<?

#
# PHP News Reader Configuration File
#
# Copyright (C) 2001-2003 - All rights reserved
# Shen Cheng-Da (cdsheen@users.sourceforge.net)

# This is a sample configuration.
# You should make a copy of this file at the directory of pnews.

# After making a copy, you can begin editing this file,

# In this configuration, you can use on as true, and off as false
# Also note that no quote is needed, for example:  $foobar = on;

define( 'on',  true,  true );
define( 'off', false, true );

# The configuration contains 3 sections:
#
#     Section 1 - Authentication
#     Section 2 - Contents
#     Section 3 - Languages

# The setting with 'REQUIRED' mark and do not come with a default value
# and should be explicitly configured

############################################################################
# Section 1 - Authentication - Configure how users login your system
############################################################################


# [auth_type] Specify the authentication type (REQUIRED)
#  "required" - authentication is required to access the while system
#  "optional" - authentication is only required for posting and forwarding
#      "open" - authentication is not needed

$CFG["auth_type"] = "open";


# [auth_prompt] Specify the style of login prompt (default: "form")
#               (used when auth_type != 'open')
#      "http" - authentication via HTTP login window    (default)
#      "form" - authentication with login form

$CFG["auth_prompt"] = "form";


# [auth_http_realm] Specify the realm used in http authentication prompt
#                   (REQUIRED if auth_prompt == 'http')

$CFG["auth_http_realm"] = "XXX";

# [auth_organization] Specify the organization of authentication source
#                     REQUIRED if auth_type != 'open'

$CFG["auth_organization"] = "XXX Club";


$CFG["auth_user_email"] = "%e";

############################################################################
# Section 2 - Contents - Configure the contents
############################################################################

# [url_base] The base url of your PHP News Reader installation (REQUIRED)

$CFG['url_base'] = 'http://StarLet.DeltaTel.RU/pnews/';


# [url_rewrite] Turn on URL rewrite (Need Apache's mod_rewrite support)
#               (default: false)

# $CFG['url_rewrite'] = true;


# [https_login] Whether to use SSL(HTTPS) after authentication (default: off)

# $CFG['https_login'] = true;


# [style_sheet] Configure the style sheet (default: "standard.css")
#               this style sheet must be reside in the css/ subdirectory.

# $CFG['style_sheet'] = "fancy.css";


# [title] The title for this webnews (default: "Webnews")

$CFG["title"] = "DeltaTelecom Inc News Service on the OpenVMS Cluster (StarLet)";


# [banner] The banner text or images, ex: "<img src=banner.jpg>" (default: "")

// $CFG["banner"] = "<img src=banner.jpg>";


# [group_list] The group definition that show on this Web News
#              You should get a copy from examples/newsgroups.lst
#              (default: "newsgroups.lst")

$CFG["group_list"] = "newsgroups.lst";


# [magic_tag] Use magic tag to indicate the unread state of newsgroup
#             (default: true)
#

// $CFG["magic_tag"] = false;


# [group_sorting] sort newsgroups in each catalog (default: off)

// $CFG["group_sorting"] = on;


# [articles_per_page] Number of articles shown in one single page (default: 20)

// $CFG['articles_per_page'] = 30;


# [article_order_reverse] reverse the order while showing articles list (default: off)

// $CFG["article_order_reverse"] = on;


# [show_article_popup] Show article in pupup window (default: off)

// $CFG["show_article_popup"] = on;


# [filter_ansi_color] Show article in pupup window (default: on)

// $CFG["filter_ansi_color"] = off;


# [time_format] The format used to displaying time (default: "%Y/%m/%d %H:%M:%S")

// $CFG["time_format"] = "%Y/%m/%d %H:%M:%S";


# [style_sheet] Alternative CSS (default: "style.css")

// $CFG["style_sheet"] = 'my_style.css';


# [language_switch] Show language switch or not (default: on)

// $CFG["language_switch"] = off;


# [organization] The organization name of this site (default: "News Server")

$CFG["organization"] = "StarLetd News Server";


# [post_signature] The signature to appended at each posted article
#                  (default: "")

$CFG["post_signature"] = "\n-- \nPOST BY: PHP News Reader powered by PHPWASD\n";


# [show_sourceforge_logo] Show SourceForge logo (default: true)

// $CFG["show_sourceforge_logo"] = false;

# [links] The links referring to other pages, (default: null)

// $CFG["links"] = array( "Back Home" => "../index.php",
//			  "Tech News" => "http://foo.bar/technews/" );


############################################################################
# Section 3 - Languages - Configure the setting about languages
############################################################################

# [language] The language setting (default: "en")
#             [config] The language setting used in this configinc.php
#           [grouplst] The language setting used in newsgroups.lst
#           [database] The language setting used in database or LDAP
#          [interface] The initial language setting of interface
#
#    Natively supported languages and the codings are:
#        "en" - Englush                    US-ASCII
#     "zh-tw" - Traditional Chinese        BIG5
#     "zh-cn" - Simplified Chinese         GB2312
#   "unicode" - Unicode (Mainly Chinese)   UTF-8    (default)

//$CFG["charset"]["config"]    = "";
//$CFG["charset"]["grouplst"]  = "US-ASCII";
//$CFG["charset"]["database"]  = "US-ASCII";
//$CFG["charset"]["interface"] = "US-ASCII";


############################################################################
# PHP News Reader
# Copyright (C) 2001-2003 - All rights reserved
# Shen Cheng-Da (cdsheen@csie.nctu.edu.tw)
############################################################################

?>
