/*  ZILLIONARE_STATS_RECORD_CLASS.HXX                                       */
/*                                                                          */
/*      Header file containing all method prototypes, etc. for              */
/*      zillionare_stats_record_class.                                      */
/*                                                                          */
/*      Part of Mega Zillionare example application.                        */
/*                                                                          */
//;;;;;
//  ANSI header files
//;;;;;
#include <string>
#include <stdlib>

//;;;;;
//  VMS header files
//;;;;;
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>

//;;;;;
//  Our header files
//;;;;;
#pragma member_alignment save
#pragma nomember_alignment
#include "zillionare_stats_record.h"     // local file generated by CDO script
#pragma member_alignment restore


class Zillionare_Stats_Record_Class
{
protected:
    char default_file_name[255];

    char    file_name[255];
    
    struct zillionare_stats_record local_rec;
    struct FAB local_fab;
    struct RAB local_rab;
    struct XABKEY local_xab;
    
public:
    //
    //  Constructor and Destructor
    //  
    Zillionare_Stats_Record_Class( char *f_name);
    ~Zillionare_Stats_Record_Class();

    //
    //  Open and close
    //  
    int open( int access = FAB$M_GET, char *f_name = NULL);

    void close( void);
    
    //
    //  Routines for record IO
    //  
    int get_via_k0( int key_val, struct zillionare_stats_record *d = NULL);
    int get_seq( struct zillionare_stats_record *d = NULL);
    int get_next_key( struct zillionare_stats_record *d = NULL);
    int get_next_key_rev( struct zillionare_stats_record *d = NULL);

    int put_record( struct zillionare_stats_record *d = NULL);
    
    //
    //  Routines to transfer record data to and from class
    //  
    void get_record_data( struct zillionare_stats_record *d);
    void set_record_data( struct zillionare_stats_record *d);

};  /* end Zillionare_Stats_Record_Class definition */
