$!  SINGLE_EXE_BUILD.COM
$!
$!  Command procedure to build the Mega_Zillionare
$!  application in the old fashioned way.  All
$!  files will be placed in the proper directories 
$!  for a production system.
$!
$!  Required parameters:
$!  P1      environment code "D01", "T01", "S01", or "P01"
$!
$ bell[0,7] = %x07
$!
$ say :== WRITE SYS$OUTPUT
$!
$!;;;;;
$!  Make sure user supplied a parameter
$!;;;;;
$ if "''p1'" .eqs. ""
$ then
$   say bell, bell, bell
$   say "you must supply P1 of D01, T01, S01, or P01
$   goto exit_program
$ endif
$!
$!;;;;;
$!  Validate the parameter
$!;;;;;
$ env_str = f$edit( "''p1'", "COLLAPSE,UPCASE")
$ if env_str .eqs. "D01" then goto good_parm
$ if env_str .eqs. "T01" then goto good_parm
$ if env_str .eqs. "S01" then goto good_parm
$ if env_str .eqs. "P01" then goto good_parm
$!
$!   Supplied parameter invalid
$!
$ say bell, bell, bell
$ SAY "you must supply P1 of D01, T01, S01, or P01
$ goto exit_program
$!
$!;;;;;
$!  Make certain we have the correct logicals
$!;;;;;
$good_parm:
$!
$ A = f$trnlnm( "MEGA_COM")
$ if "''a'" .eqs. ""
$ then
$   @dka1200:[mega_'env_str'.cms_ref]mega_environment "''env_str'"
$ else
$   @mega_com:mega_environment "''env_str'"
$ endif
$!
$ set noverify
$!;;;;;;;;;;
$!  Reconstruct CDD
$!;;;;;;;;;;
$ b = f$search( "MEGA_COM:MEGA_REBUILD_CDD.COM")
$!
$ show symbol b
$ if "''b'" .les. ""
$ then
$   @mega_src:mega_rebuild_cdd
$ else
$   @mega_com:mega_rebuild_cdd.com
$ endif
$!
$!;;;;;;;;;;
$!  Build the form library
$!;;;;;;;;;;
$!
$ fms/library/create mega_zill mega_src:zill_browse
$!
$ fms/library/insert mega_zill mega_src:zill_entry
$ fms/library/insert mega_zill mega_src:zill_entry2
$ fms/library/insert mega_zill mega_src:zill_menu
$!
$ fms/vector/output=mega_obj:mega_zill_vector mega_zill
$!
$ purge/log/keep=2 mega_zill
$!;;;;;;;;;;
$!  Build the text library
$!;;;;;;;;;;
$ library/create/text mega_text_lib
$ library/insert/text mega_text_lib mega_cms_ref:fdvdef.inc
$ library/insert/text mega_text_lib mega_cms_ref:mega_recs.inc
$!
$!;;;;;;;;;;
$!  Compile our code
$!;;;;;;;;;;
$!
$ basic/object=mega_obj: mega_src:basic_create_stats_sub
$ basic/object=mega_obj: mega_src:basic_dump_draw_data_sub
$ basic/object=mega_obj: mega_src:basic_zill_browse_sub
$ basic/object=mega_obj: mega_src:basic_zill_due_report_sub
$ basic/object=mega_obj: mega_src:basic_zill_entry_sub
$ basic/object=mega_obj: mega_src:basic_zill_import_sub
$ basic/object=mega_obj: mega_src:basic_zill_most_report_sub
$ basic/object=mega_obj: mega_src:basic_zill_menu
$!
$!;;;;;;;;;;
$!  Build the object library
$!;;;;;;;;;;
$ lib/create mega_obj_lib
$ lib/insert mega_obj_lib mega_obj:basic_create_stats_sub
$ lib/insert mega_obj_lib mega_obj:basic_dump_draw_data_sub
$ lib/insert mega_obj_lib mega_obj:basic_zill_browse_sub
$ lib/insert mega_obj_lib mega_obj:basic_zill_due_report_sub
$ lib/insert mega_obj_lib mega_obj:basic_zill_entry_sub
$ lib/insert mega_obj_lib mega_obj:basic_zill_import_sub
$ lib/insert mega_obj_lib mega_obj:basic_zill_most_report_sub
$ lib/insert mega_obj_lib mega_obj:mega_zill_vector
$!
$ purge/log/keep=2 mega_obj:
$!
$!;;;;;;;;;;
$!  Create our executables
$!;;;;;;;;;;
$!
$ link/exe=mega_exe: mega_obj:basic_zill_menu, -
     mega_obj:mega_zill_vector.obj, -
     mega_obj_lib/lib
$!
$ purge/log/keep=2 mega_exe:
$!
$!;;;;;;;;;;
$!  Move the FDL files
$!;;;;;;;;;;
$!
$ copy mega_cms_ref:*.fdl mega_dat:*.*;0
$!
$ purge/log/keep=2 mega_dat:*.fdl
$!
$!;;;;;;;;;;
$!  Move the command files
$!;;;;;;;;;;
$!
$ copy mega_cms_ref:*.com mega_com:*.*;0
$!
$ purge/log/keep=2 mega_com:*.com
$!
$exit_program:
$ exit
