1   OPTION TYPE=EXPLICIT
    !
    !   MEGA_MAIL.BAS
    !
    !   Example program showing how to send mail
    !   from inside of an application which cannot
    !   call LIB$SPAWN().
    !
    %INCLUDE "$MAILDEF" %FROM %LIBRARY
    %INCLUDE "MAIL$ROUTINES" %FROM %LIBRARY
    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY


    RECORD ITMLST
        VARIANT
        CASE
            WORD    BUFFER_LENGTH
            WORD    ITEM_CODE
            LONG    BUFFER_ADDRESS
            LONG    RETURN_LENGTH
        CASE
            LONG    TERMINATOR
        END VARIANT
    END RECORD


    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;
    MAP (MAIL_MSG_MAP)  STRING  TO_STR$ = 255%,     &
                                FROM_STR$ = 255%,   &
                                SUBJECT_STR$ = 255%,&
                                TEXT_FILE$ = 255%,  &
                                TRANSLATED_NAME$ = 255%



    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE LONG    L_STAT%, L_CONTEXT%, L_COMMA%
    DECLARE WORD    W_USER_TYPE%
    DECLARE STRING  WORK_STR$

    DECLARE ITMLST  MAIL_ITEM_1( 1% TO 5%), MAIL_ITEM_2(1% TO 5%)



    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;

100 ! Initialize the send
    !
    L_STAT% = MAIL$SEND_BEGIN( L_CONTEXT%, 0%, 0%)
    IF ( L_STAT% AND 1%) = 0%
    THEN
        PRINT "Error initializing mail interface"
        PRINT "Error code ";L_STAT%
        CALL LIB$STOP( L_STAT%)
    END IF


200 !  Build the attributes
    !  This fills in the header information for the MAIL system.
    !
    TO_STR$                         = "MEGA_SUPPORT_LIST"
    FROM_STR$                       = "HUGHES"
    SUBJECT_STR$                    = "MEGA System Notification"

    MAIL_ITEM_1(1%)::BUFFER_LENGTH  = LEN(TO_STR$)
    MAIL_ITEM_1(1%)::ITEM_CODE      = mail$_send_to_line
    MAIL_ITEM_1(1%)::BUFFER_ADDRESS = LOC(TO_STR$)
    MAIL_ITEM_1(1%)::RETURN_LENGTH  = 0%

    MAIL_ITEM_1(2%)::BUFFER_LENGTH  = LEN( TRM$( FROM_STR$))
    MAIL_ITEM_1(2%)::ITEM_CODE      = mail$_send_from_line
    MAIL_ITEM_1(2%)::BUFFER_ADDRESS = LOC(FROM_STR$)
    MAIL_ITEM_1(2%)::RETURN_LENGTH  = 0%

    MAIL_ITEM_1(3%)::BUFFER_LENGTH  = LEN( TRM$( SUBJECT_STR$))
    MAIL_ITEM_1(3%)::ITEM_CODE      = mail$_send_subject
    MAIL_ITEM_1(3%)::BUFFER_ADDRESS = LOC(SUBJECT_STR$)
    MAIL_ITEM_1(3%)::RETURN_LENGTH  = 0%
   
    MAIL_ITEM_1(4%)::TERMINATOR     = 0%

    L_STAT% = MAIL$SEND_ADD_ATTRIBUTE( L_CONTEXT%, MAIL_ITEM_1(), 0%)

    IF ( L_STAT% AND 1%) = 0%
    THEN
        PRINT "Error setting up mail header information"
        PRINT "Error code ";L_STAT%
        CALL LIB$STOP( L_STAT%)
    END IF

300 !  Add the message body.  In our case it is a text file.
    !
    TEXT_FILE$                      = "HELLO.TXT"

    MAIL_ITEM_2(1%)::BUFFER_LENGTH  = LEN(TRM$(TEXT_FILE$))
    MAIL_ITEM_2(1%)::ITEM_CODE      = mail$_send_filename
    MAIL_ITEM_2(1%)::BUFFER_ADDRESS = LOC(TEXT_FILE$)
    MAIL_ITEM_2(1%)::RETURN_LENGTH  = 0%

    ! don't fill in the terminator with this call
    !
    L_STAT% = MAIL$SEND_ADD_BODYPART( L_CONTEXT%, MAIL_ITEM_2(), 0%)

    IF ( L_STAT% AND 1%) = 0%
    THEN
        PRINT "Error creating mail message body"
        PRINT "Error code ";L_STAT%
        CALL LIB$STOP( L_STAT%)
    END IF

400 !  Now we have to actually fill in the addresses.
    !  Mail does not use the address information setup in the 
    !  message header.
    !

    WORK_STR$ = TRM$(TO_STR$)
    TRANSLATED_NAME$ = " "

    L_STAT% = LIB$GET_LOGICAL( WORK_STR$, TRANSLATED_NAME$, ,,,,)

    IF LEN(TRM$( TRANSLATED_NAME$)) < 1%
    THEN
        ! destination is not a logical value
        ! use it as is
        !
        GOSUB U20000_ADD_USER
    ELSE
        GOSUB B1000_PARSE_USER_LOGICAL
    END IF

500 !  Send the message
    !
    L_STAT% = MAIL$SEND_MESSAGE( L_CONTEXT%, 0%, 0%)
    IF ( L_STAT% AND 1%) = 0%
    THEN
        PRINT "Error sending mail message"
        PRINT "Error code ";L_STAT%
        CALL LIB$STOP( L_STAT%)
    END IF

600 !  Clean up
    !
    L_STAT% = MAIL$SEND_END( L_CONTEXT%, 0%, 0%)

    IF ( L_STAT% AND 1%) = 0%
    THEN
        PRINT "Error ending mail interface"
        PRINT "Error code ";L_STAT%
        CALL LIB$STOP( L_STAT%)
    END IF

    GOTO PROGRAM_EXIT

1000    ! Subroutine to parse the translated mail distribution logical
        ! and add the destination addresses one at a time.
        !
 B1000_PARSE_USER_LOGICAL:
        WORK_STR$ = TRM$(TRANSLATED_NAME$)

        WHILE LEN( WORK_STR$) > 0%
            L_COMMA% = INSTR( 1%, WORK_STR$, ",")
            !
            !  Last name in the list won't have a comma
            !
            IF L_COMMA% > 0%
            THEN
                TO_STR$ = LEFT$( WORK_STR$, L_COMMA%-1%)
                WORK_STR$ = RIGHT$( WORK_STR$, L_COMMA%+1%)
            ELSE
                TO_STR$ = WORK_STR$
                WORK_STR$ = ""
            END IF
            GOSUB U20000_ADD_USER
        NEXT

    RETURN

20000   ! Subroutine to add a user destination to the mail list
        !
 U20000_ADD_USER:
        MAIL_ITEM_1(1%)::BUFFER_LENGTH  = LEN(TRM$(TO_STR$))
        MAIL_ITEM_1(1%)::ITEM_CODE      = mail$_send_username
        MAIL_ITEM_1(1%)::BUFFER_ADDRESS = LOC( TO_STR$)
        MAIL_ITEM_1(1%)::RETURN_LENGTH  = 0%

        W_USER_TYPE% = mail$_to

        MAIL_ITEM_1(2%)::BUFFER_LENGTH  = 2%    ! size of a word
        MAIL_ITEM_1(2%)::ITEM_CODE      = mail$_send_username_type
        MAIL_ITEM_1(2%)::BUFFER_ADDRESS = LOC( W_USER_TYPE%)
        MAIL_ITEM_1(2%)::RETURN_LENGTH  = 0%

        MAIL_ITEM_1(3%)::TERMINATOR     = 0%

        L_STAT% = MAIL$SEND_ADD_ADDRESS( L_CONTEXT%, MAIL_ITEM_1(), 0%)

        IF ( L_STAT% AND 1%) = 0%
        THEN
            PRINT "Error adding destination address"
            PRINT "Error code ";L_STAT%
            CALL LIB$STOP( L_STAT%)
        END IF

    RETURN


 PROGRAM_EXIT:
32767   END
