        SUBROUTINE FTN_ZILL_IMPORT_SUB
        IMPLICIT NONE

C
C       Subroutine to import a flat text file
C       of comma seperated values in the form of:
C    
C       draw_dt, no_1, no_2, no_3, no_4, no_5, mega_no
C    
C       creating a shiny new indexed file.
C


        INCLUDE 'MEGA_TEXT_LIB (FTN_MEGA_RECS)'


C;;;;;
C       Constants we need
C;;;;;
	INTEGER*1   K_DRAW_CHAN, K_INPUT_CHAN, K_ELM_COUNT
        PARAMETER( K_DRAW_CHAN=6, K_INPUT_CHAN=5, K_ELM_COUNT=52)

        CHARACTER*12    DRAWING_DATA
        PARAMETER( DRAWING_DATA='MY_MEGA_FILE')

C;;;;;
C	Local variables
C;;;;;
        INTEGER*2   W_MM, W_DD, W_X
        INTEGER*4   L_X, L_ERR, L_REC_COUNT, L_DRAW_ERR
        INTEGER*4   L_YYYY, L_IO_STAT

	CHARACTER*65    IN_FILE_STR
	CHARACTER*10    DATE_STR, WORK_STR
	CHARACTER*80    LINE_IN_STR, WORK_LINE_STR

	RECORD      /DRAWING_RECORD/DRAW_REC

C;;;;;;;;;;
C	Main Logic
C;;;;;;;;;;

 100    CALL FTN_FILL_IN_LOGICALS

	PRINT *, 'Name of Input File :'
	READ (*,'(A)') IN_FILE_STR

 200	OPEN (UNIT=K_INPUT_CHAN, STATUS='OLD',
     1           READONLY, FILE=IN_FILE_STR)

 210	OPEN (UNIT=K_DRAW_CHAN, 
     1        FILE=DRAWING_DATA,
     2        STATUS='OLD',
     3        ORGANIZATION='INDEXED',
     4        ACCESS='KEYED',
     5        RECORDTYPE='FIXED',
     6        FORM='UNFORMATTED',
     7        RECL=K_DRAWING_RECORD_SIZE/4,
     8        CARRIAGECONTROL='FORTRAN',
     9        KEY=(1:8:CHARACTER),
     1        DISP='KEEP',
     2        IOSTAT=L_DRAW_ERR,
     3        ERR=999)

	L_REC_COUNT = 0

	L_ERR = 0

	DO 300 WHILE (L_ERR .EQ. 0)

C
C	    Read an input record
C
	    READ (K_INPUT_CHAN,'(A)',ERR=400,IOSTAT=L_ERR) 
     1           LINE_IN_STR

C
C	    Seg out the date
C
	    W_X = INDEX( LINE_IN_STR, ',')
	    DATE_STR = LINE_IN_STR(1:W_X-1)
	    WORK_LINE_STR = LINE_IN_STR(W_X+1:)

	    W_X = INDEX( WORK_LINE_STR, ' ')

	    READ( WORK_LINE_STR(1:W_X-1), 220, IOSTAT=L_X)
     1           DRAW_REC.NO_1,
     2           DRAW_REC.NO_2,
     3           DRAW_REC.NO_3,
     4           DRAW_REC.NO_4,
     5           DRAW_REC.NO_5,
     6           DRAW_REC.MEGA_NO

 220	    FORMAT (I,I,I,I,I,I)


C
C	Put the date in a zero filled format like
C	we did with our BASIC program
C
	W_X = INDEX( DATE_STR, '/')
	DATE_STR(W_X:) = ','//DATE_STR(W_X+1:)
	W_X = INDEX( DATE_STR, '/')
	DATE_STR(W_X:) = ','//DATE_STR(W_X+1:)

	READ( DATE_STR, '(I,I,I4)') W_MM, W_DD, L_YYYY

	WRITE (DRAW_REC.DRAW_DT, '(I4.4,I2.2,I2.2)')
     1   L_YYYY, W_MM, W_DD

	WRITE (K_DRAW_CHAN) DRAW_REC
	L_REC_COUNT = L_REC_COUNT + 1

	L_X = MOD( L_REC_COUNT, 100)
	IF (L_X .EQ. 0) THEN
	    PRINT *,L_REC_COUNT, ' Records Processed'
	END IF

 300	CONTINUE

 400	PRINT *, L_REC_COUNT, ' Records Loaded'

	CLOSE (K_DRAW_CHAN, STATUS='KEEP')
	CLOSE (K_INPUT_CHAN, STATUS='KEEP')

	GO TO 3276

 999	PRINT *, 'Error ', L_DRAW_ERR, ' opening drawing_stats'

 3276	RETURN
	END
