        SUBROUTINE FTN_SQLM_ZILL_IMPORT_SUB
        IMPLICIT NONE

!
!       Subroutine to import a flat text file
!       of comma seperated values in the form of:
!    
!       draw_dt, no_1, no_2, no_3, no_4, no_5, mega_no
!    
!       creating a shiny new set of rows in RDB table.
!

!;;;;;
!       Constants we need
!;;;;;
	INTEGER*1   K_INPUT_CHAN
        PARAMETER( K_INPUT_CHAN=5)

        CHARACTER*3 MONTH_TEXT(12)
        DATA MONTH_TEXT(1)/'JAN'/,MONTH_TEXT(2)/'FEB'/
        DATA MONTH_TEXT(3)/'MAR'/,MONTH_TEXT(4)/'APR'/
        DATA MONTH_TEXT(5)/'MAY'/,MONTH_TEXT(6)/'JUN'/
        DATA MONTH_TEXT(7)/'JUL'/,MONTH_TEXT(8)/'AUG'/
        DATA MONTH_TEXT(9)/'SEP'/,MONTH_TEXT(10)/'OCT'/
        DATA MONTH_TEXT(11)/'NOV'/,MONTH_TEXT(12)/'DEC'/
!;;;;;
!	Local variables
!;;;;;
        INTEGER*1   NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        INTEGER*2   W_MM, W_DD, W_X
        INTEGER*4   L_X, L_ERR, L_REC_COUNT, L_DRAW_ERR
        INTEGER*4   L_YYYY, L_IO_STAT, SQLCODE
        INTEGER*8   DRAW_DT_QUAD

	CHARACTER*65    IN_FILE_STR
	CHARACTER*10    DATE_STR, WORK_STR
	CHARACTER*80    LINE_IN_STR, WORK_LINE_STR
        CHARACTER*11    DRAW_DT

!;;;;;;;;;;
!	Main Logic
!;;;;;;;;;;
 100    PRINT *, 'Name of Input File :'
	READ (*,'(A)') IN_FILE_STR

 200	OPEN (UNIT=K_INPUT_CHAN, STATUS='OLD', READONLY, FILE=IN_FILE_STR)

	L_REC_COUNT = 0

	L_ERR = 0
!
!       Call SQLMOD function to delete all rows from existing table.
!
        CALL DELETE_ALL_DRAW_RECS( SQLCODE);

	DO 300 WHILE (L_ERR .EQ. 0)
!
!	    Read an input record
!
	    READ (K_INPUT_CHAN,'(A)',ERR=400,IOSTAT=L_ERR) LINE_IN_STR

            !
            ! L_ERR gets turned on when we have read past the last record
            ! but the error branch doesn't occur.
            ! Put a branch out of loop here.
            ! Yes, people don't like go to statements, but it is cleaner than
            ! nesting all of this stuff inside an IF.
            !
            IF (L_ERR .NE. 0) THEN
                GO TO 400
            END IF
!
!	    Seg out the date
!
	    W_X = INDEX( LINE_IN_STR, ',')
	    DATE_STR = LINE_IN_STR(1:W_X-1)
	    WORK_LINE_STR = LINE_IN_STR(W_X+1:)

	    W_X = INDEX( WORK_LINE_STR, ' ')

	    READ( WORK_LINE_STR(1:W_X-1), 220, IOSTAT=L_X) &
                 NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO

 220	    FORMAT (I,I,I,I,I,I)
!
!	Put the date in a zero filled format like
!	we did with our BASIC program
!
	W_X = INDEX( DATE_STR, '/')
	DATE_STR(W_X:) = ','//DATE_STR(W_X+1:)
	W_X = INDEX( DATE_STR, '/')
	DATE_STR(W_X:) = ','//DATE_STR(W_X+1:)

	READ( DATE_STR, '(I,I,I4)') W_MM, W_DD, L_YYYY

	WRITE (DRAW_DT, 226) W_DD, MONTH_TEXT( W_MM), L_YYYY
 226    FORMAT (I2.2,'-',A,'-',I4)
!
!       Let the operating system create a quad for us.
!
        CALL LIB$CONVERT_DATE_STRING( DRAW_DT, DRAW_DT_QUAD)
!
!       Call SQLMOD function to write a record
!
        SQLCODE = 0
        CALL INSERT_DRAW_REC( SQLCODE, DRAW_DT_QUAD, NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO)
        IF (SQLCODE .NE. 0) THEN
            PRINT *,'Result of inserting row ', SQLCODE
            PRINT *,'Row was: ', LINE_IN_STR
        END IF

	L_REC_COUNT = L_REC_COUNT + 1

	L_X = MOD( L_REC_COUNT, 100)
	IF (L_X .EQ. 0) THEN
	    PRINT *,L_REC_COUNT, ' Records Processed'
            CALL COMMIT_MEGA( SQLCODE)
	END IF

 300	CONTINUE

 400	PRINT *, L_REC_COUNT, ' Records Loaded'

        CALL COMMIT_MEGA( SQLCODE)

	CLOSE (K_INPUT_CHAN, STATUS='KEEP')

	GO TO 3276

 999	PRINT *, 'Error ', L_DRAW_ERR, ' opening drawing_stats'

 3276	RETURN
	END
