        SUBROUTINE FTN_SQLM_ZILL_DUE_REPORT_SUB
        IMPLICIT NONE

    !
    !   Create a report of numbers which are DUE
    !   Both regular drawing numbers and MEGA numbers will be included
    !
	INCLUDE '(LIB$ROUTINES)'
	INCLUDE '($FORIOSDEF)'

!;;;;;
!       Constants we need
!;;;;;
	INTEGER*1   K_RPT_CHAN
        PARAMETER( K_RPT_CHAN=11)

        CHARACTER*12  RPT_FILE
        PARAMETER( RPT_FILE='ZILL_DUE.RPT')

	REAL    ONE_SECOND
	PARAMETER( ONE_SECOND=1.0)

!;;;;;
!	Local variables
!;;;;;
	INTEGER*4   L_D_STAT, L_M_STAT, SQLCODE
        INTEGER*1   B_SUB, B_LOC_COUNT, B_DONE, B_END, B_X, ELM_NO
        INTEGER*4   HIT_COUNT, LAST_DRAW_NO, SINCE_LAST, CURR_SEQ, LONGEST_SEQ, MAX_BTWN
        REAL*8      PCT_HITS, AVE_BTWN
	CHARACTER*8 DATE_STR

	CHARACTER*255 COMMAND_STR

!;;;;;;;;;;
!	Main Logic
!;;;;;;;;;;
 105	OPEN (UNIT=K_RPT_CHAN, STATUS='NEW', &
              FILE=RPT_FILE, DISP='KEEP',FORM='FORMATTED', RECL=80, CARRIAGECONTROL='LIST')

!;;;;;;;;;;
!	Generate the report.
!;;;;;;;;;;

        CALL OPEN_DUE_DRAW( SQLCODE)
        CALL OPEN_DUE_MEGA( SQLCODE)

	!
	! Page title
	!
 300	CALL DATE_AND_TIME( DATE_STR)


	WRITE (UNIT=K_RPT_CHAN, FMT=302) DATE_STR(5:6), DATE_STR(7:8), DATE_STR(1:4), 1

 302    FORMAT ('DATE: ',A2,'/',A2,'/',A4, T31, 'Due Numbers Report', T71, 'Page: ', I3)

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

	WRITE (UNIT=K_RPT_CHAN, FMT='(T29, A)') 'Regular Drawing Numbers'
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

!
!	Column headings
!
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') 'No   Hits   Since   Pct_hits   Ave_btwn'

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') '--   ----   -----   --------   --------'

	DO 312, WHILE (SQLCODE .EQ. 0)
            CALL FETCH_DUE_DRAW( SQLCODE, ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN)
            IF (SQLCODE .EQ. 0) THEN
                WRITE (UNIT=K_RPT_CHAN, FMT=306) ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN
            END IF

 306	    FORMAT (I2,3X,I4,3X,I4,5X,F7.3,4X,F7.3)

 312	CONTINUE

        CALL CLOSE_DUE_DRAW( SQLCODE)

	!
	!   Second page for Mega numbers
	!
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') CHAR( 12)

	WRITE (UNIT=K_RPT_CHAN, FMT=302) DATE_STR(5:6), DATE_STR(7:8), DATE_STR(1:4), 2

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

	WRITE (UNIT=K_RPT_CHAN, FMT='(T34, A)') 'Mega Numbers'
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') ' '

!
!	Column headings
!
	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') 'No   Hits   Since   Pct_hits   Ave_btwn'

	WRITE (UNIT=K_RPT_CHAN, FMT='(A)') '--   ----   -----   --------   --------'


	DO 349, WHILE (SQLCODE .EQ. 0)
            CALL FETCH_DUE_MEGA( SQLCODE, ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN)
            IF (SQLCODE .EQ. 0) THEN
                WRITE (UNIT=K_RPT_CHAN, FMT=306) ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN
            END IF
 349	CONTINUE

	GO TO 1000

 1000   CALL CLOSE_DUE_MEGA( SQLCODE)
        CALL COMMIT_MEGA( SQLCODE)
	CLOSE( K_RPT_CHAN)

	COMMAND_STR = 'EDIT/READ '//RPT_FILE
	CALL LIB$SPAWN( COMMAND_STR,,0)
	RETURN
	END

