/*  FMS_PROTOTYPES.H
 *
 *  Copyright (c) 2005 Logikal Solutions
 *
 *  This file is for use only by persons directly owning a legally purchased 
 *  copy of 
 *  "The Minimum You Know to be an OpenVMS Application Developer".  It is
 *  not to be distributed in whole or in part, or posted anywhere on the web.
 *
 *  The prototypes declared here come with no warranty expressed or implied.
 *  Those calls which were used in the example programs work as they were used
 *  in those example programs.  The others have been cobbled together from
 *  aging memory and even more aging documentation.
 *
 *  Header file containing C language prototypes for FMS calls.
 *
 *  C doesn't give us an optional keyword for prototyping.
 *  In order to make this header clean and not invoke __va_list style
 *  calling I will use the "..." varying argument prototype, then document
 *  the type and order of the optional parameters.
 */

#include <descrip>
#include <fdvdef>

/*
 *  The descrip.h header file only provides us with one macro for creating
 *  descriptors on the file.  This macro creates only string descriptors.
 *  In order to make life more livable, we need a macro to create array
 *  descriptors.  We will steal a macro I've seen many times at various
 *  locations.  
 *
 *  BE WARNED!  This macro only works for integer arrays!  Note the 
 *  type of DSC$K_DTYPE_L.  If you want to make a generic array descriptor
 *  macro, you need 2 additional parameters.  The first is the C data type
 *  and the second is the DSC$K_DTYPE_x constant to use.  You would put 
 *  your value for "c_data_type" inside the sizeof() call and your 
 *  DTYPE_X value in place of DSC$K_DTYPE_L.
 */

#define $DESCRIPTORA(name,array)   struct dsc$descriptor_a \
name = { sizeof (long), DSC$K_DTYPE_L, \
DSC$K_CLASS_A, array, 0, 0, { 0, 0, 0, 0, 0 }, 1, sizeof array }


#pragma message disable( ELLIPSEARG, DOLLARID)

/*;;;;;;;;;;
 *  Defined as functions in FMS
 *;;;;;;;;;;
 */
int fdv$adlva( int *video_attribute);

int fdv$afcx( int *ins_overstrike, int *cursor_pos, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *field_name_str
//      int *field_index


int fdv$afva( int *video_attribute, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *field_name_str
//      int *field_index



/*;;;;;;;;;;
 *  Defined as callable subroutines in FMS
 *  As we have seen in FORTRAN, they can be declared as 
 *  functions which return FMS$STATUS.
 *;;;;;;;;;;
 */
int fdv$aterm( struct dsc$descriptor_a *tca_array,
               int *size,
               int *channel, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *term_name
//      struct dsc$descriptor_s *batch_term_name
//      int *options


int fdv$awksp( struct dsc$descriptor_a *workspace_array,
               int *size);


int fdv$bell( void);

int fdv$cancl( void);

int fdv$cdisp( struct dsc$descriptor_s *form_name_str, ...);
//
//  trailing optional parameters
//      int *offset

int fdv$clear( ...);
//
//  trailing optional parameters
//      int *line
//      int *line_count


int fdv$clear_va( void);

int fdv$del( struct dsc$descriptor_a *form_name_str);

int fdv$dfkbd( struct dsc$descriptor_a *word_key_array,
               int *elm_count);

int fdv$disp( struct dsc$descriptor_s *form_name_str, ...);
//
//  trailing optional parameters
//      int *offset

int fdv$dispw( ...);
//
//  trailing optional parameters
//      int *offset


int fdv$dpcom( ...);
//
//  trailing optional parameters
//      int *decimal_point_mode

int fdv$dwksp( struct dsc$descriptor_a *workspace_array);

int fdv$fchan( int *channel);

int fdv$fix_screen( void);

int fdv$get( struct dsc$descriptor_s *text_destination,
             int *terminator_destination,
             struct dsc$descriptor_s *field_name, ...);
//
//  trailing optional parameter
//      int *field_index

int fdv$getaf( struct dsc$descriptor_s *text_destination,
               int *terminator_destination,
               struct dsc$descriptor_s *end_field_name, ...);
//
//  trailing optional parameter
//      int *end_field_index

int fdv$getal( ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *text_destination,
//      int *terminator_destination,
//      struct dsc$descriptor_s *start_field_name,
//      int *start_index

int fdv$getdl( struct dsc$descriptor_s *text_destination,
               int *terminator_destination, ...);
//
//  trailing optional parameters
//      int *line
//      struct dsc$descriptor_s *prompt_text

int fdv$getsc( struct dsc$descriptor_s *field_name_str,
               struct dsc$descriptor_s *fld_value_dest, ...);
//
//  trailing optional parameters
//      int *terminator_dest

int fdv$iltrm( int *terminator_mode);

int fdv$lchan( int *channel);

int fdv$lclos( void );

int fdv$ledof( int *led_number);

int fdv$ledon( int *led_number);

int fdv$load( struct dsc$descriptor_s *form_name_str);

int fdv$lopen( struct dsc$descriptor_s *form_library_name, ...);
//
//  trailing optional parameters
//      int *channel

int fdv$ndisp( void);

int fdv$pft( ...);
//
//  trailing optional parameters
//      int *field_terminator
//      struct dsc$descriptor_s *field_name_str
//      struct dsc$descriptor_s *field_value_str
//      struct dsc$descriptor_s *current_field_name_dest
//      int *current_field_index_dest

int fdv$print_screen( int *output_type, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *file_name_str

int fdv$put( struct dsc$descriptor_s *field_value_str,
             struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      int *field_index

int fdv$putal( ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *form_values_str

int fdv$putd( struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      int *field_index

int fdv$putda( void);

int fdv$putl( struct dsc$descriptor_s *test_line_str, ...);
//
//  trailing optional parameters
//      int *line

int fdv$putsc( struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *field_value_str

int fdv$read( struct dsc$descriptor_s *form_name_str,
              void *buffer_address,
              int *buffer_size,
              int *form_size_dest);

int fdv$ret( struct dsc$descriptor_s *field_value_dest,
             struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      int *field_index

int fdv$retcx( int *tca_address_dest,
               int *workspace_address_dest,
               struct dsc$descriptor_s *form_name_dest,
               struct dsc$descriptor_s *url_value_dest,
               int *cursor_pos_dest,
               int *terminator_dest,
               int *ins_overstrike_dest,
               int *help_num_dest);

int fdv$retdi( int *named_data_index,
               struct dsc$descriptor_s *named_data_text_dest,...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *named_data_name_dest)

int fdv$retdn( struct dsc$descriptor_s *named_data_name_str,
               struct dsc$descriptor_s *named_data_text_dest,...);
//
//  trailing optional parameters
//      int *named_data_index_dest

int fdv$retfl( int *line_number,
               struct dsc$descriptor_s *text_value_dest,
               int *line_length_dest, ...);
//
//  trailing optional parameters
//      int *type_of_line_in

int fdv$retfn( struct dsc$descriptor_s *field_name_str,...);
//
//  trailing optional parameters
//      int *field_index_dest

int fdv$retfo( int *field_number,
               struct dsc$descriptor_s *field_name_dest,
               int *field_index_dest);

int fdv$retle( int *field_length_dest,
               struct dsc$descriptor_s *field_name_dest,
               int *field_index_dest);

int fdv$rfrsh( void);

int fdv$scr_length( int *screen_length);

int fdv$sigop( void);

int fdv$spada( int *numeric_or_app_flag);

int fdv$spoff( void);

int fdv$ssigq( int *signal_mode);

int fdv$ssrv( int *fms_status_dest, ...);
//
//  trailing optional parameter
//      int *rms_status_dest

int fdv$stat( int *fms_status_dest, ...);
//
//  trailing optional parameter
//      int *rms_status_dest

int fdv$sterm( struct dsc$descriptor_a *tca_array);

int fdv$stime( int *time_out_value);

int fdv$swksp( struct dsc$descriptor_a *workspace_array);

int fdv$tchan( int *channel);

int fdv$dterm( struct dsc$descriptor_a *tca_array);

int fdv$user_refresh( ...);
//
//  trailing optional parameters
//      void *refresh_routine

int fdv$wait( ...);
//
//  trailing optional parameters
//      int *terminator_dest

#pragma message enable( ELLIPSEARG, DOLLARID)


