/* FDVDEF.H
 * Include file for FDV symbols
 */
/*
		      COPYRIGHT (c) 1982, 1983 BY
	      DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.

 THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED
 ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE
 INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER
 COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY
 OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY
 TRANSFERRED.

 THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE
 AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT
 CORPORATION.

 DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS
 SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.
*/

/* Author: S.P.Simon */

/* Modification History:
   -002, 14-Mar-1986, James T. McCartney III.
	Added additional procedures and status return values for FMS V2.3

*/

/*************************/
/* FMS terminator codes: */
/*************************/
#define FDV$K_FT_NTR       0  /*Enter (i.e. end GETs)*/
#define FDV$K_FT_NXT       1  /*Next field */
#define FDV$K_FT_PRV       2  /*Previous field */
#define FDV$K_FT_ATB       3  /*Automatically move to next field*/
#define FDV$K_FT_XBK       4  /*Exit scrolled area backward*/
#define FDV$K_FT_XFW       5  /*Exit scrolled area forward*/
#define FDV$K_FT_SNX       6  /*Scroll forward to next field */
#define FDV$K_FT_SPR       7  /*Scroll backward to previous field*/
#define FDV$K_FT_SFW       8  /*Scroll forward*/
#define FDV$K_FT_SBK       9  /*Scroll backward*/
#define FDV$K_FT_ILG_NXT  11  /*Illegal context for next field */
#define FDV$K_FT_ILG_PRV  12  /*Illegal context for previous field */
#define FDV$K_FT_ILG_ATB  13  /*Illegal context for auto move to next field*/
#define FDV$K_FT_ILG_XBK  14  /*Illegal context for exit scrolled area backward*/
#define FDV$K_FT_ILG_XFW  15  /*Illegal context for exit scrolled area forward*/
#define FDV$K_FT_ILG_SFW  16  /*Illegal context for scroll forward*/
#define FDV$K_FT_ILG_SBK  17  /*Illegal context for scroll backward*/
/********************************************************/
/* Function key terminators returned from GETs and WAIT */
/* Also used as FDV keycodes for use with DFKBD.  */
/********************************************************/
#define FDV$K_AR_UP        99 
#define FDV$K_AR_DOWN     100 
#define FDV$K_AR_RIGHT    101 
#define FDV$K_AR_LEFT     102 
#define FDV$K_PF_1        103 
#define FDV$K_PF_2        104 
#define FDV$K_PF_3        105 
#define FDV$K_PF_4        106 
#define FDV$K_KP_NTR      107 
#define FDV$K_KP_COM      108 
#define FDV$K_KP_HYP      109 
#define FDV$K_KP_PER      110 
#define FDV$K_KP_0        112 
#define FDV$K_KP_1        113 
#define FDV$K_KP_2        114 
#define FDV$K_KP_3        115 
#define FDV$K_KP_4        116 
#define FDV$K_KP_5        117 
#define FDV$K_KP_6        118 
#define FDV$K_KP_7        119 
#define FDV$K_KP_8        120 
#define FDV$K_KP_9        121 
#define FDV$K_GAR_UP      227 
#define FDV$K_GAR_DOWN    228 
#define FDV$K_GAR_RIGHT   229 
#define FDV$K_GAR_LEFT    230 
#define FDV$K_GPF_1       231 
#define FDV$K_GPF_2       232 
#define FDV$K_GPF_3       233 
#define FDV$K_GPF_4       234 
#define FDV$K_GKP_NTR     235 
#define FDV$K_GKP_COM     236 
#define FDV$K_GKP_HYP     237 
#define FDV$K_GKP_PER     238 
#define FDV$K_GKP_0       240 
#define FDV$K_GKP_1       241 
#define FDV$K_GKP_2       242 
#define FDV$K_GKP_3       243 
#define FDV$K_GKP_4       244 
#define FDV$K_GKP_5       245 
#define FDV$K_GKP_6       246 
#define FDV$K_GKP_7       247 
#define FDV$K_GKP_8       248 
#define FDV$K_GKP_9       249 
#define FDV$K_FK_E1        33
#define FDV$K_FK_E2        34
#define FDV$K_FK_E3        35
#define FDV$K_FK_E4        36
#define FDV$K_FK_E5        37
#define FDV$K_FK_E6        38
#define FDV$K_GFK_E1      161
#define FDV$K_GFK_E2      162
#define FDV$K_GFK_E3      163
#define FDV$K_GFK_E4      164
#define FDV$K_GFK_E5      165
#define FDV$K_GFK_E6      166
#define FDV$K_FK_F6        49
#define FDV$K_FK_F7        50
#define FDV$K_FK_F8        51
#define FDV$K_FK_F9        52
#define FDV$K_FK_F10       53
#define FDV$K_FK_F11       55
#define FDV$K_FK_F12       56
#define FDV$K_FK_F13       57
#define FDV$K_FK_F14       58
#define FDV$K_FK_HELP      60
#define FDV$K_FK_DO        61
#define FDV$K_FK_F17       63
#define FDV$K_FK_F18       64
#define FDV$K_FK_F19       65
#define FDV$K_FK_F20       66
#define FDV$K_GFK_F6      177
#define FDV$K_GFK_F7      178
#define FDV$K_GFK_F8      179
#define FDV$K_GFK_F9      180
#define FDV$K_GFK_F10     181
#define FDV$K_GFK_F11     183
#define FDV$K_GFK_F12     184
#define FDV$K_GFK_F13     185
#define FDV$K_GFK_F14     186
#define FDV$K_GFK_HELP    188
#define FDV$K_GFK_DO      189
#define FDV$K_GFK_F17     191
#define FDV$K_GFK_F18     192
#define FDV$K_GFK_F19     193
#define FDV$K_GFK_F20     194
/********************************************/
/* FDV keyfunctions. For use in DFKBD call. */
/********************************************/
#define FDV$K_KF_DLCHR    1 
#define FDV$K_KF_CRSRT    2 
#define FDV$K_KF_CRSLF    3 
#define FDV$K_KF_DLFLD    4 
#define FDV$K_KF_INS      5 
#define FDV$K_KF_OVR      6 
#define FDV$K_KF_GOLD     7
#define FDV$K_KF_RESET    8 
#define FDV$K_KF_RFRSH    9 
#define FDV$K_KF_HELP    10 
#define FDV$K_KF_NXT     11 
#define FDV$K_KF_PRV     12 
#define FDV$K_KF_NTR     13 
#define FDV$K_KF_SBK     14 
#define FDV$K_KF_SFW     15 
#define FDV$K_KF_XBK     16 
#define FDV$K_KF_XFW     17 
#define FDV$K_KF_NONE     0 
#define FDV$K_KF_DFLT   (-1) 
/*************************************************************/
/* UAR return codes. These codes are returned  UAR to FDV. */
/*************************************************************/
/* Field completion return codes */
/*********************************/
#define FDV$K_UVAL_SUC       1000 	/*Field completion success 	*/
#define FDV$K_UVAL_FAIL      1001 	/*Field completion failure	*/
#define FDV$K_UVAL_END	     1002 	/*Field completion suc-stop UARs*/
/*************************/
/* Help UAR return codes */
/*************************/
#define FDV$K_UHELP_NO       2000 	/*No help given, try next step	*/
#define FDV$K_UHELPED        2001 	/*Help given, continue sequence	*/
#define FDV$K_UHELP_ALL      2002 	/*Help given, repeat UAR	*/
/*********************************/
/* Function Key UAR return codes */
/*********************************/
#define FDV$K_UKEY_ERR       3000 	/*Fn Key failure, FDV signals	*/
#define FDV$K_UKEY_TRM       3001 	/*Fn Key success, normal f.k.	*/
#define FDV$K_UKEY_NXT       3002 	/*Fn Key succ, treat as NEXT	*/
#define FDV$K_UKEY_NTR       3003 	/*Fn Key succ, treat as ENTER	*/
#define FDV$K_UKEY_SUC       3004 	/*Fn Key succ, ignore		*/

/****************************************************************************/
/* FDV status codes returned when FDV$... routines are called as functions. */
/* These codes are VMS status codes and can be signalled.  They correspond  */
/* one-to-one with the FMS status codes retrievable from FDV$STAT. 	    */
/****************************************************************************/
#define FDV$_SUC 2719889
#define FDV$_INC 2719897
#define FDV$_MOD 2719905
#define FDV$_IMP 2719922
#define FDV$_FSP 2719930
#define FDV$_IOL 2719938
#define FDV$_FLB 2719946
#define FDV$_ICH 2719954
#define FDV$_FCH 2719962
#define FDV$_FRM 2719970
#define FDV$_FNM 2719978
#define FDV$_LIN 2719986
#define FDV$_FLD 2719994
#define FDV$_NOF 2720002
#define FDV$_DSP 2720010
#define FDV$_NSC 2720018
#define FDV$_DNM 2720026
#define FDV$_DLN 2720034
#define FDV$_UTR 2720042
#define FDV$_IOR 2720050
#define FDV$_IFN 2720058
#define FDV$_ARG 2720066
#define FDV$_INI 2720074
#define FDV$_STR 2720082
#define FDV$_IVM 2720090
#define FDV$_FVM 2720098
#define FDV$_ITT 2720106
#define FDV$_TCA 2720114
#define FDV$_STA 2720122
#define FDV$_WID 2720130
#define FDV$_NFL 2720138
#define FDV$_IBF 2720146
#define FDV$_NDS 2720154
#define FDV$_UDP 2720162
#define FDV$_UAR 2720170
#define FDV$_UNF 2720178
#define FDV$_CAN 2720194
#define FDV$_KIF 2720202
#define FDV$_KEX 2720210
#define FDV$_KTW 2720218
#define FDV$_KIL 2720226
#define FDV$_TMO 2720234
#define FDV$_LLI 2720242
#define FDV$_VAL 2720250
#define FDV$_IFU 2720258
#define FDV$_SYS 2720266
#define FDV$_INA 2720274
#define FDV$_IOO 2720282

/****************************************************************************/
/* FMS status codes returned when FDV$STAT routine is called.		    */
/****************************************************************************/
/* Success codes. */

#define FDV$K_SUC 	1 
#define FDV$K_INC 	2 
#define FDV$K_MOD 	3 	

/* Failure code */

#define FDV$K_IMP	(-2) 
#define FDV$K_FSP 	(-3)
#define FDV$K_IOL 	(-4)
#define FDV$K_FLB 	(-5) 
#define FDV$K_ICH 	(-6) 
#define FDV$K_FCH 	(-7) 
#define FDV$K_FRM 	(-8) 
#define FDV$K_FNM 	(-9) 
#define FDV$K_LIN 	(-10) 
#define FDV$K_FLD 	(-11) 
#define FDV$K_NOF 	(-12) 
#define FDV$K_DSP 	(-13) 
#define FDV$K_NSC 	(-14) 
#define FDV$K_DNM 	(-15) 
#define FDV$K_DLN 	(-16) 
#define FDV$K_UTR 	(-17) 
#define FDV$K_IOR 	(-18) 
#define FDV$K_IFN 	(-19) 
#define FDV$K_ARG 	(-20) 
#define FDV$K_INI 	(-21) 
#define FDV$K_STR 	(-22) 
#define FDV$K_FVM 	(-23) 
#define FDV$K_IVM 	(-24) 
#define FDV$K_ITT 	(-25) 
#define FDV$K_TCA 	(-26) 
#define FDV$K_STA 	(-27) 
#define FDV$K_WID 	(-28) 
#define FDV$K_NFL 	(-29) 
#define FDV$K_IBF 	(-30) 
#define FDV$K_NDS 	(-31) 
#define FDV$K_UDP 	(-33) 
#define FDV$K_UAR 	(-34) 
#define FDV$K_UNF 	(-35) 	
#define FDV$K_CAN 	(-39) 
#define FDV$K_KIF 	(-40) 
#define FDV$K_KEX 	(-41) 
#define FDV$K_KTW 	(-42) 
#define FDV$K_KIL 	(-43) 
#define FDV$K_TMO 	(-44) 
#define FDV$K_LLI 	(-45) 
#define FDV$K_VAL 	(-47) 
#define FDV$K_IFU 	(-48) 
#define FDV$K_SYS 	(-49) 	
#define FDV$K_INA 	(-50) 	
#define FDV$K_IOO 	(-51) 	
