$!  EDT_CMS_MASS_SUB.COM
$!
$!  Command file to perform a mass substitution on one or
$!  more files currently residing in a CMS library.
$!
$!  Prompts user for cms library, reference directory,
$!  file list, fetch comment, replace comment, text to find,
$!  and text to replace.
$!
$!  This command file takes a brute force approach.  One at a time
$!  it reserves every file in the list, performs a substitution via
$!  EDT, then puts the file back into CMS.
$!
$!  A temporary ini file is created which contains all of the 
$!  commands EDT needs to process the file.
$!
$ say :== write sys$output
$ bell[0,7] == %x07
$!
$  say "   This command file will perform a mass substitution on "
$  say "all files matching the list provided found in the CMS"
$  say "reference area.  You will be prompted for all values"
$  say "that are needed."
$  say " "
$  say "A brute force approach is taken.  Every matching file is"
$  say "reserved, regardless whether it is a text file or not"
$  say "so don't simply pass in *.* as the file list unless you"
$  say "really mean it."
$  say " "
$!
$!;;;;;;;;;;
$!      Obtain a value to define CMS$LIB with
$!;;;;;;;;;;
$ cms_library = " "
$!
$cms_lib_top:
$!
$   say " "
$   say " "
$   inquire cms_library "Please enter a value to define CMS$LIB with: "
$!
$   cms_library = f$edit( "''cms_library'", "COMPRESS")
$!
$ if "''cms_library'" .les. " " then goto cms_lib_top
$!
$!;;;;;;;;;;
$!      Now we need the reference directory
$!;;;;;;;;;;
$ cms_reference_dir = " "
$!
$cms_reference_top:
$!
$   say " "
$   say " "
$   inquire cms_reference_dir "Reference directory: "
$!
$   cms_reference_dir = f$edit("''cms_reference_dir'", "COMPRESS")
$!
$ if "''cms_reference_dir'" .les. " " then goto cms_reference_top
$!
$!;;;;;;;;;;
$!      list of files to process
$!;;;;;;;;;;
$ file_list = " "
$!
$file_list_top:
$!
$   say " "
$   say " "
$   inquire file_list "Files to pull from CMS: "
$!
$   file_list = f$edit( "''file_list'", "COMPRESS")
$!
$ if "''file_list'" .les. " " then goto file_list_top
$!
$!
$!;;;;;;;;;;
$!      Comment to put on reservations
$!;;;;;;;;;;
$ reserve_comment = " "
$!
$reserve_comment_top:
$!
$   say " "
$   say " "
$   inquire reserve_comment "Remark to put on reservation: "
$!
$   reserve_comment = f$edit( "''reserve_comment'", "TRIM")
$!
$ if "''reserve_comment'" .les. " " then goto reserve_comment_top
$!
$!
$!;;;;;;;;;;
$!      Comment to put on replace statements
$!;;;;;;;;;;
$!
$ replace_comment = " "
$!
$replace_comment_top:
$!
$   say " "
$   say " "
$   inquire replace_comment "Remark to put on replacements: "
$!
$   replace_comment = f$edit( "''replace_comment'", "TRIM")
$!
$ if "''replace_comment'" .les. " " then goto replace_comment_top
$!
$!
$!;;;;;;;;;;
$!      Text to look for and replace with
$!
$!  We cannot edit the string here.  The user may want the spaces right
$!  where they put them.
$!;;;;;;;;;;
$!
$   find_text = " "
$!
$   say " "
$   say " "
$   inquire find_text "Enter text EDT is to search for: "
$!
$!
$   replace_text = " "
$!
$   say " "
$   say " "
$   inquire replace_text "Enter text EDT is to replace search text with: "
$!
$!;;;;;;;;;;
$!      Build the EDT command file
$!;;;;;;;;;;
$!
$ open/write tmp_com_file edt_mass_sub.edt
$ write tmp_com_file "S!''find_text'!''replace_text'!WH"
$ write tmp_com_file "exit"
$ close tmp_com_file
$!
$!;;;;;;;;;;
$!  Loop through all of the files
$!;;;;;;;;;;
$!
$ l_stream_id = 1
$!
$ prior_cms = f$trnlnm("cms$lib")
$ original_dir = f$environment( "DEFAULT")
$!
$ cms set library 'cms_library'
$!
$ work_file = cms_reference_dir + file_list
$!
$file_loop_top:
$!
$   the_file = f$search( "''work_file'", l_stream_id)
$!
$   if "''the_file'" .gts. " " 
$   then 
$       gosub process_file
$   else
$       goto exit_program
$   endif
$!
$ goto file_loop_top
$!
$!
$!;;;;;;;;;;
$!  subroutine to reserve the file, invoke EDT, and replace the file
$!;;;;;;;;;;
$!
$process_file:
$!
$   bracket_loc = f$locate( "]", "''the_file'")
$   semi_loc = f$locate( ";", "''the_file'")
$!
$   the_len = semi_loc - bracket_loc - 1
$!
$   element_name = f$extract( bracket_loc+1, the_len, "''the_file'")
$!
$   set noon
$   cms reserve 'element_name' "''reserve_comment'"
$   set on
$!
$   if .not. $STATUS
$   then
$       write sys$output bell, bell, "Unable to reserve element ''element_name'"
$   else
$       edit/edt/command='original_dir'edt_mass_sub.edt 'element_name'
$       cms replace 'element_name' "''replace_comment'"
$   endif
$!
$ return
$!
$!
$exit_program:
$   delete edt_mass_sub.edt;*
$   if "''prior_cms'" .gts. " "
$   then
$       cms set lib 'prior_cms'
$   endif
$!
$   set def 'original_dir'
$!
$   exit
