/*      CXX_ZILL_MOST_REPORT_SUB.CXX                                        */
/*                                                                          */
/*      Subroutine to create a report of the most frequently                */
/*      hit numbers.                                                        */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "zillionare_stats_record_class.hxx"

//
//  notice that we didn't include the descriptor header file
//  it was included by one of the other files under c++
//  
#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *CXX_MOST_REPORT_FILE_NAME = "ZILL_MOST.RPT";

const int ELM_COUNT = 52;



/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

extern "C" int cxx_desc_int_cmp( const void *e1, const void *e2);

void cxx_load_stat_arrays( struct zillionare_stats_record *d_stats,
                       struct zillionare_stats_record *m_stats);

void cxx_write_most_report( struct zillionare_stats_record *d_stats,
                    struct zillionare_stats_record *m_stats);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void cxx_zill_most_report_sub()
{
    using namespace std;
    
    int                     l_x;
    char                    command_str[255];

    $DESCRIPTOR( command_str_desc, command_str);

    //
    //  Arrays to hold stats records
    //
    struct zillionare_stats_record  d_stats[ ELM_COUNT];
    struct zillionare_stats_record  m_stats[ ELM_COUNT];

    c_fill_in_logicals();

    //
    //  Populate our working arrays.
    //
    cxx_load_stat_arrays( d_stats, m_stats);

    //
    //  Sort our arrays in descending order by hit count
    //
    qsort( d_stats, 
           ELM_COUNT, 
           sizeof( struct zillionare_stats_record),
           cxx_desc_int_cmp);

    qsort(  m_stats, 
            ELM_COUNT, 
            sizeof( struct zillionare_stats_record),
            cxx_desc_int_cmp);

    //
    //  Print the report
    //
    cxx_write_most_report( d_stats, m_stats);

    sprintf( command_str, "EDIT/READ %s", CXX_MOST_REPORT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);
        
}  /* end cxx_zill_most_report_sub subroutine */

/*;;;;;
 *  function to be used with qsort as the compare.
 *  Normally a sort compare routine returns the following:
 *      -1  e1 < e2
 *      0   e1 = e2
 *      1   e1 > e2
 *  We need the opposite to create descending sort.
 *;;;;;
 */
extern "C" int cxx_desc_int_cmp( const void *e1, const void *e2)
{
    int     ret_val;

    struct zillionare_stats_record *z_1, *z_2;

    z_1 = (struct zillionare_stats_record *)e1;
    z_2 = (struct zillionare_stats_record *)e2;


    ret_val = 0;

    if ( z_1->hit_count < z_2->hit_count)
    {
        ret_val = 1;
    }
    else 
    {
      if ( z_1->hit_count > z_2->hit_count)
            ret_val = -1;
    }

    return(ret_val);

}  /* end cxx_desc_int_cmp function */

/*;;;;;
 *  Subroutine to load all of the stats records into a working
 *  array.
 *;;;;;
 */
void cxx_load_stat_arrays( struct zillionare_stats_record *d_stat,
                          struct zillionare_stats_record *m_stat)
{
    int         l_x, l_sub, l_y;

    Zillionare_Stats_Record_Class   *draw_stats, *mega_stats;

    draw_stats = new Zillionare_Stats_Record_Class( "DRAWING_STATS");

    mega_stats = new Zillionare_Stats_Record_Class( "MEGA_STATS");

    //
    //  Empty arrays
    //
    memset( m_stat, 0, sizeof( struct zillionare_stats_record) * ELM_COUNT);
    memset( d_stat, 0, sizeof( struct zillionare_stats_record) * ELM_COUNT);
    
    l_x = draw_stats->open();
    if ( !(l_x & 1))
    {
        cout << "Error " << l_x << "opening drawing stats" << endl;
        return;
    }


    l_sub = 0;
    while (l_x & 1  &&  l_sub < ELM_COUNT)
    {
        l_x = draw_stats->get_seq( &d_stat[ l_sub]);
        l_sub++;
    }  /* end while not eof and array not full */

    draw_stats->close();



    l_x = mega_stats->open();
    if ( !(l_x & 1))
    {
        cout << "Error " << l_x << "opening drawing stats" << endl;
        return;
    }


    l_sub = 0;
    while (l_x & 1  &&  l_sub < ELM_COUNT)
    {
        l_x = mega_stats->get_seq( &m_stat[ l_sub]);
        l_sub++;
    }  /* end while not eof and array not full */

    mega_stats->close();

    
}  /* end cxx_load_stat_array subroutine */

void cxx_write_most_report( struct zillionare_stats_record *d_stats,
                    struct zillionare_stats_record *m_stats)
{
    int         l_x, l_fp;
    time_t      the_time;
    char        work_str[255], dtl_line[255];
    struct      zillionare_stats_record *work_stats;

    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));

    //
    //  C++ doesn't allow you to use RMS attributes in the class
    //  so you have to use C function to create the file, then use
    //  the special constructor.
    //  
    l_fp = open( CXX_MOST_REPORT_FILE_NAME,
                    O_WRONLY | O_CREAT | O_TRUNC, 0, 
                    "ctx=rec", "mrs=80", "rat=cr", "rfm=var");

    //
    //  C++ is more like BASIC in that you can declare variables anywhere
    //  
    ofstream    rpt_file( l_fp);

    
    //
    //  First heading
    //
    rpt_file << work_str;
    rpt_file.width(22);
    rpt_file << " ";
    rpt_file << "Most Hits Report" << endl << endl;
    rpt_file.width(29);
    rpt_file << " ";
    rpt_file << "Regular Drawing Numbers" << endl << endl << endl;

    //
    //  Column headings
    //
    rpt_file << "No   Hits   Since   Pct_hits   Ave_btwn" << endl;
    rpt_file << "--   ----   -----   --------   --------" << endl;


    work_stats = d_stats;

    for( l_x=0; l_x < 10; l_x++)
    {
        rpt_file.width(2);
        rpt_file << work_stats[l_x].elm_no;
        rpt_file << "   ";
        rpt_file.width(4);
        rpt_file << work_stats[l_x].hit_count;
        rpt_file << "   ";
        rpt_file.width(4);
        rpt_file << work_stats[l_x].since_last;
        rpt_file << "      ";
        rpt_file.width(5);
        rpt_file.precision(3);
        rpt_file << work_stats[l_x].pct_hits;
        rpt_file << "     ";
        rpt_file.width(5);
        rpt_file.precision(4);
        rpt_file << work_stats[l_x].ave_btwn;
        rpt_file << " " << endl;

    }  /* end for l_x loop */


    //
    //  Second heading
    //
    rpt_file << endl << endl << endl;
    rpt_file.width(30);
    rpt_file << " ";
    rpt_file << "Mega Drawing Numbers" << endl << endl << endl;

    //
    //  Column headings
    //
    rpt_file << "No   Hits   Since   Pct_hits   Ave_btwn" << endl;
    rpt_file << "--   ----   -----   --------   --------" << endl;


    work_stats = m_stats;

    for( l_x=0; l_x < 10; l_x++)
    {
        sprintf( dtl_line, "%2d   %4d   %4d      %5.3f    %5.3f",
                    work_stats[l_x].elm_no,
                    work_stats[l_x].hit_count,
                    work_stats[l_x].since_last,
                    work_stats[l_x].pct_hits,
                    work_stats[l_x].ave_btwn);

        rpt_file << dtl_line << endl;

    }  /* end for l_x loop */

    rpt_file.close();
}  /* end cxx_write_most_report subroutine */

