/*      CXX_ZILL_ENTRY_SUB.CXX                                              */
/*                                                                          */
/*      Subroutine to enter and maintain Mega Zillionare application data.  */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "drawing_record_class.hxx"
#include "fms_prototypes.hxx"

#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer

struct  entry_screen_struct
{
    char    draw_dt[8];
    char    no_1[2];
    char    no_2[2];
    char    no_3[2];
    char    no_4[2];
    char    no_5[2];
    char    mega_no[2];
    char    msg_txt[60];
};

enum entry_actions { ACTION_NONE, ACTION_ADD, ACTION_FIND,
                    ACTION_DELETE, ACTION_UPDATE, ACTION_EXIT};

enum entry_modes {ADD_MODE, DELETE_MODE, FIND_MODE, INVALID_MODE};

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int L_ZERO=0;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

void cxx_check_entry_terminator( int l_term, enum entry_actions& e);

void cxx_display_entry_error_msg( struct entry_screen_struct& s);

void cxx_entry_user_input( enum entry_actions& e_action, enum entry_modes& e_mode, 
                           struct entry_screen_struct& screen_rec, 
                           struct dsc$descriptor_s *screen_rec_desc, 
                           Drawing_Record_Class& draw_file);

void cxx_retrieve_entry_data( struct entry_screen_struct& s, struct drawing_record& d);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void cxx_zill_entry_sub( int *fms_status, int *rms_status, 
                        int *tca_array, int *workspace_array)
{
    int                     l_x, l_y;
    char                    command_str[255];
    enum entry_actions      e_action;
    enum entry_modes        e_mode;

    Drawing_Record_Class    draw_file;

    $DESCRIPTOR( form_name_desc, "ZILL_ENTRY2");

    struct  entry_screen_struct    screen_rec;

    struct dsc$descriptor_s      screen_rec_desc;

    //
    //  Best to build this one by hand since it technically isn't a string.
    //
    screen_rec_desc.dsc$w_length        = sizeof( screen_rec);
    screen_rec_desc.dsc$b_dtype         = DSC$K_DTYPE_T;
    screen_rec_desc.dsc$b_class         = DSC$K_CLASS_S;
    screen_rec_desc.dsc$a_pointer       = (char *)&screen_rec;

    l_x = draw_file.open( FAB$M_UPD | FAB$M_DEL | FAB$M_PUT);
    if ( !(l_x & 1))
    {
        cout << "Unable to open indexed file";
        return;
    }  /* end test for failed open */

    //
    //  Set the keypad mode and load our form
    //
    l_y = L_ZERO;
    l_x = fdv$spada( &l_y);

    l_x = fdv$cdisp( &form_name_desc);


    memset( &screen_rec, ' ', sizeof( screen_rec));

    do
    {
        cxx_entry_user_input( e_action, e_mode, screen_rec, 
                                &screen_rec_desc, draw_file);

    } while ( e_action != ACTION_EXIT);    

    draw_file.close();

    return;
}  /* end cxx_zill_entry_sub subroutine */

//;;;;;
//  Subroutine to handle user input
//;;;;;
void cxx_entry_user_input( enum entry_actions& e_action, enum entry_modes& e_mode, 
                           struct entry_screen_struct& screen_rec, 
                           struct dsc$descriptor_s *screen_rec_desc, 
                           Drawing_Record_Class& draw_file)
{
    int     l_x, l_terminator;
    char    work_str[255];

    struct drawing_record   d_rec;


    l_terminator = 0;

    l_x = fdv$getal( screen_rec_desc, &l_terminator);

    cxx_check_entry_terminator( l_terminator, e_action);

    switch( e_action)
    {
        case ACTION_NONE:       break;

        case ACTION_ADD:        e_mode = ADD_MODE;
                                cxx_retrieve_entry_data( screen_rec, d_rec);
                                if (d_rec.mega_no <=0)
                                {
                                    strcpy( screen_rec.msg_txt, "Must enter all fields");
                                    cxx_display_entry_error_msg( screen_rec);
                                }
                                else
                                {
                                    l_x = draw_file.put_record( &d_rec);
                                    memset( &screen_rec, ' ', sizeof(screen_rec));
                                }  /* end test for valid record on screen */
                                l_x = fdv$putal( screen_rec_desc);
                                break;

        case ACTION_FIND:       e_mode = FIND_MODE;
                                memset( work_str, '\0', sizeof( work_str));
                                memcpy( work_str, screen_rec.draw_dt, sizeof( screen_rec.draw_dt));
                                l_x = draw_file.get_via_k0( work_str, &d_rec);
                                if ( !(l_x & 1))
                                {
                                    strcpy( screen_rec.msg_txt, "Could not find record");
                                    cxx_display_entry_error_msg( screen_rec);
                                }
                                else
                                {
                                    memset( &screen_rec, ' ', sizeof( screen_rec));
                                    memcpy( screen_rec.draw_dt, d_rec.draw_dt,
                                                sizeof( screen_rec.draw_dt));
                                    sprintf( work_str, "%2d", d_rec.no_1);
                                    memcpy( screen_rec.no_1, work_str, 2);
                                    sprintf( work_str, "%2d", d_rec.no_2);
                                    memcpy( screen_rec.no_2, work_str, 2);
                                    sprintf( work_str, "%2d", d_rec.no_3);
                                    memcpy( screen_rec.no_3, work_str, 2);
                                    sprintf( work_str, "%2d", d_rec.no_4);
                                    memcpy( screen_rec.no_4, work_str, 2);
                                    sprintf( work_str, "%2d", d_rec.no_5);
                                    memcpy( screen_rec.no_5, work_str, 2);
                                    sprintf( work_str, "%2d", d_rec.mega_no);
                                    memcpy( screen_rec.mega_no, work_str, 2);
                                    

                                    l_x = fdv$putal( screen_rec_desc);
                                }  /* end test for successfull find */

                                break;

        case ACTION_UPDATE:     if ( e_mode == FIND_MODE)
                                {
                                    cxx_retrieve_entry_data( screen_rec, d_rec);
                                    l_x = draw_file.update_record( &d_rec);
                                    if ( !(l_x & 1))
                                    {
                                        sprintf( screen_rec.msg_txt,
                                                "Error %d updating record", l_x);
                                        cxx_display_entry_error_msg( screen_rec);
                                    }
                                    memset( &screen_rec, ' ', sizeof( screen_rec));
                                    l_x = fdv$putal( screen_rec_desc);
                                }
                                else
                                {
                                    strcpy( screen_rec.msg_txt,
                                        "Must find before update");
                                    cxx_display_entry_error_msg( screen_rec);
                                }
                                e_mode = ADD_MODE;
                                break;

        case ACTION_DELETE:     if ( e_mode != FIND_MODE)
                                {
                                    strcpy( screen_rec.msg_txt, "Must find before delete");
                                    cxx_display_entry_error_msg( screen_rec);
                                }
                                else
                                {
                                    e_mode = DELETE_MODE;
                                    l_x = draw_file.delete_record();
                                    memset( &screen_rec, ' ', sizeof( struct entry_screen_struct));
                                    l_x = fdv$putal( screen_rec_desc);
                                }
                                break;

        case ACTION_EXIT:       break;
    }  /* end switch of e_action */

}  /* end cxx_entry_user_input subroutine */

//;;;;;
//  Subroutine to retrieve entry data from the screen buffer
//;;;;;
void cxx_retrieve_entry_data( struct entry_screen_struct& s, struct drawing_record& d)
{
    char    work_str[ 255];

    memcpy( d.draw_dt, s.draw_dt, sizeof( d.draw_dt));

    memset( work_str, '\0', sizeof( work_str));
    memcpy( work_str, s.no_1, sizeof( s.no_1));
    d.no_1 = atol( work_str);
    memcpy( work_str, s.no_2, sizeof( s.no_2));
    d.no_2 = atol( work_str);
    memcpy( work_str, s.no_3, sizeof( s.no_3));
    d.no_3 = atol( work_str);
    memcpy( work_str, s.no_4, sizeof( s.no_4));
    d.no_4 = atol( work_str);
    memcpy( work_str, s.no_5, sizeof( s.no_5));
    d.no_5 = atol( work_str);
    memcpy( work_str, s.mega_no, sizeof( s.mega_no));
    d.mega_no = atol( work_str);
}  /* end cxx_retrieve_entry_data subroutine */

//;;;;;
//      Subroutine to display entry errors
//;;;;;
void cxx_display_entry_error_msg( struct entry_screen_struct& s)
{
    int         l_x;
    char        work_str[255];

    $DESCRIPTOR( str_desc, work_str);
    $DESCRIPTOR( fld_name_desc, "MSG_TXT");

    
    POINTER( str_desc) = s.msg_txt;
    LENGTH( str_desc) = sizeof( s.msg_txt);

    l_x = fdv$bell();

    l_x = fdv$put( &str_desc, &fld_name_desc);

    l_x = fdv$wait();

    memset( s.msg_txt, ' ', sizeof( s.msg_txt));
    l_x = fdv$put( &str_desc, &fld_name_desc);

}  /* end cxx_display_entry_error_msg subroutine */


//;;;;;
//  Subroutine to check entry terminator
//;;;;;
void cxx_check_entry_terminator( int l_term, enum entry_actions& e)
{
    switch ( l_term)
    {
        case FDV$K_FK_F7:       e = ACTION_ADD;
                                break;

        case FDV$K_FK_F8:       e = ACTION_FIND;
                                break;

        case FDV$K_FK_F9:       e = ACTION_DELETE;
                                break;

        case FDV$K_FK_F10:      e = ACTION_EXIT;
                                break;

        case FDV$K_FK_F11:      e = ACTION_UPDATE;
                                break;

        default:                e = ACTION_ADD;
                                break;
    }  /* end switch of terminator */

}  /* end cxx_check_entry_terminator subroutine */


/*;;;;;
 *  Function will be used as a UAR by FMS
 *;;;;;
 */
extern "C" int drawing_range()
{
    char    form_name_str[31], uar_vals[80], field_name[31],
            data_line[132], work_str[255];
    int     l_terminator, l_tca_ptr, l_workspace_ptr, l_cursor_pos,
            l_ins_over, l_help_num, l_x, l_fldidx, ret_val;

    $DESCRIPTOR( form_name_desc, form_name_str);
    $DESCRIPTOR( uar_vals_desc, uar_vals);
    $DESCRIPTOR( field_name_desc, field_name);
    $DESCRIPTOR( data_line_desc, data_line);


    //
    //  Set up default return value
    //
    ret_val = FDV$K_UVAL_FAIL;

    //
    //  Obtain UAR information
    //
    l_x = fdv$retcx( &l_tca_ptr, &l_workspace_ptr, &form_name_desc,
                     &uar_vals_desc, &l_cursor_pos, &l_terminator,
                     &l_ins_over, &l_help_num);

    //
    //  What field are we in
    //
    l_x = fdv$retfn( &field_name_desc, &l_fldidx);

    //
    //  Obtain the field data
    //
    memset( data_line, '\0', sizeof( data_line));

    l_x = fdv$ret( &data_line_desc, &field_name_desc, &l_fldidx);

    memset( work_str, '\0', sizeof( work_str));
    memcpy( work_str, data_line, 2);

    l_x = atol( work_str);

    if ( l_x >= 1  &&  l_x <= 52)
        ret_val = FDV$K_UVAL_SUC;

    return ret_val;
    
}  /* end drawing_range function */

// turn on warnings about dollarsign  characters
#pragma message enable (DOLLARID)          

