/*      CXX_ZILL_BROWSE_SUB.CXX                                             */
/*                                                                          */
/*      Subroutine to browse through the Mega Zillionare application data   */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "drawing_record_class.hxx"
#include "fms_prototypes.hxx"

#define LENGTH(descriptor)      descriptor.dsc$w_length


struct  browse_screen_struct
{
    char    f_mark;
    char    draw_dt[10];
    char    numbers[30];
    char    mega_no_txt[2];
};



/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int LOAD_FORWARD = 0;
const int LOAD_REVERSE = 1;
const int L_DONE = 99;
const int L_BROWSE_SCREEN_COUNT = 10;

const int L_ZERO=0;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

void cxx_browse_user_input( int *l_action, struct browse_screen_struct *s, 
                            int *l_load_direction, Drawing_Record_Class& d_f);

void cxx_load_browse_screen( struct browse_screen_struct *b_s, int *load_direction, 
                                Drawing_Record_Class& d_f);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */

//  turn off warnings about $ characters
#pragma message disable (DOLLARID)          


void cxx_zill_browse_sub( int *fms_status, int *rms_stats,
                          int *tca_array, int *workspace_array)
{
    int                     l_x, l_load_direction;
    int                     l_action, l_y;
    char                    line_in[255], command_str[255];

    Drawing_Record_Class    draw_file;

    struct  browse_screen_struct    screen_rec[L_BROWSE_SCREEN_COUNT];


    $DESCRIPTOR( form_name_desc, "ZILL_BROWSE");

    c_fill_in_logicals();

    l_x = draw_file.open();


    //
    //  Set the keypad mode and load our form
    //
    l_y = L_ZERO;
    l_x = fdv$spada( &l_y);

    l_x = fdv$cdisp( &form_name_desc);

    l_load_direction = LOAD_FORWARD;

    l_action = 0;

    //
    //  This works because the array is declared locally
    //  so the compiler knows just how big it is.
    //
    memset( screen_rec, ' ', sizeof( screen_rec));

    do
    {
        cxx_browse_user_input( &l_action, screen_rec, &l_load_direction, draw_file);
    } while (l_action != L_DONE);


    draw_file.close();

    return;

}  /* end cxx_zill_browse_sub subroutine */

//;;;;;
//      Subroutine to accept user input while browsing
//;;;;;
void cxx_browse_user_input( int *l_action, struct browse_screen_struct *s, 
                       int *l_load_direction, Drawing_Record_Class& d_f)
{
    int     l_x, l_terminator;

    struct  dsc$descriptor_s    b_s_desc;


    cxx_load_browse_screen( s, l_load_direction, d_f);

    //
    //  hand build a string descriptor for our browse
    //  screen array.
    //
    b_s_desc.dsc$w_length   = sizeof( struct browse_screen_struct)
                              * L_BROWSE_SCREEN_COUNT;
    b_s_desc.dsc$b_dtype    = DSC$K_DTYPE_T;
    b_s_desc.dsc$b_class    = DSC$K_CLASS_S;
    b_s_desc.dsc$a_pointer  = (char *)s;

    l_terminator = 0;

    l_x = fdv$putal( &b_s_desc);

    l_x = fdv$getal( &b_s_desc, &l_terminator);

    switch( l_terminator)
    {
        case FDV$K_FK_E6:       *l_load_direction = LOAD_FORWARD;
                                break;
        case FDV$K_FK_E5:       *l_load_direction = LOAD_REVERSE;
                                break;
        case FDV$K_FK_F10:      *l_action = L_DONE;
                                break;

    }  /* end switch of terminator */


}  /* end cxx_browse_user_input subroutine */

//;;;;;
//  Subroutine to load records into the browse screen
//;;;;;
void cxx_load_browse_screen( struct browse_screen_struct *b_s, int *load_direction, 
                                Drawing_Record_Class& d_f)
{
    int     l_x, l_sub, l_y;
    char    work_str[255];

    struct  drawing_record  d;


    l_sub = -1;
    memset( &d, ' ', sizeof( d));       // clear out record buffer just in
                                        // case
    
    if (*load_direction == LOAD_REVERSE)
    {
        if (memcmp( b_s[ 0].draw_dt, "    ", 4) > 0)
            l_sub = 0;
    }
    else
    {
        l_sub = L_BROWSE_SCREEN_COUNT - 1;
        //
        // find the first non blank line from the bottom of the display
        //
        while ((memcmp( b_s[ l_sub].draw_dt, "    ", 4) <= 0) && l_sub >= 0)
            l_sub--;
    }  /* end test for reverse load */

    //
    //  Does the screen provide us with a valid starting point?
    //
    if ( l_sub >= 0)
    {
        // convert draw_dt from mm/dd/yyyy to yyyymmdd
        //
        string formatted_dt_str = b_s[ l_sub].draw_dt;
        string yyyymmdd_str = formatted_dt_str.substr( 6,4) +
                              formatted_dt_str.substr( 0,2) +
                              formatted_dt_str.substr( 3,2);
        memcpy( d.draw_dt, yyyymmdd_str.c_str(), sizeof( d.draw_dt));
    }  /* end test for valid record found */

    //
    //  Set screen array to spaces
    //
    memset( b_s, ' ', sizeof( struct browse_screen_struct) * L_BROWSE_SCREEN_COUNT);

    l_x = d_f.get_via_k0( d.draw_dt, &d);

    if ( !(l_x & 1))
    {
        cout << "Error " << l_x << " retrieving key via index" << endl;
    }

    if (*load_direction == LOAD_REVERSE)
        l_sub = L_BROWSE_SCREEN_COUNT-1;
    else
        l_sub = 0;

    //
    //  Use l_y as the load record counter so we can vary
    //  l_sub in the direction it needs to go.
    //  
    l_y = 0;
    while ( (l_x & 1)  && l_y < L_BROWSE_SCREEN_COUNT)
    {
        string raw_dt_str = d.draw_dt;
        string formatted_dt_str = raw_dt_str.substr( 4,2) + '/' +
                                  raw_dt_str.substr( 6,2) + '/' +
                                  raw_dt_str.substr( 0,4);

        memcpy( b_s[ l_sub].draw_dt, formatted_dt_str.c_str(), sizeof( b_s[ l_sub].draw_dt));

        //
        //   Now build a string of the numbers
        //
        sprintf( work_str, "%2d %2d %2d %2d %2d", d.no_1,
                                                  d.no_2,
                                                  d.no_3,
                                                  d.no_4,    
                                                  d.no_5);

        memcpy( b_s[l_sub].numbers, work_str, strlen( work_str));

        sprintf( work_str, "%2d", d.mega_no);

        memcpy( b_s[l_sub].mega_no_txt, work_str, 2);

        l_y++;
        
        if (*load_direction == LOAD_REVERSE)
            l_sub--;
        else
            l_sub++;

        if (*load_direction == LOAD_FORWARD)
            l_x = d_f.get_next_key( &d);
        else
            l_x = d_f.get_next_key_rev( &d);

    }  /* end while loop */

    //
    //  trap for condition where we tried to go backwards, but hit
    //  top of file before filling screen.
    //  
    if ( l_y < L_BROWSE_SCREEN_COUNT  && *load_direction == LOAD_REVERSE)
    {
        memset( b_s, ' ', sizeof( struct browse_screen_struct) * L_BROWSE_SCREEN_COUNT);
        *load_direction = LOAD_FORWARD;
        cxx_load_browse_screen( b_s, load_direction, d_f);
    }  /* end test for too short of screen on reverse */

}  /* end cxx_load_browse_screen subroutine */
