/*      CXX_DUMP_DRAW_DATA_SUB.CXX                                          */
/*                                                                          */
/*      Subroutine to create a report of drawing records on file.           */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "drawing_record_class.hxx"

//
//  notice that we didn't include the descriptor header file
//  it was included by one of the other files under c++
//  
#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *CXX_DUMP_REPORT_FILE_NAME = "ZILL_DUMP.RPT";



/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

void    cxx_write_dump_headings( ofstream& rpt_file, int l_page_no);

void    cxx_write_dump_report( void);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void cxx_dump_draw_data_sub()
{
    int                     l_x;
    char                    command_str[255];

    $DESCRIPTOR( command_str_desc, command_str);

    cxx_write_dump_report();

    sprintf( command_str, "EDIT/READ %s", CXX_DUMP_REPORT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end cxx_dump_draw_data_sub subroutine */


void cxx_write_dump_report()
{
    const int PAGE_SIZE = 60;
    
    int     l_x, l_fp, l_page_no, l_line_no;
    char    dtl_line[255], work_str[255];
    char    yyyy_str[5], mm_str[3], dd_str[3];

    struct  drawing_record  d_rec;

    Drawing_Record_Class    draw_file;



    //
    //  C++ doesn't allow you to use RMS attributes in the class
    //  so you have to use C function to create the file, then use
    //  the special constructor.
    //  
    l_fp = open( CXX_DUMP_REPORT_FILE_NAME,
                    O_WRONLY | O_CREAT | O_TRUNC, 0, 
                    "ctx=rec", "mrs=80", "rat=cr", "rfm=var");

    //
    //  C++ is more like BASIC in that you can declare variables anywhere
    //  
    ofstream    rpt_file( l_fp);

    l_page_no = 1;
    l_line_no = 0;
    cxx_write_dump_headings( rpt_file, l_page_no);

    l_x = draw_file.open();

    if ( !(l_x & 1))
    {
        cout << "Unable to open input file " << endl;
        return;
    }  /* end test for successful open */

    l_x = draw_file.get_via_k0( "        ", &d_rec);

    while ( l_x & 1)
    {
        //
        //  Move the date into a null terminated string for printing
        //
        memset( yyyy_str, '\0', sizeof( yyyy_str));
        memset( dd_str, '\0', sizeof( dd_str));
        memset( mm_str, '\0', sizeof( mm_str));

        memcpy( yyyy_str, d_rec.draw_dt, 4);
        memcpy( mm_str, &d_rec.draw_dt[4], 2);
        memcpy( dd_str, &d_rec.draw_dt[6], 2);

        sprintf( dtl_line, "%s-%s-%s       %2d   %2d   %2d   %2d   %2d       %2d",
               mm_str, dd_str, yyyy_str,
               d_rec.no_1,
               d_rec.no_2,
               d_rec.no_3,
               d_rec.no_4,
               d_rec.no_5,
               d_rec.mega_no);

        rpt_file << dtl_line << endl;

        l_line_no++;

        if ( l_line_no > PAGE_SIZE)
        {
            l_page_no++;
            cxx_write_dump_headings( rpt_file, l_page_no);
            l_line_no = 5;
        }  /* end test for page break */

        l_x = draw_file.get_next_key( &d_rec);
        
    }  /* end while not end of file loop */

    rpt_file.close();
    
}  /*  end cxx_write_dump_report subroutine */


void    cxx_write_dump_headings( ofstream& rpt_file, int l_page_no)
{
    char    work_str[255], heading_line[255];
    time_t  the_time;


    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));

    if (l_page_no > 1)
        rpt_file << "\f";

    sprintf( heading_line, "%s %20.20s Drawing Number Report          Page: %d",
                work_str, " ", l_page_no);
    rpt_file << heading_line << endl;

    rpt_file << "    Drawing      No   No   No   No   No     Mega" << endl;
    rpt_file << "     Date         1    2    3    4    5      No" << endl;
    rpt_file << "------------     --   --   --   --   --     ----" << endl;

}  /* end cxx_write_dump_headings subroutine */
