/*  C_MY_ZILL_MENU.C
 *
 *  Main menu for C programs in our
 *  Mega example application using MySQL.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>

/*
 *      VMS headers
 */
#include <starlet>
#include <stsdef>
#include <descrip>
#include <lib$routines>
#include <fdvdef>
#include <fms_prototypes_upper>

/*
 *  Our headers
 */
#include <mysql.h>

// turn off warnings about $ characters
#pragma message disable (DOLLARID)          

#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int WORKSPACE_SIZE = 2000;

MYSQL   *Conn;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void c_my_create_stats_sub( MYSQL *conn );

void c_my_dump_draw_data_sub( MYSQL *conn);

void c_fill_in_logicals( void);

void c_my_zill_browse_sub( int *fms_status, int *rms_status,
                        int *tca_array, int *workspace_array,
                        MYSQL *conn);

void c_my_zill_due_report_sub( MYSQL *conn);

void c_my_zill_entry_sub( int *fms_status, int *rms_status,
                        int *tca_array, int *workspace_array,
                        MYSQL *conn);

void c_my_zill_import_sub( MYSQL *conn);

void c_my_zill_most_report_sub( MYSQL *conn);

void menu_user_input( int *fms_status, int *rms_status,
                      int *tca, int *workspace, int *done_flag,
                      struct dsc$descriptor_s *form_name_desc);

void prompt_password( char *pass_word);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */

int main( )
{
    int     l_x, l_y, tca[3], workspace[WORKSPACE_SIZE], l_z;
    int     fms_status, rms_status, l_done_flag, l_err_flg, l_try_count;
    char    password_str[1024];


    struct dsc$descriptor_a tca_desc, workspace_desc;


    $DESCRIPTOR( form_name_desc, "ZILL_MENU");
    $DESCRIPTOR( library_desc, "MEGA_ZILL");


    c_fill_in_logicals();

    

    //  Build our array descriptors by hand
    //
    memset( &tca_desc, 0, sizeof( tca_desc));
    tca_desc.dsc$w_length           = sizeof( int);
    tca_desc.dsc$b_dtype            = DSC$K_DTYPE_L;
    tca_desc.dsc$b_class            = DSC$K_CLASS_A;
    tca_desc.dsc$a_pointer          = (char *)tca;
    tca_desc.dsc$b_dimct            = 1;
    tca_desc.dsc$l_arsize           = sizeof( tca);

    workspace_desc                  = tca_desc;
    workspace_desc.dsc$a_pointer    = (char *)workspace;

    //
    //  Establish connection to database
    //
    Conn = mysql_init( NULL);

    memset( password_str, '\0', sizeof( password_str));

    l_err_flg = -1;
    l_try_count = 0;

    while ( strlen( password_str) < 1  &&  l_err_flg != 0  && l_try_count < 5)
    {
        l_err_flg = 0;
        prompt_password( password_str);
        if ( mysql_real_connect( Conn, 
                    NULL, 
                    NULL, 
                    password_str, 
                    "mega_zillionare",
                    0,
                    NULL,
                    0) == NULL)
        {
            l_err_flg = mysql_errno( Conn);
            printf( "mysql_real_connect() failed:\nError: %u (%s)\n",
                l_err_flg, mysql_error(Conn));
            memset( password_str, '\0', sizeof( password_str));
        }
        l_try_count++;

    }  /* end while loop to get password and connect */



  
    //  Initialize FMS
    //
    l_y = 2;
    l_z = 12;
    l_x = FDV$ATERM( &tca_desc, &l_z, &l_y);

    l_y = WORKSPACE_SIZE;
    l_x = FDV$AWKSP( &workspace_desc, &l_y);

    l_y = 1;
    l_x = FDV$LOPEN( &library_desc, &l_y);

    l_y = 1;
    l_x = FDV$SPADA( &l_y);

    l_y = 0;
    l_x = FDV$SSIGQ( &l_y);

    l_x = FDV$SSRV( &fms_status, &rms_status);

    l_x = FDV$CDISP( &form_name_desc);


    l_done_flag = 0;

    do
    {
        menu_user_input( &fms_status, &rms_status, tca, workspace, 
                         &l_done_flag, &form_name_desc);
    }  while (l_done_flag == 0);

    l_x = FDV$LCLOS();

    l_x = FDV$DWKSP( &workspace_desc);

    l_x = FDV$DTERM( &tca_desc);

    mysql_close( Conn);

    return 1;

}  /* end main */

/*;;;;;
 *  Subroutine to handle input from the user
 *;;;;;
 */
void menu_user_input( int *fms_status, int *rms_status,
                      int *tca, int *workspace, int *done_flag,
                      struct dsc$descriptor_s *form_name_desc)
{

    int         l_x, l_terminator;
    char        work_str[255];


    $DESCRIPTOR( work_str_desc, work_str);



    l_x = FDV$GETAL( &work_str_desc, &l_terminator);

    switch( l_terminator)
    {
        case FDV$K_PF_4:        *done_flag = 1;
                                break;

        case FDV$K_KP_1:        l_x = FDV$CLEAR();
                                c_my_zill_import_sub( Conn);
                                break;

        case FDV$K_KP_2:        l_x = FDV$CLEAR();
                                c_my_zill_entry_sub( fms_status, rms_status,
                                                  tca, workspace, Conn);
                                break;

        case FDV$K_KP_3:        l_x = FDV$CLEAR();
                                c_my_create_stats_sub( Conn);
                                break;

        case FDV$K_KP_5:        l_x = FDV$CLEAR();
                                c_my_zill_browse_sub( fms_status, rms_status,
                                                   tca, workspace, Conn);
                                break;

        case FDV$K_KP_7:        l_x = FDV$CLEAR();
                                c_my_zill_due_report_sub( Conn);
                                break;

        case FDV$K_KP_8:        l_x = FDV$CLEAR();
                                c_my_zill_most_report_sub( Conn);
                                break;

        case FDV$K_KP_9:        l_x = FDV$CLEAR();
                                c_my_dump_draw_data_sub( Conn);
                                break;

    }  /* end switch of e_action */


    l_x = 1;
    l_x = FDV$SPADA( &l_x);

    l_x = FDV$CDISP( form_name_desc);

}  /* end entry_user_input subroutine */

void prompt_password( char *dest_pwd)
{
    int     l_x;
    char    db_password[255];

    $DESCRIPTOR( no_echo_desc, "SET TERM/NOECHO");
    $DESCRIPTOR( echo_desc, "SET TERM/ECHO");


    memset( db_password, '\0', sizeof( db_password));
    printf( "Enter Password: ");

    l_x = lib$spawn( &no_echo_desc);

    scanf( "%s", db_password);
    puts( " ");     // the new line will be lost on input

    l_x = lib$spawn( &echo_desc);

    strcpy( dest_pwd, db_password);
}  /* end prompt_password subroutine */

// turn on warnings about dollarsign  characters
#pragma message enable (DOLLARID)          

