/*  C_MY_ZILL_ENTRY_SUB.C
 *
 *  Subroutine to allow entry and maintenance
 *  in the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>

/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>
#include <fdvdef>
#include <fms_prototypes_upper>

/*
 *  Our headers
 */
#include <mysql.h>

// turn off warnings about $ characters
#pragma message disable (DOLLARID)          

#pragma member_alignment save
#pragma nomember_alignment
#pragma dictionary "cdd_records.drawing_record"
#pragma member_alignment restore

#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer


struct  entry_screen_struct
{
    char    draw_dt[8];
    char    no_1[2];
    char    no_2[2];
    char    no_3[2];
    char    no_4[2];
    char    no_5[2];
    char    mega_no[2];
    char    msg_txt[60];
};



enum entry_actions { ACTION_NONE, ACTION_ADD, ACTION_FIND,
                    ACTION_DELETE, ACTION_UPDATE, ACTION_EXIT};

enum entry_modes {ADD_MODE, DELETE_MODE, FIND_MODE, INVALID_MODE};

/*;;;;;
 *      Program constants and global data
 *;;;;;
 */
MYSQL *Passed_Conn;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void add_mega_record( struct entry_screen_struct *s_rec, 
                      struct drawing_record *m_z);

void check_entry_terminator( int terminator, enum entry_actions *a);

void delete_mega_record( struct entry_screen_struct *screen_rec,
                         struct drawing_record *m_z);

void display_entry_error_msg( struct entry_screen_struct *s_rec);

void entry_user_input( enum entry_actions *e_action, enum entry_modes *e_mode, 
                       struct entry_screen_struct *screen_rec,
                       struct dsc$descriptor_s *screen_rec_desc,
                       struct drawing_record *m_z);

void find_mega_record( struct entry_screen_struct *s_rec,
                       struct drawing_record *m_z);

void retrieve_entry_data( struct entry_screen_struct *s_rec,
                          struct drawing_record *m_z);

void update_mega_record( struct entry_screen_struct *s_rec,
                         struct drawing_record *m_z);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_my_zill_entry_sub( int *fms_status, int *rms_status, 
                        int *tca_array, int *workspace_array,
                        MYSQL *conn)
{
    int                     l_x, l_y;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;
    enum entry_actions      e_action;
    enum entry_modes        e_mode;

    $DESCRIPTOR( command_str_desc, command_str);

    struct  drawing_record  m_z;

    struct  entry_screen_struct    screen_rec;

    $DESCRIPTOR( form_name_desc, "ZILL_ENTRY2");

    struct dsc$descriptor_s      screen_rec_desc;

    //
    //  Move the connection pointer to a global variable so
    //  we don't have to pass it around all over the place.
    //
    Passed_Conn = conn;

    //
    //  Best to build this one by hand since it technically isn't a string.
    //
    screen_rec_desc.dsc$w_length        = sizeof( screen_rec);
    screen_rec_desc.dsc$b_dtype         = DSC$K_DTYPE_T;
    screen_rec_desc.dsc$b_class         = DSC$K_CLASS_S;
    screen_rec_desc.dsc$a_pointer       = (char *)&screen_rec;

    //
    //  Set the keypad mode and load our form
    //
    l_y = 0;
    l_x = FDV$SPADA( &l_y);

    l_x = FDV$CDISP( &form_name_desc);

    memset( &screen_rec, ' ', sizeof( screen_rec));

    do
    {
        entry_user_input( &e_action, &e_mode, 
                          &screen_rec, &screen_rec_desc, &m_z);

    } while ( e_action != ACTION_EXIT);

    return;

}  /* end c_my_zill_entry_sub */

/*;;;;;
 *  Subroutine to handle input from the user
 *;;;;;
 */
void entry_user_input( enum entry_actions *e_action, enum entry_modes *e_mode, 
                       struct entry_screen_struct *screen_rec,
                       struct dsc$descriptor_s *screen_rec_desc,
                       struct drawing_record *m_z)
{
    int         l_x, l_terminator;
    char        command_str[1024];

    l_terminator = 0;

    l_x = FDV$GETAL( screen_rec_desc, &l_terminator);

    check_entry_terminator( l_terminator, e_action);

    switch( *e_action)
    {
        case ACTION_NONE:       break;

        case ACTION_ADD:        *e_mode = ADD_MODE;
                                add_mega_record( screen_rec, m_z);
                                l_x = FDV$PUTAL( screen_rec_desc);
                                break;

        case ACTION_FIND:       *e_mode = FIND_MODE;
                                find_mega_record( screen_rec, m_z);
                                l_x = FDV$PUTAL( screen_rec_desc);
                                break;

        case ACTION_UPDATE:     if ( *e_mode == FIND_MODE)
                                {
                                    update_mega_record( screen_rec, m_z);
                                    l_x = FDV$PUTAL( screen_rec_desc);
                                }
                                else
                                {
                                    strcpy( screen_rec->msg_txt,"Must find before update");
                                    display_entry_error_msg( screen_rec);
                                }
                                *e_mode = ADD_MODE;
                                break;

        case ACTION_DELETE:     if ( *e_mode != FIND_MODE)
                                {
                                    strcpy( screen_rec->msg_txt,"Must find before delete");
                                    display_entry_error_msg( screen_rec);
                                }
                                else
                                {
                                    *e_mode = DELETE_MODE;
                                    delete_mega_record( screen_rec, m_z);
                                    memset( screen_rec, ' ', sizeof( struct entry_screen_struct));
                                    l_x = FDV$PUTAL( screen_rec_desc);
                                }
                                break;

        case ACTION_EXIT:       break;
    }  /* end switch of e_action */

}  /* end entry_user_input subroutine */

/*;;;;;
 *  Subroutine to check the terminator and set appropriate action flags
 *;;;;;
 */
void check_entry_terminator( int terminator, enum entry_actions *a)
{
    switch ( terminator)
    {
        case FDV$K_FK_F7:       *a = ACTION_ADD;
                                break;

        case FDV$K_FK_F8:       *a = ACTION_FIND;
                                break;

        case FDV$K_FK_F9:       *a = ACTION_DELETE;
                                break;

        case FDV$K_FK_F10:      *a = ACTION_EXIT;
                                break;

        case FDV$K_FK_F11:      *a = ACTION_UPDATE;
                                break;

        default:                *a = ACTION_ADD;
                                break;
    }  /* end switch of terminator */

}  /* end check_entry_terminator subroutine */

/*;;;;;
 *  Subroutine to add a record to the MEGA indexed file
 *;;;;;
 */
void add_mega_record( struct entry_screen_struct *s_rec, 
                      struct drawing_record *m_z)
{
    int     l_x;
    char    command_str[1024], yyyy_str[5], mm_str[3], dd_str[3];

    retrieve_entry_data( s_rec, m_z);

    if ( m_z->mega_no <= 0)
    {
        strcpy( s_rec->msg_txt, "Must enter all fields");
        display_entry_error_msg( s_rec);
    }
    else
    {
        memset( yyyy_str, '\0', sizeof( yyyy_str));
        memset( mm_str, '\0', sizeof( mm_str));
        memset( dd_str, '\0', sizeof( dd_str));
        memcpy( yyyy_str, m_z->draw_dt, 4);
        memcpy( mm_str, &m_z->draw_dt[4], 2);
        memcpy( dd_str, &m_z->draw_dt[6], 2);

        sprintf( command_str, "INSERT INTO DRAWING_DATA\
                                (draw_dt, no_1, no_2, no_3, no_4,\
                                 no_5, mega_no)\
                                VALUES ('%s-%s-%s', %d, %d, %d, %d, %d, %d);",
                 yyyy_str, mm_str, dd_str, m_z->no_1, m_z->no_2, m_z->no_3,
                 m_z->no_4, m_z->no_5, m_z->mega_no);

        l_x = mysql_query( Passed_Conn, command_str);
        if ( l_x != 0)
        {
            sprintf( s_rec->msg_txt, "%s", mysql_error( Passed_Conn));
            display_entry_error_msg( s_rec);
        }  /* end test for succesful insert */
        else
        {
            mysql_commit( Passed_Conn);
            memset( s_rec, ' ', sizeof( struct entry_screen_struct));
        }

    }  /* end test for full screen */

}  /* end add_mega_record subroutine */

/*;;;;;
 *  Subroutine to delete a record in the Mega database
 *;;;;;
 */
void delete_mega_record( struct entry_screen_struct *s_rec,
                         struct drawing_record *m_z)
{
    int     l_x, l_y, l_z;
    char    work_str[255], yyyy_str[5], mm_str[3], dd_str[3],
            command_str[1024];



    retrieve_entry_data( s_rec, m_z);

    memcpy( m_z->draw_dt, s_rec->draw_dt, sizeof( m_z->draw_dt));
    memset( yyyy_str, '\0', sizeof( yyyy_str));
    memset( dd_str, '\0', sizeof( dd_str));
    memset( mm_str, '\0', sizeof( mm_str));

    memcpy( yyyy_str, m_z->draw_dt, 4);
    memcpy( mm_str, &m_z->draw_dt[4], 2);
    memcpy( dd_str, &m_z->draw_dt[6], 2);


    sprintf( command_str, "DELETE FROM DRAWING_DATA\
                            WHERE DRAW_DT >='%s-%s-%s';",
             yyyy_str, mm_str, dd_str);

    l_x = mysql_query( Passed_Conn, command_str);

    if ( l_x != 0)
    {
        sprintf( s_rec->msg_txt, "Delete Error %s", mysql_error(Passed_Conn));
        display_entry_error_msg( s_rec);
    }  /* end check for query error */

    mysql_commit( Passed_Conn);

}  /* end delete_mega_record subroutine */

/*;;;;;
 *  Subroutine to find a record on the MEGA database.
 *;;;;;
 */
void find_mega_record( struct entry_screen_struct *s_rec,
                       struct drawing_record *m_z)
{
    int     l_x, l_y, l_z;
    char    work_str[255], yyyy_str[5], mm_str[3], dd_str[3],
            command_str[1024];

    MYSQL_RES   *res;
    MYSQL_ROW   row;

    retrieve_entry_data( s_rec, m_z);

    memcpy( m_z->draw_dt, s_rec->draw_dt, sizeof( m_z->draw_dt));
    memset( yyyy_str, '\0', sizeof( yyyy_str));
    memset( dd_str, '\0', sizeof( dd_str));
    memset( mm_str, '\0', sizeof( mm_str));

    memcpy( yyyy_str, m_z->draw_dt, 4);
    memcpy( mm_str, &m_z->draw_dt[4], 2);
    memcpy( dd_str, &m_z->draw_dt[6], 2);

    //
    //  Stop partial date from killing us
    //
    if ( mm_str[0] <= ' ')
    {
        strcpy( mm_str, "01");
    }  /* end test for missing month */

    if ( dd_str[0] <= ' ')
    {
        strcpy( dd_str, "01");
    }  /* end test for missing day */

    sprintf( command_str, "SELECT DRAW_DT, NO_1, NO_2, NO_3,\
                            NO_4, NO_5, MEGA_NO\
                            FROM DRAWING_DATA\
                            WHERE DRAW_DT >='%s-%s-%s' LIMIT 1;",
             yyyy_str, mm_str, dd_str);

    l_x = mysql_query( Passed_Conn, command_str);

    if ( l_x != 0)
    {
        strcpy( s_rec->msg_txt, "Unable to execute find query");
        display_entry_error_msg( s_rec);
    }  /* end check for query error */


    res = mysql_use_result( Passed_Conn);

    row = mysql_fetch_row( res);

    if ( row == NULL)
    {
        strcpy( s_rec->msg_txt, "No rows in query result");
        display_entry_error_msg( s_rec);
    }  /* end test for no rows in select */

    //
    //  Parse date string from YYYY-MM-DD to YYYYMMDD
    //

    memset( s_rec, ' ', sizeof( struct entry_screen_struct));
    memset( work_str, '\0', sizeof( work_str));
    strcpy( work_str, row[0]);

    l_x = strlen( work_str);
    l_z = 0;
    for (l_y=0; l_y < l_x; l_y++)
    {
        if ( work_str[l_y] != '-')
        {
            s_rec->draw_dt[l_z] = work_str[l_y];
            l_z++;
        }  /* end test for acceptable characters to copy */

    }  /* end for l_y loop */

    strcpy( work_str, row[1]);
    memcpy( s_rec->no_1, work_str, strlen( work_str));

    strcpy( work_str, row[2]);
    memcpy( s_rec->no_2, work_str, strlen( work_str));

    strcpy( work_str, row[3]);
    memcpy( s_rec->no_3, work_str, strlen( work_str));

    strcpy( work_str, row[4]);
    memcpy( s_rec->no_4, work_str, strlen( work_str));

    strcpy( work_str, row[5]);
    memcpy( s_rec->no_5, work_str, strlen( work_str));

    strcpy( work_str, row[6]);
    memcpy( s_rec->mega_no, work_str, strlen( work_str));

    mysql_free_result( res);

    mysql_commit( Passed_Conn);

}  /* end find_mega_record */

/*;;;;;
 *      Subroutine to update a record from the MEGA indexed file
 *;;;;;
 */
void update_mega_record( struct entry_screen_struct *s_rec,
                         struct drawing_record *m_z)
{
    int     l_x;
    char    yyyy_str[5], mm_str[5], dd_str[5], work_str[1024];

    retrieve_entry_data( s_rec, m_z);

    memset( yyyy_str, '\0', sizeof( yyyy_str));
    memset( mm_str, '\0', sizeof( mm_str));
    memset( dd_str, '\0', sizeof( dd_str));

    memcpy( yyyy_str, m_z->draw_dt, 4);
    memcpy( mm_str, &m_z->draw_dt[4], 2);
    memcpy( dd_str, &m_z->draw_dt[6], 2);

    sprintf( work_str, "UPDATE DRAWING_DATA SET NO_1=%d,\
                         NO_2=%d, NO_3=%d, NO_4=%d,\
                         NO_5=%d, MEGA_NO=%d\
                         WHERE DRAW_DT='%s-%s-%s' LIMIT 1;",
              m_z->no_1, m_z->no_2, m_z->no_3, m_z->no_4,
              m_z->no_5, m_z->mega_no, yyyy_str, mm_str, dd_str);

    l_x = mysql_query( Passed_Conn, work_str);

    if ( l_x != 0)
    {
        sprintf( s_rec->msg_txt, "%s", mysql_error( Passed_Conn));
        display_entry_error_msg( s_rec);
    }  
    else
    {
        memset( s_rec, ' ', sizeof( struct entry_screen_struct));
    }  /* end check for successful update */

    mysql_commit( Passed_Conn);

}  /* end delete_mega_record */

/*;;;;;
 *  Subroutine to convert screen text to binary data record
 *;;;;;
 */
void retrieve_entry_data( struct entry_screen_struct *s_rec,
                          struct drawing_record *m_z)
{
    char    work_str[255];

    memcpy( m_z->draw_dt, s_rec->draw_dt, sizeof( m_z->draw_dt));

    memset( work_str, '\0', sizeof( work_str));

    memcpy( work_str, s_rec->no_1, sizeof( s_rec->no_1));
    m_z->no_1 = atol( work_str);

    memcpy( work_str, s_rec->no_2, sizeof( s_rec->no_2));
    m_z->no_2 = atol( work_str);

    memcpy( work_str, s_rec->no_3, sizeof( s_rec->no_3));
    m_z->no_3 = atol( work_str);

    memcpy( work_str, s_rec->no_4, sizeof( s_rec->no_4));
    m_z->no_4 = atol( work_str);

    memcpy( work_str, s_rec->no_5, sizeof( s_rec->no_5));
    m_z->no_5 = atol( work_str);

    memcpy( work_str, s_rec->mega_no, sizeof( s_rec->mega_no));
    m_z->mega_no = atol( work_str);

}  /* end retrieve_entry_data subroutine */

/*;;;;;
 *  Subroutine to display error message to user
 *;;;;;
 */
void display_entry_error_msg( struct entry_screen_struct *s_rec)
{
    int         l_x;
    char        work_str[255];

    $DESCRIPTOR( str_desc, work_str);
    $DESCRIPTOR( fld_name_desc, "MSG_TXT");
    
    POINTER( str_desc) = s_rec->msg_txt;
    LENGTH( str_desc) = sizeof( s_rec->msg_txt);

    l_x = FDV$BELL();

    l_x = FDV$PUT( &str_desc, &fld_name_desc);

    l_x = FDV$WAIT();

    memset( s_rec->msg_txt, ' ', sizeof( s_rec->msg_txt));
    l_x = FDV$PUT( &str_desc, &fld_name_desc);

}  /* end display_entry_error_msg subroutine */
 
/*;;;;;
 *  Function will be used as a UAR by FMS
 *;;;;;
 */
int DRAWING_RANGE()
{
    char    form_name_str[31], uar_vals[80], field_name[31],
            data_line[132], work_str[255];
    int     l_terminator, l_tca_ptr, l_workspace_ptr, l_cursor_pos,
            l_ins_over, l_help_num, l_x, l_fldidx, ret_val;

    $DESCRIPTOR( form_name_desc, form_name_str);
    $DESCRIPTOR( uar_vals_desc, uar_vals);
    $DESCRIPTOR( field_name_desc, field_name);
    $DESCRIPTOR( data_line_desc, data_line);

    //
    //  Set up default return value
    //
    ret_val = FDV$K_UVAL_FAIL;

    //
    //  Obtain UAR information
    //
    l_x = FDV$RETCX( &l_tca_ptr, &l_workspace_ptr, &form_name_desc,
                     &uar_vals_desc, &l_cursor_pos, &l_terminator,
                     &l_ins_over, &l_help_num);
    //
    //  What field are we in
    //
    l_x = FDV$RETFN( &field_name_desc, &l_fldidx);

    //
    //  Obtain the field data
    //
    memset( data_line, '\0', sizeof( data_line));

    l_x = FDV$RET( &data_line_desc, &field_name_desc, &l_fldidx);

    memset( work_str, '\0', sizeof( work_str));
    memcpy( work_str, data_line, 2);

    l_x = atol( work_str);

    if ( l_x >= 1  &&  l_x <= 52)
        ret_val = FDV$K_UVAL_SUC;

    return ret_val;
    
}  /* end drawing_range function */

// turn on warnings about dollarsign  characters
#pragma message enable (DOLLARID)          

