/*  C_MEGA_MAIL.C
 *
 *  Example program to show a user how to send mail.
 *
 *  Distributed with "The Minimum You Need to Know
 *  to be an OpenVMS Application Developer".
 *
 */

/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>

/*
 *      VMS headers
 */
#include <maildef>
#include <mail$routines>
#include <lib$routines>
#include <descrip>

#define LENGTH(descriptor)      descriptor.dsc$w_length

#pragma message disable( UNSTRUCTMEM)
union item_list
{
    struct 
    {
        short int   buffer_length;
        short int   item_code;
        long        buffer_address;
        long        return_length;
    };
    long    terminator;
};

#pragma message enable( UNSTRUCTMEM)

/*;;;;;
 *  Function prototypes
 *;;;;;
 */
void add_mail_user_dest( int *l_context, char *user_str);
void parse_logical_user( int *l_context, char *user_str);

/*;;;;;
 *  Functions and subroutines
 *;;;;;
 */

int main( int *argc, char **argv)
{
    int     l_stat, l_context;
    char    to_str[255], from_str[255], subject_str[255],
            text_file_str[255], translated_name_str[255],
            work_str[255];

    union item_list mail_item_1[5], mail_item_2[5];

    $DESCRIPTOR( work_str_desc, work_str);
    $DESCRIPTOR( translated_name_desc, translated_name_str);


    //;;;;;
    //  Initialize the send
    //;;;;;
    mail_item_1[0].terminator = 0;
    mail_item_2[0].terminator = 0;
    l_stat = mail$send_begin( &l_context, mail_item_1, mail_item_2);

    if (!(l_stat & 1))
    {
        puts( "Error initializing mail interface");
        printf( "Error code %d\n", l_stat);
        exit( l_stat);
    }  /* end test for successful init */

    //;;;;;
    //  Build the attributes
    //;;;;;
    strcpy( to_str, "MEGA_SUPPORT_LIST");
    strcpy( from_str, "HUGHES");
    strcpy( subject_str, "MEGA SYSTEM NOTIFICATION");

    mail_item_1[0].buffer_length        = strlen( to_str);
    mail_item_1[0].item_code            = MAIL$_SEND_TO_LINE;
    mail_item_1[0].buffer_address       = (long) to_str;    // pointer is really a long, but C
                                                            // knows the difference.  Forces us to 
                                                            // cast to get rid of compilation warning.
    mail_item_1[0].return_length        = 0;


    mail_item_1[1].buffer_length        = strlen( from_str);
    mail_item_1[1].item_code            = MAIL$_SEND_FROM_LINE;
    mail_item_1[1].buffer_address       = (long) from_str;
    mail_item_1[1].return_length        = 0;

    mail_item_1[2].buffer_length        = strlen( subject_str);
    mail_item_1[2].item_code            = MAIL$_SEND_SUBJECT;
    mail_item_1[2].buffer_address       = (long) subject_str;
    mail_item_1[2].return_length        = 0;

    mail_item_1[3].terminator           = 0;

    l_stat = mail$send_add_attribute( &l_context, mail_item_1, mail_item_2);

    if (!(l_stat & 1))
    {
        puts( "Error setting up mail header information");
        printf( "Error code %d\n", l_stat);
        exit( l_stat);
    }  /* end test for failure */


    //;;;;;
    //  Add the message body
    //;;;;;
    strcpy( text_file_str, "HELLO.TXT");

    mail_item_2[0].buffer_length    = strlen( text_file_str);
    mail_item_2[0].item_code        = MAIL$_SEND_FILENAME;
    mail_item_2[0].buffer_address   = (long) text_file_str;
    mail_item_2[0].return_length    = 0;

    mail_item_1[0].terminator       = 0;
    l_stat = mail$send_add_bodypart( &l_context, mail_item_2, mail_item_1);

    if ( !(l_stat & 1))
    {
        puts( "Error creating message body");
        printf( "Error code %d\n", l_stat);
        exit( l_stat);
    }  /* end test for failure */

    //;;;;;
    //  Now we have to actually fill in the address.
    //  Mail does not use the address information setup
    //  in the message header.
    //;;;;;
    memset( translated_name_str, '\0', sizeof( translated_name_str));
    strcpy( work_str, to_str);

    LENGTH( work_str_desc)  = strlen( work_str);

    l_stat = lib$get_logical( &work_str_desc, &translated_name_desc);

    if ( strlen( translated_name_str) < 1)
    {
        //
        //    Destination is not a logical, just add the user
        //
        add_mail_user_dest( &l_context, work_str);
    }
    else
        parse_logical_user( &l_context, translated_name_str);


    //;;;;;
    //  Send the message
    //;;;;;

    memset( mail_item_1, 0, sizeof( mail_item_1));
    memset( mail_item_2, 0, sizeof( mail_item_2));
    l_stat = mail$send_message( &l_context, mail_item_1, mail_item_2);

    if ( !(l_stat & 1))
    {
        puts( "Error sending the mail message");
        printf( "Error code %d\n", l_stat);
        exit( l_stat);
    }  /* end test for failure */

    //;;;;;
    //  Clean up the mail context
    //;;;;;
    l_stat = mail$send_end( &l_context, mail_item_1, mail_item_2);

    if ( !(l_stat & 1))
    {
        puts( "Error ending mail send");
        printf( "Error code %d\n", l_stat);
        exit( l_stat);
    }  /* end test for failure */

    return 1;

}  /* end main */


//;;;;;;;;;;
//  Subroutine to parse the mail destinations from a 
//  translated logical string.
//;;;;;;;;;;
void parse_logical_user( int *l_context, char *user_str)
{
    int     l_stat;
    char    work_str[1024], *tmp, *tmp2;

    strcpy( work_str, user_str);
    tmp = work_str;

    while( strlen( tmp) > 0)
    {
        tmp2 = strchr( tmp, ',');
        if ( tmp2 != NULL)
        {
            *tmp2 = '\0';
        }

        add_mail_user_dest( l_context, tmp);

        if ( tmp2 != NULL)  
            tmp = tmp2+1;
        else
            *tmp = '\0';

    }  /* end while loop */
}  /* end parse_logical_user subroutine */

//;;;;;
//  Subroutine to add a mail user destination to the mail
//  message currently being built.
//;;;;;
void add_mail_user_dest( int *l_context, char *user_str)
{
    int         l_stat;
    short int   w_user_type;

    union item_list m_item[5], r_item[5];

    m_item[0].buffer_length     = strlen( user_str);
    m_item[0].item_code         = MAIL$_SEND_USERNAME;
    m_item[0].buffer_address    = (int) user_str;
    m_item[0].return_length     = 0;

    w_user_type = MAIL$_TO;

    m_item[1].buffer_length     = 2;       // size of a word
    m_item[1].item_code         = MAIL$_SEND_USERNAME_TYPE;
    m_item[1].buffer_address    = (int) &w_user_type;
    m_item[1].return_length     = 0;

    m_item[2].terminator        = 0;
    r_item[0].terminator        = 0;

    l_stat = mail$send_add_address( l_context, m_item, r_item);

    if ( !(l_stat & 1))
    {
        puts( "Error adding mail destination address");
        printf( "Error code %d\n", l_stat);
        exit( l_stat);
    }  /* end test for failure */


}  /* end add_mail_user_dest subroutine */
