/*  C_FILL_IN_LOGICALS.C
 *
 *  Subroutine to fill in the logical names for the
 *  Mega Zillionare example application.
 *
 */

/*
 *  ANSI headers
 */
#include <stdio>
#include <stdlib>
#include <string>

/*
 *  VMS headers
 */
#include <descrip>
#include <lib$routines>

/*
 *      you will find most developers working with descriptors
 *      create these macros.  The allow you to directly manipulate
 *      the only two fields most developers are interested in when it
 *      comes to dealing with descriptors.  The length and the 
 *      address of the data.
 */
#define LENGTH(descriptor)      descriptor.dsc$w_length
#define POINTER(descriptor)     descriptor.dsc$a_pointer


const char *DRAWING_DATA = "MY_MEGA_FILE";
const char *DRAWING_STATS = "DRAWING_STATS";
const char *MEGA_STATS = "MEGA_STATS";

/*
 *      Be lazy in this module and use the 
 *      macro which makes the compiler build the 
 *      descriptor.
 */
$DESCRIPTOR( drawing_data_desc, "MY_MEGA_FILE");
$DESCRIPTOR( drawing_stats_desc, "DRAWING_STATS");
$DESCRIPTOR( mega_stats_desc, "MEGA_STATS");


void c_fill_in_logicals()
{
    char    work_str[255], translated_name[255];
    long    l_x;

    $DESCRIPTOR( translated_name_desc, translated_name);
    $DESCRIPTOR( work_str_desc, work_str);


    memset( work_str, '\0', sizeof( work_str));
    memset( translated_name, '\0', sizeof( work_str));

    l_x = lib$get_logical( &drawing_data_desc, &translated_name_desc);

    if ( translated_name[0] <= ' ')
    {
        strcpy( work_str, DRAWING_DATA);
        strcat( work_str, ".IDX");
        LENGTH( work_str_desc) = strlen( work_str);
        l_x = lib$set_logical( &drawing_data_desc, &work_str_desc);
    }  /* end test for successful translation */


    memset( work_str, '\0', sizeof( work_str));
    memset( translated_name, '\0', sizeof( work_str));

    l_x = lib$get_logical( &drawing_stats_desc, &translated_name_desc);

    if ( translated_name[0] <= ' ')
    {
        strcpy( work_str, DRAWING_STATS);
        strcat( work_str, ".IDX");
        LENGTH( work_str_desc) = strlen( work_str);
        l_x = lib$set_logical( &drawing_stats_desc, &work_str_desc);

    }  /* end test for successful translation */


    memset( work_str, '\0', sizeof( work_str));
    memset( translated_name, '\0', sizeof( work_str));

    l_x = lib$get_logical( &mega_stats_desc, &translated_name_desc);

    if ( translated_name[0] <= ' ')
    {
        strcpy( work_str, MEGA_STATS);
        strcat( work_str, ".IDX");
        LENGTH( work_str_desc) = strlen( work_str);
        l_x = lib$set_logical( &mega_stats_desc, &work_str_desc);

    }  /* end test for successfull translation */

}  /* end c_fill_in_logicals */

