/*  C_DUMP_DRAW_DATA_SUB.C
 *
 *  Subroutine to perform a dump of drawing data to a report
 *  over a range of dates.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>

/*
 *  Our headers
 */
#pragma dictionary "cdd_records.drawing_record"

#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *MEGA_FILE_NAME = "MY_MEGA_FILE";
const char *DUMP_RPT_FILE_NAME = "ZILL_DUMP.RPT";
const char *DEFAULT_NAME = ".IDX";

const int PAGE_SIZE = 60;


/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void build_mega_fab_rab( struct drawing_record *m_z, 
                         struct FAB *m_fab, struct RAB *m_rab,
                         struct XABKEY *m_xab,
                         int access);

void c_fill_in_logicals( void);

int  open_mega_idx( struct drawing_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access);


void write_dump_report_line( int *line_count, 
                             int *page_count, 
                             struct drawing_record *m_z,
                             FILE *rpt_file);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_dump_draw_data_sub( )
{
    int                     l_x, default_operations;
    int                     line_count, page_count;
    char                    command_str[255];
    FILE                    *rpt_file;

    $DESCRIPTOR( command_str_desc, command_str);

    struct  drawing_record  m_z;
    struct  FAB             mega_fab;
    struct  RAB             mega_rab;
    struct  XABKEY          mega_xab;


    line_count = PAGE_SIZE;         // force first page break;
    page_count = 0;

    l_x = open_mega_idx( &m_z, &mega_fab, 
                         &mega_rab, &mega_xab, FAB$M_GET);

    if ( !(l_x & 1))
    {
        puts( "Unable to create report");
        return;
    }  /* end test for failed open */

    rpt_file = fopen( DUMP_RPT_FILE_NAME, "w", 
                      "ctx=rec","mrs=80", "rat=cr", "rfm=var");

    //
    //  Establish a key of reference
    //
    memset( &m_z, ' ', sizeof( m_z));
    mega_rab.rab$l_rop = RAB$M_KGE | RAB$M_WAT | RAB$M_RLK;
    mega_rab.rab$b_ksz = sizeof( m_z.draw_dt);

    l_x = sys$find( &mega_rab);

    mega_rab.rab$l_rop = RAB$M_NXT | RAB$M_WAT | RAB$M_RLK;

    while (l_x & 1)
    {
        l_x = sys$get( &mega_rab);
        if ( l_x & 1)
            write_dump_report_line( &line_count, 
                                    &page_count, 
                                    &m_z,
                                    rpt_file);

    }  /* end while l_x loop */
    

    l_x = sys$close( &mega_fab);

    fclose( rpt_file);

    sprintf( command_str, "EDIT/READ %s", DUMP_RPT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end c_dump_draw_data_sub */

void build_mega_fab_rab( struct drawing_record *m_z, 
                             struct FAB *m_fab, struct RAB *m_rab,
                             struct XABKEY *m_xab, int access)
{
    *m_fab = cc$rms_fab;                                    // fill in defaults for FAB
    m_fab->fab$l_fna = (char *)MEGA_FILE_NAME;          // Pointer to file name
    m_fab->fab$b_fns = strlen(MEGA_FILE_NAME);          // length of name
    m_fab->fab$l_dna = (char *)DEFAULT_NAME;            // default name, really just file type
    m_fab->fab$b_dns = strlen( DEFAULT_NAME);           // length of default name
    m_fab->fab$b_org = FAB$C_IDX;                           // indexed file
    m_fab->fab$b_fac = access;                              // get, put, etc.
    m_fab->fab$w_mrs = sizeof( struct drawing_record);      // maximum record size
    m_fab->fab$b_rat = FAB$M_FTN;                           // FORTRAN formatted records
    m_fab->fab$b_rfm = FAB$C_FIX;                           // fixed length records
    m_fab->fab$b_shr = FAB$M_NIL;                           // no file sharing
    m_fab->fab$l_xab = (void *) m_xab;                      // index block address


    *m_xab = cc$rms_xabkey;                                 // fill in defaults for XAB
    m_xab->xab$b_ref = 0;                                   // primary key is zero
    m_xab->xab$b_nsg = 1;                                   // single segment key
    m_xab->xab$w_pos = 0;                                   // starting position zero in the record
    m_xab->xab$b_siz = 8;                                   // our key is 8 bytes long
    m_xab->xab$b_prolog = XAB$C_PRG3;                       // prolog 3
    m_xab->xab$l_nxt = 0;                                   // end of chain   we only have one key on this file.

    *m_rab = cc$rms_rab;                                    // fill in defaults for RAB
    m_rab->rab$l_fab = m_fab;                               // pointer to FAB
    m_rab->rab$b_rac = RAB$C_KEY;                           // keyed access
    m_rab->rab$b_krf = 0;                                   // access via primary key
    m_rab->rab$l_kbf = m_z->draw_dt;                        // key buffer
    m_rab->rab$l_ubf = (char *)m_z;                         // data buffer for record
    m_rab->rab$l_rbf = (char *)m_z;                         // data buffer for write
    m_rab->rab$w_usz = sizeof( struct drawing_record);
    m_rab->rab$w_rsz = sizeof( struct drawing_record);

}  /* end build_mega_fab_rab subroutine */

int  open_mega_idx( struct drawing_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab, int access)
{
    int         l_x;


    build_mega_fab_rab( m_z, m_fab, 
                        m_rab, m_xab, access);

    //
    //      See if we can open the file.
    //
    l_x = sys$open( m_fab);

    if (!( l_x & 1))
    {
        puts( "Unable to open input file");
        printf( "Result code %d\n", l_x);
        return l_x;
    }  /* end test for failed open */


    //
    //  once the file is open we can connect our
    //  Record Access Block to it.
    //
    l_x = sys$connect( m_rab);

    if (!(l_x & 1))
    {
        puts( "Unable to connect RAB to index");
        printf( "Result code %d\n", l_x);
        l_x = sys$close( m_fab);
        return l_x;

    }  /* end test for failed connection */

    return l_x;

}  /* end open_mega_idx */

void write_dump_page_heading( int *page_count, FILE *rpt_file)
{
    time_t  the_time;
    char    work_str[255];

    
    if (*page_count > 1)
        fprintf( rpt_file, "\f");


    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));
    
    fprintf( rpt_file, "%s %20.20s Drawing Number Report          Page: %d\n",
                work_str, " ", *page_count);
    fprintf( rpt_file, "    Drawing      No   No   No   No   No     Mega\n");
    fprintf( rpt_file, "     Date         1    2    3    4    5      No\n");
    fprintf( rpt_file, "------------     --   --   --   --   --     ----\n");

}  /* end write_dump_page_heading subroutine */

void write_dump_report_line( int *line_count, 
                             int *page_count, 
                             struct drawing_record *m_z,
                             FILE *rpt_file)
{
    char yyyy_str[5], mm_str[3], dd_str[3];
    int         l_x;


    if ( *line_count >= PAGE_SIZE)
    {
        *line_count = 5;
        *page_count = *page_count + 1;
        write_dump_page_heading( page_count, rpt_file);
    }  /* end test for page break */

    //
    //  Move the date into a null terminated string for printing
    //
    memset( yyyy_str, '\0', sizeof( yyyy_str));
    memset( dd_str, '\0', sizeof( dd_str));
    memset( mm_str, '\0', sizeof( mm_str));

    memcpy( yyyy_str, m_z->draw_dt, 4);
    memcpy( mm_str, &m_z->draw_dt[4], 2);
    memcpy( dd_str, &m_z->draw_dt[6], 2);


    fprintf( rpt_file, "%s-%s-%s       %2d   %2d   %2d   %2d   %2d       %2d\n",
               mm_str, dd_str, yyyy_str,
               m_z->no_1,
               m_z->no_2,
               m_z->no_3,
               m_z->no_4,
               m_z->no_5,
               m_z->mega_no);

    *line_count = *line_count + 1;
               
}  /* end write_dump_report_line */

