/*  C_CREATE_STATS_SUB.C
 *
 *  Subroutine to create shiny new stats files
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <lib$routines>
#include <descrip>


#define LENGTH(descriptor)      descriptor.dsc$w_length

/*
 *  Our headers
 */
#pragma member_alignment save
#pragma nomember_alignment
#pragma dictionary "cdd_records.drawing_record"
#pragma dictionary "cdd_records.zillionare_stats_record"
#pragma member_alignment restore


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
extern const char *DRAWING_STATS_NAME;
extern const char *MEGA_STATS_NAME;
extern const char *DEFAULT_NAME;

extern const int ELM_COUNT;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void c_fill_in_logicals( void);

void calc_final_stats( struct zillionare_stats_record *d_stats,
                       struct zillionare_stats_record *m_stats,
                       int l_draw_no);

void initialize_stat_arrays( struct zillionare_stats_record *d_stats,
                             struct zillionare_stats_record *m_stats);

int  open_mega_idx( struct drawing_record *m_z,
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access);

int  open_stats_idx( struct zillionare_stats_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access,
                    const char *file_name);

void update_dstats( struct zillionare_stats_record *m_stats, 
                    int l_no, int l_draw_no);

void update_mstats( struct zillionare_stats_record *m_stats, 
                    int l_no, int l_draw_no);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_create_stats_sub( )
{
    int                     l_x, l_sub, l_draw_no;
    char                    drawing_file_str[255], command_str[255];
    FILE                    *rpt_file;

    $DESCRIPTOR( command_str_desc, command_str);

    struct  drawing_record  draw_rec;

    struct  FAB             mega_fab, d_fab, m_fab;
    struct  RAB             mega_rab, d_rab, m_rab;
    struct  XABKEY          mega_xab, d_xab, m_xab;


    //
    //  Arrays to hold stats records
    //
    struct zillionare_stats_record  d_stats[ ELM_COUNT];
    struct zillionare_stats_record  m_stats[ ELM_COUNT];


    c_fill_in_logicals();

    initialize_stat_arrays( d_stats, m_stats);

    strcpy( command_str, "CREATE/FDL=MEGA_DAT:MEGA_STATS.FDL DRAWING_STATS");
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

    strcpy( command_str, "CREATE/FDL=MEGA_DAT:MEGA_STATS.FDL MEGA_STATS");
    LENGTH( command_str_desc) = strlen( command_str);
    l_x = lib$spawn( &command_str_desc);

    l_x = open_mega_idx( &draw_rec, &mega_fab,
                         &mega_rab, &mega_xab, FAB$M_GET);


    l_x = open_stats_idx( d_stats, &d_fab,
                         &d_rab, &d_xab, FAB$M_PUT,
                         DRAWING_STATS_NAME);

    l_x = open_stats_idx( m_stats, &m_fab,
                          &m_rab, &m_xab, FAB$M_PUT,
                          MEGA_STATS_NAME);

    //
    //  current rabs only filled in for read
    //  fill in size for write.
    //
    d_rab.rab$w_rsz = sizeof( struct zillionare_stats_record);
    m_rab.rab$w_rsz = sizeof( struct zillionare_stats_record);

    //
    //  Turn on sequential access for input file
    //
    mega_rab.rab$l_rop  = RAB$M_WAT | RAB$M_RLK;
    mega_rab.rab$b_rac  = RAB$C_SEQ;

    //
    //  Read through until end of input.
    //  Update each array element as found.
    //
    l_x = 1;
    l_draw_no = 0;

    while ( l_x & 1)
    {
        l_x = sys$get( &mega_rab);

        if ( l_x & 1)
        {
            l_draw_no++;
            update_dstats( d_stats, draw_rec.no_1, l_draw_no);
            update_dstats( d_stats, draw_rec.no_2, l_draw_no);
            update_dstats( d_stats, draw_rec.no_3, l_draw_no);
            update_dstats( d_stats, draw_rec.no_4, l_draw_no);
            update_dstats( d_stats, draw_rec.no_5, l_draw_no);

            update_mstats( m_stats, draw_rec.mega_no, l_draw_no);


            if ( (l_draw_no % 100) == 0)
                printf( "Processed %d records\n", l_draw_no);

        }  /* end test for successful read */

        
    }  /* end while l_x */


    printf( "Processed %d records\n", l_draw_no);     // show final count

    l_x = sys$close( &mega_fab);                    // close the input file

    calc_final_stats( d_stats, m_stats, l_draw_no);

    //
    //  Write the new records
    //
    for( l_sub=0; l_sub < ELM_COUNT; l_sub++)
    {
        d_rab.rab$l_rbf = (void *)&d_stats[ l_sub];

        l_x = sys$put( &d_rab);

        if ( !(l_x & 1))
        {
            printf( "Error %d writing drawing stat\n", l_x);
        }

        m_rab.rab$l_rbf = (void *)&m_stats[ l_sub];

        l_x = sys$put( &m_rab);

        if ( !(l_x & 1))
        {
            printf( "Error %d writing mega stat\n", l_x);
        }

    }  /* end for l_sub loop */


    l_x = sys$close( &d_fab);
    l_x = sys$close( &m_fab);


}  /* end c_create_stats_sub */

/*;;;;;
 *  Subroutine to initialize the arrays which will be written to disk.
 *;;;;;
 */
void initialize_stat_arrays( struct zillionare_stats_record *d_stats,
                             struct zillionare_stats_record *m_stats)
{
    int     l_x;

    for (l_x=0; l_x < ELM_COUNT; l_x++)
    {
        memset( &d_stats[ l_x], 0, sizeof( struct zillionare_stats_record));

        d_stats[ l_x].elm_no        = l_x + 1;
        d_stats[ l_x].pct_hits      = 0.0;
        d_stats[ l_x].ave_btwn      = 0.0;


        memset( &m_stats[ l_x], 0, sizeof( struct zillionare_stats_record));

        m_stats[ l_x].elm_no        = l_x + 1;
        m_stats[ l_x].pct_hits      = 0.0;
        m_stats[ l_x].ave_btwn      = 0.0;

    }  /* end for l_x loop */

}  /* end initialize_stat_arrays subroutine */

/*;;;;;
 *  Subroutine to update a drawing stats record
 *;;;;;
 */
void update_dstats( struct zillionare_stats_record *d_stats, 
                    int l_no, int l_draw_no)
{
    int     l_since, l_sub;


    l_sub   = l_no - 1;
    l_since = l_draw_no - d_stats[ l_sub].last_draw_no;

    //
    //  Sequence or random hit
    //
    if ( l_since == 1)
    {
        d_stats[ l_sub].curr_seq++;
        if ( d_stats[ l_sub].curr_seq > d_stats[ l_sub].longest_seq)
            d_stats[ l_sub].longest_seq = d_stats[ l_sub].curr_seq;
    }
    else
    {
        d_stats[ l_sub].curr_seq = 0;
        if ( l_since > d_stats[ l_sub].max_btwn)
            d_stats[ l_sub].max_btwn = l_since;

    }  /* end test for sequence or random hit */

    d_stats[ l_sub].hit_count++;
    d_stats[ l_sub].last_draw_no = l_draw_no;
    d_stats[ l_sub].since_last = l_since;

}  /* end update_dstats subroutine */

/*;;;;;
 *  Subroutine to update a drawing stats record
 *;;;;;
 */
void update_mstats( struct zillionare_stats_record *m_stats, 
                    int l_no, int l_draw_no)
{
    int     l_since, l_sub;


    l_sub   = l_no - 1;
    l_since = l_draw_no - m_stats[ l_sub].last_draw_no;

    //
    //  Sequence or random hit
    //
    if ( l_since == 1)
    {
        m_stats[ l_sub].curr_seq++;
        if ( m_stats[ l_sub].curr_seq > m_stats[ l_sub].longest_seq)
            m_stats[ l_sub].longest_seq = m_stats[ l_sub].curr_seq;
    }
    else
    {
        m_stats[ l_sub].curr_seq = 0;
        if ( l_since > m_stats[ l_sub].max_btwn)
            m_stats[ l_sub].max_btwn = l_since;

    }  /* end test for sequence or random hit */

    m_stats[ l_sub].hit_count++;
    m_stats[ l_sub].last_draw_no = l_draw_no;
    m_stats[ l_sub].since_last = l_since;

}  /* end update_mstats subroutine */

/*;;;;;
 *  Subroutine to calculate final drawing stats information
 *;;;;;
 */
void calc_final_stats( struct zillionare_stats_record *d_stats,
                       struct zillionare_stats_record *m_stats,
                       int l_draw_no)
{
    int     l_x, l_missed;
    double  d_1, d_2;

    for( l_x=0; l_x < ELM_COUNT; l_x++)
    {
        d_1 = d_stats[ l_x].hit_count;
        d_2 = l_draw_no;

        l_missed = l_draw_no - d_stats[ l_x].hit_count;

        d_stats[ l_x].pct_hits = (double) d_stats[ l_x].hit_count / (double) l_draw_no;

        d_stats[ l_x].ave_btwn = (double) l_missed / 
                                 (double) d_stats[ l_x].hit_count;

        d_stats[ l_x].since_last = l_draw_no - d_stats[ l_x].last_draw_no;


        d_1 = m_stats[ l_x].hit_count;
        d_2 = l_draw_no;

        l_missed = l_draw_no - m_stats[ l_x].hit_count;

        m_stats[ l_x].pct_hits = (double) m_stats[ l_x].hit_count / (double) l_draw_no;

        m_stats[ l_x].ave_btwn = (double) l_missed / 
                                 (double) m_stats[ l_x].hit_count;

        m_stats[ l_x].since_last = l_draw_no - m_stats[ l_x].last_draw_no;


    }  /* end for l_x loop */


}  /* end calc_final_stats subroutine */
