#   BASIC_MEGA.MMS
#
#   MMS Description file for Mega Zillionare example application.
#
#
#   Define our macro sybmols
# 
.SUFFIXES  .INC .INC~

.SILENT

.IFDEF DEBUG
BFLAGS = /NOOPT/DEBUG/OBJECT=MEGA_OBJ:
LFLAGS = /DEBUG/EXE=MEGA_EXE:
.ELSE
BFLAGS = /OBJECT=MEGA_OBJ:
LFLAGS = /EXE=MEGA_EXE:
.ENDIF

CMSFLAGS = /NOHISTORY/NOLOG
SAY = WRITE SYS$OUTPUT

.INC~.INC :
  IF "$(MMS$CMS_LIBRARY)" .nes. "" THEN $(CMS) SET LIBRARY $(MMS$CMS_LIBRARY)
  $(CMS) FETCH $(MMS$CMS_ELEMENT) /OUTPUT=$(MMS$TARGET_NAME).INC \
    $(CMSFLAGS) 

.BAS.OBJ :
    BASIC $(BFLAGS) $<


#
#   Directives
#

.FIRST
    SAY "STARTING MEGA ZILLIONARE BUILD"
    COPY MEGA_CMS_REF:*.COM MEGA_COM:*.*;0   !update command files
    PURGE/KEEP=2 MEGA_COM:
    COPY MEGA_CMS_REF:*.FDL MEGA_DAT:*.*;0   !update fdl files
    PURGE/KEEP=2 MEGA_DAT:

.LAST
    PURGE/KEEP=2 MEGA_EXE:
    PURGE/KEEP=2 MEGA_OBJ:
    SAY "MEGA ZILLIONARE BUILD COMPLETE"


.DEFAULT
  $(SAY) "Encountered an unknown dependancy directive:"
  $(SAY) " $@ : $+"

#
#   Targets
#

!
!   When you do not specify a target to build MMS
!   build the first target it finds.  Always make this your
!   complete application and life will be good.
!
MEGA_ZILLIONARE DEPENDS_ON  \
    MEGA_OBJ:MEGA_CDO.TXT   \
    MEGA_TEXT_LIB           \
    MEGA_ZILL               \
    MEGA_OBJ_LIB            \
    MEGA_EXE:BASIC_ZILL_MENU.EXE

    $(SAY) "Mega_Zillionare Complete"

!
!   We use the txt file to get a file with a time stamp
!   that MMS can use in comparison.  If any of the dependancy files
!   have a newer date than the txt file, we will rebuild the CDD.
!
MEGA_OBJ:MEGA_CDO.TXT  DEPENDS_ON   MEGA_FIELDS.CDO \
        MEGA_RECORDS.CDO \
        MEGA_COM:MEGA_REBUILD_CDD.COM

    @MEGA_COM:MEGA_REBUILD_CDD
    COPY NL: MEGA_OBJ:MEGA_CDO.TXT


MEGA_TEXT_LIB DEPENDS_ON FDVDEF.INC MEGA_RECS.INC
    LIB/CREATE/TEXT MEGA_TEXT_LIB
    LIB/INSERT/TEXT MEGA_TEXT_LIB FDVDEF.INC
    LIB/INSERT/TEXT MEGA_TEXT_LIB MEGA_RECS.INC

MEGA_ZILL DEPENDS_ON                     \
            ZILL_BROWSE.FRM     \
            ZILL_ENTRY.FRM      \
            ZILL_ENTRY2.FRM     \
            ZILL_MENU.FRM

    FMS/LIBRARY/CREATE MEGA_ZILL ZILL_BROWSE.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY2.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_MENU.FRM


MEGA_OBJ_LIB DEPENDS_ON \
            MEGA_OBJ:BASIC_CREATE_STATS_SUB.OBJ \
            MEGA_OBJ:BASIC_DUMP_DRAW_DATA_SUB.OBJ \
            MEGA_OBJ:BASIC_ZILL_BROWSE_SUB.OBJ \
            MEGA_OBJ:BASIC_ZILL_DUE_REPORT_SUB.OBJ \
            MEGA_OBJ:BASIC_ZILL_ENTRY_SUB.OBJ \
            MEGA_OBJ:BASIC_ZILL_IMPORT_SUB.OBJ \
            MEGA_OBJ:BASIC_ZILL_MOST_REPORT_SUB.OBJ 

    LIB/CREATE MEGA_OBJ_LIB
    LIB/INSERT MEGA_OBJ_LIB MEGA_OBJ:BASIC_CREATE_STATS_SUB, -
        MEGA_OBJ:BASIC_DUMP_DRAW_DATA_SUB,                   -
        MEGA_OBJ:BASIC_ZILL_BROWSE_SUB,                      -
        MEGA_OBJ:BASIC_ZILL_DUE_REPORT_SUB,                  -
        MEGA_OBJ:BASIC_ZILL_ENTRY_SUB,                       -
        MEGA_OBJ:BASIC_ZILL_IMPORT_SUB,                      -
        MEGA_OBJ:BASIC_ZILL_MOST_REPORT_SUB

MEGA_EXE:BASIC_ZILL_MENU.EXE DEPENDS_ON  \
        MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ    \
        MEGA_OBJ:BASIC_ZILL_MENU.OBJ     \
        MEGA_OBJ_LIB

    LINK $(LFLAGS) MEGA_OBJ:BASIC_ZILL_MENU.OBJ, -
        MEGA_OBJ:MEGA_ZILL_VECTOR, MEGA_OBJ_LIB/LIB

#
#   Lesser targets
#
MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ DEPENDS_ON MEGA_ZILL
    FMS/VECTOR/OUTPUT=MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ MEGA_ZILL


MEGA_OBJ:BASIC_CREATE_STATS_SUB.OBJ  DEPENDS_ON \
            BASIC_CREATE_STATS_SUB.BAS          \
            MEGA_TEXT_LIB


MEGA_OBJ:BASIC_DUMP_DRAW_DATA_SUB.OBJ DEPENDS_ON \
            BASIC_DUMP_DRAW_DATA_SUB.BAS         \
            MEGA_TEXT_LIB

MEGA_OBJ:BASIC_ZILL_BROWSE_SUB.OBJ DEPENDS_ON   \
            BASIC_ZILL_BROWSE_SUB.BAS           \
            MEGA_TEXT_LIB

MEGA_OBJ:BASIC_ZILL_DUE_REPORT_SUB.OBJ DEPENDS_ON   \
            BASIC_ZILL_DUE_REPORT_SUB.BAS           \
            MEGA_TEXT_LIB

MEGA_OBJ:BASIC_ZILL_ENTRY_SUB.OBJ DEPENDS_ON    \
            BASIC_ZILL_ENTRY_SUB.BAS            \
            MEGA_TEXT_LIB

MEGA_OBJ:BASIC_ZILL_IMPORT_SUB.OBJ DEPENDS_ON   \
            BASIC_ZILL_IMPORT_SUB.BAS           \
            MEGA_TEXT_LIB

MEGA_OBJ:BASIC_ZILL_MOST_REPORT_SUB.OBJ DEPENDS_ON  \
            BASIC_ZILL_MOST_REPORT_SUB.BAS          \
            MEGA_TEXT_LIB


