1   SUB BAS_SQLM_ZILL_DUE_REPORT_SUB
    OPTION TYPE=EXPLICIT
    !
    !	BAS_SQLM_ZILL_DUE_REPORT_SUB.BAS
    !
    !	program to report off the drawing
    !   and Mega numbers which are due.  Numbers reported
    !   will appear in descending order by SINCE_LAST.
    !
    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY
    %INCLUDE "SYS$LIBRARY:SQL_LITERALS.BAS"

    !;;;;;;;;;;
    !	Constants
    !;;;;;;;;;;
    DECLARE BYTE CONSTANT   rpt_chan%   = 11%

    DECLARE BYTE CONSTANT   elm_count% = 52%

    DECLARE STRING CONSTANT report_name$ = "ZILL_DUE.RPT"

    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;
    MAP (LOCAL_MAP) STRING  TRANSLATED_NAME$ = 255%

    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE BYTE    B_DONE%
    DECLARE WORD    W_X%
    DECLARE LONG    L_X%, L_ERR%, L_END%, SQLCODE%

    DECLARE STRING  WORK_STR$, LOG_TXT$

    DECLARE BYTE    ELM_NO
    DECLARE LONG    HIT_COUNT, LAST_DRAW_NO, SINCE_LAST, CURR_SEQ, LONGEST_SEQ, MAX_BTWN
    DECLARE GFLOAT  PCT_HITS, AVE_BTWN

    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;

100 L_ERR% = 0%

    GOSUB A910_OPEN_FILES

    IF SQLCODE% = 0%
    THEN
	GOSUB A940_GENERATE_REPORT
    END IF

    GOTO PROGRAM_EXIT

910 !;;;;;;;;;;
    !	Subroutine to open indexed files
    !;;;;;;;;;;
 A910_OPEN_FILES:

        WHEN ERROR IN
            L_ERR% = 0%
            OPEN report_name$ FOR OUTPUT AS FILE # rpt_chan%,   &
                RECORDTYPE LIST,                                &
                ACCESS WRITE
        USE
            L_ERR% = ERR
            PRINT "Error opening report file for output"
            PRINT "Error: ";L_ERR%;" ";ERT$( L_ERR%)
        END WHEN

        CALL OPEN_DUE_DRAW( SQLCODE%)
        PRINT "Result of Draw open";SQLCODE%
        CALL OPEN_DUE_MEGA( SQLCODE%)
        PRINT "Result of Mega Open";SQLCODE%

    RETURN

940 !;;;;;;;;;;
    !       Subroutine to generate the report
    !       No need for page breaks when will will have less
    !       than the number of lines a page can hold.
    !;;;;;;;;;;
 A940_GENERATE_REPORT:

        WORK_STR$ = "Due Numbers Report"
        L_X% = 40% - (LEN( WORK_STR$) / 2%)     ! size needed to center

        !;;;;;
	!	First Heading line
	!;;;;;
	PRINT #rpt_chan%, "DATE: ";DATE$(0%);
	PRINT #rpt_chan%, TAB( L_X%);WORK_STR$;TAB( 71%);"PAGE: ";
	PRINT #rpt_chan%, FORMAT$( 1%, "###")

        PRINT #rpt_chan%, " "
        WORK_STR$ = "Regular Drawing Numbers"
        L_X% = 40% - (LEN( WORK_STR$) / 2%)     ! size needed to center
        PRINT #rpt_chan%, TAB( L_X%);WORK_STR$
        PRINT #rpt_chan%, " "
        PRINT #rpt_chan%, " "

        !;;;;;
        !   Column headings
        !;;;;;
        PRINT #rpt_chan%, "No   Hits   Since   Pct_hits   Ave_btwn"
        PRINT #rpt_chan%, "--   ----   -----   --------   --------"

        WHILE (SQLCODE% = 0%)
                CALL FETCH_DUE_DRAW( SQLCODE%, ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN)
                IF SQLCODE% = 0% THEN
                    PRINT #rpt_chan% USING "##   ####   ####     ##.###    ##.###", &
                                ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN
                END IF
        NEXT

        !;;;;;;;;;;
        !       Second page for Mega numbers
        !;;;;;;;;;;
        PRINT #rpt_chan%, FF
        WORK_STR$ = "Due Numbers Report"
        L_X% = 40% - (LEN( WORK_STR$) / 2%)     ! size needed to center
	PRINT #rpt_chan%, "DATE: ";DATE$(0%);
	PRINT #rpt_chan%, TAB( L_X%);WORK_STR$;TAB( 71%);"PAGE: ";
	PRINT #rpt_chan%, FORMAT$( 2%, "###")

        PRINT #rpt_chan%, " "
        WORK_STR$ = "Mega Numbers"
        L_X% = 40% - (LEN( WORK_STR$) / 2%)     ! size needed to center
        PRINT #rpt_chan%, TAB( L_X%);WORK_STR$
        PRINT #rpt_chan%, " "
        PRINT #rpt_chan%, " "

        !;;;;;
        !   Column headings
        !;;;;;
        PRINT #rpt_chan%, "No   Hits   Since   Pct_hits   Ave_btwn"
        PRINT #rpt_chan%, "--   ----   -----   --------   --------"
                          
        SQLCODE% = 0%

        WHILE (SQLCODE% = 0%)
                CALL FETCH_DUE_MEGA( SQLCODE%, ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN)
                IF SQLCODE% = 0% THEN
                PRINT #rpt_chan% USING "##   ####   ####     ##.###    ##.###", &
                                ELM_NO, HIT_COUNT, SINCE_LAST, PCT_HITS, AVE_BTWN
                END IF
        NEXT

        CALL CLOSE_MOST_DRAW( SQLCODE%)
        CALL CLOSE_MOST_MEGA( SQLCODE%)
        CALL COMMIT_MEGA( SQLCODE%)

    RETURN


32767	!  End of module
 PROGRAM_EXIT:

        WHEN ERROR IN
            CLOSE #rpt_chan%
        USE
        END WHEN

        WORK_STR$ = "EDIT/READ " + report_name$

        L_X% = LIB$SPAWN( WORK_STR$)

	END SUB

