1   SUB BAS_SQLM_DUMP_DRAW_DATA_SUB
    OPTION TYPE=EXPLICIT
    !
    !	BAS_SQLM_DUMP_DRAWING_DATA.BAS
    !
    !	Program to dump off a date range of records
    !	From the drawing data IDX file.
    !
    %INCLUDE "LIB$ROUTINES" %FROM %LIBRARY 
    %INCLUDE "$LIBDTDEF" %FROM %LIBRARY

    %INCLUDE "SYS$LIBRARY:SQL_LITERALS.BAS"

    !;;;;;;;;;;
    !	Constants
    !;;;;;;;;;;
    DECLARE BYTE CONSTANT   rpt_chan% = 12%

    DECLARE LONG CONSTANT   page_size% = 55%

    DECLARE STRING CONSTANT rpt_file$ = "DRAWING.RPT"
    !;;;;;;;;;;
    !	Maps
    !;;;;;;;;;;
    MAP (LOCAL_MAP) STRING  TRANSLATED_NAME$ = 255%,	&
			    FILE_NAME$	     = 255%,    &
                            WORK_DATE_STR$   = 8%

    !;;;;;;;;;;
    !	Local Variables
    !;;;;;;;;;;
    DECLARE BYTE    B_EOF%
    DECLARE WORD    W_X%
    DECLARE LONG    L_X%, L_ERR%, L_DRAW_NO%, L_MISSED%, L_SUB%,    &
		    LINE_CNT%, PAGE_CNT%

    DECLARE STRING  WORK_STR$, LOG_TXT$, BEG_DATE$, END_DATE$, DISPLAY_DT$

    DECLARE BASIC$QUADWORD  DRAW_DT, BEG_DATE_QUAD, END_DATE_QUAD
    DECLARE BYTE            NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
    DECLARE WORD            TIM_BUFF(8%)
    DECLARE LONG            L_DATE_CONTEXT%, L_COMPONENT%, L_DEFAULTS%, SQLCODE%, &
                            L_DATE_COMPARE_CONTEXT%,L_DATE_COMPARE_CONTEXT_IN%
    !;;;;;;;;;;
    !	Main Logic
    !;;;;;;;;;;
100 L_ERR% = 0%

    GOSUB A910_OPEN_FILES

    TIM_BUFF(0%) = 1970%
    TIM_BUFF(1%) = 1%
    TIM_BUFF(2%) = 1%

    L_DATE_CONTEXT% = 0%
    L_COMPONENT% = LIB$K_OUTPUT_FORMAT
    L_DEFAULTS% = 127%

    L_X% = LIB$INIT_DATE_TIME_CONTEXT( L_DATE_CONTEXT%, L_COMPONENT%, '|!Y4-!MN0-!D0|')

    L_DATE_COMPARE_CONTEXT% = 0%
    L_COMPONENT% = LIB$K_OUTPUT_FORMAT
    L_DEFAULTS% = 127%

    L_X% = LIB$INIT_DATE_TIME_CONTEXT( L_DATE_COMPARE_CONTEXT%, L_COMPONENT%, '|!Y4!MN0!D0|')


    L_DATE_COMPARE_CONTEXT_IN% = 0%
    L_COMPONENT% = LIB$K_INPUT_FORMAT
    L_DEFAULTS% = 127%

    L_X% = LIB$INIT_DATE_TIME_CONTEXT( L_DATE_COMPARE_CONTEXT_IN%, L_COMPONENT%, '|!Y4!MN0!D0 !H04!M0!S0!C2|')

    IF L_ERR% = 0%
    THEN
	GOSUB A930_GET_DATE_RANGE
	GOSUB A940_CREATE_REPORT
    END IF

    GOTO PROGRAM_EXIT

910 !;;;;;;;;;;
    !	Subroutine to open indexed files
    !;;;;;;;;;;
 A910_OPEN_FILES:

912        OPEN rpt_file$ FOR OUTPUT AS FILE #rpt_chan%,    &
                ORGANIZATION SEQUENTIAL VARIABLE,           &
                RECORDTYPE LIST,			    &
		RECORDSIZE 80%

922         CALL OPEN_ALL_DRAW( SQLCODE%)
            PRINT "Result of opening cursor"; SQLCODE%

929 RETURN

930 !;;;;;;;;;;
    !	Subroutine to obtain date ranges for report
    !;;;;;;;;;;
 A930_GET_DATE_RANGE:
	PRINT 
	PRINT
	BEG_DATE$ = " "
	INPUT "Enter beginning date format YYYYMMDD: ";BEG_DATE$

	!
	!   Don't allow a null entry to cause an error
	!
	IF BEG_DATE$ <= " "
	THEN
	    BEG_DATE$ = ""
	END IF

	PRINT
	PRINT
        PRINT "If you enter a month for ending date, you must enter day as well"
        PRINT "The default will be the first day of the month"
	END_DATE$ = " "
	INPUT "Enter ending date format YYYYMMDD: ";END_DATE$

	IF END_DATE$ <= " "
	THEN
	    END_DATE$ = "TODAY"
	END IF

        L_X% = LIB$CONVERT_DATE_STRING( BEG_DATE$, BEG_DATE_QUAD, L_DATE_COMPARE_CONTEXT_IN%, L_DEFAULTS%, TIM_BUFF())
        L_X% = LIB$CONVERT_DATE_STRING( END_DATE$, END_DATE_QUAD, L_DATE_COMPARE_CONTEXT_IN%, L_DEFAULTS%, TIM_BUFF())


        BEG_DATE$ = "          "            ! pre-extend beg_date$
        L_X% = LIB$FORMAT_DATE_TIME( BEG_DATE$, BEG_DATE_QUAD, L_DATE_COMPARE_CONTEXT%)
        END_DATE$ = "          "
        L_X% = LIB$FORMAT_DATE_TIME( END_DATE$, END_DATE_QUAD, L_DATE_COMPARE_CONTEXT%)

        PRINT "Begining date: ";BEG_DATE$
        PRINT "Ending date: ";END_DATE$
    RETURN

940 !;;;;;;;;;;
    !	Subroutine to actually create the report
    !;;;;;;;;;;
 A940_CREATE_REPORT:

	L_ERR% = 0%
        CALL FETCH_ALL_DRAW( SQLCODE%, DRAW_DT, NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO)

	B_EOF% = 0%

	LINE_CNT% = page_size%	    ! force page break on first line
	PAGE_CNT% = 0%

942	WHILE SQLCODE% = 0%  AND  B_EOF% = 0%
            !
            !  Put date in string form for comparison
            !
            L_X% = LIB$FORMAT_DATE_TIME( WORK_DATE_STR$, DRAW_DT, L_DATE_COMPARE_CONTEXT%)

	    IF WORK_DATE_STR$ > END_DATE$
	    THEN
		B_EOF% = 1%
	    ELSE
              IF WORK_DATE_STR$ >= BEG_DATE$
              THEN
		GOSUB B1000_PRINT_RPT_LINE
              END IF
	    END IF

            CALL FETCH_ALL_DRAW( SQLCODE%, DRAW_DT, NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO)

	NEXT

949 RETURN

1000	!;;;;;;;;;;
	!   Subroutine to print a detail line
	!;;;;;;;;;;
 B1000_PRINT_RPT_LINE:
	    GOSUB C2000_PAGE_HEADING	IF LINE_CNT% >= page_size%

	    LINE_CNT% = LINE_CNT% + 1%

            L_X% = LIB$FORMAT_DATE_TIME( DISPLAY_DT$, DRAW_DT, L_DATE_CONTEXT%)

	    PRINT #rpt_chan% USING "    'LLLLLLLLL     ##   ##   ##   ##   ##     ##", &
		DISPLAY_DT$,                                                     &
		NO_1,								 &
		NO_2,								 &
		NO_3,								 &
		NO_4,								 &
		NO_5,								 &
		MEGA_NO

	RETURN

2000	!;;;;;;;;;;
	!	Subroutine to print a page heading
	!;;;;;;;;;;
 C2000_PAGE_HEADING:
	    PRINT # rpt_chan%, FF	IF PAGE_CNT% >  0%

	    PAGE_CNT% = PAGE_CNT% + 1%

	    WORK_STR$ = "Drawing Number Report"
	    L_X% = 40% - (LEN( WORK_STR$) / 2%)    ! size of TAB needed to center

	    !;;;;;
	    !	First Heading line
	    !;;;;;
	    PRINT #rpt_chan%, "DATE: ";DATE$(0%);
	    PRINT #rpt_chan%, TAB( L_X%);WORK_STR$;TAB( 71%);"PAGE: ";
	    PRINT #rpt_chan%, FORMAT$( PAGE_CNT%, "###")

	    !;;;;;
	    !	Column Headings
	    !;;;;;
	    PRINT #rpt_chan%, " "
	    PRINT #rpt_chan%, "     Drawing      NO   NO   NO   NO   NO     MEGA"
	    PRINT #rpt_chan%, "      Date         1    2    3    4    5      NO"
	    PRINT #rpt_chan%, "   ------------    --   --   --   --   --    ----"
	    PRINT #rpt_chan%, " "

	    LINE_CNT% = 0%

	RETURN


32767	!  End of module
 PROGRAM_EXIT:

	CLOSE #rpt_chan%
        CALL CLOSE_ALL_DRAW( SQLCODE%)
        CALL COMMIT_MEGA( SQLCODE%)

        L_X% = LIB$FREE_DATE_TIME_CONTEXT( L_DATE_CONTEXT%)
        L_X% = LIB$FREE_DATE_TIME_CONTEXT( L_DATE_COMPARE_CONTEXT%)
        L_X% = LIB$FREE_DATE_TIME_CONTEXT( L_DATE_COMPARE_CONTEXT_IN%)

        WORK_STR$ = "EDIT/READ " + rpt_file$
        L_X% = LIB$SPAWN( WORK_STR$)

	END SUB
