/*      TEST_MYSQL.C
 *
 *  Simple program to test connecting to our database and 
 *  dropping tables.
 *
 */

/*
 *      ANSI headers
 */
#include <stdio.h>
#include <stdlib>
#include <string.h>

/*
 *  MySQL headers
 */
#include <mysql.h>

/*
 *  VMS headers
 */
#include <descrip>
#include <lib$routines>

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
MYSQL   *Conn;


/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void prompt_password( char *dest_pwd);



/*;;;;;
 *  Main module
 *;;;;;
 */
int main( int *argc, char **argv)
{
    int     l_err_flg, l_try_count;
    char    the_password[1024];

    //  step 1 is to initialize MySQL.
    //  Later versions will add mysql_library_init() which
    //  must be called prior to this init.
    //
    Conn = mysql_init( NULL);

    if ( Conn == NULL)
    {
        printf( "Unable to connect to MySQL\n");
        return -1;
    }  /* end test for successful init */

    //
    //  Step 2:  Obtain a password for the user
    //           reading the password this way will
    //           not echo the password.
    //
    memset( the_password, '\0', sizeof( the_password));
    l_err_flg = -1;
    l_try_count = 0;

    while ( strlen( the_password) < 1  &&  l_err_flg != 0  && l_try_count < 5)
    {
        l_err_flg = 0;
        prompt_password( the_password);
        if ( mysql_real_connect( Conn, 
                    NULL, 
                    NULL, 
                    the_password, 
                    "mega_zillionare",
                    0,
                    NULL,
                    0) == NULL)
        {
            l_err_flg = mysql_errno( Conn);
            printf( "mysql_real_connect() failed:\nError: %u (%s)\n",
                l_err_flg, mysql_error(Conn));
        }
        l_try_count++;

    }  /* end while loop to get password and connect */

    puts( "Connected to database server");
    l_err_flg = mysql_query( Conn, "drop table drawing_data");
    printf( "Result of dropping drawing_data %d\n", l_err_flg);
    l_err_flg = mysql_commit( Conn);

    l_err_flg = mysql_query( Conn, "drop table draw_stats");
    printf( "Result of dropping draw_stats %d\n", l_err_flg);
    l_err_flg = mysql_commit( Conn);


    l_err_flg = mysql_query( Conn, "drop table mega_stats");
    printf( "Result of dropping mega_stats %d\n", l_err_flg);
    l_err_flg = mysql_commit( Conn);

    mysql_close( Conn);

    return 1;
}  /* end main module */


void prompt_password( char *dest_pwd)
{
    int     l_x;
    char    db_password[255];

    $DESCRIPTOR( no_echo_desc, "SET TERM/NOECHO");
    $DESCRIPTOR( echo_desc, "SET TERM/ECHO");


    memset( db_password, '\0', sizeof( db_password));
    printf( "Enter Password: ");

    l_x = lib$spawn( &no_echo_desc);

    scanf( "%s", db_password);
    puts( " ");     // the new line will be lost on input

    l_x = lib$spawn( &echo_desc);

    strcpy( dest_pwd, db_password);
}  /* end prompt_password subroutine */
