$!  MEGA_REBUILD_CDD.COM
$!
$!  Command file to delete all definitions found in 
$!  the CDD for the Mega_Zillionare demo application
$!  then repopulate the CDD from script files.
$!
$!
$ a = f$trnlnm( "MEGA_CDD_PATH")
$ if "''a'" .les. ""
$ then
$       write sys$output "Need to define MEGA environment"
$       write sys$output "Cannot run without the logicals"
$       goto exit_program
$ endif
$!
$!
$ write sys$output "Purging Records and Fields", F$TIME()
$!
$ cdo
set default mega_cdd_path
start_transaction
purge RECORD records.*.
commit
start_transaction
purge FIELD fields.*.
commit
exit
$!
$!  The commit of the PURGE statements can take a while
$!  to complete.  Since CDO doesn't have a WAIT
$!  statement we exit CDO and break up the deletions.
$!
$ write sys$output "Deleting Records", F$TIME()
$!
$ cdo
set default mega_cdd_path
start_transaction
delete RECORD/log records.*.
commit
exit
$!
$!  We have to let the record deletion occur first.
$!  If you try to delete the fields first you will get
$!  errors from CDD telling you item is in use and
$!  cannot be deleted.
$!
$ wait 00:00:10
$!
$ write sys$output "Deleting Fields", F$TIME()
$!
$ cdo
set default mega_cdd_path.fields
start_transaction
delete FIELD/descendants/log no_1.
delete FIELD/descendants/log no_2.
delete FIELD/descendants/log no_3.
delete FIELD/descendants/log no_4.
delete FIELD/descendants/log no_5.
commit
delete FIELD/descendants/log *.
commit
exit
$!
$ wait 00:00:10
$!
$ write sys$output "Rebuilding", F$TIME()
$!
$ cdo
set default mega_cdd_path
!
!   have to create fields prior to records
!
@mega_cms_ref:mega_fields.cdo
!
@mega_cms_ref:mega_records.cdo
exit
$!
$exit_program:
$ exit
