$!  MEGA_ENVIRONMENT.COM
$!
$!  Command file to map onto the logical name table for 
$!  the mega_zillionare application.
$!
$!  Required parameters:
$!  P1      environment code "D01", "T01", "S01", or "P01"
$!
$ bell[0,7] = %x07
$!
$ say :== WRITE SYS$OUTPUT
$!
$!;;;;;
$!  Make sure user supplied a parameter
$!;;;;;
$ if "''p1'" .eqs. ""
$ then
$   say bell, bell, bell
$   say "you must supply P1 of D01, T01, S01, or P01
$   goto exit_program
$ endif
$!
$!;;;;;
$!  Validate the parameter
$!;;;;;
$ env_str = f$edit( "''p1'", "COLLAPSE,UPCASE")
$ if env_str .eqs. "D01" then goto good_parm
$ if env_str .eqs. "T01" then goto good_parm
$ if env_str .eqs. "S01" then goto good_parm
$ if env_str .eqs. "P01" then goto good_parm
$!
$!   Supplied parameter invalid
$!
$ say bell, bell, bell
$ SAY "you must supply P1 of D01, T01, S01, or P01
$ goto exit_program
$!
$!;;;;;
$!  Set up environment
$!;;;;;
$good_parm:
$ tab_name = "MEGA_''env_str'_TABLE"
$ new_search_list = ""
$!
$!  See if there is a process directory translation for lnm$file_dev
$!
$! set verify
$ a = f$trnlnm( "lnm$file_dev", "lnm$process_directory")
$ if "''a'" .nes. ""
$ then
$   dir_name = "lnm$process_directory"
$ else
$   dir_name = "lnm$system_directory"
$ endif
$!
$ gosub build_new_search
$!
$!  get rid of trailing comma and space
$!
$ l = f$length( "''new_search_list'") - 2
$ final_search_list = f$extract( 0, 'l', "''new_search_list'")
$!
$ define/table=lnm$process_directory lnm$file_dev 'final_search_list'
$!
$!;;;;;
$!      Logicals added during CDD Chapter
$!      rdb logicals added during the rdb chapter.
$!;;;;;
$!
$   define  cdd_path            mega_cdd_path, bega_cdd_path, mega_rdb_path
$   define  cdd_records         cdd_path.records
$   define  cdd_fields          cdd_path.fields
$   define  cdd_rdb             mega_rdb_path
$!
$ cms set lib mega_cms
$!
$ goto exit_program
$!
$!;;;;;;;;;;
$!  Subroutine to build the new search list from the process level
$!  translation.
$!;;;;;;;;;;
$build_new_search:
$!
$   my_index = 0
$p_top:
$       a = f$trnlnm( "lnm$file_dev", "''dir_name'", my_index)
$       if "''a'" .nes. ""
$       then
$           a = f$edit( "''a'", "COLLAPSE,UPCASE")
$           if "''a'" .nes. "''tab_name'"
$           then
$               new_search_list = new_search_list + a + ", "
$           endif
$!
$           if my_index .eq. 0 then new_search_list = new_search_list + tab_name + ", "
$!
$           my_index = my_index + 1
$!
$           goto p_top
$       endif
$!
$ return
$!
$exit_program:
$! set noverify
$ exit
