        SUBROUTINE FTN_SQLM_DUMP_DRAW_DATA_SUB
        IMPLICIT NONE

!
!       Subroutine to create a report of drawing data.
!
	INCLUDE '(LIB$ROUTINES)'

!;;;;;
!       Constants we need
!;;;;;
	INTEGER*1   K_RPT_CHAN
        PARAMETER( K_RPT_CHAN=5)

	INTEGER     K_PAGE_SIZE
	PARAMETER( K_PAGE_SIZE=55)

	CHARACTER*22    RPT_FILE
	PARAMETER( RPT_FILE='DRAWING.RPT')

!;;;;;
!	Local variables
!;;;;;
	INTEGER*4       PAGE_COUNT, LINE_COUNT, L_ERR, SQLCODE, L_X, L_Y
	CHARACTER*8     BEG_DATE_STR, END_DATE_STR
        CHARACTER*27    DRAW_DT_STR
	LOGICAL         EOF_LG
	CHARACTER*255   COMMAND_STR
        INTEGER*8       BEG_DT_QUAD, END_DT_QUAD, DRAW_DT_QUAD
        INTEGER*1       NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO
        INTEGER*2       TIM_BUFF(8) /0,0,0,0,0,0,0,0/

!;;;;;;;;;;
!	Main Logic
!;;;;;;;;;;
 200	OPEN (UNIT=K_RPT_CHAN, STATUS='NEW', FILE=RPT_FILE, DISP='KEEP',FORM='FORMATTED')

!;;;;;;;;;;
!	Need to obtain beginning and ending dates
!;;;;;;;;;;
 300	PRINT *
	PRINT *
	BEG_DATE_STR = ' '
	PRINT *, 'Enter beginning date, format YYYYMMDD: '
	PRINT *, 'Default is null'
	READ (*, '(A)') BEG_DATE_STR

	IF (BEG_DATE_STR(1:1) .LE. ' ') THEN
	    BEG_DATE_STR = ''
	END IF

	PRINT *
	PRINT *
	END_DATE_STR = ' '
	PRINT *, 'Enter ENDING date, format YYYYMMDD: '
	PRINT *, 'Default is TODAY'
	READ (*, '(A)') END_DATE_STR

	IF (END_DATE_STR(1:1) .LE. ' ') THEN
	    END_DATE_STR = 'TODAY'
	END IF

        !
        !  Change the display date format by tweaking the logical locally
        !  This is a cheap trick.  When you are in a hurry it works.
        !  The correct method is to use LIB$INIT_DATE_TIME_CONTEXT
        !  and pass a context variable into each lib$format_date_time() call.
        !  Tweaking the logical like this effects all output.
        !
        L_X = LIB$SET_LOGICAL( 'LIB$DT_FORMAT', 'LIB$DATE_FORMAT_029')
        L_X = LIB$SET_LOGICAL( 'LIB$DT_INPUT_FORMAT', '|!Y4!MN0!D0 !H04!M0!S0!C2|')


        !   Let the operating system create a quad for us.
        !   This array will provide default values for all time fields.
        !
        TIM_BUFF(1) = 1970
        TIM_BUFF(2) = 1
        TIM_BUFF(3) = 1

        L_Y = 127       ! allow defaults for all date time fields

        IF ( BEG_DATE_STR(1:1) .LE. ' ') THEN
            L_X = LIB$CONVERT_DATE_STRING( '', BEG_DT_QUAD, ,L_Y, TIM_BUFF)
        ELSE
            L_X = LIB$CONVERT_DATE_STRING( BEG_DATE_STR, BEG_DT_QUAD, ,L_Y, TIM_BUFF)
        END IF

        L_X = LIB$FORMAT_DATE_TIME( DRAW_DT_STR, BEG_DT_QUAD)

        !
        TIM_BUFF(1) = 9999
        TIM_BUFF(2) = 12
        TIM_BUFF(3) = 31
 330    L_X = LIB$CONVERT_DATE_STRING( END_DATE_STR, END_DT_QUAD, ,L_Y, TIM_BUFF)


!;;;;;;;;;;
!	Generate the report
!;;;;;;;;;;
 500	EOF_LG = .FALSE.
	LINE_COUNT = K_PAGE_SIZE    
	PAGE_COUNT = 0

        !
        !  Open the complete cursor
        !
        CALL OPEN_ALL_DRAW( SQLCODE)

	DO 550 WHILE (EOF_LG .EQ. .FALSE.)

            CALL FETCH_ALL_DRAW( SQLCODE, DRAW_DT_QUAD, NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO)
            SELECT CASE( SQLCODE)
                CASE (0)
                    ! good fetch, nothing to do
                CASE (100)
                    EOF_LG = .TRUE.
                CASE DEFAULT
                    EOF_LG = .TRUE.
                    PRINT *, 'Result of fetching row', SQLCODE
            END SELECT


	    IF ( DRAW_DT_QUAD .GT. END_DT_QUAD) THEN
	        EOF_LG = .TRUE.
            ELSE
            IF ( DRAW_DT_QUAD .GE. BEG_DT_QUAD  .AND. EOF_LG .EQ. .FALSE.) THEN
	        IF (LINE_COUNT .GE. K_PAGE_SIZE) THEN
	            PAGE_COUNT = PAGE_COUNT + 1
	            CALL FTN_DUMP_PAGE_HEAD( PAGE_COUNT, K_RPT_CHAN)
	            LINE_COUNT = 0
	        END IF

                L_Y = LIB$FORMAT_DATE_TIME( DRAW_DT_STR, DRAW_DT_QUAD)

	        LINE_COUNT = LINE_COUNT + 1
	        WRITE (K_RPT_CHAN, 551), DRAW_DT_STR, &
                      NO_1, NO_2, NO_3, NO_4, NO_5, MEGA_NO


	    END IF  ! end test for date >= beg_dt_quad
            END IF  ! end test for date > end_dt_quad

 550	CONTINUE

 551    FORMAT (T4,A10,'    ',5(I2,'   '),'  ',I2)

 552	CALL CLOSE_ALL_DRAW( SQLCODE)
        CALL COMMIT_MEGA( SQLCODE)

	CLOSE (K_RPT_CHAN, STATUS='KEEP')

 	COMMAND_STR = 'EDIT/READ '//RPT_FILE
	CALL LIB$SPAWN( COMMAND_STR)

	GO TO 1000

 1000   CONTINUE

        !
        !  Don't leave logical hanging around
        !
        L_X = LIB$DELETE_LOGICAL( 'LIB$DT_FORMAT')
        L_X = LIB$DELETE_LOGICAL( 'LIB$DT_INPUT_FORMAT')

	RETURN
	END

!
!	Subroutine to print the page heading
!
	SUBROUTINE FTN_DUMP_PAGE_HEAD( PAGE_COUNT, RPT_CHAN)
	IMPLICIT NONE

	  INTEGER*4 PAGE_COUNT
	  INTEGER*1 RPT_CHAN


 	CHARACTER*8 DATE_STR, FORM_STR
	LOGICAL     FIRST_PAGE, IS_OPEN

	INQUIRE( RPT_CHAN, OPENED=IS_OPEN, FORMATTED=FORM_STR)

!
!	Page title
!
	CALL DATE_AND_TIME( DATE_STR)

	FIRST_PAGE = PAGE_COUNT .EQ. 1

	IF (.NOT. FIRST_PAGE) THEN
	    WRITE( UNIT=RPT_CHAN, FMT='(A)') CHAR(12)
	END IF


	WRITE (UNIT=RPT_CHAN, FMT=1012) DATE_STR(5:6), DATE_STR(7:8), DATE_STR(1:4), PAGE_COUNT


 1012   FORMAT ('DATE: ',A2,'/',A2,'/',A4, T30, 'Drawing Number Report', T71, 'Page: ', I3)

!
!	Column headings
!
	WRITE (UNIT=RPT_CHAN, FMT='(A)'), ' '

	WRITE (UNIT=RPT_CHAN, FMT='(A)'), '     Drawing     No   No   No   No   No     Mega'

	WRITE (UNIT=RPT_CHAN,FMT='(A)'), '      Date        1    2    3    4    5      No'

	WRITE (UNIT=RPT_CHAN,FMT='(A)'), '   ------------  --   --   --   --   --     ----'

	WRITE (UNIT=RPT_CHAN,FMT='(A)'), ' '

	RETURN
	END
