#   FORTRAN_SFO_MEGA.MMS
#
#   MMS Description file for Mega Zillionare example application.
#
#
#   Define our macro sybmols
#
.SILENT

.IFDEF DEBUG
FFLAGS = /NOOPT/DEBUG/OBJECT=MEGA_OBJ:/WARNING=(NOALIGNMENT)
LFLAGS = /DEBUG/EXE=MEGA_EXE:/MAP
.ELSE
FFLAGS = /OBJECT=MEGA_OBJ:/WARNING=(NOALIGNMENT)
LFLAGS = /EXE=MEGA_EXE:/MAP
.ENDIF

CMSFLAGS = /NOHISTORY/NOLOG
SAY = WRITE SYS$OUTPUT

.F90.OBJ :
    FORTRAN $(FFLAGS) $<

.SFO.OBJ :
    SFOR /OBJECT=MEGA_OBJ:/WARNING=(NOALIGNMENT) $<

#
#   Directives
#

.FIRST
    SAY "STARTING MEGA ZILLIONARE BUILD"
    COPY MEGA_CMS_REF:*.COM MEGA_COM:*.*;0   !update command files
    PURGE/KEEP=2 MEGA_COM:
    COPY MEGA_CMS_REF:*.FDL MEGA_DAT:*.*;0   !update fdl files
    PURGE/KEEP=2 MEGA_DAT:
    $ SFOR :== $SQL$PRE/FORTRAN

.LAST
    PURGE/KEEP=2 MEGA_EXE:
    PURGE/KEEP=2 MEGA_OBJ:
    SAY "MEGA ZILLIONARE BUILD COMPLETE"

.DEFAULT
  $(SAY) "Encountered an unknown dependancy directive:"
  $(SAY) " $@ : $+"

#
#   Targets
#

!
!   When you do not specify a target to build MMS
!   build the first target it finds.  Always make this your
!   complete application and life will be good.
!
MEGA_ZILLIONARE DEPENDS_ON  \
    MEGA_OBJ:MEGA_CDO.TXT   \
    MEGA_TEXT_LIB           \
    MEGA_ZILL               \
    MEGA_OBJ_LIB            \
    MEGA_EXE:FTN_SFO_ZILL_MENU.EXE

    $(SAY) "Mega_Zillionare Complete"

!
!   We use the txt file to get a file with a time stamp
!   that MMS can use in comparison.  If any of the dependancy files
!   have a newer date than the txt file, we will rebuild the CDD.
!
MEGA_OBJ:MEGA_CDO.TXT  DEPENDS_ON   MEGA_FIELDS.CDO \
        MEGA_RECORDS.CDO \
        MEGA_COM:MEGA_REBUILD_CDD.COM

    @MEGA_COM:MEGA_REBUILD_CDD
    COPY NL: MEGA_OBJ:MEGA_CDO.TXT

MEGA_TEXT_LIB DEPENDS_ON \
                FDVDEF_FTN.FOR 

    LIB/CREATE/TEXT MEGA_TEXT_LIB
    LIB/INSERT/TEXT MEGA_TEXT_LIB FDVDEF_FTN.FOR

MEGA_ZILL DEPENDS_ON                     \
            ZILL_BROWSE.FRM     \
            ZILL_ENTRY.FRM      \
            ZILL_ENTRY2.FRM     \
            ZILL_MENU.FRM

    FMS/LIBRARY/CREATE MEGA_ZILL ZILL_BROWSE.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_ENTRY2.FRM
    FMS/LIBRARY/INSERT MEGA_ZILL ZILL_MENU.FRM


MEGA_OBJ_LIB DEPENDS_ON \
            MEGA_OBJ:FTN_SFO_CREATE_STATS_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_DUMP_DRAW_DATA_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_ZILL_BROWSE_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_ZILL_DUE_REPORT_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_ZILL_ENTRY_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_ZILL_IMPORT_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_ZILL_MOST_RPT_SUB.OBJ \
            MEGA_OBJ:FTN_SFO_DUMP_PAGE_HEAD.OBJ \
            MEGA_OBJ:FTN_SFO_UPDATE_DRAW_STATS.OBJ \
            MEGA_OBJ:FTN_SFO_UPDATE_MEGA_STATS.OBJ \
            MEGA_OBJ:FTN_SFO_BROWSE_USER_ACTION.OBJ \
            MEGA_OBJ:FTN_SFO_LOAD_BROWSE_DISPLAY.OBJ \
            MEGA_OBJ:FTN_SFO_RETRIEVE_ENTRY_DATA.OBJ \
            MEGA_OBJ:FTN_SFO_DISPLAY_ENTRY_ERROR.OBJ \
            MEGA_OBJ:DRAWING_RANGE.OBJ

    LIB/CREATE MEGA_OBJ_LIB
    LIB/INSERT MEGA_OBJ_LIB MEGA_OBJ:FTN_SFO_CREATE_STATS_SUB, -
        MEGA_OBJ:FTN_SFO_DUMP_DRAW_DATA_SUB,                   -
        MEGA_OBJ:FTN_SFO_ZILL_BROWSE_SUB,                      -
        MEGA_OBJ:FTN_SFO_ZILL_DUE_REPORT_SUB,                  -
        MEGA_OBJ:FTN_SFO_ZILL_ENTRY_SUB,                       -
        MEGA_OBJ:FTN_SFO_ZILL_IMPORT_SUB,                      -
        MEGA_OBJ:FTN_SFO_ZILL_MOST_RPT_SUB,                 -
        MEGA_OBJ:FTN_SFO_DUMP_PAGE_HEAD,                       -
        MEGA_OBJ:FTN_SFO_UPDATE_DRAW_STATS,                    -
        MEGA_OBJ:FTN_SFO_UPDATE_MEGA_STATS,                    -
        MEGA_OBJ:FTN_SFO_BROWSE_USER_ACTION,                   -
        MEGA_OBJ:FTN_SFO_LOAD_BROWSE_DISPLAY,                  -
        MEGA_OBJ:FTN_SFO_RETRIEVE_ENTRY_DATA,                  -
        MEGA_OBJ:FTN_SFO_DISPLAY_ENTRY_ERROR,                  -
        MEGA_OBJ:DRAWING_RANGE

MEGA_EXE:FTN_SFO_ZILL_MENU.EXE DEPENDS_ON  \
        MEGA_OBJ:FTN_SFO_ZILL_MENU.OBJ     \
        MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ \
        MEGA_OBJ_LIB

    LINK $(LFLAGS) MEGA_OBJ:FTN_SFO_ZILL_MENU.OBJ, -
        MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ, MEGA_OBJ_LIB/LIB, SQL$USER/LIB

#
#   Lesser targets
#
MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ DEPENDS_ON MEGA_ZILL
    FMS/VECTOR/OUTPUT=MEGA_OBJ:MEGA_ZILL_VECTOR.OBJ MEGA_ZILL
    $(SAY) "Vector object created"


MEGA_OBJ:FTN_SFO_CREATE_STATS_SUB.OBJ  DEPENDS_ON \
            FTN_SFO_CREATE_STATS_SUB.SFO          \
            MEGA_TEXT_LIB


MEGA_OBJ:FTN_SFO_DUMP_DRAW_DATA_SUB.OBJ DEPENDS_ON \
            FTN_SFO_DUMP_DRAW_DATA_SUB.SFO         \
            MEGA_TEXT_LIB

MEGA_OBJ:FTN_SFO_ZILL_BROWSE_SUB.OBJ DEPENDS_ON   \
            FTN_SFO_ZILL_BROWSE_SUB.SFO           \
            MEGA_TEXT_LIB

MEGA_OBJ:FTN_SFO_ZILL_DUE_REPORT_SUB.OBJ DEPENDS_ON   \
            FTN_SFO_ZILL_DUE_REPORT_SUB.SFO           \
            MEGA_TEXT_LIB

MEGA_OBJ:FTN_SFO_ZILL_ENTRY_SUB.OBJ DEPENDS_ON    \
            FTN_SFO_ZILL_ENTRY_SUB.SFO            \
            MEGA_TEXT_LIB

MEGA_OBJ:FTN_SFO_ZILL_IMPORT_SUB.OBJ DEPENDS_ON   \
            FTN_SFO_ZILL_IMPORT_SUB.SFO           \
            MEGA_TEXT_LIB

MEGA_OBJ:FTN_SFO_ZILL_MOST_RPT_SUB.OBJ DEPENDS_ON  \
            FTN_SFO_ZILL_MOST_RPT_SUB.SFO          \
            MEGA_TEXT_LIB

MEGA_OBJ:FTN_SFO_DUMP_PAGE_HEAD.OBJ DEPENDS_ON \
            FTN_SFO_DUMP_PAGE_HEAD.SFO

MEGA_OBJ:FTN_SFO_UPDATE_DRAW_STATS.OBJ DEPENDS_ON \
            FTN_SFO_UPDATE_DRAW_STATS.SFO

MEGA_OBJ:FTN_SFO_UPDATE_MEGA_STATS.OBJ DEPENDS_ON \
            FTN_SFO_UPDATE_MEGA_STATS.SFO

MEGA_OBJ:FTN_SFO_BROWSE_USER_ACTION.OBJ DEPENDS_ON \
            FTN_SFO_BROWSE_USER_ACTION.SFO

MEGA_OBJ:FTN_SFO_LOAD_BROWSE_DISPLAY.OBJ DEPENDS_ON \
            FTN_SFO_LOAD_BROWSE_DISPLAY.SFO

MEGA_OBJ:FTN_SFO_RETRIEVE_ENTRY_DATA.OBJ DEPENDS_ON \
            FTN_SFO_RETRIEVE_ENTRY_DATA.SFO

MEGA_OBJ:FTN_SFO_DISPLAY_ENTRY_ERROR.OBJ DEPENDS_ON \
            FTN_SFO_DISPLAY_ENTRY_ERROR.SFO

MEGA_OBJ:DRAWING_RANGE.OBJ DEPENDS_ON \
            DRAWING_RANGE.SFO

