/*  FMS_PROTOTYPES.HXX
 *
 *  Copyright (c) 2005 Logikal Solutions
 *
 *  This file is for use only by persons directly owning a legally purchased 
 *  copy of 
 *  "The Minimum You Know to be an OpenVMS Application Developer".  It is
 *  not to be distributed in whole or in part, or posted anywhere on the web.
 *
 *  The prototypes declared here come with no warranty expressed or implied.
 *  Those calls which were used in the example programs work as they were used
 *  in those example programs.  The others have been cobbled together from
 *  aging memory and even more aging documentation.
 *
 *  Header file containing C language prototypes for FMS calls.
 *
 *  C doesn't give us an optional keyword for prototyping.
 *  In order to make this header clean and not invoke __va_list style
 *  calling I will use the "..." varying argument prototype, then document
 *  the type and order of the optional parameters.
 */

#include <descrip>
#include <fdvdef.h>

/*
 *  The descrip.h header file only provides us with one macro for creating
 *  descriptors on the file.  This macro creates only string descriptors.
 *  In order to make life more livable, we need a macro to create array
 *  descriptors.  We will steal a macro I've seen many times at various
 *  locations.  
 *
 *  BE WARNED!  This macro only works for integer arrays!  Note the 
 *  type of DSC$K_DTYPE_L.  If you want to make a generic array descriptor
 *  macro, you need 2 additional parameters.  The first is the C data type
 *  and the second is the DSC$K_DTYPE_x constant to use.  You would put 
 *  your value for "c_data_type" inside the sizeof() call and your 
 *  DTYPE_X value in place of DSC$K_DTYPE_L.
 */

#define $DESCRIPTORA(name,array)   struct dsc$descriptor_a \
name = { sizeof (long), DSC$K_DTYPE_L, \
DSC$K_CLASS_A, array, 0, 0, { 0, 0, 0, 0, 0 }, 1, sizeof array }

#pragma message disable( DOLLARID)

/*;;;;;;;;;;
 *  Defined as functions in FMS
 *;;;;;;;;;;
 */
extern "C" int fdv$adlva( int *video_attribute);

extern "C" int fdv$afcx( int *ins_overstrike, int *cursor_pos, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *field_name_str
//      int *field_index


extern "C" int fdv$afva( int *video_attribute, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *field_name_str
//      int *field_index



/*;;;;;;;;;;
 *  Defined as callable subroutines in FMS
 *  As we have seen in FORTRAN, they can be declared as 
 *  functions which return FMS$STATUS.
 *;;;;;;;;;;
 */
extern "C" int fdv$aterm( struct dsc$descriptor_a *tca_array,
               int *size,
               int *channel, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *term_name
//      struct dsc$descriptor_s *batch_term_name
//      int *options


extern "C" int fdv$awksp( struct dsc$descriptor_a *workspace_array,
               int *size);


extern "C" int fdv$bell( void);

extern "C" int fdv$cancl( void);

extern "C" int fdv$cdisp( struct dsc$descriptor_s *form_name_str, ...);
//
//  trailing optional parameters
//      int *offset

extern "C" int fdv$clear( ...);
//
//  trailing optional parameters
//      int *line
//      int *line_count


extern "C" int fdv$clear_va( void);

extern "C" int fdv$del( struct dsc$descriptor_a *form_name_str);

extern "C" int fdv$dfkbd( struct dsc$descriptor_a *word_key_array,
               int *elm_count);

extern "C" int fdv$disp( struct dsc$descriptor_s *form_name_str, ...);
//
//  trailing optional parameters
//      int *offset

extern "C" int fdv$dispw( ...);
//
//  trailing optional parameters
//      int *offset


extern "C" int fdv$dpcom( ...);
//
//  trailing optional parameters
//      int *decimal_point_mode

extern "C" int fdv$dwksp( struct dsc$descriptor_a *workspace_array);

extern "C" int fdv$fchan( int *channel);

extern "C" int fdv$fix_screen( void);

extern "C" int fdv$get( struct dsc$descriptor_s *text_destination,
             int *terminator_destination,
             struct dsc$descriptor_s *field_name, ...);
//
//  trailing optional parameter
//      int *field_index

extern "C" int fdv$getaf( struct dsc$descriptor_s *text_destination,
               int *terminator_destination,
               struct dsc$descriptor_s *end_field_name, ...);
//
//  trailing optional parameter
//      int *end_field_index

extern "C" int fdv$getal( ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *text_destination,
//      int *terminator_destination,
//      struct dsc$descriptor_s *start_field_name,
//      int *start_index

extern "C" int fdv$getdl( struct dsc$descriptor_s *text_destination,
               int *terminator_destination, ...);
//
//  trailing optional parameters
//      int *line
//      struct dsc$descriptor_s *prompt_text

extern "C" int fdv$getsc( struct dsc$descriptor_s *field_name_str,
               struct dsc$descriptor_s *fld_value_dest, ...);
//
//  trailing optional parameters
//      int *terminator_dest

extern "C" int fdv$iltrm( int *terminator_mode);

extern "C" int fdv$lchan( int *channel);

extern "C" int fdv$lclos( void );

extern "C" int fdv$ledof( int *led_number);

extern "C" int fdv$ledon( int *led_number);

extern "C" int fdv$load( struct dsc$descriptor_s *form_name_str);

extern "C" int fdv$lopen( struct dsc$descriptor_s *form_library_name, ...);
//
//  trailing optional parameters
//      int *channel

extern "C" int fdv$ndisp( void);

extern "C" int fdv$pft( ...);
//
//  trailing optional parameters
//      int *field_terminator
//      struct dsc$descriptor_s *field_name_str
//      struct dsc$descriptor_s *field_value_str
//      struct dsc$descriptor_s *current_field_name_dest
//      int *current_field_index_dest

extern "C" int fdv$print_screen( int *output_type, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *file_name_str

extern "C" int fdv$put( struct dsc$descriptor_s *field_value_str,
             struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      int *field_index

extern "C" int fdv$putal( ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *form_values_str

extern "C" int fdv$putd( struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      int *field_index

extern "C" int fdv$putda( void);

extern "C" int fdv$putl( struct dsc$descriptor_s *test_line_str, ...);
//
//  trailing optional parameters
//      int *line

extern "C" int fdv$putsc( struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *field_value_str

extern "C" int fdv$read( struct dsc$descriptor_s *form_name_str,
              void *buffer_address,
              int *buffer_size,
              int *form_size_dest);

extern "C" int fdv$ret( struct dsc$descriptor_s *field_value_dest,
             struct dsc$descriptor_s *field_name_str, ...);
//
//  trailing optional parameters
//      int *field_index

extern "C" int fdv$retcx( int *tca_address_dest,
               int *workspace_address_dest,
               struct dsc$descriptor_s *form_name_dest,
               struct dsc$descriptor_s *url_value_dest,
               int *cursor_pos_dest,
               int *terminator_dest,
               int *ins_overstrike_dest,
               int *help_num_dest);

extern "C" int fdv$retdi( int *named_data_index,
               struct dsc$descriptor_s *named_data_text_dest,...);
//
//  trailing optional parameters
//      struct dsc$descriptor_s *named_data_name_dest)

extern "C" int fdv$retdn( struct dsc$descriptor_s *named_data_name_str,
               struct dsc$descriptor_s *named_data_text_dest,...);
//
//  trailing optional parameters
//      int *named_data_index_dest

extern "C" int fdv$retfl( int *line_number,
               struct dsc$descriptor_s *text_value_dest,
               int *line_length_dest, ...);
//
//  trailing optional parameters
//      int *type_of_line_in

extern "C" int fdv$retfn( struct dsc$descriptor_s *field_name_str,...);
//
//  trailing optional parameters
//      int *field_index_dest

extern "C" int fdv$retfo( int *field_number,
               struct dsc$descriptor_s *field_name_dest,
               int *field_index_dest);

extern "C" int fdv$retle( int *field_length_dest,
               struct dsc$descriptor_s *field_name_dest,
               int *field_index_dest);

extern "C" int fdv$rfrsh( void);

extern "C" int fdv$scr_length( int *screen_length);

extern "C" int fdv$sigop( void);

extern "C" int fdv$spada( int *numeric_or_app_flag);

extern "C" int fdv$spoff( void);

extern "C" int fdv$ssigq( int *signal_mode);

extern "C" int fdv$ssrv( int *fms_status_dest, ...);
//
//  trailing optional parameter
//      int *rms_status_dest

extern "C" int fdv$stat( int *fms_status_dest, ...);
//
//  trailing optional parameter
//      int *rms_status_dest

extern "C" int fdv$sterm( struct dsc$descriptor_a *tca_array);

extern "C" int fdv$stime( int *time_out_value);

extern "C" int fdv$swksp( struct dsc$descriptor_a *workspace_array);

extern "C" int fdv$tchan( int *channel);

extern "C" int fdv$dterm( struct dsc$descriptor_a *tca_array);

extern "C" int fdv$user_refresh( ...);
//
//  trailing optional parameters
//      void *refresh_routine

extern "C" int fdv$wait( ...);
//
//  trailing optional parameters
//      int *terminator_dest

#pragma message enable( DOLLARID)


