$!  DCL_IMPORT_EXAMPLE.COM
$!
$!  Command file to import a flat text file of comma seperated values
$!  in the form of draw_dt, no_1, no_2, no_3, no_4, no_5, mega_no
$!  convert the date from mm/dd/yyyy to yyyymmdd, then write the values
$!  to a newly created indexed file.
$!
$!  We make the assumption here that all files will reside in the local
$!  directory.
$!
$!;;;;;;;;;;
$!  Step 1  Don't show the execution unless we are in batch
$!;;;;;;;;;;
$ verify_val = f$verify()
$!
$ the_mode = f$mode()
$!
$ if "''the_mode'" .eqs. "BATCH"
$ then
$   set verify
$ else
$   set noverify
$ endif
$!
$  my_status = 1	    ! set default exit to success
$  my_step = 1		    ! symbol to tell us what step had the error
$!
$!;;;;;;;;;;
$!  Step 2  Turn off system errors, we must check internally
$!;;;;;;;;;;
$!
$ my_step = 2
$ set noon	! this is pronounced no on, not "noon" 
$		! when you turn off the default error 
$		! trapping you must check the symbol $STATUS
$		! for errors.
$!;;;;;;;;;;
$!  Step 3  Create output file
$!;;;;;;;;;;
$ my_step = 3
$ create/fdl=drawing_data.fdl my_mega_file.idx
$!
$!;;;;;;;;;;
$!  Step 4  Open the input file
$!;;;;;;;;;;
$!
$ my_step = 4
$ open/read txt_file drawing_data.txt
$ if .NOT. $STATUS
$ then
$   my_status = $STATUS
$   goto error_exit
$ endif
$!
$!;;;;;;;;;;
$!  Step 5  Open the output file
$!	    use /read on the line along with /write so 
$!	    the file just created is actually used.
$!;;;;;;;;;;
$!
$ my_step = 5
$ open/read/write idx_file my_mega_file.idx
$ if .NOT. $STATUS
$ then
$	my_status = $STATUS
$	goto error_exit
$ endif
$!
$!;;;;;;;;;;
$!  Step 6  Process the file
$!;;;;;;;;;;
$!
$ my_step = 6
$ read_loop_top:
$   read/end_of_file=eof_txt txt_file line_in
$   if .NOT. $STATUS
$   then
$	my_status = $STATUS
$	goto error_exit
$   endif
$   write sys$output "input", line_in
$   !;;;;;
$   !	obtain the date
$   !;;;;;
$   comma_pos = F$locate( ",", line_in)
$   the_len = comma_pos
$   date_str = f$extract( 0, the_len, "''line_in'")
$   !
$   gosub format_date	! call a subroutine to change date format
$   !;;;;;
$   !	get rid of data we already processed
$   !;;;;;
$   start_pos = comma_pos + 1
$   the_len = f$len( line_in) - start_pos
$   work_str = f$extract( start_pos, the_len, line_in)
$   !;;;;;
$   !	rather than clutter up the loop with repetative code
$   !	call a subroutine
$   !;;;;;
$   this_int = 0	! assign a default illegal value
$   gosub next_int
$   no_1 = this_int
$   this_int = 0
$    !
$   gosub next_int
$   no_2 = this_int
$   this_int = 0
$    !
$   gosub next_int
$   no_3 = this_int
$   this_int = 0
$   !
$   gosub next_int
$   no_4 = this_int
$   this_int = 0
$   !
$   gosub next_int
$   no_5 = this_int
$   this_int = 0
$   !
$   !
$   mega_no = F$INTEGER( F$EDIT( work_str, "COLLAPSE"))
$   !;;;;;
$   !	write the output record
$   !;;;;;
$   rec_str = date_str + "!24* "		!   create a 32 byte string to match record size
$   !
$   !	move the binary data into the record
$   !
$   rec_str[ 64,32] = no_1
$   rec_str[ 96,32] = no_2
$   rec_str[ 128,32] = no_3
$   rec_str[ 160,32] = no_4
$   rec_str[ 192,32] = no_5
$   rec_str[ 224,32] = mega_no
$   !
$   write/symbol idx_file rec_str
$   if .NOT. $STATUS
$   then
$	my_status = $STATUS
$	goto error_exit
$   endif
$!
$ goto read_loop_top
$!;;;;;;;;;;
$!	Subroutine to format date
$!;;;;;;;;;;
$format_date:
$   date_len = F$LENGTH( date_str)
$   start_pos = date_len - 4
$   yyyy_str = F$EXTRACT( start_pos, 4, date_str)
$   mm_dd_str = F$EXTRACT( 0, date_len - 5, date_str)
$   slash_pos = F$LOCATE( "/", mm_dd_str)
$   mm_str = F$EXTRACT( 0, slash_pos, mm_dd_str)
$   start_pos = slash_pos + 1
$   d_len = F$LENGTH( mm_dd_str) - start_pos
$   dd_str = F$EXTRACT( start_pos, d_len, mm_dd_str)
$   !
$   !  Clean up single digit day and month
$   !
$   if F$LENGTH( dd_str) .LT. 2
$   then
$	dd_str = "0" + dd_str
$   endif
$   !
$   if F$LENGTH( mm_str) .LT. 2
$   then
$	mm_str = "0" + mm_str
$   endif
$   !
$   date_str = yyyy_str + mm_str + dd_str
$ return
$!
$!;;;;;;;;;;
$!	Subroutine to parse next integer from input line
$!;;;;;;;;;;
$next_int:
$   comma_pos = F$LOCATE( ",", work_str)
$   the_len = comma_pos 
$   this_int_str = F$EXTRACT( 0, the_len, work_str)
$   this_int_str = F$EDIT( this_int_str, "COLLAPSE")
$   this_int = F$INTEGER( this_int_str)
$   new_len = F$LENGTH( work_str) - comma_pos
$   t_work_str = F$EXTRACT( comma_pos + 1, new_len, work_str)
$   work_str = t_work_str
$ return
$!
$!;;;;;;;;;;
$!	exit due to error
$!;;;;;;;;;;
$error_exit:
$   write sys$output "Error importing file"
$   write sys$output f$message( my_status)
$   !
$   !	Fall through standard exit
$   !
$!;;;;;;;;;;
$!	standard exit
$!;;;;;;;;;;
$eof_txt:
$   if F$TRNLNM( "idx_file")  .NES. ""
$   then
$	close idx_file
$   endif
$!
$   if F$TRNLNM( "txt_file") .NES. ""
$   then
$	close txt_file
$   endif
$!
$!	restore the state of verify
$!
$   if verify_val .eq. 1
$   then
$	set verify
$   else
$	set noverify
$   endif
$!
$   set on
$ exit
