/*      CXX_ZILL_DUE_REPORT_SUB.CXX                                         */
/*                                                                          */
/*      Subroutine to create a report of the numbers due to hit             */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "zillionare_stats_record_class.hxx"

//
//  notice that we didn't include the descriptor header file
//  it was included by one of the other files under c++
//  
#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *CXX_DUE_REPORT_FILE_NAME = "ZILL_DUE.RPT";

const int ELM_COUNT = 52;



/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

extern "C" int cxx_desc_since_last_cmp( const void *e1, const void *e2);

void cxx_load_stat_arrays( struct zillionare_stats_record *d_stats,
                       struct zillionare_stats_record *m_stats);


void cxx_write_due_report( struct zillionare_stats_record *d_stats,
                    struct zillionare_stats_record *m_stats);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void cxx_zill_due_report_sub( )
{
    int                     l_x;
    char                    command_str[255];

    $DESCRIPTOR( command_str_desc, command_str);

    //
    //  Arrays to hold stats records
    //
    struct zillionare_stats_record  d_stats[ ELM_COUNT];
    struct zillionare_stats_record  m_stats[ ELM_COUNT];

    c_fill_in_logicals();

    //
    //  Populate our working arrays.
    //
    cxx_load_stat_arrays( d_stats, m_stats);

    //
    //  Sort our arrays in descending order by hit count
    //

    qsort( d_stats, 
           ELM_COUNT, 
           sizeof( struct zillionare_stats_record),
           cxx_desc_since_last_cmp);

    qsort(  m_stats, 
            ELM_COUNT, 
            sizeof( struct zillionare_stats_record),
            cxx_desc_since_last_cmp);

    //
    //  Print the report
    //
    cxx_write_due_report( d_stats, m_stats);

    sprintf( command_str, "EDIT/READ %s", CXX_DUE_REPORT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end cxx_zill_due_report_sub subroutine */
/*;;;;;
 *  function to be used with qsort as the compare.
 *  Normally a sort compare routine returns the following:
 *      -1  e1 < e2
 *      0   e1 = e2
 *      1   e1 > e2
 *  We need the opposite to create descending sort.
 *;;;;;
 */
extern "C" int cxx_desc_since_last_cmp( const void *e1, const void *e2)
{
    int     ret_val;
    
    struct zillionare_stats_record *z_1, *z_2;

    z_1 = reinterpret_cast<struct zillionare_stats_record *>(const_cast<void *>(e1));

    z_2 = reinterpret_cast<struct zillionare_stats_record *>(const_cast<void *>(e2));

    ret_val = 0;

    if ( z_1->since_last < z_2->since_last)
    {
        ret_val = 1;
    }
    else 
    {
      if ( z_1->since_last > z_2->since_last)
            ret_val = -1;
    }

    return(ret_val);

}  /* end cxx_desc_since_last_cmp function */

void cxx_write_due_report( struct zillionare_stats_record *d_stats,
                    struct zillionare_stats_record *m_stats)
{
    int         l_x, l_fp;
    time_t      the_time;
    char        work_str[255], dtl_line[255];
    struct      zillionare_stats_record *work_stats;

    const   int     PAGE_SIZE=55;

    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));

    //
    //  C++ doesn't allow you to use RMS attributes in the class
    //  so you have to use C function to create the file, then use
    //  the special constructor.
    //  
    l_fp = open( CXX_DUE_REPORT_FILE_NAME,
                    O_WRONLY | O_CREAT | O_TRUNC, 0, 
                    "ctx=rec", "mrs=80", "rat=cr", "rfm=var");

    //
    //  C++ is more like BASIC in that you can declare variables anywhere
    //  
    ofstream    rpt_file( l_fp);

    //
    //  First heading
    //  
    sprintf( dtl_line, "%s %31.31s Due Numbers Report", work_str, " ");
    rpt_file << dtl_line << endl << endl;

    sprintf( dtl_line, "%29.29sRegular Drawing Numbers", " ");
    rpt_file << dtl_line << endl << endl << endl;


    //
    //  Column headings
    //
    rpt_file << "No   Hits   Since   Pct_hits   Ave_btwn" << endl;
    rpt_file <<"--   ----   -----   --------   --------" << endl;

    work_stats = d_stats;

    for( l_x=0; l_x < ELM_COUNT; l_x++)
    {
        if (work_stats[l_x].since_last > work_stats[l_x].ave_btwn)
        {
            sprintf( dtl_line, "%2d   %4d   %4d     %5.3f    %5.3f",
                    work_stats[l_x].elm_no,
                    work_stats[l_x].hit_count,
                    work_stats[l_x].since_last,
                    work_stats[l_x].pct_hits,
                    work_stats[l_x].ave_btwn);

            rpt_file << dtl_line << endl;
        }  /* end test to see if number is due */
        

    }  /* end for l_x loop */

    //
    //  Second heading
    //
    sprintf( dtl_line, "\f%s %31.31s Due Numbers Report", work_str, " ");
    rpt_file << dtl_line << endl << endl;

    sprintf( dtl_line, "%30.30sMega Drawing Numbers", " ");
    rpt_file << endl << endl << endl << dtl_line << endl << endl << endl;

    //
    //  Column headings
    //
    rpt_file << "No   Hits   Since   Pct_hits   Ave_btwn" << endl;
    rpt_file <<"--   ----   -----   --------   --------" << endl;

    work_stats = m_stats;

    for( l_x=0; l_x < ELM_COUNT; l_x++)
    {

        if (work_stats[l_x].since_last > work_stats[l_x].ave_btwn)
        {
            sprintf( dtl_line, "%2d   %4d   %4d     %5.3f    %5.3f",
                    work_stats[l_x].elm_no,
                    work_stats[l_x].hit_count,
                    work_stats[l_x].since_last,
                    work_stats[l_x].pct_hits,
                    work_stats[l_x].ave_btwn);
                    
            rpt_file << dtl_line << endl;
            
        }  /* end test to see if number is due */

    }  /* end for l_x loop */

    rpt_file.close();
    
}  /* end cxx_write_due_report subroutine */
