/*      CXX_CREATE_STATS_SUB.CXX                                            */
/*                                                                          */
/*      Subroutine to create shiny new stats indexed files for our          */
/*      Mega_Zillionare example application.                                */
/*                                                                          */
/*
 *      ANSI headers
 */
#include <string>
#include <iostream>
#include <fstream>
#include <time.h>

/*
 *      VMS headers
 */
#include <lib$routines>

/*
 *  Our headers
 */
#include "zillionare_stats_record_class.hxx"
#include "drawing_record_class.hxx"

//
//  notice that we didn't include the descriptor header file
//  it was included by one of the other files under c++
//  
#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int ELM_COUNT = 52;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */
extern "C" void c_fill_in_logicals( void);

void cxx_calc_final_stats( struct zillionare_stats_record *d_stats,
                       struct zillionare_stats_record *m_stats,
                       int l_draw_no);

void cxx_initialize_stat_arrays( struct zillionare_stats_record *d_stats,
                             struct zillionare_stats_record *m_stats);


void cxx_update_dstats( struct zillionare_stats_record *d_stats, int l_no, int l_draw_no);

void cxx_update_mstats( struct zillionare_stats_record *m_stats, int l_no, int l_draw_no);


/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void cxx_create_stats_sub()
{
    int                     l_x, l_draw_no, l_sub;
    char                    command_str[255];
    struct drawing_record   d_rec;
    Drawing_Record_Class    draw_file;
    
    $DESCRIPTOR( command_str_desc, command_str);

    //
    //  Arrays to hold stats records
    //
    struct zillionare_stats_record  d_stats[ ELM_COUNT];
    struct zillionare_stats_record  m_stats[ ELM_COUNT];


    c_fill_in_logicals();

    //
    //  Populate our working arrays.
    //
    cxx_initialize_stat_arrays( d_stats, m_stats);

    //
    //  Create new empty stats files
    //
    strcpy( command_str, "CREATE/FDL=MEGA_DAT:MEGA_STATS.FDL DRAWING_STATS");
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

    strcpy( command_str, "CREATE/FDL=MEGA_DAT:MEGA_STATS.FDL MEGA_STATS");
    LENGTH( command_str_desc) = strlen( command_str);
    l_x = lib$spawn( &command_str_desc);


    //
    //  Open and read the drawing file
    //  
    draw_file.open();

    l_x = 1;
    l_draw_no = 0;

    while (l_x & 1)
    {
        l_x = draw_file.get_seq(&d_rec);
        if ( l_x & 1)
        {
            l_draw_no++;
            cxx_update_dstats( d_stats, d_rec.no_1, l_draw_no);
            cxx_update_dstats( d_stats, d_rec.no_2, l_draw_no);
            cxx_update_dstats( d_stats, d_rec.no_3, l_draw_no);
            cxx_update_dstats( d_stats, d_rec.no_4, l_draw_no);
            cxx_update_dstats( d_stats, d_rec.no_5, l_draw_no);

            cxx_update_mstats( m_stats, d_rec.mega_no, l_draw_no);

            if ( (l_draw_no % 100) == 0)
                cout << "Processed " << l_draw_no << " records" << endl;
                
        }  /* end test for successful read */
        
    }  /* end while l_x loop */

    cout << "Processed " << l_draw_no << " records" << endl;

    draw_file.close();

    cxx_calc_final_stats( d_stats, m_stats, l_draw_no);

    Zillionare_Stats_Record_Class   draw_stat_file( "DRAWING_STATS");
    Zillionare_Stats_Record_Class   mega_stat_file( "MEGA_STATS");

    draw_stat_file.open( FAB$M_PUT);
    mega_stat_file.open( FAB$M_PUT);

    for( l_sub=0; l_sub < ELM_COUNT; l_sub++)
    {
        l_x = draw_stat_file.put_record( &d_stats[ l_sub]);
        if ( !(l_x & 1))
            cout << "Error " << l_x << " writing drawing stat file" << endl;

        l_x = mega_stat_file.put_record( &m_stats[ l_sub]);
        if ( !(l_x & 1))
            cout << "Error " << l_x << " writing mega stat file" << endl;
        
    }  /* end for l_sub loop */

    draw_stat_file.close();
    mega_stat_file.close();
    
}  /* end cxx_create_stats_sub subroutine */

/*;;;;;
 *  Subroutine to initialize the arrays which will be written to disk.
 *;;;;;
 */
void cxx_initialize_stat_arrays( struct zillionare_stats_record *d_stats,
                             struct zillionare_stats_record *m_stats)
{
    int     l_x;

    for (l_x=0; l_x < ELM_COUNT; l_x++)
    {
        memset( &d_stats[ l_x], 0, sizeof( struct zillionare_stats_record));

        d_stats[ l_x].elm_no        = l_x + 1;
        d_stats[ l_x].pct_hits      = 0.0;
        d_stats[ l_x].ave_btwn      = 0.0;


        memset( &m_stats[ l_x], 0, sizeof( struct zillionare_stats_record));

        m_stats[ l_x].elm_no        = l_x + 1;
        m_stats[ l_x].pct_hits      = 0.0;
        m_stats[ l_x].ave_btwn      = 0.0;

    }  /* end for l_x loop */

}  /* end cxx_initialize_stat_arrays subroutine */

/*;;;;;
 *  Subroutine to update a drawing stats record
 *;;;;;
 */
void cxx_update_dstats( struct zillionare_stats_record *d_stats, int l_no, int l_draw_no)
{
    int     l_since, l_sub;


    l_sub   = l_no - 1;
    l_since = l_draw_no - d_stats[ l_sub].last_draw_no;

    //
    //  Sequence or random hit
    //
    if ( l_since == 1)
    {
        d_stats[ l_sub].curr_seq++;
        if ( d_stats[ l_sub].curr_seq > d_stats[ l_sub].longest_seq)
            d_stats[ l_sub].longest_seq = d_stats[ l_sub].curr_seq;
    }
    else
    {
        d_stats[ l_sub].curr_seq = 0;
        if ( l_since > d_stats[ l_sub].max_btwn)
            d_stats[ l_sub].max_btwn = l_since;

    }  /* end test for sequence or random hit */

    d_stats[ l_sub].hit_count++;
    d_stats[ l_sub].last_draw_no = l_draw_no;
    d_stats[ l_sub].since_last = l_since;

}  /* end cxx_update_dstats subroutine */


/*;;;;;
 *  Subroutine to update a mega stats record
 *;;;;;
 */
void cxx_update_mstats( struct zillionare_stats_record *m_stats, int l_no, int l_draw_no)
{
    int     l_since, l_sub;

    l_sub   = l_no - 1;
    l_since = l_draw_no - m_stats[ l_sub].last_draw_no;

    //
    //  Sequence or random hit
    //
    if ( l_since == 1)
    {
        m_stats[ l_sub].curr_seq++;
        if ( m_stats[ l_sub].curr_seq > m_stats[ l_sub].longest_seq)
            m_stats[ l_sub].longest_seq = m_stats[ l_sub].curr_seq;
    }
    else
    {
        m_stats[ l_sub].curr_seq = 0;
        if ( l_since > m_stats[ l_sub].max_btwn)
            m_stats[ l_sub].max_btwn = l_since;

    }  /* end test for sequence or random hit */

    m_stats[ l_sub].hit_count++;
    m_stats[ l_sub].last_draw_no = l_draw_no;
    m_stats[ l_sub].since_last = l_since;

}  /* end cxx_update_mstats subroutine */

/*;;;;;
 *  Subroutine to calculate final drawing stats information
 *;;;;;
 */
void cxx_calc_final_stats( struct zillionare_stats_record *d_stats,
                       struct zillionare_stats_record *m_stats,
                       int l_draw_no)
{
    int     l_x, l_missed;
    double  d_1, d_2;

    for( l_x=0; l_x < ELM_COUNT; l_x++)
    {
        d_1 = d_stats[ l_x].hit_count;
        d_2 = l_draw_no;

        l_missed = l_draw_no - d_stats[ l_x].hit_count;

        d_stats[ l_x].pct_hits = (double) d_stats[ l_x].hit_count / (double) l_draw_no;

        d_stats[ l_x].ave_btwn = (double) l_missed / 
                                 (double) d_stats[ l_x].hit_count;

        d_stats[ l_x].since_last = l_draw_no - d_stats[ l_x].last_draw_no;


        d_1 = m_stats[ l_x].hit_count;
        d_2 = l_draw_no;

        l_missed = l_draw_no - m_stats[ l_x].hit_count;

        m_stats[ l_x].pct_hits = (double) m_stats[ l_x].hit_count / (double) l_draw_no;

        m_stats[ l_x].ave_btwn = (double) l_missed / 
                                 (double) m_stats[ l_x].hit_count;

        m_stats[ l_x].since_last = l_draw_no - m_stats[ l_x].last_draw_no;


    }  /* end for l_x loop */


}  /* end cxx_calc_final_stats subroutine */

