IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_ZILL_BROWSE_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-02-09.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT DRAW-IDX
        ASSIGN TO 'MY_MEGA_FILE'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS DYNAMIC
        RECORD KEY IS DRAW_DT IN DRAWING_RECORD ASCENDING
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS IN-STAT.

DATA DIVISION.

FILE SECTION.

FD  DRAW-IDX
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.DRAWING_RECORD' FROM DICTIONARY.

**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 STATUS-VARIABLES.
       05 IN-STAT               PIC X(2).
       05 EOF-FLAG              PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.

       05 DONE-FLAG             PIC X.
          88 WE-ARE-DONE        VALUE 'Y'.

    01 RECORD-DATE.
       05 YYYY-STR              PIC 9(4).
       05 MM-STR                PIC 9(2).
       05 DD-STR                PIC 9(2).

    01 FORMATTED-DATE.
       05 MM-STR                PIC Z9.
       05 SLASH-1               PIC X.
       05 DD-STR                PIC 9(2).
       05 SLASH-2               PIC X.
       05 YYYY-STR              PIC 9(4).

    01 FORMATTED-NUMBERS.
       05 NO-1                  PIC Z9.
       05 FILLER                PIC X VALUE SPACE.
       05 NO-2                  PIC Z9.
       05 FILLER                PIC X VALUE SPACE.
       05 NO-3                  PIC Z9.
       05 FILLER                PIC X VALUE SPACE.
       05 NO-4                  PIC Z9.
       05 FILLER                PIC X VALUE SPACE.
       05 NO-5                  PIC Z9.

    01 SCREEN-REC.
       05 SCREEN-RECORDS        OCCURS 10 TIMES.
          10 F-MARK             PIC X.
          10 DRAW-DT            PIC X(10).
          10 NUMBERS            PIC X(30).
          10 MEGA-NO            PIC Z9.
       
    01 STUFF.
       05 LOAD-DIRECTION        PIC 9 COMP.
          88 LOAD-FORWARD       VALUE 0.
          88 LOAD-REVERSE       VALUE 1.

       05 L-COUNT               PIC 99 COMP.
       05 WORK-STR              PIC X(80).
       05 TERMINATOR            PIC S9(9) COMP.
       05 KEY_PAD_MODE          PIC 9 COMP   VALUE 0.
       05 NEGATIVE-ONE          PIC S9(9) COMP VALUE -1.

*
*   FMS definitions
*
COPY 'COBFDVDEF' OF 'MEGA_TEXT_LIB'.

LINKAGE SECTION.

    01 FMS-STUFF.
       05 FMSSTATUS                 PIC S9(9) COMP.
       05 RMSSTATUS                 PIC S9(9) COMP.
       05 TCA                       PIC X(12).
       05 WORKSPACE                 PIC X(12).


PROCEDURE DIVISION USING FMS-STUFF.

A000-MAIN.

    PERFORM B000-HSK.

    MOVE SPACES TO DRAWING_RECORD.

    PERFORM B010-USER-INPUT UNTIL WE-ARE-DONE.

    CLOSE DRAW-IDX.

    EXIT PROGRAM.


*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    CALL 'COB_FILL_IN_LOGICALS'.
    MOVE SPACES TO STATUS-VARIABLES.

    CALL 'FDV$SPADA' USING   BY REFERENCE KEY_PAD_MODE.

    CALL 'FDV$CDISP' USING  BY DESCRIPTOR 'ZILL_BROWSE'.

    MOVE SPACES TO SCREEN-REC.

    OPEN INPUT DRAW-IDX.

    SET LOAD-FORWARD TO TRUE.

*****
*   Paragraph to handle use input
*****
B010-USER-INPUT.

    PERFORM C000-FORWARD-LOAD

    CALL 'FDV$PUTAL' USING BY DESCRIPTOR SCREEN-REC.

    MOVE SPACES TO WORK-STR.

    CALL 'FDV$GETAL' USING BY DESCRIPTOR WORK-STR
                           BY REFERENCE TERMINATOR.


    EVALUATE TERMINATOR
        WHEN FDV$K_FK_E6    SET LOAD-FORWARD TO TRUE
        WHEN FDV$K_FK_E5    SET LOAD-REVERSE TO TRUE
        WHEN FDV$K_FK_F10   SET WE-ARE-DONE TO TRUE
    END-EVALUATE.

*****
*   Paragraph to load data going forward in the file.
*   If there is no more forward data, or the flag is
*   set to load in reverse we will call reverse load.
*****
C000-FORWARD-LOAD.

    MOVE SPACES TO RECORD-DATE.

    IF LOAD-REVERSE
        PERFORM D001-OBTAIN-REVERSE-POSITION
    ELSE
*
*       Allow for the possibility some of the records on the screen
*       are empty
*
        MOVE 10 TO L-COUNT

        PERFORM 
          UNTIL YYYY-STR IN RECORD-DATE IS GREATER THAN '0000'
                OR L-COUNT < 1

            MOVE DRAW_DT IN SCREEN-REC( L-COUNT) TO FORMATTED-DATE
            MOVE CORRESPONDING FORMATTED-DATE TO RECORD-DATE
            MOVE '/' TO SLASH-1, SLASH-2
            SUBTRACT 1 FROM L-COUNT

        END-PERFORM
    END-IF.


*
*   At this point we have either loaded record date from the screen
*   moving forward, or found the date we need counting backwards.
*

    MOVE SPACES TO EOF-FLAG.

    IF YYYY-STR IN RECORD-DATE IS EQUAL TO ZEROS
        MOVE SPACES TO RECORD-DATE.

*
*   Safe to clear out display area now.
*
    MOVE SPACES TO SCREEN-REC.
    MOVE ZERO TO L-COUNT.

    MOVE RECORD-DATE TO DRAW_DT IN DRAWING_RECORD.

    START DRAW-IDX KEY >= DRAW_DT IN DRAWING_RECORD
        INVALID KEY DISPLAY 'Unable to locate key going forward'
                    SET IT-IS-END-OF-FILE TO TRUE.

    PERFORM VARYING L-COUNT FROM 1 BY 1
      UNTIL L-COUNT > 10 OR IT-IS-END-OF-FILE

        READ DRAW-IDX NEXT
            AT END SET IT-IS-END-OF-FILE TO TRUE
        END-READ

        PERFORM D000-MOVE-DRAWING-DATA

    END-PERFORM.

*
*   Getting here means one of 2 things.
*   We either successfully loaded 10 records into the display
*   or we hit the bottom of the file.
*
    IF L-COUNT = 0
        IF LOAD-FORWARD
            MOVE SPACES TO RECORD-DATE
            PERFORM D001-OBTAIN-REVERSE-POSITION
            PERFORM C000-FORWARD-LOAD
        END-IF

        CALL 'FDV$BELL'
    ELSE
        IF IT-IS-END-OF-FILE AND L-COUNT < 10
            CALL 'FDV$BELL'
        END-IF
    END-IF.

*****
*   Paragraph to move drawing data from record into screen row
*****
D000-MOVE-DRAWING-DATA.

    MOVE DRAW_DT IN DRAWING_RECORD TO RECORD-DATE.
    MOVE CORRESPONDING RECORD-DATE TO FORMATTED-DATE.
    MOVE '/' TO SLASH-1, SLASH-2.
    MOVE FORMATTED-DATE TO DRAW-DT IN SCREEN-RECORDS( L-COUNT).

    MOVE NO_1 IN DRAWING_RECORD TO NO-1 IN FORMATTED-NUMBERS.
    MOVE NO_2 IN DRAWING_RECORD TO NO-2 IN FORMATTED-NUMBERS.
    MOVE NO_3 IN DRAWING_RECORD TO NO-3 IN FORMATTED-NUMBERS.
    MOVE NO_4 IN DRAWING_RECORD TO NO-4 IN FORMATTED-NUMBERS.
    MOVE NO_5 IN DRAWING_RECORD TO NO-5 IN FORMATTED-NUMBERS.
    MOVE FORMATTED-NUMBERS TO NUMBERS IN SCREEN-RECORDS( L-COUNT).

    MOVE MEGA_NO IN DRAWING_RECORD TO MEGA-NO IN SCREEN-RECORDS( L-COUNT).

*****
*   Paragraph to obtain a the record starting position after backing
*   up for the size of the screen.
*****
D001-OBTAIN-REVERSE-POSITION.

    MOVE SPACES TO DRAWING_RECORD.

*
*   User could have scrolled to end of file
*
    MOVE SPACE TO EOF-FLAG.

    MOVE DRAW-DT IN SCREEN-RECORDS( 1) TO FORMATTED-DATE.
    MOVE CORRESPONDING FORMATTED-DATE TO RECORD-DATE.
    MOVE RECORD-DATE TO DRAW_DT IN DRAWING_RECORD.

    IF DRAW_DT IN DRAWING_RECORD IS EQUAL TO ZEROS
        MOVE SPACES TO RECORD-DATE
        SET LOAD-FORWARD TO TRUE

    ELSE
*
*   Getting here means there was a prior record on the screen
*   Now we need to see if there are still 10 records remaining.
*
        READ DRAW-IDX KEY IS DRAW_DT IN DRAWING_RECORD
           INVALID KEY DISPLAY 'Error getting first record in reverse'
        END-READ

        PERFORM VARYING L-COUNT FROM 1 BY 1
          UNTIL L-COUNT > 10 OR IT-IS-END-OF-FILE

            READ DRAW-IDX PREVIOUS
                AT END SET IT-IS-END-OF-FILE TO TRUE
            END-READ

            IF IT-IS-END-OF-FILE
                CONTINUE
            ELSE
                MOVE DRAW_DT IN DRAWING_RECORD TO RECORD-DATE
            END-IF
        END-PERFORM.

*
*   Record-date will now have the last successfully read
*   index in it.
*
    MOVE RECORD-DATE TO DRAW_DT IN DRAWING_RECORD.

    IF IT-IS-END-OF-FILE
       CALL 'FDV$BELL'.

END PROGRAM COB_ZILL_BROWSE_SUB.

