IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_SQLM_ZILL_IMPORT_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-05-07.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT OPTIONAL DRAW-NO-FILE
        ASSIGN TO DISK
        ORGANIZATION IS SEQUENTIAL
        ACCESS MODE IS SEQUENTIAL
        FILE STATUS IS IN-STAT.

DATA DIVISION.

FILE SECTION.

FD  DRAW-NO-FILE
    IS GLOBAL
    VALUE OF ID IS IN-FILE
    LABEL RECORDS ARE STANDARD.

    01 LINE-IN          PIC X(80).

WORKING-STORAGE SECTION.

    01 STATUS-VARIABLES.
       05 IN-STAT           PIC X(2).
       05 DRAW-STAT         PIC X(2).
       05 EOF-FLAG          PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.
       05 IS-OPEN-FLAG      PIC X.
          88 FILE-IS-OPEN   VALUE 'Y'.

    01 STUFF.
       05 IN-FILE           PIC X(80).
       05 RECORD-COUNT      PIC S9(9) COMP.
       05 DISP-COUNT        PIC Z(4).
       05 SQLCODE           PIC S9(8) COMP.

    01 DATE-STUFF.
       05 LIB-RESULT        PIC S9(8) COMP.
       05 LIB-RESULT-DISPLAY PIC 9(8).
       05 DATE-CONTEXT      PIC S9(8) COMP.
       05 DATE-COMPONENT    PIC S9(8) COMP.
       05 DATE-IN-FMT-STR   PIC X(26) VALUE '|!Y4!MN0!D0 !H04!M0!S0!C2|'.
       05 DATE-FLAGS        PIC S9(8) COMP VALUE 127.

    01 CHAR-RECORD.
       05 DRAW-DATE.
          10 YYYY-STR       PIC 9(4).
          10 MM-STR         PIC 9(2).
          10 DD-STR         PIC 9(2).
       05 NO-1              PIC 9(2).
       05 NO-2              PIC 9(2).
       05 NO-3              PIC 9(2).
       05 NO-4              PIC 9(2).
       05 NO-5              PIC 9(2).
       05 MEGA-NO           PIC 9(2).


    01 SQL-RECORD.
       05 DATE-QUAD         PIC S9(18) COMP.
       05 NO-1              PIC 9(2) COMP.
       05 NO-2              PIC 9(2) COMP.
       05 NO-3              PIC 9(2) COMP.
       05 NO-4              PIC 9(2) COMP.
       05 NO-5              PIC 9(2) COMP.
       05 MEGA-NO           PIC 9(2) COMP.

    COPY 'SYS$LIBRARY:SQL_LITERALS.LIB'.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    PERFORM B020-OPEN-TEXT
        UNTIL FILE-IS-OPEN.

    PERFORM B010-LOAD-DATA
        UNTIL IT-IS-END-OF-FILE.


    MOVE RECORD-COUNT TO DISP-COUNT.
    DISPLAY DISP-COUNT, ' RECORDS PROCESED'.

    CLOSE DRAW-NO-FILE.

    CALL 'COMMIT_MEGA' USING BY DESCRIPTOR SQLCODE.

    CALL 'LIB$FREE_DATE_TIME_CONTEXT' USING BY REFERENCE DATE-CONTEXT
                                      GIVING LIB-RESULT.
    EXIT PROGRAM.

**********
*   House keeping routine to initialize variables and 
*   open files.
**********
B000-HSK.
    MOVE SPACES TO STATUS-VARIABLES.
    MOVE SPACES TO IN-FILE.
    MOVE ZERO TO RECORD-COUNT.

    MOVE ZERO TO DATE-CONTEXT.
    MOVE 2 TO DATE-COMPONENT.
    CALL 'LIB$INIT_DATE_TIME_CONTEXT' USING BY REFERENCE DATE-CONTEXT, DATE-COMPONENT,
                                            BY DESCRIPTOR DATE-IN-FMT-STR
                                      GIVING LIB-RESULT.

    MOVE LIB-RESULT TO LIB-RESULT-DISPLAY.
    DISPLAY 'RESULT OF INIT ', LIB-RESULT-DISPLAY.

    CALL 'DELETE_ALL_DRAW_RECS' USING BY REFERENCE SQLCODE.

    CALL 'COMMIT_MEGA' USING BY REFERENCE SQLCODE.

**********
*   Subroutine to read an input record.
*   When a record has been read, call
*   another subroutine to load it into 
*   our indexed file.
**********
B010-LOAD-DATA.

    MOVE SPACES TO LINE-IN.

    READ DRAW-NO-FILE NEXT
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    IF IT-IS-END-OF-FILE
        NEXT SENTENCE
    ELSE
        PERFORM C000-PARSE-RECORD.
**********
*
**********
B020-OPEN-TEXT.
    DISPLAY 'Input File Name: ' WITH NO ADVANCING.
    ACCEPT IN-FILE.

    OPEN INPUT DRAW-NO-FILE
        ALLOWING NO OTHERS.

    IF IN-STAT = '05'
        CLOSE DRAW-NO-FILE
        DISPLAY 'File ' IN-FILE ' Not found'.

    IF IN-STAT = '00'
        SET FILE-IS-OPEN TO TRUE
    ELSE
        DISPLAY IN-STAT ' Result code opening input file'.

**********
*   Subroutine to parse through the input
*   record and create a record in our indexed
*   file.
**********
C000-PARSE-RECORD.
    UNSTRING LINE-IN
        DELIMITED BY '/' OR ',' OR SPACE INTO 
            MM-STR
            DD-STR
            YYYY-STR
            NO-1 IN CHAR-RECORD
            NO-2 IN CHAR-RECORD
            NO-3 IN CHAR-RECORD
            NO-4 IN CHAR-RECORD
            NO-5 IN CHAR-RECORD
            MEGA-NO IN CHAR-RECORD.

    CALL 'LIB$CONVERT_DATE_STRING' USING BY DESCRIPTOR DRAW-DATE, 
                                        BY REFERENCE DATE-QUAD, DATE-CONTEXT, OMITTED, OMITTED, OMITTED
                                  GIVING LIB-RESULT.

    MOVE NO-1 IN CHAR-RECORD TO NO-1 IN SQL-RECORD.
    MOVE NO-2 IN CHAR-RECORD TO NO-2 IN SQL-RECORD.
    MOVE NO-3 IN CHAR-RECORD TO NO-3 IN SQL-RECORD.
    MOVE NO-4 IN CHAR-RECORD TO NO-4 IN SQL-RECORD.
    MOVE NO-5 IN CHAR-RECORD TO NO-5 IN SQL-RECORD.
    MOVE MEGA-NO IN CHAR-RECORD TO MEGA-NO IN SQL-RECORD.


    ADD 1 TO RECORD-COUNT.

    CALL 'INSERT_DRAW_REC' USING BY REFERENCE SQLCODE, DATE-QUAD, 
                                    NO-1 IN SQL-RECORD,
                                    NO-2 IN SQL-RECORD,
                                    NO-3 IN SQL-RECORD,
                                    NO-4 IN SQL-RECORD,
                                    NO-5 IN SQL-RECORD,
                                    MEGA-NO IN SQL-RECORD.

    IF SQLCODE IS NOT EQUAL TO 0
        MOVE SQLCODE TO LIB-RESULT-DISPLAY
        DISPLAY 'RESULT OF INSERTING DRAWING RECORD', LIB-RESULT-DISPLAY
        DISPLAY 'DATE WAS ', DRAW-DATE
        CALL 'ROLLBACK_MEGA' USING BY REFERENCE SQLCODE.

    IF FUNCTION MOD( RECORD-COUNT, 100) = 0
        MOVE RECORD-COUNT TO DISP-COUNT
        DISPLAY DISP-COUNT, ' RECORDS PROCESED'
        CALL 'COMMIT_MEGA' USING BY DESCRIPTOR SQLCODE.

END PROGRAM COB_SQLM_ZILL_IMPORT_SUB.
