$!  COB_SQLM_MMS_BUILD.COM
$!
$!  Command procedure to build the Mega_Zillionare
$!  application using MMS
$!
$!  Required parameters:
$!  P1      environment code "D01", "T01", "S01", or "P01"
$!
$!  Optional parameter
$!  P2      FULL
$!
$ bell[0,7] = %x07
$!
$ say :== WRITE SYS$OUTPUT
$!
$!;;;;;
$!  Make sure user supplied a parameter
$!;;;;;
$ if "''p1'" .eqs. ""
$ then
$   say bell, bell, bell
$   say "you must supply P1 of D01, T01, S01, or P01
$   goto exit_program
$ endif
$!
$!;;;;;
$!  Validate the parameter
$!;;;;;
$ env_str = f$edit( "''p1'", "COLLAPSE,UPCASE")
$ if env_str .eqs. "D01" then goto good_parm
$ if env_str .eqs. "T01" then goto good_parm
$ if env_str .eqs. "S01" then goto good_parm
$ if env_str .eqs. "P01" then goto good_parm
$!
$!   Supplied parameter invalid
$!
$ say bell, bell, bell
$ SAY "you must supply P1 of D01, T01, S01, or P01
$ goto exit_program
$!
$!;;;;;
$!  Make certain we have the correct logicals
$!;;;;;
$good_parm:
$!
$!  Define the logicals just in case user sent to batch.
$!
$ c = f$trnlnm("MEGA_COM", "LNM$FILE_DEV")
$!
$ if "''c'" .gts. " "
$ then
$   @mega_com:mega_environment "''env_str'"
$ else
$   @dka1200:[mega_'env_str'.com]mega_environment "''env_str'"
$ endif
$!
$!  Full build or just a partial build?
$!
$ partial_flag = 1
$!
$ if "''p2'" .gts. ""
$ then
$   p2_str = f$edit( "''p2'", "UPCASE,COLLAPSE")
$   if "''p2_str'" .eqs. "FULL" then partial_flag = 0
$ endif
$!
$ cms set lib mega_cms
$!
$ original_dir = f$environment( "DEFAULT")
$!
$ if partial_flag .eq. 0
$ then
$   delete mega_exe:*.*;*
$   delete mega_obj:*.*;*
$!
$!  Always do a full build in a clean directory
$!
$   set def sys$login
$   a = f$search( "clean_build.dir")
$   if "''a'" .eqs. "" then create/directory [.clean_build]
$   set def [.clean_build]
$   delete *.*;*
$!
$   mms/cms/descrip=cob_sqlm_mega 
$!
$   set def 'original_dir'
$ else
$   mms/cms/descrip=cob_sqlm_mega
$ endif
$!
$exit_program:
$ exit
