IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_EXEC_ZILL_MENU.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-05-14.
DATE-COMPILED.  TODAY.

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

DATA DIVISION.

FILE SECTION.

**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 CONSTANTS.
       05 KEY_PAD_MODE              PIC 9 COMP   VALUE 1.
       05 SIGNAL_BELL               PIC 9 COMP   VALUE ZERO.
       05 TCA_SIZE                  PIC 99 COMP  VALUE 12.
       05 TCA_UNIT                  PIC 99 COMP  VALUE 2.
       05 WORKSPACE_SIZE            PIC S9(9) COMP VALUE 2000.
       05 LOGICAL_UNIT              PIC 9 COMP VALUE 1.
       05 START-LINE                PIC 9 COMP VALUE 1.
       05 SCREEN-LINE-COUNT         PIC 99 COMP VALUE 23.
    
    01 STATUS-VARIABLES.
       05 DONE-FLAG                 PIC X.
          88 WE-ARE-DONE            VALUE 'Y'.

    01 FMS-STUFF.
       05 FMSSTATUS                 PIC S9(9) COMP.
       05 RMSSTATUS                 PIC S9(9) COMP.
       05 TCA                       PIC X(12).
       05 WORKSPACE                 PIC X(12).

    01 LOCAL-WORK.
       05 TERMINATOR                PIC S9(9) COMP.
       05 WORK-STR                  PIC X(80).
       05 COMMAND-STR               PIC X(255).
*
*   FMS definitions
*
COPY 'COBFDVDEF' IN 'MEGA_TEXT_LIB'.

PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    PERFORM B010-USER-INPUT
        UNTIL WE-ARE-DONE.

    CALL 'FDV$LCLOS'.

    CALL 'FDV$DWKSP' USING BY DESCRIPTOR WORKSPACE.

    CALL 'FDV$DTERM' USING BY DESCRIPTOR TCA.

    STOP RUN.


*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    MOVE SPACES TO STATUS-VARIABLES.

    CALL 'FDV$ATERM' USING  BY DESCRIPTOR TCA
                            BY REFERENCE TCA_SIZE
                            BY REFERENCE TCA_UNIT.

    CALL 'FDV$AWKSP' USING  BY DESCRIPTOR WORKSPACE
                            BY REFERENCE WORKSPACE_SIZE.

    CALL 'FDV$LOPEN' USING  BY DESCRIPTOR 'MEGA_ZILL'
                            BY REFERENCE LOGICAL_UNIT.

    CALL 'FDV$SPADA' USING   BY REFERENCE KEY_PAD_MODE.
    CALL 'FDV$SSIGQ' USING  BY REFERENCE SIGNAL_BELL.

    CALL 'FDV$SSRV' USING   BY REFERENCE FMSSTATUS
                            BY REFERENCE RMSSTATUS.

    CALL 'FDV$CDISP' USING  BY DESCRIPTOR 'ZILL_MENU'.

*****
*   Paragraph to handle user input and call needed subroutines.
*****
B010-USER-INPUT.

    MOVE SPACES TO WORK-STR.

    CALL 'FDV$GETAL' USING BY DESCRIPTOR WORK-STR
                           BY REFERENCE TERMINATOR.

    EVALUATE TERMINATOR
        WHEN FDV$K_PF_4     SET WE-ARE-DONE TO TRUE

        WHEN FDV$K_KP_1     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT

                            CALL 'COB_EXEC_ZILL_IMPORT_SUB'


        WHEN FDV$K_KP_2     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT

                            CALL 'COB_EXEC_ZILL_ENTRY_SUB' 
                                USING FMSSTATUS
                                      RMSSTATUS
                                      TCA
                                      WORKSPACE


        WHEN FDV$K_KP_3     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT
                            CALL 'COB_EXEC_CREATE_STATS_SUB'


        WHEN FDV$K_KP_5     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT

                            CALL 'COB_EXEC_ZILL_BROWSE_SUB' 
                                USING FMSSTATUS
                                      RMSSTATUS
                                      TCA
                                      WORKSPACE

        WHEN FDV$K_KP_7     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT
                            CALL 'COB_EXEC_ZILL_DUE_RPT_SUB'

        WHEN FDV$K_KP_8     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT
                            CALL 'COB_EXEC_ZILL_MOST_RPT_SUB'

        WHEN FDV$K_KP_9     CALL 'FDV$CLEAR' 
                                USING BY REFERENCE START-LINE
                                      BY REFERENCE SCREEN-LINE-COUNT
                            CALL 'COB_EXEC_DUMP_DRAW_DATA_SUB'
    END-EVALUATE.

    CALL 'FDV$SPADA' USING   BY REFERENCE KEY_PAD_MODE.

    CALL 'FDV$CDISP' USING  BY DESCRIPTOR 'ZILL_MENU'.

END PROGRAM COB_EXEC_ZILL_MENU.


