IDENTIFICATION DIVISION.

PROGRAM-ID.     COB_CREATE_STATS_SUB.
AUTHOR.         Roland Hughes.
DATE-WRITTEN.   2005-02-08.
DATE-COMPILED.  TODAY.

***********
*   Be certain you compile with /FLOAT=G_FLOAT so CDD can 
*   correctly generate record definitions.
***********

ENVIRONMENT DIVISION.

INPUT-OUTPUT SECTION.

FILE-CONTROL.

    SELECT DRAW-IDX
        ASSIGN TO 'MY_MEGA_FILE'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS SEQUENTIAL
        RECORD KEY IS DRAW_DT IN DRAWING_RECORD ASCENDING
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS IN-STAT.

    SELECT DRAW-STATS
        ASSIGN TO 'DRAWING_STATS'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS RANDOM
        RECORD KEY IS ELM_NO IN DSTATS-REC
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS D-STAT.

    SELECT MEGA-STATS
        ASSIGN TO 'MEGA_STATS'
        ORGANIZATION IS INDEXED
        ACCESS MODE IS RANDOM
        RECORD KEY IS ELM_NO IN MSTATS-REC
        LOCK MODE IS AUTOMATIC
        FILE STATUS IS M-STAT.

DATA DIVISION.

FILE SECTION.

FD  DRAW-IDX
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.DRAWING_RECORD' FROM DICTIONARY.

FD  DRAW-STATS
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY DSTATS-REC.


FD  MEGA-STATS
    IS GLOBAL
    LABEL RECORDS ARE STANDARD.

    COPY 'CDD_RECORDS.ZILLIONARE_STATS_RECORD' FROM DICTIONARY
        REPLACING ZILLIONARE_STATS_RECORD BY MSTATS-REC.


**********
*   Data declarations
**********
WORKING-STORAGE SECTION.
    01 CONSTANTS.
       05 ELM-COUNT             PIC S9(9) COMP VALUE IS 52.


    01 STATUS-VARIABLES.
       05 IN-STAT               PIC X(2).
       05 M-STAT                PIC X(2).
       05 D-STAT                PIC X(2).
       05 EOF-FLAG          PIC X.
          88 IT-IS-END-OF-FILE VALUE 'Y'.


*****
*   One of my biggest pet peeves with the copy from dictionary
*   verb is the lack of a "starting level" clause.
*   When pulling entries in from a dictionary you cannot tell
*   the dictionary what starting level number to use.
*****
    01 WORKING-VARIABLES.
       05 L-SUB             PIC S9(9) COMP.
       05 L-DRAW-NO         PIC S9(9) COMP.
       05 L-MISSED          PIC S9(9) COMP.
       05 L-SINCE           PIC S9(9) COMP.
       05 L-DRAW-NO-DISP    PIC Z(5).
       05 FLT-1             COMP-2.
       05 FLT-2             COMP-2.


    01 TABLES.
       05 DSTATS_TBL            OCCURS 52 TIMES.
          10 HIT-COUNT      PIC S9(9) COMP.
          10 LAST-DRAW-NO   PIC S9(9) COMP.
          10 SINCE-LAST     PIC S9(9) COMP.
          10 CURR-SEQ       PIC S9(9) COMP.
          10 LONGEST-SEQ    PIC S9(9) COMP.
          10 PCT-HITS       COMP-2.
          10 MAX-BTWN       PIC S9(9) COMP.
          10 AVE-BTWN       COMP-2.

       05 MSTATS_TBL            OCCURS 52 TIMES.
          10 HIT-COUNT      PIC S9(9) COMP.
          10 LAST-DRAW-NO   PIC S9(9) COMP.
          10 SINCE-LAST     PIC S9(9) COMP.
          10 CURR-SEQ       PIC S9(9) COMP.
          10 LONGEST-SEQ    PIC S9(9) COMP.
          10 PCT-HITS       COMP-2.
          10 MAX-BTWN       PIC S9(9) COMP.
          10 AVE-BTWN       COMP-2.


PROCEDURE DIVISION.

A000-MAIN.

    PERFORM B000-HSK.

    PERFORM B010-READ-DRAWINGS
        VARYING L-DRAW-NO FROM 1 BY 1
        UNTIL IT-IS-END-OF-FILE.

*****
*       Note that we have to do a subtraction here.
*       COBOL doesn't turn on end of file until you try to read
*       past the end of file.  That gets us 1 extra going into 
*       the paragraph.  Since the VARYING logic occurs prior to the 
*       UNTIL logic test, we are off by 2.
*****
    SUBTRACT 2 FROM L-DRAW-NO.

    MOVE L-DRAW-NO TO L-DRAW-NO-DISP.
    DISPLAY L-DRAW-NO-DISP ' records processed'.

    PERFORM B020-GENERATE-FINAL-STATS.

    PERFORM B030-WRITE-STATS.

    CLOSE DRAW-IDX.
    CLOSE DRAW-STATS.
    CLOSE MEGA-STATS.

    EXIT PROGRAM.

*****
*   Paragraph to initialize our data and files.
*****
B000-HSK.
    CALL 'COB_FILL_IN_LOGICALS'.
    MOVE SPACES TO STATUS-VARIABLES.

    PERFORM C002-ZERO-TABLES
        VARYING L-SUB FROM 1 BY 1 UNTIL L-SUB > ELM-COUNT.

    OPEN INPUT  DRAW-IDX.

*
*       Create new output files
*
    CALL 'LIB$SPAWN' USING BY DESCRIPTOR
        'CREATE/FDL=MEGA_DAT:MEGA_STATS.FDL DRAWING_STATS'.

    OPEN I-O DRAW-STATS.


    CALL 'LIB$SPAWN' USING BY DESCRIPTOR
        'CREATE/FDL=MEGA_DAT:MEGA_STATS.FDL MEGA_STATS'.

    OPEN I-O MEGA-STATS.

*****
*   Paragraph to read each record in the drawing file
*   and update the associated stats records.
*****
B010-READ-DRAWINGS.
    READ DRAW-IDX NEXT
        AT END SET IT-IS-END-OF-FILE TO TRUE.

    IF FUNCTION MOD( L-DRAW-NO, 100) IS EQUAL TO 0
        MOVE L-DRAW-NO TO L-DRAW-NO-DISP
        DISPLAY L-DRAW-NO-DISP ' records processed'.

    IF IT-IS-END-OF-FILE
        NEXT SENTENCE
    ELSE
        PERFORM C010-UPDATE-RECORD-STATS.

*****
*   Paragraph to generate final stats on all of the records
*****
B020-GENERATE-FINAL-STATS.

    PERFORM C020-FINAL-DSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

    PERFORM C030-FINAL-MSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

*****
*   Paragraph to write final stats records to disk
*****
B030-WRITE-STATS.
    PERFORM C040-WRITE-DSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

    PERFORM C050-WRITE-MSTATS
        VARYING L-SUB FROM 1 BY 1
        UNTIL L-SUB > ELM-COUNT.

*****
*   Paragraph to zero out table elements
*****
C002-ZERO-TABLES.

    COMPUTE HIT-COUNT IN DSTATS-TBL(L-SUB)    = 0.
    COMPUTE LAST-DRAW-NO IN DSTATS-TBL(L-SUB) = 0.
    COMPUTE SINCE-LAST IN DSTATS-TBL( L-SUB)  = 0.
    COMPUTE CURR-SEQ IN DSTATS-TBL( L-SUB)    = 0.
    COMPUTE LONGEST-SEQ IN DSTATS-TBL( L-SUB) = 0.
    COMPUTE PCT-HITS IN DSTATS-TBL( L-SUB)    = 0.
    COMPUTE MAX-BTWN IN DSTATS-TBL( L-SUB)    = 0.
    COMPUTE AVE-BTWN IN DSTATS-TBL( L-SUB)    = 0.

    COMPUTE HIT-COUNT IN MSTATS-TBL(L-SUB)    = 0.
    COMPUTE LAST-DRAW-NO IN MSTATS-TBL(L-SUB) = 0.
    COMPUTE SINCE-LAST IN MSTATS-TBL( L-SUB)  = 0.
    COMPUTE CURR-SEQ IN MSTATS-TBL( L-SUB)    = 0.
    COMPUTE LONGEST-SEQ IN MSTATS-TBL( L-SUB) = 0.
    COMPUTE PCT-HITS IN MSTATS-TBL( L-SUB)    = 0.
    COMPUTE MAX-BTWN IN MSTATS-TBL( L-SUB)    = 0.
    COMPUTE AVE-BTWN IN MSTATS-TBL( L-SUB)    = 0.


*****
*   Paragraph to update stats records for individual drawing numbers
*****
C010-UPDATE-RECORD-STATS.

    MOVE NO_1 IN DRAWING_RECORD TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO_2 IN DRAWING_RECORD TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO_3 IN DRAWING_RECORD TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO_4 IN DRAWING_RECORD TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.


    MOVE NO_5 IN DRAWING_RECORD TO L-SUB.

    PERFORM D001-UPDATE-DRAW-STAT.

    MOVE MEGA_NO IN DRAWING-RECORD TO L-SUB.

    PERFORM D002-UPDATE-MEGA-STAT.

*****
*   Paragraph to read and update each record in the DSTATS file.
*****
C020-FINAL-DSTATS.

    COMPUTE FLT-1 = HIT-COUNT IN DSTATS-TBL(L-SUB).
    COMPUTE FLT-2 = L-DRAW-NO.

    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE PCT-HITS IN DSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE L-MISSED = L-DRAW-NO - HIT-COUNT IN DSTATS-TBL( L-SUB).

    COMPUTE FLT-1 = L-MISSED.
    COMPUTE FLT-2 = HIT-COUNT IN DSTATS-TBL( L-SUB).
    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE AVE-BTWN IN DSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE SINCE-LAST IN DSTATS-TBL( L-SUB) = 
                L-DRAW-NO - LAST-DRAW-NO IN DSTATS-TBL(L-SUB).


*****
*   Paragraph to read and update each record in the MSTATS file.
*****
C030-FINAL-MSTATS.
    COMPUTE FLT-1 = HIT-COUNT IN MSTATS-TBL(L-SUB).
    COMPUTE FLT-2 = L-DRAW-NO.
    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE PCT-HITS IN MSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE L-MISSED = L-DRAW-NO - HIT-COUNT IN MSTATS-TBL( L-SUB).

    COMPUTE FLT-1 = L-MISSED.
    COMPUTE FLT-2 = HIT-COUNT IN MSTATS-TBL( L-SUB).
    IF FLT-2 < 1
        COMPUTE FLT-2 = 1.

    COMPUTE AVE-BTWN IN MSTATS-TBL(L-SUB) = FLT-1 / FLT-2.

    COMPUTE SINCE-LAST IN MSTATS-TBL( L-SUB) = 
                L-DRAW-NO - LAST-DRAW-NO IN MSTATS-TBL(L-SUB).

*****
*  Paragraph to write a dstats array element to indexed file
*****
C040-WRITE-DSTATS.
    MOVE L-SUB  TO ELM_NO IN DSTATS-REC.

    MOVE CORRESPONDING DSTATS-TBL( L-SUB) TO DSTATS-REC.

    WRITE DSTATS-REC
        INVALID KEY DISPLAY 'Error writing dstats record'.

*****
*
*****
C050-WRITE-MSTATS.
    MOVE L-SUB TO ELM_NO IN MSTATS-REC.
    MOVE CORRESPONDING MSTATS-TBL( L-SUB) TO MSTATS-REC.
    WRITE MSTATS-REC
        INVALID KEY DISPLAY 'Error writing mstats record'.

*****
*   Paragraph to update individual drawing stat records.
*****
D001-UPDATE-DRAW-STAT.

    SUBTRACT LAST-DRAW-NO IN DSTATS-TBL(L-SUB) FROM L-DRAW-NO
        GIVING L-SINCE.

    IF L-SINCE IS EQUAL TO 1
        ADD 1 TO CURR-SEQ IN DSTATS-TBL(L-SUB)
        IF CURR-SEQ IN DSTATS-TBL(L-SUB) > LONGEST-SEQ IN DSTATS-TBL(L-SUB)
            MOVE CURR-SEQ IN DSTATS-TBL(L-SUB) 
                TO LONGEST-SEQ IN DSTATS-TBL(L-SUB)
        END-IF
    ELSE
        COMPUTE CURR-SEQ IN DSTATS-TBL(L-SUB) = 0
        IF L-SINCE > MAX-BTWN IN DSTATS-TBL(L-SUB)
            COMPUTE MAX-BTWN IN DSTATS-TBL(L-SUB) = L-SINCE
        END-IF

    END-IF.

    ADD 1 TO HIT-COUNT IN DSTATS-TBL(L-SUB).
    COMPUTE LAST-DRAW-NO IN DSTATS-TBL(L-SUB) = L-DRAW-NO.
    COMPUTE SINCE-LAST IN DSTATS-TBL(L-SUB) = L-SINCE.

*****
*   Paragraph to update the mega stats from the drawing record
*****
D002-UPDATE-MEGA-STAT.
    SUBTRACT LAST-DRAW-NO IN MSTATS-TBL(L-SUB) FROM L-DRAW-NO
        GIVING L-SINCE.

    IF L-SINCE IS EQUAL TO 1
        ADD 1 TO CURR-SEQ IN MSTATS-TBL(L-SUB)
        IF CURR-SEQ IN MSTATS-TBL(L-SUB) > LONGEST-SEQ IN MSTATS-TBL(L-SUB)
            MOVE CURR-SEQ IN MSTATS-TBL(L-SUB) 
                TO LONGEST-SEQ IN MSTATS-TBL(L-SUB)
        END-IF
    ELSE
        COMPUTE CURR-SEQ IN MSTATS-TBL(L-SUB) = 0
        IF L-SINCE > MAX-BTWN IN MSTATS-TBL(L-SUB)
            COMPUTE MAX-BTWN IN MSTATS-TBL(L-SUB) = L-SINCE
        END-IF

    END-IF.

    ADD 1 TO HIT-COUNT IN MSTATS-TBL(L-SUB)
    COMPUTE LAST-DRAW-NO IN MSTATS-TBL(L-SUB) = L-DRAW-NO.
    COMPUTE SINCE-LAST IN MSTATS-TBL(L-SUB) = L-SINCE.

END PROGRAM COB_CREATE_STATS_SUB.
