/*  C_ZILL_BROWSE_SUB.C
 *
 *  Subroutine to browse drawing records
 *  in the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>
#include <fdvdef>
#include <fms_prototypes>

/*
 *  Our headers
 */

#pragma member_alignment save
#pragma nomember_alignment
#pragma dictionary "cdd_records.drawing_record"
#pragma member_alignment restore

#define LENGTH(descriptor)      descriptor.dsc$w_length


struct  browse_screen_struct
{
    char    f_mark;
    char    draw_dt[10];
    char    numbers[30];
    char    mega_no_txt[2];
};



/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int LOAD_FORWARD = 0;
const int LOAD_REVERSE = 1;
const int L_DONE = 99;
const int L_BROWSE_SCREEN_COUNT = 10;

extern const int L_ZERO;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void browse_user_input( int *l_action, 
                        struct browse_screen_struct *b_s,
                        int *load_direction,
                        struct  drawing_record  *m_z,
                        struct RAB *mega_rab);

void c_fill_in_logicals( void);

void load_browse_screen( struct browse_screen_struct *b_s, 
                         int *load_direction,
                         struct drawing_record *m_z,
                         struct RAB *mega_rab);

int  open_mega_idx( struct drawing_record *m_z, 
                    struct FAB *m_fab, struct RAB *m_rab,
                    struct XABKEY *m_xab,
                    int access);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */

// turn off warnings about $ characters
#pragma message disable (DOLLARID)          

void c_zill_browse_sub( int *fms_status, int *rms_status, 
                        int *tca_array, int *workspace_array)
{
    int                     l_x, l_load_direction;
    int                     l_action, l_y;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;

    $DESCRIPTOR( command_str_desc, command_str);

    struct  drawing_record  m_z;
    struct  FAB             mega_fab;
    struct  RAB             mega_rab;
    struct  XABKEY          mega_xab;

    struct  browse_screen_struct    screen_rec[L_BROWSE_SCREEN_COUNT];

    $DESCRIPTOR( form_name_desc, "ZILL_BROWSE");


    //
    //  attach to the mega file
    //
    l_x = open_mega_idx( &m_z, &mega_fab, 
                         &mega_rab, &mega_xab, FAB$M_GET);

    if ( !(l_x & 1))
    {
        puts( "Unable to open indexed file for output");
        return;
    }  /* end test for failed open */

    mega_rab.rab$b_ksz = sizeof( m_z.draw_dt);


    //
    //  Set the keypad mode and load our form
    //
    l_y = L_ZERO;
    l_x = fdv$spada( &l_y);

    l_x = fdv$cdisp( &form_name_desc);

    l_load_direction = LOAD_FORWARD;

    l_action = 0;

    //
    //  This works because the array is declared locally
    //  so the compiler knows just how big it is.
    //
    memset( screen_rec, ' ', sizeof( screen_rec));

    do
    {
        browse_user_input( &l_action, screen_rec, &l_load_direction,
                           &m_z, &mega_rab);

    } while ( l_action != L_DONE);

    l_x = sys$close( &mega_fab);

    return;

}  /* end c_zill_browse_sub */

/*;;;;;
 *  Subroutine to handle user interaction scrolling through the input.
 *;;;;;
 */
void browse_user_input( int *l_action, 
                        struct browse_screen_struct *b_s,
                        int *load_direction,
                        struct  drawing_record  *m_z,
                        struct RAB *mega_rab)
{

    int     l_x, l_terminator;

    struct  dsc$descriptor_s    b_s_desc;




    load_browse_screen( b_s, load_direction, m_z, mega_rab);

    //
    //  hand build a string descriptor for our browse
    //  screen array.
    //
    b_s_desc.dsc$w_length   = sizeof( struct browse_screen_struct)
                              * L_BROWSE_SCREEN_COUNT;
    b_s_desc.dsc$b_dtype    = DSC$K_DTYPE_T;
    b_s_desc.dsc$b_class    = DSC$K_CLASS_S;
    b_s_desc.dsc$a_pointer  = (void *)b_s;

    l_terminator = 0;

    l_x = fdv$putal( &b_s_desc);

    l_x = fdv$getal( &b_s_desc, &l_terminator);

    switch( l_terminator)
    {
        case FDV$K_FK_E6:       *load_direction = LOAD_FORWARD;
                                break;
        case FDV$K_FK_E5:       *load_direction = LOAD_REVERSE;
                                break;
        case FDV$K_FK_F10:      *l_action = L_DONE;
                                break;

    }  /* end switch of terminator */


}  /* end browse_user_input subroutine */

/*;;;;;
 *  Subroutine to load the browse screen with data
 *;;;;;
 */
void load_browse_screen( struct browse_screen_struct *b_s, 
                         int *load_direction,
                         struct drawing_record *m_z,
                         struct RAB *mega_rab)
{

    int     l_sub, l_x;
    char    *tmp, *tmp2, work_str[ 255];



    memset( m_z, ' ', sizeof( struct drawing_record));


    l_sub = -1;


    mega_rab->rab$l_rop = RAB$M_KGE | RAB$M_WAT | RAB$M_RLK;


    if ( *load_direction == LOAD_REVERSE)
    {
        if (memcmp( b_s[ 0].draw_dt, "    ", 4) > 0)
        {
            l_sub = 0;
        }  /* end test for non blank first record */

    }  
    else
    {
        l_sub = L_BROWSE_SCREEN_COUNT - 1;

        //
        //  find the first non blank line from the bottom of the
        //  display array.
        //
        while ((memcmp( b_s[ l_sub].draw_dt, "    ", 4) < 0)  && l_sub >= 0)
            l_sub--;



    } /* end test for reverse load */



    //
    //  Does the screen have a valid starting point for us?
    //
    if ( l_sub >= 0)
    {
        //
        //  draw_dt is mm/dd/yyyy format.
        //  we find the year 6 into it
        //  the month at the start
        //  and the day 3 into it.
        //
        tmp = b_s[ l_sub].draw_dt;
        memcpy( m_z->draw_dt, tmp+6, 4);            // year
        tmp2 = m_z->draw_dt;
        tmp2 += 4;
        memcpy( tmp2, b_s[ l_sub].draw_dt, 2);      // month
        tmp2 +=2;
        memcpy( tmp2, tmp+3, 2);                    // day

    }  /* end test for valid record found */

    //
    //  Here we don't know the compiler doesn't know the size of the array
    //  so we have to tell memset how big.
    //
    memset( b_s, ' ', sizeof( struct browse_screen_struct) 
                      * L_BROWSE_SCREEN_COUNT);


    l_x = sys$find( mega_rab);

    if ( !(l_x & 1))
    {
        printf( "Error %d loading first record\n", l_x);
        return;
    }  /* end test for successfull find */


    //
    //  See if we need to turn on the previous logic
    //
    if ( *load_direction == LOAD_FORWARD)
    {
        mega_rab->rab$l_rop = RAB$M_NXT | RAB$M_WAT | RAB$M_RLK;
    }
    else
    {
        mega_rab->rab$l_rop = RAB$M_REV | RAB$M_NXT | RAB$M_WAT | RAB$M_RLK;
    }  /* end second test of load direction */


    l_sub = 0;
    while ( (l_x & 1)  &&  l_sub < L_BROWSE_SCREEN_COUNT)
    {
        l_x = sys$get( mega_rab);

        //
        //  format the date as mm/dd/yyyy
        //  record format is YYYYMMDD
        //  month is at +4
        //  day is at +6
        //
        tmp = m_z->draw_dt;
        tmp2 = b_s[ l_sub].draw_dt;

        memcpy( tmp2, tmp+4, 2);
        tmp2 += 2;
        *tmp2 = '/';
        tmp2++;
        memcpy( tmp2, tmp+6, 2);
        tmp2 +=2;
        *tmp2 = '/';
        tmp2++;
        memcpy( tmp2, tmp, 4);

        //
        //   Now build a string of the numbers
        //
        sprintf( work_str, "%2d %2d %2d %2d %2d", m_z->no_1,
                                                  m_z->no_2,
                                                  m_z->no_3,
                                                  m_z->no_4,    
                                                  m_z->no_5);

        memcpy( b_s[l_sub].numbers, work_str, strlen( work_str));

        sprintf( work_str, "%2d", m_z->mega_no);

        memcpy( b_s[l_sub].mega_no_txt, work_str, 2);

        l_sub++;

    }  /* end while l_sub loop */

}  /* end load_browse_screen subroutine */

// turn on warnings about $ characters
#pragma message enable (DOLLARID)          

