/*  C_SQLM_ZILL_IMPORT_SUB.C
 *
 *  Subroutine to import comma seperated value text file
 *  into the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <descrip>
#include <libdtdef>
#include <lib$routines>
#include <sql_literals>
#include <ints>

/*
 *  Our headers
 */

#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void commit_mega( int *sqlcode);

void delete_all_draw_recs( int *sqlcode);

extern void insert_draw_rec( );

void parse_csv_line( char *input_line_str, int64 *dt, int8 *no_1, int8 *no_2, int8 *no_3,
                        int8 *no_4, int8 *no_5, int8 *mega_no, int *dt_context);

FILE    *prompt_and_open_csv( void);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_sqlm_zill_import_sub( )
{
    int                     l_x, l_count, sqlcode;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;

    /*
     *  The one draw back with using tinyint in the database is we have to
     *  use int8 for our data type with C.  char is an unsigned byte while
     *  int8 is signed.
    */
    int8                    no_1, no_2, no_3, no_4, no_5, mega_no;
    int64                   draw_dt;
    int                     l_date_context, l_component, l_defaults;

    $DESCRIPTOR( command_str_desc, command_str);
    $DESCRIPTOR( fmt_desc, "|!MNM/!DD/!Y4 !H04!M0!S0!C2|");

    l_date_context = 0;
    l_component = LIB$K_INPUT_FORMAT;
    l_defaults = 127;
    l_x = lib$init_date_time_context( &l_date_context, &l_component, &fmt_desc);


    delete_all_draw_recs( &sqlcode);

    //
    //  obtain a value input file
    //
    in_file = NULL;
    do
    {
        in_file = prompt_and_open_csv();
    }  while ( in_file == NULL);

    //
    //  Read every input record and create an output record
    //
    l_count = 0;
    do
    {
        //  clear out the working areas before any IO occurs.
        //
        memset( line_in, '\0', sizeof( line_in));

        fgets( line_in, sizeof( line_in) -1, in_file);
        if ( !feof( in_file))
        {
            l_count++;

            parse_csv_line( line_in, &draw_dt, &no_1, &no_2, &no_3, &no_4, &no_5, &mega_no,
                            &l_date_context);
            insert_draw_rec( &sqlcode, &draw_dt, &no_1, &no_2, &no_3, &no_4, &no_5, &mega_no);

            if ( sqlcode != SQLCODE_SUCCESS)
            {
                printf( "Error %d writing record %d to indexed file\n", l_x, l_count);
            }

            if ( (l_count % 100) == 0)
            {
                printf( "Processed %d Records\n", l_count);
                commit_mega( &sqlcode);

            }  /* end status message test */
        }  /* end test for successful read */

    } while ( !feof( in_file));

    printf( "Processed %d Records\n", l_count);
    commit_mega( &sqlcode);

    fclose( in_file);

    l_x = lib$free_date_time_context( &l_date_context);

}  /* end c_sqlm_zill_import_sub */

/*;;;;;
 *      Function to obtain a file name from the user and
 *      open the file for input.
 *;;;;;
 */
FILE *prompt_and_open_csv()
{
    int     l_x;
    char    file_name_str[255];
    FILE    *the_file;

    memset( file_name_str, '\0', sizeof( file_name_str));

    printf( "\n\nInput file name: ");
    scanf( "%s", file_name_str);

    the_file = fopen( file_name_str, "r");

    if ( the_file != NULL)
    {
        l_x = ferror( the_file);
        if (l_x != 0)
        {
            printf( "Error %d opening input file\n", l_x);
        }
    }  /* end test for succesful open */

    return the_file;

}  /* end prompt_and_open_csv function */

/*;;;;;
 *      Subroutine to parse the input record
 *      filling in the output record buffer.
 *;;;;;
 */
void parse_csv_line( char *input_line_str, int64 *dt, int8 *no_1,
                    int8 *no_2, int8 *no_3, int8 *no_4, int8 *no_5, int8 *mega_no,
                    int *l_date_context)
{
    char    *tmp, scratch_str[255], *tmp2;
    int	    l_x;

    $DESCRIPTOR( scratch_str_desc, scratch_str);

    //
    //	First field is the date in mm/dd/yyyy format with zero suppression
    //	for the date we will use the safe method of copying the characters we want
    //	into a scratch string then manipulating that.  Later we will work with the values
    //	in place.
    //
    tmp = input_line_str;


    tmp2 = strchr( tmp, ',');
    memset( scratch_str, '\0', sizeof( scratch_str));
    memcpy( scratch_str, tmp, tmp2-tmp);			// copy the MM/DD/YYYY date string

    LENGTH( scratch_str_desc) = strlen( scratch_str);

    l_x = lib$convert_date_string( &scratch_str_desc, dt, l_date_context); 

    //
    //	    Now obtain the drawing numbers
    //	    This time, instead of using the scratch_str as a work area we
    //	    will insert null bytes and work with the string in place.
    //
    tmp = tmp2 + 1;						// skip the comma
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    *no_1 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    *no_2 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    *no_3 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    *no_4 = atoi( tmp);

    tmp = tmp2 + 1;
    tmp2 = strchr( tmp, ',');
    *tmp2 = '\0';
    *no_5 = atoi( tmp);

    //  there is no trailing comma behind the mega number
    //
    tmp = tmp2 + 1;
    *mega_no = atoi( tmp);


}  /* end parse_csv_line subroutine */

