/*  C_SQLM_ZILL_DUE_REPORT_SUB.C
 *
 *  Subroutine to create a report of the most
 *  frequently hit numbers.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <descrip>
#include <lib$routines>
#include <libdtdef>
#include <ints.h>
#include <sql_literals>

/*
 *  Our headers
 */

#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *DUE_RPT_FILE_NAME = "ZILL_DUE.RPT";


/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void close_due_draw( int *sqlcode);

void close_due_mega( int *sqlcode);

void commit_mega( int *sqlcode);

void fetch_due_draw( int *sqlcode, int8 *elm_no, int *hit_count, int *since_last, double *pct_hits, double *ave_btwn);

void fetch_due_mega( int *sqlcode, int8 *elm_no, int *hit_count, int *since_last, double *pct_hits, double *ave_btwn);

void open_due_draw( int *sqlcode);

void open_due_mega( int *sqlcode);

void write_due_report( FILE *rpt_file);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_sqlm_zill_due_report_sub( )
{
    int                     l_x, default_operations, sqlcode;
    char                    command_str[255];
    FILE                    *rpt_file;

    $DESCRIPTOR( command_str_desc, command_str);


    rpt_file = fopen( DUE_RPT_FILE_NAME, "w", 
                      "ctx=rec","mrs=80", "rat=cr", "rfm=var");

    open_due_draw( &sqlcode);
    open_due_mega( &sqlcode);

    //
    //  Print the report
    //
    write_due_report( rpt_file);

    fclose( rpt_file);

    close_due_draw( &sqlcode);
    close_due_mega( &sqlcode);

    commit_mega( &sqlcode);

    sprintf( command_str, "EDIT/READ %s", DUE_RPT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end c_sqlm_zill_due_report_sub */

/*;;;;;
 *  Subroutine to write the report from our sorted working arrays.
 *;;;;;
 */
void write_due_report( FILE *rpt_file)
{
    int     l_x;
    time_t  the_time;
    char    work_str[255];

    int8    elm_no;
    int     hit_count, last_draw_no, since_last, curr_seq, longest_seq, max_btwn, sqlcode;
    double  pct_hits;
    double  ave_btwn;


    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));
    
    //
    //  First heading
    //
    fprintf( rpt_file, "%s %31.31s Due Numbers Report\n\n", work_str, " ");
    fprintf( rpt_file, "%29.29sRegular Drawing Numbers\n\n\n", " ");
    
    //
    //  Column headings
    //
    fprintf( rpt_file, "No   Hits   Since   Pct_hits   Ave_btwn\n");
    fprintf( rpt_file, "--   ----   -----   --------   --------\n");


    fetch_due_draw( &sqlcode, &elm_no, &hit_count, &since_last, &pct_hits, &ave_btwn);

    while ( sqlcode == SQLCODE_SUCCESS)
    {
        fprintf( rpt_file, "%2d   %4d   %4d     %5.3f    %5.3f\n",
                    elm_no,
                    hit_count,
                    since_last,
                    pct_hits,
                    ave_btwn);

        fetch_due_draw( &sqlcode, &elm_no, &hit_count, &since_last, &pct_hits, &ave_btwn);

    }  /* end for l_x loop */



    //
    //  Second heading
    //
    fprintf( rpt_file, "\f%s %31.31s Due Numbers Report\n\n", work_str, " ");
    fprintf( rpt_file, "\n\n\n%30.30sMega Drawing Numbers\n\n\n", " ");
    
    //
    //  Column headings
    //
    fprintf( rpt_file, "No   Hits   Since   Pct_hits   Ave_btwn\n");
    fprintf( rpt_file, "--   ----   -----   --------   --------\n");


    fetch_due_mega( &sqlcode, &elm_no, &hit_count, &since_last, &pct_hits, &ave_btwn);

    while (sqlcode == SQLCODE_SUCCESS)
    {

            fprintf( rpt_file, "%2d   %4d   %4d     %5.3f    %5.3f\n",
                    elm_no,
                    hit_count,
                    since_last,
                    pct_hits,
                    ave_btwn);
        fetch_due_mega( &sqlcode, &elm_no, &hit_count, &since_last, &pct_hits, &ave_btwn);

    }  /* end for l_x loop */

}  /* end write_due_report subroutine */
