/*  C_SQLM_ZILL_BROWSE_SUB.C
 *
 *  Subroutine to browse drawing records
 *  in the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <descrip>
#include <libdtdef>
#include <lib$routines>
#include <sql_literals>
#include <fdvdef>
#include <fms_prototypes>
#include <ints>

/*
 *  Our headers
 */

#define LENGTH(descriptor)      descriptor.dsc$w_length


struct  browse_screen_struct
{
    char    f_mark;
    char    draw_dt[10];
    char    numbers[30];
    char    mega_no_txt[2];
};



/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int LOAD_FORWARD = 0;
const int LOAD_REVERSE = 1;
const int L_DONE = 99;
const int L_BROWSE_SCREEN_COUNT = 10;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void close_all_draw( int *sqlcode);

void commit_mega( int *sqlcode);

void count_draw( int *sqlcode, int *l_count);

void fetch_all_draw( int *sqlcode, int64 *draw_dt, int8 *no_1, int8 *no_2, int8 *no_3,
                     int8 *no_4, int8 *no_5, int8 *mega_no);

void browse_user_input( int *l_action, 
                        struct browse_screen_struct *b_s,
                        int *load_direction, int l_count, int *l_current_sub);

void load_browse_screen( struct browse_screen_struct *b_s, 
                         int *load_direction, int l_count, int *l_current_sub);

void open_all_draw( int *sqlcode);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */

// turn off warnings about $ characters
#pragma message disable (DOLLARID)          

void c_sqlm_zill_browse_sub( int *fms_status, int *rms_status, 
                        int *tca_array, int *workspace_array)
{
    int                     l_x, l_load_direction;
    int                     l_action, l_y;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;

    int64                   draw_dt;
    int8                    no_1, no_2, no_3, no_4, no_5, mega_no;
    int                     sqlcode, l_count, l_current_sub;
    int                     l_date_context, l_component, l_defaults;
    char                    work_str[255];

    struct  browse_screen_struct    *screen_rec;
    struct  dsc$descriptor          dt_desc;

    $DESCRIPTOR( form_name_desc, "ZILL_BROWSE");
    $DESCRIPTOR( command_str_desc, command_str);
    $DESCRIPTOR( fmt_desc, "|!Y4/!MNM/!DD|");

    //
    //  allocate an array to hold all of the records.
    //
    l_count = 0;
    count_draw( &sqlcode, &l_count);

    screen_rec = (struct browse_screen_struct *) calloc( l_count+1, sizeof( struct browse_screen_struct));

    l_date_context = 0;
    l_component = LIB$K_OUTPUT_FORMAT;
    l_defaults = 127;
    l_x = lib$init_date_time_context( &l_date_context, &l_component, &fmt_desc);
    
    dt_desc.dsc$b_dtype         = DSC$K_DTYPE_T;
    dt_desc.dsc$b_class         = DSC$K_CLASS_S;
    dt_desc.dsc$w_length        = 10;

    //
    //  Load the array
    //
    open_all_draw( &sqlcode);
    l_y = 0;
    while ( l_y < l_count && sqlcode == SQLCODE_SUCCESS)
    {
        fetch_all_draw( &sqlcode, &draw_dt, &no_1, &no_2, &no_3, &no_4, &no_5, &mega_no);

        dt_desc.dsc$a_pointer   = (char *)&screen_rec[ l_y].draw_dt[0];
        l_x = lib$format_date_time( &dt_desc, &draw_dt, &l_date_context);

        sprintf( work_str, "%2d %2d %2d %2d %2d", no_1, no_2, no_3, no_4, no_5);
        memcpy( screen_rec[ l_y].numbers, work_str, strlen( work_str));

        sprintf( work_str, "%2d", mega_no);
        memcpy( screen_rec[ l_y].mega_no_txt, work_str, strlen( work_str));

        l_y++;

    }  /* end while loop to load array */

    close_all_draw( &sqlcode);

    commit_mega( &sqlcode);

    l_x = lib$free_date_time_context( &l_date_context);

    l_y = 0;
    l_current_sub = -9;                // first pass through we need this to zero out
    l_x = fdv$spada( &l_y);

    l_x = fdv$cdisp( &form_name_desc);

    l_load_direction = LOAD_FORWARD;

    l_action = 0;

    do
    {
        browse_user_input( &l_action, screen_rec, &l_load_direction, l_count, &l_current_sub);

    } while ( l_action != L_DONE);


    free( screen_rec);
    return;

}  /* end c_sqlm_zill_browse_sub */

/*;;;;;
 *  Subroutine to handle user interaction scrolling through the input.
 *;;;;;
 */
void browse_user_input( int *l_action, 
                        struct browse_screen_struct *b_s,
                        int *load_direction, int l_count, int *l_current_sub)
{
    int     l_x, l_terminator;

    struct  dsc$descriptor_s    b_s_desc;

    load_browse_screen( b_s, load_direction, l_count, l_current_sub);

    //
    //  hand build a string descriptor for our browse
    //  screen array.
    //
    b_s_desc.dsc$w_length   = sizeof( struct browse_screen_struct) * 10;
    b_s_desc.dsc$b_dtype    = DSC$K_DTYPE_T;
    b_s_desc.dsc$b_class    = DSC$K_CLASS_S;
    b_s_desc.dsc$a_pointer  = (void *)&b_s[ *l_current_sub];

    l_terminator = 0;

    l_x = fdv$putal( &b_s_desc);

    l_x = fdv$getal( &b_s_desc, &l_terminator);

    switch( l_terminator)
    {
        case FDV$K_FK_E6:       *load_direction = LOAD_FORWARD;
                                break;
        case FDV$K_FK_E5:       *load_direction = LOAD_REVERSE;
                                break;
        case FDV$K_FK_F10:      *l_action = L_DONE;
                                break;

    }  /* end switch of terminator */


}  /* end browse_user_input subroutine */

/*;;;;;
 *  Subroutine to load the browse screen with data
 *;;;;;
 */
void load_browse_screen( struct browse_screen_struct *b_s, 
                         int *load_direction, int l_count, int *l_current_sub)
{
    int     l_sub, l_x;
    char    *tmp, *tmp2, work_str[ 255];


    if ( *load_direction == LOAD_REVERSE)
    {
        l_sub = *l_current_sub - 9;     // leave first record at bottom
    }  
    else
    {
        l_sub = *l_current_sub + 9;     // new starting point 1 short from end of screen
    } /* end test for reverse load */


    if ( l_sub < 0)
    {
        l_sub = 0;
        l_x = fdv$bell();
    }

    if ( l_sub >= l_count-10)
    {
        l_x = fdv$bell();
        l_sub = l_count - 10;
    }

    *l_current_sub = l_sub;

}  /* end load_browse_screen subroutine */

// turn on warnings about $ characters
#pragma message enable (DOLLARID)          

