/*  C_SQLM_DUMP_DRAW_DATA_SUB.C
 *
 *  Subroutine to perform a dump of drawing data to a report
 *  over a range of dates.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>


/*
 *      VMS headers
 */
#include <starlet>
#include <descrip>
#include <libdtdef>
#include <lib$routines>
#include <ints>
#include <sql_literals>

/*
 *  Our headers
 */
#define LENGTH(descriptor)      descriptor.dsc$w_length


/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const char *DUMP_RPT_FILE_NAME = "ZILL_DUMP.RPT";

const int PAGE_SIZE = 60;


/*;;;;;
 *      Function prototypes
 *;;;;;
 */
void close_all_draw( int *sqlcode);

void commit_mega( int *sqlcode);

void fetch_all_draw( int *sqlcode, int64 *draw_dt, int8 *no_1, int8 *no_2, 
                     int8 *no_3, int8 *no_4, int8 *no_5, int8 *mega_no);

void open_all_draw( int *sqlcode);

void write_dump_report_line( int *line_count, 
                             int *page_count, 
                             int64 draw_dt, int8 no_1, int8 no_2,
                             int8 no_3, int8 no_4, int8 no_5,
                             int8 mega_no, int *l_date_context,
                             FILE *rpt_file);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */
void c_sqlm_dump_draw_data_sub( )
{
    int                     l_x, default_operations;
    int                     line_count, page_count;
    char                    command_str[255];
    FILE                    *rpt_file;

    int                     sqlcode, l_date_context, l_component;
    int64                   draw_dt;
    int8                    no_1, no_2, no_3, no_4, no_5, mega_no;


    $DESCRIPTOR( command_str_desc, command_str);
    $DESCRIPTOR( dt_fmt_str_desc, "|!Y4-!MN0-!D0|");


    line_count = PAGE_SIZE;         // force first page break;
    page_count = 0;

    rpt_file = fopen( DUMP_RPT_FILE_NAME, "w", 
                      "ctx=rec","mrs=80", "rat=cr", "rfm=var");

    l_date_context = 0;
    l_component = LIB$K_OUTPUT_FORMAT;

    l_x = lib$init_date_time_context( &l_date_context, &l_component, &dt_fmt_str_desc);

    open_all_draw( &sqlcode);

    while (sqlcode == SQLCODE_SUCCESS)
    {
        fetch_all_draw( &sqlcode, &draw_dt, &no_1, &no_2, &no_3, &no_4, &no_5, &mega_no);

        if ( sqlcode == SQLCODE_SUCCESS)
            write_dump_report_line( &line_count, 
                                    &page_count, 
                                    draw_dt, no_1, no_2, no_3, no_4, no_5, mega_no,
                                    &l_date_context,
                                    rpt_file);
    }  /* end while l_x loop */
    
    close_all_draw( &sqlcode);
    commit_mega( &sqlcode);

    fclose( rpt_file);

    l_x = lib$free_date_time_context( &l_date_context);

    sprintf( command_str, "EDIT/READ %s", DUMP_RPT_FILE_NAME);
    LENGTH( command_str_desc) = strlen( command_str);

    l_x = lib$spawn( &command_str_desc);

}  /* end c_sqlm_dump_draw_data_sub */

void write_dump_page_heading( int *page_count, FILE *rpt_file)
{
    time_t  the_time;
    char    work_str[255];

    
    if (*page_count > 1)
        fprintf( rpt_file, "\f");

    //
    //  Format system date into a string for display
    //
    the_time = time(0);
    memset( work_str, '\0', sizeof( work_str));

    strftime( work_str, sizeof( work_str)-1, "%x", 
                localtime( &the_time));
    
    fprintf( rpt_file, "%s %20.20s Drawing Number Report          Page: %d\n",
                work_str, " ", *page_count);
    fprintf( rpt_file, "    Drawing      No   No   No   No   No     Mega\n");
    fprintf( rpt_file, "     Date         1    2    3    4    5      No\n");
    fprintf( rpt_file, "------------     --   --   --   --   --     ----\n");

}  /* end write_dump_page_heading subroutine */

void write_dump_report_line( int *line_count, 
                             int *page_count, 
                             int64 draw_dt, int8 no_1, int8 no_2,
                             int8 no_3, int8 no_4, int8 no_5, int8 mega_no,
                             int *l_date_context,
                             FILE *rpt_file)
{
    char work_str[12];
    int         l_x;

    $DESCRIPTOR( work_str_desc, work_str);

    if ( *line_count >= PAGE_SIZE)
    {
        *line_count = 5;
        *page_count = *page_count + 1;
        write_dump_page_heading( page_count, rpt_file);
    }  /* end test for page break */

    //
    //  Move the date into a null terminated string for printing
    //
    memset( work_str, '\0', sizeof( work_str));
    l_x = lib$format_date_time( &work_str_desc, &draw_dt, l_date_context);
    work_str[11] = '\0';        // returned date is not null terminated

    fprintf( rpt_file, "%s      %2d   %2d   %2d   %2d   %2d       %2d\n",
               work_str, 
               no_1,
               no_2,
               no_3,
               no_4,
               no_5,
               mega_no);

    *line_count = *line_count + 1;
               
}  /* end write_dump_report_line */

