/*  C_MY_ZILL_BROWSE_SUB.C
 *
 *  Subroutine to browse drawing records
 *  in the Mega example application.
 *
 */
/*
 *      ANSI headers
 */
#include <stdlib>
#include <stdio>
#include <string>
#include <time>

/*
 *      VMS headers
 */
#include <starlet>
#include <rms>
#include <stsdef>
#include <descrip>
#include <lib$routines>
#include <fdvdef>
#include <fms_prototypes_upper>

/*
 *  Our headers
 */
#include <mysql.h>

#define LENGTH(descriptor)      descriptor.dsc$w_length


struct  browse_screen_struct
{
    char    f_mark;
    char    draw_dt[10];
    char    numbers[30];
    char    mega_no_txt[2];
};

/*;;;;;
 *  Program constants and global data
 *;;;;;
 */
const int LOAD_FORWARD = 0;
const int LOAD_REVERSE = 1;
const int L_DONE = 99;
const int L_BROWSE_SCREEN_COUNT = 10;


MYSQL_TIME              Sql_Draw_Dt;
MYSQL_STMT              *Stmt;
MYSQL_RES               *Prep_Meta_Result;
MYSQL_BIND              Bind[7];
my_bool                 Is_Null[7];
unsigned long           Fld_Length[7];
int                     L_No_1, L_No_2, L_No_3, L_No_4, L_No_5, L_Mega_No;

MYSQL                   *Passed_Conn;

/*;;;;;
 *      Function prototypes
 *;;;;;
 */

void browse_user_input( int *l_action, 
                        struct browse_screen_struct *b_s,
                        int *load_direction,
                        int *curr_row);

void load_browse_screen( struct browse_screen_struct *b_s, 
                         int *load_direction,
                         int *curr_row);

/*;;;;;
 *      Functions and subroutines
 *;;;;;
 */

// turn off warnings about $ characters
#pragma message disable (DOLLARID)          

void c_my_zill_browse_sub( int *fms_status, int *rms_status, 
                        int *tca_array, int *workspace_array, MYSQL *conn)
{
    int                     l_x, l_load_direction;
    int                     l_action, l_y, l_curr_row;
    char                    line_in[255], command_str[255];
    FILE                    *in_file;

    $DESCRIPTOR( command_str_desc, command_str);


    struct  browse_screen_struct    screen_rec[L_BROWSE_SCREEN_COUNT];

    $DESCRIPTOR( form_name_desc, "ZILL_BROWSE");


    //
    //  Build query statement
    //
    strcpy( command_str, "SELECT DRAW_DT, NO_1, NO_2, NO_3, NO_4,\
       NO_5, MEGA_NO FROM DRAWING_DATA ORDER BY DRAW_DT ASC;");

    Passed_Conn = conn;

    Stmt = mysql_stmt_init( conn);
    if (!Stmt)
    {
        printf( "%s\n", mysql_error( conn));
    }

    mysql_stmt_prepare( Stmt, command_str, strlen( command_str));

    Prep_Meta_Result = mysql_stmt_result_metadata(Stmt);

    mysql_stmt_execute( Stmt);


    memset( Bind, 0, sizeof( Bind));

    //
    //  Set up the bind array, one element for each column
    //  We have a not NULL constraint on each column
    //  so technically we could have skipped the is_null
    //  elements, but best to give the server some place
    //  to put the result.
    //
    Bind[0].buffer_type     = MYSQL_TYPE_DATE;
    Bind[0].buffer          = (char *)&Sql_Draw_Dt;
    Bind[0].is_null         = &Is_Null[0];
    Bind[0].length          = &Fld_Length[0];

    Bind[1].buffer_type     = MYSQL_TYPE_LONG;
    Bind[1].buffer          = (char *)&L_No_1;
    Bind[1].is_null         = &Is_Null[1];
    Bind[1].length          = &Fld_Length[1];

    Bind[2].buffer_type     = MYSQL_TYPE_LONG;
    Bind[2].buffer          = (char *)&L_No_2;
    Bind[2].is_null         = &Is_Null[2];
    Bind[2].length          = &Fld_Length[2];

    Bind[3].buffer_type     = MYSQL_TYPE_LONG;
    Bind[3].buffer          = (char *)&L_No_3;
    Bind[3].is_null         = &Is_Null[3];
    Bind[3].length          = &Fld_Length[3];

    Bind[4].buffer_type     = MYSQL_TYPE_LONG;
    Bind[4].buffer          = (char *)&L_No_4;
    Bind[4].is_null         = &Is_Null[4];
    Bind[4].length          = &Fld_Length[4];

    Bind[5].buffer_type     = MYSQL_TYPE_LONG;
    Bind[5].buffer          = (char *)&L_No_5;
    Bind[5].is_null         = &Is_Null[5];
    Bind[5].length          = &Fld_Length[5];

    Bind[6].buffer_type     = MYSQL_TYPE_LONG;
    Bind[6].buffer          = (char *)&L_Mega_No;
    Bind[6].is_null         = &Is_Null[6];
    Bind[6].length          = &Fld_Length[6];

    mysql_stmt_bind_result( Stmt, Bind);

    mysql_stmt_store_result( Stmt);


    l_y = 0;
    l_x = FDV$SPADA( &l_y);

    l_x = FDV$CDISP( &form_name_desc);

    l_load_direction = LOAD_FORWARD;

    l_action = 0;
    l_curr_row = -1;

    //
    //  This works because the array is declared locally
    //  so the compiler knows just how big it is.
    //
    memset( screen_rec, ' ', sizeof( screen_rec));

    do
    {
        browse_user_input( &l_action, screen_rec, &l_load_direction, &l_curr_row);

    } while ( l_action != L_DONE);

    mysql_stmt_free_result( Stmt);
    mysql_stmt_close( Stmt);

    return;

}  /* end c_my_zill_browse_sub */

/*;;;;;
 *  Subroutine to handle user interaction scrolling through the input.
 *;;;;;
 */
void browse_user_input( int *l_action, 
                        struct browse_screen_struct *b_s,
                        int *load_direction,
                        int *curr_row)
{
    int     l_x, l_terminator;

    struct  dsc$descriptor_s    b_s_desc;


    load_browse_screen( b_s, load_direction, curr_row);

    //
    //  hand build a string descriptor for our browse
    //  screen array.
    //
    b_s_desc.dsc$w_length   = sizeof( struct browse_screen_struct)
                              * L_BROWSE_SCREEN_COUNT;
    b_s_desc.dsc$b_dtype    = DSC$K_DTYPE_T;
    b_s_desc.dsc$b_class    = DSC$K_CLASS_S;
    b_s_desc.dsc$a_pointer  = (void *)b_s;

    l_terminator = 0;

    l_x = FDV$PUTAL( &b_s_desc);

    l_x = FDV$GETAL( &b_s_desc, &l_terminator);

    switch( l_terminator)
    {
        case FDV$K_FK_E6:       *load_direction = LOAD_FORWARD;
                                break;
        case FDV$K_FK_E5:       *load_direction = LOAD_REVERSE;
                                break;
        case FDV$K_FK_F10:      *l_action = L_DONE;
                                break;

    }  /* end switch of terminator */

}  /* end browse_user_input subroutine */

/*;;;;;
 *  Subroutine to load the browse screen with data
 *;;;;;
 */
void load_browse_screen( struct browse_screen_struct *b_s, 
                         int *load_direction,
                         int *curr_row)
{
    int     l_sub, l_row_count, l_fetch_result;
    char    work_str[ 255];

    //
    //  find out how many rows are in the result set.
    //
    l_row_count = mysql_stmt_num_rows( Stmt);

    l_sub = -1;

    //
    //  Now calculate a starting subscript.
    //
    if ( *load_direction == LOAD_REVERSE)
    {
        l_sub = *curr_row - (L_BROWSE_SCREEN_COUNT - 1);
        if ( l_sub < 0)
        {
            l_sub = 0;
            FDV$BELL();
        }
    }  
    else
    {
        if (*curr_row == -1)
        {
            l_sub = 0;
        }
        else
        {
            l_sub = *curr_row + L_BROWSE_SCREEN_COUNT - 1;
            if ( (l_sub + L_BROWSE_SCREEN_COUNT - 1) >= l_row_count)
            {
                l_sub = l_row_count - (L_BROWSE_SCREEN_COUNT - 1);
                FDV$BELL();
            }
        }  /* end test for first load of empty screen */

    } /* end test for reverse load */

    memset( b_s, ' ', sizeof( struct browse_screen_struct) 
                      * L_BROWSE_SCREEN_COUNT);

    *curr_row = l_sub;
    mysql_stmt_data_seek( Stmt, l_sub);

    l_sub = 0;
    while ( (l_fetch_result = mysql_stmt_fetch( Stmt)) == 0  
                &&  l_sub < L_BROWSE_SCREEN_COUNT)
    {

        sprintf( work_str, "%02d/%02d/%4d", Sql_Draw_Dt.month,
                    Sql_Draw_Dt.day, Sql_Draw_Dt.year);

        memcpy( b_s[l_sub].draw_dt, work_str, strlen( work_str));

        //
        //   Now build a string of the numbers
        //
        sprintf( work_str, "%2d %2d %2d %2d %2d", L_No_1,
                                                  L_No_2,
                                                  L_No_3,
                                                  L_No_4,    
                                                  L_No_5);

        memcpy( b_s[l_sub].numbers, work_str, strlen( work_str));

        sprintf( work_str, "%2d", L_Mega_No);

        memcpy( b_s[l_sub].mega_no_txt, work_str, 2);

        l_sub++;

    }  /* end while l_sub loop */

    *curr_row = *curr_row + l_sub;

}  /* end load_browse_screen subroutine */

// turn on warnings about $ characters
#pragma message enable (DOLLARID)          

