
/******************************************************************************
;    (c) 1995-1998 E.M. Serrat		emserrat@geocities.com
;    
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
*******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <linux/types.h>
#include <linux/cdrom.h>
#include <linux/if_packet.h>
#include <sys/socket.h>

/*-------------------------------------------------------------------------*/
void main(argc, argv)
	int argc;
	int *argv[];
{
	int			cdfd,sockfd,result,addrlen,i;
	char			buf[512],cdname[20];
	struct	sockaddr_ll	addr;
	struct 
	{
		unsigned char dest[6];
		unsigned char src[6];
		unsigned short prot;
		unsigned char header[30];
		int	      lbn;
		int	      bcnt;
		unsigned char filler[504];	// Pure COBOL ;-)
	} request;
	struct 
	{
		unsigned char dest[6];
		unsigned char src[6];
		unsigned short prot;
		unsigned char header[30];
		unsigned char buf[512];		
	} response;

	if (argc != 2)
	{
		printf("Usage: pcdserver /dev/cdrom \n");
		exit(0);
	}

	sprintf(cdname,"%s",argv[1]);
  	if ((sockfd=socket(AF_PACKET,SOCK_RAW,0x3737)) == -1) 
	{
    		perror("socket");
    		exit(-1);
  	}
	if ((cdfd=open(cdname,O_RDONLY|O_NONBLOCK)) < 0)
	{
		perror("Error opening cdrom block device");
		printf("%s\n",cdname);
		exit(-1);
	}
	
	while(recvfrom(sockfd,&request,556,0,(struct sockaddr *)&addr,&addrlen))
	{
		for (i=0; i < 6; i++) 
		{
			response.dest[i]=request.src[i];
			response.src[i]=request.dest[i];
		}
		response.prot=request.prot;
		if (lseek(cdfd,512*request.lbn,SEEK_SET) < 0)
		{
			perror("LSEEK");
			exit(-1);
		}
		request.bcnt /= 512;
		while (request.bcnt-- > 0)
		{
			if (read(cdfd,response.buf,512) < 0)
			{
				perror("READING CDROM block device");
				exit(-1);
			}
			if (sendto(sockfd,&response,556,0,(struct sockaddr *)&addr,addrlen) < 0)
			{
				perror("WRITING block to network");
				exit(-1);
			}
		}
	}
	close(sockfd);
	close(cdfd);
}
