                            ƹ $      RCP011.B                                                                                                                                                                                                     @               RCP011.B  BACKUP/NOASSIST/COMMENT=VAX/VMS SPKITBLD Procedure/INTER/LOG/VERIFY [.B]*.* RPC$:[000000]RCP011.B/LABEL=(RCP)/SAVE/BLOCK=9000/GROUP=25/NOINIT/NOREWI  VAX/VMS SPKITBLD Procedure  SUKONNIK         PΕ      V5.4	 	 _LASSIE:: 
 h 	  _$1$DUA8:  V5.4 
  $                                  * [B]BANK.C;5 +  , %   .     /    4 }                           - E9   0   1    2   3      K  P   W   O     5   6 NH  7 `Ε  8          9          G   H  J                     
#ifndef lint
static char sccsid[] = "%W%     (ultrix)        %G%";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifdef vms
#include <base.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <unixlib.h>
#else
#include <idl/c/base.h>
#endif vms
#include "bank.h"
 
#include <sys/types.h>
#ifdef vms
#include <sys/time.h>
#else
#include <sys/times.h>
#endif vms

#include <stdio.h>
#include <rrpc.h>
/* pfm.h must be included last. Else you get
 *       assorted compiler errors.
 */

#ifdef vms
#include <idl/pfm.h>
#else
#include <idl/c/pfm.h>
#endif
pfm_$cleanup_rec        crec;
char *acct_name;
char *bank_name;
char *function;
int   dollars;
char *my_name;
char noname[] = "no name given for depositor..\n";

static void DoDeposit(), DoWithdraw(), DoInquire(), DoDelete(), DoList();
static void DoShutdown();

static struct cmd_t {
    char name[20];
    void (*proc)();
} CmdTable[] = {
    {"deposit",     DoDeposit},
    {"withdraw",    DoWithdraw},
    {"list",     DoList},
    {"inquire",     DoInquire},
    {"delete",        DoDelete},
    {"shutdown",        DoShutdown},
    {"",            NULL}
};

static char             client_error_print_buf[100];
# define                client_error_$print( st ) { \
error_$c_text( st,client_error_print_buf, \
        sizeof(client_error_print_buf)); \
        printf("(%s) %s\n",my_name, client_error_print_buf); \
}

void Usage();

handle_t            server_handle;

/*
 * main
 *
 * Main program.
 */

#ifdef vms
main(argc,argv)
#else
void main(argc, argv)
#endif
int argc;
char *argv[];
{
    uuid_$t bank_id;
    uuid_$t bank$uid;
#   define MAX_LOCS 3
    bank$acct_t acct;
    status_$t st;
    struct cmd_t *p;
    extern boolean BankNameToID();

    my_name	= argv[0];

    if (argc < 3)
        Usage();

    function	= argv[1];
    bank_name	= argv[2];

    if (argc > 3)
    	acct_name = argv[3];
    else
	acct_name = noname;

    if (argc > 4)
	dollars	= atoi(argv[4]);
    else
	dollars = 0;

 	/* For those of us who like to type:
	 * bank's name function .. etc  instead of
	 * function bank's name .. etc..
	 */
    if (strcmp(function,"Exbank1") == 0 ||
	strcmp(function,"exbank1") == 0 ||
	strcmp(function,"Exbank2") == 0 ||
	strcmp(function,"exbank2") == 0 ){
	 char *saved_bank_name;
	saved_bank_name = function;
	function = bank_name;
	bank_name = saved_bank_name;
	}

    if (strcmp(function,"inquire") == 0)
	dollars = 0;

/********/
PFM_INIT:
/********/
    pfm_$init(pfm_$init_signal_handlers);
    st = pfm_$cleanup(crec);
    if (st.all != pfm_$cleanup_set) {
    /*
     *  The inital pass through the logic will see that
     *  st.all == pfm_$cleanup_set.  Subsequently, the run-time
     *  will bring us here on any program fault. If it is a terminate
     *  request, we exit.  Otherwise, we'll try to limp along..
     */

/*******/
PFM_TRAP:
/*******/
        printf("\n(%s) Cleanup handler entered.. st.all = 0x%X, %D.\n",
                my_name, st.all, st.all);
        client_error_$print(st);
	pgm_$exit();
    }
    if (! BankNameToID(bank_name, &bank_id)) {
        printf("\n(%s) Unknown bank:  \"%s\"\n",my_name,bank_name);
        Usage();
        exit(1);
    }
    if (! GetBankTypeID(&bank$uid) ) {
        printf("(%s) Unable to get bank type uuid.\n",my_name);
        exit(1);
    }
    if (strcmp(function, "list") == 0)
	goto DOLIST;

    if (strcmp(function, "create") == 0) {
        bank$create_acct(&bank_id, acct_name, strlen(acct_name), &acct, &st);
        if (st.all != status_$ok) {
            printf("(%s) Can't create account:  \"%s\" ? (Status code = 0x%08x)\n",my_name, acct_name, st);
            exit(1);
        }

	DoInquire(&bank_id, acct, "inquire", bank_name, acct_name, dollars);
        exit(0);
    }

    if (strcmp(function, "shutdown") == 0) {
	server_handle = uuid_$t_bind(bank_id);
	DoShutdown(server_handle, acct_name, strlen(acct_name), &acct, &st);
    }
    bank$get_acct(&bank_id, acct_name, strlen(acct_name), &acct, &st);
    if (st.all != status_$ok) {
        printf("(%s) No account information:  %s\n",my_name, acct_name);
        exit(1);
    }

DOLIST:
    for (p = CmdTable; p->proc != NULL; p++)
        if (strcmp(function, p->name) == 0) {
            (*p->proc)(&bank_id, acct, function, bank_name, acct_name, dollars);
            exit(0);
        }

    printf("(%s) Unknown command:  \"%s\"\n",my_name, function);
    Usage();
}


/*
 * DoInquire
 *
 * Inquire about an account.
 */

static void DoInquire(h, acct, function, bank_name, acct_name, dollars)
uuid_$t *h;
bank$acct_t acct;
char *function, *bank_name, *acct_name;
int dollars;
{
    long int balance;
    long int trans_time, create_time;
    status_$t st;

    bank$inq_acct(h, acct, &balance, &trans_time, &create_time, &st);

    if (st.all != status_$ok) {
        printf("(%s) Can't complete inquiry for account ? (Status code = 0x%08x)\n",my_name, st);
        exit(1);
    }

    if (!dollars) {
	printf("\nDepositor: %s", acct_name);
	printf("\nAccount #%ld\n", acct);
	printf("    Balance: $%d\n", balance);
	printf("    Time of creation: %s", ctime(&create_time));
	printf("    Time of last transaction: %s\n", ctime(&trans_time));
    } else
	printf("  $%d\n", balance);
}

/*
 * DoList
 *
 * List all account names..
 */

static void DoList(h, acct, function, bank_name, acct_name, dollars)
uuid_$t *h;
bank$acct_t acct;
char *function, *bank_name, *acct_name;
int dollars;
{
    long  index;
    long int balance;
    long int trans_time, create_time;
    status_$t st;
    char name[32];
    long sindex;

    printf("\n");
    for (sindex = index = 0;;sindex++) {
	index = sindex;

    	bank$list_account_names(h, &index, name, acct, &balance, &trans_time, &create_time, &st);

    if (index < 0) {
	if (index == -2) {/* Returns -2 on deleted account.. */
		continue;
	}
	printf("(%s) list of bank %s ...done...\n",my_name,bank_name);
	exit(0);
    }
    if (st.all != status_$ok) {
        printf("(%s) Can't list account #%d  (Status code = 0x%08x) ...exiting...\n",my_name, st,index);
        exit(1);
    }
    /* Note: The bank server sets index for us..
     */
    printf("Account #%ld, Depositor: %s", index,name);
    printf("    Balance: $%d\n", balance);
    printf("    Time of creation: %s", ctime(&create_time));
    printf("    Time of last transaction: %s\n", ctime(&trans_time));
  }
}


/*
 * DoDelete   
 *
 * Delete an account.
 */

static void DoDelete(h, acct, function, bank_name, acct_name, dollars)
uuid_$t *h;
bank$acct_t acct;
char *function, *bank_name, *acct_name;
int  dollars;
{
    status_$t st;
    bank$acct_t iacct;

    bank$get_acct(h, acct_name, strlen(acct_name), &iacct, &st);
    if (st.all != status_$ok) {
        printf("(%s) Can't get account info ? (Status code = 0x%08x)\n",my_name, st);
        exit(1);
    }
    bank$kill_acct(h, acct, &st);

    if (st.all != status_$ok) {
        printf("(%s) Can't delete account ? (Status code = 0x%08x)\n",my_name, st);
        exit(1);
    }
    
    printf("(%s) Account #%ld for depositor  %s  deleted.\n",my_name,acct,acct_name);
}


/*
 * DoDeposit
 *
 * Deposit into an account
 */

static void DoDeposit(h, acct, function, ban                                                                                                                                                                                                           e} $      RCP011.B                       %  E9  [B]BANK.C;5                                                                                                                    }                                           k_name, acct_name, dollars)
uuid_$t *h;
bank$acct_t acct;
char *function, *bank_name, *acct_name;
int  dollars;
{
    status_$t st;

    bank$deposit(h, acct, dollars, &st);

    if (st.all != status_$ok) {
        printf("(%s) Can't deposit into account ? (Status code = 0x%08x)\n",my_name, st);
        exit(1);
    }

    printf("(%s) Deposit of  $%d  into %s's account completed.\n(%s) Current Balance:",my_name, dollars,acct_name,my_name);
    DoInquire(h, acct, "inquire", bank_name, acct_name, dollars);
}


/*
 * DoWithdraw
 *
 * Withdraw from an account
 */

static void DoWithdraw(h, acct, function, bank_name, acct_name, dollars)
uuid_$t *h;
bank$acct_t acct;
char *function, *bank_name, *acct_name;
int dollars;
{
    status_$t st;

    bank$withdraw(h, acct, dollars, &st);

    if (st.all != status_$ok) {
        printf("(%s) Can't complete withdrawal from account ? (Status code = 0x%08x)\n",my_name, st);
        exit(1);
    }
    printf("(%s) Withdrawal of  $%d  from %s's account complete.\n(%s) Current Balance:",my_name, dollars,acct_name,my_name);
    DoInquire(h, acct, "inquire", bank_name, acct_name, dollars);
}

static void DoShutdown(h, acct, function, bank_name, acct_name, dollars)
handle_t *h;
bank$acct_t acct;
char *function, *bank_name, *acct_name;
int dollars;
{
    status_$t st;

	printf("\n(%s) Telling %s server to shut down..\n",my_name,bank_name);
	(*rrpc_$client_epv.rrpc_$shutdown)(h, &st);
	if (st.all != status_$ok) {
		printf("%s Server did not comply with shutdown request ?\n(%s) status = 0x%X\n",my_name,st.all);
	} else {
		printf("(%s) %s shutdown.\n",my_name,bank_name);
		exit(0);
	}
}
/*
 * Usage
 *
 * Print a summary of how to use this application.
 */

void Usage()
{
	printf("(%s) usage:\n\targ 1 = function:\n", my_name);
	printf("\t\tcreate\t\tA new account\n");
	printf("\t\tdelete\t\tAn account\n");
	printf("\t\tdeposit\t\tAdd arg 4 dollars in specified account\n");
	printf("\t\tinquire\t\tGive all information about an account\n");
	printf("\t\tlist\t\tGive all information about all accounts\n");
	printf("\t\tshutdown\tClose the specified bank (shutdown server)\n");
	printf("\t\twithdraw\tSubtract arg 4 dollars from specified account\n");
	printf("\n\targ 2 = bank name\t[ Exbank1 | exbank1 | Exbank2 | exbank2 ]\n", my_name);
	printf("\targ 3 = depositor's name for create, delete, deposit, & withdraw\n");
	printf("\t\tlist function provides depositor's names\n");
	printf("\targ 4 = dollars\t\t[ deposit | withdraw ]\n",my_name);
	printf("\n\targ 1 & 2 may be reversed for ease of use and\n",my_name);
	printf("\t\textraneous arguments are discarded.\n\n",my_name);
	printf("\tExample deposit command:    bank exbank2 deposit guest 5 <cr>\n");
	printf("\tExample list command:    bank list Exbank1 <cr>\n\n");
    exit(1);
}

                                                                                                                                                                                                                                                                                               
 * [B]BANK.IDL;1 +  , 2   .     /    4 J       "                   - E9    0   1    2   3      K  P   W   O     5   6 *  7  ~Ε  8          9          G   H  J                  
{*	%W%	ULTRIX	%G%
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 * First version.							*
 * [ uuid(35c2c6a25000.0d.00.00.c3.66.00.00.00), version(1) ]		*
 ************************************************************************/
 *}

[ uuid(4c750f929b87.02.82.b4.05.1b.00.00.00), version(2) ]
interface bank;

import 
    'nbase.idl';

const
    bank$bad_acct_number       = 16#2ff00001;
    bank$acct_name_not_found   = 16#2ff00002;
    bank$acct_deleted          = 16#2ff00003;

type
    bank$acct_t =
        integer32;

    bank$acct_name_t =
        array[1..32] of char;

procedure bank$create_acct(
    in ref h:       uuid_$t;
    in name:        bank$acct_name_t;
    in namelen:     integer32;
    out acct:       bank$acct_t;
    out st:         status_$t
    );

procedure bank$inq_acct(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    out balance:    integer32;
    out trans_time: integer32;
    out create_time:integer32;
    out st:         status_$t
    );

procedure bank$list_account_names(
    in ref h:       uuid_$t;
    in out	index: integer32;
    out		name: bank$acct_name_t;
    in acct:        bank$acct_t;
    out balance:    integer32;
    out trans_time: integer32;
    out create_time:integer32;
    out st:         status_$t
    );

procedure bank$get_acct(
    in ref h:       uuid_$t;
    in name:        bank$acct_name_t;
    in namelen:     integer32;
    out acct:       bank$acct_t;
    out st:         status_$t
    );

procedure bank$kill_acct(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    out st:         status_$t
    );

procedure bank$deposit(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    in amount:      integer32;
    out st:         status_$t
    );

procedure bank$withdraw(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    in amount:      integer32;
    out st:         status_$t
    );

end;
                                                                                                                                                                                                                                             * [B]BANKD.C;5 +  , 2   .     /    4        q                    - E9    0   1    2   3      K  P   W   O     5   6 -O  7 FΕ  8          9          G   H  J                   
#ifndef lint
static char sccsid[] = "%W%     (ultrix)        %G%";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifdef vms
#include <base.h>
#include <lb.h>
#include <pfm.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <unixlib.h>
#else
#include <idl/c/base.h>
#include <idl/c/lb.h>
#include <idl/c/pfm.h>
#endif vms

#include "bank.h"
#include "util.h"

#ifdef MSDOS
#include <sys\types.h>
#include <time.h>
#else
#include <sys/types.h>
#ifdef vms
#include <sys/time.h>
#define bcmp memcmp
#else
#include <sys/times.h>
#endif vms
#endif

#include <stdio.h>
#include <rrpc.h>

extern uuid_$t uuid_$nil;

#include <errno.h>

#ifdef vms
#include <perror.h>
#else
extern char *sys_errlist[];
#endif vms
#define errstr (sys_errlist[errno])  

static bank$acct_t Account_number;    /* Account # */

static struct acct_t {
    char *name;            /* Text name of account owner */
			   /* Name is stored in malloc'd space.. */
    long index;		   /* index # of account */
    long balance;          /* Account balanc                                                                                                                                                                                                                                                                           xV: $      RCP011.B                       2  E9  [B]BANKD.C;5                                                                                                                                                 ^ 
            e */
    bank$acct_t number;    /* Account # */
    boolean deleted;       /* => account has been deleted */
    long trans_time;       /* Time of last transaction */
    long create_time;      /* Time of creation */
};

#define MAX_ACCTS 100

static uuid_$t BankID;
static lb_$entry_t BankEntry;
static long NextAcct;
static long NumAccts;
static long Total;
static struct acct_t Accts[MAX_ACCTS];
static char *BankName;
static char Annotation[256]="Bank Server for:  ";

/*
 * main
 *
 * Main program.
 */

main(argc, argv)
int argc;
char *argv[];
{
    uuid_$t bank$uid;
    status_$t st, fault_st;
    char name[256];
    unsigned long namelen;
    unsigned long port;
    lb_$entry_t entry;
    lb_$entry_t old_entries[10];
    long n_entries;
    long i;
    int	x;
    socket_$addr_t saddr;
    unsigned long slen;
    pfm_$cleanup_rec crec;
    unsigned long family;

    if (argc < 2)
        Usage();

    BankName= argv[1];

    if (! BankNameToID(BankName, &BankID)) {
        printf("(bankd) Unknown bank - \"%s\"\n", BankName);
        exit(1);
    }
    if (! GetBankTypeID(&bank$uid) ) {
        printf("(bank) Unable to get bank type uuid.\n");
        exit(1);
    }
    LoadBankData();
    printf("(bankd) Loaded %ld accounts, total balance is $%ld\n", NumAccts, Total);
    /*
     * Establish socket we want to listen on and print out the resulting
     * sockaddr.
     */

    family = socket_$family_from_name ("ip", strlen("ip"), &st);
    rpc_$use_family(family, &saddr, &slen, &st);
    if (st.all != 0) {
        printf("(bankd) Can't use_family \"ip\" (%08x)\n", st.all);
        exit(1);
    }

    namelen = sizeof(name);
    rpc_$sockaddr_to_name(&saddr, slen, name, &namelen, &port, &st);

    if (st.all != 0) {
        printf("(bankd) Can't convert sockaddr to name (%08x)\n", st);
        exit(1);
    }

    printf("(bankd) name=\"%.*s\", port=%d\n", (int) namelen, name, port);

    /*
     * Register the interface I support with the RPC runtime.
     */

    rpc_$register(&bank$if_spec, bank$server_epv, &st);
    if (st.all != 0) {
        printf("(bankd) Can't register interface (%08x)\n", st);
        exit(1);
    }

    /*
     * Look in the global location database for any existing entries with
     * my bank object.
     */

    lb_$lookup_object(&BankID, NULL, 1L, &n_entries, old_entries, &st);
    if (st.all == status_$ok) {
        if (n_entries > 0) {
            printf("(bankd) Bank already registered at:\n");
            for (i = 0; i < n_entries; i++) {
                char name[256];
                  
           unsigned long namelen = 256;

                rpc_$sockaddr_to_name(&old_entries[i].saddr, old_entries[i].saddr_len,
                                      name, &namelen, &port, &st);

                if (st.all != status_$ok)
                    printf("(bankd) Can't get name of location %d\n", i);
                else
                    printf("    %.*s[%d]\n", (int) namelen, name, port);
            }
            exit(1);
        }
    }
    else if (st.all != lb_$not_registered)
        printf("(bankd) Warning: bank did not register with Global Broker ? (Status code = 0x%08x)\n", st);

    strcat(Annotation,BankName);
    lb_$register(&BankID, &bank$uid, &bank$if_spec.id, 0, Annotation, &saddr, slen, &BankEntry, &st);
    if (st.all != status_$ok) {
        printf("(bankd) Can't register bank (%08x)\n", st);
        exit(1);
    }

    pfm_$init(pfm_$init_signal_handlers);

    fault_st = pfm_$cleanup(crec);
    if (fault_st.all != pfm_$cleanup_set) {
/*****/
EXIT:
/*****/
        lb_$unregister(&BankEntry, &st);
        if (st.all != status_$ok)
            printf("(bankd) Warning: Couldn't unregister bank ? (Status Code = 0x%08x)\n", st);
    printf("(bankd) Dumping \"%s\"...\n", BankName);

        DumpBankData();
        exit(1);
    }

    rpc_$allow_remote_shutdown((unsigned long) 27,NULL,&st);
    if (st.all != status_$ok) {
	printf("(bankd) Warning: rpc_$allow_remote_shutdown status return not ok ?\n(bankd) Status code is: 0x%X\n(bankd) ..exiting..\n\n",st.all);
	exit(1);
    }
    printf("(bankd) Listening...\n");
    rpc_$listen(1, &st);
    printf("(bankd) rpc_listen returned.. exiting..\n");
    goto EXIT;
}

/*
 * Usage
 *
 * Print a blurb saying how to invoke this program.
 */

Usage()
{
    printf("\n(bankd) usage: bankd  <bank name>\n(bankd) Valid bank names are: Exbank1 | exbank1 | Exbank2 | exbank2\n");
    exit(1);
}


/*
 * DumpBankData
 *
 * Dump out the bank accounts information to a file.
 */

DumpBankData()
{
    FILE *f;
    long i;
    char buff[256];

    sprintf(buff, "%s.new", BankName);

    if ((f = fopen(buff, "w")) == NULL) {
        printf("(bankd) Can't open bank data file for write \"%s\" - %s\n", buff, errstr);
        exit(1);
    }

    fprintf(f, "%ld\n", NextAcct);

    for (i = 0; i < NumAccts; i++) {
	struct acct_t *a = &Accts[i];

        if (! a->deleted)
            fprintf(f, "%s %d %ld %ld %ld\n", 
                    a->name, a->number, a->balance, a->trans_time, a->create_time);
    }

    fclose(f);

    if (rename(buff, BankName) < 0) {
        printf("(bankd) Can't rename new bank file ?  %s\n", errstr);
        exit(1);
    }
}


/*
 * LoadBankData
 *
 * Read in the bank accounts information from a file.
 */

LoadBankData()
{
    FILE *f;
    char buff[100];
    long  i,x;

    if ((f = fopen(BankName, "r")) == NULL) {
	if (BankName[0] == 'e')
	    BankName[0] = 'E';
	else
	    BankName[0] = 'e';

	if ((f = fopen(BankName, "r")) == NULL) {
	  printf("\n(bankd) Can't open specified bank data file. %s\n(bankd) ..exiting...\n\n", errstr);
        exit(1);
	}             
    }
    sleep(1);
    printf("\n(bankd) Loading Bank Data For: \"%s\"...\n", BankName);
    fscanf(f, "%ld\n", &NextAcct);

    Total = 0;
    i = 0;
    while (EOF != fscanf(f, "%s %d %ld %ld %ld\n", 
                         buff, 
                         &Accts[i].number, 
                         &Accts[i].balance,
                         &Accts[i].trans_time,
                         &Accts[i].create_time))
    {
        Accts[i].deleted = false;
        Accts[i].name = SAlloc(buff);
	Accts[i].index = i;
        Total += Accts[i].balance;
        i++;
    }

    fclose(f);

    NumAccts = i;
}


/*
 * CheckObject
 *
 * Check to see if the object referred to by the RPC handle is the object
 * we expect.
 */

static boolean CheckObject(h, st)
uuid_$t *h;
status_$t *st;
{
    if (bcmp(h, &BankID, sizeof(BankID))) {
        printf("(bankd) Request for wrong bank !?\n");
        st->all = -1;       /* "object not found" */
        return(false);
    }

    st->all = status_$ok;
    return(true);
}


/*
 * bank$create_acct
 *
 * Create a new account.
 */

void bank$create_acct(h, name, namelen, acct, st)
uuid_$t *h;
char *name;
long namelen;
bank$acct_t *acct;
status_$t *st;
{
    struct acct_t *p;
    
    if (! CheckObject(h, st))
        return;

    name[namelen] = '\0';
    *acct = NextAcct++;
    p = &Accts[NumAccts++];
    p->name    = SAlloc(name);
    p->index   = NumAccts - 1;
    p->balance = 0;
    p->number  = *acct;
    p->deleted = false;

    p->trans_time = p->create_time = time(NULL);
    DumpBankData(); 
    st->all = status_$ok;
}


/*
 * FindAcct
 *
 * Return the account specified by "acct".  Return NULL if account can't
 * be found.
 */

static struct acct_t *FindAcct(h, index, acct, st)
uuid_$t *h;
long *index;
bank$acct_t acct;
status_$t *st;
{
    long i;

    if (! CheckObject(h, st))
        return(NULL);

    for (i = 0; i < NumAccts; i++) {
        if ((Accts[i].number == acct) || (Accts[i].index == *index)) {
            if (Accts[i].deleted) {
		Account_number = Accts[i].number;
                st->all = bank$acct_deleted;
		*index = -2;
                return(NULL);
            }
            else {
                st->all = status_$ok;
		Account_number =  Accts[i].number;
		*index = i;
                return(&Accts[i]);
            }
       }
    }
    *index = -1;
    st->all = bank$bad_acct_number;
    return(NULL);
}


/*
 * bank$list_account_names
 *
 * Return listing of all accounts.
 */

void bank$list_account_names(h, index, name, acct, balance, trans_time, create_time, st)
uuid_$t *h;
long *index;
char *name;
bank$acct_t acct;
long *balance;
long *trans_time;
long *create_time;
status_$t *st;
{
    struct acct_t *a;
    long lindex;

    lindex = *index;
    if ((a = FindAcct(h, &lindex, acct, st)) == NULL) {
	if (lindex == -2) {
		*index = -2;
		return;
	}
	*index = -1;
        return;
    }
    *index = Account_number;
    *balance = a->balance;
    *trans_time = a->trans_time;
    *create_time = a->create_time;
    strcpy(name,a->name);

    st->all = status_$ok;
}

/*
                                                                                                                                                                                                                                            wn $      RCP011.B                       2  E9  [B]BANKD.C;5                                                                                                                                                 ;R 
            * bank$inq_acct
 *
 * Return information about an account.
 */

void bank$inq_acct(h, acct, balance, trans_time, create_time, st)
uuid_$t *h;
bank$acct_t acct;
long *balance;
long *trans_time;
long *create_time;
status_$t *st;
{
    struct acct_t *a;
    long index;
    index = -1; 
    if ((a = FindAcct(h, &index, acct, st)) == NULL)
        return;

    if (index == -2) /* Account deleted..*/
	return;
 
    *balance = a->balance;
    *trans_time = a->trans_time;
    *create_time = a->create_time;

    st->all = status_$ok;
}


/*
 * bank$get_acct
 *
 * Return an account number, given its name.
 */

void bank$get_acct(h, name, namelen, acct, st)
uuid_$t *h;
char *name;
long namelen;
bank$acct_t *acct;
status_$t *st;
{
    long i;

    if (! CheckObject(h, st))
        return;

    name[namelen] = '\0';

    for (i = 0; i < NumAccts; i++) {
        struct acct_t *a = &Accts[i];

        if ((! a->deleted) && strcmp(name, a->name) == 0) {
            *acct = a->number;
            st->all = status_$ok;
            return;
        }
    }

    st->all = bank$acct_name_not_found;
}


/*
 * bank$deposit
 *
 * Deposit money in an account.
 */

void bank$deposit(h, acct, amount, st)
uuid_$t *h;
bank$acct_t acct;
long amount;
status_$t *st;
{
    struct acct_t *a;
    long index;
    index = -1;
    if ((a = FindAcct(h, &index, acct, st)) == NULL)
        return;

    a->trans_time = time(NULL);
    a->balance += amount;
    DumpBankData();
}


/*
 * bank$withdraw
 *
 * Withdraw money from an account.
 */

void bank$withdraw(h, acct, amount, st)
uuid_$t *h;
bank$acct_t acct;
long amount;
status_$t *st;
{
    struct acct_t *a;
    long index;
    index = -1;
    if ((a = FindAcct(h, &index, acct, st)) == NULL)
        return;

    a->trans_time = time(NULL);
    a->balance -= amount;
    DumpBankData();
}


/*
 * bank$kill_acct
 *
 * Kill an account.
 */
void bank$kill_acct(h, acct, st)
uuid_$t *h;
bank$acct_t acct;
status_$t *st;
{
    struct acct_t *a;
    long index;
    index = -1;
    if ((a = FindAcct(h, &index, acct, st)) == NULL)
        return;

    a->trans_time = time(NULL);
    a->deleted = true;
    DumpBankData(); 
}
                                                                                                                                                                                                                                                                                                                                                                                                                              * [B]BANKS_BUILD.COM;1 +  , %   .     /    4 R                           - E9   0   1    2   3      K  P   W   O 	    5   6 wΕ  7  Ε  8          9          G   H  J                           $!	%W%     VMS/ULTRIX Connection   %G%
$!*****************************************************************************
$!
$!                        COPYRIGHT (C) 1989 BY
$!                DIGITAL EQUIPMENT CORPORATION, MAYNARD
$!                  MASSACHUSETTS. ALL RIGHTS RESERVED.
$!
$!  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$!  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$!  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$!  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$!  PERSON. NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS  HEREBY TRANSFERRED.
$!
$!  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$!  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$!
$!  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$!  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$!
$!*****************************************************************************
$!
$!  USAGE: @build
$!  
$!  Build bank example programs:
$!      bank -- the client
$!      bankd -- the bank server
$!
$
$!
$! Produce the server and client stubs.
$!
$ write sys$output "  NIDLing..."
$ nidl -s [.idl_d]bank.idl -idir rpc$idl:
$!
$! For code portability.
$!
$ define sys        sys$library:
$ define net        sys$library:
$ define netinet    sys$library:
$ define arpa       sys$library:
$ define machine    sys$library:
$ define idl        sys$library:
$ define c$include  rpc$include:, sys$library:
$ goto do_bld
$!
$! Compile all modules.  All include files are in RPC$INCLUDE:
$!
$ do_bld:
$ write sys$output "  Compiling..."
$ if f$search("_vms_b.dir") .eqs. "" then create/dir [._vms_b]
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank_cswtch.obj bank_cswtch
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank_cstub.obj bank_cstub
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank_sstub.obj bank_sstub
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank.obj bank
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bankd.obj bankd
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]util.obj util
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]uuidbind.obj uuidbind
$!
$ deassign sys
$ deassign netinet
$ deassign arpa
$ deassign net
$ deassign machine
$ deassign c$include
$!
$! Build server and client using RPC run-time shared image.
$!
$ set def [._vms_b]
$ write sys$output "  Linking..."
$ write sys$output "  (Ignore %LINK-W-WRNERS and %LINK-I-UDFSYM message)"
$ link/exec=bankd bankd,util,b             ank_sstub,rpc$lib:rpc$libnck.opt/opt
$ link/exec=bank  bank,util,uuidbind,bank_cswtch,bank_cstub, -
  	rpc$lib:rpc$libnck.opt/opt
$ set def [-]
                                                                                                                                                                                                                                                                                                                                                                                               * [B]BANKS_README.;1 +  , 2   .     /    4 M       T                   - E9    0   1    2   3      K  P   W   O     5   6 3Ε  7 @_Ε  8          9          G   H  J                             
#  @(#)README	2.1  ULTRIX  6/23/89

This directory contains a system that uses both RPC and the Location
Broker (LB).  It also demonstrates the use of "auto-binding".  The basic
idea is that there are "banks" that have a number of accounts.  Each
server process serves only one bank.  Client programs locate a bank
via the LB and then make a call to the bank (server) to perform a
transaction at that bank.  The transactions are creating and deleting
an account, depositing to and withdrawing from an account, and inquiring
about the balance in an account.

To run the example, run "bankd" (the server process) and "bank" (the bank
client) on another,or the same, system. Only one "bankd" may be run on
a single system. To obtain access to more than one bank, run "bankd"
on one system and another "bankd" on some other system.

"bankd" takes one argument, the name of a bank. Use either
"Exbank1" or "Exbank2".  The files "Exbank1" and "Exbank2"
contain the contents of two banks (i.e. the account names, numbers &
balances).  "bankd" reads the selected bank file when it is
started.

The initial data files for "Exbank1" and "Exbank2" contain the account
name "guest". New account names may be created as desired.

To options to the "bank" program are:

        arg 1 = function:
                create          A new account
                delete          An account
                deposit         Add arg 4 dollars in specified account
                inquire         Give all information about an account
                list            Give all information about all accounts
                shutdown        Close the specified bank (shutdown server)
                withdraw        Subtract arg 4 dollars from specified account

        arg 2 = bank name       [ Exbank1 | exbank1 | Exbank2 | exbank2 ]
        arg 3 = depositor's name for create, delete, deposit, & withdraw
                list function provides depositor's names
        arg 4 = dollars         [ deposit | withdraw ]

        arg 1 & 2 may be reversed for ease of use                                                                                                                                                                                                                           N $      RCP011.B                       2  E9  [B]BANKS_README.;1                                                                                                             M                                            and
                extraneous arguments are discarded.

For example:

    bankd Exbank1&                -- Start server listening on ip protocol

    bank inquire exbank1 guest       -- Find out how much money guest has

    bank exbank2 deposit guest 3    -- Give guest $3

    bank shutdown exbank1	-- Shutdown bank server for exbank1

                                                                                                                                                                                           * [B]BASE.H;3 +  , :   .     /    4 J       
                    - E9    0   1    2   3      K  P   W   O     5   6 @^  7 `5Ε  8          9          G   H  J                    
/*	@(#)base.h	2.1	(ULTIRX)	6/13/89	*/

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef base__included
#define base__included
#include "idl_base.h"
#include "nbase.h"
#include "timebase.h"
typedef ndr_$long_int status_$all_t;
#define proc1_$n_user_processes 56
#define name_$long_complen_max 255
#define name_$long_pnamlen_max 1023
#define name_$pnamlen_max 256
#define name_$complen_max 32
typedef ndr_$char name_$pname_t[256];
typedef ndr_$char name_$name_t[32];
typedef ndr_$char name_$long_name_t[256];
typedef ndr_$char name_$long_pname_t[1024];
#define ios_$max 127
#define ios_$stdin 0
#define ios_$stdout 1
#define ios_$stderr 2
#define ios_$errin 2
#define ios_$errout 2
#define stream_$stdin ios_$stdin
#define stream_$stdout ios_$stdout
#define stream_$stderr ios_$stderr
#define stream_$errin stream_$stderr
#define stream_$errout stream_$stderr
typedef ndr_$short_int ios_$id_t;
typedef struct ios_$seek_key_t ios_$seek_key_t;
struct ios_$seek_key_t {
ndr_$long_int rec_adr;
ndr_$long_int byte_adr;
};
typedef ndr_$short_int stream_$id_t;
typedef struct uid_$t uid_$t;
struct uid_$t {
ndr_$long_int high;
ndr_$long_int low;
};
#ifdef __STDC__
handle_t uid_$t_bind(uid_$t h);
void uid_$t_unbind(uid_$t uh, handle_t h);
#else
handle_t uid_$t_bind();
void uid_$t_unbind();
#endif
typedef struct xoid_$t xoid_$t;
struct xoid_$t {
ndr_$long_int rfu1;
ndr_$long_int rfu2;
uid_$t uid;
};
typedef struct ec2_$eventcount_t ec2_$eventcount_t;
struct ec2_$eventcount_t {
ndr_$long_int value;
pinteger awaiters;
};
typedef ec2_$eventcount_t *ec2_$ptr_t;
#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 
 * [B]BASE.IDL;1 +  , :   . 	    /    4 i   	                       - E9    0   1    2   3      K  P   W   O 
    5   6   7 wΕ  8          9          G   H  J                  %pascal
{*	@(#)base.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{   BASE - Basic Apollo data types and constants }

[uuid(339b18335000.0d.00.00.80.9c.00.00.00)] interface base_;

import
    'nbase.idl',
    'timebase.idl';

type   
    status_$all_t = 
        integer32;

{ Number of user processes }
   
const  
    proc1_$n_user_processes = 56;


{ Commonly used naming server constants and types }

const  
    name_$long_complen_max = 255;   { Max lnth of a single long component }
    name_$long_pnamlen_max = 1023;  { Max lnth of whole long pathname }
    name_$pnamlen_max = 256;        { Max lnth of whole pathname (obsolete; use name_$long_pnamlen_max) }
    name_$complen_max = 32;         { Max lnth of 1 component (obsolete; use name_$long_complen_max) }

type   
    name_$pname_t = 
        array [1..name_$pnamlen_max] of char;
    name_$name_t  = 
        array [1..name_$complen_max] of char;
    name_$long_name_t = 
        array [1..256] of char;
    name_$long_pname_t =
        array [1..1024] of char;
        

{ Commonly used Streams types }

const
    ios_$max = 127;                 { [0..ios_$max] valid range for ios_$id_t when in use }

    { Beware: COFF (sr10 and later default) format programs run with
      only 3 standard streams (stdin, stdout, errout) and stream 3 is
      not valid in general.  OBJ (pre-sr10 default) format programs run
      with 4 standard streams (stdin, stdout, errin, errout) but don't
      let you write to stream 2 (errout).  Unfortunately, NIDL doesn't
      allow us to do the same hair as is done "/sys/ins/base.ins.pas"
      and "/usr/include/apollo/base.h" to make this less of a problem.
      You're on your own.  This file is designed to be "right" for the
      sr10 and later world. }

    ios_$stdin  = 0;                { system-defined stream id's  }
    ios_$stdout = 1;
    ios_$stderr = 2;

    ios_$errin  = 2;
    ios_$errout = 2;

    stream_$stdin  = ios_$stdin;
    stream_$stdout = ios_$stdout;
    stream_$stderr = ios_$stderr;

    stream_$errin  = stream_$stderr;
    stream_$errout = stream_$stderr;

type
    ios_$id_t = 
        0..ios_$max;                { open stream identifier }

    ios_$seek_key_t = 
        record
            rec_adr:  integer32;
            byte_adr: integer32;
            end;

    stream_$id_t = 
        integer;                    { open stream identifier (same as ios_$id_t) }

    uid_$t = 
        [handle] record
            high: integer32;
            low: integer32;
            end;

    xoid_$t = 
        record                      { for xoids handed to mgrs by streams }
            rfu1: integer32;
            rfu2: integer32;
            uid: uid_$t;
            end;

{ User eventcount definitions  }

    ec2_$eventcount_t = 
        record
            value: integer32;       { current ec value }
            awaiters: pinteger;
            end;

    ec2_$ptr_t = 
        ^ec2_$eventcount_t;


end;
                                                                                                                                   * [B]BINOP.C;4 +  , %$   .     /    4 J       8                   - E9   0   1    2   3      K  P   W   O     5   6  lMȓ  7 @Ε  8          9          G   H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                54 $      RCP011.B                       %$  E9  [B]BINOP.C;4                                                                                                                   J                              ].             
#ifndef lint
static char sccsid[] = "@(#)binop.c	2.1     (ultrix)        7/21/89";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This             	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unixlib.h>

#include "binop.h"

void binop$add(h, a, b, c)
handle_t h;
long a, b, *c;
{
    *c = a + b;
}


                                                                                                                                                                                                                       * [B]BINOP.IDL;1 +  , S'   .     /    4 J                          - E9   0   1    2   3      K  P   W   O     5   6  8  7  Ε  8          9          G   H  J                 
/*	%W%	ULTRIX	%G%
 */
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/


%c
[UUID(334a2e240000.0d.00.00.31.66.00.00.00), port(IP:[6677]),
    version(0)]
interface binop
{                       
[idempotent]
void binop$add(
    handle_t [in] h,
    long [in] a,
    long [in] b,
    long [out] *c
    );
}
                                                                                                                                                                                                                                                   * [B]BINOP_BUILD.COM;1 +  , 2   .     /    4 \       9                   - E9    0   1    2   3      K  P   W   O     5   6 Ε  7  0Ε  8          9          G   H  J                           
$!  %W%	VMS/ULTRIX Connection	%G%
$!**********************************************************************
$!                                                                      
$!                      Copyright (c) 1989 by                           
$!              Digital Equipment Corporation, Maynard, MA  		
$!                      All rights reserved.                            
$!                                                                      
$!   This software is furnished under a license and may be used and     
$!   copied  only  in accordance with the terms of such license and     
$!   with the  inclusion  of  the  above  copyright  notice.   This     
$!   software  or  any  other copies thereof may not be provided or     
$!   otherwise made available to any other person.  No title to and     
$!   ownership of the software is hereby transferred.                   
$!                                                                      
$!   The information in this software is subject to change  without     
$!   notice  and should not be construed as a commitment by Digital     
$!   Equipment Corporation.                                             
$!                                                                      
$!   Digital assumes no responsibility for the use  or  reliability     
$!   of its software on equipment which is not supplied by Digital.     
$!                                                                      
$!**********************************************************************
$!
$!
$ write sys$output "  Generating stubs..."
$ nidl -s [.idl_d]binop.idl -idir rpc$idl:
$
$ if f$search("_vms_b.dir") .eqs. "" then create/dir [._vms_b]
$
$ define sys        sys$library:
$ define net        sys$library:
$ define netinet    sys$library:
$ define arpa       sys$library:
$ define machine    sys$library:
$ define c$include  rpc$include:, sys$library:
$
$ write sys$output "  Compiling..."
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop_cstub.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop_cswtch.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop_sstub.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] client.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] server.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop.c
$
$ set def [._vms_b]
$ write sys$output "  Linking... (Ignore %LINK-W-WRNERS and %LINK-I-UDFSYM messages)"
$ link/exec=client client, binop_cstub, binop_cswtch, -
	rpc$lib:rpc$libnck.opt/opt
$ link/exec=server server, binop, binop_sstub, -
	rpc$lib:rpc$libnck.opt/opt
$
$ set def [-]
$ deassign sys
$ deassign net
$ deassign netinet
$ deassign arpa
$ deassign machine
                                                                                                                                                                                                                      * [B]BINOP_README.;1 +  , 2   .     /    4                          - E9    0   1    2   3      K  P   W   O     5   6 @RΕ  7  UΕ  8          9          G   H  J                             
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/


This directory contains a simple example of the use of RPC.  The "binop"
interface defines just one procedure which adds two numbers and returns
the result.

		* NOTE *
		--------

To make this example as simple as possible, "well-known ports"
are used.  In general, use of well-known ports is to be discouraged.  See
the section on well-known ports in the Network Computing System Reference
manual.  The banks example shows how to write applicati                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        :/ $      RCP011.B                       2  E9  [B]BINOP_README.;1                                                                                                                                                        ons that do
not use well-known ports. Because the sample uses "well-known ports" no
registrations with the location broker will be seen via lb_admin.


To run the example, run "server" as one process and "client" as another 
process, perhaps on another machine.  "server" takes one argument -- 
the integer address family the server should listen on.  "client" takes 
three arguments -- the name of the machine running the server (which may 
be expressed as #numeric_network_address), the integer address family
of the server, and the number of passes.  "client" will print out some
statistics after each pass and a sample of some calculations being
performed.

For Example:

    server 2                -- Start server listing on IP

    client somehost 2 3     -- Start client talking to "somehost"

    client #10.00.12.13 2 3 -- Start client talking to IP
				host at address 10.00.12.13.

                               (note: some shells might require that
				#10.00.12.13 be enclosed in quotes)


                                
 * [B]CAL.H;5 +  , :   .     /    4 e       	                   - E9    0   1    2   3      K  P   W   O 
    5   6 ?  7 @qΕ  8          9          G   H  J                     
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*  cal.h -- marlena 88/9/28 

      Declarations of portable cal_$ procedures.

      Your application must include 'nbase.h' and 'timebase.h'
      prior to including this file.

     Gotchas:
       o The unix timeval struct is not exactly the
         same as time_$timeval_t (as defined in ubase.ins.pas)
         The field names differ. 
         This file now uses the Aegis structure.

    Changes
    01/17/89 marlena  For apollos: #includ             e apollo/cal.h.  Also,
                      we add the signatures for those routines
                      not in apollo/cal.h (i.e cal_$*timeval* )
    01/16/89 marlena  time_$timeval_t is now the Aegis  struct, not a macro
                      for the bsd timeval struct.
    12/21/88 marlena  Changed apparent calling sequences so that all
                      'in' params appear to be called by value.
                      Changed some return values to exactly match those
                      in /usr/include/apollo/cal.h
    09/30/88 marlena 'long enum' is now 'enum'

****************************************************/

#ifndef apollo_base_h 
typedef struct {
    long sec;
    long usec;
} time_$timeval_t;
#endif

typedef enum {time_$relative, time_$absolute} time_$rel_abs_t;


/* CMP_CLOCK: Returns 1 if c1 > c2, -1 if c1 < c2, 0 if equal 
 *
 * Usage: short cal_$cmp_clock(
 *           [in] time_$clock_t c1,
 *           [in] time_$clock_t c2
 *         );
 */
extern short cal_real_$cmp_clock(
#ifdef __STDC__
    time_$clock_t *c1,
    time_$clock_t *c2
#endif
);


/* 
 * Usage: void cal_$add_clock(
 *           [in out] time_$clock_t *dest,
 *           [in] time_$clock_t src
 *         );
 */
extern void cal_real_$add_clock(
#ifdef __STDC__
     time_$clock_t *dest,
     time_$clock_t *src
#endif
);


/* 
 * Usage: boolean cal_$sub_clock(
 *           [in out] time_$clock_t *dest,
 *           [in] time_$clock_t src
 *         );
 */
extern boolean cal_real_$sub_clock(
#ifdef __STDC__
    time_$clock_t *dest,
    time_$clock_t *src
#endif
);


/* 
 * Usage: unsigned long cal_$clock_to_sec(
 *           [in] time_$clock_t clock
 *         );
 */
extern unsigned long cal_real_$clock_to_sec(
#ifdef __STDC__
     time_$clock_t *clock
#endif
);


/* 
 * Usage: void cal_$sec_to_clock(
 *           [in] time_$clock_t sec,
 *           [out] time_$clock_t *clock
 *         );
 */
extern void cal_real_$sec_to_clock(
#ifdef __STDC__
     unsigned long   sec,
     time_$clock_t *clo                                            @ #define SQL_EOS 100		/* SELECT or cursor got to end of stream */  L /*                                                                          P  * SQL Error statuses                                                           M  */                                                                           @ #define SQL_RDBERR -1           /* Rdb returned an error		    */I #define SQL_OUTOFRAN -304	/* Value is out of range for a host variable */ N #define SQL_NULL        [in] time_$clock_t clock
 *           [out] time_$timeval_t *timeval,
 *         );
 */
extern void cal_real_$clock_to_timeval(
#ifdef __STDC__
     time_$rel_abs_t flag,
     time_$clock_t  *clock,
     time_$timeval_t   *timeval
#endif
);

#ifndef apollo
/* Declarations for non-apollos */
#define cal_$cmp_clock(c1,c2)                       cal_real_$cmp_clock(&c1,&c2)
#define cal_$add_clock(dest,src)                    cal_real_$add_clock(dest,&src)
#define cal_$sub_clock(dest,src)                    cal_real_$sub_clock(dest,&src)
#define cal_$clock_to_sec(clock)                    cal_real_$clock_to_sec(&clock)
#define cal_$sec_to_clock(sec,clock)                cal_real_$sec_to_clock(sec, clock)
#define cal_$timeval_to_clock(flag, timeval,clock)  cal_real_$timeval_to_clock(flag, &timeval, clock)
#define cal_$clock_to_timeval(flag, clock, timeval) cal_real_$clock_to_timeval(flag, &clock, timeval)

#else
#include <apollo/cal.h>
extern boolean cal_$timeval_to_clock (          
        time_$rel_abs_t         &flag,
        time_$timeval_t         &timeval,
        time_$clock_t           *clock
        );

extern boolean cal_$clock_to_timeval (          
        time_$rel_abs_t         &flag,
        time_$clock_t           &clock,
        time_$timeval_t         *timeval
        );

#endif
                                                                                                                                                                                                                                                                     
 * [B]CLIENT.C;4 +  , &&   .     /    4                          - E9   0   1    2   3      K  P   W   O     5   6 ȓ  7 ~Ε  8          9          G   H  J                  
#ifndef lint
static char sccsid[] = "@(#)client.c	4.2     (ultrix)        11/14/90";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment whic             h is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifdef MSDOS
#include <time.h>
#include <sys\types.h>
#else
#include <sys/time.h>
#include <sys/types.h>
#endif
#include <stdio.h>

#include "base.h"
#include "rpc.h"
#ifdef vms
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <unixlib.h>
#endif
#include "binop.h"

#define CALLS_PER_PASS 100

extern uuid_$t uuid_$nil;

main(argc, argv)
int argc;
char *argv[];
{
    int k;
                                                                                                                                                                                                                                           # $      RCP011.B                       &&  E9  
[B]CLIENT.C;4                                                                                                                                               F                 int passes;
    long i, n;
    handle_t rh;
    socket_$addr_t loc;
    long llen;
    status_$t st;
    int start_time, stop_time;
#   define ERRTXTLEN 128
    char errtxt[ERRTXTLEN];
    char *errtxtp;
    extern char *error_$c_text();

    if (argc < 4) {
        fprintf(stderr, "usage: client hostname family passes\n");
        exit(1);
    }

    passes = atoi(argv[3]);
    
    rpc_$name_to_sockaddr(argv[1], (long) strlen(argv[1]), (long) rpc_$unbound_port, (long) atoi(argv[2]), 
        &loc, &llen, &st);
    if (st.all != status_$ok) {
        errtxtp = error_$c_text(st, errtxt, sizeof(errtxt));
        fprintf(stderr, "Can't convert name to sockaddr, %s\n", errtxtp);
        exit(1);
    }

    rh = rpc_$bind(&uuid_$nil, &loc, llen, &st);
    if (st.all != status_$ok) {
        errtxtp = error_$c_text(st, errtxt, sizeof(errtxt));
        fprintf(stderr, "Can't bind, %s\n", errtxtp);
        exit(1);
    }

    for (k = 1; k <= passes; k++) {
        start_time = time(NULL);

        for (i = 1; i <= CALLS_PER_PASS; i++) {
            binop$add(rh, i, i, &n);

            if (n != i+i)
                printf("Two times %ld is NOT %ld\n", i, n);
	    else {
		if (!(n%16))
			printf("Client: 2x%ld = %ld\n",i,n);
	    }
        }

        stop_time = time(NULL);

        printf("pass %3d; real/call: %2d ms\n", 
               k, ((stop_time - start_time) * 1000) / CALLS_PER_PASS);
    }
}
                                                                                                                                 
 * [B]CONV.IDL;1 +  , :   .     /    4 J                          - E9    0   1    2   3      K  P   W   O     5   6 `  7 Ε  8          9          G   H  J                  {*	@(#)conv.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{ Conversation Manager (conv) Interface }

[uuid(333a22760000.0d.00.00.80.9c.00.00.00), version(3)] 
interface conv_;

import 
    'nbase.idl';

{   C O N V _ $ W H O _ A R E _ Y O U

    This procedure is called by a server to a client when the server has
    just received a call from a client about whom it knows nothing.  The
    server passes the server's boot time back to the client so that a new
    incarnation of a crashed server is making the call back (and so the
    client can use the server's boot time in subsequent calls). }

[idempotent] procedure conv_$who_are_you(
                            in      h:          handle_t;
                            in ref  actuid:     uuid_$t;
                            in      boot_time:  unsigned32;
                            out     seq:        unsigned32;
                            out     st:         status_$t
                            );

end;

                                                        
 * [B]ERROR.H;10 +  , 0'   .     /    4                           - E9    0   1    2   3      K  P   W   O     5   6 
!  7  CΕ  8          9          G   H  J                  
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
 * Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
 * Copyright Laws Of The United States.
 * 
 * Apollo Computer Inc. reserves all rights, title and interest with respect
 * to copying, modification or the distribution of such software programs
 * and associated documentation, except those rights specifically granted
 * by Apollo in a Product Software Program License, Source Code License
 * or Commercial License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between
 * Apollo and Licensee.  Without such license agreements, such software
 * programs may not be used, copied, modified or distributed in source
 * or object code form.  Further, the copyright notice must appear on the
 * media, the supporting documentation and packaging as set forth in such
 * agreements.  Such License Agreements do not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * ========================================================================== 
 *
 * Definitions of types/constants for error text database routines.
 *
 * The database consists of two major pieces -- a header and a text
 * section.  The text section consists of a collection of "module tables".
 * The text section begins immediately after the header.
 *
 * The header is a table mapping from [subsystem, module] into the offset
 * from the beginning of the file (into the text section) of the
 * subsystem/module's module table.  Only valid [subsystem, module]
 * pairs appear in the table.
 *
 * A module table contains the number of the lowest and highest error
 * codes for that module, the text n             ame of the module and the text name
 * of the subsystem.  (Yes, the same subsystem name thus appears in
 * multiple places.)  Following this information is the text of all
 * the module's error codes, in order separated by NULL characters.
 *
 * Note that all integers are stored in big-endian (most significant byte
 * at lower offset) format.
 *
 * Format of error database:
 *
 *              |<------ 16 ----->|
 *      
 *              +-----------------+                      
 *              |                 |
 *              +     version     +
 *              |                 |
 *              +-----------------+
 *              |                 |
 *              +  header size    +   Number of header entries that follow
 *              |                 |
 *              +--------+--------+
 *              | subsys   module |   Header entry #0
 *              +--------+--------+
 *              |       pad       |
 *              +-----------------+                      
 *              |                 |
 *              +      offset     +
 *              |                 |
 *              +-----------------+ 
 *              | subsys   module |   Header entry #1
 *              +--------+--------+
 *              |       pad       |
 *              +-----------------+    
 *              |                 |
 *              +      offset     +
 *              |                 |
 *              +-----------------+ 
 *              | subsys   module |   Header entry #2
 *              +--------+------       
                                                                                                                                                                                                                          	                        Y&\i $      RCP011.B                       0'  E9  
[B]ERROR.H;10                                                                                                                                               :      
       --+
 *              |       pad       |
 *              +-----------------+
 *              |                 |
 *              +      offset     +
 *              |                 |
 *              +-----------------+     
 *      
 *              :                 :
 *      
 *              :                 :
 *      
 *              +-----------------+     
 *              |    min code     |   Module table #0
 *              +-----------------+
 *              |    max code     |
 *              +-----------------+
 *              |                 |
 *              :   subsys name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              :   module name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              |   error text    |
 *              :    strings      :
 *              :    sep'd by     :
 *              :     nulls       :
 *              |                 |
 *              +-----------------+
 *              |    min code     |   Module table #2
 *              +-----------------+
 *              |    max code     |
 *              +-----------------+
 *              |                 |
 *              :   subsys name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              :   module name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              |   error text    |
 *              :    strings      :
 *              :    sep'd by     :
 *              :     nulls       :
 *              |                 |
 *              +-----------------+
 *
 */


/*
 * Where the binary error data base lives.
 */

#define ERROR_VERSION 1

#if ! defined(UNIX) && (defined(apollo) || defined(BSD) || defined(SYS5))
#  define UNIX
#endif

#ifdef UNIX
#  ifdef apollo
#    define ERROR_DATABASE "/usr/apollo/lib/stcode.db"
#  else
#ifdef DISKLESS
#    define ERROR_DATABASE "/etc/ncs/stcode.db"
#else DISKLESS
#    define ERROR_DATABASE "/usr/lib/stcode.db"
#endif DISKLESS
#  endif
#endif

#ifdef vms
#  define ERROR_DATABASE "rpc$exe:rpc$stcode.dat"
#endif

#ifdef MSDOS
#  define ERROR_DATABASE "\\ncs\\stcode.db"
#endif

/*
 * MAX_SUBSYS and MAX_MODULE are the highest values that a subsys or module code
 * can take on.
 */

#define MAX_SUBSYS 0x7f
#define MAX_MODULE 0xff


/*
 * MAX_SUBMODS is the maximum number of valid [subsystem, module] pairs we can
 * hold.
 */

#define MAX_SUBMODS 1024


/*
 * The header.  Consists of the "header header" (version and count) and "count"
 * number of "header entries".
 */

struct hdr_hdr_t {
    long version;
    long count;
};

struct hdr_elt_t {
    short submod;
    short pad;
    long offset;
};

struct hdr_t {
    struct hdr_hdr_t h;
    struct hdr_elt_t ents[1];
};

/*
 * The header of a module table.
 */

struct modhdr_t {
    short min_code;
    short max_code;
    char ss_name[64];
    char mod_na             me[64];
};


#if defined(vax) || defined(i8086) || defined(mips)

#define swab_16(p) { \
    register char t; \
    t = ((char *) (p))[0]; \
    ((char *) (p))[0] = ((char *) (p))[1]; \
    ((char *) (p))[1] = t; \
}

#define swab_32(p) { \
    register char t; \
    t = ((char *) (p))[0]; \
    ((char *) (p))[0] = ((char *) (p))[3]; \
    ((char *) (p))[3] = t; \
    t = ((char *) (p))[1]; \
    ((char *) (p))[1] = ((char *) (p))[2]; \
    ((char *) (p))[2] = t; \
}

#else

#define swab_16(p)
#define swab_32(p)

#endif 
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
 * [B]EXBANK1.;2 +  , %   .     /    4 #                           - E9   0   1    2   3      K  P   W   O     5   6 I ȣ  7 Ε  8          9          G   H  J                  8
Mishkin 1 5300 536336336 59394
Leach 2 72111 538164643 89394
Hamilton 3 3468 601935711 534809594
Dineen 4 0 569098018 569098018
guest 7 128 613249552 613249535
                                                                                                                                                                                                                                                                                                                                                                            
 * [B]EXBANK2.;2 +  , %   .     /    4 !       a                    - E9   0   1    2   3      K  P   W   O     5   6 `ȣ  7 3Ε  8          9          G   H  J                  7
Dineen 1 3000 569097908 569097859
nerd 5 235 651807845 640628422
guest 6 0 641154992 641154992
                                                                                                                                                                                                                                                                                                                                                                                                                                              * [B]FAULT.IDL;1 +  , :   . 	    /    4 J   	   	                    - E9    0   1    2   3      K  P   W   O 
    5   6 `  7 `Ε  8          9          G   H  J     
            %pascal

{*	@(#)fault.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{   FAULT - Apollo-assigned 32-bit fault status codes. }


[uuid(404a5e8e1000.0d.00.01.8f.a1.00.00.00)] interface fault_;

const
    fault_$address_error        = 16#00120001;
    fault_$illegal_inst         = 16#00120002;
    fault_$zero_divide          = 16#00120003;
    fault_$chk_inst             = 16#00120004;
    fault_$trapv_inst           = 16#00120005;
    fault_$priv_violation       = 16#00120006;
    fault_$illegal_svc_code     = 16#00120007;
    fault_$illegal_svc_name     = 16#00120008;
    fault_$undefined_trap       = 16#00120009;
    fault_$unimplemented_inst   = 16#0012000A;
    fault_$prot_violation       = 16#0012000B;
    fault_$bus_timeout          = 16#0012000C;
    fault_$illegal_usp          = 16#0012000D;
    fault_$eccc                 = 16#0012000E;
    fault_$eccu                 = 16#0012000F;
    fault_$quit                 = 16#00120010;
    fault_$access_violation     = 16#00120011;
    fault_$not_valid            = 16#00120012;
    fault_$nullproc_onb         = 16#80120013;
    fault_$display_quit         = 16#00120014;
    fault_$single_step          = 16#00120015;
    fault_$invalid_user_fault   = 16#00120016;
    fault_$pbu_user_int_fault   = 16#00120017;
    fault_$stop                 = 16#00120018;
    fault_$blast                = 16#00120019;
    fault_$cache_parity         = 16#0012001A;
    fault_$wcs_parity           = 16#0012001B;
    fault_$not_implemented      = 16#0012001C;
    fault_$inva                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                        ifS $      RCP011.B                       :  E9  [B]FAULT.IDL;1                                                                                                                 J     	                                      lid_stack        = 16#0012001D;
    fault_$parity               = 16#0012001E;
    fault_$interrupt            = 16#0012001F;
    fault_$while_lock_set       = 16#00120020;
    fault_$spurious_parity      = 16#00120021;
    fault_$fp_inexact           = 16#00120022;
    fault_$fp_div_zero          = 16#00120023;
    fault_$fp_undflo            = 16#00120024;
    fault_$fp_op_err            = 16#00120025;
    fault_$fp_ovrflo            = 16#00120026;
    fault_$suspend_proc         = 16#00120027;
    fault_$suspend_proc_kbd     = 16#00120028;
    fault_$suspend_proc_br      = 16#00120029;
    fault_$suspend_proc_bw      = 16#0012002A;
    fault_$continue_proc        = 16#0012002B;
    fault_$fault_lost           = 16#0012002C;
    fault_$illegal_coproc       = 16#0012002D;
    fault_$fp_bsun              = 16#0012002E;
    fault_$fp_sig_nan           = 16#0012002F;
    fault_$parity_bad_thread    = 16#00120030;
    fault_$illegal_page_fault   = 16#00120031;
    fault_$cpub_bus_error       = 16#00120032;
    fault_$spurious_interrupt   = 16#00120033;
    fault_$cold_start_bus_error = 16#00120034;
    fault_$cleanup_set          = 16#00120035;
    fault_$cleanup_rls_out_order= 16#00120036;
    fault_$ac_power_fail        = 16#00120037;
    fault_$fp_parity            = 16#00120038;
    fault_$fp_unknown_vec       = 16#00120039;
    fault_$be_on_be             = 16#0012003A;
    fault_$io_chan_chk          = 16#0012003B;
    fault_$breakpoint           = 16#0012003C;
    fault_$translate_error      = 16#0012003D;
    fault_$illegal_lock         = 16#0012003E;
    fault_$lock_timeout         = 16#0012003F;
    fault_$unknown_status       = 16#00120040;
    fault_$fp_exception         = 16#00120041;
    fault_$fp_fpu_internal_error= 16#00120042;
    fault_$pause                = 16#00120043;
    fault_$halt                 = 16#00120044;
    fault_$trap_on_trap         = 16#00120045;
    fault_$unaligned_inst       = 16#00120046;

end;
                                                                                                 
 * [B]GLB.H;5 +  , !0(   .     /    4 c      
 %                    - E9    0   1    2   3      K  P   W   O 
    5   6 "-  7 1Ε  8          9          G   H  J                     
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef glb__included
#define glb__included
#include "idl_base.h"
#include "rpc.h"
#include "nbase.h"
static rpc_$if_spec_t glb_$if_spec = {
  4,
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  4,
  {
  0x333b2e69,
  0x0000,
  0,
  0xd,
  {0x0, 0x0, 0x87, 0x84, 0x0, 0x0, 0x0}
  }
};
#define lb_$mod 469893120
#define lb_$database_invalid 469893121
#define lb_$database_busy 469893122
#define lb_$not_registered 469893123
#define lb_$update_failed 469893124
#define lb_$cant_access 469893125
#define lb_$server_unavailable 469893126
#define lb_$bad_entry 469893127
typedef ndr_$ulong_int lb_$server_flag_t;
#define lb_$server_flag_local 1
#define lb_$server_flag_reserved_02 2
#define lb_$server_flag_reserved_04 4
#define lb_$server_flag_reserved_08 8
#define lb_$server_flag_reserved_10 16
#define lb_$server_flag_reserved_20 32
#define lb_$server_flag_reserved_40 64
#define lb_$server_flag_reserved_80 128
#define lb_$server_flag_reserved_0100 256
#define lb_$server_flag_reserved_0200 512
#define lb_$server_flag_reserved_0400 1024
#define lb_$server_flag_reserved_0800 2048
#define lb_$server_flag_reserved_1000 4096
#define lb_$server_flag_reserved_2000 8192
#define lb_$server_flag_reserved_4000 16384
#define lb_$server_flag_reserved_8000 32768
#define lb_$server_flag_reserved_10000 65536
#define lb_$server_flag_reserved_20000 131072
#define lb_$server_flag_reserved_40000 262144
#define lb_$server_flag_reserved_80000 524288
typedef ndr_$ulong_int lb_$lookup_handle_t;
#define lb_$default_lookup_handle 0
typedef struct lb_$entry_t lb_$entry_t;
struct lb_$entry_t {
uuid_$t object;
uuid_$t obj_type;
uuid_$t obj_interface;
lb_$server_flag_t flags;
ndr_$char annotation[64];
ndr_$ulong_int saddr_len;
socket_$addr_t saddr;
};
extern  void glb_$insert
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void glb_$delete
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
#define glb_$max_lookup_results 400
extern  void glb_$lookup
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void glb_$find_server
#ifdef __STDC__
 (
  /* [in] */handle_t h);
#else
 ( );
#endif
typedef struct glb_$epv_t {
void (*glb_$insert)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*glb_$delete)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*glb_$lookup)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*glb_$find_server)
#ifdef __STDC__
 (
  /* [in] */handle_t h)
#else
()
#endif
;
} glb_$epv_t;
globalref glb_$epv_t glb_$client_epv;
globalref glb_$epv_t glb_$manager_epv;
globalref rpc_$epv_t glb_$server_epv;
#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [B]GLB.IDL;1 +  , :   .     /    4 r                           - E9    0   1    2   3      K  P   W   O 
    5   6 ]3  7 @Ε  8          9          G   H  J                   {*	@(#)glb.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 **************                                                                                                                                                                                                                                                                           Afu $      RCP011.B                       :  E9  [B]GLB.IDL;1                                                                                                                   r                               2             **********************************************************/
 *}

{ GLB - Global Location Broker }

[
        uuid(333b2e690000.0d.00.00.87.84.00.00.00),
        version(4)
] 
interface glb_;

import 
        'nbase.idl';


const
        lb_$mod = 16#1C020000;                  {* LB module code *}

        lb_$database_invalid    = 16#1C020001;  {* lb_$mod + 1; *} {* database format out of date *}
        lb_$database_busy       = 16#1C020002;  {* lb_$mod + 2; *} {* database in use in an incompatible manner *}
        lb_$not_registered      = 16#1C020003;  {* lb_$mod + 3; *} {* no matching entry available *}
        lb_$update_failed       = 16#1C020004;  {* lb_$mod + 4; *} {* unable to complete registration operation *}
        lb_$cant_access         = 16#1C020005;  {* lb_$mod + 5; *} {* can't access database *}
        lb_$server_unavailable  = 16#1C020006;  {* lb_$mod + 6; *} {* can't reach location broker *}
        lb_$bad_entry           = 16#1C020007;  {* lb_$mod + 7; *} {* bad socket address *}
		
type
        lb_$server_flag_t = unsigned32;

const 
        lb_$server_flag_local          = 16#00001;
        lb_$server_flag_reserved_02    = 16#00002;
        lb_$server_flag_reserved_04    = 16#00004;
        lb_$server_flag_reserved_08    = 16#00008;
        lb_$server_flag_reserved_10    = 16#00010;
        lb_$server_flag_reserved_20    = 16#00020;
        lb_$server_flag_reserved_40    = 16#00040;
        lb_$server_flag_reserved_80    = 16#00080;
        lb_$server_flag_reserved_0100  = 16#00100;
        lb_$server_flag_reserved_0200  = 16#00200;
        lb_$server_flag_reserved_0400  = 16#00400;
        lb_$server_flag_reserved_0800  = 16#00800;
        lb_$server_flag_reserved_1000  = 16#01000;
        lb_$server_flag_reserved_2000  = 16#02000;
        lb_$server_flag_reserved_4000  = 16#04000;
        lb_$server_flag_reserved_8000  = 16#08000;
        lb_$server_flag_reserved_10000 = 16#10000;
        lb_$server_flag_reserved_20000 = 16#20000;
        lb_$server_flag_reserved_40000 = 16#40000;
        lb_$server_flag_reserved_80000 = 16#80000;

type
        lb_$lookup_handle_t = unsigned32;

const
        lb_$default_lookup_handle = 0; 

type
        lb_$entry_t = record 
        {* uuid_$nil == wildcard in each of the object_spec fields *}
                object          : uuid_$t;
                obj_type        : uuid_$t;
                obj_interface   : uuid_$t;
                flags           : lb_$server_flag_t;
                annotation      : array [0..63] of char;
                saddr_len       : unsigned32;
                saddr           : socket_$addr_t;
                end;

{*
** glb_$insert - add the specified entry to the global database.
*}
procedure
    glb_$insert (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** glb_$delete - remove the specified entry from the global database.
*}
procedure
    glb_$delete (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

const
        glb_$max_lookup_results = 400; {* max size of the result_entries array in lookup *}

{*
** glb_$lookup - perform a lookup operation on the global database.  Due to current
**              restrictions on the maximum packet size used by the rpc runtime, 
**              the maximum number of results is defined in glb_$max_lookup_results
*}
[ idempotent ] procedure 
    glb_$lookup (
        in      h               : handle_t;
        in ref  object          : uuid_$t;
          
           in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1..* ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** glb_$find_server - this routine is used by the location server client
**              agent to find a global server that is in service.  It is
**              normally implemented as an empty stub.
*}
[ broadcast ] procedure
    glb_$find_server (
        in      h       : handle_t
    );

end;
                                                                                                                                                                                                                                                                                                              * [B]IDL_BASE.H;5 +  , /1*   . Q    /    4 h   Q   P ,                   - E9    0   1    2   3      K  P   W   O R    5   6 `@  7  Ε  8          9          G   H  J                
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
 * Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
 * Copyright Laws Of The United States.
 *
 * Apollo Computer Inc. reserves all rights, title and interest with respect 
 * to copying, modification or the distribution of such software programs and
 * associated documentation, except those rights specifically granted by Apollo
 * in a Product Software Program License, Source Code License or Commercial
 * License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between Apollo and 
 * Licensee.  Without such license agreements, such software programs may not
 * be used, copied, modified or distributed in source or object code form.
 * Further, the copyright notice must appear on the media, the supporting
 * documentation and packaging as set forth in such agreements.  Such License
 * Agreements do not grant any rights to use Apollo Computer's name or trademarks
 * in advertising or publicity, with respect to the distribution of the software
 * programs without the specific prior written permission of Apollo.  Trademark 
 * agreements may be obtained in a separate Trademark License Agreement.
 * ========================================================================== 
 */


/*
 * This file is #include'd by ALL C files emitted by the NIDL compiler.
 *
 * This file serves two roles:  (1) It defines various primitives that
 * are missing from C but present in NIDL (e.g. booleans, handles); (2)
 * It defines certain things referred to by generated stub code.
 */

/************************** Preprocessor variables *************************/ 

/* 
 * The following variables are defined by the environment somehow:
 *
 *   MSDOS
 *       Means that the system is MS/DOS compatible.
 *   i8086
 *       Means that the system uses an i8086 cpu.
 *   cray
 *       Means that the system is CRAY/Unicos compatible.
 *   vaxc
 *       Means that the system is VAX/VMS compatible.
 *   apollo
 *      Means that the system is an Apollo.
 *   __STDC__
 *      Means that ANSI C prototypes are enabled.
 *   NIDL_CSTUB
 *      Means that a NIDL generated client stub is being compiled.
 *   NIDL_SSTUB
 *      Means that a NIDL generated server stub is being compiled.
 *
 * The following variables are defined (and undefined) within this file
 * to control the definition of macros which are emitted into header                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Ge $      RCP011.B                       /1*  E9  [B]IDL_BASE.H;5                                                                                                                h     Q                                      
 * files and stub code by the NIDL compiler.  For each variable there
 * is a set of default definitions which is used unless a target system
 * specific section #undef-s it and supplies an alternate set of
 * definitions.  Exactly which macro definitions are governed by each
 * variable is listed below.
 *
 *   USE_DEFAULT_NDR_REPS
 *      Controls the definition of the macros which assign a particular
 *      target system type to each NDR scalar type.  The following macros
 *      need to be defined if USE_DEFAULT_NDR_REPS is #undef-ed:
 *          ndr_$boolean
 *          ndr_$false
 *          ndr_$true
 *          ndr_$byte
 *          ndr_$char
 *          ndr_$small_int
 *          ndr_$short_int
 *          ndr_$long_int
 *          ndr_$hyper_int
 *          ndr_$usmall_int
 *          ndr_$ushort_int
 *          ndr_$ulong_int
 *          ndr_$uhyper_int
 *          ndr_$short_float
 *          ndr_$long_float
 *
 *   USE_DEFAULT_MP_REP
 *      Controls the definition of a type and the macros whic      
       h define
 *      the marshalling pointer scheme used on a particular target system.
 *      The following macros need to be defined if USE_DEFAULT_MP_REP
 *      is #undef-ed:
 *          rpc_$init_mp
 *          rpc_$advance_mp
 *          rpc_$align_ptr_relative
 *
 *      and the following type needs to be typedef-ed:
 *          rpc_$mp_t 
 *
 *   USE_DEFAULT_MACROS
 *      Controls the definition of the macros which define how to marshall,
 *      unmarshall and convert values of each NDR scalar type as well
 *      as NDR string types.  The following macros need to be defined
 *      if USE_DEFAULT_MACROS is #undef-ed:
 *          rpc_$marshall_boolean, rpc_$unmarshall_boolean, rpc_$convert_boolean
 *          rpc_$marshall_byte, rpc_$unmarshall_byte, rpc_$convert_byte
 *          rpc_$marshall_char, rpc_$unmarshall_char, rpc_$convert_char
 *          rpc_$marshall_small_int, rpc_$unmarshall_small_int, rpc_$convert_small_int
 *          rpc_$marshall_usmall_int, rpc_$unmarshall_usmall_int, rpc_$convert_usmall_int
 *          rpc_$marshall_short_int, rpc_$unmarshall_short_int, rpc_$convert_short_int
 *          rpc_$marshall_ushort_int, rpc_$unmarshall_ushort_int, rpc_$convert_ushort_int
 *          rpc_$marshall_long_int, rpc_$unmarshall_long_int, rpc_$convert_long_int
 *          rpc_$marshall_ulong_int, rpc_$unmarshall_ulong_int, rpc_$convert_ulong_int
 *          rpc_$marshall_hyper_int, rpc_$unmarshall_hyper_int, rpc_$convert_hyper_int
 *          rpc_$marshall_uhyper_int, rpc_$unmarshall_uhyper_int, rpc_$convert_uhyper_int
 *          rpc_$marshall_short_float, rpc_$unmarshall_short_float, rpc_$convert_short_float
 *          rpc_$marshall_long_float, rpc_$unmarshall_long_float, rpc_$convert_long_float
 *          rpc_$marshall_string, rpc_$unmarshall_string, rpc_$convert_string
 *
 *
 * The following variable is used to support an optimization in marshalling
 * and unmarshalling arrays of scalars.
 *   ALIGNED_SCALAR_ARRAYS
 *      Defining this variable asserts that the target C compiler's layout
 *      for arrays of scalars matches NDR's.  The NIDL compiler emits
 *      code to marshall and unmarshall arrays of scalars which is
 *      conditioned on this variable: if ALIGNED_SCALAR_ARRAYS is defined
 *      then the code uses rpc_$block_copy (which must be defined whenever
 *      ALIGNED_SCALAR_ARRAYS is defined); if ALIGNED_SCALAR_ARRAYS is
 *      not defined then the NIDL compiler emits a loop to marshall or
 *      unmarshall the array element-wise.  Note that converting arrays
 *      of scalars must always be done element-wise.
 */

/***************************************************************************/ 
/***************************************************************************/ 

#ifndef idl_base

#define idl_base

/***************************************************************************/ 

/*
 * Cause a syntax error if wrong options are used with Vax C compiler.
 */

#ifdef vaxc
#  if CC$gfloat != 1
        "VAX/C NCK MUST BE BUILT WITH /G_FLOAT (VMS) or -Mg (ULTRIX)"
#  endif
#endif

/***************************************************************************/ 

/*
 * Work around C's flawed model for global variable definitions.
 */

#ifndef vaxc
#  define globaldef
#  define globalref extern
#endif

/***************************************************************************/ 

/*
 * Innocuously define volatile modifier in C implementations that don't support it.
 */

#if (!defined(__STDC__) || defined(apollo)) && !defined(vaxc)
#  define volatile
#endif

/***************************************************************************/ 

/*
 * The definition of the primitive "handle_t" NIDL type.    
 */ 

typedef struct {
    unsigned short data_offset;
} *handle_t;

/***************************************************************************/ 

/*
 * The definition of the primitive "boolean" NIDL type and its two values.
 */ 

#ifndef true
   typedef unsigned char boolean;
#  define true  ((unsigned char) 0xff)
#  define false ((unsigned char) 0x00)
#endif                                    

/***************************************************************************/ 

/* 
 * macro for distinguishing rpc comm failure statuses from other rpc status codes.
 */
 
#define rpc_$is_comm_failure_status(st)\
    (((st).all & 0xffff0000) == rpc_$mod)
/*    ((st).all == rpc_$comm_failure) */

/***************************************************************************/ 

/* Data representation descriptor type.  
 *
 * This type would be defined in "rpc.idl" except NIDL doesn't yet
 * support packed structs.   (It's packed only for historical reasons.)
 * Note well:  Don't be confused into thinking that this struct defines
 * the bit layout of the drep in the packet header; it doesn't.
 */
 
typedef struct {
    unsigned int int_rep: 4;
    unsigned int char_rep: 4;
    unsigned int float_rep: 8;
    unsigned int reserved: 16;
} rpc_$drep_t;


/*
 * Macro used by stubs to compare two rpc_$drep_t's.
 */

#define rpc_$equal_drep(drep1, drep2)\
    (drep1.int_rep==drep2.int_rep)&&(drep1.char_rep==drep2.char_rep)&&(drep1.float_rep==drep2.float_rep)

/***************************************************************************/ 

/*
 * Hack to make the following variables read-only, global, and statically
 * initialized.  For Apollo global libraries.
 */

#ifdef apollo
#  define rpc_$local_drep_packed  rpc_$local_drep_p_pure_data$
#  define rpc_$local_drep         rpc_$local_drep_pure_data$
#  define rpc_$ascii_to_ebcdic    rpc_$ascii_to_ebcdic_pure_data$
#  define rpc_$ebcdic_to_ascii    rpc_$ebcdic_to_ascii_pure_data$
#endif

/***************************************************************************/ 

/*
 * Variable describing the local system's data representation.  The static
 * initialization of this variable is determined by values in "sysdep.h".
 */

globalref rpc_$drep_t rpc_$local_drep;


/*
 * ASCII <-> EBCDIC conversion tables.
 */

globalref char             rpc_$ascii_to_ebcdic[];
globalref char             rpc_$ebcdic_to_ascii[];


/***************************************************************************/ 
/***************************************************************************/ 

/*
 * Use the default definitions for:
 *
 *    1) representations for NDR scalar types,
 *    2) marshalling pointer represenation and manipulation,
 *    3) marshalling, unmarshalling and conversion methods
 *       for NDR scalar and string types
 *
 * unless some target specific section below #undef's one or more 
 * of these symbols.
 */

#define USE_DEFAULT_NDR_REPS
#define USE_DEFAULT_MP_REP
#define USE_DEFAULT_MACROS
#define ALIGNED_SCALAR_ARRAYS

/***************************************************************************/ 

/****
 **** Cray specific definitions of the default reps for NDR scalar types.
 ****/

#if defined(cray) || defined(CRAY) || defined(CRAY1) || defined(CRAY2)

#undef USE_DEFAULT_NDR_REPS

/*
 * ========= WARNING =========
 * ndr_${,u}small_int are not "chars" because no signed char is available
 * Applications developers MUST use shorts or ndr_${u,}small_int in their
 * code since the marshalling/unmarshalling/conversion code expects this.
 */
#define ndr_$boolean        unsigned char
#define ndr_$false          ((unsigned char) 00)
#define ndr_$true           ((unsigned char) 0xff)
#define ndr_$byte           unsigned char
#define ndr_$char           unsigned char
#define ndr_$small_int      short int           /* 24/32 bits => XMP/2 */
#define ndr_$short_int      short int           /* 24/32 bits => XMP/2 */
#define ndr_$long_int       int                 /* 64/32 bits => XMP/2 */                                                                                                                                                                                                                                   
                        d $      RCP011.B                       /1*  E9  [B]IDL_BASE.H;5                                                                                                                h     Q                         
 "            
#define ndr_$hyper_int      long int
#define ndr_$usmall_int     unsigned short int  /* 24/32 bits => XMP/2 */
#define ndr_$ushort_int     unsigned short int  /* 24/32 bits => XMP/2 */
#define ndr_$ulong_int      unsigned int        /* 64/32 bits => XMP/2 */
#define ndr_$uhyper_int     unsigned long int
#define ndr_$short_float    float
#define ndr_$long_float     float

#endif

/***************************************************************************/ 

/****
 **** Definitions of the vaxc reps for NDR scalar types.
 ****/

#if defined(vaxc)

#undef USE_DEFAULT_NDR_REPS

#define ndr_$boolean        unsigned char
#define ndr_$false          ((unsigned char) 0x00)
#define ndr_$true           ((unsigned char) 0xff)
#define ndr_$byte           unsigned char
#define ndr_$char           unsigned char
#define ndr_$small_int      char
#define ndr_$usmall_int     unsigned char
#define ndr_$short_int      short int
#define ndr_$ushort_int     unsigned short int
#define ndr_$long_int       long int
#define ndr_$ulong_int      unsigned long int

/* the reps for hyper must match the little-endian NDR rep since
   defined(vaxc) => defined(ALIGNED_SCALAR_ARRAYS) */
struct ndr_$hyper_int_rep   {ndr_$ulong_int low; ndr_$long_int high;};
#define ndr_$hyper_int      struct ndr_$hyper_int_rep
struct ndr_$uhyper_int_rep  {ndr_$ulong_int low; ndr_$ulong_int high;};
#define ndr_$uhyper_int     struct ndr_$uhyper_int_rep

#define ndr_$short_float    float
#define ndr_$long_float     double

#endif

/***************************************************************************/ 

/****
 **** Definitions of the default reps for NDR scalar types.
 ****/

#ifdef USE_DEFAULT_NDR_REPS

#define ndr_$boolean        unsigned char
#define ndr_$false          ((unsigned char) 0x00)
#define ndr_$true           ((unsigned char) 0xff)
#define ndr_$byte           unsigned char
#define ndr_$char           unsigned char
#define ndr_$small_int      char
#define ndr_$usmall_int     unsigned char
#define ndr_$short_int      short int
#define ndr_$ushort_int     unsigned short int
#define ndr_$long_int       long int
#define ndr_$ulong_int      unsigned long int

struct ndr_$hyper_int_rep   {ndr_$long_int high; ndr_$ulong_int low;};
#define ndr_$hyper_int      struct ndr_$hyper_int_rep
struct ndr_$uhyper_int_rep  {ndr_$ulong_int high; ndr_$ulong_int low;};
#define ndr_$uhyper_int     struct ndr_$uhyper_int_rep

#define ndr_$short_float    float
#define ndr_$long_float     double

#endif

/***************************************************************************
 ****
 **** The rest of this file is only included in NIDL generated stub code.
 ****
 ***************************************************************************/


#if defined(NIDL_CSTUB) || defined(NIDL_SSTUB)

/*
 * Define the versions of stubs that this instance of idl_base.h supports.
 */

#define IDL_BASE_SUPPORTS_V1

/*
 * Declare external C library routines that are used by stubs.
 */

#ifdef __STDC__
    char *strcpy(ndr_$char *, ndr_$char *);
    int strlen(ndr_$char *);
#else
    char *strcpy();
    int strlen();
#endif

/*
 * Declare external NCK library routines that are not declarable in
 * rpc.idl that are used by stubs.
 */

void *rpc_$malloc(
#ifdef __STDC__
    int n
#endif
);
void rpc_$free(
#ifdef __STDC__
    void *p
#endif
);


/*
 * Define some macros that stub code uses for brevity or clarity.
 */

#define NULL 0

#define SIGNAL(code) {\
    status_$t st;\
    st.all = code;\
    pfm_$signal (st);\
    }

/***************************************************************************/ 

/*
 * Define a thin veneer over the pfm_$ routines and cope with problems
 * related to Apollo C's support for C++'s "&" feature in prototypes.
 */

#define pfm_signal(st)    pfm_$signal(st)

#if defined(apollo) && defined(__STDC__)
#  define pfm_cleanup(crec)         pfm_$cleanup(&(crec))
#  define pfm_rls_cleanup(crec, st) pfm_$rls_cleanup(&(crec), &(st))
#else
#  define pfm_cleanup(crec)         pfm_$cleanup(crec)
#  define pfm_rls_cleanup(crec, st) pfm_$rls_cleanup(crec, st)
#endif

/***************************************************************************/ 

/****
 **** Definitons specific to the i8086 with Microsoft C.
 ****/

#if defined(i8086) && defined(MSDOS)

#undef USE_DEFAULT_MP_REP

#define normalize_ptr(p)\
    *(((unsigned *)&p)+1) += *((unsigned *)&p) >> 4;\
    *((unsigned *)&p) &= 0x000F

typedef char *rpc_$mp_t;

#define rpc_$init_mp(mp, dbp, bufp, offset)\
    mp = (rpc_$mp_t)bufp;\
    normalize_ptr (mp);\
    mp += offset;\
    normalize_ptr (mp);\
    dbp = mp

#define rpc_$advance_mp(mp, delta)\
    mp += delta

#define rpc_$align_ptr_relative(p, base, alignment)\
    p = base + (((p-base) + (alignment-1)) & ~(alignment-1))

#endif

/***************************************************************************/ 

/****
 **** Definitions specific to VMS (and Apple's AUX)
 ****/

#if defined(vaxc) || defined(apple_aux)

#undef USE_DEFAULT_MACROS

#define rpc_$marshall_boolean(mp, src)\
    *(ndr_$boolean *)mp = src

#define rpc_$unmarshall_boolean(mp, dst)\
    dst = *(ndr_$boolean *)mp

#define rpc_$convert_boolean(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_boolean(mp, dst)



#define rpc_$marshall_byte(mp, src)\
    *(ndr_$byte *)mp = src

#define rpc_$unmarshall_byte(mp, dst)\
    dst = *(ndr_$byte *)mp

#define rpc_$convert_byte(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_byte(mp, dst)



#define rpc_$marshall_char(mp, src)\
    *(ndr_$char *)mp = src

#define rpc_$unmarshall_char(mp, dst)\
    dst = *(ndr_$char *)mp

#define rpc_$convert_char(src_drep, dst_drep, mp, dst)\
    if (src_drep.char_rep == dst_drep.char_rep)\
        rpc_$unmarshall_char(mp, dst);\
    else if (dst_drep.char_rep == rpc_$drep_char_ascii)\
        dst = rpc_$ebcdic_to_ascii [*(ndr_$char *)mp];\
    else\
        dst = rpc_$ascii_to_ebcdic [*(ndr_$char *)mp]



#define rpc_$marshall_small_int(mp, src)\
    *(ndr_$small_int *)mp = src

#define rpc_$unmarshall_small_int(mp, dst)\
    dst = *(ndr_$small_int *)mp

#define rpc_$convert_small_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_small_int(mp, dst)



#define rpc_$marshall_usmall_int(mp, src)\
    *(ndr_$usmall_int *)mp = src

#define rpc_$unmarshall_usmall_int(mp, dst)\
    dst = *(ndr_$usmall_int *)mp

#define rpc_$convert_usmall_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_usmall_int(mp, dst)



#define rpc_$marshall_short_int(mp, src)\
    *(ndr_$short_int *)mp = src

#define rpc_$unmarshall_short_int(mp, dst)\
    dst = *(ndr_$short_int *)mp

#define rpc_$convert_short_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_short_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_ushort_int(mp, src)\
    *(ndr_$ushort_int *)mp = (ndr_$ushort_int)src

#define rpc_$unmarshall_ushort_int(mp, dst)\
    *((ndr_$ushort_int *)&dst) = *(ndr_$ushort_int *)mp

#define rpc_$convert_ushort_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ushort_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_long_int(mp, src)\
    *(ndr_$long_int *)mp = src

#define rpc_$unmarshall_long_int(mp, dst)\
    dst = *(ndr_$long_int *)mp

#define rpc_$convert_long_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_long_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_ulong_int(mp, src)\
    *(ndr_$ulong_int *)mp = (ndr_$ulong_int)src

#define rpc_$unmarshall_ulong_int(mp, dst)\
    *((ndr_$ulong_int *)&dst) = *(ndr_$ulong_int *)mp

#define rpc_$convert_ulong_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ulong_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_hyper_int(mp, src) {\
    *(struct ndr_$hyper_int_rep *)mp = *(struct ndr_$hyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_hyper_int(mp, dst) {\
    *(struct ndr_$hyper_int_rep *)&dst = *(struct ndr_$hyper_int_rep *)mp;\
    }

#define rpc_$convert_hyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_                                                                                                                                                                                                                                                                           62F $      RCP011.B                       /1*  E9  [B]IDL_BASE.H;5                                                                                                                h     Q                         b      *       rep == dst_drep.int_rep)\
        rpc_$unmarshall_hyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_uhyper_int(mp, src) {\
    *(struct ndr_$uhyper_int_rep *)mp = *(struct ndr_$uhyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_uhyper_int(mp, dst) {\
    *(struct ndr_$uhyper_int_rep *)&dst = *(struct ndr_$uhyper_int_rep *)mp;\
    }

#define rpc_$convert_uhyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_uhyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_short_float(mp, src) {\
    ndr_$short_float tmp;\
    tmp = src;\
    *(ndr_$short_float *)mp = tmp;\
    }

#define rpc_$unmarshall_short_float(mp, dst)\
    dst = *(ndr_$short_float *)mp

#define rpc_$convert_short_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_short_float(mp, dst);\
    else {\
        rpc_$cvt_short_float (src_drep, dst_drep,\
            (rpc_$short_float_p_t)mp,\
            (rpc_$short_float_p_t)&dst);\
        }



#define rpc_$marshall_long_float(mp, src)\
    *(ndr_$long_float *)mp = src

#define rpc_$unmarshall_long_float(mp, dst)\
    dst = *(ndr_$long_float *)mp

#define rpc_$convert_long_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_long_float(mp, dst);\
    else\
        rpc_$cvt_long_float (src_drep, dst_drep,\
            (rpc_$long_float_p_t)mp,\
            (rpc_$long_float_p_t)&dst)      .       



#define rpc_$marshall_string(lenvar, maxlen, mp, src)\
    {\
    if ((lenvar = strlen((ndr_$char *)src)) >= maxlen)\
        SIGNAL(nca_status_$string_too_long)\
    rpc_$marshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)mp, (ndr_$char *)src);\
    }

#define rpc_$unmarshall_string(lenvar, mp, dst)\
    {\
    rpc_$unmarshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    }

#define rpc_$convert_string(src_drep, dst_drep, lenvar, mp, dst)\
    {\
    rpc_$convert_ushort_int (src_drep, dst_drep, mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    if (src_drep.char_rep == dst_drep.char_rep)\
        strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    else\
        rpc_$cvt_string (src_drep, dst_drep, (rpc_$char_p_t)mp, (rpc_$char_p_t)dst);\
    }

#endif

/***************************************************************************/

/****
 **** Definitions specific to Crays.
 ****
 **** Cray specific issues:
 ****     cray data types don't exactly match ndr data types
 ****         cray's don't have 8 bit signed integers, nor 16 bit
 ****             signed/unsigned ints, nor 32 bit signed/unsigned
 ****             ints (in the case of the XMP)
 ****         cray's floats are all 64 bits and ndr knows this
 ****     cray XMP and cray 2 data types have different precisions
 ****     with the exception of character pointers, the address of
 ****         *any* data type results in a 64 bit aligned address
 ****         (which means that the pointer doesn't typically point
 ****         to the first byte of the data element).
 ****/

#if defined(cray) || defined(CRAY) || defined(CRAY1) || defined(CRAY2)

#undef USE_DEFAULT_MACROS
#undef ALI                                            @ #define SQL_EOS 100		/* SELECT or cursor got to end of stream */  L /*                                                                          P  * SQL Error statuses                                                           M  */                                                                           @ #define SQL_RDBERR -1           /* Rdb returned an error		    */I #define SQL_OUTOFRAN -304	/* Value is out of range for a host variable */ N #define SQL_NULL_$put_4(mp, src)\
    {\
    unsigned long buf = src; /* necessary since src isn't always an lvalue */\
    mp[0] = ((rpc_$mp_t)&buf)[4];\
    mp[1] = ((rpc_$mp_t)&buf)[5];\
    mp[2] = ((rpc_$mp_t)&buf)[6];\
    mp[3] = ((rpc_$mp_t)&buf)[7];\
    }

#define rpc_$get_4(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[4] = mp[0];\
    ((rpc_$mp_t)&dst)[5] = mp[1];\
    ((rpc_$mp_t)&dst)[6] = mp[2];\
    ((rpc_$mp_t)&dst)[7] = mp[3];\
    }

#define rpc_$get_4_swab(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[4] = mp[3];\
    ((rpc_$mp_t)&dst)[5] = mp[2];\
    ((rpc_$mp_t)&dst)[6] = mp[1];\
    ((rpc_$mp_t)&dst)[7] = mp[0];\
    }

#define rpc_$get_8_swab(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[0] = mp[7];\
    ((rpc_$mp_t)&dst)[1] = mp[6];\
    ((rpc_$mp_t)&dst)[2] = mp[5];\
    ((rpc_$mp_t)&dst)[3] = mp[4];\
    ((rpc_$mp_t)&dst)[4] = mp[3];\
    ((rpc_$mp_t)&dst)[5] = mp[2];\
    ((rpc_$mp_t)&dst)[6] = mp[1];\
    ((rpc_$mp_t)&dst)[7] = mp[0];\
    }

/*
 * now for the macros nidl uses
 */

#define rpc_$marshall_boolean(mp, src)\
    *(ndr_$boolean *)mp = src

#define rpc_$unmarshall_boolean(mp, dst)\
    dst = *(ndr_$boolean *)mp

#define rpc_$convert_boolean(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_boolean(mp, dst)



#define rpc_$marshall_byte(mp, src)\
    *(ndr_$byte *)mp = src

#define rpc_$unmarshall_byte(mp, dst)\
    dst = *(ndr_$byte *)mp

#define rpc_$convert_byte(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_byte(mp, dst)



#define rpc_$marshall_char(mp, src)\
    *(ndr_$char *)mp = src

#define rpc_$unmarshall_char(mp, dst)\
    dst = *(ndr_$char *)mp

#define rpc_$convert_char(src_drep, dst_drep, mp, dst)\
    if (src_drep.char_rep == dst_drep.char_rep){\
        rpc_$unmarshall_char(mp, dst);\
    } else if (dst_drep.char_rep == rpc_$drep_char_ascii)\
        (ndr_$char)dst = rpc_$ebcdic_to_ascii [*(ndr_$char *)mp];\
    else\
        (ndr_$char)dst = rpc_$ascii_to_ebcdic [*(ndr_$char *)mp]



/*
 * ndr_$small_int is larger than 8 bits
 */
#define rpc_$marshall_small_int(mp, src)\
    *(char *)mp = (char)src

#define rpc_$unmarshall_small_int(mp, dst)\
    {\
    dst = (*mp & 0x80) ? -1 : 0;\
    ((char *)&dst)[7] = *mp;\
    }

#define rpc_$convert_small_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_small_int(mp, dst)



/*
 * ndr_$usmall_int is larger than 8 bits
 */
#define rpc_$marshall_usmall_int(mp, src)\
    *(char *)mp = (char)src

#define rpc_$unmarshall_usmall_int(mp, dst)\
    {\
    dst = 0;\
    ((char *)&dst)[7] = *mp;\
    }

#define rpc_$convert_usmall_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_usmall_int(mp, dst)




/*
 * ndr_$short_int is larger than 16 bits
 */
#define rpc_$marshall_short_int(mp, src)\
    rpc_$put_2(mp, src)

#define rpc_$unmarshall_short_int(mp, dst)\
    {\
    dst = (*mp & 0x80) ? -1 : 0;\
    rpc_$get_2(mp, dst);\
    }

#define rpc_$convert_short_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_short_int(mp, dst);\
    } else {\
        dst = (mp[1] & 0x80) ? -1 : 0;\
        rpc_$get_2_swab(mp, dst);\
    }



/*
 * ndr_$ushort_int is larger than 16 bits
 */
#define rpc_$marshall_ushort_int(mp, src)\
    rpc_$put_2(mp, src)

#define rpc_$unmarshall_ushort_int(mp, dst)\
    {\
    dst = 0;\
    rpc_$get_2(mp, dst);\
    }

#define rpc_$convert_ushort_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_ushort_int(mp, dst);\
    } else {\
        dst = 0;\
        rpc_$get_2_swab(mp, dst);\
    }



/*
 * ndr_$long_int is larger than 32 bits on a XMP
 * (could special case for the cray 2 and get rid of the sign
 * extension processing)
 */
#define rpc_$marshall_long_int(mp, src)\
    rpc_$put_4(mp, src)

#define rpc_$unmarshall_long_int(mp, dst)\
    {\
    dst = (*mp & 0x80) ? -1 : 0;\
    rpc_$get_4(mp, dst);\
    }

#define rpc_$convert_long_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_long_int(mp, dst);\
    } else {\
        dst = (mp[3] & 0x80) ? -1 : 0;\
        rpc_$get_4_swab(mp, dst);\
    }



/*
 * ndr_$ulong_int is larger than 32 bits on a XMP
 * (could special case for the cray 2 and get rid of the 0 fill
 * extension procession)
 */
#define rpc_$marshall_ulong_int(mp, src)\
    rpc_$put_4(mp, src)

#define rpc_$unmarshall_ulong_int(mp, dst)\
    {\                                                                                                                                                                                                                                                            $      RCP011.B                       /1*  E9  [B]IDL_BASE.H;5                                                                                                                h     Q                         4 "     ;       
    dst = 0;\
    rpc_$get_4(mp, dst);\
    }

#define rpc_$convert_ulong_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_ulong_int(mp, dst);\
    } else {\
        dst = 0;\
        rpc_$get_4_swab(mp, dst);\
    }




#define rpc_$marshall_hyper_int(mp, src)\
    *(ndr_$hyper_int *)mp = src

#define rpc_$unmarshall_hyper_int(mp, dst)\
    dst = *(ndr_$hyper_int *)mp

#define rpc_$convert_hyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_hyper_int(mp, dst);\
    } else {\
        rpc_$get_8_swab(mp, dst);\
    }



#define rpc_$marshall_uhyper_int(mp, src)\
    *(ndr_$uhyper_int *)mp = src

#define rpc_$unmarshall_uhyper_int(mp, dst)\
    dst = *(ndr_$uhyper_int *)mp

#define rpc_$convert_uhyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_uhyper_int(mp, dst);\
    } else {\
        rpc_$get_8_swab(mp, dst);\
    }



/*
 * since cray's don't support a 32 bit flt pt format,
 * convert to IEEE 32 bit format and stick that in the packet.
 */
#define rpc_$marshall_short_float(mp, src)\
{\
    unsigned long ieee_32;\
    extern void rpc_$cray64_to_ieee32();\
\
    rpc_$cray64_to_ieee32(&src, &ieee_32);\
    rpc_$put_4(mp, ieee_32);\
}

/*
 * The packet has a 32 bit IEEE value (what the above macro decided
 * to stick in the packet). A conversion to 64 bit cray float is
 * required.
 */
#define rpc_$unmarshall_short_float(mp, dst)\
{\
    unsigned long ieee_32;\
    extern void rpc_$ieee32_to_cray64();\
\
    rpc_$get_4(mp, ieee_32);\
    rpc_$ieee32_to_cray64(&ieee_32, &dst);\
}

#define rpc_$convert_short_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep)){\
        rpc_$unmarshall_short_float(mp, dst);\
    } else {\
        unsigned long buf;\
        rpc_$get_4(mp, buf);\
        rpc_$cvt_short_float (\
            src_drep,\
            dst_drep,\
            (rpc_$short_float_p_t)&buf,\
            (rpc_$short_float_p_t)&dst); \
    }




#define rpc_$marshall_long_float(mp, src)\
    *(ndr_$long_float *)mp = src

#define rpc_$unmarshall_long_float(mp, dst)\
    dst = *(ndr_$long_float *)mp

#define rpc_$convert_long_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep)){\
        rpc_$unmarshall_long_float(mp, dst);\
    } else {\
        rpc_$cvt_long_float (\
            src_drep,\
            dst_drep,\
            (rpc_$long_float_p_t)mp,\
            (rpc_$long_float_p_t)&dst);\
    }



#define rpc_$marshall_string(lenvar, maxlen, mp, src)\
    {\
    if ((lenvar = strlen((ndr_$char *)src)) >= maxlen)\
        SIGNAL(nca_status_$string_too_long)\
    rpc_$marshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)mp, (ndr_$char *)src);\
    }

#define rpc_$unmarshall_string(lenvar, mp, dst)\
    {\
    rpc_$unmarshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    }

#define rpc_$convert_string(src_drep, dst_drep, lenvar, mp, dst)\
    {\
    rpc_$convert_ushort_int (src_drep, dst_drep, mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    if (src_drep.char_rep == dst_drep.char_rep)\
        strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    else\
        rpc_$cvt_string (src_drep, dst_drep, (rpc_$char_p_t)mp, (rpc_$char_p_t)dst);\
    }

#endif

/***************************************************************************/ 

/****
 **** Definition of the default marshalling pointer representation
 ****/

#ifdef USE_DEFAULT_MP_REP

typedef char *rpc_$mp_t;

#define rpc_$init_mp(mp, dbp, bufp, offset)\
    mp = dbp = (rpc_$mp_t)bufp + offset
         
#define rpc_$advance_mp(mp, delta)\
    mp += delta

#define rpc_$align_ptr_relative(p, base, alignment)\
    p = base + (((p-base) + (alignment-1)) & ~(alignment-1))

#endif

/***************************************************************************/ 

/****
 **** Definitions of the default marshall, unmarshall, and convert macros.
 ****/

#ifdef USE_DEFAULT_MACROS

#define rpc_$marshall_boolean(mp, src)\
    *(ndr_$boolean *)mp = src

#define rpc_$unmarshall_boolean(mp, dst)\
    dst = *(ndr_$boolean *)mp

#define rpc_$convert_boolean(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_boolean(mp, dst)



#define rpc_$marshall_byte(mp, src)\
    *(ndr_$byte *)mp = src

#define rpc_$unmarshall_byte(mp, dst)\
    dst = *(ndr_$byte *)mp

#define rpc_$convert_byte(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_byte(mp, dst)



#define rpc_$marshall_char(mp, src)\
    *(ndr_$char *)mp = src

#define rpc_$unmarshall_char(mp, dst)\
    dst = *(ndr_$char *)mp

#define rpc_$convert_char(src_drep, dst_drep, mp, dst)\
    if (src_drep.char_rep == dst_drep.char_rep)\
        rpc_$unmarshall_char(mp, dst);\
    else if (dst_drep.char_rep == rpc_$drep_char_ascii)\
        (ndr_$char)dst = rpc_$ebcdic_to_ascii [*(ndr_$char *)mp];\
    else\
        (ndr_$char)dst = rpc_$ascii_to_ebcdic [*(ndr_$char *)mp]



#define rpc_$marshall_small_int(mp, src)\
    *(ndr_$small_int *)mp = src

#define rpc_$unmarshall_small_int(mp, dst)\
    dst = *(ndr_$small_int *)mp

#define rpc_$convert_small_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_small_int(mp, dst)



#define rpc_$marshall_usmall_int(mp, src)\
    *(ndr_$usmall_int *)mp = src

#define rpc_$unmarshall_usmall_int(mp, dst)\
    dst = *(ndr_$usmall_int *)mp

#define rpc_$convert_usmall_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_usmall_int(mp, dst)



#define rpc_$marshall_short_int(mp, src)\
    *(ndr_$short_int *)mp = src

#define rpc_$unmarshall_short_int(mp, dst)\
    dst = *(ndr_$short_int *)mp

#define rpc_$convert_short_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_short_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_ushort_int(mp, src)\
    *(ndr_$ushort_int *)mp = (ndr_$ushort_int)src

#define rpc_$unmarshall_ushort_int(mp, dst)\
    (ndr_$ushort_int)dst = *(ndr_$ushort_int *)mp

#define rpc_$convert_ushort_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ushort_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_long_int(mp, src)\
    *(ndr_$long_int *)mp = src

#define rpc_$unmarshall_long_int(mp, dst)\
    dst = *(ndr_$long_int *)mp

#define rpc_$convert_long_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_long_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_ulong_int(mp, src)\
    *(ndr_$ulong_int *)mp = (ndr_$ulong_int)src

#define rpc_$unmarshall_ulong_int(mp, dst)\
    (ndr_$ulong_int)dst = *(ndr_$ulong_int *)mp

#define rpc_$convert_ulong_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ulong_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_hyper_int(mp, src) {\
    *(struct ndr_$hyper_int_rep *)mp = *(struct ndr_$hyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_hyper_int(mp, dst) {\
    *(struct ndr_$hyper_int_rep *)&dst = *(struct ndr_$hyper_int_rep *)mp;\
    }

#define rpc_$convert_hyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_hyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_uhyper_int(mp, src) {\
    *(struct ndr_$uhyper_int_rep *)mp = *(struct ndr_$uhyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_uhyper_int(mp, dst) {\
    *(struct ndr_$uhyper_int_rep *)&dst = *(struct ndr_$uhyper_int_rep *)mp;\
    }

#define rpc_$convert_uhyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_uhyper_int(mp, dst)\
    else {\
                                                                                                                                                                                                                                                                                  r $      RCP011.B                       /1*  E9  [B]IDL_BASE.H;5                                                                                                                h     Q                         "      L        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_short_float(mp, src){\
    ndr_$short_float tmp;\
    tmp = src;\
    *(ndr_$short_float *)mp = tmp;\
    }

#define rpc_$unmarshall_short_float(mp, dst)\
    dst = *(ndr_$short_float *)mp

#define rpc_$convert_short_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_short_float(mp, dst);\
    else {\
        rpc_$cvt_short_float (src_drep, dst_drep,\
            (rpc_$short_float_p_t)mp,\
            (rpc_$short_float_p_t)&dst);\
        }



#define rpc_$marshall_long_float(mp, src)\
    *(ndr_$long_float *)mp = src

#define rpc_$unmarshall_long_float(mp, dst)\
    dst = *(ndr_$long_float *)mp

#define rpc_$convert_long_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_long_float(mp, dst);\
    else\
        rpc_$cvt_long_float (src_drep, dst_drep,\
            (rpc_$long_float_p_t)mp,\
            (rpc_$long_float_p_t)&dst)



#define rpc_$marshall_string(lenvar, maxlen, mp, src)\
    {\
    if ((lenvar = strlen((ndr_$char *)src)) >= maxlen)\
        SIGNAL(nca_status_$string_too_long)\
    rpc_$marshall_ushort_int (mp, lenvar);\
    rpc_$advance_m      O       p(mp, 2);\
    strcpy ((ndr_$char *)mp, (ndr_$char *)src);\
    }

#define rpc_$unmarshall_string(lenvar, mp, dst)\
    {\
    rpc_$unmarshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    }

#define rpc_$convert_string(src_drep, dst_drep, lenvar, mp, dst)\
    {\
    rpc_$convert_ushort_int (src_drep, dst_drep, mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    if (src_drep.char_rep == dst_drep.char_rep)\
        strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    else\
        rpc_$cvt_string (src_drep, dst_drep, (rpc_$char_p_t)mp, (rpc_$char_p_t)dst);\
    }

#endif    
  
/***************************************************************************/ 
/***************************************************************************/ 

#endif

#endif
                                                                                                                                                                                                                                  	 * [B]LB.H;5 +  , Z02   . 	    /    4 J   	                       - E9    0   1    2   3      K  P   W   O 
    5   6  v/  7 qΕ  8          9          G   H  J                      
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef lb__included
#define lb__included
#include "idl_base.h"
#include "nbase.h"
#include "glb.h"
extern  void lb_$register
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in] */lb_$server_flag_t flags,
  /* [in] */ndr_$char annotation[64],
  /* [in] */socket_$addr_t *saddr,
  /* [in] */ndr_$ulong_int saddr_len,
  /* [out] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$unregister
#ifdef __STDC__
 (
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_range
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in] */socket_$addr_t *location,
  /* [in] */ndr_$ulong_int location_len,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_object
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_object_local
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in] */socket_$addr_t *location,
  /* [in] */ndr_$ulong_int location_len,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_type
#ifdef __STDC__
 (
  /* [in] */uuid_$t *obj_type,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_interface
#ifdef __STDC__
 (
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
#endif
                                                                                            * [B]LB.IDL;1 +  , :   .     /    4 V      
                     - E9    0   1    2   3      K  P   W   O     5   6 !  7   Ε  8          9          G   H  J                    %pascal

{*	@(#)lb.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


[ local ]
interface lb_;

import
        'nbase.idl',
        'glb.idl';


{* LS Client Agent obj_interface description - these are local calls *}

{*
** lb_$register - register the specified entry, if lb_$server_flag_local in "flags"
**              then make this entry local.
*}
procedure
    lb_$register (
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in      flags           : lb_$server_flag_t;
        in ref  annotation      : array [0..63] of char;
        in ref  saddr           : socket_$addr_t;
        in      saddr_len       : unsigned32;
        out     xentry          : lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$unregister - unregister the specified entry.
*}
procedure
    lb_$unregister (
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** lb_$lookup_range - lookup m                                                                                                                                                                                                                                                           J $      RCP011.B                       :  E9  [B]LB.IDL;1                                                                                                                    V                              ر 
            atching entries.  if any of the uuid_$t fields
**              are uuid_$nil, then that field will match
**              any value in the database.  This allows lookup by any combination
**              of entry fields.  "location" is a pointer to a socket_$addr_t,
**              if the pointer is nil, then the request is sent to a global
**              location server, otherwise it is sent to the local location server
**              running at the node specified by the "location" parameter.
**
**              a handle describing where to 
**              begin the search and returns a handle describing where to continue
**              the search from.  A handle value of lb_$default_lookup_handle on input
**              indicates the search should begin at the beginning of the data, and
**              a value of lb_$default_lookup_handle on output indicates that all
**              available data has been delivered.
**
**              NOTE: It is possible that serial invokations of this
**              function will return duplicate or incomplete information.
*}
procedure 
    lb_$lookup_range (
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in ref  location        : socket_$addr_t;
        in      location_len    : unsigned32;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{* Various common lookup operations *}

{*
** lb_$lookup_object - search for the specified object in the global database.
**              This call implies wildcards for the object type and obj_interface.
*}
procedure 
    lb_$lookup_object (
        in ref  object          : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$lookup_object_local - search for the specified object at the specified site.
**              This call implies wildcards for the object type and obj_interface.
*}
procedure 
    lb_$lookup_object_local (
            
         in ref  object          : uuid_$t;
        in ref  location        : socket_$addr_t;
        in      location_len    : unsigned32;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$lookup_type - search for the specified type in the global database.
**              This call implies wildcards for the object and obj_interface.
*}
procedure 
    lb_$lookup_type (
        in ref  obj_type        : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$lookup_interface - search for the specified obj_interface in the global 
**              database.  This call implies wildcards for the object and
**              object type.
*}
procedure 
    lb_$lookup_interface (
        in ref  obj_interface   : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

end;
                                                                                                                                                                                                                                                                                                                                                                  
 * [B]LLB.H;5 +  , 07   .     /    4 f                          - E9    0   1    2   3      K  P   W   O     5   6 /  7  UΕ  8          9          G   H  J                     
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef llb__included
#define llb__included
#include "idl_base.h"
#include "rpc.h"
#include "nbase.h"
#include "glb.h"
static rpc_$if_spec_t llb_$if_spec = {
  4,
  {0, 0, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  3,
  {
  0x333b33c3,
  0x0000,
  0,
  0xd,
  {0x0, 0x0, 0x87, 0x84, 0x0, 0x0, 0x0}
  }
};
extern  void llb_$insert
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void llb_$delete
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
#define llb_$max_lookup_results 6
extern  void llb_$lookup
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[6],
  /* [out] */status_$t *status);
#else
 ( );
#endif
typedef struct llb_$epv_t {
void (*llb_$insert)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*llb_$delete)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*llb_$lookup)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[6],
  /* [out] */status_$t *status)
#else
()
#endif
;
} llb_$epv_t;
globalref llb_$epv_t llb_$client_epv;
globalref llb_$epv_t llb_$manager_epv;
globalref rpc_$epv_t llb_$server_epv;
#endif
                                                        * [B]LLB.IDL;1 +  , :   .     /    4 U       V                    - E9    0   1    2   3      K  P   W   O     5   6 <  7 @+(Ε  8          9          G   H  J                   
{*	@(#)llb.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not b                                                                                                                                                                                                                                                           Qo $      RCP011.B                       :  E9  [B]LLB.IDL;1                                                                                                                   U                              5 
            e provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


{ LLB - Local Location Broker and forwarding agent }

[
        uuid(333b33c30000.0d.00.00.87.84.00.00.00),
        port( dds:[12] , ip:[135] ),
        version(4)
] 
interface llb_;

import 
        'nbase.idl',
        'glb.idl';

{*
** llb_$insert - add the specified entry to the database.
*}
procedure
    llb_$insert (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** llb_$delete - remove the specified entry from the database.
*}
procedure
    llb_$delete (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** llb_$lookup - perform a lookup operation at a local database.  Due to current
**              restrictions on the maximum packet size used by the rpc runtime, 
**              the maximum number of results is defined in llb_$max_lookup_results
*}
const
        llb_$max_lookup_results = 6; {* size of the result_entries array in lookup *}

[ idempotent ] procedure 
    llb_$lookup (
        in      h               : handle_t;
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results) ] 
                                      array[ 1..6 ] of lb_$entry_t;
        out     status          : status_$t
    );

end;
                                                                                                                                                                                                                                                                                                                                                                                                                                                         * [B]NBASE.H;5 +  , 2   .     /    4 J                          - E9    0   1    2   3      K  P   W   O     5   6  ʂ2  7 5Ε  8          9          G   H  J                   
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef nbase__included
#define nbase__included
#include "idl_base.h"
typedef ndr_$short_int binteger;
typedef ndr_$short_int pinteger;
typedef ndr_$long_int linteger;
typedef struct status_$t status_$t;
struct status_$t {
ndr_$long_int all;
};
#define status_$ok 0
typedef struct uuid_$t uuid_$t;
struct uuid_$t {
ndr_$ulong_int time_high;
ndr_$ushort_int time_low;
ndr_$ushort_int reserved;
ndr_$byte family;
ndr_$byte host[7];
};
#ifdef __STDC__
handle_t uuid_$t_bind(uuid_$t h);
void uuid_$t_unbind(uuid_$t uh, handle_t h);
#else
handle_t uuid_$t_bind();
void uuid_$t_unbind();
#endif
#define socket_$unspec_port 0
#define socket_$unspec ((ndr_$ushort_int) 0x0)
#define socket_$unix ((ndr_$ushort_int) 0x1)
#define socket_$internet ((ndr_$ushort_int) 0x2)
#define socket_$implink ((ndr_$ushort_int) 0x3)
#define socket_$pup ((ndr_$ushort_int) 0x4)
#define socket_$chaos ((ndr_$ushort_int) 0x5)
#define socket_$ns ((ndr_$ushort_int) 0x6)
#define socket_$nbs ((ndr_$ushort_int) 0x7)
#define socket_$ecma ((ndr_$ushort_int) 0x8)
#define socket_$datakit ((ndr_$ushort_int) 0x9)
#define socket_$ccitt ((ndr_$ushort_int) 0xa)
#define socket_$sna ((ndr_$ushort_int) 0xb)
#define socket_$unspec2 ((ndr_$ushort_int) 0xc)
#define socket_$dds ((ndr_$ushort_int) 0xd)
typedef ndr_$ushort_int socket_$addr_family_t;
#define socket_$num_families 32
#define socket_$sizeof_family 2
#define socket_$sizeof_data 14
#define socket_$sizeof_ndata 12
#define socket_$sizeof_hdata 12
typedef struct socket_$addr_t socket_$addr_t;
struct socket_$addr_t {
socket_$addr_family_t family;
ndr_$byte data[14];
};
typedef struct socket_$net_addr_t socket_$net_addr_t;
struct socket_$net_addr_t {
socket_$addr_family_t family;
ndr_$byte data[12];
};
typedef struct socket_$host_id_t socket_$host_id_t;
struct socket_$host_id_t {
socket_$addr_family_t family;
ndr_$byte data[12];
};
#endif
                                                                                                                                        * [B]NBASE.IDL;1 +  , :   . 	    /    4 [   	   	                    - E9    0   1    2   3      K  P   W   O 
    5   6  ĩ  7 CΕ  8          9          G   H  J     
            %pascal

{*	@(#)nbase.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


{   NBASE - Basic data types and constants used in network interfaces
    
    CHANGES:    
    
        03/11/87 mishkin Make uuid_$t be a handle.
        03/02/87 mishkin Initial coding from base.imp.idl.

}

[uuid(339b18336000.0d.00.00.80.9c.00.00.00)] interface nbase_;

type   
    binteger = 
        0..255;                     { positive 8 bit integer }
    pinteger = 
        0..65535;                   { positive 16 bit integer }
    linteger = 
        0..2147483647;              { positive 31 bit integer }


type   
    status_$t =
        record
            all:    integer32;
            end;

const  
    status_$ok = 0;                 { returned if called proc successful }

type
    uuid_$t =
        [handle] record
            time_high:  unsigned32;
            time_low:   unsigned;
            reserved:   unsigned;
            family:     byte;
            host:       array[1..7] of byte;
            end;

const
    socket_$unspec_port = 0;

type
    socket_$addr_family_t = (
        socket_$unspec,                 { Unspecified }
        socket_$unix,                   { Local to host (pipes, portals) }
        socket_$internet,               { Internetwork: TCP, UDP, etc }
        socket_$implink,                { ARPAnet imp addresses }
        socket_$pup,                    { PUP protocols: e.g. BSP }
        socket_$chaos,                  { MIT CHAOS protocols }
        socket_$ns,                     { XEROX NS                                                                                                                                                                                                                                                                            \ $      RCP011.B                       :  E9  [B]NBASE.IDL;1                                                                                                                 [     	                         v             protocols }
        socket_$nbs,                    { NBS protocols }
        socket_$ecma,                   { European computer manufacturers }
        socket_$datakit,                { Datakit protocols }
        socket_$ccitt,                  { CCITT protocols, X.25 etc }
        socket_$sna,                    { IBM SNA }
        socket_$unspec2,
        socket_$dds                     { Apollo DOMAIN/MSG protocol }
        );

const
    socket_$num_families = 32;          { max # of families you can              define }

    {for more information on "socket length's" and the following constants see socket.idl }
    socket_$sizeof_family = 2;          { bytes in the NDR rep of socket_$addr_family_t }
    socket_$sizeof_data = 14;           { bytes in the NDR rep of socket_$addr_t.data }
    socket_$sizeof_ndata = 12;          { bytes in the NDR rep of socket_$net_addr_t.data }
    socket_$sizeof_hdata = 12;          { bytes in the NDR rep of socket_$host_id_t.data }

type
    { Generic socket address.  ("struct sockaddr" from "sys/socket.h")
      Network address plus port (message queue within host). }

    socket_$addr_t = record
        family: socket_$addr_family_t;
        data:   array [1..socket_$sizeof_data] of byte;
        end;


    { Complete network address.  Host & network ID.  A "sockaddr" without 
      the port. }

    socket_$net_addr_t = record
        family: socket_$addr_family_t;
        data:   array [1..socket_$sizeof_ndata] of byte;
        end;


    { Host identifier.  Uniquely identifies a machine, but you may need to use an
      "socket_$net_addr_t" to actually talk to a machine.  For some families
      (e.g. Internet), the network address and host ID may be identical;
      for others (e.g. NS), the host ID may be a strict subpart of the
      network address. }

    socket_$host_id_t = record
        family: socket_$addr_family_t;
        data:   array [1..socket_$sizeof_hdata] of byte;
        end;

end;
                                                                                                 * [B]NCASTAT.H;5 +  , 2   .     /    4 J                          - E9    0   1    2   3      K  P   W   O     5   6 g3  7 `kTΕ  8          9          G   H  J                 
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef nca_status__included
#define nca_status__included
#include "idl_base.h"
#define NCASTAT_IDL_SUPPORTS_V1 ndr_$true
#define nca_status_$comm_failure 469827585
#define nca_status_$op_rng_error 469827586
#define nca_status_$unk_if 469827587
#define nca_status_$wrong_boot_time 469827590
#define nca_status_$you_crashed 469827593
#define nca_status_$proto_error 469827595
#define nca_status_$out_args_too_big 469827603
#define nca_status_$server_too_busy 469827604
#define nca_status_$string_too_long 469827605
#define nca_status_$unsupported_type 469827607
#define nca_status_$zero_divide 469762049
#define nca_status_$address_error 469762050
#define nca_status_$fp_div_zero 469762051
#define nca_status_$fp_underflow 469762052
#define nca_status_$fp_overflow 469762053
#define nca_status_$invalid_tag 469762054
#define nca_status_$invalid_bound 469762055
#endif
                                                                                                            * [B]NCASTAT.IDL;1 +  , :   . 	    /    4 i   	                        - E9    0   1    2   3      K  P   W   O 
    5   6  ),  7  'bΕ  8          9          G   H  J               %pascal

{*	@(#)ncastat.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


{ NCA_STATUS - NCA-defined status codes. }

[uuid(3c667ff91000.0d.00.01.34.22.00.00.00)] interface nca_status_;

{*
 * Define the versions of stubs that this instance of ncastat.idl supports.
 * Defining a constant named NCASTAT_IDL_SUPPORTS_V<n> (regardless of the
 * value assigned) asserts that this version of ncastat.idl supports stubs
 * of version n.
 *}

const
    NCASTAT_IDL_SUPPORTS_V1 = true;


{*
 * NCA-defined status codes.  These codes are "well-known" and part of the
 * NCA/RPC protocol (e.g. they are sent back in "fault" or "reject" messages
 * from servers).  For historical reasons, the first few status codes are
 * derived from status codes use by NCS, the Apollo implementation of NCA.
 *}

const
    nca_status_$comm_failure        = 16#1C010001;  { unable to get response from server }
    nca_status_$op_rng_error        = 16#1C010002;  { bad operation number in call }
    nca_status_$unk_if              = 16#1C010003;  { unknown interface }
    nca_status_$wrong_boot_time     = 16#1C010006;  { client passed server wrong server boot time }
    nca_status_$you_crashed         = 16#1C010009;  { a restarted server called back a client }
    nca_status_$proto_error         = 16#1C01000B;  { someone messed up the protocol }
    nca_status_$out_args_too_big    = 16#1C010013;  { output args too big }
    nca_status_$server_too_busy     = 16#1C010014;  { server is too busy to handle call }
    nca_status_$string_too_long     = 16#1C010015;  { string parameter longer than declared max len }
    nca_status_$unsupported_type    = 16#1C010017;  { no implementation of generic operation for object }

    nca_status_$zero_divide         = 16#1C000001;
    nca_status_$address_error       = 16#1C000002;
    nca_status_$fp_div_zero         = 16#1C000003;
    nca_status_$fp_underflow        = 16#1C000004;
    nca_status_$fp_overflow         = 16#1C000005;
    nca_status_$invalid_tag         = 16#1C000006;
    nca_status_$invalid_bound       = 16#1C000007;

end;
 

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    * [B]PBASE.H;6 +  , 2   .     /    4 _      
 c                   - E9    0   1    2   3      K  P   W   O 
    5   6 S?  7 wΕ  8          9          G   H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              %( $      RCP011.B                       2  E9  [B]PBASE.H;6                                                                                                                   _                                           
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
 * Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
 * Copyright Laws Of The United States.
 * 
 * Apollo Computer Inc. reserves all rights, title and interest with respect
 * to copying, modification or the distribution of such software programs
 * and associated documen             tation, except those rights specifically granted
 * by Apollo in a Product Software Program License, Source Code License
 * or Commercial License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between
 * Apollo and Licensee.  Without such license agreements, such software
 * programs may not be used, copied, modified or distributed in source
 * or object code form.  Further, the copyright notice must appear on the
 * media, the supporting documentation and packaging as set forth in such
 * agreements.  Such License Agreements do not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * ========================================================================== 
 *
 * This header file exists because "nbase.h" (derived from "nbase.idl")
 * doesn't have all the stuff that the Apollo-specific ".h" files (included
 * when building for Apollos only) need.
 * 
 * On non-Apollos, this file simply includes "nbase.h" (i.e. the includer
 * might just as well have included "nbase.h".)
 * 
 * On Apollos, this file (a) includes "/us/include/apollo/base.h" (which
 * defines some of the same things as "nbase.idl", some more things not
 * in "nbase.idl", but lacks some things that are in "nbase.idl, and (b)
 * defines those missing pieces (since we're not using "nbase.h").
 *
 * Note that              to make things mesh a little better, we include "timebase"
 * here as well.
 */

#ifndef apollo

#include "nbase.h"
#include "timebase.h" 
#include "name.h"

#define time_$high32(t)    ((t).high)
#define time_$low16(t)     ((t).low)
 
#else

#include <apollo/base.h>
#define base__included      /* <apollo/base.h> is a superset of the "base.h" from "base.idl" */

#define time_$high32(t)    ((t).c1.high)
#define time_$low16(t)     ((t).c1.low)

#define time_base_included
#define nbase__included     /* The following are the "missing pieces" */

typedef struct uuid_$t {
    unsigned long time_high;
    unsigned short time_low;
    unsigned short reserved;
    char family;
    char host[7];      
} uuid_$t;

#ifdef vms
globalref uuid_$t uuid_$nil;
#else
extern uuid_$t uuid_$nil;
#endif

#define socket_$unspec_port 0

#define socket_$unspec (short) 0x0
#define socket_$unix (short) 0x1
#define socket_$internet (short) 0x2
#define socket_$implink (short) 0x3
#define socket_$pup (short) 0x4
#define socket_$chaos (short) 0x5 
#define socket_$ns (short) 0x6
#define socket_$nbs (short) 0x7
#define socket_$ecma (short) 0x8
#define socket_$datakit (short) 0x9
#define socket_$ccitt (short) 0xa
#define socket_$sna (short) 0xb
#define socket_$unspec2 (short) 0xc
#define socket_$dds (short) 0xd

typedef short socket_$addr_family_t;

#define socket_$num_families 32

#define socket_$sizeof_family 2
#define socket_$sizeof_data 14 
#define socket_$sizeof_ndata 12
#define socket_$sizeof_hdata 12

typedef struct socket_$addr_t { 
    s      
       ocket_$addr_family_t family;
    unsigned char (data)[14];
} socket_$addr_t;

typedef struct socket_$net_addr_t {
    socket_$addr_family_t family;
    unsigned char (data)[12];
} socket_$net_addr_t;

typedef struct socket_$host_id_t { 
    socket_$addr_family_t family;
    unsigned char (data)[12];
} socket_$host_id_t;

#define name__included

#endif

                                                                                                                                                                           
 * [B]PFM.H;5 +  , 2   . 	    /    4 O   	   	 X                   - E9    0   1    2   3      K  P   W   O 
    5   6 yB  7 `?Ε  8          9          G   H  J                     
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Copyright  1987 by Apollo Computer Inc., Chelmsford, Massachusetts
 * 
 * All Rights Reserved
 * 
 * All Apollo source code software programs, object code software programs,
 * documentation and copies thereof shall contain the copyright notice above
 * and this permission notice.  Apollo Computer Inc. reserves all rights,
 * title and interest with respect to copying, modification or the
 * distribution of such software programs and associated documentation,
 * except those rights specifically granted by Apollo in a Product Software
 * Program License or Source Code License between Apollo and Licensee.
 * Without this License, such software programs may not be used, copied,
 * modified or distributed in source or object code form.  Further, the
 * copyright notice must appear on the media, the supporting documentation
 * and packaging.  A Source Code License does not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * 
 * Apollo disclaims all warranties, express or implied, with respect to
 * the Software Programs including the implied warranties of merchantability
 * and fitness, for a particular purpose.  In no event shall Apollo be liable
 * for any special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits whether in an
 * action of contract or tort, arising out of or in connection with the
 * use or performance of such software programs.
 * ========================================================================== 
 */

#ifndef pfm_included
#define pfm_included

/*
 * Process Fault Manager definitions -- *OLD VERSION*.  See "ppfm.h" for latest
 * version.  This                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $      RCP011.B                       2  E9  
[B]PFM.H;5                                                                                                                     O     	                         )              version retained for compatibility (esp. of "pfm_$..." macros
 * below).  New applications should use "ppfm.h" and the new-style "pfm_$"
 * macros defined there.
 */

#ifdef apollo

#ifdef __STDC__
#  include <ppfm.h>
#else
#  ifdef DSEE
#    include "sys/ins/pfm.ins.c"
#  else
#    include "/sys/ins/pfm.ins.c"
#  endif
#  define pfm_$init(junk)
#endif

#else

#define pfm_$cleanup(crec) \
    pfm_$__cleanup(&(crec))

#define pfm_$rls_cleanup(crec, st) \
    pfm_$_rls_cleanup(&(crec), &st)

#define pfm_$reset_cleanup(crec, st) \
    pfm_$_reset_cleanup(&(crec), &st)

#include <ppfm.h>

#endif

/*
 * The following are here only to deal with an interim, botched naming scheme
 * that will eventually go away.  Do *not* use these names.
 */

#ifndef apollo
    /* Non-Apollo */
#define pfm_$p_cleanup          pfm_$__cleanup
#define pfm_$p_rls_cleanup      pfm_$_rls_cleanup
#define pfm_$p_reset_cleanup    pfm_$_reset_cleanup
#else
#ifdef __STDC__
    /* Apollo/ANSI */
#define pfm_$p_cleanup          pfm_$cleanup
#define pfm_$p_rls_cleanup      pfm_$rls_cleanup
#define pfm_$p_reset_cleanup    pfm_$reset_cleanup
#else
    /* Apollo/non-ANSI */
#define pfm_$p_cleanup          "pfm_$p_cleanup not allowed"
#define pfm_$p_rls_cleanup      "pfm_$p_rls_cleanup not allowed"
#define pfm_$p_reset_cleanup    "pfm_$p_reset_cleanup not allowed"
#endif
#endif

#endif
                                                                                                                                                                                       * [B]PPFM.H;5 +  , /    .     /    4 ^       b                    - E9   0   1    2   3      K  P   W   O 
    5   6 QB  7  Ε  8          9          G   H  J                    
/* %W%  (ULTRIX)        %G%     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Copyright  1987 by Apollo Computer Inc., Chelmsford, Massachusetts
 * 
 * All Rights Reserved
 * 
 * All Apollo source code software programs, object code software programs,
 * documentation and copies thereof shall contain the copyright notice above
 * and this permission notice.  Apollo Computer Inc. reserves all rights,
 * title and interest with respect to copying, modification or the
 * distribution of such software programs and associated documentation,
 * except those rights specifically granted by Apollo in a Product Software
 * Program License or Source Code License between Apollo and Licensee.
 * Without this License, such software programs may not be used, copied,
 * modified or distributed in source or object code form.  Further, the
 * copyright notice must appear on the media, the supporting documentation
 * and packaging.  A Source Code License does not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * 
 * Apollo disclaims all warranties, express or implied, with respect to
 * the Software Programs including the implied warranties of merchantability
 * and fitness, for a particular purpose.  In no event shall Apollo be liable
 * for any special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits whether in an
 * action of contract or tort, arising out of or in connection with the
 * use or performance of such software programs.
 * ========================================================================== 
 */

#ifndef ppfm_included
#define ppfm_included

/*
 * Portable Process Fault Manager definitions.
 *
 * Because this interface has undergone so many variants, we enumerate the
 * exact interface below.  Portable programs should use only what appears below.
 * (Note that some of them are actually macros.)
 *
 * void pfm_$init(unsigned long flags);
 * status_$t pfm_$cleanup(pfm_$cleanup_rec *crec);
 * void pfm_$signal(status_$t st);
 * void pfm_$reset_cleanup(pfm_$cleanup_rec *crec, status_$t *st);
 * void pfm_$rls_cleanup(pfm_$cleanup_rec *crec, status_$t *st);
 * void pfm_$inhibit_faults(void);
 * void pfm_$enable_faults(void);
 * void pfm_$inhibit(void);
 * void pfm_$enable(void);
 * void pgm_$exit(void);
 */

#ifdef apollo

#include <apollo/pfm.h>

#define pfm_$init(junk)                 /* No initialization required on Apollo */

#else

#ifdef MSDOS
#define _JBLEN 20                   /* Must match std.h */
#define setjmp  setjmp_nck
#define longjmp longjmp_nck
typedef char jmp_buf[_JBLEN];
extern long setjmp_nck(jmp_buf);
#endif

#ifndef _JBLEN
#  include <setjmp.h>
#  ifndef _JBLEN
#    define _JBLEN (sizeof(jmp_buf) / sizeof(int))
#  endif
#endif

#define pfm_$module_code                    0x03040000
#define pfm_$bad_rls_order                  (pfm_$module_code + 1)
#define pfm_$cleanup_set                    (pfm_$module_code + 3)
#define pfm_$signalled_zero                 (pfm_$module_code + 0xffff)

typedef struct jmp_buf_elt_t {
    struct jmp_buf_elt_t *next;
    int fault_inh_count;
    jmp_buf buf;
    long setjmp_val;        /* This is "long" and not "int" on purpose -- keep MS/DOS happy */
} pfm_$cleanup_rec;  

void pfm_$signal(
#ifdef __STDC__
    status_$t st
#endif
);

void pfm_$inhibit_faults(
#ifdef __STDC__
    void
#endif
);

void pfm_$enable_faults(
#ifdef __STDC__
    void
#endif
);

void pfm_$inhibit(
#ifdef __STDC__
    void
#endif
);

void pfm_$enable(
#ifdef __STDC__
    void
#endif
);

void pfm_$_rls_cleanup(
#ifdef __STDC__
    pfm_$cleanup_rec *crec, 
    status_$t *st
#endif
);

void pfm_$_reset_cleanup(
#ifdef __STDC__
    pfm_$cleanup_rec *crec, 
    status_$t *st
#endif
);

status_$t pfm_$_cleanup(
#ifdef __STDC__
    long st, 
    pfm_$cleanup_rec *crec
#endif
);

#define pfm_$__cleanup(crec) ( \
    (crec)->setjmp_val = setjmp((crec)->buf), \
    pfm_$_cleanup((crec)->setjmp_val, crec) \
)

void pfm_$init(
#ifdef __STDC__
    unsigned long flags
#endif
);

void pgm_$exit(
#ifdef __STDC__
    void
#endif
);

#ifndef pfm_included 
#define pfm_$cleanup            pfm_$__cleanup
#define pfm_$rls_cleanup        pfm_$_rls_cleanup
#define pfm_$reset_cleanup      pfm_$_reset_cleanup
#endif
                                     
#endif

/*
 * Flags to "pfm_$init"
 */  

#define pfm_$init_signal_handlers   0x00000001

#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                             * [B]RPC$LB_ADMIN.EXE;18 +  , :   . 0    /    4     0   /                     - E9    0   1    2   3      K  P   W   O 1    5   6 Ε  7 Ε  8          9          G   H  J                          0 D X     0205      (  <N        N                                      RPC$LB_ADMIN                           RPC V1.1       <Ε 05-05                       	        #      
     '           F   
  -     ?   #      +        RPC$LIBNCK_001       !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001                                                                                                                                                                                                                                                             4C $      RCP011.B                       :  E9  [B]RPC$LB_ADMIN.EXE;18                                                                                                              0                          "            add clean delete register unregister set_broker set_timeout use_broker lookup exit quit help ?  garbage_collect gc * lb_admin/nck version 1.5 -nq lb_admin:  Known commands are: 
	 %-15.15s  
 help                            -- yields list of known commands
help command1 { command2 ... }  -- yields information on specified commands
 exit or quit                    -- terminate session
 bye.
 Unknown command: %s
 ?(lb_admin)    global local 	Unknown option '%s'
 unregister object type interface location
                                -- unregisters the specified entry; '*' is a wildcard
 Usage: unregister OBJ TYPE INTERFACE LOCATION
 register object type interface location annotation { global | local }
                                -- registers the specified entry
 Usage: register OBJ TYPE INTERFACE LOCATION ANNOTATION {global | local }
 set_timeout { short | long }    -- set rpc timeout mode
 Using %s RPC timeouts
 long short short long clean obj type interface location -- cleanup registry database
 set_broker { local | global } location
                                -- select broker location
 Usage: set_broker { local | global } LOCATION
 global Usage: set_broker { local | global } LOCATION
 local Usage: set_broker { local | global } LOCATION
 %s - illegal broker specification
 use_broker local | global       -- select local or global broker for operations
 Using global broker @ 
 Using local broker @  
 global local lookup object type interface location  -- search for matching entries
 <unknown host>  %.*s[%lu]  <invalid address>  \0%03.3o "%s"  @  %s
 global   ------------
 %12s = *
 object %12s = %s
 object %12s = *
 type %12s = %s
 type %12s = *
 interface %12s = %s
 interface  @  global 
 quit go yes  
 
        Automatic deletion in progress - this entry retained
 
        Invalid Address Family.  Delete?  working  .  
 
 
        Server not responding - unable to contact remote site. 
        Server not responding, but registered in remote llbd database. 
        Unable to communicate over selected address family. 
        Therefore unable to verify server status. 
        Server not responding, and is NOT registered with remote llbd.  %sDelete?   
        [using short timeouts]  
        Server not responding, and is NOT registered with remote llbd. 
        Automatic Deletion - entry DELETED.
 
        Server does not support this interface.  %sDelete?   
        [using short timeouts]  
        Server does not support this interface. 
        Automatic Deletion - entry DELETED.
 
        Automatic deletion in progress - this entry retained
   %sDelete?   
        [using short timeouts]   No entries match.
 delete ?  No entries match.
 No entries match.
 
%ld entries deleted of %ld entries processed
 
    Data from  *GLOBAL*  broker at:  %s

 
   Data from the  _LOCAL_  broker at:  %s

 No entries match.
 ------------
 * * *  r #include ncs$exe:uuidname.txt %W%     (ultrix)        %G%                                                                     i.;3    
                                                                          96 @  
  f                                          |X  `X       Z  pZ     
  X   X       |X  `X       X   X     %  Z  Z     0  Y  Y     <  $\  \     G  4]  ]     N  T  T     S  T  T     X  PR  lT     ]  PR  lT     _  HR  HR      `  Z  pZ     p  Z  pZ     s  T  T         T  HR      *                                       *                                       *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      %W%     (ultrix)        %G%                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         %W%     (ultrix)        %G%                 %W%     (ultrix)        %G%                                                                                                                                                                                                 ^>  STRߣu  ݬݬ*>  ѬЬPݠÎ ϗP      d  2 P| $^V\>  ߭=  ݭf=  f8>  f(=  ̤(=  ̔(=  ̄O=   =  P P ^=R %ݬ=  Pݭݬ2PP=   ^SRÒ \\ݭ ^=  S޼RbB޼P`PPP@cPP޼R޼P`PPY=  PPPbPP޼P`  ^ ޼P`P޼Q޼Pa`CPPPPPPP޼P`
޼P`PP޼Q޼Pa`޼P`ѭP2  P ^Rݏ   ݬ{<   P@ P`zPP@ P`P@ P`P6ѬP@ P`PPѬP@ P`PPPPP@ P`  PPP ^޼RЬP;  QPQQb޼RbaЬRЬRЬR|%  ЬR"ЬSЬRRbPPЬS   RRPЬS  RRP  ^\ χ5 J#  P*P I#  P	 F#   !    TPP 
    @PP  ^  ^P< ^勞U	SЬR1.ŝ :   RB R޲ Rb1 z  P{PQPPRRű j:  P@ Rb ѭe`ЭQЭRPPbAP@ Rѭb#RЭP@BЭP[@PPPPѭP@ RѭbЭPRR]@ЭR B߭Ŵ 9  RRP@ R޲ Rb1ž 9  sPЬRѭaЬRTЬPЭRPB`dЬTЬPЭRPB`}PݬЬRRbRRЬRѭP ^MR P@ Pް P`3ݬP@ Pް P`PPP@ Pް P`  ^\   8    ^m\N  ~8   ^QRd8   ^8   ^-RЬPPݠ   18  | ^V^(   E7  < ^޼R(7  b޼Rb*ݬݬo&  P ^ﰬSR ЬQPPЬQЭPQ@an7    ЬQPPЬQЭPQ@a407  4  ЬQPPЬQЭPQ@a\6  \n  լ1ЬQPP1 ߭ ЬQЭPQ@a6  PPPЬQЭPQ@a 5  PP
P` ЬQЭPQ@aO6  ì;6  í'6    Ѭ1ЬQPP!ЬQЭPQ@a´5  P ´´o  PPЭЬPѭ1 ЬQЭPQ@aîrPPPNЬQЭPQ@aõBPPPЬQЭPQ@aûK5  PPЬPѭ1k  2 P                                                                                                                                                                                                                                                                           +j_ $      RCP011.B                       :  E9  [B]RPC$LB_ADMIN.EXE;18                                                                                                              0                         a5 "              ^\  5   ^٩RЬPR4  PݬP S  P  ^\  4   ^yRЬP	4  PݬP G  P| ^V޼R(ƄbЬR(ƔЬR(Ƥ ݏ@   ƴЬR4
4  ЬR0RbݬЬRtЬRx 3  PRR $3  լ޼RbЬRtR bЬRѢtЬRѢt޼R bP޼RЏ b ^eRS  v3   ^IR﮳SЬP.¨PP
£PPݭ'3  qЬPPݠ®P
:PЬPPݠ´ϪP
 Pݬ9 1  P ^R  2    ^ ݬP     ^I\  Z2   $^-SR  ЬP[2  1 ÊЬPPݠ1  P'ЬPÑ1  	BPЬPPݠ1  P#ЬP1  	 ЬQЭPQ@aݭ  P<խЬQЭPQ@a  ЬQЭPQ@a  PЬQЭPQ@a1  P  ^\  0   ,^ѥR6SЬPf 0i0  	   0  .0     {0  mЬPPݠG0  P]  7P ЬPPݠ0  P 1  P    P  ^ݤ\  /    ^ ݬP    ΀^RЏd   ޼P<`PP.  PY߭߭߭ݬݬ.  PPP`b/  ݭ߭ݭH/  P8/  P Τ^S0/  TͯPPЬR4PP PPPPPP1 PPʏP@dPhPP(ЭRPPЭQPPaPPPPb1 PPʏP@dPPgЭQPP^aPPA   -ЭRPPЭQPPaPPA   PPPPbЭQPP?aPP-ЭQPPaPPݭ	.  PP? ͯ$  -   ^﹢Rݬ)-  ЬPݠtЬPxЬPˏ0PP
8PPP1PPݭ-  q-   `^CV鶴W 9.-  P9߭ 
-  PRR \,  խ޼R b ѭ1PGŏ   SЬRCtRbŏ   SЬRCxݭ+  P1Pլխhŏ   R޼SBc+  PGŏ   SЬRC+  P%,ŏ   SЬRC +  P1: ,  +  ŏ   R޼SBcm+  PRH+  :Pݏ@   ߭ŏ   R޼SBc  ߭dY+  =+  ŏ   SЬRC*  Puk{+  :ݏ@   ߭ŏ   SЬRC(  ߭ƅz?+  *  ŏ   SЬRC *  PƔƊ
+  9ݏ@   ߭ŏ   SЬRC   ߭Ʃƞ*  ŏ   R޼S(Bcŏ   SЬR(Cŏ   SЬR(C ,ŏ   R޼SBcEƳm*  ŏ   SЬRCtRbŏ   SЬRCxsŏ   SЬRC0RˏbRRƷ*  ƾ	*  RRѭ1
լ޼RЬb  ^ݬ)  ޼P` PPP޼P` ЬP| ^V :ݬ)  RRRb^(nF޼RbFPݬ(  RRRb^(n޼Rb ^R ޼P`P߭PݭϳP޼PЏ   `ЭPݭώP޼P`޼P`ݭjP߭ݬP| 0^èV޼R bЬRݢtЬRx޼Rb'  Pխխݭ'  @S@R'  PD@@RݢD8m'  8<< Rˏ<RR  ^(<nώ/< 	޼Rb< 	޼Rb޼Rb< 1 ߭  ݭy'  Rbխt&  ЬR &  P
޼RbQ޼Rb ѭ>PЬR ŏV   RBfr&  P
޼RbRRѭ<  J&   ?&  <@3&  ޼Rb޼Rb޼Rb1 P ЬR(x͈ЬRޢtRb ߭͈%  խ͘߭߭ݭ͈ЬR ЬR޼Rb
%  խ޼RbPѭ ޼RbP |^ךR<Sլ޼P ` @ < %  P;P߭ %  PPP $  խ D ѭ1DPPD ޼P`լ	޼PD`Qŏ   QЬPAtP`ŏ   QЬPAxݭP$  PDPPD1^Pŏ   QЬPAxP>`P<`PP$  P1 @ @ϲ  ߭ݏ   ŏ   P޼Q@a<r$  Fd$  ߭ݬŏ   P޼Q@a PЬQaPPaխЭ<1P@
9B@PP@@
E @߭ŏ   P޼Q@aIѭѭP1%@ @Gϧ  ߭ݏ   ŏ   P޼Q@a	ѭIg#  1PѭR#  1;Pѭ:#  .#  1Pѭ1 <-PP	PPݭA"  ·"  "  <ݬŏ   P޼Q@aPЬQaPPa1
1 Pѭ1 <-k	PP	j	PPݭ-	c"  	T"  ½	H"  <ݬŏ   P޼Q@aPЬQaPPa1 <	"  g8
PPP7
PPݭ*
!  ߭ݬŏ   P޼Q@aPЬQaPPaխЭ<PPPѭ1լ	޼PD`P| t^CV﨡\   Ԑ ͬ RR
P   ͨ߭͘    PRR :    ͗r   ̄>   P3[   ̔'   PD   ̤   P͗ʐ ͕#   ̄  P3   ̔  P  ̤  PP͕ʐ ͖Y
   P͖ ͬͰ߭ݏd   ߭ݭݭ̤̔̄
U  RRͬʏ  ͬխZ
  'PͬRRͬRb^(ͬnl1k͕
͖1 ѭ1P1_1Vͨŏ   RB(R>bR<bRR  P1EP͗j  ŏ   RBͰ  PE  ŏ   RB`  P$}  ŏ   RB?  P1 ͖Bͨŏ   RB$Rbŏ   RB(ݭ͘  P1 PRR  ͨݏ   ŏ   RBͰm
B  ߭߭ŏ   RBͰ խխ P߭ŏ   RBͰBRRѭ1k1  ͔ ѭXͨŏ   RB$Rbŏ   RB(ݭ͘  P͔PRRѭ͔<RRͬŏ   RBͰ߭ŏ   RBͰխ1
խw
  < \^[\ pptϚpRRpRb^(pnϪ ptF  Cpt    "Ppt  pRRpRb^(pn- ^1SR ߭¤(\\i  PխÊ
  PݭݭÝ
  P  $^߭ ݬ  PPPݬ 
  PP
P`1 PլWݭ  Эݭ\  P 
PPSPݭ  PP
P`'PݭI  ЭJP P2  P ^5RPPPP PPPPP   V  ^XYZ[oWԚV    
kRRj   H߭ݏd   ߭ݭݭݬݬݬ
   1 1 hhi  RRRb_PЏd   ؐ߭߭_hi  RR
Rb P_L  _
  9Џd   [߭߭jk  
T  ѭȏ  WRRRb^(nE6Pխ.ݬ߭߭ݭHݭ޼RbRR խխ1P ^כֿSR N    ¤8\\Pխ$  Pխ7s  P| ^EV滛\E,  G4  I\
  (  ̄(  ̔(  ̤K          ^2  P  ^P  ^P ^Rϩ ^R4ύ ^ٗR¤\q  ^P  ^P  ^P  ^P  ^P  ^    ^Pޠ \\ $\\  ^Rݬ  PPݬݢ   Q PP ТaPP  ^ЬQPPQ޼P`"3޼P`\	PP޼P`PPP޼P`"޼P`"=޼P `PPݭK  PPPP4  PPPPݭ     P ^1  RS ޼P `޼P `޼P`1 ޼P`PPP@bPP!PPP޼P`PPP@bPP޼P`1 PЬ޼P`PPP@bPPT޼P`"
ݬϦP޼P`\	PP޼P` PP޼P`PPP@bPP޼P`޼P `ݭЬQaPPaPЬQPPa޼P`1      ^ ޼P`P޼Q޼Pa`CPPPPPPP޼P`
޼P`PP޼Q޼Pa`޼P`ѭЏ   P2  P ^ARЬݢ x  PխЭPՠ޼Pн`Џ   P P ^RЬݬ  Pݢ$!  Pխ#ЭPՠݽݬ  Џ   P P ^R լh޼P``Ьݬ  P  ߢ( =  P*ݬ'  Pխݢ(  P θ^cSRݬݏ                                                                                                                                                                                                                                                                              U $      RCP011.B                       :  E9  [B]RPC$LB_ADMIN.EXE;18                                                                                                              0                         P      $         P1_  P @߭߭ѭ1ݽߣP.ЭPݠPխݭgݭh  1 #	1 1 Pݽ  1 PPЭPР5  PPߢ    }ѭGPЭP@  Pߢ$   PPѭݬݏ     P1 ^ё\vR߬Pխݭ>ݭ?    ^=R ޼P `ݬݬPݬݬݬ\  P 4^R f߭ݬϕPޭPP߭ݬ  ݬݭݬ  ݭ  P
Q޼P A`  ^m  P Э\ P  ^PP?  Pʏ?  PPݭ'  Pխ P ЭQPPЭQPP P ^ PPP޼P`޼RݬvPb޼RbЭP޼Rbս%ЭRѢPнսЭRѢЭRѢݬ PսЭPнЭPìRRЭRТЭPRR P  ^լ7޼P`խнݭ  Эխ޼P `ЬP P ^ЏЬQЬPѡЬPРPPPЬPРPPЭ޼P`޼P`ЭQPPQCPЭQPPaRЭQPPaPPRRխPЭPRRPխЏ   PխЬPЬRѠЏ   P P ^ЏЬQЬPѡЬPРPPPЬPРPPЭ޼P`޼P`ЭQPPQCPЭQPPaRЭQPPaPPRRխPЭPRRPխ"ЬPЬRѠЏ   P PPխ PЏ   PP  ^ЬQЬPѡ PЬPݠ޼P`޼P`?
  Pխ PЏ   P ^ЬQЬPРЬQPPЬPݠ޼P`ЬPݠ  ЬQЬPРЬRЬQЬPPPЬRݢ޼RbЬR    ^RЬPQЬPQQݭݢ,VPЭݬݬݭ8P  ^ЬPQЬPQQ޼Pѭ`ݬݬݬЬPݬݬgPPP ^Tݤ,PЭP ЬЭRЬЭPՠ	ЭPЭ#ЭSЭRݤ$ݤ PТPЭRЭP РP ^Tլ'(ݏ     TP PPP޼P`1 ЬPРPݤ ϸPpЬ)(
ЬPՠP:PЬSЬRݤ$ݤ ЬPݠϓPТЬPЬPPЬPՠPP*P(ݏ     ϙP PPP1ЬPРPݤ WP ޼P`PRЬPՠЬPРPݤ PЬPݠϣPЬPݠϋPխ1HЬPՠ1   P޼P`PРPФPРPϥP	 3PЬPРPРPФPРPwPխѭCPЬPРЭRЬPРխЬR޼P`޼PФ`PЬPФOФPРPЬPРPРPPЬPРЭPФPФЭRЬPРнЭPՠЭPРЭPՠЭQЭPРЭPРЭPՠPЭPРЭPՠЭQЭPР޼P`ЭPՠЭPРЭPՠЬQЭPРЬPРЭPՠPЭPРЭPՠЬQЭPРЬP Э P1Vխ1 ЬRЬPРФPРP޼P`PРPϻPЬPФЬR޼P`޼PФ`޼P`ЭPՠPЭPРЭPՠЬQЭPРЬPРЭPՠPЭPРЭPՠЬQЭPР1 Pѭ~ФPРPЬPРPРPP
ЬPФPЬRЬPРЬPФЬPРЭPՠЭPРЭPՠЬQЭPРPЬPФPP  ^լPЬս^ЭPРPݬ7Pн9ЭPՠЭPРPݬPЭPР
ЭPРսЭPРPݬP-ЭPՠЭPРPPPP޼PЭ`PPP1KP  ^լP޼P`gPЬPРPݬϟP޼P`:ЬPՠЬPРPݬrPЬPР
ЬPР޼P`ЬPРPݬP"ЬPՠ	PP޼PЬ`PPPP ^5S޼P`޼R cPb( )޼P`,Ь Ь$У,Pݠ[Pխ1 У,PՠУ,PУ1 PУ,PРУPРPЭPРPvPУ,R ݣݭvPУ,R ݭݣ\PУ,PްP`ЭPՠPЭPРЭPՠУ,PРQЭPРУ,PРPРЭPՠPЭPРЭPՠУ,PРQЭPРЏ   PPѭЏ   P P  ^ լЭP߭ݬЬPݠϴPѭЭPРPPPЭP  ^ լЭP޼P `߭ݬЬPݠϝPѭ#ЭPРPPP޼QЭPРPPPaP  ^լ P߭ݬЬPݠ
PѭЭP Џ   P2  P  ^޼P`޼P`[                                                                                                                                                                                                                                                                                                                                                                                                                                                      @   @     8  D                                     #           H  8  (           P  p                  H   @   p   8   `   @  0  X  P      r @             l   <   d   
   d     <                  '  &          t	          
                 @                                                                       
RPC$LIBNCK                                                     VAXCRTL                                                        LIBRTL                                                         MTHRTL                                       4        0                                                                                                                                                                                                                                                                                                                                                                                     * [B]RPC$LIBNCK.EXE;4 +  ,    .     /    4                            - E9   0   1    2   3      K  P   W   O     5   6 ``Ε  7 @rΕ  8          9          G   H  J                
             0 D X     0205      (                                      
         RPC$LIBNCK.EXE                         RPC V1.1        Ε 05-05                
                 9    
          
           !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001    4    3    &4    J3    R4  < 1    2    U    V    V    V   V    U    >V    
V   V  < rW    Bf    
   i   &i   nh    k    :k   vg  < N       އ  | ޽  |   |    f        nj    n    ʇ   ʿ    F    ^  |     ִ   r       Z  :!         V       <           ~          b  2$  #   $  ."  2    2  |     ,  < O    ^,  < N   *   *    ~    .    Z  <   | 着  <   <     :9   9   V   m     |   <   < ﾸ   Ɲ    h   n                                                                                                                                                                                                                                                                                   ^ ޼P`KPPѭ;PЬRPPЬQPPab޼RbRRѭ޼R b <^ˏ   PP޼P `޼P `޼P `ޭR eA ƴ PbխޭP` P1ޭP`WޭQޭPaޭPWޭPWޭQޭPޭPWP`VQPaPVPVQPPVѭ1PЏ xPʏ  PPPP 찏 2PP1խ1 ,ݏ   ޭP` P   1P 2PP@P`U2PP@Q2PP@Pa2PP@PU2PP@P`T2PP@Q2PP@Pa2PP@PT2PP@PT2PP@Q2PP@P2PP@PT2PP@P`2PP@P`2Qʏ Q2PP@P2`Pʏ PQP2PP@P`PP졭PP2PP	խ1}ѭ1P ݭޭP`7 ݏ   XޭP` >XP`S>XQ>XPa>XPSZP`RZQZPaZPRݬ\ݬQխ1ݬ͜ݬ6ˏ  PPPPX
Z1 Xݏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |5 $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "            XޭP`Z  #P2P@X	PP=  谭걭 \PPP2PP	޼P ``ЬQPP2P@Xa2P@X
޼P `5PP걭 ݏ   XޭP`  1vPޭPݠ  | ^= Vݏd   ݏd   4ݏd   ߭^(n@ޭRbݬߦݬ= lP4Rb߭ݬߦ"ݬ GPRb4߭ݬߦ2ݬ 4߭ߦEݬϯ  P| ^u Vݏd    ݏd   vݏd   ߦ޼R^(bnp޼SަRRc޼SvRRc޼S RRc޼SߦS PRRc޼Sv> PRRc޼S ( PRRc < d^mSmR PDmmRݢDdK  dii !hݭP  ^(intL  ޼Rb 䏔   RR<RRSR   SShhRRݭً  PP͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ   RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭt  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ+  RRíܭRR͵RR߭߭ݏ   ݭݭݭ ^r  ݬ
b  <RRRRRЭܭSSSˇ RRRSR.Sﴇ RSRS磊 RSR
޼Rнb`SSS RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭl  hݭ[  imG  < d^mSmR PDmmRݢDd;G  dii !hݭ  ^(inH  ޼Rb 䏔   RR<RRSR   SShhRRݭu  PP͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ0  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭǍ  RRíܭRR͵RR߭߭ݏ   ݭݭݭm  ݬ
,^  <RRRRRЭܭSSSg RRRSR.SP RSRSA RSR
޼Rнb`SSS RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ  hݭ  imbC  < θ^SR( PDRݢD͸B  ͸ !ݭ  ^(nC  ޼Rb A   RR<RRSR   SSRRݭ  P
RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ7  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ﯊  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ'  RRíܭRRRRR޼RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭ$j ݬ
VZ  <RRRRRЭܭSSS RRRSR1OSt RSR17Sa RSR1#޼RbRнbRR޼RbRнbRRబRR>RbRRЏ  ^(nh@  ޼ RbRR<RRխ1{íܭRRRRR޽RнbRRЭRRbRRЭRRbRRЭRRRЭR	RRݭݭ1  RRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭ磊  RRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RRݭݭ  RRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭņ  @   RRíܭRRRRRЭRtRнbRRЭRxRbRRЭRzRRݭݭ\  RR   RRRRխ1íܭRRRRR޼$Rнb1	PSSS"| RRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSS{ RRRSR޼RbRнb?P޼RbRRЭ୐ЭRЭSЭRЭSЭRЭRRRబRRSSS6{ RRRSR
>Rb"P>RRЭୈЭRЭRRRЏ  ͼ^(ͼnQ<  ޼ RbRR<RRխ1íܭRRRRRSSSz RRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS(z RRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSSy RRRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRRRRRխíܭRRRRRSSS
y RRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSSx RRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS4x RRRSRЭRRb*ЭRRR\ЭXXR\\RXRRЭRRRЭRRRխ(PRRRRRRխíܭRRRRRSSSuw RRRSRЭR RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSSv RRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSSv RRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@RRЭR(RRЭR)RRխ(PRRRRRRխíܭRRRRRSSSu RRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S8R<R8RRЭR4RRЏ@   խhPSIu RSR)4u RRRBu 
RBu RRRRRRխíܭRRRRRSSSt RRRSRЭRtRнbIPЭRtRR4Э00R44S0R4S0R4R0RRSSSRt RRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ&RRRRRRխ   RRRRխ1íܭRRRRRSSSs RRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭet  ݭTt  3    ^PP PP߭߭ݏ   ݭݭݭ
] ݬ
<M     | 4^U] VЏ  #  Pѭ*%߭ݭ  P%ݬ߭ խ
޼R(ƀb ^" R ߢ P	P \\P ^u" S\ R޼P `¤¤o Џ¤ ¨ ߣ'K P¤¤4}s ys M ߣUߣ:
 ޼PЏ `P  ^\ \̤̤ Џ  < h^! U S[ T 쐏 Ĩ   ݏd   Ĥ Pѭ
cPѭ1r 
r cř ߥh- ޼RЏ bխXGar ]r  Ŭ  !:r 6r P Г ޼RЏ b PPͯPPЭRPPRM
GPЭRPPЭQPPܐabĨPPĨЭQPPQ
P ѭĨPPĨͯPP#ͯPPͯPP 1r^q Zq Pͯ" ݬ߭ ͯ PRRͯ   ޼Rb+q p ޼RbG 1P<RR2p 
p ݬ<RRͯŀT 1n x  P	x ݬ߭ ߭ݭbNn x
  ޼Rb/=p 9p ޼Rbͯŵȑ 1"խ/	p p ޼Rbͯ 1PPѭoݬЭP>xP<`PP[  PPo o  PЭP>xP<`PPݭ,* PP䏈   PPѭѭ"Po 
Lo j 1BЏd   ݬ߭ĬЭRݢtЭRx  ޼RbŰĬ  n 
n PݭĬk ݬЭRݢtЭRxݬl>  ޼Rb,n n P޼Rb 1wPRP PDPݠDͫ,  ͫww (n n Pw- 1	Ĝ {Ĝ ݬA   {߭߭k k xݬ                                                                                                                                                                                                                                                                           Zvd $      RCP011.B                       9              a~{6!J\>v cq;18                                                                                                                                        JY@9     q       h9Xrm+ZCpC
Sgĉ#͘T@!iHL=z5 Ksa[3=FZU8ZNkζ!Ys9I4T%7CcXJSeMT:8]!wu-/_ 1yy%4Tv>⊳P{S2jlΥD:V\K]|vd(nDuXy "FYypF#<yuxg@WW
ϻuWu.`@4ZIJnuj
tJYm1r#2EK{>&!CfwўX*hܟKO+e,7=`	=gZ\|;g}d }@TdPT}hLlnF#$SF*.$!%t
t"`K8yRF<k5Bs->*U
>Si#Lg)񴐤A\n3D!ڰg
n_s~)- ť{HWO5)Yn%:`A"lٯOjҗJRT~vN5רFyf0x_{<6=/bw!*MZ	$Ug}l ]9s$SBqe`
"|J
BsK93`Ij>eowz(bs*ylDlM,P[+htJaCJ,͸bә
)y?0|'s\R)K=8
iB9'>Ų<lO>[c6$$ѠmDTNZ[zN9%?l@rǩDA	BJh)csQ=!.D
R8P5Ԕ 삖*ܝG'ILY_A'XL9y,S)Tv s[BN/k{fϧ<vTv"uM
Tx-l1	6q@"WBl6ŗ'=o{cfP$R
.
o8%l݉Cㅆ'e,/G%!LϢJT%?9(
:WQ
w.?(pN8Rhf|w-qp7p:}I>Q0슼.Q}2	Y-|f"rP+ʐv]GT2|)XPrU˳弽?C!'7o.x#f ٜQ(ex;+NoJFx4d)p-SnZŖҗ/RjILܜx+yssGT܀C[_µYX_xWTAyZ`}lXt\@v=&7/
fl8mpM
<F_B
cJ_M@Ź}gRr({L[4/<G~&T!ťm8w>IR]X, 58),i32'#7/Hc!&N7Y:Nb욍Oz9\Iqϒ"+k58h
=σi(sf	i4)d<ϴo-p`8Ԡ	X)ﱫ󿦐R,nFE:SELcÙ_. H4EzX.RQ8JKD]?7}Ќ9-OWK/^5%RR
%Y?r6v<%$]S
fZ&ULRD:CClKfGalkku҄H)M=w,Kurwpö9bz7Q5v{oIfgq6=%!suhtR;;\P "0sEŜnNG8Yȶ?MbtqyJKIJGc4AQA?Wf]\U!R_-ܩҢo-COsur m´4U/ڵ'0&Jev1p0쇅zUӤȓn>!ܴ <_RmVFa_caۄQM`(BE&lnXH}
/po,تDkmng nBcǤD!럧r(ذ$ؑ'TU5 iXj&
@:
 Y>M-$42*͛]6nʭH/w Դp23ղئw%`H2:{WHujBneIg][jcX'y!~-xtkb6$ITzPx+~KƩt#hΜJq:ǳP|ݘF$//nLOJLvt8؜^/&N Ouzd ϽP'ZA흳>,,^PFq }Ѥ\mZѫUsDEyT!X$/zۼm+(bFҴHNiI=BHFxMQEgi ^砽3i=G|u~3ϱj]׾{iBLrv=jk׻ ʵVb,ٳolUem;TW[Wy1SLqhx53[@+=Jc3ЯGYjɫ.?EfP[1j7Ub
Ij+{cYx3<;}+;:k-hO'$% 3tEUPtAĖA.&U`;|	D\'1%Y_L}~U;\Xvh=4X-B|Nc(T;OH.Ul]+b4}iD(~/ľd#5Fe1y7Hi^@tّ,1B찡Ļ~\W8\pQW	rle-OϰN3Z{Z7)Bht*R :y&PzXBR-Z-2'9$~ȍ	b8ǃ21۬/ҔM6(}ê8yܪ'.br9.t_lT~=#??&.S?:nIG9D'6mH~ЊqE
r{n{, KW<6*(1jdtV'-tn1	q2?s8嵴ub&7
H
vhVd`
ĕ4Eu"_}=/@	w/v=z'YuW:*G$JH=-}pR׫=7îǩf	,MYi1tғ	GFW~Kj~fцxŠWK
V&d]p6<.u~i'&6
?bV-שwłnvQ"8xf|On6
 Kۖy,ќH8lnx
-=;=@K{Z|X;O)L#<^A)PL1 7o` Kh[rN=ڱNjh50IPvzQoX}wJ	6mXcX#.;X;!ÕU q^Z<bYIacR l]Q{g>M>#}ly!v]S]m~\9ZBC-h"S^Ǣ(
fZH/YQG90`3ՂFOW[*Se4׊&	O(2><nL978nH8{dFf ѹa RmoJyQ+lOWFxGqOEu3j]FXys<d^R[b]ŗ6=:sx|孽볖Rh1Y~r(d,Sj9M591K(4і/SUUsg}h᷶b0	 iVE.Lɺ1֠8xF[5S΃Gqb+<Qyf0HQتp6MRBaVgF"qt1ZgND߽*4+VQl>Ma>y7V[2_.\D1I$;G`xF̰cl)pՓj>PCfen0TL"CwoPWF/"py,/ѤBS<D7./5q9q.^U:{&Kӛ9?(\IJv.mW"h+ Y8P`mxt;U?*Oe^G#
7C˻ 7WT[杖bB@8"}^[75bh?C>T0Y7HgƓ_r.Ưք|/D_xmQ:YFk6P:l3QS̝K&-X2p'[qXOUfVWJIGmJAO8I̒.N~K_,06<ԟظ8'0E.ʬ~e^jj y+%Kߥo$^h,`"UDVp)s[AB,tzGa5I2+P^HYDxS
&!F yvm
}L=~凾)<mXхۤ|o{0߷!s5<AݺIeyX u'6OuYQ=ش0I8)f@;U+V8<<m5J	 ֗؄s\lN*Gk 畁1z5 K%aHz}.^!ǩ#^?r GIY[ hV=8DC/U`x."j݃S.t+hMbo8/H8GI0k+F3uGʖ <D'T94ks.:ZO!gu I^MbQ9^|7+0%Kn[OR
&8.F9Uت	4W̊+Pw <r4&-ZYq@뫼 Z߰olCC嚠A*-Ƽ,Ӊ8JMn-L=*2%ƘnX:XY0zIvzLF˶A:5ax. Pݹa9o/aoHϫ#PXw݌=WH-{ر	m鯦6xOnbP-r	^ϒn;
;W7ǅ	(#EBO[5a7
(@̱uyϬuH(s{JS]pg=|ψ/<0@&ACHV"Ce}(3oH<s⾚#0|5'?'d#CN|vVMxI7J
UO6(4߻Ë
EaK7<3qgЗVmȪ@-lA`!j!RqLKguϴLc^PqJY%kMk	ڑSeJ撣3
s&vL8n@Hfc<(7PeFd;8w=9s+_U
s0TTfVɧ繼<`1f?^#*IL<~@ZܤReR79*Uz<jm37\gnyk0<Lg6ym,#PkSbe
z)I״b](qi\vH5~CHa-j9o[s^x].o!ob(qhq\h^HJ6V{=}N":uԊZ` /$\81(FgA\$k	B~HG	SN'ZꇙIt@:Ն(G_?=!&2PF<W1xS5V'پ0jRk
K$Mb8UCKVt-*L-ji	ѓ?'Jdݟ;"5-։@bPOܯ"OȒ<փN;VG_!U^G"86q28Y%TS|Q t:[^h%|IxCý}{7GzʤlFRI*|B-BZ`ߩq$,fRڊy\ءW9rblf)Ꝫdj.[Jc.ű[- ՘p+ƒ+u|9PF ~b'Rw>YP2[C@=Ъ5tKP|ѡ~U4s5QV']`^G]լ5ÀV )YT$Uȇ\hcr*As:ᢺ
S[+:蠥&d3Vǵ'$s)w~Ht( a`rvqa˚ &[(-vhAs`pH=ja%~9ڄ$ 1>ng/bO
M9+i&^:鏂bF0b\ilE52n8euA re_GPS0o{!/`g;s)=a$	 fTg2=8=@@|3$TbbaC4ApK#{)LyKG0{|$;UZL;~`B BDw>rk
_t޻ҩX'.L/1T-ӚOITqyKo _!jsˡɎa¨Ff*6n0*`-QG53lיCV]vN	g#7Z`
NtpDI3
b+LF2> ]:ȤqoWZ
MO\ѶK؅&LUo[^Fqn2bcj/w|FԺPѰ՛K	ǬGsɑA3ATᴾ*aћX$Q!Dl%yPu".F]-[>.	aGKh `k5L(m1שeHe|Qx |G=TMγ}oJ
jqs_u9
E^O	TΕY''9iψ}»1_J bf(eWG!/N|oKv%s,k҄-Q:$
J[sN網qQcD~ Zqң",OM̛XUWZmIHF5ŭ	F˖-(hu`nd
f`J[Q۫؄!ceqg߃o?s^3wnǛ/]rb8Fw̿<xeΩZ׼YI!̙nx!`1
Ĕ%HDV(9O]WC+!ȼia󗗼1sH=܆%NȪԶ*lYRؐ@+AmJt[M7 |7}h,`sP	(ٰ 򡿌A2xɭL3*G|ye}J1!&XB'`:ZdNCF x5GKBp>Q>kb=
Z~CՉ5WK yshN`;Ri ȺԢOyTH9.MR6??68j)2:"[NII@nmO(UrA@
x{pu R5AzLB
7J
gGt?7C_8ҕwquJINF3w6h	% Z@|EZ`;!b^/Se_x`gzG~JJ1 Gl	Y|:qX1ewnh/,%	

QϱL-s{rE$D\|T|jrt$
XtiR%V~W' ҬuA^d,ܧ:ajJHD@e~z
s\8'@An5݌Q,7iLG|?`tDܚˣÖͨƐW}YOO;2m[0n	+P
J , function, ban                                                                                                                                                                                                           g} $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "            vV R	b{g,  ޼R    ^  WMV V Ƙ 	զtPզtMk x  P	xϱ Ƙ  P)Ơݬ@޼Rb޼R^(bn,   զtݦt4A  ЭRB  P1ЭRBx;  PtRRRb1Ɯ Ɯ ݦtR@  SR' PDRݢD*  ЭRb ) Ƙ Rˏ  bRR  ^(n+  Rb >խЭRѭB޼SRbcݦt*@   tƠ χRb nƠ8k k PsT jI ݦt]T Rb,ЭRBݦtUխ^(n*  Ƙ Rb  |*  P*  Ƙ !Ơ    P  ^S P   P| ^S Vh x  P	x5լ	޼R(xbP ^yS R޼P `ݬPݬݬݬݢt;   ^AS R vբtݬݬݬݢt:  ݬݬݬx<  Pt޼P` P| ^R V ޼RЏ bݬgP1 խ1 SR PDRݢD7(  ЭRb ) Ƙ Rˏ  bRR  ^(n)  Rb  Rb ݬݬݦt޼RbRb 
 o(  '  ݬϐPխ1,P  ^ݬݬQ P  ^ݬݬQ ϿP| ^Q V   ޼ RЏ b޼R b޼RbƘ  ݬ P1gխ1_PSR PDRݢD&  ЭRb ) Ƙ Rˏ  bRR  ^(n'  Rb  Rb 1  ЬЬѭ䏐  
ЭRRЏ  ЭRRݬ ݭ߭ݭ߭ݬݬݬݦt`P R	bŭ   RRRRRíRRխխ1|𞭐Rb  &  P&  ݬ ϠPխ1խ!޼RЭb޼RЭbխݬݭ޼ Rb ޼Rb޼ R b `^o WO V  Ьѭ1 ЭR>xR<bRRݭ:  P1 PRBƴ ARBƠ RBƤ   Ǽݭ  խRBƴ RBƴ ЭRݢtЭRxRBƠ RbRBƤ L  PDѭ4ŏ   R޼S( Bc`ŏ   R޼S( Bc( `RRRR   RRѭ1   < l^լ$RR$լ 	pRR ޼ S޼R(bcЬ S޼R(bЬ S޼R(b Ь R0RЬbݏ@   ݬЬ R4 Ь RtRЬbݬݬЬ Rx ޼$R bݬ$ݬ     լ$
޼$Rb!Ь Rˏ0RRݬ$ݬ P  ^լPP޼P `ЬPˏ0PPݬݬլ
޼P`Pݬݬ    P  ^լ(PP(լ ޭPP լޭPP޼P `޼(P `լ1ݬ(ݬ$ݬ ݬݬݬݬݬݬݬ
v  'ݬ(ݬ$ݬ ݬݬݬݬݬ  ^ݬݬݬݬݬ  a {a    
-  ^ݬ ݬݬݬݬݬݬDa =a  
  ^ݬݬݬݬݬ  
a    ` 
  ^ݬݬݬݬݬ     ` ` 
y  ^ݬL  ݬPP ^ RլPPլPPݬݬb  PPPPլ1yP޼Pް P`-1L޼P`P`QQ119QPP1z   2222222222222222 Z?PPd   1 Pd                     | ?P1 ݬߢ%	  1 PݬߢJ  1 Pݬߢo  sPݬ   ނ ޼P`P`PP >P 5PL   0PL   Pl   Pl   P` 
PPPPPPPPլ1 ^ R ݬݬݬݬ    | d^N VmSmR- PDmmRݢDd  dii !hݭ_  ^(in  ޼Rb 䏔   RR<RRSR   SShhRRݭ_  P	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ@g  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭf  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ(f  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭe  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭke  RRíܭRR͵RR߭߭ݏ   ݭݭݭ r ݬ
5  <RRRRRЭܭSSS[ RRRSR1SZ RSRSZ RSR
޼RнbcPSSSZ RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ[  hݭ[  im  | d^I VmSmR} PDmmRݢDdt  dii !hݭ%[  ^(inI  ޼Rb 䏔   RR<RRSR   SShhRRݭZ  P	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭb  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭLb  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭa  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭla  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭa  RRíܭRR͵RR߭߭ݏ   ݭݭݭr ݬ
k1  <RRRRRЭܭSSSV RRRSR1SV RSRSV RSR
޼RнbcPSSS[V RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭDW  hݭ3W  im  | θ^CE VSR]y PDRݢDͺ  ͺ !ݭV  ^(n  ޼Rb A   RR<RRSR   SSRRݭDV  PPRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭk^  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ]  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ[]  RRíܭRRRRR޼RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭrݬ
-  <RRRRRЭܭSSSR RRRSR1BSR RSR1*SR RSR1޼RbRнbRR޼RbRнbRR>RbRR<RRЏ  ^(n  ޼ RbRR<RRխ1|íܭRRRRR޽RнbRRЭRRbRRЭRRbRRЭRRRЭR	RRݭݭu[  RRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭZ  RRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RRݭݭ]Z  RRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭ	Z  @   RRíܭRRRRRЭRtRнbRRЭRxRbRRЭRzRRݭݭY  RR   RRRRխ1íܭRRRRR޼$Rнb1PSSSfO RRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSSN RRRSR޼RbRнb?P޼RbRRЭ୐ЭRЭSЭRЭSЭRЭRRRSSSN RRRSR>Rb!>RRЭୈЭRЭRRR<RRЏ  ;^(;n  ޼ RbRR<RRխ1íܭRRRRRSSSM RRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS|M RRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSS M RRRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRRRRRխíܭRRRRRSSSaL RRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSSK RRRSRЭRRb,PЭRRRdЭ``RddR`RRSSSK RRRSRЭRRb*ЭRRR\ЭXXR\\RXRRЭRRRЭRRRխ(PRRRRRRխíܭRRRRRSSSJ RRRSRЭR RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSSNJ RRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSSI RRRSRЭR&Rb*ЭR&RRDЭ@@R                                                                                                                                                                                                                                                                           QMg $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          B "     (       DDR@RRЭR(RRЭR)RRխ(PRRRRRRխíܭRRRRRSSS1I RRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S8R<R8RRЭR4RRЏ@   խhPSH RSR)H RRRBH 
RBmH RRRRRRխíܭRRRRRSSS!H RRRSRЭRtRнbIPЭRtRR4Э00R44S0R4S0R4R0RRSSSG RRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ&RRRRRRխ   RRRRխ1íܭRRRRRSSSF RRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭG  ݭG      | ^6 Vլ޼R(bЬ^P ݬ߭߭  >Rbݬ߭<RR  ݬݭ߭  ݬ ߭  ݬݭE (  P޼Rb  ݭ6  ЭP  ^5 P   P< ^ݬݬݬPլ	޼Rb޼RЏ bSRh PDRݢDc  ЭRb ;Rˏ  bRR  ^(n5  P޼SRbc   Rb ݬݬݭ4 Rb4  ݭ  < ^ݬݬݬPլ	޼Rb޼RЏ bSRg PDRݢDs  ЭRb ;Rˏ  bRR  ^(nE  P޼SRbc   Rb ݬݬݭ3 RbD  ݭ  < ^ ޼(RЏ b޼ R bݬݬPRR	RbSRf PDRݢDu  ЭRb 9Rˏ  bRR  ^(nG  ޼(SRbc   Rb }Ѭ
ЬRRЭݬ(ݬ$߭ݭݬݬݬݬݭ2 R	b$0  RR$Ь ScRRcíRR޼Rb
լP  ݭJ  ޼(Rb ޼ Rb޼(R b < ^C ݬ  ue ЬPPQ - ] 9 i   E  u u    - 	?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  PHRRݬd ^(     ,^%2 \լ, d  sd  fd  Yd  Ld  ?d  2d  %d  
d  d  c  ,^1 Rx\\c i\\c W\\c E\\c 3\\c !\\c \\uc \\cc \\
Qc \\?c \\-c ,  ^ˏPP   ^0 QЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^I0 QѬ ޼PЏ `б  ޼P `  ^0 Q޼PС `Ь ޼P     ^P  ^    P  ^ (   P ^/ RТP\\P   ^/ P\\ՠ ^h  W/ VЦ խYլ
 a H 7ݏd   ߭^(n]Pݭߧ>a a ݏ@ж  զ ЭRRRլЏ
PЬRRݭЭRQa < ^ ^(n(    ^  R. S? bPPP`PЏd   ߭߭߭ݬݬ  խޢPPP'Pݭ߭ݭߢ	Î` ÎPPPP ^  SU. R޼P ` k<P	P@fPPCЭPѠ8> 
> <PP  ߣH` ЭPPP<PP@   ݏZ  ߣNߣ;~1  X> 
T>   ߣr_  ݬ>  P> 
> ݭ  ß _ խA= 
=  P_   ü o_ ޼PЏ ` P '_ ݭ  P[ _ r= n= #PA_ ݭ   ^ ݭH  ޼PЏ ` Pݭ  QPP<QP	P@fPP< 
< %<PP<PP  w^ ЭPЭЭP<QPQ`ЭP ^  S+ R< 
< PЬPݠ K^ ޼P   | ^+ V <RR 1 P,: <R.RBƦ]  P
<RRRRPЬR(<R.RBƦ0  P0ЬS<R.RBRѣ@b<T.TЬRޢ@SDRcbRR<RR 1g1 2S.SЬR((CƦ2T.TЬRޢ@SDRcb2T.TЬR>HSDRcb2T.TЬRޢ8SDRcbЬRRR2R.RBƶRRR2R.RBƶRbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RR 8^/  W) V xt O.  &ݬݬݬЬRݢ6  Pc1*P_x|c_޼RbЬRﵺ  PЬR>R<bRRy  _wݏd    ^(_n3  Ǆ[ 9 
9 P_ Ǌn[ ݏ"   T-   P [ t ݏ  ЬRݢ|  PppSZ _9 
[9 P-[  Z ݏ,  ! ,   P c f<fRRx1 <fRRBcRRlORRhKS<fRB|Rbc<fRB|R>bRbd<dRR7hThRRhlSlRRlcddRRd<dRRݬKݬЬRݢ4  cPPcfRRf<fRRx1=ݏ8  E +  cRRP ^  Wa' Vݬ ݬݬЬRݢ0  Pխ P޼RbЬR(  PЬRRRRRЬRRRRR1 fЬR  P1  6+  ЬRѢ@ƈЬR@RRƈZ7 V7 +PЬRRRRR*  P iX ݭ޼ RbݬЬRݢ  ݏ  ǒ *   P'6 
6  ǶkX  PЬRѢ@1 ЬRѢ@B RR 6 6 # ݬЬRݢ@ X IV6 R6 7PЬRRRRR)  PЬRݢ@ݬ LW  PЬRբ>&ЬSЬRѣ>8Џ ^(nhRRRЬRRR޼RbSRbcRb<RR0PЭTRRЭSRRcdRR<RRЏ   P ^  W$ V <RR s<RRBf	S<RRBf	<SS޼R(bCg	<RRBw	RЬb<RRB{	RЬb<RRBf	RRPRR<RR ݏ  ǫǗ'   ^
$ R <PP SP<PP@f	0޼P`<PP@g	  P<PP@f	PPPPP<PP 2  P ^  S# R޼P `ݬiPխ޼PЏ `ЭPРPՠ>ЭPРP>PЬ`BЭPРPѠ>23 
3 P sU ޼PЏ	 `޼QЭPޠPР     ^ݬPխ޼PЏ ` ޼P `ЭPРP< ^ݏP    ݬT ЬRH1 ЬR=1 ЬR21 ЬR'1 ޼RbЬRFRbЬRHRbլ
ЬS޼R(bP l^W  VT W" \ݏd   ^&   <RR 1UP<R.RB̦RR0   P1PuX  ^2 Z2  PЭRݢ$u S ЭR>R<bRRPխ1 P ϜRЭRޢ*SRcb(ЭR>(SRcbЭRޢ$SRcb  ЭRݭP29&S 1 
1 g F$S ݭ(\/ RR<RR 1 $  P ^  S  RccN  X  #ddr
PP5  P  ^޼P `ݏ   /  PP ЭPPЏ`ЭPlP`ЭPZP`ЭPVP`ЭPjP `ЭP  ЭP  լЭPjQjPQ`ݬЭPݬݭU  P ^Ьݬݬ3  ЬЭPZPPЭPVPЬ`<PP/ЭRPPЭQPPabRR<RRЭRjPjRPbݬЭRݢVЭRZ  PЭRjPjRPb޼R    ^ЬЭPѠ1 ЭP>jP<`PʏPP޼PЏ `ЭPZPPЬ޼QЭPޠVP`aЭP>VP`<PP1PЭRPPЭQPPabRR<RRݬݬݬj  ޼R  < ^Ь޼SЭR(c޼R   ^	  W VЬݬ ЭRVЭRZ*  ޼Rb4ݏd    ޼R^(bnl  ǉO ЭRjSjRSbЭR>R bЭRLRbЭRNRb޼R   ^Y  W& VЬݬݬ)޼Rb4ݏd    ޼R^(bn˞  Ǐ1O ЭRjSjRSb޼R   $^  W VѬ޼RЏ bݬ޼R<bRRݬJP޼Rb
խ7Pݏd    ޼R^(bn*  ǕN ޼Rbݬݬݬݭ޼Rb}ݏd    ޼R^(bnϝ  Ǜ5N ݭ   խ1ݏd    ^(n  ǡM  P  ^ЬЭP>jP<`PʏPQPQQլЭPjQjPQ`ЭPjQjPQ`޼P `PPP  ^ QPլPPe  ^Ь޼P `ЭQlPPl>lP<`PPxЭPPЏ`ЭP ЭP ЭPЄ P`PްP`ЭP  ЭP ЭP ЭPЀ P`PްP`ЭP  ݭ7*  P  ^Ь޼P `ЭQlPPlЬP| 8^e  U2 V SL PRRR z  լ	խCP* * Pݭݬŧ8L  K PRRRЬ  K ЬR STЬRz  P{ PQPPRxRRCdRRCd  ЬRRR1  PK ݏ@     ЭPPD   P.?P1  P) )                                                                                                                                                                                                                                                                            ZhZ $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          w "     9       P KK Pѭ9) 
) PYK  'K UJ  J PRRѭPPíRR1cP bJ J 2 P< ^ SRJ PDRݢDKѭ 1\ ޼R(P bRRRR b  J ЬR STЬRz  P{ PQPPRxRRCdRRCd <RR1 ЬR  ݬRݬb  ЬRRR#  Pj߭ݬzݭݏT   ݬݬϬP<RRRRR
'RRRRRRRRRRPPRR<RR1;8 
P } ^  W V ?3' 
/' -P  ǒH ݏ    ЬЬ Э  ͳ Ͳ  Ԑ    ͠ͼSͼRYH PDͼͼRݢDdd͸͸ 1 ݭݭݭݭOխ6ЭRTR4$ SBc"ݭЭRTR$ SBcR޲Rb խ խ	ݭ]ͳݬ4ݭ4Ͳ
   ^(͸nTЬRޢRbѭȏ*ЬK  ƈSƈRRƈS1 Pѭȏ
 >ݬ4߭ݬK  P޼4Rb޼4R^(bnͳ@>% :% P  F ͛^(͛nЭЭR>jR<bRʏRRA$ 
$   2rF Џ ͗^(͗n1ѬM$ $ "ݏݬ  aF Џ ͓^(͓n޼$RЭb޼0R b޼(R b޼4R b Ͱݬ4ЭR>ZR<bRR  P   PPؐ  ЭR>jR<bRʏRSRSSˏRRݬ4ݬݬ4ЭRݢVЭRZ*  P:# 
#   Ǥ2E ЭRVRR1+PЭRVRRRRRRRbSЭRVRbcЭRVRb<RR.ЭTRRЭSRRcdRR<RR>R<bSЬR<CRRE" 
" P  nD ݬ4 ʣ  S" " P  *D ݬ4>R<bSЬR<CRR  RRݏ  7   ͲЭR.e  PЭR(.ЭRNRbЬRFЭR3  PЭS޼RѣBb-PЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЭSRRRRRRѬRRЭR>jR<bRʏRRЭS`RRRRRRˏRRЭS0RRRRRRˏRRЭS RRЭR 1 1 1 ЭR .ЭSݬ4ݬЭR ЭRҀ R޲ R޲ RbPÄ ޼4Rbpݏd    ݬ4  [A 6  2  P޼4Rb  aA ޼4R^(bnЭR ЭR҄ RbRâRRؕЏ ͏^(͏n=RRRRRaݬ4ЭR>R<bRRvP޼4Rb޼4R^(bnЭRݢ@ݭPԕ RR   , 
(  <RRR  ǃ@ <RRSRR<SRRQ  %P<RRR  ǛY@ Џ ͋^(͋n\ЭR RRݭݭݭϧP'Y U  ? 11 ͱ1
 <SЭR>LR<bRRS S RSbЭR>LRb͞͉ݭ<RRݬݭ$  P͉͈<S<RRSR͉ ͈͈RR͊͊͋RR͋ЭR RRݭ͉ݭϷP'i e  > 1RRRR͊19R͉RRͱ > PRRЕͱͰPFP	͈P͈͈RR 

RR
2RxRRR䡭RR
ЏխPݭݭϏPЭPP  5	?P1kխ6ЭRTR= SBc"ݭЭRTR% SBcR޲Rb ߭ЭRݢ@ݬ ݭݭݭP1  f= PR­RR  2RR<RR8^= ѭ@   խ7  Pݭ  k= Џ@   1EP   ЭRRRRRPP! - ) r - r r % P?PSP11Y1  P ǐ< ʹݭ  ^(ʹnO  /ЭRRRRR  P  Ƿ6< 1QPz v P  < ]RRѦJ 8 
4   	; Џ ̈́^(̈́nP1ͱ2 
 <RR n	t; 13P  P  ǩ	B; 1 P  P  	; 	: ݏ{  		^  8 
4   
: =
: ݏ  X
J
  
PMP 	 
 P  |
V: Џ ̀^(̀n(P //RyR bЭR  ݭ/ݭϙݕP1 ߭9 = 9 ݭ  Ǭ
9 9 ߭9  
 Pݭ  
9 1P RR RR2RRRR 
 & 2RRݭ  
9 Jb ^ P   8 Џ |^(|nݭݭ!PRRPP  S	Z?P1խ6ЭRTR SBc"ݭЭRTR SBcR޲Rb ߭ЭRݢ@ݬ ݭݭݭkޕP1 ЭRRRRRPP %  ! % 	?PZP1Y1 1B > P<RR V7 ʹݭ 
  ^(ʹn  0PЭRRRRRG	  P  ǜj7 1P  P  :7 1Pݏ    ͱA` 
\   !6 Џ x^(xn   
 !PЭRݢ@  G6 ЭTЭR>HSHRcbЭTЭR>FSFRcb1A 
   h:6 Џ t^(tn  ЭR>LR<bSSЭR>LR<bRSR'= 9  Ǐ5 1ЭTЭR>LR<bRRRRSLRSb 1  ЭR 1;131+ЭRNSЭR҄ R޲ RSbЏ p^(pn ޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bݬ4ЭR@ݭЭR>JR<bSЭRCP޼,R^(bnЭR ЭR҄ RbR޲Rb޼4Rb޼4Rbl^(lncխ6ЭRTR SBc"ݭЭRTR SBcR޲Rb ЭRRʏRR_PͰA| 
x   Ǧ
4 Џ h^(hn޼(SЭR>JR<bRRc1$  ͰЭR>JR<bRRݭe  P͟ݭ͠H  ݭ  ͟1 ЭRRʏRR1 (P //R	yR bЭR>HSwRcb>ͬS{RcbЭR  ݭ/ݭϩ֕P)[ 
W P 2 11޼(SͨRbc޼$R͠   Pb޼0RbP  -ݭύԕe RR   dЬRFЭR  P!ЭS޼RѣBbЭTЭR>FSLRcbЭR.ß  PЭTЭR>HSNRcbЭTЭRޢ8S>RcbЭRjSjRSbRRRЭRVRRRЭRVRbSRbcRb<RR.ЭTRRЭSRRcdRR<RR޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bPխ6ЭRTRY
 SBc"ݭЭRTRA
 SBcR޲Rb ͳ ͳݬ4ݭkݭvҐ ݬ4ͼ      ^ݬݬݬݬݬݬ       ^ݬݬݬݬݬ     < ^ЬRТѭЬѭ
 ^(n޼R bЭR ЭR ЭRҀ RbR޲RbЭR    < ^ЬRТѭЬѭ
 ^(ns޼R bR P< ^ЬRТѭ@޼R bЬЭR ЭR ЭR҄ RbR޲RbЭRЬ 9Pѭ
 ݬݬݬr  Џ ^(n< ^ЬRТѭ޼R bЬЭR P7ѭ
 ݬݬr  PPЏ ^(ni  ^ݏ]   ݬ-. PݬխЬ
PPݭ   D.  .  ^  Q RѬ
IPPЬP@P  ^ P  ^ P  ^ЬPPPP߬ PP-  ^I RЬPPPP PP߭~- ЬPPPPxPPPQPPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬPJQЬPJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@PЬPLP`ЬPLQЬPLPaЬPLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP`ЬPDQЬPDPaЬPDPЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHPaЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8                                                                                                                                                                                                                                                                           po $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          { "     J       QЬP8PaЬP8PЬP8PЬP8QЬP8PЬP8P < \^  S4) U R޼P `߭ЬP  PP PPݬc  PխZe#M¸¼P [(  Ã( g( ëK( ЭPЭP PP ޼PЭ`¼ЏP   Э߭߭߭ݭЬPc  խ&¸¼ݭ ' %¸
¼Pݭ߭' խ)¸	¼ݭ ' ЭP¬hլcЬPNPPխRЭP@ҬG޼TЭP@ҬPàPP PPЭP@ҬPްP`PdխeЏP޼P`PP6¸
¼P޼P`PP i& eЏPЬPPPPPP<PPP
:¸
¼!PЬPPPPP Ó& eЏPЬPPPPxPPPQPPPQPݬIˏ¼PP¼1 PխS߭& ¸
¼Pݭݭ ú& ¸	¼
 & 4P޼P`k  ЬPݠ@ݭ PPf  ЬP>JP<`PP   PѭP<¸¼#ЬP>JP<`PPݭ '% eЏPTPPTЬPPPPPP<PPP@\QaPPaЭP ΀^  W  V# $ PRz  RP{PQPPRRЏ   PЬRRʏRR ߘSP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n޼RbRRRƼ1 ЏP   Э߭߭߭ݭЬR9  խ(Ƹ
ƼPݭ d# %Ƹ
ƼPݭ߭ǔ# ЬR ݭ RRݬC  Pխǰ>#  RR ˏƼRR	Ƽ ޼Rb  ЬRݢ@ݭ RR  խ,PRRPЬRRRRRR<RRRBXScRRcRխRRRRRRP< ^ݬ|" PխЏ ^(npP  ^   ="   ^P      PPPP  ^     ^X   PPhPլP   PPݬЭP! ЭPP` P ^  RЬP>P<`PP"Pݏ  !  y! ЬQPPЬP>P<`PPݬ  ^޼P`-P޼Pް P`޼P`n޼PЭ`޼P` ^  SЬPPPЭPPPP޼R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`ЬQPPЬ޼PЭ`ЬQPP*ЭQЭPTLôPPôЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPQЬPQPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ8P޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRRR޼RbRXݭ$ ޼R޲ Rb޼Rb*޼RЭb޼RbЭP (^  S  R¸ ޯ\\ t N  pP ~ P\\  QP<\\Lc\\ս'Э\ѭн\ lЭQЭ\P\Pl\\ B\\ 
 ¸  ^ѻ  T  R  4P<PP@cP`<PPPPPPP ϱ2PP@cPPH< PPݏ^  B.H  = < PP@cPP PP ,DPP P¨ P¤ЬЭPPЬ`ЭS  PQQPQ` ^  R   ;<PP@cPPѽ PսPP ŕ0  = ¨^ ¤¤ P< ^<RĬRRRRRѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR>JR<bRRRRíSЬRCPЬRP RRP ^9  SRPRPݬݬ| 1 PPVЬQPPЬRPPbRBHaaPP*ЬRPPЬQPPaP@HbbPPVЬQPPЬRPPbRBaaPP,PЬRPPЬQPPaP@bbPP  ^ݬݬ    | ^d  Vݏd   ߭^(niP d  k     ^Ѭ  Ѭ  Ѭ   PPPPP ^  RѬ   ޼PЏ `¬+ݏ   &P¬ ЭP @Ҭ   ЬPЬ@Ҭ޼P    (^y  SB  RHjݬ LÇݬk PãݬV  <PP
G<PP@XP`<PPPPPùݬ PP<PP
Tݬ  <PP
F<PP@\P`<PPPPPݬ PP<PP
°ݬ ´   m  H^;  V  WǼ1    \    լ
 RRP RRЬRլRR
RR߭ ݭݭݭݭݭ ݭݭo ޼RbRRƏ ЬRRR\PЬRRRƝ~ ЬRЬRRRư^ /ЬRRRE ЬRRRR<RRR  ЬRRR ЬRRRR<RRRR  ߭ЬR/  ߭ ߭ЬR  ߭ ߭ЬR(  ߭ ЬRݢ8# ЬRݢ<;m ЬRݢ@SY  fH ЬR>DR<bRRy. ЬRFƋ ЬR>FR<bRRƧ ЬRHƻ ЬR>HR<bRR ЬR>LR<bRR ЬRJЬR>JR<bRR Px ЬRRRRRPP   V ?P1 ݬǸǼP^(n^(n" FPݬEǸǼP^(n^(nA PPݭݭa ݭݭݭݭݭƁ P $^Q  R<PʏPPm <PʏPPR <PʏPP67 <PʏPPb <PʏPP <PʏPP¾ <PʏPP <PʏPP	 P ^i  R
=	 <PPC	y P¨	h P 0^!  S  TլB߭ ĸļPݬݭ 	 
 ݬE
  ѭ1 z  P{PQPPRR!խ~
 ݭÀ
 Rz  RP{PQPPRRÇ
 ЭR޼PB`RRÉ
t RRѭݬÏ
T     ^Ժ  Rq T  S޼P `ݏ   b 
޼PЏ ` ݬL  Pխ>ߢ)   
  ߢ3 ޼PЏ `ݭʒ   ݬY ޼P`լݬݬݬݬyo  ݬݭÔ  POߢc     Pdߢm d0
޼PЏ `޼PЏ `1 P߭ݬݭ%  PA¢    
  Pd¬  ޼PЏ `1 P޼PЭ`ݬ߭ݬv  ޼P`%  
  P X QPݬݭݬݬv  2 PP@ PPЭ PP ޼P `M    ^ݬݬݬ ݬP  ^ݬݬݬЬQЬP<APPݬR| ^  Vݬݬݏ   ݬݬbPխ PzЬRRʏRRgЬR( {  POЬR @CЬR L7ЬRЬRЬRЬR޼R(b ЬRRʏRR1 ЬЬRRʏRR=ЭR(PЭR(( ЭRޢ@Rb ЭR>LS Rcb PЬSЭRdЬSЭReЬSЭRfЬSЭRg޼SЭR(Pc ЬR>JRb<RR2<UЬT<SЭRChEPRRRR<RRЏ   PP< (^Ь޼$R bݬݭݬ"P޼$RЏ bRRЬ޼RЭbڭ<RR.ЭTRRЭSRRcdRR<RR޼SЭRRRRRRRc޼SЭR(c޼ SЭR(  | Π^ﳵ  VЬݬ޼R<bRRLr  P   PP(P RRЭR,ЭR-ЭR.ЭR/ЬRRRЬb<RR/ЭTRRЭSRRcdRR<RRЬ͸RRʹRЬb<RR0PЭTRRЭSRRcdRR<RRЭR>JR<bRRRfЭR>JR<bRRRRЭRP0
 +  
'  Pݬ
  ʹݬ`ePRRR b  
  P\l
  ʹݬ ʹݭݬ| ^￳  V  T <S2 RRRSR1 P<PP@ R bS޼U<PP@ Rz  bP{ PQPPRxRRRRRCeRR1 ߭<PP@ RbPvPRRRRf    &PRRRR.PƩ[	 ݭ<PP@ RbK  RR<P2 RRRPR1P  ^  S< RR   <T2 RRRTRU<\\L \ lRT<\\L \z  lP{ PQPP\x\\Bd\\Bd\\<P2 \\\P\R\ Ьb  ݏ@   Ǌ  Pխ< RRP X^ﯱ  VL W  \zSzR PDzzRݢDnﮤnѭ2  
   zjPѭ ^խ9^(n"P&  
  ^(n                                                                                                                                                                                                                                                                           l $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "     [       T խ^(n
P ､   r  <S2 RRRSRd<RRB RbRR	RR SrTz  P{ PQPPRxRRCdRRCdRR<S2 RRRSR RR    rݭ  P RR խ=g334     Pgݭ=1 1]P 2 RѭRURB R bSrTRB Rz  bP{ PQPPRxRRRRRCdRRPRR2 RѭR2 RѭR"Pݏ  ƃql  a RB RRխݏ    *P ߭ЭRݽϱPzPݭݭݭݽC  ЭR>R<bRR?ݏ  ƬЭR>R<bRRݭ  1I 1խݭzš ^)  S  R=    +  j ݏ/  8Ѭ
PЬPPЭ      4ݬ_  rt	   A  aPP  ϻ޼P     ^Y  P ޼Q     ^=  Q޼P ` Ь  ^  R  ݬݬ PP޼PЏ `Pݬy  ^޼P     ^Ѭ޼P  `޼P `ѬЬP  ޼P`ѬЬP  ޼P`ѬЬP  ޼P`ѬЬP  ޼P`ѬЬP  ޼P`޼P `   ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPʏPxPPPQQ<PP
޼P `Z<PP   ޼P `CP޼R<PPPxPPPQ<PPxPPPQPPQbPQ`ЬR  PRPbP ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPPPxPPPPPQЬPPPPxPPPPPQQ<PPO޼TЬSЬRЬQP `>P<`PPQPQ`>P<`PPQPQ`>P<`PPQdPQ`1 P<RR   K޼QЬPЬTЬSR b>R<bRRSRSb>R<bRRSRSb>R<bRRSaRSbg޼T<RRRxRRRS<RRxRRRSRRSdRSbЬR  SRSbЬTRRSRSbЬR  SRSb  ^ެPPPQQPP 	?P1ެPPPQQPP   ?P1PPPPyIЬPЬPЬPЬPЬPЬPЬP޼P`#ЬPЬPЬP޼P`ޭPPݬݬ3ݬݬ71 QQQPPPQP%޼Q޼PP`a
P޼Q޼PP`a1 Pk޼QЬPaЬQ޼P`ЬQЬPЬQЬPЬQЬPЬQЬPЬQЬPЬQЬP5P޼QЬPaЬQ޼P`ЬQЬPЬQЬP               < ^ ݬݬ^(n^(nP< ^ݏ   ݬݬ^(n^(nϧ   ^1  RQݬi  Q  PPP ^I  S  RЬP>LP<`PPЬPݠ@ЬP(Pv#  vPPP  ^  QЬP@P ^ݩ  S  RЬPݬݬЬPJP`    ݬh\    -ݏd   ¨ݬK¨hÊR   ݬݬ   | ^  V8(f  8޼R(( < ^ЬRТѽ޼RЏ b P޼SЭR(c޼UЭRТ.TЭSuRRu@uRReݬЭRݢ2ЭR6ЭR. R uPP  ^ݬB ^1  R ޼P ` Hf<Pď`   P@@PPЭPW
Э/PЬPFЭPFh  P޼Pѽ`ЭPPHխE<HPP ޼PЏ ` PHQHPPH<QPď`   P@@PPЭP WP| ^  Vݏ  ƐvݬݬPխfЭRW0ЭRVЭRѢXP޼RЏ
 b/0ЭRWЭR V޼R(V bЭRЬXЭR\R bЭS\RR\| ^Ѧ  Vݏ  ƴݬݬ1PխЭRW0ЭRVЭRѢXP޼RЏ
 bk.ЭRWЭRV޼R(V bЭRЬXЭR \\P޼R(bЭRЬЭSЭRТ\ЭRЭ\  ^  R HX<Pď`   P@@PPЭPW)޼P`ЭPF<f  Pѽ<PPPPPHЏ  PP ^i  R"  S޼P `ݏC  <޼P`ЬPF@P"޼PЏ `<Pď`   P@@PPЭPV$ЭQ\PP\>\P<`PPЭP WP  ^լ2P޼P`޼P`7e  P	ЬPРPЬPРլ2  P| ^1  V<JRR@   ޼RЏ bJSJRRJ<SR RB@RR޼R(bЭS޼R(b޼R b| ^  V޼RbB  d  P޼R(,  bЏ   P JPP<R RB@RR޼RbEd  P޼SЭR(cЏ   PRRJ޼R(  b2  P ^e  T  SЬPՠJЬPݠJЬP J(P~  z  Ph  ޼P`ЬRЬQЬP   ЬQЬP ((& ^Ӣ  S  TЬPJPP޼P`޼P`P!Pݏ  zDT   I  ЬP>6P<`PP[  P   PPЬPՠ~ЬPް~P`PàPPЭPѠ1 ЬP``ݏ  öÞ     нRЭP>QJPa`@  '4  
0  ݬh  ЬPݠ~ЬP2ݽݬ`ЭP>P` ЬPy癭PPݭ<PPЭPݠݽP<Q<PPQP	 琭PP항PPj  )^  Z  Pݬh  ЬPݠ~ЬP2ݬPPPP19޼P`  ^ЬPt P ^I  S <RR   jP<P@HF޼Rb<P@HP`  P&<P@HR   PQPQ`<PPPPP<PP   Џ  P  ^  W  VЬRHЬRHBЬR>HR<bRBH0ЬR(ЬR>HR<bRBHR>`  P<RRPЬR(P챭<RRP <RR   SP<RBHDP<RBHRb<RBHRb<RRRRRR<RR   <RR   b.@  
<  h3  Џ  P-2RBHRb2RR2RRu    P<RRhYp  <Rݏ   PЭBHЭSЬR((ЭRЏЭTЭSЭR   ЭSЭR ((&ЭR JЭRЬFЭR TЭR tЭTЬRRʏRSRSSyЭR zЭR ~ЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR.ЭTRRЭSRRcdRR<RRЭR   PSRSb<RRP ^%  S  Rc  
_  P<PPhÆ  <P@H<P @H9 ^  Vz  W<RBHѽ!Pݏ  ưT   I  <R*PЭBHЭSЭR(ЭSЭRТЭSЭRЭSЭR  ЭSЭRЭSЭR&&ЭSЭR((ЭR   PSRSbЭRբ~ЭRݢ~ЭR޲~RbR޲RbЭR ~ЭRբzЭRݢzЭR޲zRbR޲RbЭR z   ^  V>  W<RBHѽ!Pݏ     
  <Rݏ   kPЭBHݏ    ݭ  ЭSЭR(ЭSЭRТЭSЭRЭSЭR  ЭSЭRЭSЭR&&ЭSЭR((ЭRЬFЭR zЭR ~ЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR.ЭTRRЭSRRcdRR<RRЭR   PSRSbݭ{P ^  S  R:  6  P'  ݏ<  5ﱾ {  P\\ <\\   1<\LHխ1Э\ì\\\\     2\\<\\Y9  1нPP 1y  P?P1,T<\\<G  
C  +PЭ\cP<\\r  <\\ψ1}-p  
  <\\ù      (P-2\\Э\PF  <\\r1P@\\@s  
o  P<\\1  1Э\&
Э\(1 Э\&Э\( \\ PD\\D  
  P<\\v      (P2\\Э\ݬJPèF  ݭ1P  ~  &PݽP<\\   J  F  &PЭ\ݬFЭ\ݬJχP%  `\\`Э\ެ\l     P Э\2\\D      $PЭ\2(\\Э\2&\\gJ  ݭЭ\ݬF]PEPz  v  1P2\\4\\44<\\å  \\<\\   1Dֺ ^  R  \\ 4^  SR  R޼QaPP ~   
P?P1a    P´?      5ݬݬPЬPPPPP˹P  ЬPЬPJP ` ݬݬݬ1-TPPT PP    
  ´/      ´Zo      RݬݬPЬP>RP<`PPЬPPPPPP޼P`Pm  ЬPޠ@P` ЬQPPXPPX0  
,  ЬP2PPë  ݬݬ1    P´      DݬݬPЬPPPPPP޼P`DP1  ЬPЬPJP ` ݬݬݬgPݬЬPPPPPﯷP޼P`P´9  ´q  ݏ  òÛP ^ЬЭPРЭPѠ
 kѽeЭP6PPЬ޼Q                                                                                                                                                                                                                                                                            K $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          n "     l       ЭPޠ2P`aЭP>2P`<PP/ЭRPPЭQPPabRR<RR޼R b x^  W  VЬRݢ2ЬR6   ﹕Pխ\    Pݭh  ޼RbЬTЬSЬR   ЬSЬR ((&޼Rb޼Rb_SRD  PDRݢDЭѭ 1 ^  1ݏd   ƨ^(nu3ƨh'	   ݬ+ݏ  -	ﵵ޼RЭb 2  
  ݭhQ	  1 ݏ   ݬլ_@MլHѬ   >ЬRB@3ЬS߭LЬRݭЬRB@RbPzPЏ %P߭LЬRݭ;  Rb ݬ9ݏ5  s	ô޼RЭb޼RЭbխЬSRR9  1ݏd   ƨ^(n1ƨhǗ	[   ^@  W  VЬRRR<RBHЭRTRRЭRRRR ЭRRʏRR	RRRR ЭSЭRТ@ݬݭd#޼SЭRޢRbcݭPP1 P{(P R	R bRbЭR>SRcb  *  
  Pݬhǝ	#  ЭRݢ~ݬݬĻ޼R b P< ^޼RbPP  ` `     ^?P1 ЬRT9޼RbЬTЬSЬR   ЬSЬR ((&qЬRt' ݬPЏ^(n4~>Pݬ1ЬTЬSЬR   ЬSЬR ((&PP h^  Wȿ  VЬRRR ЭRRʏRSRSSЭRRʏRSRSSЭRRʏRSRSS  '  
  ݬw	s  ЭRFЭRݢ<ЭRfPЭR>FRbDЭR<Rď`   RBƆL  P <Rď`   RB@SЭRc<}P>  :  #PݬݭσPh	  ?  
   ݬh
  ݬݭݏ ݬϗЭS<Rď`   RBƄRDb1  RR   
  $PݬݭPhǅ
  K RR U  Q  ݬhǭ
  ݬݭݏ ݬЭRFRbЭR>FR<bRď`   RB@RRݬݬݭϑP+ϻ  
˻  Pݬh
[  ЭRHRb<RBH  0    ݽ#Ph
  ѽѽѽ1 PѽЭRТ*RRЭRТRRЭԭЭRѢ@P RR   
  0PݬݭGPݽϏPh$w  
ݭoѽ1 ﯺ  ^  
  Pݬh[/  y  u  "ݬݽPhǁ  ݬݬ<RR[P1  4%  !  "ݬݽϿPh  ѽ~ѽxսsݭ=PݽυPhU  ݬݭPݽSPh;  ݏZ  {UЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR/ЭTRRЭSRRАcdRR<RRЭRЬF1 ЭRѢ1 ЭSЭRТ@*ЭRNRRݭgխ1  RR 隸    3Pݏd   ƨ^(n)ƨhǟ  a  ]  ݬhǥ  ݬݭݭݬЭRբz1UЭRբ~1 ЭSЭRݢzЭR޲zR޲ R޲ RbP~խ1 ׷  
ӷ  4Pݏd   ƨ^(n(ƨhG      ݬh  ݬݭݭݬ&ЭRNSЭR޲~R޲ RSbA:  6  Pݬh!
  ݬݭݏ ݬ۞YSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR bЭR@ݬЭR>JR<bSЭRCP^(YnЭRݢ~ЭR޲~RbR޲Rbխ1 U  1ݏd   ƨ^(nl'ƨht
    
  ݬhz
  D޼RbЬR^(nDݬݭݭݬϐЭRޢ@Rb ЭSЭRѣ@I RR     +PݬݭPЭRݢhǰ
  ЭSЭRѣ@qսlѽݬݭݭݬ?K RR   
  ݬh
  ݬݭݏ ݬϫսXЭSЭRѣ@IRRЭRTشЭTЭSЭR   ЭSЭR ((&1 ЭSЭRRѣ@R1  RR R  N  #PݬݭϗPh%  K RR 
  	  ݬhF  ݬݭݏ ݬϟЭRRʏRRW߭ݬ<RRݬݬPխ(  
  ݬhv#  ͰPЭR>JR<bRR Ͱ RR C  
?  PݬhǗ  ݭZޕ  
  ݬh  ЭSЭRТ@ЭRuR bЭRЭ.ЭRd5oЬR>R<bRR:  P   PPЭRբ~ЭR޲~RbRâRR䰏P ͦͨRЏ
 bЭͬ ͱ ] UYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR b^S^R  PD^^RݢD=Bp=ѭ 1况  辰  h;  ЭU ݭυݏ?    p RR K  
G  PhD  %  2ݏd   ƨ^(Un;"ƨhh  ͲRRܕP^(UnPЏ PURRݭݭl1I*  RR!  ݏ   ݭωЭRV1 o  Oc  
_  =PݬЭR>DR<bSЭR޲XRCbЭR>DR<bRRhn  ͱ߭߭^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbR
b1 PEЭRREЭRݢ\ϘPխЏ A^(An
o  Lt  
p  :ݬЭR>DR<bSЭR޲XRCbЭR>DR<bRRh  ͱ߭߭ݭ^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbRb ݭݏ  gѭ9ͱݭͲRRݏ ݭIPRѭRR]^$m;ЭR JЭTЭSЭR   ЭSЭR ((&1(P ЭRHRbЭRLR bЭR ЭRܢ1 ]1 ЭR JЭTЭSЭR   ЭSЭR ((&ЭRJRb  Q  ~  Pݬh=  Y  U  ݬhj  ЭRݢ~ݬݭݬ1 ЭЭRNRЭbЭRբ~ЭR޲~RbRĢRRЭRݭPJP   RRݭЭRݢJW  ]	PЭЭRRR b  Q    PݬhǏ  ]  Y  ݬhǻ  ݭݬؕͰ<&  )    Pݬh  ݭ@ЭR ^  PSRSbͱݭЭR .P1 U1 ˏ  URR   RR   \ݏd   ƨ^(Unƨh  K  
G  Pݬh$  ^(Unj^(Un[P| RR   Yݏd   ƨ^(UnƨhFn  ︪  
ﴪ  ݬhLG  ^(UnjP 0^-y  T  SPPPPЬPޠ@P` ЬPHЬRЬP(\؞HQPaЬPH=ЬP>HP<`P@H+ЬP(ЬP>HP<`P@HP?9  P1   Pީ  ک  Pno  ﹩  ﵩ  ݬėG  6    #PݬݬPĮ  dPPdЬPЬPJP ` ݬݬݬЬP>HP<`P@HЭP^ЭQ&R&PP&R PP   
  ЭP2PPЬPݠ@m  ЬP1fPЬRЭPѢ@1 LPPLdPPd  ~  )PЭPݠЬP>HP<`PP   G  
C  PݬݬϋPZ  ЬPЬPJP `  *  
  Pݬk   ݬݬݬ-ЬRЭPѢ@.ЭR #  PQPQ`ݬݬݭݬϔHPPHv  5j  f  #PݬݬϯPĠ  P ^u  T  SЬPH=ЬP>HP<`P@H+ЬP(ЬP>HP<`P@HP/6  PQ0PP0˦  
Ǧ  2PݬݬPЬP>HP<`PPh=  ЬP>HP<`P@HЭR   PQPQ`ѽTЬQЭPѡ@EG  
C  $PЭPݠЬPݠ@h  ݭR1 P8PP8  
  Pho  ѥ  ͥ  ݽoPę\  殮    PЭPݠЬPݠ@ļ,  P $^!t  Tڦ  SPPЬPH>ЬP>HP<`P@H,ЬP(ЬP>HP<`P@HPd4  PbP$PP$  
  2PݬݬCPЬP>HP<`PPhq  ЭQPP1ЬP>HP<`P@HѽѽЬRЭPѢ@aP(PP(k  
g  @PݬݬϯPЬPݠ@ЭPݠݽPhD  ЬP>LP<`RЭP2 PPPRP16ЭRЬPѢ"@1$ PP ݣ  ٣  (ЭPݠ"ЬPݠ@ЭP2 PPĦY    
  (PЭP2 PPЬP>LP<`PP  i  e  ЭP2PP  ЭQPPhЭQ(R(PP(R PP   
  /  ЬPЬPJP ` ݬݬݬ7ЬP>LP<`RRЭP>RP<`PRPxЭR   PQPQ`ЭRЬP>LP<`PPPPQRPQ`ЭRЬP>LP<`PPPP ЭRЬPޠ@Q"Pa`PPݭݬ
PPЭQPP1P ^p  Tv  SЬPHЬRЬP(ОHQPaЬPH=ЬP>HP<`P@H+ЬP(ЬP>H                                                                                                                                                                                                                                                   !                        С! $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "     }       P<`P@HP0  P1 dPPd,PP,|  Wp  
l  hQ  M  I  "ݬݬϓPhĈ  ЬPЬPJP ` ݬݬݬbЬP>HP<`P@HЭR U  PQPQ`ЬP
ЬPJP `ﶠ  )猪  裂  Pݬh7   ݬݬݬݜݭP ^
o  Sơ  RPP@  
<  9ݬݬχPЬPPPPPPh  P t^n  WX  VЬRRR޼R bЭR>HR<bRR   kЭRH_RRRR  5  
  #ݬЭR>HR<bRR8
  ޼RЏ bЭR>FR<bRR lЭRF`RRRR  6  
  $ݬЭR>FR<bRRV  ޼RЏ bЬRRޭRЬb<RR1PЭTRRЭSRRcdRR<RRL   PRRLЭRբ81 ЭRѢ8L| RR  RR 6  2  Ptǿ    
  ݬǔ  ݭݏ ݬϣЭR8RLbݏt
  ǵ_޼TSRP  PDRݢD\Эd޼Rb #޼R^(bn\ЭRRRRRխݬݬݬVP&  3    !Pݬ<RB  ݭݬ<RB<Rbլ6ЭRNRﵚ  SBc"ݬЭRNR  SBcR޲Rb ݬW[9< ^Ь SR  PDRݢDZЭѭ խݭ^(n[ЭR>JR<bRRݭaPݬݬݬݬݭݬݭݬZ  ^!  QPPPPP< ^ЬЭRѢݬݬݬl6PЭRТѽ޼RЏ b޼SЭRТ.R(c޼R b  ^  Q޼P `ЬPРѽ\PP\޼PЏ ` PPЭPՠz޼PЏ `ЭPРzPP ^9  R޼P `ЬPРѽ\PP\޼PЏ `.PЭPՠ~ЭPݠ~ЭPް~P`PްP`ЭPЬ~P  ^͛  Q޼P `ЬPРѽ\PP\޼PЏ ` PPЭPР~PP ^  RѬ   ޼PЏ `@+ݏ   ʘP@ ЭP @@   ЬPЬ@@޼P     ^  P D| ^  V ޼R bHm޼RbcP<Rď`   RBƗ.ЬScTcRRcďV   T޼S<Rď`   R(V B@DcRRH޼RbPЬScRRc޼R b  ^˳  RPP PP߭߭ݏ   ݭݭݭ ݬ
Hq޼P`<PPPPPЭ䋏QQQ{  PPPQP.Qd  PQPQU  PQP
޼Pн``QQQ3  PPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭP| L^  V]S]RU  PD]]RݢDLVLYY !Xݭﵖ^(YnV޼Rb RR<RRSR   SSXXRRݭBP	ͥRR<RRRRRЭܭЬRRíܭRRͥRR߭߭ݏ   ݭݭݭݬ
:o<RRRRRЭܭSSSu  RRRSR1 S[  RSR1 SI  RSR1 RRRRRR>RbRR౭Џ  T^(TnuUíܭRRRRR޼RbRR<RRRݭݭ<RRRRíܭRRRRR޼RbRнbRR޼Rнb1PRRSSSb  RRRSR
>Rb"P>RRЭЭRЭR̢RR౭Џ  P^(PnT޼RbRR<RRխ1 íܭRRRRRSSSÒ  RRRSR
н<P޽RRЭЭRЭSЭRЭSЭRЭRĢRRRRRRխ1líܭRRRRRSSS/  RRRSR޼RbRнb=޼RbRRЭ୼ЭRЭSЭRЭSЭRЭRRRSSS  RRRSR
޼Rнb?P޼RbRRЭ୴ЭRЭSЭRЭSЭRЭRݭ晴XݭY]R| ^  V%S%R  PD%%RݢDpQ!! ! ݭ!^(!nER޼Rbz RR<zRRSR   SS  RRݭ﬑PPmRR<zRRRRRЭܭЬRRíܭRRmRRmqr߭߭ݏ   ݭݭݭݬ
j<zRRRRRЭܭrSSS׏  RRRSR1rS／  RSR1sS祐  RSR1RRRRxRR>vRbRRvxЏ  ^(nP޼RbRR<vRRխ1íܭRRRRR޽RнbRRЭRRRݏ@   ݭݭј@   RRЭRDRbRRíܭRRRRRЭRFRнbRRЭRJRbRRЭRLRbRRЭRNRRЭRORRݭݭ,RRȏV   RRRRխ1íܭRRRRR޼RbRнbRR޼Rнb1sPRRrSSSՍ  RRRSR>vRb!>vRRЭ୼ЭRЭRRRvxЏ  ^(nN޼RbRR<vRRխ1íܭRRRRRrSSS2  RRRSR
޽Rнb<P޽RRЭ୴ЭRЭSЭRЭSЭRЭRRRЭRRR խhrSSSﲌ  RRRSR
>Rb"P>RRЭ୬ЭRЭRRRRRRRխrSSSK  RRRSRЭRDRb#ЭRDRRЭ୤ЭRЭRRRíܭRRRRRrSSS  RRRSRЭRFRнb@PЭRFRRЭଡ଼ЭRЭSЭRЭSЭRЭRRRrSSSp  RRRSRЭRJRb$ЭRJRRЭ୔ЭRЭRRRrSSS  RRRSRЭRLRb&PЭRLRRЭୌЭRЭRRRЭRNRRЭRORRխ&RRRRRRխȏV   RRRRխ1íܭRRRRRrSSSC  RRRSR޼RbRнb=޼RbRRЭୄЭRЭSЭRЭSЭRЭRRRrSSSՉ  RRRSR޼RнbCP޼RbRRЭ||RЭS|RЭS|RЭR|qݭﶊ ݭ壘!%J ^  RPP PP߭߭ݏ   ݭݭݭ ݬ
c޼P`<PPPPPЭ䋏QQQﻈ  PPPQP.Q龜  PQPQ  PQP
޼Pн``QQQs  PPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭ\    ^ݬL޼P` PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R   < x^SR  PDRݢDzGzѭ խݭ3^(nH ޼Rb<RRRRRЭSSS߆  RRRSR2SȆ  RSRެRS﵆  RSR
ޭRнb]SSS  RRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭRآRRRP߭ݭݭݬv RRRRRRЬ$SRѭRRccRR޼RݭPb޼RЬb޼S<RRRcRRЭRRRR԰ԽRRRRRRҰҽRRҭЏ  ~^(~nFíRRRRR޽RR<RRRݭݭ<RRRRíRRRRRЭRRЭRR޼ SíRRcխݭ܅޼(R b< l^~S~RL  PD~~RݢDnDnzz  խݭy^(znE ޼Rb<RRRRRЭSSS$  RRRSR3S
  RSRެRS  RSRޭRнb^SSS׃  RRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭR̢RďV   RRQPv߭ݭݭݬ Rď[   RRRRRЬ$SRѭRRccRR޼Rݭ4PbP޼RЬb޼S<RRRcRRЭRRRRȰȽRRRRRRưƽRRƭЏ  r^(rn
DRR<RRխ1íRRRRRнܽRRЭRRRݏ@   ݭݭ@   RRЭR>DRbRRíRRRRRЭRޢFRbRRЭR>JRbRRЭR>LRbRRЭRNRRЭRORRݭݭoRR܏V   RRRRխ1íRRRRRЭRRvRR޼ SíRRcխݭ.z~A޼(R   ^ݬ޼P` PPЬ$QPѭPPaaPP޼RݭׁPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R b    ^E  Qլ#Ѭ
2P@޼P `Џ   PP޼PЏ
 ` P ^  R޼P `  ޼Pѭ`޼PЏ `)P2PP@ЭP޼Q@aPP
޼P   ^  S޼P `޼R޼Pb` Pݬ޼P<`PPP1PˏPPKݬݬݬݬݬ޼P<`PPP2PP@Pް0P`P޼P`1ZP P1ˏPPwݬ߭ݬݬ	  ޼P`1ݬ߭ݬݬY	  ޼P`1 Pѭݭ  P P1 ˏPPsݬ߭ݬݬ	  ޼P`1 ݬ߭ݬݬ	  ޼P`nPѭݭn  P PˏPP2ݬݬݬh   PRݬݬݬR   RP PЏ   P޼P ` Ѭ ݬ                                                                                                                                                                                                                                                   "                        ST $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "            ݬݬ  P	PPPPPPP ^q  Rݬ޼P<`PPPݬݬݬ޼P<`PPP2PP@Pް P`PP ^!  Rݬ޼P<`PPP޼P`ݬݬݬݬ޼P<`PPP2PP@PްP  ^ɚ  Rݬ޼P<`PPcP޼P`ݬݬݬݬ޼P<`PPP2PP@PްP  ^Id  R޼P `ݬbݬ  P
Pݬߢݬ  PPݬߢݬy  PPݬߢ
ݬ^  P P޼PЏ
   ЏP ^c  RЬPP 
, \ 8 \ \ \ D \ \ \ \ \ \ P 
P^?P2PޢPP2PޢPP&PޢPPPޢPPP޼PЏ
 `޼P`ݭݬ  ݭ  P޼Pѭ`޼PЭ`޼P   ^  R޼P`Ѭ  ޼PЏ `ݏ  ݬ>  ЬP @PPլg:ݬ   Pխ޼PЏ ` ݬìPPݬP޼P`ìPPPPPPPݬݬP޼P`ݏ[   ݬ  PխЬT ݏ]   PPn  Pխ޼PЏ ` PPN  PPPìPP޼P`PPV޼P`PQP#QQ	PPݬݬݬݭPPݬݬ2P@PްP`Oݬ߭ݬ  ݬݭݬݬX  ݬݭݬݬ ^`  T  SЏd   Џd   ݬ޼P<`PPPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`ЭP @߭(ߤ"4  ޼P`ݬ  
  P޼P`޼Rݬ  PPPb޼Rݬݬ P   ^_  T  SЏd   Џd   ݬ޼P<`PPrPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`'ЭP @߭(ߤ)	  [Pݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`ЭP @߭(ߤ/  ޼P`ݬ    P޼P`޼Rݬh  PPPb޼Rݬݬ P  <  ^ݬ޼RbݬP޼Rbݬ߭߭߭ݭ޼R<bRR  ޼Rb޼R(b޼SޭRb  ^  RݬݬPݬݬ2P@P P  PP ^﹓  RݬݬYP޼P` ݬ  ޼P`ݬݬݬݬ2P@P P   ^U  Rݬ޼P<`PPP޼P` ݬ  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@Pް P  ^ݒ  R޼Q޼P`a޼P`ݬ޼P<`PPePݬݬݬݬݬ޼P<`PPP2PP@Pް$P   ^u  Rݬ޼P<`PPP޼P` ݬҗ  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@Pް(P  ^  R޼Q޼P`a޼P`ݬ޼P<`PPPݬݬݬݬݬ޼P<`PPP2PP@Pް,P   ^  Rݬݬ5Pݬݬݬݬݬݬ2P@P4 P   ^I  RЬݬ޼P<`PPPݬݭݬ޼P<`PPP2PP@P8 P   ^  RЬݬ<PPPݬݭݬ<PPP2PP@Pް<P` .A    A      ^Z  S  T c@  Pѭ2ݏ  ߣ  Pѭݏ  ߣ4  ѭݭ  Pѭ`޼Rb޼RbЬP P:P޼RФbЬR> P<`QQ  QPQ`>P<`PPЬRbPPb޼RbЬP>Q Pa`ѭ#  ݭN  ݬݭ  ݭ-   X^𢡊  T|J  Ï PPNRD{RPNPP@PRPR޼RGgPJPPPbЬRPPQPQ`ݬIդ<1  j߭߭j߭n>P<`PPjݭn߭ ,  j߭,ݭPP<ЬPP `ЬP, ЬP	  Ѥ<Ф<PPPݭ.ЬP	   ^	X  RЬPPPЬPPPЬP
PPЬPPPЬPPPЬP
PPЬP	PPЬPPPЬP>P<`PP޼P`ߢN   M    ^}W  R??߭ ݬ  Pѭ
޼PЏ`޼P `޼PЭ`ЬPP`ЬPЬPP `ЬP	ЬP
ЬPЬPЬP
ЬPЬP     ^ ޼Q޼Pa`1 ЬQЬP1 ЬQЬP1 ЬQЬPrЬQЬP		cЬQЬP

TЬQЬPEЬQЬP6ЬQЬP

'ЬQЬPЬQЬP	PPPPPPP ^ЬЬ ЭQPPaRЭQPPaPPRRխЭPЭP ^ЬЭPͽQЭP̠QЭP̠QQP̭Pʏ  PPQЭPЬRRRPRQPQ{RPPQQP  | l^頋  VuSuR  PDuuRݢDll-lqq !pݭn^(qnA.޼Rb RR<RRSR   SSppRRݭmP	ͽRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭuRRíܭRRRRRЬRRíܭRRͽRR߭߭ݏ   ݭݭݭ ݬ
F<RRRRRЭܭSSSUk  RRRSRDS>k  RSR0S/k  RSR ޼RbRнbRR޼Rнb1 SSSj  RRRSR޼RbRнb=޼RbRRЭЭRЭSЭRЭSЭRЭRТRRSSSj  RRRSR
޼Rнb?P޼RbRRЭЭRЭSЭRЭSЭRЭRȢݭpkpݭ_kqu*  ^޼P`<PPPPPЭQQQi  PPPQP1 Qi  PQP1 ެPQi  PQP1 ޭPн`PPP`PPP`PPPPPPݭݭsPPíPPPPPޭPн`1QQQi  PPPQP
ޭPн`9ޭPPЭЭPЭQЭPЭQЭPЭPؠPPQQQh  PPPQPP`!PPPЭЭPЭPРPPQQQOh  PPPQP
P`PPЭЭPЭPȠPPPPPPխ&PPPPPPխíPPPPPQQQg  PPPQP
ޭPн`<PޭPPЭЭPЭQЭPЭQЭPЭP߭ݭݬ4 PPЬ$QPѭPPaaPP޼Rݭ3hPb
P޼RЬb޼P<RRR`RRЭЭRRЭRR޼ PíRR`޼(R b  ^ЬխЏP ѭˏPP&xPPPPѭˏPPЭP ^ ЭP޼Q@a$ŭ RЭP޼Q@asPRRЭP?ʘ P ^}  R%  ޼PЭ`ЬQ>P<`PPPP޼Q< PPaЬPТ$ < $^޼R( bݏi ݬ@  P PRSRS3SRRRRPP< $^޼R( bݏi ݬ  P PRSRS3SRRRRPP< $^޼R( bݏ
i ݬ  P P>R<bRSRSSRRP< $^޼R( bݬݬYP%ݬݬPݬݬPP Pݏi ݬ2  P PRSRS3SRRRRP  ^ݬ 
  PխЏPЭPްP`P  ^߬  Pխ PP  ^ЬѬ޼PЏ `ЭP> P<  PP
  PPPP ^Ь޼P`޼PЏ `޼P`޼P `ЭRݬ  PQ PQ   ^Ь޼P`޼PЏ `޼P `Ѭ (Ѭ  ЭRݏ     PQPQ`PP |^ЬѬd   ޼PЏ `޼P `޼P` ݭr  ݬݬݬݭݬݬ߭
  ЬP @4߭
  Pѭ޼PЏ `ЭPPЭ`1 ߭PЭPP޼PЏ `ޭPPޭPPЭRPPЭQPPabЭQRRЭPRR`aЭQRRЭPRR`aЭQRRЭPRR`aЭRRЭb޼R  < ^ЬѬ޼RЏ bЭR^(n	  P޼RݭB  PbP޼RЏ bݭݬ  ޼Sݬ  PRRc޼R     ^ЬѬ޼PЏ `޼P `ЭPՠ$޼P`ݬ	  P޼PЏ `8ЭPݠϧPխ޼PЏ `޼P`ݭݬ  ݬm  P޼Pѭ`޼PЭ`P  ^޼P   Џ   P  ^ ЬP  ޼P` Y  Pѭ޼PЏ `Џ   PPݏiݭ  Pݭ  ޼PЏ ` PPPPխ1 ߭ݭe  ݭݭ0P\ݭݭgPKݭݭP:ѭ4ЭPPPЭPР߭ЬP  ޼P ` PPPPխ1jݭ/  ޼P     ^ЬЭPРѬ޼PЏ `޼P `޼P`߭ P i    ^ЬѬ޼PЏ`޼P `޼P`ЬP߭(  ЭPP    ^ЬЭPРѬ޼PЏ `޼P `޼P`߭ P ́    ^ЬѬ޼PЏ`޼P `޼P`ЬP߭  ЭPP    <^ЬЬѬ޼PЏ `Ѭ޼PЏ `ݬݭ6  ݬݭ#  ޼P `Pݠ  PPPPݠ  PPPˏPP'ˏPPˏ Qˏ PQP1 ˏ?PP   .ˏ?PP   ˏ  Qˏ  PQPGPˏ?PP   .ˏ?PP   ˏ   Qˏ   PQPP ːPPPPP| ΰ^7E  V޼Rb޼RЏ b n  Pѭ޼RЏ bЏ   RRݏiݭ  Pݭ  ޼RЏ b RR RRխ1 ޼Rѭb1 S޼RCbRR(                                                                                                                                                                                                                                                    #                          $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          $ "            ͼݭݭϷPѭP1 ЭR޼SBcRbЭRݬ  PSRSbͼݏi ݭ  Pf~  0RRЭRЭR~  RR&P RRRRխ
޼Rѭb1޼RЭb޼R b    ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ  ^Ь PPЭPc޼P`ЬQaPPa  ^Џ   ߭ݏ~fݬ   P  ^   }  PP  ^ݬݬݬݬ   ]  PP  ^ݬݬݬݬݬ   !  PP  ^ݬݬݬݬݬ     PP <^9B  R*}  S߭}  PˏPP ݬN|  Pխ	cЏPP`ΞPPˏPP' PP#枭PP ЬЬݭݭ      ߭<PPݭݭ PˏPPݭb|  ЭcЏP>P<`PʏPPH>P<`PP>P<`PP>P<`PP>P<`PPߢ{  >P<`PPPPcЏP߭{  P P     {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  {  |{  x{  t{  p{  l{  h{  d{  `{  \{  X{  T{  P{  L{  H{  D{  @{  <{  8{                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  rpc$exe:rpc$stcode.dat status %lx status %lx (%s) status %lx (%s/%s) %s (%s/%s) rpc$exe:glb_obj.txt rpc$exe:glb_sites. rpc$exe:glb_sites. Can't open '%s', errno=%d
 rpc$exe:glb_sites. (find_server_nbrd) Error reading '%s', errno=%d
 rpc$exe:glb_sites. (find_server_nbrd) Error reading '%s' - file is empty
 rpc$exe:glb_sites. (find_server_nbrd) no more potential sites
 (find_server_nbrd) trying site '%s'
 (find_server_nbrd) error converting to sockaddr (0x%lx)
 (find_server_nbrd) family mismatch '%s' (%d) and %d
 (find_server_nbrd) '%s' LLB lookup failure (0x%lx)
 (find_server_nbrd) '%s' LLB doesn't have a GLB registered (0x%lx)
 (find_server_nbrd) LLB lookup result %d, invalid family (%d)
 (find_server_nbrd) LLB doesn't have GLB registered with valid family
 'couldn't convert name' (find_server_nbrd) GLB registered at '%s[%ld]'
 (find_server_nbrd) couldn't set glb binding (0x%lx)
 (find_server_nbrd) RPC runtime failure on glb lookup(0x%lx)
 glb.c: check_binding()  finding server...glb_$client_epv.glb_$find_server = 0x%X
     333b91de0000.0d.00.00.87.84.00.00.00 333b91de0000.0d.00.00.87.84.00.00.00 333b91eb0000.0d.00.00.87.84.00.00.00 333b91f70000.0d.00.00.87.84.00.00.00 %s
     
INTO u_pfm signal_handler for signal #%d.
-----------------
 *** Exiting: exception caught by PFM system cleanup handler
*** %s
   NA ERROR %*.s[%lu] %s%sgave out socket index %d from pool
 Ran out of sockets RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%smaking a new socket. None left in pool.
 %s%ssocket() got sock #: %d
 %s%sCan't create socket, errno=%d
 rpc_client.c %s%sCan't bind socket #%d, errno=%d
 %s%si = %d, nsockets = %d.
	Marking this socket in use..
 %s(free_socket) set sock->inuse = false. sock # was: %d
 %s%s
 %s(send_pkt) cannot enable broadcast, status = %08lx
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 rpc_client.c %s(send_pkt) cannot enable broadcast, errno=%d
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(c_recv_pkt) Rcvd callback (ptype=%s)
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(c_recv_pkt) This packet IS NOT for my activity ??
 
%s(c_recv_pkt) IGNORING OLD PKT..  pkt->hdr.seq #: %d, current seq #: %d, old_pkts_rcvd: %ld

 %s(c_recv_pkt) Rcvd packet with bad seq (should be %lu, is %lu; ptype=%s)
 Can't register call RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 
%swho_are_you says you crashed..

 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(ack_replies) Acking [%s, %lu]
 rpc_client.c %s(ack_replies) Can't send ACK, errno = %d
 RPC reply acknowledger %s%s
 %s%s
 %s%s
 %s%s
 %s%s
 
BAD TIMEOUT !! = %d  || end_time ? = %D  forcing to 5..
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(await_reply) case 0 timeout..
 %s(await_reply) select failure .. errno = %d
 rpc_client.c %s(await_reply) select returned junk, errno=%d
 "rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
 mispacked header stuff messed up RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 
%s%ssees NO COOKIE !?

 %s%sRaising comm_failure. We have no family ?
 %s%sSignaling args_too_big !.. ilen = %d, rpc_$max_body_size = %d
 %s%ssockaddr has specified port..
 %s%sinterface has no specified port.
	Setting to well known port..
 %s%ssetting port to interface defined port
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%s
 %s%scan't get encr, status=%08lx
 %s%sRequest Count:  %D
 %s%sRAISING COMM_FAILURE !!  Request_count > MAX_REQUESTS
	request_count = %d, MAX_REQUESTS %d
 %serror sending !large_in pkt..
 %sError sending frag pkt..
 ! recv_pkt .. request_count = %d, wait_count = %d
 %s%sforcing wait_time of %D to 64..
 %s ?? GOT rpc_$fault || rpc_$reject..
 %s%sAnomolous response to request (ptype=%s)
 %s%sawait_timeout detected..
 %s%sraising comm_failure because of an await_timeout on broadcast..
	We've retried MAX_BROADCASTS times..
 %sawait timeout whilst sending_frags.. request_count = %d
 %s%sStarting to ping...
 %s%sawait select failure
 rpc_client: select failed RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%sawait unknown error occured..
 rpc_client.c select failed RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%sRAISING COMM_FAILURE --> TOO MANY PINGS !!
 %s%ssleeping.. now = %ld
 %s%sawake !!   now = %ld
 %s%spwait_time = %D, ping_count = %d, total pings = %D
 %s%strying to raise comm_failure.. pfm_$fault_inh_count = %d
 %s got rpc_$fault || rpc_$reject whilst pinging.. request_count = %d
 %s%sAnomolous response to ping (ptype=%s)
 %s%sawait_timeout.. going to SEND_PING
 select failed RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%sRcvd "working" during frag send!
 %s%sRcvd "working" pkt; seq=%lu
 %s%sGot "fack" for non-large request!
 %signoring old fack..
 %s%sGot non-frag "response" during frag recv!
 %sError sending frag response..
   (rpc) *** FATAL ERROR "%s" at %s\%d ***
 _REQUEST_ client -> server _PING_ client -> server _RESPONSE_ server -> client ** FAULT ** server -> client _WORKING_ server -> client _NOCALL_ server -> client ** REJECT ** server -> client _ACK_ client -> server _QUIT_ client -> server _FACK_ client <-> server _QUACK_ server -> client BOGUS PACKET TYPE %s(rpc_$recvfrom) recvfrom failed ??? 
 %s(rpc_$recvfrom) recvfrom failed ??? 
 (rpc_$recvfrom) recvfrom failed %sCan't convert socket to name.. st.all = 0x%X
 
RECV DATA FROM:  %s, port[%d]
 %s(rpc_$recvfrom) Didn't get anything from the recvfrom call.. recv_len = %d
 %s(rpc_$unpack_hdr) Bad RPC version (%u)
 %s(rpc_$unpack_hdr) Bad pkt type (%d)
 %s(rpc_$unpack_hdr) Time is: %D
	NO PACKET DATA:recv_len = %D
 +------------------------------------------+
 %s(rpc_$unpack_hdr) Packet too short; is %u, data len is %u
 %sCan't convert socket to name.. st.all = 0x%X
 
SENDING TO:  %s, port[%d]
 (rpc_$sendto) sendto(2) failed ?? pkt->r                                                                                                                                                                                                                                                   $                        p $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "            efcnt > 0 RPC$:[NCK_D.LIBNCK_D]RPC_UTIL.C;1 ..ALARM CLOCK..
 ..LEAVING ALARM CLOCK..
 n_tasks < MAX_TASKS RPC$:[NCK_D.LIBNCK_D]RPC_UTIL.C;1 %s%s
 	# of remote calls out:	%lu
 	# of remote calls in:	%lu
 	# of pkts sent:	%lu
 		%s	%lu
 	# of pkts rcvd:	%lu
 		%s	%lu
 	# of frag resends:	%lu
 	# of dup frags rcvd:	%lu
 %D  +---[ *Start%sPkt Header* PKTS RCVD: %ld, PKTS SENT: %ld, OLD PKTS RCVD: %ld ]---+
 Pings Sent: %D, Pings Rcvd: %D
 RPC  Vsn: %d
 Pkt Type: %d (%s)
 Flags: 0x%x   NULL
 Flags: 0x%x  Defs:
 Flags2: 0x%x   Object    UUID: %s
 Interface UUID: %s
 Activity  UUID: %s
 Server  Boot Time: %ld
 Interface Version: %ld
 Packet SEQ #: %ld
 My  SEQ # Is: %ld
 Operation  #: %d
 Interface Hint: == NO_HINT
 Interface Hint: %d
 Activity  Hint: == NO_HINT
 Activity  Hint: %d
 Fragment #: %d
 Pkt Body: %D.  bytes
 NULL Pkt body..
 rpc_$fault Code: 0x%08X, %ld.
 rpc_$reject Code: 0x%08X, %ld.
 Pings Sent: %D, Pings Rcvd: %D
 %D  +---[   *End%sPkt Header* PKTS RCVD: %ld, PKTS SENT:%ld, OLD PKTS RCVD: %ld ]---+

 	(Client -> Server) Packet was forwarded
 	(Client <-> Server)  Packet is the last fragment
 	(Client <-> Server)  Packet is a fragment
 	(Client <-> Server)  Don't send a FACK for this FRAG
 	(Client -> Server) `MAYBE' request
 	(Client -> Server) `IDEMPOTENT' request
 	(Client -> Server) `BROADCAST' request
 	(Client -> Server) out's can be BLASTED !
 NULL
 (Client -> Server) Packet forwarded in two pieces.
	Intra-machine function only ! [never over wire]
 <<< eh ??  FLAGS2 HAS RESERVED BIT FIELDS SET ??
 %s(rpc_$dump_raw_pkt) Time is: %D
	NO PACKET DATA !len = %d
 +------------------------------------------+
 +------[ START raw data for packet seq# %ld ]---------+
 
 %04x:    %02x  
+------[ END raw data for packet seq# %ld ]---------+
  RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 rpc_lsn.c rpc_lsn.c: (use_family) Can't create socket ??
 rpc_lsn.c rpc_lsn.c: (use_family) Can't bind socket, errno=%d
 rpc_lsn.c rpc_lsn.c: (rpc_$use_family) Can't getsockname, errno=%d
 rpc_lsn.c: (rpc_$use_family) Can't get my netaddr
 rpc_lsn.c: (rpc_$forward) .. forwarding.. size <= mtu, sock# = %d
 rpc_lsn.c: (rpc_$forward) .. forwarding.. does 2 sends because size  => mtu
 rpc_lsn.c: (check_for_pkt_common)  Rcvd (ptype=%s)
 rpc_lsn.c: (listen) Spurious quit_activity fault ignored
 (listen) Exiting, st=%08lx
 rpc_lsn.c rpc_lsn.c: (await_pkt) select failed: %d, errno=%d
 which < n_sockets RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 "rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
 mispacked header stuff messed up RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 RPC packet checker NULL	(rpc_$request -- handled specially)
 do_ping  (rpc_$ping) do_bad_pkt  (rpc_$response) do_bad_pkt  (rpc_$fault) do_bad_pkt  (rpc_$working) do_bad_pkt  (rpc_$nocall) do_bad_pkt  (rpc_$reject) do_ack  (rpc_$ack) do_quit  (rpc_$quit) do_fack  (rpc_$fack) do_bad_pkt  (rpc_$quack) %s, %lu.%u frag in_call_back working in_reply replied idle passive %s(send_rejection) via rpc_$sendto. sock# %d
 %s%s
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(free_reply) act->a.reply.opkt == NULL so don't call rpc_$free_pkt()
 act->state == as_in_reply || act->state == as_replied RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 act->state = as_replied RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(send_reply) Send small reply. sock# %d
 %s(send_reply) frag of large reply. sock# %d
 %s(get_activity) Can't allocate slot
 %s(get_activity) allocate activity slot %d.
 %s(free_activity) free activity slot %d.
 act->state == as_idle RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 act->state == as_passive RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %sENTERED ..
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s slot %d. delta = %d.
 %sFreeing passive slot %d. (act->state == as_passive)
	act->id = [%s]
 %sPassivating slot %d. idle. (act->state == as_idle) && delta > IDLE_TIME
 	act->id = [%s]  delta = %d, IDLE_TIME = %d
 %sSuppressing RETRANSMIT reply slot %d. (act->state == as_in_reply)
 %sFree reply slot %d. (act->state == as_replied)
 	delta > REPLY_TIME  uidseqstring = [%s]  delta = %d, REPLY_TIME = %d
 %sRETRANSMITTING reply --> slot %d. <-- (state = %s)
 	uidseqstring = [%s]	sock# %d
 act->re_xmt_send = %d, seq # = %D
 act->ping_protocol_error = %d, act->fack_protocol_error = %d
 %s slot %d. DELTA <= 0 #%D ! (delta = %d)
 RPC activity scanner %sact->state == as_working
 	(ptype = %s)  uidseqstring = [%s]  sock# %d
 %sact->state == as_in_reply || as_replied
 %sResending reply
 	(state=%s, ptype=%s, frag=%u)
	udeseqstring = [%s] sock# %d
 act->re_xmt_send = %d
 %sact->state == as_idle || as_passive || as_frag
 	--> NO CALL <-- (state=%s, ptype=%s)
	uidseqstring = [%s]	sock# %d
 %sInvalid activity state (state=%s, ptype=%s) sock# %d
 %sIssuing -DIE- `INVALID ACTIVITY STATE'
 invalid activity state RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(who_are_you) Can't bind to client, lst=%08lx  setting act->state = as_idle..
 %s%s
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(who_are_you) fault, lst=%08lx
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s%s
 %s(handle_request_frag) sendto -> sock# %d
 %s..ENTERED.. sock# %d
 %sUnknown interface [%s]	sock# %d
 %sSending rejection for NOT broadcast
	When ihint == NO_HINT
	-or- uids not ===  -or-  ifs.vers not equal.
	Sending on sock# %d. %sOpnum out of range ?  [%s]
	sock# %d
 %ssending rejection..
	Not a broadcast.. sock# %d
 %sahint == NO_HINT. sock# %d
 %sactivity state for this call => %s
 %sGot inappropriate request (state=%s) [%s]	 sock# %d
 %sact->state == as_passive. sock# %d
 %sactivity state IS NOW => %s, NEXT INS CHANGES STATE.
	sock# %d
 %sreset activity state from as_passive  to => %s
	sock# %d
 %sInvalid state (state=%s) [%s] %sInvalid state (state=%s)
	ID = [%s]
	GOING TO INITIATE:  >> DIE << operation !
	sock# %d
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s%s
 %sSending rejection. Not idem && act->prev_seq == -1 ..
	sock# %d
 %s%s
 %scouldn't get encr ? Sending rejection. sock# %d
 %spkt->hdr.auth_type != rpc_$auth_type(act->a.encr)
	Sending rejection.. sock# %d
 %s%s
 %scouldn't decrypt pkt ? Sending rejection. sock# %d
 %sOld sequence, previous=%ld [%s]
	sock# %d  IGNORING REQUEST !!
 %sOperation not idem. Sending rejection. sock# %d
 %sProtocol error [%s]
	sock# %d
 %sNOT a BROADCAST. Sending rejection. sock# %d
 %sPF_FRAG pkt == NULL. sock# %d
 %sDiscarding any saved reply(s). Going -idle-  sock# %d
 %sSwitching to -WORKING- state. sock# %d
 %sCouldn't set pfm_$p_cleanup(&crec)
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %sFault while executing request ??
 %s%s
 %sDispatching  iface->e.s.epv[pkt->hdr.opnum] opnum = %d
	address = 0x%X	sock# %d
 %sGeneric dispatch iface->e.g.epv[pkt->hdr.opnum] opnum = %d  address = 0x%X
	sock# %d
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s== non-maybe && idem &&  !large. sock# %d
 %sCalling  rpc_$sendto for sock# %d
 %s== non-maybe && idem && large.  sock# %d
 %ssending reply for sock# %d
 %sgot_frag on sock# %d
	Calling  rpc_$free_pkt((rpc_$ppkt_p_t) pkt)
 %s%s
 %ssignalling fault_st ? sock# %d
 %s%s
 %ssignalling fault_st ? sock# %d
 %ssay -NO CALL-  NOT valid_ahint(pkt) ?
 %ssending on sock# %d
 %sNo call (no activity for this call) [%s]
	sock# %d
 PROTOCOL ERRORING PING for seq # %D, act->re_xmt_send = %d
 %sNo call (higher numbered ping), ahint=%d, previous=%ld
 	[%s]  sock# %d
 %ssay -NO CALL- packet must have been lost sock# %d
 %sDrop PING !?
	uidseqstring = [%s]
	sock# %d
 %s(do_ack) NOT valid_ahint(pkt).  ahint = %d
	 uidseq = [%s]	 sock# %d
 %s(do_ack) freeing reply. state = as_replied & pkt->hdr.seq [%D] >= act->prev_seq [%D]
 %s(do_ack) Sorry, can't call free_reply.
 	act->state = %s  s.b. as_replied
 	pkt->hdr.seq = %D, act->prev_seq = %D  hdr.seq s.b >= prev_seq
 %s(do_fack) Not valid ahint in fack, ahint=%d
	uidseq = [%s]	sock# %d
 %s(do_fack) Anomalous fack ?  state=%s, act->prev_seq=%D  pkt->hdr.seq= %D
	uidseq [%s]	sock# %d
 
DUPLICATE FACK !! # %d, pkt seq # %D, last_frag_seq = %D
 pkt->hdr.fragnum = %d, act->last_fack_frag = %d
 act->re_fack in do_fack: %d
 do_fack SENDING PROTOCOL ERROR..
 %s(do_quit) NOT valid_ahint(pkt).. Indicate -NO CALL-
 %s(do_quit) NO CALL (i.e. no activity for this call)
	uidseq = [%s]	sock# %d
 %s(do_quit) send rpc_$quack.	sock # =%d
 %s(do_bad_pkt) Bad pkt, ptype=%s
	 uidseq [%s]	sock# %d
 %sTrash ahint (%u)  sock# %d
 %sTrash ihint (%u)  sock# %d
 %sServer boot time mismatch !!
 %sSending rejection on sock# %d
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %sptype != rpc_$request.
	Dispatching to routine:  %s  sock# %d
   dds ip ns unspec unspec ip ns dds %s:#%s %s:%s %s:#%s   sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat sys$scratch:last_uui                                                                                                                                                                                                                                                   %                        d $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          o "            d.dat %08lx%04x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x %8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx    (socket_inet/set interface broadcast address):  ioctl failed: status = %d
 ioctl failed: status = %x, %x, %x%x
 %W%  (ultrix) %G%                                                                                                                                                                                                                                                                                                                                                                                   i.;3    
     X
       "    %W%     (ultrix)        %G%                                                                     i.;3    
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ő;3    
     ޑ;3    
                                                                                                                     
      %W%     (ultrix)     %G%                                                                     i.;3    
                                          %W%     (ultrix)        %G%                                                                     i.;3    
                                                                       3;3    
     7  |;  ?  %W%     (ultrix)        %G%                                                                     i.;3    
                                                                       3;3    
         %W%     (ultrix)        %G%                     %W%     (ultrix)        %G%                                                                         v":3    
                                                                          96 @  
  f           rpc_client.c:  (alloc_socket)  (rpc_$sar)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      %W%     (ultrix)        %G%                                                                     v":3    
                                                                          96 @  
  f                --> SEND -->   <-- RCVE <--  rpc_util.c:                                                                                                                                                                                                        7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????   ??????  ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#@'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[???????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????0123456789|?????                                                                                                                            QX lX X X X X X Y 'Y ?Y XY %W%     (ultrix)        %G%                                                                     v":3    
                                                                          96 @  
  f                                                                                           %W%     (ultrix)        %G% %W%     (ultrix)        %G%                                                                     v":3    
                                                                          96 @  
  f                                                                                                                                                                   rpc_server.c:  rpc_server.c: (do_request)  rpc_server.c: (scan_activities)  rpc_server.c: (ping_common)  rpc_server.c: (do_ping)  rpc_server.c: (rpc_$int_listen_dispatch)  df f f f f f 
g 'g :g Og dg                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                &                        ĕ $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                           "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            g g g g g g g                         ,  L  L  L  L  L  x    8  L  %W%     (ultrix)        %G%                                                                      96 @  
  f        t   %W%     (ultrix)        %G%                                                                      96 @  
  f             
 H    %W%     (ultrix)        %G%         ܵ                                             %W%     (ultrix)        %G%                                     %W%     (ultrix)        %G%                                                                     v":3    
     (   %W%     (ultrix)        %G%                                                                     v":3    
     `c    + , %W%	VMS/ULTRIX Connection	%G%           %W%     (ultrix)        %G%                                                                                                     1 1 02 2 3 x4 $5 <5 6 6 87 7 7 (9 : (; %W%   (ultrix)  %G                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @  @   H  <  H                                     N      X'  '  @(  '  '  '  '  '  '  '  (  x(  p'  '  '  '  '  '  '  (  (  8(  0(  X(  ((  p(  h(  `(   (  P(  (  (  '  (   (  '  x'  h'  `'  H(         d  '      |      |    L         l  \  L  L    4  D  |  $  &      t    &  <     $           '                 
  ,
  8
  Z'  b'  j'  r'  z'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  (  
(  (  (  "(  *(  2(  :(  B(  R(  Z(  b(  j(  r(  z(  (  (  (        
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                 P       r v z ~       ė ȗ ̗ З ԗ ؗ ܗ   8 < @ D H L P T X \ ` 0 4 8 < @ D H d h l p t x |       
          ̳  0 & , ܵ                 *                  Ĺ ȹ ̹ й Թ ع ܹ                    $ ( , 0 4 8                                                                                                                                                                                                 ;     
RPC$LIBNCKRPC V1.1 1-JUL-1992 14:27 1-JUL-1992 14:27   VAX-11 Linker V05-05        	.$$ABS$$.        CLOSE_SOCKET       
SELECT_NCK      	UUID_$GEN       UUID_$ENCODE      UUID_$DECODE       UUID_$EQUAL       SOCKET_$VALID_FAMILY      SOCKET_$VALID_FAMILIES   P   
SOCKET_$EQUAL      SOCKET_$INQ_PORT      SOCKET_$SET_PORT      SOCKET_$SET_WK_PORT   X   SOCKET_$FAMILY_FROM_NAME   `   SOCKET_$FAMILY_TO_NAME   p   SOCKET_$FROM_NAME      SOCKET_$TO_NUMERIC_NAME      SOCKET_$TO_NAME     < SOCKET_$SET_BROADCAST       SOCKET_$MAX_PKT_SIZE      SOCKET_$INQ_MY_NETADDR      SOCKET_$INQ_NETADDR      SOCKET_$SET_NETADDR      SOCKET_$INQ_HOSTID      SOCKET_$SET_HOSTID   x   SOCKET_$INQ_BROAD_ADDRS      SOCKET_$TO_LOCAL_REP   h   SOCKET_$FROM_LOCAL_REP      | 
RPC_$REGISTER      | RPC_$REGISTER_MGR       RPC_$UNREGISTER      | RPC_$REGISTER_OBJ                                                                                                                                                                                                                                                   '                        Tc $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          Vb 
            ECT      SCAN_ACTIVITIES     < RPC_$LISTEN_DISPATCH        RPC_$SET_FAULT_MODE       < RPC_$INQ_OBJECT   8  | RRPC_$INQ_INTERFACES     < RPC_$CVT_SHORT_FLOAT     < RPC_$CVT_LONG_FLOAT   (    RPC_$USE_FAMILY   0    RPC_$USE_FAMILY_WK     < RPC_$LISTEN_RECV     | RPC_$FORWARD       RPC_$LISTEN       
RPC_$SHUTDOWN        RPC_$ALLOW_REMOTE_SHUTDOWN   H   RRPC_$SHUTDOWN   @    RRPC_$INQ_STATS   x  < RPC_$MALLOC   p    	RPC_$FREE   `    RPC_$ALLOC_PKT       
RPC_$FREE_PKT      RPC_$CVT_STRING    h    RPC_$BLOCK_COPY   (  | RPC_$STATUS_PRINT      RPC_$DUMP_STATS        RPC_$ALLOC_HANDLE       RPC_$SET_BINDING       RPC_$INQ_BINDING       RPC_$CLEAR_SERVER_BINDING       RPC_$CLEAR_BINDING       	RPC_$BIND       RPC_$SET_SHORT_TIMEOUT       RPC_$SET_ASYNC_ACK        RPC_$FREE_HANDLE        RPC_$DUP_HANDLE      RPC_$SAR        RPC_$NAME_TO_SOCKADDR       RPC_$SOCKADDR_TO_NAME   `     	PFM_$INIT   8     
PFM_$_CLEANUP   p     PFM_$_RLS_CLEANUP   h     PFM_$_RESET_CLEANUP   P     PFM_$INHIBIT   @     PFM_$ENABLE   X    PFM_$INHIBIT_FAULTS   H     PFM_$ENABLE_FAULTS   x    PFM_$SIGNAL      < 	PGM_$EXIT   H  < LLB_CA_$INSERT   8  < LLB_CA_$DELETE   (   < LB_$REGISTER   0     LB_$UNREGISTER        LB_$LOOKUP_RANGE        LB_$LOOKUP_OBJECT        LB_$LOOKUP_OBJECT_LOCAL         LB_$LOOKUP_TYPE         LB_$LOOKUP_INTERFACE        LB_$USE_SHORT_TIMEOUTS      LB_$PROCESS_ARGS_I   X   GLB_CA_$GET_SERVER_ADDRESS   P   GLB_CA_$SET_SERVER_ADDRESS   @    GLB_CA_$INSERT   0    GLB_CA_$DELETE     | 
ERROR_$C_TEXT    RRPC_$MANAGER_EPV    RRPC_$SERVER_EPV    RRPC_$CLIENT_EPV    	UUID_$NIL    RPC_$LOCAL_DREP    RPC_$ASCII_TO_EBCDIC   @ RPC_$EBCDIC_TO_ASCII    
RPC_$DEBUG    
RPC_$LOSSY    LLB_$CLIENT_EPV   r GLB_$CLIENT_EPV                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * [B]RPC$LIBNCK.OLB;1 +  , :   .    /    4                           - E9    0   1    2   3      K  P   W   O    5 7  6  i0i  7 -Ε  8          9          G   H  J                              %
   VAX-11 Librarian V04-00         }i Ε !          "             2                    *     8   c   C                                                                                                                                                                                                                                                                                                                                                                                          n    ANOMALOUS_FACKSn    AS_IN_REPLY_PINGSn    BAD_FACK_FRAGNUMSn    CLIENT_PROTOCOL_ERRORS6   CONV_$CLIENT_EPV1   CONV_$MANAGER_EPV1   CONV_$SERVER_EPV9    CONV_$WHO_ARE_YOU   DAYLIGHTn    
DROPPED_FRAGSn    
DROPPED_PINGSn    DUPLICATE_FACKSn    DUPLICATE_PINGS   ERROR_$C_GET_TEXT   
ERROR_$C_TEXT   ERROR_$FIND_TEXT   ERROR_$FIND_TEXT_STATICn    EXCESSIVE_RETRANSMITS GETTIMEOFDAYn    HIGHER_NUMBERED_PINGSn    INVALID_ACK_AHINTSEND_SEQ_NMBRLE &          6   
CONV_CSTUB1   
CONV_SSTUB   ERROR3    FLOAT   GLB`   	GLB_CSTUB#   LB+   LLBN   	LLB_CSTUB9    
RPC_CLIENT    RPC_LSN
   RPC_SEQn    
RPC_SERVER~   RPC_UTIL:   
RRPC_CSTUBF   
RRPC_SSTUB    SOCKETr   SOCKET_INET    UUID    U_PFM   VMS                                                                                                                                                                                                                       ~   RPC_$PERIODICALLY~   
RPC_$PKT_NAME~   RPC_$REASSEMBLE_FRAG_LIST~   
RPC_$RECVFROMn    
RPC_$REGISTERn    RPC_$REGISTER_AUTHTYPE~   RPC_$REGISTER_ENCRTYPEn    RPC_$REGISTER_MGRn    RPC_$REGISTER_OBJECT9    RPC_$SAR~   RPC_$SENDTO~   RPC_$SEQn    RPC_$SERVER_TO_CLIENT_HANDLE9    RPC_$SET_ASYNC_ACK9    
RPC_$SET_AUTHn    RPC_$SET_AUTH_LOGGER9    RPC_$SET_BINDINGRPC_$SET_PKT_BODY_STn    RPC_$SET_SERVER_ENCR9    RPC_$SET_SHORT_TIMEOUTSn    
SERVER_FAULTS             EXCESSIVE_RETRANSMITS   INVALID_ACK_AHINTS   LAST_RESEND_SEQ_NMBR   
NO_CALLS_SENT   PFM_$FAULT_INH_COUNT   PFM_$_RESET_CLEANUP   PKT_HANDLER_NAMES   RPC_$ALLOC_LINKED_PKT   RPC_$CLEAR_BINDING   RPC_$GET_HANDLE   RPC_$NAME_TO_SOCKADDR   RPC_$SET_BINDING   RPC_$SET_SHORT_TIMEOUT   RRPC_$CLIENT_EPV   
SERVER_FAULTS
   SERVER_RCVD_BAD_OPNUM	   SOCKET_$MAX_PKT_SIZE   SOCKET_$TO_NAME
   	_FINDCHAN                                         n    RPC_$GET_MY_ACTIVITY~   RPC_$GET_PKT_BODY_ST9    
RPC_$INQ_AUTH9    RPC_$INQ_BINDING9    
RPC_$INQ_ENCRn    RPC_$INQ_OBJECT9    RPC_$INQ_OBJECT_CLIENTn    RPC_$INQ_SAUTHn    RPC_$INQ_SERVER_ENCR~   RPC_$INSERT_IN_FRAG_LISTn    RPC_$INT_LISTEN_DISPATCH    RPC_$LISTENn    RPC_$LISTEN_DISPATCH    RPC_$LISTEN_RECV~   RPC_$LOCAL_DREP~   RPC_$LOCAL_DREP_PACKED~   	RPC_$LOCK~   
RPC_$LOSSY~   RPC_$MALLOC~   RPC_$MAX_DEBUG9    RPC_$NAME_TO_SOCKADDR            9    RPC_$CLEAR_SERVER_BINDING3    RPC_$CVT_LONG_FLOAT3    RPC_$CVT_SHORT_FLOAT~   RPC_$CVT_STRING~   
RPC_$DEBUG~   RPC_$DIE~   RPC_$DUMP_PKT_HDR~   
RPC_$DUMP_RAW~   RPC_$DUMP_RAW_PKT~   RPC_$DUMP_STATS9    RPC_$DUP_HANDLE~   RPC_$EBCDIC_TO_ASCII~   
RPC_$ENCR_RGY~   RPC_$FILL_FRAG    RPC_$FORWARD~   	RPC_$FREE~   RPC_$FREE_FRAG_LIST9    RPC_$FREE_HANDLE~   RPC_$FREE_LINKED_PKT~   
RPC_$FREE_PKTn    RPC_$GET_CALLERS_ADDR9    RPC_$GET_HANDLE         n    LAST_RETRANSMIT_SEQ_NMBR#   LB_$LOOKUP_INTERFACE#   LB_$LOOKUP_OBJECT#   LB_$LOOKUP_OBJECT_LOCAL#   LB_$LOOKUP_RANGE#   LB_$LOOKUP_TYPE#   LB_$PROCESS_ARGS#   LB_$PROCESS_ARGS_I#   LB_$REGISTER#   LB_$UNREGISTER#   LB_$USE_SHORT_TIMEOUTSN   LLB_$CLIENT_EPV+   LLB_CA_$DELETE+   LLB_CA_$INSERT+   LLB_CA_$LOOKUP+   LLB_CA_$SET_SHORT_TIMEOUTn    
NO_CALLS_SENT  
NO_CALLS_SENT_$ENABLE   PFM_$ENABLE_FAULTS   PFM_$FAULT_INH_COUNTAR_BINDING           n    SERVER_RCVD_BAD_PACKETSn    SERVER_RCVD_INAPP_RQSTn    SERVER_REJECTIONS_SENTn    SERVER_TRASHED_AHINTSn    SERVER_TRASHED_IHINTSr   SKIP_IF_CLUSTER    
SOCKET_$EQUAL    SOCKET_$FAMILY_FROM_NAME    SOCKET_$FAMILY_TO_NAME    SOCKET_$FROM_LOCAL_REP    SOCKET_$FROM_NAME    SOCKET_$INQ_BROAD_ADDRS    SOCKET_$INQ_HOSTID    SOCKET_$INQ_MY_NETADDR    SOCKET_$INQ_NETADDR    SOCKET_$INQ_PORT    SOCKET_$MAX_PKT_SIZE  SOCKET_$TO_NAMEDELTAS                          n    SERVER_IGNORED_OLD_REQUESTn    SERVER_IMPLICIT_ACKS_DETECTEDn    SERVER_PROTOCOL_ERRORSn    SERVER_RCVD_BAD_BOOT_TIMEn    SERVER_RCVD_BAD_OPNUM                                                                                                                                                                                                                                                                                                                                                      P             
RPC_$SHUTDOWN9    RPC_$SOCKADDR_TO_NAMEn    RPC_$START_ACTIVITY_SCANNER~   
RPC_$STATS~   RPC_$STATUS_PRINT~   RPC_$STOP_PERIODIC~   RPC_$SWAB_HEADER~   RPC_$TERMINATION_FAULT~   RPC_$UNLOCKn    RPC_$UNREGISTER    RPC_$USE_FAMILY    RPC_$USE_FAMILY_WK    RRPC_$ARE_YOU_THERE:   RRPC_$CLIENT_EPVn    RRPC_$INQ_INTERFACES    RRPC_$INQ_STATSF   RRPC_$MANAGER_EPVF   RRPC_$SERVER_EPV    RRPC_$SHUTDOWNn    SCAN_ACTIVITIESn    
SERVER_FAULTS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       (                        # $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "                      9    
RPC_$SET_ENCRn    RPC_$SET_FAULT_MODE~   RPC_$SET_PKT_BODY_STn    RPC_$SET_SERVER_ENCR9    RPC_$SET_SHORT_TIMEOUT                                                                                                                                                                                                                                                                                                                                                                                                SOCKET_$TO_NUMERIC_NAME    SOCKET_$VALID_FAMILIES    SOCKET_$VALID_FAMILY   TIMEZONEn    UNFREED_REPLIES    	UUID_$CMP    UUID_$DECODE    UUID_$ENCODE    UUID_$EQUAL    	UUID_$GEN    
UUID_$HASH~   	UUID_$NILn    ZERO_DELTAS   	_FINDCHAN                                                                                                                                                                                                                                            SOCKET_$SET_BROADCAST    SOCKET_$SET_HOSTID    SOCKET_$SET_NETADDR    SOCKET_$SET_PORT    SOCKET_$SET_WK_PORT    SOCKET_$TO_LOCAL_REP    SOCKET_$TO_NAME                                                                                                                                                                                                                                                                                                                                             ~   RPC_$ALLOC_PKT    RPC_$ALLOW_REMOTE_SHUTDOWN~   RPC_$ASCII_TO_EBCDIC9    	RPC_$BIND~   RPC_$BLOCK_COPY9    RPC_$CLEAR_BINDING                                                                                                                                                                                                                                                                                                                                                                              n    REPLIES_DROPPEDn    RESENT_REPLIESn    RETRANSMITSn    RETRANSMITS_SUPPRESSED9    RPC_$ALLOC_HANDLE~   RPC_$ALLOC_LINKED_PKT                                                                                                                                                                                                                                                                                                                                                                                n    INVALID_DO_QUIT_AHINTSn    INVALID_FACK_AHINTSn    INVALID_HANDLESn    LAST_PING_SEQ_NMBRn    LAST_REQUEST_NMBRn    LAST_RESEND_SEQ_NMBR                                                                                                                                                                                                                                                                                                                                                                    n    
FACKS_RCVDn    FACK_REPLIES   FFSn    
FREED_PASSIVE   GETTIMEOFDAY`   GLB_$CLIENT_EPV   GLB_$DEFAULT_OBJ   GLB_$DEFAULT_TYPE   GLB_$HANDLE   
GLB_$TYPE_UID   GLB_$UID   GLB_CA_$DELETE   GLB_CA_$GET_OBJECT_UUID   GLB_CA_$GET_SERVER_ADDRESS   GLB_CA_$INSERT   GLB_CA_$LOOKUP   GLB_CA_$SET_SERVER_ADDRESS   GLB_CA_$SET_SHORT_TIMEOUTn    HIGHER_NUMBERED_PINGSr   INET_$SOCKET_HANDLERn    INVALID_ACK_AHINTS                                    PFM_$_RLS_CLEANUP    	PGM_$EXITn    
PINGS_RCVD9    
PINGS_SENT~   	PKTS_RCVD~   	PKTS_SENTn    PKT_HANDLER_NAMES                                                                                                                                                                                                                                                                                                                                                                                  }              PFM_$INHIBIT    PFM_$INHIBIT_FAULTS    	PFM_$INIT    PFM_$SIGNAL    
PFM_$_CLEANUP    PFM_$_RESET_CLEANUP                                                                                                                                                                                                                                                                                                                                                                                                 ~   OLD_ALARM_HANDLER9    
OLD_PKTS_RCVD~   PFLAGS~   PFLAGS2    PFM_$ENABLE    PFM_$ENABLE_FAULTS    PFM_$FAULT_INH_COUNT                                                                                                                                                                                                                                                                                                                                                                                 n    RRPC_$INQ_INTERFACES    RRPC_$INQ_STATSF   RRPC_$MANAGER_EPVF   RRPC_$SERVER_EPV    RRPC_$SHUTDOWNn    SCAN_ACTIVITIESn    
SERVER_FAULTSRn    
SERVER_FAULTS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             )                        >ƃ $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         ( "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  *                        af $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         > "     .       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                4   1       @9Li V1.0                            2     FLOATV1.0 3-APR-1991 08:30                   VAX C V3.1-051  P%W%     (ultrix)        %G%  P ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPʏPxPPPQQ<PP
޼P `Z<PP   ޼P `CP޼R<PPPxPPPQ<PPxPPPQPPQbPQ`ЬR  PRPbP ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬP 5   PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPPPxPPPPPQЬPPPPxPPPPPQQ<PPO޼TЬSЬRЬQP `> P<`PPQPQ`>P<`PPQPQ`>P<`PPQdPQ`1 P<RR   K޼QЬPЬTЬSR b>R<bRRSRSb>R<bRRSRSb>R<bRRSaRSbg޼T<RRRxRRRS<RRxRRRSRRSdRSbЬR  SRSbЬTRRSRSbЬR  SRSb  ^ެPPPQQPP P	?P1ެPPPQQPP  P?P1PPPPyIЬPЬPЬP 6   ЬPЬPЬPЬP޼P`#ЬPЬPЬP޼P`ޭPPݬݬ3ݬݬ71 QQJ  R    FLOAT      ieee32_to_vaxf         ieee64_to_vaxg       	cvt_float       rpc_$cvt_short_float &       rpc_$cvt_long_float *   		     y   o&         #   		   
CC$_GFLOAT  RPC_$LOCAL_DR 7   EP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  ABORT 
    < RPC_$CVT_SHORT_FLOAT 
    < RPC_$CVT_LONG_FLOAT  &  $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRONQPPPQP%޼Q޼PP`a
P޼Q޼PP`a1 Pk޼QЬPaЬQ޼P`ЬQЬPЬQЬPЬQЬPЬQЬPЬQЬPЬQЬP5P޼QЬPaЬQ޼P`ЬQЬPЬQЬP  ABORT  ABORT  ABORT       ABORT  ABORT< ^ ݬݬ^(n^(nP< ^ݏ   ݬݬ^(n^(nϧ 
P   P          w w                                                                                                                                                                                                                                                                                                                                                                         5     ^i  SUKONNIK    FLOAT# i  SUKONNIK    
RPC_CLIENT# `5i  SUKONNIK    
RPC_SERVER  h]i  SUKONNIK    RPC_LSN! gi  SUKONNIK    RPC_UTIL @i  SUKONNIK    SOCKET bi  SUKONNIK    UUID `Zi  SUKONNIK    U_PFM  
i  SUKONNIK    VMS   pi  SUKONNIK    RPC_SEQ i  SUKONNIK    ERROR msi  SUKONNIK    GLB >$i  SUKONNIK    LB  >c>i  SUKONNIK    LLB# sUKi  SUKONN :   1       /i V1.0                            7     
RPC_CLIENTV1.0 3-APR-1991 08:31                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$DEBUG  RPC_$MAX_DEBUG  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCI ;   I  
RPC_$STATS  
RPC_$DEBUG  
RPC_$LOSSY 
    
PINGS_SENT 
    
OLD_PKTS_RCVD   P%W%     (ultrix)        %G% P   dP v":3nP
qP P 96 @ P
 Pf Prpc_client.c:  P(alloc_socket)  P(rpc_$sar) eP PNAPERROR	P%*.s[%lu]P%s%sgave out socket index %d from pool
;PRan out of socketsNPRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7rP%s%smaking a new socket. None left in pool.
 P%s%ssocket() got sock #: %d
 P%s%sCan't create socket, er <   rno=%d
 Prpc_client.c P%s%sCan't bind socket #%d, errno=%d
P%s%si = %d, nsockets = %d.
	Marking this socket in use..
KP%s(free_socket) set sock->inuse = false. sock # was: %d
P%s%s
P%s(send_pkt) cannot enable broadcast, status = %08lx
PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7Prpc_client.cP%s(send_pkt) cannot enable broadcast, errno=%d
!PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7EPRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7iP%s(c_recv_pkt) Rcvd callback (ptype=%s)
 =   PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7P%s(c_recv_pkt) This packet IS NOT for my activity ??
P
%s(c_recv_pkt) IGNORING OLD PKT..  pkt->hdr.seq #: %d, current seq #: %d, old_pkts_rcvd: %ld

LP%s(c_recv_pkt) Rcvd packet with bad seq (should be %lu, is %lu; ptype=%s)
PCan't register callPRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7P
%swho_are_you says you crashed..

PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7P%s(ack_replies) Acking [%s, %lu]
9Prpc_client.cFP%s(ack_repl >   ies) Can't send ACK, errno = %d
rPRPC reply acknowledgerP%s%s
P%s%s
P%s%s
P%s%s
P%s%s
P
BAD TIMEOUT !! = %d  || end_time ? = %D  forcing to 5..
PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7P%s(await_reply) case 0 timeout..
'P%s(await_reply) select failure .. errno = %d
UPrpc_client.cbP%s(await_reply) select returned junk, errno=%d
P"rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
Pmispacked header stuff messed upPRPC$:[NC ?   K_D.LIBNCK_D]RPC_CLIENT.C;7P
%s%ssees NO COOKIE !?

2P%s%sRaising comm_failure. We have no family ?
  aP%s%sSignaling args_too_big !.. ilen = %d, rpc_$max_body_size = %d
P%s%ssockaddr has specified port..
P%s%sinterface has no specified port.
	Setting to well known port..
P%s%ssetting port to interface defined port
7PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7[P%s%s
aP%s%scan't get encr, status=%08lx
P%s%sRequest Count:  %D
P%s%sRAISING COMM_FAILURE !!  Requ                                                                                                                                                                                                                                                   +                        | $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         [ "     ?        @   est_count > MAX_REQUESTS
	request_count = %d, MAX_REQUESTS %d
P%serror sending !large_in pkt..
P%sError send ing frag pkt..
8P! recv_pkt .. request_count = %d, wait_count = %d
kP%s%sforcing wait_time of %D to 64..
P%s ?? GOT rpc_$fault || rpc_$reject..
P%s%sAnomolous response to request (ptype=%s)
P%s%sawait_timeout detected..
	P%s%sraising comm_failure because of an await_timeout on broadcast..
	We've retried MAX_BROADCASTS times..
n	P%sawait timeout whilst  A   sending_frags.. request_count = %d
	P%s%sStarting to ping...
	P%s%sawait select failure
	Prpc_client:	Pselect  failed	PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7
P%s%sawait unknown error occured..
=
Prpc_client.cJ
Pselect failedX
PRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7|
P%s%sRAISING COMM_FAILURE --> TOO MANY PINGS !!

P%s%ssleeping.. now = %ld

P%s%sawake !!   now = %ld

P%s%spwait_time = %D, ping_count = %d, total pings = %D
P%s%strying to raise comm_fail B   ure.. pfm_$fault_inh_count = %d
VP%s got rpc_$fault || rpc_$reject whilst pinging.. request_count = %d
P%s%sAnomolous respons  PFM_$FAULT_INH_COUNT  RPC_$FREE_HANDLE  RPC_$CLEAR_BINDING  RPC_$CLEAR_SERVER_BINDING  RPC_$SET_BINDING  RPC_$ALLOC_HANDLE  	RPC_$FREE  RPC_$MALLOC  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$FILL_FRAG  RPC_$STOP_PERIODIC  RPC_$PERIODICALLY  RPC_$REASSEMBLE_FRAG_LIST  RPC_$INSERT_IN_FRAG_LIST  RPC_$SENDTO  
RP C   C_$RECVFROM  RPC_$GET_PKT_BODY_ST  RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$DIE   RPC_$GET_CALLERS_ADDR  RPC_$SERVER_TO_CLIENT_HANDLE  RPC_$GET_MY_ACTIVITY  RPC_$INQ_SERVER_ENCR  RPC_$SET_SERVER_ENCR  UUID_$EQUAL  UUID_$ENCODE  RPC_$LISTEN_DISPATCH  RPC_$FREE_HANDLE  RPC_$CLEAR_BINDING  
RPC_$REGISTER  SOCKET_$INQ_BROAD_ADDRS  SOCKET_$MAX_PKT_SIZE  SOCKET_$TO_NUMERIC_NAME  SOCKET_$TO_NAME  SOCKET_$FROM_NAME  SOCKET_$SET_WK_PORT   D   SOCKET_$SET_PORT  SOCKET_$INQ_PORT  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP e to ping (ptype=%s)
P%s%sawait_timeout.. going to SEND_PING
Pselect failedPRPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7!P%s%sRcvd "working" during frag send!
GP%s%sRcvd "working" pkt; seq=%lu
hP%s%sGot "fack" for non-large request!
P%signoring old fack..
P%s%sGot non-frag "response" during frag recv!
P%sError sending frag response..
  P ^ R S 
RPC_$DEBUGbPPP`P E   d   ߭߭߭ݬݬ SOCKET_$TO_NUMERIC_NAMEխޢPPP'Pݭ߭ ݭߢ	Î 
VAXC$GSPRINTFÎPPPP ^ S R޼P ` k<P	P@fPPCЭPѠ8 
RPC_$DEBUG
 RPC_$MAX_DEBUG<PP  ߣ VAXC$GPRINTFЭPPP<PP@   ݏZ  ߣNߣ; RPC_$DIE 
RPC_$DEBUG
 RPC_$MAX_DEBUG  ߣr VAXC$GPRINTF ݬ SOCKETP 
RPC_$DEBUG
 RPC_$MAX_DEBUGݭ  F    ß  VAXC$GPRINTFխA 
RPC_$DEBUG
 RPC_$MAX_DEBUG P   ü  VAXC$GPRINTF޼PЏ ` P  MEMSETݭ BINDP[  PERROR 
RPC_$DEBUG RPC_$MAX_DEBUG#P ݭ    VAXC$GPRINTFݭ CLOSE_SOCKET޼PЏ ` Pݭ SET_SOCKET_NON_BLOCKING߰QPP<QP	P@fPP 
RPC_$DEBUG
 RPC_$MAX_DEBUG%<PP<PP   VAXC$GPRINTFאЭPЭЭP<QPQ` G   P ^ S R 
RPC_$DEBUG
 RPC_$MAX_DEBUGPЬPݠ K  VAXC$GPRINTF޼P   | ^ V <RR 1 P, 	UUID_$NIL<R.RBƦ UUID_$EQUALؕP
<RRRRPЬR(<R.RBƦ UUID_$EQUALP0ЬS<R.RBRѣ@b<T.TЬRޢ@SDRcbRR<RR 1g1 2S.SЬR((CƦ2T.TЬRޢ@SDRcb2T.TЬR>HSDRcb2T.TЬRޢ8SDRcbЬRRR2R.RBƶRRR2R.RBƶRbS޼Rbc޼Rb<R H   R/ЭTRRЭSRRcdRR<RR 8^ W V xt  RPC_$UNLOCK啬&ݬݬݬЬRݢ RPC_$SENDTOːPc1*P_x|c_޼RbЬR SOCKET_$INQ_PORTPЬR>R<bRR SOCKET_$INQ_BROAD_ADDRS_wݏd    ^(_n 
ERROR_$C_TEXT  Ǆ VAXC$GPRINTF 
RPC_$DEBUG
 RPC_$MAX_DEBUGP_ Ǌ VAXC$GPRINTFݏ"    	RPC_$LOCK P  t ݏ  ЬRݢ 
SETSOCKOPT I   PppS PERROR 
RPC_$DEBUG
 RPC_$MAX_DEBUGP     VAXC$GPRINTFݏ,  !  	RPC_$LOCK P c f<fRRx1 <fRRBcRRlORRhKS<fRB|Rbc<fRB|R>bRbd<dRR7hThRRhlSlRRlcddRRd<dRRݬKݬЬRݢ RPC_$SENDTOˈcPPcfRRf<fRRx1=ݏ8  E  	RPC_$LOCKcRRP ^ W Vݬ ݬݬЬRݢ 
RPC_$RECVFROMPխ P޼RbЬR J   ( UUID_$EQUALǐPЬRRRRRЬRRRRR1 fЬR UUID_$EQUALP1   RPC_$UNLOCKЬRѢ@ƈЬR@RRƈ 
RPC_$DEBUG RPC_$MAX_DEBUG+PЬRRRRR 
RPC_$PKT_NAMEP i VAXC$GPRINTFݭ޼ RbݬЬRݢ RPC_$LISTEN_DISPATCHݏ  ǒ  	RPC_$LOCK P' 
RPC_$DEBUG
 RPC_$MAX_DEBUG Ƕ VAXC$GPRINTF PЬRѢ@1 ЬRѢ@B RR  
RPC_$DEBUG RPC_$MAX_DEBUG#  K   ݬЬRݢ@  VAXC$GPRINTFI 
RPC_$DEBUG RPC_$MAX_DEBUG7PЬRRRRR  
RPC_$PKT_NAMEPЬRݢ@ݬ L VAXC$GPRINTF PЬRբ>&ЬSЬRѣ>8Џ ^(n PFM_$SIGNALRRRЬRRR޼RbSRbcRb<RR0PЭTRRЭSRRcdRR<RRЏ   P ^ W V <RR s<RRBf	S<RRBf	<SS޼R(bCg	<RRBw	RЬb<RRB{	RЬb<RRBf	RRPRR<RR ݏ  ǫǗ R L   PC_$DIE ^ R <PP SP<PP@f	0޼P`<PP@g	 UUID_$EQUALP<PP@f	PP PPP<PP 2  P ^ S R޼P `ݬiPխ޼PЏ `ЭPРPՠ>ЭPРP>PЬ`BЭPРPѠ>2 
RPC_$DEBUG
 RPC_$MAX_DEBUGP  VAXC$GPRINTF޼PЏ	 `޼QЭPޠPР     ^ݬPխ޼PЏ ` ޼P `ЭPРP< ^ݏP    ݬ MEMSETЬR RPC_$LOCAL_DREP_PACKEDЬR RPC_$LOCAL_DREP_PACKED   M    3ЬR RPC_$LOCAL_DREP_PACKED   3ЬR RPC_$LOCAL_DREP_PACKED   3ޢ޼RbЬRFRbЬRHR bլ
ЬS޼R(bP l^ V W \ݏd    	RPC_$LOCK۰ <RR 1UP<R.RB̦RR 	UUID_$NIL UUID_$EQUALP1Pu UUID_$ENCODE 
RPC_$DEBUG RPC_$MAX_DEBUG PЭRݢ$u  VAXC$GPRINTFЭR>R<bRRPխ1 P ϜRЭRޢ*SRcb(ЭR>(SRcbЭRޢ$SRcb   N   RݭP29 PERROR 
RPC_$DEBUG
 RPC_$MAX_DEBUGg F VAXC$GPRINTFݭ(  	UUID_$NILRR<RR 1  RPC_$UNLOCKP ^ S Rcc CONV_$SERVER_EPV  
RPC_$REGISTERݕ#ddr
PP RPC_$PERIODICALLYP  ^޼P `ݏ    RPC_$MALLOCPP ЭPPЏ`ЭPlP`ЭPZP`ЭPVP`ЭPjP `ЭP  ЭP  լЭPjQjPQ`ݬЭPݭ RPC_$C O   LEAR_BINDINGP ^Ьݬݬ RPC_$CLEAR_BINDINGЬЭPZPPЭPVPЬ`<PP/ЭRPPЭQPP  PFM_$ENABLE  PFM_$INHIBIT  PFM_$SIGNAL  
VAXC$GFPRINTF  VAXC$GPRINTF  
VAXC$GSPRINTF  PERROR  MEMSET  SETJMP  SLEEP  
SETSOCKOPT  BIND  SOCKET  SET_SOCKET_NON_BLOCKING  CLOSE_SOCKET  
ERROR_$C_TEXT  
ERROR_$C_TEXT  
ERROR_$C_TEXT  
ERROR_$C_TEXT  
SELECT_NCK  TIME  
SELECT_NCK  TIME  
ERROR_$C_TEXT 
  L  P     CONV_$WHO_ARE_YOU 
      RPC_$GET_HANDLE 
      RPC_$ALLOC_HANDLE 
  l   RPC_$SET_BINDING    R    
RPC_CLIENT      sastring         alloc_socket p      free_socket L     D  
update_ack_db       send_pkt     |  
c_recv_pkt     ,
  
register_call      
  	find_call s     L  conv_$who_are_you        rpc_$get_handle ?     8  init_hdr ~       ack_replies     \                                                                                                                                                                                                                                                     ,                        GJG $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         uW "     P        Q   init ^       rpc_$alloc_handle      l  rpc_$set_binding      (  rpc_$inq_bindingĭabRR<RRЭRjPjRPbݬЭRݢVЭRZ SOCKET_$INQ_PORTPЭRjPjRPb޼R    ^ЬЭPѠ1 ЭP>jP<`PʏPP޼PЏ `ЭPZPPЬ޼QЭPޠVP`aЭP>VP`<PP1PЭRPPЭQPPabRR<RRݬݬݬ RPC_$GET_CALLERS_ADDR޼R  < ^Ь޼SЭR(c޼R   ^ W VЬݬ  R   RVЭRZ SOCKET_$SET_PORT޼Rb4ݏd    ޼R^(bn 
ERROR_$C_TEXT  ǉ VAXC$GPRINTFЭRjSjRSbЭR>R bЭRLRbЭRNRb޼R   ^ W VЬݬݬ RPC_$CLEAR_SERVER_BINDING޼Rb4ݏd    ޼R^(bn 
ERROR_$C_TEXT  Ǐ VAXC$GPRINTFЭRjSjRSb޼R   $^ W VѬ޼RЏ bݬ޼R<bRRݬ RPC_$ALLOC_HANDLEP޼Rb
խ7Pݏd    ޼R^(bn 
ERROR_$C_TEXT  S    Ǖ VAXC$GPRINTF޼Rbݬݬݬݭ RPC_$SET_BINDING޼Rb}ݏd    ޼R^(bn 
ERROR_$C_TEXT  Ǜ VAXC$GPRINTFݭ RPC_$FREE_HANDLEխ1ݏd    ^(n 
ERROR_$C_TEXT  ǡ VAXC$GPRINTF P  ^ЬЭP>jP<`PʏPQPQQլЭPjQjPQ`ЭPjQjPQ`޼P `PPP  ^ QPլPPe  ^Ь޼P `ЭQlPPl>lP<`PPxЭPPЏ`ЭP ЭP ЭPЄ P`PްP`ЭP  Э T   P ЭP ЭPЀ P`PްP`ЭP  ݭ 	RPC_$FREEP  ^Ь޼P `ЭQlPPlЬP| 8^   U V  TIMEPRRR  RPC_$UNLOCKլ	խCP 
RPC_$DEBUG RPC_$MAX_DEBUGPݭݬŧ VAXC$GPRINTF  TIMEPRRRЬ   MEMSETЬR STЬRz  P{ PQPPRxRRCdRRCd  ЬRRR 
SELECT_NCKP ݏ@    	RPC_$LOCKЭPP PP.?P1  P 
RPC_$DEBUG RPC_ U   $MAX_DEBUGP  VAXC$GPRINTFPѭ9 
RPC_$DEBUG
 RPC_$MAX_DEBUGP  '  VAXC$GPRINTFU PERROR  TIMEPRRѭPPíRR1cP b  
VAXC$GFPRINTF2 P< ^ SR SETJMPPDRݢD 
PFM_$_CLEANUPѭ 1\  PFM_$ENABLE޼R(P bRRRR b   MEMSETЬR STЬRz  P{ PQPPRxRRCdRRCd <RR1 ЬR  ݬR V   ݬb  ЬRRR 
SELECT_NCKPj߭ݬzݭݏT   ݬݬϬP<RRRRR
'RRRRRRRRRRPPRR<RR1; PFM_$_RLS_CLEANUP  PFM_$INHIBIT
P  PFM_$INHIBIT ^ W V ? 
RPC_$DEBUG
 RPC_$MAX_DEBUG-P  ǒ VAXC$GPRINTFݏ   RPC_$DIEЬЬ Э  ͳ Ͳ  Ԑ    ͠ͼSͼR SETJMPPDͼͼRݢDd W    
PFM_$_CLEANUPd͸͸ 1 ݭݭݭݭOխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb խ խ	ݭ]ͳݬ4ݭ RPC_$FREE_HANDLEͲ
  RPC_$UNLOCK^(͸n PFM_$SIGNALЬRޢRbѭȏ*Ь RPC_$GET_MY_ACTIVITYƈSƈRRƈS1 Pѭȏ
 >ݬ4߭ݬ RPC_$SERVER_TO_CLIENT_HANDLEP޼4Rb޼4R^(bn PFM_$SIGNALͳ@ 
RPC_$DEBUG RPC_$MAX_DEBUGP  X     VAXC$GPRINTF͛^(͛n PFM_$SIGNALЭЭR>jR<bRʏRRA 
RPC_$DEBUG
 RPC_$MAX_DEBUG  2 VAXC$GPRINTFЏ ͗^(͗n PFM_$SIGNALѬM 
RPC_$DEBUG RPC_$MAX_DEBUG"ݏݬ  a VAXC$GPRINTFЏ ͓^(͓n PFM_$SIGNAL޼$RЭb޼0R b޼(R b޼4R b Ͱݬ4ЭR>ZR<bRR SOCKET_$MAX_PKT_SIZEP   PPؐ  ЭR>jR<bRʏRSRSSˏRRݬ4ݬ RPC_$CLEAR_BINDINGݬ4Э Y   RݢVЭRZ SOCKET_$INQ_PORTP: 
RPC_$DEBUG
 RPC_$MAX_DEBUG  Ǥ   VAXC$GPRINTFЭRVRR1+PЭRVRRRRRRRbSЭRVRbcЭRVRb<RR.ЭTRRЭSRRcdRR<RR>R<bSЬR<CRRE 
RPC_$DEBUG
 RPC_$MAX_DEBUGP   VAXC$GPRINTFݬ4  SOCKET_$SET_WK_PORTS 
RPC_$DEBUG RPC_$MAX_DEBUGP   VAXC$GPRINTFݬ4>R<bSЬR<CRR SO Z   CKET_$SET_PORTRRݏ  7  	RPC_$LOCK쐏ͲЭR. UUID_$EQUALPЭR(.ЭRNRbЬRFЭR UUID_$EQUALPЭS޼RѣBb-PЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЭSRRRRRRѬRRЭR>jR<bRʏRRЭS`RRRRRRˏRRЭS0RRRRRRˏRRЭS RRЭR 1 1 1 ЭR .ЭSݬ4ݬЭR  [   RҀ R޲ R޲ RbPÄ ޼4Rbpd    ݬ4 
ERROR_$C_TEXT  [ VAXC$GPRINTF  
RPC_$DEBUG RPC_$MAX_DEBUGP޼4Rb  a VAXC$GPRINTF޼4R^(bn PFM_$SIGNALЭR ЭR҄ RbRâRRؕЏ ͏^(͏n PFM_$SIGNALRRRRRaݬ4ЭR>R<bRRvP޼4Rb޼4R^(bn PFM_$SIGNALЭRݢ@ݭPԕ 
RPC_$STATSRR 
RPC_$STATS   
RPC_$DEBUG
 RPC_$MAX_DEBUG <RRR  \    ǃ VAXC$GPRINTF<RRSRR<SRRQ 
RPC_$DEBUG RPC_$MAX_DEBUG%P<RRR  Ǜ VAXC$GPRINTFЏ ͋^(͋n PFM_$SIGNALΐ\ЭR RRݭݭݭϧP' 
RPC_$DEBUG RPC_$MAX_DEBUG  VAXC$GPRINTF11 ͱ1
 <SЭR>LR<bRRS 
RPC_$STATSh   3S 
RPC_$STATSh   3RSbЭR>LRb͞͉ݭ<RRݬݭ RPC_$FILL_FRAGP͉͈<S<RRSR͉ ͈͈RR͊͊͋ ]   RR͋ЭR RRݭ͉ݭϷP' 
RPC_$DEBUG RPC_$MAX_DEBUG   VAXC$GPRINTF1RRRR͊19R͉RRͱ  TIMEPRRЕͱͰPFP	͈P͈͈RR 

RR
2RxRRR䡭RR
ЏխPݭݭϏPЭPP  1#P	?P1kխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ߭ЭRݢ@ݬ ݭݭݭP1   TIME ^   PR­RR 
RPC_$DEBUG RPC_$MAX_DEBUG2RR<RR8 VAXC$GPRINTFѭ@   խ7   
RPC_$DEBUG RPC_$MAX_DEBUGPݭ  k VAXC$GPRINTFЏ@   1EP   ЭRRRRRPP s$PP?PSP11Y1 
RPC_$DEBUG RPC_$MAX_DEBUGP ǐ VAXC$GPRINTFʹݭ RPC_$GET_PKT_BODY_ST^(ʹn PFM_$SIGNAL 
RPC_$DEBUG RPC_$MAX_DEBUG/ЭRRRRR 
RPC_$PKT_NAMEP  Ƿ VA _   XC$GPRINTF1QP 
RPC_$DEBUG RPC_$MAX_DEBUGP   VAXC$GPRINTF镭]RRѦJ   
RPC_$DEBUG
 RPC_$MAX_DEBUG  	 VAXC$GPRINTFЏ ̈́^(̈́n PFM_$SIGNALP1ͱ2 
RPC_$DEBUG
 RPC_$MAX_DEBUG<RR n	 VAXC$GPRINTF13P 
RPC_$DEBUG RPC_$MAX_DEBUGP  ǩ	 VAXC$GPRINTF1 P 
RPC_$DEBUG RPC_$MAX_DEBUGP  	 VAXC$GPRINTF	 PERRORݏ{  `    		 RPC_$DIE 
RPC_$DEBUG
 RPC_$MAX_DEBUG  
 VAXC$GPRINTF=
 PERRORݏ  X
J
 RPC_$DIE䱭
PMP  PFM_$ENABLE 
RPC_$DEBUG
 RPC_$MAX_DEBUGP  |
 VAXC$GPRINTFЏ ̀^(̀n PFM_$SIGNAL(P //RyR bЭR  ݭ/ݭϙݕP1 ߭ TIME 
RPC_$DEBUG RPC_$MAX_DEBUGݭ  Ǭ
 VAXC$GPRINTF SLEEP߭ TIME 
RPC_$DEBUG
  a   RPC_$MAX_DEBUGPݭ  
 VAXC$GPRINTF1P RR RR2RRRR 
RPC_$DEBUG
  RPC_$MAX_DEBUG& 2RRݭ  
 VAXC$GPRINTFJ 
RPC_$DEBUG RPC_$MAX_DEBUGP PFM_$FAULT_INH_COUNT   VAXC$GPRINTFЏ |^(|n PFM_$SIGNALݭݭ!PRRPP  (P	Z?P1խ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ߭ЭRݢ@ݬ ݭݭݭ                                                                                                                                                                                                                                                   -                        ]& $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "     a        b   kޕP1 ЭRRRRRPP 9)P	?PZP1Y1 1 
RPC_$DEBUG RPC_$MAX_DEBUGP<RR V  VAXC$GPRINTFʹݭ RPC_$GET_PKT_BODY_ST^(ʹn PFM_$SIGNAL 
RPC_$DEBUG RPC_$MAX_DEBUG0PЭRRRRR 
RPC_$PKT_NAMEP  ǜ VAXC$GPRINTF1P 
RPC_$DEBUG RPC_$MAX_DEBUGP   VAXC$GPRINTF1Pݏ   RPC_$DIEͱA 
RPC_$DEBUG
 RPC_$MAX_DEBUG  ! VAXC c   $GPRINTFЏ x^(xn PFM_$SIGNAL   
RPC_$DEBUG
 RPC_$MAX_DEBUG!PЭRݢ@  G   VAXC$GPRINTFЭTЭR>HSHRcbЭTЭR>FSFRcb1A 
RPC_$DEBUG
 RPC_$MAX_DEBUG  h VAXC$GPRINTFЏ t^(tn PFM_$SIGNAL  ЭR>LR<bSSЭR>LR<bRSR' 
RPC_$DEBUG RPC_$MAX_DEBUG Ǐ VAXC$GPRINTF1ЭTЭR>LR<bRRRRSLRSb 1  ЭR 1;131+Э d   RNSЭR҄ R޲ RSbЏ p^(pn PFM_$SIGNAL޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bݬ4ЭR@ݭЭR>JR<bSЭRCP޼,R^(bnЭR ЭR҄ RbR޲Rb޼4Rb޼4Rbl^(ln PFM_$SIGNALխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ЭRRʏRR_PͰA 
RPC_$DEBUG
 RPC_$MAX_DEBUG  Ǧ VAXC$GPRINTFЏ h^(hn PFM_$SIGNAL޼(SЭR>JR<bRRc1$ e     ͰЭR>JR<bRRݭ RPC_$ALLOC_LINKED_PKTP͟ݭ͠ RPC_$INSERT_IN_FRAG_LISTݭ  RPC_$FREE_LINKED_PKT͟1 ЭRRʏRR1 (P //R	yR bЭR>HSwRcb>ͬS{RcbЭR  ݭ/ݭϩ֕P) 
RPC_$DEBUG
 RPC_$MAX_DEBUGP  VAXC$GPRINTF11޼(SͨRbc޼$R͠ RPC_$REASSEMBLE_FRAG_LISTPb޼0RbP  -ݭύԕe RR RPC_$STOP_PERIODIC dЬRFЭ f   R UUID_$EQUAL͕P!ЭS޼RѣBbЭTЭR>FSLRcbЭR. UUID_$EQUALٕPЭTЭR>HSNRcbЭTЭRޢ8S>RcbЭRjSjRSbRRRЭRVRRRЭRVRbSRbcRb<RR.ЭTRRЭSRRcdRR<RR޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bPխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ͳ ͳݬ4ݭ RPC_$FREE_HANDLEݭvҐ ݬ4ͼ PFM_$_R g   LS_CLEANUP  RPC_$UNLOCKҰ   ^ݬݬݬݬݬݬ    SOCKET_$FROM_NAME  ^ݬݬݬݬݬ           rpc_$inq_object_client          rpc_$clear_server_binding        rpc_$clear_binding |     4  	rpc_$bind 3    h  rpc_$set_short_timeout `       rpc_$set_async_ack        rpc_$free_handle        rpc_$dup_handle $       await_reply       quit_server      h   H  rpc_$sar `    0  rpc_$name_to_sockaddr ,     0  rpc_$sockaddr_to_name (     0  
rpc_$set_auth x      SOCKET_$TO_NAME< ^ЬRТѭЬѭ
 ^(n PFM_$SIGNAL޼R bЭR ЭR ЭRҀ RbR޲RbЭR    < ^ЬRТѭЬѭ
 ^(n PFM_$SIGNAL޼R bR P< ^ЬRТѭ@޼R bЬЭR ЭR ЭR҄ RbR޲RbЭRЬ 9Pѭ
 ݬݬݬ RPC_$SET_S i   ERVER_ENCRЏ ^(n PFM_$SIGNAL< ^ЬRТѭ޼R bЬЭR P7ѭ
 ݬݬ   t1  
rpc_$inq_auth P     1  
rpc_$set_encr      T2  
rpc_$inq_encr h   		 T            
	   
    
       j              	     
 			          
   )2 k    	      
                   
                       
                	  l     
    
   	    y   


				 	   
  (   RPC_$INQ_BINDING 
    < RPC_$INQ_OBJECT_CLIENT 
     RPC_$CLEAR_SERVER_BINDING 
     RPC_$CLEAR_BINDING 
  4   	RPC_$BIND 
  h    RPC_$SET_SHORT_TIMEOUT 
      RPC_$SET_ASYNC_ACK 
      RPC_$FREE_H m   ANDLE 
      RPC_$DUP_HANDLE 
  H   RPC_$SAR 
  0    RPC_$NAME_TO_SOCKADDR 
  0    RPC_$SOCKADDR_TO_NAME 
  0  < 
RPC_$SET_AUTH 
  t1  < 
RPC_$INQ_AUTH 
  1  < 
RPC_$SET_ENCR 
  T2  < 
RPC_$INQ_ENCR  2  $CODE   $DATA    ERRNOo     
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON   $CHAR_STRING_CONSTANTS   RPC_$INQ_SERVER_ENCRPPЏ ^(n PFM_$SIGNAL /)P %  ! %  (P S c$P! - ) r - r r %  )#P      5 PD           w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              o   1    =   `	[5i V1.0                            7     
RPC_SERVERV1.0 3-APR-1991 08:33                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$DEBUG  RPC_$MAX_DEBUG  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCI p   I  
RPC_$STATS  
RPC_$DEBUG  
RPC_$LOSSY 
    EXCESSIVE_RETRANSMITS 
    LAST_REQUEST_NMBR 
    LAST_PING_SEQ_NMBR 
    LAST_RETRANSMIT_SEQ_NMBR 
    LAST_RESEND_SEQ_NMBR 
    RESENT_REPLIES 
    
SERVER_FAULTS 
    SERVER_IMPLICIT_ACKS_DETECTED 
    SERVER_PROTOCOL_ERRORS 
    CLIENT_PROTOCOL_ERRORS 
    SERVER_IGNORED_OLD_REQUEST 
    SERVER_RCVD_INAPP_RQST 
    SERVER_RCVD_BAD_OPNUM 
    SERVER_RCVD_BAD_BOOT_TIME 
    SERVER_REJECT q   IONS_SENT 
   SERVER_TRASHED_IHINTS 
   SERVER_TRASHED_AHINTS  
   SERVER_RCVD_BAD_PACKETS 
   
FACKS_RCVD 
   FACK_REPLIES 
   BAD_FACK_FRAGNUMS 
   
DROPPED_FRAGS 
    DUPLICATE_FACKS 
 $  INVALID_FACK_AHINTS 
 (  ANOMALOUS_FACKS 
 ,  INVALID_DO_QUIT_AHINTS 
 0  INVALID_ACK_AHINTS 
 4  ZERO_DELTAS 
 8  UNFREED_REPLIES 
 <  
FREED_PASSIVE 
 @  RETRANSMITS_SUPPRESSED 
 D  REPLIES_DROPPED 
 H  
DROPPED_PINGS 
 L  HIGHER_N r   UMBERED_PINGS 
 P  
PINGS_RCVD  P%W%     (ultrix)        %G%P   `P v":3jP
mP P 96 @ P
 PfhPrpc_server.c: wPrpc_server.c: (do_request) Prpc_server.c: (scan_activities) Prpc_server.c: (ping_common) Prpc_server.c: (do_ping) Prpc_server.c: (rpc_$int_listen_dispatch)  PNULL	(rpc_$request -- handled specially)
P *Pdo_ping  (rpc_$ping)P*?Pdo_bad_pkt  (rpc_$response)P?[Pdo_bad_pkt  (rpc_$fault) P[tP                                                                                                                                                                                                                                                   .                        	 $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         L$ "     r        s   do_bad_pkt  (rpc_$working)$Pt  Pdo_bad_pkt  (rpc_$nocall)(P  Pdo_bad_pkt  (rpc_$reject),P  Pdo_ack  (rpc_$ack)0P  Pdo_quit  (rpc_$quit)4P  Pdo_fack  (rpc_$fack)8P  Pdo_bad_pkt  (rpc_$quack)<P P%s, %lu.%u$PfragP$)Pin_call_backP)6PworkingP6>Pin_replyP>GPrepliedPGOPidle POTPpassive$PT\P%s(send_rejection) via rpc_$sendto. sock# %d
P%s%s
 t   PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6  PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6P%s(free_reply) act->a.reply.opkt == NULL so don't call rpc_$free_pkt()
DPact->state == as_in_reply || act->state == as_repliedzPRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6Pact->state = as_repliedPRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6P%s(send_reply) Send small reply. sock# %d
P%s(send_reply) frag of large reply. sock# %d
3P%s(get_activity) Can't allo u   cate slot
YP%s(get_activity) allocate activity  slot %d.
P%s(free_activity) free activity slot %d.
Pact->state == as_idlePRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6Pact->state == as_passivePRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6'P%sENTERED ..
5PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6YP%s slot %d. delta = %d.
rP%sFreeing passive slot %d. (act->state == as_passive)
	act->id = [%s]
P%sPassivating slot %d. idle. (act->state == as_idle) && delta > IDLE_TIME
P	act v   ->id = [%s]  delta = %d, IDLE_TIME = %d
1P%sSuppressin g RETRANSMIT reply slot %d. (act->state == as_in_reply)
vP%sFree reply slot %d. (act->state == as_replied)
P	delta > REPLY_TIME  uidseqstring = [%s]  delta = %d, REPLY_TIME = %d
P%sRETRANSMITTING reply --> slot %d. <-- (state = %s)
%P	uidseqstring = [%s]	sock# %d
DPact->re_xmt_send = %d, seq # = %D
gPact->ping_protocol_error = %d, act->fack_protocol_error = %d
P%s slot %d. DELTA <= 0 #%D ! (delta = %d)
PR w   PC activity scannerP%sact->state == as_working
P	(ptype  = %s)  uidseqstring = [%s]  sock# %d
/P%sact->state == as_in_reply || as_replied
ZP%sResending reply
mP	(state=%s, ptype=%s, frag=%u)
	udeseqstring = [%s] sock# %d
Pact->re_xmt_send = %d
P%sact->state == as_idle || as_passive || as_frag
P	--> NO CALL <-- (state=%s, ptype=%s)
	uidseqstring = [%s]	sock# %d
9P%sInvalid activity state (state=%s, ptype=%s) sock# %d
qP%sIssuing -DIE- `INVALID ACTIVITY ST x   ATE'
Pinvalid activity statePRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 P%s(who_are_you) Can't bind to client, lst=%08lx  setting act->state = as_idle..
'	P%s%s
-	PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6Q	P%s(who_are_you) fault, lst=%08lx
s	PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6	P%s%s
	P%s(handle_request_frag) sendto -> sock# %d
	P%s..ENTERED.. sock# %d
	P%sUnknown interface [%s]	sock# %d

P%sSending rejection for NOT broadcast
	When ihint == NO_HINT
	-or- uids not  y   ===  -or-  ifs.vers not equal.
	Sending on sock# %d.
P%sOpnum out of range ?   [%s]
	sock# %d

P%ssending rejection..
	Not a broadcast.. sock# %d

P%sahint == NO_HINT. sock# %d

P%sactivity state for this call => %s
$P%sGot inappropriate request (state=%s) [%s]	 sock# %d
[P%sact->state == as_passive. sock# %d
P%sactivity state IS NOW => %s, NEXT INS CHANGES STATE.
	sock# %d
P%sreset activity state from as_passive  to => %s
	sock# %d
P%sInvalid state (state=%s) z    [%s]P%sInvalid state (state=%s)
	ID = [%s]
	GOING TO INITIATE:  >> DIE << operation  !
	sock# %d
{PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6P%s%s
P%sSending rejection. Not idem && act->prev_seq == -1 ..
	sock# %d
P%s%s
P%scouldn't get encr ? Sending rejection. sock# %d
!
P%spkt->hdr.auth_type != rpc_$auth_type(act->a.encr)
	Sending rejection.. sock# %d
t
P%s%s
z
P%scouldn't decrypt pkt ? Sending rejection. sock# %d

P%sOld sequence, previous=%ld [%s]
	sock# %d   {   IGNORING REQUEST !!

P%sOperation not idem. Sending rejection. sock# %d
%P%sProtocol error  [%s]
	sock# %d
FP%sNOT a BROADCAST. Sending rejection. sock# %d
vP%sPF_FRAG pkt == NULL. sock# %d
P%sDiscarding any saved reply(s). Going -idle-  sock# %d
P%sSwitching to -WORKING- state. sock# %d
P%sCouldn't set pfm_$p_cleanup(&crec)
 PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6DP%sFault while executing request ??
hP%s%s
nP%sDispatching  iface->e.s.epv[pkt->hdr.opnum]  |   opnum = %d
	address = 0x%X	sock# %d
P%sGeneric dispatch iface->e.g.epv[pkt->hdr.opnum] opnum = %d  ad dress = 0x%X
	sock# %d
PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6=P%s== non-maybe && idem &&  !large. sock# %d
jP%sCalling  rpc_$sendto for sock# %d
P%s== non-maybe && idem && large.  sock# %d
P%ssending reply for sock# %d
P%sgot_frag on sock# %d
	Calling  rpc_$free_pkt((rpc_$ppkt_p_t) pkt)
P%s%s
$P%ssignalling fault_st ? sock# %d
FP%s%s
LP%ssignalling fa }   ult_st ? sock# %d
nP%ssay -NO CALL-  NOT valid_ahint(pkt) ?
P%ssending on sock# %d
P%sNo call (no ac tivity for this call) [%s]
	sock# %d
PPROTOCOL ERRORING PING for seq # %D, act->re_xmt_send = %d
 P%sNo call (higher numbered ping), ahint=%d, previous=%ld
ZP	[%s]  sock# %d
kP%ssay -NO CALL- packet must have been lost sock# %d
P%sDrop PING !?
	uidseqstring = [%s]
	sock# %d
P%s(do_ack) NOT valid_ahint(pkt).  ahint = %d
	 uidseq = [%s]	 sock# %d
P%s(do_ac ~   k) freeing reply. state = as_replied & pkt->hdr.seq [%D] >= act->prev_seq [%D]
oP%s(do_ack) Sorry, can't call free_rep ly.
P	act->state = %s  s.b. as_replied
P	pkt->hdr.seq = %D, act->prev_seq = %D  hdr.seq s.b >= prev_seq
P%s(do_fack) Not valid ahint in fack, ahint=%d
	uidseq = [%s]	sock# %d
DP%s(do_fack) Anomalous fack ?  state=%s, act->prev_seq=%D  pkt->hdr.seq= %D
	uidseq [%s]	sock# %d
P
DUPLICATE FACK !! # %d, pkt seq # %D, last_frag_seq = %D
Ppkt->hdr.fragnum     = %d, act->last_fack_frag = %d
Pact->re_fack in do_fack: %d
/Pdo_fack SENDING PROTOCOL ERROR..
QP%s(do_quit) NOT vali 
 T  AS_IN_REPLY_PINGS 
 X  DUPLICATE_PINGS 
 \  INVALID_HANDLES 
 `  RETRANSMITS 
 d  
NO_CALLS_SENT 
   PKT_HANDLER_NAMES  RPC_$INT_LISTEN_DISPATCH  SCAN_ACTIVITIES  	RPC_$FREE  RPC_$MALLOC  RPC_$TERMINATION_FAULT  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$FILL_FRAG  RPC_$PERIODICALLY  RPC_$REASSEMBLE_FRAG_L    IST  RPC_$INSERT_IN_FRAG_LIST  RPC_$FREE_FRAG_LIST  RPC_$SENDTO  RPC_$SET_PKT_BODY_ST   RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$DIE  RPC_$INQ_OBJECT_CLIENT  UUID_$EQUAL  UUID_$ENCODE  	UUID_$GEN  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$FREE_HANDLE  	RPC_$BIND  SOCKET_$MAX_PKT_SIZE  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  _ASSERT  ABORT  VAXC$GPRINTF  
VAXC$GSPRINTF  MEMSET  MEMCPY  SETJMP  
ERROR_    $C_TEXT  TIME  TIME  TIME  TIME  TIME  
ERROR_$C_TEXTd_ahint(pkt).. Indicate -NO CALL-
P%s(do_quit) NO CALL (i.e. no activity for this call)
	uidseq = [%s]	sock# %d
P%s(do_quit) send rpc_$quack.	sock # =%d
P%s(do_bad_pkt) Bad pkt, ptype=%s
	 uidseq [%s]	sock# %d
8P%sTrash ahint (%u)  sock# %d
VP%sTrash ihint (%u)  sock# %d
tP%sServer boot time mismatch !!
P%sSending rejection on sock# %d
PRPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6P%sptype != rpc_    $request.
	Dispatching to routine:  %s  sock# %d
  P ^ RQݬ   UUID_$ENCODEQ  PPP ^ S RЬP>LP<`PPЬPݠ@ЬP(Pv 
VAXC$GSPRINTFvPPP  ^ QЬP@P ^ S RЬPݬݬ RPC_$SET_PKT_BODY_STЬPJP` 
RPC_$DEBUG RPC_$MAX_DEBUGݬh\ VAXC$GPRINTF 
RPC_$DEBUG-ݏd   ¨ݬ 
ERROR_$C_TEXT¨hÊ VAXC$GPRINTF ݬݬ    RPC_$SENDTO| ^     V8( 	UUID_$GENŐ8޼R(( < ^ЬRТѽ޼RЏ b P޼SЭ R(c޼UЭRТ.TЭSuRRu@uRReݬЭRݢ2ЭR6ЭR. R  	RPC_$BINDPP  ^ݬB ^ R ޼P ` Hf<Pď`   P@@PPЭPW
Э/PЬPFЭPF UUID_$EQUALP޼Pѽ`ЭPPHխE<HPP ޼PЏ ` PHQHPPH<QPď`   P@@PPЭP WP| ^ Vݏ  Ɛ 	RPC_$LOCKݬݬPխ RPC_                                                                                                                                                                                                                                                   /                        hE $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         ѽ "                $UNLOCKЭRW0ЭRVЭRѢXP޼RЏ
 b RPC_$UNLOCK0ЭRWЭR V ޼R(V bЭRЬXЭR\R bЭS\RR\ RPC_$UNLOCK| ^ Vݏ  ƴ 	RPC_$LOCKݬݬ1Pխ RPC_$UNLOCKЭRW0ЭRVЭRѢXP޼RЏ
 b RPC_$UNLOCK.ЭRWЭRV޼R(V bЭRЬXЭR \ RPC_$MALLOCP޼R(bЭRЬЭSЭRТ\ЭRЭ\  RPC_$UNLOCK ^ R HX<Pď`   P@@PPЭPW)޼P    `ЭPF UUID_$EQUALʕPѽ<PPPPPHЏ  PP ^ R S޼P `  R    
RPC_SERVER      	uidstring (     (   uidseqstring S     |   
state_name         send_rejection      @  get_my_activity 0   #  p  rpc_$server_to_client_handle        rpc_$get_my_activity         find_ifrgy_slot        
rpc_$register        rpc_$register_mgr        find_interface y           rpc_$unregister        find_mgr_epv C        rpc_$register_object d      ݏC   	RPC_$LOCK޼P`ЬPF@P RPC_$UNLOCK޼PЏ `<Pď`   P@@PPЭPV$ЭQ\PP\>\P<`PPЭP WP RPC_$UNLOCK  ^լ2P޼P`޼P` UUID_$EQUALוP	ЬPРPЬPРլ2  P| ^ V<JRR@   ޼RЏ bJSJRRJ<SR RB@RR޼R(bЭS޼R(b޼R b| ^ V޼Rb 	UUID_$NIL     UUID_$EQUALP޼R( 	UUID_$NILbЏ   P JPP<R RB@RR޼Rb UUID_$EQUALP޼SЭR(cЏ   PRRJ޼R( 	UUID_$NILb2  P ^ T SЬPՠJЬPݠJ 
RPC_$FREE_PKTЬP J(P 
RPC_$DEBUG RPC_$MAX_DEBUGPh VAXC$GPRINTF޼P`ЬRЬQЬP   ЬQЬP ((& ^ S TЬPJPP޼P`޼P`P!Pݏ  zD _ASSERT  ABORTЬP>6P<`PP SOCKET_$MAX_P    KT_SIZEP   PPЬPՠ~ЬPް~P`PàPPЭPѠ1 ЬP``ݏ  öÞ _ASSERT    ABORTнRЭP>QJPa` RPC_$MAX_DEBUG' 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬh VAXC$GPRINTFЬPݠ~ЬP2ݽݬ RPC_$SENDTOЭP>P` ЬPy癭PPݭ<PPЭPݠݽ RPC_$FILL_FRAGƐP<Q<PPQP	 琭PP항PP RPC_$MAX_DEBUG) 
RPC_$DEBUG RPC_$MAX_DEBUGPݬh V    AXC$GPRINTFЬPݠ~ЬP2ݬ RPC_$SENDTOPPPP19޼P`  ^ЬPt P  ^ S <RR   jP<P@HF޼Rb<P@HP UUID_$EQUALP&<P@HR  TIMEPQPQ`<PPPPP<PP   Џ  P  ^ W VЬRHЬRHBЬR>HR<bRBH0ЬR(ЬR>HR<bRBHR UUID_$EQUALP<RRPЬR(P챭<RRP <RR   SP<RBHDP<RBHRb<RBHRb<RRRR    RR<RR   <RR   b. 
RPC_$DEBUG
 RPC_$MAX_DEBUGh3 VAXC$GPRINTFЏ  P-2ԭRBHRb2RR2RRu 
RPC_$DEBUG RPC_$MAX_DEBUGP<RRhY VAXC$GPRINTF<Rݏ    RPC_$MALLOCPЭBHЭSЬR((ЭRЏЭTЭSЭR   ЭSЭR ((&ЭR JЭRЬFЭR TЭR tЭTЬRRʏRSRSSyЭR zЭR ~ЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR.    TRRЭSRRcdRR<RRЭR  TIMEPSRSb<RRP ^ S R 
RPC_$DEBUG
 RPC_$MAX_DEBUGP<PPhÆ VAXC$GPRINTF<P@H<P @H 	RPC_$FREE ^ V W<RBHѽ!Pݏ  ư _ASSERT  ABORT<R* RPC_$MALLOCPЭBHЭSЭR(ЭSЭRТЭSЭRЭSЭR  ЭSЭRЭSЭR&&ЭSЭR((ЭR  TIMEPSRSbЭRբ~ЭRݢ~ЭR޲~RbR޲RbЭR     ~ЭRբzЭRݢzЭR޲zRbR޲RbЭR z  	RPC_$FREE  ^ V W<RBHѽ!Pݏ     _ASSERT  ABORT<Rݏ    RPC_$MALLOCPЭBHݏ    ݭ MEMSETЭSЭR(ЭSЭRТЭSЭRЭSЭR  ЭSЭRЭSЭR&&ЭSЭR((ЭRЬFЭR zЭR ~ЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR.ЭTRRЭSRRcdRR<RRЭR  TIMEPSRSbݭ 	RPC_$FREEP     ^ S R 
RPC_$DEBUG RPC_$MAX_DEBUGP' VAXC$GPRINTFݏ<  5 	RPC_$LOCK  TIMEP\\ <\\   1<\LHխ1Э\ì\\\\ 
RPC_$DEBUG RPC_$MAX_DEBUG 2\\<\\Y VAXC$GPRINTF1нPP WPP?P1,T<\\< 
RPC_$DEBUG
 RPC_$MAX_DEBUG+PЭ\cP<\\r VAXC$GPRINTF<\\ψ1}-p 
RPC_$DEBUG
 RPC_$MAX_DEBUG<\\    ù VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUG(P-2\\Э\P VAXC$GPRINTF<\\r1P@\\@  
RPC_$DEBUG
 RPC_$MAX_DEBUGP<\\1 VAXC$GPRINTF1Э\&
Э\(1 Э\&Э\( \\ PD\\D 
RPC_$DEBUG
 RPC_$MAX_DEBUGP<\\v VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUG(P2\\Э\ݬJPè VAXC$GPRINTFݭ1P 
RPC_$DEBUG     RPC_$MAX_DEBUG&PݽP<\\ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUG&PЭ\ݬFЭ\ݬJχP% VAXC$GPRINTF`\\`Э\ެ\l  
RPC_$DEBUG RPC_$MAX_DEBUGP Э\2\\D VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUG$PЭ\2(\\Э\2&\\g VAXC$GPRINTFݭЭ\ݬF]PEP 
RPC_$DEBUG RPC_$MAX_DEBUG1P2\\4\\44<\\å VAXC$GPRINTF⡭\\<\\   1D     RPC_$UNLOCK ^ R   SCAN_ACTIVITIES\\ RPC_$PERIODICALLY 4^ S R޼QaPP  P
P?P1a   
RPC_$DEBUG RPC_$MAX_DEBUGP´ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUG5ݬݬPЬPPPPP 
RPC_$PKT_NAMEP VAXC$GPRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTO1-TPPT PP  
RPC_$DEBUG
 RPC_$MAX_DEBUG´/ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_D    EBUG´Z VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGRݬݬPЬP>RP<`PPЬPPPPP 
RPC_$PKT_NAMEP޼P `Pm VAXC$GPRINTFЬPޠ@P` ЬQPPXPPX 
RPC_$DEBUG
 RPC_$MAX_DEBUGЬP2PPë VAXC$GPRINTFݬݬ1 
RPC_$DEBUG RPC_$MAX_DEBUGP´ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGDݬݬPЬPPPPP 
RPC_$PKT_NAMEP޼P`DP VAX    C$GPRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTOgPݬЬPPPPP 
RPC_$PKT_NAMEP޼P`P´9 VAXC$GPRINTF´q  VAXC$GPRINTFݏ  òÛ RPC_$DIEP ^ЬЭPРЭPѠ
 kѽeЭP6PPЬ޼QЭPޠ2P`aЭP>2P`<PP/ЭRPPЭQPPabRR<RR޼R b x^ W VЬRݢ2ЬR6 	UUID_$NIL 	RPC_$BINDPխ\ 
RPC_$DEBUG RPC_$MAX_DEBUGPݭh VA    XC$GPRINTF޼RbЬTЬSЬR   ЬSЬR ((&޼Rb޼Rb RPC_$UNLOCK򞭨SR SETJMPPDRݢD 
PFM_$_CLEANUPЭѭ  1  
RPC_$DEBUG1ݏd   ƨ^(n 
ERROR_$C_TEXTƨh'	 VAXC$GPRINTF ݬ+ݏ  -	 	RPC_$LOCK޼RЭb  PFM_$ENABLE 
RPC_$DEBUG
 RPC_$MAX_DEBUGݭhQ	 VAXC$GPRINTF1 ݏ   ݬլ_@MլHѬ   >ЬRB@3ЬS߭LЬRݭЬRB@R    bPzPЏ %P߭LЬRݭ CONV_$CLIENT_EPVRb ݬ9ݏ5  s	 	RPC_$LOCK޼RЭb PFM_$_RLS_CLEANUP޼RЭbխЬSRR9 
RPC_$DEBUG1ݏd   ƨ^(n 
ERROR_$C_TEXTƨhǗ	 VAXC$GPRINTF RPC_$FREE_HANDLE ^ W VЬRRR<RBHЭRTRRЭRRRR ЭRRʏRR	RRRR ЭSЭRТ@ݬݭ RPC_$INSERT_IN_FRAG_LIST敭#޼SЭRޢRbc                                                                                                                                                                                                                                                   0                         $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         -d "                ݭ RPC_$REASSEMBLE_FRAG_LISTPP1 P{(P R	R bRbЭR>SRcb RPC_$MAX_DEBUG* 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬhǝ	  d  inq_object_type        
free_reply        
send_reply 8    	  set_act_quitable      	  
find_activity      x
  get_activity     L
  
free_activity d     
  passivate_activity <      activate_activity     t  scan_activities ;  "        rpc_$start_activity_scanner (       ping_common       rpc_$get_callers_addr      p  who_are_you     0  handle_request_frag L   VAXC$GPRINTFЭRݢ~ݬݬ RPC_$SENDTO޼R b P< ^޼RbPP  P^?P1 ЬRT RPC_$FREE_FRAG_LIST޼RbЬTЬSЬR   ЬSЬR ((&qЬRt' ݬPЏ^(n PFM_$SIGNAL>Pݬ1ЬTЬSЬR   ЬSЬR ((&PP h^     W VЬRRR ЭRRʏRSRSSЭRRʏRSRSSЭRRʏRSRSS RPC_$MAX_DEBUG' 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬw	  VAXC$GPRINTFЭRFЭRݢ<ЭRfPЭR>FRbDЭR<Rď`   RBƆ UUID_$EQUALەP <Rď`   RB@SЭRc<}P 
RPC_$DEBUG RPC_$MAX_DEBUG#PݬݭσPh	 VAXC$GPRINTF? 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬh
 VAXC$GPRINTF    ݬݭݏ ݬϗЭS<Rď`   RBƄRDb1  RR  
RPC_$DEBUG
 RPC_$MAX_DEBUG$PݬݭPhǅ
 VAXC$GPRINTFK RR  
RPC_$DEBUG  RPC_$MAX_DEBUGݬhǭ
 VAXC$GPRINTFݬݭݏ ݬЭRFRbЭR>FR<bRď`   RB@RRݬݬݭϑP+ 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬh
 VAXC$GPRINTFЭRHRb<RBH RPC_$MAX_DEBUG0 
RPC_$DEBUG RPC_$MAX_DEBUGݽ    #Ph
 VAXC$GPRINTFѽѽѽ1 PѽЭRТ*RRЭRТRRЭԭЭRѢ@P RR  
RPC_$DEBUG
 RPC_$MAX_DEBUG0PݬݭGPݽϏPh$ VAXC$GPRINTF
ݭoѽ1  RPC_$MAX_DEBUG^ 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬh[ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUG"ݬݽPhǁ VAXC$GPRINTFݬݬ<RR[P RPC_$MAX_DEBUG4 
RPC_$DEBUG RPC_$MAX_DEBUG    "ݬݽϿPh VAXC$GPRINTFѽ~ѽxսsݭ=PݽυPhU 
VAXC$GSPRINTFݬݭPݽSPh VAXC$GPRINTFݏZ  {U  RPC_$DIEЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR/ЭTRRЭSRRАcdRR<RRЭRЬF1 ЭRѢ1 ЭSЭRТ@*ЭRNRRݭgխ1  RR  
RPC_$DEBUG RPC_$MAX_DEBUG3Pݏd   ƨ^(n 
ERROR_$C_TEXTƨh    ǟ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGݬhǥ VAXC$GPRINTFݬݭݭݬЭRբz1UЭRբ~1 ЭSЭRݢzЭR޲zR޲ R޲ RbP~խ1   
RPC_$DEBUG
 RPC_$MAX_DEBUG4Pݏd   ƨ^(n 
ERROR_$C_TEXTƨh VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGݬh VAXC$GPRINTFݬݭݭݬ&ЭRNSЭR޲~R޲ RSbA 
RPC_$DEBUG RPC_$MAX_DEBUGPݬh!
 VAXC$GPRINTF    ݬݭݏ ݬ۞YSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR bЭR@ݬЭR>JR<bSЭRCP^(YnЭRݢ~ЭR޲~RbR޲Rbխ1    
RPC_$DEBUG1ݏd   ƨ^(n 
ERROR_$C_TEXTƨht
 VAXC$GPRINTF 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬhz
 VAXC$GPRINTFD޼RbЬR^(nDݬݭݭݬϐЭRޢ@Rb ЭSЭRѣ@I RR  
RPC_$DEBUG RPC_$MAX_DEBUG+PݬݭP    ЭRݢhǰ
 VAXC$GPRINTFЭSЭRѣ@qսlѽݬݭݭݬ?K RR  
RPC_$DEBUG
 RPC_$MAX_DEBUGݬh
 VAXC$GPRINTFݬݭݏ ݬϫ սXЭSЭRѣ@IRRЭRT RPC_$FREE_FRAG_LISTЭTЭSЭR   ЭSЭR ((&1 ЭSЭRRѣ@R1  RR  
RPC_$DEBUG RPC_$MAX_DEBUG#PݬݭϗPh% VAXC$GPRINTFK RR  
RPC_$DEBUG RPC_$MAX_DEBUGݬh    F VAXC$GPRINTFݬݭݏ ݬϟЭRRʏRRW߭ݬ<RRݬݬPխ( 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬhv VAXC$GPRINTFͰPЭR>JR<bRR Ͱ RR  
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬhǗ VAXC$GPRINTFݭZޕ 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬh VAXC$GPRINTFЭSЭRТ@ЭRuR bЭRЭ.ЭRd5 RPC_$UNLOCKЬR>R<bRR SOCKET_$MAX_PKT_SIZEP   PPЭ    Rբ~ЭR޲~RbRâRR䰏P ͦͨRЏ
 bЭͬ ͱ ] UYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR b^S^R SETJMPPD^^RݢD=  
PFM_$_CLEANUP=ѭ 1 
RPC_$DEBUG RPC_$MAX_DEBUGh VAXC$GPRINTFЭU ݭυݏ?    	RPC_$LOCK  PFM_$ENABLE RR  
RPC_$DEBUG
 RPC_$MAX_DEBUGPhD VAXC$GPRINTF 
RPC_$DEBUG2ݏd   ƨ^(Un 
ERROR    _$C_TEXTƨhh VAXC$GPRINTFޞͲRRܕP^(Un RPC_$TERMINATION_FAULTەPЏ PURRݭݭ RPC_$SET_PKT_BODY_ST1I 
RPC_$STATS   3RR   
RPC_$STATS   3ݏ   ݭωЭRV1  RPC_$MAX_DEBUGO 
RPC_$DEBUG
 RPC_$MAX_DEBUG=PݬЭR>DR<bSЭR޲XRCbЭR>DR<bRRhn VAXC$GPRINTFͱ߭߭^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbR
b1 PEЭRREЭRݢ\ϘPխ     A^(An PFM_$SIGNAL RPC_$MAX_DEBUGL 
RPC_$DEBUG
 RPC_$MAX_DEBUG:ݬЭR>DR<bSЭR޲XRCbЭR>DR<bRRh VAXC$GPRINTFͱ߭߭ݭ^(Ynݏ   ͲݭݭͦЭR>DR<bSЭR޲XRCbRb ݭݏ   	RPC_$LOCKѭ9ͱݭ 
RPC_$FREE_PKTͲRRݏ ݭ RPC_$SET_PKT_BODY_STPRѭRR]^ PFM_$_RLS_CLEANUP;ЭR JЭTЭSЭR   ЭSЭR ((&1    (P ЭRHRbЭRLR bЭR ЭRܢ1 ]1 ЭR JЭTЭSЭR   ЭSЭR ((&ЭRJRb RPC_$MAX_DEBUGQ 
RPC_$DEBUG RPC_$MAX_DEBUGPݬh= VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGݬhj VAXC$GPRINTFЭRݢ~ݬݭݬ RPC_$SENDTO1 ЭЭRNRЭbЭRբ~ЭR޲~RbRĢRRЭRݭ RPC_$ALLOC_PKTPJP   RRݭЭRݢJ MEMCPYܕ]	PЭЭRRR b RPC_$MA    X_DEBUGQ 
RPC_$DEBUG RPC_$MAX_DEBUGPݬhǏ VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGݬhǻ VAXC$GPRINTFݭݬؕͰ< RPC_$MAX_DEBUG)  
RPC_$DEBUG RPC_$MAX_DEBUGPݬh VAXC$GPRINTFݭ 
RPC_$FREE_PKTЭR  TIMEPSRSbͱݭ 
RPC_$FREE_PKTЭR .P1 U1 ˏ  URR   RR  RPC_$MAX_DEBUG\ݏd   ƨ^(Un 
ERROR_$C_TEXTƨh VAXC$GPRINTF     
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬh$ VAXC$GPRINTF^(Un PFM_$SIGNAL^(Un RPC_$TERMINATION_FAULTP| RR  RPC_$MAX_DEBUGYݏd   ƨ^(Un 
ERROR_$C_TEXTƨhF VAXC$GPRINTF 
RPC_$DEBUG
 RPC_$MAX_DEBUGݬhL VAXC$GPRINTF^(Un PFM_$SIGNALP 0^ T SPPPPЬPޠ@P` ЬPHЬRЬP(\؞HQPaЬPH=ЬP>HP<`P@H+ЬP(ЬP>HP<`P@HP UUID_$EQUAL    P1  RPC_$MAX_DEBUGP 
RPC_$DEBUG RPC_$MAX_DEBUGPn VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGݬė VAXC$GPRINTF6 
RPC_$DEBUG   RPC_$MAX_DEBUG#PݬݬPĮ VAXC$GPRINTFdPPdЬPЬPJP ` ݬݬݬ RPC_$SENDTOЬP>HP<`P@HЭP^ЭQ&R&PP&R PP  
RPC_$DEBUG
 RPC_$MAX_DEBUGЭP2PPЬPݠ@ VAXC$GPRINTFЬP1fPЬRЭPѢ@1 LP                                                                                                                                                                                                                                                   1                        ' $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "                PLdPPd 
RPC_$DEBUG RPC_$MAX_DEBUG)PЭPݠЬP>HP<`PP  VAXC$GPRINTF 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬݬϋPZ VAXC$GPRINTFЬPЬ PJP ` RPC_$MAX_DEBUG* 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬk VAXC$GPRINTF ݬݬݬ RPC_$SENDTOЬRЭPѢ@.ЭR  TIMEPQPQ`ݬݬݭݬϔHPPH RPC_$MAX_DEBUG5 
RPC_$DEBUG RPC_$MAX_DEBUG#PݬݬϯPĠ     VAXC$GPRINTFP ^ T SЬPH=ЬP>HP<`P@H+ЬP(ЬP>HP<`P@HP UUID_$EQUALPQ0PP0 
RPC_$DEBUG
 RPC_$MAX_DEBUG2PݬݬPЬP>HP<`PP h VAXC$GPRINTFЬP>HP<`P@HЭR  TIMEPQPQ`ѽTЬQЭPѡ@E 
RPC_$DEBUG
 RPC_$MAX_DEBUG$PЭPݠЬPݠ@h VAXC$GPRINTFݭR1 P8PP8 
RPC_$DEBUG
 RPC_$MAX_DEBUGPho VAXC$GPRINTF 
RPC_$DEBUG     RPC_$MAX_DEBUGݽoPę VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGPЭPݠЬPݠ@ļ VAXC$GPRINTFP $^ T SPPЬPH>ЬP>HP<`P@H,ЬP(ЬP>HP<`P@HP UUID_$EQUALPbP$PP$ 
RPC_$DEBUG
 RPC_$MAX_DEBUG2PݬݬCPЬP>HP<`PPh VAXC$GPRINTFЭQPP1ЬP>HP<`P@HѽѽЬRЭPѢ@aP(PP( 
RPC_$DEBUG
 RPC_$MAX_DEBUG@Pݬݬ    ϯPЬPݠ@ЭPݠݽPhD VAXC$GPRINTFЬP>LP<`RЭP2 PPPRP16ЭRЬPѢ"@1$ PP  
RPC_$DEBUG RPC_$MAX_DEBUG(ЭPݠ"ЬPݠ@ЭP2 PPĦ VAXC$GPRINTF   
RPC_$DEBUG
 RPC_$MAX_DEBUG(PЭP2 PPЬP>LP<`PP VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGЭP2PP VAXC$GPRINTFЭQPPhЭQ(R(PP(R PP  
RPC_$DEBUG
 RPC_$MAX_DEBUG/ VAXC$GPRINTFЬP    ЬPJP ` ݬݬݬ RPC_$SENDTOЬP>LP<`RRЭP>RP<`PRPxЭR  TIMEPQPQ`ЭRЬP>LP<`PPPPQRPQ`ЭRЬP>LP<`PPPP ЭRЬPޠ@Q"Pa`PPݭݬ
PPЭQPP1P ^ T SЬPHЬRЬP(ОHQPaЬPH=ЬP>HP<`P@H+ЬP(ЬP>HP<`P@HP UUID_$EQUALP1 dPPd,PP, RPC_$MAX_DEBUGW 
RPC_$DEBUG
 RPC_$MAX_DEBUGhQ VAXC$GPRINTF 
RPC_$DEBUG RPC    _$MAX_DEBUG"ݬݬϓPhĈ VAXC$GPRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTOЬP>HP<`P@HЭR  TIMEPQPQ`ЬP
ЬPJP ` RPC_$MAX_DEBUG) 
RPC_$DEBUG   RPC_$MAX_DEBUGPݬh VAXC$GPRINTF ݬݬݬ RPC_$SENDTOݭP ^ S RPP 
RPC_$DEBUG
 RPC_$MAX_DEBUG9ݬݬχPЬPPPPP 
RPC_$PKT_NAMEPh VAXC$GPRINTFP t^ W VЬRRR    ޼R bЭR>HR<bRR   kЭRH_RRRR 
RPC_$DEBUG5 
RPC_$DEBUG
 RPC_$MAX_DEBUG#ݬЭR>HR<bRR8 VAXC$GPRINTF޼RЏ bЭR>FR<bRR lЭRF`RRRR 
RPC_$DEBUG6 
RPC_$DEBUG RPC_$MAX_DEBUG$ݬЭR>FR<bRRV VAXC$GPRINTF޼RЏ bЬRRޭRЬb<RR1PЭTRRЭSRRcdRR<RRL  TIMEPRRLЭRբ81 ЭRѢ8L| RR  RR      
RPC_$DEBUG RPC_$MAX_DEBUGPt VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGݬǔ VAXC$GPRINTFݭݏ ݬϣЭR8RLbݏt
  ǵ 	RPC_$LOCK޼TSR   SETJMPPDRݢD 
PFM_$_CLEANUPЭd޼Rb  RPC_$UNLOCK޼R^(bn PFM_$SIGNALЭRRRRRխݬݬݬVP RPC_$MAX_DEBUG3 
RPC_$DEBUG RPC_$MAX_DEBUG!Pݬ<RB VAXC$GPRINTFݭݬ    <RB<Rbլ6ЭRNR 
RPC_$ENCR_RGYSBc"ݬЭRNR 
RPC_$ENCR_RGYSBcR޲Rb ݬ PFM_$_RLS_CLEANUP RPC_$UNLOCK< ^Ь SR SETJMPPDRݢD 
PFM_$_CLEANUPЭѭ  TIME  
ERROR_$C_TEXT  TIME  TIME  TIME  TIME  TIME 
  p  < RPC_$SERVER_TO_CLIENT_HANDLE 
      RPC_$GET_MY_ACTIVITY 
    | 
RPC_$REGISTER 
    | RPC_$REGISTER_MGR 
     RPC_$UNREGISTER 
     | RPC_$REGISTER_OBJECT 
  t       SCAN_ACTIVITIES 
     RPC_$START_ACTIVITY_SCANNER 
     RPC_$GET_CALLERS_ADDR 
  ;   RPC_$INT_LISTEN_DISPATCH 
  L?  < RPC_$LISTEN_DISPATCH 
  @    RPC_$SET_FAULT_MODE 
  4@  < RPC_$INQ_OBJECT   խݭ RPC_$FREE_LINKED_PKT^(n PFM_$SIGNALЭR>JR<bRRݭ RPC_$ALLOC_LINKED_PKTPݬݬݬݬݭݬ RPC_$INT_LISTEN_DISPATCHݭ RPC_$FREE_LINKED_PKTݬ PFM_$_RLS_CLEANUP  ^ QPPPPP< ^ЬЭR    ݬݬݬ RPC_$INQ_OBJECT_CLIENT6PЭRТѽ޼RЏ b޼SЭRТ.R(c޼R b  ^ Q޼P `ЬPРѽ\PP\޼PЏ ` PPЭPՠz޼PЏ `ЭPРzPP ^ R޼P `Ь  |  
quit_activity      `  
do_request     D1  do_ping J  
  4  do_ack     P6  do_fack a    9  do_quit     d;  
do_bad_pkt j     ;  rpc_$int_listen_dispatch |    L?  rpc_$listen_dispatch          @  rpc_$set_fault_mode $     4@  rpc_$inq_object d     @  rpc_$inq_sauth ^     @  rpc_$set_server_encr i     dA  rpc_$inq_server_encr J     A  rpc_$register_authtype h       B  rpc_$set_auth_logger      ,B  rrpc_$inq_interfaces    		T      
		 
 
!               
	      	  

 	   
$           
            	 		            
         
              
 	       
   	   	   	      
                     	    PРѽ\PP\޼PЏ `.PЭPՠ~ЭPݠ~ЭPް~P`PްP`ЭPЬ~P  ^ Q޼P `ЬPРѽ\PP\޼PЏ ` PPЭPР~PP ^ RѬ   ޼PЏ `@+ݏ    RPC_$MALLOCP@ ЭP @@       ЬPЬ@@޼P     ^ P D| ^ V ޼R bHm޼RbcP<Rď`   RBƗ.ЬScTcRRcďV   T޼S<Rď`   R(V B@DcRRH޼RbPЬScRRc޼R b P ` `      P~    OP 1y       	       	  	
   	        
  	V    	   		 U 
  @    RPC_$INQ_SAUTH 
  @   RPC_$SET_SERVER_ENCR 
  dA    RPC_$INQ_SERVER_ENCR 
  A   RPC_$REGISTER_AUTHTYPE 
  B    RPC_$SET_AUTH_LOGGER 
  ,B  | RRPC_$INQ_INTERFACES  B  $CODE h  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON   $CHAR                                                                                                                                                                                                                                                   2                        'QR	 $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "                 _STRING_CONSTANTS 8 @P D1 d; d; d; d; d; 4 9 P6 d;        w w                                                                                                                                                                                                                                                                                                                                                                                                                                    1         l5R V1.0                            4     RPC_LSNV1.015-JUN-1992 16:36                   VAX C V3.1-051  P%W%     (ultrix)        %G%P   `P v":3jP
mP P 96 @ P
 Pf PRPC$:[NCK_D.LIBNCK_D]RPC_LSN.C;10"Prpc_lsn.c %d
0Prpc_lsn.c:Prpc_lsn.c: (use_family) Can't create socket ??
jPrpc_lsn.c %d
xPrpc_lsn.c Prpc_lsn.c: (use_family) Can't bind socket, errno=%d
 Prpc_lsn.c %d
 Prpc_lsn.c Prpc_lsn.c: (rpc_$use_family) Can'     t getsockname, errno=%d
	Prpc_lsn.c: (rpc_$use_family) Can't get my netaddr
<Prpc_lsn.c: (rpc_$forward) .. forwarding.. size  <= mtu, sock# = %d
Prpc_lsn.c: (rpc_$forward) .. forwarding.. does 2 sends because size  => mtu
Prpc_lsn.c: (check_for_pkt_common)  Rcvd (ptype=%s)
 Prpc_lsn.c: (listen) Spurious quit_activity fault ignored
:P(listen) Exiting, st=%08lx
VPreadfds=%X
bPnfds=%d
kPrpc_lsn.c:%d vaxc$errno %d errno %d
Prpc_lsn.c:%s
Prpc_lsn.cPrp     c_lsn.c: (await_pkt) select failed: %d, errno=%d
Pwhich < n_socketsPRPC$:[NCK_D.LIBNCK_D]RPC_LSN.C;10PRPC$:[NCK_D.LIBNCK_D]RP   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$DEBUG  RPC_$MAX_DEBUG  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EB     CDIC_TO_ASCII  
RPC_$STATS  
RPC_$DEBUG  
RPC_$LOSSY  
RPC_$SHUTDOWN  
MSG_OUTPUT  RPC_$TERMINATION_FAULT  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$PERIODICALLY  RPC_$SENDTO  
RPC_$RECVFROM  RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$DIE  RPC_$START_ACTIVITY_SCANNER  RPC_$INT_LISTEN_DISPATCH  UUID_$EQUAL  RPC_$LISTEN_DISPATCH  
RPC_$REGISTER  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$MAX_PKT_SIZE  SOCKET_$SET_PORT       
PFM_$_CLEANUP  PFM_$_RESET_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLEC_LSN.C;102P"rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
tPmispacked header stuff messed upPRPC$:[NCK_D.LIBNCK_D]RPC_LSN.C;10PRPC packet checker  P ^޼R޼P`QbPQ`ݬ  
MSG_OUTPUTRRݬ 
SYS$PUTMSG޼Q޼RbPaRPb2 P ^ R  ޼P<`PPPPЬP  P@ STRNCPY2  P ^ R T S޼P `ݏ   b 	RPC_$LOCK       RPC_$UNLOCK޼PЏ ` ݬ SOCKETPխR RPC_$UNLOCKݏ   ߢ" VAXC$GPRINTFߢ0 PERROR 
RPC_$DEBUG RPC_$MAX_DEBUG
Pߢ: VAXC$GPRINTF޼PЏ `ݭ SET_SOCKET_NON_BLOCKING ݬ MEMSET޼P`լݬݬݬݬ SOCKET_$SET_PORTݬݭ BINDPcݏ   ߢj VAXC$GPRINTFߢx PERROR 
RPC_$DEBUG
 RPC_$MAX_DEBUGd  VAXC$GPRINTFd0޼PЏ `P޼PЏ `1P߭ݬݭ      GETSOCKNAMEPQݏ   ·  VAXC$GPRINTF  PERROR  
RPC_$DEBUG
 RPC_$MAX_DEBUGd  VAXC$GPRINTF޼PЏ `1 P޼PЭ`ݬ߭ݬ SOCKET_$INQ_MY_NETADDR޼P`% 
RPC_$DEBUG
 RPC_$MAX_DEBUGP	 VAXC$GPRINTFQPݬݭݬݬ SOCKET_$SET_NETADDR2 PP@ PPЭ PP  RPC_$UNLOCK޼P ` RPC_$UNLOCK CLOSE_SOCKET  ^ݬݬݬ ݬGP  ^ݬݬݬЬQЬP<APPݬ     | ^ Vݬݬݏ   ݬݬ 
RPC_$RECVFROMPխ P zЬRRʏRRgЬR(  UUID_$EQUALPOЬR @CЬR L7ЬRЬRЬRЬR޼R(b ЬRRʏRR1 ЬЬRRʏRR=ЭR(PЭR(( ЭRޢ@Rb ЭR>LS Rcb PЬSЭRdЬSЭReЬSЭRfЬSЭRg޼SЭR(Pc ЬR>JRb<RR2<UЬT<SЭRChEPRRRR<RRЏ   PP< (^Ь޼$R bݬݭݬ     "P޼$RЏ bRRЬ޼RЭbڭ<RR.ЭTRRЭSRR cdRR<RR޼SЭRRRRRRRc޼SЭR(c޼ SЭR(  | Π^ VЬݬ޼R<bRR SOCKET_$MAX_PKT_SIZEP   PP(P RRЭR,ЭR-ЭR.ЭR/ЬRRRЬb<RR/ЭTRRЭSRRcdRR<RRЬ͸RRʹRЬb<RR0PЭTRRЭSRRcdRR<RRЭR>JR<bRRRfЭR>JR<bRRRRЭRP0      MEMCPY 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬ< VAXC$GPRINTF ʹݬ RPC_$SENDTOePRRR b 
RPC_$DEBUG
 RPC_$MAX_DEBUGP VAXC$GPRINTF ʹݬ RPC_$SENDTO ʹݭݬ RPC_$SENDTO| ^ V T <S2 RRRSR1 P<PP@ R bS޼U<PP@ Rz  bP{ PQPPRxRRRRRCeRR1 ߭<PP@ RbPvPRRRRf 
RPC_$DEBUG RPC_$MAX_DEBUG&PRRRR      
RPC_$PKT_NAMEP VAXC$GPRINTFݭ<PP@ RbE RPC_$LISTEN_DISPATCH١RR<P2 RRRPR1P  ^ S< RR  MEMSET <T2 RRRTRU<\\L \ lRT<\\L \z  lP{ PQPP\x\\Bd\\Bd\\<P2 \\\P\R\ Ьb  ݏ@    
SELECT_NCKPխ< RRP@^ V X W \zSzR SETJMPPDzzRݢDf 
PFM_$_CLEANUPfѭ3 
RP     C_$DEBUG RPC_$MAX_DEBUG
  VAXC$GPRINTFz  PFM_$_RESET_CLEANUPjPѭ ^խ9^(n RPC_$TERMINATION_FAULTP& 
RPC_$DEBUG
 RPC_$MAX_DEBUG^(n: VAXC$GPRINTFխ^(n PFM_$SIGNAL
P  PFM_$ENABLE   r MEMSET <S2 RRRSRd<RRB RbRR	RR SrTz  P{ PQPPRxRRCdRRCdRR<S2 RRRSR j n 
RPC_$DEBUG!rV VAXC$GPRINTFݭb VAXC$GP     RINTFߡ RR j  rݭ 
SELECT_NCKP RR խ1  g1  
RPC_$DEBUG
 RPC_$MAX_DEBUGPghݏ  k VAXC$GPRINTF 
RPC_$DEBUG RPC_$MAX_DEBUGƐ VAXC$GPRINTFƞ PERROR 
RPC_$DEBUG RPC_$MAX_DEBUGgݭƨ VAXC$GPRINTF1]P 2 RѭRURB R bSrTRB Rz  bP{ PQPPRxRRRRRCdRRPRR2 RѭR2 RѭR"Pݏ   _ASSERT  ABORTRB RR     ݏ     RPC_$ALLOC_LINKED_PKTP ߭ЭRݽPzPݭݭݭݽ RPC_$INT_LISTEN_DISPATCHЭR>R<bRR?ݏ<   	RPC_$LOCKЭR>R<bRRݭ RPC_$FREE_LINKED_PKT  RPC_$UNLOCK 1I 1խݭ RPC_$FREE_LINKED_PKTz PFM_$_RLS_CLEANUP ^ S R= 
RPC_$DEBUG RPC_$MAX_DEBUG+  2 VAXC$GPRINTFݏe  Õt RPC_$DIEѬ
PЬPPЭ           4ݬ RRPC_$SERVER_EPVr 
RPC_$REGISTER $  PFM_$SIGNAL  _ASSERT  ABORT  VAXC$GPRINTF  PERROR  MEMSET  MEMCPY  STRNCPY  SETJMP  GETSOCKNAME  BIND  SOCKET  
SYS$PUTMSG  
MSG_OUTPUT  CLOSE_SOCKET  SET_SOCKET_NON_BLOCKING  
SELECT_NCK  
SELECT_NCK 
       SELECT_HANDLER 
  L    
MSG_OUTPUT 
  (    RPC_$USE_FAMILY 
  H    RPC_$USE_FAMILY_WK 
  ,  < RPC_$LISTEN_RECV 
    | RPC_$FORWARD 
     RPC_$LISTEN 
      
R     PC_$SHUTDOWN 
      RPC_$ALLOW_REMOTE_SHUTDOWN   R    RPC_LSN      select_handler L     L   
msg_output @        
use_family     (  rpc_$use_family      H  rpc_$use_family_wk +     t  
s_recv_pkt     ,  rpc_$listen_recv        rpc_$forward       check_for_pkt_common -    	  
check_for_pkt      	  rlisten       rpc_$listen        
rpc_$shutdown    !    rpc                                                                                                                                                                                                                                                   3                        # $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "                 _$allow_remote_shutdown         rrpc_$shutdown  L     T  rrpc_$are_you_there      d  rrpc_$inq_stats    		9Y      	   


      
	 ح ߀ 
  8!             v     		  
     RRPC_$SHUTDOWN 
  T    RRPC_$ARE_YOU_THERE 
  d    RRPC_$INQ_STATS    $CODE $  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON   $CHAR_STRING_CONSTANTS RPC_$START_ACTIVITY_SCANNER÷]PP RPC_$PERIODICALLY䐏     1       
 V1.0                            2     U_PFMV1.024-JUN-1991 14:30                   VAX C V3.1-051 P%W%     (ultrix)        %G% P
INTO u_pfm signal_handler for signal #%d.
-----------------
>P*** Exiting: exception caught by PFM system cleanup handler
*** %s
  P< ^ 
RPC_$DEBUGݬ  VAXC$GPRINTFЬPP EP	?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  PHRRݬ SIGNAL^(      PFM_$SIGNAL  ,^ \լ,  VAXC$ESTABLISH  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL 
 SIGNAL  SIGNAL  SIGNAL ,^ Rx\\ VAXC$ESTABLISHi\\ SIGNALW\\ SIGNALE\\ SIGNAL3\\ SIGNAL!\\ SIGNAL\\ SIGNAL\\ SIGNAL\\
 SIGNAL\\ SIGNAL\\     SIGNAL,  ^ˏPP   ^ QЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII 
    PFM_$FAULT_INH_COUNT  
RPC_$DEBUG  PFM_$SIGNAL  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$SIGNAL  EXIT  
VAXC$GFPRINTF  VAXC$GPRINTF  LONGJMP  VAXC$ESTABLISH  SIGNAL  SYS$EXIT  
ERROR_$C_TEXT 
      L    	PFM_$INIT 
  d    
PFM_$_CLEANUP 
      PFM_$_RLS_CLEANUP 
      PFM_$_RESET_CLEANUP  QѬ ޼PЏ `б  ޼P `  ^ Q޼PС `Ь ޼P     ^P  ^  PFM_$INHIBIT_FAULTSP  ^  PFM_$ENABLE_FAULTSP ^ RТP\\P   ^ P\\ՠ ^ W VЦ խYլ
  EXITH 7ݏd   ߭^(n 
ERROR_$C_TEXTPݭߧ>  
VAXC$GFPRINTFݏ SYS$EXITж  զ ЭRRRլЏ    
PЬRRݭЭR LONGJMP< ^ ^(n PFM_$SIGNAL 'PQ - ] 9 i   E  u u      R    U_PFM      signal_handler         remove_signal_handler      x  install_signal_handler      L  	pfm_$init      d  
pfm_$_cleanup P       pfm_$_rls_cleanup ,       pfm_$_reset_cleanup $       inhibit_faults        pfm_$inhibit 
       pfm_$enable 
     ,  pfm_$inhibit_faults     #     P  pfm_$enable_faults      l  pfm_$signal      ,  	pgm_$exit    		                  	
 	 
						  1 
      PFM_$INHIBIT 
      PFM_$ENABLE 
  ,   PFM_$INHIBIT_FAULTS 
  P    PFM_$ENABLE_FAULTS 
  l   PFM_$SIGNAL 
  ,  < 	PG     M_$EXIT  E  $CODE 0   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON    $CHAR_STRING_CONSTANTSo  -         w w #: %ld
hPMy  SEQ # Is: %ld
{POperation  #: %d
PInterface Hint: == NO_HINT
PInterface Hint: %d
PActivity  Hint: == NO_HINT
PActivity  Hint: %d
PFragment #: %d
PPkt Body: %D.  bytes
PNULL Pkt body..
$Prpc_$fault Code: 0x%08X, %ld.
CPrpc_$reject Code: 0x%08X, %ld.
cPPin      5R  SUKONNIK    RPC_LSN  `slΕ  SUKONNIK    RPC_LSN                                                                                                                                                                                                                                                                                                                                                                                                                                                           1       Ε V1.0                           a4     RPC_LSNV1.0 1-JUL-1992 14:27                   VAX C V3.1-051  P%W%     (ultrix)        %G%P   `P v":3jP
mP P 96 @ P
 Pf PRPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11)Prpc_lsn.c3Prpc_lsn.c: (use_family) Can't create socket ??
cPrpc_lsn.cmPrpc_lsn.c: (use_family) Can't bind socket, errno=%d
 Prpc_lsn.c Prpc_lsn.c: (rpc_$use_family) Can't getsockname, errno=%d
 Prpc_lsn.c: (rpc_$us    e_family) Can't get my netaddr
Prpc_lsn.c: (rpc_$forward) .. forwarding.. size <= mtu, sock# = %d
\Prpc_lsn.c: (rpc_$forwar d) .. forwarding.. does 2 sends because size  => mtu
Prpc_lsn.c: (check_for_pkt_common)  Rcvd (ptype=%s)
Prpc_lsn.c: (listen) Spurious quit_activity fault ignored
P(listen) Exiting, st=%08lx
3Prpc_lsn.c=Prpc_lsn.c: (await_pkt) select failed: %d, errno=%d
qPwhich < n_socketsPRPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11PRPC$:[000000.NCK_    D.LIBNCK_D]RPC_LSN.C;11P"rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
Pmispacked header stuff messed up8PRP   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$DEBUG  RPC_$MAX_DEBUG  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EB    CDIC_TO_ASCII  
RPC_$STATS  
RPC_$DEBUG  
RPC_$LOSSY  
RPC_$SHUTDOWN  RPC_$TERMINATION_FAULTp  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$PERIODICALLY  RPC_$SENDTO  
RPC_$RECVFROM  RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$DIE  RPC_$START_ACTIVITY_SCANNER  RPC_$INT_LISTEN_DISPATCH  UUID_$EQUAL  RPC_$LISTEN_DISPATCH  
RPC_$REGISTER  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$MAX_PKT_SIZE  SOCKET_$SET_PORT  
PFM_$_CLE    ANUP  PFM_$_RESET_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE C$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11aPRPC packet checker  P ^ R T S޼P `ݏ   b 	RPC_$LOCK  RPC_$UNLOCK޼PЏ ` ݬ SOCKETPխ> RPC_$UNLOCKߢ) PERROR 
RPC_$DEBUG
 RPC_$MAX_DEBUGߢ3 VAXC$GPRINTF޼PЏ `ݭ SET_SOCKET_NON_BLOCKING ݬ MEMSET޼P`լݬݬݬݬ SOCKET_$SET_PORTݬݭ     BINDPOߢc PERROR 
RPC_$DEBUG RPC_$MAX_DEBUGPd ߢm VAXC$GPRINTFd0
޼PЏ `޼PЏ `1 P߭ݬݭ GETSOCKNAMEPA¢  PERROR 
RPC_$DEBUG
 RPC_$MAX_DEBUGPd¬  VAXC$GPRINTF޼PЏ `1 P޼PЭ`ݬ߭ݬ SOCKET_$INQ_MY_NETADDR޼P`% 
RPC_$DEBUG
 RPC_$MAX_DEBUGP  VAXC$GPRINTFQPݬݭݬݬ SOCKET_$SET_NETADDR2 PP@ PPЭ PP  RPC_$UNLOCK޼P `     RPC_$UNLOCK CLOSE_SOCKET  ^ݬݬݬ ݬP   ^ݬݬݬЬQЬP<APPݬR| ^ Vݬݬݏ   ݬݬ 
RPC_$RECVFROMPխ PzЬRRʏRRgЬR(  UUID_$EQUALPOЬR @CЬR L7ЬRЬRЬRЬR޼R(b ЬRRʏRR1 ЬЬRRʏRR=ЭR(PЭR(( ЭRޢ@Rb ЭR>LS Rcb PЬSЭRdЬSЭReЬSЭRfЬSЭRg޼SЭR(Pc                                                                                                                                                                                                                                                   4                        a $      RCP011.B                         E9  [B]RPC$LIBNCK.EXE;4                                                                                                                                          Ğ 
            -zFcx>M/l=נ*GF+%^`y1 XkЯƶ%-G^Mdz0@@	BSyh: lF/.[6@/?W6U̢FOPJ3%TkUYy[?aRtչO}b[V(n7ǆ1u.zn.#6'},0eI;2jH!=eS)=tHgy3%2
XKk#[" )DQQx5ļZ8	Y(Jf{4fڲ8 ?-Ћ:` я(9&W2(f e rP[(_.VV 1,1azKў0.Lvg>ܔG<\#>К%
cұ"wIn`+3u,K= |gכzWVrXϲ;LQQ4Țq4IYRXE#i\k]e$XFV@}lbVw
}m'mGޞpePXO'l_
]j0#@[Ԙ/i89V
wSL{(}UUq#5r'ImΖWK$&D+0q[kL"=*,STs%ԛȱ,Qޯ3c7_J7:1U<dP4(*_![GX6B/r/
'q';KYAЁzMJ|nE|Yv5*ON@xICֽy!\L8Hf寇^S}j8;gC萻jnbWPc% I?_y`5,t[6q9ո~y@xb1T['odS(peN_.(6|)>e\ȍo<0w!jJx4仔؜u[0ÌU3+b6M|N\&n	zό~)H^TRp#lZ帜t[ٷj<'Q苇8BQxʿl~
?JsfMޔxDkPZP|u{a' Ν"&g%"f!r#gW'ssڷXt)
5+8I  3\q7/߬KHaarv+&ij=o%V/Zq;K==[F@AQTks[|Mk[sYXeۈ5S@MTPu.Kd
Ԃrcי/8?ZՍVTbky"sz=;,w|nk{L_
UZ6JmO_1l:+WdwUH?6}yעH2=}0pF6O)P%k?KR? t11vYr 2gC7xX$"*IE*l+xJKY
98![g^k`CEz</hi'j_ݛ|7YͣϾJ7L8k%Z%;N|jh[
(247 h1KAMAEn
Ѝ,=WAp~FwV<c"2#>Pʫp ֓4XM[(%ޒ.B[}4t~dF8SA)hif& =|	6u]iA`XsguyZH+}u\$;ԫx^ٲBpi[EUOT@7M`yGA%oA;$+i	 7mlzGvno	+gflTH=h#M&۵L3>%ff(O/rp'mcaZyp_PI!omx>c8x:FbShH<oE{in9iCٮ_7P=miAilLDCR{WA [x@i-Cu&r|lׯե5@e<.g+zIlH%:0ZQY&kǟse/BPr <QONzz&ʓfN6o5LwЦgCEA#׹xFFk:BXby>ibbՎ+xvs4CA홯y9"ᎿoK{ IjGvE?S}43߲I{5?t0,eO&pfH59{9	8?E\&C}Ԫh
d'#7<VS
La,hXk[D BkiHE3zY{y>a;Z|mz(Ԙ6a)xyYLL5f'{4b	dԟ2o>8[E]8qcƼ];SKյ|*tȋ9]-42UuNYeyĥű`ַ?Zk| > @iڐqmOm I,F5]6p}Rjř)
qoC|Z	`VFāBU:ܩBHg) i ~Xur=vq!)pzAT=}Jk+8Ænv8rG;q6wQg{u7c8F)xn쾇Ɠl)j^Y% (ZL6]ɾyA3!亏:9eAT#d̺|} /rg9?kRcPŮ^N./ٚ泮/gW>^ 6#$=-*;ƂWq@ltih#B_L'@/O|]Uۯ[4ސѪLtF[\Ԇ8.i
yzQyB܏/nӉfJf
Xȏ.p<I5=irf	T6/`߲aT9j$Lm?'!sﲔu]_E_w)uDϚD3(e`56$V(ğp7D
FatL E|uʵ+a霳
6##2=xIB^?pyԇז/*.vsؘ^摰9]JT8wenv%%4;Lɩ
u%Bu:mi9螊	,@fLn<2lz|#zsTC+Xr}J4E1GVې&>Xx+6oW6Z᮷4-(+F9T9cIVͽ4s/?]Ûc5pZ78pX$Km=xVg]&J'{{II}77ő(f%o1#Y`zwZU(A۷Fis2e/)~]mA cb_'uP	dԈt߼<T)eͬ$N
J\֝)RsviƺrSz
jL=;M}hD'7מ-嘂pDĔMP3$^bYl8a1Qf^$5+U)T&w˫4uohΫmMf2_'3%Al
tktt 6|ߦ^{ZOeR7Є-S"^^U5sE7	6	d,j<ɔ@NwHK/SP	8.;?{dbQ+frė~⍅av)4-toOK+\j>oQ!4Μy`%"N
t\ߠ,s!UH<E^e,=+q6C
ẩYMzLvuviZ25u%Z]4-x~i{̥cKsH>p%.~P
PAtuY d7JA-iމޕc&5F-cK6@W8w
,HVE7j]wf=%kfBUjX[Mv-I<4\Rrj.?i^Fzeh'U
x9Bq{ #w{w0YLS mjrBz 	18ӗ
s=`If')kmNI4YǫLcE,p\;kfSdN`ψW=r!<0ZyKEY'nqk"tMoc`j'pC@ot,Ⳍwt!!jB:`h
fh &ei]d;Ho>Lď3L3/x}Ô,T9(9Tfq ^ẅ́#(mbq;:AT6X@B=6MkEaOo=imrDR=O?yJs񖬥qcF YC3N{
,].ة''uy¤7t|p'јG\ENHbreߕV#S<(N~
ǂN0)D,5jyYbN>hM_qMJx޲|xyӶb缵
$bXep^=/GGK(C?oz2JzK QjӋ3W1v1ܟl[3_i5qKDT3֋(l$%*δ0;(`kER:t)V>C^AX]N)Kd*Y9k 	m}2-cP->?_8朗;{Q*BenNG&>9H'qP`/g̈⿘Poe
Xu `F*?4}	{JOkF<'u^g80ÑIF
FJZv۫"k&'Xp5TewZ/{7Q=0F0O%Ŀ4#c*Jwf}diD¾Yg>Vjl8 ܵz
Xצ5w$&̸LKX	OfjGG_pg"@|ߎU(pmR[TU!X"rDF4K{ ʘL:qOcXV\*EKo\4w`x2ˏvqZ}]HMx+4J++yMbSBƘ!+tKHZA02LO$Rj4PyxFcox<zø Zer˂gݚ ׼
X5:IT
UO-FJ;XU2CS:@nhK֓8<Jf
[3O*!h]	Sţ5PatYtH5Fc6x^H/WB?RJ풪|Rm7nmB'WDBGi%ڣO&DQZY卐ÆcWV>(c k|I0Y#Sd'ӊICg	N9S0wI\oNϤd%l.jeݑJQԽDwр0zSלgť=[o2qZqcYP(Dbŀ`=<4AmQ*Ki*154;||oSLX|~Juems!-3U	ȞH(̐40	 [G~MnbZE6"7<ICY!#H eɈ΋qzwM7jg8diCg&GrX
ra#l8_@
ܐbOEB5;#U6@hoZ:xf޶=Δ܎a$oz"vVvdF'/1mE-UjES^)_]܌61A0M{Mo
JQv)Y
WsP>a,u5t}+aȉn:7B{`>O&5k6,c:cм-cAo嚕FJ $%zdxB`A$L;=4a&}\bXEq`Js:D9;a{n(q]aU鎛Vz\ @sVؒ/N-ldgۂ@~RT\TQ?brlgu]J FǬ;خEޢM#ǡSŻgϾzE\L^A~ӵ`O6̂lЄ\W;vJZ#rZ6w/?XTwJ/G>*w炄w6\SW1..~3Qq
?\WX+Ţ+EI!K7՘nLy(
  ZyD )OX=f9?>8²1"rWK]ϯa9&$ I.^lMaG%aȜXwyKgBp/9%	Ozx4VGU.4J9`WKC-)t1ٙP +ΌK4Mc
ϰX-o 2
rt5_rKQKRwj~b߼G<TX48;D),
I|8tx@2tP@`fW#k2),DcIX+g+:IfLpzƩXTfWU*W8ǒ.\HE}l,j`3TO3CbN!0&5sۦ_Xi#ۓ#5͂!
GXClݚX*SHT#Rӹ//i"7Dim β|L}(Jj ))noL_tEځw
0Lȩ\EXEF%;Ӽ	d'J#Xf$cIuגj{GQKu^[mwD	Է8a☽~73̏TP:JS)񆸬VPYuaޫ?V7nǩ
tZt*J7S6`T%h[`6/fpnu!q[mhaI;ݭѝ)W=63T#1"|ԭT1b#*l3\%#6)ב5j^+mfn)JXUl=u?ϡքsP7%ӽ^$St E5k^.w
OρSv6VJJZv=2;YÉ"n5%o|wMUfП[Jxs*Y+/ƅ0y|Vg2x{Ώ@njˑ7^6q6g@(Z/"JU>`)~tLvVܗO)
[n4T>N]>Vڲъ)KxމI>1-4*Տ"']Gme[ KPܩ%~^q i  $#C
ק9;=]Km!_N>oTC6G*̽UpmgjDVLy:=^-?aO=2dev~"`J
:3Ԃn4jM'"ư-
x;^amz8W½?R-M' )
blp
M1Z$1{yu!dx y}(ߦC-S߭VUFvDG߱2))σER'\kJ.iɿ(A<bLL!C
V	r9$N)o%ߦ-9BVr9=Kăہ|[}Te!4m0cs+RޠWh-$4peSfQe
h	G-~wTdyˋ~})Wa&O)KG 	􆍒O{:e?C7s7vaJs-/B{*A:]:O}:
6gPkڟwuq'%O"-͜Yȓb c#00nvOJ5
ʪ.J e9"PưT                                                                                                                                                                                                                                                    5                         $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "                 ЬR>JRb<RR2<UЬT<SЭRChEPRRRR<RRЏ   PP< (^ ޼$R bݬݭݬ"P޼$RЏ bRRЬ޼RЭbڭ<RR.ЭTRRЭSRRcdRR<RR޼SЭRRRRRRRc޼SЭR(c޼ SЭR(  | Π^ VЬݬ޼R<bRR SOCKET_$MAX_PKT_SIZEP   PP(P RRЭR,ЭR-ЭR.ЭR/ЬRRRЬb<RR/ЭTRRЭSRRcdRR<RRЬ͸RRʹR    Ьb<RR0PЭTRRЭSRRcdRR<RRЭR>JR<bRRRfЭR>JR<bR RRRЭRP0 MEMCPY 
RPC_$DEBUG
 RPC_$MAX_DEBUGPݬ VAXC$GPRINTF ʹݬ RPC_$SENDTOePRRR b 
RPC_$DEBUG
 RPC_$MAX_DEBUGP\ VAXC$GPRINTF ʹݬ RPC_$SENDTO ʹݭݬ RPC_$SENDTO| ^ V T <S2 RRRSR1 P<PP@ R bS޼U<PP@ Rz  bP{ PQPPRxRRRRRCeRR1     ߭<PP@ RbPvPRRRRf 
RPC_$DEBUG RPC_$MAX_DEBUG&PRRRR 
RPC_$PKT_NAMEPƩ VAXC$GPRINTFݭ<PP@ Rb RPC_$LISTEN_DISPATCH١RR<P2 RRRPR1P  ^ S< RR  MEMSET <T2 RRRTRU<\\L \ lRT<\\L \z  lP{ PQPP\x\\Bd\\Bd\\<P2 \\\P\R\ Ьb  ݏ@    
SELECT_NCKPխ< RRP X^     V W \zSzR SETJMPPDzzRݢDn 
PFM_$_CLEANUPnѭ2  
RPC_$DEBUG
 RPC_$MAX_DEBUG VAXC$GPRINTFz PFM_$_RESET_CLEANUPjPѭ ^խ9^(n RPC_$TERMINATION_FAULTP& 
RPC_$DEBUG
 RPC_$MAX_DEBUG^(n VAXC$GPRINTFխ^(n PFM_$SIGNAL
P  PFM_$ENABLE   r MEMSET <S2 RRRSRd<RRB RbRR	RR SrTz  P{ PQPPRxRR    CdRRCdRR<S2 RRRSR RR    rݭ 
SELECT_NCKP RR խ=g33 PERROR 
RPC_$DEBUG RPC_$MAX_DEBUGPgݭ= VAXC$GPRINTF1]P 2 RѭRURB R bSrTRB Rz  bP{ PQPPRxRRRRRCdRRPRR2 RѭR2 RѭR"Pݏ  ƃq _ASSERT  ABORTRB RRխݏ     RPC_$ALLOC_LINKED_PKTP ߭ЭRݽϱPzPݭݭݭݽ RPC_$INT_LISTEN_D    ISPATCHЭR>R<bRR?ݏ  Ƭ 	RPC_$LOCKЭR>R<bRRݭ RPC_$FREE_LINKED_PKT   RPC_$UNLOCK 1I 1խݭ RPC_$FREE_LINKED_PKTz PFM_$_RLS_CLEANUP ^ S R= 
RPC_$DEBUG RPC_$MAX_DEBUG+   VAXC$GPRINTFݏ/  8 RPC_$DIEѬ
PЬPPЭ      4ݬ RRPC_$SERVER_EPVr 
RPC_$REGISTER  RPC_$START_ACTIVITY_SCANNERaPP RPC_$PERIODICALLY䐏      ϻ޼P     ^ P ޼Q     ^ Q޼P ` Ь  ^ R  ݬݬ    R    RPC_LSN      
use_family d    d  rpc_$use_family        rpc_$use_family_wk +       
s_recv_pkt     h  rpc_$listen_recv         rpc_$forward       check_for_pkt_common -    D  
check_for_pkt      $	  rlisten       rpc_$listen      t
  
rpc_$shutdown    !  
      rpc_$allow_remote_shutdown       
  rrpc_$shutdown L     
  rrpc_$are_you_there        rrpc_$i nq_stats    		S         


      
	 ح  
  8               		   PFM_$SIGNAL  _ASSERT  ABORT  VAXC$GPRINTF  PERROR  MEMSET  MEMCPY  SETJMP  GETSOCKNAME  BIND  SOCKET  CLOSE_SOCKET  SET_SOCKET_NON_BLOCKING  
SELECT_NCK  
SELECT_NCK 
  d    RPC_$USE_FAMILY 
      RPC_$USE_FAMILY_WK 
  h  < RPC_$LISTEN_RECV 
     | RPC_$FORWARD 
     RPC_$LISTEN 
  t
    
R    PC_$SHUTDOWN 
  
    RPC_$ALLOW_REMOTE_SHUTDOWN 
  
   RRPC_$SHUTDOWN 
  
    RRPC_$ARE_YOU_THERE 
      RRPC_$INQ_STATS    $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON t  $CHAR_STRING_CONSTANTS:PP޼PЏ `Pݬ 
RPC_$SHUTDOWN  ^޼P     ^Ѭ޼P 
RPC_$STATS   3`޼P `ѬЬP 
RPC_$STATS   3޼P`ѬЬP 
RPC_$STATS   3޼P`ѬЬP 
RPC_$STAT      '޼P     ^ P ޼Q     ^ Q޼P ` Ь  ^ R  ݬݬ PP޼PЏ `Pݬ 
RPC_$SHUTDOWN  ^޼P     ^Ѭ޼P 
RPC_$STATS   3`޼P `ѬЬP 
RPC_$STATS   3޼P`ѬЬP 
RPC_$STATS   3޼P`ѬЬP 
RPC_$STATS޼P`ѬЬP 
RPC_$STATSh   3޼P`ѬЬP 
RPC_$STATSl   3޼P`޼P `R        w wN    STDOUT    STDERR    ENVIRON   $CHAR_STR     S޼P`ѬЬP 
RPC_$STATSh   3޼P`ѬЬP 
RPC_$STATSl   3޼P`޼P `        w w <       rpc_$dump_ ݬ 
VAXC$GFPRINTFPåݬ 
VAXC$GFPRINTFְ <PP
G<PP@XP`<PPPP 
RPC_$PKT_NAMEPûݬ 
VAXC$GFPRINTFޡPP<PP
Tݬ 
VAXC$GFPRINTFװ <PP
F<PP@\P`<PPPP 
RPC_$PKT_NAMEPݬ 
VAXC$GFPRINTFޡPP<PP
°ݬ 
VAXC$GFPRINTF´           |     		C 
     RPC_$LISTEN 
      
RPC_$SHUTDOWN 
       RPC_$ALLOW_REMOTE_SHUTDOWN 
      RRPC_$SHUTDOWN 
  l    RRPC_$ARE_YOU_THERE 
  |    RRPC_$INQ_STATS    $CODE $  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON   $CHAR_STR     ING_CONSTANTSN&  
RPC_$STATSl   3޼P`޼P `        w w       w wC$GPRINTF߭ЬR UUID_$ENCODE߭ VAXC$GPRINTF߭ЬR ( UUID_$ENCODE߭ VAXC$GPRINTFЬRݢ8% VAXC$GPRINTFЬRݢ<= VAXC$GPRINTFЬRݢ@U VAXC$GPRINTF h VAXC$GPRINTFЬR>DR<bRR{ VAXC$GPRINTFЬRFƍ VAXC$GPRINTFЬR>FR<bRRƩ VAXC$GPRINTFЬRHƽ VAXC$GPRINTFЬR>HR<bRR VAXC     $GPRINTFЬR>LR<bRR VAXC$GPRINTFЬRJЬR>JR<bRR VAXC$GPRINTFP VAXC$GPRINTFЬRRRRRPP "P?P1 ݬ  RPC_$GET_PKT_BODY_STؕǸǼP^(n^(n$ VAXC$GPRINTFFPݬ RPC_$GET_PKT_BODY_STؕǸǼP^(n^(nC VAXC$GPRINTFPPݭݭc VAXC$GPRINTFݭݭݭݭݭƃ VAXC$GPRINTFP $^ R<PʏPP VAXC$GPRINTF<PʏPP      VAXC$GPRINTF<PʏPP8 VAXC$GPRINTF<PʏPPd VAXC$GPRINTF<PʏPP VAXC$GPRINTF<PʏPP VAXC$GPRINTF<Pʏ PP VAXC$GPRINTF<PʏPP	 VAXC$GPRINTFP ^ R
?	 VAXC$GPRINTF<PPE	 VAXC$GPRINTFPª	 VAXC$GPRINTFP 0^ S TլB߭ TIMEەĸļPݬݭ 	 VAXC$GPRINTF
 VAXC$GPRINTFݬG
 VAXC$GPRINTF      ѭ1 z  P{PQPPRR!խÀ
 VAXC$GPRINTFݭÂ
 VAXC$GPRINTFRz  RP{PQPPRRÉ
 VAXC$GPRINTFЭR޼PB`RRË
 VAXC$GPRINTFRRѭ pkt_hdr   
    pflags        pflags2 F       rpc_$dump_raw_pkt   		R      
	Ӥ   
                                                                                                                                                                                                                                                              6                        f"= $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         f "                           
0	

	        
s  	  	 
	
       
              
  D
   RPC_$INSERT_IN_FRAG_LIST 
    < RPC_$REASSEMBLE_FRAG_LIST 
  l   RPC_$PERIODICALLY 
     RPC_$STOP_PERIODIC 
    < RPC_$FILL_FRAG 
     RPC_$CVT_STRING 
      RPC_$BLOCK_COPY 
    | RPC_$STATUS_PRINT 
  $    RPC_$TERMINATION_FAULT 
  \       RPC_$REGISTER_ENCRTYPE 
     RPC_$DUMP_STATS 
      RPC_$DUMP_PKT_HDR 
     PFLAGS 
     PFLAGS2 
     RPC_$DUMP_RAW_PKT  -  $CODE   $DATA    ERRNO    
VAXC$ERRNO    STDIN N     STDOUT    STDERR    ENVIRON 
  $CHAR_STRING_CONSTANTS. ݬÑ
 VAXC$GPRINTF P   V         w w                                                                                                                                                   1       `
i V1.0                            3     SOCKETV1.0 3-APR-1991 08:37                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  INET_$SOCKET_HANDLER  SOCKET_$FAMILY_TO_NAME  SOCKET_$FAMILY_FROM_NAME  SOCKET_$SET_PORT  SOCKET_$INQ_PORT  SOCKET_$VALID_FAMILY  SOCKET_$INQ_BROAD_ADDRS  SOCKET_$INQ_HOSTID  SOCKET_$SET_NETADDR  SOCKET_$INQ_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$INQ_POR    T  ATOI  
VAXC$GSPRINTF  MEMSET  MEMCMP  STRLEN  STRCHR  STRNCMP  STRNCPY  P%W%     (ultrix)        %G%$P INET_$SOCKET_HANDLER PddsPipPns
PunspecPunspecPipPnsPdds"P%s:#%s)P%s:%s/P%s:#%s  P  ^ Qլ#Ѭ
2P@޼P `Џ   PP޼PЏ
 ` P ^ R޼P `  ޼Pѭ`޼PЏ `)P2PP@ЭP޼Q@aPP
޼P   ^ S޼P `޼R޼Pb` Pݬ޼P<`PP SOCKET_$VALID_FAMI    LYP1PˏPPKݬݬݬݬݬ޼P<`PPP2PP@Pް0P`P޼P`1ZP P1ˏ PPwݬ߭ݬݬ SOCKET_$INQ_NETADDR޼P`1ݬ߭ݬݬ SOCKET_$INQ_NETADDR޼P`1 Pѭݭ MEMCMPP P1 ˏPPsݬ߭ݬݬ SOCKET_$INQ_HOSTID޼P`1 ݬ߭ݬݬ SOCKET_$INQ_HOSTID޼P`nPѭݭ MEMCMPP PˏPP2ݬݬݬ SOCKET_$INQ_PORTPRݬݬ     SOCKET_$INQ_PORTRP PЏ   P޼P ` Ѭ ݬݬݬ MEMCMPP	PPPPPPP ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILY˕Pݬݬݬ޼P<`PPP2PP@Pް P`PP ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYÕP޼P`ݬݬݬݬ޼P<`PPP2PP@PްP  ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYÕP޼P`ݬݬݬݬ޼P<`PPP2PP@PްP  ^ R޼P `ݬbݬ STRNCMPP
Pݬߢݬ STRNCMPP    Pݬߢݬ STRNCMPPPݬߢ
ݬ STRNCMPP P޼PЏ
   ЏP ^ RЬPP 
  P
P^?P2PޢPP2PޢPP&PޢPPPޢPPP޼PЏ
 `޼P`ݭݬ STRNCPYݭ STRLENP޼Pѭ`޼PЭ`޼P   ^ R޼P`Ѭ  ޼PЏ `ݏ  ݬ STRNCPYЬP @PPլg:ݬ STRCHRPխ޼PЏ ` ݬìPPݬ SOCKET_$FAMILY_FROM_NAMEP޼P`ìPPPPPPPݬ    ݬ SOCKET_$VALID_FAMILYP޼P`ݏ[   ݬ STRCHRPխЬT ݏ]   PP STRCHRPխ ޼PЏ ` PP ATOIPPPìPP޼P`PPV޼P`PQP#QQ	PPݬݬݬݭPPݬݬ2P@PްP`Oݬ߭ݬ SOCKET_$INQ_MY_NETADDRݬݭݬݬ SOCKET_$SET_NETADDRݬݭݬݬ SOCKET_$SET_PORT ^ T SЏd   Џd   ݬ޼P<`PP SOCKET_$VALID_FAMILYPݬ߭(޼    P<`PP SOCKET_$FAMILY_TO_NAME޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`ЭP @߭(ߤ" 
VAXC$GSPRINTF޼P`ݬ STRNCPY STRLENP޼P`޼Rݬ STRLENPPPb޼Rݬݬ  SOCKET_$INQ_PORTP   ^ T SЏd   Џd   ݬ޼P<`PP SOCKET_$VALID_FAMILYPݬ߭(޼P<`PP SOCKET_$FAMILY_TO_NAME޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`'ЭP @    (ߤ) 
VAXC$GSPRINTF[Pݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`ЭP @߭(ߤ/    R
    SOCKET      socket_$valid_family D     D   socket_$valid_families h        
socket_$equal (      socket_$inq_port P     $  socket_$set_port X     |  socket_$set_wk_port X       socket_$family_from_name      h  socket_$family_to_name      $  socket_$from_name     (  socket    _$to_numeric_name ,    T  socket_$to_name     	  socket_$set_broadcast p     L
  socket_$max_pkt_size 
VAXC$GSPRINTF޼P`ݬ STRNCPY STRLENP޼P`޼Rݬ STRLENPPPb޼Rݬݬ  SOCKET_$INQ_PORTP  <  ^ݬ޼Rbݬ SOCKET_$INQ_PORTP޼Rbݬ߭߭߭ݭ޼R<bRR SOCKET_$INQ_BROAD_ADDRS޼Rb޼R(b޼SޭRb  ^ Rݬݬ SOCKET_$VALID_FAMILYՕPݬݬ2P@P P      PP ^ Rݬݬ SOCKET_$VALID_FAMILYP޼P` ݬ MEMSET޼P`ݬݬݬݬ2P@P P   ^  
        SOCKET_$VALID_FAMILY 
  D    SOCKET_$VALID_FAMILIES 
      
SOCKET_$EQUAL 
     SOCKET_$INQ_PORT 
  $   SOCKET_$SET_PORT 
  |   SOCKET_$SET_WK_PORT 
     SOCKET_$FAMILY_FROM_NAME 
  h   SOCKET_$FAMILY_TO_NAME 
  $   SOCKET_$FROM_NAME 
  (   SOCKET_$TO_NUMERIC_NAME 
  T   SOCKET_$TO_NAME 
  	  < SOCKET_$SET_    BROADCAST 
  L
   SOCKET_$MAX_PKT_SIZE 
  
   SOCKET_$INQ_MY_NETADDR 
  
   SOCKET_$INQ_NETADDR  Rݬ޼P<`PP SOCKET_$VALID_FAMILYP޼P` ݬ MEMSET޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@Pް P  ^ R޼Q޼P`a޼P`ݬ޼P<`PP SOCKET_$VALID_FAMILYŕPݬݬݬݬݬ޼P<`PPP2PP@Pް$P   ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYP޼P` ݬ MEMSET޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@P    (P  ^ R޼Q޼P`a޼P`ݬ޼P<`PP SOCKET_$VALID_FAMILYܕPݬݬݬݬݬ޼P<`PPP2  @     
  socket_$inq_my_netaddr d     
  socket_$inq_netaddr x     h  socket_$set_netaddr h       socket_$inq_hostid x     H  socket_$set_hostid h       socket_$inq_broad_addrs L       socket_$to_local_rep T     P
  socket_$from_local_rep K   		          	                         Y 
  h   SOCKET_$SET_NETADDR 
     SOCKET_$INQ_HOSTID 
  H   SOCKET_$SET_HOSTID 
     SOCKET_$    INQ_BROAD_ADDRS 
     SOCKET_$TO_LOCAL_REP 
  P
   SOCKET_$FROM_LOCAL_REP  
  $CODE T   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON 6   $CHAR_STRING_CONSTANTS YPP@Pް,P   ^ Rݬݬ SOCKET_$VALID_FAMILYɕPݬݬݬݬݬݬ2P@P4 P   ^ RЬݬ޼P<`PP SOCKET_$VALID_FAMILY̕Pݬݭݬ޼P<`PPP2PP@P8 P   ^ RЬݬ<PP SOCKET_$VALID_FAMILY                                                                                                                                                                                                                                                   7                        o $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         h "                 ؕPݬݭݬ<PPP2PP@Pް<P` |P, \ 8 \ \ \ D \ \ \ \ \ \ P          w w                                                                                                                                                                                                                                                                                                                                                                                                                                   1        i V1.0                            1     UUIDV1.0 3-APR-1991 08:38                    VAX C V3.1-051  P%W%     (ultrix)        %G% Psys$scratch:last_uuid.datPsys$scratch:last_uuid.dat4Psys$scratch:last_uuid.dat  P.A    A    NP%08lx%04x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x P%8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx P  ^ S T c OPENPѭ2ݏ  ߣ CREATPѭݏ  ߣ4 CHMODѭ    ݭ READPѭ`޼Rb޼RbЬP P:P޼RФbЬR> P<`QQ  QPQ`>P<`PPЬRbPPb ԼRbЬP>Q Pa`ѭ#  ݭ LSEEKݬݭ WRITEݭ CLOSE X^ T| GETTIMEOFDAYÏ PPNRD{RPNPP@PRPR޼RGgPJPPPbЬRPPQPQ`ݬIդ<1  j߭߭ SOCKET_$VALID_FAMILIESj߭n>P<`PP SOCKET_$INQ_MY_NETADDRjݭn߭ SOCKET_$SET_NETADDR     , MEMSETj߭,ݭ SOCKET_$INQ_HOSTIDPP<ЬPP `ЬP, ЬP	 MEMSETѤ<Ф<PP Pݭ.ЬP	 MEMCPY ^ RЬPPPЬPPPЬP
PPЬPPPЬPPPЬP
PPЬP	PPЬPPPЬP>P<`PP޼P`ߢN    
VAXC$GSPRINTF  ^ R??߭ ݬ VAXC$GSSCANFPѭ
޼PЏ`޼P `޼PЭ`ЬPP`ЬPЬPP `ЬP	ЬP
ЬP    PЬP
ЬPЬP     ^ ޼Q޼Pa`1 ЬQЬP1 ЬQЬP1 ЬQЬPrЬQЬP		cЬQЬP

T  R    UUID     
check_uuid @    P  	uuid_$gen `      uuid_$encode      <  uuid_$decode        uuid_$equal        	uuid_$cmp P     $  
uuid_$hash j   		j&        D0 	
     	     
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  SOCKET_$INQ_HOSTID  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$VALID_FAMILIES  VAXC$GSSCANF  
VAXC$GSPRINTF  MEMSET  MEMCPY  LSEEK  CLOSE  WRITE  READ  CHMOD  CREAT  OPEN  GETTIMEOFDAY 
  P   	UUID_$GEN 
     UUID_$ENCODE 
  <   UUID_$DECODE 
      UUID_$EQUAL 
     	UUID_$CMP 
  $        
UUID_$HASH    $CODE @   $DATA    ERRNOo     
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON    $CHAR_STRING_CONSTANTS  ЬQЬPEЬQЬP6ЬQЬP

'ЬQЬPЬQЬP	PPPPPPP ^ЬЬ ЭQPЀPaRЭQPPaPPRRխЭPЭP ^ЬЭPͽQЭP̠QЭP̠QQP̭Pʏ  PPQЭPЬRRRPRQPQ{RPPQQP       w w                                     1        @i V1.0                            2     U_PFMV1.0 3-APR-1991 08:38                   VAX C V3.1-051 P%W%     (ultrix)        %G% P
INTO u_pfm signal_handler for signal #%d.
-----------------
>P*** Exiting: exception caught by PFM system cleanup handler
*** %s
  P< ^ 
RPC_$DEBUGݬ  VAXC$GPRINTFЬPP EP	?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  PHRRݬ SIGNAL^(      PFM_$SIGNAL  ,^ \լ,  VAXC$ESTABLISH  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL 
 SIGNAL  SIGNAL  SIGNAL ,^ Rx\\ VAXC$ESTABLISHi\\ SIGNALW\\ SIGNALE\\ SIGNAL3\\ SIGNAL!\\ SIGNAL\\ SIGNAL\\ SIGNAL\\
 SIGNAL\\ SIGNAL\\     SIGNAL,  ^ˏPP   ^ QЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII 
    PFM_$FAULT_INH_COUNT  
RPC_$DEBUG  PFM_$SIGNAL  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$SIGNAL  EXIT  
VAXC$GFPRINTF  VAXC$GPRINTF  LONGJMP  VAXC$ESTABLISH  SIGNAL  SYS$EXIT  
ERROR_$C_TEXT 
      L    	PFM_$INIT 
  d    
PFM_$_CLEANUP 
      PFM_$_RLS_CLEANUP 
      PFM_$_RESET_CLEANUP  QѬ ޼PЏ `б  ޼P `  ^ Q޼PС `Ь ޼P     ^P  ^  PFM_$INHIBIT_FAULTSP  ^  PFM_$ENABLE_FAULTSP ^ RТP\\P   ^ P\\ՠ ^ W VЦ խYլ
  EXITH 7ݏd   ߭^(n 
ERROR_$C_TEXTPݭߧ>  
VAXC$GFPRINTFݏ SYS$EXITж  զ ЭRRRլЏ    
PЬRRݭЭR LONGJMP< ^ ^(n PFM_$SIGNAL 'PQ - ] 9 i   E  u u      R    U_PFM      signal_handler         remove_signal_handler      x  install_signal_handler      L  	pfm_$init      d  
pfm_$_cleanup P       pfm_$_rls_cleanup ,       pfm_$_reset_cleanup $       inhibit_faults        pfm_$inhibit 
       pfm_$enable 
     ,  pfm_$inhibit_faults     #     P  pfm_$enable_faults      l  pfm_$signal      ,  	pgm_$exit    		                  	
 	 
						  1 
      PFM_$INHIBIT 
      PFM_$ENABLE 
  ,   PFM_$INHIBIT_FAULTS 
  P    PFM_$ENABLE_FAULTS 
  l   PFM_$SIGNAL 
  ,  < 	PG      M_$EXIT  E  $CODE 0   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON    $CHAR_STRING_CONSTANTS   -         w w                                                                                                                                                                                                                                                                                                                                    	  1       `- i V1.0                            0     VMSV1.0 3-APR-1991 08:39                   VAX C V3.1-051   R
    VMS
      ffs \     \   	_findchan H        gettimeofday G   		     +      
CC$_GFLOAT 
     TIMEZONE 
 $   DAYLIGHT  FFS  FTIME 
        FFS 
  \    	_FINDCHAN 
      GETTIMEOFDAY     $CODE (   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT         STDERR    ENVIRON  P%W%	VMS/ULTRIX Connection	%G%  P  ^ЬխЏP ѭˏPP&xPPPPѭˏPPЭP ^ ЭP޼Q@a$ŭ RЭP޼Q@a FFSPRRЭP?ʘ P ^ R FTIME޼PЭ`ЬQ>P<`PPPP޼Q< PPaЬPТ$        w w                                                                                                                                                                                      1       Ui V1.0                            4     RPC_SEQV1.0 3-APR-1991 08:39                   VAX C V3.1-051   R    RPC_SEQ =    
CC$_GFLOAT      $CODE    $DATA    RPC_$SEQ %  P%W%     (ultrix)        %G%  P    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    8                        Ë $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "              1       i V1.0                            2     ERRORV1.0 3-APR-1991 08:39                   VAX C V3.1-051  P%W%  (ultrix) %G% Prpc$exe:rpc$stcode.datPstatus %lx"Pstatus %lx (%s)2Pstatus %lx (%s/%s)EP%s (%s/%s)  P ^ ޼P`KPPѭ;PЬRPPЬQPPab޼RbRRѭ޼R b <^ˏ   PP޼P `P `޼P `ޭR   OPENPbխޭP` READP1ޭP`WޭQޭPaޭPWޭPWޭQ 
  PޭPWP`VQPaPVPVQPPVѭ1PЏ xPʏ  PPPP  찏 2PP1խ1 ,ݏ   ޭP` READP   1P 2PP@P`U2PP@Q2PP@Pa2PP@PU2PP@P`T2PP@Q2PP@Pa2PP@PT2PP@PT2PP@Q2PP@P2PP@PT2PP@P`2PP@P`2Qʏ Q2PP@P2`Pʏ PQP2P   P@P`PP졭PP2PP	խ1}ѭ1P ݭޭP` LSEEKݏ   XޭP` READ>XP`S>XQ>XPa>XPSZP`RZQZPaZPRݬ\ݬQխ1ݬ͜ݬ6ˏ  PPPPX
Z1 Xݏ   XޭP` READ #P2P@X	PP=  谭걭 \PPP2PP	޼P ``ЬQPP2P@Xa2P@X
޼P `5PP걭 ݏ   XޭP` READ    1vPޭPݠ  CLOSE| ^ Vݏd   ݏd   4ݏd   ߭^(n ERROR_$C_GET_TEXTޭRbݬߦݬe  R    ERROR      xstrcpy d     d   error_$c_get_text       
error_$c_text        error_$find_text    		      Z        #
    
CC$_GFLO   AT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII 
    ERROR_$FIND_TEXT_STATIC  ERROR_$C_GET_TEXT  
VAXC$GSPRINTF  STRLEN  LSEEK  CLOSE  READ  OPEN 
  d    ERROR_$C_GET_TEXT 
    | 
ERROR_$C_TEXT 
    | ERROR_$FIND_TEXT  W  $CODE >  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON P   $CHAR_STRING_CONSTANTSm 
VAXC$GSPRINTFlP4Rb߭ݬߦ"ݬ 
VAXC$GSPRINTFGPR     b4߭ݬߦ2ݬ 
VAXC$GSPRINTF4߭ߦEݬ 
VAXC$GSPRINTF P| ^ Vݏd    ݏd   vݏd   ߦ޼R^(bn ERROR_$C_GET_TEXT޼SަRRc޼SvRRc޼S RRc޼Sߦ STRLENPRRc޼Sv STRLENPRRc޼S  STRLENPRRc         w w                                                                                                                                                                                                            1    
   `UPi V1.0                            0     GLBV1.0 3-APR-1991 08:39                   VAX C V3.1-051  P%W%     (ultrix)        %G%P   `P i.;3jP
mPPő;3P
PPޑ;3P
PP Prpc$exe:glb_obj.txtPrpc$exe:glb_sites.'Prpc$exe:glb_sites.:PCan't open '%s', errno=%d
UPrpc$exe:glb_sites.hP(find_server_nbrd) Error reading '%s', errno=%d
 Prpc$exe:glb_sites. P(find_server_nbrd) Error reading '%s' - file is emp   ty
 Prpc$exe:glb_sites. P(find_server_nbrd) no more potential sites
"P(find_server_nbrd) trying site '%s'
GP(fin d_server_nbrd) error converting to sockaddr (0x%lx)
P(find_server_nbrd) family mismatch '%s' (%d) and %d
P(find_server_nbrd) '%s' LLB lookup failure (0x%lx)
P(find_server_nbrd) '%s' LLB doesn't have a GLB registered (0x%lx)
,P(find_server_nbrd) LLB lookup result %d, invalid family (%d)
jP(find_server_nbrd) LLB doesn't have GLB registered with valid    family
P'couldn't convert name'P(find_server_nbrd) GLB registered at '%s[%ld]'
P(find_server_nbrd) couldn't set glb bindi   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  	UUID_$NIL 
 t   GLB_$HANDLE 
 x   GLB_$UID 
    
GLB_$TYPE_UID 
   GLB_$DEFAULT_OBJ 
   GLB_$DEFAULT_TYPE  
RPC_$DEBUG  RPC_$MAX_DEBUG  GLB_CA_$GET_OBJECT_UUID  UUID_$EQUAL  
PFM_$_CLE   ANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  SOCKET_$TO_NAME  SOCKET_$FROM_NAMEng (0x%lx)
-P(find_server_nbrd) RPC runtime failure on glb lookup(0x%lx)
P
      jPglb.c: check_binding()  finding server...glb_$client_epv.glb_$find_server = 0x%X
  P| 4^ VЏ    OPENPѭ*%߭ݭ READP%ݬ߭ UUID_$DECODEխ
޼R(ƀb ^ R ߢ ACCESSP	P \\P ^ S R޼P    `¤¤ CLOSEЏ¤ ¨ ߣ' OPENP¤¤4 
RPC_$DEBUG  RPC_$MAX_DEBUG ߣUߣ: VAXC$GPRINTF޼PЏ `P  ^ \̤̤ CLOSEЏ  < h^ U S T 쐏 Ĩ   LSEEKݏd   Ĥ READPѭ
cPѭ1 
RPC_$DEBUG
 RPC_$MAX_DEBUGcř ߥh VAXC$GPRINTF޼RЏ bխXG 
RPC_$DEBUG RPC_$MAX_DEBUG Ŭ  VAXC$GPRINT   F! 
RPC_$DEBUG RPC_$MAX_DEBUGP  VAXC$GPRINTF޼RЏ b PPͯPPЭRPPRM
GPЭRPPЭQPPܐabĨPPĨЭQPPQ
P ѭĨPPĨͯPP#ͯPPͯPP 1r 
RPC_$DEBUG RPC_$MAX_DEBUGPͯ" VAXC$GPRINTFݬ߭ ͯ STRLENPRRͯ  SOCKET_$FROM_NAME޼Rb+ 
RPC_$DEBUG RPC_$MAX_DEBUG޼RbG VAXC$GPRINTF1P<RR2 
RPC_$D   EBUG
 RPC_$MAX_DEBUGݬ<RRͯŀ VAXC$GPRINTF1 	UUID_$NILx   UUID_$EQUAL͕P	x ݬ߭ ߭ݭb 	UUID_$NILx
 LB_$LOOKUP_RANGE޼Rb/ 
RPC_$DEBUG RPC_$MAX_DEBUG޼Rbͯŵ VAXC$GPRINTF1"խ/ 
RPC_$DEBUG RPC_$MAX_DEBUG޼Rbͯ VAXC$GPRINTF1PPѭoݬЭP>xP<`PP SOCKET_$VALID_FAMILYPP 
RPC_$DEBUG RPC_$MAX_DEBUG PЭP>xP<`PP   , VAXC$GPRINTFPP䏈   PPѭѭ" 
RPC_$DEBUG
 RPC_$MAX_DEBUGj VAXC$GPRINTF1BЏd   ݬ߭ĬЭRݢtЭRx SOCKET_$TO_NAME޼RbŰĬ STRCPY  
RPC_$DEBUG
 RPC_$MAX_DEBUGPݭĬ VAXC$GPRINTFݬЭRݢtЭRxݬ RPC_$SET_BINDING޼Rb, 
RPC_$DEBUG RPC_$MAX_DEBUGP޼Rb VAXC$GPRINTF1wPRP SETJMPPDPݠDͫ 
PFM_$_CLEANUPͫ   ww ( 
RPC_$DEBUG RPC_$MAX_DEBUGPw- VAXC$GPRINTF1	Ĝ {Ĝ ݬ RPC_$SET_SHORT_TIMEOUT {߭߭ 	UUID_$NIL 	UUID_$NILxݬ GLB_$CLIENT_EPV   3R	b{ PFM_$_RLS_CLEANUP޼R    ^ W V Ƙ 	զtPզt 	UUID_$NILx UUID_$EQUALP	xϱ Ƙ  P)Ơݬ@޼Rb޼R^(bn PFM_$SIGNAL똏 զtݦt RPC_$FREE_HANDLEЭRB SOCKET_$V   ALID_FAMILYP1ЭRBx RPC_$ALLOC_HANDLEPtRRRb1Ɯ Ɯ ݦt  RPC_$SET_SHORT_TIMEOUT򞭨SR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ) Ƙ Rˏ  bRR  ^(n PFM_$SIGNALɞRb >խЭRѭB޼SRbcݦt RPC_$FREE_HANDLE tƠ χRb nƠ8 
RPC_$DEBUG RPC_$MAX_DEBUGP GLB_$CLIENT_EPV   3j VAXC$GPRINTFݦt GLB_$CLIENT_EPV   3Rb,   ЭRBݦtUխ^(n PFM_$SIGNALƘ Rb   PFM_$ENABLEP  PFM_$_RLS_CLEANUPƘ !Ơ    P  ^ P   P| ^ V 	UUID_$NILx UUID_$EQUALܕP	x5լ	޼R(xbP ^ R޼P `ݬPݬݬݬݢt RPC_$INQ_BINDING ^ R  GLB_CA_$GET_OBJECT_UUIDբtݬݬݬݢt RPC_$SET_BINDINGݬݬݬx 	RPC_$BINDPt޼P` P| ^ V ޼RЏ                                                                                                                                                                                                                                                   9                        g` $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         Wq "               bݬgP1 խ1 SR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb   
SOCKET_$EQUAL  SOCKET_$VALID_FAMILY  UUID_$DECODE  LB_$LOOKUP_RANGE  RPC_$SET_SHORT_TIMEOUT  RPC_$FREE_HANDLE  	RPC_$BIND  RPC_$INQ_BINDING  RPC_$SET_BINDING  RPC_$ALLOC_HANDLE  VAXC$GPRINTF  STRLEN  STRCPY  SETJMP  LSEEK  READ  OPEN  ACCESS  OPEN  CLOSE  CLOSE  READ 
  	    GLB_CA_$SET_SHORT_TIMEOUT 
  	  | GLB_CA_$GET_   OBJECT_UUID 
  	   GLB_CA_$GET_SERVER_ADDRESS 
  
   GLB_CA_$SET_SERVER_ADDRESS   R
    GLB      get_default_object p     p   has_server_list <        open_server_list      @  close_server_list 0     p  find_server_nbrd        
check_binding      	  glb_ca_$set_short_timeout       	  glb_ca_$get_object_uuid :   !  	  glb_ca_$get_server_address 8   !  
  glb_ca_$set_server_address ]     t
     glb_register_ops 	      glb_ca_$insert        glb_ca_$delete      ) Ƙ Rˏ  bRR  ^(n PFM_$SIGNALRb  Rb ݬݬݦt޼RbRb 
  PFM_$ENABLE PFM_$_RLS_CLEANUPݬϐPխ1,P  ^ݬݬ GLB_$CLIENT_EPVP  ^ݬݬ GLB_$CLIENT_EPV   3ϿP| ^ V   ޼ RЏ b޼R b޼RbƘ  ݬ P1gխ1_PSR SETJMPPDRݢD     
PFM_$_CLEANUPЭRb ) Ƙ Rˏ  bRR  ^(n PFM_$SIGNALRb  Rb 1  ЬЬѭ䏐  
ЭRRЏ  ЭRRݬ ݭ߭ݭ߭ݬݬݬݦt GLB_$CLIENT_EPV   3R	bŭ   RRRRRíRRխխ1|𞭐Rb   PFM_$ENABLEP PFM_$_RLS_CLEANUPݬ ϠPխ1խ!޼RЭb޼RЭbխݬݭ޼ Rb ޼Rb޼ R b `^ W V  Ьѭ1 ЭR>xR<bR !  Rݭ SOCKET_$VALID_FAMILYP1 PRBƴ ARBƠ RBƤ   Ǽݭ     glb_ca_$lookup     
  sort_entries M  		C                 	  	          "   	   	  =             
      GLB_CA_$INSERT 
      GLB_CA_$DELETE 
    | GLB_CA_$LOOKUP    $CODE   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON   $CHAR_STRING_CONSTANTS   SOCKET_$FROM_NAMEխRBƴ RBƴ ЭRݢtЭRxRBƠ RbR     BƤ  
SOCKET_$EQUALPDѭ4ŏ   R޼S( Bc`ŏ   R޼S( Bc( `RRRR   RRѭ1         w w                                                                                                                                                                                                                                                                                                                                                                          $  1       @m,$i V1.0                            /     LBV1.0 3-APR-1991 08:40                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  	UUID_$NIL  
RPC_$DEBUG  LB_$PROCESS_ARGS_I  LB_$LOOKUP_RANGE  GLB_CA_$GET_OBJECT_UUID  GLB_CA_$SET_SHORT_TIMEOUT  GLB_CA_$LOOKUP  GLB_CA_$DELETE  GLB_CA_$INSERT  LLB_CA_$LOOKUP  LLB_CA_$DELETE  LLB_CA %  _$INSERT  UUID_$DECODE  EXIT  VAXC$GPRINTF  MEMCPY  LLB_CA_$SET_SHORT_TIMEOUT  P%W%     (ultrix)     %G%P   ]P i.;3gP
jP P333b91de0000.0d.00.00.87.84.00.00.00%P333b91de0000.0d.00.00.87.84.00.00.00JP333b91eb0000.0d.00.00.87.84.00.00.00oP333b91f70000.0d.00.00.87.84.00.00.00 P%s
  P< l^լ$RR$լ 	pRR ޼ S޼R(bcЬ S޼R(bЬ S޼R(b Ь R0RЬbݏ@   ݬЬ R4 MEMCPYЬ RtRЬbݬݬЬ Rx MEMCPY޼$R bݬ$ݬ  &     LLB_CA_$INSERTլ$
޼$Rb!Ь Rˏ0RRݬ$ݬ  GLB_CA_$INSERTP  ^լ֭PP޼P `ЬPˏ0PPݬݬ GLB_CA_$DELETEլ
޼P`Pݬݬ   LLB_CA_$DELETEP  ^լ(PP(լ ޭPP լޭPP޼P `޼(P `լ1ݬ(ݬ$ݬ ݬݬݬݬݬݬݬ
 LLB_CA_$LOOKUP'ݬ(ݬ$ݬ ݬݬݬݬݬ GLB_CA_$LOOKUP  ^ݬݬݬݬݬ   	UUID_$NIL 	UUID_$NIL   
 LB_$LOOKUP_RANGE  ^ݬ ݬݬ '  ݬݬݬݬ 	UUID_$NIL 	UUID_$NIL 
 LB_$LOOKUP_RANGE  ^ݬݬݬݬݬ   	UUID_$NIL    	UUID_$NIL
 LB_$LOOKUP_RANGE  ^ݬݬݬݬݬ      	UUID_$NIL 	UUID_$NIL
 LB_$LOOKUP_RANGE  ^ݬ LLB_CA_$SET_SHORT_TIMEOUTݬ GLB_CA_$SET_SHORT_TIMEOUTPP ^ RլPPլPPݬ GLB_CA_$GET_OBJECT_UUIDݬb UUID_$DECODEPPPPլ1yP޼Pް P`-1L޼P`P`QQ119QP (  P1 PZ?PPd   1 Pd    P?P1 ݬߢ% UUID_$DECODE1 PݬߢJ   R	    LB      lb_$register         lb_$unregister b     D  lb_$lookup_range        lb_$lookup_object <       lb_$lookup_object_local <     T  lb_$lookup_type <       lb_$lookup_interface <       lb_$use_short_timeouts         lb_$process_args_i       lb_$process_args )   		.      )         
M                 
      < LB_$REGISTER 
       LB_$UNREGISTER 
  D    LB_$LOOKUP_RANGE 
      LB_$LOOKUP_OBJECT 
      LB_$LOOKUP_OBJECT_LOCAL 
  T    LB_$LOOKUP_TYPE 
      LB_$LOOKUP_INTERFACE 
      LB_$USE_SHORT_TIMEOUTS 
     LB_$PROCESS_ARGS_I 
     LB_$PROCESS_ARGS    $CODE *      $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON    $CHAR_STRING_CONSTANTSp UUID_$DECODE1 Pݬߢo UUID_$DECODEsPݬ  VAXC$GPRINTF  EXIT޼P`P`PP >P 5PL   0PL   Pl   Pl   P 
RPC_$DEBUG
PPPPPPPPլ1 ^ R ݬݬݬݬ LB_$PROCESS_ARGS_I Pږ                  |  vPz   2222222222222222              w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ,  1       `U>i V1.0                            0     LLBV1.0 3-APR-1991 08:41                   VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  LLB_$CLIENT_EPV  LLB_$MANAGER_EPV  LLB_$SERVER_EPV  	UUID_$NIL  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$SET_WK_PORT  SOCKET_$VA -  LID_FAMILIES  RPC_$SET_SHORT_TIMEOUT  RPC_$FREE_HANDLE  	RPC_$BIND  SETJMP   P%W%     (ultrix)        %G%P   `P i.;3jP
mPrP   zP  P  P 3;3 P
 P  P| ^ Vլ޼R(bЬ^P ݬ߭߭ SOCKET_$VALID_FAMILIES>Rbݬ߭<RR SOCKET_$INQ_MY_NETADDRݬݭ߭ SOCKET_$SET_NETADDRݬ ߭ SOCKET_$SET_WK_PORTݬݭ 	UUID_$NIL 	RPC_$BINDP޼Rb                                                                                                                                                                                                                                                    :                         $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "     -       .   ݭ RPC_$SET_SHORT_TIMEOUTЭP  ^ P   P< ^ݬݬݬPլ	޼Rb޼RЏ bSR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ;Rˏ  bRR  ^(n PFM_$SIGNALP޼SRbc  PFM_$ENABLE枭Rb ݬݬݭ LLB_$CLIENT_EPVRb PFM_$_RLS_CLEANUPݭ RPC_$FREE_HANDLE< ^ݬݬݬPլ	޼Rb޼RЏ bSR SETJMPPDRݢD 
PFM_$_CLEA /  NUPЭRb ;Rˏ  bRR  ^(n PFM_$SIGNALP޼SRbc    PFM_$ENABLE枭Rb ݬݬݭ LLB_$CLIENT_EPV   3Rb PFM_$_RLS_CLEANUPݭ RPC_$FREE_HANDLE< ^ ޼(RЏ b޼ R bݬݬPRR	RbSR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb 9Rˏ  bRR  ^(n PFM_$SIGNAL޼(SRbc  PFM_$ENABLERb }Ѭ
ЬRRЭݬ(ݬ$߭ݭݬ 0  ݬݬݬݭ LLB_$CLIENT_EPV   3R	b$0  RR$Ь ScRRcíRR޼Rb
լa  R
    LLB      get_binding          llb_ca_$set_short_timeout          llb_ca_$insert        llb_ca_$delete        llb_ca_$lookup   		b9          θ  θ  κ       
       LLB_CA_$SET_SHORT_TIMEOUT 
     < LL     B_CA_$INSERT 
    < LLB_CA_$DELETE 
    < LLB_CA_$LOOKUP  [  $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON ^ P PFM_$_RLS_CLEANUPݭ RPC_$FREE_HANDLE޼(Rb ޼ Rb޼(R b        w w                                                                                                                                                                                                                  2  1        JKi V1.0                            7     
CONV_SSTUBV1.0 3-APR-1991 08:42                    VAX C V3.1-051 P%W%     (ultrix)        %G%P   `P v":3jP
mP|Px  P ^޼P`<PPPPPЭQQQ RPC_$LOCAL_DREPPPPQP1 Q RPC_$LOCAL_DREPPQP1 ެPQ RPC_$LOCAL_DREP   3PQP1 ޭPн`PPP`PPP`PPPPPPݭݭ RPC_$BLOCK_COPYPPíPPPPPޭPн 3  `1QQQ RPC_$LOCAL_DREPPPPQP
ޭPн`9ޭPPЭЭPЭQЭPЭQЭPЭPؠPPQQQ   RPC_$LOCAL_DREPPPPQPP`!PPPЭЭPЭPРPPQQQ RPC_$LOCAL_DREPPPPQP
P`PPЭЭPЭPȠPPPPPPխ&PPPPPPխíPPPPPQQQ RPC_$LOCAL_DREPPPPQP
ޭPн`<PޭPPЭЭPЭQЭPЭQЭPЭP 4  ߭ݭݬ CONV_$WHO_ARE_YOU PPЬ$QPѭPPaaPP޼Rݭ RPC_$ALLOC_PKTPb
P޼RЬb޼P<RRR`RR   R    
CONV_SSTUB      conv_$who_are_you_ssr P  		^     I  $   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV 
 r   CONV_$MANAGER_EPV 
 |   CONV_$SERVER_EPV       CONV_$WHO_ARE_YOU  RPC_$BLOCK_COPY  RPC_$ALLOC_PKT  P  $CODE    $DATAY ЭЭRRЭRR޼ PíRR`޼(R brP CONV_$WHO_ARE_YOUxP           w w                                                                                                                                                                                                                                                                                                                            IK    
CONV_SSTUB#  SXi  SUKONNIK    
CONV_CSTUB# ˱li  SUKONNIK    
RRPC_CSTUB# &|i  SUKONNIK    
RRPC_SSTUB" i  SUKONNIK    	LLB_CSTUB" <i  SUKONNIK    	GLB_CSTUB$ @i  SUKONNIK    SOCKET_INET! `  SUKONNIK    RPC_UTIL @  SUKONNIK    U_PFM    SUKONNIK    RPC_LSN  ԱW  SUKONNIK    RPC_LSN  oE  SUKONNIK    RPC_LSN  <GF  SUKONNIK    RPC_LSN  }L  SUKONNIK    RPC_LSN   7  1       /IXi V1.0                            7     
CONV_CSTUBV1.0 3-APR-1991 08:42                    VAX C V3.1-051  P%W%     (ultrix)        %G%P   `P v":3jP
mP  P| l^ VuSuR SETJMPPDuuRݢDl 
PFM_$_CLEANUPlqq !pݭ 
RPC_$FREE_PKT^(qn PFM_$SIGNAL޼Rb RR<RRSR   SSppRRݭ RPC_$ALLOC_PKTP	ͽRR<RRRRRЭܭ޼RbRRЬR>RbRR 8  ЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRRíܭRRͽRR߭߭ݏ   ݭݭݭ ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSRDS RPC_$LOCAL_DREPRSR0S RPC_$LOCAL_DREP   3RSR ޼RbRнbRR޼Rнb1 SSS RPC_$LOCAL_DREPRRRSR޼RbRнb=޼RbRRЭЭRЭSЭRЭSЭRЭRТRR 9  SSS RPC_$LOCAL_DREPRRRSR
޼Rнb?P޼RbRRЭЭRЭSЭRЭSЭRЭRȢݭ   R    
CONV_CSTUB      conv_$who_are_you_csr 3  		T     J !   U   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV 
 r   CONV_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  P     FM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR  3  $CODE v   $DATA Y  
RPC_$FREE_PKTpݭ 
RPC_$FREE_PKTqu PFM_$_RLS_CLEANUPrP           w w                                                                                                                                                                                                                                                                                        ;  1       ࣨli V1.0                            7     
RRPC_CSTUBV1.0 3-APR-1991 08:43                    VAX C V3.1-051  P%W%     (ultrix)        %G%`P 96 @jP
mPf  P ^ RPP PP߭߭ݏ   ݭݭݭ ݬ
 RPC_$SAR޼P`<PPPPPЭ䋏QQQ RPC_$LOCAL_DREPPPPQP.Q RPC_$LOCAL_DREPPQPQ RPC_$LOCAL_DREP   3PQP
޼Pн``QQQ RPC_$LOCAL_DREPPPPQP
޼Pн`<޼P`PP <  ЭЭPЭQЭPЭQЭPЭPؠݭ 
RPC_$FREE_PKTP| L^ V]S]R SETJMPPD]]R ݢDL 
PFM_$_CLEANUPLYY !Xݭ 
RPC_$FREE_PKT^(Yn PFM_$SIGNAL޼Rb RR<RRSR   SSXXRRݭ RPC_$ALLOC_PKTP	ͥRR<RRRRRЭܭЬRRíܭRRͥRR߭߭ݏ   ݭݭݭݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPR =  RRSR1 S RPC_$LOCAL_DREPRSR1 S RPC_$LOCAL_DREP   3RSR1 RRRRRR>RbRR౭Џ  T^ (Tn PFM_$SIGNALíܭRRRRR޼RbRR<RRRݭݭ RPC_$BLOCK_COPY<RRRRíܭRRRRR޼RbRнbRR޼Rнb1PRRSSS RPC_$LOCAL_DREPRRRSR
>Rb"P>RRЭЭRЭR̢RR౭Џ  P^(Pn PFM_$SIGNAL޼RbRR<RRխ1 íܭRRRRR >  SSS RPC_$LOCAL_DREPRRRSR
н<P޽RRЭЭRЭSЭRЭSЭRЭRĢRRRRRRխ1líܭRRR RRSSS RPC_$LOCAL_DREPRRRSR޼RbRнb=޼RbRRЭ୼ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR
޼Rнb?P޼RbRRЭ୴ЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKTXݭ 
RPC_$FREE_PKTY] PFM_$_RLS_CLEANUP| ^ V                                                                                                                                                                                                                                                   ;                        ̰ $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         n "     >       ?  %S%R SETJMPPD%%RݢD 
PFM_$_CLEANUP!! ! ݭ 
RPC_$FREE_PKT^(!n PFM_$SIGNAL޼Rbz RR <zRRSR   SS  RRݭ RPC_$ALLOC_PKTPPmRR<zRRRRRЭܭЬRRíܭRRmRRmqr߭߭ݏ   ݭݭݭݬ
 RPC_$SAR<zRRRRRЭܭrSSS RPC_$LOCAL_DREPRRRSR1rS RPC_$LOCAL_DREPRSR1sS RPC_$LOCAL_DREP   3RSR @  1RRRRxRR>vRbRRvxЏ  ^(n PFM_$SIGNAL޼RbRR<vRRխ1íܭRRRRR޽RнbRRЭRRRݏ @   ݭݭ RPC_$BLOCK_COPY@   RRЭRDRbRRíܭRRRRRЭRFRнbRRЭRJRbRRЭRLRbRRЭRNRRЭRORRݭݭ RPC_$BLOCK_COPYRRȏV   RRRRխ1íܭRRRRR޼RbRнbRR޼Rнb1sPRRrSSS RPC_$ A  LOCAL_DREPRRRSR>vRb!>vRRЭ୼ЭRЭRRRvxЏ  ^(n PFM_$SIGNAL޼RbRR<vRRխ1íܭRRRRRrSS S RPC_$LOCAL_DREPRRRSR
޽Rнb<P޽RRЭ୴ЭRЭSЭRЭSЭRЭRRRЭRRR խhrSSS RPC_$LOCAL_DREPRRRSR
>Rb"P>RRЭ୬ЭRЭRRRRRRRխrSSS RPC_$LOCAL_DREPRRRSRЭRDRb#ЭRDRRЭ୤ЭR B  ЭRRRíܭRRRRRrSSS RPC_$LOCAL_DREPRRRSRЭRFRнb@PЭRFRRЭଡ଼ЭRЭSЭRЭSЭRЭRRRrSSS  RPC_$LOCAL_DREPRRRSRЭRJRb$ЭRJRRЭ୔ЭRЭRRRrSSS RPC_$LOCAL_DREPRRRSRЭRLRb&PЭRLRRЭୌЭRЭRRRЭRNRRЭRORRխ&RRRRRRխȏV   RRRRխ1íܭRRRRR C  rSSS RPC_$LOCAL_DREPRRRSR޼RbRнb=޼RbRRЭୄЭRЭSЭRЭSЭRЭRRRrSSS RPC_$LOCAL_DREPRRRSR޼RнbCP޼RbRRЭ| |RЭS|RЭS|RЭR|qݭ 
RPC_$FREE_PKT ݭ 
RPC_$FREE_PKT!% PFM_$_RLS_CLEANUP ^ RPP PP߭߭ݏ   ݭݭݭ ݬ
 RPC_$SAR޼P`<PPPPPЭ䋏QQQ RPC_$LOCAL_DREPPPP D  QP.Q RPC_$LOCAL_DREPPQPQ RPC_$LOCAL_DREP   3PQP
޼Pн``QQQ RPC_$LOCAL_DREPPPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠ  R    
RRPC_CSTUB      rrpc_$are_you_there_csr 5    8  rrpc_$inq_stats_csr       rrpc_$inq_interfaces_csr     
  rrpc_$shutdown_csr 5  		       ! 	 E   '    U   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV 
 r   RRPC_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR    $CODE         $DATA 0 ݭ 
RPC_$FREE_PKTrP   8  
        w w                                                                                                                                                                                                                                                                                                                                                                                                                                              G  1       |i V1.0                            7     
RRPC_SSTUBV1.0 3-APR-1991 08:43                    VAX C V3.1-051 P%W%     (ultrix)        %G%`P 96 @jP
mPf P   P ^ݬ RRPC_$ARE_YOU_THERE޼P` PPЬ$QPѭPPaaPP޼Rݭ RPC_$ALLOC_PKTPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R   < x^SR SETJMPPDRݢDz 
PFM_$_CLEANUPzѭ խݭ 	RPC_$FREE^( H  n PFM_$SIGNAL ޼Rb<RRRRRЭSSS RPC_$LOCAL_DREPRRRSR2S RPC_$LOCAL_DREPRSRެRS   RPC_$LOCAL_DREP   3RSR
ޭRнb]SSS RPC_$LOCAL_DREPRRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭRآRRR RPC_$MALLOCP߭ݭݭݬ RRPC_$INQ_STATS RRRRRRЬ$SRѭRRccRR޼Rݭ RPC_$ALLOC_PKTPb޼RЬb޼S<RRRcRRЭRRRR԰ԽRR I  RRRRҰҽRRҭЏ  ~^(~n PFM_$SIGNALíRRRRR޽RR<RRRݭݭ RPC_$BLOCK_COPY<RRR RíRRRRRЭRRЭRR޼ SíRRcխݭ 	RPC_$FREE޼(R b< l^~S~R SETJMPPD~~RݢDn 
PFM_$_CLEANUPnzz  խݭ 	RPC_$FREE^(zn PFM_$SIGNAL ޼Rb<RRRRRЭSSS RPC_$LOCAL_DREPRRRSR3S RPC_$LOCAL_DREPRSRެRS RP J  C_$LOCAL_DREP   3RSRޭRнb^SSS RPC_$LOCAL_DREPRRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭR̢Rď V   RR RPC_$MALLOCPv߭ݭݭݬ RRPC_$INQ_INTERFACES Rď[   RRRRRЬ$SRѭRRccRR޼Rݭ RPC_$ALLOC_PKTPbP޼RЬb޼S<RRRcRRЭRRRRȰȽRRRRRRưƽRRƭЏ  r^(rn PFM_$SIGNALRR<RRխ1íRRRRRнܽR K  RЭRRRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRЭR>DRbRRíRRRRRЭRޢFRbRRЭR>JRbRRЭR>LRbRRЭRNRRЭRORRݭݭ RPC_$BLOCK_COPYRR܏V   RRRRխ1íRRRRRЭRRvRR޼ SíRRcխݭ 	RPC_$FREEz~ PFM_$_RLS_CLEANUP޼(R   ^ݬ RRPC_$SHUTDOWN޼P` PPЬ$QPѭPPaaPP޼Rݭ RPC_$ALLOC_PK L  TPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R brP RRPC_$ARE_YOU_THERE RRPC_$INQ_STATS RRPC_$INQ_INTERFACES RRPC_$SHUTDOWN P   R    
RRPC_SSTUB      rrpc_$are_you_there_ssr         rrpc_$inq_stats_ssr     P  rrpc_$inq_interfaces_ssr       rrpc_$shutdown_ssr    		        	&   M     
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV 
 r   RRPC_$MANAGER_EPV 
    RRPC_$SERVER_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RRPC_$SHUTDOWN  RRPC_$INQ_INTERFACES  RRPC_$INQ_STATS  RRPC_$ARE_YOU_THERE  RPC_$BLOCK_COPY  RPC_$ALLOC_PKT  	RPC_$FREE       RPC_$MALLOC    $CODE    $DATA       P         w w                                                                                                                                                                                                                                                                                                                                                                                                                                          O  1       @ʑi V1.0                            6     	LLB_CSTUBV1.0 3-APR-1991 08:44                   VAX C V3.1-051 P%W%     (ultrix)        %G%P   `P i.;3jP
mPrP   zP  P  P 3;3 P
 P  P| d^ VmSmR SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTP	͵RR<                                                                                                                                                                                                                                                   <                        3 $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "     O       P  RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ  RPC_$BLOCK_COPYRRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR Q  4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭ r ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR
޼RнbcPSSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭR R  ЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP| d^ VmSmR  SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTP	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYR S  RíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ  RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ  T  RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭr ݬ
 RPC_$SAR<RRRRRЭܭ SSS RPC_$LOCAL_DREPRRRSR1S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR
޼RнbcPSSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP| θ^ VSR SETJMPPD U  RݢDͺ 
PFM_$_CLEANUPͺ !ݭ 
RPC_$FREE_PKT^(n PFM_$SIGNAL޼Rb A   RR<RRSR   SSRRݭ RPC_$ALLOC_PKTPPRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_C V  OPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ   RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭrݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1BS RPC_$LOCAL_DREPRSR1*S RPC_$LOCAL_DREP   3RSR1޼RbRнbRR޼RbRнbRR>Rb W  RR<RRЏ  ^(n PFM_$SIGNAL޼ RbRR<RRխ1|íܭRRRRR޽RнbRRЭRRbRRЭRR ɽbRRЭRRRЭR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RR X  ݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRR RRЭRtRнbRRЭRxRbRRЭRzRRݭݭ RPC_$BLOCK_COPYRR   RRRRխ1íܭRRRRR޼$Rнb1PSSS RPC_$LOCAL_DREPRRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR޼RbRнb?P޼R Y  bRRЭ୐ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR>Rb!>RRЭୈЭRЭRRR< RRЏ  ;^(;n PFM_$SIGNAL޼ RbRR<RRխ1íܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSS RPC_$LOCAL Z  _DREPRRRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRޭRRRRխíܭRR RRRSSS RPC_$LOCAL_DREPRRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSS RPC_$LOCAL_DREPRRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR\ЭX [  XR\\RXRRЭRRRЭRRRխ(PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR  RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSS RPC_$LOCAL_DREPRRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSS RPC_$LOCAL_DREPRRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@RRЭR(RRЭ \  R)RRխ(PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S 8R<R8RRЭR4RRЏ@   խhPS RPC_$LOCAL_DREPRSR) RPC_$LOCAL_DREPRRRB RPC_$EBCDIC_TO_ASCII
RB RPC_$ASCII_TO_EBCDICRRRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭRtRнbIPЭRtRR4 ]  00R44S0R4S0R4R0RRSSS RPC_$LOCAL_DREPRRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ   R    	LLB_CSTUB      llb_$insert_csr g    h  llb_$delete_csr g      llb_$lookup_csr   		"      + 
 
+  ^  
 =      
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  LLB_$CLIEN _  T_EPV  LLB_$MANAGER_EPV  LLB_$SERVER_EPV 
    LLB_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR  Z  $CODE    $DATAC&RRRRRRխ   RRRRխ1íܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭ 
RPC_$FREE_PKTݭ 
RPC_$FREE_PKT      PFM_$_RLS_CLEANUP P   h          w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      =                        k $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         % "     `       a  1       `(i V1.0                            6     	GLB_CSTUBV1.0 3-APR-1991 08:44                   VAX C V3.1-051  P   DP i.;3NP
QP  P< d^mSmR SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTPP͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬR b  RRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>Rb RRЬRRRЬRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRb c  RRЬR>xRbRRЬRzRRݭݭ RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭ   ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR.S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR
޼Rнb`SSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_ d  RLS_CLEANUP< d^mSmR SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in   PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTPP͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬR e  RRЬRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR ڢ(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭ f    ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR.S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR
޼Rн b`SSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP< θ^SR SETJMPPDRݢD͸ 
PFM_$_CLEANUP͸ !ݭ 
RPC_$FREE_PKT^(n  g  PFM_$SIGNAL޼Rb A   RR<RRSR   SSRRݭ RPC_$ALLOC_PKTP
RR<RRRRRЭܭ޼RbRRЬR>RbR RЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬR h  RRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭ  ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1OS RPC_$LOCAL_DREPRSR17S RPC_$LOCAL_DREP   3RSR1#޼RbRнbRR޼RbRнbRRబRR>RbRRЏ  ^(n PFM_$SIGNAL޼ RbRR<RRխ1{í i  RRRRR޽RнbRRЭRRbRRЭRRbRRЭRRRЭR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭRRнbRR ЭRRbRRЭRRbRRЭRRRЭRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR0RнbRRЭR j  4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЭRtRнbRRЭRxRbRRЭRzRRݭݭ RPC_$BLOCK_COPYRR   RRRRխ̬1íܭRRRRR޼$Rнb1	PSSS RPC_$LOCAL_DREPRRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR޼RbRнb?P޼RbRRЭ୐ЭRЭSЭRЭSЭRЭRRRబRR k  SSS RPC_$LOCAL_DREPRRRSR
>Rb"P>RRЭୈЭRЭRRRЏ  ͼ^(ͼn PFM_$SIGNAL޼ RbRR<RRխ1íܭRRRRRSSS  RPC_$LOCAL_DREPRRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRRtЭppRttR l  pRRЭRRRЭR	RRխ(PླྀRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSS RPC_$LOCAL_DREPRRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR\ЭXXR\\RXRRЭRRRЭRRRխ m  (PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSS   RPC_$LOCAL_DREPRRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSS RPC_$LOCAL_DREPRRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@RRЭR(RRЭR)RRխ(PRRƭRRRRխíܭR n  RRRRSSS RPC_$LOCAL_DREPRRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S8R<R8RRЭR4RRЏ@   խhPS RPC_$LOCAL_DREPRSR)  RPC_$LOCAL_DREPRRRB RPC_$EBCDIC_TO_ASCII
RB RPC_$ASCII_TO_EBCDICRRRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭRtRнbIPЭRtRR4Э00R44S0R4S0R4R0RR o  SSS RPC_$LOCAL_DREPRRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ&RRRRRRխ   RRRRխ1íܭRRRRRSSS   R    	GLB_CSTUB      glb_$insert_csr c    d  glb_$delete_csr c      glb_$lookup_csr     l  glb_$find_server_csr ]   		      +  p  
 
+ 
 =  쾎  Q   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC   q  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV 
 V   GLB_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR    $CODE f   $DATA I RPC_$LOCAL_DREPRRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭ 
RPC_$FREE_PKTݭ 
RPC_$FREE_PKT PFM_$_RLS_CLEANUP  ^PP PP                                                                                                                                                                                                                                                   >                        6=& $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         } "     q           ߭߭ݏ   ݭݭݭ ݬ
 RPC_$SARVP   d  l         w w                                                                                                                                                                                                                                                                                                                                                                                                          s  1       پi V1.0                            8     SOCKET_INETV1.0 3-APR-1991 08:45                   VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  INET_$SOCKET_HANDLER 
    INET_$SOCKET_HANDLER  SKIP_IF_CLUSTER  
GETHOSTBYNAME  
GETHOSTBYADDR  	INET_NTOA  	INET_ADDR  GETHOSTNAME  SOCKET  PERROR  MEMSET  MEMCPY  STRLEN  STRNCPY  STRCPY  IOCTL  IOCTL  IOCTL  IOCTL  NTOHS  HT t  ONS  HTONS  SKIP_IF_CLUSTER  CLOSE_SOCKET  IOCTL  NTOHL  HTONS  CLOSE_SOCKET   P%W%     (ultrix)        %G% P(socket_inet/set interface broadcast address):   P< $^޼R( bݏi ݬ IOCTLP PRSRS3SRRRRPP< $^޼R( bݏi ݬ IOCTLP PRSRS3SRRRRPP< $^޼R( bݏ
i ݬ IOCTLP P>R<bRSRSSRRP< $^޼R( bݬݬYP%ݬݬPݬݬPP Pݏi ݬ I u  OCTLP PRSRS3SRRRRP  ^ݬ 
GETHOSTBYNAMEPխЏPЭPްP`P   ^߬ 
GETHOSTBYADDRPխ PP  ^ЬѬ޼PЏ `ЭP> P<  PP NTOHSPPPP ^Ь޼P`޼PЏ `޼P`޼P `ЭRݬ HTONSPQ PQ   ^Ь޼P`޼PЏ `޼P `Ѭ (Ѭ  ЭRݏ    HTONSPQPQ`PP |^ЬѬd   ޼PЏ `޼P `޼P` ݭ MEMSETٰݬݬݬݭݬݬ߭ v   STRNCPYЬP @4߭ 	INET_ADDRPѭ޼PЏ `ЭPPЭ`1 ߭PЭPP޼   R    SOCKET_INET      is_loopback_interface F     H   is_up_interface F        is_inet_interface D        is_broadcast_interface      T  
hostbyname 4       
hostbyaddr ,       inet_$inq_port <       inet_$set_port L     <  inet_$set_wk_port U       inet_$from_name l       inet_$ w  to_numeric_name        
inet_$to_name      0  inet_$max_pkt_size      H  inet_$inq_my_netadd PЏ `ޭPPޭPPЭRPPЭQPPabЭQRRЭPRR`aЭQRRЭPRR`aЭQRRЭPRR`aЭRRЭb޼R  < ^ЬѬ޼RЏ bЭR^(n 	INET_NTOAP޼Rݭ STRLENPbP޼RЏ bݭݬ STRCPY޼Sݬ STRLENPRRc޼R     ^ЬѬ޼PЏ `޼P `ЭPՠ$޼P`ݬ GE x  THOSTNAMEP޼PЏ `8ЭPݠϧPխ޼PЏ `޼P`ݭݬ STRNCPYݬ STRLENP޼Pѭ`޼PЭ`P  ^޼P   Џ   P  ^ ЬP MEMSET޼P`  SOCKETPѭ޼PЏ `Џ   PPݏiݭ IOCTLPݭ CLOSE_SOCKET޼PЏ ` PPPPխ1 ߭ݭ SKIP_IF_CLUSTERݭݭ0P\ݭݭgPKݭݭP:ѭ4ЭPPPЭPР߭ЬP MEMCPY޼P ` y   PPPPխ1jݭ CLOSE_SOCKET޼P     ^ЬЭPРѬ޼PЏ `޼P `޼P`߭ P    MEMCPY  ^ЬѬ޼PЏ`޼P `޼P`ЬP߭ MEMCPYЭPP    ^ЬЭPРѬ޼PЏ `޼P `޼P`߭ P  MEMCPY  ^ЬѬ޼PЏ`޼P `޼P`ЬP߭ MEMCPYЭPP    <^ЬЬѬ޼PЏ `Ѭ޼PЏ `ݬݭ MEMCPYݬݭ MEMCPY޼P ` z  Pݠ NTOHLPPPPݠ NTOHLPPPˏPP'ˏPPˏ Qˏ PQP1 ˏ?PP   .ˏ?PP    ˏ  Qˏ  PQPGPˏ?PP   .ˏ?PP   ˏ   Qˏ   PQPP ːPPPPP| ΰ^ V޼Rb޼RЏ b  SOCKETPѭ޼RЏ bЏ   RRݏiݭ IOCTLPݭ CLOSE_SOCKET޼RЏ b RR RRխ1 ޼Rѭb1 S޼RCbRR( ͼݭݭϷ {  PѭP1 ЭR޼SBcRbЭRݬ HTONSPSRSbͼݏi ݭ IOCTLPf PERROR0RRЭRЭR r `      inet_$inq_netaddr L       inet_$set_netaddr P     D  inet_$inq_hostid L       inet_$set_hostid P       inet_$eq_network T    4	  inet_$inq_broad_addrs     
  inet_$to_local_rep <     4  inet_$from_local_rep <     p  skip_if_cluster 4   		&       |  /	    ]            	 
        }      IOCTL 
  p    SKIP_IF_CLUSTER    $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON 0   $CHAR_STRING_CONSTANTSi MEMCPYRR&P RRRRխ
޼Rѭb1޼RЭb޼R b CLOSE_SOCKET ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ  ^Ь PPЭPc޼P`ЬQaPPa P   <          0 H   D   4	 
 4         w w                                                                                                                                                                                                                                                                                                                                                                                                                                                          1    /    ς V1.0                            5     RPC_UTILV1.024-JUN-1991 14:29                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$DEBUG  RPC_$MAX_DEBUG  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII     
RPC_$STATS  
RPC_$DEBUG  
RPC_$LOSSY 
    RPC_$SEQ  
PINGS_SENT  
PINGS_RCVD  P%W%     (ultrix)        %G%P   `P v":3jP
mP P 96 @ P
 Pf P --> SEND -->  P <-- RCVE <--  Prpc_util.c: PP     P     P7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????zP|P??????P ??????????.<   (+|&?????????!$*);^-/?????????,%_>??????????`:#@'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[??? ????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????0123456789|????? P(rpc) *** FATAL ERROR "%s" at %s\%d ***
)P_REQUEST_ client -> serverP)DP_PING_ client -> serverPD\P_RESPONSE_ server -> clientP\xP** FAULT ** server -> clientPx P_WORKING_ server -> clientP  P_NOCALL_ server -> clientP  P** REJECT ** server -> client   P  P_ACK_ client -> serverP  P_QUIT_ client -> serverP P_FACK_ client < -> serverP0P_QUACK_ server -> clientP0IPBOGUS PACKET TYPE[P%s(rpc_$recvfrom) recvfrom failed ??? 
P%s(rpc_$recvfrom) recvfrom failed ??? 
P(rpc_$recvfrom) recvfrom failedP%sCan't convert socket to name.. st.all = 0x%X
P
RECV DATA FROM:  %s, port[%d]
P%s(rpc_$recvfrom) Didn't get anything from the recvfrom call.. recv_len = %d
iP%s(rpc                                                                                                                                                                                                                                                   ?                         $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                          "              _$unpack_hdr) Bad RPC version (%u)
P%s(rpc_$unpack_hdr) Bad pkt type (%d)
P%s(rpc_$unpack_hdr) Time is: %D 
	NO PACKET DATA:recv_len = %D
P+------------------------------------------+
'P%s(rpc_$unpack_hdr) Packet too short; is %u, data len is %u
dP%sCan't convert socket to name.. st.all = 0x%X
P
SENDING TO:  %s, port[%d]
P(rpc_$sendto) sendto(2) failed ??Ppkt->refcnt > 0PRPC$:[NCK_D.LIBNCK_D]RPC_UTIL.C;1P..ALARM CLOCK..
P..LEAVING ALARM CLOCK..
   .Pn_tasks < MAX_TASKSBPRPC$:[NCK_D.LIBNCK_D]RPC_UTIL.C;1dP%s%s
jP	# of remote calls out:	%lu
P	# of remo te calls in:	%lu
P	# of pkts sent:	%lu
P		%s	%lu
P	# of pkts rcvd:	%lu
P		%s	%lu
P	# of frag resends:	%lu
P	# of dup frags rcvd:	%lu
P%D  +---[ *Start%sPkt Header* PKTS RCVD: %ld, PKTS SENT: %ld, OLD PKTS RCVD: %ld ]---+
oPPings Sent: %D, Pings Rcvd: %D
PRPC  Vsn: %d
PPkt Type: %d (%s)
PFlags: 0x%x   NULL
PFlags: 0x%x     Defs:
PFlags2: 0x%x  PObject    UUID: %s
PInterface UUID: %s
PActivity  UUID: %s
#PServer  Boot Time: %ld
 ;PInterface Version: %ld
SPPacket SEQ #: %ld
fPMy  SEQ # Is: %ld
yPOperation  #: %d
PInterface Hint: == NO_HINT
PInterface Hint: %d
PActivity  Hint: == NO_HINT
PActivity  Hint: %d
PFragment #: %d
PPkt Body: %D.  bytes
PNULL Pkt body..
"Prpc_$fault Code: 0x%08X, %ld.
APrpc_$reject Code: 0x%08X, %ld.
aPPings    Sent: %D, Pings Rcvd: %D
P%D  +---[   *End%sPkt Header* PKTS RCVD: %ld, PKTS SENT:%ld, OLD PKTS RCVD: %ld ]---+

P	(Client -> Serv er) Packet was forwarded
P	(Client <-> Server)  Packet is the last fragment
6P	(Client <-> Server)  Packet is a fragment
bP	(Client <-> Server)  Don't send a FACK for this FRAG
P	(Client -> Server) `MAYBE' request
P	(Client -> Server) `IDEMPOTENT' request
P	(Client -> Server) `BROADCAST' request
	P	(Client -> Server) out's can b   e BLASTED !
=	PNULL
C	P(Client -> Server) Packet forwarded in two pieces.
	Intra-machine function only ! [never over wire]
	P<<< eh ??  FL  
OLD_PKTS_RCVD 
    	PKTS_RCVD 
    	PKTS_SENT 
   OLD_ALARM_HANDLER 
   
RPC_$ENCR_RGY 
   	UUID_$NIL 
   RPC_$LOCAL_DREP_PACKED 
   RPC_$LOCAL_DREP 
   RPC_$ASCII_TO_EBCDIC 
 H  RPC_$EBCDIC_TO_ASCII 
 H  
RPC_$STATS 
   
RPC_$DEBUG 
   RPC_$MAX_DEBUG 
   
RPC_$DUMP_RAW 
   
RPC_$LOSSY  P   FM_$FAULT_INH_COUNT  RPC_$DUMP_RAW_PKT  PFLAGS2  PFLAGS  RPC_$DUMP_PKT_HDR  RPC_$FREE_LINKED_PKT   RPC_$ALLOC_PKT  	RPC_$FREE  RPC_$MALLOC  RPC_$SWAB_HEADER  RPC_$GET_PKT_BODY_ST  
RPC_$PKT_NAME  RPC_$DUMP_RAW_PKT  RPC_$DUMP_PKT_HDR  PFLAGS2  PFLAGS  UUID_$ENCODE  SOCKET_$TO_NAME  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$SIGNAL  _ASSERT  ABORT  MALLOC  FREE  RAND  
VAXC$GFPRINTF  VAXC$GPRINTF  PERROR  FFLUSH     MEMCPY  STRRCHR  STRCPY  ALARM  SIGNAL  TIME  RECVFROM_NCKAGS2 HAS RESERVED BIT FIELDS SET ??
	P%s(rpc_$dump_raw_pkt) Time is: %D
	NO PACKET DATA !len = %d

P+------------------------------------------+
E
P+------[ START raw data for packet seq# %ld ]---------+
~
P

P%04x: 
P 
P%02x 
P
+------[ END raw data for packet seq# %ld ]---------+
  P  ^ݏ]   ݬ STRRCHRPݬխЬ
PPݭ   VAXC$GPRINTF  ABORT    ^ Q RѬ
IPPЬP@P  ^    PFM_$INHIBIT_FAULTSP  ^  PFM_$ENABLE_FAULTSP  ^ЬPPPP߬ PP MEMCPY ^ RЬPPPP PP߭ MEMCPYЬPPPPxPPPQPPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬPJQЬPJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@PЬPLP`ЬPLQЬPLPa   PLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬ PP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP`ЬPDQЬPDPaЬPDP   ЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHP aЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8QЬP8PaЬP8PЬP8PЬP8QЬP8PЬP8P < \^ S U R޼P `߭ЬP  PP PPݬ RECVFROM_NCKPխZe#M¸¼P [    VAXC$GPRINTF Ã  
VAXC$GFPRINTFë PERRORЭPЭP PP ޼PЭ`¼ЏP   Э߭߭߭ݭЬP SOCKET_$TO_NAMEխ&¸¼ݭ  VAXC$GPRINTF%¸
¼Pݭ߭ VAXC$GPRINTFխ)¸	¼ݭ  VAXC$GPRINTFЭP¬hլcЬPNPPխRЭP@ҬG޼TЭP@ҬPàPP PPЭP@ҬPްP`PdխeЏP޼P`PP6¸
¼P޼P`PP i VAXC$GPRI   NTFeЏPЬPPPPPP<PPP
:¸
¼!PЬPPPPP Ó  VAXC$GPRINTFeЏPЬPPPPxPPPQPPPQPݬ RPC_$SWAB_HEADERˏ¼PP¼1 PխS߭ TIMEܕ¸
¼Pݭݭ ú VAXC$GPRINTF¸	¼
 VAXC$GPRINTF4P޼P` RPC_$DUMP_PKT_HDRЬPݠ@ݭ PP RPC_$DUMP_RAW_PKTЬP>JP<`PP   PѭP<¸¼#ЬP>JP<`PPݭ ' VAXC$GPRINTFeЏPTPPTЬPPP   PPP<PPP@\QaPPaЭP ΀^ W V#  RANDPRz  RP{PQPPRRЏ    PЬRRʏRR ߘSP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n PFM_$SIGNAL޼RbRRRƼ1 ЏP   Э߭߭߭ݭЬR SOCKET_$TO_NAMEխ(Ƹ
ƼPݭ d VAXC$GPRINTF%Ƹ
ƼPݭ߭ǔ VAXC$GPRINTF   ЬR ݭ RRݬ 
SENDTO_NCKPխǰ PERROR RR ˏƼRR 	Ƽ ޼Rb RPC_$DUMP_PKT_HDRЬRݢ@ݭ RR RPC_$DUMP_RAW_PKTխ,PRRPЬRRRRRR<RRRBXScRRcRխRRRRRRP< ^ݬ MALLOCPխЏ ^(n PFM_$SIGNALP  ^    FREE  ^P      PP RPC_$MALLOCPP  ^    	RPC_$FREE  ^X   PP RPC_$MALLOCPլP   PPݬЭP MEMCPY   ЭPP` P ^ RЬP>P<`PP"Pݏ   _ASSERT  ABORTЬQ   R    RPC_UTIL      rpc_$die T     T   
rpc_$pkt_name 8        	rpc_$lock 
        rpc_$unlock 
        rpc_$set_pkt_body_st (        rpc_$get_pkt_body_st      l  rpc_$swab_header     |  
rpc_$recvfrom     L	  rpc_$sendto {      rpc_$malloc 7        	rpc_$free        rpc_$alloc_pkt          4  
rpc_$free_pkt      H  rpc_$alloc_linked_pkt X       rpc_$free_linked_pkt  
SENDTO_NCK  TIME  TIME  
ERROR_$C_TEXT  TIME  TIME 
        RPC_$DIE 
  T    
RPC_$PKT_NAME 
       	RPC_$LOCK 
       RPC_$UNLOCK 
       RPC_$SET_PKT_BODY_ST 
      RPC_$GET_PKT_BODY_ST 
  l    RPC_$SWAB_HEADER 
  |  < 
RPC_$RECVFROM 
  L	   RPC_$SENDTO 
    < RPC_$MALLOC 
       	RPC_$FREE 
      RPC_$ALLOC_PKT 
  4    
RPC_$FREE_P   KT 
  H    RPC_$ALLOC_LINKED_PKT 
     RPC_$FREE_LINKED_PKT 
  
    RPC_$FREE_FRAG_LIST PPЬP>P<`PPݬ 	RPC_$FREE  ^޼P`-P޼Pް P`޼P` RPC_$FREE_LINKED_PKT޼PЭ`޼P` ^ SЬPPPЭPPPP޼R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`                                                                                                                                                                                                                                                   @                         $      RCP011.B                       :  E9  [B]RPC$LIBNCK.OLB;1                                                                                                                                         M               QPPЬ޼PЭ`ЬQPP*ЭQЭPTLôPPôЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPQЬPQPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ RPC_$ALLOC_PKTP޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRR   R޼RbRXݭ MEMCPY޼R޲ Rb޼Rb RPC_$FREE_LINKED_PKT޼RЭb޼RbЭP (^ S   R¸ VAXC$GPRINTFޯ\\ SIGNAL ALARM PFM_$FAULT_INH_COUNTpP  TIMEP\\  QP<\\Lc\\ս'Э\ѭн\ lЭQЭ\P\Pl\\ B\\ SIGNAL
 ALARM¸ VAXC$GPRINTF ^ T R  4P<PP@cP`<PPPPPPP ϱ2PP   @cPPH< PPݏ^  B. _ASSERT  ABORT< PP@cPP PP ,DPP  SIGNALP¨ ALARMP¤ЬЭPPЬ`ЭS  TIMEPQQPQ` ^ R   ;<PP@cPPѽ PսPP ŕ0   ALARM¨ SIGNAL¤¤ ALARMP< ^<RĬRRRRRѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR>JR<b   RRRRíSЬRCPЬRP MEMCPYRRP ^ SRPRPݬݬ STRCPY1 PPVЬQPPЬRPPbRBHaaPP*ЬRPPЬQPPaP@HbbPPVЬQPPЬRPPbRBaaPP,PЬRPPЬQPPaP@bbPP  ^ݬݬ    MEMCPY| ^ Vݏd   ߭^(n 
ERROR_$C_TEXTP d   VAXC$GPRINTF  FFLUSH  ^Ѭ  Ѭ  Ѭ   PPPPP ^ RѬ      ޼PЏ `¬+ݏ    RPC_$MALLOCP¬ ЭP @Ҭ   ЬPЬ@Ҭ޼P    (^ S RHjݬ  g     
  rpc_$free_frag_list ;     D
  rpc_$insert_in_frag_list        rpc_$reassemble_frag_list        handle_alarm      |  rpc_$periodically       rpc_$stop_periodic      (  rpc_$fill_frag        rpc_$cvt_string        rpc_$block_copy        rpc_$status_print L        4  rpc_$termination_fault 8     l  rpc_$register_encrtype h       rpc_$dump_stats <      rpc_$dump_  
VAXC$GFPRINTFLÇݬ 
VAXC$GFPRINTFPãݬ 
VAXC$GFPRINTFְ <PP
G<PP@XP`<PPPP 
RPC_$PKT_NAMEPùݬ 
VAXC$GFPRINTFޡPP<PP
Tݬ 
VAXC$GFPRINTFװ <PP
F<PP@\P`<PPPP 
RPC_$PKT_NAMEPݬ 
VAXC$GFPRINTFޡPP<PP
°ݬ 
VAXC$GFPRINTF   ´    
VAXC$GFPRINTF H^ V WǼ1   
PINGS_SENT 
PINGS_RCVD 
OLD_PKTS_RCVDլ
 RRP RRЬRլRR
RR߭ TIMEݭݭݭݭݭ VAXC$GPRINTFݭݭo VAXC$GPRINTF޼RbRRƏ VAXC$GPRINTFЬRRR 
RPC_$PKT_NAMEPЬRRRƝ VAXC$GPRINTFЬRЬRRRư VAXC$GPRINTF/ЬRRR VAXC$GPRINTFЬRRRR<RRR PFLAGSЬRRR    VAXC$GPRINTFЬRRRR<RRR PFLAGS2߭ЬR UUID_$ENCODE߭ VAXC$GPRINTF߭ЬR UUID_$ENCODE߭  VAXC$GPRINTF߭ЬR( UUID_$ENCODE߭ VAXC$GPRINTFЬRݢ8# VAXC$GPRINTFЬRݢ<; VAXC$GPRINTFЬRݢ@S VAXC$GPRINTF f VAXC$GPRINTFЬR>DR<bRRy VAXC$GPRINTFЬRFƋ VAXC$GPRINTFЬR>FR<bRRƧ VAXC$GPRINTFЬRHƻ VAXC$GPRINTFЬR>HR<   bRR VAXC$GPRINTFЬR>LR<bRR VAXC$GPRINTFЬRJЬR>JR<bRR VAXC$GPRINTFP VAXC$GPRINTFЬRRRRRPP   2P?P1 ݬ RPC_$GET_PKT_BODY_STؕǸǼP^(n^(n" VAXC$GPRINTFFPݬ RPC_$GET_PKT_BODY_STؕǸǼP^(n^(nA VAXC$GPRINTFPPݭݭa VAXC$GPRINTFݭݭݭݭݭƁ VAXC$GPRINTFP $^ R<PʏPP VAXC$GPRINTF<P   PP VAXC$GPRINTF<PʏPP6 VAXC$GPRINTF<PʏPPb VAXC$GPRINTF<PʏPP VAXC$GPRINTF<PʏPP¾ VAXC$GPRINTF<PʏPP VAXC$GPRINTF<PʏPP	 VAXC$GPRINTFP ^ R
=	 VAXC$GPRINTF<PPC	 VAXC$GPRINTFP¨	 VAXC$GPRINTFP 0^ S TլB߭ TIMEەĸļPݬݭ 	 VAXC$GPRINTF
 VAXC$GPRINTFݬE
    VAXC$GPRINTF ѭ1 z  P{PQPPRR!խ~
 VAXC$GPRINTFݭÀ
 VAXC$GPRINTFRz  RP{PQPPRRÇ
 VAXC$GPRINTFЭR޼PB`RRÉ
 pkt_hdr   
    pflags        pflags2 F     ,  rpc_$dump_raw_pkt   		R      
	Ӥ   
                        
0	

	        
s  	  	 р
	
     
               
  D
   RPC_$INSERT_IN_FRAG_LIST 
    < RPC_$REASSEMBLE_FRAG_LIST 
  |   RPC_$PERIODICALLY 
     RPC_$STOP_PERIODIC 
  (  < RPC_$FILL_FRAG 
     RPC_$CVT_STRING 
      RPC_$BLOCK_COPY 
    | RPC_$STATUS_PRINT 
  4    RPC_$TERMINATION_FAULT 
  l   RPC_$REG     ISTER_ENCRTYPE 
     RPC_$DUMP_STATS 
     RPC_$DUMP_PKT_HDR 
     PFLAGS 
     PFLAGS2 
  ,   RPC_$DUMP_RAW_PKT  =  $CODE   $DATA    ERRNO    
VAXC$ERRNO    STDIN N     STDOUT    STDERR    ENVIRON 
  $CHAR_STRING_CONSTANTSK  VAXC$GPRINTFRRѭݬÏ
 VAXC$GPRINTF *P   V          w w                                                                                                                                        * [B]RPC$LIBNCK.OPT;1 +  ,    .     /    4 N                          - E9   0   1    2   3      K  P   W   O     5   6 QJzΕ  7 Ε  8          9          G   H  J                            !	%W% VMS/ULTRIX Connection   %G%
!
!*****************************************************************************
!
!                        COPYRIGHT (C) 1989 BY
!                DIGITAL EQUIPMENT CORPORATION, MAYNARD
!                  MASSACHUSETTS. ALL RIGHTS RESERVED.
!
!  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
!  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
!  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
!  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
!  PERSON. NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS  HEREBY TRANSFERRED.
!
!  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
!  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
!
!  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
!  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
!
!*****************************************************************************
!
! =========                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  A                        (2 $      RCP011.B                         E9  [B]RPC$LIBNCK.OPT;1                                                                                                            N                              B             ================================================================= 
! Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
! Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
! Copyright Laws Of The United States.
! 
! Apollo Computer Inc. reserves all rights, title and interest with respect
! to copying, modification or the distribution of such software programs
! and associated documentation, except those rights specifically granted
! by Apollo in a Product Software Program License, Source Code License
! or Commercial License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between
! Apollo and Licensee.  Without such license agreements, such software
! programs may not be used, copied, modified or distributed in source
! or object code form.  Further, the copyright notice must appear on the
! media, the supporting documentation and packaging as set forth in such
! agreements.  Such License Agreements do not grant any rights to use
! Apollo Computer's name or trademarks in advertising or publicity, with
! respect to the distribution of the software programs without the specific
! prior written permission of Apollo.  Trademark agreements may be obtained
! in a separate Trademark License Agreement.
! ========================================================================== 
! 
! VMS LINK /OPTIONS file that lists the base (network independent) NCK 
! libraries.
! This file should live in RPC$LIB:.
!
rpc$lib:rpc$libnck.exe/share
IDENTIFICATION="RPC V1.1"
                                          * [B]RPC$LIBUCX.OLB;1 +  ,    . 8    /    4     8   8                     - E9   0   1    2   3      K  P   W   O 9    5   6  &i  7 Ε  8          9          G   H  J                              %
   VAX-11 Librarian V04-00        i  Si !               6    8   /      2                          7     7   $                                                                                                                                                                                                                                                                                                                                                                                 r           3    CLOSE_SOCKET3    IOCTL3    RECVFROM_NCK3    
SELECT_NCK3    
SENDTO_NCK3    SET_SOCKET_NON_BLOCKING                                                                                                                                                                                                                                                                                                                                                                                                             3    VMS_UCX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                B                        a_ $      RCP011.B                         E9  [B]RPC$LIBUCX.OLB;1                                                                                                                 8                         N "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              C                        ge7> $      RCP011.B                         E9  [B]RPC$LIBUCX.OLB;1                                                                                                                 8                          "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  D                        ӌ $      RCP011.B                         E9  [B]RPC$LIBUCX.OLB;1                                                                                                                 8                               0       1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                4   1        Si V1.0                            4     VMS_UCXV1.0 3-APR-1991 08:46                   VAX C V3.1-051  P%W%   (ultrix)  %G Pioctl failed: status = %d
Pioctl failed: status = %x, %x, %x%x
  P  ^Џ   ߭ݏ~fݬ IOCTLP  ^    CLOSEPP  ^ݬݬݬݬ    SELECTPP  ^ݬݬݬݬݬ    RECVFROMPP  ^ݬݬݬݬݬ    SENDTOPP <^ R S߭ 
LIB$GET_EFPˏPP  5    VAXC$GET_SDCPխ	cЏPP`ΞPPˏPP' PP#枭PP ЬЬݭݭ  U  R    VMS_UCX      set_socket_non_blocking (     (   close_socket      @   
select_nck (     h   recvfrom_nck ,        
sendto_nck ,        ioctl k  		     s                 
CC$_GFLOAT  RPC_$LO 6   CAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  VAXC$GPRINTF  VAXC$GET_SDC  SELECT  RECVFROM  SENDTO  IOCTL  CLOSE  LIB$FREE_EF  SYS$QIOW  
LIB$GET_EF 
        SET_SOCKET_NON_BLOCKING 
  (     CLOSE_SOCKET 
  @     
SELECT_NCK 
  h     RECVFROM_NCK 
       
SENDTO_NCK 
      IOCTL  +  $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    ENVIRON   @   $CHAR_STRING_CONSTANTS          <PPݭݭ SYS$QIOWPˏPPݭb VAXC$GPRINTFЭcЏP>P<`PʏPPH>P<`PP>P<`PP>P<`PP>P<`PPߢ VAXC$GPRINTF>P<`PPPPcЏP߭ LIB$FREE_EFP P        w w                                                                                                                                                                                                                                                                                           i  SUKONNIK    VMS_UCX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        E                        與 $      RCP011.B                       :  E9  [B]RPC$LLBD.EXE;2                                                                                                                   $                                        * [B]RPC$LLBD.EXE;2 +  , :   . $    /    4     $   %                     - E9    0   1    2   3      K  P   W   O %    5   6 `V
Ε  7  Ε  8          9          G   H  J  "             0 D X     0205      (  
N     B  t                                      RPC$LLBD                               RPC V1.1        
Ε 05-05                                  !   
  "     ?          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001#      +        RPC$LIBNCK_001  LLBD: (find_socket) called with no ready sockets
 LLBD ?  LLBD:  (process_requests) input from (process_requests) interface = %s
 (process_requests) object = %s
 (process_requests) dispatching
 LLBD:  (process_requests) forwarding to LLBD:  (process_requests) couldn't handle here..
 < name not available > %s %.*s[%d]
 LLBD: (use_family) Can't create socket
 LLBD: (use_family) Can't bind socket
 Listening on: LLBD: unable to obtain %.*s family port
 llbd/nck version 1.5 Can't register interface:  LLBD: Unable to obtain any sockets
    rpc$exe:llbdbase.dat    %W%     (ultrix)        %G%                                                                     i.;3    
                                                                       3;3    
                                                                         3   
                                                                          96 @  
  f     \  R   %W%     (ultrix)        %G%                                                                     i.;3    
                                                                       3;3    
                                                                                                 i.;3    
                                                                       3;3    
       D  t    X$  -  P                                                                                                                                                                  | \^V  c_d߭ ߭ݬݬݬ 
~  ѭ1 ޼Rb1  fd;  P
   RRft:  P	RRf:  P	RRcc޼R( dbЭPѭ޼R( dbЭѭ1cRRP< ^ ѭCЭP޼Q @aTЬUЭR޼Sz  BcP{ PQPPRxRRDeRRDeRRѭ< ^ ѭ1 ЭR޼P B`T޼UЭR޼Sz  BcP{ PQPPRxRRRRRDeRRGЭR޼P B`TЬUЭR޼Sz  BcP{ PQPPRxRRRRRRRDeRRDeЭR޼PB`PRRѭ1o]9  9  P^V0Y%Xj9  ZW "8   8   8  ЏQ 	 
ݬݬ"b	"ݏ@   8  Pխjj#ߦ2B8  P18խ1/խ1'ݬݬ"JPRR*:߭߭J߭Zݭ	8  RRRb^(nߦ:7  1hUݭJߦAϦi*7  hiߦ_7  i:7  hiƂ _7    <RR1 P<RRBtRbRF*7  PdhhƢ 
7  ݭJݭZݭ7  RRRb^(n 6  PRR<RR1c~ZJ* :aP^hݭ tZݭݭJݭ6  RRRb^(n S6  hh 
6  խ11jPP ^RЏd   ߭߭߭ݬݬ6  խ"߭5  ߭5  PPPݭ߭ݭݬ35   4^QRS ݬ*  Pխc@G5  ЏPݭ !5   ߭R5  ݭݭ[*  P#ݭ5  ch4  ЏPcݭЭP |^ST޼R b߭߭4   ѭ1 PЭP<@PPPѭAЏd   ߭߭ЭP<@PPv4  d߭ݭÜ4  ЬQaRaPPa޼PЭB`PPѭ1v  ^ ѭ#ЭP޼Q@a3  PPѭ 8^3  {WV  ݬݬ3    <RRe<RRBxR޲ Rb<RRBtRbm3  RRRb^(nE3  RR<RRe   RR2  >2  ߭߭#խ2  2  ݭ߭ϫݭ߭Ͼ2 P  ^ 2  \\d2  >^2     ^ެP޼P`޼P`2  P PP' {2  ޼P`i2  PP PP PެPЬPЬP"2  P PP% 2  ЬP1  P PP PެPЬP ЬP 1  P PP% 1  ЬP v1  P PP PެPՠ:ݬ$ЬPݠtЬPxЬPݠtЬPx0  PPPPPЏ   PP ,^޼P `լ޼PЏ`޼RݬA0  Pb޼Rbn 00  P޼Rݏ  ݏ  ݬ0  Pbݭ0  ޼Rb޼Rb/  
P޼RЏ b1-P޼Rb/  ѭU޼Rb/  ѭ&ݬ/  Pݬݬݬ޼RЏb޼RЏ b1 P޼Rbw ЭS޼RbN/  PCЭRB޼Rb!/  ޼SЭRBc ѭܭ!ЭRB.  RRѭܭЬRŏ   RRЬR޼Rb.  PЬSǏ   RR  ^Pď   P   PPݭ.  Pխ޼PЏ ` Pݭ ݭ.  ЏЭP ЭPЬݬݬݭϱ޼P`ݭ..   PЭP< ^ЬЬRѭ1 ŏ   SЬRCRRŏ   SЬRCRb_լЭSЬ Rѣ00IP(RRݭݬ ^(n	\P#լ$޼$Tŏ   SЬR( CdЭPRRЬRѭ1^ЏP  ^޼P `޼P`Ŭ   PPP ݭ޼P`-  P޼PЏ `GPݏ   ŏ   QЬPA޼P`,  Pѭ   ޼PЏ `PP< ^޼R bѬF ЬRѭ7Pŏ   SЬRCRb
ЭPRRЬRѭЬRѬ
޼RЏ bWЬRѬ
ЬSRRŏ   SЬRCRbŏ   TЬS޼R( bDݬݬݬϕ  ^ЬPѠtЬPѠt޼P `
P޼PЏ `| ^mV޼R bݬݬլ	޼Rb( ݏ    ݬ ^(nݬ
FPݬݬݭݬϑ| \^V޼R bݬݬ:լ	޼Rb( ݏ   \ݬ ^(nݬ
Pѭ+ŏ   SЬRCR bݬݭݬ]P޼RЏ b< T^ լ,
+  ޼Rb*  P޼R(bT Pլ+*  ޼Rb*  P޼R(bd Pլ+*  ޼Rb*  P޼R(bt P޼(R b޼$RbRR޼RbѭfRRݭTݭ^(nݬ
ϏPѭ)   RRRRRRѭѭѭ޼R bP޼RЭb޼ RЭbխ޼(RЏ bP ^R P.ݬݏ  &KP ޼QPaPPP ^RݬPݬݬ    ^iRݬsPݬ  A ^9Rݬ$CPݬ$ݬ ݬݏ   ݬݬݬݬݬ   
 ^Rݬ(Pݬ(ݬ$ݬ PPݬݬݬݬݬ 
G   ^޼P`f<fPPPPPЭQQQZ(  PPPQP1:Q@(  PQP1#ެPQ5(  PQP1Pн`PPP`PPP`PPPPPPݭݭX'  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ&  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ^&  PPíPPPPP
Pн`PPPPݏ@   ݭݭ&  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ%  16QQQ&  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ%  PPPQPP` PPЭЭPЭPPPQQQJ%  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ$  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ4$  PPPQPP` PPЭЭPЭPPPQQQ#  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ:#  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ"  PPPQPP` PPЭЭPЭPPPQQQ"  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ!  PPPQP
Pн`FP
PP|ЭxxP|    F                         $      RCP011.B                       :  E9  [B]RPC$LLBD.EXE;2                                                                                                                   $                         0h "            |QxP|QxP|PxPPPPЏ@   խfQN!  PQP*8!  PPP@ !  
P@!  PPPPPPխíPPPPPQQQ   PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ^   PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ: PPЬ$QPѭPPaaPP޼Rݭ)  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b ^޼P`f<fPPPPPЭQQQ  PPPQP1:Q  PQP1#ެPQ  PQP1Pн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ  PPíPPPPP
Pн`PPPPݏ@   ݭݭ  @   PPíPPPPPNPн`PPRP`PPTPPݭݭl  16QQQ  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQT  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQZ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ>  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ
  PQP*  PPP@  
P@  PPPPPPխíPPPPPQQQ  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ& PPЬ$QPѭPPaaPP޼Rݭ  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b< ^޼RbV<VRRRRRЭSSS  RRRSR1S  RSR1ެRS  RSR1RнbRRRbRRRbRRRRRRݭݭ  RRíRRRRR RнbRRRbRRRbRRRR	RRݭݭS  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ  RRíRRRRRޭRнbRRޭRнb1SSS  RRRSRRнb=PRRЭЭRЭSЭRЭSЭRЭRRRSSS  RRRSRRb RRЭЭRЭRRRSSS:  RRRSR
Rb"PRRЭЭRЭRRRRRRRխ'PRRRRRRխíRRRRRSSS  RRRSR
 Rнb<P RRЭЭRЭSЭRЭSЭRЭRRRSSS$  RRRSRRb RRЭЭRЭRRRSSS  RRRSR
Rb"PRRЭЭRЭRRRRR	RRխ'PRRRRRRխíRRRRRSSS*  RRRSR
RнbFPRR|ЭxxR||SxR|SxR|RxRRSSS  RRRSR
Rb(PRRtЭppRttRpRRSSS`  RRRSRRb&RRlЭhhRllRhRRRRRRխ%RRRRRRխíRRRRRSSS  RRRSR
ޭRнbFPޭRRdЭ``RddS`RdS`RdR`RRSSS?  RRRSR
ޭRнbCޭRR\ЭXXR\\SXR\SXR\RXP ߭ݭ߭ ݬ	 ŭЏ   RRRRRЬ$SRѭRRccRR޼Rݭ  Pb
P޼RЬb޼S<VRRRcRRЭЭȽRRЭнRRTTRR<TRRЏ  ^(n
   RR<TRRխ1zPíRRRRRнؽRRЭR>RbRRЭR>RbRRЭRRRЭR	RRݭݭ  RRíRRRRRЭRޢRbRRЭR>RbRRЭR>RbRRЭRRRЭRRRݭݭl  RRíRRRRRЭRޢ RbRRЭR>$RbRRЭR>&RbRRЭR(RRЭR)RRݭݭ  RRíRRRRRЭRޢ0RbRRЭR4RRݏ@   ݭݭ  @   RRíRRRRRЭRޢtRbRRЭR>xRbRRЭRzRRݭݭ#  RR؏   RRRRխ1íRRRRRPRR޼ SíRRc޼(R b4  0  ,  (  $                      
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @   @     P  \                                     :      X'  '  @(  '  '  '  '  '  '  '  (  x(  p'  '  '  '  '  '  '  (  (  8(  0(  X(  ((  p(  h(  `(   (  P(  (  (  '  (   (  '  x'  h'  `'     \  d  $     $   ,          
   D  |        4  &          `  h  x   P        (               `                r @        
   Z'  b'  j'  r'  z'  '  '  '  '  '  '  '  '  '  '  '  '  '  '                                                                                                                                                                                                                                                     G                        [rh $      RCP011.B                       :  E9  [B]RPC$LLBD.EXE;2                                                                                                                   $                               #       '  '  (  
(  (  (  "(  *(  2(  :(  B(  R(  Z(  b(  j(  r(  z(  (  (  (      @   
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                         
RPC$LIBNCK                             (      A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A   B  B  B  B  B  B  B  B   B  $B  (B  ,B  0B  4B  8B  <B  @B  DB  HB  LB          A                                                                                                                                                                                                                                                                                                                                                                                                                                                             * [B]RPC$NIDL.EXE;6 +  , :   .     /    4                             - E9    0   1    2   3      K  P   W   O     5   6 @1Ε  7 `QΕ  8          9          G   H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   H                        ۸ $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            R              0 D X     0205      (  N      t                                     RPC$NIDL                               RPC V1.1       rΕ 05-05           #           4 $        X      %     [       % :     (     _     M       
       ?          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001  Name already declared: %s
 case_%s %d %f "%s" false true c pascal unix ip implink pup chaos ns nbs ecma datakit ccitt sna dds %s
 [last_is()] attribute already specified %s
 [max_is()] attribute already specified %s
 Attribute already specified Invalid family name: %s
 tagged_union . NAMETABLE_NIL_ID true false Dumping interface

 UID
 	time_high = %08x
 	time_low  = %04x
 	family    = %02x
 	host      = %02x.%02x.%02x.%02x.%02x.%02x.%02x
 Version = %d
 Implicit handle var = %s
 Handle type = %s
 Exported Item: %s  Type = constant_k
 Type = type_k
 Type is %s
 Type = routine_k
 integer constant: %d
 real constant: %d
 string constant: %s
 enum ordinal val = %d
 named_constant: %s
 small_integer_k short integer_k long_integer_k hyper_integer_k small_unsigned_k short unsigned_k long_unsigned_k hyper_unsigned_k short_bitset_k long_bitset_k short_enumeration_k long_enumeration_k short_real_k long_real_k short_subrange_k long_subrange_k open_string_zero_k fixed_string_zero_k open_array_k fixed_array_k record_k named_k pointer_k void_k character_k boolean_k routine_ptr_k handle_k Lower bound = %s
 Array elements = %s
 Index_type = %s
 ...
 	Transmit type = %s
 	Last_is = %s
 	Max_is = %s
 	[handle]
 upper bound =  bound to type
 Referent is %s
 Set base type = %s
 names %s
 Bound to type: %s
 user_marshalled type
 Transmitted as: %s
 User type: %s
 Enumerator name: %s.  Lower bound =  Upper bound =  	Variant tag_id = %s
 Variant tag type = %s
 case tag value is  	field_name = %s
 Field type = %s
 	field_name = %s
 Field type = %s
 Array elements = %s
 	routine attributes
 idempotent = %s
 maybe = %s
 broadcast = %s
 	routine parameters
 	Routine result
 	parameter name = %s
 Handle parameter
 input parameter
 output parameter
 reference parameter
 Parameter type = %s
    Unexpected (or unimplemented) type ( ) encountered in %s ; exiting.
 .
 ( ) %s name %d is "%s"
 %d open_type #define NIDL_GENERATED
#define NIDL_ CSWTCH CSTUB SSTUB 
#include "%s.h"
 %s_ 
  ( ,  )
 {
 return  (* %s$client_epv . )( ,  );
 }
 
static    void  %s_csr 
#ifdef __STDC__
 
 #else
  ( ,  ) 
 #endif
 
static    void  %s_csr  ( ,  )
 
/* parameter declarations */
 
/* local variables */
 volatile   /*   */  ;
 
/* marshalling init */
 data_offset= ->data_offset;
 required_alignment resulting_alignment fixed_size_type remove_named_type_nodes open_delta_exp open_base_type xXx_%x_ %s%s_ %s.%s %s.%s %s%s_ %s.%s %s.%s %sipp_ %si_ %sepe_ %scv_ %sel_ (*%s) (*%s) %s[0] %s [0] *%s (%s-%s+1) (%s-%s+1) (%s*%s) (%s*%s) count (%s-%s+1) (%s-%s+1) (%s*%s) (%s*%s) (*%s) %sxmissible_p_ (*%s) %sxmissible_ (*%s) %sxmissible_ %s%s_ %s.%s %s.%s %s%s_ %s.%s %s.%s %sstrlen_ patch_node (*%s) %s_ bound += ( ) * %d;
 =  & ;
 for( = ;  ;  --){
 ++;
 }
 bound += %d * ( );
 bound += strlen((ndr_$char *)  );
 CSPELL_bound_calculation 
/* convert user marshalled types */
 _to_xmit_rep( , & );
 bound=0;
 
/* bound calculations */
 bound += %d;
 rpc_$align_ptr_relative (mp, dbp, %d);
  =  & ;
  =  ;
rpc_$marshall_ushort_int(mp,  );
 rpc_$unmarshall_ushort_int(mp,  );
 rpc_$convert_ushort_int (drep, rpc_$local_drep, mp,  );
 rpc_$advance_mp(mp, 2);
 if ( > ) SIGNAL(nca_status_$invalid_bound);
 #ifdef ALIGNED_SCALAR_ARRAYS
  =  mp;
 rpc_$block_copy( (rpc_$byte_p_t)mp,  (rpc_$byte_p_t) , (rpc_$byte_p_t)mp , ( *%d));
 rpc_$advance_mp (mp, ( *%d));
 #else
  =  ;
 for ( = ;  ;  --){
 ++;
 }
 #endif
 _free_xmit_rep ( );
 _from_xmit_rep ( & , & );
 count =  ;
rpc_$marshall_ushort_int (mp, count);
 rpc_$unmarshall_ushort_int (mp, count);
 #ifndef ALIGNED_SCALAR_ARRAYS
  =   rpc_$malloc (count * sizeof );
 #endif
 count =  ;
 rpc_$convert_ushort_int(drep, rpc_$local_drep, mp, count);
 =   rpc_$malloc(count * sizeof );
 rpc_$advance_mp(mp, 2);
 count =  ;
 rpc_$marshall_ushort_int (mp, count);
 rpc_$convert_ushort_int (drep, rpc_$local_drep, mp, count);
 rpc_$unmarshall_ushort_int (mp, count);
 =   rpc_$malloc(sizeof +((count-1)*(sizeof )));
 rpc_$advance_mp(mp, 2);
  = rpc_$malloc( );
 rpc_$ un marshall_string( convert_string(drep, rpc_$local_drep,  ,  %d,  mp,  );
 rpc_$advance_mp(mp,  +1);
 switch ( ) {
 case  :
 default:
 break;
 default: SIGNAL(nca_status_$invalid_tag);
 }
 rpc_$ un marshall_ convert_ ( drep, rpc_$local_drep,  mp,  );
 rpc_$advance_mp(mp, %d);
 CSPELL_marshall 
/* marshalling */
 if (rpc_$equal_drep (drep, rpc_$local_drep)) {
 
/* unmarshalling */
 } else {
 
/* unmarshalling */
 }
 
/* len calc */
 %s=mp-%s-data_offset;
 _unbind( , handle);
 handle =  _bind( );
 cleanup_status = pfm_cleanup (cleanup_rec);
 if (cleanup_status.all != pfm_$cleanup_set) {
          if (free_ins) rpc_$free_pkt(ip);
     if (rpc_$is_comm_failure_status(cleanup_status)) {
         *  = cleanup_status;
         pfm_$enable();
         return;
         }
     else
         pfm_$signal (cleanup_status);
     pfm_signal (cleanup_status);
     }

 #ifndef __STDC__
 #endif
 handle (*%s) *%s handle {
 
/* rpc_$sar arguments */
 volatile rpc_$ppkt_t *ip;
 ndr_$ulong_int ilen;
 rpc_$ppkt_t *op;
 rpc_$ppkt_t *routs;
 ndr_$ulong_int olen;
 rpc_$drep_t drep;
 ndr_$boolean free_outs;
 status_$t st;
 
/* other client side local variables */
 rpc_$ppkt_t ins;
 rpc_$ppkt_t outs;
 handle_t handle;
 pfm_$cleanup_rec cleanup_rec;
 status_$t cleanup_status;
 ndr_$ushort_int data_offset;
 ndr_$ulong_int bound;
 rpc_$mp_t mp;
 rpc_$mp_t dbp;
 ndr_$ushort_int count;
 volatile ndr_$boolean free_ins;
 
/* marshalling init */
 data_offset= ->data_offset;
 
/* buffer allocation */
 if(free_ins=(bound+data_offset>sizeof(rpc_$ppkt_t)))
     ip=rpc_$alloc_pkt(bound);
 else 
     ip= &ins;
 rpc_$init_mp(mp, dbp, ip, data_offset);
 ip= &ins;
 
/* runtime call */
 ilen=mp-dbp;
 ilen=0;
 op= &outs;
 rpc_$sar( 0 +rpc_$brdcst +rpc_$idempotent +rpc_$maybe ,
 (long)%s,
 &%s,
 %dL,
 ip,
 ilen,
 op,
 (long)sizeof(rpc_$ppkt_t),
 &routs,
 &olen,
 (rpc_$drep_t *)&drep,
 &free_outs,
 &st);
 
/* unmarshalling init */
 data_offset= ->data_offset;
 rpc_$init_mp(mp, dbp, routs, data_offset);
 
/* buffer deallocation */
 if(free_outs) rpc_$free_pkt(routs);
 if(free_ins) rpc_$free_pkt(ip);
 pfm_rls_cleanup (cleanup_rec, cleanup_status);

 
/* return */
 return( );
 }
 #ifndef IDL_BASE_SUPPORTS_V1
 The version of idl_base.h is not compatible with this stub/switch code.
 #endif
 #ifndef RPC_IDL_SUPPORTS_V1
 The version of rpc.idl is not compatible with this stub/switch code.
 #endif
 #ifndef NCASTAT_IDL_SUPPORTS_V1
 The version of ncastat.idl is not compatible with this stub/switch code.
 #endif
 #include "pfm.h"
 globaldef    ;
 %s$client_epv %s$epv_t globaldef     = {
 ,
 %s_csr 
};
 = NULL;
 = NULL;
 
 =   rpc_$malloc (sizeof +( *sizeof ));
  =   rpc_$malloc (  * sizeof );
 if (  != NULL) rpc_$free((char *) );
 if (  != NULL) rpc_$free((char *) );
 CSPELL_dealloc_param _free ( );
 & (  *) 
/* server call */
 = (*manager_epv-> _ ) ( ,  h &h );
 cleanup_status = pfm_cleanup (cleanup_rec);
 if (cleanup_status.all != pfm_$cleanup_set) {
     if ( != NULL) rpc_$free( );
     if ( != NULL) rpc_$free( );
     pfm_signal (cleanup_status);
     }

 
static void  %s_ssr 
#ifdef __STDC__
 (
  handle_t h,
  rpc_$ppkt_t *ins,
  ndr_$ulong_int ilen,
  rpc_$ppkt_t *outs,
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  I                        ^w $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                             "              ndr_$ulong_int omax,
  rpc_$drep_t drep,
    *manager_epv,
  rpc_$ppkt_t **routs,
  ndr_$ulong_int *olen,
  ndr_$boolean *free_outs,
  status_$t *st
)
 #else
 (
 h,
 ins,ilen,
 outs,omax,
 drep,
  manager_epv,
  routs,olen,
 free_outs,
 st)

 handle_t h;
 rpc_$ppkt_t *ins;
 ndr_$ulong_int ilen;
 rpc_$ppkt_t *outs;
 ndr_$ulong_int omax;
 rpc_$drep_t drep;
  *manager_epv;
 rpc_$ppkt_t **routs;
 ndr_$ulong_int *olen;
 ndr_$boolean *free_outs;
 status_$t *st;
 #endif
 
{
 
/* marshalling variables */
 ndr_$ushort_int data_offset;
 ndr_$ulong_int bound;
 rpc_$mp_t mp;
 rpc_$mp_t dbp;
 ndr_$ushort_int count;
 pfm_$cleanup_rec cleanup_rec;
 status_$t cleanup_status;
 
/* unmarshalling init */
 data_offset=h->data_offset;
 rpc_$init_mp(mp, dbp, ins, data_offset);
 data_offset=h->data_offset;
 
/* buffer allocation */
 if(*free_outs=(bound>omax))
     *routs=rpc_$alloc_pkt(bound);
 else
     *routs=outs;
 rpc_$init_mp(mp, dbp, *routs, data_offset);
 
*olen=mp-dbp;
 
/* buffer non-allocation */
 *free_outs=false;
 *routs=outs;
 *olen=0;
 
st->all=status_$ok;
 }
 #include "pfm.h"
 %s$epv_t %s$manager_epv globaldef     = {
 ,
 _ 
};
 %s$server_epv %sa 
static rpc_$generic_server_stub_t  
static rpc_$server_stub_t  []={
 ,
 (rpc_$generic_server_stub_t) (rpc_$server_stub_t) %s_ssr 
};
 globaldef  rpc_$generic_epv_t  rpc_$epv_t  =(rpc_$generic_epv_t) =(rpc_$epv_t) ;
    Too many imported files open_type %s
 [last_is()] attribute can only be applied to array types %s
 last_is variable does not exist %s
 last_is variable must be a scalar type %s
 last_is must be a scalar
 %s
 [max_is()] attribute can only be applied to open array types %s
 max_is variable does not exist %s
 max_is variable must be have scalar type %s
 max_is must be a scalar
 File: %s not found %s
 tag type does not agree with discriminator type %s
 tag type does not agree with discriminator type %s
 tag type does not agree with discriminator type %s
 Invalid tag type %s
 open arrays illegal in unions or variant records %s
 Only top level pointers are allowed in NIDL %s
 Only top level pointers are allowed in NIDL %s
 Enumeration is invalid in this context %s
 Invalid array index type %s
 Enumeration is invalid in this context %s
 Array elements cannot be open arrays %s
 Array of pointers requires a transmit_as %s
 Enumeration is invalid in this context %s
 Array elements cannot be open arrays %s
 Array of pointers requires a transmit_as %s
 Records containing pointers require a transmit_as type %s
 Open field must be last in record %s
 last_is required %s last_is must be applied to an array
 %s max_is must be applied to an array
 %s
 Sets can only be over enumerations %s
 Short bitsets can only have 16 elements Subranges must be integer or enumeration
 Subranges must be integer or enumeration
 Lower bound must be less than upper bound
 %s
 reference types can only be used in parameters %s
 rpc_$drep_t type can only be used in local interfaces %s
 last_is must be input parameter %s
 max_is must be an input parameter %s
 type must be a handle %s
 [out] pointers not allowed
 %s
 This type requires the [transmit_as()] attribute
 %s
 Records/structs containing open arrays must be [in] or [in, out]
 %s
 Records/structs containing open arrays must be passed by reference
 %s
 variant records/structs containing open fields are not allowed
 %s last_is must be applied to an array
 %s max_is must be applied to an array
 %s
 Handle parameter required %s
 Handle parameter must be an IN parameter %s
 MAYBE routines cannot have output parameters %s
 Out parameters must be passed by reference. %s
 This type requires a last_is attribute %s
 This type requires a max_is attribute %s
 Handle_t legal only in first parameter position. %s
 Too many [comm_status] parameters %s
 [comm_status] parameter must be an out %s
 [comm_status] parameter must be of type status_$t status_$t %s
 [comm_status] parameter must be of type status_$t Constant name: %s not found
 Not a constant: %s
 Name: %s is not a type.
 Type name: %s not found.
 (Warning) Type name: %s not_found.
Type void* assumed.
 Interface uid must be specified
 rpc.idl   NULL ndr_$true ndr_$false %d %f "%s" %s record_type typedef struct  %s$epv_t  {
 }  ;
 %s$client_epv globalref    ;
 %s$manager_epv globalref    ;
 globalref rpc_$generic_epv_t  globalref rpc_$epv_t  %s$server_epv ;
 * (* (*%s) 
#ifdef __STDC__
 
#else
 () 
#endif
 %s ) [1] [%d]     ;
 ;
 %s #define    
 ,
   /* case(s):  ,   */
 struct {
 }  ;
 u boolean byte small_int short_int long_int hyper_int char short_float long_float ndr_$ ndr_$char ndr_$char rpc_$drep_t handle_t struct   {
   ;
union {
 }  ;
 } void enum { } void * CSPELL_type_exp typedef struct    ;
 typedef  struct  ndr_$ushort_int ndr_$ulong_int #define  _mask_none (%s) 0
 #define  _mask (%s) 0x%x
 typedef  #define   ((ndr_$ushort_int) 0x%x)
 typedef  typedef    ;
 #ifdef __STDC__
 handle_t  _bind(  h);
 void  _unbind(  uh, handle_t h);
 #else
 handle_t  _bind();
 void  _unbind();
 #endif
 #ifdef __STDC__
 void  _from_xmit_rep(  *xmit_object,   *object);
 void  _to_xmit_rep(  object,   **xmit_object);
 void  _free(  object);
 void  _free_xmit_rep(  *xmit_object);
 #else
 void  _from_xmit_rep();
 void  _to_xmit_rep();
 void  _free();
 void  _free_xmit_rep();
 #endif
  (
 ,
   /* [ in, out in out ] */ void ) extern     
#ifdef __STDC__
 ;
 #else
  ( );
 #endif
 %s$if_spec static rpc_$if_spec_t   = {
   %d,
   { ,  %d },
   %d,
   {
   0x%08.8lx,
   0x%04.4x,
   0,
   0x%x,
   { ,  0x%x }
  }
};
 %s_included #ifndef  
#define  
 #include "idl_base.h"
 #include "$(%s.%s).h #include "%s/%s.h #include %s.h #include "%s.h "
 globalref    ;
 #endif
   "" ./ file %.*s ,  line %d of file %s  <eof> of file %s  near "%.*s" :  [error %d]  syntax error
 
file %s: ( %d ) %s****  ****  r File %s: %s
 %s
 error: %s on line %d of file %s
    Name not found: %s . Unable to open %s for %s access
    _CSTUB.C,_SSTUB.C,_CSWTCH.C nidl.tmp ansi confirm def dump_after dump_ast env exts f77c f77s idir m nametbl no_def_idir no_stubs no_warn out pascal s space_opt ungraceful version yydebug r w unable to open %s.
 File: %s not found usage: NIDL fileName [flags]

 nidl version 1.5.1
 -ansi is no longer needed.
 Should specify -s or -m; assuming -s.
 Cannot specify both -m and -s.
 rpc$idl: [] idir %%s_v%d .h .ins.pas   Illegal option ftype in getflags: %d
 Unknown flag (%s) in getflags
 Options table:
     %-*s 	illegal option in printflags: %d
 	%d 
 	%s 
 	%s No Yes 
 	%s Yes No 
 	%c 
 	%.3f 
 	%D 
 
    Symbol table overflow
  too many scoping levels
 Can't pop symbol table
 


id = %s
 Bindings for id @ %Fp
 ------------------------

 	bindingLevel = %d
 	theBinding = %x
 	nextBindingThisLevel = %x
 	oldBinding = %x
 	boundBy = %x

  %s$if_spec var
  : rpc_$if_spec_t := [
   vers := %d,
   port := [ ,  %d ],
   opcnt := %d,
   id := [
     time_high := 16#%x,
     time_low := 16#%x,
     reserved := 0,
     family := chr(16#%x),
     host := [ ,  chr(16#%x) ]
    ]
  ];
 nil true false %d %f '%s' type
 const
 var
 %%s_%d_t  =  ;
 NIDL internal limit exceeded: MAX_ANONYMOUS  =  ;
  :  ;
 ,
   ,   :  (
 );
 ^ function  procedure   :   ; options(val_param, extern) integer8 integer64 unsigned8 unsigned64 boolean char integer integer32 set of  .. unsigned unsigned32 char real double array [ ] of char char_ptr rpc_$drep_t handle_t array [ ,  ] of  array [ .. ,  ] of  record
 case   :   of
 end ^ ( ) univ_ptr pspell_type_exp function  _bind (in uh:  ): handle_t; options(val_param, extern);
 procedure  _unbind (in uh:  ; in h: handle_t); options(val_param, extern);
 procedure  _from_xmit_rep (
   in  xmit_object: univ_ptr;
   out object: univ_ptr
 ); options(val_param, extern);
 procedure  _to_xmit_rep (
   in  object: univ_ptr;
   out xmit_object: univ_ptr
 ); options(val_param, extern);
 procedure  _free_xmit_rep (
   in  xmit_object: univ_ptr
 ); options(val_param, extern);
 procedure  _free (
   in object: univ_ptr
 ); options(val_param, extern);
  = %d;
  =  ;
 (
 ;
 in out  in  out   :  univ  
) ; options(val_param, extern, d0_return);
 ; options(val_param, extern);
 function  procedure   :  ; options(val_param, extern);
  : extern    ;
 %s$epv_t  = record
  :  ;
 end;
 %s$client_epv  : extern  ;
 %s$mgr_epv  : extern  ;
 %s$server_epv  : extern rpc_$generic_epv_t;
  : extern rpc_$epv_t;
 %s_included %%ifdef   %%then
%%exit
%%else
%%var  
%%endif
 %%include 'idl_base.ins.pas';
 %%include '$(%s.%s).ins.pas %%include '%s/%s.ins.pas %%include '%s.ins.pas %%include '%s.ins.pas ';
 Out of memory
 boolean_k byte_k character_k fixed_array_k fixed_string_zero_k handle_k hyper_integer_k hyper_unsigned_k long_bitset_k long_enumeration_k long_integer_k long_rea                                                                                                                                                                                                                                                   J                        0O $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            >! "     !       l_k long_subrange_k long_unsigned_k named_k open_array_k open_record_k open_string_zero_k pointer_k record_k routine_ptr_k short_bitset_k short_enumeration_k short_integer_k short_real_k short_subrange_k short_unsigned_k small_bitset_k small_enumeration_k small_integer_k small_subrange_k small_unsigned_k user_marshalled_k void_k unknown  %ld %lx %lx bad switch yylook %d unexpected EOF inside comment at line %d
 ARRAY array BOOLEAN boolean BYTE byte CASE case CHAR char CONST const DOUBLE double END end FALSE false FUNCTION function HANDLE_T handle_t IN in IMPORT import INTEGER integer INTEGER8 integer8 INTEGER32 integer32 INTEGER64 integer64 INTERFACE interface NIL nil OF of OPTIONS options OUT out PROCEDURE procedure REAL real RECORD record REF ref rpc_$drep_t RPC_$DREP_T SET set STRING0 string0 TRUE true TYPE type UNIV_PTR univ_ptr UNSIGNED unsigned UNSIGNED8 unsigned8 UNSIGNED32 unsigned32 UNSIGNED64 unsigned64 VAL val interface import typedef const struct union bitset enum set int byte char unsigned hyper long small float short void double boolean case switch string0 handle_t rpc_$drep_t true false NULL BROADCAST broadcast COMM_STATUS comm_status IDEMPOTENT idempotent HANDLE handle IMPLICIT_HANDLE implicit_handle in LAST_IS last_is LOCAL local MAYBE maybe MAX_IS max_is out PORT port REMOTE remote SECURE secure TRANSMIT_AS transmit_as UUID uuid VERSION version # %d %s Too many %%includes
 r Couldn't open include file %s
 %8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx state %d, char 0%o
 yacc stack overflow syntax error error recovery pops state %d, uncovers %d
 error recovery discards char %d
 reduce %d
 Too many ports
 @(#)astp.c	2.1     (ultrix)        6/13/89      %W%    (ultrix)       %G%              @(#)checker.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                       @(#)cspell.c	2.1     (ultrix)        6/13/89    @(#)errors.c	2.1     (ultrix)        6/13/89                            @(#)files.c	2.1     (ultrix)        6/13/89 @(#)frontend.c	2.1     (ultrix)        6/13/89      5         5                                                                                                                                                                                                      -5  @(#)getflags.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @(#)main.c	2.1     (ultrix)        6/13/89  @(#)nametbl.c	2.1     (ultrix)        6/13/89                                                                                       M                                                                                                                                                                                                                                                  @(#)pspell.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                                                       @(#)sysdep.c	2.1     (ultrix)        6/13/89                                                @(#)utils.c	2.1     (ultrix)        6/13/89                                                 A    A    A    A    A    A    A    A    A    A    A    A    A  	  A  	  A  
  A  
  A  D  B  D  B    B    B  ?  "B  ?  +B    .B    1B    8B    ?B    GB    OB    XB    aB    kB    uB    B    B    B    B    B    B    B    B  =  B  =  B    B    B     B     B  "  B  "  B  !  B  !  B  ;  B  ;  B  >  C  >  C  $  C  $  C  %  C  %  'C  C  ,C  C  1C  '  6C  '  ;C  F  DC  F  MC  *  VC  *  _C  +  iC  +  sC  ,  ~C  ,  C  -  C  -  C  <  C  <          C    C    C  7  C    C  8  C  )  C    C  9  C  $  C  :  C    C    C  *  C  /   D  0  D  5  D  2  D  1  D  3  D  	  #D    +D    0D  6  7D  %  ?D  ?  HD  >  TD  C  YD  D  _D            dD  E  nD  E  xD    D    D  
  D  
  D  @  D  @  D    D    D    D    D    D    D    D    D    D    E    
E    E    E    E  #  "E  #  )E  4  0E  4  7E  B  CE  B  OE  (  TE  (  YE  .  aE  .          @(#)yaccpar	4.1	(Berkeley)	2/11/83                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         65    ]  ;5    S  C5  J    G5    U  R5    T  [5    { _5     d  d5     _  i5     `  n5  J  h  s5     a  u5    c  }5     \  5     { 5     ~ 5     X  5     ^  5     b  5     ȱ  5    { 5      5    @                                                                                om967 +*  v r ne_C      ;   pS2 L t     AE M + 'B %$ -     tfL L   D   NO      ;    KLJ  t1F L       <        , N   t     A    K  K E  t Ep t./    J m :  t s ^ B 
    QPU   HG(  % (}~ I((     3     44  F  kT  RO    LI&
 {j\ 	3] \         [T- . , iW )  SV   U        q c -,b   / 3 7 6 5 ( / 
4 V *  1 0   \ 5  A   Z  F H e Z~ J - . , A)        z  A  3 PK 87   ( / 74 6  *    1 0 J  xB  h\ )\      Q   >? g(F "q     z Y &d  { ]  :@`>a _   !    y ` # ;#51*)( | $Y Y b.c02 w   7 6 5  :4 g :=<@:CD::=    M v  Y      
  u A 	  U o  l 9 x     P   - . , =  ? ) Q N @      X   2          [ B?    3 = 9 7   ( / + 4     *    1 0  - . , ' i h ) & % a j $ \  # " r !    [ [         - . ,    )  3  T S R 7   ( / h 4 O }   * - . , 1 0 W )  M   " 3 [ !\ 7   ( /  4    * w H 1 0  3 I G 8u7 6 5 ( / 4 sV l*  
1 0     
|'\     	Z - . , y)  0dEG    ^ YD X- . , C n k ) Rq > 8    f 3 < WW 7 6 5 ( /  4     *     1 0     3         7 6 5 ( /   4         *      1 0                                                                 M(.UHPNANNRLU2	:3?>*510/UW'                                                                                                                                                                                                                                                   K                        '1 $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                             "     2       V 7nUMGU:*QHGQ
UUUU 4
EORRRVU8901%)UoNml4
E*+,-"	?>UFQMRJJRHRNGHRyxwUvutsSpTN@BLL|L99M6UUokjHPQWWUVCDUNK!$%=URGHMrqUSToUSHNNN{zU||WUVCDNJoQHiyilPRR@BUIM UMNRQRGU;RyPSqMUUUUUUUUOOOHPjyhg}yHNNNQH
RUGHUH;RrPPQQQQR~}RGzUHNNUUUPHPHIGGUHNNPQHHrRHRQg}UUQQQSGUURU}UQQPQQGHNUQGRQRNQRQRRQRQRR                    0102                                    	

 !##.(3"&1&2")4+5,6 









///8111239&14:5;6<9>:?;@<A>C?D@EAFCHDIEJFKHMJNST//VW1/YZ\]2122_`bcefhikl        2/   $%                  										  $    						        &&&&&&&&&&                    						'          (            )                ----------*          +------,""""""""""""""""""""              """"""""""""$/  ------$$$%                                """"""""""""  $/  $/    $/                $0-7-7-7-7-7-7-7-7-7-7            $/-7-7-7-7-7-7....................              ............      -7-7-7-7-7-7            7=7=7=7=7=7=7=7=7=7=  ............7=7=7=7=7=7==B=B=B=B=B=B=B=B=B=B              =B=B=B=B=B=B      7=7=7=7=7=7=            BGBGBGBGBGBGBGBGBGBG  =B=B=B=B=B=BBGBGBGBGBGBGGLGLGLGLGLGLGLGLGLGL              GLGLGLGLGLGL      BGBGBGBGBGBG            LOLOLOLOLOLOLOLOLOLO  GLGLGLGLGLGLLOLOLOLOLOLOOPOPOPOPOPOPOPOPOPOP              OPOPOPOPOPOP      LOLOLOLOLOLO            PQPQPQPQPQPQPQPQPQPQ  OPOPOPOPOPOPPQPQPQPQPQPQQRQRQRQRQRQRQRQRQRQR              QRQRQRQRQRQR      PQPQPQPQPQPQ            RSRSRSRSRSRSRSRSRSRS  QRQRQRQRQRQRRSRSRSRSRSRSTUTUTUTUTUTUTUTUTUTU              TUTUTUTUTUTU      RSRSRSRSRSRS            UVUVUVUVUVUVUVUVUVUV  TUTUTUTUTUTUUVUVUVUVUVUVWXWXWXWXWXWXWXWXWXWX              WXWXWXWXWXWX      UVUVUVUVUVUV            XYXYXYXYXYXYXYXYXYXY  WXWXWXWXWXWXXYXYXYXYXYXYZ[Z[Z[Z[Z[Z[Z[Z[Z[Z[              Z[Z[Z[Z[Z[Z[      XYXYXYXYXYXY            [\[\[\[\[\[\[\[\[\[\  Z[Z[Z[Z[Z[Z[[\[\[\[\[\[\]^]^]^]^]^]^]^]^]^]^              ]^]^]^]^]^]^      [\[\[\[\[\[\            ^_^_^_^_^_^_^_^_^_^_  ]^]^]^]^]^]^^_^_^_^_^_^_`a`a`a`a`a`a`a`a`a`a              `a`a`a`a`a`a      ^_^_^_^_^_^_            abababababababababab  `a`a`a`a`a`aababababababcdcdcdcdcdcdcdcdcdcd              cdcdcdcdcdcd      abababababab            dededededededededede  cdcdcdcdcdcddedededededefgfgfgfgfgfgfgfgfgfg              fgfgfgfgfgfg      dededededede            ghghghghghghghghghgh  fgfgfgfgfgfgghghghghghghijijijijijijijijijij              ijijijijijij      ghghghghghgh            jkjkjkjkjkjkjkjkjkjk  ijijijijijijjkjkjkjkjkjk                                                    jkjkjkjkjkjk                 	                    
                                                              # $                                                             ! %   " .                                                                ;F  =?@AB  ? @ A B C D E F G H I J K L M N O      &   / P        P         "#$%&'(                                          :  D    <   
     ( ) * + , -   P 2   : ; < = > V W X Y Z [ \ ]       P                             P      34)      7,                	                        9C    H    > ' 0 1   4     8     R T   P e      h k o   x P   z     P           P           !/    5  *+.-           
                  EG  KLOPQ    I3         Q   U       b d    g i     q P x l     t     f                   1068           J      5       S   P   P   P j p P   r y s                2  
MN    6 7 9 P   P c a    P u         ^   `     v w P m {       _ |     n                     }     ~                       I) N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	
	"$'0000000000AAAAAA$$$$$$$$$$$$$$$$$$$$$AAAAAA$$$$$$$$$$$$$$$$$$$$                    k >i8 e  d c >Xc  g    / bY$feB &  @dO  ( cy  b Y F  33 } | {  w  LJO   $   u ;]O "  _ \ U ^{ { S  O s  $   r !n DL  k  3)> 90&#  
u] v = # @3I3 J H G FC C -N  EF #> "  
 
 	 3;3  5 4       !  3 ) > > IFF?F E#> ; F   Z w( SBqr  {yxwvtki h uen{dc}`_^Ym k W V  QOML HG?>20.(&
  $       !   # -
o	  
 | t  i   j .  	 ve i 
             	  
 
                                            ! ! ! !   " " " 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 $ $ & & ' % # # # # # # # # ( ( ) 0 1 1 2 * , + 3 3 3 3 6 5 5 4 4 8 8 : ; ; < < 9 9 = 7 7 > > > > > > ? ? @ - - . /   B B C C C E E G F H H   I I D J J K K K K A L L L M N P P Q O O S S S S T T T T R R R R  U W X Y V V V [ [ \ Z Z ] ] ] _ b b b b b b ^ c c d f f g g g g a a          h h h h h o i i w w w w x x x x j j j k l m n q p r y s { { | | } ~ ~  z z          t t t      u u u v e e                        ` ` `                                                                                                                                                            	                                                                                                                                                                                                                                                                                                                                                                           L                        :1Z $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            u "     C                                                                                                                                                                                                                                                                                                                          &         &      <      $   ,               $      6               $      $     $ $     , Ҍ         B         N         6   4 8   < $   D $     L $     T $     \ $     d $     l $     t $     | $               (         $      $      z         $      $            `             $ 4   Ȭ     $     Ļ B                  $     ̻ N         j         8         f     Ի  4      4      4      4 ܻ Ȍ                           p                  $               Ԍ                                                                        ,                  ڌ                           Z                  $               $               $      $      Ԑ                   N                  6         ȑ                  :         B                  >                           @         6                  |                           ~         *         v                                                      j         ƍ         $                                                                                                                                                                                                                              6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
                                                                      	                     
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ^y PЭPЬ ЭP ЭP P  ^ЬPՠЬPЬ޼PЬ`ЬPЬPްPЬ`ЬPЬ P  ^ PЭPЬЭPЬЭPЬЭP ЭP ݭݬ+  P(߭ݬ  ݭCJ  P  ^	  PЭP P ^BSJ PЭRլ
ЬPP$PߣЬP=   P7  PЭЭPЬЭPЬЭP ЭP  P ^CBRЬQСPP# N ~    "?P1 ЬPРPЬPݠߢ#H    PPЬPPPP~ߢ&oH  l  PP߭ЬPݠ  ݭߢ)5H  2  PP ЬPޢ4PPPޢ.PP  PPP< ^ PoЭS޼R(bЭR ЭR  P  ^ЬPՠЬPЬЬPЬЬPЬPРPЬЬPЬ   P  ^ЬPՠЬPЬЬPЬЬPЬPРPЬЬPЬ   P  ^լ
ЬЬPЬPՠ;ЬPՠЬPЬЬPЬЬPЬQЬPРЬPЬЬPЬPՠ(ЬPՠЬPРPЬЬQЬPРЬPЬPРPЬЬPЬ   P  ^լ
ЬЬPЬPՠ;ЬPՠЬPЬЬPЬЬPЬQЬPРЬPЬЬPЬPՠ(ЬPՠЬPРPЬЬQЬPРЬPЬPРPЬЬPЬ   P  ^ЬPՠЬPЬЬPЬЬPЬPРЭPЬЬPЬ  P  ^ЬPРPЬЬQЬPР   P  ^ЬPՠ;ЬPՠЬPЬЬPЬЬPЬQЬPРЬPЬЬPЬPՠ(ЬPՠЬPРPЬЬQЬPРЬPЬPРPЬЬPЬ  P  ^ЬPՠЬPЬЬPЬЬPЬPРPЬЬPЬ   P  ^]
 PЭPЬ P  ^1
 PЬЭPЬЭPЬЭP ЭP ЭP ЭP  ^ЬPݠ޼P`PЬPРխ;ЭPݠݽPݭݭPЭPРխP  ^޼P`  PЭQЬPРЬPРխ?Pݽ  PЭQЭPРݭݭPЭPРխP  ^޼P`	  PЭQЬPРЬPРխ?Pݽu	  PЭQЭPРݭݭePЭPРխP  ^ЬխRЭP'	ЭP)ЭP'(ЭPРPѠ ЭQЭPРPРЭP*ЭPРխP  ^PЭP ЭP ݭ ݬPP  ^ݬ  P Ьխ=PЭPްP`PPЭPЭЭQPPPPЭPРխѭ   ЭPЭP $ЭPЬЭQPPЭ  P  ^ E
 PЭPЬЭP ЭP ЭP ЭP  P  ^)  PЭPЬ ЭPЬP  ^ЬPРЬPРPРЬPРPРЬPРPРЬPРPAЬPРP ЬPРP ЬPРP ЬPРP AЭPP " zzz.zN
P?P1YЬPРPѠ$ЬPݠЬPݠPC$:  PЭQЬPРPРЭRЬPРPݠ ЬPݠP ЬQPP1PЬPРPѠ$&ЬPݠЬPݠ+  PKP$  PЭQЬPРPРЭRЬPРPݠ ЬPݠ;  P ЬQPP1LЬPРPѠ$*ݏ    PЭP ЭQЬPРH$"  PЭQЬPРPР   PЭQЬPРPР ЭPЭ ЬQPP1 PЬPРPѠ$*ݏ    PЭP#ЭQЬPРH$
  PЭQЬPРPР#s
  PЭQЬPРPР ЭPЭ ЬQPP/PЬPݠЬPݠ  PЬQPPPЬPРPЭЬPРPЭЬPРPЭЬPРPA     ^5PЭQ3PPP P  ^y P'ЭP ЭP ЭPЬЭP  P  ^
5 PЭP ЭPЭЬЭPЭP  ^-  PPPЭPwЭPЬ ݏ   ݭPЭP| ^-6Vﺲ\   P, ߦ9  P                                                                                                                                                                                                                                                   M                         { $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            - "     T        ߦ;  P靈 lR b  ЭR B	(lݏ   ߦB`  Pݏ   ߦGG  Pݏ   ߦJ.  P+ݏ   ߦR  Pݏ   ߦV  PѮݏ   ߦ\  PＱݏ   ߦ_  Pݏ   ߦc  Pݏ   ߦh  Pyݏ   ߦp  PPݏ   ߦvf  Pݏ   ߦzM  P2  ^PЭPЬ P  ^M\JPP  = a  PF?P1 l	  P	  Pll	  P	  PHl	  P		  P$l~	  P
n	  P lP< ^ݏ    PRRЭRЭRЬЭRЬЭR(ЭR (ЭR ,ЭR ´ P  ^=PЭPЬЭP  P  ^  PЭPЭPЬЭP   P  ^+I PЭP ЭP ЭP ЭP &ЭP 'ЭP )ЭP $ЭPЬ P  ^   PЭPЬЭP  ЭP ! P ^-2R&TSc-ЬPՠ ߢ~޼P`z  ЬPc cd0ЬPՠ® ª ޼P`H  
PЬPd d  ^ݬrЬխЭPЬЭPРխ   P< ^=U2TSPRQЬխ8PЭPa%ЭPb&ЭPc'ЭPd(ЭPe)ЭPРխʐ a b c d e P  ^ݬϺЬխЭPЬЭPРխ   P  ^ݬςЬխ"ЭPЬݭHЭPРխЬP  ^1  PЭPЬ ЭPЬ$P  ^ݏ     PЭP ЭP ЭPЬЭP ݬAPЭPЬЭPЭЭP ЭP ЭP P  ^"  PЭPЬ( PЭPЬЭPЭ,ЭP 8 P< ^ЬR=´ ЬR(GЬRK(ЬR,ЬR0ЬRµ ݬa   (ﻫ  ب ͨ ͨ  ^
ݭ  PЭPЬЭP P  ^ЬPЬP}ЬPuЬPa d U R C P ^e.S PPPPЬRPբPPPPЬRPբPPPP Ьխ1@ЭQСPP  < `  
P?P1 ЬQЭPРs	iЬQЭPРO	EЬQЭPР+	!ЬPA	  ЭPݠ  `$  PЭRЬPݠ$PЭQ޼P`PP ЭQЬPAAЭQЬPРЭQЬPРЭнխ1 P^,Sf[CZDY9XfWSVUTZR ЭQЬP A4 ѭ61YP@bP`P@P`ѭdЬPЭ81PѭeЬPЭ<1 PѭfЬPЭ@1 PѭgЬPЭD1 PѭhЬPЭH1 PѭiЬPЭL1 PѭjЬPЭP1 PѭkЬPЭT1 Pѭ4ЬPЭXqPѭЬPЭ\YPѭTЬPЭ`APѭЬPЭh)P߭ݭ  ݭ e  PPѭݥ1P  ^PЭPЬ P ^   PЭRݬ:PЭP  ^]   PЭPЬЭPЬ P< ^  PЭS޼R(bЭR ЭR  P  ^ݏ     PЭP ЭP ЭP ЭP ЭPЬBЭP A P ^)Sb  PЭRլ
ЬPPP a  PЭЭPЬЭPЬЭPЬP  ^-PЭPPPЬЭPЬЭPЬЭP ^=)R ѭ/ PPѭP ^)Rլݬ/ ߭ݬ  ݭݬn/  ^(R.ݬK/ 3ݬ8/ P  ^(Rլ9/ M
/ ЬPݠR. ЬP>P<`PPe. ЬP PPx. ЬP'PPЬP&PPЬP%PPЬP$PPЬP#PPЬP"PPЬP!PPl. ЬPݠ(¼X. ЬPՠ,+ЬPݠ,ЬPݠ0  ЬPݠ     ^Ьխݭ   ЭPРխP ^='RЬPݠЬQСPP   ` 8 
P
?PnP	- ЬPްP`R   Lx- +ЬPްP`  $7P- ЬPްP`	  P ^&RЬQСPP 0 H p  j?P1 ЬPݠI, 1 ЬPݠ_, rP߭ЬPݠy  ݭr, KPЬPݠ, 2PЬPݠЬPՠЬPݠ4PP ^%RЬPP "K7W k        3G[os#_PZ?P1-²ݬ+ 1ݬ+ 1ݬ+ 1ݬ+ 1ݬ+ 1ݬ+ 1ݬl+ 1#ݬX+ 14ݬD+ 1yCݬ0+ 1eQݬ+ 1Qeݬ+ 1=xݬ* 1)ݬ* 1ݬ* 1¢ݬ* 1 ²ݬ* 1 ݬ* 1 ݬ|* 1 ݬh* 1 ݬT* 1 ݬ@* vPݬ,* bPݬ* NPݬ* :P"ݬ) &P,ݬ) P:ݬ) P ^#RPPCЬPݠX   PPU޼P`=    ^"Rլ(Pݬj޼P`   ЬPРլP ^"RgSѣ,

{) ,PP,ݬ"ЬPݠݬЬPՠݬЬPݠЬPՠݬЬPݠЬPՠݬЬPݠ¤ЬPAݬ²ЬQСPPGG.C C ...[ [ ... s /. g ..Pv?P1ݬЬP  1PݬЬP-  1PPP½' ݬЬPݠ21P1ݬЬPݠ Y  ЬPР$խݬݭ  1Pݬ]' PPЬPݠ1PݬЬPe1PݬЬP-  1 PPPЬPݠ1 PPЬPݠЬPՠ PP	ЬPݠ `}PPPPPЬP  SPP]& PP2ЬPݠPPFЬPݠ ,PP,    ^mR޼P`խFPPPЭPݠU)ЭPްP`ЭPРխ ^
Rݬk% ޼P`Sݬzp% ЬPݠ- ^RݬaЬPݠЬPՠPPЬPݠЬPРխ#PPPݭ   ЭPРխP ^1RЬPРխ6Pݬ¶$ ЭPfЭPРխЬPРխ@PЭPݠPPЭPݠЭPРխ ^RЬխ@PЭPݠ`PPЭPݠЭPРխ ^9RPPЬPݠAPP޼Pݠ a ^R$# ЬPPP9	ЬPPPJЬPPPVf;# ЬPРխݭB   ЭPРխЬPՠ)ݬ{" ЬPݠ    ^1RݬЬPݠЬPРPA¢" ЬP&´o" ЬP'tP" ЬP(U1" ЬPݠ  ^`R	V  PH  P     ^E"R! Sbc! ݬc  ݬߢ%c! ﶔߢ9c! x! ߢEݣ m!  ^!RߢHݬQ!  ݬݬ  ߢJ   -!  ^!R߭ݬA  ݭߢL    ^e!R߭ݬ  ݭݬO    ^3!Rݬߢ`     PP  ^ЬQСPP   Pj?P
PЏ   P2  P ^ Rլ PЬQСPP $[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [  _ [ _ [ _ {  g     P?P|P PЏ   PЬPݠkPPPPЬPՠ$ PЬPР ЭPՠЭPРЭPՠЭPݠ%PPPPЬPݠPPPPߢcЬPݠw2  P  ^ЬQСPP ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; 	?P
PЏ   P2  P  ^  լRPЬPѠ8ЬPРPЭPPխЬЭPЭPЬЬЬPРլխЭP P ^Rߢmݬ] ЬPP  ) = 	>?P:P ݬ0 &P ݬ P ݬ ݬ¥      ^XR ݬݬ[լ1APЬPްP`PPݭҟ  · ЬPݠ  PPЬPРPPЭ» ݬk ݭЭPРPݠݬ   ½ ݬ@ ЭPРխ>  ݬ ЭPݠݬЭPРխ ݬ ЭPРխ*ЭPݠЭPݠݬa  ЭPРխ ݬ ЭPՠ"ЭPРPРPѠ! ݬl  ݬ\  ݬp  Pݬ ݬ. ЬPݠݬ ݬ ЭPРխ=  ݬ ЭPݠݬЭPРխ ݬ  ݬ ЬPРլ1 ^R ݬf լ=߭߭ ЬPݠݬ   ݬ' ( ݬ  PPPP  PPݭPPݭPPݬ  Pݬ
  	ݬ ݬݬ+  ݬ                                                                                                                                                                                                                                                    N                        7 $      RCP011.B                       :  E9  [B]RPC$LLB_.VXE'$                                                                                                              N                              2           (	19;Wྒྷ/5셪@@Bu:/0 $AFm΃3
g(6I_zȑD=,T: ٧PW,o> ԁcܸXE6RA#n_OL	z];Bdw2K\?Wp~XeȍÃrV83ierxDȰ lc?/+A	x7i"(ޜ Xc&-s;^?a]<F _a3-4g76Wnt/LBSokٺ'>f2Hl{u+ Q悂.݀{1>XSG%Н~fF!+5FJ޺F
kq~>-nK˅py?[*py{wY^#uMz&Oauz,r\Y@sqwA2]=,M{]
|vş*nav&:Aǡ޻*ul<O#x%;JV3BZ/$&FYlrUzq@7S;Ӵ]*-NA^hfxn/,8UMO4e(!NKk.oQ	,Nx]e?.8Q+ﵾwY0(G϶ڼjNj9 r*/PAϛj_yfPqwgڈ3mPĜ"+;^͓\3K+"X3wIo%HXZh0H턶t+<=/OQ9=ک874vdyP.xw]+iZ}wZ="ͅW}1Ѿ&}S;% sACv' /kȱiAjtMO|aHwc>FD/֘3䵝^|Ba9)UdSHڀr-mڬ՜	Y-D:
,`㲀;wǲh	,zI&<Q*%p	~2 sQ͙D92j3=e֐zaY*	|%Kt.ݔ=B䋇	mܴXblͦOŉרOqFڷ]64,ފpEHڔ3'-[`2Z!@ZpǽLWIQ<V 1ܻH!s
ĭԾ?	{eB}is|2-Ԓb(ق[h2ڃ4m3	R۷YG,i/̦HiN_[71wv]T\8;>8:jC,oZt0&5pk}%1sR	9rU-e\cC%ӠIbvBܪ']m/dʽ/o9eh7	=vG5)S3 =1rEڴi$jB܉BJylXhBy\:cHMEop4N.Om- 7kBQ{{?[qJ\,Ԭ7ܑރ&~@ܯ^5Dػ2-llBFۚux"8{Kl (riډe#&	h&ܰX?pꃌDAuםyY_B`͎lWReSm{,Eu<#{QQʡߗstPk[j,{1wZ3ߵEbe)2shy~lan:m^\ekZ8'&QL3垫/w>&S;G&SxƾFR}r۬ٴ_Cw1	,fT좢*]SO-
^rL(	TCFc!s2Q
-137q;ek^!Nu6ƶt'@}O~A@E@c|"9;6T˒x ț*GB@rL[UZ9]١
 og9
x
-1}`XE	NEJc$i#/sg%xDL@~:٩<v%~v=>;˶}(5v2ǩߣRB7> ,晨~'*jہRBFe| PFC
ۻtX_C6;JC\j/Q/χ]H+JfyGh"BׁJhQK~oxiq+]kߋ7NaZ`Hϼ&_)%7v̷5.-$uRGs)Pɇ%7+gQ\/XGfY^sʰz;$.a@nqr6@7"¾W%`mk}XlYtc\їd?v}euwm/&2VrqQ9.JuE ѡ>$z_#e`ٶjm$7VHz\5[JC~HGd^^˴J!7aHͶ	ԃ ptV Tహ8mZ;ĽĄfdSO<8zYܫ)d
+mt#j:ZK0FuYH^ws#ޚ!+~tX$9:
't?nČvS/>
w[(0%eYk[p[vi?˭ɛxhw2Q9G M'6&$:x Sģ|/e,D?#PjGXBt*לF{lcfՈT ͠IJy&Oɶ
ҳQSoa:u.¹h~B2DYUC㵞;ݓ 5uMugųWej,x9TNxHrHK0N@(^/Lt-Lw4Od\2<c̑\`pB	 Cz`ug^Zt?6Y*govjWf7Uaj=6P?;H:+tڭ)CpHN嶨ֿG6%"6jcS;5BsRӇo\
yJ;g"V
d(	}<&8UvM.	eiF&ztPوb×',g2R?ݺUU@O?RWl#F.*6HEn	?O0(Nq&ƭ󷐛vŚ*BQh$%N&ty#A=p0˔8}!g8'Tր]tf&Epn15=i)O`y'8f
~9"sњn7ƦkR,hgZ^,ܳ6d?,8Yj|ӅehER 䱑R)54E,]o]ߺGoIA5C;c
3ӣ`ڽyɏ8ݛ0ַkR+˽}<^O .uQX$F?rx\ШQe~kdOiM'hFCSnn"jPRoa>)j\ .SCW c<3aD߫3 z~\JWWԸ4Ű_ڑZ^,)~XZqi%%CO{_LW+-%T{ ML"ZS,׎]cg{3ل1]=	e9Z+)<oEZsI[_D'k.h e;;	,q>+XօgIE}qZrM4oMq$e1ӊßDD93qa4F.ؾ$3矣,㣻 ty5~v$'a̐ 4	'3֌x@pZhMDÛcĵ#7]M gD%a%?ꄦyxMF	?@^C=͞<p+{ "8o>pm}d x7D	:/ľj~"_`9kBEaM栫Z*I@V h|2ߘce4M]!cPt][gm	rsGWRǷ]*ϮJUF_M$OψzS_\1Ρ gQVc7#u2C,)
@b^:V	O2\i'34Z́,"x|*89̑)5#vU,D|{ԵM5lKo&u;Y`Ha`t)EOZABޖNflE5y`>y
u.߆~S>EWꔏ0GCKSV_kb66.|cEq'
V8UMx;wBYaHC'eSvL%cd˰8
^GxhĊL,ӽ&W"_hXFSzh38WTYc|d7ڬ],/ca{9`gZGfq}Pŝm$u%sKrlI
,+-YѨ[)"R2!yLi0ޒ~|u0징\I+]8
sTQ^˺9"
7H_,Tig#:>>=~)_ӺYz_ަt(Ԩ}
/&eirP}_1r]GnvtTbc!)x]54ExnsHxgswrѐ:+^HUr9
&o䚻xL|3B_BJ\zPUpό1="3 ɡe]xjp9~
@1ixSC7yF;s `Riۆ2bk!.2Xq
r֡GCbR|]{8d"kiEU)f0=Q׽ŖJ\S]4VDA`H$*=2`tL1p̖GGrK"έ[mփԞENa"0j&~}ڠY3J9R{c}q%2>W~0ft6GyO>$-
7[¯Dеrpy-+qQԕ봲?
B\JV(M*yr#53mr]#-E*ҟHETvrd0jr;FJ.}@:O	'8<zyVw+>Gb1B1 +'])5:bc`v(vx>^\QvQ!NdTԅ1
-^d極>=^AwH: q l,
p[mhgp[%&Efp` )ᇖoԺvYd{N:d 
r#[ѥ5j|A8nv$ct](-D#G؄1EWum*MՈq`FeW  c""EZorb0s2}X1lWF^-f]ѱ[t%`nvln}uCj[N}r3؋(\O/
ܖU@EeBh+2P/ɗ
@ОyZMMTDD9B]֫'ESqH4!kۥ^&/uow/L@)"%D);fX[xmdc]ȡ,}٤` 	]RRĞ@U N`M{Tm?Byc=l=+\}	kO%RnzgvkM/aᚼZ(nEpAY$43tTGMf\UP8Y[=Y8~G#9&Qsɜ%rY06a"9˥Yc<> u,d
j% QQ5ׯe86.Dĸckw-#9!i)؏A><U[]&gSμ/::dq2dDU)-w>G_}f&hV8%NdD!+4
U,9Q{s_'3%(nEZfx%jՏNCZ7Ӯ+DF/}*=?b=BԩJMVjKQ1fIN*;w"q/hpZY>)@JȌ}"1mo\
:c'wBT
't&3r_|7L=!Kdp||̗Q1r<Ԑ9HFnTw>JҎ+F+ZXm~oL#	u$M!w;]RvO+n>4,Sgw٩N]S^qe$
LrA-QJ
e5ZcZP
ƤA3Ǫf*>XLhp":EvribJC!TXR.27Gxa܌鎨-5X},'cKPJ\HҹTHDi2?%Xt{kq#jBGg*^ ;!=o6\l{d_ـacֻs!Џ0e|-
탕2m=lǳO.@5]p:p2f PĖ8&Gc"_)Su{c(!̞ݑͯRoMmE]youWl[p(YxcHoLKjAY+ZL_cKi!4EL#	[qUy'ʗ[(&
8h30m皀&!R[(T[	`{ hy ϕ_i6&OxYH-4~X]x#.aؿ3*UF,9ܠ-d%ߛEDHl~^V~_,ciqFL28iyz$ڳ_&Ol4㎖iFZJk5fϧIո-l scpLI=z5QG6Xf{qzЀ=
E8[Q2<1\G](WlƷbG%Ը1J6Vc%vƥdXw
un̄9ѵVWF8+{o QїM-i	tt+V%Dզd?J  [K$ ~Sqgzmze3B`h&xS},rEjD#3>Rճhɑ\$߶Kn\/p0Rz)&`r9U6uL2_ndY*Nv05]%&WUP"PEw2f
Sn}u
pm +>dGdΉ2#KVs^irN'coܘs24)bL:׹Xζ:t1_؞ׅ_>J;)8KDJ}P
[f
V|+5%r\
mEqm9@`Ã=f>$F7L5/)kf_w(hzY HHMnHTyO1Hѐ6:po܌"oq+׬$w/8m>]Oɤ3B ',+\W=V>VpT7ᡨDw1b@BWK︟ShP}೬[C!ָS1Cx127]"M%+4#A ̨*);<jdI__:	F-)yF.C$9,EΆ9KXomh"eb^XU3gu)	67)3 !#HӃZ:mt|wVZ?&Gبat&."UJѝ Nn{)4}ʇh8LmxPWy"J6!'WЄq!b{ZK`G_:N|jzQpDtݜEGT"h2=Re^J#b4 (5[6ABhS(	akt;F@s;&s+-Y2~ .S4h2{hI]9>%A쟼k#eELB 
7]E\j# ں	-#dޠs޹ht|1oCcsWGJG+έTЄ*t.D޺~<$/SO*=
dIUa 2l
5O}$7gT#Թ[p6C`6Լ	5W:8QQQ"  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ!  PPPQP
Pн`FP
PP|ЭxxP|    O                        _ $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            ^ "     e       ݬ $ݬs լ?P 'ݬP ЬPݠݬЬPРլ*ݬ ,  .   (^eR6ݬ լ>߭߭ ЬPݠݬ  ?ݬ )PAݬ  PPPP  PPݭPPݭPPGݬh  Pݬ~  Nݬ& լ> Qݬ ЬPݠݬЬPРլT   ^9RլWݬ լ+PЬPݠЬPݠݬ9  ЬPРլP  ^RЬPРխ1 PЭPѠ
ЭPѠ
1  vݬ' ЭPݬ ݽЭPݠ	ݬ劉  ЭPՠ3ݬ ЭPݠݬݬ ¢ݬ ЭPРխ1B ^R¥ݬ| ¾ݬl ݬݬ1ݬM  ^RЬQСPP $X X X X \ ` d X \ ` d X \ ` X \ ` ` d X \ ` ((($$    (h ((( ?P1 PPPPPPЬPݠl2PPPP ЬPݠU2PPPPЬPР խ4ЬPР PQՠQQPPPPЬPР Pݠ2PPPP ЬPР$Pݠ2PPPPPP ЬPݠP2PPPPЬP 2  P  ^ЬPՠPЬPРЬPՠЬPݠ
2PPPPP ^!RЬQСPP $X X X X \ ` d X \ ` d X \ ` X \ ` ` d X \ ` ((($$   (h (((| F?P1 PPPPЬPݠs2PPPPЬPݠ_2PPPPЬPР$խJЭPРխ+ЭPݠPЭPРխ2PPPPЬPݠ ϻ2PPPPЬPݠ2PPPPЬPݠ2PPPPPЬP 2  P  ^  լ1 P BЬPQՠQQPPPPЬPݠP2Q2PPQQQЬPݠ.PЬPQՠQQPPPPЬPݠ4Pխ PPPЬPРլ1XPPP| ^VЬRТPP $c c c c g k o c g k o c g k c g k k o c g k [ [ |==A AE|s ||| P?P1"Џ   PPPPPRRЬRݢ`PP ЬRݢLPP PЬRТ ݭ*Pխ PЭ ݭL2PSݭ2PRRSSխ
ȭRRЬRТ խ*нR^(n=|  ĭPPЭRТխЭP P PЬRТ խݭϻPխ P ЬRТ$խ
ЭP1 PЭRТխ. ݭφ2PSݭ2PRRSSխ   ݭPݭ2PRR ЭRТխqPЭRݢPЭRբ ЭRТRݢP2RRѭ̭í̭RRRѭЭЭЭRТխRRRRPЬRݢ2  P|  ^EVլ PЬRТPP $                   >    >    >&[  >$P^?P1ЬRݢ wPЭRբ2ЭSЬRѣ#!UP䞽RR(B ЭЭSЬRТЭPЬPЬSЬRݢPЬPЬSЬRݢPЬPЬSЬRݢPЬPЬSЬRݢPЬPЬRТ խ&PЭSЭRݢϗPЭRТխЬRТ$խdЭSЭRݢfPЭRТխAЭRТխ%PЭSЭRݢ3PЭRТխЭRТխЬPЬRТ(խ#ЭSЭRݢPЭRТխЬRТ,SЬRТ,RݢPЬPЬSЬRݢϪPЬPЬRݢ ^ЬRЬPݠvP   ^ЬPРխݭЭPРխЬPݠ ^ЬPѠЬRЬPݠPP ^ЬQСPP  W + ? 	?PBPЬPްP`/PЬPްP`TPЬRЬPްP`ϬPP ^ЬRЬPݠ0ώP0ЬRТխݭcЭRТխ ^
Rլ PЬQСPP<  3  E    	?PrPݬЬPݠPPЬPР;PЬPРPЬPРЬPР ЭPՠPнЭPРЭPՠݭЭPݠTPP*ЬP 2  P ^RլЬPЬQСPP/  &  ]   =    M *?PqPЬPРP}w  PPЬPݠPPЬPݠPPЬPР ЭPՠPЭPРЭPՠЭPݠMPP9ЬPݠ P  ^  PЬЭPЬ	ЭPЬ
ЭQЬPРЭPЬЭPЬPЭ  ^RݬH߭D  ߭B  PPPݬݬݬݬݭZЭP  ^ݏH     PЭPЬЭPЬP  ^ v  PЭPЬ P ^
RЬPՠЬPՠݬЬPݠݬݬݬЬPՠ ݬݬЬPݠݬݬݬЬSݬݬ ЬPݠ\ЬPݠݬy  PVЬPݠݬ^  PPЬPݠݬC  PЬPݠЬPݠ	ϓ	P   ^Ьխ,ݬݬݭݬݬݬЭPРխլXЬPРЬЭPՠ/ЭPްQЭPРPРaЭP ЭPРЭPՠЭP ЭPP PP ^	Sլ1 ЬPРխbЭPՠYbЬPݠݬA  PhЬPݠݬ%  PnЬPݠݬ	  PPЬЬЬݬݬτPЭRݬ ݬЬPݠݭݭݭϗPݬ ݬЬPݠݬݬݬݬݬ
PЭPP PPX^wXFY޼RbЭRѢhЭRݢ ݬ^P޼SЭRТcݬ,ݬ($RRݬ ݬݬݬݬݬݬݬPЭRЭCЭPݬݬ|PЭRЭCݭϖPЭRݭP1ЭS ͇$6ЭR1-Ь(R&$Ь(R'լЬR'͇RR͇͇RR22RR.ЭR ݬ,ݭtݬ  PzP3ЭR ݬ,ݩ{ݬȵ  PLPЭR ݬ,ݭȀݬ  PPЭR ݬ,ݩ ȇݬl  PP(ЭRЭ?ЭSݬ,ݬ($RR޼RbșЭRݢ)  PȓЭRݢ  Pȍݬ  P  	ϝP޼RbRѢȥRR̓
ȟRR̓̓߭ ЬRТխ9нR^(n]o  ĭPPȨ߭a ЭRТխЭR߭ݬ\  PЭSѬ &޼RbPȬݬ.  P߭ݬ  PЭ$CլЬRТ RТЬRТ RТլЬRТ RТЬRТ RТ1EPլ1߭ЬRݢ﹯  ߭ݬ絛  ݭ͈n ͈j PPЭRB͈.PRRЭRB͈.R B͈ݭ͈   ͈)  P߭ݬ&  ݭ͈ ͈ PPЭRB͈.PRRЭRB͈.R B͈ݭ͈  ͈塞  Pլ1߭ЬRݢ  ߭ݬ  ݭ͈K ͈G PPЭRB͈.RRЭRB͈.R B͈ݭ͈   ͈	  P߭ݬ  ݭ͈ ͈ PPЭRB͈.PRRЭRB͈.R B͈ݭ͈|  ͈  Pլ1ЭR GȰ޼RbRݢZPݭ  PȺ޼RbRݢ1Pݭk  PѭЭRЭ ЭRЭ$FݭPЭRݭݭ'  P ЭRݭݭ  P$ЭR,ЭVѬ    P)P޼RbR^(nJk  ĭPPφPЭ-GPЭWЭV޼RbR^(nk  ĭPPNP$Ц$ ЭRGЭR ,լ1 ޼RbRݢPݭ;  P޼RbRݢطPݭ  PѭЭRЭ7ЭRЭ;8ЭRݭݭܯ  P7ЭRݭݭ  P;PЭSЭRТ 7ЭSЭRТ$;ЭP 0^ S2>TЬQСPP $Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y j  	?P1ݬݬϳPPݬ$ݬ PPЬPݠݬݬ  Pݬݬݬ	8PPݬݬ_P ݬ$ЬPݠtPݬM  PPݭ1  PЭPЭЭRݬ$ݬ PPЬPݠݭݭݭ  	ϞPЬPݠaޕPM ݬ$ЬPݠPݬﳭ  P7P&ݭ  P4 ݬ$ЬPݠ,ݬn  PPЭЭRݬ$ݬ PPЬPݠݭݭݭ  	PЭPݬݬPЭRݬ$ݬ ЬPݠ ݬݬݬPЬPР$խ1ݬݬϮPЭRݬ$ݬ PPЭPݠEЭPݠݬ׬  P?ЭPݠݬＬ  P9ЭPݠݬ  P  	PЭRݬ$ݬ ЭPݠWЭPݠݬc  PQЭPݠݬH  PKЭPݠݬ-  P  ϛPЭPЭؠfЭP ݬ;ܕPQЬPЭPЬЭRݬϭPЭPЬЭRݭݬP ЭRݬP$ЭPݬ$ݬ PPЬPЬPݠ ݬݬݬݬݬPPXg  PЭRЬPР   PЭЭRЬPР$ݬ$ݬ PPЬPݭݬݬݬݬݬyPЬQЭPР$ݭe  ݭZ  ЭPݬݬXPЭR ݬ$ݤ ]ݬN  PPЭPgЬPݠ)PP  ^ЬQСPP3  _    	?PnPݬЬPݠݬpPݏ    ݬЬPݠPݬBݏ    ݬݬϪPݬ  ݬݬݬϦ ^SЬP$ЬPՠݬЬPݠЬPՠݬЬPݠЬPРЬPݠώٕPvЬPРPѠ ЬPРPРPРЬPРPРЭPP' + ' + + + + + + + + ' 	?PPPrݭ  PЬRݬݬݏ   ЬPݠݭЬPݠЬPݠЬPݠЬPݠ	P ЬP3$  ^SЬRЬRЬR ЬR ЬR  ЬR !ЬRТRТRѢ!
ЬR &ЬRТR &ЬRТR'ЬRТRЬЬRբ
                                                                                                                                                                                                                                                   P                        3	 $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            - "     v       RТPЬRТЭŭխ]ЭRxЭPݠ|  PЬPѭ	 %PЭPՠЭPР	ЬPРЭЭŭխ ݞRRЬRբЬRТ	ЬRТЭխ1 PЭPРPѠ2ЭPРPѠ ЭPРPРPѠPЭPЭЭЬPѭ #ЭPՠЭPР	ЬPРЭŭЭխЭR ЬRЭݢЭݭխ1 PЭP%	ЬPЭ!ЭP&	ЬPЭP'	ЬPЬP ЭPݠϔ֕P	ЬP ݬݭώݬЭPݠЭPݠЭPРխ1pЬRբ*  ݬ ЬRТRݢЬRТRݢ  ^  լ1 P 8ЬPQՠQQЬPݠ2PP­PPխ
PPЬPՠЬPݠK2PPPݬЬPݠݬЬPQՠQQPPPPݬ.PP޼P`ЬPРլ1QPPP ^Rլ PPPݬPխЭPЬQСPP   p ( L 
P6?P1ݬЬPݠݬPPݬxPPЬPݠЬPݠݬ ݬTPPЬPݠЬPݠ ݬݬ[PPЬPݠЬPݠ ݬݬ:PPЬPР#PЬPР
  ݭ 2PPPíPPխ
PPݭϋ2PPPPPխ  ݭϖPխaPP|ݬ  լЬPР PPЬPР$PPݭݬݭݬ  ЭPЬPݠݬyݬ  ЭPѠݬ{  լЬPРPPЬPРPPݭݬ!ݬ=  ݬ-  ЬPݠݬݬ
  լЬPР PPPЬPР$PPݭݬݬ  ЬPݠݬ¢ݬ  ЬPݠݬg¥ݬ  ЬPݠݭݬ ݬPPЬPݠݬ «ݬ<  °ݬ,  խRݭ³ݬ  լЬPР PPЬPР$PPݭݬݬ  ЭPݬ  լЬPРPP
ЬPРPPݭݬeݬ  PЬPݠPP  ^RЬլ1!PլЬP&1 PѬЬP'1 PЬPРЭPѠ$-ЬPРPѠ ЬPРPРЭPѠ$P1 ݬ   ݭݬj  )ݬ  լЬPР PРPPЬPР PРPPݭݬ=7ݬY  ЬPР Pݠݬ;ݬ2  ЬPРլ1 $^R  ?ݬ  Ьլ1 PլЬP&1 PѬЬP'1 PIݬ   3ЬPPPЬPݠ<2PP­PPխ
PPЬPՠЬPݠϠ2PPPЬPݠ ЬPݠݬЬPQՠQQPPPPݬ~PPЬPРլ1!PPPPdݬ    ^լ]PЏ   ЬPQՠQQPPݭݬݬЬPݠݬݬϓ޼P`ЬPРլ ^Sz,R$2PPrݬG  P ^RЬPݠݬݬ  ЬPѠݬ  լЬPРPPЬPРPPݭݬ ݬ   d^#R+SЬPG1ݬЬPP    Pn?P1 ЬPݠ(ݬ1£ݬM  լЬPР PPPЬPР$PPݭݬ§ݬ
  ЬPݠ(ݬݬ  pݬ  ЬPݠ(ݬݬ  ;Pݬ  ЬPݠ(ݬa$ݬ}  P(ݬh  $ЬP,VAݬK  ЬPݠ(ݬFݬ(  ЬPݠ-ݬHݬ  ,PЬQլЬPР PP
ЬPР$PPЭ(ЬPѠ
ЬPРPЬPРЭ ЬP1Ѭ	PPꐭPPPP1nݬs  $ ݭ2PPPݬѬYЬP2PѬJЬPݠ3ݬݬ  ЬPݠ?ݬݬ  1 ݬݭݬݬϛݬ  Ѭ¦ݬ  ºݬ  ЬP2ѬЬPݠ3ݬ[ЬPݠݬEլݬ\  ݬL  ЬPݠ(ݬ
 ݭϡPݬ  Bݬ  ЬPݠ(ݬ ݭZPݬ  $	ݬ  ݬݭݬݬeѬOЬP2FЬPݠ3ݬ[ݬw  ЬPݠݬ8ݬT  ݬD  ЬPݠݬݬ!  ЬPݠ(ݬݬ  ЬPݠݬ"ݬ  ЬPݠݬ%ݬ  ݭҰP$$ݏ   ݬЬPݠݭݬݬ	ЬPݠݬ<+ݬX  0ݬH  3ݬ3  P $^RЬPРЬPP    P?P1mPPݬЬPݠݭ ݬݬݬa  ;ݬ  ЬPݠݬ{Lݬ  1PPЬPݠݭݬݬuݬݬva  PݬR  ݭϵƕPaݬ5  լЬPРPРPPPЬPРPРPPݭݬcݬ  լЬPРPPPЬPРPPݭݬgݬ  ЬPݠݬݭݬPP ^R$Sݬ&1ЬPP  h XF?P1kݬ8  լЬPР7PP
ЬPР;PPݭݬtݬ  1vPѬ1 ݬ  ЬP2ݬ  ЬPݠݬݬ  ЬPݠ?ݬ ݬ|  ЬPݠݬݬY  ЬP2
ݬ@  5Pݬ,  ЬPݠ7ݬݬ	  1 PѬyݬ  ЬPݠݬZݬ  ЬPݠ?ݬL]ݬ  ЬPݠݬ)yݬ  P}ݬp  $PPݬݬݬݬݬϐP ,^RJ"S&1IݬϩЬPP  y ] 	?P1
ݬ  ЬPݠ ݬݬ  ¢ݬ  1 PѬݬ  1 Ѭ1 ݬ  ЬPݠݬH/ݬd  ЬPݠݬ2ݬA  ЬPݠݬFݬ  ЬPݠ$ݬZݬ  `ݬ  $&PPݬЬPݠЬPݠ ݬݬ &  8^V WѬoѬiЬPP    	r?PNPJPЬRݢݬ1yݬM  ЬRݢݬƉݬ*   ݬϤƍݬ  ЬPP $  8 ?P:PƓݬ  Ɩݬ  PƧݬ  PЬRݢݬyݬ  լ-ЬR޲RbR^(nbK  Pݬc  ݬS  լЬRТRRЬRТRRݭݬݬ  3ݬ   ЬRݢݬݬ  $ ^@RSݏ   ݬЬPݠЬPݠݬݬϠլЬPРPРPPЬPРPРPPЭܭݬ_  ݭݬ$	ݬ@  2$PPЬPРPР䐏ЬPРЬPРխ1 ЭPРխeP	ݬ  ЭPݬP  	ݬ  խЭP 	ݬ  ЭPРխPP$PPݬЭPݠЭPݠݬݬυ	ݬU  н2$PP2$PPЭPРխ1%#	ݬ  N	ݬ  PP$    ^dRSݬϓP1< ݬπǰP2PPݬ@$լЬPРPPЬPРPPЭQ	ݬ  ЬPP '  ; P^?P:PW	ݬP  Z	ݬ@  Pd	ݬ,  PݬݬQ  m	ݬ	  Ѭo	ݬ  	ݬ  ݭݬ屮	ݬ   ݬ'P	ݬ  1ЬQСPP\\8 t ( P 
Pf?P1ePPݬݬЬPݠݬݬH1UPPݬݬݬݬݬ11ЬPР$խ
PP횭PPݬЬPݠЬPݠ ݬݬЬPР$խ$PPݬЬPݠݭݬݬ1 PPPݬݬݬݬݬ81 PPݬݬݬݬݬnPPPݬݬݬݬݬ|JPPPЬPݠݬݬݬݬݬ\$Pª	ЬPݠPP ^QSR$ЬլtPլЬP&TѬЬP'CP ú	ݬ  ݏ   ݬЬPݠ ЬPݠ ݬ`ЬPРլ  ^Ѭ 	Ѭ6hЬPРլ!PЬP&Џ   PЬPРլ PЬPРլ"PЬP'Џ   PЬPРլ P  ^9RS1 	ݬ  $Ьխ1 PլЭP&`ѬЭP'OP 	ݬO  ݬݭPPPݬЭPݠ ЭPݠݬ ЭPРխ
ݬ  $Ьխ~լЭP&`ѬЭP'OP 
ݬ  ݬݭZPPPݬЭPݠ ЭPݠݬτЭPРխ4
ݬ]   ^R7
ݬ@  ݬݬH
   %   ^Rݬݬݷ_
ݬ  ݬݬﾷh
    ^ARt
ݬ  ݬݬ~
ݬ  ݬݬb
 }   <^R
ݬ`  ¶
ݬP  !
ݬ;  ݬݬݬ
ݬ  լ1 ݬ  Hݬ  ЬPݠݬ﮶Rݬ  fݬ  ~ݬ  ݬ  ݬ  ¤ݬz  ݬh     U   ^RЬPްP`PPݭPY  ЬPݠݭЭPݠЭPݠЬPݠݬrݬ  ЭPݠݬ	ݬ  լDЬPѠ Ь)PЬPРЬ                                                                                                                                                                                                                                                    Q                        \&. $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                             "              P1 PЭPРЭPРPQѠ QQPPPPЭPРPРPЭPРЭPѠ1 ЭPݠ8  PPЭPРMЭPРЭPݠ  PPЭPР  ~  P'ݬ  *ݬ  Eݬ  `ݬt  vݬd  ݬT  ݬD  ³ݬ4  ݬ$  ݬ  ݬ  
ݬ  *
ݬ  =
ݬ  O
ݬ  n
ݬ  ЭPЭPSP
ݬ  §
ݬx  ¾
ݬh  
ݬX  
ݬH  ЭP
ݬ/   ݭݬϣЭP
ЭPՠ! PPPP+ݭݭЭPݠ!PPЭPPPݬIݭݭݬЭP1 ݬ  ЭPݠ  ݬ/ݬl  ݭݬ1<ݬM  ЭPݠ  ݬLݬ&  fݬ  ݬ  »ݬ  ݬ  ݬ   ЭPݠ ݬݬ  ݬ  ЭPݬ  (ݬp  1ݬ`  =ݬP  ݭݬG߭5  ЭPI߭   ЭPV߭  ЭPg߭  ߭ݬ}  ЭPݠݭ߭sݬ  ЭP1 ݬ  ЭP/ݬ  ݭݬGݬc  .ݬS  PP ЭPݠݬeZݬ%  vݬ  ݭݭݬЭPݬ  ¼ݬ  ЭPՠGݬ  ݬ  ЭPРPݠݬeݬ  ݬq   (^RݬT  )ݬD  rݬ4  zݬ$  ݬ  ݬ  ݬ  ݬ  P      <^9Rݬݬ7ݬ6Xݬ  լNjݬ  ݬݬI  uݬb  ݬݬ'wݬC  Ьխ/ PPݬݬݬݭݬЭPРխzݬ~  Pݬ
~  Pݬ  ݭݬݬ  ݭݬxݬ  լOP ¤ݬp  §ЬPݠ}  Pݬ"ЬPРլ®   -   ^RЬլ1 PЬPР ЬPРЭQСPP> f  
Pګ?PRPЭPݠݬ³ݬ  /PЭPݠݬu¼ݬ  PPЬPРլ1g f   0^RЬլ1PЬP'1ЬP&1|ЬPР ЬPРЭQСPP Z 
P?P1EЭPݠݬｫݬ  ЭPݠݬZݬ  ЭPݠݬ7ݬ  ЭPݠ ݬTݬp  ЭPݠ$ݬݬM  1 PЭPݠݬ	ݬ%  ЭPݠ?ݬ寧ݬ  ЭPݠ;ݬêݬ  ЭPݠݬ`ݬ  PPЬPРլ1[P ^	Rݬ/P1ЬQСPP    (        
PN?P1 ݬ@  ЬPݠݬݬ  ЬPݠݬީ2ݬ  1 P6ݬ  ЬPݠݬ數;ݬ  ЬPݠݬXݬ  4ݬݬЬPݠݬP\ЬPݠP ^RЬլ1 PЬPݠ ЬPݠݬόЬPРPѠ$JЬPݠݬD  qݬ  ЬPР Pݠݬ︨yݬ  ЬPРլ1{P ^)RЬQСPPh      
P?P1 ЬPРݭPݭ٨PPЬPРPѠ$}ݬD  ZPݬ0  ЬPݠCݬ1C  ݬ
  ЬP2ЬPݠ3ݬŧPPݬݬﭧ 0^ARݬ  լ1ЬPРPѠ!#ЬPݠݬjݬ  ݬq  ݬݬ6«ݬM  ­ݬ8  ¯ݬ(  լ1 P ±ݬ  ЬPРPѠ´ݬ  UЬPРPѠ &ЬPРPРPѠ¶ݬ  #PЬPݠ ЬPݠЬPݠݬЬPРլ1^¹ e   4^R½ݬH  ݬ8  1	Ьլ1 PЬPР ЬPРЭQСPPn   
P?P1 ݬ  ЭPݠݬ"ݬ  ЭPݠݬz6ݬ  \:ݬ  ЭPݠݬECݬa  ЭPݠݬ"Wݬ>  PЬPРլ1[   }    ^kRЬPްP`PPݭ H  ЬPݠݭϯݬ  ЬPݠt  Pݬmݬ  ¬ݬy  ¯ݬi  ½ݬY  ݬI  ݬ9  ݬ)  ݬ  լ/(ݬ  ݬݬɣ*ݬ  :ݬ  Qݬ  iݬ  ݬ  ݬ  ݬ  լݬp  ݬ`  ݬP  ݬ@  ݬ0  'ݬ   ;ݬ  Qݬ   լݬݬdݬ  tݬ  ݬ  ¡ݬ  »ݬ  ݬ  ݬ|  ЭPЭP`ݬX  ݬH  ݬ8  *ݬ(  9ݬ  Iݬ  ЭP  aݬ  ݬ  ݭݬSЭP -ЭP PPЭPݠݬFЭPݠݬmЭPNݬ  ¶ݬp  ݬ`  PPЭPݠ ݬrЭP ЭPݠݬPլPPPPЭPݠЭPݠЬPݠݬЭP1 ЭPݠݬqЭPݬ  ЭPݠݬρݬ  4ݬ  Qݬq  tݬa  zݬQ  ݬA  ЭPݠݬB¹ݬ  @ݬ  ݬ  ݬ  ݬ  ЭPݠݬc   (    ^Rݬݬݬ+ݬn  =ݬo  P=Ьխ0PݭPPPPݭݬ%ЭPРխ9Ьխ.P PPPPݭݬЭPРխԕ1 Fݬn  PUݬ  ݭݬy`ݬ  ݭݬZbݬv  ЬխUP hݬH  ЭPݠݬ	kݬ   ЭPРխmݬ  rݬn  Pݭn  P蕬ݬž  P¨ݬ  ݭݬuݬ  ЬխvP ݬd  ݬO  ݬ<  ЭPݠLm  PݬЭPРխݬ  ݬ  ݬ׽  *ݬĽ  ݭݬ6ݬ  PLݬ  ݭݬQZݬm    ^ЬPްP`PPݭͯЭPՠ1 ЭPݠDP  ݽM  PPݭЬPݠݬ	PPЭPݠ0ЭPݠ,ЭPݠݭЬPݠݬ욬 PPPPPPݭЬPݠݬ  ^ Ьխ"ЭPѠ	PPЭPРխP ^RݬݬO  P P ѭ4NPŏ  P@8  P޼Qŏ  P@8P`aЏ   PPPѭ42  P ^RݬݬEO  PѢ4d   1 ŏ  4P@<P`ŏ  4P>Q@@Pa`ŏ  4P>Q@BPa`ŏ  4P>Q@DPa`ŏ  4P@8  ŏ  4P@8PЬ`4PP4P>J   ^Sլ PЬQСPP $[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ s [ s [ s  _ { [ [  P?P1  PЬPݠ sPPPPЏ   PЬP ЬP ЬRЬPݠAP!ЬP  ЬP!PPPЬPՠ$ PЬPР ЭPՠPЭPРЭPՠЭPݠPPPPЬPݠPPPPߣЬPݠǗ2  P  ^ЬPѠ	ЬPР ЬQСPP    
P?P
PЏ   P2  P  ^ЬPѠ	ЬPР ЬPQѠ QQPPPPPP  ^RЬPՠЬPРѭ
ЬPР PРѭѭPߢ&ߢ"޼P`E  ЬPݠe  Pխߢcߢ_޼P`E  ЭPѠ  ޼P``E  ЭPРPРѭЭPРPР PРѭ`ѭZѭTѭNѭHѭBѭ	<ѭ
6ѭ0ѭ*ѭ$ѭѭ² ® ޼P`D    ^RЬPՠЬPРѭ
ЬPР PРѭѭP  ޼P`xD  ЬPݠc  Pխ
޼P`GD  ЭPѠ40޼P`$D  ЭPРPРѭЭPРPР PРѭaѭ[ѭUѭOѭIѭCѭ	=ѭ
7ѭ1ѭ+ѭ%ѭѭa]޼P`C  P ^kRݬz  E   ^R OM޼P`0y)gF  *ݬݬޯPPЬPݠJ  PM
   )ЭPްP`D     ЬQЭPРݬЬPݠЬPݠݬݬݭ  E  Э(ЭPРP P  ^ЬЭPՠЭPРЭPՠЭPЬЬQЬPР  P  ^Ьխbݬ߭ЭPݠP
ЭPЭ-PݬݬݭχPխݬݭ]PЭPРխP  ^ЬPP   P"?P
PЏ   P2  P  ^ЬPP                                                                                                                                                                                                                                                   R                         $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                             "               '    P?P
PЏ   P2  P ^)RЬPѠ	ЬPР ЬPРЬQСPP<   d   
P?P1 խ޼P`@  1 ݭKP޼P`@  YݭP޼P`@  1ЬPݠݬ/-)޼P`d@  PP  ^ЬPѠ	ЬPР ЬPѠЏ   PЬPѠ1 ЬPР խ)PЭPݠPЏ   PЭPРխЬPР$խUЭPРխGPЭPРխ)PЭPݠWPЏ   PЭPРխЭPРխ2  P ^]RЬPРխ1 PЭPРխ%PЭPЬPݠЭPРխЭPРխMPЭPݠϷPB>޼P`>  PPݭЭPРխЭPРխ1a ^RЬPРQСPP                 d 4 ?P1 (ˏ$PPws޼P`G>  eЬPРPР PѠ .(ˏZ$PP§£޼P`>  "P޼P`=  P  ^ЬЭPѠ	ЭPР ЭQСPP; ; ; W W    	?P:PPPݬݭ\Џ   PPPݬݭ@Џ   P2  P< ^ЬRѢ	ЬRТ ЬRѢЬRѢЬRѢFЬRТ ЭRѢ	ЭRТkP(ЭSRRЬRЭ  ^RլnPЬPPPݬ޼P`P޼Pް P`<  ЬP޼P`ЬP ЬPРլ ^-RЬPPPнPѠнPѠнPѠ޼P`<  ݽϞPJF޼P`;  6ˏ"PP&ݽPso޼P`;  ݬЭPݠPPݬݽWP ^QRЬPPPнPѠнPѠнPѠ ޼P`(;  ݽP޼P`;  6ˏ)!PP&ݽϣP޼P`:  ݬЭPݠPPݬݽ{P  ^ЬPРխ/ЬPРQЭPѡ
ЬPЭPЭPРխЬPРխ.ЬPРQЭPѡ
ЬPЭPЭPРխ ^RЬPРЭPѠ	ЭPР ЭPѠ Bˏ PP2
ЭPՠP!޼P`9  fݭPXЬPՠ\X޼P`z9  4PЭPѠ'"ЭPՠ~޼P`D9  PPݭP ^RЬPՠ)ЬPݠ~P޼P`8  ЬPՠ)ЬPݠLP¾»޼P`8  P  ^ЬPPP pX  ЭPРխ*PЭPݠЭPݠraЭPРխЭPРխTPPPݭ,ЭPРPՠ
ݭݭϒЭPРPՠ
ݭݭxЭPРխЭPՠPPЭPݠe W   ^RЬPРЭPѠ	ЭPР ЭPѠ#ЭPѠ޼P`7  ЬPѠ5ЭPѠ +ЬP 
ЬP

	޼P`L7  P $^!RЬPРЬPР ЭPѠ	ЭPРЭPѠ	ЭPРЭPѠ!ЭPѠ 5޼P`6  ЭPѠ!ЭPѠ _޼P`6  ЭPѠЭPР
ЭPРЭPѠ
ЭPРPЭPРѭ ޼P`R6  íPPѭ  
ЬPPЬPP ^Rݬݬ2ЬQСPP  RRRRRR  &RRRr   R R RR B 
P>?P1 ݬЬPݠݏ   ݬЬPݠ i1 PݬЬPݠ1 PPPݬݬ1 PPݬݬ1 PPݬx1 PPݬXrPݬ/eݬϻYѬ
լP¸´޼P`4  .PˏPP޼P`4  PP  ^ЬP(ЬQЬPРPР ^]RSЬPРխIPЭQЬPРPѡ	ЬPЭЭQЬPРPѡ	ЬPЭЭPРխЬPРխ1 ЭQЬPРPѡlЬPРЭPѠ	ЭPР ˏcPPDЭPѠ:ЬP'1ЭP'(ЭP&ЬPՠ%!ݽ3  ЭQЬPРPѡ*ˏcPPЭP&IEݽL3  ЭPРխ13P  ^ЬPРˏWPP PЬPРPѠ$ PЭPѠ	ЭPР ЭPѠЏ   P2  P  ^ˏ PP PЬPРЭPѠ$ PЭPѠ	ЭPР ЬP' PЭPѠЏ   P P ^IRЬPѠ#	ЬPРЬPѠ 	ЬPРЬPAЬPѠokݬ2   (^RЬPРЭPѠ	ЭPР ЭQСPPh    F?P1qЬP';ЬP&2ˏPP"ЬP*޼P`}1  1)ˏPP©¥޼P`P1  ЭPР խ}ЭPݠ[P]ЬP'!ЬP&޼P`1  ЬP(*ЬP*!ЬP'%!޼P`0  ЭPРխЭPР$խcЭPРխUЭPРխ9PЭPݠϳPmi޼P`o0  ЭPРխЭPРխP ^%RЬPՠ)ЬPݠϞP°­޼P`0  ЬPՠ)ЬPݠlP޼P`/  P  ^ЬPѠЏ   PЬPѠЬPР ݬΚPPPPЬPѠЬPݠPPPPЬPѠЬPݠPPPPЬPѠ1 ЬPР խ)PЭPݠcPЏ   PЭPРխЬPР$խTЭPРխFЭPРխ)PЭPݠPЏ   PЭPРխЭPРխ2  P ^R ЬPްP`PP aN  ЭPРխ+PЭPݠЭPݠbWЭPРխˏPPtˏuPPdЭPՠ ݽ.  ЭPްP`ЭPРPݠύЭPРP&ЭPްP`-  ЭPРխ1GPЭP'ЭPKGݽ-  ЭPРЭPQՠQQݭLЭPՠ
ݭݭЭPՠ
ݭݭЭPѠ#	ݭύݭЭP)@ЭPݠP/ЭP*&ЭPݠlP|xݽ,  ݭϞP"ЭPРPՠ¬¨ݽ,  ݭP/ЭPРPՠ"ЭPРPՠݽt,  3ЭPРPՠ&ЭPݠ}P	ݽ<,  ЭP%1 ЭQPPQ6	2	ݽ
,  ЭP'\	X	ݽ+  ЭPѠ		ݽ+  ?P߭ЭPݠI  ¹	ݭ  P		ݽ+  ЭPР խ1 K  ЭPՠ,ЭPРPРPQՠQQЭPРPݠP  ^ЬPѠ	Ѡ%ݬ_  ЬPްP` P ^ѸRЬPѠЬPݠJ  Pխ+߭ЬPݠH  ݭ	޼P`*  ЭPՠ+߭ЬPݠH  ݭ
޼P`k*  ЭPРPѠ$ЭPްP`TЬQЭPРPРЬQЭPްP`PP ^R^SݬBI  Pխ PЭPѠ#߭ݬ H  ݭ*
ݬ)  ޼P`޼QЭPРPРaЬQЭPРPaAPPaЭPРPѠ&ݬݬݣ0ЭPРPݠQPPPЭPްP`PPP ^5SЬPѠ1 ЬRЬPЬPA޼P`ЬPݠP ЬPՠ ~߭ЬPݠ;G  ˏ(PPݭC
޼P`(  BP!jPbPЬQPP ݭ]
޼P`(  P  ^ЬխЭPwЭPРխ  ^ЬխЭPݠpЭPРխ  ^Ьխ'ЭPݠЭPݠЭPРխ  ^լP޼P`ЬPРլP  ^ݬjЬQСPP  JJJJJJJJJJ:  J^ J J* B 
P?P1	ЬPݠЬPݠ 1 ЬPݠ ЬPР$խЭPݠ`ЭPݠ1 ЬPݠC1 ЬPݠ31 ЬPݠ ЬPݠxЬPݠ ЬPݠ$ЬPݠOPЬPݠ=ЬPݠϧЬPݠ Ϛ ЬPPЬPݠwP  ^ЬPРխЭPݠwЭPРխЬPՠЬPРPݠOP  ^ЬPՠ0
ЬPݠ01ЬPРխvPЭPՠЭPްP`PPݭЭPѠЭPްP`PPݭЭPѠЭPްP`PPݭ#ЭPРխ ^Ѭ ެQެPެQެP P ЭSެRЭQެPC	A	 PЏ   P ^aR°iZPЬPՠЭQЬPРЭQЬPРPРЬPЭ   (^全Y
V
XW߭ЬRݢB  ЬR޲RbRRhݽ~&   fЭRբ,fRRfЭR´ fRRfЭRµ fRRfЭSЭRݢϷPЭRSբSSRR땭ЭRµ fRRfЭRµ ݭЭRբݬݬЭRݢϝhݭϤѭh1 ЭRբ0ݧ0ЭRݢ01ЭRТխPݭOЭRТխЭRµ 7^(ynЭR^(nP ɕ
ЭRݢ8#  ݽ-%   ^Rf\¶
C  P̰i   < $^޼R(bެR޲R(bѭ(ѭ(ЭPP 3 3 & P?PPíRRRPíRRRP $^-RЬQСPP  ` |    0 b?P1 bݬv  1 PЬPߢݬX  PߢݬE  1 PЬPݠߢݬ)  sPЬPPPP~ߢݬ  RP߭ЬPݠB  ݭߢ ݬޔ  (߭ЬPݠ?  ݭߢ%ݬ   P  ^ݬcPPPP ^Rլ PЬQСPP $[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [  [ [ [ [  _ } [  [  g P?P:P PЏ   PЬPݠ iPPPPЬPݠ SPPPPߢ(ЬPݠq P ^8Rߢ4ݬ  ߢDݬB  PݭݬFrߢMݬc  լPPЬPѠ6ЬPްP`PPЭPݠЬPݠЭPРPݠݬ<  ЬPРլߢQݬ  ݭݬqߢTݬ  ߢWݬA  Pߢeݬ  ݭݬqߢpݬ  ݭݬfq                                                                                                                                                                                                                                                   S                        f=J $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            m "            rݬ  aߢuݬA  P ݬ[  ݭݬ q ݬ<  ݭݬq ݬ   ^亮R ݬ  ² ݬ   ݬ@  Pݬp     <^AR߭ݬ<  լPP
PPP ݬo  լ ݬU  hݭ ݬ<   ݬ,  ݬݬ   ݬ
   ݬ  ݬ  Pݭ
ݬԐ  լ
ݬ  լa ޼Pѭ`SPЭQЬPAݬ  ЭQЬPAݬg  PP޼Pѭ`P ^ٵR߭߭ ݬݬj  ݬ  PPݭPPݭPPݬ ) ^iR߭߭ ݬݬ  ݬ  ЬPPݭPPݭPPݬݬ   U   ^ݴRݬݬݬݬ%   ^﫴Rݬd"    ^yR%ݬԎ  ЬPݠݬm.ݬ  ЬPްP` v0     ^ЬPݠЬPݠ    ^Rլ?P 2ݬ0  ЬPݠݬlЬPРլP ^R7ݬ  լ?P Dݬȍ  ЬPݬЬPРլG    ^RլxЬPՠbLݬj  լݬݬЬPРլVݬ9  ݬݬkYݬ  
ݬݬσP ,^RЬQСPP	$ $ $ $ $ $ $ $ $ $ 
P?PP\ݬ  PPЬQСPP < P  d x   d x   d x  d x     x  
P^?P1 ^ݬ\  1 fݬH  1 kݬ4  zPuݬ   fPݬ  RPݬ  >Pݬ  *PݬЋ  P£ݬ  PPp^;X޼R b޼R b޼R b޼R b޼ R bЬRբЬRݢݬ;jЬRТPP $r r r r r r r r r r r r r r r r r r Rr r >  ..RZ :Rr
P?P1ЬRݢݬi1PȮݬ؊  ݬݬ1Pȴݬ  ޼Rb1Ⱦݬ  ޼RS  Pb޼R޲ Rb޼RbVЬR޲RbR^(nGP1dݬD  1Qݬ0  1= ݬݬ߭ݬ ݬЬRѢЬRТPЬRТݭݬ,խ 	нRRЭԭЬRѢ	P ΘRRRRЬRѢЬRТ$
ЬRТ ЭϭЭحխRRЭRТխ޼SRRR;R  Pc޼R޲ RЭbЬRѢ޼RbR  Эحխ<PЭWRR޼RbVнR^(nPGЭRТխ ѭ6PЭURR޼RbTЭSRRЭRCEѭխݭu  1Pݬh  ݬݬ-gݬI  ЬRТ խPݭݬϣЭRТխЬRТ$խ1 ݬ ݬݬݬݬݬЭRݢݬ-ݬч  ЭRݢݬfݬ  ЭRТխ8ЭRݢݬσЭRݢЭRݢݬЭRТխݬX  ЭRݢݬfݬ5  ݬ%  12Pݬ ݬݬݬݬݬЬRݢݬA޼Rb1 Pݬ ݬݬݬݬݬЬRݢ ݬ	1 Pݬ  1 ݬ  ЬRݢݬ
ݬs  1 ݬ ݬݬݬݬݬЬRТ,RݢݬЬRV  ޼Rb޼SЬRТ(c,ݬ  PЬRݢdPP  ^߭߭ ݬݬ
 Θ^GRЬPްP`PPЬPРЭPѠ$ЭPР ЭЭɭЭQСPP  vvvvvvvvvvvvvvv: v 
P&?P1=#ݬ$  ݭݬc3ݬ  ݭݬc5ݬ  1P8ݬЄ  ЭPРЭPՠݭ7PAݬ  1ЭPРЭPѠЭPРЭPР 
ЭPРЭPѠ
ЭPѠ1 ЭP$1 ЭP$ЭPѠ
IPPPYPPխ3hݬ  ݭݬbݭqݬ  ЭPРխSݬă  ЭPݠݬbݭݭݬ  ŭPPЭPРխݬr  1 P ЭPРխPP§ݬH  ЭPݠݬ	bݭ°ݬ!  PPЭPРխݬ  ݬ  P߭߭ݭݭݬ	ЭPѠ@ݬ  PPݭ욭PPݭPPЬPݠݬݬc  ЭPA1OЭPѠ1Bݬ:  ݬ*  ЬPݠݬ`ݬ  ЬPݠݬ`ݬ  
ݬԁ  ЬPݠݬ`ݬ  ЬPݠݬr`ݬ  ,ݬ~  3ݬn  ЬPݠݬ/`=ݬK  Gݬ;  ЬPݠݬ_Mݬ  Yݬ  ЭPѠ$1aݬ  rݬۀ  ЬPݠݬ_xݬ  ЭPݠݬݬ  ЬPݠݬV_ݬr  ¤ݬb  ЬPݠݬ#_ªݬ?  ЬPݠݬ _¸ݬ  ЭPݠݬݬ  ݬ  ЬPݠݬ^ݬ  ЬPݠݬ^ݬ  ݬ  ЬPݠݬT^ݬp  ЭPݠݬqݬM  ݬ=  ݬ-  ЬPݠݬ] ݬ
  3ݬ~  ЬPݠݬ]9ݬ~  Jݬ~  ЬPݠݬ]Pݬ~  Zݬ~  ЬPݠݬU]`ݬq~  sݬa~    ^ЬPѠѠЬPР PР
ЬPРЭPP    
P?PPЬP aPЭPЬЭQЬPРP ^ЬPSЬPЬPРխ<PЭP'ЭP(ЭRЭPݠ-PЭRТխP ,^R{ݬW}  լ1 լ1 P ݬ(}  ݬ}  ЬP&/ЬP'ݬ|  ݬ|  Pݬ|  ݬ|  ЬPݠЬPݠݬUЬPРլ1PPݬ|  ¢   m|   (^RЬPްP`PPݭj¤ݬ6|  ЭPРPݠݬ3­ݬ|  ЬPݠݬZ¯ݬ{  ЭPݠݬaݬ{  ݬ{  ݬ{  ݬ{    ^լkPЬQСPP  , 0 @ 
PZ?P9Pݬݬi&P!PݬݬݬݬqЬPРլP ^蘒RЬPްP`PPЭP 1ЭSЬPݠ*  Pݬz  ЭPݠݬYݬz  ЭPݠ(ݬz  	ݬz    
ݬXz  ЭQЭPA4ݬ;z  ݬ&z  ЭPݠݬz  ݬy  ЭPݠ#ݬy  ЭP>P<`PP1ݬy  >ݬy  ЭP PPDݬy  Mݬy    Qݬhy  ЭQЭPA!PPTݬHy  Yݬ3y  P ά^﷞RcЬPݠ2(  Poݬx  ݭݬWxݬx  ݭݬWݬx  ЬPްP`PPݬx  ЭPРխ1 ЭPݠJ	  uЭPݠ
  Pݬ<x  CP8x  P°ݬx  ݬw  ݬw  ݬw  ЭPРխ12ЭPՠ,Vݬw  ЭPݠ0ݬݬw  ЭPݠ,ݬCVݬ_w  ݬݬ2ЭPݠݬЭP :PPЭPݠЬPݠݬcPPЬPݠݬݬv    | 0^mTS	Vv  UR բ@1 @1 dݢ@v  PoТ@ݢ@v  P"\\\\ߤݭ<v  P\\\\ݭݭߤe0v  f1 eߤu  \l\\\9ݢ<c\l
c\l \\f\\ߤeu  7Pݢ<c\l
c\l \\f\\ߤ'eu  c\lV Э\LcЭ\Lc
PPխ,
e 8u  cݭߤ9e3u  eߤEu  P ^S"u  TRլ	բD\PPPߣHdt   լdݬt  d
t  լDdߣTt  լd
st   D   ^e=  PЬЭPЬЭPЬЭP ЭP ЭP ЭP ЭP ЭP  ^ݬݬ޼P`PЬPՠЬPЭЬPЭЬPРPЭЬP  ^޼P`EЬPՠ ݬݬݬЬPݠPЬRݬݬݬP޼RbBЬRբݬݬݬЬRݢ~ЬRݬݬݬP޼RbݬݬݬP ^%RPPբ4ݬݬݬaP4Pݬݬݬݢ4 ^R0PP0բ4ݬݬݬ
P4ݬݬݬݢ4 ^}Râ8PP ѭ)Pݬݏ   ݬr  PPѭЬ8 ^R r  S޼P`ݬ޼P`ݬߢbcq  ЬPݠЬPݠcq  ЬPРխ8Pߢ{cq  ЭPݠЭPݠc|q  ЭPРխ  ^ЬPՠЬPݠݬݬݬݬݬЬPՠЬPݠݬݬP ^SRբ4F߭ݬ  Á ݭp  Pݢ4ݭݭV 4 8Џ   P P ^1SRբ< ݬ                                                                                                                                                                                                                                                   T                        ; $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            _a "            ݢ<Ã p  yp  PݬÐ p  ]p   F9  ݏDp  P ^ɛSRRݢ<ݬÔ 2p  p  0PP0Ѣ0ݏo    ^P <  ^Rբ<ݢ<ݬo  	P޼P `  ^ݬwo  P'ݬϛo  >P<`PʏPP @  (P @  P   P   	P PP2 P  4^߭ݬ  ݭo  P Џ  լ޼P `լ޼P `լ޼P `PPխEPЭP@](PPխ
ЭPPЭԭܐPPխլ0$ݭݭݬ1n  ЭP޼Q @a
P޼P `ЭЭЭѭ7PЭP@.PPPPPPѭPѭPzíPPPíPPЭԭլ$ݭЭP@ݬm  ЭP޼Q @aլ޼P `լЭP@ݬsm  P  ^߭ݬ    ݭUm  PѭP<ЭP@$P@(Џ   PPPݭm  PѭP2  P ^9Rݬݬl  ݬݬl  լߢݬl  ݬ l   ^Rݬݬul  Pխ(ݬݬߢl  P  ^߭ݬ  ޼P`];Pݬݭk  Pݭݬ
l  Џ   PP P߭ݬ   ЭP޼Q@aTݬ ݭЭP޼Q@aݬݬk  PЏ   PPPЭP޼Q@a P    θ^RS߭ݬ   ݭ]ݬݬPݭ޼P` P¼ j  Pݭ޼P` P
 K  "c>  PcPЭcP PP ^S,R 4ݢ4j   ݬA\j  ݬLj  þ j  Pխ" (j  \P ^sRݬ i  %  ^E\   i  i      ^ЬP P PЬPРխ"PЭPѠЏ   PЭPРխ2  P ^޼P`޼P`3P޼P`,&ЬRPPЬQPPab޼RbЬPRR `޼RbRR޼Rb2޼Rb,&ЬQRRЬPRR`a޼RbЬPRR `޼RbRR޼Rb2޼Rb,&ЬQRRЬPRR`a޼RbЬPRR    ^    Y+  0^!TSRլ "g   DdݬݬF  4g  g  9g  =>6g  =>]g  ig  8} ЭP@DPPPЭP@DP @DQ}PPADխ!PЭQP@DADPPխÆPPDÉdC  /d	  f    ¥ ݢ@p   P f     PP  ^ p/  rf   ^TS ߣx߭MPPݬ  PPխ =9ЭPРPݠ(Ďf  ЭRЭPݠ  P?   0ЭPްP`6ߣxߣDݭ 1ЭPްP`k6P ^S
RÖЬPްP`P:;ÙЬPްP`P=PPEPPݭݬ+  =PP%PPݭ  ^
RЬPްP`:P ЬPްP`P¥ ЬPްP`P ЬPްP`P=PP¤ PP<PP;PPݭݭݭݬ    ^
R޼P`-	PP Q޼PA`P`eѭ   [PQ޼PA`P`ݬc  PЭP@/PPPPPPPQ޼PA`P`ѭ   PЏPP ^=
S޼Rb-	PP R޼PB`Rb1 ѭ   1 ݬec  PRQ޼PA`P`Kc  RP;Q޼PA`P`ݬc  PЭQЭA/PPPPPPA/PPQ޼PA`P`ѭ   1rPP  ^e\̰ P  ^QQ Ѭ ЬP@ P PP| ^蘿Ub  VSլ1q T޼RDbRb1޼Rbܑ-	PPݭ:b  PTR޼PB`Rb b  TP1R޼PB`Rbݭa  P1fRЬPBRxbPʏ PPˏPPˏPPխRЬPBRˏ bPPЭPP G  W	"?PPRЬPBRbefJa  <a  RЬPBRbЭRPPR1 Ѭ|ЭRPPPP޼P``  PbPPլխ޼Pް P`-1bPЭQЭЁA/PPA/ЭQPPQѬP1RЬPBRbխЭP@/PPPPPPЭRPPRyѬsPPP޼P`PPլխ޼Pް P`- 1PPЭQЭ́A/PPA/ЭQPPQ
ѬP1RЬPBRb䒽PP1PRЬPBRb䐏1PRЬPBRb 1qPRЬPBRbЭRPPR}ѬwPPPЭQPP޼Pް P`aPPլխ޼Pް P`-1ЭQЭȁA/PPA/ЭQPPQѬP1RЬPBRbЭRPPR1 Ѭ|ЭRPPPP޼P`\^  PPbPPլխ޼Pް P`-1ЭQЭāA/PPA/ЭQPPQѬP1RЬPBRbЭRPPR1 Ѭ|ЭRPPPP޼P`]  PbPPլխ޼Pް P`-1RPЭQЭA/PPA/ЭQPPQѬPtPPPR޼PB`Rb1޼R޲ Rb-.޼Rbߥ&fE]  ݬF   ,]  Pð Tð RRð ޼RbDô RRRRլ1P ^R\  SzT  Q޼PA`P`RQ޼PA`P`\  PQ޼PA`P`\  PPPQ޼PA`P`PPߢEcW\   Q޼PA`P`1PQЬPAP`ˏPP1PxPʏ PPˏPPխЭP@/PPPPˏ PPQ޼PA`P`ݭߢUc[  խ	խЭPP I  
P:?PPQЬPAP`ߢ^ca[  S[  QЬPAP`ЭQPPQ0ЭQPPa c[  ЭQPPQ cZ  1PQЬPAP`ЭQPPQ1ЭQPPa cZ  ЭQPPQ cZ  1>PQЬPAP`ЭQPPQJЭQPPa PP	 PPݭ c,Z  ЭQPPQ cZ  1QЬPAP`ЭQPPQJЭQPPa¢ PP	 PPݭ cY  ЭQPPQ¥ cY  1=QЬPAP`ЭQPPQ4ЭQPPaPP§ cBY  ЭQPPQ« c"Y  1 PQЬPAP`ЭQPPQ2ЭQPPPa~­ cX  ЭQPPQ³ cX  jPQЬPAP`ЭQPPQ1ЭQPPaµ cqX  ЭQPPQ¹ cQX  PPPQ޼PA`P`1» c X       ^W   ЬPPPPݭpP 5ݭFݭW  P  ^ ЬRxQPPPPQQQˏPPЭPPP̭PPͭPPPPP  ^ ЬOxQPPPQQˏPPЭPPP̭PPͭPPPPЭP ^V  TLSÄ ݬV  b ЭR޼PB`QЭP@PPP@dPP!ЭRЭP@PP#V  PPPBPPЭP޼Q@aPz  P{M  PQPPRR
RBÈ 
խ1 PPz  P{M  PQPPRR
RBÈ 
խXPխ#
P@Í RbU  PЭPíPPխ
M  PP
P@È խsU  PP
RBÉ RݭB  Pb
RBÍ Rݭ)  Pb
RBÍ RbU  ݬ
RBÉ RbT  
RBÑ R b
R BÈ Ä RRÄ P ^暑R>Sլ޼QޢPPaP޼Q
P@É P`a ^	S
P@È PPЭPՠ	$ЭRZ  P	Т	ЭP 4PЭPР	ѽÀ  P%  PЭPЭЭЭRЬЭPЭ	À ЭRÀ P@0ЭPЭÀ PЭ@0   Џ   P  ^I Qլ P
P@ P` P
P@ P`PРP  ^
 Qլ P
P@ P` P
P@ Pް P`  P
P@ PР P P ^SR  \\  \ L0PߣU ^فSnR ߣ10 P \\ @0խ5Э\ЬЭPЭ\Ь	ЭЭ\ЬݭR  խP ^Rݬt P@q fR  t ݬ[R  Pt PPt ЭP ^Q޼RЬP@q PPb  ^P 
\L 
\L \ lL   ,^｀RRS 
\LÈ 1 
\LÉ \lߢIQ  
\LÈ ߢUQ  ߢlQ  
\LÑ \lխqPݽ lQ  Э\ݬ XQ  Э\ݬ­ DQ  Э\ݬ 0Q  Э\ݬ Q  Э\ЬխL  'P  ^e\ t   ^߭ݬݭݬP  ݏ   PP  ^߭ݬ߭ݬݭݭݬoP  ݏ   hPP     ^ЬPѠ ЬPРݬP  ЭPPЬPP ^ЬPOЬP ЬPРխ9ЭP'ЭP(ЭRЭPݠPЭRТխP ^pRЬPРЭP 1ЭSbЬPݠPߢݬ`O  ЭPݠݬ!.ߢݬ>O  ЭPݠ(ߢ(ݬ'O  ߢ7ݬO    ߢCݬN  ЭQЭPA4ߢFݬN  ߢIݬN  ЭPݠߢMݬN  ߢ]ݬN  ЭPݠߢ                                                                                                                                                                                                                                                   U                        ; $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                             "            hݬN  ЭP>P<`PP ݬfN   ݬVN  ЭP PP­ ݬ;N   ݬ+N     ݬN  ЭQЭPA!PP ݬM   ݬM  P $^}RЬQСPP  ` |    0 ^?P1  ݬM  1 ЬP ݬkM   ݬXM  1 ЬPݠݬ<M  fPЬPPPP~ݬM  E߭ЬPݠݭݬL  PЬPݠݬ+PP ^|SﶸRѬ0bЬ0ЬPP  - Q A Q 	V?P>PݬL  *PݬlL  PݬXL  PP ^|S4RЬPРխ1[PЭPРQСPP P P P P P P P P P P P P P P P P P P P P P P P P T T T T T T T P 
P?PP1 QPPQK  PPЭPЭЭQЭPР  ݬϋݭݬ *'ݬ<K  ЭPݠݬ'+ݬK  ЭPЭd   QPPЭA4P.4ЭPРխ1P ^ﹶR?P\\\L4Э\ЬЭPЭ\Ь ݭyJ  P ^=zRݬϐЬPݠݬ!)Zݬ=J  ЬPݠݬ`^   J   ^yRЬPݠݬ(aݬI  ЬPݠݬe   I   ^yRլ?P hݬI  ЬPݠݬQ(ЬPРլP ^1yRլ=P mݬ8I  ЬPݬ[ЬPРլpݬ	I   ^xRtݬH  լPݬݬϿЬPРլwݬH    ^}xRݬϗ{ݬH  ЬPРPРЭPQѠ!QQPP}ݬ\H  PݬHH  ЬPݠݬϓ	ݬ"H  ݭݬ H   H^wRЬPՠЬPݠݬ&ЬQСPP $  q     m   5551	EeY ]	:?P1ЬPݠݬ5&1P´ݬLG  1½ݬ8G  1uݬ$G  1aݬG  1MݬF  19ݬF  1%ݬF  1ݬF  1ݬF  ЬPݠݬϗ1ЬPݠݬϻݬwF  ЬPݠ ݬϚ1PݬPF  1ݬ<F  1yݬ(F  1eݬF  1Q$ݬ F  1=+ݬE  ЬPްP`ݬ3ݬE  1=ݬE  1FݬE  1RݬE  1[ݬxE  ЬPР խ8 cݬHE  ݽݬ7ЭPРխfݬE  ЬPݠݬ1IlݬD  ЬPݠ ݬtݬD  ЬPݠ ݬЬPР$խ+wݬD  ݽݬϗЭPРխzݬ}D  ЬPݠݬh1ݬXD  ЬPР խPݭݬ#ЭPРխЬPՠ$1 ЬPР$ݬD  ЭPݠݬ"ݬC  ЭPݠݬݬC  ЭPРխ2PЭPݠݬ7ЭPݠݬϊЭPРխݬtC  1 ݬ`C  ЬPݠݬK1 ЬPݠ ݬ7yvPݬ$C  ЬPݠݬOݬC  AЬPݬ7-¡ݬB  PªЬPݠ PP ^﩮R  PЬЭPЬЭP   x^CrRdSݬϏխ1&ЭPѠ Ѡ1 1Pºݬ(B  ݽݬ ݬ	B  ݽݬ ݬA  ݬA  ݽݬ ݬA  ݽݬ ݬA  1]IݬA  ݽݬM TݬiA  fݬYA  ݬIA  ݬ9A  ¼ݬ)A  ݽݬݬ
A  ݬ@  ݬ@  
ݬ@  -ݬ@  ݽݬ8ݬ@  Jݬ@  gݬ@  ݬ{@  ݽݬ@ݬ\@  ݬL@  ²ݬ<@  ЭPРխ1P ,^oRЬPРЭPѠ_ݬ- ЭPРխAPЭPݠݬݭݬ?  PPЭPРխЭPѠ"ЭPݬ? ݬϳЬPݠݬDݬ`?  ݭݬOݬC?  ЭPѠ" hЭPAЭPѠ ЬPݠUЭPѠ$ЬPݠ;P  ^ЬQСPP1 9 9 9  P?P PЬPݠ PPPPЏ   P P ,^inRլ1 ݬ{>  լ1 P ݬT>  ЬP&/ЬP'ݬ2>  ݬ >  Pݬ>  ЬPݠݬݬ=  ЬPݠPݬ=  ЬPݠݬϱЬPРլ14ݬ=  P ^UmRЬPѠ	ЬPР ЬPѠ ЬPѠPݬH=  P/ݬ4=  P  ^lRЬPРݭݭݬϵݬ)ЭPРPРPQѠ!QQPPNݬ<  Xݬ<  ЬPݠݬuЭPݠݬ?cݬ{<  ЭPРPݠݬbЭPРPݠݬPgݬ<<   kP  ^լePЬQСPP  ( , < 
P?P3Pݬݬ"PݬݬϳݬݬϫЬPРլݬ<P ^}kRݬݬݬeݬ;  ݬݬpݬd;     Q;   ^kR ݬgЬխ*ЭPѠЭPݠݬЭPРխݬPݭݬݬ:  Ьխ^PЭPѠDЭPݠݬ{ªݬ:  ЭPݠݬ®ݬv:  ЭPРխ±ݬX:   χݬw·ݬ[Pݭݬݬ:  ݭݬݬ9  RݬPݭݬݬ9  ݭݬݬ9   ^aiRݬϴݬPݭݬ5ݬL9  Pݬ89  P ^hRSЬPР0ЬPݠ%P<ݬ8  ݭݬEݬ8  ݭݬbݬ8  ЬPРlݬ8  ЭPРխ1 ЭPݠBլuЭPݠPݬ48  CP08  P§ݬ8  ݬ7  ݬ7  ݬ7  ЭPРխ12ЭP PPݬݬݬЭPݠݬLЭP ZЭPՠ,ЭPݠ0ЭPݠ,ݬϜPPЭPݠЬPݠݬPPЬPݠݬπ     ^P  ^    ^ݬ6  Pխm2ݏ6  P p^{mRЬPP $Z n  &" b^ v :6NJ   r
PV?P1ߢݬI6  1Pߢݬ56  1Pߢ ݬ!6  1~Pߢ,ݬ
6  1jPߢ:ݬ5  1VPߢNݬ5  1BPߢWݬ5  1.Pߢgݬ5  1Pߢxݬ5  1P ݬ5  1 ݬ5  1¨ ݬl5  1´ ݬX5  1 ݬD5  1 ݬ05  1 ݬ5  1y ݬ5  1e ݬ4  1Q
ݬ4  1=ݬ4  1)ݬ4  1+ݬ4  1:ݬ4  1 Nݬ|4  1 ^ݬh4  1 kݬT4  1 |ݬ@4  1 ݬ,4  1 ݬ4  vP°ݬ4  bPݬ3  NPݬ3  :Pݬ3  &Pݬ3  Pݬ3     | ^SlS`UTrVR 
  Pխ1PЭPP P d h t             08@HP(D`tj?P15   P P14P1/ЏG  P1#ЏH  P1ЏI  P1ЏJ  P1ЏK  P1ЏM  P1ЏN  P1ЏP  P1ЏQ  P1ЏR  P1ЏS  P1ЏO  P1ЏT  P1 
  1P ]  PP1xP M  PP1hPd1`Pd1XP d1PP d1HP1  b1  P @IPeЏV  P1	P1  b1  P @	PeЏV  P1 Pd P	  
PЏL  P1  i  1 Pb  PP1 Pecb0  ЏW  PpPeߣ0  ЏW  PReߣ0  ЏW  P6e	  PP"b\\PPPݭߣf0   g
  Pխ1K2  P  ^Yi\=߬!0  {0  m0   ^TzRGS 3  q\c\c\\cc\l\ \2\\\/  PЭbb
d\\db\\b\\ѭ b\\Эխ$Эbb
d\\dcPc\\cb\\` P 2 P ^RX P@0P`CPP@0P`ݬX/  PP@4P`PPPP@0P`Y P@P`EP@P`ݬ.  PP@P`PPPP@P`&X P@xP`EP@xP`ݬ.  PP@|P`PPPP@xP`ݏ   ݬP6ݏ   ݬjPЏU  PP ^fRz\լ,ݬ,
.  P,լ,ݬ,-  P^fXxUiVRWSTѤ(
 g\c\c\\cc\l\ \2\\\Pf-  PЭbb
e\\eb\\b\\ѭ b\\Эխ1ѭ'
ѭ"1mg\c\c\\cc\l\ \2\\\f,  PЭbb
e\\eb\\b\\ѭ b\\Эխ                                                                                                                                                                                                                                                   V                        F $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            f "            1ѭ'
ѭ"1WЭ\ LФ(P(\\(f@dg\c\c\\cc\l\ \2\\\Pf+  PЭbb
e\\eb\\b\\ѭ b\\Эխ1} ѭ;ug\c\c\\cc\l\ \2\\\fj+  PЭbb
e\\eb\\b\\ѭ b\\Эխ2>+  Pff"4Q+   PPЭP\\\\@g\c\c\\cc\l\ \2\\\f*  PЭbb
e\\eb\\b\\ѭ b\\Эխ1g\c\c\\cc\l\ \2\\\f"*  PЭbb
e\\eb\\b\\ѭ b\\Эխ1P  ^ePՠ((\\(Р(\L`| ^TVSURe\b\b\\bb\l\ \2\\\fV)  PЭcc
d\\dc\\c\\ѭ c\\Эխ1,ѭ*1 e\b\b\\bb\l\ \2\\\f(  PЭcc
d\\dc\\c\\ѭ c\\Эѭ/1 !Эcc
d\\dbPb\\bc\\`Pխ  e\b\b\\bb\l\ \2\\\f*(  PЭcc
d\\dc\\c\\ѭ c\\Эխ1P| ^ɺTﺺV'S,URe\b\b\\bb\l\ \2\\\f'  PЭcc
d\\dc\\c\\ѭ c\\Эխ1 ѭ}   1 
խ e\b\b\\bb\l\ \2\\\f&  PЭcc
d\\dc\\c\\ѭ c\\Эխ1lP ^_R?ЬP޼P`Sݬ]&  PЬPЬP	ЬP
ЬPЬPЬP
ЬPЬPЏA  P0^WXZYVθT3S R)[kUUP ټkUUUh\\ﲤЭ,
	\\нi\ѭ\ Э\Ьխ1'Pi\ѽ\1ЭU\\\b\b\\bb\l\ \2\\\$  PЭcc
d\\dc\\c\\ѭ؏ c\\Эܭ\\eЭi\ѭ\1 ŭ\\\ѭj1 \\PPf\\PPxЭ\\\PPf\\Pf\P\0\\\\cc
d\\dbPb\\bc\\`1ЭQ\\Э\\\PPf\\PPЭa11}i\ѭ\1piPi\­\\\\\PPЭŭ\\\ѭj1 \\PPf\\PPwЭ\\\PPf\\Pf\P\/\\\\cc
d\\dbPb\\bc\\`14ЭQ\\Э\\\PPf\\PPЭa1Э\LU\\\\\ѭj1 \\PPf\\PPyЭ\\\PPf\\Pf\P\1\\\\cc
d\\dbPb\\bc\\`1 PЭQ\\Э\\\PPf\\PPЭaUЭ\Ьխнi\ѭ\13P\\\\cc
d\\dbPb\\bc\\`P1ЭU\\h\U\1MЭP\\ `ս1 н\Ьgg1 g\l1 Эg\l\L1 g\l\\н\ݬ  Plh\ѭ\cP\\ЭP\\`\\cc
d\\dbPb\\bc\\`g\l\\н\ݬH  Ph\ѭ\\\UЭ%k\\\\\\ LkgPg\\g`P\\cc
d\\dbPb\\bc\\`ЭP\\h\P\1k)\\b P\b\b\\bb\l\ \2\\\Pqz   PЭcc
d\\dc\\c\\ѭ؏ c\\\\kk\\PJ]:G   k\\1n  ^լ P޼P`!PЬQPPaP޼P` P ^!SR\b\b\\bb\l\ \2\\\Pu~  PЭcc
c\\Zc\\c\\ѭ c\\P  ^dݬQ   ^qS>RЬcc
PPbQbPPbcPPaL^_\\X﹬[WgY@ZѝV ͲЏf ɵ 2ͶRRRRkf2ͲRRl  RRRѭR߬qPͲRR(j2ͲRBgͰͰ1 Pf Pff f2ͰRfRRRRͰͰ
ͰPRP2ͰRBiͰ2ͰR2BRRf3Џf(ɳjͰͲC:RR21P2ͲRBtͰͰ1 f 
Pff fRR챽ЭRͲ PRR챽ЭRͲRR쵽2RRfRR쵽ЭRͰͰ PͰ12oRRPP  1 1  	?P1 ߬(ͧϳRRƳ/͸RѭR1 2R2BgR   RRRRͰͰ/Ͱ&2ͰR2BiRBr 2ͰRBiͲ1P2RBgͰkЭR2RR2RR߬5Y  RRRR͸RѭR1iPkf߬`#  fЏf1Pk2ͰRR́   2ͰR2B`RRRRRRЭ2ͰR2BARRRRRRЭR(jͰʹ2ͰRBsͰ2ͰR2B,S2RRSSSRRͶͶ$2ͶRBiͲ2ͲSͰRC4RP2ͰR2BRBiͲ2ʹRRPPP  yyyyy
yy=amqyyy)EyQmyyyy%M]qyyy)Meyyyyy	)9IYiyyyyyyyyyyy)Y}y		-	I	]	i		y		
yyy%
5
E
Y
u
y



)Qyq	!uyyyyyyyyyyy!
yyyyyu




y


	y-yyyyyyAMYeq
!=yQmyyyy-=Qauy=Uyyyyyyyyyyyyyyyy}y%5EUeuy9Uyyy1eyyyyy1Qqyyyyyyyyyyy-Iey	eyyy)5AMyYu}yyyyyAQi	R?P1н@ݭЭRݢ6PЭ1PЭRТj1x1yd1m Y1bPЭRТ0ЭRТRR1=ЭRТЭRТܞRR1(11	ЭRТ1Њ1΋ ̌ Ӧ︋RBﰊSЭRТcRBSЭRТcRR1ݽ Pj1ݽЭRݢPj1gP  Pj1QݽЭRݢ%Pj17PЭRТj1)ݽЭRݢPj1PݽPj1PݽЭRݢ}Pj1Pнj1нj1ݽЭRݢQPj1PЭRݢ ЭRݢ*Pj1&PЭRЭRнЭj1jPݽEPj1WPPЭRЭRнЭj1.P VPj1ݏ   *Pj1 Pj1ݽЭRݢ}Pj1PЭRݢЭRݢVPj1нЭRݢݭLPj1PЭRТj1ݽЭRݢPj1wPPЭSЭRТЭj1RP^PЭSЭRТЭj1.P:PЭj1P "PЭSЭRТЭj1P Pj1Pj1Pj1Pj1vPj1fPj1VPj1FPj1p6Pj1`	&Pj1P
Pj1@Pj10Pj1 Pj1Pj1 ݽ	Pj1PPj1ЭRݢzPj1ݽЭRݢIPj1Pݽ
Pj1PݽЭRݢPj1{PнЭRТЭ ݭPj1RPнЭRТЭЭRТݭݭPj1 нЭRТЭݭPj1ЭRТj1ݽЭRݢ
Pj1P ݽ"Pj1н\Pj1Pнݏ   ݏ   Pj1ЭRТj1y ݽPj1d ЭRݢPj1LݽЭRݢPj13Pݽ Pj1ЭRТj1ЭRТ୘ݽЭRݢ Pj1PЭRТ୔ݽЭRݢЭRݢPj1PݽЭRݢPj1PнЭRݢPj1zPЭRТЭRݢPj1VPЭRТ\1EЭRТP15ݽuPj1#PݽЭRݢMPj1PݽEPj1PݽЭRݢPj1PЭRݢЭRݢ Pj1ЭRݢЭRݢ Pj1 ЭRݢ Pj1yЭRݢЭRݢЭRݢPj1SPЭRݢЭRݢЭRݢqPj1+P ЭRݢЭRݢNPj1ݽЭRݢPj1
PݽqPj1
P!PݽPj1
!zP Pj1
PнЭRݢPj1r
PЭRݢPj1[
P!PxxЭRݢ P||q|ЭRݢPj1
!PppЭRݢЭRݢPtttЭRݢEPj1PЭRТllЭRݢ CPhhhЭRݢPj1YЭRТddЭRݢЭRݢP``q`ЭRݢPj11؄1Є1＄1ЭRТj1ݽЭRݢ
Pj1P j1Pн\\ЭRݢ"\ЭRݢPj1pнj1iݽЭRݢPj1OPݽPj1;P1-,1!11	܃փRRRR1
ﴃﮃRRRRۀ1
Ѐ1
1
ЭRТj1
 1
P 1
Pp1y
 e1n
Pݽ Pj1X
ݽЭRݢPj1?
P  Pj1)
ݽЭRݢPj1
PЭRݢPj1	PݽЭRݢyPj1	Pݽ ЭRݢVPj1	RPXXRXRнXj1	PݽmPTTj1x	PPPRPRнPj1N	P vPj1<	ݏ   JPj1(	 :Pj1	ݽPj1	PЭRТLݽL:P                                                                                                                                                                                                                                                   W                        vx $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                                         j1ЭRТHݽHPj1ЭRݢݽYPj1PݽЭRݢPj1PPDDSЭRТDj1gPrP@@SЭRТ@j1?PJP<<j1% 2P88SЭRТ8j1PݽPj1PPj1Pj1 }1P}1P}1P}1P }1P }1P y}1vP Pj1gP Pj1WP Pj1GP
Pj14 Pj1$Pj1!Pj1Pj1Pj1нj1 ЭRݢZPj1ЭRТ44RТ$SЭRТ1 ЭRݢЭRݢ P 
Pj1t ЭRݢЭRݢݽ~P Pj1CPݽЭRݢ=Pj1'PݽЭRݢнRݢIPj1PݽЭRݢPj1PЭRݢ勵Pj1PݽЭRݢPj1PЭRТ0ЭRݢ0ЭRݢPj1}ЭRТ,ЭRݢ,ЭRݢkPj1IЭRТ(ЭRݢ(zЭRݢ7Pj1ЭRТ$ЭRݢ$FЭRݢPj1ЭRТz1ЭRТz1ݽbPj1ݽNPj1ݽ:Pj1ЭRТj1yݽЭRݢPj1_PݽPj1KPн    DPj1*Pн  $Pj1
Pнݏ     Pj1PЭRݢ
Pj1PݽЭRݢ
Pj1P !ݽPj1  ݽPj1 #ݽPj1i ЭRݢPj1M ЭRݢPj11ݽЭRݢzPj1ݽЭRݢ^Pj1ݽЭRݢBPj1ݽЭRݢPj1PЭRݢEPj1PЭRТRнj1 "ЭRݢ׿Pj1qЭRТݽgЭRݢݽPЭRݢﯹPj1ЭRТݽЭRݢݽP&ЭRݢSPj1~P ݽ  ݽGPЭRݢPj1]Dz1Q0z1E(z19z1-ЭRТj1!ݽЭRݢePj1P j1 PЭRТݽ2ݽkPYPj1 PЭRТݽݽ'PPjxЭRТݽݽPPj88v j+Pxx jPt jP1                                                                                                                                                                                                                                                                                            @   @                                                    T   L      
           d    l   d      t         |     t      D      ,
  t	        
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                                                                        * [B]RPC$NRGLBD.EXE;2 +  , :   . -    /    4     -   ,                     - E9    0   1    2   3      K  P   W   O .    5   6 Ε  7  1Ε  8          9          G   H  J                             0 D X     0205      (  _N     R  	                                      
RPC$NRGLBD                             RPC V1.1       s_Ε 05-05                      %            )   
  *     ?   #      +        RPC$LIBNCK_001       !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001  <unknown> GLBD: unable to listen on %.*s address family
 GLBD: unable to listen on any address families
 GLBD:  non-replicated GLB GLBD:  nrglbd/nck version 1.5 Listening...
 GLBD:    rpc$exe:glbdbase.dat    rpc$exe:llbdbase.dat    %W%     (ultrix)        %G%                                                                     i.;3    
       %W%     (ultrix)        %G%                                                                     i.;3    
     (  ,)  \)  (    t
      |(    %W%     (ultrix)        %G%                                                                     i.;3    
                                                                       3;3    
         %W%     (ultrix)        %G%                                                                     i.;3    
                                                                       3;3    
                                                                                                 i.;3    
                                                                       3;3    
     3  83  h3  4  L=  F  X                                                                                                                                                                                                                                                                                                                                                                                                                           x^VW  ͠߭߭SJ   ѭ1 ͠RB<RB,ЭR<BRRJ  ͠RR
͠Rb2PЭSЭRBCSR(B,C,RRJPf͌J  ͠߭͌ЭR<BRRI  ͌ݭߦ
I  RRѭ11խߦ9I  I  ͠8I  ͠Rb^(͠nߦiI  I   ѭwP͠ͤRB<RbRB,ߦpbݬݬ	H  ͠Rb^(͠nƃ H  I  RRѭP| 4^H  VƊ ݬݬRH  pH   `H  ơ H  )H  Rb^(nƯ H  P ^޼P`f<fPPPPPЭQQQG  PPPQP1:QG  PQP1#ެPQH  PQP1Pн`PPP`PPP`PPPPPPݭݭG  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭF  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ"F  PPíPPPPP
Pн`PPPPݏ@   ݭݭE  @   PPíPPPPPNPн`PPRP`PPTPPݭݭtE  16QQQE  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ8E  PPPQPP` PPЭЭPЭPPPQQQD  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ>D  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQC  PPPQPP` PPЭЭPЭPPPQQQC  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQB  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQpB  PPPQPP` PPЭЭPЭPPPQQQ"B  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQvA  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ@  PQP*@  PPP@@  
P@@  PPPPPPխíPPPPPQQQr@  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ?  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ   PPЬ$QPѭPPaaPP޼Rݭ>  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b ^޼P`f<fPPPPPЭQQQ>  PPPQP1:Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  X                        = $      RCP011.B                       :  E9  [B]RPC$NRGLBD.EXE;2                                                                                                                 -                         t "            >  PQP1#ެPQ>  PQP1Pн`PPP`PPP`PPPPPPݭݭ=  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ[=  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ<  PPíPPPPP
Pн`PPPPݏ@   ݭݭ<  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ0<  16QQQ_<  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ;  PPPQPP` PPЭЭPЭPPPQQQ;  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ:  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ:  PPPQPP` PPЭЭPЭPPPQQQB:  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ9  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ,9  PPPQPP` PPЭЭPЭPPPQQQ8  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ28  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ7  PQP*7  PPP@|7  
P@q7  PPPPPPխíPPPPPQQQ.7  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ6  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ   PPЬ$QPѭPPaaPP޼Rݭ5  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b< ^SR5  PDRݢD35    խݭ5  ^(n4   ޼RbR<RRRRRRЭSSS
5  RRRSR1S4  RSR1ެRS)5  RSR1RнbRRRbRRRbRRRRRRݭݭ,4  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ3  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ23  RRíRRRRRޭRнbRRޭRнb1 SSS+3  RRRSRRнb=PRRЭЭRЭSЭRЭSЭRЭRRRSSS2  RRRSRRb RRЭЭRЭRRRSSSr2  RRRSR
Rb"PRRЭЭRЭRRRRRRRխ'PRRRRRRխíRRRRRSSS1  RRRSR
Rнb<PRRЭЭRЭSЭRЭSЭRЭRRRSSS\1  RRRSRRb RRЭЭRЭRRRSSS1  RRRSR
Rb%PRRЭ||RЭR|RRRRRRխ(PRRRRRRխíRRRRRSSS^0  RRRSR
RнbFPRRxЭttRxxStRxStRxRtRRSSS/  RRRSR
Rb(PRRpЭllRppRlRRSSS/  RRRSRRb&RRhЭddRhhRdRRRRRRխ%RRRRRRխíRRRRRSSS.  RRRSR
ޭRнbFPޭRR`Э\\R``S\R`S\R`R\RRSSSs.  RRRSR
ޭRнbCޭRRXЭTTRXXSTRXSTRXRTŭȏ   RR-  Pݭ߭ݭ߭ݬ	   ŭ̏   RRRRRЬ$SRѭRRccRR޼RݭI-  Pb޼RЬb޼S<RRRRcRRЭЭĽRRЭ̽RRPPRRNNRRNPЏ  ^(n,  RR<NRRխ1{PíRRRRRнԽRRЭR>RbRRЭR>RbRRЭRRRЭR	RRݭݭ(,  RRíRRRRRЭRޢRbRRЭR>RbRRЭR>RbRRЭRRRЭRRRݭݭ+  RRíRRRRRЭRޢ RbRRЭR>$RbRRЭR>&RbRRЭR(RRЭR)RRݭݭ+  RRíRRRRRЭRޢ0RbRRЭR4RRݏ@   ݭݭ*  @   RRíRRRRRЭRޢtRbRRЭR>xRbRRЭRzRRݭݭS*  RRԏ   RRRRխ1íRRRRRRR޼ SíRRcխݭ)  ޼(R b  ^ݬh   ޼$P `޼PЬ`޼ P `޼(P `   ^=R P.ݬݏ  _  P ޼QPaPPP  ^P ^RݬPݬݬ   	   ^RݬkPݬ  M   ^Rݬ$;Pݬ$ݬ ݬݏ   ݬݬݬݬݬ 
      ^ެP޼P`޼P`t(  P PP' (  ޼P`A(  PP PP PެPЬPЬP'  P PP% (  ЬP'  P PP PެPЬP ЬP '  P PP% '  ЬP N'  P PP PެPՠ:ݬ$ЬPݠtЬPxЬPݠtЬPx&  PPPPPЏ   PP ,^޼P `լ޼PЏ`޼Rݬ'  Pb޼Rbn '  P޼Rݏ  ݏ  ݬ&  Pbݭ&  ޼Rb޼Rb&  
P޼RЏ b1-P޼Rb&  ѭU޼Rb&  ѭ&ݬz&  Pݬݬݬ޼RЏb޼RЏ b1 P޼Rbw ЭS޼Rb&&  PCЭRB޼Rb%  ޼SЭRBc ѭܭ!ЭRB%  RRѭܭЬRŏ   RRЬR޼Rb%  PЬSǏ   RR  ^Pď   P   PPݭu%  Pխ޼PЏ ` Pݭ ݭC%  ЏЭP ЭPЬݬݬݭϱ޼P`ݭ
%   PЭP< ^ЬЬRѭ1 ŏ   SЬRCRRŏ   SЬRCRb_լЭSЬ Rѣ00IP(RRݭݬ ^(n	\P#լ$޼$Tŏ   SЬR( CdЭPRRЬRѭ1^ЏP  ^޼P `޼P`Ŭ   PPP ݭ޼P`#  P޼PЏ `GPݏ   ŏ   QЬPA޼P`#  Pѭ   ޼PЏ `PP< ^޼R bѬF ЬRѭ7Pŏ   SЬRCRb
ЭPRRЬRѭЬRѬ
޼RЏ bWЬRѬ
ЬSRRŏ   SЬRCRbŏ   TЬS޼R( bDݬݬݬϕ  ^ЬPѠtЬPѠt޼P `
P޼PЏ `| ^V޼R bݬݬլ	޼Rb( ݏ    ݬ ^(nݬ
FPݬݬݭݬϑ| \^V޼R bݬݬ:լ	޼Rb( ݏ   \ݬ ^(nݬ
Pѭ+ŏ   SЬRCR bݬݭݬ]P޼RЏ b< T^ լ,)!  ޼Rb   P޼R(bT Pլ+   ޼Rb   P޼R(bd Pլ+   ޼Rbj   P޼R(bt P޼(R b޼$RbRR޼RbѭfRRݭTݭ^(nݬ
ϏPѭ)   RRRRRRѭѭѭ޼R bP޼RЭb޼ RЭbխ޼(RЏ bP ^R P.ݬݏ  KP ޼QPaPPP ^RݬPݬݬ    ^}RݬsPݬ  A ^MRݬ$CPݬ$ݬ ݬݏ   ݬݬݬݬݬ   
 ^Rݬ(Pݬ(ݬ$ݬ PPݬݬݬݬݬ 
G   ^޼P`f<fPPPPPЭQQQf  PPPQP1:QL  PQP1#ެPQ  PQP1Pн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ  PPíPPPPP
Pн`PP                                                                                                                                                                                                                                                   Y                        *e $      RCP011.B                       :  E9  [B]RPC$NRGLBD.EXE;2                                                                                                                 -                         8              PPݏ@   ݭݭ@  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ  16QQQ  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQV  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ@  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQF  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQZ  PQP*D  PPP@,  
P@!  PPPPPPխíPPPPPQQQ  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQj  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ: PPЬ$QPѭPPaaPP޼RݭY  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b ^޼P`f<fPPPPPЭQQQ"  PPPQP1:Q  PQP1#ެPQA  PQP1Pн`PPP`PPP`PPPPPPݭݭD  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭJ  PPíPPPPP
Pн`PPPPݏ@   ݭݭ  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ  16QQQ  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ`  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQf  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQJ  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ  PQP*   PPP@
  
P@
  PPPPPPխíPPPPPQQQ
  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ&
  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ& PPЬ$QPѭPPaaPP޼Rݭ  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b< ^޼RbV<VRRRRRЭSSS  RRRSR1S  RSR1ެRS  RSR1RнbRRRbRRRbRRRRRRݭݭ   RRíRRRRR RнbRRRbRRRbRRRR	RRݭݭ
  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ
  RRíRRRRRޭRнbRRޭRнb1SSS	  RRRSRRнb=PRRЭЭRЭSЭRЭSЭRЭRRRSSS	  RRRSRRb RRЭЭRЭRRRSSSF	  RRRSR
Rb"PRRЭЭRЭRRRRRRRխ'PRRRRRRխíRRRRRSSS  RRRSR
 Rнb<P RRЭЭRЭSЭRЭSЭRЭRRRSSS0  RRRSRRb RRЭЭRЭRRRSSS  RRRSR
Rb"PRRЭЭRЭRRRRR	RRխ'PRRRRRRխíRRRRRSSS6  RRRSR
RнbFPRR|ЭxxR||SxR|SxR|RxRRSSS  RRRSR
Rb(PRRtЭppRttRpRRSSSl  RRRSRRb&RRlЭhhRllRhRRRRRRխ%RRRRRRխíRRRRRSSS  RRRSR
ޭRнbFPޭRRdЭ``RddS`RdS`RdR`RRSSSK  RRRSR
ޭRнbCޭRR\ЭXXR\\SXR\SXR\RXP ߭ݭ߭ ݬ	 ŭЏ   RRRRRЬ$SRѭRRccRR޼Rݭ7  Pb
P޼RЬb޼S<VRRRcRRЭЭȽRRЭнRRTTRR<TRRЏ  ^(n   RR<TRRխ1zPíRRRRRнؽRRЭR>RbRRЭR>RbRRЭRRRЭR	RRݭݭ(  RRíRRRRRЭRޢRbRRЭR>RbRRЭR>RbRRЭRRRЭRRRݭݭ  RRíRRRRRЭRޢ RbRRЭR>$RbRRЭR>&RbRRЭR(RRЭR)RRݭݭ  RRíRRRRRЭRޢ0RbRRЭR4RRݏ@   ݭݭ  @   RRíRRRRRЭRޢtRbRRЭR>xRbRRЭRzRRݭݭS  RR؏   RRRRխ1íRRRRRPRR޼ SíRRc޼(R b                                                                                                                                                            @   @   D                                                P     x  p  `  h  x   8     (  (        (     `  `     r @            \  d  $     $   ,            <  
     &             P   
                 @                                                                       
RPC$LIBNCK                                                     VAXCRTL                                                        LIBRTL                                                         MTHRTL                                       P                                                                                                                                                                                                                                                                                                                                                                                                                                                                 * [B]RPC$STCODE.DAT;2 +  ,    .    /    4       &                   - E9   0   1    2   3      K  P   W   O    5   6  sΕ  7 CΕ  8          9          G   H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               Z                        Gf $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "                      @     	?     
@          
               # 	     
         @      
    ?          #W     &?     (_     ,     5     <A     =     >     B     C     D:     GS     Hl     J     Lk     M8     T      U !    V6 "    X #    ]L $    b %    cv &    d '    e^ (    fK )    j *    k +    l} ,    oQ -    r .    t; /    u. 0    w 1    y 2    |5 3    }} 4    ~n 5     6    0 7     8     9    I :    / ;     <    & =     >    z    '            t        R        0	    
   
   }   $
   2[   ?   M9   Z   h   u      d      B          ӏ      m      	K      $)    1!   ?"   Lv#   Y$   gT%   t&   2'   (   I)         p   V   D          X   ũ   G   ~   y	   ̖
   Μ   x   Ӫ      ښ      
      	   ]
   "      
   g         8             7      M	   
   f   2   
         _   L   L   Z   Z   k      !h   ")   #@   $   &-   )[   *0   24   2   J   K#   P   U   g	   g
   j(   m   r
   t   wn   x   y'   y   }   ~   :	   	   	   b	   	   l	   	   v	   		   	
   	   X	   	
   	   /
   
      q      O         (   U   
   Z
   [            #            	   +   ö               ]   `   C         w                                    z   	   7
      u   b   6   	J   
{   s   
          5      @   M   	   s       &]	   'p
   (   )   +L   /d   0   1   3  OS  4    @          
     
       /
     BAT manager @  4 ,R
                     /8 attempt to free already-freed block disk is full attempt to free illegal disk address BAT not mounted disk needs salvaging   	OS   4 ?        4     
       /
     VTOC manager   4 ,R
                     /8 VTOC not mounted VTOC is bad no file map no UID not found UID not found duplicate UID uid mismatch only local access allowed   OS   4 @         4     
       /
     AST manager @  4 ,R
                     /8 attempted reference to out-of-bounds address  no replaceable aste's segment is not deactivatable write concurrency violation incompatible request reference count says unused segment not found in bst segment thread error in bst only local access allowed system object cannot be deleted   OS   4         4     
       /
 $    MST manager @  4 ,R
                     /8 object not found invalid length no space available reference to illegal address reference to out-of-bounds address no asid is available object is not mapped no rights insufficient rights guard fault wrong type - can't map system objects ppn list overflow uid mismatch virtual memory resources exhausted invalid va for install of io page invalid segment count asid 0 is illegal for this mapping   OS   4         4     
       /
 ,    PMAP manager   4 ,R
                     /8 not allocated already allocated mismatch bad wire bad unwire bad assoc pages wired page null bad disk address read concurrency violation changed pmods invalid pmape attempt to map i/o page over real page bst threads yielded invalid va  illegal pid argument from dxm callback illegal wsl index   OS   4         4     
       /
 4    MMAP manager   4 ,R
                     /8 bad avail bad free bad unavail examined max inconsistent mmape illegal wsl index illegal pid ws lists exhsusted bad install bad reclaim contiguous pages unavailable   OS   4    	      4     
       /
 <    MMU manager @  4 ,R
                     /8 mmu miss va not in valid mmu manager range va does not have os_pmap ptt parity error pft parity error mmu timeout unknown mmu status mmu parity error data cache parity error unexpected virtual timeout write buffer timeout   (OS   4 #   
      4     
       /
 D    disk manager   4 ,R
                     /8 disk not ready disk controller busy disk controller time-out disk controller error disk equipment check floppy is not 2-sided disk write protected bad disk format disk data check DMA overrun volume in use volume table full volume not properly mounted or assigned operation requires a physical volume invalid volume index logical volume not found disk block header error invalid disk address disk buffer is not page aligned invalid logical volume index or list disk seek error drive timed out before operation completed bus error occurred during disk DMA transfer invalid unit number unknown status returned by hardware invalid physical volume label floppy door has been opened or storage module has been stopped read after write failed dma not at end of range disk already mounted software detected checksum error checksum error in read after write too many wired pages -- storage module manager disk driver logic error unknown error status from drive unrecognized drive id memory parity error during disk write unrecognized interrupt from disktape controller ecc error in sector id field disk subsystem detected a DC powerfail   OS   4         4     
       /
 L    eventcount manager  4 ,R
                     /8 bad wait list on eventcount   OS   4         4     
       /
 T    level 1 process manager ,R
                     /8 illegal process id illegal lock process not suspended process already suspended process not bound process already bound bad atomic operation no pcb is available no stack space is available process not suspendable ready list is out of order bad deferred interrupt queue   OS   4 @  
      4     
       /
 \    terminal manager  4 ,R
                     /8 buffer too small end of file entered from keyboard invalid output length invalid option passed to term_$control input buffer overrun - characters lost asynchronous fault occurred while waiting for input invalid line number supplied manual stop: type G<ret>G *+2<ret> to continue character framing error character parity error data carrier detect (dcd) changed clear to send (cts) changed requested line or operation not implemented hangup fault speed incompatible with partner SIO line   OS   4         4     
       /
 d    DBUF manager   4 ,R
                     /8 bad ptr bad free   
OS   4 ?         4     
       /
 l    time manager   4 ,R
                     /8 no timer queue entry entry to be cancelled not found quit while waiting for event bad timer interrupt bad timer key alarm fault real interval timer fault virtual interval timer fault queue element not in use queue element not found cpu time limit exceeded time adjustment out of range queue element already in use   4OS   4         4     
       /
 t    naming server   4 ,R
                     /8 directory is full name already exists invalid pathname invalid link not a link name not found   invalid link operation invalid leaf node is unavailable bad directory branch is not a directory directory is not empty name is not a file illegal directory operation bad type no rights insufficient rights unable to delete system bootstrap (sysboot) directory is in use (locked) name server helpers clocks are skewed illegal request made of name server helper cannot find entry in replicated root last entry in replicated root returned name server helper is shutdown name server helper sent packet with errors clocks skewed cant find name server helper directory must be root directory not found in pathname too many components in pathname cache entry is stale cache entry was stale and was updated name server helper is uninitialized internal error bad request header version bad request code bad re                                                                                                                                                                                                                                                   [                        0`B	 $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "            quest body version request ignored directories not neighbors directory not local pathname truncated leaf truncated bad buffer size object is not an acl object volume has been mounted read-only write-protected volume prevents recovery of a damaged directory too many hard links exist to file directory object not found ran out of address space   OS   4 W        4     
       /
 |    file server @  4 ,R
                     /8 object not found object is remote bad reply received from remote node communications problem with remote node object is not locked by this process object is in use illegal lock request lock violation detected local lock table is full remote lock table is full operation cannot be done from here no more lock table entries volume uid is unavailable locking files is blocked for this volume locking is already blocked for this volume no rights insufficient rights wrong type - can't operate on system objects objects are on different volumes invalid argument incompatible request volume has been mounted read-only   OS   4 ?         4     
       /
     I/O manager @  4 ,R
                     /8 dcte not found controller not in system illegal interrupt id specified interrupt id already in use interrupt id not implemented for this bus interrupt id table full bad dcte length illegal unit number unit not acquired unit already in use unit table full illegal CSR address interrupt id already in use CSR page already in use CSR address already mapped io map full device failed self-test boot device not found   $OS   4 _         4     
       /
     network @  4 ,R
                     /8 buffer error out of pages out of blocks transmit failed no available socket buffer queue is empty remote node failed to respond to request unable to route network hardware error msg header too big unexpected reply type no more free sockets unknown request type request denied by local node request denied by remote node bad checksum too many transmit retries socket not open receive bus error transmit bus error bad asknode version number memory parity error during transmit unknown network too many networks in internet conflict with another node listing quit fault during node listing waited too long for more nodes to respond data length too large operation not defined on network hardware header length + data length exceeds max msg size no nodeid prom on this system device stat block is not valid device stat selection index is out of range foreign node does not support all network features attempt to transmit with invalid FROM ID header data length exceeds max size allowed   HOS   4          4     
       /
     fault handler   4 ,R
                     /8 odd address error illegal instruction integer divide by zero CHK instruction trapped - value out of range? arithmetic overflow privileged instruction violation invalid SVC code invalid SVC procedure name undefined TRAP instruction unimplemented instruction protection boundary violation bus time-out invalid user stack pointer correctable memory error detected uncorrectable memory error detected process quit access violation CPU B enabled with MMU valid bit reset null process running on CPU B OS-internal quit (with display return) single step completed invalid user-generated fault (subsystem code = 0) fault in user-space interrupt handler for pbu device process stop process BLAST cache parity error PEB WCS parity error unimplemented SVC invalid stack format memory parity error process interrupt supervisor fault while resource lock(s) set spurious parity error floating point inexact result (loss of significance) floating point divide by zero floating point underflow floating point operand error floating point overflow process suspend fault process suspend from keyboard process suspend due to background read process suspend due to background write process continue fault fault(s) lost; process suspended or pfm_$enable/pfm_$inhibit mismatch? coprocessor protocol violation floating point branch/set on unordered condition floating point signalling not-a-number invalid thread during parity error check illegal page fault in user gpio interrupt routine bus error while running on cpu B spurious interrupt unexpected bus error during system initialization cleanup handler set cleanup handler released out of order ac power failure fpx parity error unknown fpa exception VME bus error on bus error AT bus parity error -- (I/O channel chk) Breakpoint Translate Error Illegal Lock Lock Timeout Unknown Status Floating Point Exception A88K FPU Internal Error: Specific code in FPCSR<6:0> pause interrupt received by cpu halt interrupt received by cpu trap occurred while already in trap mode unaligned instruction floating point hardware error -- incorrect data stored to memory integer processor hardware error -- incorrect data stored to memory   2OS   4         4     
       /
     display driver   4 ,R
                     /8 invalid display unit number specified font not loaded internal font table full invalid use of display driver procedure font too large error unloading internal (hdmt) table invalid direction from SM unexpected BLT in use internal protocol violation too many pages to be wired unsupported font version # invalid buffer size error mapping display memory error borrowing display from screen manager unable to borrow - display in use display borrow request denied by screen manager error returning display to screen manager can't return - display not borrowed can't borrow both displays simultaneously display already borrowed by this process invalid position argument invalid window limits argument invalid length argument invalid direction argument invalid scroll displacement argument invalid blt mode register invalid blt control register invalid blt-done interrupt invalid interrupt routine state invalid screen coordinates in blt request font associated with specified id not mapped display memory is already mapped display memory is not mapped quit while waiting invalid cursor number hidden display memory is full quit while waiting invalid eventcount key operation not implemented on color display non-conforming and main memory blts not implemented invalid DM window id acquire denied because window is obscured no more direct mode window ID's available process not found pad/stream operations not allowed while display acquired display already acquired display acquire timed out bad tracking rectangle tracking list full hidden memory does not exist  OS   4 A         4     
       /
     volume manager   4 ,R
                     /8 Warning: disk is write protected  entry directory problems on logical volume unable to dismount the boot volume logical volume is not mounted entry directory is not on specified logical volume physical volume replaced since mount   OS   4         4     
       /
     calendar manager  4 ,R
                     /8 invalid syntax for date or time specification date or time specification invalid an empty string was passed to a decode routine timezone specified is unknown invalid time-zone difference   OS   4           4     
       /
     cross-process debug manager                     /8 locate target spans multiple objects locate target spans discontiguous segments invalid state argument  not a debugger debugger not found debugger table full requested state inapplicable to machine type already a debugger target process not found no event posted for target - not suspended invalid ec key locate target has variable mmu access state unavailable for this event invalid control/inquire option Mutually exclusive control options superfluous or illegal target setup target process is forking target process is execing a program target process is invokeing a program target process is exiting target process is loading an executable image target process is vforking   OS   4    "      4     
       /
     deferred execution module manager                   /8 no more deferred execution queue slots datum too large for deferred execution wired dxm helper not currently supported   OS   4   "      4     
       /
 Ĭ    level 2 eventcount manager                      /8 internal table exhausted internal error asynchronous fault occurred while waiting bad eventcount unable to all                                                                                                                                                                                                                                                   \                        g1H $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          \      #       ocate level 1 eventcount level 1 eventcount not allocated   OS   4 :   #      4     
       /
 ̬    level 2 process manager ,R
                     /8 process not found not a level two process bad stack base request is for current process suspend request timed out process not suspended process already suspended child process terminated another fault is pending for this process invalid process name bad eventcount key attempt to complete vfork on non-vforked process wait found no children process is a zombie no entries in level 2 process table process is not a debug target process is already a debug target permission denied internal error process is already an orphan process is a process group leader another process is using this process group id attempted to join a process group in a different session   OS   4 S  $      4     
       /
 Ԭ    import/export manager  ,R
                     /8 entry directory is not cataloged in the namespace files are locked on this volume specified entry directory not on this volume volume is not mounted   
OS   4 l   %      4     
       /
 ܬ    startup/shutdown  4 ,R
                     /8 node ID mismatch checksumming already enabled no os paging file -- please run invol option 8 no calendar on system -- please boot over network CPU board below minimum revision level undefined interrupt   exception handler is not longword-aligned cpu has unexpected cpu id in vbr reg   OS   4    &      4     
       /
     vfmt   @  4 ,R
                     /8 unterminated control string invalid control string too few arguments supplied for read/decode field width missing on "(" designator encountered end of string where more text expected encountered null token where numeric token expected non-numeric character found where numeric was expected sign encountered in unsigned field value out of range in text string character in text string does not match control string terminator in text string does not match specified terminator   OS   4 k   '      4     
       /
     circular buffer manager ,R
                     /8 invalid block size requested quit while waiting buffer wrap-around error   =OS   4 8  '      4     
       /
     pbu manager @  4 ,R
                     /8 ddf is larger than one page ddf has wrong version invalid unit number in ddf invalid csr page address in ddf csr page is in use initialization routine not in library cleanup routine not in library interrupt library too large interrupt routine not in library pbu not present too many pbu manager pages wired invalid unit number unit in use unit not acquired unit already acquired bad parameter no room in iomap requested iomap in use iomap already allocated iomap not allocated invalid iova buffer too large buffer page not wired buffer not mapped page already wired page wired too many times page not wired reference to csr page caused bus timeout trap 6 executed outside of interrupt routine invalid trap 6 code invalid usp at trap 6 protection violation unexpected interrupt from pbu device ddf has wrong file type too many wired pages csr not in device's csr page controller already mapped bad controller memory length bad buffer address interrupt library not found device library not found device is not a shared controller device not mapped pbu device got bus timeout on multibus all pbu units in use wrong version of /lib/pbulib in use interrupt level in use operation valid only for VME device physical address list too small function not supported for this device type illegal dma channel number bad dma direction specified requested dma channel in use requested dma channel not in use dma channel not at end of range no more eventcounts available eventcount not allocated to this unit unit already in use as a global device unit is publicly owned buffer pages not physically contiguous contiguous buffer not page aligned   	OS   4    +      4     
       /
     line printer module 4 ,R
                     /8 pna board not installed in system invalid string length invalid string termination line printer not acquired line printer already acquired internal error ppn list overflow - internal error line printer not assigned no line printer on system   OS   4   +      4     
       /
     OS info supplier  4 ,R
                     /8 array too small for complete table   
OS   4 6   ,      4     
       /
     badspot manager  4 ,R
                     /8 bad checksum in physical badspot block bad count in physical badspot block missing minus-one in physical badspot block badspot list too small no physical badspot blocks read or written physical badspot list partially read or written duplicate entry in badspot list no physical badspot information on disk bad daddr for lv label badspot extension block too many extensions to lv badspot list badspot extension uid <> logical volume uid manufacturer badspot list is corrupt illegal physical badspot list address specified  "OS   4    -      4     
       /
     magtape manager  4 ,R
                     /8 warning: tape not at load-point warning: tape unit is offline  invalid mt unit number invalid mode field invalid buffer length invalid parameter no PNA board installed in system magtape unit is not connected magtape not acquired magtape unit is not ready unit will not fit thru 25" hatch magtape unit in use magtape not initialized magtape already acquired invalid option too many outstanding operations invalid buffer address invalid count for erase or space operation tape drive is hung ppn list overflow - internal error config page in use - internal error release problems - internal error unexpected interrupt operation attempted before waiting wait attempted before go issued go command issued while not in batch mode header or buffer misalignment on chained r/w user quit while in mt_$wait timeout during wait or release header buffer not on header page no room from mt_$write - internal error info array (passed to mt_$wait) too small too many pages wired too many pbu devices in use buffer already wired buffer not wired   !OS   4 L  /      4     
       /
     ACL manager @  4 ,R
                     /8 no right to perform operation insufficient rights to perform operation exit_super called more often than enter_super wrong type - operation illegal on system objects entry already exists ACL is remote ACL is on different volume than object ACL protects wrong type of object insufficient address space to open ACL required entry may not be deleted no entry - entry number too large image buffer too small or incorrect size ACL object not found ACL would be unchangeable object may not be readable by backup procedure no right to set subsystem data or subsystem       1       manager project list is full - no more entries may be added project list is too big - it cannot be added to object ACL is full - no more entries may be added Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code required entry missing from ACL attempt to issue unimplemented ACL call invalid selection for required entry invalid required entry may only setid to required entry may not use setid in a default acl invalid right supplied   	OS   4    2      4     
       /
 $    PEB manager @  4 ,R
                     /8 fpu is hung PEB interrupt floating point overflow floating point underflow divide by zero floating point loss of significance floating point hardware error attempted use of unimplemented opcode wcs verify failed   OS   4 v  2      4     
       /
 ,    network logging manager ,R
                     /8 ppn list overflow   OS   4    3      4     
       /
 4    color display manager  ,R
                     /8 illegal caller too many wired pages virtual address not page aligned in color_$map pages unmapped out of order parameter value out of range color display not available instruction queue done wait timed out   OS   4 ^  3      4     
       /
 <    vme bus manager  4 ,R
                     /8 undefined vme interrupt vme bu                                                                                                                                                                                                                                   ]                        k $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                                4       s error ubus error caused by vme bus iomap parity error timeout on vme bus  &OS   4 K   4      4     
       /
 D    cartridge tape manager  ,R
                     /8 warning: tape in write mode warning: tape in read mode warning: tape not at load-point tape at load point warning: tape unit is offline tape power on/reset  invalid ct unit number unit not acquired unit already acquired unit in use no tape controller on system invalid buffer length bad buffer alignment i      5       nvalid buffer address unrecognized action type invalid operation count unit not ready unexpected ct interrupt quit waiting for i/o timeout waiting for i/o too many wired pages no cartridge in drive drive does not exist tape is write protected end of tape read/write abort read block error read filler error read no data read no data and end of tape read no data and load point filemark detected illegal drive command marginal block detected unrecognized drive status dma not at end of range dma underrun/overrun memory parity error during dma illegal controller command controller timeout controller diagnostic failed unrecognized controller status operation already in progress operation not in progress   
OS   4    6      4     
       /
 L    msg manager @  4 ,R
                     /8 socket out of range too deep socket error no more sockets not owner too much data socket empty socket in use time out quit fault   OS   4   6      4     
       /
 T    symbolic link manager  ,R
                     /8 file not symbolic link type bad symbolic link file   OS   4 }   7      4     
       /
 \    internet routing  4 ,R
                     /8 network port not open buffer queue for user port is full unknown network port can not create/delete that port type max number of ports already open routing service type not recognized port belongs to another process routing through-traffic queue overflow operation not legal on this port type unknown network device type no more buffer queues for user networks user network checksum failed bad packet length from user network unable to create through-traffic queue max number of USER ports already open bad request type asking for service change routing not allowed at port with 0 network ID   OS   4 Q  8      4     
       /
 d    internet interface controller                     /8 IIC: dma got multibus read timeout error II      9       C: not initialized prior to operation IIC: transmitter underrun error IIC: undocumented interrupt raised IIC: hardware reset operation timed out IIC: self test failure reported by board init device already acquired device not acquired operation aborted device not in system remote device not acquired could get expected packet from receive socket could not allocate receive socket for device never got expected command completion interrupt wrong board revision level invalid command control block invalid receive control block   OS   4    :      4     
       /
 l    graphics processor manager                      /8 device not present in system device not available package not initialized package already initialized device not ready for PIO device timeout wait terminated by process fault error condition reported by GPU page fault interrupt illegal values for physical page use limits Programmed I/O command error DMA command execution error buffer already wired buffer too large no GPU microcode loaded error reported by draw processor   OS   4 ;   ;      4     
       /
 t    DMA manager @  4 ,R
                     /8 illegal channel illegal byte count channel in use channel not allocated for operation operation did not finish   OS   4 .  ;      4     
       /
 |    IEEE 802.3 @  4 ,R
                     /8 internal driver error feature is not implemented driver version mismatch device is off-line device is already on-line adapter hardware error transmit operation failed invalid unit number illegal packet length invalid statistics block packet type is already in use no channels are available no packet available for receive invalid packet type channel is not open address is not a multicast multicast list is full address is a multicast packet type is not already in use illegal destination address   OS   4   <      4     
       /
     audit trail manager 4 ,      =       R
                     /8 invalid data size file already open excessive event types event logging is disabled this process is not being audited event type is not being audited invalid action code permission to perform action is denied attempted to perform a redundant action could not start event logging file not open could not find audit event list not configured event logging already started event logging already stopped event list format is not the current version   OS   4   =      4     
       /
     Ring   @  4 ,R
                     /8 feature is not implemented invalid controller unit number illegal header length illegal data length transmit operation failed no packet available to receive packet type is already in use no channels are available invalid svc packet type channel is not open device is off-line device is already on-line internal driver error controller hardware error packet type is not already in use driver version mismatch invalid statistics block illegal destination address   OS   4 5   ?      4     
       /
     Areas   @  4 ,R
                     /8 no free areas area in use cannot grow shared area illegal area grow request no free resources area not active not owner of area cannot unmap area no deactivatable pmaps internal error bad reserve   OS   4 }  ?      4     
       /
     utility bus manager 4 ,R
                     /8 undefined interrupt bus error interrupt bus timeout no response from gate array error during interrupt cycle   OS   4 n   @      4     
       /
     pc/at bus manager  4 ,R
                     /8 undefined interrupt bus error interrupt pc/at bus-generated ubus error iomap parity error iocheck asserted on pc/at bus pc/at bus refresh timeout   OS   4   @      4     
       /
     terminal handler  4 ,R
                     /8 invalid option invalid value for special function character invalid handle supplied buffer is too small end of file invalid output buffer length quit while waiting for input get conditional failed - no data available input buffer overrun put conditional failed - no room for data timeout expired   
OS   4 0  A      4     
       /
     serial I/O @  4 ,R
                     /8 invalid option illegal parameter value invalid handle character framing error character parity error data carrier detect (dcd) changed clear to send (cts) changed incompatible speed request input buffer overrun quit while waiting   OS   4    B      4     
       /
     Ring 802.5 @  4 ,R
                     /8 internal driver error feature is not implemented driver version mismatch device is off-line device is already on-line adapter hardware error transmit operation failed invalid unit number illegal frame length invalid statistics block frame type is already in use no channels are available no frame available for receive invalid frame type channel is not open frame type is not already in use illegal destination address   &OS   4    C      4     
       /
 ĭ    SCSI manager   4 ,R
                     /8 SCSI bus not present bad handle passed in call device in use device not acquired device already acquired bad parameter buffer too large page not wired page already wired too many wired pages bad length bad buffer address unsupported function invalid iova device already allocated operation timeout hardware timeout hardware failure internal manager error quit fault received during wait all units in use illegal bus revision protection violation no resources available command in progress DMA overrun DMA underrun parity error illegal command illegal data direction scsi target disconnected scsi target not available no such operation host selected by another initiator scsi bus reset detected host                                                                                                                                                                                                    ^                        K $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          e      E       illegally reselected unknown message sent to host illegal scsi bus phase   OS   4 I   E      4     
       /
 ̭    XNS Error Protocol  4 ,R
                     /8 source is broadcast address illegal buffer specification packet type error cannot open to XNS IDP   OS   4 /  E      4     
       /
 ԭ    MAC-independent interface 
                     /8 port operation not implemented no channels available packet type table full invalid packet type packet type in use no OS sockets available caller specified neither OS socket nor demux proc channel is not open no socket allocated for caller no packet available to receive data capacity too small for received packet illegal buffer specification invalid port version number   could not put packet into socket invalid port number invalid type count illegal destination address   OS   4   F      4     
       /
 ܭ    XNS IDP @  4 ,R
                     /8 no channels available no OS sockets available caller specified neither OS socket nor demux proc channel is not open no socket allocated for caller no packet available to receive data capacity too small for received packet illegal buffer specification address in use invalid type count listen network not connected illegal IDP socket IDP socket table full IDP socket in use OS socket not open no client for packet bad IDP checksum maximum hops exceeded by packet network unreachable illegal OS socket invalid version number could not put packet into socket no OS socket depth given cannot send only as well as listen cannot send only as well as connect cannot connect to broadcast address connection source address must be this node cannot connect as well as listen host address table full   OS   4 &  H      4     
       /
     Routing Information Protocol                     /8 network unreachable cannot open to XNS IDP   OS   4   H      4     
       /
     Apollo-private Protocol ,R
                     /8 could not put packet into socket   OS   4 z   I      4     
       /
     System Bus Manager  4 ,R
                     /8 undefined interrupt unknown interrupt ID  istream manager  I      4     
       /
     open   @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  P      4     
       /
     create  @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on mul      Q       tiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream      U        operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot init                                                                                                                                                                                                                   _                        :X $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          {      V       ialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  W      4     
       /
     get_rec @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a dire      ]       ctory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  ]      4     
       /
     get_prior_rec   4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  d      4     
       /
     seek   @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & p      e       artial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream                                                                                                                                                                                                                    `                        L $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                                g       by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  k      4     
       /
 $    create_here @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  q      4     
       /
 ,    truncate @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads b      u       ad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from                                                                                                                                                                                                                                   a                         $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                                x        write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  x      4     
       /
 4    put_rec @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small        y       warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 <    replace @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 D    put_chr @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open                                                                                                                                                                                                                                    b                        A $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          b             with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 L    close   @  4 ,R
                     /8              warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - ch             ecksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - leg             al only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 T    delete  @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside o                                                                                                                                                                                                   c                        Q $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          :             f current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 \    inquire @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 d    redefine @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error              move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 l    open_rec @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory manageme                                                                                                                                                                                                                                   d                         $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "            nt error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 t    pad_create @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 |    memory manager   4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     get_conditional  4 ,R
                                                                                                                                                                                                                                                                        e                        Mޏ $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          qn             /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed              resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     internal module  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     get_ec  @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal                                                                                                                                                                                                                                   f                        ; $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          Մ "             attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     internal module get_fcb.sfcb                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     internal module get_fcb.pfcb                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     fork   @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire w                                                                                                                                                                                                                                                   g                        AU $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          H "            arning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     dup   @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     get_buf @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced lo                                                                                                                                                                                                                                                   h                        B $      RCP011.B                       :  E9  [B]RPC$NIDL.EXE;6                                                                                                                                            f "            xWj1CSvL_؜L>cbbU[aˤk("-6g Ò$	\c8ZQ	EQ}ll߶#*oUX!DwD	v
XpO>Շ+!mV+cJq
IsLkrj<ȳ':qy	hu+œ!fkJ?RV)
w2|
2&"X@bcr=2D	6_Cy)R/2dqLDkio
>]`Ҡ>Djʱ?Nѐ<l}/fv3W+yz
`=y/;<čo(1rW=_W:-@s,gtgu@g$̚ǧڞlMM:JCPٺa岃u}P[qw^$;*بfU},^Mw׿UvbxoH!E&'^WDg=8j.+OM=pHLFv. ad>M9L	qZ-a
W1O:e$in\t~恤휆VWM&d'8
FHKdw
۱s5'xd(IeԲEM҃չD'
eAׂ
w|ڝ
{9jiJq)1wa)|xJD*f@"<?BzMnv:HQu=WoڥC,N&!xqQV24 Pdo|*tN	G#xږ𠟟rc
SWƞED%O"#F-qK6)@%!mۣiɞ]j~NsL_2cPH800Sdc/KQDׯYԂrh}PJe+Ȳ#e3@68ȑCN/<ڞ՞(x#?AjbRX4^t%aDYY	 P[qG4LYw^DS |ڒ¶mPn~0,X깈wf*ӱV=ܟ[D^:ؙA4jTh/Hd:cs	
"Md-M>C+htzsJ#
eWmQ+y՘HQXmV	W'
A߉${HIf)SCMu:;ŋx<vC`1Խ=SV`z kAozJM~E$PqSxNШ	fZ]&Jc6PDBQueKӔym-N5ɺ@o(Q_eg} Vz֍~ckv,Gh}Àzq
K9_cf&
FC+@hyYwQ)$a(;O6%팑4W^U8Qyf&>3[[M$7K;T|u#["-Ŕl_LPw8:~;3	5*OMrwo4X}
+Qn:ԐЭloy[5ЩBMChf̂>Nf$97H<7HLn1qz~iBA"1F8<Q!8
&xK(
|)+1I;LW6)dR9E3Tc`-G?(E,Q;0J$}.B<Bf~d&'KTW5-qgzRgg~C&娂D ^Ƭn`0hȡmMm/ptywUsJckmqAXF>`C:^{VU~
Vo\i>W8BNZQZpև]Jr$,0-ysx|/!<ȇL[[&ERt
H<<Z=mcWOxk(;~gO԰^8$㬺z;
F BenrQ6:ؔW-8YIK@l-u^l]UݏMgVg.0>/'OsJ(r%C=I\5QQs;uȽ W߇U|Ykň}pGxǗNG霷\Eօjӧ^SgɳSЅax^
qr j؋vGoa Y,b/B`	a__SN2]՜&%
]慴hD˱OTDb?{ yvɥ
ć%l"n$rЄD1q6`uǱ<U0W Ju9 N2QvE@b걚}"%胧< cy_kn-ӺDV-(p2(fOݏlCxзh>,GƁJXA`{S..]/$qsZ>k% ;kQ9=3WaJJeAajt+qωWbY1hmb,ٲ\]_7Jj 8`))z_KH}_P/1)ч.: QRI5rǉVH8	jG	bRHmT[9:Ccup]F&588(n57uCe0?7q"}y|0oӓW!no,	V8(1	qwxݡR@R7ejTSoE	LLU	+)\~ #?IE|{@,mR\I؜i&E^yp5N_LBh^լ`c̚=\%i'@j1EGzt
 Ov;++|xo-ݟ߬_t%,&Hb^Ei0\h?qxC&/SL{k@QSc!J센#qE7O)yr=K1$?B`h	isO\ޗ+݂Y>Sg17%J/sj"t"eۆF#o^c%d,| ']en}@Z )`3}@cY(3>tBtƊ	WCmEZżk)m~y;NE(?/`*~`UIܢo)aSDF!fpbgӰaSL5dil|l;~p.
~;OXNN`F_\(c5.>zU{`O;.*
}t7]z\\C':b?+nhxķ/C('lEu>=wp-A nt%Uai&a{ 	tV<ΌP)6p4ē,(L*GBEUc]M'5z[R4?@@t>TZȳ)Z%7t=]kיˢNr!/l)n}'0؛`ҷ퓥).Lv =r$E`$Щo%/ɐΜx) +:cEɻ4ˉvK9ą=s.#O)~6pLBYT`w5 3t%8dl -JW9Z'ߐJ&jC.j嗦sWdt|ʔvcZ#3Oo6%O^⋅wCD5v'U!T6n-RS1믬z=:)x%(2LՑg&0PS;K6Z߹L*-8O% 
|JpeʞQJы<v)	9KYQc݀䫝3Vm0<)ֺU)Ε~=w^\ A忥ޚ]IU8hUeI1ITT&_(ܮZMe:$E d~N u_/ؕu4-2д+>3IwEWu3uc[Ũ3DW.$?d!rMfnPwS!iEWCQyťm)e4#
D}j2vd+w^5!CFsLk[OUvY*;$!wU~PN5* %~@GirP7ު]!㢥q('R,rP˥ _174q!MP^wƑQ޹n33 '̚{V+꽤znOKGĲԆD;My`Ukdhx5-l0-¬ȗ痪jB	Zk/`V|A:
#=qWat[.%XX/YEYAfv ʬVuqH2|qVE:r$S"xޙMBD君n蓷`ۍ\Tt0Ņ[wgMڙ^U #Ez1sIS
chz/_a`b3T{1$]EL{bxhFW]cp7WM@] \GU.
ئGl'ȄRIdOYk.EtH[ߥY0?zc^c"S1[G)D@M߻?9/㨼vMK42sq1o>-xYd6m/5UG$Pլ))r;<"5N'2Y.6d~r13QVA8g!& KZ
p{}~f\\I,6B .oEN/Wh>gh.vD?@I.y̚HZvɫ׶LCZ6zw| waf>3M}o0OKrr*;pTEǄ_
f`	R^.mҗ0|qܱ*5S5ndcuԵtd/`}YZؠlSysq0-A.6%WtX2TUE}7B\`{м.ah
z.d\yWAIY^^3+wD>ӽV> b\>uhnKT^-&?ce#5]sphе) Erj@֜fCn/˼@*x)"rT{[b3.REoVj0(;7'JB$pJG%Q[enaHGʻ$Jd0cװum}z'nbo#2D:lp)IM,~sX" 6qmi8wLE`$syH:Nؓy/SzA]5kXjW!%	g|X㖠5[:?ږh#4<R { ![Lus]-JoH+J;}pdy.(:MZ景|.v^*QFA>OiFen5>]
T^q)䏱tA5kvN,19hAZp#y]\ij3g ȳRzNt NlS-lr%2LsR뷩YfZw'DibD_qc[U_)gNbl&7[pd7?0v:bc]zA\g8o1cfk ;Yz6r[8mKPr渕./z$T8e!_/len|gAiRÚit59L*Bx0&CPHNhܦȾҕxY>&7!tSy8\b4ЅԞGg-c^A(Cd~gը=\̿6cyI8TO3̘-tmg	(Q³X}|
 7$
9XwSv[N, ~m>2XR5p"eؙ,wbam}
[zJD
;CU-^$sɶ rؙ@E!3)g] d>_SM&qm%}>5
dK*-{@clO<_뾣x= dTeb= "ً-@#P*-}Q^_@AQj=G
tK4#ySZ8Ȁ-ZՊ$$gח	^SG6`SNغVJ#_dXkg!f6 *H7S M	?ÇP#*Mv>s:ET2MO΋|X5+Nu|gOšc z8O?LsL0vċ (o:	j|DI,r{=M8Wwݏi
	Ijfӵ5%./$m2M=ғ#r!~^tJ*lr9a|!p.oQ链`Ϋ*%0auɛ	I	_y&r]د@@k;%iM<y8]^^+)cՠ]F"䅰RT˶P+Ħiҡ*xW8rFx^k8`Ձ.^pvY4w3`Ѩ7*Æq67;AEtL~x]!:	%8삅fQ@gg|5Ezw;!nףnŨ!֐&OmGs;y5DФ6=U4tڠķm0|i8Ce!_jkWWnOn<32
u]\l
Eͷ\n*Mx͇j*;9vft~#g
Z9<{^*.>G|.U
K0u<DYUXA7p(' ae:qXhj?4kP3Ojm><c/T;W*Dإٓ81DXr;{`t52TGҬd~^'6:j-G ߒ#FpV>@Diۍm#paoSТFV1$0]2:j9Rpq#
j;*BXvkw
&|dIH/(1a~ŢjX`Fx\<:|.&é|pмWC	:H5ݤ,%ebq"E]̎X!W_[#2SS<N\6zVzluLUHwyiʦiӢ}w#{b<j6Е;ib^ɱLq b^?9bPpšMIĖ::$uBw

.=$6\ME23U4G|.r$'>x2ŝ~L+wǲ"g_*}+f-U/jWRQSCQ$Oa"|eገrQC4.g[H};O#tw &31j0(Vk%@l NY!$lc!߁gDj4]']FR"3Xdצ+ SӫFB~DWH#j^4`V6d.j%`۵=aXi^a_r4d%cTkNzY80,-^8dw򘷈|v<JrP3@~Lc;˃hHXXBOS"@0T_d#+( Ɏ!z9Fse+V@_/cdIkla),` Ht2=>|XRh })HtXK3JpQwн\ݾQZy/!mUN8[
%D,zRj0I_L$4
Fe(CeL盒o;Ȗh30.YKSx-q,1/dΆV0d1&|4{)GW0P|mGUl8rТ̒-w!FP*}Z7``:m6_^]}Y!ٰtRD'oOd{$M} 󤓢S,1G1Y7mHTOe =t1 ?2t'7⻪Ww$I7d'3*+	z
cwicm=FJ{$fq~msxRY~	P  CsTO                                                                                                                                                                                                    i                        r $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "            cate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 Į    alloc_sh_sk @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 ̮    free_sh_sk @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
 Ԯ    init_sh_sk_pool  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no avail                                                                                                                                                                                                                                                   j                         $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          @ "            able target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       4     
       /
 ܮ    bypass  @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       4     
       /
     force_write @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter                                                                                                                                                                                                                                                   k                        y $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          w "            combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       4     
       /
     get_xp_buf @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       4     
       /
     open_xp_buf @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        4     
       /
     pad_init @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files                                                                                                                                                                                                                                                    l                        t $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          { "     "      must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  '     4     
       /
     replicate @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  -     4     
       /
     force_unlock   4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line canno                                                                                                                                                                                                                                                   m                        W4 $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "     3      t create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  4     4     
       /
     switch  @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  ;     4     
       /
     dump   @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  B     4     
       /
 $    get_uid @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?)                                                                                                                                                                                                                                                   n                        r2 $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          2 "     D       character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  H     4     
       /
 ,    IOS   @  4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream tty has changed sessions I/O operation attempted by background process unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  O     4     
       /
 4    advisory_lock   4 ,R
                     /8 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no                                                                                                                                                                                                                                                   o                        T $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "     U       data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented   stream manager  V     4     
       /
 <    sfcb   @  4 ,R
                     /8 unable to obtain sfcb mutex lock out of global read/write memory unable to find sfcb in sfcb_$free unable to obtain sfcb hash table mutex lock   Wdisplay manager V     4     
       /
 D    DM process @  4 ,R
                     /8 Command syntax error Unknown command name Too many command arguments Position specification syntax error Key definition incomplete File not found Unable to access file Text is read-only No text under cursor Too many windows Too many pads Display manager internal error #1 Unable to write new file You must finish current command input request before making another Key definition too long Cursor is not in any window Line too long - truncated CC command requires position mark Unable to create new process Unable to create new pad Input pads cannot be replicated Bad font file Font table full Unknown function key name Window too small for any text Display manager internal error #2 Pad deleted by client process Pad still active Illegal grow coordinates Display manager pads cannot be named File is not an ascii file Processes still active Bad text range Paste buffer empty Invalid regular expression pattern Pattern too long Illegal substitution expression No match DM input window cannot be deleted No room for more text at that position Invalid hexadecimal digit Invalid tabstop value Edit pad already open on that file File already modified No window selected for grow or move Line contains non-editable controls Cannot delete .bak file Heap file inconsistent during recovery A process with that name already exists Search aborted Operation illegal during search or substitute Argument value out of range User logging out Error processing user_data/key_defs Previous fatal error prevents typing (try RW -R) Nothing left to UNDO Command illegal except during node startup Can not create paste buffer You cannot edit this pad Pathname has changed -- close window and reread Can not edit that object type Invalid paste buffer name Operation is illegal on an icon Maximum file size has been exceeded Echo mode is already on; ABRT will end echoing Echo mode aborted Name does not correspond to a window Command aborted Command is not allowed during login Logout has been disabled Insufficient memory for operation. Try closing pads Paste error Previous attempt to read file failed. Try reopening Cannot set privileged environment variable Variable not defined Command illegal after login No balancing character found Too many open characters Too many close characters Current color map usage prevents turning MONO off Mailbox data not available; pad request lost. Commands cdm and mono are mutually exclusive Window no longer exists Command illegal when WMGR -OFF          Cannot CC foreign windows Paste buffer is too large for undo buffer Unable to save file until no one else is reading it   display manager \     4     
       /
 L    Heap manager   4 ,R
                     /8 heap table full invalid length for heap get invalid heap return heap space already free on return   display manager \     4     
       /
 T    Pad manager @  4 ,R
                     /8 stream is not a pad operation valid on input pads only stream id out of range operation attempted on unopened stream operation valid on transcript pads only pad not in raw mode value out of range too many fonts loaded in this pad error loading font file unknown function key name only one input pad allowed per transcript illegal parameter combination existing pad must be an ascii file operation illegal with > 1 client process user aborted (WC -Q) edit operation specified window number does not exist window is no longer displayed operation illegal on this type of pad operation illegal when no display is attached   display manager ^     4     
       /
 \    Pbufs manager   4 ,R
                     /8 actual buffer type differs from specified type   
process manager ^     4     
       /
 d    process manager  4 ,R
                     /8 invalid parameters to pm_$invoke process had a fatal error no space for Known Global Table process already named process has no name error initializing global read/write storage error allocating PFM error mask too many libraries -- table space exceeded mark/release list full process not found argument vector too large no static space available for process creation process name too long   !process manager _     4     
       /
 l    loader  @  4 ,R
                     /8 too many undefined globals object module has too many sections disk full or not enough address space to copy procedure text file is not an object module or is not executable on this machine type object module format is incompatible with this software release not enough address space to map procedure disk full or not enough address space for static storage Known-Global-Table is full reference to undefined global library contains unresolved global(s) peb required to execute this object module object module has unremovable breakpoints; rebind C library initialization required; no C library is installed DN160, DN460, or DN660 required to execute this object module FPU required to execute this object module M020 series node required to execute this object module Cross rev. incompatibility, sr9.5 code calling pre-sr9.5 code load address already occupied absolute load address already occupied absolute object module requires relocation conflicting loader options and requirements unable to install a library required by object module FPA board required to execute this object module reached the end of the executable image list invalid image handle invalid section number object module requires link step object module requires unsupported systype load in progress while table being examined compound executable contains no module for machine type object module systype sys3 obsolete; see sr10 release notes load context requires position independent code load context precludes unload  process manager b     4     
       /
 t    process fault manager  ,R
                     /8 warning - multiple debugger fault handlers are in use  cleanup handler released out of order invalid cleanup record cleanup handler established successfully pfm_$cleanup_set was signalled no rws space to create static cleanup handler static cleanup handler not found attempt to release non-existent fault handler attempt to release fault handler at wrong level  stranded or corrupted cleanup handler record unable to unwind stack because of invalid stack frame   process manager c     4     
       /
 |    program manager  4 ,R
                     /8 argument does not exist argument is too big for supplied buffer stream vector is too large (>32) not a program process is vforked incompatible invocation options illegal option option requires an argument no entry point process is running on signal stack wrong object module format   process manager d     4     
       /
     mapped segment manager  ,R
                     /8 unsupported access rights requested attempt to release segment mapped by previous level no object mapped at virtual address supplied object already locked in a way that precludes your requested use not enough address space available bad length object not found no rights insufficient rights operation illegal: objects are on different volumes operation illegal: object is not temporary operation illegal: object is not locked properly   process manager e     4     
       /
     r/w storage manager 4 ,R
                     /8                                                                                                                                                                                                                                                    p                        1ֈ $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          SH "     f      attempt to release non-heap entry using rws_$release_heap attempt to release heap entry created at earlier program level heap corruption detected; block header incorrect heap corruption detected; level number in free block incorrect attempt to release heap entry not allocated from this pool requested rws_$pool_t out of range unable to allocate because of lack of resources   process manager f     4     
       /
     basic heap storage manager                      /8 attempt to release already released heap storage out of heap space heap corruption detected; block header incorrect requested too large an area from baf   
process manager g     4     
       /
     remote process manager  ,R
                     /8 unable to read naming and working directories unable to resolve home text unable to get SID operation not supported by remote system no more slots available to spawn remote process unknown request no more resources mbx open failed on remote node request timed out sid authentication check failed invalid to specify -me and -login local locksmiths only are allowed command line too long   process manager h     4     
       /
     task manager   4 ,R
                     /8 not enough virtual memory left to create task task does not exist task manager has not been initialized task exited invalid task handle internal error: bad status from ec2_$wait attempt to blast the distinguished task a task attempted to blast itself invalid task priority a foreground task attempted to create a background task internal error: ddslib initialization failed invalid task lifetime this process has the max # of tasks allowed - no more may be created task name is too long task does not have a completion EC task has not yet completed a task stack overflowed a task stack was corrupted   US   4 x  i     4     
       /
     file utility   4 ,R
                     /8 object must be a leaf unrecognized sys_type returned from file_$attributes unrecognized entry type returned from naming server unable to replace or delete a system directory compare failed destination directory is contained within source directory can't copy a file or tree to itself source and destination are on different disk volumes source directory is contained within destination directory pathname truncated leaf truncated  (US   4   j     4     
       /
     print utility   4 ,R
                     /8 Printer fault Printer is out of paper Print Server suspended Print Server not running Printer is offline  ./sys/print directory not found print queue directory specified by link was not found file to be printed is not an ascii text file file to be printed is corrupted prflib option is unknown prflib option value is incorrect more than 1 file found with prflib search option file type can not be printed problem with PostScript interpreter file can not be printed on this printer printer extension value incorrect printer extension value > 9 target invalid specified printer does not exist no jobs queued for specified printer operation illegal : queue is not empty max number of jobs queued print job is active print manager already registered with specified ext value illegal print server signal type communications failure. Try again. no entry in database for specifed key wrong type specified for key read error in print server driver write error in print server driver error creating I/O connection data in print server database corrupted error closing I/O connection internal error in print server driver read error in print server filter write error in print server filter open error in print server filter format error in print server filter input object type incorrect for this filter unable to allocate memory printer with this name already exists user terminated print job user suspended print job print job duplicate from pre10q daemon can not find specified print manager   US   4   m     4     
       /
     DB    @  4 ,R
                     /8 normal exit from debugger   US   4    n     4     
       /
 į    object module IO  4 ,R
                     /8 too many IO channels in use channel is not open get or put outside file ran out of free read/write storage cannot open another temporary file; one is already opened requested object file name exists and is not an object   
US   4   n     4     
       /
 ̯    TU58 tape @  4 ,R
                     /8 bad block number invalid op code motor stopped seek error data check write protected no cartridge bad unit number end of tape failed self-test   US   4 
  o     4     
       /
 ԯ    sio   @  4 ,R
                     /8 object on this stream is not sio line bad option parameter illegal stream id stream not open speed incompatible with partner SIO line   
US   4    p     4     
       /
 ܯ    pattern matcher  4 ,R
                     /8 too many tag specifiers ("{ }") too many end-tag characters ("}") missing end-class character ("]") invalid use of closure ("*") missing end-tag character ("}") pattern too big to fit in supplied buffer invalid escape sequence bad pattern given string and pattern do not match output string too small   
US   4   p     4     
       /
     wildcard processor  4 ,R
                     /8 can't get free space for pathname invalid wildcard length invalid wildcard name invalid use of directory closure ("*" or "+") too many components internal error #1 circular link detected first name found excess end tags ("}") in wildcard missing end tags ("}") in wildcard   US   4 ]  q     4     
       /
     font manager   4 ,R
                     /8 font table is full bad font file unrecognized font version # bad font id argument bad value id character is not in font free storage space full character is too large descriptor or header value is out of range invalid character code no character image font is read-only one or more images are required font table is full   US   4 "  r     4     
       /
     shell   @  4 ,R
                     /8 shell lexer has failed - unable to recognize input parse tree has been corrupted - unable to recover unable to allocate space for parse tree wrong file type - can only execute object and text files program not found inlib command obsolete; relink program with inlib option insufficient rights   !US   4    s     4     
       /
     aclm   @  4 ,R
                     /8 no right to perform operation insufficient rights to perform operation exit_super called more often than enter_super wrong type - operation illegal on system objects entry already exists ACL is remote ACL is on different volume than object ACL protects wrong type of object insufficient address space to open ACL required entry may not be deleted no entry - entry number too large image buffer too small or incorrect size ACL object not found ACL would be unchangeable object may not be readable by backup procedure no right to set subsystem data or subsystem manager project list is full - no more entries may be added project list is too big - it cannot be added to object ACL is full - no more entries may be added invalid right name invalid person identifier invalid project identifier invalid organization ID invalid node ID non-existent SID subsystem name not found required entry missing from ACL attempt to issue unimplemented ACL call invalid selection for required entry invalid required entry may only setid to required entry may not use setid in a default acl invalid right supplied   US   4   u     4     
       /
     uvtoc   @  4 ,R
                     /8 object is not a local entry directory no available address space end of vtoc   	US   4 g   v     4     
       /
     cl    @  4 ,R
                     /8 Argument too long Too many arguments follow keyword Not enough arguments follow keyword Invalid decimal number No match for wildcard Missing required derived name Unrecognized or redundant keyword Duplicate set element Invalid set element   US   4   v     4                                                                                                                                                                                                                                                        q                        VF $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "     w      
       /
     bin_tree @  4 ,R
                     /8 unable to allocate rws space end of list not found   library 4    w     4     
       /
     open   @  4 ,R
                     /8 do not provide name for SCRATCH file need name of file to open invalid STATUS= option direct access not allowed with variable length records given record length is not compatible with this file need record length > zero invalid ACCESS= option invalid FORM= option invalid UNIT= specifier no space to create requested IO unit FORM= option value not compatible with this file BLANK= option not allowed for unformatted file invalid BLANK= option unrecognized special name beginning with "-" command line arguments are named ^1 thru ^9 file not found   library 4 8  x     4     
       /
 $    close   @  4 ,R
                     /8 KEEP status not allowed for SCRATCH file invalid STATUS= option can't delete file   library 4    y     4     
       /
 ,    mark/release   4 ,R
                     /8 cannot find old Fortran IO state record   library 4    y     4     
       /
 4    IO    @  4 ,R
                     /8 no space to create IO unit unit is not connected recursive use of FORTRAN IO direct access not allowed to sequential file need record number for direct access invalid option(s) used to reference internal file feature not implemented yet end of file unformatted operation not allowed on file opened for formatted IO formatted operation not allowed on file opened for unformatted IO not enough virtual address space left to perform requested operation   library 4    z     4     
       /
 <    IO transfer @  4 ,R
                     /8 Internal format error No edit specifier in format Improper character in input data Real exponent too large Improper format descriptor for variable type Data overflows buffer size   library 4 7   {     4     
       /
 D    read   @  4 ,R
                     /8 end of file record is larger than available buffer = expected name not found in namelist ) expected integer expected as an array subscript ( expected number expected , expected array variable expected subscript out of bounds unknown high dimension on array variable   library 4   {     4     
       /
 L    write   @  4 ,R
                     /8 nyi   library 4 M   |     4     
       /
 T    position @  4 ,R
                     /8 no space to create unit unit is not connected recursive IO   .library 4   |     4     
       /
 \    floating point   4 ,R
                     /8 overflow in add/sub underflow in add/sub loss of significance in add/sub overflow in multiply underflow in multiply overflow in divide underflow in divide division by zero overflow in convert to word integer overflow in convert to long integer overflow in dp add/sub underflow in dp add/sub loss of significance in dp add/sub overflow in dp multiply underflow in dp multiply overflow in dp divide underflow in dp divide dp division by zero overflow in convert double to single underflow in convert double to single square root of a negative number overflow in exp function overflow in dp exp function arg of log function less than or equal to zero dp arg of log function less than or equal to zero underflow in exp function underflow in dp exp function attempt to raise sp zero to a power <= zero attempt to raise sp negative number to a real power attempt to raise dp zero to a power <= zero attempt to raise dp negative number to a real power both arguments zero in sp atan2 both arguments zero in dp atan2 overflow in sp x**y overflow in dp x**y underflow in sp x**y underflow in dp x**y loss of significance in sp tan - argument too large loss of significance in dp tan - argument too large loss of significance in sp sin - argument too large loss of significance in dp sin - argument too large loss of significance in sp cos - argument too large loss of significance in dp cos - argument too large argument out of range invalid op code unsupported function for this hardware configuration   library 4 f       4     
       /
 d    inquire @  4 ,R
                     /8 cmd line args are named ^1 thru ^9 recursive io target string too small   library 4 2        4     
       /
 l    format  @  4 ,R
                     /8 left parenthesis expected right parenthesis expected period expected comma, colon, slash, or right parenthesis expected unsigned integer constant expected p format not followed by f, e, d, or g bad hollerith or character constant unrecognized format specifier  Tlibrary 4        4     
       /
 t    tfp   @  4 ,R
                     /8 computed block count doesn't match that in EOF label  volume not found volume not open volume already open file not open file already open file not found tape i/o error end of volume encountered invalid file section value invalid file sequence value invalid generation number value invalid generation version number value invalid block count value invalid block length value invalid record length value invalid buffer offset value no tcb is available (internal table full) invalid unit number first label on volume is not VOL1 label label version number in VOL1 label is not "3" tape drive is already in use by this process end of file tape limit: eot/bot marker encountered label size is in error; not 80 characters block size is too large invalid record format specifier unlabeled operation attempted on a labeled volume labeled operation attempted on an unlabeled volume invalid volume id conflicting blocking information file does not exist on this volume internal or exception procedure returned bad new-volume info a HDR1 label is missing where one is required an EOF1 (or EOV1) label is missing where one is required a double filemark was encountered unexpectedly inconsistent file sequence numbers file sequence number tracking error read attempted on file open for writing write attempted on file open for reading block list size is invalid an EOV1 (or EOF1) label is missing where one is required wrong volume, file header is inconsistent with previous trailer operation not started due to error in previous block list record i/o attempted on volume open for block i/o only variable record with invalid record control word encountered spanned record with invalid segment control word encountered erroneous spanning indicator or segment out of sequence encountered invalid mode set passed to tfp_$set_mode cannot read mt status - wait is required more info returned from mt_$wait that expected attempt to enqueue too many operations magtape is offline or floppy is not ready wait not performed before go go called with no work to do invalid operation code OS magtape manager out of pb's wait called when not required OS magtape manager didn't purge ops on error # ops executed does not match # ops completed i/o error recovery failed invalid recovery value returned by execption handler zero length block list unexpected tape rewind error tape space-record error tape space-filemark error tape write-filemark error tape or floppy is write-protected redundant call to wire i/o buffers attempt to already-unwired i/o buffers unable to re-open volume; current position is unknown unable to re-open volume; info file is bad tape read-foreign error cannot write at this tape position unexpected sysboot error unknown rmt error rmt tape blank or offline rmt tape is blank rmt tape is write protected or is offline rmt tape is offline rmt tape is write protected or at end-of-tape rmt tape is at end-of-tape rmt open failed rmt prevailing write error rmt unsupported operation   library 4        4     
       /
 |    Pascal  @  4 ,R
                     /8 too many open files use of unopened file REWRITE required before writing to file RESET required before reading from file read past end of file real exponent too large invalid operation on file invalid OPEN parameter inconsistent file usage invalid read data internal error; invalid I/O key type attempt to DISPOSE a NIL pointer attempt to DISPOSE block of memory of zero or negative size attempt to DISPOSE poin                                                                                                                                                                                                                                                   r                        ? $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          j; "           ter to memory that was previously DISPOSEd index outside of string bounds overflow beyond maximum size of string invalid write data unable to DISPOSE pointer; pointer may be previously DISPOSEd or not allocated   &library 4         4     
       /
     MBX manager @  4 ,R
                     /8 size parameter too large size parameter too small too many channels illegal mbx handle file already in use no room in channel msg too big for channel no active servers open rejected end of file no available channels channel not open unexpected control message received remote transmit failed remote reply wait timed out unused invalid mbx handle wrong mbx version number unknown remote request remote service denied channel empty supplied buffer too small unused no more resources available bad key returned data does not complete a record unused interrupt data received another interrupt is already pending on this channel client and server cannot be same process client timed out while waiting for open to complete error occurred during network sequenced send server node mbx_helper has no rights to server mbx client has no rights to local mbx_helper sysmbx server record header conflicts with buffer length local mbx_helper not running and couldn't be started no remote mbx_helper running client has no rights to server mailbox   library 4 _       4     
       /
     ptx plot package  4 ,R
                     /8 image too small in the x-dimension image too small in the y-dimension invalid value for horizontal start  library 4 L        4     
       /
     floppy seq i/o manager  ,R
                     /8 warning: record truncated warning: disk almost full  invalid floppy unit # floppy is full control block is too large end of file end of tape unit is already open unit is not open attempted write on read-only floppy invalid marker specification data error: filler expected where none was found data error: filler found where not expected data error: invalid control code data error: record trailer missing data error: record trailer doesn't match header beginning of tape data error: beginning of tape found where unexpected floppy is physically write-protected floppy is not ready invalid label record -- probably not written with WBAK   &library 4 L       4     
       /
     Ethernet driver  4 ,R
                     /8 controller does not exist invalid ethernet controller number controller not online invalid buffer size parameter invalid statistics type invalid mode parameter invalid options parameter illegal number of addresses address is not a valid group address no receive available quit while waiting receive packet truncated too many collisions device timed out operation failed internal frame header invalid internal dma length error unexpected status from device diagnostic ram test failed diagnostic dma test failed diagnostic transmitter test failed diagnostic receiver test failed diagnostic loopback test failed DDF version is obsolete DMA/PIO did not complete service is not implemented in this driver adaptor reported no resources available adaptor self-test failed No packet type set for this process Packet types are already set for this process Ethernet unit is shared with other processes Ethernet driver master lock timeout Packet type already in use by another process Internal error -- unable to allocate control block Internal error -- unable to open socket Unable to allocate receive buffers Bad argument to ethernet routine Ethernet device lock timeout   library 4 Z        4     
       /
     versatec driver  4 ,R
                     /8 invalid action code invalid buffer size no PBU or Versatec controller is installed device is offline device is out of paper   library 4 Z       4     
       /
     pipe manager   4 ,R
                     /8 supplied buffer too large pipe is empty pipe is full illegal pipe operation pipe has no readers pipe has no writers pipe could not be locked   library 4 k        4     
       /
     amlc manager   4 ,R
                     /8 controller does not exist bad unit number   library 4        4     
       /
     streams-magtape manager ,R
                     /8 object is not a magtape file descriptor magtape file descriptor contains invalid data invalid attribute specifier invalid creation/expiration date invalid record format descriptor file is read-only invalid unit number invalid file sequence number invalid file section number invalid block length invalid record length invalid generation number invalid generation version number invalid buffer offset magtape volume is in use attempt to label unlabeled volume   library 4 h       4     
       /
 İ    streams-directory manager 
                     /8 unrecognized mode size parameter too small too many channels   library 4 )        4     
       /
 ̰    ipc socket manager  4 ,R
                     /8 range error too deep socket error no more sockets not owner too much data socket empty not ipc object socket not open socket already open time out  library 4 @       4     
       /
 ԰    traceback utilities 4 ,R
                     /8 warning: guessed return address  pc not in known code invalid object module version no debug table entry for routine no debug info available for routine frame type illegal for operation routine has no arguments specified argument does not exist no stack frame exists for routine   	library 4         4     
       /
 ܰ    spe driver @  4 ,R
                     /8 SPE controller or SW not installed controller not initialized device is busy device is offline device is out of paper device fault invalid sio line controller already initialized error in interrupt handler   library 4 -        4     
       /
     analog/digital driver  ,R
                     /8 Buffer length limited to 1024 bytes Attempt to allocate or declare too many buffers System cannot create the new buffer Attempt to use a buffer that is not declared Attempt to link a buffer already on xfer list Declared buffers must not cross 1024-byte bndry Declared buffer address must be word-aligned Converter clock set too fast or too slow A/D channel list limited to 16 entries Valid A/D channel numbers are 0 through 15 Buffer was not ready in time for DMA transfer Clocks or triggers too fast Operation took longer than the time out interval Waiting for buffer already released Waiting for buffer not in transfer Converter hardware not present Unable to convert value given   library 4 [       4     
       /
     compound executables manager                     /8 bad compound executable format specified module not found in compound executable   >graphics  0        4     
       /
     primitives @  4 ,R
                     /8 Primitives not initialized Primitives already initialized Wrong display hardware Operation illegal for DM frame Must borrow display for this operation No attributes defined for bitmap No more bitmap space available Dimension too big Dimension too small Bad bitmap descriptor Bad attribute block descriptor Window origin out of bitmap bounds Source window origin out of bitmap bounds Destination window origin out of bitmap bounds Invalid plane number Cannot deallocate this bitmap Coordinate value out of bounds Invalid color map Invalid raster operation value Bitmap is read-only Internal error Font table is full Bad font file Invalid font id Window is obscured Display is not in direct mode No polygon is being defined Keyboard has not been acquired Display has not been acquired Illegal pixel value range Operation illegal when in imaging format Bad value for imaging format Must release display for this operation Different screen modes for input cannot be mixed No input events are enabled Duplicate points are illegal Array must be in ascending order character is not in font Illegal bitmap for a fill pattern fill pattern scale must be one Incorrect alignment Illegal text path Unable to rotate this font Font is read only Illegal length for styled line pattern Illegal for pixel bitmap Input enabled in too many windows Illegal software version nu                                                                                                                                                                                                                                                   s                         N $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "           mber in pad Bitmap descriptor is not for a bitmap file No color map has been defined for this file Illegal call for current decomp technique Cannot change decomp technique while in polygon Specific winding number must be nonzero Arc path coordinates have overflowed 16bits Invalid virtural device id Decomp technique not valid Rop mode set is null, set via raster_op_prim_set Multiple rop modes in set, and rops not equal Input events not available in gpr_$no_display mode Style call is not active No more fast buffers for double buffering Input buffer overflowed   graphics  4        4     
       /
     DM support @  4 ,R
                     /8 Invalid bitmap address Invalid bitmap length   graphics          4     
       /
     core graphics   4 ,R
                     /8 3D inquiry function needed Count parameter or array size is less than 1 Array size is less than 3 There is no selected view surface Inconsistant viewing specification A segment is currently open There is no open segment Color attribute not supported by view surface Intensity attribute not supported by view surface Requested linestyle attribute not supported Requested linewidth attribute not supported Requested pen attribute not supported Requested font not supported String contains undefined characters Charplane and charup vectors are parallel Requested marker symbol not supported There already is an open segment The requested retained segment name already exists Current image transformation is of wrong type There is no open retained segment There is no retained segment matching given name There already exists a segment with given name There is no open temporary segment One or more of the attribute values is invalid All charplane normal components are zero All charup components are zero Image transformation type is invalid Image transformation higher type than requested Segment image xform type not compatible with inq Segment image xform type higher than inquiry Maximum less than minimun value (2D) View up vector components both equal zero Program has already set NDC space NDC default space has already been established A parameter is not in NDC system : 0->1 Neither width nor height is equal to 1 Width or height is equal to zero Viewport corner outside of NDC space A 3D viewing function was needed, not 2D Specified NDC position is outside viewport The world coordinate xform is not invertible World coordinate position outside clipping window All 3 components of view plane normal are zero Front distance is greater than back distance Parallel projection and direction components = 0 Window maximum less than window minimum All 3 viewup normal vector components are = 0 Maximum less than minimun value (3D) Projection of world coord. position outside window World coordinate position in front of clip plane World coordinate position in back of clip plane World coord. position behind center of projection Coordinate system type has already been set Too late - viewing established or segment exists View plane normal and viewup vector parallel Front plane not between cop and back plane Direction of projection aparallel to view plane Center of projection on or behind view plane Front and back clipping planes coincident Device already initialized Device class or device number is invalid Device class is invalid Array contains invalid device number Device is not initialized Device is already enabled Member of group not initialized Device is not enabled Locator device not enabled Valuator device not enabled Time parameter is less than zero Event device not initialized Invalid event device class Association already exists Event class is invalid One or both devices not initialized Association does not exist Event report not from pick device Event report not from keyboard device Event report not from stroke device Needed 3D input function Locator not enabled or associated Valuator not enabled or associated No button devices are initialized Specified pick device not initialized Specified keyboard device not initialized Specified stroke device not initialized Specified locator device not initialized Specified valuator device not initialized Echo type is invalid for specified class Specified device does not accept echo segment Image xform of segment incompatible with echo type Echo position outside of NDC space Pick aperature is less than or equal to zero Buffer size out of bounds Cursor start position out of bounds Initial string contains undefined characters Specified button device is not initialized Distance or time less than or equal to zero Specified locator position outside of NDC space Maximum less than minimun (3D) Locport corner outside of NDC space Low value is greater than high value Initial value not within defined range Associated size less than or equal to zero Duplication size less than or equal to zero Core has already been initialized Specified output level cannot be supported Specified input level cannot be supported Specified dimension cannot be supported View surface is already initialized No output device associated with view surface No other view surface can be initialized View surface is not initialized View surface is already selected View surface cannot be selected View surface has not been selected Immediate visibility state is invalid Currently in batch of updates Not in batch of updates Element of segment array does not exist Invalid visibility array element Core has not been initialized Function at a higher level than current suppory Invalid error log invocation Function is not supported Parameter count is incorrect One or more parameters invalid Vertex array is too small Intensity value is invalid Color value is invalid Specified table range is invalid Low or high table index is invalid Low table index is greater than high Too few values to fill specified range Invalid intensity array element Invalid color array element Origin outside NDC space Array size invalid Array row invalid Array column invalid Invalid parameter value View surface is initialized to intensity Invalid index value Shading vertex mismatch Vertices not coplanar Less than three vertices received Index range is too large Table is too small View surface is of type color View surface is of type intensity There is no hidden surface support The specified mode is invalid View surface is initialized Invalid view surface type parameter Input currently not supported in frame mode There is no room to add to the display list There is no room for new segments Polygon was too complex to decompose Time out in input routine   graphics          4     
       /
     map file manager  4 ,R
                     /8 Bits/inch parameter is negative X dimension is not positive Y dimension is not positive Words/line parameter is too small Position parameter is illegal   ;graphics  #       4     
       /
     2D metafile manager 4 ,R
                     /8 Not initialized Already initialized Data coerce needed No current file Too many files File name not found File id invalid No current segment Another segment is open Segment name already used Too many segments Segment name not found Segment id invalid Cant delete instanced segment Segment locked by pick Invalid polyline options Negative circle radius Circle cant be filled Illegal self instance Aclass id invalid Ablock id invalid Too many ablocks Ablock not created Attribute value invalid No font family included Too many font families Font family name not found Font family id invalid Cant delete font family in use No gm bitmap exists Viewport id invalid Viewport bounds invalid Viewport doesnt exist No current viewport Too many viewports Nothing displayed in viewport Coordinate conversion overflow Command type doesnt match No current command No pick matches found Pick list not initialized Pick list empty Pick list too long Input event type invalid Wrong display mode Illegal value Bounds invalid Name length invalid Font family name already used Obsolete procedure Command type invalid Concurrency mode invalid Access mode invalid Edit option invalid Index value invalid Font type invalid Too many environment file definitions Negative arc radius Flat arc   ,graphics          4     
       /
     GSR   @  4 ,R
                     /8 Operation invalid Zero vector invalid Vectors are dependent Invalid hither distance Invalid clip planes Invalid window Matrix is singular Ran out of space Invalid file id Too many files Viewport outside ldc range No intersecti                                                                                                                                                                                                                                                   t                        <w $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          ! "           on Point outside device limits Illegal instruction Unimplemented instruction Pick interrupt No further picks Invalid context range Illegal single step count Illegal instance depth Display context not found Display break on instance Display break on return Illegal break point found Partial refresh sync error Illegal display mode error GPU device not present Invalid virtual device id Unsupported opcode for this machine Unsupported execution mode for this machine Block size is too small Unsupported device Invalid eye distance Display device error Illegal operands Device unavailable Previous error in display device Insufficient zbuffer memory Font file already loaded Font table full Bad or improperly formatted font file Invalid font id Font still referenced Unable to rotate this font   graphics         4     
       /
 $    metafile manager  4 ,R
                     /8 Operation invalid Unable to remap file No such structure Invalid in read access mode Illegal argument Already initialized Invalid plane count Not initialized Too many files No such file Invalid file id No current file No current structure Too many points Too few points unused (16) Viewport does not exist Illegal value Viewport bounds invalid Attribute value invalid No gmr bitmap exists Too many viewports Unable to clear viewport Viewport id invalid No current viewport Not implemented Unable to allocate page Unable to initialize file Structure not allocated Render record not allocated Edit record not allocated Structure body not allocated Unable to initialize structure tables Viewport borders too large Viewport outside ldc limits Unable to map file Viewport border outside ldc Instance not allocated Tag not allocated Unimplemented mode Structure name already used Too many structures Unable to grow file on open Unable to allocate additional space Structure size too large to grow Unable to allocate element space No current element Invalid for display mode Input event type invalid Unable to grow file at edit Inq element does not match Color id out of range Inq array size too small Structure already open Aclass id invalid Ablock id invalid Too many ablocks Text invalid string length Text up vector too short LDC limits invalid File initialization error No primary structure Too many instances of structure Ablock not created Structure header allocation error Instance record allocation error Tag record allocation error Device limits invalid Returned block too short Structure move body error Structure release version error Instance structure id mismatch error Structure has no bounds Unknown element Tag not located Intensity out of range Element index out of range Structure delete error Add instance link error Drop instance link check error Drop instance backward link error Drop instance forward link error Release instance id error Structure is instanced Ablock in use Color model inconsistent Color range invalid Valid range is 0 to 1 Unable to copy between files File version mismatch Odd number of points Viewport state version mismatch Structure is still open Recursive instance Invalid view plane normal Invalid up vector Invalid hither distance Clip planes reversed Information unavailable Invalid clip zmin Invalid border width Locator outside device limits Locator outside viewport Invalid normal vector Matrix is singular Zero vector invalid Loss of precision Replace element zero index Point outside viewport Invalid window Pick index out of range Element index not found Instance index lookup failure No elements in structure Highlight lookup error Bounding box highlight only Highlight block undefined No highlight defined Using highlight default ablock Pick list empty Pick error Path depth out of range Highlight out of range Instance echo path viewport mismatch Illegal instance path length Illegal pick aperture size Non instance found on path Dynamic mode incompatible element type Dynamic mode path viewport mismatch Dynamic mode already set Dynamic mode not set Dynamic mode null element Dynamic mode edit lock Bitmap attribute block error Mark type invalid Invalid line type Invalid name set Invalid attribute type value Invalid attribute source value Echoing non primitive Graphics Accelerator not present Normal in plane of polygon Invalid shading mode Invalid hidden surface mode Invalid fill style Invalid bsp id Bsp file does not exist Light index out of range Zbuffer not supported on device Illegal in dynamic mode Dynamic mode buffer overflow Unknown tag type Polygon decomposition region count exceeded Polygon decomposition point count exceeded Replaced element not an instance Ptext not allocated No structure assigned to viewport No bsp tree assigned to viewport Non-trivial 4th column in matrix Light source not enabled Wrong light source type Wrong structure type Points are collinear Storage undefined Zbuffer not enabled Insufficient zbuffer memory Internal error with concave polygon Relocation failure Storage mismatch Compactor failure Invalid propagation option 4x4 can't convert to 4x3 Initial structure size too small Initial structure size too large Growth rate is too small Growth rate is too large Growth constant is too small Growth constant is too large NOP size is too small NOP size is too large NOP multiple is too small NOP multiple is too large Invalid font i.d. Font i.d. in use Obsolete procedure   graphics         4     
       /
 ,    color table manager 4 ,R
                     /8 Requested pixel values not available No RWS available Requested pixel value not allocated   graphics         4     
       /
 4    IDM/RM resource manager ,R
                     /8 not an resource ID resource no longer exists wrong resource type non-existent resource null resource ID resource in use, only marked for deletion ?? unused resource manager error code 7 ?? ?? unused resource manager error code 8 ?? bad resource pointer null resource pointer resources index/pointer mismatch attempt to link an already linked resource UETLIB version number mismatch record length mismatch no more RW storage available   graphics  (        4     
       /
 <    rectangle manager  4 ,R
                     /8 not a rectangle ID rectangle no longer exists not a RM ID non-existent rectangle NULL rectangle ID rectangle in use, only marked for deletion   not a group ID group no longer exists not a RM group ID non-existent group NULL group ID group in use, only marked for deletion   rectangle is a root rectangles have different roots invalid rectangle limits WARNING (x,y) not in any sub-rectangle (x,y) not in parent or any rectangle no such rectangle property key null rectangle property key caller supplied array too short rectangle not acquired rectangle not in use rectangle already in group rectangle not in group quit-fault while waiting to acquire operation is inconsistent with attributes rectangles have different parents   /graphics         4     
       /
 D    input demultiplexor 4 ,R
                     /8 not an event processor ID event processor no longer exists wrong IDM resource type non-existent event processor null event processor ID event processor in use, only marked for deletion   not a focal point ID focal point no longer exists wrong IDM resource type non-existent focal point null focal point ID event processor in use, only marked for deletion   not a queue ID queue no longer exists wrong IDM resource type non-existent queue null queue ID queue in use, only marked for deletion   not a binding set ID binding set no longer exists wrong IDM resource type non-existent binding set null binding set ID binnding set in use, only marked for deletion   bad IDM key event processor blocked focal point and rectangle not associated buffer full focal point not active binding set array too short no such logical device bad logical device index wrong logical device type focal point is not a focus event processor not in use focal point not in use queue not in use binding  not in use event bindings are not in global memory   graphics          4     
       /
 L    BitMapFile manager  4 ,R
                     /8 Package not initialized Invalid x size value Invalid y size value Invalid file identifier Too many files open Invalid file length specifier Invalid scanline length Out of bounds access Header size error Procedure is obsolete Package already initialized No zbuffer data area allocated Wrong size zbuffer Improper window size Invalid user data length Invalid offset value Wr                                                                                                                                                                                                                                                   u                         $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          7 "           ong file format No user data allocated File is compressed File is not compressed File format mismatched Color map is not allocated Invalid color map index Too many color map entries Illegal color map entries   graphics          4     
       /
 T    raytracer shell  4 ,R
                     /8 Operation invalid Package not initialized Matrix is singular Zero vector invalid Vectors are dependent Invalid window parameters Invalid view distance value Bitmap already exists Bitmap does not exist Invalid pathname Invalid rectangle parameters Invalid resolution parameters Invalid up-vector value Invalid normal-vector value Invalid bitmap size No object open Object not an aggregate Too many open objects No such object No such attribute Attribute stack overflow No active attribute Save-file overflow Invalid opcode Too many lights   graphics  n       4     
       /
 \    raytracer kernel  4 ,R
                     /8 Operation invalid   graphics          4     
       /
 d    geometry trait   4 ,R
                     /8 Unimplemented trait function Scratchpad memory overflow Degenerate trimming loop Memory management error item not found Trimming loop outside support of knots  graphics  '       4     
       /
 l    display @  4 ,R
                     /8 Node does not have a display  Stream is not associated with a display   RGYC  4        4     
       /
 t    Client  @  4 ,R
                     /8 Entry not found Name already exists Name is too long Incompatible program and file versions No more memory space available Registry is read-only Invalid file, internal error Registry salvage only partially complete No valid registry found at any registry site Name must begin with a lowercase letter Cannot delete reserved name Unable to access registry at any registry site Name contains invalid characters Entry already exists Operation not yet implemented Invalid person identifier Invalid group identifier Invalid organization identifier Invalid node identifier Invalid p.g.o identifier Operation invalid in specified domain New password is too short New password is too long New password cannot be all spaces New password cannot be all alphanumeric Password incorrect Invalid owner   RGYC  4        4     
       /
 |    Login   @  4 ,R
                     /8 Shutting down Exiting insufficient address space password does not check account is invalid or has expired  logins are disabled   	RGYC  4         4     
       /
     Server  @  4 ,R
                     /8 Operation not yet implemented Unix id changed or incorrect Object is an alias Registry server unavailable Person is not a member of specified group Person is not a member of specified org Person is not a member of specified group and org Incomplete account name Not authorized to perform operation  D3M data management    4     
       /
     d3mlib  @  4 ,R
                     /8 database not open dbk for wrong area database already open transaction lock request timed out duplicates error current unknown end of set or area unknown name; not in schema database open read only or update transaction not in effect wrong password no disk space dbk not available/no good unused no current of this record type set has no optional members record is  already member violation of concatenated set integrity unused unused current of rec wrong type current of rununit of wrong type record not member in set record not in area unused unused no record satisfies record selection unused area already open area not open delete set not empty internal stack overflow invalid literal argument invalid argument unused operation cannot be performed within transaction unused unused unused fatal D3MLIB error findv requires sorted set findc requires calced record record not indexed unused improper set mode set, record, etc. not in subschema unused unused unused unused unused deleted rec referenced key relation mismatch HLDML call error HLDML syntax error HLDML semantic error HLDML execution error from D3MLIB unexpected HLDML execution error HLDML internal error unused unused close error name not found file not found required resources not available end of file wrong object type unable to open unused database must be recovered (use RCVRDB) loc mode select required in all sets too many sets in path multischema inconsistency distributed DML operation not supported dynamic store error violation of distributed set integrity unused unused unused unused unused transaction call err active transaction required unused unused unused unused D3MLIB error unused schema/subschema confusion recompile schema read error on (sub)schema file (sub)schema file open err database write error database read error concurrency violation device unavailable unused must preallocate file (use INDB) bad bucket address                                                                                                                                                              lock table overflow insufficient virtual memory user needs to be salvaged (consult D3MUTL) no D3M server running at database node internal fatal D3M error.  Please examine `node_data/system_logs/d3m_error_log bad D3M_$dbrcvr call database areas not found journal files not found journalling for recovery not enabled database in use subschema used for recovery does not include all areas file is not an area no access rights insufficient access rights network communications problem object does not have D3M subsystem seal (use D3MUTL) unable to seal object - /sys/d3m/d3m_u2 not found unable to seal object - /sys/d3m/d3m_u2 not a D3M subsystem manager too many users of database or databases on same node control tables have been corrupted - restart D3M server D3M server version is incompatible with the installed D3M library salvage operation is potentially unsafe client not found client is marked for salvaging client is not marked for salvaging salvage operation is in progress no mbx_helper on the server node and could not start one                                                                                                                D3M internal signal (ignore it) non-local goto to DML entry point D3M lock manager file is not the expected version message reply timeout send message timeout multi-page message reply error    UNIX  4         4     
       /
     signal  @  4 ,R
                     /8 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault     UNIX  4        4     
       /
     child unconditional suspend signal                  /8      UNIX  4 b        4     
       /
     child continue signal  ,R
                     /8      UNIX  4         4     
       /
     child death signal  4 ,R
                     /8      UNIX  4 l       4     
       /
     ptrace signal   4 ,R
                     /8      UNIX  4        4     
       /
     child keyboard suspend signal                     /8      UNIX  4 v        4     
       /
 ı    child background read suspend signal                 /8      UNIX  4         4     
       /
 ̱    child background write suspend signal                /8    	UNIX  4        4     
       /
 Ա    sys5 ipc @  4 ,R
                     /8                                                                                                                                                                                                                                                    v                        }X< $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                                      not holding db lock undefined already holding db lock bad free of msq space bad lock request no access ipc object not found no space for descr ipc object already exists   UNIX  4         4     
       /
 ܱ    longjmp @  4 ,R
                     /8 internal longjmp status longjmp status   UNIX  4 X       4     
       /
     file utilities   4 ,R
                     /8 incorrect version number directory created soft link created     UNIX  4         4     
       /
     errno status   4 ,R
                     /8  UNIX  4         4     
       /
     file I/O @  4 ,R
                     /8 unknown type   UNIX  4 /       4     
       /
     device number   4 ,R
                     /8 entry not found table full entry in use   =store and forward manager      
       /
     lib   @  4 ,R
                     /8 unrecognized option invalid site name invalid queue name missing site flag in routing file missing site name in routine file unknown keyword in routing file missing queue name or gateway info in routing file site name not found in routing file invalid message length requested route unavailable invalid queue size invalid queue delete request queue is empty queue is full bad route syntax no further hops in route route entry too long invalid queue release request queue entry already locked bad queue lock request (msg_id mismatch) server not registered a server is already registered message received this hop is last in route route length less than or equal to 0 queue name length less than 0 hop will not fit in route field routing file unavailable    queue already exists bad pathname for queue queue not found bad queue directory no rights to queue insufficient rights to queue message added to local queue  queue control file already exists bad pathname for queue control file queue control file not found bad queue control file directory no rights to queue control file insufficient rights to queue control file   message already exists bad pathname for message message not found bad message directory no rights to message insufficient rights to message   object already exists bad pathname for object object not found bad object directory no rights to object insufficient rights to object   store and forward manager      
       /
     sf_helper @  4 ,R
                     /8 bad delay specification   netman  4 q        4     
       /
     netman  @  4 ,R
                     /8 unknown service request type   netman  4        4     
       /
     boot   @  4 ,R
                     /8 node not in diskless list requested file has wrong machine id unknown boot service request kind wrong type uid invalid page range in boot service request error encountered in netman.rc   netman  4 O        4     
       /
 $    dump   @  4 ,R
                     /8 dump already in progress from another node dump not open page/close request received from wrong node dump too large for dump file unknown dump service request kind dump timed out waiting for next page   X.25  4        4     
       /
 ,    device driver   4 ,R
                     /8 controller does not exist controller unit number out of range bad buffer pointer bad buffer length invalid device control operation argument invalid eventcount key bad command buffer length invalid download operation argument download address is out of range download checksum failure no data in device output mailbox data from device truncated device set invalid data length device failed to respond device does not operate properly invalid format for download file header   X.25  4        4     
       /
 4    gateway server   4 ,R
                     /8 invalid server request type invalid X.25 packet type permanent virtual circuit lcn is out of range permanent virtual circuit in use permanent virtual circuit lcn is not a permanent vc channel is  not a switched virtual circuit virtual circuit already open on this channel virtual circuit is not open on this channel an offer is already pending on this channel no more switched virtual circuits available invalid IOCTL request   X.25  4 (        4     
       /
 <    library @  4 ,R
                     /8 invalid "sysnames" file format X.25 system name not found in "sysnames" file X.25 address not found in "sysnames" file packet buffer too small invalid X.25 packet header invalid X.25 source address invalid X.25 source address length invalid X.25 destination address invalid X.25 destination address length invalid X.25 call request facilities field invalid X.25 call request facilities length invalid X.25 call request user data length X.25 call request cleared X.25 protocol error unexpected reply from gateway server buffer is too large invalid call request data format option no X.25 receive data no room for X.25 transmit data X.25 call request not valid now or has bad format   X.25  4 U       4     
       /
 D    emulate terminal  4 ,R
                     /8 unknown X.3 parameter invalid value for X.3 parameter   X.25  4         4     
       /
 L    file transfer   4 ,R
                     /8 incorrect operation of protocol unexpected reply from file server file buffer to large for packet amount of data sent exceeds size of target file could not rename target file target file already exists end of file encountered bad file name bad command line transmitted to file server wild card translation resulted in no names all translated wild card names delivered wild card name store full in file server clear packet received from x.25 unexpected reply from x.25 packet to small to transmit command line blank or null command line error in command line translation (file server) disagreement on buffer sizes for file xfer check sum error on file xfer remote domain x.25 file server not running remote domain x.25 host not available connection cleared in idle state file transfer aborted protocol error - x.25 reset packet received protocol error - x.25 interrupt packet received protocol error - x.25 diagnostic packet received procotol error detected by server   TCP/IP  4 Z        4     
       /
 T    gateway server   4 ,R
                     /8 status available (not an error) network not available too many connections no free network buffers bad net open mode bad local address, port, link, or protocol destination dead raw message send failed read or write on closed connection destination refused destination unreachable destination not responding (timeout) end of file (foreign peer closed) invalid request unknown error   TCP/IP  4 [        4     
       /
 \    library @  4 ,R
                     /8 unexpected reply from server no data available no room for data bad ec key TCP/IP server is not running cannot get space for handle control mailbox not found data mailbox not found no more connections possible illegal TCP/IP handle operation attempted on unopened connection   	DOMAIN Dia            gnostics     4     
       /
 d    Final Acceptance Test  ,R
                     /8 Test run aborted Error reported by remote process All test processes have terminated Remote process is hung or unexpectedly awaiting data Controlled channel timed-out or is hung Unexpected or out-of-sequence response from controlled process Configuration Verifier failed Network failure or net error limit exceeded Unable to invoke program via SPM   
VT100 emulator       4     
       /
 l    library @  4 ,R
                     /8 unrecognized option bad ec key end of file window is too small stream is not connected to a VT100 emulator no more resources available already initialized import failed no pty no server   socket manager       4     
       /
 t    manager @  4 ,R
                     /8 bad ec key address family not supported socket is not connected no data available end of file object on this                                                                                                                                                                                                                                   w                        nM $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          D "            stream is not a socket destination address required message too large protocol type is wrong for this socket protocol not supported socket type not supported operation not supported protocol familly not supported requested address already in use requested address not available socket is already connected message will not fit insufficient resources to create socket export/import buffer too small cannot send after socket shutdown no completed connections invalid request connection reset by peer no readers on socket connection refused by peer   socket manager       4     
       /
 |    error   @  4 ,R
                     /8 socket buffer too large socket buffer too small bad numeric name cannot find name cannot convert address to name cannot get local name cannot create socket cannot get interface configuration internal error family not valid invalid name format invalid socket length   	pty manager        4     
       /
     manager @  4 ,R
                     /8 illegal operation no data available no active slaves no active controllers controller already has pty open bad ec key object on stream is not a pty end of file not enough room for data  
dialog  4         4     
       /
     interaction manager 4 ,R
                     /8 Warning: ENUM has no choices Warning: task is in error Warning: unable to load default font file Warning: unable to load font file Warning: verification key mismatch  Library not compatible with interface description Dialog not initialized Nested event wait Invalid task identifier Wrong task type for operation Window refresh in progress Value out of range Invalid file type Dialog already initialized Invalid interface (dpd) identifier No tasks are accessible by the user Number of choices exceeds internal limits Bad heap format or reuse of heap   object based systems    4     
       /
     trait manager   4 ,R
                     /8 too many trait declarations no available rws storage unsupported trait pm level too high mark/release broken trait not supported for local objects trait not supported for near remote objects trait not supported for wicked far-away objects   object based systems    4     
       /
     type manager   4 ,R
                     /8 type not found type manager for type not found type already exists type manager already exists types file not found type manager directory not found types file has invalid format volume for the object is not mounted un-named trait trait name is already in use type does not have trait-specific managers types file needs reformatting to use split traits types file has later version (not reformatted) duplicate UID   DOMAIN/RDMS +       4     
       /
     gdslib  @  4 ,R
                     /8 unused   Communications Gateway  4     
       /
     CMP   @  4 ,R
                     /8 no controller attached invalid unit number bad buffer pointer bad buffer length invalid control operation attempted bad event count key bad command length invalid download operation invalid download address bad checksum no data currently available data truncated bad device data length controller timed out controller error cmp already initialized timed out out of address space event not for you your application may not perform a reset channel in use process is not yours invalid call cmp not yet initialized error deallocating space tried to re-download controller (with same file) tried to re-download controller (with different file) board process is dead. No sends allowed.   Communications Gateway  4     
       /
     comm_driver @  4 ,R
                     /8 no controller attached bad unit number bad process number bad buffer length invalid control operation was attempted invalid event count key board has dumped memory invalid download operation bad download address bad checksum no data currently available error mapping multibus memory no iopb available controller timed out controller error non-fatal process error board process experienced a fatal error controller experienced a fatal error  Communications Gateway  4     
       /
     Serial Controller  4 ,R
                     /8 controller is not installed invalid device number invalid logical unit number invalid channel number invalid device type -- NULL is not allowed invalid device type -- type string is too long invalid unit -- not initialized channel is not open to any process channel type is not as requested channel is in use channel is already open channel is already closed another process reserved access for too long incoming data checksum failure no resources available on this channel no received data available on this channel operation failed in an unspecified way serial controller is not responding download failed download module is too large (limit is 64K bytes) download resource was in use for too long a time buffer is too long                                                                                                                                                                                                                                          SCAT Power-Up Tests Passed EPROM 0 Memory Checksum Test failed EPROM 1 Memory Checksum Test failed DRAM MEMORY Stack Test failed DRAM MEMORY March Test failed DRAM MEMORY Ripple/Page Test failed 80186 PIC Internal Test failed 80186 PIT Internal Test failed 80186 DMA Internal Test failed 8259 INTERRUPT Controller Test failed 8254 Programmable Timer Test failed 8237 DMA Controller  0 Test failed 8237 DMA Controller  1 Test failed 8530 SCC  0 (Channel 1&2) Test failed 8530 SCC  1 (Channel 3&4) Test failed SCAT Power-Up Initializations failed Serial Ch 1 Loopback Test failed Serial Ch 2 Loopback Test failed SCAT Illegal Power-On Status Code   SNA  4        4     
       /
 Ĳ    api3770 @  4 ,R
                     /8 bad handle UIM channel closed no gateway name server file bad name server file length name server file access error UIM open error UIM invoke error UIM mbx not open error opening UIM client channel channel eventcount error error closing UIM client channel no UIM response unknown read type error getting response from channel no room in UIM channel request too big error writing to UIM channel   %SNA  4        4     
       /
 ̲    uim3770 @  4 ,R
                     /8 reserved timed out waiting for gateway reply gateway closed channel unexpectedly request ignored in this context request too long ambiguous request unknown request invalid request unless gateway opened need manager privileges unexpected non-digit found unknown request argument excess request arguments incomplete request argument duplicate request argument invalid request unless gateway powered on invalid request unless gateway enabled request not allowed in script bad name server record name server pathname unknown gateway channel already opened submit pathnames too long submitted null transparent file pathname no internal heap space priority number required reader number required gateway queue full reader unknown too many files submitted job number required host job number required request requires a host window host job number is too long no job queued with that job number job already assigned to a reader error deleting job from queue no privileges to cancel job pathname required   SNA  4 ]        4     
       /
 Բ    qm3770  @  4 ,R
                     /8 error getting config arg error opening config file error getting config record UIM mbx pathname required in config error parsing config record error creating server mailbox error closing config file error getting UIM eventcount error getting timer eventcount duplicate mbx param duplicate error log param error opening error log file mbx pathname arg required error reading from mbx   _SNA  4 `        4     
       /
 ܲ    api_3270 @  4 ,R
                     /8 no result invalid length sna_$open() was already called Cannot open configuration file Cannot close configuration file Cannot find LU number and mbx pathname Configuration data not found No reads or writes allowed until sna_$open succeeds Key entered is not defined or allowed bad buf                                                                                                                                                                                                                                                   x                        hI $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                           "           fer length  server process does not exist no more channels available channel unexpectedly closed message too big invalid mbx name cannot connect to the controller emulation invalid message from server process                                              Translation table not initialized Translation type was not ascii_to_ebcdic or ebcdic_to_ascii Not at end of keyboard sequence (ASC_TO_EB) Not a CECP message Invalid CECP type Invalid PU Id according to CE Invalid LU Id according to CE PU is in down state, i.e., no PuCb    PU is already open LU already opened Invalid CeCpKindOfData PU is already configured/created LU is already configured/created Bad command in cecpdata cmd byte Insufficient CE resources PU is not open LU is not open no data/status available LU is currently in DISCONnect mode          CECP protocol violation   	access  4 C       4     
       /
     typemanager @  4 ,R
                     /8 internal fatal error - pending data requests data cache corruption detected invalid type gateway file format bad change attributes - could not close file change attributes failed could not reopen file after attribute change seek key cache corruption detected fatal error (DOMAIN)   access  4         4     
       /
     vms server @  4 ,R
                     /8 process on host died no such program no such version fatal error (VMS) bad procedure value invalid arguement bad state detected (VMS) protocol error (VMS) insufficient memory (VMS) file specification syntax error  (VMS) Bad or inappropriate device for operation  (VMS) Error in directory name  (VMS) Logical name error (VMS) Error in quoted string (VMS) Error in file type (VMS)   access  4         4     
       /
     apollo presentation 4 ,R
                     /8 host destination refused host not responding msg send timeout msg receive timeout connection closed by host connection acknowledge timeout connect timeout message too long unknown message type unexpected extra data unexpected msg type on connection acknowledge string too long   access  4 w        4     
       /
     vms presentation  4 ,R
                     /8 login failed (VMS)   access  4        4     
       /
     protocol @  4 ,R
                     /8 loopback failure protocol error (DOMAIN) bad state detected (DOMAIN)   
DSEE  4        4     
       /
     dseelib @  4 ,R
                     /8 name not found no rights or insufficient rights operation failed unable to parse command string invalid argument network problem internal error detected unable to enter DSEE recursively dseelib session not initialized object already exists bad pathname pathname too long for DSEE pathname component too long for DSEE   $DSEE  4        4     
       /
     History Manager  4 ,R
                     /8 database is in use by someone else database recovery is required database must be reformatted database contains no schema no D3M server or MBX_HELPER at database node too many clients of D3M server at database node no D3M subsystem seal on database schema or area D3M subsystem installed on node is broken database schema format is obsolete or too new incompatible D3M server at database node database user must be recovered database contains no areas invalid database handle invalid element name element already exists unable to access source file library recovery is required element not found branch already exists version not found unable to create target file line of descent not found line of descent is reserved line of descent merged or obsolete line of descent not reserved line of descent not obsolete delete version range on two lines of descent unable to delete only version on line of descent no versions qualified for deletion versions defining range to be deleted must exist unable to delete main line of descent unable to validate library invalid or nonexistant element id invalid or nonexistant branch id no library is currently set library is not open for reading   DSEE  4         4     
       /
     Streams Manager  4 ,R
                     /8 DSEE version map corrupted more than one branch has the specified name DSEE library recovery is required attempt to open an undeclared element   DSEE  4        4     
       /
 $    Configuration Manager  ,R
                     /8 invalid model handle component set sizes are not the same invalid component set size specified invalid component identifier specified the component is not a buildable component the release area pathname already exists invalid component specifier no component as specified specified component is not unique unable to locate the build some components were not exported error encountered in archiving sources used in build error encountered in archiving the system model used in build no model is currently set no system is currently set unable to validate the system model unable to validate the thread unable to set the thread as current specified pathname is not a system area working context was not created under system no thread is currently set no derived objects associated with this build thread does not specify a version unable to construct the translate rule unable to determine the version to use unable to insert BCT or derived objects into pool file was modified during the build unable to set builder node invalid pool identifier specified invalid library identifier specified   Hyperchannel         4     
       /
 ,    driver  @  4 ,R
                     /8 no controller controller not responding to function request i/o error controller interrupted with no status available bad key passed in call bad size passed in call send failed due to incoming message associated data too large send or receive invalid in this context no messages available for input input parity error transmit failed receiver busy transmitter busy no associated data supplied by sender reply failed adapter message buffer full watchdog timer expired; port reset input message(s) lost due to host delay   Debug  4        4     
       /
 4    %Main   @  4 ,R
                     /8 operation not supported user error internal error   Debug  4        4     
       /
 <    Main Debugger   4 ,R
                     /8 internal error unable to communicate with user interface   Debug  4         4     
       /
 D    mapping utilities  4 ,R
                     /8 file is not an apollo coff object module invalid object module version invalid handle invalid component type invalid section number address is not in a mapped section   Debug  4        4     
       /
 L    symbol table access 4 ,R
                     /8 obsolete symbol table version can't allocate storage .blocks section not found invalid code segment number   Debug  4         4     
       /
 T    User Interface   4 ,R
                     /8 internal error unable to communicate with main debugger bad command syntax   Debug  4 z       4     
       /
 \    Quit Manager   4 ,R
                     /8 User Interrupt Detected   Debug  4         4     
       /
 d    cross process stack info R
                     /8 task not found operation illegal for current process operation illegal for specified register specified register value is unavailable can't allocate storage   Debug  4 7       4     
       /
 l    cross process task info ,R
                     /8 tasking not enabled task not found   Debug  4        4     
       /
 t    cross process traceback ,R
                     /8 end of stack invalid handle invalid frame number can't allocate storage requested information not available no process context set no frame context set unknown object module version obsolete symbol table version operation invalid cross-process no fault information available  LU6.2  4 u       4     
       /
 |    Verb Usage @  4 ,R
                     /8 program                                                                                                                                                                                                                                                   y                        VO $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                          )] "            not attached duplicate attach attempted invalid convid (rsrc unknown)      null struc parm passed attach,rattach: path required attach: (LU) name required attach: type invalid attach: LU unknown attach: LU not available attach: tpn not configured attach,rattach: cfile unauthorized rattach: cnvid required rattach: invalid cnvid for rattach attach, rattach : invalid wait time attach: not enough space attach: process limit reached         alcnv: rlu required alcnv: mode required alcnv: tpn required alcnv: rlu unknown alcnv: mode unknown alcnv: type invalid alcnv: mapped conv n/a alcnv: basic conv n/a alcnv: when invalid alcnv: delayed alc n/a alcnv: immediate alc n/a alcnv: sync invalid alcnv: sync 1 n/a alcnv: PIP n/a alcnv: PIP maxsize exceeded alcnv: sec invalid alcnv: requested security n/a alcnv: bad user format alcnv: bad pass format            cnfrm,cnfrmd: bad sync-level          dalcnv: type invalid          prprcv: type invalid prprcv: lock invalid         rcvwt,pstrct: fill invalid negative length is invalid         snddta: invalid LL snddta: invalid LL - PS hdr         snderr: type invalid snderr: SE_ALC reserved for tpi snderr, dalcnv: error log n/a        waitcv: count <0 invalid waitcv: invalid cnvid on list waitcv: listed cnv not posting waitcv: no posting conversations waitcv: list required with count waitcv: list too large                                                                                                                                                                               not authorized to CNOS verb Limits Requested in CNOS verb invalid Srv Mgr Mode not initialized before CNOS verb        session limit of 0 is not valid invalid value for responsible parameter c_maxs must be greater than c_minf + c_minb        invalid session identifier                                                                                NO - name too long NO - line required NO - lu required NO - pu required NO actsta - invalid dial      NO - rspque must be NULL                                                                                                                                                                                                                                                                                                                                                                                                                                                        schd is not active          schd has crashed          Time out - Request not recovered          Time out - Request recovered          Time out - Msgq full          logic error - sent to VI by PS Duplicate TPI   LU6.2  4 b        4     
       /
     Basic Conversation State R
                     /8 Conversation State error Logical Record state error conv for waitcv not S2_RECV   LU6.2  4 6       4     
       /
     Basic Conversation Allocation                     /8 TP not available - no retry TP not available - retry Conversation type mismatch PIP data not supported Error in PIP specification Error in Security Information Program does not support sync TP not recognized Allocation Failure - no retry Allocation Failure - Retry session not immediately available local resource allocation failure cannot authorize security access         allocation rejected by RM   
LU6.2  4 J       4     
       /
     Basic Conversation Program                      /8 Program Error - No Truncation Program Error - LL Truncated Program Error - Purging        Service Error - No truncation Service Error - LL Truncated Service Error - Purging    LU6.2  4 {        4     
       /
     Basic Conversation Deallocated                     /8 Deallocate - Normal Deallocate - Abend Program Deallocate - Abend Service Deallcoate - Abend Timer Resource Failure  ? VLU6.2  4 s       4     
       /
     Control Operator Verb  ,R
                     /8 Limits are not zero Requested limits exceed configuration Minimums exceed max. session Invalid SNASVCMG limits SNASVCMG mode not initialized Mode limits are closed CHGSL not valid SNASVCMG mode cannot be reset CNOS race at remote - they won Partner does not recognise mode CNOS is in process locally CNOS allocation error CNOS resource failure Session activation resource failure          CNOS function terminated abnormally   LU6.2  4        4     
       /
     Node Operator Verb  4 ,R
                     /8 NO verb failure node operator verb not recognized attach of type AT_NODE       link name not recognized adjacent link station not recognized physical unit not recognized earlier request still active dial in or dial out required logical unit name not recognized message queue name not recognized message queue not enabled no message in message queue                                                                                  actpu failure          actlu failure          dctpu failure          dctlu failure          chgmsgq failure          dspmsgq failure                                        rtvnmsg failure     LU6.2  4    	     4     
       /
     Configuration Error 4 ,R
                     /8    NCA  4   	     4     
       /
     Network Computing System R
                     /8 Integer Divide By Zero Address Error Floating Point Divide By Zero Floating Point Underflow Floating Point Overflow Invalid Tag Invalid Bounds/Array Overflow  NCA  4 5   
     4     
       /
 ĳ    RPC runtime @  4 ,R
                     /8 CHECK_SOCKETS_FAULT QUIT_ACTIVITY_FAULT  communications failure invalid operation number in call unknown interface can't create socket can't bind socket client passed server wrong server boot time too many interfaces defined activity is not doing an RPC now you crashed [a restarted server called back a client]  no port specified in sockaddr or interface specification internal protocol error too many sockets allocated [server] invalid interface re-register can't recv in listen_recv bad packet no location/binding in handle address/port in use input args too big  output args too big server is too busy to handle call string parameter longer than declared max len tried to register too many objects  Bogus handle  Client isnt authenticated   Invalid authentication type  Can't malloc memory Can't allocate near heap storage   NCA  4        4     
       /
 ̳    locating broker  4 ,R
                     /8 database format out of date database in use in an incompatible manner no matching entry available unable to complete registration operation can't access database can't reach location server bad entry   0NCA  4 @       4     
       /
 Գ    DRM   @  4 ,R
                     /8 incorrect software or database version resource locked resource not available data file full propagation file full replica unconfigured replica uninitialized replica deleted replica closed replica reset program error replica already exists replica not found too many replicas bad replica address bad remote replica state earlier timestamp clocks skewed no such entry entry not found entry already exists bad entry length bad entry bad record number object already open too many objects opened object not open bad argument create failed file io error too many keys object already exists bad protocol family               no default replica specified   NCA  4 M        4     
       /
 ܳ    Registry Server  4 ,R
                     /8 Operation not yet implemented Operation not supported on specified domain Entry already exists Name already exists Unix id changed or incorrect Entry is an alias No more matching entries Entry not found Registry server unavailable Person is not a member of specified group Person is not a member of specified org Person is not a member of specified group and org Incomplete account name Password incorrect User not authorized to perform operation Registry is read only or operation performed at a slave PGO alias entry has invalid owner Invalid data - record too long   NCA  4 	       4     
       /
     Registry Server Replication                     /8 Program error Invalid database version Unable to create database Unable to open database Unable to read database Un                                                                                                                                                                                                                                                   z                        Y $      RCP011.B                         E9  [B]RPC$STCODE.DAT;2                                                                                                                                                      able to save database Unable to rename database Master registry site not found Registry site is the master Registry site is a slave Update is not from master Replica is in a bad state Replica name is unavailable Replica has bad address Replica is in the deleted state Database is locked Clocks are skewed Update arrived out of sequence Initialization partner unavailable   NCA  4 s       4     
       /
     RPROC   @  4 ,R
                     /8 Can't run specified program Can't create a new process for program Server internal error Too many arguments specified Server won't create a process Server can't change identity of new process   NCA  4         4     
       /
     Kerberos @  4 ,R
                     /8 Principal expired Service expired Authentication expired Unknown protocol version number Principal: Incorrect master key version Service: Incorrect master key version Bad byte order Principal unknown Principal not unique Principal has null key          Permission Denied Can't read ticket file Can't find ticket    Ticket granting ticket expired     Can't decode authenticator Ticket expired Ticket issue date too far in the future Repeat request Ticket for wrong server Request inconsistent Time is out of bounds Incorrect network address Protocol version mismatch Illegal message type Message integrity error Message duplicate or out of order Unauthorized request        Current password is NULL Current password incorrect  Protocol error  Error returned by KDC Null ticket returned by KDC Retry count exceeded Can't send request    Warning: Not ALL tickets returned Password incorrect Protocol error       Generic error  Don't have ticket granting ticket      No ticket file  Can't access ticket file Can't lock ticket file; try later Bad ticket file format Read ticket file before tf_init Bad Kerberos name format                                                                                                                                                                              Generic kerberos error   NCA  4 ]        4     
       /
     Authentication   4 ,R
                     /8 Intruder alert Non-IP address families not supported, sorry Authentication is of wrong type Encryption key is weak Encryption Key parity error   NCA  4 p       4     
       /
     Location Broker Entry Cache Manager                 /8 Location entry not found Entry handle is no longer valid No more room in cache for entry No servers found Latency period has not expired No socket families found   
NCA  4         4     
       /
     data access manager 4 ,R
                     /8 invalid key count  invalid record length invalid key length memory allocation failed record not found invalid key number no more entries internal error invalid handle record already exists   
NCA  4        4     
       /
     data store manager  4 ,R
                     /8 could not create database file file I/O error could not open database file incompatible format version memory allocation failed attempt to write same block twice specified header size too large no more entries invalid handle invalid pointer    network license server  4     
       /
     server  @  4 ,R
                     /8 License not found in database NLS license not found in database Past expiration date on license Past expiration date on NLS license Before start date on license Before start date on NLS license Version not found in database NLS license version not found in database Not enough licenses Not enough NLS licenses Not authorized to use product Wait entry deleted Bad I/O Other users are waiting No licenses available No NLS licenses available Still waiting for a license Transaction id did not match Transaction id did not match in nlslib_check Time disparity too large Vendor id not in database Duplicate vendor id Duplicate product record for this vendor No such product for this vendor Could not delete vendor - still has products Database not valid for this server No such vendor Database corrupt Warning: product name changed Vendor "Apollo" can not be deleted Fatal error - check error log Vendor key is incorrect   	network license server  4     
       /
 $    library @  4 ,R
                     /8 nlslib not initialized Not waiting in any queue Not bound to any server Vendor key is incorrect No matching socket families found No servers available for this vendor  Vendor id is invalid Bad parameter Job id is invalid   network license server  4     
       /
 ,    tools   @  4 ,R
                     /8 Password version or vendor incorrect Password contains invalid characters Incorrect target in password Invalid password - old version Internal error  
tape manager        4     
       /
 4    manager @  4 ,R
                     /8 Warning: Drive status has changed Warning: Marginal media detected by device  Non-recoverable parity error Cannot find phyisical tape record Media error detected Tape drive is offline Tape drive device error Tape drive or controller is not ready Tape record too large for buffer, data lost Tape drive timeout Remote tape network error Operation not supported by device or controller   window systems       4     
       /
 <    Apollo  @  4 ,R
                     /8 display unit number out of range   display screen number out of range         display screen already inited display screen is not a root rectangle time out waiting primary window system server                                                                                                                                                                                                                                          * [B]RPC$STCODE.EXE;2 +  ,    .     /    4                             - E9   0   1    2   3      K  P   W   O     5   6 Ε  7 0PΕ  8          9          G   H  J                             0 D X     0205      (  | N     \ h h                                
RPC$STCODE                             RPC V1.1       | Ε 05-05                        !        &      "    
 (        2      $    z 4      &        
       ?          !        VAXCRTL_001      !        
LIBRTL_001 O    !       
MTHRTL_001  (stcode) usage: stcode <hex status code>
 %lx (stcode) "%s" does not appear to be a valid hex status code
 %s
  rpc$exe:rpc$stcode.dat status %lx status %lx (%s) status %lx (%s/%s) %s (%s/%s) (rpc) *** FATAL ERROR "%s" at %s\%d ***
 _REQUEST_ client -> server _PING_ client -> server _RESPONSE_ server -> client ** FAULT ** server -> client _WORKING_ server -> client _NOCALL_ server -> client ** REJECT ** server -> client _ACK_ client -> server _QUIT_ client -> server _FACK_ client <-> server _QUACK_ server -> client BOGUS PACKET TYPE %s(rpc_$recvfrom) recvfrom failed ??? 
 %s(rpc_$recvfrom) recvfrom failed ??? 
 (rpc_$recvfrom) recvfrom failed %sCan't convert socket to name.. st.all = 0x%X
 
RECV DATA FROM:  %s, port[%d]
 %s(rpc_$recvfrom) Didn't get anything from the recvfrom call.. recv_len = %d
 %s(rpc_$unpack_hdr) Bad RPC version (%u)
 %s(rpc_$unpack_hdr) Bad pkt type (%d)
 %s(rpc_$unpack_hdr) Time is: %D
	NO PACKET DATA:recv_len = %D
 +------------------------------------------+
 %s(rpc_$unpack_hdr) Packet too short; is %u, data len is %u
 %sCan't convert socket to name.. st.all = 0x%X
 
SENDING TO:  %s, port[%d]
 (rpc_$sendto) sendto(2) failed ?? pkt->refcnt > 0 RPC$:[NCK_D.LIBNCK_D]RPC_UTIL.C;1 ..ALARM CLOCK..
 ..LEAVING ALARM CLOCK..
 n_tasks < MAX_TASKS RPC$:[NCK_D.LIBNCK_D]RPC_UTIL.C;1 %s%s
 	# of remote calls out:	%lu
 	# of remote calls in:	%lu
 	# of pkts sent:	%lu
 		%s	%lu
 	# of pkts rcvd:	%lu
 		%s	%lu
 	# of frag resends:	%lu
 	# of dup frags rcvd:	%lu
 %D  +---[ *Start%sPkt Header* PKTS RCVD:                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   {                        _` $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                          ) "            %ld, PKTS SENT: %ld, OLD PKTS RCVD: %ld ]---+
 Pings Sent: %D, Pings Rcvd: %D
 RPC  Vsn: %d
 Pkt Type: %d (%s)
 Flags: 0x%x   NULL
 Flags: 0x%x  Defs:
 Flags2: 0x%x   Object    UUID: %s
 Interface UUID: %s
 Activity  UUID: %s
 Server  Boot Time: %ld
 Interface Version: %ld
 Packet SEQ #: %ld
 My  SEQ # Is: %ld
 Operation  #: %d
 Interface Hint: == NO_HINT
 Interface Hint: %d
 Activity  Hint: == NO_HINT
 Activity  Hint: %d
 Fragment #: %d
 Pkt Body: %D.  bytes
 NULL Pkt body..
 rpc_$fault Code: 0x%08X, %ld.
 rpc_$reject Code: 0x%08X, %ld.
 Pings Sent: %D, Pings Rcvd: %D
 %D  +---[   *End%sPkt Header* PKTS RCVD: %ld, PKTS SENT:%ld, OLD PKTS RCVD: %ld ]---+

 	(Client -> Server) Packet was forwarded
 	(Client <-> Server)  Packet is the last fragment
 	(Client <-> Server)  Packet is a fragment
 	(Client <-> Server)  Don't send a FACK for this FRAG
 	(Client -> Server) `MAYBE' request
 	(Client -> Server) `IDEMPOTENT' request
 	(Client -> Server) `BROADCAST' request
 	(Client -> Server) out's can be BLASTED !
 NULL
 (Client -> Server) Packet forwarded in two pieces.
	Intra-machine function only ! [never over wire]
 <<< eh ??  FLAGS2 HAS RESERVED BIT FIELDS SET ??
 %s(rpc_$dump_raw_pkt) Time is: %D
	NO PACKET DATA !len = %d
 +------------------------------------------+
 +------[ START raw data for packet seq# %ld ]---------+
 
 %04x:    %02x  
+------[ END raw data for packet seq# %ld ]---------+
  dds ip ns unspec unspec ip ns dds %s:#%s %s:%s %s:#%s   sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat %08lx%04x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x %8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx    (socket_inet/set interface broadcast address):  NA ERROR %*.s[%lu] %s%sgave out socket index %d from pool
 Ran out of sockets RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%smaking a new socket. None left in pool.
 %s%ssocket() got sock #: %d
 %s%sCan't create socket, errno=%d
 rpc_client.c %s%sCan't bind socket #%d, errno=%d
 %s%si = %d, nsockets = %d.
	Marking this socket in use..
 %s(free_socket) set sock->inuse = false. sock # was: %d
 %s%s
 %s(send_pkt) cannot enable broadcast, status = %08lx
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 rpc_client.c %s(send_pkt) cannot enable broadcast, errno=%d
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(c_recv_pkt) Rcvd callback (ptype=%s)
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(c_recv_pkt) This packet IS NOT for my activity ??
 
%s(c_recv_pkt) IGNORING OLD PKT..  pkt->hdr.seq #: %d, current seq #: %d, old_pkts_rcvd: %ld

 %s(c_recv_pkt) Rcvd packet with bad seq (should be %lu, is %lu; ptype=%s)
 Can't register call RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 
%swho_are_you says you crashed..

 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(ack_replies) Acking [%s, %lu]
 rpc_client.c %s(ack_replies) Can't send ACK, errno = %d
 RPC reply acknowledger %s%s
 %s%s
 %s%s
 %s%s
 %s%s
 
BAD TIMEOUT !! = %d  || end_time ? = %D  forcing to 5..
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s(await_reply) case 0 timeout..
 %s(await_reply) select failure .. errno = %d
 rpc_client.c %s(await_reply) select returned junk, errno=%d
 "rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
 mispacked header stuff messed up RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 
%s%ssees NO COOKIE !?

 %s%sRaising comm_failure. We have no family ?
 %s%sSignaling args_too_big !.. ilen = %d, rpc_$max_body_size = %d
 %s%ssockaddr has specified port..
 %s%sinterface has no specified port.
	Setting to well known port..
 %s%ssetting port to interface defined port
 RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%s
 %s%scan't get encr, status=%08lx
 %s%sRequest Count:  %D
 %s%sRAISING COMM_FAILURE !!  Request_count > MAX_REQUESTS
	request_count = %d, MAX_REQUESTS %d
 %serror sending !large_in pkt..
 %sError sending frag pkt..
 ! recv_pkt .. request_count = %d, wait_count = %d
 %s%sforcing wait_time of %D to 64..
 %s ?? GOT rpc_$fault || rpc_$reject..
 %s%sAnomolous response to request (ptype=%s)
 %s%sawait_timeout detected..
 %s%sraising comm_failure because of an await_timeout on broadcast..
	We've retried MAX_BROADCASTS times..
 %sawait timeout whilst sending_frags.. request_count = %d
 %s%sStarting to ping...
 %s%sawait select failure
 rpc_client: select failed RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%sawait unknown error occured..
 rpc_client.c select failed RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%sRAISING COMM_FAILURE --> TOO MANY PINGS !!
 %s%ssleeping.. now = %ld
 %s%sawake !!   now = %ld
 %s%spwait_time = %D, ping_count = %d, total pings = %D
 %s%strying to raise comm_failure.. pfm_$fault_inh_count = %d
 %s got rpc_$fault || rpc_$reject whilst pinging.. request_count = %d
 %s%sAnomolous response to ping (ptype=%s)
 %s%sawait_timeout.. going to SEND_PING
 select failed RPC$:[NCK_D.LIBNCK_D]RPC_CLIENT.C;7 %s%sRcvd "working" during frag send!
 %s%sRcvd "working" pkt; seq=%lu
 %s%sGot "fack" for non-large request!
 %signoring old fack..
 %s%sGot non-frag "response" during frag recv!
 %sError sending frag response..
   
INTO u_pfm signal_handler for signal #%d.
-----------------
 *** Exiting: exception caught by PFM system cleanup handler
*** %s
   NULL	(rpc_$request -- handled specially)
 do_ping  (rpc_$ping) do_bad_pkt  (rpc_$response) do_bad_pkt  (rpc_$fault) do_bad_pkt  (rpc_$working) do_bad_pkt  (rpc_$nocall) do_bad_pkt  (rpc_$reject) do_ack  (rpc_$ack) do_quit  (rpc_$quit) do_fack  (rpc_$fack) do_bad_pkt  (rpc_$quack) %s, %lu.%u frag in_call_back working in_reply replied idle passive %s(send_rejection) via rpc_$sendto. sock# %d
 %s%s
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(free_reply) act->a.reply.opkt == NULL so don't call rpc_$free_pkt()
 act->state == as_in_reply || act->state == as_replied RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 act->state = as_replied RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(send_reply) Send small reply. sock# %d
 %s(send_reply) frag of large reply. sock# %d
 %s(get_activity) Can't allocate slot
 %s(get_activity) allocate activity slot %d.
 %s(free_activity) free activity slot %d.
 act->state == as_idle RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 act->state == as_passive RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %sENTERED ..
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s slot %d. delta = %d.
 %sFreeing passive slot %d. (act->state == as_passive)
	act->id = [%s]
 %sPassivating slot %d. idle. (act->state == as_idle) && delta > IDLE_TIME
 	act->id = [%s]  delta = %d, IDLE_TIME = %d
 %sSuppressing RETRANSMIT reply slot %d. (act->state == as_in_reply)
 %sFree reply slot %d. (act->state == as_replied)
 	delta > REPLY_TIME  uidseqstring = [%s]  delta = %d, REPLY_TIME = %d
 %sRETRANSMITTING reply --> slot %d. <-- (state = %s)
 	uidseqstring = [%s]	sock# %d
 act->re_xmt_send = %d, seq # = %D
 act->ping_protocol_error = %d, act->fack_protocol_error = %d
 %s slot %d. DELTA <= 0 #%D ! (delta = %d)
 RPC activity scanner %sact->state == as_working
 	(ptype = %s)  uidseqstring = [%s]  sock# %d
 %sact->state == as_in_reply || as_replied
 %sResending reply
 	(state=%s, ptype=%s, frag=%u)
	udeseqstring = [%s] sock# %d
 act->re_xmt_send = %d
 %sact->state == as_idle || as_passive || as_frag
 	--> NO CALL <-- (state=%s, ptype=%s)
	uidseqstring = [%s]	sock# %d
 %sInvalid activity state (state=%s, ptype=%s) sock# %d
 %sIssuing -DIE- `INVALID ACTIVITY STATE'
 invalid activity state RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(who_are_you) Can't bind to client, lst=%08lx  setting act->state = as_idle..
 %s%s
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s(who_are_you) fault, lst=%08lx
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s%s
 %s(handle_request_frag) sendto -> sock# %d
 %s..ENTERED.. sock# %d
 %sUnknown interface [%s]	sock# %d
 %sSending rejection for NOT broadcast
	When ihint == NO_HINT
	-or- uids not ===  -or-  ifs.vers not equal.
	Sending on sock# %d. %sOpnum out of range ?  [%s]
	sock# %d
 %ssending rejection..
	Not a broadcast.. sock# %d
 %sahint == NO_HINT. sock# %d
 %sactivity state for this call => %s
 %sGot inappropriate request (state=%s) [%s]	 sock# %d
 %sact->state == as_passive. sock# %d
 %sactivity state IS NOW => %s, NEXT INS CHANGES STATE.
	sock# %d
 %sreset activity state from as_passive  to => %s
	sock# %d
 %sInvalid state (state=%s) [%s] %sInvalid state (state=%s)
	ID = [%s]
	GOING TO INITIATE:  >> DIE << operation !
	sock# %d
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s%s
 %sSending rejection. Not idem && act->prev_seq == -1 ..
	sock# %d
 %s%s
 %scouldn't get encr ? Sending rejection. sock# %d
 %spkt->hdr.auth_type != rpc_$auth_type(act->a.encr)
	Sending rejection.. sock# %d
 %s%s
 %scouldn't decrypt pkt ? Sending rejection. sock# %d
 %sOld sequence, previous=%ld [%s]
	sock# %d  IGN                                                                                                                                                                                                                                                   |                         $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                          {% "            ORING REQUEST !!
 %sOperation not idem. Sending rejection. sock# %d
 %sProtocol error [%s]
	sock# %d
 %sNOT a BROADCAST. Sending rejection. sock# %d
 %sPF_FRAG pkt == NULL. sock# %d
 %sDiscarding any saved reply(s). Going -idle-  sock# %d
 %sSwitching to -WORKING- state. sock# %d
 %sCouldn't set pfm_$p_cleanup(&crec)
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %sFault while executing request ??
 %s%s
 %sDispatching  iface->e.s.epv[pkt->hdr.opnum] opnum = %d
	address = 0x%X	sock# %d
 %sGeneric dispatch iface->e.g.epv[pkt->hdr.opnum] opnum = %d  address = 0x%X
	sock# %d
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %s== non-maybe && idem &&  !large. sock# %d
 %sCalling  rpc_$sendto for sock# %d
 %s== non-maybe && idem && large.  sock# %d
 %ssending reply for sock# %d
 %sgot_frag on sock# %d
	Calling  rpc_$free_pkt((rpc_$ppkt_p_t) pkt)
 %s%s
 %ssignalling fault_st ? sock# %d
 %s%s
 %ssignalling fault_st ? sock# %d
 %ssay -NO CALL-  NOT valid_ahint(pkt) ?
 %ssending on sock# %d
 %sNo call (no activity for this call) [%s]
	sock# %d
 PROTOCOL ERRORING PING for seq # %D, act->re_xmt_send = %d
 %sNo call (higher numbered ping), ahint=%d, previous=%ld
 	[%s]  sock# %d
 %ssay -NO CALL- packet must have been lost sock# %d
 %sDrop PING !?
	uidseqstring = [%s]
	sock# %d
 %s(do_ack) NOT valid_ahint(pkt).  ahint = %d
	 uidseq = [%s]	 sock# %d
 %s(do_ack) freeing reply. state = as_replied & pkt->hdr.seq [%D] >= act->prev_seq [%D]
 %s(do_ack) Sorry, can't call free_reply.
 	act->state = %s  s.b. as_replied
 	pkt->hdr.seq = %D, act->prev_seq = %D  hdr.seq s.b >= prev_seq
 %s(do_fack) Not valid ahint in fack, ahint=%d
	uidseq = [%s]	sock# %d
 %s(do_fack) Anomalous fack ?  state=%s, act->prev_seq=%D  pkt->hdr.seq= %D
	uidseq [%s]	sock# %d
 
DUPLICATE FACK !! # %d, pkt seq # %D, last_frag_seq = %D
 pkt->hdr.fragnum = %d, act->last_fack_frag = %d
 act->re_fack in do_fack: %d
 do_fack SENDING PROTOCOL ERROR..
 %s(do_quit) NOT valid_ahint(pkt).. Indicate -NO CALL-
 %s(do_quit) NO CALL (i.e. no activity for this call)
	uidseq = [%s]	sock# %d
 %s(do_quit) send rpc_$quack.	sock # =%d
 %s(do_bad_pkt) Bad pkt, ptype=%s
	 uidseq [%s]	sock# %d
 %sTrash ahint (%u)  sock# %d
 %sTrash ihint (%u)  sock# %d
 %sServer boot time mismatch !!
 %sSending rejection on sock# %d
 RPC$:[NCK_D.LIBNCK_D]RPC_SERVER.C;6 %sptype != rpc_$request.
	Dispatching to routine:  %s  sock# %d
   RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 rpc_lsn.c rpc_lsn.c: (use_family) Can't create socket ??
 rpc_lsn.c rpc_lsn.c: (use_family) Can't bind socket, errno=%d
 rpc_lsn.c rpc_lsn.c: (rpc_$use_family) Can't getsockname, errno=%d
 rpc_lsn.c: (rpc_$use_family) Can't get my netaddr
 rpc_lsn.c: (rpc_$forward) .. forwarding.. size <= mtu, sock# = %d
 rpc_lsn.c: (rpc_$forward) .. forwarding.. does 2 sends because size  => mtu
 rpc_lsn.c: (check_for_pkt_common)  Rcvd (ptype=%s)
 rpc_lsn.c: (listen) Spurious quit_activity fault ignored
 (listen) Exiting, st=%08lx
 rpc_lsn.c rpc_lsn.c: (await_pkt) select failed: %d, errno=%d
 which < n_sockets RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 "rpc_$mispacked_hdr" in "rpc.idl" should be %d (is currently %d)
 mispacked header stuff messed up RPC$:[000000.NCK_D.LIBNCK_D]RPC_LSN.C;11 RPC packet checker ioctl failed: status = %d
 ioctl failed: status = %x, %x, %x%x
 %W%     (ultrix)        %G% %W%  (ultrix) %G%                                                                                                                                                                                                                                                                                                               %W%     (ultrix)        %G%                                                                     v":3    
                                                                          96 @  
  f                --> SEND -->   <-- RCVE <--  rpc_util.c:                                                                                                                                                                                                        7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????   ??????  ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#@'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[???????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????0123456789|?????                                                                                                                                  8  U  p            %W%     (ultrix)        %G%                                                                      96 @  
  f   <  t        %W%     (ultrix)        %G%                                                                      96 @  
  f   P P PB P   4  Л    D  D=  %W%     (ultrix)        %G%         ?                                              %W%     (ultrix)        %G%                                     %W%     (ultrix)        %G%                                                                     v":3    
         %W%     (ultrix)        %G%                                                                     v":3    
     l    @  >  %W%	VMS/ULTRIX Connection	%G%           %W%     (ultrix)        %G%                                                                                                     0  l      |         $  p      \    t    %W%     (ultrix)        %G%                                                                         v":3    
                                                                          96 @  
  f           rpc_client.c:  (alloc_socket)  (rpc_$sar)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      %W%     (ultrix)        %G%                     %W%     (ultrix)        %G%                                                                     v":3    
                                                                          96 @  
  f                                                                                                                                                                   rpc_server.c:  rpc_server.c: (do_request)  rpc_server.c: (scan_activities)  rpc_server.c: (ping_common)  rpc_server.c: (do_ping)  rpc_server.c: (rpc_$int_listen_dispatch)     J  _  {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             D  I  V  ^  g  o  t                          h1 ; ; ; ; ; 4 9 t6 ; %W%     (ultrix)        %G%                                                                     v":3    
                                                                          96 @  
  f                                                                                           %W%   (ultrix)  %G                                                                                                                      | ΀^_  VѬfp  M  ;  ߭ߦ*ЬRݢ0  P$ЬRݢߦ.0  
    ݏd   ߭^(n  Pߦk  P   ^ ޼P`KPPѭ;PЬRPPЬQPPab޼RbRRѭ޼R b <^ˏ   PP޼P `޼P `޼P `ޭR 1  PbխޭP`  P1ޭP`WޭQޭPaޭPWޭPWޭQޭPޭPWP`VQPaPVPVQPPVѭ1PЏ                                                                                                                                                                                                                                                   }                        R $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                           "     '        xPʏ  PPPP 찏 2PP1խ1 ,ݏ   ޭP`  P   1P 2PP@P`U2PP@Q2PP@Pa2PP@PU2PP@P`T2PP@Q2PP@Pa2PP@PT2PP@PT2PP@Q2PP@P2PP@PT2PP@P`2PP@P`2Qʏ Q2PP@P2`Pʏ PQP2PP@P`PP졭PP2PP	խ1}ѭ1P ݭޭP`  ݏ   XޭP`]  >XP`S>XQ>XPa>XPSZP`RZQZPaZPRݬ\ݬQխ1ݬ͜ݬ6ˏ  PPPPX
Z1 Xݏ   XޭP`   #P2P@X	PP=  谭걭 \PPP2PP	޼P ``ЬQPP2P@Xa2P@X
޼P `5PP걭 ݏ   XޭP`   1vPޭPݠ   | ^۔Vݏd   ݏd   4ݏd   ߭^(n@ޭRbݬߦݬ  lP4Rb߭ݬߦ"ݬ`  GPRb4߭ݬߦ2ݬ7  4߭ߦEݬ   P| ^Vݏd    ݏd   vݏd   ߦ޼R^(bnp޼SަRRc޼SvRRc޼S RRc޼Sߦ  PRRc޼Sv  PRRc޼S p  PRRc   ^ݏ]   ݬ  PݬխЬ
PPݭ ,      ^eQRѬ
IPPЬP@P  ^ t  P  ^   P  ^ЬPPPP߬ PPe   ^qRЬPPPP PP߭6  ЬPPPPxPPPQPPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬPJQЬPJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@PЬPLP`ЬPLQЬPLPaЬPLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP`ЬPDQЬPDPaЬPDPЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHPaЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8QЬP8PaЬP8PЬP8PЬP8QЬP8PЬP8P < \^;S  UR޼P `߭ЬP  PP PPݬ?  PխZe#M¸¼P [{   Ã  g  ë  ЭPЭP PP ޼PЭ`¼ЏP   Э߭߭߭ݭЬP5  խ&¸¼ݭ   %¸
¼Pݭ߭  խ)¸	¼ݭ   ЭP¬hլcЬPNPPխRЭP@ҬG޼TЭP@ҬPàPP PPЭP@ҬPްP`PdխeЏP޼P`PP6¸
¼P޼P`PP i  eЏPЬPPPPPP<PPP
:¸
¼!PЬPPPPP Ó  eЏPЬPPPPxPPPQPPPQPݬIˏ¼PP¼1 PխS߭  ¸
¼Pݭݭ ú  ¸	¼
  4P޼P`k  ЬPݠ@ݭ PPf  ЬP>JP<`PP   PѭP<¸¼#ЬP>JP<`PPݭ 'i  eЏPTPPTЬPPPPPP<PPP@\QaPPaЭP ΀^kWV#   PRz  RP{PQPPRRЏ   PЬRRʏRR ߘSP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n  ޼RbRRRƼ1 ЏP   Э߭߭߭ݭЬR1  խ(Ƹ
ƼPݭ d  %Ƹ
ƼPݭ߭ǔ  ЬR ݭ RRݬ  Pխǰ   RR ˏƼRR	Ƽ ޼Rb  ЬRݢ@ݭ RR  խ,PRRPЬRRRRRR<RRRBXScRRcRխRRRRRRP< ^ݬt  PխЏ ^(nT  P  ^   5    ^P      PPPP  ^     ^X   PPhPլP   PPݬЭP  ЭPP` P ^RЬP>P<`PP"Pݏ  |   q  ЬQPPЬP>P<`PPݬ  ^޼P`-P޼Pް P`޼P`n޼PЭ`޼P` ^SЬPPPЭPPPP޼R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`ЬQPPЬ޼PЭ`ЬQPP*ЭQЭPTLôPPôЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPQЬPQPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ8P޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRRR޼RbRXݭ  ޼R޲ Rb޼Rb*޼RЭb޼RbЭP (^-SﲸR¸  ޯ\\f  `  pP B  P\\  QP<\\Lc\\ս'Э\ѭн\ lЭQЭ\P\Pl\\ B\\  
  ¸   ^=T·R  4P<PP@cP`<PPPPPPP ϱ2PP@cPPH< PPݏ^  B.@   5  < PP@cPP PP ,DPP  P¨  P¤ЬЭPPЬ`ЭS   PQQPQ` ^ﭶR   ;<PP@cPPѽ PսPP ŕ0  )  ¨  ¤¤  P< ^<RĬRRRRRѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR>JR<bRRRRíSЬRCPЬRP^  RRP ^aSRPRPݬݬ   1 PPVЬQPPЬRPPbRBHaaPP*ЬRPPЬQPPaP@HbbPPVЬQPPЬRPPbRBaaPP,PЬRPPЬQPPaP@bbPP  ^ݬݬ   Q  | ^~Vݏd   ߭^(n}P d  S  t  	    ^Ѭ  Ѭ  Ѭ   PPPPP ^ٳRѬ   ޼PЏ `¬+ݏ   &P¬ ЭP @Ҭ   ЬPЬ@Ҭ޼P    (^}SjRHjݬ  LÇݬk  PãݬV   <PP
G<PP@XP`<PPPPPùݬ  PP<PP
Tݬ   <PP
F<PP@\P`<PPPPPݬ  PP<PP
°ݬ  ´   m   H^|V,WǼ1  \Pլ
 RRP RRЬRլRR
RR߭  ݭݭݭݭݭ  ݭݭo  ޼RbRRƏ  ЬRRR\PЬRRRƝf  ЬRЬRRRưF  /ЬRRR-  ЬRRRR<RRR  ЬRRR  ЬRRRR<RRRR  ߭ЬR+  ߭  ߭ЬRh+  ߭  ߭ЬR(E+  ߭}  ЬRݢ8#i  ЬRݢ<;U  ЬRݢ@SA   f0  ЬR>DR<bRRy  ЬRFƋ  ЬR>FR<bRRƧ  ЬRHƻ  ЬR>HR<bRR  ЬR>LR<bRR  ЬRJЬR>JR<bRRq  P`  ЬRRRRRPP   V ?P1 ݬǸǼP^(n^(n"  FPݬEǸǼP^(n^(nA  PPݭݭa  ݭݭݭݭݭƁ  P $^xR<PʏPPU  <PʏPP:  <PʏPP6  <PʏPPb  <PʏPP  <PʏPP¾  <PʏPP  <PʏPP	  P ^wR
=	w  <PPC	a  P¨	P  P 0^wSTլB߭  ĸļPݬݭ 	  
  ݬE
   ѭ1 z  P{PQPPRR!խ~
  ݭÀ
  Rz  RP{PQPPRRÇ
w  Э                                                                                                                                                                                                                                                   ~                        H $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                          BV "     8       R޼PB`RRÉ
\  RRѭݬÏ
<      ^RPP PP߭߭ݏ   ݭݭݭ ݬ
T  ޼P`<PPPPPЭ䋏QQQGPPPQP.Q0PQPQ!PQP
޼Pн``QQQPPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭP| L^ﻮV]S]R  PD]]RݢDLp  LYY !XݭY^(Ynaq  ޼Rb RR<RRSR   SSXXRRݭP	ͥRR<RRRRRЭܭЬRRíܭRRͥRR߭߭ݏ   ݭݭݭݬ
R  <RRRRRЭܭSSSARRRSR1 S'RSR1 SRSR1 RRRRRR>RbRR౭Џ  T^(Tno  íܭRRRRR޼RbRR<RRRݭݭE<RRRRíܭRRRRR޼RbRнbRR޼Rнb1PRRSSS.RRRSR
>Rb"P>RRЭЭRЭR̢RR౭Џ  P^(Pno  ޼RbRR<RRխ1 íܭRRRRRSSSRRRSR
н<P޽RRЭЭRЭSЭRЭSЭRЭRĢRRRRRRխ1líܭRRRRRSSSRRRSR޼RbRнb=޼RbRRЭ୼ЭRЭSЭRЭSЭRЭRRRSSSRRRSR
޼Rнb?P޼RbRRЭ୴ЭRЭSЭRЭSЭRЭRݭLXݭ;Y]l  | ^'V%S%R  PD%%RݢDk  !! ! ݭ^(!nl  ޼Rbz RR<zRRSR   SS  RRݭPPPmRR<zRRRRRЭܭЬRRíܭRRmRRmqr߭߭ݏ   ݭݭݭݬ
"N  <zRRRRRЭܭrSSSRRRSR1rSRSR1sSuRSR1RRRRxRR>vRbRRvxЏ  ^(nYk  ޼RbRR<vRRխ1íܭRRRRR޽RнbRRЭRRRݏ@   ݭݭu@   RRЭRDRbRRíܭRRRRRЭRFRнbRRЭRJRbRRЭRLRbRRЭRNRRЭRORRݭݭRRȏV   RRRRխ1íܭRRRRR޼RbRнbRR޼Rнb1sPRRrSSSRRRSR>vRb!>vRRЭ୼ЭRЭRRRvxЏ  ^(nyi  ޼RbRR<vRRխ1íܭRRRRRrSSSRRRSR
޽Rнb<P޽RRЭ୴ЭRЭSЭRЭSЭRЭRRRЭRRR խhrSSS~RRRSR
>Rb"P>RRЭ୬ЭRЭRRRRRRRխrSSSRRRSRЭRDRb#ЭRDRRЭ୤ЭRЭRRRíܭRRRRRrSSSﮢRRRSRЭRFRнb@PЭRFRRЭଡ଼ЭRЭSЭRЭSЭRЭRRRrSSS<RRRSRЭRJRb$ЭRJRRЭ୔ЭRЭRRRrSSSRRRSRЭRLRb&PЭRLRRЭୌЭRЭRRRЭRNRRЭRORRխ&RRRRRRխȏV   RRRRխ1íܭRRRRRrSSSRRRSR޼RbRнb=޼RbRRЭୄЭRЭSЭRЭSЭRЭRRRrSSSRRRSR޼RнbCP޼RbRRЭ||RЭS|RЭS|RЭR|qݭZ ݭI!%d   ^3RPP PP߭߭ݏ   ݭݭݭ ݬ
G  ޼P`<PPPPPЭ䋏QQQPPPQP.QpPQPQaPQP
޼Pн``QQQ?PPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭ     ^ݬ蘆  ޼P` PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R   < x^SR2  PDRݢDz;b  zѭ խݭ^(nc   ޼Rb<RRRRRЭSSS﫝RRRSR2SRSRެRSRSR
ޭRнb]SSS_RRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭRآRRRP߭ݭݭݬγ   RRRRRRЬ$SRѭRRccRR޼RݭPb޼RЬb޼S<RRRcRRЭRRRR԰ԽRRRRRRҰҽRRҭЏ  ~^(~n]a  íRRRRR޽RR<RRRݭݭ<RRRRíRRRRRЭRRЭRR޼ SíRRcխݭ޼(R b< l^~S~R|  PD~~RݢDn_  nzz  խݭ^(znY`   ޼Rb<RRRRRЭSSSRRRSR3SٚRSRެRSƚRSRޭRнb^SSSRRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭR̢RďV   RRPv߭ݭݭݬa   Rď[   RRRRRЬ$SRѭRRccRR޼RݭPbP޼RЬb޼S<RRRcRRЭRRRRȰȽRRRRRRưƽRRƭЏ  r^(rn^  RR<RRխ1íRRRRRнܽRRЭRRRݏ@   ݭݭ@   RRЭR>DRbRRíRRRRRЭRޢFRbRRЭR>JRbRRЭR>LRbRRЭRNRRЭRORRݭݭRR܏V   RRRRխ1íRRRRRЭRRvRR޼ SíRRcխݭz~U\  ޼(R   ^ݬH  ޼P` PPЬ$QPѭPPaaPP޼Rݭ{Pb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R b    ^mQլ#Ѭ
2P@޼P `Џ   PP޼PЏ
 ` P ^)R޼P `  ޼Pѭ`޼PЏ `)P2PP@ЭP޼Q@aPP
޼P   ^S޼P `޼R޼Pb` Pݬ޼P<`PPP1PˏPPKݬݬݬݬݬ޼P<`PPP2PP@Pް0P`P޼P`1ZP P1ˏPPwݬ߭ݬݬ	  ޼P`1ݬ߭ݬݬY	  ޼P`1 Pѭݭr  P P1 ˏPPsݬ߭ݬݬ	  ޼P`1 ݬ߭ݬݬ	  ޼P`nPѭݭ  P PˏPP2ݬݬݬh   PRݬݬݬR   RP PЏ   P޼P ` Ѭ ݬݬݬx  P	PPPPPPP ^Rݬ޼P<`PPPݬݬݬ޼P<`PPP2PP@Pް P`PP ^IRݬ޼P<`PPP޼P`ݬݬݬݬ޼P<`PPP2PP@PްP  ^Rݬ޼P<`PPcP޼P`ݬݬݬݬ޼P<`PPP2PP@PްP  ^fR޼P `ݬbݬ/  P
Pݬߢݬ  PPݬߢݬ  PPݬߢ
ݬ޵  P P޼PЏ
   ЏP ^5fRЬPP 
, \ 8 \ \ \ D \ \ \ \ \ \ P 
P^?P2PޢPP2PޢPP&PޢPPPޢPPP޼PЏ
 `޼P`ݭݬ*  ݭ  P޼Pѭ`޼PЭ`޼P   ^GR޼P`Ѭ  ޼PЏ `ݏ  ݬ  ЬP @PPլg:ݬ  Pխ޼PЏ ` ݬìPPݬP޼P`ìPPPPPPPݬݬP޼P`ݏ[   ݬ  PխЬT ݏ]   PP  Pխ޼PЏ ` PPҳ  PPPìPP޼P`PPV޼P`PQP#QQ	PPݬݬݬݭPPݬݬ2P@PްP`Oݬ߭ݬ  ݬݭݬݬX  ݬݭݬݬ ^scT<SЏd   Џd   ݬ޼P<`PPPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`ЭP @߭(ߤ"  ޼P`ݬ  q  P޼P`޼RݬT  PPPb޼Rݬݬ P   ^GbTSЏd   Џd   ݬ޼P<`PPrPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`'ЭP @߭(ߤ)m  [Pݬ߭߭ݬݬ޼P<`PPP2PP@PްP`޼P`ЭP @߭(ߤ/  ޼P`ݬ    P޼P`޼Rݬ̰  PPPb޼Rݬݬ P  <  ^ݬ޼RbݬP޼Rbݬ߭߭߭ݭ޼R<bRR  ޼Rb޼R(b޼SޭRb  ^!RݬݬPݬݬ2P@P P  PP ^RݬݬYP޼P` ݬp  ޼P`ݬݬݬݬ2P@P P   ^}Rݬ޼P<`PPP޼P`                                                                                                                                                                                                                                                                           O%P $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                           "     I        ݬ  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@Pް P  ^R޼Q޼P`a޼P`ݬ޼P<`PPePݬݬݬݬݬ޼P<`PPP2PP@Pް$P   ^Rݬ޼P<`PPP޼P` ݬ&  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@Pް(P  ^%R޼Q޼P`a޼P`ݬ޼P<`PPPݬݬݬݬݬ޼P<`PPP2PP@Pް,P   ^ｍRݬݬ5Pݬݬݬݬݬݬ2P@P4 P   ^qRЬݬ޼P<`PPPݬݭݬ޼P<`PPP2PP@P8 P   ^RЬݬ<PPPݬݭݬ<PPP2PP@Pް<P` .A    A      ^)]ST c  Pѭ2ݏ  ߣ(  Pѭݏ  ߣ4  ѭݭF  Pѭ`޼Rb޼RbЬP P:P޼RФbЬR> P<`QQ  QPQ`>P<`PPЬRbPPb޼RbЬP>Q Pa`ѭ#  ݭ  ݬݭ@  ݭ   X^ӋT|J  Ï PPNRD{RPNPP@PRPR޼RGgPJPPPbЬRPPQPQ`ݬIդ<1  j߭߭j߭n>P<`PPjݭn߭ ,d  j߭,ݭPP<ЬPP `ЬP, ЬP	  Ѥ<Ф<PPPݭ.ЬP		   ^ZRЬPPPЬPPPЬP
PPЬPPPЬPPPЬP
PPЬP	PPЬPPPЬP>P<`PP޼P`ߢN       ^YR??߭ ݬ  Pѭ
޼PЏ`޼P `޼PЭ`ЬPP`ЬPЬPP `ЬP	ЬP
ЬPЬPЬP
ЬPЬP     ^ ޼Q޼Pa`1 ЬQЬP1 ЬQЬP1 ЬQЬPrЬQЬP		cЬQЬP

TЬQЬPEЬQЬP6ЬQЬP

'ЬQЬPЬQЬP	PPPPPPP ^ЬЬ ЭQPPaRЭQPPaPPRRխЭPЭP ^ЬЭPͽQЭP̠QЭP̠QQP̭Pʏ  PPQЭPЬRRRPRQPQ{RPPQQP  | l^ӇVuSuR  PDuuRݢDlG  lqq !pݭ^(qnH  ޼Rb RR<RRSR   SSppRRݭNP	ͽRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭxRRíܭRRRRRЬRRíܭRRͽRR߭߭ݏ   ݭݭݭ ݬ
)  <RRRRRЭܭSSS!RRRSRDS
RSR0SRSR ޼RbRнbRR޼Rнb1 SSSÁRRRSR޼RbRнb=޼RbRRЭЭRЭSЭRЭSЭRЭRТRRSSSVRRRSR
޼Rнb?P޼RbRRЭЭRЭSЭRЭSЭRЭRȢݭpݭquRE    ^޼P`<PPPPPЭQQQPPPQP1 QPQP1 ެPQmPQP1 ޭPн`PPP`PPP`PPPPPPݭݭPPíPPPPPޭPн`1QQQPPPQP
ޭPн`9ޭPPЭЭPЭQЭPЭQЭPЭPؠPPQQQiPPPQPP`!PPPЭЭPЭPРPPQQQPPPQP
P`PPЭЭPЭPȠPPPPPPխ&PPPPPPխíPPPPPQQQv~PPPQP
ޭPн`<PޭPPЭЭPЭQЭPЭQЭPЭP߭ݭݬh   PPЬ$QPѭPPaaPP޼Rݭ׾Pb
P޼RЬb޼P<RRR`RRЭЭRRЭRR޼ PíRR`޼(R b  ^ЬխЏP ѭˏPP&xPPPPѭˏPPЭP ^ ЭP޼Q@a$ŭ RЭP޼Q@asPRRЭP?ʘ P ^論R  ޼PЭ`ЬQ>P<`PPPP޼Q< PPaЬPТ$ < $^޼R( bݏi ݬ  P PRSRS3SRRRRPP< $^޼R( bݏi ݬx  P PRSRS3SRRRRPP< $^޼R( bݏ
i ݬ0  P P>R<bRSRSSRRP< $^޼R( bݬݬYP%ݬݬPݬݬPP Pݏi ݬﲓ  P PRSRS3SRRRRP  ^ݬ  PխЏPЭPްP`P  ^߬^  Pխ PP  ^ЬѬ޼PЏ `ЭP> P<  PP  PPPP ^Ь޼P`޼PЏ `޼P`޼P `ЭRݬV  PQ PQ   ^Ь޼P`޼PЏ `޼P `Ѭ (Ѭ  ЭRݏ     PQPQ`PP |^ЬѬd   ޼PЏ `޼P `޼P` ݭƜ  ݬݬݬݭݬݬ߭  ЬP @4߭}  Pѭ޼PЏ `ЭPPЭ`1 ߭PЭPP޼PЏ `ޭPPޭPPЭRPPЭQPPabЭQRRЭPRR`aЭQRRЭPRR`aЭQRRЭPRR`aЭRRЭb޼R  < ^ЬѬ޼RЏ bЭR^(nu  P޼Rݭ  PbP޼RЏ bݭݬK  ޼Sݬt  PRRc޼R     ^ЬѬ޼PЏ `޼P `ЭPՠ$޼P`ݬ*  P޼PЏ `8ЭPݠϧPխ޼PЏ `޼P`ݭݬ|  ݬњ  P޼Pѭ`޼PЭ`P  ^޼P   Џ   P  ^ ЬP4  ޼P` ِ  Pѭ޼PЏ `Џ   PPݏiݭ%  Pݭ~  ޼PЏ ` PPPPխ1 ߭ݭe  ݭݭ0P\ݭݭgPKݭݭP:ѭ4ЭPPPЭPР߭ЬPI  ޼P ` PPPPխ1jݭ﯍  ޼P     ^ЬЭPРѬ޼PЏ `޼P `޼P`߭ P Ř    ^ЬѬ޼PЏ`޼P `޼P`ЬP߭  ЭPP    ^ЬЭPРѬ޼PЏ `޼P `޼P`߭ P )    ^ЬѬ޼PЏ`޼P `޼P`ЬP߭  ЭPP    <^ЬЬѬ޼PЏ `Ѭ޼PЏ `ݬݭ  ݬݭ  ޼P `Pݠ  PPPPݠ  PPPˏPP'ˏPPˏ Qˏ PQP1 ˏ?PP   .ˏ?PP   ˏ  Qˏ  PQPGPˏ?PP   .ˏ?PP   ˏ   Qˏ   PQPP ːPPPPP| ΰ^GV޼Rb޼RЏ b   Pѭ޼RЏ bЏ   RRݏiݭ:  Pݭ  ޼RЏ b RR RRխ1 ޼Rѭb1 S޼RCbRR( ͼݭݭϷPѭP1 ЭR޼SBcRbЭRݬ6  PSRSbͼݏi ݭq  Pf:  0RRЭRЭR
  RR&P RRRRխ
޼Rѭb1޼RЭb޼R bU   ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ  ^Ь PPЭPc޼P`ЬQaPPa ^xERvSrbPPP`PЏd   ߭߭߭ݬݬխޢPPP'Pݭ߭ݭߢ	Î̓  ÎPPPP ^DSvR޼P ` k<P	P@fPPCЭPѠ8r
r<PP  ߣP  ЭPPP<PP@   ݏZ  ߣNߣ;q
q  ߣr   ݬ:  Pdq
`qݭ  ß   խA3q
/q P    ü w  ޼PЏ ` P   ݭ﬈  P[   pp#P9  ݭ     ݭD  ޼PЏ ` Pݭ  QPP<QP	P@fPP@p
<p%<PP<PP    ЭPЭЭP<QPQ`ЭP ^BSsRo
oPЬPݠ K  ޼P   | ^]sV <RR 1 P,em<R.RBƦP
<RRRRPЬR(<R.RBƦP0ЬS<R.RBRѣ@b<T.TЬRޢ@SDRcbRR<RR 1g1 2S.SЬR((CƦ2T.TЬRޢ@SDRcb2T.TЬR>HSDRcb2T.TЬRޢ8SDRcbЬRRR2R.RBƶRRR2R.RBƶRbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RR 8^@WqV xt o&ݬݬݬЬRݢPc1*P_x|c_޼RbЬR1PЬR>R<bRR_wݏd    ^(_n˞  Ǆ  +m
'mP_ Ǌv  ݏ"   t P y  t ݏ  ЬRݢx  PppS  l
lP%     ݏ,  !  P c f<fRRx1 <fRRBcRRlORRhKS<fRB|Rbc<fRB|R>bRbd<dR                                                                                                                                                                                                                                                                            x"Y $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                           "     Z       R7hThRRhlSlRRlcddRRd<dRRݬKݬЬRݢcPPcfRRf<fRRx1=ݏ8  E cRRP ^=WoVݬ ݬݬЬRݢ謹Pխ P޼RbЬR(PЬRRRRRЬRRRRR1 fЬRTP1  VЬRѢ@ƈЬR@RRƈjj+PЬRRRRR˝P iۋ  ݭ޼ RbݬЬRݢm  ݏ  ǒ ﳝ P' j
j Ƕs   PЬRѢ@1 ЬRѢ@B RR ii# ݬЬRݢ@   Iii7PЬRRRRRǜPЬRݢ@ݬ Lˊ   PЬRբ>&ЬSЬRѣ>8Џ ^(nl,  RRRЬRRR޼RbSRbcRb<RR0PЭTRRЭSRRcdRR<RRЏ   P ^M;WnlV <RR s<RRBf	S<RRBf	<SS޼R(bCg	<RRBw	RЬb<RRB{	RЬb<RRBf	RRPRR<RR ݏ  ǫǗ ^kR <PP SP<PP@f	0޼P`<PP@g	GP<PP@f	PPPPP<PP 2  P ^-:SNkR޼P `ݬiPխ޼PЏ `ЭPРPՠ>ЭPРP>PЬ`BЭPРPѠ>2+g
'gP {  ޼PЏ	 `޼QЭPޠPР     ^ݬPխ޼PЏ ` ޼P `ЭPРP< ^ݏP    ݬ  ЬRdЬRdЬRzdЬRod޼RbЬRFRbЬRHRbլ
ЬS޼R(bP l^8V  Wi\ݏd   ~ <RR 1UP<R.RB̦RRcEP1Puee PЭRݢ$u   ЭR>R<bRRPխ1 P ϜRЭRޢ*SRcb(ЭR>(SRcbЭRޢ$SRcb  ЭRݭP29  d
dg F,  ݭ(bRR<RR 1 P ^7S>hRcc:g O+  #ddr
PPP  ^޼P `ݏ   ΢PP ЭPPЏ`ЭPlP`ЭPZP`ЭPVP`ЭPjP `ЭP  ЭP  լЭPjQjPQ`ݬЭPݬݭU  P ^Ьݬݬ3  ЬЭPZPPЭPVPЬ`<PP/ЭRPPЭQPPabRR<RRЭRjPjRPbݬЭRݢVЭRZPЭRjPjRPb޼R    ^ЬЭPѠ1 ЭP>jP<`PʏPP޼PЏ `ЭPZPPЬ޼QЭPޠVP`aЭP>VP`<PP1PЭRPPЭQPPabRR<RRݬݬݬ>  ޼R  < ^Ь޼SЭR(c޼R   ^q4WeVЬݬ ЭRVЭRZ޼Rb4ݏd    ޼R^(bn  ǉڂ  ЭRjSjRSbЭR>R bЭRLRbЭRNRb޼R   ^3WdVЬݬݬ)޼Rb4ݏd    ޼R^(bnc  Ǐ9  ЭRjSjRSb޼R   $^E3WfdVѬ޼RЏ bݬ޼R<bRRݬJP޼Rb
խ7Pݏd    ޼R^(bn  Ǖ  ޼Rbݬݬݬݭ޼Rb}ݏd    ޼R^(bng  Ǜ=  ݭ   խ1ݏd    ^(n"  ǡ   P  ^ЬЭP>jP<`PʏPQPQQլЭPjQjPQ`ЭPjQjPQ`޼P `PPP  ^bQPլPPe  ^Ь޼P `ЭQlPPl>lP<`PPxЭPPЏ`ЭP ЭP ЭPЄ P`PްP`ЭP  ЭP ЭP ЭPЀ P`PްP`ЭP  ݭWP  ^Ь޼P `ЭQlPPlЬP| 8^0UaV 7  PRRR լ	խCP]]Pݭݬŧ@   ~  PRRRЬ  ~  ЬR STЬRz  P{ PQPPRxRRCdRRCd  ЬRRR-s  P~  ݏ@   ﳐЭPPD   P.?P1  P]\P S~  Pѭ9\
\PQ~   '~  U}   }  PRRѭPPíRR1cP b}  }  2 P< ^ SRF}  PDRݢDO  ѭ 1\   ޼R(P bRRRR b  |  ЬR STЬRz  P{ PQPPRxRRCdRRCd <RR1 ЬR  ݬRݬb  ЬRRRq  Pj߭ݬzݭݏT   ݬݬϬP<RRRRR
'RRRRRRRRRRPPRR<RR1;<     
P    ^/-WP^V ?{Z
wZ-P  ǒ{  ݏ  :ЬЬ Э  ͳ Ͳ  Ԑ    ͠ͼSͼR{  PDͼͼRݢDd  d͸͸ 1 ݭݭݭݭOխ6ЭRTR|WSBc"ݭЭRTRdWSBcR޲Rb խ խ	ݭ]ͳݬ4ݭ4Ͳ
 ︌^(͸nX  ЬRޢRbѭȏ*Ь  ƈSƈRRƈS1 Pѭȏ
 >ݬ4߭ݬC  P޼4Rb޼4R^(bn  ͳ@XXP  y  ͛^(͛n  ЭЭR>jR<bRʏRRA,X
(X  2zy  Џ ͗^(͗n5  ѬMWW"ݏݬ  a#y  Џ ͓^(͓n  ޼$RЭb޼0R b޼(R b޼4R b Ͱݬ4ЭR>ZR<bRRP   PPؐ  ЭR>jR<bRʏRSRSSˏRRݬ4ݬݬ4ЭRݢVЭRZP:V
V  Ǥ:x  ЭRVRR1+PЭRVRRRRRRRbSЭRVRbcЭRVRb<RR.ЭTRRЭSRRcdRR<RR>R<bSЬR<CRRE+V
'VP  vw  ݬ4 FSUUP  2w  ݬ4>R<bSЬR<CRRRRݏ  7 ͲЭR.PЭR(.ЭRNRbЬRFЭRPЭS޼RѣBb-PЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЭSRRRRRRѬRRЭR>jR<bRʏRRЭS`RRRRRRˏRRЭS0RRRRRRˏRRЭS RRЭR 1 1 1 ЭR .ЭSݬ4ݬЭR ЭRҀ R޲ R޲ RbPÄ ޼4Rbpݏd    ݬ4  [t  ~SzSP޼4Rb  at  ޼4R^(bn  ЭR ЭR҄ RbRâRRؕЏ ͏^(͏nA  RRRRRaݬ4ЭR>R<bRRvP޼4Rb޼4R^(bn  ЭRݢ@ݭPԕRRRR  tR
pR <RRR  ǃs  <RRSRR<SRRQ"RR%P<RRR  Ǜas  Џ ͋^(͋n  \ЭR RRݭݭݭϧP'QQ r  11 ͱ1
 <SЭR>LR<bRRSLQSEQRSbЭR>LRb͞͉ݭ<RRݬݭ=P͉͈<S<RRSR͉ ͈͈RR͊͊͋RR͋ЭR RRݭ͉ݭϷP'PP r  1RRRR͊19R͉RRͱ xq  PRRЕͱͰPFP	͈P͈͈RR 

RR
2RxRRR䡭RR
ЏխPݭݭϏPЭPP  5	?P1kխ6ЭRTRMSBc"ݭЭRTRmMSBcR޲Rb ߭ЭRݢ@ݬ ݭݭݭP1  Jp  PR­RROO2RR<RR8fp  ѭ@   խ7NNPݭ  k&p  Џ@   1EP   ЭRRRRRPP! - ) r - r r % P?PSP11Y1NNJNP ǐo  ʹݭ^(ʹnS  	NN/ЭRRRRR3P  Ƿ>o  1QPMMP  o  ]RRѦJ M
|M  	n  Џ ̈́^(̈́n  P1ͱ20M
,M<RR n	|n  13PLLP  ǩ	Jn  1 PLLP  	n  	m  ݏ{  		~L
|L  
m  =
m  ݏ  X
J
2
PMP 
  L
LP  |
^m  Џ ̀^(̀n  (P //RyR bЭR  ݭ/ݭϙݕP1 ߭l  KKݭ  Ǭ
l  @l  ߭el  CK
?KPݭ  
l  1P RR RR2RRRRJ
J& 2RRݭ  
&l  JJJPm[  k  Џ |^(|n
  ݭݭ!PRRPP  S	Z?P1խ6ЭRTRHSBc"ݭЭRTRHSBcR޲R                                                                                                                                                                                                                                                                           
F $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                          }U "     k       b ߭ЭRݢ@ݬ ݭݭݭkޕP1 ЭRRRRRPP %  ! % 	?PZP1Y1 1IIP<RR Vj  ʹݭ }^(ʹn  >I:I0PЭRRRRRg|P  ǜrj  1PHHP  Bj  1Pݏ  {ͱAH
H  !i  Џ x^(xn    WH
SH!PЭRݢ@  Gi  ЭTЭR>HSHRcbЭTЭR>FSFRcb1AG
G  hBi  Џ t^(tn
    ЭR>LR<bSSЭR>LR<bRSR'GG Ǐh  1ЭTЭR>LR<bRRRRSLRSb 1  ЭR 1;131+ЭRNSЭR҄ R޲ RSbЏ p^(pn$
  ޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bݬ4ЭR@ݭЭR>JR<bSЭRCP޼,R^(bnЭR ЭR҄ RbR޲Rb޼4Rb޼4Rbl^(lng	  խ6ЭRTRDSBc"ݭЭRTRCSBcR޲Rb ЭRRʏRR_PͰAE
E  Ǧg  Џ h^(hn  ޼(SЭR>JR<bRRc1$  ͰЭR>JR<bRRݭP͟ݭ͠hݭ﹄͟1 ЭRRʏRR1 (P //R	yR bЭR>HSwRcb>ͬS{RcbЭR  ݭ/ݭϩ֕P)D
DP e  11޼(SͨRbc޼$R͠ Pb޼0RbP  -ݭύԕe RR dЬRFЭRwP!ЭS޼RѣBbЭTЭR>FSLRcbЭR.?PЭTЭR>HSNRcbЭTЭRޢ8S>RcbЭRjSjRSbRRRЭRVRRRЭRVRbSRbcRb<RR.ЭTRRЭSRRcdRR<RR޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bPխ6ЭRTR@SBc"ݭЭRTR@SBcR޲Rb ͳ ͳݬ4ݭkݭvҐ ݬ4ͼ   u   ^ݬݬݬݬݬݬ     ^ݬݬݬݬݬ   < ^ЬRТѭЬѭ
 ^(n  ޼R bЭR ЭR ЭRҀ RbR޲RbЭR    < ^ЬRТѭЬѭ
 ^(nw  ޼R bR P< ^ЬRТѭ@޼R bЬЭR ЭR ЭR҄ RbR޲RbЭRЬ 9Pѭ
 ݬݬݬE  Џ ^(n  < ^ЬRТѭ޼R bЬЭR P7ѭ
 ݬݬE  PPЏ ^(nm  < ^@ݬya  ЬPPQ - ] 9 i   E  u u    - 	?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  PHRRݬ`  ^(     ,^P\լ, `   G`   :`   -`    `   `   `   _   
_   _   _   ,^aORx\\y_  i\\_  W\\_  E\\_  3\\m_  !\\[_  \\I_  \\7_  \\
%_  \\_  \\_  ,  ^ˏPP   ^uNQЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^%NQѬ ޼PЏ `б  ޼P `  ^MQ޼PС `Ь ޼P     ^P  ^    P  ^ (   P ^MRТP\\P   ^MP\\ՠ ^HWeMVЦ խYլ
 ]  H 7ݏd   ߭^(nmPݭߧ>]  ]  ݏ@ж  զ ЭRRRլЏ
PЬRRݭЭR\  < ^ ^(n(    ^LRQݬQ  PPP ^SLRЬP>LP<`PPЬPݠ@ЬP(Pv\  vPPP  ^ELQЬP@P ^]S&LRЬPݬݬnЬPJP`;
;ݬh\_\  :-ݏd   ¨ݬTl¨hÊ*\   ݬݬ   v| ^KV8(J8޼R(( < ^ЬRТѽ޼RЏ b P޼SЭR(c޼UЭRТ.TЭSuRRu@uRReݬЭRݢ2ЭR6ЭR. R EPP  ^ݬB ^JR ޼P ` Hf<Pď`   P@@PPЭPW
Э/PЬPFЭPFP޼Pѽ`ЭPPHխE<HPP ޼PЏ ` PHQHPPH<QPď`   P@@PPЭP WP| ^Vݏ  ƐflݬݬPխVlЭRW0ЭRVЭRѢXP޼RЏ
 bl0ЭRWЭR V޼R(V bЭRЬXЭR\R bЭS\RR\k| ^QVݏ  ƴkݬݬ1PխkЭRW0ЭRVЭRѢXP޼RЏ
 b[k.ЭRWЭRV޼R(V bЭRЬXЭR \LvP޼R(bЭRЬЭSЭRТ\ЭRЭ\ j ^5HR HX<Pď`   P@@PPЭPW)޼P`ЭPFPѽ<PPPPPHЏ  PP ^RGS޼P `ݏC  ,j޼P`ЬPF@Pj޼PЏ `<Pď`   P@@PPЭPV$ЭQ\PP\>\P<`PPЭP WPi  ^լ2P޼P`޼P`P	ЬPРPЬPРլ2  P| ^FV<JRR@   ޼RЏ bJSJRRJ<SR RB@RR޼R(bЭS޼R(b޼R b| ^]FV޼RbZ3ۭP޼R(D3bЏ   P JPP<R RB@RR޼RbP޼SЭR(cЏ   PRRJ޼R(2b2  P ^TESЬPՠJЬPݠJsЬP J(P44PhU  ޼P`ЬRЬQЬP   ЬQЬP ((& ^SSETЬPJPP޼P`޼P`P!Pݏ  zD<U   1U  ЬP>6P<`PPP   PPЬPՠ~ЬPް~P`PàPPЭPѠ1 ЬP``ݏ  öÞT   T  нRЭP>QJPa`X3'L3
H3ݬhT  ЬPݠ~ЬP2ݽݬPoЭP>P` ЬPy癭PPݭ<PPЭPݠݽxP<Q<PPQP	 琭PP항PP2)v2r2PݬhS  ЬPݠ~ЬP2ݬwnPPPP19޼P`  ^ЬPt P ^BS <RR   jP<P@HF޼Rb<P@HP1P&<P@HR R  PQPQ`<PPPPP<PP   Џ  P  ^yWBBVЬRHЬRHBЬR>HR<bRBH0ЬR(ЬR>HR<bRBHRP<RRPЬR(P챭<RRP <RR   SP<RBHDP<RBHRb<RBHRb<RRRRRR<RR   <RR   b.X0
T0h3Q  Џ  P-2RBHRb2RR2RRu//P<RRhYHQ  <Rݏ   nPЭBHЭSЬR((ЭRЏЭTЭSЭR   ЭSЭR ((&ЭR JЭRЬFЭR TЭR tЭTЬRRʏRSRSSyЭR zЭR ~ЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR.ЭTRRЭSRRcdRR<RRЭR O  PSRSb<RRP ^Sn?R{.
w.P<PPhÆO  <P@H<P @H)m ^AV
?W<RBHѽ!Pݏ  ư<O   1O  <R*lPЭBHЭSЭR(ЭSЭRТЭSЭRЭSЭR  ЭSЭRЭSЭR&&ЭSЭR((ЭR ~N  PSRSbЭRբ~ЭRݢ~ЭR޲~RbR޲RbЭR ~ЭRբzЭRݢzЭR޲zRbR޲RbЭR z k  ^
V=W<RBHѽ!Pݏ   N   M  <Rݏ   [kPЭBHݏ    ݭM  ЭSЭR(ЭSЭRТЭSЭRЭSЭR  ЭSЭRЭSЭR&&ЭSЭR((ЭRЬFЭR zЭR ~ЬRRRЭR2RRRЭR2RbS޼Rbc޼Rb<RR.ЭTRRЭSRRcdRR<RRЭR L  PSRSbݭkjP ^|SE<RR+N+P'L  ݏ<  5^ /L  P\\ <\\   1<\LHխ1Э\ì\\\\** 2\\<\\YL  1нPP 1y  P?P1,T<\\<_*
[*+PЭ\cP<\\rK  <\\ψ1}-p*
*<\\ùXK  ))(P-2\\Э\PK  <\\r1P@\\@)
)P<\\1J  1Э\&
Э\(1 Э\&Э\( \\ PD\\D)
)P<\\vXJ  (((P2\\Э\ݬJPèJ  ݭ1P((&PݽP<\\I  b(^(&PЭ\ݬFЭ\ݬJχP%I  `\\`Э\ެ\l ((P                                                                                                                                                                                                                                                                           Af $      RCP011.B                         E9  [B]RPC$STCODE.EXE;2                                                                                                                                          " $           `8?Lfwō쐽/=9;c򋱌}̛?6]n,ߜZ
üoUBx.f	i{GƠ"M|Bҡ"6;{HvA)Dz?7hB7PА@爺3E(Ă?3KNEy	
!VՁ"Yd*}^_!bۓRH~nEɔsʳ57=) 4p%2
<^4y{HTS#n;8YLdZ0a'Jޔ;Qhw<*emwÌg<A594طU5 F RGq/nv05S N?*$gb}el^nHԺ{Ud;?a _l' Ktu CD\2w6Ȼ5釱g(T	=IW܇RUHx2Й+HuwCz`ڏ,*g{6%0s_XQe>Y5-몌&N*{YdG{j	ݜ@TV"yfTf;sD'jSM`n"x-jNxJj?EHzIݏ~W}<),CB	JՕQlxݴrpL.F:Ì`銿:"|a\[qz$!4Oɷ1Y";17^}GdGy^YzRId9xEd2IpV	_6]6bVя28<MÌ<U1^sbHS+
s oQT&+jjDj͖yJzK<+Q$vg	AJ&n?Euo<SKrV25SFp,8E _PćSi|E+P|<[B
WR?kN6&6א8&`ƃGm#6~p/x)*mีxTK%Q(;|%q`!viߎ*
։	o9e,)m-٫vXl";NT≷N+0<<U
%ǬRaxbx1爞5+{+cV5i51
DEOFq)7vD,|`L){m[eZtEesx$ϒh;M)i3FEdlK˔iGf1&d-(d*N7HBNgkM$ߠmiũ<Qhitf(}w;ɪF)_jO9n0odkz9C\t
 ⻱/+y(w}
cU*7t8gh.4+HNVTqn