                            Et        RPC010.B                                                                                                                                                                                                     #P               RPC010.B  BACKUP/NOASSIST/COMMENT=VAX/VMS SPKITBLD Procedure/INTER/LOG/VERIFY [.RPCKIT.B]*.* $1$MUA0:[0,0]RPC010.B/LABEL=(RPC)/SAVE/IGN=LABEL/NOREWI/DENS=1600/NOINIT/NOREWI  VAX/VMS SPKITBLD Procedure  LHH              td ϓ      V5.1	 	 _LASSIE:: 
 	  _$1$MUA0:  V5.0 
       
                                 * [UCX.V13.BL13.RPCKIT.B]BANK.C;1 +  ,    .     /    4        
                    - !   0   1    2   3      K  P   W   O 
    5   6  ๓  7  ϓ  8          9          G #  H  J                  #ifndef lint
static char sccsid[] = "@(#)bank.c	2.3     (ultrix)        1/31/90";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifdef vms
#include <base.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <unixlib.h>
#else
#include <idl/c/base.h>
#endif vms
#include "bank.h"
 
#ifdef MSDOS
#include <sys\types.h>
#include <time.h>
#else
#include <sys/types.h>
#ifdef vms
#include <sys/time.h>
#else
#include <sys/times.h>
#endif vms
#endif MSDOS

#include <stdio.h>

static void DoDeposit(), DoWithdraw(), DoInquire(), DoKill();

static struct cmd_t {
    char name[20];
    void (*proc)();
} CmdTable[] = {
    {"deposit",     DoDeposit},
    {"withdraw",    DoWithdraw},
    {"inquire",     DoInquire},
    {"kill",        DoKill},
    {"",            NULL}
};


/*
 * Usage
 *
 * Print a blurb saying how to invoke this program.
 */

static void Usage()
{
    fprintf(stderr, "(bank) usage: bank <deposit | withdraw | create | delete | inquire> <bank name> <account name> <arguments>\n");
    exit(1);
}


/*
 * main
 *
 * Main program.
 */

#ifdef VMS
main(argc, argv)
#else
void main(argc, argv)
#endif VMS
int argc;
char *argv[];
{
    uuid_$t bank_id;
    uuid_$t bank$uid;
#   define MAX_LOCS 3
    char *acct_name;
    bank$acct_t acct;
    status_$t st;
    struct cmd_t *p;
    extern boolean BankNameToID();

    if (argc < 4)
        Usage();

    acct_name = argv[3];

    if (! BankNameToID(argv[2], &bank_id)) {
        fprintf(stderr, "(bank) Unknown bank - \"%s\"\n", argv[2]);
        exit(1);
    }
    if (! GetBankTypeID(&bank$uid) ) {
        fprintf(stderr, "(bank) Unable to get bank type uuid.\n");
        exit(1);
    }

    if (strcmp(argv[1], "create") == 0) {
        bank$create_acct(&bank_id, argv[3], strlen(argv[3]), &acct, &st);
        if (st.all != status_$ok) {
            fprintf(stderr, "(bank) Can't create account - \"%s\" (%08x)\n", argv[4], st);
            exit(1);
        }

        printf("New account is %d\n", acct);
        exit(0);
    }

    bank$get_acct(&bank_id, argv[3], strlen(argv[3]), &acct, &st);
    if (st.all != status_$ok) {
        fprintf(stderr, "(bank) Can't find account - \"%s\" (%08x)\n", argv[3], st);
        exit(1);
    }

    for (p = CmdTable; p->proc != NULL; p++)
        if (strcmp(argv[1], p->name) == 0) {
            (*p->proc)(&bank_id, acct, &argv[4], argc - 4);
            exit(0);
        }

    fprintf(stderr, "(bank) Unknown command - \"%s\"\n", argv[1]);
    Usage();
}


/*
 * DoInquire
 *
 * Create an account.
 */

static void DoInquire(h, acct, argv, argc)
uuid_$t *h;
bank$acct_t acct;
char *argv[];
int argc;
{
    long int balance;
    long int trans_time, create_time;
    status_$t st;

    if (argc > 0)
        fprintf(stderr, "(bank) Ignoring extra arguments\n");

    bank$inq_acct(h, acct, &balance, &trans_time, &create_time, &st);
    if (st.all != status_$ok) {
        fprintf(stderr, "(bank) Can't inquire account (%08x)\n", st);
        exit(1);
    }

    printf("Account #%ld\n", acct);
    printf("    Balance: $%d\n", balance);
    printf("    Time of creation: %s", ctime(&create_time));
    printf("    Time of last transaction: %s", ctime(&trans_time));
}


/*
 * DoKill   
 *
 * Kill an account.
 */

static void DoKill(h, acct, argv, argc)
uuid_$t *h;
bank$acct_t acct;
char *argv[];
int argc;
{
    status_$t st;

    if (argc > 0)
        fprintf(stderr, "(bank) Ignoring extra arguments\n");

    bank$kill_acct(h, acct, &st);
    if (st.all != status_$ok) {
        fprintf(stderr, "(bank) Can't kill account (%08x)\n", st);
        exit(1);
    }
    
    printf("OK\n");
}


/*
 * DoDeposit
 *
 * Deposit into an account
 */

static void DoDeposit(h, acct, argv, argc)
uuid_$t *h;
bank$acct_t acct;
char *argv[];
int argc;
{
    status_$t st;

    if (argc != 1) {
        fprintf(stderr, "(bank) Exactly one number must follow the account name\n");
        exit(1);
    }

    bank$deposit(h, acct, atoi(argv[0]), &st);
    if (st.all != status_$ok) {
        fprintf(stderr, "(bank) Can't deposit into account (%08x)\n", st);
        exit(1);
    }

    printf("OK\n");
}


/*
 * DoWithdraw
 *
 * Withdraw into an account
 */

static void DoWithdraw(h, acct, argv, argc)
uuid_$t *h;
bank$acct_t acct;
char *argv[];
int argc;
{
    status_$t st;

    if (argc != 1) {
        fprintf(stderr, "(bank) Exactly one number must follow the account name\n");
        exit(1);
    }

    bank$withdraw(h, acct, atoi(argv[0]), &st);
    if (st.all != status_$ok) {
        fprintf(stderr, "(bank) Can't withdraw into account (%08x)\n", st);
        exit(1);
    }

    printf("OK\n");
}

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ! * [UCX.V13.BL13.RPCKIT.B]BANK.IDL;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 	  6   7 @G ϓ  8          9          G #  H  J                
{*	@(#)bank.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not p                                                                                                                                                                                                                                                                                                                                                                                                                          Jj,b        RPC010.B                         !  ![UCX.V13.BL13.RPCKIT.B]BANK.IDL;1                                                                                                                                        be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

[ uuid(35c2c6a25000.0d.00.00.c3.66.00.00.00), version(1) ]
interface bank;

import 
    'nbase.idl';

const
    bank$bad_acct_number       = 16#2ff00001;
    bank$acct_name_not_found   = 16#2ff00002;
    bank$acct_deleted          = 16#2ff00003;

type
    bank$acct_t =
        integer32;

    bank$acct_name_t =
        array[1..32] of char;

procedure bank$create_acct(
    in ref h:       uuid_$t;
    in name:        bank$acct_name_t;
    in namelen:     integer32;
    out acct:       bank$acct_t;
    out st:         status_$t
    );

procedure bank$inq_acct(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    out balance:    integer32;
    out trans_time: integer32;
    out create_time:integer32;
    out st:         status_$t
    );

procedure bank$get_acct(
    in ref h:       uuid_$t;
    in name:        bank$acct_name_t;
    in namelen:     integer32;
    out acct:       bank$acct_t;
    out st:         status_$t
    );

procedure bank$kill_acct(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    out st:         status_$t
    );

procedure bank$deposit(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    in amount:      integer32;
    out st:         status_$t
    );

procedure bank$withdraw(
    in ref h:       uuid_$t;
    in acct:        bank$acct_t;
    in amount:      integer32;
    out st:         status_$t
    );

end;
                                                                                          * [UCX.V13.BL13.RPCKIT.B]BANKD.C;1 +  ,    .     /    4 c       R                   - !   0   1    2   3      K  P   W   O     5   6 ๓  7   ϓ  8          9          G #  H  J                 #ifndef lint
static char sccsid[] = "@(#)bankd.c	2.3     (ultrix)        1/31/90";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifdef vms
#include <base.h>
#include <lb.h>
#include <pfm.h>
#include <math.h>
#include <stdlib.h>
#include <unixlib.h>
#else
#include <idl/c/base.h>
#include <idl/c/lb.h>
#include <idl/c/pfm.h>
#endif vms

#include "bank.h"
#include "util.h"

#ifdef MSDOS
#include <sys\types.h>
#include <time.h>
#else
#include <sys/types.h>
#ifdef vms
#include <sys/time.h>
#define bcmp memcmp
#else
#include <sys/times.h>
#endif vms
#endif

#include <stdio.h>

extern uuid_$t uuid_$nil;

#ifdef vms
#include <errno.h>
#else
extern int errno;
#endif vms

#ifdef vms
#include <perror.h>
#else
extern char *sys_errlist[];
#endif vms
#define errstr (sys_errlist[errno])  

struct acct_t {
    char *name;            /* Text name of account owner */
    long balance;          /* Account balance */
    bank$acct_t number;    /* Account # */
    boolean deleted;       /* => account has been deleted */
    long trans_time;       /* Time of last transaction */
    long create_time;      /* Time of creation */
};

#define MAX_ACCTS 100

uuid_$t BankID;
lb_$entry_t BankEntry;
long NextAcct;
long NumAccts;
struct acct_t Accts[MAX_ACCTS];
char *BankName;


/*
 * Usage
 *
 * Print a blurb saying how to invoke this program.
 */

static void Usage()
{
    fprintf(stderr, "(bankd) usage: bankd <addr family> <bank name>\n");
    exit(1);
}


/*
 * DumpBankData
 *
 * Dump out the bank accounts information to a file.
 */

static void DumpBankData()
{
    FILE *f;
    long i;
    char buff[256];

    printf("Dumping \"%s\"...\n", BankName);

    sprintf(buff, "%s.new", BankName);

    if ((f = fopen(buff, "w")) == NULL) {
        fprintf(stderr, "(bankd) Can't open bank data file \"%s\" - %s\n", buff, errstr);
        exit(1);
    }

    fprintf(f, "%ld\n", NextAcct);

    for (i = 0; i < NumAccts; i++) {
        struct acct_t *a = &Accts[i];

        if (! a->deleted)
            fprintf(f, "%s %d %d %d %d\n", 
                    a->name, a->number, a->balance, a->trans_time, a->create_time);
    }

    fclose(f);

    if (rename(buff, BankName) < 0) {
        fprintf(stderr, "(bankd) Can't rename new bank file - %s\n", errstr);
        exit(1);
    }

    printf("Dumped %d accounts\n", NumAccts);
}


/*
 * LoadBankData
 *
 * Read in the bank accounts information from a file.
 */

static void LoadBankData()
{
    FILE *f;
    char buff[100];
    long tot, i;

    printf("Loading \"%s\"...\n", BankName);

    if ((f = fopen(BankName, "r")) == NULL) {
        fprintf(stderr, "(bankd) Can't open bank data file \"%s\" - %s\n", BankName, errstr);
        exit(1);
    }

    fscanf(f, "%ld\n", &NextAcct);

    tot = 0;
    i = 0;

    while (EOF != fscanf(f, "%s %d %d %d %d\n", 
                         buff, 
                         &Accts[i].number, 
                         &Accts[i].balance,
                         &Accts[i].trans_time,
                         &Accts[i].create_time))
    {
        Accts[i].deleted = false;
        Accts[i].name = SAlloc(buff);
        tot += Accts[i].balance;
        i++;
    }

    fclose(f);

    NumAccts = i;

    printf("Loaded %ld accounts, total balance is $%ld\n", NumAccts, tot);

}


/*
 * main
 *
 * Main program.
 */

main(argc, argv)
int argc;
char *argv[];
{
    uuid_$t bank$uid;
    status_$t st, fault_st;
    char name[256];
    unsigned long namelen;
    unsigned long port;
    lb_$entry_t entry;
    lb_$entry_t old_entries[10];
    long n_entries;
    long i;
    socket_$addr_t saddr;
    unsigned long slen;
    pfm_$cleanup_rec crec;
    unsigned long family;

    if (argc < 3)
        Usage();

    BankName = argv[2];

    if (! BankNameToID(BankName, &BankID)) {
        fprintf(stderr, "(bankd) Unknown bank - \"%s\"\n", BankName);
        exit(1);
    }
    if (! GetBankTypeID(&bank$uid) ) {
        fprintf(stderr, "(bank) Unable to get bank type uuid.\n");
        exit(1);
    }

    LoadBankData();

    /*
     * Establish the socket on want to listen on and print out the resulting
     * so                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          53        RPC010.B                         !   [UCX.V13.BL13.RPCKIT.B]BANKD.C;1                                                                                               c                              !             ckaddr.
     */

    family = socket_$family_from_name (argv[1], strlen(argv[1]), &st);
    rpc_$use_family(family, &saddr, &slen, &st);
    if (st.all != 0) {
        fprintf(stderr, "(bankd) Can't use_family %s (%08x)\n", argv[1], st);
        exit(1);
    }

    namelen = sizeof(name);
    rpc_$sockaddr_to_name(&saddr, slen, name, &namelen, &port, &st);
/*..rjg..
*fprintf(stderr,"..rjg.. rpc_$sockaddr_to_name returns:  %s\n",name);
*/
    if (st.all != 0) {
        fprintf(stderr, "(bankd) Can't convert sockaddr to name (%08x)\n", st);
        exit(1);
    }

    printf("(bankd) name=\"%.*s\", port=%d\n", (int) namelen, name, port);

    /*
     * Register the interface I support with the RPC runtime.
     */

    rpc_$register(&bank$if_spec, bank$server_epv, &st);
    if (st.all != 0) {
        fprintf(stderr, "(bankd) Can't register interface (%08x)\n", st);
        exit(1);
    }

    /*
     * Look in the global location database for any existing entries with
     * my bank object.
     */

    lb_$lookup_object(&BankID, NULL, 1L, &n_entries, old_entries, &st);
    if (st.all == status_$ok) {
        if (n_entries > 0) {
            fprintf(stderr, "(bankd) Bank already registered at:\n");
            for (i = 0; i < n_entries; i++) {
                char name[256];
                unsigned long namelen = 256;

                rpc_$sockaddr_to_name(&old_entries[i].saddr, old_entries[i].saddr_len,
                                      name, &namelen, &port, &st);

                if (st.all != status_$ok)
                    fprintf(stderr, "(bankd) Can't get name of location %d\n", i);
                else
                    fprintf(stderr, "    %.*s[%d]\n", (int) namelen, name, port);
            }
            exit(1);
        }
    }
    else if (st.all != lb_$not_registered)
        fprintf(stderr, "(bankd) Warning: Can't lookup bank (%08x)\n", st);

    lb_$register(&BankID, &bank$uid, &bank$if_spec.id, 0, BankName, &saddr, slen, &BankEntry, &st);
    if (st.all != status_$ok) {
        fprintf(stderr, "(bankd) Can't register bank (%08x)\n", st);
        exit(1);
    }

    pfm_$init(pfm_$init_signal_handlers);

    fault_st = pfm_$cleanup(crec);
    if (fault_st.all != pfm_$cleanup_set) {
        lb_$unregister(&BankEntry, &st);
        if (st.all != status_$ok)
            fprintf(stderr, "(bankd) Warning: Couldn't unregister (%08x)\n", st);
        DumpBankData();
        exit(1);
    }

    printf("Listening...\n");

    rpc_$listen(5, &st);

    pgm_$exit();
}


/*
 * CheckObject
 *
 * Check to see if the object referred to by the RPC handle is the object
 * we expect.
 */

static boolean CheckObject(h, st)
uuid_$t *h;
status_$t *st;
{
    if (bcmp(h, &BankID, sizeof(BankID))) {
        fprintf(stderr, "(bankd) Request for wrong bank!\n");
        st->all = -1;       /* "object not found" */
        return(false);
    }

    st->all = status_$ok;
    return(true);
}


/*
 * bank$create_acct
 *
 * Create a new account.
 */

void bank$create_acct(h, name, namelen, acct, st)
uuid_$t *h;
char *name;
long namelen;
bank$acct_t *acct;
status_$t *st;
{
    struct acct_t *p;
    
    if (! CheckObject(h, st))
        return;

    name[namelen] = 0;

    *acct = NextAcct++;

    p = &Accts[NumAccts++];

    p->name    = SAlloc(name);
    p->balance = 0;
    p->number  = *acct;
    p->deleted = false;

    p->trans_time = p->create_time = time(NULL);
    
    st->all = status_$ok;
}


/*
 * FindAcct
 *
 * Return the account specified by "acct".  Return NULL if the account can't
 * be found.
 */

static struct acct_t *FindAcct(h, acct, st)
uuid_$t *h;
bank$acct_t acct;
status_$t *st;
{
    long i;

    if (! CheckObject(h, st))
        return;

    for (i = 0; i < NumAccts; i++)
        if (Accts[i].number == acct)
            if (Accts[i].deleted) {
                st->all = bank$acct_deleted;
                return(NULL);
            }
            else {
                st->all = status_$ok;
                return(&Accts[i]);
            }

    st->all = bank$bad_acct_number;
    return(NULL);
}


/*
 * bank$inq_acct
 *
 * Return information about an account.
 */

void bank$inq_acct(h, acct, balance, trans_time, create_time, st)
uuid_$t *h;
bank$acct_t acct;
long *balance;
long *trans_time;
long *create_time;
status_$t *st;
{
    struct acct_t *a;

    if ((a = FindAcct(h, acct, st)) == NULL)
        return;

    *balance = a->balance;
    *trans_time = a->trans_time;
    *create_time = a->create_time;

    st->all = status_$ok;
}


/*
 * bank$get_acct
 *
 * Return an account number, given its name.
 */

void bank$get_acct(h, name, namelen, acct, st)
uuid_$t *h;
char *name;
long namelen;
bank$acct_t *acct;
status_$t *st;
{
    long i;

    if (! CheckObject(h, st))
        return;

    name[namelen] = 0;

    for (i = 0; i < NumAccts; i++) {
        struct acct_t *a = &Accts[i];

        if ((! a->deleted) && strcmp(name, a->name) == 0) {
            *acct = a->number;
            st->all = status_$ok;
            return;
        }
    }

    st->all = bank$acct_name_not_found;
}


/*
 * bank$deposit
 *
 * Deposit money in an account.
 */

void bank$deposit(h, acct, amount, st)
uuid_$t *h;
bank$acct_t acct;
long amount;
status_$t *st;
{
    struct acct_t *a;

    if ((a = FindAcct(h, acct, st)) == NULL)
        return;

    a->trans_time = time(NULL);
    a->balance += amount;
}


/*
 * bank$withdraw
 *
 * Withdraw money from an account.
 */

void bank$withdraw(h, acct, amount, st)
uuid_$t *h;
bank$acct_t acct;
long amount;
status_$t *st;
{
    struct acct_t *a;

    if ((a = FindAcct(h, acct, st)) == NULL)
        return;

    a->trans_time = time(NULL);
    a->balance -= amount;
}


/*
 * bank$kill_acct
 *
 * Kill an account.
 */

void bank$kill_acct(h, acct, st)
uuid_$t *h;
bank$acct_t acct;
status_$t *st;
{
    struct acct_t *a;

    if ((a = FindAcct(h, acct, st)) == NULL)
        return;

    a->trans_time = time(NULL);
    a->deleted = true;
}
                                                                                                                                                                                            ( * [UCX.V13.BL13.RPCKIT.B]BANKS_BUILD.COM;1 +  ,    .     /    4 R       M                    - !   0   1    2   3      K  P   W   O 	    5   6 츄Γ  7 _ ϓ  8          9          G #  H  J                         $!	%W%     VMS/ULTRIX Connection   %G%
$!*****************************************************************************
$!
$!                        COPYRIGHT (C) 1989 BY
$!                DIGITAL EQUIPMENT CORPORATION, MAYNARD
$!                  MASSACHUSETTS. ALL RIGHTS RESERVED.
$!
$!  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
$!  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
$!  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
$!  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
$!  PERSON. NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS  HEREBY TRANSFERRED.
$!
$!  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
$!  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
$!
$!  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
$!  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
$!
$!*********************************************************************                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  RPC010.B                         !  ([UCX.V13.BL13.RPCKIT.B]BANKS_BUILD.COM;1                                                                                       R                              ? 
            ********
$!
$!  USAGE: @build
$!  
$!  Build bank example programs:
$!      bank -- the client
$!      bankd -- the bank server
$!
$
$!
$! Produce the server and client stubs.
$!
$ nidl -s [.idl_d]bank.idl -idir rpc$idl:
$!
$! For code portability.
$!
$ define sys        sys$library:
$ define net        sys$library:
$ define netinet    sys$library:
$ define arpa       sys$library:
$ define machine    sys$library:
$ define c$include  rpc$include:, sys$library:
$ goto do_bld
$!
$! Compile all modules.  All include files are in RPC$INCLUDE:
$!
$ do_bld:
$ write sys$output "  Compiling..."
$ if f$search("_vms_b.dir") .eqs. "" then create/dir [._vms_b]
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank_cswtch.obj bank_cswtch
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank_cstub.obj bank_cstub
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank_sstub.obj bank_sstub
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bank.obj bank
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]bankd.obj bankd
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]util.obj util
$ cc/noopt/g_float/define=(debug, broken_inet_addr_type, inet, "CC$mixed_float") -
	/include=rpc$include/object=[._vms_b]uuidbind.obj uuidbind
$!
$ deassign sys
$ deassign netinet
$ deassign arpa
$ deassign net
$ deassign machine
$ deassign c$include
$!
$! Build server and client using RPC run-time shared image.
$!
$ set def [._vms_b]
$ write sys$output "  Linking..."
$ write sys$output "  (Ignore %LINK-W-WRNERS and %LINK-I-UDFSYM message)"
$ link/exec=bankd bankd,util,bank_sstub,rpc$lib:rpc$libnck.opt/opt
$ link/exec=bank  bank,util,uuidbind,bank_cswtch,bank_cstub, -
  	rpc$lib:rpc$libnck.opt/opt
$ set def [-]
;                                                                                                                                                                                                                                                                                                                                                                                                                                                                & * [UCX.V13.BL13.RPCKIT.B]BANKS_README.;1 +  ,    .     /    4       3                    - !   0   1    2   3      K  P   W   O     5   6  kΓ  7 ( ϓ  8          9          G #  H  J                           
#  @(#)README	2.1  ULTRIX  6/13/89

This directory contains a system that uses both RPC and the Location
Broker (LB).  It also demonstrates the use of "auto-binding".  The basic
idea is that there is are "banks" that have a number of accounts.  A
server process corresponds to a each bank.  Client prorams locate a bank
via the LB and then make a call to the bank (server) to perform a
transaction at that bank.  The transactions are creating and deleting
an account, depositing to and withdrawing from an account, and balance
inquiry on an account.

To run the example, run "bankd" (the server) in one process and "bank"
(the client) in another process, perhaps on another machine.

"bankd" takes two arguments.  The first is the address family on which
the server should listen.  The second argument is the name of the bank;
use "shawmut" or "baybanks".  Note that the files "shawmut" and "baybanks"
contain the contents of two banks (i.e. the account names, numbers and
balances).  "bankd" reads one of these files when it starts.

The initial data files for "baybanks" and "shawmut" contain an account
for "guest". New accounts may be created as desired.

To options to the "bank" program are:

    bank <deposit | withdraw | create | delete | inquire> <bank name> <account name> [<arguments>]    

The "arguments" are amounts of dollars to deposit or withdraw.

Example:

    bankd ip shawmut&                -- Start server listening on ip protocol

    bank inquire shawmut Leach       -- Find out how much money Leach has

    bank deposit shawmut Dineen 3    -- Give Dineen $3
e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           * [UCX.V13.BL13.RPCKIT.B]BASE.H;1 +  ,    .     /    4       
                    - !   0   1    2   3      K  P   W   O     5 	  6    7  x ϓ  8          9          G #  H  J      
            
/*	@(#)base.h	2.1	(ULTIRX)	6/13/89	*/

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef base__included
#define base__included
#include "idl_base.h"
#include "nbase.h"
#include "timebase.h"
typedef ndr_$long_int status_$all_t;
#define proc1_$n_user_processes 56
#define name_$long_complen_max 255
#define name_$long_pnamlen_max 1023
#define name_$pnamlen_max 256
#define name_$complen_max 32
typedef ndr_$char name_$pname_t[256];
typedef ndr_$char name_$name_t[32];
typedef ndr_$char name_$long_name_t[256];
typedef ndr_$char name_$long_pname_t[1024];
#define ios_$max 127
#define ios_$stdin 0
#define ios_$stdout 1
#define ios_$stderr 2
#define ios_$errin 2
#define ios_$errout 2
#define stream_$stdin ios_$stdin
#define stream_$stdout ios_$stdout
#define stream_$stderr ios_$stderr
#define stream_$errin stream_$stderr
#define stream_$errout stream_$stderr
typedef ndr_$short_int ios_$id_t;
typedef struct ios_$seek_key_t ios_$seek_key_t;
struct ios_$seek_key_t {
ndr_$long_int rec_adr;
ndr_$long_int byte_adr;
};
typedef ndr_$short_int stream_$id_t;
typedef struct uid_$t uid_$t;
struct uid_$t {
ndr_$long_int high;
ndr_$long_int low;
};
#ifdef __STDC__
handle_t uid_$t_bind(uid_$t h);
void uid_$t_unbind(uid_$t uh, handle_t h);
#else
handle_t uid_$t_bind();
void uid_$t_unbind();
#endif
typedef struct xoid_$t xoid_$t;
struct xoid_$t {
ndr_$long_int rfu1;
ndr_$long_int rfu2;
uid_$t uid;
};
typedef struct ec2_$eventcount_t ec2_$eventcount_t;
struct ec2_$eventcount_t {
ndr_$long_int value;
pinteger awaiters;
};
typedef ec2_$eventcount_t *ec2_$p                                                                                                                                                                                                                           3        RPC010.B                         !  [UCX.V13.BL13.RPCKIT.B]BASE.H;1;1                                                                                                                           !             tr_t;
#endif
e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ! * [UCX.V13.BL13.RPCKIT.B]BASE.IDL;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O 	    5 	  6 ܶ  7 @ ϓ  8          9          G #  H  J                %pascal
{*	@(#)base.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{   BASE - Basic Apollo data types and constants }

[uuid(339b18335000.0d.00.00.80.9c.00.00.00)] interface base_;

import
    'nbase.idl',
    'timebase.idl';

type   
    status_$all_t = 
        integer32;

{ Number of user processes }
   
const  
    proc1_$n_user_processes = 56;


{ Commonly used naming server constants and types }

const  
    name_$long_complen_max = 255;   { Max lnth of a single long component }
    name_$long_pnamlen_max = 1023;  { Max lnth of whole long pathname }
    name_$pnamlen_max = 256;        { Max lnth of whole pathname (obsolete; use name_$long_pnamlen_max) }
    name_$complen_max = 32;         { Max lnth of 1 component (obsolete; use name_$long_complen_max) }

type   
    name_$pname_t = 
        array [1..name_$pnamlen_max] of char;
    name_$name_t  = 
        array [1..name_$complen_max] of char;
    name_$long_name_t = 
        array [1..256] of char;
    name_$long_pname_t =
        array [1..1024] of char;
        

{ Commonly used Streams types }

const
    ios_$max = 127;                 { [0..ios_$max] valid range for ios_$id_t when in use }

    { Beware: COFF (sr10 and later default) format programs run with
      only 3 standard streams (stdin, stdout, errout) and stream 3 is
      not valid in general.  OBJ (pre-sr10 default) format programs run
      with 4 standard streams (stdin, stdout, errin, errout) but don't
      let you write to stream 2 (errout).  Unfortunately, NIDL doesn't
      allow us to do the same hair as is done "/sys/ins/base.ins.pas"
      and "/usr/include/apollo/base.h" to make this less of a problem.
      You're on your own.  This file is designed to be "right" for the
      sr10 and later world. }

    ios_$stdin  = 0;                { system-defined stream id's  }
    ios_$stdout = 1;
    ios_$stderr = 2;

    ios_$errin  = 2;
    ios_$errout = 2;

    stream_$stdin  = ios_$stdin;
    stream_$stdout = ios_$stdout;
    stream_$stderr = ios_$stderr;

    stream_$errin  = stream_$stderr;
    stream_$errout = stream_$stderr;

type
    ios_$id_t = 
        0..ios_$max;                { open stream identifier }

    ios_$seek_key_t = 
        record
            rec_adr:  integer32;
            byte_adr: integer32;
            end;

    stream_$id_t = 
        integer;                    { open stream identifier (same as ios_$id_t) }

    uid_$t = 
        [handle] record
            high: integer32;
            low: integer32;
            end;

    xoid_$t = 
        record                      { for xoids handed to mgrs by streams }
            rfu1: integer32;
            rfu2: integer32;
            uid: uid_$t;
            end;

{ User eventcount definitions  }

    ec2_$eventcount_t = 
        record
            value: integer32;       { current ec value }
            awaiters: pinteger;
            end;

    ec2_$ptr_t = 
        ^ec2_$eventcount_t;


end;
                                                                                                                                  " * [UCX.V13.BL13.RPCKIT.B]BAYBANKS.;1 +  ,    .     /    4       E                    - !   0   1    2   3      K  P   W   O     5   6    7  ϓ  8          9          G #  H  J                               3
Dineen 1 3000 569097908 569097859
guest 2 1000 613249607 613249597
*                                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [UCX.V13.BL13.RPCKIT.B]BINOP.C;1 +  ,    .     /    4 J       8                   - !   0   1    2   3      K  P   W   O     5   6  ;Mȓ  7 > ϓ  8          9          G #  H  J                 
#ifndef lint
static char sccsid[] = "@(#)binop.c	2.1     (ultrix)        7/21/89";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unixlib.h>

#include "binop.h"

void binop$add(h, a, b, c)
handle_t h;
long a, b, *c;
{
    *c = a + b;
}


                                                                                                                                                                                                                      " * [UCX.V13.BL13.RPCKIT.B]BINOP.IDL;1 +  ,    .     /    4       8                   - !   0   1    2   3      K  P   W   O     5 	  6  Q  7  $ ϓ  8          9          G #  H  J                                                                                                                                                                                                                     RPC010.B                         !  "[UCX.V13.BL13.RPCKIT.B]BINOP.IDL;1                                                                                                                          ̀             
/*	@(#)binop.idl	2.1	ULTRIX	7/21/89
 */
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/


%c
[uuid(334a2e240000.0d.00.00.31.66.00.00.00), port(dds:[19], ip:[6677]),
    version(0)]
interface binop
{                       
[idempotent]
void binop$add(
    handle_t [in] h,
    long [in] a,
    long [in] b,
    long [out] *c
    );
}
                                                                                                                                                                                                                      ( * [UCX.V13.BL13.RPCKIT.B]BINOP_BUILD.COM;1 +  ,    .     /    4 \       9                   - !   0   1    2   3      K  P   W   O     5   6 Γ  7 @3 ϓ  8          9          G #  H  J                         
$!  %W%	VMS/ULTRIX Connection	%G%
$!**********************************************************************
$!                                                                      
$!                      Copyright (c) 1989 by                           
$!              Digital Equipment Corporation, Maynard, MA  		
$!                      All rights reserved.                            
$!                                                                      
$!   This software is furnished under a license and may be used and     
$!   copied  only  in accordance with the terms of such license and     
$!   with the  inclusion  of  the  above  copyright  notice.   This     
$!   software  or  any  other copies thereof may not be provided or     
$!   otherwise made available to any other person.  No title to and     
$!   ownership of the software is hereby transferred.                   
$!                                                                      
$!   The information in this software is subject to change  without     
$!   notice  and should not be construed as a commitment by Digital     
$!   Equipment Corporation.                                             
$!                                                                      
$!   Digital assumes no responsibility for the use  or  reliability     
$!   of its software on equipment which is not supplied by Digital.     
$!                                                                      
$!**********************************************************************
$!
$!
$ write sys$output "  Generating stubs..."
$ nidl -s [.idl_d]binop.idl -idir rpc$idl:
$
$ if f$search("_vms_b.dir") .eqs. "" then create/dir [._vms_b]
$
$ define sys        sys$library:
$ define net        sys$library:
$ define netinet    sys$library:
$ define arpa       sys$library:
$ define machine    sys$library:
$ define c$include  rpc$include:, sys$library:
$
$ write sys$output "  Compiling..."
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop_cstub.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop_cswtch.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop_sstub.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] client.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] server.c
$ cc/opt/g_float/define="CC$mixed_float"/include=rpc$include/object=[._vms_b] binop.c
$
$ set def [._vms_b]
$ write sys$output "  Linking... (Ignore %LINK-W-WRNERS and %LINK-I-UDFSYM messages)"
$ link/exec=client client, binop_cstub, binop_cswtch, -
	rpc$lib:rpc$libnck.opt/opt
$ link/exec=server server, binop, binop_sstub, -
	rpc$lib:rpc$libnck.opt/opt
$
$ set def [-]
$ deassign sys
$ deassign net
$ deassign netinet
$ deassign arpa
$ deassign machine
_                                                                                                                                                                                                                    & * [UCX.V13.BL13.RPCKIT.B]BINOP_README.;1 +  ,    .     /    4                            - !   0   1    2   3      K  P   W   O     5   6 ⾄Γ  7 C ϓ  8          9          G #  H  J               
            
/* @(#)README	2.2  (ULTRIX)        7/21/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/


This directory contains a simple example of the use of RPC.  The "binop"
interface defines just one procedure which adds two numbers and returns
the result.

		* NOTE *
		--------

To make this example as simple as possible, "well-known ports"
are used.  In general, use of well-known ports is to be discouraged.  See
the section on well-known ports in the "Guide to the Network Computing
System" (NCS).  The banks example shows how to write applications that do
not use well-known ports. Because the sample uses "well-known ports" no
registrations with the location broker will be seen via lb_admin.


To run the example, run "server" as one process and "client" as another 
process, perhaps on another machine.  "server" takes one argument -- 
the integer address family the server should listen on.  "client" takes 
three arguments -- the name of the machine running the server (which may 
be expressed as #numeric_network_address), the integer address family
of the server, and the number of passes.  "client" will print out some
statistics after each pass and a sample of some calculations being
performed.

For Example:

    server 2                -- Start server listing on IP

    client somehost 2 3     -- Start client talking to "somehost"

    client #10.00.12.13 2 3 -- Start client talking to IP
				host at address 10.00.12.13.

                               (note: some shells might require that
				#10.00.12.13 be enclosed in quotes)


                                                                                                                                                                                                           E?        RPC010.B                         !  [UCX.V13.BL13.RPCKIT.B]CAL.H;1UILD.COM;1                                                                                                                    $               * [UCX.V13.BL13.RPCKIT.B]CAL.H;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O 
    5 
  6  0  7  UU ϓ  8          9          G #  H  J                   
/* @(#)cal.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*  cal.h -- marlena 88/9/28 

      Declarations of portable cal_$ procedures.

      Your application must include 'nbase.h' and 'timebase.h'
      prior to including this file.

     Gotchas:
       o The unix timeval struct is not exactly the
         same as time_$timeval_t (as defined in ubase.ins.pas)
         The field names differ. 
         This file now uses the Aegis structure.

    Changes
    01/17/89 marlena  For apollos: #include apollo/cal.h.  Also,
                      we add the signatures for those routines
                      not in apollo/cal.h (i.e cal_$*timeval* )
    01/16/89 marlena  time_$timeval_t is now the Aegis  struct, not a macro
                      for the bsd timeval struct.
    12/21/88 marlena  Changed apparent calling sequences so that all
                      'in' params appear to be called by value.
                      Changed some return values to exactly match those
                      in /usr/include/apollo/cal.h
    09/30/88 marlena 'long enum' is now 'enum'

****************************************************/

#ifndef apollo_base_h 
typedef struct {
    long sec;
    long usec;
} time_$timeval_t;
#endif

typedef enum {time_$relative, time_$absolute} time_$rel_abs_t;


/* CMP_CLOCK: Returns 1 if c1 > c2, -1 if c1 < c2, 0 if equal 
 *
 * Usage: short cal_$cmp_clock(
 *           [in] time_$clock_t c1,
 *           [in] time_$clock_t c2
 *         );
 */
extern short cal_real_$cmp_clock(
#ifdef __STDC__
    time_$clock_t *c1,
    time_$clock_t *c2
#endif
);


/* 
 * Usage: void cal_$add_clock(
 *           [in out] time_$clock_t *dest,
 *           [in] time_$clock_t src
 *         );
 */
extern void cal_real_$add_clock(
#ifdef __STDC__
     time_$clock_t *dest,
     time_$clock_t *src
#endif
);


/* 
 * Usage: boolean cal_$sub_clock(
 *           [in out] time_$clock_t *dest,
 *           [in] time_$clock_t src
 *         );
 */
extern boolean cal_real_$sub_clock(
#ifdef __STDC__
    time_$clock_t *dest,
    time_$clock_t *src
#endif
);


/* 
 * Usage: unsigned long cal_$clock_to_sec(
 *           [in] time_$clock_t clock
 *         );
 */
extern unsigned long cal_real_$clock_to_sec(
#ifdef __STDC__
     time_$clock_t *clock
#endif
);


/* 
 * Usage: void cal_$sec_to_clock(
 *           [in] time_$clock_t sec,
 *           [out] time_$clock_t *clock
 *         );
 */
extern void cal_real_$sec_to_clock(
#ifdef __STDC__
     unsigned long   sec,
     time_$clock_t *clock
#endif
);

/* CAL_$TIMEVAL_TO_CLOCK -- False if timeval- unix_offset < 0 */
/* 
 * Usage: boolean cal_$timeval_to_clock(
 *           [in] time_$rel_abs_t flag,
 *           [in] time_$timeval_t timeval,
 *           [out] time_$clock_t *clock
 *         );
 */
extern boolean cal_real_$timeval_to_clock(
#ifdef __STDC__
     time_$rel_abs_t  flag,
     time_$timeval_t  *timeval,
     time_$clock_t   *clock
#endif
); 


/* 
 * Usage: void cal_$clock_to_timeval(
 *           [in] time_$rel_abs_t flag,
 *           [in] time_$clock_t clock
 *           [out] time_$timeval_t *timeval,
 *         );
 */
extern void cal_real_$clock_to_timeval(
#ifdef __STDC__
     time_$rel_abs_t flag,
     time_$clock_t  *clock,
     time_$timeval_t   *timeval
#endif
);

#ifndef apollo
/* Declarations for non-apollos */
#define cal_$cmp_clock(c1,c2)                       cal_real_$cmp_clock(&c1,&c2)
#define cal_$add_clock(dest,src)                    cal_real_$add_clock(dest,&src)
#define cal_$sub_clock(dest,src)                    cal_real_$sub_clock(dest,&src)
#define cal_$clock_to_sec(clock)                    cal_real_$clock_to_sec(&clock)
#define cal_$sec_to_clock(sec,clock)                cal_real_$sec_to_clock(sec, clock)
#define cal_$timeval_to_clock(flag, timeval,clock)  cal_real_$timeval_to_clock(flag, &timeval, clock)
#define cal_$clock_to_timeval(flag, clock, timeval) cal_real_$clock_to_timeval(flag, &clock, timeval)

#else
#include <apollo/cal.h>
extern boolean cal_$timeval_to_clock (          
        time_$rel_abs_t         &flag,
        time_$timeval_t         &timeval,
        time_$clock_t           *clock
        );

extern boolean cal_$clock_to_timeval (          
        time_$rel_abs_t         &flag,
        time_$clock_t           &clock,
        time_$timeval_t         *timeval
        );

#endif
e                                                                                                                                                                                                                                                      ! * [UCX.V13.BL13.RPCKIT.B]CLIENT.C;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 
  6 Mȓ  7 g ϓ  8          9          G #  H  J                
#ifndef lint
static char sccsid[] = "@(#)client.c	2.1     (ultrix)        7/21/89";
#endif

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifdef MSDOS
#include <time.h>
#include <sys\types.h>
#else
#include <sys/time.h>
#include <sys/types.h>
#endif

#ifdef vms
#include <sys/stdio.h>
#include <sys/math.h>
#include <sys/stdlib.h>
#include <sys/unixlib.h>
#endif 

#include "base.h"
#include "rpc.h"

#include "binop.h"

#define CALLS_PER_PASS 100

extern uuid_$t uuid_$nil;

main(argc, argv)
int argc;
char *argv[];
{
    int k;
                                                                                                                                                                                                                                                           ?ˤ|        RPC010.B                         !  ![UCX.V13.BL13.RPCKIT.B]CLIENT.C;1                                                                                                                           ^                 int passes;
    long i, n;
    handle_t rh;
    socket_$addr_t loc;
    long llen;
    status_$t st;
    int start_time, stop_time;
#   define ERRTXTLEN 128
    char errtxt[ERRTXTLEN];
    char *errtxtp;
    extern char *error_$c_text();

    if (argc < 4) {
        fprintf(stderr, "usage: client hostname family passes\n");
        exit(1);
    }

    passes = atoi(argv[3]);
    
    rpc_$name_to_sockaddr(argv[1], (long) strlen(argv[1]), (long) rpc_$unbound_port, (long) atoi(argv[2]), 
        &loc, &llen, &st);
    if (st.all != status_$ok) {
        errtxtp = error_$c_text(st, errtxt, sizeof(errtxt));
        fprintf(stderr, "Can't convert name to sockaddr, %s\n", errtxtp);
        exit(1);
    }

    rh = rpc_$bind(&uuid_$nil, &loc, llen, &st);
    if (st.all != status_$ok) {
        errtxtp = error_$c_text(st, errtxt, sizeof(errtxt));
        fprintf(stderr, "Can't bind, %s\n", errtxtp);
        exit(1);
    }

    for (k = 1; k <= passes; k++) {
        start_time = time(NULL);

        for (i = 1; i <= CALLS_PER_PASS; i++) {
            binop$add(rh, i, i, &n);

            if (n != i+i)
                printf("Two times %ld is NOT %ld\n", i, n);
	    else {
		if (!(n%16))
			printf("Client: 2x%ld = %ld\n",i,n);
	    }
        }

        stop_time = time(NULL);

        printf("pass %3d; real/call: %2d ms\n", 
               k, ((stop_time - start_time) * 1000) / CALLS_PER_PASS);
    }
}
*                                                                                                                                ! * [UCX.V13.BL13.RPCKIT.B]CONV.IDL;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 	  6 6  7 `mx ϓ  8          9          G #  H  J                {*	@(#)conv.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{ Conversation Manager (conv) Interface }

[uuid(333a22760000.0d.00.00.80.9c.00.00.00), version(3)] 
interface conv_;

import 
    'nbase.idl';

{   C O N V _ $ W H O _ A R E _ Y O U

    This procedure is called by a server to a client when the server has
    just received a call from a client about whom it knows nothing.  The
    server passes the server's boot time back to the client so that a new
    incarnation of a crashed server is making the call back (and so the
    client can use the server's boot time in subsequent calls). }

[idempotent] procedure conv_$who_are_you(
                            in      h:          handle_t;
                            in ref  actuid:     uuid_$t;
                            in      boot_time:  unsigned32;
                            out     seq:        unsigned32;
                            out     st:         status_$t
                            );

end;

                                                          * [UCX.V13.BL13.RPCKIT.B]ERROR.H;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 
  6    7 ༊ ϓ  8          9          G #  H  J                 
/* @(#)error.h	2.4  (ULTRIX)        12/11/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
 * Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
 * Copyright Laws Of The United States.
 * 
 * Apollo Computer Inc. reserves all rights, title and interest with respect
 * to copying, modification or the distribution of such software programs
 * and associated documentation, except those rights specifically granted
 * by Apollo in a Product Software Program License, Source Code License
 * or Commercial License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between
 * Apollo and Licensee.  Without such license agreements, such software
 * programs may not be used, copied, modified or distributed in source
 * or object code form.  Further, the copyright notice must appear on the
 * media, the supporting documentation and packaging as set forth in such
 * agreements.  Such License Agreements do not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * ========================================================================== 
 *
 * Definitions of types/constants for error text database routines.
 *
 * The database consists of two major pieces -- a header and a text
 * section.  The text section consists of a collection of "module tables".
 * The text section begins immediately after the header.
 *
 * The header is a table mapping from [subsystem, module] into the offset
 * from the beginning of the file (into the text section) of the
 * subsystem/module's module table.  Only valid [subsystem, module]
 * pairs appear in the table.
 *
 * A module table contains the number of the lowest and highest error
 * codes for that module, the text name of the module and the text name
 * of the subsystem.  (Yes, the same subsystem name thus appears in
 * multiple places.)  Following this information is the text of all
 * the module's error codes, in order separated by NULL characters.
 *
 * Note that all integers are stored in big-endian (most significant byte
 * at lower offset) format.
 *
 * Format of error database:
 *
 *              |<------ 16 ----->|
 *      
 *              +-----------------+                      
 *                                                                                                                                                                                                                             	                        .        RPC010.B                         !   [UCX.V13.BL13.RPCKIT.B]ERROR.H;1;1                                                                                                                          8                 |                 |
 *              +     version     +
 *              |                 |
 *              +-----------------+
 *              |                 |
 *              +  header size    +   Number of header entries that follow
 *              |                 |
 *              +--------+--------+
 *              | subsys   module |   Header entry #0
 *              +--------+--------+
 *              |       pad       |
 *              +-----------------+                      
 *              |                 |
 *              +      offset     +
 *              |                 |
 *              +-----------------+ 
 *              | subsys   module |   Header entry #1
 *              +--------+--------+
 *              |       pad       |
 *              +-----------------+    
 *              |                 |
 *              +      offset     +
 *              |                 |
 *              +-----------------+ 
 *              | subsys   module |   Header entry #2
 *              +--------+--------+
 *              |       pad       |
 *              +-----------------+
 *              |                 |
 *              +      offset     +
 *              |                 |
 *              +-----------------+     
 *      
 *              :                 :
 *      
 *              :                 :
 *      
 *              +-----------------+     
 *              |    min code     |   Module table #0
 *              +-----------------+
 *              |    max code     |
 *              +-----------------+
 *              |                 |
 *              :   subsys name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              :   module name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              |   error text    |
 *              :    strings      :
 *              :    sep'd by     :
 *              :     nulls       :
 *              |                 |
 *              +-----------------+
 *              |    min code     |   Module table #2
 *              +-----------------+
 *              |    max code     |
 *              +-----------------+
 *              |                 |
 *              :   subsys name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              :   module name   :
 *              |   (64 bytes)    |
 *              +-----------------+
 *              |                 |
 *              |   error text    |
 *              :    strings      :
 *              :    sep'd by     :
 *              :     nulls       :
 *              |                 |
 *              +-----------------+
 *
 */


/*
 * Where the binary error data base lives.
 */

#define ERROR_VERSION 1

#if ! defined(UNIX) && (defined(apollo) || defined(BSD) || defined(SYS5))
#  define UNIX
#endif

#ifdef UNIX
#  ifdef apollo
#    define ERROR_DATABASE "/usr/apollo/lib/stcode.db"
#  else
#    define ERROR_DATABASE "/usr/lib/stcode.db"
#  endif
#endif

#ifdef vms
#  define ERROR_DATABASE "rpc$exe:rpc$stcode.db"
#endif

#ifdef MSDOS
#  define ERROR_DATABASE "\\ncs\\stcode.db"
#endif

/*
 * MAX_SUBSYS and MAX_MODULE are the highest values that a subsys or module code
 * can take on.
 */

#define MAX_SUBSYS 0x7f
#define MAX_MODULE 0xff


/*
 * MAX_SUBMODS is the maximum number of valid [subsystem, module] pairs we can
 * hold.
 */

#define MAX_SUBMODS 1024


/*
 * The header.  Consists of the "header header" (version and count) and "count"
 * number of "header entries".
 */

struct hdr_hdr_t {
    long version;
    long count;
};

struct hdr_elt_t {
    short submod;
    short pad;
    long offset;
};

struct hdr_t {
    struct hdr_hdr_t h;
    struct hdr_elt_t ents[1];
};

/*
 * The header of a module table.
 */

struct modhdr_t {
    short min_code;
    short max_code;
    char ss_name[64];
    char mod_name[64];
};


#if defined(vax) || defined(i8086) || defined(mips)

#define swab_16(p) { \
    register char t; \
    t = ((char *) (p))[0]; \
    ((char *) (p))[0] = ((char *) (p))[1]; \
    ((char *) (p))[1] = t; \
}

#define swab_32(p) { \
    register char t; \
    t = ((char *) (p))[0]; \
    ((char *) (p))[0] = ((char *) (p))[3]; \
    ((char *) (p))[3] = t; \
    t = ((char *) (p))[1]; \
    ((char *) (p))[1] = ((char *) (p))[2]; \
    ((char *) (p))[2] = t; \
}

#else

#define swab_16(p)
#define swab_32(p)

#endif 
                                                                              " * [UCX.V13.BL13.RPCKIT.B]FAULT.IDL;1 +  ,    . 
    /    4   
   	                    - !   0   1    2   3      K  P   W   O     5 	  6 {  7  ϓ  8          9          G #  H  J                   
            %pascal

{*	@(#)fault.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{   FAULT - Apollo-assigned 32-bit fault status codes. }


[uuid(404a5e8e1000.0d.00.01.8f.a1.00.00.00)] interface fault_;

const
    fault_$address_error        = 16#00120001;
    fault_$illegal_inst         = 16#00120002;
    fault_$zero_divide          = 16#00120003;
    fault_$chk_inst             = 16#00120004;
    fault_$trapv_inst           = 16#00120005;
    fault_$priv_violation       = 16#00120006;
    fault_$illegal_svc_code     = 16#00120007;
    fault_$illegal_svc_name     = 16#00120008;
    fault_$undefined_trap       = 16#00120009;
    fault_$unimplemented_inst   = 16#0012000A;
    fault_$prot_violation       = 16#0012000B;
    fault_$bus_timeout          = 16#0012000C;
    fault_$illegal_usp          = 16#0012000D;
    fault_$eccc                 = 16#0012000E;
    fault_$eccu                 = 16#0012000F;
    fault_$quit                 = 16#00120010;
    fault_$access_violation     = 16#00120011;
    fault_$not_valid            = 16#00120012;
    fault_$nullproc_onb         = 16#80120013;
    fault_$display_quit         = 16#00120014;
    fault_$single_step          = 16#00120015;
    fault_$invalid_user_fault   = 16#00120016;
    fault_$pbu_user_int_fault   = 16#00120017;
    fault_$stop                 = 16#00120018;
    fault_$blast                = 16#00120019;
    fault_$cache_parity         = 16#0012001A;
    fault_$wcs_parity           = 16#0012001B;
    fault_$not_implemented      = 16#0012001C;
    fault_$inva                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                                RPC010.B                         !  "[UCX.V13.BL13.RPCKIT.B]FAULT.IDL;1.COM;1                                                                                           
                                      lid_stack        = 16#0012001D;
    fault_$parity               = 16#0012001E;
    fault_$interrupt            = 16#0012001F;
    fault_$while_lock_set       = 16#00120020;
    fault_$spurious_parity      = 16#00120021;
    fault_$fp_inexact           = 16#00120022;
    fault_$fp_div_zero          = 16#00120023;
    fault_$fp_undflo            = 16#00120024;
    fault_$fp_op_err            = 16#00120025;
    fault_$fp_ovrflo            = 16#00120026;
    fault_$suspend_proc         = 16#00120027;
    fault_$suspend_proc_kbd     = 16#00120028;
    fault_$suspend_proc_br      = 16#00120029;
    fault_$suspend_proc_bw      = 16#0012002A;
    fault_$continue_proc        = 16#0012002B;
    fault_$fault_lost           = 16#0012002C;
    fault_$illegal_coproc       = 16#0012002D;
    fault_$fp_bsun              = 16#0012002E;
    fault_$fp_sig_nan           = 16#0012002F;
    fault_$parity_bad_thread    = 16#00120030;
    fault_$illegal_page_fault   = 16#00120031;
    fault_$cpub_bus_error       = 16#00120032;
    fault_$spurious_interrupt   = 16#00120033;
    fault_$cold_start_bus_error = 16#00120034;
    fault_$cleanup_set          = 16#00120035;
    fault_$cleanup_rls_out_order= 16#00120036;
    fault_$ac_power_fail        = 16#00120037;
    fault_$fp_parity            = 16#00120038;
    fault_$fp_unknown_vec       = 16#00120039;
    fault_$be_on_be             = 16#0012003A;
    fault_$io_chan_chk          = 16#0012003B;
    fault_$breakpoint           = 16#0012003C;
    fault_$translate_error      = 16#0012003D;
    fault_$illegal_lock         = 16#0012003E;
    fault_$lock_timeout         = 16#0012003F;
    fault_$unknown_status       = 16#00120040;
    fault_$fp_exception         = 16#00120041;
    fault_$fp_fpu_internal_error= 16#00120042;
    fault_$pause                = 16#00120043;
    fault_$halt                 = 16#00120044;
    fault_$trap_on_trap         = 16#00120045;
    fault_$unaligned_inst       = 16#00120046;

end;
-                                                                                                 * [UCX.V13.BL13.RPCKIT.B]GLB.H;1 +  ,    . 
    /    4   
   
 3                    - !   0   1    2   3      K  P   W   O     5 	  6 M  7 @խ ϓ  8          9          G #  H  J                   
/* @(#)glb.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef glb__included
#define glb__included
#include "idl_base.h"
#include "rpc.h"
#include "nbase.h"
static rpc_$if_spec_t glb_$if_spec = {
  4,
  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  4,
  {
  0x333b2e69,
  0x0000,
  0,
  0xd,
  {0x0, 0x0, 0x87, 0x84, 0x0, 0x0, 0x0}
  }
};
#define lb_$mod 469893120
#define lb_$database_invalid 469893121
#define lb_$database_busy 469893122
#define lb_$not_registered 469893123
#define lb_$update_failed 469893124
#define lb_$cant_access 469893125
#define lb_$server_unavailable 469893126
#define lb_$bad_entry 469893127
typedef ndr_$ulong_int lb_$server_flag_t;
#define lb_$server_flag_local 1
#define lb_$server_flag_reserved_02 2
#define lb_$server_flag_reserved_04 4
#define lb_$server_flag_reserved_08 8
#define lb_$server_flag_reserved_10 16
#define lb_$server_flag_reserved_20 32
#define lb_$server_flag_reserved_40 64
#define lb_$server_flag_reserved_80 128
#define lb_$server_flag_reserved_0100 256
#define lb_$server_flag_reserved_0200 512
#define lb_$server_flag_reserved_0400 1024
#define lb_$server_flag_reserved_0800 2048
#define lb_$server_flag_reserved_1000 4096
#define lb_$server_flag_reserved_2000 8192
#define lb_$server_flag_reserved_4000 16384
#define lb_$server_flag_reserved_8000 32768
#define lb_$server_flag_reserved_10000 65536
#define lb_$server_flag_reserved_20000 131072
#define lb_$server_flag_reserved_40000 262144
#define lb_$server_flag_reserved_80000 524288
typedef ndr_$ulong_int lb_$lookup_handle_t;
#define lb_$default_lookup_handle 0
typedef struct lb_$entry_t lb_$entry_t;
struct lb_$entry_t {
uuid_$t object;
uuid_$t obj_type;
uuid_$t obj_interface;
lb_$server_flag_t flags;
ndr_$char annotation[64];
ndr_$ulong_int saddr_len;
socket_$addr_t saddr;
};
extern  void glb_$insert
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void glb_$delete
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
#define glb_$max_lookup_results 400
extern  void glb_$lookup
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void glb_$find_server
#ifdef __STDC__
 (
  /* [in] */handle_t h);
#else
 ( );
#endif
typedef struct glb_$epv_t {
void (*glb_$insert)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*glb_$delete)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*glb_$lookup)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*glb_$find_server)
#ifdef __STDC__
 (
  /* [in] */handle_t h)
#else
()
#endif
;
} glb_$epv_t;
globalref glb_$epv_t glb_$client_epv;
globalref glb_$epv_t glb_$manager_epv;
globalref rpc_$epv_t glb_$server_epv;
#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             * [UCX.V13.BL13.RPCKIT.B]GLB.IDL;1 +  ,    .     /    4                           - !   0   1    2   3      K  P   W   O 
    5 	  6    7  ϓ  8          9          G #  H  J                                                                                                                                                                                                                                                                  bu                                          !  )[UCX.V13.BL13.RPCKIT.B]AWQ)G1)>;
1.COM;1                                                                                           
                         5            9l
/Ncyek0,WV(7OS`EvPH!IEBk<'E\kd~^4&{b-$3c-;Py_8El!ZMmqli
6cxaxBczN2i90)y{&#OX%A\C)S@_~mb5RB"Kkpkl/)3xLBC7 }RW|0ywM( 3m~6DVw9z?xe> Kq}>X(LOvJZ<THaJlGo0(Mo}P4x\zQgmsJF
}NHt9XA(n`ڊ-71_Vl/	_YLw"@yg&nZV=ij%4f[SJuCsRJ(b@~H*p2MTa}o]!!wL-O@\h S<EAba(4U$P/E-Ba{j#%?o3M<wNG%o9^Xua%@jK(v<ICgBnHTt]arO(t$
@?!zSJ6Hw||"Z3-"C=P[v[E,,+2SO;YO$4
@EGFK#jF^?AHGD;6"bPdNoKR`" "K$	c05L^h'n"Zd$7~Nu54Glo~EXv(s ws3hv~99V
RxMaG|f)M]
qJu|]vYo$DBKdf+ gS309r'DzRGa:-Z>A"4.$_%vPM(
Y	,|U m1k90YT"/;59*z|3p8%`j9d,C0_KoN3!=n2dUhrLw|eM
^2^C )Lyye~3:-&0LTzg=i>9gMt>x/c.JЈ5ND6)Ճ"ZnV"KVY6\%I;mF47}/qGwYP)ym(z>,3d*8BH*),}NJ@E+.m:zwq0:{fRoI'@+&(
oVoW<3 rvbe"Gi6c.5zNCS\"Dax7|gt","%H97P >vp{b{|6BP
 6X01P\H$*3
 =r^Kft\@ qQ^,+]la\ffFw$"7w}	h	-TAzL6p@%>x1c,dgT'H1C5
%_CfX 
W1N'J&dCQ+CXA*]"J{[PI.A/RQn>fn#qZgakkEjaS,`=R(}	ENKp-+BKFYT'<WBwG\VoO	GKRH8`!]N%#>`F F$KWOM.@!/s
ToE8GNRa
8p4Zx U|LvMjo=?;])v)L /W	O^	}OU06L;aQKe1#APFGF:
Dh52vT0diC,-K^J.?cH@\WD5xfwkkLIsnFPbj&Ij1\OOG`<IT|#4	;"i}d9s
5f08|0-zHF
9qG`U-/,#C[e[6h)v3Q%&&	AAMa28E7Gg	{FEQ'S]!'{pz>44];U1Mtc#@Dw52;o t23f]flqvBd,:O*8U 0;c 'e2Ii&Pjrk\J	)8AJ
<~OPwQaFfEm-u^(U@n[I\B!TAT[qha5aZ#YKSI*\N1Q,^]e|<q5 2FLw]Ki8MG oSR_kDpsv- 3dOhz_r3}</n&*G~||jlt}w+h3V+ZxP-H>?E4*bHF+><XLhK0@.{OD'_OmJ~-@Pr1H9Sq,7}v%(VlR
9:-Fj%M$_1GEL7=iG,|$,,3C!KLW#;brt5zo_bTy-\S?)z'S^e
 qs[;
/,7y2(G\AdBWaGTOFEYd^@mC.\4$\!3gQӖ!+OAAzUBB'X&x
P?)%1 }QBK]xNU+-%$
TSGR.qN8[k}K*zwuN jX-1LTVJT5ZkM>zGVPY
kUVyd:z"~Fp32K\4]V	? 
Ug'o<^Fm-7CSZRE 6k&%ExI)V@l_I_PDErXKz22>ELRVN[TN4zsKE)FE,$bV~
Od i~
VGL.*\
@8K7+6 c@]v'f}drI7dqE<X4FGVE9dMOcW-lD75 x72}G:g-e}En^\,bHA;:YMD~!ND{|HODq/XpP9;-B!285&J<7#H| !b^akC=#P2c$gKyAK[C+q!r!3"6 '=1pg*^-V(s[Z`ki'8/^$|fxVbZJ\^vrl`s6U+/Z(>+@X2s-dAp4- *z/|3
= -psU<\)v~7sKuql%6hTpXyn4?X ;Fs96[>$;~Kz=05/@_()m)	\*Q-15`EOl/4M|mD",un7"_6urZlQ^:{&m#Zwz$@$J/8IrLaF<IN=P=;{^R.we1u1Q&.==.,q,ABY50@(~$t;c,,Zt 8z;Hx9$}p*{/K9r*8wGi3-c\*	N3^C
'aNVIM0+B$\
MI!8d8+\!.zL"Cb1o
8e1DhZ>e}ntSn}3v	Xo_u`-<#	<HD7ZMLY!Rr@a<Cv@pSSB"P'+!l <^+psx;hGgmPvQogwejmkE"U4!
Dr\1T#J)6'`Z\rdfq];p2M$M BL}\$w3@x4/7o
q|)z;W4ZD7*s _Yys6dM$*(d|<+q(5c$y7#|)A-+3$X0'PhJ<g
=r}kBW+]kwf38dp/s)xR_W?E7h*
nwO5j'W9"bcxA!j)ah"}lkGU"70r!"fi"2!FQO|Y Q$mo@9!-40<gBTg+"h9ms29E/(zuD[u+
d*Nyq09W
%('T-.y${ m8QaFPJTN fB3P7"]KF6	`97!2=}X\\MOhFqwH:Lrz%vhzg+fJ0)=g'cYvqUu#]7XUFnDc-'hc'y;
.
k@&jZOp56*H\IyAZ0m*0o& +.)Rc-m^eP:Y~UcgIW4}UJ`J{T	JGS dF,'o_:
o UjH13* -JDV&Eg,r?-y+Jq{*&6!JKMQM
9 $jet^Z,W5@S=jeItn#bj0@^[802EWMl'5	N)@;OM]f`	|jXpO2y~Ntg3y.rw^XWbyMG~HL1'Uz i;be-*[\YQxC
.}[pv)(o^e<ek>0EN#._[&Ujo_<yTH=&xZ	Cz9YZ\.VJ^=]Qik>9kY'!-%5Uv,?Z3hI#l^PGFfxg^#("-sew2AtNg/5pjtQ1cs+_sr_XK`-Y/O>[?_~~ehE	b=xw+JBzEBfSR^ixx49S+l)^D":nVz<<;L6pPM=ThzLPL!EQ TeQ\>;0S5k0Fx?G88MBSTMp~ j. D|;P
$%U^G?i. 53w8	.9OrXf"IL (P#u(Fg]/I
S~}N7l0!{JGC]9wuKwwgG9PWe.)#]KWo
KXx_Y\h<bjs
Mh62@Dx]IbqhCDV1p/
JeQTTG9
R'	~tEK'X;	(tBdu Fi
:"8eTGZC x?BeoaIZBfIgg4:Zp>LKF;<U,rZq_
fCmAl]~ZMcEL_c#Fd?e(kdrUEE\SGN<ouG_,I2ZOVW;Zq{/B:
--ZWh
j<o:GmH;PGh}rG7n\RcB"3Lj&t3Yl@he&-:NMM%-
b| _0r+&C$
)@cOqq5
4E]E'@CRI,J
=(q9q	}p8FxGca2\>s!6tD'VIQq-b=E<i
yO*Z1#1GJ/M ,.Dp_g%h{jUV'Iz`ys/Xz;~|rkGt59s|yzoQv	AM_ E` $u*[2d;#[Ai<E{)c$q7EfV0Vc(0[R7+P+k>nE9G&i?$^x\:#d2Z!.IN9ia6wõIn
E4h+	'X1@40qDfb84 +~G?ufq-hHeʁl[/CnP7$MS=[P>~3f/s/g?tdyxVe:[ZR\D5kY,tSY{&,vTB' 2UN2Z:[#M[s
0Gq&TUe|+8QbH\Up<\X$tN%RBxqt
z{jhlt);4m%Q
[])5O12W4o+[/hf$=B0#\FRB$y)UF_s`vWOEk.c2W}`65cRK^,{h4nQ|\;6gTC?co}eY^@$%3^D1jj;]6GvP 9_<o	UJ*zivnsL|&t3Z$	qO!TQTu!v:X2"22Ou.?' ;-Bi&e [/%[
k#f-i)S!"6SwB\Xx9nVj: n#A
5_.@[:U d[
E<%zkYy~j@m\!XWB84YqK!x7!{fmkfr 
@w, jq)7U3y`vF{ap[	YVgCn
FL%KTKJqhF	_y./9  P`MRR>#R0k	TJ&=G3,*3V.x3qPxlQ+?ZMRDd=pGH_Aap
'->
H"O,MdT~^	cHLdzvhw20w'D\~$(G7"|_GkO
5+7 $n+6
MyJC;t^=7	;~S&_nq7j'f/R
dTuuEn}1_!5`a 5|;&v7}ZMZG_\kC{|@a~#'Sk?Yzv[b*MC<P5G:gNQagl	py0
`Yb4H2I}VLex};T rQ 5W U.lrf4g+<
h>|g%>!WkdPfG@A>
^>OrRV5ZS&:FJ> c357ED!$VMN@\,<rUT<uR=91 7:|6"vbra^,<mB
q1ogd5gn=[Mu^h3ggHZW0A
^?1076uhYKV8PMOR`nm9Re`Z[+#[2c"OR!yPgtETB&ujQa
WFm4'9S٥(ɝȼ܍vhzQ{t('-4
! 0OMo)V#DD+O8 o1jrX qTR|vzi\$vRBA=$:b4llt6/l=EFkAkaRd|sj5_fx?	n2]x./V`:sk~UF:L}VX	a&$k={p3}OvW"T|80\ _W77/:gh,klm~^;AZ9%?{]N9 GLM^rL+Zp/	]z&@7a0x<|b/"%VA\C<ZC[%L)57f &ekV `Q
tF6
rRpTX}Cxev^;yc@5L2%Oof-=`t SkWqdGvp;S2Xe+2y^<
	jf#+3|8)G+qs%Wk+Kj{LX+>Gn 	%L{n`?
.s"_Ot$vY85YwhJ#wW5:C_r
;6{K'
9u*nK@-;{*`A{|{ ':
+*2A3"0UkdCa}g(qCo1c1mP+Wp&ag7[8IN	ut]EIXNbZQ.wrHWlF=<9bRp~N!T!]192kv6w  ps{+J"va(&uL0`pk(srjZ2o{$ArwEpbai+ x
Q\V;lI(J'tV`'fF|:M
iJA[Z\#dIoM*I"8(wLEG35!}2cJ(
jsMsJOMAV; NvhOQv=Ud9Y8awR4z>`|H,XF+.,[S:0#i(7^%CvHK>xu-BU58`4A|dS<HEOW81z\FQ1\@c>'GJQlr{8Yoa"V{%?R'Y]m	8U<5]6Tr`vdWo-Sז&8\!B4 (g;ir:5)'KsMmN,\tr&lO=ze.>#c,W2@U
z'X Xx
_>Rdiv.zzgn9/<h+%p2)nx=;[^"M
(F'"aJkW}+;(lX
hj/qMF(&7zD-hY9 mfm~%|KMQlB<p@-g-4LOA"jΠ ]q%xmUk|YGpuY8Y+9NRWyi{lJ,8Gkڞ
T@vT0S(JOJ?Aq (s5  7
6CPNw&M[?%zRyXZg8
gZmK6a}>.b]1}@*^~% wkxR2Zs6]1Ihs)B"%/UsEjj`PU=-6UOUD^!3N#\sk]X=(h:.te^e@o	10Ncwh+
RCRGH8@Z"G!\S`SU"{rysYy/l-c
=
*˧_eCT/@Fr1tEn	v]a7->7}B	CBWEi ":E@Lo=E"<*MN BvMF~UhfmQ)r0'`R`.y8$J^tc  ir:P8p\DOXk[[!w>A(wb--f+63T$K0d+^Z$1`KFi'ev,ulV+`rG n3?m&mg }3'$=\V	GO4L/kMT/;>(fMb9wsGoYzx
&}r )QPw:~&mYg1'zD$g|H,ID6%fo
};+Tu<B47x@g8CI?WiAWho[ARJ4y)=QvcI*Ytf1w^bryU\4o=lNn2rK DhZ0ZkDvdNXW:	IDL?U; .D^f0lyGZ96"e7lKvcRHYFfOYH_VkW@[Se"t&]a$`:} ]Z@iG1 M?-~v
,c.1
V"m:?s!ys7<-Yr(sC&;< /=!v@OGOjAamH6 8f1s@zAPeU#	YCa wYzvh]zN3x"/vH"qmS@yq{=c.RohA!YlP&Q1G	!!W<7Laxw#[:2`Ti5xfR{~yTzRњ؜Je,eP |4[pSsK3
fNa0Q)?3/5ahi jf1oL3 d-
iR@vVD7BeCp=<
,	UHKf~"]>IbKewb&:2y]_agRHZ	vTUW5TfO%eP[iLyzuwsl^QkI'z6bt	WAcs,([Jn`C	{XHh]4f&MKTDXff(<K :%o
i)2:ddwk 3YO4$\r\} O/W=( IFA@yq]{s0t[0VX m{I=5,{"%HxvyH3c8q+d*xcLk{I6'?>z  {K3"
!R12{9`k3&8n*u>,xo=HG&_oP~g1Cm `d34iqGK-5giz'
Hx(]0XFuH$f'HsC_YM,cn:FVKClDl3pv3'}i
*\!gB(sP!p,; &g%YwC;%=@	%H;{OQFZ9/}FAkOKZe*	1ttH*H]
rXVIK~%;8  VL+b
_+vV 5sP,s|u#
G=#b
d=HtM'=SJEn&6\?g7%($jv/%vMC&{Mn=%
vxWU4Mn|}}pWpmhYHRuIY&x5cv.*s'y>kZ'raR
7w^3mu8&lYLu<`1|]
Jh,lJ^gDdsp0!+Bsi s}]4k faRdPɟ1< hREo
S&DrW. :%^Tgc
BR1N	tJ\5uxu~Z]b_GE
 
Q7KDG o"q=oq)@

                                                                                                                                                                                                          1]%}        RPC010.B                         !   [UCX.V13.BL13.RPCKIT.B]GLB.IDL;11                                                                                                                           E.             {*	@(#)glb.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}

{ GLB - Global Location Broker }

[
        uuid(333b2e690000.0d.00.00.87.84.00.00.00),
        version(4)
] 
interface glb_;

import 
        'nbase.idl';


const
        lb_$mod = 16#1C020000;                  {* LB module code *}

        lb_$database_invalid    = 16#1C020001;  {* lb_$mod + 1; *} {* database format out of date *}
        lb_$database_busy       = 16#1C020002;  {* lb_$mod + 2; *} {* database in use in an incompatible manner *}
        lb_$not_registered      = 16#1C020003;  {* lb_$mod + 3; *} {* no matching entry available *}
        lb_$update_failed       = 16#1C020004;  {* lb_$mod + 4; *} {* unable to complete registration operation *}
        lb_$cant_access         = 16#1C020005;  {* lb_$mod + 5; *} {* can't access database *}
        lb_$server_unavailable  = 16#1C020006;  {* lb_$mod + 6; *} {* can't reach location broker *}
        lb_$bad_entry           = 16#1C020007;  {* lb_$mod + 7; *} {* bad socket address *}
		
type
        lb_$server_flag_t = unsigned32;

const 
        lb_$server_flag_local          = 16#00001;
        lb_$server_flag_reserved_02    = 16#00002;
        lb_$server_flag_reserved_04    = 16#00004;
        lb_$server_flag_reserved_08    = 16#00008;
        lb_$server_flag_reserved_10    = 16#00010;
        lb_$server_flag_reserved_20    = 16#00020;
        lb_$server_flag_reserved_40    = 16#00040;
        lb_$server_flag_reserved_80    = 16#00080;
        lb_$server_flag_reserved_0100  = 16#00100;
        lb_$server_flag_reserved_0200  = 16#00200;
        lb_$server_flag_reserved_0400  = 16#00400;
        lb_$server_flag_reserved_0800  = 16#00800;
        lb_$server_flag_reserved_1000  = 16#01000;
        lb_$server_flag_reserved_2000  = 16#02000;
        lb_$server_flag_reserved_4000  = 16#04000;
        lb_$server_flag_reserved_8000  = 16#08000;
        lb_$server_flag_reserved_10000 = 16#10000;
        lb_$server_flag_reserved_20000 = 16#20000;
        lb_$server_flag_reserved_40000 = 16#40000;
        lb_$server_flag_reserved_80000 = 16#80000;

type
        lb_$lookup_handle_t = unsigned32;

const
        lb_$default_lookup_handle = 0; 

type
        lb_$entry_t = record 
        {* uuid_$nil == wildcard in each of the object_spec fields *}
                object          : uuid_$t;
                obj_type        : uuid_$t;
                obj_interface   : uuid_$t;
                flags           : lb_$server_flag_t;
                annotation      : array [0..63] of char;
                saddr_len       : unsigned32;
                saddr           : socket_$addr_t;
                end;

{*
** glb_$insert - add the specified entry to the global database.
*}
procedure
    glb_$insert (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** glb_$delete - remove the specified entry from the global database.
*}
procedure
    glb_$delete (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

const
        glb_$max_lookup_results = 400; {* max size of the result_entries array in lookup *}

{*
** glb_$lookup - perform a lookup operation on the global database.  Due to current
**              restrictions on the maximum packet size used by the rpc runtime, 
**              the maximum number of results is defined in glb_$max_lookup_results
*}
[ idempotent ] procedure 
    glb_$lookup (
        in      h               : handle_t;
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1..* ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** glb_$find_server - this routine is used by the location server client
**              agent to find a global server that is in service.  It is
**              normally implemented as an empty stub.
*}
[ broadcast ] procedure
    glb_$find_server (
        in      h       : handle_t
    );

end;
                                                                                                                                                                                                                                                                                                             # * [UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1 +  ,    . P    /    4   P   P ?                   - !   0   1    2   3      K  P   W   O Q    5 
  6  >  7  g ϓ  8          9          G #  H  J                              
/* @(#)idl_base.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
 * Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
 * Copyright Laws Of The United States.
 *
 * Apollo Computer Inc. reserves all rights, title and interest with respect 
 * to copying, modification or the distribution of such software programs and
 *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                        3SF        RPC010.B                         !  #[UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1                                                                                                P                         KG              associated documentation, except those rights specifically granted by Apollo
 * in a Product Software Program License, Source Code License or Commercial
 * License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between Apollo and 
 * Licensee.  Without such license agreements, such software programs may not
 * be used, copied, modified or distributed in source or object code form.
 * Further, the copyright notice must appear on the media, the supporting
 * documentation and packaging as set forth in such agreements.  Such License
 * Agreements do not grant any rights to use Apollo Computer's name or trademarks
 * in advertising or publicity, with respect to the distribution of the software
 * programs without the specific prior written permission of Apollo.  Trademark 
 * agreements may be obtained in a separate Trademark License Agreement.
 * ========================================================================== 
 */


/*
 * This file is #include'd by ALL C files emitted by the NIDL compiler.
 *
 * This file serves two roles:  (1) It defines various primitives that
 * are missing from C but present in NIDL (e.g. booleans, handles); (2)
 * It defines certain things referred to by generated stub code.
 */

/************************** Preprocessor variables *************************/ 

/* 
 * The following variables are defined by the environment somehow:
 *
 *   MSDOS
 *       Means that the system is MS/DOS compatible.
 *   i8086
 *       Means that the system uses an i8086 cpu.
 *   cray
 *       Means that the system is CRAY/Unicos compatible.
 *   vaxc
 *       Means that the system is VAX/VMS compatible.
 *   apollo
 *      Means that the system is an Apollo.
 *   __STDC__
 *      Means that ANSI C prototypes are enabled.
 *   NIDL_CSTUB
 *      Means that a NIDL generated client stub is being compiled.
 *   NIDL_SSTUB
 *      Means that a NIDL generated server stub is being compiled.
 *
 * The following variables are defined (and undefined) within this file
 * to control the definition of macros which are emitted into header
 * files and stub code by the NIDL compiler.  For each variable there
 * is a set of default definitions which is used unless a target system
 * specific section #undef-s it and supplies an alternate set of
 * definitions.  Exactly which macro definitions are governed by each
 * variable is listed below.
 *
 *   USE_DEFAULT_NDR_REPS
 *      Controls the definition of the macros which assign a particular
 *      target system type to each NDR scalar type.  The following macros
 *      need to be defined if USE_DEFAULT_NDR_REPS is #undef-ed:
 *          ndr_$boolean
 *          ndr_$false
 *          ndr_$true
 *          ndr_$byte
 *          ndr_$char
 *          ndr_$small_int
 *          ndr_$short_int
 *          ndr_$long_int
 *          ndr_$hyper_int
 *          ndr_$usmall_int
 *          ndr_$ushort_int
 *          ndr_$ulong_int
 *          ndr_$uhyper_int
 *          ndr_$short_float
 *          ndr_$long_float
 *
 *   USE_DEFAULT_MP_REP
 *      Controls the definition of a type and the macros which define
 *      the marshalling pointer scheme used on a particular target system.
 *      The following macros need to be defined if USE_DEFAULT_MP_REP
 *      is #undef-ed:
 *          rpc_$init_mp
 *          rpc_$advance_mp
 *          rpc_$align_ptr_relative
 *
 *      and the following type needs to be typedef-ed:
 *          rpc_$mp_t 
 *
 *   USE_DEFAULT_MACROS
 *      Controls the definition of the macros which define how to marshall,
 *      unmarshall and convert values of each NDR scalar type as well
 *      as NDR string types.  The following macros need to be defined
 *      if USE_DEFAULT_MACROS is #undef-ed:
 *          rpc_$marshall_boolean, rpc_$unmarshall_boolean, rpc_$convert_boolean
 *          rpc_$marshall_byte, rpc_$unmarshall_byte, rpc_$convert_byte
 *          rpc_$marshall_char, rpc_$unmarshall_char, rpc_$convert_char
 *          rpc_$marshall_small_int, rpc_$unmarshall_small_int, rpc_$convert_small_int
 *          rpc_$marshall_usmall_int, rpc_$unmarshall_usmall_int, rpc_$convert_usmall_int
 *          rpc_$marshall_short_int, rpc_$unmarshall_short_int, rpc_$convert_short_int
 *          rpc_$marshall_ushort_int, rpc_$unmarshall_ushort_int, rpc_$convert_ushort_int
 *          rpc_$marshall_long_int, rpc_$unmarshall_long_int, rpc_$convert_long_int
 *          rpc_$marshall_ulong_int, rpc_$unmarshall_ulong_int, rpc_$convert_ulong_int
 *          rpc_$marshall_hyper_int, rpc_$unmarshall_hyper_int, rpc_$convert_hyper_int
 *          rpc_$marshall_uhyper_int, rpc_$unmarshall_uhyper_int, rpc_$convert_uhyper_int
 *          rpc_$marshall_short_float, rpc_$unmarshall_short_float, rpc_$convert_short_float
 *          rpc_$marshall_long_float, rpc_$unmarshall_long_float, rpc_$convert_long_float
 *          rpc_$marshall_string, rpc_$unmarshall_string, rpc_$convert_string
 *
 *
 * The following variable is used to support an optimization in marshalling
 * and unmarshalling arrays of scalars.
 *   ALIGNED_SCALAR_ARRAYS
 *      Defining this variable asserts that the target C compiler's layout
 *      for arrays of scalars matches NDR's.  The NIDL compiler emits
 *      code to marshall and unmarshall arrays of scalars which is
 *      conditioned on this variable: if ALIGNED_SCALAR_ARRAYS is defined
 *      then the code uses rpc_$block_copy (which must be defined whenever
 *      ALIGNED_SCALAR_ARRAYS is defined); if ALIGNED_SCALAR_ARRAYS is
 *      not defined then the NIDL compiler emits a loop to marshall or
 *      unmarshall the array element-wise.  Note that converting arrays
 *      of scalars must always be done element-wise.
 */

/***************************************************************************/ 
/***************************************************************************/ 

#ifndef idl_base

#define idl_base

/***************************************************************************/ 

/*
 * Cause a syntax error if wrong options are used with Vax C compiler.
 */

#ifdef vaxc
#  if CC$gfloat != 1
        "VAX/C NCK MUST BE BUILT WITH /G_FLOAT (VMS) or -Mg (ULTRIX)"
#  endif
#endif

/***************************************************************************/ 

/*
 * Work around C's flawed model for global variable definitions.
 */

#ifndef vaxc
#  define globaldef
#  define globalref extern
#endif

/***************************************************************************/ 

/*
 * Innocuously define volatile modifier in C implementations that don't support it.
 */

#if (!defined(__STDC__) || defined(apollo)) && !defined(vaxc)
#  define volatile
#endif

/***************************************************************************/ 

/*
 * The definition of the primitive "handle_t" NIDL type.    
 */ 

typedef struct {
    unsigned short data_offset;
} *handle_t;

/***************************************************************************/ 

/*
 * The definition of the primitive "boolean" NIDL type and its two values.
 */ 

#ifndef true
   typedef unsigned char boolean;
#  define true  ((unsigned char) 0xff)
#  define false ((unsigned char) 0x00)
#endif                                    

/***************************************************************************/ 

/* 
 * macro for distinguishing rpc comm failure statuses from other rpc status codes.
 */
 
#define rpc_$is_comm_failure_status(st)\
    (((st).all & 0xffff0000) == rpc_$mod)
/*    ((st).all == rpc_$comm_failure) */

/***************************************************************************/ 

/* Data representation descriptor type.  
 *
 * This type would be defined in "rpc.idl" except NIDL doesn'                                                                                                                                                                                                                                                                           {        RPC010.B                         !  #[UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1COM;1                                                                                           P                         $(             t yet
 * support packed structs.   (It's packed only for historical reasons.)
 * Note well:  Don't be confused into thinking that this struct defines
 * the bit layout of the drep in the packet header; it doesn't.
 */
 
typedef struct {
    unsigned int int_rep: 4;
    unsigned int char_rep: 4;
    unsigned int float_rep: 8;
    unsigned int reserved: 16;
} rpc_$drep_t;


/*
 * Macro used by stubs to compare two rpc_$drep_t's.
 */

#define rpc_$equal_drep(drep1, drep2)\
    (drep1.int_rep==drep2.int_rep)&&(drep1.char_rep==drep2.char_rep)&&(drep1.float_rep==drep2.float_rep)

/***************************************************************************/ 

/*
 * Hack to make the following variables read-only, global, and statically
 * initialized.  For Apollo global libraries.
 */

#ifdef apollo
#  define rpc_$local_drep_packed  rpc_$local_drep_p_pure_data$
#  define rpc_$local_drep         rpc_$local_drep_pure_data$
#  define rpc_$ascii_to_ebcdic    rpc_$ascii_to_ebcdic_pure_data$
#  define rpc_$ebcdic_to_ascii    rpc_$ebcdic_to_ascii_pure_data$
#endif

/***************************************************************************/ 

/*
 * Variable describing the local system's data representation.  The static
 * initialization of this variable is determined by values in "sysdep.h".
 */

globalref rpc_$drep_t rpc_$local_drep;


/*
 * ASCII <-> EBCDIC conversion tables.
 */

globalref char             rpc_$ascii_to_ebcdic[];
globalref char             rpc_$ebcdic_to_ascii[];


/***************************************************************************/ 
/***************************************************************************/ 

/*
 * Use the default definitions for:
 *
 *    1) representations for NDR scalar types,
 *    2) marshalling pointer represenation and manipulation,
 *    3) marshalling, unmarshalling and conversion methods
 *       for NDR scalar and string types
 *
 * unless some target specific section below #undef's one or more 
 * of these symbols.
 */

#define USE_DEFAULT_NDR_REPS
#define USE_DEFAULT_MP_REP
#define USE_DEFAULT_MACROS
#define ALIGNED_SCALAR_ARRAYS

/***************************************************************************/ 

/****
 **** Cray specific definitions of the default reps for NDR scalar types.
 ****/

#if defined(cray) || defined(CRAY) || defined(CRAY1) || defined(CRAY2)

#undef USE_DEFAULT_NDR_REPS

/*
 * ========= WARNING =========
 * ndr_${,u}small_int are not "chars" because no signed char is available
 * Applications developers MUST use shorts or ndr_${u,}small_int in their
 * code since the marshalling/unmarshalling/conversion code expects this.
 */
#define ndr_$boolean        unsigned char
#define ndr_$false          ((unsigned char) 00)
#define ndr_$true           ((unsigned char) 0xff)
#define ndr_$byte           unsigned char
#define ndr_$char           unsigned char
#define ndr_$small_int      short int           /* 24/32 bits => XMP/2 */
#define ndr_$short_int      short int           /* 24/32 bits => XMP/2 */
#define ndr_$long_int       int                 /* 64/32 bits => XMP/2 */
#define ndr_$hyper_int      long int
#define ndr_$usmall_int     unsigned short int  /* 24/32 bits => XMP/2 */
#define ndr_$ushort_int     unsigned short int  /* 24/32 bits => XMP/2 */
#define ndr_$ulong_int      unsigned int        /* 64/32 bits => XMP/2 */
#define ndr_$uhyper_int     unsigned long int
#define ndr_$short_float    float
#define ndr_$long_float     float

#endif

/***************************************************************************/ 

/****
 **** Definitions of the vaxc reps for NDR scalar types.
 ****/

#if defined(vaxc)

#undef USE_DEFAULT_NDR_REPS

#define ndr_$boolean        unsigned char
#define ndr_$false          ((unsigned char) 0x00)
#define ndr_$true           ((unsigned char) 0xff)
#define ndr_$byte           unsigned char
#define ndr_$char           unsigned char
#define ndr_$small_int      char
#define ndr_$usmall_int     unsigned char
#define ndr_$short_int      short int
#define ndr_$ushort_int     unsigned short int
#define ndr_$long_int       long int
#define ndr_$ulong_int      unsigned long int

/* the reps for hyper must match the little-endian NDR rep since
   defined(vaxc) => defined(ALIGNED_SCALAR_ARRAYS) */
struct ndr_$hyper_int_rep   {ndr_$ulong_int low; ndr_$long_int high;};
#define ndr_$hyper_int      struct ndr_$hyper_int_rep
struct ndr_$uhyper_int_rep  {ndr_$ulong_int low; ndr_$ulong_int high;};
#define ndr_$uhyper_int     struct ndr_$uhyper_int_rep

#define ndr_$short_float    float
#define ndr_$long_float     double

#endif

/***************************************************************************/ 

/****
 **** Definitions of the default reps for NDR scalar types.
 ****/

#ifdef USE_DEFAULT_NDR_REPS

#define ndr_$boolean        unsigned char
#define ndr_$false          ((unsigned char) 0x00)
#define ndr_$true           ((unsigned char) 0xff)
#define ndr_$byte           unsigned char
#define ndr_$char           unsigned char
#define ndr_$small_int      char
#define ndr_$usmall_int     unsigned char
#define ndr_$short_int      short int
#define ndr_$ushort_int     unsigned short int
#define ndr_$long_int       long int
#define ndr_$ulong_int      unsigned long int

struct ndr_$hyper_int_rep   {ndr_$long_int high; ndr_$ulong_int low;};
#define ndr_$hyper_int      struct ndr_$hyper_int_rep
struct ndr_$uhyper_int_rep  {ndr_$ulong_int high; ndr_$ulong_int low;};
#define ndr_$uhyper_int     struct ndr_$uhyper_int_rep

#define ndr_$short_float    float
#define ndr_$long_float     double

#endif

/***************************************************************************
 ****
 **** The rest of this file is only included in NIDL generated stub code.
 ****
 ***************************************************************************/


#if defined(NIDL_CSTUB) || defined(NIDL_SSTUB)

/*
 * Define the versions of stubs that this instance of idl_base.h supports.
 */

#define IDL_BASE_SUPPORTS_V1

/*
 * Declare external C library routines that are used by stubs.
 */

#ifdef __STDC__
    char *strcpy(ndr_$char *, ndr_$char *);
    int strlen(ndr_$char *);
#else
    char *strcpy();
    int strlen();
#endif

/*
 * Declare external NCK library routines that are not declarable in
 * rpc.idl that are used by stubs.
 */

void *rpc_$malloc(
#ifdef __STDC__
    int n
#endif
);
void rpc_$free(
#ifdef __STDC__
    void *p
#endif
);


/*
 * Define some macros that stub code uses for brevity or clarity.
 */

#define NULL 0

#define SIGNAL(code) {\
    status_$t st;\
    st.all = code;\
    pfm_$signal (st);\
    }

/***************************************************************************/ 

/*
 * Define a thin veneer over the pfm_$ routines and cope with problems
 * related to Apollo C's support for C++'s "&" feature in prototypes.
 */

#define pfm_signal(st)    pfm_$signal(st)

#if defined(apollo) && defined(__STDC__)
#  define pfm_cleanup(crec)         pfm_$cleanup(&(crec))
#  define pfm_rls_cleanup(crec, st) pfm_$rls_cleanup(&(crec), &(st))
#else
#  define pfm_cleanup(crec)         pfm_$cleanup(crec)
#  define pfm_rls_cleanup(crec, st) pfm_$rls_cleanup(crec, st)
#endif

/***************************************************************************/ 

/****
 **** Definitons specific to the i8086 with Microsoft C.
 ****/

#if defined(i8086) && defined(MSDOS)

#undef USE_DEFAULT_MP_REP

#define normalize_ptr(p)\
    *(((unsigned *)&p)+1) += *((unsigned *)&p) >> 4;\
    *((unsigned *)&p) &= 0x000F

typedef char *rpc_$mp_t;

#define rpc_$init_mp(mp, dbp, bufp, offset)\
    mp = (rpc_$mp_t)bufp;\
    normalize_ptr (mp);\
    mp += offset;\
    normalize_ptr (mp);\
    dbp =                                                                                                                                                                                                                                                                            ]        RPC010.B                         !  #[UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1                                                                                                P                         r4      "       mp

#define rpc_$advance_mp(mp, delta)\
    mp += delta

#define rpc_$align_ptr_relative(p, base, alignment)\
    p = base + (((p-base) + (alignment-1)) & ~(alignment-1))

#endif

/***************************************************************************/ 

/****
 **** Definitions specific to VMS (and Apple's AUX)
 ****/

#if defined(vaxc) || defined(apple_aux)

#undef USE_DEFAULT_MACROS

#define rpc_$marshall_boolean(mp, src)\
    *(ndr_$boolean *)mp = src

#define rpc_$unmarshall_boolean(mp, dst)\
    dst = *(ndr_$boolean *)mp

#define rpc_$convert_boolean(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_boolean(mp, dst)



#define rpc_$marshall_byte(mp, src)\
    *(ndr_$byte *)mp = src

#define rpc_$unmarshall_byte(mp, dst)\
    dst = *(ndr_$byte *)mp

#define rpc_$convert_byte(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_byte(mp, dst)



#define rpc_$marshall_char(mp, src)\
    *(ndr_$char *)mp = src

#define rpc_$unmarshall_char(mp, dst)\
    dst = *(ndr_$char *)mp

#define rpc_$convert_char(src_drep, dst_drep, mp, dst)\
    if (src_drep.char_rep == dst_drep.char_rep)\
        rpc_$unmarshall_char(mp, dst);\
    else if (dst_drep.char_rep == rpc_$drep_char_ascii)\
        dst = rpc_$ebcdic_to_ascii [*(ndr_$char *)mp];\
    else\
        dst = rpc_$ascii_to_ebcdic [*(ndr_$char *)mp]



#define rpc_$marshall_small_int(mp, src)\
    *(ndr_$small_int *)mp = src

#define rpc_$unmarshall_small_int(mp, dst)\
    dst = *(ndr_$small_int *)mp

#define rpc_$convert_small_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_small_int(mp, dst)



#define rpc_$marshall_usmall_int(mp, src)\
    *(ndr_$usmall_int *)mp = src

#define rpc_$unmarshall_usmall_int(mp, dst)\
    dst = *(ndr_$usmall_int *)mp

#define rpc_$convert_usmall_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_usmall_int(mp, dst)



#define rpc_$marshall_short_int(mp, src)\
    *(ndr_$short_int *)mp = src

#define rpc_$unmarshall_short_int(mp, dst)\
    dst = *(ndr_$short_int *)mp

#define rpc_$convert_short_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_short_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_ushort_int(mp, src)\
    *(ndr_$ushort_int *)mp = (ndr_$ushort_int)src

#define rpc_$unmarshall_ushort_int(mp, dst)\
    *((ndr_$ushort_int *)&dst) = *(ndr_$ushort_int *)mp

#define rpc_$convert_ushort_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ushort_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_long_int(mp, src)\
    *(ndr_$long_int *)mp = src

#define rpc_$unmarshall_long_int(mp, dst)\
    dst = *(ndr_$long_int *)mp

#define rpc_$convert_long_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_long_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_ulong_int(mp, src)\
    *(ndr_$ulong_int *)mp = (ndr_$ulong_int)src

#define rpc_$unmarshall_ulong_int(mp, dst)\
    *((ndr_$ulong_int *)&dst) = *(ndr_$ulong_int *)mp

#define rpc_$convert_ulong_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ulong_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_hyper_int(mp, src) {\
    *(struct ndr_$hyper_int_rep *)mp = *(struct ndr_$hyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_hyper_int(mp, dst) {\
    *(struct ndr_$hyper_int_rep *)&dst = *(struct ndr_$hyper_int_rep *)mp;\
    }

#define rpc_$convert_hyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_hyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_uhyper_int(mp, src) {\
    *(struct ndr_$uhyper_int_rep *)mp = *(struct ndr_$uhyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_uhyper_int(mp, dst) {\
    *(struct ndr_$uhyper_int_rep *)&dst = *(struct ndr_$uhyper_int_rep *)mp;\
    }

#define rpc_$convert_uhyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_uhyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_short_float(mp, src) {\
    ndr_$short_float tmp;\
    tmp = src;\
    *(ndr_$short_float *)mp = tmp;\
    }

#define rpc_$unmarshall_short_float(mp, dst)\
    dst = *(ndr_$short_float *)mp

#define rpc_$convert_short_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_short_float(mp, dst);\
    else {\
        rpc_$cvt_short_float (src_drep, dst_drep,\
            (rpc_$short_float_p_t)mp,\
            (rpc_$short_float_p_t)&dst);\
        }



#define rpc_$marshall_long_float(mp, src)\
    *(ndr_$long_float *)mp = src

#define rpc_$unmarshall_long_float(mp, dst)\
    dst = *(ndr_$long_float *)mp

#define rpc_$convert_long_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_long_float(mp, dst);\
    else\
        rpc_$cvt_long_float (src_drep, dst_drep,\
            (rpc_$long_float_p_t)mp,\
            (rpc_$long_float_p_t)&dst)



#define rpc_$marshall_string(lenvar, maxlen, mp, src)\
    {\
    if ((lenvar = strlen((ndr_$char *)src)) >= maxlen)\
        SIGNAL(nca_status_$string_too_long)\
    rpc_$marshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)mp, (ndr_$char *)src);\
    }

#define rpc_$unmarshall_string(lenvar, mp, dst)\
    {\
    rpc_$unmarshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    }

#define rpc_$convert_string(src_drep, dst_drep, lenvar, mp, dst)\
    {\
    rpc_$convert_ushort_int (src_drep, dst_drep, mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    if (src_drep.char_rep == dst_drep.char_rep)\
        strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    else\
        rpc_$cvt_string (src_drep, dst_drep, (rpc_$char_p_t)mp, (rpc_$char_p_t)dst);\
    }

#endif

/***************************************************************************/

/****
 **** Definitions specific to Crays.
 ****
 **** Cray specific issues:
 ****     cray data types don't exactly match ndr data types
 ****         cray's don't have 8 bit signed integers, nor 16 bit
 ****             signed/unsigned ints, nor 32 bit signed/unsigned
 ****             ints (in the case of the XMP)
 ****         cray's floats are all 64 bits and ndr knows this
 ****     cray XMP and cray 2 data types have different precisions
 ****     with the exception of character pointers, the address of
 ****         *any* data type results in a 64 bit aligned add                                                                                                                                                                                                                                                                           088        RPC010.B                         !  #[UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1                                                                                                P                               1       ress
 ****         (which means that the pointer doesn't typically point
 ****         to the first byte of the data element).
 ****/

#if defined(cray) || defined(CRAY) || defined(CRAY1) || defined(CRAY2)

#undef USE_DEFAULT_MACROS
#undef ALIGNED_SCALAR_ARRAYS

/*
 * first some macros for some repetitive sequences
 */
#define rpc_$put_2(mp, src)\
    {\
    unsigned long buf = src; /* necessary since src isn't always an lvalue */\
    mp[0] = ((rpc_$mp_t)&buf)[6];\
    mp[1] = ((rpc_$mp_t)&buf)[7];\
    }

#define rpc_$get_2(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[6] = mp[0];\
    ((rpc_$mp_t)&dst)[7] = mp[1];\
    }

#define rpc_$get_2_swab(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[6] = mp[1];\
    ((rpc_$mp_t)&dst)[7] = mp[0];\
    }

#define rpc_$put_4(mp, src)\
    {\
    unsigned long buf = src; /* necessary since src isn't always an lvalue */\
    mp[0] = ((rpc_$mp_t)&buf)[4];\
    mp[1] = ((rpc_$mp_t)&buf)[5];\
    mp[2] = ((rpc_$mp_t)&buf)[6];\
    mp[3] = ((rpc_$mp_t)&buf)[7];\
    }

#define rpc_$get_4(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[4] = mp[0];\
    ((rpc_$mp_t)&dst)[5] = mp[1];\
    ((rpc_$mp_t)&dst)[6] = mp[2];\
    ((rpc_$mp_t)&dst)[7] = mp[3];\
    }

#define rpc_$get_4_swab(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[4] = mp[3];\
    ((rpc_$mp_t)&dst)[5] = mp[2];\
    ((rpc_$mp_t)&dst)[6] = mp[1];\
    ((rpc_$mp_t)&dst)[7] = mp[0];\
    }

#define rpc_$get_8_swab(mp, dst)\
    {\
    ((rpc_$mp_t)&dst)[0] = mp[7];\
    ((rpc_$mp_t)&dst)[1] = mp[6];\
    ((rpc_$mp_t)&dst)[2] = mp[5];\
    ((rpc_$mp_t)&dst)[3] = mp[4];\
    ((rpc_$mp_t)&dst)[4] = mp[3];\
    ((rpc_$mp_t)&dst)[5] = mp[2];\
    ((rpc_$mp_t)&dst)[6] = mp[1];\
    ((rpc_$mp_t)&dst)[7] = mp[0];\
    }

/*
 * now for the macros nidl uses
 */

#define rpc_$marshall_boolean(mp, src)\
    *(ndr_$boolean *)mp = src

#define rpc_$unmarshall_boolean(mp, dst)\
    dst = *(ndr_$boolean *)mp

#define rpc_$convert_boolean(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_boolean(mp, dst)



#define rpc_$marshall_byte(mp, src)\
    *(ndr_$byte *)mp = src

#define rpc_$unmarshall_byte(mp, dst)\
    dst = *(ndr_$byte *)mp

#define rpc_$convert_byte(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_byte(mp, dst)



#define rpc_$marshall_char(mp, src)\
    *(ndr_$char *)mp = src

#define rpc_$unmarshall_char(mp, dst)\
    dst = *(ndr_$char *)mp

#define rpc_$convert_char(src_drep, dst_drep, mp, dst)\
    if (src_drep.char_rep == dst_drep.char_rep){\
        rpc_$unmarshall_char(mp, dst);\
    } else if (dst_drep.char_rep == rpc_$drep_char_ascii)\
        (ndr_$char)dst = rpc_$ebcdic_to_ascii [*(ndr_$char *)mp];\
    else\
        (ndr_$char)dst = rpc_$ascii_to_ebcdic [*(ndr_$char *)mp]



/*
 * ndr_$small_int is larger than 8 bits
 */
#define rpc_$marshall_small_int(mp, src)\
    *(char *)mp = (char)src

#define rpc_$unmarshall_small_int(mp, dst)\
    {\
    dst = (*mp & 0x80) ? -1 : 0;\
    ((char *)&dst)[7] = *mp;\
    }

#define rpc_$convert_small_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_small_int(mp, dst)



/*
 * ndr_$usmall_int is larger than 8 bits
 */
#define rpc_$marshall_usmall_int(mp, src)\
    *(char *)mp = (char)src

#define rpc_$unmarshall_usmall_int(mp, dst)\
    {\
    dst = 0;\
    ((char *)&dst)[7] = *mp;\
    }

#define rpc_$convert_usmall_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_usmall_int(mp, dst)




/*
 * ndr_$short_int is larger than 16 bits
 */
#define rpc_$marshall_short_int(mp, src)\
    rpc_$put_2(mp, src)

#define rpc_$unmarshall_short_int(mp, dst)\
    {\
    dst = (*mp & 0x80) ? -1 : 0;\
    rpc_$get_2(mp, dst);\
    }

#define rpc_$convert_short_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_short_int(mp, dst);\
    } else {\
        dst = (mp[1] & 0x80) ? -1 : 0;\
        rpc_$get_2_swab(mp, dst);\
    }



/*
 * ndr_$ushort_int is larger than 16 bits
 */
#define rpc_$marshall_ushort_int(mp, src)\
    rpc_$put_2(mp, src)

#define rpc_$unmarshall_ushort_int(mp, dst)\
    {\
    dst = 0;\
    rpc_$get_2(mp, dst);\
    }

#define rpc_$convert_ushort_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_ushort_int(mp, dst);\
    } else {\
        dst = 0;\
        rpc_$get_2_swab(mp, dst);\
    }



/*
 * ndr_$long_int is larger than 32 bits on a XMP
 * (could special case for the cray 2 and get rid of the sign
 * extension processing)
 */
#define rpc_$marshall_long_int(mp, src)\
    rpc_$put_4(mp, src)

#define rpc_$unmarshall_long_int(mp, dst)\
    {\
    dst = (*mp & 0x80) ? -1 : 0;\
    rpc_$get_4(mp, dst);\
    }

#define rpc_$convert_long_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_long_int(mp, dst);\
    } else {\
        dst = (mp[3] & 0x80) ? -1 : 0;\
        rpc_$get_4_swab(mp, dst);\
    }



/*
 * ndr_$ulong_int is larger than 32 bits on a XMP
 * (could special case for the cray 2 and get rid of the 0 fill
 * extension procession)
 */
#define rpc_$marshall_ulong_int(mp, src)\
    rpc_$put_4(mp, src)

#define rpc_$unmarshall_ulong_int(mp, dst)\
    {\
    dst = 0;\
    rpc_$get_4(mp, dst);\
    }

#define rpc_$convert_ulong_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_ulong_int(mp, dst);\
    } else {\
        dst = 0;\
        rpc_$get_4_swab(mp, dst);\
    }




#define rpc_$marshall_hyper_int(mp, src)\
    *(ndr_$hyper_int *)mp = src

#define rpc_$unmarshall_hyper_int(mp, dst)\
    dst = *(ndr_$hyper_int *)mp

#define rpc_$convert_hyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_hyper_int(mp, dst);\
    } else {\
        rpc_$get_8_swab(mp, dst);\
    }



#define rpc_$marshall_uhyper_int(mp, src)\
    *(ndr_$uhyper_int *)mp = src

#define rpc_$unmarshall_uhyper_int(mp, dst)\
    dst = *(ndr_$uhyper_int *)mp

#define rpc_$convert_uhyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep){\
        rpc_$unmarshall_uhyper_int(mp, dst);\
    } else {\
        rpc_$get_8_swab(mp, dst);\
    }



/*
 * since cray's don't support a 32 bit flt pt format,
 * convert to IEEE 32 bit format and stick that in the packet.
 */
#define rpc_$marshall_short_float(mp, src)\
{\
    unsigned long ieee_32;\
    extern void rpc_$cray64_to_ieee32();\
\
    rpc_$cray64_to_ieee32(&src, &ieee_32);\
    rpc_$put_4(mp, ieee_32);\
}

/*
 * The packet has a 32 bit IEEE value (what the above macro decided
 * to stick in the packet). A conversion to 64 bit cray float is
 * required.
 */
#define rpc_$unmarshall_short_float(mp, dst)\
{\
    unsigned long ieee_32;\
    extern void rpc_$ieee32_to_cray64();\
\
    rpc_$get_4(mp, ieee_32);\
    rpc_$ieee32_to_cray64(&ieee_32, &dst);\
}

#define rpc_$convert_short_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep)){\
        rpc_$unmarshall_short_float(mp, dst);\
    } else {\
        unsigned long buf;\
        rpc_$get_4(mp, buf);\
        rpc_$cvt_short_float (\
            src_drep,\
            dst_drep,\
            (rpc_$short_float_p_t)&buf,\
            (rpc_$short_float_p_t)&dst); \
    }




#define rpc_$marshall_long_float(mp, src)\
    *(ndr_$long_float *)mp = src

#define rpc_$unmarshall_long_float(mp, dst)\
    dst = *(ndr_$long_float *)mp

#define rpc_$convert_long_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep)){\
        rpc_$unmarshall_long_float(mp, dst);\
    } else {\
        rpc                                                                                                                                                                                                                                                                                   RPC010.B                         !  #[UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1COM;1                                                                                           P                               @       _$cvt_long_float (\
            src_drep,\
            dst_drep,\
            (rpc_$long_float_p_t)mp,\
            (rpc_$long_float_p_t)&dst);\
    }



#define rpc_$marshall_string(lenvar, maxlen, mp, src)\
    {\
    if ((lenvar = strlen((ndr_$char *)src)) >= maxlen)\
        SIGNAL(nca_status_$string_too_long)\
    rpc_$marshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)mp, (ndr_$char *)src);\
    }

#define rpc_$unmarshall_string(lenvar, mp, dst)\
    {\
    rpc_$unmarshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    }

#define rpc_$convert_string(src_drep, dst_drep, lenvar, mp, dst)\
    {\
    rpc_$convert_ushort_int (src_drep, dst_drep, mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    if (src_drep.char_rep == dst_drep.char_rep)\
        strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    else\
        rpc_$cvt_string (src_drep, dst_drep, (rpc_$char_p_t)mp, (rpc_$char_p_t)dst);\
    }

#endif

/***************************************************************************/ 

/****
 **** Definition of the default marshalling pointer representation
 ****/

#ifdef USE_DEFAULT_MP_REP

typedef char *rpc_$mp_t;

#define rpc_$init_mp(mp, dbp, bufp, offset)\
    mp = dbp = (rpc_$mp_t)bufp + offset
         
#define rpc_$advance_mp(mp, delta)\
    mp += delta

#define rpc_$align_ptr_relative(p, base, alignment)\
    p = base + (((p-base) + (alignment-1)) & ~(alignment-1))

#endif

/***************************************************************************/ 

/****
 **** Definitions of the default marshall, unmarshall, and convert macros.
 ****/

#ifdef USE_DEFAULT_MACROS

#define rpc_$marshall_boolean(mp, src)\
    *(ndr_$boolean *)mp = src

#define rpc_$unmarshall_boolean(mp, dst)\
    dst = *(ndr_$boolean *)mp

#define rpc_$convert_boolean(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_boolean(mp, dst)



#define rpc_$marshall_byte(mp, src)\
    *(ndr_$byte *)mp = src

#define rpc_$unmarshall_byte(mp, dst)\
    dst = *(ndr_$byte *)mp

#define rpc_$convert_byte(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_byte(mp, dst)



#define rpc_$marshall_char(mp, src)\
    *(ndr_$char *)mp = src

#define rpc_$unmarshall_char(mp, dst)\
    dst = *(ndr_$char *)mp

#define rpc_$convert_char(src_drep, dst_drep, mp, dst)\
    if (src_drep.char_rep == dst_drep.char_rep)\
        rpc_$unmarshall_char(mp, dst);\
    else if (dst_drep.char_rep == rpc_$drep_char_ascii)\
        (ndr_$char)dst = rpc_$ebcdic_to_ascii [*(ndr_$char *)mp];\
    else\
        (ndr_$char)dst = rpc_$ascii_to_ebcdic [*(ndr_$char *)mp]



#define rpc_$marshall_small_int(mp, src)\
    *(ndr_$small_int *)mp = src

#define rpc_$unmarshall_small_int(mp, dst)\
    dst = *(ndr_$small_int *)mp

#define rpc_$convert_small_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_small_int(mp, dst)



#define rpc_$marshall_usmall_int(mp, src)\
    *(ndr_$usmall_int *)mp = src

#define rpc_$unmarshall_usmall_int(mp, dst)\
    dst = *(ndr_$usmall_int *)mp

#define rpc_$convert_usmall_int(src_drep, dst_drep, mp, dst)\
    rpc_$unmarshall_usmall_int(mp, dst)



#define rpc_$marshall_short_int(mp, src)\
    *(ndr_$short_int *)mp = src

#define rpc_$unmarshall_short_int(mp, dst)\
    dst = *(ndr_$short_int *)mp

#define rpc_$convert_short_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_short_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_ushort_int(mp, src)\
    *(ndr_$ushort_int *)mp = (ndr_$ushort_int)src

#define rpc_$unmarshall_ushort_int(mp, dst)\
    (ndr_$ushort_int)dst = *(ndr_$ushort_int *)mp

#define rpc_$convert_ushort_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ushort_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[1]; _d[1]=_s[0];\
        }



#define rpc_$marshall_long_int(mp, src)\
    *(ndr_$long_int *)mp = src

#define rpc_$unmarshall_long_int(mp, dst)\
    dst = *(ndr_$long_int *)mp

#define rpc_$convert_long_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_long_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_ulong_int(mp, src)\
    *(ndr_$ulong_int *)mp = (ndr_$ulong_int)src

#define rpc_$unmarshall_ulong_int(mp, dst)\
    (ndr_$ulong_int)dst = *(ndr_$ulong_int *)mp

#define rpc_$convert_ulong_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_ulong_int(mp, dst);\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[3]; _d[1]=_s[2]; _d[2]=_s[1]; _d[3]=_s[0];\
        }



#define rpc_$marshall_hyper_int(mp, src) {\
    *(struct ndr_$hyper_int_rep *)mp = *(struct ndr_$hyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_hyper_int(mp, dst) {\
    *(struct ndr_$hyper_int_rep *)&dst = *(struct ndr_$hyper_int_rep *)mp;\
    }

#define rpc_$convert_hyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_hyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_uhyper_int(mp, src) {\
    *(struct ndr_$uhyper_int_rep *)mp = *(struct ndr_$uhyper_int_rep *)&src;\
    }

#define rpc_$unmarshall_uhyper_int(mp, dst) {\
    *(struct ndr_$uhyper_int_rep *)&dst = *(struct ndr_$uhyper_int_rep *)mp;\
    }

#define rpc_$convert_uhyper_int(src_drep, dst_drep, mp, dst)\
    if (src_drep.int_rep == dst_drep.int_rep)\
        rpc_$unmarshall_uhyper_int(mp, dst)\
    else {\
        ndr_$byte *_d = (ndr_$byte *) &dst;\
        ndr_$byte *_s = (ndr_$byte *) mp;\
        _d[0]=_s[7]; _d[1]=_s[6]; _d[2]=_s[5]; _d[3]=_s[4];\
        _d[4]=_s[3]; _d[5]=_s[2]; _d[6]=_s[1]; _d[7]=_s[0];\
        }



#define rpc_$marshall_short_float(mp, src){\
    ndr_$short_float tmp;\
    tmp = src;\
    *(ndr_$short_float *)mp = tmp;\
    }

#define rpc_$unmarshall_short_float(mp, dst)\
    dst = *(ndr_$short_float *)mp

#define rpc_$convert_short_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_short_float(mp, dst);\
    else {\
        rpc_$cvt_short_float (src_drep, dst_drep,\
            (rpc_$short_float_p_t)mp,\
            (rpc_$short_float_p_t)&dst);\
        }



#define rpc_$marshall_long_float(mp, src)\
    *(ndr_$long_float *)mp = src

#define rpc_$unmarshall_long_float(mp, dst)\
    dst = *(ndr_$long_float *)mp

#define rpc_$convert_long_float(src_drep, dst_drep, mp, dst)\
    if ((src_drep.float_rep == dst_drep.float_rep) &&\
        (src_drep.int_rep   == dst_drep.int_rep))\
        rpc_$unmarshall_long_float(mp, dst);\
    else\
        rpc_$cvt_long_float (src_drep, dst_drep,\
            (rpc_$long_float_p_t)mp,\
            (rpc_$long_float_p_t)&dst)



#define rpc_$marshall_string(lenvar, maxlen, mp, src)\
    {\
    if ((lenvar = strlen((ndr_$char *)src)) >= maxlen)\
        SIGNAL(nca_status_$string_too_long)\
    rpc_$marshall_ushort_int (mp, lenvar);\                                                                                                                                                                                                                                                                                   RPC010.B                         !  #[UCX.V13.BL13.RPCKIT.B]IDL_BASE.H;1                                                                                                P                               O       
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)mp, (ndr_$char *)src);\
    }

#define rpc_$unmarshall_string(lenvar, mp, dst)\
    {\
    rpc_$unmarshall_ushort_int (mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    }

#define rpc_$convert_string(src_drep, dst_drep, lenvar, mp, dst)\
    {\
    rpc_$convert_ushort_int (src_drep, dst_drep, mp, lenvar);\
    rpc_$advance_mp(mp, 2);\
    if (src_drep.char_rep == dst_drep.char_rep)\
        strcpy ((ndr_$char *)dst, (ndr_$char *)mp);\
    else\
        rpc_$cvt_string (src_drep, dst_drep, (rpc_$char_p_t)mp, (rpc_$char_p_t)dst);\
    }

#endif    
  
/***************************************************************************/ 
/***************************************************************************/ 

#endif

#endif
                                                                                                                                                                                                                * [UCX.V13.BL13.RPCKIT.B]LB.H;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O 	    5 	  6   7 / ϓ  8          9          G #  H  J                    
/* @(#)lb.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef lb__included
#define lb__included
#include "idl_base.h"
#include "nbase.h"
#include "glb.h"
extern  void lb_$register
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in] */lb_$server_flag_t flags,
  /* [in] */ndr_$char annotation[64],
  /* [in] */socket_$addr_t *saddr,
  /* [in] */ndr_$ulong_int saddr_len,
  /* [out] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$unregister
#ifdef __STDC__
 (
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_range
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in] */socket_$addr_t *location,
  /* [in] */ndr_$ulong_int location_len,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_object
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_object_local
#ifdef __STDC__
 (
  /* [in] */uuid_$t *object,
  /* [in] */socket_$addr_t *location,
  /* [in] */ndr_$ulong_int location_len,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_type
#ifdef __STDC__
 (
  /* [in] */uuid_$t *obj_type,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void lb_$lookup_interface
#ifdef __STDC__
 (
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[1],
  /* [out] */status_$t *status);
#else
 ( );
#endif
#endif
                                                                               * [UCX.V13.BL13.RPCKIT.B]LB.IDL;1 +  ,    .     /    4      
                     - !   0   1    2   3      K  P   W   O     5 	  6 D@  7 ` ϓ  8          9          G #  H  J      
            %pascal

{*	@(#)lb.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


[ local ]
interface lb_;

import
        'nbase.idl',
        'glb.idl';


{* LS Client Agent obj_interface description - these are local calls *}

{*
** lb_$register - register the specified entry, if lb_$server_flag_local in "flags"
**              then make this entry local.
*}
procedure
    lb_$register (
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in      flags           : lb_$server_flag_t;
        in ref  annotation      : array [0..63] of char;
        in ref  saddr           : socket_$addr_t;
        in      saddr_len       : unsigned32;
        out     xentry          : lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$unregister - unregister the specified entry.
*}
procedure
    lb_$unregister (
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** lb_$lookup_range - lookup matching entries.  if any of the uuid_$t fields
**              are uuid_$nil, then that field will match
**              any value in the database.  This allows lookup by any combination
**              of entry fields.  "location" is a pointer to a socket_$addr_t,
**              if the pointer is nil, then the request is sent to a global
**              location server, otherwise it is sent to the local location server
**              running at the node specified by the "location" parameter.
**
**                                                                                                                                                                                                                                                  ,;(        RPC010.B                         !  [UCX.V13.BL13.RPCKIT.B]LB.IDL;1.H;1                                                                                                                         z7                    a handle describing where to 
**              begin the search and returns a handle describing where to continue
**              the search from.  A handle value of lb_$default_lookup_handle on input
**              indicates the search should begin at the beginning of the data, and
**              a value of lb_$default_lookup_handle on output indicates that all
**              available data has been delivered.
**
**              NOTE: It is possible that serial invokations of this
**              function will return duplicate or incomplete information.
*}
procedure 
    lb_$lookup_range (
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in ref  location        : socket_$addr_t;
        in      location_len    : unsigned32;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{* Various common lookup operations *}

{*
** lb_$lookup_object - search for the specified object in the global database.
**              This call implies wildcards for the object type and obj_interface.
*}
procedure 
    lb_$lookup_object (
        in ref  object          : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$lookup_object_local - search for the specified object at the specified site.
**              This call implies wildcards for the object type and obj_interface.
*}
procedure 
    lb_$lookup_object_local (
        in ref  object          : uuid_$t;
        in ref  location        : socket_$addr_t;
        in      location_len    : unsigned32;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$lookup_type - search for the specified type in the global database.
**              This call implies wildcards for the object and obj_interface.
*}
procedure 
    lb_$lookup_type (
        in ref  obj_type        : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

{*
** lb_$lookup_interface - search for the specified obj_interface in the global 
**              database.  This call implies wildcards for the object and
**              object type.
*}
procedure 
    lb_$lookup_interface (
        in ref  obj_interface   : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results), max_is(max_num_results) ] 
                                      array [ 1 .. * ] of lb_$entry_t;
        out     status          : status_$t
    );

end;
                                                                                                                                                                                                                                                                                                                                                                   * [UCX.V13.BL13.RPCKIT.B]LLB.H;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 	  6 
u  7  ϓ  8          9          G #  H  J                   
/* @(#)llb.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef llb__included
#define llb__included
#include "idl_base.h"
#include "rpc.h"
#include "nbase.h"
#include "glb.h"
static rpc_$if_spec_t llb_$if_spec = {
  4,
  {0, 0, 135, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0},
  3,
  {
  0x333b33c3,
  0x0000,
  0,
  0xd,
  {0x0, 0x0, 0x87, 0x84, 0x0, 0x0, 0x0}
  }
};
extern  void llb_$insert
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
extern  void llb_$delete
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status);
#else
 ( );
#endif
#define llb_$max_lookup_results 6
extern  void llb_$lookup
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[6],
  /* [out] */status_$t *status);
#else
 ( );
#endif
typedef struct llb_$epv_t {
void (*llb_$insert)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*llb_$delete)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */lb_$entry_t *xentry,
  /* [out] */status_$t *status)
#else
()
#endif
;
void (*llb_$lookup)
#ifdef __STDC__
 (
  /* [in] */handle_t h,
  /* [in] */uuid_$t *object,
  /* [in] */uuid_$t *obj_type,
  /* [in] */uuid_$t *obj_interface,
  /* [in, out] */lb_$lookup_handle_t *entry_handle,
  /* [in] */ndr_$ulong_int max_num_results,
  /* [out] */ndr_$ulong_int *num_results,
  /* [out] */lb_$entry_t result_entries[6],
  /* [out] */status_$t *status)
#else
()
#endif
;
} llb_$epv_t;
globalref llb_$epv_t llb_$client_epv;
globalref llb_$epv_t llb_$manager_epv;
globalref rpc_$epv_t llb_$server_epv;
#endif
n                                          * [UCX.V13.BL13.RPCKIT.B]LLB.IDL;1 +  ,    .     /    4       V                    - !   0   1    2   3      K  P   W   O     5 	  6  5;  7  ϓ  8          9          G #  H  J                                                                                                                                                                                                                                                               4        RPC010.B                         !   [UCX.V13.BL13.RPCKIT.B]LLB.IDL;1H;1COM;1                                                                                                                    o             
{*	@(#)llb.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


{ LLB - Local Location Broker and forwarding agent }

[
        uuid(333b33c30000.0d.00.00.87.84.00.00.00),
        port( dds:[12] , ip:[135] ),
        version(4)
] 
interface llb_;

import 
        'nbase.idl',
        'glb.idl';

{*
** llb_$insert - add the specified entry to the database.
*}
procedure
    llb_$insert (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** llb_$delete - remove the specified entry from the database.
*}
procedure
    llb_$delete (
        in      h       : handle_t;
        in ref  xentry  : lb_$entry_t;
        out     status  : status_$t
    );

{*
** llb_$lookup - perform a lookup operation at a local database.  Due to current
**              restrictions on the maximum packet size used by the rpc runtime, 
**              the maximum number of results is defined in llb_$max_lookup_results
*}
const
        llb_$max_lookup_results = 6; {* size of the result_entries array in lookup *}

[ idempotent ] procedure 
    llb_$lookup (
        in      h               : handle_t;
        in ref  object          : uuid_$t;
        in ref  obj_type        : uuid_$t;
        in ref  obj_interface   : uuid_$t;
        in out  entry_handle    : lb_$lookup_handle_t;
        in      max_num_results : unsigned32;
        out     num_results     : unsigned32;
        out     result_entries  : [ last_is(num_results) ] 
                                      array[ 1..6 ] of lb_$entry_t;
        out     status          : status_$t
    );

end;
                                                                                                                                                                                                                                                                                                                                                                                                                                                          * [UCX.V13.BL13.RPCKIT.B]NBASE.H;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 	  6    7 @' ϓ  8          9          G #  H  J                 
/* @(#)nbase.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef nbase__included
#define nbase__included
#include "idl_base.h"
typedef ndr_$short_int binteger;
typedef ndr_$short_int pinteger;
typedef ndr_$long_int linteger;
typedef struct status_$t status_$t;
struct status_$t {
ndr_$long_int all;
};
#define status_$ok 0
typedef struct uuid_$t uuid_$t;
struct uuid_$t {
ndr_$ulong_int time_high;
ndr_$ushort_int time_low;
ndr_$ushort_int reserved;
ndr_$byte family;
ndr_$byte host[7];
};
#ifdef __STDC__
handle_t uuid_$t_bind(uuid_$t h);
void uuid_$t_unbind(uuid_$t uh, handle_t h);
#else
handle_t uuid_$t_bind();
void uuid_$t_unbind();
#endif
#define socket_$unspec_port 0
#define socket_$unspec ((ndr_$ushort_int) 0x0)
#define socket_$unix ((ndr_$ushort_int) 0x1)
#define socket_$internet ((ndr_$ushort_int) 0x2)
#define socket_$implink ((ndr_$ushort_int) 0x3)
#define socket_$pup ((ndr_$ushort_int) 0x4)
#define socket_$chaos ((ndr_$ushort_int) 0x5)
#define socket_$ns ((ndr_$ushort_int) 0x6)
#define socket_$nbs ((ndr_$ushort_int) 0x7)
#define socket_$ecma ((ndr_$ushort_int) 0x8)
#define socket_$datakit ((ndr_$ushort_int) 0x9)
#define socket_$ccitt ((ndr_$ushort_int) 0xa)
#define socket_$sna ((ndr_$ushort_int) 0xb)
#define socket_$unspec2 ((ndr_$ushort_int) 0xc)
#define socket_$dds ((ndr_$ushort_int) 0xd)
typedef ndr_$ushort_int socket_$addr_family_t;
#define socket_$num_families 32
#define socket_$sizeof_family 2
#define socket_$sizeof_data 14
#define socket_$sizeof_ndata 12
#define socket_$sizeof_hdata 12
typedef struct socket_$addr_t socket_$addr_t;
struct socket_$addr_t {
socket_$addr_family_t family;
ndr_$byte data[14];
};
typedef struct socket_$net_addr_t socket_$net_addr_t;
struct socket_$net_addr_t {
socket_$addr_family_t family;
ndr_$byte data[12];
};
typedef struct socket_$host_id_t socket_$host_id_t;
struct socket_$host_id_t {
socket_$addr_family_t family;
ndr_$byte data[12];
};
#endif
r                                                                                                                      " * [UCX.V13.BL13.RPCKIT.B]NBASE.IDL;1 +  ,    . 
    /    4   
   	                    - !   0   1    2   3      K  P   W   O     5 	  6    7  8 ϓ  8          9          G #  H  J                               %pascal

{*	@(#)nbase.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ***                                                                                                                                                                                                                           w{        RPC010.B                         !  "[UCX.V13.BL13.RPCKIT.B]NBASE.IDL;11                                                                                                
                         c|             *********************************************************************/
 *}


{   NBASE - Basic data types and constants used in network interfaces
    
    CHANGES:    
    
        03/11/87 mishkin Make uuid_$t be a handle.
        03/02/87 mishkin Initial coding from base.imp.idl.

}

[uuid(339b18336000.0d.00.00.80.9c.00.00.00)] interface nbase_;

type   
    binteger = 
        0..255;                     { positive 8 bit integer }
    pinteger = 
        0..65535;                   { positive 16 bit integer }
    linteger = 
        0..2147483647;              { positive 31 bit integer }


type   
    status_$t =
        record
            all:    integer32;
            end;

const  
    status_$ok = 0;                 { returned if called proc successful }

type
    uuid_$t =
        [handle] record
            time_high:  unsigned32;
            time_low:   unsigned;
            reserved:   unsigned;
            family:     byte;
            host:       array[1..7] of byte;
            end;

const
    socket_$unspec_port = 0;

type
    socket_$addr_family_t = (
        socket_$unspec,                 { Unspecified }
        socket_$unix,                   { Local to host (pipes, portals) }
        socket_$internet,               { Internetwork: TCP, UDP, etc }
        socket_$implink,                { ARPAnet imp addresses }
        socket_$pup,                    { PUP protocols: e.g. BSP }
        socket_$chaos,                  { MIT CHAOS protocols }
        socket_$ns,                     { XEROX NS protocols }
        socket_$nbs,                    { NBS protocols }
        socket_$ecma,                   { European computer manufacturers }
        socket_$datakit,                { Datakit protocols }
        socket_$ccitt,                  { CCITT protocols, X.25 etc }
        socket_$sna,                    { IBM SNA }
        socket_$unspec2,
        socket_$dds                     { Apollo DOMAIN/MSG protocol }
        );

const
    socket_$num_families = 32;          { max # of families you can define }

    {for more information on "socket length's" and the following constants see socket.idl }
    socket_$sizeof_family = 2;          { bytes in the NDR rep of socket_$addr_family_t }
    socket_$sizeof_data = 14;           { bytes in the NDR rep of socket_$addr_t.data }
    socket_$sizeof_ndata = 12;          { bytes in the NDR rep of socket_$net_addr_t.data }
    socket_$sizeof_hdata = 12;          { bytes in the NDR rep of socket_$host_id_t.data }

type
    { Generic socket address.  ("struct sockaddr" from "sys/socket.h")
      Network address plus port (message queue within host). }

    socket_$addr_t = record
        family: socket_$addr_family_t;
        data:   array [1..socket_$sizeof_data] of byte;
        end;


    { Complete network address.  Host & network ID.  A "sockaddr" without 
      the port. }

    socket_$net_addr_t = record
        family: socket_$addr_family_t;
        data:   array [1..socket_$sizeof_ndata] of byte;
        end;


    { Host identifier.  Uniquely identifies a machine, but you may need to use an
      "socket_$net_addr_t" to actually talk to a machine.  For some families
      (e.g. Internet), the network address and host ID may be identical;
      for others (e.g. NS), the host ID may be a strict subpart of the
      network address. }

    socket_$host_id_t = record
        family: socket_$addr_family_t;
        data:   array [1..socket_$sizeof_hdata] of byte;
        end;

end;
                                                                                                " * [UCX.V13.BL13.RPCKIT.B]NCASTAT.H;1 +  ,    .     /    4                          - !   0   1    2   3      K  P   W   O     5 	  6  e  7 J ϓ  8          9          G #  H  J                               
/* @(#)ncastat.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

#ifndef nca_status__included
#define nca_status__included
#include "idl_base.h"
#define NCASTAT_IDL_SUPPORTS_V1 ndr_$true
#define nca_status_$comm_failure 469827585
#define nca_status_$op_rng_error 469827586
#define nca_status_$unk_if 469827587
#define nca_status_$wrong_boot_time 469827590
#define nca_status_$you_crashed 469827593
#define nca_status_$proto_error 469827595
#define nca_status_$out_args_too_big 469827603
#define nca_status_$server_too_busy 469827604
#define nca_status_$string_too_long 469827605
#define nca_status_$unsupported_type 469827607
#define nca_status_$zero_divide 469762049
#define nca_status_$address_error 469762050
#define nca_status_$fp_div_zero 469762051
#define nca_status_$fp_underflow 469762052
#define nca_status_$fp_overflow 469762053
#define nca_status_$invalid_tag 469762054
#define nca_status_$invalid_bound 469762055
#endif

                                                                                        $ * [UCX.V13.BL13.RPCKIT.B]NCASTAT.IDL;1 +  ,    .     /    4                           - !   0   1    2   3      K  P   W   O 	    5 	  6  
  7  O] ϓ  8          9          G #  H  J                             %pascal

{*	@(#)ncastat.idl	2.1	ULTRIX	6/13/89
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
 *}


{ NCA_STATUS - NCA-defined status codes. }

[uuid(3c667ff91000.0d.00.01.34.22.00.00.00)] interface nca_status_;

{*
 * Define the versions of stubs that this instance of ncastat.idl supports.
 * Defining a constant named NCASTAT_IDL_SUPPORTS_V<n> (regardless of the
 * value assigned) asserts that this version of ncastat.idl supports stubs
 * of version n.
 *}

const
    NCASTAT_IDL_SUPPORTS_V1 = true;


{*
 * NCA-defined status c                                                                                                                                                                                                               $+                                                  =                       	 obrub
11COM;1                                                                                                                                      ez,]mQwX^s&Us7n
2)dQKc?T7aRJtK
OHSW)&OxTBY$l-H0^/maI`Qy,"cQO-
rL2S[aG+nGCcBE*ZQv}@@WHNp0nTAL\ONbD*uPJ4\&qOTz3i=$q@ 1`KzdHbG}s&!1
Pj`>W B&7`'n0
.,3{+SP-8V1TiS%Vq,n1g)P51,(1d;c:
PTX"q"b,HfvK^n#k_R3&q2YBQ jZJYT`1&'mv,]
Sj8~<IUqPbNw}${ 
mI[Ny1O[gOk?D}R8I,Dx')Rxs>
09q+
9??e?KM
3Smk=w<il@-Cx4fo~Y ]QZT>a 

YF8<XU0Q^K\{RN`&&/ZBv-_n'QRo?n96w, E/j;bBEB@?4lj@r RKT2.OD$IH`:quP@U84Z	 *`Id"GYvLHE\TF	`8;KH#aOqy5//TDNF^5^u_X^/}()M@"@RV 9i]S&+QKH#MpoZ[c
QC,LP&Qw(_*bV^j%^hX
PE&Dh/}W	qdA9|J\pMry<A1|/0jM8JIhpeV~0%B{[w fLt Qx3G>g
y.XR "7>GA0uBW(LSSdcUSkF
eLJ4b[4+QAV>[GLFZ(
)~&YKEeV
@^_
C0a0\%> @n*%<C\F {/5eu9{F\/h^a\jW>IB^LF-XweB|2g.BIHjQo~UJm}}
2Os":!{0.sz>
{|l 'Vto{#v{_k/V@{!zG&V[4kyM/7_:Rnj&0)8{_La ]=]Ty<Lat"[zVfy YQXnA5(q. "Cmw gL?KT59*4]!0le;z?2??sA;o"sRXcF mPT/7e| e6~`"SEu{k
"*}4vzvJa/Ez\h=w;Jv#nd-B24.qbM&'G[,'e82A"ZWe:Q$R]\Q/Cg[Y@Gu[w!4:
o*p1Ro%t>=Z`NQpnO80$^D!kk&ktd3v'dJqtLhy7pc4=Pq/1Qn[2PV^h<06]7g1,n37^ǥ~(n*eo% 3Yssc>S)vnnZ=<po+mutL> M7>fL0~89];`f8LxV?=w52=!H+[+\hCi
YrK
pA&2W7=`l{~UM%+wp-'E@#U}	Zj*=l2)x_ "|0%=ZLuAD]	IXAG
m,K2*,EDyT7X'WmOMVX;EdDCYzPCDd.VQ
[<P(Ch;#AE/f0r=J`NHKob/!QiOc& qyd2nUKvkHEr]\MJB,3V(.*]DYLxf@#"Wh&K!qu>l=;E#dP'WY6b$)uyc7coWf
V }6^H6OC*P{CH9R#v ~?MpYSW!
<{`aha	5G_Q}}>6_]%:mH;iL%Td9%OJ1(PL8VaqI]b6Z2JkXx7e
oX^JFAPoc?n|:&n:n*u?\zB;,f0(jwJ.>G
K%q@An9ES(0>R|:VFYIF19dECO\	*|DV]z9jpV"3Lj}FLc+TXz.t.f;im=b}i?mW@RK`S't65cWx& R?Z9Jcz86.-	Og7~YK$OYQ|E!C,pp!3!u@%PXJ^%5? ;W]0
D po5,L< kSf'9~$fUWZ\AQ4BGX3rBIs}i1oCX8c|$;{kUo4`-<]&}OI/e5O5]N_IkL,.8mF"?Apu0A]Nqo)"<2_1Ig618c5p%j3q>6*|!y*dC  [
bzGW^CKpv@r_#qp
1YrF
Y#,>0`P>G:EZ	+}r0 z/R
lYY:MjYwe#y?\<U"16;\NH|))H
B YX>nX|n;_|J Nh?Qm/^%CVKfpz #r~XJ
UYn4X[eo3A	\@Zr8uBL@]kG;H\ AwPa[Ow?IF zG5~3/'c)!cWHHX`,!Ho2\"c$m|}pJPt?}c-R';9;e9TTM##f@k[g2[r|/mz5M?d.LBg=oFA5	PTT8EK[@X?oHc_WYCmdPP(Y!C7YGsy3d}.ZlphWUl0xV7'ou@TSeI&k
2:W @G<J&:?^[@#eYjcC>yP~k 24FOmtYf{L9OIFBN2~Ow~3g@"\ CRTb(1OS @i{<O}u>]r#qbaR%-NfIK}o/JeE\4')>X|nveqQ4${N.,^J=z.0MNou9G26LHTK
8a#%.Kw1/VumD(XbfL=<Vi)R	
MssmH))q]3p%l5^^r$ =uY
^~sF\`SI7$6f?p,qGO>CivJP
r
bl*g3Kx"q~%c`%^D/mjv{r1`bV02 kq $|+3<4=K`,;+mzJ[mi	X9gq2Y/%t<l|Owwl)xzZk	R1a
/z4 ~b41/
L+/9~/g^~9O'R;I C0F[+W rd8W@rtayu!u.'@cFe
<1sC
kjXL<h
MmJdgh6lp.!	t >~@G--,{-=e2~#r%0n!E:/V
8nM}##~.qz")GC50D,7q=

P[SD8{D>Je=> -CRcdswssM~v6a,vY!T]68w$3y]7'
R+2g)'wOf*nFgrqA?&{ROAN/)tmtLpQ==cxQW`/G
Fb;a("]! ]n0Dfi
e{T"EIVK2T'^6^XJ#P;Rt3%=-K4Od ^:F zoCDkwffx$N9{h*(`F)uUv
	2O(1Z~P:	a>*37`Mg/]nZ6sBe[U)6Y\1[Tr_W$}{;`E6F~l[tHq>tz/[0wh {c$kSq.6. r<zQsm#i]"5|#Ou(Q
S"In\ Z4c>Bufn/U<z09N d`gvT	0Lr<V"vc	#YDU _8j%(:
7GL,hd
21A%?9w9(7P5Q\74lN6&:W18*uOmb<jXc'79=iL< +Xj-]&KsQaGae`OKE e>
F(|po4WrRgL3,Ww{M`VQ^kX"YL9P-H~Xb[qV-E	ZeTEkWXH@p>oHQa'@WI\6g>Pf~Q,dsiNi= tq#ZhZjyW*&Q!x|{t<mg(JR8
#KX^]$ZP}z0Jp5L{t(I/+-@(f"8TJ*oe
s~,mYE/_1`9BSozd
50B
6>JDN]rdl_	YJB<u.<1;aV[Y|#dXz%V<wVF)Q
[QMg&h7~d'ch RoPiZV;
%n7Z&WLM^}u'&7{@[P%'am	 C1+~I+e]-W>7_#e'/]XNfI[OH5h7gEtM."9M&rN9^kt:]N,cx]&3EWN7R0
Yf3}*6 KePF(Q'KdX8
WZU~k&`(ffL5:yrq}s_3iK\L@W`-|H,$x8@BZ1If'IrI_EK`. DgJR/ltde}<!=CCop5	> .&,DZFLVVB"&eT^ekjjz3^sy?yCg^xPA<zP1xYJ"hvg%WD,)-[l"6J58B
d$yL<,p'Q&K|d?S G+&Z5R4[rtPM
> i]w=K":G2g r5ZlP(1[;dBA[.C]MhBWvj)@4 E`JNQAs$dc/9msu)0ESm(PF:v*;@[,,2"O\G4#%+
:ao8Ca6xZ'03~4Ao9S(/bRIq&J"KaV
,-;ak[Pav1Pp-uuLI`vZc65R
.o1BiJjF?M:)c7Mb+\K@~SoV&5a=X!#	ErJ
E_^l2+ JghtGQ>_gB.nR>Fm@}9
hvZ
eU %#od0.>(@$IZ@c")voMz*z\"(ERv2\IM.HE7s![{E!'1*L_Q((Irx^tSB[1HX?KYvh]8GT_+}3Lj,SXz62FV $?99<1J_q XP;kyB@_Ok_dd~hD<	
MK!u ct@..kI4NWx{|gM5uRyPig`K

9M<E 1}17eP#Dve6MEmh%8eY!W1y#|!+kpuU|	vD(TTGj,C\M
Kx1,	(7YPit%=Wcor>!&dl+r8/2KO, 2.F&^90BanE!o^/ US@tSPmm5}`@5l]QKa@8RwPJ$~>U_KC?-xv}>ObbQ?YMwrFE2_eE>
Uwq
5SUwZ]"y]SJd1e<#"<Z62l(i
z#0dNgV/F&0J^n~O\17*axU$52*GZ]5^,d0`3@9*?q<M:7T		wOG9G+652;WE{@)
8{`_]DRl|qP}/W@IN;KOu8![|sqi8N(Ou&m
S$?DQkq7%'v!"Jd{<Vt=O>>`h)O@owHNNe|ice<-k\0W<hX G=CkL"4z+	<\r\<[FswIg'%${sS l]5Ej{#_Wj"a%P2=uII7I==_qu)Bj:UY$W
C"~1M18;kNlfSPc<(%cCMs[]7K!@~Fa[#B!>l#R$
kQ}{nwfA,k5,bm\SUF^S:Y%.p;L6H!U{ak$	hg4|%Hk0p=8{s2-&Z<\imd*^^bmKwDx*A%ppO+v-[BPlKLk'C{AQ @"b3PJ"
' i3H~,>4eGB^_
!zT*V: codYQPIy&pke&>HnSkmH7S1Q(t@eI$@G%(/u% t;DL$I	e01o>pbF=DPrBMtW?1@{A1_ySCWP_@1:UYZ'|csan!Ski_X /lEqGXp1?(h$jJzjJfZf\peN`8#NnS[tt:oYC|_qJ~flZOFp	;%,#r1Kb{WY)&]l6wS2T ~(s	skXJ2
f.7[)W\y?x)1oA(y5"*G,JVWRnZX?gIa|QU,xvkE0>&GGQ Z
Rq62bt&WH"<wi'Ze*&s|9: CN<e.[4Hy nE	l(c\s"ZcEyb~7j:pZp34rgy:X37q:6+R#WC\/L+
EnsNtla24N
Op+5	q&sC1Kou[zoyu17 mqKu|^$
7LSQ]a,k|HQ
\M+J[;SI=np]fEa~?IqhoSNR
agQ?BrTjm.\1LlWT@$Ty gs,'+D8EC[;2t&7J~JV8)7T"
%&4hiz4d*XDV$5Y"|?(1|Z|a4&(6o0<r/,Apo~i!//8Z<s%'uvFzuV*Gl,QK*2	 g~]i4j@$6E{zA:
D 7;D0BI"k JY^RMDM>+;aE1i TK
1uA	 a4qPH>R2CM n9_J`=\?uE<`L9:D.,?U[NZLW#G_%hYeZ<D$:qR.3uxK["E:}l.f<L;#G3Bv@HO@nnWq21[)cU\9R`-F?wGzmziC:WXS`'slvjy1XyCmetoAJu)U~X2]R%16QBKrBaOj|l @MMW],32 7F+|_A\IgR?/o[_:Up|~@N*?X!6Y1
LGhcHUX
	l21YNxj#[`&sw5hd1JLUB+=gj]\L{=X3C;a@_W;g!d[\79 oiq#?JB-5pMBi|r}-V_T9O1o7Y8~c?uw6bdZ2L1Fh3U>}:9]8YfW`>!fX5.IM#NY S+>=)|-:
-Re<jq|9!JPTxCg,kC0T$bGmN"Kcm7]^r &!~n:`||aE,p
67.ez' 3}f((@@N:tz)y6p*PG+.zRC$U#[coW2T_=VK*7ly/jd)"T5/+3R@1f~:,rNc]a@Hz
?rS{HzP&\o9
"2{5q/F}w6Z;=10wk`S`
AhtO!0h#	7dq*BKDNKe{s@0I-SZx}I!#s1Cb$zK%~NIE_jly
 dpXB'E(~$_c_
+5Ig?s8E/;?t$)t=/t]t@@wS`ΨL GKc:~*"}jf\@XosYvKA]8O/*egYh$inC+K-^;zFL~,DZjC%"8v~ y=~pe1Repz9_xvk20OEMU^ai|_LpI^n~mOyBE,wh5{2C	
	>Q]4Ey=W;v
9RPd5QrNV)S3T>.lEY~Ao)Y+j8pj=R6%~[b2t {eg	++J&;t
Q!0i{0	\0sAh^G|"I"Zy(,(pW {q>qiH!>uz,j=BCxSoqU"sfxs>Z#R'NCK 
uXm  L1>/aTro{(1G%hW{`sV8k;9Zq~yY$au6~O(f/>0P#MRCR;(qJN
$1<L4zD:NS026bd"
Aj6WGi$lkBe%Ll_k\?%KU^2&<2
	R:>w|?-d:aL#&H2se|oBwYmPp/f`k3wA5lUlERjN;/SrqTFyhD 2q

d'_.sxG*pTAF)t!_X @V3BMTn]?R4[ESM8"CmRhe8U&gLgl'g+& I4I+tIu
RQI
NB
9kPM	h]q+BYgrX9a13EMxW_
"GX{tSVe#9q
3Px(fSOp
w^X}|g;vOzQEEqTgb] A<zC1T3E&[v%}poJ!`U)T\Wx O4\T	ia&InIM	44`o1Gz/]W9*tle-FfpBSh_{}f5EwJD1Nv`a4_?f'+XvKFAGwdK |&j: ;,q&[Qemu3q>P*@lJR+W+EqYCY7Km,OPGYb1xVYuZFKwlEOr*_WKmSVtavE[6Il0)WDX
	Mw)(bu; 04K#MY$
<`xky9Q-l|BoKC?~VGb=]Al XWEVQ^G+ca:;B,i1H3"gA?Xa7G
OSH@ F~Ar>L1}58F[iATh b8 b;S~\Iq3vI[FED@LOEz!9}.*^rl2r#) *nikefined status c                                                                                                                                                                                                           eE        RPC010.B                         !  $[UCX.V13.BL13.RPCKIT.B]NCASTAT.IDL;1                                                                                                                        N             odes.  These codes are "well-known" and part of the
 * NCA/RPC protocol (e.g. they are sent back in "fault" or "reject" messages
 * from servers).  For historical reasons, the first few status codes are
 * derived from status codes use by NCS, the Apollo implementation of NCA.
 *}

const
    nca_status_$comm_failure        = 16#1C010001;  { unable to get response from server }
    nca_status_$op_rng_error        = 16#1C010002;  { bad operation number in call }
    nca_status_$unk_if              = 16#1C010003;  { unknown interface }
    nca_status_$wrong_boot_time     = 16#1C010006;  { client passed server wrong server boot time }
    nca_status_$you_crashed         = 16#1C010009;  { a restarted server called back a client }
    nca_status_$proto_error         = 16#1C01000B;  { someone messed up the protocol }
    nca_status_$out_args_too_big    = 16#1C010013;  { output args too big }
    nca_status_$server_too_busy     = 16#1C010014;  { server is too busy to handle call }
    nca_status_$string_too_long     = 16#1C010015;  { string parameter longer than declared max len }
    nca_status_$unsupported_type    = 16#1C010017;  { no implementation of generic operation for object }

    nca_status_$zero_divide         = 16#1C000001;
    nca_status_$address_error       = 16#1C000002;
    nca_status_$fp_div_zero         = 16#1C000003;
    nca_status_$fp_underflow        = 16#1C000004;
    nca_status_$fp_overflow         = 16#1C000005;
    nca_status_$invalid_tag         = 16#1C000006;
    nca_status_$invalid_bound       = 16#1C000007;

end;
 

o                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    * [UCX.V13.BL13.RPCKIT.B]PBASE.H;1 +  , 		
   . 
    /    4 _   
   
 s                   - !   0   1    2   3      K  P   W   O     5 	  6 F˓  7  u ϓ  8          9          G #  H  J                 
/* @(#)pbase.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
 * Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
 * Copyright Laws Of The United States.
 * 
 * Apollo Computer Inc. reserves all rights, title and interest with respect
 * to copying, modification or the distribution of such software programs
 * and associated documentation, except those rights specifically granted
 * by Apollo in a Product Software Program License, Source Code License
 * or Commercial License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between
 * Apollo and Licensee.  Without such license agreements, such software
 * programs may not be used, copied, modified or distributed in source
 * or object code form.  Further, the copyright notice must appear on the
 * media, the supporting documentation and packaging as set forth in such
 * agreements.  Such License Agreements do not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * ========================================================================== 
 *
 * This header file exists because "nbase.h" (derived from "nbase.idl")
 * doesn't have all the stuff that the Apollo-specific ".h" files (included
 * when building for Apollos only) need.
 * 
 * On non-Apollos, this file simply includes "nbase.h" (i.e. the includer
 * might just as well have included "nbase.h".)
 * 
 * On Apollos, this file (a) includes "/us/include/apollo/base.h" (which
 * defines some of the same things as "nbase.idl", some more things not
 * in "nbase.idl", but lacks some things that are in "nbase.idl, and (b)
 * defines those missing pieces (since we're not using "nbase.h").
 *
 * Note that to make things mesh a little better, we include "timebase"
 * here as well.
 */

#ifndef apollo

#include "nbase.h"
#include "timebase.h" 
#include "name.h"

#define time_$high32(t)    ((t).high)
#define time_$low16(t)     ((t).low)
 
#else

#include <apollo/base.h>
#define base__included      /* <apollo/base.h> is a superset of the "base.h" from "base.idl" */

#define time_$high32(t)    ((t).c1.high)
#define time_$low16(t)     ((t).c1.low)

#define time_base_included
#define nbase__included     /* The following are the "missing pieces" */

typedef struct uuid_$t {
    unsigned long time_high;
    unsigned short time_low;
    unsigned short reserved;
    char family;
    char host[7];      
} uuid_$t;

#ifdef vms
globalref uuid_$t uuid_$nil;
#else
extern uuid_$t uuid_$nil;
#endif

#define socket_$unspec_port 0

#define socket_$unspec (short) 0x0
#define socket_$unix (short) 0x1
#define socket_$internet (short) 0x2
#define socket_$implink (short) 0x3
#define socket_$pup (short) 0x4
#define socket_$chaos (short) 0x5 
#define socket_$ns (short) 0x6
#define socket_$nbs (short) 0x7
#define socket_$ecma (short) 0x8
#define socket_$datakit (short) 0x9
#define socket_$ccitt (short) 0xa
#define socket_$sna (short) 0xb
#define socket_$unspec2 (short) 0xc
#define socket_$dds (short) 0xd

typedef short socket_$addr_family_t;

#define socket_$num_families 32

#define socket_$sizeof_family 2
#define socket_$sizeof_data 14 
#define socket_$sizeof_ndata 12
#define socket_$sizeof_hdata 12

typedef struct socket_$addr_t { 
    socket_$addr_family_t family;
    unsigned char (data)[14];
} socket_$addr_t;

typedef struct socket_$net_addr_t {
    socket_$addr_family_t family;
    unsigned char (data)[12];
} socket_$net_addr_t;

typedef struct socket_$host_id_t { 
    socket_$addr_family_t family;
    unsigned char (data)[12];
} socket_$host_id_t;

#define name__included

#endif

                                                                                                                                                            * [UCX.V13.BL13.RPCKIT.B]PFM.H;1 +  , 	   . 
    /    4   
   	 f                   - !   0   1    2   3      K  P   W   O     5 
  6  y
  7  ϓ  8          9          G #  H  J                                                                                                                                                                                                                                                                 ;RS        RPC010.B                       	  !  [UCX.V13.BL13.RPCKIT.B]PFM.H;1DL;11                                                                                                
                         j             
/* @(#)pfm.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Copyright  1987 by Apollo Computer Inc., Chelmsford, Massachusetts
 * 
 * All Rights Reserved
 * 
 * All Apollo source code software programs, object code software programs,
 * documentation and copies thereof shall contain the copyright notice above
 * and this permission notice.  Apollo Computer Inc. reserves all rights,
 * title and interest with respect to copying, modification or the
 * distribution of such software programs and associated documentation,
 * except those rights specifically granted by Apollo in a Product Software
 * Program License or Source Code License between Apollo and Licensee.
 * Without this License, such software programs may not be used, copied,
 * modified or distributed in source or object code form.  Further, the
 * copyright notice must appear on the media, the supporting documentation
 * and packaging.  A Source Code License does not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * 
 * Apollo disclaims all warranties, express or implied, with respect to
 * the Software Programs including the implied warranties of merchantability
 * and fitness, for a particular purpose.  In no event shall Apollo be liable
 * for any special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits whether in an
 * action of contract or tort, arising out of or in connection with the
 * use or performance of such software programs.
 * ========================================================================== 
 */

#ifndef pfm_included
#define pfm_included

/*
 * Process Fault Manager definitions -- *OLD VERSION*.  See "ppfm.h" for latest
 * version.  This version retained for compatibility (esp. of "pfm_$..." macros
 * below).  New applications should use "ppfm.h" and the new-style "pfm_$"
 * macros defined there.
 */

#ifdef apollo

#ifdef __STDC__
#  include <ppfm.h>
#else
#  ifdef DSEE
#    include "sys/ins/pfm.ins.c"
#  else
#    include "/sys/ins/pfm.ins.c"
#  endif
#  define pfm_$init(junk)
#endif

#else

#define pfm_$cleanup(crec) \
    pfm_$__cleanup(&(crec))

#define pfm_$rls_cleanup(crec, st) \
    pfm_$_rls_cleanup(&(crec), &st)

#define pfm_$reset_cleanup(crec, st) \
    pfm_$_reset_cleanup(&(crec), &st)

#include <ppfm.h>

#endif

/*
 * The following are here only to deal with an interim, botched naming scheme
 * that will eventually go away.  Do *not* use these names.
 */

#ifndef apollo
    /* Non-Apollo */
#define pfm_$p_cleanup          pfm_$__cleanup
#define pfm_$p_rls_cleanup      pfm_$_rls_cleanup
#define pfm_$p_reset_cleanup    pfm_$_reset_cleanup
#else
#ifdef __STDC__
    /* Apollo/ANSI */
#define pfm_$p_cleanup          pfm_$cleanup
#define pfm_$p_rls_cleanup      pfm_$rls_cleanup
#define pfm_$p_reset_cleanup    pfm_$reset_cleanup
#else
    /* Apollo/non-ANSI */
#define pfm_$p_cleanup          "pfm_$p_cleanup not allowed"
#define pfm_$p_rls_cleanup      "pfm_$p_rls_cleanup not allowed"
#define pfm_$p_reset_cleanup    "pfm_$p_reset_cleanup not allowed"
#endif
#endif

#endif
                                                                                                                                                                         * [UCX.V13.BL13.RPCKIT.B]PPFM.H;1 +  , "	4   .     /    4       q                    - !   0   1    2   3      K  P   W   O 
    5 
  6  u  7 ޛ ϓ  8          9          G #  H  J      
            
/* @(#)ppfm.h	2.1  (ULTRIX)        6/13/89     */

/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 * ========================================================================== 
 * Copyright  1987 by Apollo Computer Inc., Chelmsford, Massachusetts
 * 
 * All Rights Reserved
 * 
 * All Apollo source code software programs, object code software programs,
 * documentation and copies thereof shall contain the copyright notice above
 * and this permission notice.  Apollo Computer Inc. reserves all rights,
 * title and interest with respect to copying, modification or the
 * distribution of such software programs and associated documentation,
 * except those rights specifically granted by Apollo in a Product Software
 * Program License or Source Code License between Apollo and Licensee.
 * Without this License, such software programs may not be used, copied,
 * modified or distributed in source or object code form.  Further, the
 * copyright notice must appear on the media, the supporting documentation
 * and packaging.  A Source Code License does not grant any rights to use
 * Apollo Computer's name or trademarks in advertising or publicity, with
 * respect to the distribution of the software programs without the specific
 * prior written permission of Apollo.  Trademark agreements may be obtained
 * in a separate Trademark License Agreement.
 * 
 * Apollo disclaims all warranties, express or implied, with respect to
 * the Software Programs including the implied warranties of merchantability
 * and fitness, for a particular purpose                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  RPC010.B                       "	4  !  [UCX.V13.BL13.RPCKIT.B]PPFM.H;1b
11COM;1                                                                                                                                 .  In no event shall Apollo be liable
 * for any special, indirect or consequential damages or any damages
 * whatsoever resulting from loss of use, data or profits whether in an
 * action of contract or tort, arising out of or in connection with the
 * use or performance of such software programs.
 * ========================================================================== 
 */

#ifndef ppfm_included
#define ppfm_included

/*
 * Portable Process Fault Manager definitions.
 *
 * Because this interface has undergone so many variants, we enumerate the
 * exact interface below.  Portable programs should use only what appears below.
 * (Note that some of them are actually macros.)
 *
 * void pfm_$init(unsigned long flags);
 * status_$t pfm_$cleanup(pfm_$cleanup_rec *crec);
 * void pfm_$signal(status_$t st);
 * void pfm_$reset_cleanup(pfm_$cleanup_rec *crec, status_$t *st);
 * void pfm_$rls_cleanup(pfm_$cleanup_rec *crec, status_$t *st);
 * void pfm_$inhibit_faults(void);
 * void pfm_$enable_faults(void);
 * void pfm_$inhibit(void);
 * void pfm_$enable(void);
 * void pgm_$exit(void);
 */

#ifdef apollo

#include <apollo/pfm.h>

#define pfm_$init(junk)                 /* No initialization required on Apollo */

#else

#ifdef MSDOS
#define _JBLEN 20                   /* Must match std.h */
#define setjmp  setjmp_nck
#define longjmp longjmp_nck
typedef char jmp_buf[_JBLEN];
extern long setjmp_nck(jmp_buf);
#endif

#ifndef _JBLEN
#  include <setjmp.h>
#  ifndef _JBLEN
#    define _JBLEN (sizeof(jmp_buf) / sizeof(int))
#  endif
#endif

#define pfm_$module_code                    0x03040000
#define pfm_$bad_rls_order                  (pfm_$module_code + 1)
#define pfm_$cleanup_set                    (pfm_$module_code + 3)
#define pfm_$signalled_zero                 (pfm_$module_code + 0xffff)

typedef struct jmp_buf_elt_t {
    struct jmp_buf_elt_t *next;
    int fault_inh_count;
    jmp_buf buf;
    long setjmp_val;        /* This is "long" and not "int" on purpose -- keep MS/DOS happy */
} pfm_$cleanup_rec;  

void pfm_$signal(
#ifdef __STDC__
    status_$t st
#endif
);

void pfm_$inhibit_faults(
#ifdef __STDC__
    void
#endif
);

void pfm_$enable_faults(
#ifdef __STDC__
    void
#endif
);

void pfm_$inhibit(
#ifdef __STDC__
    void
#endif
);

void pfm_$enable(
#ifdef __STDC__
    void
#endif
);

void pfm_$_rls_cleanup(
#ifdef __STDC__
    pfm_$cleanup_rec *crec, 
    status_$t *st
#endif
);

void pfm_$_reset_cleanup(
#ifdef __STDC__
    pfm_$cleanup_rec *crec, 
    status_$t *st
#endif
);

status_$t pfm_$_cleanup(
#ifdef __STDC__
    long st, 
    pfm_$cleanup_rec *crec
#endif
);

#define pfm_$__cleanup(crec) ( \
    (crec)->setjmp_val = setjmp((crec)->buf), \
    pfm_$_cleanup((crec)->setjmp_val, crec) \
)

void pfm_$init(
#ifdef __STDC__
    unsigned long flags
#endif
);

void pgm_$exit(
#ifdef __STDC__
    void
#endif
);

#ifndef pfm_included 
#define pfm_$cleanup            pfm_$__cleanup
#define pfm_$rls_cleanup        pfm_$_rls_cleanup
#define pfm_$reset_cleanup      pfm_$_reset_cleanup
#endif
                                     
#endif

/*
 * Flags to "pfm_$init"
 */  

#define pfm_$init_signal_handlers   0x00000001

#endif
n                                                                                                                                                                                                                                                                                                                                                                                                                            ) * [UCX.V13.BL13.RPCKIT.B]RPC$LB_ADMIN.EXE;1 +  , #	(   . 0    /    4     0   0                     - !   0   1    2   3      K  P   W   O 1    5 	  6 ǿΓ  7 @. ϓ  8          9          G #  H  J                         0 D X     0205      (  =N        P                                      RPC$LB_ADMIN                           RPC V1.0A-00   @=Γ 05-05           	            
        #           (           F   
  .     ?   #      +         RPC$LIBNCK_001       !        VAXCRTL_001      !        
LIBRTL_001      !       
MTHRTL_001  add clean delete register unregister set_broker set_timeout use_broker lookup exit quit help ?  garbage_collect gc * lb_admin/nck version 1.5 -nq lb_admin:  Known commands are: 
	 %-15.15s  
 help                            -- yields list of known commands
help command1 { command2 ... }  -- yields information on specified commands
 exit or quit                    -- terminate session
 bye.
 Unknown command: %s
 ?(lb_admin)    global local 	Unknown option '%s'
 unregister object type interface location
                                -- unregisters the specified entry; '*' is a wildcard
 Usage: unregister OBJ TYPE INTERFACE LOCATION
 register object type interface location annotation { global | local }
                                -- registers the specified entry
 Usage: register OBJ TYPE INTERFACE LOCATION ANNOTATION {global | local }
 set_timeout { short | long }    -- set rpc timeout mode
 Using %s RPC timeouts
 long short short long clean obj type interface location -- cleanup registry database
 set_broker { local | global } location
                                -- select broker location
 Usage: set_broker { local | global } LOCATION
 global Usage: set_broker { local | global } LOCATION
 local Usage: set_broker { local | global } LOCATION
 %s - illegal broker specification
 use_broker local | global       -- select local or global broker for operations
 Using global broker @ 
 Using local broker @  
 global local lookup object type interface location  -- search for matching entries
 <unknown host>  %.*s[%lu]  <invalid address>  \0%03.3o "%s"  @  %s
 global   ------------
 %12s = *
 object %12s = %s
 object %12s = *
 type %12s = %s
 type %12s = *
 interface %12s = %s
 interface  @  global 
 quit go yes  
 
        Automatic deletion in progress - this entry retained
 
        Invalid Address Family.  Delete?  working  .  
 
 
        Server not responding - unable to contact remote site. 
        Server not responding, but registered in remote llbd database. 
        Unable to communicate over selected address family. 
        Therefore unable to verify server status. 
        Server not responding, and is NOT registered with remote llbd.  %sDelete?   
        [using short timeouts]  
        Server not responding, and is NOT registered with remote llbd. 
        Automatic Deletion - entry DELETED.
 
        Server does not support this interface.  %sDelete?   
        [using short timeouts]  
        Server does not support this interface. 
        Automatic Deletion - entry DELETED.
 
        Automatic deletion in progress - this entry retained
   %sDelete?   
        [using short timeouts]   No entries match.
 delete ?  No entries match.
 No entries match.
 
%ld entries deleted of %ld entries processed
 
    Data from GLB replica: %s

 No entries match.
 ------------
   r #include rpc$exe:uuidname.txt @(#)lb_admin.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                                                          96                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           F+        RPC010.B                       #	(  !  )[UCX.V13.BL13.RPCKIT.B]RPC$LB_ADMIN.EXE;1                                                                                           0                                      @  
  f                                           |Z  `Z       \  p\     
  Z   Z       |Z  `Z       Z   Z     %  \  \     0  [  [     <  $^  ^     G  4_  _     N  V  V     S  V  V     X  PT  lV     ]  PT  lV     _  HT  HT      `  \  p\     p  \  p\     s  V  V         V  HT      *                                       *                                       *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @(#)lb_args.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           @(#)uname.c	2.2     (ultrix)        11/15/89                @(#)balanced_trees.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                                                            ^<  SRߣu  ݬݬ*<  ѬЬPݠÎ ϗP      d  2 P| $^V﮼\<  ߭;  ݭf;  f<<  f(;  ̸(;  ̨(;  ̘O;   ;  P P ^R %ݬ;  Pݭݬ2PP;   ^SﺻRÒ \\ݭ ^;  S޼RbB޼P`PPP@cPP޼R޼P`PPY;  PPPbPP޼P`  ^ ޼P`P޼Q޼Pa`CPPPPPPP޼P`
޼P`PP޼Q޼Pa`޼P`ѭP2  P ^￺Rݏ   ݬ:   P@ P`zPP@P`P@ P`P6ѬP@P`PPѬP@P`PPPPP@ P`  PPP ^޼RЬP9  QPQQb޼RbaЬRЬRЬR$  ЬR"ЬSЬRRbPPЬS   RRPЬS  RRP  ^Y\ χ5 "  P*P "  P	 ~"   !    TPP 
    @PP  ^  ^P< ^來U͸SЬR1.ŝ 8   RB R޲ Rb1 z  P{PQPPRRű n8  P@ Rb ѭe`ЭQЭRPPbAP@Rѭb#RЭP@BЭP[@PPPPѭP@RѭbЭPRR]@ЭR B߭Ŵ 7  RRP@ R޲ Rb1ž 7  sPЬRѭaЬRTЬPЭRPB`dЬTЬPЭRPB`}PݬЬRRbRRЬRѭP ^R P@ Pް P`3ݬP@Pް P`PPP@ Pް P`  ^\   6    ^m\N  6   ^QRh6   .6   ^-RЬPPݠ   56  | ^V^(   E5  < ^޼R(5  b޼Rb*ݬݬ%  P ^ﰪSٵR ЬQPPЬQЭPQ@a r5     ЬQPPЬQЭPQ@aH45  H  ЬQPPЬQЭPQ@ap4  p  լ1ЬQPP1 ߭ ЬQЭPQ@a4  PPPЬQЭPQ@a 3  PP
P` ЬQЭPQ@a	S4  ì	?4  í	+4  	  Ѭ1ЬQPP!ЬQЭPQ@a3  P   PPЭЬPѭ1 ЬQЭPQ@aîrPPPNЬQЭPQ@aõBPPPЬQЭPQ@aûO3  PPЬPѭ1k  2 P  ^\  
3   ^٧RЬPR2  PݬP S  P  ^\  2   ^yRЬP	2  PݬP G  P| ^eV޼R(ƘbЬR(ƨЬR(Ƹ ݏ@   ЬR42  ЬR0RbݬЬRtЬRx 	1  PRR	 $1  լ޼RbЬRtR bЬRѢtЬRѢt޼R bP޼RЏ b ^eRS  z1   ^IRrSЬP.¨PP
£PPݭ+1  qЬPPݠ®P
:PЬPPݠ´ϪP
 Pݬ9 /  P ^R  0    ^ ݬP     ^I\  ^0   $^-SVR ЬP[ 0  1 ÊЬPPݠ/  P'ЬPÑ/  	BPЬPPݠ/  P#ЬP/  	 ЬQЭPQ@aݭ  P<խЬQЭPQ@a3  ЬQЭPQ@a   PЬQЭPQ@a                                                                                                                                                                                                                                                                           f M        RPC010.B                       #	(  !  )[UCX.V13.BL13.RPCKIT.B]RPC$LB_ADMIN.EXE;1                                                                                           0                         R             /  P  ^\  /   ,^ѣRSЬPf0i.  !
   .  ..     .  mЬPPݠK.  P]  7P ЬPPݠ.  P 1  P   P  ^ݢ\  -    ^ ݬP    ΀^RЏd   ޼P<`PP,  PY߭߭߭ݬݬ,  PPP`f-  ݭ߭ݭL-  P<-  P Τ^S0-  TͯPPЬR4PP PPPPPP1 PPʏP@dPhPP(ЭRPPЭQPPaPPPPb1 PPʏP@dPPgЭQPP^aPPA   -ЭRPPЭQPPaPPA   PPPPbЭQPP?aPP-ЭQPPaPPݭ
,  PP? ͯ$  +   ^﹠Rݬ)+  ЬPݠtЬPxЬPˏ0PP
8PPP1PPݭ-  u+   `^CVlW 9	2+  P9߭ 	+  PRR	 \*  խ޼R b ѭ1PGŏ   SЬRCtRbŏ   SЬRCxݭ)  P1Pլխh ŏ   R޼SBc)  PG0ŏ   SЬRC)  P%@ŏ   SЬRC )  P1:$*  )  ŏ   R޼SBcm)  PRH)  :Pݏ@   ߭ŏ   R޼SBc  ߭dY)  =)  ŏ   SЬRC(  Puk)  :ݏ@   ߭ŏ   SЬRC`  ߭ƅzC)  (  ŏ   SЬRC (  PƔƊ)  9ݏ@   ߭ŏ   SЬRC   ߭Ʃƞ(  ŏ   R޼S(Bc ŏ   SЬR(C0ŏ   SЬR(C @ŏ   R޼SBcEƳq(  ŏ   SЬRCtRbŏ   SЬRCxsŏ   SЬRC0RˏbRRƷ(  ƾ
(  RRѭ1
լ޼RЬb  ^ݬ'  ޼P` PPP޼P` ЬP| ^﹧V:ݬ'  RRRb^(nF޼RbFPݬ&  RRRb^(n޼Rb ^R ޼P`P߭PݭϳP޼PЏ   `ЭPݭώP޼P`޼P`ݭjP߭ݬP| 0^V޼R bЬRݢtЬRx޼Rb%  Pխխݭ%  @S@R%  PD@@RݢD8m%  8<< Rˏ<RR  ^(<nώ/< 	޼Rb< 	޼Rb޼Rb< 1 ߭  ݭy%  Rbխt$  ЬR $  P
޼RbQ޼Rb ѭ>PЬR ŏV   RBfr$  P
޼RbRRѭ<  J$   ?$  <@3$  ޼Rb޼Rb޼Rb1 P ЬR(x͈ЬRޢtRb ߭͈#  խ͘߭߭ݭ͈ЬR ЬR޼Rb
#  խ޼RbPѭ ޼RbP |^טR Sլ޼P ` T P 	#  P;P߭ 	#  PPP	 "  խ X ѭ1XPPX ޼P`լ	޼PX`Qŏ   QЬPAtP`ŏ   QЬPAxݭP"  PXPPX1^Pŏ   QЬPAxP>`P<`PP"  P1 T Tϲ  ߭ݏ   ŏ   P޼Q@aPv"  Fh"  ߭ݬŏ   P޼Q@a PЬQaPPaխЭP1PT
9BTPPTT
E T߭ŏ   P޼Q@aIѭѭP1%T TGϧ  ߭ݏ   ŏ   P޼Q@a	ѭIk!  1PѭV!  1;Pѭ>!  2!  1Pѭ1 P-PP	PPݭA   ·      Pݬŏ   P޼Q@aPЬQaPPa1
1 Pѭ1 P-k	PP	j	PPݭ-	g   	X   ½	L   Pݬŏ   P޼Q@aPЬQaPPa1 P	   g8
PPP7
PPݭ*
  ߭ݬŏ   P޼Q@aPЬQaPPaխЭPPPPѭ1լ	޼PX`P| t^CVl\   Ԑ ͬRR
P   ͨ߭͘ 	  PRR	 :   ͗r  ̘>  P3[  ̨'  PD  ̸  P͗ʐ ͕#  ̘  P3  ̨  P  ̸  PP͕ʐ ͖Y
	  P͖ ͬͰ߭ݏd   ߭ݭݭ̸̨̘
U  RRͬʏ  ͬխZ
  'PͬRRͬRb^(ͬnl1k͕
͖1 ѭ1P1_1Vͨŏ   RB(R>bR<bRR  P1EP͗j  ŏ   RBͰ  PE  ŏ   RB`  P$}  ŏ   RB?  P1 ͖Bͨŏ   RB$Rbŏ   RB(ݭ͘  P1 PRR  ͨݏ   ŏ   RBͰm
F  ߭߭ŏ   RBͰ խխ P߭ŏ   RBͰBRRѭ1k1  ͔ ѭXͨŏ   RB$Rbŏ   RB(ݭ͘  P͔PRRѭ͔<RRͬŏ   RBͰ߭ŏ   RBͰխ1
խw
!  < \^\ pptϚpRRpRb^(pnϪptF  C.pt    "Ppt  pRRpRb^(pn- ^1SZR ߭¸¨(\\i  PխÊ
  PݭݭÝ
  P  $^߭ ݬ  PPPݬ 
  PP
P`1 PլWݭ  Эݭ`  P 
PPSPݭ  PP
P`'Pݭa  ЭbP P2  P ^RPPPPPPPPP    T^XY}W輦V   RR
P   \߭ݏd   ߭ݭݭݬݬݬ
  1 1 hhi  RRRb_PЏd   ؐ߭߭ghi  RR
Rb Pg  g
  ѭЏ 	 ZPRRRb^(n3E6Pխ.ݬ߭߭ݭ\ݭ޼RbRR խխ1P ^R\ ̸̨̘{PP(Pխ
  խ   P  ^2  P  ^P  ^P ^R q ^R¨HU ^eR¸p9  ^P  ^P  ^P  ^P  ^P  ^    ^Pޠ4\\0 8\\4 ^uRݬ  PPݬݢ0  4Q4PP4Т0a0PP0  ^ЬQPPQ޼P`"3޼P`\	PP޼P`PPP޼P`"޼P`"=޼P `PPݭ  PPPP   PPPPݭ     P ^  RnS ޼P `޼P4`޼P`1 ޼P`PPP@bPP!PPP޼P`PPP@bPP޼P`1 PЬ޼P`PPP@bPPT޼P`"
ݬϦP޼P`\	PP޼P` PP޼P`PPP@bPP޼P`޼P `ݭЬQaPPaPЬQPPa޼P`1 4    ^ ޼P`P޼Q޼Pa`CPPPPPPP޼P`
޼P`PP޼Q޼Pa`޼P`ѭЏ   P2  P ^RЬݢ0x  PխЭPՠ޼Pн`Џ   P P ^RЬݬ  Pݢ4!  Pխ#ЭPՠݽݬ  Џ   P P ^IR լh޼P``ЬݬS  P  ߢ8 =  P*&ݬ  Pխݢ8  P θ^SRݬݏ     P1_  P @߭߭ѭ1ݽߣP.ЭPݠPխݭgݭ0  1 #	1 1 Pݽk  1 PPЭPР                                                                                                                                                                                                                                                                           |        RPC010.B                       #	(  !  )[UCX.V13.BL13.RPCKIT.B]RPC$LB_ADMIN.EXE;1                                                                                           0                         ^      &         PPߢ0   }ѭGPЭP@  Pߢ4   PPѭݬݏ   M  P1 ^]\*R߬Pխݭ>ݭ  -  ^R- ޼P `ݬݬPݬݬݬ$  P 4^R- f߭ݬϕPޭPP߭ݬ  ݬݭݬ  ݭ  P
Q޼P A`  ^5  P Э\ P  ^PP?  Pʏ?  PPݭ  Pխ P ЭQPPЭQPP P ^ PPP޼P`޼RݬvPb޼RbЭP޼Rbս%ЭRѢPнսЭRѢЭRѢݬ PսЭPнЭPìRRЭRТЭPRR P  ^լ7޼P`խнݭ
  Эխ޼P `ЬP P ^ЏЬQЬPѡЬPРPPPЬPРPPЭ޼P`޼P`ЭQPPQCPЭQPPaRЭQPPaPPRRխPЭPRRPխЏ   PխЬPЬRѠЏ   P P ^ЏЬQЬPѡЬPРPPPЬPРPPЭ޼P`޼P`ЭQPPQCPЭQPPaRЭQPPaPPRRխPЭPRRPխ"ЬPЬRѠЏ   P PPխ PЏ   PP  ^ЬQЬPѡ PЬPݠ޼P`޼P`  Pխ PЏ   P ^ЬQЬPРЬQPPЬPݠ޼P`ЬPݠ  ЬQЬPРЬRЬQЬPPPЬRݢ޼RbЬR y   ^uRЬPQЬPQQݭݢHVPЭݬݬݭ8P  ^ЬPQЬPQQ޼Pѭ`ݬݬݬЬPݬݬgPPP ^TݤHPЭP ЬЭRЬЭPՠ	ЭPЭ#ЭSЭRݤ@ݤ<PТPЭRЭP РP ^QTլ'Dݏ     TP8 PPP޼P`1 ЬPРPݤ<ϸPpЬ8ED
ЬPՠP:PЬSЬRݤ@ݤ<ЬPݠϓPТЬPЬPPЬPՠPP*PDݏ     ϙP8 PPP1ЬPРPݤ<WP ޼P`PRЬPՠЬPРPݤ<PЬPݠϣPЬPݠϋPխ1HЬPՠ1   P޼P`PРPФ8PРPϥP	 3PЬPРPРPФ8PРPwPխѭCPЬPРЭRЬPРխЬR޼P`޼PФ8`PЬPФ8OФ8PРPЬPРPРPPЬPРЭPФ8PФ8ЭRЬPРнЭPՠЭPРЭPՠЭQЭPРЭPРЭPՠPЭPРЭPՠЭQЭPР޼P`ЭPՠЭPРЭPՠЬQЭPРЬPРЭPՠPЭPРЭPՠЬQЭPРЬP Э8 P1Vխ1 ЬRЬPРФ8PРP޼P`PРPϻPЬPФ8ЬR޼P`޼PФ8`޼P`ЭPՠPЭPРЭPՠЬQЭPРЬPРЭPՠPЭPРЭPՠЬQЭPР1 Pѭ~Ф8PРPЬPРPРPP
ЬPФ8PЬRЬPРЬPФ8ЬPРЭPՠЭPРЭPՠЬQЭPРPЬPФ8PP  ^լPЬս^ЭPРPݬ7Pн9ЭPՠЭPРPݬPЭPР
ЭPРսЭPРPݬP-ЭPՠЭPРPPPP޼PЭ`PPP1KP  ^լP޼P`gPЬPРPݬϟP޼P`:ЬPՠЬPРPݬrPЬPР
ЬPР޼P`ЬPРPݬP"ЬPՠ	PP޼PЬ`PPPP ^S޼P`޼R cPbD 8E޼P`HЬ<Ь@УHPݠ[Pխ1 УHPՠУHPУ81 PУHPРУ8PРPЭPРPvPУHR ݣ8ݭvPУHR ݭݣ8\PУHPްP`ЭPՠPЭPРЭPՠУHPРQЭPРУHPРPРЭPՠPЭPРЭPՠУHPРQЭPРЏ   PPѭЏ   P P  ^ լЭP߭ݬЬPݠϴPѭЭPРPPPЭP  ^ լЭP޼P `߭ݬЬPݠϝPѭ#ЭPРPPP޼QЭPРPPPaP  ^լ P߭ݬЬPݠ
PѭЭP Џ   P2  P  ^޼P`޼P`[                                                                                                                              @   @     8  D                                     #           H  8  (           P  p                  H   @   p   8   `   @  0  X  P  J f f f 6 K J J           l   <   d   
     d     <                  '  &        t	  f        
                 @                                                                       
RPC$LIBNCK                                                     VAXCRTL                                                        LIBRTL                                                         MTHRTL                                       4        0                                                                                                                                                                                                                                                                                                                                                                                    ' * [UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1 +  , $	   .     /    4                           - !   0   1    2   3      K  P   W   O     5 	  6 Γ  7   ϓ  8          9          G #  H  J                           0 D X     0205      (          j                             
         RPC$LIBNCK.EXE                         RPC V1.0A-00   wΓ 05-05                
                 (    
          
           !        VAXCRTL_001      !        
LIBRTL_001      !       
MTHRTL_001    4    Z3    3    2    3  < ^1    62    U    U    U    U   U    T    fU    2U  | U  < V    b        fe    *e    d    f    &f   c  <    ﺝ    {  |   | ﾧ  |    b    R    Ze        z{       ﮓ    Ɠ  |     j            n   N            j           <                             v   F          B   Z2    22  | f    +  < N    +  < M   B*   )        
    z  < :  <   <   < J    
      v   h   Ҍ  |   <   < R       c                                                                                                                                                                                                                                                                                           ^ ޼P`KPPѭ;PЬRPPЬQPPab޼RbRRѭ޼R b <^ˏ   PP޼P `޼P `޼P `ޭR e f PbխޭP`f P1ޭP`WޭQޭPaޭPWޭPWޭQޭPޭPWP`VQPaPVPVQPPVѭ1PЏ xPʏ  PPPP 찏 2PP1խ1 ,ݏ   ޭP`e P   1P 2PP@P`U2PP@Q2PP@Pa2PP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                                 @PU2PP@P`T2PP@Q2PP@Pa2PP@PT2PP@PT2PP@Q2PP@P2PP@PT2PP@P`2PP@P`2Qʏ Q2PP@P2`Pʏ PQP2PP@P`PP졭PP2PP	խ1}ѭ1P ݭޭP`3d ݏ   XޭP`d >XP`S>XQ>XPa>XPSZP`RZQZPaZPRݬ\ݬQխ1ݬ͜ݬ6ˏ  PPPPX
Z1 Xݏ   XޭP`Vc  #P2P@X	PP=  谭걭 \PPP2PP	޼P ``ЬQPP2P@Xa2P@X
޼P `5PP걭 ݏ   XޭP`b  1vPޭPݠ b | ^ Vݏd   ݏd   4ݏd   ߭^(n@ޭRbݬߦݬ9b lP4Rb߭ݬߦ!ݬb GPRb4߭ݬߦ1ݬa 4߭ߦDݬa  P| ^+ Vݏd    ݏd   Ɛ ݏd   ߦ,޼R^(bno޼Sަ,RRc޼SƐ RRc޼S RRc޼Sߦ,Ma PRRc޼SƐ 7a PRRc޼S !a PRRc  | d^+ VmSmR` PDmmRݢDdJ  dii !hݭe}  ^(inK  ޼Rb 䏔   RR<RRSR   SShhRRݭ|  P	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭԄ  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭH  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ＃  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭh  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ  RRíܭRR͵RR߭߭ݏ   ݭݭݭ 0 ݬ
\  <RRRRRЭܭSSS< RRRSR1S< RSRSx< RSR
޼RнbcPSSSS< RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭy  hݭsy  imF  | d^[' VmSmRy\ PDmmRݢDdTF  dii !hݭx  ^(in)G  ޼Rb 䏔   RR<RRSR   SShhRRݭx  P	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭl  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭT  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ   @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ~  RRíܭRR͵RR߭߭ݏ   ݭݭݭ0 ݬ
X  <RRRRRЭܭSSS68 RRRSR1S8 RSRS8 RSR
޼RнbcPSSS7 RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭu  hݭu  im~B  | θ^" VSRX PDRݢD͸A  ͸ !ݭt  ^(nB  ޼Rb A   RR<RRSR   SSRRݭt  PPRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ{  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭw{  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭz  RRíܭRRRRR޼RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭ0ݬ
T  <RRRRRЭܭSSSV4 RRRSR1RS;4 RSR1:S(4 RSR1&޼RbRнbRR޼RbRнbRRబRR>RbRRЏ  ^(n?  ޼ RbRR<RRխ1~PíܭRRRRR޽RнbRRЭRRbRRЭRRbRRЭRRRЭR	RRݭݭx  RRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭmx  RRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RRݭݭw  RRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭw  @   RRíܭRRRRRЭRtRнbRRЭRxRbRRЭRzRRݭݭ$w  RR   RRRRխ1íܭRRRRR޼$Rнb1 	PSSS0 RRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSSy0 RRRSR޼RbRнb?P޼RbRRЭ୐ЭRЭSЭRЭSЭRЭRRRRRSSS 0 RRRSR>Rb >RRЭୈЭRЭRRRЏ  ͼ^(ͼnm;  ޼ RbRR<RRխ1íܭRRRRRSSS^/ RRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS. RRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSS. RRRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRRRRRխíܭRRRRRSSS- RRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSS^- RRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS - RRRSRЭRRb*ЭRRR\ЭXXR\\RXRRЭRRRЭRRRխ(PRRRRRRխíܭRRRRRSSSA, RRRSRЭR RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSS+ RRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSSh+ RRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@RRЭR(RRЭR)RRխ(PRRRRRRխíܭRRRRRSSS* RRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S8R<R8RRЭR4RRЏ@   խhPS* RSR) * RRRBt* 
RB) RRRRRRխíܭRRRRRSSS) RRRSRЭRtRнbIPЭRtRR4Э00R44S0R4S0R4R0RRSSS) RRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ&RRRRRRխ   RRRRխ1íܭRRRRRSSSS( RRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭye  ݭhe  2   ^O RPP PP߭߭ݏ   ݭݭݭ0ݬ
G     | 4^ VЏ    H Pѭ*%߭ݭG P%ݬ߭  խ
޼R(Ɛb ^  R ߢG P	P \\P ^e  S R޼P `´                                                                                                                                                                                                                                                                           {9@        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                    U4             ´[G Џ´ ¸ ߣ'7G P´´)E( DG ߣUߣ:G ޼PЏ `  ^Q \̴̴F Џ  < h^  UF S T 쐏 ĸ  F ݏd   ĴxF Pѭ
cPѭ'p' cř ߥh/F ޼RЏ bխB1?'  Ŭ  F P"'  E ޼RЏ b PPͯPPЭRPPRM
GPЭRPPЭQPPܐabĸPPĸЭQPPQ
P ѭĸPPĸͯPP#ͯPPͯPP 1R& ͯ"E ݬ߭ ͯE PRRͯ   ޼Rb& ޼RbGD 1"<RR*% ݬ<RRͯŀD 1P# Ĉ )  P
Ĉ ? ݬ߭ ߭ݭq`# Ĉ 
  ޼Rb$N% ޼RbͯŵD 1jխ#%% ޼RbͯC 1APPѭcݬЭP>xP<`PP  PD$ ЭP>xP<`PPݭ,C PP䏈   PPѭѭ$ jJC 1PЏd    ݬ߭ ļЭRݢtЭRxv  ޼RbŰļB  $ ݭļB ݬЭRݢtЭRxݬ);  ޼Rb!# ޼RbB 1PRPB PDPݠDͫZ,  ͫww r# w-3B 1Ĭ {Ĭ ݬ!=   {߭߭! ! Ĉ ݬ=
 R	b{,  ޼R   | ^
 V ƨ 
Ƅ PƄ !  ƈ 6  P
ƈ L ƨ  ϲP)ưݬ޼Rb޼R^(bnA,   Ƅ Ƅ <  ЭRB$  P1PЭRB$ƈ 8  PƄ RR
Rb1]PƬ Ƭ Ƅ ;  SR@ PDRݢD*  ЭRb ) ƨ Rˏ  bRR  ^(nQ+  Rb ?խЭRѭB$޼SRbcƄ ;   Ƅ ư 
Rb IưƄ E Rb-ЭRB$Ƅ  խ^(n*  ƨ Rb 
 K*  )  ƨ =ư v   P  ^
 P   P| ^
 VQ ƈ   P
ƈ լ
޼R(ƈ bP ^]
 R޼P `ݬ$Pݬݬݬ 7  P ^!
 R n ݬݬݬ  7  Pݬݬݬ 9  P ޼P`¨ | ^	 V ޼RЏ bݬ{P1 խ1 SR> PDRݢD'  ЭRb ) ƨ Rˏ  bRR  ^(n(  Rb  Rb ݬݬƄ ޼RbRb 	 2(  '  ݬϤPխ1,P  ^ݬݬ P  ^ݬݬ~ ϿP| ^x V   ޼ RЏ b޼R b޼Rbƨ  ݬ P1kխ1cPSR< PDRݢD&  ЭRb ) ƨ Rˏ  bRR  ^(n`'  Rb  Rb 1  ЬЬѭ䏐  
ЭRRЏ  ЭRRݬ ݭ߭ݭ߭ݬݬݬƄ ; R	bŭ   RRRRRíRRխխ1{P𞭐Rb  @&  P%  ݬ ϰPխ1խ!޼RЭb޼RЭbխݬݭ޼ Rb ޼Rb޼ R b `^  Wt V  Ьѭ1 ЭR>xR<bRRݭ  P1 PRB ARBư RBƴ   jݭĽ  խRB RB ЭRݢtЭRxRBư RbRBƴ   PDѭ4ŏ   R޼S( Bc`ŏ   R޼S( Bc( `RRRR   RRѭ1   < l^լ$RR$լ 	pRR ޼ S޼R(bcЬ S޼R(bЬ S޼R(b Ь R0RЬbݏ@   ݬЬ R4V9 Ь RtRЬbݬݬЬ Rx39 ޼$R bݬ$ݬ     լ$
޼$Rb!Ь Rˏ0RRݬ$ݬ P  ^լPP޼P `ЬPˏ0PPݬݬ~լ
޼P`Pݬݬ    P  ^լ(PP(լ ޭPP լޭPP޼P `޼(P `լ1ݬ(ݬ$ݬ ݬݬݬݬݬݬݬ
v  'ݬ(ݬ$ݬ ݬݬݬݬݬ  ^ݬݬݬݬݬ       
-  ^ݬ ݬݬݬݬݬݬ   
  ^ݬݬݬݬݬ  z    l 
  ^ݬݬݬݬݬ     7 0 
y  ^ݬL  ݬPP  ^9  RլPPլPPݬsݬb  PPPPլ1yP޼Pް P`-1L޼P`P`QQ119QPP1z   2222222222222222 Z?PPd   1 Pd                     | ?P1 ݬߢ%  1 PݬߢJ  1 Pݬߢo  sPݬ 5  n5 ޼P`P`PP >P 5PL   0PL   Pl   Pl   Pd 
PPPPPPPPլ1 ^a  R ݬݬݬݬ    | d^ VmSmR4 PDmmRݢDd  dii !hݭEQ  ^(inq  ޼Rb 䏔   RR<RRSR   SShhRRݭP  P	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭX  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ(X  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭW  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭHW  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭV  RRíܭRR͵RR߭߭ݏ   ݭݭݭ Ɔ  ݬ
0  <RRRRRЭܭSSS} RRRSR0Sf RSRSW RSR޼RнbbPSSS3 RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭdM  hݭSM  im  | d^  VmSmRY0 PDmmRݢDd4  dii !hݭL  ^(in	  ޼Rb 䏔   RR<RRSR   SShhRRݭfL  P	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭLT  RRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭS  RRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ4S  RRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭR  @   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭwR  RRíܭRR͵RR߭߭ݏ   ݭݭݭƆ  ݬ
v,  <RRRRRЭܭSSS RRRSR0S RSRS RSR޼RнbbPSSS RRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭH  hݭH  im^  | θ^;  VSR+ PDRݢDͺ  ͺ !ݭuH  ^(n  ޼Rb A   RR<RRSR   SSRRݭG  PPRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭO  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭWO  RRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭN  RRíܭRRRRR޼RbRRЬRRíܭRRRR                                                                                                                                                                                                                                                                                   RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                    ȭ      #       ߭߭ݏ   ݭݭݭƆ ݬ
(  <RRRRRЭܭSSS5 RRRSR1AS RSR1)S RSR1޼RbRнbRR޼RbRнbRR>RbRR<RRЏ  ^(nl  ޼ RbRR<RRխ1{íܭRRRRR޽RнbRRЭRRbRRЭRRbRRЭRRRЭR	RRݭݭL  RRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭ]L  RRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RRݭݭK  RRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭ}K  @   RRíܭRRRRRЭRtRнbRRЭRxRbRRЭRzRRݭݭK  RR   RRRRխ1íܭRRRRR޼$Rнb1PSSS RRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSSi RRRSR޼RbRнb?P޼RbRRЭ୐ЭRЭSЭRЭSЭRЭRRRSSS RRRSR>Rb!>RRЭୈЭRЭRRR<RRЏ  ;^(;nd  ޼ RbRR<RRխ1íܭRRRRRSSSV RRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS RRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSS RRRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRRRRRխíܭRRRRRSSS RRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSSV RRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS  RRRSRЭRRb*ЭRRR\ЭXXR\\RXRRЭRRRЭRRRխ(PRRRRRRխíܭRRRRRSSS9  RRRSRЭR RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSS  RRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSS`  RRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@RRЭR(RRЭR)RRխ(PRRRRRRխíܭRRRRRSSS  RRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S8R<R8RRЭR4RRЏ@   խhPS
  RSR)  RRRBl  
RB  RRRRRRխíܭRRRRRSSS  RRRSRЭRtRнbIPЭRtRR4Э00R44S0R4S0R4R0RRSSS  RRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ&RRRRRRխ   RRRRխ1íܭRRRRRSSSK  RRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭq9  ݭ`9      | ^  Vլ޼R(bЬ^P ݬ߭߭  >Rbݬ߭<RRﻤ  ݬݭ߭|  ݬ ߭z  ݬݭ  |  P޼Rb  ݭ  ЭP  ^  P   P< ^ݬݬݬPլ	޼Rb޼RЏ bSRE PDRݢD#  ЭRb ;Rˏ  bRR  ^(n  P޼SRbc   Rb ݬݬݭ  Rb  ݭ!  < ^ݬݬݬPլ	޼Rb޼RЏ bSRU PDRݢD3  ЭRb ;Rˏ  bRR  ^(n  P޼SRbc   Rb ݬݬݭ  Rb  ݭ1  < ^ ޼(RЏ b޼ R bݬݬPRR	RbSRW PDRݢD5  ЭRb 9Rˏ  bRR  ^(n  ޼(SRbc   Rb }Ѭ
ЬRRЭݬ(ݬ$߭ݭݬݬݬݬݭ  R	b$0  RR$Ь ScRRcíRR޼Rb
լP  ݭ  ޼(Rb ޼ Rb޼(R b < ^ЬPPS / _ ; k   G  w w    / P?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  P^(n    ,^m  \լ( A  4  '    
       
     P ,^  RϬ\\ Ϛ\\ ψ\\ v\\t d\\b R\\P @\\> .\\
, \\ 
\\ (     ^ˏPP !  ^  QЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^  QѬ ޼PЏ `б  ޼P `  ^y  Q޼PС `Ь ޼P     ^P  ^    P  ^ (   P ^-  RТP\\P   ^	  P\\ՠ| ΀^  VЦ խ^լ  MP Oݏd   ߭^(n9Pݭ    ݏ@ж  զ ЭRRRլ
ЏPЬRRݭЭR% < ^ ^(n(    4^U  S6  R޼P ` >P<P	P@ PPЭPѠ
ЭPPP<PP@   ݏ4  ߣc&   ݬＹ  Pխ,   ߣH&  ޼PЏ ` P " ݭo  P7M  I ߣv.&  ݭ+  ޼PЏ ` Pݭ  QPP<QP	P@ PPЭPЭЭP<QPQ P  ^޼P   | ^  V <RR 1 P,  <R.RB  P
<RRRRPЬR(<R.RBС  P0ЬS<R.RB+Rѣ@b<T.TЬRޢ@SD+RcbRR<RR 1g1 2S.SЬR((C2T.TЬRޢ@SD+Rcb2T.TЬR>HSD/Rcb2T.TЬRޢ8SD1RcbЬRRR2R.RBRRR2R.RBRbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RR @^'  S xt $  %ݬݬݬЬRݢ+  Pc1P_x|c_޼RbЬR]  PЬR>R<bRR!  _6  _â c#  ݏ    $   P R t ݏ  ЬRݢ  Ppp7   	"  ݏ  7 #   P c f<fRRx1 P<fRRBcPPlOPPhKQ<fRB|P`a<fP@|R>bP`d<dPP7hRhPPhlQlPPlabdPPd<dPPݬKݬЬRݢ)  cPPcfPPf<fPPx1=ݏ  l "  cRRP <^  W  Vݬ ݬݬЬRݢV'  Pխ P޼RbЬR(  PЬRRRRRЬRRRRR1 ^ЬRܝ  P1  "  ЬRѢ@ЬR@RR"  &PЬRRRRR!  Pǡ   ݭ޼ RbݬЬRݢq  ݏN   l!   P  
    PЬRѢ@MЬRѢ@<z  2PЬRRRRR   PЬRݢ@ݬ+<    PЬRբ>&ЬSЬRѣ>8Џ ^(nRRRЬRRR޼RbSRbcRb<RR1PЭTRRЭSRRcdRR<RRЏ   P ^奔  W  V <RR s<RRBS<RRB<SS޼R(bC<RRBRЬb<RRBRЬb<RRBRRPRR<RR ݏ  ǈt   ^  R <PP SP<PP@0޼P`<PP@7  P<PP@PPPPP<PP                                                                                                                                                                                                                                                                             +        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                          2       2  P  ^޼P `ݬwPխ޼PЏ `ЭPРPՠ>ЭPРP>PЬ`PЭPРPѠ>޼PЏ	 `޼QЭPޠP`   ^ݬPխ޼PЏ ` ޼P `ЭPРP< ^ݏP    ݬb
 ЬR  ЬR  ЬR  ЬR  ޼RbЬRFRbЬRHRbլ
ЬS޼R(bP l^O  V<
 W)  \ݏ#  ƽ    <RR 1,P<R.RBRR  i  P1 Pu    PЭRݢ$u  ЭR>R<bRR@Pխ1  ϬRЭRޢ*SRcb(ЭR>(SRcbЭRޢ$SRcb  ЭRݭP  g  ݭ,(  RR<RR 1   P ^ջ  S  R   D  #  :2PP*  P  ^޼P `ݏ   $  PP ЭPPЏ`ЭPlP`ЭPZP`ЭPVP`ЭPjP `ЭP  ЭP  լЭPjQjPQ`ݬЭPݬݭ
  P ^Ьݬݬ  ЬЭPZPPЭPVPЬ`<PP/ЭRPPЭQPPabRR<RRЭRjPjRPbݬЭRݢVЭRZׇ  PЭRjPjRPb޼R    ^ЬЭPѠ1 ЭP>jP<`PʏPP޼PЏ `ЭPZPPЬ޼QЭPޠVP`aЭP>VP`<PP1PЭRPPЭQPPabRR<RRݬݬݬR  ޼R  < ^Ь޼SЭR(c޼R    ^Ьݬ ЭPVЭPZ   ЭPjQjPQ`ЭP>P `ЭPLP`ЭPNP`޼P     ^ЬݬݬЭPjQjPQ`޼P     ^ݬ޼P<`PPݬP޼P`ݬݬݬݭ޼P`ݭ    P  ^ЬЭP>jP<`PʏPQPQQլЭPjQjPQ`ЭPjQjPQ`޼P `PPP  ^  QPլPP   ^Ь޼P `ЭQlPPl>lP<`PPxЭPPЏ`ЭP ЭP ЭPЄ P`PްP`ЭP  ЭP ЭP ЭPЀ P`PްP`ЭP  ݭk   P  ^Ь޼P `ЭQlPPlЬP< 8^  U r PRRR q  Ь  K ЬR STЬRz  P{ PQPPRxRRCdRRCd  ЬRRRc  PI ݏ  Q   ЭPP5   	?P1  P  Pņ  Pѭ  ݭŝ   j PRRѭ   P  PPíRR1Pg  2 P< ^ SR" PDRݢDѭ 1\ ޼R(P bRRRR b   ЬR STЬRz  P{ PQPPRxRRCdRRCd <RR1 ЬR  ݬRݬb  ЬRRRw  Pj߭ݬzݭݏT   ݬݬHP<RRRRR
'RRRRRRRRRRPPRR<RR1; =
P 1 <^￳  V  W ЬЬ ͻ ͺ  ؐ    ͨSR4  PDRݢDpp 1 ݭݭݭݭϢխ6ЭRTR  SBc"ݭЭRTR  SBcR޲Rb խ խ	ݭͻݬ4ݭͺ
 S  ^(n[ЬRޢRbѭ̏)Ь:  SRRS`Pѭ̏
 >ݬ4߭ݬ:  P޼4Rb޼4R^(bnͻͣ^(ͣnЭЭR>jR<bRʏRRЏ ͟^(͟nѬЏ ͛^(͛nh޼$RЭb޼0R b޼(R b޼4R b ͸ݬ4ЭR>ZR<bRR  P   PPܐ   ЭR>jR<bRʏRSRSSˏRRݬ4ݬKݬ4ЭRݢVЭRZ~  PЭRVRR1 ЭRVRRRRRRRbSЭRVRbcЭRVRb<RR.ЭTRRЭSRRcdRR<RR>R<bSЬR<CRRݬ4 ~  ,Pݬ4>R<bSЬR<CRR~  RRݏ$     ͺЭR.W  PЭR(.ЭRNRbЬRFЭR%  PЭS޼RѣBb+ЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЭSRRRRRRѬRR
ЭR>jR<bRʏRRЭS`RRRRRRˏRRЭS0RRRRRRˏRRЭS RRЭR ytoЭR .ЭSݬ4ݬЭR ЭRҀ R޲ R޲ RbPÄ ޼4Rb/$  ޼4RbF  ޼4R^(bnЭR ЭR҄ RbRâRRܕ
Џ ͗^(͗nRRRRRݬ4ЭR>R<bRR@P޼4Rb޼4R^(bnFЭRݢ@ݭϹPؕ
  RR    SRR<SRRЏ ͓^(͓n
2ЭR RRݭݭݭϹ蕭15
 ͹1  <SЭR>LR<bRRS  S  RSbЭR>LRbͦ͑ݭ<RRݬݭ  P͑͐<S<RRSR͑ ͐͐RR͒͒͓RR͓ЭR RRݭ͑ݭ硭RRRR͒1dR͑RR͹P   PRRԕ͹	͸	VP	͐P͐͐RR0<RR
RR
<RRRxRRR䡭RRխݭݭsPЭPP  7	?P1խ6ЭRTR
  SBc"ݭЭRTR  SBcR޲Rb ߭#ЭRݢ@ݬ ݭݭݭP e  PR­RRRR1>P ЭRRRRRPP! - ) M - M M % P&?P.P11A1ͼݭH  ^(ͼn:  &PЭRRRRR
  Po
  13RRѧ  Џ ͌^(͌n1͹1!  PƤ	   Pݏ  	  RR<RR<RR3Pb  PH	  Џ ͈^(͈n(P 77RR bЭR  ݭ7ݭP  1_Pݭ PRRPP  v?P1խ6ЭRTR  SBc"ݭЭRTR  SBcR޲Rb ߭#ЭRݢ@ݬ ݭݭݭoP1 ЭRRRRRPP %  ! % 	?P.P1uvP1ͼݭ  ^(ͼn  &PЭRRRRRK  P+  111-ݏK  k]  ͹/  Ơ  Џ ̈́^(̈́nGi  ЭRݢ@H  ЭTЭR>HSHRcbЭTЭR>FSFRcb1CP
/     Џ ̀^(̀nЭR>LR<bSSЭR>LR<bRSR1PЭTЭR>LR<bRRRRSLRSb 1pЭR 1;131+ЭRNSЭR҄ R޲ RSbЏ |^(|n0޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bݬ4ЭR@ݭЭR>JR<bSЭRCP޼,R^(bnЭR ЭR҄ RbR޲Rb޼4Rb޼4Rbx^(xnsխ6ЭRTR|  SBc"ݭЭRTRd  SBcR޲Rb ЭRRʏRROP͸/<  #$  Џ t^(tn޼(SЭR>JR<bRRc1 P͸ЭR>JR<bRRݭ  Pͧݭͨp  ݭ  ͧkЭRRʏRRS(P 77R	R bЭR>HSRcb>ʹSRcbЭR  ݭ7ݭ-1fP޼(SͰRbc޼$Rͨ\  Pb޼0RbP-#ݭMޕ  ϶ϲRR    ЬRFЭR[  P!ЭS޼RѣBbЭTЭR>FSLRcbЭR.#  PЭTЭR>HSNRcbЭTЭRޢ8S>RcbЭRjSjRSb#RRRЭRVRRRЭRVRbS#Rbc#Rb<RR.ЭTRRЭSRRcdRR<RR޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bPխ6ЭRTR}  SBc"ݭЭRTRe  SBcR޲Rb ĕͻ ͻݬ4ݭݭrܐ 4 G     ^ݬݬݬݬݬݬ   q    ^ݬݬݬݬݬ   u  < ^ЬRТѭЬѭ
 ^(nc޼R bЭR ЭR ЭRҀ RbR޲RbЭR    < ^ЬRТѭЬѭ
 ^(n޼R bR P< ^ЬRТѭ@޼R bЬЭR ЭR ЭR҄ RbR޲RbЭRЬ 9Pѭ
 ݬݬݬ/S                                                                                                                                                                                                                                                     !                                                                                                   	~p#8u\
~
1                                                                                      }   >                         r        :       mlXH^iBBRA1	^Gs:>WoP&NRnRu&-97
i&U~;c0"x,Qd*@sw1ⓆgcO*ai&CI-cG%Uvt] ]ODkkZi
X
::P*W`cɓ`R`U8~4OڅJ{՘QoAhg~6"Ag/^S$ʑ'7jƔnư2YWCV%SgŵAk/xd?W|9kQA׼Uv2}}E6|Ҭ_G=P(WA3a3+鐖tuV/1˷fė)ޫw*'kĄ y;&V
-6sֶLRn\:g"'`!4u'kCj7൶ySY"uLҏ4qzoW_1=wA.|}(1*0LZVXiS#ʫq⏂wj;W+Oa5Go{NӰa(ehKVG2@#ְmL_#.T_ [pkqfG0UW(lpZM~PNCLOfTW6Y!2غenyN	;Pdc=Bfj*H| ?6}OibZDr56xVݹ I_=Y@)q%d^,10<֠GڛOsך] !*YsOǄIUtAMzifUs?ﺳTH,TDغ.9TS&R=}GSgoQLlH@8{Q׶oN΄a}xL]I<%?/69<ͩ_V]\|*hz	Jjzm(`g0f*d`2r@	q*mqe 2XR-_ vNb
+&U:D&`?ɷ1,ù=LBE([6':% zϙء^B2*&ˀQ,I6>>KPc	[&4yqqd^V(
E{p?野Y]UgIip"U|dh= i1C+V:F?HfeJ
EuR{fiev3+Kjq$t<Ӧi0alsd'53'ZJh ʻzqh"8B&	`&5AhUe1%Py>7Xzb?X$kcVtdD0n>pZ(5,& 'RtL(Ay+{zHw%5ݫx0QRe!nP3WrP궓ǯk vP\!FO27eO%+	$qmb5_=`Px-LXXpaF	#ۙ-^D~m<_]/)s<,_|
4HC
ry)!áWʺR T9	ıŢťgEIO9
y_WG$?saDm=mr
rwOmʶ׺,bsd$/>0pI	*0(Yğcǀ-E֠v۵U`BԻe'uVWK;
 Vm^Ne=ܝ#zR\m *b+BXZ*V
Pv^HS$y`C
0_>8
@w"T*@Qβu)e?n{' [ӷk?BK!KG|FWō(
+Ĳ-Uhk'\ɒE$9pC+icVer%Uh+uB0*+ujW(g;ۙQz'EDmu%bvl&rz$nrj&Đ2[;-qGxֱGw2wF Oɩ	UlyGZUօ|֏5!Ϲn"Ojʁ4 Sg*jtU|kZJFR2PokL t1GAYwO/W_;JCV:f3uC%;2]ke[:?ٱ{*HIuaLﱕ GOI4MJ|b5 s9eZvy/R zA31R
"bιWt1SX\LaBAuVw@3P 5E>ױv!دh_~?RXp\: S&I)TሾwiRK97.XFR})S*lnǛ^wdrn~ZBEr#>U"{IEq.45T3G=	xSΐ}y"Y=ߛ%P W7cRL,L#"Srli25*]JWR uNa감t
j`Q	GM;x_=yPj^ЊiA8c^ˬ,{#tlޜqS#4FߛvȫPzn
PҲg6O{f`Y{0)jAhy0;Ehq
ɬ*Fxb%S_D%IȰ;^t#Pqk.&jj	rxiLT$Q*;UwEqn1IO>"Ɇ%o'm}\S qX(;v[CSz
k \o|TKύ(N\82hD%mB8gdOf}_.-[ee=
PΟ)/ؑeHZ xA^XmU0#Й|dE7^H4Ҕy`sc
rKh$p;"Dd6?c*[DS%|kuHdccd7='|+½ɑo@|	{و @r|6wt#Diʠ憉zMKҊ0Ϳ4c$5ne#pvnrG|y&!WEHi^ڠ*U^@Hmc<`Ӿݾw!},?5VaS"_e19z>k0:F{\ڞR~zv6aBV\S}듊og?݆1iگUj-iyLb3xqnJ|v~8y=m+:ו~DTmȱ..{#>sK_?7޹'2mfV
5}~JIKچT
$7vJ0%;
)b8.SF5,6:Nj/. e O"]tZ8B5)zq_?`D]bގ˻\| 0Sw~Aa~mH3IXmNbWu<4SY=TF:Z.xTh넹}7ʍ[Uj!eӐ$.OHGˇ=0K:m}<ʞש@I|S?y	C=R@ L !/*$(ƪӐDAa;ȝA5=<{zo"hKu'J;ݿqufbst|23a_F4@sXJ@Mw<ychZ:ҵ<F
nwy$/Uc\F
^yՁJ<iRzCK%=a/{ZTO'uXK;02-R|˘+78Y^ sc7]8 fΙGf9[v(эż;u6Yx֥>N\x;avl=4@U zɰ	@v'WU6L#of
 ӓGk>͜]z[xX[2ѧU%:\CaK.P^AyzU/hd}s|-ehs6Ef rt'mp݌RI-V.FX(kYp'%tA}3~nGYyQf'kB2LJiE
ׂ>.^;]y.w tdY%FԣӰ ׼iT
51ȍ{jV}9J29hj_->$BH')?_P&Xw.[w@,xU7v3\q7Ty U_Upawٺԯ?oa.ã+T,UHtaE
Gew52#@ƑxsQV
v{JPgS\9Aa
wP*iz[?Q*K!m͡`Y#FpCRd<'>q: c레C~"c!Ｘ@sLxͽQh=|b6B
	|^tu{ۀI`j\xlJ-tw/wҗ7 O??<3/I>DB vn_xwC|o9h¾=([%
X#*^FL= ,1k♧Aإ
[uFtHl`hb+H:Ƈհ?lP#R^_x&wGo` u!T~Cuog0Qتǜޥ)*1*s=/.Er,@bqߍ4mwXZrFPP 3ǻ	Pjhܦ%UZƵ,l#D`3l;sӥxr12<ɲz(uk"L	df$ޘpaTjdX.\}\?+Lslx#{HN=$r70րߜ!H8ȝܰy~3[.N+Izڸ6$FMdUm٠'ZW!{߃0xIyχt

jEV]uS< <'
-ez~JJ>t^53Zy+ZEpZ&#0Y
C,
I
usHsNH$eC	kbccWUv@!B{(vg}@OƑ/f6_m%0hR~]໺G$yB]S
Z^7{ʧ
e}oDܻ##PH6Fԁ:TJFnV\F2[#}(ڕä<AB~.jFBW/rlScb%ˆWekɄPxG񾦋%nۂ\H$eT	BFaR@*HđbWJAj񑨱it૥W8H:%VzVBc^%N>W7-62:(xɠ%⪉1[p.'٥<j]>4r2V[pUKMDw#\<s|
Z)ˀA%&'`s؈6 ϑ]9>t Ҳ9]	!4BAq`ZAS9zSc4/DQs,uEw|vzUlQc:C#_gs@hr	,3t=VS}(W6"`(0U@g82+Xl5{WryC5MwGcx[ X-4ETR5>=*<2 TNﶦۡgTLos7ɣɘQHn5vF36C8ymLf<Xbe0FfNQ$<T-w_JaOB4[?FFj\z:̱8KBhf\1q^x_M$=A'rxe)_%nG!VwQuR03 e|1A|wQa_p0xlOAnDjP-URQ,p`Ϲ#Ɗjq#N׮ne6Xuj'**:qIOdDAi*+Hd'ɬ|hiQmг`F*FZXYG뱌"\S%NkBqxA.UO	~9N.AJĉސ/ ezjw
0#Xod,'ӥ2RK8w$7S5hʵ;9y'j{+}d8f7HOehJLCm_u} ½{6界ד)@s-	pzG/:?'r+kkgv{E,P}$yky	nP.zu6\oyqhɎ-MƔ3RU_YkObWKk)t_@H7
"p T$nBsl7č$k)ݥA/	&Pؖ/#m%T7)
TDD>cL1DUt
TPt/h߂_lAb-7_qwv`)Ya,A2dR jP-e{I<_^\
V1:Е}o_hp9lOm SZD0lum\Ud=z\HiooYbE~K ',9|L]aI6nHCj
ĥ$Z]ǆɞ>#q<:{	GIl/ق!UsNILxE<5rLLŵm (qy&wN|h	Śoӿ_ςVI;_a_*7VDi9Q̙_\,=
xqkכ0CP~4L	nyAFu\
˕,|]>nٌvN}UQ+~HPƻԞٯW/fzX/i

r7)QcQ=nW
ڔ_S9-~k3.hcGda[X3ղsZ#-@M&(5oemt Q"6Z !K:!'NÛΐu[`!< j/q8)Px
ZXQxWiLQC5"vMR1!Z^
]hHB}Z
<.E(m|Lz H  J                                                                                                                                                                                                                                         "                                RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                          A       Џ ^(nI< ^ЬRТѭ޼R bЬЭR P7ѭ
 ݬݬ#S  PPЏ ^(n  ^        u    ^ݏ]   ݬY  PݬխЬ
PPݭ       ^  Qb  RѬ
ޡoPPЬP@ P  ^ P  ^ P  ^ЬPPPP߬ PP   ^  RЬPPPP PP߭  ЬPPPPxPPPQ PPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬPJQЬPJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@PЬPLP`ЬPLQЬPLPaЬPLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP`ЬPDQЬPDPaЬPDPЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHPaЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8QЬP8PaЬP8PЬP8PЬP8QЬP8PЬP8P <  ^Š  TV  U3  R޼P `߭ЬP  PP PPݬQ  Pխe#ā   ЭP޼PЭ`խЭPhլcЬPNPPխRЭP@G޼SЭP@PàPP PPЭP@PްP`PcխeЏP޼P`PP)޼P`PPġ :eЏPЬPPPPPP<PPP
.ЬPPPPP eЏPЬPPPPxPPPQ PPPQPݬVЬP>JP<`PP   PѭP3 PЬP>JP<`PPݭ ~eЏP°PP°ЬPPPPPP<PPP@¸QaPPaP ^ﭞ  W"  VЬRRʏRR 똭SP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n?޼RbRRRЬR ݭ RRݬ  Pխ)  խ,ƬRRƬЬRRRRRR<RRRBƴScRRcRխRRRRRRP< ^ݬh  PխЏ ^(nxP  ^   
    ^P      PPPP  ^     ^X   PPhPլP   PPݬЭP  ЭPP` P ^]  RЬP>P<`PP"Pݏ  UEd   E  ЬQPPЬP>P<`PPݬ  ^޼P`-P޼Pް P`޼P`n޼PЭ`޼P` ^5  SЬPPPЭPPPP޼R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`ЬQPPЬ޼PЭ`ЬQPP*ЭQЭPTLPPЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPQЬPQPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ8P޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRRR޼RbRXݭ  ޼R޲ Rb޼Rb*޼RЭb޼RbЭP ^  R  pP   P\\  QP<\\L¿ \\ս'Э\ѭн\ lЭQЭ\P\Pl\\ v\\,   
  P ^ŗ  T:  R  4P<PP@¿ P`<PPPPPPP ϱ2PP@¿ PPH< PPݏ"  ĜĈl   M  < PP@¿ PP PP  , ψPP>  P  P ЬЭPPЬ`ЭS   PQQPQ` ^%  R   ;<PP@¿ PPѽ PսPP ŕ0   i      H  P< ^<RĬRRRRRѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR>JR<bRRRRíSЬRCPЬRP  RRP ^ٹ  SRPRPݬݬ  1 PPVЬQPPЬRPPbRBäaaPP*ЬRPPЬQPPaP@äbbPPVЬQPPЬRPPbRB$aaPP,PЬRPPЬQPPaP@$bbPP  ^ݬݬ     | ^X  Vݏd   ߭^(n)xP       A    ^Ѭ  Ѭ  Ѭ   PPPPP ^Q  RѬ   ޼PЏ `+ݏ   jP ЭP @   ЬPЬ@޼P    (^m  S  R¤ݬ  ¨ݬ  ¬ݬv   <PP
G<PP@´P`<PPPPP$ݬ4  PP<PP
°.ݬ
   <PP
F<PP@¸P`<PPPPPDݬ  PP<PP
Nݬ  gݬ      ^ﴔ  R  T  S޼P `ݏ   b> =޼PЏ ` ݬh~  Pխ.
G  Pߢ2-޼PЏ `ݭ{   ݬ  ޼P`լݬݬݬݬX  ݬݭ}  P;͸  dߢTd0
޼PЏ `޼PЏ `1 P߭ݬݭe~  P){  Pdߢ~^޼PЏ `1 ޼PЭ`ݬ߭ݬ_  ޼P`+  P­ QPݬݭݬݬE`  2 PP@ÿ PPЭ PP ޼P `{z    ^ݬݬݬ ݬP  ^ݬݬݬЬQЬP<APPݬϖ| ^  Vݬݬݏ   ݬݬPխ PzЬRRʏRRgЬR( e  POЬR @CЬR L7ЬRЬRЬRЬR޼R( b ЬRRʏRR1 ЬЬRRʏRR=ЭR(P ЭR(( ЭRޢ@Rb ЭR>LS Rcb PЬSЭRdЬSЭReЬSЭRfЬSЭRg޼SЭR(Pc ЬR>JRb<RR2<UЬT<SЭRChEPRRRR<RRЏ   PP< (^Ь޼$R bݬݭݬ"P޼$RЏ bRRЬ޼RЭbڭ<RR.ЭTRRЭSRRcdRR<RR޼SЭRRRRRRRc޼SЭR(c޼ SЭR(  < ΰ^Ьݬ޼R<bRR[  P   PP(P RRЭR,ЭR-ЭR.ЭR/ЬRRRЬb<RR.ЭTRRЭSRRcdRR<RRЬ͸RRʹRЬb<RR0PЭTRRЭSRRcdRR<RRЭR>JR<bRRRBЭR>JR<bRRRRЭRP0q   ʹݬIEPRRR b ʹݬ ʹݭݬ| ^/  Vl  S <T2 RRRTR1 P<PP@ÿ R bT޼U<PP@ÿ Rz  bP{ PQPPRxRRRRRDeRR1 ߭<PP@ÿ RbSPnPRRRR^  &PRRRRP gݭ<PP@ÿ RbM5  RR<P2 RRRPR1P  ^M  S< RR    <T2 RRRTRU<\\Lÿ \ lRT<\\Lÿ \z  lP{ PQPP\x\\Bd\\Bd\\<P2 \\\P\R\ Ьb  ݏ@   {t  Pխ< RRP T^'  V4  W]  \zSzR  PDzzRݢDn¹nѭ*ܰ   zVPѭ Jխ'^(nP^(n,                                                                                                                                                                                                                                                   #                        g        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                    
-      P       zխ^(nF    r   <S2 RRRSRd<RRB̿ RbRR	RR SrTz  P{ PQPPRxRRCdRRCdRR<S2 RRRSR RR    rݭr  P RR խ)g  PgݭHm1]P 2 RѭRURB̿ R bSrTRB̿ Rz  bP{ PQPPRxRRRRRCdRRPRR2 RѭR2 RѭR"Pݏ  ƃq   i  RB̿ RRխݏ    fP ߭ЭRݽ5PzPݭݭݭݽ.  ЭR>R<bRR?ݏ  ƵЭR>R<bRRݭ4  1I 1z ^  S  RѬ	ЬPPЭ      4ݬ  i	   e  qPP&  ;޼P     ^  P ޼Q     ^  Q޼P ` Ь  ^a  R  ݬݬ PP޼PЏ `Pݬy  ^޼P     ^Ѭ޼PW  `޼P `ѬЬPG  ޼P`ѬЬP*  ޼P`ѬЬP	  ޼P`ѬЬPX  ޼P`ѬЬPC  ޼P`޼P `   ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPʏPxPPPQQ<PP
޼P `Z<PP   ޼P `CP޼R<PPPxPPPQ<PPxPPPQPPQbPQ`ЬR  PRPbP ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPPPxPPPPPQЬPPPPxPPPPPQQ<PPO޼TЬSЬRЬQP `>P<`PPQPQ`>P<`PPQPQ`>P<`PPQdPQ`1 P<RR   K޼QЬPЬTЬSR b>R<bRRSRSb>R<bRRSRSb>R<bRRSaRSbg޼T<RRRxRRRS<RRxRRRSRRSdRSbЬR  SRSbЬTRRSRSbЬR  SRSb  ^ެPPPQQPP 	?P1ެPPPQQPP   ?P1PPPPyIЬPЬPЬPЬPЬPЬPЬP޼P`#ЬPЬPЬP޼P`ޭPPݬݬ3ݬݬ71 QQQPPPQP%޼Q޼PP`a
P޼Q޼PP`a1 Pk޼QЬPaЬQ޼P`ЬQЬPЬQЬPЬQЬPЬQЬPЬQЬPЬQЬP5P޼QЬPaЬQ޼P`ЬQЬPЬQЬP 
              < ^ ݬݬ^(n^(nP< ^ݏ   ݬݬ^(n^(nϧ   ^y  Rݬ T    PPP ^Q  RЬP>LP<`PPЬPݠ@ЬP(P      PPP  ^  QЬP@(P  ^ЬPݬݬ0ЬPJP` ݬ  | ^逸  VTDQ  T޼R(D < ^ЬRТѽ޼RЏ b P޼SЭR(c޼UЭRТ TЭSgRRg@gRReݬЭRݢ$ЭR(ЭR  R 
PP  ^ݬB ^  R ޼P ` f<Pď`   P@¿ PPЭPW
Э/PЬPFЭPFS  P޼Pѽ`ЭPPխE<PP ޼PЏ ` PQPP<QPď`   P@¿ PPЭP WP| ^  Vݏp  ߦC/ݬݬPխЭRW1ЭRVЭRѢXP޼RЏ
 b0ЭRWЭR V޼R(V bЭRЬXЭR\R bЭS\RR\| ^  Vݏ  ߦxkݬݬ2Pխ[ЭRW1ЭRVЭRѢXP޼RЏ
 b#.ЭRWЭRV޼R(V bЭRЬXЭR \XP޼R(bЭRЬЭSЭRТ\ЭRЭ\  ^]  R X<Pď`   P@¿ PPЭPW)޼P`ЭPF,Q  Pѽ<PPPPPЏ  PP ^Y  Rڣ  S޼P `ݏ  ­ ޼P`ЬPF@P޼PЏ `<Pď`   P@ÿ PPЭPV$ЭQ\PP\>\P<`PPЭP WP  ^լ2P޼P`޼P`'P  P	ЬPРPЬPРլ2  P| ^  V<RR@   ޼RЏ bSRR<SR RBƿRR޼R(bЭS޼R(b޼R b| ^  V޼Rb  O  P޼R(  bЏ   P PP<R RBƿRR޼Rb5O  P޼SЭR(cЏ   PRR޼R(p  b2  P  ^ЬPՠ<ЬPݠ<ЬP <޼P   ^#}  SЬP<PP޼P`
޼P`P!Pݏ      y  ЬP>(P<`PPG  P   PPЬPՠpЬPްpP`PàPPЭPѠbЬP``"Pݏ  eM     нRЭP>QJPa`ЬPݠpЬP$ݽݬЭP>P` ЬPk	P癭PPݭ<PPЭPݠݽ9P<Q<PPQP	 琭PP항PPЬPݠpЬP$ݬLPPPP1j޼P`  ^ЬPf P ^ş  S <RR   jP<P@F޼Rb<P@PL  P&<P@R   PQPQ`<PPPPP<PP   Џ  P ^z  W.  VЬRHЬRHBЬR>HR<bRB0ЬR(ЬR>HR<bRBRK  P<RRPЬR(P챭<RRP <RR   SP<RBDP<RBRb<RBRb<RRRRRR<RR   <RR   JǚЏ  P,2RBRb2RR]2RR!<Rݏt   PЭBЭSЬR((ЭRЏЭR <ЭRЬ8ЭR FЭR fЭTЬRRʏRSRSSkЭR lЭR pЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR1PЭTRRЭSRRcdRR<RRЭR    PSRSb<RRP ^͜  R<P@<P @ ^x  V  W<RBѽ!Pݏv  ƾ   u  <RPЭBЭSЭR(ЭSЭRТЭR O  PSRSbЭRբpЭRݢpЭR޲pRbR޲RbЭR pЭRբlЭRݢlЭR޲lRbR޲RbЭR l $^w  V  W<RBѽ!Pݏ  "	   y  <Rݏt   PЭBݏt    ݭo  ЭSЭR(ЭSЭRТЭRЬ8ЭR lЭR pЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RRЭR   PSRSbݭ[P  ^u  SR  Rݏ  Ws e  P\\ <\\   1[P<\Lխ1-Э\ì\\\\нPP  W  	R?P1 ,4J  PЭ\+PÌ <\\ϼ1 -2  Э\Pô<\\ϰ1 2З  Э\ݬ<Pݭ7F  *PЭ\ݬ<ϧPݽPhݭЭ\ݬ8\\<\\   1 ^t  R<4\\ ^s  R޼QaPP  i     	?P1Mږ  2PݬPЬPPPPP+PQЬPЬPJP ` ݬݬݬ31/r  OPݬPЬP>DP<`PPЬPPPPPP޼P`ϚPxݬݬ1 P  APݬPЬPPPPPWP޼P`<PºЬPЬPJP ` ݬݬݬPMPЬPPPPPP޼P`PYݏL  =&m ^ЬЭPРЭPѠ
 kѽeЭP(PPЬ޼QЭPޠ$P`aЭP>$P`<PP/ЭRPPЭQPPabRR<RR޼R b< ^q  U  T  PrݬЬPݠ$ЬP(e  P޼Rb%T  ޼RbŐ5޼Rb޼Rb޼Rb޼SRPݲ  PDPݠDﻜЭc޼Rb V ݬbݏ  žh޼RЭb 1  P޼Rb1 Pݏ   ݬլcMլHѬ   >ЬP@3ЬSݬ߭ЬPݭЬP@RbPlP޼RЏ b&Pݬ߭ЬPݭl  P` ݬqݏ  w޼RЭbЛ޼RbЬQPP   P޼R                                                                                                                                                                                                                                                   $                                RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1
1                                                                                                                    n      _       bGqŬ| ^ԓ  VЬRRR<RBЭRFRRЭRRRR ЭRRʏRR	RRRR ЭSЭRТ@ݬݭ"޼SЭRޢRbcݭPP[PI(P R	R bRbЭR>SRcbЭRݢpݬݬ޼R b PP< ^޼RbPP  4 4 h h t t "?P^PЬRF޼RbDЬRf' ݬϏPЏ^(n︚PݬcPP Μ^m  V,  WЬRRR ЭRRʏRSRSSЭRRʏRSRSSЭRRʏRSRSSЭRFЭRݢ<ЭRAPPЭR>FRbDЭR<Rď`   RB|>  P <Rď`   RBǿ SЭRc<EPʏ  PݭPsݬݭݏ ݬЭS<Rď`   RBRDbAm  ݭ{PƘHݬݭݏ ݬϷЭRFRbЭR>FR<bRď`   RBǿ RRݬݬݭ1PЭRHRb<RBѽѽ	ѽoѽЭRТRRЭRТRRЭԭЭRѢ@4  &PݭϗPݽPƾXPݭѽݬݬ<RRPѽLѽFսAݭ6PݽzP  ݏ  !ЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR.ЭTRRЭSRRАcdRR<RRЭRЬ8SЭRѢEЭSЭRТ@ЭRNRRݭρխݬݭݭݬϟЭRբl1ЭRբp^ЭSЭRݢlЭR޲lR޲ R޲ RbPpխ2Ό  PݭVﰾݬݭݭݬ'ЭRNSЭR޲pR޲ RSbݬݭݏ ݬYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR bЭR@ݬЭR>JR<bSЭRCP^(YnЭRݢpЭR޲pRbR޲RbխTʋ  Pݭƅ﬽޼RbЬR^(nݬݭݭݬЭSЭRѣ@.g  #PݭsPЭRݢƷ8ЭSЭRѣ@?ս:ѽݬݭݭݬݬݭݏ ݬvս"ЭSЭRѣ@ЭRF>SЭSЭRRѣ@R@﬊  ݭϻPݬݭݏ ݬЭRRʏRR/߭ݬ<RRݬݬPխͰЭR>JR<bRR ͰݭϣЭSЭRТ@ЭRgR bЭRЭ ЭRVϥЬR>R<bRR0  P   PPЭRբpЭR޲pRbRâRR䰏P ͦͨRЏ
 bЭͬ ͱ ] UYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR b^S^Rۧ  PD^^RݢD﶑ѭ 1 ЭU ݭUݏx  [ ,  P^(Un<{ͲRRܕ^(UnPPЏ PURRݭݭ 1ﺇ  RRﱇ  ݏ   ݭϡЭRVPͱ߭߭^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbR
b1 ЭRϊЭRݢ\PխЏ ^(nFͱ߭߭ݭ^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbRb ݭϥݏ  r﫹ѭ9ͱݭ|ͲRRݏ ݭPRѭRR]^ﴏЭR <1(P ЭRHRbЭRLR bЭR ЭRܢ?]9ЭR <ЭRJRbЭRݢpݬݭݬʿ1 PЭЭR@RЭbЭRբpЭR޲pRbRĢRRЭRݭJP<P   RRݭЭRݢ<s  ]	PЭЭRDR bݭݬ;ͰݭЭR   PSRSbͱݭЭR  )U#ˏ  URR  ^(Un^(UnRP^(Unﾎ ^a  TJ  SЬPHЬRЬP(\枢HQPaЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P2  PO^  PݬkPħ8ЬPЬPJP ` ݬݬݬϽЬP>HP<`P@ЭR   PQPQ`ЬQЭPѡ@e׃  1PݬPЭPݠЬP>HP<`PPЬPЬPJP ` ݬݬݬ1ЬQЭPѡ@ݬݬݭݬ@M  ݬ[P"(P ^`  T  SЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P_1  P4ʂ  (PݬPЬP>HP<`PP<ЬP>HP<`P@ЭR )  PQPQ`ѽЬQЭPѡ@	ݭ ^9_  Tﺃ  SЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P0  P4  (PݬPЬP>HP<`PPrﾳЬP>HP<`P@ЭR Q  PQPQ`ѽЬQЭPѡ@9~  .PݬϋPЭPݠݽPĪDЬP>LP<`RRЭP>DP<`PRPЭRЬP>LP<`PPPPQDPQ`ݭݬP ^]  Tf  SЬPHЬRЬP(x➢HQPaЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P/  POz  PݬχPTЬPЬPJP ` ݬݬݬЬP>HP<`P@ЭR   PQPQ`ЬP
ЬPJP ` ݬݬݬݭς ^\  R  2PݬPЬPPPPPP	P |^k\  V  WЬRRR޼R bЭR>HR<bRR   >ЭRH2:  PЭR>HR<bRR:	޼RЏ bЭR>FR<bRR <ЭRF0~  ЭR>FR<bRRg	ư޼RЏ bЬRRޭRЬb<RR.ЭTRRЭSRRcdRR<RR   PRRЭRբ8>ЭRѢ82?~  PƔ	$ݭݏ ݬϘЭR8RbݏL	  	޼TSR  PDRݢDЭd޼Rb d޼R^(bnjЭRRRRRխݬݬݬϡPݭݬ<RBXRbլ6ЭRNR,{  SBc"ݬЭRNR{  SBcR޲Rb  ͎ﵯ< ^Ь SR  PDRݢDЭѭ խݭ^(nbЭR>JR<bRRݭ!PݬݬݬݬݭݬݭKݬQ  ^}  QPPP< ^ЬЭRѢݬݬݬ6PЭRТѽ޼RЏ b޼SЭRТ R(c޼R b  ^޼P `ЬPРѽ޼PЏ ` PЭPՠl޼PЏ `ЭPРlPP  ^޼P `ЬPРѽ
޼PЏ `,ЭPՠpЭPݠpЭPްpP`PްP`ЭPЬpP  ^޼P `ЬPРѽ޼PЏ ` P	ЭPРpPP ^9|  RѬ   ޼PЏ `+ݏ   ƵP ЭP @   ЬPЬ@޼P     ^{  P | ^{  V ޼R bm޼RbcP<Rď`   RB.ЬScTcRRcďV   T޼S<Rď`   R(V Bƿ DcRR޼RbPЬScRRc޼R b  ^  RPP PP߭߭ݏ   ݭݭݭ 1ݬ
޼P`<PPPPPЭ䋏QQQ/w  PPPQP.Qw  PQPQ	w  PQP
޼Pн``QQQv  PPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭP| L^g  V]S]R-  PD]]RݢDLLYY !Xݭﱳ^(Yn݁޼Rb RR<RRSR   SSXXRRݭ>P	ͥRR<RRRRRЭܭЬRRíܭRRͥRR߭߭ݏ   ݭݭݭ1ݬ
<RRRRRЭܭSSS)u  RRRSR1 Su  RSR1 St  RSR1 RRRRRR>RbRR౭Џ  T^(TnyíܭRRRRR޼RbRR<RRRݭݭY<RRRRíܭRRRRR޼RbRнbRR޼Rнb1PRRSSSt  RRRSR
>Rb"P>RRЭЭRЭR̢RR౭Џ  P^(Pn޼RbRR<RRխ1 íܭRRRRRSSSws  RRRSR
н<P޽RRЭЭRЭSЭRЭSЭRЭRĢRRRRRRխ1líܭRRRRRSSSr  RRRSR޼RbRнb=޼RbRRЭ୼ЭRЭSЭRЭSЭRЭR                                                                                                                                                                                                                                                   %                                RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                    A      n       RRSSSvr  RRRSR
޼Rнb?P޼RbRRЭ୴ЭRЭSЭRЭSЭRЭRݭ勞XݭY]}| ^ӌ  V%S%R  PD%%RݢDt|!! ! ݭ^(!nI}޼Rbz RR<zRRSR   SS  RRݭ郞PPmRR<zRRRRRЭܭЬRRíܭRRmRRmqr߭߭ݏ   ݭݭݭ1ݬ
<zRRRRRЭܭrSSSp  RRRSR1rSpp  RSR1sS]p  RSR1RRRRxRR>vRbRRvxЏ  ^(n{޼RbRR<vRRխ1íܭRRRRR޽RнbRRЭRRRݏ@   ݭݭ@   RRЭRDRbRRíܭRRRRRЭRFRнbRRЭRJRbRRЭRLRbRRЭRNRRЭRORRݭݭRRȏV   RRRRխ1íܭRRRRR޼RbRнbRR޼Rнb1sPRRrSSSn  RRRSR>vRb!>vRRЭ୼ЭRЭRRRvxЏ  ^(ny޼RbRR<vRRխ1íܭRRRRRrSSSm  RRRSR
޽Rнb<P޽RRЭ୴ЭRЭSЭRЭSЭRЭRRRЭRRR խhrSSSfm  RRRSR
>Rb"P>RRЭ୬ЭRЭRRRRRRRխrSSSl  RRRSRЭRDRb#ЭRDRRЭ୤ЭRЭRRRíܭRRRRRrSSSl  RRRSRЭRFRнb@PЭRFRRЭଡ଼ЭRЭSЭRЭSЭRЭRRRrSSS$l  RRRSRЭRJRb$ЭRJRRЭ୔ЭRЭRRRrSSSk  RRRSRЭRLRb&PЭRLRRЭୌЭRЭRRRЭRNRRЭRORRխ&RRRRRRխȏV   RRRRխ1íܭRRRRRrSSSj  RRRSR޼RbRнb=޼RbRRЭୄЭRЭSЭRЭSЭRЭRRRrSSSj  RRRSR޼RнbCP޼RbRRЭ||RЭS|RЭS|RЭR|qݭﲧ ݭ!%u ^߄  RPP PP߭߭ݏ   ݭݭݭ1 ݬ
؉޼P`<PPPPPЭ䋏QQQoi  PPPQP.QXi  PQPQIi  PQP
޼Pн``QQQ'i  PPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭX    ^ݬ］޼P` PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R   < x^SRڈ  PDRݢDzrzѭ խݭ/^(ns ޼Rb<RRRRRЭSSSg  RRRSR2S|g  RSRެRSig  RSR
ޭRнb]SSSGg  RRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭRآRRR
P߭ݭݭݬ RRRRRRЬ$SRѭRRccRR޼RݭPb޼RЬb޼S<RRRcRRЭRRRR԰ԽRRRRRRҰҽRRҭЏ  ~^(~nqíRRRRR޽RR<RRRݭݭＫ<RRRRíRRRRRЭRRЭRR޼ SíRRcխݭآ޼(R b< l^~S~R$  PD~~RݢDnonzz  խݭu^(znp ޼Rb<RRRRRЭSSSd  RRRSR3Sd  RSRެRSd  RSRޭRнb^SSSd  RRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭR̢RďV   RRMPv߭ݭݭݬ Rď[   RRRRRЬ$SRѭRRccRR޼Rݭ0PbP޼RЬb޼S<RRRcRRЭRRRRȰȽRRRRRRưƽRRƭЏ  r^(rnoRR<RRխ1íRRRRRнܽRRЭRRRݏ@   ݭݭ̨@   RRЭR>DRbRRíRRRRRЭRޢFRbRRЭR>JRbRRЭR>LRbRRЭRNRRЭRORRݭݭ'RR܏V   RRRRխ1íRRRRRЭRRvRR޼ SíRRcխݭ*޼(R    ^ݬp޼P` PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R b    ^Q}  Qլ#Ѭ
2P@0޼P `Џ   PP޼PЏ
 ` P ^
}  R޼P `  ޼Pѭ`޼PЏ `)P2PP@0ЭP޼Q@aPP
޼P   ^|  S޼P `޼R޼Pb` Pݬ޼P<`PPP1PˏPPKݬݬݬݬݬ޼P<`PPP2PP@0Pް0P`P޼P`1ZP P1ˏPPwݬ߭ݬݬ	  ޼P`1ݬ߭ݬݬY	  ޼P`1 Pѭݭ  P P1 ˏPPsݬ߭ݬݬ	  ޼P`1 ݬ߭ݬݬ	  ޼P`nPѭݭ^  P PˏPP2ݬݬݬh   PRݬݬݬR   RP PЏ   P޼P ` Ѭ ݬݬݬ~  P	PPPPPPP ^}z  Rݬ޼P<`PPPݬݬݬ޼P<`PPP2PP@0Pް P`PP ^-z  Rݬ޼P<`PPP޼P`ݬݬݬݬ޼P<`PPP2PP@0PްP  ^y  Rݬ޼P<`PPcP޼P`ݬݬݬݬ޼P<`PPP2PP@0PްP  ^-F  R޼P `ݬbݬ}  P
Pݬߢݬ}  PPݬߢݬi}  PPݬߢ
ݬN}  P P޼PЏ
   ЏP ^E  RЬPP 
, \ 8 \ \ \ D \ \ \ \ \ \ P 
P^?P2PޢPP2PޢPP&PޢPPPޢPPP޼PЏ
 `޼P`ݭݬ|  ݭ}  P޼Pѭ`޼PЭ`޼P   ^+x  R޼P`Ѭ  ޼PЏ `ݏ  ݬ.|  ЬP @PPլg:ݬ|  Pխ޼PЏ ` ݬìPPݬP޼P`ìPPPPPPPݬݬP޼P`ݏ[   ݬ{  PխЬT ݏ]   PP^{  Pխ޼PЏ ` PP*{  PPPìPP޼P`PPV޼P`PQP#QQ	PPݬݬݬݭPPݬݬ2P@0PްP`Oݬ߭ݬ  ݬݭݬݬX  ݬݭݬݬ ^B  T v  SЏd   Џd   ݬ޼P<`PPPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`ЭP @߭(ߤ"z  ޼P`ݬy  y  P޼P`޼Rݬy  PPPb޼Rݬݬ P   ^A  Tt  SЏd   Џd   ݬ޼P<`PPrPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`'ЭP @߭(ߤ)x  [Pݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`ЭP @߭(ߤ/x  ޼P`ݬx  mx  P޼P`޼RݬPx  PPPb޼Rݬݬ P  <  ^ݬ޼RbݬP޼Rbݬ߭߭߭ݭ޼R<bRR  ޼Rb޼R(b޼SޭRb  ^s  RݬݬPݬݬ2P@0P P  PP ^r  RݬݬYP޼P` ݬw  ޼P`ݬݬݬݬ2P@0P P   ^ar  Rݬ޼P<`PPP޼P` ݬv  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@0Pް P  ^q  R޼Q޼P`a޼P`ݬ޼P<`PPePݬݬݬݬݬ޼P<`PPP2PP@0Pް$P   ^q  Rݬ޼P<`PPP޼P` ݬu  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@0Pް(P  ^	q  R޼Q޼P`a޼P`ݬ޼P<`PPPݬݬݬݬݬ                                                                                                                                                                                                                                                   &                        W        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                    R      }       ޼P<`PPP2PP@0Pް,P   ^p  Rݬݬ5Pݬݬݬݬݬݬ2P@0P4 P   ^Up  RЬݬ޼P<`PPPݬݭݬ޼P<`PPP2PP@0P8 P   ^p  RЬݬ<PPPݬݭݬ<PPP2PP@0Pް<P` .A    A      ^<  Sp  T c(t  Pѭ2ݏ  ߣs  Pѭݏ  ߣ4ts  ѭ+ݭs  Pѭ`޼Rb+޼Rb+ЬP/P:P޼RФ+bЬR>/P<`QQ  QPQ`>P<`PPЬRbPPb޼Rb+ЬP>Q/Pa`ѭ#  ݭ6s  ݬݭr  ݭs   X^n  T|J  Ï PPNRD{RPNPP@PRPR޼RGgPJPPPbЬRPPQPQ`ݬIդL1  j߭߭j߭n>P<`PPjݭn߭ ; r  j߭;ݭPPLЬPP `ЬP; ЬP	q  ѤLФLPPPݭ=ЬP	q   ^9  RЬPPPЬPPPЬP
PPЬPPPЬPPPЬP
PPЬP	PPЬPPPЬP>P<`PP޼P`ߢN   5q    ^a9  R??߭ ݬpp  Pѭ
޼PЏ`޼P `޼PЭ`ЬPP`ЬPЬPP `ЬP	ЬP
ЬPЬPЬP
ЬPЬP     ^ ޼Q޼Pa`1 ЬQЬP1 ЬQЬP1 ЬQЬPrЬQЬP		cЬQЬP

TЬQЬPEЬQЬP6ЬQЬP

'ЬQЬPЬQЬP	PPPPPPP ^ЬЬ ЭQPPaRЭQPPaPPRRխЭPЭP ^ЬЭPͽQЭP̠QЭP̠QQP̭Pʏ  PPQЭPЬRRRPRQPQ{RPPQQP  | l^j  VuSuRn  PDuuRݢDlXlqq !pݭ)^(qnUY޼Rb RR<RRSR   SSppRRݭﶊP	ͽRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭRRíܭRRRRRЬRRíܭRRͽRR߭߭ݏ   ݭݭݭ 1ݬ
zl<RRRRRЭܭSSSL  RRRSRDSL  RSR0SK  RSR ޼RbRнbRR޼Rнb1 SSSK  RRRSR޼RbRнb=޼RbRRЭЭRЭSЭRЭSЭRЭRТRRSSSNK  RRRSR
޼Rнb?P޼RbRRЭЭRЭSЭRЭSЭRЭRȢݭ|pݭkquU  ^޼P`<PPPPPЭQQQJ  PPPQP1 Q{J  PQP1 ެPQeJ  PQP1 ޭPн`PPP`PPP`PPPPPPݭݭPPíPPPPPޭPн`1QQQI  PPPQP
ޭPн`9ޭPPЭЭPЭQЭPЭQЭPЭPؠPPQQQaI  PPPQPP`!PPPЭЭPЭPРPPQQQI  PPPQP
P`PPЭЭPЭPȠPPPPPPխ&PPPPPPխíPPPPPQQQnH  PPPQP
ޭPн`<PޭPPЭЭPЭQЭPЭQЭPЭP߭ݭݬx] PPЬ$QPѭPPaaPP޼Rݭ?Pb
P޼RЬb޼P<RRR`RRЭЭRRЭRR޼ PíRR`޼(R b  ^ЬխЏP ѭˏPP&xPPPPѭˏPPЭP ^ ЭP޼Q@a$ŭ RЭP޼Q@asPRRЭP?ʘ P ^d  Rg  ޼PЭ`ЬQ>P<`PPPP޼Q<,PPaЬPТ0 < $^޼R( bݏi ݬ  P PRSRS3SRRRRPP< $^޼R( bݏi ݬ  P PRSRS3SRRRRPP< $^޼R( bݏ
i ݬd  P P>R<bRSRSSRRP< $^޼R( bݬݬYP%ݬݬPݬݬPP Pݏi ݬ
  P PRSRS3SRRRRP  ^ݬ  PխЏPЭPްP`P  ^߬  Pխ PP  ^ЬѬ޼PЏ`ЭP> P<  PP  PPPP ^Ь޼P`޼PЏ`޼P `ЭRݬ  PQPQ` ^Ь޼P`޼PЏ`޼P `Ѭ (Ѭ  ЭRݏ   B  PQPQ`PP |^ЬѬd   ޼PЏ `޼P `޼P` ݭnd  ݬݬݬݭݬݬ߭d  ЬP @4߭
  Pѭ޼PЏ `ЭPPЭ`1 ߭PЭPP޼PЏ `ޭPPޭPPЭRPPЭQPPabЭQRRЭPRR`aЭQRRЭPRR`aЭQRRЭPRR`aЭRRЭb޼R  < ^ЬѬ޼RЏbЭR^(n	  P޼Rݭ6c  PbP޼RЏ bݭݬb  ޼Sݬc  PRRc޼R     ^ЬѬ޼PЏ`޼P `ЭPՠ$޼P`ݬj	  P޼PЏ `8ЭPݠϳPխ޼PЏ `޼P`ݭݬa  ݬab  P޼Pѭ`޼PЭ`P  ^޼P   Џ   P  ^ ЬPa  ޼P`   Pѭ޼PЏ `Џ   PPݏiݭe  Pݭ  ޼PЏ ` PPPPխ1 ݭݭKP_ݭݭςPNݭݭP=ѭ7ЭPPPЭPР߭ЬP`  ޼P `P PPPPխ1vݭ  ޼P     ^ЬЭPРѬ޼PЏ`޼P `޼P`߭ P m`    ^ЬѬ޼PЏ`޼P `޼P`ЬP߭,`  ЭPP    ^ЬЭPРѬ޼PЏ`޼P `޼P`߭ P _    ^ЬѬ޼PЏ`޼P `޼P`ЬP߭_  ЭPP    <^ЬЬѬ޼PЏ`Ѭ޼PЏ`ݬݭ:_  ݬݭ'_  ޼P `Pݠi  PPPPݠS  PPPˏPP'ˏPPˏ Qˏ PQP1 ˏ?PP   .ˏ?PP   ˏ  Qˏ  PQPGPˏ?PP   .ˏ?PP   ˏ   Qˏ   PQPP ːPPPPP| ΰ^3'  V޼Rb޼RЏ b :  Pѭ޼RЏ bЏ   RRݏiݭ  Pݭ  ޼RЏ b RR RRխ1 ޼Rѭb1 S޼RCbRR( ͼݭݭPѭP1 ЭR޼SBcRbЭRݬ  PSRSbͼݏi ݭ  Pf\  0RRЭRЭR\  RR&P RRRRխ
޼Rѭb1޼RЭb޼R b    ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ  ^Џ   ߭ݏ~fݬ   P  ^   [  PP  ^ݬݬݬݬ   ]  PP  ^ݬݬݬݬݬ   !  PP  ^ݬݬݬݬݬ     PP <^i$  R^[  S߭F[  PˏPP ݬZ  Pխ	cЏPP`ΞPPˏPP' PP#枭PP ЬЬݭݭ      ߭<PPݭݭ PˏPPݭbKZ  ЭcЏP>P<`PʏPPH>P<`PP>P<`PP>P<`PP>P<`PPߢY  >P<`PPPPcЏP߭Z  P P     Z   Z  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  Y  |Y  xY  tY  pY  lY                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             '                        {6        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1
1                                                                                                                    t                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             rpc$exe:rpc$stcode.db status %lx status %lx (%s) status %lx (%s/%s) %s (%s/%s)  rpc$exe:glb_obj.txt rpc$exe:glb_sites. rpc$exe:glb_sites. Can't open '%s', errno=%d
 rpc$exe:glb_sites. (find_server_nbrd) Error reading '%s', errno=%d
 rpc$exe:glb_sites. (find_server_nbrd) Error reading '%s' - file is empty
 rpc$exe:glb_sites. (find_server_nbrd) no more potential sites
 (find_server_nbrd) trying site '%s'
 (find_server_nbrd) error converting to sockaddr (0x%lx)
 (find_server_nbrd) family mismatch '%s' (%d) and %d
 (find_server_nbrd) '%s' LLB lookup failure (0x%lx)
 (find_server_nbrd) '%s' LLB doesn't have a GLB registered (0x%lx)
 (find_server_nbrd) LLB lookup result %d, invalid family (%d)
 (find_server_nbrd) LLB doesn't have GLB registered with valid family
 'couldn't convert name' (find_server_nbrd) GLB registered at '%s[%ld]'
 (find_server_nbrd) couldn't set glb binding (0x%lx)
 (find_server_nbrd) RPC runtime failure on glb lookup(0x%lx)
   333b91de0000.0d.00.00.87.84.00.00.00 333b91de0000.0d.00.00.87.84.00.00.00 333b91eb0000.0d.00.00.87.84.00.00.00 333b91f70000.0d.00.00.87.84.00.00.00 %s
     *** Exiting: exception caught by PFM system cleanup handler
*** %s
 Ran out of sockets DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (alloc_socket) Can't create socket, errno=%d
 (alloc_socket) Can't bind socket, errno=%d
 (send_pkt) cannot enable broadcast, status=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (send_pkt) cannot enable broadcast, errno=%d
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (c_recv_pkt) Rcvd callback (ptype=%s)
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (c_recv_pkt) Rcvd packet not for my activity
 (c_recv_pkt) Rcvd packet with bad seq (should be %lu, is %lu; ptype=%s)
 Can't register call DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (ack_replies) Acking [%s, %lu]
 (ack_replies) Can't send ACK, errno=%d
 RPC reply acknowledger DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (await_reply) timeout
 (await_reply) select failed, errno=%d
 (await_reply) timeout (EINTR)
 (await_reply) select returned junk, errno=%d
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (rpc_$sar) can't get encr, status=%08lx
 (rpc_$sar) Anomolous response to request (ptype=%s)
 (rpc_$sar) Starting to ping
 select failed DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (rpc_$sar) Too many pings...signaling
 (rpc_$sar) Anomolous response to ping (ptype=%s)
 select failed DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (rpc_$sar) Rcvd "working" during frag send!
 (rpc_$sar) Rcvd "working" pkt; seq=%lu
 (rpc_$sar) Got "fack" for non-large request!
 (rpc_$sar) Got non-frag "response" during frag recv!
    (rpc) *** FATAL ERROR "%s" at %s\%d ***
 request ping response fault working nocall reject ack quit fack quack BOGUS PACKET TYPE (rpc_$recvfrom) recvfrom failed (rpc_$unpack_hdr) Bad RPC version (%u)
 (rpc_$unpack_hdr) Bad pkt type (%d)
 (rpc_$unpack_hdr) Packet too short; is %u, data len is %u
 (rpc_$sendto) sendto failed pkt->refcnt > 0 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;5 n_tasks < MAX_TASKS DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;5 %s%s
 	# of remote calls out:	%lu
 	# of remote calls in:	%lu
 	# of pkts sent:	%lu
 		%s	%lu
 	# of pkts rcvd:	%lu
 		%s	%lu
 	# of frag resends:	%lu
 	# of dup frags rcvd:	%lu
   DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1 (use_family) Can't create socket
 (use_family) Can't bind socket, errno=%d
 (rpc_$use_family) Can't getsockname, errno=%d
 (rpc_$use_family) Can't get my netaddr
 (check_for_pkt_common) Rcvd (ptype=%s)
 (listen) Spurious quit_activity fault ignored
 (listen) Exiting, st=%08lx
 (await_pkt) select failed: %d, errno=%d
 which < n_sockets DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1 RPC packet checker   %s, %lu.%u frag in_call_back working in_reply replied idle passive DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 act->state == as_in_reply || act->state == as_replied DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 act->state = as_replied DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (get_activity) Can't allocate slot
 act->state == as_idle DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 act->state == as_passive DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (scan_activities) Freeing passive [%s]
 (scan_activities) Passivating idle [%s]
 (scan_activities) Dropping reply [%s]
 (scan_activities) Retransmitting reply (state=%s) [%s]
 RPC activity scanner (ping_common) Working (ptype=%s) [%s]
 (ping_common) Resending reply (state=%s, ptype=%s, frag=%u) [%s]
 (ping_common) No call (state=%s, ptype=%s) [%s]
 (ping_common) Invalid activity state (state=%s, ptype=%s)
 invalid activity state DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (who_are_you) Doing callback
 (who_are_you) Can't bind to client, st=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (who_are_you) fault, st=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (who_are_you) who_are_you failed, st=%08lx
 (do_request) Unknown interface [%s]
 (do_request) Opnum out of range [%s]
 (do_request) Got inappropriate request (state=%s) [%s]
 (do_request) Invalid state (state=%s) [%s] DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (do_request) couldn't get encr (status=%08lx)
 (do_request) couldn't decrypt pkt (status=%08lx)
 (do_request) Old sequence, previous=%ld [%s]
 (do_request) Protocol error [%s]
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (do_request) Fault while executing request, st=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (do_ping) No call (no activity for this call) [%s]
 (do_ping) No call (higher numbered ping), ahint=%d, previous=%ld [%s]
 (do_ping) Drop ping [%s]
 (do_ack) No or incorrect ahint in ack, ahint=%d [%s]
 (do_fack) No or incorr                                                                                                                                                                                                                                                   (                        ;Hҳ        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                    IK             ect ahint in fack, ahint=%d [%s]
 (do_fack) Anomalous fack, state=%s, prev_seq=%lu [%s]
 (do_quit) No call (no activity for this call) [%s]
 (do_bad_pkt) Bad pkt, ptype=%s [%s]
 (rpc_$int_listen_dispatch) Trash ahint (%u)
 (rpc_$int_listen_dispatch) Trash ihint (%u)
 (rpc_$int_listen_dispatch) Server boot time mismatch
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1  dds ip ns unspec unspec ip ns dds %s:#%s %s:%s %s:#%s   sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat %08lx%04x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x %8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx    (socket_inet/set interface broadcast address):  ioctl failed: status = %d
 ioctl failed: status = %x, %x, %x%x
 @(#)error.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                             @(#)glb_cstub.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
     \
    ,  "    @(#)glb.c	2.2     (ultrix)        11/15/89                                                                     i.;3    
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ő;3    
     ޑ;3    
                                                                                                                     
      @(#)lb.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                          @(#)llb_cstub.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                                                       3;3    
     |6  :  L?  @(#)llb.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                                                       3;3    
           %W%     (ultrix)        %G%                 %W%   (ultrix)  %G                                                                          v":3    
                                                                          96 @  
  f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              %W%   (ultrix)  %G                                                                     v":3    
                                                                          96 @  
  f                                                                                                     7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????   ??????  ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#@'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[???????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????0123456789|?????                                                                                                                            !% )% .% 7% =% E% L% S% W% \% a% %W%   (ultrix)  %G                                                                     v":3    
                                                                          96 @  
  f                                                                                        @(#)float.c	2.1     (ultrix)        6/13/89 %W%   (ultrix)  %G                                                                     v":3    
                                                                          96 @  
  f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       )                        ݂F        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1;1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ) ) ) ) ) ) )                                     \    4    @(#)rrpc_cstub.c	2.1     (ultrix)        6/13/89                                                                      96 @  
  f            @(#)rrpc_sstub.c	2.1     (ultrix)        6/13/89                                                                      96 @  
  f       8  T     l       f @(#)socket.c	2.1     (ultrix)        6/13/89            i                                             @(#)uuid.c	2.1     (ultrix)        6/13/89                                      @(#)conv_cstub.c	2.1     (ultrix)        6/13/89                                                                     v":3    
        @(#)conv_sstub.c	2.1     (ultrix)        6/13/89                                                                     v":3    
     `     h @(#)vms.c	2.1	VMS/ULTRIX Connection	6/29/89         @(#)socket_inet.c	2.7     (ultrix)        12/21/89   8    ,	 D	 
 
 4   $
  $  %W%   (ultrix)  %G                                                                                                                                                                              @  @   D  8  D                                     M      X'  '  @(  '  '  '  '  '  '  '  (  x(  p'  '  '  '  '  '  '  (  (  8(  0(  X(  ((  p(  h(  `(   (  P(  (  (  '  (   (  '  x'  h'  `'  H(         d  '        |      l  |    L   4  0'  \    L  L    D  $  &      t    &  <     $           '                 
  ,
  8
  Z'  b'  j'  r'  z'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  (  
(  (  (  "(  *(  2(  :(  B(  R(  Z(  b(  j(  r(  z(  (  (  (      j  
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                 E       6 6 6 6 p< t< x< L L L L L L L L L L L (e ,e 0e 4e 8e <e @e \e `e de he le pe te xe |e e f f f f f f f f f f                                                                                                                                                                                                                                                    *                        'j        RPC010.B                       $	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.EXE;1
1                                                                                                                                 f f f  g h h h h i i i i i i i #i 'i +i /i 3i 7i ;i ?i Ci *      k k k k k k k k k k k k k k k k k k k k k k k k k k k k  l l l l l l l l  l $l (l ,l 0l 4l                                                                                                                                                                                                                                                 ?     
RPC$LIBNCKRPC V1.0A-0018-SEP-1990 15:2918-SEP-1990 15:29   VAX-11 Linker V05-05        	.$$ABS$$.        CLOSE_SOCKET       
SELECT_NCK      	UUID_$GEN       UUID_$ENCODE      UUID_$DECODE       UUID_$EQUAL       SOCKET_$VALID_FAMILY      SOCKET_$VALID_FAMILIES   P   
SOCKET_$EQUAL      SOCKET_$INQ_PORT      SOCKET_$SET_PORT      SOCKET_$SET_WK_PORT   X   SOCKET_$FAMILY_FROM_NAME   `   SOCKET_$FAMILY_TO_NAME   p   SOCKET_$FROM_NAME      SOCKET_$TO_NUMERIC_NAME      SOCKET_$TO_NAME     < SOCKET_$SET_BROADCAST       SOCKET_$MAX_PKT_SIZE      SOCKET_$INQ_MY_NETADDR      SOCKET_$INQ_NETADDR      SOCKET_$SET_NETADDR      SOCKET_$INQ_HOSTID      SOCKET_$SET_HOSTID   x   SOCKET_$INQ_BROAD_ADDRS      SOCKET_$TO_LOCAL_REP   h   SOCKET_$FROM_LOCAL_REP      | 
RPC_$REGISTER      | RPC_$REGISTER_MGR       RPC_$UNREGISTER      | RPC_$REGISTER_OBJECT     < RPC_$LISTEN_DISPATCH        RPC_$SET_FAULT_MODE      < RPC_$INQ_OBJECT    8  | RRPC_$INQ_INTERFACES     < RPC_$CVT_SHORT_FLOAT     < RPC_$CVT_LONG_FLOAT   (    RPC_$USE_FAMILY   0    RPC_$USE_FAMILY_WK     < RPC_$LISTEN_RECV     < RPC_$FORWARD       RPC_$LISTEN       
RPC_$SHUTDOWN        RPC_$ALLOW_REMOTE_SHUTDOWN   H   RRPC_$SHUTDOWN   @    RRPC_$INQ_STATS   x  < RPC_$MALLOC   p    	RPC_$FREE   `    RPC_$ALLOC_PKT       
RPC_$FREE_PKT      RPC_$CVT_STRING   h    RPC_$BLOCK_COPY    (  | RPC_$STATUS_PRINT      RPC_$DUMP_STATS        RPC_$ALLOC_HANDLE       RPC_$SET_BINDING       RPC_$INQ_BINDING        RPC_$CLEAR_SERVER_BINDING        RPC_$CLEAR_BINDING        	RPC_$BIND       RPC_$SET_SHORT_TIMEOUT       RPC_$SET_ASYNC_ACK        RPC_$FREE_HANDLE        RPC_$DUP_HANDLE      RPC_$SAR        RPC_$NAME_TO_SOCKADDR       RPC_$SOCKADDR_TO_NAME   `     	PFM_$INIT   8     
PFM_$_CLEANUP   p     PFM_$_RLS_CLEANUP   h     PFM_$_RESET_CLEANUP   P     PFM_$INHIBIT   @     PFM_$ENABLE   X    PFM_$INHIBIT_FAULTS   H     PFM_$ENABLE_FAULTS   x   | PFM_$SIGNAL      < 	PGM_$EXIT   H  < LLB_CA_$INSERT   8  < LLB_CA_$DELETE   (   < LB_$REGISTER   0     LB_$UNREGISTER        LB_$LOOKUP_RANGE        LB_$LOOKUP_OBJECT        LB_$LOOKUP_OBJECT_LOCAL         LB_$LOOKUP_TYPE         LB_$LOOKUP_INTERFACE        LB_$USE_SHORT_TIMEOUTS      LB_$PROCESS_ARGS_I    X   GLB_CA_$GET_SERVER_ADDRESS   P   GLB_CA_$SET_SERVER_ADDRESS   @    GLB_CA_$INSERT   0    GLB_CA_$DELETE     | 
ERROR_$C_TEXT   f RRPC_$MANAGER_EPV   f RRPC_$SERVER_EPV   f RRPC_$CLIENT_EPV   J 	UUID_$NIL   J RPC_$LOCAL_DREP   J RPC_$ASCII_TO_EBCDIC   K RPC_$EBCDIC_TO_ASCII   L 
RPC_$DEBUG   L 
RPC_$LOSSY   p< LLB_$CLIENT_EPV   6 GLB_$CLIENT_EPV                    ' * [UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1 +  , 9	   . f   /    4     f  f                    - !   0   1    2   3      K  P   W   O g   5 6  6  R`>˓  7 F ϓ  8          9          G #  H  J                            %
   VAX-11 Librarian V04-00         >˓  7;M˓ !       G   %   e  f        2                    "     8   ^                                                                                                                                                                                                                                                                                                                                                                                                 CONV_$CLIENT_EPV    CONV_$MANAGER_EPV    CONV_$SERVER_EPV    CONV_$WHO_ARE_YOU    DAYLIGHT    ERROR_$C_GET_TEXT    
ERROR_$C_TEXT    ERROR_$FIND_TEXT    ERROR_$FIND_TEXT_STATIC    FFS    GETTIMEOFDAY#   GLB_$CLIENT_EPV    GLB_$DEFAULT_OBJ    GLB_$DEFAULT_TYPE    GLB_$HANDLE    
GLB_$TYPE_UID    GLB_$UID    GLB_CA_$DELETE    GLB_CA_$GET_OBJECT_UUID    GLB_CA_$GET_SERVER_ADDRESS    GLB_CA_$INSERT    GLB_CA_$LOOKUPULTSN_FLOAT      &              
CONV_CSTUB    
CONV_SSTUB    ERROR3    FLOAT    GLB#   	GLB_CSTUB?    LBX    LLB   	LLB_CSTUB    
RPC_CLIENT    RPC_LSN    RPC_SEQ_    
RPC_SERVER    RPC_UTIL    
RRPC_CSTUB	   
RRPC_SSTUB    SOCKET    SOCKET_INET9    UUID    U_PFM    VMS                                                                                                                                                                                                              g             RPC_$SENDTO_    RPC_$SERVER_TO_CLIENT_HANDLE    RPC_$SET_ASYNC_ACK    
RPC_$SET_AUTH_    RPC_$SET_AUTH_LOGGER    RPC_$SET_BINDING    
RPC_$SET_ENCR_    RPC_$SET_FAULT_MODE    RPC_$SET_PKT_BODY_ST_    RPC_$SET_SERVER_ENCR    RPC_$SET_SHORT_TIMEOUT    
RPC_$SHUTDOWN    RPC_$SOCKADDR_TO_NAME_    RPC_$START_ACTIVITY_SCANNER    
RPC_$STATS    RPC_$STOP_PERIODIC    RPC_$SWAB_HEADER    RPC_$UNLOCK_    RPC_$UNREGISTER    RPC_$USE_FAMILYUUID_$NIL                  GLB_CA_$LOOKUP   LLB_CA_$DELETE   PFM_$ENABLE_FAULTS   PFM_$_RESET_CLEANUP   RPC_$ALLOW_REMOTE_SHUTDOWN   RPC_$CVT_LONG_FLOAT   RPC_$EBCDIC_TO_ASCII	   RPC_$GET_HANDLE   RPC_$INQ_OBJECT_CLIENT   
RPC_$RECVFROM
   RPC_$SAR   RPC_$START_ACTIVITY_SCANNER   RPC_$USE_FAMILY   SOCKET_$MAX_PKT_SIZE
   SOCKET_$SET_WK_PORT   	_FINDCHAN                                                                                                                       _    RPC_$INQ_SAUTH_    RPC_$INQ_SERVER_ENCR    RPC_$INSERT_IN_FRAG_LIST_    RPC_$INT_LISTEN_DISPATCH    RPC_$LISTEN_    RPC_$LISTEN_DISPATCH    RPC_$LISTEN_RECV    RPC_$LOCAL_DREP    RPC_$LOCAL_DREP_PACKED    	RPC_$LOCK    
RPC_$LOSSY    RPC_$MALLOC    RPC_$MAX_DEBUG    RPC_$NAME_TO_SOCKADDR    RPC_$PERIODICALLY    
RPC_$PKT_NAME    RPC_$PRINTF    RPC_$REASSEMBLE_FRAG_LIST    
RPC_$RECVFROMGISTER_OBJECT9    RPC_$SAR                                       _    RPC_$GET_MY_ACTIVITY    RPC_$GET_PKT_BODY_ST    
RPC_$INQ_AUTH    RPC_$INQ_BINDING    
RPC_$INQ_ENCR_    RPC_$INQ_OBJECT    RPC_$INQ_OBJECT_CLIENT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              +                        ܥ        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        J                          RPC_$USE_FAMILY_WK    RRPC_$ARE_YOU_THERE    RRPC_$CLIENT_EPV_    RRPC_$INQ_INTERFACES    RRPC_$INQ_STATS	   RRPC_$MANAGER_EPV	   RRPC_$SERVER_EPV    RRPC_$SHUTDOWN    
SOCKET_$EQUAL    SOCKET_$FAMILY_FROM_NAME    SOCKET_$FAMILY_TO_NAME    SOCKET_$FROM_LOCAL_REP    SOCKET_$FROM_NAME    SOCKET_$INQ_BROAD_ADDRS    SOCKET_$INQ_HOSTID    SOCKET_$INQ_MY_NETADDR    SOCKET_$INQ_NETADDR    SOCKET_$INQ_PORT    SOCKET_$MAX_PKT_SIZE                              
RPC_$ENCR_RGY    RPC_$FILL_FRAG    RPC_$FORWARD    	RPC_$FREE    RPC_$FREE_FRAG_LIST    RPC_$FREE_HANDLE    RPC_$FREE_LINKED_PKT    
RPC_$FREE_PKT_    RPC_$GET_CALLERS_ADDR    RPC_$GET_HANDLE                                                                                                                                                                                                                                                                                                _    
RPC_$REGISTER_    RPC_$REGISTER_AUTHTYPE    RPC_$REGISTER_ENCRTYPE_    RPC_$REGISTER_MGR_    RPC_$REGISTER_OBJECT    RPC_$SAR                                                                                                                                                                                                                                                                                                                                                                                  
RPC_$STATS    RPC_$STATUS_PRINT    RPC_$STOP_PERIODIC    RPC_$SWAB_HEADER    RPC_$TERMINATION_FAULT    RPC_$UNLOCK_    RPC_$UNREGISTER    RPC_$USE_FAMILY                                                                                                                                                                                                                                                                                                                                             SOCKET_$TO_LOCAL_REP    SOCKET_$TO_NAME    SOCKET_$TO_NUMERIC_NAME    SOCKET_$VALID_FAMILIES    SOCKET_$VALID_FAMILY    TIMEZONE9    	UUID_$CMP9    UUID_$DECODE9    UUID_$ENCODE9    UUID_$EQUAL9    	UUID_$GEN9    
UUID_$HASH    	UUID_$NIL    	_FINDCHAN                                                                                                                                                                                                                                   SOCKET_$SET_BROADCAST    SOCKET_$SET_HOSTID    SOCKET_$SET_NETADDR    SOCKET_$SET_PORT    SOCKET_$SET_WK_PORT                                                                                                                                                                                                                                                                                                                                                                                              3    RPC_$CVT_SHORT_FLOAT    RPC_$CVT_STRING    
RPC_$DEBUG    RPC_$DIE    RPC_$DUMP_STATS    RPC_$DUP_HANDLE    RPC_$EBCDIC_TO_ASCII                                                                                                                                                                                                                                                                                                                                                                          RPC_$ASCII_TO_EBCDIC    	RPC_$BIND    RPC_$BLOCK_COPY    RPC_$CLEAR_BINDING    RPC_$CLEAR_SERVER_BINDING3    RPC_$CVT_LONG_FLOAT                                                                                                                                                                                                                                                                                                                                                                              PFM_$_RLS_CLEANUP    	PGM_$EXIT    RPC_$ALLOC_HANDLE    RPC_$ALLOC_LINKED_PKT    RPC_$ALLOC_PKT    RPC_$ALLOW_REMOTE_SHUTDOWN                                                                                                                                                                                                                                                                                                                                                                                PFM_$FAULT_INH_COUNT    PFM_$INHIBIT    PFM_$INHIBIT_FAULTS    	PFM_$INIT    PFM_$SIGNAL    
PFM_$_CLEANUP    PFM_$_RESET_CLEANUP                                                                                                                                                                                                                                                                                                                                                            z             GLB_CA_$SET_SERVER_ADDRESS    GLB_CA_$SET_SHORT_TIMEOUT    INET_$SOCKET_HANDLER?    LB_$LOOKUP_INTERFACE?    LB_$LOOKUP_OBJECT?    LB_$LOOKUP_OBJECT_LOCAL?    LB_$LOOKUP_RANGE?    LB_$LOOKUP_TYPE?    LB_$PROCESS_ARGS?    LB_$PROCESS_ARGS_I?    LB_$REGISTER?    LB_$UNREGISTER?    LB_$USE_SHORT_TIMEOUTS   LLB_$CLIENT_EPVX    LLB_CA_$DELETELLB_CA_$LOOKUP    LLB_CA_$SET_SHORT_TIMEOUT    OLD_ALARM_HANDLER    PFM_$ENABLE    PFM_$ENABLE_FAULTS                  X    LLB_CA_$INSERTX    LLB_CA_$LOOKUPX    LLB_CA_$SET_SHORT_TIMEOUT    OLD_ALARM_HANDLER    PFM_$ENABLE    PFM_$ENABLE_FAULTS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ,                           %                                                                                     
  1                                                                                                                       2       Q       ِMӨVZ>ӪߜjԈ#gӋiW!іkF2;OoՆB;[a0,N$Us $wxE<zg;ktկsOP09`to-*y>"eW<DTQ1
ߣ~!+<4AuT^fkP 4w>]x/3Ygfi4`F!~4vo"\@'\P;E`9  1Fxv_=aufqFN ܇|Q2X1	miT"R#J}9z`:n~i2U!+tfՃ8{~l.W7Ah*{0W]VBm8L?xzLYG*ou+0z+GgV^fPYұR_N4M'PHֹErk5:l*ĒJ/
EAr9|4sj)*V獎WL4>PnE}L;DB0kXͮvig}i\-B<<U /C_"qS6Pw2Q3}[LbRRhVF,aߩ2C{y٨
/ŠKm/Ɣ`k_ãdhkș9f!%e((k+|waoں.ʇgBS3	whDdf^~ӂ^>a2خ;'
'7Ava$=C<앁.@qTdK	zv*x"]4$>`et nFkiOq?=%hťR?9M,Q-:	P퓭7>L} M=*MM1?n>~2?$,"`o]6lTɫ5D}c\Mz1/L֛{5ksTdKiAa!-T=6jqXGRz.R<\juG-pe5E='S񼦀A=o!$<WWZN >YӗI吺s|Vmڿo,>U`upn#`a+y,RAOxf;+XyxCy]{`$|ٚ8*MTWx3wF@zlfr}\įP
IҌص6dC=Q&dS
Ut8u-vVZ x]p-$[Khh#1ϣ|0H3Wv
yS]h7~Mx uڅnbD@P"b#M0P	`T+Z-},'+q|vV`I$l/np,lbKF?U!(VމNXq^^4s)W
9?,Xǭ<BVB#5G$<L.&(ݮ뗑357gQb79K_37M/du4v͗a۾M Ay3I!++g_JK"7L1\a(f]n)g$`E)!28jǆ-adsyw|q
0'g'XtY{Ї(|ć_,U0(E>!M
^H?=$1bl܍>A;d>>zՁϡm#y=<&4?$Rΐ*me;0tNZay0"
Ѫ9lI C-=n$S6`BX}@!h'!yYqYk<*vХ$ˋS qX=>7x&qgNЮm'{ %y
l\nr2޸ɽrEєW,צJHs?ﴦHw{s@_InDLh Kʏ
еJOyEþDh/I riYLD)LbʁnPei_lr1T^͆$	b
Jl"1ۤ
m2<^cr9iup5N7o.pKYN4s<zm/?uYmtf#e	9&?R^Z	(*=;wNu@G?^mf.Zm|5|r.D-bkM9	xl^"P/{-4ԌmJnpr`?FgÿP~؇2)Vr!
sV{)H?1ɤl=+z,IUL ,[nskD"4>BOBLƿpҐ]{T+)Ճ̊EC"R)擱ER_Lm/-o%,
ɗp"A^; 6 6=$NjlG[3åSTi[+:	4咫z{%4{9Sֻ]m2ott),'"x=C՞Ӧ8lyy>b v"cw&Bo/@tc\1S9"c
fC6 ;8gI9q.#pHlrQ`n4TVqO' 芫20]{۷P̵C߬,po
;FY$Zs<yFMTf4^l
LB>f_jgcU`X5hRkХ1-Ybw&Эe1} m
X:IΆ=2unW:1'e21ߐ5yEQ\@".U@iF>`H؛V<LXc߬dlFy Ӕ<<-:|A
w-&/@=$F'8 pcܪĹX+ͫqYpYq:tq:Po4Qr6I.o-ES=$J$ݽ8N 6sG 0D֑b꺻h{,R-]= F%	8;[$ަ	LC/LERc%L3Zl-p3^{z({n J(}S]mUN!Yu)'iG*/f/
ĄoAN^	щiW2]>+rC@B eHbUBt<_0C9H̑p[joc5\{}~)6yE'j*5֠䨆x>&0JC&+[?sSeq?T'-[AIB~C;>pB3o}Q b`2T^@Jeq$xg}p;\D9~" y%75YO2 =0dg](X/:=-X@kP/"߾[ѢfpgqC9FA&scm㪰mcLRA9W)bn$C~' |5ZSW-
5svv%S_T$	of<@֐	7vr;򁍇, !dJrAeeS1u)讐dy	La%T&|Y`~*|MZX;O Am_5x&&>P-ׅu[Sta0LB0u	Ԝ8A;QkUuTX{ˌM,Sū!ǘw~S.0c[#pEb ߡtu{@4QI39M)K&p^vWno:ɗ"?OPF=c#QċI>L8ZcىG2ư>ނ7#@kj7Kٵ1哺PڣØ;˕&r"9
gG]^JV$z.;s=G
`-L[BBiȸ>-	f&X-PB1BpP)bn^jFng
¹;t֢wA&UkW|-/$ m&^>3gɂ*~:wKX
.[8 @]X%2Ig	pC?;%!s@~y|Nh]|3(mObYozXwXy2;hޔ@DU*JFs	=UH!^{mBHIfBmM@Omv)Q]S0-SwL5IwưUPI$WbI;[#e"8ƄRȁ	=c6J#D鑄XU6D7Pգ-:g*|]r~Zlx!R
!w(W-u|pJdIWn砻5TkCӻ-A0&M,/E hD%UiK@ؘNw _yQ(p2#y'"=yx@ BJ7q~`ypgŦT7*U{LmRPh2uP Aw>6f8-Ցk!2*Nύ}!`r;KO9Ɂdup=`
e),ҟjSk`UZ&o-@mR˟ w!;Uөmfi|yB-naNČ B87끒y6N޾0:f 7NBl]E}f=
wlυ f)a%ܶL WJ$=$$EN౒"R3Dk9q(?ez _SxʦD`h75FR`B-۳+łKg(̄$<˞yJt*,&3}A4-qH6nI%p#$ Ig	Qdd(TpM8R>yhEʟ~`oƵȘWfIZM/%@B'X5I1/o/IPXPvAz%" ]i7lL] =N&{ ]TO.we\
Um=fV!ݍi/FԬ(!0nA' ylu2$[Yk٧(=i2J.j
sK_e
C&&=2ШÑ逕KF%#r4Cy rݣ
ԝE#0Od 	~TAuySV}sѓ$6#.pɎ>]o(#42ν_QT:qr6F[jI&a&ݷP_gR%յ ۲0rlښDW*3lTn&@!^`<>ia_?/ C
Nw7kjkl,6p	;>BFL)u_"Ѵ+>M=fM]QߍNS~+9/WPφK'g*X2ilg1nⓅcr4I2y{Dsh_Խs쮧~7!J"	zqT,$)Qʊ̲n/'*S#bat~.^ڝX|⍭7ťc;)(a.uȼ@
'-q^
v,Eb%	B륄#1dJlwD$iO V!Z
*
89^̈N9OmB4BZ"h $h吾6486ˈ#E^VA̖Bz_a֕Y.f)L`IN%Nx?$*ZUuL j(%t1/t&iߕs}2
e{r̭DP[^%ҵFqfpVLdMMȊnm{Z
sY\Lipm>x#bP~ƹٲ	̲QA],#dc$8gvvoqड़دWn@߶kXi.E3,(v z֪}m|+J A

T3R>zO1naG]Ol32h\2`%ewBjo$%!T">pdjCCpgL.xJp*h\h	Z
Ϙz1~-//#Rf>wU+ҼK^3~tM1^%t9%ot_NO8DWYR,%Lyl()}(zKw.ҩ~ ßn[U"u5)ONT/s8,I'_]GKa;4AT:vnݹ
`ɩNnwa-&=k.!
XL9K?F'$UVEMuooo7
7fF%ЍIDJt{%@
@.؍"z:F wS7D41Y'~ɾcXЌŖ6hr(h\ZmTS+}t#|(n
̉x̳,c6NQ$%4+GiZm)P]a;ۢ
.-^kzJάFN"`(`s^x
ee	pd?knRW	dʬ{#A2S	l?GMdnU[d?<B=tRmnK>+NCd,2;9pH^S0׭JPټVm7>Z2Lt)M)jթj٣aZTMX)IܧOcOq0[.4[yE~!.쎍Χ@Q[uKoqEMPy]r9 ֚Ӝ>L%KUu]KII>x`VbB0qfwZ s?J2=%Gh#FI8. Fm"@hw
X!ga.sVKm88v|=͉1ޡ1Rl/#'ﻈO#a"?l|0O3֒9V#g=
Cb~Y"2r{
Vzn.p}}Ku(9 /:xAv( TR$NuKG)Y^,$of?k+ͯC\2lLݾ.
PBmk.grg."W"~8:JoCA+Vt9Pu_`Ǒ)q:<gs9!% <*yA|݄Kc0{(7xhC9cO                                                                                                                                                                                                                                                   -                        1        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  .                        !        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                        @      &       '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                4   1        \>˓ V1.0                            2     FLOATV1.014-SEP-1990 11:37                   VAX C V3.1-051  P@(#)float.c	2.1     (ultrix)        6/13/89  P ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPʏPxPPPQQ<PP
޼P `Z<PP   ޼P `CP޼R<PPPxPPPQ<PPxPPPQPPQbPQ`ЬR  PRPbP ^޼P`PPPxPPPPPЬPPPPxPPPQ޼P`PʏPxPPPQQЬPQЬPPPP 5   xPPPPPQЬPPʏPxPPPQQЬPQЬPPPPxPPPPPQЬPPPPxPPPPPQЬPPPPxPPPPPQQ<PPO޼TЬSЬ RЬQP `>P<`PPQPQ`>P<`PPQPQ`>P<`PPQdPQ`1 P<RR   K޼QЬPЬTЬSR b>R<bRRSRSb>R<bRRSRSb>R<bRRSaRSbg޼T<RRRxRRRS<RRxRRRSRRSdRSbЬR  SRSbЬTRRSRSbЬR  SRSb  ^ެPPPQQPP P	?P1ެPPPQQPP  P?P1PPPPyIЬP                                                                                                                                                                                                                                                   /                        +E        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                        U      5        6   ЬPЬPЬPЬPЬPЬP޼P`#ЬPЬPЬPΐ޼P`ޭPPݬݬ3ݬݬJ  R    FLOAT      ieee32_to_vaxf         ieee64_to_vaxg       	cvt_float       rpc_$cvt_short_float &       rpc_$cvt_long_float *   		     y   o&         #   		   
CC$_GFLOAT  RPC_$LOCAL_DR 7   EP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  ABORT 
    < RPC_$CVT_SHORT_FLOAT 
    < RPC_$CVT_LONG_FLOAT  &  $CODE ,   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR71 QQQPPPQP%޼Q޼PP`a
P޼Q޼PP`a1 Pk޼QЬPaЬQ޼P`ЬQЬPЬQЬPЬQЖPЬQЬPЬQЬPЬQЬP5P޼QЬPaЬQ޼P`ЬQЬPЬQЬP  ABORT  ABORT  ABORT       ABORT  ABORT< ^ ݬݬ^(n^(nP< ^ݏ   ݬݬ^(n^(nϧ 
P   P          w w                                                                                                                                                                                                                                                                                                                                                                               fn>˓  SUKONNIK    FLOAT# `>˓  SUKONNIK    
RPC_CLIENT# `?˓  SUKONNIK    
RPC_SERVER  B?˓  SUKONNIK    RPC_LSN! p?˓  SUKONNIK    RPC_UTIL MY@˓  SUKONNIK    SOCKET '@˓  SUKONNIK    UUID  0o9@˓  SUKONNIK    U_PFM @,D@˓  SUKONNIK    VMS  `5H@˓  SUKONNIK    RPC_SEQ  Y@˓  SUKONNIK    ERROR  @˓  SUKONNIK    GLB J@˓  SUKONNIK    LB @&U@˓  SUKONNIK    LLB# `3n@˓  SUKONN :   1       *?PG˓ V1.0                            1     UUIDV1.014-SEP-1990 12:40                    VAX C V3.1-051  P@(#)uuid.c	2.1     (ultrix)        6/13/89 Psys$scratch:last_uuid.datPsys$scratch:last_uuid.dat4Psys$scratch:last_uuid.dat  P.A    A    NP%08lx%04x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x P%8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx P  ^ S T c OPENPѭ2ݏ  ߣ CREATPѭݏ  ߣ4 CHMOD ;   ѭ+ݭ READPѭ`޼Rb+޼Rb+ЬP/P:P޼RФ+bЬR>/P<`QQ  QPQ`>P<`PPЬRbPPb޼Rb+ЬP>Q/Pa`ѭ#  ݭ LSEEKݬݭ WRITEݭ CLOSE X^ T| GETTIMEOFDAYÏ PPNRD{RPNPP@PRPR޼RGgPJPPPbЬRPPQPQ`ݬIդL1  j߭߭ SOCKET_$VALID_FAMILIESj߭n>P<`PP SOCKET_$INQ_MY_NETADDRjݭn߭ SOCKE <   T_$SET_NETADDR ; MEMSETj߭;ݭ SOCKET_$INQ_HOSTIDPPLЬPP `ЬP; ЬP	  MEMSETѤLФLPPPݭ=ЬP	 MEMCPY ^ RЬPPPЬPPPЬP
PPЬPPPЬPPPЬP
PPЬP	PPЬPPPЬP>P<`PP޼P`ߢN    
VAXC$GSPRINTF  ^ R??߭ ݬ VAXC$GSSCANFPѭ
޼PЏ`޼P `޼PЭ`ЬPP`ЬPЬPP `ЬP	ЬP =   
ЬPЬPЬP
ЬPЬP     ^ ޼Q޼Pa`1 ЬQЬP1 ЬQЬP1 ЬQЬPrЬQЬ  R    UUID     
check_uuid @    P  	uuid_$gen `      uuid_$encode      <  uuid_$decode        uuid_$equal        	uuid_$cmp P     $  
uuid_$hash j   		$        D0 	
  >   	     
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  SOCKET_$INQ_HOSTID  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$VALID_FAMILIES  VAXC$GSSCANF  
VAXC$GSPRINTF  MEMSET  MEMCPY  LSEEK  CLOSE  WRITE  READ  CHMOD  CREAT  OPEN  GETTIMEOFDAY 
  P   	UUID_$GEN 
     UUID_$ENCODE 
  <   UUID_$DECODE 
      UUID_$EQUAL 
     	UUID_$CMP 
  $   
UUID_$HA     SH    $CODE P   $DATA    ERRNO_     
VAXC$ERRNO    STDIN    STDOUT    STDERR    $CHAR_STRING_CONSTANTSU8P		cЬQЬP

TЬQЬPEЬQЬP6ЬQЬP

'ЬQЬPЬQЬP	PPPPPPP ^ЀЬ ЭQPPaRЭQPPaPPRRխЭPЭP ^ЬЭPͽQЭP̠QЭP̠QQP̭Pʏ  PPQЭPЬRRRPRQPQ{RPPQQP       w wFM_$INHIBIT  PFM_$SIGNAL  MEM @   1        7;M˓ V1.0                            /     LBV1.014-SEP-1990 13:22                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  	UUID_$NIL  
RPC_$DEBUG  LB_$PROCESS_ARGS_I  LB_$LOOKUP_RANGE  GLB_CA_$GET_OBJECT_UUID  GLB_CA_$SET_SHORT_TIMEOUT  GLB_CA_$LOOKUP  GLB_CA_$DELETE  GLB_CA_$INSERT  LLB_CA_$LOOKUP  LLB_CA_$DELETE  LLB_CA A   _$INSERT  UUID_$DECODE  VAXC$GPRINTF  MEMCPY  LLB_CA_$SET_SHORT_TIMEOUTl P@(#)lb.c	2.1     (ultrix)        6/13/89)P   mP i.;3wP
zP P333b91de0000.0d.00.00.87.84.00.00.00%P333b91de0000.0d.00.00.87.84.00.00.00JP333b91eb0000.0d.00.00.87.84.00.00.00oP333b91f70000.0d.00.00.87.84.00.00.00 P%s
  P< l^լ$RR$լ 	pRR ޼ S޼R(bcЬ S޼R(bЬ S޼R(b Ь R0RЬbݏ@   ݬЬ R4 MEMCPYЬ RtRЬbݬݬЬ Rx MEMCPY޼$R b B   ݬ$ݬ    LLB_CA_$INSERTլ$
޼$Rb!Ь Rˏ0RRݬ$ݬ  GLB_CA_$INSERTP  ^լPP޼P `ЬPˏ0PPݬݬ GLB_CA_$DELETEլ
޼P`Pݬݬ   LLB_CA_$DELETEP  ^լ(PP(լ ޭPP լޭPP޼P `޼(P `լ1ݬ(ݬ$ݬ ݬݬݬݬݬݬݬ
 LLB_CA_$LOOKUP'ݬ(ݬ$ݬ ݬݬݬݬݬ GLB_CA_$LOOKUP  ^ݬݬݬݬݬ   	UUID_$NIL 	UUID_$NIL   
 LB_$LOOKUP_RANGE  ^ݬ  C   ݬݬݬݬݬ 	UUID_$NIL 	UUID_$NIL 
  LB_$LOOKUP_RANGE  ^ݬݬݬݬݬ   	UUID_$NIL    	UUID_$NIL
 LB_$LOOKUP_RANGE  ^ݬݬݬݬݬ      	UUID_$NIL 	UUID_$NIL
 LB_$LOOKUP_RANGE  ^ݬ LLB_CA_$SET_SHORT_TIMEOUTݬ GLB_CA_$SET_SHORT_TIMEOUTPP  ^ RլPPլPPݬ GLB_CA_$GET_OBJECT_UUIDݬb UUID_$DECODEPPPPլ1yP޼Pް P`-1L޼P`P`QQ1 D   19QPP1 PZ?PPd   1 Pd    P?P1    R	    LB      lb_$register         lb_$unregister b     D  lb_$lookup_range        lb_$lookup_object <       lb_$lookup_object_local <     T  lb_$lookup_type <       lb_$lookup_interface <       lb_$use_short_timeouts         lb_$process_args_i       lb_$process_args )   		;-                                                                                                                                                                                                                                                           0                        5H        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        Ŀ      D        E       
M                  EXIT 
      < LB_$REGISTER 
       LB_$UNREGISTER 
  D    LB_$LOOKUP_RANGE 
      LB_$LOOKUP_OBJECT 
      LB_$LOOKUP_OBJECT_LOCAL 
  T    LB_$LOOKUP_TYPE 
      LB_$LOOKUP_INTERFACE 
      LB_$USE_SHORT_TIMEOUTS 
     LB_$PROCESS_ARGS_I 
     LB_$PROCESS_ARGS    $CODE    $DATA    ERRNO  F      
VAXC$ERRNO    STDIN    STDOUT    STDERR    $CHAR_STRING_CONSTANTSݬߢ% UUID_$DECODE1 PݬߢJ UUID_$DECODE1 Pݬߢo UUID_$DECODEsPݬ  VAXC$GPRINTF  EXIT޼P`P`PP >P 5PL   0PL   Pl   Pl   P 
RPC_$DEBUG
PPPPPPPPլ1 ^ R ݬݬݬݬ LB_$PROCESS_ARGS_I Pږ                  |  vPz   222222222222222     2 $        w wb VAXC$GPRINTF1PRP SETJMPPDPݠDͫ 
PFM_$_CLEANUPͫww  
RPC_$DEBUGw- VAXC$GPRINTF1Ĭ {Ĭ ݬ RPC_$SET_SHORT_TIMEOUT {߭߭ 	UUID_$NIL 	UUID_$NILĈ ݬ GLB_$CLIENT_EPV   3R	b{ PFM_$_RLS_CLEANUP޼R   | ^ V ƨ 
Ƅ PƄ ! 	UUID_$NILƈ  UUID_$EQUALP
ƈ L ƨ  ϲP)ưݬ޼Rb޼H     R^(bn PFM_$SIGNAL Ƅ Ƅ  RPC_$FREE_HANDLEЭRB$ SOCKET_$VALID_FAMILYP1PЭRB$ƈ  RPC_$ALLOC_HANDLEPƄ RR
Rb1]PƬ Ƭ Ƅ  RPC_$SET_SHORT_TIMEOUT򞭨SR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ) ƨ Rˏ  bRR  ^(n PFM_$SIGNALɞRb ?խЭRѭB$޼SRbcƄ  RPC_$FREE_HANDLE Ƅ ư 
Rb IưƄ  GLB_$CLIENT_EPV   3I     Rb-ЭRB$Ƅ  խ^(n PFM_$SIGNALƨ Rb 
   PFM_$ENABLE PFM_$_RLS_CLEANUPƨ =ư v   P  ^ P   P| ^ V 	UUID_$NILƈ  UUID_$EQUALٕP
ƈ լ
޼R(ƈ bP ^ R޼P `ݬ$Pݬݬݬ  RPC_$INQ_BINDINGP ^ R  GLB_CA_$GET_OBJECT_UUID ݬݬݬ  RPC_$SET_BINDINGPݬݬݬ  	RPC_$BINDP ޼P`¨ J     | ^ V ޼RЏ bݬ{P1 խ1 SR SETJMPPDRݢ  SOCKET_$VALID_FAMILY  UUID_$DECODE  LB_$LOOKUP_RANGE  RPC_$SET_SHORT_TIMEOUT  RPC_$FREE_HANDLE  	RPC_$BIND  RPC_$INQ_BINDING  RPC_$SET_BINDING  RPC_$ALLOC_HANDLE  VAXC$GPRINTF  STRLEN  STRCPY  SETJMP  LSEEK  READ  OPEN  ACCESS  OPEN  CLOSE  CLOSE  READ 
      GLB_CA_$SET_SHORT_TIMEOUT 
    | GLB_CA_$GET_OBJECT_UUID 
  (	   GLB_CA_$GETK     _SERVER_ADDRESS 
  d	   GLB_CA_$SET_SERVER_ADDRESS 
  
    GLB_CA_$INSERTC  R
    GLB      get_default_object p     p   has_server_list <        open_server_list      4  close_server_list 0     d  find_server_nbrd     h  
check_binding _       glb_ca_$set_short_timeout         glb_ca_$get_object_uuid =   !  (	  glb_ca_$get_server_address 9   !  d	  glb_ca_$set_server_address c     	  glb_regiL     ster_ops 	    
  glb_ca_$insert      
  glb_ca_$delete      D 
PFM_$_CLEANUPЭRb ) ƨ Rˏ  bRR  ^(n PFM_$SIGNALRb  Rb ݬݬƄ ޼RbRb 	  PFM_$ENABLE PFM_$_RLS_CLEANUPݬϤPխ1,P  ^ݬݬ GLB_$CLIENT_EPVP  ^ݬݬ GLB_$CLIENT_EPV   3ϿP| ^ V   ޼ RЏ b޼R b޼Rbƨ  ݬ P1kխ1cPSRM      SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ) ƨ Rˏ  bRR   ^(n PFM_$SIGNALRb  Rb 1  ЬЬѭ䏐  
ЭRRЏ  ЭRRݬ ݭ߭ݭ߭ݬݬݬƄ  GLB_$CLIENT_EPV   3R	bŭ   RRRRRíRRխխ1{P𞭐Rb   PFM_$ENABLEP PFM_$_RLS_CLEANUPݬ ϰPխ1խ!޼RЭb޼RЭbխݬݭ޼ Rb ޼Rb޼ R b `^ W N     V  Ьѭ1 ЭR>xR<bRRݭ SOCKET_$VALID_FAMILYP1 PRB A    glb_ca_$lookup     
  sort_entries M  		A                 	   	       O      	   	  :            
  
    GLB_CA_$DELETE 
    | GLB_CA_$LOOKUP  U  $CODE ,  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR k  $CHAR_STRING_CONSTANTSRRBư RBƴ   jݭ SOCKET_$FROM_NAMEխRB RB ЭRݢtЭRxRBư RbRBƴ  
SP     OCKET_$EQUALPDѭ4ŏ   R޼S( Bc`ŏ   R޼S( Bc( `RRRR   RRѭ1_        w w,Pݬ4>R<bSЬR<CRR SOCKET_$SET_PORTRRݏ     	RPC_$LOCK쐏ͺЭR. UUID_$EQUALӕPЭR(.ЭRNRbЬRFЭR UUID_$EQUALPЭS޼RѣBb+ЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЀSRRRRRRѬRR
ЭR>jR<bRʏQ     1        OG˓ V1.0                           /     LBV1.014-SEP-1990 12:42                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  	UUID_$NIL  GLB_$HANDLE  GLB_$UID  
GLB_$TYPE_UID  
RPC_$DEBUG  LB_$PROCESS_ARGS_I  LB_$LOOKUP_RANGE  GLB_CA_$GET_OBJECT_UUID  GLB_CA_$SET_SHORT_TIMEOUT  GLB_CA_$LOOKUP  GLB_CA_$DELETE  GLB_CA_$INSERT R      LLB_CA_$LOOKUP  LLB_CA_$DELETE  LLB_CA_$INSERT  UUID_$DECODE  VAXC$GPRINTF P@(#)lb.c	2.1     (ultrix)        6/13/89)P   mP i.;3wP
zP P333b91de0000.0d.00.00.87.84.00.00.00%P333b91de0000.0d.00.00.87.84.00.00.00JP333b91eb0000.0d.00.00.87.84.00.00.00oP333b91f70000.0d.00.00.87.84.00.00.00 P%s
  P< l^լ$RR$լ 	pRR ޼ S޼R(bcЬ S޼R(bЬ S޼R(b Ь R0RЬbݏ@   ݬЬ R4 MEMCPYЬ RtRЬbݬݬЬ Rx MEMCPY޼S     $R bݬ$ݬ    LLB_CA_$INSERTլ$
޼$Rb!Ь Rˏ0RRݬ$ݬ  GLB_CA_$INSERTP  ^լPP޼P `ЬPˏ0PPݬݬ GLB_CA_$DELETEլ
޼P`Pݬݬ   LLB_CA_$DELETEP  ^լ(PP(լ ޭPP լޭPP޼P `޼(P `լ1ݬ(ݬ$ݬ ݬݬݬݬݬݬݬ
 LLB_CA_$LOOKUP'ݬ(ݬ$ݬ ݬݬݬݬݬ GLB_CA_$LOOKUP  ^ݬݬݬݬݬ   	UUID_$NIL 	UUID_$NIL   
 LB_$LOOKUP_RANGE  ^                                                                                                                                                                                                                                                   1                        Wh        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                              S       T     ݬ ݬݬݬݬݬݬ 	UUID_$NIL 	UUID_$NIL 
  LB_$LOOKUP_RANGE  ^ݬݬݬݬݬ   	UUID_$NIL    	UUID_$NIL
 LB_$LOOKUP_RANGE  ^ݬݬݬݬݬ      	UUID_$NIL 	UUID_$NIL
 LB_$LOOKUP_RANGE  ^ݬ LLB_CA_$SET_SHORT_TIMEOUTݬ GLB_CA_$SET_SHORT_TIMEOUTPP  ^ RլPPլPPݬ GLB_CA_$GET_OBJECT_UUIDݬb UUID_$DECODEPPPPլ1yP޼Pް P`-1L޼P`PU     `QQ119QPP1 PZ?PPd   1 Pd    P?P1    R	    LB      lb_$register         lb_$unregister b     D  lb_$lookup_range        lb_$lookup_object <       lb_$lookup_object_local <     T  lb_$lookup_type <       lb_$lookup_interface <       lb_$use_short_timeouts         lb_$process_args_i       lb_$process_args )   		;-        V         
M               c  MEMCPY  LLB_CA_$SET_SHORT_TIMEOUT  EXIT 
      < LB_$REGISTER 
       LB_$UNREGISTER 
  D    LB_$LOOKUP_RANGE 
      LB_$LOOKUP_OBJECT 
      LB_$LOOKUP_OBJECT_LOCAL 
  T    LB_$LOOKUP_TYPE 
      LB_$LOOKUP_INTERFACE 
      LB_$USE_SHORT_TIMEOUTS 
     LB_$PROCESS_ARGS_I 
     LB_$PROCESS_ARW     GS    $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR    $CHAR_STRING_CONSTANTSݬߢ% UUID_$DECODE1 PݬߢJ UUID_$DECODE1 Pݬߢo UUID_$DECODEsPݬ  VAXC$GPRINTF  EXIT޼P`P`PP >P 5PL   0PL   Pl   Pl   P 
RPC_$DEBUG
PPPPPPPPլ1 ^ R ݬݬݬݬ LB_$PROCESS_ARGS_I Pږ                B      |  vPz   2222222222222222         w wjRSb#RRRЭRVRRRЭRVRbS#Rbc#Rb<RR.ЭTRRЭ  CLOSE_SOCKET  
SELECT_NCK  TIME  
SELECT_NCK  TIME 
      CONV_$WHO_ARE_YOU 
  H	    RPC_$GET_HANDLE 
      RPC_$ALLOC_HANDLE 
     RPC_$SET_BINDING 
  P
   RPC_$INQ_BINDING 
    < RPC_$INQ_OBJECT_CLIENT 
  0    RPC_$CLEAR_SERVER_BINDING 
      RPC_$CLEAR_BINDING 
      	RPC_$BIND 
  0    RPC_$SET_ Y   1        iG˓ V1.0                            0     LLBV1.014-SEP-1990 12:43                   VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  LLB_$CLIENT_EPV  LLB_$MANAGER_EPV  LLB_$SERVER_EPV  	UUID_$NIL  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$SET_WK_PORT  SOCKET_$VA Z   LID_FAMILIES  RPC_$SET_SHORT_TIMEOUT  RPC_$FREE_HANDLE  	RPC_$BIND  SETJMP  P@(#)llb.c	2.1     (ultrix)        6/13/89*P   nP i.;3xP
{P P    P  P  P 3;3 P
 P  P| ^ Vլ޼R(bЬ^P ݬ߭߭ SOCKET_$VALID_FAMILIES>Rbݬ߭<RR SOCKET_$INQ_MY_NETADDRݬݭ߭ SOCKET_$SET_NETADDRݬ ߭ SOCKET_$SET_WK_PORTݬݭ 	UUID_$NIL 	RPC_$BINDP޼Rb [     ݭ RPC_$SET_SHORT_TIMEOUTЭP  ^ P   P< ^ ݬݬݬPլ	޼Rb޼RЏ bSR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ;Rˏ  bRR  ^(n PFM_$SIGNALP޼SRbc  PFM_$ENABLE枭Rb ݬݬݭ LLB_$CLIENT_EPVRb PFM_$_RLS_CLEANUPݭ RPC_$FREE_HANDLE< ^ݬݬݬPլ	޼Rb޼RЏ bSR SETJMPPDRݢD \    
PFM_$_CLEANUPЭRb ;Rˏ  bRR  ^(n PFM_$SIGNALP޼SRbc   PFM_$ENABLE枭Rb ݬݬݭ LLB_$CLIENT_EPV   3Rb PFM_$_RLS_CLEANUPݭ RPC_$FREE_HANDLE< ^ ޼(RЏ b޼ R bݬݬPRR	RbSR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb 9Rˏ  bRR  ^(n PFM_$SIGNAL޼(SRbc  PFM_$ENABLERb }Ѭ
ЬRRЭݬ( ]   ݬ$߭ݭݬݬݬݬݭ LLB_$CLIENT_EPV   3R	b$0  RR$Ь ScRRcíRR޼Rb
լa  R
    LLB      get_binding          llb_ca_$set_short_timeout          llb_ca_$insert        llb_ca_$delete        llb_ca_$lookup   		7          θ  θ  κ      
       LLB_CA_$SET_SHORT_TIMEOUT      
     < LLB_CA_$INSERT 
    < LLB_CA_$DELETE 
    < LLB_CA_$LOOKUP  [  $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR` P PFM_$_RLS_CLEANUPݭ RPC_$FREE_HANDLE޼(Rb ޼ Rb޼(R b        w w       	  	    
  	      

Z
		      NNIK    LLB$  7G˓  SUKONNIK    SOCKET_INET! xI˓  SUKONNIK    RPC_UTIL p0I˓  SUKONNIK    U_PFM <!M˓  SUKONNIK    GLB };M˓  SUKONNIK    LB                                                                                                                                                                                                                                                                                                                                 `   1       ?˓ V1.0                            7     
RPC_SERVERV1.014-SEP-1990 11:40                    VAX C V3.1-051  P%W%   (ultrix)  %GP   WP v":3aP
dP P 96 @ P
 Pf P%s, %lu.%uPfrag(PPin_call_back,PPworking0P%Pin_reply4P%.Preplied8P.6Pidle<P6;Ppassive@P;CPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1xPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 PDUA0:[NC a   S_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 Pact->state == as_in_reply || act->state == as_repliedPDUA0:[NCS_VMS.DSSBUILD.NCK_ D.LIBNCK_D]RPC_SERVER.C;1MPact->state = as_repliedePDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1P(get_activity) Can't allocate slot
Pact->state == as_idlePDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1	Pact->state == as_passive"PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1WPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNC b   K_D]RPC_SERVER.C;1P(scan_activities) Freeing passive [%s]
P(scan_activities) Passivating idle [%s]
P(scan_activities) Dropping re ply [%s]
P(scan_activities) Retransmitting reply (state=%s) [%s]
<PRPC activity scannerQP(ping_common) Working (ptype=%s) [%s]
xP(ping_common) Resending reply (state=%s, ptype=%s, frag=%u) [%s]
P(ping_common) No call (state=%s, ptype=%s) [%s]
P(ping_common) Invalid activity state (state=%s, ptype=%s)
&Pinvalid activity state                                                                                                                                                                                                                                                   2                        -<        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                        M      b        c   =PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1rP(who_are_you) Doing callback
P(who_are_you) Can't bind to client, st=%08lx
PDUA 0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1P(who_are_you) fault, st=%08lx
PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1GP(who_are_you) who_are_you failed, st=%08lx
sP(do_request) Unknown interface [%s]
P(do_request) Opnum out of range [%s]
P(do_request) Got inappropriate request (state=%s) [%s]
P(do_re d   quest) Invalid state (state=%s) [%s]!PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1VP(do_request) couldn't get encr (status=%08lx)
P(do_requ est) couldn't decrypt pkt (status=%08lx)
P(do_request) Old sequence, previous=%ld [%s]
P(do_request) Protocol error [%s]
PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1<P(do_request) Fault while executing request, st=%08lx
rPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1P(do_ping) No call (no activity e    for this call) [%s]
P(do_ping) No call (higher numbered ping), ahint=%d, previous=%ld [%s]
"P(do_ping) Drop ping [%s]
<P(do_ack) No or incorrect ahint in    
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_T f   O_ASCII  
RPC_$STATS  
RPC_$DEBUG  
RPC_$LOSSY  RPC_$INT_LISTEN_DISPATCH  	RPC_$FREE  RPC_$MALLOC  RPC_$TERMINATION_FAULT  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$FILL_FRAG  RPC_$PERIODICALLY  RPC_$REASSEMBLE_FRAG_LIST  RPC_$INSERT_IN_FRAG_LIST  RPC_$FREE_FRAG_LIST  RPC_$SENDTO  RPC_$SET_PKT_BODY_ST  RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$DIE  RPC_$PRINTF  RPC_$INQ_OBJECT_CLIENT  UUID_$EQUAL  UUID_$ENCODE  	UUID_$G g   EN  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$FREE_HANDLE  	RPC_$BIND  SOCKET_$MAX_PKT_SIZE  ack, ahint=%d [%s]
rP(do_fack) No or incorrect ahint in fack, ahint=%d [%s]
P(do_fack) Anomalous fack, state=%s, prev_seq=%lu [%s]
P(do_quit) No call (no activity for this call) [%s]
	P(do_bad_pkt) Bad pkt, ptype=%s [%s]
:	P(rpc_$int_listen_dispatch) Trash ahint (%u)
g	P(rpc_$int_listen_dispatch) Trash ihint (%u)
	P(rpc_$int_listen_dispatch) Server boot time mismatch
	 h   PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1  P ^ Rݬ UUID_$ENCODE  PPP  ^ RЬP>LP<`PPЬPݠ@ЬP(P  
VAXC$GSPRINTF  PPP  ^ QЬP@(P  ^ЬPݬݬ RPC_$SET_PKT_BODY_STЬPJP` ݬ   RPC_$SENDTO| ^ VTD 	UUID_$GENT޼R(D < ^ЬRТѽ޼RЏ b P޼SЭR(c޼UЭRТ TЭSgRRg@gRReݬЭRݢ$ЭR(ЭR  R  	RPC_$ i   BINDPP  ^ݬB ^ R ޼P ` f<Pď`   P@¿ PPЭPW
Э/PЬPFЭPF UUID_$EQUALP޼Pѽ`ЭPPխE<PP ޼PЏ ` PQPP<QPď`   P@¿ PPЭP WP| ^ Vݏp  ߦC 	RPC_$LOCKݬݬPխ RPC_$UNLOCKЭRW1ЭRVЭRѢXP޼RЏ
 b RPC_$UNLOCK0ЭRWЭR V޼R(V bЭRЬXЭR\R bЭS\RR\ RPC_$UNLOCK| ^  j   Vݏ  ߦx 	RPC_$LOCKݬݬ2Pխ RPC_$UNLOCKЭRW1ЭRVЭRѢXP޼RЏ
 b   RPC_$UNLOCK.ЭRWЭRV޼R(V bЭRЬXЭR \ RPC_$MALLOCP޼R(bЭRЬЭSЭRТ\ЭRЭ\  RPC_$UNLOCK ^ R X<Pď`   P@¿ PPЭPW)޼P`ЭPF UUID_$EQUALʕPѽ<PPPPPЏ  PP ^ R S޼P `ݏ  ­  	RPC_$LOCK޼P`ЬPF@P  k   RPC_$UNLOCK޼PЏ `<Pď`   P@ÿ PPЭPV$ЭQ\PP\>\P<`PPЭP WP RPC_$UNLOCK  ^լ2P޼P`  R    
RPC_SERVER      	uidstring (     (   uidseqstring P     x   
state_name         send_rejection @        get_my_activity 0   #     rpc_$server_to_client_handle        rpc_$get_my_activity        find_ifrgy_slot      l  
rpc_$register      0  rpc_$register_mgr      l      find_interface y       rpc_$unregister      L  find_mgr_epv C       rpc_$register_object d     ޼P` UUID_$EQUALוP	ЬPРPЬPРլ2  P| ^ V<RR@   ޼RЏ bSRR<SR RBƿRR޼R(bЭS޼R(b޼R b| ^ V޼Rb 	UUID_$NIL UUID_$EQUALP޼R( 	UUID_$NILbЏ   P PP<R RBƿRR޼Rb UUID_$EQUALЕP޼SЭR(cЏ   PRR޼R( 	UUID_$NILb m   2  P  ^ЬPՠ<ЬPݠ< 
RPC_$FREE_PKTЬP <޼P   ^ SЬP<PP޼P`
޼P`P!Pݏ     _ASSERT  ABORTЬP>(P<`PP SOCKET_$MAX_PKT_SIZEP   PPЬPՠpЬPްpP`PàPPЭPѠbЬP``"Pݏ  eM _ASSERT  ABORTнRЭP>QJPa`ЬPݠpЬP$ݽݬ RPC_$SENDTOЭP>P` ЬPk	P癭PPݭ<PPЭPݠݽ RPC_$FILL_FRAGP<Q<PPQP	 琭 n   PP항PPЬPݠpЬP$ݬ RPC_$SENDTOPPPP1j޼P`  ^ЬPf P ^ S <RRԏ   jP<P@F޼Rb<P@P UUID_$EQUALP&<P@R  TIMEPQPQ`<PPPPP<PP   Џ  P ^ W VЬRHЬRHBЬR>HR<bRB0ЬR(ЬR>HR<bRBR UUID_$EQUALP<RRPЬR(P챭<RRP <RR   SP<RBDP<RBRb<RBRb o   <RRRRRR<RR   <RR   Jǚ RPC_$PRINTFЏ  P,2RBRb2RR]2RR!<Rݏt     RPC_$MALLOCPЭBЭSЬR((ЭRЏЭR <ЭRЬ8ЭR FЭR fЭTЬRRʏRSRSSkЭR lЭR pЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR1PЭTRRЭSRRcdRR<RRЭR  TIMEPSRSb<RRP ^ R<P@<P @ 	RPC_$FREE ^ V  p   W<RBѽ!Pݏv  ƾ _ASSERT  ABORT<R RPC_$MALLOCPЭBЭSЭR(ЭSЭRТЭR  TIMEPSRSbЭRբpЭRݢpЭR޲pRbR޲RbЭR pЭRբlЭRݢlЭR޲lRbR޲RbЭR l 	RPC_$FREE $^ V W<RBѽ!Pݏ  "	 _ASSERT  ABORT<Rݏt    RPC_$MALLOCPЭBݏt    ݭ MEMSETЭSЭR(ЭSЭRТЭRЬ8ЭR lЭR pЬRRRЭR$RRRЭR q   $RbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RRЭR  TIMEPSRSbݭ 	RPC_$FREEP  ^ S Rݏ  W 	RPC_$LOCK  TIMEP\\ <\\   1[P<\Lխ1-Э\ì\\\\нPP P	R?P1 ,4 
RPC_$DEBUGPЭ\+PÌ RPC_$PRINTF<\\ϼ1 -2 
RPC_$DEBUGЭ\Pô RPC_$PRINTF<\\ϰ1 2 
RPC_$DEBUGЭ\ݬ<P RPC_$                                                                                                                                                                                                                                                   3                        0        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        `U      q        r   PRINTFݭ7F 
RPC_$DEBUG*PЭ\ݬ<ϧPݽP RPC_$PRINTFݭЭ\ݬ8\\<\\   1   RPC_$UNLOCK ^ R<4\\ RPC_$PERIODICALLY ^ R޼QaPP  P	?P1M 
RPC_$DEBUG2PݬPЬPPPPP 
RPC_$PKT_NAMEPQ RPC_$PRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTO1/ 
RPC_$DEBUGOPݬPЬP>DP<`PPЬPPPPP 
RPC_$PKT_NAMEP޼P`ϚPx s    RPC_$PRINTFݬݬ1 P 
RPC_$DEBUGAPݬPЬPPPPP 
RPC_$PKT_NAMEP޼P`<Pº RPC_$PRINTFЬP  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  _ASSERT  
VAXC$GSPRINTF  MEMSET  MEMCPY  SETJMP  ABORT  TIME  TIME  TIME  ABORT  TIME  ABORT  TIME  TIME  TIME  TIME  TIME  TIME  TIME 
     < RPC_$SERVER_TO_CLIENT_HANDLE 
      RPC_$GET_MY_ACTIVITY 
  l  | 
RPC_$ t   REGISTER 
  0  | RPC_$REGISTER_MGR 
     RPC_$UNREGISTER 
    | RPC_$REGISTER_OBJECT 
     RPC_$START_ACTIVITY_SCANNER PJP ` ݬݬݬ RPC_$SENDTOMPЬPPPPP 
RPC_$PKT_NAMEP޼P`P RPC_$PRINTFݏL  =& RPC_$DIE ^ЬЭPРЭPѠ
 kѽeЭP(PPЬ޼QЭPޠ$P`aЭP>$P`<PP/ЭRPPЭQPPabRR<RR޼R b< ^ U T 
RPC_$DEBUGPr RPC_$PRINTFݬ u   ЬPݠ$ЬP( 	UUID_$NIL 	RPC_$BINDP޼Rb% 
RPC_$DEBUG޼RbŐ RPC_$PRINTF޼Rb޼Rb޼Rb  RPC_$UNLOCK޼SRP SETJMPPDPݠD 
PFM_$_CLEANUPЭc޼Rb V ݬbݏ  ž 	RPC_$LOCK޼RЭb  PFM_$ENABLE 
RPC_$DEBUGP޼Rb RPC_$PRINTF1 Pݏ   ݬլcMլHѬ   >ЬP@3ЬSݬ߭ЬPݭЬP@RbPlP޼RЏ b&Pݬ߭ЬPݭ v    CONV_$CLIENT_EPVP` ݬqݏ   	RPC_$LOCK޼RЭb PFM_$_RLS_CLEANUP޼RbЬQPP      inq_object_type        
free_reply 0       
send_reply       set_act_quitable        
find_activity      D	  get_activity h      
free_activity 0       passivate_activity        activate_activity H       scan_activities   "    rpc_$start_activity_scanner $   w        ping_common       rpc_$get_callers_addr      X  who_are_you L      handle_request_frag     
RPC_$DEBUGP޼RbG RPC_$PRINTF RPC_$FREE_HANDLE| ^ VЬRRR<RBЭRFRRЭRRRR ЭRRʏRR	RRRR ЭSЭRТ@ݬݭ RPC_$INSERT_IN_FRAG_LIST敭"޼SЭRޢRbcݭ RPC_$REASSEMBLE_FRAG_LISTPP[PI(P R	R bRbЭR>SRcb x   ЭRݢpݬݬ RPC_$SENDTO޼R b PP< ^޼RbPP  P"?P^PЬRF RPC_$FREE_FRAG_LIST޼RbDЬRf' ݬ PЏ^(n PFM_$SIGNALPݬcPP Μ^ V WЬRRR ЭRRʏRSRSSЭRRʏRSRSSЭRRʏRSRSSЭRFЭRݢ<ЭRAPPЭR>FRbDЭR<Rď`   RB UUID_$EQUALەP <Rď`   RBǿ SЭRc<EP 
RPC_$DEBUGPݭ y   Ps RPC_$PRINTFƕݬݭݏ ݬЭS<Rď`   RBRDbA 
RPC_$DEBUGݭ{PƘ RPC_$PRINTFꕭݬݭݏ  ϷЭRFRbЭR>FR<bRď`   RBǿ RRݬݬݭ1PЭRHRb<RBѽѽ	ѽoѽЭRТRRЭRТRRЭԭЭRѢ@4 
RPC_$DEBUG&PݭϗPݽPƾ RPC_$PRINTFPݭѽݬݬ<RRPѽLѽFսAݭ6PݽzP 
VAXC$GSPR z   INTFݏ  ! RPC_$DIEЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR.ЭTRRЭSRRАcdRR<RRЭRЬ8SЭR EЭSЭRТ@ЭRNRRݭρխݬݭݭݬϟЭRբl1ЭRբp^ЭSЭRݢlЭR޲lR޲ R RbPpխ2 
RPC_$DEBUGPݭV RPC_$PRINTFݬݭݭݬ'ЭRNSЭR޲pR޲ RSbݬݭݏ ݬYSЭRRRRxRRRRR cYSЭRRRRcYSЗRRRR {   YRR bЭR@ݬЭR>JR<bSЭRCP^(YnЭRݢpЭR޲pRbR޲RbխT 
RPC_$DEBUGPݭƅ RPC_$PRINTF޼RbЬR^(nݬݭݭݬЭSЭRѣ@. 
RPC_$DEBUG#PݭsPЭRݢƷ RPC_$PRINTFЭSЭRѣ@?ս:ѽݬݭݭݬݬݭݏ ݬvս"ЭSЭRѣ@ЭRF RPC_$FREE_FRAG_LISTSЭSЭRRѣ@R@ 
RPC_$DEBUGݭϻP RPC_$PRINTFݬݭݏ  |   ݬЭRRʏRR/߭ݬ<RRݬݬPխͰЭR>JR<bRR ͰݭϣЭSЭRТ@ЭRgR bЭRЭ ЭRVϥ  RPC_$UNLOCKЬR>R<bRR SOCKET_$MAX_PKT_SIZEP   PPЭRբpЭR޲pRbRâRR䰏P ͦͨRЏ
 bЭͬ ͱ ] UYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR b^S^R SETJMPPD^^RݢD 
PFM_$_CLEANUPѭ 1 ЭU ݭUݏx   }    	RPC_$LOCK  PFM_$ENABLE 
RPC_$DEBUGP^(Un< RPC_$PRINTFޞͲRRܕ^(Un RPC_$TERMINATION_FAULTPPЏ P URRݭݭ RPC_$SET_PKT_BODY_ST1 
RPC_$STATS   3RR 
RPC_$STATS   3ݏ   ݭϡЭRVPͱ߭߭^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbR
b1 ЭRϊЭRݢ\PխЏ ^(n PFM_$SIGNALͱ߭߭ݭ^(Ynݏ  ͲݭݭͦЭ ~   R>DR<bSЭR޲XRCbRb ݭϥݏ  r 	RPC_$LOCKѭ9ͱݭ 
RPC_$FREE_PKTͲRRݏ ݭ RPC_$SET_PKT_BODY_STPRѭRR]^ PFM_$_RLS_CLEANUPЭR <1(P ЭRHRbЭRLR bЭR ЭRܢ?]9ЭR <ЭRJRbЭRݢpݬݭݬ RPC_$SENDTO1 PЭЭR@RЭbЭRբpЭR޲pRbRĢRRЭRݭ RPC_$ALLOC_PKTP<P   RRݭЭRݢ< MEMCPYĕ]	PЭЭ    RDR bݭݬ;Ͱݭ 
RPC_$FREE_PKTЭR  TIMEPSRSbͱݭ 
RPC_$FREE_PKTЭR  )U#ˏ  URR  ^(Un PFM_$SIGNAL^(Un   RPC_$TERMINATION_FAULTP^(Un PFM_$SIGNAL ^ T SЬPHЬRЬP(\枢HQPaЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P UUID_$EQUALPO 
RPC_$DEBUGPݬkPħ RPC_$PRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTOЬP>HP<`P@    ЭR  TIMEPQPQ`ЬQЭPѡ@e 
RPC_$DEBUG1PݬPЭPݠЬP>HP<`PP RPC_$PRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTOЬQЭPѡ@ݬ ݬݭݬ@ 
RPC_$DEBUGݬ[P" RPC_$PRINTFP ^ T SЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P UUID_$EQUALP4 
RPC_$DEBUG(PݬPЬP>HP<`PP< RPC_$PRINTFЬP>HP<`P@ЭR  TIMEPQPQ`ѽЬQЭPѡ                                                                                                                                                                                                                                                   4                        ϒ=        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                                         @	ݭ ^ T SЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P UUID_$EQUALP4 
RPC_$DEBUG(PݬPЬP>HP<`PPr RPC_$PRINTFЬP>HP<`P@ ЭR  TIMEPQPQ`ѽЬQЭPѡ@9 
RPC_$DEBUG.PݬϋPЭPݠݽPĪ RPC_$PRINTFЬP>LP<`RRЭP>DP<`PRPЭRЬP>LP<`PPPPQDPQ`ݭݬP ^ T SЬPHЬRЬP(x➢HQPaЬPH=ЬP>HP<`P@+ЬP(Ь    P>HP<`P@P UUID_$EQUALPO 
RPC_$DEBUGPݬχP RPC_$PRINTFЬPЬPJP ` ݬݬݬ RPC_$SENDTOЬP>HP<`P@ЭR  TIMEPQPQ`ЬP
ЬP JP ` ݬݬݬ RPC_$SENDTOݭς ^ R 
RPC_$DEBUG2PݬPЬPPPPP 
RPC_$PKT_NAMEP	 RPC_$PRINTFP |^ V WЬRRR޼R bЭR>HR<bRR   >ЭRH2 
RPC_$DEBUGPЭR>HR<bRR:	 RPC_$PRINTF޼RЏ     bЭR>FR<bRR <ЭRF0 
RPC_$DEBUGЭR>FR<bRRg	 RPC_$PRINTF޼RЏ bЬRRޭRЬb<RR.ЭTRRЭSRRcdRR<RR  TIMEPRRЭRբ8>Э RѢ82 
RPC_$DEBUGPƔ	 RPC_$PRINTFݭݏ ݬϘЭR8RbݏL	  	 	RPC_$LOCK޼TSR SETJMPPDRݢD 
PFM_$_CLEANUPЭd޼Rb  RPC_$UNLOCK޼R^(bn PFM_$SIGNALЭRRRRRխݬݬ    ϡPݭݬ<RBXRbլ6ЭRNR 
RPC_$ENCR_RGYSBc"ݬЭRNR 
RPC_$ENCR_RGYSBcR޲Rb  ͎ PFM_$_RLS_CLEANUP RPC_$UNLOCK< ^Ь SR SETJMPPD RݢD 
PFM_$_CLEANUPЭѭ խݭ RPC_$FREE_LINKED_PKT^(n PFM_$SIGNALЭR>JR<bRRݭ RPC_$ALLOC_LINKED_PKTPݬݬݬݬݭݬ RPC_$INT_LISTEN_DISPATCHݭ RPC_$FREE_LINKED_PKTݬ PFM_$_RLS_CLEANUP  ^     QPPP< ^ЬЭRѢݬݬݬ RPC_$INQ_OBJECT_CLIENT6PЭRТѽ޼RЏ b޼SЭRТ R(c޼R b  ^޼P `ЬPРѽ޼PЏ ` PЭPՠl޼PЏ `ЭPРlPP  ^    
quit_activity      D  
do_request     ("  do_ping   
  #  do_ack      $  do_fack R    &  do_quit +    8'  
do_bad_pkt I     '  rpc_$int_listen_dispatch     *  rpc_$listen_dispatch          *  rpc_$set_fault_mode $      +  rpc_$inq_object d     d+  rpc_$inq_sauth J     +  rpc_$set_server_encr U     ,  rpc_$inq_server_encr 6     @,  rpc_$register_authtype h       ,  rpc_$set_auth_logger      ,  rrpc_$inq_interfaces    		R       
 
!               
	      	   

 	   

         
        	 	             
         
      
 	       
   
  	                      	   		 		  	 	
   	    P `ЬPРѽ
޼PЏ `,ЭPՠpЭPݠpЭPްpP`PްP`ЭPЬpP  ^޼P `ЬPРѽ޼PЏ ` P	ЭPРpPP ^ RѬ   ޼PЏ `+ݏ    RPC_$MALLOCP ЭP @   ЬPЬ@޼    P     ^ P | ^ V ޼R bm޼RbcP<Rď`   RB.ЬScTcRRcďV   T޼S<Rď`   R(V Bƿ DcRR޼RbPЬScRRc޼R b P 4 4 h h t t  P i      P  W  \P (" 8' 8'  
  	    	6   		 
     RPC_$GET_CALLERS_ADDR 
  '   RPC_$INT_LISTEN_DISPATCH 
  *  < RPC_$LISTEN_DISP     ATCH 
  *    RPC_$SET_FAULT_MODE 
   +  < RPC_$INQ_OBJECT 
  d+    RPC_$INQ_SAUTH 
  +    RPC_$SET_SERVER_ENCR 
  ,    RPC_$INQ_SERVER_ENCR 
  @,   RPC_$REGISTER_AUTHTYPE 
  ,    RPC_$SET_AUTH_LOGGER 
  ,  | RRPC_$INQ_INTERFACES  [-  $CODE   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR 	  $CHAR_STRING_CONSTANTS$  8' 8' 8' # & $ 8'        w w                                                                       1       B?˓ V1.0                            4     RPC_LSNV1.014-SEP-1990 11:42                   VAX C V3.1-051  P%W%   (ultrix)  %GP   WP v":3aP
dP P 96 @ P
 Pf PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;12P(use_family) Can't create socket
TP(use_family) Can't bind socket, errno=%d
~P(rpc_$use_family) Can't getsockname, errno=%d
 P(rpc_$use_family) Can't get my netaddr
 P(check_for_pkt_common) Rcvd (ptype=%s)
 P(listen)     Spurious quit_activity fault ignored
,P(listen) Exiting, st=%08lx
HP(await_pkt) select failed: %d, errno=%d
qPwhich < n_   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  
RPC_$STATS  
RPC_$DEBU    G  
RPC_$LOSSY  
RPC_$SHUTDOWN  RPC_$TERMINATION_FAULT  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$PERIODICALLY  RPC_$SENDTO  
RPC_$RECVFROM  RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$PRINTF  RPC_$START_ACTIVITY_SCANNER  RPC_$INT_LISTEN_DISPATCH  UUID_$EQUAL  RPC_$LISTEN_DISPATCH  
RPC_$REGISTER  SOCKET_$SET_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$MAX_PKT_SIZE  SOCKET_$SET_PORT  
PFM_$_CLEANUP  PFM_$_RESET_CLEANUP  PFM_$_R    LS_CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  _ASSERT  MEMSET  MEMCPYsocketsPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1PRPC packet checker  P ^ R T S޼P `ݏ   b 	RPC_$LOCK  RPC_$UNLOCK޼PЏ ` ݬ SOCKETPխ. RPC_$UNLOCK 
RPC_$DEBUGPߢ2 RPC_$PRINTF޼PЏ `ݭ SET_SOCKET_NON_BLOCKING ݬ MEMSET޼P`լ                                                                                                                                                                                                                                                   5                        ɖ        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                                         ݬݬݬݬ SOCKET_$SET_PORTݬݭ BINDP;   
RPC_$DEBUGdߢT RPC_$PRINTFd0
޼PЏ `޼PЏ `1 P߭ݬݭ GETSOCKNAMEP) 
RPC_$DEBUGPdߢ~ RPC_$PRINTF޼PЏ `1 ޼PЭ`ݬ߭ݬ SOCKET_$INQ_MY_NETADDR޼P` 
RPC_$DEBUGP­  RPC_$PRINTFQPݬݭݬݬ SOCKET_$SET_NETADDR2 PP@ÿ PPЭ PP  RPC_$UNLOCK޼P ` RPC_$UNLOCK CLOSE_SOCKET      ^ݬݬݬ ݬP  ^ݬݬݬЬQЬP<APPݬϖ|  ^ Vݬݬݏ   ݬݬ 
RPC_$RECVFROMPխ PzЬRRʏRRgЬR(  UUID_$EQUALPOЬR @CЬR L7ЬRЬRЬRЬR޼R( b ЬRRʏRR1 ЬЬRRʏRR=ЭR(P ЭR(( ЭRޢ@Rb ЭR>LS Rcb PЬSЭRdЬSЭReЬSЭRfЬSЭRg޼SЭR(Pc ЬR>JRb<RR2<UЬT<SЭRChEP    RRRR<RRЏ   PP< (^Ь޼$R bݬݭݬ"P޼$RЏ bRRЬ޼RЭbڭ<RR.ЭTRRЭSRRcdRR<RR޼SЭRRRRRRRc޼SЭR(c޼ SЭR(  < ΰ^Ьݬ޼R<bRR SOCKET_$MAX_PKT_SIZEP   PP(P RRЭR,ЭR-ЭR.ЭR/ЬRRRЬb<RR.ЭTRRЭSRRcdRR<RRЬ͸RRʹRЬb<RR0PЭTRRЭSRRcdRR    <RRЭR>JR<bRRRBЭR>JR<bRRRRЭRP0 MEMCPY ʹݬ  RPC_$SENDTOEPRRR b ʹݬ RPC_$SENDTO ʹݭݬ RPC_$SENDTO| ^ V S <T2 RRRTR1 P<PP@ÿ R bT޼U<PP@ÿ Rz  bP{ PQPPRxRRRRRDeRR1 ߭<PP@ÿ RbSPnPRRRR^ 
RPC_$DEBUG&PRRRR 
RPC_$PKT_NAMEP  RPC_$PRINTFݭ<PP@ÿ Rb RPC_$LISTEN_D    ISPATCH١RR<P2 RRRPR1P  ^ S< RR  MEMSET <T2 RRRTRU<\\Lÿ \ lRT<\\Lÿ \z  lP{ PQPP\x\\Bd\\Bd\\<P2 \\\P\R\ Ьb  ݏ@    
SELECT_NCKPխ< RRP T^ V W \zSzR SETJMPPDzzRݢDn 
PFM_$_CLEANUPnѭ* 
RPC_$DEBUG  RPC_$PRINTFz PFM_$_RESET_CLEANUPVPѭ Jխ'^(n RPC_    $TERMINATION_FAULTP^(n, RPC_$PRINTFխ^(n PFM_$SIGNAL  PFM_$ENABLE   r MEMSET <S2 RRRSRd<RRB̿ RbRR	RR SrTz  P{ PQPPRxRRCdRRCdRR<S2 RRRSR RR    rݭ 
SELECT_NCKP RR խ)g 
RPC_$DEBUGPgݭH RPC_$PRINTF1]P 2 RѭRURB̿ R bSrTRB̿ Rz  bP{ PQPPRxRRRRRCdRRPRR2 RѭR2 RѭR"Pݏ      ƃq _ASSERT  ABORTRB̿ RRխݏ       RPC_$ALLOC_LINKED_PKTP ߭ЭRݽ5PzPݭݭݭݽ RPC_$INT_LISTEN_DISPATCHЭR>R<bRR?ݏ  Ƶ 	RPC_$LOCKЭR>R<bRRݭ RPC_$FREE_LINKED_PKT  RPC_$UNLOCK 1I 1z PFM_$_RLS_CLEANUP ^ S RѬ	ЬPPЭ      4ݬ RRPC_$SERVER_EPVi 
RPC_$REGISTER  RPC_$START_ACTIVITY_SCANN    ERqPP RPC_$PERIODICALLY䐏  ;޼P     ^ P   R    RPC_LSN      
use_family         rpc_$use_family      @  rpc_$use_family_wk +     l  
s_recv_pkt     $  rpc_$listen_recv        rpc_$forward       check_for_pkt_common %      
check_for_pkt        rlisten H      rpc_$listen      \  
rpc_$shutdown    !  x  rpc_$allow_remote_shutdown             rrpc_$shutdown L       rrpc_$are_you_there        rrpc_$inq_stats    		Q          


     
	 خ  
  Թ8        
     		   SETJMP  GETSOCKNAME  BIND  SOCKET  CLOSE_SOCKET  SET_SOCKET_NON_BLOCKING  
SELECT_NCK  ABORT  
SELECT_NCK 
       RPC_$USE_FAMILY 
  @    RPC_$USE_FAMILY_WK 
  $  < RPC_$LISTEN_RECV 
    < RPC_$FORWARD 
     RPC_$LISTEN 
  \    
RPC_$SHUTDOWN 
  x    RPC_$ALLOW_REMOTE_SHUTDOWN 
     RRPC_$SHUTDOWN 
      RRPC_$ARE_YOU_THERE 
      RRPC_$INQ_STATS  
      $CODE   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT/     STDERR   $CHAR_STRING_CONSTANTS  ޼Q     ^ Q޼P ` Ь  ^ R  ݬݬ PP޼PЏ `Pݬ 
RPC_$SHUTDOWN  ^޼P     ^Ѭ޼P 
RPC_$STATS   3`޼P `ѬЬP 
RPC_$STATS   3޼P`ѬЬP 
RPC_$STATS   3޼P`ѬЬP 
RPC_$STATS޼P`ѬЬP 
RPC_$STATSh   3޼P`ѬЬP 
RPC_$STA     TSl   3޼P`޼P `         w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   1       K C˓ V1.0                            0     VMSV1.014-SEP-1990 12:10                   VAX C V3.1-051   R
    VMS
      ffs \     \   	_findchan H        gettimeofday G   		     +      
CC$_GFLOAT 
 ,   TIMEZONE 
 0   DAYLIGHT  FFS  FTIME 
        FFS 
  \    	_FINDCHAN 
      GETTIMEOFDAY     $CODE 4   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT         STDERR ( P@(#)vms.c	2.1	VMS/ULTRIX Connection	6/29/89  P  ^ЬխЏP ѭˏPP&xPPPPѭˏPPЭP ^ ЭP޼Q@a$ŭ RЭP޼Q@a FFSPRRЭP?ʘ P ^ R FTIME޼PЭ`ЬQ>P<`PPPP޼Q<,PPaЬPТ0        w w_myOС ?	????
???????????????????PP??????P ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#    1       *4G˓ V1.0                           ?7     
RPC_CLIENTV1.014-SEP-1990 12:38                 Y  VAX C V3.1-051  P%W%   (ultrix)  %GP   \P v":3fP
iP P 96 @ P
 Pf P PRan out of socketsPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2HP(alloc_socket) Can't create socket, errno=%d
vP(alloc_socket) Can't bind socket, errno=%d
 P(send_pkt) cannot enable broadcast, status=%08lx
 PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CL                                                                                                                                                                                                                                                   6                        _c        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        *                 IENT.C;2	P(send_pkt) cannot enable broadcast, errno=%d
7PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2lPDUA0:[NCS_VMS .DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2P(c_recv_pkt) Rcvd callback (ptype=%s)
PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2P(c_recv_pkt) Rcvd packet not for my activity
+P(c_recv_pkt) Rcvd packet with bad seq (should be %lu, is %lu; ptype=%s)
tPCan't register callPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2PDUA0:[N    CS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2P(ack_replies) Acking [%s, %lu]
P(ack_replies) Can't send ACK, errno=%d
:PRPC reply a cknowledgerQPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2P(await_reply) timeout
P(await_reply) select failed, errno=%d
P(await_reply) timeout (EINTR)
P(await_reply) select returned junk, errno=%d
PDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2FP(rpc_$sar) can't get encr, status=%08lx
oP(rpc_$sar) Anomolous     response to request (ptype=%s)
P(rpc_$sar) Starting to ping
Pselect failedPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2P(rp   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  
RPC_    $STATS  
RPC_$DEBUG  
RPC_$LOSSY  RPC_$FREE_HANDLE  RPC_$CLEAR_BINDING  RPC_$CLEAR_SERVER_BINDING  RPC_$SET_BINDING  RPC_$ALLOC_HANDLE  	RPC_$FREE  RPC_$MALLOC  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_LINKED_PKT  RPC_$FILL_FRAG  RPC_$STOP_PERIODIC  RPC_$PERIODICALLY  RPC_$REASSEMBLE_FRAG_LIST  RPC_$INSERT_IN_FRAG_LIST  RPC_$SENDTO  
RPC_$RECVFROM  RPC_$GET_PKT_BODY_ST  RPC_$UNLOCK  	RPC_$LOCK  
RPC_$PKT_NAME  RPC_$DIE  RPC_$PRINTF  RPC_    $GET_CALLERS_ADDR  RPC_$SERVER_TO_CLIENT_HANDLE  RPC_$GET_MY_ACTIVITY  RPC_$INQ_SERVER_ENCR  RPC_$SET_SERVER_ENCR  UUID_$EQUAL  UUID_$ENCODE  RPC_$LISTEN_DISPATCH  RPC_$FREE_HANDLE  RPC_$CLEAR_BINDING  
RPC_$REGISTER  SOCKET_$INQ_BROAD_ADDRS  SOCKET_$MAX_PKT_SIZE  SOCKET_$TO_NAME  SOCKET_$FROM_NAME  SOCKET_$SET_WK_PORT  SOCKET_$SET_PORT  SOCKET_$INQ_PORT  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$ENABLE  PFM_$INHIBIT  PFM_$SIGNAL  MEM    SET  SETJMP  SLEEP  
SETSOCKOPT  BIND  SOCKET  SET_SOCKET_NON_BLOCKINGc_$sar) Too many pings...signaling
+P(rpc_$sar) Anomolous response to ping (ptype=%s)
]Pselect failedkPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2P(rpc_$sar) Rcvd "working" during frag send!
P(rpc_$sar) Rcvd "working" pkt; seq=%lu
P(rpc_$sar) Got "fack" for non-large request!
#P(rpc_$sar) Got non-frag "response" during frag recv!
  P 4^ S R޼P `     >P<P	P@ PPЭPѠ
ЭPPP<PP@   ݏ4  ߣcP RPC_$DIE ݬ SOCKETPխ, 
RPC_$DEBUG ߣH RPC_$PRINTF޼PЏ ` P  MEMSETݭ BINDP7 
RPC_$DEBUG ߣv RPC_$PRINTFݭ CLOSE_SOCKET޼PЏ ` Pݭ SET_SOCKET_NON_BLOCKINGQPP<QP	P@ PPЭPЭЭP<QPQ P  ^޼P   | ^ V <RR 1 P, 	    UUID_$NIL<R.RB UUID_$EQUALؕP
<RRRRPЬR(<R.RBL UUID_$EQUALP0ЬS<R.RB+Rѣ@b<T.TЬRޢ@SD+RcbRR<RR 1g1 2S.SЬR((C2T.TЬRޢ@SD+Rcb2T.TЬR>HSD/Rcb2T.TЬRޢ8SD1RcbЬRRR2R.RBRRR2R.RBRbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RR @^ S xt  RPC_$UNLOCK啬%ݬݬݬЬRݢ RPC_$SENDTO̐Pc1P_x    |c_޼RbЬR SOCKET_$INQ_PORTPЬR>R<bRR SOCKET_$INQ_BROAD_ADDRS_6 
RPC_$DEBUG_â  RPC_$PRINTFݏ     	RPC_$LOCK P  t ݏ  ЬRݢ 
SETSOCKOPTPpp7 
RPC_$DEBUG 	 RPC_$PRINTFݏ  7  	RPC_$LOCK P c f<fRRx1 P<fRRBcPPlOPPhKQ<fRB|P`a<fP@|R>bP`d<dPP7hRhPPhlQlPPlabdPPd<dPPݬKݬЬR    ݢ RPC_$SENDTOˈcPPcfPPf<fPPx1=ݏ  l   	RPC_$LOCKcRRP <^ W Vݬ ݬݬЬRݢ 
RPC_$RECVFROMPխ P޼RbЬR( UUID_$EQUALƐPЬRRRRRЬRRRRR1 ^ЬR UUID_$EQUALP1   RPC_$UNLOCKЬRѢ@ЬR@RR 
RPC_$DEBUG&PЬRRRRR 
RPC_$PKT_NAMEPǡ RPC_$PRINTFݭ޼ RbݬЬRݢ RPC_$LISTEN_DISPATCHݏN    	RPC_$LOCK P     
RPC_$DEBUG
 RPC_$PRINTF PЬRѢ@MЬRѢ@< 
RPC_$DEBUG2PЬRRRRR 
RPC_$PKT_NAMEPЬRݢ@ݬ+ RPC_$PRINTF PЬRբ>&ЬSЬRѣ>8Џ ^(n PFM_$SIGNALRRRЬRRR޼RbSRbcRb<RR1PЭTRRЭSRRcdRR<RRЏ   P ^ W V <RR s<RRBS<RRB<SS޼R(bC<RRBRЬb<RRBRЬb<RRBRRPRR<RR ݏ  ǈ    t RPC_$DIE ^ R <PP SP<PP@0޼P`<PP@ UUID_$EQUALP<PP@PPPPP<PP 2  P  ^޼P `ݬwPխ޼PЏ `ЭPРPՠ>ЭPРP>PЬ`PЭPЄPѠ>޼PЏ	 `޼QЭPޠP`   ^ݬPխ޼PЏ ` ޼P `ЭPРP< ^ݏP    ݬ MEMSETЬR RPC_$LOCAL_DREP_PACKEDЬR RPC_$LOCAL_DREP_PACKED   3ЬR RPC_$LOCAL_DREP_PACKED   3ЬR RPC_$LOCAL_DREP_PACKED       3޼RbЬRFRbЬRHRbլ
ЬS޼R(bP l^ V W \ݏ#  ƽ  	RPC_$LOCK۰ <RR 1,P<R.RBRR 	UUID_$NIL UUID_$EQUALP1 Pu UUID_$ENCODE 
RPC_$DEBUGPЭRݢ$u RPC_$PRINTFЭR>R<bRR@Pխ1  ϬRЭRޢ*SRcb(ЭR>(SRcbЭRޢ$SRcb  ЭRݭP 
RPC_$DEBUGg RPC_$PRINTFݭ,( 	UUID_$NILRR<    RR 1  RPC_$UNLOCKP ^ S R    CONV_$SERVER_EPV 
RPC_$REGISTERݕ#  :2PP RPC_$PERIODICALLYP  ^޼P `ݏ    RPC_$MALLOCPP ЭPPЏ`ЭPlP`ЭPZP`ЭPVP`ЭPjP `ЭP  ЭP  լЭPjQjPQ`ݬЭPݭ RPC_$CLEAR_BINDINGP ^Ьݬݬ RPC_$CLEAR_BINDINGЬЭPZPPЭPVPЬ`<PP/ЭRPPЭQPPabRR<R    RЭRjPjRPbݬЭRݢVЭRZ SOCKET_$INQ_PORTPЭRjPj   R    
RPC_CLIENT      alloc_socket       free_socket        
update_ack_db     ,  send_pkt 7    d  
c_recv_pkt G      
register_call      X  	find_call s       conv_$who_are_you x     D	  rpc_$get_handle ?     	  init_hdr ~     
  ack_replies y      init ^       rpc_$alloc_handle                                                                                                                                                                                                                                                         7                           hؕ                                                                                            ;1                                                                                                                        q               i    Zz~J4b&h@ɲ
$8ĵ,EwWʠ%	Eٳ*hFJ	dt(W:Ζot00oڎ9	LM̖7"V#0{Yw>+ʋh,2lK!+/Nu9E'wFԹچEz6].' 3CzzD$Li8z4zej3Mv% $x~}xd\3)wt1Pب+uw|nhQmaS'?$f@,5 @jӮ	 MjX dS~[!65\O#כ۠AM[I]
Z0O]uHq<|dxsaS!Ow_|">#tײ"#H[V|Aȼ
֓Rf    7#+~
%uSbMVx0uh~w'+k׸WE3<]/v	f̉d3Hky(?Ņt0)u _Q6$	Pc^*c=|2>#ػ+RT:\(^(,Ԏێ>.CQ'A%9)+ @/I\Gdơ[I\ʩJQ!sTR8rӮ`x΢%+h7oşN'^˹	J ^NLSJXlnmһsP숋6d
эiZͪkҠOQ)ti;
I&P;
+u1eb0e7%uh
n̒l! N&PB}#d֥\ʹ_Պ a1@5Ac?@
|lvۜD'%G/	g    vo32
⢿\d]f`K~
؜ή)*hթyA5
YkX:k|_e$@wT2JYlw҅
-|<1龂寍'ycTIaBfa5,it*4bIu	`{?
s!
_xs ruA#>VfhD(ptg}"Z?q1vkqԲ	E(S^-}		<l#>G~Q2noB4ɥTra;͏-L8Ͷn>Js 
!$WzߐxS5ݙ~ؘq
[ᔠYIXBGB Bp@)hĞ㕏Ś
Zl82!5]:/]g_h=/QӬ课ttt    
~FJ䉰+$0d[y+u!&T=Jdje$UQd~F%AGHQDLe+!k&fN"hu>JYkdTǴ7d*,kᴔn4n
qS?$2y޴yb[	rDro,ցY=H;ӈH"kG 2e:I6t=Is~Ne9&u6	h)ZL8d_	<{-?4Z瑭Q%,R0d$?^!{I
B)Q9({Zj1J
JӗH[K!Ӥ֬;D9b?C
%cu//pU^`^hg0|RE-.\FnڒW-n縲V@泳8Ǥ#ۨWvb{VB.{RW\oP\B=4G4:   x-NNۙ߃)fFEuzfc;ۖH3҉
r*=̢*(YG;#_SȤ6_(PHW} ×K^gkycxm8a[+%C3$ޢP[dS57-9Ӊ-IF<r7BT94:JhioP
( >ʄJzmϪ`
H~fbbJQy]\1Dx	 Xz2kT,fke3ڤÞ*(նc@`:Kı`UMvzT2y	TR)QOC׷~!u,#1ܹ(Rp@y.cx]6pAEϤXAUx!5
:Ok$fZQo,rG
2̉B}/ڌ)ÖIpN^r2v9
ZHNO.CGrn2ޭc\    0bF1(t=KdKN6+3\ƈ3Eiëcsv_fќiT5ɌE[d֭;տݢ^$H/Dd*baB
OF"==~>X4Ս̞o5Er5uCr	P,_*91RR4	c
J>tf[ XY#ڮ"L(
tl?O,jpW9VYw̶G_PJ%R{Wuc͸ʾ-OL2rK։FaO
>}m],WF,]!
CwiBL m,X0qZC$ŧSP{Ч[oU
~ڕ]:Rՙxi$W#6:Q99KHU&nK$#O1<H$mɉ<'?ƙZ"Ȥ팓pZg=j,5nh[[DM!ȹ'(iz y)Dz    ̍8YO
1b6"!^v
h&MKcD +W;N_svH
۽M7({l^`u&Z'69cJ)$[.uS9AH͟tEJYoqc@8y{)~Ƽ	ӊ0yWJ	Rxɩ"bΫQy75d'R HG(\`exp-˯6n V4P1WHH*n.-o#B;E6zmэO^+
l-pK;_\e8e*4"yPFJ6_@	gK*	N?N`nytԙla!^t(,Zsd,@Sp'C|	* ">2{:8T_[Q~z7TGZ7ޠ&8}"˄դ2sşB N    mE\5?ݧ]MnPseL(dI"@1Zs?1<|Rѷz] KT+EOD_bШlUG_#R6Ϡ-j~0{si N;XLL\Qc˞sי~JtF[#R/4}o3xR÷o5~:8>jE62<v1)SYN7B-w5;Y@֙:w/c0mtklN[1H	_ءVyHʟPSM&'ƍftPR6]ZPP'/hnI6H:}q!T猳6oK!z@}!tӿڽD{5|wF(_NÍD.47NF]sB94es86쑟#UѸxc蠍N\$NfQIx@    2 mt?\6}SU|Kexc ^RGDŃ^[{q%8Rjx&m8ሔF\5F|ٹ>3гb*ۡ(.RT.+&/Y:*۠I?%;uÓUfmKN_3aB] ;,9.[\VXUæNR8
ZL=r%䞸׵b%& ;HFe*ʈfi78}5JuY["ZUE`u,N)WŖL!R.TފS,YZ!ұ4Y´~ȃB urOQnQ&B̒uhR*'FhcVY{wEqq|٣;iq:r:R]I`zNQJ@Ȯpc~ozS.GbEqZ    vY, XMD>[6K)@k@(V`9u.2k-fWgI甖;3fH#!9s?nl4
撽zy7}!SAYWRM;e|V*4f[:K牫XL5<-^Bc:TZĹ/TK~=et@MJ$L]ek`/vM~}Ԡ&~נ^oˀۨ2bDwװ
.:NK?0w'-kU:GMY"Zq#i{REsЋVy	S=.&Dttl8(YfȍhR['[B7^fWw/IbC$S>e8Ǎ
ujA3"·ZFWr	ۘaނ]5ҟkb5+7pWinۨ5qׅ{\@59O 9vK/Y b   0e#J|EGƅ|N߁T{=W{JT9G&EB49
ĪuOl'z/8 ->\{?R!㹦D085A	0JeY$=wҐcftυ0d^f.pbu[8MlC,\qxڣTIެXDl򆨾Y =d[&5]ToK'
a<̋+c݀n0d>^ʭ8'@\xv6UD'񸻷850
7uK'H{⻦>}a>.1iə8cdJ$tY[A+<EC V!D3y2:HATQw'1G@nUڒ`u,`>|\ay:]PfyOsdJ]+3[SF t   u)ъȯ.xgoRR&ۂ̊ՂC,4C=]{aTUϐTԯ(T]DY3ܷ];}
*42\<m[<0lQ'{$?)&go"b5@91_a1r$&2uoM!+fOtsH`۲8:a]Lrw"bǢN
61v/2Bks7f|{>w0jogw$F<6!穈gIhEK@i"[TEY	@XvAKbJZ0B )f	ΥH~h:_1f[*^xY+@T`0Ekp#n_4kJDo ^"_;c:
YM%U]UO/)Η[^,2%W$!t
5D	-˫2%1I;<	<^dh6v    mjtw!p{<ftm*xKU擷$!&)ǯw $x-wں7jټ.J>o;kZfXA)oy7+4@۱Igې]r=pe|0E6nMZ$Ikyj0
;-W/EfEq|`:J* gYNM`ia?`[nnܫ.)j(-Z?-0\WmSJF
աA95&QӅ>o[inp	>Õ 7UZ'wg0O`VElՃH(^3^tm
a).j08K	ʢjIbmڦ109ˀ3}y[׈0Ѷj	'F88]~?ίe׻I?[!{	a+v'WChʜ0՘.	pw ;   E+whL=-Om4}ۨˌdT.QG5@@?:=8ku5t`9C]t.2vs[+/Zض>VgXr+j,fx*i:MxN丄`VӦzBmbNk>>|g7l\4 r.J.>D8Qw&:p6k܉ކv4[Bk%E
1OAQ'F3t]CtK;n1%`i2rk%ΝFqx&;VqJW?+P'ux웎AZ
6 u˞ܲ:5K7hksÿ`@k umuS)55XѰ/`\$q}a.Hw`HmXDU
Qz#R]k4r*9d<R,"s ^   54=].ZvNGٙy!x"ΌFѴ4K^O-7mvΨ۴-<0mrAD+5e9ܶ)<ђud2v`tngؼgR z:AܷrHB̂Dh*4լ3ZN!Bh(lWN.`{\ƊzNGg=?8c.J]\*g ՔcŐ$֢:e1Tb̈́K*JY#h@p"#/H;|Rr
,`R]I-Y#'3ܛK`}J/`X(dM ;zZ	VzlhA0d;PdЎ= _aYhluޑ֖P^?Z:r(>\=޺&q*2^	2OyƯ|u^XXHy]+h-j-~2z                                                                                                                                                                                                                                                    8                        C        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                                           rpc_$set_binding      L
  rpc_$inq_binding        rpc_$inq_ RPb޼R    ^ЬЭPѠ1 ЭP>jP<`PʏPP޼PЏ `ЭPZPPЬ޼QЭPޠVP`aЭP>VP`<PP1PЭRPPЭQPPabRR<RRݬݬݬ RPC_$GET_CALLERS_ADDR޼R  < ^Ь޼SЭR(c޼R    ^Ьݬ ЭPVЭPZ SOCKET_$SET_PORTЭPjQjPQ`ЭP>P `ЭPLP`ЭPNP`޼P     ^Ьݬݬ RPC_$CLEAR_SERV    ER_BINDINGЭPjQjPQ`޼P     ^ݬ޼P<`PPݬ RPC_$ALLOC_HANDLEP޼P`ݬݬݬݭ RPC_$SET_BINDING޼P`ݭ RPC_$FREE_HANDLE P  ^ЬЭP>jP<`PʏPQPQQլЭPjQjPQ`ЭPjQjPQ`޼P `PPP  ^ QPլPP   ^Ь޼P `ЭQlPPl>lP<`PPxЭPPЏ`ЭP ЭP ЭPЄ P`PްP`ЭP  ЭP ЭP ЭPЀ P`PްP`ЭP  ݭ 	RPC_$FREEP  ^Ь޼P `Э    QlPPlЬP< 8^ U  TIMEPRRR  RPC_$UNLOCKЬ   MEMSETЬR STЬRz  P{ PQPPRxRRCdRRCd  ЬRRR 
SELECT_NCKP ݏ  Q  	RPC_$LOCKЭPP 5P	?P1  P 
RPC_$DEBUGPņ RPC_$PRINTFPѭ 
RPC_$DEBUGݭŝ RPC_$PRINTF  TIMEPRRѭ  
RPC_$DEBUGP RPC_$PRINTFPPíRR1P RPC_$PRINTF2 P< ^  5  SR SETJMPPDRݢD 
PFM_$_CLEANUPѭ 1\  PFM_$ENABLE޼R(P bRRRR b   MEMSETЬR STЬRz  P{ PQPPRxRRCdRRCd <RR1 ЬR  ݬRݬb  ЬRRR 
SELECT_NCKPj߭ݬzݭݏT   ݬݬHP<RRRRR
'RRRRRRRRRRPPRR<RR1; PFM_$_RLS_CLEANUP  PFM_$INHIBIT
P  PFM_$INHIBIT    1        P<@˓ V1.0                            3     SOCKETV1.014-SEP-1990 11:48                    VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  INET_$SOCKET_HANDLER  SOCKET_$FAMILY_TO_NAME  SOCKET_$FAMILY_FROM_NAME  SOCKET_$SET_PORT  SOCKET_$INQ_PORT  SOCKET_$VALID_FAMILY  SOCKET_$INQ_BROAD_ADDRS  SOCKET_$INQ_HOSTID  SOCKET_$SET_NETADDR  SOCKET_$INQ_NETADDR  SOCKET_$INQ_MY_NETADDR  SOCKET_$INQ_POR    T  
VAXC$GSPRINTF  MEMSET  MEMCMP  STRLEN  STRCHR  STRNCMP  STRNCPY   P@(#)socket.c	2.1     (ultrix)        6/13/898P INET_$SOCKET_HANDLER PddsPipPns
PunspecPunspecPipPnsPdds"P%s:#%s)P%s:%s/P%s:#%s  P  ^ Qլ#Ѭ
2P@0޼P `Џ   PP޼PЏ
 ` P ^ R޼P `  ޼Pѭ`޼PЏ `)P2PP@0ЭP޼Q@aPP
޼P   ^ S޼P `޼R޼Pb` Pݬ޼P<`PP SOCKET_$V    ALID_FAMILYP1PˏPPKݬݬݬݬݬ޼P<`PPP2PP@0Pް0P`P޼P`1Z P P1ˏPPwݬ߭ݬݬ SOCKET_$INQ_NETADDR޼P`1ݬ߭ݬݬ SOCKET_$INQ_NETADDR޼P`1 Pѭݭ MEMCMPP P1 ˏPPsݬ߭ݬݬ SOCKET_$INQ_HOSTID޼P`1 ݬ߭ݬݬ SOCKET_$INQ_HOSTID޼P`nPѭݭ MEMCMPP PˏPP2ݬݬݬ SOCKET_$INQ_PORTPR    ݬݬݬ SOCKET_$INQ_PORTRP PЏ   P޼P ` Ѭ ݬݬݬ MEMCMPP	PP겐PPPPP ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILY˕Pݬݬݬ޼P<`PPP2PP@0Pް P`PP ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYÕP޼P`ݬݬݬݬ޼P<`PPP2PP@0PްP  ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYÕP޼P`ݬݬݬݬ޼P<`PPP2PP@0PްP  ^ R޼P `ݬbݬ STRNCMPP
Pݬߢݬ ST    RNCMPPPݬߢݬ STRNCMPPPݬߢ
ݬ STRNCMPP P޼PЏ
   ЏP ^  RЬPP 
 P
P^?P2PޢPP2PޢPP&PޢPPPޢPPP޼PЏ
 `޼P`ݭݬ STRNCPYݭ STRLENP޼Pѭ`޼PЭ`޼P   ^ R޼P`Ѭ  ޼PЏ `ݏ  ݬ STRNCPYЬP @PPլg:ݬ STRCHRPխ޼PЏ ` ݬìPPݬ SOCKET_$FAMILY_FROM_NAMEP޼P`ìPPPPP    PPݬݬ SOCKET_$VALID_FAMILYP޼P`ݏ[   ݬ STRCHRPխЬT ݏ]   PP   STRCHRPխ޼PЏ ` PP ATOIPPPìPP޼P`PPV޼P`PQP#QQ	PPݬݬݬݭPPݬݬ2P@0PްP`Oݬ߭ݬ SOCKET_$INQ_MY_NETADDRݬݭݬݬ SOCKET_$SET_NETADDRݬݭݬݬ SOCKET_$SET_PORT ^ T SЏd   Џd   ݬ޼P<`PP SOCKET_$VALID_FAMILYPݬ    ߭(޼P<`PP SOCKET_$FAMILY_TO_NAME޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`Э P @߭(ߤ" 
VAXC$GSPRINTF޼P`ݬ STRNCPY STRLENP޼P`޼Rݬ STRLENPPPb޼Rݬݬ  SOCKET_$INQ_PORTP   ^ T SЏd   Џd   ݬ޼P<`PP SOCKET_$VALID_FAMILYPݬ߭(޼P<`PP SOCKET_$FAMILY_TO_NAME޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`'    P @߭(ߤ) 
VAXC$GSPRINTF[Pݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`ЭP @߭(ߤ/   R
    SOCKET      socket_$valid_family D     D   socket_$valid_families h        
socket_$equal (      socket_$inq_port P     $  socket_$set_port X     |  socket_$set_wk_port X       socket_$family_from_name      h  socket_$family_to_name      $  socket_$from_name     (      socket_$to_numeric_name ,    T  socket_$to_name     	  socket_$set_broadcast p     L
  socket_$max_pkt_size  
VAXC$GSPRINTF޼P`ݬ STRNCPY STRLENP޼P`޼Rݬ STRLENPPPb޼Rݬݬ  SOCKET_$INQ_PORTP  <  ^ݬ޼Rbݬ SOCKET_$INQ_PORTP޼Rbݬ߭߭߭ݭ޼R<bRR SOCKET_$INQ_BROAD_ADDRS޼Rb޼R(b޼SޭRb  ^ Rݬݬ SOCKET_$VALID_FAMILYՕPݬݬ2P    @0P P  PP ^ Rݬݬ SOCKET_$VALID_FAMILYP޼P` ݬ MEMSET޼P`ݬݬݬݬ2P@0P P     ATOI 
        SOCKET_$VALID_FAMILY 
  D    SOCKET_$VALID_FAMILIES 
      
SOCKET_$EQUAL 
     SOCKET_$INQ_PORT 
  $   SOCKET_$SET_PORT 
  |   SOCKET_$SET_WK_PORT 
     SOCKET_$FAMILY_FROM_NAME 
  h   SOCKET_$FAMILY_TO_NAME 
  $   SOCKET_$FROM_NAME 
  (   SOCKET_$TO_NUMERIC_NAME 
  T   SOCKET_$TO_NAME 
  	      < SOCKET_$SET_BROADCAST 
  L
   SOCKET_$MAX_PKT_SIZE 
  
   SOCKET_$INQ_MY_NETADDR 
  
   SOCKET_$INQ_NETADDR  ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYP޼P` ݬ MEMSET޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@0Pް P  ^ R޼Q޼P`a޼P`ݬ޼P<`PP SOCKET_$VALID_FAMILYŕPݬݬݬݬݬ޼P<`PPP2PP@0Pް$P   ^ Rݬ޼P<`PP SOCKET_$VALID_FAMILYP޼P` ݬ MEMSET޼Q޼P`aݬݬݬݬݬ                                                                                                                                                                                                                                                   9                        PD        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                                         ޼P<`PPP2PP@0Pް(P  ^ R޼Q޼P`a޼P`ݬ޼P<`PP SOCKET_$VALID_FAMILYPݬݬݬݬݬ޼P<`P  @     
  socket_$inq_my_netaddr d     
  socket_$inq_netaddr x     h  socket_$set_netaddr h       socket_$inq_hostid x     H  socket_$set_hostid h       socket_$inq_broad_addrs L       socket_$to_local_rep T     P
  socket_$from_local_rep K   		9              	          
           I 
  h   SOCKET_$SET_NETADDR 
     SOCKET_$INQ_HOSTID 
  H   SOCKET_$SET_HOSTID 
         SOCKET_$INQ_BROAD_ADDRS 
     SOCKET_$TO_LOCAL_REP 
  P
   SOCKET_$FROM_LOCAL_REP  
  $CODE h   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR 6   $CHAR_STRING_CONSTANTS ]PP2PP@0Pް,P   ^ Rݬݬ SOCKET_$VALID_FAMILYɕPݬݬݬݬݬݬ2P@0P4 P   ^ RЬݬ޼P<`PP SOCKET_$VALID_FAMILY̕Pݬݭݬ޼P<`PPP2PP@0P8 P   ^ RЬݬ<PP SOCKET_$VALID_FAMIL     YؕPݬݭݬ<PPP2PP@0Pް<P` |P, \ 8 \ \ \ D \ \ \ \ \ \ P          w w                                                                                                                                                                                                                                                                                                                                                                                                                                 1       G˓ V1.0                            8     SOCKET_INETV1.014-SEP-1990 12:44                   VAX C V3.1-051  P@(#)socket_inet.c	2.7     (ultrix)        12/21/89 P(socket_inet/set interface broadcast address):   P< $^޼R( bݏi ݬ IOCTLP PRSRS3SRRRRPP< $^޼R( bݏi ݬ IOCTLP PRSRS3SRRRRPP< $^޼R( bݏ
i ݬ IOCTLP P>R<bRSRSSRRP< $^޼R( bݬݬYP%ݬݬ    PݬݬPP Pݏi ݬ IOCTLP PRSRS3SRRRRP  ^ݬ 
GETHOSTBYNAMEPխЏ PЭPްP`P  ^߬ 
GETHOSTBYADDRPխ PP  ^ЬѬ޼PЏ`ЭP> P<  PP NTOHSPPPP ^Ь޼P`޼PЏ`޼P `ЭRݬ HTONSPQPQ` ^Ь޼P`޼PЏ`޼P `Ѭ (Ѭ  ЭRݏ    HTONSPQPQ`PP |^ЬѬd   ޼PЏ `޼P `޼P` ݭ MEMSET    ٰݬݬݬݭݬݬ߭ STRNCPYЬP @4߭ 	INET_ADDRPѭ޼PЏ `ЭPPЭ`1 ߭PЭP   R    SOCKET_INET      is_loopback_interface F     H   is_up_interface F        is_inet_interface D        is_broadcast_interface      T  
hostbyname 4       
hostbyaddr ,       inet_$inq_port <       inet_$set_port @     0  inet_$set_wk_port U       inet_$from    _name l      inet_$to_numeric_name      x  
inet_$to_name      $  inet_$max_pkt_size      <  inet_$inq_my_netadd P޼PЏ `ޭPPޭPPЭRPPЭQPPabЭQRRЭPRR`aЭQRRЭPRR`aЭQRRЭPRR`aЭRRЭb޼R  < ^ЬѬ޼RЏbЭR^(n 	INET_NTOAP޼Rݭ STRLENPbP޼RЏ bݭݬ STRCPY޼Sݬ STRLENPRRc޼R     ^ЬѬ޼P    Џ`޼P `ЭPՠ$޼P`ݬ GETHOSTNAMEP޼PЏ `8ЭPݠϳPխ޼PЏ `޼P`ݭݬ STRNCPYݬ STRLENP޼Pѭ` ޼PЭ`P  ^޼P   Џ   P  ^ ЬP MEMSET޼P`  SOCKETPѭ޼PЏ `Џ   PPݏiݭ IOCTLPݭ CLOSE_SOCKET޼PЏ ` PPPPխ1 ݭݭKP_ݭݭςPNݭݭP=ѭ7ЭPPPЭPР߭ЬP ME    MCPY޼P `P PPPPխ1vݭ CLOSE_SOCKET޼P     ^ЬЭPРѬ޼PЏ`޼P `޼P`߭ P  MEMCPY  ^Ь Ѭ޼PЏ`޼P `޼P`ЬP߭ MEMCPYЭPP    ^ЬЭPРѬ޼PЏ`޼P `޼P`߭ P  MEMCPY  ^ЬѬ޼PЏ`޼P `޼P`ЬP߭ MEMCPYЭPP    <^ЬЬѬ޼PЏ`Ѭ޼PЏ`ݬݭ MEMCPYݬݭ ME    1    
   @T M˓ V1.0                            0     GLBV1.014-SEP-1990 13:21                   VAX C V3.1-051  P@(#)glb.c	2.2     (ultrix)        11/15/89+P   oP i.;3yP
|PPő;3P
PPޑ;3P
PP Prpc$exe:glb_obj.txtPrpc$exe:glb_sites.'Prpc$exe:glb_sites.:PCan't open '%s', errno=%d
UPrpc$exe:glb_sites.hP(find_server_nbrd) Error reading '%s', errno=%d
 Prpc$exe:glb_sites. P(find_server_nbrd) Error reading '%s    ' - file is empty
 Prpc$exe:glb_sites. P(find_server_nbrd) no more potential sites
"P(find_server_nbrd) trying site  '%s'
GP(find_server_nbrd) error converting to sockaddr (0x%lx)
P(find_server_nbrd) family mismatch '%s' (%d) and %d
P(find_server_nbrd) '%s' LLB lookup failure (0x%lx)
P(find_server_nbrd) '%s' LLB doesn't have a GLB registered (0x%lx)
,P(find_server_nbrd) LLB lookup result %d, invalid family (%d)
jP(find_server_nbrd) LLB doesn't have GLB registe    red with valid family
P'couldn't convert name'P(find_server_nbrd) GLB registered at '%s[%ld]'
P(find_server_nbrd) couldn'   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV  	UUID_$NIL 
    GLB_$HANDLE 
    GLB_$UID 
    
GLB_$TYPE_UID 
   GLB_$DEFAULT_OBJ 
   GLB_$DEFAULT_TYPE  
RPC_$DEBUG  GLB_CA_$GET_OBJECT_UUID  UUID_$EQUAL  
PFM_$_CLEANUP  PFM_$_RLS_    CLEANUP  PFM_$ENABLE  PFM_$SIGNAL  SOCKET_$TO_NAME  SOCKET_$FROM_NAME  
SOCKET_$EQUALt set glb binding (0x%lx)
-P(find_server_nbrd) RPC runtime failure on glb lookup(0x%lx)
$P
        P| 4^ VЏ    OPENPѭ*%߭ݭ READP%ݬ߭ UUID_$DECODEխ
޼R(Ɛb ^ R ߢ ACCESSP	P \\P ^ S R޼P `´´ CLOSEЏ´ ¸ ߣ' OPENP´´    ) 
RPC_$DEBUG ߣUߣ: VAXC$GPRINTF޼PЏ `  ^ \̴̴ CLOSEЏ  < h^ U S T 쐏 ĸ   LSEEKݏd   Ĵ READPѭ
cPѭ' 
RPC_$DEBUGcř ߥh VAXC$GPRINTF޼RЏ bխB1 
RPC_$DEBUG Ŭ  VAXC$GPRINTFP 
RPC_$DEBUG  VAXC$GPRINTF޼RЏ b PPͯPPЭRPPRM
GPЭRPPЭQPPܐabĸPP                                                                                                                                                                                                                                                   :                                RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        @              7  ĸЭQPPQ
PÐ ѭĸPPĸͯPP#ͯPPͯPP 1  
RPC_$DEBUGͯ" VAXC$GPRINTFݬ߭ ͯ STRLENPRRͯ  SOCKET_$FROM_NAME޼Rb 
RPC_$DEBUG޼RbG VAXC$GPRINTF1"<RR* 
RPC_$DEBUGݬ<RRͯŀ VAXC$GPRINTF1P 	UUID_$NILĈ  UUID_$EQUAL̕P
Ĉ ? ݬ߭ ߭ݭq 	UUID_$NILĈ 
 LB_$LOOKUP_RANGE޼Rb$ 
RPC_$DEBUG޼Rbͯ    1    (   VI˓ V1.0                            5     RPC_UTILV1.014-SEP-1990 12:52                   VAX C V3.1-051   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV  
RPC_$ENCR_RGY  	UUID_$NIL  RPC_$LOCAL_DREP_PACKED  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  
RPC_$STATS  
RPC_$DEBUG  
    RPC_$LOSSY 
   OLD_ALARM_HANDLER 
   
RPC_$ENCR_RGY 
   	UUID_$NIL 
   RPC_$LOCAL_DREP_PACKED  P%W%   (ultrix)  %GP   WP v":3aP
dP P 96 @ P
 PfP P     !P     %P7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????PP??????P ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#     1       /H@˓ V1.0                            4     RPC_SEQV1.014-SEP-1990 11:50                   VAX C V3.1-051   R    RPC_SEQ =    
CC$_GFLOAT      $CODE .   $DATA    RPC_$SEQ 7  P@(#)rpc_seq.c	2.1     (ultrix)        6/13/89  P    w w                                                                                                                                                                                                                                   1        [Y@˓ V1.0                            2     ERRORV1.014-SEP-1990 11:50                   VAX C V3.1-051  P@(#)error.c	2.1     (ultrix)        6/13/89 Prpc$exe:rpc$stcode.dbPstatus %lx!Pstatus %lx (%s)1Pstatus %lx (%s/%s)DP%s (%s/%s)  P ^ ޼P`KPPѭ;PЬRPPЬQPPab޼RbRRѭ޼R b <^ˏ   PP޼P `P `޼P `ޭR   OPENPbխޭP` READP1ޭP`WޭQޭPa    ޭPWޭPWޭQޭPޭPWP`VQPaPVPVQPPVѭ1PЏ  xPʏ  PPPP 찏 2PP1խ1 ,ݏ   ޭP` READP   1P 2PP@P`U2PP@Q2PP@Pa2PP@PU2PP@P`T2PP@Q2PP@Pa2PP@PT2PP@PT2PP@Q2PP@P2PP@PT2PP@P`2PP@P`2Qʏ Q2PP    @P2`Pʏ PQP2PP@P`PP졭PP2PP	խ1}ѭ1P ݭޭP` LSEEKݏ   XޭP`  READ>XP`S>XQ>XPa>XPSZP`RZQZPaZPRݬ\ݬQխ1ݬ͜ݬ6ˏ  PPPPX
Z1 Xݏ   XޭP` READ #P2P@X	PP=  谭걭 \PPP2PP	޼P ``ЬQPP2P@Xa2P@X
޼P `5PP걭 ݏ       XޭP` READ 1vPޭPݠ  CLOSE| ^ Vݏd   ݏd   4ݏd   ߭^(n ERROR_$C_GET_TEXTޭRbݬe  R    ERROR      xstrcpy d     d   error_$c_get_text       
error_$c_text        error_$find_text    		E
      Z        #
        
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII 
 ,   ERROR_$FIND_TEXT_STATIC  ERROR_$C_GET_TEXT  
VAXC$GSPRINTF  STRLEN  LSEEK  CLOSE  READ  OPEN 
  d    ERROR_$C_GET_TEXT 
    | 
ERROR_$C_TEXT 
    | ERROR_$FIND_TEXT  Z  $CODE X  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR O   $CHAR_STRING_CONSTANTSyݬ 
VAXC$GSPRINTFlP4Rb߭ݬߦ!ݬ 
VAXC$GSPRINTF     GPRb4߭ݬߦ1ݬ 
VAXC$GSPRINTF4߭ߦDݬ 
VAXC$GSPRINTF P| ^ Vݏd    ݏd   Ɛ ݏd   ߦ,޼R^(bn ERROR_$C_GET_TEXT޼Sަ,RRc޼SƐ RRc޼S RRc޼Sߦ, STRLENPRRc޼SƐ  STRLENPRRc޼S  STRLENPRRc         w w                                                                                                                                                                                                 MCPY޼P `Pݠ NTOHLPPPPݠ NTOHLPPPˏPP'ˏPPˏ Qˏ PQP1 ˏ?PP   .ˏ?PP   ˏ  Qˏ  P QPGPˏ?PP   .ˏ?PP   ˏ   Qˏ   PQPP ːPPPPP| ΰ^ V޼Rb޼RЏ b  SOCKETPѭ޼RЏ bЏ   RRݏiݭ IOCTLPݭ CLOSE_SOCKET޼RЏ b RR RRխ1 ޼Rѭb1 S޼RCbRR(     ͼݭݭPѭP1 ЭR޼SBcRbЭRݬ HTONSPSRSbͼݏi ݭ IOCTLPf PERROR0RRЭRЭR MEMCPYRR r T      inet_$inq_netaddr L       inet_$set_netaddr P     ,  inet_$inq_hostid L     x  inet_$set_hostid P       inet_$eq_network T    	  inet_$inq_broad_addrs     
  inet_$to_local_rep <       inet_$from_local_rep <   		%          /	        #       	
      _   
CC$_GFLOAT      RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  INET_$SOCKET_HANDLER 
 3   INET_$SOCKET_HANDLER  
GETHOSTBYNAME  
GETHOSTBYADDR  	INET_NTOA  	INET_ADDR  GETHOSTNAME  SOCKET  PERROR  MEMSET  MEMCPY  STRLEN  STRNCPY  STRCPY  IOCTL  IOCTL  IOCTL  IOCTL  NTOHS  HTONS  HTONS  CLOSE_SOCKET  IOCTL  NTOHL  HTONS  CLOSE_SOCKET  IOCTL  X  $CODE s   $DATA    ERRNO    
VAXC$ERRNOL     STDIN         STDOUT    STDERR 0   $CHAR_STRING_CONSTANTS&P RRRRխ
޼Rѭb1޼RЭb޼R b CLOSE_SOCKET ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ3P   0   x $ <   , x  	 
         w w VAXC$GPRINTFP 
RPC_$DEBUG  VAXC$GPRINTF޼RЏ b PPͯPPЭRPPRM
GPЭRPPЭQP                                                                                                                                                                                                                                                   ;                                RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                        5f                 @'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[???????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????012 3456789|????? P(rpc) *** FATAL ERROR "%s" at %s\%d ***
)Prequest P)1Pping$P16Presponse(P6?Pfault,P?EPworking0PEMPnocall4PMTPreject8PT[Pack<P[_Pquit@P_dPfackDPdiPquackHPioPBOGUS PACKET TYPE P(rpc_$recvfrom) recvfrom failed P(rpc_$unpack_hdr) Bad RPC version (%u)
 P(    rpc_$unpack_hdr) Bad pkt type (%d)
 P(rpc_$unpack_hdr) Packet too short; is %u, data len is %u
)P(rpc_$sendto) sendto fa 
    RPC_$LOCAL_DREP 
 $  RPC_$ASCII_TO_EBCDIC 
   RPC_$EBCDIC_TO_ASCII 
   
RPC_$STATS 
   
RPC_$DEBUG 
   RPC_$MAX_DEBUG 
   
RPC_$LOSSY  PFM_$FAULT_INH_COUNT  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_PKT  	RPC_$FREE  RPC_$MALLOC  RPC_$SWAB_HEADER  
RPC_$PKT_NAME  RPC_$PRINTF  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS      PFM_$SIGNAL  MALLOC  _ASSERT  
VAXC$GFPRINTF  VAXC$GPRINTF  VAXC$GVFPRINTF  PERRORC iledEPpkt->refcnt > 0UPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;5Pn_tasks < MAX_TASKSPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;5P%s%s
P	# of remote calls out:	%lu
P	# of remote calls in:	%lu
P	# of pkts sent:	%lu
$P		%s	%lu
.P	# of pkts rcvd:	%lu
DP		%s	%lu
NP	# of frag resends:	%lu
gP	# of dup frags rcvd:	%lu
  P  ^        VAXC$GVFPRINTF  FFLUSH  ^ݏ]   ݬ STRRCHRPݬխЬ
PP ݭ   RPC_$PRINTF  ABORT ^ Q RѬ
ޡoPPЬP@ P  ^  PFM_$INHIBIT_FAULTSP  ^  PFM_$ENABLE_FAULTSP  ^ЬPPPP߬ PP MEMCPY ^ RЬPPPP PP߭ MEMCPYЬPPPPxPPPQ PPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬP    JQЬPJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@ PЬPLP`ЬPLQЬPLPaЬPLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPP    aЬPPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP` ЬPDQЬPDPaЬPDPЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHPaЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8QЬP8PaЬP8PЬP8PЬP8QЬP8P    ЬP8P <  ^ T U R޼P `߭ЬP  PP PPݬ RECVFROM_NCKPխe# ā  PERRORЭP޼PЭ`խЭPhլcЬPNPPխRЭP@G޼SЭP@PàPP PPЭP@PްP`PcխeЏP޼P`PP)޼P`PPġ  RPC_$PRINTFeЏPЬPPPPPP<PPP
.ЬPPPPP  RPC_$PRINTFeЏPЬPPPPxPPPQ PPPQPݬ RPC_$SWAB_HEADERЬP>JP<`PP   P    ѭP3 PЬP>JP<`PPݭ  RPC_$PRINTFeЏP°PP°ЬPPPPPP<PPP@¸QaPPaP ^ W VЬ  FFLUSH  MEMCPY  STRRCHR  STRCPY  ALARM  SIGNAL  ABORT  RECVFROM_NCK  
SENDTO_NCK  FREE  ABORT  TIME  TIME  ABORT  
ERROR_$C_TEXT 
        RPC_$PRINTF 
  ,     RPC_$DIE 
      
RPC_$PKT_NAME 
       	RPC_$LOCK 
       RPC_$UNLOCK 
       RPC_$SET_PKT_BODY_ST 
      RPC_$GET_PKT_BODY_ST 
      RP    C_$SWAB_HEADER 
    < 
RPC_$RECVFROM 
     RPC_$SENDTO 
  8	  < RPC_$MALLOC 
  p	    	RPC_$FREERRʏRR 똭SP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n PFM_$SIGNAL޼RbRRRЬR ݭ RRݬ 
SENDTO_NCKPխ) PERRORխ,ƬRRƬЬRRRRRR<RRRBƴScRRcRխRRRRRRP< ^ݬ MALL    OCPխЏ ^(n PFM_$SIGNALP  ^    FREE  ^P      PPF   R    RPC_UTIL      rpc_$printf ,     ,   rpc_$die T        
rpc_$pkt_name 8        	rpc_$lock 
        rpc_$unlock 
        rpc_$set_pkt_body_st (        rpc_$get_pkt_body_st        rpc_$swab_header       
rpc_$recvfrom       rpc_$sendto w    8	  rpc_$malloc 7     p	  	rpc_$free          	  rpc_$alloc_pkt       	  
rpc_$free_pkt      	  rpc_$alloc_linked_pkt X      RPC_$MALLOCPP  ^    	RPC_$FREE  ^X   PP RPC_$MALLOCPլP   PPݬЭP MEMCPYЭPP` P ^ RЬP>P<`PP"Pݏ  UE _ASSERT  ABORTЬQPPЬP>P<`PPݬ 	RPC_$FREE  ^޼P`-P޼Pް P`޼P` RPC_$FREE_LINKED_PKT޼PЭ`޼P` ^ SЬPPPЭPPPP޼    R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`ЬQPPЬ޼PЭ`ЬQPP*ЭQЭPTLPPЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPQЬP    QPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ  RPC_$ALLOC_PKTP޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRRR޼RbRXݭ MEMCPY޼R޲ Rb޼Rb RPC_$FREE_LINKED_PKT޼RЭb޼RbЭP ^ R PFM_$FAULT_INH_COUNTpP  TIMEP\\  QP<\\L¿ \\ս'Э\ѭн\ lЭQЭ\P\Pl\\ v\\     SIGNAL 
 ALARMP ^ T R  4P<PP@¿ P`<PPPPPPP ϱ ǭ2PP@¿ PPH< PPݏ"  ĜĈ _ASSERT  ABORT< PP@¿ PP PP  , ψPP SIGNALP ALARMP ЬЭPPЬ`ЭS  TIMEPQQPQ` ^ R   ;<PP@¿ PPѽ PսPP ŕ0    ALARM SIGNAL   ALARMP<     ^<RĬRRRRRѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR> ۢJR<bRRRRíSЬRCPЬRP MEMCPYRRP ^ SRPRPݬݬ STRCPY1 PPVЬQPPЬRPPbRBäaaPP*ЬRPPЬQPPaP@äbbPPVЬQPPЬRPPbRB$aaPP,PЬRPPЬQPPaP@$bbPP  ^ݬݬ    MEMCPY| ^ Vݏd   ߭^(n 
ERRO                                                                                                                                                                                                                                                   <                        }i        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                                         R_$C_TEXTP    VAXC$GPRINTF  FFLUSH  ^Ѭ  Ѭ  Ѭ   PPPPP ^ RѬ   ޼PЏ `+ݏ    RPC_$MALLOCP ЭP @   ЬPЬ@޼P    (^ S R¤ݬ 
VAXC$GFPRINTF¨ݬ 
VAXC$GFPRINTF¬ݬ 
VAXC$GFPRINTFְ <PP
G<PP@´P`<PPPP 
RPC_$PKT_NAMEP$ݬ 
VAXC$GFPRINTFޡPP<PP
°.ݬ 
VAXC$GFPRINTFװ <P    P
F<PP@¸P`<PPPP 
RPC_$PKT_NAMEPDݬ 
VAXC$GFPRINTFޡPP<PP
Nݬ 
VAXC$GFPRINTFgݬ   
  rpc_$free_linked_pkt g     x
  rpc_$free_frag_list ;     
  rpc_$insert_in_frag_list      8
  rpc_$reassemble_frag_list      
  handle_alarm        rpc_$periodically       rpc_$stop_periodic      T  rpc_$fill_frag        rpc_$cvt_string        rpc_$block_    copy        rpc_$status_print L     `  rpc_$termination_fault 8       rpc_$register_encrtype h        rpc_$dump_stats  9  		R      


	Ӥ   


          
0	

	           
q  	   	 
	
    
  	    RPC_$ALLOC_PKT 
  	    
RPC_$FREE_PKT 
  	    RPC_$ALLOC_LINKED_PKT 
  
   RPC_$FREE_LINKED_PKT 
  x
    RPC_$FREE_FRAG_LIST 
  
   RPC_$INSERT_IN     _FRAG_LIST 
  8
  < RPC_$REASSEMBLE_FRAG_LIST 
     RPC_$PERIODICALLY 
     RPC_$STOP_PERIODIC 
  T  < RPC_$FILL_FRAG 
     RPC_$CVT_STRING 
      RPC_$BLOCK_COPY 
    | RPC_$STATUS_PRINT 
  `    RPC_$TERMINATION_FAULT 
     RPC_$REGISTER_ENCRTYPE 
      RPC_$DUMP_STATS  9  $CODE L  $DATAm     ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR   $CHAR_STRING_CONSTANTS   
VAXC$GFPRINTF         w w                       1       @90I˓ V1.0                            2     U_PFMV1.014-SEP-1990 12:54                   VAX C V3.1-051  P%W%     (ultrix)        %G% P*** Exiting: exception caught by PFM system cleanup handler
*** %s
  P< ^ЬPP +PP?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  P^(n PFM_$SIGNAL  ,^ \լ(  SIGNAL  SIGNAL  SIGNAL  SIGNAL  SIGNAL      SIGNAL  SIGNAL 
 SIGNAL  SIGNAL  SIGNALP ,^ RϬ\\ SIGNALϚ\\   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII 
    PFM_$FAULT_INH_COUNT  PFM_$SIGNAL  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTS  PFM_$SIGNAL  
VAXC$GFPRINTF  LONGJMP  SIGNAL  SYS$EXIT  EXIT  
ERROR_$C_TEXT 
      	PFM_$INIT 
  $    
PFM_$_CLEANUP 
      t    PFM_$_RLS_CLEANUP 
      PFM_$_RESET_CLEANUP 
      PFM_$INHIBIT 
      PFM_$ENABLE SIGNALψ\\ SIGNALv\\ SIGNALd\\ SIGNALR\\ SIGNAL@\\ SIGNAL.\\
 SIGNAL\\ SIGNAL
\\ SIGNAL(     ^ˏPP !  ^ QЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^ QѬ ޼PЏ `б  ޼P `  ^ Q޼PС `Ь ޼P     ^P      ^  PFM_$INHIBIT_FAULTSP  ^  PFM_$ENABLE_FAULTSP ^ RТP\\P   ^   R    U_PFM      signal_handler         remove_signal_handler      D  install_signal_handler        	pfm_$init      $  
pfm_$_cleanup P     t  pfm_$_rls_cleanup ,       pfm_$_reset_cleanup $       inhibit_faults        pfm_$inhibit 
       pfm_$enable 
       pfm_$inhibit_faults     #       pfm_$enable_faults      ,  pfm_$signal        	pgm_$exit    		     չ             	
 	 
						    
     PFM_$INHIBIT_FAULTS 
      PFM_$ENABLE_FAULTS 
  ,  | PFM_$SIGNAL 
    < 	PGM_$EXIT    $CODE ,   $DATA    ERRNO    
VAXC$ERRNO         STDIN    STDOUT    STDERR D   $CHAR_STRING_CONSTANTSF P\\ՠ| ΀^ VЦ խ^լ  EXITMP Oݏd   ߭^(n 
ERROR_$C_TEXTPݭ   
VAXC$GFPRINTFݏ SYS$EXITж  զ ЭRRRլ
ЏPЬRRݭЭR LONGJMP< ^ ^(n PFM_$SIGNAL 
PS / _ ; k   G  w w    /         w w                                                                                             1       e@˓ V1.0                            7     
CONV_SSTUBV1.014-SEP-1990 11:54                    VAX C V3.1-051  P@(#)conv_sstub.c	2.1     (ultrix)        6/13/891P   uP v":3P
 P P   P ^޼P`<PPPPPЭQQQ RPC_$LOCAL_DREPPPPQP1 Q RPC_$LOCAL_DREPPQP1 ެPQ RPC_$LOCAL_DREP   3PQP1 ޭPн`PPP`PPP`PPPPPPݭݭ RPC_$BLOCK_COPYPPí    PPPPPޭPн`1QQQ RPC_$LOCAL_DREPPPPQP
ޭPн`9ޭPPЭЭPЭQЭPЭQЭPЭPؠ PPQQQ RPC_$LOCAL_DREPPPPQPP`!PPPЭЭPЭPРPPQQQ RPC_$LOCAL_DREPPPPQP
P`PPЭЭPЭPȠPPPPPPխ&PPPPPPխíPPPPPQQQ RPC_$LOCAL_DREPPPPQP
ޭPн`<PޭPPЭЭPЭQЭP    ЭQЭPЭP߭ݭݬ CONV_$WHO_ARE_YOU PPЬ$QPѭPPaaPP޼Rݭ RPC_$ALLOC_PKTPb
P޼   R    
CONV_SSTUB      conv_$who_are_you_ssr P  		^     I  $   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV 
    CONV_$MANAGER_EPV 
    CONV_$SERVER_EP     V  CONV_$WHO_ARE_YOU  RPC_$BLOCK_COPY  RPC_$ALLOC_PKT  P  $CODE    $DATAq RЬb޼P<RRR`RRЭЭRRЭRR޼ PíRR`޼(R b P CONV_$WHO_ARE_YOU P           w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                =                        rݴ:        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        L             ^     IK    
CONV_SSTUB# >@˓  SUKONNIK    
CONV_CSTUB# @˓  SUKONNIK    
RRPC_CSTUB# @@˓  SUKONNIK    
RRPC_SSTUB" `jA˓  SUKONNIK    	LLB_CSTUB"  o>A˓  SUKONNIK    	GLB_CSTUB A˓  SUKONNIK    VMS$ `ŐA˓  SUKONNIK    SOCKET_INET!  ΝC˓  SUKONNIK    RPC_UTIL  C˓  SUKONNIK    VMS# z5G˓  SUKONNIK    
RPC_CLIENT  PG˓  SUKONNIK    UUID N{G˓  SUKONNIK    GLB [G˓  SUKONNIK    LB  xG˓  SUKO    1       `a6@˓ V1.0                            7     
CONV_CSTUBV1.014-SEP-1990 11:54                    VAX C V3.1-051  P@(#)conv_cstub.c	2.1     (ultrix)        6/13/891P   uP v":3P
 P  P| l^ VuSuR SETJMPPDuuRݢDl 
PFM_$_CLEANUPlqq !pݭ 
RPC_$FREE_PKT^(qn PFM_$SIGNAL޼Rb RR<RRSR   SSppRRݭ RPC_$ALLOC_PKTP	ͽRR<RRRRRЭܭ޼RbR    RЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR ЬRRíܭRRͽRR߭߭ݏ   ݭݭݭ 1ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSRDS RPC_$LOCAL_DREPRSR0S RPC_$LOCAL_DREP   3RSR ޼RbRнbRR޼Rнb1 SSS RPC_$LOCAL_DREPRRRSR޼RbRнb=޼RbRRЭЭRЭSЭRЭSЭR    ЭRТRRSSS RPC_$LOCAL_DREPRRRSR
޼Rнb?P޼RbRRЭЭRЭSЭRЭSЭRЭRȢݭ   R    
CONV_CSTUB      conv_$who_are_you_csr 3  		T     J !   U   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  CONV_$CLIENT_EPV  CONV_$MANAGER_EPV  CONV_$SERVER_EPV 
    CONV_$CLIENT_EPV  
PFM_$_CLEANUP  P     FM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR  3  $CODE    $DATA Z  
RPC_$FREE_PKTpݭ 
RPC_$FREE_PKTqu PFM_$_RLS_CLEANUP P          w w                                                                                                                                                                                                                                                                     1       $@˓ V1.0                            7     
RRPC_CSTUBV1.014-SEP-1990 11:54                    VAX C V3.1-051 P@(#)rrpc_cstub.c	2.1     (ultrix)        6/13/89uP 96 @P
 Pf  P ^ RPP PP߭߭ݏ   ݭݭݭ 1ݬ
 RPC_$SAR޼P`<PPPPPЭ䋏QQQ RPC_$LOCAL_DREPPPPQP.Q RPC_$LOCAL_DREPPQPQ RPC_$LOCAL_DREP   3PQP
޼Pн``QQQ RPC_$LOCAL_DREPPPPQP    
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭ 
RPC_$FREE_PKTP| L^ V]S]R   SETJMPPD]]RݢDL 
PFM_$_CLEANUPLYY !Xݭ 
RPC_$FREE_PKT^(Yn PFM_$SIGNAL޼Rb RR<RRSR   SSXXRRݭ RPC_$ALLOC_PKTP	ͥRR<RRRRRЭܭЬRRíܭRRͥRR߭߭ݏ   ݭݭݭ1ݬ
 RPC_$SAR<RRRRRЭܭSSS     RPC_$LOCAL_DREPRRRSR1 S RPC_$LOCAL_DREPRSR1 S RPC_$LOCAL_DREP   3RSR1 RRRRRR>Rb RR౭Џ  T^(Tn PFM_$SIGNALíܭRRRRR޼RbRR<RRRݭݭ RPC_$BLOCK_COPY<RRRRíܭRRRRR޼RbRнbRR޼Rнb1PRRSSS RPC_$LOCAL_DREPRRRSR
>Rb"P>RRЭЭRЭR̢RR౭Џ  P^(Pn PFM_$SIGNAL޼RbRR<RRխ1 í   ܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
н<P޽RRЭЭRЭSЭRЭSЭRЭRĢRRRRRR֭խ1líܭRRRRRSSS RPC_$LOCAL_DREPRRRSR޼RbRнb=޼RbRRЭ୼ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR
޼Rнb?P޼RbRRЭ୴ЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKTXݭ 
RPC_$FREE_PKTY] PFM_$_RLS_CLEAN   UP| ^ V%S%R SETJMPPD%%RݢD 
PFM_$_CLEANUP!! ! ݭ 
RPC_$FREE_PKT^(!n   PFM_$SIGNAL޼Rbz RR<zRRSR   SS  RRݭ RPC_$ALLOC_PKTPPmRR<zRRRRRЭܭЬRRíܭRRmRRmqr߭߭ݏ   ݭݭݭ1ݬ
 RPC_$SAR<zRRRRRЭܭrSSS RPC_$LOCAL_DREPRRRSR1rS RPC_$LOCAL_DREPRSR1sS RPC_$LO   CAL_DREP   3RSR1RRRRxRR>vRbRRvxЏ  ^(n PFM_$SIGNAL޼RbRR<vRRխ1íܭRRRR R޽RнbRRЭRRRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRЭRDRbRRíܭRRRRRЭRFRнbRRЭRJRbRRЭRLRbRRЭRNRRЭRORRݭݭ RPC_$BLOCK_COPYRRȏV   RRRRխ1íܭRRRRR޼RbRнbRR޼Rнb1sPRR   rSSS RPC_$LOCAL_DREPRRRSR>vRb!>vRRЭ୼ЭRЭRRRvxЏ  ^(n PFM_$SIGNAL޼RbRR<vRRխ 1íܭRRRRRrSSS RPC_$LOCAL_DREPRRRSR
޽Rнb<P޽RRЭ୴ЭRЭSЭRЭSЭRЭRRRЭRRR խhrSSS RPC_$LOCAL_DREPRRRSR
>Rb"P>RRЭ୬ЭRЭRRRRRRRխrSSS RPC_$LOCAL_DREPRRRSRЭRDRb   #ЭRDRRЭ୤ЭRЭRRRíܭRRRRRrSSS RPC_$LOCAL_DREPRRRSRЭRFRнb@PЭRFRRЭଡ଼ЭRЭSЭRЭSЭRܐЭRRRrSSS RPC_$LOCAL_DREPRRRSRЭRJRb$ЭRJRRЭ୔ЭRЭRRRrSSS RPC_$LOCAL_DREPRRRSRЭRLRb&PЭRLRRЭୌЭRЭRRRЭRNRRЭRORRխ&RRRRRRխȏV   RRRRխ1   íܭRRRRRrSSS RPC_$LOCAL_DREPRRRSR޼RbRнb=޼RbRRЭୄЭRЭSЭRЭSЭRЭRRRrSSS  RPC_$LOCAL_DREPRRRSR޼RнbCP޼RbRRЭ||RЭS|RЭS|RЭR|qݭ 
RPC_$FREE_PKT ݭ 
RPC_$FREE_PKT!% PFM_$_RLS_CLEANUP ^ RPP PP߭߭ݏ   ݭݭݭ1 ݬ
 RPC_$SAR޼P`<PPPPPЭ䋏QQQ    RPC_$LOCAL_DREPPPPQP.Q RPC_$LOCAL_DREPPQPQ RPC_$LOCAL_DREP   3PQP
޼Pн``QQQ RPC_$LOCAL_DREPPPPQP
޼Pн`<޼P`PP  R    
RRPC_CSTUB      rrpc_$are_you_there_csr 5    8  rrpc_$inq_stats_csr       rrpc_$inq_interfaces_csr     
  rrpc_$shutdown_csr 5  		       ! 	 '                                                                                                                                                                                                                                                    >                        b;u        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                                          U   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV 
    RRPC_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR    $CODE    $DATA i ЭЭPЭ     QЭPЭQЭPЭPؠݭ 
RPC_$FREE_PKT P   8  
         w w                                                                                                                                                                                                                                                                                                                                                                                                                      
  1       @˓ V1.0                            7     
RRPC_SSTUBV1.014-SEP-1990 11:55                    VAX C V3.1-051 P@(#)rrpc_sstub.c	2.1     (ultrix)        6/13/89uP 96 @P
 Pf P   P ^ݬ RRPC_$ARE_YOU_THERE޼P` PPЬ$QPѭPPaaPP޼Rݭ RPC_$ALLOC_PKTPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R   < x^SR SETJMPPDRݢDz 
PFM_$_CLEANUPzѭ խ    	RPC_$FREE^(n PFM_$SIGNAL ޼Rb<RRRRRЭSSS RPC_$LOCAL_DREPRRRSR2S   RPC_$LOCAL_DREPRSRެRS RPC_$LOCAL_DREP   3RSR
ޭRнb]SSS RPC_$LOCAL_DREPRRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭRآRRR RPC_$MALLOCP߭ݭݭݬ RRPC_$INQ_STATS RRRRRRЬ$SRѭRRccRR޼Rݭ RPC_$ALLOC_PKTPb޼RЬb޼S<RRRcRRЭR   RRR԰ԽRRRRRRҰҽRRҭЏ  ~^(~n PFM_$SIGNALíRRRRR޽RR<RRRݭ  RPC_$BLOCK_COPY<RRRRíRRRRRЭRRЭRR޼ SíRRcխݭ 	RPC_$FREE޼(R b< l^~S~R SETJMPPD~~RݢDn 
PFM_$_CLEANUPnzz  խݭ 	RPC_$FREE^(zn PFM_$SIGNAL ޼Rb<RRRRRЭSSS RPC_$LOCAL_DREPRRRSR3S RPC_$LOCAL_DRE 
  PRSRެRS RPC_$LOCAL_DREP   3RSRޭRнb^SSS RPC_$LOCAL_DREPRRRSR
ޭRнb9ޭRRЭЭRЭSЭR ԐЭSЭRЭR̢RďV   RR RPC_$MALLOCPv߭ݭݭݬ RRPC_$INQ_INTERFACES Rď[   RRRRRЬ$SRѭRRccRR޼Rݭ RPC_$ALLOC_PKTPbP޼RЬb޼S<RRRcRRЭRRRRȰȽRRRRRRưƽRRƭЏ  r^(rn PFM_$SIGNALRR<RRխ1íR   RRRRнܽRRЭRRRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRЭR>DRbRRíRRRRRЭRޢFRbRRЭR>JRbRRЭR>LRbRRЭRNRRЭRORRݭݭ RPC_$BLOCK_COPYRR܏V   RRRRխ1íRRRRRЭRRvRR޼ SíRRcխݭ 	RPC_$FREE޼(R    ^ݬ RRPC_$SHUTDOWN޼P` PPЬ$QPѭPPaaPP޼Rݭ RPC_$ALLOC_PKTPb
P   ޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R b P RRPC_$ARE_YOU_THERE RRPC_$INQ_STATS RRPC_$INQ_INTERFACES  R    
RRPC_SSTUB      rrpc_$are_you_there_ssr         rrpc_$inq_stats_ssr     P  rrpc_$inq_interfaces_ssr        rrpc_$shutdown_ssr    		     ߹   	$         
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  RRPC_$CLIENT_EPV  RRPC_$MANAGER_EPV  RRPC_$SERVER_EPV 
    RRPC_$MANAGER_EPV 
    RRPC_$SERVER_EPV  
PFM_$_CLEANUP  PFM_$SIGNAL  SETJMP  RRPC_$SHUTDOWN  RRPC_$INQ_INTERFACES  RRPC_$INQ_STATS  RRPC_$ARE_YOU_THERE  RPC_$BLOCK_COPY  RPC_$ALLOC_PKT  	RPC_$FREE  RPC_$MALLOC    $CODE    $DATA *  RRPC_$S     HUTDOWN P     P          w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                              1       A˓ V1.0                            6     	LLB_CSTUBV1.014-SEP-1990 11:56                   VAX C V3.1-051 P@(#)llb_cstub.c	2.1     (ultrix)        6/13/890P   tP i.;3~P
 P P    P  P  P 3;3 P
 P  P| d^ VmSmR SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_   PKTP	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RR  ݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR   Rޢ0RbRRЬR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRR ЬRzRRݭݭ RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭ Ɔ  ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR0S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR޼RнbbPSSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭ   SЭRЭSЭRЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP| d^ VmSmR SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTP	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ    RPC_$BLOCK_COPYRRíܭRRRRRЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ  RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬ                                                                                                                                                                                                                                                   ?                        ,x        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                        E               RzRRݭݭ RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭƆ  ݬ
 RPC_$SAR<RRRRRЭܭ SSS RPC_$LOCAL_DREPRRRSR0S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR޼RнbbPSSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP| θ^ VS   R SETJMPPDRݢDͺ 
PFM_$_CLEANUPͺ !ݭ 
RPC_$FREE_PKT^(n PFM_$SIGNAL޼Rb A   RR<RRSR   SSRRݭ RPC_$ALLOC_PKTPPRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RR   ݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ   RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭƆ ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1AS RPC_$LOCAL_DREPRSR1)S RPC_$LOCAL_DREP   3RSR1޼RbRнbRR޼RbR   bRR>RbRR<RRЏ  ^(n PFM_$SIGNAL޼ RbRR<RRխ1{íܭRRRRR޽RнbRRЭRRbRRЭRR ɽbRRЭRRRЭR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(   RRЭR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRR RRЭRtRнbRRЭRxRbRRЭRzRRݭݭ RPC_$BLOCK_COPYRR   RRRRխ1íܭRRRRR޼$Rнb1PSSS RPC_$LOCAL_DREPRRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRS   R޼RbRнb?P޼RbRRЭ୐ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR>Rb!>RRЭୈЭRЭRRR< RRЏ  ;^(;n PFM_$SIGNAL޼ RbRR<RRխ1íܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR|ЭxxR||RxRR   SSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRޭRRRRխíܭRR RRRSSS RPC_$LOCAL_DREPRRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSS RPC_$LOCAL_DREPRRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS RPC_$LOCAL_DREPRRRSRЭRR   b*ЭRRR\ЭXXR\\RXRRЭRRRЭRRRխ(PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR  RнbIPЭR RRTЭPPRTTSPRTSPRTRPRRSSS RPC_$LOCAL_DREPRRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSS RPC_$LOCAL_DREPRRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@R   RЭR(RRЭR)RRխ(PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S 8R<R8RRЭR4RRЏ@   խhPS RPC_$LOCAL_DREPRSR) RPC_$LOCAL_DREPRRRB RPC_$EBCDIC_TO_ASCII
RB RPC_$ASCII_TO_EBCDICRRRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR    tRнbIPЭRtRR4Э00R44S0R4S0R4R0RRSSS RPC_$LOCAL_DREPRRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ   R    	LLB_CSTUB      llb_$insert_csr g    h  llb_$delete_csr g      llb_$lookup_csr   		"      + 
 
+  !  
 =      
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$S "  ERVER_EPV  LLB_$CLIENT_EPV  LLB_$MANAGER_EPV  LLB_$SERVER_EPV 
    LLB_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR  Z  $CODE    $DATAC&RRRRRRխ   RRRRխ1íܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭ 
RPC_$FREE_PKT     ݭ 
RPC_$FREE_PKT PFM_$_RLS_CLEANUP P   h          w w                                                                                                                                                                                                                                                                                                                                                                                                                            $  1       nT>A˓ V1.0                            6     	GLB_CSTUBV1.014-SEP-1990 11:56                   VAX C V3.1-051  P@(#)glb_cstub.c	2.1     (ultrix)        6/13/890P   tP i.;3~P
 P  P| d^ VmSmR SETJMPPDmmRݢDd 
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTP	͵RR<RRRRRЭܭ޼RbR %  RЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRR RЬRޢRbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ RPC                                                                                                                                                                                                                                                   @                                RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        r      %       &  _$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ RPC_$BLOCK_COPYRRíܭRR͵RR߭߭ݏ   ݭݭݭ 0 ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR
޼RнbcPSSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ 
RPC_$FRE '  E_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP| d^ VmSmR SETJMPPDmmRݢDd   
PFM_$_CLEANUPdii !hݭ 
RPC_$FREE_PKT^(in PFM_$SIGNAL޼Rb 䏔   RR<RRSR   SShhRRݭ RPC_$ALLOC_PKTP	͵RR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ (  RbRRЬR>RbRRЬR>RbRRЬRRRЬRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRR RЬRޢ RbRRЬR>$RbRRЬR>&RbRRЬR(RRЬR)RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЬRޢ0RbRRЬR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЬRޢtRbRRЬR>xRbRRЬRzRRݭݭ RPC_$BLOCK_COPYRRí )  RR͵RR߭߭ݏ   ݭݭݭ0 ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1S RPC_$LOCAL_DREPRSRS RPC_$LOCAL_DREP   3RSR
޼RнbcPSSS RPC_$LOCAL_DREPRRRSR
޼Rнb<޼RbRRЭЭRЭSЭRЭSЭRЭRݭ 
RPC_$FREE_PKThݭ 
RPC_$FREE_PKTim PFM_$_RLS_CLEANUP| θ^ VSR SETJMPPDRݢD͸ 
PFM_$_CLE *  ANUP͸ !ݭ 
RPC_$FREE_PKT^(n PFM_$SIGNAL޼Rb A   RR<RRSR   SSRRݭ   RPC_$ALLOC_PKTPPRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRR +  R޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRR޼ RbRRЬRRíܭRRRR߭߭ݏ   ݭݭݭ0ݬ
 RPC_$SAR<RRRRRЭܭSSS RPC_$LOCAL_DREPRRRSR1RS RPC_$LOCAL_DREPRSR1:S RPC_$LOCAL_DREP   3RSR1&޼RbRнbRR޼RbRнbRRబRR>RbRRЏ ,    ^(n PFM_$SIGNAL޼ RbRR<RRխ1~PíܭRRRRR޽RнbRRЭRRbRRЭRRbRRЭRRRЭ R	RRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭRRнbRRЭRRbRRЭRRbRRЭRRRЭRRRݭݭ RPC_$BLOCK_COPYRRíܭRRRRRЭR RнbRRЭR$RbRRЭR&RbRRЭR(RRЭR)RRݭݭ RPC_ -  $BLOCK_COPYRRíܭRRRRRЭR0RнbRRЭR4RRݏ@   ݭݭ RPC_$BLOCK_COPY@   RRíܭRRRRRЭRtRнbRRЭRx RbRRЭRzRRݭݭ RPC_$BLOCK_COPYRR   RRRRխ1íܭRRRRR޼$Rнb1 	PSSS RPC_$LOCAL_DREPRRRSR
޼RbRнb<޼RbRRЭ୘ЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSR޼RbRнb?P޼RbRRЭ୐ЭR .  ЭSЭRЭSЭRЭRRRRRSSS RPC_$LOCAL_DREPRRRSR>Rb >RRЭୈЭRЭRRRЏ  ͼ^(ͼn PFM_$SIGNAL޼ RbRR<RRխ1íܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
޽Rнb<P޽RRЭୀЭRЭSЭRЭSЭRЭRRRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR|ЭxxR||RxRRSSS RPC_$LOCAL_DREPR /  RRSRЭRRb*ЭRRRtЭppRttRpRRЭRRRЭR	RRխ(PླྀRRƭRRRRխíܭRRRRRSSS  RPC_$LOCAL_DREPRRRSRЭRRнbIPЭRRRlЭhhRllShRlShRlRhRRSSS RPC_$LOCAL_DREPRRRSRЭRRb,PЭRRRdЭ``RddR`RRSSS RPC_$LOCAL_DREPRRRSRЭRRb*ЭRRR\ЭXXR\ 0  \RXRRЭRRRЭRRRխ(PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR RнbIPЭR RRTЭ PPRTTSPRTSPRTRPRRSSS RPC_$LOCAL_DREPRRRSRЭR$Rb,PЭR$RRLЭHHRLLRHRRSSS RPC_$LOCAL_DREPRRRSRЭR&Rb*ЭR&RRDЭ@@RDDR@RRЭR(RRЭR)RR 1  խ(PRRƭRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭR0RнbIPЭR0RR<Э88R<<S8R<S8R<R8 RRЭR4RRЏ@   խhPS RPC_$LOCAL_DREPRSR) RPC_$LOCAL_DREPRRRB RPC_$EBCDIC_TO_ASCII
RB RPC_$ASCII_TO_EBCDICRRRRRRխíܭRRRRRSSS RPC_$LOCAL_DREPRRRSRЭRtRнbIPЭRtRR4Э00 2  R44S0R4S0R4R0RRSSS RPC_$LOCAL_DREPRRRSRЭRxRb,PЭRxRR,Э((R,,R(RRЭRzRRխ&RRRR   R    	GLB_CSTUB      glb_$insert_csr g    h  glb_$delete_csr g      glb_$lookup_csr     t  glb_$find_server_csr a   		      + 
  3  
+ 
 =  쎿 Q   
CC$_GFLOAT  RPC_$LOCAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  4   GLB_$CLIENT_EPV  GLB_$MANAGER_EPV  GLB_$SERVER_EPV 
    GLB_$CLIENT_EPV  
PFM_$_CLEANUP  PFM_$_RLS_CLEANUP  PFM_$SIGNAL  SETJMP  RPC_$BLOCK_COPY  
RPC_$FREE_PKT  RPC_$ALLOC_PKT  RPC_$SAR    $CODE    $DATA RRխ   RRRRխ1íܭRRRRRSSS RPC_$LOCAL_DREPRRRSR
޼$RнbF޼$RbRR$Э  R$$S R$S R$R ݭ 
RPC_$FREE_PKTݭ 
RPC_$FREE_PKT                                                                                                                                                                                                                                                   A                        (        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                        T      4            PFM_$_RLS_CLEANUP ^ RPP PP߭߭ݏ   ݭݭݭ0ݬ
 RPC_$SAR P   h  t         w w                                                                                                                                                                                                                                                                                                                                                6   <^ V W ЬЬ ͻ ͺ  ؐ    ͨSR  SETJMPPDRݢDp 
PFM_$_CLEANUPp 1 ݭݭݭݭϢխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb խ խ	ݭͻݬ4ݭ RPC_$FREE_HANDLEͺ
  RPC_$UNLOCK^(n PFM_$SIGNALЬRޢRbѭ̏)Ь RPC_$GET_MY_ACTIVITYSRRS`Pѭ̏
 >ݬ4߭ݬ RPC_$ V  SERVER_TO_CLIENT_HANDLEP޼4Rb޼4R^(bn PFM_$SIGNAL琏ͻͣ^(ͣn  PFM_$SIGNALЭЭR>jR<bRʏRRЏ ͟^(͟n PFM_$SIGNALѬЏ ͛^(͛n PFM_$SIGNAL޼$RЭb޼0R b޼(R b޼4R b ͸ݬ4ЭR>ZR<bRR SOCKET_$MAX_PKT_SIZEP   PPܐ   ЭR>jR<bRʏRSRSSˏRRݬ4ݬ RPC_$CLEAR_BINDINGݬ4ЭRݢVЭRZ SOCKET_$INQ_PORTPЭRVRR1 ЭRVRRRRRRRbSЭRVRbcЭR 8  ŵ VAXC$GPRINTF1jխ# 
RPC_$DEBUG޼Rbͯ VAXC$GPRINTF1APPcݬЭP>xP<`PP SOCKET_$VALID_FAMILYPD 
RPC_$DEBUGЭP>xP<`PPݭ, VAXC$GPRINTFPP䏈   PPѭѭ 
RPC_$DEBUGj VAXC$GPRINTF1PЏd    ݬ߭ ļЭRݢtЭRx SOCKET_$TO_NAME޼RbŰļ STRCPY  
RPC_$DEBUGݭļ VAXC$GPRINTFݬЭRݢtЭRxݬ RPC_$SET_BINDING޼Rb!  9  
RPC_$DEBUG޼Rb VAXC$GPRINTF1PRP SETJMPPDPݠDͫ$ 
PFM_$_CLEANUPͫww  
RPC_$DEBUGw- VAXC$GPRINTF1Ĭ {Ĭ ݬ RPC_$SET_SHORT_TIMEOUT {߭߭ 	UUID_$NIL 	UUID_$NILĈ ݬ GLB_$CLIENT_EPV   3R	b{ PFM_$_RLS_CLEANUP޼R   | ^ V ƨ 
Ƅ PƄ ! 	UUID_$NILƈ  UUID_$EQUALP
ƈ L ƨ  ϲP)ưݬ޼Rb޼ :  R^(bn PFM_$SIGNAL Ƅ Ƅ  RPC_$FREE_HANDLEЭRB$ SOCKET_$VALID_FAMILYP1PЭRB$ƈ  RPC_$ALLOC_HANDLEPƄ RR
Rb1]PƬ Ƭ Ƅ  RPC_$SET_SHORT_TIMEOUT򞭨SR SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ) ƨ Rˏ  bRR  ^(n PFM_$SIGNALɞRb ?խЭRѭB$޼SRbcƄ  RPC_$FREE_HANDLE Ƅ ư 
Rb IưƄ  GLB_$CLIENT_EPV   3 ;  Rb-ЭRB$Ƅ  խ^(n PFM_$SIGNALƨ Rb 
   PFM_$ENABLE PFM_$_RLS_CLEANUPƨ =ư v   P  ^ P   P| ^ V 	UUID_$NILƈ  UUID_$EQUALٕP
ƈ լ
޼R(ƈ bP ^ R޼P `ݬ$Pݬݬݬ  RPC_$INQ_BINDINGP ^ R  GLB_CA_$GET_OBJECT_UUID ݬݬݬ  RPC_$SET_BINDINGPݬݬݬ  	RPC_$BINDP ޼P`¨  <  | ^ V ޼RЏ bݬ{P1 խ1 SR SETJMPPDRݢ  SOCKET_$VALID_FAMILY  UUID_$DECODE  LB_$LOOKUP_RANGE  RPC_$SET_SHORT_TIMEOUT  RPC_$FREE_HANDLE  	RPC_$BIND  RPC_$INQ_BINDING  RPC_$SET_BINDING  RPC_$ALLOC_HANDLE  VAXC$GPRINTF  STRLEN  STRCPY  SETJMP  LSEEK  READ  OPEN  ACCESS  OPEN  CLOSE  CLOSE  READ 
      GLB_CA_$SET_SHORT_TIMEOUT 
    | GLB_CA_$GET_OBJECT_UUID 
  (	   GLB_CA_$GET =  _SERVER_ADDRESS 
  d	   GLB_CA_$SET_SERVER_ADDRESS 
  
    GLB_CA_$INSERTb  R
    GLB      get_default_object p     p   has_server_list <        open_server_list      4  close_server_list 0     d  find_server_nbrd     h  
check_binding _       glb_ca_$set_short_timeout         glb_ca_$get_object_uuid =   !  (	  glb_ca_$get_server_address 9   !  d	  glb_ca_$set_server_address c     	  glb_regi >  ster_ops 	    
  glb_ca_$insert      
  glb_ca_$delete      D 
PFM_$_CLEANUPЭRb ) ƨ Rˏ  bRR  ^(n PFM_$SIGNALRb  Rb ݬݬƄ ޼RbRb 	  PFM_$ENABLE PFM_$_RLS_CLEANUPݬϤPխ1,P  ^ݬݬ GLB_$CLIENT_EPVP  ^ݬݬ GLB_$CLIENT_EPV   3ϿP| ^ V   ޼ RЏ b޼R b޼Rbƨ  ݬ P1kխ1cPSR ?   SETJMPPDRݢD 
PFM_$_CLEANUPЭRb ) ƨ Rˏ  bRR   ^(n PFM_$SIGNALRb  Rb 1  ЬЬѭ䏐  
ЭRRЏ  ЭRRݬ ݭ߭ݭ߭ݬݬݬƄ  GLB_$CLIENT_EPV   3R	bŭ   RRRRRíRRխխ1{P𞭐Rb   PFM_$ENABLEP PFM_$_RLS_CLEANUPݬ ϰPխ1խ!޼RЭb޼RЭbխݬݭ޼ Rb ޼Rb޼ R b `^ W  @  V  Ьѭ1 ЭR>xR<bRRݭ SOCKET_$VALID_FAMILYP1 PRB A    glb_ca_$lookup     
  sort_entries M  		A                 	   	        A   	   	  :            
  
    GLB_CA_$DELETE 
    | GLB_CA_$LOOKUP  U  $CODE ,  $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR k  $CHAR_STRING_CONSTANTSYRBư RBƴ   jݭ SOCKET_$FROM_NAMEխRB RB ЭRݢtЭRxRBư RbRBƴ  
S     OCKET_$EQUALPDѭ4ŏ   R޼S( Bc`ŏ   R޼S( Bc( `RRRR   RRѭ1        w w %GP   WP v":3aP
dP P 96 @ P
 PfP P     !P     %P7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????PP??????P ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#C    @'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[???????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????012 3456789|????? P(rpc) *** FATAL ERROR "%s" at %s\%d ***
)Prequest P)1Pping$P16Presponse(P6?Pfault,P?EPworking0PEMPnocall4PMTPreject8PT[Pack<P[_Pquit@P_dPfackDPdiPquackHPioPBOGUS PACKET TYPE P(rpc_$recvfrom) recvfrom failed P(rpc_$unpack_hdr) Bad RPC version (%u)
 P(                                                                                                                                                                                                                                                   B                                                                                                                       
1                                                                                                                        L               \ ,   A+f߄Ȧq(1﷧ȫG(}ChiZkؾA6FV4%0$(x3y
c;h{*W{vb
~Y葶Ҿ5Wa4X4c<DuNc
]/ֳO7zJW UfԞ$zƵCK	0!\m&<qo/ '<ar_L@W߷bk8!+̅B7.kcVVEO['!>_	1WG)ZQ(zI5lC_CuEdn^T52JYwƔʩ	,=]x=Qz
SDJq.aZܧ!8q,r^2 TɁT\ZteI2Cy
ng(J9Fhp%OO	o99WQre:$*@H;O8$ϿZkNTJ    KUPip3MBq68r9#֥0QFzƿʱ_T)lV4`T9j1_AWXܾe}|qoI*/U*b#PDCAXt݈#$@TGCRO[?dxlG]9>sC͂zR;}2e̓KS0ar#)h 
fc@@,Wun1XG8*Y}f1q"Arn\RhՄ_cbp7P], eZ#/Tƀڨ>	14jI
eV힆n?$o\j~̼l'+3EVR
Ɠ"Ý1Ď^)h::jI
KgX`nLg:C͆Lܳ
P+0ΊWte% Ƨ^ʮv1]&)`9K+wSx?n r   Mѻ957x=g`?+̰i}}T(5hHy
;l(g5)4ԅǂ{sYCUh<X'9.CR׎˨ݲ3Zs iGח^%GcSź6pLבߔ|L-mG:J7AJTy$9NLixODˬuv>}*lPqE;2ʹHiΎ3:W'Կ"6@k-~ь/R
>dTi
Ts]HК\YO%yGb&[0\O?Ն4Q	#{Npȴ|	$J+VquRZw3$*ݿ}ii9Uxo%<9tSWȂ[V::LhV(qG/Oz~eoH )</#I[8gMu5ۥcv4   <apQ}:ʛ<arGV4\`v1m˶h:h.qw][VݏK愌‸-rPEvDa5'9QuBZ"yLP:կiA,9{юxqg-313DEKi5][,˛
]
(Vf}^äx^HBTHJg>+D?*/9xhc1 <TakF5׫aԍLf.g3_K8S.#j!
&B;>gd2Ri?szt}S!r,
H3棏1
9wq
D x7j2>u5xd1~lP\N͇]z엦}?NKaGg_HJkzOSݗEؙfg6E]/iyb3;4
?V1|v
1ivQ]GEU x   OJby'bli<;6ȁ$І&a"ԅQW as!Ɓ:
O/8"sYD*vH!!PGGQDFTOT(Xe#ZązV/ř 
f|B? k*>گ
[\ptqA!MlG%;k٪6C	#ʐQInyRfq*0}gV#A4
<HoC(Y0NySc#t-^oRԍ/@T+E--ꁼfIcq{x\smxLe:vbȭw%Pi\`Xa4Cssߦ:%ڀJCb9n/ZC'.RڷB:H?myI]8PBa֌qXVf l8
4hpSŷ1;^ #-U  Q   7ɫ$+6vB5(6^MR#R
W%|voMXdSnVIbZMdeB`w7^@5<$MI<dhEM1;@CJ
[1E,e<2`>gEouw
i+6>j"j2?h*V	(`xnMZ$󂚗ncް!mvL,J+J_Gf&iWrr.*H6O9Jk4խ?ꨳk
.x@$B<olfUM`0*}$nߕ`%ø@cZɡ:
m|.ݫ[cEɴ|XҦ:#ȉ4eVPiHU
5ͺ-*sgG!
uF!voӤ7Rإ|˭W  O   CÔy74%"6	i8уZ۟MO(ȴqm zUdKph8Ft9%bhH^DK18hUK(DWa,S7OO;%T#	hLmY{[TjHBaaKE|6ҁpN4p=+rO	]`榠xunA{ H5Mj[R7+0⏪hZ)*2;Ylw,)i
z1(9깓@%';F{#eXͷQE|zq~~PP:FAQQ<?Σ8oÎūRgkFf5eA輞'l#\D`2٦=|UQ!vR0Ϋ"$.tXʇS_)Z{M_-,/'ʫ#
͏b}	o0I0oG+cy5Jmp9D\    1(|A4\GgÈ\&jwxvtU[̈́׊?YRsޞ>*pU7`8O HP'Ύ$ULu!9{p(}*Wt YsJCcpڔ'@W4t:^
1lˌȢ]H#O0TH`n:??iлx/Z\NW߮,5)TDϏm@ѢEkAz+*1]yN×v{;#Cٜ)wVJm7ssOcL.zh{[?s8E&
'DY9b܊͵|
D}.tXI*d^҇>UBi秂=)I%f^X]ҟ*W~-BE`t\AK"ͣBi_M*[{xh5Wj\8bK   [[pq?@lR,xT|AΆp+]FX 0ʁ[B'sE<8h-̲wc$irhhIӵX!G&<nw<O&
$O%v'"?{$V6,X{<	3=#_Wq@QɖGh+tn#/V%(u?~ mYFQ8dOHhjs+U=ȫP,B0玊kA'0a{ )SL&6H?<\<oe0hv?V*ǳ=4qK`O\oK\9;݊rR<BBShR]{
8ҙ`Y,",BDZ#i=uQLW=ӰA&.vTȀ+C4uS8Y1 F   fX8kMQ*,+ٺ6(<ѝQ,^ y,U9J:L:͑s&W]s {hͰˍslxEr8:ɨW+J[5% #/$!_dÊ@ID?Lp#=t5,?`K-OZª;˴/DīȨx|_mv ꂍj8V*:Zw[Z0	qsh8H!`!sJ8ȨCcU,kDB3 R+{`K4`4/o !ƬDAqX# ܑ.W"DRUǊa}>rpqe%(9xH1>?ئ)uax=g6wNTϥ(?Q0^FAe+u~HjXDd s  w(Typƴ煽\;.<Ff
KV`\KHUP7`!a|)go+h*	͝l[a1ѝ5]
!>Xq?ƿc UavkuO㏚n,9ҽ/`fmV%-&gŨP l1$3gϏioȉ+݀^,<510)},`Ӡ5R]EVNkR>$KἚ+[Q̄^3C<6D.NoHJ΅ 2֏DtI=_ l
2
o84Z]zYk=S
78,!1}.xh*J}2n]Vʼ4b &.ZmekKS
]tS~]?4ڐ4qPyY5Z!27Y   \rl?#YQG7e9A`C
)Jr	C M`مÿag/K6M~PJ~áa-AWۗfLCu54	AR <>#Ԡ(8U=o@-CPkO*((Z;UD"<-ޛ`ۈ+L2U­`e|\隠u$x󈑆mZ&%LOr{$_SDAEӇY $>@4>y摬KMOA+aźM$3:m?={cUV׶jp_/I{5y<E)8(7bmzpC/yeC1?L{~`oVp)&Z7wy֓5ˆ'[
Q<hphe,r:\x~k0H,D^qcLd&,
&`A1T ݕC*Y
/ JDFʀ    SR1'y.ENJ||O$[Eɒz=P5M*=x[!_$N8/B@jA,eLx܏`QK$z+o']2qϾa}bLګUCѬH6Oxj&eZn(<vHugNg%݊S=upR'-
^>S|%?nogA?|Y
KAxpC6ً\jk|UбZ2\`WRtnxؑs~nBcĨQ
q;b]VbE$zmCBN`ᰘV 0ӓQg8B3co
"i2p,PgZ&F	OiW-xHVpZ.1~Iq#R;
H=e(Kynsgx'h#u7LU&HZ
 F	~IΉ>    ZLfq)ʎ^9"`~ȴ@$شXV9sy|@#0w߼hܔFHV*s;VNwHk4sf=ݗ|'-|8k@S}iaGqsT՞ڠ|\v
x9fVUl
gV$W[h}&#
X`\Qx

?I`:z3oq\hy1Ӎ}D1	=,ƁކFׁW>=k#sf[X9͟,*C~J1o9l;5=ば-!HwyT9_ࡌHtIa#'}OG:{q*mP	bZ'VnΙC,ֺ[C-(yNqK:-R
cɨ#gxK\m7|7S{'ſ=]槀Sckd\ݎ"ؠJs^'A   AӷG᭺	Ӎ>}@F^\h5` dסb9D }%d?r>HűM]%&氼߰U >^-	3rڟ{W0ci͎h"㔂n(6K(
nwכOnVFh}M|hIzǋ6I}I] m>E"ZRCO0i2)=3B?VRلSǉb\yق  u+&e{I=1vNZ"벅=q `B}NugT]'3&]db5(͜6
mu%DO85_)@:}aeARN$EoOM{{pw׿FwR`!铩;^ṘȰϯU_ݱOrs(ޚ8+R
E Ir2EvJ%%⚹{s su jiψo                                                                                                                                                                                                                                                    C                        /O        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;11                                                                                            f                              C      D    rpc_$unpack_hdr) Bad pkt type (%d)
 P(rpc_$unpack_hdr) Packet too short; is %u, data len is %u
)P(rpc_$sendto) sendto fa 
    RPC_$LOCAL_DREP 
 $  RPC_$ASCII_TO_EBCDIC 
   RPC_$EBCDIC_TO_ASCII 
   
RPC_$STATS 
   
RPC_$DEBUG 
   RPC_$MAX_DEBUG 
   
RPC_$LOSSY 
 L  PFM_$FAULT_INH_COUNT  RPC_$FREE_LINKED_PKT  RPC_$ALLOC_PKT  	RPC_$FREE  RPC_$MALLOC  RPC_$SWAB_HEADER  
RPC_$PKT_NAME  RPC_$PRINTF  PFM_$ENABLE_FAULTS  PFM_$INHIBIT_FAULTSE      PFM_$SIGNAL  MALLOC  _ASSERT  
VAXC$GFPRINTF  VAXC$GPRINTF  VAXC$GVFPRINTF  iledEPpkt->refcnt > 0UPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;4Pn_tasks < MAX_TASKSPDUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;4P%s%s
P	# of remote calls out:	%lu
P	# of remote calls in:	%lu
P	# of pkts sent:	%lu
$P		%s	%lu
.P	# of pkts rcvd:	%lu
DP		%s	%lu
NP	# of frag resends:	%lu
gP	# of dup frags rcvd:	%lu
  P  ^  F      VAXC$GVFPRINTF  FFLUSH  ^ݏ]   ݬ STRRCHRPݬխЬ
PP ݭ   RPC_$PRINTF  ABORT ^ Q RѬ
ޡoPPЬP@ P  ^  PFM_$INHIBIT_FAULTSP  ^  PFM_$ENABLE_FAULTSP  ^ЬPPPP߬ PP MEMCPY ^ RЬPPPP PP߭ MEMCPYЬPPPPxPPPQ PPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬPJQG    PJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@ PЬPLP`ЬPLQЬPLPaЬPLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaH    PPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP` ЬPDQЬPDPaЬPDPЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHPaЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8QЬP8PaЬP8PЬP8PЬP8QЬP8PI    P8P <  ^ T U R޼P `߭ЬP  PP PPݬ RECVFROM_NCKPխe# ā  PERRORЭP޼PЭ`խЭPhլcЬPNPPխRЭP@G޼SЭP@PàPP PPЭP@PްP`PcխeЏP޼P`PP)޼P`PPġ  RPC_$PRINTFeЏPЬPPPPPP<PPP
.ЬPPPPP  RPC_$PRINTFeЏPЬPPPPxPPPQ PPPQPݬ RPC_$SWAB_HEADERЬP>JP<`PP   PѭP3J     PЬP>JP<`PPݭ  RPC_$PRINTFeЏP°PP°ЬPPPPPP<PPP@¸QaPPaP ^ W VЬ  PERROR  FFLUSH  MEMCPY  STRRCHR  STRCPY  ALARM  SIGNAL  ABORT  RECVFROM_NCK  
SENDTO_NCK  FREE  ABORT  TIME  TIME  ABORT  
ERROR_$C_TEXT 
        RPC_$PRINTF 
  ,     RPC_$DIE 
      
RPC_$PKT_NAME 
       	RPC_$LOCK 
       RPC_$UNLOCK 
       RPC_$SET_PKT_BODY_ST 
      RPC_$GET_PKT_BODY_ST 
    K      RPC_$SWAB_HEADER 
    < 
RPC_$RECVFROM 
     RPC_$SENDTO 
  8	  < RPC_$MALLOC 
  p	    	RPC_$FREE RRʏRR 똭SP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n PFM_$SIGNAL޼RbRRRЬR ݭ RRݬ 
SENDTO_NCKPխ) PERRORխ,ƬRRƬЬRRRRRR<RRRBƴScRRcRխRRRRRRP< ^ݬL     MALLOCPխЏ ^(n PFM_$SIGNALP  ^    FREE  ^P      PP    R    RPC_UTIL      rpc_$printf ,     ,   rpc_$die T        
rpc_$pkt_name 8        	rpc_$lock 
        rpc_$unlock 
        rpc_$set_pkt_body_st (        rpc_$get_pkt_body_st        rpc_$swab_header       
rpc_$recvfrom       rpc_$sendto w    8	  rpc_$malloc 7     p	  	rpc_$freeM          	  rpc_$alloc_pkt       	  
rpc_$free_pkt      	  rpc_$alloc_linked_pkt X      RPC_$MALLOCPP  ^    	RPC_$FREE  ^X   PP RPC_$MALLOCPլP   PPݬЭP MEMCPYЭPP` P ^ RЬP>P<`PP"Pݏ  UE _ASSERT  ABORTЬQPPЬP>P<`PPݬ 	RPC_$FREE  ^޼P`-P޼Pް P`޼P` RPC_$FREE_LINKED_PKT޼PЭ`޼P` ^ SЬPPPЭPPPN    P޼R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`ЬQPPЬ޼PЭ`ЬQPP*ЭQЭPTLPPЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPO    QЬPQPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ  RPC_$ALLOC_PKTP޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRRR޼RbRXݭ MEMCPY޼R޲ Rb޼Rb RPC_$FREE_LINKED_PKT޼RЭb޼RbЭP ^ RLn  TIMEP\\  QP<\\L¿ \\ս'Э\ѭн\ lЭQЭ\P\Pl\\ z\\ SIGNAL P    
 ALARMP ^ T R  4P<PP@¿ P`<PPPPPPP ϱ2PP@¿ PP H< PPݏ"  ĜĈ _ASSERT  ABORT< PP@¿ PP PP  , όPP SIGNALP ALARMP ЬЭPPЬ`ЭS  TIMEPQQPQ` ^ R   ;<PP@¿ PPѽ PսPP ŕ0    ALARM SIGNAL   ALARMP< ^<RĬRRRRQ    RѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR>JR<bRRRRíSЬR CPЬRP MEMCPYRRP ^ SRPRPݬݬ STRCPY1 PPVЬQPPЬRPPbRBäaaPP*ЬRPPЬQPPaP@äbbPPVЬQPPЬRPPbRB$aaPP,PЬRPPЬQPPaP@$bbPP  ^ݬݬ    MEMCPY| ^ Vݏd   ߭^(n 
ERROR_$C_TEXTPR        VAXC$GPRINTF  FFLUSH  ^Ѭ  Ѭ  Ѭ   PPPPP ^ RѬ   ޼PЏ `+ݏ   
  rpc_$free_linked_pkt g     x
  rpc_$free_frag_list ;     
  rpc_$insert_in_frag_list      8
  rpc_$reassemble_frag_list      
  handle_alarm        rpc_$periodically       rpc_$stop_periodic      P  rpc_$fill_frag        rpc_$cvt_string        rpc_$block_                                                                                                                                                                                                                                                   D                                RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1;1                                                                                           f                        ֔      R      S    copy        rpc_$status_print L     \  rpc_$termination_fault 8       rpc_$register_encrtype h       rpc_$dump_stats  9  		R      


	Ӥ   


          
0	

	T           
q  	   	 
	
    
  	    RPC_$ALLOC_PKT 
  	    
RPC_$FREE_PKT 
  	    RPC_$ALLOC_LINKED_PKT 
  
   RPC_$FREE_LINKED_PKT 
  x
    RPC_$FREE_FRAG_LIST 
  
   RPC_$INSERT_INU    _FRAG_LIST 
  8
  < RPC_$REASSEMBLE_FRAG_LIST 
     RPC_$PERIODICALLY 
     RPC_$STOP_PERIODIC 
  P  < RPC_$FILL_FRAG 
     RPC_$CVT_STRING 
      RPC_$BLOCK_COPY 
    | RPC_$STATUS_PRINT 
  \    RPC_$TERMINATION_FAULT 
     RPC_$REGISTER_ENCRTYPE 
     RPC_$DUMP_STATS  5  $CODE P  $DATAm     ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR   $CHAR_STRING_CONSTANTS    RPC_$MALLOCP ЭP @   ЬP      Ь@޼P    (^ S R¤ݬ 
VAXC$GFPRINTF¨ݬ 
VAXC$GFPRINTF¬ݬ 
VAXC$GFPRINTFְ <PP
G<PP@´P`<PPPP 
RPC_$PKT_NAMEP$ݬ 
VAXC$GFPRINTFޡPP<PP
°.ݬ 
VAXC$GFPRINTFװ <PP
F<PP@¸P`<PPPP 
RPC_$PKT_NAMEPDݬ 
VAXC$GFPRINTFޡPP<PP
Nݬ 
VAXC$GFPRINTFgݬ 
VAXC$GFPRINTF        w w                                          W  VRb<RR.ЭTRRЭSRRcdRR<פRR>R<bSЬR<CRRݬ4   SOCKET_$SET_WK_PORT,Pݬ4>R<bSЬR<CRR SOCKET_$SET_PORTRRݏ$    	RPC_$LOCK쐏ͺЭR. UUID_$EQUALӕPЭR(.ЭRNRbЬRFЭR UUID_$EQUALPЭS޼RѣBb+ЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЀSRRRRRRѬRR
ЭR>jR<bRʏR X  RЭS`RRRRRRˏRRЭS0RRRRRRˏRRЭS RR ЭR ytoЭR .ЭSݬ4ݬЭR ЭRҀ R޲ R޲ RbPÄ ޼4Rb/ 
RPC_$DEBUG޼4RbF RPC_$PRINTF޼4R^(bn PFM_$SIGNALЭR ЭR҄ RbRâRRܕ
Џ ͗^(͗n PFM_$SIGNALRRRRRݬ4ЭR>R<bRR@P޼4Rb޼4R^(bn PFM_$SIGNALЭRݢ@ݭϹPؕ
 
RPC_$STATSRR 
RPC_$STATS  Y   SRR<SRRЏ ͓^(͓n PFM_$SIGNALɐ
2ЭR RRݭݭݭϹ蕭15
  ͹1  <SЭR>LR<bRRS 
RPC_$STATSh   3S 
RPC_$STATSh   3RSbЭR>LRbͦ͑ݭ<RRݬݭ RPC_$FILL_FRAGP͑͐<S<RRSR͑ ͐͐RR͒͒͓RR͓ЭR RRݭ͑ݭ硭RRRR͒1dR͑RR͹P  TIMEPRRԕ͹	͸	VP	͐P͐͐RR0<RR
RR
<RR Z  RxRRR䡭RRխݭsPЭPP  P	?P1խ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭR TR 
RPC_$ENCR_RGYSBcR޲Rb ߭#ЭRݢ@ݬ ݭݭݭP  TIMEPR­RRRR1>P ЭRRRRRPP PP&?P.P11A1ͼݭ RPC_$GET_PKT_BODY_ST^(ͼn PFM_$SIGNAL 
RPC_$DEBUG&PЭRRRRR 
RPC_$PKT_NAMEPo RPC_$PRINTF13RRѧ  Џ ͌^(͌n PFM_$SIGNAL [  1͹1! 
RPC_$DEBUGPƤ RPC_$PRINTF Pݏ   RPC_$DIE⡭RR<RR<RR3P 
RPC_$DEBUGP RPC_$PRINTFЏ ͈^(͈n PFM_$SIGNAL(P 77RR bЭR  ݭ7ݭP SLEEP1_Pݭ PRRPP  Pv?P1խ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ߭#ЭRݢ@ݬ ݭݭݭoP1 ЭRRRRRPP  \  P	?P.P1uvP1ͼݭ RPC_$GET_PKT_BODY_ST^(ͼn PFM_$SIGNAL 
RPC_$DEBUG&PЭRRRRR   
RPC_$PKT_NAMEP+ RPC_$PRINTF111-ݏK  k] RPC_$DIE͹/ 
RPC_$DEBUGƠ RPC_$PRINTFЏ ̈́^(̈́n PFM_$SIGNAL 
RPC_$DEBUGЭRݢ@ RPC_$PRINTFЭTЭR>HSHRcbЭTЭR>FSFRcb1CP
/ 
RPC_$DEBUG RPC_$PRINTFЏ ̀^(̀n PFM_$SIGNALЭR>LR<bSSЭR>LR<bRSR1P ]  TЭR>LR<bRRRRSLRSb 1pЭR 1;131+ЭRNSЭR҄ R޲ RSbЏ |^(|n PFM_$SIGNAL޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bݬ4ЭR@ݭЭR>JR<bSЭRCP޼,R^(bnЭR ҭR҄ RbR޲Rb޼4Rb޼4Rbx^(xn PFM_$SIGNALխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ЭRRʏRROP͸/ 
RPC_$DEBUG# RPC_$PRINTFЏ t^(tn  ^  PFM_$SIGNAL޼(SЭR>JR<bRRc1 P͸ЭR>JR<bRRݭ RPC_$ALLOC_LINKED_PKTPͧݭͨ RPC_$INSERT_IN_FRAG_LISTݭ   RPC_$FREE_LINKED_PKTͧkЭRRʏRRS(P 77R	R bЭR>HSRcb>ʹSRcbЭR  ݭ7ݭ-1fP޼(SͰRbc޼$Rͨ RPC_$REASSEMBLE_FRAG_LISTPb޼0RbP-#ݭMޕ  ϶ϲRR RPC_$STOP_PERIODIC  ЬRFЭR UUID_$EQUAL͕P!ЭS޼RѣBbЭTЭR>FSLRcbЭR. UU _  ID_$EQUALPЭTЭR>HSNRcbЭTЭRޢ8S>RcbЭRjSjRSb#RRRЭRVRRRЭRVRbS#Rbc#Rb<RR.ЭTRRЭ  CLOSE_SOCKET  
SELECT_NCK  TIME  
SELECT_NCK  TIME 
      CONV_$WHO_ARE_YOU 
  D	    RPC_$GET_HANDLE 
      RPC_$ALLOC_HANDLE 
     RPC_$SET_BINDING 
  L
   RPC_$INQ_BINDING 
    < RPC_$INQ_OBJECT_CLIENT 
  ,    RPC_$CLEAR_SERVER_BINDING 
      RPC_$CLEAR_BINDING 
      	RPC_$BIND 
  ,    RPC_$SET_SHOR `  T_TIMEOUT 
      RPC_$SET_ASYNC_ACK 
      RPC_$FREE_HANDLE 
  L    RPC_$DUP_HANDLE 
     RPC_$SAR SRRcdRR<RR޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bPխ6ЭRTR 
RPC_$ENCR_RGYSBc"ݭЭRTR 
RPC_$ENCR_RGYSBcR޲Rb ĕͻ ͻݬ4ݭ RPC_$FREE_HANDLEݭrܐ 4  PFM_$_RLS_CLEANUP  RPC_$UNLOCK  ^ݬݬݬݬݬݬ    SOCKET_$FROM_NAME  ^ݬݬݬ a  ݬݬ    SOCKET_$TO_NAME< ^ЬRТѭЬѭ
 ^(n PFM_$SIGNAL޼R bЭR object_client        ,  rpc_$clear_server_binding h       rpc_$clear_binding 4       	rpc_$bind c     ,  rpc_$set_short_timeout `       rpc_$set_async_ack        rpc_$free_handle      L  rpc_$dup_handle $     p  await_reply t      quit_server       rpc_$sar     0%  rpc_$                                                                                                                                                                                                                                                   E                        㿫        RPC010.B                       9	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OLB;1
1                                                                                           f                         
     a       b  name_to_sockaddr ,     \%  rpc_$sockaddr_to_name (     %  
rpc_$set_auth x     %  
rpc_$inq_auth P     ЭR ЭRҀ RbR޲RbЭR    < ^ЬRТѭЬѭ
 ^(n PFM_$SIGNAL޼R bR P< ^ЬRТѭ@޼R bЬЭR ЭR ЭR҄ RbR޲RbЭRЬ 9Pѭ
 ݬݬݬ RPC_$SET_SERVER_ENCRЏ ^(n PFM_$SIGNAL< ^ЬRТѭ޼R bЬЭR P7ѭ
 ݬ c  ݬ RPC_$INQ_SERVER_ENCRPPЏ ^(n PFM_$SIGNAL P %  ! %  zP  P! - ) M - M M %  	P 7  L&  
rpc_$set_encr      &  
rpc_$inq_encr h   		6R          
	  
    
          d        	 
 			        
   %0 	   
 e          	     
                    
   Հ            	  	    
  	      

Z
		     		 	 / 
  0%    RPC_$NAME_TO_SOCKADDR 
  \%    RPC_$SOCKADDR_TO_NAME 
  %  < 
RPC_$SET_AUTH 
  %  < 
RPC_$INQ_AUTH 
  L&  < 
RPC_$SET_ENCR 
  &  < 
RPC_$INQ_ENCR  D'  $CODE   $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR Y  $CHAR_STRING_CONSTANTS 
  /P5            w w                                                                                                                 ' * [UCX.V13.BL13.RPCKIT.B]RPC$LIBNCK.OPT;1 +  , :	   .     /    4 N                           - !   0   1    2   3      K  P   W   O     5   6  KΓ  7   ϓ  8          9          G #  H  J                          !	@(#)libnck.opt	2.3     VMS/ULTRIX Connection   1/27/90
!
!*****************************************************************************
!
!                        COPYRIGHT (C) 1989 BY
!                DIGITAL EQUIPMENT CORPORATION, MAYNARD
!                  MASSACHUSETTS. ALL RIGHTS RESERVED.
!
!  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED
!  ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND WITH THE INCLUSION
!  OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR ANY OTHER COPIES
!  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY OTHER
!  PERSON. NO TITLE TO AND OWNERSHIP OF THE SOFTWARE IS  HEREBY TRANSFERRED.
!
!  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
!  SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
!
!  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY OF ITS
!  SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL.
!
!*****************************************************************************
!
! ========================================================================== 
! Confidential and Proprietary.  Copyright 1987 by Apollo Computer Inc.,
! Chelmsford, Massachusetts.  Unpublished -- All Rights Reserved Under
! Copyright Laws Of The United States.
! 
! Apollo Computer Inc. reserves all rights, title and interest with respect
! to copying, modification or the distribution of such software programs
! and associated documentation, except those rights specifically granted
! by Apollo in a Product Software Program License, Source Code License
! or Commercial License Agreement (APOLLO NETWORK COMPUTING SYSTEM) between
! Apollo and Licensee.  Without such license agreements, such software
! programs may not be used, copied, modified or distributed in source
! or object code form.  Further, the copyright notice must appear on the
! media, the supporting documentation and packaging as set forth in such
! agreements.  Such License Agreements do not grant any rights to use
! Apollo Computer's name or trademarks in advertising or publicity, with
! respect to the distribution of the software programs without the specific
! prior written permission of Apollo.  Trademark agreements may be obtained
! in a separate Trademark License Agreement.
! ========================================================================== 
! 
! VMS LINK /OPTIONS file that lists the base (network independent) NCK 
! libraries.
! This file should live in RPC$LIB:.
!
rpc$lib:rpc$libnck.exe/share
!rpc$lib:rpc$libnck/lib
!rpc$lib:rpc$libucx/lib
!sys$library:ucx$ipc/lib
!sys$library:vaxcrtlg/lib
!sys$library:vaxcrtl.olb/lib
IDENTIFICATION="RPC V1.0A-00"
                                                                                                                                                                                                                                                                                                                                                                                                              ' * [UCX.V13.BL13.RPCKIT.B]RPC$LIBUCX.OLB;1 +  , ;	   . 8    /    4     8   8                     - !   0   1    2   3      K  P   W   O 9    5   6 Y=A˓  7  ϓ  8          9          G #  H  J                            %
   VAX-11 Librarian V04-00        A˓  A˓ !               6    8   /      2                          7     7   $                                                                                                                                                                                                                                                                                                                                                                                 r           3    CLOSE_SOCKET3    IOCTL3    RECVFROM_NCK3    
SELECT_NCK3    
SENDTO_NCK3    SET_SOCKET_NON_BLOCKING                                                                                                                                                                                                                                                                                                                                                                                                             3    VMS_UCX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         F                        M        RPC010.B                       ;	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBUCX.OLB;11                                                                                            8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            G                        a        RPC010.B                       ;	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBUCX.OLB;1;1                                                                                           8                         %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  H                        Qh        RPC010.B                       ;	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBUCX.OLB;1
1                                                                                           8                         /      "       #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  I                        w        RPC010.B                       ;	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$LIBUCX.OLB;11                                                                                            8                         9:      1       2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                4   1        A˓ V1.0                            4     VMS_UCXV1.014-SEP-1990 12:02                   VAX C V3.1-051  P%W%   (ultrix)  %G Pioctl failed: status = %d
Pioctl failed: status = %x, %x, %x%x
  P  ^Џ   ߭ݏ~fݬ IOCTLP  ^    CLOSEPP  ^ݬݬݬݬ    SELECTPP  ^ݬݬݬݬݬ    RECVFROMPP  ^ݬݬݬݬݬ    SENDTOPP <^ R S߭ 
LIB$GET_EFPˏPP  5    VAXC$GET_SDCPխ	cЏPP`ΞPPˏPP' PP#枭PP ЬЬݭݭ  U  R    VMS_UCX      set_socket_non_blocking (     (   close_socket      @   
select_nck (     h   recvfrom_nck ,        
sendto_nck ,        ioctl k  		F     s                 
CC$_GFLOAT  RPC_$LO 6   CAL_DREP  RPC_$ASCII_TO_EBCDIC  RPC_$EBCDIC_TO_ASCII  VAXC$GPRINTF  VAXC$GET_SDC  SELECT  RECVFROM  SENDTO  IOCTL  CLOSE  LIB$FREE_EF  SYS$QIOW  
LIB$GET_EF 
        SET_SOCKET_NON_BLOCKING 
  (     CLOSE_SOCKET 
  @     
SELECT_NCK 
  h     RECVFROM_NCK 
       
SENDTO_NCK 
      IOCTL  +  $CODE    $DATA    ERRNO    
VAXC$ERRNO    STDIN    STDOUT    STDERR @   $CHAR_STRING_CONSTANTS      ߭<PPݭݭ      SYS$QIOWPˏPPݭb VAXC$GPRINTFЭcЏP>P<`PʏPPH>P<`PP>P<`PP>P<`PP>P<`PPߢ VAXC$GPRINTF>P<`PPPPcЏP߭ LIB$FREE_EFP P        w w                                                                                                                                                                                                                                                                                                             A˓  SUKONNIK    VMS_UCX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    % * [UCX.V13.BL13.RPCKIT.B]RPC$LLBD.EXE;1 +  , <	   . $    /    4     $   %                     - !   0   1    2   3      K  P   W   O %    5 	  6  mΓ  7  ϓ  8          9          G #  H  J                             0 D X     0205      (  =N     B  p                                      RPC$LLBD                               RPC V1.0A-00   @=Γ 05-05                                  !   
  "     ?          !        VAXCRTL_001      !        
LIBRTL_001      !       
MTHRTL_001#      +         RPC$LIBNCK_001  LLBD: (find_socket) called with no ready sockets
 LLBD:  (process_requests) input from (process_requests) interface = %s
 (process_requests) object = %s
 (process_requests) dispatching
 LLBD:  (process_requests) forwarding to LLBD:  (process_requests) couldn't handle here..
 < name not available > %s %.*s[%d]
 LLBD: (use_family) Can't create socket
 LLBD: (use_family) Can't bind socket
 Listening on: LLBD: unable to obtain %.*s family port
 llbd/nck version 1.5 Can't register interface:  LLBD: Unable to obtain any sockets
    rpc$exe:llbdbase.dat    @(#)llbd.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                                                       3;3    
                                                                         3   
                                                                          96 @  
  f        Y  f                                         @(#)llb_man.c	2.2     (ultrix)        11/16/89                                                                     i.;3    
                                                                       3;3    
                              @(#)llb_sstub.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                                                       3;3    
          0    $  X-                                                < \^  c_d߭ ߭ݬݬݬ 
B  ѭ1 ޼Rb1  ;  d;  P
   RR:  t:  P	RR:  :  P	RRcc޼R( dbЭPѭ޼R( dbЭѭ1cRRP< ^ ѭCЭP޼Q @aTЬUЭR޼Sz  BcP{ PQPPRxRRDeRRDeRRѭ| ^V ѭ1 PЭR޼P B`T޼UЭR޼Sz  BcP{ PQPPRxRRRRRDeRRGЭR޼P B`TЬUЭR޼Sz  BcP{ PQPPRxRRRRRRRDeRRDeЭR޼PB`PRRѭ1oƃ9  8   ^WV "8   8   8  ЏQ 	 
ݬݬ"r	"ݏ@   8  Pխխ1JPխ1@ݬݬ"vPRR*:߭߭J߭Zݭ	28  RRRb^(nߧ28  1ƃ`ݭJߧ9ϼƔ*7  ƃƔߧW7  Ɣ:7  ƃƔߧzr7    <RR1 <RRBƄRbRF*7  Phƃƃǚ 7  ݭJݭZݭ)7  RRRb^(nǺ 6  PRR<RR1_1 ZJ* :vP`ƃݭ wZݭݭJݭ6  RRRb^(n Z6  ƃƃ 6  խ11mP ^RЏd   ߭߭߭ݬݬ6  խ"߭5  ߭5  PPPݭ߭ݭݬ+5   4^aSR ݬ*  Pխ8M5  ЏPݭ +5   ߭                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  J                        [(        RPC010.B                       <	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$LLBD.EXE;1;1;1                                                                                           $                                      T5  ݭݭ)*  P%ݭ5  `4  ЏPݭÆϼP |^TS޼R b߭߭4   ѭ1 PЭP<@PPPѭEЏd   ߭߭ЭP<@PPr4  Ã߭ݭĔ4  PЬQaRaPPa޼PЭB`PPѭ1r  ^ ѭ#ЭP޼Q@a3  PPѭ 4^3  WVǽ  ݬݬ3  3  ƃƃ  <RRf<RRBƈR޲ Rb<RRBƄRb]3  RRRb^(n53  RR<RR߭߭6խ2  2  ݭ߭ݭ߭PP     ^ެP޼P`޼P`2  P PP' 2  ޼P`2  PP PP PެPЬPЬPV2  P PP% 92  ЬP"2  P PP PެPЬP ЬP 1  P PP% 1  ЬP 1  P PP PެPՠ:ݬ$ЬPݠtЬPxЬPݠtЬPx 1  PPPPPЏ   PP ,^޼P `լ޼PЏ`޼Rݬ0  Pb޼Rbn x0  P޼Rݏ  ݏ  ݬS0  PbݭI0  ޼Rb޼Rb,0  
P޼RЏ b1-P޼Rb0  ѭU޼Rb/  ѭ&ݬ/  Pݬݬݬ޼RЏb޼RЏ b1 P޼Rbw ЭS޼Rb/  PCЭRB޼Rbi/  ޼SЭRBc ѭܭ!ЭRB@/  RRѭܭЬRŏ   RRЬR޼Rb/  PЬSǏ   RR  ^Pď   P   PPݭ.  Pխ޼PЏ ` Pݭ ݭ.  ЏЭP ЭPЬݬݬݭϱ޼P`ݭR.   PЭP< ^ЬЬRѭ1 ŏ   SЬRCRRŏ   SЬRCRb_լЭSЬ Rѣ00IP(RRݭݬ ^(n	\P#լ$޼$Tŏ   SЬR( CdЭPRRЬRѭ1^ЏP  ^޼P `޼P`Ŭ   PPP ݭ޼P`e-  P޼PЏ `GPݏ   ŏ   QЬPA޼P`-  Pѭ   ޼PЏ `PP< ^޼R bѬF ЬRѭ7Pŏ   SЬRCRb
ЭPRRЬRѭЬRѬ
޼RЏ bWЬRѬ
ЬSRRŏ   SЬRCRbŏ   TЬS޼R( bDݬݬݬϕ  ^ЬPѠtЬPѠt޼P `
P޼PЏ `| ^V޼R bݬݬլ	޼Rb( ݏ    ݬ ^(nݬ
FPݬݬݭݬϑ| \^kV޼R bݬݬ:լ	޼Rb( ݏ   \ݬ ^(nݬ
Pѭ+ŏ   SЬRCR bݬݭݬ]P޼RЏ b< T^ լ,E+  ޼Rb/+  P޼R(bT Pլ++  ޼Rb*  P޼R(bd Pլ+*  ޼Rb*  P޼R(bt P޼(R b޼$RbRR޼RbѭfRRݭTݭ^(nݬ
ϏPѭ)   RRRRRRѭѭѭ޼R bP޼RЭb޼ RЭbխ޼(RЏ bP ^UR P.ݬݏ  bKP ޼QPaPPP ^
RݬPݬݬ    ^RݬsPݬ  A ^Rݬ$CPݬ$ݬ ݬݏ   ݬݬݬݬݬ   
 ^]Rݬ(Pݬ(ݬ$ݬ PPݬݬݬݬݬ 
G   ^޼P`f<fPPPPPЭQQQ(  PPPQP1:Qx(  PQP1#ެPQi(  PQP1Pн`PPP`PPP`PPPPPPݭݭ'  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ'  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ&  PPíPPPPP
Pн`PPPPݏ@   ݭݭH&  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ%  16QQQ;&  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ%  PPPQPP` PPЭЭPЭPPPQQQ%  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ$  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQl$  PPPQPP` PPЭЭPЭPPPQQQ$  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQr#  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ#  PPPQPP` PPЭЭPЭPPPQQQ"  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ"  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ!  PQP*p!  PPP@X!  
P@M!  PPPPPPխíPPPPPQQQ
!  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ   PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ: PPЬ$QPѭPPaaPP޼Rݭa  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b ^޼P`f<fPPPPPЭQQQN  PPPQP1:Q4  PQP1#ެPQ%  PQP1Pн`PPP`PPP`PPPPPPݭݭL  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭR  PPíPPPPP
Pн`PPPPݏ@   ݭݭ  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ  16QQQ  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ>  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ(  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ.  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQv  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQB  PQP*,  PPP@  
P@	  PPPPPPխíPPPPPQQQ  PPPQP
NPн`FPNPPtЭppP                                                                                                                                                                                                                                                   K                        y        RPC010.B                       <	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$LLBD.EXE;1;1
1                                                                                           $                         Y             ttQpPtQpPtPpPPQQQR  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ& PPЬ$QPѭPPaaPP޼Rݭ  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b< ^޼RbV<VRRRRRЭSSS
  RRRSR1S  RSR1ެRS  RSR1RнbRRRbRRRbRRRRRRݭݭ  RRíRRRRR RнbRRRbRRRbRRRR	RRݭݭ  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ  RRíRRRRRޭRнbRRޭRнb1SSS+  RRRSRRнb=PRRЭЭRЭSЭRЭSЭRЭRRRSSS  RRRSRRb RRЭЭRЭRRRSSSr  RRRSR
Rb"PRRЭЭRЭRRRRRRRխ'PRRRRRRխíRRRRRSSS  RRRSR
 Rнb<P RRЭЭRЭSЭRЭSЭRЭRRRSSS\  RRRSRRb RRЭЭRЭRRRSSS  RRRSR
Rb"PRRЭЭRЭRRRRR	RRխ'PRRRRRRխíRRRRRSSSb  RRRSR
RнbFPRR|ЭxxR||SxR|SxR|RxRRSSS  RRRSR
Rb(PRRtЭppRttRpRRSSS  RRRSRRb&RRlЭhhRllRhRRRRRRխ%RRRRRRխíRRRRRSSS  RRRSR
ޭRнbFPޭRRdЭ``RddS`RdS`RdR`RRSSSw  RRRSR
ޭRнbCޭRR\ЭXXR\\SXR\SXR\RXP ߭ݭ߭ ݬ	 ŭЏ   RRRRRЬ$SRѭRRccRR޼Rݭ?  Pb
P޼RЬb޼S<VRRRcRRЭЭȽRRЭнRRTTRR<TRRЏ  ^(n
   RR<TRRխ1zPíRRRRRнؽRRЭR>RbRRЭR>RbRRЭRRRЭR	RRݭݭ0
  RRíRRRRRЭRޢRbRRЭR>RbRRЭR>RbRRЭRRRЭRRRݭݭ  RRíRRRRRЭRޢ RbRRЭR>$RbRRЭR>&RbRRЭR(RRЭR)RRݭݭ  RRíRRRRRЭRޢ0RbRRЭR4RRݏ@   ݭݭ  @   RRíRRRRRЭRޢtRbRRЭR>xRbRRЭRzRRݭݭ[  RR؏   RRRRխ1íRRRRRPRR޼ SíRRc޼(R b    d  `  \  X  T  P  L  H  D  @  <  8  4  0  ,  (  $                      
  
  
  
  
  
  
  
  
  
  
  
  
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @   @     @  L                                     7      X'  '  @(  '  '  '  '  '  '  '  (  x(  p'  '  '  '  '  '  '  (  (  8(  0(  X(  ((  p(  h(  `(   (  P(  (  (  '  (   (  '  x'  h'  `'       \  d  $     $   ,        
           &        `  h  x   P        (               `         L J f f f p< 6 K J J     J Z'  b'  j'  r'  z'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  (  
(  (  (  "(  *(  2(  :(  B(  R(  Z(  b(  j(  r(  z(  (  (  (      @   
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                         
RPC$LIBNCK                             '      A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A  A   B  B  B  B  B  B  B  B   B  $B  (B  ,B  0B  4B  8B  <B          A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                % * [UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1 +  , =	   .     /    4                             - !   0   1    2   3      K  P   W   O     5 	  6 ҵ`Γ  7  ϓ  8          9          G #  H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 L                        i*        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;11                                                                                                                                   0 D X     0205      (  N\N      t                                     RPC$NIDL                               RPC V1.0A-00   2N\Γ 05-05           #           4 $        X      %     [       % :     (     _     M       
       ?          !        VAXCRTL_001      !        
LIBRTL_001      !       
MTHRTL_001  Name already declared: %s
 case_%s %d %f "%s" false true c pascal unix ip implink pup chaos ns nbs ecma datakit ccitt sna dds %s
 [last_is()] attribute already specified %s
 [max_is()] attribute already specified %s
 Attribute already specified Invalid family name: %s
 tagged_union . NAMETABLE_NIL_ID true false Dumping interface

 UID
 	time_high = %08x
 	time_low  = %04x
 	family    = %02x
 	host      = %02x.%02x.%02x.%02x.%02x.%02x.%02x
 Version = %d
 Implicit handle var = %s
 Handle type = %s
 Exported Item: %s  Type = constant_k
 Type = type_k
 Type is %s
 Type = routine_k
 integer constant: %d
 real constant: %d
 string constant: %s
 enum ordinal val = %d
 named_constant: %s
 small_integer_k short integer_k long_integer_k hyper_integer_k small_unsigned_k short unsigned_k long_unsigned_k hyper_unsigned_k short_bitset_k long_bitset_k short_enumeration_k long_enumeration_k short_real_k long_real_k short_subrange_k long_subrange_k open_string_zero_k fixed_string_zero_k open_array_k fixed_array_k record_k named_k pointer_k void_k character_k boolean_k routine_ptr_k handle_k Lower bound = %s
 Array elements = %s
 Index_type = %s
 ...
 	Transmit type = %s
 	Last_is = %s
 	Max_is = %s
 	[handle]
 upper bound =  bound to type
 Referent is %s
 Set base type = %s
 names %s
 Bound to type: %s
 user_marshalled type
 Transmitted as: %s
 User type: %s
 Enumerator name: %s.  Lower bound =  Upper bound =  	Variant tag_id = %s
 Variant tag type = %s
 case tag value is  	field_name = %s
 Field type = %s
 	field_name = %s
 Field type = %s
 Array elements = %s
 	routine attributes
 idempotent = %s
 maybe = %s
 broadcast = %s
 	routine parameters
 	Routine result
 	parameter name = %s
 Handle parameter
 input parameter
 output parameter
 reference parameter
 Parameter type = %s
    Unexpected (or unimplemented) type ( ) encountered in %s ; exiting.
 .
 ( ) %s name %d is "%s"
 %d open_type #define NIDL_GENERATED
#define NIDL_ CSWTCH CSTUB SSTUB 
#include "%s.h"
 %s_ 
  ( ,  )
 {
 return  (* %s$client_epv . )( ,  );
 }
 
static    void  %s_csr 
#ifdef __STDC__
 
 #else
  ( ,  ) 
 #endif
 
static    void  %s_csr  ( ,  )
 
/* parameter declarations */
 
/* local variables */
 volatile   /*   */  ;
 
/* marshalling init */
 data_offset= ->data_offset;
 required_alignment resulting_alignment fixed_size_type remove_named_type_nodes open_delta_exp open_base_type xXx_%x_ %s%s_ %s.%s %s.%s %s%s_ %s.%s %s.%s %sipp_ %si_ %sepe_ %scv_ %sel_ (*%s) (*%s) %s[0] %s [0] *%s (%s-%s+1) (%s-%s+1) (%s*%s) (%s*%s) count (%s-%s+1) (%s-%s+1) (%s*%s) (%s*%s) (*%s) %sxmissible_p_ (*%s) %sxmissible_ (*%s) %sxmissible_ %s%s_ %s.%s %s.%s %s%s_ %s.%s %s.%s %sstrlen_ patch_node (*%s) %s_ bound += ( ) * %d;
 =  & ;
 for( = ;  ;  --){
 ++;
 }
 bound += %d * ( );
 bound += strlen((ndr_$char *)  );
 CSPELL_bound_calculation 
/* convert user marshalled types */
 _to_xmit_rep( , & );
 bound=0;
 
/* bound calculations */
 bound += %d;
 rpc_$align_ptr_relative (mp, dbp, %d);
  =  & ;
  =  ;
rpc_$marshall_ushort_int(mp,  );
 rpc_$unmarshall_ushort_int(mp,  );
 rpc_$convert_ushort_int (drep, rpc_$local_drep, mp,  );
 rpc_$advance_mp(mp, 2);
 if ( > ) SIGNAL(nca_status_$invalid_bound);
 #ifdef ALIGNED_SCALAR_ARRAYS
  =  mp;
 rpc_$block_copy( (rpc_$byte_p_t)mp,  (rpc_$byte_p_t) , (rpc_$byte_p_t)mp , ( *%d));
 rpc_$advance_mp (mp, ( *%d));
 #else
  =  ;
 for ( = ;  ;  --){
 ++;
 }
 #endif
 _free_xmit_rep ( );
 _from_xmit_rep ( & , & );
 count =  ;
rpc_$marshall_ushort_int (mp, count);
 rpc_$unmarshall_ushort_int (mp, count);
 #ifndef ALIGNED_SCALAR_ARRAYS
  =   rpc_$malloc (count * sizeof );
 #endif
 count =  ;
 rpc_$convert_ushort_int(drep, rpc_$local_drep, mp, count);
 =   rpc_$malloc(count * sizeof );
 rpc_$advance_mp(mp, 2);
 count =  ;
 rpc_$marshall_ushort_int (mp, count);
 rpc_$convert_ushort_int (drep, rpc_$local_drep, mp, count);
 rpc_$unmarshall_ushort_int (mp, count);
 =   rpc_$malloc(sizeof +((count-1)*(sizeof )));
 rpc_$advance_mp(mp, 2);
  = rpc_$malloc( );
 rpc_$ un marshall_string( convert_string(drep, rpc_$local_drep,  ,  %d,  mp,  );
 rpc_$advance_mp(mp,  +1);
 switch ( ) {
 case  :
 default:
 break;
 default: SIGNAL(nca_status_$invalid_tag);
 }
 rpc_$ un marshall_ convert_ ( drep, rpc_$local_drep,  mp,  );
 rpc_$advance_mp(mp, %d);
 CSPELL_marshall 
/* marshalling */
 if (rpc_$equal_drep (drep, rpc_$local_drep)) {
 
/* unmarshalling */
 } else {
 
/* unmarshalling */
 }
 
/* len calc */
 %s=mp-%s-data_offset;
 _unbind( , handle);
 handle =  _bind( );
 cleanup_status = pfm_cleanup (cleanup_rec);
 if (cleanup_status.all != pfm_$cleanup_set) {
          if (free_ins) rpc_$free_pkt(ip);
     if (rpc_$is_comm_failure_status(cleanup_status)) {
         *  = cleanup_status;
         pfm_$enable();
         return;
         }
     else
         pfm_$signal (cleanup_status);
     pfm_signal (cleanup_status);
     }

 #ifndef __STDC__
 #endif
 handle (*%s) *%s handle {
 
/* rpc_$sar arguments */
 volatile rpc_$ppkt_t *ip;
 ndr_$ulong_int ilen;
 rpc_$ppkt_t *op;
 rpc_$ppkt_t *routs;
 ndr_$ulong_int olen;
 rpc_$drep_t drep;
 ndr_$boolean free_outs;
 status_$t st;
 
/* other client side local variables */
 rpc_$ppkt_t ins;
 rpc_$ppkt_t outs;
 handle_t handle;
 pfm_$cleanup_rec cleanup_rec;
 status_$t cleanup_status;
 ndr_$ushort_int data_offset;
 ndr_$ulong_int bound;
 rpc_$mp_t mp;
 rpc_$mp_t dbp;
 ndr_$ushort_int count;
 volatile ndr_$boolean free_ins;
 
/* marshalling init */
 data_offset= ->data_offset;
 
/* buffer allocation */
 if(free_ins=(bound+data_offset>sizeof(rpc_$ppkt_t)))
     ip=rpc_$alloc_pkt(bound);
 else 
     ip= &ins;
 rpc_$init_mp(mp, dbp, ip, data_offset);
 ip= &ins;
 
/* runtime call */
 ilen=mp-dbp;
 ilen=0;
 op= &outs;
 rpc_$sar( 0 +rpc_$brdcst +rpc_$idempotent +rpc_$maybe ,
 (long)%s,
 &%s,
 %dL,
 ip,
 ilen,
 op,
 (long)sizeof(rpc_$ppkt_t),
 &routs,
 &olen,
 (rpc_$drep_t *)&drep,
 &free_outs,
 &st);
 
/* unmarshalling init */
 data_offset= ->data_offset;
 rpc_$init_mp(mp, dbp, routs, data_offset);
 
/* buffer deallocation */
 if(free_outs) rpc_$free_pkt(routs);
 if(free_ins) rpc_$free_pkt(ip);
 pfm_rls_cleanup (cleanup_rec, cleanup_status);

 
/* return */
 return( );
 }
 #ifndef IDL_BASE_SUPPORTS_V1
 The version of idl_base.h is not compatible with this stub/switch code.
 #endif
 #ifndef RPC_IDL_SUPPORTS_V1
 The version of rpc.idl is not compatible with this stub/switch code.
 #endif
 #ifndef NCASTAT_IDL_SUPPORTS_V1
 The version of ncastat.idl is not compatible with this stub/switch code.
 #endif
 #include "pfm.h"
 globaldef    ;
 %s$client_epv %s$epv_t globaldef     = {
 ,
 %s_csr 
};
 = NULL;
 = NULL;
 
 =   rpc_$malloc (sizeof +( *sizeof ));
  =   rpc_$malloc (  * sizeof );
 if (  != NULL) rpc_$free((char *) );
 if (  != NULL) rpc_$free((char *) );
 CSPELL_dealloc_param _free ( );
 & (  *) 
/* server call */
 = (*manager_epv-> _ ) ( ,  h &h );
 cleanup_status = pfm_cleanup (cleanup_rec);
 if (cleanup_status.all != pfm_$cleanup_set) {
     if ( != NULL) rpc_$free( );
     if ( != NULL) rpc_$free( );
     pfm_signal (cleanup_status);
     }

 
static void  %s_ssr 
#ifdef __STDC__
 (
  handle_t h,
  rpc_$ppkt_t *ins,
  ndr_$ulong_int ilen,
  rpc_$ppkt_t *outs,
                                                                                                                                                                                                                                                   M                           6                                                                              mv
ws  1                                                                                                                              j      u2|m
A`L/ϩ)58cZ%1>6BNÔ	Idz˪Ő;QwȤD1ש=E(
]O;M=ӥ~)-
`
moy>B
 sp niǵaR!A)
ճ^:"{Znǽf_,Edbּ}kWPI:	sN5ծs6qtE%e7v~EE ?K	FaD_:ȾIhZHX&1ɯl7;8R{Ǘ5%\ɾ:هµLLq͸s
CҟL6F]_k{өDkE̖U^(b;j]}C6F[0ߣLLUNڔts+E7' v[/4 5@z&KS:,dYSڟr*0@8jS 
mW +ޛL&!~0_Prf?
-_9Ajxn+7蹙ʏ:	@j]Xh?j!ɭ5߅w]diح_كI"-0`El> e\:(&D6n(H~"ɂy<bAd5ovs^}PWA$l	ޞ-= e;'XpU+2CK:$*Zk.,G'@>#n{8%@Z[_I_"2?</p=Д
->Y0.<@J/K,kt9Hͳԗ"Nfw߳SmTA*iu,bG5_Pr~/2Œ!jD	fqj
N)9NJ 3XPH47W8.}u

ĕEiL
T&y@YCo{ξlO<e,5݀eh0+=駑84lݧ^ @%禎xQ(&U>]]tF}}i3ѱrJ|#)@|R:~i	C k~."Lgsw8*̽#
ʱ	Q#בAja2|YS]sW.M_͏Aˀ"fl ڦ V>{>
./YK:)
DTcwAuTQhdZsLIb\O<a 쓃`T;Ng<  5bx>

x[u
Xpw3 kSξ8*+:5Ŏ[^1X/S`HJw9|hpVXfm ՠ\7E92p#;.7$kOa3_4 $(=WQ]_Vu4͏z!w%@bJ6КӱFs\čLDM74k2B:Q*cS!?M,dr[,E,TGSЋS;ogIlуFY"h{~bxmqpڗr%`MqӲh/
^n(ak/l?y%syXZ=+Eٜt3wldRz9
=3wtC^Lrv^T]9+i3~j%%Z^4]=07tՏb_7O?ݵ4gϖ!/Ocm03OPW"aQ_4s9mlj\9`$nb4R
#Zހ/}4V6T#7!/]!W*~VU |no#O4DRo
7D,1p$qQVMqbE#iM^m}

qnN'T!I%"; b,>
T2.%lpQ?t~#Ƭ
pIȟ`{֟C
D32ԓꫭC:R&,+a,IDԩ]]?R9Kԉ|l57!tjj؉6BcԖb)rH_b\(iw nU<D_FWӾ+sy>=~dZyoXjѷ 3efmuX)FX7ደ0/V >O@FdI4$(G&eG^ql1+b)TL=늜Hp{,ykOP$l	_o㟷ήEnvXͥ4e06eX1xw(˃7`A8>ےwa|-\7 PǓ
LU%OLGP(cKt{9PEw
o-VIK5RkBm+$
wAt+}0ϒ_[SjF",Zx
DW\'ͩ$7]ǧ@z;s|RŎ#"Gd@b?t>f۾{
|9Xk%A7\[tOQ@m~P{n>E`W[APL-j%[U!k؀vrJEoF\*@uIڡMM*~14y$љCҝ#/ AuIsT;^RAOEh
֎}p-fɶ@0uvFUcYnϞ(3Aݲ&`hrt=PsqWUU6}V=~\HkZXJfIs[Zoџ]vW.MoCqto]	ӎ~QP0gt,4+5*1(?/5da4խ<h2߬+d)ъuKVW#a$Y]SZ/lQ -lwg0G(r 6%1}3c<~hsؾ(YI\LUUW)}^ݼӵYtk"? ͱNv\1q?"-~Zgi<&J/W&pQ@LXmT|d[M)刎V1}8rQqUxsJTD=㢣1V*`w#QIYp*ϟ*٢G{4-qYc7oCMz}膁D*= Rפ:cfzf`阈fWh";\)X7>lt?.SQ'9O	/
OURܱzpjSUf}{~sya1hx%СX.aIΊ!5Q>4JkS-܇5QWry(ajPAc}y!|UT4TIJм@?YcU|Yd- ey]%KPqvU3^!dLzQ:v֚紜 _(^Mk')2T9I	szn0DAYf`ix?WY޶'u0FFַ
0ҌYz0TE
T=	-ģĚ+tjis%X4W`
UЯ3#ZOȃj#9=9oũb#?`9?k@wZ]4ٹEQ
yWCh8KGR&X}3חH/H1@x
T
Qϑ߈0BS!4 {B^\ûmgPuT^)_RM=fDHGEK	j:FTj0ZGZt ȣm	C jLPv(cn{aQ;0GdS#[nؐ0V-zt07af!{ѠLO蟏}/@TA.NMwtʎU4؁U-ҹ
eo
qwE9ӂxˋ74[ 'CGm9xx˷RI.!eE`Vْ
MuHxY
K@`002W0S&1 ?xv.X3qZ1~R~P"&eydBH*-c7 ,~+X6LDYa6\5#~AۍsV+0fauM
Yq.Jԕ䑎=<Ү
i|'I~01)mUn J`e2q7tݟNXH#OpX1CɰQ.7%5|1p+$F
u$@}۵}qBu{R|; $qBƼb><|8I`fc./&93nvS*$2P동rIA0B`c\.wDjWe掩jȖ3Eew?Q%=] >鱨&89X`uh̼/p
17	hDL$+V!O\-/SƲ!
bbd%E665RvWf!>f
vvvMA>2[RfhޯxG~,](>b<)Dܚ_89eB
{b,8xpvS
1h``J2RjӚvʎ}~P{'O|E3vHH]n
Jf%ÃBeb_mT.
^ΒKo(vbvf; ~DzMm#~V
k	&a
Y	oJi1xx`!]傮SҚĉ?э5)fv;rܥ^UCUeF2[KEXo31!N,b84S5.ň/(-
Gp|T]ژ*4.nP8*
Qw8=s%ʪ#1?WyRxw>vhZ?QxpF>N!nRp^4yiE=@ C*oR%xu߿QYYv^vuSpR{\yVa?^v0dv'4ҘHvj172N[JՑ\Yg2tM:P=IMƋDw\FM^~l^9J77?B.uE_6ם#DȊE{q->GgUng.̄B`]A2OC@H>y(V(6xZ?LURilrwB{>:N>2JT$>ݙZڜ7aCv^ߦI}ϟ1vtwkG1^V#/"mN{+ih~~>~AI9L7&^ZSij`甙NrKYlsZH51ssuǗbyh5ǘ8nk
CxDX{ byoQ4qNdt5#t,.gIL3x=>
.ꔌ
cXdHhkiE@YF7הE!tH`vp'6Б6~+%6>ont1D~/gTr]-,M+ս	S= /%&aHߗPf=~B"5/;-HaΊ֢DGr"{1tdercwXM9AT[Q6&8
AKF+XLuaV51q^ϋ%қ&Gj	[P߿0s?7-.ބ
	9sM808ԑ:8?c TCa:Sy)l;V'upeh!@GFO$!%Tц^[b3_	cF_&	r"ጙMɷ,&bgVT7Y;PD|Nh\n 3A;l
uQaU5G{pUՈ)oVCw>X`5soL$^P.B3֗,{htWk&k}^Y{x$4^QIq1uBGntq7LCîgb>Nh4uTl^_W)

WR*;]<	j<يM*~Rvb*.{ʋ($f°i/U.Nb)*+*CeO>&=cj
w{֖5(8n$?!M3}fL85}.l-O1uvu%rG6	~+~Ը:!@
ᵸsM-ӭ9"Qmڄ+Ou.Ж^eoӋmBP.w܆)ta`iԵ)k^/Nf(rC!ų*@~a&5#Ț.=RQL_@Ju Sπ|y|&DZvA$Qf3.Ƶph=ܪsY9ۨ1۹m5XsV(UQ-i3`_3L@^MZJ`b|BmZD|Rl0X@kg
o?{ZV7t&d!Q</&)Z67'0
ZCwc'=+WΡ}H|ʤW>,Zw&|R
aLQsW3dxȤT⢫#~ЊY5MT6_~pja|^2i=n,;|L!E<ϲ97ySuX~`%ST/%ؖE<
 tx'b2*$sPnRj
N \M;~8H8(gXےt9ٝzB+S|euTE`F])5oVųq'(Ԏ2AjC)1X09څ
wkOhO
<9%Ý'Vb;_st]O fi-굱W1Xhٕi?b!ׁc^uR<R3	Pa9FmZg/&ܮc(<p73np9`T`?8_`B93Վ8]%tNL,anWIuRy`m?4ZK;$yQ(O)_VBXdIA<ƪZ)M1"!JZR[%
elmLh^r+| bhmz7BИsMJF>hdVnUϞ?I3*HS~Ŕs/ANNVGHcgԣ۽;_#h;r                                                                                                                                                                                                                                                  N                        2j        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1;1                                                                                                                                   ndr_$ulong_int omax,
  rpc_$drep_t drep,
    *manager_epv,
  rpc_$ppkt_t **routs,
  ndr_$ulong_int *olen,
  ndr_$boolean *free_outs,
  status_$t *st
)
 #else
 (
 h,
 ins,ilen,
 outs,omax,
 drep,
  manager_epv,
  routs,olen,
 free_outs,
 st)

 handle_t h;
 rpc_$ppkt_t *ins;
 ndr_$ulong_int ilen;
 rpc_$ppkt_t *outs;
 ndr_$ulong_int omax;
 rpc_$drep_t drep;
  *manager_epv;
 rpc_$ppkt_t **routs;
 ndr_$ulong_int *olen;
 ndr_$boolean *free_outs;
 status_$t *st;
 #endif
 
{
 
/* marshalling variables */
 ndr_$ushort_int data_offset;
 ndr_$ulong_int bound;
 rpc_$mp_t mp;
 rpc_$mp_t dbp;
 ndr_$ushort_int count;
 pfm_$cleanup_rec cleanup_rec;
 status_$t cleanup_status;
 
/* unmarshalling init */
 data_offset=h->data_offset;
 rpc_$init_mp(mp, dbp, ins, data_offset);
 data_offset=h->data_offset;
 
/* buffer allocation */
 if(*free_outs=(bound>omax))
     *routs=rpc_$alloc_pkt(bound);
 else
     *routs=outs;
 rpc_$init_mp(mp, dbp, *routs, data_offset);
 
*olen=mp-dbp;
 
/* buffer non-allocation */
 *free_outs=false;
 *routs=outs;
 *olen=0;
 
st->all=status_$ok;
 }
 #include "pfm.h"
 %s$epv_t %s$manager_epv globaldef     = {
 ,
 _ 
};
 %s$server_epv %sa 
static rpc_$generic_server_stub_t  
static rpc_$server_stub_t  []={
 ,
 (rpc_$generic_server_stub_t) (rpc_$server_stub_t) %s_ssr 
};
 globaldef  rpc_$generic_epv_t  rpc_$epv_t  =(rpc_$generic_epv_t) =(rpc_$epv_t) ;
    Too many imported files open_type %s
 [last_is()] attribute can only be applied to array types %s
 last_is variable does not exist %s
 last_is variable must be a scalar type %s
 last_is must be a scalar
 %s
 [max_is()] attribute can only be applied to open array types %s
 max_is variable does not exist %s
 max_is variable must be have scalar type %s
 max_is must be a scalar
 File: %s not found %s
 tag type does not agree with discriminator type %s
 tag type does not agree with discriminator type %s
 tag type does not agree with discriminator type %s
 Invalid tag type %s
 open arrays illegal in unions or variant records %s
 Only top level pointers are allowed in NIDL %s
 Only top level pointers are allowed in NIDL %s
 Enumeration is invalid in this context %s
 Invalid array index type %s
 Enumeration is invalid in this context %s
 Array elements cannot be open arrays %s
 Array of pointers requires a transmit_as %s
 Enumeration is invalid in this context %s
 Array elements cannot be open arrays %s
 Array of pointers requires a transmit_as %s
 Records containing pointers require a transmit_as type %s
 Open field must be last in record %s
 last_is required %s last_is must be applied to an array
 %s max_is must be applied to an array
 %s
 Sets can only be over enumerations %s
 Short bitsets can only have 16 elements Subranges must be integer or enumeration
 Subranges must be integer or enumeration
 Lower bound must be less than upper bound
 %s
 reference types can only be used in parameters %s
 rpc_$drep_t type can only be used in local interfaces %s
 last_is must be input parameter %s
 max_is must be an input parameter %s
 type must be a handle %s
 [out] pointers not allowed
 %s
 This type requires the [transmit_as()] attribute
 %s
 Records/structs containing open arrays must be [in] or [in, out]
 %s
 Records/structs containing open arrays must be passed by reference
 %s
 variant records/structs containing open fields are not allowed
 %s last_is must be applied to an array
 %s max_is must be applied to an array
 %s
 Handle parameter required %s
 Handle parameter must be an IN parameter %s
 MAYBE routines cannot have output parameters %s
 Out parameters must be passed by reference. %s
 This type requires a last_is attribute %s
 This type requires a max_is attribute %s
 Handle_t legal only in first parameter position. %s
 Too many [comm_status] parameters %s
 [comm_status] parameter must be an out %s
 [comm_status] parameter must be of type status_$t status_$t %s
 [comm_status] parameter must be of type status_$t Constant name: %s not found
 Not a constant: %s
 Name: %s is not a type.
 Type name: %s not found.
 (Warning) Type name: %s not_found.
Type void* assumed.
 Interface uid must be specified
 rpc.idl   NULL ndr_$true ndr_$false %d %f "%s" %s record_type typedef struct  %s$epv_t  {
 }  ;
 %s$client_epv globalref    ;
 %s$manager_epv globalref    ;
 globalref rpc_$generic_epv_t  globalref rpc_$epv_t  %s$server_epv ;
 * (* (*%s) 
#ifdef __STDC__
 
#else
 () 
#endif
 %s ) [1] [%d]     ;
 ;
 %s #define    
 ,
   /* case(s):  ,   */
 struct {
 }  ;
 u boolean byte small_int short_int long_int hyper_int char short_float long_float ndr_$ ndr_$char ndr_$char rpc_$drep_t handle_t struct   {
   ;
union {
 }  ;
 } void enum { } void * CSPELL_type_exp typedef struct    ;
 typedef  struct  ndr_$ushort_int ndr_$ulong_int #define  _mask_none (%s) 0
 #define  _mask (%s) 0x%x
 typedef  #define   ((ndr_$ushort_int) 0x%x)
 typedef  typedef    ;
 #ifdef __STDC__
 handle_t  _bind(  h);
 void  _unbind(  uh, handle_t h);
 #else
 handle_t  _bind();
 void  _unbind();
 #endif
 #ifdef __STDC__
 void  _from_xmit_rep(  *xmit_object,   *object);
 void  _to_xmit_rep(  object,   **xmit_object);
 void  _free(  object);
 void  _free_xmit_rep(  *xmit_object);
 #else
 void  _from_xmit_rep();
 void  _to_xmit_rep();
 void  _free();
 void  _free_xmit_rep();
 #endif
  (
 ,
   /* [ in, out in out ] */ void ) extern     
#ifdef __STDC__
 ;
 #else
  ( );
 #endif
 %s$if_spec static rpc_$if_spec_t   = {
   %d,
   { ,  %d },
   %d,
   {
   0x%08.8lx,
   0x%04.4x,
   0,
   0x%x,
   { ,  0x%x }
  }
};
 %s_included #ifndef  
#define  
 #include "idl_base.h"
 #include "$(%s.%s).h #include "%s/%s.h #include %s.h #include "%s.h "
 globalref    ;
 #endif
   "" ./ file %.*s ,  line %d of file %s  <eof> of file %s  near "%.*s" :  [error %d]  syntax error
 
file %s: ( %d ) %s****  ****  r File %s: %s
 %s
 error: %s on line %d of file %s
    Name not found: %s . Unable to open %s for %s access
    _CSTUB.C,_SSTUB.C,_CSWTCH.C nidl.tmp ansi confirm def dump_after dump_ast env exts f77c f77s idir m nametbl no_def_idir no_stubs no_warn out pascal s space_opt ungraceful version yydebug r w unable to open %s.
 File: %s not found usage: NIDL fileName [flags]

 nidl version 1.5.1
 -ansi is no longer needed.
 Should specify -s or -m; assuming -s.
 Cannot specify both -m and -s.
 rpc$idl: [] idir %%s_v%d .h .ins.pas   Illegal option ftype in getflags: %d
 Unknown flag (%s) in getflags
 Options table:
     %-*s 	illegal option in printflags: %d
 	%d 
 	%s 
 	%s No Yes 
 	%s Yes No 
 	%c 
 	%.3f 
 	%D 
 
    Symbol table overflow
  too many scoping levels
 Can't pop symbol table
 


id = %s
 Bindings for id @ %Fp
 ------------------------

 	bindingLevel = %d
 	theBinding = %x
 	nextBindingThisLevel = %x
 	oldBinding = %x
 	boundBy = %x

  %s$if_spec var
  : rpc_$if_spec_t := [
   vers := %d,
   port := [ ,  %d ],
   opcnt := %d,
   id := [
     time_high := 16#%x,
     time_low := 16#%x,
     reserved := 0,
     family := chr(16#%x),
     host := [ ,  chr(16#%x) ]
    ]
  ];
 nil true false %d %f '%s' type
 const
 var
 %%s_%d_t  =  ;
 NIDL internal limit exceeded: MAX_ANONYMOUS  =  ;
  :  ;
 ,
   ,   :  (
 );
 ^ function  procedure   :   ; options(val_param, extern) integer8 integer64 unsigned8 unsigned64 boolean char integer integer32 set of  .. unsigned unsigned32 char real double array [ ] of char char_ptr rpc_$drep_t handle_t array [ ,  ] of  array [ .. ,  ] of  record
 case   :   of
 end ^ ( ) univ_ptr pspell_type_exp function  _bind (in uh:  ): handle_t; options(val_param, extern);
 procedure  _unbind (in uh:  ; in h: handle_t); options(val_param, extern);
 procedure  _from_xmit_rep (
   in  xmit_object: univ_ptr;
   out object: univ_ptr
 ); o                                                                                                                                                                                                                                                   O                        .n        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1
1                                                                                                                                 ptions(val_param, extern);
 procedure  _to_xmit_rep (
   in  object: univ_ptr;
   out xmit_object: univ_ptr
 ); options(val_param, extern);
 procedure  _free_xmit_rep (
   in  xmit_object: univ_ptr
 ); options(val_param, extern);
 procedure  _free (
   in object: univ_ptr
 ); options(val_param, extern);
  = %d;
  =  ;
 (
 ;
 in out  in  out   :  univ  
) ; options(val_param, extern, d0_return);
 ; options(val_param, extern);
 function  procedure   :  ; options(val_param, extern);
  : extern    ;
 %s$epv_t  = record
  :  ;
 end;
 %s$client_epv  : extern  ;
 %s$mgr_epv  : extern  ;
 %s$server_epv  : extern rpc_$generic_epv_t;
  : extern rpc_$epv_t;
 %s_included %%ifdef   %%then
%%exit
%%else
%%var  
%%endif
 %%include 'idl_base.ins.pas';
 %%include '$(%s.%s).ins.pas %%include '%s/%s.ins.pas %%include '%s.ins.pas %%include '%s.ins.pas ';
 Out of memory
 boolean_k byte_k character_k fixed_array_k fixed_string_zero_k handle_k hyper_integer_k hyper_unsigned_k long_bitset_k long_enumeration_k long_integer_k long_real_k long_subrange_k long_unsigned_k named_k open_array_k open_record_k open_string_zero_k pointer_k record_k routine_ptr_k short_bitset_k short_enumeration_k short_integer_k short_real_k short_subrange_k short_unsigned_k small_bitset_k small_enumeration_k small_integer_k small_subrange_k small_unsigned_k user_marshalled_k void_k unknown  %ld %lx %lx bad switch yylook %d unexpected EOF inside comment at line %d
 ARRAY array BOOLEAN boolean BYTE byte CASE case CHAR char CONST const DOUBLE double END end FALSE false FUNCTION function HANDLE_T handle_t IN in IMPORT import INTEGER integer INTEGER8 integer8 INTEGER32 integer32 INTEGER64 integer64 INTERFACE interface NIL nil OF of OPTIONS options OUT out PROCEDURE procedure REAL real RECORD record REF ref rpc_$drep_t RPC_$DREP_T SET set STRING0 string0 TRUE true TYPE type UNIV_PTR univ_ptr UNSIGNED unsigned UNSIGNED8 unsigned8 UNSIGNED32 unsigned32 UNSIGNED64 unsigned64 VAL val interface import typedef const struct union bitset enum set int byte char unsigned hyper long small float short void double boolean case switch string0 handle_t rpc_$drep_t true false NULL BROADCAST broadcast COMM_STATUS comm_status IDEMPOTENT idempotent HANDLE handle IMPLICIT_HANDLE implicit_handle in LAST_IS last_is LOCAL local MAYBE maybe MAX_IS max_is out PORT port REMOTE remote SECURE secure TRANSMIT_AS transmit_as UUID uuid VERSION version # %d %s Too many %%includes
 r Couldn't open include file %s
 %8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx state %d, char 0%o
 yacc stack overflow syntax error error recovery pops state %d, uncovers %d
 error recovery discards char %d
 reduce %d
 Too many ports
 @(#)astp.c	2.1     (ultrix)        6/13/89      %W%    (ultrix)       %G%              @(#)checker.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                       @(#)cspell.c	2.1     (ultrix)        6/13/89    @(#)errors.c	2.1     (ultrix)        6/13/89                            @(#)files.c	2.1     (ultrix)        6/13/89 @(#)frontend.c	2.1     (ultrix)        6/13/89      5         5                                                                                                                                                                                                      -5  @(#)getflags.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @(#)main.c	2.1     (ultrix)        6/13/89  @(#)nametbl.c	2.1     (ultrix)        6/13/89                                                                                       M                                                                                                                                                                                                                                                  @(#)pspell.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                                                                                                                                                       @(#)sysdep.c	2.1     (ultrix)        6/13/89                                                @(#)utils.c	2.1     (ultrix)        6/13/89                                                 A    A    A    A    A    A    A    A    A    A    A    A    A  	  A  	  A  
  A  
  A  D  B  D  B    B    B  ?  "B  ?  +B    .B    1B    8B    ?B    GB    OB    XB    aB    kB    uB    B    B    B    B    B    B    B    B  =  B  =  B    B    B     B     B  "  B  "  B  !  B  !  B  ;  B  ;  B  >  C  >  C  $  C  $  C  %  C  %  'C  C  ,C  C  1C  '  6C  '  ;C  F  DC  F  MC  *  VC  *  _C  +  iC  +  sC  ,  ~C  ,  C  -  C  -  C  <  C  <          C    C    C  7  C    C  8  C  )  C    C  9  C  $  C  :  C    C    C  *  C  /   D  0  D  5  D  2  D  1  D  3  D  	  #D    +D    0D  6  7D  %  ?D  ?  HD  >  TD  C  YD  D  _D            dD  E  nD  E  xD    D    D  
  D  
  D  @  D  @  D    D    D    D    D    D    D    D    D    D    E    
E    E    E    E  #  "E  #  )E  4  0E  4  7E  B  CE  B  OE  (  TE  (  YE  .  aE  .          @(#)yaccpar	4.1	(Berkeley)	2/11/83                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         65    ]  ;5    S  C5  J    G5    U  R5    T  [5    { _5     d  d5     _  i5     `  n5  J  h  s5     a  u5    c  }5     \  5     { 5     ~ 5     X  5     ^  5     b  5     ȱ  5    { 5      5    @                                                                                om                                                                                                                                                                                                                                                   P                        T        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1  1                                                                                                                     F1      .       967 +*  v r ne_C      ;   pS2 L t     AE M + 'B %$ -     tfL L   D   NO      ;    KLJ  t1F L       <        , N   t     A    K  K E  t Ep t./    J m :  t s ^ B 
    QPU   HG(  % (}~ I((     3     44  F  kT  RO    LI&
 {j\ 	3] \         [T- . , iW )  SV   U        q c -,b   / 3 7 6 5 ( / 
4 V *  1 0   \ 5  A   Z  F H e Z~ J - . , A)        z  A  3 PK 87   ( / 74 6  *    1 0 J  xB  h\ )\      Q   >? g(F "q     z Y &d  { ]  :@`>a _   !    y ` # ;#51*)( | $Y Y b.c02 w   7 6 5  :4 g :=<@:CD::=    M v  Y      
  u A 	  U o  l 9 x     P   - . , =  ? ) Q N @      X   2          [ B?    3 = 9 7   ( / + 4     *    1 0  - . , ' i h ) & % a j $ \  # " r !    [ [         - . ,    )  3  T S R 7   ( / h 4 O }   * - . , 1 0 W )  M   " 3 [ !\ 7   ( /  4    * w H 1 0  3 I G 8u7 6 5 ( / 4 sV l*  
1 0     
|'\     	Z - . , y)  0dEG    ^ YD X- . , C n k ) Rq > 8    f 3 < WW 7 6 5 ( /  4     *     1 0     3         7 6 5 ( /   4         *      1 0                                                                 M(.UHPNANNRLU2	:3?>*510/UW'V 7nUMGU:*QHGQ
UUUU 4
EORRRVU8901%)UoNml4
E*+,-"	?>UFQMRJJRHRNGHRyxwUvutsSpTN@BLL|L99M6UUokjHPQWWUVCDUNK!$%=URGHMrqUSToUSHNNN{zU||WUVCDNJoQHiyilPRR@BUIM UMNRQRGU;RyPSqMUUUUUUUUOOOHPjyhg}yHNNNQH
RUGHUH;RrPPQQQQR~}RGzUHNNUUUPHPHIGGUHNNPQHHrRHRQg}UUQQQSGUURU}UQQPQQGHNUQGRQRNQRQRRQRQRR                    0102                                    	

 !##.(3"&1&2")4+5,6 









///8111239&14:5;6<9>:?;@<A>C?D@EAFCHDIEJFKHMJNST//VW1/YZ\]2122_`bcefhikl        2/   $%                  										  $    						        &&&&&&&&&&                    						'          (            )                ----------*          +------,""""""""""""""""""""              """"""""""""$/  ------$$$%                                """"""""""""  $/  $/    $/                $0-7-7-7-7-7-7-7-7-7-7            $/-7-7-7-7-7-7....................              ............      -7-7-7-7-7-7            7=7=7=7=7=7=7=7=7=7=  ............7=7=7=7=7=7==B=B=B=B=B=B=B=B=B=B              =B=B=B=B=B=B      7=7=7=7=7=7=            BGBGBGBGBGBGBGBGBGBG  =B=B=B=B=B=BBGBGBGBGBGBGGLGLGLGLGLGLGLGLGLGL              GLGLGLGLGLGL      BGBGBGBGBGBG            LOLOLOLOLOLOLOLOLOLO  GLGLGLGLGLGLLOLOLOLOLOLOOPOPOPOPOPOPOPOPOPOP              OPOPOPOPOPOP      LOLOLOLOLOLO            PQPQPQPQPQPQPQPQPQPQ  OPOPOPOPOPOPPQPQPQPQPQPQQRQRQRQRQRQRQRQRQRQR              QRQRQRQRQRQR      PQPQPQPQPQPQ            RSRSRSRSRSRSRSRSRSRS  QRQRQRQRQRQRRSRSRSRSRSRSTUTUTUTUTUTUTUTUTUTU              TUTUTUTUTUTU      RSRSRSRSRSRS            UVUVUVUVUVUVUVUVUVUV  TUTUTUTUTUTUUVUVUVUVUVUVWXWXWXWXWXWXWXWXWXWX              WXWXWXWXWXWX      UVUVUVUVUVUV            XYXYXYXYXYXYXYXYXYXY  WXWXWXWXWXWXXYXYXYXYXYXYZ[Z[Z[Z[Z[Z[Z[Z[Z[Z[              Z[Z[Z[Z[Z[Z[      XYXYXYXYXYXY            [\[\[\[\[\[\[\[\[\[\  Z[Z[Z[Z[Z[Z[[\[\[\[\[\[\]^]^]^]^]^]^]^]^]^]^              ]^]^]^]^]^]^      [\[\[\[\[\[\            ^_^_^_^_^_^_^_^_^_^_  ]^]^]^]^]^]^^_^_^_^_^_^_`a`a`a`a`a`a`a`a`a`a              `a`a`a`a`a`a      ^_^_^_^_^_^_            abababababababababab  `a`a`a`a`a`aababababababcdcdcdcdcdcdcdcdcdcd              cdcdcdcdcdcd      abababababab            dededededededededede  cdcdcdcdcdcddedededededefgfgfgfgfgfgfgfgfgfg              fgfgfgfgfgfg      dededededede            ghghghghghghghghghgh  fgfgfgfgfgfgghghghghghghijijijijijijijijijij              ijijijijijij      ghghghghghgh            jkjkjkjkjkjkjkjkjkjk  ijijijijijijjkjkjkjkjkjk                                                    jkjkjkjkjkjk                 	                    
                                                              # $                                                             ! %   " .                                                                ;F  =?@AB  ? @ A B C D E F G H I J K L M N O      &   / P        P         "#$%&'(                                          :  D    <   
     ( ) * + , -   P 2   : ; < = > V W X Y Z [ \ ]       P                             P      34)      7,                	                        9C    H    > ' 0 1   4     8     R T   P e      h k o   x P   z     P           P           !/    5  *+.-           
                  EG  KLOPQ    I3         Q   U       b d    g i     q P x l     t     f                   1068           J      5       S   P   P   P j p P   r y s                2  
MN    6 7 9 P   P c a    P u         ^   `     v w P m {       _ |     n                     }     ~                       I) N                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Q                        s        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1;1                                                                                                                    k^      =                                                                                                                                	
	"$'0000000000AAAAAA$$$$$$$$$$$$$$$$$$$$$AAAAAA$$$$$$$$$$$$$$$$$$$$                    k >i8 e  d c >Xc  g    / bY$feB &  @dO  ( cy  b Y F  33 } | {  w  LJO   $   u ;]O "  _ \ U ^{ { S  O s  $   r !n DL  k  3)> 90&#  
u] v = # @3I3 J H G FC C -N  EF #> "  
 
 	 3;3  5 4       !  3 ) > > IFF?F E#> ; F   Z w( SBqr  {yxwvtki h uen{dc}`_^Ym k W V  QOML HG?>20.(&
  $       !   # -
o	  
 | t  i   j .  	 ve i 
             	  
 
                                            ! ! ! !   " " " 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 
 $ $ & & ' % # # # # # # # # ( ( ) 0 1 1 2 * , + 3 3 3 3 6 5 5 4 4 8 8 : ; ; < < 9 9 = 7 7 > > > > > > ? ? @ - - . /   B B C C C E E G F H H   I I D J J K K K K A L L L M N P P Q O O S S S S T T T T R R R R  U W X Y V V V [ [ \ Z Z ] ] ] _ b b b b b b ^ c c d f f g g g g a a          h h h h h o i i w w w w x x x x j j j k l m n q p r y s { { | | } ~ ~  z z          t t t      u u u v e e                        ` ` `                                                                                                                                                            	                                                                                                                                                                                                                                                                                                                                                                                                                                           &         &      <      $   ,               $      6               $      $     $ $     , Ҍ         B         N         6   4 8   < $   D $     L $     T $     \ $     d $     l $     t $     | $               (         $      $      z         $      $            `             $ 4   Ȭ     $     Ļ B                  $     ̻ N         j         8         f     Ի  4      4      4      4 ܻ Ȍ                           p                  $               Ԍ                                                                        ,                  ڌ                           Z                  $               $               $      $      Ԑ                   N                  6         ȑ                  :         B                  >                           @         6                  |                           ~         *         v                                                      j         ƍ         $                                                                                                                                                                                                                              6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           
                                                                      	                     
                                                                                                                                                                                                                                                                                                                                                               R                        ,F        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1
1                                                                                                                    }      L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ^y PЭPЬ ЭP ЭP P  ^ЬPՠЬPЬ޼PЬ`ЬPЬPްPЬ`ЬPЬ P  ^ PЭPЬЭPЬЭPЬЭP ЭP ݭݬ+  P(߭ݬ  ݭCJ  P  ^	  PЭP P ^BSJ PЭRլ
ЬPP$PߣЬP=   P7  PЭЭPЬЭPЬЭP ЭP  P ^CBRЬQСPP# N ~    "?P1 ЬPРPЬPݠߢ#H    PPЬPPPP~ߢ&oH  l  PP߭ЬPݠ  ݭߢ)5H  2  PP ЬPޢ4PPPޢ.PP  PPP< ^ PoЭS޼R(bЭR ЭR  P  ^ЬPՠЬPЬЬPЬЬPЬPРPЬЬPЬ   P  ^ЬPՠЬPЬЬPЬЬPЬPРPЬЬPЬ   P  ^լ
ЬЬPЬPՠ;ЬPՠЬPЬЬPЬЬPЬQЬPРЬPЬЬPЬPՠ(ЬPՠЬPРPЬЬQЬPРЬPЬPРPЬЬPЬ   P  ^լ
ЬЬPЬPՠ;ЬPՠЬPЬЬPЬЬPЬQЬPРЬPЬЬPЬPՠ(ЬPՠЬPРPЬЬQЬPРЬPЬPРPЬЬPЬ   P  ^ЬPՠЬPЬЬPЬЬPЬPРЭPЬЬPЬ  P  ^ЬPРPЬЬQЬPР   P  ^ЬPՠ;ЬPՠЬPЬЬPЬЬPЬQЬPРЬPЬЬPЬPՠ(ЬPՠЬPРPЬЬQЬPРЬPЬPРPЬЬPЬ  P  ^ЬPՠЬPЬЬPЬЬPЬPРPЬЬPЬ   P  ^]
 PЭPЬ P  ^1
 PЬЭPЬЭPЬЭP ЭP ЭP ЭP  ^ЬPݠ޼P`PЬPРխ;ЭPݠݽPݭݭPЭPРխP  ^޼P`  PЭQЬPРЬPРխ?Pݽ  PЭQЭPРݭݭPЭPРխP  ^޼P`	  PЭQЬPРЬPРխ?Pݽu	  PЭQЭPРݭݭePЭPРխP  ^ЬխRЭP'	ЭP)ЭP'(ЭPРPѠ ЭQЭPРPРЭP*ЭPРխP  ^PЭP ЭP ݭ ݬPP  ^ݬ  P Ьխ=PЭPްP`PPЭPЭЭQPPPPЭPРխѭ   ЭPЭP $ЭPЬЭQPPЭ  P  ^ E
 PЭPЬЭP ЭP ЭP ЭP  P  ^)  PЭPЬ ЭPЬP  ^ЬPРЬPРPРЬPРPРЬPРPРЬPРPAЬPРP ЬPРP ЬPРP ЬPРP AЭPP " zzz.zN
P?P1YЬPРPѠ$ЬPݠЬPݠPC$:  PЭQЬPРPРЭRЬPРPݠ ЬPݠP ЬQPP1PЬPРPѠ$&ЬPݠЬPݠ+  PKP$  PЭQЬPРPРЭRЬPРPݠ ЬPݠ;  P ЬQPP1LЬPРPѠ$*ݏ    PЭP ЭQЬPРH$"  PЭQЬPРPР   PЭQЬPРPР ЭPЭ ЬQPP1 PЬPРPѠ$*ݏ    PЭP#ЭQЬPРH$
  PЭQЬPРPР#s
  PЭQЬPРPР ЭPЭ ЬQPP/PЬPݠЬPݠ  PЬQPPPЬPРPЭЬPРPЭЬPРPЭЬPРPA     ^5PЭQ3PPP P  ^y P'ЭP ЭP ЭPЬЭP  P  ^
5 PЭP ЭPЭЬЭPЭP  ^-  PPPЭPwЭPЬ ݏ   ݭPЭP| ^-6Vﺲ\   P, ߦ9  P ߦ;  P靈 lR b  ЭR B	(lݏ   ߦB`  Pݏ   ߦGG  Pݏ   ߦJ.  P+ݏ   ߦR  Pݏ   ߦV  PѮݏ   ߦ\  PＱݏ   ߦ_  Pݏ   ߦc  Pݏ   ߦh  Pyݏ   ߦp  PPݏ   ߦvf  Pݏ   ߦzM  P2  ^PЭPЬ P  ^M\JPP  = a  PF?P1 l	  P	  Pll	  P	  PHl	  P		  P$l~	  P
n	  P lP< ^ݏ    PRRЭRЭRЬЭRЬЭR(ЭR (ЭR ,ЭR ´ P  ^=PЭPЬЭP  P  ^  PЭPЭPЬЭP   P  ^+I PЭP ЭP ЭP ЭP &ЭP 'ЭP )ЭP $ЭPЬ P  ^   PЭPЬЭP  ЭP ! P ^-2R&TSc-ЬPՠ ߢ~޼P`z  ЬPc cd0ЬPՠ® ª ޼P`H  
PЬPd d  ^ݬrЬխЭPЬЭPРխ   P< ^=U2TSPRQЬխ8PЭPa%ЭPb&ЭPc'ЭPd(ЭPe)ЭPРխʐ a b c d e P  ^ݬϺЬխЭPЬЭPРխ   P  ^ݬςЬխ"ЭPЬݭHЭPРխЬP  ^1  PЭPЬ ЭPЬ$P  ^ݏ     PЭP ЭP ЭPЬЭP ݬAPЭPЬЭPЭЭP ЭP ЭP P  ^"  PЭPЬ( PЭPЬЭPЭ,ЭP 8 P< ^ЬR=´ ЬR(GЬRK(ЬR,ЬR0ЬRµ ݬa   (ﻫ  ب ͨ ͨ  ^
ݭ  PЭPЬЭP P  ^ЬPЬP}ЬPuЬPa d U R C P ^e.S PPPPЬRPբPPPPЬRPբPPPP Ьխ1@ЭQСPP  < `  
P?P1 ЬQЭPРs	iЬQЭPРO	EЬQЭPР+	!ЬPA	  ЭPݠ  `$  PЭRЬPݠ$PЭQ޼P`PP ЭQЬPAAЭQЬPРЭQЬPРЭнխ1 P^,Sf[CZDY9XfWSVUTZR ЭQЬP A4 ѭ61YP@bP`P@P`ѭdЬPЭ81PѭeЬPЭ<1 PѭfЬPЭ@1 PѭgЬPЭD1 PѭhЬPЭH1 PѭiЬPЭL1 PѭjЬPЭP1 PѭkЬPЭT1 Pѭ4ЬPЭXqPѭЬPЭ\YPѭTЬPЭ`APѭЬPЭh)P߭ݭ  ݭ e  PPѭݥ1P  ^PЭPЬ P ^   PЭRݬ:PЭP  ^]   PЭPЬЭPЬ P< ^  PЭS޼R(bЭR ЭR  P  ^ݏ     PЭP ЭP ЭP ЭP ЭPЬBЭP A P ^)Sb  PЭRլ
ЬPPP a  PЭЭPЬЭPЬЭPЬP  ^-PЭPPPЬЭPЬЭPЬЭP ^=)R ѭ/ PPѭP ^)Rլݬ/ ߭ݬ  ݭݬn/  ^(R.ݬK/ 3ݬ8/ P  ^(Rլ9/ M
/ ЬPݠR. ЬP>P<`PPe. ЬP PPx. ЬP'PPЬP&PPЬP%PPЬP                                                                                                                                                                                                                                                   S                        -        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1  1                                                                                                                           [       $PPЬP#PPЬP"PPЬP!PPl. ЬPݠ(¼X. ЬPՠ,+ЬPݠ,ЬPݠ0  ЬPݠ     ^Ьխݭ   ЭPРխP ^='RЬPݠЬQСPP   ` 8 
P
?PnP	- ЬPްP`R   Lx- +ЬPްP`  $7P- ЬPްP`	  P ^&RЬQСPP 0 H p  j?P1 ЬPݠI, 1 ЬPݠ_, rP߭ЬPݠy  ݭr, KPЬPݠ, 2PЬPݠЬPՠЬPݠ4PP ^%RЬPP "K7W k        3G[os#_PZ?P1-²ݬ+ 1ݬ+ 1ݬ+ 1ݬ+ 1ݬ+ 1ݬ+ 1ݬl+ 1#ݬX+ 14ݬD+ 1yCݬ0+ 1eQݬ+ 1Qeݬ+ 1=xݬ* 1)ݬ* 1ݬ* 1¢ݬ* 1 ²ݬ* 1 ݬ* 1 ݬ|* 1 ݬh* 1 ݬT* 1 ݬ@* vPݬ,* bPݬ* NPݬ* :P"ݬ) &P,ݬ) P:ݬ) P ^#RPPCЬPݠX   PPU޼P`=    ^"Rլ(Pݬj޼P`   ЬPРլP ^"RgSѣ,

{) ,PP,ݬ"ЬPݠݬЬPՠݬЬPݠЬPՠݬЬPݠЬPՠݬЬPݠ¤ЬPAݬ²ЬQСPPGG.C C ...[ [ ... s /. g ..Pv?P1ݬЬP  1PݬЬP-  1PPP½' ݬЬPݠ21P1ݬЬPݠ Y  ЬPР$խݬݭ  1Pݬ]' PPЬPݠ1PݬЬPe1PݬЬP-  1 PPPЬPݠ1 PPЬPݠЬPՠ PP	ЬPݠ `}PPPPPЬP  SPP]& PP2ЬPݠPPFЬPݠ ,PP,    ^mR޼P`խFPPPЭPݠU)ЭPްP`ЭPРխ ^
Rݬk% ޼P`Sݬzp% ЬPݠ- ^RݬaЬPݠЬPՠPPЬPݠЬPРխ#PPPݭ   ЭPРխP ^1RЬPРխ6Pݬ¶$ ЭPfЭPРխЬPРխ@PЭPݠPPЭPݠЭPРխ ^RЬխ@PЭPݠ`PPЭPݠЭPРխ ^9RPPЬPݠAPP޼Pݠ a ^R$# ЬPPP9	ЬPPPJЬPPPVf;# ЬPРխݭB   ЭPРխЬPՠ)ݬ{" ЬPݠ    ^1RݬЬPݠЬPРPA¢" ЬP&´o" ЬP'tP" ЬP(U1" ЬPݠ  ^`R	V  PH  P     ^E"R! Sbc! ݬc  ݬߢ%c! ﶔߢ9c! x! ߢEݣ m!  ^!RߢHݬQ!  ݬݬ  ߢJ   -!  ^!R߭ݬA  ݭߢL    ^e!R߭ݬ  ݭݬO    ^3!Rݬߢ`     PP  ^ЬQСPP   Pj?P
PЏ   P2  P ^ Rլ PЬQСPP $[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [  _ [ _ [ _ {  g     P?P|P PЏ   PЬPݠkPPPPЬPՠ$ PЬPР ЭPՠЭPРЭPՠЭPݠ%PPPPЬPݠPPPPߢcЬPݠw2  P  ^ЬQСPP ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; ; 	?P
PЏ   P2  P  ^  լRPЬPѠ8ЬPРPЭPPխЬЭPЭPЬЬЬPРլխЭP P ^Rߢmݬ] ЬPP  ) = 	>?P:P ݬ0 &P ݬ P ݬ ݬ¥      ^XR ݬݬ[լ1APЬPްP`PPݭҟ  · ЬPݠ  PPЬPРPPЭ» ݬk ݭЭPРPݠݬ   ½ ݬ@ ЭPРխ>  ݬ ЭPݠݬЭPРխ ݬ ЭPРխ*ЭPݠЭPݠݬa  ЭPРխ ݬ ЭPՠ"ЭPРPРPѠ! ݬl  ݬ\  ݬp  Pݬ ݬ. ЬPݠݬ ݬ ЭPРխ=  ݬ ЭPݠݬЭPРխ ݬ  ݬ ЬPРլ1 ^R ݬf լ=߭߭ ЬPݠݬ   ݬ' ( ݬ  PPPP  PPݭPPݭPPݬ  Pݬ
  	ݬ ݬݬ+  ݬ ݬ $ݬs լ?P 'ݬP ЬPݠݬЬPРլ*ݬ ,  .   (^eR6ݬ լ>߭߭ ЬPݠݬ  ?ݬ )PAݬ  PPPP  PPݭPPݭPPGݬh  Pݬ~  Nݬ& լ> Qݬ ЬPݠݬЬPРլT   ^9RլWݬ լ+PЬPݠЬPݠݬ9  ЬPРլP  ^RЬPРխ1 PЭPѠ
ЭPѠ
1  vݬ' ЭPݬ ݽЭPݠ	ݬ劉  ЭPՠ3ݬ ЭPݠݬݬ ¢ݬ ЭPРխ1B ^R¥ݬ| ¾ݬl ݬݬ1ݬM  ^RЬQСPP $X X X X \ ` d X \ ` d X \ ` X \ ` ` d X \ ` ((($$    (h ((( ?P1 PPPPPPЬPݠl2PPPP ЬPݠU2PPPPЬPР խ4ЬPР PQՠQQPPPPЬPР Pݠ2PPPP ЬPР$Pݠ2PPPPPP ЬPݠP2PPPPЬP 2  P  ^ЬPՠPЬPРЬPՠЬPݠ
2PPPPP ^!RЬQСPP $X X X X \ ` d X \ ` d X \ ` X \ ` ` d X \ ` ((($$   (h (((| F?P1 PPPPЬPݠs2PPPPЬPݠ_2PPPPЬPР$խJЭPРխ+ЭPݠPЭPРխ2PPPPЬPݠ ϻ2PPPPЬPݠ2PPPPЬPݠ2PPPPPЬP 2  P  ^  լ1 P BЬPQՠQQPPPPЬPݠP2Q2PPQQQЬPݠ.PЬPQՠQQPPPPЬPݠ4Pխ PPPЬPРլ1XPPP| ^VЬRТPP $c c c c g k o c g k o c g k c g k k o c g k [ [ |==A AE|s ||| P?P1"Џ   PPPPPRRЬRݢ`PP ЬRݢLPP PЬRТ ݭ*Pխ PЭ ݭL2PSݭ2PRRSSխ
ȭRRЬRТ խ*нR^(n=|  ĭPPЭRТխЭP P PЬRТ խݭϻPխ P ЬRТ$խ
ЭP1 PЭRТխ. ݭφ2PSݭ2PRRSSխ   ݭPݭ2PRR ЭRТխqPЭRݢPЭRբ ЭRТRݢP2RRѭ̭í̭RRRѭЭЭЭRТխRRRRPЬRݢ2  P|  ^EVլ PЬRТPP $                   >                                                                                                                                                                                                                                                    T                        1{        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1;1                                                                                                                    !      j          >    >&[  >$P^?P1ЬRݢ wPЭRբ2ЭSЬRѣ#!UP䞽RR(B ЭЭSЬRТЭPЬPЬSЬRݢPЬPЬSЬRݢPЬPЬSЬRݢPЬPЬSЬRݢPЬPЬRТ խ&PЭSЭRݢϗPЭRТխЬRТ$խdЭSЭRݢfPЭRТխAЭRТխ%PЭSЭRݢ3PЭRТխЭRТխЬPЬRТ(խ#ЭSЭRݢPЭRТխЬRТ,SЬRТ,RݢPЬPЬSЬRݢϪPЬPЬRݢ ^ЬRЬPݠvP   ^ЬPРխݭЭPРխЬPݠ ^ЬPѠЬRЬPݠPP ^ЬQСPP  W + ? 	?PBPЬPްP`/PЬPްP`TPЬRЬPްP`ϬPP ^ЬRЬPݠ0ώP0ЬRТխݭcЭRТխ ^
Rլ PЬQСPP<  3  E    	?PrPݬЬPݠPPЬPР;PЬPРPЬPРЬPР ЭPՠPнЭPРЭPՠݭЭPݠTPP*ЬP 2  P ^RլЬPЬQСPP/  &  ]   =    M *?PqPЬPРP}w  PPЬPݠPPЬPݠPPЬPР ЭPՠPЭPРЭPՠЭPݠMPP9ЬPݠ P  ^  PЬЭPЬ	ЭPЬ
ЭQЬPРЭPЬЭPЬPЭ  ^RݬH߭D  ߭B  PPPݬݬݬݬݭZЭP  ^ݏH     PЭPЬЭPЬP  ^ v  PЭPЬ P ^
RЬPՠЬPՠݬЬPݠݬݬݬЬPՠ ݬݬЬPݠݬݬݬЬSݬݬ ЬPݠ\ЬPݠݬy  PVЬPݠݬ^  PPЬPݠݬC  PЬPݠЬPݠ	ϓ	P   ^Ьխ,ݬݬݭݬݬݬЭPРխլXЬPРЬЭPՠ/ЭPްQЭPРPРaЭP ЭPРЭPՠЭP ЭPP PP ^	Sլ1 ЬPРխbЭPՠYbЬPݠݬA  PhЬPݠݬ%  PnЬPݠݬ	  PPЬЬЬݬݬτPЭRݬ ݬЬPݠݭݭݭϗPݬ ݬЬPݠݬݬݬݬݬ
PЭPP PPX^wXFY޼RbЭRѢhЭRݢ ݬ^P޼SЭRТcݬ,ݬ($RRݬ ݬݬݬݬݬݬݬPЭRЭCЭPݬݬ|PЭRЭCݭϖPЭRݭP1ЭS ͇$6ЭR1-Ь(R&$Ь(R'լЬR'͇RR͇͇RR22RR.ЭR ݬ,ݭtݬ  PzP3ЭR ݬ,ݩ{ݬȵ  PLPЭR ݬ,ݭȀݬ  PPЭR ݬ,ݩ ȇݬl  PP(ЭRЭ?ЭSݬ,ݬ($RR޼RbșЭRݢ)  PȓЭRݢ  Pȍݬ  P  	ϝP޼RbRѢȥRR̓
ȟRR̓̓߭ ЬRТխ9нR^(n]o  ĭPPȨ߭a ЭRТխЭR߭ݬ\  PЭSѬ &޼RbPȬݬ.  P߭ݬ  PЭ$CլЬRТ RТЬRТ RТլЬRТ RТЬRТ RТ1EPլ1߭ЬRݢ﹯  ߭ݬ絛  ݭ͈n ͈j PPЭRB͈.PRRЭRB͈.R B͈ݭ͈   ͈)  P߭ݬ&  ݭ͈ ͈ PPЭRB͈.PRRЭRB͈.R B͈ݭ͈  ͈塞  Pլ1߭ЬRݢ  ߭ݬ  ݭ͈K ͈G PPЭRB͈.RRЭRB͈.R B͈ݭ͈   ͈	  P߭ݬ  ݭ͈ ͈ PPЭRB͈.PRRЭRB͈.R B͈ݭ͈|  ͈  Pլ1ЭR GȰ޼RbRݢZPݭ  PȺ޼RbRݢ1Pݭk  PѭЭRЭ ЭRЭ$FݭPЭRݭݭ'  P ЭRݭݭ  P$ЭR,ЭVѬ    P)P޼RbR^(nJk  ĭPPφPЭ-GPЭWЭV޼RbR^(nk  ĭPPNP$Ц$ ЭRGЭR ,լ1 ޼RbRݢPݭ;  P޼RbRݢطPݭ  PѭЭRЭ7ЭRЭ;8ЭRݭݭܯ  P7ЭRݭݭ  P;PЭSЭRТ 7ЭSЭRТ$;ЭP 0^ S2>TЬQСPP $Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y Y j  	?P1ݬݬϳPPݬ$ݬ PPЬPݠݬݬ  Pݬݬݬ	8PPݬݬ_P ݬ$ЬPݠtPݬM  PPݭ1  PЭPЭЭRݬ$ݬ PPЬPݠݭݭݭ  	ϞPЬPݠaޕPM ݬ$ЬPݠPݬﳭ  P7P&ݭ  P4 ݬ$ЬPݠ,ݬn  PPЭЭRݬ$ݬ PPЬPݠݭݭݭ  	PЭPݬݬPЭRݬ$ݬ ЬPݠ ݬݬݬPЬPР$խ1ݬݬϮPЭRݬ$ݬ PPЭPݠEЭPݠݬ׬  P?ЭPݠݬＬ  P9ЭPݠݬ  P  	PЭRݬ$ݬ ЭPݠWЭPݠݬc  PQЭPݠݬH  PKЭPݠݬ-  P  ϛPЭPЭؠfЭP ݬ;ܕPQЬPЭPЬЭRݬϭPЭPЬЭRݭݬP ЭRݬP$ЭPݬ$ݬ PPЬPЬPݠ ݬݬݬݬݬPPXg  PЭRЬPР   PЭЭRЬPР$ݬ$ݬ PPЬPݭݬݬݬݬݬyPЬQЭPР$ݭe  ݭZ  ЭPݬݬXPЭR ݬ$ݤ ]ݬN  PPЭPgЬPݠ)PP  ^ЬQСPP3  _    	?PnPݬЬPݠݬpPݏ    ݬЬPݠPݬBݏ    ݬݬϪPݬ  ݬݬݬϦ ^SЬP$ЬPՠݬЬPݠЬPՠݬЬPݠЬPРЬPݠώٕPvЬPРPѠ ЬPРPРPРЬPРPРЭPP' + ' + + + + + + + + ' 	?PPPrݭ  PЬRݬݬݏ   ЬPݠݭЬPݠЬPݠЬPݠЬPݠ	P ЬP3$  ^SЬRЬRЬR ЬR ЬR  ЬR !ЬRТRТRѢ!
ЬR &ЬRТR &ЬRТR'ЬRТRЬЬRբ
ЬRТPЬRТЭŭխ]ЭRxЭPݠ|  PЬPѭ	 %PЭPՠЭPР	ЬPРЭЭŭխ ݞRRЬRբЬRТ	ЬRТЭխ1 PЭPРPѠ2ЭPРPѠ ЭPРPРPѠPЭPЭЭЬPѭ #ЭPՠЭPР	ЬPРЭŭЭխЭR ЬRЭݢЭݭխ1 PЭP%	ЬPЭ!ЭP&	ЬPЭP'	ЬPЬP ЭPݠϔ֕P	ЬP ݬݭώݬЭPݠЭPݠЭPРխ1pЬRբ*  ݬ ЬRТRݢЬRТRݢ  ^  լ1 P 8ЬPQՠQQЬPݠ2PP­PPխ
PPЬPՠЬPݠK2PPPݬЬPݠݬЬPQՠQQPPPPݬ.PP޼P`ЬPРլ1QPPP ^Rլ PPPݬPխЭPЬQСPP   p ( L 
P6?P1ݬЬPݠݬPPݬxPPЬPݠЬPݠݬ ݬTPPЬPݠЬPݠ ݬݬ[PPЬPݠЬPݠ ݬݬ:PPЬPР#PЬPР
  ݭ 2PPPíPPխ
PPݭϋ2PPPPPխ  ݭϖPխaPP|ݬ  լЬPР PPЬPР$PPݭݬݭݬ  ЭPЬPݠݬyݬ  ЭPѠݬ{  լЬPРPPЬPРPPݭݬ!ݬ=  ݬ-  ЬPݠݬݬ
  լЬPР PPPЬPР$PPݭݬݬ  ЬPݠݬ¢ݬ  ЬPݠݬg                                                                                                                                                                                                                                                   U                        Go        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1
1                                                                                                                          y       ݬ  ЬPݠݭݬ ݬPPЬPݠݬ «ݬ<  °ݬ,  խRݭ³ݬ  լЬPР PPЬPР$PPݭݬݬ  ЭPݬ  լЬPРPP
ЬPРPPݭݬeݬ  PЬPݠPP  ^RЬլ1!PլЬP&1 PѬЬP'1 PЬPРЭPѠ$-ЬPРPѠ ЬPРPРЭPѠ$P1 ݬ   ݭݬj  )ݬ  լЬPР PРPPЬPР PРPPݭݬ=7ݬY  ЬPР Pݠݬ;ݬ2  ЬPРլ1 $^R  ?ݬ  Ьլ1 PլЬP&1 PѬЬP'1 PIݬ   3ЬPPPЬPݠ<2PP­PPխ
PPЬPՠЬPݠϠ2PPPЬPݠ ЬPݠݬЬPQՠQQPPPPݬ~PPЬPРլ1!PPPPdݬ    ^լ]PЏ   ЬPQՠQQPPݭݬݬЬPݠݬݬϓ޼P`ЬPРլ ^Sz,R$2PPrݬG  P ^RЬPݠݬݬ  ЬPѠݬ  լЬPРPPЬPРPPݭݬ ݬ   d^#R+SЬPG1ݬЬPP    Pn?P1 ЬPݠ(ݬ1£ݬM  լЬPР PPPЬPР$PPݭݬ§ݬ
  ЬPݠ(ݬݬ  pݬ  ЬPݠ(ݬݬ  ;Pݬ  ЬPݠ(ݬa$ݬ}  P(ݬh  $ЬP,VAݬK  ЬPݠ(ݬFݬ(  ЬPݠ-ݬHݬ  ,PЬQլЬPР PP
ЬPР$PPЭ(ЬPѠ
ЬPРPЬPРЭ ЬP1Ѭ	PPꐭPPPP1nݬs  $ ݭ2PPPݬѬYЬP2PѬJЬPݠ3ݬݬ  ЬPݠ?ݬݬ  1 ݬݭݬݬϛݬ  Ѭ¦ݬ  ºݬ  ЬP2ѬЬPݠ3ݬ[ЬPݠݬEլݬ\  ݬL  ЬPݠ(ݬ
 ݭϡPݬ  Bݬ  ЬPݠ(ݬ ݭZPݬ  $	ݬ  ݬݭݬݬeѬOЬP2FЬPݠ3ݬ[ݬw  ЬPݠݬ8ݬT  ݬD  ЬPݠݬݬ!  ЬPݠ(ݬݬ  ЬPݠݬ"ݬ  ЬPݠݬ%ݬ  ݭҰP$$ݏ   ݬЬPݠݭݬݬ	ЬPݠݬ<+ݬX  0ݬH  3ݬ3  P $^RЬPРЬPP    P?P1mPPݬЬPݠݭ ݬݬݬa  ;ݬ  ЬPݠݬ{Lݬ  1PPЬPݠݭݬݬuݬݬva  PݬR  ݭϵƕPaݬ5  լЬPРPРPPPЬPРPРPPݭݬcݬ  լЬPРPPPЬPРPPݭݬgݬ  ЬPݠݬݭݬPP ^R$Sݬ&1ЬPP  h XF?P1kݬ8  լЬPР7PP
ЬPР;PPݭݬtݬ  1vPѬ1 ݬ  ЬP2ݬ  ЬPݠݬݬ  ЬPݠ?ݬ ݬ|  ЬPݠݬݬY  ЬP2
ݬ@  5Pݬ,  ЬPݠ7ݬݬ	  1 PѬyݬ  ЬPݠݬZݬ  ЬPݠ?ݬL]ݬ  ЬPݠݬ)yݬ  P}ݬp  $PPݬݬݬݬݬϐP ,^RJ"S&1IݬϩЬPP  y ] 	?P1
ݬ  ЬPݠ ݬݬ  ¢ݬ  1 PѬݬ  1 Ѭ1 ݬ  ЬPݠݬH/ݬd  ЬPݠݬ2ݬA  ЬPݠݬFݬ  ЬPݠ$ݬZݬ  `ݬ  $&PPݬЬPݠЬPݠ ݬݬ &  8^V WѬoѬiЬPP    	r?PNPJPЬRݢݬ1yݬM  ЬRݢݬƉݬ*   ݬϤƍݬ  ЬPP $  8 ?P:PƓݬ  Ɩݬ  PƧݬ  PЬRݢݬyݬ  լ-ЬR޲RbR^(nbK  Pݬc  ݬS  լЬRТRRЬRТRRݭݬݬ  3ݬ   ЬRݢݬݬ  $ ^@RSݏ   ݬЬPݠЬPݠݬݬϠլЬPРPРPPЬPРPРPPЭܭݬ_  ݭݬ$	ݬ@  2$PPЬPРPР䐏ЬPРЬPРխ1 ЭPРխeP	ݬ  ЭPݬP  	ݬ  խЭP 	ݬ  ЭPРխPP$PPݬЭPݠЭPݠݬݬυ	ݬU  н2$PP2$PPЭPРխ1%#	ݬ  N	ݬ  PP$    ^dRSݬϓP1< ݬπǰP2PPݬ@$լЬPРPPЬPРPPЭQ	ݬ  ЬPP '  ; P^?P:PW	ݬP  Z	ݬ@  Pd	ݬ,  PݬݬQ  m	ݬ	  Ѭo	ݬ  	ݬ  ݭݬ屮	ݬ   ݬ'P	ݬ  1ЬQСPP\\8 t ( P 
Pf?P1ePPݬݬЬPݠݬݬH1UPPݬݬݬݬݬ11ЬPР$խ
PP횭PPݬЬPݠЬPݠ ݬݬЬPР$խ$PPݬЬPݠݭݬݬ1 PPPݬݬݬݬݬ81 PPݬݬݬݬݬnPPPݬݬݬݬݬ|JPPPЬPݠݬݬݬݬݬ\$Pª	ЬPݠPP ^QSR$ЬլtPլЬP&TѬЬP'CP ú	ݬ  ݏ   ݬЬPݠ ЬPݠ ݬ`ЬPРլ  ^Ѭ 	Ѭ6hЬPРլ!PЬP&Џ   PЬPРլ PЬPРլ"PЬP'Џ   PЬPРլ P  ^9RS1 	ݬ  $Ьխ1 PլЭP&`ѬЭP'OP 	ݬO  ݬݭPPPݬЭPݠ ЭPݠݬ ЭPРխ
ݬ  $Ьխ~լЭP&`ѬЭP'OP 
ݬ  ݬݭZPPPݬЭPݠ ЭPݠݬτЭPРխ4
ݬ]   ^R7
ݬ@  ݬݬH
   %   ^Rݬݬݷ_
ݬ  ݬݬﾷh
    ^ARt
ݬ  ݬݬ~
ݬ  ݬݬb
 }   <^R
ݬ`  ¶
ݬP  !
ݬ;  ݬݬݬ
ݬ  լ1 ݬ  Hݬ  ЬPݠݬ﮶Rݬ  fݬ  ~ݬ  ݬ  ݬ  ¤ݬz  ݬh     U   ^RЬPްP`PPݭPY  ЬPݠݭЭPݠЭPݠЬPݠݬrݬ  ЭPݠݬ	ݬ  լDЬPѠ Ь)PЬPРЬ   P1 PЭPРЭPРPQѠ QQPPPPЭPРPРPЭPРЭPѠ1 ЭPݠ8  PPЭPРMЭPРЭPݠ  PPЭPР  ~  P'ݬ  *ݬ  Eݬ  `ݬt  vݬd  ݬT  ݬD  ³ݬ4  ݬ$  ݬ  ݬ  
ݬ  *
ݬ  =
ݬ  O
ݬ  n
ݬ  ЭPЭPSP
ݬ                                                                                                                                                                                                                                                   V                        W<        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1  1                                                                                                                     
               §
ݬx  ¾
ݬh  
ݬX  
ݬH  ЭP
ݬ/   ݭݬϣЭP
ЭPՠ! PPPP+ݭݭЭPݠ!PPЭPPPݬIݭݭݬЭP1 ݬ  ЭPݠ  ݬ/ݬl  ݭݬ1<ݬM  ЭPݠ  ݬLݬ&  fݬ  ݬ  »ݬ  ݬ  ݬ   ЭPݠ ݬݬ  ݬ  ЭPݬ  (ݬp  1ݬ`  =ݬP  ݭݬG߭5  ЭPI߭   ЭPV߭  ЭPg߭  ߭ݬ}  ЭPݠݭ߭sݬ  ЭP1 ݬ  ЭP/ݬ  ݭݬGݬc  .ݬS  PP ЭPݠݬeZݬ%  vݬ  ݭݭݬЭPݬ  ¼ݬ  ЭPՠGݬ  ݬ  ЭPРPݠݬeݬ  ݬq   (^RݬT  )ݬD  rݬ4  zݬ$  ݬ  ݬ  ݬ  ݬ  P      <^9Rݬݬ7ݬ6Xݬ  լNjݬ  ݬݬI  uݬb  ݬݬ'wݬC  Ьխ/ PPݬݬݬݭݬЭPРխzݬ~  Pݬ
~  Pݬ  ݭݬݬ  ݭݬxݬ  լOP ¤ݬp  §ЬPݠ}  Pݬ"ЬPРլ®   -   ^RЬլ1 PЬPР ЬPРЭQСPP> f  
Pګ?PRPЭPݠݬ³ݬ  /PЭPݠݬu¼ݬ  PPЬPРլ1g f   0^RЬլ1PЬP'1ЬP&1|ЬPР ЬPРЭQСPP Z 
P?P1EЭPݠݬｫݬ  ЭPݠݬZݬ  ЭPݠݬ7ݬ  ЭPݠ ݬTݬp  ЭPݠ$ݬݬM  1 PЭPݠݬ	ݬ%  ЭPݠ?ݬ寧ݬ  ЭPݠ;ݬêݬ  ЭPݠݬ`ݬ  PPЬPРլ1[P ^	Rݬ/P1ЬQСPP    (        
PN?P1 ݬ@  ЬPݠݬݬ  ЬPݠݬީ2ݬ  1 P6ݬ  ЬPݠݬ數;ݬ  ЬPݠݬXݬ  4ݬݬЬPݠݬP\ЬPݠP ^RЬլ1 PЬPݠ ЬPݠݬόЬPРPѠ$JЬPݠݬD  qݬ  ЬPР Pݠݬ︨yݬ  ЬPРլ1{P ^)RЬQСPPh      
P?P1 ЬPРݭPݭ٨PPЬPРPѠ$}ݬD  ZPݬ0  ЬPݠCݬ1C  ݬ
  ЬP2ЬPݠ3ݬŧPPݬݬﭧ 0^ARݬ  լ1ЬPРPѠ!#ЬPݠݬjݬ  ݬq  ݬݬ6«ݬM  ­ݬ8  ¯ݬ(  լ1 P ±ݬ  ЬPРPѠ´ݬ  UЬPРPѠ &ЬPРPРPѠ¶ݬ  #PЬPݠ ЬPݠЬPݠݬЬPРլ1^¹ e   4^R½ݬH  ݬ8  1	Ьլ1 PЬPР ЬPРЭQСPPn   
P?P1 ݬ  ЭPݠݬ"ݬ  ЭPݠݬz6ݬ  \:ݬ  ЭPݠݬECݬa  ЭPݠݬ"Wݬ>  PЬPРլ1[   }    ^kRЬPްP`PPݭ H  ЬPݠݭϯݬ  ЬPݠt  Pݬmݬ  ¬ݬy  ¯ݬi  ½ݬY  ݬI  ݬ9  ݬ)  ݬ  լ/(ݬ  ݬݬɣ*ݬ  :ݬ  Qݬ  iݬ  ݬ  ݬ  ݬ  լݬp  ݬ`  ݬP  ݬ@  ݬ0  'ݬ   ;ݬ  Qݬ   լݬݬdݬ  tݬ  ݬ  ¡ݬ  »ݬ  ݬ  ݬ|  ЭPЭP`ݬX  ݬH  ݬ8  *ݬ(  9ݬ  Iݬ  ЭP  aݬ  ݬ  ݭݬSЭP -ЭP PPЭPݠݬFЭPݠݬmЭPNݬ  ¶ݬp  ݬ`  PPЭPݠ ݬrЭP ЭPݠݬPլPPPPЭPݠЭPݠЬPݠݬЭP1 ЭPݠݬqЭPݬ  ЭPݠݬρݬ  4ݬ  Qݬq  tݬa  zݬQ  ݬA  ЭPݠݬB¹ݬ  @ݬ  ݬ  ݬ  ݬ  ЭPݠݬc   (    ^Rݬݬݬ+ݬn  =ݬo  P=Ьխ0PݭPPPPݭݬ%ЭPРխ9Ьխ.P PPPPݭݬЭPРխԕ1 Fݬn  PUݬ  ݭݬy`ݬ  ݭݬZbݬv  ЬխUP hݬH  ЭPݠݬ	kݬ   ЭPРխmݬ  rݬn  Pݭn  P蕬ݬž  P¨ݬ  ݭݬuݬ  ЬխvP ݬd  ݬO  ݬ<  ЭPݠLm  PݬЭPРխݬ  ݬ  ݬ׽  *ݬĽ  ݭݬ6ݬ  PLݬ  ݭݬQZݬm    ^ЬPްP`PPݭͯЭPՠ1 ЭPݠDP  ݽM  PPݭЬPݠݬ	PPЭPݠ0ЭPݠ,ЭPݠݭЬPݠݬ욬 PPPPPPݭЬPݠݬ  ^ Ьխ"ЭPѠ	PPЭPРխP ^RݬݬO  P P ѭ4NPŏ  P@8  P޼Qŏ  P@8P`aЏ   PPPѭ42  P ^RݬݬEO  PѢ4d   1 ŏ  4P@<P`ŏ  4P>Q@@Pa`ŏ  4P>Q@BPa`ŏ  4P>Q@DPa`ŏ  4P@8  ŏ  4P@8PЬ`4PP4P>J   ^Sլ PЬQСPP $[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ s [ s [ s  _ { [ [  P?P1  PЬPݠ sPPPPЏ   PЬP ЬP ЬRЬPݠAP!ЬP  ЬP!PPPЬPՠ$ PЬPР ЭPՠPЭPРЭPՠЭPݠPPPPЬPݠPPPPߣЬPݠǗ2  P  ^ЬPѠ	ЬPР ЬQСPP    
P?P
PЏ   P2  P  ^ЬPѠ	ЬPР ЬPQѠ QQPPPPPP  ^RЬPՠЬPРѭ
ЬPР PРѭѭPߢ&ߢ"޼P`E  ЬPݠe  Pխߢcߢ_޼P`E  ЭPѠ  ޼P``E  ЭPРPРѭЭPРPР PРѭ`ѭZѭTѭNѭHѭBѭ	<ѭ
6ѭ0ѭ*ѭ$ѭѭ² ® ޼P`D    ^RЬPՠЬPРѭ
ЬPР PРѭѭP  ޼P`xD  ЬPݠc  Pխ
޼P`GD  ЭPѠ40޼P`$D  ЭPРPРѭЭPРPР PРѭaѭ[ѭUѭOѭIѭCѭ	=ѭ
7ѭ1ѭ+ѭ%ѭѭa]޼P`C  P ^kRݬ                                                                                                                                                                                                                                                   W                        I        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1;1                                                                                                                                  z  E   ^R OM޼P`0y)gF  *ݬݬޯPPЬPݠJ  PM
   )ЭPްP`D     ЬQЭPРݬЬPݠЬPݠݬݬݭ  E  Э(ЭPРP P  ^ЬЭPՠЭPРЭPՠЭPЬЬQЬPР  P  ^Ьխbݬ߭ЭPݠP
ЭPЭ-PݬݬݭχPխݬݭ]PЭPРխP  ^ЬPP   P"?P
PЏ   P2  P  ^ЬPP   '    P?P
PЏ   P2  P ^)RЬPѠ	ЬPР ЬPРЬQСPP<   d   
P?P1 խ޼P`@  1 ݭKP޼P`@  YݭP޼P`@  1ЬPݠݬ/-)޼P`d@  PP  ^ЬPѠ	ЬPР ЬPѠЏ   PЬPѠ1 ЬPР խ)PЭPݠPЏ   PЭPРխЬPР$խUЭPРխGPЭPРխ)PЭPݠWPЏ   PЭPРխЭPРխ2  P ^]RЬPРխ1 PЭPРխ%PЭPЬPݠЭPРխЭPРխMPЭPݠϷPB>޼P`>  PPݭЭPРխЭPРխ1a ^RЬPРQСPP                 d 4 ?P1 (ˏ$PPws޼P`G>  eЬPРPР PѠ .(ˏZ$PP§£޼P`>  "P޼P`=  P  ^ЬЭPѠ	ЭPР ЭQСPP; ; ; W W    	?P:PPPݬݭ\Џ   PPPݬݭ@Џ   P2  P< ^ЬRѢ	ЬRТ ЬRѢЬRѢЬRѢFЬRТ ЭRѢ	ЭRТkP(ЭSRRЬRЭ  ^RլnPЬPPPݬ޼P`P޼Pް P`<  ЬP޼P`ЬP ЬPРլ ^-RЬPPPнPѠнPѠнPѠ޼P`<  ݽϞPJF޼P`;  6ˏ"PP&ݽPso޼P`;  ݬЭPݠPPݬݽWP ^QRЬPPPнPѠнPѠнPѠ ޼P`(;  ݽP޼P`;  6ˏ)!PP&ݽϣP޼P`:  ݬЭPݠPPݬݽ{P  ^ЬPРխ/ЬPРQЭPѡ
ЬPЭPЭPРխЬPРխ.ЬPРQЭPѡ
ЬPЭPЭPРխ ^RЬPРЭPѠ	ЭPР ЭPѠ Bˏ PP2
ЭPՠP!޼P`9  fݭPXЬPՠ\X޼P`z9  4PЭPѠ'"ЭPՠ~޼P`D9  PPݭP ^RЬPՠ)ЬPݠ~P޼P`8  ЬPՠ)ЬPݠLP¾»޼P`8  P  ^ЬPPP pX  ЭPРխ*PЭPݠЭPݠraЭPРխЭPРխTPPPݭ,ЭPРPՠ
ݭݭϒЭPРPՠ
ݭݭxЭPРխЭPՠPPЭPݠe W   ^RЬPРЭPѠ	ЭPР ЭPѠ#ЭPѠ޼P`7  ЬPѠ5ЭPѠ +ЬP 
ЬP

	޼P`L7  P $^!RЬPРЬPР ЭPѠ	ЭPРЭPѠ	ЭPРЭPѠ!ЭPѠ 5޼P`6  ЭPѠ!ЭPѠ _޼P`6  ЭPѠЭPР
ЭPРЭPѠ
ЭPРPЭPРѭ ޼P`R6  íPPѭ  
ЬPPЬPP ^Rݬݬ2ЬQСPP  RRRRRR  &RRRr   R R RR B 
P>?P1 ݬЬPݠݏ   ݬЬPݠ i1 PݬЬPݠ1 PPPݬݬ1 PPݬݬ1 PPݬx1 PPݬXrPݬ/eݬϻYѬ
լP¸´޼P`4  .PˏPP޼P`4  PP  ^ЬP(ЬQЬPРPР ^]RSЬPРխIPЭQЬPРPѡ	ЬPЭЭQЬPРPѡ	ЬPЭЭPРխЬPРխ1 ЭQЬPРPѡlЬPРЭPѠ	ЭPР ˏcPPDЭPѠ:ЬP'1ЭP'(ЭP&ЬPՠ%!ݽ3  ЭQЬPРPѡ*ˏcPPЭP&IEݽL3  ЭPРխ13P  ^ЬPРˏWPP PЬPРPѠ$ PЭPѠ	ЭPР ЭPѠЏ   P2  P  ^ˏ PP PЬPРЭPѠ$ PЭPѠ	ЭPР ЬP' PЭPѠЏ   P P ^IRЬPѠ#	ЬPРЬPѠ 	ЬPРЬPAЬPѠokݬ2   (^RЬPРЭPѠ	ЭPР ЭQСPPh    F?P1qЬP';ЬP&2ˏPP"ЬP*޼P`}1  1)ˏPP©¥޼P`P1  ЭPР խ}ЭPݠ[P]ЬP'!ЬP&޼P`1  ЬP(*ЬP*!ЬP'%!޼P`0  ЭPРխЭPР$խcЭPРխUЭPРխ9PЭPݠϳPmi޼P`o0  ЭPРխЭPРխP ^%RЬPՠ)ЬPݠϞP°­޼P`0  ЬPՠ)ЬPݠlP޼P`/  P  ^ЬPѠЏ   PЬPѠЬPР ݬΚPPPPЬPѠЬPݠPPPPЬPѠЬPݠPPPPЬPѠ1 ЬPР խ)PЭPݠcPЏ   PЭPРխЬPР$խTЭPРխFЭPРխ)PЭPݠPЏ   PЭPРխЭPРխ2  P ^R ЬPްP`PP aN  ЭPРխ+PЭPݠЭPݠbWЭPРխˏPPtˏuPPdЭPՠ ݽ.  ЭPްP`ЭPРPݠύЭPРP&ЭPްP`-  ЭPРխ1GPЭP'ЭPKGݽ-  ЭPРЭPQՠQQݭLЭPՠ
ݭݭЭPՠ
ݭݭЭPѠ#	ݭύݭЭP)@ЭPݠP/ЭP*&ЭPݠlP|xݽ,  ݭϞP"ЭPРPՠ¬¨ݽ,  ݭP/ЭPРPՠ"ЭPРPՠݽt,  3ЭPРPՠ&ЭPݠ}P	ݽ<,  ЭP%1 ЭQPPQ6	2	ݽ
,  ЭP'\	X	ݽ+  ЭPѠ		ݽ+  ?P߭ЭPݠI  ¹	ݭ  P		ݽ+  ЭPР խ1 K  ЭPՠ,ЭPРPРPQՠQQЭPРPݠP  ^ЬPѠ	Ѡ%ݬ_  ЬPްP` P ^ѸRЬPѠЬPݠJ  Pխ+߭ЬPݠH  ݭ	޼P`*  ЭPՠ+߭ЬPݠH  ݭ
޼P`k*  ЭPРPѠ$ЭPްP`TЬQЭPРPРЬQЭPްP`PP ^R^SݬBI  Pխ PЭPѠ#߭ݬ H  ݭ*
ݬ)  ޼P`޼QЭPРPРaЬQЭPРPaAPPaЭPРPѠ&ݬݬݣ0ЭPРPݠQPPPЭPްP`PPP ^5SЬPѠ1 ЬRЬPЬPA޼P`ЬPݠP ЬPՠ ~߭ЬPݠ;G  ˏ(PPݭC
޼P`(  BP!jPbPЬQPP ݭ]
޼P`(  P  ^ЬխЭPwЭPРխ  ^ЬխЭPݠpЭPРխ  ^Ьխ'ЭPݠЭPݠЭPРխ  ^լP޼P`ЬPРլP  ^ݬjЬQСPP  JJJJJJJJJJ:  J^ J J* B 
P?P1	ЬPݠЬPݠ 1 ЬPݠ ЬPР$խЭPݠ`ЭPݠ1 ЬPݠC1 ЬPݠ31 ЬPݠ ЬPݠxЬPݠ ЬPݠ$ЬPݠOPЬPݠ=ЬPݠϧЬPݠ Ϛ ЬPPЬPݠwP  ^ЬPРխЭPݠwЭPРխЬPՠЬPРPݠOP  ^ЬPՠ0
ЬPݠ01ЬPРխvPЭPՠЭPްP`PPݭЭPѠЭPްP`PPݭЭPѠЭPްP`PPݭ#ЭPРխ                                                                                                                                                                                                                                                   X                           Nz                                                                                          ;1;1                                                                                                                                       nfWVNJ	 Og\B}ظ1 trJvr[ReW dd~^0	剬pZ_~	ܛdD]dA6_,O)v
f
I#6<<0)%Qw1ޓP)?v tI@SI`L;p`Ep8vN 
-Zѫ@-NDo~FaׂQIc%'U:*H3J[cl6૲e'Cڢ07'נ8@}:eGbRVPv[E 8c<!7K1V:ҺɖҡmR^cO
L@@2@?u!CymcyS0
X-jM/Yw<qI%'٠ĊojpGK=DC-wN(6|B# ,	Lar/>Ф봐"CR~f[Wt* ۴g,jcLW$6]P<dРr܍H(5wJ{9DX	[pDc<'[B4[@`Sń 	BoJptlkج?fr#H"x.#ym|DDϕE+DU[WxQ<2C6cR`駍O
OPP|">Rc˺A<`nYOՏ'~F7QaZDv01/[v-0r-E*W_'- lGݬf^e<9U[Aο(,M<d>bM-HkEcaTqZ4vśJP<A[DG(2*3|efXUK}Mݗ0v3eжH^7U]\ҷ
:RAۆR	٢р9*>D]d5ًC6zti/gC	ʖNؓ>mAzmzS | woZ<^cչ*^λw],Kc`gkn <򓘓J"N+%⺘s,
nx^٨a|yLmtWkjNi"%[&`H>ԁ43@Q&0=)H/ݱTVvCrڰ_2H
wkOG=e{Tzus=M9J8*]]0x\D`%>sCj;/S}~|mنLţi'H e황D)Ep8&!fiW]KA{Ђ̀DXo	߶5:j㧴/݈E,8zGrUbکF}`sR,7 iP`h(S~r?{
&yo?+
tu΢/F8\UO{Mb/W}սw4;.kέ0PW0%HkKR&:Tڏ3,^h/8?T=_`?Puʾ_YT*j{FN,Q'<Po:~qj[8NvSꀑ 
AIһ5)eI?}8'F١LLa8Zg`(_=ϋ
~3<220UU%l'V@nfTڔFCp"$iIfmtMWapuAJK/&;9>RC~rzJ.fao~850_tFlN._cYӛJ}\w-Gn^^x6 Ng.:ԘVy_^w>3N%P3;f^|-T^[zxb#f%6!=Ϳ-$!x"e/q?뿇X`/@A^ʱtZ[[d+ybBЏ:Tx3up\ȭfp{Cs&jN(ژ&=~e`}<-{l¦G&qP)EqC9 .1j\ >Rh_hcD⮛<Ն}5k(F3	?gߛ7pD1,h{;+8j
l~J)XEaДTiڟ1tRXrTIC3 us30F3s )"]h#}p&O5͙b5b!2/6}S
їjLy>Asn.W/lUC`,/QݺTYBUr{
l@"+Psϐv4kA{d5Edm1Z-#@9x  !<p' 4KXI).
$%&Y4%voE@?HT[N*Λ@5%lp*&"eu
)Nz0uMc=_I:r ľeüm: 5{Eo'EoA(2_e=46Vt".I*4
~UVM	yor]2H/Ș!qNy+,gJ#} I*X]}~쏾9ѝΚ]=	 Ӭf,Z:ƂF$R&ص QڥF6e&]%3Z?)0*O.r(w@9IBQ"a3@LEaխ*2
-,IZȨ+nS;V
ԿM
Eeױ	Eij+[+TO303KbM "=}:jI$>	ܝS#be{Ǜ0NkX Rl1d֔GNs:`]LY^61;H3-~3 '%Urqq)՞Ϻ*^T!f$lrN#[m8J_|lօ0.oT
#6:o$Nކ37Ew(2segZ$$qvi͘h-y MI{5❸8%͚2ɣtcjd`r'ϳn?
A\EQX
~8h;pP?jǸ- 'Fñ3BȹCHjDB}*߂X!]5?[@P.jM3Oj%k} ;aļ'[0	ȏ}=@a'l7O]cXbpXrMyW)yh\!C2LqF[|Ґ̶}̋>54Y8䐭&Π]J
zQ+UuiVUCA95G\4\LL*Y`{-,$Rs^B#:!'rH4W4j(=ʙ.l[!Fa"$)Q"gg8qU}3""ԜѤs[8ۡM(wasΧW~@˙ap:Y^(o$ޝ"syglkhPld`'O+_X,sl<9v
d l*-k}|hs19)qɆi4\wc w.jC\U9:ð&"F`$A2+%uh)Df=Z:MeSPHClnlE?sg%ïC$(EH4eżuZ(%=D8p|:E,e`pGMTz	GտgzE~73,!p#=ǝ, k[A7&w3RIsɸW-<#	iHlm#P=jBtD!!vU]r`4KGHX5~<=}JۗQM5@;A ]fk^Ӽ4}"tL2heӆ;h\Y
1

kʐzDu765M?e$F\MI beyZf!ف ~Nj5 I['Yf[fD8of1EӦDa1'H`FzԲh|f7
_f,>;sA/vpH@w9m`olILt9e|%эd5|k^§Ů4CM8=l$cU:3_Z]tqhmI?_7#|qΈ_V wgk2ɪk4bZXY{i8FPi~iw?"Aeu~4|)qUM>RT(T՘!nQAttΔ}bWN~ۭz+vsur',$WAߋr!C7REnV^I_WH Z}i@l)l[ƙ&@wp&(>%3׶akZ%>eLg)V,hl"]6K0Ev t*8>JtMb|e
?v)2mX;oYy#plHd$le&4r<x$<Jr_6W3Rջ1$ ynd%d9v ^5Jjr78+8j><9ZҘ$H0iUH[uH!GT1ABg-\1%BQypikJqM.2Q^I?:s{k$zse?:K8oU}z(SRdKg=A&sMg*yZ&Wt
h+ˠ@BMlvprڬ&XlK|h,F+
WqZoig^u7iSv77ޤ^4Aĸ~=x?NvoLүA3q%
@ UѐpqJ3!VܾalЀ*j&8EWF5֞D+ܜf;WZ51al(&4wLStu$lfCa ̪W3 v_Zx$hhE`0}kq
3MY]e'r<QPE8&+PT.tNirfp<AFn
Pb݂!wTd @&b,1wŞɋU~BU3|!0@2aEo4&]M#bΙSŭ.RO^E81?G$YAPֳnӞG[Ƹ]qbܟ@&Zcdr؎+Xp[<&xښs7=-cHK(T/A88IZ46;
<`vVvmQOIdRg>OA$*BV)$Zv,eCNSmPGɛh˗K푺9J	P0shFFi&-TZTOl|T97}i(,,"dǢY{ބS叏#lM#zE׻ *":+=[P<dSϑK Ĩl`,o sLuZT2tW".aw/~iL ![/G?z͛r'tVOuc;Sv)3g^+q-:ǥgj{ZT3˵;U3klTF&	b໹|A,D.YHe!$q1]5uD>g(bJ@Vs`VȮx~ 0_M%U
eK+z&a!iG/HeB -\9A<[4_(f~A-N]'@)aC0S2u%M^N#B6D4z5l46[{w($BBU׿j	ǦHfBK IUpU5a޴(VA3y3ί.-VSE5q6K%G^-~d3Q8؀
+a
ښO5y?dIQ#Do/*k.@,	r3'<<Yk㑃hx+4C
.w!][m)ZPc-(]sM
pWCՍ KQxr˒	z!3%U @( 
{4Z;e%faTWEH.BC,.MxZH={= w@Y꘵^2F@Q2[o`OU>#@3'H֞|˭̆;1$78
4`--Ǘ'΋Btg
a 
H	wB
-Xn;W4Ûi:p	-b K{]iݞoЂj^}6`JkQS2H}9,
Q~ŭmzS
Y2T3Ȑ mUWiX
]I8*tK˒pk2uk6jyi`_J.u E*|ŠQn6wRT&C7~
b&d0svpWbay~;P	cgsgPA	.QXE@yyR@R"NF#8UjtD T*kCS"$w]MbcOnx*TC?|"'0j k$#PvO2jwA9[|4̷.`A΢t.
77^,grII`x
Rn|N		֬1iNyVOG YNec])Q~y^:J,1I9$9l,=KMLam9͕QQXZt! !;s[.vUEUU>xbf]օlMSĳ>REEx<EĘ}=OKN1! G-D</WԦIǩ5g'])5p5Zg`G,(yApgXU22.Ѵ˚q+!}{s0RlW,-3_2
/pû;yV#V`C=2t'P$RoI!S\/T"Ebku :hn>ჵD9OGFSk)f%Aq'vu0E/QǱkD8!0:D|rdgLƧi.yk?%h#92                                                                                                                                                                                                                                                    Y                        ?        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1
1                                                                                                                    >m              ^Ѭ ެQެPެQެP P ЭSެRЭQެPC	A	 PЏ   P ^aR°iZPЬPՠЭQЬPРЭQЬPРPРЬPЭ   (^全Y
V
XW߭ЬRݢB  ЬR޲RbRRhݽ~&   fЭRբ,fRRfЭR´ fRRfЭRµ fRRfЭSЭRݢϷPЭRSբSSRR땭ЭRµ fRRfЭRµ ݭЭRբݬݬЭRݢϝhݭϤѭh1 ЭRբ0ݧ0ЭRݢ01ЭRТխPݭOЭRТխЭRµ 7^(ynЭR^(nP ɕ
ЭRݢ8#  ݽ-%   ^Rf\¶
C  P̰i   < $^޼R(bެR޲R(bѭ(ѭ(ЭPP 3 3 & P?PPíRRRPíRRRP $^-RЬQСPP  ` |    0 b?P1 bݬv  1 PЬPߢݬX  PߢݬE  1 PЬPݠߢݬ)  sPЬPPPP~ߢݬ  RP߭ЬPݠB  ݭߢ ݬޔ  (߭ЬPݠ?  ݭߢ%ݬ   P  ^ݬcPPPP ^Rլ PЬQСPP $[ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [ [  [ [ [ [  _ } [  [  g P?P:P PЏ   PЬPݠ iPPPPЬPݠ SPPPPߢ(ЬPݠq P ^8Rߢ4ݬ  ߢDݬB  PݭݬFrߢMݬc  լPPЬPѠ6ЬPްP`PPЭPݠЬPݠЭPРPݠݬ<  ЬPРլߢQݬ  ݭݬqߢTݬ  ߢWݬA  Pߢeݬ  ݭݬqߢpݬ  ݭݬfqߢrݬ  aߢuݬA  P ݬ[  ݭݬ q ݬ<  ݭݬq ݬ   ^亮R ݬ  ² ݬ   ݬ@  Pݬp     <^AR߭ݬ<  լPP
PPP ݬo  լ ݬU  hݭ ݬ<   ݬ,  ݬݬ   ݬ
   ݬ  ݬ  Pݭ
ݬԐ  լ
ݬ  լa ޼Pѭ`SPЭQЬPAݬ  ЭQЬPAݬg  PP޼Pѭ`P ^ٵR߭߭ ݬݬj  ݬ  PPݭPPݭPPݬ ) ^iR߭߭ ݬݬ  ݬ  ЬPPݭPPݭPPݬݬ   U   ^ݴRݬݬݬݬ%   ^﫴Rݬd"    ^yR%ݬԎ  ЬPݠݬm.ݬ  ЬPްP` v0     ^ЬPݠЬPݠ    ^Rլ?P 2ݬ0  ЬPݠݬlЬPРլP ^R7ݬ  լ?P Dݬȍ  ЬPݬЬPРլG    ^RլxЬPՠbLݬj  լݬݬЬPРլVݬ9  ݬݬkYݬ  
ݬݬσP ,^RЬQСPP	$ $ $ $ $ $ $ $ $ $ 
P?PP\ݬ  PPЬQСPP < P  d x   d x   d x  d x     x  
P^?P1 ^ݬ\  1 fݬH  1 kݬ4  zPuݬ   fPݬ  RPݬ  >Pݬ  *PݬЋ  P£ݬ  PPp^;X޼R b޼R b޼R b޼R b޼ R bЬRբЬRݢݬ;jЬRТPP $r r r r r r r r r r r r r r r r r r Rr r >  ..RZ :Rr
P?P1ЬRݢݬi1PȮݬ؊  ݬݬ1Pȴݬ  ޼Rb1Ⱦݬ  ޼RS  Pb޼R޲ Rb޼RbVЬR޲RbR^(nGP1dݬD  1Qݬ0  1= ݬݬ߭ݬ ݬЬRѢЬRТPЬRТݭݬ,խ 	нRRЭԭЬRѢ	P ΘRRRRЬRѢЬRТ$
ЬRТ ЭϭЭحխRRЭRТխ޼SRRR;R  Pc޼R޲ RЭbЬRѢ޼RbR  Эحխ<PЭWRR޼RbVнR^(nPGЭRТխ ѭ6PЭURR޼RbTЭSRRЭRCEѭխݭu  1Pݬh  ݬݬ-gݬI  ЬRТ խPݭݬϣЭRТխЬRТ$խ1 ݬ ݬݬݬݬݬЭRݢݬ-ݬч  ЭRݢݬfݬ  ЭRТխ8ЭRݢݬσЭRݢЭRݢݬЭRТխݬX  ЭRݢݬfݬ5  ݬ%  12Pݬ ݬݬݬݬݬЬRݢݬA޼Rb1 Pݬ ݬݬݬݬݬЬRݢ ݬ	1 Pݬ  1 ݬ  ЬRݢݬ
ݬs  1 ݬ ݬݬݬݬݬЬRТ,RݢݬЬRV  ޼Rb޼SЬRТ(c,ݬ  PЬRݢdPP  ^߭߭ ݬݬ
 Θ^GRЬPްP`PPЬPРЭPѠ$ЭPР ЭЭɭЭQСPP  vvvvvvvvvvvvvvv: v 
P&?P1=#ݬ$  ݭݬc3ݬ  ݭݬc5ݬ  1P8ݬЄ  ЭPРЭPՠݭ7PAݬ  1ЭPРЭPѠЭPРЭPР 
ЭPРЭPѠ
ЭPѠ1 ЭP$1 ЭP$ЭPѠ
IPPPYPPխ3hݬ  ݭݬbݭqݬ  ЭPРխSݬă  ЭPݠݬbݭݭݬ  ŭPPЭPРխݬr  1 P ЭPРխPP§ݬH  ЭPݠݬ	bݭ°ݬ!  PPЭPРխݬ  ݬ  P߭߭ݭݭݬ	ЭPѠ@ݬ  PPݭ욭PPݭPPЬPݠݬݬc  ЭPA1OЭPѠ1Bݬ:  ݬ*  ЬPݠݬ`ݬ  ЬPݠݬ`ݬ  
ݬԁ  ЬPݠݬ`ݬ  ЬPݠݬr`ݬ  ,ݬ~  3ݬn  ЬPݠݬ/`=ݬK  Gݬ;  ЬPݠݬ_Mݬ  Yݬ  ЭPѠ$1aݬ  rݬۀ  ЬPݠݬ_xݬ  ЭPݠݬݬ  ЬPݠݬV_ݬr  ¤ݬb  ЬPݠݬ#_ªݬ?  ЬPݠݬ _¸ݬ  ЭPݠݬݬ  ݬ  ЬPݠݬ^ݬ  ЬPݠݬ^ݬ  ݬ  ЬPݠݬT^ݬp  ЭPݠݬqݬM  ݬ=  ݬ-  ЬPݠݬ] ݬ
  3ݬ~  ЬPݠݬ]9ݬ~  Jݬ~  ЬPݠݬ]Pݬ~  Zݬ~  ЬPݠݬU]`ݬq~  sݬa~    ^ЬPѠѠЬPР PР
ЬPРЭPP    
P?PPЬP aPЭPЬЭQЬPРP ^ЬPSЬPЬPРխ<PЭP'ЭP(ЭRЭPݠ-PЭRТխP ,^R{ݬW}  լ1 լ1 P ݬ(}  ݬ}  ЬP&/ЬP'ݬ|  ݬ|  Pݬ|  ݬ|  ЬPݠЬPݠݬUЬPРլ1PPݬ|  ¢   m|   (^RЬPްP`PPݭj¤ݬ6|  ЭPРPݠݬ3­ݬ|  ЬPݠݬZ¯ݬ{  ЭPݠݬaݬ{  ݬ{  ݬ{  ݬ{    ^լkPЬQСPP  , 0 @ 
PZ?P9Pݬݬi&P!PݬݬݬݬqЬPРլP ^蘒RЬPްP`PPЭP 1ЭSЬPݠ*  Pݬz  ЭPݠݬYݬz  ЭPݠ(ݬz                                                                                                                                                                                                                                                     Z                        ¥Z        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1  1                                                                                                                                  	ݬz    
ݬXz  ЭQЭPA4ݬ;z  ݬ&z  ЭPݠݬz  ݬy  ЭPݠ#ݬy  ЭP>P<`PP1ݬy  >ݬy  ЭP PPDݬy  Mݬy    Qݬhy  ЭQЭPA!PPTݬHy  Yݬ3y  P ά^﷞RcЬPݠ2(  Poݬx  ݭݬWxݬx  ݭݬWݬx  ЬPްP`PPݬx  ЭPРխ1 ЭPݠJ	  uЭPݠ
  Pݬ<x  CP8x  P°ݬx  ݬw  ݬw  ݬw  ЭPРխ12ЭPՠ,Vݬw  ЭPݠ0ݬݬw  ЭPݠ,ݬCVݬ_w  ݬݬ2ЭPݠݬЭP :PPЭPݠЬPݠݬcPPЬPݠݬݬv    | 0^mTS	Vv  UR բ@1 @1 dݢ@v  PoТ@ݢ@v  P"\\\\ߤݭ<v  P\\\\ݭݭߤe0v  f1 eߤu  \l\\\9ݢ<c\l
c\l \\f\\ߤeu  7Pݢ<c\l
c\l \\f\\ߤ'eu  c\lV Э\LcЭ\Lc
PPխ,
e 8u  cݭߤ9e3u  eߤEu  P ^S"u  TRլ	բD\PPPߣHdt   լdݬt  d
t  լDdߣTt  լd
st   D   ^e=  PЬЭPЬЭPЬЭP ЭP ЭP ЭP ЭP ЭP  ^ݬݬ޼P`PЬPՠЬPЭЬPЭЬPРPЭЬP  ^޼P`EЬPՠ ݬݬݬЬPݠPЬRݬݬݬP޼RbBЬRբݬݬݬЬRݢ~ЬRݬݬݬP޼RbݬݬݬP ^%RPPբ4ݬݬݬaP4Pݬݬݬݢ4 ^R0PP0բ4ݬݬݬ
P4ݬݬݬݢ4 ^}Râ8PP ѭ)Pݬݏ   ݬr  PPѭЬ8 ^R r  S޼P`ݬ޼P`ݬߢbcq  ЬPݠЬPݠcq  ЬPРխ8Pߢ{cq  ЭPݠЭPݠc|q  ЭPРխ  ^ЬPՠЬPݠݬݬݬݬݬЬPՠЬPݠݬݬP ^SRբ4F߭ݬ  Á ݭp  Pݢ4ݭݭV 4 8Џ   P P ^1SRբ< ݬݢ<Ã p  yp  PݬÐ p  ]p   F9  ݏDp  P ^ɛSRRݢ<ݬÔ 2p  p  0PP0Ѣ0ݏo    ^P <  ^Rբ<ݢ<ݬo  	P޼P `  ^ݬwo  P'ݬϛo  >P<`PʏPP @  (P @  P   P   	P PP2 P  4^߭ݬ  ݭo  P Џ  լ޼P `լ޼P `լ޼P `PPխEPЭP@](PPխ
ЭPPЭԭܐPPխլ0$ݭݭݬ1n  ЭP޼Q @a
P޼P `ЭЭЭѭ7PЭP@.PPPPPPѭPѭPzíPPPíPPЭԭլ$ݭЭP@ݬm  ЭP޼Q @aլ޼P `լЭP@ݬsm  P  ^߭ݬ    ݭUm  PѭP<ЭP@$P@(Џ   PPPݭm  PѭP2  P ^9Rݬݬl  ݬݬl  լߢݬl  ݬ l   ^Rݬݬul  Pխ(ݬݬߢl  P  ^߭ݬ  ޼P`];Pݬݭk  Pݭݬ
l  Џ   PP P߭ݬ   ЭP޼Q@aTݬ ݭЭP޼Q@aݬݬk  PЏ   PPPЭP޼Q@a P    θ^RS߭ݬ   ݭ]ݬݬPݭ޼P` P¼ j  Pݭ޼P` P
 K  "c>  PcPЭcP PP ^S,R 4ݢ4j   ݬA\j  ݬLj  þ j  Pխ" (j  \P ^sRݬ i  %  ^E\   i  i      ^ЬP P PЬPРխ"PЭPѠЏ   PЭPРխ2  P ^޼P`޼P`3P޼P`,&ЬRPPЬQPPab޼RbЬPRR `޼RbRR޼Rb2޼Rb,&ЬQRRЬPRR`a޼RbЬPRR `޼RbRR޼Rb2޼Rb,&ЬQRRЬPRR`a޼RbЬPRR    ^    Y+  0^!TSRլ "g   DdݬݬF  4g  g  9g  =>6g  =>]g  ig  8} ЭP@DPPPЭP@DP @DQ}PPADխ!PЭQP@DADPPխÆPPDÉdC  /d	  f    ¥ ݢ@p   P f     PP  ^ p/  rf   ^TS ߣx߭MPPݬ  PPխ =9ЭPРPݠ(Ďf  ЭRЭPݠ  P?   0ЭPްP`6ߣxߣDݭ 1ЭPްP`k6P ^S
RÖЬPްP`P:;ÙЬPްP`P=PPEPPݭݬ+  =PP%PPݭ  ^
RЬPްP`:P ЬPްP`P¥ ЬPްP`P ЬPްP`P=PP¤ PP<PP;PPݭݭݭݬ    ^
R޼P`-	PP Q޼PA`P`eѭ   [PQ޼PA`P`ݬc  PЭP@/PPPPPPPQ޼PA`P`ѭ   PЏPP ^=
S޼Rb-	PP R޼PB`Rb1 ѭ   1 ݬec  PRQ޼PA`P`Kc  RP;Q޼PA`P`ݬc  PЭQЭA/PPPPPPA/PPQ޼PA`P`ѭ   1rPP  ^e\̰ P  ^QQ Ѭ ЬP@ P PP| ^蘿Ub  VSլ1q T޼RDbRb1޼Rbܑ-	PPݭ:b  PTR޼PB`Rb b  TP1R޼PB`Rbݭa  P1fRЬPBRxbPʏ PPˏPPˏPPխRЬPBRˏ bPPЭPP G  W	"?PPRЬPBRbefJa  <a  RЬPBRbЭRPPR1 Ѭ|ЭRPPPP޼P``  PbPPլխ޼Pް P`-1bPЭQЭЁA/PPA/ЭQPPQѬP1RЬPBRbխЭP@/PPPPPPЭRPPRyѬsPPP޼P`PPլխ޼Pް P`- 1PPЭQЭ́A/PPA/ЭQPPQ
ѬP1RЬPBRb䒽PP1PRЬPBRb䐏1PRЬPBRb 1qPRЬPBRbЭRPPR}ѬwPPPЭQPP޼Pް P`aPPլխ޼Pް P`-1ЭQЭȁA/PPA/ЭQPPQѬP1RЬPBRbЭRPPR1 Ѭ|ЭRPPPP޼P`\^  PPbPPլխ޼Pް P`-1ЭQЭāA/PPA/ЭQPPQѬP1RЬPBRbЭRPPR1 Ѭ|ЭRPPPP޼P`]  PbPPլխ޼Pް P`-1RPЭQЭA/PPA/ЭQPPQѬPtPPPR޼PB`Rb1޼R޲ Rb-.޼Rbߥ&fE]  ݬF   ,]  Pð Tð RRð ޼RbDô RRRRլ1P ^R\  SzT  Q޼PA`P`RQ޼PA`P`\  PQ޼PA`P`                                                                                                                                                                                                                                                   [                        )[        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1;1                                                                                                                                 \  PPPQ޼PA`P`PPߢEcW\   Q޼PA`P`1PQЬPAP`ˏPP1PxPʏ PPˏPPխЭP@/PPPPˏ PPQ޼PA`P`ݭߢUc[  խ	խЭPP I  
P:?PPQЬPAP`ߢ^ca[  S[  QЬPAP`ЭQPPQ0ЭQPPa c[  ЭQPPQ cZ  1PQЬPAP`ЭQPPQ1ЭQPPa cZ  ЭQPPQ cZ  1>PQЬPAP`ЭQPPQJЭQPPa PP	 PPݭ c,Z  ЭQPPQ cZ  1QЬPAP`ЭQPPQJЭQPPa¢ PP	 PPݭ cY  ЭQPPQ¥ cY  1=QЬPAP`ЭQPPQ4ЭQPPaPP§ cBY  ЭQPPQ« c"Y  1 PQЬPAP`ЭQPPQ2ЭQPPPa~­ cX  ЭQPPQ³ cX  jPQЬPAP`ЭQPPQ1ЭQPPaµ cqX  ЭQPPQ¹ cQX  PPPQ޼PA`P`1» c X       ^W   ЬPPPPݭpP 5ݭFݭW  P  ^ ЬRxQPPPPQQQˏPPЭPPP̭PPͭPPPPP  ^ ЬOxQPPPQQˏPPЭPPP̭PPͭPPPPЭP ^V  TLSÄ ݬV  b ЭR޼PB`QЭP@PPP@dPP!ЭRЭP@PP#V  PPPBPPЭP޼Q@aPz  P{M  PQPPRR
RBÈ 
խ1 PPz  P{M  PQPPRR
RBÈ 
խXPխ#
P@Í RbU  PЭPíPPխ
M  PP
P@È խsU  PP
RBÉ RݭB  Pb
RBÍ Rݭ)  Pb
RBÍ RbU  ݬ
RBÉ RbT  
RBÑ R b
R BÈ Ä RRÄ P ^暑R>Sլ޼QޢPPaP޼Q
P@É P`a ^	S
P@È PPЭPՠ	$ЭRZ  P	Т	ЭP 4PЭPР	ѽÀ  P%  PЭPЭЭЭRЬЭPЭ	À ЭRÀ P@0ЭPЭÀ PЭ@0   Џ   P  ^I Qլ P
P@ P` P
P@ P`PРP  ^
 Qլ P
P@ P` P
P@ Pް P`  P
P@ PР P P ^SR  \\  \ L0PߣU ^فSnR ߣ10 P \\ @0խ5Э\ЬЭPЭ\Ь	ЭЭ\ЬݭR  խP ^Rݬt P@q fR  t ݬ[R  Pt PPt ЭP ^Q޼RЬP@q PPb  ^P 
\L 
\L \ lL   ,^｀RRS 
\LÈ 1 
\LÉ \lߢIQ  
\LÈ ߢUQ  ߢlQ  
\LÑ \lխqPݽ lQ  Э\ݬ XQ  Э\ݬ­ DQ  Э\ݬ 0Q  Э\ݬ Q  Э\ЬխL  'P  ^e\ t   ^߭ݬݭݬP  ݏ   PP  ^߭ݬ߭ݬݭݭݬoP  ݏ   hPP     ^ЬPѠ ЬPРݬP  ЭPPЬPP ^ЬPOЬP ЬPРխ9ЭP'ЭP(ЭRЭPݠPЭRТխP ^pRЬPРЭP 1ЭSbЬPݠPߢݬ`O  ЭPݠݬ!.ߢݬ>O  ЭPݠ(ߢ(ݬ'O  ߢ7ݬO    ߢCݬN  ЭQЭPA4ߢFݬN  ߢIݬN  ЭPݠߢMݬN  ߢ]ݬN  ЭPݠߢhݬN  ЭP>P<`PP ݬfN   ݬVN  ЭP PP­ ݬ;N   ݬ+N     ݬN  ЭQЭPA!PP ݬM   ݬM  P $^}RЬQСPP  ` |    0 ^?P1  ݬM  1 ЬP ݬkM   ݬXM  1 ЬPݠݬ<M  fPЬPPPP~ݬM  E߭ЬPݠݭݬL  PЬPݠݬ+PP ^|SﶸRѬ0bЬ0ЬPP  - Q A Q 	V?P>PݬL  *PݬlL  PݬXL  PP ^|S4RЬPРխ1[PЭPРQСPP P P P P P P P P P P P P P P P P P P P P P P P P T T T T T T T P 
P?PP1 QPPQK  PPЭPЭЭQЭPР  ݬϋݭݬ *'ݬ<K  ЭPݠݬ'+ݬK  ЭPЭd   QPPЭA4P.4ЭPРխ1P ^ﹶR?P\\\L4Э\ЬЭPЭ\Ь ݭyJ  P ^=zRݬϐЬPݠݬ!)Zݬ=J  ЬPݠݬ`^   J   ^yRЬPݠݬ(aݬI  ЬPݠݬe   I   ^yRլ?P hݬI  ЬPݠݬQ(ЬPРլP ^1yRլ=P mݬ8I  ЬPݬ[ЬPРլpݬ	I   ^xRtݬH  լPݬݬϿЬPРլwݬH    ^}xRݬϗ{ݬH  ЬPРPРЭPQѠ!QQPP}ݬ\H  PݬHH  ЬPݠݬϓ	ݬ"H  ݭݬ H   H^wRЬPՠЬPݠݬ&ЬQСPP $  q     m   5551	EeY ]	:?P1ЬPݠݬ5&1P´ݬLG  1½ݬ8G  1uݬ$G  1aݬG  1MݬF  19ݬF  1%ݬF  1ݬF  1ݬF  ЬPݠݬϗ1ЬPݠݬϻݬwF  ЬPݠ ݬϚ1PݬPF  1ݬ<F  1yݬ(F  1eݬF  1Q$ݬ F  1=+ݬE  ЬPްP`ݬ3ݬE  1=ݬE  1FݬE  1RݬE  1[ݬxE  ЬPР խ8 cݬHE  ݽݬ7ЭPРխfݬE  ЬPݠݬ1IlݬD  ЬPݠ ݬtݬD  ЬPݠ ݬЬPР$խ+wݬD  ݽݬϗЭPРխzݬ}D  ЬPݠݬh1ݬXD  ЬPР խPݭݬ#ЭPРխЬPՠ$1 ЬPР$ݬD  ЭPݠݬ"ݬC  ЭPݠݬݬC  ЭPРխ2PЭPݠݬ7ЭPݠݬϊЭPРխݬtC  1 ݬ`C  ЬPݠݬK1 ЬPݠ ݬ7yvPݬ$C  ЬPݠݬOݬC  AЬPݬ7-¡ݬB  PªЬPݠ PP ^﩮R  PЬЭPЬЭP   x^CrRdSݬϏխ1&ЭPѠ Ѡ1 1Pºݬ(B  ݽݬ ݬ	B  ݽݬ ݬA  ݬA  ݽݬ ݬA  ݽݬ ݬA  1]IݬA  ݽݬM TݬiA  fݬYA  ݬIA  ݬ9A  ¼ݬ)A  ݽݬݬ
A  ݬ@  ݬ@  
ݬ@  -ݬ@  ݽݬ8ݬ@  Jݬ@  gݬ@  ݬ{@  ݽݬ@ݬ\@  ݬL@  ²ݬ<@  ЭPРխ1P ,^oRЬPРЭPѠ_ݬ- ЭPРխAPЭPݠݬݭݬ?  PPЭPРխЭPѠ"ЭPݬ? ݬϳЬPݠݬDݬ`?  ݭݬOݬC?  ЭPѠ" hЭPAЭPѠ ЬPݠUЭPѠ$ЬPݠ;P  ^ЬQСPP1 9 9 9  P?P PЬPݠ PPPPЏ   P P ,^inRլ                                                                                                                                                                                                                                                   \                        n        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1
1                                                                                                                                 1 ݬ{>  լ1 P ݬT>  ЬP&/ЬP'ݬ2>  ݬ >  Pݬ>  ЬPݠݬݬ=  ЬPݠPݬ=  ЬPݠݬϱЬPРլ14ݬ=  P ^UmRЬPѠ	ЬPР ЬPѠ ЬPѠPݬH=  P/ݬ4=  P  ^lRЬPРݭݭݬϵݬ)ЭPРPРPQѠ!QQPPNݬ<  Xݬ<  ЬPݠݬuЭPݠݬ?cݬ{<  ЭPРPݠݬbЭPРPݠݬPgݬ<<   kP  ^լePЬQСPP  ( , < 
P?P3Pݬݬ"PݬݬϳݬݬϫЬPРլݬ<P ^}kRݬݬݬeݬ;  ݬݬpݬd;     Q;   ^kR ݬgЬխ*ЭPѠЭPݠݬЭPРխݬPݭݬݬ:  Ьխ^PЭPѠDЭPݠݬ{ªݬ:  ЭPݠݬ®ݬv:  ЭPРխ±ݬX:   χݬw·ݬ[Pݭݬݬ:  ݭݬݬ9  RݬPݭݬݬ9  ݭݬݬ9   ^aiRݬϴݬPݭݬ5ݬL9  Pݬ89  P ^hRSЬPР0ЬPݠ%P<ݬ8  ݭݬEݬ8  ݭݬbݬ8  ЬPРlݬ8  ЭPРխ1 ЭPݠBլuЭPݠPݬ48  CP08  P§ݬ8  ݬ7  ݬ7  ݬ7  ЭPРխ12ЭP PPݬݬݬЭPݠݬLЭP ZЭPՠ,ЭPݠ0ЭPݠ,ݬϜPPЭPݠЬPݠݬPPЬPݠݬπ     ^P  ^    ^ݬ6  Pխm2ݏ6  P p^{mRЬPP $Z n  &" b^ v :6NJ   r
PV?P1ߢݬI6  1Pߢݬ56  1Pߢ ݬ!6  1~Pߢ,ݬ
6  1jPߢ:ݬ5  1VPߢNݬ5  1BPߢWݬ5  1.Pߢgݬ5  1Pߢxݬ5  1P ݬ5  1 ݬ5  1¨ ݬl5  1´ ݬX5  1 ݬD5  1 ݬ05  1 ݬ5  1y ݬ5  1e ݬ4  1Q
ݬ4  1=ݬ4  1)ݬ4  1+ݬ4  1:ݬ4  1 Nݬ|4  1 ^ݬh4  1 kݬT4  1 |ݬ@4  1 ݬ,4  1 ݬ4  vP°ݬ4  bPݬ3  NPݬ3  :Pݬ3  &Pݬ3  Pݬ3     | ^SlS`UTrVR 
  Pխ1PЭPP P d h t             08@HP(D`tj?P15   P P14P1/ЏG  P1#ЏH  P1ЏI  P1ЏJ  P1ЏK  P1ЏM  P1ЏN  P1ЏP  P1ЏQ  P1ЏR  P1ЏS  P1ЏO  P1ЏT  P1 
  1P ]  PP1xP M  PP1hPd1`Pd1XP d1PP d1HP1  b1  P @IPeЏV  P1	P1  b1  P @	PeЏV  P1 Pd P	  
PЏL  P1  i  1 Pb  PP1 Pecb0  ЏW  PpPeߣ0  ЏW  PReߣ0  ЏW  P6e	  PP"b\\PPPݭߣf0   g
  Pխ1K2  P  ^Yi\=߬!0  {0  m0   ^TzRGS 3  q\c\c\\cc\l\ \2\\\/  PЭbb
d\\db\\b\\ѭ b\\Эխ$Эbb
d\\dcPc\\cb\\` P 2 P ^RX P@0P`CPP@0P`ݬX/  PP@4P`PPPP@0P`Y P@P`EP@P`ݬ.  PP@P`PPPP@P`&X P@xP`EP@xP`ݬ.  PP@|P`PPPP@xP`ݏ   ݬP6ݏ   ݬjPЏU  PP ^fRz\լ,ݬ,
.  P,լ,ݬ,-  P^fXxUiVRWSTѤ(
 g\c\c\\cc\l\ \2\\\Pf-  PЭbb
e\\eb\\b\\ѭ b\\Эխ1ѭ'
ѭ"1mg\c\c\\cc\l\ \2\\\f,  PЭbb
e\\eb\\b\\ѭ b\\Эխ1ѭ'
ѭ"1WЭ\ LФ(P(\\(f@dg\c\c\\cc\l\ \2\\\Pf+  PЭbb
e\\eb\\b\\ѭ b\\Эխ1} ѭ;ug\c\c\\cc\l\ \2\\\fj+  PЭbb
e\\eb\\b\\ѭ b\\Эխ2>+  Pff"4Q+   PPЭP\\\\@g\c\c\\cc\l\ \2\\\f*  PЭbb
e\\eb\\b\\ѭ b\\Эխ1g\c\c\\cc\l\ \2\\\f"*  PЭbb
e\\eb\\b\\ѭ b\\Эխ1P  ^ePՠ((\\(Р(\L`| ^TVSURe\b\b\\bb\l\ \2\\\fV)  PЭcc
d\\dc\\c\\ѭ c\\Эխ1,ѭ*1 e\b\b\\bb\l\ \2\\\f(  PЭcc
d\\dc\\c\\ѭ c\\Эѭ/1 !Эcc
d\\dbPb\\bc\\`Pխ  e\b\b\\bb\l\ \2\\\f*(  PЭcc
d\\dc\\c\\ѭ c\\Эխ1P| ^ɺTﺺV'S,URe\b\b\\bb\l\ \2\\\f'  PЭcc
d\\dc\\c\\ѭ c\\Эխ1 ѭ}   1 
խ e\b\b\\bb\l\ \2\\\f&  PЭcc
d\\dc\\c\\ѭ c\\Эխ1lP ^_R?ЬP޼P`Sݬ]&  PЬPЬP	ЬP
ЬPЬPЬP
ЬPЬPЏA  P0^WXZYVθT3S R)[kUUP ټkUUUh\\ﲤЭ,
	\\нi\ѭ\ Э\Ьխ1'Pi\ѽ\1ЭU\\\b\b\\bb\l\ \2\\\$  PЭcc
d\\dc\\c\\ѭ؏ c\\Эܭ\\eЭi\ѭ\1 ŭ\\\ѭj1 \\PPf\\PPxЭ\\\PPf\\Pf\P\0\\\\cc
d\\dbPb\\bc\\`1ЭQ\\Э\\\PPf\\PPЭa11}i\ѭ\1piPi\­\\\\\PPЭŭ\\\ѭj1 \\PPf\\PPwЭ\\\PPf\\Pf\P\/\\\\cc
d\\dbPb\\bc\\`14ЭQ\\Э\\\PPf\\PPЭa1Э\LU\\\\\ѭj1 \\PPf\\PPyЭ\\\PPf\\Pf\P\1\\\\cc
d\\dbPb\\bc\\`1 PЭQ\\Э\\\PPf\\PPЭaUЭ\Ьխнi\ѭ\13P\\\\cc
d\\dbPb\\bc\\`P1ЭU\\h\U\1MЭP\\ `ս1 н\Ьgg1 g\l1 Эg\l\L1 g\l\\н\ݬ  Plh\ѭ\cP\\ЭP\\`\\cc
d\\dbPb\\bc\\`g\l\\н\ݬH  Ph\ѭ\\\UЭ%k\\\\\\ LkgPg\\g`P\\cc
d\\dbPb\\bc\\`ЭP\\h\P\1k)\\b P\b\b\\bb\l\ \2\\\Pqz   PЭcc
d\\dc\\c\\ѭ؏                                                                                                                                                                                                                                                    ]                        U0        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1  1                                                                                                                     N             c\\\\kk\\PJ]:G   k\\1n  ^լ P޼P`!PЬQPPaP޼P` P ^!SR\b\b\\bb\l\ \2\\\Pu~  PЭcc
c\\Zc\\c\\ѭ c\\P  ^dݬQ   ^qS>RЬcc
PPbQbPPbcPPaL^_\\X﹬[WgY@ZѝV ͲЏf ɵ 2ͶRRRRkf2ͲRRl  RRRѭR߬qPͲRR(j2ͲRBgͰͰ1 Pf Pff f2ͰRfRRRRͰͰ
ͰPRP2ͰRBiͰ2ͰR2BRRf3Џf(ɳjͰͲC:RR21P2ͲRBtͰͰ1 f 
Pff fRR챽ЭRͲ PRR챽ЭRͲRR쵽2RRfRR쵽ЭRͰͰ PͰ12oRRPP  1 1  	?P1 ߬(ͧϳRRƳ/͸RѭR1 2R2BgR   RRRRͰͰ/Ͱ&2ͰR2BiRBr 2ͰRBiͲ1P2RBgͰkЭR2RR2RR߬5Y  RRRR͸RѭR1iPkf߬`#  fЏf1Pk2ͰRR́   2ͰR2B`RRRRRRЭ2ͰR2BARRRRRRЭR(jͰʹ2ͰRBsͰ2ͰR2B,S2RRSSSRRͶͶ$2ͶRBiͲ2ͲSͰRC4RP2ͰR2BRBiͲ2ʹRRPPP  yyyyy
yy=amqyyy)EyQmyyyy%M]qyyy)Meyyyyy	)9IYiyyyyyyyyyyy)Y}y		-	I	]	i		y		
yyy%
5
E
Y
u
y



)Qyq	!uyyyyyyyyyyy!
yyyyyu




y


	y-yyyyyyAMYeq
!=yQmyyyy-=Qauy=Uyyyyyyyyyyyyyyyy}y%5EUeuy9Uyyy1eyyyyy1Qqyyyyyyyyyyy-Iey	eyyy)5AMyYu}yyyyyAQi	R?P1н@ݭЭRݢ6PЭ1PЭRТj1x1yd1m Y1bPЭRТ0ЭRТRR1=ЭRТЭRТܞRR1(11	ЭRТ1Њ1΋ ̌ Ӧ︋RBﰊSЭRТcRBSЭRТcRR1ݽ Pj1ݽЭRݢPj1gP  Pj1QݽЭRݢ%Pj17PЭRТj1)ݽЭRݢPj1PݽPj1PݽЭRݢ}Pj1Pнj1нj1ݽЭRݢQPj1PЭRݢ ЭRݢ*Pj1&PЭRЭRнЭj1jPݽEPj1WPPЭRЭRнЭj1.P VPj1ݏ   *Pj1 Pj1ݽЭRݢ}Pj1PЭRݢЭRݢVPj1нЭRݢݭLPj1PЭRТj1ݽЭRݢPj1wPPЭSЭRТЭj1RP^PЭSЭRТЭj1.P:PЭj1P "PЭSЭRТЭj1P Pj1Pj1Pj1Pj1vPj1fPj1VPj1FPj1p6Pj1`	&Pj1P
Pj1@Pj10Pj1 Pj1Pj1 ݽ	Pj1PPj1ЭRݢzPj1ݽЭRݢIPj1Pݽ
Pj1PݽЭRݢPj1{PнЭRТЭ ݭPj1RPнЭRТЭЭRТݭݭPj1 нЭRТЭݭPj1ЭRТj1ݽЭRݢ
Pj1P ݽ"Pj1н\Pj1Pнݏ   ݏ   Pj1ЭRТj1y ݽPj1d ЭRݢPj1LݽЭRݢPj13Pݽ Pj1ЭRТj1ЭRТ୘ݽЭRݢ Pj1PЭRТ୔ݽЭRݢЭRݢPj1PݽЭRݢPj1PнЭRݢPj1zPЭRТЭRݢPj1VPЭRТ\1EЭRТP15ݽuPj1#PݽЭRݢMPj1PݽEPj1PݽЭRݢPj1PЭRݢЭRݢ Pj1ЭRݢЭRݢ Pj1 ЭRݢ Pj1yЭRݢЭRݢЭRݢPj1SPЭRݢЭRݢЭRݢqPj1+P ЭRݢЭRݢNPj1ݽЭRݢPj1
PݽqPj1
P!PݽPj1
!zP Pj1
PнЭRݢPj1r
PЭRݢPj1[
P!PxxЭRݢ P||q|ЭRݢPj1
!PppЭRݢЭRݢPtttЭRݢEPj1PЭRТllЭRݢ CPhhhЭRݢPj1YЭRТddЭRݢЭRݢP``q`ЭRݢPj11؄1Є1＄1ЭRТj1ݽЭRݢ
Pj1P j1Pн\\ЭRݢ"\ЭRݢPj1pнj1iݽЭRݢPj1OPݽPj1;P1-,1!11	܃փRRRR1
ﴃﮃRRRRۀ1
Ѐ1
1
ЭRТj1
 1
P 1
Pp1y
 e1n
Pݽ Pj1X
ݽЭRݢPj1?
P  Pj1)
ݽЭRݢPj1
PЭRݢPj1	PݽЭRݢyPj1	Pݽ ЭRݢVPj1	RPXXRXRнXj1	PݽmPTTj1x	PPPRPRнPj1N	P vPj1<	ݏ   JPj1(	 :Pj1	ݽPj1	PЭRТLݽL:Pj1ЭRТHݽHPj1ЭRݢݽYPj1PݽЭRݢPj1PPDDSЭRТDj1gPrP@@SЭRТ@j1?PJP<<j1% 2P88SЭRТ8j1PݽPj1PPj1Pj1 }1P}1P}1P}1P }1P }1P y}1vP Pj1gP Pj1WP Pj1GP
Pj14 Pj1$Pj1!Pj1Pj1Pj1нj1 ЭRݢZPj1ЭRТ44RТ$SЭRТ1 ЭRݢЭRݢ P 
Pj1t ЭRݢЭRݢݽ~P Pj1CPݽЭRݢ=Pj1'PݽЭRݢнRݢIPj1PݽЭRݢPj1PЭRݢ勵Pj1PݽЭRݢPj1PЭRТ0ЭRݢ0ЭRݢPj1}ЭRТ,ЭRݢ,ЭRݢkPj1IЭRТ(ЭRݢ(zЭRݢ7Pj1ЭRТ$ЭRݢ$FЭRݢPj1ЭRТz1ЭRТz1ݽbPj1ݽNPj1ݽ:Pj1ЭRТj1yݽЭRݢPj1_PݽPj1KPн    DPj1*Pн  $Pj1
Pнݏ     Pj1PЭRݢ
Pj1PݽЭRݢ
Pj1P !ݽPj1  ݽPj1 #ݽPj1i ЭRݢPj1M ЭRݢPj11ݽЭRݢzPj1ݽЭRݢ^Pj1ݽЭRݢBPj1ݽЭRݢPj1PЭRݢEPj1PЭRТRнj1 "ЭRݢ׿Pj1qЭRТݽgЭRݢݽPЭRݢﯹPj1ЭRТݽЭRݢݽP&ЭRݢSPj1~P ݽ  ݽGPЭRݢPj1]Dz1Q0z1E(z19z1-ЭRТj1!ݽЭRݢePj1P j1 PЭRТݽ                                                                                                                                                                                                                                                   ^                        D        RPC010.B                       =	  !  %[UCX.V13.BL13.RPCKIT.B]RPC$NIDL.EXE;1;1;1                                                                                                                    Z             2ݽkPYPj1 PЭRТݽݽ'PPjxЭRТݽݽPPj88v j+Pxx jPt jP1                                                                                                                                                                                                                                                                                            @   @                                                    T   L      
           d    l   d      t         |     t      D      ,
  t	        
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                                                                                       ' * [UCX.V13.BL13.RPCKIT.B]RPC$NRGLBD.EXE;1 +  , >	   . ,    /    4     ,   ,                     - !   0   1    2   3      K  P   W   O -    5 	  6 aΓ  7 @@( ϓ  8          9          G #  H  J                           0 D X     0205      (   N     R  	                                      
RPC$NRGLBD                             RPC V1.0A-00   9 Γ 05-05                      %            )   
  *     ?   #      +         RPC$LIBNCK_001       !        VAXCRTL_001      !        
LIBRTL_001      !       
MTHRTL_001  <unknown> GLBD: unable to listen on %.*s address family
 GLBD: unable to listen on any address families
 GLBD:  non-replicated GLB GLBD:  nrglbd/nck version 1.5 Listening...
 GLBD:    rpc$exe:glbdbase.dat    rpc$exe:llbdbase.dat    @(#)glbd.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
        @(#)glb_sstub.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
     (  ,)  \)  (    t
      |(    @(#)glb_man.c	2.2     (ultrix)        11/16/89                                                                     i.;3    
                                                                       3;3    
          @(#)llb_man.c	2.2     (ultrix)        11/16/89                                                                     i.;3    
                                                                       3;3    
                              @(#)llb_sstub.c	2.1     (ultrix)        6/13/89                                                                     i.;3    
                                                                       3;3    
     3  83  h3  4  L=  F                                                                                                                                                                                                                                                                                                 l^VW  ͠߭߭SJ   ѭ1 ͠RB<RB,ЭR<BRRJ  ͠RR
͠Rb2PЭSЭRBCSR(B,C,RRJPf͌!J  ͠߭͌ЭR<BRRI  ͌ݭߦ
I  RRѭ11խߦ9I  I  ͠+8I  ͠Rb^(͠nߦiI  }I   ѭwP͠ͤRB<RbRB,ߦpqݬݬ	H  ͠Rb^(͠nƃ H  I  RRѭP| 4^H  VƊ ݬݬRH  pH   `H  ơ H  )H  Rb^(nƯ H  P ^޼P`f<fPPPPPЭQQQG  PPPQP1:QG  PQP1#ެPQH  PQP1Pн`PPP`PPP`PPPPPPݭݭG  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭF  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ"F  PPíPPPPP
Pн`PPPPݏ@   ݭݭE  @   PPíPPPPPNPн`PPRP`PPTPPݭݭtE  16QQQE  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ8E  PPPQPP` PPЭЭPЭPPPQQQD  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ>D  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQC  PPPQPP` PPЭЭPЭPPPQQQC  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQB  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQpB  PPPQPP` PPЭЭPЭPPPQQQ"B  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQvA  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ@  PQP*@  PPP@@  
P@@  PPPPPPխíPPPPPQQQr@  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ?  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ   PPЬ$QPѭPPaaPP޼Rݭ>  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b ^޼P`f<fPPPPPЭQQQ>  PPPQP1:Q>  PQP1#ެPQ>  PQP1Pн`PPP`PPP`PPPPPPݭݭ=  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ[=  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ<  PPíPPPPP
Pн`PPPPݏ@   ݭݭ<  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ0<  16QQQ_<  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ;  PPPQPP` PPЭЭPЭPPPQQQ;  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ:  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  _                        ۅ        RPC010.B                       >	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$NRGLBD.EXE;1
1                                                                                           ,                               
       PQQQ:  PPPQPP` PPЭЭPЭPPPQQQB:  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ9  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ,9  PPPQPP` PPЭЭPЭPPPQQQ8  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ28  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ7  PQP*7  PPP@|7  
P@q7  PPPPPPխíPPPPPQQQ.7  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ6  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ   PPЬ$QPѭPPaaPP޼Rݭ5  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b< ^SR5  PDRݢD35    խݭ5  ^(n4   ޼RbR<RRRRRRЭSSS
5  RRRSR1S4  RSR1ެRS)5  RSR1RнbRRRbRRRbRRRRRRݭݭ,4  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ3  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ23  RRíRRRRRޭRнbRRޭRнb1 SSS+3  RRRSRRнb=PRRЭЭRЭSЭRЭSЭRЭRRRSSS2  RRRSRRb RRЭЭRЭRRRSSSr2  RRRSR
Rb"PRRЭЭRЭRRRRRRRխ'PRRRRRRխíRRRRRSSS1  RRRSR
Rнb<PRRЭЭRЭSЭRЭSЭRЭRRRSSS\1  RRRSRRb RRЭЭRЭRRRSSS1  RRRSR
Rb%PRRЭ||RЭR|RRRRRRխ(PRRRRRRխíRRRRRSSS^0  RRRSR
RнbFPRRxЭttRxxStRxStRxRtRRSSS/  RRRSR
Rb(PRRpЭllRppRlRRSSS/  RRRSRRb&RRhЭddRhhRdRRRRRRխ%RRRRRRխíRRRRRSSS.  RRRSR
ޭRнbFPޭRR`Э\\R``S\R`S\R`R\RRSSSs.  RRRSR
ޭRнbCޭRRXЭTTRXXSTRXSTRXRTŭȏ   RR-  Pݭ߭ݭ߭ݬ	   ŭ̏   RRRRRЬ$SRѭRRccRR޼RݭI-  Pb޼RЬb޼S<RRRRcRRЭЭĽRRЭ̽RRPPRRNNRRNPЏ  ^(n,  RR<NRRխ1{PíRRRRRнԽRRЭR>RbRRЭR>RbRRЭRRRЭR	RRݭݭ(,  RRíRRRRRЭRޢRbRRЭR>RbRRЭR>RbRRЭRRRЭRRRݭݭ+  RRíRRRRRЭRޢ RbRRЭR>$RbRRЭR>&RbRRЭR(RRЭR)RRݭݭ+  RRíRRRRRЭRޢ0RbRRЭR4RRݏ@   ݭݭ*  @   RRíRRRRRЭRޢtRbRRЭR>xRbRRЭRzRRݭݭS*  RRԏ   RRRRխ1íRRRRRRR޼ SíRRcխݭ)  ޼(R b  ^ݬh   ޼$P `޼PЬ`޼ P `޼(P `   ^aR P.ݬݏ  _  P ޼QPaPPP  ^P ^RݬPݬݬ   	   ^RݬkPݬ  M   ^Rݬ$;Pݬ$ݬ ݬݏ   ݬݬݬݬݬ 
      ^ެP޼P`޼P`t(  P PP' (  ޼P`A(  PP PP PެPЬPЬP'  P PP% (  ЬP'  P PP PެPЬP ЬP '  P PP% '  ЬP N'  P PP PެPՠ:ݬ$ЬPݠtЬPxЬPݠtЬPx&  PPPPPЏ   PP ,^޼P `լ޼PЏ`޼Rݬ'  Pb޼Rbn '  P޼Rݏ  ݏ  ݬ&  Pbݭ&  ޼Rb޼Rb&  
P޼RЏ b1-P޼Rb&  ѭU޼Rb&  ѭ&ݬ~&  Pݬݬݬ޼RЏb޼RЏ b1 P޼Rbw ЭS޼Rb*&  PCЭRB޼Rb%  ޼SЭRBc ѭܭ!ЭRB%  RRѭܭЬRŏ   RRЬR޼Rb%  PЬSǏ   RR  ^Pď   P   PPݭu%  Pխ޼PЏ ` Pݭ ݭG%  ЏЭP ЭPЬݬݬݭϱ޼P`ݭ$   PЭP< ^ЬЬRѭ1 ŏ   SЬRCRRŏ   SЬRCRb_լЭSЬ Rѣ00IP(RRݭݬ ^(n	\P#լ$޼$Tŏ   SЬR( CdЭPRRЬRѭ1^ЏP  ^޼P `޼P`Ŭ   PPP ݭ޼P`#  P޼PЏ `GPݏ   ŏ   QЬPA޼P`#  Pѭ   ޼PЏ `PP< ^޼R bѬF ЬRѭ7Pŏ   SЬRCRb
ЭPRRЬRѭЬRѬ
޼RЏ bWЬRѬ
ЬSRRŏ   SЬRCRbŏ   TЬS޼R( bDݬݬݬϕ  ^ЬPѠtЬPѠt޼P `
P޼PЏ `| ^V޼R bݬݬլ	޼Rb( ݏ    ݬ ^(nݬ
FPݬݬݭݬϑ| \^CV޼R bݬݬ:լ	޼Rb( ݏ   \ݬ ^(nݬ
Pѭ+ŏ   SЬRCR bݬݭݬ]P޼RЏ b< T^ լ,)!  ޼Rb   P޼R(bT Pլ+   ޼Rb   P޼R(bd Pլ+   ޼Rbj   P޼R(bt P޼(R b޼$RbRR޼RbѭfRRݭTݭ^(nݬ
ϏPѭ)   RRRRRRѭѭѭ޼R bP޼RЭb޼ RЭbխ޼(RЏ bP ^-R P.ݬݏ  KP ޼QPaPPP ^RݬPݬݬ    ^RݬsPݬ  A ^Rݬ$CPݬ$ݬ ݬݏ   ݬݬݬݬݬ   
 ^5Rݬ(Pݬ(ݬ$ݬ PPݬݬݬݬݬ 
G   ^޼P`f<fPPPPPЭQQQf  PPPQP1:QL  PQP1#ެPQ  PQP1Pн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭ  PPíPPPPP
Pн`PP                                                                                                                                                                                                                                                   `                        N        RPC010.B                       >	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$NRGLBD.EXE;11                                                                                            ,                         k             PPݏ@   ݭݭ@  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ  16QQQ  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQV  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ@  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQF  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQZ  PQP*D  PPP@,  
P@!  PPPPPPխíPPPPPQQQ  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQj  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ: PPЬ$QPѭPPaaPP޼RݭY  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b ^޼P`f<fPPPPPЭQQQ"  PPPQP1:Q  PQP1#ެPQA  PQP1Pн`PPP`PPP`PPPPPPݭݭD  PPíPPPPPPн`PPP`PPP`PPPPPPݭݭ  PPíPPPPPPн`PPP`PP P`PPPPPPݭݭJ  PPíPPPPP
Pн`PPPPݏ@   ݭݭ  @   PPíPPPPPNPн`PPRP`PPTPPݭݭ  16QQQ  PPPQPPн`=PPPЭЭPЭQЭPЭQЭPЭPPPQQQ`  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQf  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQ  PPPQP
P`"PPPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`<PPPЭЭPЭQЭPЭQЭPЭPPPQQQ  PPPQPP` PPЭЭPЭPPPQQQJ  PPPQP
 P`"P PPЭЭPЭPPPPPPPխ'PPPPPPPխíPPPPPQQQ  PPPQP
Pн`FP
PP|ЭxxP||QxP|QxP|PxPPPPЏ@   խfQ  PQP*   PPP@
  
P@
  PPPPPPխíPPPPPQQQ
  PPPQP
NPн`FPNPPtЭppPttQpPtQpPtPpPPQQQ&
  PPPQP
RP`(PRPPlЭhhPllPhPPTPPխ(PPPPPPPխbݬ& PPЬ$QPѭPPaaPP޼Rݭ  Pb޼RЬb޼P<fRRR`RRЭbRR޼ PíRR`޼(R b< ^޼RbV<VRRRRRЭSSS  RRRSR1S  RSR1ެRS  RSR1RнbRRRbRRRbRRRRRRݭݭ   RRíRRRRR RнbRRRbRRRbRRRR	RRݭݭ
  RRíRRRRRRнbRRRbRRRbRRRRRRݭݭ
  RRíRRRRRޭRнbRRޭRнb1SSS	  RRRSRRнb=PRRЭЭRЭSЭRЭSЭRЭRRRSSS	  RRRSRRb RRЭЭRЭRRRSSSF	  RRRSR
Rb"PRRЭЭRЭRRRRRRRխ'PRRRRRRխíRRRRRSSS  RRRSR
 Rнb<P RRЭЭRЭSЭRЭSЭRЭRRRSSS0  RRRSRRb RRЭЭRЭRRRSSS  RRRSR
Rb"PRRЭЭRЭRRRRR	RRխ'PRRRRRRխíRRRRRSSS6  RRRSR
RнbFPRR|ЭxxR||SxR|SxR|RxRRSSS  RRRSR
Rb(PRRtЭppRttRpRRSSSl  RRRSRRb&RRlЭhhRllRhRRRRRRխ%RRRRRRխíRRRRRSSS  RRRSR
ޭRнbFPޭRRdЭ``RddS`RdS`RdR`RRSSSK  RRRSR
ޭRнbCޭRR\ЭXXR\\SXR\SXR\RXP ߭ݭ߭ ݬ	 ŭЏ   RRRRRЬ$SRѭRRccRR޼Rݭ7  Pb
P޼RЬb޼S<VRRRcRRЭЭȽRRЭнRRTTRR<TRRЏ  ^(n   RR<TRRխ1zPíRRRRRнؽRRЭR>RbRRЭR>RbRRЭRRRЭR	RRݭݭ(  RRíRRRRRЭRޢRbRRЭR>RbRRЭR>RbRRЭRRRЭRRRݭݭ  RRíRRRRRЭRޢ RbRRЭR>$RbRRЭR>&RbRRЭR(RRЭR)RRݭݭ  RRíRRRRRЭRޢ0RbRRЭR4RRݏ@   ݭݭ  @   RRíRRRRRЭRޢtRbRRЭR>xRbRRЭRzRRݭݭS  RR؏   RRRRխ1íRRRRRPRR޼ SíRRc޼(R b                                                                                                                                                            @   @   D                                                P    p< x  p  `  h  x   8     (  (        (     `  `   L J 6 K J J            \  d  $     $   ,          <  
       &      J     P   
                 @                                                                       
RPC$LIBNCK                                                     VAXCRTL                                                        LIBRTL                                                                                                                                                                                                                                                                                a                        b        RPC010.B                       >	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$NRGLBD.EXE;1;1                                                                                           ,                               +                                   MTHRTL                                       P                                                                                                                                                                                                                                                                                                                                                                                                                                                                ' * [UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1 +  , ?	   . &   /    4     &  &D                    - !   0   1    2   3      K  P   W   O '   5 	  6  &  7  	9 ϓ  8          9          G #  H  J                                    0     	/     
0          
                	     
         0      
    /          #G     &/     (O     ,     5     <1     =     >     B     B     D*     GC     H\     I     L[     M(     T
      U !    V& "    X #    ]< $    b %    cf &    c '    eN (    f; )    j *    k +    lm ,    oA -    q .    t+ /    u 0    w 1    y 2    |% 3    }m 4    ~^ 5    t 6      7     8     9    9 :     ;    } <     =     >    j                d        B         	    
   	   m   $
   2K   ?   M)   Z   h   uv      T      2               ]      	;      $    1!   >"   Lf#   Y$   gD%   t&   "'   (   9)         `   F   4         H   ř   7   n   i	   ̆
   Ό   h   Ӛ      ڊ            ߸	   M
         
   W         (            '      =	   
   V   "   
         O   <   <   J   J   [   	   !X   "   #0   $   &   )K   *    2$   2   I   K   P   U   g	   g
   j   mp   q
   t   w^   w   y   y   }x   ~|   *	   	   	   	   k	   :	   		   	   		   v	
   	   N	   	
   	   a
   
         D         ,   Z      A
   ǌ
   ɍ   $      B   U   Ғ   ;   ֮      [   ܇                                 |   =    _   r   8      	y   
6   a   P   
   
	   
                       !   #E   &3   )!   +   ,^   /k   2'   4   5   ;{	   <
   =   >   @j   D   E   F   H  OS  $[
    0          	     	       / L   BAT manager 0Z
 tZ
 $[
 H
                    /
 attempt to free already-freed block disk is full attempt to free illegal disk address BAT not mounted disk needs salvaging   	OS  tZ
 $[
 /        $[
     	       / T   VTOC manager Z
 tZ
 $[
 H
                    /
 VTOC not mounted VTOC is bad no file map no UID not found UID not found duplicate UID uid mismatch only local access allowed   OS  tZ
 $[
 0         $[
     	       / \   AST manager 0Z
 tZ
 $[
 H
                    /
 attempted reference to out-of-bounds address  no replaceable aste's segment is not deactivatable write concurrency violation incompatible request reference count says unused segment not found in bst segment thread error in bst only local access allowed system object cannot be deleted   OS  tZ
 $[
         $[
     	       / d   MST manager 0Z
 tZ
 $[
 H
                    /
 object not found invalid length no space available reference to illegal address reference to out-of-bounds address no asid is available object is not mapped no rights insufficient rights guard fault wrong type - can't map system objects ppn list overflow uid mismatch virtual memory resources exhausted invalid va for install of io page invalid segment count asid 0 is illegal for this mapping   OS  tZ
 $[
         $[
     	       / l   PMAP manager Z
 tZ
 $[
 H
                    /
 not allocated already allocated mismatch bad wire bad unwire bad assoc pages wired page null bad disk address read concurrency violation changed pmods invalid pmape attempt to map i/o page over real page bst threads yielded invalid va  illegal pid argument from dxm callback illegal wsl index   OS  tZ
 $[
         $[
     	       / t   MMAP manager Z
 tZ
 $[
 H
                    /
 bad avail bad free bad unavail examined max inconsistent mmape illegal wsl index illegal pid ws lists exhsusted bad install bad reclaim contiguous pages unavailable   OS  tZ
 $[
    	      $[
     	       / |   MMU manager 0Z
 tZ
 $[
 H
                    /
 mmu miss va not in valid mmu manager range va does not have os_pmap ptt parity error pft parity error mmu timeout unknown mmu status mmu parity error data cache parity error unexpected virtual timeout write buffer timeout   (OS  tZ
 $[
    
      $[
     	       /    disk manager Z
 tZ
 $[
 H
                    /
 disk not ready disk controller busy disk controller time-out disk controller error disk equipment check floppy is not 2-sided disk write protected bad disk format disk data check DMA overrun volume in use volume table full volume not properly mounted or assigned operation requires a physical volume invalid volume index logical volume not found disk block header error invalid disk address disk buffer is not page aligned invalid logical volume index or list disk seek error drive timed out before operation completed bus error occurred during disk DMA transfer invalid unit number unknown status returned by hardware invalid physical volume label floppy door has been opened or storage module has been stopped read after write failed dma not at end of range disk already mounted software detected checksum error checksum error in read after write too many wired pages -- storage module manager disk driver logic error unknown error status from drive unrecognized drive id memory parity error during disk write unrecognized interrupt from disktape controller ecc error in sector id field disk subsystem detected a DC powerfail   OS  tZ
 $[
          $[
     	       /    eventcount manager  $[
 H
                    /
 bad wait list on eventcount   OS  tZ
 $[
         $[
     	       /    level 1 process manager H
                    /
 illegal process id illegal lock process not suspended process already suspended process not bound process already bound bad atomic operation no pcb is available no stack space is available process not suspendable ready list is out of order bad deferred interrupt queue   OS  tZ
 $[
 0  
      $[
     	       /    terminal manager Z
 $[
 H
                    /
 buffer too small end of file entered from keyboard invalid output length inv                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  b                        fu̗        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        i             alid option passed to term_$control input buffer overrun - characters lost asynchronous fault occurred while waiting for input invalid line number supplied manual stop: type G<ret>G *+2<ret> to continue character framing error character parity error data carrier detect (dcd) changed clear to send (cts) changed requested line or operation not implemented hangup fault speed incompatible with partner SIO line   OS  tZ
 $[
         $[
     	       /    DBUF manager Z
 tZ
 $[
 H
                    /
 bad ptr bad free   
OS  tZ
 $[
 /         $[
     	       /    time manager Z
 tZ
 $[
 H
                    /
 no timer queue entry entry to be cancelled not found quit while waiting for event bad timer interrupt bad timer key alarm fault real interval timer fault virtual interval timer fault queue element not in use queue element not found cpu time limit exceeded time adjustment out of range queue element already in use   4OS  tZ
 $[
         $[
     	       /    naming server 
 tZ
 $[
 H
                    /
 directory is full name already exists invalid pathname invalid link not a link name not found   invalid link operation invalid leaf node is unavailable bad directory branch is not a directory directory is not empty name is not a file illegal directory operation bad type no rights insufficient rights unable to delete system bootstrap (sysboot) directory is in use (locked) name server helpers clocks are skewed illegal request made of name server helper cannot find entry in replicated root last entry in replicated root returned name server helper is shutdown name server helper sent packet with errors clocks skewed cant find name server helper directory must be root directory not found in pathname too many components in pathname cache entry is stale cache entry was stale and was updated name server helper is uninitialized internal error bad request header version bad request code bad request body version request ignored directories not neighbors directory not local pathname truncated leaf truncated bad buffer size object is not an acl object volume has been mounted read-only write-protected volume prevents recovery of a damaged directory too many hard links exist to file directory object not found ran out of address space   OS  tZ
 $[
 G        $[
     	       /    file server 0Z
 tZ
 $[
 H
                    /
 object not found object is remote bad reply received from remote node communications problem with remote node object is not locked by this process object is in use illegal lock request lock violation detected local lock table is full remote lock table is full operation cannot be done from here no more lock table entries volume uid is unavailable locking files is blocked for this volume locking is already blocked for this volume no rights insufficient rights wrong type - can't operate on system objects objects are on different volumes invalid argument incompatible request volume has been mounted read-only   OS  tZ
 $[
 /         $[
     	       /    I/O manager 0Z
 tZ
 $[
 H
                    /
 dcte not found controller not in system illegal interrupt id specified interrupt id already in use interrupt id not implemented for this bus interrupt id table full bad dcte length illegal unit number unit not acquired unit already in use unit table full illegal CSR address interrupt id already in use CSR page already in use CSR address already mapped io map full device failed self-test boot device not found   $OS  tZ
 $[
 O         $[
     	       /    network 0Z
 tZ
 $[
 H
                    /
 buffer error out of pages out of blocks transmit failed no available socket buffer queue is empty remote node failed to respond to request unable to route network hardware error msg header too big unexpected reply type no more free sockets unknown request type request denied by local node request denied by remote node bad checksum too many transmit retries socket not open receive bus error transmit bus error bad asknode version number memory parity error during transmit unknown network too many networks in internet conflict with another node listing quit fault during node listing waited too long for more nodes to respond data length too large operation not defined on network hardware header length + data length exceeds max msg size no nodeid prom on this system device stat block is not valid device stat selection index is out of range foreign node does not support all network features attempt to transmit with invalid FROM ID header data length exceeds max size allowed   HOS  tZ
 $[
          $[
     	       /    fault handler 
 tZ
 $[
 H
                    /
 odd address error illegal instruction integer divide by zero CHK instruction trapped - value out of range? arithmetic overflow privileged instruction violation invalid SVC code invalid SVC procedure name undefined TRAP instruction unimplemented instruction protection boundary violation bus time-out invalid user stack pointer correctable memory error detected uncorrectable memory error detected process quit access violation CPU B enabled with MMU valid bit reset null process running on CPU B OS-internal quit (with display return) single step completed invalid user-generated fault (subsystem code = 0) fault in user-space interrupt handler for pbu device process stop process BLAST cache parity error PEB WCS parity error unimplemented SVC invalid stack format memory parity error process interrupt supervisor fault while resource lock(s) set spurious parity error floating point inexact result (loss of significance) floating point divide by zero floating point underflow floating point operand error floating point overflow process suspend fault process suspend from keyboard process suspend due to background read process suspend due to background write process continue fault fault(s) lost; process suspended or pfm_$enable/pfm_$inhibit mismatch? coprocessor protocol violation floating point branch/set on unordered condition floating point signalling not-a-number invalid thread during parity error check illegal page fault in user gpio interrupt routine bus error while running on cpu B spurious interrupt unexpected bus error during system initialization cleanup handler set cleanup handler released out of order ac power failure fpx parity error unknown fpa exception VME bus error on bus error AT bus parity error -- (I/O channel chk) Breakpoint Translate Error Illegal Lock Lock Timeout Unknown Status Floating Point Exception A88K FPU Internal Error: Specific code in FPCSR<6:0> pause interrupt received by cpu halt interrupt received by cpu trap occurred while already in trap mode unaligned instruction floating point hardware error -- incorrect data stored to memory integer processor hardware error -- incorrect data stored to memory   2OS  tZ
 $[
         $[
     	       /    display driver  tZ
 $[
 H
                    /
 invalid display unit number specified font not loaded internal font table full invalid use of display driver procedure font too large error unloading internal (hdmt) table invalid direction from SM unexpected BLT in use internal protocol violation too many pages to be wired unsupported font version # invalid buffer size error mapping display memory error borrowing display from screen manager unable to borrow - display in use display borrow request denied by screen manager error                                                                                                                                                                                                                                                    c                           q                                                                                 
1                                                                                          
                        0       #       ![RXy/`<0M~=63
fr|.dLQ%ĎN]2>f<ArRß\$|(lPkw4r:ʿ~_ AOYfY^ie#x"(*7to/;QnԜ8:$kF1+b]Acl௹ad_J|,s&&-tB֢pR֓!1=7**`ۋ[0I_4I[f& A8GK֌'Qk6yhWiu$:t6BzčVnl+(tT()pipKw'řxo\ěrD, <FJ -l)
FKֺ1E8Ť"aFG,eJ-jumOߓ
і1:1ٜ%ܗH;^u#2z5^dKƪ/lv.\1⬛ňoŅYkN&Cނ
.90eDyb+>ku3[ǖ}de51½LAByeWN;<Һe
2$̚1GTTD'?RD`k,lfy56H=1z*XRDCgvN4P'$&NᯝHBTy_N,m//ʺtBUޅԯ?g}ť؄MjW{Q-I A\Ostsӫ'L9NӳM>ǂ9Ҩ4yUrF@QenE:AX[$.SvSV	jw>RRI
gm@m;CT5x̐!YD ⷘKd㫦k}^x3k )BiXm9>&!JL
Ol?q^hCn^WWX#g' 3ikׯ=.I
L	ze_(wzJlb`_,k(=5a5x9QVfo<&תXw`6ұ#=)aUX4Na4-FЊG]8FV>e]l' H06]յ@cp\r.7-LU>Qqe˞dfLYqc;/re;>.B>5r~AMƜ1e(넏M7xnw)r[Xj]9{>BDXб#
uxΗ%s+F4O	j0Q"-i;Qm@cgY=&Yie~tpdY
yY6X]d@DOQ=
_c
S,jYi]tFͻՌ-/u^hbxA,uI3'WF֥j y6d&.TESDɕ@fO5}MWܪXNߢ҉%5Dr4gD|E
c޲~uW0Dk}$Fwܼh:OMP8Pzpq
dOՈCJ!$2Vadfٶd;ZUM)o;2KCG'F!'	<v`sFWSO
C	յÃgQܪ*!rn#sBW`ة2K[τ%
i4R$ikEZ*!cҊ
Pe.7P+ǇW]ԤCҗ?_q^y~,~
2uNV
J-9WeS4A+Lv, Q]%]0.3!(2T
R)O Aqe*ΜM1͎61]+6Mpm`(wnS4dr|_F(wֵF3hL:}2&)'fބ?*',f #6 / Tcl{
Dm/rM̻e/f$mjUtZNy0ee'"iL/k*[SN4KR]*qh{_jÒx{w jaz'ߓ{daG]j%C<̐KA^0ɂelֲZyهii)kw>@L	,2*W&2K^4}ɓXNj[1o'Fn߻4b!xqO|>^ʴZg#AK0A0؃>3h&FOHDP17ߞx\STGTK}L^
%Zq#	WUgf:p%r5>;v L;<tR|i
3ծBп%( N4ٗI)4fc}۽&#_"$-}8\ـ'Ę^+d#1ikBYkֹ>RHm7@ze J䄱Iؾ+95U((ײPE.}nEm'PӞ:*G[UQ4nu6n_R5L	 X
rtrDKI03Pڀ 0'Vq&6`[.}2KzB1H㺚ߊN LqnR2dRG%GaQ`m:A.P}Ƥ ^6ހ%mT-Hcgѩt?퉨[K?vfա>/j}ӰvJFJj*=/d
_W8}/lttԆs~#O쪪P
x	%LPaƌumdcW5l)m!wd`MlQEN]:[GAp~q%cŕ&?(|!cct{hۂ _'\Qhb2`ԵL<'C	tx
S DHԙ";нy
0RBBX-L,^5E#L`Y09Y=H	[%_2l;:c;E^:.M9,|/X
1髼aX{@YۦPSS:7gH%_+ #ޠi uQ'Bt[6l,J/-u,.;]|O=8̕4
I?ۂx
QW!5
ONHM8xd*h!VK*Nhd~XT}>o_}.J0#G;Ḃ&b㚀'|f
nwWRK{;bIqcРR=|--,8[tkS
Y?h+fH)Wbithjr7
D4\MWаr
Қ8Rqמּ"M
+(w\2sxzyVZ|E[*eVMau#r.+[jzw
ԪtЦB]჆&r#`0y%>CiY,=J<YcYeQۑ)-r;$w7<~[2X.BzaHHg]a-zeh>6l֒~e*ߌBet[Н˄xy#fouC0E)!`pB5\yDNTӊh9Pzؿ%PhCV8*(MJmsV)&{Q[
Vz^TX9Zas1YUZ=B}i
Hn[.]-Qd0
ð"!>i
-(eBEpX/`OIlvc\"r{VZ:䘲+2OGŷT[wIbxو̖6?#.(!m<`(dK{sǶHC!
L0cTA
:
ƣ|L4,>
MmqJe׫rZ!W8JǆK7[E"'R׺q
_
c3reAd;⬨BRAnȣ#;{p*תP1C4z>H*\<xnMO<9&)_SN)
r$FFdk3m=ZCDE#ȴ@8ҼwP0QԱظLW!OXAG85-k/7zHČ+g'A^-D	03ihy;(+nE2 _A4'm$mHevׇk\Ɩۅ!C#P
'µȍUVes}
^pZlaĪHtqϗ'  IUppl{`6%7f4/LӜ\SL8%ev#FaOWށwf6C]='i:X[X.Ae%-pV)t(i9"|!Jgu5}Y\BR$b H|]4 J
*ݞpܪ${{yzjdy
zפ9s: v\EB7ah(n1&.r7\.ZrЀ/]Ɓ\w268`pZ{A"d̹p7̣-0]ݦKK:\K}س;la%\67  Q$y;<_M6yz-?}vH,Ǯv)snAד|G|| Qמi<-tC
 q)>M4hܟkv7]3SR~JVs2ζhQnsa%5Q3vW<3-ѿ2^\uT4y-Rǡ `P1W;Ja>j$m45@uk+'UjB/Ϸeb5x/bӇ՚yGJqXl̝1Á	J19O{!
Vfe)!~uetF	jawtWf^,1hWh󊟕xmE5L# i)<ɟt##?y
ѱ۸t/WU/X!\GBmbX+N<xvO$VwJV%׌2(:u7vƎɳjBt˕OQ
ԜL抔E?#Meϙj<٣37њg䍇a?38	ȿɃ GRǼfUG-Gq7LTܴS,
6J}è"[J''&U	qYe-H>
˸#`5DSd{d{ײsoIE#XYԷ4WpRȦQ<ܼm@bŤr&(;QFRul0zȃ=ZH'0x"l})u]@ŪrJMU'n܇aĦr*Z
]jKU?d@ BRXyG;W ꈊ}B\c kn$L[!{wA7sĴp8VN|S"BKn;v2ֵ'ꭴMۤ(
"̩Sev'N}>)$Za8gO(+WIv"irɧ׸C{@.CRV"1a=Xa.%c/г"±¡(j3jjhQFT5-k>P
s-߿s]W v:J|Yދ?{l
[q-%hnҌC Avӱ^Ɓ	#Ziy}!,s<0RLYB9( ա	ѦDy&3C=/J?K&\,WX^s3|F"GZ'Mg>7:\c:ٔgg?1}_RfXEER>DP79Fd}wu{Nƈ`{qZc&:T㎲m,}g^MHվY[YKh	@+.(PS00
{ہMb=0cp6PC>@=yS0*nb_[EZز"&L=8fu9>l\J姹j3;8Ў+gIw`Y"9hqca#ox!s1&˔D
R OEĀ	-T=$߆8~32tK0 DY2IeV`kN8D</ʴ^Z4ϯ]#~ho1s>~QeҰJLzڅtOoظy|zˏ	ſL:PW>)B.K4-$)	
?6|"I
 xnwGl[%Q]mk/}]Gل(Hfy22;?ϰ	JCoK7n~{>OuK]n%b==<8@ĵ:#PAYM>Tq6gA5-J|N}L
\D hZ6@˻6ŤYS^ 	J݆Ey&dJV3b)'qz'
^	hY_ݮ-QJJ4Q-'#DXѡHդXQWpmXA0owP͊9",_#I(mEc7t:`&Ӥ5Ͻ&tnGZ^!+qԲ+.o_ESيXބ Y tGE ȿ@䂉-X<w%I#mEą}/`[$\gD[+FՂq	+jɊlPϣulˋ3n~暟m@G7=W,Jql,y+[Қwy mb7B[15I3u0_<en{m9{p&u K9zti8[*rYf?V56REi+W	0&߇/`;!H:g50"	;=bEDS3e<PzMh@ݳ8x][]9O̮0ɎWO6
d,_J"NOrj@W?$Nz'z_Ls 3ִ?'3rI#}or+pc`ב]l",o*VWȚ"iȅ-	[Ј5YWtq,                                                                                                                                                                                                                                                    d                        m         RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        p             returning display to screen manager can't return - display not borrowed can't borrow both displays simultaneously display already borrowed by this process invalid position argument invalid window limits argument invalid length argument invalid direction argument invalid scroll displacement argument invalid blt mode register invalid blt control register invalid blt-done interrupt invalid interrupt routine state invalid screen coordinates in blt request font associated with specified id not mapped display memory is already mapped display memory is not mapped quit while waiting invalid cursor number hidden display memory is full quit while waiting invalid eventcount key operation not implemented on color display non-conforming and main memory blts not implemented invalid DM window id acquire denied because window is obscured no more direct mode window ID's available process not found pad/stream operations not allowed while display acquired display already acquired display acquire timed out bad tracking rectangle tracking list full hidden memory does not exist  OS  tZ
 $[
 1         $[
     	       /    volume manager  tZ
 $[
 H
                    /
 Warning: disk is write protected  entry directory problems on logical volume unable to dismount the boot volume logical volume is not mounted entry directory is not on specified logical volume physical volume replaced since mount   OS  tZ
 $[
         $[
     	       /    calendar manager Z
 $[
 H
                    /
 invalid syntax for date or time specification date or time specification invalid an empty string was passed to a decode routine timezone specified is unknown invalid time-zone difference   OS  tZ
 $[
           $[
     	       /    cross-process debug manager H
                    /
 locate target spans multiple objects locate target spans discontiguous segments invalid state argument  not a debugger debugger not found debugger table full requested state inapplicable to machine type already a debugger target process not found no event posted for target - not suspended invalid ec key locate target has variable mmu access state unavailable for this event invalid control/inquire option Mutually exclusive control options superfluous or illegal target setup target process is forking target process is execing a program target process is invokeing a program target process is exiting target process is loading an executable image target process is vforking   OS  tZ
 $[
    "      $[
     	       /    deferred execution module manager                   /
 no more deferred execution queue slots datum too large for deferred execution wired dxm helper not currently supported   OS  tZ
 $[
    "      $[
     	       /    level 2 eventcount manager H
                    /
 internal table exhausted internal error asynchronous fault occurred while waiting bad eventcount unable to allocate level 1 eventcount level 1 eventcount not allocated   OS  tZ
 $[
 *   #      $[
     	       /    level 2 process manager H
                    /
 process not found not a level two process bad stack base request is for current process suspend request timed out process not suspended process already suspended child process terminated another fault is pending for this process invalid process name bad eventcount key attempt to complete vfork on non-vforked process wait found no children process is a zombie no entries in level 2 process table process is not a debug target process is already a debug target permission denied internal error process is already an orphan process is a process group leader another process is using this process group id attempted to join a process group in a different session   OS  tZ
 $[
 C  $      $[
     	       /    import/export manager 
 H
                    /
 entry directory is not cataloged in the namespace files are locked on this volume specified entry directory not on this volume volume is not mounted   
OS  tZ
 $[
 \   %      $[
     	       /    startup/shutdown Z
 $[
 H
                    /
 node ID mismatch checksumming already enabled no os paging file -- please run invol option 8 no calendar on system -- please boot over network CPU board below minimum revision level undefined interrupt   exception handler is not longword-aligned cpu has unexpected cpu id in vbr reg   OS  tZ
 $[
   %      $[
     	       / $   vfmt   0Z
 tZ
 $[
 H
                    /
 unterminated control string invalid control string too few arguments supplied for read/decode field width missing on "(" designator encountered end of string where more text expected encountered null token where numeric token expected non-numeric character found where numeric was expected sign encountered in unsigned field value out of range in text string character in text string does not match control string terminator in text string does not match specified terminator   OS  tZ
 $[
 [   '      $[
     	       / ,   circular buffer manager H
                    /
 invalid block size requested quit while waiting buffer wrap-around error   =OS  tZ
 $[
 (  '      $[
     	       / 4   pbu manager 0Z
 tZ
 $[
 H
                    /
 ddf is larger than one page ddf has wrong version invalid unit number in ddf invalid csr page address in ddf csr page is in use initialization routine not in library cleanup routine not in library interrupt library too large interrupt routine not in library pbu not present too many pbu manager pages wired invalid unit number unit in use unit not acquired unit already acquired bad parameter no room in iomap requested iomap in use iomap already allocated iomap not allocated invalid iova buffer too large buffer page not wired buffer not mapped page already wired page wired too many times page not wired reference to csr page caused bus timeout trap 6 executed outside of interrupt routine invalid trap 6 code invalid usp at trap 6 protection violation unexpected interrupt from pbu device ddf has wrong file type too many wired pages csr not in device's csr page controller already mapped bad controller memory length bad buffer address interrupt library not found device library not found device is not a shared controller device not mapped pbu device got bus timeout on multibus all pbu units in use wrong version of /lib/pbulib in use interrupt level in use operation valid only for VME device physical address list too small function not supported for this device type illegal dma channel number bad dma direction specified requested dma channel in use requested dma channel not in use dma channel not at end of range no more eventcounts available eventcount not allocated to this unit unit already in use as a global device unit is publicly owned buffer pages not physically contiguous contiguous buffer not page aligned   	OS  tZ
 $[
 
   +      $[
     	       / <   line printer module $[
 H
                    /
 pna board not installed in system invalid string length invalid string termination line printer not acquired line printer already acquired internal error ppn list overflow - internal error line printer not assigned no line printer on system   OS  tZ
 $[
   +      $[
     	       / D   OS info supplier Z
 $[
 H
                    /
                                                                                                                                                                                                                                                    e                                RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                              ,       array too small for complete table   
OS  tZ
 $[
 &   ,      $[
     	       / L   badspot manager tZ
 $[
 H
                    /
 bad checksum in physical badspot block bad count in physical badspot block missing minus-one in physical badspot block badspot list too small no physical badspot blocks read or written physical badspot list partially read or written duplicate entry in badspot list no physical badspot information on disk bad daddr for lv label badspot extension block too many extensions to lv badspot list badspot extension uid <> logical volume uid manufacturer badspot list is corrupt illegal physical badspot list address specified  "OS  tZ
 $[
    -      $[
     	       / T   magtape manager tZ
 $[
 H
                    /
 warning: tape not at load-point warning: tape unit is offline  invalid mt unit number invalid mode field invalid buffer length invalid parameter no PNA board installed in system magtape unit is not connected magtape not acquired magtape unit is not ready unit will not fit thru 25" hatch magtape unit in use magtape not initialized magtape already acquired invalid option too many outstanding operations invalid buffer address invalid count for erase or space operation tape drive is hung ppn list overflow - internal error config page in use - internal error release problems - internal error unexpected interrupt operation attempted before waiting wait attempted before go issued go command issued while not in batch mode header or buffer misalignment on chained r/w user quit while in mt_$wait timeout during wait or release header buffer not on header page no room from mt_$write - internal error info array (passed to mt_$wait) too small too many pages wired too many pbu devices in use buffer already wired buffer not wired   !OS  tZ
 $[
 <  /      $[
     	       / \   ACL manager 0Z
 tZ
 $[
 H
                    /
 no right to perform operation insufficient rights to perform operation exit_super called more often than enter_super wrong type - operation illegal on system objects entry already exists ACL is remote ACL is on different volume than object ACL protects wrong type of object insufficient address space to open ACL required entry may not be deleted no entry - entry number too large image buffer too small or incorrect size ACL object not found ACL would be unchangeable object may not be readable by backup procedure no right to set subsystem data or subsystem manager project list is full - no more entries may be added project list is too big - it cannot be added to object ACL is full - no more entries may be added Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code Unused ACL status code required entry missing from ACL attempt to issue unimplemented ACL call invalid selection for required entry invalid required entry may only setid to required entry may not use setid in a default acl invalid right supplied   	OS  tZ
 $[
    2      $[
     	       / d   PEB manager 0Z
 tZ
 $[
 H
                    /
 fpu is hung PEB interrupt floating point overflow floating point underflow divide by zero floating point loss of significance floating point hardware error attempted use of unimplemented opcode wcs verify failed   OS  tZ
 $[
 f  2      $[
     	       / l   network logging manager H
                    /
 ppn list overflow   OS  tZ
 $[
   2      $[
     	       / t   color display manager 
 H
                    /
 illegal caller too many wired pages virtual address not page aligned in color_$map pages unmapped out of order parameter value out of range color display not available instruction queue done wait timed out   OS  tZ
 $[
 N  3      $[
     	       / |   vme bus manager tZ
 $[
 H
                    /
 undefined vme interrupt vme bus error ubus error caused by vme bus iomap parity error timeout on vme bus  &OS  tZ
 $[
 ;   4      $[
     	       /    cartridge tape manager  H
                    /
 warning: tape in write mode warning: tape in read mode warning: tape not at load-point tape at load point warning: tape unit is offline tape power on/reset  invalid ct unit number unit not acquired unit already acquired unit in use no tape controller on system invalid buffer length bad buffer alignment invalid buffer address unrecognized action type invalid operation count unit not ready unexpected ct interrupt quit waiting for i/o timeout waiting for i/o too many wired pages no cartridge in drive drive does not exist tape is write protected end of tape read/write abort read block error read filler error read no data read no data and end of tape read no data and load point filemark detected illegal drive command marginal block detected unrecognized drive status dma not at end of range dma underrun/overrun memory parity error during dma illegal controller command controller timeout controller diagnostic failed unrecognized controller status operation already in progress operation not in progress   
OS  tZ
 $[
    6      $[
     	       /    msg manager 0Z
 tZ
 $[
 H
                    /
 socket out of range too deep socket error no more sockets not owner too much data socket empty socket in use time out quit fault   OS  tZ
 $[
   6      $[
     	       /    symbolic link manager 
 H
                    /
 file not symbolic link type bad symbolic link file   OS  tZ
 $[
 m   7      $[
     	       /    internet routing Z
 $[
 H
                    /
 network port not open buffer queue for user port is full unknown network port can not create/delete that port type max number of ports already open routing service type not recognized port belongs to another process routing through-traffic queue overflow operation not legal on this port type unknown network device type no more buffer queues for user networks user network checksum failed bad packet length from user network unable to create through-traffic queue max number of USER ports already open bad request type asking for service change routing not allowed at port with 0 network ID   OS  tZ
 $[
 A  8      $[
     	       /    internet interface controller 
                    /
 IIC: dma got multibus read timeout error IIC: not initialized prior to operation IIC: transmitter underrun error IIC: undocumented interrupt raised IIC: hardware reset operation timed out IIC: self test failure reported by board init device already acquired device not acquired operation aborted device not in system remote device not acquired could get expected packet from receive socket could not allocate receive socket for device never got expected command completion interrupt wrong board revision level invalid command control block invalid receive control block   OS  tZ
 $[
   9      $[
     	       /    graphics processor manager H
                    /
 device not present in system device not available package not initialized package already initialized device not ready for PIO device timeout wait terminated by process fault error condition reported by GPU page fault interrupt illegal values for physical page use limits Programmed I/O command error DMA command execution error buffer already wired buffer too large no GPU microco                                                                                                                                                                                                                                                   f                        
.8        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                              ;       de loaded error reported by draw processor   OS  tZ
 $[
 +   ;      $[
     	       /    DMA manager 0Z
 tZ
 $[
 H
                    /
 illegal channel illegal byte count channel in use channel not allocated for operation operation did not finish   OS  tZ
 $[
   ;      $[
     	       /    IEEE 802.3 0Z
 tZ
 $[
 H
                    /
 internal driver error feature is not implemented driver version mismatch device is off-line device is already on-line adapter hardware error transmit operation failed invalid unit number illegal packet length invalid statistics block packet type is already in use no channels are available no packet available for receive invalid packet type channel is not open address is not a multicast multicast list is full address is a multicast packet type is not already in use illegal destination address   OS  tZ
 $[
   <      $[
     	       /    audit trail manager $[
 H
                    /
 invalid data size file already open excessive event types event logging is disabled this process is not being audited event type is not being audited invalid action code permission to perform action is denied attempted to perform a redundant action could not start event logging file not open could not find audit event list not configured event logging already started event logging already stopped event list format is not the current version   OS  tZ
 $[
   =      $[
     	       /    Ring   0Z
 tZ
 $[
 H
                    /
 feature is not implemented invalid controller unit number illegal header length illegal data length transmit operation failed no packet available to receive packet type is already in use no channels are available invalid svc packet type channel is not open device is off-line device is already on-line internal driver error controller hardware error packet type is not already in use driver version mismatch invalid statistics block illegal destination address   OS  tZ
 $[
 %   ?      $[
     	       /    Areas   0Z
 tZ
 $[
 H
                    /
 no free areas area in use cannot grow shared area illegal area grow request no free resources area not active not owner of area cannot unmap area no deactivatable pmaps internal error bad reserve   OS  tZ
 $[
 m  ?      $[
     	       /    utility bus manager $[
 H
                    /
 undefined interrupt bus error interrupt bus timeout no response from gate array error during interrupt cycle   OS  tZ
 $[
 ^   @      $[
     	       /    pc/at bus manager 
 $[
 H
                    /
 undefined interrupt bus error interrupt pc/at bus-generated ubus error iomap parity error iocheck asserted on pc/at bus pc/at bus refresh timeout   OS  tZ
 $[
 t  @      $[
     	       /    terminal handler Z
 $[
 H
                    /
 invalid option invalid value for special function character invalid handle supplied buffer is too small end of file invalid output buffer length quit while waiting for input get conditional failed - no data available input buffer overrun put conditional failed - no room for data timeout expired   
OS  tZ
 $[
    A      $[
     	       /    serial I/O 0Z
 tZ
 $[
 H
                    /
 invalid option illegal parameter value invalid handle character framing error character parity error data carrier detect (dcd) changed clear to send (cts) changed incompatible speed request input buffer overrun quit while waiting   OS  tZ
 $[
    B      $[
     	       /    Ring 802.5 0Z
 tZ
 $[
 H
                    /
 internal driver error feature is not implemented driver version mismatch device is off-line device is already on-line adapter hardware error transmit operation failed invalid unit number illegal frame length invalid statistics block frame type is already in use no channels are available no frame available for receive invalid frame type channel is not open frame type is not already in use illegal destination address   &OS  tZ
 $[
    C      $[
     	       /    SCSI manager Z
 tZ
 $[
 H
                    /
 SCSI bus not present bad handle passed in call device in use device not acquired device already acquired bad parameter buffer too large page not wired page already wired too many wired pages bad length bad buffer address unsupported function invalid iova device already allocated operation timeout hardware timeout hardware failure internal manager error quit fault received during wait all units in use illegal bus revision protection violation no resources available command in progress DMA overrun DMA underrun parity error illegal command illegal data direction scsi target disconnected scsi target not available no such operation host selected by another initiator scsi bus reset detected host illegally reselected unknown message sent to host illegal scsi bus phase   OS  tZ
 $[
 9   E      $[
     	       /    XNS Error Protocol  $[
 H
                    /
 source is broadcast address illegal buffer specification packet type error cannot open to XNS IDP   OS  tZ
 $[
   E      $[
     	       /    MAC-independent interface H
                    /
 port operation not implemented no channels available packet type table full invalid packet type packet type in use no OS sockets available caller specified neither OS socket nor demux proc channel is not open no socket allocated for caller no packet available to receive data capacity too small for received packet illegal buffer specification invalid port version number   could not put packet into socket invalid port number invalid type count illegal destination address   OS  tZ
 $[
 }  F      $[
     	       /    XNS IDP 0Z
 tZ
 $[
 H
                    /
 no channels available no OS sockets available caller specified neither OS socket nor demux proc channel is not open no socket allocated for caller no packet available to receive data capacity too small for received packet illegal buffer specification address in use invalid type count listen network not connected illegal IDP socket IDP socket table full IDP socket in use OS socket not open no client for packet bad IDP checksum maximum hops exceeded by packet network unreachable illegal OS socket invalid version number could not put packet into socket no OS socket depth given cannot send only as well as listen cannot send only as well as connect cannot connect to broadcast address connection source address must be this node cannot connect as well as listen host address table full   OS  tZ
 $[
   H      $[
     	       / $   Routing Information Protocol 
                    /
 network unreachable cannot open to XNS IDP   OS  tZ
 $[
   H      $[
     	       / ,   Apollo-private Protocol H
                    /
 could not put packet into socket   OS  tZ
 $[
 j   I      $[
     	       / 4   System Bus Manager  $[
 H
                    /
 undefined interrupt unknown interrupt ID  istream manager  I      $[
     	       / <   open   0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added b                                                                                                                                                                                                                                                   g                        (        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        :      J       ut cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  P      $[
     	       / D   create  0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  V      $[
     	       / L   get_rec 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must b                                                                                                                                                                                                                                                   h                        q7        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                        )      Y       e already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  ]      $[
     	       / T   get_prior_rec 
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  d      $[
     	       / \   seek   0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change c                                                                                                                                                                                                                                                   i                        |        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                              h       annot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  k      $[
     	       / d   create_here 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  q      $[
     	       / l   truncate 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version                                                                                                                                                                                                                                                    j                        pԔ        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        2i      w       does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  x      $[
     	       / t   put_rec 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       / |   replace 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented                                                                                                                                                                                                                                                    k                        z        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                                      istream manager        $[
     	       /    put_chr 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    close   0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    delete  0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length recor                                                                                                                                                                                                                                                   l                        [        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        {p             d internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    inquire 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    redefine 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad rela                                                                                                                                                                                                                                                   m                        GH        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        e             ted pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    open_rec 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    pad_create 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stre                                                                                                                                                                                                                                                   n                                                                                                                       1                                                                                                                         AG               ƫQ^Y	KuSCoFg 556n rZ9{Se7tf@&.TL<|]#,YrUhy":r]V1q&0:R늭%1S9R7VYS>)2`F|X&9ċI"ɋ$)DS"^[A8G	1]
	-]G"w+bZC=)lTS 
DkL]		LZYZ:V
y	
VXB>C8zGAk 4	`QDl[	g
I7V>l
	qrRB_UL [COx)h
$dn|E-yH0}+va", `VD-FlhD/2<|!h7-bx5tYڳPi3&Y`198?g{K^LCeb<y	zwHk?h0Gj0>~3n<st*5m8`hu-I#`!.ne1	7]B6FwRGRE\V/.
E_RFU	\^%U9P*G;
E	^@JsG*KCTTN?A^B	D.}[7INoaB	JoN$y[6+aUY7CNh1HKJeELX	PN2?
Tnutl8*uV(PcoO^WU}Bq^8A%|[`NS[[%K^KM"{e>m+j/CN_UUFZDK*
J]Y{G!7	JufU~^fg+H=X
P$_p$HDXv6p.Saf!N'7E	&j+ dUzL%j|uz<&3mc7 e,z]IІ٥6q6x3r;n9+AB@5/f*a}}(M3Z$~a)Iq7t`m@ТH"5  i80tSIzDt˟o+l=6-n?]b:{~x:v<nuj"eWDU7a.8nMOưD(ak/"&tnV?*>6.00->_eBm.#-w#
5PIU_;Wmtf3lv$$8g"RMQW}Xa0;~ryf?a }ùjyi\}:-pr	OSTNIXjTv$
%l0۽|?"vg)&;Z`<6'u&RrtI}$n|]
n [?N_@ccJHOBB2icr$#xY0y;A5gmx7iroB  ?Wk1cK)#k`{dX}gu31{#I^
YPJ^[.>uX>b v/*6y*lci1-?p&LbV%k/Q#9&*w.}<k>x+z{I9F-CRMIr 7
UJkbDKBX[y[`W;BG]<My;I@[]Dl_`&M1I^GJ[?ZK}H@AE y/XqpdC@1DND6Pc#w)^[@@'Md2
Da6MT
dbM*_50`z	k!*.0Vu[R!$VNR49[CLBtP`:N'DX\C7^RF0F${?	Hm
L%P{j@ KUUdEWNKq\@OFH9s.%#@,kXERrxxexmji3ft4y_trjhj8bATѱGɢD_SpcR=1GH;'0ehb7W:H!cK>K$_僸	[TT7 F9n󗊟O;-0g+h%&g_'RX
Sfwx-
c2-g<m}WC7q}X,r)e|{(a,)l}%'Gq	j1ح+#@=~lq"m
U}:XYY+".p^~?
6z|)kDw?j?YF3aurbzH+B,m{xw=V)z|bR\
IWxRJHor:/xx562\wd7j6:CZ,}T1srbcb6bSp/%m!7 ?i){CY$V5$m#D?0 VHK	T
b?BTVzMWL T^ix*:+'hm>wJo}sh(E5
Pr
תإ
1IƀX
C-GA18 xgfO5F C*Xc
ĀW]Y=&`C	Ql
j!@:f"y-$~oy̠_W
{92IBmXX[]IES5oA=V %tQ]ifD'C%BTThXKV~
V.DNRHF\NXXs
1?/; +
W[\_4sT9U WH@bHf&%	-qrw	%gMdF)	yqF9|`4~ .''eM/&/+~Ie{dvñ*s#8/@XBFc2MĂԏ|D?E .G*B]a!7
~Hdyh;<#e#k7/GpulSz>yaq	(	H6#C>rJE@NDM^O4GS8m fW a2t6Z6t3V'J
ZUL#@T$Fg7:/BB8_@T&u:GKx-pXheDtn[]CCa			WBvQ}Nd^4PCFw+QldVnE1" hPxa?~!&W:jj8=<~Wz
5^a?	&tx(vZ
I @,%[1xWF;UYN	o=v(dŔU?ol p*eAOo2WK}&{"p8qL""]ɋ)I,8I	{M/TQj8,{r*[TWe%RFfH^_
?bAq(,Oe/Y mg%?PhHlVB^/z4(^:uw<j`jmq]7k?q0KNH`/=RI)5lNy"E\_H
_
:SIl9i6Fxi6w}"g&y("SLlfoc*n5RHP"%~=ZDK%Ep@N$3[ke!ocU*\0E0iMM\dRcf3cY&z&v	QcɸI_hFU 1;JS]9>tz	
K$	Rytz8zOP`?zoi2:jhi>a?|yE'`)%?
./@_ۺ-5+&i<|!TH7/\hQ UMjOP9\azvc}/w4eb\4 ~j>%#[/xTrqĄ)zr,u1zGt|*ps#6)-q'VLn','~C$C w-U>|#	WzHijTS
;c;^vyz}og30cu_n*)mc-I4aT-Q7(q&9>NMYI+{	tiF$A2G[b^ye_zkb!r`{&oRJupml<F3hJtoaqV/`-JA[N;"	<WĠp߻&Ҭ B)^"w{QPxgzJ!δ`Q\0'i(
vXZaMt2v,rn`kr%W#O?^y/s&GWgeTU=:+?Ul4q~R8|cqxR9+<C*v.{`9O =ÈNxR2-Z+|}s}h
mfs;e9g]/w0umu$ 7,w&cVRuF\URhE,5M];)/c6)j*^$ X-*B*_|1`~TI| }$oa6=df f"n2qB4h"N6|uBJ"AXgJ&:GCf6KuMvF;ү&<8h!0NfO`b"`C*E:?X+Eqt)|Qrxrr{Jgqo~9女>0,`ٮLף PBS\K 'eJ|EAS8NY
|:T*ByDX\ORXVRPw|.~:K~@d[#-}~{mgv\:>%o!W|e%0k
i 2c$	hoy,HVUzs}#w2
'CQKeCj\q
T
 }'xAAp7i*;#} raw?ih% $vve)a')b&CGCV v:!-F0,w+U:V?Esq83#g:,u[.!la/G!9d1 [#f=%*tMspH (<XuGE3LIF>5=3a_~s>K&$6ie:8y m`>~ic~"i7ao~y/a|Xy#߉3bF"X^A5VoLR^HKScG+NvkI\$@u#S@ZUwf``'p-3'be]b	LhffZY/YU/NIiM^
t.PC#Ƞv{33'{g/s 01z%^yK3; md|0!)v kEC}lqC|\t;'J]^DQrC)"s]x٥^v
pkG %[	V>AG@x5b\e&GXti;E -`2VEt	
 #O]ivq4\rp_x
kO3B]X^N_w^XD}nG2g>bZ;nX3:uKw.l[+ p[{#Y"eOCI6
Cp.EQ`usm϶)2{I_aM#1?A2LѦKKadwqQ
y@Z{F,L^mF̟uQӡF0,	oEVyd144P
Vsgtg{ҎaP8\\hTmd+s+(fz6k^nO1>S
r/sJ2x,/=k?fZ(B~of(>wue_z<o#ĦZdw.uB.Rmv OEGC@oEW][S@DQ,>Cd}$
1aF@PBCt2 *'8A}CBqT<Zn]'D*m)MV
CX>X@zJ
b9C|Zw/W GsNJ~#
FKGYMB!+g?X^	V~oGI"U4\GQd}
"
ciVEBHNP_K[QR\pT
?OU
sqiu_1`0;kM~Si#g%6-q9{tr3o!=ul7w)P)vj9?2k&[Q_<oLr~vu>KZ3.zV;ơ_f:+e?^S98qX-B;Uj'tp1t&rG~)0.]{Aq:ڳ DwFVD[)UUFf/~>|J[-NW!d/,JLdQB-]ax[#=jh.827uO
QM&.]_#X!eMb[$KU)@k k&V 3\xXY4
+#UYQQdRtBIKOirF.9 
I]B&U]Y	'rTICn0tPE.Q?0|#~}h[Z3>n
YN
	hvS[XQHhM.EU`kyABZ	M!%/-G
Jvi}Y9
XSrdT:GpQTPGTd2A]*e
?zXLtU0[U.Np @d`fW~jUZKjYN^k0,}\>)G7}h}kH`>8bb,p!=qzU 2/J'	(b}<@hB\m_+-Z]J0jXn7ր iy,p9?<[`3d&ORiK2n2p&
S,d"{OW6>32]*!raa Du#7 ?5,om<c?1jn9>p@NHbOV+>
T;Hf<A7%DIPP[uvN:2+┧a]/_s+l2n'~"JZQluh~uRލ?F<x(O9fF\H]u'=Qj{mV
}7*CiƘpq '.jpFAJ" vIv_GtiDQwWIY=LYRReF,n-H2$R`DC4k^-)VAWL@CA6<
˟|䀜_ xT2|PL|CXsU^762>x%0+ŢBVR]OOaUfD MI{
PPȈz/~'9ŀHY_05|.2.U)XVk|rC`~m96g<T1S$`z $g>p{m(R&9=1Mz@Mt/gSGRA
LQ-	/S-%"Id
8*j1-'00y?=o/aXA?%='L8~ڮriq
_04eis] !p

'JK>YH@]vELRXX}yl:i =XZ Sm3S/if;+vEq)1su;/&D~'w`	Z8hct2EsTnxFw.dgjYIe]~0P F9,AFm7&1x|	Q.|Wo<Eiu
eZ': LԋBmp|jvg>nT(o+jj<l?8LbGcdgS#n~<xɃ	{2`SP%P5-!սG%~B#~1v>UY%\4t{K=li'H!*4hIY^}8RV{^1=- R(QHsHM6w^$3AEt!+MY[jRws?d&pejxg}?#wcz^:Zqnr>\ɓ=ܔ̒+5|&han*w6xqYrNI%JwZ ^
Su:1W>>r Ibe}TYN9Hsbf&c
}&JU wa#"4l{Ux+=zq/x9J&87
k1*6UGZMVD]$V^[H_AQI7JQJn7]@R\YABQqV?UB[Q}D[O
S^QCSFUtBo/>^Y,EI+I-#G	PWbRL	%4Ds^84UNF
vN5[X_Y,XREV&3b(.YW~E	X^pQ^#YhI ?QW3Z;
N/51DM&s_L])tAWD4|W8}B<EpSFR[M%
v^
 \SOkfV_Z/N51:Ny-U=^IkdE|4uaek  'QgedXvJWuv%~Z-d<L!c} a3kͰ%Yd~vo!h|\rnD@ICnD
ZjU,	M@Hw^T9{0%yq`#~ 9Soni?3g~eFU|U~R=(T 1}L=RU]d	uOly
~Qw;8$<O^N<k(MJ/O@Y;Cs
JDE^{2
<yvh<6pjrHJ Q]2X\krtLzwW\F˻&1MR9+B!zA	W/qq,
AN6>j)Ų/f!|,N^Y!9m,Lxjk^xq/rvccNk"*I\e}Fw&c74	7mzOTOSO uAJ4xB.Ot4VM
*AmYQBL\
Pjme
WdlO vi,'s	DSfprV\J[CD]ENDAQ&`2o&+ieY=0G >iRbzpiw?<IȪIHBLB6oxIg[pVc<D[wQ0I!K*PVH|]eDY	GLǈgͧ"Ld\-
'QRMǭNeHQZM]wR22PE&>Q!8zn>0=`'2c}"5-r?o=[pKaHhFe]˳APSZS9 D6Cqt]i\IcF
DG;.8 &Q;vP}hI"$\1b/~%2g->wb}a}@w;zkw*'fd (/60I4fN\[7f/]]_HQ_.(Tct[2_swDqK''>$:j$	! kgb9
BqD?OK/
bk 6`O"+k>.~<3e-\Bxe:xQ ~7#YN`/+>8-G`*Q3ƀ$<~,<:`w >u="4FnyxG^K#1,{!X	%~4!qsi+nuf*4B GXa5,vxw踓x/XK
LU
7A@O\<M0)h/?!Zy
 ,owTiJ[N
^m@P.<~ւ,~EC+G{ G*+` $7w]?t}Pf
kJ"g2zfs8+xYAqȬ{O~Ms5s..'V=7nm!Ez~\*P5l)bs N(ij
YcKLu.=fiFW ZY`{^7+XD"~!{/oG?KA\xɦ(uE%w00u`?PeyTbNxnC{v*ea"Ygj)Yz (*j>8Gt{G;Na n#l}
                                                                                                                                                                                                                                                    o                        I        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                        m%             am operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    memory manager  tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    get_conditional tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused                                                                                                                                                                                                                                                    p                        (        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        #C             unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    internal module tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    get_ec  0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    internal module get_fcb.sfcb 
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for sw                                                                                                                                                                                                                                                   q                                RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        V             itch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    internal module get_fcb.pfcb 
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    fork   0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found                                                                                                                                                                                                                                                   r                        ]za        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                                      even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    dup   0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    get_buf 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - l                                                                                                                                                                                                                                                   s                        S        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                                     egal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    alloc_sh_sk 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    free_sh_sk 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this ob                                                                                                                                                                                                                                                   t                                RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        S)             ject type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       /    init_sh_sk_pool tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       $[
     	       /    bypass  0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       $[
     	       / $   force_write 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning                                                                                                                                                                                                                                                    u                        W֩,        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                        ~      
      - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       $[
     	       / ,   get_xp_buf 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager       $[
     	       / 4   open_xp_buf 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file                                                                                                                                                                                                                                                    v                        ;        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        h            header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager        $[
     	       / <   pad_init 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  '     $[
     	       / D   replicate 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illeg                                                                                                                                                                                                                                                   w                        5(        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                              +      al attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  -     $[
     	       / L   force_unlock Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  4     $[
     	       / T   switch  0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data                                                                                                                                                                                                                                                   x                        *uH        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                        vp      :       available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  ;     $[
     	       / \   dump   0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  B     $[
     	       / d   get_uid 0Z
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  H     $[
     	       / l   IOS   0Z
 tZ
 $[
 H
                                                                                                                                                                                                                                                             y                           \                                                                                            ;1                                                                                                                        !        Q       VXiV7XR d:2KI sA[VUU>[ BzLG'BW$/)]DFPbO0EEI'@9H`G.
Xlle)M+V{uJxA:RP(wXPYvt[DzA
oWX
$ecnR ~,CKTQ+L?BS(f^GW
	`cN?XzT&E
qr011
	0BD.CwrCQ51k%1+ f#;76:[T ֲ&sY@-VhYy2+p3*rNznz~k
g{U7m*ft3bf@JI/./)Jb4:sQO+
SWC~iBW@
xI6x#a(~tL<::(62JzwPk0dfmu<%f#:
 U$ wGXZq4$).@_ZM]A_T`SVKYj7L;U{@CTWur_ #A[J</fzNkK\2g# )29pmXCN`hZ@BCr_IN&io9xb\y"# 
dN?e>poyoq[[a"UG
>;q!jyx->v)V>SQw20B;	3}uvs׽"i%s>w`cE@)28bb&[y6 4tdCPk-{.LXVAq>D1
M	.WgU
sKJ\&	V#5
HT)0YVCBRSX	H}N1N=t#X]>n#wq B)z#p
HV
Eb:O!rz-e`F=`:!rw
nok3I82y[OKx&3[4|qd=C)0|d+n@ܧt~Ly
3;
"vQ-8tbht" 52%74:`3E9&IE3f%ƻx\VX=RdYG,H7?a](LoBZyKV;?B$R' w_^	<p~)*Uy0[I=I{X<:Ef^M ,
3pE_HrFdWXpXiliOO~C1HHNBENtQ
Q[Z2'ZEUR*z(xG<K
`tq1"6sF,D	DZ.A;qYN}L*
3n:X!QW6;_T!߲o<SQg]dYs/
q-}N3we;9qUuV(;anK>jE"OOW-bhgL0(0nzE 
ZSvsxhE\q
WpI+r cixv	-txx=3z6W~b{sjj``*,sv#4յ
U/nDX9Z>/(@LQK}KCU# MNbdV1E.{@i^rkFDQ>YvNJ:+kqM`KN2|3 </'p>nQ-x.]$FvCIqbrq>0y`(3]jJstvj=hwl2sL[	ߥ0,$/eDu,y
3 KqLhDS=-ZF}'`&ƻ:m#Zpqv4eHH7aWrm2MhB6< 1@Ca*45ʠWDH4ADO7I#;dWK@2C_
_6YS
IR7)J)$	^LgCTBR[UBT|	 _%9\eKJ[-++|C0r#ZgJ
D R
kH6+N>m|s!4A0a:5e5ktd>[65yFRj'>{$jqu*A)1 tGLn0Mv)k*hb?80::d1auj0=f%$x-(+`|"+9;Y12m=Ū@XY	DNL6
B^$hCAENPmR	\
BK_\_#@!XTX<^3	&UeZZVOB`_F*_SgI(MD/nP-I<P
@pJ`{(CH1H@^CRJ  WA>KH4
BE
 0/8hQNKYw
wd#s:NW~B_)`O4~U)5# 07`\ >?\VYMEk0AApJ%}
-s	

O+@BO\-6VJuu(_,M!K}\E`\}KB
-nQSbsDO K~o|/E\qlpP1_lD\zZS{#	S
CtSmRQ]jqN '{F]OE%Sp}"
RB/C4LCVF' H6Q%pIY|nDd.E\CPAqXmZ_W)&J`WS0"04y"2=5!<-?T[+lD=ig4q,[du6Vn	IkA~d>(dkL!~JAڤWȤ0.9 Pa4=mU"p/S~,Z
F]q"h$
8y"Vf4!+mVC~`@7.2Md'7=bDC_$$7ɴM\a[SNMwn$'*IX2K	L

LCzUSYOT{k%ah
IvQyIXTL@NMS\J
]J3"p6GXEji^y)/ya	%bSX6IbHBCNMkD5j@l"|<!|Bu|N2n5,2b>Ay%fMXquBpwph:h7LS~}~,**efslD4{-0 vqfdR}k#j62)d\,/:s_E
9(o2
DK^YHQP)/^NW'EDOHvGLFNOFF\Rw[<WV[2:{&GJ^"C]G\Q2U-PY5)
VL}[ 7XoGCGzjf|3 HXKCORIRRZqLM|<_Z6{13uH@X>4 0i 
fB^.-^/E,Op1e#ezOH-.Gv PBO~\Np[2e
#'Y0@FVXJ.[d	^wuH	'($#ATVLvTBR
:'MJ@*
Wwg5%@UbMr9@
3Q\jGU|jB\ fVMzKBxCJw`nT,7EBG%Be{(A_abJBPsL`eN:U3F>ZG}%r;BPxFAW 3V^WqV7r/;]<lm2,dyG@e-xT[ycL*'#):>@mq(ve
cYd6(*y{FGg{M\D̠76))V|>=}R*OUI=L\qX{l? 
.pogA2 -&eVFb~Vx4wDauuq&YZ*%'\aSAI Xu%^$l*B8WG	[X2U_OTCTj*	5ZdvAdO	'W}
rEGK@@PS8vk*PD&x1&3+5r
ZIqi[VCFCrCHX ,vT8jdk9,?&21tR8y)ua"SPuqlUꧾWOڟ-:N1j`y;$jHc^8Am;0?) |evs0x$6t5sfcR4|qm}b%:`_,==iDFC9ia8
	%R\CHwO$@-APN-P^
HrGFHNZJGL>p IW#|/XZCIMXVDMC@TwY7^=f#UGX8qssoECV[`Vd21U
RU ^
I_Sf-
\lsWXWR^4QI jPf=W=/m	J%;.)F/XeZmAK	euTH lH} FFW~VXiV7XR d:2KI sA[VUU>[ BzLG'BW$/)]DFPbO0EEI'@9H`G.
Xlle)M+V{uJxA:RP(wXPYvt[DzA
oWX
$ecnR ~,CKTQ+L?BS(f^GW
	`cN?XzT&E
qr011
	0BD.CwrCQ51k%1+ f#;76:[T ֲ&sY@-VhYy2+p3*rNznz~k
g{U7m*ft3bf@JI/./)Jb4:}ZO^{;a/
xI6x#a(~tL<::(62JzwPk0dfmu<%f#:
 U$ wGXZq4$).@_ZM]A_T`SVKYj7L;U{@CTWur_ #A[J</fzNkK\2g# )29pmXCN`hZ@BCr_IN&io9xuc\y"# 
dN?e>poyoq[[a"UG
>;y!jyx-	)oVia׽o+$;	3}uvs׽"i%s>w`cE@)28bb&[y6 4tdCPk-{.LXVAq>D1
M	.WgU
sKJ\&	V#5
HT)0YVCBRSX	H}N1N=t#X]>n#wq B)z#p
HV
Eb:6!rz-e`F=`:!rw
nok3I82y[OKx&[4|qd=@9)SF
@ܧt~Ly
3;
"vQ-8tbht" 52%74:`3E9&IE3f%ƻx\VX=RdYG,H7?a](LoBZyKV;?B$R' w_^	<p~)*Uy0[I=I{X<:Ef^M ,
3pE_HrFdWXpXiliOO~C1HHNBENtQ
Q[Z2'ZEUR*z(xG<K
`tq1"6sF,D	DZ.A;qYN}L*
3n:X!QW6;_T!߲o<SQg]dYs/
q-}N3we;9qUuV(;anK>jE"OOW-bhgL0(0dz\Z~ip`NO
WpI+r cixv	-txx=3z6W~b{sjj``*,sv#4յ
U/nDX9Z>/(@LQK}KCU# MNbdV1E.{@i^rkFDQ>YvNJ:+kqM`KN2|3 </'p>nQ-x.]$FvCIqbrq>0y`(3]jJstvj=hwl2sL[	ߥ0,,/eDu,y
-)A.]{D\x=-ZF}'`&ƻ:m#Zpqv4eHH7aWrm2MhB6< 1@Ca*45ʠWDH4ADO7I#;dWK@2C_
_6YS
IR7)J)$	^LgCTBR[UBT|	 _%9\eKJ[-++|C0r#ZgJ
D R
kH6+W>m|s!4A0a:5e5ktd>[65yFRj'&{$jqu*T1*hC~)}v)k*hb?80::d1auj0=f%$x-(+`|"+9;Y12m=Ū@XY	DNL6
B^$hCAENPmR	\
BK_\_#@!XTX<^3	&UeZZVOB`_F*_SgI(MD/nP-I<P
@pJ`{(CH1H@^CRJ  WA>KH4
BE
 0/8hQNKYw
wd#s:NW~B_)`O4~U)5# 07`\ >?\VYMEk0AApJ%}
-s	

O+@BO\-6VJuu(_,M!K}\E`\}KB
-nQSbsDO K~o|/E\qlpP1_lD\zZS{#	S
CtSmRQ]jqN '{F]OE%Sp}"
RB/C4LCVF' H6Q%pIY|nDd.E\CPAqXmZ_W)&J`WS0"04y"2=5!<-?T[+lD=ig4q,[du6Vn	IkA~d>(dkL!~JAڤWȤ0.9 Pa4=n
S/S~,Z
F]q"h$
8y"Vf4!+mVC~`@7.2Md'7=bDC_$$7ɴM\a[SNMwn$'*IX2K	L

LCzUSYOT{k%ah
IvQyIXTL@NMS\J
]J3"p6GXEji^y)/ya	%bSX6IbHBCNMkD5jGl"|<!|Bu|N2n5,2b>Ay%fMXqu:pwph:l#^Z}~,**efslD4{-0 vqfdR}k#j62)d\,/:s_E
9(o2
DK^YHQP)/^NW'EDOHvGLFNOFF\Rw[<WV[2:{&GJ^"C]G\Q2U-PY5)
VL}[ 7XoGCGzjf|3 HXKCORIRRZqLM|<_Z6{13uH@X>4 0i 
fB^.-^/E,Op1e#ezOH-.Gv PBO~\Np[2e
#'Y0@FVXJ.[d	^wuH	'($#ATVLvTBR
:'MJ@*
Wwg5%@UbMr9@
3Q\jGU|jB\ fVMzKBxCJw`nT,7EBG%Be{(A_abJBPsL`eN:U3F>ZG}%r;BPxFAW 3V^WqV7r/;]<lm2,dyG@e-xT[ycL*'#):>@mq(ve
cYd6(*y{FGg{M\D̠76))V|>=rT$=lz9Iz3QKD`N6h# 8ogA2 -&eVFb~Vx4wDauuq&YZ*%'\aSAI Xu%^$l*B8WG	[X2U_OTCTj*	5ZdvAdO	'W}
rEGK@@PS8vk*PD&x1&3+5r
ZIqi[VCFCrCHX ,vT8jnk9,?&21tR8y)ua"SPuqlUꧾWOڟ-:V1j`y;1{>5@L"I+'[m;0?) |evs0x$6t5sfcR4|qm}b%:`_,==iDFC9ia8
	%R\CHwO$@-APN-P^
HrGFHNZJGL>p IW#|/XZCIMXVDMC@TwY7^=f#UGX8qssoECV[`Vd21U
RU ^
I_Sf-
\lsWXWR^4QI jPf=W=/m	J%;.)F/XeZmAK	euTH lH} FFW~VXiV7XR d:2KI sA[VUU>[ BzLG'BW$/)]DFPbO0EEI'@9H`G.
Xlle)M+V{uJxA:RP(wXPYvt[DzA
oWX
$ecnR ~,CKTQ+L?BS(f^GW
	`cN?XzT&E
qr011
	0BD.CwrCQ51k%1+ f#;76:[T ֲ&sY@-VhYy2+p3*rNznz~k
g{U7m*ft3bf@JI/./)Jb4:sQO+
SWC~iBW@4)m'
'G|`~tL<::(62JzwPk0dfmu<%f#:
 U$ wGXZq4$).@_ZM]A_T`SVKYj7L;U{@CTWur_ #A[J</fzNkK\2g# )29pmXCN`hZ@BCr_IN&io9x|c\y"# 
dN?e>poyoq[[a"UG
>;A!jyx-
?mzINMBo+$;	3}uvs׽"i%s>w`cE@)28bb&[y6 4tdCPk-{.LXVAq>D1
M	.WgU
sKJ\&	V#5
HT)0YVCBRSX	H}N1N=t#X]>n#wq B)z#p
HV
Eb:<!rz-e`F=`:!rw
nok3I82y[OKx&[4|qd=n+n@ܧt~Ly
3;
"vQ-8tbht" 52%                                                                                                                                                                                                                                                    z                        gF?        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                              I                /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream tty has changed sessions I/O operation attempted by background process unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented  istream manager  O     $[
     	       / t   advisory_lock 
 tZ
 $[
 H
                    /
 warning: a full record was not available warning: supplied buffer too small warning: new name added but cannot delete old name warning: fix lgth recs & partial rec at EOF warning: close anomaly inquire warning - object open on multiple streams warning: file trouble flag is set unused operation attempted on unopened stream attempted operation illegal on this stream "from" stream not open on switch request no available target stream for switch can't switch - no available stream ids can't open stream to this object type no more available streams requested object is in use end of file ran out of address space permanent files must have names "put" of wrong length record internal fatal error; table re-verify failed file already exists operation illegal with variable length records unused attempt to seek beyond beginning of file (key=0?) character seek outside of current record bad import - must be already open on stream elsewhere count field for current record is in error name not found bad stream file header - checksum doesn't check bad location parameter in create call inquire error - can't open stream to this type of object object already open on another stream by a different name stream id out of range unused object not found even though name exists unused unused attempted name change would require file move object deleted while open on this stream name required - open with no name is illegal EOF pad put error - "put" legal only at EOF on pads bad related pad - invalid or not open unable to lock needed resources this object type is illegal for pad create internal memory management error - fatal attempted write to read only stream replace length error; record size cannot change cannot redefine this attribute for a pad manager cannot inquire/redefine one of the requested attributes illegal attempt to open stream to remote device no access rights to object insufficient rights to object invalid data in write to pad internal table space error move mode is needed - forced locate is on illegal forced locate request - legal only for disk files no more shared file cursors available on this node internal error: shared file cursor has bad reference count (below zero) internal error: export buffer too small parameter combination illegal for this stream operation couldn't find directory in pathname system (or process) crash prevented complete file close no stream found in conditional inquire cannot open a remote sio line cannot create file through a link specified DSEE version does not exist object is read-only put conditional failed - no room for data get conditional failed - no data available not at record boundary cannot change type as requested opened for inquire only - operation failed file not empty buffer too big for object of this type cannot initialize object of this type flag not supported for this object type advisory lock already set on this object no advisory lock to unlock not a directory deadlock detected file size limit exceeded attempted read from write only stream unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused unused char seek outside of current record illegal unused unused unused inquire for this object type not implemented   stream manager  V     $[
     	       / |   sfcb   0Z
 tZ
 $[
 H
                    /
 unable to obtain sfcb mutex lock out of global read/write memory unable to find sfcb in sfcb_$free unable to obtain sfcb hash table mutex lock   Wdisplay manager V     $[
     	       /    DM process 0Z
 tZ
 $[
 H
                    /
 Command syntax error Unknown command name Too many command arguments Position specification syntax error Key definition incomplete File not found Unable to access file Text is read-only No text under cursor Too many windows Too many pads Display manager internal error #1 Unable to write new file You must finish current command input request before making another Key definition too long Cursor is not in any window Line too long - truncated CC com                                                                                                                                                                                                                                                   {                        P5        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        b      X      mand requires position mark Unable to create new process Unable to create new pad Input pads cannot be replicated Bad font file Font table full Unknown function key name Window too small for any text Display manager internal error #2 Pad deleted by client process Pad still active Illegal grow coordinates Display manager pads cannot be named File is not an ascii file Processes still active Bad text range Paste buffer empty Invalid regular expression pattern Pattern too long Illegal substitution expression No match DM input window cannot be deleted No room for more text at that position Invalid hexadecimal digit Invalid tabstop value Edit pad already open on that file File already modified No window selected for grow or move Line contains non-editable controls Cannot delete .bak file Heap file inconsistent during recovery A process with that name already exists Search aborted Operation illegal during search or substitute Argument value out of range User logging out Error processing user_data/key_defs Previous fatal error prevents typing (try RW -R) Nothing left to UNDO Command illegal except during node startup Can not create paste buffer You cannot edit this pad Pathname has changed -- close window and reread Can not edit that object type Invalid paste buffer name Operation is illegal on an icon Maximum file size has been exceeded Echo mode is already on; ABRT will end echoing Echo mode aborted Name does not correspond to a window Command aborted Command is not allowed during login Logout has been disabled Insufficient memory for operation. Try closing pads Paste error Previous attempt to read file failed. Try reopening Cannot set privileged environment variable Variable not defined Command illegal after login No balancing character found Too many open characters Too many close characters Current color map usage prevents turning MONO off Mailbox data not available; pad request lost. Commands cdm and mono are mutually exclusive Window no longer exists Command illegal when WMGR -OFF          Cannot CC foreign windows Paste buffer is too large for undo buffer Unable to save file until no one else is reading it   display manager \     $[
     	       /    Heap manager Z
 tZ
 $[
 H
                    /
 heap table full invalid length for heap get invalid heap return heap space already free on return   display manager \     $[
     	       /    Pad manager 0Z
 tZ
 $[
 H
                    /
 stream is not a pad operation valid on input pads only stream id out of range operation attempted on unopened stream operation valid on transcript pads only pad not in raw mode value out of range too many fonts loaded in this pad error loading font file unknown function key name only one input pad allowed per transcript illegal parameter combination existing pad must be an ascii file operation illegal with > 1 client process user aborted (WC -Q) edit operation specified window number does not exist window is no longer displayed operation illegal on this type of pad operation illegal when no display is attached   display manager ^     $[
     	       /    Pbufs manager 
 tZ
 $[
 H
                    /
 actual buffer type differs from specified type   
process manager ^     $[
     	       /    process manager tZ
 $[
 H
                    /
 invalid parameters to pm_$invoke process had a fatal error no space for Known Global Table process already named process has no name error initializing global read/write storage error allocating PFM error mask too many libraries -- table space exceeded mark/release list full process not found argument vector too large no static space available for process creation process name too long   !process manager _     $[
     	       /    loader  0Z
 tZ
 $[
 H
                    /
 too many undefined globals object module has too many sections disk full or not enough address space to copy procedure text file is not an object module or is not executable on this machine type object module format is incompatible with this software release not enough address space to map procedure disk full or not enough address space for static storage Known-Global-Table is full reference to undefined global library contains unresolved global(s) peb required to execute this object module object module has unremovable breakpoints; rebind C library initialization required; no C library is installed DN160, DN460, or DN660 required to execute this object module FPU required to execute this object module M020 series node required to execute this object module Cross rev. incompatibility, sr9.5 code calling pre-sr9.5 code load address already occupied absolute load address already occupied absolute object module requires relocation conflicting loader options and requirements unable to install a library required by object module FPA board required to execute this object module reached the end of the executable image list invalid image handle invalid section number object module requires link step object module requires unsupported systype load in progress while table being examined compound executable contains no module for machine type object module systype sys3 obsolete; see sr10 release notes load context requires position independent code load context precludes unload  process manager b     $[
     	       /    process fault manager 
 H
                    /
 warning - multiple debugger fault handlers are in use  cleanup handler released out of order invalid cleanup record cleanup handler established successfully pfm_$cleanup_set was signalled no rws space to create static cleanup handler static cleanup handler not found attempt to release non-existent fault handler attempt to release fault handler at wrong level  stranded or corrupted cleanup handler record unable to unwind stack because of invalid stack frame   process manager c     $[
     	       /    program manager tZ
 $[
 H
                    /
 argument does not exist argument is too big for supplied buffer stream vector is too large (>32) not a program process is vforked incompatible invocation options illegal option option requires an argument no entry point process is running on signal stack wrong object module format   process manager d     $[
     	       /    mapped segment manager  H
                    /
 unsupported access rights requested attempt to release segment mapped by previous level no object mapped at virtual address supplied object already locked in a way that precludes your requested use not enough address space available bad length object not found no rights insufficient rights operation illegal: objects are on different volumes operation illegal: object is not temporary operation illegal: object is not locked properly   process manager e     $[
     	       /    r/w storage manager $[
 H
                    /
 attempt to release non-heap entry using rws_$release_heap attempt to release heap entry created at earlier program level heap corruption detected; block header incorrect heap corruption detected; level number in free block incorrect attempt to release heap entry not allocated from this pool requested rws_$pool_t out of range unable to allocate because of lack of resources   process manager f     $[
     	       /    basic heap storage manager H
                    /
 attempt to release                                                                                                                                                                                                                                                    |                        3        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                              g      already released heap storage out of heap space heap corruption detected; block header incorrect requested too large an area from baf   
process manager g     $[
     	       /    remote process manager  H
                    /
 unable to read naming and working directories unable to resolve home text unable to get SID operation not supported by remote system no more slots available to spawn remote process unknown request no more resources mbx open failed on remote node request timed out sid authentication check failed invalid to specify -me and -login local locksmiths only are allowed command line too long   process manager h     $[
     	       /    task manager Z
 tZ
 $[
 H
                    /
 not enough virtual memory left to create task task does not exist task manager has not been initialized task exited invalid task handle internal error: bad status from ec2_$wait attempt to blast the distinguished task a task attempted to blast itself invalid task priority a foreground task attempted to create a background task internal error: ddslib initialization failed invalid task lifetime this process has the max # of tasks allowed - no more may be created task name is too long task does not have a completion EC task has not yet completed a task stack overflowed a task stack was corrupted   US  tZ
 $[
 h  i     $[
     	       /    file utility Z
 tZ
 $[
 H
                    /
 object must be a leaf unrecognized sys_type returned from file_$attributes unrecognized entry type returned from naming server unable to replace or delete a system directory compare failed destination directory is contained within source directory can't copy a file or tree to itself source and destination are on different disk volumes source directory is contained within destination directory pathname truncated leaf truncated  (US  tZ
 $[
   j     $[
     	       /    print utility 
 tZ
 $[
 H
                    /
 Printer fault Printer is out of paper Print Server suspended Print Server not running Printer is offline  ./sys/print directory not found print queue directory specified by link was not found file to be printed is not an ascii text file file to be printed is corrupted prflib option is unknown prflib option value is incorrect more than 1 file found with prflib search option file type can not be printed problem with PostScript interpreter file can not be printed on this printer printer extension value incorrect printer extension value > 9 target invalid specified printer does not exist no jobs queued for specified printer operation illegal : queue is not empty max number of jobs queued print job is active print manager already registered with specified ext value illegal print server signal type communications failure. Try again. no entry in database for specifed key wrong type specified for key read error in print server driver write error in print server driver error creating I/O connection data in print server database corrupted error closing I/O connection internal error in print server driver read error in print server filter write error in print server filter open error in print server filter format error in print server filter input object type incorrect for this filter unable to allocate memory printer with this name already exists user terminated print job user suspended print job print job duplicate from pre10q daemon can not find specified print manager   US  tZ
 $[
   m     $[
     	       /    DB    0Z
 tZ
 $[
 H
                    /
 normal exit from debugger   US  tZ
 $[
    n     $[
     	       /    object module IO Z
 $[
 H
                    /
 too many IO channels in use channel is not open get or put outside file ran out of free read/write storage cannot open another temporary file; one is already opened requested object file name exists and is not an object   
US  tZ
 $[
   n     $[
     	       /    TU58 tape 0Z
 tZ
 $[
 H
                    /
 bad block number invalid op code motor stopped seek error data check write protected no cartridge bad unit number end of tape failed self-test   US  tZ
 $[
    o     $[
     	       /    sio   0Z
 tZ
 $[
 H
                    /
 object on this stream is not sio line bad option parameter illegal stream id stream not open speed incompatible with partner SIO line   
US  tZ
 $[
    p     $[
     	       /    pattern matcher tZ
 $[
 H
                    /
 too many tag specifiers ("{ }") too many end-tag characters ("}") missing end-class character ("]") invalid use of closure ("*") missing end-tag character ("}") pattern too big to fit in supplied buffer invalid escape sequence bad pattern given string and pattern do not match output string too small   
US  tZ
 $[
   p     $[
     	       / $   wildcard processor  $[
 H
                    /
 can't get free space for pathname invalid wildcard length invalid wildcard name invalid use of directory closure ("*" or "+") too many components internal error #1 circular link detected first name found excess end tags ("}") in wildcard missing end tags ("}") in wildcard   US  tZ
 $[
 M  q     $[
     	       / ,   font manager Z
 tZ
 $[
 H
                    /
 font table is full bad font file unrecognized font version # bad font id argument bad value id character is not in font free storage space full character is too large descriptor or header value is out of range invalid character code no character image font is read-only one or more images are required font table is full   US  tZ
 $[
   r     $[
     	       / 4   shell   0Z
 tZ
 $[
 H
                    /
 shell lexer has failed - unable to recognize input parse tree has been corrupted - unable to recover unable to allocate space for parse tree wrong file type - can only execute object and text files program not found inlib command obsolete; relink program with inlib option insufficient rights   !US  tZ
 $[
    s     $[
     	       / <   aclm   0Z
 tZ
 $[
 H
                    /
 no right to perform operation insufficient rights to perform operation exit_super called more often than enter_super wrong type - operation illegal on system objects entry already exists ACL is remote ACL is on different volume than object ACL protects wrong type of object insufficient address space to open ACL required entry may not be deleted no entry - entry number too large image buffer too small or incorrect size ACL object not found ACL would be unchangeable object may not be readable by backup procedure no right to set subsystem data or subsystem manager project list is full - no more entries may be added project list is too big - it cannot be added to object ACL is full - no more entries may be added invalid right name invalid person identifier invalid project identifier invalid organization ID invalid node ID non-existent SID subsystem name not found required entry missing from ACL attempt to issue unimplemented ACL call invalid selection for required entry invalid required entry may only setid to required entry may not use setid in a default acl invalid right supplied   US  tZ
 $[
   u     $[
     	       / D   uvtoc   0Z
 tZ
 $[
 H
                                                                                                                                                                                                                                                                       }                        D        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        +      v      /
 object is not a local entry directory no available address space end of vtoc   	US  tZ
 $[
 W   v     $[
     	       / L   cl    0Z
 tZ
 $[
 H
                    /
 Argument too long Too many arguments follow keyword Not enough arguments follow keyword Invalid decimal number No match for wildcard Missing required derived name Unrecognized or redundant keyword Duplicate set element Invalid set element   US  tZ
 $[
   v     $[
     	       / T   bin_tree 0Z
 tZ
 $[
 H
                    /
 unable to allocate rws space end of list not found   library $[
    w     $[
     	       / \   open   0Z
 tZ
 $[
 H
                    /
 do not provide name for SCRATCH file need name of file to open invalid STATUS= option direct access not allowed with variable length records given record length is not compatible with this file need record length > zero invalid ACCESS= option invalid FORM= option invalid UNIT= specifier no space to create requested IO unit FORM= option value not compatible with this file BLANK= option not allowed for unformatted file invalid BLANK= option unrecognized special name beginning with "-" command line arguments are named ^1 thru ^9 file not found   library $[
 (  x     $[
     	       / d   close   0Z
 tZ
 $[
 H
                    /
 KEEP status not allowed for SCRATCH file invalid STATUS= option can't delete file   library $[
   x     $[
     	       / l   mark/release Z
 tZ
 $[
 H
                    /
 cannot find old Fortran IO state record   library $[
    y     $[
     	       / t   IO    0Z
 tZ
 $[
 H
                    /
 no space to create IO unit unit is not connected recursive use of FORTRAN IO direct access not allowed to sequential file need record number for direct access invalid option(s) used to reference internal file feature not implemented yet end of file unformatted operation not allowed on file opened for formatted IO formatted operation not allowed on file opened for unformatted IO not enough virtual address space left to perform requested operation   library $[
    z     $[
     	       / |   IO transfer 0Z
 tZ
 $[
 H
                    /
 Internal format error No edit specifier in format Improper character in input data Real exponent too large Improper format descriptor for variable type Data overflows buffer size   library $[
 '   {     $[
     	       /    read   0Z
 tZ
 $[
 H
                    /
 end of file record is larger than available buffer = expected name not found in namelist ) expected integer expected as an array subscript ( expected number expected , expected array variable expected subscript out of bounds unknown high dimension on array variable   library $[
   {     $[
     	       /    write   0Z
 tZ
 $[
 H
                    /
 nyi   library $[
 =   |     $[
     	       /    position 0Z
 tZ
 $[
 H
                    /
 no space to create unit unit is not connected recursive IO   .library $[
    |     $[
     	       /    floating point  tZ
 $[
 H
                    /
 overflow in add/sub underflow in add/sub loss of significance in add/sub overflow in multiply underflow in multiply overflow in divide underflow in divide division by zero overflow in convert to word integer overflow in convert to long integer overflow in dp add/sub underflow in dp add/sub loss of significance in dp add/sub overflow in dp multiply underflow in dp multiply overflow in dp divide underflow in dp divide dp division by zero overflow in convert double to single underflow in convert double to single square root of a negative number overflow in exp function overflow in dp exp function arg of log function less than or equal to zero dp arg of log function less than or equal to zero underflow in exp function underflow in dp exp function attempt to raise sp zero to a power <= zero attempt to raise sp negative number to a real power attempt to raise dp zero to a power <= zero attempt to raise dp negative number to a real power both arguments zero in sp atan2 both arguments zero in dp atan2 overflow in sp x**y overflow in dp x**y underflow in sp x**y underflow in dp x**y loss of significance in sp tan - argument too large loss of significance in dp tan - argument too large loss of significance in sp sin - argument too large loss of significance in dp sin - argument too large loss of significance in sp cos - argument too large loss of significance in dp cos - argument too large argument out of range invalid op code unsupported function for this hardware configuration   library $[
 V       $[
     	       /    inquire 0Z
 tZ
 $[
 H
                    /
 cmd line args are named ^1 thru ^9 recursive io target string too small   library $[
 "        $[
     	       /    format  0Z
 tZ
 $[
 H
                    /
 left parenthesis expected right parenthesis expected period expected comma, colon, slash, or right parenthesis expected unsigned integer constant expected p format not followed by f, e, d, or g bad hollerith or character constant unrecognized format specifier  Tlibrary $[
        $[
     	       /    tfp   0Z
 tZ
 $[
 H
                    /
 computed block count doesn't match that in EOF label  volume not found volume not open volume already open file not open file already open file not found tape i/o error end of volume encountered invalid file section value invalid file sequence value invalid generation number value invalid generation version number value invalid block count value invalid block length value invalid record length value invalid buffer offset value no tcb is available (internal table full) invalid unit number first label on volume is not VOL1 label label version number in VOL1 label is not "3" tape drive is already in use by this process end of file tape limit: eot/bot marker encountered label size is in error; not 80 characters block size is too large invalid record format specifier unlabeled operation attempted on a labeled volume labeled operation attempted on an unlabeled volume invalid volume id conflicting blocking information file does not exist on this volume internal or exception procedure returned bad new-volume info a HDR1 label is missing where one is required an EOF1 (or EOV1) label is missing where one is required a double filemark was encountered unexpectedly inconsistent file sequence numbers file sequence number tracking error read attempted on file open for writing write attempted on file open for reading block list size is invalid an EOV1 (or EOF1) label is missing where one is required wrong volume, file header is inconsistent with previous trailer operation not started due to error in previous block list record i/o attempted on volume open for block i/o only variable record with invalid record control word encountered spanned record with invalid segment control word encountered erroneous spanning indicator or segment out of sequence encountered invalid mode set passed to tfp_$set_mode cannot read mt status - wait is required more info returned from mt_$wait that expected attempt to enqueue too many operations magtape is offline or floppy is not ready wait not performed                                                                                                                                                                                                                                                   ~                        ![!        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                                     before go go called with no work to do invalid operation code OS magtape manager out of pb's wait called when not required OS magtape manager didn't purge ops on error # ops executed does not match # ops completed i/o error recovery failed invalid recovery value returned by execption handler zero length block list unexpected tape rewind error tape space-record error tape space-filemark error tape write-filemark error tape or floppy is write-protected redundant call to wire i/o buffers attempt to already-unwired i/o buffers unable to re-open volume; current position is unknown unable to re-open volume; info file is bad tape read-foreign error cannot write at this tape position unexpected sysboot error unknown rmt error rmt tape blank or offline rmt tape is blank rmt tape is write protected or is offline rmt tape is offline rmt tape is write protected or at end-of-tape rmt tape is at end-of-tape rmt open failed rmt prevailing write error rmt unsupported operation   library $[
        $[
     	       /    Pascal  0Z
 tZ
 $[
 H
                    /
 too many open files use of unopened file REWRITE required before writing to file RESET required before reading from file read past end of file real exponent too large invalid operation on file invalid OPEN parameter inconsistent file usage invalid read data internal error; invalid I/O key type attempt to DISPOSE a NIL pointer attempt to DISPOSE block of memory of zero or negative size attempt to DISPOSE pointer to memory that was previously DISPOSEd index outside of string bounds overflow beyond maximum size of string invalid write data unable to DISPOSE pointer; pointer may be previously DISPOSEd or not allocated   &library $[
         $[
     	       /    MBX manager 0Z
 tZ
 $[
 H
                    /
 size parameter too large size parameter too small too many channels illegal mbx handle file already in use no room in channel msg too big for channel no active servers open rejected end of file no available channels channel not open unexpected control message received remote transmit failed remote reply wait timed out unused invalid mbx handle wrong mbx version number unknown remote request remote service denied channel empty supplied buffer too small unused no more resources available bad key returned data does not complete a record unused interrupt data received another interrupt is already pending on this channel client and server cannot be same process client timed out while waiting for open to complete error occurred during network sequenced send server node mbx_helper has no rights to server mbx client has no rights to local mbx_helper sysmbx server record header conflicts with buffer length local mbx_helper not running and couldn't be started no remote mbx_helper running client has no rights to server mailbox   library $[
 O       $[
     	       /    ptx plot package Z
 $[
 H
                    /
 image too small in the x-dimension image too small in the y-dimension invalid value for horizontal start  library $[
 <        $[
     	       /    floppy seq i/o manager  H
                    /
 warning: record truncated warning: disk almost full  invalid floppy unit # floppy is full control block is too large end of file end of tape unit is already open unit is not open attempted write on read-only floppy invalid marker specification data error: filler expected where none was found data error: filler found where not expected data error: invalid control code data error: record trailer missing data error: record trailer doesn't match header beginning of tape data error: beginning of tape found where unexpected floppy is physically write-protected floppy is not ready invalid label record -- probably not written with WBAK   &library $[
 <       $[
     	       /    Ethernet driver tZ
 $[
 H
                    /
 controller does not exist invalid ethernet controller number controller not online invalid buffer size parameter invalid statistics type invalid mode parameter invalid options parameter illegal number of addresses address is not a valid group address no receive available quit while waiting receive packet truncated too many collisions device timed out operation failed internal frame header invalid internal dma length error unexpected status from device diagnostic ram test failed diagnostic dma test failed diagnostic transmitter test failed diagnostic receiver test failed diagnostic loopback test failed DDF version is obsolete DMA/PIO did not complete service is not implemented in this driver adaptor reported no resources available adaptor self-test failed No packet type set for this process Packet types are already set for this process Ethernet unit is shared with other processes Ethernet driver master lock timeout Packet type already in use by another process Internal error -- unable to allocate control block Internal error -- unable to open socket Unable to allocate receive buffers Bad argument to ethernet routine Ethernet device lock timeout   library $[
 J        $[
     	       /    versatec driver tZ
 $[
 H
                    /
 invalid action code invalid buffer size no PBU or Versatec controller is installed device is offline device is out of paper   library $[
 J       $[
     	       /    pipe manager Z
 tZ
 $[
 H
                    /
 supplied buffer too large pipe is empty pipe is full illegal pipe operation pipe has no readers pipe has no writers pipe could not be locked   library $[
 [        $[
     	       /    amlc manager Z
 tZ
 $[
 H
                    /
 controller does not exist bad unit number   library $[
 	       $[
     	       /    streams-magtape manager H
                    /
 object is not a magtape file descriptor magtape file descriptor contains invalid data invalid attribute specifier invalid creation/expiration date invalid record format descriptor file is read-only invalid unit number invalid file sequence number invalid file section number invalid block length invalid record length invalid generation number invalid generation version number invalid buffer offset magtape volume is in use attempt to label unlabeled volume   library $[
 X       $[
     	       /    streams-directory manager H
                    /
 unrecognized mode size parameter too small too many channels   library $[
         $[
     	       /    ipc socket manager  $[
 H
                    /
 range error too deep socket error no more sockets not owner too much data socket empty not ipc object socket not open socket already open time out  library $[
 0       $[
     	       /    traceback utilities $[
 H
                    /
 warning: guessed return address  pc not in known code invalid object module version no debug table entry for routine no debug info available for routine frame type illegal for operation routine has no arguments specified argument does not exist no stack frame exists for routine   	library $[
         $[
     	       /    spe driver 0Z
 tZ
 $[
 H
                    /
 SPE controller or SW not installed controller not initialized device is busy device is offline device is out of paper device fault invalid sio line controller already initialize                                                                                                                                                                                                                                                                           wF        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                        |            d error in interrupt handler   library $[
         $[
     	       / $   analog/digital driver 
 H
                    /
 Buffer length limited to 1024 bytes Attempt to allocate or declare too many buffers System cannot create the new buffer Attempt to use a buffer that is not declared Attempt to link a buffer already on xfer list Declared buffers must not cross 1024-byte bndry Declared buffer address must be word-aligned Converter clock set too fast or too slow A/D channel list limited to 16 entries Valid A/D channel numbers are 0 through 15 Buffer was not ready in time for DMA transfer Clocks or triggers too fast Operation took longer than the time out interval Waiting for buffer already released Waiting for buffer not in transfer Converter hardware not present Unable to convert value given   library $[
 K       $[
     	       / ,   compound executables manager 
                    /
 bad compound executable format specified module not found in compound executable   >graphics [
          $[
     	       / 4   primitives 0Z
 tZ
 $[
 H
                    /
 Primitives not initialized Primitives already initialized Wrong display hardware Operation illegal for DM frame Must borrow display for this operation No attributes defined for bitmap No more bitmap space available Dimension too big Dimension too small Bad bitmap descriptor Bad attribute block descriptor Window origin out of bitmap bounds Source window origin out of bitmap bounds Destination window origin out of bitmap bounds Invalid plane number Cannot deallocate this bitmap Coordinate value out of bounds Invalid color map Invalid raster operation value Bitmap is read-only Internal error Font table is full Bad font file Invalid font id Window is obscured Display is not in direct mode No polygon is being defined Keyboard has not been acquired Display has not been acquired Illegal pixel value range Operation illegal when in imaging format Bad value for imaging format Must release display for this operation Different screen modes for input cannot be mixed No input events are enabled Duplicate points are illegal Array must be in ascending order character is not in font Illegal bitmap for a fill pattern fill pattern scale must be one Incorrect alignment Illegal text path Unable to rotate this font Font is read only Illegal length for styled line pattern Illegal for pixel bitmap Input enabled in too many windows Illegal software version number in pad Bitmap descriptor is not for a bitmap file No color map has been defined for this file Illegal call for current decomp technique Cannot change decomp technique while in polygon Specific winding number must be nonzero Arc path coordinates have overflowed 16bits Invalid virtural device id Decomp technique not valid Rop mode set is null, set via raster_op_prim_set Multiple rop modes in set, and rops not equal Input events not available in gpr_$no_display mode Style call is not active No more fast buffers for double buffering Input buffer overflowed   graphics [
 $        $[
     	       / <   DM support 0Z
 tZ
 $[
 H
                    /
 Invalid bitmap address Invalid bitmap length   graphics [
         $[
     	       / D   core graphics 
 tZ
 $[
 H
                    /
 3D inquiry function needed Count parameter or array size is less than 1 Array size is less than 3 There is no selected view surface Inconsistant viewing specification A segment is currently open There is no open segment Color attribute not supported by view surface Intensity attribute not supported by view surface Requested linestyle attribute not supported Requested linewidth attribute not supported Requested pen attribute not supported Requested font not supported String contains undefined characters Charplane and charup vectors are parallel Requested marker symbol not supported There already is an open segment The requested retained segment name already exists Current image transformation is of wrong type There is no open retained segment There is no retained segment matching given name There already exists a segment with given name There is no open temporary segment One or more of the attribute values is invalid All charplane normal components are zero All charup components are zero Image transformation type is invalid Image transformation higher type than requested Segment image xform type not compatible with inq Segment image xform type higher than inquiry Maximum less than minimun value (2D) View up vector components both equal zero Program has already set NDC space NDC default space has already been established A parameter is not in NDC system : 0->1 Neither width nor height is equal to 1 Width or height is equal to zero Viewport corner outside of NDC space A 3D viewing function was needed, not 2D Specified NDC position is outside viewport The world coordinate xform is not invertible World coordinate position outside clipping window All 3 components of view plane normal are zero Front distance is greater than back distance Parallel projection and direction components = 0 Window maximum less than window minimum All 3 viewup normal vector components are = 0 Maximum less than minimun value (3D) Projection of world coord. position outside window World coordinate position in front of clip plane World coordinate position in back of clip plane World coord. position behind center of projection Coordinate system type has already been set Too late - viewing established or segment exists View plane normal and viewup vector parallel Front plane not between cop and back plane Direction of projection aparallel to view plane Center of projection on or behind view plane Front and back clipping planes coincident Device already initialized Device class or device number is invalid Device class is invalid Array contains invalid device number Device is not initialized Device is already enabled Member of group not initialized Device is not enabled Locator device not enabled Valuator device not enabled Time parameter is less than zero Event device not initialized Invalid event device class Association already exists Event class is invalid One or both devices not initialized Association does not exist Event report not from pick device Event report not from keyboard device Event report not from stroke device Needed 3D input function Locator not enabled or associated Valuator not enabled or associated No button devices are initialized Specified pick device not initialized Specified keyboard device not initialized Specified stroke device not initialized Specified locator device not initialized Specified valuator device not initialized Echo type is invalid for specified class Specified device does not accept echo segment Image xform of segment incompatible with echo type Echo position outside of NDC space Pick aperature is less than or equal to zero Buffer size out of bounds Cursor start position out of bounds Initial string contains undefined characters Specified button device is not initialized Distance or time less than or equal to zero Specified locator position outside of NDC space Maximum less than minimun (3D) Locport corner outside of NDC space Low value is greater than high value Initial value not within defined range Associated size less than or equal to zero Duplication size less than or equal to zero Core has already been initialized Specified output level cannot be supported Specified input level cannot be supported Specified dimension cannot be supported View surface is already initialized                                                                                                                                                                                                                                                                            Q        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        -            No output device associated with view surface No other view surface can be initialized View surface is not initialized View surface is already selected View surface cannot be selected View surface has not been selected Immediate visibility state is invalid Currently in batch of updates Not in batch of updates Element of segment array does not exist Invalid visibility array element Core has not been initialized Function at a higher level than current suppory Invalid error log invocation Function is not supported Parameter count is incorrect One or more parameters invalid Vertex array is too small Intensity value is invalid Color value is invalid Specified table range is invalid Low or high table index is invalid Low table index is greater than high Too few values to fill specified range Invalid intensity array element Invalid color array element Origin outside NDC space Array size invalid Array row invalid Array column invalid Invalid parameter value View surface is initialized to intensity Invalid index value Shading vertex mismatch Vertices not coplanar Less than three vertices received Index range is too large Table is too small View surface is of type color View surface is of type intensity There is no hidden surface support The specified mode is invalid View surface is initialized Invalid view surface type parameter Input currently not supported in frame mode There is no room to add to the display list There is no room for new segments Polygon was too complex to decompose Time out in input routine   graphics [
        $[
     	       / L   map file manager Z
 $[
 H
                    /
 Bits/inch parameter is negative X dimension is not positive Y dimension is not positive Words/line parameter is too small Position parameter is illegal   ;graphics [
        $[
     	       / T   2D metafile manager $[
 H
                    /
 Not initialized Already initialized Data coerce needed No current file Too many files File name not found File id invalid No current segment Another segment is open Segment name already used Too many segments Segment name not found Segment id invalid Cant delete instanced segment Segment locked by pick Invalid polyline options Negative circle radius Circle cant be filled Illegal self instance Aclass id invalid Ablock id invalid Too many ablocks Ablock not created Attribute value invalid No font family included Too many font families Font family name not found Font family id invalid Cant delete font family in use No gm bitmap exists Viewport id invalid Viewport bounds invalid Viewport doesnt exist No current viewport Too many viewports Nothing displayed in viewport Coordinate conversion overflow Command type doesnt match No current command No pick matches found Pick list not initialized Pick list empty Pick list too long Input event type invalid Wrong display mode Illegal value Bounds invalid Name length invalid Font family name already used Obsolete procedure Command type invalid Concurrency mode invalid Access mode invalid Edit option invalid Index value invalid Font type invalid Too many environment file definitions Negative arc radius Flat arc   ,graphics [
         $[
     	       / \   GSR   0Z
 tZ
 $[
 H
                    /
 Operation invalid Zero vector invalid Vectors are dependent Invalid hither distance Invalid clip planes Invalid window Matrix is singular Ran out of space Invalid file id Too many files Viewport outside ldc range No intersection Point outside device limits Illegal instruction Unimplemented instruction Pick interrupt No further picks Invalid context range Illegal single step count Illegal instance depth Display context not found Display break on instance Display break on return Illegal break point found Partial refresh sync error Illegal display mode error GPU device not present Invalid virtual device id Unsupported opcode for this machine Unsupported execution mode for this machine Block size is too small Unsupported device Invalid eye distance Display device error Illegal operands Device unavailable Previous error in display device Insufficient zbuffer memory Font file already loaded Font table full Bad or improperly formatted font file Invalid font id Font still referenced Unable to rotate this font   graphics [
        $[
     	       / d   metafile manager Z
 $[
 H
                    /
 Operation invalid Unable to remap file No such structure Invalid in read access mode Illegal argument Already initialized Invalid plane count Not initialized Too many files No such file Invalid file id No current file No current structure Too many points Too few points unused (16) Viewport does not exist Illegal value Viewport bounds invalid Attribute value invalid No gmr bitmap exists Too many viewports Unable to clear viewport Viewport id invalid No current viewport Not implemented Unable to allocate page Unable to initialize file Structure not allocated Render record not allocated Edit record not allocated Structure body not allocated Unable to initialize structure tables Viewport borders too large Viewport outside ldc limits Unable to map file Viewport border outside ldc Instance not allocated Tag not allocated Unimplemented mode Structure name already used Too many structures Unable to grow file on open Unable to allocate additional space Structure size too large to grow Unable to allocate element space No current element Invalid for display mode Input event type invalid Unable to grow file at edit Inq element does not match Color id out of range Inq array size too small Structure already open Aclass id invalid Ablock id invalid Too many ablocks Text invalid string length Text up vector too short LDC limits invalid File initialization error No primary structure Too many instances of structure Ablock not created Structure header allocation error Instance record allocation error Tag record allocation error Device limits invalid Returned block too short Structure move body error Structure release version error Instance structure id mismatch error Structure has no bounds Unknown element Tag not located Intensity out of range Element index out of range Structure delete error Add instance link error Drop instance link check error Drop instance backward link error Drop instance forward link error Release instance id error Structure is instanced Ablock in use Color model inconsistent Color range invalid Valid range is 0 to 1 Unable to copy between files File version mismatch Odd number of points Viewport state version mismatch Structure is still open Recursive instance Invalid view plane normal Invalid up vector Invalid hither distance Clip planes reversed Information unavailable Invalid clip zmin Invalid border width Locator outside device limits Locator outside viewport Invalid normal vector Matrix is singular Zero vector invalid Loss of precision Replace element zero index Point outside viewport Invalid window Pick index out of range Element index not found Instance index lookup failure No elements in structure Highlight lookup error Bounding box highlight only Highlight block undefined No highlight defined Using highlight default ablock Pick list empty Pick error Path depth out of range Highlight out of range Instance echo path viewport mismatch Illegal instance path length Illegal pick aperture size Non instance found on path Dynamic mode incompatible element type Dynamic mode path viewport mismatch Dynamic mode already set Dynamic mode not set Dynamic mode null element Dynamic mode edit lock Bitmap attribute block error Mark typ                                                                                                                                                                                                                                                                           W&J        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                                    e invalid Invalid line type Invalid name set Invalid attribute type value Invalid attribute source value Echoing non primitive Graphics Accelerator not present Normal in plane of polygon Invalid shading mode Invalid hidden surface mode Invalid fill style Invalid bsp id Bsp file does not exist Light index out of range Zbuffer not supported on device Illegal in dynamic mode Dynamic mode buffer overflow Unknown tag type Polygon decomposition region count exceeded Polygon decomposition point count exceeded Replaced element not an instance Ptext not allocated No structure assigned to viewport No bsp tree assigned to viewport Non-trivial 4th column in matrix Light source not enabled Wrong light source type Wrong structure type Points are collinear Storage undefined Zbuffer not enabled Insufficient zbuffer memory Internal error with concave polygon Relocation failure Storage mismatch Compactor failure Invalid propagation option 4x4 can't convert to 4x3 Initial structure size too small Initial structure size too large Growth rate is too small Growth rate is too large Growth constant is too small Growth constant is too large NOP size is too small NOP size is too large NOP multiple is too small NOP multiple is too large Invalid font i.d. Font i.d. in use Obsolete procedure   graphics [
        $[
     	       / l   color table manager $[
 H
                    /
 Requested pixel values not available No RWS available Requested pixel value not allocated   graphics [
        $[
     	       / t   IDM/RM resource manager H
                    /
 not an resource ID resource no longer exists wrong resource type non-existent resource null resource ID resource in use, only marked for deletion ?? unused resource manager error code 7 ?? ?? unused resource manager error code 8 ?? bad resource pointer null resource pointer resources index/pointer mismatch attempt to link an already linked resource UETLIB version number mismatch record length mismatch no more RW storage available   graphics [
         $[
     	       / |   rectangle manager 
 $[
 H
                    /
 not a rectangle ID rectangle no longer exists not a RM ID non-existent rectangle NULL rectangle ID rectangle in use, only marked for deletion   not a group ID group no longer exists not a RM group ID non-existent group NULL group ID group in use, only marked for deletion   rectangle is a root rectangles have different roots invalid rectangle limits WARNING (x,y) not in any sub-rectangle (x,y) not in parent or any rectangle no such rectangle property key null rectangle property key caller supplied array too short rectangle not acquired rectangle not in use rectangle already in group rectangle not in group quit-fault while waiting to acquire operation is inconsistent with attributes rectangles have different parents   /graphics [
 p       $[
     	       /    input demultiplexor $[
 H
                    /
 not an event processor ID event processor no longer exists wrong IDM resource type non-existent event processor null event processor ID event processor in use, only marked for deletion   not a focal point ID focal point no longer exists wrong IDM resource type non-existent focal point null focal point ID event processor in use, only marked for deletion   not a queue ID queue no longer exists wrong IDM resource type non-existent queue null queue ID queue in use, only marked for deletion   not a binding set ID binding set no longer exists wrong IDM resource type non-existent binding set null binding set ID binnding set in use, only marked for deletion   bad IDM key event processor blocked focal point and rectangle not associated buffer full focal point not active binding set array too short no such logical device bad logical device index wrong logical device type focal point is not a focus event processor not in use focal point not in use queue not in use binding  not in use event bindings are not in global memory   graphics [
        $[
     	       /    BitMapFile manager  $[
 H
                    /
 Package not initialized Invalid x size value Invalid y size value Invalid file identifier Too many files open Invalid file length specifier Invalid scanline length Out of bounds access Header size error Procedure is obsolete Package already initialized No zbuffer data area allocated Wrong size zbuffer Improper window size Invalid user data length Invalid offset value Wrong file format No user data allocated File is compressed File is not compressed File format mismatched Color map is not allocated Invalid color map index Too many color map entries Illegal color map entries   graphics [
         $[
     	       /    raytracer shell tZ
 $[
 H
                    /
 Operation invalid Package not initialized Matrix is singular Zero vector invalid Vectors are dependent Invalid window parameters Invalid view distance value Bitmap already exists Bitmap does not exist Invalid pathname Invalid rectangle parameters Invalid resolution parameters Invalid up-vector value Invalid normal-vector value Invalid bitmap size No object open Object not an aggregate Too many open objects No such object No such attribute Attribute stack overflow No active attribute Save-file overflow Invalid opcode Too many lights   graphics [
 ^       $[
     	       /    raytracer kernel Z
 $[
 H
                    /
 Operation invalid   graphics [
        $[
     	       /    geometry trait  tZ
 $[
 H
                    /
 Unimplemented trait function Scratchpad memory overflow Degenerate trimming loop Memory management error item not found Trimming loop outside support of knots  graphics [
        $[
     	       /    display 0Z
 tZ
 $[
 H
                    /
 Node does not have a display  Stream is not associated with a display   RGYC Z
 $[
        $[
     	       /    Client  0Z
 tZ
 $[
 H
                    /
 Entry not found Name already exists Name is too long Incompatible program and file versions No more memory space available Registry is read-only Invalid file, internal error Registry salvage only partially complete No valid registry found at any registry site Name must begin with a lowercase letter Cannot delete reserved name Unable to access registry at any registry site Name contains invalid characters Entry already exists Operation not yet implemented Invalid person identifier Invalid group identifier Invalid organization identifier Invalid node identifier Invalid p.g.o identifier Operation invalid in specified domain New password is too short New password is too long New password cannot be all spaces New password cannot be all alphanumeric Password incorrect Invalid owner   RGYC Z
 $[
 x       $[
     	       /    Login   0Z
 tZ
 $[
 H
                    /
 Shutting down Exiting insufficient address space password does not check account is invalid or has expired  logins are disabled   	RGYC Z
 $[
 |        $[
     	       /    Server  0Z
 tZ
 $[
 H
                    /
 Operation not yet implemented Unix id changed or incorrect Object is an alias Registry server unavailable Person is not a member of specified group Person is not a member of specified org Person is not a member of specified group and org Incomplete account                                                                                                                                                                                                                                                                           l<        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                                     name Not authorized to perform operation  D3M data management    $[
     	       /    d3mlib  0Z
 tZ
 $[
 H
                    /
 database not open dbk for wrong area database already open transaction lock request timed out duplicates error current unknown end of set or area unknown name; not in schema database open read only or update transaction not in effect wrong password no disk space dbk not available/no good unused no current of this record type set has no optional members record is  already member violation of concatenated set integrity unused unused current of rec wrong type current of rununit of wrong type record not member in set record not in area unused unused no record satisfies record selection unused area already open area not open delete set not empty internal stack overflow invalid literal argument invalid argument unused operation cannot be performed within transaction unused unused unused fatal D3MLIB error findv requires sorted set findc requires calced record record not indexed unused improper set mode set, record, etc. not in subschema unused unused unused unused unused deleted rec referenced key relation mismatch HLDML call error HLDML syntax error HLDML semantic error HLDML execution error from D3MLIB unexpected HLDML execution error HLDML internal error unused unused close error name not found file not found required resources not available end of file wrong object type unable to open unused database must be recovered (use RCVRDB) loc mode select required in all sets too many sets in path multischema inconsistency distributed DML operation not supported dynamic store error violation of distributed set integrity unused unused unused unused unused transaction call err active transaction required unused unused unused unused D3MLIB error unused schema/subschema confusion recompile schema read error on (sub)schema file (sub)schema file open err database write error database read error concurrency violation device unavailable unused must preallocate file (use INDB) bad bucket address                                                                                                                                                              lock table overflow insufficient virtual memory user needs to be salvaged (consult D3MUTL) no D3M server running at database node internal fatal D3M error.  Please examine `node_data/system_logs/d3m_error_log bad D3M_$dbrcvr call database areas not found journal files not found journalling for recovery not enabled database in use subschema used for recovery does not include all areas file is not an area no access rights insufficient access rights network communications problem object does not have D3M subsystem seal (use D3MUTL) unable to seal object - /sys/d3m/d3m_u2 not found unable to seal object - /sys/d3m/d3m_u2 not a D3M subsystem manager too many users of database or databases on same node control tables have been corrupted - restart D3M server D3M server version is incompatible with the installed D3M library salvage operation is potentially unsafe client not found client is marked for salvaging client is not marked for salvaging salvage operation is in progress no mbx_helper on the server node and could not start one                                                                                                                D3M internal signal (ignore it) non-local goto to DML entry point D3M lock manager file is not the expected version message reply timeout send message timeout multi-page message reply error    UNIX Z
 $[
        $[
     	       /    signal  0Z
 tZ
 $[
 H
                    /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
        $[
     	       /    child unconditional suspend signal                  /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
        $[
     	       /    child continue signal 
 H
                    /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
 k       $[
     	       /    child death signal  $[
 H
                    /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
 :       $[
     	       /    ptrace signal 
 tZ
 $[
 H
                    /
 hangup fault interrupt fault quit fault illegal instruction fault                                                                                                                                                                                                                                                                            m=        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                        *            trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
 	       $[
     	       /    child keyboard suspend signal 
                    /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
         $[
     	       /    child background read suspend signal                 /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault    UNIX Z
 $[
         $[
     	       /    child background write suspend signal                /
 hangup fault interrupt fault quit fault illegal instruction fault trace trap fault IOT instruction fault EMT instruction fault floating point exception fault process kill fault bus error fault segmentation violation fault bad argument to system call fault broken pipe fault alarm clock fault software termination fault user-defined fault (1) user-defined fault (2) child death fault Apollo-specific fault process stop fault stop signal generated from keyboard fault continue after stop fault child status has changed fault backgrnd read attempt from control terminal fault backgrnd write attempt from control terminal fault i/o is possible on a descriptor fault cpu time limit exceeded fault file size limit exceeded fault virtual time alarm fault profiling timer alarm fault urgent condition present on socket fault window changed size fault   	UNIX Z
 $[
 v        $[
     	       /    sys5 ipc 0Z
 tZ
 $[
 H
                    /
 not holding db lock undefined already holding db lock bad free of msq space bad lock request no access ipc object not found no space for descr ipc object already exists   UNIX Z
 $[
        $[
     	       /    longjmp 0Z
 tZ
 $[
 H
                    /
 internal longjmp status longjmp status   UNIX Z
 $[
 N        $[
     	       / $   file utilities  tZ
 $[
 H
                    /
 incorrect version number directory created soft link created   UNIX Z
 $[
        $[
     	       / ,   errno status Z
 tZ
 $[
 H
                    /
 incorrect version number directory created soft link created UNIX Z
 $[
        $[
     	       / 4   file I/O 0Z
 tZ
 $[
 H
                    /
 unknown type   UNIX Z
 $[
 a        $[
     	       / <   device number 
 tZ
 $[
 H
                    /
 entry not found table full entry in use   =store and forward manager 
     	       / D   lib   0Z
 tZ
 $[
 H
                    /
 unrecognized option invalid site name invalid queue name missing site flag in routing file missing site name in routine file unknown keyword in routing file missing queue name or gateway info in routing file site name not found in routing file invalid message length requested route unavailable invalid queue size invalid queue delete request queue is empty queue is full bad route syntax no further hops in route route entry too long invalid queue release request queue entry already locked bad queue lock request (msg_id mismatch) server not registered a server is already registered message received this hop is last in route route length less than or equal to 0 queue name length less than 0 hop will not fit in route field routing file unavailable    queue already exists bad pathname for queue queue not found bad queue directory no rights to queue insufficient rights to queue message added to local queue  queue control file already exists bad pathname for queue control file queue control file not found bad queue control file directory no rights to queue control file insufficient rights to queue control file   message already exists bad pathname for message message not found bad message directory no rights to message insufficient rights to message   object already exists bad pathname for object object not found bad object directory no rights to object insufficient rights to object   store and forward manager 
     	       / L   sf_helper 0Z
 tZ
 $[
 H
                    /
 bad delay specification   netman  $[
        $[
     	       / T   netman  0Z
 tZ
 $[
 H
                    /
 unknown service request type   netman  $[
 D        $[
     	       / \   boot   0Z
 tZ
 $[
 H
                    /
 node not in diskless list requested file has wrong machine id unknown boot service request kind wrong type uid invalid page range in boot service request error encountered in netman.rc   netman  $[
        $[
     	       / d   dump   0Z
 tZ
 $[
 H
                    /
 dump already in progress from another node dump not open page/close request received from wrong node dump too large for dump file unknown dump service request kind dump timed out waiting for next page   X.25 Z
 $[
         $[
     	       / l   device driver 
 tZ
 $[
 H
                    /
 controller does not exist controller unit number out of range bad buffer pointer bad buffer length invalid device control operation argument invalid eventcount key bad comman                                                                                                                                                                                                                                                                                                                                                                          
1                                                                                                                        ^               A
U>=Cckl@RWlDm"bCCP^mZ]	U?~/^.(kx)b
00?HCYNJCcI>#fykkÝDb*Ux:VLJ@;[nX!P"6aNH8pHdj}/wip^]Wy\n3ъ%xL
Tv)"}S+k/68~3ru.p'K
lvfV	
coc@ar36&t;a%tB-1zkx	/lDS'
JJnE7"UG^"P
ClFFCo&ORY}7`EZPI,*)Jl~HZM"8QR2(.o7DW,)P$2&G]@FUI](hz`(W[]Wa|qy*KA<p
L2@PvdHF?u'KXH0ly>j
GyvKc]WAKF)t#GE^Yb
WYXFc&5w-=&p*e2;UZ c"%~(a3&f"4>o0u	?2,x;sc:gQǝ)	ATM9/<-Z(}L F
2ȇN#UH3z16>lgHn3H"&~&ez/'+k{fdp21d]4rUi6WN'.]_YH7$lUHVQ]		ONB F[7,iPm6(^ ^QS;@im*+NJAJal, Rx+Rpj %?QaMz_<wSRm$_>ռU1sqR%
Ld{j,um2B CrP_83@۟[:a}+
:0xGm=@D`nD[``w:\o8rQ-tKH&(Er4P6|]Z3:Rx%&[Gfٺy'<5xO[<s1zCnM)<#z}d=4-u>T>4JV4j*	/ts??&J>,~{'
j[+H%AxY	ED	V2.=U HWiawm+|EiX(w!z.0'sb
 g7z)!֜;lU%-X\evKJl:-`SD	~9kEa{-o!a4y"1<uܡ]ۭ[n
o"6cfkRk4kl{| 
|YeC	GRyO-b.n	[8KSXh5A
-jAd(r_2ga5<rgs74!Z%pTfn(I7}?Ns3a:`EF9jcbU5h`pjlor8&1
"aQ,­p.$x!-YIY9"9>QCFHH*)m`1Pw8qI

Po&XXj`u*;?qQ\PF2y=*c1V!`XG<HW"m@=3.^Vf)P).BQ_(G	W=K":>)"
}P#Zpx{I
7gy9pGT!*qJ[@?|oʼk7%1PLYrpo>)>2&*gwg|WƂQߙb-CT>Mq],`bZuvA(],?;BZi<?'c6+I)+H[-,5Tm=*^AWN"D0y!f`H
!#+ar*.qԥKjUNp.o|`<|XMU!@u~+"ur-HG}`WodfR`-+C)Vy<	h<t76Ƭ"{vo:s(# VmC9yȰ#W)m(Yl[5 Y`eru+%a0xSOaR`N<Rj?0(
j<'Sz
O*-.pM
?>;"ftu3\PI
TuKD\$WIZ?V@L Gv%Zj
"[  _K	+	EZWbryg@	{d^ZHM!	6W4AUEQ(x1FPFT(_h$k.xמk}#xpm')nE(Tڙ/w^p)@Aq;aWŠD"pI?дX(nETG^;M'!knF٫~V_^Es3
<Os:

j[uI%>u3:20P>d6}q7h|g`C"i6=lh`8a9/v>)"-	.3:$owa1Rrp&jXWwS\1nR#t9S6qGUfwj3;vMB[*ayiC@i\@E)Cmg+Zevˮ=e	6 -[dG4';J>A<+DNJ;WAPa7
/KB?X}W]U77%HG^O
N6dC)ԙjf#>l'YT>F>-V9Fv%>6~ 9WB*]_N~tg{F;Rwsm+ju;yAfw*f_DNmCMJ
`<;O\
:STO
k?M7]C}6H9?e=&iOCg7oNo3yZn+	(`|x)s|Q*]Lux:0u~bx
zf
'wp`a MU8y!9V{{_^E5oeG+[^2#dcgCڡӎbO%:I`Z*S\_[hNCfE9,U%Pzw3%"Wf>f hF6Pjo&m%Mo@L"BU	?$ƂzO&Dx5	 ?\MhV4	I?\Id-Qr*"E/b3 #NX5*eAL3t_90"x$s{
.p1cF>ؾZ+=wBi-MNYh&BDsB$iUN
TMX|	)
JDLH3(/R$.P^TN`IEbCXV!L&[EHj$O[]G
zc#7aYA7D2(-H0:uYwo.je$.;3 (o,eW5ULe3A`8w [6g'K=,a25*Y.eIE.<\	U:x;h1q{Ci.1
?5~~got
@t8Ap,bED?C"'m;sF{>-N/{(h}qbs1o|CqM (ںIMeqsncRM<
SRD
 *QJ0
o[QBw ?0Z
tYv+.%>m3XE^]!2"FV[zrr?fJDCSEi"f1XxH{o@E	GrC	!yrK5JHW>rHCR%q\as&~[*6b_A$2V
ozxv7h=@ܙ5m|lf0J9
Y96,=5d~<U4q?V].@H)4qdLB^MNCv-]ⱙWWVG+		LU->dqv
SN+<''[i(h?h0cBZ-I~`-c#+x{{p1i=ziU4G=h[_zu0n['pJmH![fG.AM"k5%t&7$]++02:6p4+
˓x&ƏJNA
-apwfMI-y}03dt+g`zS]Zg&(b|"~ebl9%ruOU-.i=Q=V)1yUw<|49ajA.@m_gY0%k[nЙwe-fQY@-
߳*>IStIOs!w UW/IxE)96I|A \7숁4bdvy- "4[fSPyDRe=y[!=d?svpRzJ| >b6 `[Eb+0(p3n3mu|==z`0RLIA^t~3^;\PZFGSC^+;$v	ttn'O_Mdu!?We"V6hg"esuL=
"KaK[Y~ ]'YDAfE>xc#Qp*}t@~|39*yl%
ľ<jG%f!S7BSUZ/<<($E:"* %-VXIsJQѳ18_w[;EP&UEaw:EIA%[H^DUE)f::RcBNQe:khoCQ0Q1<=w'zm{Q1^-Ta
AAz&"
 GRtQ!61p9cw3
-~
j;||G*x74A<!`ww13ٲZb6%5 "E8/AZ$KaMcFX@N)TOd{l<eJE@O	FGTK*|?K]ù>%cxjV`|"I^
\$[Y8d{g)T>pa3zg<c<OW/@SC'MVX	K'΍,O?+:',&%m~7[xUߺEw?n*\l5r=d/N",»:S}IZ#%kjRl7/b}m9P<SIia[ήv醙;-19w/ja-EuO*iH%e"|l< ia@rgIx4f9g3W%zA`|/^w9jp?
 n\,bؙfKЖe%AVLEF`Nn{dGE	NB"9`>C^q">zih>r>5;r4dE+:<u||\,W4YeZNU;Z&%D22_6
\;F8X~ZqNT|[U@X[,,,xf>? qC	Ml70s p]g{-m1< g3}ta$|	)}!}3t_˪l4aۺ'4JLp?lrx31tjYk&glw k|4 c!!"+evHbQl]zhe4\C[,<GmK\)<`F/HB4_|3L
wZTM_O[*' brAw9oSEM2,QK/5eSe^v*'\,\N5R
qMz}2wMHt<S8<g5 .5K.M-q"uFX#nVQap`V]KL@x}f ^5?!k5$h%'e)E0Q k95^":J
G]\ZySP6g*m]j_[ppSɆ-U,(gTɦWvˍ|pt1,'ned@i
o~~E,7|ycP~A(q_YY)F2<[!`(MPbAD[WZkʥS+)n+7]uVE]iNeaLOa30>S5ff"j
xyyC2okM	&~1ygg' ix]EVHFBUYydHwi,qx$yzB?vZ`
ݟb~>L9{.K^T14uq!JhN]uqz5v(:\~9jzMP$q>h
^6@!։%p?oowBcx:C@oIs
H*
Y3Lp
/ws]/@ըW!MJ2T3|&vP9"_A;q#;W`+T_R S#Pq-#/+1	hlve3Ib}dW
0}k'ryYOZJ `B8^tY,%q)|ny>Zrt}&/;q"PE(Ns&^
{/?MXdpM)Ķ1ye0sh,$({,zg>,rn';Yku+÷&,6{,9OH;~C62x|.)M0fS>~+L^}[^GC_{*/qc= X*Qg;DkF)4E!XZ_(9P75<2I]
J4y'
DQ|^xn`OPm^EdM
`$'D[FDCge%]W6CDk
Lfji+| Af%O:Fk|>:Fvebj7CmTb0c6~wMKIVM5SMjBK5Hǭ}:xb/8II8rPlZVq$xtr`Quw
a=}د$|m#MI)kVB&ie=T%		DTsumA# iDmv͜Q&7j{^:cBxtq46K45AU8d͖/|bEb4|8=rGXO)		*]aEKGu\:+ylski=u}v-gfNZ}D{<I$<sT
d\ bd44Oia2l#y|fie-99ᤜǠٹUvBX>J@[
kR
dQ^  6k*yo9
.g^
qk6YwM3f{vh0Q&|oJ9;(KniU&/w(e/13:QGSR
~\\OC5I~vU`,dxeQ	Np{Jbs8Sh6D 35!(nT
pK0E_`Tϯ~I&)t5L]Ef<lg4cI([@JWxա$z%5~ ^Fi+Sn13"_oP'`/eY V7]6n.l)tf3i|2	.(`ne/ybqbh_sM"s hxo\Dp2K}+x*ypdw?g)Ya8Z:`B-@h,cPYH}	T%eG)CX
U,}ttvwh]@ M"S`:+nR)` #0w+,?dH(z`#=|j59!nf>%*" ܨ(Ac_IL~GPT
7mIV@

5)h50YGMZteKm O8R_xl}ukiFUm/kYFQ\A.^)OPZJiN?(X#0AX5`i|#C,@UW"yvjY{o]sc5cu=rf<!fo=xfuwo)L 8,WP#,mA ?s_Obwr""p`h"C:<|M/opw=tm(hUHgm0w 6b;taYA>a
|:P,]{w\i&H
MGVA\=9
`$%̓L@wTOrl8M3N>0ڔRvs	Kχ^ӟQ\ęnCmn@vpK%-rTd	SX
2bD gr%:}|g(*VW>]A]@tl"b%ǘq#$$o,J%k@n~8@)IB$!8|Y,}+oKNW.;u7ŢiPjSW05R@
Ev;T|Arrj(bu2q<Fǩmi!RE.tI)K?6PO)qEO.3Y%Z;
;=QɊ<U{7'LB'wZ8JM;dR`3<;*F)%55	aU`!{wsp=n
d;QS.|_jbu:drs(3"Lñ^NQXt uY!w7v#!j!CTel62d|]bΙ (6ix~{973ABnlqbxavgc#f6Q̤G~K1 ex']i($+?bPeAbqzv#1a/)bj2o9N!.a1CVef,Ku	4ho;fjo
`2O@.VtJ	*~Bx KIOſ*[=|Oĳ5o=nYK6-:M|
ijс.?7c"Vd;0ƥf)OPTPd3U3C@ja&>j%.J'h.NX?xs.gv 	,>Aq|/oT|vK8W^,HQHD\
~s{J9UMyHP5(UBT
~#WMHB94O!*%/z@^2(9	U?K#L@~&4_0?uoJ1O/V(=	X.+pn#}s5<cF5mjYJE5S		}~B{~1%@ut1ppy8g#T6 {z=?ewi,_O9Pfk+k{x$ Wb&y	8QxSDt ujP	tf_tav8nP]$NO5K0!LIP\.>=;-K2,48\cpO2Y6)h;Ce5dw=rJY.n,sSdx&&5w8Fpwye:m.t8iXzu%94ua#}F{ȍ-/`"jHcA^%kHcbBdpqKC*Z|^2f$q	UsbOEh#ZW47S~I\x.1dq,"8Q7DXGrqs&                                                                                                                                                                                                                                                                            )3        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                        3            d buffer length invalid download operation argument download address is out of range download checksum failure no data in device output mailbox data from device truncated device set invalid data length device failed to respond device does not operate properly invalid format for download file header   X.25 Z
 $[
 ,       $[
     	       / t   gateway server  tZ
 $[
 H
                    /
 invalid server request type invalid X.25 packet type permanent virtual circuit lcn is out of range permanent virtual circuit in use permanent virtual circuit lcn is not a permanent vc channel is  not a switched virtual circuit virtual circuit already open on this channel virtual circuit is not open on this channel an offer is already pending on this channel no more switched virtual circuits available invalid IOCTL request   X.25 Z
 $[
 Z       $[
     	       / |   library 0Z
 tZ
 $[
 H
                    /
 invalid "sysnames" file format X.25 system name not found in "sysnames" file X.25 address not found in "sysnames" file packet buffer too small invalid X.25 packet header invalid X.25 source address invalid X.25 source address length invalid X.25 destination address invalid X.25 destination address length invalid X.25 call request facilities field invalid X.25 call request facilities length invalid X.25 call request user data length X.25 call request cleared X.25 protocol error unexpected reply from gateway server buffer is too large invalid call request data format option no X.25 receive data no room for X.25 transmit data X.25 call request not valid now or has bad format   X.25 Z
 $[
         $[
     	       /    emulate terminal Z
 $[
 H
                    /
 unknown X.3 parameter invalid value for X.3 parameter   X.25 Z
 $[
 A       $[
     	       /    file transfer 
 tZ
 $[
 H
                    /
 incorrect operation of protocol unexpected reply from file server file buffer to large for packet amount of data sent exceeds size of target file could not rename target file target file already exists end of file encountered bad file name bad command line transmitted to file server wild card translation resulted in no names all translated wild card names delivered wild card name store full in file server clear packet received from x.25 unexpected reply from x.25 packet to small to transmit command line blank or null command line error in command line translation (file server) disagreement on buffer sizes for file xfer check sum error on file xfer remote domain x.25 file server not running remote domain x.25 host not available connection cleared in idle state file transfer aborted protocol error - x.25 reset packet received protocol error - x.25 interrupt packet received protocol error - x.25 diagnostic packet received procotol error detected by server   TCP/IP  $[
        $[
     	       /    gateway server  tZ
 $[
 H
                    /
 status available (not an error) network not available too many connections no free network buffers bad net open mode bad local address, port, link, or protocol destination dead raw message send failed read or write on closed connection destination refused destination unreachable destination not responding (timeout) end of file (foreign peer closed) invalid request unknown error   TCP/IP  $[
        $[
     	       /    library 0Z
 tZ
 $[
 H
                    /
 unexpected reply from server no data available no room for data bad ec key TCP/IP server is not running cannot get space for handle control mailbox not found data mailbox not found no more connections possible illegal TCP/IP handle operation attempted on unopened connection   	DOMAIN Diagnostics     $[
     	       /    Final Acceptance Test 
 H
                    /
 Test run aborted Error reported by remote process All test processes have terminated Remote process is hung or unexpectedly awaiting data Controlled channel timed-out or is hung Unexpected or out-of-sequence response from controlled process Configuration Verifier failed Network failure or net error limit exceeded Unable to invoke program via SPM   
VT100 emulator       $[
     	       /    library 0Z
 tZ
 $[
 H
                    /
 unrecognized option bad ec key end of file window is too small stream is not connected to a VT100 emulator no more resources available already initialized import failed no pty no server   socket manager       $[
     	       /    manager 0Z
 tZ
 $[
 H
                    /
 bad ec key address family not supported socket is not connected no data available end of file object on this stream is not a socket destination address required message too large protocol type is wrong for this socket protocol not supported socket type not supported operation not supported protocol familly not supported requested address already in use requested address not available socket is already connected message will not fit insufficient resources to create socket export/import buffer too small cannot send after socket shutdown no completed connections invalid request connection reset by peer no readers on socket connection refused by peer   	pty manager U       $[
     	       /    manager 0Z
 tZ
 $[
 H
                    /
 illegal operation no data available no active slaves no active controllers controller already has pty open bad ec key object on stream is not a pty end of file not enough room for data  
dialog  $[
         $[
     	       /    interaction manager $[
 H
                    /
 Warning: ENUM has no choices Warning: task is in error Warning: unable to load default font file Warning: unable to load font file Warning: verification key mismatch  Library not compatible with interface description Dialog not initialized Nested event wait Invalid task identifier Wrong task type for operation Window refresh in progress Value out of range Invalid file type Dialog already initialized Invalid interface (dpd) identifier No tasks are accessible by the user Number of choices exceeds internal limits Bad heap format or reuse of heap   object based systems    $[
     	       /    trait manager 
 tZ
 $[
 H
                    /
 too many trait declarations no available rws storage unsupported trait pm level too high mark/release broken trait not supported for local objects trait not supported for near remote objects trait not supported for wicked far-away objects   object based systems    $[
     	       /    type manager Z
 tZ
 $[
 H
                    /
 type not found type manager for type not found type already exists type manager already exists types file not found type manager directory not found types file has invalid format volume for the object is not mounted un-named trait trait name is already in use type does not have trait-specific managers types file needs reformatting to use split traits types file has later version (not reformatted) duplicate UID   DOMAIN/RDMS         $[
     	       /    gdslib  0Z
 tZ
 $[
 H
                    /
 unused   Communications Gateway  $[
     	       /    CMP   0Z
 tZ
 $[
 H
                    /
 no controller attached invalid un                                                                                                                                                                                                                                                                           w        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                                    it number bad buffer pointer bad buffer length invalid control operation attempted bad event count key bad command length invalid download operation invalid download address bad checksum no data currently available data truncated bad device data length controller timed out controller error cmp already initialized timed out out of address space event not for you your application may not perform a reset channel in use process is not yours invalid call cmp not yet initialized error deallocating space tried to re-download controller (with same file) tried to re-download controller (with different file) board process is dead. No sends allowed.   Communications Gateway  $[
     	       /    comm_driver 0Z
 tZ
 $[
 H
                    /
 no controller attached bad unit number bad process number bad buffer length invalid control operation was attempted invalid event count key board has dumped memory invalid download operation bad download address bad checksum no data currently available error mapping multibus memory no iopb available controller timed out controller error non-fatal process error board process experienced a fatal error controller experienced a fatal error  Communications Gateway  $[
     	       /    Serial Controller 
 $[
 H
                    /
 controller is not installed invalid device number invalid logical unit number invalid channel number invalid device type -- NULL is not allowed invalid device type -- type string is too long invalid unit -- not initialized channel is not open to any process channel type is not as requested channel is in use channel is already open channel is already closed another process reserved access for too long incoming data checksum failure no resources available on this channel no received data available on this channel operation failed in an unspecified way serial controller is not responding download failed download module is too large (limit is 64K bytes) download resource was in use for too long a time buffer is too long                                                                                                                                                                                                                                          SCAT Power-Up Tests Passed EPROM 0 Memory Checksum Test failed EPROM 1 Memory Checksum Test failed DRAM MEMORY Stack Test failed DRAM MEMORY March Test failed DRAM MEMORY Ripple/Page Test failed 80186 PIC Internal Test failed 80186 PIT Internal Test failed 80186 DMA Internal Test failed 8259 INTERRUPT Controller Test failed 8254 Programmable Timer Test failed 8237 DMA Controller  0 Test failed 8237 DMA Controller  1 Test failed 8530 SCC  0 (Channel 1&2) Test failed 8530 SCC  1 (Channel 3&4) Test failed SCAT Power-Up Initializations failed Serial Ch 1 Loopback Test failed Serial Ch 2 Loopback Test failed SCAT Illegal Power-On Status Code   SNA tZ
 $[
        $[
     	       /    api3770 0Z
 tZ
 $[
 H
                    /
 bad handle UIM channel closed no gateway name server file bad name server file length name server file access error UIM open error UIM invoke error UIM mbx not open error opening UIM client channel channel eventcount error error closing UIM client channel no UIM response unknown read type error getting response from channel no room in UIM channel request too big error writing to UIM channel   %SNA tZ
 $[
        $[
     	       /    uim3770 0Z
 tZ
 $[
 H
                    /
 reserved timed out waiting for gateway reply gateway closed channel unexpectedly request ignored in this context request too long ambiguous request unknown request invalid request unless gateway opened need manager privileges unexpected non-digit found unknown request argument excess request arguments incomplete request argument duplicate request argument invalid request unless gateway powered on invalid request unless gateway enabled request not allowed in script bad name server record name server pathname unknown gateway channel already opened submit pathnames too long submitted null transparent file pathname no internal heap space priority number required reader number required gateway queue full reader unknown too many files submitted job number required host job number required request requires a host window host job number is too long no job queued with that job number job already assigned to a reader error deleting job from queue no privileges to cancel job pathname required   SNA tZ
 $[
         $[
     	       /    qm3770  0Z
 tZ
 $[
 H
                    /
 error getting config arg error opening config file error getting config record UIM mbx pathname required in config error parsing config record error creating server mailbox error closing config file error getting UIM eventcount error getting timer eventcount duplicate mbx param duplicate error log param error opening error log file mbx pathname arg required error reading from mbx   _SNA tZ
 $[
         $[
     	       /    api_3270 0Z
 tZ
 $[
 H
                    /
 no result invalid length sna_$open() was already called Cannot open configuration file Cannot close configuration file Cannot find LU number and mbx pathname Configuration data not found No reads or writes allowed until sna_$open succeeds Key entered is not defined or allowed bad buffer length  server process does not exist no more channels available channel unexpectedly closed message too big invalid mbx name cannot connect to the controller emulation invalid message from server process                                              Translation table not initialized Translation type was not ascii_to_ebcdic or ebcdic_to_ascii Not at end of keyboard sequence (ASC_TO_EB) Not a CECP message Invalid CECP type Invalid PU Id according to CE Invalid LU Id according to CE PU is in down state, i.e., no PuCb    PU is already open LU already opened Invalid CeCpKindOfData PU is already configured/created LU is already configured/created Bad command in cecpdata cmd byte Insufficient CE resources PU is not open LU is not open no data/status available LU is currently in DISCONnect mode          CECP protocol violation   	access  $[
         $[
     	       /    typemanager 0Z
 tZ
 $[
 H
                    /
 internal fatal error - pending data requests data cache corruption detected invalid type gateway file format bad change attributes - could not close file change attributes failed could not reopen file after attribute change seek key cache corruption detected fatal error (DOMAIN)   access  $[
         $[
     	       / $   vms server 0Z
 tZ
 $[
 H
                    /
 process on host died no such program no such version fatal error (VMS) bad procedure value invalid arguement bad state detected (VMS) protocol error (VMS) insufficient memory (VMS) file specification syntax error  (VMS) Bad or inappropriate device for operation  (VMS) Error in directory name  (VMS) Logical name error (VMS) Error in quoted string (VMS) Error in file type (VMS)   access  $[
         $[
     	       / ,   apollo presentation $[
 H
                    /
 host destination refused host not responding msg send timeout msg receive timeout connection closed by host connection acknowledge timeout connect timeout message too long unknown message type unexpected extra data unexpected msg type on connection                                                                                                                                                                                                                                                                            =        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1
1                                                                                            &                                    acknowledge string too long   access  $[
         $[
     	       / 4   vms presentation Z
 $[
 H
                    /
 login failed (VMS)   access  $[
         $[
     	       / <   protocol 0Z
 tZ
 $[
 H
                    /
 loopback failure protocol error (DOMAIN) bad state detected (DOMAIN)   
DSEE Z
 $[
 |       $[
     	       / D   dseelib 0Z
 tZ
 $[
 H
                    /
 name not found no rights or insufficient rights operation failed unable to parse command string invalid argument network problem internal error detected unable to enter DSEE recursively dseelib session not initialized object already exists bad pathname pathname too long for DSEE pathname component too long for DSEE   $DSEE Z
 $[
 =       $[
     	       / L   History Manager tZ
 $[
 H
                    /
 database is in use by someone else database recovery is required database must be reformatted database contains no schema no D3M server or MBX_HELPER at database node too many clients of D3M server at database node no D3M subsystem seal on database schema or area D3M subsystem installed on node is broken database schema format is obsolete or too new incompatible D3M server at database node database user must be recovered database contains no areas invalid database handle invalid element name element already exists unable to access source file library recovery is required element not found branch already exists version not found unable to create target file line of descent not found line of descent is reserved line of descent merged or obsolete line of descent not reserved line of descent not obsolete delete version range on two lines of descent unable to delete only version on line of descent no versions qualified for deletion versions defining range to be deleted must exist unable to delete main line of descent unable to validate library invalid or nonexistant element id invalid or nonexistant branch id no library is currently set library is not open for reading   DSEE Z
 $[
 _        $[
     	       / T   Streams Manager tZ
 $[
 H
                    /
 DSEE version map corrupted more than one branch has the specified name DSEE library recovery is required attempt to open an undeclared element   DSEE Z
 $[
 r       $[
     	       / \   Configuration Manager 
 H
                    /
 invalid model handle component set sizes are not the same invalid component set size specified invalid component identifier specified the component is not a buildable component the release area pathname already exists invalid component specifier no component as specified specified component is not unique unable to locate the build some components were not exported error encountered in archiving sources used in build error encountered in archiving the system model used in build no model is currently set no system is currently set unable to validate the system model unable to validate the thread unable to set the thread as current specified pathname is not a system area working context was not created under system no thread is currently set no derived objects associated with this build thread does not specify a version unable to construct the translate rule unable to determine the version to use unable to insert BCT or derived objects into pool file was modified during the build unable to set builder node invalid pool identifier specified invalid library identifier specified   Hyperchannel         $[
     	       / d   driver  0Z
 tZ
 $[
 H
                    /
 no controller controller not responding to function request i/o error controller interrupted with no status available bad key passed in call bad size passed in call send failed due to incoming message associated data too large send or receive invalid in this context no messages available for input input parity error transmit failed receiver busy transmitter busy no associated data supplied by sender reply failed adapter message buffer full watchdog timer expired; port reset input message(s) lost due to host delay   Debug 
 $[
         $[
     	       / l   %Main   0Z
 tZ
 $[
 H
                    /
 operation not supported user error internal error   Debug 
 $[
 y       $[
     	       / t   Main Debugger 
 tZ
 $[
 H
                    /
 internal error unable to communicate with user interface   Debug 
 $[
 6        $[
     	       / |   mapping utilities 
 $[
 H
                    /
 file is not an apollo coff object module invalid object module version invalid handle invalid component type invalid section number address is not in a mapped section   Debug 
 $[
 a       $[
     	       /    symbol table access $[
 H
                    /
 obsolete symbol table version can't allocate storage .blocks section not found invalid code segment number   Debug 
 $[
 P        $[
     	       /    User Interface  tZ
 $[
 H
                    /
 internal error unable to communicate with main debugger bad command syntax   Debug 
 $[
        $[
     	       /    Quit Manager Z
 tZ
 $[
 H
                    /
 User Interrupt Detected   Debug 
 $[
        $[
     	       /    cross process stack info H
                    /
 task not found operation illegal for current process operation illegal for specified register specified register value is unavailable can't allocate storage   Debug 
 $[
         $[
     	       /    cross process task info H
                    /
 tasking not enabled task not found   Debug 
 $[
        $[
     	       /    cross process traceback H
                    /
 end of stack invalid handle invalid frame number can't allocate storage requested information not available no process context set no frame context set unknown object module version obsolete symbol table version operation invalid cross-process no fault information available  LU6.2 
 $[
   	     $[
     	       /    Verb Usage 0Z
 tZ
 $[
 H
                    /
 program not attached duplicate attach attempted invalid convid (rsrc unknown)      null struc parm passed attach,rattach: path required attach: (LU) name required attach: type invalid attach: LU unknown attach: LU not available attach: tpn not configured attach,rattach: cfile unauthorized rattach: cnvid required rattach: invalid cnvid for rattach attach, rattach : invalid wait time attach: not enough space attach: process limit reached         alcnv: rlu required alcnv: mode required alcnv: tpn required alcnv: rlu unknown alcnv: mode unknown alcnv: type invalid alcnv: mapped conv n/a alcnv: basic conv n/a alcnv: when invalid alcnv: delayed alc n/a alcnv: immediate alc n/a alcnv: sync invalid alcnv: sync 1 n/a alcnv: PIP n/a alcnv: PIP maxsize exceeded alcnv: sec invalid alcnv: requested security n/a alcnv: bad user format alcnv: bad pass format            cnfrm,cnfrmd: bad sync-level          dalcnv: type invalid          prprcv: type invalid prprcv: lock invalid         rcvwt,pstrct: fill invalid negative length is invalid         snddta: invalid LL snddta: invalid LL - PS hdr         snderr: type invali                                                                                                                                                                                                                                                                           n6        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;11                                                                                             &                                    d snderr: SE_ALC reserved for tpi snderr, dalcnv: error log n/a        waitcv: count <0 invalid waitcv: invalid cnvid on list waitcv: listed cnv not posting waitcv: no posting conversations waitcv: list required with count waitcv: list too large                                                                                                                                                                               not authorized to CNOS verb Limits Requested in CNOS verb invalid Srv Mgr Mode not initialized before CNOS verb        session limit of 0 is not valid invalid value for responsible parameter c_maxs must be greater than c_minf + c_minb        invalid session identifier                                                                                NO - name too long NO - line required NO - lu required NO - pu required NO actsta - invalid dial      NO - rspque must be NULL                                                                                                                                                                                                                                                                                                                                                                                                                                                        schd is not active          schd has crashed          Time out - Request not recovered          Time out - Request recovered          Time out - Msgq full          logic error - sent to VI by PS Duplicate TPI   LU6.2 
 $[
         $[
     	       /    Basic Conversation State H
                    /
 Conversation State error Logical Record state error conv for waitcv not S2_RECV   LU6.2 
 $[
         $[
     	       /    Basic Conversation Allocation 
                    /
 TP not available - no retry TP not available - retry Conversation type mismatch PIP data not supported Error in PIP specification Error in Security Information Program does not support sync TP not recognized Allocation Failure - no retry Allocation Failure - Retry session not immediately available local resource allocation failure cannot authorize security access         allocation rejected by RM   
LU6.2 
 $[
         $[
     	       /    Basic Conversation Program H
                    /
 Program Error - No Truncation Program Error - LL Truncated Program Error - Purging        Service Error - No truncation Service Error - LL Truncated Service Error - Purging    LU6.2 
 $[
          $[
     	       /    Basic Conversation Deallocated                     /
 Deallocate - Normal Deallocate - Abend Program Deallocate - Abend Service Deallcoate - Abend Timer Resource Failure  ? VLU6.2 
 $[
        $[
     	       /    Control Operator Verb 
 H
                    /
 Limits are not zero Requested limits exceed configuration Minimums exceed max. session Invalid SNASVCMG limits SNASVCMG mode not initialized Mode limits are closed CHGSL not valid SNASVCMG mode cannot be reset CNOS race at remote - they won Partner does not recognise mode CNOS is in process locally CNOS allocation error CNOS resource failure Session activation resource failure          CNOS function terminated abnormally   LU6.2 
 $[
 E       $[
     	       /    Node Operator Verb  $[
 H
                    /
 NO verb failure node operator verb not recognized attach of type AT_NODE       link name not recognized adjacent link station not recognized physical unit not recognized earlier request still active dial in or dial out required logical unit name not recognized message queue name not recognized message queue not enabled no message in message queue                                                                                  actpu failure          actlu failure          dctpu failure          dctlu failure          chgmsgq failure          dspmsgq failure                                        rtvnmsg failure   LU6.2 
 $[
 3        $[
     	       /    Configuration Error $[
 H
                    /
 NO verb failure node operator verb not recognized attach of type AT_NODE       link name not recognized adjacent link station not recognized physical unit not recognized earlier request still active dial in or dial out required logical unit name not recognized message queue name not recognized message queue not enabled no message in message queue                                                                                  actpu failure          actlu failure          dctpu failure          dctlu failure          chgmsgq failure          dspmsgq failure                                        rtvnmsg failure   network computing system [
     	       /    RPC runtime 0Z
 tZ
 $[
 H
                    /
 communications failure operation number out of range unknown interface can't create socket can't bind socket wrong boot time too many interfaces defined not in call you crashed no port specified in sockaddr or interface specification protocol error too many sockets allocated invalid interface re-register can't recv bad packet no location in handle address in use   network computing system [
     	       /    locating broker tZ
 $[
 H
                    /
 database format out of date database in use in an incompatible manner no matching entry available unable to complete registration operation can't access database can't reach location server bad entry   0network computing system [
     	       /    DRM   0Z
 tZ
 $[
 H
                    /
 incorrect software or database version resource locked resource not available data file full propagation file full replica unconfigured replica uninitialized replica deleted replica closed replica reset program error replica already exists replica not found too many replicas bad replica address bad remote replica state earlier timestamp clocks skewed no such entry entry not found entry already exists bad entry length bad entry bad record number object already open too many objects opened object not open bad argument create failed file io error too many keys object already exists bad protocol family               no default replica specified   network computing system [
     	       /    Registry Server tZ
 $[
 H
                    /
 Operation not yet implemented Operation not supported on specified domain Entry already exists Name already exists Unix id changed or incorrect Entry is an alias No more matching entries Entry not found Registry server unavailable Person is not a member of specified group Person is not a member of specified org Person is not a member of specified group and org Incomplete account name Password incorrect User not authorized to perform operation Registry is read only or operation performed at a slave PGO alias entry has invalid owner Invalid data - record too long   network computing system [
     	       /    Registry Server Replication H
                    /
 Program error Invalid database version Unable to create database Unable to open database Unable to read database Unable to save database Unable to rename database Master registry site not found Registry site is the master Registry site is a slave Update is not from master Replica is in a bad state Replica name is unavailable Replica has ba                                                                                                                                                                                                                                                                           F
2}        RPC010.B                       ?	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.DAT;1;1                                                                                            &                        j            d address Replica is in the deleted state Database is locked Clocks are skewed Update arrived out of sequence Initialization partner unavailable   network computing system [
     	       /    RPROC   0Z
 tZ
 $[
 H
                    /
 Can't run specified program Can't create a new process for program Server internal error Too many arguments specified Server won't create a process Server can't change identity of new process   network computing system [
     	       / $   Kerberos 0Z
 tZ
 $[
 H
                    /
 Principal expired Service expired Authentication expired Unknown protocol version number Principal: Incorrect master key version Service: Incorrect master key version Bad byte order Principal unknown Principal not unique Principal has null key          Permission Denied Can't read ticket file Can't find ticket    Ticket granting ticket expired     Can't decode authenticator Ticket expired Ticket issue date too far in the future Repeat request Ticket for wrong server Request inconsistent Time is out of bounds Incorrect network address Protocol version mismatch Illegal message type Message integrity error Message duplicate or out of order Unauthorized request        Current password is NULL Current password incorrect  Protocol error  Error returned by KDC Null ticket returned by KDC Retry count exceeded Can't send request    Warning: Not ALL tickets returned Password incorrect Protocol error       Generic error  Don't have ticket granting ticket      No ticket file  Can't access ticket file Can't lock ticket file; try later Bad ticket file format Read ticket file before tf_init Bad Kerberos name format                                                                                                                                                                              Generic kerberos error   network computing system [
     	       / ,   Authentication  tZ
 $[
 H
                    /
 Intruder alert Non-IP address families not supported, sorry Authentication is of wrong type Encryption key is weak Encryption Key parity error   network computing system [
     	       / 4   Location Broker Entry Cache Manager                 /
 Location entry not found Entry handle is no longer valid No more room in cache for entry No servers found Latency period has not expired No socket families found   
network computing system [
     	       / <   data access manager $[
 H
                    /
 invalid key count  invalid record length invalid key length memory allocation failed record not found invalid key number no more entries internal error invalid handle record already exists   
network computing system [
     	       / D   data store manager  $[
 H
                    /
 could not create database file file I/O error could not open database file incompatible format version memory allocation failed attempt to write same block twice specified header size too large no more entries invalid handle invalid pointer    network license server  $[
     	       / L   server  0Z
 tZ
 $[
 H
                    /
 License not found in database NLS license not found in database Past expiration date on license Past expiration date on NLS license Before start date on license Before start date on NLS license Version not found in database NLS license version not found in database Not enough licenses Not enough NLS licenses Not authorized to use product Wait entry deleted Bad I/O Other users are waiting No licenses available No NLS licenses available Still waiting for a license Transaction id did not match Transaction id did not match in nlslib_check Time disparity too large Vendor id not in database Duplicate vendor id Duplicate product record for this vendor No such product for this vendor Could not delete vendor - still has products Database not valid for this server No such vendor Database corrupt Warning: product name changed Vendor "Apollo" can not be deleted Fatal error - check error log Vendor key is incorrect   	network license server  $[
     	       / T   library 0Z
 tZ
 $[
 H
                    /
 nlslib not initialized Not waiting in any queue Not bound to any server Vendor key is incorrect No matching socket families found No servers available for this vendor  Vendor id is invalid Bad parameter Job id is invalid   network license server  $[
     	       / \   tools   0Z
 tZ
 $[
 H
                    /
 Password version or vendor incorrect Password contains invalid characters Incorrect target in password Invalid password - old version Internal error  
tape manager    $     $[
     	       / d   manager 0Z
 tZ
 $[
 H
                    /
 Warning: Drive status has changed Warning: Marginal media detected by device  Non-recoverable parity error Cannot find phyisical tape record Media error detected Tape drive is offline Tape drive device error Tape drive or controller is not ready Tape record too large for buffer, data lost Tape drive timeout Remote tape network error Operation not supported by device or controller   window systems  %     $[
     	       / l   Apollo  0Z
 tZ
 $[
 H
                    /
 display unit number out of range   display screen number out of range         display screen already inited display screen is not a root rectangle time out waiting primary window system server                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ' * [UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1 +  , @	   .     /    4                             - !   0   1    2   3      K  P   W   O     5 	  6 72Γ  7 `KH ϓ  8          9          G #  H  J                           0 D X     0205      (  T0N      h H              }                  
RPC$STCODE                             RPC V1.0A-00   `CT0Γ 05-05                                         
         !          e $              
  {     ?          !        VAXCRTL_001      !        
LIBRTL_001      !       
MTHRTL_001  (stcode) usage: stcode <hex status code>
 %lx (stcode) "%s" does not appear to be a valid hex status code
 %s
  rpc$exe:rpc$stcode.db status %lx status %lx (%s) status %lx (%s/%s) %s (%s/%s)  (rpc) *** FATAL ERROR "%s" at %s\%d ***
 request ping response fault working nocall reject ack quit fack quack BOGUS PACKET TYPE (rpc_$recvfrom) recvfrom failed (rpc_$unpack_hdr) Bad RPC version (%u)
 (rpc_$unpack_hdr) Bad pkt type (%d)
 (rpc_$unpack_hdr) Packet too short; is %u, data len is %u
 (rpc_$sendto) sendto fa                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          w        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1
1                                                                                                                    -             iled pkt->refcnt > 0 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;5 n_tasks < MAX_TASKS DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_UTIL.C;5 %s%s
 	# of remote calls out:	%lu
 	# of remote calls in:	%lu
 	# of pkts sent:	%lu
 		%s	%lu
 	# of pkts rcvd:	%lu
 		%s	%lu
 	# of frag resends:	%lu
 	# of dup frags rcvd:	%lu
   *** Exiting: exception caught by PFM system cleanup handler
*** %s
 Ran out of sockets DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (alloc_socket) Can't create socket, errno=%d
 (alloc_socket) Can't bind socket, errno=%d
 (send_pkt) cannot enable broadcast, status=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (send_pkt) cannot enable broadcast, errno=%d
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (c_recv_pkt) Rcvd callback (ptype=%s)
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (c_recv_pkt) Rcvd packet not for my activity
 (c_recv_pkt) Rcvd packet with bad seq (should be %lu, is %lu; ptype=%s)
 Can't register call DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (ack_replies) Acking [%s, %lu]
 (ack_replies) Can't send ACK, errno=%d
 RPC reply acknowledger DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (await_reply) timeout
 (await_reply) select failed, errno=%d
 (await_reply) timeout (EINTR)
 (await_reply) select returned junk, errno=%d
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (rpc_$sar) can't get encr, status=%08lx
 (rpc_$sar) Anomolous response to request (ptype=%s)
 (rpc_$sar) Starting to ping
 select failed DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (rpc_$sar) Too many pings...signaling
 (rpc_$sar) Anomolous response to ping (ptype=%s)
 select failed DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_CLIENT.C;2 (rpc_$sar) Rcvd "working" during frag send!
 (rpc_$sar) Rcvd "working" pkt; seq=%lu
 (rpc_$sar) Got "fack" for non-large request!
 (rpc_$sar) Got non-frag "response" during frag recv!
    %s, %lu.%u frag in_call_back working in_reply replied idle passive DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 act->state == as_in_reply || act->state == as_replied DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 act->state = as_replied DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (get_activity) Can't allocate slot
 act->state == as_idle DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 act->state == as_passive DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (scan_activities) Freeing passive [%s]
 (scan_activities) Passivating idle [%s]
 (scan_activities) Dropping reply [%s]
 (scan_activities) Retransmitting reply (state=%s) [%s]
 RPC activity scanner (ping_common) Working (ptype=%s) [%s]
 (ping_common) Resending reply (state=%s, ptype=%s, frag=%u) [%s]
 (ping_common) No call (state=%s, ptype=%s) [%s]
 (ping_common) Invalid activity state (state=%s, ptype=%s)
 invalid activity state DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (who_are_you) Doing callback
 (who_are_you) Can't bind to client, st=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (who_are_you) fault, st=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (who_are_you) who_are_you failed, st=%08lx
 (do_request) Unknown interface [%s]
 (do_request) Opnum out of range [%s]
 (do_request) Got inappropriate request (state=%s) [%s]
 (do_request) Invalid state (state=%s) [%s] DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (do_request) couldn't get encr (status=%08lx)
 (do_request) couldn't decrypt pkt (status=%08lx)
 (do_request) Old sequence, previous=%ld [%s]
 (do_request) Protocol error [%s]
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (do_request) Fault while executing request, st=%08lx
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1 (do_ping) No call (no activity for this call) [%s]
 (do_ping) No call (higher numbered ping), ahint=%d, previous=%ld [%s]
 (do_ping) Drop ping [%s]
 (do_ack) No or incorrect ahint in ack, ahint=%d [%s]
 (do_fack) No or incorrect ahint in fack, ahint=%d [%s]
 (do_fack) Anomalous fack, state=%s, prev_seq=%lu [%s]
 (do_quit) No call (no activity for this call) [%s]
 (do_bad_pkt) Bad pkt, ptype=%s [%s]
 (rpc_$int_listen_dispatch) Trash ahint (%u)
 (rpc_$int_listen_dispatch) Trash ihint (%u)
 (rpc_$int_listen_dispatch) Server boot time mismatch
 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_SERVER.C;1  DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1 (use_family) Can't create socket
 (use_family) Can't bind socket, errno=%d
 (rpc_$use_family) Can't getsockname, errno=%d
 (rpc_$use_family) Can't get my netaddr
 (check_for_pkt_common) Rcvd (ptype=%s)
 (listen) Spurious quit_activity fault ignored
 (listen) Exiting, st=%08lx
 (await_pkt) select failed: %d, errno=%d
 which < n_sockets DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1 DUA0:[NCS_VMS.DSSBUILD.NCK_D.LIBNCK_D]RPC_LSN.C;1 RPC packet checker   dds ip ns unspec unspec ip ns dds %s:#%s %s:%s %s:#%s   sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat sys$scratch:last_uuid.dat %08lx%04x.%02x.%02x.%02x.%02x.%02x.%02x.%02x.%02x %8lx%4hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx.%2hx    (socket_inet/set interface broadcast address):  ioctl failed: status = %d
 ioctl failed: status = %x, %x, %x%x
 @(#)stcode.c	2.1     (ultrix)        6/13/89    @(#)error.c	2.1     (ultrix)        6/13/89                                                                                                                                                                                                                                                                                                             %W%   (ultrix)  %G                                                                     v":3    
                                                                          96 @  
  f                                                                                                     7-./%
<=2&?'@Z{[lP}M]\Nk`Kaz^L~no|_myOС ?	????
???????????????????   ??????  ??????????.<(+|&?????????!$*);^-/?????????,%_>??????????`:#@'="?abcdefghi???????jklmnopqr???????~stuvwxyz???[???????????????]??{ABCDEFGHI??????}JKLMNOPQR??????\?STUVWXYZ??????0123456789|?????                                                                                                                                      
        $  )  @(#)rrpc_cstub.c	2.1     (ultrix)        6/13/89                                                                      96 @  
  f   <c  td  i  p   @(#)rrpc_sstub.c	2.1     (ultrix)        6/13/89                                                                      96 @  
  f       \     4r  r  u  4y  @  @(#)conv_cstub.c	2.1     (ultrix)        6/13/89                                                                     v":3    
     y   @(#)conv_sstub.c	2.1     (ultrix)        6/13/89                                                                     v":3    
     (   }  l   %W%     (ultrix)        %G%                 %W%   (ultrix)  %G                                                                          v":3    
                                                                          96 @  
  f                                                                                                                                                                                                                                                                                                                                                                                                                                         i        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;11                                                                                                                                                                                                                                                                                  %W%   (ultrix)  %G                                                                     v":3    
                                                                          96 @  
  f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  	                                                X    %W%   (ultrix)  %G                                                                     v":3    
                                                                          96 @  
  f                                                                                        @(#)socket.c	2.1     (ultrix)        6/13/89            GF                                              @(#)uuid.c	2.1     (ultrix)        6/13/89                                      @(#)vms.c	2.1	VMS/ULTRIX Connection	6/29/89         @(#)socket_inet.c	2.7     (ultrix)        12/21/89 `      4    $      <   $ t     %W%   (ultrix)  %G                                                                                                                                                                                                                                                                                                                                                                      | ΀^[  VѬfl  I  7  ߭ߦ*ЬRݢ,  P$ЬRݢߦ.,  	    ݏd   ߭^(n  Pߦk  P   ^ ޼P`KPPѭ;PЬRPPЬQPPab޼RbRRѭ޼R b <^ˏ   PP޼P `޼P `޼P `ޭR 1
  PbխޭP`  P1ޭP`WޭQޭPaޭPWޭPWޭQޭPޭPWP`VQPaPVPVQPPVѭ1PЏ xPʏ  PPPP 찏 2PP1խ1 ,ݏ   ޭP`  P   1P 2PP@P`U2PP@Q2PP@Pa2PP@PU2PP@P`T2PP@Q2PP@Pa2PP@PT2PP@PT2PP@Q2PP@P2PP@PT2PP@P`2PP@P`2Qʏ Q2PP@P2`Pʏ PQP2PP@P`PP졭PP2PP	խ1}ѭ1P ݭޭP`{  ݏ   XޭP`Y  >XP`S>XQ>XPa>XPSZP`RZQZPaZPRݬ\ݬQխ1ݬ͜ݬ6ˏ  PPPPX
Z1 Xݏ   XޭP`   #P2P@X	PP=  谭걭 \PPP2PP	޼P ``ЬQPP2P@Xa2P@X
޼P `5PP걭 ݏ   XޭP`   1vPޭPݠ   | ^۴Vݏd   ݏd   4ݏd   ߭^(n@ޭRbݬߦݬ  lP4Rb߭ݬߦ!ݬ\  GPRb4߭ݬߦ1ݬ3  4߭ߦDݬ   P| ^	Vݏd    ݏd   Ɛ ݏd   ߦ,޼R^(bno޼Sަ,RRc޼SƐ RRc޼S RRc޼Sߦ,  PRRc޼SƐ   PRRc޼S i  PRRc    ^  z  '  l      ^ݏ]   ݬ  PݬխЬ
PPݭ O    ^5Q2RѬ
ޡoPPЬP@ P  ^ |3  P  ^ 3  P  ^ЬPPPP߬ PP9   ^RЬPPPP PP߭
  ЬPPPPxPPPQ PPPQP<ޭP`ޭQޭPaޭPޭPޭQޭPޭP޼P    ^ЬPJP`ЬPJQЬPJPaЬPJPЬP@P`ЬP@QЬP@PaЬP@PЬP@PЬP@QЬP@PЬP@PЬPLP`ЬPLQЬPLPaЬPLPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬPP`P`ЬPP`QЬPP`PaЬPP`PЬPP`PЬPP`QЬPP`PЬPP`PЬPPP`ЬPPQЬPPPaЬPPPЬP<P`ЬP<QЬP<PaЬP<PЬP<PЬP<QЬP<PЬP<PЬPDP`ЬPDQЬPDPaЬPDPЬPFP`ЬPFQЬPFPaЬPFPЬPHP`ЬPHQЬPHPaЬPHPЬP(P`P`ЬP(P`QЬP(P`PaЬP(P`PЬP(P`PЬP(P`QЬP(P`PЬP(P`PЬP(PP`ЬP(PQЬP(PPaЬP(PPЬP8P`ЬP8QЬP8PaЬP8PЬP8PЬP8QЬP8PЬP8P <  ^
Tھ  UR޼P `߭ЬP  PP PPݬu  Pխe#ā )  ЭP޼PЭ`խЭPhլcЬPNPPխRЭP@G޼SЭP@PàPP PPЭP@PްP`PcխeЏP޼P`PP)޼P`PPġ :eЏPЬPPPPPP<PPP
.ЬPPPPP eЏPЬPPPPxPPPQ PPPQPݬVЬP>JP<`PP   PѭP3 PЬP>JP<`PPݭ ~eЏP°PP°ЬPPPPPP<PPP@¸QaPPaP ^WVЬRRʏRR 똭SP   SЬR>JR<bRRSSЬRޢ@RbլЬS޼R޲ RbNЬRЬRЬRЬRլW RRRݭݭ RRݬ޼RbR޲Rbխ^(n+  ޼RbRRRЬR ݭ RRݬ  Pխ)N  խ,ƬRRƬЬRRRRRR<RRRBƴScRRcRխRRRRRRP< ^ݬ  PխЏ ^(n+  P  ^       ^P      PPPP  ^     ^X   PPhPլP   PPݬЭP@  ЭPP` P ^數RЬP>P<`PP"Pݏ  UE    չ  ЬQPPЬP>P<`PPݬ  ^޼P`-P޼Pް P`޼P`n޼PЭ`޼P` ^SЬPPPЭPPPP޼R b޼Rb1 ЬRЭP>JP<`QPQ`޼RЬPЬРbЬRЭP>LP<`PP P虭PPЬRЭPLPP<PPPP޼R bЬQPPЬRЭP>LP<`PPPP޼Rb խ|PЭQЭPTLAխ ޼PЬ`޼PЭ`ЬQPPЬ޼PЭ`ЬQPP*ЭQЭPTLPPЭнխխ"Ь޼R bЬRЬЬQPPЬRЭP>JP<`QQPQ`ЬPРP>TP<`PP1 P޼Rb갭խ[ЭP>TP<`PPPPЭP>TP<`PPPP갭ЭP>TP<`PPQЬPQPPPнխЬP	ЬP޼Q ЬRЬPЬP	PP萭PP < ^ЬRݢ8P޼RbR(P ЭRJR bЭRPSЬRSS޼RbpP޼RbR>RR<bRRRRRR޼RbR>RR<bRRRR޼RbRXݭl  ޼R޲ Rb޼Rb*޼RЭb޼RbЭP ^ｽRpP   P\\  QP<\\L¿ \\ս'Э\ѭн\ lЭQЭ\P\Pl\\ v\\   
  P ^
T
R  4P<PP@¿ P`<PPPPPPP                                                                                                                                                                                                                                                                            ?        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1;1                                                                                                                    Ԧ      !       ϱ2PP@¿ PPH< PPݏ"  ĜĈ   ݴ  < PP@¿ PP PP  , ψPP  P  P ЬЭPPЬ`ЭS g  PQQPQ` ^R   ;<PP@¿ PPѽ PսPP ŕ0         ܳ  P< ^<RĬRRRRRѭRR޼S޼R(P bcЬSЭRR
PЬRRJRbЬSRRЬRLRb
ЬSRRЬR>JR<bRRRRíSЬRCPЬRP2  RRP ^喙SRPRPݬݬ  1 PPVЬQPPЬRPPbRBäaaPP*ЬRPPЬQPPaP@äbbPPVЬQPPЬRPPbRB$aaPP,PЬRPPЬQPPaP@$bbPP  ^ݬݬ   %  | ^Vݏd   ߭^(nMP     @  ݱ    ^Ѭ  Ѭ  Ѭ   PPPPP ^!RѬ   ޼PЏ `+ݏ   jP ЭP @   ЬPЬ@޼P    (^ﵠSﲸR¤ݬL  ¨ݬ7  ¬ݬ"   <PP
G<PP@´P`<PPPPP$ݬ  PP<PP
°.ݬ   <PP
F<PP@¸P`<PPPPPDݬx  PP<PP
NݬQ  gݬ<      ^ǺRPP PP߭߭ݏ   ݭݭݭ 1ݬ
T4  ޼P`<PPPPPЭ䋏QQQPPPQP.QPQPQPQP
޼Pн``QQQӷPPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭ4P| L^V]S]R  PD]]RݢDL  LYY !Xݭ^(Yn  ޼Rb RR<RRSR   SSXXRRݭZP	ͥRR<RRRRRЭܭЬRRíܭRRͥRR߭߭ݏ   ݭݭݭ1ݬ
F2  <RRRRRЭܭSSSRRRSR1 SRSR1 SRSR1 RRRRRR>RbRR౭Џ  T^(Tn5  íܭRRRRR޼RbRR<RRRݭݭu<RRRRíܭRRRRR޼RbRнbRR޼Rнb1PRRSSSRRRSR
>Rb"P>RRЭЭRЭR̢RR౭Џ  P^(Pn@  ޼RbRR<RRխ1 íܭRRRRRSSScRRRSR
н<P޽RRЭЭRЭSЭRЭSЭRЭRĢRRRRRRխ1líܭRRRRRSSSϳRRRSR޼RbRнb=޼RbRRЭ୼ЭRЭSЭRЭSЭRЭRRRSSSbRRRSR
޼Rнb?P޼RbRRЭ୴ЭRЭSЭRЭSЭRЭRݭXݭY]  | ^V%S%R  PD%%RݢD0  !! ! ݭ9^(!n  ޼Rbz RR<zRRSR   SS  RRݭPPmRR<zRRRRRЭܭЬRRíܭRRmRRmqr߭߭ݏ   ݭݭݭ1ݬ
-  <zRRRRRЭܭrSSSwRRRSR1rS\RSR1sSIRSR1RRRRxRR>vRbRRvxЏ  ^(n  ޼RbRR<vRRխ1íܭRRRRR޽RнbRRЭRRRݏ@   ݭݭ@   RRЭRDRbRRíܭRRRRRЭRFRнbRRЭRJRbRRЭRLRbRRЭRNRRЭRORRݭݭ RRȏV   RRRRխ1íܭRRRRR޼RbRнbRR޼Rнb1sPRRrSSSuRRRSR>vRb!>vRRЭ୼ЭRЭRRRvxЏ  ^(n  ޼RbRR<vRRխ1íܭRRRRRrSSSҮRRRSR
޽Rнb<P޽RRЭ୴ЭRЭSЭRЭSЭRЭRRRЭRRR խhrSSSRRRRSR
>Rb"P>RRЭ୬ЭRЭRRRRRRRխrSSSRRRSRЭRDRb#ЭRDRRЭ୤ЭRЭRRRíܭRRRRRrSSSRRRSRЭRFRнb@PЭRFRRЭଡ଼ЭRЭSЭRЭSЭRЭRRRrSSSRRRSRЭRJRb$ЭRJRRЭ୔ЭRЭRRRrSSSﺬRRRSRЭRLRb&PЭRLRRЭୌЭRЭRRRЭRNRRЭRORRխ&RRRRRRխȏV   RRRRխ1íܭRRRRRrSSSRRRSR޼RbRнb=޼RbRRЭୄЭRЭSЭRЭSЭRЭRRRrSSSuRRRSR޼RнbCP޼RbRRЭ||RЭS|RЭS|RЭR|qݭ ݭ!%   ^RPP PP߭߭ݏ   ݭݭݭ1 ݬ
&  ޼P`<PPPPPЭ䋏QQQ[PPPQP.QDPQPQ5PQP
޼Pн``QQQPPPQP
޼Pн`<޼P`PPЭЭPЭQЭPЭQЭPЭPؠݭt    ^ݬs  ޼P` PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R   < x^SR.  PDRݢDzs  zѭ խݭK^(nL   ޼Rb<RRRRRЭSSSRRRSR2ShRSRެRSURSR
ޭRнb]SSS3RRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭRآRRR)P߭ݭݭݬq   RRRRRRЬ$SRѭRRccRR޼RݭPb޼RЬb޼S<RRRcRRЭRRRR԰ԽRRRRRRҰҽRRҭЏ  ~^(~n  íRRRRR޽RR<RRRݭݭ<RRRRíRRRRRЭRRЭRR޼ SíRRcխݭ޼(R b< l^~S~Rx  PD~~RݢDn  nzz  խݭ^(zn
   ޼Rb<RRRRRЭSSSĥRRRSR3SﭥRSRެRSRSRޭRнb^SSSwRRRSR
ޭRнb9ޭRRЭЭRЭSЭRЭSЭRЭR̢RďV   RRiPv߭ݭݭݬma   Rď[   RRRRRЬ$SRѭRRccRR޼RݭLPbP޼RЬb޼S<RRRcRRЭRRRRȰȽRRRRRRưƽRRƭЏ  r^(rn  RR<RRխ1íRRRRRнܽRRЭRRRݏ@   ݭݭ@   RRЭR>DRbRRíRRRRRЭRޢFRbRRЭR>JRbRRЭR>LRbRRЭRNRRЭRORRݭݭCRR܏V   RRRRխ1íRRRRRЭRRvRR޼ SíRRcխݭF޼(R    ^ݬLl  ޼P` PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRR޼ PíRR`޼(R b  | l^wVuSuR%  PDuuRݢDlh  lqq !pݭq^(qn=	  ޼Rb RR<RRSR   SSppRRݭP	ͽRR<RRRRRЭܭ޼RbRRЬR>RbRRЬR>RbRRЬRRRЬR	RRݭݭRRíܭRRRRRЬRRíܭRRͽRR߭߭ݏ   ݭݭݭ 1ݬ
b  <RRRRRЭܭSSS1RRRSRDSRSR0SRSR ޼RbRнbRR޼Rнb1                                                                                                                                                                                                                                                                            ʌX        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1
1                                                                                                                          0       SSSӟRRRSR޼RbRнb=޼RbRRЭЭRЭSЭRЭSЭRЭRТRRSSSfRRRSR
޼Rнb?P޼RbRRЭЭRЭSЭRЭSЭRЭRȢݭpݭqu    ^޼P`<PPPPPЭQQQﭞPPPQP1 QPQP1 ެPQ}PQP1 ޭPн`PPP`PPP`PPPPPPݭݭ,PPíPPPPPޭPн`1QQQߝPPPQP
ޭPн`9ޭPPЭЭPЭQЭPЭQЭPЭPؠPPQQQyPPPQPP`!PPPЭЭPЭPРPPQQQ+PPPQP
P`PPЭЭPЭPȠPPPPPPխ&PPPPPPխíPPPPPQQQPPPQP
ޭPн`<PޭPPЭЭPЭQЭPЭQЭPЭP߭ݭݬ`
   PPЬ$QPѭPPaaPP޼RݭPb
P޼RЬb޼P<RRR`RRЭЭRRЭRR޼ PíRR`޼(R b< ^ЬPPS / _ ; k   G  w w    / P?PbPЏ  VPЏ  JPЏA  >PЏ  2PЏ  &PЏ  PЏ  PЏ  P^(n    ,^i\լ( 	            Ց   ȑ      
        P ,^ўRϬ\\r  Ϛ\\`  ψ\\N  v\\<  d\\*  R\\  @\\  .\\
  \\  
\\А  (     ^ˏPP !  ^QЬխ"޼PС `ЬPСЬ Џ Pѭ Э     ^QѬ ޼PЏ `б  ޼P `  ^uQ޼PС `Ь ޼P     ^P  ^    P  ^ (   P ^)RТP\\P   ^P\\ՠ| ΀^VЦ խ^լ ŏ  MP Oݏd   ߭^(nPݭj    ݏ@ж  զ ЭRRRլ
ЏPЬRRݭЭRՎ  < ^ ^(n(    4^!S2R޼P ` >P<P	P@ PPЭPѠ
ЭPPP<PP@   ݏ4  ߣcI ݬ<  Pխ,՘  ߣH޼PЏ ` P ֍  ݭ  P7}-  ߣvݭ﯀  ޼PЏ ` Pݭm  QPP<QP	P@ PPЭPЭЭP<QPQ P  ^޼P   | ^署V <RR 1 P,ﱕ<R.RBr  P
<RRRRPЬR(<R.RBq  P0ЬS<R.RB+Rѣ@b<T.TЬRޢ@SD+RcbRR<RR 1g1 2S.SЬR((C2T.TЬRޢ@SD+Rcb2T.TЬR>HSD/Rcb2T.TЬRޢ8SD1RcbЬRRR2R.RBRRR2R.RBRbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RR @^}S xt %ݬݬݬЬRݢPc1P_x|c_޼RbЬRea  PЬR>R<bRR)k  _6ﱕ_â ݏ    e P 6  t ݏ  ЬRݢ  Ppp7H  	Yݏ  7  P c f<fRRx1 P<fRRBcPPlOPPhKQ<fRB|P`a<fP@|R>bP`d<dPP7hRhPPhlQlPPlabdPPd<dPPݬKݬЬRݢEcPPcfPPf<fPPx1=ݏ  l cRRP <^{WΖVݬ ݬݬЬRݢPխ P޼RbЬR(#n  PЬRRRRRЬRRRRR1 ^ЬRm  P1  bЬRѢ@ЬR@RRR&PЬRRRRRPǡPݭ޼ RbݬЬRݢJ  ݏN    Pݒ
 PЬRѢ@MЬRѢ@<朗2PЬRRRRR7PЬRݢ@ݬ+ PЬRբ>&ЬSЬRѣ>8Џ ^(nRRRЬRRR޼RbSRbcRb<RR1PЭTRRЭSRRcdRR<RRЏ   P ^uyWV <RR s<RRBS<RRB<SS޼R(bC<RRBRЬb<RRBRЬb<RRBRRPRR<RR ݏ  ǈty ^R <PP SP<PP@0޼P`<PP@?k  P<PP@PPPPP<PP 2  P  ^޼P `ݬwPխ޼PЏ `ЭPРPՠ>ЭPРP>PЬ`PЭPРPѠ>޼PЏ	 `޼QЭPޠP`   ^ݬPխ޼PЏ ` ޼P `ЭPРP< ^ݏP    ݬ  ЬR܍ЬRэЬRƍЬRﻍ޼RbЬRFRbЬRHRbլ
ЬS޼R(bP l^wV   W%\ݏ#  ƽ & <RR 1,P<R.RBRRqi  P1 Pu h  PЭRݢ$uЭR>R<bRR@Pխ1  ϬRЭRޢ*SRcb(ЭR>(SRcbЭRޢ$SRcb  ЭRݭPDgYݭ,(RR<RR 1 P ^uSﲐR  j  #  :2PPoP  ^޼P `ݏ   PP ЭPPЏ`ЭPlP`ЭPZP`ЭPVP`ЭPjP `ЭP  ЭP  լЭPjQjPQ`ݬЭPݬݭ
  P ^Ьݬݬ  ЬЭPZPPЭPVPЬ`<PP/ЭRPPЭQPPabRR<RRЭRjPjRPbݬЭRݢVЭRZW  PЭRjPjRPb޼R    ^ЬЭPѠ1 ЭP>jP<`PʏPP޼PЏ `ЭPZPPЬ޼QЭPޠVP`aЭP>VP`<PP1PЭRPPЭQPPabRR<RRݬݬݬ+  ޼R  < ^Ь޼SЭR(c޼R    ^Ьݬ ЭPVЭPZW  ЭPjQjPQ`ЭP>P `ЭPLP`ЭPNP`޼P     ^ЬݬݬЭPjQjPQ`޼P     ^ݬ޼P<`PPݬP޼P`ݬݬݬݭ޼P`ݭ    P  ^ЬЭP>jP<`PʏPQPQQլЭPjQjPQ`ЭPjQjPQ`޼P `PPP  ^בֿQPլPP   ^Ь޼P `ЭQlPPl>lP<`PPxЭPPЏ`ЭP ЭP ЭPЄ P`PްP`ЭP  ЭP ЭP ЭPЀ P`PްP`ЭP  ݭP  ^Ь޼P `ЭQlPPlЬP< 8^pU :~  PRRR ѺЬ  }  ЬR STЬRz  P{ PQPPRxRRCdRRCd  ЬRRRp  P-~  ݏ  Q 9ЭPP5   	?P1  P.PņDPѭݭŝ  2}  PRRѭ ڇPPPíRR1PǸ2 P< ^ SR|  PDRݢDѭ 1\ ޼R(P bRRRR b  E|  ЬR STЬRz  P{ PQPPRxRRCdRRCd <RR1 ЬR  ݬRݬb  ЬRRRn  Pj߭ݬzݭݏT   ݬݬHP<RRRRR
'RRRRRRRRRRPPRR<RR1; =
P 1 <^mVW ЬЬ ͻ ͺ  ؐ    ͨSRz  PDRݢDpp 1 ݭݭݭݭϢխ6ЭRTRSBc"ݭЭRTRSBcR޲Rb խ խ	ݭͻݬ4ݭͺ
 ﳶ^(n[ЬRޢRbѭ̏)Ь  SRRS`Pѭ̏
 >ݬ4߭ݬ  P޼4Rb޼4R^(bnͻͣ^(ͣnЭЭR>jR<bRʏRRЏ ͟^(͟nѬ                                                                                                                                                                                                                                                                           q6        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;11                                                                                                                     ]      ?        ͛^(͛nh޼$RЭb޼0R b޼(R b޼4R b ͸ݬ4ЭR>ZR<bRRV  P   PPܐ   ЭR>jR<bRʏRSRSSˏRRݬ4ݬKݬ4ЭRݢVЭRZN  PЭRVRR1 ЭRVRRRRRRRbSЭRVRbcЭRVRb<RR.ЭTRRЭSRRcdRR<RR>R<bSЬR<CRRݬ4 N  ,Pݬ4>R<bSЬR<CRRN  RRݏ$   ͺЭR._\  PЭR(.ЭRNRbЬRFЭR-\  PЭS޼RѣBb+ЭSЬR(FЭR޼SBRcbЭRLRbЭR(P ЭR ЭRDRbЭR@RЭbЭRJRbЭR ЭSRRRRRRѬRR
ЭR>jR<bRʏRRЭS`RRRRRRˏRRЭS0RRRRRRˏRRЭS RRЭR ytoЭR .ЭSݬ4ݬЭR ЭRҀ R޲ R޲ RbPÄ ޼4Rb/T޼4RbFe޼4R^(bnЭR ЭR҄ RbRâRRܕ
Џ ͗^(͗nRRRRRݬ4ЭR>R<bRR@P޼4Rb޼4R^(bnFЭRݢ@ݭϹPؕ
RR~  SRR<SRRЏ ͓^(͓n
2ЭR RRݭݭݭϹ蕭15
 ͹1  <SЭR>LR<bRRS~S~RSbЭR>LRbͦ͑ݭ<RRݬݭ!P͑͐<S<RRSR͑ ͐͐RR͒͒͓RR͓ЭR RRݭ͑ݭ硭RRRR͒1dR͑RR͹P Ns  PRRԕ͹	͸	VP	͐P͐͐RR0<RR
RR
<RRRxRRR䡭RRխݭݭsPЭPP  7	?P1խ6ЭRTR={SBc"ݭЭRTR%{SBcR޲Rb ߭#ЭRݢ@ݬ ݭݭݭP -r  PR­RRRR1>P ЭRRRRRPP! - ) M - M M % P&?P.P11A1ͼݭ郞^(ͼnj|&PЭRRRRRPoh13RRѧ  Џ ͌^(͌n1͹1!{PƤ Pݏ  RR<RR<RR3P{P館Џ ͈^(͈n(P 77RR bЭR  ݭ7ݭPVp  1_Pݭ PRRPP  v?P1խ6ЭRTRxSBc"ݭЭRTRxSBcR޲Rb ߭#ЭRݢ@ݬ ݭݭݭoP1 ЭRRRRRPP %  ! % 	?P.P1uvP1ͼݭ\^(ͼnz&PЭRRRRR﫫P+111-ݏK  k](͹/yƠЏ ̈́^(̈́nGyЭRݢ@飯ЭTЭR>HSHRcbЭTЭR>FSFRcb1CP
/Hy`Џ ̀^(̀nЭR>LR<bSSЭR>LR<bRSR1PЭTЭR>LR<bRRRRSLRSb 1pЭR 1;131+ЭRNSЭR҄ R޲ RSbЏ |^(|n0޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bݬ4ЭR@ݭЭR>JR<bSЭRCP޼,R^(bnЭR ЭR҄ RbR޲Rb޼4Rb޼4Rbx^(xnsխ6ЭRTRuSBc"ݭЭRTRuSBcR޲Rb ЭRRʏRROP͸/lw#Џ t^(tn޼(SЭR>JR<bRRc1 P͸ЭR>JR<bRRݭPͧݭͨвݭ!ͧkЭRRʏRRS(P 77R	R bЭR>HSRcb>ʹSRcbЭR  ݭ7ݭ-1fP޼(SͰRbc޼$RͨＴPb޼0RbP-#ݭMޕ  ϶ϲRR  ЬRFЭRcP  P!ЭS޼RѣBbЭTЭR>FSLRcbЭR.+P  PЭTЭR>HSNRcbЭTЭRޢ8S>RcbЭRjSjRSb#RRRЭRVRRRЭRVRbS#Rbc#Rb<RR.ЭTRRЭSRRcdRR<RR޼,SЭRRRRxRRRRR c޼,SЭRRRRcЬ,SЭRRRRЬ,RR bPխ6ЭRTRrSBc"ݭЭRTRrSBcR޲Rb ĕͻ ͻݬ4ݭݭrܐ 4 G =  ^ݬݬݬݬݬݬ   B    ^ݬݬݬݬݬ   	E  < ^ЬRТѭЬѭ
 ^(nc޼R bЭR ЭR ЭRҀ RbR޲RbЭR    < ^ЬRТѭЬѭ
 ^(n޼R bR P< ^ЬRТѭ@޼R bЬЭR ЭR ЭR҄ RbR޲RbЭRЬ 9Pѭ
 ݬݬݬ3,  Џ ^(nI< ^ЬRТѭ޼R bЬЭR P7ѭ
 ݬݬ',  PPЏ ^(n ^Rݬ$K    PPP ^｀RЬP>LP<`PPЬPݠ@ЬP(P_Xg    PPP  ^mQЬP@(P  ^ЬPݬݬЬPJP` ݬ  Q| ^VTDH  T޼R(D < ^ЬRТѽ޼RЏ b P޼SЭR(c޼UЭRТ TЭSgRRg@gRReݬЭRݢ$ЭR(ЭR  R 	PP  ^ݬB ^UR ޼P ` f<Pď`   P@¿ PPЭPW
Э/PЬPFЭPFJ  P޼Pѽ`ЭPPխE<PP ޼PЏ ` PQPP<QPď`   P@¿ PPЭP WP| ^]Vݏp  ߦCݬݬPխ{ЭRW1ЭRVЭRѢXP޼RЏ
 bC0ЭRWЭR V޼R(V bЭRЬXЭR\R bЭS\RR\| ^	]Vݏ  ߦxǠݬݬ2Pխ﷠ЭRW1ЭRVЭRѢXP޼RЏ
 b.ЭRWЭRV޼R(V bЭRЬXЭR \ﴨP޼R(bЭRЬЭSЭRТ\ЭRЭ\ 
 ^|R X<Pď`   P@¿ PPЭPW)޼P`ЭPF0H  Pѽ<PPPPPЏ  PP ^[RF|S޼P `ݏ  ­ P޼P`ЬPF@P6޼PЏ `<Pď`   P@ÿ PPЭPV$ЭQ\PP\>\P<`PPЭP WPޞ  ^լ2P޼P`޼P`+G  P	ЬPРPЬPРլ2  P| ^U{V<RR@   ޼RЏ bSRR<SR RBƿRR޼R(bЭS޼R(b޼R b| ^zV޼Rb"jF  P޼R(jbЏ   P PP<R RBƿRR޼Rb9F  P޼SЭR(cЏ   PRR޼R(ib2  P  ^ЬPՠ<ЬPݠ<KЬP <޼P   ^kYSЬP<PP޼P`
޼P`P!Pݏ   `   e`  ЬP>(P<`PP>  P   PPЬPՠpЬPްpP`PàPPЭPѠbЬP``"Pݏ  eM`   _  нRЭP>QJPa`ЬPݠpЬP$ݽݬSЭP>P` ЬPk	P癭PPݭ<PPЭPݠݽP<Q<PPQP	 琭PP항PPЬPݠpЬP$ݬ諸PPPP1j޼P`  ^ЬPf P ^1xS <RR   jP<P@F޼Rb<P@PC  P&<P@R i^  PQPQ`<PPPPP<PP   Џ  P ^VWwVЬRHЬRHBЬR>HR<bRB0ЬR(ЬR>HR<bRBRB  P<RRPЬR(P챭<RRP <RR   SP<RBDP<RBRb<RBRb<RRRRRR<RR   <RR   JǚЏ  P,2RBRb2RR]2RR!<Rݏt   PЭBЭSЬR((ЭRЏЭR <ЭRЬ8ЭR FЭR fЭTЬRRʏRSRSSkЭR lЭR pЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR1PЭTRRЭSRRcdRR<RRЭR [  PSRSb<RRP ^9uR<P@<P @ ^]TVuW<RBѽ!Pݏv  ƾ[   a[  <RgPЭBЭSЭR(ЭSЭRТЭR                                                                                                                                                                                                                                                                              2                                                                                       1                                                                                                                                WC-zШmf;FU\A$Mƻ'B&Du툔N!BIcpE![ݗ$I~VmUmRxjovQ04^M/~s+;cy<_X]TނMgԺ!QC$Gn˜qŦ/,xĆ!hUx_5fۏ'8ohS% tjl6:T	u
RO+54$-},5E&L>bN#[ocqwO^"S+@.8BuhQFqNPuPWעE֋jW4,^Oۄ	pq޸%V	<$]5Dܒ"yА1bᑊ
 {̳{u{cf)x^
dOR\4NpT)RK:pO+Ό"s6=q"-U>-y3k8[WYG7L=
} aӑƴ/xtBzAkhǑȏD0ʛP:	\U0D첸h2oqU;A]ײ8Q/wE~()Q`9A;GԷe&08+׬A0ց6S`(xNBIGcfPkEVPs"nv.ѺLl-b}C>b26$}eNVm
uceQN\h|K+G)%:} 2`gE`
dіM=y)}4Kp?!JAa5Ĩ
Qsg~]:ڸcqz,"N	@$Kʪ?nvv93[Ftߗﾇ/0棎dNxBcl@;{ܜ)LvQتZ1D[n0δISPFa8DayxdLm*W}ȭSZƇMV4,c7},/sE  R9!>EM$~	dRפ6?/)Y 
D8S @pL8
&esμlc{2^qcy`Q
{)vK]_ɋ<ȓ`iZD}Zjf!3L*t6F`leX'Dy*CY`F쇠id&*S;?R#uFATWnx'zڎ"H+ꤰX	NwkγXpNx;@%i[79)jd31XW ^1EX8xQ#mYdDw-z':	tfGK|@gCCcȠ)dI@{{kSC5st
Ie(oBR	u`BD4fޤ\Mҧ3Ԟ&X=ށnFql\]@nS1kt_sw
hfd́%X"#a
MBLֲ0sw6|
̎o-O2XZ#zUjPqOdDig=a
\n/z+耓ƛ_5@PC|#*	  SE
40|[ǆ`SHuk{+my]ԑ|D^>i/:|BaK
"L. y۫c @dE)El32/S]
TĪ"gQxBq޹u=ٮuKMa[6358b|\oOe[YG'VI%"Z$ O"[U<`F&VeA#8%O`tYmW`qv
fJ:M Cc+@!gJ
<K̪.٢5_q9<X6|.MxmsG5d4٤ԅЪ̐KiPJ(<S~US$"Axԍ2kg%R51/	>8Ov4Gg{(y^ۘ=yKCLyR`r歂KyuY!GΑ>4\CPU;cfFon*UVоZ9Ѻ9qH4m2]z"Ҹpe醛zOg2Z۔;kq-V,ɤ)",m15'[RYQ'隻&zHT^8в=b6+*3VUdQGRm*k eσ,W̛lgv1"0&c?M5c<DkR NmN,6R\O3vĬodq@ iO|zI54n<<&2KS^n`wh=/ov1>nv>}VZUE-^(7Մ\ 3_فȋ=x{p1zZX-2SL24w6#|Thĺ W%M\`i YB#ܯUFWŠșJ^jqʉ0,!ˤ<Zu3qK-(>xĂng`4bkG9t
6]^ V(Ӿ*hH:=Ҫ枱_wm5_`=me	U_tx9X^׶/0NyzH6w!כҸ>HXePOs_sPY?&oqcײeVCFpR1}62BX {RJ7R]i|Lp:pGDc&1/*\v{faom$vZq:nd.k-¡JB*Fpn]'skGZWA55>Z1
ӟ:3Q֡xނf%IG&!@[0r\=u`#'n)d"Xuč8
!M:Bg!N}~B4.WKl\'V>_OS.t?!	
(!R3zNm{s|b)=SiY}K	roMz |I,HsH[r*_>;/wwckWOш9B;'Y3TMRDWCbBC#&X]iⅼtQ9KY֒r{Trs+|MGf~bEj)H[rzUW6̆py+ YX˷д"Ζ'[Q-M
Alf
#{T*@7+ß{_?.λL}$]}dKOD puZoGtŗ[VJs=WZ%`/{aN&wlT ѳ=w$ܧSapjy}+ج4aCL21 "V3[FY3!/nc~Kc #C&'Կn.. f['FZE,}H5Wx
"!Y`S*7V2@73 HS}.fi8eg+>'\~[Ï$_8_g]&}SWMCmxl8j&{Kp)1wM)U3tywwfgZS1nWt;r)a,r3~g^k+|$ QH@,4lb5p]js|-~3j@5,_XWU#gq !QȤ	=rZLP#`
PB׶ RAi;?<zD14_P ,׭&QdÂ+Ri~ME0!J 8)qP8)G-%2-fG&Zow˻Q\9o2wx(X~כ!l-NY`e+bvWԆܜƅn
}Ű"3Y·p%^Ť	Yz,JRkt#2Y^o(y?
R (:co~hp.b|YlKުHCу htT{4q\k1+>$OR.
7)"ǂuxXU-#p۷Ul;y􍄝HC"-	I s$
}-Vx;g"-fCsgd&y_/,;IX6zL_O~B)t^;q'DaFT`q.!^u14M)2H)??~8zɮ oupaRDc'%.4jy|Egۯh8ebZǼ)eȅt]ط*.AM31Og)P5?.twVU
`݄uwpnxN^X}kQؽI^98=.'YbU\	ÖgدjϿ"`d.P-xpCnsx'2y:܆uSSo9Hy:ůg;[>4M7m!e͎	a))</'+#9Ej(`(vK翂44fv-XMV7O'@r
E}@umF؞vb`Ȭ	D
~/XdNŧ_H
OGreYqph#qx!hTf)]aq=	&zߒ ϩIC;Nj:/R-p+]-Ec+v̲D=.}!g}f[$)#&e3ΚZFEu*8dYyQ?Jw`RW8ׄ6n첪{GS=*&4d"*2ѹ~|Y=f.`97^I2]=DFpk!~x
A$HO
\I[5DR{Pj^=BN@ƹhsexcrLI5ݫg8a<{+&@{_~K(]bO'p
IpTE]@8T
Zxb/ȥ˶gKvcJeh|cMjPoG$Piۂ)Tx!6%:	,EOC炪Tr/ngkjx	UXU{  AhC1BshH0i?v~ѝё?=tvq۟LQ'IOpJhtQY^-q<GUn~r<E!sHpJ
!W.W cFKbKȂR(EH9tzOCLHQ;24W3"I6떍4+w{BgcrX5ZoB|6rahh +mJJhK]_r 
[3aQ@olJ/4㲈ة4I$ȵܘW08-W]i]פ;5 hi*B0ޛ;݋THd2>`c}PTaj~tFTۆv{&'	pf3~c EӃ) âQv'%B5"b̨]&^}dco)h5=]E%6;enRyJIOT䐻3pګŖ7d2Ec
?;nxAk8 {HK	`&  7ٝW-uH)eMs.~O:  ^ԧ}*kE;~g+⚣b*>-$FЁ:b5pYxu(&)Y_GjlEua٤ϱ"w!H_I[iǦɹTzPߺeѥN/_lma7>!k"8wmbFjǆ^gwGY~yMrNoE>3*kE~M+8gr\V *,?zA{3i(
LM]w5ͱO[ɱ㜌sm'+n!cA*[Dy9zvEfgl:7<:eIѧ^qة#__P_%{L2cdL c1;?n얈]z^Ϲ#kVfT9YBfzmC#~ze-KRՅY~ҍ@?< pM1oZUԾ	{](/ }V2ء/O\vݑ|zHz& IYe re6!l±.e:7ݚ" Oz=	I͈xwy8 `<YWFPG4U)s,{+;;$7N0QN@[ViW|3%/(>3:AE?
~WROvX0Ψ!1vqM8'Z~L(ykIQ%R͘+V@E6<HdS[N=yr4ALNRs9ɐO>NC
H{g5
?Mvްѯ0SrkG%a6D	UqI@1{ 교 <|@eS ߦ+!ܳmn=_zH{1~g<Ǣ'>@PXJ<
+Y~O*82P^&uH֫q_\;ڞ3P@-7̓E,7kR*=]Ȁ6@՚JtBI%$E{g)K*"jr </	@cD'Q-!mIMs2.Qfqs*.538-Ym<M`oa'ќHOgukh;L$[#nD?+K(O!@(jqyX}D,pH\u
FiF-b'G#GЁ?tPQI@([:&St_'x0=MԻYQo.k`^z
`hY	fuAM}`C\QcTc<GC1h8Nn	rxToS<pQ¸=c2)(oOsOGdyڜ ҍnE.VT^                                                                                                                                                                                                                                                                           <        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1;1                                                                                                                          N        [  PSRSbЭRբpЭRݢpЭR޲pRbR޲RbЭR pЭRբlЭRݢlЭR޲lRbR޲RbЭR l $^aSVtW<RBѽ!Pݏ  "	Z   eZ  <Rݏt   gPЭBݏt    ݭZ  ЭSЭR(ЭSЭRТЭRЬ8ЭR lЭR pЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR/ЭTRRЭSRRcdRR<RRЭR xY  PSRSbݭ﷞P  ^RSrRݏ  Wϕ )Y  P\\ <\\   1[P<\Lխ1-Э\ì\\\\нPP  W  	R?P1 ,4vcPЭ\+PÌ|<\\ϼ1 -28cЭ\Pô@<\\ϰ1 2bЭ\ݬ<Pݭ7Fb*PЭ\ݬ<ϧPݽPēݭЭ\ݬ8\\<\\   1U ^ePR<4\\ ^APR޼QaPP  i     	?P1Mb2PݬPЬPPPPPPQЬPЬPJP ` ݬݬݬ1/aOPݬPЬP>DP<`PPЬPPPPPP޼P`ϚPxsݬݬ1 P2aAPݬPЬPPPPPﳒP޼P`<PºЬPЬPJP ` ݬݬݬ﬙MPЬPPPPPSP޼P`PﵑݏL  =&ɑ ^ЬЭPРЭPѠ
 kѽeЭP(PPЬ޼QЭPޠ$P`aЭP>$P`<PP/ЭRPPЭQPPabRR<RR޼R b< ^MUnT_PrܐݬЬPݠ$ЬP(]P޼Rb%_޼RbŐ޼Rb޼Rb޼Rb8޼SRPqT  PDPݠDЭc޼Rb V ݬbݏ  žĐ޼RЭb -^P޼Rbݏ1 Pݏ   ݬլcMլHѬ   >ЬP@3ЬSݬ߭ЬPݭЬP@RbPlP޼RЏ b&Pݬ߭ЬPݭ`P` ݬqݏ  ӏ޼RЭb޼RbЬQPP ]P޼RbG͎| ^@lVЬRRR<RBЭRFRRЭRRRR ЭRRʏRR	RRRR ЭSЭRТ@ݬݭߘ"޼SЭRޢRbcݭDPP[PI(P R	R bRbЭR>SRcbЭRݢpݬݬv޼R b PP< ^޼RbPP  4 4 h h t t "?P^PЬRF޼RbDЬRf' ݬϏPЏ^(nPݬcPP Μ^IVjWЬRRR ЭRRʏRSRSSЭRRʏRSRSSЭRRʏRSRSSЭRFЭRݢ<ЭRAPPЭR>FRbDЭR<Rď`   RB5  P <Rď`   RBǿ SЭRc<EPZPݭPs ݬݭݏ ݬЭS<Rď`   RBRDbAZݭ{PƘ喇ݬݭݏ ݬϷЭRFRbЭR>FR<bRď`   RBǿ RRݬݬݭ1PЭRHRb<RBѽѽ	ѽoѽЭRТRRЭRТRRЭԭЭRѢ@4Y&PݭϗPݽPƾﴊPݭѽݬݬ<RRPѽLѽFսAݭ6PݽzPN  ݏ  !bЬRRRЭR$RRRЭR$RbS޼Rbc޼Rb<RR.ЭTRRЭSRRАcdRR<RRЭRЬ8SЭRѢEЭSЭRТ@ЭRNRRݭρխݬݭݭݬϟЭRբl1ЭRբp^ЭSЭRݢlЭR޲lR޲ R޲ RbPpխ2WPݭVݬݭݭݬ'ЭRNSЭR޲pR޲ RSbݬݭݏ ݬYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR bЭR@ݬЭR>JR<bSЭRCP^(YnЭRݢpЭR޲pRbR޲RbխTVPݭƅ޼RbЬR^(nݬݭݭݬЭSЭRѣ@.V#PݭsPЭRݢƷЭSЭRѣ@?ս:ѽݬݭݭݬݬݭݏ ݬvս"ЭSЭRѣ@ЭRFSЭSЭRRѣ@R@UݭϻPݬݭݏ ݬЭRRʏRR/߭ݬ<RRݬݬPխͰЭR>JR<bRR ͰݭϣЭSЭRТ@ЭRgR bЭRЭ ЭRVϥЬR>R<bRR'  P   PPЭRբpЭR޲pRbRâRR䰏P ͦͨRЏ
 bЭͬ ͱ ] UYSЭRRRRxRRRRR cYSЭRRRRcYSЭRRRRYRR b^S^RoI  PD^^RݢDﲸѭ 1 ЭU ݭUݏx  ﷅ (SP^(Un<ׄͲRRܕ^(UnPPЏ PURRݭݭ\1RRRRݏ   ݭϡЭRVPͱ߭߭^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbR
b1 ЭRϊЭRݢ\PխЏ ^(nBͱ߭߭ݭ^(Ynݏ  ͲݭݭͦЭR>DR<bSЭR޲XRCbRb ݭϥݏ  rѭ9ͱݭ،ͲRRݏ ݭPRѭRR]^ﰶЭR <1(P ЭRHRbЭRLR bЭR ЭRܢ?]9ЭR <ЭRJRbЭRݢpݬݭݬ&1 PЭЭR@RЭbЭRբpЭR޲pRbRĢRRЭRݭ曆P<P   RRݭЭRݢ<7F  ]	PЭЭRDR bݭݬ;ͰݭbЭR E  PSRSbͱݭ9ЭR  )U#ˏ  URR  ^(Un޵^(UnﮓP^(Unﺵ ^>T^SЬPHЬRЬP(\枢HQPaЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P)  POOPݬkPħЬPЬPJP ` ݬݬݬ+ЬP>HP<`P@ЭR fD  PQPQ`ЬQЭPѡ@eO1PݬPЭPݠЬP>HP<`PPЬPЬPJP ` ݬݬݬЬQЭPѡ@ݬݬݭݬ@yNݬ[P"P ^Y<T\SЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@Pc(  P4M(PݬPЬP>HP<`PP<~ЬP>HP<`P@ЭR B  PQPQ`ѽЬQЭPѡ@	ݭ ^;T&\SЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P'  P4M(PݬPЬP>HP<`PPr~ЬP>HP<`P@ЭR B  PQPQ`ѽЬQЭPѡ@9L.PݬϋPЭPݠݽPĪ}ЬP>LP<`RRЭP>DP<`PRPЭRЬP>LP<`PPPPQDPQ`ݭݬP ^-:TZSЬPHЬRЬP(x➢HQPaЬPH=ЬP>HP<`P@+ЬP(ЬP>HP<`P@P&  POKPݬχP|ЬPЬPJP ` ݬݬݬGЬP>HP<`P@ЭR @  PQPQ`ЬP
ЬPJP ` ݬݬݬݭς ^9RJ2PݬPЬPPPPPo|P	{P |^8VXYWЬRRR޼R bЭR>HR<bRR   >ЭRH2fJPЭR>HR<bRR:	n{޼RЏ bЭR>FR<bRR <ЭRF0JЭR>FR<bRRg	"{޼RЏ bЬRRޭRЬb<RR.ЭTRRЭSRRcdRR<RR >  PRRЭRբ8>ЭRѢ82kIPƔ	zݭݏ ݬϘЭR8RbݏL	  	z޼TSRE>  PDRݢDЭd޼Rb z޼R^(bnfЭRRRRRխݬݬݬϡPݭݬ<RBXRbլ6ЭRNRXFSBc"ݬЭRNR@FSBcR޲Rb  ͎z< ^Ь SR>=  PDRݢDЭѭ                                                                                                                                                                                                                                                                            x2        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1
1                                                                                                                          ]       խݭ^(n^ЭR>JR<bRRݭ}Pݬݬݬݬݭݬݭ蓼ݬM  ^	VQPPP< ^ЬЭRѢݬݬݬ6PЭRТѽ޼RЏ b޼SЭRТ R(c޼R b  ^޼P `ЬPРѽ޼PЏ ` PЭPՠl޼PЏ `ЭPРlPP  ^޼P `ЬPРѽ
޼PЏ `,ЭPՠpЭPݠpЭPްpP`PްP`ЭPЬpP  ^޼P `ЬPРѽ޼PЏ ` P	ЭPРpPP ^TRѬ   ޼PЏ `+ݏ   "P ЭP @   ЬPЬ@޼P     ^=TP | ^)TV ޼R bm޼RbcP<Rď`   RB.ЬScTcRRcďV   T޼S<Rď`   R(V Bƿ DcRR޼RbPЬScRRc޼R b  ^<R:  TjS޼P `ݏ   b~v }v޼PЏ ` ݬ.  Pխ.MvWDPߢ2mu޼PЏ `ݭZ,   ݬU9  ޼P`լݬݬݬݬ  ݬݭO.  P;CdߢTtd0
޼PЏ `޼PЏ `1 P߭ݬݭ.  P)CPdߢ~t޼PЏ `1 ޼PЭ`ݬ߭ݬ  ޼P`;CP­ PtQPݬݭݬݬ-  2 PP@ÿ PPЭ PP t޼P `t+    ^ݬݬݬ ݬP  ^ݬݬݬЬQЬP<APPݬϖ| ^hVݬݬݏ   ݬݬyPխ PzЬRRʏRRgЬR( l  POЬR @CЬR L7ЬRЬRЬRЬR޼R( b ЬRRʏRR1 ЬЬRRʏRR=ЭR(P ЭR(( ЭRޢ@Rb ЭR>LS Rcb PЬSЭRdЬSЭReЬSЭRfЬSЭRg޼SЭR(Pc ЬR>JRb<RR2<UЬT<SЭRChEPRRRR<RRЏ   PP< (^Ь޼$R bݬݭݬ"P޼$RЏ bRRЬ޼RЭbڭ<RR.ЭTRRЭSRRcdRR<RR޼SЭRRRRRRRc޼SЭR(c޼ SЭR(  < ΰ^Ьݬ޼R<bRR  P   PP(P RRЭR,ЭR-ЭR.ЭR/ЬRRRЬb<RR.ЭTRRЭSRRcdRR<RRЬ͸RRʹRЬb<RR0PЭTRRЭSRRcdRR<RRЭR>JR<bRRRBЭR>JR<bRRRRЭRP04   ʹݬwEPRRR b ʹݬYw ʹݭݬBw| ^W6VdS <T2 RRRTR1 P<PP@ÿ R bT޼U<PP@ÿ Rz  bP{ PQPPRxRRRRRDeRR1 ߭<PP@ÿ RbSPnPRRRR^=&PRRRR6oP nݭ<PP@ÿ Rb1RR<P2 RRRPR1P  ^acS< RR A2   <T2 RRRTRU<\\Lÿ \ lRT<\\Lÿ \z  lP{ PQPP\x\\Bd\\Bd\\<P2 \\\P\R\ Ьb  ݏ@   $  Pխ< RRP T^O4V1  Wqb\zSzR_1  PDzzRݢDnnѭ*; mzVPѭ Jխ'^(n2P^(n,lխ^(n& ͠   r0   <S2 RRRSRd<RRB̿ RbRR	RR SrTz  P{ PQPPRxRRCdRRCdRR<S2 RRRSR RR    rݭ)#  P RR խ)g:PgݭHk1]P 2 RѭRURB̿ R bSrTRB̿ Rz  bP{ PQPPRxRRRRRCdRRPRR2 RѭR2 RѭR"Pݏ  ƃqd/   9/  RB̿ RRխݏ    tP ߭ЭRݽ5PzPݭݭݭݽЭR>R<bRR?ݏ  Ƶ7kЭR>R<bRRݭtt k 1I 1z ^	1S2_RѬ	ЬPPЭ      4ݬ7:i IqPPfx  ;޼P     ^^P ޼Q     ^^Q޼P ` Ь  ^u^R  ݬݬ PP޼PЏ `Pݬy  ^޼P     ^Ѭ޼Pg7`޼P `ѬЬPW7޼P`ѬЬP:7޼P`ѬЬP7޼P`ѬЬPh7޼P`ѬЬPS7޼P`޼P `    ^^Qլ#Ѭ
2P@0޼P `Џ   PP޼PЏ
 ` P ^E^R޼P `  ޼Pѭ`޼PЏ `)P2PP@0ЭP޼Q@aPP
޼P   ^]S޼P `޼R޼Pb` Pݬ޼P<`PPP1PˏPPKݬݬݬݬݬ޼P<`PPP2PP@0Pް0P`P޼P`1ZP P1ˏPPwݬ߭ݬݬ	  ޼P`1ݬ߭ݬݬY	  ޼P`1 Pѭݭ*  P P1 ˏPPsݬ߭ݬݬ	  ޼P`1 ݬ߭ݬݬ	  ޼P`nPѭݭ2*  P PˏPP2ݬݬݬh   PRݬݬݬR   RP PЏ   P޼P ` Ѭ ݬݬݬ)  P	PPPPPPP ^[Rݬ޼P<`PPPݬݬݬ޼P<`PPP2PP@0Pް P`PP ^e[Rݬ޼P<`PPP޼P`ݬݬݬݬ޼P<`PPP2PP@0PްP  ^
[Rݬ޼P<`PPcP޼P`ݬݬݬݬ޼P<`PPP2PP@0PްP  ^m-R޼P `ݬbݬs(  P
PݬߢݬX(  PPݬߢݬ=(  PPݬߢ
ݬ"(  P P޼PЏ
   ЏP ^,RЬPP 
, \ 8 \ \ \ D \ \ \ \ \ \ P 
P^?P2PޢPP2PޢPP&PޢPPPޢPPP޼PЏ
 `޼P`ݭݬn'  ݭ'  P޼Pѭ`޼PЭ`޼P   ^cYR޼P`Ѭ  ޼PЏ `ݏ  ݬ'  ЬP @PPլg:ݬ&  Pխ޼PЏ ` ݬìPPݬP޼P`ìPPPPPPPݬݬP޼P`ݏ[   ݬ]&  PխЬT ݏ]   PP2&  Pխ޼PЏ ` PP%  PPPìPP޼P`PPV޼P`PQP#QQ	PPݬݬݬݭPPݬݬ2P@0PްP`Oݬ߭ݬ  ݬݭݬݬX  ݬݭݬݬ ^*TXWSЏd   Џd   ݬ޼P<`PPPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`ЭP @߭(ߤ"$  ޼P`ݬa$  $  P޼P`޼Rݬ$  PPPb޼Rݬݬ P   ^(T,VSЏd   Џd   ݬ޼P<`PPrPݬ߭(޼P<`PP޼P`ЭP @(ݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`'ЭP @߭(ߤ)#  [Pݬ߭߭ݬݬ޼P<`PPP2PP@0PްP`޼P`ЭP @߭(ߤ/X#  ޼P`ݬ"  1#  P޼P`޼Rݬ#  PPPb޼Rݬݬ P  <  ^ݬ޼RbݬP޼Rbݬ߭߭߭ݭ޼R<bRR  ޼Rb޼R(b޼SޭRb  ^=TRݬݬPݬݬ2P@0P P  PP ^SRݬݬYP޼P` ݬ!  ޼P`ݬݬݬݬ2P@0P P   ^SRݬ޼P<`PPP޼P` ݬN!  ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@0Pް P  ^!SR޼Q޼P`a޼P`ݬ޼P<`PPePݬݬݬݬݬ޼P<`PPP2PP@0Pް$P   ^RRݬ޼P<`PPP޼P` ݬn   ޼Q޼P`aݬݬݬݬݬ޼P<`PPP2PP@0Pް(P  ^ARR޼Q޼P`a޼P`ݬ޼P<`PPPݬݬݬݬݬ޼P<`PPP2PP@0Pް,P   ^QRݬݬ5Pݬݬݬݬݬݬ2P@0P4 P   ^QRЬݬ޼P<`PPPݬݭݬ޼P<`PPP2PP@0P8 P   ^9QRЬݬ<PP                                                                                                                                                                                                                                                                           V3m        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;11                                                                                                                           l       Pݬݭݬ<PPP2PP@0Pް<P` .A    A      ^#S>QT c  Pѭ2ݏ  ߣh  Pѭݏ  ߣ4L  ѭ+ݭ  Pѭ`޼Rb+޼Rb+ЬP/P:P޼RФ+bЬR>/P<`QQ  QPQ`>P<`PPЬRbPPb޼Rb+ЬP>Q/Pa`ѭ#  ݭ  ݬݭ  ݭ   X^PT|  Ï PPNRD{RPNPP@PRPR޼RGgPJPPPbЬRPPQPQ`ݬIդL1  j߭߭j߭n>P<`PPjݭn߭ ;  j߭;ݭPPLЬPP `ЬP; ЬP	^  ѤLФLPPPݭ=ЬP	Y   ^-!RЬPPPЬPPPЬP
PPЬPPPЬPPPЬP
PPЬP	PPЬPPPЬP>P<`PP޼P`ߢN       ^ R??߭ ݬ  Pѭ
޼PЏ`޼P `޼PЭ`ЬPP`ЬPЬPP `ЬP	ЬP
ЬPЬPЬP
ЬPЬP     ^ ޼Q޼Pa`1 ЬQЬP1 ЬQЬP1 ЬQЬPrЬQЬP		cЬQЬP

TЬQЬPEЬQЬP6ЬQЬP

'ЬQЬPЬQЬP	PPPPPPP ^ЬЬ ЭQPPaRЭQPPaPPRRխЭPЭP ^ЬЭPͽQЭP̠QЭP̠QQP̭Pʏ  PPQЭPЬRRRPRQPQ{RPPQQP    ^ЬխЏP ѭˏPP&xPPPPѭˏPPЭP ^ ЭP޼Q@a$ŭ RЭP޼Q@asPRRЭP?ʘ P ^qKRm  ޼PЭ`ЬQ>P<`PPPP޼Q<,PPaЬPТ0 < $^޼R( bݏi ݬ  P PRSRS3SRRRRPP< $^޼R( bݏi ݬ  P PRSRS3SRRRRPP< $^޼R( bݏ
i ݬd  P P>R<bRSRSSRRP< $^޼R( bݬݬYP%ݬݬPݬݬPP Pݏi ݬ
  P PRSRS3SRRRRP  ^ݬ  PխЏPЭPްP`P  ^߬  Pխ PP  ^ЬѬ޼PЏ`ЭP> P<  PP  PPPP ^Ь޼P`޼PЏ`޼P `ЭRݬ  PQPQ` ^Ь޼P`޼PЏ`޼P `Ѭ (Ѭ  ЭRݏ   >  PQPQ`PP |^ЬѬd   ޼PЏ `޼P `޼P` ݭ  ݬݬݬݭݬݬ߭^  ЬP @4߭
  Pѭ޼PЏ `ЭPPЭ`1 ߭PЭPP޼PЏ `ޭPPޭPPЭRPPЭQPPabЭQRRЭPRR`aЭQRRЭPRR`aЭQRRЭPRR`aЭRRЭb޼R  < ^ЬѬ޼RЏbЭR^(n	  P޼Rݭ~  PbP޼RЏ bݭݬ+  ޼SݬL  PRRc޼R     ^ЬѬ޼PЏ`޼P `ЭPՠ$޼P`ݬf	  P޼PЏ `8ЭPݠϳPխ޼PЏ `޼P`ݭݬP  ݬ  P޼Pѭ`޼PЭ`P  ^޼P   Џ   P  ^ ЬP  ޼P`   Pѭ޼PЏ `Џ   PPݏiݭe  Pݭ  ޼PЏ ` PPPPխ1 ݭݭKP_ݭݭςPNݭݭP=ѭ7ЭPPPЭPР߭ЬP8  ޼P `P PPPPխ1vݭ  ޼P     ^ЬЭPРѬ޼PЏ`޼P `޼P`߭ P     ^ЬѬ޼PЏ`޼P `޼P`ЬP߭p  ЭPP    ^ЬЭPРѬ޼PЏ`޼P `޼P`߭ P     ^ЬѬ޼PЏ`޼P `޼P`ЬP߭  ЭPP    <^ЬЬѬ޼PЏ`Ѭ޼PЏ`ݬݭ~  ݬݭk  ޼P `Pݠe  PPPPݠO  PPPˏPP'ˏPPˏ Qˏ PQP1 ˏ?PP   .ˏ?PP   ˏ  Qˏ  PQPGPˏ?PP   .ˏ?PP   ˏ   Qˏ   PQPP ːPPPPP| ΰ^V޼Rb޼RЏ b 6  Pѭ޼RЏ bЏ   RRݏiݭ  Pݭ  ޼RЏ b RR RRխ1 ޼Rѭb1 S޼RCbRR( ͼݭݭPѭP1 ЭR޼SBcRbЭRݬ~  PSRSbͼݏi ݭ  Pf&  0RRЭRЭR
  RR&P RRRRխ
޼Rѭb1޼RЭb޼R b    ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ ^ЬЬ޼P `ЭRЭP>QPa`ЭPЭRТ  ^Џ   ߭ݏ~fݬ   P  ^   
  PP  ^ݬݬݬݬ   Y  PP  ^ݬݬݬݬݬ     PP  ^ݬݬݬݬݬ     PP <^-R  S߭  PˏPP ݬ  Pխ	cЏPP`ΞPPˏPP' PP#枭PP ЬЬݭݭ      ߭<PPݭݭ PˏPPݭb  ЭcЏP>P<`PʏPPH>P<`PP>P<`PP>P<`PP>P<`PPߢj  >P<`PPPPcЏP߭b  P P d  `  \  X  T  P  L  H  D  @  <  8  4  0  ,  (  $                      
  
  
  
  
  
  
  
  
  
  
  
  
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ޖ        RPC010.B                       @	  !  '[UCX.V13.BL13.RPCKIT.B]RPC$STCODE.EXE;1;1                                                                                                                    (      {               @   @   D  8  D                                     M      X'  '  @(  '  '  '  '  '  '  '  (  x(  p'  '  '  '  '  '  '  (  (  8(  0(  X(  ((  p(  h(  `(   (  P(  (  (  '  (   (  '  x'  h'  `'  H(         d        |    L    $  <  L    l  D  |        L   4  0'  \       $           '  
     &  &  '                ,
   
  8
  Z'  b'  j'  r'  z'  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  '  (  
(  (  (  "(  *(  2(  :(  B(  R(  Z(  b(  j(  r(  z(  (  (  (        
                 @                                                                       VAXCRTL                                                        LIBRTL                                                         MTHRTL                                 *                                             $ ( , 0 4             
    STCODE  H  main    		 H         ERROR H  xstrcpy d    I  error_$c_get_text    M  
error_$c_text     XN  error_$find_text    		E
H   Z        #
    RPC_UTIL  O  rpc_$printf ,    ,O  rpc_$die T    O  
rpc_$pkt_name 8    O  	rpc_$lock 
    O  rpc_$unlock 
    O  rpc_$set_pkt_body_st (     P  rpc_$get_pkt_body_st     P  rpc_$swab_header    T  
rpc_$recvfrom    V  rpc_$sendto w   8X  rpc_$malloc 7    pX  	rpc_$free     X  rpc_$alloc_pkt      X  
rpc_$free_pkt     X  rpc_$alloc_linked_pkt X    Y  rpc_$free_linked_pkt g    xY  rpc_$free_frag_list ;    Y  rpc_$insert_in_frag_list     8\  rpc_$reassemble_frag_list     \  handle_alarm     ]  rpc_$periodically    ^  rpc_$stop_periodic     T_  rpc_$fill_frag     `  rpc_$cvt_string     `  rpc_$block_copy     a  rpc_$status_print L   