                            |7 $      RTI020.J                                                                                                                                                                                                     T>                RTI020.Jm  BACKUP/INTERCHANGE/VERIFY/BLOCK=9000/GROUP=25/PROT=(S:RWED,G:R,O:RWED,W:R) SEAS$KWD:*.*;* []RTI020.J/SAVE_SET  STANVICK          9
B      V5.3 	 _EDGE:: 
      _$111$DUA55:  V5.3 
  $                      ( * [STANVICK.SEAS$WORK_294000DB]ABSNT.FOR;1 +  ,  	   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 ;@  7  #A  8          9          G    H  J                        C  C H C     .................................................................. C  C        SUBROUTINE ABSNT  C  C        PURPOSE? C           TEST MISSING OR ZERO VALUES FOR EACH OBSERVATION IN  C           MATRIX A.  C  C        USAGE" C           CALL ABSNT (A,S,NO,NV) C " C        DESCRIPTION OF PARAMETERS- C           A  - OBSERVATION MATRIX, NO BY NV D C           S  - OUTPUT VECTOR OF LENGTH NO INDICATING THE FOLLOWING, C                CODES FOR EACH OBSERVATION.9 C                1  THERE IS NOT A MISSING OR ZERO VALUE. : C                0  AT LEAST ONE VALUE IS MISSING OR ZERO.@ C           NO - NUMBER OF OBSERVATIONS. NO MUST BE > OR = TO 1.E C           NV - NUMBER OF VARIABLES FOR EACH OBSERVATION. NV MUST BE , C                GREATER THAN OR EQUAL TO 1. C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           A TEST IS MADE FOR EACH ROW (OBSERVATION) OF THE MATRIX A.C C           IF THERE IS NOT A MISSING OR ZERO VALUE, 1 IS PLACED IN G C           S(J). IF AT LEAST ONE VALUE IS MISSING OR ZERO, 0 IS PLACED  C           IN S(J). C H C     .................................................................. C !       SUBROUTINE ABSNT(A,S,NO,NV)        DIMENSION A(1),S(1)  C        DO 20 J=1,NO
       IJ=J-NO        S(J)=1.0       DO 10 I=1,NV       IJ=IJ+NO       IF(A(IJ)) 10,5,10      5 S(J)=0       GO TO 20    10 CONTINUE    20 CONTINUE       RETURN	       END                               ( * [STANVICK.SEAS$WORK_294000DB]ANOVA.COM;1 +  , "   .     /     4 A                          - =    0   1    2   3      K  P   W   O     5 -  6 @ؐ@  7 #A  8          9          G    H  J                       A $ COPY IN$:ANOVA.FOR,AVCAL.FOR,AVDAT.FOR,MEANQ.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                          ( * [STANVICK.SEAS$WORK_294000DB]ANOVA.DAT;1 +  , =   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 K@  7 `S#A  8          9          G    H  J                       # SAMPLE04       A0004B0003C0003R0002 H      3    10     9     8    24     8     9     3     2     8     9     8H      4    12     3     9    22     7    16     2     2     2     7     2H      5    10     5     8    23     9    17     3     2     8     6     3H      2    14     9    13    29    16    11     3     2     7     5     3H      7    11     5     8    28    18    10     6     6     6     5     9H      9    10    27     8    28    16    11     7     8     9     8    15                                           ( * [STANVICK.SEAS$WORK_294000DB]ANOVA.FOR;1 +  , B   . 	    /     4 B   	                      - =    0   1    2   3      K  P   W   O     5 -  6   @  7 #A  8          9          G    H  J                       - C	RT-11 FORTRAN SCIENTIFIC SUBROUTINE PACKAGE  C	DEC-11-XXXXX-A-LA  C  C  C  C  C  C  C  C  C  C 5 C	COPYRIGHT (C) 1974 BY DIGITAL EQUIPMENT CORPORATION  C	MAYNARD, MASSACHUSETTS  01754  C  C  C  C  C  C  C  C  C 7 C	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE < C	WITHOUT NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT6 C	BY DIGITAL EQUIPMENT CORPORATION.  DIGITAL EQUIPMENT6 C	CORPORATION ASSUMES NO RESPONSIBILITY FOR ANY ERRORS# C	THAT MAY APPEAR IN THIS DOCUMENT.  C 9 C	THE SOFTWARE DESCRIBED IN THIS DOCUMENT IS FURNISHED TO < C	THE PURCHASER UNDER A LICENSE FOR USE ON A SINGLE COMPUTER7 C	SYSTEM AND CAN BE COPIED (WITH INCLUSION OF DIGITAL'S : C	COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS2 C	MAY OTHERWISE BE PROVIDED IN WRITING BY DIGITAL. C 9 C	DIGITAL EQUIPMENT CORPORATION ASSUMES NO RESPONSIBILITY 9 C	FOR THE USE OR RELIABILITY OF ITS SOFTWARE ON EQUIPMENT " C	THAT IS NOT SUPPLIED BY DIGITAL. C  C  C  C  C  C  C  C  C  C  C  C  C	R. SHIELDS	OCTOBER 1974 5 C	ANOVA.FOR - SAMPLE PROGRAM FOR ANALYSIS OF VARIANCE > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE? C	CUMULATIVE PRODUCT OF EACH FACTOR LEVEL PLUS ONE (LEVEL(I)+1) 3 C	FOR I=1 TO K, WHERE K IS THE NUMBER OF FACTORS...  	DIMENSION X(1600)= C	THE FOLLOWING DIMENSIONS MUST BE GREATER THAN OR EQUAL TO 2 ' C	TO THE K-TH POWER MINUS 1, ((2**K)-1) 6 	DIMENSION HEAD(6),LEVEL(6),ISTEP(6),KOUNT(6),LASTS(6)& 	DIMENSION SUMSQ(63),NDF(63),SMEAN(63); C	THE FOLLOWING DIMENSION IS USED TO PRINT FACTOR LABELS IN ) C	ANALYSIS OF VARIANCE TABLE AND IS FIXED  	DIMENSION FMT(15)B 1	FORMAT(A4,A2,I2,A4,3X,11(A1,I4)/(A1,I4,A1,I4,A1,I4,A1,I4,A1,I4))2 2	FORMAT(////26H ANALYSIS OF VARIANCE.....A4,A2//)/ 3	FORMAT(//18H LEVELS OF FACTORS/(3X,A1,7X,I4)) & 4	FORMAT(////11H GRAND MEAN,F20.5////)B 5	FORMAT(//10H SOURCE OF,18X,7HSUMS OF,10X,10HDEGREES OF,9X,4HMEAN< 	1/10H VARIATION,18X,7HSQUARES,11X,7HFREEDOM,10X,7HSQUARES/)$ 6	FORMAT(2X,15A1,F20.5,10X,I6,F20.5)$ 7	FORMAT(/6H TOTAL,10X,F20.5,10X,I6) 8	FORMAT(12F6.0) C  C	INPUT CHANNEL = IN 	IN=1 7 	OPEN (UNIT=1,NAME='IN$:ANOVA.DAT',TYPE='OLD',READONLY) 5 100	READ(IN,1)PR,PR1,K,BLANK,(HEAD(I),LEVEL(I),I=1,K) & C	PR=PROBLEM NUMBER, MAY BE ALPHAMERIC C	PR1=PROBLEM NUMBER CONTINUED C	K=NUMBER OF FACTORS  C	BLANK=BLANK FIELD  C	LEVEL=LEVELS OF FACTORS $ 	IF(K.EQ.0) STOP 'ANOVA successful!'+ C	PRINT PROBLEM NUMBER AND LEVEL OF FACTORS  	TYPE 2, PR,PR1 ! 	TYPE 3, (HEAD(I),LEVEL(I),I=1,K) ) C	CALCULATE TOTAL NUMBER OF DATA ELEMENTS  	N=LEVEL(1) 
 	DO 102 I=2,K  102	N=N*LEVEL(I) C	READ ALL INPUT DATA  	READ(IN,8) (X(I),I=1,N)& 	CALL AVDAT(K,LEVEL,N,X,L,ISTEP,KOUNT)$ 	CALL AVCAL(K,LEVEL,X,L,ISTEP,LASTS)> 	CALL MEANQ(K,LEVEL,X,GMEAN,SUMSQ,NDF,SMEAN,ISTEP,KOUNT,LASTS) C	PRINT GRAND MEAN 	TYPE 4, GMEAN" C	PRINT ANALYSIS OF VARIANCE TABLE 	TYPE 5  	LL=(2**K)-1 	ISTEP(1)=1 
 	DO 105 I=2,K  105	ISTEP(I)=0 	DO 110 I=1,15 110	FMT(I)=BLANK 	NN=0  	SUM=0.0 120	NN=NN+1  	L=0
 	DO 140 I=1,K 
 	FMT(I)=BLANK  	IF(ISTEP(I)) 130,140,130 	 130	L=L+1  	FMT(L)=HEAD(I)  140	CONTINUE3 	TYPE 6,(FMT(I),I=1,15),SUMSQ(NN),NDF(NN),SMEAN(NN)  	SUM=SUM+SUMSQ(NN) 	IF(NN-LL) 145,170,170 145	DO 160 I=1,K 	IF(ISTEP(I)) 147,150,147  147	ISTEP(I)=0
 	GO TO 160 150	ISTEP(I)=1
 	GO TO 120 160	CONTINUE	 170	N=N-1  	TYPE 7, SUM,N
 	GO TO 100 	END                                                                                                                                                                                                                                                    ( * [STANVICK.SEAS$WORK_294000DB]ARRAY.FOR;1 +  , 7   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7  y#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE ARRAY  C  C        PURPOSEF C           CONVERT DATA ARRAY FROM SINGLE TO DOUBLE DIMENSION OR VICED C           VERSA.  THIS SUBROUTINE IS USED TO LINK THE USER PROGRAME C           WHICH HAS DOUBLE DIMENSION ARRAYS AND THE SSP SUBROUTINES @ C           WHICH OPERATE ON ARRAYS OF DATA IN A VECTOR FASHION. C  C        USAGE) C           CALL ARRAY (MODE,I,J,N,M,S,D)  C " C        DESCRIPTION OF PARAMETERS5 C           MODE - CODE INDICATING TYPE OF CONVERSION 8 C                    1 - FROM SINGLE TO DOUBLE DIMENSION8 C                    2 - FROM DOUBLE TO SINGLE DIMENSION7 C           I    - NUMBER OF ROWS IN ACTUAL DATA MATRIX : C           J    - NUMBER OF COLUMNS IN ACTUAL DATA MATRIX? C           N    - NUMBER OF ROWS SPECIFIED FOR THE MATRIX D IN & C                  DIMENSION STATEMENTB C           M    - NUMBER OF COLUMNS SPECIFIED FOR THE MATRIX D IN& C                  DIMENSION STATEMENTE C P                                                                                                                           d_ $      RTI020.J                       7  =  ([STANVICK.SEAS$WORK_294000DB]ARRAY.FOR;1                                                                                       H                              n                       S    - IF MODE=1, THIS VECTOR IS INPUT WHICH CONTAINS THE G C                  ELEMENTS OF A DATA MATRIX OF SIZE I BY J. COLUMN I+1 C C                  OF DATA MATRIX FOLLOWS COLUMN I, ETC. IF MODE=2, F C                  THIS VECTOR IS OUTPUT REPRESENTING A DATA MATRIX OFD C                  SIZE I BY J CONTAINING ITS COLUMNS CONSECUTIVELY.7 C                  THE LENGTH OF S IS IJ, WHERE IJ=I*J. C C           D    - IF MODE=1, THIS MATRIX OF SIZE N BY M IS OUTPUT, G C                  CONTAINING A DATA MATRIX OF SIZE I BY J IN THE FIRST F C                  I ROWS AND J COLUMNS. IF MODE=2, THIS N BY M MATRIXF C                  IS INPUT CONTAINING A DATA MATRIX OF SIZE I BY J IN2 C                  THE FIRST I ROWS AND J COLUMNS. C  C        REMARKSG C           VECTOR S CAN BE IN THE SAME LOCATION AS MATRIX D.  VECTOR S C C           IS REFERRED AS A MATRIX IN OTHER SSP ROUTINES, SINCE IT # C           CONTAINS A DATA MATRIX. H C           THIS SUBROUTINE CONVERTS ONLY GENERAL DATA MATRICES (STORAGE C           MODE OF 0).  C 6 C        SUBROUTINES AND FUNCTION SUBROUTINES REQUIRED C           NONE C  C        METHOD H C           REFER TO THE DISCUSSION ON VARIABLE DATA SIZE IN THE SECTION> C           DESCRIBING OVERALL RULES FOR USAGE IN THIS MANUAL. C H C     .................................................................. C )       SUBROUTINE ARRAY (MODE,I,J,N,M,S,D)        DIMENSION S(1),D(1)  C        NI=N-I C   C        TEST TYPE OF CONVERSION C        IF(MODE-1) 100, 100, 120 C 0 C        CONVERT FROM SINGLE TO DOUBLE DIMENSION C    100 IJ=I*J+1       NM=N*J+1       DO 110 K=1,J       NM=NM-NI       DO 110 L=1,I
       IJ=IJ-1 
       NM=NM-1    110 D(NM)=S(IJ)        GO TO 140  C 0 C        CONVERT FROM DOUBLE TO SINGLE DIMENSION C 
   120 IJ=0
       NM=0       DO 130 K=1,J       DO 125 L=1,I
       IJ=IJ+1 
       NM=NM+1    125 S(IJ)=D(NM)    130 NM=NM+NI C    140 RETURN	       END                                                                                       ' * [STANVICK.SEAS$WORK_294000DB]AUTO.FOR;1 +  , 2   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  3խ@  7  O#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE AUTO C  C        PURPOSEB C           TO FIND AUTOCOVARIANCES OF SERIES A FOR LAGS 0 TO L-1. C  C        USAGE C           CALL AUTO (A,N,L,R)  C " C        DESCRIPTION OF PARAMETERSF C           A    - INPUT VECTOR OF LENGTH N CONTAINING THE TIME SERIES3 C                  WHOSE AUTOCOVARIANCE IS DESIRED. * C           N    - LENGTH OF THE VECTOR A.H C           L    - AUTOCOVARIANCE IS CALCULATED FOR LAGS OF 0, 1, 2,..., C                  L-1. G C           R    - OUTPUT VECTOR OF LENGTH L CONTAINING AUTOCOVARIANCES  C                  OF SERIES A.  C  C        REMARKSF C           THE LENGTH OF R IS DIFFERENT FROM THE LENGTH OF A.  N MUSTF C           BE GREATER THAN L.  IF NOT, R(1) IS SET TO ZERO AND RETURN+ C           IS MADE TO THE CALLING PROGRAM.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           DESCRIBED IN R.B. BLACKMAN AND J.W. TUKEY, 'THE MEASURMENTD C        OF POWER SPECTRA', DOVER PUBLICATIONS INC., NEW YORK, 1959. C H C     .................................................................. C        SUBROUTINE AUTO (A,N,L,R)        DIMENSION A(1),R(1)  C ( C     CALCULATE AVERAGE OF TIME SERIES A C        AVER=0.0       IF(N-L) 50,50,100     50 R(1)=0.0       RETURN   100 DO 110 I=1,N   110 AVER=AVER+A(I)
       FN=N       AVER=AVER/FN C  C     CALCULATE AUTOCOVARIANCES  C        DO 130 J=1,L       NJ=N-J+1
       SUM=0.0        DO 120 I=1,NJ        IJ=I+J-1&   120 SUM=SUM+(A(I)-AVER)*(A(IJ)-AVER)       FNJ=NJ   130 R(J)=SUM/FNJ       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                               ( * [STANVICK.SEAS$WORK_294000DB]AVCAL.FOR;1 +  ,    . 	    /     4 H   	                        - =    0   1    2   3      K  P   W   O     5 -  6 @  7 @%#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE AVCAL  C  C        PURPOSE@ C           PERFORM THE CALCULUS OF A FACTORIAL EXPERIMENT USINGB C           OPERATOR SIGMA AND OPERATOR DELTA.  THIS SUBROUTINE ISC C           PRECEDED BY SUBROUTINE ADVAT AND FOLLOWED BY SUBROUTINE B C           MEANQ IN THE PERFORMANCE OF ANALYSIS OF VARIANCE FOR A& C           COMPLETE FACTORIAL DESIGN. C  C        USAGE0 C           CALL AVCAL (K,LEVEL,X,L,ISTEP,LASTS) C " C        DESCRIPTION OF PARAMETERSF C           K     - NUMBER OF VARIABLES (FACTORS). K MUST BE .GT. ONE.E C           LEVEL - INPUT VECTOR OF LENGTH K CONTAINING LEVELS (CATE- 1 C                   GORIES) WITHIN EACH VARIABLE. H C           X     - INPUT VECTOR CONTAINING DATA.  DATA HAVE BEEN PLACEDE C                   IN VECTOR X BY SUBROUTINE AVDAT.  THE LENGTH OF X B C                   IS (LEVEL(1)+1)*(LEVEL(2)+1)*...*(LEVEL(K)+1).F C           L     - THE POSITION IN VECTOR X WHERE THE LAST INPUT DATAD C                   IS LOCATED.  L HAS BEEN CALCULATED BY SUBROUTINE C                   AVDAT.G C           ISTEP - INPUT VECTOR OF LENGTH K CONTAINING STORAGE CONTROL B C                   STEPS WHICH HAVE BEEN CALCULATED BY SUBROUTINE C                   AVDAT./ C           LASTS - WORKING VECTOR OF LENGTH K.  C  C        REMARKS9 C           THIS SUBROUTINE MUST FOLLOW SUBROUTINE AVDAT.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD C C           THE METHOD IS BASED ON THE TECHNIQUE DISCUSSED BY H. O. D C           HARTLEY IN 'MATHEMATICAL METHODS FOR DIGITAL COMPUTERS',B C           EDITED BY A. RALSTON AND H. WILF, JOHN WILEY AND SONS, C           1962, CHAPTER 20.  C H C     .................................................................. C 0       SUBROUTINE AVCAL (K,LEVEL,X,L,ISTEP,LASTS)/       DIMENSION LEVEL(1),X(1),ISTEP(1),LASTS(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C  C     DOUBLE PRECISION X,SUM C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C H C        ............................................................... C 5 C     CALCULATE THE LAST DATA POSITION OF EACH FACTOR  C        LASTS(1)=L+1       DO 145 I=2,K"   145 LASTS(I)=LASTS(I-1)+ISTEP(I) C # C     PERFORM CALCULUS OF OPERATION  C    150 DO 175 I=1,K	       L=1 
       LL=1
       SUM=0.0        NN=LEVEL(I)        FN=NN        INCRE=ISTEP(I)       LAST=LASTS(I)  C  C     SIGMA OPERATION  C    155 DO 160 J=1,NN        SUM=SUM+X(L)   160 L=L+INCRE        X(L)=SUM C  C     DELTA OPERATION  C        DO 165 J=1,NN        X(LL)=FN*X(LL)-SUM   165 LL=LL+INCRE 
       SUM=0.0        IF(L-LAST) 167, 175, 175$   167 IF(L-LAST+INCRE) 168, 168, 170   168 L=L+INCRE        LL=LL+INCRE        GO TO 155    170 L=L+INCRE+1-LAST       LL=LL+INCRE+1-LAST       GO TO 155    175 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]AVDAT.FOR;1 +  , 9    . 	    /     4 H   	   	 x                    - =    0   1    2   3      K  P   W   O 
    5 -  6 @  7 t"#A  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                  FP\ $      RTI020.J                       9   =  ([STANVICK.SEAS$WORK_294000DB]AVDAT.FOR;1                                                                                       H     	                         *              C H C     .................................................................. C  C        SUBROUTINE AVDAT  C  C        PURPOSEG C           PLACE DATA FOR ANALYSIS OF VARIANCE IN PROPERLY DISTRIBUTED G C           POSITIONS OF STORAGE.  THIS SUBROUTINE IS NORMALLY FOLLOWED F C           BY CALLS TO AVCAL AND MEANQ SUBROUTINES IN THE PERFORMANCED C           OF ANALYSIS OF VARIANCE FOR A COMPLETE FACTORIAL DESIGN. C  C        USAGE2 C           CALL AVDAT (K,LEVEL,N,X,L,ISTEP,KOUNT) C " C        DESCRIPTION OF PARAMETERSF C           K     - NUMBER OF VARIABLES (FACTORS). K MUST BE .GT. ONE.E C           LEVEL - INPUT VECTOR OF LENGTH K CONTAINING LEVELS (CATE- 1 C                   GORIES) WITHIN EACH VARIABLE. 8 C           N     - TOTAL NUMBER OF DATA POINTS READ IN.G C           X     - WHEN THE SUBROUTINE IS CALLED, THIS VECTOR CONTAINS H C                   DATA IN LOCATIONS X(1) THROUGH X(N).  UPON RETURNINGH C                   TO THE CALLING ROUTINE, THE VECTOR CONTAINS THE DATAD C                   IN PROPERLY REDISTRIBUTED LOCATIONS OF VECTOR X.F C                   THE LENGTH OF VECTOR X IS CALCULATED BY (1) ADDINGG C                   ONE TO EACH LEVEL OF VARIABLE AND (2) OBTAINING THE E C                   CUMULATIVE PRODUCT OF ALL LEVELS.  (THE LENGTH OF D C                   X = (LEVEL(1)+1)*(LEVEL(2)+1)*...*(LEVEL(K)+1).)G C           L     - OUTPUT VARIABLE CONTAINING THE POSITION IN VECTOR X 8 C                   WHERE THE LAST INPUT DATA IS STORED.F C           ISTEP - OUTPUT VECTOR OF LENGTH K CONTAINING CONTROL STEPSE C                   WHICH ARE USED TO LOCATE DATA IN PROPER POSITIONS   C                   OF VECTOR X./ C           KOUNT - WORKING VECTOR OF LENGTH K.  C  C        REMARKS@ C           INPUT DATA MUST BE ARRANGED IN THE FOLLOWING MANNER.F C           CONSIDER THE 3-VARIABLE ANALYSIS OF VARIANCE DESIGN, WHEREF C           ONE VARIABLE HAS 3 LEVELS AND THE OTHER TWO VARIABLES HAVEH C           2 LEVELS.  THE DATA MAY BE REPRESENTED IN THE FORM X(I,J,K),@ C           I=1,2,3  J=1,2  K=1,2.  IN ARRANGING DATA, THE INNERC C           SUBSCRIPT, NAMELY I, CHANGES FIRST.  WHEN I=3, THE NEXT E C           INNER SUBSCRIPT, J, CHANGES AND SO ON UNTIL I=3, J=2, AND  C           K=2. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD C C           THE METHOD IS BASED ON THE TECHNIQUE DISCUSSED BY H. O. D C           HARTLEY IN 'MATHEMATICAL METHODS FOR DIGITAL COMPUTERS',B C           EDITED BY A. RALSTON AND H. WILF, JOHN WILEY AND SONS, C           1962, CHAPTER 20.  C H C     .................................................................. C 2       SUBROUTINE AVDAT (K,LEVEL,N,X,L,ISTEP,KOUNT)/       DIMENSION LEVEL(1),X(1),ISTEP(1),KOUNT(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C  C     DOUBLE PRECISION X C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C H C        ............................................................... C ( C     CALCULATE TOTAL DATA AREA REQUIRED C        M=LEVEL(1)+1       DO 105 I=2,K   105 M=M*(LEVEL(I)+1) C 0 C     MOVE DATA TO THE UPPER PART OF THE ARRAY X& C     FOR THE PURPOSE OF REARRANGEMENT C        N1=M+1       N2=N+1       DO 107 I=1,N
       N1=N1-1 
       N2=N2-1    107 X(N1)=X(N2)  C G C     CALCULATE MULTIPLIERS TO BE USED IN FINDING STORAGE LOCATIONS FOR  C     INPUT DATA C        ISTEP(1)=1       DO 110 I=2,K(   110 ISTEP(I)=ISTEP(I-1)*(LEVEL(I-1)+1)       DO 115 I=1,K   115 KOUNT(I)=1 C $ C     PLACE DATA IN PROPER LOCATIONS C 
       N1=N1-1        DO 135 I=1,N       L=KOUNT(1)       DO 120 J=2,K   120 L=L+ISTEP(J)*(KOUNT(J)-1) 
       N1=N1+1        X(L)=X(N1)       DO 130 J=1,K)       IF(KOUNT(J)-LEVEL(J)) 124, 125, 124    124 KOUNT(J)=KOUNT(J)+1        GO TO 135    125 KOUNT(J)=1   130 CONTINUE   135 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                       ' * [STANVICK.SEAS$WORK_294000DB]BESI.FOR;1 +  , 2*   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @֠@  7 J6#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE BESI C  C        PURPOSEH C           COMPUTE THE I BESSEL FUNCTION FOR A GIVEN ARGUMENT AND ORDER C  C        USAGE! C           CALL BESI(X,N,BI,IER)  C " C        DESCRIPTION OF PARAMETERS= C           X  -THE ARGUMENT OF THE I BESSEL FUNCTION DESIRED : C           N  -THE ORDER OF THE I BESSEL FUNCTION DESIRED/ C           BI -THE RESULTANT I BESSEL FUNCTION * C           IER-RESULTANT ERROR CODE WHERE C              IER=0 NO ERROR " C              IER=1 N IS NEGATIVE" C              IER=2 X IS NEGATIVE= C              IER=3 UNDERFLOW, BI .LT. 1.E-38, BI SET TO 0.0 7 C              IER=4 OVERFLOW, X .GT. 60 WHERE X .GT. N  C  C        REMARKS% C           N AND X MUST BE .GE. ZERO  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD A C           COMPUTES I BESSEL FUNCTION USING SERIES OR ASYMPTOTIC : C           APPROXIMATION DEPENDING ON RANGE OF ARGUMENTS. C H C     .................................................................. C "       SUBROUTINE BESI(X,N, BI,IER) C = C     CHECK FOR ERRORS IN N AND X AND EXIT IF ANY ARE PRESENT  C        IER=0        BI=1.0       IF(N)150,15,10    10 IF(X)160,20,20    15 IF(X)160,17,20    17 RETURN C  C     DEFINE TOLERANCE C     20 TOL=1.E-6  C 5 C     IF ARGUMENT GT 12 AND GT N, USE ASYMPTOTIC FORM  C        IF(X-12.)40,40,30     30 IF(X-FLOAT(N))40,40,110  C C C     COMPUTE FIRST TERM OF SERIES AND SET INITIAL VALUE OF THE SUM  C 
    40 XX=X/2.     50 TERM=1.0       IF(N) 70,70,55    55 DO 60 I=1,N 
       FI=I"       IF(ABS(TERM)-1.E-36)56,60,60    56 IER=3        BI=0.0       RETURN    60 TERM=TERM*XX/FI 
    70 BI=TERM        XX=XX*XX C A C     COMPUTE TERMS, STOPPING WHEN ABS(TERM) LE ABS(SUM OF TERMS)  C     TIMES TOLERANCE  C        DO 90 K=1,1000)       IF(ABS(TERM)-ABS(BI*TOL))100,100,80     80 FK=K*(N+K)       TERM=TERM*(XX/FK)     90 BI=BI+TERM C  C     RETURN BI AS ANSWER  C    100 RETURN C 9 C     X GT 12 AND X GT N, SO USE ASYMPTOTIC APPROXIMATION  C    110 FN=4*N*N4 C  THE LIMIT OF 60. MAY BE ABLE TO BE REVISED UPWARD       IF(X-60.0)115,111,111    111 IER=4        RETURN   115 XX=1./(8.*X)
       TERM=1.        BI=1.        DO 130 K=1,30 *       IF(ABS(TERM)-ABS(TOL*BI))140,140,120   120 FK=(2*K-1)**2 #       TERM=TERM*XX*(FK-FN)/FLOAT(K)    130 BI=BI+TERM C 2 C     SIGNIFICANCE LOST AFTER 30 TERMS, TRY SERIES C        GO TO 40   140 PI=3.141592653        BI=BI*EXP(X)/SQRT(2.*PI*X)       GO TO 100    150 IER=1        GO TO 100    160 IER=2        GO TO 100 	       END                                                                                                                                                                                                                                                                                                                                                                                                       ' * [STANVICK.SEAS$WORK_294000DB]BESJ.FOR;1 +  , 2    .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 ҋ@  7 G#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE BESJ C  C        PURPOSEH C           COMPUTE THE J BESSEL FUNCTION FOR A GIVEN ARGUMENT AND ORDER C  C        USAGE# C           CALL BESJ(X,N,BJ,D,IER)  C " C        DESCRIPTION OF PARAMETERS= C           X  -THE ARGUMENT OF THE J BESSEL FUNCTION DESIRED : C           N  -THE ORDER OF THE J BESSEL FUNCTION DESIRED/ C           BJ -THE RESULTANT J BESSEL FUNCTION ! C           D  -REQUIRED ACCURACY                                                                                                                                                                                                            -ì $      RTI020.J                       2   =  '[STANVICK.SEAS$WORK_294000DB]BESJ.FOR;1                                                                                        H                              1 
            * C           IER-RESULTANT ERROR CODE WHERE C              IER=0  NO ERROR# C              IER=1  N IS NEGATIVE + C              IER=2  X IS NEGATIVE OR ZERO 4 C              IER=3  REQUIRED ACCURACY NOT OBTAINEDH C              IER=4  RANGE OF N COMPARED TO X NOT CORRECT (SEE REMARKS) C  C        REMARKSC C           N MUST BE GREATER THAN OR EQUAL TO ZERO, BUT IT MUST BE  C           LESS THAN ? C              20+10*X-X** 2/3   FOR X LESS THAN OR EQUAL TO 15 5 C              90+X/2           FOR X GREATER THAN 15  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           RECURRENCE RELATION TECHNIQUE DESCRIBED BY H. GOLDSTEIN AND E C           R.M. THALER,'RECURRENCE TECHNIQUES FOR THE CALCULATION OF F C           BESSEL FUNCTIONS',M.T.A.C.,V.13,PP.102-108 AND I.A. STEGUNE C           AND M. ABRAMOWITZ,'GENERATION OF BESSEL FUNCTIONS ON HIGH : C           SPEED COMPUTERS',M.T.A.C.,V.11,1957,PP.255-257 C H C     .................................................................. C #       SUBROUTINE BESJ(X,N,BJ,D,IER)  C        BJ=.0        IF(N)10,20,20     10 IER=1        RETURN    20 IF(X)30,30,31     30 IER=2        RETURN    31 IF(X-15.)32,32,34     32 NTEST=20.+10.*X-X** 2/3        GO TO 36    34 NTEST=90.+X/2.    36 IF(N-NTEST)40,38,38     38 IER=4        RETURN    40 IER=0        N1=N+1       BPREV=.0 C ! C     COMPUTE STARTING VALUE OF M  C        IF(X-5.)50,60,60
    50 MA=X+6.        GO TO 70    60 MA=1.4*X+60./X    70 MB=N+IFIX(X)/4+2       MZERO=MAX0(MA,MB)  C  C     SET UPPER LIMIT OF M C        MMAX=NTEST   100 DO 190 M=MZERO,MMAX,3  C  C     SET F(M),F(M-1)  C        FM1=1.0E-28        FM=.0        ALPHA=.0       IF(M-(M/2)*2)120,110,120   110 JT=-1        GO TO 130 
   120 JT=1   130 M2=M-2       DO 160 K=1,M2        MK=M-K       BMK=2.*FLOAT(MK)*FM1/X-FM        FM=FM1
       FM1=BMK        IF(MK-N-1)150,140,150    140 BJ=BMK   150 JT=-JT       S=1+JT   160 ALPHA=ALPHA+BMK*S        BMK=2.*FM1/X-FM        IF(N)180,170,180   170 BJ=BMK   180 ALPHA=ALPHA+BMK        BJ=BJ/ALPHA ,       IF(ABS(BJ-BPREV)-ABS(D*BJ))200,200,190   190 BPREV=BJ       IER=3    200 RETURN	       END                                                                                                                                                                                                                                                                                                                                           ' * [STANVICK.SEAS$WORK_294000DB]BESK.FOR;1 +  , U3   . 	    /     4 H   	                         - =    0   1    2   3      K  P   W   O 	    5 -  6 @p@  7 p\#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE BESK C H C           COMPUTE THE K BESSEL FUNCTION FOR A GIVEN ARGUMENT AND ORDER C  C        USAGE! C           CALL BESK(X,N,BK,IER)  C " C        DESCRIPTION OF PARAMETERS= C           X  -THE ARGUMENT OF THE K BESSEL FUNCTION DESIRED : C           N  -THE ORDER OF THE K BESSEL FUNCTION DESIRED/ C           BK -THE RESULTANT K BESSEL FUNCTION * C           IER-RESULTANT ERROR CODE WHERE C              IER=0  NO ERROR# C              IER=1  N IS NEGATIVE + C              IER=2  X IS ZERO OR NEGATIVE 7 C              IER=3  X .GT. 60, MACHINE RANGE EXCEEDED $ C              IER=4  BK .GT. 10**36 C  C        REMARKS3 C           N MUST BE GREATER THAN OR EQUAL TO ZERO  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           COMPUTES ZERO ORDER AND FIRST ORDER BESSEL FUNCTIONS USINGG C           SERIES APPROXIMATIONS AND THEN COMPUTES N TH ORDER FUNCTION & C           USING RECURRENCE RELATION.F C           RECURRENCE RELATION AND POLYNOMIAL APPROXIMATION TECHNIQUEF C           AS DESCRIBED BY A.J.M.HITCHCOCK,'POLYNOMIAL APPROXIMATIONSD C           TO BESSEL FUNCTIONS OF ORDER ZERO AND ONE AND TO RELATEDF C           FUNCTIONS', M.T.A.C., V.11,1957,PP.86-88, AND G.N. WATSON,E C           'A TREATISE ON THE THEORY OF BESSEL FUNCTIONS', CAMBRIDGE ) C           UNIVERSITY PRESS, 1958, P. 62  C H C     .................................................................. C !       SUBROUTINE BESK(X,N,BK,IER)        DIMENSION T(12)        BK=.0        IF(N)10,11,11     10 IER=1        RETURN    11 IF(X)12,12,20     12 IER=2        RETURN4 C  THE LIMIT OF 60. MAY BE ABLE TO BE REVISED UPWARD    20 IF(X-60.0)22,22,21    21 IER=3        RETURN    22 IER=0        IF(X-1.)36,36,25    25 A=EXP(-X)        B=1./X       C=SQRT(B)        T(1)=B       DO 26 L=2,12    26 T(L)=T(L-1)*B        IF(N-1)27,29,27  C / C     COMPUTE KO USING POLYNOMIAL APPROXIMATION  C A    27 G0=A*(1.2533141-.1566642*T(1)+.08811128*T(2)-.09139095*T(3) >      2+.1344596*T(4)-.2299850*T(5)+.3792410*T(6)-.5247277*T(7)A      3+.5575368*T(8)-.4262633*T(9)+.2184518*T(10)-.06680977*T(11)       4+.009189383*T(12))*C       IF(N)20,28,29     28 BK=G0        RETURN C / C     COMPUTE K1 USING POLYNOMIAL APPROXIMATION  C ?    29 G1=A*(1.2533141+.4699927*T(1)-.1468583*T(2)+.1280427*T(3) >      2-.1736432*T(4)+.2847618*T(5)-.4594342*T(6)+.6283381*T(7)A      3-.6632295*T(8)+.5050239*T(9)-.2581304*T(10)+.07880001*T(11)       4-.01082418*T(12))*C        IF(N-1)20,30,31     30 BK=G1        RETURN C 5 C     FROM KO,K1 COMPUTE KN USING RECURRENCE RELATION  C     31 DO 35 J=2,N !       GJ=2.*(FLOAT(J)-1.)*G1/X+G0        IF(GJ-1.0E36)33,33,32     32 IER=4        GO TO 34    33 G0=G1     35 G1=GJ     34 BK=GJ        RETURN    36 B=X/2.       A=.57721566+ALOG(B)        C=B*B        IF(N-1)37,43,37  C ' C     COMPUTE KO USING SERIES EXPANSION  C     37 G0=-A        X2J=             1.
       FACT=1.        HJ=.0        DO 40 J=1,6        RJ=1./FLOAT(J)       X2J=X2J*C        FACT=FACT*RJ*RJ        HJ=HJ+RJ    40 G0=G0+X2J*FACT*(HJ-A)        IF(N)43,42,43     42 BK=G0        RETURN C ' C     COMPUTE K1 USING SERIES EXPANSION  C     43 X2J=B 
       FACT=1.        HJ=1.        G1=1./X+X2J*(.5+A-HJ)        DO 50 J=2,8        X2J=X2J*C        RJ=1./FLOAT(J)       FACT=FACT*RJ*RJ        HJ=HJ+RJ)    50 G1=G1+X2J*FACT*(.5+(A-HJ)*FLOAT(J))        IF(N-1)31,52,31     52 BK=G1        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ' * [STANVICK.SEAS$WORK_294000DB]BESY.FOR;1 +  , "7   . 	    /     4 H   	    *                    - =    0   1    2   3      K  P   W   O 	    5 -  6 W@  7 Fp#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE BESY C  C        PURPOSEH C           COMPUTE THE Y BESSEL FUNCTION FOR A GIVEN ARGUMENT AND ORDER C  C        USAGE! C           CALL BESY(X,N,BY,IER)  C " C        DESCRIPTION OF PARAMETERS= C           X  -THE ARGUMENT OF THE Y BESSEL FUNCTION DESIRED : C           N  -THE ORDER OF THE Y BESSEL FUNCTION DESIRED/ C           BY -THE RESULTANT Y BESSEL FUNCTION * C           IER-RESULTANT ERROR CODE WHERE C              IER=0  NO ERROR# C              IER=1  N IS NEGATIVE + C              IER=2  X IS NEGATIVE OR ZERO 9 C              IER=3  BY HAS EXCEEDED MAGNITUDE OF 10**36  C  C        REMARKSE C           VERY SMALL VALUES OF X MAY CAUSE THE RANGE OF THE LIBRARY ( C           FUNCTION ALOG TO BE EXCEEDED' C           X MUST BE GREATER THAN ZERO 3 C           N MUST BE GREATER THAN OR EQUAL TO ZERO  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           RECURRENCE RELATION AND POLYNOMIAL APPROXIMATION TECHNIQUEF C           AS DESCRIBED BY A.J.M.HITCHCOCK,'POLYNOMIAL APPROXIMATIONSD C           TO BESSEL FUNCTIONS OF ORDER ZERO AND ONE AND TO RELATEDF C           FUNCTIONS', M.T.A.C., V.11,1957,PP.86-88, AND G.N. WATSON,E C           'A TREATISE ON THE THEORY OF BESSEL FUNCTIONS', CAMBRIDGE ) C           UNIVERSITY PRESS, 1958, P. 62  C H C     .................................................................. C !       SUBROUTINE BESY(X,                                                                                                                                                                                           E2K? $      RTI020.J                       "7  =  '[STANVICK.SEAS$WORK_294000DB]BESY.FOR;1                                                                                        H     	                         H             N,BY,IER)  C ! C     CHECK FOR ERRORS IN N AND X  C        IF(N)180,10,10    10 IER=0        IF(X)190,190,20  C & C     BRANCH IF X LESS THAN OR EQUAL 4 C     20 IF(X-4.0)40,40,30  C . C       COMPUTE Y0 AND Y1 FOR X GREATER THAN 4 C     30 T1=4.0/X       T2=T1*T1<       P0=((((-.0000037043*T2+.0000173565)*T2-.0000487613)*T2.      1  +.00017343)*T2-.001753062)*T2+.3989423;       Q0=((((.0000032312*T2-.0000142078)*T2+.0000342468)*T2 2      1  -.0000869791)*T2+.0004564324)*T2-.01246694;       P1=((((.0000042414*T2-.0000200920)*T2+.0000580759)*T2 /      1  -.000223203)*T2+.002921826)*T2+.3989423 :       Q1=((((-.0000036594*T2+.00001622)*T2-.0000398708)*T22      1  +.0001064741)*T2-.0006390400)*T2+.03740084       A=2.0/SQRT(X)        B=A*T1       C=X-.7853982        Y0=A*P0*SIN(C)+B*Q0*COS(C)!       Y1=-A*P1*COS(C)+B*Q1*SIN(C)        GO TO 90 C 7 C       COMPUTE Y0 AND Y1 FOR X LESS THAN OR EQUAL TO 4  C 
    40 XX=X/2.        X2=XX*XX       T=ALOG(XX)+.5772157        SUM=0.       TERM=T
       Y0=T       DO 70 L=1,15       IF(L-1)50,60,50     50 SUM=SUM+1./FLOAT(L-1) 
    60 FL=L       TS=T-SUM-       TERM=(TERM*(-X2)/FL**2)*(1.-1./(FL*TS))     70 Y0=Y0+TERM       TERM = XX*(T-.5)       SUM=0.
       Y1=TERM        DO 80 L=2,16       SUM=SUM+1./FLOAT(L-1) 
       FL=L       FL1=FL-1.        TS=T-SUM9       TERM=(TERM*(-X2)/(FL1*FL))*((TS-.5/FL)/(TS+.5/FL1))     80 Y1=Y1+TERM       PI2=.6366198       Y0=PI2*Y0        Y1=-PI2/X+PI2*Y1 C ' C     CHECK IF ONLY Y0 OR Y1 IS DESIRED               C     90 IF(N-1)100,100,130 C ( C     RETURN EITHER Y0 OR Y1 AS REQUIRED C    100 IF(N)110,120,110   110 BY=Y1        GO TO 170    120 BY=Y0        GO TO 170  C 0 C    PERFORM RECURRENCE OPERATIONS TO FIND YN(X) C    130 YA=Y0        YB=Y1 	       K=1    140 T=FLOAT(2*K)/X       YC=T*YB-YA#       IF(ABS(YC)-1.0E36)145,145,141    141 IER=3        RETURN   145 K=K+1        IF(K-N)150,160,150   150 YA=YB        YB=YC        GO TO 140    160 BY=YC    170 RETURN   180 IER=1        RETURN   190 IER=2        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]BOUND.FOR;1 +  , '7
   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 w:@  7 #A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE BOUND  C  C        PURPOSEF C           SELECT FROM A SET (OR A SUBSET) OF OBSERVATIONS THE NUMBERD C           OF OBSERVATIONS UNDER, BETWEEN AND OVER TWO GIVEN BOUNDS C           FOR EACH VARIABLE  C  C        USAGE> C           CALL BOUND (A,S,BLO,BHI,UNDER,BETW,OVER,NO,NV,IER) C " C        DESCRIPTION OF PARAMETERS0 C           A     - OBSERVATION MATRIX, NO BY NV= C           S     - VECTOR INDICATING SUBSET OF A. ONLY THOSE E C                   OBSERVATIONS WITH A NON-ZERO S(J) ARE CONSIDERED. ( C                   VECTOR LENGTH IS NO.B C           BLO   - INPUT VECTOR OF LOWER BOUNDS ON ALL VARIABLES.( C                   VECTOR LENGTH IS NV.B C           BHI   - INPUT VECTOR OF UPPER BOUNDS ON ALL VARIABLES.( C                   VECTOR LENGTH IS NV.G C           UNDER - OUTPUT VECTOR INDICATING, FOR EACH VARIABLE, NUMBER E C                   OF OBSERVATIONS UNDER LOWER BOUNDS. VECTOR LENGTH  C                   IS NV.G C           BETW  - OUTPUT VECTOR INDICATING, FOR EACH VARIABLE, NUMBER G C                   OF OBSERVATIONS EQUAL TO OR BETWEEN LOWER AND UPPER 0 C                   BOUNDS. VECTOR LENGTH IS NV.G C           OVER  - OUTPUT VECTOR INDICATING, FOR EACH VARIABLE, NUMBER D C                   OF OBSERVATIONS OVER UPPER BOUNDS. VECTOR LENGTH C                   IS NV.* C           NO    - NUMBER OF OBSERVATIONS< C           NV    - NUMBER OF VARIABLES FOR EACH OBSERVATION& C           IER   - ZERO, IF NO ERROR.E C                 - 1, IF LOWER BOUND IS GREATER THAN THE UPPER BOUND % C                   FOR SOME VARIABLE  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD A C           EACH ROW (OBSERVATION) OF MATRIX A WITH CORRESPONDING D C           NON-ZERO ELEMENT IN S VECTOR IS TESTED. OBSERVATIONS AREG C           COMPARED WITH SPECIFIED LOWER AND UPPER VARIABLE BOUNDS AND @ C           A COUNT IS KEPT IN VECTORS UNDER, BETWEEN, AND OVER. C H C     .................................................................. C 9       SUBROUTINE BOUND(A,S,BLO,BHI,UNDER,BETW,OVER,NO,NV) @       DIMENSION A(1),S(1),BLO(1),BHI(1),UNDER(1),BETW(1),OVER(1) C  C        CLEAR OUTPUT VECTORS. C        IER=0        DO 10 I=1,NV!       IF (BLO(I)-BHI(I)) 10,10,11     11 IER=1        GO TO 12    10 CONTINUE       DO 1 K=1,NV        UNDER(K)=0.0       BETW(K)=0.0      1 OVER(K)=0.0  C  C        TEST SUBSET VECTOR  C        DO 8 J=1,NO 
       IJ=J-NO        IF(S(J)) 2,8,2 C ) C        COMPARE OBSERVATIONS WITH BOUNDS  C      2 DO 7 I=1,NV        IJ=IJ+NO       IF(A(IJ)-BLO(I)) 5,3,3     3 IF(A(IJ)-BHI(I)) 4,4,6 C 
 C       COUNT  C      4 BETW(I)=BETW(I)+1.0 
       GO TO 7      5 UNDER(I)=UNDER(I)+1.0 
       GO TO 7      6 OVER(I)=OVER(I)+1.0      7 CONTINUE     8 CONTINUE    12 RETURN	       END                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]CADD.FOR;1 +  , ;   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 Y@  7 @l#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CADD C  C        PURPOSE@ C           ADD COLUMN OF ONE MATRIX TO COLUMN OF ANOTHER MATRIX C  C        USAGE+ C           CALL CADD(A,ICA,R,ICR,N,M,MS,L)  C " C        DESCRIPTION OF PARAMETERS& C           A   - NAME OF INPUT MATRIXC C           ICA - COLUMN IN MATRIX A TO BE ADDED TO COLUMN ICR OF R ' C           R   - NAME OF OUTPUT MATRIX A C           ICR - COLUMN IN MATRIX R WHERE SUMMATION IS DEVELOPED + C           N   - NUMBER OF ROWS IN A AND R ( C           M   - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL ( C           L   - NUMBER OF COLUMNS IN R C  C        REMARKS- C           MATRIX R MUST BE A GENERAL MATRIX F C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A UNLESS C           A IS GENERAL C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD > C           EACH ELEMENT OF COLUMN ICA OF MATRIX A IS ADDED TO; C           CORRESPONDING ELEMENT OF COLUMN ICR OF MATRIX R  C H C     .................................................................. C +       SUBROUTINE CADD(A,ICA,R,ICR,N,M,MS,L)        DIMENSION A(1),R(1)  C        IR=N*(ICR-1)       DO 2 I=1,N
       IR=IR+1  C 9 C        LOCATE INPUT ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,ICA,IA,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IA) 1,2,1 C  C        ADD ELEMENTS  C      1 R(IR)=R(IR)+A(IA)      2 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                   ( * [STANVICK.SEAS$WORK_294000DB]CANOR.FOR;1 +  , 	<   .     /     4 H      
 j                    - =    0   1    2   3      K  P   W   O     5 -  6 @  7 #A  8          9          G    H  J                        p                                                                                                                                                                                                                                                                                                                                                                                                                          7n $      RTI020.J                       	<  =  ([STANVICK.SEAS$WORK_294000DB]CANOR.FOR;1                                                                                       H                                            C H C     .................................................................. C  C        SUBROUTINE CANOR  C  C        PURPOSEB C           COMPUTE THE CANONICAL CORRELATIONS BETWEEN TWO SETS OFG C           VARIABLES.  CANOR IS NORMALLY PRECEDED BY A CALL TO SUBROU-  C           TINE CORRE.  C  C        USAGEC C           CALL CANOR (N,MP,MQ,RR,ROOTS,WLAM,CANR,CHISQ,NDF,COEFR,   C                       COEFL,R) C " C        DESCRIPTION OF PARAMETERS* C           N     - NUMBER OF OBSERVATIONS1 C           MP    - NUMBER OF LEFT HAND VARIABLES 2 C           MQ    - NUMBER OF RIGHT HAND VARIABLESF C           RR    - INPUT MATRIX (ONLY UPPER TRIANGULAR PORTION OF THEA C                   SYMMETRIC MATRIX OF M X M, WHERE M = MP + MQ) G C                   CONTAINING CORRELATION COEFFICIENTS.  (STORAGE MODE  C                   OF 1) E C           ROOTS - OUTPUT VECTOR OF LENGTH MQ CONTAINING EIGENVALUES 5 C                   COMPUTED IN THE NROOT SUBROUTINE. A C           WLAM  - OUTPUT VECTOR OF LENGTH MQ CONTAINING LAMBDA. C C           CANR  - OUTPUT VECTOR OF LENGTH MQ CONTAINING CANONICAL ! C                   CORRELATIONS. = C           CHISQ - OUTPUT VECTOR OF LENGTH MQ CONTAINING THE * C                   VALUES OF CHI-SQUARES.E C           NDF   - OUTPUT VECTOR OF LENGTH MQ CONTAINING THE DEGREES ; C                   OF FREEDOM ASSOCIATED WITH CHI-SQUARES. A C           COEFR - OUTPUT MATRIX (MQ X MQ) CONTAINING MQ SETS OF 7 C                   RIGHT HAND COEFFICIENTS COLUMNWISE. A C           COEFL - OUTPUT MATRIX (MP X MQ) CONTAINING MQ SETS OF 6 C                   LEFT HAND COEFFICIENTS COLUMNWISE.' C           R     - WORK MATRIX (M X M)  C  C        REMARKSD C           THE NUMBER OF LEFT HAND VARIABLES (MP) SHOULD BE GREATERE C           THAN OR EQUAL TO THE NUMBER OF RIGHT HAND VARIABLES (MQ). D C           THE VALUES OF CANONICAL CORRELATION, LAMBDA, CHI-SQUARE,G C           DEGREES OF FREEDOM, AND CANONICAL COEFFICIENTS ARE COMPUTED F C           ONLY FOR THOSE EIGENVALUES IN ROOTS WHICH ARE GREATER THAN C           ZERO.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           MINV@ C           NROOT  (WHICH, IN TURN, CALLS THE SUBROUTINE EIGEN.) C  C        METHOD F C           REFER TO W. W. COOLEY AND P. R. LOHNES, 'MULTIVARIATE PRO-F C           CEDURES FOR THE BEHAVIORAL SCIENCES', JOHN WILEY AND SONS, C           1962, CHAPTER 3. C H C     .................................................................. C C       SUBROUTINE CANOR (N,MP,MQ,RR,ROOTS,WLAM,CANR,CHISQ,NDF,COEFR,        1                  COEFL,R)H       DIMENSION RR(1),ROOTS(1),WLAM(1),CANR(1),CHISQ(1),NDF(1),COEFR(1),      1          COEFL(1),R(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C F C     DOUBLE PRECISION RR,ROOTS,WLAM,CANR,CHISQ,COEFR,COEFL,R,DET,SUM,	 C	1  DLOG  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOG C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENT E C        165 MUST BE CHANGED TO DSQRT.  ALOG IN STATEMENT 175 MUST BE  C        CHANGED TO DLOG.  C H C        ............................................................... C D C     PARTITION INTERCORRELATIONS AMONG LEFT HAND VARIABLES, BETWEEND C     LEFT AND RIGHT HAND VARIABLES, AND AMONG RIGHT HAND VARIABLES. C 
       M=MP+MQ 
       N1=0       DO 105 I=1,M       DO 105 J=1,M       IF(I-J) 102, 103, 103    102 L=I+(J*J-J)/2        GO TO 104    103 L=J+(I*I-I)/2 
   104 N1=N1+1    105 R(N1)=RR(L) 
       L=MP       DO 108 J=2,MP        N1=M*(J-1)       DO 108 I=1,MP        L=L+1 
       N1=N1+1    108 R(L)=R(N1)
       N2=MP+1 	       L=0        DO 110 J=N2,M        N1=M*(J-1)       DO 110 I=1,MP        L=L+1 
       N1=N1+1    110 COEFL(L)=R(N1)	       L=0        DO 120 J=N2,M        N1=M*(J-1)+MP        DO 120 I=N2,M        L=L+1 
       N1=N1+1    120 COEFR(L)=R(N1) C " C     SOLVE THE CANONICAL EQUATION C        L=MP*MP+1        K=L+MP$       CALL MINV (R,MP,DET,R(L),R(K)) C + C        CALCULATE T = INVERSE OF R11 * R12  C        DO 140 I=1,MP 
       N2=0       DO 130 J=1,MQ 
       N1=I-MP        ROOTS(J)=0.0       DO 130 K=1,MP        N1=N1+MP
       N2=N2+1 '   130 ROOTS(J)=ROOTS(J)+R(N1)*COEFL(N2)        L=I-MP       DO 140 J=1,MQ        L=L+MP   140 R(L)=ROOTS(J)  C  C        CALCULATE A = R21 * T C 
       L=MP*MQ        N3=L+1       DO 160 J=1,MQ 
       N1=0       DO 160 I=1,MQ        N2=MP*(J-1) 
       SUM=0.0        DO 150 K=1,MP 
       N1=N1+1 
       N2=N2+1    150 SUM=SUM+COEFL(N1)*R(N2)        L=L+1    160 R(L)=SUM C B C        CALCULATE EIGENVALUES WITH ASSOCIATED EIGENVECTORS OF THE C        INVERSE OF R22 * A  C        L=L+1 ,       CALL NROOT (MQ,R(N3),COEFR,ROOTS,R(L)) C B C     FOR EACH VALUE OF I = 1, 2, ..., MQ, CALCULATE THE FOLLOWING C     STATISTICS C        DO 210 I=1,MQ  C 5 C        TEST WHETHER EIGENVALUE IS GREATER THAN ZERO  C         IF(ROOTS(I)) 220, 220, 165 C  C        CANONICAL CORRELATION C    165 CANR(I)= SQRT(ROOTS(I))  C  C        CHI-SQUARE  C        WLAM(I)=1.0        DO 170 J=I,MQ $   170 WLAM(I)=WLAM(I)*(1.0-ROOTS(J))
       FN=N       FMP=MP       FMQ=MQ4   175 CHISQ(I)=-(FN-0.5*(FMP+FMQ+1.0))*ALOG(WLAM(I)) C * C        DEGREES OF FREEDOM FOR CHI-SQUARE C        N1=I-1       NDF(I)=(MP-N1)*(MQ-N1) C , C        I-TH SET OF RIGHT HAND COEFFICIENTS C        N1=MQ*(I-1)        N2=MQ*(I-1)+L-1        DO 180 J=1,MQ 
       N1=N1+1 
       N2=N2+1    180 COEFR(N1)=R(N2)  C + C        I-TH SET OF LEFT HAND COEFFICIENTS  C        DO 200 J=1,MP 
       N1=J-MP        N2=MQ*(I-1)        K=MP*(I-1)+J       COEFL(K)=0.0       DO 190 JJ=1,MQ       N1=N1+MP
       N2=N2+1 '   190 COEFL(K)=COEFL(K)+R(N1)*COEFR(N2)    200 COEFL(K)=COEFL(K)/CANR(I)    210 CONTINUE   220 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]CCPY.FOR;1 +  , <   .     /     4 H       d                   - =    0   1    2   3      K  P   W   O     5 -  6 @  7  #A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CCPY C  C        PURPOSE; C           COPY SPECIFIED COLUMN OF A MATRIX INTO A VECTOR  C  C        USAGE# C           CALL CCPY(A,L,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX, C           L - COLUMN OF A TO BE MOVED TO R1 C           R - NAME OF OUTPUT VECTOR OF LENGTH N # C           N - NUMBER OR ROWS IN A & C           M - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD E C           ELEMENTS OF COLUMN L ARE MOVED TO CORRESPONDING POSITIONS  C           OF VECTOR R  C H C     .................................................................. C #       SUBROUTINE CCPY(A,L,R,N,M,MS)        DIMENSION A(1),R(1)  C        DO 3 I=1,N C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,L,IL,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IL) 1,2,1 C  C        MOVE ELEMENT TO R C      1 R(I)=A(IL)
       GO TO 3      2 R(I)=0.0     3 CONTINUE       RETURN	       END                                                                                                                                                                           ' * [STANVICK.SEAS$WORK_294000DB]CCUT.FOR;1 +  , <   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  Aݷ@  7 @u#A  8          9          G    H  J                                                                                                                                                                                                                                    2f $      RTI020.J                       <  =  '[STANVICK.SEAS$WORK_294000DB]CCUT.FOR;1                                                                                        H                              M 
             C H C     .................................................................. C  C        SUBROUTINE CCUT C  C        PURPOSED C           PARTITION A MATRIX BETWEEN SPECIFIED COLUMNS TO FORM TWO C           RESULTANT MATRICES C  C        USAGE& C           CALL CCUT (A,L,R,S,N,M,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIXC C           L - COLUMN OF A TO THE LEFT OF WHICH PARTITIONING TAKES  C               PLACE B C           R - NAME OF MATRIX TO BE FORMED FROM LEFT PORTION OF AC C           S - NAME OF MATRIX TO BE FORMED FROM RIGHT PORTION OF A # C           N - NUMBER OF ROWS IN A & C           M - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS; C           MATRIX R CANNOT BE IN SAME LOCATION AS MATRIX A ; C           MATRIX S CANNOT BE IN SAME LOCATION AS MATRIX A ; C           MATRIX R CANNOT BE IN SAME LOCATION AS MATRIX S = C           MATRIX R AND MATRIX S ARE ALWAYS GENERAL MATRICES  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD E C           ELEMENTS OF MATRIX A TO THE LEFT OF COLUMN L ARE MOVED TO @ C           FORM MATRIX R OF N ROWS AND L-1 COLUMNS. ELEMENTS OFH C           MATRIX A IN COLUMN L AND TO THE RIGHT OF L ARE MOVED TO FORM1 C           MATRIX S OF N ROWS AND M-L+1 COLUMNS.  C H C     .................................................................. C %       SUBROUTINE CCUT(A,L,R,S,N,M,MS)        DIMENSION A(1),R(1),S(1) C 
       IR=0
       IS=0       DO 70 J=1,M        DO 70 I=1,N  C 7 C        FIND LOCATION IN OUTPUT MATRIX AND SET TO ZERO  C        IF(J-L) 20,10,10
    10 IS=IS+1        S(IS)=0.0        GO TO 30
    20 IR=IR+1        R(IR)=0.0  C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C     30 CALL LOC(I,J,IJ,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IJ) 40,70,40  C - C        DETERMINE WHETHER RIGHT OR LEFT OF L  C     40 IF(J-L) 60,50,50    50 S(IS)=A(IJ)        GO TO 70    60 R(IR)=A(IJ)     70 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]CEL1.FOR;1 +  , k=   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 `ϸ@  7  >#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CEL1 C  C        PURPOSE> C           CALCULATE COMPLETE ELLIPTIC INTEGRAL OF FIRST KIND C  C        USAGE! C           CALL CEL1(RES,AK,IER)  C " C        DESCRIPTION OF PARAMETERS  C           RES   - RESULT VALUE# C           AK    - MODULUS (INPUT) . C           IER   - RESULTANT ERROR CODE WHERE# C                   IER=0  NO ERROR 3 C                   IER=1  AK NOT IN RANGE -1 TO +1  C  C        REMARKS6 C           THE RESULT IS SET TO 1.E38 IF ABS(AK) GE 18 C           FOR MODULUS AK AND COMPLEMENTARY MODULUS CK,- C           EQUATION AK*AK+CK*CK=1.0 IS USED. , C           AK MUST BE IN THE RANGE -1 TO +1 C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD  C           DEFINITIONC C           CEL1(AK)=INTEGRAL(1/SQRT((1+T*T)*(1+(CK*T)**2)), SUMMED ' C           OVER T FROM 0 TO INFINITY). * C           EQUIVALENT ARE THE DEFINITIONSE C           CEL1(AK)=INTEGRAL(1/(COS(T)SQRT(1+(CK*TAN(T))**2)),SUMMED # C           OVER T FROM 0 TO PI/2), D C           CEL1(AK)=INTEGRAL(1/SQRT(1-(AK*SIN(T))**2),SUMMED OVER T4 C           FROM 0 TO PI/2), WHERE K=SQRT(1.-CK*CK). C           EVALUATION; C           LANDENS TRANSFORMATION IS USED FOR CALCULATION.  C           REFERENCE D C           R.BULIRSCH, 'NUMERICAL CALCULATION OF ELLIPTIC INTEGRALSG C           AND ELLIPTIC FUNCTIONS', HANDBOOK SERIES SPECIAL FUNCTIONS, : C           NUMERISCHE MATHEMATIK VOL. 7, 1965, PP. 78-90. C H C     .................................................................. C !       SUBROUTINE CEL1(RES,AK,IER)        IER=0        ARI=2.       GEO=(0.5-AK)+0.5       GEO=GEO+GEO*AK
       RES=0.5        IF(GEO)1,2,4     1 IER=1      2 RES=1.E38        RETURN     3 GEO=GEO*AARI     4 GEO=SQRT(GEO)        GEO=GEO+GEO        AARI=ARI       ARI=ARI+GEO        RES=RES+RES        IF(GEO/AARI-0.9999)3,5,5     5 RES=RES/ARI*6.283185E0       RETURN	       END                       ' * [STANVICK.SEAS$WORK_294000DB]CEL2.FOR;1 +  , =   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 9@  7 #A  8          9          G    H  J            
             C H C     .................................................................. C  C        SUBROUTINE CEL2 C  C        PURPOSEB C           COMPUTES THE GENERALIZED COMPLETE ELLIPTIC INTEGRAL OF C           SECOND KIND. C  C        USAGE% C           CALL CEL2(RES,AK,A,B,IER)  C " C        DESCRIPTION OF PARAMETERS  C           RES   - RESULT VALUE# C           AK    - MODULUS (INPUT) . C           A     - CONSTANT TERM IN NUMERATOR9 C           B     - FACTOR OF QUADRATIC TERM IN NUMERATOR . C           IER   - RESULTANT ERROR CODE WHERE# C                   IER=0  NO ERROR 3 C                   IER=1  AK NOT IN RANGE -1 TO +1  C  C        REMARKS? C           FOR ABS(AK) GE 1 THE RESULT IS SET TO 1.E38 IF B IS 1 C           POSITIVE, TO -1.E38 IF B IS NEGATIVE.  C           SPECIAL CASES ARE + C           K(K) OBTAINED WITH A = 1, B = 1 ; C           E(K) OBTAINED WITH A = 1, B = CK*CK WHERE CK IS " C           COMPLEMENTARY MODULUS.+ C           B(K) OBTAINED WITH A = 1, B = 0 + C           D(K) OBTAINED WITH A = 0, B = 1 D C           WHERE K, E, B, D DEFINE SPECIAL CASES OF THE GENERALIZEDB C           COMPLETE ELLIPTIC INTEGRAL OF SECOND KIND IN THE USUALA C           NOTATION, AND THE ARGUMENT K OF THESE FUNCTIONS MEANS  C           THE MODULUS. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD  C           DEFINITIONH C           RES=INTEGRAL((A+B*T*T)/(SQRT((1+T*T)*(1+(CK*T)**2))*(1+T*T)). C           SUMMED OVER T FROM 0 TO INFINITY). C           EVALUATION; C           LANDENS TRANSFORMATION IS USED FOR CALCULATION.  C           REFERENCE D C           R.BULIRSCH, 'NUMERICAL CALCULATION OF ELLIPTIC INTEGRALSG C           AND ELLIPTIC FUNCTIONS', HANDBOOK SERIES SPECIAL FUNCTIONS, : C           NUMERISCHE MATHEMATIK VOL. 7, 1965, PP. 78-90. C H C     .................................................................. C %       SUBROUTINE CEL2(RES,AK,A,B,IER)        IER=0        ARI=2.       GEO=(0.5-AK)+0.5       GEO=GEO+GEO*AK       RES=A        A1=A+B       B0=B+B       IF(GEO)1,2,6     1 IER=1      2 IF(B)3,8,4     3 RES=-1.E38       RETURN     4 RES=1.E38        RETURN     5 GEO=GEO*AARI     6 GEO=SQRT(GEO)        GEO=GEO+GEO        AARI=ARI       ARI=ARI+GEO        B0=B0+RES*GEO        RES=A1       B0=B0+B0       A1=B0/ARI+A1       IF(GEO/AARI-0.9999)5,7,7     7 RES=A1/ARI       RES=RES+0.5707963E0*RES      8 RETURN	       END                                                                                                   ( * [STANVICK.SEAS$WORK_294000DB]CHISQ.FOR;1 +  , =   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 (@  7 `#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE CHISQ  C  C        PURPOSE7 C           COMPUTE CHI-SQUARE FROM A CONTINGENCY TABLE  C  C        USAGE/ C           CALL CHISQ(A,N,M,CS,NDF,IERR,TR,TC)  C " C        DESCRIPTION OF PARAMETERSE C           A    - INPUT MATRIX, N BY M, CONTAINING CONTINGENCY TABLE & C           N    - NUMBER OF ROWS IN A) C           M    - NUMBER OF COLUMNS IN A & C           CS   - CHI-SQUARE (OUTPUT)8 C           ND                                                                                                                                                                                                                                                                                                                                                                                                                                          :_. $      RTI020.J                       =  =  ([STANVICK.SEAS$WORK_294000DB]CHISQ.FOR;1                                                                                       H                              H 
            F  - NUMBER OF DEGREES OF FREEDOM (OUTPUT)& C           IERR - ERROR CODE (OUTPUT)$ C                    0 - NORMAL CASEB C                    1 - EXPECTED VALUE IS LESS THAN 1.0 IN ONE OR# C                        MORE CELLS = C                    3 - NUMBER OF DEGREES OF FREEDOM IS ZERO * C           TR   - WORK VECTOR OF LENGTH N* C           TC   - WORK VECTOR OF LENGTH M C  C        REMARKSA C           IF ONE OR MORE CELLS CONTAIN AN EXPECTED VALUE (I.E., @ C           THEORETICAL VALUE) LESS THAN 1.0, CHI-SQUARE WILL BE6 C           COMPUTED, BUT ERROR CODE WILL BE SET TO 1.& C           SEE REFERENCE GIVEN BELOW.D C           CHI-SQUARE IS SET TO ZERO IF EITHER N OR M IS ONE (ERROR C           CODE 3). C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956,$ C           CHAPTER 6 AND CHAPTER 8. C H C     .................................................................. C /       SUBROUTINE CHISQ(A,N,M,CS,NDF,IERR,TR,TC)         DIMENSION A(1),TR(1),TC(1) C        NM=N*M       IERR=0       CS=0.0 C   C        FIND DEGREES OF FREEDOM C        NDF=(N-1)*(M-1)        IF(NDF) 5,5,10     5 IERR=3       RETURN C  C        COMPUTE TOTALS OF ROWS  C     10 DO 90 I=1,N        TR(I)=0.0        IJ=I-N       DO 90 J=1,M 
       IJ=IJ+N     90 TR(I)=TR(I)+A(IJ)  C " C        COMPUTE TOTALS OF COLUMNS C 
       IJ=0       DO 100 J=1,M       TC(J)=0.0        DO 100 I=1,N
       IJ=IJ+1    100 TC(J)=TC(J)+A(IJ)  C  C        COMPUTE GRAND TOTAL C        GT=0.0       DO 110 I=1,N   110 GT=GT+TR(I)  C ; C        COMPUTE CHI SQUARE FOR 2 BY 2 TABLE (SPECIAL CASE)  C        IF(NM-4) 130,120,130E   120 CS=GT*(ABS(A(1)*A(4)-A(2)*A(3))-GT/2.0)**2  /(TC(1)*TC(2)*TR(1) 
      1*TR(2))        RETURN C 8 C        COMPUTE CHI SQUARE FOR OTHER CONTINGENCY TABLES C 
   130 IJ=0       DO 140 J=1,M       DO 140 I=1,N
       IJ=IJ+1        E=TR(I)*TC(J)/GT       IF(E-1.0) 135, 140, 140    135 IERR=1!   140 CS=CS+(A(IJ)-E)*(A(IJ)-E)/E        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]CINT.FOR;1 +  , @   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @  7 #A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CINT C  C        PURPOSE/ C           INTERCHANGE TWO COLUMNS OF A MATRIX  C  C        USAGE  C           CALL CINT(A,N,LA,LB) C " C        DESCRIPTION OF PARAMETERS C           A  - NAME OF MATRIX $ C           N  - NUMBER OF ROWS IN A9 C           LA - COLUMN TO BE INTERCHANGED WITH COLUMN LB 9 C           LB - COLUMN TO BE INTERCHANGED WITH COLUMN LA  C  C        REMARKS- C           MATRIX A MUST BE A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           EACH ELEMENT OF COLUMN LA IS INTERCHANGED WITH CORRESPONDING  C           ELEMENT OF COLUMN LB C H C     .................................................................. C         SUBROUTINE CINT(A,N,LA,LB)       DIMENSION A(1) C . C        LOCATE STARTING POINT OF BOTH COLUMNS C        ILA=N*(LA-1)       ILB=N*(LB-1) C        DO 3 I=1,N       ILA=ILA+1        ILB=ILB+1  C  C        INTERCHANGE ELEMENTS  C        SAVE=A(ILA)        A(ILA)=A(ILB)      3 A(ILB)=SAVE        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                   ) * [STANVICK.SEAS$WORK_294000DB]COLROW.COM;1 +  , A(   .     /     4 ?       H                  - =    0   1    2   3      K  P   W   O     5 -  6  d@  7 3#A  8          9          G    H  J                      ? $ COPY IN$:COLROW.FOR,CINT.FOR,MCPY.FOR,MTRA.FOR TMP$:TMPSSP.11 < $ COPY IN$:RINT.FOR,SCMA.FOR,SRMA.FOR,LOC.FOR TMP$:TMPSSP.12- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                      ) * [STANVICK.SEAS$WORK_294000DB]COLROW.FOR;1 +  , B   .     /     4 E       |                   - =    0   1    2   3      K  P   W   O     5 -  6  d@  7 lG#A  8          9          G    H  J                      = C	COLROW.FTN - SAMPLE PROGRAM OF ELEMENTARY MATRIX OPERATIONS 4 C  SRMA		- ADD SCALAR MULTIPLE OF ONE ROW TO ANOTHER C  SCMA	- SAME BUT COLUMNS C  RINT		- INTERCHANGE ROWS  C  CINT		- INTERCHANGE COLUMNS  C  MTRA		- TRANSPOSE OF A MATRIX@ C   ALSO...  MCPY IS CALLED BY MTRA BUT NOT USED IN THIS PROGRAM@ C   ALSO...  MCPY IN TURN CALLS LOC WHICH ISN'T USED HERE EITHER 	DIMENSION A(3,3),C(3,3)$ 	DATA A/2.,1.,-2.,1.,0.,0.,4.,4.,2./ C	LET C = TRANSPOSE OF A 	CALL MTRA(A,C,3,3,0) 0 	TYPE 100, ((A(I,J),J=1,3),(C(I,J),J=1,3),I=1,3)E 100	FORMAT(/' ORIGINAL MATRIX AND ITS TRANSPOSE:'//(3F8.1,10X,3F8.1))  	CALL CINT(A,3,1,2)  	CALL RINT(C,3,3,1,2) 0 	TYPE 101, ((A(I,J),J=1,3),(C(I,J),J=1,3),I=1,3)6 101	FORMAT(//5X'COL 1 <=> COL 2'19X'ROW 1 <=> ROW 2'// 	1(3F8.1,10X,3F8.1)) 	CALL SCMA(A,-2.,3,1,2)  	CALL SRMA(C,-2.,3,3,1,2)  	CALL SCMA(A,-4.,3,1,3)  	CALL SRMA(C,-4.,3,3,1,3) 0 	TYPE 102, ((A(I,J),J=1,3),(C(I,J),J=1,3),I=1,3)E 102	FORMAT(//' COL 2 -2*COL 1 => COL 2'10X' ROW 2 -2*ROW 1 => ROW 2'/ ; 	1' COL 3 -4*COL 1 => COL 3'10X' ROW 3 -4*ROW 1 => ROW 1'//  	2 (3F8.1,10X,3F8.1))  	CALL SRMA(A,2.,3,3,2,3) 	CALL SCMA(C,2.,3,2,3) 	CALL SCMA(A,-4.,3,2,3)  	CALL SRMA(C,-4.,3,3,2,3)  	CALL SRMA(A,0.1,3,3,3,0)  	CALL SCMA(C,0.1,3,3,0) 0 	TYPE 103, ((A(I,J),J=1,3),(C(I,J),J=1,3),I=1,3)< 103	FORMAT(//' 3 TRANSFORMATIONS LATER:'//(3F8.1,10X,3F8.1)) 	STOP 'COLROW successful!' 	END                                                                                                                                                  ( * [STANVICK.SEAS$WORK_294000DB]CORRE.FOR;1 +  , C"   .     /     4 H      
 t                    - =    0   1    2   3      K  P   W   O     5 -  6  GH@  7 @Y#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE CORRE  C  C        PURPOSEF C           COMPUTE MEANS, STANDARD DEVIATIONS, SUMS OF CROSS-PRODUCTS8 C           OF DEVIATIONS, AND CORRELATION COEFFICIENTS. C  C        USAGE5 C           CALL CORRE (N,M,IO,X,XBAR,STD,RX,R,B,D,T)  C " C        DESCRIPTION OF PARAMETERSB C           N     - NUMBER OF OBSERVATIONS. N MUST BE > OR = TO 2.? C           M     - NUMBER OF VARIABLES. M MUST BE > OR = TO 1. . C           IO    - OPTION CODE FOR INPUT DATAH C                   0 IF DATA ARE TO BE READ IN FROM INPUT DEVICE IN THEF C                     SPECIAL SUBROUTINE NAMED DATA.  (SEE SUBROUTINES5 C                     USED BY THIS SUBROUTINE BELOW.) 6 C                   1 IF ALL DATA ARE ALREADY IN CORE.3 C           X     - IF IO=0, THE VALUE OF X IS 0.0. F C                   IF IO=1, X IS THE INPUT MATRIX (N BY M) CONTAINING" C                            DATA.? C           XBAR  - OUTPUT VECTOR OF LENGTH M CONTAINING MEANS. A C           STD   - OUTPUT VECTOR OF LENGTH M CONTAINING STANDARD  C                   DEVIATIONS. C C           RX    - OUTPUT MATRIX (M X M) CONTAINING SUMS OF CROSS- 6 C                   PRODUCTS OF DEVIATIONS FROM MEANS.G C           R     - OUTPUT MATRIX (ONLY UPPER TRIANGULAR PORTION OF THE F C                   SYMMETRIC MATRIX OF M BY M) CONTAINING CORRELATION6 C                   COEFFICIENTS.  (STORAGE MODE OF 1)E C           B     - OUTPUT VECTOR OF LENGTH M CONTAINING T`                                                                                                                   	                        m#] $      RTI020.J                       C"  =  ([STANVICK.SEAS$WORK_294000DB]CORRE.FOR;1                                                                                       H                              	_             HE DIAGONAL > C                   OF THE MATRIX OF SUMS OF CROSS-PRODUCTS OF* C                   DEVIATIONS FROM MEANS./ C           D     - WORKING VECTOR OF LENGTH M. / C           T     - WORKING VECTOR OF LENGTH M.  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDE C           DATA(M,D) - THIS SUBROUTINE MUST BE PROVIDED BY THE USER. C C                       (1) IF IO=0, THIS SUBROUTINE IS EXPECTED TO F C                           FURNISH AN OBSERVATION IN VECTOR D FROM AN2 C                           EXTERNAL INPUT DEVICE.C C                       (2) IF IO=1, THIS SUBROUTINE IS NOT USED BY E C                           CORRE BUT MUST EXIST IN JOB DECK. IF USER E C                           HAS NOT SUPPLIED A SUBROUTINE NAMED DATA, 7 C                           THE FOLLOWING IS SUGGESTED. 0 C                                SUBROUTINE DATA' C                                RETURN $ C                                END C  C        METHOD A C           PRODUCT-MOMENT CORRELATION COEFFICIENTS ARE COMPUTED.  C H C     .................................................................. C 5       SUBROUTINE CORRE (N,M,IO,X,XBAR,STD,RX,R,B,D,T) =       DIMENSION X(1),XBAR(1),STD(1),RX(1),R(1),B(1),D(1),T(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C 3 C     DOUBLE PRECISION XBAR,STD,RX,R,B,T,DSQRT,DABS  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOE C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT AND ABS IN 9 C        STATEMENT 220 MUST BE CHANGED TO DSQRT AND DABS.  C H C        ............................................................... C  C     INITIALIZATION C        DO 100 J=1,M       B(J)=0.0   100 T(J)=0.0       K=(M*M+M)/2        DO 102 I=1,K   102 R(I)=0.0
       FN=N	       L=0  C        IF(IO) 105, 127, 105 C  C     DATA ARE ALREADY IN CORE C    105 DO 108 J=1,M       DO 107 I=1,N       L=L+1    107 T(J)=T(J)+X(L)       XBAR(J)=T(J)   108 T(J)=T(J)/FN C        DO 115 I=1,N
       JK=0       L=I-N        DO 110 J=1,M       L=L+N        D(J)=X(L)-T(J)   110 B(J)=B(J)+D(J)       DO 115 J=1,M       DO 115 K=1,J
       JK=JK+1    115 R(JK)=R(JK)+D(J)*D(K)        GO TO 205  C / C     READ OBSERVATIONS AND CALCULATE TEMPORARY # C     MEANS FROM THESE DATA IN T(J)  C    127 IF(N-M) 130, 130, 135 
   130 KK=N       GO TO 137 
   135 KK=M   137 DO 140 I=1,KK        CALL DATA (M,D)        DO 140 J=1,M       T(J)=T(J)+D(J)       L=L+1    140 RX(L)=D(J)       FKK=KK       DO 150 J=1,M       XBAR(J)=T(J)   150 T(J)=T(J)/FKK  C 4 C     CALCULATE SUMS OF CROSS-PRODUCTS OF DEVIATIONS- C     FROM TEMPORARY MEANS FOR M OBSERVATIONS  C 	       L=0        DO 180 I=1,KK 
       JK=0       DO 170 J=1,M       L=L+1    170 D(J)=RX(L)-T(J)        DO 180 J=1,M       B(J)=B(J)+D(J)       DO 180 K=1,J
       JK=JK+1    180 R(JK)=R(JK)+D(J)*D(K)  C        IF(N-KK) 205, 205, 185 C 6 C     READ THE REST OF OBSERVATIONS ONE AT A TIME, SUM3 C     THE OBSERVATION, AND CALCULATE SUMS OF CROSS- 1 C     PRODUCTS OF DEVIATIONS FROM TEMPORARY MEANS  C 
   185 KK=N-KK        DO 200 I=1,KK 
       JK=0       CALL DATA (M,D)        DO 190 J=1,M       XBAR(J)=XBAR(J)+D(J)       D(J)=D(J)-T(J)   190 B(J)=B(J)+D(J)       DO 200 J=1,M       DO 200 K=1,J
       JK=JK+1    200 R(JK)=R(JK)+D(J)*D(K)  C  C     CALCULATE MEANS  C 
   205 JK=0       DO 210 J=1,M       XBAR(J)=XBAR(J)/FN C 1 C     ADJUST SUMS OF CROSS-PRODUCTS OF DEVIATIONS  C     FROM TEMPORARY MEANS C        DO 210 K=1,J
       JK=JK+1    210 R(JK)=R(JK)-B(J)*B(K)/FN C ( C     CALCULATE CORRELATION COEFFICIENTS C 
       JK=0       DO 220 J=1,M
       JK=JK+J    220 STD(J)= SQRT( ABS(R(JK)))        DO 230 J=1,M       DO 230 K=J,M       JK=J+(K*K-K)/2       L=M*(J-1)+K        RX(L)=R(JK)        L=M*(K-1)+J        RX(L)=R(JK) %       IF(STD(J)*STD(K)) 225, 222, 225    222 R(JK)=0.0        GO TO 230 !   225 R(JK)=R(JK)/(STD(J)*STD(K))    230 CONTINUE C # C     CALCULATE STANDARD DEVIATIONS  C        FN=SQRT(FN-1.0)        DO 240 J=1,M   240 STD(J)=STD(J)/FN C B C     COPY THE DIAGONAL OF THE MATRIX OF SUMS OF CROSS-PRODUCTS OF C     DEVIATIONS FROM MEANS. C 
       L=-M       DO 250 I=1,M
       L=L+M+1    250 B(I)=RX(L)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]CROSS.FOR;1 +  , D   .     /     4 H       D                    - =    0   1    2   3      K  P   W   O     5 -  6  ޑ@  7  o#A  8          9          G    H  J           
             C H C     .................................................................. C  C        SUBROUTINE CROSS  C  C        PURPOSEB C           TO FIND THE CROSSCOVARIANCES OF SERIES A WITH SERIES B% C           (WHICH LEADS AND LAGS A).  C  C        USAGE$ C           CALL CROSS (A,B,N,L,R,S) C " C        DESCRIPTION OF PARAMETERSA C           A    - INPUT VECTOR OF LENGTH N CONTAINING FIRST TIME  C                  SERIES.B C           B    - INPUT VECTOR OF LENGTH N CONTAINING SECOND TIME C                  SERIES., C           N    - LENGTH OF SERIES A AND B.F C           L    - CROSSCOVARIANCE IS CALCULATED FOR LAGS AND LEADS OF$ C                  0, 1, 2,..., L-1.D C           R    - OUTPUT VECTOR OF LENGTH L CONTAINING CROSSCOVARI-5 C                  ANCES OF A WITH B, WHERE B LAGS A. D C           S    - OUTPUT VECTOR OF LENGTH L CONTAINING CROSSCOVARI-6 C                  ANCES OF A WITH B, WHERE B LEADS A. C  C        REMARKSG C           N MUST BE GREATER THAN L.  IF NOT, R(1) AND S(1) ARE SET TO ; C           ZERO AND RETURN IS MADE TO THE CALLING PROGRAM.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           DESCRIBED IN R.B. BLACKMAN AND J.W. TUKEY, 'THE MEASURMENTD C        OF POWER SPECTRA', DOVER PUBLICATIONS INC., NEW YORK, 1959. C H C     .................................................................. C $       SUBROUTINE CROSS (A,B,N,L,R,S)#       DIMENSION A(1),B(1),R(1),S(1)  C * C     CALCULATE AVERAGES OF SERIES A AND B C 
       FN=N       AVERA=0.0        AVERB=0.0        IF(N-L)50,50,100    50 R(1)=0.0       S(1)=0.0       RETURN   100 DO 110 I=1,N       AVERA=AVERA+A(I)   110 AVERB=AVERB+B(I)       AVERA=AVERA/FN       AVERB=AVERB/FN C 2 C     CALCULATE CROSSCOVARIANCES OF SERIES A AND B C        DO 130 J=1,L       NJ=N-J+1       SUMR=0.0       SUMS=0.0       DO 120 I=1,NJ        IJ=I+J-1*       SUMR=SUMR+(A(I)-AVERA)*(B(IJ)-AVERB)*   120 SUMS=SUMS+(A(IJ)-AVERA)*(B(I)-AVERB)       FNJ=NJ       R(J)=SUMR/FNJ    130 S(J)=SUMS/FNJ        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                           % * [STANVICK.SEAS$WORK_294000DB]CS.FOR;1 +  , D   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 S{@  7 u#A  8          9          G    H  J                           C H C     .................................................................. C  C        SUBROUTINE CS C  C        PURPOSE+ C           COMPUTES THE FRESNEL INTEGRALS.  C  C        USAGE C           CALL CS (C,S,X)  C " C        DESCRIPTION OF PARAMETERS- C           C     - THE RESULTANT VALUE C(X). - C           S     - THE RESULTANT VALUE S(X). 5 C           X     - THE ARGUMENT OF FRESNEL INTEGRALS A C                   IF X IS NEGATIVE, THE ABSOLUTE VALUE IS USED.  C  C        REMARKS3 C                                                                                                                                                                                      
                        s{ $      RTI020.J                       D  =  %[STANVICK.SEAS$WORK_294000DB]CS.FOR;1                                                                                          H                              E                     THE ARGUMENT VALUE X REMAINS UNCHANGED.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD  C           DEFINITIONH C           C(X)=INTEGRAL(COS(T)/SQRT(2*LI*T) SUMMED OVER T FROM 0 TO X)H C           S(X)=INTEGRAL(SIN(T)/SQRT(I*LI*T) SUMMED OVER T FROM 0 TO X) C           EVALUATIONB C           USING DIFFERENT APPROXIMATIONS FOR X LESS THAN 4 AND X C           GREATER THAN 4.  C           REFERENCE : C           'COMPUTATION OF FRESNEL INTEGRALS' BY BOERSMA,G C           MATHEMATICAL TABLES AND OTHER AIDS TO COMPUTATION, VOL. 14, ! C           1960, NO. 72, P. 380.  C H C     .................................................................. C        SUBROUTINE CS(C,S,X)       Z=ABS(X)       IF(Z-4.)1,1,2      1 C=SQRT(Z)        S=Z*C        Z=(4.-Z)*(4.+Z) <       C=C*((((((5.100785E-11*Z+5.244297E-9)*Z+5.451182E-7)*Z@      1+3.273308E-5)*Z+1.020418E-3)*Z+1.102544E-2)*Z+1.840965E-1);       S=S*(((((6.677681E-10*Z+5.883158E-8)*Z+5.051141E-6)*Z 1      1+2.441816E-4)*Z+6.121320E-3)*Z+8.026490E-2)        RETURN     2 D=COS(Z)       S=SIN(Z)       Z=4./ZG       A=(((((((8.768258E-4*Z-4.169289E-3)*Z+7.970943E-3)*Z-6.792801E-3) D      1*Z-3.095341E-4)*Z+5.972151E-3)*Z-1.606428E-5)*Z-2.493322E-2)*Z      2-4.444091E-9G       B=((((((-6.633926E-4*Z+3.401409E-3)*Z-7.271690E-3)*Z+7.428246E-3) A      1*Z-4.027145E-4)*Z-9.314910E-3)*Z-1.207998E-6)*Z+1.994711E-1        Z=SQRT(Z)        C=0.5+Z*(D*A+S*B)        S=0.5+Z*(S*A-D*B)        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ' * [STANVICK.SEAS$WORK_294000DB]CSRT.FOR;1 +  , G;   .     /     4 H       2                   - =    0   1    2   3      K  P   W   O     5 -  6 g@  7 @Ŗ#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CSRT C  C        PURPOSE$ C           SORT COLUMNS OF A MATRIX C  C        USAGE# C           CALL CSRT(A,B,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS1 C           A - NAME OF INPUT MATRIX TO BE SORTED ? C           B - NAME OF INPUT VECTOR WHICH CONTAINS SORTING KEY , C           R - NAME OF SORTED OUTPUT MATRIX) C           N - NUMBER OF ROWS IN A AND R < C           M - NUMBER OF COLUMNS IN A AND R AND LENGTH OF B? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A / C           MATRIX R IS ALWAYS A GENERAL MATRIX ' C           M MUST BE GREATER THAN ONE. 4 C	    N MUST BE AT LEAST TWO FOR THE ROUTINE TO WORK C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C           CCPY C  C        METHOD F C           COLUMNS OF INPUT MATRIX A ARE SORTED TO FORM OUTPUT MATRIXH C           R. THE SORTED COLUMN SEQUENCE IS DETERMINED BY THE VALUES OFB C           ELEMENTS IN ROW VECTOR B. THE LOWEST VALUED ELEMENT INF C           B WILL CAUSE THE CORRESPONDING COLUMN OF A TO BE PLACED ING C           THE FIRST COLUMN OF R. THE HIGHEST VALUED ELEMENT OF B WILL E C           CAUSE THE CORRESPONDING ROW OF A TO BE PLACED IN THE LAST < C           COLUMN OF R. IF DUPLICATE VALUES EXIST IN B, THEG C           CORRESPONDING COLUMNS OF A ARE MOVED TO R IN THE SAME ORDER  C           AS IN A. C H C     .................................................................. C #       SUBROUTINE CSRT(A,B,R,N,M,MS)        DIMENSION A(1),B(1),R(1) C > C        MOVE SORTING KEY VECTOR TO FIRST ROW OF OUTPUT MATRIX7 C        AND BUILD ORIGINAL SEQUENCE LIST IN SECOND ROW  C 
       IK=1       DO 10 J=1,M        R(IK)=B(J)       R(IK+1)=J 
    10 IK=IK+N  C D C        SORT ELEMENTS IN SORTING KEY VECTOR (ORIGINAL SEQUENCE LIST$ C        IS RESEQUENCED ACCORDINGLY) C        L=M+1 
    20 ISORT=0        L=L-1 
       IP=1       IQ=N+1       DO 50 J=2,L        IF(R(IQ)-R(IP)) 30,40,40
    30 ISORT=1        RSAVE=R(IQ)        R(IQ)=R(IP)        R(IP)=RSAVE        SAVER=R(IQ+1)        R(IQ+1)=R(IP+1)        R(IP+1)=SAVER 
    40 IP=IP+N 
       IQ=IQ+N     50 CONTINUE       IF(ISORT) 20,60,20 C E C        MOVE COLUMNS FROM MATRIX A TO MATRIX R (NUMBER IN SECOND ROW ? C        OF R REPRESENTS COLUMN NUMBER OF MATRIX A TO BE MOVED)  C     60 IQ=-N        DO 70 J=1,M 
       IQ=IQ+N  C & C        GET COLUMN NUMBER IN MATRIX A C 
       I2=IQ+2        IN=R(I2) C  C        MOVE COLUMN C 
       IR=IQ+1 "       CALL CCPY(A,IN,R(IR),N,M,MS)    70 CONTINUE       RETURN	       END                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]CSUM.FOR;1 +  , G!   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 F@  7  "#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CSUM C  C        PURPOSE: C           SUM ELEMENTS OF EACH COLUMN TO FORM ROW VECTOR C  C        USAGE! C           CALL CSUM(A,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX* C           R - NAME OF VECTOR OF LENGTH M# C           N - NUMBER OF ROWS IN A & C           M - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           VECTOR R CANNOT BE IN THE SAME LOCATION AS MATRIX A  C           UNLESS A IS GENERAL  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD E C           ELEMENTS ARE SUMMED DOWN EACH COLUMN INTO A CORRESPONDING * C           ELEMENT OF OUTPUT ROW VECTOR R C H C     .................................................................. C !       SUBROUTINE CSUM(A,R,N,M,MS)        DIMENSION A(1),R(1)  C        DO 3 J=1,M C  C        CLEAR OUTPUT LOCATION C        R(J)=0.0 C        DO 3 I=1,N C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,J,IJ,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IJ) 2,3,2 C $ C        ACCUMULATE IN OUTPUT VECTOR C      2 R(J)=R(J)+A(IJ)      3 CONTINUE       RETURN	       END                                                                     ' * [STANVICK.SEAS$WORK_294000DB]CTAB.FOR;1 +  , H	   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 #@  7 ~#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CTAB C  C        PURPOSEA C           TABULATE COLUMNS OF A MATRIX TO FORM A SUMMARY MATRIX  C  C        USAGE' C           CALL CTAB(A,B,R,S,N,M,MS,L)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX? C           B - NAME OF INPUT VECTOR OF LENGTH M CONTAINING KEY H C           R - NAME OF OUTPUT MATRIX CONTAINING SUMMARY OF COLUMN DATA.? C               IT IS INITIALLY SET TO ZERO BY THIS SUBROUTINE. E C           S - NAME OF OUTPUT VECTOR OF LENGTH L+1 CONTAINING COUNTS ) C           N - NUMBER OF ROWS IN A AND R & C           M - NUMBER OF COLUMNS IN A& C           L - NUMBER OF COLUMNS IN R? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS/ C           MATRIX R IS ALWAYS A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPRO                                                                                                                                                                                                                                                                                                                                                                                                                                          ?w $      RTI020.J                       H	  =  '[STANVICK.SEAS$WORK_294000DB]CTAB.FOR;1                                                                                        H                                           GRAMS REQUIRED C           LOC  C           CADD C  C        METHOD F C           COLUMNS OF DATA IN MATRIX A ARE TABULATED BASED ON THE KEYG C           CONTAINED IN VECTOR B. THE FLOATING POINT NUMBER IN B(I) IS H C           TRUNCATED TO FORM J. THE ITH COLUMN OF A IS ADDED TO THE JTHH C           COLUMN OF MATRIX R AND ONE IS ADDED TO S(J). IF THE VALUE OF< C           J IS NOT BETWEEN 1 AND L, ONE IS ADDED TO S(L+1)F C           UPON COMPLETION, THE OUTPUT MATRIX R CONTAINS A SUMMARY OFH C           COLUMN DATA AS SPECIFIED BY VECTOR B. EACH ELEMENT IN VECTORD C           S CONTAINS A COUNT OF THE NUMBER OF COLUMNS OF A USED TOF C           FORM R. ELEMENT S(L+1) CONTAINS THE NUMBER OF COLUMNS OF AE C           NOT INCLUDED IN R AS A RESULT OF J BEING LESS THAN ONE OR  C           GREATER THAN L.  C H C     .................................................................. C '       SUBROUTINE CTAB(A,B,R,S,N,M,MS,L) #       DIMENSION A(1),B(1),R(1),S(1)  C  C        CLEAR OUTPUT AREAS  C        CALL LOC(N,L,IT,N,L,0)       DO 10 IR=1,IT     10 R(IR)=0.0        DO 20 IS=1,L    20 S(IS)=0.0        S(L+1)=0.0 C        DO 60 I=1,M  C + C        TEST FOR THE KEY OUTSIDE THE RANGE  C 
       JR=B(I)        IF (JR-1) 50,40,30    30 IF (JR-L) 40,40,50 C  C 6 C        ADD COLUMN OF A TO COLUMN OF R AND 1 TO COUNT C "    40 CALL CADD(A,I,R,JR,N,M,MS,L)       S(JR)=S(JR)+1.0        GO TO 60 C     50 S(L+1)=S(L+1)+1.0     60 CONTINUE       RETURN	       END                                             ' * [STANVICK.SEAS$WORK_294000DB]CTIE.FOR;1 +  , zH  .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7 T#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE CTIE C  C        PURPOSEC C           ADJOIN TWO MATRICES WITH SAME ROW DIMENSION TO FORM ONE ) C           RESULTANT MATRIX (SEE METHOD)  C  C        USAGE* C           CALL CTIE(A,B,R,N,M,MSA,MSB,L) C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX ' C           N - NUMBER OF ROWS IN A,B,R & C           M - NUMBER OF COLUMNS IN A? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSB - SAME AS MSA EXCEPT FOR MATRIX B & C           L - NUMBER OF COLUMNS IN B C  C        REMARKSF C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRICES A OR B/ C           MATRIX R IS ALWAYS A GENERAL MATRIX B C           MATRIX A MUST HAVE THE SAME NUMBER OF ROWS AS MATRIX B C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD ; C           MATRIX B IS ATTACHED TO THE RIGHT OF MATRIX A . B C           THE RESULTANT MATRIX R CONTAINS N ROWS AND M+L COLUMNS C H C     .................................................................. C *       SUBROUTINE CTIE(A,B,R,N,M,MSA,MSB,L)       DIMENSION A(1),B(1),R(1) C 
       MM=M
       IR=0
       MSX=MSA        DO 6 JJ=1,2        DO 5 J=1,MM        DO 5 I=1,N
       IR=IR+1        R(IR)=0.0  C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,J,IJ,N,MM,MSX)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IJ) 2,5,2 C ! C        MOVE ELEMENT TO MATRIX R  C      2 GO TO(3,4),JJ      3 R(IR)=A(IJ) 
       GO TO 5      4 R(IR)=B(IJ)      5 CONTINUE C " C        REPEAT ABOVE FOR MATRIX B C 
       MSX=MSB 
       MM=L     6 CONTINUE       RETURN	       END                                                                                 ( * [STANVICK.SEAS$WORK_294000DB]DASCR.COM;1 +  , H  .     /     4 >                          - =    0   1    2   3      K  P   W   O     5 -  6  @@  7 @8#A  8          9          G    H  J                       > $ COPY IN$:DASCR.FOR,LOC.FOR,SUBST.FOR,TAB1.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                              ( * [STANVICK.SEAS$WORK_294000DB]DASCR.DAT;1 +  , H]  . 	    /     4 (   	   	                     - =    0   1    2   3      K  P   W   O 
    5 -  6 _@  7  #A  8          9          G    H  J                             1 100   4 0(         46        64       173        12(         24        72       170         8(         32        71       154        16(         41        68       129        10(         50        65       192         9(         63        75       203        12(         29        70       122        14(         28        64       136        13(         52        77       147        11(         36        67       153        18(         31        68       165         9(         72        70       178        10(         53        71       205        14(         21        65       219        12(         49        63       150         6(         28        62       160        16(         53        72       161        13(         47        73       142        15(         37        67       193        18(         64        68       156        14(         65        60       114        10(         62        64       153        12(         19        68       225         9(         46        67       158        11(         33        72       121         4(         37        65       132        13(         41        76       148        16(         52        71       123        16(         29        68       128        14(         32        65       155        17(         24        72       172        16(         56        73       163        10(         63        65       158        11(         67        69       146         2(         58        66       171         9(         41        65       153        12(         49        66       165        14(         52        72       172        16(         23        78       183        15(         56        71       195        16(         52        68       118         7(         40        66       165        14(         39        68       215        16(         23        71       154        12(         56        65       149        10(         25        65       162        16(         37        68       152        16(         46        70       159        15(         41        69       137        14(         62        71       163        12(         29        72       191         4(         19        68       168        10(         46        63       158        16(         37        64       139        18(         34        68       156        10(         64        67       153        12(         57        67       141        13(         32        68       157        17(         29        70       183        15(         53        72       164        18(         47        72       156        18(         56        73       160        16(         61        74       169        12(         21        68       161        10(         25        76       178        11(         23        72       157        16(         29        68       186        16(         39        70       159        14(         42        70       154        10(         56        62       159        12(         63        70       177        12(         51        71       161         9(         41        66       158        10(         33        69       158        16(         37        68       157        16(         25        70       163        15(         63        68       159        12(         53        71       202         6(         51        72       167        14(         47        73       164        14(         39        75       151        12(         28        68       166        10(         64        69       156        16(         55        67       144        16(         51        66       177                                                                                                                                                                                                                                                                                                                                                                                                                                                _w $      RTI020.J                       H] =  ([STANVICK.SEAS$WORK_294000DB]DASCR.DAT;1                                                                                       (     	                         /               10(         46        65       157        12(         72        66       125        10(         66        65       131        12(         28        74       149        18(         27        71       168        11(         23        72       158        12(         23        72       163        12(         60        68       157         9(         30        66       142        10(         39        67       162        16(         46        74       154        16(         50        68       158        10(         61        66       161        14(         36        64       157        15(         32        71       156        16 9   2 3  12     65 46      8        120        20       210                                                                                                                                                                                                                                                                                                                                                   ( * [STANVICK.SEAS$WORK_294000DB]DASCR.FOR;1 +  , Is  .     /     4 M                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7  k#A  8          9          G    H  J                       0 C	SAMPLE MAIN PROGRAM FOR DATA SCREENING - DASCR  C  ROUTINES USED: SUBST,TAB1,LOC 	EXTERNAL BOOL> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE7 C	MAXIMUM NUMBER OF ELEMENTS OF THE OBSERVATION MATRIX.  	DIMENSION A(400) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	NUMBER OF CONDITIONS TIMES 3 	DIMENSION C(63)< C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO 3 	DIMENSION UBO(3) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	NUMBER OF OBSERVATIONS.  	DIMENSION S(100) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	NUMBER OF CONDITIONS.  	DIMENSION R(21)> C	THE FOLLOWING DIMENSIONS MST BE GREATER THAN OR EQUAL TO THE0 C	NUMBER OF INTERVALS FOR THE SELECTED VARIABLE. 	DIMENSION FREQ(20),PCT(20) = C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO 5.  	DIMENSION STATS(5) 
 	COMMON IN C	INPUT CHANNEL = IN, 10	FORMAT(////23H DATA SCREENING PROBLEM,I3)@ 11	FORMAT(//45H DIMENSIONED AREA TOO SMALL FOR INPUT MATRIX ,I4)% 12	FORMAT(//21H EXECUTION TERMINATED) > 13	FORMAT(//43H INCORRECT NUMBER OF DATA CARDS FOR MATRIX ,I4)# 14	FORMAT(//19H GO ON TO NEXT CASE)  15	FORMAT(//12H END OF CASE) 16	FORMAT(7(F2.0,F1.0,F7.0)) 17	FORMAT(3F10.0) " 18	FORMAT(//14H SUBSET VECTOR,///) 19	FORMAT(I6,F5.0)6 20	FORMAT(////33H SUMMARY STATISTICS FOR VARIABLE ,I3)E 21	FORMAT(//8H TOTAL =,F10.3,2X,9HAVERAGE =,F10.3,2X,20HSTANDARD DEVI : 	1ATION =,F10.3/12X,9HMINIMUM =,F10.3,2X,9HMAXIMUM =F10.3) 22	FORMAT(2I2) 	KC=0 7 	OPEN (UNIT=1,NAME='IN$:DASCR.DAT',TYPE='OLD',READONLY)  	IN=1 
 24	KC=KC+1$ 	CALL MATIN(ICOD,A,400,NO,NV,MS,IER) 	IF(NO) 25,50,25 25	IF(IER-1) 40,30,35  30	TYPE 11, ICOD 	TYPE 14	 	GO TO 24 
 35	TYPE 13 	TYPE 12	 	GO TO 60  40	READ(IN,22) NC,NOVAR  	JC=NC*3 	READ(IN,16) (C(I),I=1,JC) 	READ(IN,17) (UBO(I),I=1,3) " 	CALL SUBST(A,C,R,BOOL,S,NO,NV,NC) 	TYPE 10, KC 	TYPE 18
 	DO 50 I=1,NO  50	TYPE 19, I,S(I). 	CALL TAB1(A,S,NOVAR,UBO,FREQ,PCT,STATS,NO,NV) 	TYPE 20, NOVAR  	TYPE 21, (STATS(I),I=1,5)
 	JZ=UBO(2) 	CALL HIST(KC,FREQ,JZ) 	TYPE 15	 	GO TO 24  60	STOP 'unexpected' 	END 	SUBROUTINE BOOL(R,T)  	DIMENSION R(1)  	L1=1  	L2=2  	T=R(L1)*R(L2) 	RETURN  	END C M C............................................................................  C  C	SUBROUTINE HIST  C 	 C	PURPOSE 5 C	  PRINT A HISTOGRAM OF FREQUENCIES VERSUS INTERVALS  C  C	USAGE  C	  CALL HIST(NU,FREQ,IN)  C  C	DESCRIPTION OF PARAMETERS $ C	  NU	- HISTOGRAM NUMBER (3 DIGITS)  C	  FREQ	- VECTOR OF FREQUENCIES; C	  IN	- NUMBER OF INTERVALS AND LENGTH OF FREQ (MAX IS 20) : C		  NORMALLY, FREQ(1) CONTAINS THE FREQUENCY SMALLER THAT8 C		  THE LOWER BOUND AND FREQ(IN) CONTAINS THE FREQUENCY  C		  LARGER THAN THE UPPER BOUND C 	 C	REMARKS ( C	  FREQUENCIES MUST BE POSITIVE NUMBERS C / C	SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED  C	  NONE C  C	METHOD; C	  THE LARGEST FREQUENCY IS DETERMINED AND SCALING IS USED  C	  IF REQUIRED  C  C.I C........................................................................  C  	SUBROUTINE HIST(NU,FREQ,INN)  	DIMENSION JOUT(20),FREQ(20)
 	COMMON IN 	DATA K,IBLNK/'*',' '// 1	FORMAT(' EACH ',A1,' EQUALS ',I2,' POINTS',/)  2	FORMAT(I6,4X,20(2X,A1))  3	FORMAT(' INTERVAL '20I3)" 4	FORMAT(///,33X,' HISTOGRAM ',I3) 5	FORMAT(//,10H FREQUENCY,20I3)  6	FORMAT(' CLASS') 7	FORMAT(8('----------')) " C	PRINT TITLE AND FREQUENCY VECTOR 	TYPE 4, NU  	DO 12 I=1,INN 12	JOUT(I)=FREQ(I) 	TYPE 5, (JOUT(I),I=1,INN) 	TYPE 7  C	FIND THE LARGEST FREQUENCY	 	FMAX=0.0  	DO 20 I=1,INN 	IF(FREQ(I)-FMAX) 20,20,15 15	FMAX=FREQ(I)  20	CONTINUE  C	SCALE IF NECESSARY 	JSCAL=1 	IF(FMAX-50.0) 40,40,30  30	JSCAL= (FMAX+49.0)/50.0 	TYPE 1, K,JSCAL C	CLEAR OUTPUT AREA TO BLANKS  40	DO 50 I=1,INN 50	JOUT(I)=IBLNK% C	LOCATE FREQUENCIES IN EACH INTERVAL  	MAX=FMAX/FLOAT(JSCAL) 	DO 80 I=1,MAX 	X=MAX-(I-1) 	DO 70 J=1,INN$ 	IF(FREQ(J)/FLOAT(JSCAL)-X) 70,60,60 60	JOUT(J)=K 70	CONTINUE  	IX=X*FLOAT(JSCAL) C	PRINT LINE OF FREQUENCIES  80	TYPE 2, IX,(JOUT(J),J=1,INN)  C	GENERATE CONSTANTS 	DO 90 I=1,INN 90	JOUT(I)=I C	PRINT INTERVAL NUMBERS 	TYPE 7  	TYPE 3, (JOUT(J),J=1,INN) 	TYPE 6  	RETURN  	ENDI C........................................................................  C  C	SUBROUTINE MATIN C 	 C	PURPOSE < C	  READS CONTROL CARD AND MATRIX DATA ELEMENTS FORM LOGICAL
 C	  UNIT 'IN'  C  C	USAGE . C	  CALL MATIN(ICODE,A,ISIZE,IROW,ICOL,IS,IER) C  C	DESCRIPTION OF PARAMETERS D C	  ICODE -UPON RETURN, ICODE WILL CONTAIN FOUR DIGIT IDENTIFICATION# C		 CODE FROM MATRIX PARAMETER CARD ! C	  A	-DATA AREA FOR INPUT MATRIX < C	  ISIZE	-NUMBER OF ELEMENTS DIMENSIONED BY USER FOR AREA A; C	  IROW	-UPON RETURN, IROW WILL CONTAIN ROW DIMENSION FROM  C		 MATRIX PARAMETER CARD > C	  ICOL	-UPON RETURN, ICOL WILL CONTAIN COLUMN DIMENSION FROM C		 MATRIX PARAMETER CARD ; C	  IS	-UPON RETURN, IS WILL CONTAIN STORAGE MODE CODE FROM  C		 MATRIX PARAMETER CARD WHERE  C		 IS=0  GENERAL MATRIX C		 IS=1  SYMMETRIC MATRIX C		 IS=2  DIAGONAL MATRIX : C	  IER	-UPON RETURN, IER WILL CONTAIN AN ERROR CODE WHERE C		 IER=0  NO ERROR 7 C		 IER=1  ISIZE IS LESS THAN THE NUMBER OF ELEMENTS IN  C			INPUT MATRIX) C		 IER=2  INCORREDT NUMBER OF DATA CARDS  C 	 C	REMARKS  C	  NONE C / C	SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED  C	  LOC  C  C	METHOD< C	SUBROUTINE ASSUMES THAT INPUT MATRIX CONSISTS OF PARAMETER2 C	CARD FOLLOWED BY DATA CARDS (OR LINES IN A FILE)) C	PARAMETER CARD HAS THE FOLLOWING FORMAT  C	  COL. 1- 2  BLANK2 C	  COL. 3- 6  UP TO FOR DIGIT IDENTIFICATION CODE' C	  COL. 7-10  NUMBER OF ROWS IN MATRIX * C	  COL.11-14  NUMBER OF COLUMNS IN MATRIX6 C	  COL.15-16  STORAGE MODE OF MATRIX (SEE 'IS' ABOVE)B C	DATA CARDS ARE ASSUMED TO HAVE SEVEN FIELDS OF TEN COLUMNS EACH.? C	DECIMAL POINTS MAY APPEAR ANYWHERE IN A FIELD.  IF NO DECIMAL C C	POINT IS INCLUDED, IT IS ASSUMED THAT THE DECIMAL POINT IS AT THE C C	END OF THE 10 COLUMN FIELD.  NUMBER IN EACH FIELD MAY BE PRECEDED > C	BY BLANKS.  DATA ELEMENTS MUST BE PUNCHED BY ROW.  A ROW MAY> C	CONTINUE FROM CARD TO CARD.  HOWEVER EACH NEW ROW MUST STARTA C	IN THE FIRST FIELD OF THE NEXT CARD.  ONLY THE UPPER TRIANGULAR = C	PORTION OF A SYMMETRIC MATRIX OR THE DIAGONAL ELEMENTS OF A D C	DIAGONAL MATRIX ARE CONTAINED ON DATA CARDS.  THE FIRST ELEMENT OFG C	EACH NEW ROW WILL BE THE DIAGONAL ELEMENT FOR A MATRIX WITH SYMMETRIC F C	OR DIAGONAL STORAGE MODE.  THE LAST DATA CARD FOR ANY MATRIX MUST BEG C	FOLLOWED BY A CARD WITH A 9 PUNCH IN COLUMN 1.  THE ROUTINE WILL HALT % C	IF THE PARAMETER CARD IS BLANK.....  C I C........................................................................ 1 	SUBROUTINE MATIN(ICODE,A,ISIZE,IROW,ICOL,IS,IER)  	DIMENSION A(1)  	DIMENSION CARD(8)
 	COMMON IN 1	FORMAT(7F10.0) 2	FORMAT(I6,2I4,I2)  3	FORMAT(I1) 	IDC=7 	IER=0 	READ(IN,2) ICODE,IROW,ICOL,IS& 	CALL LOC(IROW,ICOL,ICNT,IROW,ICOL,IS)# C  ***** HERE IS THE STOP MORE DATA , 	IF(ICOL+IROW.EQ.0) STOP 'DASCR successful!' 	IF(ISIZE-ICNT) 6,7,7  6	IER=1  7	IF(ICNT) 38,38,8 8	ICOLT=ICOL 	IROCR=1% C	COMPUTE NUMBER OF CARS FOR THIS ROW  11	IRCDS=(ICOLT-1)/IDC+1 	IF(IS-1) 15,1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                        R $      RTI020.J                       Is =  ([STANVICK.SEAS$WORK_294000DB]DASCR.FOR;1                                                                                       M                             Y             5,12
 12	IRCDS=1( C	SET UP LOOP FOR NUMBER OF CARDS IN ROW 15	DO 31 K=1,IRCDS 	READ(IN,1) (CARD(I),I=1,IDC) 1 C	SKIP THROUGH DATA CARDS IF INPUT AREA TOO SMALL  	IF(IER) 16,16,31  16	L=07 C	COMPUTE COLUMN NUMBER FOR FIRST FIELD IN CURRENT CARD  	JS=(K-1)*IDC+ICOL-ICOLT+1 	JE=JS+IDC-1 	IF(IS-1) 19,19,17 17	JF=JS+ C	SET UP LOOP FOR DATA ELEMENTS WITHIN CARD  19	DO 30 J=JS,JE 	IF(J-ICOL) 20,20,31$ 20	CALL LOC(IROCR,J,IJ,IROW,ICOL,IS) 	L=L+1 30	A(IJ)=CARD(L) 31	CONTINUE  	IROCR=IROCR+1 	IF(IROW-IROCR) 38,35,35 35	IF(IS-1) 37,36,36 36	ICOLT=ICOLT-1 37	GO TO 11  38	READ(IN,3) ICARD  	IF(ICARD-9) 39,40,39  39	IER=2	 40	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                                                ' * [STANVICK.SEAS$WORK_294000DB]DCLA.FOR;1 +  , I   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  @  7 @A)#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE DCLA C  C        PURPOSEC C           SET EACH DIAGONAL ELEMENT OF A MATRIX EQUAL TO A SCALAR  C  C        USAGE  C           CALL DCLA (A,C,N,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX C           C - SCALAR6 C           N - NUMBER OF ROWS AND COLUMNS IN MATRIX A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS0 C           INPUT MATRIX MUST BE A SQUARE MATRIX C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD F C           EACH ELEMENT ON DIAGONAL OF MATRIX IS REPLACED BY SCALAR C C H C     .................................................................. C        SUBROUTINE DCLA(A,C,N,MS)        DIMENSION A(1) C        DO 3 I=1,N C < C        LOCATE DIAGONAL ELEMENT FOR ANY MATRIX STORAGE MODE C        CALL LOC(I,I,ID,N,N,MS)  C " C        REPLACE DIAGONAL ELEMENTS C 
     3 A(ID)=C        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]DCPY.FOR;1 +  , L   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @  7 ;#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE DCPY C  C        PURPOSE< C           COPY DIAGONAL ELEMENTS OF A MATRIX INTO A VECTOR C  C        USAGE  C           CALL DCPY (A,R,N,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX1 C           R - NAME OF OUTPUT VECTOR OF LENGTH N 6 C           N - NUMBER OF ROWS AND COLUMNS IN MATRIX A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS0 C           INPUT MATRIX MUST BE A SQUARE MATRIX C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD E C           ELEMENTS ON DIAGONAL OF MATRIX ARE MOVED TO CORRESPONDING ! C           POSITIONS OF VECTOR R  C H C     .................................................................. C        SUBROUTINE DCPY(A,R,N,MS)        DIMENSION A(1),R(1)  C        DO 3 J=1,N C < C        LOCATE DIAGONAL ELEMENT FOR ANY MATRIX STORAGE MODE C        CALL LOC(J,J,IJ,N,N,MS)  C * C        MOVE DIAGONAL ELEMENT TO VECTOR R C      3 R(J)=A(IJ)       RETURN	       END                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]DISCR.FOR;1 +  , ND   .     /     4 H                          - =    0   1    2   3      K  P   W   O 
    5 -  6 y@  7 fO#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE DISCR  C  C        PURPOSED C           COMPUTE A SET OF LINEAR FUNCTIONS WHICH SERVE AS INDICESE C           FOR CLASSIFYING AN INDIVIDUAL INTO ONE OF SEVERAL GROUPS. B C           NORMALLY THIS SUBROUTINE IS USED IN THE PERFORMANCE OF" C           DISCRIMINANT ANALYSIS. C  C        USAGE6 C           CALL DISCR (K,M,N,X,XBAR,D,CMEAN,V,C,P,LG) C " C        DESCRIPTION OF PARAMETERSA C           K     - NUMBER OF GROUPS. K MUST BE GREATER THAN ONE. ' C           M     - NUMBER OF VARIABLES G C           N     - INPUT VECTOR OF LENGTH K CONTAINING SAMPLE SIZES OF  C                   GROUPS. F C           X     - INPUT VECTOR CONTAINING DATA IN THE MANNER EQUIVA-D C                   LENT TO A 3-DIMENSIONAL FORTRAN ARRAY, X(1,1,1),D C                   X(2,1,1), X(3,1,1), ETC.  THE FIRST SUBSCRIPT ISH C                   CASE NUMBER, THE SECOND SUBSCRIPT IS VARIABLE NUMBERA C                   AND THE THIRD SUBSCRIPT IS GROUP NUMBER.  THE F C                   LENGTH OF VECTOR X IS EQUAL TO THE TOTAL NUMBER OFC C                   DATA POINTS, T*M, WHERE T = N(1)+N(2)+...+N(K). H C           XBAR  - INPUT MATRIX (M X K) CONTAINING MEANS OF M VARIABLES C                   IN K GROUPS B C           D     - INPUT MATRIX (M X M) CONTAINING THE INVERSE OF- C                   POOLED DISPERSION MATRIX. F C           CMEAN - OUTPUT VECTOR OF LENGTH M CONTAINING COMMON MEANS.F C           V     - OUTPUT VARIABLE CONTAINING GENERALIZED MAHALANOBIS C                   D-SQUARE. G C           C     - OUTPUT MATRIX (M+1 X K) CONTAINING THE COEFFICIENTS E C                   OF DISCRIMINANT FUNCTIONS.  THE FIRST POSITION OF D C                   EACH COLUMN (FUNCTION) CONTAINS THE VALUE OF THE/ C                   CONSTANT FOR THAT FUNCTION. G C           P     - OUTPUT VECTOR CONTAINING THE PROBABILITY ASSOCIATED H C                   WITH THE LARGEST DISCRIMINANT FUNCTIONS OF ALL CASESH C                   IN ALL GROUPS.  CALCULATED RESULTS ARE STORED IN THEB C                   MANNER EQUIVALENT TO A 2-DIMENSIONAL AREA (THEB C                   FIRST SUBSCRIPT IS CASE NUMBER, AND THE SECONDD C                   SUBSCRIPT IS GROUP NUMBER).  VECTOR P HAS LENGTHH C                   EQUAL TO THE TOTAL NUMBER OF CASES, T (T = N(1)+N(2) C                   +...+N(K)). B C           LG    - OUTPUT VECTOR CONTAINING THE SUBSCRIPTS OF THEF C                   LARGEST DISCRIMINANT FUNCTIONS STORED IN VECTOR P.E C                   THE LENGTH OF VECTOR LG IS THE SAME AS THE LENGTH   C                   OF VECTOR P. C  C        REMARKSD C           THE NUMBER OF VARIABLES MUST BE GREATER THAN OR EQUAL TO! C           THE NUMBER OF GROUPS.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           REFER TO 'BMD COMPUTER PROGRAMS MANUAL', EDITED BY W. J.C C           DIXON, UCLA, 1964, AND T. W. ANDERSON, 'INTRODUCTION TO D C           MULTIVARIATE STATISTICAL ANALYSIS', JOHN WILEY AND SONS," C           1958, SECTION 6.6-6.8. C H C     .................................................................. C 6       SUBROUTINE DISCR (K,M,N,X,XBAR,D,CMEAN,V,C,P,LG)?       DIMENSION N(1),X(1),XBAR(1),D(1),CMEAN(1),C(1),P(1),LG(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLO                                                                                                                                                                                                                                                                                                                                                                                                                                           |] $      RTI020.J                       ND  =  ([STANVICK.SEAS$WORK_294000DB]DISCR.FOR;1                                                                                       H                               
            WS.  C 0 C     DOUBLE PRECISION XBAR,D,CMEAN,V,C,SUM,P,PL C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOF C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  EXP IN STATEMENT% C        250 MUST BE CHANGED TO DEXP.  C H C        ............................................................... C  C     CALCULATE COMMON MEANS C 
       N1=N(1)        DO 100 I=2,K   100 N1=N1+N(I)       FNT=N1       DO 110 I=1,K   110 P(I)=N(I)        DO 130 I=1,M       CMEAN(I)=0       N1=I-M       DO 120 J=1,K
       N1=N1+M %   120 CMEAN(I)=CMEAN(I)+P(J)*XBAR(N1)    130 CMEAN(I)=CMEAN(I)/FNT  C 0 C     CALCULATE GENERALIZED MAHALANOBIS D SQUARE C 	       L=0        DO 140 I=1,K       DO 140 J=1,M       L=L+1    140 C(L)=XBAR(L)-CMEAN(J)        V=0.0 	       L=0        DO 160 J=1,M       DO 160 I=1,M       N1=I-M       N2=J-M
       SUM=0.0        DO 150 IJ=1,K 
       N1=N1+M 
       N2=N2+M    150 SUM=SUM+P(IJ)*C(N1)*C(N2)        L=L+1    160 V=V+D(L)*SUM C : C     CALCULATE THE COEFFICIENTS OF DISCRIMINANT FUNCTIONS C 
       N2=0       DO 190 KA=1,K        DO 170 I=1,M
       N2=N2+1    170 P(I)=XBAR(N2)        IQ=(M+1)*(KA-1)+1 
       SUM=0.0        DO 180 J=1,M       N1=J-M       DO 180 L=1,M
       N1=N1+M    180 SUM=SUM+D(N1)*P(J)*P(L)        C(IQ)=-(SUM/2.0)       DO 190 I=1,M       N1=I-M
       IQ=IQ+1        C(IQ)=0.0        DO 190 J=1,M
       N1=N1+M    190 C(IQ)=C(IQ)+D(N1)*P(J) C . C     FOR EACH CASE IN EACH GROUP, CALCULATE.. C  C        DISCRIMINANT FUNCTIONS  C 
       LBASE=0 
       N1=0       DO 270 KG=1,K        NN=N(KG)       DO 260 I=1,NN        L=I-NN+LBASE       DO 200 J=1,M       L=L+NN   200 D(J)=X(L) 
       N2=0       DO 220 KA=1,K 
       N2=N2+1        SUM=C(N2)        DO 210 J=1,M
       N2=N2+1    210 SUM=SUM+C(N2)*D(J)   220 XBAR(KA)=SUM C * C        THE LARGEST DISCRIMINANT FUNCTION C 	       L=1        SUM=XBAR(1)        DO 240 J=2,K#       IF(SUM-XBAR(J)) 230, 240, 240 	   230 L=J        SUM=XBAR(J)    240 CONTINUE C F C        PROBABILITY ASSOCIATED WITH THE LARGEST DISCRIMINANT FUNCTION C        PL=0.0       DO 250 J=1,K   250 PL=PL+ EXP(XBAR(J)-SUM) 
       N1=N1+1        LG(N1)=L   260 P(N1)=1.0/PL   270 LBASE=LBASE+NN*M C        RETURN	       END                                                                                                 ( * [STANVICK.SEAS$WORK_294000DB]DMATX.FOR;1 +  , Nd   . 	    /     4 H   	                       - =    0   1    2   3      K  P   W   O     5 -  6 2o@  7  ro#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE DMATX  C  C        PURPOSEA C           COMPUTE MEANS OF VARIABLES IN EACH GROUP AND A POOLED D C           DISPERSION MATRIX FOR ALL THE GROUPS. NORMALLY THIS SUB-H C           ROUTINE IS USED IN THE PERFORMANCE OF DISCRIMINANT ANALYSIS. C  C        USAGE- C           CALL DMATX (K,M,N,X,XBAR,D,CMEAN)  C " C        DESCRIPTION OF PARAMETERS$ C           K     - NUMBER OF GROUPSA C           M     - NUMBER OF VARIABLES (MUST BE THE SAME FOR ALL  C                   GROUPS).G C           N     - INPUT VECTOR OF LENGTH K CONTAINING SAMPLE SIZES OF  C                   GROUPS. F C           X     - INPUT VECTOR CONTAINING DATA IN THE MANNER EQUIVA-D C                   LENT TO A 3-DIMENSIONAL FORTRAN ARRAY, X(1,1,1),D C                   X(2,1,1), X(3,1,1), ETC.  THE FIRST SUBSCRIPT ISH C                   CASE NUMBER, THE SECOND SUBSCRIPT IS VARIABLE NUMBERA C                   AND THE THIRD SUBSCRIPT IS GROUP NUMBER.  THE F C                   LENGTH OF VECTOR X IS EQUAL TO THE TOTAL NUMBER OFC C                   DATA POINTS, T*M, WHERE T = N(1)+N(2)+...+N(K). G C           XBAR  - OUTPUT MATRIX (M X K) CONTAINING MEANS OF VARIABLES   C                   IN K GROUPS.G C           D     - OUTPUT MATRIX (M X M) CONTAINING POOLED DISPERSION. / C           CMEAN - WORKING VECTOR OF LENGTH M.  C  C        REMARKSD C           THE NUMBER OF VARIABLES MUST BE GREATER THAN OR EQUAL TO! C           THE NUMBER OF GROUPS.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           REFER TO 'BMD COMPUTER PROGRAMS MANUAL', EDITED BY W. J.C C           DIXON, UCLA, 1964, AND T. W. ANDERSON, 'INTRODUCTION TO D C           MULTIVARIATE STATISTICAL ANALYSIS', JOHN WILEY AND SONS," C           1958, SECTION 6.6-6.8. C H C     .................................................................. C -       SUBROUTINE DMATX (K,M,N,X,XBAR,D,CMEAN) /       DIMENSION N(1),X(1),XBAR(1),D(1),CMEAN(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C # C     DOUBLE PRECISION XBAR,D,CMEAN  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C H C        ............................................................... C  C     INITIALIZATION C        MM=M*M       DO 100 I=1,MM    100 D(I)=0.0 C  C     CALCULATE MEANS  C 
       N4=0	       L=0 
       LM=0       DO 160 NG=1,K        N1=N(NG)       FN=N1        DO 130 J=1,M
       LM=LM+1        XBAR(LM)=0.0       DO 120 I=1,N1        L=L+1    120 XBAR(LM)=XBAR(LM)+X(L)   130 XBAR(LM)=XBAR(LM)/FN C 4 C     CALCULATE SUMS OF CROSS-PRODUCTS OF DEVIATIONS C        LMEAN=LM-M       DO 150 I=1,N1        LL=N4+I-N1       DO 140 J=1,M       LL=LL+N1       N2=LMEAN+J   140 CMEAN(J)=X(LL)-XBAR(N2) 
       LL=0       DO 150 J=1,M       DO 150 JJ=1,M 
       LL=LL+1 $   150 D(LL)=D(LL)+CMEAN(J)*CMEAN(JJ)   160 N4=N4+N1*M C , C     CALCULATE THE POOLED DISPERSION MATRIX C        LL=-K        DO 170 I=1,K   170 LL=LL+N(I)       FN=LL        DO 180 I=1,MM    180 D(I)=D(I)/FN C        RETURN	       END                                                                                                             ( * [STANVICK.SEAS$WORK_294000DB]EIGEN.FOR;1 +  , N   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 cf@  7  H#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE EIGEN  C  C        PURPOSED C           COMPUTE EIGENVALUES AND EIGENVECTORS OF A REAL SYMMETRIC C           MATRIX C  C        USAGE  C           CALL EIGEN(A,R,N,MV) C " C        DESCRIPTION OF PARAMETERSF C           A - ORIGINAL MATRIX (SYMMETRIC), DESTROYED IN COMPUTATION.B C               RESULTANT EIGENVALUES ARE DEVELOPED IN DIAGONAL OF- C               MATRIX A IN DESCENDING ORDER. D C           R - RESULTANT MATRIX OF EIGENVECTORS (STORED COLUMNWISE,0 C               IN SAME SEQUENCE AS EIGENVALUES)) C           N - ORDER OF MATRICES A AND R  C           MV- INPUT CODE< C                   0   COMPUTE EIGENVALUES AND EIGENVECTORS? C                   1   COMPUTE EIGENVALUES ONLY (R NEED NOT BE D C                       DIMENSIONED BUT MUST STILL APPEAR IN CALLING! C                       SEQUENCE)  C  C        REMARKSE C           ORIGINAL MATRIX A MUST BE REAL SYMMETRIC (STORAGE MODE=1) ? C           MATRIX A CANNOT BE IN THE SAME LOCATION AS MATRIX R  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD C C           DIAGONALIZATION METHOD ORIGINATED BY JACOBI AND ADAPTED H C           BY VON NEUMANN FOR LARGE COMPUTERS AS FOUND IN 'MATHEMATICALD C           METHODS FOR DIGITAL COMPUTERS', EDITED BY A. RALSTON ANDE C           H.S. WILF, JOHN WILEY AND SONS, NEW YORK, 1962, CHAPTER 7  C H C     .................................................................. C         SUBROUTINE EIGEN(A,R,N,MV)       DIMENSION A(1),R(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C ? C     DOUBLE PRECISION A,R,ANORM,ANRMX,THR,X,Y,SINX,SINX2,COSX, 3 C    1                 COSX2,SINCS,RANGE,DSQRT,DABS  C D C        THE C MUST ALSO BE REMOVED FROM                                                                                                                                                                                                            $      RTI020.J                       N  =  ([STANVICK.SEAS$WORK_294000DB]EIGEN.FOR;1                                                                                       H                                            DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOH C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENTSG C        40, 68, 75, AND 78 MUST BE CHANGED TO DSQRT.  ABS IN STATEMENT G C        62 MUST BE CHANGED TO DABS. THE CONSTANT IN STATEMENT 5 SHOULD  C        BE CHANGED TO 1.0D-12.  C H C        ............................................................... C ! C        GENERATE IDENTITY MATRIX  C      5 RANGE=1.0E-6       IF(MV-1) 10,25,10     10 IQ=-N        DO 20 J=1,N 
       IQ=IQ+N        DO 20 I=1,N 
       IJ=IQ+I        R(IJ)=0.0        IF(I-J) 20,15,20    15 R(IJ)=1.0     20 CONTINUE C ; C        COMPUTE INITIAL AND FINAL NORMS (ANORM AND ANORMX)  C     25 ANORM=0.0        DO 35 I=1,N        DO 35 J=I,N        IF(I-J) 30,35,30    30 IA=I+(J*J-J)/2       ANORM=ANORM+A(IA)*A(IA)     35 CONTINUE       IF(ANORM) 165,165,40    40 ANORM=1.414*SQRT(ANORM)         ANRMX=ANORM*RANGE/FLOAT(N) C 9 C        INITIALIZE INDICATORS AND COMPUTE THRESHOLD, THR  C        IND=0        THR=ANORM     45 THR=THR/FLOAT(N)	    50 L=1     55 M=L+1  C  C        COMPUTE SIN AND COS C     60 MQ=(M*M-M)/2       LQ=(L*L-L)/2
       LM=L+MQ #    62 IF( ABS(A(LM))-THR) 130,65,65     65 IND=1 
       LL=L+LQ 
       MM=M+MQ        X=0.5*(A(LL)-A(MM)) %    68 Y=-A(LM)/ SQRT(A(LM)*A(LM)+X*X)        IF(X) 70,75,75
    70 Y=-Y.    75 SINX=Y/ SQRT(2.0*(1.0+( SQRT(1.0-Y*Y))))       SINX2=SINX*SINX     78 COSX= SQRT(1.0-SINX2)        COSX2=COSX*COSX        SINCS =SINX*COSX C  C        ROTATE L AND M COLUMNS  C        ILQ=N*(L-1)        IMQ=N*(M-1)        DO 125 I=1,N       IQ=(I*I-I)/2       IF(I-L) 80,115,80     80 IF(I-M) 85,115,90 
    85 IM=I+MQ        GO TO 95
    90 IM=M+IQ     95 IF(I-L) 100,105,105 
   100 IL=I+LQ        GO TO 110 
   105 IL=L+IQ    110 X=A(IL)*COSX-A(IM)*SINX !       A(IM)=A(IL)*SINX+A(IM)*COSX 
       A(IL)=X    115 IF(MV-1) 120,125,120   120 ILR=ILQ+I        IMR=IMQ+I        X=R(ILR)*COSX-R(IMR)*SINX $       R(IMR)=R(ILR)*SINX+R(IMR)*COSX       R(ILR)=X   125 CONTINUE       X=2.0*A(LM)*SINCS !       Y=A(LL)*COSX2+A(MM)*SINX2-X !       X=A(LL)*SINX2+A(MM)*COSX2+X 3       A(LM)=(A(LL)-A(MM))*SINCS+A(LM)*(COSX2-SINX2) 
       A(LL)=Y 
       A(MM)=X  C  C        TESTS FOR COMPLETION  C ! C        TEST FOR M = LAST COLUMN  C    130 IF(M-N) 135,140,135    135 M=M+1        GO TO 60 C - C        TEST FOR L = SECOND FROM LAST COLUMN  C    140 IF(L-(N-1)) 145,150,145    145 L=L+1        GO TO 55   150 IF(IND-1) 160,155,160    155 IND=0        GO TO 50 C * C        COMPARE THRESHOLD WITH FINAL NORM C    160 IF(THR-ANRMX) 165,165,45 C * C        SORT EIGENVALUES AND EIGENVECTORS C    165 IQ=-N        DO 185 I=1,N
       IQ=IQ+N        LL=I+(I*I-I)/2       JQ=N*(I-2)       DO 185 J=I,N
       JQ=JQ+N        MM=J+(J*J-J)/2!       IF(A(LL)-A(MM)) 170,185,185 
   170 X=A(LL)        A(LL)=A(MM) 
       A(MM)=X        IF(MV-1) 175,185,175   175 DO 180 K=1,N       ILR=IQ+K       IMR=JQ+K       X=R(ILR)       R(ILR)=R(IMR)    180 R(IMR)=X   185 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                         ' * [STANVICK.SEAS$WORK_294000DB]EXPI.FOR;1 +  , !O$   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 F@  7 #A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE EXPI C  C        PURPOSE5 C           COMPUTES THE EXPONENTIAL INTEGRAL -EI(-X)  C  C        USAGE  C           CALL EXPI(X,RES,AUX) C " C        DESCRIPTION OF PARAMETERS4 C           X     - ARGUMENT OF EXPONENTIAL INTEGRAL  C           RES   - RESULT VALUE- C           AUX   - RESULTANT AUXILIARY VALUE  C  C        REMARKS( C           X GT 87 MAY CAUSE UNDERFLOW ) C           WITH THE EXPONENTIAL FUNCTION 7 C           FOR X = 0 THE RESULT VALUE IS SET TO -1.E37  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD  C           DEFINITIONF C           RES=INTEGRAL(EXP(-T)/T, SUMMED OVER T FROM X TO INFINITY). C           EVALUATIONC C           THREE DIFFERENT RATIONAL APPROXIMATIONS ARE USED IN THE B C           RANGES 1 LE X, X LE -9 AND -9 LT X LE -3 RESPECTIVELY,? C           A POLYNOMIAL APPROXIMATION IS USED IN -3 LT X LT 1.  C H C     .................................................................. C         SUBROUTINE EXPI(X,RES,AUX)       IF(X-1.)2,1,1      1 Y=1./XC       AUX=1.-Y*(((Y+3.377358E0)*Y+2.052156E0)*Y+2.709479E-1)/((((Y* G      11.072553E0+5.716943E0)*Y+6.945239E0)*Y+2.593888E0)*Y+2.709496E-1)        RES=AUX*Y*EXP(-X)        RETURN     2 IF(X+3.)6,6,3 H     3 AUX=(((((((7.122452E-7*X-1.766345E-6)*X+2.928433E-5)*X-2.335379E-4E      1)*X+1.664156E-3)*X-1.041576E-2)*X+5.555682E-2)*X-2.500001E-1)*X       2+9.999999E-1       RES=-1.E37       IF(X)4,5,4(     4 RES=X*AUX-ALOG(ABS(X))-5.772157E-1     5 RETURN     6 IF(X+9.)8,8,7 H     7 AUX=1.-((((5.176245E-2*X+3.061037E0)*X+3.243665E1)*X+2.244234E2)*XB      1+2.486697E2)/((((X+3.995161E0)*X+3.893944E1)*X+2.263818E1)*X      2+1.807837E2)       GOTO 9     8 Y=9./XC       AUX=1.-Y*(((Y+7.659824E-1)*Y-7.271015E-1)*Y-1.080693E0)/((((Y G      1*2.518750E0+1.122927E1)*Y+5.921405E0)*Y-8.666702E0)*Y-9.724216E0)      9 RES=AUX*EXP(-X)/X        RETURN	       END                                 ( * [STANVICK.SEAS$WORK_294000DB]EXPON.COM;1 +  , Z   .     /     4 -                          - =    0   1    2   3      K  P   W   O     5 -  6   @  7 `#A  8          9          G    H  J                       - $ COPY IN$:EXPON.FOR,EXSMO.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                              ( * [STANVICK.SEAS$WORK_294000DB]EXPON.DAT;1 +  , Z   .     /     4 H       &                   - =    0   1    2   3      K  P   W   O     5 -  6  (@  7 #A  8          9          G    H  J                       - SAMPLE  38  0.1       0.0       0.0       0.0 H    430   426   422   419   414   413   412   409   411   417   422   430H    438   441   447   455   461   453   448   449   454   463   470   472H    476   481   483   487   491   492   485   486   482   479   479   476    472   470                                                                                                                                                                                                                                                 ( * [STANVICK.SEAS$WORK_294000DB]EXPON.FOR;1 +  , X   .     /     4 D       ,                  - =    0   1    2   3      K  P   W   O     5 -  6  @@  7 @'#A  8          9          G    H  J                       > C	SAMPLE MAIN PROGRAM FOR TRIPLE EXPONENTIAL SMOOTHING - EXPON> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE/ C	NUMBER OF DATA POINTS IN A GIVEN TIME SERIES.  	DIMENSION X(1000),S(1000) 1	FORMAT(A4,A2,I4,F5.0,3F10.0) 2	FORMAT(12F6.0)D 3	FORMAT(////34H TRIPLE EXPONENTIAL SMOOTHING.....,A4,A2//22H NUMBER2 	1 OF DATA POINTS,I6/19H SMOOTHING CONSTANT,F9.3/)3 4	FORMAT(//13H COEFFICIENTS,9X,1HA,14X,1HB,14X,1HC) $ 5	FORMAT(//9H ORIGINAL,F19.5,2F15.5)$ 6	FORMAT(//8H UPDATED,F20.5,2F15.5/)C 7	FORMAT(//27X,13HSMOOTHED DATA/7X,10HINPUT DATA,12X,10H(FORECAST))  8	FORMAT(F17.5,8X,F15.5) C  **INPUT CHANNEL IS MY7 	OPEN (UNIT=1,NAME='IN$:EXPON.DAT',TYPE='OLD',READONLY)  	MY=1  C	READ PARAMETER CARD ! 100	READ(MY,1) PR,PR1,NX,AL,A,B,C & 	IF (NX.EQ.0) STOP 'EXPON successful!', C	PR......PROBLEM NUMBER (MAY BE ALPHABETIC)$ C	PR1.....PROBLEM NUMBER (CONTINUED). C	NX......NUMBER OF DATA POINTS IN TIME SERIES C	AL......SMOOTHING CONSTANT1 C	A,B,C...COEFFICIENTS OF THE PREDICTION EQUATION  	TYPE 3, PR,`                                                                                                                                           w= $      RTI020.J                       X  =  ([STANVICK.SEAS$WORK_294000DB]EXPON.FOR;1                                                                                       D                             K             PR1,NX,AL  C	PRINT ORIGINAL COEFFICIENTS  	TYPE 4  	TYPE 5, A,B,C C	READ TIME SERIES DATA  	READ(MY,2) (X(I),I=1,NX)  	CALL EXSMO(X,NX,AL,A,B,C,S) C	PRINT UPDATED COEFFICIENTS 	TYPE 6, A,B,C C	PRINT INPUT AND SMOOTHED DATA  	TYPE 7  	DO 200 I=1,NX 200	TYPE 8, X(I),S(I) 
 	GO TO 100 	END                                                                                                                                                                                                                                  ( * [STANVICK.SEAS$WORK_294000DB]EXSMO.FOR;1 +  , Y   .     /     4 H       *                   - =    0   1    2   3      K  P   W   O     5 -  6 s@  7 
#A  8          9          G    H  J           
             C H C     .................................................................. C  C        SUBROUTINE EXSMO  C  C        PURPOSEC C           TO FIND THE TRIPLE EXPONENTIAL SMOOTHED SERIES S OF THE  C           GIVEN SERIES X.  C  C        USAGE( C           CALL EXSMO (X,NX,AL,A,B,C,S) C " C        DESCRIPTION OF PARAMETERSD C           X     - INPUT VECTOR OF LENGTH NX CONTAINING TIME SERIES? C                   DATA WHICH IS TO BE EXPONENTIALLY SMOOTHED. 0 C           NX    - THE NUMBER OF ELEMENTS IN X.G C           AL    - SMOOTHING CONSTANT, ALPHA.  AL MUST BE GREATER THAN + C                   ZERO AND LESS THAN ONE. F C           A,B,C - COEFFICIENTS OF THE PREDICTION EQUATION WHERE S IS0 C                   PREDICTED T PERIODS HENCE BY4 C                                 A + B*T + C*T*T/2.G C                   AS INPUT-- IF A=B=C=0, PROGRAM WILL PROVIDE INITIAL B C                   VALUES.  IF AT LEAST ONE OF A,B,C IS NOT ZERO,E C                   PROGRAM WILL TAKE GIVEN VALUES AS INITIAL VALUES. E C                   AS OUTPUT-- A,B,C CONTAIN LATEST, UPDATED COEFFI- ) C                   CIENTS OF PREDICTION. @ C           S     - OUTPUT VECTOR OF LENGTH NX CONTAINING TRIPLE7 C                   EXPONENTIALLY SMOOTHED TIME SERIES.  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           REFER TO R. G. BROWN, 'SMOOTHING, FORECASTING AND PREDICTION@ C           OF DISCRETE TIME SERIES', PRENTICE-HALL, N.J., 1963, C           PP. 140 TO 144.  C H C     .................................................................. C (       SUBROUTINE EXSMO (X,NX,AL,A,B,C,S)       DIMENSION X(1),S(1)  C : C     IF A=B=C=0.0, GENERATE INITIAL VALUES OF A, B, AND C C        IF(A) 140, 110, 140    110 IF(B) 140, 120, 140    120 IF(C) 140, 130, 140    130 C=X(1)-2.0*X(2)+X(3)       B=X(2)-X(1)-1.5*C        A=X(1)-B-0.5*C C    140 BE=1.0-AL        BECUB=BE*BE*BE       ALCUB=AL*AL*AL C $ C     DO THE FOLLOWING FOR I=1 TO NX C        DO 150 I=1,NX  C ' C        FIND S(I) FOR ONE PERIOD AHEAD  C        S(I)=A+B+0.5*C C ( C        UPDATE COEFFICIENTS A, B, AND C C        DIF=S(I)-X(I)        A=X(I)+BECUB*DIF"       B=B+C-1.5*AL*AL*(2.0-AL)*DIF   150 C=C-ALCUB*DIF        RETURN	       END                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]FACTO.COM;1 +  , "Y?  .     /     4 @       :                  - =    0   1    2   3      K  P   W   O     5 -  6  T@  7 #A  8          9          G    H  J                       @ $ COPY IN$:FACTO.FOR,CORRE.FOR,EIGEN.FOR,LOAD.FOR TMP$:TMPSSP.11- $ COPY IN$:TRACE.FOR,VARMX.FOR TMP$:TMPSSP.12 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                    ( * [STANVICK.SEAS$WORK_294000DB]FACTO.DAT;1 +  , -YU  .     /     4 :       2                   - =    0   1    2   3      K  P   W   O     5 -  6  S@  7 =#A  8          9          G    H  J                        SAMPLE   23 9   1.0 6      7     7     9     7    15    36    60    15    246     13    18    25    15    13    35    61    18    306      9    18    24    23    12    43    62    14    316      7    13    25    36    11    12    63    26    326      6     8    20     7    15    46    18    28    156     10    12    30    11    10    42    27    12    176      7     6    11     7    15    35    60    20    256     16    19    25    16    13    30    64    20    306      9    22    26    24    13    40    66    15    32:      8    15    26    30    13    10    66    25    34    6      8    10    20     8    17    40    20    30    186      9    12    28    11     8    45    30    15    196     11    17    21    30    10    45    60    17    306      9    16    26    27    14    31    59    19    176     10    15    24    18    12    29    48    18    266     11    11    30    19    19    26    57    20    306     16     9    16    20    18    31    60    21    176      9     8    19    14    16    33    67     9    196      7    18    22     9    15    37    62    11    206      8    11    23    18     9    36    61    22    246      6     6    27    23     7    40    55    24    316     10     9    26    26    10    37    57    27    296      8    10    26    15    11    42    59    20    28                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]FACTO.FOR;1 +  , 0Y_  . 	    /     4 C   	   	                    - =    0   1    2   3      K  P   W   O 
    5 -  6 `@  7 (#A  8          9          G    H  J           
            ) C	SAMPLE MAIN PROGRAM FOR FACTOR ANALYSIS ! C	USES THE FOLLOWING SUBROUTINES: 6 C  CORRE	- MEANS,STANDARD DEVIATIONS, AND CORRELATIONS> C  EIGEN	- EIGENVALUES AND EIGENVECTORS OF A REAL,SYMM. MATRIX/ C  TRACE	- CUMULATIVE PERCENTAGE OF EIGENVALUES  C  LOAD		- FACTOR LOADING  C  VARMX	- VARIMAX ROTATION  C . C  DATA - A ROUTINE SUPPLIED WITH THIS PROGRAM C ? C	THE FOLLOWING DIMENSIONS MUST BE GREATER THAN OR EQUAL TO THE  C	NUMBER OF VARIABLES, M... + 	DIMENSION B(29),D(29),S(29),T(29),XBAR(29) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF M*M.. 	DIMENSION V(841) : C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO
 C	(M+1)*M/2..  	DIMENSION R(435) ? C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO 51..  	DIMENSION TV(51) 
 	COMMON IN C	INPUT CHANNEL = IN 	IN = 1  C B 1	FORMAT(////21H FACTOR ANALYSIS.....A4,A2//3X,12HNO. OF CASES,4X,  	1I6/3X,16HNO. OF VARIABLES,I6/) 2	FORMAT(//6H MEANS/(5F15.5)) , 3	FORMAT(//20H STANDARD DEVIATIONS/(5F15.5))( 4	FORMAT(//25H CORRELATION COEFFICIENTS) 5	FORMAT(//4H ROW,I3/(5F15.5))% 6	FORMAT(///12H EIGENVALUES/(5F15.5)) = 7	FORMAT(//37H CUMULATIVE PERCENTAGE OF EIGENVALUES/(5F15.5))  8	FORMAT(///13H EIGENVECTORS) ! 9	FORMAT(//7H VECTOR,I3/(5F15.5)) 0 10	FORMAT(///16H FACTOR MATRIX (,I3,9H FACTORS))$ 11	FORMAT(//9H VARIABLE,I3/(5F15.5))5 12	FORMAT(///10H ITERATION,7X,9HVARIANCES/8H   CYCLE)  13	FORMAT(I6,F20.6) 8 14	FORMAT(///24H ROTATED FACTOR MATRIX (,I3,9H FACTORS))$ 15	FORMAT(//9H VARIABLE,I3/(5F15.5))C 16	FORMAT(///23H CHECK ON COMMUNALITIES//9H VARIABLE,7X,8HORIGINAL,   	112X,5HFINAL,10X,10HDIFFERENCE) 17	FORMAT(I6,3F18.5) 18	FORMAT(A4,A2,I5,I2,F6.0) 9 19	FORMAT(//5H ONLY,I2,30H FACTOR RETAINED. NO ROTATION )  C	READ PROBLEM PARAMETER CARD 7 	OPEN (UNIT=1,NAME='IN$:FACTO.DAT',TYPE='OLD',READONLY)  100	READ(IN,18) PR,PR1,N,M,CON, C  PR     PROBLEM NUMBER (MAY BE ALPHAMERIC)$ C  PR1    PROBLEM NUMBER (CONTINUED) C  N      NUMBER OF CASES  C  M      NUMBER OF VARIABLES @ C  CON    CONSTANT USED TO DECIDE HOW MANY EIGENVALUES TO RETAIN C $ 	IF(N.EQ.0) STOP 'FACTO successful!' 	TYPE 1,PR,PR1,N,M 	IO=0  	X=0.0& 	CALL CORRE(N,M,IO,X,XBAR,S,V,R,D,B,T)
 C	PRINT MEANS  	TYPE 2,( XBAR(J),J=1,M) C	PRINT STANDARD DEVIATIONS  	TYPE 3, (S(J),J=1,M)   C	PRINT CORRELATION COEFFICIENTS 	TYPE 4 
 	DO 120 I=1,M 
 	DO 110 J=1,M  	IF(I-J) 102,104,104 102	L=I+(J*J-J)/2 
 	GO TO 110 104	L=J+(I*I-I)/2 
 110	D(J)=R(L)  120	TYPE 5, I,(D(J),J=1,M) 	MV=0  	CALL EIGEN (R,V,M,MV) 	CALL TRACE(M,R,CON,K,D) C	PRINT EIGENVAL`                                                                                                                                           !~ $      RTI020.J                       0Y_ =  ([STANVICK.SEAS$WORK_294000DB]FACTO.FOR;1                                                                                       C    	                         D             UES 
 	DO 130 I=1,K  	L=I+(I*I-I)/2
 130	S(I)=R(L)  	TYPE 6, (S(J),J=1,K) , C	PRINT CUMULATIVE PERCENTAGE OF EIGENVALUES 	TYPE 7, (D(J),J=1,K)  C	PRINT EIGENVECTORS 	TYPE 8  	L=0
 	DO 150 J=1,K 
 	DO 140 I=1,M  	L=L+1 140	D(I) = V(L)  150	TYPE 9, J,(D(I),I=1,M) 	CALL LOAD(M,K,R,V)  C	PRINT FACTOR MATRIX  	TYPE 10, K 
 	DO 180 I=1,M 
 	DO 170 J=1,K  	L=M*(J-1)+I
 170	D(J)=V(L)  180	TYPE 11, I,(D(J),J=1,K)  	IF(K-1) 185,185,188
 185	TYPE 19,K 
 	GO TO 100% 188	CALL VARMX(M,K,V,NC,TV,B,T,D,IER)  C	PRINT VARIANCES  	NV=NC+1 	TYPE 12 	DO 190 I=1,NV 	NC=I-1  190	TYPE 13, NC,TV(I)  C	PRINT ROTATED FACTOR MATRIX  	TYPE 14, K 
 	DO 220 I=1,M 
 	DO 210 J=1,K  	L=M*(J-1)+I
 210	S(J)=V(L)  220	TYPE 15, I,(S(J),J=1,K)  C	PRINT COMMUNALITIES  	TYPE 16
 	DO 230 I=1,M  230	TYPE 17, I,B(I),T(I),D(I) 
 	GO TO 100 	END$ C	SAMPLE INPUT SUBROUTINE - DATA.FTN C 	 C	PURPOSE : C	  READ AN OBSERVATION (N DATA VALUES) FROM INPUT DEVICE.> C	  THIS SUBROUTINE IS CALLED BY THE SUBROUTINE CORRE AND MUST: C	  BE PROVIDED BY THE USER.  IF SIZE AND LOCATION OF DATAA C	  FIELDS ARE DIFFERENT FROM PROBLEM TO PROBLEM, THIS SUBROUTINE 6 C	  MUST BE RECOMPILED WITH A PROPRE FORMAT STATEMENT. C  C	USAGE  C	  CALL DATA(M,D) C  C	DESCRIPTION OF PARAMETERS 2 C	  M - THE NUMBER OF VARIABLES IN AN OBSERVATION.B C	  D - OUTPUT VECTOR OF LENGTH M CONTAINING THE OBSERVATION DATA. C 	 C	REMARKS : C	  THE TYPE OF CONVERSION SPECIFIED IN THE FORMAT MUST BE C	  EITHER F OR E. C / C	SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED  C	  NONE C  	SUBROUTINE DATA(M,D)  	DIMENSION D(1) 
 	COMMON IN 1	FORMAT(12F6.0)( C	READ AN OBSERVATION FROM INPUT DEVICE. 	READ(IN,1) (D(I),I=1,M) 	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                ( * [STANVICK.SEAS$WORK_294000DB]FORIF.FOR;1 +  , `Y   . 	    /     4 H   	    T                    - =    0   1    2   3      K  P   W   O     5 -  6 M@  7 ;#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE FORIF  C  C        PURPOSE@ C           FOURIER ANALYSIS OF A GIVEN PERIODIC FUNCTION IN THE C           RANGE 0-2PI D C           COMPUTES THE COEFFICIENTS OF THE DESIRED NUMBER OF TERMSF C           IN THE FOURIER SERIES F(X)=A(0)+SUM(A(K)COS KX+B(K)SIN KX)E C           WHERE K=1,2,...,M TO APPROXIMATE THE COMPUTED VALUES OF A % C           GIVEN FUNCTION SUBPROGRAM  C  C        USAGE' C           CALL FORIF(FUN,N,M,A,B,IER)  C " C        DESCRIPTION OF PARAMETERSD C           FUN-NAME OF FUNCTION SUBPROGRAM TO BE USED FOR COMPUTING C               DATA POINTS D C           N  -DEFINES THE INTERVAL SUCH THAT 2N+1 POINTS ARE TAKENG C               OVER THE INTERVAL (0,2PI). THE SPACING IS THUS 2PI/2N+1 ? C           M  -THE MAXIMUM ORDER OF THE HARMONICS TO BE FITTED B C           A  -RESULTANT VECTOR OF FOURIER COSINE COEFFICIENTS OF C               LENGTH M+1- C               A SUB 0, A SUB 1,..., A SUB M @ C           B  -RESULTANT VECTOR OF FOURIER SINE COEFFICIENTS OF C               LENGTH M+1- C               B SUB 0, B SUB 1,..., B SUB M * C           IER-RESULTANT ERROR CODE WHERE C               IER=0  NO ERROR 2 C               IER=1  N NOT GREATER OR EQUAL TO M$ C               IER=2  M LESS THAN 0 C  C        REMARKS3 C           M MUST BE GREATER THAN OR EQUAL TO ZERO 0 C           N MUST BE GREATER THAN OR EQUAL TO M> C           THE FIRST ELEMENT IN VECTOR B IS ZERO IN ALL CASES C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDC C           FUN-NAME OF USER FUNCTION SUBPROGRAM USED FOR COMPUTING  C               DATA POINTS @ C           CALLING PROGRAM MUST HAVE FORTRAN EXTERNAL STATEMENTF C           CONTAINING NAMES OF FUNCTION SUBPROGRAMS LISTED IN CALL TO C           FORIF  C  C        METHOD F C           USES RECURSIVE TECHNIQUE DESCRIBED IN A. RALSTON, H. WILF,D C           'MATHEMATICAL METHODS FOR DIGITAL COMPUTERS', JOHN WILEY? C           AND SONS, NEW YORK, 1960, CHAPTER 24. THE METHOD OF ? C           INDEXING THROUGH THE PROCEDURE HAS BEEN MODIFIED TO % C           SIMPLIFY THE COMPUTATION.  C H C     .................................................................. C '       SUBROUTINE FORIF(FUN,N,M,A,B,IER)        DIMENSION A(1),B(1)  C # C        CHECK FOR PARAMETER ERRORS  C        IER=0     20 IF(M) 30,40,40    30 IER=2        RETURN    40 IF(M-N) 60,60,50    50 IER=1        RETURN C % C        COMPUTE AND PRESET CONSTANTS  C 
    60 AN=N       COEF=2.0/(2.0*AN+1.0)        CONST=3.141593*COEF        S1=SIN(CONST)        C1=COS(CONST)        C=1.0        S=0.0 	       J=1        FUNZ=FUN(0.0)     70 U2=0.0       U1=0.0       AI=2*N C . C        FORM FOURIER COEFFICIENTS RECURSIVELY C     75 X=AI*CONST       U0=FUN(X)+2.0*C*U1-U2        U2=U1        U1=U0        AI=AI-1.0        IF(AI) 80,80,75     80 A(J)=COEF*(FUNZ+C*U1-U2)       B(J)=COEF*S*U1       IF(J-(M+1)) 90,100,100    90 Q=C1*C-S1*S        S=C1*S+S1*C 	       C=Q        J=J+1        GO TO 70   100 A(1)=A(1)*0.5        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]FORIT.FOR;1 +  , aY	   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 y@  7 L#A  8          9          G    H  J           
             C H C     .................................................................. C  C        SUBROUTINE FORIT  C  C        PURPOSEB C           FOURIER ANALYSIS OF A PERIODICALLY TABULATED FUNCTION.D C           COMPUTES THE COEFFICIENTS OF THE DESIRED NUMBER OF TERMSF C           IN THE FOURIER SERIES F(X)=A(0)+SUM(A(K)COS KX+B(K)SIN KX); C           WHERE K=1,2,...,M TO APPROXIMATE A GIVEN SET OF 8 C           PERIODICALLY TABULATED VALUES OF A FUNCTION. C  C        USAGE' C           CALL FORIT(FNT,N,M,A,B,IER)  C " C        DESCRIPTION OF PARAMETERSB C           FNT-VECTOR OF TABULATED FUNCTION VALUES OF LENGTH 2N+1D C           N  -DEFINES THE INTERVAL SUCH THAT 2N+1 POINTS ARE TAKENG C               OVER THE INTERVAL (0,2PI). THE SPACING IS THUS 2PI/2N+1 7 C           M  -MAXIMUM ORDER OF HARMONICS TO BE FITTED B C           A  -RESULTANT VECTOR OF FOURIER COSINE COEFFICIENTS OF C               LENGTH M+1- C               A SUB 0, A SUB 1,..., A SUB M @ C           B  -RESULTANT VECTOR OF FOURIER SINE COEFFICIENTS OF C               LENGTH M+1- C               B SUB 0, B SUB 1,..., B SUB M * C           IER-RESULTANT ERROR CODE WHERE C               IER=0  NO ERROR 2 C               IER=1  N NOT GREATER OR EQUAL TO M$ C               IER=2  M LESS THAN 0 C  C        REMARKS3 C           M MUST BE GREATER THAN OR EQUAL TO ZERO 0 C           N MUST BE GREATER THAN OR EQUAL TO M> C           THE FIRST ELEMENT OF VECTOR B IS ZERO IN ALL CASES C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           USES RECURSIVE TECHNIQUE DESCRIBED IN A. RALSTON, H. WILF,D C           'MATHEMATICAL METHODS FOR DIGITAL COMPUTERS', JOHN WILEYH C           AND SONS, NEW YORK, 1960, CHAPTER 24. THE METHOD OF INDEXINGC C           THROUGH THE PROCEDURE HAS BEEN MODIFIED TO SIMPLIFY THE  C           COMPUTATION. C H C     .................................................................. C '       SUBROUTINE FORIT(FNT,N,M,A,B,IER)         DIMENSION A(1),B(1),FNT(1) C # C        CHECK FOR PARAMETER ERRORS  C        IER=0     20 IF(M) 30,40,40    30 IER=2        RETURN    40 IF(M-N) 60,60,50    50 IER=1        RETURN C % C        COMPUTE AND PRESET CONSTANTS  C 
    60 AN=N       COEF=2.0/(2.0*AN+1.0)        CONST=3.141593*COEF        S1=SIN(CONST)        C1=COS(CONST)        C=1.0        S=0.0 	       J=1        FNTZ=FNT(1)     70 U2=0.0       U1=0.0
       I=2*N+1  C . C        FORM FOURIER COEFFICIENTS RECURSIVELY C     75 U0=FNT(I)+2.0*C*U1-U                                                                                                                                                                                                           W<B $      RTI020.J                       aY	  =  ([STANVICK.SEAS$WORK_294000DB]FORIT.FOR;1                                                                                       H                                           2        U2=U1        U1=U0        I=I-1        IF(I-1) 80,80,75    80 A(J)=COEF*(FNTZ+C*U1-U2)       B(J)=COEF*S*U1       IF(J-(M+1)) 90,100,100    90 Q=C1*C-S1*S        S=C1*S+S1*C 	       C=Q        J=J+1        GO TO 70   100 A(1)=A(1)*0.5        RETURN	       END                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]FORR.COM;1 +  , bY   .     /     4 6                          - =    0   1    2   3      K  P   W   O     5 -  6 3@  7 `b#A  8          9          G    H  J                        6 $ COPY IN$:FORR.FOR,FORIF.FOR,FORIT.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                      ' * [STANVICK.SEAS$WORK_294000DB]FORR.FOR;1 +  , cY	   .     /     4 F                           - =    0   1    2   3      K  P   W   O     5 -  6 P@  7 u#A  8          9          G    H  J                        9 C	FORR.FTN - A PROGRAM TO TEST THE FOLLOWING SUBROUTINES: / C  FORIF	- FOURIER ANALYSIS OF A GIVEN FUNCTION 3 C  FORIT	- FOURIER ANALYSIS OF A TABULATED FUNCTION * C	49 DATA POINTS WILL BE USED IN EACH CASE C 
 	EXTERNAL FCN " 	DIMENSION A(25),B(25),T(50),C(13)5 	DATA C/3.29,-4.0,1.,-.444,.25,-.160,.111,-.082,.063, ' 	1 -.049,.040,-.033,.028/,PI/3.1415926/  	TWOPI=PI+PI C  C  C	TEST FORIF C 	 	TYPE 100 / 100	FORMAT(//' RESULTS OF FORIF'/4X,'FUNCTION:' 2 	1' F(X)=X**2+X ON -PI < X < PI, F(X+2*PI)=F(X)'/)	 	TYPE 103 F 103	FORMAT(' COEFFICIENTS:'/'   N'8X,'A(N)'5X,'A(N)-EXACT',5X,'B(N)'/) 	CALL FORIF(FCN,24,12,A,B,IER) 	DO 1 I=1,13 	N=I-1 1	TYPE 101, N,A(I),C(I),B(I) 101	FORMAT(I4,3F12.3)  C  C	TEST FORIT C 	 	TYPE 102 5 102	FORMAT(//' RESULTS OF FORIT'/4X,'SAME FUNCTION'/)  	DO 2 J=1,49 	JM1=J-1 2	T(J)=FCN(JM1*TWOPI/49.) 	 	TYPE 103  	CALL FORIT(T,24,12,A,B,IER) 	DO 3 I=1,13 	N=I-1 3	TYPE 101, N,A(I),C(I),B(I) 	STOP 'FORR successful!' 	END) C	EXTERNAL FUNCTION FOR USE WITH FORR.FTN  	FUNCTION FCN(X) 	DATA PI/3.1415926/  	TWOPI=PI+PI 	Z=X 1	IF(ABS(Z)-PI) 3,3,2 
 2	IF(Z) 4,3,5  4	Z=Z+TWOPI  	GO TO 1 5	Z=Z-TWOPI  	GO TO 1 3	FCN=Z**2+Z 	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                ( * [STANVICK.SEAS$WORK_294000DB]GAMMA.FOR;1 +  , dY   .     /     4 H       (                   - =    0   1    2   3      K  P   W   O     5 -  6 1@  7 #A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GAMMA  C  C        PURPOSE< C           COMPUTES THE GAMMA FUNCTION FOR A GIVEN ARGUMENT C  C        USAGE! C           CALL GAMMA(XX,GX,IER)  C " C        DESCRIPTION OF PARAMETERS3 C           XX -THE ARGUMENT FOR THE GAMMA FUNCTION 2 C           GX -THE RESULTANT GAMMA FUNCTION VALUE* C           IER-RESULTANT ERROR CODE WHERE C               IER=0  NO ERROR G C               IER=1  XX IS WITHIN .000001 OF BEING A NEGATIVE INTEGER = C               IER=2  XX GT 34.5, OVERFLOW, GX SET TO 1.0E38  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD ? C           THE RECURSION RELATION AND POLYNOMIAL APPROXIMATION F C           BY C.HASTINGS,JR., 'APPROXIMATIONS FOR DIGITAL COMPUTERS',, C           PRINCETON UNIVERSITY PRESS, 1955 C H C     .................................................................. C !       SUBROUTINE GAMMA(XX,GX,IER)        IF(XX-34.5)6,6,4     4 IER=2        GX=1.E38       RETURN
     6 X=XX       ERR=1.0E-6       IER=0        GX=1.0       IF(X-2.0)50,50,15     10 IF(X-2.0)110,110,15 
    15 X=X-1.0 
       GX=GX*X        GO TO 10    50 IF(X-1.0)60,120,110  C 2 C        SEE IF X IS NEAR NEGATIVE INTEGER OR ZERO C     60 IF(X-ERR)62,62,80     62 Y=FLOAT(INT(X))-X        IF(ABS(Y)-ERR)130,130,64    64 IF(1.0-Y-ERR)130,130,70  C . C        X NOT NEAR A NEGATIVE INTEGER OR ZERO C     70 IF(X-1.0)80,80,110
    80 GX=GX/X 
       X=X+1.0        GO TO 70
   110 Y=X-1.0 E       GY=1.0+Y*(-0.5771017+Y*(+0.9858540+Y*(-0.8764218+Y*(+0.8328212+ 7      1Y*(-0.5684729+Y*(+0.2548205+Y*(-0.05149930)))))))        GX=GX*GY   120 RETURN   130 IER=1        RETURN	       END                                                                                                                                                                                                                                       ( * [STANVICK.SEAS$WORK_294000DB]GAUSS.FOR;1 +  , eY
   .     /     4 I                           - =    0   1    2   3      K  P   W   O     5 -  6 5@  7  #A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GAUSS  C  C        PURPOSEF C           COMPUTES A NORMALLY DISTRIBUTED RANDOM NUMBER WITH A GIVEN' C           MEAN AND STANDARD DEVIATION  C  C        USAGE! C           CALL GAUSS(IX,S,AM,V)  C " C        DESCRIPTION OF PARAMETERSI C           IX -IX IS AN INTEGER ARRAY OF LENGTH 2.  THE INITIAL ENTRIES  8 C		IN THE IX ARRAY SHOULD BE ZERO.   THEREAFTER, IT WILLF C               CONTAIN PART OF A UNIFORMLY DISTRIBUTED INTEGER RANDOMB C               NUMBER GENERATED BY THE SUBROUTINE FOR USE ON THE - C               NEXT ENTRY TO THE SUBROUTINE. < C           S  -THE DESIRED STANDARD DEVIATION OF THE NORMAL C               DISTRIBUTION. ; C           AM -THE DESIRED MEAN OF THE NORMAL DISTRIBUTION @ C           V  -THE VALUE OF THE COMPUTED NORMAL RANDOM VARIABLE C  C        REMARKS@ C           THIS SUBROUTINE USES RANDU WHICH IS MACHINE SPECIFIC C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           RANDU  C  C        METHOD C C           USES 12 UNIFORM RANDOM NUMBERS TO COMPUTE NORMAL RANDOM @ C           NUMBERS BY CENTRAL LIMIT THEOREM. THE RESULT IS THEND C           ADJUSTED TO MATCH THE GIVEN MEAN AND STANDARD DEVIATION.E C           THE UNIFORM RANDOM NUMBERS COMPUTED WITHIN THE SUBROUTINE 2 C           ARE FOUND BY THE POWER RESIDUE METHOD. C H C     .................................................................. C !       SUBROUTINE GAUSS(IX,S,AM,V)        DIMENSION IX(2)        A=0.0        DO 50 I=1,12       CALL RANDU(IX(1),IX(2),Y)     50 A=A+Y        V=(A-6.0)*S+AM       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                 ( * [STANVICK.SEAS$WORK_294000DB]GDATA.FOR;1 +  , fY	   . 	    /     4 H   	   	                    - =    0   1    2   3      K  P   W   O 
    5 -  6 `v@  7  Ԭ#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GDATA  C  C        PURPOSED C           GENERATE INDEPENDENT VARIABLES UP TO THE M-TH POWER (THEC C           HIGHEST DEGREE POLYNOMIAL SPECIFIED) AND COMPUTE MEANS, D C           STANDARD DEVIATIONS, AND CORRELATION COEFFICIENTS.  THISC C           SUBROUTINE IS NORMALLY CALLED BEFORE SUBROUTINES ORDER, = C           MINV AND MULTR IN THE PERFORMANCE OF A POLYNOMIAL  C           REGRESSION.  C  C   @                                                                                                                                                                                                                                                                                                                                                                          .'~ $      RTI020.J                       fY	  =  ([STANVICK.SEAS$WORK_294000DB]GDATA.FOR;1                                                                                       H     	                                           USAGE/ C           CALL GDATA (N,M,X,XBAR,STD,D,SUMSQ)  C " C        DESCRIPTION OF PARAMETERS+ C           N     - NUMBER OF OBSERVATIONS. ? C           M     - THE HIGHEST DEGREE POLYNOMIAL TO BE FITTED. E C           X     - INPUT MATRIX (N BY M+1) .  WHEN THE SUBROUTINE IS A C                   CALLED, DATA FOR THE INDEPENDENT VARIABLE ARE H C                   STORED IN THE FIRST COLUMN OF MATRIX X, AND DATA FORA C                   THE DEPENDENT VARIABLE ARE STORED IN THE LAST @ C                   COLUMN OF THE MATRIX.  UPON RETURNING TO THEH C                   CALLING ROUTINE, GENERATED POWERS OF THE INDEPENDENT? C                   VARIABLE ARE STORED IN COLUMNS 2 THROUGH M. C C           XBAR  - OUTPUT VECTOR OF LENGTH M+1 CONTAINING MEANS OF 8 C                   INDEPENDENT AND DEPENDENT VARIABLES.C C           STD   - OUTPUT VECTOR OF LENGTH M+1 CONTAINING STANDARD F C                   DEVIATIONS OF INDEPENDENT AND DEPENDENT VARIABLES.G C           D     - OUTPUT MATRIX (ONLY UPPER TRIANGULAR PORTION OF THE G C                   SYMMETRIC MATRIX OF M+1 BY M+1) CONTAINING CORRELA- ; C                   TION COEFFICIENTS.  (STORAGE MODE OF 1) B C           SUMSQ - OUTPUT VECTOR OF LENGTH M+1 CONTAINING SUMS OFE C                   PRODUCTS OF DEVIATIONS FROM MEANS  OF INDEPENDENT , C                   AND DEPENDENT VARIABLES. C  C        REMARKS' C           N MUST BE GREATER THAN M+1. F C           IF M IS EQUAL TO 5 OR GREATER, SINGLE PRECISION MAY NOT BEB C           SUFFICIENT TO GIVE SATISFACTORY COMPUTATIONAL RESULTS. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           REFER TO B. OSTLE, 'STATISTICS IN RESEARCH', THE IOWA STATE + C           COLLEGE PRESS, 1954, CHAPTER 6.  C H C     .................................................................. C /       SUBROUTINE GDATA (N,M,X,XBAR,STD,D,SUMSQ) 1       DIMENSION X(1),XBAR(1),STD(1),D(1),SUMSQ(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C / C     DOUBLE PRECISION X,XBAR,STD,D,SUMSQ,T1,T2  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOE C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT AND ABS IN 9 C        STATEMENT 180 MUST BE CHANGED TO DSQRT AND DABS.  C H C        ............................................................... C $ C     GENERATE INDEPENDENT VARIABLES C        IF(M-1) 105, 105, 90
    90 L1=0       DO 100 I=2,M
       L1=L1+N        DO 100 J=1,N       L=L1+J       K=L-N    100 X(L)=X(K)*X(J) C  C     CALCULATE MEANS  C    105 MM=M+1
       DF=N	       L=0        DO 115 I=1,MM        XBAR(I)=0.0        DO 110 J=1,N       L=L+1    110 XBAR(I)=XBAR(I)+X(L)   115 XBAR(I)=XBAR(I)/DF C        DO 130 I=1,MM    130 STD(I)=0.0 C 4 C     CALCULATE SUMS OF CROSS-PRODUCTS OF DEVIATIONS C        L=((MM+1)*MM)/2        DO 150 I=1,L   150 D(I)=0.0       DO 170 K=1,N	       L=0        DO 170 J=1,MM        L2=N*(J-1)+K       T2=X(L2)-XBAR(J)       STD(J)=STD(J)+T2       DO 170 I=1,J       L1=N*(I-1)+K       T1=X(L1)-XBAR(I)       L=L+1    170 D(L)=D(L)+T1*T2 	       L=0        DO 175 J=1,MM        DO 175 I=1,J       L=L+1     175 D(L)=D(L)-STD(I)*STD(J)/DF	       L=0        DO 180 I=1,MM        L=L+I        SUMSQ(I)=D(L)    180 STD(I)= SQRT( ABS(D(L))) C ( C     CALCULATE CORRELATION COEFFICIENTS C 	       L=0        DO 190 J=1,MM        DO 190 I=1,J       L=L+1    190 D(L)=D(L)/(STD(I)*STD(J))  C # C     CALCULATE STANDARD DEVIATIONS  C        DF=SQRT(DF-1.0)        DO 200 I=1,MM    200 STD(I)=STD(I)/DF       RETURN	       END                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]GMADD.FOR;1 +  , gY	   .     /     4 H       *                    - =    0   1    2   3      K  P   W   O     5 -  6  #@  7 ##A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GMADD  C  C        PURPOSEE C           ADD TWO GENERAL MATRICES TO FORM RESULTANT GENERAL MATRIX  C  C        USAGE! C           CALL GMADD(A,B,R,N,M)  C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX ' C           N - NUMBER OF ROWS IN A,B,R * C           M - NUMBER OF COLUMNS IN A,B,R C  C        REMARKS; C           ALL MATRICES MUST BE STORED AS GENERAL MATRICES  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD 4 C           ADDITION IS PERFORMED ELEMENT BY ELEMENT C H C     .................................................................. C !       SUBROUTINE GMADD(A,B,R,N,M)        DIMENSION A(1),B(1),R(1) C % C        CALCULATE NUMBER OF ELEMENTS  C        NM=N*M C  C        ADD MATRICES  C        DO 10 I=1,NM    10 R(I)=A(I)+B(I)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]GMPRD.FOR;1 +  , jY	   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  ݙ@  7 #A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GMPRD  C  C        PURPOSEE C           MULTIPLY TWO GENERAL MATRICES TO FORM A RESULTANT GENERAL  C           MATRIX C  C        USAGE# C           CALL GMPRD(A,B,R,N,M,L)  C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX # C           N - NUMBER OF ROWS IN A 4 C           M - NUMBER OF COLUMNS IN A AND ROWS IN B& C           L - NUMBER OF COLUMNS IN B C  C        REMARKS; C           ALL MATRICES MUST BE STORED AS GENERAL MATRICES ? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A ? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX B H C           NUMBER OF COLUMNS OF MATRIX A MUST BE EQUAL TO NUMBER OF ROW C           OF MATRIX B  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           THE M BY L MATRIX B IS PREMULTIPLIED BY THE N BY M MATRIX A < C           AND THE RESULT IS STORED IN THE N BY L MATRIX R. C H C     .................................................................. C #       SUBROUTINE GMPRD(A,B,R,N,M,L)        DIMENSION A(1),B(1),R(1) C 
       IR=0       IK=-M        DO 10 K=1,L 
       IK=IK+M        DO 10 J=1,N 
       IR=IR+1        JI=J-N       IB=IK 
       R(IR)=0        DO 10 I=1,M 
       JI=JI+N 
       IB=IB+1     10 R(IR)=R(IR)+A(JI)*B(IB)        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ( * [STANVICK.SEAS$WORK_294000DB]GMSUB.FOR;1 +  , tY
   .     /     4 H       l                    - =    0   1    2   3      K  P   W   O     5 -  6 @  7  I#A  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Nܶ $      RTI020.J                       tY
  =  ([STANVICK.SEAS$WORK_294000DB]GMSUB.FOR;1                                                                                       H                                            C H C     .................................................................. C  C        SUBROUTINE GMSUB  C  C        PURPOSEF C           SUBTRACT ONE GENERAL MATRIX FROM ANOTHER TO FORM RESULTANT C           MATRIX C  C        USAGE! C           CALL GMSUB(A,B,R,N,M)  C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX ' C           N - NUMBER OF ROWS IN A,B,R * C           M - NUMBER OF COLUMNS IN A,B,R C  C        REMARKS; C           ALL MATRICES MUST BE STORED AS GENERAL MATRICES  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           MATRIX B ELEMENTS ARE SUBTRACTED FROM CORRESPONDING MATRIX A C           ELEMENTS C H C     .................................................................. C !       SUBROUTINE GMSUB(A,B,R,N,M)        DIMENSION A(1),B(1),R(1) C % C        CALCULATE NUMBER OF ELEMENTS  C        NM=N*M C  C        SUBTRACT MATRICES C        DO 10 I=1,NM    10 R(I)=A(I)-B(I)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                   ( * [STANVICK.SEAS$WORK_294000DB]GMTRA.FOR;1 +  , vY   .     /     4 H       4                    - =    0   1    2   3      K  P   W   O     5 -  6  ]@  7 @#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GMTRA  C  C        PURPOSE& C           TRANSPOSE A GENERAL MATRIX C  C        USAGE C           CALL GMTRA(A,R,N,M)  C " C        DESCRIPTION OF PARAMETERS/ C           A - NAME OF MATRIX TO BE TRANSPOSED ( C           R - NAME OF RESULTANT MATRIX4 C           N - NUMBER OF ROWS OF A AND COLUMNS OF R4 C           M - NUMBER OF COLUMNS OF A AND ROWS OF R C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A ? C           MATRICES A AND R MUST BE STORED AS GENERAL MATRICES  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD = C           TRANSPOSE N BY M MATRIX A TO FORM M BY N MATRIX R  C H C     .................................................................. C        SUBROUTINE GMTRA(A,R,N,M)        DIMENSION A(1),R(1)  C 
       IR=0       DO 10 I=1,N        IJ=I-N       DO 10 J=1,M 
       IJ=IJ+N 
       IR=IR+1     10 R(IR)=A(IJ)        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]GTPRD.FOR;1 +  , wY   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6  @9@  7  |#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE GTPRD  C  C        PURPOSED C           PREMULTIPLY A GENERAL MATRIX BY THE TRANSPOSE OF ANOTHER C           GENERAL MATRIX C  C        USAGE# C           CALL GTPRD(A,B,R,N,M,L)  C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX ) C           N - NUMBER OF ROWS IN A AND B 4 C           M - NUMBER OF COLUMNS IN A AND ROWS IN R, C           L - NUMBER OF COLUMNS IN B AND R C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A ? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX B ; C           ALL MATRICES MUST BE STORED AS GENERAL MATRICES  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           MATRIX TRANSPOSE OF A IS NOT ACTUALLY CALCULATED. INSTEAD,A C           ELEMENTS OF MATRIX A ARE TAKEN COLUMNWISE RATHER THAN 7 C           ROWWISE FOR POSTMULTIPLICATION BY MATRIX B.  C H C     .................................................................. C #       SUBROUTINE GTPRD(A,B,R,N,M,L)        DIMENSION A(1),B(1),R(1) C 
       IR=0       IK=-N        DO 10 K=1,L 
       IJ=0
       IK=IK+N        DO 10 J=1,M        IB=IK 
       IR=IR+1 
       R(IR)=0        DO 10 I=1,N 
       IJ=IJ+1 
       IB=IB+1     10 R(IR)=R(IR)+A(IJ)*B(IB)        RETURN	       END                             ( * [STANVICK.SEAS$WORK_294000DB]INTEG.COM;1 +  , xY   .     /     4 4                          - =    0   1    2   3      K  P   W   O     5 -  6 "@  7  R"#A  8          9          G    H  J                       4 $ COPY IN$:INTEG.FOR,QATR.FOR,RK1.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                        ( * [STANVICK.SEAS$WORK_294000DB]INTEG.FOR;1 +  , Y   .     /     4 E                           - =    0   1    2   3      K  P   W   O     5 -  6 @  7 @(6#A  8          9          G    H  J                        C 6 C	INTEG.FOR - SAMPLE PROGRAM INVOLVING DIFFERENTIATION C	  AND INTEGRATION USING:1 C  RK1		- RUNGE-KUTTA SOLUTION OF ORD. DIFF. EQN.  C  QATR		- ROMBERG INTEGRATION C  C	ACTUAL FCN  Y=EXP(X)-X-1
 	EXTERNAL FC1 
 	EXTERNAL FC2  	DIMENSION AUX(50) C  C  	XI=0. 	YI=0. 	XF=1.0  	YF=10.  	H=0.05 * 	CALL RK1(FC2,H,XI,YI,XF,YF,ANSX,ANSY,IER) 	TYPE 100, ANSX, ANSY E 100	FORMAT(//' USE OF RK1 WITH Y'' = Y + X'/' SOLN. IS Y=EXP(X)-X-1'/ D 	13X,'CASE 1:  XFINAL=',F8.4,'   ANSY=',F8.4,' (SHOULD BE 0.7183)'/) 	XI=0. 	YI=0. 	XF=10. 
 	YF=0.7183 	H=0.05 * 	CALL RK1(FC2,H,XI,YI,XF,YF,ANSX,ANSY,IER) 	TYPE 101, ANSX,ANSYC 101	FORMAT(3X,'CASE 2:  ANSX='F8.4,' (SHOULD BE 1.0)  YFINAL='F8.4)  C  C	QATR) 	CALL QATR(0.,1.0,1.E-5,50,FC1,Y,IER,AUX)  	TYPE 102, Y,IER5 102	FORMAT(//' USE OF QATR WITH Y=EXP(X)-1 ON (0,1)'/ * 	1' VALUE OF INTEGRAL ='F8.4,'  IER ='I1/) 	STOP 'INTEG successful!'  	END 	FUNCTION FC2(X,Y) C  FOR USE IN RK1  	FC2=Y+X 	RETURN  	END 	FUNCTION FC1(X) C  FOR USE IN QATR
 	FC1=EXP(X)-1  	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ( * [STANVICK.SEAS$WORK_294000DB]KRANK.FOR;1 +  , Y   . 	    /     4 H   	                        - =    0   1    2   3      K  P   W   O     5 -  6  @  7 `I#A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE KRANK  C  C        PURPOSEF C           TEST CORRELATION BETWEEN TWO VARIABLES BY MEANS OF KENDALL( C           RANK CORRELATION COEFFICIENT C  C        USAGE+ C           CALL KRANK(A,B,R,N,TAU,SD,Z,NR)  C " C        DESCRIPTION OF PARAMETERSC C           A   - INPUT VECTOR OF N OBSERVATIONS FOR FIRST VARIABLE D C           B   - INPUT VECTOR OF N OBSERVATIONS FOR SECOND VARIABLEF C           R   - @                                                                                                                                                                                                                                                                                                                                                                          5 $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]KRANK.FOR;1                                                                                       H     	                         
y             OUTPUT VECTOR OF RANKED DATA OF LENGTH 2*N. SMALLESTD C                 OBSERVATION IS RANKED 1, LARGEST IS RANKED N. TIES5 C                 ARE ASSIGNED AVERAGE OF TIED RANKS. ( C           N   - NUMBER OF OBSERVATIONS? C           TAU - KENDALL RANK CORRELATION COEFFICIENT (OUTPUT) - C           SD  - STANDARD DEVIATION (OUTPUT) @ C           Z   - TEST OF SIGNIFICANCE OF TAU IN TERMS OF NORMAL' C                 DISTRIBUTION (OUTPUT) D C           NR  - CODE, 0 FOR UNRANKED DATA IN A AND B, 1 FOR RANKED) C                 DATA IN A AND B (INPUT)  C  C        REMARKS: C           SD AND Z ARE SET TO ZERO IF N IS LESS THAN TEN C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           RANK C           TIE  C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956, C           CHAPTER 9  C H C     .................................................................. C +       SUBROUTINE KRANK(A,B,R,N,TAU,SD,Z,NR)        DIMENSION A(1),B(1),R(1) C        SD=0.0       Z=0.0 
       FN=N       FN1=N*(N-1)  C ) C        DETERMINE WHETHER DATA IS RANKED  C        IF(NR-1) 5, 10, 5  C B C        RANK DATA IN A AND B VECTORS AND ASSIGN TIED OBSERVATIONS C        AVERAGE OF TIED RANKS C      5 CALL RANK (A,R,N)        CALL RANK (B,R(N+1),N)       GO TO 40 C % C        MOVE RANKED DATA TO R VECTOR  C     10 DO 20 I=1,N     20 R(I)=A(I)        DO 30 I=1,N        J=I+N     30 R(J)=B(I)  C 5 C        SORT RANK VECTOR R IN SEQUENCE OF VARIABLE A  C 
    40 ISORT=0        DO 50 I=2,N        IF(R(I)-R(I-1)) 45,50,50    45 ISORT=ISORT+1        RSAVE=R(I)       R(I)=R(I-1)        R(I-1)=RSAVE       I2=I+N       SAVER=R(I2)        R(I2)=R(I2-1)        R(I2-1)=SAVER     50 CONTINUE       IF(ISORT) 40,55,40 C E C        COMPUTE S ON VARIABLE B. STARTING WITH THE FIRST RANK, ADD 1 G C        TO S FOR EACH LARGER RANK TO ITS RIGHT AND SUBTRACT 1 FOR EACH - C        SMALLER RANK.  REPEAT FOR ALL RANKS.  C     55 S=0.0        NM=N-1       DO 60 I=1,NM       J=N+I        DO 60 L=I,N        K=N+L        IF(R(K)-R(J)) 56,60,57
    56 S=S-1.0        GO TO 60
    57 S=S+1.0     60 CONTINUE C 4 C        COMPUTE TIED SCORE INDEX FOR BOTH VARIABLES C 
       KT=2       CALL TIE(R,N,KT,TA)        CALL TIE(R(N+1),N,KT,TB) C  C        COMPUTE TAU C        IF(TA) 70,65,70     65 IF(TB) 70,67,70     67 TAU=S/(0.5*FN1)        GO TO 803    70 TAU=S/((SQRT(0.5*FN1-TA))*(SQRT(0.5*FN1-TB)))  C ; C     COMPUTE STANDARD DEVIATION AND Z IF N IS 10 OR LARGER  C     80 IF(N-10) 90,85,85 ,    85 SD=(SQRT((2.0*(FN+FN+5.0))/(9.0*FN1)))       Z=TAU/SD    90 RETURN	       END                                                                                                                                                                                                                                                                                                                                                 & * [STANVICK.SEAS$WORK_294000DB]LEP.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @@  7 M\#A  8          9          G    H  J                          C H C     .................................................................. C  C        SUBROUTINE LEP  C  C        PURPOSEA C           COMPUTE THE VALUES OF THE LEGENDRE POLYNOMIALS P(N,X) 6 C           FOR ARGUMENT VALUE X AND ORDERS 0 UP TO N. C  C        USAGE C           CALL LEP(Y,X,N)  C " C        DESCRIPTION OF PARAMETERSH C           Y     - RESULT VECTOR OF DIMENSION N+1 CONTAINING THE VALUES> C                   OF LEGENDRE POLYNOMIALS OF ORDER 0 UP TO N) C                   FOR GIVEN ARGUMENT X. = C                   VALUES ARE ORDERED FROM LOW TO HIGH ORDER 3 C           X     - ARGUMENT OF LEGENDRE POLYNOMIAL 0 C           N     - ORDER OF LEGENDRE POLYNOMIAL C  C        REMARKS3 C           N LESS THAN 0 IS TREATED AS IF N WERE 0  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD > C           EVALUATION IS BASED ON THE RECURRENCE EQUATION FOR' C           LEGENDRE POLYNOMIALS P(N,X) C C           P(N+1,X)=2*X*P(N,X)-P(N-1,X)-(X*P(N,X)-P(N-1,X))/(N+1), : C           WHERE THE FIRST TERM IN BRACKETS IS THE ORDER,' C           THE SECOND IS THE ARGUMENT. 3 C           STARTING VALUES ARE P(0,X)=1, P(1,X)=X.  C H C     .................................................................. C        SUBROUTINE LEP(Y,X,N)  C        DIMENSION Y(1) C  C        TEST OF ORDER
       Y(1)=1.        IF(N)1,1,2     1 RETURN C      2 Y(2)=X       IF(N-1)1,1,3 C      3 DO 4 I=2,N       G=X*Y(I)+     4 Y(I+1)=G-Y(I-1)+G-(G-Y(I-1))/FLOAT(I)        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]LOAD.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  @  7 `n#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE LOAD C  C        PURPOSEB C           COMPUTE A FACTOR MATRIX (LOADING) FROM EIGENVALUES ANDE C           ASSOCIATED EIGENVECTORS.  THIS SUBROUTINE NORMALLY OCCURS F C           IN A SEQUENCE OF CALLS TO SUBROUTINES CORRE, EIGEN, TRACE,D C           LOAD, AND VARMX IN THE PERFORMANCE OF A FACTOR ANALYSIS. C  C        USAGE C           CALL LOAD (M,K,R,V)  C " C        DESCRIPTION OF PARAMETERS( C           M     - NUMBER OF VARIABLES.F C           K     - NUMBER OF FACTORS. K MUST BE GREATER THAN OR EQUAL5 C                   TO 1 AND LESS THAN OR EQUAL TO M. E C           R     - A MATRIX (SYMMETRIC AND STORED IN COMPRESSED FORM D C                   WITH ONLY UPPER TRIANGLE BY COLUMN IN CORE) CON-E C                   TAINING EIGENVALUES IN DIAGONAL.  EIGENVALUES ARE = C                   ARRANGED IN DESCENDING ORDER, AND FIRST K G C                   EIGENVALUES ARE USED BY THIS SUBROUTINE.  THE ORDER G C                   OF MATRIX R IS M BY M.  ONLY M*(M+1)/2 ELEMENTS ARE 4 C                   IN STORAGE.  (STORAGE MODE OF 1)D C           V     - WHEN THIS SUBROUTINE IS CALLED, MATRIX V (M X M)H C                   CONTAINS EIGENVECTORS COLUMNWISE.  UPON RETURNING TOC C                   THE CALLING PROGRAM, MATRIX V CONTAINS A FACTOR # C                   MATRIX (M X K).  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           NORMALIZED EIGENVECTORS ARE CONVERTED TO THE FACTOR PATTERN D C           BY MULTIPLYING THE ELEMENTS OF EACH VECTOR BY THE SQUARE1 C           ROOT OF THE CORRESPONDING EIGENVALUE.  C H C     .................................................................. C        SUBROUTINE LOAD (M,K,R,V)        DIMENSION R(1),V(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C # C     DOUBLE PRECISION R,V,SQ,DSQRT  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOG C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENT & C        150 MUST BE CHANGED TO DSQRT. C H C        ............................................................... C 	       L=0 
       JJ=0       DO 160 J=1,K
       JJ=JJ+J    150 SQ= SQRT(R(JJ))        DO 160 I=1,M       L=L+1    160 V(L)=SQ*V(L)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ~ $      RTI020.J                       Y  =  &[STANVICK.SEAS$WORK_294000DB]LOC.FOR;1                                                                                         H                              p              & * [STANVICK.SEAS$WORK_294000DB]LOC.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6  @  7 #A  8          9          G    H  J                          C H C     .................................................................. C  C        SUBROUTINE LOC  C  C        PURPOSED C           COMPUTE A VECTOR SUBSCRIPT FOR AN ELEMENT IN A MATRIX OF" C           SPECIFIED STORAGE MODE C  C        USAGE$ C           CALL LOC (I,J,IR,N,M,MS) C " C        DESCRIPTION OF PARAMETERS' C           I   - ROW NUMBER OF ELEMENT + C           J   - COLUMN NUMBER  OF ELEMENT , C           IR  - RESULTANT VECTOR SUBSCRIPT* C           N   - NUMBER OF ROWS IN MATRIX- C           M   - NUMBER OF COLUMNS IN MATRIX = C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           MS=0   SUBSCRIPT IS COMPUTED FOR A MATRIX WITH N*M ELEMENTS . C                  IN STORAGE (GENERAL MATRIX)G C           MS=1   SUBSCRIPT IS COMPUTED FOR A MATRIX WITH N*(N+1)/2 IN C C                  STORAGE (UPPER TRIANGLE OF SYMMETRIC MATRIX). IF G C                  ELEMENT IS IN LOWER TRIANGULAR PORTION, SUBSCRIPT IS ; C                  CORRESPONDING ELEMENT IN UPPER TRIANGLE. E C           MS=2   SUBSCRIPT IS COMPUTED FOR A MATRIX WITH N ELEMENTS E C                  IN STORAGE (DIAGONAL ELEMENTS OF DIAGONAL MATRIX). F C                  IF ELEMENT IS NOT ON DIAGONAL (AND THEREFORE NOT IN/ C                  STORAGE), IR IS SET TO ZERO.  C H C     .................................................................. C #       SUBROUTINE LOC(I,J,IR,N,M,MS)  C 
       IX=I
       JX=J       IF(MS-1) 10,20,30     10 IRX=N*(JX-1)+IX        GO TO 36    20 IF(IX-JX) 22,24,24    22 IRX=IX+(JX*JX-JX)/2        GO TO 36    24 IRX=JX+(IX*IX-IX)/2        GO TO 36    30 IRX=0        IF(IX-JX) 36,32,36    32 IRX=IX    36 IR=IRX       RETURN	       END                                                                                                             ) * [STANVICK.SEAS$WORK_294000DB]MACHK1.COM;1 +  , Y   .     /     4 B                         - =    0   1    2   3      K  P   W   O     5 -  6 @ψ@  7  Ô#A  8          9          G    H  J                      B $ COPY IN$:MACHK1.FOR,ARRAY.FOR,GMADD.FOR,GMPRD.FOR TMP$:TMPSSP.11@ $ COPY IN$:GMSUB.FOR,GMTRA.FOR,GTPRD.FOR,MADD.FOR TMP$:TMPSSP.12! $ COPY IN$:LOC.FOR TMP$:TMPSSP.13 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 - $ FORTRAN/OBJECT=TMP$:TMPSSP.3 TMP$:TMPSSP.13 ? $ LINK/EXECUTABLE=TMP$:TMPSSP.4 TMP$:TMPSSP.1,TMPSSP.2,TMPSSP.3  $ RUN TMP$:TMPSSP.4  $ DELETE TMP$:TMPSSP.*;*                                                                                                  ) * [STANVICK.SEAS$WORK_294000DB]MACHK1.FOR;1 +  , Y   .     /     4 @       t                    - =    0   1    2   3      K  P   W   O     5 -  6 @@  7 #A  8          9          G    H  J                      - C	RT-11 FORTRAN SCIENTIFIC SUBROUTINE PACKAGE  C	DEC-11-XXXXX-A-LA  C  C  C  C  C  C  C  C  C  C 5 C	COPYRIGHT (C) 1974 BY DIGITAL EQUIPMENT CORPORATION  C	MAYNARD, MASSACHUSETTS  01754  C  C  C  C  C  C  C  C  C 7 C	THE INFORMATION IN THIS DOCUMENT IS SUBJECT TO CHANGE < C	WITHOUT NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT6 C	BY DIGITAL EQUIPMENT CORPORATION.  DIGITAL EQUIPMENT6 C	CORPORATION ASSUMES NO RESPONSIBILITY FOR ANY ERRORS# C	THAT MAY APPEAR IN THIS DOCUMENT.  C 9 C	THE SOFTWARE DESCRIBED IN THIS DOCUMENT IS FURNISHED TO < C	THE PURCHASER UNDER A LICENSE FOR USE ON A SINGLE COMPUTER7 C	SYSTEM AND CAN BE COPIED (WITH INCLUSION OF DIGITAL'S : C	COPYRIGHT NOTICE) ONLY FOR USE IN SUCH SYSTEM, EXCEPT AS2 C	MAY OTHERWISE BE PROVIDED IN WRITING BY DIGITAL. C 9 C	DIGITAL EQUIPMENT CORPORATION ASSUMES NO RESPONSIBILITY 9 C	FOR THE USE OR RELIABILITY OF ITS SOFTWARE ON EQUIPMENT " C	THAT IS NOT SUPPLIED BY DIGITAL. C  C  C  C  C  C  C  C  C  C  C  C  C	R. SHIELDS	OCTOBER 1974  C  C  C  C  C  C  C  C  C  C  C  C  C  C = C	MACHK1.FTN - SAMPLE TO CHECK THE FOLLOWING MATRIX ROUTINES: " C  GMADD	- GENERAL MATRIX ADDITION% C  GMSUB	- GENERAL MATRIX SUBTRACTION # C  GMTRA	- GENERAL MATRIX TRANSPOSE ( C  GMPRD	- GENERAL MATRIX MULTIPLICATION5 C  GTPRD	- TRANSPOSE OF A MATRIX TIMES ANOTHER MATRIX 3 C  ARRAY	- ARRAY CONVERSION ROUTINE (BETWEEN MODES)  C  MADD		- MATRIX ADDITION C & 	DIMENSION A(3,3),B(4,4),C(3,3),D(3,3)5 	DATA B/1.,2.,-1.7,0.,3.,2.6,1.9,1.,4.7,-2.,3.4,5*0./ ) 	DATA C/1.2,3.4,-2.9,6.4,2*0.,-1.,0.,2.5/  C ! 	TYPE 100, ((B(I,J),J=1,4),I=1,4) - 100	FORMAT(/' ORIGINAL 4X4 MATRIX:'//(4F8.2))  	CALL ARRAY(2,3,3,4,4,A,B)! 	TYPE 101, ((A(I,J),J=1,3),I=1,3) < 101	FORMAT(//' TOP 3X3 CORNER EXTRACTED BY ARRAY:'//(3F8.2))" 	TYPE 102,  ((C(I,J),J=1,3),I=1,3)8 102	FORMAT(//' ADD TO IT THE FOLLOWING ARRAY:'//(3F8.2)) 	CALL GMADD(A,C,D,3,3)! 	TYPE 103, ((D(I,J),J=1,3),I=1,3) ; 103	FORMAT(//' SUM OF TWO ARRAYS USING GMADD IS:'//(3F8.2))  	CALL MADD(A,C,D,3,3,0,0) ! 	TYPE 203, ((D(I,J),J=1,3),I=1,3) : 203	FORMAT(//' SUM OF TWO ARRAYS USING MADD IS:'//(3F8.2)) 	CALL GMSUB(D,C,A,3,3)! 	TYPE 104, ((A(I,J),J=1,3),I=1,3) @ 104	FORMAT(//' SUBTRACTING SECOND ARRAY OUT BY GMSUB:'//(3F8.2)) 	CALL GMTRA(A,D,3,3)" 	TYPE 105,  ((D(I,J),J=1,3),I=1,3)8 105	FORMAT(//' TRANSPOSE MATRIX VIA GMTRA IS:'//(3F8.2)) 	CALL GMPRD(D,D,C,3,3,3)" 	TYPE 106,  ((C(I,J),J=1,3),I=1,3)> 106	FORMAT(//' THE TRANSPOSE SQUARED VIA GMPRD IS:'//(3F10.4)) 	CALL GTPRD(A,D,C,3,3,3)" 	TYPE 107,  ((C(I,J),J=1,3),I=1,3)< 107	FORMAT(//' WHICH SHOULD ALSO BE (VIA GTPRD):'//(3F10.4)) 	STOP 'MACHK1 successful!' 	END                                                                                                                                                                                                                                                                                                                                                                                                                          ) * [STANVICK.SEAS$WORK_294000DB]MACHK2.COM;1 +  , Y
   .     /     4 ?                         - =    0   1    2   3      K  P   W   O     5 -  6 @淉@  7 |#A  8          9          G    H  J                      ? $ COPY IN$:MACHK2.FOR,CCUT.FOR,CTIE.FOR,DCLA.FOR TMP$:TMPSSP.11 = $ COPY IN$:MATA.FOR,MCPY.FOR,RCUT.FOR,RTIE.FOR TMP$:TMPSSP.12 < $ COPY IN$:TPRD.FOR,XCPY.FOR,DCPY.FOR,LOC.FOR TMP$:TMPSSP.13- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 - $ FORTRAN/OBJECT=TMP$:TMPSSP.3 TMP$:TMPSSP.13 ? $ LINK/EXECUTABLE=TMP$:TMPSSP.4 TMP$:TMPSSP.1,TMPSSP.2,TMPSSP.3  $ RUN TMP$:TMPSSP.4  $ DELETE TMP$:TMPSSP.*;*                                                                            ) * [STANVICK.SEAS$WORK_294000DB]MACHK2.FOR;1 +  , Y	   .     /     4 B                           - =    0   1    2   3      K  P   W   O     5 -  6  S@  7  #A  8          9          G    H  J                      / C	MACHK2.FTN - SAMPLE PROGRAM (MATRICES) USING:  C  XCPY		- SUBMATRIX COPY  C  MCPY		- MATRIX COPY C  TRPD		- TRANSPOSE PRODUCT C  MATA		- TRANSPOSE PRODUCT! C  DCPY		- COPY DIAGONAL ELEMENTS 4 C  DCLA		- SET DIAGONAL ELEMENTS EQUAL TO A CONSTANT% C  CTIE		- ADJOIN MATRICES BY COLUMNS " C  RTIE		- ADJOIN MATRICES BY ROWS( C  CCUT		- PARTITION MATRICES BY COLUMNS% C  RCUT		- PARTITION MATRICES BY ROWS B C	MOST OF THE ROUTINES LISTED HERE CALL LOC - LOCATION CALCULATION C / 	DIMENSION A(4,4),R(3,3),B1(3,2),E(2,3),B2(3,2) % 	DIMENSION BB(2,2),C(3),C2(2,2),R1(3)  	EQUIVALENCE (A,BB,R),(E,B1)? 	DATA A/-1.,6.,7.,8.,-2.,0.,1.,2.,-3.,3.,4.,5.,-4.,-5.,-6.,-7./  	DATA R1/1.,2.,10./  C  C ! 	TYPE 100, ((A(I,J),J=1,4),I=1,4) ( 100	FORMAT(//' ORIGINAL MATRIX'/(4F8.1)) 	CALL XCPY(A,B1,2,2,3,2,4,4,0)" 	TYPE 101, ((B1(I,J),J=1,2),I=1,3)B 101	FORMAT(//' 3X2 SUBMATRIX AT ELEMENT (2,3) USING XCPY'/(2F8.1)) 	CALL MCPY(B1,B2,3,2,0) " 	TYPE 102, ((B2(I,J),J=1,2),I=1,3)6 102	FORMAT(//' SAME MATRIX COPIED USING MCPY'/(2P                                                                                                                                                                                                                                                                                                                                                                                          }_1 $      RTI020.J                       Y	  =  )[STANVICK.SEAS$WORK_294000DB]MACHK2.FOR;1                                                                                      B                                           F8.1)) 	CALL TPRD(B1,B2,BB,3,2,0,0,2)" 	TYPE 103, ((BB(I,J),J=1,2),I=1,2)< 103	FORMAT(//' TRANSPOSE OF MATRIX TIMES MATRIX USING TPRD'/ 	1 (2F8.1))  	CALL MATA(B1,C2,3,2,0) * 	TYPE 104, C2(1,1),C2(2,1),C2(2,1),C2(1,2)0 104	FORMAT(//' SAME PRODUCT USING MATA'/(2F8.1)) 	CALL DCPY(C2,C,2,1) 	TYPE 105, C(1),C(2)4 105	FORMAT(//' DIAGONAL ELEMENTS USING DCPY'/(F8.1)) 	CALL DCLA(BB,2.,2,0) " 	TYPE 106, ((BB(I,J),J=1,2),I=1,2)= 106	FORMAT(//' REPLACING DIAGONAL BY 2.0 USING DCLA'/(2F8.1))  	CALL CTIE(BB,C,E,2,2,0,0,1)! 	TYPE 107, ((E(I,J),J=1,3),I=1,2) @ 107	FORMAT(//' ADJOINING THESE TWO MATRICES USING CTIE'/(3F8.1))
 	TYPE 108, R1 - 108	FORMAT(//' TAKE THIS ROW VECTOR'/(3F8.1))  	CALL RTIE(E,R1,R,2,3,0,0,1)" 	TYPE 109,  ((R(I,J),J=1,3),I=1,3)@ 109	FORMAT(//' ADJOINING THESE TWO MATRICES USING RTIE'/(3F8.1)) 	CALL CCUT(R,3,B1,C,3,3,0)' 	TYPE 110, ((B1(I,J),J=1,2),C(I),I=1,3) > 110	FORMAT(//' PARTITIONING BETWEEN COLS. 2 AND 3 USING CCUT'/ 	1 (2F8.1,12X,F8.1)) 	CALL RCUT(B1,2,R1,C2,3,2,0)0 	TYPE 111, (R1(I),I=1,2),((C2(I,J),J=1,2),I=1,2)= 111	FORMAT(//' PARTITIONING BETWEEN ROWS 1 AND 2 USING RCUT'/  	1 2F8.1//(2F8.1)) 	STOP 'MACHK2 successful!' 	END                                                                                                                                                                                                                                                                                                                                                                                        ) * [STANVICK.SEAS$WORK_294000DB]MACHK3.COM;1 +  , Y   .     /     4 ?                         - =    0   1    2   3      K  P   W   O     5 -  6 @@  7  #A  8          9          G    H  J                      ? $ COPY IN$:MACHK3.FOR,CCPY.FOR,CSUM.FOR,MFUN.FOR TMP$:TMPSSP.11 = $ COPY IN$:MSUB.FOR,RSRT.FOR,RSUM.FOR,SMPY.FOR TMP$:TMPSSP.12 ! $ COPY IN$:LOC.FOR TMP$:TMPSSP.13 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 - $ FORTRAN/OBJECT=TMP$:TMPSSP.3 TMP$:TMPSSP.13 ? $ LINK/EXECUTABLE=TMP$:TMPSSP.4 TMP$:TMPSSP.1,TMPSSP.2,TMPSSP.3  $ RUN TMP$:TMPSSP.4  $ DELETE TMP$:TMPSSP.*;*                                                                                                      ) * [STANVICK.SEAS$WORK_294000DB]MACHK3.FOR;1 +  , Y   .     /     4 C                           - =    0   1    2   3      K  P   W   O     5 -  6  z/@  7 #A  8          9          G    H  J          
            8 C	MACHK3.FOR - SAMPLE PROGRAM (MATRIX OPERATIONS) USING:" C  MSUB		- SUBTRACTION OF MATRICES) C  MFUN		- TRANSFORM MATRIX BY A FUNCTION ( C  SMPY		- MULTIPLY A MATRIX BY A SCALAR C  RSUM		- SUM ROWS OF MATRIX   C  CSUM		- SUM COLUMNS OF MATRIX C  RSRT		- SORT ROWS OF MATRIX, C  CCPY		- COPY COLUMN OF MATRIX INTO VECTORC C    ALSO... MOST OF THESE ROUTINES CALL LOC - LOCATION CALCULATION  	EXTERNAL POSDIF/ 	DIMENSION SOLD(4,5),ECP(4,5),CUR(4,5),SCR(4,5) # 	DIMENSION SS(4),SE(4),RK(4),TOT(1) , C	DATA STATEMENT REPLACES THE NORMAL READ IN> 	DATA SOLD/10.,12.,8.,16.,6.,3.,2.,9.,9.,2.,0.,7.,24.,17.,22., 	1         19.,13.,15.,15.,24./ ? 	2     ECP/5.,12.,10.,12.,4.,4.,4.,6.,10.,3.,3.,6.,25.,20.,20.,  	3         20.,12.,17.,15.,20./  C 	 	TYPE 100 ? 100	FORMAT(//' STORE'10X' GOODS SOLD'9X' EXPECTED TO BE SOLD'/)  	DO 1 I=1,4 0 1	TYPE 101, I,(SOLD(I,J),J=1,5),(ECP(I,J),J=1,5)! 101	FORMAT(I4,7X,5F4.0,5X,5F4.0/)  C # C  SEE WHO IS AHEAD OF EXPECTATIONS   	CALL MSUB(SOLD,ECP,CUR,4,5,0,0)  	CALL MFUN(CUR,POSDIF,SCR,4,5,0) 	DO 2 I=1,4  	TYPE 102, I 102	FORMAT(/' STORE',I2,':') 	DO 2 J=1,5  	X=SCR(I,J)  	IF(X) 3,2,4 3	STOP 'unexpected #1'   4	TYPE 103, X,J 7 103	FORMAT('   IS AHEAD',F4.0,' UNIT(S) OF PRODUCT',I2) 
 2	CONTINUE C  C  SEE WHO IS BEHIND 	CALL SMPY(CUR,-1.,CUR,4,5,0)   	CALL MFUN(CUR,POSDIF,SCR,4,5,0) 	DO 5 I=1,4  	TYPE 102, I 	DO 5 J=1,5  	X=SCR(I,J)  	IF(X) 6,5,7 6	STOP 'unexpected #2'   7	TYPE 104, X,J 8 104	FORMAT('   IS BEHIND',F4.0,' UNIT(S) OF PRODUCT',I2)
 5	CONTINUE C  C  GET STATISTICS  	CALL RSUM(SOLD,SS,4,5,0)  	CALL RSUM(ECP,SE,4,5,0) 	CALL CSUM(SS,TOT,4,1,0)	 	TYPE 105 9 105	FORMAT(//' STORE   SOLD/EXP (PER CENT)   TOTAL SALES   	1(ALL STORES)'/)  	DO 8 I=1,4  	X=SS(I)/SE(I)*100.  	XT=SS(I)/TOT(1)*100.  8	TYPE 106, I,X,XT  106	FORMAT(I4,11X,F7.2,16X,F7.2) 	CALL SMPY(CUR,-1.,CUR,4,5,0)  C  C  DETERMINE PROGRESS IN SALES	 	TYPE 107 @ 107	FORMAT(//' PRODUCT   STORES ACCORDING TO INCREASING SALES'/) 	DO 9 I=1,5  	DO 10 J=1,4 10	RK(J)=FLOAT(J)  	CALL CCPY(SOLD,I,SS,4,5,0)  	CALL RSRT(RK,SS,SCR,4,1,0)  9	TYPE 108, I,(SCR(J,1),J=1,4) 108	FORMAT(I5,6X,4F5.0)  	STOP 'MACHK3 successful!' 	END 	FUNCTION POSDIF(X) 	 	POSDIF=X  	IF(X) 1,2,2 1	POSDIF=0.  2	RETURN 	END                                                                                                                                                                                                                                                                                                                          ) * [STANVICK.SEAS$WORK_294000DB]MACHK4.COM;1 +  ,    .     /     4 H       D                   - =    0   1    2   3      K  P   W   O     5 -  6  #@  7 `N
#A  8          9          G    H  J                      ? $ COPY IN$:MACHK4.FOR,CADD.FOR,CCPY.FOR,CSRT.FOR TMP$:TMPSSP.11 = $ COPY IN$:MPRD.FOR,MSTR.FOR,RADD.FOR,RCPY.FOR TMP$:TMPSSP.12 E $ COPY IN$:SADD.FOR,SCLA.FOR,SDIV.FOR,SSUB.FOR,LOC.FOR TMP$:TMPSSP.13 = $ COPY IN$:CTAB.FOR,MFUN.FOR,RECP.FOR,RTAB.FOR TMP$:TMPSSP.14 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 - $ FORTRAN/OBJECT=TMP$:TMPSSP.3 TMP$:TMPSSP.13 - $ FORTRAN/OBJECT=TMP$:TMPSSP.4 TMP$:TMPSSP.14 H $ LINK/EXECUTABLE=TMP$:TMPSSP.5 TMP$:TMPSSP.1,TMPSSP.2,TMPSSP.3,TMPSSP.4 $ RUN TMP$:TMPSSP.5  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ) * [STANVICK.SEAS$WORK_294000DB]MACHK4.FOR;1 +  , Y   .     /     4 E                           - =    0   1    2   3      K  P   W   O     5 -  6 &@  7 $!#A  8          9          G    H  J                      1 C	MACHK4.FTN - SAMPLE PROGRAM (MATRIX OPERATIONS)  C  RCPY	- COPY ROW INTO VECTOR C  MSTR	- CONVERT STORAGE MODE C  MPRD	- MULTIPLY TWO MATRICES  C  SADD	- ADD SCALAR TO MATRIX% C  SSUB	- SUBTRACT SCALAR FROM MATRIX ! C  SDIV	- DIVIDE MATRIX BY SCALAR / C  SCLA	- SET MATRIX ELEMENTS EQUAL TO A SCALAR * C  RADD	- ADD ROW TO ROW OF ANOTHER MATRIX, C  CADD	- ADD COL. TO COL. OF ANOTHER MATRIX# C  RTAB	- TABULATE ROWS OF A MATRIX $ C  CTAB	- TABULATE COLS. OF A MATRIX C  CSRT	- SORT COLUMNS& C  RECP	- RECIPROCAL FUNCTION FOR MFUN C    ALSO	- MFUN, CCPY, LOC  C  	EXTERNAL RECP3 	DIMENSION A(3,3),B(3,3),C(3,3),R(3),U(4),S(4),T(3)  	EQUIVALENCE (R,U), (S,T) 1 	DATA A/1.,1.,-1.,2.,0.,3.,3.,-1.,2./,R/1.,2.,3./ ! 	TYPE 100, ((A(I,J),J=1,3),I=1,3) * 100	FORMAT(//' ORIGINAL MATRIX:'/(3F10.2)) C  SET B = ALL ONES  	CALL SCLA(B,1.0,3,3,0)  	CALL SADD(A,1.0,C,3,3,0) ! 	TYPE 101, ((B(I,J),J=1,3),I=1,3) 1 101	FORMAT(//' MATRIX OF ONES BY SCLA:'/(3F10.2)) " 	TYPE 102,  ((C(I,J),J=1,3),I=1,3)4 102	FORMAT(//' SIMULATE ADDITION BY SADD:'/(3F10.2))" C  CONVERT DIAGONAL R TO GENERAL A 	CALL MSTR(R,A,3,2,0) # 	TYPE 103, R,((A(I,J),J=1,3),I=1,3) E 103	FORMAT(//' EXPAND DIAGONAL TO GENERAL BY MSTR:'/3F10.2//(3F10.2))  C  MULTIPLY MATRICES 	CALL MPRD(A,C,B,3,3,0,0,3) ! 	TYPE 104, ((B(I,J),J=1,3),I=1,3) 9 104	FORMAT(//' PRODUCT OF MATRICES USING MPRD:'/(3F10.2))  C  GET THE FIRST COLUMN  	CALL CADD(C,1,B,1,3,3,0,3) ! 	TYPE 105, ((B(I,J),J=1,3),I=1,3) C 105	FORMAT(//' ADDING (2,2,0) TO THE FIRST COL. BY CADD:'/(3F10.2))  C  GET A ROW 	CALL RCPY(B,1,R,3,3,0)  	TYPE 106, R* 106	FORMAT(//' FIRST ROW BY RCPY:'/3F10.2) 	CALL SDIV(B,2.,B,3,3,0) 	CALL SSUB(R,1.9,R,3,1,0) ' 	TYPE 107,  ((B(I,J),J=1,3),R(I),I=1,3) = 107	FORMAT(//' DIVIDING 3X3 MATRIX BY 2. AND      SUBTRACTING , 	1 1.9 FROM ROW VECTOR:'/(3F10.2,10X,F10.2)) 	CALL CTAB(B,R,A,S,3,3,0,3) $ 	TYPE 108,  ((A(I,J),J=1,3),I=1,3),S; 108	FORMAT(//' TABULATING THE COLUMNS BY CTAB:'/3(3F10.2/)/ 9 	1'   NUMBER OF OLD COLUMNS USED IN NEW COLUMNS:'/4F10.2)  	CALL CSRT(A,T,B`                                                                                                                                           L $      RTI020.J                       Y  =  )[STANVICK.SEAS$WORK_294000DB]MACHK4.FOR;1                                                                                      E                              `             ,3,3,0) " 	TYPE 109,  ((B(I,J),J=1,3),I=1,3)7 109	FORMAT(//' COLUMNS ALIGNED BY NUMBER OF OLD COLS.'/ " 	1'   IN THEM VIA CSRT:'/(3F10.2)) 	CALL RTAB(B,T,A,U,3,3,0,3) $ 	TYPE 110,  ((A(I,J),J=1,3),I=1,3),U8 110	FORMAT(//' TABULATING THE ROWS BY RTAB:'/3(3F10.2/)/3 	1'   NUMBER OF OLD ROWS USED IN NEW ROWS:'/4F10.2)  	CALL SADD(A,1.5,B,3,3,0)  	CALL MFUN(B,RECP,A,3,3,0)" 	TYPE 111,  ((A(I,J),J=1,3),I=1,3)E 111	FORMAT(//' ADDING 1.5 TO EACH ELEMENT AND TAKING THE RECIPROCAL:'  	1/(3F10.2)) 	STOP 'MACHK4 successful!' 	END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ' * [STANVICK.SEAS$WORK_294000DB]MADD.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  @  7 `1#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MADD C  C        PURPOSEA C           ADD TWO MATRICES ELEMENT BY ELEMENT TO FORM RESULTANT  C           MATRIX C  C        USAGE( C           CALL MADD(A,B,R,N,M,MSA,MSB) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX$ C           B - NAME OF INPUT MATRIX% C           R - NAME OF OUTPUT MATRIX ' C           N - NUMBER OF ROWS IN A,B,R * C           M - NUMBER OF COLUMNS IN A,B,R? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSB - SAME AS MSA EXCEPT FOR MATRIX B  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD G C           STORAGE MODE OF OUTPUT MATRIX IS FIRST DETERMINED. ADDITION 8 C           OF CORRESPONDING ELEMENTS IS THEN PERFORMED.D C           THE FOLLOWING TABLE SHOWS THE STORAGE MODE OF THE OUTPUT9 C           MATRIX FOR ALL COMBINATIONS OF INPUT MATRICES > C                         A                B                 R@ C                      GENERAL          GENERAL          GENERAL@ C                      GENERAL          SYMMETRIC        GENERAL@ C                      GENERAL          DIAGONAL         GENERAL@ C                      SYMMETRIC        GENERAL          GENERALB C                      SYMMETRIC        SYMMETRIC        SYMMETRICB C                      SYMMETRIC        DIAGONAL         SYMMETRIC@ C                      DIAGONAL         GENERAL          GENERALB C                      DIAGONAL         SYMMETRIC        SYMMETRICA C                      DIAGONAL         DIAGONAL         DIAGONAL  C H C     .................................................................. C (       SUBROUTINE MADD(A,B,R,N,M,MSA,MSB)       DIMENSION A(1),B(1),R(1) C 0 C        DETERMINE STORAGE MODE OF OUTPUT MATRIX C        IF(MSA-MSB) 7,5,7      5 CALL LOC(N,M,NM,N,M,MSA)       GO TO 100      7 MTEST=MSA*MSB        MSR=0        IF(MTEST) 20,20,10    10 MSR=1     20 IF(MTEST-2) 35,35,30    30 MSR=2  C - C        LOCATE ELEMENTS AND PERFORM ADDITION  C     35 DO 90 J=1,M        DO 90 I=1,N        CALL LOC(I,J,IJR,N,M,MSR)        IF(IJR) 40,90,40    40 CALL LOC(I,J,IJA,N,M,MSA) 
       AEL=0.0        IF(IJA) 50,60,50    50 AEL=A(IJA)    60 CALL LOC(I,J,IJB,N,M,MSB) 
       BEL=0.0        IF(IJB) 70,80,70    70 BEL=B(IJB)    80 R(IJR)=AEL+BEL    90 CONTINUE       RETURN C % C        ADD MATRICES FOR OTHER CASES  C    100 DO 110 I=1,NM    110 R(I)=A(I)+B(I)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                           ' * [STANVICK.SEAS$WORK_294000DB]MATA.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @  7  JG#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MATA C  C        PURPOSE; C           PREMULTIPLY A MATRIX BY ITS TRANSPOSE TO FORM A  C           SYMMETRIC MATRIX C  C        USAGE! C           CALL MATA(A,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS% C           A  - NAME OF INPUT MATRIX & C           R  - NAME OF OUTPUT MATRIX$ C           N  - NUMBER OF ROWS IN A@ C           M  - NUMBER OF COLUMNS IN A. ALSO NUMBER OF ROWS AND( C                NUMBER OF COLUMNS OF R.? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A G C           MATRIX R IS ALWAYS A SYMMETRIC MATRIX WITH A STORAGE MODE=1  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD H C           CALCULATION OF (A TRANSPOSE A) RESULTS IN A SYMMETRIC MATRIXC C           REGARDLESS OF THE STORAGE MODE OF THE INPUT MATRIX. THE 1 C           ELEMENTS OF MATRIX A ARE NOT CHANGED.  C H C     .................................................................. C !       SUBROUTINE MATA(A,R,N,M,MS)        DIMENSION A(1),R(1)  C        DO 60 K=1,M        KX=(K*K-K)/2       DO 60 J=1,M        IF(J-K) 10,10,60
    10 IR=J+KX 
       R(IR)=0        DO 60 I=1,N        IF(MS) 20,40,20     20 CALL LOC(I,J,IA,N,M,MS)        CALL LOC(I,K,IB,N,M,MS)        IF(IA) 30,60,30     30 IF(IB) 50,60,50     40 IA=N*(J-1)+I       IB=N*(K-1)+I    50 R(IR)=R(IR)+A(IA)*A(IB)     60 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                       ( * [STANVICK.SEAS$WORK_294000DB]MCANO.COM;1 +  , Y   .     /     4 7       :                  - =    0   1    2   3      K  P   W   O     5 -  6  [@  7 @ [#A  8          9          G    H  J                       7 $ COPY IN$:MCANO.FOR,CANOR.FOR,CORRE.FOR TMP$:TMPSSP.11 6 $ COPY IN$:EIGEN.FOR,MINV.FOR,NROOT.FOR TMP$:TMPSSP.12- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                    ( * [STANVICK.SEAS$WORK_294000DB]MCANO.DAT;1 +  , Y   .     /     4 *                           - =    0   1    2   3      K  P   W   O     5 -  6 @  7 r#A  8          9          G    H  J                        SAMPLE   23 4 3 *    191   155    65    19   179   145    70*    195   149    70    20   201   152    69*    181   148    71    19   185   149    75*    183   153    82    18   188   149    86*    176   144    67    18   171   142    71*    208   157    81    22   192   152    77*    189   150    75    21   190   149    72*    197   159    90    20   189   152    82*    188   152    76    19   197   159    84*    192   150    78    20   187   151    72*    179   158    99    18   186   148    89*    183   147    65    18   174   147    70*    174   150    71    19   185   152    65*    190   159    91    19   195   157    99*    188   151    98    20   187   158    87*    163   137    59    18   161   130    63*    195   155    85    20   183   158    81*    196   153    80    21   173   148    74*    181   145    77    20   182   146    70*    175   140    70    19   165   137    81*    192   154    69    20   185   152    63*    174   143    79    20   178   147    73*    176   139    70    20   176   143`                                                                                                                                           RQ $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]MCANO.DAT;1                                                                                       *                                               69                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ( * [STANVICK.SEAS$WORK_294000DB]MCANO.FOR;1 +  , Y   . 	    /     4 H   	   	                    - =    0   1    2   3      K  P   W   O 
    5 -  6 8c@  7 م#A  8          9          G    H  J                       7 C	SAMPLE MAIN PROGRAM FOR CANONICAL CORRELATION - MCANO $ C	USES  CORRE,CANOR,MINV,NROOT,EIGEN C		AND DATA (ATTACHED)? C	THE FOLLOWING DIMENSIONS MUST BE GREATER THAN OR EQUAL TO THE > C	TOTAL NUMBER OF VARIABLES M (M=MP+MQ, WHERE MP IS THE NUMBER< C	OF LEFT HAND VARIABLES AND MQ IS THE NUMBER OF RIGHT HAND 
 C	VARIABLES). 1 	DIMENSION XBAR(9),STD(9),CANR(9),CHISQ(9),NDF(9) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF M*M 	DIMENSION RX(81) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	(M+1)*M/2  	DIMENSION R(45)> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF MQ*MQ 	DIMENSION COEFL(81)> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF MQ*MQ 	DIMENSION COEFR(25) C 
 	COMMON INH C....................................................................... 1	FORMAT(A4,A2,I5,2I2)> 2	FORMAT(//'CANONICAL CORRELATION.....'A4,A2//'   NO. OF OBSER< 	1VATIONS'8X,I4/'   NO. OF LEFT HAND VARIABLES'I5/'   NO. OF 	2 RIGHT HAND VARIABLES'I4/) 3	FORMAT(/' MEANS'/(5F16.5))* 4	FORMAT(/' STANDARD DEVIATIONS'/(5F16.5))& 5	FORMAT(/' CORRELATION COEFFICIENTS') 6	FORMAT(/' ROW'I3/(5F16.5))A 7	FORMAT(//'   NUMBER OF'7X'LARGEST'7X'CORRESPONDING'27X'DEGREES' 7 	1/'  EIGENVALUES'5X'EIGENVALUE'7X'CANONICAL'7X'LAMBDA' > 	25X'CHI-SQUARE'4X'OF'/4X'REMOVED'7X'REMAINING'7X'CORRELATION' 	328X'FREEDOM'/)% 8	FORMAT(I7,F19.5,F16.5,2F14.5,3X,I5) ( 9	FORMAT(/' CANONICAL CORRELATION'F12.5)= 10	FORMAT(/'  COEFFICIENTS FOR LEFT HAND VARIABLES'/(5F16.5)) > 11	FORMAT(/'  COEFFICIENTS FOR RIGHT HAND VARIABLES'/(5F16.5))H C....................................................................... C	INPUT CHANNEL = IN 	IN=1  C  C	READ PROBLEM PARAMETER CARD 7 	OPEN (UNIT=1,NAME='IN$:MCANO.DAT',TYPE='OLD',READONLY)  100	READ(IN,1) PR,PR1,N,MP,MQ ' C	PR=PROBLEM NUMBER (MAY BE ALPHAMERIC)   C	PR1=PROBLEM NUMBER (CONTINUED) C	N=NUMBER OF OBSERVATIONS" C	MP=NUMBER OF LEFT HAND VARIABLES# C	MQ=NUMBER OF RIGHT HAND VARIABLES $ 	IF(N.EQ.0) STOP 'MCANO successful!' 	TYPE 2, PR,PR1,N,MP,MQ  	M=MP+MQ 	IO=0  	X=0.04 	CALL CORRE(N,M,IO,X,XBAR,STD,RX,R,CANR,CHISQ,COEFL)3 C	PRINT MEANS, STANDARD DEVIATIONS, AND CORRELATION  C	COEFFICIENTS OF ALL VARIABLES  	TYPE 3, (XBAR(I),I=1,M) 	TYPE 4, (STD(I),I=1,M)  	TYPE 5 
 	DO 160 I=1,M 
 	DO 150 J=1,M  	IF(I-J) 120,130,130 120	L=I+(J*J-J)/2 
 	GO TO 140 130	L=J+(I*I-I)/2  140	CANR(J)=R(L) 150	CONTINUE 160	TYPE 6, I,(CANR(J),J=1,M) = 	CALL CANOR(N,MP,MQ,R,XBAR,STD,CANR,CHISQ,NDF,COEFR,COEFL,RX) @ C	PRINT EIGENVALUES, CANONICAL CORRELATIONS, LAMBDA, CHI-SQUARES C	DEGREES OF FREEDOMS  	TYPE 7  	DO 170 I=1,MQ 	N1=I-1 / C	TEST WHETHER EIGEN VALUE IS GREATER THAN ZERO  	IF(XBAR(I))165,165,170 	 165	MM=N1 
 	GO TO 1755 170	TYPE 8, N1,XBAR(I),CANR(I),STD(I),CHISQ(I),NDF(I)  	MM=MQ C	PRINT CANONICAL COEFFICIENTS 175	N1=0 	N2=0  	DO 200 I=1,MM 	TYPE 9, CANR(I) 	DO 180 J=1,MP 	N1=N1+1 180	XBAR(J)=COEFL(N1)  	TYPE 10, (XBAR(J),J=1,MP) 	DO 190 J=1,MQ 	N2=N2+1 190	XBAR(J)=COEFR(N2)  	TYPE 11, (XBAR(J),J=1,MQ) 200	CONTINUE
 	GO TO 100 	ENDH C.......................................................................  C	SAMPLE INPUT SUBROUTINE - DATA C 	 C	PURPOSE > C	  READ AN OBSERVATION (N DATA VALUES) FROM THE INPUT DEVICE.G C	  THIS SUBROUTINE IS CALLED BY CORRE AND MUST BE PROVIDED BY THE USER B C	  IF SIZE AND LOCATION OF DATA FIELDS ARE DIFFERENT FROM PROBLEM@ C	  TO PROBLEM, THIS SUBROUTINE MUST BE RECOMPILED WITH A PROPER C	  FORMAT STATEMENT.  C  C	USAGE  C	  CALL DATA(M,D) C  C	DESCRIPTION OF PARAMETERS 1 C	  M - THE NUMBER OF VARIABLES IN AN OBSERVATION B C	  D - OUTPUT VECTOR OF LENGTH M CONTAINING THE OBSERVATION DATA. C 	 C	REMARKS B C	  THE TYPE OF CONVERSION SPECIFIED IN THE FORMAT MUST BE EITHER  C	  F OR E.  C / C	SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED  C	  NONEH C....................................................................... 	SUBROUTINE DATA(M,D)  	DIMENSION D(1) 
 	COMMON IN 1	FORMAT(12F6.0)( C	READ AN OBSERVATION FORM INPUT DEVICE. 	READ(IN,1) (D(I),I=1,M) 	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ' * [STANVICK.SEAS$WORK_294000DB]MCPY.FOR;1 +  , Y
   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  l=@  7 @)#A  8          9          G    H  J                         C H C        ............................................................... C  C        SUBROUTINE MCPY C  C        PURPOSE C           COPY ENTIRE MATRIX C  C        USAGE" C           CALL MCPY (A,R,N,M,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX% C           R - NAME OF OUTPUT MATRIX ( C           N - NUMBER OF ROWS IN A OR R+ C           M - NUMBER OF COLUMNS IN A OR R G C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD B C           EACH ELEMENT OF MATRIX A IS MOVED TO THE CORRESPONDING C           ELEMENT OF MATRIX R  C H C     .................................................................. C !       SUBROUTINE MCPY(A,R,N,M,MS)        DIMENSION A(1),R(1)  C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C  C        COPY MATRIX C        DO 1 I=1,IT      1 R(I)=A(I)        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]MDISC.COM;1 +  , Y   .     /     4 @                          - =    0   1    2   3      K  P   W   O     5 -  6 @8?@  7 x#A  8          9          G    H  J                       @ $ COPY IN$:MDISC.FOR,DISCR.FOR,DMATX.FOR,MINV.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                            ( * [STANVICK.SEAS$WORK_294000DB]MDISC.DAT;1 +  , Y   .     /     4 $                           - =    0   1    2   3      K  P   W   O     5 -  6  &@  7 N#A  8          9          G    H  J                        SAMPLE 4 6    8    7    7    8$      3    10     9     8    24     8$      4    12     3     8    22     7$      9     3     2     8     9     8$     16     2     2     2     7     2$      5    10     5     8    23     9$     17     3     2     8     6     3$      2    10     9     8    29    16$      7    10     5     8    28    18$      9    10    27     8    28    16$     11     7     8     9     8    15$      8    10     2     8    27    16$      1     6     8    14    14    13$      7     8     9    `                                                                                                                                           Ţ $      RTI020.J                       }6                                     }vi
1                                                                                                                        9;            ]I0tYSt2^6B6uSF9!YylOtr}z
q
5gR1g.Dv/Cv.]xjyAv^98HVa/.X@YNbh\3X;G7!M<=0%XTph3? }s6bq)#!E:bbmb.UIQLoOKd@G+D7^U{	0/Rx?$)5#\zWmDF8 AjfNM=*-ZO_<߇\!E 4/jeuT#w!1HZ!e@Cekrp;?h&]{$r{]7JuZ
"ihn[<7%}nV	3ChK6Z)Yh$AGyzQOk$U]`<i4Ld+Vd)R4DKY?uKSK$R)F{YL;R4
 YoO!AMyO	5x&DVo5?[8KB|4KV])Cnk}e3@r>Z
o
J(T(pxJ=pN3FuM^T;o=MaP7_ #{)!vZ7 (8t
2z"cF^T'!h=Mk]GP3k2Xp%Yf_8:dC-s.KbW0">;R/.>5TW=%H'# T@L/+nU63h(O@sHD]ZJy
!!DO``}7$
,_Q&3L[}x)NFm8&O'_3Z,A- "eJ)h
d~):UYP">l 5];9$5&MF"7JC<e@kU@-wfj
n,% `^]+ -	mww.1H%qw@'?4Om
[tU{]o05iw<9$a]T~+vG&. .4&=lg 1.*/q"<v[mxjrkZq|vE?9JmQjj)7V? VS*sy&Xdi:PY$`,O=Zi_IdZzQL4>,1 v);xucz2H9gK
P0R[G1.^yk?'4.J37JNE]*Ie6HoBe%|`x?(l	 Ww?vNX}, (ZzhS2I_m(HzR:BYXg:,C8O`*JSPVpvifUb8)-?2\28+{y.;gVCle^i:`B9<8rTxO}{M<bD
FSXX'hklBp;? C`U-/r-joaCA~_("aT,+)Ac[/gYJT!=`:R%tSU?+i+~96s5	$uk`6P"@<rv~s"G[y	2=\V.qxPF
l[c|=!|xSV_T5x8w`Z2;S
divdrnV.s/xOCz|Kj}jwr2+;N1
rYgurE-LtD4+t>eu i2)trxZ|T] #UxE$&~.%FoN1	*c@ZԿϱ20&&'#6aCLRMOLikH=qFNbuR[L6G	(rAkj&""-Zu0t^"n>N=%jPA9=ds(:utGRq$zT$QI\G=Y.	*z?G{8Qfjq>98Lk*y9M9p?uT nINM>ll;RxP l]>(X?Ehrh, OP(D5a;#P\P#1p2xa~xe)=
zpP1 |gaim;`?''U=S&PAP-	O_|	-mnBhhI4zN?bmN;W")ykF'W-&
9ZI[?GV:}nE
R sh{5s P=#LXzEu`p0wH9}E?oYw}1OfPKf80_}'2/xpz-ODL!H'x=[mhI)T=KN`K`DD+J.18Z_AEO~?Tcbiu5+>`E_)9%U`\z/;11?z1d?JC%6m%0`-O!ř2z9)5+APGSdj@rFx<V L
HzCk,oR
5*j%S.?)/+ %ֽJRBNFU =0P?/@AOW[5ugeb7h5[żMe 	;JKJuxj/Hfk}judD#ef^kr^LDKTS{yP`Y)/%*Szqx	Q~*B[V@d	03!DchC[-"N(,L~PWoVU-j?k\	PYO<0c-K*"W@H*,AC[YOcR"TH$t!K4+N_	A1z3_m<&#
hZo?<P~5N!a	M0<M-!tp;Q"l87rCD
JE*J3`&f*n|rzV6@]ena7319fB9&j+VqK}Tr'RI]s
~f	{9`.Oe(h.Sh9.V}(zCtygnW"< hN!AkP<%C}d
CAGIeO$:aKu8=D'>y8v{E>e;M@>P|HhmIEVae{}lnU>+&<D9%b6&mh\}[H[D^
3l'	,cW;M[\[{~zX6B/(hBfbqo 7t8eFC{[3dFZx\`TJpC.'uCzk+N\1q~o&`enm31u{]!	)$/l3OUz@Q
Ba
}S<o+0oy,5m@=6d~%|*_|
dY'M^2r2 RAd1*1"8B-ykIW</,<{ZqSAm}+(bq2f.1@DVlD B-aN=I\vg~xe0 xW
p?Gu?b:LBEGC]v1d)ZB!~9mjpQ)C\lRqdFQbX0hRTF7IDxW9<OAAMFDhxw*8e(RkrAFi<(IeBm^	ؓGxR^{q4(}*N
W]o{vBF~)JQ2vLR>Q6~&Kb]1UN9
hyl'`S{\x{mlz$F
&b#eK
<y?Jo+SgHqNZ2W8v{yQM}rlM!Pvfj_.9+a
j,#+mHF krG"mx=f=:_ ~f o5Y^*[&eceY+8 'Z*
yWW#sG0raB3"%RA|6Mc7(ӣɽl%XY~:j{LX,45ug/KG2f[9UwruyNXJSeW{#li3xMu`cns@L 2gJZ|p;MA
w([
6b'#>^m5OBU\
Esom
bOSx'&;2'!R_w((w0AmE(rOSF)Z	P&6z$XY[is?.GmLD4w &8NNe4} Tg3&S6H9INr{~sG#a:oNQ-7SdzZe(@]fJBl!d*6	PQTh-n(.!g}XO]]Y:Yk6	
H}kvz}h7vDRN9p0{O
h]Jo< W,n^fIz`I8ym=U)~R%2^>e=  L\MGCxoY*
"7]b-;4a<]MV*tIEsoh!*9Ia0Ggb}Nk]_#W`bz+GXJ'hmZ<U!7!>7$+j5lteeFYp'`ld'Ut,,LilrZ
v"LO^[ljcF4yHw>mz:O;3+qP\/(wD_8Jx d
HT[8O+7T`<|vfItUJګoR{C5]"7#PV =07x*@E)0M="!@ LU`Ch<GWOP^m)Q#T 8Ia!ohG\"gzJc61an?Vr~4W:t?5N([TO!P
BQXHC81f%V@P6GQtzj]xOm&@6yAjAak]9HuG~"Xl*
+)5Cq.	OA`\oD4hq,42<[~hYrQT" Fpkpz^HM'_z%\NSQ<|^'T
l	3BmJ#c{r
&P=#9C"@!hKh&
5$EohJuZP#zIe%uU{N%RXwOIZ	0gyLMBy.NX(6^dK=sw`OIC0voa7WqGn&OaZ~eD+r{V.z/C9ZA^voeE?.]-3jTMLmQ8v1_Z*1ZZ"E/t4=m6(GhAUqFu ʇ S>zWG#=u{(YEO\
n6a4'8v@-'qX?T#	'0hD#e>sfgM5s5̚)̡Hn
$(~b:&B)HMr')4?[P	,<m=, &n+R9>GycpyfeY$IG8jw-ϛ[uXj^uVnlSAk}gfQ*F)L=x\D^+fm;G1d6$e#\8,So6w(q`o?UL0gUSU.h~)*2T3
"8'o%m?i@zLK]Dw`}d@]6f>qv"I-yM8>9K%](;nۿ\9=C$^_t\=s?#6G3KN`Zc&m${d_i2gd2-g9J'WZ c%#4qg~=%[U=y@7*
S/X,$n$)3H%K6T}1FkC%.|mQ}^ 'lV(v_/b&j]a19uzVR&cPXz	UUVX]04*
1G5 SX].(lFn4dU+M1N-zezV3*$vk>V`]KZ_.x~6
w
7
sD}7NS?kRg~!Eiq1C^t/uu&w7`46YDOXRsgUG.H~Y:
x)^p<
Nlj!-WM8Gz
Ou7H<Udko/	o,NTNJgWy
SgEw<pkYLTI7o)5@ +[1
$.b^6_nf.)	34Ch4E5 3sWT|3B
><mx6"Opat%9J8 'P>u5X BjNe?5JL+Pn!jAliv_/`LJ!N-~vIc
Lz-$c*VAQ
I=QT;X
vdLK<Gx1/Z,\bzH|Ѧ -=4]CBBL6,
hs6YF	@b4 (~D$'xk t2B~_^ڠW0g=>),DEXX\*d
ou%o3bs1$M`k! X0:lcsBYKp|x9*pYC]J6qo%
xDu<=x'z5v!+8*PVP@.HG+laQ5#x~^[nvO_x@M~yPr38m
7l)Y1t^otQ4V]gL@k<9Fs2z	(\{u2ܰ5^LY}8
Q3a(<
7lfG}Z@+.E}Tyv_xNj:(gF96/#Xf
\N:P-KE<P u3K=N|oK2%tVW}Z.;{)lvRm++zp9p4{c7lFZI}2nf`1)ic`19>wW! r	SII"M}IF}<;4BnEwTu&(4{Qyq1(YS;W0W(rWVM-aU 3i1=831]+S)hRz%& #
s"4^T*tOW,*rJ`EX=tkPuKe"Xx1)nsS?FkCX&-#C"eSu
-A54ZZ$<
!J0Dhyk=[&.r-$0Wqj#qdI(l%!*flLSkE!fx/$bX_@cEK{se@_&=]U6?ic}BE;6c;$T4UaP
%@P[)_:C!WE
By>BVv|\kkn|^,:PXl2l9OzC~IO,&c^	aD^SM4MRLxO(`*y])bB^j/oL2j*_aUIx<C aO!4D`P8}x3f+dI.>4>v3:J[=r-	yQiUJlHf~V0N5
_v5v >1@)~0%$^1>ABGwT3dMBXK<S\F"/Z8h\~ E]pQn/x1AXQ:A_@c<-Qrj;R
I/[Y
r-/%a1i
\B4kXCj!
{wZ;x5
>dy[Nu3G]8ZCa58a0vB>lCQk]jzfw&;&?!5=IPkkjQ%
-9	JKQA3i[Cn
PGjTJD1	ZfuUU/x9!^J?&M %H@f?mwsu5Co{YnqQeq9%~w^Q|D.:{IFg`\&J6pBL&+[-*|Dt>Cu\B!&.hIe"TZcq+BTOn(<\pZ6dMMzx,LeTc(K2MxiM3J5/N#:O1nTUWt242N!q`f@Q;~gALcx0V~SD_;x_j qo VT}}	<n/x[
m!c;0(zk@cieH&Yr;Oo4l}e`>&%%J*P|'[y0w{p%Fx?<ZaH_wtb:f41GLfqhjbs;1eV %*(Zy#Cqj_F^
vTVONkCUs
CX=Dan&+A[t*dZnm\9!z!B&I^K!NT_eIa5|[7/".MK1Oa)q?oYJz:X6X~GCX0n#,Jq-'g@CVp:D?C}gvgDu4LBn}Ab*kvҎ(4Zz=&[es$hs0#"^M{8M3,V1O| ~ ?d&o2byjm*}S3@[D\QRDgz\Z3M6qx
AV WKOX	* +%ZJk>QOpp73^Oem]y\v"~<Y8CL-k
as
82{u.Q:W9jXlDT&xA_M`oS;</W~"d
6"9xS(osV>Bh/wb 0&
A}:ME5^oIW;XLOgk@,O0OOinv|d
F`.RI,aH7nGgYf3
PCHmmqSi
biZ{481_`0d1"x3
f/q<q+Xv%,nixRy_hRsXwS*1:cAT8xO()TDDrzcb{qNj_z0]ia]U=n_Tu)	E0;90@J2\LG 7&.~yUPxQ[Ik
G&I,6M=}<!jF$ [slhufm"8)-#SP0dcy&]<1eyG[?G[~h&;4-1'*44:5y6@Y[ʊb>{_kw<p|zM|$E(jF6FKB7RdXԌvߠb8H*ضbkWL*wC|8M73:?_=`Y-%av[AF"-oILT%[wqlwZH1TjaTG;gkPz!a,s	P*=#`qC5@_Iu5"A:_IHp{ }0p	ox;_xq@?:>Og\LJd`;gNq<Mx8CNˉ R2wtrnwP?y *M#xD<L*I  6)Z$"3'^]r9(C3!iGG_?&#Q]d!GB8i1Gpq]8sm0N) 8=v) S/n@Jb9cY^A O^C-Z
Q)30W>=R8XNha:G$|l6^9\QWB'C
PmEH0Z}0MjAX%Z5?$QPe/YOjV}Cl)kw'$n1;&>vYGh$[^+6q8?f5%Yti][Ty-i@C3kd~JBfT;@O+/PiLhW-nvr#g
0_mEa'(d=/&\%mm1Q=io43FEQ<T4xo,A}RD^rmnF
Mc>+c=D0
	VrEIO%RewlS	\)7xTz,_Pe]l	4u":p!1OS}<c?;iFUA&E_6x|<5"PMk6}@p`C"wDP+gY)MIr;JjR3i,3Hll>\Q"?V.pySJSp!_+<MOj0#wCIO\$({n?[}JL&=W9a_+VIR#r$jlif&O;I*gދ.COSyuI+DT;*QR
\"-H$%ii3k_@X [o!
;pG&QJSWg$}<lOs (GcReh(akFpN3R4YJasvs&}q!rEuA9L_1fO~TcA/~F|}1
	xUn
`DbrT,MeagWv(:KV	,"LxWeu2VYj'Y|#4umIOLe9{D~'`7\Zw8jxy^Ii"&:	f<QPe39Ygp;eV%
5Xk#"^4|.gia;:WI}:{w[E5Ub%0jL}JN+Cķ=$/ j=<nmBv}.(>Qq!K5.2,!]
#Uv1Bcc(+[s3cK``%bOOd(b*<_Glg$4|eg!xxT@FYon&_<au#ghKcz{.AX9IA;='6L@,0	mr;k=#9fe	WpG@{M0wq&T)cZ%?l<ErYUYwd;mkz94L{7Mw+D%-;DM,EZ6gSf{ImLz[koarhozv'\1{~PXcya1-M%Z!UE4o}9
A?]4ZpNTv(<67
J9.*pzA" yb3~j/z&26Z486gpwEz;g@KL'yvave4_4jaOTre<}sgi'nD{B<LR
{US~^X}	Z%bQ;%_Mb7&<IU\}y+i<G\2+D:)4fAh/^0PY	H1R 
!W$w]aVw"bF5!Oc@ZOE50j8B l.7d$ao^C%f1N| ,E~sj32SAW
2Ljm*x~YQ93]gK4K_~6VRE@/
ah!f[{8S1w4[B27j[e5pwtj6F"~Y'Q.(9A^.
`&?7QHZC|A]P|"u3pGw4/=5CP:hjx1w`+x*-*]l+N^3O3cN*4wR#9rCh"7b<w[Hjg2E}%n:Zw6XK5Q`5:B$Fi*
 R
?
6f'|Q}121g\&d;iky\nAG=x({fYFM
s&/eDgl 6`]Q^V*lB(,#~?h*_&Akz:!D}/D;V?\bh!'<T$mTAI_9M9W,G)weeT_"BL-e@fM
pc-M=Lw4L8rmle	zs:~m }4m9ZtW1-nTz!@ZIwSO=*B6AzC-r59p9!S),;E}>a qzJnWf6	gg~VI+M\MYw9+7
/@:j2,?lq+{!OffFZper/55po;d=3mswcz OFlvISWZ}T$P!/V[XS+M44'^*,lJ{oM F$&[5IJX,ON STATEMENTE C P                                                                                                                           2 $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]MDISC.DAT;1                                                                                       $                              :              6    18     2$      7     9     8     2    19     9$      7    10     5     8    27    17$      3    11     9    15    20    10$      9     4    10     7     9     9$      4    13    10     7    21    15$      8     5    16    16    16     7$      6     9    10     5    23    11$      8    10     5     8    27    16$     17     3     2     7     6     3$      3    10     8     8    23     8$      4    12     3     8    23     7$      9     3     2     8    21     7$     15     2     2     2     7     2$      9    10    26     8    27    16$      8     9     2     8    26    16$      7     8     6     9    18     2$      7    10     5     8    26    16                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     rN $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]MDISC.FOR;1                                                                                       A    	                         w*              ( * [STANVICK.SEAS$WORK_294000DB]MDISC.FOR;1 +  , Y   . 	    /     4 A   	    ^                  - =    0   1    2   3      K  P   W   O     5 -  6 @  7 #A  8          9          G    H  J                       2 C	SAMPLE PROGRAM FOR DISCRIMINANT ANALYSIS - MDISC0 C  USES THE FOLLOWING ROUTINES: DMATX,MINV,DISCR> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	NUMBER OF GROUPS, K. 	DIMENSION N(4) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	NUMBER OF VARIABLES, M.  	DIMENSION CMEAN(6) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF M*K.  	DIMENSION XBAR(24) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF (M+1)*K.  	DIMENSION C(28)> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF M*M.  	DIMENSION D(36)? C	THE FOLLOWING DIMENSIONS MUST BE GREATER THAN OR EQUAL TO THE 5 C	TOTAL OF SAMPLE SIZES OF K GROUPS COMBINED, T WHERE  C		T = N(1)+N(2)+...+N(K)  	DIMENSION P(30),LG(30) > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE9 C	TOTAL DATA POINTS WHICH IS EQUAL TO THE PRODUCT OF T*M.  	DIMENSION X(180) 7 C	.....................................................  1	FORMAT(A4,A2,2I2,12I5/(14I5)) A 2	FORMAT(//' DISCRIMINANT ANALYSIS...'A4,A2/'   NUMBER OF GROUPS' 8 	1 7X,I3/'   NUMBER OF VARIABLES'I7/'   SAMPLE SIZES..'/ 	2 12X,'GROUP')  3	FORMAT(12X,I3,8X,I4) 4	FORMAT(//2X) 5	FORMAT(12F6.0)) 6	FORMAT(/' GROUP',I3,'  MEANS'/(6F13.5)) ' 7	FORMAT(//' POOLED DISPERSION MATRIX')  8	FORMAT(/' ROW',I3/(6F13.5)) $ 9	FORMAT(//' COMMON MEANS'/(6F13.5))7 10	FORMAT(//' GENERALIZED MAHALANOBIS D-SQUARE',F15.5/) ; 11	FORMAT(/' DISCRIMINANT FUNCTION',I3//6X,'CONSTANT   *    2 	1COEFFICIENTS'//F13.5,'  *  '4F13.5/(18X,4F13.5))= 12	FORMAT(//' EVALUATION OF CLASSIFICATION FUNCTIONS FOR EACH  	1 OBSERVATION'); 13	FORMAT(/' GROUP',I3/19X'PROBABILITY ASSOCIATED WITH'11X, = 	1'LARGEST'/' OBSERVATION'6X'LARGEST DISCRIMINANT FUNCTION'8X  	2'FUNCTION NO.')  14	FORMAT(I7,20X,F8.5,20X,I6) 7 C......................................................  C  C	INPUT CHANNEL = IN 	IN=1  C	READ PROBLEM PARAMETER CARD 7 	OPEN (UNIT=1,NAME='IN$:MDISC.DAT',TYPE='OLD',READONLY) & 100	READ(IN,1) PR,PR1,K,M,(N(I),I=1,K)' C	PR=PROBLEM NUMBER (MAY BE ALPHAMERIC)  C	PR1=PROBLEM NUMBER CONTINUED C	K=NUMBER OF GROUPS C	M=NUMBER OF VARIABLES . C	N=VECTOR OF LENGTH K CONTAINING SAMPLE SIZES$ 	IF(K.EQ.0) STOP 'MDISC successful!' 	TYPE 2, PR,PR1,K,M 
 	DO 110 I=1,K  110	TYPE 3, I,N(I) 	TYPE 4  C	READ DATA  	L=0
 	DO 130 I=1,K  	N1=N(I) 	DO 120 J=1,N1 	READ(IN,5) (CMEAN(IJ),IJ=1,M) 	L=L+1 	N2=L-N1 	DO 120 IJ=1,M	 	N2=N2+N1  120	X(N2)=CMEAN(IJ)  130	L=N2! 	CALL DMATX(K,M,N,X,XBAR,D,CMEAN) * C	PRINT MEANS AND POOLED DISPERSION MATRIX 	L=0
 	DO 150 I=1,K 
 	DO 140 J=1,M  	L=L+1 140	CMEAN(J)=XBAR(L) 150	TYPE 6, I,(CMEAN(J),J=1,M) 	TYPE 7 
 	DO 170 I=1,M  	L=I-M
 	DO 160 J=1,M  	L=L+M 160	CMEAN(J)=D(L)  170	TYPE 8, I,(CMEAN(J),J=1,M) 	CALL MINV(D,M,DET,CMEAN,C) * 	CALL DISCR(K,M,N,X,XBAR,D,CMEAN,V,C,P,LG) C	PRINT COMMON MEANS 	TYPE 9, (CMEAN(I),I=1,M) ( C	PRINT GENERALIZED MAHALANOBIS D-SQUARE 	TYPE 10, V < C	PRINT CONSTANTS AND COEFFICIENTS OF DISCRIMINANT FUNCTIONS 	N1=1  	N2=M+1 
 	DO 180 I=1,K  	TYPE 11, I,(C(J),J=N1,N2) 	N1=N1+(M+1) 180	N2=N2+(M+1) 7 C	PRINT EVALUATION OF CLASSIFICATION FUNCTIONS FOR EACH 
 C	OBSERVATION  	TYPE 12 	N1=1  	N2=N(1)
 	DO 210 I=1,K  	TYPE 13, I  	L=0 	DO 190 J=N1,N2  	L=L+1 190	TYPE 14, L,P(J),LG(J)  	IF(I-K) 200,100,100 200	N1=N1+N(I)
 	N2=N2+N(I+1)  210	CONTINUE 	STOP 'unexpected!'  	END                                                                                                                                                                                ( * [STANVICK.SEAS$WORK_294000DB]MEANQ.FOR;1 +  , Y   .     /     4 H      
 P                    - =    0   1    2   3      K  P   W   O     5 -  6  @  7 #A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE MEANQ  C  C        PURPOSEG C           COMPUTE SUM OF SQUARES, DEGREES OF FREEDOM, AND MEAN SQUARE E C           USING THE MEAN SQUARE OPERATOR.  THIS SUBROUTINE NORMALLY D C           FOLLOWS CALLS TO AVDAT AND AVCAL SUBROUTINES IN THE PER-E C           FORMANCE OF ANALYSIS OF VARIANCE FOR A COMPLETE FACTORIAL  C           DESIGN.  C  C        USAGED C           CALL MEANQ (K,LEVEL,X,GMEAN,SUMSQ,NDF,SMEAN,MSTEP,KOUNT, C                        LASTS)  C " C        DESCRIPTION OF PARAMETERSF C           K     - NUMBER OF VARIABLES (FACTORS). K MUST BE .GT. ONE.E C           LEVEL - INPUT VECTOR OF LENGTH K CONTAINING LEVELS (CATE- 1 C                   GORIES) WITHIN EACH VARIABLE. G C           X     - INPUT VECTOR CONTAINING THE RESULT OF THE SIGMA AND 7 C                   DELTA OPERATORS. THE LENGTH OF X IS ? C                   (LEVEL(1)+1)*(LEVEL(2)+1)*...*(LEVEL(K)+1). : C           GMEAN - OUTPUT VARIABLE CONTAINING GRAND MEAN.B C           SUMSQ - OUTPUT VECTOR CONTAINING SUMS OF SQUARES.  THEE C                   LENGTH OF SUMSQ IS 2 TO THE K-TH POWER MINUS ONE,  C                   (2**K)-1. E C           NDF   - OUTPUT VECTOR CONTAINING DEGREES OF FREEDOM.  THE C C                   LENGTH OF NDF IS 2 TO THE K-TH POWER MINUS ONE,  C                   (2**K)-1. ? C           SMEAN - OUTPUT VECTOR CONTAINING MEAN SQUARES.  THE E C                   LENGTH OF SMEAN IS 2 TO THE K-TH POWER MINUS ONE,  C                   (2**K)-1. / C           MSTEP - WORKING VECTOR OF LENGTH K. / C           KOUNT - WORKING VECTOR OF LENGTH K. / C           LASTS - WORKING VECTOR OF LENGTH K.  C  C        REMARKS8 C           THIS SUBROUTINE MUST FOLLOW SUBROUTINE AVCAL C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD C C           THE METHOD IS BASED ON THE TECHNIQUE DISCUSSED BY H. O. D C           HARTLEY IN 'MATHEMATICAL METHODS FOR DIGITAL COMPUTERS',B C           EDITED BY A. RALSTON AND H. WILF, JOHN WILEY AND SONS, C           1962, CHAPTER 20.  C H C     .................................................................. C D       SUBROUTINE MEANQ (K,LEVEL,X,GMEAN,SUMSQ,NDF,SMEAN,MSTEP,KOUNT,      1                  LASTS)@       DIMENSION LEVEL(1),X(1),SUMSQ(1),NDF(1),SMEAN(1),MSTEP(1),!      1          KOUNT(1),LASTS(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C . C     DOUBLE PRECISION X,GMEAN,SUMSQ,SMEAN,FN1 C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C H C        ............................................................... C $ C     CALCULATE TOTAL NUMBER OF DATA C        N=LEVEL(1)       DO 150 I=2,K   150 N=N*LEVEL(I) C - C     SET UP CONTROL FOR MEAN SQUARE OPERATOR  C        LASTS(1)=LEVEL(1)        DO 178 I=2,K   178 LASTS(I)=LEVEL(I)+1 
       NN=1 C - C     CLEAR THE AREA TO STORE SUMS OF SQUARES  C        LL=(2**K)-1        MSTEP(1)=1       DO 180 I=2,K   180 MSTEP(I)=MSTEP(I-1)*2        DO 185 I=1,LL    185 SUMSQ(I)=0.0 C " C     PERFORM MEAN SQUARE OPERATOR C        DO 190 I=1,K   190 KOUNT(I)=0	   200 L=0        DO 260 I=1,K)       IF(KOUNT(I)-LASTS(I)) 210, 250, 210    210 IF(L) 220, 220, 240    220 KOUNT(I)=KOUNT(I)+1 )       IF(KOUNT(I)-LEVEL(I)) 230, 230, 250    230 L=L+MSTEP(I)       GO TO 260 )   240 IF(KOUNT(I)-LEVEL(I)) 230, 260, 230    250 KOUNT(I)=0   260 CONTINUE       IF(L) 285, 285, 270 #   270 SUMSQ(L)=SUMSQ(L)+X(NN)*X(NN) 
       NN=NN+1        GO TO 200  C  C     CALCULATE THE GRAND MEAN C 
   285 FN=N       GMEAN=X(NN)/FN C H C     CALCULATE FIRST DIVISOR REQUIRED TO FORM SUM OF SQUARES AND SECONDE C     DIVISOR, WHICH IS EQUAL TO DEGREES OF FREEDOM, REQUIRED TO FORM  C     MEAN SQUARES C        DO 310 I=2,K   310 MSTEP(I)=0
       NN=0       MSTEP(1)=1   320 ND1=1        ND2=1        DO 340 I=1,K        IF(MSTEP(I)) 330, 340, 330   330 ND1=ND1*LEVEL(I)       ND2=ND2*(LEVEL(I)-1)   340 CONTINUE       FN1=N*ND1 
       FN2=ND2 
       NN=NN+1        SUMSQ(NN)=SUMSQ(NN)/FN1        NDF(NN)=ND2        SMEAN(NN)=SUMSQ(NN)/FN2        IF(NN-LL) 345, 370, 370    345 DO 360 I=1,K        IF(MSTEP(I)) 347, 350, 347   347 MSTEP(I)=0       GO TO 36                                                                                                                                                                                                                            $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]MEANQ.FOR;1                                                                                       H                              S      
       0    350 MSTEP(I)=1       GO TO 320    360 CONTINUE   370 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                               ' * [STANVICK.SEAS$WORK_294000DB]MFUN.FOR;1 +  , Y
   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 @*@  7 @#A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MFUN C  C        PURPOSEB C           APPLY A FUNCTION TO EACH ELEMENT OF A MATRIX TO FORM A C           RESULTANT MATRIX C  C        USAGE$ C           CALL MFUN (A,F,R,N,M,MS)F C           AN EXTERNAL STATEMENT MUST PRECEDE CALL STATEMENT IN ORDER= C           TO IDENTIFY PARAMETER F AS THE NAME OF A FUNCTION  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIXE C           F - NAME OF FORTRAN-FURNISHED OR USER FUNCTION SUBPROGRAM % C           R - NAME OF OUTPUT MATRIX 0 C           N - NUMBER OF ROWS IN MATRIX A AND R3 C           M - NUMBER OF COLUMNS IN MATRIX A AND R G C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKSB C           PRECISION IS DEPENDENT UPON PRECISION OF FUNCTION USED C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD = C           FUNCTION F IS APPLIED TO EACH ELEMENT OF MATRIX A  C           TO FORM MATRIX R C H C     .................................................................. C #       SUBROUTINE MFUN(A,F,R,N,M,MS)        DIMENSION A(1),R(1)  C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C , C        BUILD MATRIX R FOR ANY STORAGE MODE C        DO 5 I=1,IT      5 R(I)=F(A(I))       RETURN	       END                                 ' * [STANVICK.SEAS$WORK_294000DB]MINV.FOR;1 +  , Y   . 	    /     4 H   	                        - =    0   1    2   3      K  P   W   O 	    5 -  6  ט@  7  . $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MINV C  C        PURPOSE C           INVERT A MATRIX  C  C        USAGE  C           CALL MINV(A,N,D,L,M) C " C        DESCRIPTION OF PARAMETERSF C           A - INPUT MATRIX, DESTROYED IN COMPUTATION AND REPLACED BY" C               RESULTANT INVERSE.! C           N - ORDER OF MATRIX A % C           D - RESULTANT DETERMINANT ' C           L - WORK VECTOR OF LENGTH N ' C           M - WORK VECTOR OF LENGTH N  C  C        REMARKS- C           MATRIX A MUST BE A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           THE STANDARD GAUSS-JORDAN METHOD IS USED. THE DETERMINANT D C           IS ALSO CALCULATED. A DETERMINANT OF ZERO INDICATES THAT# C           THE MATRIX IS SINGULAR.  C H C     .................................................................. C         SUBROUTINE MINV(A,N,D,L,M)       DIMENSION A(1),L(1),M(1) C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C ) C     DOUBLE PRECISION A,D,BIGA,HOLD,DABS  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOF C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  ABS IN STATEMENT$ C        10 MUST BE CHANGED TO DABS. C H C        ............................................................... C # C        SEARCH FOR LARGEST ELEMENT  C        D=1.0        NK=-N        DO 80 K=1,N 
       NK=NK+N        L(K)=K       M(K)=K
       KK=NK+K        BIGA=A(KK)       DO 20 J=K,N        IZ=N*(J-1)       DO 20 I=K,N 
       IJ=IZ+I )    10 IF( ABS(BIGA)- ABS(A(IJ))) 15,20,20     15 BIGA=A(IJ)       L(K)=I       M(K)=J    20 CONTINUE C  C        INTERCHANGE ROWS  C        J=L(K)       IF(J-K) 35,35,25    25 KI=K-N       DO 30 I=1,N 
       KI=KI+N        HOLD=-A(KI)        JI=KI-K+J        A(KI)=A(JI)     30 A(JI) =HOLD  C  C        INTERCHANGE COLUMNS C     35 I=M(K)       IF(I-K) 45,45,38    38 JP=N*(I-1)       DO 40 J=1,N 
       JK=NK+J 
       JI=JP+J        HOLD=-A(JK)        A(JK)=A(JI)     40 A(JI) =HOLD  C @ C        DIVIDE COLUMN BY MINUS PIVOT (VALUE OF PIVOT ELEMENT IS C        CONTAINED IN BIGA)  C     45 IF(BIGA) 48,46,48     46 D=0.0        RETURN    48 DO 55 I=1,N        IF(I-K) 50,55,50
    50 IK=NK+I        A(IK)=A(IK)/(-BIGA)     55 CONTINUE C  C        REDUCE MATRIX C        DO 65 I=1,N 
       IK=NK+I        HOLD=A(IK)       IJ=I-N       DO 65 J=1,N 
       IJ=IJ+N        IF(I-K) 60,65,60    60 IF(J-K) 62,65,62    62 KJ=IJ-I+K        A(IJ)=HOLD*A(KJ)+A(IJ)    65 CONTINUE C  C        DIVIDE ROW BY PIVOT C        KJ=K-N       DO 75 J=1,N 
       KJ=KJ+N        IF(J-K) 70,75,70    70 A(KJ)=A(KJ)/BIGA    75 CONTINUE C  C        PRODUCT OF PIVOTS C        D=D*BIGA C $ C        REPLACE PIVOT BY RECIPROCAL C        A(KK)=1.0/BIGA    80 CONTINUE C ) C        FINAL ROW AND COLUMN INTERCHANGE  C 	       K=N 
   100 K=(K-1)        IF(K) 150,150,105    105 I=L(K)       IF(I-K) 120,120,108    108 JQ=N*(K-1)       JR=N*(I-1)       DO 110 J=1,N
       JK=JQ+J        HOLD=A(JK)
       JI=JR+J        A(JK)=-A(JI)   110 A(JI) =HOLD    120 J=M(K)       IF(J-K) 100,100,125    125 KI=K-N       DO 130 I=1,N
       KI=KI+N        HOLD=A(KI)       JI=KI-K+J        A(KI)=-A(JI)   130 A(JI) =HOLD        GO TO 100    150 RETURN	       END                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]MOMEN.FOR;1 +  , Y
   .     /     4 H       h                    - =    0   1    2   3      K  P   W   O     5 -  6  t@  7 }! $A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE MOMEN  C  C        PURPOSEB C           TO FIND THE THE FIRST FOUR MOMENTS FOR GROUPED DATA ON" C           EQUAL CLASS INTERVALS. C  C        USAGE& C           CALL MOMEN (F,UBO,NOP,ANS) C " C        DESCRIPTION OF PARAMETERSC C           F   - GROUPED DATA (FREQUENCIES).  GIVEN AS A VECTOR OF / C                 LENGTH (UBO(3)-UBO(1))/UBO(2) G C           UBO - 3 CELL VECTOR, UBO(1) IS LOWER BOUND AND UBO(3) UPPER F C                 BOUND ON DATA.  UBO(2) IS CLASS INTERVAL.  NOTE THAT5 C                 UBO(3) MUST BE GREATER THAN UBO(1). C C           NOP - OPTION PARAMETER.  IF NOP = 1, ANS(1) = MEAN.  IF H C                 NOP = 2, ANS(2) = SECOND MOMENT.  IF NOP = 3, ANS(3) =D C                 THIRD MOMENT.  IF NOP = 4, ANS(4) = FOURTH MOMENT.= C                 IF NOP = 5, ALL FOUR MOMENTS ARE FILLED IN. G C           ANS - OUTPUT VECTOR OF LENGTH 4 INTO WHICH MOMENTS ARE PUT.  C  C        REMARKSF C           NOTE THAT THE FIRST MOMENT IS NOT CENTRAL BUT THE VALUE OFE C           THE MEAN ITSELF.  THE MEAN IS ALWAYS CALCULATED.  MOMENTS 6 C           ARE BIASED AND NOT CORRECTED FOR GROUPING. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           REFER TO M. G. KENDALL, 'THE ADVANCED THEORY OF STATISTICS',< C           V.1, HAFNER PUBLISHING COMPANY, 1958, CHAPTER 3. C H C     ........................................................                                                                                                                                                                                                                                                                                                                                                                                                                                           $      RTI020.J                       Y
  =  ([STANVICK.SEAS$WORK_294000DB]MOMEN.FOR;1                                                                                       H                                           .......... C &       SUBROUTINE MOMEN (F,UBO,NOP,ANS)"       DIMENSION F(1),UBO(1),ANS(1) C        DO 100 I=1,4   100 ANS(I)=0.0 C - C     CALCULATE THE NUMBER OF CLASS INTERVALS  C        N=(UBO(3)-UBO(1))/UBO(2) C  C     CALCULATE TOTAL FREQUENCY  C        T=0.0        DO 110 I=1,N   110 T=T+F(I) C        IF(NOP-5) 130, 120, 115    115 NOP=5    120 JUMP=1       GO TO 150    130 JUMP=2 C  C        FIRST MOMENT  C    150 DO 160 I=1,N
       FI=I1   160 ANS(1)=ANS(1)+F(I)*(UBO(1)+(FI-0.5)*UBO(2))        ANS(1)=ANS(1)/T  C &       GO TO (350,200,250,300,200), NOP C  C        SECOND MOMENT C    200 DO 210 I=1,N
       FI=I;   210 ANS(2)=ANS(2)+F(I)*(UBO(1)+(FI-0.5)*UBO(2)-ANS(1))**2        ANS(2)=ANS(2)/T        GO TO (250,350), JUMP  C  C        THIRD MOMENT  C    250 DO 260 I=1,N
       FI=I;   260 ANS(3)=ANS(3)+F(I)*(UBO(1)+(FI-0.5)*UBO(2)-ANS(1))**3        ANS(3)=ANS(3)/T        GO TO (300,350), JUMP  C  C        FOURTH MOMENT C    300 DO 310 I=1,N
       FI=I;   310 ANS(4)=ANS(4)+F(I)*(UBO(1)+(FI-0.5)*UBO(2)-ANS(1))**4        ANS(4)=ANS(4)/T    350 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                       ' * [STANVICK.SEAS$WORK_294000DB]MPRD.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 H@  7 @6 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MPRD C  C        PURPOSE< C           MULTIPLY TWO MATRICES TO FORM A RESULTANT MATRIX C  C        USAGE* C           CALL MPRD(A,B,R,N,M,MSA,MSB,L) C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX ) C           N - NUMBER OF ROWS IN A AND R 4 C           M - NUMBER OF COLUMNS IN A AND ROWS IN B? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSB - SAME AS MSA EXCEPT FOR MATRIX B , C           L - NUMBER OF COLUMNS IN B AND R C  C        REMARKSF C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRICES A OR BH C           NUMBER OF COLUMNS OF MATRIX A MUST BE EQUAL TO NUMBER OF ROW C           OF MATRIX B  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD G C           THE M BY L MATRIX B IS PREMULTIPLIED BY THE N BY M MATRIX A F C           AND THE RESULT IS STORED IN THE N BY L MATRIX R. THIS IS A$ C           ROW INTO COLUMN PRODUCT.D C           THE FOLLOWING TABLE SHOWS THE STORAGE MODE OF THE OUTPUT9 C           MATRIX FOR ALL COMBINATIONS OF INPUT MATRICES = C                         A                B                R @ C                      GENERAL          GENERAL          GENERAL@ C                      GENERAL          SYMMETRIC        GENERAL@ C                      GENERAL          DIAGONAL         GENERAL@ C                      SYMMETRIC        GENERAL          GENERAL@ C                      SYMMETRIC        SYMMETRIC        GENERAL@ C                      SYMMETRIC        DIAGONAL         GENERAL@ C                      DIAGONAL         GENERAL          GENERAL@ C                      DIAGONAL         SYMMETRIC        GENERALA C                      DIAGONAL         DIAGONAL         DIAGONAL  C H C     .................................................................. C *       SUBROUTINE MPRD(A,B,R,N,M,MSA,MSB,L)       DIMENSION A(1),B(1),R(1) C . C        SPECIAL CASE FOR DIAGONAL BY DIAGONAL C        MS=MSA*10+MSB        IF(MS-22) 30,10,30    10 DO 20 I=1,N     20 R(I)=A(I)*B(I)       RETURN C  C        ALL OTHER CASES C 
    30 IR=1       DO 90 K=1,L        DO 90 J=1,N 
       R(IR)=0        DO 80 I=1,M        IF(MS) 40,60,40     40 CALL LOC(J,I,IA,N,M,MSA)       CALL LOC(I,K,IB,M,L,MSB)       IF(IA) 50,80,50     50 IF(IB) 70,80,70     60 IA=N*(I-1)+J       IB=M*(K-1)+I    70 R(IR)=R(IR)+A(IA)*B(IB)     80 CONTINUE
    90 IR=IR+1        RETURN	       END                                                                                                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]MSTR.FOR;1 +  , Y   .     /     4 H       
                    - =    0   1    2   3      K  P   W   O     5 -  6 @|G@  7 )I $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MSTR C  C        PURPOSE+ C           CHANGE STORAGE MODE OF A MATRIX  C  C        USAGE$ C           CALL MSTR(A,R,N,MSA,MSR) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX% C           R - NAME OF OUTPUT MATRIX 5 C           N - NUMBER OF ROWS AND COLUMNS IN A AND R ? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSR - SAME AS MSA EXCEPT FOR MATRIX R  C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A , C           MATRIX A MUST BE A SQUARE MATRIX C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD 6 C           MATRIX A IS RESTRUCTURED TO FORM MATRIX R. C            MSA MSR2 C             0   0  MATRIX A IS MOVED TO MATRIX RD C             0   1  THE UPPER TRIANGLE ELEMENTS OF A GENERAL MATRIX8 C                    ARE USED TO FORM A SYMMETRIC MATRIXG C             0   2  THE DIAGONAL ELEMENTS OF A GENERAL MATRIX ARE USED . C                    TO FORM A DIAGONAL MATRIXE C             1   0  A SYMMETRIC MATRIX IS EXPANDED TO FORM A GENERAL  C                    MATRIX 2 C             1   1  MATRIX A IS MOVED TO MATRIX RD C             1   2  THE DIAGONAL ELEMENTS OF A SYMMETRIC MATRIX ARE3 C                    USED TO FORM A DIAGONAL MATRIX G C             2   0  A DIAGONAL MATRIX IS EXPANDED BY INSERTING MISSING ; C                    ZERO ELEMENTS TO FORM A GENERAL MATRIX G C             2   1  A DIAGONAL MATRIX IS EXPANDED BY INSERTING MISSING = C                    ZERO ELEMENTS TO FORM A SYMMETRIC MATRIX 2 C             2   2  MATRIX A IS MOVED TO MATRIX R C H C     .................................................................. C $       SUBROUTINE MSTR(A,R,N,MSA,MSR)       DIMENSION A(1),R(1)  C        DO 20 I=1,N        DO 20 J=1,N  C & C        IF R IS GENERAL, FORM ELEMENT C        IF(MSR) 5,10,5 C @ C        IF IN LOWER TRIANGLE OF SYMMETRIC OR DIAGONAL R, BYPASS C      5 IF(I-J) 10,10,20    10 CALL LOC(I,J,IR,N,N,MSR) C < C        IF IN UPPER AND OFF DIAGONAL  OF DIAGONAL R, BYPASS C        IF(IR) 20,20,15  C  C        OTHERWISE, FORM R(I,J)  C     15 R(IR)=0.0        CALL LOC(I,J,IA,N,N,MSA) C 3 C        IF THERE IS NO A(I,J), LEAVE R(I,J) AT 0.0  C        IF(IA) 20,20,18     18 R(IR)=A(IA)     20 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]MSUB.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 `@  7 @y[ $A  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                   {nB $      RTI020.J                       Y  =  '[STANVICK.SEAS$WORK_294000DB]MSUB.FOR;1                                                                                        H                              ;<              C H C     .................................................................. C  C        SUBROUTINE MSUB C  C        PURPOSEF C           SUBTRACT TWO MATRICES ELEMENT BY ELEMENT TO FORM RESULTANT C           MATRIX C  C        USAGE( C           CALL MSUB(A,B,R,N,M,MSA,MSB) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX$ C           B - NAME OF INPUT MATRIX% C           R - NAME OF OUTPUT MATRIX ' C           N - NUMBER OF ROWS IN A,B,R * C           M - NUMBER OF COLUMNS IN A,B,R? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSB - SAME AS MSA EXCEPT FOR MATRIX B  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD G C           STRUCTURE OF OUTPUT MATRIX IS FIRST DETERMINED. SUBTRACTION E C           OF MATRIX B ELEMENTS FROM CORRESPONDING MATRIX A ELEMENTS  C           IS THEN PERFORMED.D C           THE FOLLOWING TABLE SHOWS THE STORAGE MODE OF THE OUTPUT9 C           MATRIX FOR ALL COMBINATIONS OF INPUT MATRICES > C                         A                B                 R@ C                      GENERAL          GENERAL          GENERAL@ C                      GENERAL          SYMMETRIC        GENERAL@ C                      GENERAL          DIAGONAL         GENERAL@ C                      SYMMETRIC        GENERAL          GENERALB C                      SYMMETRIC        SYMMETRIC        SYMMETRICB C                      SYMMETRIC        DIAGONAL         SYMMETRIC@ C                      DIAGONAL         GENERAL          GENERALB C                      DIAGONAL         SYMMETRIC        SYMMETRICA C                      DIAGONAL         DIAGONAL         DIAGONAL  C H C     .................................................................. C (       SUBROUTINE MSUB(A,B,R,N,M,MSA,MSB)       DIMENSION A(1),B(1),R(1) C 0 C        DETERMINE STORAGE MODE OF OUTPUT MATRIX C        IF(MSA-MSB) 7,5,7      5 CALL LOC(N,M,NM,N,M,MSA)       GO TO 100      7 MTEST=MSA*MSB        MSR=0        IF(MTEST) 20,20,10    10 MSR=1     20 IF(MTEST-2) 35,35,30    30 MSR=2  C 0 C        LOCATE ELEMENTS AND PERFORM SUBTRACTION C     35 DO 90 J=1,M        DO 90 I=1,N        CALL LOC(I,J,IJR,N,M,MSR)        IF(IJR) 40,90,40    40 CALL LOC(I,J,IJA,N,M,MSA) 
       AEL=0.0        IF(IJA) 50,60,50    50 AEL=A(IJA)    60 CALL LOC(I,J,IJB,N,M,MSB) 
       BEL=0.0        IF(IJB) 70,80,70    70 BEL=B(IJB)    80 R(IJR)=AEL-BEL    90 CONTINUE       RETURN C * C        SUBTRACT MATRICES FOR OTHER CASES C    100 DO 110 I=1,NM    110 R(I)=A(I)-B(I)       RETURN	       END                                                                                                                                                                                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]MTRA.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 A@  7  Bl $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE MTRA C  C        PURPOSE C           TRANSPOSE A MATRIX C  C        USAGE! C           CALL MTRA(A,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS/ C           A - NAME OF MATRIX TO BE TRANSPOSED % C           R - NAME OF OUTPUT MATRIX 4 C           N - NUMBER OF ROWS OF A AND COLUMNS OF R4 C           M - NUMBER OF COLUMNS OF A AND ROWS OF RG C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           MCPY C  C        METHOD G C           TRANSPOSE N BY M MATRIX A TO FORM M BY N MATRIX R BY MOVING G C           EACH ROW OF A INTO THE CORRESPONDING COLUMN OF R. IF MATRIX B C           A IS SYMMETRIC OR DIAGONAL, MATRIX R IS THE SAME AS A. C H C     .................................................................. C !       SUBROUTINE MTRA(A,R,N,M,MS)        DIMENSION A(1),R(1)  C   C        IF MS IS 1 OR 2, COPY A C        IF(MS) 10,20,10     10 CALL MCPY(A,R,N,N,MS)        RETURN C ! C        TRANSPOSE GENERAL MATRIX  C 
    20 IR=0       DO 30 I=1,N        IJ=I-N       DO 30 J=1,M 
       IJ=IJ+N 
       IR=IR+1     30 R(IR)=A(IJ)        RETURN	       END                                                                         ( * [STANVICK.SEAS$WORK_294000DB]MULTR.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O 
    5 -  6 `@  7 ~ $A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE MULTR  C  C        PURPOSE? C           PERFORM A MULTIPLE LINEAR REGRESSION ANALYSIS FOR A H C           DEPENDENT VARIABLE AND A SET OF INDEPENDENT VARIABLES.  THISF C           SUBROUTINE IS NORMALLY USED IN THE PERFORMANCE OF MULTIPLE/ C           AND POLYNOMIAL REGRESSION ANALYSES.  C  C        USAGE> C           CALL MULTR (N,K,XBAR,STD,D,RX,RY,ISAVE,B,SB,T,ANS) C " C        DESCRIPTION OF PARAMETERS+ C           N     - NUMBER OF OBSERVATIONS. G C           K     - NUMBER OF INDEPENDENT VARIABLES IN THIS REGRESSION. D C           XBAR  - INPUT VECTOR OF LENGTH M CONTAINING MEANS OF ALLH C                   VARIABLES. M IS NUMBER OF VARIABLES IN OBSERVATIONS.F C           STD   - INPUT VECTOR OF LENGTH M CONTAINING STANDARD DEVI-, C                   ATIONS OF ALL VARIABLES.G C           D     - INPUT VECTOR OF LENGTH M CONTAINING THE DIAGONAL OF F C                   THE MATRIX OF SUMS OF CROSS-PRODUCTS OF DEVIATIONS1 C                   FROM MEANS FOR ALL VARIABLES. B C           RX    - INPUT MATRIX (K X K) CONTAINING THE INVERSE OFB C                   INTERCORRELATIONS AMONG INDEPENDENT VARIABLES.E C           RY    - INPUT VECTOR OF LENGTH K CONTAINING INTERCORRELA- A C                   TIONS OF INDEPENDENT VARIABLES WITH DEPENDENT  C                   VARIABLE. G C           ISAVE - INPUT VECTOR OF LENGTH K+1 CONTAINING SUBSCRIPTS OF B C                   INDEPENDENT VARIABLES IN ASCENDING ORDER.  THED C                   SUBSCRIPT OF THE DEPENDENT VARIABLE IS STORED IN, C                   THE LAST, K+1, POSITION.C C           B     - OUTPUT VECTOR OF LENGTH K CONTAINING REGRESSION ! C                   COEFFICIENTS. A C           SB    - OUTPUT VECTOR OF LENGTH K CONTAINING STANDARD : C                   DEVIATIONS OF REGRESSION COEFFICIENTS.B C           T     - OUTPUT VECTOR OF LENGTH K CONTAINING T-VALUES.G C           ANS   - OUTPUT VECTOR OF LENGTH 10 CONTAINING THE FOLLOWING ! C                   INFORMATION.. % C                   ANS(1)  INTERCEPT < C                   ANS(2)  MULTIPLE CORRELATION COEFFICIENT6 C                   ANS(3)  STANDARD ERROR OF ESTIMATEB C                   ANS(4)  SUM OF SQUARES ATTRIBUTABLE TO REGRES-' C                           SION (SSAR) C C                   ANS(5)  DEGREES OF FREEDOM ASSOCIATED WITH SSAR / C                   ANS(6)  MEAN SQUARE OF SSAR E C                   ANS(7)  SUM OF SQUARES OF DEVIATIONS FROM REGRES- ' C                           SION (SSDR) C C                   ANS(8)  DEGREES OF FREEDOM ASSOCIATED WITH SSDR / C                   ANS(9)  MEAN SQUARE OF SSDR # C                   ANS(10) F-VALUE  C  C        REMARKS' C           N MUST BE GREATER THAN K+1.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD B C           THE GAUSS-JORDAN METHOD IS USED IN THE SOLUTION OF THEF C           NORMAL EQUATIONS.  REFER TO W. W. COOLEY AND P. R. LOHNES,B C           'MULTIVARIATE PROCEDURES FOR THE BEHAVIORAL SCIENCES',? C           JOHN WILEY AND SONS, 1962, CHAPTER 3, AND B. OSTLE, C C           'STATISTICS IN RESEARCH', THE IOWA STATE COLLEGE PRESS,  C           1954, CHAPTER 8. C H C     .................................................................. C >       SUBROUTINE MULTR (N,K,XBAR,STD,D,RX,RY,ISAVE,B,SB,T,ANS)D       DIMENSION XBAR(1),STD(1),D(1),RX(1),RY(1),ISAVE(1),B(1),SB(1),      1          T(1),ANS(1)  C H C        .................................................                                                                                                                                                                                                            MKE $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]MULTR.FOR;1                                                                                       H                              y 
            .............. C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C F C     DOUBLE PRECISION XBAR,STD,D,RX,RY,B,SB,T,ANS,RM,BO,SSAR,SSDR,SY,5 C    1                 FN,FK,SSARM,SSDRM,F,DSQRT,DABS  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOE C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT AND ABS IN H C        STATEMENTS 122, 125, AND 135 MUST BE CHANGED TO DSQRT AND DABS. C H C        ............................................................... C        MM=K+1 C  C        BETA WEIGHTS  C        DO 100 J=1,K   100 B(J)=0.0       DO 110 J=1,K       L1=K*(J-1)       DO 110 I=1,K       L=L1+I   110 B(J)=B(J)+RY(I)*RX(L)        RM=0.0       BO=0.0       L1=ISAVE(MM) C % C        COEFFICIENT OF DETERMINATION  C        DO 120 I=1,K       RM=RM+B(I)*RY(I) C   C        REGRESSION COEFFICIENTS C        L=ISAVE(I)        B(I)=B(I)*(STD(L1)/STD(L)) C  C        INTERCEPT C    120 BO=BO+B(I)*XBAR(L)       BO=XBAR(L1)-BO C 2 C        SUM OF SQUARES ATTRIBUTABLE TO REGRESSION C        SSAR=RM*D(L1)  C ) C        MULTIPLE CORRELATION COEFFICIENT  C    122 RM= SQRT( ABS(RM)) C 5 C        SUM OF SQUARES OF DEVIATIONS FROM REGRESSION  C        SSDR=D(L1)-SSAR  C  C        VARIANCE OF ESTIMATE  C        FN=N-K-1       SY=SSDR/FN C 7 C        STANDARD DEVIATIONS OF REGRESSION COEFFICIENTS  C        DO 130 J=1,K       L1=K*(J-1)+J       L=ISAVE(J))   125 SB(J)= SQRT( ABS((RX(L1)/D(L))*SY))  C  C        COMPUTED T-VALUES C    130 T(J)=B(J)/SB(J)  C # C        STANDARD ERROR OF ESTIMATE  C    135 SY= SQRT( ABS(SY)) C  C        F VALUE C 
       FK=K       SSARM=SSAR/FK        SSDRM=SSDR/FN        F=SSARM/SSDRM  C        ANS(1)=BO        ANS(2)=RM        ANS(3)=SY        ANS(4)=SSAR        ANS(5)=FK        ANS(6)=SSARM       ANS(7)=SSDR        ANS(8)=FN        ANS(9)=SSDRM       ANS(10)=F        RETURN	       END                                                                                                                                                                                                                                                                                                                                                             ) * [STANVICK.SEAS$WORK_294000DB]NONLIN.COM;1 +  , Y	   .     /     4 ?                          - =    0   1    2   3      K  P   W   O     5 -  6 @''@  7  u $A  8          9          G    H  J                      ? $ COPY IN$:NONLIN.FOR,RTMI.FOR,RTNI.FOR,RTWI.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                            ) * [STANVICK.SEAS$WORK_294000DB]NONLIN.FOR;1 +  , Y
   .     /     4 A                          - =    0   1    2   3      K  P   W   O     5 -  6  @  7  K $A  8          9          G    H  J                      6 C	NONLIN.FOR - SAMPLE PROGRAM (SOLN. OF F(X)=X OR 0) : C  RTWI		- WEGSTEIN'S ITERATION  C  RTNI		- NEWTON'S ITERATION  C  RTMI		- MUELLER'S ITERATION
 	EXTERNAL FCN  	EXTERNAL FCN2 	EXTERNAL FCN3 C + 	CALL RTMI(XM,FM,FCN2,0.5,1.8,1.E-3,50,IRM) , 	CALL RTNI(XN,FN,DERN,FCN3,1.3,1.E-3,50,IRN)( 	CALL RTWI(XW,XWF,FCN,1.15,1.E-3,50,IRW) 	TYPE 100, XM,FM,IRM- 100	FORMAT(//' SOLUTION TO X**9-1=0 NEAR 1'// 8 	1' MUELLER''S ITERATION'/' ROOT =',F10.5,'  FUNCTION =' 	2F10.5,/' IER =',I2)  	TYPE 101, XN,FN,IRNA 101	FORMAT(//' NEWTON''S ITERATION'/' ROOT =',F10.5,' FUNCTION ='  	1F10.5,/' IER=',I2) 	TYPE 102, XW,XWF,IRW A 102	FORMAT(//' WEGSTEIN''S ITERATION'/' ROOT =',F10.5,' X-F(X) ='  	1F10.5,/' IER=',I2) 	STOP 'NONLIN successful!' 	END 	FUNCTION FCN(X) C	FUNCTION FOR ROUTINE RTWI  	FCN=X**9+X-1.0  	RETURN  	END 	FUNCTION FCN2(X)  C	FUNCTION FOR ROUTINE RTMI  	FCN2=X**9-1.0 	RETURN  	END 	SUBROUTINE FCN3(X,F,DERF) C	SUBROUTINE FOR ROUTINE RTNI  	F=X**9-1.0  	DERF=9.0*X**8 	RETURN  	END                ) * [STANVICK.SEAS$WORK_294000DB]NONPAR.COM;1 +  , Y   .     /     4 H       V                  - =    0   1    2   3      K  P   W   O     5 -  6 @@  7 ৾ $A  8          9          G    H  J                      B $ COPY IN$:NONPAR.FOR,CHISQ.FOR,GAUSS.FOR,KRANK.FOR TMP$:TMPSSP.11H $ COPY IN$:SRANK.FOR,TIE.FOR,TWOAV.FOR,UTEST.FOR,RANK.FOR TMP$:TMPSSP.12- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                        ) * [STANVICK.SEAS$WORK_294000DB]NONPAR.DAT;1 +  , Y   .     /     4                            - =    0   1    2   3      K  P   W   O     5 -  6 b@  7 ` $A  8          9          G    H  J                       **** CHISQ ****        13.8      18.5       7.7       10.4      13.9       5.7        8.7      11.5       4.8       12.1      16.1       6.8 **** TWOAV ****        100.      160.      150.       915.      180.      210.       135.      125.      175.       100.      110.      110. **** SRANK AND KRANK ****         25.       38.        30.       36.        42.       50.        44.       45.        58.       30.        59.       78.        75.       76.        79.       85.        87.       65.        90.       76.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ) * [STANVICK.SEAS$WORK_294000DB]NONPAR.FOR;1 +  , Y   .     /     4 G       2                  - =    0   1    2   3      K  P   W   O     5 -  6 `P@  7  T $A  8          9          G    H  J                      ? C	NONPAR.FOR - SAMPLE PROGRAM (NONPARAMETRIC STATISTICS) USING: 2 C  CHISQ	- CHI-SQUARE TEST FOR A CONTINGENCY TABLE C  UTEST	- MANN-WHITNEY U-TEST' C  TWOAV	- TWO WAY ANALYSIS OF VARIANCE $ C  SRANK	- SPEARMAN RANK CORRELATION# C  KRANK	- KENDALL RANK CORRELATION 
 C  ...ALSO...  C  RANK		- RANK OBSERVATIONS4 C  TIE		- CALCULATION OF TIES IN RANKED OBSERVATIONS" C  GAUSS	- NORMAL RANDOM GENERATOR+ C		   WHICH USES "RANDU" IN FORTRAN LIBRARY  C G C  THIS PROGRAM MERELY TESTS THESE ROUTINES AND IS NOT TO BE CONSIDERED  C	A TYPICAL APPLICATION  C < 	DIMENSION A2(8,3),R2(8,3),A(65),B(65),WRK(25),A3(4,3),IX(2) 	EQUIVALENCE (A2,A3) C  C  INPUT CHANNEL = IN  	IN = 1  C  C	CHI-SQUARE TEST 	 	NROW = 4 	 	MCOL = 3 8 	OPEN (UNIT=1,NAME='IN$:NONPAR.DAT',TYPE='OLD',READONLY) 	READ(IN,99) JUNK 
 99	FORMAT(A1)  C	JUST TO CLEAR AWAY LABEL CARD . 	READ(IN,100) (WRK(I),WRK(I+4),WRK(I+8),I=1,4) 100	FORMAT(3F10.0), 	CALL CHISQ(WRK,NROW,MCOL,CHIS,NDF,IERR,A,B)5 	TYPE 101, NROW,MCOL,(WRK(I),WRK(I+4),WRK(I+8),I=1,4) 5 101	FORMAT(/' CHI-SQUARE STATISTICS FOR',I3,' BY',I3, $ 	1' CONTINGENCY TABLE:'//4(3F10.1/)) 	TYPE 102, CHIS,NDF B 102	FORMAT(' CHI-SQUARE =',F8.3,' ACTUAL(0.003),DEG OF FREEDOM =', 	1I3,/)  C  C	MANN-WHITNEY UTEST,GAUSS C	GENERATE 2 NORMAL SAMPLES:+ C	1)  MEAN=65, SIGMA=10.5, NO. OF POINTS=30 + C	2)  MEAN=70, SIGMA= 9.5, NO. OF POINTS=35  C	SEED FOR RANDOM NO. GENERATOR  	IX(1)=13107 	IX(2)=0 	DO 1 I=1,30 1	CALL GAUSS(IX,10.5,65.,A(I))
 	DO 2 I=31,65  2	CALL GAUSS(IX,9.5,70.,A(I))  	TYPE 10@                                                                                                                                                                                                                                                                                                                                                  !                         $      RTI020.J                       Y  =  )[STANVICK.SEAS$WORK_294000DB]NONPAR.FOR;1                                                                                      G                             ,             3, (A(I),I=1,30)@ 103	FORMAT(//' UTEST STATISTICS FOR TWO SAMPLES:'/4X'SAMPLE #1 -* 	1 30 NOS., MEAN=65, SIGMA=10.5'/(5F10.0)) 	TYPE 104, (A(I),I=31,65) A 104	FORMAT(/4X'SAMPLE #2 - 35 NOS., MEAN=70, SIGMA=9.5'/(5F10.0))  	CALL UTEST(A,B,30,35,U,Z) 	TYPE 105, U,ZA 105	FORMAT(/' UTEST HOMOGENEITY:',F8.3,'  SIGNIFICANCE:',F8.3,//)  C	CLEAR CARD 	READ(IN,99) JUNK  C  C	TWOAV TEST 	MCOL=3  	NROW=4 % 	READ(IN,100) ((A3(I,J),J=1,3),I=1,4)  C	DATA UNRANKED $ 	CALL TWOAV(A3,R2,4,3,WRK,FRI,NDF,0)	 	TYPE 106 B 106	FORMAT(//' FRIEDMAN TWO-WAY ANALYSIS FOR 4 GROUPS (3 CASES):'/, 	13X,'GROUP    CASE 1    CASE 2    CASE 3'/)$ 	TYPE 107, (I,(A3(I,J),J=1,3),I=1,4) 107	FORMAT(5X,I2,3X,3F10.0)  	TYPE 108, FRI,NDFC 108	FORMAT(/' FRIEDMAN STATISTIC ='F8.3,3X,' DEG OF FREEDOM ='I3//)  C  C	SRANK AND KRANK TESTS  	READ(IN,99) JUNK  	N=10  	READ(IN,109) (A(I),B(I),I=1,N)  109	FORMAT(2F10.0) 	TYPE 110, (A(I),B(I),I=1,N)7 110	FORMAT(//' SPEARMAN AND KENDALL RANK CORRELATIONS'/ " 	1'   GROUP 1   GROUP 2'/(2F10.0))" 	CALL SRANK(A,B,WRK,10,RS,T,NDF,0)! 	CALL KRANK(A,B,WRK,N,TAU,SD,Z,0)  	TYPE 111, RS,T,NDF,TAU,Z,SD= 111	FORMAT(/' SPEARMAN COEF:',F8.3,' ITS SIGNIFICANCE;',F8.3, / 	1' DEG OF FREEDOM=',I3,/' KENDALL COEF:',F8.3, 7 	2' ITS SIGNIFICANCE:',F8.3,' STANDARD DEV. =',F8.3,//)  	STOP 'NONPAR successful!' 	END                                                                                                                                                                                                                            ( * [STANVICK.SEAS$WORK_294000DB]NPAR2.COM;1 +  , Y   .     /     4 7       8                  - =    0   1    2   3      K  P   W   O     5 -  6 @  7 @* $A  8          9          G    H  J                       7 $ COPY IN$:NPAR2.FOR,MOMEN.FOR,QTEST.FOR TMP$:TMPSSP.11 4 $ COPY IN$:RANK.FOR,TIE.FOR,WTEST.FOR TMP$:TMPSSP.12- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                      ( * [STANVICK.SEAS$WORK_294000DB]NPAR2.FOR;1 +  , Y   .     /     4 ?       ^                   - =    0   1    2   3      K  P   W   O     5 -  6 l#@  7 ` $A  8          9          G    H  J                       - C	NPAR2.FOR - NONPARAMETRIC STATISTICS USING: - C  WTEST	- KENDALL COEFFICIENT OF CONCORDANCE  C  QTEST	- COCHRAN Q-TEST  C  MOMEN	- FIRST FOUR MOMENTS  C  ...USES RANK, TIE5 	DIMENSION A(8,3),A1(24),TEN(10),R(8,3),UBO(3),ANS(4)  	EQUIVALENCE (A,A1) 8 	DATA A/4.,2.,1.,7.,6.,3.,5.,8.,7.,2.,1.,6.,4.,5.,3.,8., 	1 7.,4.,2.,6.,5.,3.,1.,8./  C  C  C	WTEST ( 	CALL WTEST(A,R,8,3,TEN,WKEN,CHIS,NDF,0)/ 	TYPE 100, ((A(I,J),J=1,3),I=1,8),WKEN,CHIS,NDF 4 100	FORMAT(/' KENDALL WTEST: 8 VARIABLES, 3 CASES:'/. 	1 8(3F10.0/)/' COEF. OF CONCORDANCE =',F8.4,/= 	2' CHI-SQUARE =',F8.3,' SHOULD BE 0'/' DEG OF FREEDOM =',I4)  C  C	MOMEN  	DO 1 I=1,10 1	TEN(I)=0.  	DO 2 J=1,24 	K=IFIX(A1(J)) 2	TEN(K)=TEN(K)+1. 	TYPE 101, (K,TEN(K),K=1,10): 101	FORMAT(//' MOMENTS - FREQUENCY DIST. OF ABOVE ARRAY:'/% 	1 ' NUMBER  FREQUENCY'/(I5,6X,F4.0)) 
 	UBO(1)=0.
 	UBO(2)=1. 	UBO(3)=10.  	CALL MOMEN(TEN,UBO,5,ANS) 	TYPE 102, (K,ANS(K),K=1,4) - 102	FORMAT(/' MOMENT     VALUE'/(I5,3X,F9.3))  C  C	QTEST 
 	XMEAN=ANS(1)  	DO 3 I=1,24 	IF(A1(I)-XMEAN) 4,4,5
 4	A1(I)=0. 	GO TO 3
 5	A1(I)=1.
 3	CONTINUE
 	A(6,1)=1.! 	TYPE 103, ((A(I,J),J=1,3),I=1,8) = 103	FORMAT(//' Q-TEST - DICHOTOMOUS DATA (8 SETS/3 GROUPS)'//  	1 8(3F8.0/)/) 	CALL QTEST(A1,8,3,Q,NDF)  	TYPE 104, Q,NDF? 104	FORMAT(' COCHRAN Q-STATISTIC ='F8.3,' DEG OF FREEDOM ='I2/)  	STOP 'NPAR2 successful!'  	END                                                                                                                                                                                ( * [STANVICK.SEAS$WORK_294000DB]NROOT.FOR;1 +  , Y	   . 	    /     4 H   	                        - =    0   1    2   3      K  P   W   O 	    5 -  6 @  7 O $A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE NROOT  C  C        PURPOSEG C           COMPUTE EIGENVALUES AND EIGENVECTORS OF A REAL NONSYMMETRIC E C           MATRIX OF THE FORM B-INVERSE TIMES A.  THIS SUBROUTINE IS ? C           NORMALLY CALLED BY SUBROUTINE CANOR IN PERFORMING A + C           CANONICAL CORRELATION ANALYSIS.  C  C        USAGE# C           CALL NROOT (M,A,B,XL,X)  C " C        DESCRIPTION OF PARAMETERS6 C           M  - ORDER OF SQUARE MATRICES A, B, AND X.& C           A  - INPUT MATRIX (M X M).& C           B  - INPUT MATRIX (M X M).D C           XL - OUTPUT VECTOR OF LENGTH M CONTAINING EIGENVALUES OF# C                B-INVERSE TIMES A. F C           X  - OUTPUT MATRIX (M X M) CONTAINING EIGENVECTORS COLUMN- C                WISE. C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           EIGEN  C  C        METHOD F C           REFER TO W. W. COOLEY AND P. R. LOHNES, 'MULTIVARIATE PRO-F C           CEDURES FOR THE BEHAVIORAL SCIENCES', JOHN WILEY AND SONS, C           1962, CHAPTER 3. C H C     .................................................................. C #       SUBROUTINE NROOT (M,A,B,XL,X) $       DIMENSION A(1),B(1),XL(1),X(1) C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C $ C     DOUBLE PRECISION A,B,XL,X,SUMV C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOH C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENTSD C        110 AND 175 MUST BE CHANGED TO DSQRT.  ABS IN STATEMENT 110! C        MUST BE CHANGED TO DABS.  C H C        ............................................................... C / C     COMPUTE EIGENVALUES AND EIGENVECTORS OF B  C 	       K=1        DO 100 J=2,M       L=M*(J-1)        DO 100 I=1,J       L=L+1        K=K+1    100 B(K)=B(L)  C 1 C        THE MATRIX B IS A REAL SYMMETRIC MATRIX.  C 
       MV=0       CALL EIGEN (B,X,M,MV)  C B C     FORM RECIPROCALS OF SQUARE ROOT OF EIGENVALUES.  THE RESULTS7 C     ARE PREMULTIPLIED BY THE ASSOCIATED EIGENVECTORS.  C 	       L=0        DO 110 J=1,M       L=L+J !   110 XL(J)=1.0/ SQRT( ABS(B(L))) 	       K=0        DO 115 J=1,M       DO 115 I=1,M       K=K+1    115 B(K)=X(K)*XL(J)  C - C     FORM (B**(-1/2))PRIME * A * (B**(-1/2))  C        DO 120 I=1,M
       N2=0       DO 120 J=1,M       N1=M*(I-1)       L=M*(J-1)+I        X(L)=0.0       DO 120 K=1,M
       N1=N1+1 
       N2=N2+1    120 X(L)=X(L)+B(N1)*A(N2) 	       L=0        DO 130 J=1,M       DO 130 I=1,J       N1=I-M       N2=M*(J-1)       L=L+1        A(L)=0.0       DO 130 K=1,M
       N1=N1+M 
       N2=N2+1    130 A(L)=A(L)+X(N1)*B(N2)  C / C     COMPUTE EIGENVALUES AND EIGENVECTORS OF A  C        CALL EIGEN (A,X,M,MV) 	       L=0        DO 140 I=1,M       L=L+I    140 XL(I)=A(L) C ) C     COMPUTE THE NORMALIZED EIGENVECTORS  C        DO 150 I=1,M
       N2=0       DO 150 J=1,M       N1=I-M       L=M*(J-1)+I        A(L)=0.0       DO 150 K=1,M
       N1=N1+M 
       N2=N2+1    150 A(L)=A(L)+B(N1)*X(N2) 	       L=0 	       K=0        DO 180 J=1,M       SUMV=0.0       DO 170 I=1,M       L=L+1    170 SUMV=SUMV+A(L)*A(L)    175 SUMV= SQRT(SUMV)       DO 180 I=1,M       K=K+1    180 X(K)=A(K)/SUMV       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]ORDER.FOR;1 +  , Y   . 	    /     4 H   	                        - =    0   1    2   3      K  P   W   O 	    5 -  6 @  7 1$A  8          9          G    H  J                        `                                                                                                                   "                        . $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]ORDER.FOR;1                                                                                       H     	                         ͟              C H C     .................................................................. C  C        SUBROUTINE ORDER  C  C        PURPOSEF C           CONSTRUCT FROM A LARGER MATRIX OF CORRELATION COEFFICIENTSB C           A SUBSET MATRIX OF INTERCORRELATIONS AMONG INDEPENDENTF C           VARIABLES AND A VECTOR OF INTERCORRELATIONS OF INDEPENDENTB C           VARIABLES WITH DEPENDENT VARIABLE.  THIS SUBROUTINE ISG C           NORMALLY USED IN THE PERFORMANCE OF MULTIPLE AND POLYNOMIAL   C           REGRESSION ANALYSES. C  C        USAGE/ C           CALL ORDER (M,R,NDEP,K,ISAVE,RX,RY)  C " C        DESCRIPTION OF PARAMETERS> C           M     - NUMBER OF VARIABLES AND ORDER OF MATRIX R.E C           R     - INPUT MATRIX CONTAINING CORRELATION COEFFICIENTS. A C                   THIS SUBROUTINE EXPECTS ONLY UPPER TRIANGULAR D C                   PORTION OF THE SYMMETRIC MATRIX TO BE STORED (BY6 C                   COLUMN) IN R.  (STORAGE MODE OF 1)C C           NDEP  - THE SUBSCRIPT NUMBER OF THE DEPENDENT VARIABLE. B C           K     - NUMBER OF INDEPENDENT VARIABLES TO BE INCLUDEDC C                  IN THE FORTHCOMING REGRESSION. K MUST BE GREATER & C                  THAN OR EQUAL TO 1.G C           ISAVE - INPUT VECTOR OF LENGTH K+1 CONTAINING, IN ASCENDING A C                   ORDER, THE SUBSCRIPT NUMBERS OF K INDEPENDENT G C                   VARIABLES TO BE INCLUDED IN THE FORTHCOMING REGRES-  C                   SION. F C                   UPON RETURNING TO THE CALLING ROUTINE, THIS VECTORB C                   CONTAINS, IN ADDITION, THE SUBSCRIPT NUMBER OF; C                   THE DEPENDENT VARIABLE IN K+1 POSITION. F C           RX    - OUTPUT MATRIX (K X K) CONTAINING INTERCORRELATIONSD C                   AMONG INDEPENDENT VARIABLES TO BE USED IN FORTH-& C                   COMING REGRESSION.F C           RY    - OUTPUT VECTOR OF LENGTH K CONTAINING INTERCORRELA-A C                   TIONS OF INDEPENDENT VARIABLES WITH DEPENDENT  C                   VARIABLES. C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           FROM THE SUBSCRIPT NUMBERS OF THE VARIABLES TO BE INCLUDEDH C           IN THE FORTHCOMING REGRESSION, THE SUBROUTINE CONSTRUCTS THE( C           MATRIX RX AND THE VECTOR RY. C H C     .................................................................. C /       SUBROUTINE ORDER (M,R,NDEP,K,ISAVE,RX,RY) )       DIMENSION R(1),ISAVE(1),RX(1),RY(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C  C     DOUBLE PRECISION R,RX,RY C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C H C        ............................................................... C 5 C     COPY INTERCORRELATIONS OF INDEPENDENT VARIABLES  C     WITH DEPENDENT VARIABLE  C 
       MM=0       DO 130 J=1,K       L2=ISAVE(J)        IF(NDEP-L2) 122, 123, 123    122 L=NDEP+(L2*L2-L2)/2        GO TO 125    123 L=L2+(NDEP*NDEP-NDEP)/2    125 RY(J)=R(L) C 5 C     COPY A SUBSET MATRIX OF INTERCORRELATIONS AMONG  C     INDEPENDENT VARIABLES  C        DO 130 I=1,K       L1=ISAVE(I)        IF(L1-L2) 127, 128, 128    127 L=L1+(L2*L2-L2)/2        GO TO 129    128 L=L2+(L1*L1-L1)/2 
   129 MM=MM+1    130 RX(MM)=R(L)  C 1 C     PLACE THE SUBSCRIPT NUMBER OF THE DEPENDENT  C     VARIABLE IN ISAVE(K+1) C        ISAVE(K+1)=NDEP        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                       ' * [STANVICK.SEAS$WORK_294000DB]PADD.FOR;1 +  , Y   .     /     4 H       p                   - =    0   1    2   3      K  P   W   O     5 -  6 0@  7 uF$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PADD C  C        PURPOSE C           ADD TWO POLYNOMIALS  C  C        USAGE. C           CALL PADD(Z,IDIMZ,X,IDIMX,Y,IDIMY) C " C        DESCRIPTION OF PARAMETERSB C           Z     - VECTOR OF RESULTANT COEFFICIENTS, ORDERED FROM- C                   SMALLEST TO LARGEST POWER / C           IDIMZ - DIMENSION OF Z (CALCULATED) H C           X     - VECTOR OF COEFFICIENTS FOR FIRST POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER6 C           IDIMX - DIMENSION OF X (DEGREE IS IDIMX-1)A C           Y     - VECTOR OF COEFFICIENTS FOR SECOND POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER6 C           IDIMY - DIMENSION OF Y (DEGREE IS IDIMY-1) C  C        REMARKSB C           VECTOR Z MAY BE IN SAME LOCATION AS EITHER VECTOR X ORE C           VECTOR Y ONLY IF THE DIMENSION OF THAT VECTOR IS NOT LESS ' C           THAN THE OTHER INPUT VECTOR H C           THE RESULTANT POLYNOMIAL MAY HAVE TRAILING ZERO COEFFICIENTS C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           DIMENSION OF RESULTANT VECTOR IDIMZ IS CALCULATED AS THED C           LARGER OF THE TWO INPUT VECTOR DIMENSIONS. CORRESPONDING2 C           COEFFICIENTS ARE THEN ADDED TO FORM Z. C H C     .................................................................. C .       SUBROUTINE PADD(Z,IDIMZ,X,IDIMX,Y,IDIMY)       DIMENSION Z(1),X(1),Y(1) C ! C     TEST DIMENSIONS OF SUMMANDS  C        NDIM=IDIMX       IF (IDIMX-IDIMY) 10,20,20     10 NDIM=IDIMY    20 IF(NDIM) 90,90,30     30 DO 80 I=1,NDIM       IF(I-IDIMX) 40,40,60    40 IF(I-IDIMY) 50,50,70    50 Z(I)=X(I)+Y(I)       GO TO 80    60 Z(I)=Y(I)        GO TO 80    70 Z(I)=X(I)     80 CONTINUE    90 IDIMZ=NDIM       RETURN	       END                                                                                                                                                               ( * [STANVICK.SEAS$WORK_294000DB]PADDM.FOR;1 +  , Y   .     /     4 H       V                    - =    0   1    2   3      K  P   W   O     5 -  6 `v@  7  X$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE PADDM  C  C        PURPOSEB C           ADD COEFFICIENTS OF ONE POLYNOMIAL TO THE PRODUCT OF A8 C           FACTOR BY COEFFICIENTS OF ANOTHER POLYNOMIAL C  C        USAGE4 C           CALL PADDM(Z,IDIMZ,X,IDIMX,FACT,Y,IDIMY) C " C        DESCRIPTION OF PARAMETERSB C           Z     - VECTOR OF RESULTANT COEFFICIENTS, ORDERED FROM- C                   SMALLEST TO LARGEST POWER / C           IDIMZ - DIMENSION OF Z (CALCULATED) H C           X     - VECTOR OF COEFFICIENTS FOR FIRST POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER6 C           IDIMX - DIMENSION OF X (DEGREE IS IDIMX-1)7 C           FACT  - FACTOR TO BE MULTIPLIED BY VECTOR Y A C           Y     - VECTOR OF COEFFICIENTS FOR SECOND POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER6 C           IDIMY - DIMENSION OF Y (DEGREE IS IDIMY-1) C  C        REMARKSB C           VECTOR Z MAY BE IN SAME LOCATION AS EITHER VECTOR X ORE C           VECTOR Y ONLY IF THE DIMENSION OF THAT VECTOR IS NOT LESS ' C           THAN THE OTHER INPUT VECTOR H C           THE RESULTANT POLYNOMIAL MAY HAVE TRAILING ZERO COEFFICIENTS C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           DIMENSION OF RESULTANT VECTOR IDIMZ IS CALCULATED AS THEE C           LARGER OF THE TWO INPUT VECTOR DIMENSIONS. COEFFICIENT IN H C           VECTOR X IS THEN ADDED TO COEFFICIENT IN VECTOR Y MULTIPLIED  C           BY FACTOR TO FORM Z. C H C     .................................................................. C 4       SUBROUTINE PADDM(Z,IDIMZ,X,IDIMX,FACT,Y,IDIMY)       DIMENSION Z(1),X(1),Y(1) C ! C     TEST DIMENSIONS OF SUMMANDS  C        NDIM=IDIMX       IF(IDIMX-IDIMY) 10,20,20    10 NDIM=IDIMY    20 IF(NDIM) 90,90,30     30 DO 80 I=1,NDIM       IF(I-IDIMX) 40,40,60    40 IF(I-IDIMY) 50,50,70    50 Z(I)=FACT*Y(I)+X(I)        GO TO 80    60 Z(I)=FACT*Y(I)                                                                                                                                                                                          #                        tQs $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]PADDM.FOR;1                                                                                       H                              g             GO TO 80    70 Z(I)=X(I)     80 CONTINUE    90 IDIMZ=NDIM       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                         ' * [STANVICK.SEAS$WORK_294000DB]PCLA.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @J@  7  l$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PCLA C  C        PURPOSE" C           MOVE POLYNOMIAL X TO Y C  C        USAGE& C           CALL PCLA(Y,IDIMY,X,IDIMX) C " C        DESCRIPTION OF PARAMETERSB C           Y     - VECTOR OF RESULTANT COEFFICIENTS, ORDERED FROM- C                   SMALLEST TO LARGEST POWER " C           IDIMY - DIMENSION OF YB C           X     - VECTOR OF COEFFICIENTS FOR POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER" C           IDIMX - DIMENSION OF X C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD A C           IDIMY IS REPLACED BY IDIMX AND VECTOR X IS MOVED TO Y  C H C     .................................................................. C '       SUBROUTINE PCLA (Y,IDIMY,X,IDIMX)        DIMENSION X(1),Y(1)  C        IDIMY=IDIMX        IF(IDIMX) 30,30,10    10 DO 20 I=1,IDIMX     20 Y(I)=X(I)     30 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]PCLD.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  @  7 ~$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PCLD C  C        PURPOSE@ C           SHIFT OF ORIGIN (COMPLETE LINEAR SYNTHETIC DIVISION) C  C        USAGE  C           CALL PCLD(X,IDIMX,U) C " C        DESCRIPTION OF PARAMETERSD C           X     - VECTOR OF COEFFICIENTS, ORDERED FROM SMALLEST TO> C                   LARGEST POWER. IT IS REPLACED BY VECTOR OF- C                   TRANSFORMED COEFFICIENTS. " C           IDIMX - DIMENSION OF X# C           U     - SHIFT PARAMETER  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           COEFFICIENT VECTOR X(I) OF POLYNOMIAL P(Z) IS TRANSFORMED C C           SUCH THAT Q(Z)=P(Z-U) WHERE Q(Z) DENOTES THE POLYNOMIAL 0 C           WITH TRANSFORMED COEFFICIENT VECTOR. C H C     .................................................................. C !       SUBROUTINE PCLD (X,IDIMX,U)        DIMENSION X(1) C 	       K=1 
     1 J=IDIMX      2 IF (J-K) 4,4,3     3 X(J-1)=X(J-1)+U*X(J)       J=J-1 
       GO TO 2      4 K=K+1        IF (IDIMX-K) 5,5,1     5 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]PDER.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7 `G$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PDER C  C        PURPOSE+ C           FIND DERIVATIVE OF A POLYNOMIAL  C  C        USAGE& C           CALL PDER(Y,IDIMY,X,IDIMX) C " C        DESCRIPTION OF PARAMETERSG C           Y     - VECTOR OF COEFFICIENTS FOR DERIVATIVE, ORDERED FROM - C                   SMALLEST TO LARGEST POWER 5 C           IDIMY - DIMENSION OF Y (EQUAL TO IDIMX-1) C C           X     - VECTOR OF COEFFICIENTS FOR ORIGINAL POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER" C           IDIMX - DIMENSION OF X C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           DIMENSION OF Y IS SET AT DIMENSION OF X LESS ONE. DERIVATIVEC C           IS THEN CALCULATED BY MULTIPLYING COEFFICIENTS BY THEIR ! C           RESPECTIVE EXPONENTS.  C H C     .................................................................. C &       SUBROUTINE PDER(Y,IDIMY,X,IDIMX)       DIMENSION X(1),Y(1)  C  C     TEST OF DIMENSION        IF (IDIMX-1) 3,3,1     1 IDIMY=IDIMX-1 
       EXPT=0.        DO 2 I=1,IDIMY       EXPT=EXPT+1.     2 Y(I)=X(I+1)*EXPT
       GO TO 4 
     3 IDIMY=0      4 RETURN	       END                                                                                                                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]PDIV.FOR;1 +  , Y   .     /     4 H       L                  - =    0   1    2   3      K  P   W   O     5 -  6 @  7  $A  8          9          G    H  J            
             C H C     .................................................................. C  C        SUBROUTINE PDIV C  C        PURPOSE, C           DIVIDE ONE POLYNOMIAL BY ANOTHER C  C        USAGE6 C           CALL PDIV(P,IDIMP,X,IDIMX,Y,IDIMY,TOL,IER) C " C        DESCRIPTION OF PARAMETERS5 C           P     - RESULTANT VECTOR OF INTEGRAL PART " C           IDIMP - DIMENSION OF PC C           X     - VECTOR OF COEFFICIENTS FOR DIVIDEND POLYNOMIAL, A C                   ORDERED FROM SMALLEST TO LARGEST POWER. IT IS 9 C                   REPLACED BY REMAINDER AFTER DIVISION. " C           IDIMX - DIMENSION OF XB C           Y     - VECTOR OF COEFFICIENTS FOR DIVISOR POLYNOMIAL,: C                   ORDERED FROM SMALLEST TO LARGEST POWER" C           IDIMY - DIMENSION OF Y@ C           TOL   - TOLERANCE VALUE BELOW WHICH COEFFICIENTS ARE3 C                   ELIMINATED DURING NORMALIZATION B C           IER   - ERROR CODE. 0 IS NORMAL, 1 IS FOR ZERO DIVISOR C  C        REMARKS' C           THE REMAINDER R REPLACES X. , C           THE DIVISOR Y REMAINS UNCHANGED.E C           IF DIMENSION OF Y EXCEEDS DIMENSION OF X, IDIMP IS SET TO , C           ZERO AND CALCULATION IS BYPASSED# C	    IDIMX IS MODIFIED UPON RETURN  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           PNORM  C  C        METHOD G C           POLYNOMIAL X IS DIVIDED BY POLYNOMIAL Y GIVING INTEGER PART 4 C           P AND REMAINDER R SUCH THAT X = P*Y + R.; C           DIVISOR Y AND REMAINDER  VECTOR GET NORMALIZED.  C H C     .................................................................. C 6       SUBROUTINE PDIV(P,IDIMP,X,IDIMX,Y,IDIMY,TOL,IER)       DIMENSION P(1),X(1),Y(1) C        CALL PNORM (Y,IDIMY,TOL)       IF(IDIMY) 50,50,10    10 IDIMP=IDIMX-IDIMY+1        IF(IDIMP) 20,30,60 C ; C     DEGREE OF DIVISOR WAS GREATER THAN DEGREE OF DIVIDEND  C 
    20 IDIMP=0     30 IER=0     40 RETURN C  C     Y IS ZERO POLYNOMIAL C     50 IER=1        GO TO 40 C  C     START REDUCTION  C     60 IDIMX=IDIMY-1 
       I=IDIMP     70 II=I+IDIMX       P(I)=X(II)/Y(IDIMY)  C " C     SUBTRACT MULTIPLE OF DIVISOR C        DO 80 K=1,IDIMX 
       J=K-1+I        X(J)=X(J)-P(I)*Y(K)     80 CONTINUE       I=I-1        IF(I) 90,90,70 C $ C     NORMALIZE REMAINDER POLYNOMIAL C     90 CALL PNORM(X,IDIMX,TOL)        GO TO 30	       END                                                                                                                                                                                     `                                                                                                                   $                        O $      RTI020.J                       Y  =  '[STANVICK.SEAS$WORK_294000DB]PGCD.FOR;1                                                                                        H                              #              ' * [STANVICK.SEAS$WORK_294000DB]PGCD.FOR;1 +  , Y   .     /     4 H       `                    - =    0   1    2   3      K  P   W   O     5 -  6 @t@  7  m$A  8          9          G    H  J            
             C H C     .................................................................. C  C        SUBROUTINE PGCD C  C        PURPOSE@ C           DETERMINE GREATEST COMMON DIVISOR OF TWO POLYNOMIALS C  C        USAGE3 C           CALL PGCD(X,IDIMX,Y,IDIMY,WORK,EPS,IER)  C " C        DESCRIPTION OF PARAMETERSA C           X     -  VECTOR OF COEFFICIENTS FOR FIRST POLYNOMIAL, ; C                    ORDERED FROM SMALLEST TO LARGEST POWER # C           IDIMX -  DIMENSION OF X B C           Y     -  VECTOR OF COEFFICIENTS FOR SECOND POLYNOMIAL,< C                    ORDERED FROM SMALLEST TO LARGEST POWER.@ C                    THIS IS REPLACED BY GREATEST COMMON DIVISOR# C           IDIMY -  DIMENSION OF Y * C           WORK  -  WORKING STORAGE ARRAY? C           EPS   -  TOLERANCE VALUE BELOW WHICH COEFFICIENT IS 4 C                    ELIMINATED DURING NORMALIZATION/ C           IER   -  RESULTANT ERROR CODE WHERE $ C                    IER=0  NO ERROR5 C                    IER=1  X OR Y IS ZERO POLYNOMIAL  C  C        REMARKS, C           IDIMX MUST BE GREATER THAN IDIMYC C           IDIMY=1 ON RETURN MEANS X AND Y ARE PRIME, THE GCD IS A < C           CONSTANT. IDIMX IS DESTROYED DURING COMPUTATION. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           PDIV C           PNORM  C  C        METHOD A C           GREATEST COMMON DIVISOR OF TWO POLYNOMIALS X AND Y IS C C           DETERMINED BY MEANS OF EUCLIDEAN ALGORITHM. COEFFICIENT = C           VECTORS X AND Y ARE DESTROYED AND GREATEST COMMON & C           DIVISOR IS GENERATED IN Y. C H C     .................................................................. C 3       SUBROUTINE PGCD(X,IDIMX,Y,IDIMY,WORK,EPS,IER) !       DIMENSION X(1),Y(1),WORK(1)  C C C     DIMENSION REQUIRED FOR VECTOR NAMED  WORK  IS   IDIMX-IDIMY+1  C 2     1 CALL PDIV(WORK,NDIM,X,IDIMX,Y,IDIMY,EPS,IER)       IF(IER) 5,2,5      2 IF(IDIMX) 5,5,3  C  C     INTERCHANGE X AND Y  C      3 DO 4 J=1,IDIMY       WORK(1)=X(J)       X(J)=Y(J)      4 Y(J)=WORK(1)       NDIM=IDIMX       IDIMX=IDIMY        IDIMY=NDIM
       GO TO 1      5 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                               ' * [STANVICK.SEAS$WORK_294000DB]PILD.FOR;1 +  , Y   .     /     4 H       z                    - =    0   1    2   3      K  P   W   O     5 -  6  ,@  7  C$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PILD C  C        PURPOSED C           EVALUATE POLYNOMIAL AND ITS FIRST DERIVATIVE FOR A GIVEN C           ARGUMENT C  C        USAGE. C           CALL PILD(POLY,DVAL,ARGUM,X,IDIMX) C " C        DESCRIPTION OF PARAMETERS' C           POLY  - VALUE OF POLYNOMIAL  C           DVAL  - DERIVATIVE C           ARGUM - ARGUMENTB C           X     - VECTOR OF COEFFICIENTS FOR POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER" C           IDIMX - DIMENSION OF X C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           PQSD C  C        METHOD E C           EVALUATION IS DONE BY MEANS OF SUBROUTINE PQSD (QUADRATIC  C           SYNTHETIC DIVISION)  C H C     .................................................................. C /       SUBROUTINE PILD (POLY,DVAL,ARGUM,X,IDIMX)        DIMENSION X(1) C        P=ARGUM+ARGUM        Q=-ARGUM*ARGUM C '       CALL PQSD (DVAL,POLY,P,Q,X,IDIMX)  C        POLY=ARGUM*DVAL+POLY C        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]PINT.FOR;1 +  , Y   .     /     4 H       T                   - =    0   1    2   3      K  P   W   O     5 -  6 `l@  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PINT C  C        PURPOSEF C           FIND INTEGRAL OF A POLYNOMIAL WITH CONSTANT OF INTEGRATION C           EQUAL TO ZERO  C  C        USAGE& C           CALL PINT(Y,IDIMY,X,IDIMX) C " C        DESCRIPTION OF PARAMETERSE C           Y     - VECTOR OF COEFFICIENTS FOR INTEGRAL, ORDERED FROM - C                   SMALLEST TO LARGEST POWER 5 C           IDIMY - DIMENSION OF Y (EQUAL TO IDIMX+1) C C           X     - VECTOR OF COEFFICIENTS FOR ORIGINAL POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER" C           IDIMX - DIMENSION OF X C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           DIMENSION OF Y IS SET AT DIMENSION OF X PLUS ONE, AND THE E C           CONSTANT TERM IS SET TO ZERO. INTEGRAL IS THEN CALCULATED C C           BY DIVIDING COEFFICIENTS BY THEIR RESPECTIVE EXPONENTS.  C H C     .................................................................. C &       SUBROUTINE PINT(Y,IDIMY,X,IDIMX)       DIMENSION X(1),Y(1)  C        IDIMY=IDIMX+1 
       Y(1)=0.        IF(IDIMX)1,1,2     1 RETURN
     2 EXPT=1.        DO 3 I=2,IDIMY       Y(I)=X(I-1)/EXPT     3 EXPT=EXPT+1.
       GO TO 1 	       END                                                                                                                                                                                           ' * [STANVICK.SEAS$WORK_294000DB]PMPY.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 `xH@  7 h$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PMPY C  C        PURPOSE$ C           MULTIPLY TWO POLYNOMIALS C  C        USAGE. C           CALL PMPY(Z,IDIMZ,X,IDIMX,Y,IDIMY) C " C        DESCRIPTION OF PARAMETERSB C           Z     - VECTOR OF RESULTANT COEFFICIENTS, ORDERED FROM- C                   SMALLEST TO LARGEST POWER / C           IDIMZ - DIMENSION OF Z (CALCULATED) H C           X     - VECTOR OF COEFFICIENTS FOR FIRST POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER6 C           IDIMX - DIMENSION OF X (DEGREE IS IDIMX-1)A C           Y     - VECTOR OF COEFFICIENTS FOR SECOND POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER6 C           IDIMY - DIMENSION OF Y (DEGREE IS IDIMY-1) C  C        REMARKS1 C           Z CANNOT BE IN THE SAME LOCATION AS X 1 C           Z CANNOT BE IN THE SAME LOCATION AS Y  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD 9 C           DIMENSION OF Z IS CALCULATED AS IDIMX+IDIMY-1 C C           THE COEFFICIENTS OF Z ARE CALCULATED AS SUM OF PRODUCTS F C           OF COEFFICIENTS OF X AND Y , WHOSE EXPONENTS ADD UP TO THE( C           CORRESPONDING EXPONENT OF Z. C H C     .................................................................. C .       SUBROUTINE PMPY(Z,IDIMZ,X,IDIMX,Y,IDIMY)       DIMENSION Z(1),X(1),Y(1) C        IF(IDIMX*IDIMY)10,10,20 
    10 IDIMZ=0        GO TO 50    20 IDIMZ=IDIMX+IDIMY-1        DO 30 I=1,IDIMZ 
    30 Z(I)=0.        DO 40 I=1,IDIMX        DO 40 J=1,IDIMY 
       K=I+J-1     40 Z(K)=X(I)*Y(J)+Z(K)     50 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                   p                                                                                                                                   %                        U $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]PNORM.FOR;1                                                                                       H                                            ( * [STANVICK.SEAS$WORK_294000DB]PNORM.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 ?@  7 	$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE PNORM  C  C        PURPOSE8 C           NORMALIZE COEFFICIENT VECTOR OF A POLYNOMIAL C  C        USAGE# C           CALL PNORM(X,IDIMX,EPS)  C " C        DESCRIPTION OF PARAMETERSB C           X      - VECTOR OF ORIGINAL COEFFICIENTS, ORDERED FROMD C                    SMALLEST TO LARGEST POWER. IT REMAINS UNCHANGEDF C           IDIMX  - DIMENSION OF X. IT IS REPLACED BY FINAL DIMENSIOND C           EPS    - TOLERANCE BELOW WHICH COEFFICIENT IS ELIMINATED C  C        REMARKSC C           IF ALL COEFFICIENTS ARE LESS THAN EPS, RESULT IS A ZERO ? C           POLYNOMIAL WITH IDIMX=0 BUT VECTOR X REMAINS INTACT  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           DIMENSION OF VECTOR X IS REDUCED BY ONE FOR EACH TRAILING H C           COEFFICIENT WITH AN ABSOLUTE VALUE LESS THAN OR EQUAL TO EPS C H C     .................................................................. C #       SUBROUTINE PNORM(X,IDIMX,EPS)        DIMENSION X(1) C      1 IF(IDIMX) 4,4,2 !     2 IF(ABS(X(IDIMX))-EPS) 3,3,4      3 IDIMX=IDIMX-1 
       GO TO 1      4 RETURN	       END                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]POLRG.COM;1 +  , Y   .     /     4 J                          - =    0   1    2   3      K  P   W   O     5 -  6 `@  7 $A  8          9          G    H  J                       J $ COPY IN$:POLRG.FOR,GDATA.FOR,MINV.FOR,MULTR.FOR,ORDER.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                  ( * [STANVICK.SEAS$WORK_294000DB]POLRG.DAT;1 +  , Y   .     /     4                            - =    0   1    2   3      K  P   W   O     5 -  6 c@  7 `2$A  8          9          G    H  J                        SAMPLE   15041      1    10      2    16      3    20      4    23      5    25      6    26      7    30      8    36      9    48     10    62     11    78     12    94     13   107     14   118     15   127                                                                                                                                                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]POLRG.FOR;1 +  , Y   .     /     4 @                         - =    0   1    2   3      K  P   W   O 
    5 -  6 *@  7 GE$A  8          9          G    H  J                       7 C	SAMPLE MAIN PROGRAM FOR POLYNOMIAL REGRESSION - POLRG : C  THE FOLLOWING ROUTINES ARE USED: GDATA,ORDER,MINV,MULTR4 C	AND AN OPTIONAL PLOTTING SUBROUTINE COULD BE ADDED C > C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE> C	PRODUCT OF N*(M+1) WHERE N IS THE NUMBER OF OBSERVATIONS AND/ C	M IS THE HIGHEST DEGREE POLYNOMIAL SPECIFIED.  	DIMENSION X(75)> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO THE C	PRODUCT OF M*M.  	DIMENSION DI(16) : C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO C	(M+2)*(M+1)/2. 	DIMENSION D(15)> C	THE FOLLOWING DIMENSIONS MUST BE GREATER THAN OR EQUAL TO M. 	DIMENSION B(4),SB(4),T(4),E(4) ; C	THE FOLLOWING DIMENSIONS MUST BE GREATER THAN OR EQUAL TO  C	(M+1).2 	DIMENSION XBAR(5),STD(5),COE(5),SUMSQ(5),ISAVE(5)> C	THE FOLLOWING DIMENSION MUST BE GREATER THAN OR EQUAL TO 10. 	DIMENSION ANS(10)> C	THE FOLLOWING DIMENSION WILL BE USED IF THE PLOT OF OBSERVED? C	DATA AND ESTIMATES IS DESIRED.  THE SIZE OF THE DIMENSION, IN = C	THIS CASE, MUST BE GREATER THAN OR EQUAL TO N*3. OTHERWISE, , C	THE SIZE OF THE DIMENSION MAY BE SET TO 1. 	DIMENSION P(45)
 	COMMON IN C  C	INPUT CHANNEL = IN 1	FORMAT(A4,A2,I5,I2,I1) 2	FORMAT(2F6.0) 0 3	FORMAT(//27H POLYNOMIAL REGRESSION.....,A4,A2)' 4	FORMAT(/23H NUMBER OF OBSERVATION,I6) 1 5	FORMAT(/32H POLYNOMIAL REGRESSION OF DEGREE,I3)   6	FORMAT(/12H   INTERCEPT,F15.5)1 7	FORMAT(/26H   REGRESSION COEFFICIENTS/(6F12.5)) @ 8	FORMAT(/8X,24HANALYSIS OF VARIANCE FOR,I4,19H  DEGREE POLYNOMI 	1AL/): 9	FORMAT(/' SOURCE OF VARIATION  DEGREE'6X'SUM OF'8X'MEAN'6 	110X'F    IMPROVEMENT'/24X'OF'8X'SQUARES'7X'SQUARE'6X7 	2'VALUE  IN TERMS OF'/21X'FREEDOM'39X'SUM OF SQUARES') - 10	FORMAT(/' DUE TO REGRESSION',I6,4X,4F13.5) 9 11	FORMAT(' DEVIATION ABOUT'/8X'REGRESSION',I6,4X,2F13.5) & 12	FORMAT(' TOTAL',12X,I6,4X,F13.5///)  13	FORMAT(/17H  NO IMPROVEMENT )= 14	FORMAT(//27X,18HTABLE OF RESIDUALS//16H OBSERVATION NO.,5X : 	1,7HX VALUE,7X,7HY VALUE,7X,10HY ESTIMATE,7X,8HRESIDUAL/)* 15	FORMAT(/,3X,I6,F18.5,F14.5,F17.5,F15.5) C  	IN=1  C	READ PARAMETER CARD 7 	OPEN (UNIT=1,NAME='IN$:POLRG.DAT',TYPE='OLD',READONLY)  100	READ(IN,1) PR,PR1,N,M,NPLOT ' C	PR=PROBLEM NUMBER (MAY BE ALPHAMERIC)   C	PR1=PROBLEM NUMBER (CONTINUED) C	N=NUMBER OF OBSERVATIONS' C	M=HIGHEST DEGREE POLYNOMIAL SPECIFIED   C	NPLOT=OPTION CODE FOR PLOTTING C		0 IF PLOT IS NOT DESIRED  C		1 IF PLOT IS DESIRED $ 	IF(N.EQ.0) STOP 'POLRG successful!' C	PRINT PROBLEM NUMBER AND N.    	TYPE 3, PR,PR1 
 	TYPE 4, N C	READ INPUT DATA  	L=N*M
 	DO 110 I=1,N  	J=L+I= C	X(I) IS THE INDEPENDENT VARIABLE, AND X(J) IS THE DEPENDENT  C	VARIABLE.  110	READ(IN,2) X(I),X(J)# 	CALL GDATA(N,M,X,XBAR,STD,D,SUMSQ)  	MM=M+1  	SUM=0.0 	NT=N-1 
 	DO 200 I=1,M  	ISAVE(I)=I / C	FORM SUBSET OF CORRELATION COEFFICIENT MATRIX ! 	CALL ORDER(MM,D,MM,I,ISAVE,DI,E) 2 C	INVERT THE SUBMATRIX OF CORRELATION COEFFICIENTS 	CALL MINV(DI,I,DET,B,T)5 	CALL MULTR(N,I,XBAR,STD,SUMSQ,DI,E,ISAVE,B,SB,T,ANS) ! C	PRINT THE RESULT OF CALCULATION 
 	TYPE 5, I 	IF(ANS(7)) 140,130,130  130	SUMIP=ANS(4)-SUM 	IF(SUMIP) 140,140,150 140	TYPE 13 
 	GO TO 210 150	TYPE 6, ANS(1) 	TYPE 7, (B(J),J=1,I) 
 	TYPE 8, I 	TYPE 9  	SUM=ANS(4) ' 	TYPE 10, I,ANS(4),ANS(6),ANS(10),SUMIP 
 	NI=ANS(8) 	TYPE 11, NI,ANS(7),ANS(9) 	TYPE 12, NT,SUMSQ(MM)2 C	SAVE COEFFICIENTS FOR CALCULATION OF Y ESTIMATES 	COE(1)=ANS(1)
 	DO 160 J=1,I  160	COE(J+1)=B(J)  	LA=I  200	CONTINUE C	TEST WHETHER PLOT IS DESIRED 210	IF(NPLOT) 100,100,220  C	CALCULATE ESTIMATES  220	NP3=N+N 
 	DO 230 I=1,N 
 	NP3=NP3+1 	P(NP3)=COE(1) 	L=I 	DO 230 J=1,LA 	P(NP3)=P(NP3)+X(L)*COE(J+1)	 230	L=L+N  C	COPY OBSERVED DATA 	N2=N  	L=N*M
 	DO 240 I=1,N 
 	P(I)=X(I) 	N2=N2+1 	L=L+1 240	P(N2)=X(L) C	PRINT TABLE OF RESIDUALS 	TYPE 3, PR,PR1  	TYPE 5, LA  	TYPE 14 	NP2=N 	NP3=N+N
 	DO 250 I=1,N 
 	NP2=NP2+1
 	NP3=NP3+1 	RESID=P(NP2)-P(NP3)' 250	TYPE 15, I,P(I),P(NP2),P(NP3),RESID  	CALL PLOT(LA,P,N,3,0,80,1) 
 	GO TO 100 	END# 	SUBROUTINE PLOT(NO,A,N,M,NL,NC,NS) * 	DIMENSION OUT(132),YPR(12),BLANK(10),A(1) 	EQUIVALENCE(BL,BLANK) 	INTEGER OUT,BLANK,BL,DIV 
 	COMMON IN= 	DATA BLANK/' ','1','2','3','4','5','6','7','8','9'/,DIV/'I'/  C  1	FORMAT(///25X' CHART 'I3//)  2	FORMAT(1X,F11.4,4X,115A1)  4	FORMAT(132A1)  8	FORMAT(9X,12F10.4) 	IFLAG=0 	NLL=NL  	NCC=NC  	IF(NS) 16,16,10, C	SORT BASE VARIABLE DATA IN ASCENDING ORDER
 10	NM1=N-1 	DO 15 I=1,NM1 	IP1=I+1 	DO 14 J=IP1,N 	IF(A(I)-A(J)) 14,14,11  11	L=I-N 	LL=J-N 
 C	SWITCH ROWS  	DO 12 K=1,M 	L=L+N 	LL=LL+N 	F=A(L)  	A(L)=A(LL) 
 12	A(LL)=F 14	CONTINUE  15	CONTINUE  C	CHECK DEFAULT CONDITIONS 16	IF(NLL.EQ.0) NLL=50 	IF(NCC.EQ.0) NCC=72 C	DETERMINE PLOTTING WIDTH C	FIND NUMBER OF MARKERS 	DO 90 J=19,139,10 	IF(J-NCC) 90,90,91  90	CONTINUE  91	NTOP=J/10 -1  	NCC=NTOP*10 - 9
 C	PRINT TITLE 
 20	TYPE 1, NO  C	FIND SCALE FOR BASE VARIABLE! 	XSCAL=(A(N)-A(1))/(FLOAT(NLL-1))   C	FIND SCALE FOR CROSS-VARIABLES 	M1=N+1  	M2=M*N  	YMIN=A(M1) 
 	YMAX=YMIN 	DO 40 J=M1,M2 	X=A(J)  	IF(X.LT.YMIN) YMIN=X  40	IF(X.GT.YMAX) YMAX=X ! 	YSCAL=(YMAX-YMIN)/(FLOAT(NCC-p                                                                                                                                   &                        0Ǉ $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]POLRG.FOR;1                                                                                       @                             >             1)) # C	FIND BASE VARIABLE PRINT POSITION  	XB=A(1) 	L=1 	MYX=M-1 	I=1 45	F=I-1 	XPR=XB+F*XSCAL  	IF(A(L)-XPR) 50,50,70 C	FIND CROSS VARIABLES 50	DO 55 IX=1,132 
 55	OUT(IX)=BL  	DO 56 IX=1,131,10 56	OUT(IX)=DIV 	DO 60 J=1,MYX	 	LL=L+J*N  	JP=((A(LL)-YMIN)/YSCAL)+1.0 60	OUT(JP)=BLANK(J+1)  C	PRINT LINE AND CLEAR OR SKIP 	TYPE 2, XPR,(OUT(IZ),IZ=1,NCC)  	L=L+1	 	GO TO 80  70	DO 71 IX=1,132 
 71	OUT(IX)=BL  	DO 72 IX=17,127,10  72	OUT(IX)=DIV 	NC17=NCC+17 	TYPE 4, (OUT(IZ),IZ=1,NC17) 80	I=I+1 	IF(I-NLL) 45,84,86  84	XPR=A(N) 	 	GO TO 50  C	PRINT CROSS-VARIABLES NUMBERS  86	IF(IFLAG) 87,88,87 
 88	IFLAG=1	 	GO TO 70  87	YPR(1)=YMIN 	NM2=NTOP-2  	DO 93 KN=1,NM2 ! 93	YPR(KN+1)=YPR(KN) + YSCAL*10.0  	YPR(NTOP)=YMAX  	TYPE 8, (YPR(I),I=1,NTOP) 	RETURN  	END                                                                                                                                                                                                                                                    ( * [STANVICK.SEAS$WORK_294000DB]POLRT.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 k@  7 @+\$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE POLRT  C  C        PURPOSED C           COMPUTES THE REAL AND COMPLEX ROOTS OF A REAL POLYNOMIAL C  C        USAGE2 C           CALL POLRT(XCOF,COF,M,ROOTR,ROOTI,IER) C " C        DESCRIPTION OF PARAMETERS> C           XCOF -VECTOR OF M+1 COEFFICIENTS OF THE POLYNOMIAL8 C                 ORDERED FROM SMALLEST TO LARGEST POWER. C           COF  -WORKING VECTOR OF LENGTH M+1% C           M    -ORDER OF POLYNOMIAL D C           ROOTR-RESULTANT VECTOR OF LENGTH M CONTAINING REAL ROOTS# C                 OF THE POLYNOMIAL = C           ROOTI-RESULTANT VECTOR OF LENGTH M CONTAINING THE A C                 CORRESPONDING IMAGINARY ROOTS OF THE POLYNOMIAL " C           IER  -ERROR CODE WHERE! C                 IER=0  NO ERROR ( C                 IER=1  M LESS THAN ONE* C                 IER=2  M GREATER THAN 36F C                 IER=3  UNABLE TO DETERMINE ROOT WITH 500 INTERATIONS- C                        ON 5 STARTING VALUES 7 C                 IER=4  HIGH ORDER COEFFICIENT IS ZERO  C  C        REMARKS5 C           LIMITED TO 36TH ORDER POLYNOMIAL OR LESS. < C           FLOATING POINT OVERFLOW MAY OCCUR FOR HIGH ORDERH C           POLYNOMIALS BUT WILL NOT AFFECT THE ACCURACY OF THE RESULTS. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           NEWTON-RAPHSON ITERATIVE TECHNIQUE.  THE FINAL ITERATIONS D C           ON EACH ROOT ARE PERFORMED USING THE ORIGINAL POLYNOMIALC C           RATHER THAN THE REDUCED POLYNOMIAL TO AVOID ACCUMULATED - C           ERRORS IN THE REDUCED POLYNOMIAL.  C H C     .................................................................. C 2       SUBROUTINE POLRT(XCOF,COF,M,ROOTR,ROOTI,IER)0       DIMENSION XCOF(1),COF(1),ROOTR(1),ROOTI(1)G       DOUBLE PRECISION XO,YO,X,Y,XPR,YPR,UX,UY,V,YT,XT,U,XT2,YT2,SUMSQ,       1 DX,DY,TEMP,ALPHA,DABS C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C + C     DOUBLE PRECISION XCOF,COF,ROOTR,ROOTI  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE. E C        THE DOUBLE PRECISION VERSION MAY BE MODIFIED BY CHANGING THE D C        CONSTANT IN STATEMENT 78 TO 1.0D-12 AND IN STATEMENT 122 TOD C        1.0D-10.  THIS WILL PROVIDE HIGHER PRECISION RESULTS AT THE C        COST OF EXECUTION TIME  C H C        ............................................................... C        IFIT=0	       N=M        IER=0        IF(XCOF(N+1))10,25,10     10 IF(N) 15,15,32 C  C        SET ERROR CODE TO 1 C     15 IER=1     20 RETURN C  C        SET ERROR CODE TO 4 C     25 IER=4        GO TO 20 C  C        SET ERROR CODE TO 2 C     30 IER=2        GO TO 20    32 IF(N-36) 35,35,30 
    35 NX=N
       NXX=N+1 
       N2=1       KJ1 = N+1        DO 40 L=1,KJ1        MT=KJ1-L+1    40 COF(MT)=XCOF(L)  C  C        SET INITIAL VALUES  C     45 XO=.00500101       YO=0.01000101  C # C        ZERO INITIAL VALUE COUNTER  C 
       IN=0
    50 X=XO C - C        INCREMENT INITIAL VALUES AND COUNTER  C        XO=-10.0*YO        YO=-10.0*X C % C        SET X AND Y TO CURRENT VALUE  C 
       X=XO
       Y=YO
       IN=IN+1        GO TO 59    55 IFIT=1       XPR=X        YPR=Y  C , C        EVALUATE POLYNOMIAL AND DERIVATIVES C     59 ICT=0     60 UX=0.0       UY=0.0       V =0.0       YT=0.0       XT=1.0       U=COF(N+1)       IF(U) 65,130,65     65 DO 70 I=1,N        L =N-I+1       TEMP=COF(L)        XT2=X*XT-Y*YT        YT2=X*YT+Y*XT        U=U+TEMP*XT2       V=V+TEMP*YT2
       FI=I       UX=UX+FI*XT*TEMP       UY=UY-FI*YT*TEMP       XT=XT2    70 YT=YT2       SUMSQ=UX*UX+UY*UY        IF(SUMSQ) 75,110,75     75 DX=(V*UY-U*UX)/SUMSQ       X=X+DX       DY=-(U*UY+V*UX)/SUMSQ        Y=Y+DY-    78 IF(DABS(DY)+DABS(DX)-1.0D-05) 100,80,80  C  C        STEP ITERATION COUNTER  C     80 ICT=ICT+1        IF(ICT-500) 60,85,85    85 IF(IFIT)100,90,100    90 IF(IN-5) 50,95,95  C  C        SET ERROR CODE TO 3 C     95 IER=3        GO TO 20   100 DO 105 L=1,NXX       MT=KJ1-L+1       TEMP=XCOF(MT)        XCOF(MT)=COF(L)    105 COF(L)=TEMP 
       ITEMP=N 
       N=NX       NX=ITEMP       IF(IFIT) 120,55,120    110 IF(IFIT) 115,50,115    115 X=XPR        Y=YPR    120 IFIT=0,   122 IF(DABS(Y)-1.0D-4*DABS(X)) 135,125,125   125 ALPHA=X+X        SUMSQ=X*X+Y*Y        N=N-2        GO TO 140    130 X=0.0 
       NX=NX-1        NXX=NXX-1    135 Y=0.0        SUMSQ=0.0 
       ALPHA=X        N=N-1     140 COF(2)=COF(2)+ALPHA*COF(1)   145 DO 150 L=2,N3   150 COF(L+1)=COF(L+1)+ALPHA*COF(L)-SUMSQ*COF(L-1)    155 ROOTI(N2)=Y        ROOTR(N2)=X 
       N2=N2+1        IF(SUMSQ) 160,165,160 
   160 Y=-Y       SUMSQ=0.0        GO TO 155    165 IF(N) 20,20,45	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ( * [STANVICK.SEAS$WORK_294000DB]POLY1.COM;1 +  , Y   .     /     4 ?       J                  - =    0   1    2   3      K  P   W   O     5 -  6  7@  7 `p$A  8          9          G    H  J                       ? $ COPY IN$:POLY1.FOR,PADDM.FOR,PDER.FOR,PDIV.FOR TMP$:TMPSSP.11 > $ COPY IN$:PINT.FOR,PMPY.FOR,PNORM.FOR,PVAL.FOR TMP$:TMPSSP.12- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                    ( * [STANVICK.SEAS$WORK_294000DB]POLY1.FOR;1 +  , Y   .     /     4 F                          - =    0   1    2   3      K  P   W   O     5 -  6 %@  7 ׃$A  8          9          G    H  J                       : C	POLY1.FTN - A PROGRAM TO TEST THE FOLLOWING SUBROUTINES:9 C  PADDM	- ADD A CONSTANT TIMES ONE POLYNOMIAL TO ANOTHER % C  PDER		- DERIVATIVE OF A POLYNOMIAL + C  PDIV		- DIVIDE ONE POLYNOMIAL BY ANOTHER . C  PINT		- INDEFINITE INTEGRAL OF A POLYNOMIAL# C  PMPY		- MULTIPLY TWO POLYNOMIALS ; C  PNORM	- NORMALIZE THE COEFFICIENT VECTOR OF A POLYNOMIAL   C  PVAL		- EVALUATE A POLYNOMIAL C 4 	DIMENSION F1(3),F2(4),F3(2),F4(5),F5(3),F6(4),F7(3) 	DIMENSION WORK1(10). C  F1(X)=12X**2+2, F2(X)=X**3+4X**2+4, F3(                                                                                                                                                                                                                                                                                                                                                                                                                  '                         $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]POLY1.FOR;1                                                                                       F                              }P             X)=X- 	DATA F1/2.,0.,12./,F2/4.,0.,4.,1./,F3/0.,1./  	TYPE 99< 99	FORMAT(//' F1(X)=12X**2+2, F2(X)=X**3+4X**2+4, F3(X)=X'/) C ' C	COMPUTE F4(X)=2*F3(X) * F2(X) + F1(X)  C  	CALL PMPY(WORK1,IW1,F2,4,F3,2) % 	CALL PADDM(F4,IF4,F1,3,2.,WORK1,IW1) 	 	TYPE 100 E 100	FORMAT(' F4(X)=2*F3(X)*F2(X)+F1(X)',3X,'(SHOULD BE 2*(X+1)**4)'/) 0 101	FORMAT(' COEFFICIENT OF X**',I1,' IS 'F10.4)
 	DO 1 I=1,IF4  	IM1=I-1 1	TYPE 101, IM1,F4(I)  C " C	COMPUTE F5(X) = F4(X) / (X+1)**2 C  	WORK1(1)=1  	WORK1(2)=2  	WORK1(3)=1 + 	CALL PDIV(F5,IF5,F4,IF4,WORK1,3,1.E-4,IER) 	 	TYPE 102 B 102	FORMAT(//' F5(X)=F4(X)/(X+1)**2',3X,' (SHOULD BE 2(X+1)**2)'/)
 	DO 2 I=1,IF5  	IM1=I-1 2	TYPE 101, IM1,F5(I) 	 	TYPE 103 . 103	FORMAT(/' REMAINDER POLYNOMIAL (IF ANY)'/)
 	DO 3 I=1,IF4  	IM1=I-1 3	TYPE 101, IM1,F4(I)  C , C	COMPUTE F6(X)=INDEFINITE INTEGRAL OF F5(X) C 	 	TYPE 104 F 104	FORMAT(//' F6(X)=INTEGRAL OF F5(X)',3X,'(SHOULD BE [2(X+1)**3]/3'/( 	1'      CONSTANT TERM SHOULD BE ZERO'/) 	CALL PINT(F6,IF6,F5,IF5) 
 	DO 4 I=1,IF6  	IM1=I-1 4	TYPE 101, IM1,F6(I)  C 4 C	COMPUTE AF6=DEFINITE INTEGRAL OF F5(X) FROM 1 TO 3 C  	CALL PVAL(AF6,3.,F6,IF6)  	CALL PVAL(TEMP,1.,F6,IF6) 	AF6 = AF6 - TEMP  	TYPE 105, AF68 105	FORMAT(//' AF6=DEFINITE INTEGRAL OF F5(X) ON [1,3]'/ 	1'    VALUE IS',E16.7)  C  C	COMPUTE DERIVATIVE OF F2(X)  C 	 	TYPE 106 , 106	FORMAT(//' DERIVATIVE OF X**3+4X**2+4'/) 	CALL PDER(F7,IF7,F2,4) 
 	DO 5 I=1,IF7  	IM1=I-1 5	TYPE 101, IM1,F7(I)  	STOP 'POLY1 successful!'  	END                                          ( * [STANVICK.SEAS$WORK_294000DB]POLY2.COM;1 +  , Y   .     /     4 H                         - =    0   1    2   3      K  P   W   O     5 -  6 @}@  7 A$A  8          9          G    H  J                       H $ COPY IN$:POLY2.FOR,PADD.FOR,PADDM.FOR,PCLA.FOR,PCLD.FOR TMP$:TMPSSP.11G $ COPY IN$:PILD.FOR,PMPY.FOR,PQSD.FOR,PSUB.FOR,PVSUB.FOR TMP$:TMPSSP.12 5 $ COPY IN$:PNORM.FOR,PGCD.FOR,PDIV.FOR TMP$:TMPSSP.13 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 - $ FORTRAN/OBJECT=TMP$:TMPSSP.3 TMP$:TMPSSP.13 ? $ LINK/EXECUTABLE=TMP$:TMPSSP.4 TMP$:TMPSSP.1,TMPSSP.2,TMPSSP.3  $ RUN TMP$:TMPSSP.4  $ DELETE TMP$:TMPSSP.*;*                                                                ( * [STANVICK.SEAS$WORK_294000DB]POLY2.FOR;1 +  , Y   .     /     4 @       
                   - =    0   1    2   3      K  P   W   O     5 -  6  A  7 $$A  8          9          G    H  J           
            1 C	POLY2.FTN - SAMPLE POLYNOMIAL OPERATIONS USING:  C  PADD		- ADD TWO POLYNOMIALS$ C  PCLD		- LINEAR SYNTHETIC DIVISION! C  PGCD		- GCD OF TWO POLYNOMIALS  C	CALLS PNORM, PDIV % C  PVSUB	- COMPOSITION OF POLYNOMIALS  C	CALLS PMPY,PADDM,PCLA % C  PSUB		- SUBTRACTION OF POLYNOMIALS 7 C  PILD		- EVALUATE POLYNOMIAL AND ITS FIRST DERIVATIVE  C	CALLS PQSD C  C	REVISED 10-OCT-85 S. JAIN @ C	  MODIFY CALL TO PGCD SO THAT A DUMMY VARIABLE IS USED INSTEAD@ C	  OF A CONSTANT AS THE IDIMX ARGUMENT SINCE THE IDIMX ARGUMENT C	  IS MODIFIED UPON RETURN. C . 	DIMENSION P1(4),P2(3),P3(3),P6(4),W1(5),W2(5)5 	DATA P1/-72.,-9.,2.,1./,P2/26.,-2.,6./,P3/6.,-8.,8./  C 	 	TYPE 100 3 100	FORMAT(//' ADDING THE FOLLOWING POLYNOMIALS:'/) " 	TYPE 101, P1(4),P1(3),P1(2),P1(1)3 101	FORMAT(10X,'(',F5.1,')X**3 +(',F5.1,')X**2 +(',  	1F5.1,')X +(',F5.1,')'/)  	TYPE 102, P2(3),P2(2),P2(1): 102	FORMAT(23X,'(',F5.1,')X**2 +(',F5.1,')X +(',F5.1,')'/) 	CALL PADD(P1,IP1,P1,4,P2,3)	 	TYPE 103  103	FORMAT(' SUM IS:'/) " 	TYPE 101, P1(4),P1(3),P1(2),P1(1)	 	TYPE 104 4 104	FORMAT(//' SUBTRACT THE FOLLOWING POLYNOMIAL:'/) 	TYPE 102, P3(3),P3(2),P3(1) 	CALL PSUB(P1,IP1,P1,4,P3,3)	 	TYPE 105  105	FORMAT(/' RESULT IS:'/) " 	TYPE 101, P1(4),P1(3),P1(2),P1(1) C 
 C	COMPOSITION 	 	P2(1)=2. 	 	P2(2)=1. 	 	TYPE 106 ) 106	FORMAT(/' NOW PRECOMPOSE WITH X+2:'/) # 	CALL PVSUB(P6,IP6,P1,4,P2,2,W1,W2) 	 	TYPE 105 " 	TYPE 101, P6(4),P6(3),P6(2),P6(1)	 	TYPE 107 1 107	FORMAT(/' TRANSLATING INTO FACTORS OF X-2:'/)  	CALL PCLD(P6,4,2.) 	 	TYPE 105 " 	TYPE 101, P6(4),P6(3),P6(2),P6(1)
 	P1(1)=45.
 	P1(2)=12.	 	P1(3)=1. 	 	TYPE 108 @ 108	FORMAT(//' G.C.D. OF ABOVE POLYNOMIAL AND X**2+12X+45 IS:'/) 	IP1=3& C*	CALL PGCD(P6,4,P1,IP1,W1,1.E-2,IER) 	IDUMMY=4				!** SJ / 	CALL PGCD(P6,IDUMMY,P1,IP1,W1,1.E-2,IER)!** SJ 	 	TYPE 105  	TYPE 102, P1(3),P1(2),P1(1) C $ C	EVALUATE POLYNOMIAL AND DERIVATIVE 	CALL PILD(PV,DV,-6.,P1,3) 	TYPE 109, PV,DV/ 109	FORMAT(/' THE FUNCTION AT X=-6 EQUALS'F8.3/ ' 	1' ITS DERIVATIVE AN X=-6 EQUALS'F8.3)  	STOP 'POLY2 successful!'  	END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ' * [STANVICK.SEAS$WORK_294000DB]PQSD.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 jA  7  $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PQSD C  C        PURPOSE0 C           PERFORM QUADRATIC SYNTHETIC DIVISION C  C        USAGE& C           CALL PQSD(A,B,P,Q,X,IDIMX) C " C        DESCRIPTION OF PARAMETERS> C           A     - COEFFICIENT OF Z IN REMAINDER (CALCULATED); C           B     - CONSTANT TERM IN REMAINDER (CALCULATED) < C           P     - COEFFICIENT OF Z IN QUADRATIC POLYNOMIAL9 C           Q     - CONSTANT TERM IN QUADRATIC POLYNOMIAL D C           X     - COEFFICIENT VECTOR FOR GIVEN POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER" C           IDIMX - DIMENSION OF X C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           POLYNOMIAL IS DIVIDED BY THE QUADRATIC Z**2-P*Z-Q GIVING& C           THE LINEAR REMAINDER A*Z+B C H C     .................................................................. C &       SUBROUTINE PQSD(A,B,P,Q,X,IDIMX)       DIMENSION X(1) C 
       A=0.
       B=0.
       J=IDIMX      1 IF(J)3,3,2
     2 Z=P*A+B        B=Q*A+X(J)	       A=Z        J=J-1 
       GO TO 1      3 RETURN	       END                                                                                                                                                                                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]PSUB.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6  GA  7  $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PSUB C  C        PURPOSE0 C           SUBTRACT ONE POLYNOMIAL FROM ANOTHER C  C        USAGE. C           CALL PSUB(Z,IDIMZ,X,IDIMX,Y,IDIMY) C " C        DESCRIPTION OF PARAMETERSB C           Z     - VECTOR OF RESULTANT COEFFICIENTS, ORDERED FROM- C                   SMALLEST TO LARGEST POWER / C           IDIMZ - DIMENSION OF Z (CALCULATED) H C           X     - VECTOR OF COEFFICIENTS FOR FIRST POLYNOMIAL, ORDERED2 C                   FROM SMALLEST TO LARGEST POWER6 C           IDIMX - DIMENSION OF X (DEGREE IS IDIMX-1)A C           Y     - VECTOR OF COEFFICIENTS FOR SECOND POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER6 C           IDIMY - DIMENSION OF Y (DEGREE IS IDIMY-1) C  C        REMARKSB C           VECTOR Z MAY BE IN SAME LOCATION AS EITHER VECTOR X ORE C           VECTOR Y ONLY IF THE DIMENSION OF THAT VECTOR IS NOT LESS ' C           THAN THE OTHER INPUT VECTOR H C           THE RESULTANT POLYNOMIAL MAY HAVE TRAILING ZERO COEFFICIENTS C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           DIMENSION OF RESULTANT VECTOR IDIMZ IS CALCULATED AS THEF C           LARGER OF THE TWO INPUT VECTOR DIMENSIONS. COEFFICIENTS INH C           VECTOR Y ARE THEN SUBTRACTED FROM CORRESPONDING COEFFICIENTS C           IN VECTOR X. C H C     .................................................................. C .       SUBROU`                                                                                                                   (                        ӏ  $      RTI020.J                       Y  =  '[STANVICK.SEAS$WORK_294000DB]PSUB.FOR;1                                                                                        H                              F	             TINE PSUB(Z,IDIMZ,X,IDIMX,Y,IDIMY)       DIMENSION Z(1),X(1),Y(1) C ! C     TEST DIMENSIONS OF SUMMANDS  C        NDIM=IDIMX       IF (IDIMX-IDIMY) 10,20,20     10 NDIM=IDIMY    20 IF (NDIM) 90,90,30    30 DO 80 I=1,NDIM       IF (I-IDIMX) 40,40,60     40 IF (I-IDIMY) 50,50,70     50 Z(I)=X(I)-Y(I)       GO TO 80    60 Z(I)=-Y(I)       GO TO 80    70 Z(I)=X(I)     80 CONTINUE    90 IDIMZ=NDIM       RETURN	       END                                                                                         ' * [STANVICK.SEAS$WORK_294000DB]PVAL.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  A  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE PVAL C  C        PURPOSEC C           EVALUATE A POLYNOMIAL FOR A GIVEN VALUE OF THE VARIABLE  C  C        USAGE& C           CALL PVAL(RES,ARG,X,IDIMX) C " C        DESCRIPTION OF PARAMETERS2 C           RES    - RESULTANT VALUE OF POLYNOMIAL0 C           ARG    - GIVEN VALUE OF THE VARIABLEE C           X      - VECTOR OF COEFFICIENTS, ORDERED FROM SMALLEST TO " C                    LARGEST POWER# C           IDIMX  - DIMENSION OF X  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD @ C           EVALUATION IS DONE BY MEANS OF NESTED MULTIPLICATION C H C     .................................................................. C &       SUBROUTINE PVAL(RES,ARG,X,IDIMX)       DIMENSION X(1) C        RES=0.
       J=IDIMX      1 IF(J)3,3,2     2 RES=RES*ARG+X(J)       J=J-1 
       GO TO 1      3 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         ( * [STANVICK.SEAS$WORK_294000DB]PVSUB.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 @A  7 @$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE PVSUB  C  C        PURPOSEE C           SUBSTITUTE VARIABLE OF A POLYNOMIAL BY ANOTHER POLYNOMIAL  C  C        USAGE; C           CALL PVSUB(Z,IDIMZ,X,IDIMX,Y,IDIMY,WORK1,WORK2)  C " C        DESCRIPTION OF PARAMETERSD C           Z     - VECTOR OF COEFFICIENTS FOR RESULTANT POLYNOMIAL,: C                   ORDERED FROM SMALLEST TO LARGEST POWER" C           IDIMZ - DIMENSION OF ZC C           X     - VECTOR OF COEFFICIENTS FOR ORIGINAL POLYNOMIAL, : C                   ORDERED FROM SMALLEST TO LARGEST POWER" C           IDIMX - DIMENSION OF XB C           Y     - VECTOR OF COEFFICIENTS FOR POLYNOMIAL WHICH ISF C                   SUBSTITUTED FOR VARIABLE, ORDERED FROM SMALLEST TO! C                   LARGEST POWER " C           IDIMY - DIMENSION OF Y? C           WORK1 - WORKING STORAGE ARRAY (SAME DIMENSION AS Z) ? C           WORK2 - WORKING STORAGE ARRAY (SAME DIMENSION AS Z)  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           PMPY C           PADDM  C           PCLA C  C        METHOD C C           VARIABLE OF POLYNOMIAL X IS SUBSTITUTED BY POLYNOMIAL Y @ C           TO FORM POLYNOMIAL Z. DIMENSION OF NEW POLYNOMIAL ISE C           (IDIMX-1)*(IDIMY-1)+1. SUBROUTINE REQUIRES TWO WORK AREAS  C H C     .................................................................. C ;       SUBROUTINE PVSUB(Z,IDIMZ,X,IDIMX,Y,IDIMY,WORK1,WORK2) 0       DIMENSION Z(1),X(1),Y(1),WORK1(1),WORK2(1) C  C     TEST OF DIMENSIONS C        IF (IDIMX-1) 1,3,3
     1 IDIMZ=0      2 RETURN C 
     3 IDIMZ=1        Z(1)=X(1) "       IF (IDIMY*IDIMX-IDIMY) 2,2,4     4 IW1=1        WORK1(1)=1.  C        DO 5 I=2,IDIMX,       CALL PMPY(WORK2,IW2,Y,IDIMY,WORK1,IW1)$       CALL PCLA(WORK1,IW1,WORK2,IW2)       FACT=X(I) 0       CALL PADDM(Z,IDIMR,Z,IDIMZ,FACT,WORK1,IW1)       IDIMZ=IDIMR      5 CONTINUE
       GO TO 2 	       END                                         ' * [STANVICK.SEAS$WORK_294000DB]QATR.FOR;1 +  , Y   . 	    /     4 H   	                       - =    0   1    2   3      K  P   W   O 	    5 -  6 A  7 `$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE QATR C  C        PURPOSEC C           TO COMPUTE AN APPROXIMATION FOR INTEGRAL(FCT(X), SUMMED " C           OVER X FROM XL TO XU). C  C        USAGE4 C           CALL QATR (XL,XU,EPS,NDIM,FCT,Y,IER,AUX)9 C           PARAMETER FCT REQUIRES AN EXTERNAL STATEMENT.  C " C        DESCRIPTION OF PARAMETERS5 C           XL     - THE LOWER BOUND OF THE INTERVAL. 5 C           XU     - THE UPPER BOUND OF THE INTERVAL. ; C           EPS    - THE UPPER BOUND OF THE ABSOLUTE ERROR. F C           NDIM   - THE DIMENSION OF THE AUXILIARY STORAGE ARRAY AUX.B C                    NDIM-1 IS THE MAXIMAL NUMBER OF BISECTIONS OF* C                    THE INTERVAL (XL,XU).G C           FCT    - THE NAME OF THE EXTERNAL FUNCTION SUBPROGRAM USED. H C           Y      - THE RESULTING APPROXIMATION FOR THE INTEGRAL VALUE.1 C           IER    - A RESULTING ERROR PARAMETER. D C           AUX    - AN AUXILIARY STORAGE ARRAY WITH DIMENSION NDIM. C  C        REMARKS> C           ERROR PARAMETER IER IS CODED IN THE FOLLOWING FORMD C           IER=0  - IT WAS POSSIBLE TO REACH THE REQUIRED ACCURACY. C                    NO ERROR.D C           IER=1  - IT IS IMPOSSIBLE TO REACH THE REQUIRED ACCURACY0 C                    BECAUSE OF ROUNDING ERRORS.E C           IER=2  - IT WAS IMPOSSIBLE TO CHECK ACCURACY BECAUSE NDIM G C                    IS LESS THAN 5, OR THE REQUIRED ACCURACY COULD NOT C C                    BE REACHED WITHIN NDIM-1 STEPS. NDIM SHOULD BE  C                    INCREASED.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDD C           THE EXTERNAL FUNCTION SUBPROGRAM FCT(X) MUST BE CODED BY= C           THE USER. ITS ARGUMENT X SHOULD NOT BE DESTROYED.  C  C        METHOD C C           EVALUATION OF Y IS DONE BY MEANS OF TRAPEZOIDAL RULE IN D C           CONNECTION WITH ROMBERGS PRINCIPLE. ON RETURN Y CONTAINSE C           THE BEST POSSIBLE APPROXIMATION OF THE INTEGRAL VALUE AND = C           VECTOR AUX THE UPWARD DIAGONAL OF ROMBERG SCHEME. E C           COMPONENTS AUX(I) (I=1,2,...,IEND, WITH IEND LESS THAN OR G C           EQUAL TO NDIM) BECOME APPROXIMATIONS TO INTEGRAL VALUE WITH ? C           DECREASING ACCURACY BY MULTIPLICATION WITH (XU-XL).  C           FOR REFERENCE, SEED C           (1) FILIPPI, DAS VERFAHREN VON ROMBERG-STIEFEL-BAUER ALSD C               SPEZIALFALL DES ALLGEMEINEN PRINZIPS VON RICHARDSON,D C               MATHEMATIK-TECHNIK-WIRTSCHAFT, VOL.11, ISS.2 (1964), C               PP.49-54. G C           (2) BAUER, ALGORITHM 60, CACM, VOL.4, ISS.6 (1961), PP.255.  C H C     .................................................................. C 3       SUBROUTINE QATR(XL,XU,EPS,NDIM,FCT,Y,IER,AUX)  C  C        DIMENSION AUX(1) C " C     PREPARATIONS OF ROMBERG-LOOP!       AUX(1)=.5*(FCT(XL)+FCT(XU)) 
       H=XU-XL        IF(NDIM-1)8,8,1      1 IF(H)2,10,2  C 5 C     NDIM IS GREATER THAN 1 AND H IS NOT EQUAL TO 0. 
     2 HH=H       E=EPS/ABS(H)       DELT2=0.
       P=1.
       JJ=1       DO 7 I=2,NDIM        Y=AUX(1)       DELT1=DELT2        HD=HH        HH=.5*HH       P=.5*P
       X=XL+HH        SM=0.        DO 3 J=1,JJ        SM=SM+FCT(X)     3 X=X+HD       AUX(I)=.5*AUX(I-1)+P*SM C C     A NEW APPROXIMATION OF INTEGRAL VALUE IS COMPUTED BY MEANS OF  C     TRAPEZOIDAL RULE.  C - C     START OF ROMBERGS EXTRAPOLATION METHOD. 
       Q=1.       JI=I-1       DO 4 J=1,JI        II=I-J       Q=Q+Q        Q=Q+Q 2     4 AUX(II)=AUX(II+1)+(AUX(II+1)-AUX(II))/(Q-1                                                                                                                                                                                                                                                                                                                                                                                                                  )                        "GS $      RTI020.J                       Y  =  '[STANVICK.SEAS$WORK_294000DB]QATR.FOR;1                                                                                        H     	                                      .) C     END OF ROMBERG-STEP  C        DELT2=ABS(Y-AUX(1))        IF(I-5)7,5,5     5 IF(DELT2-E)10,10,6     6 IF(DELT2-DELT1)7,11,11     7 JJ=JJ+JJ     8 IER=2      9 Y=H*AUX(1)       RETURN    10 IER=0 
       GO TO 9     11 IER=1        Y=H*Y        RETURN	       END                                                                                                                                                                                                                                                   ( * [STANVICK.SEAS$WORK_294000DB]QDINT.COM;1 +  , Y   .     /     4 -                          - =    0   1    2   3      K  P   W   O     5 -  6 @Y@  7  D0$A  8          9          G    H  J                       + $ COPY IN$:QDINT.FOR,QSF.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                                ( * [STANVICK.SEAS$WORK_294000DB]QDINT.DAT;1 +  , Y   .     /     4 F       j                   - =    0   1    2   3      K  P   W   O     5 -  6 A  7 @D$A  8          9          G    H  J                        12345   20       1.0F        2.0       2.0       2.0       2.0       2.0       2.0       2.0F        2.0       2.0       2.0       2.0       2.0       2.0       2.0<        2.0       2.0       2.0       2.0       2.0       2.0   543   10       1.0F        1.0       2.0       3.0       4.0       5.0       6.0       7.0        8.0       9.0      10.0                                                                                                                                                                           ( * [STANVICK.SEAS$WORK_294000DB]QDINT.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 ͇A  7 `W$A  8          9          G    H  J                       H C  QDINT.FTN - SAMPLE PROGRAM FOR INTEGRATION OF A TABULATED FUNCTION BY0 C	NUMERICAL QUADRATURE USING THE SUBROUTINE  QSF@ C	THE FOLLOWING DIMENSION MUST BE AS LARGE AS THE MAXIMUM NUMBER& C	OF TABULATED VALUES TO BE INTEGRATED 	DIMENSION Z(500)  10	FORMAT(2I5,F10.0)C 20	FORMAT(////' INTEGRATION OF TABULATED VALUES FOR DY/DX USING SUB > 	1ROUTINE QSF'///11H FUNCTION  ,I5,3X,I5,17H TABULATED VALUES, 	25X,10HINTERVAL =,E15.8/)" 22	FORMAT(/18H ILLEGAL CONDITION/)= 23	FORMAT(/46H NUMBER OF TABULATED VALUES IS LESS THAN THREE) * 24	FORMAT(/27H WPECIFIED INTERVAL IS ZERO)= 30	FORMAT(/7X,'RESULTANT VALUE OF INTEGRAL AT EACH STEP IS',/  	1(1H ,5E15.8))  32	FORMAT(7F10.0)  C  C	INPUT CHANNEL = IN 	IN = 1  C 7 	OPEN (UNIT=1,NAME='IN$:QDINT.DAT',TYPE='OLD',READONLY)  35	READ(IN,10) ICOD,NUMBR,SPACE  	IF(ICOD+NUMBR) 70,70,38 70	STOP 'QDINT successful!'  38	TYPE 20, ICOD,NUMBR,SPACE 	IF(NUMBR-3) 100,50,50 50	READ(IN,32)(Z(I),I=1,NUMBR) 	CALL QSF(SPACE,Z,Z,NUMBR) 	IF(SPACE) 60,200,60 60	TYPE 30, (Z(I),I=1,NUMBR)	 	GO TO 35  100	TYPE 22  	TYPE 23 	READ(IN,32) (Z(I),I=1,NUMBR) 	 	GO TO 35  200	TYPE 22  	TYPE 24	 	GO TO 35  	END                                                                                                                                                                                                                                                                                                                                                                                                          & * [STANVICK.SEAS$WORK_294000DB]QSF.FOR;1 +  , Y   . 	    /     4 H   	                       - =    0   1    2   3      K  P   W   O     5 -  6 @m]A  7 ?j$A  8          9          G    H  J                          C H C     .................................................................. C  C        SUBROUTINE QSF  C  C        PURPOSE@ C           TO COMPUTE THE VECTOR OF INTEGRAL VALUES FOR A GIVEN1 C           EQUIDISTANT TABLE OF FUNCTION VALUES.  C  C        USAGE! C           CALL QSF (H,Y,Z,NDIM)  C " C        DESCRIPTION OF PARAMETERS6 C           H      - THE INCREMENT OF ARGUMENT VALUES.9 C           Y      - THE INPUT VECTOR OF FUNCTION VALUES. F C           Z      - THE RESULTING VECTOR OF INTEGRAL VALUES. Z MAY BE& C                    IDENTICAL WITH Y.6 C           NDIM   - THE DIMENSION OF VECTORS Y AND Z. C  C        REMARKS/ C           NO ACTION IN CASE NDIM LESS THAN 3.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           BEGINNING WITH Z(1)=0, EVALUATION OF VECTOR Z IS DONE BYF C           MEANS OF SIMPSONS RULE TOGETHER WITH NEWTONS 3/8 RULE OR AB C           COMBINATION OF THESE TWO RULES. TRUNCATION ERROR IS OFF C           ORDER H**5 (I.E. FOURTH ORDER METHOD). ONLY IN CASE NDIM=36 C           TRUNCATION ERROR OF Z(2) IS OF ORDER H**4. C           FOR REFERENCE, SEEC C           (1) F.B.HILDEBRAND, INTRODUCTION TO NUMERICAL ANALYSIS, E C               MCGRAW-HILL, NEW YORK/TORONTO/LONDON, 1956, PP.71-76. E C           (2) R.ZURMUEHL, PRAKTISCHE MATHEMATIK FUER INGENIEURE UND G C               PHYSIKER, SPRINGER, BERLIN/GOETTINGEN/HEIDELBERG, 1963,  C               PP.214-221.  C H C     .................................................................. C         SUBROUTINE QSF(H,Y,Z,NDIM) C  C        DIMENSION Y(1),Z(1)  C        HT=.3333333*H        IF(NDIM-5)7,8,1  C > C     NDIM IS GREATER THAN 5. PREPARATIONS OF INTEGRATION LOOP     1 SUM1=Y(2)+Y(2)       SUM1=SUM1+SUM1       SUM1=HT*(Y(1)+SUM1+Y(3))       AUX1=Y(4)+Y(4)       AUX1=AUX1+AUX1#       AUX1=SUM1+HT*(Y(3)+AUX1+Y(5)) =       AUX2=HT*(Y(1)+3.875*(Y(2)+Y(5))+2.625*(Y(3)+Y(4))+Y(6))        SUM2=Y(5)+Y(5)       SUM2=SUM2+SUM2#       SUM2=AUX2-HT*(Y(4)+SUM2+Y(6)) 
       Z(1)=0.        AUX=Y(3)+Y(3)        AUX=AUX+AUX "       Z(2)=SUM2-HT*(Y(2)+AUX+Y(4))       Z(3)=SUM1        Z(4)=SUM2        IF(NDIM-6)5,5,2  C  C     INTEGRATION LOOP     2 DO 4 I=7,NDIM,2        SUM1=AUX1        SUM2=AUX2        AUX1=Y(I-1)+Y(I-1)       AUX1=AUX1+AUX1%       AUX1=SUM1+HT*(Y(I-2)+AUX1+Y(I))        Z(I-2)=SUM1        IF(I-NDIM)3,6,6      3 AUX2=Y(I)+Y(I)       AUX2=AUX2+AUX2'       AUX2=SUM2+HT*(Y(I-1)+AUX2+Y(I+1))      4 Z(I-1)=SUM2      5 Z(NDIM-1)=AUX1       Z(NDIM)=AUX2       RETURN     6 Z(NDIM-1)=SUM2       Z(NDIM)=AUX1       RETURN C     END OF INTEGRATION LOOP  C      7 IF(NDIM-3)12,11,8  C  C     NDIM IS EQUAL TO 4 OR 5 =     8 SUM2=1.125*HT*(Y(1)+Y(2)+Y(2)+Y(2)+Y(3)+Y(3)+Y(3)+Y(4))        SUM1=Y(2)+Y(2)       SUM1=SUM1+SUM1       SUM1=HT*(Y(1)+SUM1+Y(3))
       Z(1)=0.        AUX1=Y(3)+Y(3)       AUX1=AUX1+AUX1#       Z(2)=SUM2-HT*(Y(2)+AUX1+Y(4))        IF(NDIM-5)10,9,9     9 AUX1=Y(4)+Y(4)       AUX1=AUX1+AUX1#       Z(5)=SUM1+HT*(Y(3)+AUX1+Y(5))     10 Z(3)=SUM1        Z(4)=SUM2        RETURN C  C     NDIM IS EQUAL TO 3,    11 SUM1=HT*(1.25*Y(1)+Y(2)+Y(2)-.25*Y(3))       SUM2=Y(2)+Y(2)       SUM2=SUM2+SUM2       Z(3)=HT*(Y(1)+SUM2+Y(3))
       Z(1)=0.        Z(2)=SUM1     12 RETURN	       END                                                                                                                                                                                                                                                 ( * [STANVICK.SEAS$WORK_294000DB]QTEST.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  XA  7 {$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE QTEST  C  C        PURPOSED C           TEST WHETHER THREE OR MORE MATCHED GROUPS OF DICHOTOMOUS; C           DATA DIFFER SIGNIFICANTLY BY THE COCHRAN Q-TEST  C  C        USAGE# C           CALL QTEST(A,N,M,Q,NDF)  C " C        DESCRIPTION OF PARAMETERSE C           A   - INPUT MATRIX, N BY M, OF DICHOTOMOUS DATA (0 AND 1) . C           N   - NUMBER OF SETS IN EACH GROUP" C           M   - NUMBER OF @                                                                                                                                                                                                                                                                                                                                                  *                        n| $      RTI020.J                       Y  =  ([STANVICK.SEAS$WORK_294000DB]QTEST.FOR;1                                                                                       H                                           GROUPS. C           Q   - COCHRAN Q STATISTIC (OUTPUT)7 C           NDF - NUMBER OF DEGREES OF FREEDOM (OUTPUT)  C  C        REMARKS& C           M MUST BE THREE OR GREATER C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956, C           CHAPTER 7  C H C     .................................................................. C #       SUBROUTINE QTEST(A,N,M,Q,NDF)        DIMENSION A(1) C F C        COMPUTE SUM OF SQUARES OF ROW TOTALS, RSQ, AND GRAND TOTAL OF C        ALL ELEMENTS, GD  C 
       RSQ=0.0        GD=0.0       DO 20 I=1,N        TR=0.0       IJ=I-N       DO 10 J=1,M 
       IJ=IJ+N     10 TR=TR+A(IJ)        GD=GD+TR    20 RSQ=RSQ+TR*TR  C 5 C        COMPUTE SUM OF SQUARES OF COLUMN TOTALS, CSQ  C 
       CSQ=0.0 
       IJ=0       DO 40 J=1,M        TC=0.0       DO 30 I=1,N 
       IJ=IJ+1     30 TC=TC+A(IJ)     40 CSQ=CSQ+TC*TC  C % C        COMPUTE COCHRAN Q TEST VALUE  C 
       FM=M+       Q=(FM-1.0)*(FM*CSQ-GD*GD)/(FM*GD-RSQ)  C   C        FIND DEGREES OF FREEDOM C 
       NDF=M-1        RETURN	       END                                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]RADD.FOR;1 +  , Y   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 `e	A  7 @X$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RADD C  C        PURPOSE: C           ADD ROW OF ONE MATRIX TO ROW OF ANOTHER MATRIX C  C        USAGE+ C           CALL RADD(A,IRA,R,IRR,N,M,MS,L)  C " C        DESCRIPTION OF PARAMETERS& C           A   - NAME OF INPUT MATRIXD C           IRA - ROW IN MATRIX A TO BE ADDED TO ROW IRR OF MATRIX R' C           R   - NAME OF OUTPUT MATRIX > C           IRR - ROW IN MATRIX R WHERE SUMMATION IS DEVELOPED% C           N   - NUMBER OF ROWS IN A . C           M   - NUMBER OF COLUMNS IN A AND R? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL % C           L   - NUMBER OF ROWS IN R  C  C        REMARKS- C           MATRIX R MUST BE A GENERAL MATRIX F C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A UNLESS C           A IS GENERAL C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD ; C           EACH ELEMENT OF ROW IRA OF MATRIX A IS ADDED TO 8 C           CORRESPONDING ELEMENT OF ROW IRR OF MATRIX R C H C     .................................................................. C +       SUBROUTINE RADD(A,IRA,R,IRR,N,M,MS,L)        DIMENSION A(1),R(1)  C        IR=IRR-L       DO 2 J=1,M
       IR=IR+L  C 9 C        LOCATE INPUT ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(IRA,J,IA,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IA) 1,2,1 C  C        ADD ELEMENTS  C      1 R(IR)=R(IR)+A(IA)      2 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                         ' * [STANVICK.SEAS$WORK_294000DB]RANK.FOR;1 +  , Y   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 G
A  7 ;$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RANK C  C        PURPOSE# C           RANK A VECTOR OF VALUES  C  C        USAGE C           CALL RANK(A,R,N) C " C        DESCRIPTION OF PARAMETERS( C           A - INPUT VECTOR OF N VALUESF C           R - OUTPUT VECTOR OF LENGTH N. SMALLEST VALUE IS RANKED 1,F C               LARGEST IS RANKED N. TIES ARE ASSIGNED AVERAGE OF TIED C               RANKS   C           N - NUMBER OF VALUES C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           VECTOR IS SEARCHED FOR SUCCESSIVELY LARGER ELEMENTS. IF TIESB C           OCCUR, THEY ARE LOCATED AND THEIR RANK VALUE COMPUTED.F C           FOR EXAMPLE, IF 2 VALUES ARE TIED FOR SIXTH RANK, THEY ARE- C           ASSIGNED A RANK OF 6.5 (=(6+7)/2)  C H C     .................................................................. C        SUBROUTINE RANK(A,R,N)       DIMENSION A(1),R(1)  C  C        INITIALIZATION  C        DO 10 I=1,N     10 R(I)=0.0 C  C        FIND RANK OF DATA C        DO 100 I=1,N C 2 C        TEST WHETHER DATA POINT IS ALREADY RANKED C        IF(R(I)) 20, 20, 100 C   C        DATA POINT TO BE RANKED C     20 SMALL=0.0        EQUAL=0.0        X=A(I)       DO 50 J=1,N        IF(A(J)-X) 30, 40, 50 6 C        COUNT NUMBER OF DATA POINTS WHICH ARE SMALLER C  C     30 SMALL=SMALL+1.0        GO TO 50 C 4 C        COUNT NUMBER OF DATA POINTS WHICH ARE EQUAL C     40 EQUAL=EQUAL+1.0        R(J)=-1.0     50 CONTINUE C  C        TEST FOR TIE  C        IF(EQUAL-1.0) 60, 60, 70 C . C        STORE RANK OF DATA POINT WHERE NO TIE C     60 R(I)=SMALL+1.0       GO TO 100  C + C        CALCULATE RANK OF TIED DATA POINTS  C !    70 P=SMALL + (EQUAL + 1.0)*0.5        DO 90 J=I,N        IF(R(J)+1.0) 90, 80, 90     80 R(J)=P    90 CONTINUE   100 CONTINUE       RETURN	       END                                                                 ' * [STANVICK.SEAS$WORK_294000DB]RCPY.FOR;1 +  , Y   .     /     4 H       Z                   - =    0   1    2   3      K  P   W   O     5 -  6 @!A  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RCPY C  C        PURPOSE8 C           COPY SPECIFIED ROW OF A MATRIX INTO A VECTOR C  C        USAGE$ C           CALL RCPY (A,L,R,N,M,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX) C           L - ROW OF A TO BE MOVED TO R 1 C           R - NAME OF OUTPUT VECTOR OF LENGTH M # C           N - NUMBER OR ROWS IN A & C           M - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD B C           ELEMENTS OF ROW L ARE MOVED TO CORRESPONDING POSITIONS C           OF VECTOR R  C H C     .................................................................. C #       SUBROUTINE RCPY(A,L,R,N,M,MS)        DIMENSION A(1),R(1)  C        DO 3 J=1,M C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(L,J,LJ,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(LJ) 1,2,1 C  C        MOVE ELEMENT TO R C      1 R(J)=A(LJ)
       GO TO 3      2 R(J)=0.0     3 CONTINUE       RETURN	       END                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]RCUT.FOR;1 +  , Y   .     /     4 H       ~                    - =    0   1    2   3      K  P   W   O     5 -  6 `A  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RCUT C  C        PURPOSEA C           PARTITION A MATRIX BETWEEN SPECIFIED ROWS TO FORM TWO  C           RESULTANT MATRICES C  C        USAGE& C           CALL RCUT (A,L,R,S,N,M,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX= C           L - ROW OF A ABOVE WHICH PARTITIONING TAKES PLACE C C           R - NAME OF MATRIX TO BE FORMED FROM UPPER PORTION OF A C C       `                                                                                                                   +                        K $      RTI020.J                       Y  =  '[STANVICK.SEAS$WORK_294000DB]RCUT.FOR;1                                                                                        H                              T                 S - NAME OF MATRIX TO BE FORMED FROM LOWER PORTION OF A # C           N - NUMBER OF ROWS IN A & C           M - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS; C           MATRIX R CANNOT BE IN SAME LOCATION AS MATRIX A ; C           MATRIX S CANNOT BE IN SAME LOCATION AS MATRIX A ; C           MATRIX R CANNOT BE IN SAME LOCATION AS MATRIX S = C           MATRIX R AND MATRIX S ARE ALWAYS GENERAL MATRICES  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD G C           ELEMENTS OF MATRIX A ABOVE ROW L ARE MOVED TO FORM MATRIX R D C           OF L-1 ROWS AND M COLUMNS. ELEMENTS OF MATRIX A IN ROW LD C           AND BELOW ARE MOVED TO FORM MATRIX S OF N-L+1 ROWS AND M C           COLUMNS  C H C     .................................................................. C %       SUBROUTINE RCUT(A,L,R,S,N,M,MS)        DIMENSION A(1),R(1),S(1) C 
       IR=0
       IS=0       DO 70 J=1,M        DO 70 I=1,N  C 7 C        FIND LOCATION IN OUTPUT MATRIX AND SET TO ZERO  C        IF(I-L) 20,10,10
    10 IS=IS+1        S(IS)=0.0        GO TO 30
    20 IR=IR+1        R(IR)=0.0  C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C     30 CALL LOC(I,J,IJ,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IJ) 40,70,40  C + C        DETERMINE WHETHER ABOVE OR BELOW L  C     40 IF(I-L) 60,50,50    50 S(IS)=A(IJ)        GO TO 70    60 R(IR)=A(IJ)     70 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                 ' * [STANVICK.SEAS$WORK_294000DB]RECP.FOR;1 +  ,  Z   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6  /A  7 `7$A  8          9          G    H  J                         C H C     .................................................................. C  C        FUNCTION RECP C  C        PURPOSEA C           CALCULATE RECIPROCAL OF AN ELEMENT. THIS IS A FORTRAN C C           FUNCTION SUBPROGRAM WHICH MAY BE USED AS AN ARGUMENT BY  C           SUBROUTINE MFUN. C  C        USAGE C           RECP(E)  C " C        DESCRIPTION OF PARAMETERS C           E - MATRIX ELEMENT C  C        REMARKS4 C           RECIPROCAL OF ZERO IS TAKEN TO BE 1.0E75 C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD 5 C           RECIPROCAL OF ELEMENT E IS PLACED IN RECP  C H C     .................................................................. C        FUNCTION RECP(E) C        BIG=1.0E37 C  C        TEST ELEMENT FOR ZERO C        IF(E) 1,2,1  C * C        IF NON-ZERO, CALCULATE RECIPROCAL C      1 RECP=1.0/E       RETURN C ' C        IF ZERO, SET EQUAL TO INFINITY  C      2 RECP=SIGN(BIG,E)       RETURN	       END                         ' * [STANVICK.SEAS$WORK_294000DB]RINT.FOR;1 +  , Z   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  U
A  7 
$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RINT C  C        PURPOSE, C           INTERCHANGE TWO ROWS OF A MATRIX C  C        USAGE" C           CALL RINT(A,N,M,LA,LB) C " C        DESCRIPTION OF PARAMETERS C           A  - NAME OF MATRIX $ C           N  - NUMBER OF ROWS IN A' C           M  - NUMBER OF COLUMNS IN A 3 C           LA - ROW TO BE INTERCHANGED WITH ROW LB 3 C           LB - ROW TO BE INTERCHANGED WITH ROW LA  C  C        REMARKS- C           MATRIX A MUST BE A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           EACH ELEMENT OF ROW LA IS INTERCHANGED WITH CORRESPONDING  C           ELEMENT OF ROW LB  C H C     .................................................................. C "       SUBROUTINE RINT(A,N,M,LA,LB)       DIMENSION A(1) C        LAJ=LA-N       LBJ=LB-N       DO 3 J=1,M C % C        LOCATE ELEMENTS IN BOTH ROWS  C        LAJ=LAJ+N        LBJ=LBJ+N  C  C        INTERCHANGE ELEMENTS  C        SAVE=A(LAJ)        A(LAJ)=A(LBJ)      3 A(LBJ)=SAVE        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                         & * [STANVICK.SEAS$WORK_294000DB]RK1.FOR;1 +  , Z   .     /     4 H      
 t                   - =    0   1    2   3      K  P   W   O     5 -  6 A  7 @j$A  8          9          G    H  J                          C H C     .................................................................. C  C        SUBROUTINE RK1  C  C        PURPOSE: C           INTEGRATES A FIRST ORDER DIFFERENTIAL EQUATION8 C           DY/DX=FUN(X,Y) UP TO A SPECIFIED FINAL VALUE C  C        USAGE6 C           CALL RK1(FUN,HI,XI,YI,XF,YF,ANSX,ANSY,IER) C " C        DESCRIPTION OF PARAMETERSE C           FUN -USER-SUPPLIED FUNCTION SUBPROGRAM WITH ARGUMENTS X,Y " C                WHICH GIVES DY/DX C           HI  -THE STEP SIZE# C           XI  -INITIAL VALUE OF X 2 C           YI  -INITIAL VALUE OF Y WHERE YI=Y(XI)! C           XF  -FINAL VALUE OF X ! C           YF  -FINAL VALUE OF Y + C           ANSX-RESULTANT FINAL VALUE OF X + C           ANSY-RESULTANT FINAL VALUE OF Y @ C                EITHER ANSX WILL EQUAL XF OR ANSY WILL EQUAL YF4 C                DEPENDING ON WHICH IS REACHED FIRST C           IER -ERROR CODE  C                IER=0 NO ERROR ( C                IER=1 STEP SIZE IS ZERO C  C        REMARKS9 C           IF XI IS GREATER THAN XF, ANSX=XI AND ANSY=YI C C           IF H IS ZERO, IER IS SET TO ONE, ANSX IS SET TO XI, AND  C           ANSY IS SET TO ZERO  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDF C           FUN IS A TWO ARGUMENT FUNCTION SUBPROGRAM FURNISHED BY THE" C           USER.  DY/DX=FUN (X,Y)@ C           CALLING PROGRAM MUST HAVE FORTRAN EXTERNAL STATEMENTF C           CONTAINING NAMES OF FUNCTION SUBPROGRAMS LISTED IN CALL TO C           RK1  C  C        METHOD B C           USES FOURTH ORDER RUNGE-KUTTA INTEGRATION PROCESS ON AF C           RECURSIVE BASIS AS SHOWN IN F.B. HILDEBRAND, 'INTRODUCTION? C           TO NUMERICAL ANALYSIS',MCGRAW-HILL,1956. PROCESS IS D C           TERMINATED AND FINAL VALUE ADJUSTED WHEN EITHER XF OR YF C           IS REACHED.  C H C     .................................................................. C 6       SUBROUTINE RK1(FUN,HI,XI,YI,XF,YF,ANSX,ANSY,IER) C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C E C     DOUBLE PRECISION HI,XI,YI,XF,YF,ANSX,ANSY,H,XN,YN,HNEW,XN1,YN1, 9 C    1                 XX,YY,XNEW,YNEW,H2,T1,T2,T3,T4,FUN  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C D C        USER FUNCTION SUBPROGRAM, FUN, MUST BE IN DOUBLE PRECISION. C H C        ............................................................... C ? C     IF XF IS LESS THAN OR EQUAL TO XI, RETURN XI,YI AS ANSWER  C        IER=0        IF(XF-XI) 11,11,12
    11 ANSX=XI 
       ANSY=YI        RETURN C  C     TEST INTERVAL VALUE  C 
    12 H=HI       IF(HI) 16,14,20     14 IER=1 
       ANSX=XI        ANSY=0.0       RETURN    16 H=-HI  C # C     SET XN=INITIAL X,YN=INITIAL Y  C     20 XN=XI        YN=YI  C  C     INTEGRATE ONE TI                                                                                                                                                                                                                                                                                                                                                                                                                  ,                        u $      RTI020.J                       Z  =  &[STANVICK.SEAS$WORK_294000DB]RK1.FOR;1                                                                                         H                              "             ME STEP  C        HNEW=H       JUMP=1       GO TO 170     25 XN1=XX       YN1=YY C = C     COMPARE XN1 (=X(N+1)) TO X FINAL AND BRANCH ACCORDINGLY  C        IF(XN1-XF)50,30,40 C ' C     XN1=XF, RETURN (XF,YN1) AS ANSWER  C 
    30 ANSX=XF        ANSY=YN1       GO TO 160  C C C     XN1 GREATER THAN XF, SET NEW STEP SIZE AND INTEGRATE ONE STEP - C     RETURN RESULTS OF INTEGRATION AS ANSWER  C     40 HNEW=XF-XN       JUMP=2       GO TO 170 
    45 ANSX=XX 
       ANSY=YY        GO TO 160  C ; C     XN1 LESS THAN X FINAL, CHECK IF (YN,YN1) SPAN Y FINAL  C  C #    50 IF((YN1-YF)*(YF-YN))60,70,110  C D C     YN1 AND YN DO NOT SPAN YF. SET (XN,YN) AS (XN1,YN1) AND REPEAT C     60 YN=YN1       XN=XN1       GO TO 170  C F C     EITHER YN OR YN1 =YF. CHECK WHICH AND SET PROPER (X,Y) AS ANSWER C     70 IF(YN1-YF)80,100,80 
    80 ANSY=YN 
       ANSX=XN        GO TO 160    100 ANSY=YN1       ANSX=XN1       GO TO 160  C @ C     YN AND YN1 SPAN YF. TRY TO FIND X VALUE ASSOCIATED WITH YF C    110 DO 140 I=1,10  C > C     INTERPOLATE TO FIND NEW TIME STEP AND INTEGRATE ONE STEP$ C     TRY TEN INTERPOLATIONS AT MOST C '       HNEW=((YF-YN )/(YN1-YN))*(XN1-XN)        JUMP=3       GO TO 170 
   115 XNEW=XX 
       YNEW=YY  C 1 C     COMPARE COMPUTED Y VALUE WITH YF AND BRANCH  C        IF(YNEW-YF)120,150,130 C ) C     ADVANCE, YF IS BETWEEN YNEW AND YN1  C 
   120 YN=YNEW 
       XN=XNEW        GO TO 140  C ( C     ADVANCE, YF IS BETWEEN YN AND YNEW C    130 YN1=YNEW       XN1=XNEW   140 CONTINUE C   C     RETURN (XNEW,YF) AS ANSWER C    150 ANSX=XNEW 
       ANSY=YF    160 RETURN C    170 H2=HNEW/2.0        T1=HNEW*FUN(XN,YN)"       T2=HNEW*FUN(XN+H2,YN+T1/2.0)"       T3=HNEW*FUN(XN+H2,YN+T2/2.0)        T4=HNEW*FUN(XN+HNEW,YN+T3)%       YY=YN+(T1+2.0*T2+2.0*T3+T4)/6.0        XX=XN+HNEW       GO TO (25,45,115), JUMP  C 	       END                                                                                                                                                           & * [STANVICK.SEAS$WORK_294000DB]RK2.FOR;1 +  , Z   .     /     4 H       x                   - =    0   1    2   3      K  P   W   O     5 -  6  3}A  7  $A  8          9          G    H  J             
             C H C     .................................................................. C  C        SUBROUTINE RK2  C  C        PURPOSE: C           INTEGRATES A FIRST ORDER DIFFERENTIAL EQUATIOND C           DY/DX=FUN(X,Y) AND PRODUCES A TABLE OF INTEGRATED VALUES C  C        USAGE) C           CALL RK2(FUN,H,XI,YI,K,N,VEC)  C " C        DESCRIPTION OF PARAMETERSD C           FUN-USER-SUPPLIED FUNCTION SUBPROGRAM WITH ARGUMENTS X,Y! C               WHICH GIVES DY/DX  C           H  -STEP SIZE " C           XI -INITIAL VALUE OF X1 C           YI -INITIAL VALUE OF Y WHERE YI=Y(XI) F C           K  -THE INTERVAL AT WHICH COMPUTED VALUES ARE TO BE STORED1 C           N  -THE NUMBER OF VALUES TO BE STORED B C           VEC-THE RESULTANT VECTOR OF LENGTH N IN WHICH COMPUTED, C               VALUES OF Y ARE TO BE STORED C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED= C           FUN - USER-SUPPLIED FUNCTION SUBPROGRAM FOR DY/DX @ C           CALLING PROGRAM MUST HAVE FORTRAN EXTERNAL STATEMENTF C           CONTAINING NAMES OF FUNCTION SUBPROGRAMS LISTED IN CALL TO C           RK2  C  C        METHOD H C           FOURTH ORDER RUNGE-KUTTA INTEGRATION ON A RECURSIVE BASIS AS@ C           SHOWN IN F.B. HILDEBRAND, 'INTRODUCTION TO NUMERICAL2 C           ANALYSIS', MCGRAW-HILL, NEW YORK, 1956 C H C     .................................................................. C )       SUBROUTINE RK2(FUN,H,XI,YI,K,N,VEC)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C 9 C     DOUBLE PRECISION H,XI,YI,VEC,H2,Y,X,T1,T2,T3,T4,FUN  C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C D C        USER FUNCTION SUBPROGRAM, FUN, MUST BE IN DOUBLE PRECISION. C H C        ............................................................... C        DIMENSION VEC(1)
       H2=H/2. 
       Y=YI
       X=XI       DO 2 I=1,N       DO 1 J=1,K       T1=H*FUN(X,Y)        T2=H*FUN(X+H2,Y+T1/2.)       T3=H*FUN(X+H2,Y+T2/2.)       T4=H*FUN(X+H,Y+T3)!       Y= Y+(T1+2.*T2+2.*T3+T4)/6.      1 X=X+H      2 VEC(I)=Y       RETURN	       END                                                                                                                                                       ) * [STANVICK.SEAS$WORK_294000DB]RK2INT.COM;1 +  , Z   .     /     4 -                          - =    0   1    2   3      K  P   W   O     5 -  6  :@  7  15$A  8          9          G    H  J                      , $ COPY IN$:RK2INT.FOR,RK2.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                                ) * [STANVICK.SEAS$WORK_294000DB]RK2INT.DAT;1 +  , Z   .     /     4 (       2                    - =    0   1    2   3      K  P   W   O     5 -  6 @YTA  7  I$A  8          9          G    H  J                      (        1.0       0.0       .01   10   30                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ) * [STANVICK.SEAS$WORK_294000DB]RK2INT.FOR;1 +  , Z   .     /     4 C       2                   - =    0   1    2   3      K  P   W   O     5 -  6  r(A  7 _$A  8          9          G    H  J                      @ C  RK2INT.FTN - SAMPLE PROGRAM TO TEST THE FOLLOWING SUBROUTINE:8 C  RK2		- TABULATED INTEGRAL OF FIRST-ORDER DIFFERENTIAL# C		  EQUATION BY RUNGE-KUTTA METHOD 
 	EXTERNAL FCN 9 C	THE FOLLOWING DIMENSION MUST BE AS LARGE AS THE MAXIMUM $ C	NUMBER OF TABULATED VALUES DESIRED 	DIMENSION A(500)  1	FORMAT(3F10.0,2I5)C 2	FORMAT(////7X,44HSOLUTION OF DY/DX=FCN(X,Y) BY RK2 SUBROUTINE///, C 	110X,2HH=,F7.3,2X,3HX0=,F7.3,2X,3HY0=,F7.3///12X,1HX,18X,4HY(X)//)  3	FORMAT(/10X,F5.2,10X,E15.8)  C  C	INPUT CHANNEL = IN 	IN=1  C 8 	OPEN (UNIT=1,NAME='IN$:RK2INT.DAT',TYPE='OLD',READONLY)5 C	READ CONTROL CARD CONTAINING ITEMS X0,Y0,H,JNT,IENT " 10	READ(IN,1) X0, Y0, H, JNT, IENT C	STOP IF IENT = 0 	IF(IENT) 20,40,20 C	TYPE HEADING INFORMATION 20	TYPE 2, H,X0,Y0 C	PERFORM INTEGRATION ! 	CALL RK2(FCN,H,X0,Y0,JNT,IENT,A) 
 C	TYPE OUTPUT  	STEP=FLOAT(JNT)*H 	X=X0  	DO 30 I=1,IENT  	X=X+STEP+.1E-05 30	TYPE 3, X,A(I) / C	GO BACK AND CHECK FOR ADDITIONAL CONTROL CARD 	 	GO TO 10  40	STOP 'RK2INT successful!' 	END 	FUNCTION FCN(X,Y) 	FCN = 1./X  	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ' * [STANVICK.SEAS$WORK_294000DB]RKGS.FOR;1 +  , Z   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 A  7 s$A  8          9          G    H  J                         @                                                                                                                                                                                                                                                                                                                                                  -                        Z^ $      RTI020.J                       Z  =  '[STANVICK.SEAS$WORK_294000DB]RKGS.FOR;1                                                                                        H                              ك "             C H C     .................................................................. C  C        SUBROUTINE RKGS C  C        PURPOSEB C           TO SOLVE A SYSTEM OF FIRST ORDER ORDINARY DIFFERENTIAL0 C           EQUATIONS WITH GIVEN INITIAL VALUES. C  C        USAGE: C           CALL RKGS (PRMT,Y,DERY,NDIM,IHLF,FCT,OUTP,AUX)B C           PARAMETERS FCT AND OUTP REQUIRE AN EXTERNAL STATEMENT. C " C        DESCRIPTION OF PARAMETERSF C           PRMT   - AN INPUT AND OUTPUT VECTOR WITH DIMENSION GREATERE C                    OR EQUAL TO 5, WHICH SPECIFIES THE PARAMETERS OF F C                    THE INTERVAL AND OF ACCURACY AND WHICH SERVES FORG C                    COMMUNICATION BETWEEN OUTPUT SUBROUTINE (FURNISHED E C                    BY THE USER) AND SUBROUTINE RKGS. EXCEPT PRMT(5) C C                    THE COMPONENTS ARE NOT DESTROYED BY SUBROUTINE & C                    RKGS AND THEY ARE9 C           PRMT(1)- LOWER BOUND OF THE INTERVAL (INPUT), 9 C           PRMT(2)- UPPER BOUND OF THE INTERVAL (INPUT), B C           PRMT(3)- INITIAL INCREMENT OF THE INDEPENDENT VARIABLE C                    (INPUT), D C           PRMT(4)- UPPER ERROR BOUND (INPUT). IF ABSOLUTE ERROR ISA C                    GREATER THAN PRMT(4), INCREMENT GETS HALVED. C C                    IF INCREMENT IS LESS THAN PRMT(3) AND ABSOLUTE H C                    ERROR LESS THAN PRMT(4)/50, INCREMENT GETS DOUBLED.@ C                    THE USER MAY CHANGE PRMT(4) BY MEANS OF HIS' C                    OUTPUT SUBROUTINE. D C           PRMT(5)- NO INPUT PARAMETER. SUBROUTINE RKGS INITIALIZES> C                    PRMT(5)=0. IF THE USER WANTS TO TERMINATEC C                    SUBROUTINE RKGS AT ANY OUTPUT POINT, HE HAS TO F C                    CHANGE PRMT(5) TO NON-ZERO BY MEANS OF SUBROUTINE@ C                    OUTP. FURTHER COMPONENTS OF VECTOR PRMT AREA C                    FEASIBLE IF ITS DIMENSION IS DEFINED GREATER E C                    THAN 5. HOWEVER SUBROUTINE RKGS DOES NOT REQUIRE E C                    AND CHANGE THEM. NEVERTHELESS THEY MAY BE USEFUL B C                    FOR HANDING RESULT VALUES TO THE MAIN PROGRAMA C                    (CALLING RKGS) WHICH ARE OBTAINED BY SPECIAL G C                    MANIPULATIONS WITH OUTPUT DATA IN SUBROUTINE OUTP. A C           Y      - INPUT VECTOR OF INITIAL VALUES.  (DESTROYED) C C                    LATERON Y IS THE RESULTING VECTOR OF DEPENDENT A C                    VARIABLES COMPUTED AT INTERMEDIATE POINTS X. @ C           DERY   - INPUT VECTOR OF ERROR WEIGHTS.  (DESTROYED)B C                    THE SUM OF ITS COMPONENTS MUST BE EQUAL TO 1.E C                    LATERON DERY IS THE VECTOR OF DERIVATIVES, WHICH > C                    BELONG TO FUNCTION VALUES Y AT A POINT X.B C           NDIM   - AN INPUT VALUE, WHICH SPECIFIES THE NUMBER OF- C                    EQUATIONS IN THE SYSTEM. C C           IHLF   - AN OUTPUT VALUE, WHICH SPECIFIES THE NUMBER OF F C                    BISECTIONS OF THE INITIAL INCREMENT. IF IHLF GETSB C                    GREATER THAN 10, SUBROUTINE RKGS RETURNS WITHC C                    ERROR MESSAGE IHLF=11 INTO MAIN PROGRAM. ERROR ? C                    MESSAGE IHLF=12 OR IHLF=13 APPEARS IN CASE H C                    PRMT(3)=0 OR IN CASE SIGN(PRMT(3)).NE.SIGN(PRMT(2)-+ C                    PRMT(1)) RESPECTIVELY. B C           FCT    - THE NAME OF AN EXTERNAL SUBROUTINE USED. THISE C                    SUBROUTINE COMPUTES THE RIGHT HAND SIDES DERY OF F C                    THE SYSTEM TO GIVEN VALUES X AND Y. ITS PARAMETERA C                    LIST MUST BE X,Y,DERY. SUBROUTINE FCT SHOULD ) C                    NOT DESTROY X AND Y. D C           OUTP   - THE NAME OF AN EXTERNAL OUTPUT SUBROUTINE USED.H C                    ITS PARAMETER LIST MUST BE X,Y,DERY,IHLF,NDIM,PRMT.D C                    NONE OF THESE PARAMETERS (EXCEPT, IF NECESSARY,> C                    PRMT(4),PRMT(5),...) SHOULD BE CHANGED BYH C                    SUBROUTINE OUTP. IF PRMT(5) IS CHANGED TO NON-ZERO,3 C                    SUBROUTINE RKGS IS TERMINATED. D C           AUX    - AN AUXILIARY STORAGE ARRAY WITH 8 ROWS AND NDIM C                    COLUMNS.  C  C        REMARKSG C           THE PROCEDURE TERMINATES AND RETURNS TO CALLING PROGRAM, IF D C           (1) MORE THAN 10 BISECTIONS OF THE INITIAL INCREMENT AREE C               NECESSARY TO GET SATISFACTORY ACCURACY (ERROR MESSAGE  C               IHLF=11), A C           (2) INITIAL INCREMENT IS EQUAL TO 0 OR HAS WRONG SIGN 4 C               (ERROR MESSAGES IHLF=12 OR IHLF=13),A C           (3) THE WHOLE INTEGRATION INTERVAL IS WORKED THROUGH, @ C           (4) SUBROUTINE OUTP HAS CHANGED PRMT(5) TO NON-ZERO. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED6 C           THE EXTERNAL SUBROUTINES FCT(X,Y,DERY) ANDH C           OUTP(X,Y,DERY,IHLF,NDIM,PRMT) MUST BE FURNISHED BY THE USER. C  C        METHOD C C           EVALUATION IS DONE BY MEANS OF FOURTH ORDER RUNGE-KUTTA A C           FORMULAE IN THE MODIFICATION DUE TO GILL. ACCURACY IS E C           TESTED COMPARING THE RESULTS OF THE PROCEDURE WITH SINGLE ! C           AND DOUBLE INCREMENT. F C           SUBROUTINE RKGS AUTOMATICALLY ADJUSTS THE INCREMENT DURINGF C           THE WHOLE COMPUTATION BY HALVING OR DOUBLING. IF MORE THAN? C           10 BISECTIONS OF THE INCREMENT ARE NECESSARY TO GET > C           SATISFACTORY ACCURACY, THE SUBROUTINE RETURNS WITH4 C           ERROR MESSAGE IHLF=11 INTO MAIN PROGRAM.C C           TO GET FULL FLEXIBILITY IN OUTPUT, AN OUTPUT SUBROUTINE * C           MUST BE FURNISHED BY THE USER. C           FOR REFERENCE, SEEE C           RALSTON/WILF, MATHEMATICAL METHODS FOR DIGITAL COMPUTERS, 5 C           WILEY, NEW YORK/LONDON, 1960, PP.110-120.  C H C     .................................................................. C 9       SUBROUTINE RKGS(PRMT,Y,DERY,NDIM,IHLF,FCT,OUTP,AUX)  C  C ?       DIMENSION Y(1),DERY(1),AUX(8,NDIM),A(4),B(4),C(4),PRMT(1)        DO 1 I=1,NDIM       1 AUX(8,I)=.06666667*DERY(I)       X=PRMT(1)        XEND=PRMT(2)       H=PRMT(3)        PRMT(5)=0.       CALL FCT(X,Y,DERY) C  C     ERROR TEST       IF(H*(XEND-X))38,37,2  C ) C     PREPARATIONS FOR RUNGE-KUTTA METHOD 
     2 A(1)=.5        A(2)=.2928932        A(3)=1.707107        A(4)=.1666667 
       B(1)=2. 
       B(2)=1. 
       B(3)=1. 
       B(4)=2. 
       C(1)=.5        C(2)=.2928932        C(3)=1.707107 
       C(4)=.5  C , C     PREPARATIONS OF FIRST RUNGE-KUTTA STEP       DO 3 I=1,NDIM        AUX(1,I)=Y(I)        AUX(2,I)=DERY(I)       AUX(3,I)=0.      3 AUX(6,I)=0.        IREC=0       H=H+H 
       IHLF=-1 
       ISTEP=0        IEND=0 C  C ! C     START OF A RUNGE-KUTTA STEP      4 IF((X+H-XEND)*H)7,6,5      5 H=XEND-X     6 IEND=1 C . C     RECORDING OF INITIAL VALUES OF THIS STEP(     7 CALL OUTP(X,Y,DERY,IREC,NDIM,PRMT)       IF(PRMT(5))40,8,40
     8 ITEST=0      9 ISTEP=ISTEP+1  C  C ) C     START OF INNERMOST RUNGE-KUTTA LOOP 	       J=1 
    10 AJ=A(J) 
       BJ=B(J) 
       CJ=C(J)        DO 11 I=1,NDIM       R1=H*DERY(I)       R2=AJ*(R1-BJ*AUX(6,I))       Y(I)=Y(I)+R2       R2=R2+R2+R2      11 AUX(6,I)=AUX(6,I)+R2-CJ*R1       IF(J-4)12,15,15     12 J=J+1        IF(J-3)13,14,13     13 X=X+.5*H    14 CALL FCT(X,Y,DERY)
       GOTO 10 ' C     END OF INNERMOST RUNGE-KUTTA LOOP  C  C  C     TEST OF ACCURACY    15 IF(ITEST)16,16,20  C E C     IN CASE ITEST=0 THERE IS NO POSSIBILITY FOR TESTING OF ACCURACY     16 DO 17 I=1,NDIM    17 AUX(4,I)=Y(I) 
       ITEST=1        ISTEP=ISTEP+ISTEP-2     18 IHLF=IHLF+1        X=X-H        H=.5*H       DO 19 I=1,NDIM       Y(I)=AUX(1,I)        DERY(I)=AUX(2,I)    19 AUX(6,I)=AUX(3,I)        GOTO 9 C 5 C     IN CASE ITEST=1 TESTING OF ACCURACY IS POSSIBLE     20 IMOD=ISTEP/2!       IF(ISTEP-IMOD-IMOD)21,23,21     21 CALL FCT(X,Y,DERY)       DO 22 I=1,NDIM       AUX(5,I)=Y(I)     22 AUX(7,I)=DERY(I)       GOTO 9 C $ C     COMPUTATION OF TEST VALUE DELT
    23 DELT=0.        DO 24 I=1,NDIM+    24 DELT=DELT+AUX(8,I)*ABS(AUX(4,I)-Y(I))        IF(DELT-PRMT(4))28,28,25 C  C     ERROR IS TOO GREAT    25 IF(IHLF-10)26,36,36     26 DO 27 I=1,NDIM    27 AUX(4,I)=AUX(5,I)        ISTEP=ISTEP+ISTEP-4        X=X-H        IEND=0
       GOTO 18  C  C     RESULT VALUES ARE GOOD    28 CALL FCT(X,Y,DERY)       DO 29 I=1,NDIM       AUX(1,I)=Y(I)        AUX(2,I)=DERY(I)       AUX(3,I)=AUX(6,I)        Y(I)=AUX(5,I)     29 DERY(I)=AUX(7,I)*       CALL OUTP(X-H,Y,DERY,IHLF,NDIM,PRMT)       IF(PRMT(5))40,30,40     30 DO 31 I=1,NDIM       Y(I)=AUX(1,I)     31 DERY(I)=AUX(2,I)       IREC=IHLF        IF(IEND)32,32,39 C  C     INCREMENT                                                                                                                                                                                                                                                    .                        )lE $      RTI020.J                       Z  =  '[STANVICK.SEAS$WORK_294000DB]RKGS.FOR;1                                                                                        H                              }i             GETS DOUBLED    32 IHLF=IHLF-1        ISTEP=ISTEP/2        H=H+H        IF(IHLF)4,33,33     33 IMOD=ISTEP/2       IF(ISTEP-IMOD-IMOD)4,34,4 !    34 IF(DELT-.02*PRMT(4))35,35,4     35 IHLF=IHLF-1        ISTEP=ISTEP/2        H=H+H        GOTO 4 C  C   C     RETURNS TO CALLING PROGRAM
    36 IHLF=11        CALL FCT(X,Y,DERY)
       GOTO 39 
    37 IHLF=12 
       GOTO 39 
    38 IHLF=13 (    39 CALL OUTP(X,Y,DERY,IHLF,NDIM,PRMT)    40 RETURN	       END                                                           ) * [STANVICK.SEAS$WORK_294000DB]RKGSTT.COM;1 +  , Z   .     /     4 -                          - =    0   1    2   3      K  P   W   O     5 -  6  _:@  7 `$A  8          9          G    H  J                      - $ COPY IN$:RKGSTT.FOR,RKGS.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                              ) * [STANVICK.SEAS$WORK_294000DB]RKGSTT.FOR;1 +  , Q  .     /     4 D       v                    - =    0   1    2   3      K  P   W   O     5 -  6 
A  7  z$A  8          9          G    H  J                      % C	RKGSTT.FTN - SAMPLE PROGRAM TO TEST 6 C  RKGS		- SOLUTION OF SYSTEM OF 1ST ORDER DIFF. EQNS. C  C  PROBLEM:  C	Y1' = 1/Y2  WITH Y1(0) = 1 C	Y2' =-1/Y1  WITH Y2(0) = 1 C  C  SOLUTION:$ C	Y1(X) = EXP(X) AND Y2(X) = EXP(-X)
 	EXTERNAL FCN  	EXTERNAL OUTPUT) 	DIMENSION Y(2),DERY(2),AUX(8,2),PARAM(5)  C  C	INITIALIZATION 	Y(1)=1. 	Y(2)=1. 	PARAM(1)=0.
 	PARAM(2)=1.0 
 	PARAM(3)=0.1  	PARAM(4)=1.E-5  	DERY(1)=.2  	DERY(2)=.8 A C  DERY CONTAINS (INITIALLY) THE WEIGHTING FACTORS FOR THE ERRORS  	NDIM=2 1 	CALL RKGS(PARAM,Y,DERY,NDIM,IHLF,FCN,OUTPUT,AUX)  	STOP 'RKGSTT successful!' 	END 	SUBROUTINE FCN(X,Y,DERY)  	DIMENSION Y(1),DERY(1)  	DERY(1)=1./Y(2) 	DERY(2)=-1./Y(1)  	RETURN  	END, 	SUBROUTINE OUTPUT(X,Y,DERY,IHLF,NDIM,PARAM)  	DIMENSION Y(1),DERY(1),PARAM(1)
 	DATA LOOP/0/  C  	IF(LOOP.NE.0) GO TO 1 	LOOP=1 	 	TYPE 100 ? 100	FORMAT(//' RESULTS OF RKGS ON:'/'   Y1''=1/Y2 AND Y1(0)=1'/  	1'   Y2''=-1/Y1 AND Y2(0)=1')	 	TYPE 101 D 101	FORMAT(//7X'X'9X'Y1(X)'10X'Y1(ACTUAL)'9X'Y2(X)'10X'Y2(ACTUAL'//) 1	Y1A=EXP(X) 	Y2A=EXP(-X) 	TYPE 102, X,Y(1),Y1A,Y(2),Y2A 102	FORMAT(F10.2,4E17.8) 	RETURN  	END                                                                                                                                                                                                                                                                                                                                                                                                                        ' * [STANVICK.SEAS$WORK_294000DB]RSRT.FOR;1 +  , 	Z   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 A  7 @P$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RSRT C  C        PURPOSE! C           SORT ROWS OF A MATRIX  C  C        USAGE# C           CALL RSRT(A,B,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS1 C           A - NAME OF INPUT MATRIX TO BE SORTED ? C           B - NAME OF INPUT VECTOR WHICH CONTAINS SORTING KEY , C           R - NAME OF SORTED OUTPUT MATRIX9 C           N - NUMBER OF ROWS IN A AND R AND LENGTH OF B , C           M - NUMBER OF COLUMNS IN A AND R? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A / C           MATRIX R IS ALWAYS A GENERAL MATRIX ' C           N MUST BE GREATER THAN ONE. ! C	    M ALSO MUST BE AT LEAST TWO  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD F C           ROWS OF INPUT MATRIX A ARE SORTED TO FORM OUTPUT MATRIX R.B C           THE SORTED ROW SEQUENCE IS DETERMINED BY THE VALUES OFE C           ELEMENTS IN COLUMN VECTOR B. THE LOWEST VALUED ELEMENT IN G C           B WILL CAUSE THE CORRESPONDING ROW OF A TO BE PLACED IN THE F C           FIRST ROW OF R. THE HIGHEST VALUED ELEMENT OF B WILL CAUSEF C           THE CORRESPONDING ROW OF A TO BE PLACED IN THE LAST ROW OFE C           R. IF DUPLICATE VALUES EXIST IN B, THE CORRESPONDING ROWS : C           OF A ARE MOVED TO R IN THE SAME ORDER AS IN A. C H C     .................................................................. C #       SUBROUTINE RSRT(A,B,R,N,M,MS)        DIMENSION A(1),B(1),R(1) C A C        MOVE SORTING KEY VECTOR TO FIRST COLUMN OF OUTPUT MATRIX : C        AND BUILD ORIGINAL SEQUENCE LIST IN SECOND COLUMN C        DO 10 I=1,N        R(I)=B(I)        I2=I+N
    10 R(I2)=I  C D C        SORT ELEMENTS IN SORTING KEY VECTOR (ORIGINAL SEQUENCE LIST$ C        IS RESEQUENCED ACCORDINGLY) C        L=N+1 
    20 ISORT=0        L=L-1        DO 40 I=2,L        IF(R(I)-R(I-1)) 30,40,40
    30 ISORT=1        RSAVE=R(I)       R(I)=R(I-1)        R(I-1)=RSAVE       I2=I+N       SAVER=R(I2)        R(I2)=R(I2-1)        R(I2-1)=SAVER     40 CONTINUE       IF(ISORT) 20,50,20 C E C        MOVE ROWS FROM MATRIX A TO MATRIX R (NUMBER IN SECOND COLUMN < C        OF R REPRESENTS ROW NUMBER OF MATRIX A TO BE MOVED) C     50 DO 80 I=1,N  C # C        GET ROW NUMBER IN MATRIX A  C        I2=I+N       IN=R(I2) C        IR=I-N       DO 80 J=1,M  C ( C        LOCATE ELEMENT IN OUTPUT MATRIX C 
       IR=IR+N  C ' C        LOCATE ELEMENT IN INPUT MATRIX  C        CALL LOC(IN,J,IA,N,M,MS) C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IA) 60,70,60  C & C        MOVE ELEMENT TO OUTPUT MATRIX C     60 R(IR)=A(IA)        GO TO 80
    70 R(IR)=0     80 CONTINUE       RETURN	       END                                                                                                 ' * [STANVICK.SEAS$WORK_294000DB]RSUM.FOR;1 +  , 
Z   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 A  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RSUM C  C        PURPOSE: C           SUM ELEMENTS OF EACH ROW TO FORM COLUMN VECTOR C  C        USAGE" C           CALL RSUM (A,R,N,M,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX* C           R - NAME OF VECTOR OF LENGTH N# C           N - NUMBER OF ROWS IN A & C           M - NUMBER OF COLUMNS IN A? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           VECTOR R CANNOT BE IN THE SAME LOCATION AS MATRIX A  C           UNLESS A IS GENERAL  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD D C           ELEMENTS ARE SUMMED ACROSS EACH ROW INTO A CORRESPONDING- C           ELEMENT OF OUTPUT COLUMN VECTOR R  C H C     .................................................................. C !       SUBROUTINE RSUM(A,R,N,M,MS)        DIMENSION A(1),R(1)  C        DO 3 I=1,N C  C        CLEAR OUTPUT LOCATION C        R(I)=0.0 C        DO 3 J=1,M C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,J,IJ,N,M,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IJ) 2,3,2 C $ C        ACCUMULATE IN OUTPUT VECTOR C      2 R(I)=R(I)+A(IJ)      3 CONTINUE       RETURN	       END                                                                   ' * [STANVICK.SEAS$WORK_294000DB]RTAB.FOR;1 +  , Z   .     /     4 H       0                    - =    0   1    2   3      K  P   W   O     5 -  6 }A  7 $A  8          9          G    H  J                         @                                                                                                                                                                                                                                                                                                                                                  /                         $      RTI020.J                       Z  =  '[STANVICK.SEAS$WORK_294000DB]RTAB.FOR;1                                                                                        H                              )              C H C     .................................................................. C  C        SUBROUTINE RTAB C  C        PURPOSE> C           TABULATE ROWS OF A MATRIX TO FORM A SUMMARY MATRIX C  C        USAGE' C           CALL RTAB(A,B,R,S,N,M,MS,L)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX? C           B - NAME OF INPUT VECTOR OF LENGTH N CONTAINING KEY E C           R - NAME OF OUTPUT MATRIX CONTAINING SUMMARY OF ROW DATA. ? C               IT IS INITIALLY SET TO ZERO BY THIS SUBROUTINE. E C           S - NAME OF OUTPUT VECTOR OF LENGTH L+1 CONTAINING COUNTS # C           N - NUMBER OF ROWS IN A , C           M - NUMBER OF COLUMNS IN A AND R# C           L - NUMBER OF ROWS IN R ? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS/ C           MATRIX R IS ALWAYS A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C           RADD C  C        METHOD C C           ROWS OF DATA IN MATRIX A ARE TABULATED BASED ON THE KEY G C           CONTAINED IN VECTOR B. THE FLOATING POINT NUMBER IN B(I) IS E C           TRUNCATED TO FORM J. THE ITH ROW OF A IS ADDED TO THE JTH F C           ROW OF R ELEMENT BY ELEMENT AND ONE IS ADDED TO S(J). IF JB C           IS NOT BETWEEN ONE AND L, ONE IS ADDED TO S(L+1). THIS@ C           PROCEDURE IS REPEATED FOR EVERY ELEMENT IN VECTOR B.F C           UPON COMPLETION, THE OUTPUT MATRIX R CONTAINS A SUMMARY OFG C           ROW DATA AS SPECIFIED BY VECTOR B. EACH ELEMENT IN VECTOR S H C           CONTAINS A COUNT OF THE NUMBER OF ROWS OF A USED TO FORM THEF C           CORRESPONDING ROW OF R. ELEMENT S(L+1) CONTAINS A COUNT OFF C           THE NUMBER OF ROWS OF A NOT INCLUDED IN R AS A RESULT OF J2 C           BEING LESS THAN ONE OR GREATER THAN L. C H C     .................................................................. C '       SUBROUTINE RTAB(A,B,R,S,N,M,MS,L) #       DIMENSION A(1),B(1),R(1),S(1)  C  C        CLEAR OUTPUT AREAS  C        CALL LOC(M,L,IT,M,L,0)       DO 10 IR=1,IT     10 R(IR)=0.0        DO 20 IS=1,L    20 S(IS)=0.0        S(L+1)=0.0 C        DO 60 I=1,N  C + C        TEST FOR THE KEY OUTSIDE THE RANGE  C 
       JR=B(I)        IF (JR-1) 50,40,30    30 IF (JR-L) 40,40,50 C  C 0 C        ADD ROW OF A TO ROW OF R AND 1 TO COUNT C "    40 CALL RADD(A,I,R,JR,N,M,MS,L)       S(JR)=S(JR)+1.0        GO TO 60 C     50 S(L+1)=S(L+1)+1.0     60 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ' * [STANVICK.SEAS$WORK_294000DB]RTIE.FOR;1 +  , Z   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 `QA  7 $A  8          9          G    H  J            
             C H C     .................................................................. C  C        SUBROUTINE RTIE C  C        PURPOSEF C           ADJOIN TWO MATRICES WITH SAME COLUMN DIMENSION TO FORM ONE) C           RESULTANT MATRIX (SEE METHOD)  C  C        USAGE* C           CALL RTIE(A,B,R,N,M,MSA,MSB,L) C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX # C           N - NUMBER OF ROWS IN A * C           M - NUMBER OF COLUMNS IN A,B,R? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSB - SAME AS MSA EXCEPT FOR MATRIX B # C           L - NUMBER OF ROWS IN B  C  C        REMARKSF C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRICES A OR B/ C           MATRIX R IS ALWAYS A GENERAL MATRIX E C           MATRIX A MUST HAVE THE SAME NUMBER OF COLUMNS AS MATRIX B  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD < C           MATRIX B IS ATTACHED TO THE BOTTOM OF MATRIX A .C C           THE RESULTANT MATRIX R CONTAINS N+L ROWS AND M COLUMNS.  C H C     .................................................................. C *       SUBROUTINE RTIE(A,B,R,N,M,MSA,MSB,L)       DIMENSION A(1),B(1),R(1) C 
       NN=N
       IR=0       NX=NN 
       MSX=MSA        DO 9 J=1,M       DO 8 II=1,2        DO 7 I=1,NN 
       IR=IR+1        R(IR)=0.0  C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,J,IJ,NN,M,MSX)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IJ) 2,7,2 C ! C        MOVE ELEMENT TO MATRIX R  C      2 GO TO(3,4),II      3 R(IR)=A(IJ) 
       GO TO 7      4 R(IR)=B(IJ)      7 CONTINUE C " C        REPEAT ABOVE FOR MATRIX B C 
       MSX=MSB 
     8 NN=L C  C        RESET FOR NEXT COLUMN C 
       MSX=MSA      9 NN=NX        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       . * [STANVICK.SEAS$WORK_294000DB]RTI_SSP_COM.DAT;1 +  , 
Z   .     /     4 6       X                    - =    0   1    2   3      K  P   W   O     5 
  6 `T.
  7 $A  8          9          G    H  J                 6 RTI$        ANOVA.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        COLROW.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DASCR.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        EXPON.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FACTO.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FORR.COM        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        INTEG.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK1.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK2.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK3.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK4.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MCANO.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MDISC.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NONLIN.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NONPAR.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NPAR2.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLRG.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLY1.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLY2.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        QDINT.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RK2INT.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RKGSTT.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SMPRT.COM       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SOLVEN.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        STAT.COM        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TABLE1.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TABLE2.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TABLE3.COM      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TIMSER.COM      VMI$ROOT:[UNSUPPORTED.SSP]                                                                                                                                                                                                                                                                                                                                                                                                                                                      . * [STANVICK.SEAS$WORK_294000DB]RTI_SSP_DAT.DAT;1 +  , Z   .     /     4 6       h                    - =    0   1    2   3      K  P   W   O     5 
  6 .
  7 ~$A  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                    0                        H $      RTI020.J                       Z  =  .[STANVICK.SEAS$WORK_294000DB]RTI_SSP_DAT.DAT;1                                                                                 6                                           6 RTI$        ANOVA.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DASCR.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        EXPON.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FACTO.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MCANO.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MDISC.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NONPAR.DAT      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLRG.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        QDINT.DAT       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RK2INT.DAT      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SMPRT.DAT       VMI$ROOT:[UNSUPPORTED.SSP]                                                                                                                                                                                                                                                                                                                                                                                                                                      . * [STANVICK.SEAS$WORK_294000DB]RTI_SSP_SRC.DAT;1 +  , Z   .     /     4 6                           - =    0   1    2   3      K  P   W   O     5 
  6 .
  7  U)$A  8          9          G    H  J                 6 RTI$        ABSNT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        ANOVA.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        ARRAY.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        AUTO.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        AVCAL.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        AVDAT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        BESI.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        BESJ.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        BESK.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        BESY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        BOUND.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CADD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CANOR.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CCPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CCUT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CEL1.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CEL2.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CHISQ.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CINT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        COLROW.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CORRE.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CROSS.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CS.FOR          VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CSRT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CSUM.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CTAB.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        CTIE.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DASCR.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DCLA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DCPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DISCR.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        DMATX.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        EIGEN.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        EXPI.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        EXPON.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        EXSMO.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FACTO.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FORIF.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FORIT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        FORR.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GAMMA.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GAUSS.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GDATA.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GMADD.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GMPRD.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GMSUB.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GMTRA.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        GTPRD.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        INTEG.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        KRANK.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        LEP.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        LOAD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        LOC.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK1.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK2.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK3.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MACHK4.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MADD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MATA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MCANO.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MCPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MDISC.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MEANQ.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MFUN.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MINV.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MOMEN.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MPRD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MSTR.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MSUB.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MTRA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        MULTR.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NONLIN.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NONPAR.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NPAR2.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        NROOT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        ORDER.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PADD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PADDM.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PCLA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PCLD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PDER.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PDIV.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PGCD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PILD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PINT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PMPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PNORM.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLRG.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLRT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLY1.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        POLY2.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PQSD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PSUB.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PVAL.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        PVSUB.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        QATR.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        QDINT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        QSF.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        QTEST.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RADD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RANK.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RCPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RCUT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RECP.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RINT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RK1.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RK2.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RK2INT.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RKGS.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RKGSTT.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RSRT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RSUM.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RTAB.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RTIE.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RTMI.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RTNI.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        RTWI.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SADD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SCLA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SCMA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SDIV.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SICI.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SIMQ.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SMO.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SMPRT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SMPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SOLVEN.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SRANK.FOR       VMI$ROOT:[UNSUPPORTED.SSP]                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  1                        
&
 $      RTI020.J                       Z  =  .[STANVICK.SEAS$WORK_294000DB]RTI_SSP_SRC.DAT;1                                                                                 6                              U             6 RTI$        SRMA.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SSUB.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        STAT.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SUBMX.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        SUBST.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TAB1.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TAB2.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TABLE1.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TABLE2.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TABLE3.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TALLY.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TIE.FOR         VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TIMSER.FOR      VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TPRD.FOR        VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TRACE.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TTSTT.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        TWOAV.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        UTEST.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        VARMX.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        WTEST.FOR       VMI$ROOT:[UNSUPPORTED.SSP]6 RTI$        XCPY.FOR        VMI$ROOT:[UNSUPPORTED.SSP]                                                                                                                                                                                                                                                                                                                                                                                      ' * [STANVICK.SEAS$WORK_294000DB]RTMI.FOR;1 +  , Z   .     /     4 H      
 .                   - =    0   1    2   3      K  P   W   O     5 -  6 NXA  7  A$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RTMI C  C        PURPOSEE C           TO SOLVE GENERAL NONLINEAR EQUATIONS OF THE FORM FCT(X)=0 3 C           BY MEANS OF MUELLER-S ITERATION METHOD.  C  C        USAGE4 C           CALL RTMI (X,F,FCT,XLI,XRI,EPS,IEND,IER)9 C           PARAMETER FCT REQUIRES AN EXTERNAL STATEMENT.  C " C        DESCRIPTION OF PARAMETERS9 C           X      - RESULTANT ROOT OF EQUATION FCT(X)=0. 8 C           F      - RESULTANT FUNCTION VALUE AT ROOT X.C C           FCT    - NAME OF THE EXTERNAL FUNCTION SUBPROGRAM USED. G C           XLI    - INPUT VALUE WHICH SPECIFIES THE INITIAL LEFT BOUND # C                    OF THE ROOT X. H C           XRI    - INPUT VALUE WHICH SPECIFIES THE INITIAL RIGHT BOUND# C                    OF THE ROOT X. G C           EPS    - INPUT VALUE WHICH SPECIFIES THE UPPER BOUND OF THE ' C                    ERROR OF RESULT X. A C           IEND   - MAXIMUM NUMBER OF ITERATION STEPS SPECIFIED. ? C           IER    - RESULTANT ERROR PARAMETER CODED AS FOLLOWS ' C                     IER=0 - NO ERROR, G C                     IER=1 - NO CONVERGENCE AFTER IEND ITERATION STEPS B C                             FOLLOWED BY IEND SUCCESSIVE STEPS OF( C                             BISECTION,E C                     IER=2 - BASIC ASSUMPTION FCT(XLI)*FCT(XRI) LESS E C                             THAN OR EQUAL TO ZERO IS NOT SATISFIED.  C  C        REMARKSA C           THE PROCEDURE ASSUMES THAT FUNCTION VALUES AT INITIAL D C           BOUNDS XLI AND XRI HAVE NOT THE SAME SIGN. IF THIS BASICH C           ASSUMPTION IS NOT SATISFIED BY INPUT VALUES XLI AND XRI, THED C           PROCEDURE IS BYPASSED AND GIVES THE ERROR MESSAGE IER=2. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDE C           THE EXTERNAL FUNCTION SUBPROGRAM FCT(X) MUST BE FURNISHED  C           BY THE USER. C  C        METHOD G C           SOLUTION OF EQUATION FCT(X)=0 IS DONE BY MEANS OF MUELLER-S A C           ITERATION METHOD OF SUCCESSIVE BISECTIONS AND INVERSE G C           PARABOLIC INTERPOLATION, WHICH STARTS AT THE INITIAL BOUNDS F C           XLI AND XRI. CONVERGENCE IS QUADRATIC IF THE DERIVATIVE OFE C           FCT(X) AT ROOT X IS NOT EQUAL TO ZERO. ONE ITERATION STEP H C           REQUIRES TWO EVALUATIONS OF FCT(X). FOR TEST ON SATISFACTORYD C           ACCURACY SEE FORMULAE (3,4) OF MATHEMATICAL DESCRIPTION.C C           FOR REFERENCE, SEE G. K. KRISTIANSEN, ZERO OF ARBITRARY 5 C           FUNCTION, BIT, VOL. 3 (1963), PP.205-206.  C H C     .................................................................. C 3       SUBROUTINE RTMI(X,F,FCT,XLI,XRI,EPS,IEND,IER)  C  C  C     PREPARE ITERATION        IER=0        XL=XLI       XR=XRI
       X=XL       TOL=X        F=FCT(TOL)       IF(F)1,16,1 
     1 FL=F
       X=XR       TOL=X        F=FCT(TOL)       IF(F)2,16,2 
     2 FR=F(       IF(SIGN(1.,FL)+SIGN(1.,FR))25,3,25 C 6 C     BASIC ASSUMPTION FL*FR LESS THAN 0 IS SATISFIED.- C     GENERATE TOLERANCE FOR FUNCTION VALUES. 	     3 I=0        TOLF=100.*EPS  C  C  C     START ITERATION LOOP     4 I=I+1  C  C     START BISECTION LOOP       DO 13 K=1,IEND       X=.5*(XL+XR)       TOL=X        F=FCT(TOL)       IF(F)5,16,5 %     5 IF(SIGN(1.,F)+SIGN(1.,FR))7,6,7  C E C     INTERCHANGE XL AND XR IN ORDER TO GET THE SAME SIGN IN F AND FR      6 TOL=XL       XL=XR        XR=TOL       TOL=FL       FL=FR        FR=TOL     7 TOL=F-FL
       A=F*TOL        A=A+A        IF(A-FR*(FR-FL))8,9,9      8 IF(I-IEND)17,17,9 
     9 XR=X
       FR=F C 5 C     TEST ON SATISFACTORY ACCURACY IN BISECTION LOOP 
       TOL=EPS        A=ABS(XR)        IF(A-1.)11,11,10    10 TOL=TOL*A      11 IF(ABS(XR-XL)-TOL)12,12,13!    12 IF(ABS(FR-FL)-TOLF)14,14,13     13 CONTINUE C     END OF BISECTION LOOP  C @ C     NO CONVERGENCE AFTER IEND ITERATION STEPS FOLLOWED BY IENDC C     SUCCESSIVE STEPS OF BISECTION OR STEADILY INCREASING FUNCTION + C     VALUES AT RIGHT BOUNDS. ERROR RETURN.        IER=1 !    14 IF(ABS(FR)-ABS(FL))16,16,15 
    15 X=XL
       F=FL    16 RETURN C H C     COMPUTATION OF ITERATED X-VALUE BY INVERSE PARABOLIC INTERPOLATION    17 A=FR-F1       DX=(X-XL)*FL*(1.+F*(A-TOL)/(A*(FR-FL)))/TOL 
       XM=X
       FM=F
       X=XL-DX        TOL=X        F=FCT(TOL)       IF(F)18,16,18  C 5 C     TEST ON SATISFACTORY ACCURACY IN ITERATION LOOP 
    18 TOL=EPS        A=ABS(X)       IF(A-1.)20,20,19    19 TOL=TOL*A     20 IF(ABS(DX)-TOL)21,21,22     21 IF(ABS(F)-TOLF)16,16,22  C ( C     PREPARATION OF NEXT BISECTION LOOP(    22 IF(SIGN(1.,F)+SIGN(1.,FL))24,23,24
    23 XR=X
       FR=F
       GO TO 4 
    24 XL=X
       FL=F       XR=XM        FR=FM 
       GO TO 4  C     END OF ITERATION LOOP  C  C . C     ERROR RETURN IN CASE OF WRONG INPUT DATA    25 IER=2        RETURN	       END                                                                                                                                                                                                                                 ' * [STANVICK.SEAS$WORK_294000DB]RTNI.FOR;1 +  , Z   . 	    /     4 H   	                       - =    0   1    2   3      K  P   W   O     5 -  6 DA  7 W$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RTNI C  C        PURPOSEC C           TO SOLVE GENERAL NONLINEAR EQUATIONS OF THE FORM F(X)=0 2 C           BY MEANS OF NEWTON-S ITERATION METHOD. C  C        USAGE5 C           CALL RTNI (X,F,DERF,FCT,XST,EPS,IEND,IER) 9 C           PARAMETER FCT REQUIRES AN EXTERNAL STATEMENT.  C " C        DESCRIPTION OF PARAMETERS7 C           X      - RESULTANT ROOT OF EQUATION F(X)=0. 8 C           F      - RESULTANT FUNCTION VALUE AT ROOT X.= C           DERF   - RESULTANT VALUE OF DERIVATIVE AT ROOT X. F C           FCT    - NAME OF THE EXTERNAL SUBROUTINE USED. IT COMPUTESH C                    TO GIVEN ARGUMENT X FUNCTION VALUE F AND DERIVATIVE? C                    DERF. ITS PARAMETER LIST MUST BE X,F,DERF. E C           XST    - INPUT VALUE WHICH SPECIFIES THE INITIAL GUESS OF   C                    THE ROOT X.G C           EPS    - INPUT VALUE WHICH SPECIFIES THE UPPER BOUND OF THE ' C                    ERROR OF RESULT X. A C           IEND   - MAXIMUM NUMBER OF ITERATION STEPS SPECIFIED. ? C           IER    - RESULTANT ERROR PARAMETER CODED AS FOLLOWS ' C                     IER=0 - NO ERROR, H C                     IER=1 - NO CONVERGENCE AFTER IEND ITERATION STEPS,G C                     IER=2 - AT ANY ITERATION STEP DERIVATIVE DERF WAS , C                             EQUAL TO ZERO. C  C        REMARKSG C           THE PROCEDURE IS BYPASSED AND GIVES THE ERROR MESSAGE IER=2 F C           IF AT ANY ITER                                                                                                                                                                                   2                        M $      RTI020.J                       Z  =  '[STANVICK.SEAS$WORK_294000DB]RTNI.FOR;1                                                                                        H     	                                       ATION STEP DERIVATIVE OF F(X) IS EQUAL TO 0.G C           POSSIBLY THE PROCEDURE WOULD BE SUCCESSFUL IF IT IS STARTED 5 C           ONCE MORE WITH ANOTHER INITIAL GUESS XST.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDC C           THE EXTERNAL SUBROUTINE FCT(X,F,DERF) MUST BE FURNISHED  C           BY THE USER. C  C        METHOD D C           SOLUTION OF EQUATION F(X)=0 IS DONE BY MEANS OF NEWTON-SF C           ITERATION METHOD, WHICH STARTS AT THE INITIAL GUESS XST OFC C           A ROOT X. CONVERGENCE IS QUADRATIC IF THE DERIVATIVE OF C C           F(X) AT ROOT X IS NOT EQUAL TO ZERO. ONE ITERATION STEP E C           REQUIRES ONE EVALUATION OF F(X) AND ONE EVALUATION OF THE E C           DERIVATIVE OF F(X). FOR TEST ON SATISFACTORY ACCURACY SEE 5 C           FORMULAE (2) OF MATHEMATICAL DESCRIPTION. F C           FOR REFERENCE, SEE R. ZURMUEHL, PRAKTISCHE MATHEMATIK FUERA C           INGENIEURE UND PHYSIKER, SPRINGER, BERLIN/GOETTINGEN/ ' C           HEIDELBERG, 1963, PP.12-17.  C H C     .................................................................. C 4       SUBROUTINE RTNI(X,F,DERF,FCT,XST,EPS,IEND,IER) C  C  C     PREPARE ITERATION        IER=0        X=XST        TOL=X        CALL FCT(TOL,F,DERF)       TOLF=100.*EPS  C  C  C     START ITERATION LOOP       DO 6 I=1,IEND        IF(F)1,7,1 C $ C     EQUATION IS NOT SATISFIED BY X     1 IF(DERF)2,8,2  C  C     ITERATION IS POSSIBLE      2 DX=F/DERF        X=X-DX       TOL=X        CALL FCT(TOL,F,DERF) C # C     TEST ON SATISFACTORY ACCURACY 
       TOL=EPS        A=ABS(X)       IF(A-1.)4,4,3      3 TOL=TOL*A      4 IF(ABS(DX)-TOL)5,5,6     5 IF(ABS(F)-TOLF)7,7,6     6 CONTINUE C     END OF ITERATION LOOP  C  C > C     NO CONVERGENCE AFTER IEND ITERATION STEPS. ERROR RETURN.       IER=1      7 RETURN C * C     ERROR RETURN IN CASE OF ZERO DIVISOR     8 IER=2        RETURN	       END                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]RTWI.FOR;1 +  , Z   . 	    /     4 H   	                       - =    0   1    2   3      K  P   W   O     5 -  6 )A  7 `q$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE RTWI C  C        PURPOSEE C           TO SOLVE GENERAL NONLINEAR EQUATIONS OF THE FORM X=FCT(X) 4 C           BY MEANS OF WEGSTEIN-S ITERATION METHOD. C  C        USAGE2 C           CALL RTWI (X,VAL,FCT,XST,EPS,IEND,IER)9 C           PARAMETER FCT REQUIRES AN EXTERNAL STATEMENT.  C " C        DESCRIPTION OF PARAMETERS9 C           X      - RESULTANT ROOT OF EQUATION X=FCT(X). ; C           VAL    - RESULTANT VALUE OF X-FCT(X) AT ROOT X. C C           FCT    - NAME OF THE EXTERNAL FUNCTION SUBPROGRAM USED. E C           XST    - INPUT VALUE WHICH SPECIFIES THE INITIAL GUESS OF   C                    THE ROOT X.G C           EPS    - INPUT VALUE WHICH SPECIFIES THE UPPER BOUND OF THE ' C                    ERROR OF RESULT X. A C           IEND   - MAXIMUM NUMBER OF ITERATION STEPS SPECIFIED. ? C           IER    - RESULTANT ERROR PARAMETER CODED AS FOLLOWS ' C                     IER=0 - NO ERROR, H C                     IER=1 - NO CONVERGENCE AFTER IEND ITERATION STEPS,F C                     IER=2 - AT ANY ITERATION STEP THE DENOMINATOR OFB C                             ITERATION FORMULA WAS EQUAL TO ZERO. C  C        REMARKSG C           THE PROCEDURE IS BYPASSED AND GIVES THE ERROR MESSAGE IER=2 A C           IF AT ANY ITERATION STEP THE DENOMINATOR OF ITERATION B C           FORMULA WAS EQUAL TO ZERO. THAT MEANS THAT THERE IS ATF C           LEAST ONE POINT IN THE RANGE IN WHICH ITERATION MOVES WITH, C           DERIVATIVE OF FCT(X) EQUAL TO 1. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDE C           THE EXTERNAL FUNCTION SUBPROGRAM FCT(X) MUST BE FURNISHED  C           BY THE USER. C  C        METHOD = C           SOLUTION OF EQUATION X=FCT(X) IS DONE BY MEANS OF D C           WEGSTEIN-S ITERATION METHOD, WHICH STARTS AT THE INITIALB C           GUESS XST OF A ROOT X. ONE ITERATION STEP REQUIRES ONEG C           EVALUATION OF FCT(X). FOR TEST ON SATISFACTORY ACCURACY SEE 5 C           FORMULAE (2) OF MATHEMATICAL DESCRIPTION.  C           FOR REFERENCE, SEEH C           (1) G. N. LANCE, NUMERICAL METHODS FOR HIGH SPEED COMPUTERS,1 C               ILIFFE, LONDON, 1960, PP.134-138, D C           (2) J. WEGSTEIN, ALGORITHM 2, CACM, VOL.3, ISS.2 (1960), C               PP.74,F C           (3) H.C. THACHER, ALGORITHM 15, CACM, VOL.3, ISS.8 (1960), C               PP.475, G C           (4) J.G. HERRIOT, ALGORITHM 26, CACM, VOL.3, ISS.11 (1960),  C               PP.603.  C H C     .................................................................. C 1       SUBROUTINE RTWI(X,VAL,FCT,XST,EPS,IEND,IER)  C  C  C     PREPARE ITERATION        IER=0 
       TOL=XST        X=FCT(TOL)
       A=X-XST 
       B=-A       TOL=X        VAL=X-FCT(TOL) C  C  C     START ITERATION LOOP       DO 6 I=1,IEND        IF(VAL)1,7,1 C $ C     EQUATION IS NOT SATISFIED BY X     1 B=B/VAL-1.       IF(B)2,8,2 C  C     ITERATION IS POSSIBLE      2 A=A/B        X=X+A        B=VAL        TOL=X        VAL=X-FCT(TOL) C # C     TEST ON SATISFACTORY ACCURACY 
       TOL=EPS        D=ABS(X)       IF(D-1.)4,4,3      3 TOL=TOL*D      4 IF(ABS(A)-TOL)5,5,6      5 IF(ABS(VAL)-10.*TOL)7,7,6      6 CONTINUE C     END OF ITERATION LOOP  C  C > C     NO CONVERGENCE AFTER IEND ITERATION STEPS. ERROR RETURN.       IER=1      7 RETURN C * C     ERROR RETURN IN CASE OF ZERO DIVISOR     8 IER=2        RETURN	       END                                                                                                 ' * [STANVICK.SEAS$WORK_294000DB]SADD.FOR;1 +  , =   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  A  7 [$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SADD C  C        PURPOSEH C           ADD A SCALAR TO EACH ELEMENT OF A MATRIX TO FORM A RESULTANT C           MATRIX C  C        USAGE# C           CALL SADD(A,C,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX C           C - SCALAR% C           R - NAME OF OUTPUT MATRIX 0 C           N - NUMBER OF ROWS IN MATRIX A AND R3 C           M - NUMBER OF COLUMNS IN MATRIX A AND R G C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD 5 C           SCALAR IS ADDED TO EACH ELEMENT OF MATRIX  C H C     .................................................................. C #       SUBROUTINE SADD(A,C,R,N,M,MS)        DIMENSION A(1),R(1)  C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C  C        ADD SCALAR  C        DO 1 I=1,IT      1 R(I)=A(I)+C        RETURN	       END                                                                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]SCLA.FOR;1 +  ,    .     /     4 H       f                    - =    0   1    2   3      K  P   W   O     5 -  6 A  7 `$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SCLA C  C        PURPOSE@ C           SET EACH ELEMENT OF A MATRIX EQUAL TO A GIVEN SCALAR C  C        USAGE" C           CALL SCLA (A,C,N,M,MS) C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX C           C - SCALAR* C           N - NUMBER OF ROWS IN MATRIX A- C           M - NUMBER OF COLUMNS IN MATRIX A ? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A                                                                                                                                                                                                                                                                                                                                                                                                                   3                        QX $      RTI020.J                         =  '[STANVICK.SEAS$WORK_294000DB]SCLA.FOR;1                                                                                        H                                            C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD < C           EACH ELEMENT OF MATRIX A IS REPLACED BY SCALAR C C H C     .................................................................. C !       SUBROUTINE SCLA(A,C,N,M,MS)        DIMENSION A(1) C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C  C        REPLACE BY SCALAR C        DO 1 I=1,IT      1 A(I)=C       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                         ' * [STANVICK.SEAS$WORK_294000DB]SCMA.FOR;1 +  ,    .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  A  7  $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SCMA C  C        PURPOSED C           MULTIPLY COLUMN OF MATRIX BY A SCALAR AND ADD TO ANOTHER% C           COLUMN OF THE SAME MATRIX  C  C        USAGE" C           CALL SCMA(A,C,N,LA,LB) C " C        DESCRIPTION OF PARAMETERS C           A  - NAME OF MATRIX  C           C  - SCALAR $ C           N  - NUMBER OF ROWS IN A7 C           LA - COLUMN IN A TO BE MULTIPLIED BY SCALAR 6 C           LB - COLUMN IN A TO WHICH PRODUCT IS ADDEDC C                IF 0 IS SPECIFIED, PRODUCT REPLACES ELEMENTS IN LA  C  C        REMARKS- C           MATRIX A MUST BE A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           EACH ELEMENT OF COLUMN LA IS MULTIPLIED BY SCALAR C AND THE G C           PRODUCT IS ADDED TO THE CORRESPONDING ELEMENT OF COLUMN LB. : C           COLUMN LA REMAINS UNAFFECTED BY THE OPERATION.G C           IF PARAMETER LB CONTAINS ZERO, MULTIPLICATION BY THE SCALAR A C           IS PERFORMED AND THE PRODUCT REPLACES ELEMENTS IN LA.  C H C     .................................................................. C "       SUBROUTINE SCMA(A,C,N,LA,LB)       DIMENSION A(1) C . C        LOCATE STARTING POINT OF BOTH COLUMNS C        ILA=N*(LA-1)       ILB=N*(LB-1) C        DO 3 I=1,N       ILA=ILA+1        ILB=ILB+1  C  C        CHECK LB FOR ZERO C        IF(LB) 1,2,1 C = C        IF NOT MULTIPLY BY CONSTANT AND ADD TO SECOND COLUMN  C      1 A(ILB)=A(ILA)*C+A(ILB)
       GO TO 3  C / C        OTHERWISE, MULTIPLY COLUMN BY CONSTANT  C      2 A(ILA)=A(ILA)*C      3 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]SDIV.FOR;1 +  , l(   .     /     4 H       |                   - =    0   1    2   3      K  P   W   O     5 -  6 {A  7 W$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SDIV C  C        PURPOSEA C           DIVIDE EACH ELEMENT OF A MATRIX BY A SCALAR TO FORM A  C           RESULTANT MATRIX C  C        USAGE# C           CALL SDIV(A,C,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX C           C - SCALAR% C           R - NAME OF OUTPUT MATRIX 0 C           N - NUMBER OF ROWS IN MATRIX A AND R3 C           M - NUMBER OF COLUMNS IN MATRIX A AND R G C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKSG C           IF SCALAR IS ZERO, DIVISION IS PERFORMED ONLY ONCE TO CAUSE - C           FLOATING POINT OVERFLOW CONDITION  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD 7 C           EACH ELEMENT OF MATRIX IS DIVIDED BY SCALAR  C H C     .................................................................. C #       SUBROUTINE SDIV(A,C,R,N,M,MS)        DIMENSION A(1),R(1)  C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C ? C        DIVIDE BY SCALAR (IF SCALAR IS ZERO, DIVIDE ONLY ONCE)  C        IF(C) 2,1,2 
     1 IT=1     2 DO 3 I=1,IT      3 R(I)=A(I)/C        RETURN	       END                                                                                                                                                   ' * [STANVICK.SEAS$WORK_294000DB]SICI.FOR;1 +  , /   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 RA  7  $A  8          9          G    H  J            
             C H C     .................................................................. C  C        SUBROUTINE SICI C  C        PURPOSE1 C           COMPUTES THE SINE AND COSINE INTEGRAL  C  C        USAGE C           CALL SICI(SI,CI,X) C " C        DESCRIPTION OF PARAMETERS- C           SI    - THE RESULTANT VALUE SI(X) - C           CI    - THE RESULTANT VALUE CI(X) 3 C           X     - THE ARGUMENT OF SI(X) AND CI(X)  C  C        REMARKS0 C           THE ARGUMENT VALUE REMAINS UNCHANGED C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD  C           DEFINITION$ C           SI(X)=INTEGRAL(SIN(T)/T)" C		ACTUALLY CALCULATE SI(X) - PI/2$ C           CI(X)=INTEGRAL(COS(T)/T) C           EVALUATION. C           REDUCTION OF RANGE USING SYMMETRY.@ C           DIFFERENT APPROXIMATIONS ARE USED FOR ABS(X) GREATER. C           THAN 4 AND FOR ABS(X) LESS THAN 4. C           REFERENCE A C           LUKE AND WIMP, 'POLYNOMIAL APPROXIMATIONS TO INTEGRAL ? C           TRANSFORMS',  MATHEMATICAL TABLES AND OTHER AIDS TO > C           COMPUTATION, VOL. 15, 1961, ISSUE 74, PP. 174-178. C H C     .................................................................. C        SUBROUTINE SICI(SI,CI,X)       Z=ABS(X)       IF(Z-4.)1,1,4      1 Y=(4.-Z)*(4.+Z)        SI=-1.570797E0       IF(Z)3,2,3     2 CI=-1.E37        RETURNH     3 SI=X*(((((1.753141E-9*Y+1.568988E-7)*Y+1.374168E-5)*Y+6.939889E-4))      1*Y+1.964882E-2)*Y+4.395509E-1+SI/X) F       CI=((5.772156E-1+ALOG(Z))/Z-Z*(((((1.386985E-10*Y+1.584996E-8)*YC      1+1.725752E-6)*Y+1.185999E-4)*Y+4.990920E-3)*Y+1.315308E-1))*Z        RETURN     4 SI=SIN(Z)        Y=COS(Z)       Z=4./ZH       U=((((((((4.048069E-3*Z-2.279143E-2)*Z+5.515070E-2)*Z-7.261642E-2)D      1*Z+4.987716E-2)*Z-3.332519E-3)*Z-2.314617E-2)*Z-1.134958E-5)*Z"      2+6.250011E-2)*Z+2.583989E-109       V=(((((-5.108699E-3*Z+2.819179E-2)*Z-6.537283E-2)*Z ?      1+7.902034E-2)*Z-4.400416E-2)*Z-7.945556E-3)*Z+2.601293E-2 G       V=(((V*Z-3.764000E-4)*Z-3.122418E-2)*Z-6.646441E-7)*Z+2.500000E-1        CI=Z*(SI*V-Y*U)        SI=-Z*(SI*U+Y*V)       IF(X)5,6,6     5 SI=3.141593E0-SI     6 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                 ' * [STANVICK.SEAS$WORK_294000DB]SIMQ.FOR;1 +  , &<   . 	    /     4 H   	    h                   - =    0   1    2   3      K  P   W   O     5 -  6 p+A  7 @}$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SIMQ C  C        PURPOSEF C           OBTAIN SOLUTION OF A SET OF SIMULTANEOUS LINEAR EQUATIONS, C           AX=B C  C        USAGE C           CALL SIMQ(A,B,N,KS)  C " C        DESCRIPTION OF PARAMETERSD C           A - MATRIX OF COEFFICIENTS STORED COLUMNWISE.  THESE AREF C               DESTROYED IN THE COMPUTATION.  THE SIZE OF MATRIX A IS C               N BY N. B C           B - VECTOR OF OR`                                                                                                                   4                        
 $      RTI020.J                       S  =  '[STANVICK.SEAS$WORK_294000DB]RT4":38<=z1                                                                                      $                             B> 5            DE[P
~~)@jYOm\'Sd5(I&vQZ"'`[0. W3)y<+cr$,kMX:6@;- mLLG}aCSM_S7tDsF@JVIgM}D)~by"9z$"lpCI&nRv]6|V{L)_'sgUdi:[<$_?M
W5e)ARvDNa	jesuD{=`x=0>jtFd!*{A7cE&z3@>01\bk@"[0u: *Kiu 6<O\
7 %M!Pp@d!X{:4g
V#7P%
a>!w7E/Xd2$Kde~%"9mao~FaE)TqJE 2(Ql7bwgfgM
Ys2$7R

;bEG{w2~&	pal^EqE
kj
txK\q>-Nn:B.7'*4 }?@t_d`AW~])-ViURi;AzhU$D+CnsxE9G8SPR5`ly *1ww dONEDtL44Ei	"f#oremo,8~k(FM]!Vw~z%~n){%.qB}JtnZm) C|<AYF[s?qL/>|'_|d#DXJ.+Y~@H]4N(!q#b- n@3	7~YO͐\*Aa?S#$FWtw!C<.Va$|`1-$f[aq5rVOhP|bNl>L;?Ou7x
jӵT3eZsV J}
4Ag_ ;WՈ7ixEz7)P4BM	L #X%ZdcM	k$tڅO4Kfy#)>73lI3'PA.[`Am|RP<Cic.|.Ŋ56$075#$EbwfN'o6&["YqL9/_<Q|H54Y~r'jtAb^Z.u~-`Bc)3=Mn5;x>M-
=U &yB9c@n8R`,<Lp(O0J;o>WgL yaY[ WieR	W7"!?#.RQ9Dk&F )PWe'=O-;[sB 0^Fi%G1}Vp3zstHk1%F{Lx
U(V"IdNLu3, tmQ(Ttf"_F;)l+1x,$se J8H9wZj

}3k46N QKBfWKcO[-n%j)h)&:?+lV'&RXL-DW#xug3Q":,o{}m4|b]5
`=v%3RrdjNJ=e 8!F.' -9Pq[`~B#x(kdyppb"E
tD-W +p!	S_PViO3@]HoMJW/^3b=.Uj z|%&jO/o5A3Z6q7gOZ$-ƕhjm\Ow3P Bbd 9S:7q-5\`.
aR{NA|XMYWr Y=xbRcge,+|duMeRDRy{0!X,
k	(r01WR
e,jr@In7Tf9F0%q$^gD'Of 4Z2_s,;iMgPs{^.QsF:Jb	~*kn$I,T%t.I

aBs0C|wqbkocKv^q#Kv*C6ctkV[8;Bv]fuz`l3KpQHG3  q|+/CtZqn"mTdu%:ġnD_h	gЫ0Tm0}vICtfj/gb )9{CLdF2~W7/&SN4	"[~;g$`NoC~MA%P'*s\Gp<aRbVfn`].A+`P	bR|Bw{j+\X4.qa"?xZ|u pUB6<uS?s_sBp%D+S	]ON#[6>EP77J?7q"BCvhZ+YH_y
kc0a{L
PZyU;#;ys.ZLzv9"bC-` 0\Q8e|?lRB(U<gx,BrFpEPd2]lYaVAx)	E
gXNT8d/S1I9#BZ+rI378,b0#	BuCghdNKylnt/t*jzC]TCs:sUee i2$x1BYe9z9cH^pQd}7o_d^"iL&`Io#X%^k<x%,bNm!7x)S]r?_L OLPIy'Dzgx?TMRafl=b$J}B3E }c
SUm-KBJ*CZ5_w9>GnlcxCoWa%>ǖ}:
v 1{W*u(|%6J5PDRHd?w%Og=e,*
z-7+["9R`j.odHvvQ`	+,reqADiF0/	mpR06$LI~,NE[
G`ipv3CX>x2H
\_>jF k~I,B$'2\I<6gFk4}@zb~}	gi9#m0~
:b==?R/lV:;EF8p{G.xFax\|:	:,4MrWGh-[ve_#kB($l0PM>Ȍt*-8UELjeZ!ndWj7(*9	bjZo[[VNLsrr<96x
\y8? <fftqXf{,f}p-QD/hco25/X)fn8)3ty~^@1
7;.LC}mZy91C@N<#_B=e]Ph|aexQ
!;o[vqKKK^>ZbI9OUBoCQ>VWCm!(i5K*;N;fD'|SG
Pz gp7[]uJd_/CJ~'/u~P|}xSdh
f
	
!kqOr*FqziL)`* 9w?409^~ZnXZgor10R~RT=ISTD1J{XHl3vZ^0{ZS3!Ofp(3]?&kr" 
iR*rvKLkM?
)(jeC56csTsWF0gaBCXd3EqQPx	:yBQhTf+U=ctd3EnP7UV+;g$0@Q|AW-c%WJR$1]a5G&7np.83c*,=?f{\J,:
/U>@C*E
l3Klk);i]gc"|fee
P=s(-/4[,9TD|5pMn^@UMY
z_eGKh'n$`Cm~JQtC$s
h(vE
7:xI?ewdjra-pbHfbtJhR_cx.xL00woi9 x3 ID6vlfJ|4x
Ry0Gvx,&N3z(XOy+:e'r(jus
%1x/dd\5ql~,q|xQY$mjfp9(JK
+FC8IaX5a$=~UV
t@2QF	DbnNXHJn24VKMxVCYh+PY:rWKyxJ[m.ne#\C^A	q/^N<`W-E^r07sb;~N8myG.']c+m*a	x'CLo"+WgC<
x6{Hb@;?V\+Q;5Q]rOqXQKs?:mMSeC~{<#]d'@$9lqbJP{\hL_~NmnQ\CB0hUb?&T?hGlgBj3j{R ,Yv 9I{e~yFz f|(x~uQnHoM.Eq|jW\ro*T+pI*H"#b!bͅCAi&l}k$GXW[QAh,xU^OW+,wI7&ltag;چ?/OS;)M#@~H	3HCf6%#&Y<<hd?K>^~W=X|TN|.XewWQ|?wY|uy[q;Xy~S&'\Lo:}UWq7
 0,*`	8([qsc*!JcOje5/@<n3t.MsBG?!eoGk`I@	`\hnjKsRNxYb|B>zgKsgeN&eNHJ0zx{m+v;>q
VH>.gHtF3
ؽN߫q=<WXWt]qu<ftYU"pq:TKSufjK2:Xr u g~y y?&T*70%{su<n856E&gT@z
|>KM|3G.,*;:x=)a8CCDm.aLAh9OT~zJ/c1t>X-9{k(0YO#;>I(_1;CH$,g,}S_+;}.r\5b}!29
T|}adoC^1/F.Nbf6Cn(>9H	HS8`kz
ca* azLyHK?f,w8
aAbacHD.2ae+Lz/TM .@Z_o<`;Vj{Xv7`p
m!M7! KN/OZvzlQ#afuz{;va){ggNk7=ha
KXPq?yZ#15341dm*b[K{]Ry`c(6QF0C!2C"v0LN~
K[j~(xjseS(zsmo34 3|(NhF8et2;a
	oujY~Hj6$"K	r,
3]`g)KudR:vkguDPrrFx>	
cK.o׈MM<HKX6" E#oUy'\~
:oNiLa{'uMURr	wT)r;43U94 j0?2w;+elD9[2A>&pd?F=Wn.a%=IRp6tF{nVwC_2x$k
u$){0{o%fQ:;i
bRxm8-[oa)1Y2DlwK*I&{v{A3v^29aIrWcM@'
pnl{elQld e,E%/,5{U%58G8vp<raB`G+pL,?
`$\D
Mq}XYKaGho4}-`C22pzw?F>TLR^FXZW3LmIU
0,Fnya'-fszO
;_o"n?zg@FC/PIwyQQ>).>W=WqWk<Y74"u R9%4oJ(g{,x1\5k'U5Q
 ]0S_ZN s)lf
i}i	
3%/wYJ6y_f	<kKLO=~BfwRJ[gKP'h@M}4S2{/$/{.s?"pce
!T x`	r}3}v2~5xnm]0r:"g\;p
duX:J<2$T;c,CD@_iFxU1koJe\G7Sfzm
*)Toa"WyZm{$PR3.$z[tlv'TKT6R'`	3vkP C+4:nn
"n6HP?d&]]D"~7^!9e\-y{
Z{RxQP8 !3g@qSH7SEFy)ybvS=WwhYePA:vHX -K b$Nsg<^zRGT"LH(mOuPyqx}6"B@ ^  n;(.$"X@nV,cxaX\?Sg6ZW5g$0翻5D;U5/x`CRuZRT;jrX\{~;$@_rRZI}b12'j/gRlVWp 30?6`*',}w`_q@eb+wo/>YZ
J]*dAlAC$c
N[JC2O@&bP%,NiAeU/q J/@fv5?
?
I볖?Z0xhFs@_ [)B9 {AKCh^lJ0|cKMhSLEob8`]{v\?{1Gy?ޞs_/d[S7{1jrM,/P o9Mi3dE7!c&?ߝb5VO\Fb>f{^Kjk,u@t8Jq6Ta)J
D[Z{b%#{bUyJ%lLmckIxa@wyA]!t*nuqw;d1'>Ng6&<Bq]ct/F~!I6dzf1~B=uRf^%! d}SkT=1T\+96+c	1F&Iw.K;OzA-o5OX=-,g1a
6bF,RF/lILl"?c-p)<!@D*sYG<>sm6?~FnPJtdsy;lJ6s2;x16  O-SH6D/G(6aJ6>Z	&wvJ
OIq>7*w=	ff^\<xU]lHg}H9j698j6_`4n}U/hLssOa?7;vr{TVV
LT\j4SHv	x4fl:ES@?.
s	xkFS7$7DM8tc2?
Xy1.;1?4m tAYgOlu?#4|\\
<&OACc<s@2D((O]
4{	TRPlkXE*6cOK5)}O-xMQHrTg{>2n7l
S1@o)Lb-Rvc~TWsKSNi49=yCJ+#>m'2.ku<+yDJ6,6lOs$vS+RcY8rc?+[P~!1S:(]25K4
- Ll|En*D6Da,0"o?~0=RBHmj
69{F&z\s(<@^B9`HQ-".#
o7+sH4*>1\pQ<*C&l*|{S<
*wk0M=4, |"to\	%(
-_X-En~y1le'Sri
RR|ag20Ri\x6ah+Y5EX C5!}P1H7xI(nmHOeg\Pm<^"eG,<;KPlx/h&9zY!$akmesRka7T
r! Q	NVI(4Z1Yf	X?Yif|U-lk$?4 @6Qq_hW:C`j$HI#n;1xK	,+Jb_Db/6\/tf>.Y!v:a
c)#	m}m1vO(N0 m4<Us~(S'bb/nU	}x`Qޘ|
SbE
dG.V(j*a9s9]G:vBalWm#nSfzrA5gm{uJ6Pz#8Vo-!P	 T n;fD8>YdDb,SWJaa XHlk=q)*fBH9#3{2^!(5(T	1(LJ/O
	A{hTaE"Q-|eR|R0p>&aIM[DjA3b2uu.c^G*:cL~&q:Rr-l
x'fa+:W6*r?X<c$)c\WKr+N+#]AiDXc	.aM~Q&Co>Sg:C dz*+Vt&waEp*BpqrVv,ohi>ZG!<ux_2lu(_s}5
zO8 >+uYnh_Y;3%=
JDTSQ 7XO,kI1XoZ?j8Lpq+9Y#93kQr6"j}N`r{
BDTHB?CyI{Ito,=z}R?*l^oEqAuQ,6T[Q(?/r
t\8gARnCIrXT=3`)QA6W oGDAH)iWta_0fzz#^U,vx@2HlNwq\/	"FU5*~
iEm[d/l=~R	7{㛶4`{ކ<[~\+k)Jmk
h=[dPt.^B:E'b[bn;;e'ftNM
h{[&IifWwm!c'N%";~UPQe:Rs6\&i"^ILh`3Rh	bRhTXv\!z2?n`;T9k8pEWv@lBQT4j#CRGb[MA| BCg 'M?]C
_>h4RW;2bhig0V"8jw+z/Vo49/67%Qyo,P
w\\I*f;@	O65n<.?7j GI~VEZuwQ)nrxG`\)S\n{jo>Evx=(
]x%jaHan'E)_e:8NQBe_'.'0yZWB	"ZjA+T=MT3fQ+6
G5$MvjK=0<[\<z!1|)yTPhzdXZc0K3f-
L:*O>E*~4?Py2M;}=US($gS93ZcI}:s\OxBmzh:?A)ZY!FKG"LKr ~^z^'pewp6V}y$
x}W_]XZhh*
\-}eTa>
qVFExq-61hB]:H:5PkUJhPgGB/C"-&z~S(_IV-T-jz\,H6o2~k`MR '
|JKA.,Npx4yf/?U& 	3qy4@'$1?w"!a(6~<b*NUstH(2K'RL<|	y]ClS${2Fg[Ap:xG-VypV?)8`K|R\=)3?
L)T4YxF }ESQ)->qBRt#(pmCvff:[k3&C:`XAefX
tqq|8Gm#N	aXoDm:,JO;EJ 0Ac1t1
FL3.gN&T4tJ}T[A'XoZ!{kc<4N0B$P:1bD)?Xa#4Cc$hKpDxi"b	i*:oSTQqK)lVr,m()6c3NG(>I'AOzPd8HAo_DH!J'kUy>\_x~D8uvxE]X)=
2ARw
%yEbiJ(VZW8	l'
#K{uvFZG)%cu4X
1 Q.m3q2Tc )PEfo 
Y};C>e#PcH;k(P<umUCb^Nl`CZRBy&g
/<H2	}k QG_g\aw:ta4`eC",r=,6
K=JH2L]iJ5q_!g,6 q>c_ m9h?g(S@Qx_L&R2Z:5+lO!QH.WaWcWJ]N2c[uvX_
[=Q(K
B	ibc)2gs
3pmY|KIwhy)
8%:G5*{t*c&+{O$N>`27dY?=]
T0ej'3{06*r

kY}Pc)l.O,IF2rzPdn)@,"_oJo)AT(`
RQ{:}rH-&iuN+Nb4	^HC'@AnZ`][JBs0SuB~xAGQVx
ih$OjaeaTtdkL7$7'e_#1&0c*I g 
Oh.:0QT|erh{J6`HZ5C`8C0O,@i{q:e#YrZuor[87N+BdSW8/T_:*d+].u]#M(SB2,?=$-AKMX4
nn\E1&cb*-k-ac[[x~:k-L(DR{V8LS[;)Zk YJefG1UT;GW,} {
E,:Y/ dE>6*fnC%
 9%9AM3eGuB_PGEEU<chw}SNX8.
W']&Ic
#GNb[C9XCbTcH@0C)w
T2Zf[0c-\ev7:bz4|9#E@W/X2ZGpd^gqz,_!s"Ws0ڳueϿIx0nRRoAju;,?Myt{vgiEE`Tԉc9Z
G#Tt%7.Fn`ZOXz[#ydV==]/e uZ C$*cclXt"KH,O]TVU>OXA"+(`p$|BLt&8jJW?hy4lY-jF,7)z`"\
.Ypm,pUhV3+e
+ '0x-C&9	:Q	'"	>;I#K
u2TXwM<jCM~KF\s+`C`<X<']FPLqj	R6Or'wK5XUFibdV7zBLJMc:y۷^e!IX9+bW_'/	.(o
_nmaVZHsOo|{tiGec(rat-C!oA 7e t-RS:$R '`                                                                                                                   5                        T1; $      RTI020.J                       &<  =  '[STANVICK.SEAS$WORK_294000DB]SIMQ.FOR;1                                                                                        H     	                         m             IGINAL CONSTANTS (LENGTH N). THESE ARE< C               REPLACED BY FINAL SOLUTION VALUES, VECTOR X.F C           N - NUMBER OF EQUATIONS AND VARIABLES. N MUST BE .GT. ONE. C           KS - OUTPUT DIGIT ( C                0 FOR A NORMAL SOLUTION2 C                1 FOR A SINGULAR SET OF EQUATIONS C  C        REMARKS% C           MATRIX A MUST BE GENERAL. D C           IF MATRIX IS SINGULAR , SOLUTION VALUES ARE MEANINGLESS.C C           AN ALTERNATIVE SOLUTION MAY BE OBTAINED BY USING MATRIX 8 C           INVERSION (MINV) AND MATRIX PRODUCT (GMPRD). C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           METHOD OF SOLUTION IS BY ELIMINATION USING LARGEST PIVOTALH C           DIVISOR. EACH STAGE OF ELIMINATION CONSISTS OF INTERCHANGINGB C           ROWS WHEN NECESSARY TO AVOID DIVISION BY ZERO OR SMALL C           ELEMENTS. @ C           THE FORWARD SOLUTION TO OBTAIN VARIABLE N IS DONE INB C           N STAGES. THE BACK SOLUTION FOR THE OTHER VARIABLES ISB C           CALCULATED BY SUCCESSIVE SUBSTITUTIONS. FINAL SOLUTIONF C           VALUES ARE DEVELOPED IN VECTOR B, WITH VARIABLE 1 IN B(1),< C           VARIABLE 2 IN B(2),........, VARIABLE N IN B(N).B C           IF NO PIVOT CAN BE FOUND EXCEEDING A TOLERANCE OF 0.0,F C           THE MATRIX IS CONSIDERED SINGULAR AND KS IS SET TO 1. THISG C           TOLERANCE CAN BE MODIFIED BY REPLACING THE FIRST STATEMENT.  C H C     .................................................................. C        SUBROUTINE SIMQ(A,B,N,KS)        DIMENSION A(1),B(1)  C  C        FORWARD SOLUTION  C 
       TOL=0.0 
       KS=0       JJ=-N        DO 65 J=1,N        JY=J+1       JJ=JJ+N+1        BIGA=0
       IT=JJ-J        DO 30 I=J,N  C 1 C        SEARCH FOR MAXIMUM COEFFICIENT IN COLUMN  C 
       IJ=IT+I '       IF(ABS(BIGA)-ABS(A(IJ))) 20,30,30     20 BIGA=A(IJ)       IMAX=I    30 CONTINUE C = C        TEST FOR PIVOT LESS THAN TOLERANCE (SINGULAR MATRIX)  C         IF(ABS(BIGA)-TOL) 35,35,40
    35 KS=1       RETURN C & C        INTERCHANGE ROWS IF NECESSARY C     40 I1=J+N*(J-2)       IT=IMAX-J        DO 50 K=J,N 
       I1=I1+N        I2=I1+IT       SAVE=A(I1)       A(I1)=A(I2)        A(I2)=SAVE C / C        DIVIDE EQUATION BY LEADING COEFFICIENT  C     50 A(I1)=A(I1)/BIGA       SAVE=B(IMAX)       B(IMAX)=B(J)       B(J)=SAVE/BIGA C   C        ELIMINATE NEXT VARIABLE C        IF(J-N) 55,70,55    55 IQS=N*(J-1)        DO 65 IX=JY,N        IXJ=IQS+IX
       IT=J-IX        DO 60 JX=JY,N        IXJX=N*(JX-1)+IX       JJX=IXJX+IT %    60 A(IXJX)=A(IXJX)-(A(IXJ)*A(JJX))     65 B(IX)=B(IX)-(B(J)*A(IXJ))  C  C        BACK SOLUTION C     70 NY=N-1       IT=N*N       DO 80 J=1,NY
       IA=IT-J        IB=N-J
       IC=N       DO 80 K=1,J        B(IB)=B(IB)-A(IA)*B(IC) 
       IA=IA-N 
    80 IC=IC-1        RETURN	       END                                                                                                                                                                       & * [STANVICK.SEAS$WORK_294000DB]SMO.FOR;1 +  , 6   .     /     4 H       z                    - =    0   1    2   3      K  P   W   O     5 -  6 7
A  7 `S$A  8          9          G    H  J             
             C H C     .................................................................. C  C        SUBROUTINE SMO  C  C        PURPOSE6 C           TO SMOOTH OR FILTER SERIES A BY WEIGHTS W. C  C        USAGE" C           CALL SMO (A,N,W,M,L,R) C " C        DESCRIPTION OF PARAMETERSE C           A - INPUT VECTOR OF LENGTH N CONTAINING TIME SERIES DATA. # C           N - LENGTH OF SERIES A. < C           W - INPUT VECTOR OF LENGTH M CONTAINING WEIGHTS.C C           M - NUMBER OF ITEMS IN WEIGHT VECTOR.  M MUST BE AN ODD @ C               INTEGER.  (IF M IS AN EVEN INTEGER, ANY FRACTIOND C               RESULTING FROM THE CALCULATION OF (L*(M-1))/2 IN (1)1 C               AND (2) BELOW WILL BE TRUNCATED.) H C           L - SELECTION INTEGER.  FOR EXAMPLE, L=12 MEANS THAT WEIGHTSB C               ARE APPLIED TO EVERY 12-TH ITEM OF A.  L=1 APPLIESD C               WEIGHTS TO SUCCESSIVE ITEMS OF A.  FOR MONTHLY DATA,H C               L=12 GIVES YEAR-TO-YEAR AVERAGES AND L=1 GIVES MONTH-TO- C               MONTH AVERAGES. E C           R - OUTPUT VECTOR OF LENGTH N.  FROM IL TO IH ELEMENTS OF D C               THE VECTOR R ARE FILLED WITH THE SMOOTHED SERIES AND/ C               OTHER ELEMENTS WITH ZERO, WHERE ; C                    IL=(L*(M-1))/2+1  ................ (1) ; C                    IH=N-(L*(M-1))/2  ................ (2)  C  C        REMARKSB C           N MUST BE GREATER THAN OR EQUAL TO THE PRODUCT OF L*M. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           REFER TO THE ARTICLE 'FORTRAN SUBROUTINES FOR TIME SERIES F C           ANALYSIS', BY J. R. HEALY AND B. P. BOGERT, COMMUNICATIONS- C           OF ACM, V.6, NO.1, JANUARY, 1963.  C H C     .................................................................. C "       SUBROUTINE SMO (A,N,W,M,L,R)       DIMENSION A(1),W(1),R(1) C  C     INITIALIZATION C        DO 110 I=1,N   110 R(I)=0.0       IL=(L*(M-1))/2+1       IH=N-(L*(M-1))/2 C " C     SMOOTH SERIES A BY WEIGHTS W C        DO 120 I=IL,IH       K=I-IL+1       DO 120 J=1,M       IP=(J*L)-L+K   120 R(I)=R(I)+A(IP)*W(J)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]SMPRT.COM;1 +  , 	1   .     /     4 -                          - =    0   1    2   3      K  P   W   O     5 -  6 @@  7 6$A  8          9          G    H  J                       - $ COPY IN$:SMPRT.FOR,POLRT.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  6                         $      RTI020.J                       
6  =  ([STANVICK.SEAS$WORK_294000DB]SMPRT.DAT;1                                                                                       F                                             ( * [STANVICK.SEAS$WORK_294000DB]SMPRT.DAT;1 +  , 
6   .     /     4 F                           - =    0   1    2   3      K  P   W   O     5 -  6 A  7 "$A  8          9          G    H  J                       
   360   09F      -1.0                                                          1.0                            1.0
     0    0                                                                                                                                                                                                                                                                                                                                                                                                              ( * [STANVICK.SEAS$WORK_294000DB]SMPRT.FOR;1 +  , 
   .     /     4 E                         - =    0   1    2   3      K  P   W   O     5 -  6  % A  7 i7$A  8          9          G    H  J                       ; C	SAMPLE PROGRAM FOR REAL AND COMPLEX ROOTS OF A REAL POLY-  C	NOMIAL - SMPRT C  C	REVISED 10-OCT-85 S. JAIN C C	  PUT IN CALL TO ERRSET TO MAKE FLOATING OVERFLOW ERROR NON-FATAL  C * 	DIMENSION A(37),W(37),ROOTR(37),ROOTI(37). 	DATA IFOVF/72/			!** SJ - FLTOVF_F ERROR CODE 10	FORMAT(1X,I4,3X,I2)E 30	FORMAT(////62H REAL AND COMPLEX ROOTS OF A POLYNOMIAL USING SUBROU D 	1TINE POLRT///17H FOR POLYNOMIAL  ,I4,2X,10HOF ORDER  ,I2//27H THE  	2INPUT COEFFICIENTS ARE//)  40	FORMAT(7F10.0)  50	FORMAT(6E16.7) 4 65	FORMAT(////34H ORDER OF POLYNOMIAL LESS THAN ONE)6 77	FORMAT(////36H ORDER OF POLYNOMIAL GREATER THAN 36)1 79	FORMAT(////31H HIGH ORDER COEFFICIENT IS ZERO) D 85	FORMAT(////50H UNABLE TO DETERMINE ROOT. THOSE ALREADY FOUND ARE)2 95	FORMAT(////5X,9HREAL ROOT,6X,12HCOMPLEX ROOT//) 97	FORMAT(2E16.7) 0 C	MAKE FLOATING OVERFLOW ERRORS NON-FATAL	!** SJ2 	CALL ERRSET(IFOVF,.TRUE.,.FALSE.,,.FALSE.)	!** SJ C  **MY IS INPUT CHANNEL 	MY=1 7 	OPEN (UNIT=1,NAME='IN$:SMPRT.DAT',TYPE='OLD',READONLY)  5	READ(MY,10) ID,IORD  	IF(ID+IORD) 100,100,20  20	TYPE 30, ID,IORD 	 	J=IORD+1  	READ(MY,40) (A(I),I=1,J)  	TYPE 50, (A(I),I=1,J)% 	CALL POLRT(A,W,IORD,ROOTR,ROOTI,IER)  	IF(IER-1) 90,60,70 
 60	TYPE 65 	GO TO 5 70	IF(IER-3) 75,80,78 
 75	TYPE 77 	GO TO 5
 78	TYPE 79 	GO TO 5
 80	TYPE 85
 90	TYPE 95 	DO 96 I=1,IORD  96	TYPE 97,ROOTR(I),ROOTI(I) 	GO TO 5 100	STOP 'SMPRT successful!' 	END                                                                                                                                  ' * [STANVICK.SEAS$WORK_294000DB]SMPY.FOR;1 +  , 
R   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @K!A  7 ?K$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SMPY C  C        PURPOSEC C           MULTIPLY EACH ELEMENT OF A MATRIX BY A SCALAR TO FORM A  C           RESULTANT MATRIX C  C        USAGE# C           CALL SMPY(A,C,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX C           C - SCALAR% C           R - NAME OF OUTPUT MATRIX 0 C           N - NUMBER OF ROWS IN MATRIX A AND R3 C           M - NUMBER OF COLUMNS IN MATRIX A AND R G C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD : C           SCALAR IS MULTIPLIED BY EACH ELEMENT OF MATRIX C H C     .................................................................. C #       SUBROUTINE SMPY(A,C,R,N,M,MS)        DIMENSION A(1),R(1)  C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C  C        MULTIPLY BY SCALAR  C        DO 1 I=1,IT      1 R(I)=A(I)*C        RETURN	       END                                                                                                                                                                                                                                                                                                                           ) * [STANVICK.SEAS$WORK_294000DB]SOLVEN.COM;1 +  ,    .     /     4 @                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7 _$A  8          9          G    H  J                      @ $ COPY IN$:SOLVEN.FOR,GMPRD.FOR,MINV.FOR,SIMQ.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                            ) * [STANVICK.SEAS$WORK_294000DB]SOLVEN.FOR;1 +  , 6   .     /     4 ?       ,                  - =    0   1    2   3      K  P   W   O     5 -  6  o"A  7  r$A  8          9          G    H  J                      5 C	SOLVEN.FOR - SAMPLE PROGRAM USING MATRICES TO TEST:  C  MINV		- MATRIX INVERSION 1 C  GMPRD	- GENERAL MATRIX (MODE 0) MULTIPLICATION 4 C  SIMQ		- SOLUTION OF SIMULTANEOUS LINEAR EQUATIONS C  C	REVISED 10-OCT-85 S. JAIN 8 C	  MODIFY CALL STATEMENT TO SIMQ SO THAT DUMMY VARIABLE7 C	  IDUMMY IS USED INSTEAD OF THE CONSTANT 0 AS THE 4TH 5 C	  ARGUMENT TO SIMQ.  THIS IS NECESSARY BECAUSE SIMQ ) C	  RETURNS A VALUE FOR THE 4TH ARGUMENT.  C 2 	DIMENSION A(3,3),X1(3),X2(3),B(3),C(3,3),D(10,10)0 	DATA A/2.,1.,3.,3.,5.,-1.,1.,2.,1./,B/0.,6.,2./ C  	DO 1 I=1,3  	DO 1 J=1,3  1	C(I,J)=A(I,J)  C	COPY THE ARRAY A INTO C  C  C	MINV 	CALL MINV(A,3,DETA,X1,X2)& 	TYPE 100, ((C(I,J),J=1,3),B(I),I=1,3)? 100	FORMAT(/' USE OF MINV'//' (',3F8.3,' ) ( X )   (',F8.3,')'/ 0 	1' (',3F8.3,' ) ( Y ) = (',F8.3,')'/' (',3F8.3, 	2' ) ( Z )   (',F8.3,')'//)! 	TYPE 101, ((A(I,J),J=1,3),I=1,3) - 101	FORMAT(' INVERSE OF COEFFICIENT MATRIX'//  	13(' (',3F8.3,' )'/)) C  C	GMPRD  	CALL GMPRD(A,B,X1,3,3,1) 
 	TYPE 102, X1 7 102	FORMAT(/' MULTIPLYING INVERSE BY CONSTANT VECTOR:'/ + 	1' X =',F8.3,/' Y =',F8.3,/' Z =',F8.3,//)  C  C	SIMQ C*	CALL SIMQ(C,B,3,0)   	CALL SIMQ(C,B,3,IDUMMY)		!** SJ 	TYPE 103, B) 103	FORMAT(/' USE OF SIMQ FOR SOLUTION:'/ % 	1' X ='F8.3/' Y ='F8.3/' Z ='F8.3//)  	STOP 'SOLVEN successful!' 	END                                                                                                                                                                                                                                  ( * [STANVICK.SEAS$WORK_294000DB]SRANK.FOR;1 +  ,    .     /     4 H       b                    - =    0   1    2   3      K  P   W   O     5 -  6 E#A  7 H$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE SRANK  C  C        PURPOSEG C           TEST CORRELATION BETWEEN TWO VARIABLES BY MEANS OF SPEARMAN ( C           RANK CORRELATION COEFFICIENT C  C        USAGE+ C           CALL SRANK(A,B,R,N,RS,T,NDF,NR)  C " C        DESCRIPTION OF PARAMETERSC C           A   - INPUT VECTOR OF N OBSERVATIONS FOR FIRST VARIABLE D C           B   - INPUT VECTOR OF N OBSERVATIONS FOR SECOND VARIABLEH C           R   - OUTPUT VECTOR FOR RANKED DATA, LENGTH IS 2*N. SMALLESTD C                 OBSERVATION IS RANKED 1, LARGEST IS RANKED N. TIES5 C                 ARE ASSIGNED AVERAGE OF TIED RANKS. ( C           N   - NUMBER OF OBSERVATIONS@ C           RS  - SPEARMAN RANK CORRELATION COEFFICIENT (OUTPUT)5 C           T   - TEST OF SIGNIFICANCE OF RS (OUTPUT) 7 C           NDF - NUMBER OF DEGREES OF FREEDOM (OUTPUT) D C           NR  - CODE, 0 FOR UNRANKED DATA IN A AND B, 1 FOR RANKED) C                 DATA IN A AND B (INPUT)  C  C        REMARKS2 C           T IS SET TO ZERO IF N IS LESS THAN TEN C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           RANK C           TIE  C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956, C           CHAPTER 9  C H C     .................................................................. C +       SUBROUTINE SRANK(A,B,R,N,RS,T,NDF,NR)        DIMENSION A(1),B(10                                                                   7                        ,= $      RTI020.J                         =  ([STANVICK.SEAS$WORK_294000DB]SRANK.FOR;1                                                                                       H                              PW             ),R(1) C        FNNN=N*N*N-N C ) C        DETERMINE WHETHER DATA IS RANKED  C        IF(NR-1) 5, 10, 5  C B C        RANK DATA IN A AND B VECTORS AND ASSIGN TIED OBSERVATIONS C        AVERAGE OF TIED RANKS C      5 CALL RANK (A,R,N)        CALL RANK (B,R(N+1),N)       GO TO 40 C % C        MOVE RANKED DATA TO R VECTOR  C     10 DO 20 I=1,N     20 R(I)=A(I)        DO 30 I=1,N        J=I+N     30 R(J)=B(I)  C 3 C        COMPUTE SUM OF SQUARES OF RANK DIFFERENCES  C     40 D=0.0        DO 50 I=1,N        J=I+N !    50 D=D+(R(I)-R(J))*(R(I)-R(J))  C ! C        COMPUTE TIED SCORE INDEX  C 
       KT=1       CALL TIE (R,N,KT,TSA)         CALL TIE (R(N+1),N,KT,TSB) C 6 C        COMPUTE SPEARMAN RANK CORRELATION COEFFICIENT C        IF(TSA) 60,55,60    55 IF(TSB) 60,57,60    57 RS=1.0-6.0*D/FNNN        GO TO 70    60 X=FNNN/12.0-TSA        Y=X+TSA-TSB "       RS=(X+Y-D)/(2.0*(SQRT(X*Y))) C > C        COMPUTE T AND DEGREES OF FREEDOM IF N IS 10 OR LARGER C        T=0.0     70 IF(N-10) 80,75,75 '    75 T=RS*SQRT(FLOAT(N-2)/(1.0-RS*RS)) 
    80 NDF=N-2        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]SRMA.FOR;1 +  ,    .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 $A  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SRMA C  C        PURPOSEE C           MULTIPLY ROW OF MATRIX BY A SCALAR AND ADD TO ANOTHER ROW  C           OF THE SAME MATRIX C  C        USAGE$ C           CALL SRMA(A,C,N,M,LA,LB) C " C        DESCRIPTION OF PARAMETERS C           A  - NAME OF MATRIX  C           C  - SCALAR $ C           N  - NUMBER OF ROWS IN A' C           M  - NUMBER OF COLUMNS IN A 4 C           LA - ROW IN A TO BE MULTIPLIED BY SCALAR3 C           LB - ROW IN A TO WHICH PRODUCT IS ADDED G C                IF 0 IS SPECIFIED, PRODUCT REPLACES ELEMENTS IN ROW LA  C  C        REMARKS- C           MATRIX A MUST BE A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD D C           EACH ELEMENT OF ROW LA IS MULTIPLIED BY SCALAR C AND THED C           PRODUCT IS ADDED TO THE CORRESPONDING ELEMENT OF ROW LB.7 C           ROW LA REMAINS UNAFFECTED BY THE OPERATION. G C           IF PARAMETER LB CONTAINS ZERO, MULTIPLICATION BY THE SCALAR E C           IS PERFORMED AND THE PRODUCT REPLACES ELEMENTS IN ROW LA.  C H C     .................................................................. C $       SUBROUTINE SRMA(A,C,N,M,LA,LB)       DIMENSION A(1) C        LAJ=LA-N       LBJ=LB-N       DO 3 J=1,M C $ C        LOCATE ELEMENT IN BOTH ROWS C        LAJ=LAJ+N        LBJ=LBJ+N  C  C        CHECK LB FOR ZERO C        IF(LB) 1,2,1 C : C        IF NOT, MULTIPLY BY CONSTANT AND ADD TO OTHER ROW C      1 A(LBJ)=A(LAJ)*C+A(LBJ)
       GO TO 3  C , C        OTHERWISE, MULTIPLY ROW BY CONSTANT C      2 A(LAJ)=A(LAJ)*C      3 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                       - * [STANVICK.SEAS$WORK_294000DB]SSPSTARTUP.COM;1 +  ,    .     /     4 J                          - =    0   1    2   3      K  P   W   O     5   6  A^  7 {$A  8          9          G    H  J                  6 $ !                        S S P S T A R T U P . C O M $ ! 4 $ !                            COPYRIGHT (C) 1986 BY9 $ !                        DIGITAL EQUIPMENT CORPORATION, 5 $ !                           MAYNARD, MASSACHUSETTS. 4 $ !                             ALL RIGHTS RESERVED. $ ! J $ !       THIS  SOFTWARE  IS FURNISHED UNDER A LICENSE AND MAY BE USED ANDJ $ !       COPIED ONLY IN ACCORDANCE WITH THE TERMS  OF  SUCH  LICENSE  ANDJ $ !       WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWAREJ $ !       OR ANY OTHER COPIES THEREOF MAY NOT  BE  PROVIDED  OR  OTHERWISEJ $ !       MADE AVAILABLE TO ANY OTHER PERSON. NO TITLE TO AND OWNERSHIP OF- $ !       THE SOFTWARE IS HEREBY TRANSFERRED.  $ ! J $ !       THE INFORMATION IN THIS SOFTWARE IS SUBJECT  TO  CHANGE  WITHOUTJ $ !       NOTICE  AND  SHOULD  NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL  $ !       EQUIPMENT CORPORATION. $ ! J $ !       DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR RELIABILITY  OFD $ !       ITS SOFTWARE ON EQUIPMENT THAT IS NOT SUPPLIED BY DIGITAL. $ ! ; $ !                     Define System Logical Names for SSP  $ ! @ $ ! DEFINE/SYSTEM/EXEC	SYS$UNSUPPORTED	SYS$SYSROOT:[UNSUPPORTED]= $ ! DEFINE/SYSTEM/EXEC	SYS$SSP		SYS$SYSROOT:[UNSUPPORTED.SSP]  $ EXIT                                                                                                                                                                                                                                                                                  , * [STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1 +  ,    .    /     4  U                         - =    0   1    2   3      K  P   W   O    5 -  6 Q?  7  _$A  8          9          G    H  J       
             
 
 
 
 
 
 
 
 
 
 
 
 
 
 
3                            Scientific Subroutines
 6                        Programmer's Reference Manual
 
 
 
 
 
.                                February 1986
 
 
 
<                   This document describes  the  Scientific
<                   Subroutines  Package  (SSP) available to
)                   users of Labpak V1.0.
  
<                   This document is an edited  and  revised
;                                     __________ ___________
 <                   version  of  the  Scientific Subroutines
3                   ____________  _________   ______
 <                   Programmer's  Reference   Manual   dated
<                   October  1984.   It  is intended for use
<                   only by users  of  Labpak  V1.0  running
2                   under MicroVMS V4.2 and later.
 
 
?                   OPERATING SYSTEM:   MicroVMS V4.2 and later
  
0                   SOFTWARE:           SSP V1.3
 
 
 
 
 
 
B            digital equipment corporation. maynard, massachusetts
  K                                                                   Page ii
  
 
K                                                        Special Issue 1986
  
 
K    The information in this document is subject to change  without  notice
 K    and  should  not  be  construed  as  a commitment by Digital Equipment
 K    Corporation.  Digital Equipment Corporation assumes no  responsibility
 3    for any errors that may appear in this manual.
  
K    The software described in this document is public domain software  and
      is provided free of charge.
 
K    No responsibility is assumed for the use or reliability of software on
 K    equipment that is not supplied by DIGITAL or its affiliated companies.
  
C    The following are trademarks of Digital Equipment Corporation:
  
?            DEC                         MASSBUS            RSX
 >            DECmate                     PDP                RT
B            DECsystem-10                P/OS               UNIBUS
?            DECSYSTEM-20                Professional       VAX
 ?            DECUS                       Q-BUS              VMS
 >            DECwriter                   Rainbow            VT
J            DIBOL                       RSTS               Work Processor
 
  K                                                                  Page iii
  
 
0                                       CONTENTS
 
                                                                                                                                                                                                                                                                                                                                                                                                                     8                        1y $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "             PREFACE
 
 
    CHAPTER 1       OVERVIEW
  
K                    THE SCIENTIFIC SUBROUTINES PACKAGE . . . . . . . . 1-1
 K                      Subroutine Arrays  . . . . . . . . . . . . . . . 1-2
 G                      The Scientific Subroutines Package Distribution 
 K                      Kit  . . . . . . . . . . . . . . . . . . . . . . 1-2
  
 
,    CHAPTER 2       STATISTICAL SUBROUTINES
 
K                    DATA SCREENING ROUTINES  . . . . . . . . . . . . . 2-1
 K                      ABSNT Subroutine . . . . . . . . . . . . . . . . 2-1
 K                      BOUND Subroutine . . . . . . . . . . . . . . . . 2-2
 K                      SUBMX Subroutine . . . . . . . . . . . . . . . . 2-3
 K                      SUBST Subroutine . . . . . . . . . . . . . . . . 2-3
 K                      TAB1 Subroutine  . . . . . . . . . . . . . . . . 2-5
 K                      TAB2 Subroutine  . . . . . . . . . . . . . . . . 2-6
 K                      TALLY Subroutine . . . . . . . . . . . . . . . . 2-7
 K                    ELEMENTARY STATISTICS SUBROUTINES  . . . . . . . . 2-8
 K                      MOMEN Subroutine . . . . . . . . . . . . . . . . 2-8
 K                      TTSTT Subroutine . . . . . . . . . . . . . . . . 2-9
 K                    CORRELATION SUBROUTINE . . . . . . . . . . . . .  2-10
 K                      CORRE Subroutine . . . . . . . . . . . . . . .  2-10
 K                    MULTIPLE LINEAR REGRESSION SUBROUTINES . . . . .  2-11
 K                      MULTR Subroutine . . . . . . . . . . . . . . .  2-12
 K                      ORDER Subroutine . . . . . . . . . . . . . . .  2-13
 K                    POLYNOMIAL REGRESSION SUBROUTINE . . . . . . . .  2-14
 K                      GDATA Subroutine . . . . . . . . . . . . . . .  2-14
 K                    CANONICAL CORRELATION SUBROUTINES  . . . . . . .  2-15
 K                      CANOR Subroutine . . . . . . . . . . . . . . .  2-15
 K                      NROOT Subroutine . . . . . . . . . . . . . . .  2-16
 K                    ANALYSIS OF VARIANCE SUBROUTINES . . . . . . . .  2-17
 K                      AVCAL Subroutine . . . . . . . . . . . . . . .  2-17
 K                      AVDAT Subroutine . . . . . . . . . . . . . . .  2-17
 K                      MEANQ Subroutine . . . . . . . . . . . . . . .  2-18
 K                    DISCRIMINANT ANALYSIS SUBROUTINES  . . . . . . .  2-19
 K                      DISCR Subroutine . . . . . . . . . . . . . . .  2-19
 K                      DMATX Subroutine . . . . . . . . . . . . . . .  2-21
 K                    FACTOR ANALYSIS SUBROUTINES  . . . . . . . . . .  2-22
 K                      LOAD Subroutine  . . . . . . . . . . . . . . .  2-22
 K                      TRACE Subroutine . . . . . . . . . . . . . . .  2-22
 K                      VARMX Subroutine . . . . . . . . . . . . . . .  2-23
 K                    TIME SERIES SUBROUTINES  . . . . . . . . . . . .  2-24
 K                      AUTO Subroutine  . . . . . . . . . . . . . . .  2-24
 K                      CROSS Subroutine . . . . . . . . . . . . . . .  2-25
 K                      EXSMO Subroutine . . . . . . . . . . . . . . .  2-25
 K                      SMO Subroutine . . . . . . . . . . . . . . . .  2-26
 K                    NONPARAMETRIC STATISTICAL SUBROUTINES  . . . . .  2-27
 K                      CHISQ Subroutine . . . . . . . . . . . . . . .  2-27
 K                      KRANK Subroutine . . . . . . . . . . . . . . .  2-28
   K                                                                   Page iv
  
 
K                      QTEST Subroutine . . . . . . . . . . . . . . .  2-29
 K                      RANK Subroutine  . . . . . . . . . . . . . . .  2-29
 K                      SRANK Subroutine . . . . . . . . . . . . . . .  2-30
 K                      TIE Subroutine . . . . . . . . . . . . . . . .  2-30
 K                      TWOAV Subroutine . . . . . . . . . . . . . . .  2-31
 K                      UTEST Subroutine . . . . . . . . . . . . . . .  2-32
 K                      WTEST Subroutine . . . . . . . . . . . . . . .  2-33
 K                    RANDOM NUMBER GENERATOR SUBROUTINE . . . . . . .  2-33
 K                      GAUSS Subroutine . . . . . . . . . . . . . . .  2-33
 K                    REFERENCES . . . . . . . . . . . . . . . . . . .  2-34
  
 
,    CHAPTER 3       MATHEMATICAL OPERATIONS
 
K                    SPECIAL MATRIX OPERATIONS SUBROUTINES  . . . . . . 3-1
 K                      EIGEN Subroutine . . . . . . . . . . . . . . . . 3-1
 K                      MINV Subroutine  . . . . . . . . . . . . . . . . 3-2
 K                    MATRIX SUBROUTINES . . . . . . . . . . . . . . . . 3-2
 K                      ARRAY Subroutine . . . . . . . . . . . . . . . . 3-2
 K                      CADD Subroutine  . . . . . . . . . . . . . . . . 3-3
 K                      CCPY Subroutine  . . . . . . . . . . . . . . . . 3-4
 K                      CCUT Subroutine  . . . . . . . . . . . . . . . . 3-5
 K                      CINT Subroutine  . . . . . . . . . . . . . . . . 3-6
 K                      CSRT Subroutine  . . . . . . . . . . . . . . . . 3-6
 K                      CSUM Subroutine  . . . . . . . . . . . . . . . . 3-7
 K                      CTAB Subroutine  . . . . . . . . . . . . . . . . 3-8
 K                      CTIE Subroutine  . . . . . . . . . . . . . . . . 3-9
 K                      DCLA Subroutine  . . . . . . . . . . . . . . .  3-10
 K                      DCPY Subroutine  . . . . . . . . . . . . . . .  3-10
 K                      GMADD Subroutine . . . . . . . . . . . . . . .  3-11
 K                      GMPRD Subroutine . . . . . . . . . . . . . . .  3-12
 K                      GMSUB Subroutine . . . . . . . . . . . . . . .  3-12
 K                      GMTRA Subroutine . . . . . . . . . . . . . . .  3-13
 K                      GTPRD Subroutine . . . . . . . . . . . . . . .  3-13
sK                      LOC Subroutine . . . . . . . . . . . . . . . .  3-14
 K                      MADD Subroutine  . . . . . . . . . . . . . . .  3-15
 K                      MATA Subroutine  . . . . . . . . . . . . . . .  3-16
_K                      MCPY Subroutine  . . . . . . . . . . . . . . .  3-16
 K                      MFUN Subroutine  . . . . . . . . . . . . . . .  3-17

K                      MPRD Subroutine  . . . . . . . . . . . . . . .  3-18
 K                      MSTR Subroutine  . . . . . . . . . . . . . . .  3-19
TK                      MSUB Subroutine  . . . . . . . . . . . . . . .  3-20
SK                      MTRA Subroutine  . . . . . . . . . . . . . . .  3-21
aK                      RADD Subroutine  . . . . . . . . . . . . . . .  3-22
 K                      RCPY Subroutine  . . . . . . . . . . . . . . .  3-23
 K                      RCUT Subroutine  . . . . . . . . . . . . . . .  3-23
nK                      RECP Subroutine  . . . . . . . . . . . . . . .  3-24
dK                      RINT Subroutine  . . . . . . . . . . . . . . .  3-25
tK                      RSRT Subroutine  . . . . . . . . . . . . . . .  3-25
 K                      RSUM Subroutine  . . . . . . . . . . . . . . .  3-26
dK                      RTAB Subroutine  . . . . . . . . . . . . . . .  3-27
iK                      RTIE Subroutine  . . . . . . . . . . . . . . .  3-28
aK                      SADD Subroutine  . . . . . . . . . . . . . . .  3-29
oK                      SCLA Subroutine  . . . . . . . . . . . . . . .  3-29
 K                      SCMA Subroutine  . . . . . . . . . . . . . . .  3-30
   K                                                                    Page v
  
 
K                      SDIV Subroutine  . . . . . . . . . . . . . . .  3-30
 K                      SMPY Subroutine  . . . . . . . . . . . . . . .  3-31
 K                      SRMA Subroutine  . . . . . . . . . . . . . . .  3-32
 K                      SSUB Subroutine  . . . . . . . . . . . . . . .  3-32
 K                      TPRD Subroutine  . . . . . . . . . . . . . . .  3-33
 K                      XCPY Subroutine  . . . . . . . . . . . . . . .  3-34
1K                    INTEGRATION AND DIFFERENTIATION SUBROUTINES  . .  3-35
 K                      QATR Subroutine  . . . . . . . . . . . . . . .  3-35
 K                      QSF Subroutine . . . . . . . . . . . . . . . .  3-36
gK                      RKGS Subroutine  . . . . . . . . . . . . . . .  3-37
 K                      RK1 Subroutine . . . . . . . . . . . . . . . .  3-39
 K                      RK2 Subroutine . . . . . . . . . . . . . . . .  3-40
 K                                                                                                                                                                                                                                                              9                        ZO $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "                     FOURIER ANALYSIS SUBROUTINES . . . . . . . . . .  3-41
 K                      FORIF Subroutine . . . . . . . . . . . . . . .  3-41
 K                      FORIT Subroutine . . . . . . . . . . . . . . .  3-42
 K                    SPECIAL SUBROUTINE OPERATIONS AND FUNCTIONS  . .  3-43
 K                      BESI Subroutine  . . . . . . . . . . . . . . .  3-43
 K                      BESJ Subroutine  . . . . . . . . . . . . . . .  3-44
 K                      BESK Subroutine  . . . . . . . . . . . . . . .  3-44
 K                      BESY Subroutine  . . . . . . . . . . . . . . .  3-45
 K                      CEL1 Subroutine  . . . . . . . . . . . . . . .  3-46
 K                      CEL2 Subroutine  . . . . . . . . . . . . . . .  3-46
 K                      CS Subroutine  . . . . . . . . . . . . . . . .  3-47
 K                      EXPI Subroutine  . . . . . . . . . . . . . . .  3-47
 K                      GAMMA Subroutine . . . . . . . . . . . . . . .  3-48
 K                      LEP Subroutine . . . . . . . . . . . . . . . .  3-48
 K                      SICI Subroutine  . . . . . . . . . . . . . . .  3-49
 K                    LINEAR EQUATIONS SUBROUTINE  . . . . . . . . . .  3-50
 K                      SIMQ Subroutine  . . . . . . . . . . . . . . .  3-50
 K                    NONLINEAR EQUATIONS SUBROUTINES  . . . . . . . .  3-51
 K                      RTMI Subroutine  . . . . . . . . . . . . . . .  3-51
 K                      RTNI Subroutine  . . . . . . . . . . . . . . .  3-52
 K                      RTWI Subroutine  . . . . . . . . . . . . . . .  3-53
 K                    ROOTS OF POLYNOMIALS SUBROUTINE  . . . . . . . .  3-54
 K                      POLRT Subroutine . . . . . . . . . . . . . . .  3-54
 K                    POLYNOMIAL OPERATIONS SUBROUTINES  . . . . . . .  3-55
 K                      PADD Subroutine  . . . . . . . . . . . . . . .  3-55
 K                      PADDM Subroutine . . . . . . . . . . . . . . .  3-55
 K                      PCLA Subroutine  . . . . . . . . . . . . . . .  3-56
 K                      PCLD Subroutine  . . . . . . . . . . . . . . .  3-57
 K                      PDER Subroutine  . . . . . . . . . . . . . . .  3-57
 K                      PDIV Subroutine  . . . . . . . . . . . . . . .  3-57
 K                      PGCD Subroutine  . . . . . . . . . . . . . . .  3-59
 K                      PILD Subroutine  . . . . . . . . . . . . . . .  3-59
 K                      PINT Subroutine  . . . . . . . . . . . . . . .  3-60
 K                      PMPY Subroutine  . . . . . . . . . . . . . . .  3-60
 K                      PNORM Subroutine . . . . . . . . . . . . . . .  3-61
 K                      PQSD Subroutine  . . . . . . . . . . . . . . .  3-62
 K                      PSUB Subroutine  . . . . . . . . . . . . . . .  3-62
 K                      PVAL Subroutine  . . . . . . . . . . . . . . .  3-63
 K                      PVSUB Subroutine . . . . . . . . . . . . . . .  3-63
 K                    REFERENCES . . . . . . . . . . . . . . . . . . .  3-64

  K                                                                   Page vi
2 
 
:    APPENDIX A      VERIFYING AND USING SSP UNDER VAX/VMS
 
K                    THE INDIRECT-COMMAND FILES . . . . . . . . . . . . A-1
 K                    THE VERIFICATION PROCEDURE . . . . . . . . . . . . A-5
 K                    ERROR CONDITIONS . . . . . . . . . . . . . . . . . A-6
 B                    CREATING A PROGRAM THAT CALLS THE SCIENTIFIC 
K                    SUBROUTINES  . . . . . . . . . . . . . . . . . . . A-6
 K                    STORING THE SCIENTIFIC SUBROUTINES IN A LIBRARY  . A-8
  
 
    TABLES
  
K            A-1     The Indirect-Command Files . . . . . . . . . . . . A-2
   K                                                                  Page vii

 
 
    PREFACE
M    PREFACE
 
 
 
    MANUAL OBJECTIVES
 
<        __________ ___________ ____________ _________ ______
K    The Scientific Subroutines Programmer's Reference Manual describes the
 K    Scientific  Subroutines  Package  (SSP)  available  to users of Labpak
 K    V1.0.  SSP provides over 100 mathematical and statistical  subroutines
 '    you use to analyze real-time data.
  
K    To use this manual, you should be a programmer  familiar  VAX  FORTRAN
 K    and the MicroVMS operating system.  You should also be familiar with a
 K    scientific  laboratory,  should  understand   the   capabilities   and
 K    operation of all instruments in your system, and should have access to
 -    instrument manufacturers' documentation.
R 
 
    MANUAL STRUCTURE
  
@        __________  ___________  ____________  _________  ______
K    The Scientific  Subroutines  Programmer's  Reference  Manual  contains
     three chapters.
 
>    Chapter 1 introduces the scientific subroutines software.
 
5    Chapter 2 describes the statistical subroutines.
  
6    Chapter 3 describes the mathematical subroutines.
 
K    Bibliographies of non-DIGITAL technical publications appear at the end
SK    of Chapters 2 and 3.  Many subroutine descriptions in Chapters 2 and 3
SK    contain  brief  references  to  authors  and  publications  in   these
SK    bibliographies.    For   complete   information  about  a  publication
SK    referenced in a subroutine description, consult  the  bibliography  at
S    the end of that chapter.
  
 
    DOCUMENTATION CONVENTIONS
 
4    The following conventions apply to this manual:
 
K          o  <RET> means you must press the RETURN key  on  your  terminal
p             keyboard.
u 
K          o  <CTRL/x> means you press the "x" key while holding  down  the
oK             key  labeled  CTRL.   For example, hold down the CTRL key and
iB             type the letter C to produce the <CTRL/C> character.
 
K          o  [Square Brackets] enclose optional  arguments  in  subroutine

K             lines.   When  you  use an optional argument, do not type the
t+             brackets in the command line.
  
 
  
  
 
 
 
 
 
 
 
 
 
 

    CHAPTER 1
r    CHAPTER 1
 
    OVERVIEW

    OVERVIEW
  
 
 
=        __________ ___________ ____________ _________  ______
 K    The Scientific Subroutines Programmer's Reference  Manual  accompanies
 K    the   Scientific   Subroutines  Package  (SSP),  a  set  of  over  100
 K    mathematical and statistical subroutines you use to analyze  real-time
 	    dta.
  
K    This manual describes the subroutines and explains  how  to  use  them
 K    with   your  VAX  FORTRAN  programs.   This  document  contains  three
 K    chapters.  This first chapter provides an overview of the  subroutines
 K    available  to  you  and  of the way in which they are described in the
 K    document.  Chapters 2 and 3 contain  descriptions  of  the  scientific
 K    subroutines.   Each  description presents the subroutine call function
 K    and  syntax,  and  defines  all  required  and   optional   subroutine
 K    arguments.  Descriptions of the more complex subroutines in Chapters 2
 K    and 3 include  bibliographical  references.   The  bibliographies  are
 K    presented  at  the  end  of Chapters 2 and 3.  Each bibliography gives
 K    complete  information  about  publications  cited  in  the  subroutine
     descriptions.
 
K    Each description also provides the name for a test program that  calls
 ;    the subroutine.  The test program is named as follows:
M 
&    (Test program:  PROGRAM_NAME.FOR)
 
:    where:  PROGRAM_NAME is the name of the test program.
 
7            .FOR is the VAX FORTRAN program extension.
  
 
 
&    THE SCIENTIFIC SUBROUTINES PACKAGE
'    THE SCIENTIFIC SUBROUTINES PACKAGE
  
K    The Scientific Subroutines Package consists of  over  100  subroutines
 K    that  you  can  call  from  any  VAX FORTRAN program running under the
     MicroVMS operating system.
  
K    Each subroutine in the package performs  a  different  statistical  or
 K    mathematical  operation  commonly  required in scientific programming.
 K    Many of the larger statistical subroutines, however, are programmed as
 K    collections  of  smaller  routines  to let you use them more easily in
     large, overlaid programs.
      OVERVIEW
K    OVERVIEW                                                      Page 1-2
  
 
K    None of the subroutines needs input/output  operations.   All  of  the
 -    subroutines use single-precision values.
n 
K    Many of the subroutines, however, can use dou                                                                                                                                                                                                                                                   :                        t+F $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             : "     (       ble-precision  values  in
UK    calculations  (at  a  loss  of  speed and an increase in memory).  The
 K    individual subroutine source files contain the instructions for making
 K    the  necessary  modifications  to  convert  from  single-precision  to
 #    double-precision calculations.
  
 
 
    Subroutine Arrays
i    Subroutine Arrays
 
K    To save as much memory space as possible,  the  subroutines  use  only
 K    dimension  statements  to access an array.  They do not use them as an
 K    upper limitation on array size.  The subroutines always handle  arrays
 7    as vectors and calculate subscripts when required.
  
K    Three types of arrays are used in scientific programming.   They  are,
 '    in decreasing order of occurrence:
  
C         1.  General matrices, including vectors (storage mode 0).
  
2         2.  Symmetric matrices (storage mode 1).
 
1         3.  Diagonal matrices (storage mode 2).
  
K    Symmetric and diagonal  matrices  require  less  memory  than  general
 J                                                       N    N          N N
K    matrices.   Where  a  general  matrix of the order N by N requires N*N
UJ                                                                 N*(N+1)/2
K    storage locations, a symmetric matrix of the same order uses N*(N+1)/2
S4                                                   N
@    locations, and a diagonal matrix requires only N locations.
 
                   LOC
K    The subroutine LOC calculates most of the  matrix  references  in  the
u"                               LOC
K    scientific  subroutines.   LOC determines the relative position of any
 #                                LOC
SK    element in a vector array.  LOC is supplied as a  FORTRAN  subroutine.
AK    To  increase  execution  speed,  you  could write an assembly-language
u               LOC
    version of LOC.
 
 
 
7    The Scientific Subroutines Package Distribution Kit
 8    The Scientific Subroutines Package Distribution Kit
 
K    The distribution kit for the Scientific Subroutines  Package  consists
 K    of   up   to   two  mass-storage  volumes  containing  the  Scientific
 K    Subroutines  Package,  and  this  document,  which   is   shipped   in
 2    machine-readable form on-line as a .MEM file.
 
C    The distribution volume contains the following kinds of files:
  
K          o  The SSP files.  These are FORTRAN source files, indentifiable
 $             by the .FOR extension.
 
K          o  Test program files.  These are  also  FORTRAN  source  files,
 K             indentifiable by the .FOR extension.  Each contains a FORTRAN
 K             program that calls one or more of the scientific subroutines.
       OVERVIEW
K    OVERVIEW                                                      Page 1-3
  
 
K          o  Test program data files, indentifiable by the .DAT extension.
 >             These are required by some of the test programs.
 
K          o  Indirect-command files, indentifiable by the .COM  extension.
 K             These files compile the test programs then link or task-build

              them and run them.
 
 
D 
G 
 
 
 
 
 
 
 
 
 
 

    CHAPTER 2
O    CHAPTER 2
 
    STATISTICAL SUBROUTINES
     STATISTICAL SUBROUTINES
 
 
 
<    This chapter describes the SSP statistical subroutines.
 
 
 
    DATA SCREENING ROUTINES

    DATA SCREENING ROUTINES
 
D    The following sections describe the data screening subroutines.
 
 
 
    ABSNT Subroutine
    ABSNT Subroutine
  
K    ABSNT tests for missing (or zero) values for  each  observation  in  a
E0    general matrix A (Test program:  STAT.FOR).
 
$    Syntax:  CALL ABSNT (A,S,NO,NV)
 
#    ________            ___________
 $    Argument            Description
 
6    A                   Observation matrix, NO by NV.
 
K    S                   Output  vector  of  length   NO   indicating   the
e>                        following codes for each observation:
 
K                        1 indicates that  there  is  no  missing  or  zero

                        value.
0K                        0 indicates that at least one value is missing  or
m                        zero.
 
K    NO                  Number of observations.  NO must be  greater  than
 '                        or equal to 1.
i 
K    NV                  Number of variables for each observation.  NV must
e7                        be greater than or equal to 1.
m 
    Method:
 
K    ABSNT tests each row (observation) of the matrix A.  If  it  does  not
TK    find  a  missing  or  zero value, it places a one in S(J).  If it does
_G    find at least one missing or zero value, it places a zero in S(J).
a 
    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                       Page 2-2
r 
 
    BOUND Subroutine
    BOUND Subroutine
C 
K    BOUND selects from a set (or a subset) of observations, the number  of
DK    observations  under,  between,  and  over  two  given  bounds for each
e(    variable (Test program:  STAT.FOR).
 
@    Syntax:  CALL BOUND (A,S,BLO,BHI,UNDER,BETW,OVER,NO,NV,IER)
 
#    ________            ___________
e$    Argument            Description
 
6    A                   Observation matrix, NO by NV.
 
K    S                   Vector  indicating  subset  of  A.    Only   those
 K                        observations  with  a nonzero S(J) are considered.
 1                        The vector length is NO.

 
K    BLO                 Input vector of lower  bounds  on  all  variables.
O1                        The vector length is NV.
_ 
K    BHI                 Input vector of upper  bounds  on  all  variables.
r1                        The vector length is NV.
e 
K    UNDER               Output vector indicating, for each  variable,  the
aK                        number  of  observations  under lower bounds.  The
 -                        vector length is NV.
a 
K    BETW                Output vector indicating, for each  variable,  the
sK                        number  of  observations  equal  to or between the
oF                        lower and upper bounds.  Vector length is NV.
 
K    OVER                Output vector indicating, for each  variable,  the
cK                        number  of observations over upper bounds.  Vector
s&                        length is NV.
 
0    NO                  Number of observations.
 
B    NV                  Number of variables for each observation.
 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates   that   S   is   null.    VMIN=1.E37,
 #                        SD=AVER=0.
aI                        2 indicates that S has only one nonzero element.
i-                          VMIN=VMAX, SD=0.0.
  
    Method:
 
K    BOUND tests each row (observation) of matrix A  with  a  corresponding
 K    nonzero  element  in  the  vector  S.   It  compares observations with
gK    specified lower and upper variable bounds and keeps a count in vectors
     UNDER, BETW, and OVER.
I      STATISTICAL SUBROUTINES
UK    STATISTICAL SUBROUTINES                                       Page 2-3
o 
 
    SUBMX Subroutine
    SUBMX Subroutine
o 
K    SUBMX builds  a  subset  matrix.   Based  on  vector  S  derived  from
 K    subroutines  SUBST  or  ABSNT,  SUBMX  copies  from a larger matrix of
oK    observation data a subset matrix  of  those  observations  which  have
gK    satisfied  a  certain  condition.   This  subroutine  is normally used
aK    before  the  statistical  analyses  (multiple  regression  or   factor
i)    analysis) (Test program:  STAT.FOR).
  
(    Syntax:  CALL SUBMX (A,D,S,NO,NV,N)
 
#    ________            ___________
 $    Argument            Description
 
@    A                   Input matrix of observations, NO by NV.
 
?    D                   Output matrix of observations N by NV.
c 
K    S                   Input vector of length  NO  containing  the  codes
a@                        derived from subroutine SUBST or ABSNT.
 
K    NO                  Number of observations.  NO must be  greater  than
 '                        or equal to 1.
  
-    NV                  Number of variables.
  
K    N                   Output variable containing the number  of  nonzero
c+                        codes in vector S.
  

    Remarks:
t 
6    Matrix D can be in the same location as m                                                                                                                                                                                                                                                   ;                        t $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                                   9       atrix A.
 
    Method:
 
K    SUBMX determines whether S(I) contains a nonzero code.   If  it  does,
cK    the  Ith  observation  is  copied  from the input matrix to the output
s    matrix.
 
 
 
    SUBST Subroutine
    SUBST Subroutine
r 
K    SUBST derives a subset vector indicating which observations in  a  set
 K    have   satisfied   certain   conditions   on   the   variables   (Test
g    program:  DASCR.FOR).
 
-    Syntax:  CALL SUBST (A,C,R,B,S,NO,NV,NC)
q 
#    ___       :       _____            ___________
 $    Argument            Description
 
6    A                   Observation matrix, NO by NV.
 
K    C                   Input  matrix,  3  by  NC,  of  conditions  to  be
 K                        considered.  The first element of each column of C
iK                        represents the number of the variable  (column  of
       STATISTICAL SUBROUTINES
sK    STATISTICAL SUBROUTINES                                       Page 2-4
O 
 
K                        the matrix A) to be tested.  The second element of
 K                        each column is one  of  the  following  relational
t                        codes:
  
/                                  Code Element
e 
5                          1       For LT (less than)
 A                          2       For LE (less than or equal to)
n4                          3       For EQ (equal to)
8                          4       For NE (not equal to)
D                          5       For GE (greater than or equal to)
8                          6       For GT (greater than)
 
K                        The third element of each column is a quantity  to
hK                        be   used  for  comparison  with  the  observation
 I                        values.  For example, the following in column C:
  
                          2.
h                          5.
                          92.5
 
K                        causes  the  second  variable  to  be  tested  for
o7                        greater than or equal to 92.5.
o 
K    R                   Working vector used to store intermediate  results
aK                        of  above  tests  on  a  single  observation.   If
cK                        condition is satisfied, R(I) is set to 1.   If  it
 H                        is not, R(I) is set to 0.  Vector length is NC.
 
K    B                   Name  of  subroutine   you   must   supply.    The
uK                        subroutine   must   be   defined  by  an  external
 K                        statement in the calling program.  It consists  of
 K                        a  Boolean  expression  linking  the  intermediate

K                        values stored in vector R.  The Boolean  operators
CA                        are * for AND and + for OR, for example:
T 
.                        SUBROUTINE BOOL (R,T)
'                        DIMENSION R(3)
                               (
D*                        T=R(1)(R(2)+R(3))
                        RETURN
e                        END
 
K                        The    above    expression    is    tested    for:
(0                        R(1).AND.(R(2).OR.R(3))
 
K    S                   Output vector indicating,  for  each  observation,
,K                        whether  or not proposition B is satisfied.  If it
sD                        is, S(I) is zero.  The vector length is NO.
 
K    NO                  Number of observations.  NO must be  greater  than
e'                        or equal to 1.
f 
K    NV                  Number of variables.  NV must be greater  than  or
o$                        equal to 1.
      STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                       Page 2-5
  
 
K    NC                  Number of basic conditions to  be  satisfied.   NC
a<                        must be greater than or equal to 1.
 
3    Subroutines and Function Subprograms Required:
t 
K    B - The name of the subroutine you must supply can be different,  (for
 K    example  BOOL)  but  the  subroutine  SUBST always calls it as B.  For
tK    subroutine SUBST  to  do  this,  you  must  define  the  name  of  the
 K    subroutine  by an external statement in the calling program.  You must
iH    also list the name in the CALL SUBST statement.  (See Usage above.)
 
    Method:
 
7    SUBST performs the following for each observation:
  
K         1.  SUBST  analyzes  the  condition  matrix  to  determine  which
i+             variables are to be examined.
r 
-         2.  SUBST forms immediate vector R.

 
K         3.  SUBST evaluates the Boolean expression (in subroutine  B)  to
,K             derive  the  element  in subset vector S corresponding to the
              observation.
 
 
 
 
    TAB1 Subroutine
s    TAB1 Subroutine
 
K    TAB1 tabulates for one variable in an observation matrix (or a  matrix
hK    subset)  the  frequency  and  percent  over given class intervals.  In
rK    addition, TAB1 calculates for  the  same  variable  the  total,  mean,
oI    standard deviation, minimum, and maximum (Test program:  DASCR.FOR).
r 
;    Syntax:  CALL TAB1(A,S,NOVAR,UBO,FREQ,PCT,STATS,NO,NV)
t 
#    ________            ___________

$    Argument            Description
 
6    A                   Observation matrix, NO by NV.
 
K    S                   Input vector  giving  subset  of  A.   Only  those
bK                        observations with a corresponding nonzero S(J) are
d:                        considered.  Vector length is NO.
 
6    NOVAR               The variable to be tabulated.
 
K    UBO                 Input  vector  giving  lower  limit,   number   of
 K                        intervals,  and  upper  limit  of  variable  to be
 K                        tabulated   in   UBO(1),   UBO(2),   and    UBO(3)
tK                        respectively.   If  lower  limit is equal to upper
 K                        limit, the program uses the  minimum  and  maximum
gK                        values  of  the  variable.   Number  of intervals,
vK                        UBO(2), must include two cells  for  values  under
o?                        and above limits.  Vector length is 3.
  t    STATISTICAL SUBROUTINES
EK    STATISTICAL SUBROUTINES                                       Page 2-6
  
 
K    FREQ                Output vector of frequencies.   Vector  length  is
                          UBO(2).
 
K    PCT                 Output vector  of  relative  frequencies.   Vector
f*                        length is UBO(2).
 
K    STATS               Output vector  of  summary  statistics,  that  is,
sK                        total,   mean,  standard  deviation,  minimum  and
MK                        maximum.  Vector length is 5.  If S is  null,  the
iK                        total,  average,  and  standard deviation equal 0,
II                        minimum equals -1.E75, and maximum equals 1.E75.
i 
K    NO                  Number of observations.  NO must be  greater  than
 '                        or equal to 1.
  
K    NV                  Number of variables for each observation.  NV must
D7                        be greater than or equal to 1.
  
    Method:
 
K    TAB1 calculates the  interval  size  from  the  given  information  or
oK    optionally,  from  the  minimum and maximum values for variable NOVAR.
eK    TAB1 then calculates the frequencies, percent frequencies, and summary
 K    statistics.   The  divisor for standard deviation is one less than the
t!    number of observations used.
  
 
 
    TAB2 Subroutine
o    TAB2 Subroutine
 
K    TAB2 performs  a  two-way  classification  for  two  variables  in  an
nK    observation  matrix  (or  a  matrix  subset) of the frequency, percent
 K    frequency, and other  statistics  over  given  class  intervals  (Test
g    program:  STAT.FOR).
n 
?    Syntax:  CALL TAB2(A,S,NOV,UBO,FREQ,PCT,STAT1,STAT2,NO,NV)
. 
#    ________            ___________
r$    Argument            Description
 
6    A                   Observation matrix, NO by NV.
 
K    S                   Input vector  giving  subset  of  A.   Only  those
 K                        observations with a corresponding nonzero S(J) are

:                        considered.  Vector length is NO.
 
K    NOV                 Variables  to  be  cross-tabulated.    NOV(1)   is
cK                        variable  1,  NOV(2) is variable 2.  Vector length
SK                        is 2.  NOV must be greater than or equal to 1  an                                                                                                                                                                                                                                   <                        b> $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             q  "     J       d
i2                        less than or equal to NV.
 
K    UBO                 3 by  2  matrix  giving  lower  limit,  number  of
 K                        intervals, and upper limit of both variables to be
 K                        tabulated (first column  for  variable  1,  second
eK                        column  for  variable 2).  If lower limit is equal
iK                        to upper limit for variable 1,  the  program  uses
       STATISTICAL SUBROUTINES
,K    STATISTICAL SUBROUTINES                                       Page 2-7
  
 
K                        the  minimum  and maximum values on each variable.
 K                        Number of intervals must  include  two  cells  for
 0                        under and above limits.
 
K    FREQ                Output  matrix  of  frequencies   in   the   2-way
iK                        classification.   Order of matrix is INT1 by INT2,
TK                        where INT1 is the number of intervals of  variable
 K                        1  and INT2 is the number of intervals of variable
 K                        2.  INT1 and INT2 must be specified in the  second
 E                        position of respective column of UBO matrix.
e 
K    PCT                 Output matrix of percent frequencies,  same  order
 !                        as FREQ.
q 
K    STAT1               Output  matrix  summarizing  totals,  means,   and
 K                        standard  deviations  for  each  class interval of
rC                        variable 1.  Order of matrix is 3 by INT1.
r 
K    STAT2               Same as STAT1  but  over  variable  2.   Order  of
 -                        matrix is 3 by INT2.
  
K    NO                  Number of observations.  NO must be  greater  than
.'                        or equal to 1.

 
K    NV                  Number of variables for each observation.  NV must
 7                        be greater than or equal to 1.
t 

    Remarks:
e 
4    If S is null, the output areas are set to zero.
 
    Method:
 
K    TAB2 calculates interval sizes  for  both  variables  from  the  given
uK    information or, optionally, from the minimum and maximum values.  TAB2
 K    also develops the frequency and percent frequency matrices.  Then,  it
 K    calculates  matrices  STAT1  and  STAT2 summarizing totals, means, and
.    standard deviations.
  
K    The divisor for standard deviation is one  less  than  the  number  of
s.    observations used in each class interval.
 
 
 
    TALLY Subroutine
    TALLY Subroutine
g 
K    TALLY calculates the total, the  mean,  the  standard  deviation,  the
 K    minimum,  and  the maximum for each variable in a set (or a subset) of
B,    observations (Test program:  STAT.FOR).
 
?    Syntax:  CALL TALLY(A,S,TOTAL,AVER,SD,VMIN,VMAX,NO,NV,IER)
  
#    ________            ___________
 $    Argument            Description
 
6    A                   Observation matrix, NO by NV.
 
    STATISTICAL SUBROUTINES
RK    STATISTICAL SUBROUTINES                                       Page 2-8
  
 
K    S                   Input vector indicating subset of A.   Only  those
)K                        observations  with  a nonzero S(J) are considered.
i-                        Vector length is NO.
p 
K    TOTAL               Output vector of totals of each variable.   Vector
h&                        length is NV.
 
K    AVER                Output vector of means of each  variable.   Vector
 &                        length is NV.
 
K    SD                  Output  vector  of  standard  deviations  of  each
 8                        variable.  Vector length is NV.
 
K    VMIN                Output vector of minima of each variable.   Vector

&                        length is NV.
 
K    VMAX                Output vector of maxima of each variable.   Vector
r&                        length is NV.
 
0    NO                  Number of observations.
 
B    NV                  Number of variables for each observation.
 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates   that   S   is   null.    VMIN=1.E37,
a#                        SD=AVER=0.
YI                        2 indicates that S has only one nonzero element.
a-                          VMIN=VMAX, SD=0.0.
m 
    Method:
 
K    TALLY analyzes all observations corresponding to a nonzero element  in
tK    vector  S  for each variable in matrix A.  Then, it accumulates totals
 K    and  finds  minimum  and  maximum  values.   Following   this,   TALLY
 -    calculates mean and standard deviations.
O 
K    The divisor for standard deviation is one  less  than  the  number  of
g    observations used.
i 
 
 
%    ELEMENTARY STATISTICS SUBROUTINES
,&    ELEMENTARY STATISTICS SUBROUTINES
 
K    The  sections  that  follow   describe   the   elementary   statistics
s    subroutines.
r 
 
 
    MOMEN Subroutine
    MOMEN Subroutine
n 
K    MOMEN finds the first four moments for grouped  data  on  equal  class
a*    intervals (Test program:  NPAR2.FOR).
 e    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                       Page 2-9
i 
 
'    Syntax:  CALL MOMEN(F,UBO,NOP,ANS)
  
#    ________            ___________
t$    Argument            Description
 
K    F                   Grouped data (frequencies).  Given as a vector  of
a7                        length (UBO(3)-UBO(1))/UBO(2).
  
K    UBO                 Three-cell vector, UBO(1) is  a  lower  bound  and
UK                        UBO(3)  is  an  upper  bound on data.  UBO(2) is a
aK                        class interval.  Note that UBO(3) must be  greater
 %                        than UBO(1).
  
K    NOP                 Option  Argument.   If  NOP=1,  ANS(1)=mean.    If
oK                        NOP=2,    ANS(2)=second    moment.     If   NOP=3,
 K                        ANS(3)=third  moment.   If  NOP=4,   ANS(4)=fourth
 K                        moment.  If NOP=5, all four moments are filled in.
  
K    ANS                 Output vector of length 4 into which  moments  are
e                        put.
m 

    Remarks:
  
K    The first moment is not central but the value of the mean itself.  The
 K    mean  is  always calculated.  Moments are biased and not corrected for
     grouping.
 
    Method:
 
    Refer to Kendall 1977.
  
 
 
    TTSTT Subroutine
    TTSTT Subroutine
e 
K    TTSTT finds certain T-statistics on the  means  of  populations  (Test
     program:  STAT.FOR).
f 
/    Syntax:  CALL TTSTT(A,NA,B,NB,NOP,NDF,ANS)
  
#    ________            ___________
 $    Argument            Description
 
C    A                   Input vector of length NA containing data.
  
5    NA                  Number of observations in A.
e 
C    B                   Input vector of length NB containing data.
r 
5    NB                  Number of observations in B.
i 
8    NOP                 Options for various hypotheses:
 
K                        1 indicates that population mean of B equals given
o,                        value A (set NA=1).
 
K                        2 indicates  that  population  mean  of  B  equals

      STATISTICAL SUBROUTINES
iK    STATISTICAL SUBROUTINES                                      Page 2-10

 
 
K                        population mean of A, given that the variance of B
 2                        equals the variance of A.
 
K                        3 indicates  that  population  mean  of  B  equals
 K                        population mean of A, given that the variance of B
 ;                        is not equal to the variance of A.
  
K                        4 indicates  that  population  mean  of  B  equals
 K                        population  mean  of A, given no information about
 >                        the variances of A and B (set NA=NB).
 
K    NDF                 Output  variable  containing  degrees  of  freedom
 D                        associated with the T-statistic calculated.
 
:    ANS                 T-statistic for given hypothesis.
 

    Remarks:
  
K    NA and NB must be greater than 1, except that NA=1 in  option  1.   NA
tK    and NB must be the same in option 4.  If NOP is other than 1, 2, 3, or
cK    4, degrees of freedom and T-statistic are not calculated.  NDF and ANS
t    are set to zero.
b 
    Method:
 
    Refer to Ostel 1975.
S 
 
 
    CORRELATION SUBROUTINE
                                                                                                                                                                                                                                                   =                        m5g $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "     [           CORRELATION SUBROUTINE
  
C    The section that follows describes the correlation subroutine.
x 
 
 
    CORRE Subroutine
    CORRE Subroutine
N 
K    CORRE computes means, standard deviations, sums of  cross-products  of
rK    deviations,    and    correlation   coefficients   (Tests:  FACTO.FOR,
i    MCANO.FOR).
 
6    Syntax:  CALL CORRE(N,M,IO,X,XBAR,STD,RX,R,B,D,T)
 
#    ________            ___________
 $    Argument            Description
 
K    N                   Number of observations.  N must be greater than or
v$                        equal to 2.
 
K    M                   Number of variables.  M must be  greater  than  or
 $                        equal to 1.
 
4    IO                  Option code for input data.
 
K                        0 indicates data is  to  be  read  in  from  input
AK                        device in the special subroutine named DATA.  (See
       STATISTICAL SUBROUTINES
iK    STATISTICAL SUBROUTINES                                      Page 2-11
e 
 
D                        subroutines used by this subroutine below.)
 
C                        1 indicates all data is already in memory.
N 
K    X                   If IO=0, the value of X is 0.0.  If IO=1, X is the
t?                        input matrix (N by M) containing data.
  
D    XBAR                Output vector of length M containing means.
 
K    STD                 Output vector  of  length  M  containing  standard
 $                        deviations.
 
K    RX                  Output  matrix  (M  by  M)  containing   sums   of
bA                        cross-products of deviations from means.
i 
K    R                   Output matrix (only upper  triangular  portion  of
eK                        the   symmetric  matrix  of  M  by  M)  containing
mF                        correlation coefficients (storage mode of 1).
 
K    B                   Output vector of length M containing the  diagonal
iK                        of   the  matrix  of  sums  of  cross-products  of
Y/                        deviations from means.
, 
4    D                   Working vector of length M.
 
4    T                   Working vector of length M.
 
3    Subroutines and Function Subprograms Required:

 
2    DATA(M,D) - You must provide this subroutine.
 
K         1.  If  IO=0,  this  subroutine  is  expected   to   furnish   an
rD             observation in vector D from an external input device.
 
K         2.  If IO=1, this subroutine is not used by  CORRE  but  must  be
 K             provided  when building the executable file.  If you have not
iK             supplied a subroutine named DATA, the following is suggested:
t 
             SUBROUTINE DATA
i             RETURN
             END
  
    Method:
 
<    CORRE computes product-moment correlation coefficients.
 
 
 
*    MULTIPLE LINEAR REGRESSION SUBROUTINES
+    MULTIPLE LINEAR REGRESSION SUBROUTINES
c 
K    The sections that  follow  describe  the  multiple  linear  regression
     subroutines.
v o    STATISTICAL SUBROUTINES
oK    STATISTICAL SUBROUTINES                                      Page 2-12
V 
 
    MULTR Subroutine
    MULTR Subroutine
r 
K    MULTR performs a multiple linear regression analysis for  a  dependent
 K    variable and a set of independent variables.  This subroutine normally
 K    performs   multiple   and   polynomial   regression   analyses   (Test

    program:  POLRG.FOR).
 
?    Syntax:  CALL MULTR(N,K,XBAR,STD,D,RX,RY,ISAVE,B,SB,T,ANS)
R 
#    ________            ___________
 $    Argument            Description
 
0    N                   Number of observations.
 
K    K                   Number   of   independent   variables   in    this
2$                        regression.
 
K    XBAR                Input vector of length M containing means  of  all

B                        variables.  M is the number of variables.
 
K    STD                 Input  vector  of  length  M  containing  standard
t5                        deviations of all variables.
  
K    D                   Input vector of length M containing  the  diagonal
 K                        of  the  matrix  of  sums  of  cross  products  of
 ?                        deviations from means for all vectors.
B 
K    RX                  Input matrix (K by K) containing  the  inverse  of
oG                        intercorrelations among independent variables.

 
K    RY                  Input    vector    of    length    K    containing
 K                        intercorrelations  of independent variables with a
I,                        dependent variable.
 
K    ISAVE               Input vector of length K+1  containing  subscripts

K                        of  independent variables in ascending order.  The
RK                        subscript of the dependent variable is  stored  in
 F                        the last position, that is, the K+1 position.
 
K    B                   Output vector of length  K  containing  regression
f&                        coefficients.
 
K    SB                  Output vector  of  length  K  containing  standard
T?                        deviations of regression coefficients.
  
G    T                   Output vector of length K containing T-values.
_ 
K    ANS                 Output  vector  of  length   10   containing   the
 /                        following information:
e 
)                        ANS(1) Intercept
n@                        ANS(2) Multiple correlation coefficient
:                        ANS(3) Standard error of estimate
F                        ANS(4) Sum of squares due to regression (SSR)
F                        ANS(5) Degrees of freedom associated with SSR
2                        ANS(6) Mean square of SSR
      STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-13
e 
 
=                        ANS(7) Residual sum of squares (RSS)
 F                        ANS(8) Degrees of freedom associated with RSS
2                        ANS(9) Mean square of RSS
(                        ANS(10) F-value
 

    Remarks:
m 
     N must be greater than K+1.
 
    Method:
 
K    MULTR uses the Gauss-Jordan method to solve normal  equations.   Refer
l/    to Cooley and Lohnes 1962, and Ostel 1975.
n 
 
 
    ORDER Subroutine
    ORDER Subroutine

 
K    ORDER  constructs  a  subset   matrix   of   intercorrelations   among

K    independent variables and a vector of intercorrelations of independent
nK    variables  with  a  dependent  variable  from  a  larger   matrix   of
LK    correlation  coefficients.   This  subroutine  is normally used in the
 K    performance of  multiple  and  polynomial  regression  analyses  (Test
f    program:  POLRG.FOR).
 
0    Syntax:  CALL ORDER(M,R,NDEP,K,ISAVE,RX,RY)
 
#    ________            ___________
t$    Argument            Description
 
C    M                   Number of variables and order of matrix R.
P 
K    R                   Input matrix containing correlation  coefficients.
iK                        This  subroutine expects only the upper triangular
lK                        portion of the symmetric matrix to be  stored  (by
 :                        column) in R (storage mode of 1).
 
H    NDEP                The subscript number of the dependent variable.
 
K    K                   Number of independent variables to be included  in
 K                        the  forthcoming  regression.   K  must be greater
 ,                        than or equal to 1.
 
K    ISAVE               Input  vector  of  length   K+1   containing,   in
oK                        ascending   order,  the  subscript  numbers  of  K
 K                        independent  variables  to  be  included  in   the
 K                        forthcoming  regression.   Upon  returning  to the
 K                        calling  routine,   this   vector   contains,   in
 K                        addition,  the  subscript  number of the dependent
 2                        variable in position K+1.
 
K    RX                  Output    matrix    (K    by     K)     containing
sK                        intercorrelations  among  independent variables to
.;                        be used in forthcoming regression.
o 
K    RY                  Output   vector    of    length    K    containing
a .    STATISTICAL SUBROUTINES
tK    STATISTICAL SUBROUTINES                                      Page 2-14
C 
 
K                                                                                                                                                                                                                                                                >                        .! $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             Hs "     l                  intercorrelations  of  independent  variables with
 -                        dependent variables.

 
    Method:
 
K    ORDER constructs the matrix RX and the vector RY  from  the  subscript
sK    numbers of the variables to be included in the forthcoming regression.
f 
 
 
$    POLYNOMIAL REGRESSION SUBROUTINE
%    POLYNOMIAL REGRESSION SUBROUTINE
B 
K    The  section  that  follows  describes   the   polynomial   regression
     subroutine.
 
 
 
    GDATA Subroutine
    GDATA Subroutine
u 
K    GDATA generates independent variables up to the Mth power (the highest
 K    degree  polynomial specified) and computes means, standard deviations,
 K    and correlation coefficients.   This  subroutine  is  normally  called
.K    before  subroutines  ORDER,  MINV,  and  MULTR in the performance of a
n6    polynomial regression (Test program:  POLRG.FOR).
 
0    Syntax:  CALL GDATA(N,M,X,XBAR,STD,D,SUMSQ)
 
#    ________            ___________
 $    Argument            Description
 
0    N                   Number of observations.
 
D    M                   The highest degree polynomial to be fitted.
 
K    X                   Input matrix (N by M+1).  When  GDATA  is  called,
XK                        data for the independent variable is stored in the
cK                        first  column  of  matrix  X,  and  data  for  the
aK                        dependent variable is stored in the last column of
aK                        the  matrix.   Upon  returning  to   the   calling
 K                        routine,   generated  powers  of  the  independent
 D                        variable are stored in columns 2 through M.
 
K    XBAR                Output vector of length M+1  containing  means  of
 =                        independent and dependent variables.
  
K    STD                 Output vector of length  M+1  containing  standard
 K                        deviations of independent and dependent variables.
  
K    D                   Output matrix (only upper  triangular  portion  of
 K                        the  symmetric  matrix  of  M+1 by M+1) containing
 F                        correlation coefficients (storage mode of 1).
 
K    SUMSQ               Output vector of length  M+1  containing  sums  of
uK                        products  of  deviations from means of independent
 1                        and dependent variables.
b v    STATISTICAL SUBROUTINES
eK    STATISTICAL SUBROUTINES                                      Page 2-15
  
 

    Remarks:
  
K    N must be greater than M+1.  If M is equal to  5  or  greater,  single
 K    precision  may  not  be  sufficient to give satisfactory computational


    results.
U 
    Method:
 
    Refer to Ostel 1975.
  
 
 
%    CANONICAL CORRELATION SUBROUTINES
r&    CANONICAL CORRELATION SUBROUTINES
 
K    The  sections  that  follow  describe   the   canonical   correlations
E    subroutines.
c 
 
 
    CANOR Subroutine
    CANOR Subroutine
l 
K    CANOR calculates  the  canonical  correlations  between  two  sets  of
 K    variables.   CANOR  is normally preceded by a call to subroutine CORRE

     (Test program:  MCANO.FOR).
 
>    Syntax:  CALL CANOR(N,MP,MQ,RR,ROOTS,WLAM,CANR,CHISQ,NDF,
             COEFR,COEFL,R)
 
#    ________            ___________
r$    Argument            Description
 
0    N                   Number of observations.
 
7    MP                  Number of left-hand variables.
n 
8    MQ                  Number of right-hand variables.
 
K    RR                  Input matrix (only upper triangular portion of the
 K                        symmetric   matrix  of  M  by  M,  where  M=MP+MQ)
NK                        containing correlation coefficients (storage  mode
r                        of 1).
  
K    ROOTS               Output vector of length MQ containing  eigenvalues
 :                        computed in the NROOT subroutine.
 
F    WLAM                Output vector of length MQ containing lambda.
 
K    CANR                Output vector of length  MQ  containing  canonical
 &                        correlations.
 
K    CHISQ               Output vector of length MQ containing  the  values

(                        of chi-squares.
 
K    NDF                 Output vector of length MQ containing the  degrees
e@                        of freedom associated with chi-squares.
 o    STATISTICAL SUBROUTINES
tK    STATISTICAL SUBROUTINES                                      Page 2-16
g 
 
K    COEFR               Output matrix (MQ by MQ)  containing  MQ  sets  of
 =                        right-hand coefficients column-wise.
  
K    COEFL               Output matrix (MQ by MP)  containing  MQ  sets  of
u<                        left-hand coefficients column-wise.
 
.    R                   Work matrix (M by M).
 

    Remarks:
  
K    The number of left-hand variables (MP) should be greater than or equal
eK    to  the  number of right-hand variables (MQ).  The values of canonical
 K    correlation, lambda, chi-square, degrees  of  freedom,  and  canonical
 K    coefficients are computed only for those eigenvalues in roots that are
S    greater than zero.
s 
    Method:
 
%    Refer to Cooley and Lohnes 1962.
  
 
 
    NROOT Subroutine
    NROOT Subroutine
L 
K    NROOT computes the eigenvalues and eigenvectors of a real nonsymmetric
 K    matrix  of  the  form  B-inverse times A.  This subroutine is normally
AK    called by subroutine  CANOR  in  performing  a  canonical  correlation
 )    analysis (Test program:  MCANO.FOR).
  
$    Syntax:  CALL NROOT(M,A,B,XL,X)
 
#    ________            ___________
 $    Argument            Description
 
>    M                   Order of square matrices A, B, and X.
 
/    A                   Input matrix (M by M).
O 
/    B                   Input matrix (M by M).
R 
K    XL                  Output vector of length M  containing  eigenvalues
e.                        of B-inverse times A.
 
K    X                   Output matrix (M  by  M)  containing  eigenvectors
a%                        column-wise.
n 
3    Subroutines and Function Subprograms Required:
r 

    EIGEN
 
    Method:
 
%    Refer to Cooley and Lohnes 1962.
o m    STATISTICAL SUBROUTINES
aK    STATISTICAL SUBROUTINES                                      Page 2-17
_ 
 
$    ANALYSIS OF VARIANCE SUBROUTINES
%    ANALYSIS OF VARIANCE SUBROUTINES
a 
K    The  sections  that  follow  describe   the   analysis   of   variance
g    subroutines.
i 
 
 
    AVCAL Subroutine
    AVCAL Subroutine
t 
K    AVCAL performs the calculus of a factorial experiment  using  operator
aK    sigma  and  operator delta.  AVCAL is preceded by subroutine AVDAT and
 K    followed by subroutine MEANQ in  analyzing  variance  for  a  complete
r1    factorial design (Test program:  ANOVA.FOR).
p 
1    Syntax:  CALL AVCAL(K,LEVEL,X,L,ISTEP,LASTS)
  
#    ________            ___________
 $    Argument            Description
 
K    K                   Number of variables (factors).  K must be  greater
                          than 1.
 
K    LEVEL               Input  vector  of  length  K   containing   levels
 ;                        (categories) within each variable.
h 
K    X                   Input  vector  containing  data.   Data  has  been
 K                        placed  in  vector  X  by  subroutine  AVDAT.  The
 K                        length             of             X             is
 4                                    (           .  (
A                        (LEVEL(1)+1)(LEVEL(2)+1)...(LEVEL(K)+1).
c 
K    L                   The position in vector X where the last input data
lK                        is  located.   L has been calculated by subroutine
                         AVDAT.
t 
K    ISTEP               Input  vector  of  length  K  containing   storage
AK                        control   steps  which  have  been  calculated  by

*                        subroutine AVDAT.
 
4    LASTS               Working vector of length K.
 

    Remarks:
s 
2    This subroutine must follow subroutine AVDAT.
 
    Method:
 
K    The method is based on  the  technique  discussed  by  H.O.   Hartley.
 $    (Ralston and Wilf, eds.  1962).
 
 
 
    AVDAT Subroutine
    AVDAT Subroutine
R 
K    AVDAT places  data  for  variance  analysis  in  properly  distributed
oK    positions  of  storage.  This subroutine is normally followed by                                                                                                                                                                                                                                                    ?                        ̋ $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "     }       calls
GK    to AVCAL and MEANQ  subroutines  analyzing  variance  for  a  complete
h w    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-18
r 
 
1    factorial design (Test program:  ANOVA.FOR).
l 
3    Syntax:  CALL AVDAT(K,LEVEL,N,X,L,ISTEP,KOUNT)
  
#    ________            ___________
 $    Argument            Description
 
K    K                   Number of variables (factors).  K must be  greater
                          than 1.
 
K    LEVEL               Input  vector  of  length  K   containing   levels
 ;                        (categories) within each variable.
e 
:    N                   Total number of data points read.
 
K    X                   When AVDAT is called, this vector contains data in
iK                        locations  X(1)  through  X(N).  Upon returning to
 K                        the calling routine, the vector contains the  data
eK                        in  properly  redistributed locations of vector X.
 K                        The length of vector  X  is  calculated  by:   (1)
tK                        adding  1  to  each  level  of  variable  and  (2)
hK                        obtaining the cumulative product  of  all  levels.
gK                        The        length        of        X        equals
 4                                    (           .  (
A                        (LEVEL(1)+1)(LEVEL(2)+1)...(LEVEL(K)+1).
i 
K    L                   Output variable containing the position in  vector
(?                        X where the last input data is stored.
e 
K    ISTEP               Output vector of length K containing control steps
aK                        which  are used to locate data in proper positions
e%                        of vector X.
o 
4    KOUNT               Working vector of length K.
 

    Remarks:
n 
K    Input data must be arranged in the  following  manner.   Consider  the
OK    3-way analysis of variance design, where one variable has three levels
eK    and the other  two  variables  have  two  levels.   The  data  may  be
 K    represented  in  the  form:   X(I,J,K),  I=1,2,3,  J=1,2,  K=1,2.   In
tK    arranging data, the subscript, I, changes first.  When I=3,  the  next
 =    subscript, J, changes and so on until I=3, J=2, and K=2.
S 
    Method:
 
K    The method is based on the technique discussed  by  H.   O.   Hartley.
 $    (Ralston and Wilf, eds.  1962).
 
 
 
    MEANQ Subroutine
    MEANQ Subroutine
N 
K    MEANQ computes sum of squares, degrees of  freedom,  and  mean  square
 K    using the mean square operator.  MEANQ normally follows calls to AVDAT
bK    and AVCAL subroutines in analyzing variance for a  complete  factorial
R'    design (Test program:  ANOVA.FOR).
       STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-19

 
 
?    Syntax:  CALL MEANQ(K,LEVEL,X,GMEAN,SUMSQ,NDF,SMEAN,MSTEP,
              KOUNT,LASTS)
 
#    ________            ___________
m$    Argument            Description
 
K    K                   Number of variables (factors).  K must be  greater
                          than 1.
 
K    LEVEL               Input  vector  of  length  K   containing   levels
o;                        (categories) within each variable.
) 
K    X                   Input vector containing the result  of  the  sigma
eK                        and   delta   operators.   The  length  of  X  is:
 4                                    (           .  (
A                        (LEVEL(1)+1)(LEVEL(2)+1)...(LEVEL(K)+1).
o 
?    GMEAN               Output variable containing grand mean.
  
K    SUMSQ               Output vector containing  sums  of  squares.   The
 K                        length  of  SUMSQ  is  2 to the Kth power minus 1,
o                          K
e                         (2K)-1.
 
K    NDF                 Output vector containing degrees of freedom.   The
AK                        length  of  NDF  is  2  to  the Kth power minus 1,
                           K
E                         (2K)-1.
 
K    SMEAN               Output vector containing mean squares.  The length
 C                                                                  K
 H                        of SMEAN is 2 to the Kth power minus 1, (2K)-1.
 
4    MSTEP               Working vector of length K.
 
4    KOUNT               Working vector of length K.
 
4    LASTS               Working vector of length K.
 

    Remarks:
t 
2    This subroutine must follow subroutine AVCAL.
 
    Method:
 
K    The method is based on the technique discussed  by  H.   O.   Hartley.
c$    (Ralston and Wilf, eds.  1962).
 
 
 
%    DISCRIMINANT ANALYSIS SUBROUTINES
 &    DISCRIMINANT ANALYSIS SUBROUTINES
 
K    The  sections  that  follow   describe   the   discriminant   analysis
     subroutines.
  
 
 
    DISCR Subroutine
    DISCR Subroutine
r 
K    DISCR computes  a  set  of  linear  functions  that  are  indexes  for
u o    STATISTICAL SUBROUTINES
nK    STATISTICAL SUBROUTINES                                      Page 2-20
t 
 
K    classifying  an  individual into one of several groups.  Normally this

K    subroutine is used in the performance of discriminant  analysis  (Test
     program:  MDISC.FOR).
 
7    Syntax:  CALL DISCR(K,M,N,X,XBAR,D,CMEAN,V,C,P,LG)
i 
#    ________            ___________
m$    Argument            Description
 
E    K                   Number of groups.  K must be greater than 1.
f 
-    M                   Number of variables.
T 
K    N                   Input vector of length K containing  sample  sizes
_#                        of groups.
g 
K    X                   Input  vector  containing  data  in   the   manner
eK                        equivalent   to   3-dimensional   FORTRAN   array,
 K                        X(1,1,1), X(2,1,1), X(3,1,1) and  so  forth.   The
tK                        first  subscript is the case number, the second is
 K                        the variable number, and the third  is  the  group
nK                        number.   The  length  of vector X is equal to the
oA                                                                M
 K                        total   number   of   data   points,   TM,   where
B.                        T=N(1)+N(2)+...+N(K).
 
K    XBAR                Input matrix  (M  by  K)  containing  means  of  M
I/                        variables in K groups.
  
K    D                   Input matrix (M by M) containing  the  inverse  of
s2                        pooled dispersion matrix.
 
K    CMEAN               Output vector of length M containing common means.
t 
K    V                   Output variable containing generalized Mahalanobis
t"                        D-square.
 
K    C                   Output  matrix  ((M+1)  by   K)   containing   the
TK                        coefficients of discriminant functions.  The first
SK                        position of each column  (function)  contains  the
rA                        value of the constant for that function.
  
K    P                   Output   vector   containing    the    probability
 K                        associated  with the largest discriminant function
 K                        of all cases in all  groups.   Calculated  results
eK                        are   stored   in   a   manner   equivalent  to  a
iK                        two-dimensional area (the first subscript  is  the
 K                        case  number,  the  second  is  the group number).
 K                        Vector P has a length equal to the total number of
L9                        cases, T (T=N(1)+N(2)+...+N(K)).
o 
K    LG                  Output vector containing  the  subscripts  of  the
nK                        largest discriminant functions stored in vector P.
 K                        The length of vector LG is the same as the  length
 %                        of vector P.
v 

    Remarks:
  
    STATISTICAL SUBROUTINES
bK    STATISTICAL SUBROUTINES                                      Page 2-21

 
 
K    The number of variables must be greater than or equal to the number of
o    groups.
 
    Method:
 
1    Refer to Dixon, ed.  1977 and Anderson 1958.
  
 
 
    DMATX Subroutine
    DMATX Subroutine
T 
K    DMATX  computes  means  of  variables  in  each  group  and  a  pooled
nK    dispersion  matrix  for  all  the  groups.   Normally  PMATX  performs
t6    discriminant analysis (                                                                                                                                                                                                                                                   @                        f $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "            Test program:  MDISC.FOR).
 
.    Syntax:  CALL DMATX(K,M,N,X,XBAR,D,CMEAN)
 
#    ________            ___________
 $    Argument            Description
 
*    K                   Number of groups.
 
K    M                   Number of variables (must  be  the  same  for  all
L!                        groups).
_ 
K    N                   Input vector of length K containing  sample  sizes
 #                        of groups.
( 
K    X                   Input  vector  containing  data  in   the   manner
 K                        equivalent   to  a  3-dimensional  FORTRAN  array,
 K                        X(1,1,1), X(2,1,1), X(3,1,1), and so  forth.   The
 K                        first  subscript is the case number, the second is
sK                        the variable number, and the third  is  the  group
(K                        number.   The  length  of vector X is equal to the
r@                                                               M
K                        total   number   of   data   points   TM,    where
T.                        T=N(1)+N(2)+...+N(K).
 
K    XBAR                Output  matrix  (M  by  K)  containing  means   of
h/                        variables in K groups.
  
K    D                   Output  matrix  (M   by   M)   containing   pooled
 $                        dispersion.
 
4    CMEAN               Working vector of length M.
 

    Remarks:
( 
K    The number of variables must be greater than or equal to the number of
n    groups.
 
    Method:
 
1    Refer to Dixon, ed.  1977 and Anderson 1958.
t d    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-22
  
 
    FACTOR ANALYSIS SUBROUTINES
e     FACTOR ANALYSIS SUBROUTINES
 
G    The sections that follow describe the factor analysis subroutines.

 
 
 
    LOAD Subroutine
t    LOAD Subroutine
 
K    LOAD  computes  a  factor  matrix  (loading)  from   eigenvalues   and
iK    associated   eigenvectors.   This  subroutine  normally  occurs  in  a
 K    sequence of calls to subroutines CORRE, EIGEN, TRACE, LOAD, and  VARMX
XH    in the performance of a factor analysis (Test program:  FACTO.FOR).
 
     Syntax:  CALL LOAD(M,K,R,V)
 
#    ________            ___________
 $    Argument            Description
 
-    M                   Number of variables.
i 
K    K                   Number of factors.  K  must  be  greater  than  or

@                        equal to 1 and less than or equal to M.
 
K    R                   A matrix (symmetric and stored in compressed  form
tK                        with  only  upper  triangle  by  column in memory)
CK                        containing eigenvalues in  diagonal.   Eigenvalues
 K                        are  arranged  in  descending  order,  and first K
CK                        eigenvalues are  used  by  this  subroutine.   The
SD                                                                   (
K                        order  of  matrix  R  is  M  by  M.  Only M(M+1)/2
 E                        elements are in storage (storage mode of 1).
a 
K    V                   When LOAD is called, matrix V (M  by  M)  contains
 K                        eigenvectors  column-wise.   Upon returning to the
 K                        calling program, matrix V contains a factor matrix
I"                        (M by K).
 
    Method:
 
K    LOAD  converts  normalized  eigenvectors  to  the  factor  pattern  by
 K    multiplying  the  elements  of  each  vector by the square root of the
     corresponding eigenvalue.
 
 
 
    TRACE Subroutine
    TRACE Subroutine
n 
K    TRACE computes the cumulative percentage of eigenvalues  greater  than
 K    or equal to a specified constant.  TRACE normally occurs in a sequence
eK    of calls to subroutines CORRE, EIGEN, TRACE, LOAD, and  VARMX  in  the

A    performance of a factor analysis (Test program:  FACTO.FOR).
L 
%    Syntax:  CALL TRACE(M,R,CON,K,D)
  
#    ________            ___________
r$    Argument            Description
 
-    M                   Number of variables.
h e    STATISTICAL SUBROUTINES
.K    STATISTICAL SUBROUTINES                                      Page 2-23
N 
 
K    R                   Input matrix (symmetric and stored  in  compressed
oK                        form with only upper triangle by column in memory)
sK                        containing eigenvalues in  diagonal.   Eigenvalues
cK                        are  arranged  in  descending order.  The order of
A4                                                   (
K                        matrix R is M by M.  Only M(M+1)/2 elements are in
n5                        storage (storage mode of 1).
  
K    CON                 A constant used to decide how many eigenvalues  to
p                         retain.
 
K    K                   Output   variable   containing   the   number   of
_K                        eigenvalues  greater  than or equal to CON.  (K is
N0                        the number of factors.)
 
K    D                   Output vector of length  M  containing  cumulative
tK                        percentage of eigenvalues that are greater than or
r&                        equal to CON.
 
    Method:
 
K    TRACE divides each eigenvalue greater than or equal to CON  by  M  and
nK    adds  the  result  to  the  previous  total  to  obtain the cumulative
1$    percentage for each eigenvalue.
 
 
 
    VARMX Subroutine
    VARMX Subroutine
e 
K    VARMX  performs  orthogonal  rotations  of  a  factor  matrix.    This
rK    subroutine  normally  occurs  in  a  sequence  of calls to subroutines
 K    CORRE, EIGEN, TRACE, LOAD, and VARMX in the performance  of  a  factor
 )    analysis (Test program:  FACTO.FOR).
d 
/    Syntax:  CALL VARMX(M,K,A,NC,TV,H,F,D,IER)
  
#    ________            ___________
 $    Argument            Description
 
K    M                   Number of variables and number of rows  of  matrix
                         A.
m 
+    K                   Number of factors.
  
K    A                   Input is the original factor matrix, and output is
uK                        the  rotated factor matrix.  The order of matrix A
O#                        is M by K.
  
K    NC                  Output variable containing the number of iteration
t*                        cycles performed.
 
K    TV                  Output  vector  containing  the  variance  of  the

K                        factor  matrix  for  each  iteration  cycle.   The

K                        variance prior to the  first  iteration  cycle  is
 K                        also  calculated.   This means that NC+1 variances
 K                        are  stored  in  vector  TV.   Maximum  number  of
 K                        iteration cycles allowed in this subroutine is 50;
       STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-24
n 
 
B                        therefore, the length of vector TV is 51.
 
K    H                   Output vector of length M containing the  original
 '                        communalities.
  
K    F                   Output vector of length  M  containing  the  final
 '                        communalities.
p 
K    D                   Output  vector  of   length   M   containing   the
eK                        differences   between   the   original  and  final
 '                        communalities.
t 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates that convergence was not  achieved  in
 /                        50 cycles of rotation.
g 

    Remarks:
t 
K    If the variance computed after each iteration cycle does not  increase
A5    for four successive times, VARMX stops rotation.
o 
    Method:
 
K    Kaiser's varimax rotation as described in COMPUTER PROGRAM FOR VARIMAX
tK    ROTATION   IN   FACTOR   ANALYSIS,   Educational   and   Psychological
o*    Measurement, Vol.  XIX, No.  3, 1959.
 
 
 
    TIME SERIES SUBROUTINES
_    TIME SERIES SUBROUTINES
 
C    The sections that follow describe the time series subroutines.
f 
 
 
    AUTO Subroutine
     AUTO Subroutine
 
K    AUTO finds the autocovariances of a series A for lags 0 to  L-1  (Test
N    program:  TIMSER.FOR).
o 
     Syntax:  CALL AUTO(A,N,L,R)
 
#    ________            ___________
($    Argument            Description
 
K    A                                                                                                                                                                                                                                                                     A                         $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             > "             Input vector  of  length  N  containing  the  time
 @                        series whose autocovariance is desired.
 
0    N                   Length of the vector A.
 
K    L                   Autocovariance is calculated for  lags  of  0,  1,
 $                        2,..., L-1.
 
K    R                   Output   vector    of    length    L    containing
  v    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-25
  
 
5                        autocovariances of series A.
  

    Remarks:
  
K    The length of R must be different from the length of  A.   N  must  be
 K    greater than L.  If not, R(1) is set to zero and return is made to the
     calling program.
  
    Method:
 
&    Refer to Blackman and Tukey 1959.
 
 
 
    CROSS Subroutine
    CROSS Subroutine
  
K    CROSS finds the cross-covariances of a series A with a series  B  that
l2    leads and lags A (Test program:  TIMSER.FOR).
 
%    Syntax:  CALL CROSS(A,B,N,L,R,S)
f 
#    ________            ___________

$    Argument            Description
 
K    A                   Input vector of length  N  containing  first  time
                          series.
 
K    B                   Input vector of length N  containing  second  time
e                         series.
 
2    N                   Length of series A and B.
 
K    L                   Cross-covariance is calculated for lags and  leads
 .                        of 0, 1, 2, ..., L-1.
 
K    R                   Output   vector    of    length    L    containing
RG                        cross-covariances of A with B, where B lags A.
t 
K    S                   Output   vector    of    length    L    containing
 H                        cross-covariances of A with B, where B leads A.
 

    Remarks:
e 
K    N must be greater than L; if it is not, CROSS sets R(1)  and  S(1)  to
r-    zero and returns to the calling program.
l 
    Method:
 
&    Refer to Blackman and Tukey 1959.
 
 
 
    EXSMO Subroutine
    EXSMO Subroutine
  
K    EXSMO finds the triple exponential smoothed  series  S  of  the  given
 )    series X (Test program:  EXPON.FOR).
n i    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-26
  
 
)    Syntax:  CALL EXSMO(X,NX,AL,A,B,C,S)
  
#    ________            ___________
 $    Argument            Description
 
K    X                   Input vector of length NX containing  time  series
1D                        data which is to be exponentially smoothed.
 
5    NX                  The number of elements in X.
a 
K    AL                  Smoothing constant, alpha.   AL  must  be  greater
 0                        than 0 and less than 1.
 
K    A,B,C               Coefficients of the prediction equation,  where  S
 C                                                              T  TT
eK                        is  predicted  T  periods hence by A+BT+CTT/2.  As
cK                        input--if  A=B=C=0,  the  program   will   provide

K                        initial values.  If at least one of A, B, C is not
 K                        zero, the  program  will  take  given  as  initial
iK                        values.   As  output--A,  B, C contain the latest,
t<                        updated coefficients of prediction.
 
K    S                   Output  vector  of  length  NX  containing  triple
L<                        exponentially smoothed time series.
 
    Method:
 
    Refer to Brown 1963.
r 
 
 
    SMO Subroutine
    SMO Subroutine
l 
K    SMO   smooths   or   filters   series   A   by   weights    W    (Test
     program:  TIMSER.FOR).
s 
#    Syntax:  CALL SMO(A,N,W,M,L,R)
e 
#    ________            ___________
e$    Argument            Description
 
K    A                   Input vector of length N  containing  time  series
n                        data.
 
,    N                   Length of series A.
 
E    W                   Input vector of length M containing weights.
  
K    M                   Number of items in weight vector.  M  must  be  an
OK                        odd  integer.   If  M  is  an  even  integer,  any
 K                        fraction  resulting  from   the   calculation   of
                           (
eK                        (L(M-1))/2 in (1) and (2) below will be truncated.
l 
K    L                   Selection integer.  For example, L=12  means  that
cK                        weights  are applied to every 12th item of A.  L=1
 K                        applies weights to successive  items  of  A.   For
eK                        monthly data, L=12 gives year-to-year averages and
 ;                        L=1 gives month-to-month averages.
t p    STATISTICAL SUBROUTINES
iK    STATISTICAL SUBROUTINES                                      Page 2-27
r 
 
K    R                   Output vector of length N.  From IL to IH elements
NK                        of  the  vector  R  are  filled  with the smoothed
 D                        series and other elements with zero, where:
 
                             (
.                        IL=(L(M-1))/2+1...(1)
                                (
.                        IH=N-(L(M-1))/2...(2)
 

    Remarks:
O 
5                                                    M
t7    N must be greater than or equal to the product LM.
h 
    Method:
 
$    Refer to Healy and Bogert 1963.
 
 
 
)    NONPARAMETRIC STATISTICAL SUBROUTINES
i*    NONPARAMETRIC STATISTICAL SUBROUTINES
 
K    The  sections  that  follow  describe  the  nonparametric  statistical
E    subroutines.
D 
 
 
    CHISQ Subroutine
    CHISQ Subroutine
y 
K    CHISQ  computes  the  chi-square  from  a  contingency   table   (Test
I    program:  NONPAR.FOR).
  
0    Syntax:  CALL CHISQ(A,N,M,CS,NDF,IER,TR,TC)
 
#    ________            ___________
v$    Argument            Description
 
K    A                   Input  matrix,  N  by  M,  containing  contingency

                        table.
p 
-    N                   Number of rows in A.
  
0    M                   Number of columns in A.
 
-    CS                  Chi-square (output).
  
?    NDF                 Number of degrees of freedom (output).
u 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates that the expected value is  less  than
t2                        1.0 in one or more cells.
K                        3 indicates that the number of degrees of  freedom
 !                        is zero.
T 
1    TR                  Work vector of length N.
  
1    TC                  Work vector of length M.
       STATISTICAL SUBROUTINES
cK    STATISTICAL SUBROUTINES                                      Page 2-28
  
 

    Remarks:
N 
K    If one or more cells contain an expected value (that  is,  theoretical
 K    value)  less  than  1.0, CHISQ computes chi-square, and sets the error
tK    code to 1.  (See reference given  below.)  CHISQ  sets  chi-square  to
m/    zero if either N or M is 1 (error code 3).
  
    Method:
 
    Refer to Siegel 1956.
 
 
 
    KRANK Subroutine
    KRANK Subroutine
  
K    KRANK tests the correlation between two variables by the Kendall  rank
 9    correlation coefficient (Test program:  NONPAR.FOR).
  
-    Syntax:  CALL KRANK(A,B,R,N,TAU,SD,Z,NR)
R 
#    ________            ___________
 $    Argument            Description
 
K    A                   Input vector of N observations for first variable.
e 
K    B                   Input  vector  of  N   observations   for   second

"                        variable.
 
I                                                                        N
 K    R                   Output  vector  of  ranked  data  of  length   2N.
cK                        Smallest  observation  is  ranked  1,  largest  is
SK                        ranked N.   Ties  are  assigned  average  of  tied
1                        ranks.
S 
0    N                   Number of observations.
 
G    TAU                 Kendall rank correlation coefficient (output).
  
5    SD                  Standard deviation (output).
d 
K    Z                   Test of significance of TAU  in  terms  of  normal
M/                        distribution (output).

 
K    NR                  Code, 0 for unranked data in A and B, 1 for ranked
 1                        d                                                                                                                                                                                                                                                   B                        H $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "            ata in A and B (input).
  

    Remarks:
  
3    SD and Z are set to zero if N is less than 10.
n 
3    Subroutines and Function Subprograms Required:
e 
	    RANK

    TIE
 
    Method:
 v    STATISTICAL SUBROUTINES
gK    STATISTICAL SUBROUTINES                                      Page 2-29
  
 
    Refer to Siegel 1956.
 
 
 
    QTEST Subroutine
    QTEST Subroutine
  
K    QTEST tests whether three or more matched groups of  dichotomous  data
 K    differ significantly by the Cochran Q-test (Test program:  NPAR2.FOR).
  
%    Syntax:  CALL QTEST(A,N,M,Q,NDF)
f 
#    ________            ___________
 $    Argument            Description
 
K    A                   Input matrix, N by M, of dichotomous data  (0  and

                        1).
 
6    N                   Number of sets in each group.
 
*    M                   Number of groups.
 
6    Q                   Cochran Q statistic (output).
 
?    NDF                 Number of degrees of freedom (output).
L 

    Remarks:
_ 
    M must be 3 or greater.
 
    Method:
 
    Refer to Siegel 1956.
 
 
 
    RANK Subroutine
t    RANK Subroutine
 
K    RANK ranks a vector of  values.   RANK  assigns  tied  values  to  the
c2    average rank (Tests:  NONPAR.FOR, NPAR2.FOR).
 
    Syntax:  CALL RANK(A,R,N)
 
#    ________            ___________
 $    Argument            Description
 
2    A                   Input vector of N values.
 
K    R                   Output vector of  length  N.   Smallest  value  is
tK                        ranked  1, largest is ranked N.  Ties are assigned
a/                        average of tied ranks.
  
*    N                   Number of values.
 
    Method:
 
K    RANK searches vector A for successively larger elements.  RANK locates
 K    all  ties  and  computes  their value.  For example, if two values are
) n    STATISTICAL SUBROUTINES
eK    STATISTICAL SUBROUTINES                                      Page 2-30
a 
 
K    tied for sixth  rank,  RANK  assigns  each  of  them  a  rank  of  6.5
S    ((6+7)/2).
l 
 
 
    SRANK Subroutine
    SRANK Subroutine
s 
K    SRANK tests the correlation between two variables by the Spearman rank
I9    correlation coefficient (Test program:  NONPAR.FOR).
e 
-    Syntax:  CALL SRANK(A,B,R,N,RS,T,NDF,NR)
B 
#    ________            ___________
_$    Argument            Description
 
K    A                   Input vector of N observations for first variable.
s 
K    B                   Input  vector  of  N   observations   for   second

"                        variable.
 
I                                                                        N
LK    R                   Output vector  for  ranked  data,  length  is  2N.
 K                        Smallest  observation  is  ranked  1,  largest  is
 K                        ranked N.   Ties  are  assigned  average  of  tied
                         ranks.
p 
0    N                   Number of observations.
 
H    RS                  Spearman rank correlation coefficient (output).
 
=    T                   Test of significance of RS (output).
  
?    NDF                 Number of degrees of freedom (output).
a 
K    NR                  Code, 0 for unranked data in A and B, 1 for ranked
n1                        data in A and B (input).
  

    Remarks:
l 
,    SRANK sets T to 0 if N is less than 10.
 
3    Subroutines and Function Subprograms Required:
s 
	    RANK
     TIE
 
    Method:
 
    Refer to Siegel 1956.
 
 
 
    TIE Subroutine
    TIE Subroutine
s 
K    TIE calculates the correction factor due to ties  (Tests:  NONPAR.FOR,
     NPAR2.FOR).
 e    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-31
  
 
     Syntax:  CALL TIE(R,N,KT,T)
 
#    ________            ___________
t$    Argument            Description
 
K    R                   Input vector  of  ranks  of  length  N  containing
s'                        values 1 to N.
= 
1    N                   Number of ranked values.
i 
I    KT                  Input code for calculation of correction factor:
r 
1                        1 means solve equation 1
v1                        2 means solve equation 2
S 
4    T                   Correction factor (output):
 
-                                            3
 5                        Equation 1  T=SUM(CT3-CT)/12
e-                                            (
t6                        Equation 2  T=SUM(CT(CT-1)/2)
 
K                        where CT is the number of observations tied for  a
 $                        given rank.
 
    Method:
 
K    TIE searches vector R for successively larger ranks.  TIE counts  ties

'    and some correction factor 1 of 2.
  
 
 
    TWOAV Subroutine
    TWOAV Subroutine
t 
K    TWOAV tests whether samples  are  from  the  same  population  by  the
nK    Friedman     two-way     analysis     of     variance    test    (Test
N    program:  NONPAR.FOR).
O 
-    Syntax:  CALL TWOAV(A,R,N,M,W,XR,NDF,NR)
i 
#    ________            ___________
 $    Argument            Description
 
@    A                   Input matrix, N by M, of original data.
 
?    R                   Output matrix, N by M, of ranked data.
. 
*    N                   Number of groups.
 
7    M                   Number of cases in each group.
A 
.                                             M
0    W                   Work area of length 2M.
 
5    XR                  Friedman statistic (output).
  
?    NDF                 Number of degrees of freedom (output).
m 
K    NR                  Code, 0 for unranked data in A, 1 for ranked  data
 &                        in A (input).
 r    STATISTICAL SUBROUTINES
RK    STATISTICAL SUBROUTINES                                      Page 2-32
t 
 
3    Subroutines and Function Subprograms Required:
x 
	    RANK
  
    Method:
 
    Refer to Siegel 1956.
 
 
 
    UTEST Subroutine
    UTEST Subroutine
  
K    UTEST determines whether two independent  groups  are  from  the  same
TG    population by the Mann-Whitney U-test (Test program:  NONPAR.FOR).
  
+    Syntax:  CALL UTEST(A,R,N1,N2,U,Z,IER)
S 
#    ________            ___________
 $    Argument            Description
 
K    A                   Input  vector   of   cases   consisting   of   two
eK                        independent groups.  Smaller group precedes larger
s1                        group.  Length is N1+N2.
( 
K    R                   Output vector of ranks.  Smallest value is  ranked
 K                        1, largest is ranked N.  Ties are assigned average

9                        of tied ranks.  Length is N1+N2.
  
:    N1                  Number of cases in smaller group.
 
9    N2                  Number of cases in larger group.
N 
K    U                   Statistic used to  test  homogeneity  of  the  two
 )                        groups (output).
  
K    Z                   Measure of significance of U in  terms  of  normal
 /                        distribution (output).
p 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates that all values of one group are tied.
  

    Remarks:
c 
,    Z is set to zero if N2 is less than 20.
 
3    Subroutines and Function Subprograms Required:
a 
	    RANK
     TIE
 
    Method:
 
    Refer to Siegel 1956.
 o    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-33
T 
 
    WTEST Subroutine
    WTEST Subroutine
n 
K    WTEST uses the Kendall coefficient of concordance to test  the  degree
 K    of association among a number of variables (Test program:  NPAR2.FOR).
  
0    Syntax:  CALL WTEST(A,R,N,M,WA,W,CS,NDF,NR)
 
#    ________            ___________
 $    Argument            Description
 
@    A                   Input matrix, N by M, of original data.
 
K    R                   Output matrix, N by M, of ranked  data.   Smallest
nK                        value  is ranked 1, largest is ranked N.  Ties are
v8                        assigned average of tied ranks.
 
-    N                   Number of variables.
  
)    M                   Number of cases.
  
5                                                    M
t7    WA                  Work area vector of length 2M.
  
E    W                                                                                                                                                                                                                                                                   C                        bG $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              M "               Kendall coefficient of concordance (output).
R 
-    CS                  Chi-square (output).

 
?    NDF                 Number of degrees of freedom (output).
D 
K    NR                  Code, 0 for unranked data in A, 1 for ranked  data
a&                        in A (input).
 

    Remarks:
  
5    WTEST sets chi-square to 0 if M is 7 or smaller.
  
3    Subroutines and Function Subprograms Required:
  
	    RANK
i    TIE
 
    Method:
 
    Refer to Siegel 1956.
 
 
 
&    RANDOM NUMBER GENERATOR SUBROUTINE
'    RANDOM NUMBER GENERATOR SUBROUTINE
o 
K    The  section  that  follows  describes  the  random  number  generator
u    subroutine.
 
 
 
    GAUSS Subroutine
    GAUSS Subroutine
a 
K    GAUSS computes a normally distributed random number with a given  mean
a      STATISTICAL SUBROUTINES
_K    STATISTICAL SUBROUTINES                                      Page 2-34
A 
 
8    and standard deviation (Test program:  NONPAR.FOR).
 
#    Syntax:  CALL GAUSS(IX,S,AM,V)
m 
#    ________            ___________
 $    Argument            Description
 
K    IX                  IX is an integer dimensioned to two.  On the first
 K                        entry  to  GAUSS,  both  elements  of the IX array
cK                        should be equal to zero.   Thereafter,  they  will
cK                        contain  a  uniformly  distributed  integer random
SK                        number generated by the subroutine for use on  the
 6                        next entry to the subroutine.
 
K    S                   The  desired  standard  deviation  of  the  normal
K&                        distribution.
 
E    AM                  The desired mean of the normal distribution.

 
J    V                   The value of the computed normal random variable.
 

    Remarks:
R 
3    Subroutines and Function Subprograms Required:
  

    RANDU
 
    Method:
 
K    GAUSS uses 12 uniform random numbers to compute normal random  numbers

K    by  the central limit theorem.  GAUSS then adjusts the result to match
cK    the given mean and standard deviation.  GAUSS finds the uniform random
 H    numbers computed within the subroutine by the power residue method.
 
 
 
    REFERENCES
    REFERENCES

 
I                    ____________  __  ____________  ___________  ________
 K    Anderson, T.W.  Introduction  to  Multivariate  Statistical  Analysis.
 *    New York:  John Wiley and Sons, 1958.
 
I                                      ___ ___________  __  _____  _______
aK    Blackman, R.B., and J.W.  Tukey.  The Measurement  of  Power  Spectra.
f)    New York:  Dover Publications, 1959.
F 
J                 __________ ___________ ___ __________  __  ________  ____
K    Brown, R.G.  Smoothing, Forecasting and Prediction  of  Discrete  Time
 
    ______
/    Series.  New Jersey:  Prentice-Hall, 1963.
  
J                                        ____________  __________  ___  ___
K    Cooley, W.W., and  P.R.   Lohnes.   Multivariate  Procedures  for  the
_    __________ ________
,@    Behavioral Sciences.  New York:  John Wiley and Sons, 1962.
 
K    Dixon, W.J., ed.  BMDP Computer Programs Manual.  Los Angeles:   UCLA,
_
    1977.
 
K    Healey, J.R., and B.P.  Bogert.  "FORTRAN Subroutines for Time  Series
oF    Analysis," Communications of ACM, Vol. 6.  No. 1 (January, 1963).
 l    STATISTICAL SUBROUTINES
 K    STATISTICAL SUBROUTINES                                      Page 2-35
, 
 
K    Kaiser.  "Computer Program for Varimax Rotation  in  Factor  Analysis"

F    Educational and Psychological Measurement, Vol. 11, No. 3 (1959).
 
K    Kendall, M.G.  The Advance Theory of Statistics,  Vol. 1.   New  York:
     Hafner Press, 1977.
 
%               __________ __ ________
 K    Ostle, B.  Statistics in Research.  Ames:  Iowa State  College  Press,
 
    1975.
 
J                                       ____________  _______  ___  _______
K    Ralston, A., and  H. Wilf,  eds.   Mathematical  Methods  for  Digital
 
    _________
v6    Computers.  New York:  John Wiley and Sons, 1962.
 
D                _____________ __________ ___ ___ __________ ________
K    Siegal, S.  Nonparametric Statistics for the Behavioral Sciences.  New
v    York:  McGraw-Hill, 1956.
 
e 
t 
 
 
 
 
 
 
 
 
 
 

    CHAPTER 3
p    CHAPTER 3
 
    MATHEMATICAL OPERATIONS
     MATHEMATICAL OPERATIONS
 
 
 
K    This chapter describes the mathematical subroutines you use to analyze
     real-time data.
 
 
 
)    SPECIAL MATRIX OPERATIONS SUBROUTINES
w*    SPECIAL MATRIX OPERATIONS SUBROUTINES
 
K    The sections  that  follow  describe  the  special  matrix  operations
c    subroutines.
c 
 
 
    EIGEN Subroutine
    EIGEN Subroutine
  
K    EIGEN computes the eigenvalues and eigenvectors of a  real,  symmetric
n2    matrix (Test program:  FACTO.FOR, MCANO.FOR).
 
"    Syntax:  CALL EIGEN(A,R,N,MV)
 
#    ________            ___________
 $    Argument            Description
 
K    A                   Original   matrix   (symmetric),   destroyed    in
 K                        computation.   Resultant eigenvalues are developed
 E                        in diagonal of matrix A in descending order.
  
K    R                   Resultant   matrix   of    eigenvectors    (stored
 G                        column-wise, in same sequence as eigenvalues).
i 
3    N                   Order of matrices A and R.
  
$    MV                  Input code:
 
F                        0 means compute eigenvalues and eigenvectors.
K                        1 means compute eigenvalues only (R  need  not  be
 K                        dimensioned  but  must  still  appear  in  calling
 #                        sequence).

 

    Remarks:
L 
K    The original matrix A must be real  symmetric  (storage  mode  of  1).
a 2    MATHEMATICAL OPERATIONS
sK    MATHEMATICAL OPERATIONS                                       Page 3-2
  
 
9    Matrix A cannot be in the same location as matrix B.
E 
    Method:
 
K    EIGEN uses the diagonalization method originated by Jacobi and adapted
 G    by Von Neumann for large computers (Ralston and Wilf, eds.  1960).
  
 
 
    MINV Subroutine
,    MINV Subroutine
 
K    MINV inverts a matrix and calculates its determinant.   A  determinant
AK    of    zero    indicates    that   the   matrix   is   singular   (Test
 =    programs:  MCANO.FOR, MDISC.FOR, POLRG.FOR, SOLVEN.FOR).
l 
"    Syntax:  CALL MINV(A,N,D,L,M)
 
#    ________            ___________
 $    Argument            Description
 
K    A                   Input  matrix,  destroyed   in   computation   and
a7                        replaced by resultant inverse.
  
+    N                   Order of matrix A.
N 
/    D                   Resultant determinant.
  
1    L                   Work vector of length N.
  
1    M                   Work vector of length N.
o 

    Remarks:
  
'    Matrix A must be a general matrix.
  
    Method:
 
K    MINV uses  the  standard  Gauss-Jordan  method.   For  accuracy,  MINV
d*    employs both row and column pivoting.
 
 
 
    MATRIX SUBROUTINES
    MATRIX SUBROUTINES
0 
>    The sections that follow describe the matrix subroutines.
 
 
 
    ARRAY Subroutine
    ARRAY Subroutine
  
K    ARRAY converts a data array from single to double  dimension  or  vice
pK    versa.   ARRAY links the user program that has double dimension arrays
rK    and subroutines that operate on arrays of data  in  a  vector  fashion
N!    (Test program:  MACHK1.FOR).
  
*    Syntax:  CALL ARRAY(MODE,I,J,N,M,S,D)
 W    MATHEMATICAL OPERATIONS
EK    MATHEMATICAL OPERATIONS                                       Page 3-3
  
 
#    ________            ___________
 $    Argument            Description
 
<    MODE                Code indicating type of conversion:
 
A                        1 means from single to double dimension.
 A                        2 means from double to single dimension.
  
>    I                   Number of rows in actual data matrix.
 
A    J                   Number of columns in actual data matrix.
r 
K    N                   Number of rows  specified  for  the  matrix  D  in
 -                        dimension statement.
  
K    M                   Number of columns specified for the  matrix  D  in
 -                        dimension statement.
c 
K    S                   If MODE=1, this v                                                                                                                                                                                                                                                   D                        "{U $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             A "            ector containing the elements  of
cK                        a data matrix of size I by J is input.  Column I+1
FK                        of data matrix follows column I, and so forth.  If
 K                        MODE=2,  this vector is output representing a data
 K                        matrix of size  I  by  J  containing  its  columns
 K                        consecutively.   The  length  of  S  is  IJ, where
r                            J
                        IJ=IJ.
t 
K    D                   If MODE=1, this matrix of size N by  M  is  output
UK                        containing  a  data  matrix  of size I by J in the
tK                        first I rows and J columns.  If MODE=2, this N  by
oK                        M matrix is input containing a data matrix of size
rB                        I by J in the first I rows and J columns.
 

    Remarks:
B 
K    Vector S can be in the  same  location  as  matrix  D.   Vector  S  is
rK    referred  to  as  a  matrix in other scientific subroutines because it
MK    contains a data matrix.  This subroutine only  converts  general  data
r"    matrices (storage mode of 0).
 
    Method:
 
H    Refer to the discussion on variable data size in the Section 1.1.1.
 
 
 
    CADD Subroutine

    CADD Subroutine
 
K    CADD adds a column of one matrix to a column of another matrix  (Test:
     MACHK4.FOR).
m 
-    Syntax:  CALL CADD(A,ICA,R,ICR,N,M,MS,L)
  
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
      MATHEMATICAL OPERATIONS
rK    MATHEMATICAL OPERATIONS                                       Page 3-4
  
 
K    ICA                 Column in matrix A to be added to column ICR of R.
  
/    R                   Name of output matrix.
v 
I    ICR                 Column in matrix R where summation is developed.
u 
3    N                   Number of rows in A and R.
u 
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
t 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
e 
0    L                   Number of columns in R.
 

    Remarks:
  
K    Matrix R must be a general matrix and cannot be in the  same  location
_&    as matrix A, unless A is general.
 
3    Subroutines and Function Subprograms Required:
w 
    LOC
 
    Method:
 
K    CADD adds each element of column ICA of matrix A to the  corresponding
_'    element of column ICR of matrix R.
  
 
 
    CCPY Subroutine
1    CCPY Subroutine
 
K    CCPY copies a column of a matrix into  a  vector  (Tests:  MACHK3.FOR,

    MACHK4.FOR).
a 
%    Syntax:  CALL CCPY(A,L,R,N,M,MS)
T 
#    ________            ___________
o$    Argument            Description
 
.    A                   Name of input matrix.
 
6    L                   Column of A to be moved to R.
 
;    R                   Name of output vector of length N.
n 
-    N                   Number of rows in A.
h 
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
  f    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                       Page 3-5
: 
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  
3    Subroutines and Function Subprograms Required:
d 
    LOC
 
    Method:
 
K    CCPY moves elements of column L to corresponding positions  of  vector
_    R.
_ 
 
 
    CCUT Subroutine
_    CCUT Subroutine
 
K    CCUT partitions  a  matrix  between  specified  columns  to  form  two
H4    resultant matrices (Test program:  MACHK2.FOR).
 
'    Syntax:  CALL CCUT(A,L,R,S,N,M,MS)

 
#    ________            ___________
T$    Argument            Description
 
.    A                   Name of input matrix.
 
K    L                   Column of A to  the  left  of  which  partitioning
T%                        takes place.
P 
K    R                   Name of matrix to be formed from left  portion  of
                         A.
b 
K    S                   Name of matrix to be formed from right portion  of
G                        A.
n 
-    N                   Number of rows in A.
  
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
m 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  

    Remarks:
a 
K    Matrix R and matrix S must be general matrices.  Neither matrix R  nor
lK    matrix  S can be in the same location as matrix A.  Matrix R cannot be
m&    in the same location as matrix S.
 
3    Subroutines and Function Subprograms Required:
  
    LOC
      MATHEMATICAL OPERATIONS
dK    MATHEMATICAL OPERATIONS                                       Page 3-6
  
 
    Method:
 
K    CCUT moves elements of matrix A to the left of column L to form matrix
uK    R  of  N  rows  and  L-1  columns.  CCUT moves elements of matrix A in
 K    column L and to the right of L to form matrix S of N  rows  and  M-L+1


    columns.
s 
 
 
    CINT Subroutine
A    CINT Subroutine
 
C    CINT interchanges two columns of a matrix (Test:  COLROW.FOR).
E 
"    Syntax:  CALL CINT(A,N,LA,LB)
 
#    ________            ___________
M$    Argument            Description
 
(    A                   Name of matrix.
 
-    N                   Number of rows in A.
c 
B    LA                  Column to be interchanged with column LB.
 
B    LB                  Column to be interchanged with column LA.
 

    Remarks:
n 
'    Matrix A must be a general matrix.
. 
    Method:
 
K    CINT interchanges each element of column  LA  with  the  corresponding
     element of column LB.
 
 
 
    CSRT Subroutine
l    CSRT Subroutine
 
8    CSRT sorts columns of a matrix (Test:  MACHK4.FOR).
 
%    Syntax:  CALL CSRT(A,B,R,N,M,MS)
  
#    ________            ___________
r$    Argument            Description
 
;    A                   Name of input matrix to be sorted.
  
I    B                   Name of input vector which contains sorting key.
r 
6    R                   Name of sorted output matrix.
 
3    N                   Number of rows in A and R.
N 
F    M                   Number of columns in A and R and length of B.
 
G    MS                  One-digit number for storage mode of matrix A:
c a    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                       Page 3-7
R 
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
b 

    Remarks:
A 
K    Matrix R must be a general matrix and cannot be in the  same  location
aK    as  matrix  A.   M  must be greater than 1.  N must be greater than or
s    equal to 2.
 
3    Subroutines and Function Subprograms Required:
e 
    LOC
	    CCPY

 
    Method:
 
K    CSRT sorts the columns of input matrix A  to  form  output  matrix  R.
AK    CSRT  determines  the sorted column sequence by the values of elements
_    in row vector B.
_ 
K    The lowest valued element in B causes the corresponding column of A to
iK    be  placed  in the first column of R.  The highest valued element of B
tK    causes the corresponding row of A to be placed in the last  column  of
dK    R.   If  duplicate  values  exist  in  B, CSRT moves the corresponding
.1    columns of A to R in the same order as in A.
  
 
 
    CSUM Subroutine
     CSUM Subroutine
 
K    CSUM sums elements  of  each  column  to  form  a  row  vector  (Test:
n    MACHK3.FOR).
  
#    Syntax:  CALL CSUM(A,R,N,M,MS)
s 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
4    R                   Name of vector of length M.
 
-    N                   Number of rows in A.
F 
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A.
u 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  

    Remarks:
  
K    Vector R cannot be in the same  location  as  matrix  A  unless  A  is
       MATHEMATICAL OPERATIONS
 K    MAT                                                                                                                                                                                                                                                   E                        HPG $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             k "            HEMATICAL OPERATIONS                                       Page 3-8
  
 

    general.
n 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    CSUM sums elements down each column into a  corresponding  element  of
a    output row vector R.

 
 
 
    CTAB Subroutine
     CTAB Subroutine
 
K    CTAB tabulates the columns of data  based  on  the  key  contained  in
 K    vector B.  It adds columns of the original matrix into a new matrix in
cK    the columns specified by the floating point number in  the  respective
n5    row of the vector B (Test program:  MACHK4.FOR).
e 
)    Syntax:  CALL CTAB(A,B,R,S,N,M,MS,L)
t 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
I    B                   Name of input vector of length M containing key.
. 
K    R                   Name of output matrix containing summary of column
 K                        data.   It  is  initially  set  to  zero  by  this
 $                        subroutine.
 
K    S                   Name of output vector  of  length  L+1  containing
                          counts.
 
3    N                   Number of rows in A and R.
c 
0    M                   Number of columns in A.
 
0    L                   Number of columns in R.
 
F    MS                  One-digit number of storage mode of matrix A:
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
m 

    Remarks:
e 
'    Matrix R must be a general matrix.
0 e    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                       Page 3-9
  
 
3    Subroutines and Function Subprograms Required:
  
    LOC
	    CADD
a 
    Method:
 
K    CTAB tabulates the columns of data  in  matrix  A  based  on  the  key
bK    contained in vector B.  The floating point number in B(I) is truncated

K    to form J.  The Ith column of A is added to the Jth column of matrix R
nK    and  1  is added to S(J).  If the value of J is not between 1 and L, 1
e    is added to S(L+1).
 
K    Upon completion, the output matrix R contains a summary of column data
 K    as  specified  by vector B.  Each element in vector S contains a count
_K    of the number of columns of A used to form R.  Element S(L+1) contains
 K    the  number  of  columns of A not included in R as a result of J being
A#    less than 1 or greater than L.
h 
 
 
    CTIE Subroutine
c    CTIE Subroutine
 
K    CTIE adjoins two matrices with the same row  dimensions  to  form  one
i2    resultant matrix (Test program:  MACHK2.FOR).
 
,    Syntax:  CALL CTIE(A,B,R,N,M,MSA,MSB,L)
 
#    ________            ___________
e$    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
c 
/    R                   Name of output matrix.
o 
3    N                   Number of rows in A, B, R.
e 
0    M                   Number of columns in A.
 
G    MSA                 One-digit number for storage mode of matrix A:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
O 
9    MSB                 Same as MSA except for matrix B.
  
0    L                   Number of columns in B.
 

    Remarks:

 
K    Matrix R must be a general matrix and cannot be in the  same  location
rK    as either matrix A or matrix B.  Matrix A must have the same number of
o    rows as matrix B.
      MATHEMATICAL OPERATIONS
RK    MATHEMATICAL OPERATIONS                                      Page 3-10
t 
 
3    Subroutines and Function Subprograms Required:

 
    LOC
 
    Method:
 
K    Matrix B is attached to the right of matrix A.  The resultant matrix R
_%    contains N rows and M+L columns.
m 
 
 
    DCLA Subroutine
     DCLA Subroutine
 
K    DCLA sets each diagonal element of a matrix equal to  a  scalar  (Test
f    Program:  MACHK2.FOR).
  
!    Syntax:  CALL DCLA(A,C,N,MS)
  
#    ________            ___________
b$    Argument            Description
 
.    A                   Name of input matrix.
 
K    C                   Scalar.    (Single   precision   floating    point
A$                        variables.)
 
@    N                   Number of rows and columns in matrix A.
 
G    MS                  One-digit number for storage mode of matrix A.

 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.

 

    Remarks:

 
*    Input matrix must be a square matrix.
 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    DCLA replaces each element on the diagonal of a matrix with  a  scalar
n    C.
n 
 
 
    DCPY Subroutine
    DCPY Subroutine
 
K    DCPY copies diagonal  elements  of  a  matrix  into  a  vector  (Test:
     MACHK2.FOR).
  
!    Syntax:  CALL DCPY(A,R,N,MS)
  m    MATHEMATICAL OPERATIONS
oK    MATHEMATICAL OPERATIONS                                      Page 3-11
e 
 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
;    R                   Name of output vector of length N.
g 
@    N                   Number of rows and columns in matrix A.
 
G    MS                  One-digit number for storage mode of matrix A:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  

    Remarks:
  
.    The input matrix must be a square matrix.
 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    DCPY moves  the  elements  on  diagonal  of  matrix  to  corresponding
e    positions of vector R.
m 
 
 
    GMADD Subroutine
    GMADD Subroutine
L 
K    GMADD adds two general matrices (mode  0)  to  form  resultant  matrix
o!    (Test Program:  MACHK1.FOR).
R 
#    Syntax:  CALL GMADD(A,B,R,N,M)
, 
#    ________            ___________
_$    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
c 
/    R                   Name of output matrix.
  
3    N                   Number of rows in A, B, R.
  
6    M                   Number of columns in A, B, R.
 

    Remarks:
c 
5    All matrices must be stored as general matrices.
  
    Method:
 
0    GMADD performs addition element by element.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-12
  
 
    GMPRD Subroutine
    GMPRD Subroutine
1 
K    GMPRD multiplies two general matrices  to  form  a  resultant  general
 5    matrix (Test programs:  MACHK1.FOR, SOLVEN.FOR).
  
%    Syntax:  CALL GMPRD(A,B,R,N,M,L)
m 
#    ________            ___________
 $    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
o 
/    R                   Name of output matrix.

 
-    N                   Number of rows in A.
  
>    M                   Number of columns in A and rows in B.
 
0    L                   Number of columns in B.
 

    Remarks:
  
K    All matrices must be stored as general matrices.  Matrix R  cannot  be
 K    in  the  same  location as either matrix A or matrix B.  The number of
fI    columns of matrix A must be equal to the number of rows in matrix B.
m 
    Method:
 
K    GMPRD premultiplies the M by L matrix B by the N by  M  matrix  A  and
 .    stores the result in the N by L matrix R.
 
 
 
    GMSUB Subroutine
    GMSUB Subroutine
  
K    GMSUB subtracts one general matrix from another to  form  a  resultant
 (    matrix (Test program:  MACHK1.FOR).
 
#    Syntax:  CALL GMSUB(A,B,R,N,M)
. 
#    ________            ___________
c$    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
e 
/    R                   Name of output matrix.
  
3    N                   Number of rows in A, B, R.
  
6    M                   Number of columns in A, B, R.
 

    Remarks:

      MATHEMATICAL OPERATIONS
mK    MATHEMATICAL OPERATIONS                                      Page 3-13
  
 
                                                                                                                                                                                                                                                   F                        6{ $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             2 "            5    All matrices must be stored as general matrices.
  
    Method:
 
K    GMSUB  subtracts  matrix  B  elements  from  corresponding  matrix   A

    elements.
 
 
 
    GMTRA Subroutine
    GMTRA Subroutine
i 
;    GMTRA transposes a general matrix (Test:  MACHK1.FOR).
  
!    Syntax:  CALL GMTRA(A,R,N,M)
A 
#    ________            ___________
 $    Argument            Description
 
9    A                   Name of matrix to be transposed.
  
2    R                   Name of resultant matrix.
 
>    N                   Number of rows in A and columns in R.
 
>    M                   Number of columns in A and rows in R.
 

    Remarks:
t 
>    Matrix A and matrix R must be stored as general matrices.
 
    Method:
 
>    GMTRA transposes N by M matrix A to form M by N matrix R.
 
 
 
    GTPRD Subroutine
    GTPRD Subroutine
. 
K    GTPRD premultiplies a general  matrix  by  the  transpose  of  another
 0    general matrix (Test program:  MACHK1.FOR).
 
&    Syntax:  CALL GTPRD (A,B,R,N,M,L)
 
#    ________            ___________
 $    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
  
/    R                   Name of output matrix.
  
3    N                   Number of rows in A and B.
  
>    M                   Number of columns in A and rows in R.
 
6    L                   Number of columns in B and R.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-14
  
 

    Remarks:
  
K    All matrices must be stored as general matrices.  Matrix R  cannot  be
 9    in the same location as either matrix A or matrix B.
o 
    Method:
 
K    GTPRD does not actually calculate the matrix transpose of A.  Instead,
oK    it  takes  the elements of matrix A column wise (rather than row wise)
B(    for postmultiplication by matrix B.
 
 
 
    LOC Subroutine
    LOC Subroutine
I 
K    LOC computes a  vector  subscript  for  an  element  in  a  matrix  of
aD    specified storage mode (Test programs:  DASCR.FOR, MACHK2.FOR).
 
%    Syntax:  CALL LOC(I,J,IR,N,M,MS)
I 
#    ________            ___________
 $    Argument            Description
 
/    I                   Row number of element.
N 
2    J                   Column number of element.
 
4    IR                  Resultant vector subscript.
 
2    N                   Number of rows in matrix.
 
5    M                   Number of columns in matrix.
N 
E    MS                  One-digit number for storage mode of matrix:
t 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  
    Method:
 
4                                                   M
K    MS=0  Subscript is computed for a matrix with NM elements  in  storage
R    (general matrix).
 
7                                                      (
tK    MS=1  Subscript is computed for a  matrix  with  N(N+1)/2  in  storage
rK    (upper  triangle  of  symmetric  matrix).   If  element  is  in  lower
IK    triangular  portion,  subscript  is  corresponding  element  in  upper
S    triangle.
 
K    MS=2  Subscript is computed for a matrix with N  elements  in  storage
 K    (diagonal elements of diagonal matrix).  If element is not on diagonal
 7    (and therefore not in storage), IR is set to zero.
e      MATHEMATICAL OPERATIONS
DK    MATHEMATICAL OPERATIONS                                      Page 3-15
P 
 
    MADD Subroutine
     MADD Subroutine
 
K    MADD adds two matrices (of any mode) to form  resultant  matrix  (Test
s    program:  MACHK1.FOR).
  
*    Syntax:  CALL MADD(A,B,R,N,M,MSA,MSB)
 
#    ________            ___________
o$    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
  
/    R                   Name of output matrix.

 
3    N                   Number of rows in A, B, R.
  
6    M                   Number of columns in A, B, R.
 
F    MSA                 One-digit number of storage mode of matrix A:
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  
F    MSB                 One-digit number of storage mode of matrix B:
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    MADD first determines storage mode of output  matrix,  then  adds  the

K    corresponding elements.  The storage mode of the output matrix for all
n2    combinations of input matrices is as follows:
 
(        A                B            R
 
+    general           general      general
 +    general           symmetric    general

+    general           diagonal     general
 +    symmetric         general      general
 -    symmetric         symmetric    symmetric
 -    symmetric         diagonal     symmetric
g+    diagonal          general      general
t-    diagonal          symmetric    symmetric
o,    diagonal          diagonal     diagonal
      MATHEMATICAL OPERATIONS
K    MATHEMATICAL OPERATIONS                                      Page 3-16
e 
 
    MATA Subroutine
m    MATA Subroutine
 
K    MATA premultiplies a matrix by  its  transpose  to  form  a  symmetric
e(    matrix (Test program:  MACHK2.FOR).
 
#    Syntax:  CALL MATA(A,R,N,M,MS)
n 
#    ________            ___________
_$    Argument            Description
 
.    A                   Name of input matrix.
 
/    R                   Name of output matrix.
  
-    N                   Number of rows in A.
R 
K    M                   Number of columns in A.  Also number of  rows  and
f0                        number of columns in R.
 
G    MS                  One-digit number for storage mode of matrix A:
b 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
I 

    Remarks:
  
K    Matrix R must be a symmetric matrix with a storage mode of 1.   Matrix

2    R cannot be in the same location as matrix A.
 
3    Subroutines and Function Subprograms Required:
s 
    LOC
 
    Method:
 
K    Calculation  of  (A  transpose  A)  results  in  a  symmetric   matrix
LK    regardless  of  the storage mode of the input matrix.  The elements of
p    matrix A are not changed.
 
 
 
    MCPY Subroutine
     MCPY Subroutine
 
C    MCPY copies an entire matrix (Tests:  COLROW.FOR, MACHK2.FOR).
o 
#    Syntax:  CALL MCPY(A,R,N,M,MS)
  
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
/    R                   Name of output matrix.
i 
2    N                   Number of rows in A or R.
 b    MATHEMATICAL OPERATIONS
iK    MATHEMATICAL OPERATIONS                                      Page 3-17
m 
 
5    M                   Number of columns in A or R.
o 
K    MS                  One-digit number for storage mode of matrix A  and
n                        R:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
i 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    MCPY moves each element of matrix A to the  corresponding  element  of
A    matrix R.
 
 
 
    MFUN Subroutine
     MFUN Subroutine
 
K    MFUN applies a function  to  each  element  of  a  matrix  to  form  a

7    resultant matrix (Tests:  MACHK3.FOR, MACHK4.FOR).
  
%    Syntax:  CALL MFUN(A,F,R,N,M,MS)
, 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
K    F                   Name  of  FORTRAN-furnished   or   user   function
l$                        subprogram.
 
/    R                   Name of output matrix.
  
<    N                   Number of rows in matrices A and R.
 
?    M                   Number of columns in matrices A and R.
  
K    MS                  One-digit number for storage mode of matrix A  and
L                        R:
_ 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
n 

    Remarks:
R 
K    An external s                                                                                                                                                                                                                                                   G                        p. $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             R "           tatement must precede  the  CALL  statement  to  identify
 K    Argument  F as the name of a function.  Precision depends on precision
s    of function used.
 
3    Subroutines and Function Subprograms Required:
s e    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-18
. 
 
    LOC
 
    Method:
 
J    MFUN applies function F to each element of matrix A to form matrix R.
 
 
 
    MPRD Subroutine
n    MPRD Subroutine
 
K    MPRD  multiplies  two  matrices  to  form  a  resultant  matrix  (Test
     program:  MACHK4.FOR).
A 
,    Syntax:  CALL MPRD(A,B,R,N,M,MSA,MSB,L)
 
#    ________            ___________
 $    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
  
/    R                   Name of output matrix.
c 
3    N                   Number of rows in A and R.
N 
>    M                   Number of columns in A and rows in B.
 
F    MSA                 One-digit number of storage mode of matrix A:
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
l 
F    MSB                 One-digit number of storage mode of matrix B:
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
a 
6    L                   Number of columns in B and R.
 

    Remarks:
  
K    Matrix R cannot be in the same location as either matrix A  or  matrix
 K    B.   The number of columns of matrix A must be equal to number of rows
a    of matrix B.
H 
3    Subroutines and Function Subprograms Required:

 
    LOC
 
    Method:
 
K    MPRD premultiplies the M by L matrix B by the N  by  M  matrix  A  and
eK    stores  the  result in the N by L matrix R.  This is a row into column
  I    MATHEMATICAL OPERATIONS
vK    MATHEMATICAL OPERATIONS                                      Page 3-19
n 
 

    product.
i 
K    The storage mode of the output matrix for all  combinations  of  input
q    matrices is as follows:
 
(        A                B            R
 
+    general           general      general
M+    general           symmetric    general
L+    general           diagonal     general
 +    symmetric         general      general
.+    symmetric         symmetric    general
A+    symmetric         diagonal     general
S+    diagonal          general      general

+    diagonal          symmetric    general
s,    diagonal          diagonal     diagonal
 
 
 
 
    MSTR Subroutine
r    MSTR Subroutine
 
G    MSTR changes storage mode of a matrix (Test program:  MACHK4.FOR).
  
&    Syntax:  CALL MSTR(A,R,N,MSA,MSR)
 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
/    R                   Name of output matrix.
  
?    N                   Number of rows and columns in A and R.
d 
G    MSA                 One-digit number for storage mode of matrix A:
e 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.

 
G    MSR                 One-digit number for storage mode of matrix R:
l 
$                        0  General.
%                        1  Symmetric
 %                        2  Diagonal.
o 

    Remarks:
s 
K    Matrix A must be a square matrix.  Matrix R  cannot  be  in  the  same
     location as matrix A.
 
3    Subroutines and Function Subprograms Required:
  
    LOC
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-20
  
 
    Method:
 
1    MSTR restructures matrix A to form matrix R.
_ 
    MSA     MSR
 
2     0       0     Matrix A is moved to matrix R.
 
K     0       1     The upper triangle elements of  a  general  matrix  are
r4                   used to form a symmetric matrix.
 
K     0       2     The diagonal elements of a general matrix are  used  to
 +                   form a diagonal matrix.

 
K     1       0     A symmetric  matrix  is  expanded  to  form  a  general
                    matrix.
. 
2     1       1     Matrix A is moved to matrix R.
 
K     1       2     The diagonal elements of a symmetric matrix are used to
e+                   form a diagonal matrix.
  
K     2       0     A diagonal matrix is expanded by inserting missing zero
26                   elements to form a general matrix.
 
K     2       1     A diagonal matrix is expanded by inserting missing zero
o8                   elements to form a symmetric matrix.
 
2     2       2     Matrix A is moved to matrix R.
 
 
 
 
    MSUB Subroutine
t    MSUB Subroutine
 
K    MSUB subtracts one matrix from another, element by element, to form  a
r2    resultant matrix (Test program:  MACHK3.FOR).
 
*    Syntax:  CALL MSUB(A,B,R,N,M,MSA,MSB)
 
#    ________            ___________
 $    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
t 
/    R                   Name of output matrix.
d 
3    N                   Number of rows in A, B, R.
I 
6    M                   Number of columns in A, B, R.
 
G    MSA                 One-digit number for storage mode of matrix A:
r 
$                        0  General.
 b    MATHEMATICAL OPERATIONS
aK    MATHEMATICAL OPERATIONS                                      Page 3-21
L 
 
&                        1  Symmetric.
%                        2  Diagonal.
D 
G    MSB                 One-digit number for storage mode of matrix B:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
N 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    MSUB first determines the structure of  the  output  matrix,  then  it
rF    subtracts matrix B elements from corresponding matrix A elements.
 
K    The storage mode of the output matrix for all  combinations  of  input

    matrices is as follows:
 
(        A                B            R
 
+    general           general      general
 +    general           symmetric    general
r+    general           diagonal     general
:+    symmetric         general      general
 -    symmetric         symmetric    symmetric
r-    symmetric         diagonal     symmetric
.+    diagonal          general      general
n-    diagonal          symmetric    symmetric
P,    diagonal          diagonal     diagonal
 
 
 
    MTRA Subroutine
.    MTRA Subroutine
 
H    MTRA transposes a matrix (of any mode) (Test program:  COLROW.FOR).
 
#    Syntax:  CALL MTRA(A,R,N,M,MS)
  
#    ________            ___________
 $    Argument            Description
 
9    A                   Name of matrix to be transposed.
o 
/    R                   Name of output matrix.
I 
>    N                   Number of rows in A and columns in R.
 
>    M                   Number of columns in A and rows in R.
 
K    MS                  One-digit number for storage mode of matrix A  and
                         R:
  
$                        0  General.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-22
o 
 
&                        1  Symmetric.
%                        2  Diagonal.
a 

    Remarks:
e 
9    Matrix R cannot be in the same location as matrix A.
u 
3    Subroutines and function Subprograms Required:
u 
	    MCPY
h 
    Method:
 
K    MTRA transposes N by M matrix A to form M by N matrix R by moving each
 K    row of A into the corresponding column of R.  If matrix A is symmetric
_1    or diagonal, then matrix R is the same as A.
  
 
 
    RADD Subroutine
t    RADD Subroutine
 
K    RADD  adds  row  of  one  matrix  to  row  of  another  matrix   (Test
     program:  MACHK4.FOR).

 
-    Syntax:  CALL RADD(A,IRA,R,IRR,N,M,MS,L)
  
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
K    IRA                 Row in matrix A to be added to row IRR  of  matrix

                        R.

 
/    R                   Name of output matrix.
  
F    IRR                 Row in matrix R where summation is developed.
 
-    N                   Number                                                                                                                                                                                                                                                    H                        B $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             c+ "           of rows in A.
r 
6    M                   Number of columns in A and R.
 
G    MS                  One-digit number for storage mode of matrix A:
n 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
R 
-    L                   Number of rows in R.
1 

    Remarks:
C 
K    Matrix R must be a general matrix.  Matrix R cannot  be  in  the  same
t/    location as matrix A, unless A is general.
e 
3    Subroutines and Function Subprograms Required:
a c    MATHEMATICAL OPERATIONS
aK    MATHEMATICAL OPERATIONS                                      Page 3-23
, 
 
    LOC
 
    Method:
 
K    RADD adds each element of row IRA of matrix A to corresponding element
     of row IRR of matrix R.
 
 
 
    RCPY Subroutine
     RCPY Subroutine
 
K    RCPY   copies   a   row   of   a   matrix   into   a   vector    (Test
     program:  MACHK4.FOR).
A 
%    Syntax:  CALL RCPY(A,L,R,N,M,MS)
e 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
3    L                   Row of A to be moved to R.
. 
;    R                   Name of output vector of length M.
  
-    N                   Number of rows in A.

 
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
L 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.

 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
I    RCPY moves elements of row L to corresponding positions of vector R.
g 
 
 
    RCUT Subroutine
e    RCUT Subroutine
 
K    RCUT partitions a matrix between specified rows to form two  resultant
s*    matrices (Test program:  MACHK2.FOR).
 
'    Syntax:  CALL RCUT(A,L,R,S,N,M,MS)
  
#    ________            ___________
S$    Argument            Description
 
.    A                   Name of input matrix.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-24

 
 
G    L                   Row of A above which partitioning takes place.
  
K    R                   Name of matrix to be formed from upper portion  of
                         A.
i 
K    S                   Name of matrix to be formed from lower portion  of
                         A.
  
-    N                   Number of rows in A.
n 
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
a 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
t 

    Remarks:
  
K    Matrix R and matrix S must be general matrices.  Neither matrix R  nor
 K    matrix  S can be in the same location as matrix A.  Matrix R cannot be

&    in the same location as matrix S.
 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    RCUT moves elements of matrix A above row L to form matrix  R  of  L-1
TK    rows  and  M  columns.   RCUT  moves elements of matrix A in row L and
38    below to form matrix S of N-L+1 rows and M columns.
 
 
 
    RECP Subroutine
     RECP Subroutine
 
K    RECP calculates the reciprocal of  an  element.   This  is  a  FORTRAN
 K    function subprogram that can be used as an argument by subroutine MFUN
o!    (Test program:  MACHK4.FOR).
  
    Syntax:  CALL RECP(E)
 
#    ________            ___________
 $    Argument            Description
 
(    E                   Matrix element.
 

    Remarks:
  
.    Reciprocal of zero is taken to be 1.0E75.
 
    Method:
 
/    Reciprocal of element E is placed in RECP.
       MATHEMATICAL OPERATIONS
sK    MATHEMATICAL OPERATIONS                                      Page 3-25
  
 
    RINT Subroutine
n    RINT Subroutine
 
@    RINT interchanges two rows of a matrix (Test:  COLROW.FOR).
 
$    Syntax:  CALL RINT(A,N,M,LA,LB)
 
#    ________            ___________
s$    Argument            Description
 
(    A                   Name of matrix.
 
-    N                   Number of rows in A.
  
0    M                   Number of columns in A.
 
<    LA                  Row to be interchanged with row LB.
 
<    LB                  Row to be interchanged with row LA.
 

    Remarks:
L 
'    Matrix A must be a general matrix.
  
    Method:
 
K    RINT interchanges each  element  of  row  LA  with  the  corresponding
r    element of row LB.
  
 
 
    RSRT Subroutine
n    RSRT Subroutine
 
=    RSRT sorts rows of a matrix (Test program:  MACHK3.FOR).
  
%    Syntax:  CALL RSRT(A,B,R,N,M,MS)

 
#    ________            ___________
s$    Argument            Description
 
;    A                   Name of input matrix to be sorted.
  
I    B                   Name of input vector which contains sorting key.
A 
6    R                   Name of sorted output matrix.
 
C    N                   Number of rows in A and R and length of B.
  
6    M                   Number of columns in A and R.
 
G    MS                  One-digit number for storage mode of matrix A:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
m 

    Remarks:
  L    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-26
  
 
K    Matrix R must be a general matrix and cannot be in the  same  location
aK    as  matrix  A.   N  must be greater than 1.  M must be greater than or
     equal to 2.
 
3    Subroutines and Function Subprograms Required:
r 
    LOC
 
    Method:
 
K    RSRT sorts rows of input matrix A  to  form  output  matrix  R.   RSRT
 K    determines  the  sorted  row sequence by the values of the elements in
 K    column  vector  B.   The  lowest  valued  element  in  B  causes   the
.K    corresponding  row  of  A  to  be  placed  in the first row of R.  The
cK    highest valued element of B causes the corresponding row of  A  to  be
 K    placed  in  the  last  row of R.  If duplicate values exist in B, RSRT
 F    moves the corresponding rows of A to R in the same order as in A.
 
 
 
    RSUM Subroutine
     RSUM Subroutine
 
K    RSUM sums elements  of  each  row  to  form  a  column  vector  (Test:
b    MACHK3.FOR).

 
#    Syntax:  CALL RSUM(A,R,N,M,MS)
a 
#    ________            ___________
e$    Argument            Description
 
.    A                   Name of input matrix.
 
4    R                   Name of vector of length N.
 
-    N                   Number of rows in A.
  
0    M                   Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.

 

    Remarks:

 
K    Vector R cannot be in the same  location  as  matrix  A  unless  A  is
t
    general.
o 
3    Subroutines and Function Subprograms Required:
: 
    LOC
 
    Method:
 
K    RSUM sums elements across each row into  a  corresponding  element  of
p i    MATHEMATICAL OPERATIONS
iK    MATHEMATICAL OPERATIONS                                      Page 3-27

 
 
    output column vector R.
 
 
 
    RTAB Subroutine
f    RTAB Subroutine
 
K    RTAB tabulates the rows of data based on  the  key  contained  in  the
AK    vector  B.  Rows of the original matrix are added into a new matrix in
 K    the rows specified by the floating-point number in the respective  row
m1    of the vector B (Test program:  MACHK4.FOR).
A 
)    Syntax:  CALL RTAB(A,B,R,S,N,M,L,MS)
  
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
I    B                   Name of input vector of length N containing key.
M 
K    R                   Name of output matrix containing  summary  of  row
eC                        data.  It is initially set to zero by RTAB
  
K    S                   Name  of  output  vector  length  L+1   containing
                          counts.
 
-    N                   Number of rows in A.

 
6    M                   Number of columns in A and R.
 
-    L                   Number of rows in R.
u 
G    MS                  One-digit number for stor                                                                                                                                                                                                                                                   I                        ǥ $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "     '      age mode of matrix A:

 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.

 

    Remarks:
M 
'    Matrix R must be a general matrix.
w 
3    Subroutines and Function Subprograms Required:
R 
    LOC
	    RADD
  
    Method:
 
K    RTAB tabulates rows of data matrix A based on  the  key  contained  in
iK    vector  B.   It truncates the floating-point number in B(I) to form J.
AK    RTAB adds the Ith row of A to the Jth row of R element by element  and
nK    1  is  added  to  S(J).   If  J  is not between 1 and L, 1 is added to

    S(L+1).
 
K    This procedure is repeated  for  every  element  in  vector  B.   Upon
o u    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-28
m 
 
K    completion,  the  output  matrix  R  contains a summary of row data as
oK    specified by vector B.  Each element in vector S contains a  count  of
 K    the  number of rows of A not included in R as a result of J being less
s    than or greater than L.
 
 
 
    RTIE Subroutine
t    RTIE Subroutine
 
K    RTIE adjoins two matrices with the same column dimension to  form  one
R2    resultant matrix (Test program:  MACHK2.FOR).
 
,    Syntax:  CALL RTIE(A,B,R,N,M,MSA,MSB,L)
 
#    ________            ___________
g$    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
  
/    R                   Name of output matrix.
  
-    N                   Number of rows in A.
e 
6    M                   Number of columns in A, B, R.
 
G    MSA                 One-digit number for storage mode of matrix A:
g 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
m 
G    MSB                 One-digit number for storage mode of matrix B:
m 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
T 
-    L                   Number of rows in B.
  

    Remarks:
  
K    Matrix R must be a general matrix and cannot be in the  same  location
 K    as either matrix A or matrix B.  Matrix A must have the same number of
     columns as matrix B.
o 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    RTIE attaches matrix B to the  bottom  of  matrix  A.   The  resultant
 .    matrix R contains N+L rows and M columns.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-29
  
 
    SADD Subroutine
     SADD Subroutine
 
K    SADD adds a scalar to each element of a matrix  to  form  a  resultant
r(    matrix (Test program:  MACHK4.FOR).
 
%    Syntax:  CALL SADD(A,C,R,N,M,MS)

 
#    ________            ___________
i$    Argument            Description
 
.    A                   Name of input matrix.
 
     C                   Scalar.
 
/    R                   Name of output matrix.
  
:    N                   Number of rows in matrix A and R.
 
=    M                   Number of columns in matrix A and R.
i 
K    MS                  One-digit number for storage mode of matrix A  and
                         R:
R 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
m 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
6    SADD adds a scalar to each element of the matrix.
 
 
 
    SCLA Subroutine
     SCLA Subroutine
 
K    SCLA sets each element of a matrix equal  to  a  given  scalar  (Test:
     MACHK4.FOR).
  
#    Syntax:  CALL SCLA(A,C,N,M,MS)
c 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
     C                   Scalar.
 
4    N                   Number of rows in matrix A.
 
7    M                   Number of columns in matrix A.
a 
G    MS                  One-digit number for storage mode of matrix A:
g n    MATHEMATICAL OPERATIONS
K    MATHEMATICAL OPERATIONS                                      Page 3-30
  
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
h 
3    Subroutines and Function Subprograms Required:
n 
    LOC
 
    Method:
 
:    SCLA replaces each element of matrix A by a scalar C.
 
 
 
    SCMA Subroutine
e    SCMA Subroutine
 
K    SCMA multiplies a column of matrix by a scalar and adds the product to
uC    another column of the same matrix (Test program:  COLROW.FOR).
( 
$    Syntax:  CALL SCMA(A,C,N,LA,LB)
 
#    ________            ___________
_$    Argument            Description
 
(    A                   Name of matrix.
 
     C                   Scalar.
 
-    N                   Number of rows in A.
i 
B    LA                  Column in A to be multiplied by a scalar.
 
K    LB                  Column in A to which product is added.   If  0  is
dD                        specified, product replaces elements in LA.
 

    Remarks:
  
'    Matrix A must be a general matrix.
r 
    Method:
 
K    SCMA multiplies each element of column LA by a scalar C and  adds  the
tK    product  to the corresponding element of column LA.  Column LA remains
TK    unaffected  by  the  operation.   If  Argument   LB   contains   zero,
 K    multiplication  by  the  scalar  is performed and the product replaces
o    elements in LA.
 
 
 
    SDIV Subroutine
m    SDIV Subroutine
 
K    SDIV divides each element of a matrix by a scalar to form a  resultant
 (    matrix (Test program:  MACHK4.FOR).
 
%    Syntax:  CALL SDIV(A,C,R,N,M,MS)
n      MATHEMATICAL OPERATIONS
aK    MATHEMATICAL OPERATIONS                                      Page 3-31
  
 
#    ________            ___________
h$    Argument            Description
 
.    A                   Name of input matrix.
 
     C                   Scalar.
 
/    R                   Name of output matrix.
d 
:    N                   Number of rows in matrix A and R.
 
=    M                   Number of columns in matrix A and R.
r 
K    MS                  One-digit number for storage mode of matrix A  and
R                        R:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
, 

    Remarks:
_ 
K    If the scalar is zero, SDIV divides only once to cause floating  point
     overflow condition.
 
3    Subroutines and Function Subprograms Required:
f 
    LOC
 
    Method:
 
7    SDIV divides each element of a matrix by a scalar.
N 
 
 
    SMPY Subroutine
M    SMPY Subroutine
 
K    SMPY multiplies each element of  a  matrix  by  a  scalar  to  form  a
e2    resultant matrix (Test program:  MACHK3.FOR).
 
%    Syntax:  CALL SMPY(A,C,R,N,M,MS)
R 
#    ________            ___________
t$    Argument            Description
 
.    A                   Name of input matrix.
 
     C                   Scalar.
 
/    R                   Name of output matrix.
t 
:    N                   Number of rows in matrix A and R.
 
=    M                   Number of columns in matrix A and R.
  
G    MS                  One-digit number for storage mode of matrix A:

 
    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-32
  
 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
y 
3    Subroutines and Function Subprograms Required:
o 
    LOC
 
    Method:
 
:    SMPY multiplies a scalar by each element of a matrix.
 
 
 
    SRMA Subroutine
_    SRMA Subroutine
 
K    SRMA multiplies a row of matrix by a scalar and adds  the  product  to
 @    another row of the same matrix (Test program:  COLROW.FOR).
 
&    Syntax:  CALL SRMA(A,C,N,M,LA,LB)
 
#    ________            ___________

$    Argument            Description
 
.    A                   Name of input matrix.
 
     C                   Scalar.
 
-    N                   Number of rows in A.
c 
0    M                   Number of columns in A.
 
?    LA                  Row in A to be multiplied by a scalar.

 
K    LB                  Row in A to which the product is added.  If  0  is
dK                                                                                                                                                                                                                                                                      J                        XR^ $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             ZX "     8           specified,  the  product  replaces elements in row
e                        LA.
 

    Remarks:
  
'    Matrix A must be a general matrix.
  
    Method:
 
K    SRMA multiplies each element of row LA by a  scalar  C  and  adds  the
rK    product  to  the  corresponding  element  of  row  LB.  Row LA remains
uK    unaffected  by  the  operation.   If  Argument   LB   contains   zero,
BK    multiplication  by  the  scalar  is performed and the product replaces
s    elements in row LA.
 
 
 
    SSUB Subroutine
n    SSUB Subroutine
 
K    SSUB subtracts a scalar from each  element  of  a  matrix  to  form  a
 2    resultant matrix (Test program:  MACHK4.FOR).
 e    MATHEMATICAL OPERATIONS
TK    MATHEMATICAL OPERATIONS                                      Page 3-33
  
 
%    Syntax:  CALL SSUB(A,C,R,N,M,MS)
  
#    ________            ___________
y$    Argument            Description
 
.    A                   Name of input matrix.
 
     C                   Scalar.
 
/    R                   Name of output matrix.

 
:    N                   Number of rows in matrix A and R.
 
=    M                   Number of columns in matrix A and R.
  
K    MS                  One-digit number for storage mode of matrix A  and
                         R:
  
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
t 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
;    SSUB subtracts a scalar from each element of a matrix.
  
 
 
    TPRD Subroutine
w    TPRD Subroutine
 
K    TPRD transposes a matrix and postmultiplies it by  another  matrix  to
c9    form a resultant matrix (Test program:  MACHK2.FOR).
  
,    Syntax:  CALL TPRD(A,B,R,N,M,MSA,MSB,L)
 
#    ________            ___________
p$    Argument            Description
 
4    A                   Name of first input matrix.
 
5    B                   Name of second input matrix.
s 
/    R                   Name of output matrix.
T 
3    N                   Number of rows in A and B.
  
>    M                   Number of columns in A and rows in R.
 
G    MSA                 One-digit number for storage mode of matrix A:
a 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
       MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-34
  
 
G    MSB                 One-digit number for storage mode of matrix B:
a 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
  
6    L                   Number of columns in B and R.
 

    Remarks:
e 
K    Matrix R cannot be in the same location as either matrix A  or  matrix
     B.

 
3    Subroutines and Function Subprograms Required:
  
    LOC
 
    Method:
 
K    TPRD does not actually calculate the matrix transpose of A.   Instead,
 K    it  takes  the elements in matrix A column-wise (rather than row-wise)
L$    for multiplication by matrix B.
 
K    The storage mode of the output matrix for all  combinations  of  input
     matrices is as follows:
 
(        A                B            R
 
+    general           general      general
 +    general           symmetric    general
m+    general           diagonal     general
 +    symmetric         general      general
e+    symmetric         symmetric    general
 +    symmetric         diagonal     general
 +    diagonal          general      general
t+    diagonal          symmetric    general
A,    diagonal          diagonal     diagonal
 
 
 
    XCPY Subroutine
     XCPY Subroutine
 
K    XCPY   copies   a   submatrix    from    a    given    matrix    (Test
     program:  MACHK2.FOR).
l 
/    Syntax:  CALL XCPY(A,R,L,K,NR,MR,NA,MA,MS)
u 
#    ________            ___________
 $    Argument            Description
 
.    A                   Name of input matrix.
 
/    R                   Name of output matrix.
a 
H    L                   Row of A where first element of R can be found.
 e    MATHEMATICAL OPERATIONS
CK    MATHEMATICAL OPERATIONS                                      Page 3-35
  
 
K    K                   Column of A where first element of R can be found.
  
<    NR                  Number of rows to be copied into R.
 
?    MR                  Number of columns to be copied into R.
  
-    NA                  Number of rows in A.
  
0    MA                  Number of columns in A.
 
G    MS                  One-digit number for storage mode of matrix A:
e 
$                        0  General.
&                        1  Symmetric.
%                        2  Diagonal.
e 

    Remarks:
m 
K    Matrix R must be a general matrix and cannot be in the  same  location
     as matrix A.
L 
3    Subroutines and Function Subprograms Required:
g 
    LOC
 
    Method:
 
K    XCPY forms matrix R by copying a portion of matrix A.  This is done by
 K    extracting  NR  rows and MR columns of matrix A, starting with element

    at row L, column K.
 
 
 
/    INTEGRATION AND DIFFERENTIATION SUBROUTINES
i0    INTEGRATION AND DIFFERENTIATION SUBROUTINES
 
K    The sections that follow describe the integration and  differentiation
R    subroutines.
  
 
 
    QATR Subroutine

    QATR Subroutine
 
K    QATR uses Romberg's extrapolation method to approximate  the  integral
 H    of a given function by trapezoidal rule (Test program:  INTEG.FOR).
 
5    Syntax:  CALL QATR(XL,XU,EPS,NDIM,FCT,Y,IER,AUX)
  
#    ________            ___________
t$    Argument            Description
 
9    XL                  The lower bound of the interval.
  
9    XU                  The upper bound of the interval.
  
?    EPS                 The upper bound of the absolute error.

      MATHEMATICAL OPERATIONS
tK    MATHEMATICAL OPERATIONS                                      Page 3-36
  
 
K    NDIM                The dimension of the auxiliary storage array  AUX.
oK                        NDIM-1  is the maximal number of bisections of the
L*                        interval (XL,XU).
 
K    FCT                 The name of the external function subprogram used.
P 
K    Y                   The  resulting  approximation  for  the   integral
                         value.
i 
.    IER                 Resultant error code:
 
K                        0 means it was  possible  to  reach  the  required
 "                        accuracy.
$                          No error.
 
K                        1 means it is impossible  to  reach  the  required
 !                        accuracy
 6                          because of rounding errors.
 
K                        2 means  it  was  impossible  to  check   accuracy
e                         because
K                          NDIM is less than 5, or  the  required  accuracy
                         could
B                          not be reached with NDIM-1 steps.  NDIM
/                          should be increased.
  
H    AUX                 An auxiliary storage array with dimension NDIM.
 

    Remarks:

 
1    Argument FCT requires an external statement.
  
3    Subroutines and Function Subprograms Required:
  
K    You must supply the external function subprogram FCT(X).  Its argument
     X should not be destroyed.
r 
    Method:
 
K    QATR evaluates y by  trapezoidal  rule  on  Romberg's  principle.   On

K    return,  Y  contains  the  best possible approximation of the integral
 K    value and  vector  AUX,  the  upward  diagonal  of  Romberg's  scheme.
 K    Components  AUX(I)  (I=1,2,...,IEND,  with  IEND less than or equal to
 K    NDIM) become approximations to integral value with decreasing accuracy
oK    by  multiplication  with  (XU-XL).   Refer  to Filippi 1964 and Bauser
t
    1961.
 
 
 
    QSF Subroutine
    QSF Subroutine
i 
K    QSF computes the vector of integral values  for  a  given  equidistant
 9    table of function values (Test program:  QDINT.FOR).
  
"    Syntax:  CALL QSF(H,Y,Z NDIM)
 e    MATHEMATICAL OPERATIONS
cK    MATHEMATICAL OPERATIONS                                      Page 3-37
r 
 
#    ________            ___________
 $    Argument            Description
 
:    H                   The increment of argument values.
 
=    Y                   The input vector of function                                                                                                                                                                                                                                                    K                        #; $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "     I      values.

 
K    Z                   The resulting vector of integral values.  Z may be
f*                        identical with Y.
 
:    NDIM                The dimension of vectors Y and Z.
 

    Remarks:
T 
/    No action is taken if NDIM is less than 3.
  
    Method:
 
K    Beginning with Z(1)=0, evaluation of vector Z  is  done  by  means  of
 K    Simpson's  rule  together  with  Newton's 3/8 rule or a combination of
 K    these two rules.  Truncation error is of the order H**5 (that is,  the
 K    fourth order method).  Only in case NDIM=3 truncation error of Z(2) is
m@    of order H**4.  Refer to Hildebrand 1974 and Zurmuehl 1963.
 
 
 
    RKGS Subroutine
     RKGS Subroutine
 
K    RKGS solves a system of first-order  ordinary  differential  equations
 K    with    initial    values    by    the    Runge-Kutta   method   (Test
     program:  RKGSTT.FOR).
  
;    Syntax:  CALL RKGS(PRMT,Y,DERY,NDIM,IHLF,FCT,OUTP,AUX)
m 
#    ________            ___________
h$    Argument            Description
 
K    PRMT                An input and output vector with dimension  greater
tK                        than  or  equal to 5, that specifies the Arguments
RK                        of the interval and of accuracy,  and  serves  for
rK                        communication between output subroutine (furnished
aK                        by you) and subroutine RKGS.  Except PRMT(5),  the
(K                        components  are  not  destroyed  by  RKGS.   These
t(                        components are:
 
=    PRMT(1)             Lower bound of the interval (input).
  
=    PRMT(2)             Upper bound of the interval (input).
i 
K    PRMT(3)             Initial  increment  of  the  independent  variable
K!                        (input).
R 
K    PRMT(4)             Upper error bound (input).  If absolute  error  is
 K                        greater  than  PRMT(4), increment gets halved.  If
.K                        increment is less than PRMT(4)/50, increment  gets
 K                        doubled.   You may change PRMT(4) by means of your
r+                        output subroutine.
  m    MATHEMATICAL OPERATIONS
iK    MATHEMATICAL OPERATIONS                                      Page 3-38
x 
 
K    PRMT(5)             No input Argument.   RKGS  initializes  PRMT(5)=0.
.K                        If  you  want  to terminate subroutine RKGS at any
 K                        point, you must change PRMT(5) to nonzero by means
 K                        of  subroutine OUTP.  Further components of vector

K                        PRMT are feasible  if  its  dimension  is  defined
tK                        greater  than 5; however, subroutine RKGS does not
mK                        require and change them.  Nevertheless,  they  can
nK                        be  useful  for  handing result values to the main
tK                        program  (calling  RKGS)  that  are  obtained   by

K                        special   manipulations   with   output   data  in
 )                        subroutine OUTP.
l 
K    Y                   Input  vector  of  initial   values   (destroyed).
TK                        Later,  Y  is  the  resulting  vector of dependent
mE                        variables computed at intermediate points X.
  
K    DERY                Input vector of error  weights  (destroyed).   The
 K                        sum  of its components must be equal to 1.  Later,
 K                        DERY is the vector of derivatives that  belong  to
s8                        function values Y at a point X.
 
K    NDIM                An  input  value  that  specifies  the  number  of
a1                        equations in the system.
  
K    IHLF                An output  value  that  specifies  the  number  of
 K                        bisections  of  the  initial  increment.   If IHLF
 K                        becomes greater than 10, subroutine  RKGS  returns
_K                        with  error  message  IHLF=11  into  main program.
 K                        Error message IHLF=12 or IHLF=13 appears  in  case
aK                        PRMT(3)=0           or           in           case

@                        SIGN(PRMT(3)).NE.SIGN(PRMT(2)-PRMT(1)),
&                        respectively.
 
K    FCT                 The name of an  external  subroutine  used.   This
eK                        subroutine  computes  the  right-hand side DERY of
 K                        the system to given values X and Y.  Its  Argument
NK                        list  must be X,Y,DERY.  Subroutine FCT should not
 )                        destroy X and Y.
  
K    OUTP                The name of an external  output  subroutine  used.
0K                        Its Argument list must be X,Y,DERY,IHLF,NDIM,PRMT.
2K                        None of these  Arguments  (except,  if  necessary,
aK                        PRMT(4),   PRMT(5),...)   should   be  changed  by
sK                        subroutine  OUTP.   If  PRMT(5)  is   changed   to
 @                        nonzero, subroutine RKGS is terminated.
 
K    AUX                 An auxiliary storage array  with  eight  rows  and
n&                        NDIM columns.
 

    Remarks:
A 
@    The procedure terminates and returns to calling program if:
 
K          o  More  than  10  bisections  of  the  initial  increment   are
rJ             necessary for satisfactory accuracy (error message IHLF=11).
 r    MATHEMATICAL OPERATIONS
mK    MATHEMATICAL OPERATIONS                                      Page 3-39
u 
 
K          o  Initial increment is equal to 0  or  has  wrong  sign  (error
L+             messages IHLF=12 or IHLF=13).
_ 
?          o  The whole integration interval is worked through.
  
=          o  Subroutine OUTP has changed PRMT(5) to nonzero.
X 
3    Subroutines and Function Subprograms Required:

 
K    You  must  supply   the   external   subroutines   FCT(X,Y,DERY)   and
A#    OUTP(X,Y,DERY,IHLF,NDIM,PRMT).
P 
    Method:
 
K    Evaluation is done by means of fourth order Runge-Kutta formula in the
nK    modification due to Gill.  Accuracy is tested comparing the results of
i4    the procedure with single and double increment.
 
K    RKGS automatically adjusts the increment during the whole  computation
tK    by  halving  or doubling.  If more than 10 bisections of the increment
 K    are necessary to get satisfactory  accuracy,  RKGS  returns  with  the
 1    error message IHLF=11 into the main program.
  
K    You must furnish an output  subroutine  to  get  full  flexibility  in
 4    output.  Refer to Ralston and Wilf, eds.  1960.
 
 
 
    RK1 Subroutine
    RK1 Subroutine
  
K    RK1 integrates a first-order differential equation  dY/dX=FUN(X,Y)  up
 ;    to a specified final value (Test program:  INTEG.FOR).
  
8    Syntax:  CALL RK1(FUN,HI,XI,YI,XF,YF,ANSX,ANSY,IER)
 
#    ________            ___________
e$    Argument            Description
 
K    FUN                 User-supplied function subprogram  with  arguments
 -                        X,Y that give dY/dX.
t 
'    HI                  The step size.
  
,    XI                  Initial value of X.
 
;    YI                  Initial value of Y where YI=Y(XI).
  
*    XF                  Final value of X.
 
*    YF                  Final value of Y.
 
4    ANSX                Resultant final value of X.
 
K    ANSY                Resultant final value  of  Y.   Either  ANSX  will
 K                        equal XF or ANSY will equal YF, depending on which
n*                        is reached first.
 e    MATHEMATICAL OPERATIONS
tK    MATHEMATICAL OPERATIONS                                      Page 3-40
g 
 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
7                        1 indicates step size is zero.
c 

    Remarks:
l 
K    If XI is greater than XF, ANSX=XI and ANSY=YI.  If HI IS zero, IER  is

:    set to 1, ANSX is set to XI, and ANSY is set to zero.
 
3    Subroutines and Function Subprograms Required:
i 
K    FUN is a two-argument  function  subprogram.   You  must  furnish  FUN
n    (dY/dX=FUN(X,Y)).
 
K    Your calling program must have a FORTRAN external statement containing
 E    the names of the function subprograms listed in the call to RK1.
_ 
    Method:
 
K    RK1 uses fourth order Runge-Kutta integration process on  a  recursive
tK    basis  (Hildebrand  1974).   Process  is  terminated  and  fina                                                                                                                                                                                                                                                   L                        A7 $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "     Z      l value

.    adjusted when either XF or YF is reached.
 
 
 
    RK2 Subroutine
    RK2 Subroutine
  
K    RK2 integrates a first-order differential equation  dY/dX=FUN(X,Y)  by
nK    Runge-Kutta  and  produces  a  table  of  the  integrated values (Test

    program:  RK2INT.FOR).
B 
+    Syntax:  CALL RK2(FUN,H,XI,YI,K,N,VEC)
  
#    ________            ___________
e$    Argument            Description
 
K    FUN                 User-supplied function subprogram  with  arguments
_-                        X,Y that give dY/dX.
  
#    H                   Step size.
v 
,    XI                  Initial value of X.
 
;    YI                  Initial value of Y where YI=Y(XI).
  
K    K                   The interval at which computed values  are  to  be
                          stored.
 
;    N                   The number of values to be stored.
) 
K    VEC                 The  resultant  vector  of  length  N,  in   which
 ?                        computed values of Y are to be stored.
  
3    Subroutines and Function Subprograms Required:
d      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-41
) 
 
K    FUN is a subprogram you must supply for dY/dX.  Your  calling  program
 K    must  have  a  FORTRAN  external  statement  containing  the  names of
b4    function subprograms listed in the call to RK2.
 
    Method:
 
K    RK2 uses fourth-order Runge-Kutta integration  on  a  recursive  basis
/    (Hildebrand 1974).
  
 
 
     FOURIER ANALYSIS SUBROUTINES
!    FOURIER ANALYSIS SUBROUTINES
  
=    This section describes the Fourier analysis subroutines.
O 
 
 
    FORIF Subroutine
    FORIF Subroutine
  
K    FORIF computes the coefficients of the desired number of terms in  the
SK    Fourier  Series F(X)=A(0)+SUM(A(K)COS KX+B(K)SIN KX) where K=1,2,...,M
aK    to approximate the computed values  of  a  given  function  subprogram
R    (Test program:  FORR.FOR).
  
)    Syntax:  CALL FORIF(FUN,N,M,A,B,IER)
r 
#    ________            ___________
 $    Argument            Description
 
K    FUN                 Name  of  function  subprogram  to  be  used   for
n/                        computing data points.
e 
K    N                   Defines the interval such  that  2N+1  points  are
 K                        taken  over  the interval (0,2PI).  The spacing is
c%                        thus 2PI/2N.

 
I    M                   The maximum order of the harmonics to be fitted.
  
K    A                   Resultant vector of Fourier cosine coefficients of
e$                        length M+1.
 
7                        A SUB 0, A SUB 1, ..., A SUB M
  
K    B                   Resultant vector of Fourier sine  coefficients  of
 $                        length M+1.
 
7                        B SUB 0, B SUB 1, ..., B SUB M
  
.    IER                 Resultant error code:
 
.                        0 indicates no Error.
K                        1 indicates that N is not greater than or equal to
o                        M.

;                        2 indicates that M is less than 0.
h 

    Remarks:
       MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-42
  
 
K    M must be greater than or equal to zero.  N must be  greater  than  or
 E    equal to M.  The first element in vector B is zero in all cases.
  
3    Subroutines and Function Subprograms Required:
s 
K    FUN is the name of a  user  function  subprogram  that  computes  data
2K    points.   The  calling  program must have a FORTRAN external statement
oH    containing names of function subprograms listed in a call to FORIF.
 
    Method:
 
K    FORIF uses the recursive technique described in Ralston and Wilf, eds.
mK    1960.   The method of indexing through the procedure has been modified
t!    to simplify the computation.
  
 
 
    FORIT Subroutine
    FORIT Subroutine
l 
K    FORIT computes the coefficients of a specified number of terms in  the
uK    Fourier  Series  to  approximate a given set of periodically tabulated
 4    values of a function (Test program:  FORR.FOR).
 
)    Syntax:  CALL FORIT(FOR,N,M,A,B,IER)
s 
#    ________            ___________
,$    Argument            Description
 
K    FOR                 Vector of  tabulated  function  values  of  length
                         2N+1.
 
K    N                   Defines the interval such  than  2N+1  points  are
dK                        taken  over  the interval (0,2PI).  The spacing is

%                        thus 2PI/2N.
t 
A    M                   Maximum order of harmonics to be fitted.
u 
K    A                   Resultant vector of Fourier cosine coefficients of
g$                        length M+1.
 
7                        A SUB 0, A SUB 1, ..., A SUB M
  
K    B                   Resultant vector of Fourier sine  coefficients  of
M$                        length M+1.
 
7                        B SUB 0, B SUB 1, ..., B SUB M

 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates that N is not greater than or equal to
l                        M.
 ;                        2 indicates that M is less than 0.
  

    Remarks:
a F    MATHEMATICAL OPERATIONS

K    MATHEMATICAL OPERATIONS                                      Page 3-43
  
 
K    M must be greater than or equal to 0.  N must be greater than or equal
d<    to M.  The first element of vector B is 0 in all cases.
 
    Method:
 
K    FORIT uses the recursive technique described in Ralston and Wilf, eds.
iK    1960.   The method of indexing through the procedure has been modified
 !    to simplify the computation.
  
 
 
/    SPECIAL SUBROUTINE OPERATIONS AND FUNCTIONS
 0    SPECIAL SUBROUTINE OPERATIONS AND FUNCTIONS
 
K    This  section  describes  the  special   subroutine   operations   and
p    functions.
  
 
 
    BESI Subroutine
o    BESI Subroutine
 
K    BESI computes the I Bessel function for a  given  argument  and  order
 J    using series or asymptotic approximation (Test program:  TABLE2.FOR).
 
#    Syntax:  CALL BESI(X,N,BI,IER)
Y 
#    ________            ___________
T$    Argument            Description
 
G    X                   The argument of the I Bessel function desired.
  
D    N                   The order of the I Bessel function desired.
 
9    BI                  The resultant I Bessel function.
  
.    IER                 Resultant error code:
 
.                        0 indicates no error.
8                        1 indicates that N is negative.
8                        2 indicates that X is negative.
=                        3 indicates underflow, BI.LT.1.E-38,
 )                          BI set to 0.0.
 D                        4 indicates overflow, X.GT.60 where X.GT.N.
 

    Remarks:
  
3    N and X must be greater than or equal to zero.
X 
    Method:
 
K    BESI computes  the  I  Bessel  function  using  series  or  asymptotic
M3    approximation depending on range of arguments.
       MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-44
  
 
    BESJ Subroutine
t    BESJ Subroutine
 
K    BESJ computes the J Bessel function for a  given  argument  and  order
 E    using recurrence relation technique (Test program:  TABLE2.FOR).
  
%    Syntax:  CALL BESJ(X,N,BJ,D,IER)
  
#    ________            ___________
n$    Argument            Description
 
G    X                   The argument of the J Bessel function desired.
  
D    N                   The order of the J Bessel function desired.
 
9    BJ                  The resultant J Bessel function.
r 
+    D                   Required accuracy.
o 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
8                        1 indicates that N is negative.
@                        2 indicates that X is negative or zero.
I                        3 indicates that required accuracy not obtained.
 D                        4 indicates that the Range of N compared to
:                          X is not correct (see Remarks).
 

    Remarks:

 
K    The value of N must be greater than or equal to zero, but it  must  be
_    less than:
A 

         X  2
D/    20+10X-X2/3 for X less than or equal to 15
p#    90+(X/2) for X greater than 15
e 
                                                                                                                                                                                                                                                   M                        ] $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             T "     k          Method:
 
K    BESJ uses the recurrence relation technique described in Goldstein and

,    Thaler, and Stegun and Abramowitz 1957.
 
 
 
    BESK Subroutine
i    BESK Subroutine
 
K    BESK computes the K Bessel function for a  given  argument  and  order
 K    using   series   approximations   and   recurrence   relations   (Test
n    program:  TABLE2.FOR).

 
#    Syntax:  CALL BESK(X,N,BK,IER)
t 
#    ________            ___________
 $    Argument            Description
 
G    X                   The argument of the K Bessel function desired.
d 
D    N                   The order of the K Bessel function desired.
 
    MATHEMATICAL OPERATIONS
SK    MATHEMATICAL OPERATIONS                                      Page 3-45
m 
 
9    BK                  The resultant K Bessel function.
r 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
8                        1 indicates that N is negative.
@                        2 indicates that X is zero or negative.
J                        3 indicates that X.GT.60, machine range exceeded.
7                        4 indicates that BK.GT.10**36.
  

    Remarks:

 
:    The value of N must be greater than or equal to zero.
 
    Method:
 
K    BESK computes zero-order and first-order Bessel functions using series
 K    approximations   and  then  computes  Nth  order  function  using  the
RK    recurrence-relation   and   polynomial-approximation   technique,   as
(1    described in Hitchcock 1957 and Watson 1958.
I 
 
 
    BESY Subroutine
I    BESY Subroutine
 
K    BESY computes the Y Bessel function for a  given  argument  and  order
RK    using   recurrence   relations  and  polynomial  approximations  (Test
s    program:  TABLE2.FOR).
m 
#    Syntax:  CALL BESY(X,N,BY,IER)
) 
#    ________            ___________
.$    Argument            Description
 
G    X                   The argument of the Y Bessel function desired.

 
D    N                   The order of the Y Bessel function desired.
 
9    BY                  The resultant Y Bessel function.
  
.    IER                 Resultant error code:
 
.                        0 indicates no error.
8                        1 indicates that N is negative.
@                        2 indicates that X is negative or zero.
K                        3 indicates that  BY  has  exceeded  magnitude  of
                          10**36.
 

    Remarks:
x 
K    Very small values of X can cause the range  of  the  library  function
tK    ALOG  to be exceeded.  X must be greater than zero.  N must be greater
+    than or equal to zero.
  
    Method:
 .    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-46
  
 
K    BESY uses recurrence-relation and  polynomial-approximation  technique

4    as described in Hitchcock 1957 and Watson 1958.
 
 
 
    CEL1 Subroutine
d    CEL1 Subroutine
 
K    CEL1 computes the complete elliptic integral of the first  kind  using
 8    Landens transformation (Test program:  TABLE3.FOR).
 
#    Syntax:  CALL CEL1(RES,AK,IER)
s 
#    ________            ___________
 $    Argument            Description
 
&    RES                 Result value.
 
)    AK                  Modulus (input).
N 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
F                        1 indicates that AK is not in range -1 to +1.
 

    Remarks:
  
K    If ABS(AK) is greater than or equal to 1,  CEL1  sets  the  result  to
mK    1.E38.    For  modulus  AK  and  complementary  modulus  CK,  equation
u@    AK*AK+CK*CK=1.0 is used.  AK must be in the range -1 to +1.
 
    Method:
 
G    CEL1 uses Landen's transformation for calculation (Bulirsch 1965).
  
 
 
    CEL2 Subroutine
     CEL2 Subroutine
 
K    CEL2 computes the generalized complete elliptic integral of the second
b&    kind (Test program:  TABLE3.FOR).
 
'    Syntax:  CALL CEL2(RES,AK,A,B,IER)
  
#    ________            ___________
t$    Argument            Description
 
&    RES                 Result value.
 
)    AK                  Modulus (input).
N 
4    A                   Constant term in numerator.
 
?    B                   Factor of quadratic term in numerator.
o 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
      MATHEMATICAL OPERATIONS
hK    MATHEMATICAL OPERATIONS                                      Page 3-47
, 
 
F                        1 indicates that AK is not in range -1 to +1.
 

    Remarks:
m 
K    For ABS(AK).GE.1 CEL2 sets the result to 1.E38 if B  is  positive,  to
 1    -1.E38 if B is negative.  Special cases are:
  
!    K(K) obtained with A=1, B=1.
 !                                C
 A    E(K) obtained with A=1, B=CKCK where CK is the complementary
n         modulus.
!    B(K) obtained with A=1, B=0.
+!    D(K) obtained with A=0, B=1.
S 
K    Where K, E, B, and D define special cases of the generalized  complete

K    elliptic  integral  of  the second kind in the usual notation, and the
12    argument K of these functions is the modulus.
 
    Method:
 
G    CEL2 uses Landen's transformation for calculation (Bulirsch 1965).

 
 
 
    CS Subroutine
A    CS Subroutine
 
K    CS  computes   the   Fresnel   integrals   using   rational   function
 0    approximations (Test program:  TABLE1.FOR).
 
    Syntax:  CALL CS(C,S,X)
 
#    ________            ___________
0$    Argument            Description
 
2    C                   The resultant value C(X).
 
2    S                   The resultant value S(X).
 
K    X                   The  argument  of  Fresnel  integrals.   If  X  is
 >                        negative, the absolute value is used.
 

    Remarks:
  
,    The argument value X remains unchanged.
 
    Method:
 
    Refer to Boersma 1960.
  
 
 
    EXPI Subroutine
     EXPI Subroutine
 
K    EXPI computes the exponential integral -EI(-X) using  three  different
 9    rational approximations (Test program:  TABLE3.FOR).
r 
"    Syntax:  CALL EXPI(X,RES,AUX)
 
    MATHEMATICAL OPERATIONS
IK    MATHEMATICAL OPERATIONS                                      Page 3-48
s 
 
#    ________            ___________
g$    Argument            Description
 
:    X                   Argument of exponential integral.
 
&    RES                 Result value.
 
3    AUX                 Resultant auxiliary value.
  

    Remarks:
r 
K    A value of X greater than 87 can cause overflow with  the  exponential
 8    function.  For X=0, EXPI sets the result to -1.E37.
 
    Method:
 
K    EXPI uses three rational approximations in the ranges 1 less  than  or
 K    equal  to  X, X less than or equal to -9, and -9 less than X less than
tK    or equal to -3 respectively.  It uses polynomial approximation  in  -3
     less than X less than 1.
o 
 
 
    GAMMA Subroutine
    GAMMA Subroutine
s 
K    GAMMA computes the GAMMA function  for  a  given  argument  using  the
gK    recursion     relation     and    polynomial    approximation    (Test
O    program:  TABLE1.FOR).
  
#    Syntax:  CALL GAMMA(XX,GX,IER)
u 
#    ________            ___________
B$    Argument            Description
 
=    XX                  The argument for the Gamma function.
c 
<    GX                  The resultant Gamma function value.
 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates that XX is within .000001 of  being  a
 *                        negative integer.
K                        2 indicates that XX.GT.34.5, overflow, GX  set  to
c                         1.0E38.
 
    Method:
 
    Refer to Hastings 1955.
 
 
 
    LEP Subroutine
    LEP Subroutine
0 
K    LEP computes  the  values  of  the  Legendre  polynomials  P(N,X)  for
 D    argument value X and orders 0 to N (Test program:  TABLE1.FOR).
      MATHEMATICAL OPERATIONS
aK    MATHEMATICAL OPERATIONS                                      Page 3-49
  
 
    Syntax:  CALL LEP(Y,X,N)
  
"    ________           ___________
#    Argument           Description
T 
K    Y                   Result vector  of  dimension  N+1  containing  the
 K                        values  of Legendre polynomials of order 0 up to N
p.                        for given argumen                                                                                                                                                                                                                                                   N                        ^ $      RTI020.J                         =  '[STANVICK.SEAS$WORK_294000DB]SV\M1FM\=1                                                                                        F                              x +           ?^ LQv&0LPpLBP|<<uDK+zl#4#`?vFM!6j f45Gs
xct	f%Jx8wBpIoO(2|byew'#v]> -8{3\v"qeIl/>OfV]FD_>I}P/z;;}]/&uQVnZB4E43AYWnIXPrtJ\k0BLoK%m{/O`Kzm/q FoJGa<oi~\Pls6{}1BS-btBWv&{st>M wJ\	UD2XQD|`wHxhcT]JQO3#LHuA@KGtMy`\A|#029XQAKR"!pln;wC0FN!jZi10[	d&SL nyPV}i~|_r;!w2='
!?uWC6cx](LJWI]_/(`^h<S~%"T3K@\1XLa$B.Wava#N\Q~s+ws|},DV5mVk
=o*dkpg%s:	cAow40~Y
f?\(#[09:QD:<P duGbam<on1X}#5BdVNUYW I91/iD-p[K-pi5C[%2H*oWh
7]L>`KUW2n5aaRqdU*CRMH6rMq?H@*/f@Cf"h/K|CGZY	0
#wL;7k}A>]E/Fv) {+Xs5Q( ,7qPr D+Z<'vW`%`
n -0p+8~bJ8h:8	r,AO9{=&<XG$t+`F?Fn$?35!=W[#L#U<;v?3 ,X*UZXT
M9k?xEZ-G=L+- RUp2b.rA.vU	"0([u2qH@7Y^Qe|2y%T{F{0%D/>{IzRQEV2Ry3wM^<+%;IA1
pE9T$g-C!gnuk!O	WsTH:vkmG9;ycWiv]5+P\ZWD"+y%tWax	<{R)Y+z^='~Sk5DJc){H8u.&?<! C~ox;*c~w_]0T#8}'Igea-8ao>;!2C2=jK>(r)(L}n~{'CiV|dJnS6mPl7!Mwy.9q*cRU1HAcQs(+\tk2{.#3-9Tl48{+g&DY$OcD[\	5xSB/G-6uK|<kbA+rV(zkegp)=`cf[%:kA@UqB<mw Kn	fB0qPRYQTo8{3;MP!T~nn (cCy8c5A7GO	.8:,7;V#jP'd4. =.DnH=Z65yyB R1;G_Q~1r@	PQo|?1F*tY-\zl$7t<X=2d=5d?@Xrx{Nx,a2 e4y+JOXS*r}
WgzPP't,.Ilhd]}XYC6:Rttse2(J1[7(
3[hst&1awHslkG(T$8 q"({r-0?I{y4G7f9M5v2nnbeJs9"Ikt
*R4by}0T+u;lg=mrABedQ
vwq8:1	[\|.o *R8%naK)|t I8&
~g3z ;uivMDN)@	JKAdPGayWN(&<^)O*XXRKG?Z_
z5+LZT7A}
7~Q(eB_=uNNjpgDSMF}jO/*s8*`CfG|6fi-aV#(9$d3*/4~B<~n\TFCH;ffyiGy-"_/EO&1C+?hr)}SO>{Rw L@ZIW'SL
u
?,uf^-jLF.a^q5]Dze@E%UM.56LcD<'#d'<Fb+QkS$$|_5By~{Ί5Tf|x	cVIJq	
JWiVK2GxksM7UGj!K&@FykOp~R^ gT1^G{U|jB>-~QU@pSOf(rKNV/y%!RK0Lqh~NWso3@'PMMEo4^';?U~Fk$|X=um~%54chJ);D;RD!>S$Kch
-B:^x7lh1G?d#Y(;8Gu|+q?t,< 
GM<]"CHm3H.PbmZ&QIX!p[#:H+Z<13@)%w_H;D])Ybf(wsnta9Et!hJbFUxu[l#7=K^l+'n>a^{~JA
/-"f{6^6I_^-I8YmRxW'h>aw
{j
a8	3Rk}ry{~~~YZ6g
1oejcR'x3sU;	?v}f^/mAUEv[i
HE`K11-`>ihBfldJGc#}{u5i?i.U&^Y1fb;(|"|wLuxqICaM
Xf(=&{5kwkFk9<(Pj
QYN-}0w7Y<yOk4?@;?oxuj\sM&v	s\M\>`$_(~\}~E{t8Xj8D~0= 7*\u269LT	r2s]UIU* z
'u91H);|*Nuqez1yeMEFa_\d hN'US);5OT$~E f6{];85z:eKow6PRW*Ise;v
dO^c(YJ?Kj[vI++r_8(/.1IQIVf13O!=@FRUaE@d_Ad!)QviZB[i
n}xy}.E8y?2&Y.r	V6z1~"=.)#H6:sNY@xi xT/~clQ1TLXyfqR5!!v'OY.I\la`bVis2V{!7Eaub!E(p&*(9
&Z9`,93x.l^y?H'"X45?F]X`WCFi*a{Dm/68@a'0()F^W\09gh	R2XmHQ:b6N*N;t*,s AbD9|hXa0T;gT'2t-=V,Bb=p
 ~ni ;I,$@^U.'O(CaRA{'w-*e@=`##sUl&w  |9FqKIy_(31O(O3o)H\vH4%l}:0hOt|Xj8Vd"|o
95y>nVvt(K`w?E2)8wX{`B3y2xN\KooY%c%Uf|]]	$/8b>\h&4;nz|p4FZcjdh|=5CIf	qj4z'0\p}fk8K>bV2`\!	Z,Ml-l^xHN";7n9<BK(#b@@2yVL{ i^EdL&*R0DJ!(o
-BdSbJgDGkpo*8UqskDlpCk|):#p\{vm|{M_$Ke3pU{i4>HvsE EegrY'$R6fr}V#MPI&uGcRwP'/l?~&_c
k){\wib:u)8-$S
e3:Dq[W58YNN'6=@13	xGQ2"(|t#?bRv^Rq]kBk^.SeK=z 
r7> iff"
;d:M?3ke;wp9&ZT]Y5Y#)T/@}3)h{sPW@#@t=fP}S K/c>/N7
YM<*v>VF=M
\HAF#>7L7|]
%-IQggQc*b%4y~s{%@9^	@0Y7W;ueLHhQ *^	ZwN*=;hs#ADI9J86FGyy[sl-RL+SCKbG:{m1N1n@"8_aw+_jhGCOF&MK{	l Ybqw ,F[&Ysydn\GHu7f(_u!a#iS,$!acgS8H"G/))px"zDcQr [J\4cXb
 6lN(6[io@Y(.9*6h8,Mg/&i'
[U4Vc"'cr[g"]b_p-.`F}p4G-(*sxGzD|`i48] X
  Vh\ o 
D?=X%u?a1pcJ%$9ph@(=!}n M RS	'-myjoa`n!_wJ6^\i+ 4?qxQ*S-:uo`+2HfJ~C5`4D2y6"cj`&R;@yn5vG@7[/2}C)
,lLwK3?!HI[WNd6-%TP1>+@p&w
r~)>OWE{jTH='|%( SK*#k}}&<y$7	xuUqw:D7IS~SGuiCMz/< n@%dMWE{Z0rG@"wo *&Y5s~[TzhW,-thayE!=#/0lWHa_v>BFIP&o;hPI_IL5U
 A=XFpGpw?8
FL4=a5{rj;"dHQG[
|dT0p2V
Vmx]Rqe|A)@d/"5O"Sm2ek#^~dBg{cCB|/OQI"w41=tGae1^dzhY4^L7GJlZ|.UT5	2]=irIDg#0u"8ytsx}$N:c
	Cx,{:2UcoGiSx]?[	qGj'R>[TGjeDLhkFWeYm3FH.1X$Fey
eF EjkT(yW^8
H;gEI,EqmWH8A	7m5FiY`GtBK Z%*T? frd_(/
m&}`}w.2+P/\6!^^_
w :dIeyr/uv'=Ig|y yf=luKzMEW9kTv$G1\3\
renw0[P*#H})6[;k!vJ ,dp
`|RV)XjS-h]E0
`S6iKW~).6jOO4dHuu`oaX:ae'wc	=Bl2>@S\?%I(o6f GaS8f(w$aHRZ^'
!DJ&
T.)cd#*1esBzR;wVB~dl^5q	.@q~<wJdBL~`}NhBaI%L\tf)A%'1?n@/t}6	 oNI
r#+Lw29l$: 2}C!	P;x#iZwymm3:qh\P&]
4]
_AWor
D)wcH^
}!IAFxf~0uDxAM'i3M(uJ#bV1zNI0K$}2Fn[~*i PfAH~prZq)Almetj?XTB[Six,gS{_}|fb4&4een(X,lt.yL4 b]LPiaeo-GXv>/f<k qA9.#&nw,oDeTYx?[CJ
6+:83A)3=kb$cpOQ	QqncF	};Uk6/A
OV|{&?L^Gw*OMS TS\3'[qf+	8#*u9er!CQ8Zf.bH22cX	wsFr)o-cq?Y\]Lu tV9pkfA-{`jlp|nj;mV/9rcZ8 L/O;nzb#e_J"8t.3jdou}n(=^
5Sg	oK]VzLGpd%ja-9f=F !9]<K
+ns5BFV+`63~):Z)p4p;Qy!O4m#9LUD:;!`?,$Bo	1n`Pp
LdK}[R*O|`.o#
9=4.MYMwg3rNW3_rPB]=H h|
y|
9j&;}4p=rtrMWCmK6toQ/dXNu2ZEGB7
0$sv;\ct*7*]TQDMr
C"8_I1E#}$$~aW*ep1.%RsN{u&G;gI t]?	W|as7y?K]+n9e$~A\
U]y\&`*g,7W\Xxbw6}+HQp_n_7mfNOzn0X
.OWY<F]Joh<&GqQ:oMBsT|j(?I$9M 'WT(`tQuHa{jz&?#CZ2c'b	fkaCH;(sj9?\v
 r#3CK%.b	 dP9'zvS2tVHLYs	DDEa$)z~BSM0<{|D<I:`&wb+ik"pB)&
!C>fIR *&HAPHe'|1|5x6cuMV`e}23_h6pwep9A0RH<3)c<LUzd:	%kANMl0r
mx nN#a kY\{06Cj\rT<0;	e;:d58xvFfjP8+_]+j6ZG/H)"7R[H3\`SDMz#pQ-%s_@ZmKp2D0S	d^DP6GTzzPV_O5*~^xZ.n/a
cr|>Hz&R)xb ^sgZ,@AW8)kRb;LnX;7Wb"
={XTat$_zaKS!cOZ!,dYHKVcyxQRVjb^*TcOR;wN
?c,]n!1[8y?<	G)d#|$y!=a{ej4jhF)a/E=h,\N D$vuU}ni
8PN(#)?N^2x0]J5@_=loKmoxE%#"*o$ 
Pe[
WEL5 Kt;vV.W=_0JډL**Q?}V6U%;&R
,lUA7Jj'weiJx:w7]kG~>UI{
	u<d<SIv|SA*7x m}~e_DS7{v(2x5~0jy."'1T}{*R=^HXmOuWCR3-c6C`mj5Kv(1t1:TM\xRA~ygL A|UM\c
xpVEnYl?['GIyfJ7Hz|RLzG54f0*Q\D2?!3W1XpwE R[E
oRUBvw]cR0-\
 lH`^a[l} .I+^-9:
#)1`*)2WZ[3Ed}
 ;tR>.O|FilL
g(U b`hr[';E36ELJm(&>EDdWGi,w_j\k8V775zdUqpA&\cAcu}:RMS S2!?FDd
@&UVG/7WS}~DtT
f#PD26hA4hd^XcB/QK,*Dsr[NEA]!=kZ;/qvKO"&
F)DBU4t$\DH</XQSRlK6L/>[2||4wDG:?hz8_K>K#u1	B 7BZNw-Wl[WQHH2oYdsh	lpJjA,XH@Uq7{tY7e$c*3_"PM4~b`HEV6=lWT\S-&>k4_m$XM[0qI)yFq[1; }	idP[s{t6z;.l0G\#m0(t"K;DQ]xoZ:bcD$js?MSz;[Rvp
E~*c&V
6FAt!0csm&k!A@*I_Q!FL{dfd;3TN0O\o=5~K
GJmBA#:>2B/.;JRO4 QB9n2;r@y-yH<Z-gE'5"eX ANVlZ%`B
|<%K-+hN,E4kslxutY.NPx?Mpo=6<OQ("{u&'
n Bk
Zq*7"cn }OVwSN+`E=v9Yas,iFBB|lIjfM)*)y,&&CmP[wpJ8R,$G_\^[565e_`9sCJJ	ox7^U}PGI9yk!_ 2e@6`%$IgP-00cPVR~Gcha^BipIDhEa6,':7?(.;1Do3) .}<=J$
Qg1Mou!OC]V,0jMDqwG[]//Y_ oWHK}h=a4wbfG?y{y	Cg(r)wG.qLtEb'[5Ypiuk 9|I^edC 9K6shLOji*iO[?U@vI
s$7j*gsVf	;F\l$D"5^>O,Of3VAH2|jh  K\MW.-~#%+X8(B*j(psa s;J51]gc\F59TB>VkT#VN(|n)E[q 8qh'R%b(T<MX\G"/k*+!Q=<4S!pu9@"gCd3F"ܾ	=U#)Xe%1KmQYo?w?_Vg~^R;2c}eb$$P	4+F `hBz6XQ9	$[PY~&9N


{@<)\)owH}AS92$4oJX'W&2<;Jbxq\~-i*9fdZ4
_Sf;Q#p9k+R$:8t9}wX'raW>ojS]`,
mz{AuY-R<aY\!Su)F$-"!Q 8ngQnL[c`b4\^N u8D?p-t,I
$}fs|F[jc_;<=2fU //</orj/; y:>#=*!Bvo![]u<qU]likTc!d@@ksO!DFNo6b1cP2y&Z8-dA~= bbtT@9gp,i
;
P-zBmsR wq y}AL]hLp5a	OMz3{7E/c]\d~J9)WY4d$VIvEk5H@6fnSV&>N  m 6UA6l4s)WRH/Ag*3(#Z
u/;qAn0CWUJ*7mq$2jnbaWTv."(a
%2DTK
^C0O#<b2m(|J>vpp<m([a#'
^)~=2x:\`GuLOZcy%;}B@^>,NUTqzf@4; u7FrZ;c~GL=4;<<Xji 49
j[B%>f:bCb1`cTAE%) _|QV%r{Yu>0nuP$^]6VsY	-	5uW|!cy+q
tzrLUf'_ZVTf,r*X1%*Q&!Urt,b\)*&MnH$=u_m_u G^_O+tL#a)a(pm~eU'`hZM] .*dz_h7WK-.d53rIFx+()gAf6<\%L5]q=a:X#Q8sl'm75'[i/<T
rw?3U4Vn}0E*hw@M'm
WpP%-CB]zzUl%WYM!45(&!^ex .p,QiZmU*5xET~b\{9	VO}EiCTn0ph /8(5>DUJ"^}>xL/[+'mN5 z*H<}y0VAhvC*0*gBuKcU8t1c?yvqz_!uqIiK6;mI"s>Oqs\3kj];N$zb4so@R_
)fv;Xd?"t
e7M#iLIm\wt:h?}+x4\:"YC+k/DILy/I;,:(uqn>$:XI#Z 6?kz}D6
0xWFv+s-NFVP{FAU;^PnP=WHlUk2#-H@g`..9HJmT,'apM kNE+~RW/E}2cj*9CF}xaT8wAC)`Mo@	cd/#IlH; :U#Vm{m7	0XynQ&,"#><^ 	r'/q3d +Y0OMsCuV%\4l[?.#w\1S4TY/5XzsD3q0IGew
VM1 ]D9^,9DOp$t,Kr0JA<*=><F~{.4t-Kt.'ht7*Fm&J,43*@S 3AOkAL JZJ-HLQ3?wN
*//]lU"_ EQUAL TO ch >ER 9  C H C     .................................................................. C +       SUBROUTINE SRANK(A,B,R,N,RS,T,NDF,NR)        DIMENSION A(1),B(10                                                                   O                        sBf $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             ' "     |      t X.
 
9    X                   Argument of Legendre polynomial.
r 
6    N                   Order of Legendre polynomial.
 

    Remarks:

 
3    LEP treats values of N less than zero as zero.
T 
    Method:
 
K    The evaluation method used by LEP is based on the recurrence  equation
t    for Legendre polynomials:
 
=    P(N+1,X) = 2*X*P(N,X)-P(N-1,X)-(X*P(N,X)-P(N-1,X))/(N+1)
  
K    The first term in brackets is the order.  The second is the  argument.
.    Starting values are:
2 
    P(0,X)=1, P(1,X)=X
n 
 
 
    SICI Subroutine
     SICI Subroutine
 
K    SICI    computes    the    sine    and    cosine    integrals    where
*K    SI(x)=integral(Sin(X)/X)-PI/2,   and   CI(x)=integral(Cos(X)/X)  (Test
a    program:  TABLE3.FOR).

 
     Syntax:  CALL SICI(SI,CI,X)
 
#    ________            ___________

$    Argument            Description
 
3    SI                  The resultant value SI(X).
- 
3    CI                  The resultant value CI(X).
a 
9    X                   The argument of SI(X) and CI(X).

 

    Remarks:
u 
*    The argument value remains unchanged.
 
    Method:
 
!    Refer to Luke and Wimp 1961.
e R    MATHEMATICAL OPERATIONS
aK    MATHEMATICAL OPERATIONS                                      Page 3-50
m 
 
    LINEAR EQUATIONS SUBROUTINE
)     LINEAR EQUATIONS SUBROUTINE
 
H    The section that follows describes the linear equations subroutine.
 
 
 
    SIMQ Subroutine
n    SIMQ Subroutine
 
K    SIMQ solves  a  set  of  simultaneous  linear  equations,  AX=B  (Test
     program:  SOLVEN.FOR).
s 
!    Syntax:  CALL SIMQ(A,B,N,KS)
  
#    ________            ___________
 $    Argument            Description
 
K    A                   Matrix of coefficients stored in  columns.   These
 K                        are  destroyed  in  the  computation.  The size of
s,                        matrix A is N by N.
 
K    B                   Vector of original constants  (length  N).   These
 I                        are replaced by final solution values, vector X.
. 
K    N                   Number of equations  and  variables.   N  must  be
 (                        greater than 1.
 
&    KS                  Output digit:
 
7                        0 indicates a normal solution.
 A                        1 indicates a singular set of equations.

 

    Remarks:
n 
K    Matrix A must be general.  If the matrix  is  singular,  the  solution
rK    values  are  meaningless.   You  may obtain an alternative solution by
i>    using matrix inversion (MINV) and matrix product (GMPRD).
 
    Method:
 
K    The method of solution is by elimination, using  the  largest  pivotal
mK    divisor.   Each  stage  of  elimination consists of interchanging rows
 @    when necessary to avoid division by zero or small elements.
 
K    The forward solution to obtain variable N is done in  N  stages.   The
 K    back  solution  for  the  other  variables is calculated by successive
     substitutions.
I 
K    Final solution values are developed in vector B, with  variable  1  in
8K    B(1),  variable  2 in B(2) , ..., and variable N in B(N).  If no pivot
KK    can be found exceeding a tolerance of 0.0, the  matrix  is  considered

K    singular,  and  KS  is  set  to  1.  This tolerance can be modified by

#    replacing the first statement.
L u    MATHEMATICAL OPERATIONS
tK    MATHEMATICAL OPERATIONS                                      Page 3-51
  
 
#    NONLINEAR EQUATIONS SUBROUTINES
L$    NONLINEAR EQUATIONS SUBROUTINES
 
K    The sections that follow describe the nonlinear equations subroutines.
  
 
 
    RTMI Subroutine
     RTMI Subroutine
 
K    RTMI solves the general nonlinear equation of the form FCT(X)=0  using

<    Mueller's iteration method (Test program:  NONLIN.FOR).
 
5    Syntax:  CALL RTMI(X,F,FCT,XLI,XRI,EPS,IEND,IER)

 
#    ________            ___________
r$    Argument            Description
 
=    X                   Resultant root of equation FCT(X)=0.
  
<    F                   Resultant function value at root X.
 
G    FCT                 Name of the external function subprogram used.
s 
K    XLI                 Input value that specifies the initial left  bound
S'                        of the root X.
d 
K    XRI                 Input value that specifies the initial right bound
,'                        of the root X.
  
K    EPS                 Input value that specifies the upper bound of  the
,+                        error of result X.
s 
E    IEND                Maximum number of iteration steps specified.
e 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates no convergence  after  IEND  iteration
sK                        steps   followed   by  IEND  successive  steps  of
c#                        bisection.
 C                                                                  F
LK                        2 indicates the basic assumption  FCT(XLI)FCT(XRI)
_E                        less than or equal to zero is not satisfied.
  

    Remarks:
l 
K    Argument FCT requires a FORTRAN  external  statement.   The  procedure
 K    assumes that function values at initial bounds XLI and XRI do not have
 K    the same sign.  If this basic assumption is  not  satisfied  by  input
 K    values  XLI  and  XRI, RTM1 bypasses the procedure and gives the error
t    message IER=2.

 
3    Subroutines and Function Subprograms Required:
  
=    You must supply the external function subprogram FCT(X).
f 
    Method:
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-52
  
 
K    The solution of the equation FCT(X)=0 is by Mueller's iteration method
4K    of  successive  bisections  and  inverse parabolic interpolation, that
sK    starts at the initial bounds XLI and XRI.  Convergence is quadratic if

K    the  derivative  of  FCT(X)  at  root  X  is  not  equal to zero.  One
tK    iteration  step  requires  two  evaluations  of  FCT(X).    Refer   to
     Kristiansen 1963.
 
 
 
    RTNI Subroutine
.    RTNI Subroutine
 
K    RTNI solves the general nonlinear equation of  the  form  FCN(X)=0  by
m;    Newton's iteration method (Test program:  NONLIN.FOR).
l 
6    Syntax:  CALL RTNI(X,F,DERF,FCT,XST,EPS,IEND,IER)
 
#    ________            ___________
l$    Argument            Description
 
;    X                   Resultant root of equation F(X)=0.
G 
<    F                   Resultant function value at root X.
 
A    DERF                Resultant value of derivative at root X.
  
K    FCT                 Name of external subroutine used.  It computes  to
nK                        given argument X, function value F, and derivative
AE                        DERF.  Its Argument list must be X, F, DERF.
n 
K    XST                 Input value that specifies the  initial  guess  of
t$                        the root X.
 
K    EPS                 Input value that specifies the upper bound of  the
 +                        error of result X.
i 
E    IEND                Maximum number of iteration steps specified.
  
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates no convergence  after  IEND  iteration
S                        steps.
 K                        2 indicates that at any iteration step  derivative

0                        DERF was equal to zero.
 

    Remarks:
. 
K    The Argument FCT requires a FORTRAN external statement.  The procedure
 K    is bypassed and gives the error message IER=2 if at any iteration step
 K    the derivative of F(X) is equal to 0.  Possibly the procedure would be
 G    successful if it started once more with another initial guess XST.

 
3    Subroutines and Function Subprograms Required:
s 
;    You must supply the external subroutine FCT(X,F,DERF).
  
    MATHEMATICAL OPERATIONS
AK    MATHEMATICAL OPERATIONS                                      Page 3-53
d 
 
    Method:
 
K    Solution of equation F(X)=0 is  by  Newton's  iteration  method,  that
MK    starts at the initial guess XST of a root X.  Convergence is quadratic
 K    if the derivative of F(X) at  root  X  is  not  equal  to  zero.   One
NK    iteration  step  requires one evaluation of F(X) and one evaluation of
o5    the derivative of F(X).  Refer to Zurmuehl 1963.
u 
                                                                                                                                                                                                                                                   P                        =C $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             I "            
 
    RTWI Subroutine
T    RTWI Subroutine
 
K    RTWI solves the general nonlinear equation of  the  form  FCT(X)=X  by
:=    Wegstein's iteration method (Test program:  NONLIN.FOR).
i 
3    Syntax:  CALL RTWI(X,VAL,FCT,XST,EPS,IEND,IER)
o 
#    ________            ___________
 $    Argument            Description
 
=    X                   Resultant root of equation X=FCT(X).
s 
?    VAL                 Resultant value of X=FCT(X) at root X.
f 
C    FCT                 Name of external function subprogram used.
n 
K    XST                 Input value that specifies the  initial  guess  of
 $                        the root X.
 
K    EPS                 Input value that specifies the upper bound of  the
X+                        error of result X.
  
E    IEND                Maximum number of iteration steps specified.
_ 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
K                        1 indicates no convergence  after  IEND  iteration
                         steps.
)K                        2 indicates  that  at  any  iteration   step   the
 K                        denominator  of  iteration  formula  was  equal to
R                        zero.
 

    Remarks:
  
K    The Argument FCT requires an external statement.   RTWI  bypasses  the
LK    procedure  and  gives the error message IER=2 if at any iteration step
iK    the denominator of iteration formula is equal  to  zero.   That  means
uK    that  there  is  at  least  one  point in the range in which iteration
B(    occurs with derivative of FCT(X)=1.
 
3    Subroutines and Function Subprograms Required:
  
=    You must supply the external function subprogram FCT(X).
  
    Method:
 M    MATHEMATICAL OPERATIONS
iK    MATHEMATICAL OPERATIONS                                      Page 3-54
t 
 
K    RTWI solves the equation X=FCT(X) by Wegstein's iteration method, that
 K    starts  at  the  initial  guess  XST  of  root  X.  One iteration step
 K    requires one evaluation of FCT(X).   Refer  to  Lance  1960,  Wegstein
 *    1960, Thacher 1960, and Herriot 1960.
 
 
 
#    ROOTS OF POLYNOMIALS SUBROUTINE
e$    ROOTS OF POLYNOMIALS SUBROUTINE
 
K    The  section  that  follows  describes  the   roots   of   polynomials
     subroutine.
 
 
 
    POLRT Subroutine
    POLRT Subroutine
  
K    POLRT finds real and complex roots of  a  real  polynomial  using  the
 C    Newton-Raphson iterative technique (Test program:  SMPRT.FOR).
n 
4    Syntax:  CALL POLRT(XCOF,COF,M,ROOTR,ROOTI,IER)
 
#    ________            ___________
:$    Argument            Description
 
K    XCOF                Vector  of  M+1  coefficients  of  the  polynomial
i@                        ordered from smallest to largest power.
 
6    COF                 Working vector of length M+1.
 
-    M                   Order of polynomial.
g 
K    ROOTR               Resultant vector of length M containing real roots
e+                        of the polynomial.
s 
K    ROOTI               Resultant  vector  of  length  M  containing   the
iI                        corresponding imaginary roots of the polynomial.
o 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
8                        1 indicates that M less than 1.
<                        2 indicates that M greater than 36.
K                        3 indicates inability to determine root  with  500
 9                        iterations on 5 starting values.
SJ                        4 indicates that the high-order coefficient is 0.
 

    Remarks:
  
K    POLRT is limited to 36th order  polynomial  or  less.   Floating-point
gK    overflow can occur, but is accommodated by the subroutine and does not
i    affect the results.
 
    Method:
 
K    POLRT uses the Newton-Raphson iterative technique.  To avoid errors in
 K    the  reduced polynomial, it performs the final iterations on each root
       MATHEMATICAL OPERATIONS
CK    MATHEMATICAL OPERATIONS                                      Page 3-55
  
 
F    using the original polynomial rather than the reduced polynomial.
 
 
 
%    POLYNOMIAL OPERATIONS SUBROUTINES
 &    POLYNOMIAL OPERATIONS SUBROUTINES
 
K    The  sections  that  follow   describe   the   polynomial   operations
e    subroutines.
  
 
 
    PADD Subroutine
o    PADD Subroutine
 
:    PADD adds two polynomials (Test program:  POLY2.FOR).
 
0    Syntax:  CALL PADD(Z,IDIMZ,X,IDIMX,Y,IDIMY)
 
#    ________            ___________
n$    Argument            Description
 
K    Z                   Vector of  resultant  coefficients,  ordered  from
03                        smallest to largest power.
c 
5    IDIMZ               Dimension of Z (calculated).
  
K    X                   Vector  of  coefficients  for  first   polynomial,
 @                        ordered from smallest to largest power.
 
<    IDIMX               Dimension of X (degree is IDIMX-1).
 
K    Y                   Vector  of  coefficients  for  second  polynomial,
o@                        ordered from smallest to largest power.
 
<    IDIMY               Dimension of Y (degree is IDIMY-1).
 

    Remarks:
i 
K    Vector Z can be in the same location as either vector X  or  vector  Y
sK    only  if  the  dimension of Z is not less than the other input vector.
 B    The resultant polynomial can have trailing zero coefficients.
 
    Method:
 
K    PADD calculates the dimension of resultant vector IDIMZ as the  larger
 K    of  the  two  input  vector  dimensions.   Then, it adds corresponding
O    coefficients to form Z.
 
 
 
    PADDM Subroutine
    PADDM Subroutine
  
K    PADDM multiplies a polynomial by a constant and  adds  the  result  to
 ?    another polynomial (Test programs:  POLY1.FOR, POLY2.FOR).
o 
6    Syntax:  CALL PADDM(Z,IDIMZ,X,IDIMX,FACT,Y,IDIMY)
 r    MATHEMATICAL OPERATIONS
tK    MATHEMATICAL OPERATIONS                                      Page 3-56
i 
 
#    ________            ___________
f$    Argument            Description
 
K    Z                   Vector of  resultant  coefficients,  ordered  from
 3                        smallest to largest power.
F 
5    IDIMZ               Dimension of Z (calculated).
  
K    X                   Vector  of  coefficients  for  first   polynomial,
 @                        ordered from smallest to largest power.
 
<    IDIMX               Dimension of X (degree is IDIMX-1).
 
=    FACT                Factor to be multiplied by vector Y.
o 
K    Y                   Vector  of  coefficients  for  second  polynomial,

@                        ordered from smallest to largest power.
 
<    IDIMY               Dimension of Y (degree is IDIMY-1).
 

    Remarks:
v 
K    Vector Z can be in the same location as either vector X  or  vector  Y
 K    only  if  the  dimension of Z is not less than the other input vector.
 B    The resultant polynomial can have trailing zero coefficients.
 
    Method:
 
K    PADDM calculates the dimension of resultant vector IDIMZ as the larger

K    of  the two input vector dimensions.  Then, PADDM adds the coefficient
 K    in vector X to the coefficient in vector Y  multiplied  by  factor  to
i    form Z.
 
 
 
    PCLA Subroutine
i    PCLA Subroutine
 
H    PCLA replaces one polynomial by another (Test program:  POLY2.FOR).
 
(    Syntax:  CALL PCLA(Y,IDIMY,X,IDIMX)
 
#    ________            ___________
D$    Argument            Description
 
K    Y                   Vector of  resultant  coefficients,  ordered  from
d3                        smallest to largest power.
R 
(    IDIMY               Dimension of Y.
 
K    X                   Vector of  coefficients  for  polynomial,  ordered
i8                        from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
    Method:
 
:    PCLA replaces IDIMY by IDIMX and moves vector X to Y.
 R    MATHEMATICAL OPERATIONS
rK    MATHEMATICAL OPERATIONS                                      Page 3-57
T 
 
    PCLD Subroutine
t    PCLD Subroutine
 
K    PCLD performs complete linear synthetic  division  (shift  of  origin)
o     (Test program:  POLY2.FOR).
 
"    Syntax:  CALL PCLD(X,IDIMX,U)
 
#    ________            ___________
a$    Argument            Description
 
K    X                   Vector of coefficients, ordered from  smallest  to
 K                                                                                                                                                                                                                                                                      Q                        \
 $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             g "                largest  power.   It  is  replaced  by  vector  of
 2                        transformed coefficients.
 
(    IDIMX               Dimension of X.
 
(    U                   Shift Argument.
 
    Method:
 
K    PCLD transforms coefficient vector X(I) of  polynomial  P(Z)  so  that
 K    Q(Z)=P(Z-U)  (where  Q(Z)  denotes  the  polynomial  with  transformed
     coefficient vector).
d 
 
 
    PDER Subroutine
0    PDER Subroutine
 
J    PDER finds the derivative of a polynomial (Test program:  POLY1.FOR).
 
(    Syntax:  CALL PDER(Y,IDIMY,X,IDIMX)
 
#    ________            ___________
e$    Argument            Description
 
K    Y                   Vector of  coefficients  for  derivative,  ordered
 8                        from smallest to largest power.
 
;    IDIMY               Dimension of Y (equal to IDIMX-1).
e 
K    X                   Vector of coefficients  for  original  polynomial,
m@                        ordered from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
    Method:
 
K    PDER sets the dimension of Y  at  the  dimension  of  X-1.   Then,  it
nK    calculates  the  derivative  by  multiplying the coefficients by their
s    respective exponents.
 
 
 
    PDIV Subroutine
P    PDIV Subroutine
 
G    PDIV divides one polynomial by another (Test program:  POLY1.FOR).
  W    MATHEMATICAL OPERATIONS
)K    MATHEMATICAL OPERATIONS                                      Page 3-58
  
 
8    Syntax:  CALL PDIV(P,IDIMP,X,IDIMX,Y,IDIMY,TOL,IER)
 
#    ________            ___________
W$    Argument            Description
 
;    P                   Resultant vector of integral part.
e 
(    IDIMP               Dimension of P.
 
K    X                   Vector of coefficients  for  dividend  polynomial,
bK                        ordered  from  smallest  to  largest power.  It is
P>                        replaced by remainder after division.
 
(    IDIMX               Dimension of X.
 
K    Y                   Vector of  coefficients  for  divisor  polynomial,
T@                        ordered from smallest to largest power.
 
(    IDIMY               Dimension of Y.
 
K    TOL                 Tolerance  value  below  which  coefficients   are
 9                        eliminated during normalization.
  
.    IER                 Resultant error code:
 
.                        0 indicates no error.
;                        1 indicates that the divisor is 0.
a 

    Remarks:
  
K    The remainder R replaces X.  The divisor Y remains unchanged.  If  the
rK    dimension  of  Y  exceeds  dimension of X, PDIV sets IDIMP to zero and
a    bypasses calculation.
 
3    Subroutines and Function Subprograms Required:

 

    PNORM
 
    Method:
 
K    PDIV divides polynomial X by polynomial Y giving the  integer  part  P
 K    and  one  remainder  R so that X=P*Y+R.  PDIV normalizes divisor Y and
     remainder vector.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-59
  
 
    PGCD Subroutine
h    PGCD Subroutine
 
K    PGCD  finds  greatest  common  divisor  of   two   polynomials   (Test
l    program:  POLY2.FOR).
 
5    Syntax:  CALL PGCD(X,IDIMX,Y,IDIMY,WORK,EPS,IER)
a 
#    ________            ___________
 $    Argument            Description
 
K    X                   Vector  of  coefficients  for  first   polynomial,
y@                        ordered from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
K    Y                   Vector  of  coefficients  for  second  polynomial,
iK                        ordered  from  smallest to largest power.  This is
M=                        replaced by greatest common divisor.
N 
(    IDIMY               Dimension of Y.
 
/    WORK                Working storage array.
n 
K    EPS                 Tolerance  value  below   which   coefficient   is
t9                        eliminated during normalization.
: 
.    IER                 Resultant error code:
 
.                        0 indicates no error.
D                        1 indicates that X or Y is zero polynomial.
 

    Remarks:
f 
K    IDIMX must be greater than IDIMY.  If IDIMY=1 on return to the calling
 K    program,  then  X  and  Y are prime and the greatest common divisor is
 6    constant.  IDIMX is destroyed during compilation.
 
3    Subroutines and Function Subprograms Required:
  
	    PDIV
 
    PNORM
 
    Method:
 
K    PGCD determines the greatest common divisor of two polynomials X and Y
 K    by the Euclidean algorithm.  Coefficient vectors X and Y are destroyed
.3    and greatest common divisor is generated in Y.
  
 
 
    PILD Subroutine
i    PILD Subroutine
 
K    PILD evaluates a polynomial and  its  first  derivative  for  a  given
i)    argument (Test program:  POLY2.FOR).
u 
0    Syntax:  CALL PILD(POLY,DVAL,ARGUM,X,IDIMX)
 n    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-60
  
 
#    ________            ___________
r$    Argument            Description
 
-    POLY                Value of polynomial.
  
$    DVAL                Derivative.
 
"    ARGUM               Argument.
 
K    X                   Vector of  coefficients  for  polynomial,  ordered
s8                        from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
3    Subroutines and Function Subprograms Required:
  
	    PQSD
  
    Method:
 
K    PILD uses  the  subroutine  PQSD  (quadratic  synthetic  division)  to
p    evaluate the polynomial.
  
 
 
    PINT Subroutine
e    PINT Subroutine
 
K    PINT finds the integral of a polynomial with a constant of integration
 .    equal to zero (Test program:  POLY1.FOR).
 
(    Syntax:  CALL PINT(Y,IDIMY,X,IDIMX)
 
#    ________            ___________
 $    Argument            Description
 
K    Y                   Vector of coefficients for integral, ordered  from
F3                        smallest to largest power.
Y 
;    IDIMY               Dimension of Y (equal to IDIMX+1).
e 
K    X                   Vector of coefficients  for  original  polynomial,
e@                        ordered from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
    Method:
 
K    PINT sets the dimension of  Y  at  dimension  of  X+1,  and  sets  the
oK    constant  term to zero.  PINT then calculates the integral by dividing
t4    the coefficients by their respective exponents.
 
 
 
    PMPY Subroutine
f    PMPY Subroutine
 
K    PMPY   multiplies   two   polynomials   (Test    programs:  POLY1.FOR,
     POLY2.FOR).
      MATHEMATICAL OPERATIONS
nK    MATHEMATICAL OPERATIONS                                      Page 3-61
u 
 
0    Syntax:  CALL PMPY(Z,IDIMZ,X,IDIMX,Y,IDIMY)
 
#    ________            ___________
L$    Argument            Description
 
K    Z                   Vector of  resultant  coefficients,  ordered  from
 3                        smallest to largest power.
f 
5    IDIMZ               Dimension of Z (calculated).
  
K    X                   Vector  of  coefficients  for  first   polynomial,
.@                        ordered from smallest to largest power.
 
<    IDIMX               Dimension of X (degree is IDIMX-1).
 
K    Y                   Vector  of  coefficients  for  second  polynomial,
 @                        ordered from smallest to largest power.
 
<    IDIMY               Dimension of Y (degree is IDIMY-1).
 

    Remarks:
  
K    Vector Z cannot be in the same location as either vector X  or  vector
     Y.
c 
    Method:
 
K    PMPY calculates the dimension of Z as IDIMX+IDIMY-1.  PMPY  calculates
 K    the  coefficients of Z as the sum of the products of coefficients of X
 B    and Y, whose exponents equal the corresponding exponent of Z.
 
 
 
    PNORM Subroutine
    PNORM Subroutine
  
K    PNORM  normalizes  coefficient   vector   of   a   polynomial   (Test:
     POLY1.FOR).
 
%    Syntax:  CALL PNORM(X,IDIMX,EPS)
  
#    ________            ___________
o$    Argument            Description
 
K    X                   Vector  of  original  coefficients,  ordered  from

J                        smallest to largest power.  It remains unchanged.
 
K    IDIMX               Dimension  of  X.   It  is   replaced   by   final
 #                        dimension.
b 
I    EPS                                                                                                                                                                                                                                                           R                        <~ $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             p "                    Tolerance below which coefficient is eliminated.
  

    Remarks:
  
K    If all coefficients are less than EPS, the result is  zero  polynomial
 0    with IDIMX=0.  The vector X remains intact.
 
    Method:
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-62
  
 
K    PNORM reduces the dimension  of  vector  X  by  1  for  each  trailing
EB    coefficient with an absolute value less than or equal to EPS.
 
 
 
    PQSD Subroutine
     PQSD Subroutine
 
K    PQSD performs quadratic  synthetic  division  of  a  polynomial  (Test
     program:  POLY2.FOR).
 
(    Syntax:  CALL PQSD(A,B,P,Q,X,IDIMX)
 
#    ________            ___________

$    Argument            Description
 
D    A                   Coefficient of Z in remainder (calculated).
 
A    B                   Constant term in remainder (calculated).
  
B    P                   Coefficient of Z in quadratic polynomial.
 
?    Q                   Constant term in quadratic polynomial.
  
K    X                   Coefficient vector for given  polynomial,  ordered
 8                        from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
    Method:
 
K    PQSD divides polynomial by the quadratic Z**2-P*Z-Q, giving the linear
y    remainder A*Z+B.
  
 
 
    PSUB Subroutine
M    PSUB Subroutine
 
K    PSUB subtracts one polynomial from another (Test program:  POLY2.FOR).
  
0    Syntax:  CALL PSUB(Z,IDIMZ,X,IDIMX,Y,IDIMY)
 
#    ________            ___________
_$    Argument            Description
 
K    Z                   Vector of  resultant  coefficients,  ordered  from
 3                        smallest to largest power.
  
5    IDIMZ               Dimension of Z (calculated).
o 
K    X                   Vector  of  coefficients  for  first   polynomial,
i@                        ordered from smallest to largest power.
 
<    IDIMX               Dimension of X (degree is IDIMX-1).
 
K    Y                   Vector  of  coefficients  for  second  polynomial,
 @                        ordered from smallest to largest power.
      MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-63
  
 
<    IDIMY               Dimension of Y (degree is IDIMY-1).
 

    Remarks:
s 
K    Vector Z may be in same location as either vector X or vector  Y  only
 K    if  the  dimension  of X is not less than the other input vector.  The
 >    resultant polynomial can have trailing zero coefficients.
 
    Method:
 
K    PSUB calculates the dimension of resultant vector IDIMZ as the  larger
sK    of the two input vector dimensions.  It then subtracts coefficients in
 :    vector Y from corresponding coefficients in vector X.
 
 
 
    PVAL Subroutine
     PVAL Subroutine
 
K    PVAL evaluates a polynomial for a given value of the  variable  (Test:
r    POLY1.FOR).
 
(    Syntax:  CALL PVAL(RES,ARG,X,IDIMX)
 
#    ________            ___________
 $    Argument            Description
 
7    RES                 Resultant value of polynomial.
r 
1    ARG                 Given value of variable.

 
K    X                   Vector of coefficients, ordered from  smallest  to
S'                        largest power.
_ 
(    IDIMX               Dimension of X.
 
    Method:
 
:    Evaluation is done by means of nested multiplication.
 
 
 
    PVSUB Subroutine
    PVSUB Subroutine
  
K    PVSUB substitutes a polynomial for the variable of another  polynomial
      (Test program:  POLY2.FOR).
 
=    Syntax:  CALL PVSUB(Z,IDIMZ,X,IDIMX,Y,IDIMY,WORK1,WORK2)
t 
#    ________            ___________
 $    Argument            Description
 
K    Z                   Vector of coefficients for  resultant  polynomial,
 @                        ordered from smallest to largest power.
 
(    IDIMZ               Dimension of Z.
 
K    X                   Vector of coefficients  for  original  polynomial,
       MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-64
i 
 
@                        ordered from smallest to largest power.
 
(    IDIMX               Dimension of X.
 
K    Y                   Vector of coefficients for the polynomial that  is
 K                        substituted   for   the   variable,  ordered  from
 3                        smallest to largest power.

 
(    IDIMY               Dimension of Y.
 
E    WORK1               Working storage array (same dimension as Z).
  
E    WORK2               Working storage array (same dimension as Z).
e 
3    Subroutines and Function Subprograms Required:
n 
	    PMPY
 
    PADDM
	    PCLA
i 
    Method:
 
K    PVSUB substitutes polynomial Y for the variable  of  polynomial  X  to
eK    form   polynomial   Z.    The  dimension  of  the  new  polynomial  is
O             (
:    (IDIMX-1)(IDIMY-1)+1.  PVSUB requires two work areas.
 
 
 
    REFERENCES
    REFERENCES
  
B    Bauser.  "Algorithm 60," CACM, Vol. 4, Iss, 6 (1961), p. 255.
 
F    Boersma.  "Computation of Fresnel Integrals," Mathematical Tables
C    and Other Aids to Computation, Vol. 14, No. 72 (l960), p. 380.
  
C    Bulirsch, R.  "Numerical Calculation of Elliptic Integrals and
p<    Elliptic Functions," Handbook Series Special Functions,
5    Numerische Mathematik, Vol. 7 (1965), pp. 78-90.
n 
G    Filippi.  "Das Verfahrem von Romberg-Stiefel-Bauer als Spezialfall
S:    des Allgemeinen Prinzips von Richardson," Mathematik-
;    Technik-Wirtschaft, Vol. 11, Iss. 2 (1964), pp. 49-54.
  
D    Golstein, H., and R.M.  Thaler.  "Recurrence Techniques for the
F    Calculation of Bessel Functions," M.T.A.C., Vol. 13, pp. 102-108.
 
=    Hasting, C.  Jr.  "The Recursion Relation and Polynomial
a@    Approximation," Approximation for Digital Computers.  1955.
 
I    Herriot, J.G.  "Algorithm 26," CACM, Vol. 3, Iss .11 (1960), p. 603.
o 
8                      ____________ __ _________ ________
E    Hildebrand, F.B.  Introduction to Numerical Analysis.  New York:
m    McGraw-Hill, 1974.
M 
F    Hitchcock, A.J.M.  "Polynomial Approximations to Bessel Functions
 y    MATHEMATICAL OPERATIONS
 K    MATHEMATICAL OPERATIONS                                      Page 3-65
m 
 
@    of Order Zero and One and Two Related Functions," M.T.A.C.,
    Vol. 11 (1957), pp. 86-88.
  
I    Kristiansen, G.K.  "Zero of Arbitrary Function," Bit, Vol. 3 (1963),
n    pp.205-206.
 
;                 _________ _______ ___ ____ _____ _________
rF    Lance, G.N.  Numerical Methods for High Speed Computers.  London:
    Iliffe, 1960.
 
H    Luke, and Wimp.  "Polynomial Approximation to Integral Transforms,"
7    Mathematical Tables and Other Aids to Computation,
 )    Vol. 15, No. 74 (1961), pp. 174-178.
P 
J                                       ____________  _______  ___  _______
K    Ralston, A., and H.S.  Wilf, eds.  Mathematical  Methods  for  Digital
 
    _________
 6    Computers.  New York:  John Wiley and Sons, 1962.
 
G    Stegun, I.A., and M.  Abramowitz.  "Generation of Bessel Functions

E    on High Speed Computers," M.T.A.C., Vol. 11 (1957), pp. 255-257.
i 
I    Thatcher, H.C.  "Algorithm 15," CACM, Vol. 3, Iss. 8 (1960), p. 475.
  
@    Watson, G.N.  A Treatise on the Theory of Bessel Functions.
/    London:  Cambridge University Press, 1958.
e 
E    Wegstein, J.  "Algorithm 2," CACM, Vol. 3, Iss. 8 (1960), p. 74.
m 
F    Zurmuehl, R.  Praktische Mathematik fuer Ingenieure und Physiker.
    Springer, 1963.
 
P 
 
 
 
 
 
 
 
 
 
 
-                                  APPENDIX A
r 
:                    VERIFYING AND USING SSP UNDER VAX/VMS
 
 
 
E    This appendix describes how to verify and use SSP under VAX/VMS.
e 
 
 
    THE INDIRECT-COMMAND FILES
    THE INDIRECT-COMMAND FILES
e 
K    The SSP distribution volume contains indirect-command files  that  you
 K    use to verify that you performed the installation procedure correctly,
 5    and that your software is in good working order.
u 
B    When you run an indirect-command file, it does the following:
 
K         1.  Directs the VAX FORTRAN compiler to compile  a  FORTRAN  test
OK             program  and  one or more of the Scientific Subroutines.  The
sK             FORTRAN  program  calls  up  to  sixteen  of  the  Scientific
wE             Subroutines, testing to verify that they work correc                                                                                                                                                                                                                                                   S                         $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                              "           ly.
  
K             Compiling creates one or more object  files  called  TMPSSP.n
vK             where n is a number less than ten.  TMPSSP.n is a "temporary"
:K             file because it resides temporarily on a storage device  that
A1             you assign to receive output files.
  
K         2.  The Linker generates the file and creates an executable  file
              called TMPSSP.m.
 
K         3.  Directs the test program TMPSSP.n to run.  Some test programs
.K             require  a file of input data.  Input-data files are included
 K             in the distributed SSP software.  The test program  uses  the
 K             input-data  file  automatically  if  it  needs  one.  If your
 K             software is sound, the test program runs and types some  data
 K             on  your  terminal.   This  data  results  from  calculations

A             performed by the test programs and the subroutines.
a 
K         4.  Deletes all files called TMPSSP (regardless  of  file  type).
AK             Before  running  an indirect-command file, make sure you have
 K             no files called TMPSSP on the device you  assign  to  receive
e%             temporary output files.
  
K    Table A-1 lists the indirect-command files, the subroutine  that  each
 K    indirect-command  file  tests,  the  FORTRAN test file (and input-data
f eK    VERIFYING AND USING SSP UNDER VAX/VMS                         Page A-2
t 
 
K    file, if required) the indirect-command file needs, and the amount  of

B    storage space required for temporary storage of output files.
 
 
*    Table A-1:  The Indirect-Command Files
+    Table A-1:  The Indirect-Command Files
I 
 
C                                                                  
 R         Indirect Command        Subroutines Tested       Test and Data File Used
.         Files                               
 
R         ANOVA.COM               AVCAL.FOR                      ANOVA.FOR        
J                                 AVDAT.FOR                      ANOVA.DAT
+                                 MEANQ.FOR
t 
S         COLROW.COM              CINT.FOR    RINT.FOR           COLROW.FOR        
 6                                 MCPY.FOR    SCMA.FOR
6                                 LOC.FOR     SRMA.FOR
*                                 MTRA.FOR
 
S         DASCR.COM               LOC.FOR                         DASCR.FOR        
eK                                 SUBST.FOR                       DASCR.DAT
,*                                 TAB1.FOR
 
T         EXPON.COM               EXSMO.FOR                       EXPON.FOR         
K                                                                 EXPON.DAT

 
S         FACTO.COM               CORRE.FOR   TRACE.FOR           FACTO.FOR        
 K                                 EIGEN.FOR   VARMX.FOR           FACTO.DAT
.*                                 LOAD.FOR
 
T         FORR.COM                FORIF.FOR                       FORR.FOR          
+                                 FORIT.FOR
a 
T         INTEG.COM               QATR.FOR                        INTEG.FOR         
)                                 RK1.FOR
R 
S         MACHK1.COM              ARRAY.FOR   GMTRA.FOR           MACHK1.FOR       
n7                                 GMADD.FOR   GTPRD.FOR
 5                                 GMPRD.FOR   LOC.FOR
r6                                 GMSUB.FOR   MADD.FOR
 
S         MACHK2.COM              CCUT.FOR    MCPY.FOR            MACHK2.FOR       
n6                                 CTIE.FOR    RCUT.FOR
6                                 DCLA.FOR    RTIE.FOR
6                                 DCPY.FOR    TPRD.FOR
6                                 LOC.FOR     XCPY.FOR
*                                 MATA.FOR
  K    VERIFYING AND USING SSP UNDER VAX/VMS                         Page A-3
  
 
8         Table A-1:  The Indirect-Command Files (Cont.)
 
R         Indirect Command        Subroutines Tested       Test and Data File Used
.         Files                               
 
R         MACHK3.COM              CCPY.FOR    MSUB.FOR           MACHK3.FOR       
6                                 CSUM.FOR    RSRT.FOR
6                                 LOC.FOR     RSUM.FOR
6                                 MFUN.FOR    SMPX.FOR
 
R         MACHK4.                 COMCADD.FOR RADD.FOR           MACHK4.FOR       
6                                 CCPY.FOR    RCPY.FOR
6                                 CSRT.FOR    RECP.FOR
6                                 CTAB.FOR    RTAB.FOR
6                                 LOC.FOR     SADD.FOR
6                                 MFUN.FOR    SCLA.FOR
6                                 MPRD.FOR    SDIV.FOR
6                                 MSTR.FOR    SSUB.FOR
 
R         MCANO.COM               CANOR.FOR   MINV.FOR           MCANO.FOR        
J                                 CORRE.FOR   NROOT.FOR          MCANO.DAT
+                                 EIGEN.FOR
f 
S         MDISC.COM               DISCR.FOR                      MDISC.FOR         
rJ                                 DMATX.FOR                      MDISC.DAT
*                                 MINV.FOR
 
U         NONLIN.COM              RTMI.FOR                       NONLIN.FOR          
3*                                 RTNI.FOR
*                                 RTWI.FOR
 
S         NONPAR.COM              CHISQ.FOR   SRANK.FOR          NONPAR.FOR        
gK                                 GAUSS.FOR   TIE.FOR            NONPAR.DAT
 7                                 FRANK.FOR   TWOAV.FOR
 7                                 RANK.FOR    UTEST.FOR
G 
T         NPAR2.COM               MOMEN.FOR   TIE.FOR            NPAR2.FOR          
7                                 QTEST.FOR   WTEST.FOR
P*                                 RANK.FOR
 
R         POLRG.COM               GDATA.FOR                      POLRG.FOR        
J                                 MINV.FOR                       POLRG.DAT
+                                 MULTR.FOR
.+                                 ORDER.FOR
_  K    VERIFYING AND USING SSP UNDER VAX/VMS                         Page A-4
C 
 
8         Table A-1:  The Indirect-Command Files (Cont.)
 
R         Indirect Command        Subroutines Tested       Test and Data File Used
.         Files                               
 
S         POLY1.COM               PADDM.FOR   PMPY.FOR           POLY1.FOR         
 7                                 PDER.FOR    PNORM.FOR
c6                                 PDIV.FOR    PVAL.FOR
*                                 PINT.FOR
 
R         POLY2.COM               PADD.FOR    PILD.FOR           POLY2.FOR        
6                                 PADDM.FOR   PMPY.FOR
7                                 PCLA.FOR    PNORM.FOR
 6                                 PCLD.FOR    PQSD.FOR
6                                 PDIV.FOR    PSUB.FOR
7                                 PGCD.FOR    PVSUB.FOR
  
S         QDINT.COM               QSF.FOR                        QDINT.FOR         
aJ                                                                QDINT.DAT
 
S         RKGSTT.COM              RKGS.FOR                       RKGSTT.FOR        
  
S         RK2INT.COM              RK2.FOR                        RK2INT.FOR        
dK                                                                RK2INT.DAT
R 
S         SMPRT.COM               POLRT.FOR                      SMPRT.FOR         
cJ                                                                SMPRT.DAT
 
S         SOLVEN.COM              GMPRD.FOR   SIMQ.FOR           SOLVEN.FOR        
 *                                 MINV.FOR
 
R         STAT.COM                ABSNT.FOR   TAB2.FOR           STAT.FOR         
7                                 BOUND.FOR   TALLY.FOR
 7                                 GAUSS.FOR   TTSTT.FOR
N+                                 SUBMX.FOR
  
S         TABLE1.COM              CS.FOR      LEP.FOR            TABLE1.FOR        
 +                                 GAMMA.FOR
h 
S         TABLE2.COM              BESI.FOR    BESK.FOR           TABLE2.FOR        
r6                                 BESJ.FOR    BESY.FOR
 
S         TABLE3.COM              CEL1.FOR    EXPI.FOR           TABLE3.FOR        
T6                                 CEL2.FOR    SICI.FOR
 
S         TIMSER.COM              AUTO.FOR    GAUSS.FOR          TIMSER.FOR        
 5                                 CROSS.FOR   SMO.FOR
g  K    VERIFYING AND USING SSP                                                                                                                                                                                                                                                   T                        < $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                             ; "            UNDER VAX/VMS                         Page A-5
m 
 
#         THE VERIFICATION PROCEDURE
 $         THE VERIFICATION PROCEDURE
 
P         SSP contains more than 100 subroutines.  Verify  only  those  routines
         you plan to use.
 
P         Take the following steps to use the indirect-command files  to  verify
         the SSP subroutines:
 
E         1.  Make sure that VAX FORTRAN is installed on your system.
e 
-         2.  Assign logical device names to:
  
P              o  the directory containing all the files you will use for input.
P                 Assign  this device the logical name "IN$" for "input device."
3                 Enter the following command line:
  
+                 $ ASSIGN SYS$SSP IN$<RET>
s 
                 or
 
1                 $ ASSIGN DISK$0:[USER] IN$<RET>
a 
P              o  the device used for storage  of  the  temporary  output  files
P                 TMPSSP.n  created  by  the indirect-command file when it runs.
P                 Assign this device the  logical  name  "TMP$"  for  "temporary
D                 storage device." Enter the following command line:
 
0                 $ ASSIGN SYS$SCRATCH TMP$<RET>
 
 
P         3.  Consult Table A-1.  Find the name of a subroutine you want to test
=             and the indirect-command file that verifies it.
i 
O         4.  Run the indirect-command file.  Enter the following command line:
g 
              @IN$:filename<RET>
 
             where:
 
P             @  is  the  symbol   that   indicates   you   want   to   run   an
$             indirect-command file.
 
P             filename  is the name of the indirect-command  file  you  want  to
             run.
 
P             This command runs the indirect-command file you specify, which  in
1             turn runs the FORTRAN test program.
  
  K    VERIFYING AND USING SSP UNDER VAX/VMS                         Page A-6
  
 
         ERROR CONDITIONS
          ERROR CONDITIONS
 
P         If an error occurs during the execution of an  indirect-command  file,
P         the  command  file  stops running and an error message is displayed on
P         your terminal.   If  an  error  occurs  during  the  execution  of  an
P         indirect-command  file,  check to ensure that the following conditions
         have been met:
 
P          o  A necessary system program such as the VAX FORTRAN compiler, or  a
P             utility  program  such  as the VAX/VMS Linker is installed on your
             system.
1 
P          o  The input device is correctly assigned.  That is, the  device  you
J             designate to be the input device must contain the SSP files.
 
P          o  The output device is correctly assigned.  That is, the device  you
P             designate  to  be  the output device must contain adequate storage
             space.
 
P          o  Your  system  device  or  your  input  and  output   devices   are
             write-enabled.
 
 
P         It is impossible to anticipate all conditions that  can  cause  errors
P         that  are  not  the  fault  of  the software.  If you receive an error
P         message, first check to see that all  the  requirements  listed  above
P         have  been  met  by  your  system.   Then,  if  you  need  to, see the
P         appropriate VAX/VMS documentation to help you determine the  cause  of
P         the  error  and correct it.  You find the appropriate documentation by
P         noting the name of the program which gave you the error  message,  for
P         example,  error  messages  with  a  prefix  of "LNK" are issued by the
P         LINKER or those with a prefix of "FORT" are issued by  FORTRAN.   Then
P         look in the VAX/VMS manual that contains information about the issuing
6         program to see what the error message means.
 
P         Finally, if one of the  indirect-command  files  will  not  run,  even
P         though  you  have  not  made  any  of  the  errors  described above or
P         neglected any of the requirements listed above, you may have  received
P         a  defective  copy  of  your Scientific Subroutines software.  Contact
'         DIGITAL for more information.
  
 
 
A         CREATING A PROGRAM THAT CALLS THE SCIENTIFIC SUBROUTINES
MB         CREATING A PROGRAM THAT CALLS THE SCIENTIFIC SUBROUTINES
 
P         Take the following steps  to  create,  link,  and  execute  a  FORTRAN
8         program that calls the Scientific Subroutines:
 
+         1.  Write and check your program.
R 
P         2.  Use one of the VAX editors, such as EVE  or  EDT,  to  enter  your
7             program into a source file.  For example,
  
*             $ EDIT program_name.FOR<RET>
  K    VERIFYING AND USING SSP UNDER VAX/VMS                         Page A-7
  
 
P             For information about entering  the  text  of  your  file,  making
O                                                       ___ ___ _________ ______
 P             changes, and displaying the file, see the VAX EDT Reference Manual
'                    ______ _____ __ ___
 )             or the User's Guide to EVE.
  
1                                            NOTE
M 
H                     Always specify a file extension when  you  use  an
H                     editor.   VAX/VMS  editors do not use default file
H                     extensions.  In this case, give your  source  file
H                     the  extension  .FOR  since  that  is  the default
H                     extension the VAX FORTRAN compiler  uses  when  it
,                     compiles your program.
 
 
P         3.  Use the VAX FORTRAN  compiler  to  create  object  files  of  your
P             program  and of the Scientific Subroutines you wish to use.  Since
P             you can specify only one input file each time you use the  FORTRAN
G             compiler, you must compile the subroutines one at a time.
  
P             You can compile frequently used Scientific Subroutines in advance.
P             Then,  you  only  need  to  compile  the  main program using these
             routines.
  
P         4.  Use the VAX/VMS Linker to link the object  file  of  your  program
P             with  the  object  files  of  your  Scientific  Subroutines.   For
             example:
 
8             $ LINK program_name,sub1,sub2,...subn<RET>
 
             where:
 
<             program_name  is the name of your main program
 
P             sub1  is the name of the first Scientific Subroutine you  want  to
%             link with your program.
T 
P             sub2  is the name of the second Scientific Subroutine you want  to
%             link with your program.
  
P             subn  is the name of the last Scientific Subroutine  you  want  to
%             link with your program.
  
P             You can specify as many  object  files  as  you  need  for  input.
P             However,  if  your  list of input files uses more than one line on
J                                        _______  ______  _________  ______
P             your  terminal,  see  the  VAX/VMS  Linker  Reference  Manual  for
H             information about how to input files using multiple lines.
 
D             To run your program, enter the following command line:
 
%             $ RUN program_name<RET>
  
P             For more information about compiling, linking, and running FORTRAN
O                                ___ _______ ________ ______         ___ _______
 P             programs,  see the VAX FORTRAN Refernce Manual and the VAX FORTRAN
             ______ _____
B             User's Guide.
   K    VERIFYING AND USING SSP UNDER VAX/VMS                         Page A-8
  
 
8         STORING THE SCIENTIFIC SUBROUTINES IN A LIBRARY
9         STORING THE SCIENTIFIC SUBROUTINES IN A LIBRARY
S 
P         After determining that the Scientific Subroutines that you want to use
P         are  sound,  copy  them  to  your  system volume or to the development
P         volume where you store your FORTRAN  programs,  or  place  them  in  a
         library.
 
P         To create a library from the Scientific Subroutines you  compile,  use
P         the VAX/VMS LIBRARIAN Utility.  You may also use the LIBRARIAN Utility
P         to add modules to or delete modules from a library at  a  later  time.
P         This  includes  the system library, SYS$LIBRARY:IMAGELIB.OLB.  See the
+         _______ _________ _________ ______
 P         VAX/VMS Librar                                                                                                                                                                                                                                                   U                        #. $      RTI020.J                         =  ,[STANVICK.SEAS$WORK_294000DB]SSP_GUIDE.MEM;1                                                                                    U                                         ian Reference Manual for information about  the  VAX/VMS
         Librarian Utility.
 
P         If you have placed the subroutines in a library, you do  not  need  to
P         list  each individual subroutine in the LINKER command line.  You only
P         need to specify the /USERLIBRARY qualifier.  If you have  placed  them
P         in  the system library, SYS$LIBRARY:IMAGELIB.OLB, you do not even need
P         to specify the /USERLIBRARY qualifier in the LINKER command line.  The
P         VAX/VMS  LINKER  automatically  searches  the  system  library  for  a
5         subroutine or function needed by a program.
g 
P         For example, suppose your  compiled  program,  MYPROG.OBJ,  calls  the
P         compiled  subroutines  ABSNT.OBJ,  BOUND.OBJ,  and GAUSS.OBJ.  To link
3         MYPROG, enter the following command line:

 
.         $ LINK MYPROG,ABSNT,BOUND,GAUSS<RET>
 
P         If you place the subroutines in a library in your SYS$LOGIN directory,
P         named,  for  example, MYLIB.OLB, you must first define the LNK$LIBRARY
P         logical name.  To define  LNK$LIBRARY,  enter  the  following  command
         line:
t 
.         $ DEFINE LNK$LIBRARY SYS$LOGIN:MYLIB
 
P         Then, to link a program named  MYPROG,  enter  the  following  command
         line:
  
(         $ LINK/USERLIBRARY MYPROG<RET>
 
P         If you place the subroutines in  SYS$LIBRARY:IMAGELIB.OLB,  enter  the
0         following command line to link MYPROG:
 
         $ LINK MYPROG<RET>
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ' * [STANVICK.SEAS$WORK_294000DB]SSUB.FOR;1 +  ,    .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6  ]$A  7 $A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE SSUB C  C        PURPOSEE C           SUBTRACT A SCALAR FROM EACH ELEMENT OF A MATRIX TO FORM A  C           RESULTANT MATRIX C  C        USAGE# C           CALL SSUB(A,C,R,N,M,MS)  C " C        DESCRIPTION OF PARAMETERS$ C           A - NAME OF INPUT MATRIX C           C - SCALAR% C           R - NAME OF OUTPUT MATRIX 0 C           N - NUMBER OF ROWS IN MATRIX A AND R3 C           M - NUMBER OF COLUMNS IN MATRIX A AND R G C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A (AND R)  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD A C           SCALAR IS SUBTRACTED FROM EACH EACH ELEMENT OF MATRIX  C H C     .................................................................. C #       SUBROUTINE SSUB(A,C,R,N,M,MS)        DIMENSION A(1),R(1)  C " C        COMPUTE VECTOR LENGTH, IT C        CALL LOC(N,M,IT,N,M,MS)  C  C        SUBTRACT SCALAR C        DO 1 I=1,IT      1 R(I)=A(I)-C        RETURN	       END                                                                                                                                                                                                                                                                                                                     ' * [STANVICK.SEAS$WORK_294000DB]STAT.COM;1 +  ,  
   .     /     4 @       L                  - =    0   1    2   3      K  P   W   O     5 -  6 *@  7 $A  8          9          G    H  J                        @ $ COPY IN$:STAT.FOR,ABSNT.FOR,BOUND.FOR,SUBMX.FOR TMP$:TMPSSP.11@ $ COPY IN$:TALLY.FOR,TTSTT.FOR,GAUSS.FOR,TAB2.FOR TMP$:TMPSSP.12- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.2 TMP$:TMPSSP.12 6 $ LINK/EXECUTABLE=TMP$:TMPSSP.3 TMP$:TMPSSP.1,TMPSSP.2 $ RUN TMP$:TMPSSP.3  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                  ' * [STANVICK.SEAS$WORK_294000DB]STAT.FOR;1 +  , 
   . 	    /     4 C   	    V                   - =    0   1    2   3      K  P   W   O     5 -  6  %A  7 $A  8          9          G    H  J                        - C                                             ? C	STAT.FOR - SAMPLE PROGRAM (STATISTICS - DATA SAMPLING) USING: $ C  ABSNT	- DETECTION OF MISSING DATA2 C  BOUND	- SELECTION OF OBSERVATIONS WITHIN BOUNDS& C  SUBMX	- BUILDING OF A SUBSET MATRIX+ C  TAB2 	- TABULATION OF DATA (2 VARIABLES) ) C  TALLY	- TOTALS, MEANS, S. D., MIN, MAX # C  TTSTT	- TEST ON POPULATION MEANS + C  ALSO ... USE GAUSS (FOR DATA GENERATION)  C > 	DIMENSION A(20,10),S(20),TOTAL(10),AVE(10),STDEV(10),VMIN(10)? 	DIMENSION VMAX(10),BLO(10),BHI(10),UNDER(10),BETW(10),OVER(10) = 	DIMENSION NOV(2),UBO(3,2),FREQ(10,10),PERCNT(10,10),B(20,10) ; 	DIMENSION A1(200),STAT1(3,10),STAT2(3,10),B1(200),ISEED(2) : 	EQUIVALENCE (STDEV,UNDER,FREQ(1,3)),(VMIN,BETW,FREQ(1,4)). 	EQUIVALENCE (TOTAL,FREQ,B,B1),(AVE,FREQ(1,2))2 	EQUIVALENCE (VMAX,OVER,FREQ(1,5)),(B(1,6)),(A,A1) C 8 	DATA NOV/1,8/,UBO/2.,10.,10.,2.,10.,10./,ISEED/13107,0/ 	DATA BLO/10*0./,BHI/10*12./ C  C   C  GENERATE ORIGINAL DATA MATRIX
 	DO 1 I=1,200  	CALL GAUSS(ISEED,3.,6.,RV)  1	A1(I)=FLOAT(IABS(IFIX(RV)))  C  C  LOOK FOR MISSING DATA 	NO=20 	NV=10 	CALL ABSNT(A,S,NO,NV)( 	TYPE 100, ((A(I,J),J=1,10),S(I),I=1,20)@ 100	FORMAT(//' DETECTION OF MISSING DATA BY ABSNT:'/17X'ORIGINAL- 	1 MATRIX',29X,'S-VECTOR'//(10F5.0,10X,F5.0))  C 0 C  ELIMINATE OBSERVATIONS WITH VARIABLES MISSING 	CALL SUBMX(A,B,S,NO,NV,N)	 	TYPE 101 < 101	FORMAT(//' ELIMINATION OF "BAD" OBSERVATIONS BY SUBMX:') 	DO 20 I=1,N 	NI=I-N ! 20	TYPE 1011, (B1(J*N+NI),J=1,10)  1011	FORMAT(10F5.0)  C " C  CHECK RANGE WITHIN 2*SIGMA OF 62 	CALL BOUND(A,S,BLO,BHI,UNDER,BETW,OVER,NO,NV,IER)% 	TYPE 102, (I,I=1,10),UNDER,BETW,OVER 8 102	FORMAT(//' CHECK RANGE WITH BOUND;'/' VARIABLE NO.'/1 	1 10I5/' LESS THAN 0'/10F5.0/' IN RANGE'/10F5.0/  	2 ' GREATER THAN 12'/10F5.0)  	IF(IER.NE.0) TYPE 103, IER  C   C  COMPILE FULL-BLOWN STATISTICS4 	CALL TALLY(A,S,TOTAL,AVE,STDEV,VMIN,VMAX,NO,NV,IER) 103	FORMAT(/' AND IER ='I2) / 	TYPE 104, (I,I=1,10),TOTAL,AVE,STDEV,VMIN,VMAX : 104	FORMAT(//' FULL STATISTICS ON ARRAY:'/' VARIABLE NO.'/; 	1 10I8/' TOTALS'/10F8.0/' AVERAGES'/10F8.2/' STAND. DEV.'/ ' 	2 10F8.3/' MINIMUM OBSERVATION'/10F8.0 " 	3/'  MAXIMUM OBSERVATION'/10F8.0) 	IF (IER.NE.0) TYPE 103, IER C 0 C  TABULATION OF STATISTICS ON VARIABLES 1 AND 25 	CALL TAB2(A,S,NOV,UBO,FREQ,PERCNT,STAT1,STAT2,NO,NV) & 	TYPE 105, ((FREQ(I,J),J=1,10),I=1,10)1 105	FORMAT(//' STATISTICS ON VARIABLES 1 AND 8:'/ 9 	1 '   FREQUENCY MATRIX:  (<2),2(1.00)10,(>10)'/(10F5.0)) ) 	TYPE 106,  ((PERCNT(I,J),J=1,10),I=1,10) C 106	FORMAT(/'   PER CENT DISTRIBUTION:  (SAME PARTITION)'/(10F5.0))  	I=1( 	TYPE 107, I,((STAT1(J,K),K=1,10),J=1,3)? 107	FORMAT(/' FOR VARIABLE',I2,' OVER SAME RANGE:'/'   TOTALS'/ 6 	1 10F8.0,/'   MEANS'/,10F8.1,/'   STD. DEV.'/,10F8.5) 	I=8( 	TYPE 107, I,((STAT2(J,K),K=1,10),J=1,3) C + C  STATISTICS (T-TEST) ON VARIABLES 1 AND 8  	DO 2 I=1,10 	VMIN(I)=A(1,I)  2	VMAX(I)=A(8,I)
 	DO 3 IOP=2,4 ( 	CALL TTSTT(VMIN,10,VMAX,10,IOP,NDF,ANS) 	GO TO (3,4,5,6),IOP
 4	TYPE 1083 108	FORMAT(//' T-STATISTICS ON VARIABLES 1 AND 8'// 8 	1 '   HYPOTHESES:  MEANS EQUAL, GIVEN VARIANCES EQUAL') 	GO TO 3
 5	TYPE 109C 109	FORMAT(/'   HYPOTHESIS:  MEANS EQUAL, GIVEN VARIANCES UNEQUAL')  	GO TO 3
 6	TYPE 110= 110	FORMAT(/'   HYPOTHESIS:  MEANS EQUAL, VARIANCES UNKNOWN')  3	TYPE 111, NDF,ANS = 111	FORMAT(10X'DEG. OF FREEDOM ='I4,10X,'T-STATISTIC ='F12.5)  	STOP 'STAT successful!' 	END                                                                                                                                                                                        ( * [STANVICK.SEAS$WORK_294000DB]SUBMX.FOR;1 +  , 
   .     /     4 H       j                   - =    0   1    2   3      K  P   W   O     5 -  6 -&A  7 $A  8          9          G    H  J                        `                                                                                                                   V                        ) $      RTI020.J                       
  =  ([STANVICK.SEAS$WORK_294000DB]SUBMX.FOR;1                                                                                       H                              v              C H C     .................................................................. C  C        SUBROUTINE SUBMX  C  C        PURPOSEE C           BASED ON VECTOR S DERIVED FROM SUBROUTINE SUBST OR ABSNT, F C           THIS SUBROUTINE COPIES FROM A LARGER MATRIX OF OBSERVATIONA C           DATA A SUBSET MATRIX OF THOSE OBSERVATIONS WHICH HAVE E C           SATISFIED CERTAIN CONDITION.  THIS SUBROUTINE IS NORMALLY F C           USED PRIOR TO STATISTICAL ANALYSES (E.G., MULTIPLE REGRES-# C           SION, FACTOR ANALYSIS).  C  C        USAGE& C           CALL SUBMX (A,D,S,NO,NV,N) C " C        DESCRIPTION OF PARAMETERS8 C           A  - INPUT MATRIX OF OBSERVATIONS, NO BY NV.8 C           D  - OUTPUT MATRIX OF OBSERVATIONS, N BY NV.G C           S -  INPUT VECTOR OF LENGTH NO CONTAINING THE CODES DERIVED 0 C                FROM SUBROUTINE SUBST OR ABSNT.@ C           NO - NUMBER OF OBSERVATIONS. NO MUST BE > OR = TO 1.% C           NV - NUMBER OF VARIABLES. H C           N  - OUTPUT VARIABLE CONTAINING THE NUMBER OF NON-ZERO CODES C                IN VECTOR S.  C  C        REMARKS= C           MATRIX D CAN BE IN THE SAME LOCATION AS MATRIX A.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD A C           IF S(I) CONTAINS A NON-ZERO CODE, I-TH OBSERVATION IS > C           COPIED FROM THE INPUT MATRIX TO THE OUTPUT MATRIX. C H C     .................................................................. C &       SUBROUTINE SUBMX (A,D,S,NO,NV,N)       DIMENSION A(1),D(1),S(1) C 	       L=0 
       LL=0       DO 20 J=1,NV       DO 15 I=1,NO       L=L+1        IF(S(I)) 15, 15, 10 
    10 LL=LL+1        D(LL)=A(L)    15 CONTINUE    20 CONTINUE C ) C        COUNT NON-ZERO CODES IN VECTOR S  C 	       N=0        DO 30 I=1,NO       IF(S(I)) 30, 30, 25     25 N=N+1     30 CONTINUE C        RETURN	       END                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]SUBST.FOR;1 +  , Y   . 	    /     4 H   	   	                    - =    0   1    2   3      K  P   W   O 
    5 -  6  'A  7 +$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE SUBST  C  C        PURPOSEE C           DERIVE A SUBSET VECTOR INDICATING WHICH OBSERVATIONS IN A C C           SET HAVE SATISFIED CERTAIN CONDITIONS ON THE VARIABLES.  C  C        USAGE+ C           CALL SUBST (A,C,R,B,S,NO,NV,NC) G C           PARAMETER B MUST BE DEFINED BY AN EXTERNAL STATEMENT IN THE  C           CALLING PROGRAM  C " C        DESCRIPTION OF PARAMETERS- C           A  - OBSERVATION MATRIX, NO BY NV G C           C  - INPUT MATRIX, 3 BY NC, OF CONDITIONS TO BE CONSIDERED. E C                THE FIRST ELEMENT OF EACH COLUMN OF C REPRESENTS THE F C                NUMBER OF THE VARIABLE (COLUMN OF THE MATRIX A) TO BE? C                TESTED, THE SECOND ELEMENT OF EACH COLUMN IS A + C                RELATIONAL CODE AS FOLLOWS + C                     1. FOR LT (LESS THAN) 7 C                     2. FOR LE (LESS THAN OR EQUAL TO) * C                     3. FOR EQ (EQUAL TO). C                     4. FOR NE (NOT EQUAL TO): C                     5. FOR GE (GREATER THAN OR EQUAL TO). C                     6. FOR GT (GREATER THAN)E C                THE THIRD ELEMENT OF EACH COLUMN IS A QUANTITY TO BE E C                USED FOR COMPARISON WITH THE OBSERVATION VALUES. FOR 3 C                EXAMPLE, THE FOLLOWING COLUMN IN C  C                          2.  C                          5.  C                         92.5D C                CAUSES THE SECOND VARIABLE TO BE TESTED FOR GREATER& C                THAN OR EQUAL TO 92.5E C           R  - WORKING VECTOR USED TO STORE INTERMEDIATE RESULTS OF E C                ABOVE TESTS ON A SINGLE OBSERVATION. IF CONDITION IS G C                SATISFIED, R(I) IS SET TO 1. IF IT IS NOT, R(I) IS SET + C                TO 0. VECTOR LENGTH IS NC. B C           B  - NAME OF SUBROUTINE TO BE SUPPLIED BY THE USER. IT= C                CONSISTS OF A BOOLEAN EXPRESSION LINKING THE D C                INTERMEDIATE VALUES STORED IN VECTOR R. THE BOOLEANB C                OPERATORS ARE '*' FOR'AND', '+' FOR 'OR'. EXAMPLE* C                     SUBROUTINE BOOL(R,T)$ C                     DIMENSION R(3)( C                     T=R(1)*(R(2)+R(3)) C                     RETURN C                     END 3 C                THE ABOVE EXPRESSION IS TESTED FOR - C                     R(1).AND.(R(2).OR.R(3)) @ C           S  - OUTPUT VECTOR INDICATING, FOR EACH OBSERVATION,E C                WHETHER OR NOT PROPOSITION B IS SATISFIED. IF IT IS, E C                S(I) IS NON-ZERO. IF IT IS NOT, S(I) IS ZERO. VECTOR  C                LENGTH IS NO.@ C           NO - NUMBER OF OBSERVATIONS. NO MUST BE > OR = TO 1.= C           NV - NUMBER OF VARIABLES. NV MUST BE > OR = TO 1. G C           NC - NUMBER OF BASIC CONDITIONS TO BE SATISFIED. NC MUST BE , C                GREATER THAN OR EQUAL TO 1. C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIREDE C           B  THE NAME OF ACTUAL SUBROUTINE SUPPLIED BY THE USER MAY E C              BE DIFFERENT (E.G., BOOL), BUT SUBROUTINE SUBST ALWAYS H C              CALLS IT AS B.  IN ORDER FOR SUBROUTINE SUBST TO DO THIS,? C              THE NAME OF THE USER-SUPPLIED SUBROUTINE MUST BE G C              DEFINED BY AN EXTERNAL STATEMENT IN THE CALLING PROGRAM. A C              THE NAME MUST ALSO BE LISTED IN THE ''CALL SUBST'' , C              STATEMENT.  (SEE USAGE ABOVE) C  C        METHOD 7 C           THE FOLLOWING IS DONE FOR EACH OBSERVATION. E C           CONDITION MATRIX IS ANALYZED TO DETERMINE WHICH VARIABLES D C           ARE TO BE EXAMINED. INTERMEDIATE VECTOR R IS FORMED. THEE C           BOOLEAN EXPRESSION (IN SUBROUTINE B) IS THEN EVALUATED TO F C           DERIVE THE ELEMENT IN SUBSET VECTOR S CORRESPONDING TO THE C           OBSERVATION. C H C     .................................................................. C *       SUBROUTINE SUBST(A,C,R,B,S,NO,NV,NC)#       DIMENSION A(1),C(1),R(1),S(1)  C        DO 9 I=1,NO 
       IQ=I-NO 
       K=-2       DO 8 J=1,NC  C  C        CLEAR R VECTOR  C        R(J)=0.0 C B C         LOCATE ELEMENT IN OBSERVATION MATRIX AND RELATIONAL CODE C        K=K+3 
       IZ=C(K)        IA=IQ+IZ*NO        IGO=C(K+1) C  C         FORM R VECTOR  C        Q=A(IA)-C(K+2)       GO TO(1,2,3,4,5,6),IGO     1 IF(Q) 7,8,8      2 IF(Q) 7,7,8      3 IF(Q) 8,7,8      4 IF(Q) 7,8,7      5 IF(Q) 8,7,7      6 IF(Q) 8,8,7      7 R(J)=1.0     8 CONTINUE C  C        CALCULATE S VECTOR  C      9 CALL B(R,S(I))       RETURN	       END                         ' * [STANVICK.SEAS$WORK_294000DB]TAB1.FOR;1 +  , o)   . 	    /     4 H   	   	                    - =    0   1    2   3      K  P   W   O 
    5 -  6 lj(A  7 `@$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE TAB1 C  C        PURPOSED C           TABULATE FOR ONE VARIABLE IN AN OBSERVATION MATRIX (OR AD C           MATRIX SUBSET), THE FREQUENCY AND PERCENT FREQUENCY OVERF C           GIVEN CLASS INTERVALS. IN ADDITION, CALCULATE FOR THE SAMEE C           VARIABLE THE TOTAL, AVERAGE, STANDARD DEVIATION, MINIMUM,  C           AND MAXIMUM. C  C        USAGE9 C           CALL TAB1(A,S,NOVAR,UBO,FREQ,PCT,STATS,NO,NV)  C " C        DESCRIPTION OF PARAMETERS0 C           A     - OBSERVATION MATRIX, NO BY NV? C           S     - INPUT VECTOR GIVING SUBSET OF A. ONLY THOSE G C                   OBSERVATIONS WITH A CORRESPONDING NON-ZERO S(J) ARE 4 C                   CONSIDERED. VECTOR LENGTH IS NO.G C           NOVAR - THE VARIABLE TO BE TABULATED. NOVAR MUST BE GREATER D C                   THAN OR EQUAL TO 1 AND LESS THAN OR EQUAL TO NV.? C                   AND UPPER LIMIT OF VARIABLE TO BE TABULATED A C                   IN UBO(1), UBO(2) AND UBO(3) RESPECTIVELY. IF D C                   LOWER LIMIT IS EQUAL TO UPPER LIMIT, THE PROGRAMH C                   USES THE MINIMUM AND MAXIMUM VALUES OF THE VARIABLE.G C                   NUMBER OF INTERVALS, UBO(2), MUST INCLUDE TWO CELLS D C                   FOR VALUES UNDER AND ABOVE LIMITS. VECTOR LENGTH C                   IS 3. B C           FREQ  - OUTPUT VECTOR OF FREQUENCIES. VECTOR LENGTH IS C                   UBO(2). A C           PCT   - OUTPUT VECTOR OF R                                                                                                                                                                                   W                        g $      RTI020.J                       o)  =  '[STANVICK.SEAS$WORK_294000DB]TAB1.FOR;1                                                                                        H     	                         s             ELATIVE FREQUENCIES. VECTOR % C                   LENGTH IS UBO(2). E C           STATS - OUTPUT VECTOR OF SUMMARY STATISTICS, I.E., TOTAL, E C                   AVERAGE, STANDARD DEVIATION, MINIMUM AND MAXIMUM. H C                   VECTOR LENGTH IS 5. IF S IS NULL, THEN TOTAL,AVERAGEH C                   AND STANDARD DEVIATION = 0, MIN=1.E75 AND MAX=-1.E75B C           NO    - NUMBER OF OBSERVATIONS. NO MUST BE > OR = TO 1E C           NV    - NUMBER OF VARIABLES FOR EACH OBSERVATION. NV MUST 2 C                   BE GREATER THAN OR EQUAL TO 1. C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           THE INTERVAL SIZE IS CALCULATED FROM THE GIVEN INFORMATIONA C           OR OPTIONALLY FROM THE MINIMUM AND MAXIMUM VALUES FOR G C           VARIABLE NOVAR. THE FREQUENCIES AND PERCENT FREQUENCIES ARE : C           THEN CALCULATED ALONG WITH SUMMARY STATISTICS.C C           THE DIVISOR FOR STANDARD DEVIATION IS ONE LESS THAN THE ( C           NUMBER OF OBSERVATIONS USED. C H C     .................................................................. C 9       SUBROUTINE TAB1(A,S,NOVAR,UBO,FREQ,PCT,STATS,NO,NV) 8       DIMENSION A(1),S(1),UBO(1),FREQ(1),PCT(1),STATS(1)       DIMENSION WBO(3)       DO 5 I=1,3     5 WBO(I)=UBO(I)  C  C        CALCULATE MIN AND MAX C        VMIN=1.0E37        VMAX=-1.0E37       IJ=NO*(NOVAR-1)        DO 30 J=1,NO
       IJ=IJ+1        IF(S(J)) 10,30,10     10 IF(A(IJ)-VMIN) 15,20,20     15 VMIN=A(IJ)    20 IF(A(IJ)-VMAX) 30,30,25     25 VMAX=A(IJ)    30 CONTINUE       STATS(4)=VMIN        STATS(5)=VMAX  C  C        DETERMINE LIMITS  C         IF(UBO(1)-UBO(3)) 40,35,40    35 UBO(1)=VMIN        UBO(3)=VMAX     40 INN=UBO(2) C  C        CLEAR OUTPUT AREAS  C        DO 45 I=1,INN        FREQ(I)=0.0     45 PCT(I)=0.0       DO 50 I=1,3     50 STATS(I)=0.0 C   C        CALCULATE INTERVAL SIZE C ,       SINT=ABS((UBO(3)-UBO(1))/(UBO(2)-2.0)) C  C        TEST SUBSET VECTOR  C        SCNT=0.0       IJ=NO*(NOVAR-1)        DO 75 J=1,NO
       IJ=IJ+1        IF(S(J)) 55,75,55     55 SCNT=SCNT+1.0  C & C        DEVELOP TOTAL AND FREQUENCIES C        STATS(1)=STATS(1)+A(IJ) #       STATS(3)=STATS(3)+A(IJ)*A(IJ)        TEMP=UBO(1)-SINT       INTX=INN-1       DO 60 I=1,INTX       TEMP=TEMP+SINT       IF(A(IJ)-TEMP) 70,60,60     60 CONTINUE       IF(A(IJ)-TEMP) 75,65,65     65 FREQ(INN)=FREQ(INN)+1.0        GO TO 75    70 FREQ(I)=FREQ(I)+1.0     75 CONTINUE       IF (SCNT)79,105,79 C ' C        CALCULATE RELATIVE FREQUENCIES  C     79 DO 80 I=1,INN     80 PCT(I)=FREQ(I)*100.0/SCNT  C . C        CALCULATE MEAN AND STANDARD DEVIATION C        IF(SCNT-1.0) 85,85,90     85 STATS(2)=STATS(1)        STATS(3)=0.0       GO TO 95    90 STATS(2)=STATS(1)/SCNTF       STATS(3)=SQRT(ABS((STATS(3)-STATS(1)*STATS(1)/SCNT)/(SCNT-1.0)))    95 DO 100 I=1,3   100 UBO(I)=WBO(I)    105 RETURN	       END                                                                             ' * [STANVICK.SEAS$WORK_294000DB]TAB2.FOR;1 +  , SC   .     /     4 H      
 z                    - =    0   1    2   3      K  P   W   O     5 -  6 >)A  7 @Q$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE TAB2 C  C        PURPOSED C           PERFORM A TWO-WAY CLASSIFICATION FOR TWO VARIABLES IN ANE C           OBSERVATION MATRIX (OR A MATRIX SUBSET) OF THE FREQUENCY, D C           PERCENT FREQUENCY, AND OTHER STATISTICS OVER GIVEN CLASS C           INTERVALS. C  C        USAGE= C           CALL TAB2(A,S,NOV,UBO,FREQ,PCT,STAT1,STAT2,NO,NV)  C " C        DESCRIPTION OF PARAMETERS0 C           A     - OBSERVATION MATRIX, NO BY NV? C           S     - INPUT VECTOR GIVING SUBSET OF A. ONLY THOSE G C                   OBSERVATIONS WITH A CORRESPONDING NON-ZERO S(J) ARE 4 C                   CONSIDERED. VECTOR LENGTH IS NO.G C           NOV   - VARIABLES TO BE CROSS-TABULATED. NOV(1) IS VARIABLE H C                       1, NOV(2) IS VARIABLE 2. VECTOR LENGTH IS 2. NOVH C                       MUST BE GREATER THAN OR EQUAL TO 1 AND LESS THAN' C                       OR EQUAL TO NV. ? C           UBO   - 3 BY 2 MATRIX GIVING LOWER LIMIT, NUMBER OF F C                   INTERVALS, AND UPPER LIMIT OF BOTH VARIABLES TO BEB C                   TABULATED (FIRST COLUMN FOR VARIABLE 1, SECONDF C                   COLUMN FOR VARIABLE 2). IF LOWER LIMIT IS EQUAL TOD C                   UPPER LIMIT FOR VARIABLE 1, THE PROGRAM USES THEG C                   MINIMUM AND MAXIMUM VALUES ON EACH VARIABLE. NUMBER E C                   OF INTERVALS MUST INCLUDE TWO CELLS FOR UNDER AND ! C                   ABOVE LIMITS. ? C           FREQ  - OUTPUT MATRIX OF FREQUENCIES IN THE TWO-WAY D C                   CLASSIFICATION. ORDER OF MATRIX IS INT1 BY INT2,G C                   WHERE INT1 IS THE NUMBER OF INTERVALS OF VARIABLE 1 F C                   AND INT2 IS THE NUMBER OF INTERVALS OF VARIABLE 2.A C                   INT1 AND INT2 MUST BE SPECIFIED IN THE SECOND @ C                   POSITION OF RESPECTIVE COLUMN OF UBO MATRIX.D C           PCT   - OUTPUT MATRIX OF PERCENT FREQUENCIES, SAME ORDER C                   AS FREQ.@ C           STAT1 - OUTPUT MATRIX SUMMARIZING TOTALS, MEANS, ANDB C                   STANDARD DEVIATIONS FOR EACH CLASS INTERVAL OF= C                   VARIABLE 1. ORDER OF MATRIX IS 3 BY INT1. F C           STAT2 - SAME AS STAT1 BUT OVER VARIABLE 2. ORDER OF MATRIX! C                   IS 3 BY INT2. C C           NO    - NUMBER OF OBSERVATIONS. NO MUST BE GREATER THAN " C                   OR EQUAL TO 1.@ C           NV    - NUMBER OF VARIABLES FOR EACH OBSERVATION. NV7 C                   MUST BE GREATER THAN OR EQUAL TO 1.  C  C        REMARKS6 C           IF S IS NULL, OUTPUT AREAS ARE SET TO ZERO C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           INTERVAL SIZES FOR BOTH VARIABLES ARE CALCULATED FROM THE H C           GIVEN INFORMATION OR OPTIONALLY FROM THE MINIMUM AND MAXIMUMD C           VALUES. THE FREQUENCY AND PERCENT FREQUENCY MATRICES AREC C           DEVELOPED. MATRICES STAT1 AND STAT2 SUMMARIZING TOTALS, ? C           MEANS, AND STANDARD DEVIATIONS ARE THEN CALCULATED. C C           THE DIVISOR FOR STANDARD DEVIATION IS ONE LESS THAN THE ? C           NUMBER OF OBSERVATIONS USED IN EACH CLASS INTERVAL.  C H C     .................................................................. C =       SUBROUTINE TAB2(A,S,NOV,UBO,FREQ,PCT,STAT1,STAT2,NO,NV) B       DIMENSION A(1),S(1),NOV(2),UBO(3,2),FREQ(1),PCT(1),STAT1(1),      1STAT2(2),SINT(2)       DIMENSION WBO(3,2)       DO 5 I=1,3       DO 5 J=1,2     5 WBO(I,J)=UBO(I,J)  C  C        DETERMINE LIMITS  C        DO 40 I=1,2 &       IF(UBO(1,I)-UBO(3,I)) 40, 10, 40    10 VMIN=1.0E37        VMAX=-1.0E37       IJ=NO*(NOV(I)-1)       DO 35 J=1,NO
       IJ=IJ+1        IF(S(J)) 15,35,15     15 IF(A(IJ)-VMIN) 20,25,25     20 VMIN=A(IJ)    25 IF(A(IJ)-VMAX) 35,35,30     30 VMAX=A(IJ)    35 CONTINUE       UBO(1,I)=VMIN        UBO(3,I)=VMAX     40 CONTINUE C   C        CALCULATE INTERVAL SIZE C     45 DO 50 I=1,2 5    50 SINT(I)=ABS((UBO(3,I)-UBO(1,I))/(UBO(2,I)-2.0))  C  C        CLEAR OUTPUT AREAS  C        INT1=UBO(2,1)        INT2=UBO(2,2)        INTT=INT1*INT2       DO 55 I=1,INTT       FREQ(I)=0.0     55 PCT(I)=0.0       INTY=3*INT1        DO 60 I=1,INTY    60 STAT1(I)=0.0       INTZ=3*INT2        DO 65 I=1,INTZ    65 STAT2(I)=0.0 C  C        TEST SUBSET VECTOR  C        SCNT=0.0       INTY=INT1-1        INTX=INT2-1        IJ=NO*(NOV(1)-1)       IJX=NO*(NOV(2)-1)        DO 95 J=1,NO
       IJ=IJ+1        IJX=IJX+1        IF(S(J)) 70,95,70     70 SCNT=SCNT+1.0  C  C        CALCULATE FREQUENCIES C        TEMP1=UBO(1,1)-SINT(1)       DO 75 IY=1,INTY        TEMP1=TEMP1+SINT(1)        IF(A(IJ)-TEMP1) 80,75,75    75 CONTINUE
       IY=INT1     80 IYY=3*(IY-1)+1!       STAT1(IYY)=STAT1(IYY)+A(IJ)        IYY=IYY+1        STAT1(IYY)=STAT1(IYY)+1.0        IYY=IYY+1 '       STAT1(IYY)=STAT1(IYY)+A(IJ)*A(IJ)        TEMP2=UBO(1,2)-SINT(2)       DO 85 IX=1,INTX        TEMP2=TEMP2+SINT(2)        IF(A(IJX)-TEMP2) 90,85,85     85 CONTINUE
       IX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  X                        0 $      RTI020.J                       SC  =  '[STANVICK.SEAS$WORK_294000DB]TAB2.FOR;1                                                                                        H                              iw             =INT2     90 IJF=INT1*(IX-1)+IY       FREQ(IJF)=FREQ(IJF)+1.0        IX=3*(IX-1)+1         STAT2(IX)=STAT2(IX)+A(IJX)
       IX=IX+1        STAT2(IX)=STAT2(IX)+1.0 
       IX=IX+1 '       STAT2(IX)=STAT2(IX)+A(IJX)*A(IJX)     95 CONTINUE       IF (SCNT)98,151,98 C & C        CALCULATE PERCENT FREQUENCIES C     98 DO 100 I=1,INTT    100 PCT(I)=FREQ(I)*100.0/SCNT  C 5 C        CALCULATE TOTALS, MEANS, STANDARD DEVIATIONS  C        IXY=-1       DO 120 I=1,INT1        IXY=IXY+3        ISD=IXY+1        TEMP1=STAT1(IXY)       SUM=STAT1(IXY-1)       IF(TEMP1-1.0) 120,105,110    105 STAT1(ISD)=0.0       GO TO 115 B   110 STAT1(ISD)=SQRT(ABS((STAT1(ISD)-SUM*SUM/TEMP1)/(TEMP1-1.0)))   115 STAT1(IXY)=SUM/TEMP1   120 CONTINUE       IXX=-1       DO 140 I=1,INT2        IXX=IXX+3        ISD=IXX+1        TEMP2=STAT2(IXX)       SUM=STAT2(IXX-1)       IF(TEMP2-1.0) 140,125,130    125 STAT2(ISD)=0.0       GO TO 135 B   130 STAT2(ISD)=SQRT(ABS((STAT2(ISD)-SUM*SUM/TEMP2)/(TEMP2-1.0)))   135 STAT2(IXX)=SUM/TEMP2   140 CONTINUE       DO 150 I=1,3       DO 150 J=1,2   150 UBO(I,J)=WBO(I,J)    151 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                     ) * [STANVICK.SEAS$WORK_294000DB]TABLE1.COM;1 +  , U   .     /     4 =                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7  g$A  8          9          G    H  J                      = $ COPY IN$:TABLE1.FOR,CS.FOR,GAMMA.FOR,LEP.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                              ) * [STANVICK.SEAS$WORK_294000DB]TABLE1.FOR;1 +  , V  .     /     4 E                           - =    0   1    2   3      K  P   W   O     5 -  6  M*A  7  z$A  8          9          G    H  J                      - C	TABLE1.FOR - PROGRAM TO GENERATE TABLES OF:  C  GAMMA	- GAMMA FUNCTION  C  LEP		- LEGENDRE POLYNOMIALS C  CS		- FRESNEL INTEGRALS 	DIMENSION A(10),POLY(11),B(10)  	DATA PI/3.1415926/  C  C	GAMMA FUNCTION 	X=.99 	H=.01 	XOLD=.9	 	TYPE 100 ; 100	FORMAT(/' GAMMA FUNCTION X=1(.01)2, 2(1)34'//'     X'/)  	DO 1 J=1,10
 	XOLD=XOLD+.1  	DO 2 K=1,10 	X=X+H 2	CALL GAMMA(X,A(K),IER) 1	TYPE 101, XOLD,A 101	FORMAT(F8.3/(5X,5E15.8)) 	X=1.  	H=1. 	 	XOLD=-1.  	DO 3 J=1,11
 	XOLD=XOLD+3.  	DO 4 I=1,3  	X=X+H 4	CALL GAMMA(X,A(I),IER) 3	TYPE 101, XOLD,(A(K),K=1,3)  C  C	LEGENDRE POLYNOMIALS	 	TYPE 102 E 102	FORMAT(//' LEGENDRE POLYNOMIALS X=0(0.05)1  N=0(1)10'//'     X'/)  	X=-0.05 	H=0.05  	DO 5 I=1,21 	X=X+H 	CALL LEP(POLY,X,10) 5	TYPE 101, X,POLY C  C	FRESNEL INTEGRALS 	 	TYPE 103 ? 103	FORMAT(//' FRESNEL INTEGRALS U=(PI*X**2)/2  X=0.1(.1)5.0'/)  	PIBY2=PI/2. 	X=0.  	H=0.1	 	XOLD=-.9  	DO 6 I=1,5 
 	XOLD=XOLD+1.  	DO 7 J=1,10 	X=X+H
 	U=PIBY2*X**2  7	CALL CS(A(J),B(J),U) 	TYPE 104, XOLD,A % 104	FORMAT(F8.3,'   C(X)'/(5X5E15.8))  6	TYPE 105, XOLD,B% 105	FORMAT(F8.3,'   S(X)'/(5X5E15.8))  	STOP 'TABLE1 successful!' 	END                                                                                                                                                                                                                                                                                                                                                                                              ) * [STANVICK.SEAS$WORK_294000DB]TABLE2.COM;1 +  , V  .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 @  7 @$A  8          9          G    H  J                      H $ COPY IN$:TABLE2.FOR,BESI.FOR,BESJ.FOR,BESK.FOR,BESY.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                    ) * [STANVICK.SEAS$WORK_294000DB]TABLE2.FOR;1 +  , 	W   .     /     4 A                          - =    0   1    2   3      K  P   W   O     5 -  6 *A  7  $A  8          9          G    H  J                      ) C	TABLE2.FTN - MATHEMATICAL TABLES USING:  C  BESJ		- J BESSEL FUNCTION C  BESY		- Y BESSEL FUNCTION C  BESI		- I BESSEL FUNCTION C  BESK		- K BESSEL FUNCTION C  C	RANGE  N=0(1)10  X=0(1)20  C . 	DIMENSION BJ(11),BY(11),BI(11),BK(11),IM1(11)& 	DIMENSION IJ(11),IY(11),II(11),IK(11) C  C	INITIALIZE ARRAY FOR OUTPUT  	DO 1 I=1,11 1	IM1(I)=I-1 C  	X=-1. 	DX=1.	 	TYPE 100 4 100	FORMAT(/' BESSEL FUNCTIONS N=0(1)10  X=0(1)20'//A 	1'   X   N'4X'BESJ'7X'IER'3X'BESY'7X'IER'3X'BESI'7X'IER'3X'BESK'  	27X'IER'//) 	DO 2 I=1,21 	X=X+DX  	DO 3 J=1,11 	JM1=J-1# 	CALL BESJ(X,JM1,BJ(J),1.E-5,IJ(J))  	CALL BESY(X,JM1,BY(J),IY(J))  	CALL BESI(X,JM1,BI(J),II(J))  3	CALL BESK(X,JM1,BK(J),IK(J)): 2	TYPE 101, X,(IM1(K),BJ(K),IJ(K),BY(K),IY(K),BI(K),II(K), 	1BK(K),IK(K),K=1,11) > 101	FORMAT(F5.1/(5X,I3,1X,E12.5,I4,1X,E12.5,I4,1X,E12.5,I4,1X, 	1E12.5,I4)) 	STOP 'TABLE2 successful!' 	END                                                                                                                                          ) * [STANVICK.SEAS$WORK_294000DB]TABLE3.COM;1 +  , "W   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 .g@  7 `$A  8          9          G    H  J                      H $ COPY IN$:TABLE3.FOR,CEL1.FOR,CEL2.FOR,EXPI.FOR,SICI.FOR TMP$:TMPSSP.11- $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                    ) * [STANVICK.SEAS$WORK_294000DB]TABLE3.FOR;1 +  , ]W   .     /     4 E                           - =    0   1    2   3      K  P   W   O     5 -  6 +A  7 $A  8          9          G    H  J                      ) C	TABLE3.FTN - MATHEMATICAL TABLES USING: * C  CEL1		- ELIPTIC INTEGRALS OF FIRST KIND+ C  CEL2		- ELIPTIC INTEGRALS OF SECOND KIND  C  EXPI		- EXPONENTIAL INTEGRAL $ C  SICI		- SINE AND COSINE INTEGRALS C  	DIMENSION V(10),VK(9),W(10) C  C  CEL1  	X=0.00  	H=0.01  	XOLD=-0.08 	 	TYPE 100 0 100	FORMAT(/' ELLIPTIC INTEGRAL OF FIRST KIND:'/) 	1'  K=SQRT(M)  M=.01(.01).99'//'    X'/)  	DO 1 I=1,11 	XOLD=XOLD+.09 	DO 2 J=1,9  	X=X+H 	XK=SQRT(X)  2	CALL CEL1(VK(J),XK,IER)  1	TYPE 101, XOLD,VK  101	FORMAT(F6.2/(5X5E15.7))  C  C  CEL2 	 	TYPE 102 2 102	FORMAT(//' ELLIPTIC INTEGRAL OF SECOND KIND:'/< 	1' CASE 1:  A = B = 1, K=SQRT(M)  M=.01(.01).99'//'    X'/) 	X=0.0 	H=0.01  	XOLD=-0.08  	DO 3 I=1,11 	XOLD=XOLD+.09 	DO 4 J=1,9  	X=X+H 	XK=SQRT(X)  4	CALL CEL2(VK(J),XK,1.,1.,IER)  3	TYPE 101, XOLD,VK 	 	TYPE 103 ? 103	FORMAT(/' CASE 2:  A=1, B=1-K**2, K=SQRT(M)  M=.01(.01).99' 
 	1//'    X'/)  	X=0.0 	H=0.01  	XOLD=-0.08  	DO 5 I=1,11 	XOLD=XOLD+.09 	DO 6 J=1,9  	X=X+H 	XK=SQRT(X)  	B=1.-X  6	CALL CEL2(VK(J),XK,1.,B,IER) 5	TYPE 101, XOLD,VK  C  C  SICI 	 	TYPE 104 E 104	FORMAT(//' SINE AND COSINE INTEGRALS:  X=0.1(0.1)10.0'//'    X'/)  	X=0.0 	H=0.1	 	XOLD=-.9  	DO 7 I=1,10
 	XOLD=XOLD+1.  	DO 8 J=1,10 	X=X+H 8	CALL SICI(V(J),W(J),X) 	TYPE 105, XOLD,V , 105	FORMAT(/F8.3,5X,'SI(X)-PI/2'/(5X5E15.7)) 7	TYPE 106, XOLD,W' 106	FORMAT(/F8.3,5X,'CI(X)'/(5X5E15.7))  C  C  EXPI 	 	TYPE 107 > 107	FORMAT(//' EXPONENTIAL INTEGRAL:  X=-10.(.2)6.'//'    X'/) 	X=-10.2 	H=0.2
 	XOL                                                    Y                         $      RTI020.J                       ]W  =  )[STANVICK.SEAS$WORK_294000DB]TABLE3.FOR;1                                                                                      E                              z             D=-11. 	DO 9 I=1,16
 	XOLD=XOLD+1.  	DO 10 J=1,5 	X=X+H 	IF (ABS(X).LT.1.E-4)  X=0.E0  10	CALL EXPI(X,V(J),AUX) 9	TYPE 101, XOLD,(V(K),K=1,5)  	STOP 'TABLE3 successful!' 	END                                                                                                                                                                                                                                                                                                                                                        ( * [STANVICK.SEAS$WORK_294000DB]TALLY.FOR;1 +  , {W   . 	    /     4 H   	                        - =    0   1    2   3      K  P   W   O     5 -  6 ,A  7  $A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE TALLY  C  C        PURPOSEG C           CALCULATE TOTAL, MEAN, STANDARD DEVIATION, MINIMUM, MAXIMUM D C           FOR EACH VARIABLE IN A SET (OR A SUBSET) OF OBSERVATIONS C  C        USAGE= C           CALL TALLY(A,S,TOTAL,AVER,SD,VMIN,VMAX,NO,NV,IER)  C " C        DESCRIPTION OF PARAMETERS0 C           A     - OBSERVATION MATRIX, NO BY NVC C           S     - INPUT VECTOR INDICATING SUBSET OF A. ONLY THOSE E C                   OBSERVATIONS WITH A NON-ZERO S(J) ARE CONSIDERED. ( C                   VECTOR LENGTH IS NO.D C           TOTAL - OUTPUT VECTOR OF TOTALS OF EACH VARIABLE. VECTOR! C                   LENGTH IS NV. F C           AVER  - OUTPUT VECTOR OF AVERAGES OF EACH VARIABLE. VECTOR! C                   LENGTH IS NV. @ C           SD    - OUTPUT VECTOR OF STANDARD DEVIATIONS OF EACH2 C                   VARIABLE. VECTOR LENGTH IS NV.D C           VMIN  - OUTPUT VECTOR OF MINIMA OF EACH VARIABLE. VECTOR! C                   LENGTH IS NV. D C           VMAX  - OUTPUT VECTOR OF MAXIMA OF EACH VARIABLE. VECTOR! C                   LENGTH IS NV. * C           NO    - NUMBER OF OBSERVATIONS< C           NV    - NUMBER OF VARIABLES FOR EACH OBSERVATION& C           IER   - ZERO, IF NO ERROR.E C                 - 1,IF S IS NULL. VMIN=1.E37,VMAX=-1.E37.,SD=AVER=0 E C                 - 2, IF S HAS ONLY ONE NON-ZERO ELEMENT. VMIN=VMAX.  C                   SD=0.0 C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD E C           ALL OBSERVATIONS CORRESPONDING TO A NON-ZERO ELEMENT IN S > C           VECTOR ARE ANALYZED FOR EACH VARIABLE IN MATRIX A.E C           TOTALS ARE ACCUMULATED AND MINIMUM AND MAXIMUM VALUES ARE D C           FOUND. FOLLOWING THIS, MEANS AND STANDARD DEVIATIONS AREG C           CALCULATED.  THE DIVISOR FOR STANDARD DEVIATION IS ONE LESS 1 C           THAN THE NUMBER OF OBSERVATIONS USED.  C H C     .................................................................. C =       SUBROUTINE TALLY(A,S,TOTAL,AVER,SD,VMIN,VMAX,NO,NV,IER) @       DIMENSION A(1),S(1),TOTAL(1),AVER(1),SD(1),VMIN(1),VMAX(1) C 6 C        CLEAR OUTPUT VECTORS AND INITIALIZE VMIN,VMAX C        IER=0        DO 1 K=1,NV        TOTAL(K)=0.0       AVER(K)=0.0        SD(K)=0.0        VMIN(K)=1.0E37     1 VMAX(K)=-1.0E37  C  C        TEST SUBSET VECTOR  C        SCNT=0.0       DO 7 J=1,NO 
       IJ=J-NO        IF(S(J)) 2,7,2     2 SCNT=SCNT+1.0  C ( C        CALCULATE TOTAL, MINIMA, MAXIMA C        DO 6 I=1,NV        IJ=IJ+NO 	X=A(IJ)       TOTAL(I)=TOTAL(I)+X        IF(X-VMIN(I)) 3,4,4      3 VMIN(I)=X      4 IF(X-VMAX(I)) 6,6,5      5 VMAX(I)=X      6 SD(I)=SD(I)+X*X      7 CONTINUE C 0 C        CALCULATE MEANS AND STANDARD DEVIATIONS C        IF (SCNT)8,8,9     8 IER=1        GO TO 15     9 DO 10 I=1,NV    10 AVER(I)=TOTAL(I)/SCNT        IF (SCNT-1.0) 13,11,13    11 IER=2        DO 12 I=1,NV    12 SD(I)=0.0        GO TO 15    13 DO 14 I=1,NV@    14 SD(I)=SQRT(ABS((SD(I)-TOTAL(I)*TOTAL(I)/SCNT)/(SCNT-1.0)))    15 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                 & * [STANVICK.SEAS$WORK_294000DB]TIE.FOR;1 +  , W   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6 \-A  7 $A  8          9          G    H  J                          C H C     .................................................................. C  C        SUBROUTINE TIE  C  C        PURPOSE3 C           CALCULATE CORRECTION FACTOR DUE TO TIES  C  C        USAGE C           CALL TIE(R,N,KT,T) C " C        DESCRIPTION OF PARAMETERSD C           R  - INPUT VECTOR OF RANKS OF LENGTH N CONTAINING VALUES C                1 TO N ( C           N  - NUMBER OF RANKED VALUES@ C           KT - INPUT CODE FOR CALCULATION OF CORRECTION FACTOR+ C                      1   SOLVE EQUATION 1 + C                      2   SOLVE EQUATION 2 + C           T  - CORRECTION FACTOR (OUTPUT) 4 C                    EQUATION 1   T=SUM(CT**3-CT)/124 C                    EQUATION 2   T=SUM(CT*(CT-1)/2)D C                  WHERE CT IS THE NUMBER OF OBSERVATIONS TIED FOR A# C                        GIVEN RANK  C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD F C           VECTOR IS SEARCHED FOR SUCCESSIVELY LARGER RANKS. TIES ARE8 C           COUNTED AND CORRECTION FACTOR 1 OR 2 SUMMED. C H C     .................................................................. C        SUBROUTINE TIE(R,N,KT,T)       DIMENSION R(1) C  C        INITIALIZATION  C        T=0.0        Y=0.0      5 X=1.0E38       IND=0  C  C        FIND NEXT LARGEST RANK  C        DO 30 I=1,N        IF(R(I)-Y) 30,30,10     10 IF(R(I)-X) 20,30,30     20 X=R(I)       IND=IND+1     30 CONTINUE C . C        IF ALL RANKS HAVE BEEN TESTED, RETURN C        IF(IND) 90,90,40	    40 Y=X        CT=0.0 C  C        COUNT TIES  C        DO 60 I=1,N        IF(R(I)-X) 60,50,60     50 CT=CT+1.0     60 CONTINUE C $ C        CALCULATE CORRECTION FACTOR C        IF(CT) 70,5,70    70 IF(KT-1) 75,80,75     75 T=T+CT*(CT-1.)/2.0
       GO TO 5     80 T=T+(CT*CT*CT-CT)/12.0
       GO TO 5     90 RETURN	       END                                                                                                                                           ) * [STANVICK.SEAS$WORK_294000DB]TIMSER.COM;1 +  , W   .     /     4 I                          - =    0   1    2   3      K  P   W   O     5 -  6 E@  7 |$A  8          9          G    H  J                      I $ COPY IN$:TIMSER.FOR,AUTO.FOR,CROSS.FOR,SMO.FOR,GAUSS.FOR TMP$:TMPSSP.11 - $ FORTRAN/OBJECT=TMP$:TMPSSP.1 TMP$:TMPSSP.11 - $ LINK/EXECUTABLE=TMP$:TMPSSP.2 TMP$:TMPSSP.1  $ RUN TMP$:TMPSSP.2  $ DELETE TMP$:TMPSSP.*;*                                                                                                                                                                                                                                                                                                                  ) * [STANVICK.SEAS$WORK_294000DB]TIMSER.FOR;1 +  , W   .     /     4 <                          - =    0   1    2   3      K  P   W   O     5 -  6 q.A  7 R'$A  8          9          G    H  J                      6 C	TIMSER.FTN	- SAMPLE PROGRAM (TIME SERIES STATISTICS) C  AUTO		- AUTOCOVARIANCE  C  CROSS	- CROSSCOVARIANCE C  SMO		- SMOOTHED SERIES  C    ALSO USE GAUSS  C < 	DIMENSION A(51),B(51),W(6),R(51),RL(6),IN(6),SL(6),ISEED(2)$ 	DATA ISEED/13107,0/,IN/0,1,2,3,4,5/ C  C " C	GENERATE DATA FOR AUTO AND CROSS 	DO 1 I=1,51 	CALL GAUSS(ISEED,1.92,9.7,RV) 	A(I)=RV	 1	B(I)=RV  	TYPE 100, (A(J),J=1,50)< 100	FORMAT(//' 50 OBSERVATIONS OF NORMAL DATA'/'   MEAN=9.7, 	1 SIGMA=1.92'//(10F8.2))  	CALL AUTO(A,50,6,W) 	CALL CROSS(A,B,50,6,RL,SL) ) 	TYPE 101, (IN(I),W(I),RL(I),SL(I),I=1,6) * 101	FORMAT(//' RESULTS OF AUTO AND CROSS'/3 	1'   (FOR CROSS - ARRAY USED TWICE)'//'   LAG',6X, / 	2'   AUTO: A'6X'CROSS: B LAGS A'5X'A LAGS B'// # 	3(I5,5X,F10.2,11X,F10.2,3X,F10.2))  C  C	SMO 1 C	GENERATE APPROXIMATION TO F(X)=X**2 X=0(0.2)10.  	X=-0.02 	DX=0.02 	DO 2 I=1,51 	X=X+DX 
 	B(I)=X**2  2	A(I)= ( A(I)-9.7) / 40. + X**2 C ! C	WEIGHTS 1/9, 3/9, 1/9, 3/9, 1/9  	WNINE = 1./9. 	WTHRE=1./3. 	W(1)=WNINE  	W(3)=WN`                                                                                                                   Z                        :1 $      RTI020.J                       W  =  )[STANVICK.SEAS$WORK_294000DB]TIMSER.FOR;1                                                                                      <                                           INE  	W(5)=WNINE  	W(2)=WTHRE  	W(4)=WTHRE  	CALL SMO(A,51,W,5,1,R) 	 	TYPE 102 8 102	FORMAT(///' RESULT FROM SMO:  F(X)=X**2'/' WEIGHTS: 5 	1 (1,3,1,3,1)/9'/ 4X'X'11X'F(X)'7X'RAW'5X'SMOOTH'//)  	X=-0.02 	DO 3 I=1,2  	X=X+DX  3	TYPE 103, X,B(I),A(I)  103	FORMAT(F7.2,3X,3F10.3) 	DO 4 I=3,49 	X=X+DX  4	TYPE 103, X,B(I),A(I),R(I)
 	DO 5 I=50,51  	X=X+DX  5	TYPE 103, X,B(I),A(I)  	STOP 'TIMSER successful!' 	END                                                                                                    ' * [STANVICK.SEAS$WORK_294000DB]TPRD.FOR;1 +  , W   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 `WN/A  7 @9$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE TPRD C  C        PURPOSEB C           TRANSPOSE A MATRIX AND POSTMULTIPLY BY ANOTHER TO FORM C           A RESULTANT MATRIX C  C        USAGE* C           CALL TPRD(A,B,R,N,M,MSA,MSB,L) C " C        DESCRIPTION OF PARAMETERS* C           A - NAME OF FIRST INPUT MATRIX+ C           B - NAME OF SECOND INPUT MATRIX % C           R - NAME OF OUTPUT MATRIX ) C           N - NUMBER OF ROWS IN A AND B 4 C           M - NUMBER OF COLUMNS IN A AND ROWS IN R? C           MSA - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL 1 C           MSB - SAME AS MSA EXCEPT FOR MATRIX B , C           L - NUMBER OF COLUMNS IN B AND R C  C        REMARKSF C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRICES A OR B C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD F C           MATRIX TRANSPOSE OF A IS NOT ACTUALLY CALCULATED. INSTEAD,A C           ELEMENTS IN MATRIX A ARE TAKEN COLUMNWISE RATHER THAN 3 C           ROWWISE FOR MULTIPLICATION BY MATRIX B. D C           THE FOLLOWING TABLE SHOWS THE STORAGE MODE OF THE OUTPUT9 C           MATRIX FOR ALL COMBINATIONS OF INPUT MATRICES = C                         A                B                R @ C                      GENERAL          GENERAL          GENERAL@ C                      GENERAL          SYMMETRIC        GENERAL@ C                      GENERAL          DIAGONAL         GENERAL@ C                      SYMMETRIC        GENERAL          GENERAL@ C                      SYMMETRIC        SYMMETRIC        GENERAL@ C                      SYMMETRIC        DIAGONAL         GENERAL@ C                      DIAGONAL         GENERAL          GENERAL@ C                      DIAGONAL         SYMMETRIC        GENERALA C                      DIAGONAL         DIAGONAL         DIAGONAL  C H C     .................................................................. C *       SUBROUTINE TPRD(A,B,R,N,M,MSA,MSB,L)       DIMENSION A(1),B(1),R(1) C . C        SPECIAL CASE FOR DIAGONAL BY DIAGONAL C        MS=MSA*10+MSB        IF(MS-22) 30,10,30    10 DO 20 I=1,N     20 R(I)=A(I)*B(I)       RETURN C % C        MULTIPLY TRANSPOSE OF A BY B  C 
    30 IR=1       DO 90 K=1,L        DO 90 J=1,M        R(IR)=0.0        DO 80 I=1,N        IF(MS) 40,60,40     40 CALL LOC(I,J,IA,N,M,MSA)       CALL LOC(I,K,IB,N,L,MSB)       IF(IA) 50,80,50     50 IF(IB) 70,80,70     60 IA=N*(J-1)+I       IB=N*(K-1)+I    70 R(IR)=R(IR)+A(IA)*B(IB)     80 CONTINUE
    90 IR=IR+1        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                         ( * [STANVICK.SEAS$WORK_294000DB]TRACE.FOR;1 +  , W	   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6  '0A  7 K$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE TRACE  C  C        PURPOSEE C           COMPUTE CUMULATIVE PERCENTAGE OF EIGENVALUES GREATER THAN D C           OR EQUAL TO A CONSTANT SPECIFIED BY THE USER.  THIS SUB-B C           ROUTINE NORMALLY OCCURS IN A SEQUENCE OF CALLS TO SUB-E C           ROUTINES CORRE, EIGEN, TRACE, LOAD, AND VARMX IN THE PER- * C           FORMANCE OF A FACTOR ANALYSIS. C  C        USAGE$ C           CALL TRACE (M,R,CON,K,D) C " C        DESCRIPTION OF PARAMETERS( C           M     - NUMBER OF VARIABLES.D C           R     - INPUT MATRIX (SYMMETRIC AND STORED IN COMPRESSEDD C                   FORM WITH ONLY UPPER TRIANGLE BY COLUMN IN CORE)H C                   CONTAINING EIGENVALUES IN DIAGONAL.  EIGENVALUES AREH C                   ARRANGED IN DESCENDING ORDER.  THE ORDER OF MATRIX RG C                   IS M BY M.  ONLY M*(M+1)/2 ELEMENTS ARE IN STORAGE. ' C                   (STORAGE MODE OF 1) E C           CON   - A CONSTANT USED TO DECIDE HOW MANY EIGENVALUES TO A C                   RETAIN.  CUMULATIVE PERCENTAGE OF EIGENVALUES D C                   WHICH ARE GREATER THAN OR EQUAL TO THIS VALUE IS C                   CALCULATED. H C           K     - OUTPUT VARIABLE CONTAINING THE NUMBER OF EIGENVALUESF C                   GREATER THAN OR EQUAL TO CON.  (K IS THE NUMBER OF C                   FACTORS.) C C           D     - OUTPUT VECTOR OF LENGTH M CONTAINING CUMULATIVE D C                   PERCENTAGE OF EIGENVALUES WHICH ARE GREATER THAN$ C                   OR EQUAL TO CON. C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD H C           EACH EIGENVALUE GREATER THAN OR EQUAL TO CON IS DIVIDED BY MC C           AND THE RESULT IS ADDED TO THE PREVIOUS TOTAL TO OBTAIN : C           THE CUMULATIVE PERCENTAGE FOR EACH EIGENVALUE. C H C     .................................................................. C $       SUBROUTINE TRACE (M,R,CON,K,D)       DIMENSION R(1),D(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION! C        STATEMENT WHICH FOLLOWS.  C  C     DOUBLE PRECISION R,D C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C H C        ............................................................... C 
       FM=M	       L=0        DO 100 I=1,M       L=L+I    100 D(I)=R(L) 	       K=0  C - C     TEST WHETHER I-TH EIGENVALUE IS GREATER # C     THAN OR EQUAL TO THE CONSTANT  C        DO 110 I=1,M        IF(D(I)-CON) 120, 105, 105   105 K=K+1    110 D(I)=D(I)/FM C 2 C     COMPUTE CUMULATIVE PERCENTAGE OF EIGENVALUES C    120 DO 130 I=2,K   130 D(I)=D(I)+D(I-1)       RETURN	       END                                                               ( * [STANVICK.SEAS$WORK_294000DB]TTSTT.FOR;1 +  , W   . 	    /     4 H   	                         - =    0   1    2   3      K  P   W   O 	    5 -  6 71A  7 @A^$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE TTSTT  C  C        PURPOSEE C           TO FIND CERTAIN T-STATISTICS ON THE MEANS OF POPULATIONS.  C  C        USAGE. C           CALL TTSTT (A,NA,B,NB,NOP,NDF,ANS) C " C        DESCRIPTION OF PARAMETERS< C           A   - INPUT VECTOR OF LENGTH NA CONTAINING DATA.. C           NA  - NUMBER OF OBSERVATIONS IN A.< C           B   - INPUT VECTOR OF LENGTH NB CONTAINING DATA.. C           NB  - NUMBER OF OBSERVATIONS IN B.2 C           NOP - OPTIONS FOR VARIOUS HYPOTHESES..E C                 NOP=1--- THAT POPULATION MEAN OF B = GIVEN VALUE A. % C                          (SET NA=1) F C                 NOP=2--- THAT POPULATION MEAN OF B = POPULATION MEANC C                          OF A, GIVEN THAT THE VARIANCE OF B = THE ) C                          VARIANCE OF A. F C                 NOP=3--- THAT POPULATION MEAN OF B = POPULATION MEAND C                          OF A, GIVEN THAT THE VARIANCE OF B IS NOT                                                                                                                                                                                                                                                                                                                                                                                                                  [                        m $      RTI020.J                       W  =  ([STANVICK.SEAS$WORK_294000DB]TTSTT.FOR;1                                                                                       H     	                                      6 C                          EQUAL TO THE VARIANCE OF A.F C                 NOP=4--- THAT POPULATION MEAN OF B = POPULATION MEANH C                          OF A, GIVEN NO INFORMATION ABOUT VARIANCES OF0 C                          A AND B.  (SET NA=NB)G C           NDF - OUTPUT VARIABLE CONTAINING DEGREES OF FREEDOM ASSOCI- 3 C                 ATED WITH T-STATISTIC CALCULATED. 3 C           ANS - T-STATISTIC FOR GIVEN HYPOTHESIS.  C  C        REMARKSA C           NA AND NB MUST BE GREATER THAN 1, EXCEPT THAT NA=1 IN = C           OPTION 1. NA AND NB MUST BE THE SAME IN OPTION 4. E C           IF NOP IS OTHER THAN 1, 2, 3 OR 4, DEGREES OF FREEDOM AND D C           T-STATISTIC WILL NOT BE CALCULATED.  NDF AND ANS WILL BE C           SET TO ZERO. C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD C C           REFER TO OSTLE, BERNARD, 'STATISTICS IN RESEARCH', IOWA 1 C           STATE COLLEGE PRESS, 1954, CHAPTER 5.  C H C     .................................................................. C .       SUBROUTINE TTSTT (A,NA,B,NB,NOP,NDF,ANS)       DIMENSION A(1),B(1)  C  C     INITIALIZATION C        NDF=0 
       ANS=0.0  C  C     CALCULATE THE MEAN OF A  C        AMEAN=0.0        DO 110 I=1,NA    110 AMEAN=AMEAN+A(I)       FNA=NA       AMEAN=AMEAN/FNA  C  C     CALCULATE THE MEAN OF B  C    115 BMEAN=0.0        DO 120 I=1,NB    120 BMEAN=BMEAN+B(I)       FNB=NB       BMEAN=BMEAN/FNB  C        IF(NOP-4) 122, 180, 200    122 IF(NOP-1) 200, 135, 125  C ! C     CALCULATE THE VARIANCE OF A  C 
   125 SA2=0.0        DO 130 I=1,NA    130 SA2=SA2+(A(I)-AMEAN)**2        SA2=SA2/(FNA-1.0)  C ! C     CALCULATE THE VARIANCE OF B  C 
   135 SB2=0.0        DO 140 I=1,NB    140 SB2=SB2+(B(I)-BMEAN)**2        SB2=SB2/(FNB-1.0)  C        GO TO (150,160,170), NOP C  C        OPTION 1  C -   150 ANS=((BMEAN-AMEAN)/SQRT(SB2))*SQRT(FNB)        NDF=NB-1       GO TO 200  C  C        OPTION 2  C    160 NDF=NA+NB-2        FNDF=NDF0       S=SQRT(((FNA-1.0)*SA2+(FNB-1.0)*SB2)/FNDF)7       ANS=((BMEAN-AMEAN)/S)*(1.0/SQRT(1.0/FNA+1.0/FNB))        GO TO 200  C  C        OPTION 3  C -   170 ANS=(BMEAN-AMEAN)/SQRT(SA2/FNA+SB2/FNB)        A1=(SA2/FNA+SB2/FNB)**2 6       A2=(SA2/FNA)**2/(FNA+1.0)+(SB2/FNB)**2/(FNB+1.0)       NDF=A1/A2-2.0+0.5        GO TO 200  C  C        OPTION 4  C    180 SD=0.0       D=BMEAN-AMEAN        DO 190 I=1,NB    190 SD=SD+(B(I)-A(I)-D)**2       SD=SQRT(SD/(FNB-1.0))        ANS=(D/SD)*SQRT(FNB)       NDF=NB-1 C    200 RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ( * [STANVICK.SEAS$WORK_294000DB]TWOAV.FOR;1 +  , W  .     /     4 H       j                    - =    0   1    2   3      K  P   W   O     5 -  6 @1A  7 p$A  8          9          G    H  J           
             C H C     .................................................................. C  C        SUBROUTINE TWOAV  C  C        PURPOSE> C           TEST WHETHER A NUMBER OF SAMPLES ARE FROM THE SAMEH C           POPULATION BY THE FRIEDMAN TWO-WAY ANALYSIS OF VARIANCE TEST C  C        USAGE+ C           CALL TWOAV(A,R,N,M,W,XR,NDF,NR)  C " C        DESCRIPTION OF PARAMETERS8 C           A   - INPUT MATRIX, N BY M, OF ORIGINAL DATA7 C           R   - OUTPUT MATRIX, N BY M, OF RANKED DATA " C           N   - NUMBER OF GROUPS/ C           M   - NUMBER OF CASES IN EACH GROUP ) C           W   - WORK AREA OF LENGTH 2*M - C           XR  - FRIEDMAN STATISTIC (OUTPUT) 7 C           NDF - NUMBER OF DEGREES OF FREEDOM (OUTPUT) C C           NR  - CODE, 0 FOR UNRANKED DATA IN A, 1 FOR RANKED DATA  C                 IN A (INPUT) C  C        REMARKS C           NONE C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           RANK C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956, C           CHAPTER 7  C H C     .................................................................. C ,       SUBROUTINE TWOAV (A,R,N,M,W,XR,NDF,NR)       DIMENSION A(1),R(1),W(1) C ) C        DETERMINE WHETHER DATA IS RANKED  C        IF(NR-1) 10, 30, 10  C E C        RANK DATA IN EACH GROUP AND ASSIGN TIED OBSERVATIONS AVERAGE  C        OF TIED RANK  C     10 DO 20 I=1,N        IJ=I-N       IK=IJ        DO 15 J=1,M 
       IJ=IJ+N     15 W(J)=A(IJ)       CALL RANK (W,W(M+1),M)       DO 20 J=1,M 
       IK=IK+N        IW=M+J    20 R(IK)=W(IW)        GO TO 35    30 NM=N*M       DO 32 I=1,NM    32 R(I)=A(I)  C 2 C        CALCULATE SUM OF SQUARES OF SUMS OF RANKS C     35 RTSQ=0.0
       IR=0       DO 50 J=1,M        RT=0.0       DO 40 I=1,N 
       IR=IR+1     40 RT=RT+R(IR)     50 RTSQ=RTSQ+RT*RT  C * C        CALCULATE FRIEDMAN TEST VALUE, XR C        FNM=N*(M+1) 
       FM=M%       XR=(12.0/(FM*FNM))*RTSQ-3.0*FNM  C   C        FIND DEGREES OF FREEDOM C 
       NDF=M-1        RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                     ( * [STANVICK.SEAS$WORK_294000DB]UTEST.FOR;1 +  , W
   .     /     4 H                          - =    0   1    2   3      K  P   W   O     5 -  6  22A  7 @$A  8          9          G    H  J           
             C H C     .................................................................. C  C        SUBROUTINE UTEST  C  C        PURPOSEA C           TEST WHETHER TWO INDEPENDENT GROUPS ARE FROM THE SAME 6 C           POPULATION BY MEANS OF MANN-WHITNEY U-TEST C  C        USAGE) C           CALL UTEST(A,R,N1,N2,U,Z,IER)  C " C        DESCRIPTION OF PARAMETERSD C           A  - INPUT VECTOR OF CASES CONSISTING OF TWO INDEPENDENTE C                GROUPS . SMALLER GROUP PRECEDES LARGER GROUP. LENGTH  C                IS N1+N2.D C           R  - OUTPUT VECTOR OF RANKS. SMALLEST VALUE IS RANKED 1,G C                LARGEST IS RANKED N. TIES ARE ASSIGNED AVERAGE OF TIED ( C                RANKS. LENGTH IS N1+N2.1 C           N1 - NUMBER OF CASES IN SMALLER GROUP 0 C           N2 - NUMBER OF CASES IN LARGER GROUP> C           U  - STATISTIC USED TO TEST HOMOGENEITY OF THE TWO  C                GROUPS (OUTPUT)@ C           Z  - MEASURE OF SIGNIFICANCE OF U IN TERMS OF NORMAL& C                DISTRIBUTION (OUTPUT)  C           IER- 0, IF NO ERROR.8 C              - 1, IF ALL VALUES OF ONE GROUP ARE TIED. C  C        REMARKS2 C           Z IS SET TO ZERO IF N2 IS LESS THAN 20 C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           RANK C           TIE  C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956, C           CHAPTER 6  C H C     .................................................................. C %       SUBROUTINE UTEST(A,R,N1,N2,U,Z)        DIMENSION A(1),R(1)  C E C        RANK SCORES FROM BOTH GROUP TOGETHER IN ASCENDING ORDER, AND 7 C        ASSIGN TIED OBSERVATIONS AVERAGE OF TIED RANKS  C 
       N=N1+N2        CALL RANK(A,R,N)       Z=0.0  C " C        SUM RANKS IN LARGER GROUP C        R2=0.0
       NP=N1+1        DO 10 I=NP,N    10 R2=R2+R(I) C  C        CALCULATE U C        FNX=N1*N2 
       FN=N       FN2=N2#       UP=FNX+FN2*((FN2+1.0)/2.0)-R2        U=FNX-UP       IF(UP-U) 20,30,30 
    20 U=UP C ! C        TEST FOR N2 LESS THAN 20  C     30 IF(N2-20) 80,40,40 C # C        COMPUTE STANDARD DEVIATION  C 
    40 KT=1       CALL TIE(R,N,KT,TS)        IF(TS) 50,60,50 &    50 IF (TS-(FN*FN*FN-FN)/12)52,51,52    51 IER=1        GO TO 80;    52 S=SQRT((FNX/(FN*(FN-1.0)))*(((FN*FN*FN-FN)/12.0)-TS))        GO TO 70    60 S=SQRT(FNX*(FN+1.0)/12.0)  C  C        COMPUTE Z C     70 Z=(U-FNX*0.5)/S     80 RETURN	       END                                                                                                                                                                                                                      \                        ʋ $      RTI020.J                       W  =  ([STANVICK.SEAS$WORK_294000DB]VARMX.FOR;1                                                                                       H                              j              ( * [STANVICK.SEAS$WORK_294000DB]VARMX.FOR;1 +  , W   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 @3A  7 /$A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE VARMX  C  C        PURPOSEB C           PERFORM ORTHOGONAL ROTATIONS OF A FACTOR MATRIX.  THISE C           SUBROUTINE NORMALLY OCCURS IN A SEQUENCE OF CALLS TO SUB- H C           ROUTINES CORRE, EIGEN, TRACE, LOAD, VARMX IN THE PERFORMANCE! C           OF A FACTOR ANALYSIS.  C  C        USAGE. C           CALL VARMX (M,K,A,NC,TV,H,F,D,IER) C " C        DESCRIPTION OF PARAMETERSG C           M     - NUMBER OF VARIABLES AND NUMBER OF ROWS OF MATRIX A. & C           K     - NUMBER OF FACTORS.F C           A     - INPUT IS THE ORIGINAL FACTOR MATRIX, AND OUTPUT ISE C                   THE ROTATED FACTOR MATRIX.  THE ORDER OF MATRIX A  C                   IS M X K. F C           NC    - OUTPUT VARIABLE CONTAINING THE NUMBER OF ITERATION% C                   CYCLES PERFORMED. G C           TV    - OUTPUT VECTOR CONTAINING THE VARIANCE OF THE FACTOR H C                   MATRIX FOR EACH ITERATION CYCLE.  THE VARIANCE PRIORD C                   TO THE FIRST ITERATION CYCLE IS ALSO CALCULATED.G C                   THIS MEANS THAT NC+1 VARIANCES ARE STORED IN VECTOR F C                   TV.  MAXIMUM NUMBER OF ITERATION CYCLES ALLOWED IND C                   THIS SUBROUTINE IS 50.  THEREFORE, THE LENGTH OF$ C                   VECTOR TV IS 51.E C           H     - OUTPUT VECTOR OF LENGTH M CONTAINING THE ORIGINAL " C                   COMMUNALITIES.B C           F     - OUTPUT VECTOR OF LENGTH M CONTAINING THE FINAL" C                   COMMUNALITIES.H C           D     - OUTPUT VECTOR OF LENGTH M CONTAINING THE DIFFERENCESA C                   BETWEEN THE ORIGINAL AND FINAL COMMUNALITIES. # C           IER   - ERROR INDICATOR $ C                   IER=0 - NO ERRORE C                   IER=1 - CONVERGENCE WAS NOT ACHIEVED IN 50 CYCLES ' C                           OF ROTATION  C  C        REMARKSD C           IF VARIANCE COMPUTED AFTER EACH ITERATION CYCLE DOES NOTD C           INCREASE FOR FOUR SUCCESSIVE TIMES, THE SUBROUTINE STOPS C           ROTATION.  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           NONE C  C        METHOD G C           KAISER'S VARIMAX ROTATION AS DESCRIBED IN 'COMPUTER PROGRAM H C           FOR VARIMAX ROTATION IN FACTOR ANALYSIS' BY THE SAME AUTHOR,F C           EDUCATIONAL AND PSYCHOLOGICAL MEASUREMENT, VOL XIX, NO. 3, C           1959.  C H C     .................................................................. C .       SUBROUTINE VARMX (M,K,A,NC,TV,H,F,D,IER))       DIMENSION A(1),TV(1),H(1),F(1),D(1)  C H C        ............................................................... C F C        IF A DOUBLE PRECISION VERSION OF THIS ROUTINE IS DESIRED, THEB C        C IN COLUMN 1 SHOULD BE REMOVED FROM THE DOUBLE PRECISION C D C     DOUBLE PRECISION A,TV,H,F,D,TVLT,CONS,AA,BB,CC,DD,U,T,B,COS4T,H C    1                 SIN4T,TAN4T,SINP,COSP,CTN4T,COS2T,SIN2T,COST,SINT C	2, DABS, DSQRT C D C        THE C MUST ALSO BE REMOVED FROM DOUBLE PRECISION STATEMENTSB C        APPEARING IN OTHER ROUTINES USED IN CONJUNCTION WITH THIS C        ROUTINE.  C B C        THE DOUBLE PRECISION VERSION OF THIS SUBROUTINE MUST ALSOH C        CONTAIN DOUBLE PRECISION FORTRAN FUNCTIONS.  SQRT IN STATEMENTSF C        115, 290, 330, 350, AND 355 MUST BE CHANGED TO DSQRT.  ABS IN> C        STATEMENTS 280, 320, AND 375 MUST BE CHANGED TO DABS. C H C        ............................................................... C  C     INITIALIZATION C        IER=0        EPS=0.00116        TVLT=0.0       LL=K-1
       NV=1
       NC=0
       FN=M       FFN=FN*FN        CONS=0.7071066 C & C     CALCULATE ORIGINAL COMMUNALITIES C        DO 110 I=1,M       H(I)=0.0       DO 110 J=1,K       L=M*(J-1)+I    110 H(I)=H(I)+A(L)*A(L)  C ( C     CALCULATE NORMALIZED FACTOR MATRIX C        DO 120 I=1,M   115 H(I)= SQRT(H(I))       DO 120 J=1,K       L=M*(J-1)+I    120 A(L)=A(L)/H(I)       GO TO 132  C * C     CALCULATE VARIANCE FOR FACTOR MATRIX C 
   130 NV=NV+1        TVLT=TV(NV-1)    132 TV(NV)=0.0       DO 150 J=1,K       AA=0.0       BB=0.0       LB=M*(J-1)       DO 140 I=1,M       L=LB+I       CC=A(L)*A(L)       AA=AA+CC   140 BB=BB+CC*CC %   150 TV(NV)=TV(NV)+(FN*BB-AA*AA)/FFN        IF(NV-51)160,155,155   155 IER=1        GO TO 430  C  C     PERFORM CONVERGENCE TEST C -   160 IF((TV(NV)-TVLT)-(1.E-7)) 170, 170, 190 
   170 NC=NC+1        IF(NC-3) 190, 190, 430 C - C     ROTATION OF TWO FACTORS CONTINUES UP TO  C     THE STATEMENT 120. C    190 DO 420 J=1,LL        L1=M*(J-1)       II=J+1 C  C        CALCULATE NUM AND DEN C        DO 420 K1=II,K       L2=M*(K1-1)        AA=0.0       BB=0.0       CC=0.0       DD=0.0       DO 230 I=1,M
       L3=L1+I 
       L4=L2+I #       U=(A(L3)+A(L4))*(A(L3)-A(L4))        T=A(L3)*A(L4)        T=T+T        CC=CC+(U+T)*(U-T)        DD=DD+2.0*U*T 
       AA=AA+U 
   230 BB=BB+T        T=DD-2.0*AA*BB/FN        B=CC-(AA*AA-BB*BB)/FN  C " C        COMPARISON OF NUM AND DEN C        IF(T-B) 280, 240, 320 !   240 IF((T+B)-EPS) 420, 250, 250  C 2 C        NUM + DEN IS GREATER THAN OR EQUAL TO THE C        TOLERANCE FACTOR  C    250 COS4T=CONS       SIN4T=CONS       GO TO 350  C  C        NUM IS LESS THAN DEN  C    280 TAN4T= ABS(T)/ ABS(B) !       IF(TAN4T-EPS) 300, 290, 290 &   290 COS4T=1.0/ SQRT(1.0+TAN4T*TAN4T)       SIN4T=TAN4T*COS4T        GO TO 350    300 IF(B) 310, 420, 420    310 SINP=CONS        COSP=CONS        GO TO 400  C   C        NUM IS GREATER THAN DEN C    320 CTN4T= ABS(T/B) !       IF(CTN4T-EPS) 340, 330, 330 &   330 SIN4T=1.0/ SQRT(1.0+CTN4T*CTN4T)       COS4T=CTN4T*SIN4T        GO TO 350    340 COS4T=0.0        SIN4T=1.0  C * C        DETERMINE COS THETA AND SIN THETA C "   350 COS2T= SQRT((1.0+COS4T)/2.0)       SIN2T=SIN4T/(2.0*COS2T) !   355 COST= SQRT((1.0+COS2T)/2.0)        SINT=SIN2T/(2.0*COST)  C & C        DETERMINE COS PHI AND SIN PHI C        IF(B) 370, 370, 360    360 COSP=COST        SINP=SINT        GO TO 380    370 COSP=CONS*COST+CONS*SINT$   375 SINP= ABS(CONS*COST-CONS*SINT)   380 IF(T) 390, 390, 400    390 SINP=-SINP C  C        PERFORM ROTATION  C    400 DO 410 I=1,M
       L3=L1+I 
       L4=L2+I        AA=A(L3)*COSP+A(L4)*SINP"       A(L4)=-A(L3)*SINP+A(L4)*COSP   410 A(L3)=AA   420 CONTINUE       GO TO 130  C " C     DENORMALIZE VARIMAX LOADINGS C    430 DO 440 I=1,M       DO 440 J=1,K       L=M*(J-1)+I    440 A(L)=A(L)*H(I) C  C     CHECK ON COMMUNALITIES C 
       NC=NV-1        DO 450 I=1,M   450 H(I)=H(I)*H(I)       DO 470 I=1,M       F(I)=0.0       DO 460 J=1,K       L=M*(J-1)+I    460 F(I)=F(I)+A(L)*A(L)    470 D(I)=H(I)-F(I)       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                         ( * [STANVICK.SEAS$WORK_294000DB]WTEST.FOR;1 +  , W
   .     /     4 H                           - =    0   1    2   3      K  P   W   O     5 -  6 4A  7 $A  8          9          G    H  J                        C H C     .................................................................. C  C        SUBROUTINE WTEST  C  C        PURPOSEE C           TEST DEGREE OF ASSOCIATION AMONG A NUMBER OF VARIABLES BY 2 C           THE KENDALL COEFFICIENT OF CONCORDANCE C  C        USAGE. C           CALL WTEST(A,R,N,M,WA,W,CS,NDF,NR) C " C        DESCRIPTION OF PARAMETERS8 C           A   - INPUT MATRIX, N BY M, OF ORIGINAL DATAF C           R   - OUTPUT MATRIX, N BY M, OF RANKED DATA.SMALLEST VALUEE C                 IS RANKED 1, LARGEST IS RANKED N. TIES ARE ASSIGNED ' C                 AVERAGE OF TIED RANKS % C           N   - NUMBER OF VARIABLES ! C           M   - NUMBER OF CASES 0 C           WA  - WORK AREA VECTOR OF LENGTH 2*M< C           W   - KENDALL COEFFICIENT OF CONCORDANCE(OUTPUT)% C           CS  - CHI-SQUARE (OUTPUT) 7 C           NDF - NUMBER OF DEGREES OF FREEDOM (OUTPUT) C C           NR  - CODE, 0 FOR UNRANKED DATA IN A, 1 FOR RANKED DATA  C                 IN A (INPUT) C  C        REMARKS: C                                                                                                                                                                                                      ]                        S $      RTI020.J                       W
  =  ([STANVICK.SEAS$WORK_294000DB]WTEST.FOR;1                                                                                       H                              [                     CHI-SQUARE IS SET TO ZERO IF M IS 7 OR SMALLER C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           RANK C           TIE  C  C        METHOD E C           DESCRIBED IN S. SIEGEL, 'NONPARAMETRIC STATISTICS FOR THE > C           BEHAVIORAL SCIENCES', MCGRAW-HILL, NEW YORK, 1956, C           CHAPTER 9 H C     .................................................................. C  C /       SUBROUTINE WTEST (A,R,N,M,WA,W,CS,NDF,NR)        DIMENSION A(1),R(1),WA(1)  C 
       FM=M
       FN=N C ) C        DETERMINE WHETHER DATA IS RANKED H C        RANK DATA FOR ALL VARIABLES ASSIGNING TIED OBSERVATIONS AVERAGE= C        OF TIED RANKS AND COMPUTE CORRECTION FOR TIED SCORES  C        T=0.0 
       KT=1       DO 20 I=1,N        IJ=I-N       IK=IJ        IF(NR-1) 5,2,5     2 DO 3 J=1,M
       IJ=IJ+N        K=M+J      3 WA(K)=A(IJ)        GO TO 15     5 DO 10 J=1,M 
       IJ=IJ+N     10 WA(J)=A(IJ)        CALL RANK(WA,WA(M+1),M)     15 CALL TIE(WA(M+1),M,KT,TI)        T=T+TI       DO 20 J=1,M 
       IK=IK+N        IW=M+J    20 R(IK)=WA(IW) C * C        CALCULATE VECTOR OF SUMS OF RANKS C 
       IR=0       DO 40 J=1,M        WA(J)=0.0        DO 40 I=1,N 
       IR=IR+1     40 WA(J)=WA(J)+R(IR)  C & C        COMPUTE MEAN OF SUMS OF RANKS C        SM=0.0       DO 50 J=1,M     50 SM=SM+WA(J)        SM=SM/FM C - C        COMPUTE SUM OF SQUARES OF DEVIATIONS  C        S=0.0        DO 60 J=1,M     60 S=S+(WA(J)-SM)*(WA(J)-SM)  C  C        COMPUTE W C -       W=S/(((FN*FN)*(FM*FM*FM-FM)/12.0)-FN*T)  C A C        COMPUTE DEGREES OF FREEDOM AND CHI-SQUARE IF M IS OVER 7  C        CS=0.0       NDF=0        IF(M-7) 70,70,65    65 CS=FN*(FM-1.0)*W
       NDF=M-1     70 RETURN	       END                                                                                                                                                                                                                                                                                             ' * [STANVICK.SEAS$WORK_294000DB]XCPY.FOR;1 +  , W
   .     /     4 H       ,                   - =    0   1    2   3      K  P   W   O     5 -  6 ş5A  7 `U$A  8          9          G    H  J                         C H C     .................................................................. C  C        SUBROUTINE XCPY C  C        PURPOSE& C           COPY A PORTION OF A MATRIX C  C        USAGE- C           CALL XCPY(A,R,L,K,NR,MR,NA,MA,MS)  C " C        DESCRIPTION OF PARAMETERS% C           A  - NAME OF INPUT MATRIX & C           R  - NAME OF OUTPUT MATRIX? C           L  - ROW OF A WHERE FIRST ELEMENT OF R CAN BE FOUND B C           K  - COLUMN OF A WHERE FIRST ELEMENT OF R CAN BE FOUND3 C           NR - NUMBER OF ROWS TO BE COPIED INTO R 6 C           MR - NUMBER OF COLUMNS TO BE COPIED INTO R$ C           NA - NUMBER OF ROWS IN A' C           MA - NUMBER OF COLUMNS IN A ? C           MS  - ONE DIGIT NUMBER FOR STORAGE MODE OF MATRIX A  C                  0 - GENERAL  C                  1 - SYMMETRIC C                  2 - DIAGONAL  C  C        REMARKS? C           MATRIX R CANNOT BE IN THE SAME LOCATION AS MATRIX A / C           MATRIX R IS ALWAYS A GENERAL MATRIX  C 6 C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED C           LOC  C  C        METHOD E C           MATRIX R IS FORMED BY COPYING A PORTION OF MATRIX A. THIS E C           IS DONE BY EXTRACTING NR ROWS AND MR COLUMNS OF MATRIX A, 4 C           STARTING WITH ELEMENT AT ROW L, COLUMN K C H C     .................................................................. C -       SUBROUTINE XCPY(A,R,L,K,NR,MR,NA,MA,MS)        DIMENSION A(1),R(1)  C  C        INITIALIZE  C 
       IR=0       L2=L+NR-1        K2=K+MR-1  C        DO 5 J=K,K2        DO 5 I=L,L2 
       IR=IR+1        R(IR)=0.0  C 3 C        LOCATE ELEMENT FOR ANY MATRIX STORAGE MODE  C        CALL LOC(I,J,IA,NA,MA,MS)  C 1 C        TEST FOR ZERO ELEMENT IN DIAGONAL MATRIX  C        IF(IA) 4,5,4     4 R(IR)=A(IA)      5 CONTINUE       RETURN	       END                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ^                        oo8 $      RTI020.J                       nw  =  ,[STANVICK.SEAS$WORK_294000DB]UOYDG4IDE.MEM;1                                                                                    ,                             q      :      0:4|1)Jo7Rd?tg/7.13)/!S5:@mm30\wPy{ff;Qt'f1@XMLzo.CXbh<IeGi
jp
T7w;m@g5h>*e'MrAXp;u%e`~bV:m!W00O?
8]-k?X{)mk+/)E
'{a
}]+kVMn-Z]Y5@s_3Ly|@2yK@F2I]H	`DFmG9ueryrMBE9##M4,"j99Os`
1S H)N]k/J:_$g22&pbA]-^Pwe\rIu(O-g/vSw==FcRSk?`wzE:oejs5l|(4{3p p\Wzrg7_FHb
B_KK\m4c
cE:`9v]Kj9B)KknQM/0Y.D9F	j}[ZZYv$}a ca(*B0iImPR*6OCklo.:e[A~mcH)s2*u[L. If!VR-*&vsfjg+8}kC{zi-cTF7C}<{[}R^P"~#I\$J.E@ N)%<h<HRHs=
dBtF+U@~h!3{qjuvdS.$q&AwbnT:o5Z}85}ZS`+VK^vBD	8HH-^}# FfOe6m$t?3"^*Y
l9	.Wo }&$`C%'{2\?w
/LkfC	S5@
=-~;?1X9/l(a7hAo^W#P<:@\yP1?e2;zvwu6)[vq-P¢7b\@:Nꛃ1opw!Q [H2%OZ7+1.M>sr!5VkPW:]pEs_^G-&_t=9% Dq`!3-}C[%^mx+U+SV6g|@^ZG%SYQ /FEkk$P
X*_*O$AsYF?o*f,hG3Ry54OV'
UT~!@bIF(: pdr?olO+z<vHBE35@F=P]jN!|9O%f{wy$kYf%dq$"bicTb{<Yd=WtV7Ye<-:dHYxEv~e3Q(ru#]fkia ]FO>_9Gg8Fft&Q]\>~=^iT ,\oWDXq[/IA2.*gZ~ePmiUl#s\96yY#vt?_biCAhfWD#FHh
1mAIH>.N o<TuZG$Y[1WEov*qL 2
}
|HJJwsS{Lh!jsC5}k2tJ|MBcsF,z< B(3pk"s>F
b~)u7"cC:Nj1bZ{V+&D5Q78Wr~3#l R0ezM#wcXtUX>Gt 3fJmJ e+RK/ CAB`)G"]g:Hi)'unL~"@,Cm&	)"@*#gf0e8pE00>i'Zm}/JD%`|WV7o,c*'iWg6QR+.~+_,JHTo,!j-15{YRWy;G=bqq"&x4.X`Tuv>0t3P YfM
f! f;nA\GQCD6ip%LL#n!}q]4IMa3(4Z*]-fdlh M~o4BC0*m7M V	EA{ +(AjhIWfR\hZSRW(s^cL3,IkM?!|jc'L`
M $==/q*Y#Q<mJ8`)!>ne&I1?=L_o`+WbU5&C3"i6Kei{!nm_(2F*l\(}qc.nnU:L`Y
Ni\^qoKgwYL/&"/wkFA&ZO0N&(=Ix!Yc8L:Z
]<"I:|
:u7)khQg80|ywE~G:E\J]MrFb}d:T"V +Xl?lp9f%lZI_BHn`S.D<y sHF^@-hs<i`q}g-Ou-R{=vkiz/.@v$?k1`%
0"biObL(	AwO:1)>?);=(_ ayq%`c(F%T?+`UZ1=[Yv^
kD"!7o'y\d~r	P Gg`eU6cQ%f@8k\bu&!h$QlyS~JK_Ac#4Is# MtlYJJ qb
F]8{K,#n1P&0#>OJ[<3lSSEXpD'*A.Zi)v51zJU{U-.<F|
nit(4o~+
Gy~<p1-D/qLdV\upf5Vh&G6 H^te;fCbHp3$\_Tt*%`O&!k7Aq,<
t;F;6NHK%YBS	L/'W |Td5u3U,g=OR7D*& zAUT()2	HTqy`R\G|,4lsQIMim:7kTr \;?L	u6f}aur9JM8/~'[Yt @-;#|g
x@mqNjHaZk4J,KF8:-cPVpY)2,=g 9~TPP[}t ,clX TZfEomJk|~v4dk3<wKh/JPn~-@-&O~DaR^)XX<dZx?`,960Hp%K<!PAX"x5vCZLFo@ml	/tzuAUjxZfTy:[n: oNSy^V"aZNCW?$nG3#]Yq6N*Xb:3MDFr5U+P-eA>Sgy\(!.sh\Ku*iUlW3f#{8kBD
ZyLG{7ju/P+)|L5;|)bd? 3iIdX&6{5M*FUgl"$d7)DXYQad8N*&##S-CH05Hnl<*j$_tudm=G[m/
D ZXm*mV)D|;o1 a{ȳ
y(D[H/#7
d[cNX	~zB8@<Wa/-Q97/B)	-t|a]A9/p@.$d8cp$!0n4?FB*c"(m
yDlCH	d92<9(nWP
( `TXX;$C_m<@j**b)MNoo
K$<:H+yxW75$4eM(7Yb}X{|Z:>
At@6m?(,SEv`~jJ7i' $Zt}~7C)6"^OYY>WFi{26VsrFMRY^X#_y43iC`rQ<bu[-@{4KCERhcn5(k7vjO4w;?y2B _UqU1RqXr7g?U{6""H0R 6\-w2UyM#YuGOn&n2W;jw;/
1aNvQssJltg[VH}Z{3SYD5V)tl#&@|IE!(9:6U'2$*j3v;U^TuQP@x^#X7zE\7K;ek$SwxA
$7,o_rP`Vn-6 ^c=K:gS)ET}R@SA 4voQrhf^{<fM:|e @TntLAH9dN5(w o:pP-;_!R%&	hQ;NN2!rm'
Ba=:lYl*j2R3]'R=km`S.$/:y`)-EgMj
r8+t=Hw:7i!yDbe3*.+^>I*,|iFqG\%SwCGtJG84{2:AL%?:wV!!m%/0KG:WxQoQdG#TlDntus7A	<Ky(5BEktg~YG	(^W2
?\2EGb<)1>qѠ
iy`bNMv)&faR]^"D+4F3d2<:ez#T*ieGYM*zwաjEk3tj	5Kqljn#Q);,y~v^#vzL96^4AD.v(hAbjOlF=(}(ZcY<^50#hh}-U'R7QXGd{&_fO&wpV7W&D}GHk9{3Ks.F
e:E"-)"M#-!C6H=Za`|A2
[|MK\3zY;xYf
L='u\l[2 XOW\&/Bc F;DFZ*e3jqV4
mwNZ j/r6}eCGu"Mm[OzKLRA~#?6EQ'B[HBj*lo$_jp 0'UgDY:D<z3fw yuP$m<\oLkSfx/Olt ':f  q&sjC[7.G8eGN
!hn'/Dv	DA{W@eLVB ^:^3T}BPC7~ !Yi{5.`>.ON&_*%fY9*I7V{$igRn8DLC r:6Sq'/i;QDPBU_Uk(): 
7nRNI|eP$&IClWM>![C$3&e w7-?~w3JKm1"EJK[mzv%+YksAS1ppQW@D#5|h#<b5CBGp`'T|oQIPf_9&H[M<	H{k<)?.0L~uSI'k`U,JH"#msU0fild`4Q#3H[WQ{2	oF$#{S	+7c1x0t	5M}"Z?)L;||Y8QJ5}v,; 4 e3b%/j0sD)iI*hYfg-ygPDy*4Cj7j6s{~vq291;rNdTi$pp'!-_K]$
51y"sT
sjyyd.i|9;4P="HjI3:]
lj'	`@5PLuFwL})OcgGd4ګt\R(fqYJ{M-sl
_~7*#EUl|HgI,HWz [>0;ds%Z# ?38H$M*OSp^h?D$]2<bkY60^srv]$pa&lE","_amd`\_UrRr/v U7}"#HTe)zN_[ZrHNEJ8u6H8A7nn[}VcB2x|	cHJ!Mo66#1Wqak 4Y&2mcrV5dU7i!fibeb#4 WZZrk{Vª`%NKbNY8H*Q/In+F!vZ
J&;<d&1W?ORd5
) u
\o=^ |0T*eN@>/	R^1rp>lP}|_%Z(z-/<=CV?M3& qYD20Fx]GrF7t#W"t]r:Hh=i(u3)4`79+<SQ0c[q}aBq-51
s1p|T|T[xJA@KiM) RSLMcH0%W4j"9_``,gppF`z-
Q}Qfbp:v+d@5E(kW; v"[G8?NaJ)K^a#]h%YTAwP;rg2|iyB5|55hco}M^
~X^\F|Qak5(Cf]A/U,r7f$7uGbOFst0A[Z(0o.	"e%aNRO7H!*&'/]UM^,.z
&gcCNOV^yHfd1+V*T*nv<Y-H'v]8#3<pB%J	BA,NNXIN=Ux g6V "[QpqBj+0	ln{OW,yIOz$Q~'Ruw1
D5QDGrI?u^g3Wbݟev9/MMVpa	veqrGs,-]gT1XMRLrln6aCIra8WM;+#y~?~7sztjG
 `
F]_?5vtJz~mnrUA9T!)_@BfX(tn,!ASk %~I_4=qa "Zcm%eV<-
gQ,d
-\K+kd,'}ZB^@;E4vmv^i-wMr\EG(D@4yEddcL17cCndOK'5m20^L/ {k/<z)aJn,L83jZiVBFq?L!FS
]D=ZQ <{p Y?>H)ckzOU1O-?^T+
~>}17Kn{Z8Gy
_an9eBY('Rzr}.(Ul-fsr}V=JE;
'Mn,`)Oe;#$som87gMzd` 8f#p<04]d.#Kq,K%o+;!lmHvA KboSY)lglP? DUB.;"mjL1EA%N^>#GkjoP6.9^	;=WU')_bXFO`*T !
$.erT.
{
>[bu*E<h"g`g l]Cp]t4w!]804.+`!^4O@(E:<"B&@(vDs(.05
[AAYaKM~:fD (W.Cz7
++5
X_Ph8RmiW-fn
t=M_ Cz+hf~h0mMqHiLAcx(f<T \8\cT(P$O+Jr9"].HUs"Ldr,V.n1xe,XGu	|W+*K.;(<D
2 RT2=ONHuk,<-o=|$ky3MThS6yBrI`atfJFfh}T,==hc!B6# iWyP
?HgT.=q>&*[p4J_B!~.@4iS>k7+v*#H;oBqV(^qhp{G/AAi-ul,Z0!9a-r3K!><-->5)?0e.5yQK-f?]M)~RjbtA;)/MSdB7*STVn%u~5OBpfGNmIPiH3oz/^q31mf	QAoeGGdhI~9?vI]#~; ,B`c[ZXpX%}ns/n=L%'eIW!,@LRBt	)h@i[=%kC4
T{=)gT(;3b*t$:]X2SNzo	/zYJ"{fw=e
UgsKpGY>' X|eh($ KT$AH2~"@hE1l1M[S
Q	fb=3-W&4"D*	<ZV@ijVV/.pNhq!PsY+U
vFp&)NN[EDUO1CIXreeP*g$*{SnNcq#beLk!x>S	Ls>	f[ax.Q y'h9zQ|.\7,ioPF_g%le%J~NN/RbgimZL8LZZ	X"
<|rG 0,7=I]ISXgo2B ~#vL}f5H/su'BO+Vl.eZ*
?< Hx</y^F0^-=lP)g-U+o~u4YAc9yS-[STNubJ%Y1uc>[9"~MD='>`]TsXa'$E.AGEIE/ih1MnHc+6&l	>)XwM rC T
2kw5bVcl{%7s7]{{OC ,Yo$+nSdz>\Ed<|
*]m ^>=N7yEjy\>{/}$B#iO^YF>vlL+ #)>ApA&Sa#n'WzBHlJ&v732E<0EAJPFu&vRJt":t*y*C?J>{epk	<%LNSj$RS?M@#@6lqH>^tKi@:TD>"nAgm&xoKMPSdh#vhNH4)hp+#TW;1:iY4.e~:T9]k/S7x4]bmtJ\M}
c]UVG(dw;GG&_$e'g h?!y!Kt
 q()Ae;cB$&@0mBDa&>AT*2NIQ=>KUe;Yd _1YAgPMobf	M{0`QQ}g?(si[ .P8ztopy-TWjSY$F
qt! 0DlSpIUi.'iOE3/ff}! #|ruwewgt=36(d>.`:	`(i-1i@]H:-7P^Q23AD&5tK[o|xFKq++lal#R_x+z_>Xmk^w	qv b# F,;	^Qo).hTX68Tu +4cMV@N]fW;.jJ$yTLi}``/OHjHt]
+h"?X'mI #'R6m¸Ԯ-'goo12om@t+P geOMS!HV>/<X7e`xA*"-~GijxjR^wli'#+,!t+k61YM
?%IC!R1P}:].][7$^*Q
9Mt]:B0STM)_
.cdFAME-;`PXRerS$<Vp@k{[]ifmCC{S:J2Aoru\
8LTF5RY}Wm.|]%G}9m{|{4}+-.B/sm0PYEG`B>wyO$yun!}.#|GeV:}
1tj$Zszs2/=4~$ 9KOiy.'f&H<kieD/ys_43/mkWX=7z}"OHDs
R-`YeҮsS(78Ī]^Sh(T[fa,"+RvG8@^"gdu+i^+!}-q	XtAU74J}M&9)El`iI*NpkOfQ%1*{r*,tp}>dNuiJ'tUGt},[
B%zY Oz Hx7iI7I2hz'7pWf,r/a[+:v>}r7nu;Bu|c{OMx X~q`	@bqb,K6<1|51|^
y88rEh@ 9oc*+pghB1+ey&
VYuoO_aG?^F!a4~+Eg(Mq8k
ovKG
}1GYG>eBqB6 'V!d(75y~Rv\su niokANe ;h	)?=w+596Ej4Ar 34	ork/j9DiPH-UC'pe-|,jQ"t($",j")&v_`(!**UB9q_[[v1>ZO,&f!+|uh3:?$oD	>r%$~=[uaN*:IL
;r7apv"?=0^sQn4-X
i<m#^3 g^<r,-[pJ5$@LO\V2.7$	>ptoULrUa?@	*' M@b!a}M8}Fh2~ITv9,+dxl x
R>k`aDNwEH
Y>%2howP?hXW~i>A2
gI,GyY |.4o*$%fL CA|nGgu]sn,&^z)hNQf]wRfHkN)t)z+K/BTs gA?!E0ypk>)	|Ms36drf<[,H<Bn]2UrdKS~
@Jte
i9y>YM
g8pX_Y^ 62h
:!WWG6Pk3i4%``b$9y{%r3addRp(OM%qvcOH8`9, {1T#;S%\g^b+{#k.M]UK23Stlx@=_sS]n573w};	pK`+4?Y-e"od j$0j&N|)TYT2(:] 1@e	0[pHV0u!ahH_ .U4T`sKs{MF=J[
pjEV$)Gs`|Msc]oFj"]DtdzqRkcc&:@H	=%WXk>BdM/b>t??<fMY*JWNi3C`)p| _5Nz"":[Q%bRZx^D%mtt<v[
'6v'd/cH.
wM1)?^S
@UcAKs\yIo2r({:qoS][I-Xk<PT5-?UFJ	DN
o|X:={"V5UA2?b+&G>?1p*
F+8%cL(7HB]|w; Re3_INv( $1[:
NKm]Wq%X}l40
+dANh%N
9"o}B+t'T*@F<Yg=%PK)4n{ (rS/r	fK`%C1J*VOcnL0jk7Yu?d>c?><PQz|]muFB"o'l
DqB:ii)I
;!mz
*3C{Sbjp
)`JbPhr$!}c4D~;z/	[T@$pR<XUW_k]di'W:?-kLY{ds/@ S.b\AVU=];i`\?nt2
e$[XC Pf[--[G-kf}h"À^NabYK7yAWtt9) WOI
E'9cV}aqE ]x[{.5 8g8orm/$'(pcfs TIAL INTEGRAL:  X=-10.(.2)6.'//'    X'/) 	X=-10.2 	H=0.2
 	XOL                                                