                            XC $      ELN042.D                                                                                                                                                                                                     HO@               ELN042.D  BACKUP/INTERCHANGE/VERIFY/BLOCK=9000/GROUP=25/REPLACE/PROT=(S:RWED,G:R,O:RWED,W:R) SEAS$KWD:*.*;* SEAS$LIB_NODE"SEAS$REMOTE password"::SEAS$LIB_DISK:[34516.79374.109147.0.ELN]ELN042.D;1/SAVE_SET  SYSTEM            M:u      V5.4 	 _4BUY4:: 
   
  V5.4 
  $                               - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION1.PAS;1 +  ,    .     /     4 5      
                     - 
    0   1    2   3      K  P   W   O     5   6  ~FX  7  -Y  8          9          G    H  J                   module asynchronous_io_example;    {++  {  { Abstract:  { 3 {	This is a simple program to show how asynchronous 0 {	activity is done using the VAXELN multitasking
 {	facilities.  { 4 {	The master process creates a subprocess to perform1 {	the I/O operations. As each buffer is complete, 2 {	the master process computes a simple checksum on3 {	the data. When all the data is read, the checksum 4 {	is displayed. The subprocess asynchoronously reads1 {	data from a file using a straightforward double 1 {	buffering scheme which is synchronized with the ( {	master process by using Event objects. {  {--}   include  	$mutex;   {  {	Job-wide declarations. {}   { 1 {	Define a record which will contain data and the 3 {	mutex to protect the data from multiple accesses.  {}   type, 	file_record = packed array[1..512] of char;   	data_record = record; 	    full: mutex;  	    empty: mutex; 	    last_block: boolean;  	    data: file_record	 	    end;    { , {	Declare a "double buffer" of data_records. {}   const  	first = 0;  	second = 1;   var / 	data_blk: array[first..second] of data_record;    {  {	Declare the input file {}   var   	data_file: file of file_record;  ( function other(index: integer): integer;   {++  {  { Functional description:  { ) {	This is an inline routine to "flip" the ) {	buffer index to the other buffer index.  { 	 { Inputs:  {  {	index - Buffer index.  { 
 { Outputs: {  {	Index of the other buffer. {  {--}   begin    if index = first then 	other := second else 	other := first  end;    program asynchronous_io(output);   {++  {  { Functional description:  { + {	This is the master process that creates a 4 {	subprocess to asynchronously read the data blocks.5 {	As the data blocks are read a checksum is computed. 1 {	When all the dats is processed, the checksum is  {	displayed. { 	 { Inputs:  {  {	A data file. { 
 { Outputs: { # {	The simple checksum is displayed.  {  {--}   { - {	Master-process-local variable declarations.  {}   var  	reader_process: process;  	checksum: integer;  	i, j, k: integer;
 	id: integer;  	status: integer;  	checksum_done: boolean;   begin    { , {	Start by opening the data file and exit if, {	the open fails using the failure status as* {	the job exit status. NOTE: The file name0 {	'10.172::gathered.dat' must be replaced with a- {	valid node number, username and password if . {	necessary, and filespec of an existing file. {}   open(data_file, )      file_name := '10.172::gathered.dat',       history := history$old,      status := status);    if not odd(status) then 	exit(exit_status := status);    reset(data_file);    { & {	Initialize both data_blk structures. { * {	Set mutexs to indicate that both buffers {	are empty. {}  # create_mutex(data_blk[first].full); ! lock_mutex(data_blk[first].full); $ create_mutex(data_blk[first].empty);$ data_blk[first].last_block := false;  $ create_mutex(data_blk[second].full);" lock_mutex(data_blk[second].full);% create_mutex(data_blk[second].empty); % data_blk[second].last_block := false;    { ) {	Create the subprocess to read the file.  {  {}   create_process(reader_process, 	       reader_process_code, 	       status := status);   { & {	Initialize the variables used during {	the checksum computation.  {}   checksum := 0; id := first; checksum_done := false;    {  {	Checksum computation loop. { + {	Pass over each buffer in turn, locking it $ {	while the data is being processed. {}   repeat 	lock_mutex(data_blk[id].full);  	if not data_blk[id].last_block  	then  		for i := 1 to 512 do 			checksum := checksum + ! 				    ord(data_blk[id].data[i])  	else  		checksum_done := true;" 	unlock_mutex(data_blk[id].empty); 	id := other(id)   	until checksum_done;    { / {	Close file and display the computed checksum.  {}   close(data_file); , writeln('Data file checksum is: ', checksum) end;  " process_block reader_process_code;   {++  {  { Functional description:  { * {	This process reads the data file using a' {	double buffer scheme. The buffers are $ {	"locked" then filled with data and& {	unlocked. This locking protocol will+ {	synchronize with the master process which  {	is computing the checksum. { , {	A boolean is set in the buffer to indicate {	end-of-file. { 	 { Inputs:  {  {	Data_file is open. {	Buffer one's lock is set.  { 
 { Outputs: {  {	<No direct outputs.> {--}   var 
 	id: integer;    begin    {  {	Initialize local variables.  {}   id := first;   {  {	File read loop.  {}   repeat  	lock_mutex(data_blk[id].emp      
       ty); 	if not eof(data_file) 	then # 		read(data_file,data_blk[id].data)  	else " 		data_blk[id].last_block := true;! 	unlock_mutex(data_blk[id].full);  	id := other(id)  & 	until data_blk[other(id)].last_block; end; end;                                                                                                                                                                                                                                                                                                            . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION10.PAS;1 +  ,    . 	    /     4 O   	   	 P                    - 
    0   1    2   3      K  P   W   O 
    5   6 FX  7 `XIY  8          9          G    H  J                  module dlv11j_test;    { F {     This application writes a prompt to the terminal, waits for user@ {     input, and echoes the characters received on the terminal. {}     { I {     Define the CSR and buffer for the receiver and transmitter channels  {     of a DLV11--J. {}   type&      both_csrs =	 [word] packed record% 				  interrupt   : [pos(6)] boolean; % 				  ready	      : [pos(7)] boolean;  				end;  )      both_buffers =	 [word] packed record " 				  datum	      : [pos(0)] char; 				end;  +      dl_type_registers =      packed record  				csr		   : both_csrs; 				buffer		   : both_buffers;
 			      end;   %      region_def =	      packed record  				datum		   : both_buffers; 
 			      end;    { @ {     Declare variables for the two DEVICES, their registers and# {     their communications regions.  {}   VAR 8      receiver_device, transmitter_device       : DEVICE;8      receiver, transmitter		       : ^dl_type_registers;=      receiver_region, transmitter_region       : ^region_def; 9      receiver_priority, transmitter_priority   : INTEGER; 0      clear_the_ready_bit		       : both_buffers;5      prompt				       : PACKED ARRAY [1..16] OF CHAR;    program dlv11_j_test;    var       i : integer;    begin    {  {     Main Program code.   { M {     Fill in the prompt. Create the receiver and transmitter DEVICE objects. M {     Creating the devices maps the CSR variables to the registers on the I/O M {     page and connects the appropriate ISR to each of the interrupt vectors.  {}                prompt := 'Program started ';  create_device('dla0',  	      receiver_device, ' 	      service_routine := receiver_isr, ' 	      region	      := receiver_region, # 	      registers	      := receiver, , 	      priority	      := receiver_priority);   create_device('dla1',  	      transmitter_device,* 	      service_routine := transmitter_isr,* 	      region	      := transmitter_region,& 	      registers	      := transmitter,/ 	      priority	      := transmitter_priority);   L {     Clear the receiver ready bit in case it is set by reading the receiver {     buffer register. {}  7 clear_the_ready_bit := read_register(receiver^.buffer);     H {     Enable interrupts for the receiver and transmitter channels of the {     DLV11--J.  {}  % disable_interrupt(receiver_priority); 2 write_register(receiver^.csr,	 interrupt := true);4 write_register(transmitter^.csr, interrupt := true); enable_interrupt;   M {     Write out a prompt by putting one character at a time into the transmit D {     buffer and the@                                                                                                                                                                                                                                                                                                                                                                          8 $      ELN042.D                         
  .[SYSEXE.SEAS$WORK_0000005C]APPLICATION10.PAS;1                                                                                 O     	                         }#             n waiting until the interrupt is handled for theG {     transmitter.  The WAIT_ANY will be satisfied after each character  {     is sent. {}   for i := 1 to 16 do    begin <     write_register(transmitter^.buffer, datum := prompt[i]);!     wait_any(transmitter_device);    end;   { O {    Echo each character entered at the terminal.  First, wait for the receiver L {    ISR to place a character in the communication region.  When the wait isN {    satisfied, put the character in the transmitter's buffer              and wait for the@ {    transmitter ISR to signal that the character has been sent. {}  
 while true do    begin      wait_any(receiver_device);'     write_register(transmitter^.buffer, , 		   datum := receiver_region^.datum::char);!     wait_any(transmitter_device);    end; end;      ; interrupt_service receiver_isr( dlv		 : ^dl_type_registers; $ 				interrupt_region : ^region_def); begin    { ) {     Receiver interrupt service routine.  { H {     Move the character from the receiver buffer into the communicationM {     region. Then signal the device, which will inform the main program that & {     the interrupt has been serviced. {}  8   interrupt_region^.datum := read_register(dlv^.buffer);   signal_device; end;  I interrupt_service transmitter_isr( interrupt_csr    : ^dl_type_registers; ' 				   interrupt_region : ^region_def);  begin    { , {     Transmitter interrupt service routine. { H {     Inform the main program that the character has been transferred byH {     signalling the device, indicating that the interrupt has occurred. {}     signal_device; end;   end.                                                                                                                                                                                                                                                                                                                                                                                                                                                              . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION11.PAS;1 +  , 
   .     /     4 O       $                    - 
    0   1    2   3      K  P   W   O     5   6 @4#]  7 gY  8          9          G    H  J                  module drv11_w_test;   { E {     This application uses ELN$UNIBUS_MAP to perform DMA between the > {     DRV11_WA parallel interface and a MicroVAX II processor. {}   include $unibus;     { J {     Define data types for the different registers on the DRV11-WA board. {}   type'      drv11_w_word =	   [word] 0..65535; ,      drv11_w_twos_compl =  [word] -32768..0;/      drv11_w_bus_address = [word] packed record  				    case boolean of . 				      true  : (low   : [pos(1)] 0..32767);+ 				      false : (high  : [pos(0)] 0..63); 
 				  end;  -      control_status =	   [word] packed record % 				    go		     : [pos(0)]	 boolean; ( 				    user_1	     : [pos(1)]	 boolean;( 				    user_2	     : [pos(2)]	 boolean;( 				    user_3	     : [pos(3)]	 boolean;* 				    extended_addr    : [pos(4)]	 0..3;- 				    interrupt_enable : [pos(6)]	 boolean; ' 				    ready	     : [pos(7)]	 boolean; ' 				    cycle	     : [pos(8)]	 boolean; ( 				    stat_a	     : [pos(9)]	 boolean;( 				    stat_b	     : [pos(10)] boolean;( 				    stat_c	     : [pos(11)] boolean;' 				    maint	     : [pos(12)] boolean; & 				    attn	     : [pos(13)] boolean;& 				    nex		     : [pos(14)] boolean;' 				    error	     : [pos(15)] boolean; 
 				  end;  #      drv11_w_reg =	   packed record . 			     word_count		     : drv11_w_twos_compl;/ 			     bus_address	     : drv11_w_bus_address; ' 			     csr_reg		     : control_status; $ 			     buffer		     : drv11_w_word;
 			   end;   { B {     Define a type for a buffer that will hold 32K words of data. {}  <      big_buffer =	   packed array[0..32767] OF drv11_w_word;   { @ {     Define a type to load the Q-bus address into the DRV11-WA. {}  +      qbus_address =	   [long] packed record & 				    low		     : [pos(1)] 0..32767;$ 				    high	     : [pos(16)] 0..63;
 				  end;   { ? {     Define variables that you will use in the program itself.  {}   var &      drv11_w_registers : ^drv11_w_reg;%      this_buffer       : ^big_buffer; !      drv11_w_priority  : integer; !      dummy_message     : message;       drv11_w	       : device; &      buffer_address    : qbus_address;-      bus_address_set   : drv11_w_bus_address;    program drv11_w_handler;   begin      {  {     Main program code. { L {     Use the create_device procedure to map variables in your address spaceH {     to the I/O page, to identify the interrupt service routine, and to! {     identify the DEVICE object.  {}   create_device ('drv11_wa', 	       drv11_w,' 	       service_routine := drv11_w_isr, - 	       registers       := drv11_w_registers, - 	       priority	       := drv11_w_priority);    { M {     Use the create_message procedure to create a contiguous block of memory  {     for your buffer area.  {}  + create_message(dummy_message, this_buffer);    { K {     Use the ELN$UNIBUS_MAP procedure to convert the address in your space K {     to a 22-bit Q-bus physical address.  The variable buffer_address will D {     contain the 22-bit Q-bus address of the variable this_buffer^.L {     Consequently, you ca 
            n use buffer_address to tell the DRV11-WA where to {     DMA data to or from. {}   eln$unibus_map(drv11_w, . 	       this_buffer^::byte_data(65535), 65535,! 	       buffer_address::integer);    { L {     Set the bus address register flag of the DRV11-WA by accessing the busL {     address register.	 This enables you to load the Q-bus address into the, {     appropriate registers on the DRV11-WA. {}  A bus_address_set := read_register(drv11_w_registers^.bus_address);    { H {     Load the low portion, the first 16 bits (bit 0 is ignored), of theO {     Q-bus address into the bus address register.  Then load the high portion,  {     the last six bits. {}  K write_register(drv11_w_registers^.bus_address, low  := buffer_address.low); L write_register(drv11_w_registers^.bus_address, high := buffer_address.high);   { A {     Incitialize the word count register to -32768.  This is the E {     negative count of the number of words to be transferred (65,535 H {     bytes).  As each word is transferred, the controller increases theN {     count by 1.  When the count reaches 0, the controller interrupts to show$ {     that the transfer is complete. {}  6 write_register(drv11_w_registers^.word_count, -32768);   { ' {     Disable interrupts for the board.  {}  $ disable_interrupt(drv11_w_priority);   { & {     Set the board up for interrupts. {}  * write_register(drv11_w_registers^.csr_reg, 		 go		  := true,  		 cycle		  := true, 		 interrupt_enable := true);    { 2 {     Enable interrupts and wait for an interrupt. {}   enable_interrupt;  wait_any(drv11_w);   { H {     Print out that an interrupt has occurred, indicating that data has. {     been transferred to or from your buffer. {}  + writeln ('   I	GOT   THE   INTERRUPT	!!!');  end;  > interrupt_service drv11_w_ISR(interrupt_csr    : ^drv11_w_reg;& 			      interrupt_region : ^integer);   begin    {   {     Interrupt service routine. { M {     The interrupt service routine simply signals the device to let you know  {     that DMA has occurred. {}     signal_device; end; end;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION12A.C;1 +  , 
   .     /     4 @                           - 
    0   1    2   3      K  P   W   O     5   6 'vFX  7 nY  8          9          G    H  J                   #module application12  #include descrip   /*<  *	This module demonstrates the calling of FORTRAN functions  *	from VAX C.  */   > float 	a1[5][10] = {	1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,, 			1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,, 			1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,, 			1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0,. 			1.0,2.0,3.0,4.0,5.0,6.0,7.0,8.0,9.0,10.0 };  ( float	a2[10][5] = {	1.0,2.0,3.0,4.0,5.0, 			1.0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0,  			1                                                                                                                                                                           -mQ $      ELN042.D                       
  
  -[SYSEXE.SEAS$WORK_0000005C]APPLICATION12A.C;1                                                                                  @                              c 
            .0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0,  			1.0,2.0,3.0,4.0,5.0 };    float	vec1[5],vec2[10];    /*9  *	The declarations of FORTRAN routines in C involves the ;  *	only thing that C "knows" about the function, it's retur <  *	type. When actually coding calls to the FORTRAN routines,7  *	you are responsible for mapping the FORTRAN language 8  *	semantics of the arguments into C semantics, i.e. for1  *	putting the correct data in the argument list.   */    /*<  *	Declaration of first function. FORTRAN's default argument>  *	passing mechanism is by-reference, and the array dimensions=  *	are reversed. Therefore although this function sums up the >  *	FORTRAN array's columns, it will sum up the C array's rows.<  *	Note that the declaration's extents are reversed from the<  *	way they appear in the FORTRAN declaration. That is, it's8  *	the number of rows that's passed before the number of!  *	columns, in the FORTRAN sense.   */   ( /* 1st arg = pointer to matrix to sum */, /* 2nd arg = pointer to output sum vector */= /* 3rd arg = pointer to number of rows (FORTRAN) in matrix */ @ /* 4th arg = pointer to number of columns (FORTRAN) in matrix */   float	sum();   /*"  *	Declaration of second function:  */   1 /* 1st argument = pointer to string descriptor */ = /* FORTRAN calls this a "passed length character argument" */    int	icmax();   main() {   
 float	result;  int	i;& static	$DESCRIPTOR(str, "abcdefghij");' static	$DESCRIPTOR(str2, "zyxwvutsrq");   " result	= sum(&a1, &vec1, &10, &5);# result += sum(&a2, &vec2, &5, &10);  result += icmax(&str); result += icmax(&str2);    /*?  *	Check the results of the calls. Result itself should be 436. =  *	Each of the elements of vec1 should be 55, and each of the !  *	elements of vec2 should be 15.   */   @ printf("The value of Result is %g (Should be 436)\n\n", result);  = printf("\nThe values of vec1 should all be 55.	They are:\n");  for(i = 0; i < 5; i++) 	printf("%g\n", vec1[i]);   = printf("\nThe values of vec2 should all be 15.	They are:\n");  for(i = 0; i < 10; i++)  		printf("%g\n",vec2[i]);    }                                                                                                                                                                                                                                                                                                                                                                                                       / * [SYSEXE.SEAS$WORK_0000005C]APPLICATION12B.PAS;1 +  ,    .     /     4 C                          - 
    0   1    2   3      K  P   W   O     5   6 RFX  7 ` Y  8          9          G    H  J                 module application12;    { ; {	This module demonstrates the calling of Fortran functions  {	from ELN Pascal. {}   type5 	real_array(m,n: integer) = array[1..m,1..n] of real; / 	real_vector(m: integer) = array[1..m] of real;    var 7 	a1: real_array(5,10) := (5 of (1,2,3,4,5,6,7,8,9,10)); - 	a2: real_array(10,5) := (10 of (1,2,3,4,5));  	vec1: real_vector(5); 	vec2: real_vector(10);    { 6 {	Declaration of a Fortran function. Fortran's default5 {	argument passing mechanism is by-reference, and the 4 {	array dimensions are reversed. Therefore, although4 {	this function sums up the Fortran array's columns,3 {	it will sum up the Pascal array's rows. Note that 5 {	the declaration's extents are reversed from the way 7 {	they appear in the Fortran declaration. That is, it's 7 {	the number of rows that's passed before the number of   {	columns, in the Fortran sense. {}  & function sum(ary: real_array(<m>,<n>); 	     vec: real_vector(m);& 	     n,m: [reference] integer): real;	 external;    { 3 {	Declaration of another Fortran function. This one 5 {	demonstrates the passing of a string by descriptor. 0 {	(Fortran calls this a "passed length character
 {	argument".)  {}  + function icmax(cvar: string(<n>)): integer; 	 external;    program test(output);    var  	result: real; 	i: integer;! 	str: string(10) := 'abcdefghij';    begin    result := sum(a1,vec1);   result := result + sum(a2,vec2); result := result + icmax(str);' result := result + icmax('zyxwvutsrq');    { > {	Check the results of the calls. Result itself should be 436.< {	Each of the elements of vec1 should be 55, and each of the  {	elements of vec2 should be 15. {}  C writeln('The value of Result is ', result:5:1, ' (Should be 436)');  writeln;  ; writeln('The values of vec1 should all be 55.  They are:');  for i := 1 to 5 do 	writeln(vec1[i]:4:1); writeln;  ; writeln('The values of vec2 should all be 15.  They are:');  for i := 1 to 10 do  	writeln(vec2[i]:4:1)    end; end;                                                                      / * [SYSEXE.SEAS$WORK_0000005C]APPLICATION12C.FOR;1 +  ,    .     /     4 J       P                   - 
    0   1    2   3      K  P   W   O     5   6  rFX  7 wY  8          9          G    H  J                 C > C This module defines some Fortran functions to be called from# C ELN Pascal or C in an ELN process  C    C B C This function sums each column in the array into the vector, and8 C returns the sum of all elements as the function result C " 	FUNCTION SUM(ARRAY, VECTOR, M, N)  ! 		DIMENSION ARRAY(M,N), VECTOR(N)    		INTEGER COL,ROW    		SUM = 0.0    		DO 20 COL = 1,N  			VECTOR(COL) = 0.0   			DO 10 ROW = 1,M. 				VECTOR(COL) = VECTOR(COL) + ARRAY(ROW,COL) 				SUM = SUM + ARRAY(ROW,COL) 10				CONTINUE  
 20			CONTINUE    		RETURN 		END    C J C This function returns the position of the character in a string with the C highest ASCII code value C  	FUNCTION ICMAX(CVAR)    	CHARACTER*(*) CVAR    		ICMAX = 1  		DO 10 I = 2, LEN(CVAR)2 			IF (CVAR(I:I) .GT. CVAR(ICMAX:ICMAX)) ICMAX = I
 10			CONTINUE  		RETURN 		END                                                                                                                                                                                               , * [SYSEXE.SEAS$WORK_0000005C]APPLICATION13.C;1 +  , 

   .     /     4 >       p                   - 
    0   1    2   3      K  P   W   O     5   6 
GX  7 uY  8          9          G    H  J                    #module dlv_driver   /*;  *	This is a sample DLV device driver written in C. It does :  *	not support UNIX or STDIO style I/O, rather, a message-:  *	based form of I/O requests is provided (see below for a;  *	description). Since C I/O is not supported, the normal C 9  *	runtime library interpretation of program arguments is ;  *	not used. Instead, the program assumes the first program   *	argument is the device name.   *  *-  *	The interface to the driver is as follows:   *:  *	    1)	The program wishing to do I/O to and/or from the4  *		DLV device connects to the DLV$DRIVER_PORT port.  *;  *	    2)	The program then sends requests over this circuit 9  *	   	to do reads and writes to/from the DLV. The driver 9  *	   	services the request and sends back an appropriate 
  *		response.   *=  *	    3)	The program sends a special "I'm done" message when   *		it has completed it's I/O.  *>  *	The messages passed between the driver and the user program=  *	contain a request type (read_block, write_block, or done), <  *	a place for an error code (set by the driver), the number>  *	of bytes to be read or written, and a buffer into which the<  *	data will be read or from which the data will be written.;  *	See the structure definition below for the exact message ;  *	format.	 Note that there is also a maximum size for read /  *	and written data which should be adhered to.   */    #include $vaxelnc  #include descrip   /*6  *	Define the size of the receive and transmit buffers   *	in the communications region.  */    #define	RBUFFER_LENGTH	512 #define	XBUFFER_LENGTH	512   /*  * 	Define the device count   */    #define DEVICE_COUNT	1   /*3  *	Define the supported function codes (used in the 8  *	operation field of the dlv_packet message structure).  */    #define	DONE_FUNCTION		0 #define	READ_BLOCK_FUNCTION	1  #define	WRITE_BLOCK_FUNCTION	2   /*2  *	Define the bit locations and masked used in the1  *	transmit and receive CSR and buffer registers.   */    #define	RCSR$V_INT_ENA	6* #define RCSR$M                                                                                                                                                                                                                                                                                                                                                                                                                                          ui] $      ELN042.D                       

  
  ,[SYSEXE.SEAS$WORK_0000005C]APPLICATION13.C;1                                                                                   >                              J "            _INT_ENA	(1<<RCSR$V_INT_ENA) #define	RBUF$V_CHAR	0 ' #define RBUF$M_CHAR	(0xFF<<RBUF$V_CHAR)  #define	RBUF$V_ERROR	15 & #define RBUF$M_ERROR	(1<<RBUF$V_ERROR) #define	XCSR$V_BREAK	0& #define XCSR$M_BREAK	(1<<XCSR$V_BREAK) #define	XCSR$V_INT_ENA	6* #define XCSR$M_INT_ENA	(1<<XCSR$V_INT_ENA)   /*   *	Define the COPY_BYTES macro -0  *	    This macro copies the specified number of/  *	    bytes from one string to another without $  *	    any character interpretation.  */   # #define COPY_BYTES(src,dst,cnt)			\  		{				\ 		char *s = (src);		\  		char *d = (dst);		\  		int   c;			\ 		for(c=(cnt);c;c--)		\  			*d++ = *s++;		\ 		}    /*+  *	Define and allocate a pointer to the DLV   *	device registers.  */    struct register_def  		{  		unsigned short	rcsr; 		unsigned short	rbuf; 		unsigned short	xcsr; 		unsigned short	xbuf; 		}			*register_ptr;   /*/  *	Define and allocate a pointer to the receive '  *	and transmit communications regions.   */    struct rx_region_def 		{  		char	rbuffer[RBUFFER_LENGTH];  		int	read_count;  		int	buf_ptr; 		BOOLEAN	read_in_progress;  		BOOLEAN	error; 		}			*rx_region_ptr;    struct tx_region_def 		{  		char	xbuffer[XBUFFER_LENGTH];  		int	write_count; 		int	buf_ptr; 		BOOLEAN	write_in_progress; 		}			*tx_region_ptr;    /*/  *	Define the format of the dlv_packet message.   */    struct dlv_packet  		{  		int	operation; 		int	error;
 		int	length;  		char	buffer[]; 		};   /*7  *	Master process - This function will be that which is 6  *	started as the job and, therefore, must come first.  */    dlv_driver() {   & VARYING_STRING(32)	device_name_string;0 DEVICE			dlv_receive_device,dlv_transmit_device; PORT			dlv_driver_port;  MESSAGE			dlv_message; NAME			dlv_name;! void			receive_service_routine(),  			transmit_service_routine(); struct dlv_packet	*dlv_request;  BOOLEAN			done; " int			*adapter,*vector,ipl,status; int			request_size;    /*+  *	These macros allocate string descriptors   */   4 static $DESCRIPTOR(dlv_port_name,"DLV$DRIVER_PORT");# static $DESCRIPTOR(device_name,"");   , /*******************************************  *					   *    *	   Driver Initialization	   *  *					   * -  *******************************************/    /*3  *	Obtain the device name from the program argument .  *	list and put it into the device_name string  *	descriptor.  */   - eln$program_argument(&device_name_string, 1); 4 device_name.dsc$a_pointer = device_name_string.data;5 device_name.dsc$w_length  = device_name_string.count;    /*$  *	Create the receive DEVICE object.  */    ker$create_device( 		&status, &device_name, 		1, receive_service_routine,  		sizeof(struct rx_region_def),   		&rx_region_ptr, &register_ptr, 		&adapter, &vector, &ipl, 		&dlv_receive_device, 		DEVICE_COUNT,  		NULL);   /*%  *	Create the transmit DEVICE object.   */    ker$create_device( 		&status, &device_name, 		2, transmit_service_routine, 		sizeof(struct tx_region_def),   		&tx_region_ptr, &register_ptr, 		&adapter, &vector, &ipl, 		&dlv_transmit_device,  		DEVICE_COUNT,  		NULL);   /*2  *	Initialize the device by setting the receiver's  *	interrupt enable bit.  */   3 write_register(RCSR$M_INT_ENA,&register_ptr->rcsr);      /*-  *	Get the driver's job port, create a string .  *	descriptor pointing to the desired name for2  *	the port (DLV$DRIVER_PORT) and create the name.  */   % ker$job_port(NULL, &dlv_driver_port); 0 ker$create_name(NULL, &dlv_name, &dlv_port_name,  		&dlv_driver_port, NAME$LOCAL);     /*/  *	Initialization complete - inform the kernel.   */    ker$initialization_done(NULL);  , /*******************************************  *					   * "  *	   Driver Normal Operation	   *  *					   * -  *******************************************/    /*,  *	Continuously wait for connect requests to*  *	perform I/O to and from the DLV device.  */    for (;;) 	{   	/* ) 	 *	Accept a circuit connect with another ' 	 *	job who wants to do I/O to/from the  	 *	DLV device.  	 */  1 	ker$accept_circuit(NULL, &dlv_driver_port, NULL,  			   TRUE, NULL, NULL);   	/* % 	 *	Service I/O requests until a done  	 *	packet is sent.  	 */   	for (done = FALSE; !done;)  		{    		/*% 		 *	Wait on the port until a message $ 		 *	has been sent, then receive it. 		 */   3 		ker$wait_any(NULL, NULL, NULL, &dlv_driver_port); / 		ker$receive(NULL, &dlv_message, &dlv_request, ' 			    &request_size, &dlv_driver_port,  			    NULL, NULL);    		/*! 		 *	Case on requested operation.  		 */     		switch(dlv_request->operation) 			{   			/*  			 *	Service the read request.  			 */   			case READ_BLOCK_FUNCTION:   				/* 				 *	Disable interrupts for  				 *	the device. 				 */    				ELN$DISABLE_INTERRUPT(ipl);    				/*$ 				 *	Initialize the communications 				 *	region for this request.  				 */    				rx_region_ptr->read_count =  						dlv_request->length; 				rx_region_ptr->buf_ptr = 0; ! 				rx_region_ptr->error = FALSE; % 				rx_region_ptr->read_in_progress =  						TRUE;    				/*# 				 *	Reenable interrupts and wait ! 				 *	for the read to be done by  				 *	the ISR.  				 */    				ELN$ENABLE_INTERRUPT(); " 				ker$wait_any(NULL, NULL, NULL, 					     dlv_receive_device);   				/*! 				 *	Check for read errors - if ! 				 *	an error occurred, set the # 				 *	error flag in the DLV packet # 				 *	and set the buffer length to  				 *	the number of characters " 				 *	actually successfully read. 				 */    				if (rx_region_ptr->error)  					{ 					dlv_request->error = -1;  					dlv_request->length =  					    rx_region_ptr->buf_ptr; 					} 				else 					dlv_request->error = 0;   				/*# 				 *	Copy the received bytes from   				 *	the communications buffer# 				 *	into the DLV message packet.  				 */   & 				COPY_BYTES(rx_region_ptr->rbuffer, 					   dlv_request->buffer, 					   dlv_request->length);    				/*  				 *	Send the response back to 				 *	the requestor.  				 */    				ker$send(NULL, dlv_message,  					 request_size,  					 &dlv_driver_port,  					 NULL, FALSE); 
 				break;   			/*  			 *	Service write request. 			*/    			case WRITE_BLOCK_FUNCTION:    				/*" 				 *	Copy the packet buffer data# 				 *	to the communications region  				 *	buffer. 				 */   # 				COPY_BYTES(dlv_request->buffer,  					   tx_region_ptr->xbuffer,  					   dlv_request->length);    				/*$ 				 *	Initialize the communications 				 *	region for this request.  				 */    				tx_region_ptr->buf_ptr = 0;   				tx_region_ptr->write_count = 					 dlv_request->length;   				/*# 				 * 	Disable interrupts from the # 				 *	device and set the interrupt # 				 *	enable bit in the CSR - this " 				 *	causes the device to inter-  				 *	rupt (since the ready bit! 				 *	should be set) and the ISR  				 *	can then do the output. 				 */    				ELN$DISABLE_INTERRUPT(ipl); " 				write_register(XCSR$M_INT_ENA,! 					       &register_ptr->xcsr); & 				tx_region_ptr->write_in_progress = 					       TRUE;    				/*# 				 *	Reenable interrupts and wait  				 *	for the I/O to complete.  				 */    				ELN$ENABLE_INTERRUPT(); " 				ker$wait_any(NULL, NULL, NULL, 					     dlv_transmit_device);    				/*  				 *	Send the response back to 				 *	the requestor indicating  				 *	the buffer was output.  				 */    				dlv_request->error = 0;  				ker$send(NULL, dlv_message,  					 request_size,  					 &dlv_driver_port, NULL, 
 					 FALSE); 
 				break;   			/*  			 *	Service done request.  			 */   			case DONE_FUNCTION:   				/*! 				 *	Send a message back to the  				 *	requestor indicating the ! 				 *	done request was received,   				 *	then set the done flag to 				 *	exit out of the loop. 				 */    				dlv_request->error = 0;  				ker$send(NULL, dlv_message,  					 request_size,  					 &dlv_driver_port, NULL, 
 					 FALSE);  				done = TRUE;   			} 		}    	/* 1 	 *	Since the user program is the last to receive 4 	 *	a message on the circuit, wait on the port until1 	 *	he does a disconnect, then disconnect at this 0 	 *	end. This method is used to avoid having the0 	 *	circuit disconnected before the user program 	 *	receives the last message. 	 */  5 	ker$wait_any(&status, NULL, NULL, &dlv_driver_port);e0 	ker$disconnect_circuit(NULL, &dlv_driver_port); 	} }s o /*,  *	Receiver interrupt service routine (ISR).  */   7 void receive_service_routine(int_registers, int_region)t  $ struct register_def		*int_registers;" struct rx_region_def		*int_region;   {    unsigned short	receive_input;c   /*$  *	Read the receive buffer register.  */i  4 receive_input = read_register(&int_regis                                                                                                                                                                                                                                                                           P $      ELN042.D                       

  
  ,[SYSEXE.SEAS$WORK_0000005C]APPLICATION13.C;1                                                                                   >                                           ters->rbuf);   /*.  *	If the driver is waiting for input, put the1  *	character in the communications region buffer,h  *	otherwise, drop it.  */i  ! if (int_region->read_in_progress)    	/* ! 	 *	Check for errors on the read.e 	 */    	if (receive_input&RBUF$M_ERROR) 		{*   		/*" 		 *	If an error occurred, set the$ 		 *	error bit in the communications" 		 *	region and signal the device. 		 */m   		int_region->error = TRUE;e' 		int_region->read_in_progress = FALSE;e 		ker$signal_device(NULL, 0);k 		}d 	else  		{p   		/*  		 *	Otherwise, put the received# 		 *	character in the communcationso" 		 *	region buffer and bump up the& 		 *	buffer pointer. If this character" 		 *	satisfies the request, signal 		 *	the device. 		 */o  . 		int_region->rbuffer[int_region->buf_ptr++] =  					 receive_input&RBUF$M_CHAR;4 		if (int_region->buf_ptr >= int_region->read_count) 			{ 			ker$signal_device(NULL, 0);( 			int_region->read_in_progress = FALSE; 			} 		}  }n t /*/  *	Transmitter interrupt service routine (ISR).d  */	  8 void transmit_service_routine(int_registers, int_region)  $ struct register_def		*int_registers;" struct tx_region_def		*int_region;   {r   /*.  *	If the driver is waiting for output, output$  *	characters to the DLV until done.  */   " if (int_region->write_in_progress)3 	if (int_region->write_count > int_region->buf_ptr)    		/*! 		 *	More characters to output sod  		 *	output the next and bump up 		 *	the buffer pointer. 		 */*   		write_register(I. 			int_region->xbuffer             [int_region->buf_ptr++], 			&int_registers->xbuf);  	elsen   		/*! 		 *	All characters output; clear	  		 *	the write_in_progress flag," 		 *	clear interrupt_enable on the  		 *	transmitter, and signal the 		 *	device. 		 */f   		{R 		ker$signal_device(NULL, 0);T( 		int_region->write_in_progress = FALSE;* 		write_register(0, &int_registers->xcsr); 		}t   }e                                                                                                                                                              . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION14.PAS;1 +  ,    .     /     4 @                          - 
    0   1    2   3      K  P   W   O     5   6  GX  7 Y  8          9          G    H  J                  module makeboot;   {++  {  { Abstract:  { 7 {	This program initializes an RX50 floppy disk, creates 4 {	required directories, on it, and copies a bootable4 {	VAXELN system image on it. The machine may then be {	booted from the floppy.  {  {--}   include 1 	$disk_utility, $file_utility, $get_message_text, ! 	$elnmsg, $kernelmsg, $pascalmsg;    program make_bootable_floppy;    {  {	Local constant definitions.  {}   const ( 	boot_file = '[SYS0.SYSEXE]sysboot.exe';   {  {	Local type declarations. {}   type+ 	blocks = packed array [1..128] of integer;    {  {	Local variable declarations. {}   var ) 	copy_method, file_size, status: integer; ! 	bad_block_list: dsk$_badlist(1);   7 	source_file_var, destination_file_var: file of blocks;    	answer: varying_string(10);  	drive_name: varying_string(30);4 	status_text, system_file_spec: varying_string(255);" 	volume_label: varying_string(12);   	bootable: boolean;   8 procedure error_exit(status_message: varying_string(80); 		     status_value: integer); {++  {  { Routine description: { 0 {	This procedure accepts a status value and some0 {	accompanying text, translates the status value4 {	to ELN message text, and outputs both text strings/ {	to the console. It then causes the program to  {	terminate. { 	 { Inputs:  { 5 {	status_message - Supplies a varying string which is ' {			 output to the console prior to the  {			 status message. { 1 {	status_value -	 Supplies the status value whose & {			 associated text will be output to {			 t             he console.  { 
 { Outputs: { 9 {	Status code text information is written to the standard ' {	output file (generally, the console).  {  {--}   {  {	Local variable declarations. {}   var " 	status_text: varying_string(255);   begin    { 6 {	Obtain the text associated with this status code and7 {	output both the input string and the generated string  {	to the console.  {}  > eln$get_status_text(status_value, [status$text], status_text); writeln; writeln(status_message); writeln(status_text);    { % {	Dismount the specified disk volume.  {}  , dismount_volume(drive_name, status:=status); exit   end;  . function get_source_spec: varying_string(255);   {++  {  { Routine description: { - {	This function prompts the user for the file , {	specification of the source system file on- {	the host machine.  This system file must be 1 {	built with DISK as the boot method, chosen from 3 {	the System Charactersitics Menu of Ebuild.  There 9 {	is a system image provided on the kit that can be used. 8 {	It is ELN$:ICP.SYS.  This is the disk bootable version3 {	of the VAXELN Installation Certification Program.  { 	 { Inputs:  {  {	None.  { 
 { Outputs: { 3 {	Function returns user-entered file specification.  {  {--}   {  {	Local variable declarations. {}   var # 	source_spec : varying_string(255);    begin    { 7 {	Prompt the user for the file specification. Note that 6 {	a multi-line prompt is used. Read the specification. {}   writeln;@ writeln('Enter full filename (including node number              and access',! 	'control string if necessary)');  write('of system file: '); readln (source_spec);    { & {	Return the file specification input. {}   get_source_spec := source_spec   end;   [inline] procedure dcl_method;   {++  {  { Routine description: { 7 {	This procedure simply prompts the user to type in the 5 {	appropriate DCL commands to copy the system file to  {	the disk.  { 	 { Inputs:  {  {	None.  { 
 { Outputs: {  {	None.  {  {--}   begin    { : {	Write an appropriate prompt string and wait for the user/ {	to let us know that the file has been copied.  {}   writeln;% writeln('From the host system, use'); 9 writeln('      $ COPY systemfile.sys node::', drive_name, ( 	'[SYS0.SYSEXE]sysboot.exe/CONTIGUOUS');# writeln('to copy the system file');  writeln;$ write('Hit RETURN when complete: '); readln (answer)    end;  # [inline] procedure copyfile_method;    {++  {  { Routine description: { 2 {	This procedure copies the system image using the1 {	copy_file utility procedure. Note that the file + {	being copied is assumed to be contiguous.  { 	 { Inputs:  {  {	None.  { 
 { Outputs: {  {	None.  {  {--}   begin    {   {	Get source file specification. {}  $ system_file_spec := get_source_spec;   {  {	Copy the file to this node.  {}   copy_file(system_file_spec,  	  drive_name+boot_file, 	  status := status);  if not odd(status) then' 	error_exit('copy_file failed', status)    end;  " [inline] procedure get_put_method;   {++  {  { Routine description: { 6 {	This procedure copies the system file directly using3 {	gets and puts. This method is used instead of the 6 {	copy_file procedure if the source system file is not
 {	contiguous.  { 	 { Inputs:  {  {	None.  { 
 { Outputs: {  {	None.  {  {--}   {  {	Local variable declarations. {}   var * 	file_attributes: ^file$attributes_record;   begin    { + {	Get the specification of the source file.  {}  $ system_file_spec := get_source_spec;   {  {	Open the source file.  {}   open(source_file_var, #      file_name := system_file_spec,       history := history$old,(      file_attributes := file_attributes,      status := status);    if not odd(status) then/ 	error_exit('Open source file failed', status);  reset(source_file_var);    {  {	Compute the size of the file.  {}  0 file_size := file_attributes^.end_of_file_block;' if file_attributes^.first_free_byte = 0  then 	file_size := file_size - 1;   { . {	If the file is not of zero length, continue. {}   if file_size > 0 then 	begin   	{2 	{	Open the destination file - make it contiguous. 	{}    	open(destination_file_var, ( 	     file_name := drive_name+boot_file, 	     history := history$new,  	     contiguous := true,  	     filesize := file_size);    	if not odd(status)  	then ) 		error_exit('Copy_file failed', status);  	rewrite(destination_file_var);    	{& 	{	Copy the source to the destination. 	{}   " 	while not eof(source_file_var) do 		begin , 		destination_file_var^ := source_file_var^; 		put(destination_file_var                                                                                                                                                                                                                                                                                                                                                                                                                                                          
A $      ELN042.D                         
  .[SYSEXE.SEAS$WORK_0000005C]APPLICATION14.PAS;1                                                                                 @                                    
       ); 		get(source_file_var) 		end; 	end;  end;   {  {	Main program starts here.  {}   begin    { 8 {	Get the drive name and desired volume label as program8 {	arguments 1 and 2. If no drive and/or volume label are {	specified, ask the user. {}  " drive_name := program_argument(1); if drive_name = '' then 	begin  	write('Enter drive name	  : '); 	readln(drive_name);  	write('Enter volume label : '); 	readln(volume_label)  	end else 	begin% 	volume_label := program_argument(2);  	if volume_label = ''  	then  		begin ! 		write('Enter volume label : ');  		readln(volume_label) 		end; 	end;    { 2 {	Set name and label to defaults if not specified. {}   if drive_name = '' then 	drive_name := 'DUA1:';  if volume_label = '' then 	volume_label := 'SCRATCH';   3 if substr(drive_name, length(drive_name), 1) <> ':'  then  	drive_name := drive_name + ':';   { ! {	Ask the user if all is correct.  {}   writeln;5 writeln('***** Initializing ', drive_name, ' *****'); : writeln('This will destroy all information on this disk');0 write('Do you wish to continue (Y or N [Y])? '); readln (answer);   if (answer = '') or "    (substr(answer, 1, 1) = 'Y') or    (substr(answer, 1, 1) = 'y')  then 	begin   	{ 	{	Initialize the volume.  	{}    	init_volume(drive_name, 		    volume_label,  		    verified := false,2 		    bad_list := bad_block_list::dsk$_badlist(0), 		    status := status); 	if not odd(status)  	then + 		error_exit('init_volume failed', status);    	{ 	{	Mount the floppy. 	{}   0 	mount_volume(drive_name, volume_label, status); 	if not odd(status)  	then , 		error_exit('mount_volume failed', status);   	{$ 	{	Create the necessary directories. 	{}   1 	create_directory(drive_name + '[SYS0]', status);  	if not odd(status)  	then 0 		error_exit('create_directory failed', status);8 	create_directory(drive_name + '[SYS0.SYSEXE]', status); 	if not odd(status)  	then 0 		error_exit('create_directory failed', status);   	{1 	{	The floppy is now initialized and is bootable. 1 	{	The system image may be copied in one of three + 	{	ways. All three methods are shown below.  	{}   	 	writeln; ( 	writeln('Ready to copy system image.');2 	writeln('    1 - Copy from host using DCL copy');6 	writeln('    2 - Copy via VAXELN COPY_FILE utility');, 	writeln('    3 - Copy with GETs and PUTs');	 	writeln; 6 	writeln('Enter desired copy method (note: method 2');? 	write('requires a contiguous file on the host system) 1-3: ');  	readln(copy_method);    	bootable := true; 	case copy_method of   		1:	dcl_method;   		2:	copyfile_method;    		3: 	get_put_method;    		otherwise  			 bootable := false;   		end;  / 	dismount_volume(drive_name, status := status);  	if not odd(status)  	then / 		error_exit('dismount_volume failed', status);   	 	writeln;  	if bootable 	then / 		writeln('Operation complete - disk bootable')  	else 2 		writeln('Operation complete - disk initialized') 	end else 	begin	 	writeln; " 	writeln('Initialization aborted') 	end;  end; end;                                / * [SYSEXE.SEAS$WORK_0000005C]APPLICATION15A.PAS;1 +  ,    . 	    /     4 I   	    f                  - 
    0   1    2   3      K  P   W   O     5   6 `rUH  7 Z  8          9          G    H  J                ( MODULE dda_sample_01 [ident('V4.1-01')];   {++  {  { Abstract:  { > {	This is a sample program to show how to use DDA interface toG {	to read logical blocks off a disk which is NOT mounted.  This program * {	uses default message transfer mechanism. { G {	The program asks for the name of the disk drive.  It then establishes A {	connection with the appropriate DDA port and uses supplied DDA  2 {	interface routine to read the data off the disk. { C {	The program will then ask number of blocks to read from LBN zero. C {	It creates appropriate size message and times the data throughput  { @ {	The program will loop until number of blocks to read becomes 1D {	This will allow you to get an idea of how increasing transfer size( {	changes the available throughput rate. {  {--}     INCLUDE $dda_utility;   # PROGRAM test_dda_01(input, output);    TYPE   byte = -128..127; (   block = PACKED ARRAY [1..512] OF byte;   VAR    total_blocks : integer;    device_file : FILE of block;   msg_obj : MESSAGE;   msg_ptr : ^anytype; (   bytes_to_read, starting_LBN : integer;   data_ptr : ^anytype;   access_port : PORT; @   drive_name, remote_port_name, file_name : VARYING_STRING (32);   status, bytes_read : integer;    s_time : large_integer;    e_time : large_integer;    d_time : large_integer; "   s_time_asc : varying_string(23);"   e_time_asc : varying_string(23);"   d_time_asc : varying_string(23);   BEGIN { Main program }  *   { First create a port to talk with DDA }   create_port(access_port);   '   { Find out which drive to read from } *   write('Enter the drive name [DUA1] ? ');   readln(drive_name); /   if drive_name = '' then drive_name := 'DUA1'; -   remote_port_name := drive_name + '$ACCESS';   G  { open the device to make sure that appropriate structure are set up }   { by the device driver }       file_name := drive_name + ':';I   open(device_file, FILE_NAME := file_name, HISTORY := HISTORY$READONLY);   &   { now connect to it using the name }E   connect_circuit(access_port, DESTINATION_NAME := remote_port_name);    repeat  &   { find out how many blocks to read }%   write('How many blocks to read? ');    readln(total_blocks); &   bytes_to_read := total_blocks * 512;   starting_LBN := 0;     bytes_read := 0;  :   { create the right size message to be sent to DDA port }   create_message(msg_obj, 8 		msg_ptr::^byte_data(dda$_header_size + bytes_to_read)  		);  (   { use DDA protocall to read the disk }   GET_TIME(s_time); A   eln$disk_read(status, access_port, READ_SIZE := bytes_to_read,  A 		BLOCK_NUMBER := starting_LBN, BYTES_TRANSFERRED := bytes_read,  * 		MSG_OBJ := msg_obj, MSG_PTR := msg_ptr);   GET_TIME(e_time);   G   { calculate the data pointer AFTER the read call as the msg_ptr value    { might have changed };   data_ptr::integer := msg_ptr::integer + dda$_header_size;   ,   writeln('eln$disk_read status : ',status);B   d_time := e_time - s_time;	{ negative time means interval time }'   d_time_asc := TIME_STRING(-(d_time)); D   writeln('Time for ', bytes_read, ' byte transfer -- ',d_time_asc);I   writeln('Transfer Rate = ', bytes_read DIV (d_time::integer DIV 10000),  		' Kb/s' );  2   { delete the message and the associated buffer }   delete(msg_obj);   until total_blocks = 1;      { do the general cleanup }  "   disconnect_circuit(access_port);   delete(access_port);   close(device_file);     END; { of main program } END.                                                                                                                                                                        / * [SYSEXE.SEAS$WORK_0000005C]APPLICATION15B.PAS;1 +  ,    .     /     4 O       n                   - 
    0   1    2   3      K  P   W   O     5   6 @[n  7  ?Z  8          9          G    H  J                ( MODULE dda_sample_02 [ident('V4.1-01')];   {++  {  { Abstract:  { > {	This is a sample program to show how to use DDA interface toF {	to read a contiguous file off a disk which is mounted.  This program* {	uses default message transfer mechanism. { G {	The program asks for the name of the disk drive.  It then establishes A {	connection with the appropriate DDA port and uses supplied DDA  A {	interface routine to read/write the data off from known file on  {	that disk. { H {	This program first creates an empty contiguous file, which is defined G {	as having 512 bytes fixed length records.  It will use LOCATE service F {	to write to the last record and then closes the file.  This fills in2 {	the correct EOF marker in the file header field. { A {	This program will then re-open the file and will retrieves its  E {	file_attribute record to find the starting logical block number and  {	the size of the file.    { A {	****** ALL OF OUR I/O MUST BE LIMITED WITHIN THAT RANGE  ****** 1 {	****** OTHERWISE THE DISK WILL TRASHED.  ******  { G {	Program then writes known pattern to fill the file and then reads it  C {	back again using DDA protocal and then compares to make sure that E {	the data was successfully written.  It also prints out the read and  {	write transfer rates.  {  {--}   INCLUDE $kernelmsg, $elnmsg; INCLUDE $dda_utility;  INCLUDE $file_utility;  # PROGRAM test_dda_02(input, output);    TYPE   byte = -128..127; (   block = PACKED ARRAY [1..512] OF byte;   VAR    dda_file : FILE of blo                                                                                                                                                                                                           T $      ELN042.D                         
  /[SYSEXE.SEAS$WORK_0000005C]APPLICATION15B.PAS;1                                                                                O                             `             ck;    filesize : integer; %   attr_rec : ^FILE$ATTRIBUTES_RECORD;    fill_flag : integer;   total_blocks : integer;    msg_obj : MESSAGE;   msg_ptr : ^anytype; &   total_bytes, starting_LBN : integer;   data_ptr : ^anytype;   access_port : PORT; @   drive_name, remote_port_name, file_name : VARYING_STRING (32);   status, bytes_xfr : integer;   s_time : large_integer;    e_time : large_integer;    d_time : large_integer; "   s_time_asc : varying_string(23);"   e_time_asc : varying_string(23);"   d_time_asc : varying_string(23);  8 [inline] procedure populate_data_buffer(flag : integer); {++ H { This procedure will write an easily recoginzable pattern on each block {--} VAR    vbn, offset : integer;   pointer : ^integer;    BEGIN    FOR vbn := 1 to filesize DO 	     BEGIN        FOR offset := 1 TO 128 DO  	BEGIN           pointer::integer := < 		data_ptr::integer + ((vbn - 1) * 512 ) + (offset - 1) * 4; 	  case flag of  	    0: pointer^ := 0; 	    1: pointer^ := vbn; 	    2: if pointer^ <> vbn then  		begin 9 		  writeln('Verify failed @ VBN, offset ', vbn, offset); $ 		  raise_exception(ker$_bad_value); 		end; 	  end; { case } 	END; { for offset }     END;  { for vbn }  END; { procedure }   BEGIN { Main program }  *   { First create a port to talk with DDA }   create_port(access_port);   '   { Find out which drive to read from } *   write('Enter the drive name [DUA1] ? ');   readln(drive_name);   &   { find out how many blocks to read }%   write('Enter filesize in blocks ');    readln(filesize);   /   if drive_name = '' then drive_name := 'DUA1'; -   remote_port_name := drive_name + '$ACCESS';   9   file_name := drive_name + ':' + '[000000]dda_file.img';     { now create the file }  @   open(dda_file, FILE_NAME := file_name, HISTORY := HISTORY$NEW,3 	RECORD_LENGTH := 512, RECORD_TYPE := RECORD$FIXED,   	ACCESS_METHOD := ACCESS$DIRECT,+ 	CONTIGUOUS := TRUE, FILESIZE := filesize);   L   { locate to the last block, write to it.  this will automatically extend }   { the file to proper size }      if filesize > 0 then  	     begin !       locate(dda_file, filesize);        put(dda_file);     end;  7   { now close the file to make sure proper eof is set }       close(dda_file);  <   { now re-open the file for writing by using DDA protocal }@   open(dda_file, FILE_NAME := file_name, HISTORY := HISTORY$OLD, 	FILE_ATTRIBUTES := attr_rec 	);   G   { make sure that we got correct starting block number, otherwise, we  O   { WILL destroy the disk!  NOTE-  it will be zero if file was not contiguous }    { If so STOP immediately }  9   IF attr_rec = NIL THEN raise_exception (ker$_bad_state) 2   ELSE IF attr_rec^.starting_block_number = 0 THEN" 		raise_exception(ker$_bad_state);  *   { connect to the disk for DDA protocal }E   connect_circuit(access_port, DESTINATION_NAME := remote_port_name);       total_bytes := filesize * 512;2   starting_LBN := attr_rec^.starting_block_number;   bytes_xfr := 0;   :   { create the right size message to be sent to DDA port }   create_message(msg_obj, 6 		msg_ptr::^byte_data(dda$_header_size + total_bytes)  		);      { calculate the data pointer };   data_ptr::integer := msg_ptr::integer + dda$_header_size;   )   { Fill in the test data in our buffer }    populate_data_buffer(1);  ,   { use DDA protocall to write to the disk }   GET_TIME(s_time); A   eln$disk_write(status, access_port, WRITE_SIZE := total_bytes,  @ 		BLOCK_NUMBER := starting_LBN, BYTES_TRANSFERRED := bytes_xfr, * 		MSG_OBJ := msg_obj, MSG_PTR := msg_ptr);   GET_TIME(e_time); -   writeln('eln$disk_write status : ',status); B   d_time := e_time - s_time;	{ negative time means interval time }'   d_time_asc := TIME_STRING(-(d_time)); C   writeln('Time for ', bytes_xfr, ' byte transfer -- ',d_time_asc); O   writeln('Write Transfer Rate = ', bytes_xfr  DIV (d_time::integer DIV 10000),  		' Kb/s' );  G   { Re-calculate the data pointer as the call to eln$disk_write could } 0   { return back different msg_obj/msg_ptr pair };   data_ptr::integer := msg_ptr::integer + dda$_header_size;   G   { Before reading back the data from the disk, initialize our buffer }    populate_data_buffer(0);  +   { use DDA protocall to read to the disk }    GET_TIME(s_time); ?   eln$disk_read(status, access_port, READ_SIZE := total_bytes,  @ 		BLOCK_NUMBER := starting_LBN, BYTES_TRANSFERRED := bytes_xfr, * 		MSG_OBJ := msg_obj, MSG_PTR := msg_ptr);   GET_TIME(e_time); ,   writeln('eln$disk_read status : ',status);B   d_time := e_time - s_time;	{ negative time means interval time }'   d_time_asc := TIME_STRING(-(d_time)); C   writeln('Time for ', bytes_xfr, ' byte transfer -- ',d_time_asc); O   writeln('Read  Transfer Rate = ', bytes_xfr  DIV (d_time::integer DIV 10000),  		' Kb/s' );  F   { Re-calculate the data pointer as the call to eln$disk_read could }0   { return back different msg_obj/msg_ptr pair };   data_ptr::integer := msg_ptr::integer + dda$_header_size;   A   { verify that the data read really matches with what we wrote }    populate_data_buffer(2);     { general clean-up }   delete(msg_obj);"   disconnect_circuit(access_port);   close(dda_file);   delete(access_port);   END; { of main program } END.                                                                                                                                                                                                                                                                                                                                                                                                                                / * [SYSEXE.SEAS$WORK_0000005C]APPLICATION15C.PAS;1 +  ,    . 	    /     4 I   	                      - 
    0   1    2   3      K  P   W   O 	    5   6    7 `Z  8          9          G    H  J    
            ( MODULE dda_sample_03 [ident('V4.1-01')];   {++  {  { Abstract:  { > {	This is a sample program to show how to use DDA interface toG {	to read logical blocks off a disk which is NOT mounted.  This program < {	will show how to use system virtual address space for dataC {	transfers into specified physical memory address, such as for the 7 {	memory which is not configured into the system image.  { G {	The program asks for the name of the disk drive.  It then establishes A {	connection with the appropriate DDA port and uses supplied DDA  D {	interface routine to read the data off the disk into the specified {	physical memory. { ? {	Please note that constant pages_in_ebuild MUST match with the B {	"Memory limit" from EBUILD System Characteristic menu, otherwise) {	it will lead to unpredictable results!!  { 2 {	*** THIS PROGRAM NEEDS TO RUN IN KERNEL MODE *** { @ {	The program will loop until number of blocks to read becomes 1D {	This will allow you to get an idea of how increasing transfer size( {	changes the available throughput rate. {  {--}     INCLUDE $dda_utility;  INCLUDE $KERNEL;  # PROGRAM test_dda_03(input, output);    CONST ?   pages_in_ebuild = 6144;	{ System knows upto this many pages } B   phy_addr = pages_in_ebuild * 512; { Memory onward this physical  						address is free } B   free_pages_left = 10240 - pages_in_ebuild; { on a 5 MB machine }   TYPE   byte = -128..127; (   block = PACKED ARRAY [1..512] OF byte;   VAR    s0_addr : ^anytype;    total_blocks : integer;    device_file : FILE of block;   msg_obj : MESSAGE;   msg_ptr : ^anytype; (   bytes_to_read, starting_LBN : integer;   data_ptr : ^anytype;   access_port : PORT; @   drive_name, remote_port_name, file_name : VARYING_STRING (32);   status, bytes_read : integer;    s_time : large_integer;    e_time : large_integer;    d_time : large_integer; "   s_time_asc : varying_string(23);"   e_time_asc : varying_string(23);"   d_time_asc : varying_string(23);   BEGIN { Main program }  *   { First create a port to talk with DDA }   create_port(access_port);   '   { Find out which drive to read from } *   write('Enter the drive name [DUA1] ? ');   readln(drive_name); /   if drive_name = '' then drive_name := 'DUA1'; -   remote_port_name := drive_name + '$ACCESS';   G  { open the device to make sure that appropriate structure are set up }   { by the driver }      file_name := drive_name + ':';I   open(device_file, FILE_NAME := file_name, HISTORY := HISTORY$READONLY);   &   { now connect to it using the name }E   connect_ci                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          W/ $      ELN042.D                         
  /[SYSEXE.SEAS$WORK_0000005C]APPLICATION15C.PAS;1                                                                                I    	                         ,             rcuit(access_port, DESTINATION_NAME := remote_port_name);   <   { create the DDA header message to be sent to DDA port }     create_message(msg_obj, ( 		 msg_ptr::^byte_data(dda$_header_size) 		); repeat    &   { find out how many blocks to read }%   write('How many blocks to read? ');    readln(total_blocks);   &   bytes_to_read := total_blocks * 512;   starting_LBN := 0;     bytes_read := 0;  *   { allocate the necessary system region }7   ker$allocate_system_region(, s0_addr, bytes_to_read,   				PHYSICAL := phy_addr );       { calculate the data pointer }   data_ptr := s0_addr;  (   { use DDA protocall to read the disk }   GET_TIME(s_time); A   eln$disk_read(status, access_port, READ_SIZE := bytes_to_read,  A 		BLOCK_NUMBER := starting_LBN, BYTES_TRANSFERRED := bytes_read,  ) 		MSG_OBJ := msg_obj, MSG_PTR := msg_ptr,  		SYS_REG_ADDR := s0_addr);    GET_TIME(e_time); ,   writeln('eln$disk_read status : ',status);B   d_time := e_time - s_time;	{ negative time means interval time }'   d_time_asc := TIME_STRING(-(d_time)); D   writeln('Time for ', bytes_read, ' byte transfer -- ',d_time_asc);I   writeln('Transfer Rate = ', bytes_read DIV (d_time::integer DIV 10000),  		' Kb/s' );  "   { deallocate the system region }1   ker$free_system_region(,bytes_to_read,s0_addr);    until total_blocks = 1;      { general cleanup }    delete(msg_obj);"   disconnect_circuit(access_port);   close(device_file);    delete(access_port);    END; { of main program } END.                                                        . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION2A.PAS;1 +  ,    .     /     4 ;                           - 
    0   1    2   3      K  P   W   O     5   6 `VGX  7  |Z  8          9          G    H  J     
             module initial_job1;   {++  {  { Abstract:  { 9 {	This module contains the first job (named INITIAL_JOB1) 7 {	of a two-job system designed to show two jobs passing 5 {	data back and forth via the SEND and RECEIVE kernel . {	services on a circuit based on a named port. {  {--}   {  {	Job-wide declarations. {}   var  	io_port: port;  	data_message: message;  	identifier: name;" 	string_data: ^varying_string(32); 	done: boolean := false;   program initial_job1;    {++  {  { Functional description:  { 5 {	This program creates a port with an associated name 4 {	of 'INITIAL_JOB_PORT' as part of an initialization	 {	action.  { 4 {	After the initialization is performed, the program5 {	simply waits for incoming messages (in ASCII) to be 5 {	received via a circuit established on that port. It 6 {	transmits the data back to the sender, stripping off4 {	the first and last characters, until it receives a7 {	message with the value '***END***', which causes this  {	program to terminate.  { 	 { Inputs:  { 7 {	Incoming ASCII string messages directed to the global   {	port named 'INITIAL_JOB_PORT'. { 
 { Outputs: { 7 {	All incoming data is retransmitted back to the sender ; {	with the first and last characters removed from the data.  {  {--}   begin    {  {	Initialization section:  { 1 {	Create the port and "name it" INITIAL_JOB_PORT.  {}   create_port(io_port); 5 create_name(identifier, 'INITIAL_JOB_PORT', io_port);  initialization_done;   { 3 {	Wait here to accept the incoming circuit request.  {}   accept_circuit(io_port);2 writeln('Job INITIAL_JOB1 accepted the circuit.');   { 0 {	Loop for each message received and process it. {}   while not done do  	begin   	{1 	{	Wait for a message to arrive on the port. When / 	{	arrives, receive the message and output it's ( 	{	contents to the standard output file. 	{}    	wait_any(io_port); - 	receive(data_message, string_data, io_port); ' 	writeln('Job INITIAL_JOB1 received "',  		string_data^,  		'".');   	if string_data^ = '***END***' 	then  		done := true 	else  		begin * 		string_data^ := substr(string_data^,  2,# 				       length(string_data^)-2);  		send(data_message, io_port)  		end; 	end;   # writeln('Job INITIAL_JOB1 exited.')  end; end;                                                                                                                                                                                                                                                                                                            . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION2B.PAS;1 +  ,    .     /     4 C                           - 
    0   1    2   3      K  P   W   O     5   6 s|)GX  7 	Z  8          9          G    H  J     
             module initial_job2;   {++  {  { Abstract:  { : {	This module contains the second job (named INITIAL_JOB2)7 {	of a two-job system designed to show two jobs passing 5 {	data back and forth via the SEND and RECEIVE kernel . {	services on a circuit based on a named port. {  {--}   {  {	Job-wide declarations. {}   var  	io_port: port;  	data_message: message; " 	string_data: ^varying_string(32); 	done: boolean := false;   program initial_job2;    {++  {  { Functional description:  { 1 {	This program starts a message dialogue with job 1 {	INITIAL_JOB1. The messages transmitted back and   {	forth start out as the string: {  {		'**********END**********' { 5 {	which is whittled down by INITIAL_JOB1 to the final 3 {	string '***END***' by deleting the first and last 6 {	characters of the messages received by INITIAL_JOB1. { 5 {	This program initially connects the circuit between 8 {	the two jobs and loops transmitting data and receiving, {	the modified data back for retransmission. { 	 { Inputs:  { 6 {	ASCII string messages directed from INITIAL_JOB1 via$ {	its port named 'INITIAL_JOB_PORT'. { 
 { Outputs: { 7 {	All incoming data is retransmitted back to the sender  {	without modification.  {  {--}   begin    { 3 {	Create the message packet and initialize the data 	 {	string.  {}  * create_message(data_message, string_data);* string_data^ := '**********END**********';   { 1 {	Create a port and connect to the other program.  {}   create_port(io_port); A connect_circuit(io_port, destination_name := 'INITIAL_JOB_PORT'); C writeln('Job INITIAL_JOB2 connected circuit to INITIAL_JOB_PORT.');    { 8 {	Loop transmitting and receiving data until '***END***'
 {	is seen. {}   while not done do  	begin& 	done := (string_data^ = '***END***'); 	send(data_message, io_port);    	if not done 	then  		begin    		{ & 		{	Wait for the modified string to be+ 		{	sent back to our port. When it arrives, * 		{	receive it and output it's contents to 		{	the standard output file.  		{}   		wait_any(io_port);. 		receive(data_message, string_data, io_port);( 		writeln('Job INITIAL_JOB2 received "', 			string_data^, 			'".') 		end; 	end;   # writeln('Job INITIAL_JOB2 exited.')  end; end;                                                                                                                                                                                                                                                                                                                                        + * [SYSEXE.SEAS$WORK_0000005C]APPLICATION3.C;1 +  ,    .     /     4 C       &                   - 
    0   1    2   3      K  P   W   O     5   6 @5GX  7  Z  8          9          G    H  J                     #include $disk_utility #include $file_utility #include descrip #include stdio     /*  *  * Abstract:  *8  *	This example shows typical calls to the disk and file'  *	utility procedures from a C program.   *8  *	WARNING	 -  This program initializes the disk mounted2  *	in the drive named by the preprocessor constant8  *	'TARGET_DRIVE' defined below. No warning of this fact6  *	is given and the device must be readied for writing!  *	before the program is started.   *=  *	NOTE	- This program was designed to work with an RX50 type 5  *		  drive.  To run this program using an RDxxx type 9  *		  drive you may need to change the target_drive name. ?  *		  You will need to make certain that the verified parameter .  *		  in the call to eln$init_volume is FALSE.  */    /*  *	Preprocessor definitions:  */    #ifndef TARGET_DRIVE7 #define TARGET_DRIVE "DUA1:"	/* Default drive to use */  #endif     /*"  *	File specification definitions:  */   * #define DIRECTORY "DISK$SAMPLE:[TEST_DIR]"8 #define DATA                                                                                                                                                                                                                                                                                                                                                                                                                  	                        I' $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]APPLICATION3.C;1                                                                                    C                              90             FILE  "DISK$SAMPLE:[TEST_DIR]TEST_FILE.DAT;"@ #define COPYFILE  "DISK$SAMPLE:[TEST_DIR]TEST_COPY_FILE.DAT;100"C #define COPYFILE2 "DISK$SAMPLE:[TEST_DIR]TEST_RENAME_FILE.DAT;1234"      /*:  *	Define shorthand versions of volume and file protection	  *	masks:   */    #define RWED	(DSK$M_READ |				\  		 DSK$M_WRITE |				\  		 DSK$M_EXEC |				\ 		 DSK$M_DELETE) #define R	(DSK$M_READ) #define RE	(DSK$M_READ |				\  		 DSK$M_EXEC)  , #define NOGROUP	((FILE$DENY_READ_ACCESS		|	\ 		  FILE$DENY_WRITE_ACCESS	|	\  		  FILE$DENY_EXECUTE_ACCESS	|	\+ 		  FILE$DENY_DELETE_ACCESS) << FILE$GROUP)      /*(  *	VARYING_STRING constant declarations:  */   1 VARYING_STRING_CONSTANT(drive_name,TARGET_DRIVE); * VARYING_STRING_CONSTANT(dir_fs,DIRECTORY);* VARYING_STRING_CONSTANT(data_fs,DATAFILE);* VARYING_STRING_CONSTANT(copy_fs,COPYFILE);, VARYING_STRING_CONSTANT(copy_fs2,COPYFILE2);A VARYING_STRING_CONSTANT(search_fs,"DISK$SAMPLE:[TEST_DIR]*.*;*"); ) VARYING_STRING_CONSTANT(username,"USER"); ) VARYING_STRING_CONSTANT(volume,"SAMPLE");      /*4  *	Define a macro used to output VARYING_STRING data	  *	items:   */   + #define PRINT_VARYING(text1, vs, text2)			\ 4 	printf("%s%.*s%s", text1, vs.count, vs.data, text2)   /*  *  * Routine description:   **  *	This code performs the following steps:  *5  *	    1.	The target disk is initialized with label = 
  *		"SAMPLE".   *	    2.	The disk is mounted.:  *	    3.	The directory [TEST_DIR] is created on the disk.7  *	    4.	Ten datafiles named [TEST_DIR]TEST_FILE.DAT;*   *		are written to the disk.1  *	    5.	[TEST_DIR]TEST_FILE.DAT;10 is copied to %  *		[TEST_DIR]TEST_COPY_FILE.DAT;100. 8  *	    6.	[TEST_DIR]TEST_COPY_FILE.DAT;100 is renamed to(  *		[TEST_DIR]TEST_RENAME_FILE.DAT;1234.4  *	    7.	The file created in step 6 is typed on the  *		console.7  *	    8.	[TEST_DIR]TEST_FILE.DAT;9 has it's protection (  *		changed to exclude all GROUP access.7  *	    9.	Eln$directory_open and eln$directory_list are 4  *		used to visit all files in [TEST_DIR]. Each file  *		visited is deleted. "  *	    10.	The disk is dismounted.  *  */    main() {    DSK$_BADBLOCK		bad_blocks[2]; / DSK$_BADLIST		bad_block_list = {2,&bad_blocks};  char			buffer[132];  ELN$DIR_FILE		*directory; " FILE$ATTRIBUTES_RECORD	*file_attr; FILE			*fp; 6 VARYING_STRING(255)	delete_fs,old_fs,new_fs,dirtmp_fs; int			status,i,j;    /*5  *	Initialize imaginary bad block information to mark 4  *	LBNs 100-119 and 222-231 inclusive as bad blocks.  *  */   + bad_blocks[0].type.logical.start_lbn = 100; * bad_blocks[0].type.logical.lbn_count = 20;! bad_blocks[0].pbn_format = FALSE;   + bad_blocks[1].type.logical.start_lbn = 222; * bad_blocks[1].type.logical.lbn_count = 10;! bad_blocks[1].pbn_format = FALSE;      /*3  *	1.  Initialize the disk using reasonable values:   */   1 eln$init_volume(&drive_name,	/* device name				*/  		&volume,	/* volume name				*/  		5,		/* default extension			*/  		&username,	/* username				*/ 		0x00010001,	/* owner				*/ 				/* volume protection			*/  				/* [RWED,RWED,RWED,]			*/  		&~( RWED<<DSK$V_SYSTEM | 		    RWED<<DSK$V_OWNER  | 		    RWED<<DSK$V_GROUP),  				/* default file prot.			*/ 				/* [RWED,RWED,RE,]			*/  		&~( RWED<<DSK$V_SYSTEM | 		    RWED<<DSK$V_OWNER  | 		    RE	<<DSK$V_GROUP),  				/* default record prot.			*/ 				/* [RWED,RWED,R,]			*/ 		&~( RWED<<DSK$V_SYSTEM | 		    RWED<<DSK$V_OWNER  | 		    R	<<DSK$V_GROUP), " 		3,		/* accessed directories 		*/ 		0,		/* maximum files			*/  		0,		/* user_directories			*/ 		0,		/* file headers				*/  		7,		/* windows				*/ 		0,		/* cluster size				*/ % 		DSK$_MIDDLE,	/* index position			*/ # 		DSK$_NOCHECK,	/* data check				*/  		TRUE,		/* share				*/  		FALSE,		/* group				*/ 		TRUE,		/* system				*/3 		TRUE,		/* verified, FALSE for RDxxx type drives*/ ! 		&bad_block_list,/* bad list		*/  		NULL);		/* status		*/   = PRINT_VARYING("Initialized disk in drive '", drive_name,"'"); 3 PRINT_VARYING(" as volume name '", volume, "'.\n");    /*  *	2.  Now mount the disk:  */    eln$mount_volume(&drive_name,  		 &volume, 	 		 NULL);    printf("Mounted disk.\n\n");   /*.  *	3.  Create the directory used by this test:  */    	eln$create_directory(&dir_fs,
 			     NULL,  			     0x00010001,  			     &new_fs, 			     NULL);  6 	PRINT_VARYING("Created directory '", new_fs, "'.\n");   /*9  *	4.  Create a series of simple text files with the same 8  *	    filename and file type, but with versions ranging  *	    from 1 through 10.   *8  *	    The number of records in each file is the same as7  *	    the file version number. Each record consists of /  *	    the record number from 0 to version - 1.   *  */    for(i = 1; i <= 10; i++) 	{ 	fp = fopen(DATAFILE, "w");  	for(j = 0; j < i; j++)  		fprintf(fp, "%d\n", j);  	fclose(fp);( 	printf("Created %s%d.\n", DATAFILE, i); 	}   /**  *	5.  Copy the last file to another file:  */    eln$copy_file(&data_fs,  	      &copy_fs, 	      NULL, 	      NULL, 	      NULL, 	      NULL, 	      &old_fs,  	      &new_fs,  	      NULL,
 	      NULL);   , PRINT_VARYING("\nCopied\t'", old_fs, "'\n");' PRINT_VARYING("to\t'", new_fs, "'.\n");    /*#  *	6.  Rename the file just copied:   */    eln$rename_file(&copy_fs,  		&copy_fs2, 		NULL, 
 		&old_fs,
 		&new_fs, 		NULL,  		NULL);  + PRINT_VARYING("Renamed\t'", old_fs, "'\n"); ) PRINT_VARYING("to\t'", new_fs, "'.\n\n");      /*7  *	7.  Open the renamed file for reading and type it on   *	    the console:   */    fp = fopen(COPYFILE2, "r"); 0 while(fgets(buffer, sizeof(buffer), fp) != NULL)/ 	printf("Contents of data file =\t%s", buffer);  fclose(fp);    /*7  *	8.  Protect the highest version of data file against   *	    all group access:  */    eln$protect_file(&data_fs, 		 NULL, 		 &NOGROUP, 		 NULL, 		 &new_fs, 	 		 NULL);   = PRINT_VARYING("\nChanged protection of '", new_fs, "'.\n\n");    /*3  *	9.  Start a directory listing of this directory:   */   * directory = calloc(1, sizeof(*directory));* file_attr = calloc(1, sizeof(*file_attr));   eln$directory_open(&directory, 		   &search_fs,
 		   &new_fs,  		   &dirtmp_fs,
 		   NULL,
 		   NULL, 		   &file_attr);    /*7  *	Loop for each file in the directory and delete them:   */    for(;;)  	{ 	eln$directory_list(&directory,  			   &dirtmp_fs,  			   &new_fs, 			   &status, 			   &file_attr); 	if (!(status&1))  		break;   	/* - 	 *	Concatenate volume + directory + filename  	 */  * 	delete_fs.count = sprintf(delete_fs.data, 				   "DISK$SAMPLE:%.*s%.*s", 				   dirtmp_fs.count,  				   dirtmp_fs.data, 				   new_fs.coun             t, 				   new_fs.data);  1 	eln$delete_file(&delete_fs, NULL, &new_fs,NULL); , 	PRINT_VARYING("Deleted '", new_fs, "'.\n"); 	}   /*  *	10.  Dismount the disk:  */   ' eln$dismount_volume(&drive_name, NULL); # printf("Dismounted the disk.\n\n");   ! printf("End of sample program.");    }                                                                                                                                                                                                                                         - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION3.PAS;1 +  ,     .     /     4 8                           - 
    0   1    2   3      K  P   W   O     5   6 W>GX  7 Z  8          9          G    H  J                   module mutex_test;   { 0 {	This module demonstrates the use of mutexes to3 {	synchronize two processes writing to the console.  {}   include  	$mutex;   const 8 	write_limit = 10;	{ Writes performed by each process. }   var 
 	gate: mutex;    program test(input,output);    var ( 	first_process, second_process: process;   begin    { 4 {	Create the mutex and the processes. Lock the mutex5 {	as soon as it's created so that both of the created , {	subprocesses will be forced to wait on it. {}   create_mutex(gate);  lock_mutex(gate); . create_process(first_process, two_flavors, 1);/ create_process(second_process, two_flavors, 2); ) write('Hit <CR> to start the program: ');  readln;    { 2 {	Now, start up the two processes by unlocking the6 {	mutex and wait until they are both finished to exit. {}   unlock_mutex(gate); & wait_all(first_process,second_process) end.  3 process_block two_flavors(process_number: integer);    { 1 {	This is the process that will be created in two / {	different versio                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                         h: $      ELN042.D                          
  -[SYSEXE.SEAS$WORK_0000005C]APPLICATION3.PAS;1                                                                                  8                                           ns. One version will have the 1 {	value 1 for process_number, the	other will have ! {	the value 2 for this parameter.  {}   var  	process_name: string(3);  	write_count: integer := 0;    begin    { . {	Loop once to write a message to the console. {}  " while write_count < write_limit do 	begin   	{ 	{	Wait on the mutex.  	{}    	lock_mutex(gate);   	{ 	{	Write the message.  	{}    	if (process_number = 2) 	then  		begin  		process_name := 'two'; 		write(' ':30)  		end  	else  		process_name := 'one';  0 	writeln('This is from process ', process_name);  	write_count := write_count + 1;   	{, 	{	Unlock the gate so that the other process 	{	can continue. 	{}    	unlock_mutex(gate)  	end;  end; end;                                                                                                                                                                                                                                                                                                                - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION4.PAS;1 +  , ;   .     /     4 <       @                    - 
    0   1    2   3      K  P   W   O     5   6 CGX  7 @+Z  8          9          G    H  J                   module timer_test;   { < {	This module demonstrates the use of the ELN time routines. {}   var 8 	elapsed_time, actual_time, current_time: large_integer; 	result: integer;  	time_rec: time_record; # 	a_time_string: varying_string(80); ) 	elapsed_time_string: varying_string(12);    program timer(input,output);   var  	i: integer;   begin  writeln('Program starting');   {  {	Set the date and time. {}  ( write('Enter today''s date and time: '); readln(a_time_string);* current_time := time_value(a_time_string); set_time(current_time); + writeln('The date and time have been set');    { ; {	Use the time_fields function to convert current_time back  {	to a string. {}  & time_rec := time_fields(current_time); with time_rec do. writeln(day:1, '/', month:1, '/', year:1, ' ',9 	hour:2, ':', minute:2, ':', second:2, '.', hundredth:2);    { 6 {	Loop five times to display the time every 5 seconds. {}   for i := 1 to 5 do 	begin   	{# 	{	Set up for a delay of 5 seconds.  	{}   % 	elapsed_time := time_value('0 ::5');  	get_time(actual_time);    	{ 	{	Wait for 5 seconds to go by.  	{}   2 	wait_any(time := elapsed_time, status := result); 	get_time(current_time);   	{2 	{	Compute the elapsed time and display the actual 	{	and elapsed time. 	{}   , 	elapsed_time := current_time - actual_time;, 	a_time_string := time_string(elapsed_time);2 	elapsed_time_string := substr(a_time_string, 12);; 	writeln('The actual time was ', time_string(actual_time)); 	 	writeln; 6 	writeln('The elapsed time is ', elapsed_time_string);	 	writeln;  	writeln 	end;  end; end.                                                                                                                                                                                                                                                                                                                                                                                                                                                                              - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION5.PAS;1 +  , <   .     /     4 ?                           - 
    0   1    2   3      K  P   W   O     5   6 AHGX  7 [  8          9          G    H  J                   module time_req_test;    { 8 {	This is an ELN application that initiates a connection8 {	with a .COM file on a remote VMS system to request the# {	time of day.  Note the following:  { ; {	A.  Change 10.172 to whatever the node address of the VMS  {	    system is.; {	B.  The command procedure time.com must be present in the : {	    default decnet directory of the machine running VMS. {}   var  	this_port: port;  	this_message: message;  	these_data: ^string(32);  	actual_time: string(32);  	current_time: large_integer;   $ program time_request(input, output);   begin    { 9 {	First, create the port that will be used to communicate  {	with the VMS system. {}   create_port(this_port);    { 6 {	Executing the connect_circuit causes TIME.COM in the7 {	default DECnet directory on the VMS system to be run. < {	10.172 is the number of the node on which VMS was running." {	TIME.COM itself looks like this: {  {	$ open /write fred sys$net {	$ time = f$time()  {	$ write fred time  {	$ close fred {}  ? connect_circuit(this_port, destination_name := '10.172::time'); ' writeln('Connected to the VMS system');  wait_any(this_port);   { * {	Read in the message and then display it. {}  - receive(this_message, these_data, this_port); / writeln('The message was "', these_data^, '"');  disconnect_circuit(this_port);   { / {	Set the time to and then get the time just to * {	double check that everything worked O.K. {}  * actual_time := substr(these_data^, 1, 23);( current_time := time_value(actual_time); set_time(current_time);  get_time(current_time); ) actual_time := time_string(current_time); - writeln('The current time is ', actual_time);  writeln('Done')    end. end;                                                                                                                                                                                                                                                                                                                                                                , * [SYSEXE.SEAS$WORK_0000005C]APPLICATION6A.C;1 +  , =   .     /     4 >                          - 
    0   1    2   3      K  P   W   O     5   6  PGX  7  \?[  8          9          G    H  J       
             #module multiple_circuit   #include $vaxelnc  #include ctype #include descrip   /*  *  * Abstract:  *:  *	This module shows an example of how a typical server is:  *	implemented using an individual process to service each7  *	incoming circuit request to the server's global port :  *	named 'SERVER$PORT'.  It is intended to demonstrate how9  *	the master process dispatches incoming circuit request '  *	to the subordinate server processes.   *  */    /*  *	Job-wide declarations.   */    LARGE_INTEGER timeout_interval;    multiple_circuit() {    /*  * Functional description:  *8  *	This is the master process for the server example. It<  *	simply listens for circuit requests from remote processes3  *	and creates a subprocess to handle each request.   *
  * Inputs:  *:  *	Incoming circuit connection requests to the global port  *	named 'SERVER$PORT'.   *  * Outputs:   *=  *	All incoming requests are handled by creating a subprocess   *	to accomplish each request.  *  */    /*.  *	Master-process-local variable declarations.  */    PORT	*circuit_port;  NAME	global_port_name; PORT	master_process_job_port; . static	$DESCRIPTOR(server_name,"SERVER$PORT"); void	server$process(); int	status; 6 static	$DESCRIPTOR(timeout_string,"   0 00:10:00.00"); PROCESS	subprocess;    /*=  *	M A S T E R   P R O C E S S   I N I T I A L I Z A T I O N:   *7  *	Begin by creating a name for this job's port. If the 9  *	name already exists, there is already a server process    *	in existence, so simply exit.  */   - ker$job_port(NULL, &master_process_job_port);    ker$create_name(&status, 		&global_port_name,     		&server_name,      		&master_process_job_port,      		NAME$UNIVERSAL);   if (!(status&1)) 	ker$exit(NULL, 1);    /*<  *	Compute ten minute timeout constant used by subprocesses.  */   3 timeout_interval = eln$time_value(&timeout_string);      /*8  *	The initialization is done - inform ELN of that fact.  */    ker$initialization_done(NULL);  9 /*	M A S T E R   P R O C E S S   M A I N L I N E	C O D E:   *:  *	Loop indefinitely waiting for a remote circuit request.<  *	When one is received, create a port to handle the circuit4  *	and try to establish the circuit with the sender.  *;  *	If the circuit can be established, then create a process ;  *	to service this circuit and pass this newly created port !  *	to the process as a parameter.   *:  *	If the circuit cannot be established,then simply delete;  *	the new port and continue looping, waiting for requests.   *  */    for(;;)                                                                                                                                                                                                                                                                                                                                                                                                                                           k $      ELN042.D                       =  
  ,[SYSEXE.SEAS$WORK_0000005C]APPLICATION6A.C;1                                                                                   >                              {?              	{   	/* * 	 *	Wait for any requests on the job port. 	 */  : 	ker$wait_any(NULL, NULL, NULL, &master_process_job_port);   	/* 3 	 *	Allocate a new port and create the port object.  	 */  ( 	circuit_port = calloc(1,sizeof (PORT));( 	ker$create_port(NULL, circuit_port, 4);   	/* ) 	 *	Setup the circuit using the new port.  	 */   	ker$accept_circuit(&status, 			   &master_process_job_port,  			   circuit_port,  			   FALSE, 			   NULL,  			   NULL); 	if (status&1) 		{    		/*& 		 *	Start the server process and pass 		 *	it the circuit port.  		 */    		ker$create_process(NULL, 				   &subprocess,  				   server$process, 				   NULL, 				   circuit_port);    		/*. 		 *	Note that it is now the responsibility of- 		 *	the subprocess to delete the port object / 		 *	and deallocate the port variable memory at , 		 *	the completion of the server's dialogue, 		 *	with the remote application. Of course,, 		 *	this housecleaning must also be done if0 		 *	the circuit is broken due to error as well. 		 ** 		 *	Now lower the process priority of the, 		 *	created subprocess to be just BELOW the) 		 *	priority of the master process. This % 		 *	ensures that none of the spawned ) 		 *	subprocesses ever prevent the master 0 		 *	process from servicing connection requests. 		 */   0 		ker$set_process_priority(NULL, subprocess, 9); 		}  	else  		{    		/*/ 		 *	The connect failed - delete and deallocate  		 *	the PORT. 		 */   ! 		ker$delete(NULL, circuit_port);  		cfree(circuit_port); 		}  	} }   5 void server$process(circuit_port) PORT *circuit_port;  {    /*0  *	S U B P R O C E S S   M A I N L I N E	C O D E  *  * Routine description:   *9  *	This is the entry routine for a separate process which 7  *	is created to handle an incoming connection request.   *7  *	In this example, the service performed by the server 8  *	and the protocol observed by the two circuit partners5  *	is vastly simplified to keep the example small and   *	understandable.  *<  *	The protocol is simple:	 Messages containing text strings9  *	are sent from the "application" (the other half of the 6  *	circuit) to this process (the "server"). The server9  *	processes each message by converting all the lowercase 8  *	letters in the string to uppercase and then transmits>  *	the converted text back to the application. The application7  *	sends a record consisting of the null string ('') to   *	terminate the exchange.  *7  *	A receive timeout is built into this server to add a 8  *	little realism to a contrived example. If the timeout5  *	expires, the server abandons the circuit as if the 3  *	exchange had been terminated normally. In a real 7  *	application, some further application-specific error 8  *	processing, such as printing a diagnostic, would most  *	likely occur.  *
  * Inputs:  *=  *	circuit_port - Circuit which request has been accepted on.   *  * Outputs:   *#  *	The incoming request is handled.   *  */    /*'  *	Process-local variable declarations.   */    BOOLEAN			done = FALSE; ( int			i,status,wait_result,message_size; MESSAGE			message_id;   VARYING_STRING(80)	*message_ptr;   /*  *	Loop until:  *  *		Receive timeout occurs, or  *		Receive error occurs, or*  *		Null string received from application.  *  */    while(!done) 	{   	/* # 	 *	Wait for the port or a timeout.  	 */   	ker$wait_any(NULL,  		     &wait_result, 		     &timeout_interval,  		     circuit_port);    	/* 1 	 *	If the result of the wait service was 0, then 1 	 *	the reason the wait terminated was because of  	 *	a timeout. 	 */   	if (wait_result == 0) 		done = TRUE; 	else  		{    		/** 		 *	Otherwise, a message has been sent to# 		 *	the port. Receive the message.  		 */    		ker$receive(&status, 			    &message_id,  			    &message_ptr, 			    &message_size,  			    circuit_port, 			    NULL,
 			    NULL);  		if (!(status&1)) 			done = TRUE;  		else 			{ 			if (message_ptr->count == 0)  				done = TRUE; 			else  				{    				/*# 				 *	A non-zero length string has # 				 * 	successfully been received.  				 *	Uppercase the string. 				 */   ' 				for(i=0; i<message_ptr->count; i++)  				  message_ptr->data[i] =' 				    _toupper(message_ptr->data[i]);  				ker$send(NULL, 					 message_id,  					 message_size,  					 circuit_port,  					 NULL, 
 					 FALSE);  				}  			} 		}  	}   /*<  *	The exchange has terminated - delete the port, deallocate#  *	the local port storage and exit.   */    ker$delete(NULL, circuit_port);  cfree(circuit_port);   }                                         , * [SYSEXE.SEAS$WORK_0000005C]APPLICATION6B.C;1 +  , >   .     /     4 @                           - 
    0   1    2   3      K  P   W   O     5   6 +UGX  7 @Z[  8          9          G    H  J       
             #module multiple_circuit_sender    #include $vaxelnc  #include descrip #include stdio   /*  *  * Abstract:  *;  *	This module shows an example of a simple terminal-driven ;  *	application that makes use of the server example program   *	described above.   *<  *	The application reads a line from the terminal and passes<  *	the line to the server for processing. The processed line:  *	is read back from the server and typed at the terminal.  *<  *	The process continues until the user enters a blank line,9  *	which is the protocol established in the server as the   *	"end-of-dialogue" marker.  *  */    multiple_circuit_sender()  {    /*  *	Variable declarations.   */    PORT			circuit_port;6 static 			$DESCRIPTOR(destination_name,"SERVER$PORT"); int			discard; BOOLEAN			done = FALSE;  MESSAGE			message_id;   VARYING_STRING(80)	*message_ptr;   /*<  *	Start by connecting our job port to the sample server via;  *	its universal name 'SERVER$PORT'. On error, exit the job   *	with appropriate status.   */   " ker$job_port(NULL, &circuit_port); ker$connect_circuit(NULL,  		    &circuit_port, 		    NULL,  		    &destination_name, 		    FALSE, 		    NULL,  		    NULL);   /*#  *	Print the prompt for user input.   */   % printf("\nEnter your input data.\n"); ; printf("Terminate your input by entering a blank line.\n");    /*>  *	Loop for each non-blank line entered. Send it to the server@  *	for processing and read it back from the server and print it.  */    while(!done) 	{ 	ker$create_message(NULL,  			   &message_id, 			   &message_ptr,  			   sizeof (*message_ptr));  	gets(message_ptr->data); 0 	message_ptr->count = strlen(message_ptr->data); 	if (message_ptr->count == 0)  		done = TRUE;   	ker$send(NULL,  		 message_id, 		 sizeof (*message_ptr),  		 &circuit_port,  		 NULL,
 		 FALSE);   	if (!done)  		{  		ker$wait_any(NULL, 			     &discard, 
 			     NULL,  			     &circuit_port);  		ker$receive(NULL,  			    &message_id,  			    &message_ptr, 			    &discard, 			    &circuit_port,  			    NULL,
 			    NULL);  		printf("%.*s\n", 		       message_ptr->count, 		       message_ptr->data); 		}  	} }                                                                                                                                                                                                                                                                                                                                                                                         . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION6C.PAS;1 +  , ?   .     /     4 =                           - 
    0   1    2   3      K  P   W   O     5   6 `ZGX  7 `z[  8          9          G    H  J                  module multiple_circuit;   {++  {  {  { Abstract:  { 9 {	This module shows an example of how a typical server is 9 {	implemented using an individual process to service each 6 {	incoming circuit request to the server's global port9 {	named 'SERVER$PORT'.  It is intended to demonstrate how 8 {	the master process dispatches incoming circuit request& {	to the subordinate server processes. {  {  {--}   {  {	Job-wide declarations. {}   var ! 	timeout_interval: large_integer;    program multiple_circuit;    {++  {  { Functional description:  { 7 {	This is the master process for the server example. It ; {	simply listens for circuit requests from remote processes 2 {	and creates a subprocess to handle each request. { 	 { Inputs:  { 9 {	Incoming circuit connection requests to the global port  {	named 'SERVER$PORT'. { 
 { Outputs: { < {	All incoming requests are handled by creating a subprocess {	to accomplish each request.  {  {--}   { - {	Master-process-local variable declarations.  {}                                                                                                                                                                                                             sI $      ELN042.D                       ?  
  .[SYSEXE.SEAS$WORK_0000005C]APPLICATION6C.PAS;1                                                                                 =                              6              var  	master_process_job_port: port;  	circuit_port: ^port;  	global_port_name: name; 	status: integer;  	subprocess: process;  begin    { < {	M A S T E R   P R O C E S S   I N I T I A L I Z A T I O N: { 6 {	Begin by creating a name for this job's port. If the8 {	name already exists, there is already a server process {	in existence, so simply exit.  {}  " job_port(master_process_job_port);   create_name(global_port_name,  	    'SERVER$PORT',  	    master_process_job_port,  	    table := name$universal,  	    status := status);    if not odd(status) then 	exit(exit_status := 1);   { ; {	Compute ten minute timeout constant used by subprocesses.  {}  3 timeout_interval := time_value('   0 00:10:00.00');      { 7 {	The initialization is done - inform ELN of that fact.  {}   initialization_done;   { 8 {	M A S T E R   P R O C E S S   M A I N L I N E	C O D E: { 9 {	Loop indefinitely waiting for a remote circuit request. ; {	When one is received, create a port to handle the circuit 3 {	and try to establish the circuit with the sender.  { : {	If the circuit can be established, then create a process: {	to service this circuit and pass this newly created port  {	to the process as a parameter. { 9 {	If the circuit cannot be established,then simply delete : {	the new port and continue looping, waiting for requests. {  {}  
 while true do  	begin   	{) 	{	Wait for any requests on the job port.  	{}   # 	wait_any(master_process_job_port);    	{2 	{	Allocate a new port and create the port object. 	{}    	new(circuit_port); ' 	create_port(circuit_port^,limit := 4);    	{( 	{	Setup the circuit using the new port. 	{}   ( 	accept_circuit(master_process_job_port," 		       connect := circuit_port^, 		       status := status);    	if odd(status)  	then  		begin    		{ ( 		{	Start the server process and pass it 		{	the circuit port.  		{}   		create_process(subprocess, 			       server$process,  			       circuit_port);   		{ - 		{	Note that it is now the responsibility of , 		{	the subprocess to delete the port object. 		{	and deallocate the port variable memory at+ 		{	the completion of the server's dialogue + 		{	with the remote application. Of course, + 		{	this housecleaning must also be done if / 		{	the circuit is broken due to error as well.  		{ ) 		{	Now lower the process priority of the + 		{	created subprocess to be just BELOW the ( 		{	priority of the master process. This$ 		{	ensures that none of the spawned( 		{	subprocesses ever prevent the master/ 		{	process from servicing connection requests.  		{}  % 		set_process_priority(subprocess, 9)  		end  	else  		begin    		{ . 		{	The connect failed - delete and deallocate
 		{	the PORT.  		{}   		delete(circuit_port^); 		dispose(circuit_port)  		end  	end;  end.  2 process_block server$process(circuit_port: ^port);   { / {	S U B P R O C E S S   M A I N L I N E	C O D E  {  { Routine description: { 8 {	This is the entry routine for a separate process which6 {	is created to handle an incoming connection request. { 6 {	In this example, the service performed by the server7 {	and the protocol observed by the two circuit partners 4 {	is vastly simplified to keep the example small and {	understandable.  { ; {	The protocol is simple:	 Messages containing text strings 8 {	are sent from the "application" (the other half of the5 {	circuit) to this process (the "server"). The server 8 {	processes each message by converting all the lowercase7 {	letters in the string to uppercase and then transmits = {	the converted text back to the application. The application 6 {	sends a record consisting of the null string ('') to {	terminate the exchange.  { 6 {	A receive timeout is built into this server to add a7 {	little realism to a contrived example. If the timeout 4 {	expires, the server abandons the circuit as if the2 {	exchange had been terminated normally. In a real6 {	application, some further application-specific error7 {	processing, such as printing a diagnostic, would most  {	likely occur.  { 	 { Inputs:  { < {	circuit_port - Circuit which request has been accepted on. { 
 { Outputs: { " {	The incoming request is handled. {  {--}   { & {	Process-local variable declarations. {}   var  	done: boolean := false; 	status, wait_result: integer; 	message_id: message; " 	message_ptr: ^varying_string(80);   begin    { 
 {	Loop until:  {  {		Receive timeout occurs, or  {		Receive error occurs, or ) {		Null string received from application.  {  {}   while not done do  	begin   	{" 	{	Wait for the port or a timeout. 	{}    	wait_any(circuit_port^, 		 result := wait_result,  		 time := timeout_interval);    	{0 	{	If the result of the wait service was 0, then0 	{	the reason the wait terminated was because of
 	{	a timeout.  	{}    	if wait_result = 0  	then  		done := true 	else  		begin    		{ ) 		{	Otherwise, a message has been sent to " 		{	the port. Receive the message. 		{}   		receive(message_id,  			message_ptr,  			circuit_port^,  			status := status);  		if not odd(status) 		then 			done := true  		else 			begin 			if length(message_ptr^) = 0 			then  				done := true 			else 	 				begin    				{ " 				{	A non-zero length string has! 				{	successfully been received.  				{	Uppercase the string.  				{}   				message_ptr^ := & 				    translate_string(message_ptr^,% 				    'ABCDEFGHIJKLMNOPQRSTUVWXYZ',  				    oldchars := # 					'abcdefghijklmnopqrstuvwxyz');  				send(message_id, 				     circuit_port^)  				end; 			end;  		end; 	end;    { ; {	The exchange has terminated - delete the port, deallocate " {	the local port storage and exit. {}   delete(circuit_port^); dispose(circuit_port)    end; end;                                                                                                                                                                                                                                                                                                                                                                                                    . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION6D.PAS;1 +  , @   .     /     4 A                           - 
    0   1    2   3      K  P   W   O     5   6 @8fGX  7 b[  8          9          G    H  J                  module multiple_circuit_sender;    {++  {  {  { Abstract:  { : {	This module shows an example of a simple terminal-driven: {	application that makes use of the server example program {	described above. { ; {	The application reads a line from the terminal and passes ; {	the line to the server for processing. The processed line 9 {	is read back from the server and typed at the terminal.  { ; {	The process continues until the user enters a blank line, 8 {	which is the protocol established in the server as the {	"end-of-dialogue" marker.  {  {  {--}    program multiple_circuit_sender;   {  {	Variable declarations. {}   var  	circuit_port: port; 	done : boolean := false;  	message_id: message; " 	message_ptr: ^varying_string(80); begin    { ; {	Start by connecting our job port to the sample server via : {	its universal name 'SERVER$PORT'. On error, exit the job {	with appropriate status. {}   job_port(circuit_port); A connect_circuit(circuit_port, destination_name := 'SERVER$PORT');    { " {	Print the prompt for user input. {}   writeln;" writeln('Enter your input data.');: writeln('Terminate your input by entering a blank line.'); writeln;   { = {	Loop for each non-blank line entered. Send it to the server ? {	for processing and read it back from the server and print it.  {}   while not done do  	begin) 	create_message(message_id, message_ptr);  	readln(message_ptr^); 	if length(message_ptr^) = 0 	then  		done := true;     	send(message_id, circuit_port);   	if not done 	then  		begin  		wait_any(circuit_port); 1 		receive(message_id, message_ptr, circuit_port);  		writeln(message_ptr^)  		end; 	end;  end; end;                                                                                                                                                                                                                                                                                                                                                                                              . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION7A.PAS;1 +  , A   . 	    /     4 M   	    T                    - 
    0   1    2   3      K  P   W   O     5   6 mGX  7  n[  8          9          G    H  J                                                                                                                                                                                                     
                        2 $      ELN042.D                       A  
  .[SYSEXE.SEAS$WORK_0000005C]APPLICATION7A.PAS;1                                                                                 M     	                         Π              module siminterrupt;   { ? {     This is a simple program to show how ISRs work in VAXELN. 4 {     The program uses the CPU to simulate a device. { H {     The program creates a simulated device, inspects fields in the SCBD {     to show that the device has been created, generates a software7 {     interrupt, and shows that the interrupt occurred.  {  {     Device description:  {  {	Name			sim {	Register address	%o0000000 {	Vector address		%o274  {}   type   {  {     SCB fields {}        scb	     = record- 		       syspage : array [0..127] of integer; - 		       buspage : array [0..127] of integer; 
 		       end;   $      csrtyp	     = [word] 0..%xffff;      csrptrtyp	     = ^csrtyp;      ioregiontyp     = integer; %      ioregionptrtyp  = ^ ioregiontyp;    const    { ( {     System control block base register {}        scbb = 17;    { ) {     Software interrupt request register  {}        sirr = 20;    var       i, j, pri, vec1,       scbbcop	     :integer;       interrupterid   :process;      vec, scbptra    :^anytype;       scbptr	     :^scb;       simid	     :device;      csrptr	     :csrptrtyp;%      ioregionptr     :ioregionptrtyp;     J interrupt_service isr (intcsr :csrptrtyp; intioregionptr :ioregionptrtyp); begin    {   {     Interrupt service routine. { J {     Increment the value in the communication region to indicate that the {     interrupt happened.  {}  ' intioregionptr^ := intioregionptr^ + 1;    {  {     Signal the device. {}   signal_device; end;     program simulate;    begin    {  {     Main program code. { J {     Look into the System Control Block to demonstrate that CREATE DEVICEM {     allocates a vector.  Since there is no CSR and the address is specified G {     as 000000, the system page interrupt vector shows that the device  {     has been created.  {}   scbbcop := mfpr (scbb); 5 allocate_memory (scbptra, 1024, physical := scbbcop);  scbptr := scbptra;$ writeln ('scbb register contents:'); writeln (hex(scbbcop));    { A {     Vector of software interrupt at IPL 15 is located at %O274.  {}   i := %o274;   8 writeln ('System and Bus Page vector contents before:');7 writeln (hex(i),oct(i), hex(scbptr^.syspage[i div 4])); 7 writeln (hex(i),oct(i), hex(scbptr^.buspage[i div 4]));    create_device ('sim', simid, 		service_routine := isr,  		region := ioregionptr, 		registers := csrptr, 		priority := pri, 		vector := vec);   7 writeln ('System and Bus Page vector contents after:'); 7 writeln (hex(i),oct(i), hex(scbptr^.syspage[i div 4])); 7 writeln (hex(i),oct(i), hex(scbptr^.buspage[i div 4])); ' writeln ('vector and priority after:'); 4 writeln (hex(vec::integer), oct(vec::integer), pri);   { I {    Initialize the communication region counter (already cleared to 0 by  {    create_device). {}  	 writeln ;  ioregionptr^ := 2; writeln (ioregionptr^) ;   { 9 {     Cause a software requested CPU interrupt at IPL 15.  {}   mtpr (sirr,15);    {  {     Wait for an interrupt. {}   wait_any (simid);    { # {     See if an inte             rrupt happened.  {}   writeln (ioregionptr^) ;   writeln ('Done!'); end. end;                                                                                                                                                                                                                                                                                                                                                                                                                                                            . * [SYSEXE.SEAS$WORK_0000005C]APPLICATION7B.PAS;1 +  , B   . 	    /     4 K   	                       - 
    0   1    2   3      K  P   W   O     5   6 `cwGX  7 [  8          9          G    H  J                  MODULE siminterrupts;   H {     This program is a sample to illustrate using interrupts in VAXELN.E {     It shows how data is collected by the interrupt service routine D {     and signals the main program if the buffer is filled.  It alsoH {     determines whether interrupts come faster than it can handle them.8 {     The program uses the CPU to simulate the hardware. {  {     Device description:  {	Name			sim {	Register address	%o0000000 {	Vector address		%o274  {}   type'      csrtyp	     = [word] packed record $ 		       intena  : [pos(6)] boolean;
 		       end;       csrptrtyp	     = ^csrtyp;      ioregiontyp     = record ! 		       bufindex	     : integer; 4 		       buffer	     : array [0..buflen] of integer;. 		       csr	     : csrtyp;	 { simulated csr } 		       csrcopy	     : csrtyp; 
 		       end;   $      ioregionptrtyp  = ^ioregiontyp;   const       buflen = 9;   { ) {     Software interrupt request register  {}        sirr = 20;    { ) {     Software interrupt summary register  {}        sisr = 21;    var       pri, vec1	     : integer;      interrupterid   : process;       vec	     : ^anytype;       simid	     : device;       csrptr	     : csrptrtyp; "      comptr	     : ioregionptrtyp;   process_block interrupter;   var        delay	     : large_integer;   begin    {     Interrupt generator code.  { C {     Simulate an interface card that will cause an interrupt every H {     0.1 second, if the simulated CSR has the interrupt enable bit set. {}  ) delay := time_value ('0000 00:00:00.10');   
 while true do    begin    wait_any (time := delay); -   comptr^.csrcopy := read_register (csrptr^);    { J {     Cause a software interrupt at IPL 15, if the interrupt enable bit is
 {     set. {}   if comptr^.csrcopy.intena then     mtpr (sirr,15);    end; end;  C interrupt_service isr (intcsr :csrptrtyp; icomptr :ioregionptrtyp);  begin    {   {     Interrupt service routine. { > {     While inside the buffer, collect some data from the CPU. {}   with icomptr^ do   begin    if bufindex <= buflen then     buffer[bufindex] :=         MFPR (bufindex MOD 5 + 8);  7 {     Signal the device, if the buffer has been filled.  {}   if bufindex = buflen then        signal_device;   { I {    Increment the index into the buffer.  The count will be greater than ) {    the buffer, if there is an overflow.  {}   bufindex := bufindex + 1; 
   end; {with} 
 end; {isr}     program simulate;    var       i, j	     : integer;    begin    {  {     Main program code. { G {     Create the device, simulate a CSR, create the interrupt generator 4 {     process, and enable interrupts for the device. {}   create_device ('sim', simid, 		service_routine := isr,  		region := comptr,  		registers := csrptr, 		priority := pri, 		vector := vec); 	 writeln ;   csrptr := address (comptr^.csr);, create_process (interrupterid, interrupter);) write_register (csrptr^, intena := TRUE);    { J {     Wait until interrupted.  Disallow interrupts.  Collect data from theK {     buffer and do some work on the data.  Reset the buffer index to zero.  {     Reenable interrupts. {}   for j := 1 to 20 do    begin    wait_any (simid); ,   write_register (csrptr^, intena := false);   for i := 0 to buflen do ,     write (comptr^.buffer[i] mod %x1000 :5);   write (comptr^.bufindex:5); 
   writeln;   comptr^.bufindex := 0;+   write_register (csrptr^, intena := true);    end; writeln ('Done!'); end. end;                                                                                                  - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION8.PAS;1 +  , C   . 	    /     4 O   	    f                   - 
    0   1    2   3      K  P   W   O 	    5   6 @mZ  7  w[  8          9          G    H  J                   MODULE talking_to_qna;  L {     This is a VAXELN application that shows how a program in user mode canG {     access a MicroVAX II's DEQNA Ethernet controller to determine the G {     hardware address of the controller.  The application accesses the L {     address's location in I/O space by mapping the physical address of theA {     beginning of I/O space into the program's P0 address space.  {}   include $kernel;  & type  wurd				      = [word] 0..65535;<       page_of_memory			      = packed array[0..255] of wurd;   { M {     The base address plus (144 * 2) equals %X20001920, which corresponds to N {     %O17440 in the Q-bus I/O space.  This location contains the first of sixD {     sets of hex digits that constitute the hardware address of the {     DEQNA board. {}   const -       base_page_to_deqna		      = %X20001800; %       first_two_digits			      = 144; $       last_two_digits			      = 149;   var 9       pointer_to_page_of_memory		      : ^page_of_memory; 6       point_to_mem_alloc_to_io_s                                                                                                                                                                                            $      ELN042.D                       C  
  -[SYSEXE.SEAS$WORK_0000005C]APPLICATION8.PAS;1                                                                                  O     	                         t             pace	      : ^anytype;8       temporary_variable, status_of_the_call  : integer;1       converted_to_hex_string		      : string(4); 1       complete_deqna_address		      : string(17);     ( procedure allocate_memory_for_the_deqna;   begin    { , {     Code to allocate memory for the DEQNA. { I {     The procedure is called in kernel mode because it allocates memeory O {     at a physical address.  The ALLOCATE_MEMORY call maps 512 bytes of memory M {     starting at physical address %X20001800.	This memory is in the IO space F {     of a MicroVAX II and is mapped into the job's P0 virtual memory. {}  / allocate_memory(point_to_mem_alloc_to_io_space,  		512,! 		PHYSICAL := base_page_to_deqna,   		STATUS := status_of_the_call);; writeln('The status of the call was ', status_of_the_call);  writeln; end;   procedure talk_to_the_deqna;   var current_digits,       index_into_string : integer;   begin      index_into_string := 1;    { - {     Code for obtaining the DEQNA's address.  { N {     Assign the pointer for the type of variable to access memory in words to9 {     the pointer returned from the allocate_memory call.  {}  < pointer_to_page_of_memory := point_to_mem_alloc_to_io_space;   { H {     For each of the six sets of digits of the Ethernet address, do theO {     following:  read the register that contains the information, convert that O {     information to a hexidecimal string, move the third and fourth characters K {     of the converted string into a complete DEQNA address string, and, if D {     this isn't the last set of digits, add a hyphen to the string. {}  < for current_digits := first_two_digits TO last_two_digits DO   begin      temporary_variable := @       read_register(pointer_to_page_of_memory^[current_digits]);=     converted_to_hex_string := HEX(temporary_variable, 4, 4); =       substr(complete_deqna_address, index_into_string, 2) := )       substr(converted_to_hex_string, 3); -     if current_digits <> last_two_digits THEN        begin C 	substr(complete_deqna_address, (index_into_string + 2), 1) := '-'; , 	index_into_string := index_into_string + 3;
       end; end;   { - {     Finally, print out the complete string.  {}  I writeln('The address of the ethernet board is ', complete_deqna_address);  end;   program test_talking_to_qna;   begin    {  {     Main program code. { J {     The main program calls a subprocedure to map the DEQNA's memory intoD {     the program's address space.  Another procedure then reads theL {     hardware address for the mapped memeory.	Because you must be in kernelJ {     mode when the physical parameter is used in an ALLOCATE_MEMORY call,. {     enter kernel context for that procedure. {}  , ker$enter_kernel_context(status_of_the_call,, 			 address(allocate_memory_for_the_deqna));   { 7 {     Then pick up the digits for the Ethernet address.  {}   talk_to_the_deqna; end;   end;                                                                                                                                                                          - * [SYSEXE.SEAS$WORK_0000005C]APPLICATION9.PAS;1 +  , D   .     /     4 D       R                    - 
    0   1    2   3      K  P   W   O     5   6 M?Z  7 \  8          9          G    H  J                  
 module axv11;    { 5 {	This module contains some simple procedures to read 2 {	converted analog data from an AXV11 device and a# {	program to demonstrate their use.  {}   type   	{# 	{	Input/output data and gain data.  	{}    	axv_data = -%o3777..%o7777;   	{. 	{	Identifiers - one for each physical device. 	{}    	axv = ^anytype;   	{1 	{	AXV Control Status Register record definition:  	{$ 	{	start - 		Initiates a conversion.! 	{	gain_setting -		Controls gain. 0 	{	ext_start_enable - 	Permits external start of 	{			   	conversion./ 	{	clock_start_enable - 	Permits external start  	{			     	of conversion. . 	{	done_int_enable - 	Enables interrupt at end 	{			  	of conversion.- 	{	a_d_done - 		Set when conversion complete. 2 	{	multiplexer_address - 	Channel being addressed.. 	{	error_int_enable - 	Enables interrupt at an 	{			   	error condition. * 	{	a_d_error - 		Set when error detected -# 	{				can't happen in this program.  	{}   $ 	axv_csr_type = [word] packed record  	    start: 		 [pos(0)] boolean;# 	    gain_setting: 	 [pos(2)] 0..3; * 	    ext_start_enable: 	 [pos(4)] boolean;+ 	    clock_start_enable:  [pos(5)] boolean; ) 	    done_int_enable: 	 [pos(6)] boolean; # 	    a_d_done: 		 [pos(7)] boolean; ) 	    multiplexer_address: [pos(8)] 0..15; + 	    error_int_enable: 	 [pos(14)] boolean; $ 	    a_d_error: 		 [pos(15)] boolean	 	    end;    	{ 	{	Result of A/D conversion. 	{}     	axv_dbr_type = [word] axv_data;   	{% 	{	AXV register layout in controller:  	{! 	{	csr -	Control/status register.  	{	dbr -	Data buffer register. 	{}   , 	axv_registers = [aligned(1)]  packed record 	    csr: axv_csr_type;  	    dbr: axv_dbr_type	 	    end;    	{& 	{	AXV interrupt communication region: 	{0 	{	dbr_read - Temporary repository for data read* 	{		   in ISR (Interrupt Service Routine). 	{}   # 	axv_done_interrupt_region = record  	    dbr_read: axv_dbr_type 	 	    end;    	{ 	{	Data area for each device:  	{4 	{	done_device -	  Device object for done interrupt./ 	{	registers -	  Address of device's registers. 6 	{	done_region_ptr - Address of done interrupt region. 	{}    	axv_data_area = packed record 	    done_device: device;  	    registers: ^axv_registers; 0 	    done_region_ptr: ^axv_done_interrupt_region	 	    end;   5 interrupt_service done_interrupt(reg: ^axv_registers; - 			         com: ^axv_done_interrupt_region);    {++  {  { Routine description: { 7 {	Called upon receipt of an interrupt indicating that a 5 {	conversion is complete. This routine reads the data ; {	from the just-completed conversion into the communication & {	region, and then signals the device. { 	 { Inputs:  { ( {	reg - Address of the device registers.; {	com - Address of the done interrupt communication region.  { 
 { Outputs: { ; {	The conversion data is stored in the communication region  {	and the device is signalled. {  {--}   begin    {  {	Read the new data. {}  ) com^.dbr_read := read_register(reg^.dbr);    { 3 {	Signal the device to enable axv_read to continue.  {}  
 signal_device    end;  D procedure axv_initialize(device_name: [readonly] varying_string(30); 			 var identifier: axv);    {++  {  { Routine description: { > {	This procedure is called to allocate and initialize the data= {	area for an ADV11C or AXV11C. It also creates the necessary : {	device objects. It must be called once for each physical	 {	device.  { 	 { Inputs:  { 8 {	device_name -	1 to 30 character string giving the name) {			of the device. It must match the name ( {			established with the system builder. { 
 { Outputs: { 0 {	identifier -	Longword identifier to be used in' {			subsequent calls to axv_initialize, & {			axv_read and axv_write to identify {			this device. { : {	An identifier is allocated and returned, a device object4 {	is created and the physical device is initialized. {  {--}   begin    {  {	Get a new identifier.  {}    new(identifier::^axv_data_area);  " with identifier^::axv_data_area do 	begin   	{1 	{	Create a device object for the done interrupt.  	{}    	create_device(	device_name, 			done_device,  			vector_number := 1,% 			service_routine := done_interrupt,  			region := done_region_ptr,  			registers := registers);    	{ 	{	Initialize the device's CSR.  	{}    	write_register(registers^.csr)  	end;  end;  $ procedure axv_read(	identifier: axv; 			channel: integer;! 			var converted_data: axv_data);    {++  {  { Routine description: { 5 {	This routine is called to initiate a conversion and 5 {	gather the resulting datum from an AXV11C or ADV11C       
       " {	device on the specified channel. { 	 { Inputs:  { 0 {	identifier -	Expression of type AXV giving the% {			value of an identifier (which was & {			returned by axv_initialize) of the {			device to be read. { 0 {	channel -	Integer expression giving the analog {			channel to be read.  { 
 { Outputs: { 4 {	converted_data - Received resultant datum from the {			requested conversion.  {  {--}   {  {	Local variable declarations. {}   var  	csr_template: axv_csr_type;   begin   " with identifier^                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           $      ELN042.D                       D  
  -[SYSEXE.SEAS$WORK_0000005C]APPLICATION9.PAS;1                                                                                  D                              y 
            ::axv_data_area do 	begin   	{. 	{	First, set up the CSR templates. Begin with 	{	the contents of the CSR.  	{}   / 	csr_template := read_register(registers^.csr);    	{  	{	Now set the following fields: 	{" 	{	start -			Necessary to initiate 	{				conversions from the 	{				program., 	{	done_int_enable -	Necessary so the device 	{				interrupts. % 	{	multiplexer_address -	Set channel.  	{}    	with csr_template do  		begin  		start := true; 		done_int_enable := true;  		multiplexer_address := channel 		end;   	{7 	{	Write the device register to initiate the conversion 5 	{	and wait on the device. The wait will be satisfied 2 	{	when the interrupt service routine has read the) 	{	converted data and signals the device.  	{}   . 	write_register(registers^.csr, csr_template); 	wait_any(done_device);    	{1 	{	Finally, move the converted data into the user  	{	supplied variable.  	{}   , 	converted_data := done_region_ptr^.dbr_read 	end;  end;   program test(input,output);    { 4 {	This test program tests the above driver routines.2 {	It prompts the user for a channel to sample, and3 {	then samples the channel five times, printing the 2 {	resulting voltage from each. It assumes that the5 {	device is configured to give bipolar, offset-binary 2 {	outputs. If this is not the case, you can change {	the statement marked '**'. {}   var ) 	ident: axv;		{ the device's identifier } ) 	channel: integer;	{ channel to be read } 7 	result: axv_data;	{ resultant data from a conversion } 2 	voltage: real;		{ result converted to a voltage } 	i: integer;   begin    {  {	Initialize the device. {}   axv_initialize('AXV1', ident);   {  {	Loop to read data. {}  
 while true do  	begin   	{2 	{	Obtain the channel number from the user. If the( 	{	channel number is negative then exit. 	{}    	write('channel? '); 	readln(channel);    	if channel < 0  	then  		goto finished;   	for i := 1 to 5 do  		begin # 		axv_read(ident, channel, result); 7 {'**'}		voltage := (result - %o4000) * (10.0 / %o4000);   		writeln(voltage:5:2, ' volts') 		end; 	end;   	 finished:    end; end.                                                                                                                                                                                                                                                                                                                                                                                                                                                            % * [SYSEXE.SEAS$WORK_0000005C]CICP.OBJ;1 +  , E   . 	    /     4     	   	 <   
              - 
    0   1    2   3      K  P   W   O 
    5   6  [  7 @6\  8          9          G    H  J                          1     CICPV1.010-OCT-1990 22:59                    VAX C V3.1-051  P  PICP_AREAP  	P0 0:0:2P	 P0 0:0:10PPTesting the C run time routines...  P#=
p=ף=Perror - C math functionsVPerror - C conversion between real and strings Perror - C conversion between real and strings P1 P. Perror - C string spanning P%d Perror - C conversion between integer and stringsP123456789P123456789P123456789"P8$Perror - C string operations@Perror - incorrect C arguments^Perror - incorre  STDIN  STDOUT  STDERR   
C$V_CTYPEDEFS  SLEEP  SIGNAL  LONGJMP  SETJMP  TOLOWER  TOUPPER  PERROR  
VAXC$DSPRINTF  VAXC$DPRINTF  PUTS  
VAXC$DTANH  	VAXC$DTAN  
VAXC$DSQRT  
VAXC$DSINH  	VAXC$DSIN  	VAXC$DPOW  
VAXC$DMODF  VAXC$DLOG10  	VAXC$DLOG  VAXC$DLDEXP  VAXC$DHYPOT  VAXC$DFREXP  VAXC$DFLOOR  
VAXC$DFABS  	VAXC$DEXP  
VAXC$DCOSH  	VAXC$DCOS  
VAXC$DCEIL  VAXC$DATAN2  
VAXC$DATANct C timewPHOME|Perror - incorrect C environmentPC CREATE_AREAPAll C run time routines correctPC  SIGNAL AREAPC WAIT ON TIMEOUTPerror - incorrect C setjumpPerror - incorrect C timeout#Perror - incorrect C longjump@PFAILURE OF CICP - %X %s P8^ C$MAIN_ARGS T Yߤ PUTSpU|WpU~pW~ VAXC$DATAN2pPUjW~pU~ VAXC$DLDEXPpPUpU~ 
VAXC$DCEILpPU߭pU~ VAXC$DFREXPpPUpU~ VAXC$DFLOORpPUpU~ 
VAXC$DACOSpPUpU~  	VAXC$DSINpPUpU~ 
VAXC$DASINpPUpU~ 	VAXC$DTANpPUpU~ 
VAXC$DATANpPUpU~ 	VAXC$DEXPpPUpU~ 
VAXC$DSINHpPRpU~ 
VAXC$DCOSHfPRdURpU~ 
VAXC$DTANHgPRUpU~ 	VAXC$DLOGpPUpW~pU~ VAXC$DHYPOTdPUpU~ 
VAXC$DSQRTpPUp"WpU~pW~ 	VAXC$DPOWpPUpU~ VAXC$DLOG10pPUpU~ 	VAXC$DCOSpPU߭pU~ 
VAXC$DMODFpPUpU~ 
VAXC$DFABSqPϕݭ ABSPߤ= PERROR EXIT߭
p~ 
VAXC$DGCVTP߭ STRCPY߭ 
VAXC$DATOFqPߤV PERROR EXIT߭߭
p~ 
VAXC$DECVTP߭ STRNCPYѭխĄ  PERROR EXITĲ ߭ STRCSPNPĴ ߭ STRSPNPխխĶ  PERROR EXITݭ SRANDP  RANDPݭ ߭ 
VAXC$DSPRINTF߭ ATOLѭP  PERROR EXIT߭ STRCPY߭߭ STRCPY8SS STRRCHRP߭ STRNCATPS STRCHRP߭ STRCATP STRCMPP߭߭ STRNCMPPխ;խ6"߭ STRPBRKP STRLENPS TOLOWERPRS TOUPPERRP$ PERROR EXITѬ@ PERROR EXIT߭ TIMEP߭ CTIMEP߭ STRCPYխ0^ PERROR EXITw GETENVP߭ STRCPY󑭊]| PERROR EXITԭ  SETJMPPoЭR֭R PERROR EXIT SLEEPP PERROR EXIT  LONGJMP  SIGNAL# PERROR EXITy ELN$TIME_VALUE_LIST}y i ߭߭߭ KER$CREATE_AREAЭRĜSRSR@   
VAXC$DASIN  
VAXC$DACOS  ABS  GETENV  EXIT  SRAND  RAND  
VAXC$DATOF  ATOL  ELN$TIME_VALUE_LIST  KER$WAIT_ANY  
KER$SIGNAL  KER$CREATE_AREA  CHECK  TEST  CTIME  TIME  STRLEN  STRPBRK  STRNCMP  STRCMP  STRNCAT  STRRCHR  STRCAT  STRCHR  STRSPN  STRCSPN  STRNCPY  
VAXC$DECVT  STRCPY  
VAXC$DGCVT  HALT  HALT 
     MAIN 
  @   TEST 
     CHECK 
      HALT   R    CICP     main 8    @  test x       check ,       halt    		        l   C$MAIN_ARGS    $CODE    $DATA      _CTYPE_ <   CONTEXT X  $CHAR_STRING_CONSTANTS VAXC$DPRINTF EXITĪ PUTSݭ߭ 
KER$SIGNALЭRSRSR@ VAXC$DPRINTF EXIT ߭ KER$WAIT_ANYЭRSRSR@ VAXC$DPRINTF EXIT EXIT2 P ^ RѬ PERROR EXIT SLEEPP PERROR EXIT  LONGJMP  SIGNAL#   PERROR EXIT ^ R ݬݬ@ VAXC$DPRINTF EXIT  ^ݬ PERROR EXIT                                                                                                                                                                                                                          + * [SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1 +  , F   . 2   /     4     2  2                    - 
    0   1    2   3      K  P   W   O 2   5 	  6 @}  7 `V\  8          9          G    H  J                      %
   VAX-11 Librarian V04-00        @+} `skX
 !               0   2     #   2   "   !     q     q   :          1  F                                                                                                                                                                                                                                                                                                                                                                                              ABORT3    ABS   "ACCEPT*   ACOS*   ASIN*   ATAN*   ATAN2-  ATOF4    ATOI4    ATOL   "BIND    BSEARCH4   C$$COND_HAND   C$$DDOPRINT   
C$$DDOSCAN   P 	C$$FILBUF   P 	C$$FLSBUFS    C$$GA_SYS_ERRLIST    C$$GDOPRINT    
C$$GDOSCAN4   C$$MAINN    C$$MATH_HAND   P 	C$$SOCKET   "C$$SOCKET_CLOSE   "C$$SOCKET_READ   "C$$SOCKET_WRITE   `C$$TRANSLATE4   C$$TRNS_VALUESR   C$K_ECVT_BUFFSIZE<    C$MAIN<    C$MAIN_ARGS_ERRNO                                                                                                                                                                                                             6{ $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        ǚ "                        
C$$DOPRINT    C$$GDOPRINTN    C$$MATH_HANDO   LC$$MEMORY_ALLOCATION   `C$$TRANSLATE    C$ABORT3    C$ABS    C$ACOS    C$ASIN   C$ASSERT   RC$ATAN   C$ATAN2   " C$ATOF4    C$ATOL   h 	C$AUXCNBO    	C$AUXCSHR    	C$BSEARCH   C$CEIL    C$COS   h C$COSHF    C$CTYPE    C$DIVIDE    C$ECVT  \C$EXP   C$FABS  4 C$FLOOR  l C$FMOD
  C$FREXP   V C$GACOS    C$GASIN   C$GATAN   C$GATAN2    C$GATOFTRNCMPER_MATH           Z   b ELN$REMOVE_ENTRYJ   z ELN$SUB_LARGE_INTEGERS   ELN$SWITCH_STACKH    EXIT*   EXP*   FABS   P FCLOSE-  FCVT   P FDOPEN   P FFLUSH   P FGETC   P FGETNAME   P FGETS*   FLOOR*   FMOD   P FOPENy   FOR$CNV_IN_DEFGv   rFOR$CNV_IN_Ix   f FOR$CNV_IN_Ox   f FOR$CNV_IN_Zi   2 
FOR$CNV_OUT_Di   2 
FOR$CNV_OUT_Ei   2 
FOR$CNV_OUT_Fi   2 
FOR$CNV_OUT_Gi   2 FOR$CVT_D_TDi   2 FOR$CVT_D_TEi   2 FOR$CVT_D_TFi   2 FOR$CVT_D_TGCVT_G_TEi   2 FOR$CVT_G_TF                    C$MAIN_ARGS   DELETE   ELN$READ_ERRNO   FOR$CVT_D_TG   FOR$CVT_G_TF   FOR$_FAIACTCPU
   FOR$_FAISHRSTACK   FOR$_INVCOMADR   FOR$_LOCALACCESS
   FOR$_PARINITERR	   FOR$_UNIALROPE   GSIGNAL   NTOHS"   OTS$$CVT_MUL   OTS$CVT_T_D   OTS$_FATINTERR   OTS$_USEFLORES   SIGPAUSE   STRTOL   
VAXC$DFPRINTF   
VAXC$GATAN    VAXC$GET_FCB   VAXC$SOCKET_CONTROL   _PARTIAL_PRINTF                                                   b   
SIGSETMASKb   SIGSTACKb   SIGVEC*   SIN*   SINHg   SLEEP   "SOCKET-  SPRINTF*   SQRT[    SRAND-  SSCANF^   Z SSIGNAL   P STDERR   P STDIN   P STDOUT   4 STRCAT   \STRCHR   pSTRCMP   4 STRCPY   4 STRCSPNS    STRERROR   4 STRLEN   4 STRNCAT   STRNCMP   4 STRNCPY   4 STRPBRK   STRRCHR   4 STRSPN   STRSTR-  STRTOD   STRTOK     STRTOLTOUPPER   P UMASK   P UNGETC    
VAXC$DACOS   P 
VAXC$DFPRINTF_FOPEN  p            h HTONL   h HTONS*   HYPOT    	INET_ADDR    
INET_LNAOF    
INET_MAKEADDR    
INET_NETOF    INET_NETWORK    	INET_NTOA   P ISATTY*   LDEXP    LDIV   "LISTEN   h 	LOCALTIME*   LOG*   LOG10\   LONGJMP   P LSEEKO   LMALLOC   >MEMCHR   >MEMCMP   >MEMCPY   >MEMMOVE   >MEMSET*   MODF   h NTOHL   h NTOHS    OTS$$A_CVT_TABs    OTS$$CVT_D_T_R8s    OTS$$CVT_F_T_R8}    OTS$$CVT_G_T_R8}    OTS$$CVT_H_T_R8}    OTS$$CVT_MULLORES         i   2 FOR$CVT_G_TGi   2 FOR$CVT_H_TDi   2 FOR$CVT_H_TEi   2 FOR$CVT_H_TFi   2 FOR$CVT_H_TGn    FOR$_ADJARRDIMn    FOR$_ATTACCNONn    FOR$_ATTREANONn    FOR$_BACERRn    FOR$_CLOERRn    FOR$_COMSHRERRn    FOR$_DEFVALUSEDn    FOR$_DELERRn    FOR$_DIRIO_KEYn    FOR$_DUPFILSPEn    FOR$_ENDDURREAn    FOR$_ENDFILERRn    FOR$_ERRDURREAn    FOR$_ERRDURWRIn    
FOR$_FACILITYn    FOR$_FAIACTCPUOWNERIDn    
FOR$_FAIPRCIDn    FOR$_FAIPRCNAMEn    FOR$_FAISHRSTACKCOMADRe         n    FOR$_RECIO_OPEn    FOR$_RECNUMOUTn    FOR$_REWERRn    FOR$_REWRITERRn    FOR$_SEGRECFORn    FOR$_SEQIO_DIRn    FOR$_SPERECLOCn    FOR$_STACKSHRERRn    FOR$_STKBUFOVRn    FOR$_SUBPRCDIEDn    FOR$_SYNERRFORn    FOR$_SYNERRNAMn    FOR$_TOOMANPRCn    FOR$_TOOMANRECn    FOR$_TOOMANVALn    FOR$_UNFIO_FMTn    FOR$_UNIALROPEn    FOR$_UNIPROCESSn    FOR$_UNLERRn    FOR$_VFEVALERRn    FOR$_WRIREAFILO   LFREE    FTIMEI   GETENV^   Z GSIGNAL                    n    FOR$_LOCALSHRERRn    FOR$_MEMSHRERRn    FOR$_MIXFILACCn    FOR$_MORONERECn    FOR$_NESTPPLOOPn    FOR$_NOPARINITn    FOR$_NOTFORSPEn    FOR$_NOTIMPn    FOR$_NOTIMPRETn    FOR$_NOTRUNINPPn    FOR$_NO_CURRECn    FOR$_NO_SUCDEVn    FOR$_OPEDEFREQn    FOR$_OPEFAIn    FOR$_OPEREQDISn    FOR$_OPEREQSEQn    FOR$_OUTCONERRn    FOR$_OUTSTAOVEn    FOR$_PARINITERR                                                                                                      Q         n    FOR$_INVDSTRSIZEn    FOR$_INVKEYSPEn    FOR$_INVLCLADRn    FOR$_INVLOGNAMn    FOR$_INVLOGUNIn    FOR$_INVMATKEYn    FOR$_INVNUMPRCn    FOR$_INVREFVARn    FOR$_INVTEXn    FOR$_INVTEXRECn    FOR$_INVUNWINDn    FOR$_IO_NONFORn    FOR$_KEYIO_DIRn    FOR$_KEYVALERRn    FOR$_LISIO_SYNn    FOR$_LOCALACCESS                                                                                                                                                                            n    FOR$_FAISUBPRCn    FOR$_FATINTERRn    FOR$_FILNAMSPEn    FOR$_FILNOTFOUn    FOR$_FINERRn    FOR$_FLOUNDEXCn    FOR$_FMTIO_UNFn    FOR$_FORVARMISn    FOR$_IGNNOTDELn    FOR$_IGNOREDn    FOR$_INCFILORGn    FOR$_INCKEYCHGn    FOR$_INCOPECLOn    FOR$_INCRECLENn    FOR$_INCRECTYPn    FOR$_INFFORLOOn    FOR$_INPCONERRn    FOR$_INPRECTOOn    FOR$_INPSTAREQn    FOR$_INSVIRMEMn    FOR$_INVARGFORn    FOR$_INVCOMADR                                                     n    FOR$_FAIDCLEXITn    
FOR$_FAIIDPRCn    FOR$_FAIIMAGNAMEn    FOR$_FAIOWNERIDn    
FOR$_FAIPRCIDn    FOR$_FAIPRCNAMEn    FOR$_FAISHRSTACK                                                                                                                                                                                                                                                                                                                                                                         OTS$_WRONUMARG     OVERFLOW_HANDLERb   PAUSES    PERROR*   POW-  PRINTF   P PUTCHAR   P PUTS   P PUTW   QSORT[    RAND   P READO   LREALLOC   "RECV   "RECVFROM   "RECVMSG   P REWIND-  SCANF   "SELECT   "SEND   "SENDMSG   "SENDTO   P SETBUF\   SETJMP   "
SETSOCKOPT   "SHUTDOWNb   SIGBLOCK^   Z SIGNALb   SIGPAUSE                                                                                                                         OTS$_INPCONERR    OTS$_INSVIRMEM    OTS$_INTDATCOR    OTS$_INVSTRDES    OTS$_IO_CONCLO    OTS$_OUTCONERR    OTS$_STRIS_INT    OTS$_USEFLORES                                                                                                                                                                                                                                                                                                                                                         ELN$SWITCH_STACKi   2 	FOR$CVTRTn    
FOR$MSGDEFs    
OTS$$CVTDT}    
OTS$$CVTRTv   r
OTS$CVTTILx   f 
OTS$CVTTOLy   	OTS$CVTTR    OTS$MOVE    
OTS$MSGDEFG   z VAXC$ESTABLISH   VAXC$VARARGS                                                                                                                                                                                                                                                                                                z              C$GATOF   C$POW!   	C$STRNCMP   	C$TOUPPER   ELN$LARGE_INTEGER_MATH   	ELN$SLEEP   VAXC$VARARGS                                                                                                                                                                                                                                                                                                                                                                                                    K    ELN$LOCATE_CRTL_CTX<    ELN$MAINR   
ELN$P1DEFSS    
ELN$PERROR\   
ELN$SETJMP^   Z 
ELN$SIGNALb   
ELN$SIGVECg   	ELN$SLEEP                                                                                                                                                                                                                                                                                                                                                                                i   2 FOR$CVT_F_TDi   2 FOR$CVT_F_TEi   2 FOR$CVT_F_TFi   2 FOR$CVT_F_TGi   2 FOR$CVT_G_TDi   2 FOR$CVT_G_TEi   2 FOR$CVT_G_TF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Mj $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        Z "                          DIV   P DUP   P DUP2-  ECVTJ   z ELN$ADD_LARGE_INTEGERS   LELN$CLEANUP_P1_CTXZ   b ELN$INSERT_ENTRYR   ELN$K_P1_CTX_SIZEK    ELN$LOCATE_CRTL_CTXK    ELN$READ_ERRNO                                                                                                                                                                                                                                                                                                                      s         n    FOR$_UNIPROCESSn    FOR$_UNLERRn    FOR$_VFEVALERRn    FOR$_WRIREAFIL-  FPRINT   P FPUTC   P FPUTS   P FREADO   LFREE   P FREOPEN*   FREXP-  FSCANF   P FSEEK   P FTELL    FTIME   P FWRITE-  GCVT   P GETCHARI   GETENV   P GETNAME   "GETPEERNAME   P GETS   "GETSOCKNAME   "
GETSOCKOPT   P GETW^   Z GSIGNAL                                                                                                                                             P VAXC$GET_SDC  	VAXC$GEXP   
VAXC$GFABS   
VAXC$GFCVT  L VAXC$GFLOOR	   
VAXC$GFMOD   P 
VAXC$GFPRINTF  >VAXC$GFREXP   P VAXC$GFSCANF  L 
VAXC$GGCVT  jVAXC$GHYPOT   VAXC$GLDEXP  V 	VAXC$GLOG  VAXC$GLOG10  
VAXC$GMODF  J 	VAXC$GPOW   P VAXC$GPRINTF   P VAXC$GSCANF   	VAXC$GSIN!  &
VAXC$GSINH   P 
VAXC$GSPRINTF#  
VAXC$GSQRT   P VAXC$GSSCANF    VAXC$GSTRTOD&  x 	VAXC$GTAN(   
VAXC$GTANH   "VAXC$SOCKET_CONTROLF                        y   OTS$CVT_T_Gy   OTS$CVT_T_H    	OTS$MOVE3    OTS$MOVE3_R5    	OTS$MOVE5    OTS$MOVE5_R5    
OTS$_FACILITY    OTS$_FATINTERR                                                                                                                                                                                                                                                                                                                                                                              P C$VAXCIO4   	ELN$$MAIN   LELN$CLEANUP_P1_CTX=   *ELN$CMSCVECTORS   "
ELN$CSRSHR-  ELN$DCIO_JACKET_ROUTINES*   ELN$DCMTH_JACKET_ROUTINESH    ELN$EXITI   
ELN$GETENVJ   z ELN$LARGE_INTEGER_MATH                                                                                                                                                                                                                                                                                                  
  VAXC$DFREXP   P VAXC$DFSCANF  p
VAXC$DGCVT  &VAXC$DHYPOT  VAXC$DLDEXP   	VAXC$DLOG   VAXC$DLOG10  j
VAXC$DMODF   	VAXC$DPOW   P VAXC$DPRINTF   P VAXC$DSCANF   	VAXC$DSIN    
VAXC$DSINH   P 
VAXC$DSPRINTF"  |
VAXC$DSQRT   P VAXC$DSSCANF   " VAXC$DSTRTOD%  0 	VAXC$DTAN'   
VAXC$DTANHG   z VAXC$ESTABLISH   V 
VAXC$GACOS    
VAXC$GASIN   
VAXC$GATANBS   
VAXC$GCEIL   @ 	VAXC$GCOS    
VAXC$GCOSH   
VAXC$GECVT   P VAXC$GET_FCB               F    
C$V_CTYPEDEFS*   CABSO   LCALLOC4   
CC$_GFLOAT*   CEILO   LCFREE   P CHMOD   P CHOWN   P CLOSE   "CONNECT*   COS*   COSH   P CREAT   h CTIME   P DELETE                                                                                                                                                                                                                                                                                                                              }    OTS$$RET_A_CVT_TAB_R1x   f OTS$CVT_TB_Lv   rOTS$CVT_TI_Lx   f OTS$CVT_TO_Lv   rOTS$CVT_TU_Lx   f OTS$CVT_TZ_Ly   OTS$CVT_T_D                                                                                                                                                                                                                                                                                                                                                                                     STRTOUL*   TAN*   TANH    TIME    TIMES    TMPFILE   |TOLOWER   TOUPPER   P UMASK   P UNGETC    
VAXC$DACOS    
VAXC$DASIN   R
VAXC$DATAN   VAXC$DATAN2   " 
VAXC$DATOF  &
VAXC$DCABS   
VAXC$DCEIL    	VAXC$DCOS   h 
VAXC$DCOSH    
VAXC$DECVT  \	VAXC$DEXP   
VAXC$DFABS    
VAXC$DFCVT  4 VAXC$DFLOOR  l 
VAXC$DFMOD   P 
VAXC$DFPRINTF                                                                                                                 	C$STRRCHR   C$STRSTR   C$STRTOK     C$STRTOL%  0 C$TAN'   C$TANH    C$TIME   h C$TIMEF    	C$TMPFILE   |	C$TOLOWER   	C$TOUPPER                                                                                                                                                                                                                                                                                                                                                               C$GCEIL   @ C$GCOS    C$GCOSH  pC$GCVT   C$GECVT  C$GEXP   C$GFABS  L C$GFLOOR	   C$GFMOD  >C$GFREXP  L C$GGCVT  jC$GHYPOT   C$GLDEXP  V C$GLOG  C$GLOG10  C$GMODF  J C$GPOW   C$GSIN!  &C$GSINH#  C$GSQRT&  x C$GTAN(   C$GTANH  &C$HYPOT  C$LDEXP   C$LOG   C$LOG10   >	C$MEMFUNC  jC$MODF   C$POW   C$SIN    C$SINH   \C$STRCHR   pC$STRCMP   4 	C$STRINGS   	C$STRNCMP                         
VAXC$VA_COUNT   
VAXC$VA_START   VAXC$VA_START_1   P WRITE   _ASSERTH    _EXIT   P _FOPEN   P _PARTIAL_PRINTF                                                                                                                                                                                                                                                                                                                                                                                          VAXC$GATAN2    
VAXC$GATOF  j
VAXC$GCABS   
VAXC$GCEIL   @ 	VAXC$GCOS    
VAXC$GCOSH   
VAXC$GECVT   P VAXC$GET_FCB                                                                                                                                                                                                                                                                                                                                                                                       C$QSORTZ   b C$QUEUE[    C$RAND   C$SIN    C$SINH"  |C$SQRT   \C$STRCHR   pC$STRCMP   4 	C$STRINGS   	C$STRNCMP                                                                                                                                                                                                                                                                                                                                                                                    P OPEN}    OTS$$A_CVT_TABs    OTS$$CVT_D_T_R8s    OTS$$CVT_F_T_R8}    OTS$$CVT_G_T_R8}    OTS$$CVT_H_T_R8}    OTS$$CVT_MUL                                                                                                                                                                                                                                                                                                                                                                         $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          X $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                         "     %       &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               
 4   1        S} V4.1-00                         5     C$ABSV4.1-0010-OCT-1990 22:15                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ABS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ABS ELN_BUILD:[ELN.CRTL.SRC]ABS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - integer absolute math library function         	.  ABS  .    P       $CODE   P    
       ABS & ЬPPP  5     w w 1       } V4.1-00                         6     C$ATOLV4.1-0010-OCT-1990 22:08                   VAX C V3.1-051F   ATOL 
       ATOL 
       ATOI     $CODE     $DATA   P ^|RPP	$ ZP?P
PR֬	֬P0'9!
SQЬP֬`PPQ0QS09RSQPSQQP  ^ݬ ATOL PT T T T T ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] ] T ] ] ] ] ] ] ] ] ] ] Z ] X          w w 1       } V4.1-00                         9     	EL 6   N$$MAINV4.1-0010-OCT-1990 22:08                    VAX C V3.1-051   C$_EPERM   	C$_ENOENT   C$_ESRCH   C$_EINTR   C$_EIO   C$_ENXIO   C$_E2BIG   
C$_ENOEXEC   C$_EBADF   	C$_ECHILD   	C$_EAGAIN   	C$_ENOMEM   	C$_EACCES   	C$_EFAULT   
C$_ENOTBLK   C$_EBUSY   	C$_EEXIST   C$_EXDEV   	C$_ENODEV   
C$_ENOTDIR   	C$_EISDIR   	C$_EINVAL   	C$_ENFILE   	C$_EMFILE   	C$_ENOTTY   
C$_ETXTBSY   C$_EFBIG   	C$_ENOSPC   	C$_ESPIPE   C$_EROFS   	C$_EMLINK   C$_EP                                                                                                                                                                                                                                                                            $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        cp "     6        7   IPE   C$_EDOM   	C$_ERANGE    C$_EWOULDBLOCK   C$_EINPROGRESS   C$_EALREADY   C$_ENOTSOCK   C$_EDESTADDRREQ   C$_EMSGSIZE   
C$_EPROTOTYPE   C$_ENOPROTOOPT   C$_EPROTONOSUPPORT   C$_ESOCKTNOSUPPORT   
C$_EOPNOTSUPP   C$_EPFNOSUPPORT   C$_EAFNOSUPPORT   
C$_EADDRINUSE   C$_EADDRNOTAVAIL   C$_ENETDOWN   C$_ENETUNREACH   C$_ENETRESET   C$_ECONNABORTED   
C$_ECONNRESET   
C$_ENOBUFS   
C$_EISCONN   C$_ENOTCONN   C$_ESHUTDOWN   C$_ETOOMANYREFS   C$_ETIMED 8   OUT  PPATH=[]PHOME=[]PTERM=PUSER=  PY                              <PЇ                               pP                                                
                           	            ԏ                     	      
     P   
                      DP      N   
          lP   ^ X U CALLOCPT MALLOCPS 9      ELN$PROGRAM_ARGUMENT_COUNTPVeԥTT hިި |~ KER$GET_USER<RBߨS STRCPY STRCPYSdլ1 ~ CALLOCPVSTV3PT ELN$PROGRAM_ARGUMENTĞRPSP VTϔRRSRRPRWP CALLOCPRWR/PWRWݥPި֥լeSPSSPP^լ/P޼Q@a @a	׬P޼Q@a @a	SެTC  C 	dRSCb Cb	VYެZjRSR1pެRb[ެX   Ck"1 WSP :   jQPQ@   C$_ECONNREFUSED   C$_ELOOP   C$_ENAMETOOLONG   C$_EHOSTDOWN   C$_EHOSTUNREACH   C$_ERROR   C$_INV_FRAME   C$_KILL   
C$_LONGJMP   C$_LONGJMP_FAILED   
CC$_GFLOAT       
CC$_GFLOAT       
CC$_GFLOAT 
      C$$TRNS_VALUES  ELN$LOCATE_CRTL_CTX  ELN$PROGRAM_ARGUMENT_COUNT  ELN$PROGRAM_ARGUMENT  KER$WAIT_ANY  
KER$SIGNAL  KER$GET_USER  STRCPY  MALLOC  CALLOC  
SIGSETMASK  ELN$SWITCH_STACK  C$$TRANSLATE 
    C$$MAIN   " ;   jQPWPQ@ "YdW1YUWTTUThQVPVC @aTUWPPS1 PUWTTTUThQVPVC @aTUWPPS1 PW5YUWTTTUT  QVPVC @aTUWPPS1 PUWTUTШ QVPVC @aTUWPPSXYHC UUAUZVTVUP PPD 1U U	VPV@ PVPVU@ VTVC D SSn1VSV޼RC  VP^QVS޼RެTA CbUPQPKdXíWAhVS޼PA C`UVQ!PVVS޼RQPQ@ CbUQQWUP ^  ELN$LOCATE_CRTL_CTXPSXݣ|~   <    KER$WAIT_ANYʏ    ЬRݢ C$$TRANSLATE ݣ  
KER$SIGNAL ЬRˏRxR[YYRBcRb1PPYP@KR[b1$[ЬP YYP@,RbU@'RbZUPxPPPPP P$UQA Rb1x[bA RZb1 PUP@ P`R1 R1 RXUU`ЬVfQUP@ RbW ԭ QTDfAfUP@ RUPxPPbP  W XZU ELN$SWITCH_STACKPRUxUPP ݭ 
SIGSETMASKЭDfXݣ  
KER$SIGNALRPYYP@Rb1X	 =    d  
  0  C$$COND_HAND  ,  $CODE    $DATA    ENVIRON    $CHAR_STRING_CONSTANTS6  
KER$SIGNAL<	PXݣ  
KER$SIGNALP      w w 1        } V4.1-00                         8     ELN$MAINV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]CMAIN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]CMAIN ELN_BUILD:[ELN.CRTL.SRC]CMAIN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALI
 >   B.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - VAXELN-C Main RoutinesC   C$$COND_HAND  C$$MAIN 
     C$MAIN 
    C$MAIN_ARGS          	.  ABS  .    P    (   $CODE U  P C$$COND_HANDm~ C$$MAINP\P C$$COND_HANDm C$$MAINP\    w w 1        \} V4.1-00                         ?     ELN$CMSCVECTORSV4.1-0010-OCT-1990 22:17                    VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]CMSCVECTOR/OBJECT=ELN_BUILD ?   :[ELN.CRTL.OBJ]CMSCVECTOR ELN_BUILD:[ELN.CRTL.SRC]CMSCVECTOR+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  Transfer vectors for miscellaneous C rou  ABS  ATOI  ATOL  BSEARCH  C$$COND_HAND  C$$MAIN  C$$TRANSLATE  C$MAIN  C$MAIN_ARGS  CALLOC  CFREE  CTIME  DIV  ELN$ADD_LARGE_INTEGERS  ELN$CLEANUP_P1_CTX  ELN$INSERT_ENTRY  ELN$LOCATE_CRTL_CTX  ELN$READ_ERRNO  ELN$RE @   MOVE_ENTRY  ELN$SUB_LARGE_INTEGERS  ELN$SWITCH_STACK  FREE  FTIME  GETENV  GSIGNAL  	LOCALTIME  LONGJMP  MALLOC  MEMCHR  MEMCMP  MEMCPY  MEMMOVE  MEMSET   PAUSE  QSORT  RAND  REALLOC  SETJMP  SIGBLOCK  SIGNAL  SIGPAUSE  
SIGSETMASK  SIGSTACK  SIGVEC  SLEEP  SRAND  SSIGNAL  STRCAT  STRCHR  STRCMP  STRCPY  STRCSPN  STRLEN  STRNCAT  STRNCMP  STRNCPY  STRPBRK  STRRCHR  STRSPN  STRSTR A     STRTOK  STRTOL  STRTOUL  TIME  TIMES  TOLOWER  TOUPPER  VAXC$ESTABLISH  
VAXC$VA_COUNT  
VAXC$VA_START  VAXC$VA_START_1   _EXIT          	.  ABS  .    P    =  
$$$VECTORS PAMALLOCMALLOC&1 MALLOC3Q   ACALLOCCALLOC&1 CALLOC3Q   AFREEFREE&1 FREE3Q   ACFREECFREE&1 CFREE3Q   AREALLOCREALLOC&1 REALLOC3Q   AABSABS&1 ABS3Q   AATOIATOI&1 ATOI3Q   AATOLATOL&1 ATOL3Q   AELN$INSERT_ENTRY B   ELN$INSERT_ENTRY&1 ELN$INSERT_ENTRY3Q   AELN$REMOVE_ENTRYELN$REMOVE_ENTRY&1 ELN$REMOVE_ENTRY3Q   ARANDRAND&1 RAND3Q   ASRANDSRAND&1 SRAND3Q    ASTRCATSTRCAT&1 STRCAT3Q   ASTRCHRSTRCHR&1 STRCHR3Q   ASTRCMPSTRCMP&1 STRCMP3Q   ASTRCPYSTRCPY&1 STRCPY3Q   ASTRCSPNSTRCSPN&1 STRCSPN3Q   ASTRLENSTRLEN&1 STRLEN3Q   ASTRNCATSTRNCAT&1 STRNCAT3Q   ASTRNCMPSTRNCMP&1 STRNCMP3Q   ASTRNCPYSTRNCPY&1 STRNCPY C   3Q   ASTRPBRKSTRPBRK&1 STRPBRK3Q   ASTRRCHRSTRRCHR&1 STRRCHR3Q   ASTRSPNSTRSPN&1 STRSPN3Q   ATIMETIME &1 TIME3Q   AFTIMEFTIME&1 FTIME3Q   ATIMESTIMES&1 TIMES3Q   ACTIMECTIME&1 CTIME3Q   A	LOCALTIME	LOCALTIME&1 	LOCALTIME3Q   ATOLOWERTOLOWER&1 TOLOWER3Q   ATOUPPERTOUPPER&1 TOUPPER3Q   AC$$TRANSLATEC$$TRANSLATE&1 C$$TRANSLATE3Q   AC$MAIN1 C$MAINQ   AC$MAIN_ARGS1 C$MAIN_ARGSQ   AC$$MAINC$$M D   AIN&1 C$$MAIN3Q   AC$$COND_HANDC$$COND_HAND&1 C$$COND_HAND3Q   AEXITA_EXIT_EXIT&1 _EXIT3Q   AGETENVGETENV&1 GETENV3Q   AELN$ADD_LARGE_INTEGERSELN$ADD_LARGE_INTEGERS&1 ELN$ADD_LARGE_INTEGERS3Q   AELN$SUB_LARGE_INTEGERSELN$SUB_LARGE_INTEGERS&1 ELN$SUB_LARGE_INTEGERS3Q   AELN$LOCATE_CRTL_CTXELN$LOCATE_CRTL_CTX&1 ELN$LOCATE_CRTL_CTX3Q   AELN$READ_ERRNOELN$READ_ERRNO&1 ELN$READ_ERRNO3Q   ASETJMPSETJMP&1 SETJMP3Q   ALONGJMP E   LONGJMP&1 LONGJMP3Q   AGSIGNALGSIGNAL&1 GSIGNAL3Q   ASIGNALSIGNAL&1 SIGNAL3Q   ASSIGNALSSIGNAL&1 SSIGNAL3Q   APAUSEPAUSE&1 PAUSE3Q   ASIGBLOCKSIGBLOCK&1 SIGBLOCK3Q   ASIGPAUSESIGPAUSE&1 SIGPAUSE3Q   A
SIGSETMASK
SIGSETMASK&1 
SIGSETMASK3Q   ASIGSTACKSIGSTACK&1 SIGSTACK3Q   ASIGVECSIGVEC&1 SIGVEC3Q   ASLEEPSLEEP&1 SLEEP3Q   AELN$SWITCH_STACKELN$SWITCH_STACK&1 ELN$SWITCH_STACK3Q   AVAXC$ESTABLISHV F   AXC$ESTABLISH&1 VAXC$ESTABLISH3Q   A
VAXC$VA_COUNT
VAXC$VA_COUNT&1 
VAXC$VA_COUNT3Q   A
VAXC$VA_START
VAXC$VA_START&1 
VAXC$VA_START3Q   AVAXC$VA_START_1VAXC$VA_START_1&1 VAXC$VA_START_13Q   AELN$CLEANUP_P1_CTXELN$CLEANUP_P1_CTX&1 ELN$CLEANUP_P1_CTX3Q   AMEMMOVEMEMMOVE&1 MEMMOVE3Q   AMEMCPYMEMCPY&1 MEMCPY3Q   AMEMSETMEMSET&1 MEMSET3Q   AMEMCMPMEMCMP&1 MEMCMP3Q   AMEMCHRMEMCHR&1 MEMCHR3Q   ABSEARCH  BSEARCH&1 BSE G   ARCH3Q   AQSORTQSORT&1 QSORT3Q   ASTRTOKSTRTOK&1 STRTOK3Q   ASTRTOLSTRTOL&1 STRTOL3Q   ASTRTOULSTRTOUL&1 STRTOUL3Q   ADIVALDIVDIV&1 DIV3Q   ASTRSTRSTRSTR&1 STRSTR3    w w 1       } V4.1-00                         7     C$CTYPEV4.1-0010-OCT-1990 22:09                    VAX C V3.1-051m    
C$V_CTYPEDEFS       
C$V_CTYPEDEFS       
C$V_CTYPEDEFS      $CODE     $DATA     _CTYPE_   P         (((((                                                                                                                                                                                                                                                                                        $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        | "     G        H         DDDDDDDDDDAAAAAABBBBBB   P   w w 1       @~ V4.1-00                         >     VAXC$ESTABLISHV4.1-0010-OCT-1990 22:15                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ESTABLISH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ESTABLISH ELN_BUILD:[ELN.CRTL.SRC]ESTABLISH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/L I   IB(  - establish exception handling routine         	.  ABS  .    P        $ABS$ 	   P  P       $CODE   P    
       VAXC$ESTABLISH  & ЬP    w w 1        ~ V4.1-00                         8     ELN$EXITV4.1-0010-OCT-1990 22:15                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]EXIT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]EXIT ELN_BUILD:[ELN.CRTL.SRC]EXIT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$ J   :[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - C RTL exit routines   
     EXIT  KER$EXIT         	.  ABS  .    P        $ABS$    P       $CODE   P    
       _EXIT &  lЬPPP~ KER$EXIT   w w 1       `+~ V4.1-00                         :     
ELN$GETENVV4.1-0010-OCT-1990 22:09                   VAX C V3.1-051V   STRNCMP  STRLEN 
       GETENV  i   $CODE     $DATA    ENVIRONz   P ^ P K   ݬ STRLENPTP Sc9PTݬc STRNCMPPcRRTQa=RTPPq=TRPScP        w w 1       `8~ V4.1-00                         F     ELN$LARGE_INTEGER_MATHV4.1-0010-OCT-1990 22:15                   VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]LARGE_INTEGER_MATH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]LARGE_INTEGER_MATH ELN_BUILD:[ELN.CRTL.SRC]LARGE_INTEGER_MATH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTE L   MLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB '  - LARGE_INTEGER math support routines          	.  ABS  .    P    *   $CODE   P #  
      ELN$ADD_LARGE_INTEGERS  & }Q}aPbPآQ}P #  
     ELN$SUB_LARGE_INTEGERS  & }R}cPbP٢Q}P    w w 1        E~ V4.1-00                         C     ELN$LOCATE_CRTL_CTXV4.1-0010-OCT-1990 22:15                    VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]LOCATE_CRTL_CTX/OBJECT=ELN_BUILD:
 M   [ELN.CRTL.OBJ]LOCATE_CRTL_CTX ELN_BUILD:[ELN.CRTL.SRC]LOCATE_CRTL_CTX+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB!  - Locate C RTL P1 context frame    ELN$K_P1_CTX_SIZE  KER$ALLOCATE_MEMORY  KER$CREATE_EVENT  KER$CREATE_SEMAPHORE  KER$DISABLE_SWITCH  KER$ENABLE_SWITCH  KER$ENTER_KERNEL_CONTEXT  P1$GA_CRTL_CTX         	.  ABS  .    P        $ABS$    P       $CODE   P     
 N          ELN$LOCATE_CRTL_CTX & m P1$GA_CRTL_CTXP5~ KER$DISABLE_SWITCH P1$GA_CRTL_CTX SPn^P`F~ KER$ENTER_KERNEL_CONTEXT~ KER$ENABLE_SWITCHЎP  l P1$GA_CRTL_CTXP| ~V|~ ELN$K_P1_CTX_SIZEf~ KER$ALLOCATE_MEMORYЎV, n  ELN$K_P1_CTX_SIZE&f~ߦ~ KER$CREATE_EVENTP~P `~ KER$CREATE_SEMAPHOREЎPVP  ~ KER$ENABLE_SWITCHЏ	  P P   
      ELN$READ_ERRNO  &  >ЬQA`P   w w  O   1       S~ V4.1-00                         <     C$$MATH_HANDV4.1-0010-OCT-1990 22:15                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]MATHCHAND/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]MATHCHAND ELN_BUILD:[ELN.CRTL.SRC]MATHCHAND+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB"  - math routine condition handlerB   C$_EDOM  	C$_ERANGE  ELN$LOCATE_CRTL_CTX  
KER$UNWIND         	 P   .  ABS  .    P        $ABS$    P  P  P  P       $CODE   P|   
     | C$$MATH_HAND  &   ELN$LOCATE_CRTL_CTXPVЬRТS|TS C$_EDOM7:=%Rя SCя S:я S1я̂ S(я S}T 	C$_ERANGE7:=%RяĂ S<	PRfЬR}T~ ~ 
KER$UNWIND   w w 1       @Fa~ V4.1-02                         D     C$$MEMORY_ALLOCATIONV4.1-0210-OCT-1990 22:17                   VAXELN PASCAL V4.2_95 
  e
 I	    o e    ZTYPE Q   REALLOCCFREEFREECALLOCMALLOCC$$TRANSLATEPAS$DISPOSE2PAS$NEW2 FILLUSEP
PTFILLER
  USED
 
MPOINTER% 
SIZE% ANYTYPE 
%  
%  
NUMBER% 
ESIZE%  
MSIZE%  
ERROR_NUMBER%  
MEMORY_POINTER%  
NUMBER_OF_BYTES% 	 M   C$$TRANSLATE  PAS$DISPOSE2  PAS$NEW2  PAS$HANDLER  PAS$GOTO F      PQRЬPݠ C$$TRANSLATEԢ@R PAS$GOTOP R     
  +    MALLOC   +   P ^| PAS$HANDLERm޼nޯ]n PAS$NEW2PЮЭP ^   PQRЬPݠ C$$TRANSLATEԢzR PAS$GOTOP  
     CALLOC      P^| PAS$HANDLERm޼޼nޯ]ŮnWW PAS$NEW2PXVW   , n Fh  V  WW  , n WFhXЭP    PQRЬPݠ C$$TRANSLATE6R PAS$GOTOP   
     FREE K    P ^| PAS$HANDLERm޼nޯ­]n PAS$DISPOSE2ԭЭP   
  K  	 S    CFREEW  K  P ^޼nnQRЬPݠ C$$TRANSLATEԢ R PAS$GOTOP   
    REALLOC    P^| PAS$HANDLERmЬ[޼n[оѮn[1 ޯ]n PAS$NEW2PZînY!kQjSnX<VVXXV(VacVXTkQjSЮX<VVXXV(VacVXЮWY   , n Gj  W  YY  , n YGj[ PAS$DISPOSE2ZЭP     X  $CODE     $DATA         w w 1       o~ V4.1-00                         :     
ELN$P1DEFSV4.1-0010-OCT-199
 T   0 22:09                   VAX C V3.1-051    ELN$K_P1_CTX_SIZE   2  ELN$K_P1_CTX_SIZE   2  ELN$K_P1_CTX_SIZE   C$K_ECVT_BUFFSIZE      C$K_ECVT_BUFFSIZE      C$K_ECVT_BUFFSIZE      $CODE     $DATA    P    w w 1        D~~ V4.1-00                         :     
ELN$PERRORV4.1-0010-OCT-1990 22:09                   VAX C V3.1-051   Perror 0                             not owner                           no such file or directory           no such process  U                       interrupted system call             i/o error                           no such device or address           arg list too long                   exec format error                   bad file number                     no children                         no more processes                   not enough core                     permission denied                    bad address                         block device required               mount device busy                   file exists V                            cross-device link                   no such device                      not a directory                     is a directory                      invalid argument                    file table overflow                 too many open files                 not a typewriter                    text file busy                      file too large                      no  space left on device             illegal seek                        read-only file system               too ma W   ny links                      broken pipe                         math argument                       result too large                    I/O stream empty                    operation in progress               operation already in progress       socket operation on non-socket      destination address required        message too long                    protocol wrong type for socket      proto col not available              protocol not supported              socket type not supported           o X   peration not supported on socket   protocol family not supported       address family not supported        address already in use              can't assign requested address      network is down                     network is unreachable              network dropped connection on reset software caused connection abort    connection reset by peer            no buffer space available           socket is already connected         socket is not connected             can't send after socket shutdown                                                                                                                                                                                                                                                                           A= $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        ( "     X        Y       too many references: can't splice   connection timed out                connection refused                  too many levels of symbolic links   file name too long                  host is down                        no route to host                       P%s: non-translatable VAXELN error code: 0x%X, VAXELN message:
%s
BP%s: %.*s
LP%s: Undefined error
 K	P ^ W    STDIN  STDOUT  STDERR 
      C$$GA_SYS_ERRLIST  
VAXC$DFPRINTF  ELN$GET_STATUS_TEXT  ELN$L Z   OCATE_CRTL_CTX  
VAXC$VA_START  STRCPY 
  L	   PERROR 
  	  < STRERROR  
  $CODE     $DATA a   $CHAR_STRING_CONSTANTS ELN$LOCATE_CRTL_CTXPUeVV  Hݥ ELN$GET_STATUS_TEXT֞ST<R
PRdݥݬg STDERR 
VAXC$DFPRINTFV(VA   $VF3$ݬߧB STDERR 
VAXC$DFPRINTFݬߧL STDERR 
VAXC$DFPRINTF< ^  ELN$LOCATE_CRTL_CTXPUЬR"RA   $RB2 STRCPY2P߭ 
VAXC$VA_STARTнRѬ  6 [   R1ݬ ELN$GET_STATUS_TEXTܞS2T<RRd2PP    L	   w w 1       `~ V4.1-00                         7     C$QUEUEV4.1-0010-OCT-1990 22:16                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]QUEUE/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]QUEUE ELN_BUILD:[ELN.CRTL.SRC]QUEUE+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB%  - queue manipulation routines for C  \            	.  ABS  .    P    `   $CODE   P    
       ELN$INSERT_ENTRY  &2 ^ЬPլ`PPլP,P   
 ,     ELN$REMOVE_ENTRY  &4 ^ЬPլ ԼPPլP   w w 1       Ȝ~ V4.1-00                         6     C$RANDV4.1-0010-OCT-1990 22:16                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]RAND/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]RAND ELN_BUILD:[ELN.CRTL.SRC]RAND+ELN_BUILD:[EL ]   N.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - random number generation   ELN$LOCATE_CRTL_CTX          	.  ABS  .    P    1   $CODE   P   
      RAND  &:   ELN$LOCATE_CRTL_CTXޠRzmNAb90  PPbP "P   
 "     SRAND &!   ELN$LOCATE_CRTL_CTXЬ    w w 1       
~ V4.1-00                         :     
ELN$SETJMPV4.1-0010-OCT-1990 22:16                   VAX MACRO  ^   V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]SETJMP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]SETJMP ELN_BUILD:[ELN.CRTL.SRC]SETJMP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - setjmp/longjmp routines    
KER$UNWIND         	.  ABS  .    P        $ABS$    P    x   $CODE   P    
       SETJMP  &1 ЬPԀ}R}T}V}X}Z}РQЬЭ`|P   
 /    LONGJMP &W ЬPЬ`~Q _   ORRݠ0a 
KER$UNWINDЭPР4^ݠ8Р,\}$Z}X}V}T}RQ`P    w w 1       Ӽ~ V4.1-00                         :     
ELN$SIGNALV4.1-0010-OCT-1990 22:09                   VAX C V3.1-051   C$_EPERM   	C$_ENOENT   C$_ESRCH   C$_EINTR   C$_EIO   C$_ENXIO   C$_E2BIG   
C$_ENOEXEC   C$_EBADF   	C$_ECHILD   	C$_EAGAIN   	C$_ENOMEM   	C$_EACCES   	C$_EFAULT   
C$_ENOTBLK   C$_EBUSY   	C$_EEXIST   C$_EXDEV   	C$_ENODEV   
C$_ENOTDIR   	C$_EISDIR   `    	C$_EINVAL   	C$_ENFILE   	C$_EMFILE   	C$_ENOTTY   
C$_ETXTBSY   C$_EFBIG   	C$_ENOSPC   	C$_ESPIPE   C$_EROFS   	C$_EMLINK   C$_EPIPE   C$_EDOM   	C$_ERANGE    C$_EWOULDBLOCK   C$_EINPROGRESS   C$_EALREADY   C$_ENOTSOCK   C$_EDESTADDRREQ   C$_EMSGSIZE   
C$_EPROTOTYPE   C$_ENOPROTOOPT   C$_EPROTONOSUPPORT   C$_ESOCKTNOSUPPORT   
C$_EOPNOTSUPP   C$_EPFNOSUPPORT   C$_EAFNOSUPPORT   
C$_EADDRINUSE   C$_EADDRNOTAVAIL   C$_ENETDOWN   C$_ENETUNREACH   C a   $_ENETRESET   C$_ECONNABORTED   
C$_ECONNRESET   
C$_ENOBUFS   
C$_EISCONN   C$_ENOTCONN   C$_ESHUTDOWN   C$_ETOOMANYREFS   C$_ETIMEDOUT    P ^  ELN$LOCATE_CRTL_CTXPRլ\ѬVXݢ|~  KER$WAIT_ANYP@ QaSЬa@ Qa@ Qa@ P`Xݢ  
KER$SIGNALSPݏ 	C$_EINVAL C$$TRANSLATEPP  ^ݬݬ SIGNALPPQQQPP| ^  ELN$LOCATE_CRTL_CTXPS߭ 
VAXC$VA_STARTѽRЬRRVլѬݏ 	C$_EINVAL C$$TRA b   NSLATEPTTP@ C$$TRNS_VALUESRb1 TP@ C$$TRNS_VALUES   3Qas@ C$$TRNS_VALUES   3QaV	V]@ C$$TRNS_VALUESPx`UX   C$_ECONNREFUSED   C$_ELOOP   C$_ENAMETOOLONG   C$_EHOSTDOWN   C$_EHOSTUNREACH   C$_ERROR   C$_INV_FRAME   C$_KILL   
C$_LONGJMP   C$_LONGJMP_FAILED  C$$TRNS_VALUES  SIGNAL  ELN$LOCATE_CRTL_CTX  KER$WAIT_ANY  
KER$SIGNAL  KER$RAISE_EXCEPTION  C$$TRANSLATE  _EXIT  C$$TRANSLATE  
VAXC$VA_START 
  c         SIGNAL 
       SSIGNAL 
     | GSIGNAL    $CODE     $DATA ݣ|~  KER$WAIT_ANYP@ P`RXݣ  
KER$SIGNALRЬPVU  KER$RAISE_EXCEPTIONPTTP@ C$$TRNS_VALUESP`1a _EXIT         w w 1       ~ V4.1-00                         :     
ELN$SIGVECV4.1-0010-OCT-1990 22:09                   VAX C V3.1-051   C$_EPERM   	C$_ENOENT   C$_ESRCH   C$_EINTR   C$_EIO   C$_ENXIO   C$_E2BIG   
C$_ENOEXEC d      C$_EBADF   	C$_ECHILD   	C$_EAGAIN   	C$_ENOMEM   	C$_EACCES   	C$_EFAULT   
C$_ENOTBLK   C$_EBUSY   	C$_EEXIST   C$_EXDEV   	C$_ENODEV   
C$_ENOTDIR   	C$_EISDIR   	C$_EINVAL   	C$_ENFILE   	C$_EMFILE   	C$_ENOTTY   
C$_ETXTBSY   C$_EFBIG   	C$_ENOSPC   	C$_ESPIPE   C$_EROFS   	C$_EMLINK   C$_EPIPE   C$_EDOM   	C$_ERANGE    C$_EWOULDBLOCK   C$_EINPROGRESS   C$_EALREADY   C$_ENOTSOCK   C$_EDESTADDRREQ   C$_EMSGSIZE   
C$_EPROTOTYPE   C$_ENOPROTOOPT e      C$_EPROTONOSUPPORT   C$_ESOCKTNOSUPPORT   
C$_EOPNOTSUPP   C$_EPFNOSUPPORT   C$_EAFNOSUPPORT   
C$_EADDRINUSE   C$_EADDRNOTAVAIL   C$_ENETDOWN   C$_ENETUNREACH   C$_ENETRESET   C$_ECONNABORTED   
C$_ECONNRESET   
C$_ENOBUFS   
C$_EISCONN   C$_ENOTCONN   C$_ESHUTDOWN   C$_ETOOMANYREFS   C$_ETIMEDOUT    P ^  ELN$LOCATE_CRTL_CTXPS߭ 
VAXC$VA_STARTнTլѬݏ 	C$_EINVAL C$$TRANSLATEPXݣ|~  KER$WAIT_ANYT(ЬR"P@ Q f   ab@ Qa@ P`T(ЬR"P@ Qba@ QТa@ PТ`Xݣ  
KER$SIGNALPP ^  ELN$LOCATE_CRTL_CTXPRXݢ|~  KER$WAIT_ANY SȬ Xݢ  
KER$SIGNALSPP^  ELN$LOCATE_CRTL_CTXPR߭ 
VAXC$VA_STARTЭPˏ WWլXݢ|~  KER$WAIT_ANY XЬPP VЬ    C$_ECONNREFUSED   C$_ELOOP   C$_ENAMETOOLONG   C$_EHOSTDOWN   C$_EHOSTUNREACH   C$_ERROR   C$_INV_FRAME   C$_KILL   
C$_LONGJMP   C$_LONGJM g   P_FAILED  PAUSE  
SIGSETMASK  ELN$LOCATE_CRTL_CTX  KER$WAIT_ANY  KER$WAIT_ALL  
KER$SIGNAL  KER$RAISE_EXCEPTION  KER$CLEAR_EVENT  C$$TRANSLATE  
VAXC$VA_START  
VAXC$VA_START  C$$TRANSLATE  
VAXC$VA_START 
       SIGVEC 
      SIGBLOCK 
    
SIGSETMASK 
      PAUSE WլXݢ  
KER$SIGNALUVuPVeWլXݢ|~  KER$WAIT_ANYUQA P`S`A P`TWլXݢ  
KER$SIGNALS
TS  KER$RAISE_EXCEPTI h   ONUxVVVXP  ^  ELN$LOCATE_CRTL_CTXP\ ݬ  KER$CLEAR_EVENT |~  KER$WAIT_ALL  ^ݬ 
SIGSETMASK  PAUSEݏ C$_EINTR C$$TRANSLATEP ^  ELN$LOCATE_CRTL_CTXPR߭ 
VAXC$VA_STARTнSXݢ|~  KER$WAIT_ANYSЬP ` Sм Xݢ E  
  4    SIGPAUSE 
  \   SIGSTACK    $CODE     $DATA   
KER$SIGNALP        w w 1       ~ V4.1-00                         9     	ELN$SLEEPV4.1-0 i   010-OCT-1990 22:16                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]SLEEP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]SLEEP ELN_BUILD:[ELN.CRTL.SRC]SLEEP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - pause a process for specified number o#   C$$TRANSLATE  KER$WAIT_ALL          	.  ABS  .    P    3   $CODE   P   
      SLEEP &I zig ~|~^Rߢb KER$WAIT_AL                                                                                                                                                                                                                                                                           _ $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                         "     i       	 j   LbЬP C$$TRANSLATEP    w w 1       ~ X-2                             5     	FOR$CVTRTX-211-OCT-1989 19:54                    VAX MACRO V5.0-8k  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:FORCVTRT/OBJ=OBJ$:FORCVTRT TMP$:FORCVTRT.MAR %  - Convert Real (F, D, G, H) to Text   
 e   
FOR$CNV_OUT_D 
    
FOR$CNV_OUT_E 
 ]  
FOR$CNV_OUT_F 
   
FOR$CNV_OUT_G  FOR$_OUTCONERR  OTS$$CVT_D_T_R8  OTS$$CVT_F_T_R8  OTS$$CVT_G_T_R8  OTS$$ k   CVT_H_T_R8         	.  ABS  .    P    t  	_FOR$CODE   P  
     FOR$CVT_F_TE  && ^E؞ OTS$$CVT_F_T_R8X1   
    FOR$CVT_D_TE  &% ^E؞ OTS$$CVT_D_T_R8Xx   
 )   FOR$CVT_G_TE  &% ^E؞ OTS$$CVT_G_T_R8Xd   
 =   FOR$CVT_H_TE  &% ^E؞ OTS$$CVT_H_T_R8XP   
 Q   FOR$CVT_F_TD  &% ^D؞ OTS$$CVT_F_T_R8X<   
 e   FOR$CVT_D_TD  &% ^D؞ OTS$$CVT_D_T_R8X(   l    
 y   FOR$CVT_G_TD  &% ^D؞ OTS$$CVT_G_T_R8X   
    FOR$CVT_H_TD  & ^D؞ OTS$$CVT_H_T_R8X 0Эȭխ
Э1֭RR^^ЬP]Qhԭ­ЭխԭЭȭЭЭԭέЭЭ
ԭ­Э֭130؃STd֭Sc1SS1
   
 N  FOR$CVT_F_TF  &  ^ OTS$$CVT_F_T_R8X-  
 ]  FOR$CVT_D_TF  &  ^ OTS$$CVT_D_T_R8X  
 l  FOR$CVT_G_TF  &  ^ OTS$$CVT_G_T_R8 m   X  
 {  FOR$CVT_H_TF  & ^ OTS$$CVT_H_T_R8X 0<׭iRR^^ȏ   ȭԭЬP]QhԭխԭЭԭέԭíȭԭЭȭխԭ01X1C  
   FOR$CVT_F_TG  &% ^E؞ OTS$$CVT_F_T_R8X<   
   FOR$CVT_D_TG  &% ^E؞ OTS$$CVT_D_T_R8X(   
 .  FOR$CVT_G_TG  &% ^E؞ OTS$$CVT_G_T_R8X   
 B  FOR$CVT_H_TG  &^E؞ OTS$$CVT_H_T_R8X 0 <PPR n   R^^ȏ   ЬP]QhЭTխcԭ1ѭRЭQ- n9QdDc5?1, n0d׭֭1ѭ$:- n9d1c5,1, n0d׭֭1ЭPխ
PP1ЭP­1PTRb5r90bbRT׭֭l ԭԭԭԭȏlX4&X4&~X4&nX4&iX4&dX4&њЬЬЬЬЬЬԭԭԏl4&4&4&4&4&4  &ЬЬЭV}R<RRíRP­P­P­PPխ PPfPW Pխ
 +- o   խ"խխW6Ws c0(fcQV.ЭP0PЭP(Pfc}P, n*Pa FOR$_OUTCONERRP}P<PPPQSQ QP   w w 1    f    !~  X-3                             6     
FOR$MSGDEFX-311-OCT-1989 19:4811-OCT-1989 19:48  VAX-11 Message V04-00        $ABS$    # FOR$_NESTPPLOOP    FOR$_NOTRUNINPP    FOR$_NOPARINIT    FOR$_UNIPROCESS    FOR$_DEFVALUSED    FOR$_INVDSTRSIZE   
 FOR$_TOOMANPRC    FOR$_INVLOGNAM    F p   OR$_STKBUFOVR    FOR$_INVUNWIND    FOR$_FAISHRSTACK    FOR$_STACKSHRERR    FOR$_PARINITERR    FOR$_INVCOMADR    FOR$_COMSHRERR   | FOR$_INVLCLADR   t FOR$_LOCALACCESS   l FOR$_LOCALSHRERR   d FOR$_MEMSHRERR   \ FOR$_INVNUMPRC   T FOR$_FAISUBPRC   L FOR$_FAIDCLEXIT   D FOR$_FAIIMAGNAME   < 
FOR$_FAIIDPRC   4 FOR$_FAIACTCPU   , FOR$_FAIPRCNAME   $ 
FOR$_FAIPRCID    FOR$_FAIOWNERID    FOR$_NOTIMPRET q       FOR$_SUBPRCDIED    FOR$_FATINTERR   c FOR$_FLOUNDEXC   L FOR$_OPEREQSEQ   D FOR$_OPEREQDIS   < FOR$_INVTEX   4 FOR$_INVTEXREC   , FOR$_IO_NONFOR   $ FOR$_KEYIO_DIR    FOR$_SEQIO_DIR    FOR$_DIRIO_KEY    FOR$_FMTIO_UNF    FOR$_UNFIO_FMT    FOR$_INVMATKEY    FOR$_ADJARRDIM   $ FOR$_VFEVALERR    FOR$_INPSTAREQ    FOR$_OUTSTAOVE    FOR$_INPCONERR    FOR$_OUTCONERR    FOR$_SYNERRFOR    r    FOR$_FORVARMIS    FOR$_INFFORLOO   ܁ FOR$_LISIO_SYN   $ FOR$_ATTREANON   ܀ FOR$_MORONEREC   ́ FOR$_FINERR   ā FOR$_UNLERR    FOR$_DELERR    FOR$_REWRITERR    FOR$_NO_CURREC    FOR$_SPERECLOC    FOR$_INCFILORG    FOR$_INCKEYCHG    FOR$_INVKEYSPE    FOR$_INVARGFOR   | FOR$_WRIREAFIL   t FOR$_INCOPECLO   l FOR$_KEYVALERR   d FOR$_INCRECTYP   \ FOR$_FILNAMSPE   T FOR$_NO_SUCDEV   L FOR$_I s   NSVIRMEM   D FOR$_RECIO_OPE   < FOR$_ERRDURREA   4 FOR$_ERRDURWRI   , FOR$_INCRECLEN   $ FOR$_ATTACCNON    FOR$_SEGRECFOR    FOR$_UNIALROPE    FOR$_ENDFILERR    FOR$_INVLOGUNI    FOR$_MIXFILACC    FOR$_OPEFAI    FOR$_FILNOTFOU    FOR$_CLOERRu   ܀ FOR$_TOOMANREC   Ԁ FOR$_OPEDEFREQ   ̀ FOR$_RECNUMOUT   Ā FOR$_ENDDURREA    FOR$_BACERR    FOR$_INPRECTOO    FOR$_DUPFILSPE    FOR$_REWERR 
 t      FOR$_INVREFVAR    FOR$_TOOMANVAL    FOR$_SYNERRNAM     FOR$_IGNNOTDEL    FOR$_IGNORED    FOR$_NOTIMP    FOR$_NOTFORSPE      
FOR$_FACILITY    w w 1        X-1                             6     
OTS$$CVTDTX-111-OCT-1989 20:45                   VAX MACRO V5.0-8k  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSCVTDT/OBJ=OBJ$:OTSCVTDT TMP$:OTSCVTDT.MAR    3  
    OTS$$CVT_D_T_R8 
    OTS$$CVT_F_T_R8          	.  u    ABS  .    P      	_OTS$CODE  P0000000000010203040506070809101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899QWQP`PQWp`P}WQ^X^TPR]PPQQ   R||d R QR ȏ   PPR R d R R-VWxRUUU)1{ ЧQ, n0a|ԧ1 QިTdPETդU֨}dP{ ʚ;PdQԤUWÏ eQStR{ ʚ;RdQȏ    v    dtP{ ʚ;PdQWQUШR}P{ ʚ;PRBRRЎWUÏW   P PQШRBScPz ʚ;PQPPRz ʚ;PQP ʚ;QPRQQRЧU0VШP1 	UUS}υ@QR{d   QQT1Dtu{d   QQT Dcu{d   QQTDRu{d   QQTDCu0QuUSPQ
P0PP
	QPQSUPVrרШP1 	UUS}@QQ
DR{d   QQT1Du{d   QQT Du{d   QQTDϿu{d   QQTDϰu0QuSU	V1W0ԧ	Q0	UUS}{Q
D R{d   QQT1Dju{d   QQT DYu{d    w   QQTDHu{d   QQTD9u0QuUSPQ
P0PP
PSUPVb0
	UUS}Q
DԀR{d   QQT1Du{d   QQT Du{d   QQTDu{d   QQTDϺu0QuSU	Vd0	UUS}ϘQ
DR{d   QQT1Dχu{d   QQT Dvu{d   QQTDeu{d   QQTDVu0QuSU	VVVUAP4P	PPUe5 UPp90``§PPP֧^WQ   w w 1        X-2                             6     
OTS$CVTTILX-211-OCT-1989 20:57                   VAX MACRO V5.0-8n  MACRO/ENAB
 x   LE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSCVTTIL/OBJ=OBJ$:OTSCVTTIL TMP$:OTSCVTTIL.MAR&  ; Convert text (integer) to longword*  
    FOR$CNV_IN_I  OTS$_INPCONERR         	.  ABS  .    P       	_OTS$CODE   P|   
     | OTS$CVT_TU_L  &
 VV|  
    | OTS$CVT_TI_L  &V}P|TlV; PaaVa	QPVa-Va+PQP8SS VS	 V0S0SS		z
TSTU OTS$_INPCONERRPT!PVT   TTTVTԑl&ЬR R
 y   VR
2TTTRTTST<TSTS OTS$_INPCONERRP   w w 1       ` X-1                             6     
OTS$CVTTOLX-111-OCT-1989 20:58                   VAX MACRO V5.0-8n  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSCVTTOL/OBJ=OBJ$:OTSCVTTOL TMP$:OTSCVTTOL.MAR  ; Convert text to integer @  
    FOR$CNV_IN_O 
 _   FOR$CNV_IN_Z  OTS$_INPCONERR         	.  ABS  .    P    .  	_OTS$CODE    P 	 z   

|@  
    |@OTS$CVT_TO_L  &K 0 0 8.P4VV*P#PTcPPTcPTcTV1L 1M |@   
 _   |@OTS$CVT_TZ_L  && 0S 0 	VPTcTV1) 1* |@  
    |@OTS$CVT_TB_L  & 00 0f PVPTcTV1 1 P0  OTS$_INPCONERRPVl	լЬVЬP, n V`xVV}Q<QQQRЬSTlЬUQ3rPQP  UP0P!P PPP
@PP1~    w w 1       
 X-4                             5     	OTS$CVTTRX-411-OCT-                                                                                                                                                                                                                                                                           z $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                         "     z        {   1989 20:59                    VAX MACRO V5.0-8k  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSCVTTR/OBJ=OBJ$:OTSCVTTR TMP$:OTSCVTTR.MAR %  ; Convert text to real (D, G and H) Q  
    FOR$CNV_IN_DEFG  OTS$$A_CVT_TAB  OTS$$CVT_MUL  OTS$_INPCONERR          	.  ABS  .    P      	_OTS$CODE   P  
     OTS$CVT_T_H & P   ^  
    OTS$CVT_T_G & P   ^
  
    OTS$CVT_T_D &P   ^ Ԯl l |   
լȏ  }PR|T|VԮlЬ|X; Pa1aS
S	QP1S-S+S.ȏ   @Ԁ0^P1 0SS	WX0`֮SLS3S2S@S5;S1S4,S!'SA   1 A1 11y tԮ1tPDQ; Pa<aSS	S+
S-ȏ    0P0S7S	2
RDSR?RRȏ   Y?PЬQ||al	<QPQ OTS$_INPCONERRPڑlЏ OTS$_INPCONERRPď  4&4&4&< Q<Q<@QRPl }   ¬X®XXPY	5YW@UnyTTyVVn VQ@   Q}TVQyVV|T`   QTWQxWWTXQ(}T}V
WRЮP@RPPPWPWWPPR OTS$$A_CVT_TABBRWn(W OTS$$CVT_MULnWծ1ծ( 4&%4&4&11}Vx(QJVXyVVʏ   WQW6XV W&	լXW ЬRWVb1 1}Vx(QP VXXXyVVʏ  W PQW6XV W	լXW ЬRWVb1| 10}T}Vx(Qn TXXX VPyTTyVVPUʏ   ~   WQWEX
րT U V W/	լXW ЬRWVUTbP1PQaSS	S  0S	Y\Y@PUPyVVPVyTTUPyV~PnyT~T؎U؎V؎WST	 U V WЎPyTTyTVVTWUST U|VDdT>DcTY   w w 1       9 X-1                             6     
OTS$$CVTRTX-117-NOV-1989 19:54                   VAX MACRO T5.2V-4 k  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSCVTRT/OBJ=OBJ$:OTSCVTRT TMP$:OTSCVTRT.MAR )  - Kernel Convert real (G and H    ) to text   
 1  OTS$$A_CVT_TAB 
 X  OTS$$CVT_G_T_R8 
    OTS$$CVT_H_T_R8 
   OTS$$CVT_MUL 
   OTS$$RET_A_CVT_TAB_R1         	.  ABS  .    P        $ABS$ 	   P  P    D	  	_OTS$CODE  P0000000000010203040506070809101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899QWԧ2`Q1W* QQmX ` 14  Jms`    <^^XÏ @  QTS
R<QQQ Qh R STTɏ   T1v QWԧ`Q1+ QQ  `   1  JmS`<^^XÏ   Q`TS|h R RSTɏ   T1  >Rq43I>qR>QR2PxPQxQQQQQPP	E14R1QQQRQR0Qď  QxQQQE14QQR14Rۨ'Ѣ ѢѢbhE14R>1PRP
PPRPR0 QΨP&PQQhQP hhP     P ԨP QQh   "ЏhЏЏЏ֧ЧUVΧ0ԨЏ ʚ;RzR PըRQPQzR PըR QPQ zR PըRQPQ  zRh PhRQPhQ   	UUS}qШQR{d   QQT3Dau{d   QQT"DPu{d   QQTD?u{d   QQT D.u0QuSU	V1$VVU:Q-QQQUe5UPp90``§Pԧ֧<^WQЧQ, n0a|ԧWQ ЬPѠ<  7ЬQա.`RB`R s    ЏT  Џ	  P`QbP    1PԨ||$|,|4>%	ST:UVDhP,EbQ&zPQ PDhEbQEbDhQPFQF F 0,ب0 ب4$ب8((QרQQ hQ Q  Q $2QQ2QQá#-ޟݦ %I-64OSm kXWڥ 22q#2I\ 	SU9zc%C1 ]|d|FW$bGט#?9',Jg9Eϖyh.L[Mľ
K7٬:|S\	5$oe(KB.E.D?ˈPo	̼I9i$MZDs10
h16A_p    =|6+
aw̫Miv2=BzՔI? il7Tr3܀#GGŧN@a+eX&1Zd;Onp=
ףp=
ףp=
ף                                                                   
                @                P                $                                              (k 	              " 
             @C%              (              *焑, 
             /             1_2             	    6           p+ŝk   %kqk<զIx @ 76l3oߌG ݍ~S XPT\eƑ P(=
euuvJ
 RΚ2(M]=]; JJ?Lɚ R`'5          w w 1          X-1                             6     
OTS$MSGDEFX-111-OCT-1989 19:5211-OCT-1989 19:52  VAX-11 Message V04-00        $ABS$      OTS$_USEFLORES   L OTS$_WRONUMARG   D OTS$_INSVIRMEM   < OTS$_STRIS_INT   4 OTS$_OUTCONERR   , OTS$_IN    PCONERR   $ OTS$_IO_CONCLO    OTS$_INTDATCOR    OTS$_FATINTERR    OTS$_INVSTRDES      
OTS$_FACILITY   w w 1       F X-1                             4     OTS$MOVEX-111-OCT-1989 21:02                   VAX MACRO V5.0-8h  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSMOVE/OBJ=OBJ$:OTSMOVE TMP$:OTSMOVE.MAR  - Move characters -  
 
   OTS$MOVE3_R5 
    OTS$MOVE5_R5          	.  ABS  .    P      	_OTS$CODE   P<   
         < 	OTS$MOVE3 & }PЬRP  (PabQRKQRSSPBPRSPQ(    Q  S    nЎPPR(PBaBc
PRS(ac    nЎP(Pac<   
    < 	OTS$MOVE5 & }P}RЬTP  S  ,PaRSdPS~SPTR0FЎPR~PS~TRTSP0.Sn  , nc    n}P, nQPcЎQ    w w 1       @$ V4.1-00                         8     C$STRCHRV4.1-0010-OCT-1990 22:16                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD    :[ELN.CRTL.LIS]STRCHR/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRCHR ELN_BUILD:[ELN.CRTL.SRC]STRCHR+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - first character search         	.  ABS  .    P       $CODE   P   
      STRCHR  & }PRQRPRP   w w 1       3 V4.1-00                         8     C$STRCMPV4.1-0010-OCT-1990 22:16                   VAX MACRO V5.0-9  MACRO/DEBU    G=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]STRCMP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRCMP ELN_BUILD:[ELN.CRTL.SRC]STRCMP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - string compare         	.  ABS  .    P       $CODE   P   
      STRCMP  & }QP	SSPbSSP    w w 1       
@ V4.1-00                         9     	C$STRNCMPV4.1-0010-OCT-1990 22:16                    VAX MACRO V5    .0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]STRNCMP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRNCMP ELN_BUILD:[ELN.CRTL.SRC]STRNCMP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - string compare n characters          	.  ABS  .    P    &   $CODE   P   
      STRNCMP && ЬS}QPTTPSPbTTP   w w 1        ]R V4.1-00                         9     	C$STRRCHRV4.1-0010-OCT-    1990 22:16                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]STRRCHR/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRRCHR ELN_BUILD:[ELN.CRTL.SRC]STRRCHR+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - last character search          	.  ABS  .    P       $CODE   P   
      STRRCHR & }PRSQSPRSRP   w w 1       @a V4.1-00                         @         ELN$SWITCH_STACKV4.1-0010-OCT-1990 22:16                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]SWSTACK/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]SWSTACK ELN_BUILD:[ELN.CRTL.SRC]SWSTACK+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - execute signal handler on correct stac!   
KER$SIGNAL  KER$WAIT_ANY          	.  ABS  .    P    h   $CODE   P<   
     < ELN$SWITCH_STACK  &                                                                                                                                                                                                                                                                           [ $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                          "                | ^RЬ ST
ЬUU^Xc~ 
KER$SIGNALЬURTeUݬݬPRX
c|~~ KER$WAIT_ANYTRP   w w 1       p V4.1-00                         6     C$TIMEV4.1-0010-OCT-1990 22:16                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]TIME/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]TIME ELN_BUILD:[ELN.CRTL.SRC]TIME+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB     "  - time related library functions:   KER$CURRENT_PROCESS  KER$GET_JCB  KER$GET_TIME         	.  ABS  .    P        $ABS$    P  P  P  P  P       $CODE   P @Kg| P  
     FTIME &] ~R~~P`b KER$GET_TIME}PЎRR|P1 ¯PٯQ{ PPQƏ'  QЬRPQbTP   
 T    TIME  &V ~R~~P`b KER$GET_TIME}PЎRR|P1 ¯PٯQ{ PPQl	ЬQPa P  
     TIMES & ~R~S~Tbc KER$GET_JCBdc     KER$CURRENT_PROCESSbRdTRRSbRRS$Ѣ<T1ЬPТl|	cSУppՀԀ}R}RP    w w 1        ~ V4.1-00                         7     C$TIMEFV4.1-0010-OCT-1990 22:10                    VAX C V3.1-051  PSunMonTueWedThuFriSatPJanFebMarAprMayJunJulAugSepOctNovDec  P                                                                         hP ^ЬQ֬
P0PPaЬS֬z  P{
PQP0PRRc   P ^Q޼PA`RЬQ֬aЬQ֬aЬP֬b`       P,^ X  ELN$LOCATE_CRTL_CTXPYɰ W($g؞ɖ Vݬ 	LOCALTIMEVݧhPV Vݧߨ{PV ݧV3PV0  ݧVPV:ݧV	PV:gVPV 19ݧVPV
($ا ɖ P^ [V<UnZWOyT  ELN$LOCATE_CRTL_CTX YެST OP3TU[z  UP{PQPPz  UP{d   PQPPz  UP{  PQPP	Q TWT Ѽ3	ռU[z  UP{PQPPz  UP{d   PQPPz  UP{  PQPPWNUSď3SŏQ WRRSSXWU[z  UP{PQPP    z  UP{d   PQPPz  UP{  PQPPWNUSď3SŏQ WRRSSXW[Tz  UP{PQPPz  UP{d   PQPPz  UP{  PQPPTTSxVRCRŏQ bRZRRXCCT  PxVRPRbnVRVxRRPRŏQ bRRZxVRPRŏQ bRZRRXUVZX   	LOCALTIME  ELN$LOCATE_CRTL_CTX  	LOCALTIME 
     CTIME 
    	LOCALTIME    $CODE     $DATA ;   $CHAR_STRING_CONSTANTSr ǏQ XRRnRR[RRz  RP{PQPPz  XP{Q PQPPXǏ  Xz  XP{  PQPPX<Xz  XP{<PQPPXXi    YP   h    w w 1       `ߍ V4.1-00                         9     	C$TMPFILEV4.1-0010-OCT-1990 22:10                    VAX C V3.1-051d   FDOPEN  CREAT 
        TMPFILE  *   $CODE     $DATA    $CHAR_STRING_CONSTANTSL PFOP=TMD	Pw+  P  ^ \߬<~l CREAT߬	P FDOPEN        w w 1       @ V4.1-00                         <     C$$TRANSLATEV4.1-0010-OCT-1990 22:10                   VAX C V3.1-051   C$_EPERM   	C$_ENOE    NT   C$_ESRCH   C$_EINTR   C$_EIO   C$_ENXIO   C$_E2BIG   
C$_ENOEXEC   C$_EBADF   	C$_ECHILD   	C$_EAGAIN   	C$_ENOMEM   	C$_EACCES   	C$_EFAULT   
C$_ENOTBLK   C$_EBUSY   	C$_EEXIST   C$_EXDEV   	C$_ENODEV   
C$_ENOTDIR   	C$_EISDIR   	C$_EINVAL   	C$_ENFILE   	C$_EMFILE   	C$_ENOTTY   
C$_ETXTBSY   C$_EFBIG   	C$_ENOSPC   	C$_ESPIPE   C$_EROFS   	C$_EMLINK   C$_EPIPE   C$_EDOM   	C$_ERANGE    C$_EWOULDBLOCK   C$_EINPROGRESS   C$_EALREADY   C$_E    NOTSOCK   C$_EDESTADDRREQ   C$_EMSGSIZE   
C$_EPROTOTYPE   C$_ENOPROTOOPT   C$_EPROTONOSUPPORT   C$_ESOCKTNOSUPPORT   
C$_EOPNOTSUPP   C$_EPFNOSUPPORT   C$_EAFNOSUPPORT   
C$_EADDRINUSE   C$_EADDRNOTAVAIL   C$_ENETDOWN   C$_ENETUNREACH   C$_ENETRESET   C$_ECONNABORTED   
C$_ECONNRESET   
C$_ENOBUFS   
C$_EISCONN   C$_ENOTCONN   C$_ESHUTDOWN   C$_ETOOMANYREFS   C$_ETIMEDOUT  PS   $       C$_EPERM   	     S   S   S   S    	C$_ENOENT             C$_ESRCH   Q      C$_EINTR   S   S    C$_EIO   	     |      S    C$_ENXIO    C$_E2BIG   D       
C$_ENOEXEC    C$_EBADF	    	C$_ECHILD
         	C$_EAGAIN   D          S        	C$_ENOMEM   $   
   S
    	C$_EACCES
   S
          	C$_EFAULT   \!     
C$_ENOTBLK   l           @     A     H     S     C$_EBUSY   lS    	C$_EEXIST    C$_EXDEV   	                      	    C$_ENODEV   (     S    
C$_ENOTDIR    	C$_EISDIR               	C$_EINVAL   S    	C$_ENFILE         	C$_EMFILE    	C$_ENOTTY    
C$_ETXTBSY    C$_EFBIG   P          S    	C$_ENOSPC    	C$_ESPIPE   \     S    C$_EROFS    	C$_EMLINK    C$_EPIPE    S      !     !    !    !    !   ̂ !    !    C$_EDOM!     "     "   Ă  "   , "    	C$_ERANGE"   S#    C$_EWOULDBLOCK#     #   S$    C$_    EINPROGRESS$   ,   $   S%    C$_EALREADY%   S&    C$_ENOTSOCK&   S'    C$_EDESTADDRREQ'     '   S(    C$_EMSGSIZE(     (   S)    
C$_EPROTOTYPE)   t   )   S*    C$_ENOPROTOOPT*   S+    C$_EPROTONOSUPPORT+   S,    C$_ESOCKTNOSUPPORT,   S-    
C$_EOPNOTSUPP-      -   S.    C$_EPFNOSUPPORT.   S/    C$_EAFNOSUPPORT/   
S0    
C$_EADDRINUSE0      0   S1    C$_EADDRNOTAVAIL1   4  1   S2    C$_ENETDOWN2      2   "S    3    C$_ENETUNREACH3   *S4    C$_ENETRESET4   2S5    C$_ECONNABORTED5      5   :S6    
C$_ECONNRESET6   BS7    
C$_ENOBUFS7   JS8    
C$_EISCONN8   RS9    C$_ENOTCONN9   |  9   ZS:    C$_ESHUTDOWN:   bS;    C$_ETOOMANYREFS;   jS<    C$_ETIMEDOUT<   rS=    C$_ECONNREFUSED=   zS>    C$_ELOOP>   S?    C$_ENAMETOOLONG?   S@    C$_EHOSTDOWN@      @   SA       C$_ECONNREFUSED   C$_ELOOP   C$_ENAMETOOLONG   C$_EHOSTDOWN       C$_EHOSTUNREACH   C$_ERROR   C$_INV_FRAME   C$_KILL   
C$_LONGJMP   C$_LONGJMP_FAILED  ELN$LOCATE_CRTL_CTX 
       C$$TRANSLATE  i   $CODE     $DATA  @  TRANSLATION_TABLE  C$_EHOSTUNREACHA      A     P ^ R  ELN$LOCATE_CRTL_CTXPTЬQxQP@bP`QQ   xQP@bP`Q   xQP@P`S<SSdЬP        w w 1       c V4.1-00                         9     	C$TOLOWERV4.1-0010-OCT-1990 22:16                    VAX MACRO V5.0-9
      MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]TOLOWER/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]TOLOWER ELN_BUILD:[ELN.CRTL.SRC]TOLOWER+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - convert to lower case          	.  ABS  .    P       $CODE   P    
       TOLOWER & PPAP	ZP P   w w 1        V4.1-00                         9     	C$TOUPPERV4.1-0010-OCT-1990 22:17                        VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]TOUPPER/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]TOUPPER ELN_BUILD:[ELN.CRTL.SRC]TOUPPER+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - convert to upper case          	.  ABS  .    P       $CODE   P    
       TOUPPER & PPaP	zP P   w w 1       T V4.1-00                         <     VAXC$VARARGSV4.1-00    10-OCT-1990 22:17                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]VARARGS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]VARARGS ELN_BUILD:[ELN.CRTL.SRC]VARARGS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - set up pointers to variable argument l         	.  ABS  .    P    0   $CODE   P    
       
VAXC$VA_START & PPP   
      VAXC$VA_START_1 & PP    PP   
      
VAXC$VA_COUNT & Pl	լP   w w 1    <   ` V4.1-00                         8     C$VAXCIOV4.1-0010-OCT-1990 22:17                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]VAXCIO/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]VAXCIO ELN_BUILD:[ELN.CRTL.SRC]VAXCIO+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - VAX C I/O subsystem   C$$DDOPRINT  
C$$D                                                                                                                                                                                                                                                                           u $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                         "                DOSCAN  C$$GDOPRINT  
C$$GDOSCAN  C$$SOCKET_CLOSE  C$$SOCKET_READ  C$$SOCKET_WRITE  C$$TRANSLATE  C$_EBADF  C$_EBUSY  	C$_EEXIST  	C$_EINVAL  	C$_ENOENT  C$_ENOTSOCK  CALLOC  DAP$$CLEANUP  DAP$$ENCODE_CONTINUE  	DAP$ERASE  DAP$FIND  	DAP$FLUSH  DAP$GET  DAP$PUT  
DAP$REWIND  
DAP$UPDATE  	ELN$CLOSE  ELN$DECLARE_EXIT_HANDLER  ELN$OPEN  FREE  KER$CREATE_SEMAPHORE    KER$DISABLE_SWITCH  KER$ENABLE_SWITCH  
KER$SIGNAL  KE    R$WAIT_ANY 
     STDERR 
     STDIN 
     STDOUT  STRLEN         	.  ABS  .    P        $ABS$    P  P  P  P    ~   $DATA ~  PQ     Q                        >4653>4653>4653 @634     STDIN   P>3     STDOUT  P>3     STDERR  P>3     IO_MUTEX
  PQ      $  $CODE  P
   ALQ  h  DEQ    FOP  P  CTG  CBT  TEF  CIF  S    UP  SCF  SPL  TMD  TMP  
NEF  	RCK  WCK  DLT  MXV  RWO   POS  RWC   FSZ  N   MRS  d  )RAT      CR   BLK  FTN   PRN   >RFM   @  FIX  VAR  VFC  UDF   STM  STMLFSTMCR >SHR  M   GET  PUT   DEL  UPD  NIL  UPI  MSE   CTX  D  BIN  REC    yPfop=cif P
 PSYS$INPUT: SYS$OUTPUT: SYS$ERROR: P   
   CHMOD &D ݬ;P!P\^\0Ў\   WXЬP0>P  
   CHOWN &A     ݬ;PP\^\0Ў\ǐ ǒ P   
   CLOSE &.0XP1|2IX 3  3|~~ KER$WAIT_ANYkX 3  3~ 
KER$SIGNALPʏ   ӏ   Y L0!g0Pʏ   XH DAP$$CLEANUPP|~?ǎ ǐ ~H 	ELN$CLOSEP0ЎP0Pݬ C$$SOCKET_CLOSE0yP0ЎPPP  
   VAXC$GET_SDC  &F 0ӏ    C$_ENOTSOCK C$$TRANSLATEPǢPP  
       VAXC$GET_FCB  & 0PWPP  
   CREAT & 0ЬUVP0ЬPP   WX0ZԚlZZVެ\0,P
ЎVЎZ0HPЎVЎZ` ǘ 
|~t?ǎ ǐ O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H ELN$OPEN2Z
ZPȏ   P  
   DELETE  &: 0ЬUV0Ǣ  	DAP$ERASEP0ЎP01P)P  
 )  DUP & 0z1k0u+ЎYYkX 3  3~ 
KER$SIGNAL2ZP    X 3  3~ 
KER$SIGNALP  
   DUP2  &[0"ЬYYZYPX 3  3|~~ KER$WAIT_ANY ZjP+@P00X 3  3~ 
KER$SIGNAL޺PjYYPZIYiDX 3  3~ 
KER$SIGNALݬX 3  3|~~ KER$WAIT_ANYkX2XiX 3  3~ 
KER$SIGNALЬPqP   
 q  FCLOSE  &# ЬWP0|
~τԼP   
   
    FDOPEN  &c 0=ЬVU0Ur(UwUaff+[P 	C$_EINVALP0{PP   
   FFLUSH  & ЬWP0{   D0i0b
gʏ@      7H 	DAP$FLUSH0/;ǈ [ǌ Z[x	[[Z[R R~
~[
PH 	DAP$FLUSH0PPgP   
 g  FGETC &W ЬWP0EP1gV0% Dѧ@	Џ<SPP֧g0Pʏ      
   FGETNAME  &) ЬWP02P(Ǣ Ǥ cЬPP   
       FGETS & ЬWP01| P1ЬZЬ[ZZ~7gV0WF:
VPPVVZ
VnVZVZZn0\nZɔkЬPʏ    C$_EBADFP0[ߔʏ   P  
 l  	C$$FILBUF && ЬWP0g0
Pg֧P  
   	C$$FLSBUF &1 ЬW P0^0PP֧gPP   
   FOPEN & ߬l~n    
     _FOPEN  &߬l~n0
ЬUЬRS VSrVSw	Sa1Pb+VP0HЭZЭ\0oHP01E`     ǘ Swo |~t?ǎ ~O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H ELN$OPENPSЎn1 SaЎn1s Վ<PPP   WX0O
|~t?ǎ ǐ O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H ELN$OPENKG2Z
a
~Z[
[PX 3  3~ 
KER$SIGNAL 	C$_EINVAL P0Pt	P  
 t	  	C$$SOCKET &01"X 3  3~ 
KER$SIGNAL0<P0R*X 3  3
    ~ 
KER$SIGNALP0ЎP0PWWkX 3  3~ 
KER$SIGNALȏ   PP8P2x	PPP0PPP@PЬǢZPP0ЎP0  
 <
  
VAXC$DFPRINTF &  C$$DDOPRINT   
 F
  
VAXC$GFPRINTF &~  C$$GDOPRINTЬW P0
OP15ЎZ   ^^[Wݏ   ߬ݬ[jPQZ0yʏ   ЎPʏ   P
P  
 
  FPUTC & ЬW P0@
9gV0/gV֧g D 
ӏ   02ЬPѧ(,!Ч(,0ç    PP0	P֧,P0ЬPP,P   
 ,  FPUTS &I ЬW P0(Ь[Џ  Z: Zk 	C$_EINVALP0 [QZ0PcP   
 c  FREAD &U ЬWP03Ь[L Ь~լЬZ0nÎP C$_EBADFP0PP   
   FREOPEN && ЬWP0FP
~KԼl  
   VAXC$DFSCANF  &  
C$$DDOSCAN  
   VAXC$GFSCANF  &J  
C$$GDOSCANЬWP0PP1	ЎZ߬ݬݬjʏ   
P  
 
  FSEEK &/     ЬWP0}~
~[
PP/P   
 /  FTELL &) ЬWP0
~
~[
KP   
 K  FWRITE  &V ЬW P0=Ь[Ь~$լ$ЬZ0#0"яPnЬPЏ4SP0PP  
   GETCHAR &  W1P  
   GETNAME & 0(Ǣ Ǥ cЬPP   
   GETS  &s  WP0.LЬ[Џ  ZZ~gV04:
VPPVVZ
VnVZVZZn0nZɔ{ЬP[P'
P   
 '
  GETW  &+     ЬWP0
Z~n[0RЎPPJ
P   
 J
  ISATTY  & 0Y	PXP[
P   
 [
  LSEEK &0H 	Z	[ D1k Lѧ09ˏXVя  V+ǈ ǌ nՎǈ Ϭ 

4&

4&

4& 	C$_EINVALP0PP[&g0ǈ [ǌ Zլ19,[0Zg	Z[[P[PZPQ[ǈ Zǌ H 
DAP$REWIND1 P,GZ0Aǈ ݧTݧ|ǔ ~H DAP$FINDP<S0Ч,[<0Z[ǈ Zǌ 1[ǈ Zǌ  M+Ч|~ǧd|֧|ǈ ݧTݧ|~H     DAP$FINDЎ|ǈ ݧTݧ|~H DAP$FINDя<SPя<SP0z1B0Ϭ  4&4&4& 	C$_EINVALP0\[([çUUZZ[P,[0Z< V	Z[[P[,nx	,T0T VT~ݬPF L 	C$_EINVALP0
x	[UZUTUVTTUUTTggT}T~, n T}TTTg0KTUv[(;g0[([||~ǈ Ǆ ݧlݧTݧ|~H
 DAP$GET0y
P[,'Z0!<0PPZTT0PS, n TcZVgZ0[ǈ Zǌ [x	[[Z[P;P   
 ;  OPEN      &0jЬUЬVʏVP0ql*(`lZZެ\0`P08P1ǘ |~t?ǎ ~O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H ELN$OPENPVˏQя 
  Q
 	C$_EEXISTP1Cӏ   1|~?ǎ ~ݧPH 	ELN$CLOSEPP0ЎP0,lnTяSPӏ    	C$_ENOENTPP0fЎP1 lB(@ۚlZZެ\0
@P	07P1 ЬPP   WY0` ǘ ЬU0	|~t?ǎ ǐ O~N~~ݧh<ǖ ~ǜ ǘ k  ߧd\ߧXݧTݧPM~L~Ǣ ~H     ELN$OPENȏ   %!2Z

 Z%ZP0   
 >  VAXC$DPRINTF  &  C$$DDOPRINT   
 H  VAXC$GPRINTF  &  C$$GDOPRINT W P0OP10ЎZ   ^^[Wݏ   ߬ݬ[jPQZ0tЎPʏ   ʏ   PP   
   PUTCHAR &  W1P  
   PUTS  &[  W P0,5Ь[Џ  Z: Zk 	C$_EINVALP0k
[QZ0[Z0 PP   
   PUTW  &* ZЬW P0Ь    ~^[0
ЬP)P  
 )  READ  &f 0z
P1^ӏ   & P0
0=ZP<PP ʏ   ݬݬݬ C$$SOCKET_READ  
   REWIND  &! ЬWP0n0|~
~Ͽ   
   VAXC$DSCANF &  
C$$DDOSCAN  
   VAXC$GSCANF &P  
C$$GDOSCAN WP0=PP1ЎZ߬ݬ jʏ   P  
   SETBUF  &` ЬWP0Nլ=ЧЧլçPЬPЧЧgЧ                                                                                                                                                                                                                                                                             D*
 $      ELN042.D                       n 
                                               u}1                                                                                     w                               ^@/            AnwZZenJl3K27xAOfԱ&' 1.ngwB3+b`p ӄ
\:6l9
G
:jx.XU8`?z$VY.F	]]H[]#Ae2<psEXL̛z#A
Il\o?hu#w	"|T ?
tXAxp66_|Vd
O`$gze7RddC\AN*
k%xn#bNpc|F)Gߦ#,j*Kq|@"=e~Xfo6P+%Gsa*rkl	SQG<(sb$AL68ba)pTAbgxŠ}VoW
+ZXrQu$~G
_Bfop:DQGz%
q&;a'u$*4
!;{F8TQdKTb 
}UK $G+
qKjtdE;2OK)>ax2-$nOTs5Yq=,,xNd[89f	|SZ)ckMr|39t;sWs3G3TBP'"d4v#fB{!<r|JF=:/(6:i6]Ntl;cOTjօI6˒t0fEHMp|%~rz.T}]Gq_d3$4P_#9{#B.1 ry3#=fHnjRHVҧ N)ʹΕ9 ._YqxM^iZ 6d`HǩJĤ-Rbb
uwXütQqON{ؑ^6ݪAطeYrUoحJY[B"h"Yr-y|oo4.*BZ}K!8A| q_xgZ#fb710E͇vЯYuaprX;1/Ʈ{W\~3/F=4hEו6DuW|=Gﮠ1ZJC;VCirl'NHhCщbuvIGЬ9o%aZ*RӠuQZ 滛:
9LsJK4gp흽U5l=q.UIf*,yLzf~.؅XgIiveu~({'L:iCgy®u=N{S-°hݐ$8(&*:% ba[	lף	zQU#tOdS&<ϾaYJy%t.?
Teb<$5'JBuH(|4.rI%s"ge<@E1ыjA~\aA۷dҾ7R7 <tAuU~幍lE|o1:8Ɵe\S&/cZLDҋ,	 u5,w ;ME"Fڄ[N+	 NюjD0Q.@N\9f.=E4ƠB׵5!qg,,HB0#A)!&fF 8 OND9 ˣ W?8(M{6M?Ds̔8)ΛU\9KjA돗![J<CN7 y.8"?
qY$|ʸKVOe@qNgRm0.*%f	YL c	nXK;ϖIOVN%e
Gi֧MY?? [,ɫ֙]'B
ӽ5|3\B4V,+y_1#x,Erޞ&Kۃ}QyIV}?!Z	(I H=?(T?;i~
UVLkB6(qpT-~#i:CŶ_9iGE L0ԛT']60
<!zpg0T@ʠn8v]Qו	jI+ù;	;S
#6]UeI&&37Zۻn@YL}\_wP%FuoթPGjHxʦ1͟DQnWuǇ?P4,F'{fzG3K:23RTBzn:7(i*0`~
- usw .h0GP*M:|d`t(1;YS_ƙuT=b0/&&]
F9S:#m۠=5eEByVbVB`KC_%i?72v\!@pɥލClĤ1a#$ [}A]8=|c:<<Xm_Q(d༦ l
KSKC7cUH12G ^lõptvolJ@4+tT~|Z_h/en}VRU,U8a~فz۰:T-q.|UPCP3Sk֔瘣XW \5!O.8 jbY.&j1bzj~1im[@.?M)XkG 7|3+ce&@$ \D?[eJ@y!V5-E!(4Uq75)wR.a@쥞莒g7>g_&h	~b1~rC?ׇvK+N5LɓA1R^p{SYiT+%GBD"3{dg=SWQ/ܣ]?b${+p=roh0Wm>:Gԫ)ńi*)䱘cW9;,nuu9=w
:`0t>4Z༘Za^gS>A¾:[nC0
kDhΫȕO4w~$ZCmQ˅~E!0 EDc)Lk;t}Ir9oG5~وr'Lo|@b][5
VJɀ8WǨLt	;)!&~9iF?gnԽT
 [` 3ShltB]
}[ꖟOU`a˥ԓ[0m=K3q6"E|Г=~#LKlS`Q,@^~NaO]ӗ	E©9sQ"<* Pʲh ռȇ ֪2'&vzFV;{@0]dbfP6
M?ʲ"w vtK\<9`!K.[ cMaW8OwQFXՊpD븦"QgI|H^`*ǋ$	YqNT[}ܿ"z!Pྒྷt+^vU[~ƌw|#+DzeHأfo!ur:YQr%"3ydh"Qz-u!Z SEuTb{AgjH;6SDԲPAMKrM{ _!m[1Yb:@)USu`P]_II1;XM_'QqC0`GI'8
 @DfTX2vk*6z)-
 *X-SWP!q~0/#ٍBs'k4K	c{պkӢo6d>/k(^Zƹ?u̙Ƕ|l. ɁT0@fYDH4{>:3q]pf14q
*%"c
uhdA\29T:g'
JMkvdrDX߹*3\EJw=1y=fu49/P퀋NM*%H7{;Ɛ@v}?P=bgq}o.Kvi:fC熩x"à]f~$6(Cr<?ܛR@vgVXRM{E-q9Od!L{&ֽtbP?^VRbQN[1lפTW1bO97qeGkuT	=x~7*t=jE^3Kmc\HngR@\)iD	1v,r5R̷=FQU1NץV;M]diw	-
luY5N<`g`+0$<Cy,r66+ؼ(]sLe/IsG9&ċh	B1dd(͆r:>., ƶ>Y	y`OTR^~ 5y*[9NF:S-#h"5aH,NZ iC1~n"Lk;G=C
 T]"P
rWzf˵TÕ9Z߈Ɇ
AI^<#2}6~ˣƈz)Bh\~e}i}zR˧wQSmQa';
)
\ψ
&G+lG´yʫ![̚M	x*
i2R@}|
R4Zv.ylg&@<Y前|2y	H3-l߿(cJK$QGVpxIS^ AL
u@wCFk.3OKj/J캰Q:e0o؋M)kjh9	-|N@S\3$¬lrua<RBN!׫QI{ZlC>
)1j[F;<S' 5pW<sP=y[1-1ݝn^~?SIףRBZe}\9\@PǱEסSh@-
1B00q4D*f69DпP+ICF1x~	ҍ|"lML̑fMMԌSO 3BZc&N-9	xM=irq2T9N˔AǸd
 X!rSx4P2@39G
g|i!0Os"k
s1 "$,Ю,}I`,߭	dyq:w7.a{](W?F$<" 6ko2w)X߬lZ`\
3Jbߋ
h,EF~g#؊7X#;ngƴ^Q/I:?UXez[zJt:DP
nC-Ytfwe&FL0 `(L_ċEwFL5% Yq,5Ƒ9gkq JD[9fSջcgf5nD	4yG.SVQLӬkԒ^|wԇ;8/7ko+(]ӕ\s	l+`yan khL=|Sm; lAU\X#YspEJ.WT)V;Iᬵ{JMp[\F^V~@^4e3^K,c!'GoA+ dD7a䑝t(R繵̙qE5R+ |;M]A>]	/&~CSڑ+:JvyrO)sN:8
8͙&c ;P9@JJSKHxI
= Grp2ѮǬ ϱj
\rjc&=yī=+85Kƻdu
BOP  +Кx )Loh-w;<%R`2YK&>zG*}Oy2{{D1`Y8<cTf%hrMxbJB&
74PImB3m9yS(O#ۨ03[ <| rލb<?7+@Y4nkK=5
̚G+sH
5\U
w"Ac!d+Id{9k#̣3jNq-<flPWvpqކՆ,֧"Mַı}x@(([9h
P$s!'j#S0ۺm[BAVQ!
nθks%	4ٟQO3*H)Pߦ3>6$hƙcv!M}NH7\M{Sśa1SP(U#lЀ$n2B 1	4\߇\]-Ӂwv-{/y}bduX4Li,7@"NJ/E
(W}	(\=BkN_0Tn&eK1c6OB;RU S:8G& +3##&s%ĝ:T4 E@(8ө{xEuXga2vM%l:ci?HEXy$
n+̓tp֊_C(y<Q V[W'
WJo _rP{ݠeWI9;v"R!7d{I6v拦C%K/鄲PRI4QEg!/@ҵ/6wCuJ<^dY z0|w2Ho\xVVrH%0,[l?="|zCy7xAФO҄F#З@7\w9
629:TЖ/^X&XI$]+<Dǖ}iV$'n+VTӀP!ilTS%C\Z5-\.+ $\ɹ\n5y(ӲSdقQ/2qMaIT\pogf)9+LA9sJmgv" %7L`55:ʘWRڿ(Uot6ҥ0[|߹Ly4x}XK7Ʃ]13E+OtOnDzfȎ̿\`:
KU ġIjh^Mb',v^h8cY tU5:Yln%iMSKL݅GS#e7#[|@W4+GI=F8j,DT*aSTY8٘i 3U5F~4a/,"oogxc*$W#pPA@C[;|6a6#0@X^x'ca6aϪmv*:L0b5b㞟lFؤ-)	mmy8N%	7mܽx@L6TM&U	\Tၽy1pn,<ɔFy0yaI*<ɪ+\|AoYGoRzTBLua,c^^:|70H5Ore<$"aS%~2=Q:ǎ3Rо' ^
y<QGbD)6 (J Kj8a^@9wwp 
+]S3LII,+5M:Ti|\.>QD?	JQ &TS( 5>'tR@"KP3_:+"}{B$^Mp6pWPck pvvm$t-:~ +'9ǂ	>mSL7>c[0_Ikn~r>#Ն!8[gKHtV+ ߘzߧaGTCWX؏zkhK9ƩN+IIJC%}n5BjPfcK4UC;?GhV9?.o=N38;@.WJO6}ft+'^Ur*y@.@B7pL#5XB.!A/[yܵ}.~8d9JPo~4X>׋K3F(A[<$G).=P^ @.z/&
_s_v3ϨeaV"~_[rS-̺n#Vp(Ɣ zljaD?0aeй)`HG9_c4;w*e)?!9bu%w^41?0t+"k3DXM\I~f`8B39"8,\Y!){jX22dTQY
2םPI#bW/f7g,!|7"}L0fev͘&wd" -E ^R^GPQ"zC6W̾B9I2}_k5qLB+*brlq5(W3^O7hWjH6L8Y??DfGDQGRY?`@;Zru1!Z+t|x&%n)A[cH jXK
L_")flnG<HUh__xZYpz}@.
'k-n,'r>_{(&G*M.q:xLVtFFd@V?zc
,JD15jJa0k&`dI;zBNk<7r;g^OrmVhe]ASsFAoE\qC4.0,5.0,  			1                                                                                                                                                                           a. $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                         "                 
 C   
VAXC$DSPRINTF &  C$$DDOPRINTZ	   
 N   
VAXC$GSPRINTF &8  C$$GDOPRINTZ|~ݏ  ߬ݬݬjЬQ@aP  
 y  VAXC$DSSCANF  &  
C$$DDOSCANZ	   
   VAXC$GSSCANF  &X  
C$$GDOSCANZ  ^^WgЬЬݬ STRLENPgA^~^W߬ݬWjP   
     UMASK & <PP  
   UNGETC  &G ЬWP00P1 ЧQQѬP
PPqQgʏ   P   
   WRITE & 0    P1o ӏ   1=   P0 ! 0 Dӏ   0;<PP ʏ   ݬݬݬ C$$SOCKET_WRITE   
   _PARTIAL_PRINTF &ЬWЬ[ЬZ0sP C$_EBUSYP0ЎPP0X 3  3|~~ KER$WAIT_ANYҺZkP@P0 PkQAZQk[A[PP CALLOCPPPP|~?ǎ |~H 	ELN$CLOSE0 ЎP0*P.PPL-<Z2Ь[P P0>
gZP C$_EBADFP0PnP ^P Qa` ELN$DECLARE_EX    IT_HANDLER TSdTRBPS_SRPX 3  3|~~ KER$WAIT_ANY kRHТP	P FREEТP>Ǡ QQP	P FREEТtP	P FREER FREEkX 3  3~ 
KER$SIGNAL@PЬUP0|Վ|~t?ǎ ~O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H ELN$OPENЬP|~?ǎ |~H 	ELN$CLOSEPkRk~|PTZQPTZTT`PZkWRk C$_EBADFP0]PPVKW<W[gW4    
Z0V VL V0`gP C$_EBADFP0
IP  [k^~ KER$DISABLE_SWITCHm [k;>k 3   3~ KER$CREATE_SEMAPHORE^PQa` ELN$DECLARE_EXIT_HANDLER^~ KER$ENABLE_SWITCHm  ~ KER$ENABLE_SWITCHЏ	  PPPR<P0&X 3  3~ 
KER$SIGNALPWWkX 3  3~ 
KER$SIGNAL<WP0PtPY0'P d ǎ Ǖ ǔ ǜ 0ǎ >Ǡ     
NP
0P0 0Щ$,N1>Ǡ QQ
ݧ FREENNP0KPЧHQ` ˏwXVя V6Ǖ 0ǜ )< PDDPl01 PPT1 X1 ǜ 	ǘ 1 |~?ǎ |~H 	ELN$CLOSE0lȏ   ǘ ǜ |~t?ǎ ǐ O~N~ݏ   ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H ELN$OPEN0dDN<dR	< RRdRXD	xRPP<SRSPPǘ xPPl0PSЧЩPǐ ǘ ȏ    MBL V 	L    V	 	C$_EINVALP0RPŻǢ :  e&UQPPǢ UXP(PeǤ ЎP(Phǣ cXUPPӞ ^Ќ[X0=k4[V0PP)VY"ZԺ ^     Q4&Q    4&Q    `4&Q    4&Q    󺏀 ^0 	C$_EINVALP0f[0 Pk<UUV(WhWP[ kQkR0R	R

QRQP<UUV
    QJD4&Q    OD4&Q    TD4&Q    QfQfQfPP[0O  V0 P<TTUSSe,kPkP[0      V0b P<TTUePkPWXV k[k),k$=k?WWUaU
zUрUUW	 vWP-Wh 
fPPVPPPh PQAXQQhPQAHQQhPQA8QQhQ hUPQя<SPW@6QP1P C$$TRANSLATEQW! էHя4SPH DAP$$ENCODE_CONTINUEQQPP0X 3  3|~~ KER$WAIT_ANYܺWZѬZgk[bZZJ[k WN&X 3  3~ 
KER$SIGNAL0ZX 3      3~ 
KER$SIGNALZX 3  3~ 
KER$SIGNAL C$_EBADFP0 D1  0E0p g 0R0PgV0K Dѧ(,0V VЏ<SP0ZVZV(VkQVgS[VZ
ұ DPЧV|~ǈ Ǆ ݧlݧTݧ|ǔ ~H
 DAP$GETP"<Ǆ UDǘ +ǘ . ǘ 
1 1 0X
RSREfSU1 
EfU1 XЧTXTXX~ dP=UX(UfhЎP1XVXU
f
E
ExUXU(UhЎUЧVЎX1 	P
xPxPhPUU
f`|PfT%T+ P
QT T    $T0
T1QPPU(U@fVSUQQfT$T
EfUT0Qǜ NTTUЧVUgVP֧(Ч(||~ǈ Ǆ ݧlݧTݧ|~H
 DAP$GETPЧЏ   gPק(0 D1/ Ч<gP 0 Ч<g0Pg0 0 )Ч<g0Y֧(, g  P D1v Zӏ   :
ZkQ[QZgV 0dMZVZV(VkVgSQ[VnVZ0:#ӏ   
0nZPՎPgV0%ZVZV(VkSVgЦQ[VZPЧVVU0J PЧ<gP0    Џ   Pѧ(,çP|~ǈ PݧTݧ(~H	 DAP$PUT0D"P}U~ǘ Hǜ !U(NfЎUNTTVTU
Џ4SP11TP ǘ *ǘ 1 
EU1,T
EU1U1ff
Aӏ   'ʏ    ~}U~ޮVU0 }UT}U~1 f
ȏ   1PfP1Q+Qӏ    Qʏ    E
ȏ   U+E
U ӏ   Q1P
Q $Q QQ~P	(UfVSUfLXGDBxUTT^^S
R
R
RU

Sȏ   ^V^SUT^1 Ulǜ UdЏ4SP0T^}UPݧVˏw    XSя S% |~ǈ ݧlݧTH 
DAP$UPDATEЎ1 |~ǈ ݧlݧTݧ|ǔ ~H	 DAP$PUTЎǈ ,ǌ 0NVUVǜ ǜ ǜ VVV<0SVS 	SPP0	SPP,Ч,ǈ 0ǌ T^}U0ǜ -
P`
çPPdP,  D n PSէ(	 D<(Ч(QçP	PQQ,Q,0P0P0   w w 1       ` V4.1-00                         B     ELN$CLEANUP_P1_CTXV4.1-0010-OCT-1990 22:18                   VAX C V3.1-051   ELN$LOCATE_CRTL_CTX  KER$FREE_M    EMORY  KER$ENABLE_SWITCH  KER$DISABLE_SWITCH  
KER$DELETE 
      < ELN$CLEANUP_P1_CTX  Q   $CODE     $DATA    P< ^  ELN$LOCATE_CRTL_CTXP\?  KER$DISABLE_SWITCH^(n  
KER$DELETEݬ  
KER$DELETE\<2~  KER$FREE_MEMORY  KER$ENABLE_SWITCH        w w 1       
 V4.1-00                         9     	C$MEMFUNCV4.1-0010-OCT-1990 22:15                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]MEMFUNC/OBJEC    T=ELN_BUILD:[ELN.CRTL.OBJ]MEMFUNC ELN_BUILD:[ELN.CRTL.SRC]MEMFUNC+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB      	OTS$MOVE3          	.  ABS  .    P       $CODE   P|   
     | MEMMOVE & |  
    | MEMCPY  &1 lЬQЬQl 	OTS$MOVE3ЬPP'P|   
 '   | MEMSET  &8 ЬSЬVVRR  Џ  RRV, nRcVЬPYP|  
 Y   | MEMCMP  &L lPЬ    QЬSЬVVPP  Џ  PPV)PacVP
cSaQSQP P  
     MEMCHR  &9 ɑlPЬQЬRRPP  Џ  PPR:PaRQQP    w w 1       @ V4.1-00                         9     	C$BSEARCHV4.1-0010-OCT-1990 22:08                    VAX C V3.1-0510  
       BSEARCH  l   $CODE     $DATAr   P ^ЬVЬWլPѬVPSRSR> USRTTŬTPVP~WePQ	ŬTPVPQ	TRPTSSRP        w w 1       ' V4.1-00                             7     C$QSORTV4.1-0010-OCT-1990 22:08                    VAX C V3.1-051   P ^Ь4ѬЬSSˏ4Rz  SP{PQPP SD<Ѭ(ݬ CALLOCP<Ԯ8ZZ@lYY[Ю4jެWRgR4Ri
g ծ81M UjRRViSS(RS$Ѯ$ ׮8Z@Y[1gXQЮ$PXT
TP
րQ{TPQPQTQTPT
TP
Q{TPQPXQRQRQxXRTST P	ST_SR P	SRJRT P	RT5TRPgR݀VR PgSSV PSRSRS    V VSTS(RTR!j@gSkgSj֮8Z@Y[PgS@ikgSi֮8Z@Y[ծ81ެWRgB   FREE  CALLOC 
      QSORT    $CODE    $DATAR4RXЮ4SgSTSXt VTS PWgTݮD TRS47ݮ<S P*  UUSRϡ SRUSS4
ݮ<S Pgݮ@R}TSgTSXѬ(
ݮ< FREE< ^ UЬRЬQe$ХSSTSPT7bTaTPSPSХSSTSPTbTaTPSPS ^ЬRЬQЬPPRP        w w 1       >7 V4.1-00     
                        8     C$ASSERTV4.1-0010-OCT-1990 22:08                   VAX C V3.1-051   STDIN  STDOUT  STDERR  
VAXC$DFPRINTF  ABORT 
        _ASSERT  )   $CODE     $DATA 6   $CHAR_STRING_CONSTANTS   Passert error: expression = %s, in file %s at line %d
  P  ^ݬݬݬ  STDERR 
VAXC$DFPRINTF  ABORT         w w 1       sC V4.1-00                         8     C$STRTOKV4.1-0010-OCT-1990 22:16                   VAX MACR                                                                                                                                                                                                                                                                           h $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        R "                O V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]STRTOK/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRTOK ELN_BUILD:[ELN.CRTL.SRC]STRTOK+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB             	.  ABS  .    P       $DATA 
  PQ         $CODE   P|   
     | STRTOK  &  ^, n  nUЬQ n QЬRP@nQT: dUTQ+QdnU 5QVUQT: dUTQ*QdnU 		    Q VPP   w w 1        R V4.1-00                         8     C$STRTOLV4.1-0010-OCT-1990 22:16                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]STRTOL/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRTOL ELN_BUILD:[ELN.CRTL.SRC]STRTOL+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - convert string to long library functioS   C$_EDOM  	C$_ERANGE  ELN$LOCATE_CRTL_CTX      LIB$INT_OVER  
SYS$UNWIND          	.  ABS  .    P       $DATA   P              $ABS$ 	 PP       _CTYPE_ 
  PQ      <  $CODE   P    
       OVERFLOW_HANDLER  &1 ~~~ 
SYS$UNWINDЏ	  PP|   
    |STRTOL  &  ELN$LOCATE_CRTL_CTXPXlЬS
SS$
P C$_EDOM7:=%RRhЬR TUm  LIB$INT_OVERP@dTP-TTP+RRVS&
S0SP PPX   SRVRS0    P PPX   㚂PP9 PP0P
PSSUPUTUSլЬRRVR LIB$INT_OVERSPЏST(U   bPP9 PP0PPSЏ   S 	C$_ERANGE7:=%PPhPP   
 P  STRTOUL &)  ELN$LOCATE_CRTL_CTXPXlЬS
SS$
P C$_EDOM7:=%RRhPЬR TVP@dTP-TTP+RRUS&
S0SP PPX   SRURS0P PPX   㚂PP9 PP0PPSzSVPVWЏV 	C$_ERANGE7:=%PPhzTV VլЬR
    RURVP    w w 1       ~c V4.1-00                         7     C$ABORTV4.1-0010-OCT-1990 22:15                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ABORT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ABORT ELN_BUILD:[ELN.CRTL.SRC]ABORT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - abort the current process <   C$$COND_HAND  ELN$LOCATE_CRTL_CTX  
ELN$LOG_EVENT         	.      ABS  .    P        $ABS$    P    J   $CODE 7  P %C-F-ABORT, user requested abortQ Q        
 !     ABORT &R ۚ~ 
ELN$LOG_EVENT  ELN$LOCATE_CRTL_CTX`m C$$COND_HANDm P   w w 1       :q V4.1-00                         8     C$DIVIDEV4.1-0010-OCT-1990 22:15                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]DIVIDE/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]DIVIDE ELN_BUILD:[ELN.CRTL.SRC]DIVIDE+ELN_BUILD:[ELN.    CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB      
     LDIV          	.  ABS  .    P    %   $CODE   P   
      DIV &% լݏ ݬ{nQR޼SQRc    w w 1       | V4.1-00                         8     C$STRSTRV4.1-0010-OCT-1990 22:10                   VAX C V3.1-051/  
      | STRSTR  X   $CODE     $DATA ^   P| ^ЬPЬScR=ެT  VVUcPPU"SR  QQRa
    PSPbPPabScPP        w w 1    	    V4.1-00                         9     	C$STRINGSV4.1-0010-OCT-1990 22:16                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]STRFUNC/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]STRFUNC ELN_BUILD:[ELN.CRTL.SRC]STRFUNC+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB            	.  ABS  .    P      $CODE   P    
           STRLEN  & ЬQ: aìQPP|  
    | STRCPY  &0 }SV: dVTQR(RdcQTVcЬP>P  
 >    STRNCPY &g }SЬWOЏ  VVWWV: Vd(VdcQTVW,TQR
RW(RdcQTЏ  VVWWV, n VcVWЬP P|   
    | STRCAT  &< }QV: aQS: bVRQP(PbcQRVcЬP P  
     STRNCAT &M }QЬW5V: aQS: bVRQPPWWPPW(PbcQRVڔcЬPP<   
   < STRCSPN &Z  ^, n  nUЬQ6ЬR
: a
    &P@nQT: dUTQ*QdnUìQPlP<  
 l  < STRSPN  &Z  ^, n  nUЬQ6ЬR
: a&P@nQT: dUTQ+QdnUìQPP|  
   | STRPBRK &I  ^, n  nUЬQ.P@nЬQQT: dUTQ*QdnUQP    w w 1       z V4.1-00                         :     
ELN$CSRSHRV4.1-0010-OCT-1990 22:10                   VAX C V3.1-051   C$_EPERM   	C$_ENOENT   C$_ESRCH   C$_EINTR   C$_EIO   C$_ENXIO   C$_E2BI    G   
C$_ENOEXEC   C$_EBADF   	C$_ECHILD   	C$_EAGAIN   	C$_ENOMEM   	C$_EACCES   	C$_EFAULT   
C$_ENOTBLK   C$_EBUSY   	C$_EEXIST   C$_EXDEV   	C$_ENODEV   
C$_ENOTDIR   	C$_EISDIR   	C$_EINVAL   	C$_ENFILE   	C$_EMFILE   	C$_ENOTTY   
C$_ETXTBSY   C$_EFBIG   	C$_ENOSPC   	C$_ESPIPE   C$_EROFS   	C$_EMLINK   C$_EPIPE   C$_EDOM   	C$_ERANGE    C$_EWOULDBLOCK   C$_EINPROGRESS   C$_EALREADY   C$_ENOTSOCK   C$_EDESTADDRREQ   C$_EMSGSIZE   
C$_EPROTOTYPE       C$_ENOPROTOOPT   C$_EPROTONOSUPPORT   C$_ESOCKTNOSUPPORT   
C$_EOPNOTSUPP   C$_EPFNOSUPPORT   C$_EAFNOSUPPORT   
C$_EADDRINUSE   C$_EADDRNOTAVAIL   C$_ENETDOWN   C$_ENETUNREACH   C$_ENETRESET   C$_ECONNABORTED   
C$_ECONNRESET   
C$_ENOBUFS   
C$_EISCONN   C$_ENOTCONN   C$_ESHUTDOWN   C$_ETOOMANYREFS   C$_ETIMEDOUT    C$_ECONNREFUSED   C$_ELOOP   C$_ENAMETOOLONG   C$_EHOSTDOWN   C$_EHOSTUNREACH   C$_ERROR   C$_INV_FRAME   C$_KILL   
C$_LONGJMP   C    $_LONGJMP_FAILED  	C$$SOCKET  C$$TRANSLATE  VAXC$GET_SDC  ELN$IPC_GETPEERNAME  ELN$IPC_GETSOCKETNAME  ELN$IPC_DELETE_SOCKET  ELN$IPC_CREATE_SOCKET  ELN$IPC_ACCEPT  ELN$READ_ERRNO  ELN$IPC_RECV  ELN$IPC_SEND  ELN$IPC_BIND  ELN$IPC_CONNECT  ELN$IPC_LISTEN  ELN$IPC_RECV   P  ^ݬ VAXC$GET_SDCP߭߭ ELN$IPC_DELETE_SOCKETЭP  ELN$READ_ERRNOP  ^ݬ VAXC$GET_SDCP4ԭ߭|~ݬݬP߭ ELN$IPC_RECVݭ C$$TRANSL    ATEPЭPP  ^ݬ VAXC$GET_SDCP4ԭ߭|~ݬݬP߭ ELN$IPC_SENDݭ C$$TRANSLATEPЭPP  ^ݬ VAXC$GET_SDCPQݬݬ߭P߭ ELN$IPC_ACCEPTݭ C$$TRANSLATEPݭ 	C$$SOCKETPѭ
߭߭ ELN$IPC_DELETE_SOCKETЭPP  ^ݬ   VAXC$GET_SDCP'ݬݬP߭ ELN$IPC_BINDݭ C$$TRANSLATEPPPP  ^ݬ VAXC$GET_SDCP'ݬݬP߭ ELN$IPC_CONNECTݭ C$$TRANSLATEPPPP  ^ݬ     VAXC$GET_SDCP$ݬP߭ ELN$IPC_LISTENݭ C$$TRANSLATEPPP  ^ݬ VAXC$GET_SDCP6Ь߭|~ݬݬP߭ ELN$IPC_RECVݭ C$$TRANSLATEPЭPPP  ^լݏS C$$TRANSLATEPݬ VAXC$GET_SDCP:Ь߭ݬݬݬݬP߭ ELN$IPC_RECVݭ C$$TRANSLATEPЭPP  ^ݬ VAXC$GET_SDCP1Ь߭ݬP߭ ELN$IPC_RECVMSGݭ C$$TRANSLATEPЭPP^լЬWP@WW@   WݏS C    $$TRANSLATEPTXVUYTWsz  UP{ PQPPVUxUPPRRRPRRR
PPPP TSVU~ VAXC$GET_SDCPCPTX	TRBTUTWXF߭ݬݬݬݬX߭ ELN$IPC_SELECTЭRRjSYR C$$TRANSLATE
RYЭYY
ݭ C$$TRANSLATEYP  ^ݬ   ELN$IPC_RECV  ELN$IPC_RECVMSG  ELN$IPC_SELECT  ELN$IPC_SEND  ELN$IPC_SENDMSG  ELN$IPC_SEND  ELN$IPC_SHUTDOWN  ELN$IPC_GETSOCKOPT  ELN$IPC_SETSOCKOPT  ELN$I    PC_CONTROL_SOCKET 
        C$$SOCKET_CLOSE 
  4     C$$SOCKET_READ 
       C$$SOCKET_WRITE 
       ACCEPT 
  4    BIND 
  t    CONNECT 
      LISTEN 
      RECV 
  @    RECVFROM 
      RECVMSG 
    SELECT 
      SEND 
  h    SENDMSG 
      SENDTO  VAXC$GET_SDCP6Ь߭|~ݬݬP߭ ELN$IPC_SENDݭ C$$TRANSLATEPЭPPP  ^ݬ VAXC$GET_SDCP1Ь߭ݬP߭ ELN$IPC_SENDMSGݭ C$$TRANSLATEPЭP                                                                                                                                                                                                                                                                           hw $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        i "                P  ^լݏS C$$TRANSLATEPݬ VAXC$GET_SDCP:Ь߭ݬݬݬݬP߭ ELN$IPC_SENDݭ C$$TRANSLATEPЭPP  ^ݬ VAXC$GET_SDCP$ݬP߭ ELN$IPC_SHUTDOWNݭ C$$TRANSLATEPPP  ^߭ݬݬݬ߭ ELN$IPC_CREATE_SOCKETݭ C$$TRANSLATEPݭ 	C$$SOCKETPѭ
߭߭ ELN$IPC_DELETE_SOCKETP  ^ݬ VAXC$GET_SDCP'ݬݬP߭ ELN$IPC_GETPEERNAMEݭ C$$TRANSLATEPPPP      ^ݬ VAXC$GET_SDCP'ݬݬP߭ ELN$IPC_GETSOCKETNAMEݭ C$$TRANSLATEPPPP  ^ݬ VAXC$GET_SDCP-ݬݬݬݬP߭ ELN$IPC_GETSOCKOPTݭ C$$TRANSLATEPPP  ^ݬ VAXC$GET_SDCP-ݬݬݬݬP߭ ELN$IPC_SETSOCKOPTݭ   
      SHUTDOWN 
  T    SOCKET 
      GETPEERNAME 
      GETSOCKNAME 
  ,    
GETSOCKOPT 
  p    
SETSOCKOPT 
      VAXC$SOCKET_CONTROL    $CODE     $DATAi  C$$TRANSLATEPP	    P  ^ݬݬݬ߭ ELN$IPC_CONTROL_SOCKETݭ C$$TRANSLATEPP         w w 1       P V4.1-01                         9     	C$AUXCNBOV4.1-0110-OCT-1990 22:17                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]AUXCNBO/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]AUXCNBO ELN_BUILD:[ELN.CRTL.SRC]AUXCNBO+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB            	.  ABS      .    P     0   $CODE   P$   
     $ HTONL & $  
    $ NTOHL & ЬUUPPPURRP   
      NTOHS &    
       HTONS & PQQP   w w 1       ` V4.1-00                         9     	C$AUXCSHRV4.1-0010-OCT-1990 22:11                    VAX C V3.1-051   P         (((((                  DDDDDDDDDDAAAAAABBBBBB  P!UW.!UW.!UW.!UW  P 0^     Rԭ}}ҰꞬQ ְbްژaPˏ P옡Pˏ PPˏ PPˏ P߭쟭?꟭ SYS$FAOL<P@   P^ЬRޭYRPT
Qb0QRbxbXQRbPgPPUUUEϢTQVPU0UVUTR?PQ<PUUVFy-xTXPW
WFhaVAVVUUWWXTRbPb.ޭUUYUPTR1WPb bUUUEPTޭRRYSSSPP P~P?PЭTrPxSˏ   RRST\xSˏ RxRRRSˏ  RRST8xSˏ RxRRRSˏ RxRR    RSˏ RRSTPT HTONLPTTP ^ݬ NTOHLPRP	ˏ   RPˏ?RPP   	ˏ  RPˏ RPP ^ЬQQ   xQPɬPR PQ   xQPɬPR	xQPɬPRR HTONLPRRPP ^ݬ NTOHLPRPˏ RPPPˏ?RPP   ˏ  RPPPˏ   RPPPP^ЬRޭYRPT
Qb0QRbxbXQRbPgPPU   SYS$FAOL  HTONL  NTOHL  HTONL  NTOHL 
      	INET_NTOA 
    	INET_ADDR 
     
INET_LNAOF 
     
INET_MAKEADDR 
  0        
INET_NETOF 
    INET_NETWORK    $CODE    $DATA    $CHAR_STRING_CONSTANTS UUE2TQVPU0UVUTR?PQ<PUUVF	-xTXPW
WFaVAVVUUWWXTRbPb.ޭUUYUPTR1WPbbUUUEϪPTޭRRYSSSPTPSPxTTˏ @RRTPPSTP  P  0 T        w w                                                                                                                                                                         1        X V4.1-00                         6     C$ACOSV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ACOS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ACOS ELN_BUILD:[ELN.CRTL.SRC]ACOS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB "  - arcosine math library function#   C$$MATH_HAND  MTH$DACOS_R7          	.  ABS  .    P       $CODE   P       
      
VAXC$DACOS  &*  C$$MATH_HANDmpP MTH$DACOS_R7   w w 1        !́ V4.1-00                         7     C$GACOSV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GACOS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GACOS ELN_BUILD:[ELN.CRTL.SRC]GACOS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB"  - arcosine math library function#   C$$MATH_    HAND  MTH$GACOS_R7          	.  ABS  .    P       $CODE   P   
      
VAXC$GACOS  &+  C$$MATH_HANDmPP MTH$GACOS_R7    w w 1       @c܁ V4.1-00                         6     C$ASINV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ASIN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ASIN ELN_BUILD:[ELN.CRTL.SRC]ASIN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB    +TOPD$:[KERNEL.OBJ]KERMAC/LIB !  - arcsine math library function #   C$$MATH_HAND  MTH$DASIN_R7          	.  ABS  .    P       $CODE   P   
      
VAXC$DASIN  &*  C$$MATH_HANDmpP MTH$DASIN_R7   w w 1         V4.1-00                         7     C$GASINV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GASIN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GASIN ELN_BUILD:[ELN.CRTL.SRC]GASIN+ELN_BUIL    D:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB!  - arcsine math library function #   C$$MATH_HAND  MTH$GASIN_R7          	.  ABS  .    P       $CODE   P   
      
VAXC$GASIN  &+  C$$MATH_HANDmPP MTH$GASIN_R7    w w 1        V4.1-00                         6     C$ATANV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.L    IS]ATAN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ATAN ELN_BUILD:[ELN.CRTL.SRC]ATAN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB $  - arctangent math library function   MTH$DATAN_R7         	.  ABS  .    P    
   $CODE   P   
      
VAXC$DATAN  & pP MTH$DATAN_R7   w w 1       D V4.1-00                         7     C$GATANV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0    -9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GATAN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GATAN ELN_BUILD:[ELN.CRTL.SRC]GATAN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB$  - arctangent math library function   MTH$GATAN_R7         	.  ABS  .    P       $CODE   P   
      
VAXC$GATAN  & PP MTH$GATAN_R7    w w 1          V4.1-00                         7     C$ATAN2V4.1-001    0-OCT-1990 22:11                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ATAN2/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ATAN2 ELN_BUILD:[ELN.CRTL.SRC]ATAN2+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB$  - arctangent math library function   
MTH$DATAN2         	.  ABS  .    P       $CODE   P    
       VAXC$DATAN2 &  
MTH$DATAN2    w w 1       `B- V4.1-0
    0                         8     C$GATAN2V4.1-0010-OCT-1990 22:13                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GATAN2/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GATAN2 ELN_BUILD:[ELN.CRTL.SRC]GATAN2+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB $  - arctangent math library function   
MTH$GATAN2         	.  ABS  .    P       $CODE   P    
       VAXC$GATAN2 &      
MTH$GATAN2    w w 1        : V4.1-00                         6     C$ATOFV4.1-0010-OCT-1990 22:07                   VAX C V3.1-051   P ^ TPPRBdP֬PPP@d SRcQQ+1 QPP+  P
Pj?PPe   GaR	Rd   SRGPRd   eR5R
R*PR#PR
#
RPRd   dR
PS1CPìSЬ"|~ OTS$CVT_T_DPRPpPR C$$TRANSLATErP  ^ TV  ELN$LOCATE_CRTL_CTXPWЬRRUbPPR                                                                                                                                                                                                                                                                           Ӟy $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        k "                Bd֬PPP@d SRcQQ+1 QPP+ P
P2?PPe   SmR	Rd   _Rc-VRGPRd   eR5R
R*PR#PR
#
RPRd      
C$V_CTYPEDEFS  ELN$LOCATE_CRTL_CTX  C$$TRANSLATE  OTS$CVT_T_D  C$$TRANSLATE  OTS$CVT_T_D 
      
VAXC$DATOF 
  8   VAXC$DSTRTOD    $CODE     $DATA      _CTYPE_ ^ dR
PS17PìS!gЬRUb|PЬЬRSb"|~ OTS$CVT_T_DPUP:s0&|~ OTS$CVT_T_DPRPR,     "gPR C$$TRANSLATEpPU, "gV
p.RPp,RpRPU C$$TRANSLATE|P PN  N   n n n n n n n n n n              VPN  N   b b b b b b b b b b                    w w 1       @@J V4.1-00                         7     C$GATOFV4.1-0010-OCT-1990 22:08                    VAX C V3.1-051   P       P 0P ^ TPPRBdP֬PPP@d SRcQQ+1 QPP+  P
PJ?PPe   GaR	Rd       SRGPRd   eR5R
R*PR#PR
#
RPRd   dR
PS1CPìSЬ"|~ OTS$CVT_T_GPRPPPR C$$TRANSLATEPϦP  ^ TV  ELN$LOCATE_CRTL_CTXPWЬRRUbPPRBd֬PPP@d SRcQQ+1 QPP+ P
P?PPe   SmR	Rd   _Rc-VRGPRd   eR5R
R*PR    
CC$_GFLOAT   
C$V_CTYPEDEFS  ELN$LOCATE_CRTL_CTX  C$$TRANSLATE  OTS$CVT_T_G  C$$TRANSLATE  OTS$CVT_T_G 
  0    
VAXC$G    ATOF 
  \   VAXC$GSTRTOD    $CODE     $DATA      _CTYPE_#PR
#
RPRd   dR
PS17PìS!gЬRUbPσPЬЬRSb"|~ OTS$CVT_T_GPUP?Q]0&|~ OTS$CVT_T_GPRPR, "gPR C$$TRANSLATEPPU, "gV	PRPRPRPU C$$TRANSLATEPP PN  N   n n n n n n n n n n              vPN  N   b b b b b b b b b b                0    w w 1        	[ V4.1-00                             6     C$CEILV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]CEIL/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]CEIL ELN_BUILD:[ELN.CRTL.SRC]CEIL+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB !  - ceiling math library function          	.  ABS  .    P       $CODE   P   
      
VAXC$DCEIL  & pPtP RR`PbRP    w w 1           `Kj V4.1-00                         7     C$GCEILV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GCEIL/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GCEIL ELN_BUILD:[ELN.CRTL.SRC]GCEIL+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB!  - ceiling math library function          	.  ABS  .    P       $CODE   P   
      
VAXC$GCEIL  & PPTP RR    @PBRP    w w 1        x V4.1-00                         5     C$COSV4.1-0010-OCT-1990 22:11                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]COS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]COS ELN_BUILD:[ELN.CRTL.SRC]COS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - cosine math library function   MTH$DCOS_R7          	.  ABS  .    P    
   $CODE   P   

          	VAXC$DCOS & pP MTH$DCOS_R7    w w 1       @I V4.1-00                         6     C$GCOSV4.1-0010-OCT-1990 22:13                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GCOS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GCOS ELN_BUILD:[ELN.CRTL.SRC]GCOS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB    - cosine math library function   MTH$GCOS_R7          	.  ABS  .  
      P       $CODE   P   
      	VAXC$GCOS & PP MTH$GCOS_R7   w w 1         V4.1-00                         6     C$COSHV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]COSH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]COSH ELN_BUILD:[ELN.CRTL.SRC]COSH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - hyperbolic cosine math library f    unctio    C$$MATH_HAND  	MTH$DCOSH         	.  ABS  .    P       $CODE   P    
       
VAXC$DCOSH  &'  C$$MATH_HANDm 	MTH$DCOSH    w w 1       @諂 V4.1-00                         7     C$GCOSHV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GCOSH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GCOSH ELN_BUILD:[ELN.CRTL.SRC]GCOSH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALI    B.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - hyperbolic cosine math library functio    C$$MATH_HAND  	MTH$GCOSH         	.  ABS  .    P       $CODE   P    
       
VAXC$GCOSH  &'  C$$MATH_HANDm 	MTH$GCOSH    w w 1       ࣹ V4.1-00                         :     
C$$DOPRINTV4.1-0010-OCT-1990 22:11                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]DOPRINT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]DOPRINT ELN_BUILD:[E	    LN.CRTL.SRC]DOPRINT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - print and scan   	C$$FILBUF  ELN$$FAO  FOR$CVT_D_TE  FOR$CVT_D_TF  FOR$CVT_D_TG  OTS$CVT_TI_L  OTS$CVT_TO_L  OTS$CVT_TZ_L  OTS$CVT_T_D         	.  ABS  .    P        $ABS$ 
   P  P  P      $CODE < P!OL!XL!SL!UL                                                                 @                             @                                                                                                                                       doxucsefgDOXUEGp%doxscef[DOXEFip,P  
 ,  C$$DDOPRINT &Ψ^ͨ< ԭԭЬZЬXЬY[: hP  W:%Wh}P~PWPXQ0P1}WXW1ԭ ԭԭhn00h*
ЉXW]1Y+WhPWRXh09R*.0XW1-h*
ЉXW1+WhPWRXS}PW0Pѭ   1 h.IXW1 h*Љ    XW.1 +WhPWRXS}PW0rP   1 PhlXWh:h
ͨQhaP
0JP1f ͨSVѭPK譾/PV}P~0a-a+
ac0aSVT, aTVc}PVRT ,PaTRcЭPͨQP	XW1SЭPìZQP~P[P~.([ajSZjQìZ~ݬݬPЎQЬZ[ЎPΎ[(PajSZjPhATh-譾KXW1h+譽6XW1wh#譿!XW1bh 譼XW1M魽RА+ͨ(Rcͩ	ͨ6PP 4&N4&4&#4&4&R    4&4&N4&+4&4&$4&4&#4&4&R4&4&אiͨՉPͨQP:  P  P譹խ P
ѭPЭPЉQ ܚ݉ ELN$$FAOP;0ͨPQ譿Qܚ݉ ELN$$FAOP0;0ͨPQ魿
Xq0qP譺}PRA RPܚЉRR ELN$$FAOP<PͨQR魽+qP	魼 qP	ܚ݉ ELN$$FAOP<PͨQpi~~魹Эn߭~~s 	 FOR$CVT_D_TF     FOR$CVT_D_TGPT;  ͨs魽+qP	魼 qP}PR:EPa	譺" a: RcPR譿q0SQRRa.R}RPTpi~  ~魹Эn߭~~ FOR$CVT_D_TEP3譺:E ͨ a;  ͨs魽+qP	魼 qPPpi~魹Эn߭~~ FOR$CVT_D_TFP;  ͨs魽+qP	魼 qP譿魹խPXWЭP   
   
C$$DDOSCAN  &Ь[ЬXЬVfVPΨ^ԭʏ @  ЦZfY DѦ(,0Y YP13: hP  WYW19Y0C1ԭ+WhPW}PW0}BW;h    %Q*Wh0PWT}P~TUYTYT)ThjTU0 TWTXUT1 1 }WTYSZWh%1WXhn0Z1_*h	WX+WhPWRXSPWzQX0PlhWcXhh	WRXRWRZ R:R5譸魰֭1P ЭP
ЏPЭPæZQQfZЦf}fY PAݬ 	C$$FILBUFP,fצPЦZfY DѦ(,0Y Y
YPYP+Yj}PYPPTP
PY0pԭԭT >	4&;	4&64&64&	4&                                                                                                                                                                                                                                                                           0g $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                         "                	4&	4&^4&64&64&
4&
4&	4&	4&	4&4&Y%PP譸
ЋP譶``PZЭP	֭PY0YԭjRB1 jR@BB1 jRBAjRB 301jjR@BjRB
1I0_1? OTS$CVT_TZ_LT1- j-j+ OTS$CVT_TI_LT OTS$CVT_TO_LT ЭU< UѭU1ͨS魵j01U jRBR03UͨíS     魶n߭譸ЋndPЭPS譸ЋSխ֭ЭTTYYT魸
TZQTYP
,Yj TcY0t}PYPU譸ЋUխЏ  ЭTTYYT*Tj T譸
(YjecSU0"PT~譸
(njecnZYP ͨUЭT< Tj-j+Y0P1 T1 TАjRBY0TTѭT譱Ta譴'譳Yj.Y0q	FP1 T;譱1z T+jEjeY09PPT1D譱1D ͨíU~~߭߭ OTS$CVT_T_DP"譸ЋU魷
p    eveЭPPU譸ЋU:]WhPЭRЏRPWSXTPWQXd^ST:jSd魲'#魸ZY
0q	PR譸eЭPXWY   w w 1        ς V4.1-00                         ;     C$$GDOPRINTV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GDOPRINT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GDOPRINT ELN_BUILD:[ELN.CRTL.SRC]GDOPRINT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[	    SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - print and scan   	C$$FILBUF  ELN$$FAO  FOR$CVT_G_TE  FOR$CVT_G_TF  FOR$CVT_G_TG  OTS$CVT_TI_L  OTS$CVT_TO_L  OTS$CVT_TZ_L  OTS$CVT_T_G         	.  ABS  .    P        $ABS$ 
   P  P  P     
  $CODE < P!OL!XL!SL!UL                                                                 @                         @                                                                                                                                           doxucsefgDOXUEGp%doxscef[DOXEFip,P  
 ,  C$$GDOPRINT &Π^͠< ԭԭЬZЬXЬY[: hP  W:%Wh}P~PWPXQ0P1}WXW1ԭ ԭԭhn0
0h*
ЉXW]1Y+WhPWRXh09R*.0XW1-h*
ЉXW1+WhPWRXS}PW0Pѭ   1 h.IXW1 h*ЉXW.1 +WhPWRXS}PW0rP   1 PhlXWh:h    
͠QhaP
0JP1f ͠SVѭPK譶/PV}P~0a-a+
ac0aSVT, aTVc}PVRT ,PaTRcЭP͠QP	XW1SЭPìZQP~P[P~.([ajSZjQìZ~ݬݬPЎQЬZ[ЎPΎ[(PajSZjPhATh-譶KXW1h+譵6XW1wh#護!XW1bh 譴XW1M魵RȐ+͠(Rc͡	͠6PP 4&N4&4&#4&4&R4&4&N4&]4&4&$4&4&#4&4&    R4&4&אi͠ՉP͠QP:  P  P譱խ P
ѭPЭPЉQ Ԛ݉ ELN$$FAOP;0͠PQ護QԚ݉ ELN$$FAOP0;0͠PQ魷
Xq0qP譲}PRA RPԚЉRR ELN$$FAOP<P͠QR魵+qP	魴 qP	Ԛ݉ ELN$$FAOP<P͠QPi~~魱Эn߭~~S 	 FOR$CVT_G_TF FOR$CVT_G_TGPe;  ͠S魵+qP	魴 qP}PR: RcPR}RP:EPa譲 a0    R護q0 SQRRa.R}RP PPi~~魱Эn߭~~ FOR$CVT_G_TEP;  ͠S魵+qP	魴 qP}PR: RcPR}RP:EPa譲 a0R}RPPi~魱Эn߭~~ FOR$CVT_G_TFP1;  ͠S魵+qP	魴 qP護魱խP19XWЭP  
   
C$$GDOSCAN  &Ь[ЬXЬVfVPΠ^ԭʏ @  ЦZfY DѦ(,0Y YP13: hP  WYW19Y0C1ԭ+WhPW}PW0}BW;h%Q*Wh0PWT}P~TUYTYT)Thj    TU0 TWTXUT1 1 }WTYSZWh%1WXhn0\1_*h	WX+WhPWRXSPWzQX0PlhWcXhh	WRXRWRZ R:R5議魨֭1P ЭP
ЏPЭPæZQQfZЦf}fY PAݬ 	C$$FILBUFP,fצPЦZfY DѦ(,0Y Y
YPYP+Yj}PYPPTP
PY0pԭԭدT 	
	4&r	
	4&m
	4&m
	4&	
	4&)

	4&

	4&
	4&m    
	4&m
	4&

	4&
	4&	
	4&)

	4&

	4&,	
	4&Y%PP議
ЋP譮``PZЭP	֭PY0YԭjRB1 jR@BB1 jRBAjRB 301jjR@BjRB
1I0_1? OTS$CVT_TZ_LT1- j-j+ OTS$CVT_TI_LT OTS$CVT_TO_LT ЭU< UѭU1͠S魭j01U jRBR03U͠íS 魮n߭議ЋndP    ЭPS議ЋSխ֭ЭTTYYT魰
TZQTYP
,Yj TcY0t}PYPU議ЋUխЏ  ЭTTYYT*Tj T議
(YjecSU0"PT~議
(njecnZYP ͠UЭT< Tj-j+Y0P1 T1 TȐjRBY0TTѭT譩Ta譬'譫Yj.Y0q	FP1 T;譩1| T+jEjeY09PRT1D譩1F ͠íU~~߭߭ OTS$CVT_T_GP$議ЋU魯Pe	3eЭPPU議Ћ     U:]WhPЭRЏRPWSXTPWQXd^ST:jSd魪'#魰ZY
0o	PR議eЭPXWY   w w                                                                                                                                                                                                                                                                                                                                                                               1     @Ђ  THISSELL    C$ACOSC$GACOSC$ASINC$GASINC$ATANC$GATANC$ATAN2C$GATAN2C$ATOFC$GATOFC$CEILC$GCEILC$COSC$GCOSC$COSHC$GCOSH
C$$DOPRINTC$$GDOPRINT 롄  THISSELL    C$ECVTC$GECVTC$EXPC$GEXPC$FABSC$GFABSC$FLOORC$GFLOORC$FMODC$GFMODC$FREXPC$GFREXPC$GCVTC$GGCVTC$HYPOTC$GHYPOTC$LDEXPC$GLDEXP [  THISSELL    C$LOGC$GLOGC$LOG10C$GLOG10C$MODFC$GMODFC$POWC$GPOWC$SINC$GSINC$SINHC$GSINHC$SQRTC$GSQRTC$TANC$GTANC$TANHC$GTANHK qX
    1         V4.1-00                         6     C$ECVTV4.1-0010-OCT-1990 22:12                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]ECVT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]ECVT ELN_BUILD:[ELN.CRTL.SRC]ECVT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - floating to text conversion T   C$K_ECVT_BUFFSIZE  ELN$LOCATE_CRTL_CTX  FOR$CVT_D_TF  OTS$$CVT_D_T_R8         	.  A    BS  .    P       $CODE   P  
     
VAXC$DECVT  &l   ELN$LOCATE_CRTL_CTX➠R^Q(^ԡЬRԡެP OTS$$CVT_D_T_R8PPRbССԼ  
 I   
VAXC$DFCVT  &   ELN$LOCATE_CRTL_CTXXX C$K_ECVT_BUFFSIZEݬ߮߬ FOR$CVT_D_TFXS;  C$K_ECVT_BUFFSIZE&cԼ-aּPQ}PT;0Paa.PQ;0Pa
T(TcԼ(}PV:.TePVּPT,Vg TcPVQW(VgccXP    w w 1       `ⳃ V4.1-00                         7     C$GECVTV4.1   -0010-OCT-1990 22:14                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GECVT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GECVT ELN_BUILD:[ELN.CRTL.SRC]GECVT+ECVT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB  - floating to text conversion T   C$K_ECVT_BUFFSIZE  ELN$LOCATE_CRTL_CTX  FOR$CVT_G_TF  OTS$$CVT_G_T_R8         	.  ABS  .    P       $CODE   P  
     
VAXC$GECVT  &l   ELN$LOCATE_C
   RTL_CTX➠R^Q(^ԡЬRԡެP OTS$$CVT_G_T_R8PPRbССԼ  
 I   
VAXC$GFCVT  &   ELN$LOCATE_CRTL_CTXXX C$K_ECVT_BUFFSIZEݬ߮߬ FOR$CVT_G_TFXS;  C$K_ECVT_BUFFSIZE&cԼ-aּPQ}PT;0Paa.PQ;0Pa
T(TcԼ(}PV:.TePVּPT,Vg TcPVQW(VgccXP    w w 1         V4.1-00                         5     C$EXPV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[                                                                                                                                                                                                                                                                            /; $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        p "              ELN.CRTL.LIS]EXP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]EXP ELN_BUILD:[ELN.CRTL.SRC]EXP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - base e exponentiation math library fun"   C$$MATH_HAND  MTH$DEXP_R6         	.  ABS  .    P       $CODE   P|   
     | 	VAXC$DEXP &)  C$$MATH_HANDmpP MTH$DEXP_R6    w w 1       f҃ V4.1-00                         6     C$GEXPV4.1-0010-OCT-199   0 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GEXP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GEXP ELN_BUILD:[ELN.CRTL.SRC]GEXP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - base e exponentiation math library fun"   C$$MATH_HAND  MTH$GEXP_R6         	.  ABS  .    P       $CODE   P|   
     | 	VAXC$GEXP &*  C$$MATH_HANDmPP MTH$GEXP_R6   w w    1       " V4.1-00                         6     C$FABSV4.1-0010-OCT-1990 22:12                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]FABS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]FABS ELN_BUILD:[ELN.CRTL.SRC]FABS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - floating double absolute math library          	.  ABS  .    P       $CODE   P    
       
VAXC$DFABS  & 
   pP P   w w 1         V4.1-00                         7     C$GFABSV4.1-0010-OCT-1990 22:14                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GFABS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GFABS ELN_BUILD:[ELN.CRTL.SRC]GFABS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - floating double absolute math library          	.  ABS  .    P    
   $CODE   P    
          
VAXC$GFABS  &
 PP P    w w 1       `  V4.1-00                         7     C$FLOORV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]FLOOR/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]FLOOR ELN_BUILD:[ELN.CRTL.SRC]FLOOR+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - floor math library function          	.  ABS  .    P       $CODE  
    P   
      VAXC$DFLOOR & pPtP RRbPbRP    w w 1       `U	 V4.1-00                         8     C$GFLOORV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GFLOOR/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GFLOOR ELN_BUILD:[ELN.CRTL.SRC]GFLOOR+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - floor math library function          	.  ABS  .   	    P       $CODE   P   
      VAXC$GFLOOR & PPTP RRBPBRP    w w 1       @ V4.1-00                         6     C$FMODV4.1-0010-OCT-1990 22:12                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]FMOD/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]FMOD ELN_BUILD:[ELN.CRTL.SRC]FMOD+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - floating-point remainder    
    C$$MATH_HAND  MTH$DMOD          	.  ABS  .    P       $CODE   P    
       
VAXC$DFMOD  &0 pP C$$MATH_HANDm MTH$DMOD   w w 1       @S& V4.1-00                         7     C$GFMODV4.1-0010-OCT-1990 22:14                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GFMOD/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GFMOD ELN_BUILD:[ELN.CRTL.SRC]GFMOD+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALI   B.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - floating-point remainder     C$$MATH_HAND  MTH$GMOD          	.  ABS  .    P    #   $CODE   P    
       
VAXC$GFMOD  &5 SPP C$$MATH_HANDm MTH$GMOD    w w 1       5 V4.1-00                         7     C$FREXPV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]FREXP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]FREXP ELN_BUILD:[ELN.C   RTL.SRC]FREXP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - extract fraction and exponent math lib         	.  ABS  .    P        $CODE   P    
       VAXC$DFREXP &  pPP      P   w w 1       D V4.1-00                         8     C$GFREXPV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GFREXP/OBJECT=E 
  LN_BUILD:[ELN.CRTL.OBJ]GFREXP ELN_BUILD:[ELN.CRTL.SRC]GFREXP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - extract fraction and exponent math lib         	.  ABS  .    P    !   $CODE   P    
       VAXC$GFREXP &! PPP      P    w w 1        T V4.1-00                         6     C$GCVTV4.1-0010-OCT-1990 22:12                   VAX MACRO V5.0-9  MACRO/DEBUG=
   NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GCVT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GCVT ELN_BUILD:[ELN.CRTL.SRC]GCVT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - floating to text conversion    OTS$$CVT_D_T_R8          	.  ABS  .    P       $CODE   P  
     
VAXC$DGCVT  & ^Q(^ЬRRRRR	R	RRR^nԡԡ~P OTS$$CVT_D_T_R8ЬSСWXա-СV&VW!(Vhc.VW(Wacs0c.S
   cЬPWաV.(Whcs0Se^STVnndЬP   w w 1       a V4.1-00                         7     C$GGCVTV4.1-0010-OCT-1990 22:14                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GGCVT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GGCVT ELN_BUILD:[ELN.CRTL.SRC]GGCVT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - floating to text conversion    OTS$$CVT_G_T_R8   
          	.  ABS  .    P       $CODE   P  
     
VAXC$GGCVT  & ^Q(^ЬRRRRR	R	RRR^nԡԡ~P OTS$$CVT_G_T_R8ЬSСWXա-СV&VW!(Vhc.VW(Wacs0c.ScЬPWաV.(Whcs0Se^STVnndЬP   w w 1       q V4.1-00                         7     C$HYPOTV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]HYPOT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]HY   POT ELN_BUILD:[ELN.CRTL.SRC]HYPOT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - euclidean distance&   MTH$DSQRT_R5 
     
VAXC$DCABS         	.  ABS  .    P       $CODE   P<   
     < VAXC$DHYPOT &# ePeR`RP MTH$DSQRT_R5    w w 1        V4.1-00                         8     C$GHYPOTV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE   /LIS=ELN_BUILD:[ELN.CRTL.LIS]GHYPOT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GHYPOT ELN_BUILD:[ELN.CRTL.SRC]GHYPOT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - euclidean distance&   MTH$GSQRT_R5 
     
VAXC$GCABS         	.  ABS  .    P       $CODE   P<   
     < VAXC$GHYPOT && EPER@RP MTH$GSQRT_R5   w w 1        # V4.1-00                         7     C$LDEXPV4.1-001   0-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]LDEXP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]LDEXP ELN_BUILD:[ELN.CRTL.SRC]LDEXP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - power 2 multiply math library function'   	C$_ERANGE  ELN$LOCATE_CRTL_CTX          	.  ABS  .    P        $ABS$ 	   P  P    P   $CODE   P   
      VAXC$DLDEXP &w                                                                                                                                                                                                                                                    !                        ,? $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                        
 "                ELN$LOCATE_CRTL_CTXPSpPPRRя   RRP|P<}PP< 	C$_ERANGE7:=%c    w w 1       @e V4.1-00                         8     C$GLDEXPV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GLDEXP/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GLDEXP ELN_BUILD:[ELN.CRTL.SRC]GLDEXP+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB 
     *  - power 2 multiply math library function'   	C$_ERANGE  ELN$LOCATE_CRTL_CTX          	.  ABS  .    P        $ABS$ 	   P  P    Q   $CODE   P   
      VAXC$GLDEXP &x   ELN$LOCATE_CRTL_CTXPSPPPRRя  RRP|P<}PP< 	C$_ERANGE7:=%c   w w                                                                                                                                                                              1       n V4.1-00                         5     C$LOGV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]LOG/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]LOG ELN_BUILD:[ELN.CRTL.SRC]LOG+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB)  - logrithm base e math library function "   C$$MATH_HAND  MTH$DLOG_R8         	.  ABS  .    P       $CODE   P     
     	VAXC$DLOG &)  C$$MATH_HANDmpP MTH$DLOG_R8    w w 1       @ V4.1-00                         6     C$GLOGV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GLOG/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GLOG ELN_BUILD:[ELN.CRTL.SRC]GLOG+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB )  - logrithm base e math library function "   C$$M   ATH_HAND  MTH$GLOG_R8         	.  ABS  .    P       $CODE   P  
     	VAXC$GLOG &*  C$$MATH_HANDmPP MTH$GLOG_R8   w w 1         V4.1-00                         7     C$LOG10V4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]LOG10/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]LOG10 ELN_BUILD:[ELN.CRTL.SRC]LOG10+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/   LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - logrithm base 10 math library function$   C$$MATH_HAND  
MTH$DLOG10_R8         	.  ABS  .    P       $CODE   P  
     VAXC$DLOG10 &+  C$$MATH_HANDmpP 
MTH$DLOG10_R8    w w 1         V4.1-00                         8     C$GLOG10V4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GLOG10/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GLOG10 ELN_BUILD:[ELN.CRTL.SRC]   GLOG10+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - logrithm base 10 math library function$   C$$MATH_HAND  
MTH$GLOG10_R8         	.  ABS  .    P       $CODE   P  
     VAXC$GLOG10 &,  C$$MATH_HANDmPP 
MTH$GLOG10_R8   w w 1        &օ V4.1-00                         6     C$MODFV4.1-0010-OCT-1990 22:12                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/L
   IS=ELN_BUILD:[ELN.CRTL.LIS]MODF/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]MODF ELN_BUILD:[ELN.CRTL.SRC]MODF+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - extract fraction and integer math libr         	.  ABS  .    P    ?   $CODE   P   
      
VAXC$DMODF  &? pPqP P      
qP       }PRʏSbRPjPRnRRbRPcP    w w 1        V4.1-00                         7     C$GMODFV4.1-0010-   OCT-1990 22:14                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GMODF/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GMODF ELN_BUILD:[ELN.CRTL.SRC]GMODF+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - extract fraction and integer math libr         	.  ABS  .    P    G   $CODE   P   
      
VAXC$GMODF  &G PPQP B      QP       }PRʏ? SBRPJPRNRRBRPCP       w w 1       ` V4.1-00                         5     C$POWV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]POW/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]POW ELN_BUILD:[ELN.CRTL.SRC]POW+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  - power math library function     C$$MATH_HAND  	OTS$POWDD         	.  ABS  .    P       $CODE   P    
          	VAXC$DPOW &$  C$$MATH_HANDml 	OTS$POWDD   w w 1         V4.1-00                         6     C$GPOWV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GPOW/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GPOW ELN_BUILD:[ELN.CRTL.SRC]GPOW+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - power math library function     C$$MATH_HAND  	OTS$POWGG            	.  ABS  .    P       $CODE   P    
       	VAXC$GPOW &$  C$$MATH_HANDml 	OTS$POWGG   w w 1       @ V4.1-00                         5     C$SINV4.1-0010-OCT-1990 22:12                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]SIN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]SIN ELN_BUILD:[ELN.CRTL.SRC]SIN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB  -     sine math library function   MTH$DSIN_R7          	.  ABS  .    P    
   $CODE   P   
      	VAXC$DSIN & pP MTH$DSIN_R7    w w 1       @ V4.1-00                         6     C$GSINV4.1-0010-OCT-1990 22:14                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GSIN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GSIN ELN_BUILD:[ELN.CRTL.SRC]GSIN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/L !  IB+TOPD$:[KERNEL.OBJ]KERMAC/LIB   - sine math library function   MTH$GSIN_R7          	.  ABS  .    P       $CODE   P   
      	VAXC$GSIN & PP MTH$GSIN_R7   w w 1       ( V4.1-00                         6     C$SINHV4.1-0010-OCT-1990 22:13                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]SINH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]SINH ELN_BUILD:[ELN.CRTL.SRC]SINH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DA "  PDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB )  - hyperbolic sine math library function     C$$MATH_HAND  	MTH$DSINH         	.  ABS  .    P       $CODE   P    
       
VAXC$DSINH  &'  C$$MATH_HANDm 	MTH$DSINH    w w 1       @:3 V4.1-00                         7     C$GSINHV4.1-0010-OCT-1990 22:14                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GSINH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GS #  INH ELN_BUILD:[ELN.CRTL.SRC]GSINH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB)  - hyperbolic sine math library function     C$$MATH_HAND  	MTH$GSINH         	.  ABS  .    P       $CODE   P    
       
VAXC$GSINH  &'  C$$MATH_HANDm 	MTH$GSINH    w w 1       |B V4.1-00                         6     C$SQRTV4.1-0010-OCT-1990 22:13                   VAX MACRO V5.0-9  
 $  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]SQRT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]SQRT ELN_BUILD:[ELN.CRTL.SRC]SQRT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB %  - square root math library function #   C$$MATH_HAND  MTH$DSQRT_R5          	.  ABS  .    P       $CODE   P<   
     < 
VAXC$DSQRT  &*  C$$MATH_HANDmpP MTH$DSQRT_R5   w w 1       Z V4.1-00                                                                                                                                                                                                                                                                        "                         $      ELN042.D                       F  
  +[SYSEXE.SEAS$WORK_0000005C]CRTLOBJECT.OLB;1                                                                                         2                              $      
 %      7     C$GSQRTV4.1-0010-OCT-1990 22:15                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GSQRT/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GSQRT ELN_BUILD:[ELN.CRTL.SRC]GSQRT+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB%  - square root math library function #   C$$MATH_HAND  MTH$GSQRT_R5          	.  ABS  .    P       $CODE   P<   
     < 
VAXC$GSQRT  &+  C$$MATH &  _HANDmPP MTH$GSQRT_R5    w w 1        h V4.1-00                         5     C$TANV4.1-0010-OCT-1990 22:13                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]TAN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]TAN ELN_BUILD:[ELN.CRTL.SRC]TAN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB!  - tangent math library function "   C$$MATH_HAND  MTH$DTAN_R7         	.  ABS  .  
 '    P       $CODE   P   
      	VAXC$DTAN &)  C$$MATH_HANDmpP MTH$DTAN_R7    w w 1       ]v V4.1-00                         6     C$GTANV4.1-0010-OCT-1990 22:15                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GTAN/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GTAN ELN_BUILD:[ELN.CRTL.SRC]GTAN+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB !  - tangent math lib (  rary function "   C$$MATH_HAND  MTH$GTAN_R7         	.  ABS  .    P       $CODE   P   
      	VAXC$GTAN &*  C$$MATH_HANDmPP MTH$GTAN_R7   w w 1        V4.1-00                         6     C$TANHV4.1-0010-OCT-1990 22:13                   VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]TANH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]TANH ELN_BUILD:[ELN.CRTL.SRC]TANH+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[ )  SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB *  - hyperbolic tangent math library functi   	MTH$DTANH          	.  ABS  .    P    
   $CODE   P    
       
VAXC$DTANH  &  	MTH$DTANH    w w 1        Ց V4.1-00                         7     C$GTANHV4.1-0010-OCT-1990 22:15                    VAX MACRO V5.0-9  MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]GTANH/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]GTANH ELN_BUILD:[ELN.CRTL.SRC]GTANH+ELN_BUILD:[ELN.C     RTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB*  - hyperbolic tangent math library functi   	MTH$GTANH          	.  ABS  .    P    
   $CODE   P    
       
VAXC$GTANH  &  	MTH$GTANH    w w                                                                                                                                                                                                                          +  1       `>_X
 V4.1-00                         I     ELN$DCMTH_JACKET_ROUTINESV4.1-0010-OCT-1990 22:18                    VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]DCMTHJACKETS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]DCMTHJACKETS ELN_BUILD:[ELN.CRTL.SRC]DCMTHJACKETS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB    Z  
VAXC$DACOS  
VAXC$DASIN  
VAXC$DATAN  VAXC$DATAN2  
VAXC$DCEIL  	VA ,  XC$DCOS  
VAXC$DCOSH  	VAXC$DEXP  
VAXC$DFABS  VAXC$DFLOOR  
VAXC$DFMOD  VAXC$DFREXP  VAXC$DHYPOT  VAXC$DLDEXP  	VAXC$DLOG  VAXC$DLOG10  
VAXC$DMODF  	VAXC$DPOW  	VAXC$DSIN  
VAXC$DSINH  
VAXC$DSQRT  	VAXC$DTAN  
VAXC$DTANH         	.  ABS  .    P       
DMATH_JACKETS   P    
       ACOS  & l 
VAXC$DACOS    
 
     ASIN  & l 
VAXC$DASIN    
      ATAN  & l 
VAXC$DATAN    
      ATAN2 &  -  l VAXC$DATAN2   
 (     CEIL  & l 
VAXC$DCEIL    
 2     COS & l 	VAXC$DCOS   
 <     COSH  & l 
VAXC$DCOSH    
 F     EXP & l 	VAXC$DEXP   
 P     FABS  & l 
VAXC$DFABS    
 Z     FLOOR & l VAXC$DFLOOR   
 d     FREXP & l VAXC$DFREXP   
 n     LDEXP & l VAXC$DLDEXP   
 x     LOG & l 	VAXC$DLOG   
      LOG10 & l VAXC$DLOG10" .     
      MODF  & l 
VAXC$DMODF    
      POW & l 	VAXC$DPOW   
      SIN & l 	VAXC$DSIN   
      SINH  & l 
VAXC$DSINH    
      SQRT  & l 
VAXC$DSQRT    
      TAN & l 	VAXC$DTAN   
      TANH  & l 
VAXC$DTANH    
      FMOD  & l 
VAXC$DFMOD    
      HYPOT & l VAXC$DHYPOT   
      CABS  & l VAXC$DHYPOT   w w 1     /     `skX
 V4.1-00                         H     ELN$DCIO_JACKET_ROUTINESV4.1-0010-OCT-1990 22:17                   VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]DCIOJACKETS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]DCIOJACKETS ELN_BUILD:[ELN.CRTL.SRC]DCIOJACKETS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB      
VAXC$DATOF  
VAXC$DECVT  
VAXC$DFCVT  
VAXC$DFPRINTF  VAXC$DFSCANF  
VAXC$DGCVT 0    VAXC$DPRINTF  VAXC$DSCANF  
VAXC$DSPRINTF  VAXC$DSSCANF  VAXC$DSTRTOD          	.  ABS  .    P    n   DCIO_JACKETS  P    
       ATOF  & l 
VAXC$DATOF    
 
     STRTOD  & l VAXC$DSTRTOD    
      ECVT  & l 
VAXC$DECVT    
      FCVT  & l 
VAXC$DFCVT    
 (     GCVT  & l 
VAXC$DGCVT    
 2     FPRINT  & l 
VAXC$DFPRINTF   
 <     PRINTF  & l VAXC$DPRINTF         
 F     SPRINTF & l 
VAXC$DSPRINTF   
 P     FSCANF  & l VAXC$DFSCANF    
 Z     SCANF & l VAXC$DSCANF   
 d     SSCANF  & l VAXC$DSSCANF    w w                                                                                                                                                                                                                                                                                                 THISSELL    ELN$DCMTH_JACKET_ROUTINESELN$DCIO_JACKET_ROUTINES                                                                                                                                                                                                                                                                                                                                                                                                                                                                  * * [SYSEXE.SEAS$WORK_0000005C]CRTLSHARE.OLB;1 +  , G   . <    /     4     <   =                     - 
    0   1    2   3      K  P   W   O =    5   6 @2V
  7 @s\  8          9          G    H  J                       %
   VAX-11 Librarian V04-00         V
 1W
 !               <   =   ,      ;                                                                                              (     (                                                                                                                                                                                                                                                                                                                         <    ABORT<    ABS<    ACCEPT<    ACOS<    ASIN<    ATAN<    ATAN2<    ATOF<    ATOI<    ATOL<    BIND<    BSEARCH<    C$$COND_HAND<    C$$MAIN<    	C$$SOCKET<    C$$TRANSLATE<    C$MAIN<    C$MAIN_ARGS<    
C$V_CTYPEDEFS<    CABS<    CALLOC<    
CC$_GFLOAT<    CEIL<    CFREE<    CHMOD<    CHOWN<    CLOSE<    CONNECT<    COS<    COSH  ELN$ADD_LARGE_INTEGERS<    ELN$CLEANUP_P1_CTX<    ELN$INSERT_ENTRY<    ELN$LOCATE_CRTL_CTXT_1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       #                        ` $      ELN042.D                       G  
  *[SYSEXE.SEAS$WORK_0000005C]CRTLSHARE.OLB;1                                                                                          <                         Ai "                     <    STDERR<    STDIN<    STDOUT<    STRCAT<    STRCHR<    STRCMP<    STRCPY<    STRCSPN<    STRERROR<    STRLEN<    STRNCAT<    STRNCMP<    STRNCPY<    STRPBRK<    STRRCHR<    STRSPN<    STRSTR<    STRTOD<    STRTOK<    STRTOL<    STRTOUL<    TAN<    TANH<    TIME<    TIMES<    TMPFILE<    TOLOWER<    TOUPPER<    UMASK<    UNGETC<    
VAXC$DACOS<    
VAXC$DASIN<    
VAXC$DATAN<    VAXC$DATAN2<    
VAXC$DATOF<    
VAXC$DCABSINT                COSH   ELN$LOCATE_CRTL_CTX   GETENV   PAUSE   SSIGNAL   
VAXC$DCABS   VAXC$DFREXP
   
VAXC$DSINH   VAXC$GATAN2   
VAXC$GFMOD
   	VAXC$GSIN	   _EXIT                                                                                                                                                                                                                                                                                                                              <    PERROR<    POW<    PRINTF<    PUTCHAR<    PUTS<    PUTW<    QSORT<    RAND<    READ<    REALLOC<    RECV<    RECVFROM<    RECVMSG<    REWIND<    SCANF<    SELECT<    SEND<    SENDMSG<    SENDTO<    SETBUF<    SETJMP<    
SETSOCKOPT<    SHUTDOWN<    SIGBLOCK<    SIGNAL<    SIGPAUSE<    
SIGSETMASK<    SIGSTACK<    SIGVEC<    SIN<    SINH<    SLEEP<    SOCKET<    SPRINTF<    SQRT<    SRAND<    SSCANF<    SSIGNAL                 <    GETNAME<    GETPEERNAME<    GETS<    GETSOCKNAME<    
GETSOCKOPT<    GETW<    GSIGNAL<   |HTONL<   |HTONS<    HYPOT<   |	INET_ADDR<   |
INET_LNAOF<   |
INET_MAKEADDR<   |
INET_NETOF<   |INET_NETWORK<   |	INET_NTOA<    ISATTY<    LDEXP<    LDIV<    LISTEN<    	LOCALTIME<    LOG<    LOG10<    LONGJMP<    LSEEK<    MALLOC<    MEMCHR<    MEMCMP<    MEMCPY<    MEMMOVE<    MEMSET<    MODF<   |NTOHL<   |NTOHS<    OPEN<    PAUSE      1           <   |AUXCSHR<    CMSC<    DCIO<    DCMATH                                                                                                                                                                                                                                                                                                                                                                                                                                                                            <    ELN$READ_ERRNO<    ELN$REMOVE_ENTRY<    ELN$SUB_LARGE_INTEGERS<    ELN$SWITCH_STACK<    EXIT<    EXP<    FABS<    FCLOSE<    FCVT<    FDOPEN<    FFLUSH<    FGETC<    FGETNAME<    FGETS<    FLOOR<    FMOD<    FOPEN<    FPRINTF<    FPUTC<    FPUTS<    FREAD<    FREE<    FREOPEN<    FREXP<    FSCANF<    FSEEK<    FTELL<    FTIME<    FWRITE<    GCVT<    GETCHAR<    GETENV                                                                       <    
VAXC$GSINH<    
VAXC$GSPRINTF<    
VAXC$GSQRT<    VAXC$GSSCANF<    VAXC$GSTRTOD<    	VAXC$GTAN<    
VAXC$GTANH<    VAXC$SOCKET_CONTROL<    
VAXC$VA_COUNT<    
VAXC$VA_START<    VAXC$VA_START_1<    WRITE<    _ASSERT<    _EXIT                                                                                                                                                                                                                                                                   <    
VAXC$GFPRINTF<    VAXC$GFREXP<    VAXC$GFSCANF<    
VAXC$GGCVT<    VAXC$GHYPOT<    VAXC$GLDEXP<    	VAXC$GLOG<    VAXC$GLOG10<    
VAXC$GMODF<    	VAXC$GPOW<    VAXC$GPRINTF<    VAXC$GSCANF<    	VAXC$GSIN                                                                                                                                                                                                                                                                                        <    
VAXC$GATOF<    
VAXC$GCABS<    
VAXC$GCEIL<    	VAXC$GCOS<    
VAXC$GCOSH<    
VAXC$GECVT<    VAXC$GET_FCB<    VAXC$GET_SDC<    	VAXC$GEXP<    
VAXC$GFABS<    
VAXC$GFCVT<    VAXC$GFLOOR<    
VAXC$GFMOD                                                                                                                                                                                                                                                                                              <    
VAXC$DSPRINTF<    
VAXC$DSQRT<    VAXC$DSSCANF<    VAXC$DSTRTOD<    	VAXC$DTAN<    
VAXC$DTANH<    VAXC$ESTABLISH<    
VAXC$GACOS<    
VAXC$GASIN<    
VAXC$GATAN<    VAXC$GATAN2                                                                                                                                                                                                                                                                                                                        <    VAXC$DFSCANF<    
VAXC$DGCVT<    VAXC$DHYPOT<    VAXC$DLDEXP<    	VAXC$DLOG<    VAXC$DLOG10<    
VAXC$DMODF<    	VAXC$DPOW<    VAXC$DPRINTF<    VAXC$DSCANF<    	VAXC$DSIN<    
VAXC$DSINH                                                                                                                                                                                                                                                                                                             <    
VAXC$DCEIL<    	VAXC$DCOS<    
VAXC$DCOSH<    
VAXC$DECVT<    	VAXC$DEXP<    
VAXC$DFABS<    
VAXC$DFCVT<    VAXC$DFLOOR<    
VAXC$DFMOD<    
VAXC$DFPRINTF<    VAXC$DFREXP                                                                                                                                                                                                                                                                                                                                <    CREAT<    CTIME<    DELETE<    DIV<    DUP<    DUP2<    ECVT<    ELN$ADD_LARGE_INTEGERS<    ELN$CLEANUP_P1_CTX<    ELN$INSERT_ENTRY<    ELN$LOCATE_CRTL_CTX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             $                         $      ELN042.D                       G  
  *[SYSEXE.SEAS$WORK_0000005C]CRTLSHARE.OLB;1                                                                                          <                         e "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  %                        . $      ELN042.D                       G  
  *[SYSEXE.SEAS$WORK_0000005C]CRTLSHARE.OLB;1                                                                                          <                         
 "     %       &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               3                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               4                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               5                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  &                        kY $      ELN042.D                       G  
  *[SYSEXE.SEAS$WORK_0000005C]CRTLSHARE.OLB;1                                                                                          <                               6       7                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               8                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               9                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               :                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    1    M    0V
                                 ;     CMSCVAXELN V4.2-0010-OCT-1990 23:0810-OCT-1990 23:08    w w 1    I   `r	W
                                 =     DCMATHVAXELN V4.2-0010-OCT-1990 23:0810-OCT-1990 23:08    w w 1    d   HW
                                 ;     DCIOVAXELN V4.2-0010-OCT-1990 23:0810-OCT-1990 23:08    w w 1       1W
                                 >     AUXCSHRVAXELN V4.2-0010-OCT-1990 23:0810-OCT-1990 23:08   w w                     % * [SYSEXE.SEAS$WORK_0000005C]DCIO.EXE;1 +  , H   . E    /     4     E   E 8                   - 
    0   1    2   3      K  P   W   O F    5   6  ;P
  7  \  8          9          G    H  J                           0 D X     0205      (          z                        A              DCIO                                   VAXELN V4.2-00 ɃO
 05-05                       :            <   
  >     =   
 ?         !         CMSC_001      !         
IPCSHR_001       !         LANGMSC_001"      !        
PASCALMSC_001"      !         
LIBCOMMON_001      !        DAP_001"      !         
ELNACCESS_001"      !         
GETMSGSHR_001   1   1!   1!   1]"     1'   1)   1)   1)   1*   1+   1+   1*,   1-   1%-   1n-   1-   1<.   1U.   1)/   11   12   12   12   12   13   1F3   1`3   1t3   13   13   13   104   1K4   1T4   1,7   1'9   19   19   19   19   1@:   1V:   1:    1:   1;     1`;   1j;   1;    1T     1U     1.V   < 1IU   1/   1B)    15   1Y)     1V     1UW     1W     1W     1W     1AX     1X   1X     1Z     1IZ     1Z     1Z     1[     1m[     1[     1[     1\     1U\    1	!    1-"   1#   1*$   1$   1/   17    19   1E1   19   19                                                                                                                                                                                                                                                                                                                                                            FOP=TMD w+ %s: non-translatable VAXELN error code: 0x%X, VAXELN message:
%s
 %s: %.*s
 %s: Undefined error
    assert error: expression = %s, in file %s at line %d
   !OL!XL!SL!UL                                                                 @                         @                                                                                                                                       doxucsefgDOXUEGp%doxscef[DOXEFipΨ^ͨ< ԭԭЬZЬXЬY[: hP  W:%Wh}P~PWPXQ0P1}WXW1ԭ ԭԭhn00h*
ЉXW]1Y+WhHPWRXh09R*.0XW1-h*
ЉXW1+Wh
PWRXS}PW0Pѭ   1 h.IXW1 h*ЉXW.1 +WhPWRXS}PW0rP   1 PhlXW   h:hz
ͨQhaP
0JP1f ͨSVѭPK譾/PV}P~0a-a+
ac0aSVT, aTVc}PVRT,PaTRcЭPͨQP	XW1SЭPìZQP~P[P~.([ajSZjQìZ~ݬݬPЎQЬZ[ЎPΎ[(PajSZjPhATh-譾KXW1h+譽6XW1wh#譿!XW1bh 譼XW1M魽RА+ͨ(Rcͩ	ͨ6PP  \1 `  \92 " 1 `  iͨՉPͨQP:  P  P譹խP
ѭPЭPЉQܚ݉q  P;0ͨPQ譿Quܚ݉vq  P0;0ͨPQ魿
Xq0qP譺}PRA RP#ܚЉRRq  P<PͨQR魽+qP	魼 qPܚ݉p  P<PͨQpi~~魹Эn߭~~s 	V  V  PT;  ͨs魽+qP	魼 qP}PR:EPa	譺" a: RcPR譿q0SQRRa.R}RPTpi~~魹Эn߭~~LT  P3譺:E ͨ a;  ͨs魽+qP	魼 qPPpi~魹Эn߭~~@U  P;  ͨs魽+qP	魼 qP譿魹խPXWЭЬ[ЬXЬVfVPΨ^ԭʏ @  ЦZfY DѦ(,0Y YP13: hP  WYW19Y0C1ԭ+Wh PW}PW0}BW;h%Q*Wh0PWT}P~TUYTYT)ThjTU0 TWTXUT1 1 }WTYSZWh%1WXhn0Z1_*h	WX+WhpPWRXSPWzQX0PlhWcXhh	WRXRWRZ R:R.5   譸魰֭1P ЭP
ЏPЭPæZQQfZЦf}fYPAݬq"  P,fצPЦZfY DѦ(,0Y Y
YPYP+Yjo}PYPPTP
PY0pԭԭT > h cc cc " Y%PP譸
ЋP譶``PZЭP	֭PY0YԭjRB1 jR@BB1 jRBAjRB}301jjR@BdjRBW
1I0_1?c  T1- j-j+)l  Tc  T ЭU< UѭU1ͨS魵j01U jRBR03UͨíS 魶n߭譸ЋndPЭPS譸ЋSխ֭ЭTTYYT魸
TZQTYP
,Yj TcY0t}PYPU譸ЋUխЏ  ЭTTYYT*Tj T譸
(YjecSU0"PT~譸
(njecnZYPͨUЭT< Tj-                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  '                        " $      ELN042.D                       H  
  %[SYSEXE.SEAS$WORK_0000005C]DCIO.EXE;1                                                                                               E                          "     
       j+Y0P1 T1 TАjRBY0TTѭT譱Ta譴'譳Yj.Y0q	FP1 T;譱1z T+jEjeY09PPT1D譱1D ͨíU~~߭߭b  P"譸ЋU魷
peveЭPPU譸ЋU:]WhPЭRЏRPWSXTPWQXd^ST:jSd魲'#魸ZY
0q	PR譸eЭPXWY !OL!XL!SL!UL                                                                 @                         @                                                                                                                                       doxucsefgDOXUEGp%doxscef[DOXEFipΠ^͠< ԭԭЬZЬXЬY[: hP  W:%Wh}P~PWPXQ0P1}WXW1ԭ ԭԭhn0
0h*
ЉXW]1Y+WhHPWRXh09R*.0XW1-h*
ЉXW1+Wh
PWRXS}PW0Pѭ   1 h.IXW1 h*ЉXW.1 +WhPWRXS}PW0rP   1 PhlXW   h:hz
͠QhaP
0JP1f ͠SVѭPK譶/PV}P~0a-a+
ac0aSVT, aTVc}PVRT,PaTRcЭP͠QP	XW1SЭPìZQP~P[P~.([ajSZjQìZ~ݬݬPЎQЬZ[ЎPΎ[(PajSZjPhATh-譶KXW1h+譵6XW1wh#護!XW1bh 譴XW1M魵RȐ+͠(Rc͡	͠6PP  \1 `  \k2 " 1 `  i͠ՉP͠QP:  P  P譱խP
ѭPЭPЉQԚ݉d  P;0͠PQ護QuԚ݉d  P0;0͠PQ魷
Xq0qP譲}PRA RP#ԚЉRR6d  P<P͠QR魵+qP	魴 qPԚ݉c  P<P͠QPi~~魱Эn߭~~S 	7I  I  Pe;  ͠S魵+qP	魴 qP}PR: RcPR}RP:EPa譲 a0R護q0SQRRa.R}RP PPi~~魱Эn߭~~\G  P;  ͠S魵+qP	魴 qP}PR: RcPR}RP:EPa譲 a0R}RPPi~魱Эn߭~~4H  P1;  ͠S魵+qP	魴 qP護魱խP19XWЭЬ[ЬXЬVfVPΠ^ԭʏ @  ЦZfY DѦ(,0Y YP13: hP  WYW19Y0C1ԭ+WhPW}PW0}BW;h%Q*Wh0PWT}P~TUYTYT)ThjTU0 TWTXUT1 1 }WTYSZWh%1WXhn0\1_*h	WX+Wh9PWRXSPWzQX0PlhWcXhh	WRXRWRZ R:R5   議魨֭1P ЭP
ЏPЭPæZQQfZЦf}fYPAݬR  P,fצPЦZfY DѦ(,0Y Y
YPYP+Yj8}PYPPTP
PY0pԭԭدT  h cc cc " Y%PP議
ЋP譮``PZЭP	֭PY0YԭjRB1 jR@BwBm1 jRBVAjRBF301jjR@B-jRB 
1I0_1?gV  T1- j-j+
_  TU  T ЭU< UѭU1͠S魭j01U jRBR03U͠íS 魮n߭議ЋndPЭPS議ЋSխ֭ЭTTYYT魰
TZQTYP
,Yj TcY0t}PYPU議ЋUխЏ  ЭTTYYT*Tj T議
(YjecSU0"PT~議
(njecnZYP͠UЭT< Tj-j+Y0P1 T1 TȐjRBOY0TTѭT譩Ta譬'譫Yj.Y0q	FP1 T;譩1| T+jEjeY09PRT1D譩1F ͠íU~~߭߭T  P$議ЋU魯Pe	3eЭPPU議ЋU:]WhPЭRЏRPWSXTPWQXd^ST:jSd魪'#魰ZY
0o	PR議eЭPXWY ^Q\  TPPRBdP֬PPP@d SRcQQ+1 QPP+N  N   b b b b b b b b b b             
Pj?PPe   GaR	Rd   SRGPRd   eR5R
R*PR#PR
#
RPRd   dR
PS1CPìSЬ"|~S  PRPpPRtZ  rP  ^)[  TV cZ  PWЬRRUbPPRBd֬PPP@d SRcQQ+1 QPP+N  N   n n n n n n n n n n             
P2?PPe   SmR	Rd   _Rc-VRGPRd   eR5R
R*PR#PR
#
RPRd   dR
PS17PìS!gЬRUb|PЬЬRSb"|~Q  PUP:s0&|~Q  PRPR, "gPRX  pPU, "gV
p.RPp,RpRPUX  |P    X  R^Q(^ԡЬRԡެPRB  PPRbССԼ nX  XXݏ   ݬ߮߬>  XS;  cԼ-aּPQ}PT;0Paa.PQ;0Pa
T(TcԼ(}PV:.TePVּPT,Vg TcPVQW(VgccXP ^Q(^ЬRRRRR	R	RRR^nԡԡ~PkA  ЬSСWXա-СV&VW!(Vhc.VW(Wacs0c.ScЬPWաV.(Whcs0Se^STVnndЬP                                 ^W  TPPRBdP֬PPP@d SRcQQ+1 QPP+N  N   b b b b b b b b b b             
PJ?PPe   GaR	Rd   SRGPRd   eR5R
R*PR#PR
#
RPRd   dR
PS1CPìSЬ"|~sN  PRPPPRU  PϦP  ^V  TV U  PWЬRRUbPPRBd֬PPP@d SRcQQ+1 QPP+N  N   n n n n n n n n n n             
P?PPe   SmR	Rd   _Rc-VRGPRd   eR5R
R*PR#PR
#
RPRd   dR
PS17PìS!gЬRUbPσPЬЬRSb"|~
M  PUP?Q]0&|~L  PRPR, "gPRGT  PPU, "gV	PRPRPRPUT  PP  T  R^Q(^ԡЬRԡެP<C  PPRbССԼ S  XXݏ   ݬ߮߬9  XS;  cԼ-aּPQ}PT;0Paa.PQ;0Pa
T(TcԼ(}PV:.TePVּPT,Vg TcPVQW(VgccXP ^Q(^ЬRRRRR	R	RRR^nԡԡ~PUB  ЬSСWXա-СV&VW!(Vhc.VW(Wacs0c.ScЬPWաV.(Whcs0Se^STVnndЬP    ^\߬<~l-  ߬	P    
   ALQ  h  DEQ    FOP  P  CTG  CBT  TEF  CIF  SUP  SCF  SPL  TMD  TMP  
NEF  	RCK  WCK  DLT  MXV  RWO   POS  RWC   FSZ  N   MRS  d  )RAT      CR   BLK  FTN   PRN   >RFM   @  FIX  VAR  VFC  UDF   STM  STMLFSTMCR >SHR  M   GET  PUT   DEL  UPD  NIL  UPI  MSE   CTX  D  BIN  REC    fop=cif 
 SYS$INPUT: SYS$OUTPUT: SYS$ERROR: ݬτP!P\^\0Ў\   WXЬP0>0 ݬRPP\^\0Ў\ǐ ǒ  0XP1|2IXTN  HN  |~~ kX2N  &N  ~ Pʏ   ӏ   Y L0!g0Pʏ   XH0P  P|~?ǎ ǐ ~HAP  P0ЎP0Pݬ-  0yP0ЎPP0ӏ   ݏ45 MO  PǢP0PWP0ЬUVP0ЬPL  P   WX0ZL  lZZVެ\0,P
ЎVЎZ0HPЎVЎZ` L  ǘ 
|~t?ǎ ǐ O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H$O  2Z
ZPȏ   0ЬUV0Ǣ N  P0ЎP01P0z1k0u+ЎYYkX8L  ,L  ~ 2ZPXL  L  ~ 0"ЬYYZYPXK  K  |~~ BK  ZjP+@P00XK  K  ~ PjYYPZIYiDXtK  hK  ~ ݬXPK  DK  |~~ kX2XiX'K  K  ~ ЬPЬWP0|
~τԼ0=ЬVU0Ur(UwUaff+[PЏ5 P0{PЬWP0{   D0i0b
gʏ@      7HL  0/;ǈ [ǌ Z[x	[[Z[R R~
~PHL  0PPЬWP0EP1gV0% Dѧ@	Џ<SPP֧g0Pʏ   ЬWP02P(Ǣ Ǥ cЬPЬWP01| P1ЬZЬ[ZZ~7gV0WF:
VPPVVZ
VnVZVZZn0\nZɔkЬPʏ   ЏL5 P0[ߔʏ   PЬWP0g0
Pg֧PЬW P0^0PP֧gP߬l~n  ߬l~n0
ЬUЬRS VSrVSw	Sa1Pb+VP0HG  ЭZЭ\0oHP01E` G  ǘ Swo |~t?ǎ ~O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~HpJ  PSЎn1 SaЎn1s Վ<IG  PPP   WX0O
|~t?ǎ ǐ O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~HI  KG2Z
a
~Z  [PX,G   G  ~ Џ5 P0P01"XF  F  ~ 0<P0R*XF  F  ~ P0ЎP0PWWkXF  F  ~ ȏ                                                                                                                                                                                                                                                      (                         $      ELN042.D                       H  
  %[SYSEXE.SEAS$WORK_0000005C]DCIO.EXE;1                                                                                               E                         b "            PP8P2x	PPP0PPP@PЬǢZPP0ЎP0jЬW P0
OP15ЎZ   ^^[Wݏ   ߬ݬ[jPQZ0yʏ   ЎPʏ   PЬW P0@
9gV0/gV֧g D 
ӏ   02ЬPѧ(,!Ч(,0çPP0	P֧,P0ЬPPЬW P0(Ь[Џ  Z: ZkЏ5 P0 [QZ0PЬWP03Ь[L Ь~լЬZ0nÎPЏL5 P0PЬWP0FP
~KԼlShЬWP0PP1	ЎZ߬ݬݬjʏ   ЬWP0}~
~3PPЬWP0
~
~ЬW P0=Ь[Ь~$լ$ЬZ0#0"яPnЬPЏ4SP0PC  W10(Ǣ Ǥ cЬPC  WP0.LЬ[Џ  ZZ~gV04:
VPPVVZ
VnVZVZZn0nZɔ{ЬP[PЬWP0
Z~n[0RЎPP0Y	PXP0H 	Z	[ D1k Lѧ09ˏXVя  V+ǈ ǌ nՎǈ Ϭ   9 Џ5 P0PP[&g0ǈ [ǌ Zլ19,[0Zg	Z[[P[PZPQ[ǈ Zǌ HD  1 P,GZ0Aǈ ݧTݧ|ǔ ~HD  P<S0Ч,[<0Z[ǈ Zǌ 1[ǈ Zǌ  M+Ч|~ǧd|֧|ǈ ݧTݧ|~H;D  Ў|ǈ ݧTݧ|~HD  я<SPя<SP0z1B0Ϭ   + Џ5 P0\[([çUUZZ[P,[0Z< V	Z[[P[,nx	,T0T VT~ݬPF LЏ5 P0
x	[UZUTUVTTUUTTggT}T~, n T}TTTg0KTUv[(;g0[([||~ǈ Ǆ ݧlݧTݧ|~H
C  0y
P[,'Z0!<0PPZTT0PS, n TcZVgZ0[ǈ Zǌ [x	[[Z[P0jЬUЬVʏVP0ql*(`?  lZZެ\0`P08P1ǘ |~t?ǎ ~O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H,B  PVˏQя 
  Q
Џ5 P1Cӏ   1|~?ǎ ~ݧPHA  PP0ЎP0,lnTяSPӏ   Џ5 PP0fЎP1 lB(@>  lZZެ\0
@P	07P1 ЬPo>  P   WY0` \>  ǘ ЬU0	|~t?ǎ ǐ O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H@  ȏ   %!2Z

 Z%ZP0h6>  W P0OP10ЎZ   ^^[
Wݏ   ߬ݬ[jPQZ0tЎPʏ   ʏ   P=  W1=  W P0,5Ь[Џ  Z: ZkЏ5 P0k
[QZ0[Z0 PZЬW P0Ь~^[0
ЬP0z
P1^ӏ   & P0
0=ZP<PP ʏ   ݬݬݬ  ЬWP0n0|~
~Ͽ<  WP0=PP1ЎZ߬ݬ<  jʏ   ЬWP0Nլ=ЧЧլçPЬPЧЧgЧ Z	 bZ|~ݏ  ߬ݬݬjЬQ@aPZ	Z  ^^WgЬЬݬ=  PgA^~^W߬ݬWj  <1;  P(;  ЬWP00P1 ЧQQѬP
PPqQgʏ   0P1o ӏ   1=   P0 ! 0 Dӏ   0;<PP ʏ   ݬݬݬ  ЬWЬ[ЬZ0sPЏ5 P0ЎP0X:  :  |~~ ZkP@P0 PkQAZQk[A[PF<  PPPP|~?ǎ |~H<  0 ЎP0*PPL-<Z2Ь[P P0>
gZPЏL5 P0P ^P Qa`;<  l9  TSdTRBPS_SRX9  9  |~~ kRHТP	PV;  ТP>Ǡ QQP	P=;  ТtP	P.;  R%;  kXT9  H9  ~ ЬUP0|Վ|~t?ǎ ~O~N~~ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~Hi;  ЬP|~?ǎ |~HM;  kRk~|PTZQPTZTT`PZkWRkЏL5 P0]PVKW<W[gW4
Z0V VL V0`gPЏL5 P0
7  [k^~  Sm7  [k;7  k8   7  ~  ^PQa`!:  ^~  m  ~  Џ	  PPR<P0&X7  7  ~ PWWkX}7  q7  ~ <WP0PtPY0'P d ǎ Ǖ ǔ ǜ 0ǎ >Ǡ 
NP
0P00Щ$,N1>Ǡ QQ
ݧ8  NNP0KPЧHQ` ˏwXVя V6Ǖ 0ǜ )< PDDPl01 PPT1 X1 ǜ 	ǘ 1 |~?ǎ |~H8  0lȏ   ǘ ǜ |~t?ǎ ǐ O~N~ݏ   ݧh<ǖ ~ǜ ǘ ߧd\ߧXݧTݧPM~L~Ǣ ~H`8  0dDN<dR	< RRdRXD	xRPP<SRSPPǘ xPPl0PSЧЩPǐ ǘ ȏ    MBL V	LV	Џ5 P0Ǣ :  e&UQPPǢ UXP(PeǤ ЎP(Phǣ cXUP ^Ќ[X0=k4[V0PP)VY"C4  ZԺ ^  >    ^0Џ5 P0f[0 Pk<UUV(WhWP[ kQkR0R	R

QRQP<UUV
    QfQfQfPP[0O V0 P<TTUSSe,kPkP[0  V0b P<TTUePkPWXV k[k),k$=k?WWUaU
zUUUW	 vWP-Wh 
fPPVPPh PQAXQQhPQAHQQhPQA8QQhQ hQя<SPW@6QP1P4  QW! էHя4SPHS5  QQP0X2  2  |~~ WZѬZgk[bZZJ[kWN&X2  v2  ~ 0ZX\2  P2  ~ ZX92  -2  ~ ЏL5 P0 D1  0E0p g 0R0PgV0K Dѧ(,0V VЏ<SP0ZVZV(VkQVgS[VZ
 DPЧV|~ǈ Ǆ ݧlݧTݧ|ǔ ~H
3  P"<Ǆ UDǘ +ǘ . ǘ 
1 1 0X
RSREfSU1 
EfU1 XЧTXTXX~dP=UX(UfhЎP1XVXU
f
E
ExUXU(UhЎUЧVЎX1 	P
xPxPhPUU
f`|PfT%T+ P
QT T$T0
T1QPPU(U@fVSUQQfT$T
EfUT0Qǜ NTTUЧVUgVP֧(Ч(||~ǈ Ǆ ݧlݧTݧ|~H
r2  PЧЏ   gPק(0 D1/ Ч<gP 0 Ч<g0Pg0 0 )Ч<g0Y֧(, g  P D1v Zӏ   :
ZkQ[QZgV0dMZVZV(VkVgSQ[VnVZ0:#ӏ   
0nZPՎPgV0%ZVZV(VkSVgQ[VZPЧVVU0J PЧ<gP0Џ   Pѧ(,çP|~ǈ PݧTݧ(~H	0  0D}U~ǘ Hǜ !U(NfЎUNTTVTU
Џ4SP11TP ǘ *ǘ 1 
EU1,T
EU1U1ff
Aӏ   'ʏ    ~}U~ޮVU0 }UT}U~1 f
ȏ   1PfP1Q+Qӏ    Qʏ   E
ȏ   U+E
U ӏ   Q1P
Q $Q QQ~P	(UfVSUfLXGDBxUTT^^S
R
R
RU

Sȏ   ^V^SUT^1 Ulǜ UdЏ4SP0T^}UPݧVˏwXSя S% |~ǈ ݧlݧTH.  Ў1 |~ǈ ݧlݧTݧ|ǔ ~H	.  Ўǈ ,ǌ 0NVUVǜ ǜ ǜ VVV<0SVS 	SPP0	SPP,Ч,ǈ 0ǌ T^}U0ǜ -
P`
çPPdP, n PSէ(	 D<(Ч(QçP	PQQ,Q,0P0P0error 0                             not owner                           no such file or directory           no such process                     interrupted system call             i/o error                           no such device or address           arg list too long                   exec format error                   bad file number                     no children                         no more processes                   not enough core                     permission denied                   bad address                         block device required               mount device busy                   file exists                         cross-device link                   no such device                      not a directory                     is a directory                      invalid argument                    file table overflow                 too many open files                 not a typewriter                    text file busy                      file too large                      no space left on device             illegal seek                        read-only file system               too many links                      broken pipe                         math argument                       result too large                    I/O stream empty                    operation in progress               operation already in progress       socket operation on non-socket      destination address required        message too long                    protocol wrong type for socket      protocol not available              protocol not supported              socket type not supported           operation not supported on socket   protocol family not supported       address family not supported        address already in use              can't assign requested address      network is d                                                                                                                                                                                                                                                   )                          $      ELN042.D                       H  
  %[SYSEXE.SEAS$WORK_0000005C]DCIO.EXE;1                                                                                               E                         9 "     ,       own                     network is unreachable              network dropped connection on reset software caused connection abort    connection reset by peer            no buffer space available           socket is already connected         socket is not connected             can't send after socket shutdown    too many references: can't splice   connection timed out                connection refused                  too many levels of symbolic links   file name too long                  host is down                        no route to host                        ^ǭW $  PUeVV  Hݥ$  ST<R
PRdݥݬg!  V(VA   $VF3$ݬߧB!  rݬߧL!  ]< ^ n#  PUЬR"RA   $RB2=#  2P߭A#  нRѬ  6R1ݬ#  S2T<RRd2PP    ^ݬݬݬ    %       %C-F-ABORT, user requested abort  ۚ~"   "  `mw"  m P    ^ݬP߭߭"  ЭP H"  P  ^ݬP4ԭ߭|~ݬݬP߭8"  ݭ!  PЭPP  ^ݬrP4ԭ߭|~ݬݬP߭!  ݭ!  PЭPP  ^ݬ&PQݬݬ߭P߭!  ݭj!  Pݭ|Pѭ
߭߭!  ЭPP  ^ݬP'ݬݬP߭S!  ݭ!  PPPP  ^ݬ~P'ݬݬP߭!  ݭ   PPPP  ^ݬ>P$ݬP߭   ݭ   PPP  ^ݬP6Ь߭|~ݬݬP߭z   ݭ<   PЭPPP  ^լݏS   PݬP:Ь߭ݬݬݬݬP߭   ݭ  PЭPP  ^ݬJP1Ь߭ݬP߭  ݭ  PЭPP^լЬWP@WW@   WݏSJ  PTXVUYTWsz  UP{ PQPPVUxUPPRRRPRRR
PPPP TSVU~nPCPTX	TRBTUTWXF߭ݬݬݬݬX߭  ЭRRjSYR{  
RYЭYY
ݭY  YP  ^ݬP6Ь߭|~ݬݬP߭Z  ݭ  PЭPPP  ^ݬP1Ь߭ݬP߭  ݭ  PЭPP  ^լݏS  Pݬ,P:Ь߭ݬݬݬݬP߭  ݭb  PЭPP  ^ݬP$ݬP߭Z  ݭ$  PPP  ^߭ݬݬݬ߭E  ݭ  PݭPѭ
߭߭
  P  ^ݬFP'ݬݬP߭  ݭ  PPPP  ^ݬP'ݬݬP߭  ݭM  PPPP  ^ݬP-ݬݬݬݬP߭9  ݭ  PPP  ^ݬP-ݬݬݬݬP߭  ݭ  PPP  ^ݬݬݬ߭  ݭ  PP   ^E؞3  X1 ^E؞(  Xx^E؞
  Xd^E؞
  XP^D؞  X<^D؞  X(^D؞Z
  X^D؞	  X 0Эȭխ
Э1֭RR^^ЬP]Qhԭ­ЭխԭЭȭЭЭԭέЭЭ
ԭ­Э֭130؃STd֭Sc1SS1
^  X-^  X^l	  X^  X 0<׭iRR^^ȏ   ȭԭЬP]QhԭխԭЭԭέԭíȭԭЭȭխԭ01X1C^E؞-  X<^E؞#  X(^E؞  X^E؞	  X 0 <PPRR^^ȏ   ЬP]QhЭTխcԭ1ѭRЭQ- n9QdDc5?1, n0d׭֭1ѭ$:- n9d1c5,1, n0d׭֭1ЭPխ
PP1ЭP­1PTRb5r90bbRT׭֭l ԭԭԭԭȏl0 + &    ЬЬЬЬЬЬԭԭԏl      ЬЬЭV}R<RRíRP­P­P­PPխ PPfPW Pխ
 +-խ"խխW6Ws c0(fcQV.ЭP0PЭP(Pfc}P, n*PaЏ P}P<PPPQSQ QP0000000000010203040506070809101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899QWQP`PQWp`P}WQ^X^TPR]PPQQ   R||d R QR ȏ   PPR R d R R-VWxRUUU)1{ ЧQ, n0a|ԧ1 QިTdPETդU֨}dP{ ʚ;PdQԤUWÏ eQStR{ ʚ;RdQȏ   dtP{ ʚ;PdQWQUШR}P{ ʚ;PRBRRЎWUÏW   P PQШRBScPz ʚ;PQPPRz ʚ;PQP ʚ;QPRQQRЧU0VШP1 	UUS}υ@QR{d   QQT1Dtu{d   QQT Dcu{d   QQTDRu{d   QQTDCu0QuUSPQ
P0PP
	QPQSUPVrרШP1 	UUS}@QQ
DR{d   QQT1Du{d   QQT Du{d   QQTDϿu{d   QQTDϰu0QuSU	V1W0ԧ	Q0	UUS}{Q
DR{d   QQT1Dju{d   QQT DYu{d   QQTDHu{d   QQTD9u0QuUSPQ
P0PP
PSUPVb0
	UUS}Q
DR{d   QQT1Du{d   QQT Du{d   QQTDu{d   QQTDϺu0QuSU	Vd0	UUS}ϘQ
DR{d   QQT1Dχu{d   QQT Dvu{d   QQTDeu{d   QQTDVu0QuSU	VVVUAP4P	PPUe5 UPp90``§PPP֧^WQ   0000000000010203040506070809101112131415161718192021222324252627282930313233343536373839404142434445464748495051525354555657585960616263646566676869707172737475767778798081828384858687888990919293949596979899QWԧ2`Q1W* QQmX 
   ` 14  Cms`<^^XÏ @  QTS
R<QQQ Qh R STTɏ   T1v QWԧ`Q1+ QQ     `   1  ϸmS`<^^XÏ   Q`TS|hR RSTɏ   T1  >  R I>  R>]  R2 PxPQxQQQQQPP	   R  QQQRQR0Qď  QxQQQď   QQR@  R 'Ѣ ѢѢbh   R>  PRP
PPRPR0 QΨP&PQQhQP hhP P ԨP QQh   "ЏhЏЏЏ֧ЧUV0ԨЏ ʚ;RzR PըRQPQzR PըRQPQ zR PըRQPQ  zRh PhRQPhQ   	UUS}qШQR{d   QQT3Dau{d   QQT"DPu{d   QQTD?u{d   QQT D.u0QuSU	V1$VVU:Q-QQQUe5UPp90``§Pԧ֧<^WQЧQ, n0a|ԧWQ ЬPѠ<  7ЬQա.`RB`R s    ЏT  Џ	  P`QbP  PԨ||$|,|4>d  ST:UVDhP,EbQ&zPQ PDhEbQEbDhQPFQF F0,ب0 ب4$ب8((QרQQ hQ Q  Q $2 QQ2 QQá#-ޟݦ %I-64OSm kXWڥ 22q#2I\ 	SU9zc%C1 ]|d|FW$bGט#?9',Jg9Eϖyh.L[Mľ
K7٬:|S\	5$oe(KB.E.D?ˈPo	̼I9i$MZDs10
h16A_p=|6+
aw̫Miv2=BzՔI?il7Tr3܀#GGŧN@a+eX&1Zd;Onp=
ףp=
ףp=
ף                                                                   
                @                P                $                                              (k 	              " 
             @C%              (              *焑, 
             /             1_2             6         p+ŝk   %kqk<զIx @ 76l3oߌG ݍ~S XPT\eƑ P(=
euuvJ
 RΚ2(M]=]; JJ?Lɚ R`'5        	

|@0 0 8.P4VV*P#PTcPPTcPTcTV1L 1M |@0S 0 	VPTcTV1) 1* |@00 0f PVPTcTV1 1 P0 Џ, PVl	լЬVЬP, n V`xVV}Q<QQQRЬSTlЬUQ3rPQP  UP0P!P PPP
@PP1~  P   ^P   ^
P   ^ Ԯl l
լȏ  }PR|T|VԮlЬ|X; Pa1aS
S	QP1S-S+S.ȏ   @Ԯ0^P1 0SS	WX0`֮SLS3S2S@S5;S1S4,S!'SA   1 A1 11y tԮ1tPDQ; Pa<aSS	S+
S-ȏ    0P0S7S	2
RDSR?RRȏ   Y?PЬQ||al	<QPQЏ, PڑlЏЏ, Pď  
  < Q<Q<@QRPl¬X®XXPY	5YW@UnyTTyVVn VQ@   Q}TVQyVV|T`   QTWQxWWTXQ(}T}V
WRЮP@RPPPWPWWPPRB)RWn(WnWծ1ծ(  i  11}Vx(QJVXyVVʏ   WQW6XV W&	լXW ЬRWVb1 1}Vx(QP                                                                                                                                                                                                                                                   *                        #v $      ELN042.D                       H  
  %[SYSEXE.SEAS$WORK_0000005C]DCIO.EXE;1                                                                                               E                               =        VXXXyVVʏ  WQW6XV W	լXW ЬRWVb1| 10}T}Vx(Qn TXXX VPyTTyVVPUʏ  WQWEX
T U V W/	լXW ЬRWVUTbP1PQaSS	S  0S	Y\Y@PUPyVVPVyTTUPyV~PnyT~T؎U؎V؎WST	 U V WЎPyTTyTVVTWUST U|VDdT>DcTY                                                                                                                                                                                                                            x  x  ,x                                                            Jx  Bx  Fx                                                                                                                                                                                                                                                                                                                                                                                      @  @   l     ,  	                                   	               x        @  H          P   h   `   X   H   @   8   0   (                       x   p                     	      `         0     P   @                                     ,      z   
                 @                                                                       CMSC                                                           IPCSHR                                                         LANGMSC                                                        	PASCALMSC                                                      	LIBCOMMON                                                      DAP                                                            	ELNACCESS                                                      	GETMSGSHR                                     Bx  Fx  Jx  x  x  x        {                                                                                                          ;     DCIOVAXELN V4.2-0010-OCT-1990 23:0810-OCT-1990 23:08   VAX-11 Linker V05-05        	.$$ABS$$.        ATOF      ECVT      FCVT      FPRINTF      FSCANF      GCVT     PRINTF   H  SCANF   X  SPRINTF   `  SSCANF     STRTOD       ACCEPT       BIND       CONNECT       LISTEN       RECV       RECVFROM       RECVMSG     SELECT        SEND       SENDMSG       SENDTO       SHUTDOWN        SOCKET   (    GETPEERNAME   0    GETSOCKNAME   8    
GETSOCKOPT   @    
SETSOCKOPT    H    VAXC$SOCKET_CONTROL       ABORT       _ASSERT      PERROR     < STRERROR   x  WRITE   p  UNGETC   h    UMASK     VAXC$GSSCANF   `  VAXC$DSSCANF      
VAXC$GSPRINTF   X   
VAXC$DSPRINTF   P  SETBUF     VAXC$GSCANF   H  VAXC$DSCANF   @  REWIND   8  READ   0  PUTW   (  PUTS      PUTCHAR     VAXC$GPRINTF     VAXC$DPRINTF     OPEN     LSEEK      ISATTY      GETW      GETS      GETNAME      GETCHAR      FWRITE      FTELL      FSEEK     VAXC$GFSCANF      VAXC$DFSCANF      FREOPEN      FREAD      FPUTS      FPUTC   x  
VAXC$GFPRINTF      
VAXC$DFPRINTF     	C$$SOCKET      FOPEN      FGETS      FGETNAME   x   FGETC   p   FFLUSH   h   FDOPEN   `   FCLOSE   X   DUP2   P   DUP   H   DELETE   @   CREAT W     VAXC$GET_FCB     VAXC$GET_SDC   8   CLOSE   0   CHOWN   (   CHMOD         TMPFILE   p  
VAXC$GGCVT   h  
VAXC$GFCVT   `  
VAXC$GECVT   P   
VAXC$GATOF   X   VAXC$GSTRTOD      
VAXC$DGCVT      
VAXC$DFCVT      
VAXC$DECVT        
VAXC$DATOF      VAXC$DSTRTOD     x  IO_MUTEX$    x  STDERR  x  STDERR"    x  STDIN  x  STDIN$    x  STDOUT  x  STDOUT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ' * [SYSEXE.SEAS$WORK_0000005C]DCMATH.EXE;1 +  , I   .     /     4        
                   - 
    0   1    2   3      K  P   W   O     5   6  HVG
  7 %\  8          9          G    H  J                         0 D X     0205      *          
                                        DCMATH                                 VAXELN V4.2-00 `nLE
 05-05                                      
          !        	DMATH_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001   1    1	    1     1    1%    15     1=   | 1I     1U    1Y     1   < 1    1   1   1    1     1I    1U     1]   < 1i    1u     1     1	    1    1    1     1    1    1     1   | 1     1    1     1E    1a   1   1    1     1
    1     1!   < 1-    1=     1M     1   < 1                                                                                                                                                      mpP}     mpPm   pP       
   pPtP RR`PbRP    pP       @  m  | ,  mpP    pP P pPtP RRbPbRP     pP  m      pPP      P< ePeR`RPY      PSpPPRRя   RRP|P<}PP<"cL  mpP  8  mpP   pPqP P      
qP       }PRʏSbRPjPRnRRbRPcP     mll      pPt         m  <   mpPU     mpPy    p      t  mPP\      \  mPPH      PP         PPTP RR@PBRP    PP        m  |   mPP       PP P    PPTP RRBPBRP   < EPER@RPb     SPPx  mj     PPP      P       PSPPPRRя  RRP|P<}PP<"c      mPP        mPP      PPQP B      QP       }PRʏ? SBRPJPRNRRBRPCP   p   ml      PP      L   mE  < 8   mPP           mPP            |  {   PVЬRТS|TS!Rя SCя S:я S1я̂ S(я S}T"RяĂ S<	PRfЬR}T~ ~    Ϣ mПP5~  ݟ .Pn^P`~ ~  ЎP  lP| ~V|~ݏ2  f~0  ЎV, n 2f~ߦ~X  P~P `~  ЎPVP  ~  Џ	  P   >ЬQA`P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @  @                                                                 0  (  X  H              (  0                                           
   
                 @                                                                       DMATH                                                          	LIBCOMMON                                                      	PASCALMSC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        +                        / $      ELN042.D                       I  
  '[SYSEXE.SEAS$WORK_0000005C]DCMATH.EXE;1                                                                                                                      XQ             =     DCMATHVAXELN V4.2-0010-OCT-1990 23:0810-OCT-1990 23:08   VAX-11 Linker V05-05        	.$$ABS$$.        ACOS      ASIN      ATAN      ATAN2   X   CABS       CEIL   (   COS   0   COSH   8   EXP   @   FABS   H   FLOOR      FMOD   P   FREXP   X   HYPOT   `   LDEXP   h   LOG   p   LOG10   x   MODF      POW      SIN      SINH      SQRT      TAN      TANH   X    
VAXC$GTANH   P   	VAXC$GTAN   H  < 
VAXC$GSQRT   @    
VAXC$GSINH   8   	VAXC$GSIN   0    	VAXC$GPOW   (   
VAXC$GMODF      VAXC$GLOG10      	VAXC$GLOG      VAXC$GLDEXP       VAXC$GFREXP   `    
VAXC$GFMOD   h  < VAXC$GHYPOT   h  
VAXC$GCABS       VAXC$GFLOOR        
VAXC$GFABS      | 	VAXC$GEXP        
VAXC$GCOSH       	VAXC$GCOS       
VAXC$GCEIL        VAXC$GATAN2       
VAXC$GATAN       
VAXC$GASIN       
VAXC$GACOS        
VAXC$DTANH       	VAXC$DTAN      < 
VAXC$DSQRT        
VAXC$DSINH       	VAXC$DSIN        	VAXC$DPOW   x    
VAXC$DMODFx   p   VAXC$DLOG10   h   	VAXC$DLOG   `    VAXC$DLDEXP   X   < VAXC$DHYPOT   X   
VAXC$DCABS   P     VAXC$DFREXP        
VAXC$DFMOD   H    VAXC$DFLOOR   @     
VAXC$DFABS   8   | 	VAXC$DEXP   0     
VAXC$DCOSH   (    	VAXC$DCOS        
VAXC$DCEIL        VAXC$DATAN2       
VAXC$DATAN       
VAXC$DASIN        
VAXC$DACOS                                        + * [SYSEXE.SEAS$WORK_0000005C]DFLOATCRTL.OBS;1 +  , J   . 	    /     4  Z  	    J                    - 
    0   1    2   3      K  P   W   O     5   6 {  7 `\  8          9          G    H  J                    I     ELN$DCMTH_JACKET_ROUTINESV4.1-0010-OCT-1990 22:18                    VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]DCMTHJACKETS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]DCMTHJACKETS ELN_BUILD:[ELN.CRTL.SRC]DCMTHJACKETS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB    Z  
VAXC$DACOS  
VAXC$DASIN  
VAXC$DATAN  VAXC$DATAN2  
VAXC$DCEIL  	VAXC$DCOS  
VAXC$DCOSH  	VAXC$DEXP  
VAXC$DFABS  VAXC$DFLOOR  
VAXC$DFMOD  VAXC$DFREXP  VAXC$DHYPOT  VAXC$DLDEXP  	VAXC$DLOG  VAXC$DLOG10  
VAXC$DMODF  	VAXC$DPOW  	VAXC$DSIN  
VAXC$DSINH  
VAXC$DSQRT  	VAXC$DTAN  
VAXC$DTANH         	.  ABS  .    P       
DMATH_JACKETS   P    
       ACOS  & l 
VAXC$DACOS    
 
     ASIN  & l 
VAXC$DASIN    
      ATAN  & l 
VAXC$DATAN    
      ATAN2 & l VAXC$DATAN2   
 (     CEIL  & l 
VAXC$DCEIL    
 2     COS & l 	VAXC$DCOS   
 <     COSH  & l 
VAXC$DCOSH    
 F     EXP & l 	VAXC$DEXP   
 P     FABS  & l 
VAXC$DFABS    
 Z     FLOOR & l VAXC$DFLOOR   
 d     FREXP & l VAXC$DFREXP   
 n     LDEXP & l VAXC$DLDEXP   
 x     LOG & l 	VAXC$DLOG   
      LOG10 & l VAXC$DLOG10   
      MODF  & l 
VAXC$DMODF    
      POW & l 	VAXC$DPOW   
      SIN & l 	VAXC$DSIN   
      SINH  & l 
VAXC$DSINH    
      SQRT  & l 
VAXC$DSQRT    
      TAN & l 	VAXC$DTAN   
      TANH  & l 
VAXC$DTANH    
      FMOD  & l 
VAXC$DFMOD    
      HYPOT & l VAXC$DHYPOT   
      CABS  & l VAXC$DHYPOT  H     ELN$DCIO_JACKET_ROUTINESV4.1-0010-OCT-1990 22:17                   VAX MACRO V5.0-9 MACRO/DEBUG=NONE/LIS=ELN_BUILD:[ELN.CRTL.LIS]DCIOJACKETS/OBJECT=ELN_BUILD:[ELN.CRTL.OBJ]DCIOJACKETS ELN_BUILD:[ELN.CRTL.SRC]DCIOJACKETS+ELN_BUILD:[ELN.CRTL.OBJ]ELNCMAC/LIB+TOPD$:[DAP.OBJ]DAPDEF/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+TOPD$:[KERNEL.OBJ]KERMAC/LIB      
VAXC$DATOF  
VAXC$DECVT  
VAXC$DFCVT  
VAXC$DFPRINTF  VAXC$DFSCANF  
VAXC$DGCVT  VAXC$DPRINTF  VAXC$DSCANF  
VAXC$DSPRINTF  VAXC$DSSCANF  VAXC$DSTRTOD          	.  ABS  .    P    n   DCIO_JACKETS  P    
       ATOF  & l 
VAXC$DATOF    
 
     STRTOD  & l VAXC$DSTRTOD    
      ECVT  & l 
VAXC$DECVT    
      FCVT  & l 
VAXC$DFCVT    
 (     GCVT  & l 
VAXC$DGCVT    
 2     FPRINT  & l 
VAXC$DFPRINTF   
 <     PRINTF  & l VAXC$DPRINTF    
 F     SPRINTF & l 
VAXC$DSPRINTF   
 P     FSCANF  & l VAXC$DFSCANF    
 Z     SCANF & l VAXC$DSCANF   
 d     SSCANF  & l VAXC$DSSCANF                                                                                                                                                                                                                                                                                                                                                                                                                                                                       * * [SYSEXE.SEAS$WORK_0000005C]DFLOATRTL.COM;1 +  , K   .     /     4 O       ~                   - 
    0   1    2   3      K  P   W   O     5   6 秦  7 @\  8          9          G    H  J         
            I $ ! VAXELN command procedure for configuring the VAXELN runtime libraries 6 $ ! for machines that have no g_floating instructions. $ ! 
 $ set noon $ ! " $ ! Configure the sharable library $ !  $ language = ""  $ subject = "shareable" / $ if f$search("ELN$:DMATH.EXE") .eqs. "" .or. - ;      f$search("ELN$:RTLSHARE.OLB") .eqs. "" then goto error  $ !  $ define /user sys$error nl: $ define /user sys$output nl: 2 $ library /delete=(gmath, gpascalio) eln$:rtlshare) $ library /share eln$:rtlshare eln$:dmath  $ !  $ language = "Pascal" > $ if f$search("ELN$:DPASCALIO.EXE") .eqs. "" then goto warning- $ library /share eln$:rtlshare eln$:dpascalio  $ !  $done_pascal_shareable:  $ language = "C"0 $ if f$search("ELN$:DCMATH.EXE") .eqs. "" .or. -9      f$search("ELN$:DCIO.EXE") .eqs. "" then goto warning  $ define /user sys$error nl: $ define /user sys$output nl: / $ library /delete=(gcmath, gcio) eln$:crtlshare 1 $ library /share eln$:crtlshare eln$:dcmath, dcio  $ !  $done_c_shareable: $done_shareable: $ !   $ ! Configure the object library $ !  $ language = ""  $ subject = "object"3 $ if f$search("ELN$:RTLOBJECT.OLB") .eqs. "" .or. - <      f$search("ELN$:DFLOATRTL.OBS") .eqs. "" then goto error $ define /user sys$error nl: $ define /user sys$output nl: $ $ library eln$:rtlobject /delete=( - 	uvx$exp, -  	uvx$gsincos, - 
 	uvx$powgg, - 
 	uvx$powrr, -  	uvx$sincos, -
 	uvx$sqrt)4 $ library /replace eln$:rtlobject eln$:dfloatrtl.obs $ !  $ language = "C"4 $ if f$search("ELN$:CRTLOBJECT.OLB") .eqs. "" .or. -?      f$search("ELN$:DFLOATCRTL.OBS") .eqs. "" then goto warning  $ ! $ $ library eln$:crtlobject /delete=(- 	eln$gcmth_jacket_routines, -  	eln$gcio_jacket_routines)  6 $ library /replace eln$:crtlobject eln$:dfloatcrtl.obs $ !  $done_c_object: 
 $done_object:  $ exit $ !  $ ! Error subroutines  $ !  $error:  $ write sys$error - O "%ELN-E-DFLOAT The VAXELN ''subject' library can not be configured for D_FLOAT"  $ goto done_'subject'  $ ! 	 $warning:  $ write sys$error -  "%ELN-W-DFLOAT " + -G "The VAXELN ''language' modules are missing for the ''subject' library"   $ goto done_'language'_'subject'                                                                                                                                                                                                                                                                                                                                                                                                                * * [SYSEXE.SEAS$WORK_0000005C]DFLOATRTL.OBS;1 +  , L   . $    /     4    $   "                     - 
    0   1    2   3      K  P   W   O #    5   6 3
  7 	]  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                        ,                        ;i $      ELN042.D                       L  
  *[SYSEXE.SEAS$WORK_0000005C]DFLOATRTL.OBS;1                                                                                          $                         k "            @     ELN$CONVERT_REALV2.0-0010-OCT-1990 20:27                   VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]CVRTREAL/OBJ=ELN_BUILD:[ELN.RTL.OBJ]CVRTREAL ELN_BUILD:[ELN.RTL.SRC]CVRTREAL+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB   - datatype conversion routines#   FOR$CVT_D_TE  FOR$CVT_G_TE          	.  ABS  .    P    o   $CODE   Pp$  
     pELN$FLOATING_TO_CHAR_R3 & 	p(  
    pELN$FLOATING_TO_CHAR_VAR_R3 & SQVUV`~Qp`n
P`~VUVSTT^PTVV^^V^Q U U	 FOR$CVT_D_TE FOR$CVT_G_TE(SbVV^  ?     ELN$CONVERT_T_FV2.0-0010-OCT-1990 20:27                    VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]CVRTTF/OBJ=ELN_BUILD:[ELN.RTL.OBJ]CVRTTF ELN_BUILD:[ELN.RTL.SRC]CVRTTF+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB!  ; Convert text to real (F only) 4   ELN$_INVREALSTR  
LIB$SIGNAL  OTS$CVT_T_D         	.  ABS  .    P        $ABS$ 	   P  P       $CODE   P<   
     < ELN$CONVERT_T_F & lP@^ďP(Pln~n OTS$CVT_T_DPOmvPPԼ ELN$_INVREALSTR 
LIB$SIGNALP  ЬPЬQա	PЏ	  P  3     MTH$EXPX-2 8-APR-1988 02:27                    VAX MACRO V5.0-8x  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:MTHEXP/OBJ=OBJ$:MTHEXP TMP$:MTHJACKET.MAR+TMP$:MTHEXP.MAR*  ; Single Precision Floating Exponential   
    MTH$$EXP2_R4  MTH$$JACKET_HND  MTH$$JACKET_TST  MTH$$SIGNAL 
    
MTH$EXP_R4  MTH$K_FLOOVEMAT  MTH$K_FLOUNDMAT          	.  ABS  .    P        $ABS$    P      	_MTH$CODE   P@  @ê@@Ø@7@2@@>X@@@*g@$@D@@@}%    O44g4$V#4qA4B#4Q4B3z4X
37(3$44*4$)36$*>*? @  @  B;1> p7@  
    @MTH$EXP &k MTH$$JACKET_HNDmPP.@QPxTTˏPRTRя   Rʏ  PRP1 1 ˏPRя=  R^я D  RlEPQKQTNTQEQRBRPDQBQPElPS@jSDPS@fSDPS@bSDSPˏTR"BQDQP@BPT Tя 4  RBPPЏ@  Q^SP*R  MTH$$JACKET_TSTP<RPR
n MTH$K_FLOUNDMAT%~ MTH$$SIGNAL Q Tn MTH$K_FLOOVEMAT%~Џ   P Q MTH$$SIGNALTQ   7     MTH$GSINCOSX-1 8-APR-1988 02:43                    VAX MACRO V5.0-8  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:MTHGSINCO/OBJ=OBJ$:MTHGSINCO TMP$:MTHJACKET.MAR+TMP$:MTHGSINCO.MAR *  ; Floating Point Sine, Cosine and Sincos   MTH$$JACKET_HND  MTH$$JACKET_TST  MTH$$SIGNAL  MTH$AL_4_OV_PI_V 
   MTH$GCOSD_R7 
 %  MTH$GCOS_R7 
   MTH$GSINCOSD_R7 
 ~  MTH$GSINCOS_R7 
 S  MTH$GSIND_R7 
 ]  MTH$GSIN_R7  MTH$K_FLOUNDMAT          	.  ABS  .    P        $ABS$ 	   P  P    1  	_MTH$CODE  P      	@!DT-<@:F̾"@|3!/@zjU)^85@uf@     f     >ܥc?ll?l   >[[}?j)%\@ܥcl ܥc@DBiŸ@DBiŸ@-2O#)'ѓJA@DBiŸ @ES*NjȽ^4A>G=ɲO~o?~vvl-6?UUUU3U       @      Ƚ^4A>G=ɲO~o?~vvl-6?UUUU3U<g@,^)D0]>@nz峵3>QZJ</?UUUUCUn	8{%[=Q]Mzm>P0h$?U<]<~\?<Z<E)D0]{% 2[=Q]Mzm>P0h$?U<]<~\?<ZͿM.)D0]=>m8>09A>#,--R?fugԿ%A?BDѭ>acr 9֭#/<\F[xP>jsC۹@      >acr 9֭#/<\F[xP>js)D0]G9 5vԗ[ȟ;_J6Z==;
^/}?j)%  
    MTH$GSINCOS &.  MTH$$JACKET_HNDmPP~}P}R  
 
   MTH$GSIN  &&  MTH$$JACKET_HNDmPP]  
 "   MTH$GCOS  &&  MTH$$JACKET_HNDmPP%  
 7   MTH$GSINCOSD  &.  MTH$$JACKET_HNDmPP}P}R  
 T   	MTH$GSIND &&  MTH$$JACKET_HNDmPPS  
 i   	MTH$GCOSD & MTH$$JACKET_HNDmPPPPVRPP PQoP1QoP1}T~RFЎR}T}P~}R @P1 `>P1 }PVEVVTETR@RDTR@RDTR@RDTR@RDTR@RDTR@RDTR@RETP@PDTP@PDTP@PDTP@PDTP@
PDTP@PDVP@VPPR}P~VPTdTTvTR}R~ErRP@sPDRP@qPDRP@oPDRP@mPDRP@kPDRP@iPDRP@gPTbTVPPbTPvPR}TETTP@UPDTP@SPDTP@QPDTP@O PDTP@MPDTP@KPDnP@PqR}T~}TЎR}P~}RSPmRPP PQϑP"QϑPqR |
4&4&4&w
4&w
4&4&4&|
4&`>PO}PVEPPTEϘTP@ϙPDTP@ϗPDTP@ϕPDTP@ϓPDTP@ϑPDTP@ϏPDVP@VPqTR n4&
4&
4&n4&i4&4&4&i4&RRRR 4&
4&4&
4&SP PQ P%QP1 R J4&w
J4&w
J4&J4&J4&|
J4&|
J4&J4& @PVPT1`>POEPPTEOTP@PPDTP@NPDTP@LPDTP@JPDTP@HPDTP@FPDTP@DPPPqTR 
4&n4&i4&4&4&i4&n4&
4&RRRR 
4&4&
4&4&SP P
RPPQ!P$
}V~SЎS}nV}Pnv}R^}Pn}P}P}RSPcRPP PQP
S z4&z4&z4&z4&z4&z4&z4&z4&QϱP}PV1
SPQP1e
EϳPR` P@RPSP PQjP
S 4&4&4&4&4&4&4&4&QXP}PV1PPQ%P2QPVPPciPTRRVPPcdPTRRQPVPPcWPTRRVPPcRPTRR!@              PSSS TʏT MTH$AL_4_OV_PI_VR MTH$AL_4_OV_PI_VRTRSPPAPJPPQQP~ʏn $^^T ^UTWySbgWRySbg֧TWzP nzPPddzQ dzQzQ֤Qeenخخ   eӏ  ?e7;
T e!я1  eя   5eʏ   UT
բPecPTЮ R1 }PTЮ R1 =eя  (;
я}d=  eSR1V T
cPtTR® T:=eя  ;
դ	}d e T
}PTR® T $(^RySbVzQW QzPWP
zQW zPWdخ֤֤Ю^VnPd֤ Pnfd`fP Pnf`ϲf`fP       @    0       @    0 `CPNPRʏ  PPCPPR}PSʏ?QBPSP@SPRRRSSSRSMBRMBRDRP@BPLEPVRʏR }V~JnS!NSTCTnTCTVnJSRBTVSh@VO}nTʏ? UBTn}P~EPRPTˏQUBTPDϥP@PRDϛT@TRJRS}PSSVNVVD_VBPVSNSVD TV@PVS T @TddTTvTRERP@PDRP@ PDRP@PDRP@PDRP@PDRP@PDRP@PTbTVPPbTPvPPvTVDVVE]VP@^PDVP@\PDVP@ZPDVP@XPDVP@VPDVP@TPDVP@RP T @TddTTvTRE?RP@@PDRP@>PDRP@<PDRP@:PDRP@8PDRP@6PDRP@4PTbTVPPbPTvTPvTVDVVEϛVP@ϜPDVP@ϚPDVP@ϘPDVP@ϖPDVP@ϔPDVP@ϒPDVP@ϐP P T}T~vTRERRTEϻTP@ϼPDTP@ϺPDTP@ϸP DTP@϶PDTP@ϴPDTP@ϲPDRP}TVPP`TPvPPqTedTTvTRERP@PDRP@PDRP@PDRP@PDRP@PDRP@PDRP@PTbTVPPbTPvPPvTVDVVE+VP@,PDVP@*PDVP@(PDVP@&PDVP@$PDVP@"PDVP@ P@P TqTedTTvTRERP@	PDRP@PDRP@PDRP@PDRP@PDRP@PDRP@PTbTVPPbPTvTPvTVDVVEcVP@dPDVP@bPDVP@`PDVP@^PDVP@\PDVP@ZPDVP@XPCPϙP T}T ~vTRERRTEπTP@ρPDTP@PDTP@}PDTP@{PDTP@yPDTP@wPDRP}nTnbTVPP`TPvPPQώV1 VVTdTTvTREχRP@ψPDRP@φPDRP@τPDRP@ςPDRP@πPDRP@~PDRP@|PVPP
Tя   W}T~ʏ  WbTnbPbTbTPvPPDVVJEVP@PDVP@PDVP@PDVP@PDVP@PDVP@ϿPDVP@ϽPPPQϩV1 VVTdTTvTREϢRP@ϣPDRP@ϡPDRP@ϟPDRP@ϝPDRP@ϛPDRP@ϙPDRP@ϗPVPP
Tя   W}T~ʏ  WbTnA&bPbTbPTvTPDVVOEVP@PDVP@PDVP@PDVP@PDVP@PDVP@PDVP@P PP\PRVVEVVPO}PTETP@ PDTP@PDTP@PDTP@PDTP@PDTP@PDVP` V@VPPPPPR  MTH$$JACKET_TSTP<RPR
n MTH$K_FLOUNDMAT%~ MTH$$SIGNAL  5     	OTS$POWGGX-1 8-APR-1988 03:27                    VAX MACRO V5.0-8~  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$                                                                                                                                                                                                                                                   -                        y $      ELN042.D                       L  
  *[SYSEXE.SEAS$WORK_0000005C]DFLOATRTL.OBS;1                                                                                          $                         & "            :OTSPOWGG/OBJ=OBJ$:OTSPOWGG TMP$:MTHJACKET.MAR+TMP$:OTSPOWGG.MAR&  - G REAL*8 ** G REAL*8 power routineJ   MTH$$SIGNAL  MTH$K_FLOOVEMAT  MTH$K_FLOUNDMAT  MTH$K_UNDEXP         	.  ABS  .    PA       $ABS$   PO   b  	_OTS$CODEE P 			






   @              @1
WXCT|@Uφ)B@0%N
ٮ1@+ǃͭJ@Hs[(@##Vl\@)Q]J@o0qRZ0F\@7ssqPEE/G@=dB#[#"A>t@D16	@KSbqz9!.@BSi<Idj@Z}BQ4@GbXKoCڼ@	jgf@q^=7.׬@z>G}mQl?@X̬(J@ΊA;"T
U|@s{^EOT#
@I*	?k+@P#;UI$@:MssZ @/o䵪n{S<@ؽ)U"±	*@r
P<@ՀύH]rZf@7s묌9)@J*
IX:0@eTtK(vb@              J@a(8	R@lwP>^@	:        @TqRv/wxtlcd=0̇=c>o{>k݀N?Ŷ?B.9        o  
   	OTS$POWGG &V~PPn< PQ MTH$K_UNDEXP%~ MTH$$SIGNALˏPX@  XXPVPPPTʏTDϺT>HdXcD/PTPbTPgPT~vnVEVVPE$PR@%RDPR@#RDRP@!PVPP`PdPnXT`TPdnP PT@T1 kPXnXTbTPvPPEPR@RDPR@RDPR@RDPR@RDPR@RDRP@PˏXT}DqTvTRDRPVPP`TPvPPXXXXPPSPX|P MTH$K_FLOUNDMAT%~ MTH$$SIGNAL MTH$K_FLOOVEMAT%~yP MTH$$SIGNAL  5     	OTS$POWRRX-1 8-APR-1988 03:31                 l  VAX MACRO V5.0-8~  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:OTSPOWRR/OBJ=OBJ$:OTSPOWRR TMP$:MTHJACKET.MAR+TMP$:OTSPOWRR.MAR  - REAL ** REAL power routineJ   MTH$$SIGNAL  MTH$K_FLOOVEMAT  MTH$K_FLOUNDMAT  MTH$K_UNDEXP         	.  ABS  .S   P-       $ABS$3   P    ]  	_OTS$CODER* P          ((((((000000008888888@@@@@@@@HHHHHHHHPPPPPPPPPXXXXXXXXX`````````hhhhhhhhhhppppppppppxxxxxxxxxxxD;\)g@      @êg{H@׋@ës@7Q@2`@9Q@>XBK@3e޽@X7@*gU@$@Dk@*@9$@}%$̆ A      3Yv8f <r%  
     	OTS$POWRR &PPPQ< P MTH$K_UNDEXP%~ MTH$$SIGNALˏPT@  TTP QˏPRBϜRRTRRcBPR PbRPfPRERRQEC#QP@CO8PDQP Q`PdPRNTP Q`PRPPP~ nRT TT TkdPRAM  RPBM  PbPRIPTGE'RP@%PDRP@!PDRP@PˏTRRR}BvRDRP`RPvPP TTPP SPTSPP MTH$K_FLOUNDMAT%~ MTH$$SIGNAL MTH$K_FLOOVEMAT%~yP MTH$$SIGNAL  6     
MTH$SINCOSX-1 8-APR-1988 03:18                   VAX MACRO V5.0-8  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:MTHSINCOS/OBJ=OBJ$:MTHSINCOS TMP$:MTHJACKET.MAR+TMP$:MTHSINCOS.MAR*  ; Floating Point Sine, Cosine and Sincos   MTH$$JACKET_HND  MTH$$JACKET_TST  MTH$$SIGNAL  MTH$AL_4_OV_PI 
 h  MTH$COSD_R4 
   
MTH$COS_R4  MTH$K_FLOUNDMAT 
   MTH$SINCOSD_R5 
 H  
MTH$SINCOS_R5 
   MTH$SIND_R4 
 G  
MTH$SIN_R4          	.  ABS  .   P       $ABS$?	   P  P     	_MTH$CODES  P@!hIA!hA˙A!hl*>@  8e*>2&<    L=*^ފl7Ϫu=@  l7Ϫu=o2O    }#<I/]>-12@  w!40Ƅ2vv5ݥm.cm;Q<M  
    < 
MTH$SINCOSH &-  MTH$$JACKET_HNDmPPHPQ   
     MTH$SIN &%  MTH$$JACKET_HNDmPPG   
     MTH$COS &%  MTH$$JACKET_HNDmPP<  
   < MTH$SINCOSD &-  MTH$$JACKET_HNDmPPPQR  
     MTH$SINDV &%  MTH$$JACKET_HNDmPP@  
 4   MTH$COSDR & MTH$$JACKET_HNDmPPhPPTWRPP PQI@P/QA1P1 }S~R6ЎR}SPrЎQ @PO:PDPTETTUEsUQ@qQDUQ@mQDUQ@iQE|UP@zPDUP@vPDUP@rPDTP@TPPQPRVPSdSSSPQЎSE?SP@=PDSP@9PDSP@5PDRP@RPR}S~}SnRPnЎQSPURPP PQI@P#QA1PyR ov4&v4&v4&jv4&jv4& v4& v4&ov4& @P0:PP(PTEPPQEϥQP@ϣPDQP@ϟPDQP@ϛPDTP@TPVPRdRRE}RQ@{QDRQ@wQDRQ@sQDPQ@QPSR x	4&4&4&x	4&s	4&	4&	4&s	4&RRRR 
4&
4&
4&
4&SP PQI@P#QA1PRR :4&j:4&j:4& :4& :4&o:4&o:4&:4&Ǳ @PVPS1P:P EPPQEϺQP@ϸPDQP@ϴPDQP@ϰPPPSR 4&x	4&s	4&	q4&	4&s	4&x	4&4&RRRR 
4&
4&
4&
4&SP PRPP4CP}S~|}SP$ЎQPPUЎP8UQSPRPP P4CPS 
(4&	(4&	(4&
(4&
(4&)
(4&)
(4&
(4&Qe=.PPT1eSPQe.P1E;QPQ P@QPSP P4CPS 	4&
4&
4&)
4&)
4&
4&
 4&	4&Qe=.PPT1PPQQ{ASP)QAPcEPSRRc=PSRRQAPc,PSRRc$PSRR`      PRRRSʏS MTH$AL_4_OV_PIQSQRP LPJPP~ʏn yRa~QyRaSzPT SPTŮPnnT    Tnӏ  ?nG^}SnTn֮, Tяn1  Tя   nK}nSՎ^TRnSPTRȏ   TnTS S`PSS1 ʏ   TnTS S`PSS1 S~Џ  я  ?nT֮֮1 я}Sn= @ SR^1~ SnnPnnnS SScSϒSbPSRS1O S~Џ  я  nT֮T}Sn TnnnPnnnS S`PSRSn^QyRaSzPT SPT       @    0       @    0 LPEˏ  PQ LQQPˏ  QRBRQ R@RQPPPRRRPRM@PM@PDQPQe=`    PRjRSSSTNTTD4C  TBPTSNSTD4  T@PTS S @S7dSSEςSP@πPDSP@|PDSP@xPDSP@tP   SbSbSPvPPvSTDTTE8TP@6PDTP@2PDTP @.P S @S7dSSESP@PDSP@PDSP@PDSP@P   SbSbPSvSPvSTDTTETP@PDTP@PDTP@P P SSQDQQEQP@PDQP@PDQP@PDSP`SPvPPQ"@S7dSSEϾSP@ϼPDSP@ϸPDSP@ϴPDSP@ϰP   SbSbSPvPPvSTDTTEpTP@nPDTP@jPDTP@fPDTP@bPQ"@S7dSSETSP@RPDSP@NPDSP@JPDSP@FP   SbSbPSvSPvSTDTTETP@PDTP@ PDTP@PDTP@P P S}S~DSSESP@PDSP@PDSP@PDnPÏ   nSbSbSPvPPQB.TSVTSdSSESdyP@PDSP@PDSP@PDSP@P  Sя   T}S~ʏ  TbSn`PbSbSPvPPDTTE{TP@yPDTP@uPDTP@qPQB.TSVTSdSSE`SP@^PDSP@ZPDSP@VPDSP@RP  Sя   T}S~ʏ  TbSn`PbSbPSvSPDTTE TP@PDTP@PDTP@P PRTTETTP)PQEQP@PDQP@PDQP@PDTP T@TPPPP  PR  MTH$$JACKET_TSTP<RPR
n MTH$K_FLOUNDMAT%~ MTH$$SIGNAL@  4     MTH$SQRTX-1 8-APR-1988 03:19                   VAX MACRO V5.0-8{  MACRO/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/LIS=LIS$:MTHSQRT/OBJ=OBJ$:MTHSQRT TMP$:MTHJACKET.MAR+TMP$:MTHSQRT.MAR&  ; Floating Point Square Root routineN   MTH$$JACKET_HND  MTH$$SIGNAL  MTH$K_SQUROONEG 
    MTH$SQRT_R3         	.  ABS  .   PT   |   	_MTH$CODE  P@  
     @MTH$SQRT &  MTH$$JACKET_HNDmPPPPQS<PRRRPPD_P@ J<P  PD@P@#KPRRRPGPQR@RP PVQRQfPR@RP Pn MTH$K_SQUROONEG%~xP MTH$$SIGNAL  >     PAS$F_FLOAT_IOV2.0-0010-OCT-1990 20:12                   VAXELN PASCAL V4.2_95T
  e
      e    (\	PAS$IODEFPAS$WRITE_REALE_FPAS$WRITE_REALF_FPAS$READ_REAL_F 
PFV	 
F_VALUE% 
TOTAL_WIDTH% 	PAS$R_PFV  
	 
% 
% 
FRAC_DIGITS%  
	 t   FOR$CVT_D_TF  FOR$CVT_D_TE  ELN$CONVERT_T_F  PAS$$READ_REAL  PAS$$WRITE_REALF  PAS$$WRITE_REALE      P  
       PAS$READ_REAL_FE  $^ޭP ELN$CONVERT_T_Fԭ߭P PAS$$READ_REALPP   
  (    PAS$WRITE_REALF_Fc  (   P ^޼޼޼nPԭP FOR$CVT_D_TFԭ߭ݮݮP PAS$$WRITE_REALFT  
  h    PAS$WRITE_REALE_F]  h   P ^޼޼nPԭP FOR$CVT_D_TEԭ߭ݮP PAS$$WRITE_REALET       $CODE     $DATA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       .                        i $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         п              $ * [SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1 +  , M   .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 `\u  7 *)]  8          9          G    H  J                             0 D X     0205      (  t`          0                                  ECL                                    VAXELN V4.2-00 t 05-05           	            
          F              
       ?         !        DAP_001"      !         
LIBCOMMON_001"      !        
DPASCALIO_001"      !         
ELNACCESS_001!      !        FILEUTIL_001      !         DISK_001"      !         
GETMSGSHR_001"      !        
PASCALMSC_001"      !         
PRGLOADER_001      !         DDA_001                               ECL> -     fz- tz-                                                                                                                                                                                                                                                                                                                                                    A       FCMD                                                A       FOUT                                                      (                                                                                                                                                                                       	      \
  `  d  h
  l  p  t  x                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              	                                   Device:    Directory:     File:  From:  Node:  Label:    	 Program:   Time:  To:    What:  UIC:   Symbol:                                                                                                                                                                                                                     logged out at -W-NOTIMPL, command is not implemented  UIC = [                               %SHOW-W-NODEV, no devices are available%SHOW-W-NOSUCHDEV, no such device available                                                         Name                              Address                     Number    NumberDevice                               CSR       Vector   IPL     BI      Adapter  %ECL-E-CPNEST, command procedures cannot be nested%MOUNT-E-DEVICE, error mounting device %HELP-E-ERRHLP, error executing HELP command; file %DISMOUNT-E-DEVICE, error dismounting device -I-IGNQUAL, qualifiers appearing before this item were ignored%ECL-W-SKPDAT, image data (records not beginning with "$") ignored, DIGITAL EQUIPMENT CORPORATIONCopyright  VAXELN Command Language RTMISSING:[MISSING]                                                                                                     @                       -E-TOOFEWARG, too few program argumentsDISK$DEFAULT_VOLUME:[000000]ECL.HLP                               %UNLOAD-E-UNLOADERR, error unloading Name Service not enabled on this systemError returning Name Server informationName Server address is Name Server is the local systemName Server location is unknown0 00:00:15.00(            %SHOW-E-NAME, error displaying name server-E-SETHOST, SET HOST facility not in system SET_HOST has been deleted-I-DELSYM, Global symbol  == " == ""!-- %SET-E-SETTIME, error modifying time modified%SET-I-MODIFIED,  file protection modified%SET-I-PROTECTED, %SET-E-NOTMODIFIED, error modifying %SET-E-SETDEF, error setting defaults to None %SET-E-SETTERM, PASSTHRU not available$ACCESS:50   75   110  134  150  300  600  1200 1800 2000 2400 3600 4800 7200 9600 1920038400  Width:   Passthru         No Passthru       No Line Editing   Line Editing   No Wrap        Wrap             Insert           Over Strike    Eightbit       No Eightbit      Scope          Escape           No Scope       No Escape         Passall           TTsync           Echo              No Passall        No TTsync        No Echo        Terminal:   Speed:    Parity: Ignore   Parity: Mark     Parity: Space    Parity: None     Parity: Even     Parity: Odd       Character size: %SHOW-E-SHOWTERM, error showing terminal%SET-E-SETTERM, error setting terminal.EXE loaded%LOAD-I-LOADED, image %LOAD-E-IMGLOAD, error loading %LOAD-E-ADAPNUM, ADAPTER_NUMBER must be 0 - 15%LOAD-E-ADAPNUM, ADAPTER_NUMBER qualifier missing%LOAD-E-BINUM, BI_NUMBER must be 0 - 15%LOAD-E-BINUM, BI_NUMBER qualifier missing.SYS%LOAD-E-IMGLOAD, error loading f                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  /                        KJ $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         M& "            ile%INIT-E-ERRINIT, error initializing device ALLALAQUITQUIQUQNONFALSEFALFA0YESYEYTRUETRUTR1%TYPE-E-OPENIN, error opening .LIS%TYPE-E-ERRREAD, error reading  renamed to %RENAME-I-RENAMED,  not renamed%RENAME-E-NOTRENAMED, ) blocks files deleted (-I-TOTAL, %DELETE-W-SEARCHFAIL%PURGE-W-SEARCHFAIL%PURGE-I-NOFILPURG, no files purged for %DELETE-W-FILENOTDEL%PURGE-W-FILENOTPUR-E-SYN, file specification syntax error%DELETE%PURGE%DELETE-E-DELVER, version number or wild card required %PURGE-E-PURGEVER, version number not permitted;0 deleted (%DELETE-I-FILDEL%PURGE-I-FILPURG, error deleting %DELETE-W-FILNOTDEL%PURGE-W-FILNOTPUR, delete? [N]:;-E-ACTPROGRAM, error activating program   \     $                        -E-NOMSG, Message number %X-W-VALREQ, missing qualifier or keyword value - supply all required values-W-UNDSYM, undefined symbol - check validity and spelling-E-STRTOOLNG, string argument is too long - shorten-I-RSCNOTSUP, read subsequent command input not supported-I-ONLGBLSYM, only global symbols supported-W-NULFIL, missing or invalid file specification - respecify-W-NOVALU, value not allowed - remove value specification-W-NOQUAL, qualifiers not allowed - supply only verb and parameters-W-NOPAREN, value improperly delimited - supply parenthesis-W-NOKEYW, qualifier name is missing - append the name to the slash-W-NOCOMD, no command on line - reenter with alphabetic first character-W-NOATFIL, no file name for command procedure-W-MAXPARM, too many parameters - reenter command with fewer parameters-I-LBLNOTSUP, labels are not supported-W-IVVERB, unrecognized command verb - check validity and spelling-W-IVQUAL, unrecognized qualifier - check validity, spelling, and placement-W-IVQLOC, invalid qualifier location - place directly after verb-W-IVPROT, invalid protection code - only use combinations of R,W,E, and D-W-IVKEYW, unrecognized keyword - check validity and spelling-W-IVCHAR, invalid character-W-INVUIC, invalid UIC - must be of the form [group,member]-W-INSFQUAL, missing qualifier - supply all required qualifiers-W-INSFPRM, missing command parameters - supply all required parameters-W-CMDTOOLNG, command line too long-W-BADVALUE, illegal qualifier value-W-ABVERB, ambiguous command verb - supply more characters-I-ABRNOTSUP, command line abbreviations not supported-W-ABKEYW, ambiguous qualifier or keyword - supply more characters-W-ACTPROGRAM, error activating program ECL^YTISFSYS$OUTPUT:%DIRECT-W-NOFILES, no files found file directory directoriesGrand total of  blocks. files%DIRECT-E-DURLIST, error performing directory operation%DIRECT-E-OPENIN, error opening Directory  files.Total of *.*;*DIRECT%DEFINE-E-SETHLP, error setting help file to ECL.HLP%CREATE-E-OPENOUT, error opening $CREATE%CREATE-E-ERRWRTFIL, error writing file  created%CREATE-I-CREATED, -ELN-F-INVFILSPE, invalid file specification directory file not created%CREATE-E-DIRNOTCRE, ;*.**s)) record block ( copied to %COPY-I-COPIED, %COPY-E-OPENOUT, error opening %COPY-E-OPENIN, error opening ][                                as output-E-OPENOUT, error opening -ELN-F-SYN, file specification syntax error-E-OPENIN, error opening %ECL-W-TNS, Terminator not seen24~26~B[BA[AC[CD[D                                                     logout
_ SYS$INPUT:,                             ,-%0000 00:00:00.30"::password       @                        . as input%ECL-E-OPENIN, error opening .COMeln$ecl_login%ECL-W-READERR, error reading            FIN_TEXT                                 FOUT_FIX                                  	FOUT_TEXT                                 F                              1987, 1990V4.2-00Þ^QY^WWX<XVV^(n(WX (nЬRߢ JYA PǞ^|0 m)YZ^-+( 
tZc	Ͼ R߭,2R~t>  RRZ1 RdVVW	WX<W\\^n\(l(V<XVV^(Wln(	ϽX (n߭ Qϣ]tÖ q{0^޼Rb(bZ޼WgRX:JRP<RXPXXp2RYYXVVYRR,  ڈ@ FTTS2URRUTSTST(TXXXYYSR:SHP<SRPRRZZZ%<SUCeTS RRRRe(R ^^޼XT9^h
2hTRTTT[1[VUSV,U)VFRRRR"SVUVSVUU1ATV[*T'VRRhSBcRR R	VTV[TِTRR1TV[*T'VRRhSBcRR R	TVV[TِTRR1 TV[*T'VRRhSBcRR R	VTV[TِTRR1 V1 V[RZ:ARFP<RZPZVRRSS2hRRVZZZRR<YY^nY(Si}<WW^(in(Jh hh(hn[R׭íR[[[S2hRSR[-[V2hRRSRRUT9ϞUC
2UTRTTT[V[[18 ^eRS QR߭a }Pݢߢ߭ Ѣ Sݢ @  ; SPϞ^޼Rb(b ^޼Rb<}  b 8 _S1 ϲ1R:ϦS P<SRPRRTRYRZR:υS P<SRPRZRR[1c1PJWW)TV<SUCeTS RRVVRRe(RkWJV<VXX^(nV V(VnV RRRVR(RIc<STCdRS 	dI1 
OVY<VXX^(n_V V(VnV RRYYRVR(RJc6V<SUCeTS RRVVRRe(RJ]KTTSRS   SϺRR SST2RR[UURRVTSRSVSS SS(SE] UV2RR[RRY<VXX^(nEV V(VnV RRYYRVR(RKc
( S'2SRR  R; . ޼R1 lbÐ TTSRS   SώRR SSTTRR,S2SRR R   Q\ϫ \W P$^|H mAT޼W޼VЏ   :ԭUޯ]
r x U2ݏ  I  pW  UV  UΟ  P^޼Vf(fTPWQ2XPX1 W1 @ UUSS"QURRDTURR"1 Q1 RS   SRR SRRUURRDT]S!WSS S	TDDf<DT1S/"TSTDfϳTSTURRCT
URRDTPPXW1BQT%޼RDvTTTb޼RϢDTbϞ^Y޼Rb(bՔ^޼Խ޼[kR 􂰭SSSS(SՂ1 魾2
ɴ ݭ ݭȟɴ ɴ ok oЏ( ĐlT2TSkZ2ZRRSSS   GTV<VXX^(TntWV V(VnV RRZZRVRg(Rck-k  4 PЏ( 1ռ1 25RR޼Zj[2[RRR   	Џ  V<VXX^(nWV V(VnV RR[[RVRg(Rc2RüR^Q\Vd̜Zì`RRZY̬̤S2SRR Rƴ ZWd`RWRRWW̰ ̰̰(̰̳̲ kZWY̰S2SRR ̲Rƴ ƴ W̨Y1 
ƴw 
ƴh YXX``XXGX̰ ̰̰(̰G̳̲̰S2SRR ̲Rƴ  ƴ	 `SSY̬ìSRR̤ԬX̨SWY1^X
ƴъ ƴ ̨̠ ^QR$S²`PP\L±P\L±\PP\P ²Pôr Ϟh^Wԭ|Ԕt޼llͨͬͤdͨͨ͜͠xl| jb0
 1q%ЬR~bbщ S E ЬRblx1\cﭳ|~ ߭߭ПXP~H߭ ѭ||  nxͱ(ϑͳ͜1Э\X\p1hXRRp1YR̀̀RBW͇͇SSS   	S   t͇RR[1t1 ͇RRK[RS   SRR1
RS`   SϢRR1
S;1
SO   1
S[   1
S?1
t[RR

(T-T FM-T 9B-T +7-T ,-T !-T -T -T  ͇͇͇͈͈͈͈
lx1	V-V ϵ-V Ϩ͈@ͨ,ͨRR`Ǵ Ǵx ͨϱ1	-V S-V F
͈1 ͨSSRR`S kM
Ǵ% 
Ǵ Ǵ ͨͬ`ͤRíRͤͨ͠ԭ5S͠.TͤSR BͲǴɆ Ǵ ͨ쭳1-V ψ-V {͈Aͱ(ͳ2ͱRR͜]Q Ϟ]Q ύ쭳1o͈)
Ǵ1 
Ǵ" ]Q 1?-V -V J]Q ;S2SRR RǴ Ǵυ ͨ͠͜뭳1-V Ϗ͈|||뭳1͈1 ͨS͠TST1TRR`T kN
ǴK 
Ǵ< Ǵ- ͨͬ`ͤRíRͤͨ͠ԭ14ST[[RͤS[ CͲ[Ǵ Ǵۄ Tͨ1͈-V ϤVͨBͨRR[ψKͱR[[R[ Ͳ[Ǵ                                                                                                                                                                                                                                                    0                        . $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                          "     "       Ǵ} ͨϵꭳ1͈1	ͨZZ1ϓͲYͬdR, RIͱdYZ͠[[͖ͤXXZR͖Ͱ ͰͰ(ͰBͲͲͰV,VͲ ͖Hͳ,VͲ ͖Iͱ[YYRYZRZR[KͱZ[[SS͠RRSRS[χKͱR[[R[ Ͳ[Ǵ Ǵ| ͨ͠RRͨ͜͠RR͜ͨ1͈   1PͨYY1 k1͌͜ЭZ͌ZRR`͐R͐1YZRRR͐1 ͰIͰͲͰS2SRR ͲRǴ Ǵ˂ Yͨ͠͌ͨ͜VV͠1V͠[[XXͰ ͰͰ(ͰFͳͲͤV,ͰͲ XFͲ1Yͨͨ͠͠[[XͤͨVXͰ ͰͰ(ͰFͳͲ,ͰͲ XFͲ͌͜͠Z͐ZZRR[[SSRBͱSRǴ ͰT2TSS ͲSǴс  Ǵ RSR ͲRǴ Ǵ 1YYY` Ǵx Ǵi 8Ǵ\  ǴM Ǵ> Ǵ/ ͨͨ͜͠V͠XVX1=VX[[YͤVYͰ ͰͰ(ͰFͳͲ,ͰͲ YFͲXX`[[SSRϜBͱSRͰS2SRR ͲRǴ  Ǵ [RRSR ͲRǴx Ǵa 1ͬ1ͬ͜
ǴB 
Ǵ3 ]Q  Ǵ Ǵ
 `ͤ1-ͤ1&͈
1͜   1͚(Ϝ͜|~͚=ͱ	ͳ͜x1|1 ͨ͠1 ͠YYRR`1ͤͨVV͜RRXXͰ ͰͰ(ͰFͲͲ͇RRFͲ,ͰͲ XFͳͨ͠TY`TTRR[KͱR[͇RRǴ
 ͰS2SRR ͲRǴ~ TRT ͲTǴ~ Ǵ~ ͨ͜͠1 ͈Ǵ~ Ǵ~ ͤͨS͇RRCͲͨͨ͠ͨ͜͠RR`1  k1 
ǴN~ 
Ǵ?~ Ǵ0~ ͨͬ`ͤRíRͤͨ͠ԭ8x̀\\̀X
Ǵ} Ǵ} p̀\x1ЬS͜RRc cc(cͳϞ^QX޼Rb(b޼Rb(b^
(~ ~߭c  P1 SSYYZZ[	[<YWW^nWgRp(S<ZVV^nV(Ygf(ϋ<[WW^nW(Zfg(<VV^([gn(	mヰ (n  +(+ PϞ^QX޼Rb(b޼Rb(b^
(~ ~߭5  P1 SSYYZZ[
[<YWW^nWgRB(S<ZVV^nV(Ygf(<[WW^nW(Zfg(<VV^([gn(
 (n +(+ ϸPϞ^Ь^Q>PSR { (Q>PSR k{ (V,%  ǈ˞UUS2VTRRTUSUSU2VRRURR(EVUUS2VTRRTUSUSU2VRRURR(EЬSSXXYZZY[<XWW^nWgRu߂(S<YVV^nV(XgfϘ<[XX^(Yfn(ZW[VVV(VnVRRRVRg(R$c^޼Rb(bѰRS:RP<RSPSX:*RP<RXPXW:RP<RWPWSXRRR(Cѭ2孰筴|~9y ޼VIXWWW(Hѭ2孰筴|~x IfϞ^QZ^޼W޼V fgZQ4﫸 	
	 
w^1ﯸ|~fgx + |~fgyx 1 b޼VfXXY	Y[<YWW^nW('g(X<[VV^(Ygn(	Ϫރ[ (n =޼VfXXY
Y[<YWW^nW(Ϧg(X<[VV^(Ygn(
܃[ (n 1QPSR w  (VVXXYY[[<XWW^nW(g(V<YVV^nV(Xgf(Ϭۃ<[WW^nW(Yfg( <VV^nV([gfρۃ<WW^(fn( (n(<SUCeTS RRRRe(Rۤ&<SUCeTS RRRRe(Rڤ<STCdRS 0dڢ&<SUCeTS RRRRe(Rϟڤ 3Ϟ^QV޼޼^޼Yi[  P1e RT-RD BTTTS2iRRRRZSZ[W<[XX^(Sn(ZG[i ii(in   SR-SB U޼WRRS2gRRRRZSZ[X<[YY^(Sn(ZH[g gg(gnTSЬR-TC S"޼SRRc cc(c޼Rb(b  P1g62RRRRSRS (B 1 SSRR (C d52RRRRSRS (B *SSRR (C ЬR|~ by  PTЬS~ cV  PTϞ^QV^޼Rb(b~~  PRPRR1 ޼WgYYZZ[<ZXX^nX(Ih(Y<[WW^(Zhn(׃[ (n ް,(,Ϲ ϭ	WW޼ZRj (b jW$r dŰjXXYY[<YWW^nW(|g(X<[XX^(Ygn(Lփ[ (n <ZjXXYY[<YWW^nW(ϼg(X<[XX^(Ygn}ϠՃ[ (n ϕϞ^Q[V^޼S Kr׭߭q }Pݦߦ߭ Ѧѣ|! <<}УRR<}  pR 	  gRbhЫRТWgY(YZ<ZXX^((ϧn(YZ (nЬRߢ Ϻܟu[p PϞΐ^\|p mQVW͠Џ   ͤgͨͬʹЏ   ͸"ͼ(ԭ^͐ԭ޼XПhVQUP1t͔͔]jQcE0hR.͔-߭,߭+2R~͠
Co 1 hR͔-߭,߭+2R~͠o 1 @hSR.͔-߭,߭+$R"	2S~ʹn 9hSR͔-߭,߭+$R"	2S~ʹn 1jЭT'VU-UX  ЬRUb bb(bX11E]͠Tn  q1  1
Ǵ3n Ǵ$n o}ϲ o*}S2SRR R͠ n ͠m ﴭ͠m  1}1 0ttm 1t1 ~t}ym tjm ϕ}S2SRR R͠`m ͠Im  }S2SRR Rɬ.m Ｌm 1T-!Ɓ}o(}c~͠l /ʹl ʹl ʹ|l a1 ޼XhZZ[[͚<[YY͐^nY(i(Z<͚XX^([in}ϺЃ͚͟ ͟͟(͟n͡ ͟ϭjh޼XhZ!Z[
[͘<[YY͐^nY(!i(Z<͘XX^([in(
Wу͘͟ ͟͟(͟n߭͡ ͟Aխ
ݭBl k Ϟ^QV#[(Ϛ^޼W~~dg讀  P   g[j(g]hgY-YZ<ZXX^(-n(YZ (n  υװ+(+ψ  kϞ^Q, - P {(Ϡέ^ <~9k RPh0޼VfRQ P15(P7~ R~,5f  
 QIA9 1	)! 9,46fh@j *޼R09,46bShj ,1K
97 77(7;97	7Ϻ|||
K19@1.51#.11
	1	1,1޼ 6
7 ,54Rh7i - 461d{:(P~ {P~h rh 1 cp[Mh 	 W	6h #h  &qh Xh Kh 
 
ۧ@h 
X4YYX[2[Z<XWW ^nW(9g(
8<[VV^nV(Xgf(Y6Z fZg vg ig $4
(46,XX1R$R R$5WWP p{Ϯ4P~ {P~Xg ?g , ~ P {5S2SRR 7Rﻦ g ﮦg $1W1UT$
WT2WS$RRRO   RSRTTeP~ {P~Sf Ff ,  P {$$R RSSSRRQ   RRR,57 RC{*$R RSSSRRQ   RRR,57 RC{$4P~ {P~ﾥ#f ﱥ
f , I P {25RRV1V$R R$4P~ {P~je ]e ,  P {V1F$R RSSSRRQ   RRR,W7 RC{$1P~ {P~ce Je , ω P {1 X<S1 XS1 f W WX	XY<XVV ^nV( ρf R(W<YWW^(Xfn(	ϐ˃Y+ ++(+n-, +#7+(7-, +ѐ1{(P~ {P~vd ]d ,1(1
,1670,54Rh.d - 461j﨣11~1s

_c 	 i	Hc 5c  c 01  1P ϬYc Bc /Т-c ｢c n٢Ң, Lb b 2* `b Mb  6b )                                                                                                                                                                                                                                                   1                        P $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         ,f "     3       b .sb 	bb |1 ԡ-b 
 
｡"b X4YYX[2[Z<XWW ^nW(9g(8<[VV^nV(Xgf(Y6Z fZea Xa Ka 4
(46,VVN2* 50  0S<Rգ$ף$0R$1 V<S1 VS1 , V 8VVa ﳠq﫠i5S2SRR 7Rv` RRRSR RX` 8S2SRR :R9` ,` ,S,,1G1
%	
ޟ7` 1a1V	 	ﱟ` _  :_ 1  P ]_ J_ /9_ &_ nB;, ϵb_ K_ 2* ρɞ._ ﶞ_  J_ ^ .^ r^ y1n13^  ϸ^ 	j^  {P^ 
 X
ҝ7^  sﻝ ^ 精	^  =]  q] 1  P G] 4] /#] q] n,%, ϟL] Ԝ5] 2* kﳜ] ]  4\ |\ 1 .h\ [\ 1 1 !+(!ϗ-|~+1 S!+(!q-|~+r<}  g8޼VfX XY	YZ<YWW ^nW( g(X<ZVV^(Ygn(	Z+ ++(+n-, +g,Rh\ RhS\ 00:\  ^QSСR\[  j"
b[ e[ ~P:[ A[ ~&̴[ ̴[ ,[ QVЬRѢ<}  
 W(Ѣ<}  ϑVP[  VQ WWPǞ^Q|+[ mQY!Z޼Rb](b_޼Rb^(b`^ l   0Z #Z ʴZ 0](
<STCdRSd<STCdRSdϼ ԧ<STCdRSdϭ߭|~ @ ݭgް^S2SU`YZ 2RSRcyY 2yR{SRcY 2RSR	c
͉Y 2͉R͋SRcS2SޭɀS2SɂS2Śޭͅ\Y 2RSRyc}]S2Sq_uqý	lUd
h   d1 ͟l|~d |~l߭߭߭d@ нݭd  1 ]Q bѭ<}  4 X W W 1 \߭ \;u]Q ^W,WXYR(ω-RY((Q<XVV^(,-n(W`X\ \\(\n^d \]Q Ϗl    ݪ @  \^XЬV     @{:z.p0k*l$dV1RϪ(ͮR(B ϘFg(F ͮi|~gr1Rj(ԷͺR(6$:͹(:ͺͻ|~͹71R/(ϙͶR(:ϯ>͵(>Ͷͷ|~͵1rR(^R($P(((|~17VRϷ(!R(#𵂰'('|~τ1V1VRu(߶ͩR(G eKͨ(K ͩͪ|~ͨ=1VR3(ϝͱR(?洂CͰ(C ͱͲ|~Ͱ1sR(_͵R(;m?ʹ(?͵Ͷ|~ʹ¿18RϺ($R( ( |~χ1R(鵂ͳR(=ϞAͲ(A ͳʹ|~ͲI1VR?(ϩͦR(J Nͥ(N ͦͧ|~ͥ1}R(iͯR(A ϑEͮ(E ͯͰ|~ͮǾ1=RϿ()ͥR(K Oͤ(O ͥͦ|~ͤχ1R(鴂ͮR(B τFͭ(F ͮͯ|~ͭG1R?(ϩR(& *(*|~1R(nͩR(G ϜKͨ(K ͩͪ|~ͨ̽1BVR·(,R(..2(2|~Ϗ1VRυ(ﳂͩR(G ϨKͨ(K ͩͪ|~ͨM1VRC(ϭͭR(C #Gͬ(G ͭͮ|~ͬ1R(m͵R(;Ϫ?ʹ(?͵Ͷ|~ʹм1FVRƶ(0ͭR(C (Gͬ(G ͭͮ|~ͬώ1Rφ(𲂞ͷR(9ϱ=Ͷ(=ͷ͸|~ͶS1VRI(ϳʹR(<8@ͳ(@ ʹ͵|~ͳ1VR	(sR(+ͬ/(/|~ֻ1LRε(8ͷR(9Y=Ͷ(=ͷ͸|~Ͷϛ1hRϏ(ͽR(3竂7ͼ(7ͽ;|~ͼ\1 RT(ϾͷR(9s=Ͷ(=ͷ͸|~Ͷ!1 VR(ρͦR(J ꪂNͥ(N ͦͧ|~ͥߺVhRԴ(>R(ώ 	N '(}|~ωVV11'V1%2sRRVRRW,  $FJTTS2WURRUTSTS^S ϩFM STﲍRS BS"M \~lM [M -WFǍ  ϑk dی@M 2SSASST7RS BS琉M \~L L  ^QSСRC\ 1 L  j"
L L ~nXL 
_L ~D̴0L ̴9L JL Ϟ^QQZ[޼^ّ߭Ͻ#Ȓ߭Ϩ#﷓߭ϓ#璉߭~#߭i#߭T#s߭?#b߭*#7    ÊK ڊK ˴J ݊1,Ҋ1 ޼ScT2Tޣ̐S2SÐｑS2SﴑﮒS2S勒S2SS2SS2SxrS2SicS2SxY|x߭߭߭߭߭߭߭ ߭dh  1޼ScT2Tޣ
J 2
RSRc͂}J 2͂R̈́SRc^J 2RSRcS2SS2S~xS2SoiS2S`ZS2SxP|IS2Sp?t8S2S.'S2Spx߭߭߭߭߭߭߭ ߭dh  1@麗1 ޼ScT2TޣS2SS2SS2SysS2SjdS2S[US2SLFS2S=7S2Sx-|x߭߭߭߭߭߭߭߭dh  1[޼ScT2TޣRoH 2RRTSRJcNNH 2RSRcv-H 2vRxSRncrcS2SfYjRS2S^HbAS2SV7Z0S2SN&RS2SFJS2S>BS2S6:S2S.2.6>FNV^fnJ߭dh   duh]Q ϼ޼WgX,XYR(fRЭ((m<YVV^(,n(XYͿ ͿͿ(Ϳnd Ϳϥ1 1 |~d |~߭߭߭d@ нݭd  ЬRbQ<]Q mE Oѭ<}  3 ϗHE ;E .E Ϳ߭ Ϳ,   ]Q x ݫ @  Ϟd^Q\СX^d܄1MRS:ROP<RSPSS1SV-VO PR1 M;
(MO~~@;s  P eRRSRSͿͿͿ(ͿB2Ϳ̀̈́|~͐̀@D P͐Q1 1 1 VP PP(POR\Q >M
(MO~~@s  P \RRSRS(B2̀̈́|~͐̀{C P͐Q甬 91  1 QVVYL[[YZMzzZn<YWWd^nW(g(VS<ZVV^nV(Ygf([N<nYY^(Zfn(zOnVV V(VnPV RRRVRN(RÞc꟬NωRR蔬RRe 1RVVYL[[YZMxxZv<YWWd^nW(g(VT<ZVV^nV(Ygf([N<vWW^(Zfn(xOvM MM(MnO M@M9B  @1 ڀ度N(ϿP
N(ϝPNYMZZY[<YVVd^nV(NPf(a<[WW^(Yfn(ZO[} }}(}n@ }%18DpQpRޢPŚR A ́SP SPS(S̓UpR4N(ϥP
N(φPNYM[[YZ
ZtSlltj<YVVd^nV(NPf<ZWW^nW(Yfg([O<tVV^nV(Zgf(
                                                                                                                                                                                                                                                   2                        <!h $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                          "     D       <jYY^(tfn(lUjVV V(VnPV RRRVRN(RcpRѢ<NSNTCdRS 0d뤢&<NSNUCeTS RRRRe(R NUϞμ^QVСYU^ͼԦRXX\LZZ\[<\WWͼ^nW(g(XT<[XX^(\gn(ZN[\\ \(\n\ RRMMR\R(ROcSS~߭cn  P 1 <~? P|~߭(? 1  ߭? pS~߭m  P JRRSRSܱ(B2|~G> P߭> > Ϟ^QQ$^|4޼VfO(fQ}M(͡OM~$R~<Mfm  P1 SRSR RR(RBTfO(fQM}4$R1Db|/3(/ј5 3ة1$R1.|73(7f5 3Ϥ1 ||N(1P
N(PNXOZZXY	Y[<XWW^nW(NPg(<YVV^nV(Xgf(ZQ<[WW^(Yfn(	e[3 33(3n5 3'NW<WVV^(NPn('\W3 33(3n5 3ϴ1P<~< $RPh{+޼RD<LQb$Sh< '޼R <LQb$Sh;  <RR1KR11]{"D<ML$Rh;  <ML$Rh; LR-RN KM zPLK
(LNM<VV]Q 1V<S1 VS1 zN(ʕP
N(ϧPNXZZXYQ..Y[L,,[*<XWW^nW(NPg(N<YVV^nV(Xgf(Z<[WW^nW(Yfg(.S<*XX^([gn(,N*VV V(VnPV RRMMRVRN(ROc< Nϋ<<1by1y181OW(WX<XVV^((rn(WQX3 33(3n5 31 <S'CyN(P4N(P%yN(3P
N(PN[޼XhYY[Z<[VV^nV(NPf(Ӕ<ZWW^([fn(YZ3 33(3n5< 3T$RhhN9 x1(D181^xN(ϹP
N(ϣP
NZQ8PS'R 8 Z'YY"Q4PSR 8 "[[ <ZWW^nW(NPg(
ϒ<YVV^nV(Zgf(')<"WW^nW(Yfg(X<[VV^nV("gf(< WW^([fn}( 3 33(3n5 3D8 Ϟ^QY^޼[޼V fkYQϱ|7 |~fkg7 ɀX7 dvkWWXXZ<XVV^nV(Yf(W<ZWW^(Xfn(8Z (n Hv1 VVXXZ[[Z<XWW^nW(Đg(V <ZVV^nV(Xgf(ϟ<WW^(Zfn([ (n ϼϞ^Q[sV^޼S Kϙ߭6 }Pݦߦ߭ Ѧѣ|! <<}УRR<}  }R 	  tRoh\u5 ЫRТWgYYZ<ZXX^(ώn(YZ (nЬRߢ ԡ[5 PϞ^\|5 mQVЏ   0^޼[k(k~~d  P1R,2R~4 fskXXY	YZ<YWW^nW(^g(X<ZXX^(Ygn(	&Z (n Ϲ1 ])4 4 1L~}3 3 }S2SRR Rs3 xs3 3 {rkXXY	YZ<YWW^nW(tg(X<ZXX^(Ygn(	<Z (n џ+(+Ԙ Ϸ3 Ǟ^pVW޼Y޼X޼Z
ƴ3 iS2SRR Rƴ3 ƴ2 	hW1IϗT-T   	jhW1&-T  }T-T  χH-T  c<-T  T0-T  D$-T  7-T  )-T  hW1 -T  H-T  "<-T  0-T  ܋$-T  ˋ-T  Ͼ-T  ϰhWb-T  ϛ$-T  ύ-T  ~-T  nhW*-T  Y-T  K-T  <hWW1dϞ^QZn[^z1 ޼Xh	p1pq&p|~ @ 	Џ  vV"ʜ (ʞ V (~vl^p&bpWVpWIpWWR*p,.p&ppRpRR ooooYRWVppoooooooo޼Rb(ͮͮͮ(ͮͰ޼Rb((͘͘͘(͘͚͂͘͂͂(͚͂̈́VWVYUTSRR~S~T~U~V~W~͂ͮ. Q޼Rb(h(nv  ʀ(. Nh޼VfX+XY<YWW^(+in(XY (n -^QW$kV޼S K߭. }Pݦߦ߭ Ѧѣ|! <<}УRR<}  >R 	  5R0h#(#φЬRߢ ωϦW- PϞ^|q- mQW޼Rb(b^]
(~~d[  P17l%* Ϝ*
lo, kV, wl%' G'kA, k(, Ilk%1 1k, k+ k1wl%. y.mk+ `k+ k
ckRR[w  B[Y2YX<YVV^nV(f([X fXjT+ j;+ j1 [YYZ<YVV^nV(υf([<ZXX^(Yfn(hZ (n FiX<XVV^(@n(X (n +(+ ߖϞ^QYg[޼Rb(b^
(χ ~~d/Y  P1]i	jUUi	
jTTi	iSSti	iRR`i-odRSiTU Bi~
6i~ /i~n)  dMhW<WVV^(Ɓn(W (nd }h1 nWWXXZ<XVV^nV(Pf(Wkn<ZWW^(Xfn(1Z (n hW<WVV^(n(W (n Ĕ+(+Ǎ Ϫ^UX޼WЧVfT-T  Y1 2TQQUQ1 EPPRR"'PRR<RTBdSR RdHXBЧS2cRUR2E>)PRR<RTBdSR dUXXUUQ1z޼SRbcbcb(b TUU6޼S2cRTR*D	D~xDTUU2cRTR@^QV޼RbVQϘ d9l (qlfVQϙ^QW.dV޼S K߭(' }Pݦߦ߭ Ѧѣ|! <<}УRR<}  mR 	  dR_h #&(&j~ЬRߢ χ!(((~ЬRߢ dW[& PÞ|^|L& mQWBcX(U {wY^|]- ii  ҋ*i ih(hhR:6{hhP<hRPRRY.YRRh hh(hhhh(hhxhR<bSbUCeTS RRRRe(Rz    >hS2S͇4h͋ ͇  |~|~ H   "% 1V ddc	c	c
c
cjcccc	cclwcljck^ck
Qc j cM# 2cj )c%Ѧ&͆(&y͈|~͆ϴ
b&Ѧ&͎(&x͐|~͎φbbb bb bbb	b` e# 1Lb" 
 $z
3b" S2SRR Rby" b`" aS" 	 y	aF" VRRR wa" 2RRR Bra!  1  
 ) D _ z 1  yba! 1  yFa! j sy+a! O %yau! 4 x`Z!  y`?!  +y`&! U̀<UTT|^nTQ̀P2USdR \!  d`  u`  	 v	\`  Q`PS͂R ! 2͂S̈́RS bS&`  `r  `e    w_S   w_8   
 
w_   w_   w|_  /wa_ T_   }v6_  v_   &v^b  v^G  	 Kv^)  ev^ ^  l u}^  zub^  k ;uC^  u(^                                                                                                                                                                                                                                                   3                        Y $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                          "     U         j t	^n  t]S ѦF]4   `t]"  Vt] ] ]   B   Ǟ^QV[Z޼Rb(b޼^
( d 'K  P   1   1 yƀ
(ƀƂdJ  P SRS (B ~ dK  P !~ dƀK  P   p1 hX)XY<YWW^()qn(XY (n Ϟ+(+ϡ τ2RRR (   ƀ
( ƂϞ^9YZ^[r[[޼Y f[i KhiW$WX<XVV[^($pn(WX (n ϞZ1 Z`WWXXY<XVV[^nV(Gpf(W<YWW^(Xfn(pY (n *oZ`WWX	XY<XVV[^nV(of(W<YWW^(Xfn(	oY (n ^QWWV޼S KϤ߭ }Pݦߦ߭ Ѧѣ|! <<}УRR<}  @R 	  7R2h$($nЬRߢ ϝ W P ^| m^4]޼VfYR:YP<YRPRR,YX<XWW^(;nn(YXf ff(fnfS2Sަ߭ }P  Ϟ^^޼WgV-V  0 Xݏ Ϯ1]-V  
1Mg߭z%V1&VVg- 1 R:mm
P<RPRRHY<YXX^(n(3mY (n|~ϑ1ZZ[[<ZYY^nY(i(l<[XX^nX(Zih(<YY^([hnO~ (n|~1&ffV- fR:fl
P<RPRRH޼RbX<XWW^(bn(,lX (n|~ϊ1 ޼TdU- UvUYYZZ[<YXX^nX(Uh(k<ZWW^nW(Yhg(<[VV^(Zgn>}[ (n|~ݏ؀ [ݏ؀ N <V1S1SXh1 R:;k
P<RPRRGRRW<WVV^(Rn(kW (n|~_RRY[[YZZ<YWW^nW(Rg(j<ZVV^nV(Ygf([<WW^(Zfn| (n|~ށhXh1R:Ej
P<RPRRFRRW<WVV^(Rn(jW (n|~iRRYYZZ[<YWW^nW(Rg(i<ZVV^nV(Ygf(<[WW^(Zfn-{[ (n|~ϞΨ^Q[Ͱ^ͨ޼ZjV-V  z Tݏ -V  yz1|j߭kY1Wͮjͬ-ͮ ͬ1 i1 Yk kS1jWWXXͺR;z(vRЭ({h<XVVͨ^nV(f(W<ͺWW^(Xfn(@hͺͽ ͽͽ(ͽnͿ|~ͽ-ͮ ͬ1 YRikR R1jWWXX͸Ry(uRЭ(g<XVVͨ^nV(f(W<͸WW^(Xfn(g͸ (n|~YT޼R- bd
TͰdT޼W- g1 ddݰݰT R1"gYYXXͶRx(uRЭ(f<XVVͨ^nV(f(Y<ͶWW^(Xfn(fͶ (n|~=~ݏ؀ Ϙݏ؀ ό yQ1ykR1qb1 kRj jj(jkRRSbkS %QjWWXXYRw(/tRЭ(f<XVVͨ^nV(f(W<YWW^(Xfn(eY (n|~Y}ջ 1G޼WkRg gg(gkRkR7 lPgYYXXZRw(vsRЭ(Ne<XVVͨ^nV(f(Y<ZWW^(Xfn(eZ (n|~| ^QSСRM\ 1   j$=v
iO \O ~rcO VO ~r̴z ̴  ^QQVLW}d    N N Ǵ ﰭS2Sޭ< 2<R>SR4c8͒i 2͒R͔SR,c0
H 2
RSR$c(޼ScT2Tޣ $,4߭dh   dQh]Q 9Rt(:qvRЭ(,b0u(0vwd uz1 |~d |~߭߭߭d@ нݭd  ]Q ϰyM
 Sѭ<}  5 pRM
 EM
 8M
 ͩ߭ ͩy   ]Q 8 ݧ @  ^QWJV޼S Ms߭
 }Pݦߦ߭ Ѧѣ|! <<}УRR<}  DR 	  ;R6h*(* aЬRߢ yW
 RRP 4^ЬR(b ݭr ݭr ݭrz ݭ~rZ ݭ^r: ݭ(
`ѭ`b`*߭QޭPSR 
 ,Э ;r 
QޭPSR  ,ҭ -pЬR(b x^| m]  1a    6߭߭ p   : ~ݭ ` 
%_߭h }Pn|~ |~߭߭߭ @ ЭRѢ1  	 2 [ 1  ^"J
 Jn
 1  d^I^
 IE
 1 Ϡ( ^I$
  I
 I	 N' ]'I	 tI	 &' _]'YI	 LI	 ݭ߭  ߭  Ǟ^FZ^޼Vfұ(((Ҧ߭	 MhfX%XY<YWW^(%\n(XY (n߭ pu^jFXUVSW޼TdS1޼P2`RVR#URR	Џx dRЏ dS1iVFRRRR   E ............. .......... ....K 1 S1U * 0 = 1VS1 VNHЏȀ dS1 S1 Џx dS1 Џ dS1 U    1 U1 Џx dS1 Џ dS1 URR	Џx dRЏ dSqU
 
   cU^SYЏ dSMU
 
   ?S:U5US-U
    WSЏx dS
Џ dSS1fU1VWR޼WR ( ,aZ   TTS2URRUTSSTЏ 1$2gRVR
FmV޼S2cRVR%RVRR (F7h1 hV-  	ffVW- W 
(- W s<~ PV	( 
(hfVh8<~T PV	( 
(fVhÞ^|TWC1UP޼S2cVTVU<TDRRRR " , , , , , , , , , , , , , , ' 
UUWUW1?WR޼VR ( 2fRWRR (GbBVUf)U&TT- T UfVfUfURSRS-R S UU1 W1 R:oYWP<WRPRRЬRb(uY2YS2WRRSS   ݏ  1ЬRbXW W(WW RRYYRWRh(RcЬRbt^QTbAR޼S MKj߭Z }Pݢߢ߭ Ѣѣ|! <<}УP ЬPѠ<}  \d  ЬPݠ߭  PϞ^| m@[#[(#jV]~ BB^<~eB B ~e˴ ˴  ; PKWRi(e,RW('U++(+,-|~+n   UP ,8U  @TTS2URRUTSTS	PP ,T  TTS2URRUTSTSOO3 ,WT  TTS2URRUTSTSiOdO ,S  TTS2URRUTSTSOO (i ͜͜͜(͜͞? ͂͂͂(͂̈́͂͘Ϧ͘͜ 8 ̀  ) ))()+ )]QϏ-̀͂  wf̀(R͂ ̀]QbͲ
(ʹR:UͲʹ
P<ͲRPRR!RRͲͲͲ(Ͳʹʹ<ͲSͲUCeTSRRRRe(RpU H   ͲS2SSʹW S8  |~|~8H H  jQ-mj|e
>
  >  P`2dp   P	1 >   EQy>   f`>  S>   P:>  
 ?f
!>   P>m  =T  =G  <	  > >>(>>p U ߫dX  d=`   mRݫ` R\   \ x  l   
A(
jdA eχ] q+ &S2SRR R˴_  ˴H  ́ 1n m/ ߫4H  2Ы4Rii ijh qof=r1 ~~v0tt  1t"~t,=  t  =ti  q=#                                                                                                                                                                                                                                                   4                         $      ELN042.D                       I  
  '[SYSEXE.SEAS$WORK_0000005C]DCMATH.EXE;1                                                                                                                      _            Vf%`_Nf}O7$Z~<a*j-{^;c!μbd/GD1lk!"'T ԥLAXMix Jl͹ɘwŬkF2&_Yu9LIjGDI.1_hjV?2?O5!ZE0xD!(YG7ԞD gD'4+aä-mw3U{?nJfQ;](̱֜Pr'e=ݤVǌӀ|g	Ȑ[ߢTƩ! B pojQ%CEU3i̳z`ApSבGFvTa%,_uA<SļV4o_gS׸:}UlC$U.Q0T>-F	5l^+Ԝt=@]bzxd1y$s KaGi5ts9%6l!.XzvW{RBoj;ǀBmI6P$k2"Ǐy8oè7PN_DoE{H,g~}H2|U&G}1"-`mDKJ	٧G!SZIƟ@bq8W%ɱ(ʵ{R
˽:!#aOm(LؑKϱ}ಲV)T_FQ<N)[.riARY;y[jB2{2lxCTa`	YUQg:VY5"Wbl^K``Li2è^AѾ"D(Cegc6JN#ߖzz9%B-!A"&J	d0;tY
KCϹZ-5v=8(p(!IOP
'Bv(2M&4C+Gd)n31?nI洼%;oRIǀ>S^z\=Z"qcC@7io0;*mlPmwA0:]}}CY#O ӳ#em]ͯ96wj<	5K%Nʸ!td=H};^%c&h_Xu\	=R$hlK])=.8^?&Q<Y	?y4"&gEI_ ^^
cA[[5w"SϳxwבgB(?$c٧PBF:=@b+yWSpkҎ/%acj^ǵ>`t&%9sy'Bk2vPfLo-ȜjVrze߽IzgKHD¦ʀ2Csӥ
(X"kOh)>H1j?7/R0c.fY f,ZG!6a611L/"rb*O4#O@֤w&+`ǺxVƅ<NLqؓ3N 䘁&;
,G
8U7?Ğ>-k/ʟO2Ϊ4
i%617-T=be/6xe>/n\<3O8w ˼@]QC~7LͧFt\h/[nLGĕep?4*0N''Mo	E
#T	E~ŁWbtpI֖հB
U5 (_
p[cs{;1W
kN7.:BwMR=IWUo/2郝⁄,.WF90g
lC.%GBQw>8I(fs
qʫ	w9(G."h7m1őP[-olȾ-Ѓ/_ni9=B.LLͮ(ٷPW;P.35NjD^ 9MZ>TߨAn$q}SD#Sa,pEw^X
v'0Efe3[^I` He{ad/[7jOl%<*f@iuksE
g
kHt^,׌$
3G,)z<|u@
/<95P;oQB#!x⹱Qt(Y1~m8FI膷yBGM%ߺ nT1%Dռ; [{;3_H D2"$D#mx(x4%wŽy68_L":N`P..fD]h$b5Ǔຖ-5?i;̌͠ VbG+t8%3N'P[o
J 9<!dovm}]=Fo=|szк'"ϫ~}qr3[%s2E>~Z`43i_|A
A$wkߨ6M grNbK*El땗J*,?nݬ{}եӲT/^~9)sN2.oAH8!LZv@d魊FvXx0}z2+F#{݄Xj-Nkel6F
W;CsNNcffqn*fydR˶ه
3 (,a:oN5yEx^K4/߮j+τ㵅xqNPp!DdPjfϋ<YΈ0}lkvc9|VIh=g]^"A4PK)azLfA}dbRKџ?5J@ WqrlAjI'B%$#IF#GېQ2L踁!a{ ZQ{ eKKqʰQfv#Kn˱;3ͪ,QJ̕˙'6.n狼2J:3`v]
I~f}n{t4h<N
9wsޖe
lp!QVH!dKF3y&1&Lg	rBٓX8Q;`8'-`?z5 A1[wIL kyl{ZvZjw>]@lzeiaqMm&tL738k<\Qe=R<	fv$7]R~a8랊
BwgNOmwD?4wB
d3K42]UKeͩ_'lTU}^8[Y 8Ls̀^vڊLFf<㸾ezљgت͢EW:-&4HccQ12ةfL27l?QXܾ<3T&"Npo(X&~I+yX^s/FT;OlK*j@(!_+a8<UABQN>8Aۀ?)ϰ~!q7}ד=cؕn_Ͽ@ATLGm۸#|ЁEDp-|V֪ UL30-G!h=D28'*:nLr> T_UV'ɤp	-rE]v)qy3"zhRpVCj|c\%.3K1Nr.qIiG<ݹDIS4lgzh4[K@4zdB(Ì?sZV3d:'+Hn	:qdûxhHY\:Y{ 6	xlvL:&{B#.lw{?s͉/)km,v)ly} /Da^gk5n%ќ߃.@/qjވ>*6*u|Q
IFPqg,7"Wc-${EyVc;.nynĮES!E8K
m䥓6~2[/Jz?cA/leݴ[G'}fZ=(LؖǄrVJ̚:#pMNUc^'+>ywA~C{^#|b({3v=1eʌ1 6L܃"E@Sa{<2cUjrǚ;\ca5]3ȺRz.`C@\#j#{ -sQO"`2_.#g$\^yR+q89z.K@_>B#Y)0m6-Q/;C ZYKIp \j&C+z!UE/#E#܌ۭDZQzb%.rXqɌW|s0_YS	BM3H;DC>~y%+
@Fދ|qsȳ&9p	3 RɕxY@.N=P͝y+.8Ǚi!|\'$+ڎ7_I=9Fd촲HlH̈́Na%i0FҜ%`S	Ӵ@sM?7f˾Ze^mOWNoR ϐ^4&0Φr5G͕iNޫkhܯG"&]? 
DC% 4O%_.W.$3
h'!kO
L-|
y\o׊)(J0ٝ`ڬl
bdv>Ə /a=V5;iڢN-$1l0"9Ja`q׿COb;pRnm-S!R Os8+kp[*^sk:	^0C+VղWVm@|{SdNT֚/8;65"xȊʇԾQ
*8"{1{x:G*i	/}UX$UnYhoL߭RdM/`P8+pȔ@JHx } `qޅ[S`
 Ԥ@")g1Zxԟ1WZI(
GȆ!(ˮ1ft:XnM]by0[!eLl.Ngmcc-H+Sٹ->um&0-[%EJGĝo5yxkjZ\J)w䕋yg}l[G`y qMfW%#@4>uHY5oae\)eLa1LHxEZ
"`J\BD[[rh{ƛɕ@lrK
`etॹ1eᤴؑ#}hd(T?U!(2l:lu9%*8}UVyTFI9J/{}â^%W.upeUW6LH})ؖ(>Ǘ$\z]KhH'1IZa{	sr#хaϻKLzFT3fǹL݃˽g[sR0۟WRlߕuʺf~b5ErL	-Y$<Zt[5LZuxMA5;~S=hUtܔm։מ!'$DĘMtG
u~ks\
 b^\j4z=?9⣶$'TLI^5˲3OxST3
U7{VWTKϠ~7a*u74oΓx>MlQ숐Әu9Un(>gq M*ct{F%ӝxR,+I^DfS"W{s5y-Dl?$
Q "ix* vc_+iX3A4j\M~09'U3KyOM0)pEMu؇5|\
HkjEF^['B֠H3smeTs!=j=W
z̖鱦}So")Aaw@n|eXO^v~V~f$UZ7ހ
!9m\xh;%(Qޢ<uN*P䛹4TɩqׄFfdj{X+>dr]ƨY%<*9BQG7<~J*Gt>Ġ"u>NYԸ-tU{Zd^
L|b \7MV01mA{_iZ:qBCyhdZfJb/=gor'm&o KQ_ٴ ifKomɝA׃u354eo`5[Kci%Λ"Z/z=a( ks@FP7Z]߲=Cӧ3CQB1*jDaͲ\֥y%_Y``xe=[ZQǩ chLGȡn,hG{mT3I+]ȸ+GN==2`+N!N]-_JT]R${S.Z6ȗD3NX.NbP͵g^R <%F	Q/kNܮ$8j񪢩UUKi"AmPESYT@c!
C3$74WJLe{Ӽ65k
 k.oI@&&O:\Si smxLE4E&gP8IfhM4M32mQ9KR&Ipe3JMP袉:Jmؿ+Sӧ#}AI̴Pqt;04$3S
14SP3Y~L!	`g7˟!fGnݔXX2UwE,x9W.58>0햼p\vÇiOa_LuXub@cJl$1<X␑iLJ#LkޑoMi4zcL
!ѵƂ	0x9Sh_@ߪ#1s
HOy"){2ifgj./z!q&P.Ҝy?DQՉ~Xa-<؈ro
egvw7qQr\Vg!b7x5۞ơ-G9(͜:aw5FľaLwE#fkT	eW%_RsA?}qrꌙz**oTˣ/ǡaW}xhF1IHI}fͽXM~_6", O\]bNUw3&߹0-Ҿp3ȂC
{,R+7VǨ{^F:Lmֆ>)
iͫK.HAZ(%||.LޯSayc*+,iIf7P -`k5.j ?-WWz:7?<*[qQsU9Gkk9hA_PHK-|`Whrᳮt3M:pm5撞mQyjJ I;S M'q 8DMP^mGG)0St$N.ƠΑD.st_F.N"3L
So%w}sٻ_pWMAd_IOݍ_XNͳxZPnə'EZ:-OobvةT:<JUv$"	oJ 
	A}BBZW78LC$8~=)a$fvOٶr+Rα,A)	h<A0UK햹C/D{ً/ul68fwI9FFBd'f
l鶇
sCy]\Ib|ж[O~(ͧ{|9;cpDWs_PU}ͯլ*<y̥ &Ƃ@R:aSt3ZXfy+hh<B\(^Co@1y춤ݹ3f0_'=*_^YZ#P\ev|AE
"2K~[Ɉ|Ъyxx{
j/	0?@
6@BZW/ 3[+`íVω:E-'OA̒gD,`H
g߳eo^Q*1We{ mf2IR5>S2ZIڦz(VejoO=9a"ڪQmܷ> g                                                                                                                                                                                                                                                    5                        r,? $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         ^ "     f       BZ(B rN\|~Zh q8 B0<S2SRR <R;B  ;)   q!<<1`́o qPj<Gc<
`:2T<RRRJ< A<7<(1</<)<́ q<́́ gP́́1	) q#BZ(B ZM\|~Zg q;<(;;<;k;,;~;d]Q:d a;]Q=S;  Pd :1WR1a(]RW(>\LB(B |~f:V192:RRVRRW,V  ;?@$BF:TTS2WURR;UTSTSi :V9  S:R Bf:9  \~t9  g9  ~-WF+:  _m U;9  2:SS9SST9RS B9S9l  \~8Q  8@  d1
 91
 81
8 / V
  hD-Ju 
1'
 p+8^<]QϪ1W
M<]Qσ1F
	([	9]Qҝ1"
 p=<]Q]1
	(O[	8]QϏ1;]Qϊ1 p+7;]QϦ1;]Q˹1	(Z	l8]Q)1y pi;]Qϐ1b	(Z	18]Q1> p.;]QϤ1'	(sZ	7]Qϳ1 p1 #7O:;;;(;:=;(=]  9:;;;(;:=6~;JA  1bhT:W-WX<XVV^(-CHn(W9:XZ ZZ(Zn\ Zb1
	(VY	6]Qϖ1
 9]Q1
9[8  1
h[W3WX<XVV^(3fGn(W]XZ ZZ(Zn\ ZIb1b
 pV:L9]Q51E
	(X	6]Qњ1!
 p9]Q1

	(VX	5]Qϖ1	 p8]Q=1		(X	5]Q[1	 1	 p1 4Q8;;;(;r8=;(=   278;;;(;!8=|~;,>  1	h7W'WX<XVV^('En(W7XZ ZZ(Zn\ Z`1	(V	~4]Q;1 q2Z(2D\|~ZM`1f \1\ pP8F7]Q1?	(V	4]Q˘17]Qc1
036R6! !!(!b#	  (    ^ j   1!]Qq1 p!C1	(U	i3]Q&1v!E1j2͜ 8 1M!]Q=1>]Q11W2 6R6" ""("b$
 a  2 %G  81 JC1I  ̀S2SRR ͂R1*  1  1"# ##(#$% #5 2#RB$G RR# ##(#%%ޟ0 Z0 ZZZ1#"$$$($& ! "$)"%&!!1YO~ AO~0"  0	  O~ ]AO~0  0  *RR2$RRRRW$\\ \(\&F\ RRWWR\RD(R@c$ O  (O̟ɰVDV\<\WW^(DFn(Ṽ\ \(\nF\ RRR\RD(R\@c(Tt  (T̟ϙȰWDW\\Y$Q$PSNR =  <\VV^nV(DFf(W̃<YWW^(\fn(?Y\\ \(\nF\ RRNNR\RD(RPcDS2SRR FR.`   {?.G   4
 1 Q+PSNR   2NSPRS bS.  	 ?	.  Q,PSNR <  2NSPRS bST.  G.  jZjZZ1	+Z(+u>\ ZZ1'Z('">\ ZZ1"]Q!1   ?-  D   D-  x-  1Z߭|~ @ T  (U氭V,N=  ;ATTS2VURR;UTSTS%2VRRRRR(B柭4  (5VTTS2VURR;UTSTS%2VRRRRR(B	 t<	_,  S2SRR RB,  ,1,  S2SRR R,y  ]~,^  +M  1  ]Q\1  1  p/]QͶ1 	(N	y,]Q61  p
v/_s	(N	B,]QPWR-R(N-RW(&&;*,(*-.|~,Wd	dḰ q8 3*X  S2SRR R˴I  ˴2   qV 0N hHt  q}+*  S2SRR R˴  ˴   1 n1   ͜SSXX\2\Y<XWW^nWgR;(S͞<\VV^nV(Xgf(9Y fY
*o  D   D)J  )1   qt   \d  Hd   2
ݫ4o  Hd  d  P< , b  r) *>-<.)x/v0t1r2p3n4l5j6/,/h7RS<c<Tcc)6  >  b  )())))
))>)sP9(AբЏp PcAcZ!(PwЏ PC>Џ P5e(	\(#ЏP PЏ  P(Pя PP(բSQ2(QâQQ AcQQt(  (P  'P  'P  'P  'P        լѬ   Џ (P  ѬѬ  Џ 'P  ѬѬ>  Џ 'P  լѬ  Џ 'P  ѬѬP   Џ 'P  Ѭ P  Ѭ ' (Џ0 d'&&Џ8 G'  D'@'2'&+'&Џ@ 'P  ʬ &  ʬ &  4&  Լ   _&]&  _&P  &
Џ  &P  /,)
 	P %%9%%ЬP%RRPQ AbQQ.&%%/&q)o)a(ݬ WU)C&I)P Ь QQ3xQRRw%  n% x3 QQ[%  lQЬ Al  j3C% Џ   !%K%R3S	TЃT| %RbЬQbVFbPQ`(`P| n%RbbЬQbVFbPQ`(`PЏ +%P  $$  $$  $$< }PP(!E*RP(PabPЏ $PЏЀ $P  lQAlQЬA$< }PP!&*RP(PabPЏ $PЏЀ z$P    )#  )#  )#  )#Access Cntrl List:  <Unknown> World: Group: Owner:File protection:    System:Non-spanned, Non-spannedNoneEmbeddedPrint file carriage controlCarriage return carriage controlFortranRecord attributes:   bytes, maximum Unknown type = Stream_CRStream_LFStream byte headerVFC, Variable length byte recordsFixed length UndefinedRecord format:      , Directory fileLockedContiguous-best-tryContiguous                    , Extend = Allocation = File attributes:    IndexedRelativeSequentialFile organization:  <No backup done>   Backup:   Expires:  <None specified>   Revised:  Created:  Owner:    [Size:           File ID:  <Unknown> (], [  <None specified>/                               Ϟΐ^޼͐^͔޼Y<Rթ$ש$R{  (ԭܰV,  UUS2VTRRTUSUSU2VRRURRڱ(EۭܟP  (ԭ氭VUUS2VTRRTUSUSU2VRRURR(E
 1޼VfWW72WRR R.    ͲͲe
	fZ
1, σ Qީ$PSR B  ͭ(ϭ 1 vn1 czQީPSR   ͭ(ϭX2XRRRRRXRW<WVV͔^(Rn(XW (n	~1 X2XRRRRRXRW<WVV͔^(Rn(XW (n	/1 W2WRRRRTWTXXZQީPSR   Z[<XVV͔^nV(Tf(W<ZWW^nW(Xfg
<[VV^(Zgn(ͭσ[ (nϝ	_SyRRѩ4S ѩ0R(ϟj20  Ry(ÂͰ(ͲͰ61 SSXXZͦͦZ[[͢<XWW͔^nWgR(S܂<ZVV^nV(Xgf<[WW^nW(Zfg(ͦ<͢VV^([gn͢ (nϔ
d Ϥ"  T ߭	T߭϶	T߭ϧ	T߭Ϙ	)p  c  ͐"VS2SU2SRR XR=  #޼ScT2TU2TRR R}  UUU!URRSR RV  UUURU U4  UR ϯ   m    Qީ$PSR A  XXZQީPSR #  Z[<XVV͔^nV(f(ͭσ<ZWW^nW(Xfg<[VV^(Zgn([ (nϬVVXXZͤͤZ[[͚2͚͜<XWW͔^nW(hg(V܃<ZVV^nV(Xgfς<[WW^nW(Zfg(ͤ<͚VV^nV([gfY͜ f͜e  X  
 
A  SyRRѩ4Sѩ0R                                                                                                                                                                                                                                                   6                        XϜ $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         j "     w        |  &R0   T  
 z
=  SyRRѩ<Sѩ8R @  &R8      Vo  ݩ,]  )L  ?  
 ϰ
(  SyRRѩDSѩ@R c  &R@   ;  
 :
$  SyRRѩLS,ѩHR&      3RH[   `  S   ϓ<  iR&
 m
   l  OR& :Z  A  $ 
4       
 ϱ
  ݩ   }k  <
RRV  I  
1    
 
d   H   Ϣ,   v     >  RR  + q    1
	 	W  1
 
=  <RR(  
 ϥ
v  1  |\  1  ]B  <RR)   %  w   ^	 	  E	 	f  , ϚM  RR8  <R[RRR
 U
w  <RR^   #K  2  
#       Ϲ    } {   F_   "C     $  T &
 
 e  L  3 ϝ?  &  
   O  T ߭ϯ  "  T߭ω  [  T߭d 6  T߭?t   zi  P  C   ޼RRPxPPPR~!  RPxPPPPW~   RPxPPPPE~  RPxPPPPD~_  R,I  Þ^޼Rb(b޼^S2SRRRRWSWY2YX<YVV^nV(Sf(WX fXD  ":Ϟ<^޼@[D^<޼R, n 4b޼VYZfSR:SP<SRPRR^RT2SXTXRBJRWWXBY5ZT@ @(XWXXf ff(fGYRR޼RZbU, n t Ḧ́Ϳ͈޼S@~cH  P [<̈́RRc cc(c݈Z:޼VZfXZXY<YWW<^(Zn(XYf ff(fn2ZD޼R[DbH[PϞ4^޼8޼4HLD<^@޼R, n 4b޼VY[fSR:VSP<SRPRReRT2SXTXYB2PRWWX
BY:[T:@ :@:(:<XWXXf ff(fGYRR޼RbH1޼VfS1 ZYLR:ϭSP<SRPRRgRT2SXTX[BωRRWWX
BvY<LT|@ |@|(|~XWXXf ff(fGYRR޼RbH1F, n t P͌;͐Y81 [1 L1 ЏScRh1 hRb9 99(9;XD9SR:ϨS;P<SRPRRoRT2SWTWcB;ςYRVVWB<nXBDT@ @(;WVWW9 99(9F:;XRR"Y9P  P 1'[L
D4VVZ|, n t  :YP޼Rb  P 1 , n t P͌;͐\޼RV~bPg  PgYJ(t P:<͌RRR,Rݐ  :͌ , n t P͌;͐\޼RV~bP  P #HЬS<͌RRc cc(cݐ[<޼V:ZfXZXY<YWW@^(Z<n(XYf ff(fn2Z<Lq޼V|ZfXZXY<YWW@^(Z~n(XYf ff(fn[7޼VfXZXY<YWW@^(Z~n(XYf ff(fn2Z<D{Z9WWZX<XVV@^(Zn(W;X9 99(9n;[;L6޼VfXZXY<YWW@^(Zn(XYf ff(fn2Z<޼RH<bPHP ^(t ޼T޼ScTcRRc RRcRRc RRcRRc RRc!RR "RR	c#RR
c$RRcT RRR(RRR0 $$(,                                                          /*Additional information available:                                Information available:Sorry, no information on              F                              (^QW޼ܔ[ЭY UYSYNVm	  VTDU2US*VRS BSD	  7	  YVY"	{  YSSR ?d  SR I  XXAVVTD4U2USVRS B6S     XV  8  Y1 088  181S   K<  /  "{  ~8V\  8M  WQ;F  YQޭPSR   YQޭPSR }  YQޭPSR ^  X[FXYA~8V  8  XVVWQ
P[VX[XY[1 b088g  18K~8V^  8O  VXZ ZZRSR@   RSSZ1 Vz  YR   YR! P!  u  h  Y~WQϝO  Ϟ^QV޼޼QPSR   QPSR   1088  181 Vmm (o RR/'"RB4SR)SB6WWRSR@   RSSe^WHRB4UT-UD6 )UD6#W1 J/W<JSJUCeTS RRRRe(RW԰J[2[RR(ZSS/Z2VRRZ2VZS/9*RZYBX[WW((W(WLW(RRYYRWRh(RXc;*SZRRYCX[WW((W(WLW(RRYYRWRh(RZc1~8V   8  1P ^QV޼Z[JZQޭPSR Y  ZQޭPSR :   1088  181VYY1RRX1[JW2WU2YTTTTSSSURRN   (U LUJ  1  JJ1 Z(<JSJUCeTS RRRRe(R6ZXX-W<JSJUCeTS RRRRe(RϟXW2VRRRW<JSJUCeTS RRWWRRe(RZ12VRRRW<JSJUCeTS RRWWRRe(RZ2VXXX/XRRW<JSJUCeTS RRWWRRe(Rܤ1XRRW<JSJUCeTS RRWWRRe(Rܤ1YRRX[1Y1qZ1iX$1][1W2JTYR2RRRRSSSTTN   3JS2SRR LRz  a  JJbZXX-W<JSJUCeTS RRRRe(RXW<JSJUCeTS RRVVRRe(RX*<JSJUCeTS RRVVRRe(RX2VXXRR.XRRW<JSJUCeTS RRWWRRe(Rܤ~XRRW<JSJUCeTS RRWWRRe(RܤPVRRX4V-XRSR@   RϬSSRRX 1E~8V  8ؿ  1$JT-TL  :'2TRR LRaƿ  T  ^QV޼WWQޭPSR    1 088H  181 ~8V<  8-  VXT TTSRS@   SϠRRS/WRB6cTRR!1r 1jWR ϯoԾ  WRVS2SRR XRL  ?  1TtVm"{  WR Ch  WR! ϶!M  4  '  W~VQ ^޼P2`QQKUETTRSR   R-SS RRTTRR<RTBdSRP dQUЬRb bb(bQRЬPР4υR  PϞ^|  m޼Rb2(b4޼Rb3(b58Џ   <@D[[RB4[, { 4[W3V,#  5TTS2VURRUTSTSYr[m2VVV[WG3WY[RB4SYRRccc(cG4YWWVRRRG4TTS2RURRUTSTSY[3A[<[WG3ϥWY[RB4S23RRWRRccc(cG4[^[YWXWVF4>WTWR2B4STSRB5ED4RSSbbb(bD6XXX[W]2R42R~8s  |8u  [1 >8J  181JP   E  ,    ~8V   8  ]Q1X>8ƺ  181W~8V  8  X1 W[1 ZZWVZ~V]QPSW/>8Q  18WWD]Q9X$VWX~8V	  8  XW[1XXe[`[VVJW޹  WTDU2US*WRS BS\  O  VW>  [WX1{[TDU2US*[RS BSq  X  K  []Qϕ4  >8  18X[Y[WX1 >8  18x[RWRoWZZZ~W]Q0P0>8  18WXWWYY~8V  8v                                                                                                                                                                                                                                                   7                         $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         g "              W1lWXco  YR[VRVJRWWTDU2US*WRS BSC  *    VWX18ط  |޼R4b4
4 8   $COMMAND:                                                                                                                   <^޼Rb(b޼Rb(b޼W2VVVV(V{TDUURSR   RqSS RRUURRDUSRS@   S+RR1RS@   SRRRS`   SRRЏSWVTW|~ݭȟ #PW޼RWbWW 8 0^޼Rb(b޼W޼SY2cVVVV(V7TDUURSR   RρSS RRUURRDVTVW	W   ЏSVV W `PV޼RVbVV 8 <(^޼Rb(b޼ܚ~|~ ޼RPbPP 8 ^޼Rb(b޼X޼޼޼^2RBARR ߭  NW2W<WVV^nV(f} Эf|~ ߭ ߭H     1 (߭߭߭p  1 ЭV, n (fXX  ( H E޼Rb(Э%޼Rb(Э|~~ݭ ` |~  |~߭߭߭ @ нݭ         ЭPka800$loader|μ^޼޼n޼Rb(b<
~߭߭ p  ЭVЮfn	(
޼Rb		ޯ       ܟ옏~ݭ ` |~  |~߭߭߭ @ нح RRݭ                INPUT    a     OUTPUT   &1?JW`dkrx	)/:CHNX\gmr{$*8@KU`rx$.4ANR`ems$,16;DGR[`dlv{$*06=CFIMQUY]bglqv{"'07=CCOPYCREATEDEFINEDELETEDIRECTORYDISMOUNTEXECUTEHELPINITIALIZELOADLOGOUTMOUNTPURGERENAMERUNSETSHOWTYPEUNLOADALLOCATIONTRANSFER_MODECONTIGUOUSNOCONTIGUOUSTRUNCATELOGNOLOGRECORDBLOCKAUTOMATICALLOCATIONDIRECTORYLOGNOLOGOWNER_UICPROTECTIONHELPALLCONFIRMLOGNOCONFIRMNOLOGSYMBOLBRIEFDATEFULLGRAND_TOTALNODATENOOWNERNOPROTECTIONNOTRAILINGOWNERPROTECTIONSECURITYSIZETOTALTRAILINGALLALLOCATIONUSEDTAPENOUNLOADUNLOADARGUMENTSNOWAITNOSTANDARD_ARGUMENTSSTANDARD_ARGUMENTSWAITACCESSEDCLUSTER_SIZEDATA_CHECKDIRECTORIESDENSITYDISKEXTENSIONFILE_PROTECTIONGROUPHEADERSINDEXMAXIMUM_FILESNOSHARENOVERIFIEDOWNER_UICPROTECTIONRECORD_PROTECTIONSHARESYSTEMTAPEUSER_NAMEVERIFIEDWINDOWSBEGINNINGENDMIDDLEREADWRITEPROGRAMSYSTEMKA800TAPECONFIRMLOGNOCONFIRMNOLOGCONFIRMLOGNOCONFIRMNOLOGNOLOGLOGARGUMENTSDEBUGJOB_PRIORITYKERNEL_STACKLOGMESSAGE_LIMITMODENODEBUGNOLOGNOPOWER_RECOVERYNOSTANDARD_ARGUMENTSPOWER_RECOVERYPROCESS_PRIORITYPROGRAM_NAMESTANDARD_ARGUMENTSUSER_STACKADAPTER_NUMBERBI_NUMBERDEBUGLOGNODEBUGNOLOGKERNELUSERDEFAULTFILEHOSTNOONNOVERIFYONPROTECTIONTERMINALTIMEUICVERIFYCHAR_SIZEECHOEIGHT_BITESCAPEINSERTLINE_EDITINGNOECHONOEIGHT_BITNOESCAPENOLINE_EDITINGNOPARITYNOPASSALLNOPASSTHRUNOSCOPENOTTSYNCNOWRAPOVERSTRIKEPARITYPASSALLPASSTHRUSCOPESPEEDWIDTHTTSYNCWRAP5075110134150300600120018002000240036004800720096001920038400ODDEVENSPACEMARKIGNORELOGNOLOGOWNER_UICPROTECTIONLOGNOLOGPROTECTIONDAYTIMEDEFAULTDEVICESNAME_SERVERSYMBOLTIMETERMINALUICALLPROGRAMSYSTEMOWNERGROUPWORLD@Q      q    q   q   wq   q   q   Tq   q	   ^r
   \	
q
   qt   qh   
q\   
qP   _qD   q8   q,   u    q 	u   0W UuQ    ( &u" P /q z   j    U Z    oJ    _:    q*       uh 	Cqy ( . qe 
 ,)uE           |P      ( ,u  /q    ^    q       ( !q   "   u&h    	u	 q Qu / u8 q #uP   qu A   >s cu_ Q 9m1 s  * u B 4/q $q|   %[`   &qP   ') (   ),+   uh uh    x, ^߿uZ  0/q6 *+q   ,q    -q @  .   /   0   Խ1q_    2qS   3qG   4q;  5q3   % 6q#    7    uh 	<qr ( . q^ 
 ,)u> 8   9   :    uP   ( >u  /q ;q   <    =q   @uhh    @H  , &u, Z /q ><	?   @qs   A   ֻBqZ   uh 3  h? û  E  L/qR C  XAD  K   Eq@   F  *Gp     2H   Ix  J Kq`   L  ޺MqG   N  źFO   P   zQq   RH Sv Tq     Uq   Vq   WXq   Yu@h 	u0 q$ duX 	u q 2ʻuX 	u q  uX 	`u q Zq   [q
    \q   u^P 	u   qB ]q@   ^q   uP    	    	u q Ѭu 	u q QXu 	Vu q hLul 	"u\ qP Q u< 	u, q  Qu 	u q u 	u q xu 	Zu q ζLup 	&u` qT xu6 / u(8 q _q    `q   A uP &  N
q 	euh q auh   5.Z۷<
~    %[ 
/q
 bq   uh #t 
Tu  /q cq+   dq   e   f   juqh /qc gq   hq   i   6j   u%h S  յW {u $   ( Lu  /q k   	 lq   uh    b  %  J˵ (/q. m^nq   o    G   p   2t   qqh   r   S   gst   u   v   w3   xq   y      zq   }{'|       u>h /q0 }   ]    ~   H    q~   qr      β   uh 	~u q ( h>q N$,)uh 	uX qL |u8    #	u q q      uP 	u q ĳu   bya q   q   Dq   %         q   q   4 q	   fq
   {   SuP   R /q q-   -q!   q   q	   q   q    q   q   q   q   q   q    q   q  @ q   qy   qm   q]@   qQ   qE                                                                                                                                                                                                                                                   8                        Mz $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         Vs "               q9    t  $   q   q @  u|h qp 	&	u` qT 5p   6p   7p   8p   u q 	u q qp   qd   qX   qL   q@   q4   q(   q   q	   q
   q   q   q
   q   q   q   q   u e    q   	u q qj   q^   qR    qF   q:   u 	Tu q Q*un   yK y= -a    > /q qd      B$ qK   9q?   [uh    Ь  RyQ y5q Su[ 
x     ,b 
/q q   ē   fHqo   uh 	q yA   uX yu 	Yu q yCq Su[   y
8 y* u@ B  īy qe	   =qY   1qM    qA   q5
   0 q)	   q    q
   uP 1   -* BӫDuL z l/q, q   uh y  s u y  vK u y    f u / u}8 qq ucP   40 u8  // u H u    /I u    _/& u /| u u /Vu 	Du~ qr u`@ 	uP qD  u2X :ڦɦ[<]>.:*%;-" "Ҩ( " 
 ا,)u q Ѓ    zу   o҃   dӃ   YuJP 	 q6 ,p* )p ۥR   .W   !E   D    -:.ts.^[E,E]>>" 0("::="   "c                                                                              e   n  z        n  (   zn                        H {     @Sq   Sq  Sq  Sq  Sq  Sq
  Sq  8Sq   {      S  S  S   S6   Sf  (S  0S  8S"  @Sr  HS  PS  XSR  `S  hS  pS  xSf  S  S  S  S^  S  S  S.  S  S  ȀS  ЀS  ؀Sx  S  S8   S  S  S  S2   Sn  (S  0S  8S  @S^   S   S  S  S  S>   Sh  (S  S  S  @SX  HS  PS  XS  `S4  hSf  pS  xS  S  SB  Sp  S  0S  8S  @SP   {     HS  PS  XS"  `Sd  hS  pS  xS6   Sj   S   S   SF!  S!  S!  ȣS!  УSB"  أSr"  S"  S"  S#  SH#  Sz#  S#  S#  S$  SR$  S$  S$  S%  SB%  ȿS%  пS%  ؿSJ&  S&  S&  S&  SD'   S'  S'  S'  S'   S(  (S>(  0Sd(  8S(  @S(  HS(  PS*)  XSR)  `S|)  hS)  pS)  xS*  S<*  Sr*  S*  S*  S*  S4+  S\+  S+  S+  S+  SB,   {     Sx,  S,  S,  S"-  SH-   Sn-  S-  S-  S-   S.  (SB.  0Sr.  8S.  @S.  HS.  PS$/  XSR/  `S/  hS/  pS 0  xS0  SP0  S0  S0  S0  S0  S1  SZ1  S1  S1  S1  S2  S\2  S2  S2  S2  S23   Sh3  S3  S3  S3   S 4  (SN4  0S4  8S4  @S4  HS$5  PSl5  XS5  `S5  hS6  pST6  xS6  S6  S6  S
7  SL7  S7  S7  S7  S&8  SN8  Sv8   {     S8  S8  S8  S9  S29  Sp9   S9  S9  S9  S:   S8:  (Sd:  0S:  8S:  @S:  HS;  PSH;  XSn;  `S;  hS;  pS;  xS<  S.<  ST<  Sz<  S<  S<  S<  S=  SD=  Sn=  S=  S=  S=  S>  SF>  Sz>  S>   S>  S?  S>?  Sn?   S?  (S?  0S?  8S@  @S,@  HS^@  PS@  XS@  `SA  hS2A  pSVA  xSA  SA  SA  SB  S2B  S`B  SB  SB  SB  SC   {     S>C  SrC  SC  SC  SC  SC  SD   S6D  SXD  SD  SD   SD  (S"E  0SJE  8SzE  @SE  HSE  PSF  XS8F  `SjF  hSF  pSF  xSF  SG  SFG  SrG  SG  SG  S
H  S4H  SvH  SH  SH  SI  SBI  SjI  SI  SI  SI   SJ  S@J  S~J  SJ   SJ  (S K  0S,K  8ShK  @SK  HSK  PSK  XSL  `SLL  hSL  pSL  xSL  S M  SDM  SM  SM  SN  SHN  SpN  SN   {     SN  SO  SDO  StO  SO  SO  SP  S4P   SvP  SP  SP  SQ   S*Q  (SRQ  0SQ  8SQ  @SFR  HSR  PSS  XS`S  `SS  hSS  pST  xSVT  ST  ST  ST  ST  SU  SNU  SU  SU  SV  S(V  SRV  S|V  SV  SV  S W  S,W  SNW  SW  SW   SW  SX  S<X  SpX   SX  0SX  8SY  @S(Y  HS\Y  PSY  XSY  `SY  hSY  pS"Z  xSJZ  SvZ  SZ  SZ  S[  S6[   {     S^[  S[  S[  S[  `S
\  hSN\  pS\  xS\  S]  SX]  S]  S]  S]  S.^  ST^  S^  S^  S^  S_  ST_  S_  S_  S_  S`   S&`  SX`  S`  S`   Sa  (SDa  0S~a  8Sa  @Sa  S2b  Sdb  Sb  Sb   Sc  SPc  `Sc  hSc  pSc  xSd  S(d  SFd  Spd  Sd  Sd  Se  S.e  S^e  Se  Se  Se  Sf  SHf  Sxf  Sf  Sf   Sg  SJg  Svg  Sg  0{      Sg  (Sg  0S4h  8Slh  @Sh  HSh  PSh  XSi  `SRi  hSi  pSi  xSi  Sj  S8j  SXj  Sj  Sj  Sj  @Sk  HSLk  PSk  XSk  `Sk  0Sk  8Sl  @SJl  HS|l  PSl  XSl  `Sm  hSHm  pSxm  xSm   Sm  (Sm  0S"n  8SFn  .        SUCCESSnormal successful completion2        SUBSCR!array index value is out of range6        SUBSTR$an operand to SUBSTR is out of range 0        PRED the operand to PRED is too small 0        SUCC the operand to SUCC is too large J        TYPECAST6the target type is larger than the variable being cast B        CHARASGN.assignment of string not of length 1 to a char P        PAOCASGN<assignment of string of wrong length to packed array of char X        SETASGNFmembers present in the set source are out of range specified by target:        CHR,the operand to CHR is out of the range 0-255N        SUBRASGN;the source value is out of the range of the target subrangeF        	SETCONSTR2an expression in a set constructor is out of rangeJ        PAOC:a packed array of char is too large to be used as a string .        STRLENa string length exceeds 32767V        GENERICDexecution of a statement with more than one compile time range errorJ        CASELAB8no case label exists corresponding to the selector value:        ARGUMENT&non existent arg specified by ARGUMENT "        ASSERTfailed assertion R        	FINDFIRST>start index out of range in a call to FIND_FIRST_BIT_SET/CLEAR>        
TYPEEXTENT(corresponding type extents are not equal >        
ARRAYBOUND(corresponding array bounds are not equal T        
INTCONVERT?expression out of range for conversion to boolean or enumeratedT        	TRANSLATE@no translation exists for a character in the source to TRANSLATE>        NEGSIZE+the size of a dynamic aggregate is negative ,        	EOFNOTDEFEOF taken when undefined2        EOLN#EOLN taken when file at end-of-fileZ        ADAWIIthe first argument of ADD_INTERLOCKED is out of the range -32768 to 32767 H        ZEROSIZE4the size of the target of ZERO is greater than 65535 x        RECEIVEfthe size of the message received is different than the size of the associated type of the data pointer\        	PROBESIZEHthe size of the argument to PROBE_READ/WRITE is greater than 65535 bytes4        	INVTIMSTRincorrect specification of time ,        	INVTIMVALinco                                                                                                                                                                                                                                                   9                        Ob, $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                          "            rrect value for time>        	INVDBLSTR)incorrect specification for double number <        
INVREALSTR'incorrect specification for real number4        	NEGSTRLEN negative string length specified<        
INVENUMVAL'incorrect value for the enumerated type<        
INVENUMSTR'incorrect syntax for an enumerated typeD        
AMBENUMSTR/ambiguous specification for the enumerated type:        
NOTENUMSTR$string is not of the enumerated type &        	ERRDURFLUError during FLUSH2        AUTH_NO_PRIVILEno privilege for request&        AUTH_NO_SUCH_USno such user(        AUTH_DUPLICATE_duplicate user*        AUTH_UNKNOWN_REunknown request ,        AUTH_INVALID_UIinvalid UIC value 4        AUTH_NO_AUTHORIno authorization for user D        AXV_DEVICE_ERRO*device error - clock too fast for requestsL        KWV_DATA_OVERRU1data overrun - external events occurring too fast 6        DISK_ALLOCFAILindex file allocation failure8        
DISK_BADRANGEbad block address not on volume >        DISK_BLKZERO'block zero is bad - volume not bootable0        DISK_CLUSTERunsuitable cluster factor2        
DISK_DEVMOUNTdevice is already mounted 2        
DISK_DIAGPACKdisk is a diagnostic pack :        DISK_FACTBAD"cannot read factory bad block data :        DISK_INVCHRVOL!invalid character in volume label6        
DISK_LARGECNTdisk too large to be supported.        DISK_MAXBADbad block table overflow<        DISK_NOBADDATA"bad block data not found on volume 8        DISK_NOTFILEDEVdevice is not file structured 2        FILE_ALTHOMBLKalternate home block used:        FILE_ALTIDXFHD alternate index file header used D        FILE_BITMAPERR*I/O error on storage bitmap; volume locked F        FILE_IDXMAPERR-I/O error on index file bitmap; volume lockedH        FILE_INCVOLLABE-incorrect volume label, volume mounted anyway B        FILE_MAPHDRBAD(storage map header is bad; volume locked X        FILE_VOLIMPDSM>volume was improperly dismounted; please rebuild on VMS system >        FILE_BADIDXFHD%no valid index file file header found<        
FILE_DEVINUSE#device is in use by another process 4        FILE_DEVNOTMNTno volume mounted on deviceJ        FILE_FILESTRUCT/unsupported file structure level or ODS feature J        FILE_MLTVOLLABE0a volume with this name has already been mountedH        FILE_NOBLOCKSPE-device driver indicated zero blocks on device >        FILE_NOHOMEBLOC#no valid home block found on volume 2        FILE_VOLALRMNTvolume is already mountedD        TAPE_DIFLBLMNT+a volume with a different label was mountedH        TAPE_VOLNAMMSK.this volume's name is masked by another volume 0        TAPE_DEVWRTLCKdevice is write-locked <        
TAPE_DEVINUSE#device is in use by another process 2        
TAPE_DEVMOUNTdevice is already mounted .        
TAPE_DEVERRORdevice error occurred :        TUTL_INVCHRVOL!invalid character in volume label2        TUTL_BLKSIZinvalid block size specified4        
PENDING_ERRORerror in DAP pending message4        
SUCCESS_ERRORerror in DAP success message4        	UNSUPPORTnetwork operation not supported <        
PROTOCOL_RES1#Data Access Protocol error detected 0        FILE_OPEN_ERRORerror in DAP file open6        TRANSFER_ERRORerror in DAP transfer; error P        PROTOCOL_TRANSF5Data Access Protocol error detected; transfer warning :        ACCESS_TERMINATerror in DAP access termination \        PROTOCOL_FORMATBDAP protocol error detected; message field contains invalid formatP        PROTOCOL_INVALI5DAP protocol error detected; message field is invalid \        
PROTOCOL_SYNCDDAP protocol error detected; message received out of synchronization<        
PROTOCOL_RES2#Data Access Protocol error detected <        
PROTOCOL_RES3#Data Access Protocol error detected <        
PROTOCOL_RES4#Data Access Protocol error detected F        PROTOCOL_USER1,Data Access Protocol error detected - user 1 F        PROTOCOL_USER2,Data Access Protocol error detected - user 2         SPAREreserved         ABOoperation aborted (        ACCFiles-11 ACP access failed0        ACT!file activity precludes operation $        AIDinvalid area ID in XAB&        ALNalignment options error D        ALQ6invalid allocation quantity (negative or 0 on $EXTEND)"        ANInot ANSI "D" format &        AOPallocation options error:        AST,invalid (i.e.; synch) operation at AST level(        ATRfile attributes read error*        ATWfile attributes write error *        BKSbucket size too large (FAB) *        BKZbucket size too large in XABD        BLN6invalid block length error for control block (FAB/RAB)(        BOFbeginning of file detected6        BPA(private pool address not multiple of "4"4        BPS%private pool size not multiple of "4" 4        BUG%internal RMS error condition detected          CCRcannot connect RAB:        CHG+invalid key change in $UPDATE (CHG not set) (        CHKbucket format check failed<        CLS.RSTS/E close function failed (STV=SYS ERR CODE6        COD(invalid or unsupported type field in XAB.        CREFiles-11 ACP file create failed F        CUR8no current record (operation not preceded by $GET/$FIND)6        DAC(Files-11 ACP file deaccess failed $CLOSE.        DANinvalid data area number in XAB .        DELRFA-accessed record was deleted N        DEV?error in device name or inappropriate device type for operation &        DIRerror in directory name &        DMEdynamic memory exhausted"        DNFdirectory not found .        DNRdevice not ready or not mounted &        DPEdevice positioning error*        DTPinvalid key data type in XAB4        DUP%duplicate key detected, (DUP not set) 0        ENT"Files-11 ACP enter function failed2        ENV$operation not selected in ORG$ macro"        EOFend of file detected,        ESSexpanded string area too small2        EXP$file expiration date not yet reached.        EXTFiles-11 ACP file extend failed 0        FAB!invalid FAB or FAB not accessible L        FAC=record operation not permitted by specified file access (FAC) 2        FEX#file already exists, not superseded         FIDinvalid file ID 2        FLG#invalid key definition flags in XAB 4        FLK%file currently locked by another user :        FND,Files-11 ACP file or directory lookup failed        FNFfile not found         FNMerror in file name"        FOPinvalid file options>        FUL/device full (insufficient space for allocation) .        IAN invalid index area number in XAB:        IFI,invalid internal file identifier (IFI) value4        IMX&invalid duplicate XAB or non-dense XAB&        INI$INIT macro never issued@        IOP1operation invalid for file organization or device F        IRC7illegal record encountered (with sequential files only) <        ISI.invalid internal stream identifier (ISI) value         KBFinvalid key buffer4        KEY&invalid record number key or key value6        KRF'invalid key-of-reference for $GET/$FIND .        KSZinvalid key size for $GET/$FIND <        LAN-invalid lowest-level-index area number in XAB ,        LBLtape label is not ANSI format "        LBYlogical channel busy.        LCH logical channel number too largeB        LEX4invalid $EXTEND for area containing an unused extent6        LOC(invalid allocation location field in XAB"        MAPbuffer mapping error<        MKD-Files-11 ACP could not mark file for deletion H        MRN:invalid maximum record number or record number exceeds MRN*        MRSinvalid maximum record size <        NAM-invalid NAM block or NAM block not accessible J        NEF<not positioned to EOF on $PUT (sequential organization only)8        NID)cannot allocate internal index descriptor 6        NPK'no primary key defined for indexed file *        OPNRSTS/E open function failed (        ORDXABs not in correct order .        ORGinvalid file organization value B        PLG4error detected in file's prologue (reconstruct file)<        POS.invalid key position (greater than MRS) in XAB,        PRMinvalid file date value in XABB        PRV3insufficient privilege or file protection violation 0        RAB!invalid RAB or RAB not accessible (        RACinvalid record access mode(        RATinvalid record attributes $        RBFinvalid record buffer         RERfile read error $        REXrecord already exists 2        RFA#invalid record's file address (RFA) $        RFMinvalid record format >        RLK0target record currently locked by another stream2        RMV#Files-11 ACP remove function failed         RNFrecord not found         RNLrecord not locked                                                                                                                                                                                                                                                    :                         $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         o  "            $        ROPinvalid record options4        RPL%error detected while reading prologue ,        RRVinvalid RRV record encountered,        RSArecord stream currently active"        RSZinvalid record size 0        RTB"record too large for user's buffer6        SEQ(primary key out of sequence (SEQ access)0        SHR"invalid file sharing (SHR) options&        SIZinvalid key size in XAB ,        STKstack too large for save area 0        SYS!QIO system service request failed "        TREerror in index tree          TYPerror in file type"        UBFinvalid user buffer &        USZinvalid user buffer size&        VERerror in version number         VOLno such volume        WERfile write error,        WLKdevice currently write locked 4        WPL%error detected while writing prologue 0        XAB!invalid XAB or XAB not accessible *        BUGDDIinvalid default directory*        CAAcannot access argument list          CCFcannot close file          CDAcannot deliver AST:        CHN,assign channel system service request failed4        CNTRLO"terminal I/O ignored due to CTRL/O 4        CNTRLY"terminal I/O aborted due to CTRL/Y 6        DNA(invalid default file name string address2        DVI$invalid device ID value in NAM block.        ESAinvalid expanded string address .        FNAinvalid filename string address 0        FSZ!invalid fixed control header size $        IALinvalid argument list         KFFknown file found6        LNE'logical name translation count exceeded          NODerror in node name&        NORMALoperation successful 2        OK_DUP!record inserted had duplicate key<        OK_IDX+index update error occurred-record inserted.        OK_RLKrecord locked but read anyway<        OK_RR+record was inserted successfully in primary .        CREATEDfile was created, not opened$        PBFinvalid prompt buffer :        PENDING(asynchronous operation not yet completed$        QUOerror in quoted string*        RHBinvalid record header buffer(        RLFinvalid related NAM block ,        RSSinvalid resultant string size .        RST invalid resultant string address0        SQO"operation not sequential (SQO set)"        SUCoperation successful:        SPRSED(created file superseded existing version .        SYNfile specification syntax error $        TMOtimeout period expired4        BLK&nonspan record attribute not supported        BSZ
bad byte size $        CDRcannot disconnect RAB &        CGJcannot get JFN for file         COFcannot open file        JFN
bad JFN valud $        PEFcannot position to EOF"        TRUcannot truncate fileH        UDF9file is currently in an undefined state; access is denied 6        XCL(file must be opened for exclusive access"        DIR_FULLdirectory full *        	NOHANDLERhandler not in system (        	FATAL_HWEfatal hardware error0        
WRITE_BEOFattempt to write beyond EOF2        NOSUCHOPTIONhardware option not present,        
DEVICE_NOTATTdevice not attached 0        
DEVICE_ALRATTdevice already attached 0        DEVICE_NATTCHBLdevice not attachable 2        RESOURCE_INUSEshareable resource in use,        	ILLOVRREQillegal overlay request 2        BLKCHK_CRC_ERRblock check or CRC error 2        NODE_EXHAUSTEDcaller's nodes exhausted $        	IDXF_FULLindex file full (        
FILE_HDR_FULLfile header full,        WRITE_ACCESSEDaccessed for write 6        FILE_HDR_CHKSUMfile header checksum failure0        ATTR_CTRL_LISTattribute control list 2        FILE_ALRACCfile already accessed on LUN*        BAD_TAPE_FORMATbad tape format B        ILL_OPER_FDB*illegal operation on file descriptor block .        RENAME_2rename; 2 different devices>        RENAME_ALRINUSE#rename; new filename already in use 8        OLD_FILE_RENAMEcannot rename old file system (        FILE_ALROPENfile already open(        PARITYparity error on device .        
END_OF_VOLUMEend of volume detected$        DATA_OVERRUN
data over-run(        	BAD_BLOCKbad block on device *        END_OF_TAPEend of tape detected2        NO_BUFFER_SPACEno buffer space for file>        	NO_BLOCKS)file exceeds allocated space -- no blocks 2        TASK_NOTINSspecified task not installed        UNLOCKunlock error 2        NOFILE_ACCESSEDno file accessed on LUN ,        SEND_RECEIVEsend/receive failure <        SPL-spool or submit command file failed on $CLOSE "        NMFno more files found 0        CRC"network DAP level CRC check failed         EXQUOTAquota exceeded:        BUGDAP)internal network error condition detected8        CNTRLC'terminal input aborted due to (CNTRL) CB        DFL4data bucket full size larger than bucket size in XAB,        ESLinvalid expanded string length$        IBFillegal bucket format B        IBK3LAN bucket size not equal to IAN bucket size in XAB $        IDXindex not initialized F        IFA8illegal file attributes detected (file header corrupted)D        IFL5index bucket fill size larger than bucket size in XAB 4        KNM%key name buffer not accessible in XAB F        KSI8index bucket will not hold two keys for key-of-reference(        MBCinvalid multi-block count 6        NET'network operation failed at remote node *        OK_ALKrecord is already locked 6        OK_DEL$deleted record successfully accessed >        OK_LIM,retrieved record exceeds specified key value 0        OK_NOPXAB not filled in for block I/O:        OK_RNF(nonexistent record successfully accessed *        PLVunsupported prologue version.        REFillegal key-of-reference in XAB .        RSLinvalid resultant string length B        RVU4error updating RRV's, some paths to data may be lostH        SEG:data types other than string limited to one segment in XAB        SPARE2reserved .        SUPnetwork operation not supported $        WBEerror on write behind (        WLDinvalid wildcard operationD        WSF6working set full (can not lock buffers in working set)f        DIR_FNMSdirectory listing -- error in reading volume-set name, directory name, or file name J        
DIR_ERRFAT5directory listing -- error in reading file attributest        DIR_PROadirectory listing -- protection violation in trying to read the volume-set, directory or filename `        
DIR_PROFATKdirectory listing -- protection violation in trying to read file attributesF        	DIR_NOFAT1directory listing -- file attributes do not exist h        DIR_SKIPTdirectory listing -- unable to recover directory list after Continue Transfer (Skip) &        SNEfile sharing not enabled.        SPE file sharing page count exceeded:        UPI+UPI not set when sharing and BIO or BRO set ,        ACSerror in access control string"        TNSterminator not seen "        BESbad escape sequence &        PESpartial escape sequence 2        WCC$invalid wildcard context (WCC) value0        IDR"invalid directory rename operationF        STR8user structure (FAB/RAB) became invalid during operationF        FTM8network file transfer mode precludes operation (SQO) set*        	NORESOURCno resources available$        	INVALFUNCinvalid function*        INVALSUBFUNCinvalid subfunction*        INVALBUFSIZinvalid buffer size &        DEVNOTREADYdevice not ready2        DATAOVERFLOWtypeahead buffer overflowed,        INVALRECinvalid record definition,        
INVALSPEEDinvalid terminal speed "        NOMODEMno modem support@        REQUEST_OUTSTAN%a request of this type already exists .        INVALCHARSIZinvalid character size *        INVALPARITYinvalid parity type &        TIMEOUTtimeout has occurred0        	TERM_RECVterminator has been received4        FRAME_ERRORframing error on received data8        BREAK_DETECTEDa break condition was detected &        
UNKNOWN_ERROR
unknown error 6        INVALNAM#invalid node, port, or service name$        INVALTYPinvalid port type4        	LATACTIVELAT services are already active 2        LATNOTACTIVELAT services are not active$        
NOSUCHLINKno such link(s)$        
NOSUCHPORTno such port(s)$        
NOSUCHSERVno such service(        
LINKEXISTSlink already exists(        
PORTEXISTSport already exists,        
SERVEXISTSservice already exists 8        
MAXSERVICE"maximum number of services reached $        	NOSERVERSno known servers2        MAXPORTSmaximim number of ports reached2        MAXLINKmaximum number of links reached (        
NOMOREINFOno more information"        	NOSUCHDEVno such device$        	DEVACTIVEdevice is active,        ABORTEDconnection attempt failed :        INVALD                                                                                                                                                                                                                                                   ;                        j6B $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                          "            SKSIZ$bad parameter input for VM disk sizeD        
NI_EXCESSCOLL+excessive collisions - transmission stopped :        NI_PROMENABLED promiscuous mode already enabled P        
NI_INVALIDSAP7invalid sap value - even groupsap or odd individual sap :        NI_PROTENABLED protocol enabled by another user F        
NI_NOTENABLED.user has not been enabled in a connect requestJ        NI_INVLLCCLASS0the llc class specified is invalid for this user ,        NI_TRANSFAILEDtransmission failed.        
NI_ILLEGALCMDillegal command opcode2        
NI_INVALIDCMDcommand parameters invalid&        NI_INVALIDPTDBPTDB invalid 2        NI_UNKNOWNPTDBspecified PTDB is unknown0        NI_TOOMANYPTDBtoo many PTDB's defined,        NI_TOOMANYFQtoo many FQ's defined2        
NI_TOOMANYADRtoo many addresses defined@        NI_NOTUNIQUE(ptt/sap/pi not unique, when so specified J        NI_OTHERUNIQUE0ptt/sap/pi not unique, when another so specified "        	NI_LENGTHillegal length         NI_LONGframe too long"        NI_SHORTframe too short$        	NI_BSHORTbuffer too short2        NI_INVALIDBUFFinvalid buffer specified :        NI_XMTFAILNRSN!transmit failed - no reason given<        NI_XMTFAILRTRY#transmit failed - retries exhausted:        NI_XMTFAILLCOL transmit failed - late collision <        NI_XMTFAILTIME"transmit failed - transmit timeout :        NI_RCVFAILNRSN receive failed - no reason given @        NI_RCVFAIL802TR%receive failed - 802 packet truncated :        NI_CARRIERLOSS carrier loss during transmission :        
NI_ADDRNOTSET"address not set, protocols enabled2        MOVVEC!vector moved from shareable image4        OBSVEC#obsolete termclass vectored routine4        NM_INVALID_PARAinvalid parameter specifedL        NM_WRONG_STATE3network is in the wrong state for specifed function8        NM_INVALID_FUNCrequested function is unknown @        COPY_BADOPT*Contradictory or reserved option specified,        	INVALADDRinvalid network address *        NOSUCHENTRYno such entry exists        BADSTATE	bad state&        BADVALUEbad parameter value        LOCKED
access denied*        ENTRYEXISTSentry already existsF        INCOMPATVER/incompatable version - recompile/relink program &        	BADMSGLENbad message length&        EWOULDBLOCKI/O stream empty,        EINPROGRESSoperation in progress 0        EALREADYoperation already in progress2        ENOTSOCKsocket operation on non-socket 4        EDESTADDRREQdestination address required $        EMSGSIZEmessage too long 4        
EPROTOTYPEprotocol wrong type for socket ,        ENOPROTOOPTprotocol not available0        EPROTONOSUPPORTprotocol not supported4        ESOCKTNOSUPPORTsocket type not supported 6        
EOPNOTSUPP!operation not supported on socket4        EPFNOSUPPORTprotocol family not supported4        EAFNOSUPPORTaddress family not supported ,        
EADDRINUSEaddress already in use 6        
EADDRNOTAVAILcan't assign requested address"        ENETDOWNnetwork is down.        ENETUNREACHnetwork is unreachable	 8        	ENETRESET#network dropped connection on reset 8        ECONNABORTED software caused connection abort .        
ECONNRESETconnection reset by peer ,        ENOBUFSno buffer space available .        EISCONNsocket is already connected *        ENOTCONNsocket is not connected4        	ESHUTDOWN can't send after socket shutdown8        ETOOMANYREFS!too many references: can't splice(        	ETIMEDOUTconnection timed out*        ECONNREFUSEDconnection refused 2        ELOOP!too many levels of symbolic links *        ENAMETOOLONGfile name too long          	EHOSTDOWNhost is down(        EHOSTUNREACHno route to host $        EINVALbad parameter valueH        EACCESS6inadequate permission to access requested address/port        EPIPEpipe broken D        
DEVOFFLINE/device is not in configuration or not available8        UNSUPPORTED!unsupported operation or function &        BADPARAMbad parameter value"        MEDOFLmedium is offline(        CTRLERRfatal controller error&        	INVALLINEinvalid line name 0        	INVALNODEinvalid node name or address2        MAXLOADSmaximum number of loads reached.        	MISLINNAMline name cannot be found 2        	MISLOAFILload file name cannot be found4        	MISPHYADR physical address cannot be found8        MISNODID$node name or address cannot be found 0        CONFLICTINGVALconflicting parameters &        	ERRDURLOAerror during load $        	BADIMGFMTbad image format2        REQMAX!maximum number of requests in use.        	ALLRDYRUNdevice is already running $        NOREQno request available4        
BADCLKMODEbad or inappropriate clock mode SELN  K  (   @                        {            |  &  |  N  |  ~  |     |    (|    0|    8|  4  @|  \  H|    P|    X|    `|    h|  F  p|  j  x|    |    |    |     |  B  |  l  |    |    |    |  >  |  h  |    |    |    |  0  |  T  |     }    }    }    }      }  J  (}    0}    8}    @}  	  H}  8	  P}  b	  X}  	  `}  	  h}  
  p}  :
  x}  x
  }  
  }  
  }    }  F     |              .        SUCCESSnormal successful completion(        	BAD_COUNTbad parameter count 0        
BAD_CREATEbad job or process creation0        
BAD_LENGTHbad string parameter length"        BAD_MODEbad access mode        	BAD_STACK	bad stack $        	BAD_STATEbad object state"        BAD_TYPEbad object type(        	BAD_VALUEbad parameter value 4        CONNECT_COMPLETconnect circuit completed 2        CONNECT_PENDINGconnect circuit pending 2        CONNECT_TIMEOUTconnect circuit timeout (        COUNT_OVERFLOWcount overflow *        COUNT_UNDERFLOWcount underflow $        DEBUG_SIGNALdebug signal 2        DEVICE_CONNECTEdevice already connected4        
DISCONNECTcircuit disconnected by partner"        	DUPLICATEduplicate name.        KERNEL_STACKkernel stack not valid "        
MACHINECHK
machine check*        	NO_ACCESSno access to parameter,        NO_DESTINATIONno destination port:        NO_INITIALIZATIno job initialization specified 0        	NO_MEMORYno physical memory available<        NO_MAP_REGISTER!no I/O mapping register available *        
NO_MESSAGEno message available 4        	NO_OBJECTno object table entry available 8        
NO_PAGE_TABLEno process page table available 8        NO_PATH_REGISTEno datapath register available$        NO_POOLno pool available $        NO_PORTno port available 2        	NO_STATUSno exit status value specified(        NO_SUCH_DEVICEno such device $        NO_SUCH_NAMEno such name $        NO_SUCH_PORTno such port *        NO_SUCH_PROGRAMno such program *        NO_SUCH_SERVICEno such service @        NO_SYSTEM_PAGE&no system page table entries available 8        
NO_VIRTUAL"no virtual address space available ,        POWER_SIGNALpower recovery signal"        QUIT_SIGNALquit signal (        REMOTE_PORTremote port value *        EXIT_SIGNALprocess exit signal :        UNREACHABLE#remote system currently unreachable .        PROCESS_ATTENTIinterprocess signal F        BAD_ACCESS_CONT+remote system rejected username or password *        BAD_MESSAGE_SIZbad message size>        
NO_SUCH_IMAGE&referenced shareable image not present:        BAD_IMAGE_FORMA unsupported program image format0        BUGCHECKinternal consistency failure *        AMP_PORTport on another bi node:        THIRD_PARTY_DIS third party disconnected circuit6        NETWORK_STATE_Onetwork is in the off state 8        TIME_NOT_SET time has not been previously set &        	EXPEDITEDexpedited message 8        AREA_EXISTS"previous job actually created area.        
DEVICE_EXISTSdevice already exists 	   KERNEL  z  (   r  `                      8{     H! `  P!   X!   `!   h!   p! F  x!   !   ! "  ! L  !   !   !   ! 4  ! z  !   0!   8!   @! <  H! t  P!   X!   `!   Ї! B  ! j  !   !   p!   x! R  !   !   ! 	  `! 8	  h! 	  p! 	  x! 	  ! 	  ! 
  ! @
  ! h
  ! 
  ! 
  ! 
  !   ! L  ȉ! ~  Љ!   ؉!   !   ! <  !   !    !   ! .
  ! n
  ! 
   ! 
  (!   0! Z  @!   H!   P!   X!   `! D  h! j  p!   x!   !   !   ! $  (        	FILALROPEfile is already open&        	ERRDUROPEerror during OPEN "        	FILNOTFOUfile not found,        	INVFILSYNinvalid filename syntax J        	ACCMETINC6ACC                                                                                                                                                                                                                                                   <                        
. $      ELN042.D                       M  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.EXE;1                                                                                                                         $             ESS_METHOD specified is incompatible with this fileJ        	RECLENINC6RECORD_LENGTH specified is inconsistent with this fileH        	RECTYPINC4RECORD_TYPE specified is inconsistent with this fileJ        	ORGSPEINC5ORGANIZATION specified is inconsistent with this file *        	INVKEYDEFinvalid key definitionB        	KEYDEFINC-key definition is inconsistent with this file 4        	KEYNOTDEF key is not defined for this file*        	INVRECLENinvalid record length H        	TEXREQSEQ4textfiles require sequential organization and accessF        	FILNAMREQ2FILE_NAME required for this HISTORY or DISPOSITION*        	FILALRCLOfile is already closed&        	ERRDURCLOerror during CLOSE8        	AMBVALENU#ambiguous value for enumerated type :        	INVSYNENU&invalid syntax for an enumerated value8        	INVSYNINT#invalid syntax for an integer value 4        	INVSYNREAinvalid syntax for a real value :        	INVSYNUNS&invalid syntax for an unsigned integer6        	NOTVALTYP"item not a value of specified type*        	ERRDURPROerror during prompting(        	ERRDURWRIerror during WRITELN$        	LINTOOLONline is too longJ        	NEGWIDDIG5negative Width or Digits specification is not allowed 8        	WRIINVENU$WRITE of an invalid enumerated valueB        	KEYVALINC.key value is incompatible with this file's key8        	KEYDUPNOT$key field duplication is not allowed4        	KEYCHANOTkey field change is not allowed H        	CURCOMUND3current component is undefined for DELETE or UPDATE 2        	FAIGETLOCfailed to GET locked componentL        	DELNOTALL8DELETE is not allowed for a sequential organization file(        	ERRDURDELerror during DELETE &        	ERRDURFINerror during FIND $        	ERRDURGETerror during GET$        	ERRDURPUTerror during PUT&        	ERRDURRESerror during RESET(        	ERRDURREWerror during REWRITE*        	ERRDURTRUerror during TRUNCATE (        	ERRDURUNLerror during UNLOCK (        	ERRDURUPDerror during UPDATE 8        	FILNOTDIR$file is not opened for direct access2        	FILNOTGENfile is not in Generation mode2        	FILNOTINSfile is not in Inspection mode8        	FILNOTKEY#file is not opened for keyed access $        	FILNOTOPEfile is not open8        	FILNOTSEQ#file is not sequential organization *        	FILNOTTEXfile is not a textfileF        	GENNOTALL2Generation mode is not allowed for a READONLY file4        	GETAFTEOFGET attempted after end-of-file H        	INSNOTALL3Inspection mode is not allowed for a WRITEONLY file 0        	INSVIRMEMinsufficient virtual memory @        	INVARGPAS+invalid argument to Pascal Run-Time Library ,        	LINVALEXCLINELIMIT value exceeded<        	REWNOTALL(REWRITE is not allowed for a shared fileF        	RESNOTALL1RESET is not allowed on an unopened internal file >        	TRUNOTALL)TRUNCATE is not allowed for a shared file L        	UPDNOTALL8UPDATE is not allowed for a sequential organization file*        	INVFILVARinvalid file variable (        	FILALRACTfile already active $        	ERRDURNEWerror during NEW(        	ERRDURDISerror during DISPOSE&        	ERRDURMARerror during MARK (        	ERRDURRELerror during RELEASE(        GOTOnon-local GOTO requested *        
GOTOFAILEDnon-local GOTO failed        HALT  0        BUGCHECKinternal consistency failure N        	NEGDIGARG:negative Digits argument to BIN, HEX or OCT is not allowed ! PAS                                                                                                                                                                 @   @       D  P                                           8  (        x        (  H  P  X  h  p                	      @   (   8   0                                                        (   8   @   H   P   h   `   p   x            	             
   0                    
                 @                                                                       DAP                                                            	LIBCOMMON                                                      	DPASCALIO                                                      	ELNACCESS                                                      FILEUTIL                                                       DISK                                                           	GETMSGSHR                                                      	PASCALMSC                                                      	PRGLOADER                                                      DDA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  $ * [SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1 +  , N   .     /     4 O       d                  - 
    0   1    2   3      K  P   W   O     5   6 @HDl  7 5I]  8          9          G    H  J                           C ]! For instructions on adding help to this file please refer to the  ! end of this help file. !  1 @   D     Informs ECL to read subsequent commands from a command procedure     file       Format:               @file_spec 2 Parameters  
     file-spec   K     Specifies the name of the command procedure file. If you do not specify 9     a file type, the system uses the default type of COM.   <     No wildcard characters are allowed in the specification.	 2 Example   )      Example of a command procedure file:         $ CRE/DIR [.TEST]      $ COP PROMPT.TXT [.TEST] 3      $ SET DEF [.TEST] !Point to the test directory       $ !       $ !Type the operator prompt      $ !      $ TYPE PROMPT.TXT 1 COPY  .     Creates a new file from an existing file.        Format:   ,       COPY  input-file-spec output-file-spec 2 Parameters       input-file-spec   6     Specifies the name of the input file to be copied.  '     No wildcard characters are allowed.          output-file-spec  G     Specifies the name of the output file into  which  the  input  file      will be copied.   H     You  must  specify  at  least  one  field   in   the   output   fileH     specification.   If  the  device or directory is not specified, yourH     current default device and directory are  used.   The  COPY  commandH     replaces  any  other  missing  fields (file name, file type, versionH     number)  with  the   corresponding   field   of   the   input   file     specification.  H     The asterisk wildcard character can be used in  place  of  the  fileH     name, file  type,  and/or version number.  The COPY command uses theH     corresponding  field  in  the input file specification to  name  the     output file.  For example:         ECL> COPY A.A;1 *.C   H     This  COPY  command  creates  the  file A.C;1 in the current default     directory. 2 Command_Qualifiers   /ALLOCATION       /ALLOCATION=n    I     Forces the initial allocation of the output file to be the number of  J     512-byte blocks specified by n.  If you specify /ALLOCATION without a C     value for n, an error message is displayed.  If you specify an  H     allocation value which exceeds the space available to you, an error 7     message is displayed indicating the device is full.   F     If  you  omit the /ALLOCATION qualifier, the initial allocation ofE     the output file is determined by the size of the input file being      copied.      /CONTIGUOUS       /CONTIGUOUS      /NOCONTIGUOUS    H     Indicates whether the output file is  to  be  contiguous,  that  is,H     whether the file must occupy consecutive physical disk blocks.  This-     qualifier applies only to an output file.   C     If there is insufficient space to complete the COPY/CONTIGUOUS  E     operation, an error message is displayed indicating the device is 	     full.   H     By default, the COPY command creates an  output  file  in  the  sameH     format  as  the  corresponding  input  file.   If  an  input file isH     contiguous, the COPY command attempts to create a contiguo                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  =                        |LC $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                             
" "            us  outputG     file.  An error message is displayed if there is insufficient space #     available for this operation.     H     The /CONTIGUOUS qualifier has no effect when you copy  files  to  orH     from  tapes,  because  the  size  of  the  file  on  tape  cannot beH     determined until after it is copied to the disk.  If you copy a fileH     from a tape and want the file to be contiguous, use the COPY commandH     twice:  once to copy the file from the tape, and a  second  time  to     create a contiguous file.    /LOG  	     /LOG       /NOLOG (default)  G     Controls whether the COPY command displays the  file  specification 7     of the file copied.  By default COPY/NOLOG is used.   H     When you use the /LOG  qualifier,  the  COPY  command  displays  theH     following:  (1) the file specification of the input and output file,H     and  (2)  the  number  of blocks or  the  number of  records  copiedH     (depending on  whether  the  file  is  copied on a block-by-block or     record-by-record basis).   /TRANSFER_MODE      /TRANSFER_MODE=BLOCK     /TRANSFER_MODE=RECORD&    /TRANSFER_MODE=AUTOMATIC  (default)  D      The /TRANSFER_MODE qualifier is used to specify the I/O method E      to be used  in  a  transfer.   This option is especially useful  F      for COPY operations to or from operating systems which do not use      the ODS-2 file structure.  )                    /TRANSFER_MODE Options   ,    Option                           Function  <    AUTOMATIC      Allow COPY to determine the transfer mode /                   and resulting file attributes I    BLOCK          Transfer block-by-block, regardless of record structure +    RECORD         Transfer record-by-record   F    When copying files to or from an operating system which implements A    the ODS-2 file structure (for example, VMS or VAXELN), you can F    generally use /TRANSFER_MODE=AUTOMATIC, the default mode.  In this G    case, COPY will select the most efficient mode (block or record) for     transferring data.   H    When copying files to or from an operating system which does not haveH    the attributes of the ODS-2 file structure, you select the BLOCK modeG    for block-by-block data transfer, and the RECORD mode for record-by- >    record data transfer.  The mode you select will dictate theF    interpretation of the data.  When copying to VAXELN, the mode will &    dictate the attributes of the file.  	 /TRUNCATE   
    /TRUNCATE    H     Controls whether the COPY command truncates an output  file  at  theH     end-of-file  when copying it.  By default, the COPY command uses theH     allocation of the input file to determine the  size  of  the  output	     file. 
 2 Examples  &      1  ECL> COPY TEST.DAT NEWTEST.DAT  K           The COPY command copies  the  contents of the file TEST.DAT from  J           the default  disk  and  directory to a file named NEWTEST.DAT onK           the same disk and directory.  If a file named NEWTEST.DAT already G           exists,  the  COPY  command  creates  a  new  version  of it.   +      2  ECL> COPY/ALLOCATION=10 A.DAT B.DAT   F           The  COPY command  with the /ALLOCATION qualifier forces theC           initial allocation of the output file to be the number of E           512-block bytes specified by n.  In this example, the file  C           B.DAT is created with an initial allocation of 10 blocks.   (      3  ECL> COPY/CONTIGUOUS A.DAT B.DAT  E           The  COPY command  with the /CONTIGUOUS qualifier indicates G           that the output file must occupy consecutive physical blocks.   7      4  ECL> COPY/CONTIGUOUS/ALLOCATION=100 A.DAT B.DAT   E           In this example, the file B.DAT is created with an initial  7           allocation of 100 blocks of contiguous space.   *      5  ECL> COPY/LOG TEST.DAT NEWTEST.DATB         %COPY-S-COPIED, DISK$EXAMPLE:[EXAMPLE]TEST.DAT;1 copied to5         DISK$EXAMPLE:[EXAMPLE]NEWTEST.DAT;1 (1 block)   F           The /LOG qualifier requests to COPY operation to display theG           input and output file specifications and the number of blocks            copied.   1      6  ECL> COPY/TRANSFER_MODE=BLOCK B.DAT C.DAT   I           The /TRANSFER_MODE=BLOCK qualifier requests the COPY operation  *           to copy the file block-by-block.  2      7  ECL> COPY/TRANSFER_MODE=RECORD B.DAT C.DAT  J           The /TRANSFER_MODE=RECORD qualifier requests the COPY operation ,           to copy the file record-by-record.  5      8  ECL> COPY/TRANSFER_MODE=AUTOMATIC B.DAT C.DAT   C           The /TRANSFER_MODE=AUTOMATIC qualifier requests the COPY  A           operatin to copy the file, if possible, block-by-block             (more efficient).   &      9  ECL> COPY/TRUNCATE B.DAT C.DAT  F           The  COPY command  with the /TRUNCATE qualifier requests theF           COPY operation to truncate an output file at the end-of-file           when copying it. 1 CREATE  8     The CREATE commands perform the following functions:  ?     o  Creates a sequential disk files from records that follow &        in the input stream (see File).  C     o  Defines a new directory or subdirectory for cataloging files         (see /DIRECTORY). 2 File  =     Creates a sequential disk  file  from  the  records  that +     follow the command in the input stream.        Format:          CREATE  file-spec  3 Parameter   
     file-spec   1     Specifies the name of the file to be created.   D     If you omit either the file name  or the file type,  the  CREATED     command does not supply any defaults;  the  file  name  or  fileD     type is null. If you do not specify a  file  version number, andD     a file already exists with the same  file name and  file type asD     the file specification, the CREATE command creates a new version     of the file.  E     If  the  device  and  directory  are  not specified, your current /     default  device  and  directory  are  used.   E     No  wildcard  characters  are  allowed in the file specification.  3 Command_Qualifiers   /ALLOCATION        /ALLOCATION=n   G     Forces  allocation for the file to be the number of 512-byte blocks G     specified by n.  If you specify /ALLOCATION without a value for n,  "     an error message is displayed.   /LOG       /LOG     /NOLOG (default)  D     Controls   whether   the   CREATE   command  displays  the  file9     specification  of  the  file  that  it  has  created.   
 /OWNER_UIC       /OWNER_UIC=uic  D     Specifies  the  user identification code (UIC) to be  associated$     with  the  file  being  created.  4     Specify  the  UIC  using  standard  UIC  format.   /PROTECTION        /PROTECTION=(code)  =     Defines  the  protection  to  be  applied  to  the  file.   D     If  you  omit the /PROTECTION qualifier, the command applies theD     default  protection  defined for the volume on which the file is     created.  D     Specify  the  code  according  to  the standard syntax rules for     specifying  protection. 
 3 Examples        1  ECL> CREATE A.DAT           Input line one for A.DAT          Input line two for A.DAT                 .                  .                  . 
         ^Z  E            If you  issue  the  CREATE  command from the terminal, theeH            system reads input lines into the sequential file A.DAT until*            CTRL/Z  terminates  the  input.  I            If the CREATE command is issued from a command procedure file, G            the system reads input lines from the command procedure filepI            until it encounters a line whose first character is the dollaraF            sign ($), or until the end of the command procedure file is            found.     '      2  ECL> CREATE/ALLOCATION=10 A.DATX  H           The  CREATE  command  with the /ALLOCATION qualifier creates aH           contiguous  sequential  file  with fixed length records of 512H           bytes.  The  file  in  this example is created with an initial%           allocation  of  10  blocks.c 2 /DIRECTORY  A     Creates a new directory or subdirectory for cataloging files.t)     The /DIRECTORY qualifier is required.a       Format:   &       CREATE/DIRECTORY  directory-spec 3 Parameter        directory-spec  I     Specifies  the  name  of the directory or subdirectory to be created.s  I     The  directory specification must contain a directory name.  A deviceeI     name is  optional.  If you  do not specify a device name your currentoI     default device is used.  When you create a subdirectory, separate thed9     names  of  the  directory  levels  with  periods '.'.c  I     Note  that  only  the  last subdirectory in the specification will be =     created;  any  intermediat                                                                                                                                                                                                                                                   >                        PD	 $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                              "            e  levels must  already  exist.e  I     Note  also  that  the  CREATE/DIRECTORY  command  only works when the C     target  is  a  volume  being  handled  by VAXELN  File Service.e  J     No  wild  card  characters are allowed in the directory specification. 3 Command_Qualifiers   /LOG       /LOG     /NOLOG (default)  C     Controls  whether  the  CREATE/DIRECTORY  command displays the  B     directory  specification  of  the directory after creating it.  
 /OWNER_UIC       /OWNER_UIC=uic  B     Specifies the user identification code (UIC) to be  associatedB     with the  file  being created.  Specify the UIC using standard     UIC format.s
 3 Examples  '      1  ECL> CREATE/DIRECTORY [MALCOLM]d  J           The CREATE/DIRECTORY command creates a directory named [MALCOLM]            on the default device.  8      2  ECL> CREATE/DIRECTORY/LOG DISK$EXAMPLE:[EXAMPLE]9         %CREATE-I-CREATED, DISK$EXAMPLE:[EXAMPLE] createdG  J           The CREATE/DIRECTORY command creates a directory named [EXAMPLE]J           on the device  DISK$EXAMPLE.  The  /LOG  qualifier  requests theJ           CREATE/DIRECTORY  command  to  display the name of the directory           file  created. 1 DEFINE  I     Defines  the  help  file  to  be  used  with  subsequent requests foriJ     help  through  the  HELP  command.  The  /HELP  qualifier is required.       Format:          DEFINE/HELP file-spect   2 Parametere  
     file-specf  I     Gives  the  default  specification  for  the  file  the  HELP commandeI     uses  to  provide  help.  No  wildcard  characters  are  allowed   in I     the  file specification.  The initial default help file specificationNI     when you begin an ECL session is DISK$DEFAULT_VOLUME:[000000]ECL.HLP.e	 2 Example   -      1  ECL> DEFINE/HELP 25.329::ELN$:ECL.HLP   K           The DEFINE/HELP command establishes the file 25.329::ELN$:ECL.HLPmK           as the help file to be accessed when the HELP commands is issued.  1 DELETE  8     The DELETE commands perform the following functions:  I     o Delete one or more files specified by the input file specification.t  ?     o Delete one or all symbol definitions from a symbol table         (see /SYMBOL).   2 File  I     Specifies  the names of one or more file(s) to be deleted from a massoI     storage  volume.  The  file  specification  must  contain an explicituI     version  number.  You  can  use  wildcards  in  either the file name, !     file type, or version number.   I     If  you omit the directory specification or device name, the  currentb1     default  device  and  directory  are assumed.   I     In  the  version number of a file specification, a semicolon followedeI     by  no  file  version  number  or by a version number of 0 results ine9     the  deletion  of  the  latest  version of  the file.        Format:r         DELETE [file-spec]   3 Command_Qualifiers   /CONFIRM       /CONFIRM     /NOCONFIRM (default)  H     Controls whether a request is issued before each  individual  DELETEH     operation  to confirm that the operation should be performed on that	     file.e  H     When the system  issues  the  prompt,  you  can  issue  any  of  the     following responses:           YES      NO     QUIT          TRUE     FALSE  <CTRL/Z>         1        0      ALLy                  <RET>  H     You can use any combination of upper- and lowercase letters for wordH     responses.  Word responses can be abbreviated to one or more lettersH     (for example, T, TR, or TRU for TRUE).  Affirmative answers are YES,H     TRUE, and 1.  Negative answers are NO, FALSE, 0, and <RET>.  QUIT orH     CTRL/Z indicates that you want to stop  processing  the  command  atH     that  point.   When  you  respond with ALL, the command continues toH     process, but no further prompts are given.  If you type  a  responseE     other than one of those in the list, the prompt will be reissued.w   /LOG       /LOG     /NOLOG (default)  G     Controls whether the DELETE command displays the file specification +     for each file as the files are deleted.f  
 3 Examples         1  ECL> DELETE COMMON.SUM;2  C           The DELETE command deletes the file COMMON.SUM;2 from theo-           current default disk and directory.1  #      2  ECL> DELETE/LOG ALPHA.TXT;* J         %DELETE-I-FILDEL, DISK$EXAMPLE:[USER]ALPHA.TXT;2 deleted (1 block)K         %DELETE-I-FILDEL, DISK$EXAMPLE:[USER]ALPHA.TXT;1 deleted (2 blocks) 3         %DELETE-I-TOTAL, 2 files deleted (3 blocks)E  J           The  DELETE  command deletes all versions of the file ALPHA.TXT.J           The  /LOG  qualifier displays the name of each file deleted, theK           total number of files deleted, and the number of blocks recovereda           from the operation.   1      3  ECL> DELETE/CONFIRM [EXAMPLE.TEMP]*.TMP;*f:         DISK$EXAMPLE:[EXAMPLE]AVERAGE.TMP;1, delete? [N]:Y7         DISK$EXAMPLE:[EXAMPLE]TEMP.TMP;1, delete? [N]:N37         DISK$EXAMPLE:[EXAMPLE]TEST.TMP;1, delete? [N]:N 8         DISK$EXAMPLE:[EXAMPLE]TODAY.TMP;1, delete? [N]:Y         ECL>  K           The DELETE command examines all versions of  files  with the typeGK           TMP in the subdirectory  [EXAMPLE.TEMP]  on  the current  default K           device.  Before deleting each file, it requests confirmation thatsK           the file should be deleted.  The default response - N for NO - isD#           given in square brackets.p   2 Parameter   
     file-specM  I     Specifies  the names of one or more file(s) to be deleted from a mass I     storage  volume.  The  file  specification  must  contain an explicitdI     version  number.  You  can  use  wildcards  in  either the file name,D!     file type, or version number.h  I     If  you omit the directory specification or device name, the  currentc1     default  device  and  directory  are assumed.R  I     In  the  version number of a file specification, a semicolon followedeI     by  no  file  version  number  or by a version number of 0 results in.9     the  deletion  of  the  latest  version of  the file.        Format:          DELETE [file-spec]   3 Command_Qualifiers   /CONFIRM       /CONFIRM     /NOCONFIRM (default)  H     Controls whether a request is issued before each  individual  DELETEH     operation  to confirm that the operation should be performed on that	     file.e  H     When the system  issues  the  prompt,  you  can  issue  any  of  the     following responses:           YES      NO     QUIT          TRUE     FALSE  <CTRL/Z>         1        0      ALLt                  <RET>  H     You can use any combination of upper- and lowercase letters for wordH     responses.  Word responses can be abbreviated to one or more lettersH     (for example, T, TR, or TRU for TRUE).  Affirmative answers are YES,H     TRUE, and 1.  Negative answers are NO, FALSE, 0, and <RET>.  QUIT orH     CTRL/Z indicates that you want to stop  processing  the  command  atH     that  point.   When  you  respond with ALL, the command continues toH     process, but no further prompts are given.  If you type  a  responseE     other than one of those in the list, the prompt will be reissued.f   /LOG       /LOG     /NOLOG (default)  G     Controls whether the DELETE command displays the file specificationa+     for each file as the files are deleted.n  
 3 Examples         1  ECL> DELETE COMMON.SUM;2  C           The DELETE command deletes the file COMMON.SUM;2 from thei-           current default disk and directory.c  #      2  ECL> DELETE/LOG ALPHA.TXT;*aJ         %DELETE-I-FILDEL, DISK$EXAMPLE:[USER]ALPHA.TXT;2 deleted (1 block)K         %DELETE-I-FILDEL, DISK$EXAMPLE:[USER]ALPHA.TXT;1 deleted (2 blocks)f3         %DELETE-I-TOTAL, 2 files deleted (3 blocks)   J           The  DELETE  command deletes all versions of the file ALPHA.TXT.J           The  /LOG  qualifier displays the name of each file deleted, theK           total number of files deleted, and the number of blocks recoveredC           from the operation.p  1      3  ECL> DELETE/CONFIRM [EXAMPLE.TEMP]*.TMP;*s:         DISK$EXAMPLE:[EXAMPLE]AVERAGE.TMP;1, delete? [N]:Y7         DISK$EXAMPLE:[EXAMPLE]TEMP.TMP;1, delete? [N]:N 7         DISK$EXAMPLE:[EXAMPLE]TEST.TMP;1, delete? [N]:Nn8         DISK$EXAMPLE:[EXAMPLE]TODAY.TMP;1, delete? [N]:Y         ECL>  K           The DELETE command examines all versions of  files  with the typelK           TMP in the subdirectory  [EXAMPLE.TEMP]  on  the current  defaulttK           device.  Before deleting each file, it requests conformation that K           the file should be deleted.  The default response - N for NO - isi#           given in square brackets.    2 Command_Qualifier    /SYMBOL                                                                                                                                                                                                                                                    ?                        !'; $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                             3Q "     )         
    /SYMBOL  D    Deletes a symbol definition from the symbol table, or deletes allB    symbol definitions in a symbol table.  The /SYMBOL qualifier is    required.  
    FORMAT:         DELETE/SYMBOL [symbol-name]   3 Command_Qualifiers /ALL     /ALL  B   Specifies that all symbol names in the specified symbol table be   deleted.     /LOG       /LOG     /NOLOG (default)  ?     Indicates that an informational message listing the symbols =     being deleted be displayed.  By default, no informational      messages are displayed.C   3 ParameterN       symbol-name   D     Specifies the name of a symbol definition to be deleted from the     symbol table.e  
 3 Examples        1  ECL> DELETE/SYMBOL TIME   A           The DELETE/SYMBOL command deletes the symbol definitioni%           TIME from the symbol table.s  #      2  ECL> DELETE/SYMBOL/LOG timei:         %ECL-I-DELSYM, Global symbol TIME has been deleted  G           The  DELETE  command deletes the symbol definition TIME from iG           the symbol table.  The  /LOG  qualifier displays the name of aD           the symbol being deleted.  All symbols are global symbols.        3  ECL> DELETE/SYMBOL/ALL  F           The DELETE/SYMBOL/ALL command deletes all symbol definitions            from the symbol table.  "      4  ECL> DELETE/SYMBOL/ALL/LOG:         %ECL-I-DELSYM, Global symbol TIME has been deleted:         %ECL-I-DELSYM, Global symbol LIST has been deleted9         %ECL-I-DELSYM, Global symbol RUN has been deleteda  C           The  DELETE  command deletes all symbol definitions from oG           the symbol table.  The  /LOG  qualifier displays the name of  E           each symbol being deleted.  All symbols are global symbols.d  a 1 DIRECTORYs  H     Provides a list of files or information about a  file  or  group  of
     files.       Format:a         DIRECTORY  [file-spec] 2 ParameterR  
     file-speci  D     Specifies  the  file  to  be  listed.   The  syntax  of  a  fileD     specification determines which files will be listed, as follows:  H     o  If you do not enter a file specification, the  DIRECTORY  commandH        lists all versions of the files in the current default directory.  H     o  If you specify only a device name,  the  DIRECTORY  command  uses,        your default directory specification.  H     o  Whenever the file specification does not include a file name  andH        file  type,  all versions of all files in the specified directory        are listed.  H     o  If a file specification contains a file name and/or file type andC        no version number, the DIRECTORY command lists all versions.A  H     o  If a file specification contains only a file name, the  DIRECTORYH        command  lists  all  files  in the current default directory with=        that name, regardless of file type and version number..  H     o  If a file specification contains only a file type, the  DIRECTORYH        command  lists  all  files  in the current default directory withB        that file type, regardless of file name and version number.  H     You  can  use wildcard characters in the file name,  file  type,  orH     version number fields of a file specification to list all files that'     satisfy the components you specify.0 2 Command_Qualifiers   /BRIEF       /BRIEF (default)  J     Includes  only the file name, type, and version number of each file toJ     be  listed.   The  brief  format lists the files in alphabetical orderJ     from  left  to right on each line, in descending version number order.J     However,  the  /BRIEF  qualifier, whether  specified  explicitly or inJ     effect  by  default, is  overridden  whenever  one  of  the  followingJ     formatting  qualifiers  is  specified  in the command:  /DATE,  /FULL,0     /OWNER,  /PROTECTION,  /SECURITY,  or /SIZE.   /DATE   	     /DATE      /NODATEi  J     Includes  the  creation  date  for each  specified  file.  If you omit0     this  qualifier,  the  default  is  /NODATE.   /FULL   	     /FULL   ,     Lists the following items for each file:              File name            File type            Version numberd             Number of blocks used%            Number of blocks allocatedl            Date of creations            Date of last backup            Date last modifiedd            Date of expirationo            File owner's UICt            File protection+            File identification number (FID)             File organization             Other file attributes            Record attributes            Record format$            Access control list (ACL)  I     The  /FULL  qualifier  overrides  the  default  brief listing format.r   /GRAND_TOTAL       /GRAND_TOTAL  I     Suppresses  both  the  per-directory  total   and   individual   fileFI     information.   /GRAND_TOTAL  displays  only  the  total  line for all I     files  and directories that have been selected.  (See  the  /TRAILINGeD     qualifier  for  information  on  displaying  directory  totals.)   /OWNER  
     /OWNER     /NOOWNER (default)  ;     Controls  whether  the  file  owner's  UIC  is  listed.N   /PROTECTIONd       /PROTECTION      /NOPROTECTION (default)a  H     Controls  whether  the  file  protection  for  each  file is listed.  	 /SECURITY   
     /SECURITYn  H     Controls  whether  information  about  file  security  is displayed.H     Using   the   /SECURITY  qualifier  provides  the  same  informationD     as  the  two  qualifiers   /OWNER,  and   /PROTECTION  together.   /SIZE        /SIZE[=option]     /NOSIZE (default)   H     Provides the file size in blocks used and/or allocated for each fileH     listed,  according  to the option you specify.  If you specify /SIZEH     without an option, the listing provides  the  file  size  in  blocks+     used.  The options you can specify are:-  H       ALL             Lists the file size both in blocks used and blocks                       allocatedT  =       ALLOCATION      Lists the file size in blocks allocatedd  8       USED            Lists the file size in blocks used   /TOTAL  
     /TOTAL  H     Suppresses  the  listing  of  all  individual  file  information andH     displays  only  the trailing lines, as described under the /TRAILING     qualifier.  H     By default, the output format is /BRIEF, which gives this total, butH     also  lists  all  the  file  names,  file  types,  and their version     numbers.  	 /TRAILINGT  
     /TRAILING:     /NOTRAILINGE  H     Controls  whether  trailing  lines  that  summarize  the   following     information are output:          o  Number of files listedm  2       o  Total number of blocks used per directory  )       o  Total number of blocks allocatedE  J       o  Total  number  of  directories  and  total  blocks  used   and/orJ          allocated  in all directories (only if more than one directory is          listed)  H     By  default,  the  output  format  includes  most  of  this  summaryH     information.    The   /SIZE  and  /FULL  qualifiers  determine  moreH     precisely what summary information is included.  If you  omit  /SIZEH     or  /FULL,  only  the  number of files is displayed and possibly theH     total number of directories, if  applicable.   If  you  specify  theH     /SIZE  qualifier,  the number of blocks is also displayed, accordingH     to the size  option  selected  (USED  and/or  ALLOCATION).   If  youH     specify  the  /FULL  qualifier,  the  number of files as well as the6     number of blocks used and allocated are displayed.
 2 Examples        1.  ECL> DIRECTORY   I           The DIRECTORY command lists  all  versions  of all files in the I           current  default  disk  and  directory  in  the  brief  format.aI           The heading identifies the disk and directory, and the trailingr1           line  gives  the total number of files.   #      2.  ECL> DIRECTORY AVERAGE.*;0   J           The  DIRECTORY  command lists only the highest version  of  eachJ           file named AVERAGE in the current default directory.  The formatI           is  brief,  four  columns,  with  heading  and  trailing lines.u         3.  ECL> DIRECTORY BLOCK%%%  J           The DIRECTORY command locates all versions and types of files inJ           the  default  device  and  directory whose  names begin with theJ           letters BLOCK and end with any three additional characters.  TheJ           default  output format is  brief, four columns, with heading and           trailing lines.n         4.  ECL> DIRECTORY 25.276::  I           This  DIRECTORY  command  lists  all  the  files  cataloged  in I           the  directory   associated  with  the  default  account                                                                                                                                                                                                                                                   @                         $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                             b "     :         beingG2           accessed  at  the  remote  node  25.276.
 1 DISMOUNT  G     Releases a disk or magnetic tape volume that was previously mountedlH     with  the  mount  command  or  when  the  system  was  bootstrapped.       Format:E         DISMOUNT device-name 2 Parameter        device-namer  6     Specifies the name of the device to be dismounted. 2 Command_Qualifiers   /TAPE-  	     /TAPEK  I     Specifies that the device to be dismounted is a magnetic tape volume.E   /UNLOADR      /UNLOAD (default)    /NOUNLOAD  J     Controls whether  the  DISMOUNT  command  unloads  the physical deviceJ     on  which  the  volume is mounted and makes the device not ready.  UseK     the /NOUNLOAD qualifier to keep the device and volume in a ready state.i
 2 Examples        1.  ECL> DISMOUNT DUA0:  K           The   DISMOUNT  command  dismounts  the  volume  mounted  on  theM           device  DUA0.E  *      2.  ECL> DISMOUNT/TAPE/NOUNLOAD MUA0:  L           The DISMOUNT command dismounts the volume; the /NOUNLOAD qualifierD           requests  that  the  volume  remain  in  the  ready state.	 1 EXECUTEl  @     Creates a new job, which executes a specified program image.  
     Format         EXECUTE prog-name  2 Parametert  
     prog-name[  I     Specifies the name of the the program the job is to run.  The programeI     must  have been specified to the System Builder or loaded with eithertA     the  LOAD/PROGRAM  command  or  the  LOAD_PROGRAM  procedure.r 2 Command_Qualifiers  
 /ARGUMENTS       /ARGUMENTS=(arg[,...])  J     Specifies  from  1  to  8  optional  arguments  to  be  passed  to theJ     program.  Arguments  can  also  be  supplied  to  the program with theJ     System Builder,  as  part  of  a program  description.  Note  that anyJ     arguments  supplied  with the  /ARGUMENTS qualifier override arguments(     supplied  with  the  System  Builder  J     If  you  specify  only  one  parameter,  you can omit the parenthesis.  K     The commas delimit individual parameters.  To specify a parameter that eK     contains  special  characters  or delimiters, enclose the parameter in hJ     quotation  marks.  Each  parameter  can  have  up  to a maximum of 100     characters.   K     ECL always  passes  a  minimum  of  8 arguments to the invoked program. K     By  convention,  the   name  of  the  user's terminal  -  for  example,LK     CONSOLE:   or   TTA0:  -  is   passed  as  the  first  three  argumentstK     (corresponding  to  SYS$INPUT,  SYS$OUTPUT,  and  SYS$ERROR). ArgumentsiK     specified with  /ARGUMENTS  are passed starting at the fourth argument. K     If  no arguments are specified using /ARGUMENTS the remaining arguments '     are  passed  as  null strings ('').E  K     To     invoke    programs    that    do     not    conform    to    theoK     SYS$INPUT/SYS$OUTPUT/SYS$ERROR calling convention   -  or to  specify a K     different terminal than the one you are currently using  -  specify thee$     /NOSTANDARD_ARGUMENTS qualifier.   /STANDARD_ARGUMENTS   !     /STANDARD_ARGUMENTS (default)m     /NOSTANDARD_ARGUMENTSi  K     Controls  whether  the  first  three  program  arguments  passed to thenK     program   give  the  name  of  the user's  terminal.  By  default,  thesK     terminal  names  are  passed, and  correspond to SYS$INPUT, SYS$OUTPUT,fK     and  SYS$ERROR  respectively.  Any  program  arguments  passed  in  the]K     EXECUTE  command  are  passed  starting at the fourth program argument.   K     Use   /NOSTANDARD_ARGUMENTS   to   prevent   EXECUTE  from  passing thesK     terminal   name   as   the   first   three   program   arguments.    IfEK     /NOSTANDARD_ARGUMENTS   is   specified,  any arguments you specify with K     the  /ARGUMENTS  qualifier  are passed  starting  at  the first programa     argument. (See examples.)i   /WAITp  	     /WAIT      /NOWAIT (default)i  J     Controls whether the EXECUTE command waits for the program to complete:     execution  before  prompting  for  the  next  command.  
 2 Examples        1.  ECL> EXECUTE MYPROGRAM   L           This command executes the program MYPROGRAM.  The command languageL           utility  prompts  for  the  next  command  without waiting for the           program to terminate.a  E      2.  ECL> EXECUTE EXAMPLE/ARGUMENTS=(PARAMETER1, PARAMETER2)/WAIT   L           The  EXECUTE  command invokes the program EXAMPLE and waits for itL           to  complete  before  requesting the next command to process.  TheL           command  passes the  terminal that the command language is runningL           on  as  the first three program arguments  (SYS$INPUT, SYS$OUTPUT,M           and   SYS$ERROR   respectively).   The  arguments  PARAMETER1  and oL           PARAMETER2  are  passed as the fourth and fifth program arguments.  E           The program arguments that the program EXAMPLE receives is:l  -             Program_argument[1]  = "CONSOLE:" -             Program_argument[2]  = "CONSOLE:"f-             Program_argument[3]  = "CONSOLE:"r/             Program_argument[4]  = "PARAMETER1"r/             Program_argument[5]  = "PARAMETER2"e%             Program_argument[6]  = ""e%             Program_argument[7]  = ""e%             Program_argument[8]  = ""i%             Program_argument[9]  = ""o%             Program_argument[10] = ""R%             Program_argument[11] = ""T  L      3.  ECL> EXECUTE/NOSTANDARD_ARGUMENTS EXAMPLE/ARGUMENTS=(PARAM1,PARAM2)  K           The EXECUTE command invokes the program EXAMPLE but does not wait K           for it to complete before requesting the next command to process. K           The qualifier /NOSTANDARD_ARGUMENTS suppresses the passing of the K           terminal on which the command language is running on as the firsttK           three program arguments.  The arguments  PARAM1  and  PARAM2  ared;           passed as the first and second program arguments.t  E           The program arguments that the program EXAMPLE receives is:   *             Program_argument[1] = "PARAM1"*             Program_argument[2] = "PARAM2"$             Program_argument[3] = ""$             Program_argument[4] = ""$             Program_argument[5] = ""$             Program_argument[6] = ""$             Program_argument[7] = ""$             Program_argument[8] = "" 1 HELP  <     Displays information from the current default help file.       Format:          HELP  [keyword,...]e 2 Parameters       keywordb  I     Specifies  one  or  more keywords that refer to the topic or subtopicsI     on  which  you  want information from a help file. Information within)I     HELP   is   arranged  in  a  hierarchical  manner.  The  levels  are:T  B 	1. None -- If you do not specify a keyword, HELP lists the topicsI            that are available.  Each item in the list is a keyword in the (            first level of the hierarchy.  I         2. Topic-name -- If you specify a keyword by naming a topic, HELPTJ            describes  the  topic  as  it is documented.  Keywords for any J            additional information available on this topic are also listed.  J         3. Topic-name subtopic -- If you  specify a  subtopic  following aJ            topic,  HELP  provides  a  description  of the specified topic.J            Keywords for any additional information available on this topic            are also listed.e            cJ         You   can   abbreviate   any   keyword  name,  although  ambiguousH         abbreviations   result   in   all   matches   being   displayed.
 2 Examples        1.  ECL> HELP  !            Information available:t                (list of topics)     G           Issuing the HELP command without any qualifiers or parametersl6           produces  a  display  of  the  HELP  topics.        2.  ECL> HELP COPY/              COPYf  J                Creates an exact copy of the input file to the output file.                  Format:  7                  COPY input-file-spec  output-file-specb  ,            Additional information available:  '            Parameters Command_Qualifierl            /LOG       Examples    I           You can get HELP on a specific topic or subtopic.  This example /           requests  HELP  on  the  topic  COPY.  1 INITIALIZE  8     Formats and writes a label on a mass storage volume.       Format:d  )       INITIALIZE device-name volume-labelc 2 Parameters       device-name   J     Specifies the name of the device on which the volume to be initialized     is physically mounted.         volume-label  J     Specifies  the identification to be encoded on the volume.  For a diskJ     volume,  you  can  specify a maximum of 12 alphanumeric characters andJ     the  character                                                                                                                                                                                                                                                   A                        ֲ $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                              "     K       s  $ and  _; for a magnetic tape volume, you can specifyJ     a  maximum of  6  alphanumeric  characters.  Letters are automatically     changed to uppercase.  2 Command_Qualifiers  	 /ACCESSEDo       /ACCESSED=ns  H     Specifies,  for disk volumes, the number of directories to be cached)     by  the  system  for  ready  access. e  H     Legal values for n are 0 through 255.  If /ACCESSED is not specified?     the  INITIALIZE  command  uses  the  default  value  of  3.l  
 /CLUSTER_SIZEl       /CLUSTER_SIZE=n   H     Defines,  for  disk volumes, the minimum allocation unit, in blocks.H     The  maximum  size  you can specify for a volume is one-hundreth theH     size  of  the volume.  The  cluster size default depends on the diskH     capacity;  disks  that are  50,000  blocks  or larger have a defaultH     cluster  size  of 3, while those smaller than  50,000  blocks have a     default of 1.    /DATA_CHECKe       /DATA_CHECK=option  H     Defines,  for  a  disk  volume, a  default for data check operationsH     following  all  reads  and/or writes to the volume.  You can specify%     one  of  the  following  options:o  7     READ  Performs checks following all read operations   8     WRITE Performs checks following all write operations  H     If  you specify /DATA_CHECK without specifying an option, the systemH     assumes   the  default  of /DATA_CHECK=WRITE.  If you do not specifyH     /DATA_CHECK,  the  system  by  default  performs  no  data checking.   /DENSITY       /DENSITY=density-value  I     For magnetic  tape  volumes, specifies the density in bytes per inch TH     (bpi) at  which  the  magnetic  tape  volume  is  to be written.  IfH     the  specified  density  is  not supported, the magnetic tape volumeH     will  be  initialized  to the  supported density closest to it.  TheH     default density  is  the  highest  density  supported  by  the  tape
     drive.   /DIRECTORIES       /DIRECTORIES=n  H     Specifies,  for  disk  volumes, the number of entries to preallocate     for  user  directories.   H     The  legal  values  are in the range 16 through 16000; if you do notH     specify  a  value, the  INITIALIZE command uses the default value of     16.   
 /EXTENSION       /EXTENSION=n  I     Specifies, for disk volumes, the number of blocks to use as a default I     extension size for all files on the volume.  The extension default is I     used when a file increases to a size greater than its initial default/      allocation during an update.  I     You can specify a value in the range 0 through 65,535.  If you do notsI     specify a default extension size, the INITIALIZE command uses a valuea	     of 5.o   /FILE_PROTECTION       /FILE_PROTECTION=code   J     Defines,  for  disk  volumes, the  default protection to be applied to     all files on the volume.  J     Specify the code according to the standard syntax rules for specifyingJ     protection.  If you  do  not  specify  /FILE_PROTECTION the INITIALIZEK     command  assigns  the  default  protection  of RWED  to the system and MJ     owner  categories;  RE  to the group category;  and  no  access to the     world category.    /GROUP  
     /GROUP  I     Defines a disk volume as a group volume.  The owner UIC of the volumerJ     defaults  to  the  group number of the user issuing the command and a      member number of 0.e  I     If  this  qualifier  is  specified  in  conjunction with the /NOSHARE I     qualifier, the  volume  protection is RWED for the system, owner, andoI     group.  However,  the  /GROUP qualifier  specified  alone defines thet=     volume  protection  as  RWED  for  all  user  categories.       /HEADERS       /HEADERS=n  I     Specifies,  for disk volumes,  the  number  of  file  headers  to  belI     allocated initially  for  the index file.  The  minimum value you can I     specify  is  16;  the  maximum  value  is  the  value  set  with  theO     /MAXIMUM_FILES qualifier.s  I     By  default,  the  INITIALIZE  command  allocates  16  file  headers.Y   /INDEX       /INDEX=positione  H     Requests, for  disk  volumes, that  the  index file for the volume'sH     directory  structure be places in a specific location on the volume.  1     You can specify one of the following options:     H     BEGINNING    Places the  index  file  at the beginning of the volume  H     END          Places  the  index  file  at  the  end  of  the  volume  H     MIDDLE       Places the  index  file  in  the  middle  of the volume    H     By  default, the  INITIALIZE  command  places  the index file in the     middle  of  the  volume.     /MAXIMUM_FILES       /MAXIMUM_FILES=n  I     Restricts,  for  disk  volumes, the  maximum number of files that theiI     volume  can  contain,  overriding  the default value.  The default is 4     calculated  from  the  volume  size  in  blocks.  I     The minimum value is 0.  Note, however, that you should specify a low I     file maximum only after careful consideration.  Once set, the maximum 7     can be increased only by reinitializing the volume.e  
 /OWNER_UIC       /OWNER_UIC=uic  I     Specifies,  for  disk  volumes,  the  user  identification code to be I     assigned ownership  of  the volume and files.  Specify  the UIC using      standard UIC format.  I     If  you  do  not  specify  /OWNER_UIC,  the default value of [1,1] iseI     used.  However,  if  you  do  not  specify  /OWNER_UIC, but /GROUP isrI     specified, the UIC is assigned as your  current  UIC  with  a  memberr     number  of  0.   /PROTECTIONn       /PROTECTION=code  I     Specifies, for disk volumes, the protection to applied to the volume.YI     The protection controls who can read, write, create, and delete files I     on  the  volume.  If you do not specify a protection code, protection2I     defaults  to  all  types of access to all user categories.  Note that I     the /GROUP, /SHARE, and /SYSTEM qualifiers can also be used to define       protection for disk volumes.  J     Specify the code according to the standard syntax rules for specifying     protection.l  J     When  you  specify a protection code for an entire disk volume, access2     type  E  (execute)  indicates  create  access.   /SHARE       /SHARE (default)     /NOSHARE  I     Controls whether a disk volume is shareable.  The protection code for I     the  volume  defaults to all types of access for all user categories. I     If you specify  /NOSHARE,  the  protection code defaults to no accesstB     for  group  and  world,  unless  /GROUP  has  been  specified.   /SYSTEM        /SYSTEMt  K     Defines  a  disk  volume  as  a system volume.  The protection for the  J     volume  defaults  to  all  types of access to the volume to all users.  J     Note, however, that only users with system UICs can create directories     on system volumes.  
 /USER_NAME       /USER_NAME=stringe  K     Specifies,  for  disk volumes, a user name of up to 20 characters to beAK     recorded on the volume.  If /USER_NAME is not specified, the INITIALIZE C     command  takes  the  user  name  under  which  you  logged  in.x   /TAPE   	     /TAPE   J     Specifies that the device to be initialized is a magnetic tape volume.  	 /VERIFIEDm       /VERIFIED (default)a     /NOVERIFIED   I     Indicates,  for  disk volumes, whether the disk has bad block data onaI     it.  The default is /VERIFIED, that is the INITIALIZE command assumessI     that  the disk contains bad block data, and uses the data to mark bad I     blocks as allocated.  Use /NOVERIFIED to ignore bad block data on thet	     disk.M     
 2 Examples  2      1.  ECL> INITIALIZE/NOVERIFIED DUA0: USERDISK          ECL> MOUNT DUA0:_,          ECL> CREATE/DIRECTORY DUA0:[ARCHIE]  L           The  previous  sequence  of  commands  shows  how  to initialize aL           disk  volume.  First, the INITIALIZE command is used to initializeL           the volume. When the volume is initialized the MOUNT command makesL           the  file  structure  available.  The   CREATE/DIRECTORY   commandM           creates  a  directory  in  which  to  place  files  on the volume. E    7      2.  ECL> INITIALIZE/TAPE/DENSITY=1600 MUA0: SOURCE           ECL> MOUNT/TAPE MUA0:$          ECL> COPY EXAMPLE.PAS MUA0:  I           These  commands  show  the  procedure necessary to initialize a J           magnetic tape. First, the magnetic tape is loaded on the device,J           and the INITIALIZE/TAPE command writes  the  label SOURCE on it.J           Then, the MOUNT/TAPE command mounts the  magnetic  tape  so that*           files  can  be  written  to  it. 1 LOAD  J     When the /PROGRAM qualifier is present, the command lo                                                                                                                                                                                                                                                   B                        s $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                             [o "     \       ads a specified E     program into the system. When the /SYSTEM qualifier is present, a.M     secondary system will be loaded with a system image. Either the /PROGRAM  3     qualifier or the /SYSTEM qualifier is required.        Format:a         LOAD/PROGRAM file-spec               or  *       LOAD/SYSTEM=processor_type file-spec 2 Parameter   
     file-specm  +                                LOAD/PROGRAMa  K     If the command is LOAD/PROGRAM, the file-spec is an  executable  image EL     (program) to  be loaded into the system.   If you do not specify a file L     type, the LOAD/PROGRAM command  uses  the  default  file  type  of  EXE.  *                                LOAD/SYSTEM  L     If the command is LOAD/SYSTEM=processor_type, the file-spec is the name E     of a system image file to be loaded into a secondary system, and  K     processor_type (required) is the name of the processor (e.g. KA800) on  M     the secondary system. If you do not specify a file type, the LOAD/SYSTEM  I     command  uses the  default  file  type  of  SYS. Note: Do not use the I     LOAD/SYSTEM command if the system contains MS820 memory. You must use G     the configuration file method of loading to configure MS820 memory.m  I     If the device  or  directory is  not specified, your current default z"     device and directory are used.  M     No  wildcard   characters   are   allowed  in  the  file  specification. . 2 Command_Qualifiers   /ADAPTER_NUMBERi       /ADAPTER_NUMBER=nu  L     Specifies the VAXBI adapter number of the secondary system to be loaded.?     This qualifier is valid only if the command is LOAD/SYSTEM.   
 /BI_NUMBER       /BI_NUMBER=n  D     Specifies the VAXBI number of the secondary system to be loaded.?     This qualifier is valid only if the command is LOAD/SYSTEM.e   /DEBUG  
     /DEBUG     /NODEBUG (default)  K     If the command is LOAD/Program, this qualifier controls  whether  the  eL     VAXELN debugger (EDEBUG) is to get control of the   program  when it is O     started.  If  you  specify /DEBUG, debugger support must have been built   m     into the VAXELN system..  M     If the command is LOAD/SYSTEM, this qualifier controls whether the kerneli5     debugger will be invoked on the secondary system.o  
 /JOB_PRIORITYa       /JOB_PRIORITY=ne  I     Specifies the starting job priority for the program.  The value for noG     can  be  from  0  to  31.   The  default  is  16. This qualifier ise0     valid only when the command is LOAD/PROGRAM.  
 /KERNEL_STACK        /KERNEL_STACK=n   K     Specifies the size, in pages, of the kernel mode stack for jobs runningeK     this program.  User mode programs require at least 1 page (the default)lE     of kernel stack. This qualifier is valid only when the command isr     LOAD/PROGRAM.    /LOG       /LOG     /NOLOG (default)  J     Controls  whether  the  LOAD/PROGRAM and LOAD/SYSTEM commands displaysK     the program name associated  with  the loaded image.  You can name the sK     program with the /PROGRAM_NAME qualifier (when used with LOAD/PROGRAM).n   /MESSAGE_LIMIT       /MESSAGE_LIMIT=n  J     Specifies the maximum number of messages the job port can contain; theB     default is 0. This qualifier is valid only when the command is     LOAD/PROGRAM.u   /MODEi       /MODE=option  J     Specifies  the  mode  in which the program is to run.  The options you     can  specify  are:    @     KERNEL        Specifies the program is to run in kernel mode  >     USER          Specified the program is to run in user mode  B     This qualifier is valid only when the command is LOAD/PROGRAM.   /POWER_RECOVERYo       /POWER_RECOVERYt     /NOPOWER_RECOVERY (default)T  I     Specifies  whether  the  job  running  the specified program is to beNI     given  the power recovery exception if the power fails on the system. B     This qualifier is valid only when the command is LOAD/PROGRAM.   /PROCESS_PRIORITY        /PROCESS_PRIORITY=nt  I     Specifies  the  starting  process  priority (n) for the program.  The G     value  for  n  can  be  from  0  to  15.  The  default  is  8. Thiso=     qualifier is valid only when the command is LOAD/PROGRAM.d  
 /PROGRAM_NAME        /PROGRAM_NAME=prg-name  I     Specifies the name by which the program will be known for the purposetI     of invoking it with the EXECUTE command.  If you do  not  specify thehI     /PROGRAM_NAME qualifier the image name supplied by the linker is usednD     as the default. This qualifier is valid only when the command is     LOAD/PROGRAM.d   /SYSTEMt       /SYSTEM=processor-type  I     Specifies that the command is to load a secondary system containing aoK     processor of type processor-type (typ. KA800) with a system image file.m   /USER_STACKl       /USER_STACK=nf  I     Specifies  the initial size (n), in pages, of the user mode stack formI     jobs  running  this  program.  Programs  require at least 1 page (theiI     default)  of  user  stack.  This qualifier is ignored for kernel modei?     programs. This qualifier is valid only when the command is       LOAD/PROGRAM.s  
 2 Examples  (      1.  ECL> LOAD/PROGRAM/LOG MYPROGRAM/          %LOAD-I-LOADED, image MYPROGRAM loadedS
          ECL>S  L           The  LOAD  command  loads the image file MYPROGRAM residing in theL           default  device and directory into the system.  The /LOG qualifierL           causes  ECL to display the program name associated with the loadedL           image (supplied by the linker since no /PROGRAM_NAME qualifier was           specified.  >      2.  ECL> LOAD/SYSTEM=KA800/LOG/BI=2/ADAPTER=3 SUBORDINATE1          %LOAD-I-LOADED, image SUBORDINATE loaded 
          ECL>s  I           The  LOAD  command  loads the system image file into the systemf            at VAXBI 2, adapter 3.     1 LOGOUT  /     Terminates an interactive terminal session.        Format:          LOGOUT 1 MOUNTe  B     Makes a disk or magnetic tape volume available for processing.       Format:i         MOUNT device-name    2 Parameter        device-nameN  B       Specifies the physical device name on which the volume is to       be mounted.M 2 Command_QualifierM   /TAPEn  	     /TAPEi  G      Specifies that the device to be mounted is a magnetic tape volume.e  
 2 Examples        1.  ECL> MOUNT DUA0:l  K           The  MOUNT  command  the  volume  that is currently loaded in the K           indicated drive, making it available for use as a file-structured            volume.f          2.  ECL> MOUNT/TAPE MUA0:  K           The  MOUNT  command mounts the volume that is currently loaded inNK           the  indicated  drive.  The  /TAPE  qualifier  specifies that ther%           device  is  a  tape  drive.n 1 PURGEh  G     Deletes all but the highest-numbered version of the specified file.r       Format:          PURGE [file-spec]E 2 Parametere  
     file-spec,  I     Specifies  the  file(s) to be purged.  If you  do  not provide a filePI     specification, the  PURGE command purges all  files  in  the  currentm$     default  device  and  directory.  I     If  you  specify  only  a file name, PURGE purges all files with that I     file name, regardless of file type.  If you specify only a file type,,I     PURGE  purges  all  files  of that file type regardless of file name.rI     Version numbers cannot be specified.  You can use wildcard characterss?     in  the  file  name  field  and/or  the  file  type  field.u  I     If  you omit the directory specification or device name, the  current -     default device and directory are assumed.a 2 Command_Qualifiers   /CONFIRM       /CONFIRM     /NOCONFIRM (default)  H     Controls whether a request is  issued before each  individual  PURGEH     operation  to confirm that the operation should be performed on that	     file.e  H     When the system  issues  the  prompt,  you  can  issue  any  of  the     following responses:           YES      NO     QUIT          TRUE     FALSE  <CTRL/Z>         1        0      ALLt                  <RET>  H     You can use any combination of upper- and lowercase letters for wordH     responses.  Word responses can be abbreviated to one or more lettersH     (for example, T, TR, or TRU for TRUE).  Affirmative answers are YES,H     TRUE, and 1.  Negative answers are NO, FALSE, 0, and <RET>.  QUIT orH     CTRL/Z indicates that you want to stop  processing  the  command  atH     that  point.   When  you  respond with ALL, the command continues toH     process, but no further prompts are given.  If you type  a  responseE     other than one of those in the list, the prompt will be reissued.    /LOG       /LOG     /NOLOG (default)  H     Cont                                                                                                                                                                                                                                                   C                        {{ $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                                   m       rols whether the  PURGE command displays the file specificationsH     of  each  file  it  deletes  and the total number of file and blocks     deleted.  
 2 Examples        1.  ECL> PURGE COMMON.SUM  H           The  PURGE  command  deletes  all  but  the   highest-numberedH           version  of  the  file  COMMON.SUM in the current default disk           and directory. a           2.  ECL> PURGE/LOG SAMPLE.*E          %PURGE-I-FILPURG, DISK$EXAMPLE:[EXAMPLE]SAMPLE.TXT;3 deletedI          (3 blocks)SF          %PURGE-I-FILPURG, DISK$EXAMPLE:[EXAMPLE]SAMPLE.TXT;2 deleted           (20 blocks)E          %PURGE-I-FILPURG, DISK$EXAMPLE:[EXAMPLE]SAMPLE.TMP;5 deleted           (5 blocks)F4          %PURGE-I-TOTAL, 3 files deleted (28 blocks)  I           The PURGE command deletes all but the highest-numbered versions I           of the files with the same file name SAMPLE. The /LOG qualifier I           causes  PURGE  to display the name of each file deleted and the.4           total number of files and blocks deleted.  1 RENAME  F      Changes the directory specification, file name, file type or file8      version of an existing disk file or disk directory.       Format:   -       RENAME input-file-spec output-file-specp 2 Parameters       input-file-spec   J     Specifies  the  name of the file whose specification is to be changed.  +     No  wildcard  characters  are  allowed.          output-file-spec  J     Provides  the  new file specification to be applied to the input file.J     The  RENAME  command  uses  the device, directory, file name, and fileJ     type of the input file specification to provide defaults for fields inJ     the  output  file that are not specified, or indicated by the wildcard     character '*'.    J     The  RENAME  command supplies output file version numbers according to-     the first description below that applies:   I     1.  If  the  output  file specification  contains an explicit versioncI         number,  the   RENAME   command   uses   that   version   number.r  I     2.  If no file currently exists with the same file name and file type I         as  that  specified for the output file, the RENAME command gives +         the new file a version number of 1.f  H     3.  If a file currently exists with the same file name and file typeH         as  the  output file, the RENAME command gives the output file aI         version  number  one  greater  than the highest existing version.  2 Command_Qualifier    /LOG       /LOG     /NOLOG (default)  H     Controls  whether the RENAME command displays the file specification%     of  the  file  that  it  renames.t
 2 Examples  /      1.  ECL> RENAME AVERAGE.OBJ OLDAVERAGE.OBJr  H           The  RENAME  command  renames  the  file  name  of the highestI           existing  version  of  the file  AVERAGE.OBJ to OLDAVERAGE.OBJ.dH           If no file named OLDAVERAGE.OBJ currently exists, the new file,           is assigned a version number of 1.    .      2.  ECL> RENAME/LOG REPORT.TMP REPORT.PRMH          %RENAME-I-RENAMED, DISK$E      s       AMPLE:[EXAMPLE]REPORT.TMP;1 renamed to+          DISK$EXAMPLE:[EXAMPLE]REPORT.PRM;1o  H           The  RENAME  command  renames  the  file  name  of the highestI           existing  version  of the file  REPORT.TMP to REPORT.PRM.  The  H           /LOG qualifier causes the result of the rename operation to be           displayed. 1 RUNe  -     Places a program into execution as a job.        Format:e         RUN file-specE   2 Parametert  
     file-spec   C     Specifies the  executable  image to be executed.  If you do notuC     specify a file type, the RUN command uses the default file typef     on EXE.i  D     If  you  omit  the  directory specification or device name, the ;     current  default  device  and  directory  are  assumed.   C     No wildcard  characters  are allowed in the file specification.h   2 Command_Qualifiers  
 /ARGUMENTS       /ARGUMENTS=(arg[,...])  J     Specifies  from  1  to  8  optional  arguments  to  be  passed  to theJ     program.  Arguments  can  also  be supplied  to  the  program with theJ     System  Builder,  as   part  of  a program description.  Note that anyJ     arguments supplied with the  /ARGUMENTS  qualifier  override arguments(     supplied  with  the  System  Builder  J     If  you  specify  only  one parameter, you  can  omit the parenthesis.  J     The  commas  delimit  individual  parameters.  To  specify a parameterJ     that  contains special characters or delimiters, enclose the parameterJ     in  quotation  marks.  Each  parameter can have up to a maximum of 100     characters.   J     ECL  always  passes  a  minimum of 8 arguments to the invoked program.J     By  convention,  the  name  of  the  user's  terminal  -  for example,J     CONSOLE:   or   TTA0:  -  is  passed  as  the  first  three  argumentsJ     (corresponding to  SYS$INPUT,  SYS$OUTPUT,  and  SYS$ERROR). ArgumentsJ     specified with  /ARGUMENTS are passed starting at the fourth argument.J     If no arguments are specified using /ARGUMENTS the remaining arguments$     are passed as null strings ('').  J     To    invoke     programs    that    do    not    conform    to    theJ     SYS$INPUT/SYS$OUTPUT/SYS$ERROR  calling  convention -  or to specify aJ     different terminal than the one you are currently using -  specify the$     /NOSTANDARD_ARGUMENTS qualifier.   /DEBUG  
     /DEBUG     /NODEBUG (default)  J     Controls whether the VAXELN debugger (EDEBUG) is to get control of theJ     program when  it  is started.  If you specify /DEBUG, debugger support0     must have been built into the VAXELN system.  
 /JOB_PRIORITYu       /JOB_PRIORITY=nh  I     Specifies the starting job priority for the program.  The value for na,     can be from 0 to 31.  The default is 16.  
 /KERNEL_STACK        /KERNEL_STACK=nf  I     Specifies  the  size (n), in pages, of the kernel mode stack for jobsOI     running  this  program.  User  mode  programs require at least 1 paget"     (the default) of kernel stack.   /MESSAGE_LIMIT       /MESSAGE_LIMIT=n  J     Specifies the maximum number of messages the job port can contain; the     default is 0.d   /MODEm       /MODE=option  J     Specifies the mode in which the program is to run. The options you can     specify are: U    @     KERNEL        Specifies the program is to run in kernel mode  >     USER          Specified the program is to run in user mode   /POWER_RECOVERY        /POWER_RECOVERY)     /NOPOWER_RECOVERY (default)r  I     Specifies  whether  the  job  running  the specified program is to be I     given the  power recovery exception if the power fails on the system.O   /PROCESS_PRIORITY        /PROCESS_PRIORITY=ne  H     Specifies  the  starting  process priority (n) for the program.  TheI     value   for   n   can   be   from   0  to  15.  The  default  is  8. t  
 /PROGRAM_NAMEe       /PROGRAM_NAME=prg-name  I     Specifies the name by which the program will be known.  If you do not I     specify the  /PROGRAM_NAME  qualifier, the image name supplied by the "     linker is used as the default.   /STANDARD_ARGUMENTS2  !     /STANDARD_ARGUMENTS (default)D     /NOSTANDARD_ARGUMENTSE  H     Controls  whether the first three  program  arguments  passed to theH     program  give  the  name  of  the user's  terminal.  By default, theH     terminal  names are passed, and correspond to SYS$INPUT, SYS$OUTPUT,H     and  SYS$ERROR  respectively.  Any  program arguments passed in  theH     EXECUTE  command are passed starting at the fourth program argument.  H     Use   /NOSTANDARD_ARGUMENTS   to  prevent   RUN  from   passing  theH     terminal  name  as  the  first   three    program   arguments.    IfH     /NOSTANDARD_ARGUMENTS  is  specified, any arguments you specify withH     the  /ARGUMENTS  qualifier are  passed starting at the first program     argument. (See examples.)t   /USER_STACKo       /USER_STACK=n   H     Specifies the initial size (n), in pages, of the user mode stack forH     jobs  running  this  program.  Programs require at least 1 page (theH     default) of user  stack.  This  qualifier is ignored for kernel mode
     programs. 
 2 Examples        1.  ECL> RUN TEST  I           The image TEST.EXE is executed.  The command language waits for I           the program  to complete before prompting for the next command.   E      2.  ECL> EXECUTE EXAMPLE/ARGUMENTS=(PARAMETER1, PARAMETER2)/WAITe  J           The  RUN  command  invokes  the program EXAMPLE and waits for itJ           to  complete before requesting the next command to process.  TheJ           command passes the terminal that the command language is runningJ                                                                                                                                                                                                                                          D                        (7E7 $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                                   ~           on as the first three program arguments  (SYS$INPUT, SYS$OUTPUT,K           and   SYS$ERROR  respectively).   The arguments  PARAMETER1  and sJ           PARAMETER2 are passed as the fourth and fifth program arguments.  E           The program arguments that the program EXAMPLE receives is:   -             Program_argument[1]  = "CONSOLE:"i-             Program_argument[2]  = "CONSOLE:"l-             Program_argument[3]  = "CONSOLE:"_/             Program_argument[4]  = "PARAMETER1"N/             Program_argument[5]  = "PARAMETER2"i%             Program_argument[6]  = ""E%             Program_argument[7]  = ""e%             Program_argument[8]  = "" %             Program_argument[9]  = ""t%             Program_argument[10] = ""t%             Program_argument[11] = ""   I      3.  ECL> RUN/NOSTANDARD_ARGUMENTS EXAMPLE/ARGUMENTS=(PARAM1, PARAM2)   G           The  RUN command invokes the program EXAMPLE and waits for it G           to complete before requesting the next  command  to  process.rG           The qualifier /NOSTANDARD_ARGUMENTS suppresses the passing of.G           the terminal on which the command language  is  running on as,G           the  first three program arguments.  The arguments PARAM1 andpH           PARAM2  are  passed as the first and second program arguments.  E           The program arguments that the program EXAMPLE receives is:i  *             Program_argument[1] = "PARAM1"*             Program_argument[2] = "PARAM2"$             Program_argument[3] = ""$             Program_argument[4] = ""$             Program_argument[5] = ""$             Program_argument[6] = ""$             Program_argument[7] = ""$             Program_argument[8] = "" 1 SET   I     Defines or changes, for the current terminal session, characteristics )     associated with files and the system.s       Format:i         SET option	 2 DEFAULTe  F     Changes the default device and/or directory name.  The new defaultF     is  applied  to  all  subsequent  file  specifications that do not<     explicitly  include  a  device  and/or  directory  name.       Format:M         SET DEFAULT device-nameb 3 Parameter        device-name,  H     Specifies  the  device  and/or  a  directory  name to be used as the?     default  device  and  directory  in  file  specifications. G  H     If you specify a physical device name,  terminate  the  device  nameH     with  a colon.  If you specify a directory name, you must enclose it     in square brackets.a  H     You can  use  the  minus  sign  as  a  directory-searching  wildcard-     character in the directory specification.o	 3 Examplea  ,      ECL> SET DEFAULT DISK$EXAMPLE:[FOO.BAR]      ECL> DIRECTORYf  %      Directory DISK$EXAMPLE:[FOO.BAR]   &      AVERAGE.DAT;2       AVERAGE.DAT;1        Total of 2 files.  H           The SET DEFAULT command changes the default file specificationH           to  be  the  directory [FOO.BAR] and the device DISK$EXAMPLE:.H           The directory and device DISK$EXAMPLE:[FOO.BAR] are assumed toH           be  the  default  for  subsequent file operations, such as the$           directory operation shown. 2 FILE  +     Modifies the characteristics of a file.e       Format:          SET FILE file-spec   3 Parameterd  
     file-specd  &     Specifies the file to be modified.  D     If you omit either the file name or the file type, the  SET FILED     command  does  not  supply  any  defaults; the file name or fileD     type  is  null. If you do not specify a file version number, theD     version number defaults to the file with highest ver             sion number.  D     If the device or directory is not specified, you current default&     device  and  directory  are  used.  E     No  wildcard  characters  are allowed  in the file specification.  3 Command_Qualifiers   /LOG       /LOG     /NOLOG (default)  D     Controls  whether  the   SET FILE   command  displays  the  file7     specification  after  it  has  modified  the  file.h  
 /OWNER_UIC       /OWNER_UIC=uic  D     Sets the owner user identification code (UIC) of the file to the     specified UIC.  .     Specify the UIC using standard UIC format.   /PROTECTION        /PROTECTION=code  D     Allows  you  to  change  the  protection  status  of  the  file.  D     Specify  the  code  according  to  the standard syntax rules for     specifying  protection. 
 3 Examples  1      1.  ECL> SET FILE/OWNER_UIC=[1,1] MYFILE.DATV  H           The  SET FILE  command  modifies  the owner UIC of the highest4           version  of  the  file  named  MYFILE.DAT.    J      2.  ECL> SET FILE/PROTECTION=(SYSTEM:R,OWNER:RWED,GROUP:RW) PAYRL.LIS  I           The  SET FILE  command  changes  the  protection codes applied mI           to  the  highest  version  of  the  file named PAYRL.LIS.  The  H           command gives  the  system  read-only  access; the owner read,H           write,  execute,  and  delete access; and users in the owner'sH           group read and write access, but the world is denied all types           of access. 2 HOST  C     Connects your terminal (through the current host processor) to eC     another processor called the remote processor. Both processors       must be running DECnet.n       Format:f         SET HOST nodet 3 Parameters       node  I     Specifies the DECnet area and node number of the remote network node.   	 3 Exampler        1.  ECL> SET HOST 25.432  	eA           This set host command connects the user terminal to theM/           processor at the network node 25.432.  2 ON  D     Controls whether the command interpreter performs error checkingB     following the execution of each command in a command file. TheE     SET ON command causes a command procedure to abort when a commandiD     or image returns an error. The SET NOON command permits command C     procedures to continue executing no matter how many errors are e$     returned. SET ON is the default.       Format:          SET [NO]ON
 3 Examples        1.  ECL> SET ON 	 J           The SET ON command enables error checking of command procedures.        2.  ECL> SET NOON 	cA           The SET NOON command disables error checking of command            procedures.a 2 PROTECTION  G     Establishes the protection to be applied to a file.  The protection H     of  a  file  limits  the  type of access  available to system users.       Format:r  '       SET PROTECTION[=(code)] file-spec  3 Parameters       code  H     Defines the protection to be applied to the specified file.  SpecifyB     the  protection  code  in  standard  protection  code  format.    
     file-speci  I     Specifies  the  file  for  which  the  protection  is  to be changed.p  I     If you omit either the file name or the file type, the SET PROTECTIONTI     command  does  not  supply  any  defaults;  the  file  name  or  filetI     type  is  null.  If  you  do  not  specify a file version number, theTI     version  number  defaults  to  the  file with highest version number.s  I     If  the  device or  directory  is  not specified, you current defaulth&     device  and  directory  are  used.  I     No  wildcard  characters  are  allowed  in  the  file  specification.B 3 Command_Qualifiers   /LOG       /LOG     /NOLOG (default)  I     Controls   whether  the   SET PROTECTION  command  displays  the fileh7     specification  after  it  has  modified  the  file.f   /PROTECTIONe       /PROTECTION=code  J     Defines  the  protection code to be applied to the file specification.J     If  you  specify the command's code parameter in addition to using theJ     /PROTECTION   qualifier  with  a  file  specification, the  attributes?     specified  with  the  /PROTECTION  qualifier  are  applied.M  J     Specify the code according to the standard syntax rules for specifying     protection.y  
 3 Examples  !      1.  ECL> DELETE INCOME.DAT;3pG          %DELETE-W-FILNOTDEL error deleting DUA0:[EXAMPLES]INCOME.DAT;3eH          -ELN-F-PRV, insufficient privilege or file protection violation1          ECL> SET PROTECTION=OWNER:D INCOME.DAT;3c!          ECL> DELETE INCOME.DAT;3t 	sH           The  file  INCOME.DAT;3  has  been protected against deletion.H           This  set  PROTECTION  command  changes  the owner's access toH           delete  for  the file  INCOME.DAT;3 only.  Now the file can be           deleted.  E      2.  ECL> SET PROTECTION=(SYSTEM:R,OWNER:RWED,GROUP:RW) PAYRL.LISM  H           The  SET PROTECTION  command  changes  the  protection   codesH           applied to  the  highest  version of the file named PAYRL.LIS.H           The command gives the system read-only access; the owner read,H           write,  execute,  and  delet                                                                                                                                                                                                                                   E                        q8 $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                             c             e access; and users in the owner'sH           group read and write access, but the world is denied all types           of access.
 2 TERMINAL  H     Changes the system's interpretation of the terminal characteristics.  %                                  NOTEN%                                  ----e  G     Due to hardware constraints, the setting of certain characteristicseL     may be prohibited by certain terminal drivers. However, no error messageI     is displayed in these situations. For verification, a subsequent SHOW $     TERMINAL command may be entered.       Format:S  #       SET TERMINAL [device-name[:]]r 3 Parameters       device-name   K     Must be a valid terminal device-name. If the parameter is omitted, the  G     terminal device will be the terminal on which the user entered the h     command. 3 Command_Qualifiers   /CHARACTER_SIZE=size       /CHARACTER_SIZE=size  F     Specifies the number of bits that comprise a character. Valid size     values are 5,6,7,8.d   /ECHOe  	     /ECHOr                  /NOECHOx  I     Controls whether the terminal echoes (that is, displays) all keyboard      characters.u  H     When /NOECHO is set, the terminal displays only data that  a  systemB     or user application program writes to it. It does not echo any     keyboard characters.  
 /EIGHT_BIT       /EIGHT_BIT     /NOEIGHT_BIT  F     Indicates whether the terminal uses an 8-bit ASCII character code.   /ESCAPEp       /ESCAPE      /NOESCAPE   H     Controls whether ANSI standard escape sequences transmitted from theC     terminal are handled as a single multiple-character terminator.n  H     If you specify the /ESCAPE qualifier, the terminal driver checks theC     escape sequences for syntax before passing them to the program.    /INSERT        /INSERT   F     Sets  the terminal to /INSERT mode.  This  feature  allows you to F     insert characters when you are editing command lines. The default      mode is /OVERSTRIKE.  
 /LINE_EDITING        /LINE_EDITINGu     /NOLINE_EDITING   @     Enables the line editing features for editing command lines.   /OVERSTRIKE6       /OVERSTRIKE   H     Sets the terminal to /OVERSTRIKE mode. This feature  allows  you to H     type over the current character when you are editing a command line.     This is the default mode.]   /PARITY        /PARITY[=option]
     /NOPARITYA  E     Defines the parity for the terminal.  You can specify one of  thee     following options:              SPACE            ODD            EVENh            MARKt            IGNORE   H     If you use the /PARITY qualifier without an option, the SET TERMINAL!     command assumes /PARITY=EVEN.    /PASSALL       /PASSALL     /NOPASSALL  F     If you specify /PASSALL, all characters including XON and XOFF are>     passed through the terminal driver without interpretation. 	 	 /PASSTHRUg       /PASSTHRU      /NOPASSTHRU   H     Controls whether the system interprets special characters or passes 6     all data to an application program as binary data.   /SPEED       /SPEED=rateg  E     Specifies the rate at which the terminal sends and receives data.r  E     The rate value indicates  the input (terminal to host) and output $     (host to terminal) baud  rates.     9     The valid values for input and output baud rates are:e  9             50           150          1800           4800o9             75           300          2000           7200e9            110           600          2400           9600s9            134          1200          3600          19200o          38400   /SCOPE  
     /SCOPE     /NOSCOPE  H     Indicates whether the terminal is a video terminal, and thus how  itH     reacts   when  certain  keys  are  pressed.   The  /SCOPE  qualifierH     establishes the terminal as a video terminal.  Thus, when you  pressH     the  DELETE  key, the printing position is moved left one column and7     the character displayed in that position is erased.r   /TTSYNC,       /TTSYNCs
     /NOTTSYNCu  H     Controls whether the system responds to a CTRL/S  or  CTRL/Q  issued5     from the terminal in order to synchronize output.a  H     The default is /TTSYNC; the system stops sending output when  CTRL/SE     is sent by the terminal and resumes output when a CTRL/Q is sent.D   /WIDTH  
     /WIDTH=n    G     Specifies the number of characters on each input output line of an a     ECL command line.    /WRAP   
     /WRAP      /NOWRAP   F     Controls whether or not a carriage  return/line  feed is generatedF     when an ECL command reaches the end of the line. The end of a line7     is determined by the setting of the terminal width.   
 3 Examples  ,       1. ECL> SET TERMINAL/NOEIGHT_BIT TTA1:'       2. ECL> SET TERMINAL/NOECHO TTA0:I     2 TIME  @     Resets  the  system  time.  The  system  time  is  used  for>     all  time-dependent   activities  in  the  VAXELN  system.       Format:E         SET TIME=timet   3 Parameterd       time  A     Specifies the date, time or both, using the standard absolutevA     time  format.   The  absolute  time  format  is  as  follows:g  +              [dd-mmm-yyyy[:]] [hh:mm:ss.cc]r	 3 Exampleo  &      ECL> SET TIME=3-FEB-1987 03:21:24      ECL> SHOW TIMEr        3-FEB-1987 03:21:24.50h  ;           The  SET TIME command sets the system time to theu;           specified time.  The SHOW TIME command requests at&           display of the current time. 2 UICy  J     Establishes a new user identification code (UIC) as the  default.  UseJ     the SET UIC command to gain access to a restricted file,  that  is,  aJ     file contained in a directory whose protection restricts access to the     owner of that directory.       Format:O         SET UIC uicl 3 Parameter        uice  H     Specifies the group number and member number.  Specify the UIC using     standard UIC format.
 3 Examples        1.  ECL> SET UIC [370,10]  J           This  command  establishes  your  UIC  as [370,10].  You can nowJ           read or modify any files whose access is restricted to this UIC.          2.  ECL> SET UIC [214,4] $          ECL> SET DEFAULT [ANDERSON]  J           The  SET UIC  command  sets your UIC to [214,4]; the SET DEFAULTA           command  sets  the  default  directory  to  [ANDERSON].  2 VERIFY  <     Controls whether command lines and data lines in command<     procedures are displayed. The SET VERIFY command can be ,     useful in debugging a command procedure.       Format:          SET [NO]VERIFY	 3 Example,        1. ECL> SET VERIFYl   1 SHOW  C     Displays information about the current defaults of the terminalu     session, and of the system.n       Format:          SHOW optionc	 2 DEFAULT   D     Displays  the current default device and directory names.  TheseD     defaults are applied whenever you omit a device and/or directory#     name from a file specification.        Format:m         SHOW DEFAULT	 3 Example.        ECL> SHOW DEFAULT$        DISK$DEFAULT_VOLUME:[EXAMPLE]  D           The SHOW DEFAULT command requests a display of the current-           default device and directory names.r	 2 DEVICES   I     Displays  information  about  a  device  configured  in  the  system.   K     The  SHOW DEVICES  command  does  not verify the presence of the deviceiK     hardware  or the  validity of  the  System  Builder device information.tK     Device drivers perform such varification and typically raise exceptions !     if  the  verification  fails.        Format:   #       SHOW DEVICES [device-name[:]]  3 ParameterE       device-name[:]  L     Specifies  the  name  of  a  device  for  which  information  is  to  beL     displayed.  You  can specify  a complete  device  name or only a portionM     of  a  device name.  If  you  truncate a device name the  command  lists pM     information  about  all   devices   whose  names  begin  with  what  you sL     entered -  possibly  a generic class of devices, depending on the use ofL     device-naming conventions in the system.  For example, if you specify D,L     SHOW DEVICES  lists  all  the  devices  whose device names begin with D.   L     If you  omit this parameter, the SHOW DEVICES command provides a listing2     of  all  devices  configured  in  the  system.  
 3 Examples        1.  ECL> SHOW DEVICESI          Device                CSR       Vector   IPL     BI      Adapter I           Name               Address                     Number    Number 5          DUA                  772150       154      4s5          XQA                  774440       120      4 5          CONSOLE              000000       370      4n   B              The SHOW DEVICES command displays information for a                                                                                                                                                                                                                                   F                        q $      ELN042.D                       N  
  $[SYSEXE.SEAS$WORK_0000005C]ECL.HLP;1                                                                                           O                             )             llB              devices  configured  in  a  non-VAXBI  target system.  B              The  information  displayed,  for  each device, is as              follows:    F               o  Device name -  the   name   of   device   controller.   H               o  Device CSR address - the  physical  address,  in octal,H                  of   the   device's   first  device  control  register.   H               o  Device Vector number -  the  device's  first  interrupt#                  vector  in  octal.    E               o  Device  Interrupt  Priority  (IPL)  -  The  device's H                  bus-request priority,  an  integer  in the range 4 to 7H                  that corresponds  to  the VAX interrupt priority levels;                  14(hexadecimal)  through  17(hexadecimal).    H               o  BI number - the  number  of  the VAXBI bus on which theH                  device is  located,  if  applicable - an integer in the!                  range  0  to  4.C   H               o  BI adapter number - the  number of the VAXBI adapter onH                  which the device is located, if applicable - an integer4                  in  the  range  0  to  15(decimal).          2.  ECL> SHOW DEVICESI          Device                CSR       Vector   IPL     BI      AdapterPI           Name               Address                     Number    Number F          DUA                  000000       000     5       2         0F          XBA                  000000       000     4       2         7F          CONSOLE              000000       370     4       0         0   E              The SHOW DEVICES command displays  information  for  alls7              devices  configured  in  a  VAXBI  target.     #      3.  ECL> SHOW DEVICES CONSOLE: I          Device                CSR       Vector   IPL     BI      Adapter I           Name               Address                     Number    Number 5          CONSOLE              000000       370      4r  E              The SHOW DEVICES command  displays information  for  then              device CONSOLE:.N
 2 NAME_SERVERb  I     Displays status of a name server node. A name server may be the localeI     node, or a remote node on the network. If the name server is a remotepE     node, the Ethernet address and Decnet area and node number of the "     remote node will be displayed.	 3 Exampleo       SHOW NAME_SERVER   2 SYMBOL  A     Displays the current value of a symbol.  Symbols are defined t7     using the assignment statement :==  .  For example:7  *              ECL>  list :== directory/full       All symbols are global.a       Format:i  !       SHOW SYMBOL   [symbol-name]c 3 Parameter        symbol-name,  F     Specifies  the  name  of   a symbol  for  which  information  is  E     to be displayed.  Wildcards are not permitted.  You must specify       the entire name.  BE     If you  omit this parameter, the SHOW SYMBOL command prompts you tG     for a symbol name.  In response to the prompt, enter a symbol name       or the /ALL qualifier. 3 Command_Qualifierr   /ALL       /ALL  H     Requests that the current values of all symbols in the symbol table      be displayed.  S  
 2 TERMINAL  E     Displays the current characteristics of a specific terminal. EachpC     character corresponds to an option of the SET TERMINAL command.        Format:   $       SHOW TERMINAL [device-name[:]] 3 Parametere       device-name[:]  9     Must be a valid terminal device-name. The device nameR<     CONSOLE, however, may be used only on the Microvax 2000.  @     If the parameter is omitted, the terminal device will be theD     terminal on which the user entered the command. If the parameter=     is omitted and the terminal is the console, an error willh2     occur on all systems except the Microvax 2000.	 3 Exampleh       ECL> SHOW TERMINAL TTA1:       Terminal: TTA1  8       Speed:  none   Parity: None      Character size: 8       Width:  80  6       Echo           Escape            TTsync         6       Scope          No Eightbit       No Passall     -       Over Strike    Wrap	       Line EditingI       No Passthrut   2 TIME  E     Displays the current date and time.  The DAY element is optional.        Format:N         SHOW [DAY]TIME	 3 ExampleS        ECL> SHOW TIMEl        3-FEB-1987 17:21:24.13s  B           The SHOW TIME command displays the current date and time           at the terminal. 2 UIC   8     Displays the current user identification code (UIC).       Format:          SHOW UIC	 3 Examplei        ECL> SET UIC [1,1]       ECL> SHOW UIC        UIC = [1,1]  @           The SET UIC command establishes your UIC as [1,1]; the@           SHOW UIC  command  displays  the  current default UIC. 1 TYPE  A     Displays the contents of a file on the current output device.a       Format:r         TYPE file-spec 2 Parameter   
     file-spec0  G     Specifies the file to be displayed.  If you specify a file name andeG     do  not specify a file type, the TYPE command uses the default file1     type of LIS.  G     If you omit the directory specification or device name, the currentN-     default device and directory are assumed.   +     No  wildcard  characters  are  allowed. 	 2 Examplea            ECL> TYPE COMMON.DATC  ?           The TYPE command requests that the file COMMON.DAT beT$           displayed at the terminal. 1 UNLOAD  >     Unloads a specified program from the system.  The /PROGRAM     qualifier is required.       Format:T         UNLOAD/PROGRAM prog-name 2 Parametero  
     prog-namee  L     Specifies  the  name  of the program to be removed from the system.  TheL     program must already be installed in the system (via the System Builder,C     the  LOAD/PROGRAM  command,  or  the  LOAD_PROGRAM  procedure).t	 2 ExampleL  !          ECL> UNLOAD/PROGRAM TESTn  B           The  UNLOAD/PROGRAM  command  removes  the  program TEST%           from  the  running  system.A !  ! HELP TEXT FILE Description:  !o ! Restriction(s):o ! G !	1. All level 1 help must be in alphabetical order for wildcarding to  A !	   work.  Qualifiers and level 2 help and lower need not be in t !	   alphabetical order. ! G !	2. There must always be a blank line after a level or a qualifier. IfLE !	   no blank line separates the level and the text the first line ofm$ !	   the text will not be displayed. ! D !	3. If a ninth level is added it will be displayed as text when the, !	   text for the eighth level is displayed.                                                                                                                                                                          ) * [SYSEXE.SEAS$WORK_0000005C]EDISPLAY.EXE;1 +  , O   . 3    /     4     3   4                     - 
    0   1    2   3      K  P   W   O 4    5   6  z  7 @i]  8          9          G    H  J                       0 D X     0205      (  `                                             EDISPLAY                               VAXELN V4.2-00 % 05-05                                         -            F        G   
  2     ?   "      !        
DPASCALIO_001      !        DAP_001"      !         
ELNACCESS_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001                       A       FOUT                                                A       FIN                             EDISPLAY.HLP   ƭ        " 8 x       ʮ خ  L& P&   N \ j v                    "     < \&     4$             $ $ $ $ $ Ĭ$ Ь$     $ l&      $             n$ |$ ( DISK$DEFAULT_VOLUME:[000000]EDISPLAY.HLP " 8 x       ʮ خ  L& P&   N \ j v                    "     < \&     4$             $ $ $ $ $ Ĭ$ Ь$     $ l&      $             n$ |$                                                                   
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             G                        %I $      ELN042.D                       O  
  )[SYSEXE.SEAS$WORK_0000005C]EDISPLAY.EXE;1                                                                                           3                         L8 "                                                                                                                                                                                                                                                                                                                                                                                        \1            1                  1                                                                                                            ?25l0 ::1_CONSOLECONSOLE:[24;1H?25h[0K[1DOQ28~[28~<D[D4~C[4~[CP5~[5~N6~[6~ -- press RETURN key to continue.EDISPLAY-E-.:ARGUMENT, Invalid argument --RRARATRATEJJOJOBSSESETSETUSETUPMMEMEMMEMOMEMORMEMORY                                                                	

 !"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`ABCDEFGHIJKLMNOPQRSTUVWXYZ{|}~SUSPENDEDWAIT     RUN      READY                                   *PROC        WAIT RUN  READYUK[0J)>JOB, Invalid job number.                              ?? Job#RATE, Invalid display rate<dddd hh:mm:ss.cc> DP29~OP[29~=Exit HelpKEYSHelpDisplay Rate[0m HELP MENU SETUP MENUEDISPLAY [1;7mH;[                           Exit EdisplayMemory DisplayJob Display[2K[1;1H[9;47HState[9;55HRuntime[9;1HJob# Program_name Mode Pri[9;28HStack   Pages[8;5H(Proc-name/ID)[8;34HR/W   R/O[9;40HState[9;52HRuntime[8;28HR/W   R/O[9;1HJob# Program_name Mode Pri   Pages[5;40HS0-REGION:[6;40HJOB-SLOTS:[7;40HPROCESS-SLOTS:[5;1HPAGES:[6;1HPOOL:CPU[2;26HIDLE:[1;1HVAXELN - [1;26HUP:
MOM ^VBA[B[A>Press RETURN to continue...   For more help, select and activate the HELP entry in the setup display.   entry.    a menu entry and use the RETURN or ENTER key to activate that    or type > or S. Use the up-arrow and down-arrow keys to select    To access the setup display, press the SELECT or right-arrow key    job display shows statistics about a job and its processes.    and slot table usage -- and identifies the jobs in the system. The    display shows system-level information -- such as memory, pool,    screen refresh rate, get help, or exit EDISPLAY. The memory    The setup display lets you switch between displays, change the    EDISPLAY offers three types of displays: setup, memory and job.		Left-arrow, <	Go to memory display		SELECT		Right-arrow, >,	Go to setup display		NEXT SCREEN		Up-arrow, ^,	Display next set of jobs		PREV SCREEN		Down-arrow, v,	Display previous set of jobs    Memory and Job Display 		PF1		DO, D,		Exit (execute) setup display		ENTER		RETURN		Select menu item 		Down-arrow, v	Move down 1 menu item		Up-arrow, ^	Move up 1 menu item    Setup Display        Available function keys are as follows:    function keys.    You move between or within displays by pressing screen manipulation 	       -  CPU time used by process	       -  Process size	       -  Stack size	       -  Process priority		  the process in the process list 	       -  Process name or *PROCn, where n indicates the position of    display shows the following information for each process:    state (identical to the memory display). The lower portion of the    The upper portion of the display provides details about the system    The JOB display shows statistics for a job and its processes.        causes EDISPLAY to show statistics for the job whose number is 2.        JOB DISPLAY  ?? Job#   2    Example     the job for which you want statistics displayed.    When you select Job Display, EDISPLAY prompts you for the number of    The Job Display entry on the setup menu identifies a job for viewing.	       -  CPU time used by job	       -  Job state	       -  Program size: Read/Write pages and Read-Only pages	       -  Job priority	       -  Processor mode: kernel (K) or user (U)	       -  Program name	       -  Job number	    o  For each job loaded into the system:	    o  S0, JOB and PROCESS slot table usage	    o  Memory and pool usage	    o  Date and time	    o  Processor up time and idle time	    o  DECnet node name and number	    o  Operating system and version     display information includes the following:    information and identifies the jobs in the system. Memory      The Memory Display entry on the setup menu shows system-level	  -- omitted fields default to zero. 	  Refreshes the terminal screen once every 3.5 seconds      2  DISPLAY RATE: <dddd hh:mm:ss.cc>  0 ::3.5 	  Refreshes the terminal screen once every 3.5 seconds.     1  DISPLAY RATE: <dddd hh:mm:ss.cc>  0 00:00:3.5   Examples	     cc   - hundredths of a second (0 to 99)	     ss   - seconds (0 to 59)	     mm   - minutes (0 to 59)	     hh   - hours (0 to 23)      where: dddd - days (0 to 9999)        dddd hh:mm:ss.cc    Format    Changes the terminal screen refresh rate. [2JEXIT, Job exited or was deleted ^\Z j.(Z \ l. ̂.߭߭߭. fF  Э0/Э,/Э4/߭߭߭  >F  Э</Э8/Э@/߭߭߭ F  ЭP/ЭL/߭߭߭ E  ЭX/ЭT/Ο D/<" RxRH/﬽\X}  z. k~̄.R ҟ4 ҟ0 b̄.  TySS̈.T1̄.S1TySS ̄.S ̈.T T̈.S̄.̄.  ̈.1 П R~B0 S~̄.R ңcb̄.  WyVV̈.W6̄.V/TySS~̄.R bS آT T̈.S̄.̄.  ̈.QeP
PRB̌.S<cR~B0 T~R Ҥdb֣  ѣW-ѣV'UyTT T أU UT֣  QPr.  |~  ϭRR̛!A  P/X*R%cB  P
X|~ XP<^|HH  mŻ\̴  Ϯ<Xt-p-|~  R R߭ ѭ((ϔ6̿̹Xn-
j-  ̂߭G  }P̬|~ 1h@\^޼V V_G  V9 6 6 6 6 4	6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 1.\(.^ \-
\(
Ϭ^ \-\(x^ \ϸ-$\($8^ \Ϝ-\( ^ \π-\(^ \d-\(ό^ 	\H--\(-C^ 
\,-
\(
^ \-6\(6^ \,8\(8w^ \,2\(2)^ \ϼ,8\(8^ \Ϡ,&\(&ϓ^ \τ,mE  1gA\(A #^ \U,?\(?^ \9,/\(/}^ \,%\(%<^ \,#\(#^ \+'\('Ϻ^ \+\(ω^ \ϭ+\(P^ 	\ϑ+,\(,^ 
\u+,\(,^ \Y+\(Ϗ^ \=+\(\^ 
\!+1\(1^ \+\(^ \*=\(=σ^ \*\(S^ \ϱ*\(^ \ϕ*~C  1xI\(I Ϡ^ \f*G\(G :^ \G*4\(4^ \+*\(^ \* \( φ^ \)I\(I ^ 	\)A\(A Ͼ^ \ϵ)F\(F Y^ \ϖ)E\(E ^ 
\w)=\(=Ϝ^ \[)D\(D 9^ \<)$\($^ \ )\(^ \)\(ϑ^ \(\(^^ \(#\(#^ \ϰ(A  1H\(H Ϩ^ \ρ(\(z^ \e(+\(+3^ \I(\^ \.( \(\(^ \(!\(!ϛ^ \'%\(%Z^ 	\'\(#^ 
\ϯ'\( ^ \ϓ'&\(&Ͼ^ \w'\(ϝ^ 
\['\(f^ \?'-\(-^ \#'
\(
^ \''\('ϱ^ \&
\(
ψ^ \&%\(%G^ \ϳ&\}$^ \Ϙ&$\($^ \|&e?  1_C\(C r^ \M&B\(B ^ \.&?\(?϶^ \&C\(C T^ \%F\(F ^ \%?\(?ϔ^ \ϸ%D\(D 1^ \ϙ%B\(B ^ 	\z%A\(A p^ 
\[%	\(	K^ \?%J\(J ^ 
\ %X	>  V[ <	>  /=   w=  =   /- F1M^MX V魭1WW1[] V[N$VRR,PP P(S2SRR RN=  A<   /- |x\-\ b:-\ T/-\ G$-\ :-\ .-\ "1 	 V	{#d<  T-T -T -T                                                                                                                                                                                                                                                   H                         $      ELN042.D                       O  
  )[SYSEXE.SEAS$WORK_0000005C]EDISPLAY.EXE;1                                                                                           3                         } "             VVVT-T -T ϱ-T Ϣ;VV3V.-\ φ-\ y-\ m
WVsW1{譭1Y|^|;  mh\̴  Q0Xn-j-|~  ̹̺̹ ̿1 r{;  
1~ ϳS;  ̒P P(̔ 
"  a<
;  u(D㭢 !Qޟ PSR :  (S2SRR R:  ::   Ϲ:  7 k7h:  08 8yJ:   b3:  E$ ϧ$I:  4 \42:   +9  ̿VV L ϟV ; A	V  9  t9  Xt-1p-  1T^V޼XRRRXR1 RS2SRR RW(9   F@9  WW\(^ \W\(^ \ϳW
\(
Ϲ^ \ϑ ^޼޼޼(t߭쟭ݭݭQ(찭S2SRR RuF8  S2SRR RX)8  (^޼޼޼V	f(	ަЭܭQޭPSR 8  , W:MfP<fWPWϮGWЭQޭPSR 7  , GRbR:fP<fRPReBRPX^W޼X KT7   'l=7  (	
ޭǒRRG GR	R(RǔV 
X$\(^2VR
R R\'X"
\(
Ϗ^2VR
R R\Ϥ k6  \(F^ \qX\(ǂ^ \Q\(j^ \5\(\^ \\^ 
\X\ϫ^ 	
\X
\(
^ \Ͼ!X	\(	_^ \ϛ5  Þ^.W '~5    ϱǿǹ1	 XYY1	ϼ XXRRPP P(S2SRR R4  
4   &V-V B
 >1-V ):-V /-V $-V -V -V 1 ͙͗ X͗Bz+4  T-T ϵ-T Ϧ-T ϚXXXT-T ψ-T x-T i1.XX1#X1-V n,-V `!-V Q-V D-V 8"Yǿǹ1-V T-T -T 1X  U   1\
S2SRR RG3   603  
͗(
͙ ͗ϱS2SRR R2   2   x2  ͗(1͙ ͗\ #[2  ( )a2  (XS2SRR Rg
2  $\-\ t
 p1%R:[\P<\RPRRVR:B\P<\RPRRVVR:'\P<\RPRRVVR:\P<\RPRRVVR:	\P<\RPRRVVRR(쭐2\RRVRRP P(F\\́́́(́̓́pP1 E(XGEϮ<XϺ<S2SRR >R0   0   ͗χ͗(ǂ͙ ͗kT0  1,\ ǂT-T /-T $-T -T -T ϻ1eYǿǹ1CXω /  ͗(͙ ͗ϸ /  /  1X j/  ͗(ϑ͙ ͗N |M/  E(ϒG EN.  XS2SRR Rg.   V-V a
 ]1R:HVP<VRPRR\R:/VP<VRPRR\\R:VP<VRPRR\\R:VP<VRPRR\\R:VP<VRPRR\\RR

(୐2VRR\RRP P(LV-V τe<X<S2SRR >R-   -   ͗Ϫ-  \1 \TTS2VURR@   RUTSST1 2Vm-  UU<& RURb\UT-T ,-T Ͻ!-T Ϯ-T ϡ-T ϕYǿǹ\1͗(͙͗ϊ<Xϖ<S2SRR >R,   Ͻ,  ͗(ϙ͙ ͗V?,  1  ϕ 1 X ^/,  
͗(
%͙ ͗ ++  +  Ǩ  ǰ     Y1 +  {+  Ǩ  Þ^\-v-x- j.l.	 ̺1 j.v-
(j.l.x-v-P P(x- ̂.̎-̏-R߭(Rϧ 
̎-R߭.ݭRϏѭ ݭ}r.~- ~-5}z.̆-2̆-!}̄.̐- ̐-
 1 XRRRY1 W(ϯҭЭV VXCWR<B̌.QޭPSR I*  (S2SRR R5*  :$)  
WSC̚-TC̎.R}bdV~XdBѭK   XYWP8.,/ ̺K(,/8.߭ 8.!߭/ݭ@.߭/ݭ<.P.D/ ̺7ϡ}D/P.߭ P.߭/ݭT.ϵD.8/ ̺K8[(8/D.߭ 8D.ρ߭/ݭL.n߭/ݭH.[X.L/ ̺78}L/X.߭ 8X.(߭/ݭ\.`.T/ ̺68ϻ}T/`.߭ 8`.
 /ݭd.
ϞH^W[ Ǻ ǽ2Ǜ!

 Ǻ> ǽ82Ǜ!SS
RRS2Ǜ!
RRR ǺC2Ǜ!RR7R'2Ǜ!Ǽ
RRR Ǽ1 ǼVV
n
VRR
2Ǜ!RR
Ǻ
S2SRR R9
'   "&  1 Vy8*
ǹǽ
ωS2SRR R&   ϡ}&  Ǭ  1 ǻ1 ǻ2Ǜ!RR	1 Ǻ
S2SRR RL&   *5&  
2Ǜ!RR0#ǹǬ  12Ǜ!2Ǜ!ZǽRLRL1RYZ5YRB\Bǝ!Rlb Ǻ}[
ZXXϾ5YVFǝ!Rbl<lR  XR
FǮ!Rb""(Fǰ!RP RPR(RTXR5YRBǠ![Q5YRBǠ!R!RT
ZR RRϣRT
ZR RRς5YRBǡ![-
ZVV5YRBǡ!R  VR	5YRBǢ!ScBǬ!Rb[M
ZV	Vχ5YRBǢ!ScBǬ!Rb<R  VRϜ	<R  "VRω	5YRBǟ![1 5YRBǟ!R R(T
ZR (RRϕ
RR R(ϡT
ZR (RRl
RR R(sT
ZR (RRC
5YRBǤ!RѬ	Ѭb[Z5YRBǤ!R}bTySSѬTѬSSyRR R S ҬҬ֭  
ZR/RR	[LYH
RRKRRRϏ갭S2SRR R"   ϧ"  Ϟ0^
W
(
bȭ[ Ǻie<R  
Rv""(x>P >P>(>@
> h ǺFh  R>@ 
>Ϫ>@ 
>ύi Ǻ&iR  
Rjt ǺA	"ϥjt<R  "
R<R  (
Rϯg ǺvgR>(@ /
>RR>(@ /
>ϠRR>(Ϧ@ /
>zpl ǺU}lTySSTSSyRR R S ֭  5
ϐ Ǻ Ǿ2c Ǻ> Ǿ82cSSRRS2cRRR ǺC2cRR7R'2cǼRRR Ǽ1 ǼVVmVRR2cRR2cǺ氭S2SRR R8	   !  1 Vy0$ǹǾψ氭S2SRR R   Ϡ|  Ǭ  1 ǻ1 ǻ2cRR	1 Ǻ氭S2SRR RK   )4  2cRR0#ǹǬ  12cZ2cǾR4R41RYZ0YRB2\YRlBǚ	 Ǻ1	[YRBǚlZXXϯ0YR("BǨ,  ptTTS"URRpUTSTSTT ">("@X>1 <lVV1>P >P>(>@ X>ϫWV8Q8PSR   , (>P >P>(>@ X>R0YRBǝ["0YRBǝSZR  RSYRBǞ[-ZVVqYRBǞ<R  VRϓ0YRBǜ[1 0YRBǜR 	>(	ϙ@ZR /R>ϟRR 	>(	g@ZR /R>vRR 	>(	5@ZR /R>MRR 	>(	@ZR /R>$YR~BǠRѬ
	Ѭb[WYR}BǠTySSѬ
TѬSSyRR R S
 Ҭ
Ҭ֭  ZR5R6[4Y-RRKR
RRsⰭS2SRR Rﭽ~   ϋg                                                                                                                                                                                                                                                    I                        Z+k $      ELN042.D                       O  
  )[SYSEXE.SEAS$WORK_0000005C]EDISPLAY.EXE;1                                                                                           3                         !      &        ΀^޼޼޼X޼WXݭPSWVV 
SWRRCSP P(ЭQޭPSR 	  

(޼S2RXRcV cS2SRR R  S2SRR Rü   ΀^}޼޼ݭݭGPP P(S2SRR Ri:  M   F   P^޼Rb\(b^޼T޼X޼S+\R2RRRcc\P \P\(\^^XTψPP P(S2SRR R請{  \S2SRR ^R\  Ϟ^X^ȸZ R  P1d[\[#,  #ͳ(ͳ(ͳ(ͳ%͵^ͳU-U͵ L1<UVV^<UW͵TnSpRBeWU͉(͉(͉(͉n͋Y͉W,  in͋VVS2WTRRiTVSVSVV4Y2WRRVSSRRޱ  (C͊͉Ϛ͋GVCY2WRRVSSRRޱ  (C͊VV͉(͉(͉(͉͉͋͋W-W͋ ?1,8  i p͋VVS2WTRRiTVSVSVH2WRRVSSRR (C͊VV͉(͉(͉(͉͉͋͋T-T͋ ϯ<-T͋ Ϟ0-T͋ ώ$-T͋ -T͋ q-T͋ dZ\1 Z1 -T͋ @0-T͋ 0$-T͋ !-T͋ -T͋ Z\1 ȸZr-T͋ -T͋ ӹ-T͋ ƹLZ\GZT-T ͽ\*2Tx|̈́xD  ̈́\Y1\1
ψW,  i pVVS2WTRRiTVSVSVL2WRRVSSRR (CVVVޱ  (ޭభT-T ͸!-T Ͽ-T ϲ-T ϦLV-V Ƽ\9Vsss(susϏ P\,V Ȃ\\IͳVVW<W\\^(n(V͵W7P 7P7(7n97ώ[ ȸ7 97aϞ^޼Rb(bߐZ[YY
 $ $ > LR:ۻݭ	P<RPRRW2R:rݭ	P<RPRRWR:Wݭ	P<RPRRWWY
WYZW&2RRWSSRRݱ(Cޭ1,W[VR:GVP<VRPRRWWRR(߭2VRR(߭ݐ<WRR(߭2RRWSSRRݱ(Cޭ߰VTTS2VURR@   R]UTSSTZ!2VП  ЭX[Y
 # 0 0 1X'  XZ X[XXZXX<ZY4V-V ZTTS2VURR@   RϻUTSSTZ22V߭Пi  ЭR	Rc   	Z[ZZPX^̄W޼Rb\(b^޼VVV)ذS2SRR R  V
VVC   \S2SRR ^RԳ  ǳ  V
ﵳf  VV1 ! e!b  M  w(  @*  @   ذS2SRR R:   #    ^|  mh\^W1 V-V *̹̿̬߭ 1-V  ,-V k!-V -V R-V F̻̬߭ 1A-V ϰ,-V !-V ϖ-V -V ̼̬߭ 1 -V Ͳ7-V Ͼ,-V ϱ!-V ϣ-V =-V  Ϫ1 -V s-V f-V ZO̹̿Xn-j-|~  Xt-
p-  ̬߭ 6-V !-V -V ޱ-V 
 W18PÞ^VYX 1@
  PW@
  WRRRRRe   	RE   <Xn-j-|~  ư     WRRȵX1WRURTSnRBױUWYHWRR   < ǰf  f   ϧf  f  X
WRRHXYIWRRAR   8R   /RD   &R
!R   Rf  fu  WRR   YWRRA   RZ   	RO   $WRR~   R^   R<
R>R
 1GЬSXRRcP cPc(c R¹¿Xt-p-|~  Xn-
j-  ¨|~  Xn-j-|~  Xt-
p-  ¬   ~\̰     P ^|N  mޯL L   Ǯ5  (
     P Pp^|
  me~Vέrv
  v(x鵭1  
 }%v
 R0RR\\RR9RR\
 R0RRWWRR9RRW(߭Ԑح\SR}ԂS(	˭ϿW\(
ѐ\(ѭ#R2R~@	  @	  <~	  	  ~2R~f	  f	  ,0 ƂƿƹƸ d	   D|M	  o 	   U	  P  ƌ.RR  ,ޮ  o UUSTRRTUSUSUUURRƒ
ƒ
ƒ(ƒEn ƔƔTTS2ƒURRUTSTSTTTƒ
ƒ
ƒ(ƒƔƔ ƴ    ư    ƨ    Ƭ   n- j-   Xn-j-|~  t- p-   ϱR R߭   ƴ|~  R R߭   ƴ|~   Ƹƨ|~  ϱR RƠ   Ơ x Ƥ   Ƥ x ư|~   c4   ުL  ?     P  XXVЬSЏ8   WЦVVX1 <0QЦP#籬QQ\PUЦ<Q%Ц8R bЂTUTTTTPQ߰PPUUЦRYiPzp  	YZjZZY zl      	  
ء#Q,Q# "W1>UUЦVVX<0UUЏ8   VWVVЬSVcVP                                SP UUVЬSSWЦVVU<0QЦP#걬QSQ\PUЦ<Q%Ц8R bЂTUTTTTPQ߰PPUUЦRVfPzp  	SZ#Q,Q# "Џ0   TVUfVVU1 <QQQcЦ0Q<ﾀRxRR    R0RB RQ    QP bՂPQPzl  	أ

0Ц4RТzPQQ,Q$  1 ( ϒ0T1]XXfVVU<XXЏ0   VTVVVg, n .cSS| ЬTP<QQ|RUdUUU UUQ$UVV VVQUVPPRPSPSVUQRS| ЬT<US URRU RnRSфS          INPUT    a     OUTPUT                                                                                                                                                                                                                                                                                                                         @   @                                                	        X  p  x                     @   P   p   x                    
                 @                                                                       	DPASCALIO                                                      DAP                                                            	ELNACCESS                                                      	LIBCOMMON                                                      	PASCALMSC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ' * [SYSEXE.SEAS$WORK_0000005C]ELNRTL.OBS;1 +  , P   .     /     4       
 4                   - 
    0   1    2   3      K  P   W   O     5   6 X
  7 `Ň]  8          9          G    H  J                        <     ELN$$BOOLEANV2.0-0010-OCT-1990 20:26                   VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]BOOLEAN/OBJ=ELN_BUILD:[ELN.RTL.OBJ]BOOLEAN ELN_BUILD:[ELN.RTL.SRC]BOOLEAN+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB *  VAXELN Pascal BOOLEAN enumerated type de  
     ELN$$GR_BOOLEAN_PETD          	.  ABS  .    P     #   $CODE b  P 4    4 4 BOOLEANQQ    FALSEQQ    TRUEQQ     :     
ELN$BOUNDSV2.0-0010-OCT-1990 20:26                   VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]BOUNDS/OBJ=ELN_BUILD:[ELN.RTL.OBJ]BOUNDS ELN_BUILD:[ELN.RTL.SRC]BOUNDS+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB  VAXELN Range Checking Errors 
    ELN$BOUNDS_CHECK  
ELN$_ADAWI  
ELN$_ARGUMENT  ELN$_ARRAYBOUND  ELN$_ASSERT  ELN$_CASELAB  
ELN$_CHARASGN  ELN$_CHR  ELN$_EOFNOTDEF  	ELN$_EOLN  ELN$_FINDFIRST  E                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  J                        f $      ELN042.D                       P  
  '[SYSEXE.SEAS$WORK_0000005C]ELNRTL.OBS;1                                                                                                                      6             LN$_GENERIC  ELN$_INTCONVERT  ELN$_NEGSIZE  	ELN$_PAOC  
ELN$_PAOCASGN  	ELN$_PRED  ELN$_PROBESIZE  ELN$_RECEIVE  ELN$_SETASGN  ELN$_SETCONSTR  ELN$_STRLEN  
ELN$_SUBRASGN  ELN$_SUBSCR  ELN$_SUBSTR  	ELN$_SUCC  ELN$_TRANSLATE H   
ELN$_TYPECAST  ELN$_TYPEEXTENT  
ELN$_ZEROSIZE  
LIB$SIGNAL         	.  ABS  .    P        $ABS$ 	   P  P       $CODE  P     ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSCR ELN$_SUBSTR ELN$_SUBSTR 	ELN$_PRED 	ELN$_SUCC 
ELN$_TYPECAST 
ELN$_CHARASGN 
ELN$_PAOCASGN ELN$_SETASGN ELN$_CHR ELN$_RECEIVE 
ELN$_SUBRASGN ELN$_SETCONSTR ELN$_SETCONSTR 	ELN$_PAOC ELN$_STRLEN ELN$_GENERIC ELN$_CASELAB 
ELN$_ARGUMENT ELN$_ASSERT ELN$_FINDFIRST ELN$_TYPEEXTENT ELN$_ARRAYBOUND ELN$_INTCONVERT   ELN$_TRANSLATE ELN$_NEGSIZE ELN$_EOFNOTDEF 	ELN$_EOLN 
ELN$_ADAWI 
ELN$_ZEROSIZE ELN$_PROBESIZEЎP    QPAN 
LIB$SIGNAL   F     ELN$CONVERT_ENUMERATEDV2.0-0010-OCT-1990 20:11                   VAXELN PASCAL V4.2_95 
  e
 ?     e    멸$ELNMSG(\	PAS$IODEFELN$CHAR_TO_BOOLELN$BOOL_TO_CHAR_VARELN$BOOL_TO_CHARELN$CHAR_TO_ENUMELN$ENUM_TO_CHAR_VARELN$ENUM_TO_CHAR 
STR	
STR_LENGTH""
 
EVS	
TOTAL_WIDTH""
EVALUE% 
 
	

""
%  
		
""
PETD	   
PAS$R_PETD  
	
LENGTH""
% 
	    
	

""
% 
	   j      P                                                                           E   
LIB$SIGNAL  ELN$$GR_BOOLEAN_PETD 
  a   ELN$ENUM_TO_CHAR  ޼Zլ
ݏ$S 
LIB$SIGNALЬ[ЬRZZ
ݏ,S 
LIB$SIGNAL޼VJRBfX[X[XX[WWR޼Y, RiXSJR(SBGi!  
     |ELN$ENUM_TO_CHAR_VAR Y     P|޼VЬRVV
ݏ,S 
LIB$SIGNAL޼UFTDeSЬRSbbb(bD   
    ELN$CHAR_TO_ENUM    P,^޼XXV޼W,  gTTS2VURRUTSTSZZXXXV,Ͽ  䈏JTTS2VURRUTSTSnXnnJSRS   STRRS$S_   
ݏ4S 
LIB$SIGNALY޼X޼VIQA[n[kWnP>UZURBSSRRa   Rz    RRSSTQURTBhWPUW!n[ծ
ݏ<S 
LIB$SIGNALYY	Y1vծ
ݏDS 
LIB$SIGNALЮP   
  }   ELN$BOOL_TO_CHAR D  }  P ^޼n޼QQЬP ELN$$GR_BOOLEAN_PETDݮQ`Ͻ!  
     ELN$BOOL_TO_CHAR_VAR @    P ^޼n޼QЬP ELN$$GR_BOOLEAN_PETDݮQ`  
     ELN$CHAR_TO_BOOL <    P ^޼QQnЬP ELN$$GR_BOOLEAN_PETDQ`.      $CODE     $DATA    a   C     ELN$CONVERT_INTEGERV2.0-0010-OCT-1990 20:27                    VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]CVRTINT/OBJ=ELN_BUILD:[ELN.RTL.OBJ]CVRTINT ELN_BUILD:[ELN.RTL.SRC]CVRTINT+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB $  - integer/text conversion routines         	.  ABS  .    P       $CODE   P0#  
     0ELN$INTEGER_TO_CHAR_R3  &( ^^U5PSQ!, n QbSR!PS(Seb0'  
 %   0ELN$INTEGER_TO_CHAR_VAR_R3  & ^^UPSSPP(PebU$TQQK464UK4ZK4_K4|P`P2`P`PPPTQ{
PPR0RuPT-uЎRUP   @     ELN$CONVERT_REALV2.0-0010-OCT-1990 20:27                   VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]CVRTREAL/OBJ=ELN_BUILD:[ELN.RTL.OBJ]CVRTREAL ELN_BUILD:[ELN.RTL.SRC]CVRTREAL+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB   - datatype conversion routines#   FOR$CVT_D_TE  FOR$CVT_G_TE          	.  ABS  .    P    o   $CODE   Pp$  
     pELN$FLOATING_TO_CHAR_R3 & 	p(  
    pELN$FLOATING_TO_CHAR_VAR_R3 & SQVUV`~Qp`n
P`~VUVSTT^PTVV^^V^Q U U	 FOR$CVT_D_TE FOR$CVT_G_TE(SbVV^  ?     ELN$CONVERT_T_FV2.0-0010-OCT-1990 20:27                    VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]CVRTTF/OBJ=ELN_BUILD:[ELN.RTL.OBJ]CVRTTF ELN_BUILD:[ELN.RTL.SRC]CVRTTF+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB!  ; Convert text to real (F only) 4   ELN$_INVREALSTR  
LIB$SIGNAL  OTS$CVT_T_D         	.  ABS  .    P        $ABS$ 	   P  P       $CODE   P<   
     < ELN$CONVERT_T_F & lP@^ďP(Pln~n OTS$CVT_T_DPOmvPPԼ ELN$_INVREALSTR 
LIB$SIGNALP  ЬPЬQա	PЏ	  P  ?     ELN$CONVERT_T_RV2.0-0010-OCT-1990 20:27                    VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.RTL.LIS]CVRTTR/OBJ=ELN_BUILD:[ELN.RTL.OBJ]CVRTTR ELN_BUILD:[ELN.RTL.SRC]CVRTTR+TOPD$:[KERNEL.OBJ]KERMAC/LIB+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIB+SYS$LIBRARY:LIB/LIB'  ; Convert text to real (D and G only) C   ELN$_INVDBLSTR  
LIB$SIGNAL  OTS$CVT_T_D  OTS$CVT_T_G          	.  ABS  .    P    4   $CODE   P    
       ELN$CONVERT_T_D &> l OTS$CVT_T_DP
 ELN$_INVDBLSTR 
LIB$SIGNAL   
      ELN$CONVERT_T_G &< l OTS$CVT_T_GP
 ELN$_INVDBLSTR 
LIB$SIGNAL                                                                                                                                                                                                                            + * [SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN.EXE;1 +  , Q   . E    /     4     E   E                     - 
    0   1    2   3      K  P   W   O E    5   6 `]  7 ~]  8          9          G    H  J        
             0 D X     0205      (  ]`       %                                      
EPAAV_MAIN                             VAXELN V4.2-00 ] 05-05                                 +            =      >     >     ?     B   
  C     ?         !      	  
LBRSHR_001      !      T 
SCRSHR_001      !        
LIBRTL_001      +      e  
PASRTL_001        8     $     EXITFILEHELPPLOTPRINSET TABU$    \         X      ,  4                    &     EXITO  EPA_EXIT 4                   &     FILEHN  EPA_FILE 4                ! )   P1OUTFILE
Save file 4    ,             &     HELPlN  EPA_HELP ,                ! !   P1HELPTEXT  4             &     PLOTF  EPA_PLOT (                ! !   P1M_NAME(                   MODULE   (                   ROUTINE  $  (                 MACRO,  T               & MAXIMUM100 ,                 & MINIMUM0   (                   SOURCE   $                   ZERO $                    FILE       0  X          $                  @  L                  h  t                                  8                 #   '     PRINT`N  	EPA_PRINT   (               %         SET   0           8    ! (   P1OPTIONWhat       T     SET_OPTIONS(        |             	DATA_FILEH              "    0     SET_DATA_SYNTAXTN  EPA_NEW_LOG_FILE   0         8    ! (   P1OPTIONWhat   8                ! *   P2DATAFILE
Data_file    8   d    \      *     	TABULATE4J  EPA_TAB  (                ! !   P1M_NAME(                   MODULE   (                   ROUTINE  $                    MACRO,  ,               & MAXIMUM100 ,  X               & MINIMUM0   (                   SOURCE   $                   ZERO $                  FILE (            	       COVERAGE $         COVERAGE_KEYWORDS  $    8                 FULL $                      BRIEF    t                    X                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           K                        x $      ELN042.D                       Q  
  +[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN.EXE;1                                                                                         E                         ] "                     X        $           DATASOUR    4      ,    `            
         	DATAFILE  0                ! )   P1SETFILEFILE  (                          SOURCE0                ! )   P1SETFILEFILE        (           DATARUN_SOUR    <   t      8                 
   *     	DATAFILE N  	SHOW_DATA8                     *     	RUN_SPEC4N  SHOW_RUN 8                     (     SOURCEN  SHOW_SOURCE                                                                    P                                      B                                 D                                                          $      ` 
                                                                                                                                                                                                                                                                                                                                                                      P                                                                           D                                                      $      `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         EPA>                                                                                            epaa>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  xQ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          b      LOG_FILE             EPA_PERF   datafileVAXELN PERFORMANCE UTILITY V4.2        Analyzer Utility (EPA)                                                         .LOG_Data_file: epaaThe specified datafile contains PC-sampling dataThe specified datafile contains PC-coverage data_Image_name:    _Image_name:    The specified datafile contains JOB sampling data   The specified datafile contains PROCESS sampling data   The specified datafile contains SYSTEM-SERVICE sampling data^ԭ^  mP`^W T  P1  dЏz 1Ru^  PP\\\PPԠOpЏ %ܞܭP  <PPXXW^^Y(XznXY?잭]   1 f ]e-?  X9.?RRR?RRYYVV(?,VPYY PYY?xYYY,Pi ?   & / 8 A  J = V/  4 '  + '  " (   z(   (   (  
111Px\  | ,^^V,(.(ޏ   ޏ   [  P\<,PPV^P~(n.n%^^Pޏ   ޏ   ԭ[  P\<PPV^P~(nn%^^Pޏ   ޏ   ԭZ[  P\ޏ   ޏ   7[  P\0^, n  0, n  _\ ԰֞K؞ԭȰԭКZ  PVVVf1 \1 -   n1 ( SSQЏ   PRR   RPSQSQW( SSQЏ   PRR   RPSQSQX ԰֞o؞ԭĞ2Z  Ȟ*Z  ̰КM  PVV jN  
XW\\hVȞܭЏ 0ԭؚğPVЏ   Ԟ0؞Z  КY  Z  ؚY   ^\мRRkY  Μ^,  @ ,< Y  Plv11 ?>   
X  ^X  P1 -?R  ޏ",  ?/?                                                                                                                                                                                                                                                   L                        b4s $      ELN042.D                       Q  
  +[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN.EXE;1                                                                                         E                          "            ԭZX  Pwq
11 X  P( `ly?X  l);IW  ޏ!,  ?.Av1XPϠ
 3
 1?W  W  bPѠ70W  {W  W  WW  50rW  DW  ^W   W  JW  W  o,?O @ @1    PPPww1 -?  ޏ,  @ @ 
ԭV  P,&z	
b18X1`X|1|
|PP|ШPШ
Q@Ш
QШPA
hXX< U  PlPРxVxV1VVpP( `lU  lYЭYWW䞭ͤ͜͠
   PPP[[1 p1 ѭ1 ޏ 8,  @ @ 
찏F쭐ԭlT  Pvy1RRP]QRPP[PP1 ZgT  PP`PԠPԠP(B qP͜dPԠRRE>P;`4+)P"RТRBRPՠRPͤ]Q$RPP[PP1 RS  PP`PԠPԠP(B ͤPԠPՠzPwfPcWPTLPERТRB[1 .Pՠ&PѠtR  PP`PЭPԠPՠPPPPRТRBY@   V1oehbVЦ]R  PZ@PZQ  P\\jlPР\ZP`P`1Q  rQ  1Q  bQ  |Q  >Q  hQ  *Q  1 QQ  Q  51Q  Q  Q  P  	Q  P  \P  P  <P  P  P  P  P  mP  v
1<^ԭxP  m\Q(B <(B V<VW!>P
W ?PPQ
W ?QQ`aVWV	<PWPԐVXXPMAIN.MAIN.Ϟά^[XʹЬR߭b
  P1խ1<߭YO  P1SSSRbbbЭ	(|ԫͰZjͼʹ11RR   $)DM )1߭N  P1VSRfSVRRRRRW-W ϚEͰQPSR @  :RnSSSS8(SͰW8 8 8(8:Z 5Ԧ$Ԧ,0Ԧ(46RBZRR ͸1R1߭M  P1VSRfSЪRRWW (RWRb|ƙ 1PR1F߭%M  P1OVSRfSЪRRRR (͸Ԧƙ ͸1R1߭L  P1VSRfSЪRRRR (͸V͸ƙ ƙ Ԧ1_1xR1nЪТ͸͸17Y1OުWWͼͼZZW1gRR#                1 է
M߭K  P1 V
, n   2RR|ԦWSRfSRWRRW1 ~K  իPPhPXWScWVWSԭcЭWAWSԭc<
W,W'WScWWWWWWZW1SSRRSS1ʹʹP@Q\VЬRbѬR\Q PVмRѬRԬVPQ\YЬRТ䞢RѬR1 ЬRТWЬRТVЬRXgS1 S1 SX|f@ f@f(fЬRRbЬRRѬRGЬRТSSTSXY1gSgTf@ f@f(fЬмY1 Y1 gS/ЬRS%SX f@ f@f(fЬY1 мЬRRѬR1ЬRТ䞢RѬRtЬRТWЬRТVЬRTgSSSTgS2ЬRS(ST#ЬRf@ f@f(fЬYмЬRRѬRYP^Q\`VZЬRԢ$ЬRԢ,ЬR0ЬR4ЬRԢ(ԬЬRТ[kYЬRТXЬRТWZRRЬScZRR   1 R   	R   ЬSЬRТ(ЬRТRЬSRR   ChޣSZRݬ߭kRSoPYíhgЬRѢ	 gY1YYP,^\^Zn޼Td޼VfԭԼԼԭЪ1ժ1ЪмЪЭRYмS1 S1 SY1 nЭR8d@ d@d(d:ЭRf@ f@f(fЭRRЪbЭRRѭR]ЭVЦWWXWY]Q "P[1@ѼW$ѼXЬRb@ b@b(bЭн]Q P[1]Q P[1 мR`ЭSRVRYQnЬRb@ b@b(bЬSЭR8c@ c@c(c:ЭЪ]Q qP[1 ]Q P6nЬSЭR8c@ c@c(c:ЭRТ ]Q /P[N]Q JP[[Э9nЬSЭR8c@ c@c(c:ЭЭRТ ]Q P[[ԼЭRâмЭnP^޼Q޼޼޼ԮPZЮVЮ[޼SУ(nռQ*ѼnѼ(YYЬRբ$Т$RѼ$RRYWY1~[1w޼S޼X޼WУ(nQУ$hWfRRT*W 40$TZZ֣,RRR(U1V[T+ f y       k| J  @1W<fRR( 40$֣,U1Wf( 40$֣,U1cfRR$Z,U1P<fRR$Z,U1=f$Z,U1-f0,U1<f0,U10,U1,4U1 ,4U1 <f,U1 <f$QУ$hRh$RRYУ$PU1 f$QУ$hRh$RRYУ$PU1 f$QУ$hRh$RRYУ$PU^WfRR(UMW<fRR(U<Wf(U.WfRR(UW<fRR(UWf(UYiU[UVQѾnѾ(Y/Y+n(h$n(h$ZYP
hYPY[1QЬRТ(nYP^X޼TdRТVRVR޼S<RRcfVdRRVRVVqЦW  ( fz  Pм ЬRbf6  P мX 
   XP  .EXE ԼoRЬQ<PP=Q8 § ߢ  §  P<P< PЬQP(P aRТT  ^nU|~ ݏ   |~e<1 ~<T~  P<ePPUP<P@eS<Ux	UUU~A  PgЎRЎQURcS< VVUUVnP|~ SVb|~`<1 ~<T~  P$<nPPFbR   SVU\P< ЬU?R SS0Fԥ|ЬQŠ Q<PP<Q4c`ߢ  §  P6=<Џ   ߢPЏ   \ߢXP
Џ  Q1? ХP#ѥХhlvߢXPԥPPߢP< bRЬU vߢXPB<zP
Ҁ Тhl֥ѥαP < PЬQP(PҀ aPPߢP     m_name  module  source  m_name  m_name  macro   zeromaximum maximum minimum minimum m_name  filefilemodule  source  m_name  m_name  macro   zeromaximum maximum minimum minimum m_name  filefilecoveragecoverageFULLhelptexthelptextvaxeln /analyzer    epaa.tmp ^ԭ>  mЏ@ %𞭬G1  ݏF   g>  P\l\ RSRT<PQ
RPQQ
aQQ,<SP
P ? PQ@STRSSݏF   
>  Pll\lTR<TRTS <^ԭ=  m^\	PC  }{.0  P		J0  P1  	/  PpЏ  %̭İƞȟ/  P<QPQ0PRRST
S ?TT<SU
RSUU
edQPӰ7C/  P_ 	V/  P /	  $.  PXЏ  %̭İƞȟ.  <PPVV\^^W(VnVW;  PPxh.  PXЏ  %̭İƞQȟ|.  <PPWW\^^V(WnWVP;  PP>V-  PV
PPVV ϖ-  Pb Џ  %̭İƞȟ-  <PPVV\^^\(VnV\?':   <^ԭ:  m^\OI	?PC  97,  P		,  P1  	,  PmЏ  %̭İƞȟ,  P<QPQ-PRRSrT
S ?TT<SU
RSUU
edQPӰK+  P 	"+  P 	  +  PXЏ  %̭İƞȟ+  <PPVV\^^W(VnVW8  PPi +  PXЏ  %̭İƞeȟ4+  <PPWW\^^V(WnWV8  PPV#*  PVPPVV Na*  Pb Џ  %̭İƞȟl*  <PPVV\^^W(VnVW?<7  l)  PsЏ  %̭İƞEȟ)  <PPWW\^^\(WnW\ 6  -                                                                                                                                                                                                                                                    M                        R $      ELN042.D                       Q  
  +[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN.EXE;1                                                                                         E                         q "     (           sp  _\  K  	?  3 <^ԭr6  m^\( ֐
̰ΞiП(  P,Џ  %̞ԭП̰İƞBȟ(  <VVWW   W\^^\(n(Vc-PW`(l`  ^5         B      EPA_PERF   epa$p_set   epa$p_show  outfile epaa.tmp.EPAeln$:epa_help   epaa.tmp  \	E5  5  85  5  \P  
5  4  5  4    4^\Џ  %ԭ̰ΞXП'  n4  ԭ֭̰ΞП4  \P  \	?r
4  c3  \P  ^3  ߏ   
`Tߏ    3  N3   ^3  v3  ZPѠ9\ЬRТSS3  cSR}3  bR\o3  l\     B      EPA_PERF       a      RPT_FILE   epaa.tmpepaa.tmp.EPAPC_coverage samplingJOB samplingPROCESS samplingSYSTEM SERVICE sampling PLOT Command Summary information:   TABULATE Command Summary information:   Datafile =  System file       : Up time           : Idle time         : CPU1 Idle time         :    CPU2 Idle time         :    Begin time        : Stop time         : Clock rate        :  ms Sampling interval :  ms Total data points : Bucket size       :  bytes  Traced S0 counts  : Untraced S0 counts: Specified datafile does not contain PC-sampling data                VAXELN Performance Analyzer                Program Counter Sampling DataModule/Routine  Count   Percent                    Program Counter Coverage Data               Program Counter Sampling DataCoverage    Percent     Count       Line>>>0<<<   **    :   JOB Sampling Data     JOB    NAME   CONTEXT TIME.LOG secPROCESS Sampling Data   JOB       NAME  CONTEXT TIME.LOG PROCESS(ES)*PROC    secSYSTEM SERVICE Sampling Data.LOG м\RR\RRS u2/  R\ м\PzQбRТQѡ\
QPQaQQRbw< p^ԭ.  m(B (B pPp;\<QQ\Q.\R
R ? UESErT S TSTPQ\P(^ԭ.  m(B l^-V1 l1q Э\^(B (B l(X(<P<QQPQ+PY
Y ? RBZB*[ Z [Z[XQPXЭ^\XWWWVfVV1nWWP< ^ԭ-  m^\ܰޞ`-  ,U ? 5(?߾<?p-  c,  NپR޹  1b
 ? c   1 ]Qυ1 ,  ,  ,  ,  j,  ,  ,  ,  F,  ,  ,  l,  ",  e,  ,  H,  bb B L V  R]QE ]T]QϮ]Q ]Q J]Q +  +  +  +  +  '!+  }+  %%s+  V+  I+  {D+  b++  U+  H+  ˼PѠ1  T<TRUP
RPP
Q`֭P
  RQBQQ PRѭ RPRRT,*  VT|*  _*  )PѠPѠ1TPP<TQUR
QRR
 QSAÛ bPϟ9*  VT$)  )  PP<TRUS
RSS
 RvQBmcPfP  :L)  VTt)  W)  1 &O)  VTq:)  d)  TPP<TSUQ
SQQ
 SﾺRC aPϟ(  VT (  (  (  TPP<TQUR
QRR
 Q>SA?bPПn_(  VTJ(  t-(  TPP<TRUS
RSS
 RιQBVcPП&'  VT'  '  PѠ1wPǏ'  8'  ݭ}'  p'  S'  PĠ<yB'  ݭg('  ~R'  E&  8&  S#&  ݭ&  &  3&  pPݠ&  &  m&  h&   PݠG&  y2&  d-&  PݠK&  >%  1%   {%  ݏ   %  %  %  %  %  %  0
W%  1\^7%   QR\\;PѠ.4]%  6%  P%  %  R)%  PԢ`cТPVQ@\dﹱ\PQ9PѠa,PРa
7PРPѠaPРaP`P`ڲ1u
B	:2	RQ !RQ $< ^ԭV$  mQ\U$  +@	$  3#  &#  ,#  #  #  #  /ߏ   8ﾾ#  ߏ   
ߏ;   	X#  ;#  PP1
P<				P	QPQ7PPR<bS
S S
T
T ? T*UDCPQլ
PNPNQFQPEC  P bPՠ15QQ1'Q?1
P`M"  /s0"  8<PP#蟬vPݠD"  ߏ   Ϟr<PP蟬ϊ?R
﫮*Pߏ2   b\Q+Pߏ2   b\QP`ż!  ﰼu!  %\!  K!  
 1PР Pՠ1P<				TP	RPR9PPTQ<aS
S S
U
U ? U&TECPRլPNPNRFRPEC  PQ`15QN1'
:P`\   /?   u.   
[$   TP`D
   9<TPP"蟬ϓKPݠ  ߏ   oM<TPP蟬Z*Pߏ2   P\QP`ﻺ  了k  %R  A  吝P`1P`1^ԭ4  mQ\^TW9+  	    %,  ֹ  #",ﾹ  ﱹj  魯]   %ߏ   |E  -b+  
M  8  +  ԭЭV^:P(B X﫪1 P`X1y ЭW^P(B `(B XZ@P<QQPQ-P
 ? RB[BX [ X[XZQPZЭ^WZYYYԭнխ1_YYЭ^V譠1.`VЦVWѧVpWgXչ͹1ﷹﶹP\QPРPР
VWVW1PVV֭PLQ@Ƹ<Q<ﱸ立qQ(P1Pߏ   χ1 \լPNPNQFQPEC  Pܶ  %˶  ߏ   %Dߏ   PՠIZ  :zC  8*Pߏ   P\QJP`>  * *"Pݠ  ߏ   u    3d (T	dTP<TQPQ7PTR<bS
S S
TU
T    UUeCQPʟ:p9  TP`Y"  L  VW1VfO&V@WѦ2Wg*ԭ!1^P︶1 ﮶UХUХ
UVUV1 UUPW^PRSﮧXиݵֵXШTѤR
TSTdTTﳵXh﫵P^WPSWѧ
WЧUV1vUe1)^ԭ  mмPмRмSTUSNSSRPNPPFSPKPPP_ЬS<cV
V V
|FUURP5RPSRS(RRUVЬW<gX
VX X
THRSPR<SUSRS&RRUTЬW<gX
TX X
 HRS^ԭ  mQ\  +      ߏ   Cɲ  Ｒu  ﯲh  [  mV  ߏ   Um6  ߏ   =M  ߏ	   ϧ%-       PРiݏ     PY|  ڧ?Q  ﳥ<  PQ( a`_  VWVW1VVܲPeQ( a`X%  ﻲP(,`﫲XYXY19X1  ߏ   b TPPTQ<aR
R R
ES
 SScB PϞTP`﫰t  ߏ   )L  ߏ	   PN8PGtJ $P6NPD)PG"P <  ''    pP
P , Pʱ                                                                                                                                                                                                                                                   N                        ;u| $      ELN042.D                       N  
  %[SYSEXE.SEAS$WORK_0000005C]EXF@R_"W%XM1ct;1                                                                                         y                         )      *       ѱa3ܞJPv(3DCFJ&Qd4^^Cx@IO niԞD%>DҞw_ Dd8t2@xj̆7U
G-Deqyu#,}aT@R ^MՉp&X(uM}U Cİ.D.I/WhGwIy"[aZ]M{nXJ lc<buQ߀Ar՞BJUN譟%oe`w@ǓB-PU?'L
4k\+*XeQ7i0kOb0JT0jU,pT4""QGz|jKjSo̗PPW^H}v>c䒚	EvJvN=
=zMfk n{3^7OW-z]+޷J.H.5^j}M>GT=$o1}4#%>Y
zK쑓
_'NNqJR 2:V`P(3OBiɛ(0SPEکb	mCrn/Rzm=bUAvtu`0"UX6A{gA^ixk^5?XNIT#t]q\h?N\?
w
A+yjx\^)`1;mk4Z.`\ylCtMx&AjWlq|bSfA2u*M$5H]Lp܍`D&kL.AocSݭ X;]H/v؋ibU6S«׾x؊j~~S41Uoo%JٹC2͑0plp,><wa
0@ Gg^}I0Ds	
HT~P4 i&?-lx_ B(}Uk̆Al|?8
*q3CBk"&ۻ얉#Ts?
aim$g8gc(lg@lt*}fl\ry:KK!3w+ˈR<۰P%k_[o(fJ(ʐڨRřbp3Ie1Xx:="[SjW~yvE&k&}!-o$mZ
O,e morE0uLћ9'F[2dP8.Cj!4mػҝZ_~ jc ,Z
&<B.ږ"@D{7jĚeiKGSg,c6w+#ao#fV1	:g6n	PnP|ւ	īd0X"^GSFq-AHVߙ>(8^EpL%cݱOMXqvN(R_*k/TST~?dpc"|+_ɢ_	]=|y	6*!0^raƎ6}PGo~{+s,4HխiEځYߨT2q@3~m!vۑފ,Pn0ss"'
jYG}$ju+Ṭֹ	)wHإ~?9!\DF 8Yfr>F \[g7l({É,6xO{Sű"O5#^Lj-mS#qY`p n{
N4]$p!"&d%bFVbv^smnt
N{]"	
)x -P*OD 68Dv 6pJ&T# wV;ɐ5rsyҹC*DCn^m4Ɨm,}"gb|Z'^AlEd34T&its?sRU!xSчuۑLT8Rq=I|*<i1
Vu)^s1WoO׷U|d,%ڸ{CAy<6^t
/PH[{ĳU(Dhm䒂pnD|f"e%<2x,$$'+*nî"Z eJdvi,= L,#'r8qp.a÷w4A@%@Vd{Xd[4eXeA:Uv{4}'"_'GPE0߁I;ъ!^ah}A2cJ6=Q^":-

ryp
ؔ8Nfj]1< }.=tGjXhގܰn\͔!pF8F@&"'$S>gw0(J
D?TK^_7vױxA%	ݖM͑q~Y7Y
w4%J0L]VGЎrv,T
tַ
?<Ib+B׺n܌̰ |n3܀4:tb;ђӉ{Tr<>R(/9)4	UIc2.On{R'4	'69WSmLO4wrQK4&V]nF~+`>%սsB|?ɼbZ\zH9NkO)Îcd`j[Cgا 
НΠ@!vL6"u@"m(>{+>nԢi
Ǩ(u>1%Q*ǁ'>l5Ƨp8SKtF^&*^b?$]Wdm]	͂ejwp41XHH}9;2\%(D N X6IoVm	vuyŴfn_:G	Y;{AT2\mikfMil+ŝ]0-Xm#qI]'[_Z*_3행`k,$a6z7mGz;Ҏ7 ÷
jC_%2ܪgY~ibGѭ^B[筕d]$m`/cfʣHӢUC~s9P[1~DAmbO!kz.6%HY|E7Z,=[HNVfպLuZͻ'
[RnD2!NǓ%5Qu\DW[Q"YL2}ѭO:(ᗁU,-Th"Aر?v0!˝@ԳCʘQdxp\3
J5X M	.Zr䃇ZpfN"4X}b!o9t(P|%_,fLFܪI19JÒ6yD\pnˑh}!
D-**4.6ۭ(9+gK1NQ,;~qKdN(*#7g?:mWZc3Ȫn& XnӜZm&*Ơ5OX'Q1$w(14UշyGåvdyz ΒxAY0	gTx)z

#ML]5w82 RclvBZgey02	 +d/
,#Q-6
,:XLAMN/N8j.i˟R^>KgtH.gQ?bb(| ѤskOC/Iws&Sg/#S_*՛FPZWd3bxxx<f:ѣZrZYN$U{EVoV.f59)Sz_$ahfm>i򿐸j&Xqb\ThbJN^MtƱ?pNZyE$׊fZ4f-+µplIQG
̘D(/l	o.FʙB	Yz2zvElLMP(z"F%T?~;HJ_8P^FS(?In[>n_7X#vD6r;8wU4}|
s%uPo;u8ԮZ_¬0	5&%rjţ>b %9TNd9lCWv<6m_z'a/H_?7r~>W$MCiZ`\}9P	2[\>Wăy%qQCf_{\uu\~/dݬgZ#uXLSY\gwP BVo7jQ*$!&Mvsru*QZoNG*d'9yc;E#<y@6[И2g-ns^SŮ`gWj
BjnUܜ6=,` &@NU$,G(g.
N*bEQJGhrsdtփ.T)3t@95o6q?Uwހk5C㼊JeW.m][1>ښLSz&UVy	!K,HiH{`
nZ&5bf|Ic<l4漎R҇dXlXi*p6qUX@2!~sV^AhW(gZ~GelVcpRS4%H}d
&ze0wu<dCOca4"XЇF:
ScڱDtx)<A
t4o	N-ah1E,
-*Z?Fw]0ą[K	){X̞Yٞ=
Is&0k8$[QТH2/GxG_IRx]<G 0
ҵ+sF$q Z!:D$ۆW}::x/qء25R
My	T9E+:Aymhz޺u2f<zrhn6p`$|[_ܵ+~i2 AH5NiUL)u|ٳLDK\']崥'r^	]A{U5B֎2{UɇNfT]>qkNef$XNE˩fH)l:*%o(}Jovm<p/Ey8?ȚFפ?#D gs~8e)!RH-U'a*օU=f̨nsHT.`fow
XR R޷[1atX/b鳊gh~D"»TnsG-a1BkI?NXM"J7l$8A\Ҿv7XVǨ&\o.3GCЛ3l)`^BL=2ҷ@t:3][0٫(u ͒r-dL.+׬Gz[efA ~*~ռn9E!ŨSG3jn?:K
J$E_;L(%YZa0F%AeOՍyVBep>f"$+;cTL3!dI$TuĞ`fg/L]ͭUZ8	3`DX7"E%GJD]۠dS^+Ûl=XTBijÜ5̒$N:WєPxܔ4GÈk#ou>,
z{0s~1ɒh%a yA7jeY[}=_26@#/k9@`32X!PōLy=X;ҙ`/Riθ@h 5~}ǠFVvo8P?}PpMļ/Z@;T6{[%;Vkv@rP5pwiKlO7}oD=\w}KǶ]]kb}[ǒJɢ!<h
颇7:6CqHWԧ ZZZ^+ copKYJPUc
>NG]Cir寐>+/llxA$UP'Hi%տ>dʐt
@hEoyٯrK9Id
F7#|/?T
ʰr[&6Ի.o]w +gʊT	5&WI/s<T!fLrE<Zָgj7~|hR	Uùp!-^we=a胳<=͔
5[)> Y
G, P΁	/
'B"6&@
\ЪAxv!4vb8} ?s*4
{ Hq  ͓Bzvl6zYP
"QI]-ӣUUM-rDIy:,ɢ5avSi=IUU35ֺ6LIXۨ4x<՘6kAt<Cgv4JXXzX%7?D[dI^\|enq;aZLcTDܕ;Ŧٞ@v3|[dN݊2aofWwQӳrQ7l3kgmw=
7F:	](1WGqd'6wt"?]A<Qʮde	j?^Hn~[=qW(8U쌠iU<
AKV.]_pk%MOm3kF$}/J>jbjGSR#^ ,ak=`ð}{j$)_64
L[{꟰[m f85z|RޘO+ZKMurk\=` 
S1fߏ7Hl&V-+x\6)9y"Uതj
sJ<?Z
fܪl`F.cb=SO<Ѭ>4e}Q܊ؓ`I+4^%!"*7:>|dM
vYiIMx[RKO>?JIΕ:br2MsR<ƀo劭o~!2CE @p'_O&d؊At[e	ӈ	X#pd5Fjgxnd"pzsras[2Ul59☤X-_C瑸c]-+nD͇-:An2{~a{p&Ǡ}_jEdȘBiiFt@\`łw *	`
A3/2<kܺۨG-;4b¡Ԝ,>21օ5RՐSY5ϜP4ܞC7fFġ,e#͢FMTCtEfocYR50s?Z\QD_OҼM\ZU:Ĝ-;vZQZѵtҙ,aeI](Y'n@P
1?h:&X˸C{O+ʺe|2.ceUo/	|M!K~p
7,\0=R+K,hl{ys>Azd<^1(z*)ވ+]*>
&Ah9Iv݌b_( gz|W4U
|oI%lB!Vj/qSyd$Wm(jU=pi&Pp|ɞb\m+JsqQ9]HLWM7Pq*lVI]E[ZWv5ga^*mI{=qĺrٗӨ%ewpn2|8
@(wU
?ځXĚNXm8vL4SLzK܇D*]u=O8
OegixECb{)ۦ=qvMtaWzWqk~u}rLi9# ι?kV8(FOd'1K0![S832'U.0 d{d@Vjтx9	cM8Z^'NCV;.V5
ыr]>zFQ"8)n9VnC/\NFf3_tK2*n;`0#({`AN "*>e5                                                                                                                                                                                                                                   O                        h$s $      ELN042.D                       Q  
  +[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN.EXE;1                                                                                         E                         /      9       P(,`iYXVW1o$^ԭ  mQ\^,  y  g+﫯t  W  J  ߏ   uq:  d  W  J  Q5  ߏ   Ϗ9  ߏ   o!  ߏ	   O	ծ  Ȯ  ﻮt  >PРݏ   |  P$  ?h  [  ﾯPGQ( a`:  WW1WWP	Q( a`  _ﶯﰯP(,`OZ[Z[1cZ)31-BѬ<省^  Y  <  v/  ۮa"  ߏ   ϻ TＮ 9PPTQ<aR
R R
S
 SScB P1 vܰޞܟX  XXY9 RRRRR&YRPP RPPPPP,R` X
XX   X^^V(n(cTPX`(f`TP    `  ^^V,`  n   	TP `(f`TP`%  ߏ     ߏ	   _}PN8PGtJ $PﰭNrPDPG"Pﶫ{  j  M  P
P , PDP(,`[ZW1D ^ԭ:  mQ\D  +/  "    ߏ   oI    ۪  Ϊ  QPР$ݏ     P7  ?{  n  ѫPZQ( a`M  V恵WVW1VVP!Q( a`  wҫ̫P(,`Q1~ (TPPTQ<aR
R R
]S
(SScB(PϞTP``  ߏ
   w8  j#  ﻪ)
ﲪ , PP(,`ڪت13VW1  0^^U5PSQ!, n QbSR!PS(Seb0^^UPSSPP(PebU$TQ
   |P`P2`P`PPPTQ{
PPR0RuPT-uЎRUP  < `^, n 䐏P    ݬ  ^|   VX^, n 䐏Q    ݬf^PRݬ\  l$լݬfRP| +  VD^, n ȐSȞ+  ؞  ܕlլݬfЬ̑lլ
lլ, n 䞭l
լЬl
լЬlլݬf^< `^, n 䐏T  e  l
լЬ^< `^, n 䐏U@  $  ݬ  ^                                                                                                                                                          P   z                                                                                          ) pz  !/SYSTEM SERVICE ERROR AT APP. !XP R0=!XL   z  01-JUL-1990        V5.0 z  VAXELN-TOOLKIT z  DEC            z  z         z  {  z    z        z            |~    P')ugPXPakPnPϖPP%|~  ~|~ <0 ~<a~                                                                                                  e         `  (   R                         {       0  X   ~  (  0  8  @`  H  P  X  `Z  h  p  x*  t      8  l        L  v                   RETRYretrying connect(        
NO_CONNECTconnection failure &        	BAD_STATEinconsistent state6        INSUF_MEMORYinsuffient memory for operation2        BAD_MODEEPC job must be a kernel job   2        	UNDEF_RUNrun type has not been defined H        UNDEF_DATAFILE/performance data file name has not been defined6        
NOT_CONNECTEDnot connected to an ELN target>        FILE_OPEN_ERROR#error opening performance data file <        NO_DATA*no performance data is currently availableJ        TIMER_INTERVAL1warning time interval specified has been rounded H        BUCKET_ERROR1invalid bucket size specified, default of 16 usedB        INTERVAL_ERROR(invalid interval specified, default used F        IMAGE_ERROR/invalid image size specified, default of 0 used J        CODE_STRT_ERROR/invalid code start specified, default of 0 used D        KWV_CONNECT_ERR)unable to connect to specified KWV device 6        NO_JOB%job image not currently in the systemJ        ATTEMPTING_CONN0attempting to connect to ELN target, please wait4        CONNECT_COMPLETconnect circuit completed .        SUCCESSsampling session initializedJ        SYSTEM_STARTED1target system currently running, data may be lost.        SESSION_RUNNINGEPC session resumed :        WAIT*writing performance data file, please wait *        INVARGinvalid argument supplied:        OPENIN_IMAGE"error opening specified image file 8        OPENIN_DATA!error opening specified data file 8        NOTDATA&specified file is not an EPA data file2        BADDATA specified file contains bad data EPCEPA                                                                                                                                                @   @                                                     s         8   H               `  H      x    P              (             (  8    x     8  p    `    h        x                 
                 @                                                                       LBRSHR                                                         SCRSHR                                                         LIBRTL                                                         PASRTL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           / * [SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN_V47.EXE;1 +  ,    . E    /     4     E   E                     - 
    0   1    2   3      K  P   W   O E    5   6 J0\  7  ]  8          9          G    H  J                 0 D X     0205      (  t-\`       %                                      
EPAAV_MAIN                             VAXELN V4.2-00 `t-\ 05-05                                 +            =      >     >     ?     B   
  C     ?         !      	  
LBRSHR_001      !      T 
SCRSHR_001      !      
  
LIBRTL_001      +      e  
PASRTL_001        8     $     EXITFILEHELPPLOTPRINSET TABU$    \         X      ,  4                    &     EXITO  EPA_EXIT 4                   &     FILEHN  EPA_FILE 4                ! )   P1OUTFILE
Save file 4    ,             &     HELPlN  EPA_HELP ,                ! !   P1HELPTEXT  4             &     PLOTF  EPA_PLOT (                ! !   P1M_NAME(                   MODULE   (                   ROUTINE  $  (                 MACRO,  T               & MAXIMUM100 ,                 & MINIMUM0   (                   SOURCE   $                   ZERO $                    FILE       0  X          $                  @  L                  h  t                                  8                 #   '     PRINT`N  	EPA_PRINT   (               %         SET   0           8    ! (   P1OPTIONWhat       T     SET_OPTIONS(        |             	DATA_FILEH              "    0     SET_DATA_SYNTAXTN  EPA_NEW_LOG_FILE   0         8    ! (   P1OPTIONWhat   8                ! *   P2DATAFILE
Data_file    8   d    \      *     	TABULATE4J  EPA_TAB  (                ! !   P1M_NAME(                   MODULE   (                   ROUTINE  $                    MACRO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  P                        vĨ $      ELN042.D                         
  /[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN_V47.EXE;1                                                                                     E                          "            ,  ,               & MAXIMUM100 ,  X               & MINIMUM0   (                   SOURCE   $                   ZERO $                  FILE (            	       COVERAGE $         COVERAGE_KEYWORDS  $    8                 FULL $                      BRIEF    t                    X                                                                  X        $           DATASOUR    4      ,    `            
         	DATAFILE  0                ! )   P1SETFILEFILE  (                          SOURCE0                ! )   P1SETFILEFILE        (           DATARUN_SOUR    <   t      8                 
   *     	DATAFILE N  	SHOW_DATA8                     *     	RUN_SPEC4N  SHOW_RUN 8                     (     SOURCEN  SHOW_SOURCE                                                                    P                                      B                                 D                                                          $      ` 
                                                                                                                                                                                                                                                                                                                                                                      P                                                                           D                                                      $      `                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         EPA>                                                                                            epaa>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        <O                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  xQ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       Q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          b      LOG_FILE             EPA_PERF   datafileVAXELN PERFORMANCE UTILITY V4.2        Analyzer Utility (EPA)                                                         .LOG_Data_file: epaaThe specified datafile contains PC-sampling dataThe specified datafile contains PC-coverage data_Image_name:    _Image_name:    The specified datafile contains JOB sampling data   The specified datafile contains PROCESS sampling data   The specified datafile contains SYSTEM-SERVICE sampling data^ԭ^  mP`^W T  P1  dЏz 1Ru^  PP\\\PPԠOpЏ %ܞܭP  <PPXXW^^Y(XznXY?잭]   1 f ]e-?  X9.?RRR?RRYYVV(?,VPYY PYY?xYYY,Pi ?   & / 8 A  J = V/  4 '  + '  " (   z(   (   (  
111Px\  | ,^^V,(.(ޏ   ޏ   [  P\<,PPV^P~(n.n%^^Pޏ   ޏ   ԭ[  P\<PPV^P~(nn%^^Pޏ   ޏ   ԭZ[  P\ޏ   ޏ   7[  P\0^, n  0, n  _\ ԰֞K؞ԭȰԭКZ  PVVVf1 \1 -   n1 ( SSQЏ   PRR   RPSQSQW( SSQЏ                                                                                                                                                                                                                                                   Q                         $      ELN042.D                         
  /[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN_V47.EXE;1                                                                                     E                         < "               PRR   RPSQSQX ԰֞o؞ԭĞ2Z  Ȟ*Z  ̰КM  PVV jN  
XW\\hVȞܭЏ 0ԭؚğPVЏ   Ԟ0؞Z  КY  Z  ؚY   ^\мRRkY  Μ^,  @ ,< Y  Plv11 ?>   
X  ^X  P1 -?R  ޏ",  ?/?ԭZX  Pwq
11 X  P( `ly?X  l);IW  ޏ!,  ?.Av1XPϠ
 3
 1?W  W  bPѠ70W  {W  W  WW  50rW  DW  ^W   W  JW  W  o,?O @ @1    PPPww1 -?  ޏ,  @ @ 
ԭV  P,&z	
b18X1`X|1|
|PP|ШPШ
Q@Ш
QШPA
hXX< U  PlPРxVxV1VVpP( `lU  lYЭYWW䞭ͤ͜͠
   PPP[[1 p1 ѭ1 ޏ 8,  @ @ 
찏F쭐ԭlT  Pvy1RRP]QRPP[PP1 ZgT  PP`PԠPԠP(B qP͜dPԠRRE>P;`4+)P"RТRBRPՠRPͤ]Q$RPP[PP1 RS  PP`PԠPԠP(B ͤPԠPՠzPwfPcWPTLPERТRB[1 .Pՠ&PѠtR  PP`PЭPԠPՠPPPPRТRBY@   V1oehbVЦ]R  PZ@PZQ  P\\jlPР\ZP`P`1Q  rQ  1Q  bQ  |Q  >Q  hQ  *Q  1 QQ  Q  51Q  Q  Q  P  	Q  P  \P  P  <P  P  P  P  P  mP  v
1<^ԭxP  m\Q(B <(B V<VW!>P
W ?PPQ
W ?QQ`aVWV	<PWPԐVXXPMAIN.MAIN.Ϟά^[XʹЬR߭b
  P1խ1<߭YO  P1SSSRbbbЭ	(|ԫͰZjͼʹ11RR   $)DM )1߭N  P1VSRfSVRRRRRW-W ϚEͰQPSR @  :RnSSSS8(SͰW8 8 8(8:Z 5Ԧ$Ԧ,0Ԧ(46RBZRR ͸1R1߭M  P1VSRfSЪRRWW (RWRb|ƙ 1PR1F߭%M  P1OVSRfSЪRRRR (͸Ԧƙ ͸1R1߭L  P1VSRfSЪRRRR (͸V͸ƙ ƙ Ԧ1_1xR1nЪТ͸͸17Y1OުWWͼͼZZW1gRR#                1 է
M߭K  P1 V
, n   2RR|ԦWSRfSRWRRW1 ~K  իPPhPXWScWVWSԭcЭWAWSԭc<
W,W'WScWWWWWWZW1SSRRSS1ʹʹP@Q\VЬRbѬR\Q PVмRѬRԬVPQ\YЬRТ䞢RѬR1 ЬRТWЬRТVЬRXgS1 S1 SX|f@ f@f(fЬRRbЬRRѬRGЬRТSSTSXY1gSgTf@ f@f(fЬмY1 Y1 gS/ЬRS%SX f@ f@f(fЬY1 мЬRRѬR1ЬRТ䞢RѬRtЬRТWЬRТVЬRTgSSSTgS2ЬRS(ST#ЬRf@ f@f(fЬYмЬRRѬRYP^Q\`VZЬRԢ$ЬRԢ,ЬR0ЬR4ЬRԢ(ԬЬRТ[kYЬRТXЬRТWZRRЬScZRR   1 R   	R   ЬSЬRТ(ЬRТRЬSRR   ChޣSZRݬ߭kRSoPYíhgЬRѢ	 gY1YYP,^\^Zn޼Td޼VfԭԼԼԭЪ1ժ1ЪмЪЭRYмS1 S1 SY1 nЭR8d@ d@d(d:ЭRf@ f@f(fЭRRЪbЭRRѭR]ЭVЦWWXWY]Q "P[1@ѼW$ѼXЬRb@ b@b(bЭн]Q P[1]Q P[1 мR`ЭSRVRYQnЬRb@ b@b(bЬSЭR8c@ c@c(c:ЭЪ]Q qP[1 ]Q P6nЬSЭR8c@ c@c(c:ЭRТ ]Q /P[N]Q JP[[Э9nЬSЭR8c@ c@c(c:ЭЭRТ ]Q P[[ԼЭRâмЭnP^޼Q޼޼޼ԮPZЮVЮ[޼SУ(nռQ*ѼnѼ(YYЬRբ$Т$RѼ$RRYWY1~[1w޼S޼X޼WУ(nQУ$hWfRRT*W 40$TZZ֣,RRR(U1V[T+ f y       k| J  @1W<fRR( 40$֣,U1Wf( 40$֣,U1cfRR$Z,U1P<fRR$Z,U1=f$Z,U1-f0,U1<f0,U10,U1,4U1 ,4U1 <f,U1 <f$QУ$hRh$RRYУ$PU1 f$QУ$hRh$RRYУ$PU1 f$QУ$hRh$RRYУ$PU^WfRR(UMW<fRR(U<Wf(U.WfRR(UW<fRR(UWf(UYiU[UVQѾnѾ(Y/Y+n(h$n(h$ZYP
hYPY[1QЬRТ(nYP^X޼TdRТVRVR޼S<RRcfVdRRVRVVqЦW  ( fz  Pм ЬRbf6  P мX 
   XP  .EXE ԼoRЬQ<PP=Q8 § ߢ  §  P<P< PЬQP(P aRТT  ^nU|~ ݏ   |~e<1 ~<T~  P<ePPUP<P@eS<Ux	UUU~A  PgЎRЎQURcS< VVUUVnP|~ SVb|~`<1 ~<T~  P$<nPPFbR   SVU\P< ЬU?R SS0Fԥ|ЬQŠ Q<PP<Q4c`ߢ  §  P6=<Џ   ߢPЏ   \ߢXP
Џ  Q1? ХP#ѥХhlvߢXPԥPPߢP< bRЬU vߢXPB<zP
Ҁ Тhl֥ѥαP < PЬQP(PҀ aPPߢP     m_name  module  source  m_name  m_name  macro   zeromaximum maximum minimum minimum m_name  filefilemodule  source  m_name  m_name  macro   zeromaximum maximum minimum minimum m_name  filefilecoveragecoverageFULLhelptexthelptextvaxeln /analyzer    epaa.tmp ^ԭ>  mЏ@ %𞭬G1  ݏF   g>  P\l\ RSRT<PQ
RPQQ
aQQ,<SP
P ? PQ@STRSSݏF   
>  Pll\lTR<TRTS <^ԭ=  m^\	PC  }{.0  P		J0  P1  	/  PpЏ  %̭İƞȟ/  P<QPQ0PRRST
S ?TT<SU
RSUU
edQPӰ7C/  P_ 	V/  P /	  $.  PXЏ  %̭İƞȟ.  <PPVV\^^W(VnVW;  PPxh.  PXЏ  %̭İƞQȟ|.  <PPWW\^^V(WnWVP;  PP>V-  PV
PPVV ϖ-  Pb Џ  %̭İƞȟ-  <PPVV\^^\(VnV\?':   <^ԭ:  m^\OI	?PC  97,  P		,  P1  	,  PmЏ  %̭İƞȟ,  P<QPQ-PRRSrT
S ?TT<SU
RSUU
edQPӰK+  P 	"+  P 	  +  PXЏ  %̭İƞ                                                                                                                                                                                                                                                   R                        UǺ $      ELN042.D                         
  /[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN_V47.EXE;1                                                                                     E                         ` "     '       ȟ+  <PPVV\^^W(VnVW8  PPi +  PXЏ  %̭İƞeȟ4+  <PPWW\^^V(WnWV8  PPV#*  PVPPVV Na*  Pb Џ  %̭İƞȟl*  <PPVV\^^W(VnVW?<7  l)  PsЏ  %̭İƞEȟ)  <PPWW\^^\(WnW\ 6  -     sp  _\  K  	?  3 <^ԭr6  m^\( ֐
̰ΞiП(  P,Џ  %̞ԭП̰İƞBȟ(  <VVWW   W\^^\(n(Vc-PW`(l`  ^5         B      EPA_PERF   epa$p_set   epa$p_show  outfile epaa.tmp.EPAeln$:epa_help   epaa.tmp  \	E5  5  85  5  \P  
5  4  5  4    4^\Џ  %ԭ̰ΞXП'  n4  ԭ֭̰ΞП4  \P  \	?r
4  c3  \P  ^3  ߏ   
`Tߏ    3  N3   ^3  v3  ZPѠ9\ЬRТSS3  cSR}3  bR\o3  l\     B      EPA_PERF       a      RPT_FILE   epaa.tmpepaa.tmp.EPAPC_coverage samplingJOB samplingPROCESS samplingSYSTEM SERVICE sampling PLOT Command Summary information:   TABULATE Command Summary information:   Datafile =  System file       : Up time           : Idle time         : CPU1 Idle time         :    CPU2 Idle time         :    Begin time        : Stop time         : Clock rate        :  ms Sampling interval :  ms Total data points : Bucket size       :  bytes  Traced S0 counts  : Untraced S0 counts: Specified datafile does not contain PC-sampling data                VAXELN Performance Analyzer                Program Counter Sampling DataModule/Routine  Count   Percent                    Program Counter Coverage Data               Program Counter Sampling DataCoverage    Percent     Count       Line>>>0<<<   **    :   JOB Sampling Data     JOB    NAME   CONTEXT TIME.LOG secPROCESS Sampling Data   JOB       NAME  CONTEXT TIME.LOG PROCESS(ES)*PROC    secSYSTEM SERVICE Sampling Data.LOG м\RR\RRS u2/  R\ м\PzQбRТQѡ\
QPQaQQRbw< p^ԭ.  m(B (B pPp;\<QQ\Q.\R
R ? UESErT S TSTPQ\P(^ԭ.  m(B l^-V1 l1q Э\^(B (B l(X(<P<QQPQ+PY
Y ? RBZB*[ Z [Z[XQPXЭ^\XWWWVfVV1nWWP< ^ԭ-  m^\ܰޞ`-  ,U ? 5(?߾<?p-  c,  NپR޹  1b
 ? c   1 ]Qυ1 ,  ,  ,  ,  j,  ,  ,  ,  F,  ,  ,  l,  ",  e,  ,  H,  bb B L V  R]QE ]T]QϮ]Q ]Q J]Q +  +  +  +  +  '!+  }+  %%s+  V+  I+  {D+  b++  U+  H+  ˼PѠ1  T<TRUP
RPP
Q`֭P
  RQBQQ PRѭ RPRRT,*  VT|*  _*  )PѠPѠ1TPP<TQUR
QRR
 QSAÛ bPϟ9*  VT$)  )  PP<TRUS
RSS
 RvQBmcPfP  :L)  VTt)  W)  1 &O)  VTq:)  d)  TPP<TSUQ
SQQ
 SﾺRC aPϟ(  VT (  (  (  TPP<TQUR
QRR
 Q>SA?bPПn_(  VTJ(  t-(  TPP<TRUS
RSS
 RιQBVcPП&'  VT'  '  PѠ1wPǏ'  8'  ݭ}'  p'  S'  PĠ<yB'  ݭg('  ~R'  E&  8&  S#&  ݭ&  &  3&  pPݠ&  &  m&  h&   PݠG&  y2&  d-&  PݠK&  >%  1%   {%  ݏ   %  %  %  %  %  %  0
W%  1\^7%   QR\\;PѠ.4]%  6%  P%  %  R)%  PԢ`cТPVQ@\dﹱ\PQ9PѠa,PРa
7PРPѠaPРaP`P`ڲ1u
B	:2	RQ !RQ $< ^ԭV$  mQ\U$  +@	$  3#  &#  ,#  #  #  #  /ߏ   8ﾾ#  ߏ   
ߏ;   	X#  ;#  PP1
P<				P	QPQ7PPR<bS
S S
T
T ? T*UDCPQլ
PNPNQFQPEC  P bPՠ15QQ1'Q?1
P`M"  /s0"  8<PP#蟬vPݠD"  ߏ   Ϟr<PP蟬ϊ?R
﫮*Pߏ2   b\Q+Pߏ2   b\QP`ż!  ﰼu!  %\!  K!  
 1PР Pՠ1P<				TP	RPR9PPTQ<aS
S S
U
U ? U&TECPRլPNPNRFRPEC  PQ`15QN1'
:P`\   /?   u.   
[$   TP`D
   9<TPP"蟬ϓKPݠ  ߏ   oM<TPP蟬Z*Pߏ2   P\QP`ﻺ  了k  %R  A  吝P`1P`1^ԭ4  mQ\^TW9+  	    %,  ֹ  #",ﾹ  ﱹj  魯]   %ߏ   |E  -b+  
M  8  +  ԭЭV^:P(B X﫪1 P`X1y ЭW^P(B `(B XZ@P<QQPQ-P
 ? RB[BX [ X[XZQPZЭ^WZYYYԭнխ1_YYЭ^V譠1.`VЦVWѧVpWgXչ͹1ﷹﶹP\QPРPР
VWVW1PVV֭PLQ@Ƹ<Q<ﱸ立qQ(P1Pߏ   χ1 \լPNPNQFQPEC  Pܶ  %˶  ߏ   %Dߏ   PՠIZ  :zC  8*Pߏ   P\QJP`>  * *"Pݠ  ߏ   u    3d (T	dTP<TQPQ7PTR<bS
S S
TU
T    UUeCQPʟ:p9  TP`Y"  L  VW1VfO&V@WѦ2Wg*ԭ!1^P︶1 ﮶UХUХ
UVUV1 UUPW^PRSﮧXиݵֵXШTѤR
TSTdTTﳵXh﫵P^WPSWѧ
WЧUV1vUe1)^ԭ  mмPмRмSTUSNSSRPNPPFSPKPPP_ЬS<cV
V V
|FUURP5RPSRS(RRUVЬW<gX
VX X
THRSPR<SUSRS&RRUTЬW<gX
TX X
 HRS^ԭ  mQ\  +      ߏ   Cɲ  Ｒu  ﯲh  [  mV  ߏ   Um6  ߏ   =M  ߏ	   ϧ%-       PРi                                                                                                                                                                                                                                                   S                         $      ELN042.D                         
  /[SYSEXE.SEAS$WORK_0000005C]EPAAV_MAIN_V47.EXE;1                                                                                     E                               8       ݏ     PY|  ڧ?Q  ﳥ<  PQ( a`_  VWVW1VVܲPeQ( a`X%  ﻲP(,`﫲XYXY19X1  ߏ   b TPPTQ<aR
R R
ES
 SScB PϞTP`﫰t  ߏ   )L  ߏ	   PN8PGtJ $P6NPD)PG"P <  ''    pP
P , PʱP(,`iYXVW1o$^ԭ  mQ\^,  y  g+﫯t  W  J  ߏ   uq:  d  W  J  Q5  ߏ   Ϗ9  ߏ   o!  ߏ	   O	ծ  Ȯ  ﻮt  >PРݏ   |  P$  ?h  [  ﾯPGQ( a`:  WW1WWP	Q( a`  _ﶯﰯP(,`OZ[Z[1cZ)31-BѬ<省^  Y  <  v/  ۮa"  ߏ   ϻ TＮ 9PPTQ<aR
R R
S
 SScB P1 vܰޞܟX  XXY9 RRRRR&YRPP RPPPPP,R` X
XX   X^^V(n(cTPX`(f`TP    `  ^^V,`  n   	TP `(f`TP`%  ߏ     ߏ	   _}PN8PGtJ $PﰭNrPDPG"Pﶫ{  j  M  P
P , PDP(,`[ZW1D ^ԭ:  mQ\D  +/  "    ߏ   oI    ۪  Ϊ  QPР$ݏ     P7  ?{  n  ѫPZQ( a`M  V恵WVW1VVP!Q( a`  wҫ̫P(,`Q1~ (TPPTQ<aR
R R
]S
(SScB(PϞTP``  ߏ
   w8  j#  ﻪ)
ﲪ , PP(,`ڪت13VW1  0^^U5PSQ!, n QbSR!PS(Seb0^^UPSSPP(PebU$TQ
   |P`P2`P`PPPTQ{
PPR0RuPT-uЎRUP  < `^, n 䐏P    ݬ  ^|   VX^, n 䐏Q    ݬf^PRݬ\  l$լݬfRP| +  VD^, n ȐSȞ+  ؞  ܕlլݬfЬ̑lլ
lլ, n 䞭l
լЬl
լЬlլݬf^< `^, n 䐏T  e  l
լЬ^< `^, n 䐏U@  $  ݬ  ^                                                                                                                                                          P   z                                                                                          ) pz  !/SYSTEM SERVICE ERROR AT APP. !XP R0=!XL   z  01-JUL-1990        V5.0 z  VAXELN-TOOLKIT z  DEC            z  z         z  {  z    z        z            |~    P')ugPXPPnPϖPP%|~  ~|~ <0 ~<a~                                                                                                  e         `  (   R                         {       0  X   ~  (  0  8  @`  H  P  X  `Z  h  p  x*  t      8  l        L  v                   RETRYretrying connect(        
NO_CONNECTconnection failure &        	BAD_STATEinconsistent state6        INSUF_MEMORYinsuffient memory for operation2        BAD_MODEEPC job must be a kernel job   2        	UNDEF_RUNrun type has not been defined H        UNDEF_DATAFILE/performance data file name has not been defined6        
NOT_CONNECTEDnot connected to an ELN target>        FILE_OPEN_ERROR#error opening performance data file <        NO_DATA*no performance data is currently availableJ        TIMER_INTERVAL1warning time interval specified has been rounded H        BUCKET_ERROR1invalid bucket size specified, default of 16 usedB        INTERVAL_ERROR(invalid interval specified, default used F        IMAGE_ERROR/invalid image size specified, default of 0 used J        CODE_STRT_ERROR/invalid code start specified, default of 0 used D        KWV_CONNECT_ERR)unable to connect to specified KWV device 6        NO_JOB%job image not currently in the systemJ        ATTEMPTING_CONN0attempting to connect to ELN target, please wait4        CONNECT_COMPLETconnect circuit completed .        SUCCESSsampling session initializedJ        SYSTEM_STARTED1target system currently running, data may be lost.        SESSION_RUNNINGEPC session resumed :        WAIT*writing performance data file, please wait *        INVARGinvalid argument supplied:        OPENIN_IMAGE"error opening specified image file 8        OPENIN_DATA!error opening specified data file 8        NOTDATA&specified file is not an EPA data file2        BADDATA specified file contains bad data EPCEPA                                                                                                                                                @   @                                                     s         8   H               `  H      x    P              (             (  8    x     8  p    `    h        x                 
                 @                                                                       LBRSHR                                                         SCRSHR                                                         LIBRTL                                                         PASRTL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           * * [SYSEXE.SEAS$WORK_0000005C]EPACEMAIN.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6  *Ʌ]  7 C]  8          9          G    H  J                      0 D X     0205      (  t{]`     0                                        	EPACEMAIN                              VAXELN V4.2-00 t{] 05-05                                                
       ?   "      !        
PASCALMSC_001"      !         
LIBCOMMON_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 B      EPA_PERF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             T                        r?g $      ELN042.D                         
  *[SYSEXE.SEAS$WORK_0000005C]EPACEMAIN.EXE;1                                                                                                                   %! "                                                                                                                                                                                                                                                                                                                                                                                                                  x                                                                                                              COLLECTOR_PROCESS_EPA|^(b n   
 R0RR\\RR9RR\
 R0RRVVRR9RRV 
 3(󐯇\SRЭS(nV\(\S2Sޭ ߭>   ޯPR R   R b߭   |~  P^ { |~|~C   4|~  |~!߭߭@ 1R~ p  \l\Ԭ\l ( L   x zRk  PS`   PS<`tv\  PS4  PSS
!\l\S\	߭  V   P\\\1߭  1|0000 00:00:00:50epaaV                               <^޼n(S|~옏~ݮ߭` SSP^޼WЏX޼Vf(ǌ Ԧ!Aǰ 1Ǭ =Ԧ9ԦFǼ RR rѦ==	զ==Ѧ11ߦ5ߦ)  զ5< 5զ)"ЏX20
 RxRR  RǏ   R)Ǹ Ǹ 5Ǵ   Ǵ RǏ   R)ǈ x	)RRR)x	)RxRRǦ1R)XPϞ^Y޼Z޼XhZP hϐ
P
 R2P! ݨ)ߨ-߭x Э[[1-  )RƏ   Rx	RWя  WWR, n R-5Ш-VW  , n f  V  WW  WR, n Rfʈ WW1  i1 ЬRТ=V<V,  ʼ UUS TRRTUSUSUUU(ʽ ʼ ϘV  PSV
  PSS!S  SЬRߢ%S~  | W| Э$[|  
Џ [|  Џ(ЭP^W޼Y޼Vf(Ɍ Ԧ! fЏZP R2P!߭߭<  խЏZ޼V   )  )SƏ   Sx	SS Sߦ-߭x ЭXX>SR, n R-   R(R  -  Rߦ%R@~  | Z$X|  
Џ X|  Џ(ЭP^޼V20
 R,R)  )RƏ   Rx	R) ݦ)ߦ-߭x ЭWW/E| , n )-Ц-S,)RR-Џ$W|  
Џ W|  Џ(ЭP^wW޼Y޼Vf(Ɍ Ԧ! fMP
 R2P!߭߭  2( S20
 RRS,S)  )RƏ   Rx	R) ݦ)ߦ-߭x ЭXX@խ
ЏЏE| , n )-Ц-S,)RRR-$X|  
Џ X|  Џ(ЭP^V޼WЏXf41 ǈ   0 B  F WυPX4 WPX" WϥPX WPXX74(    ( ЏX߭ XP^S41 4޼R| TT6 c Ü P ύ	   0   ' ݢ%~2  T ݢ%@~  R߭ ޼P}0 ` }8 P Тß( b` ٟ, PЏPWмV4( | Ɛ (  Ɣ П ƴ П Ƹ 	 Rş RƼ П  П  ЏPδ^WЬ(N ЬX~߼Ǡ  p  мRbмRXǨ Ǡ ߼_< ~@D p   HR L(  `XPT$X1\ g<'(П (  (  (R ҢTbSS  T}Snn  (޼ V ҦSfRR  S}R  (  * ҦSҦRR  S}Rw  (@V, n  f( HfǨ |~  |~Ǩ ߭Ǥ ߧ@ Ǥ ߧ  |~Ǩ ~D<` XϞ8^XЬ8Y| RRYݟ   | ՟ [   	 [Ə   [Y[[߼߼[ 8ϢП
 Vß  W[1 ZȨ |~  |~Ȩ ߭8Ȥ ߨ@ Ȥ ߨ  < ~@D p  UП TUUSTWCYfC V	<fC VTW?U( @|~Ȩ ~D<` [ZWݟ
 ݟ	 < PϞ^TWЬ| % *߭x  }Pnn|~ % ట& R2RSSZZZx	Z[߼߼Z ݭ@|~[߭߭0  1 Sݟ	 ݟ
 ݭ,
  ЭXZ1 YǨ |~  |~Ǩ ߭߭Ǥ ߧ@ Ǥ ߧ  < ~߭߭ p  ЭV, n  f(hf|~Ǩ ~ݭ߭`   XZYݭ[߭ ЏP$^޼Rb(bП UYVX޼TZު WWSSUddRТ<R-#% XYVdRТ UVޟ RURVԼYP<^(N UЭTTS2RRUУ
TUPϞ^fWЬ| % ,)߭  }P|~ % T՟ "߼߼  ݭ]1C  P  S2PRR  2RRRTT PTTZZZx	Z[߼߼Z ݭ|~[߭߭0  1 Tݟ	 ݟ
 ݭ,   ЭXZ1 YǨ |~  |~Ǩ ߭߭Ǥ ߧ@ Ǥ ߧ  < ~߭߭ p  ЭV, n  f(hf|~Ǩ ~ݭ߭`   XZYݭ[߭ ЏP^WЬ씟|   ZZZ՟ "߼߼  ݭ1 ߼߼Z ݭϢП
 XZ1 YǨ |~  |~Ǩ ߭߭Ǥ ߧ@ Ǥ ߧ  < ~߭߭ p  ЭV, n  f(hf|~Ǩ ~ݭ߭`   XZYݟ
 ݟ	 ߭ ЏP^RЬ| PP ) F c  r߼߼ݭϕPU߼߼ݭP8߼߼ݭϨP߼߼ݭNPЭn¨ |~  |~¨ ߭߭¤ ߭@ ¤ ߢ  ~߼   p  мP`nP0000 00:00:01.00|^V޼Rb(b޼UЏܰS2SޭNR ߦ ߦ fߦR߭߭
P  Џ1fRo߭N  }PfRТЭfRЭ}S}S|~ ԭfRТ}S|~ ֭ѭ
Џ1 fSУ@ 	RR Э@ԭ߭f  fRЭfRТ(	Э(ЦSRR ԦЦSURRASRRSRRSSЭP^޼R   nAQ PPPPQPPPPQQ  \ ݬ    ^޼n e  AP PPP |0^V޼Rb(b޼TЏS2SޭޭޯR ߦ|~ ߦfR߭߭
P  
Џ5 ԦSTRRSЦRSASЦRRSЦRRSSЭP F\ ݬ   | ЬVޟH UeUPѥVPR{ IB:
 Q~ݡݡ00Џ   0xPȏ   (Ў0Ўڎݏ|   8 ~0xPQQ_   ڎ ЬTޟH ScSѣTRB
 RԼR ЬTޟH ScSѣTT<D           INPUT    a     OUTPUT~}P~}R~ R  QPdP!]עAXТ=AN]SЮPBP#Q¢5PƢ1PPQQ)@-$֢91  cУP `УSP1֢FТ%}R}P    }P~}R~ R  QPZP!SLN]SЮHPBP#Q¢5PƢ1PPQQ)@-H$֢91  cУP `УSP1֢F}R}P ~}P~   PP!ЮQ,QQ)-QaР%}P ԼԼЬP`Qޟ YiYU<#R%SRIBaTBcUUTRЩ[Щ <kPP[k ЫR<kPP[kRR    XXYЩYXYNQ<0PPBPĬPЬSPS<0ЩR#Q,Q%  c<^VfPРpcVWfVVWlc1ЬVVX<W;VQfPPĬPPQ(faVWШ
Vhݬ   1hݬ     XЬZ   ЬS<PЪ<Y#X,X%  c<~Sn  Ճ,X%  cVVXfV1H fVVX1P ЬS<QQBQTĬTTSQЦ4RТzTQQ,Q$  c1 (   c<Цll  1ЬVVX<WMVY|PYY1 fYYPPQ(fa(  VWШ
Vhݬ   1hݬ    ~R~Sbch bW}RЬQQT0+ П RRbTլb~Tbڎ  Ч<PРTSSФRQR3x	PRPQP)PR<dPPTSTФTPЎTS^PФSRQPPSTP                                                                                                                                                                                                                               UUVЦVVU:<0QЦP#걬Q%ЦRVfPVUfVVUЦ4Rʏ  @L1    accept_circuit                              allocate_map                                allocate_path                               allocate_memory                             clear_event                                 connect_circuit                             create_device                               create_event                                create_job                                  create_message                              create_name                                 create_port                                 create_semaphore                            create_process                              current_process                             disable_asynch_exception                    disable_switch                              delete                                      disconnect_circuit                          enable_asynch_exception                                                                                                                                                                                                                                                        U                        Ǐ $      ELN042.D                         
  *[SYSEXE.SEAS$WORK_0000005C]EPACEMAIN.EXE;1                                                                                                                    
                            enable_switch                               exit                                        free_map                                    free_path                                   free_memory                                 initialization_done                         job_port                                    receive                                     resume                                      send                                        set_job_priority                            set_protection                              set_process_priority                        set_time                                    signal                                      suspend                                     translate_name                              wait_all                                    wait_any                                    raise_debug_exception                       enter_kernel_context                        raise_process_exception                     create_area                                 install_program                             remove_program                              set_user                                    get_user                                    memory_size                                 set_job_eligibility                         get_jcb                                     allocate_system_region                      free_system_region                          post_errorlog                               create_shared_device                        get_uptime                                  create_area_semaphore                       create_area_event                           get_object_address                          allocate_memory_withbase                    wait_all_expedited                          wait_any_expedited                          save_proc                               >   
                                                                                                                                                                                              @   @       T   `                                                          .   
                 @                                                                       	PASCALMSC                                                      	LIBCOMMON                                                                                                                                                                                                                                                                            . * [SYSEXE.SEAS$WORK_0000005C]EPACEMAIN_V47.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6  N0\  7 ^  8          9          G    H  J                  0 D X     0205      (  %\`     0                                        	EPACEMAIN                              VAXELN V4.2-00 %\ 05-05                                                
       ?   "      !        
PASCALMSC_001"      !         
LIBCOMMON_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 B      EPA_PERF                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 x                                                                                                              COLLECTOR_PROCESS_EPA|^(b n   
 R0RR\\RR9RR\
 R0RRVVRR9RRV 
 3(󐯇\SRЭS(nV\(\S2Sޭ ߭>   ޯPR R   R b߭   |~  P^ { |~|~C   4|~  |~!߭߭@ 1R~ p  \l\Ԭ\l ( L   x zRk  PS`   PS<`tv\  PS4  PSS
!\l\S\	߭  V   P\\\1߭  1|0000 00:00:00:50epaaV                               <^޼n(S|~옏~ݮ߭` SSP^޼WЏX޼Vf(ǌ Ԧ!Aǰ 1Ǭ =Ԧ9ԦFǼ RR rѦ==	զ==Ѧ11ߦ5ߦ)  զ5< 5զ)"ЏX20
 RxRR  RǏ   R)Ǹ Ǹ 5Ǵ   Ǵ RǏ   R)ǈ x	)RRR)x	)RxRRǦ1R)XPϞ^Y޼Z޼XhZP hϐ
P
 R2P! ݨ)ߨ-߭x Э[[1-  )RƏ   Rx	RWя  WWR, n R-5Ш-VW  , n f  V  WW  WR, n Rfʈ WW1  i1 ЬRТ=V<V,  ʼ UUS TRRTUSUSUUU(ʽ ʼ ϘV  PSV
  PSS!S  SЬRߢ%S~  | W| Э$[|  
Џ [|  Џ(ЭP^W޼Y޼Vf(Ɍ Ԧ! fЏZP R2P!߭߭<  խЏZ޼V   )  )SƏ   Sx	SS Sߦ-߭x ЭXX>SR, n R-   R(R  -  Rߦ%R@~  | Z$X|  
Џ X|  Џ(ЭP^޼V20
 R,R)  )RƏ   Rx	R) ݦ)ߦ-߭x ЭWW/E| , n )-Ц-S,)RR-Џ$W|  
Џ W|  Џ(ЭP^wW޼Y޼Vf(Ɍ Ԧ! fMP
 R2P!߭߭  2( S20
 RRS,S)  )RƏ   Rx	R) ݦ)ߦ-߭x ЭXX@խ
ЏЏE| , n )-Ц-S,)RRR-$X|  
Џ X|  Џ(ЭP^V޼WЏXf41 ǈ   0 B  F WυPX4 WPX" WϥPX WPXX74(    ( ЏX߭ XP^S41 4޼R| TT6 c Ü P ύ	   0   ' ݢ%~2  T ݢ%@~  R߭ ޼P}0 ` }8 P Тß( b` ٟ, PЏPWмV4( | Ɛ (  Ɣ П ƴ П Ƹ 	 Rş RƼ П  П  ЏPδ^WЬ(N ЬX~߼Ǡ  p  мRbмRXǨ Ǡ ߼_< ~@D p   HR L(  `XPT$X1\ g<'(П (  (  (R ҢTbSS  T}Snn  (޼ V ҦSfRR  S}R  (  * ҦSҦRR  S}Rw  (@V, n  f( HfǨ |~  |~Ǩ ߭Ǥ ߧ@ Ǥ ߧ  |~Ǩ ~D<` XϞ8^XЬ8Y| RRYݟ   | ՟ [   	 [Ə   [Y[[߼߼[ 8ϢП
 Vß  W[1 ZȨ |~  |~Ȩ ߭8Ȥ ߨ@ Ȥ ߨ  < ~@D p  UП TUUSTWCYfC V	<fC VTW?U( @|~Ȩ ~D<` [ZWݟ
 ݟ	 < PϞ^TWЬ| % *߭x  }Pnn|~ % ట& R2RSSZZZx	Z                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  V                         $      ELN042.D                         
  .[SYSEXE.SEAS$WORK_0000005C]EPACEMAIN_V47.EXE;1                                                                                                               H             [߼߼Z ݭ@|~[߭߭0  1 Sݟ	 ݟ
 ݭ,
  ЭXZ1 YǨ |~  |~Ǩ ߭߭Ǥ ߧ@ Ǥ ߧ  < ~߭߭ p  ЭV, n  f(hf|~Ǩ ~ݭ߭`   XZYݭ[߭ ЏP$^޼Rb(bП UYVX޼TZު WWSSUddRТ<R-#% XYVdRТ UVޟ RURVԼYP<^(N UЭTTS2RRUУ
TUPϞ^fWЬ| % ,)߭  }P|~ % T՟ "߼߼  ݭ]1C  P  S2PRR  2RRRTT PTTZZZx	Z[߼߼Z ݭ|~[߭߭0  1 Tݟ	 ݟ
 ݭ,   ЭXZ1 YǨ |~  |~Ǩ ߭߭Ǥ ߧ@ Ǥ ߧ  < ~߭߭ p  ЭV, n  f(hf|~Ǩ ~ݭ߭`   XZYݭ[߭ ЏP^WЬ씟|   ZZZ՟ "߼߼  ݭ1 ߼߼Z ݭϢП
 XZ1 YǨ |~  |~Ǩ ߭߭Ǥ ߧ@ Ǥ ߧ  < ~߭߭ p  ЭV, n  f(hf|~Ǩ ~ݭ߭`   XZYݟ
 ݟ	 ߭ ЏP^RЬ| PP ) F c  r߼߼ݭϕPU߼߼ݭP8߼߼ݭϨP߼߼ݭNPЭn¨ |~  |~¨ ߭߭¤ ߭@ ¤ ߢ  ~߼   p  мP`nP0000 00:00:01.00|^V޼Rb(b޼UЏܰS2SޭNR ߦ ߦ fߦR߭߭
P  Џ1fRo߭N  }PfRТЭfRЭ}S}S|~ ԭfRТ}S|~ ֭ѭ
Џ1 fSУ@ 	RR Э@ԭ߭f  fRЭfRТ(	Э(ЦSRR ԦЦSURRASRRSRRSSЭP^޼R   nAQ PPPPQPPPPQQ  \ ݬ    ^޼n e  AP PPP |0^V޼Rb(b޼TЏS2SޭޭޯR ߦ|~ ߦfR߭߭
P  
Џ5 ԦSTRRSЦRSASЦRRSЦRRSSЭP F\ ݬ   | ЬVޟH UeUPѥVPR{ IB:
 Q~ݡݡ00Џ   0xPȏ   (Ў0Ўڎݏ|   8 ~0xPQQ_   ڎ ЬTޟH ScSѣTRB
 RԼR ЬTޟH ScSѣTT<D           INPUT    a     OUTPUT~}P~}R~ R  QPdP!]עAXТ=AN]SЮPBP#Q¢5PƢ1PPQQ)@-$֢91  cУP `УSP1֢FТ%}R}P    }P~}R~ R  QPZP!SLN]SЮHPBP#Q¢5PƢ1PPQQ)@-H$֢91  cУP `УSP1֢F}R}P ~}P~   PP!ЮQ,QQ)-QaР%}P ԼԼЬP`Qޟ YiYU<#R%SRIBaTBcUUTRЩ[Щ <kPP[k ЫR<kPP[kRR    XXYЩYXYNQ<0PPBPĬPЬSPS<0ЩR#Q,Q%  c<^VfPРpcVWfVVWlc1ЬVVX<W;VQfPPĬPPQ(faVWШ
Vhݬ   1hݬ     XЬZ   ЬS<PЪ<Y#X,X%  c<~Sn  Ճ,X%  cVVXfV1H fVVX1P ЬS<QQBQTĬTTSQЦ4RТzTQQ,Q$  c1 (   c<Цll  1ЬVVX<WMVY|PYY1 fYYPPQ(fa(  VWШ
Vhݬ   1hݬ    ~R~Sbch bW}RЬQQT0+ П RRbTլb~Tbڎ  Ч<PРTSSФRQR3x	PRPQP)PR<dPPTSTФTPЎTS^PФSRQPPSTP                                                                                                                                                                                                                               UUVЦVVU:<0QЦP#걬Q%ЦRVfPVUfVVUЦ4Rʏ  @L1    accept_circuit                              allocate_map                                allocate_path                               allocate_memory                             clear_event                                 connect_circuit                             create_device                               create_event                                create_job                                  create_message                              create_name                                 create_port                                 create_semaphore                            create_process                              current_process                             disable_asynch_exception                    disable_switch                              delete                                      disconnect_circuit                          enable_asynch_exception                     enable_switch                               exit                                        free_map                                    free_path                                   free_memory                                 initialization_done                         job_port                                    receive                                     resume                                      send                                        set_job_priority                            set_protection                              set_process_priority                        set_time                                    signal                                      suspend                                     translate_name                              wait_all                                    wait_any                                    raise_debug_exception                       enter_kernel_context                        raise_process_exception                     create_area                                 install_program                             remove_program                              set_user                                    get_user                                    memory_size                                 set_job_eligibility                         get_jcb                                     allocate_system_region                      free_system_region                          post_errorlog                               create_shared_device                        get_uptime                                  create_area_semaphore                       create_area_event                           get_object_address                          allocate_memory_withbase                    wait_all_expedited                          wait_any_expedited                          save_proc                               >   
                                                                                                                                                                                              @   @       T   `                                                          .   
                 @                                                                       	PASCALMSC                                                      	LIBCOMMON                                                                                                                                                                                                                                                                            * * [SYSEXE.SEAS$WORK_0000005C]EPACVMAIN.EXE;1 +  ,    . '    /     4     '   (                     - 
    0   1    2   3      K  P   W   O (    5   6 Jx]  7  24^  8          9          G    H  J                      0 D X     0205      (  ~]`     J  4                                      	EPACVMAIN                              VAXELN V4.2-00 N~] 05-05                                        
            !     !     "     %   
  &     ?         !      	  
LBRSHR_001      !      T 
SCRSHR_001      !        
LIBRTL_001      +      e  
PASRTL_001        8   L  $     EXITGO  HELPSET SHOWSTOPWAIT$    \              
  
  4                    &     EXITp(  	EXIT_FUNC0                    $     GO(  GO_FUNC4                  &     HELP@'  EPA_HELP ,                ! !   P1HELPTEXT  (    H           %         SET   0           x    ! (   P1OPTIONWhat            SET_OPTIONS(      P             	DATA_FILE$      P             NODE ,                   P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  W                        
 $      ELN042.D                         
  *[SYSEXE.SEAS$WORK_0000005C]EPACVMAIN.EXE;1                                                                                          '                          "            C_SAMPLING  (    4               COVERAGE 0    d               PROCESS_SAMPLING ,                   JOB_SAMPLING 8                     SYSTEM_SERVICE_SAMPLING  T              "    <     SET_SERVICE_SAMPLING_SYNTAX9  SYSTEM_SERVICE_FUNC0   L      x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  P                     8     SET_JOB_SAMPLING_SYNTAX*  JOB_SAMPLING_FUNC  X    (          "    <     SET_PROCESS_SAMPLING_SYNTAX2  PROCESS_SAMPLING_FUNC  0   X      x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  L `    <      "    4     SET_COVERAGE_SYNTAX-  PC_COVERAGE_FUNC   0         x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  ,  h              ) 
IMAGE_SIZE00                  ) 
CODE_START512  L `    H      "    7     SET_PC_SAMPLING_SYNTAX-  PC_SAMPLING_FUNC0         x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  ,  t              ' INTERVAL10 ,                ) 
IMAGE_SIZE00                * BUCKET_SIZE16  0                 ) 
CODE_START512  (  (              " KWVKWV (                  " KWBKWB @ `          "    0     SET_NODE_SYNTAX +  	NODE_FUNC  0         x    ! (   P1OPTIONWhat   4                ! *   P2NODENAME	Node_name,                 ( 	BI_NUMBER0 0                  - ADAPTER_NUMBER0D              "    0     SET_DATA_SYNTAX   
DATAFILE_FUNC  0         x    ! (   P1OPTIONWhat   8                ! +   P2	DATA_FILE	Data_file   (    $	           &         SHOW  0           T	    ! (   P1OPTIONWhat        t	     SHOW_OPTIONS   (    	  h
             	DATA_FILE$    	  (
             NODE (        	             RUN_SPEC @                 &   0     SHOW_RUN_SYNTAX4  SHOW_RUN   @                 &   1     SHOW_NODE_SYNTAX 4  	SHOW_NODE @                 &   1     SHOW_DATA_SYNTAXp3  	SHOW_DATA 4                 (   &     STOP8  	STOP_FUNC4                  &     WAIT;  	WAIT_FUNC<                ! *   P1TIME_VALTime in Seconds                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ::"0=EPA                                                                                                                                                                                                                                                                                                  EPC>                                                                                                                                                                                                                                                                                                                                                                                                                                                                          EPA_PERF   bi_number   adapter_number  bi_number   bi_number   adapter_number  adapter_number                              data_file   vaxeln /collector   helptexthelptexteln$:epa_help   VAXELN PERFORMANCE COLLECTOR V4.2          Collector Utility (EPC)  nodenamenodename.LOGjobname jobname kwv kwv kwb kwb intervalintervalbucket_size bucket_size image_size  image_size  code_start  code_start  jobname datafile name is:   node_name is:   run type: process sampling  run type: job sampling  run type: pc sampling   run type: pc coverage   run type: system service sampling   job name:               sampling interval:   ms bucket size:        image size:         code start:         image size:         code start:         jobname                                                       time_val  %  P  ϿP;/  <^ԭD/  m\((^VPPWQ
WQQa Q
VQQR
WRRbaVPϔؔԔR	C̚   PRS%̚f   PSRSS1	̚5   Pm	Џ  %<̚?   P<<PPZZ^^[(Z>nZ[̞ȭ-  PذȰʞ̞ȭ  PmȰʞs̞ȭЏ  %`  P<`PP[[^^Z([bn[Z̞ȭ^-  PԀ0؀0ԑ9ؑ9ZZ   Z^^[(n(_cZXX   X[^^Y(Zkn(cX[[   [Y^^Z(Xin(_c[YY   YZ^^X([jn(cYZZ   ZX^^[(Yhn("c,Zk ,[[   [^^Z(n("c,[j ^\(((ЏT V2PW䭼ޏQFT/ԭԭPPWWI  ޏX1	W   	W   fVbVXޏPYȭԭԭԭ PYxPY1 Xkޏ]WĭЏ vԭPY-RЏ   D*  *  *  *  X1WI   < ^ԭz*  m\QQP
P  RЬSBSS   &S
P  SЬR
P  TЬU CD Q< ^ԭ*  m, n  	Џ %ܞܭ  P\\=  	,    	,  ^\( Vԭ2V2ОԞЭԭԭԭԭԭԭğ PWS1 ޏ_	25䞭Џ ؞tܞحԭPX-PЏ   B(  (  (  (  1 2V2ОԞԭԭԭԭԭԭğ PXe1 Y 1 ޏk29䞭Џ ؞ܞحԭPX-\Џ   N'  '  '  '  ^\( мVWԭ2W2ОԞЭԭԭԭԭԭԭğ PXc1 ޏo2E䞭Џ ؞ܞحԭPY-`Џ   R&  &  &  &  1 2W2ОЬVԭԭԭԭԭԭğ PY|1 ޏϐ2^䞭Џ ؞ܞحԭPY-Џ   s%  %  %  %  ^\( мVW2W䞭1 1 +%  XXޏP}ޏfZX[Z[\ZZYޏ   2WܞܭЬ8d
P( `$  Z                                                                                                                                                                                                                                                   X                        6; $      ELN042.D                         
  *[SYSEXE.SEAS$WORK_0000005C]EPACVMAIN.EXE;1                                                                                          '                          "            [2Wܞܭ\$  < ^c2螭ϓ1 Ǐ'  	B1 ( 7J( )( ޏ T
 3^ԭd#  m^V( ,   \(&,    PpЏ  %ԭ  P\,ԭ  _2WW   WV^^X(n( >c,Wh  a"  ޏ     
pޏ   "  !    ^2P\i  ^VhNaIZK!/2#螭-`Lޏ@ޏ0Ͼޏ8ϥ ,^^W!,(!Z. ( pޏ   ޏ      P\<,PPW^P~(n.n%^^Pޏ   ޏ   ԭo   P\<PPW^P~(nn%^^Pޏ   ޏ   ԭ&   P\ޏ   ޏ      P\Џ %ܞܭ,  PV, f1[0R.*@@HX< , n    ^\мRRc  < ,^, n Џ\谏잭Џ %Ԟ؞ԭS  P\, \+(~~ϖ ^\ЬԭԭPЬԭԭPRRP 8^\( 8Џ   ؞8h̞   -  G1 ޏH}+䞭Џ ԭPV-nЏ   `        WWP< ^, n  ,Џ\԰֞؞ԭЏ  %ܭĞКc  P\,ܭ  \&(  ϒ /n< ^, n  Џ\԰֞q؞ԭЏ  %ܭĞК  P\,ܭ  Y\( O ^ԭ  m^[V}{W,   v<1"谏잭
  Pt谏잭Џ  %Ԟ؞ԭ  PX<ZZ\\   \[^^Y(Vn(Zc\  	,\i  谏8잭a
  Ps谏잭Џ  %Ԟ؞ԭk
  PX<YY\\   \[^^Z(Bn(Yc\  	,\j  :V谏잭  P1 谏잭Џ  %Ԟ4؞ԭ  PX<4PPZZ[^^\(Z6nZ\잭  PXXX  ޏhϻsTVQXWQHz  XP{PPPPPP/ޏXcXV谏잭  P1 谏m잭Џ  %Ԟ\؞ԭ  PX<\PP\\[^^Z(\^n\Z잭V  Pխ
ѭ  ޏ`ϑЭ<
谏잭
  P1 
谏잭Џ  %Ԟ؞ԭ
  PX<PPZZ[^^\(ZnZ\잭  Pխ
ѭ  ޏp	Э
谏8잭
  P1 
谏잭Џ  %Ԟ؞ԭ!
  PX<PP\\[^^Z(\n\Z잭  PWW   	W  ޏx	W< ^, n  <԰֞؞ԭЏ  %ܭĞКz	  P\,ܭ  \( 5*  ^ޏ8rl
        Џ   :          ^ޏ@h
  l  r  P  R  8  >      ^{ D 
   1         1         1   x  ~  \  ~\  B  H  &  H!&        ޏ08Pd [l    ԭ       o  U1my]  C  <8            T            Td  f  l`  B  L  *  @T$  
          1 T      ~    f  |T`  F  P@  "  ,  
    ^I1 J1 3P\1 +2螭
1x [ޏ   2䞭ρ)ޏ8~ޏj< ^, n  ԰֞,؞ԭЏ  %ܭĞК  P\,ܭ  \\( R^, n  \ ԰֞؞ԭȰԭК  PVVVz 
 1 \1 - {  n1 ( TdSSQЏ   PRR   RPSQSQW( ?/SSQЏ   PRR   RPSQSQX ԰֞؞ԭĞV  ȞN  ̰ К  PVV   
XW\\lVȞܭЏ ԭؚğPVЏ   Ԟ؞  К    ؚ  ^^WаҞ;ԞЭЏ  %ܭ̚   P\<PPXXW^^Y(XnXYԞЭ̚[  PVNV؞حԚ'  P\\ޏÀԚϋ  < `^, n 䐏P
  
  ݬ
  ^| 
  VX^, n 䐏Q
  
  ݬf^PRݬX
  l$լݬfRP| '
  VD^, n ȐSȞ
  ؞
  ܕlլݬfЬ̑lլ
lլ, n 䞭l
լЬl
լЬlլݬf^< `^, n 䐏Tm  a  l
լЬ^< `^, n 䐏U,     ݬ
  ^                                                                                                                                                                                                                                                                                                                                                                                                                      P   @                                                                                          ) p@  !/SYSTEM SERVICE ERROR AT APP. !XP R0=!XL   @  01-JUL-1990        V5.0 @  VAXELN-TOOLKIT @  DEC            @  @         @  A  @    @        @            |~    P')ugPXPaPnPϖPP%|~  ~|~ <0 ~<a~                                                                                                  e         `  (   R                         {       0  X   ~  (  0  8  @`  H  P  X  `Z  h  p  x*  t      8  l        L  v                   RETRYretrying connect(        
NO_CONNECTconnection failure &        	BAD_STATEinconsistent state6        INSUF_MEMORYinsuffient memory for operation2        BAD_MODEEPC job must be a kernel job   2        	UNDEF_RUNrun type has not been defined H        UNDEF_DATAFILE/performance data file name has not been defined6        
NOT_CONNECTEDnot connected to an ELN target>        FILE_OPEN_ERROR#error opening performance data file <        NO_DATA*no performance data is currently availableJ        TIMER_INTERVAL1warning time interval specified has been rounded H        BUCKET_ERROR1invalid bucket size specified, default of 16 usedB        INTERVAL_ERROR(invalid interval specified, default used F        IMAGE_ERROR/invalid image size specified, default of 0 used J        CODE_STRT_ERROR/invalid code start specified, default of 0 used D        KWV_CONNECT_ERR)unable to connect to specified KWV device 6        NO_JOB%job image not currently in the systemJ        ATTEMPTING_CONN0attempting to connect to ELN target, please wait4        CONNECT_COMPLETconnect circuit completed .        SUCCESSsampling session initializedJ        SYSTEM_STARTED1target system currently running, data may be lost.                                                                                                                                                                                                                                                      Y                        g` $      ELN042.D                         
  *[SYSEXE.SEAS$WORK_0000005C]EPACVMAIN.EXE;1                                                                                          '                         E      %            SESSION_RUNNINGEPC session resumed :        WAIT*writing performance data file, please wait *        INVARGinvalid argument supplied:        OPENIN_IMAGE"error opening specified image file 8        OPENIN_DATA!error opening specified data file 8        NOTDATA&specified file is not an EPA data file2        BADDATA specified file contains bad data EPCEPA                                                                                                                                                @   @                                                      s         8   H               `  H  P    x    X            (        x  8      x              H   
                 @                                                                       LBRSHR                                                         SCRSHR                                                         LIBRTL                                                         PASRTL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   . * [SYSEXE.SEAS$WORK_0000005C]EPACVMAIN_V47.EXE;1 +  ,    . '    /     4     '   (                     - 
    0   1    2   3      K  P   W   O (    5   6 0\  7 /Q^  8          9          G    H  J                  0 D X     0205      (  (\`     J  4                                      	EPACVMAIN                              VAXELN V4.2-00 (\ 05-05                                        
            !     !     "     %   
  &     ?         !      	  
LBRSHR_001      !      T 
SCRSHR_001      !      
  
LIBRTL_001      +      e  
PASRTL_001        8   L  $     EXITGO  HELPSET SHOWSTOPWAIT$    \              
  
  4                    &     EXITp(  	EXIT_FUNC0                    $     GO(  GO_FUNC4                  &     HELP@'  EPA_HELP ,                ! !   P1HELPTEXT  (    H           %         SET   0           x    ! (   P1OPTIONWhat            SET_OPTIONS(      P             	DATA_FILE$      P             NODE ,                   PC_SAMPLING  (    4               COVERAGE 0    d               PROCESS_SAMPLING ,                   JOB_SAMPLING 8                     SYSTEM_SERVICE_SAMPLING  T              "    <     SET_SERVICE_SAMPLING_SYNTAX9  SYSTEM_SERVICE_FUNC0   L      x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  P                     8     SET_JOB_SAMPLING_SYNTAX*  JOB_SAMPLING_FUNC  X    (          "    <     SET_PROCESS_SAMPLING_SYNTAX2  PROCESS_SAMPLING_FUNC  0   X      x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  L `    <      "    4     SET_COVERAGE_SYNTAX-  PC_COVERAGE_FUNC   0         x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  ,  h              ) 
IMAGE_SIZE00                  ) 
CODE_START512  L `    H      "    7     SET_PC_SAMPLING_SYNTAX-  PC_SAMPLING_FUNC0         x    ! (   P1OPTIONWhat   4                ! )   P2JOBNAMEJob_name  ,  t              ' INTERVAL10 ,                ) 
IMAGE_SIZE00                * BUCKET_SIZE16  0                 ) 
CODE_START512  (  (              " KWVKWV (                  " KWBKWB @ `          "    0     SET_NODE_SYNTAX +  	NODE_FUNC  0         x    ! (   P1OPTIONWhat   4                ! *   P2NODENAME	Node_name,                 ( 	BI_NUMBER0 0                  - ADAPTER_NUMBER0D              "    0     SET_DATA_SYNTAX   
DATAFILE_FUNC  0         x    ! (   P1OPTIONWhat   8                ! +   P2	DATA_FILE	Data_file   (    $	           &         SHOW  0           T	    ! (   P1OPTIONWhat        t	     SHOW_OPTIONS   (    	  h
             	DATA_FILE$    	  (
             NODE (        	             RUN_SPEC @                 &   0     SHOW_RUN_SYNTAX4  SHOW_RUN   @                 &   1     SHOW_NODE_SYNTAX 4  	SHOW_NODE @                 &   1     SHOW_DATA_SYNTAXp3  	SHOW_DATA 4                 (   &     STOP8  	STOP_FUNC4                  &     WAIT;  	WAIT_FUNC<                ! *   P1TIME_VALTime in Seconds                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ::"0=EPA                                                                                                                                                                                                                                                                                                  EPC>                                                                                                                                                                                                                                                                                                                                                                                                                                                                          EPA_PERF   bi_number   adapter_number  bi_number   bi_number   adapter_number  adapter_number                              data_file   vaxeln /collector   helptexthelptexteln$:epa_help   VAXELN PERFORMANCE COLLECTOR V4.2          Collector Utility (EPC)  nodenamenodename.LOGjobname jobname kwv kwv kwb kwb intervalintervalbucket_size bucket_size image_size  image_size  code_start  code_start  jobname datafile name is:   node_name is:   run type: process sampling  run type: job sampling  run                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   Z                        "7 $      ELN042.D                         
  .[SYSEXE.SEAS$WORK_0000005C]EPACVMAIN_V47.EXE;1                                                                                      '                          "            type: pc sampling   run type: pc coverage   run type: system service sampling   job name:               sampling interval:   ms bucket size:        image size:         code start:         image size:         code start:         jobname                                                       time_val  %  P  ϿP;/  <^ԭD/  m\((^VPPWQ
WQQa Q
VQQR
WRRbaVPϔؔԔR	C̚   PRS%̚f   PSRSS1	̚5   Pm	Џ  %<̚?   P<<PPZZ^^[(Z>nZ[̞ȭ-  PذȰʞ̞ȭ  PmȰʞs̞ȭЏ  %`  P<`PP[[^^Z([bn[Z̞ȭ^-  PԀ0؀0ԑ9ؑ9ZZ   Z^^[(n(_cZXX   X[^^Y(Zkn(cX[[   [Y^^Z(Xin(_c[YY   YZ^^X([jn(cYZZ   ZX^^[(Yhn("c,Zk ,[[   [^^Z(n("c,[j ^\(((ЏT V2PW䭼ޏQFT/ԭԭPPWWI  ޏX1	W   	W   fVbVXޏPYȭԭԭԭ PYxPY1 Xkޏ]WĭЏ vԭPY-RЏ   D*  *  *  *  X1WI   < ^ԭz*  m\QQP
P  RЬSBSS   &S
P  SЬR
P  TЬU CD Q< ^ԭ*  m, n  	Џ %ܞܭ  P\\=  	,    	,  ^\( Vԭ2V2ОԞЭԭԭԭԭԭԭğ PWS1 ޏ_	25䞭Џ ؞tܞحԭPX-PЏ   B(  (  (  (  1 2V2ОԞԭԭԭԭԭԭğ PXe1 Y 1 ޏk29䞭Џ ؞ܞحԭPX-\Џ   N'  '  '  '  ^\( мVWԭ2W2ОԞЭԭԭԭԭԭԭğ PXc1 ޏo2E䞭Џ ؞ܞحԭPY-`Џ   R&  &  &  &  1 2W2ОЬVԭԭԭԭԭԭğ PY|1 ޏϐ2^䞭Џ ؞ܞحԭPY-Џ   s%  %  %  %  ^\( мVW2W䞭1 1 +%  XXޏP}ޏfZX[Z[\ZZYޏ   2WܞܭЬ8d
P( `$  Z[2Wܞܭ\$  < ^c2螭ϓ1 Ǐ'  	B1 ( 7J( )( ޏ T
 3^ԭd#  m^V( ,   \(&,    PpЏ  %ԭ  P\,ԭ  _2WW   WV^^X(n( >c,Wh  a"  ޏ     
pޏ   "  !    ^2P\i  ^VhNaIZK!/2#螭-`Lޏ@ޏ0Ͼޏ8ϥ ,^^W!,(!Z. ( pޏ   ޏ      P\<,PPW^P~(n.n%^^Pޏ   ޏ   ԭo   P\<PPW^P~(nn%^^Pޏ   ޏ   ԭ&   P\ޏ   ޏ      P\Џ %ܞܭ,  PV, f1[0R.*@@HX< , n    ^\мRRc  < ,^, n Џ\谏잭Џ %Ԟ؞ԭS  P\, \+(~~ϖ ^\ЬԭԭPЬԭԭPRRP 8^\( 8Џ   ؞8h̞   -  G1 ޏH}+䞭Џ ԭPV-nЏ   `        WWP< ^, n  ,Џ\԰֞؞ԭЏ  %ܭĞКc  P\,ܭ  \&(  ϒ /n< ^, n  Џ\԰֞q؞ԭЏ  %ܭĞК  P\,ܭ  Y\( O ^ԭ  m^[V}{W,   v<1"谏잭
  Pt谏잭Џ  %Ԟ؞ԭ  PX<ZZ\\   \[^^Y(Vn(Zc\  	,\i  谏8잭a
  Ps谏잭Џ  %Ԟ؞ԭk
  PX<YY\\   \[^^Z(Bn(Yc\  	,\j  :V谏잭  P1 谏잭Џ  %Ԟ4؞ԭ  PX<4PPZZ[^^\(Z6nZ\잭  PXXX  ޏhϻsTVQXWQHz  XP{PPPPPP/ޏXcXV谏잭  P1 谏m잭Џ  %Ԟ\؞ԭ  PX<\PP\\[^^Z(\^n\Z잭V  Pխ
ѭ  ޏ`ϑЭ<
谏잭
  P1 
谏잭Џ  %Ԟ؞ԭ
  PX<PPZZ[^^\(ZnZ\잭  Pխ
ѭ  ޏp	Э
谏8잭
  P1 
谏잭Џ  %Ԟ؞ԭ!
  PX<PP\\[^^Z(\n\Z잭  PWW   	W  ޏx	W< ^, n  <԰֞؞ԭЏ  %ܭĞКz	  P\,ܭ  \( 5*  ^ޏ8rl
        Џ   :          ^ޏ@h
  l  r  P  R  8  >      ^{ D 
   1         1         1   x  ~  \  ~\  B  H  &  H!&        ޏ08Pd [l    ԭ       o  U1my]  C  <8            T            Td  f  l`  B  L  *  @T$  
          1 T      ~    f  |T`  F  P@  "  ,  
    ^I1 J1 3P\1 +2螭
1x [ޏ   2䞭ρ)ޏ8~ޏj< ^, n  ԰֞,؞ԭЏ  %ܭĞК  P\,ܭ  \\( R^, n  \ ԰֞؞ԭȰԭК  PVVVz 
 1 \1 - {  n1 ( TdSSQЏ   PRR   RPSQSQW( ?/SSQЏ   PRR   RPSQSQX ԰֞؞ԭĞV  ȞN  ̰ К  PVV   
XW\\lVȞܭЏ ԭؚğPVЏ   Ԟ؞  К    ؚ  ^^WаҞ;ԞЭЏ  %                                                                                                                                                                                                                                                   [                        Wp $      ELN042.D                         
  .[SYSEXE.SEAS$WORK_0000005C]EPACVMAIN_V47.EXE;1                                                                                      '                         ~             ܭ̚   P\<PPXXW^^Y(XnXYԞЭ̚[  PVNV؞حԚ'  P\\ޏÀԚϋ  < `^, n 䐏P
  
  ݬ
  ^| 
  VX^, n 䐏Q
  
  ݬf^PRݬX
  l$լݬfRP| '
  VD^, n ȐSȞ
  ؞
  ܕlլݬfЬ̑lլ
lլ, n 䞭l
լЬl
լЬlլݬf^< `^, n 䐏Tm  a  l
լЬ^< `^, n 䐏U,     ݬ
  ^                                                                                                                                                                                                                                                                                                                                                                                                                      P   @                                                                                          ) p@  !/SYSTEM SERVICE ERROR AT APP. !XP R0=!XL   @  01-JUL-1990        V5.0 @  VAXELN-TOOLKIT @  DEC            @  @         @  A  @    @        @            |~    P')ugPXPPnPϖPP%|~  ~|~ <0 ~<a~                                                                                                  e         `  (   R                         {       0  X   ~  (  0  8  @`  H  P  X  `Z  h  p  x*  t      8  l        L  v                   RETRYretrying connect(        
NO_CONNECTconnection failure &        	BAD_STATEinconsistent state6        INSUF_MEMORYinsuffient memory for operation2        BAD_MODEEPC job must be a kernel job   2        	UNDEF_RUNrun type has not been defined H        UNDEF_DATAFILE/performance data file name has not been defined6        
NOT_CONNECTEDnot connected to an ELN target>        FILE_OPEN_ERROR#error opening performance data file <        NO_DATA*no performance data is currently availableJ        TIMER_INTERVAL1warning time interval specified has been rounded H        BUCKET_ERROR1invalid bucket size specified, default of 16 usedB        INTERVAL_ERROR(invalid interval specified, default used F        IMAGE_ERROR/invalid image size specified, default of 0 used J        CODE_STRT_ERROR/invalid code start specified, default of 0 used D        KWV_CONNECT_ERR)unable to connect to specified KWV device 6        NO_JOB%job image not currently in the systemJ        ATTEMPTING_CONN0attempting to connect to ELN target, please wait4        CONNECT_COMPLETconnect circuit completed .        SUCCESSsampling session initializedJ        SYSTEM_STARTED1target system currently running, data may be lost.        SESSION_RUNNINGEPC session resumed :        WAIT*writing performance data file, please wait *        INVARGinvalid argument supplied:        OPENIN_IMAGE"error opening specified image file 8        OPENIN_DATA!error opening specified data file 8        NOTDATA&specified file is not an EPA data file2        BADDATA specified file contains bad data EPCEPA                                                                                                                                                @   @                                                      s         8   H               `  H  P    x    X            (        x  8      x              H   
                 @                                                                       LBRSHR                                                         SCRSHR                                                         LIBRTL                                                         PASRTL                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ( * [SYSEXE.SEAS$WORK_0000005C]EPAHELP.HLP;1 +  ,    .     /     4 I                         - 
    0   1    2   3      K  P   W   O     5   6 v)  7  l^  8          9          G    H  J                        1 VAXELN PERFORMANCEA VAXELN Performance Utility allows users to collect statistics on  @ and analyze the run time behavior of a VAXELN application.  The 0 utility has two parts, a Collector and Analyzer.  9    o The Collector Utility collects performance data from =      a specified VAXELN TARGET.  To invoke collector from the       dcl prompt enter:  /       $VAXELN PERFORMANCE/collector <node_name>     ;     o The Analyzer Utility generates reports from datafiles ?       created by the Collector Utility.  To invoke the analyzer         from the dcl prompt enter:  .       $VAXELN PERFORMANCE/analyzer <data_file>   	   
 2 /COLLECTOR  C   The Collector utility allows you to collect real time performance     data on an ELN application.   3 SET F     Defines or changes characteristics associated with the collection      run.        Format:          EPC> Set Option   4 DATA_FILE A Specifies the file the Collector uses to record performance data.         Format:  %        EPC> SET DATA_FILE <file_spec>  4 NODEF Specifies the node from which you will be collecting Performance data  from.         Format:           EPC> SET NODE <node name>   4 JOB_SAMPLINGE Specifies that the data which will be collected for this run will be  I JOB_SAMPLING data.  JOB_SAMPLING data consists of lapsed time and context * switch counts for each job in your system.        Format:          EPC> SET JOB_SAMPLING  
 4 PC_SAMPLING D Specifies that the data which will be collected for this run will be PC_SAMPLING data.           Format:  &        EPC> SET PC_SAMPLING <job_name>   5 /INTERVAL E This optional parameter specifies the rate at which you will take PC  C SAMPLES.  The value is set in millisecond and is truncated to be a  B multiple of the INTERVAL TIMER value.  The default is every TIMER 	 INTERVAL.   
       Format:   2         EPC> SET PC_SAMPLING/INTERVAL=n <job_name>   5 /BUCKET_SIZEC This is an optional parameter which specifies the size of the tally 0 buckets. The default for this parameter is 16.    
       Format:   0         EPC> SET PC_SAMPLING/BUCKET=n <job_name>  
 5 /IMAGE_SIZE ? This is an optional parameter which specifies the code size in  C bytes of the job to be sampled.  If this value is not specified and A the job exists in the system image, built in via ebuild, then the B collector will determine this value dynamically.  If this value is@ not specified and the job doesn't exist in the system image the ? default value used will be the P0 Virtual size parameter set in  ebuild.   
       Format:   ,         EPC> SET PC_SAMPLING/IMAGE_SIZE=1024   5 /CODE_START A This is an optional parameter which specifies the virtual address A where sampling will begin. This value would be set if the job is  B loaded dynamically or if samples are not to be taken of the entire@ job. If this value is not specified the Collector uses 200 (hex) as the starting address.  
       Format:   ,         EPC> SET PC_SAMPLING/CODE_START=400    5 /KWVA This is an optional parameter which specifies that the KWV clock, @ instead of the TIMER INTERVAL, is used for sampling. The device : name is the name specified on the Device Description Menu.  
       Format:     	EPC> SET PC_SAMPLING/KWV=KWV11A  
 4 COVERAGED Specifies that the data which will be collected for this run will be COVERAGE  data.           Format:  $        EPC> SET COVERAGE  <job_name>  
 5 /IMAGE_SIZE ? This is an optional parameter which specifies the code size in  C bytes of the job to be sampled.  If this value is not specified and A the job exists in the                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   \                        t $      ELN042.D                         
  ([SYSEXE.SEAS$WORK_0000005C]EPAHELP.HLP;1                                                                                       I                             3             system image, built in via ebuild, then the B collector will determine this value dynamically.  If this value is@ not specified and the job doesn't exist in the system image the ? default value used will be the P0 Virtual size parameter set in  ebuild.   
       Format:   )         EPC> SET COVERAGE/IMAGE_SIZE=1024    5 /CODE_START A This is an optional parameter which specifies the virtual address A where sampling will begin. This value would be set if the job is  B loaded dynamically or if samples are not to be taken of the entire@ job. If this value is not specified the Collector uses 200 (hex) as the starting address.  
       Format:   )         EPC> SET COVERAGE/CODE_START=400     4 PROCESS_SAMPLING  A Specifies that the data which will be collected for this run will C be PROCESS_SAMPLING data.  PROCESS_SAMPLING data consists of lapsed D time and context switch counts for each process within the selected  job.  
       Format:   ,         EPC> SET PROCESS_SAMPLING <job_name>   4 SYSTEM_SERVICE_SAMPLING E Specifies that the data which will be collected for this run will be  E SYSTEM_SERVICE_SAMPLING data.  SYSTEM_SERVICE_SAMPLING data consists  < of the number of times each kernel primitive is called.  SeeD documentation for the list of primitives SYSTEM_SERVICE_SAMPLING can keep track of.  
       Format:   3         EPC> SET SYSTEM_SERVICE_SAMPLING <job_name>    3 SHOW>     Displays information about the current collection session.           Format:              EPC> Show Option   4 DATA_FILE 8 Displays the name of the current performance data file.   
       Format:            EPC> SHOW DATA_FILE    4 NODE< Displays the name of the node from where you are collecting  performance data.   
       Format:            EPC> SHOW NODE   4 RUN > Display the type of data you are currently collecting and any 0 qualifiers associated with that collection type.  
       Format:            EPC> SHOW RUN    3 GO Start collection run.     
       Format:            EPC> GO    3 STOP9 Stop a collection run and write the data collected to the  specified performance datafile.   
       Format:            EPC> STOP    3 EXIT Exit the Collector Utility.         Format:          EPC> EXIT 2 /ANALYZER 7  The Analyzer Utility generates reports from datafiles  "  created by the Collector Utility.   
 3 TABULATE@ The TABULATE command generates tabular reports from a specified 	 datafile.   
       Format:   "         EPA> TAB[qualifiers] range     4 range A This entry specifies the section of the application for which the A user desires to see performance data displayed.  It is only valid B for PC-sampling data.  If '/SOURCE' is specified, the range should2 be the module for which source display is desired.  	 4 /SOURCE E This qualifier produces a listing of the source file with the         + performance data displayed for each line.     
       Format:  	 #         EPA> TAB/SOURCE module_name   	 4 /MODULE > This qualifier produces a tabular report with routine entries  suppressed.   
       Format:   .         EPA> TAB/MODULE [list of module_names] 4 /ZERO   A This qualifier causes suppression of all entries for which there   are no data points.             Format:  -          EPA> TAB/ZERO [list of module_names] 
 4 /MAXIMUM  E This qualifier causes suppression of all entries whose percentage is  " greater than the specified value.   
       Format:   1         EPA> TAB/MAXIMUM=n [list of module_names]   
 4 /MINIMUM  E This qualifier causes suppression of all entries whose percentage is    less than the specified value.    
       Format:  	 1         EPA> TAB/MINIMUM=m [list of module_names]    4 /FILE [=file_specification]   E This qualifier causes only a report file to be generated, no terminal  output.   
       Format:   # 	EPA> TAB/FILE[=file_specification]    4 /COVERAGE=KEYWORD   D This qualifier is used to specify how the table displays source codeF coverage data. The keywords are FULL and BRIEF.  The default is brief.H The BRIEF table simply indicates whether or not a particular source lineH was executed or not.  The FULL table displays the percentage and number " of PC counts for each source line.           Format:    	EPA> TAB/COVERAGE=[KEYWORD] 3 PLOT  C The PLOT command generates a histogram from a PC sampling datafile.   
       Format:   #         EPA> PLOT[qualifiers] range    4 range A This entry specifies the section of the application for which the A user desires to see performance data displayed.  It is only valid B for PC-sampling data.  If '/SOURCE' is specified, the range should2 be the module for which source display is desired.	 4 /SOURCE > This qualifier produces a listing of the source file with the + performance data displayed for each line.     
       Format:  	 $         EPA> PLOT/SOURCE module_name  	 4 /MODULE > This qualifier produces a tabular report with routine entries  suppressed.   
       Format:   /         EPA> PLOT/MODULE [list of module_names]  4 /ZERO A This qualifier causes suppression of all entries for which there   are no data points.     
       Format:   & 	EPA> PLOT/ZERO [list of module_names]
 4 /MAXIMUMB This qualifier causes suppression of all entries whose percentage % is greater than the specified value.    
       Format:   2         EPA> PLOT/MAXIMUM=n [list of module_names]
 4 /MINIMUMB This qualifier causes suppression of all entries whose percentage # is less than the specified value.     
       Format:  	 2         EPA> PLOT/MINIMUM=m [list of module_names] 4 /FILE [=file_specification] E This qualifier causes only a report file to be generated, no terminal  output.   
       Format:   $ 	EPA> PLOT/FILE[=file_specification]   3 FILEC The FILE command causes the last report generated to be written to   a user specified file.     
       Format:  	          EPA> FILE file_spec    3 PRINT A The PRINT command causes the last report generated to be printed   on the system printer.    
       Format:            EPA> PRINT                                                                                                                          ) * [SYSEXE.SEAS$WORK_0000005C]EPA_HELP.HLB;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 ĳ  7 8^  8          9          G    H  J                        %
   VAX-11 Librarian V04-00        Tӳ ߳                    $                                                                                                         5                                                                                                                                                                                                                                                                                                                         
               VAXELN                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       ]                        N $      ELN042.D                         
  )[SYSEXE.SEAS$WORK_0000005C]EPA_HELP.HLB;1                                                                                                                    Ӎ "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      ߳  1 VAXELN PERFORMANCEA VAXELN Performance Utility allows users to collect statistics on  @ and analyze the run time behavior of a VAXELN application.  The 0 utility has two parts, a Collector and Analyzer.  9    o The Collector Utility collects performance data from =      a specified VAXELN TARGET.  To invoke collector from the       dcl prompt enter:  /       $VAXELN PERFORMANCE/collector <node_name>     ;     o The Analyzer Utility generates reports from datafiles ?       create 	   d by the Collector Utility.  To invoke the analyzer         from the dcl prompt enter:  .       $VAXELN PERFORMANCE/analyzer <data_file>   	   
 2 /COLLECTOR  C   The Collector utility allows you to collect real time performance     data on an ELN application.   3 SET F     Defines or changes characteristics associated with the collection      run.        Format:          EPC> Set Option   4 DATA_FILE A Specifies the file the Collector uses to record performance data.         Format:  %        
    EPC> SET DATA_FILE <file_spec>  4 NODEF Specifies the node from which you will be collecting Performance data  from.         Format:           EPC> SET NODE <node name>   4 JOB_SAMPLINGE Specifies that the data which will be collected for this run will be  I JOB_SAMPLING data.  JOB_SAMPLING data consists of lapsed time and context * switch counts for each job in your system.        Format:          EPC> SET JOB_SAMPLING  
 4 PC_SAMPLING D Specifies that the data which will be collected for this     run will be PC_SAMPLING data.           Format:  &        EPC> SET PC_SAMPLING <job_name>   5 /INTERVAL E This optional parameter specifies the rate at which you will take PC  C SAMPLES.  The value is set in millisecond and is truncated to be a  B multiple of the INTERVAL TIMER value.  The default is every TIMER 	 INTERVAL.   
       Format:   2         EPC> SET PC_SAMPLING/INTERVAL=n <job_name>   5 /BUCKET_SIZEC This is an optional parameter which specifies the size of the tally 0 buckets. The d
    efault for this parameter is 16.    
       Format:   0         EPC> SET PC_SAMPLING/BUCKET=n <job_name>  
 5 /IMAGE_SIZE ? This is an optional parameter which specifies the code size in  C bytes of the job to be sampled.  If this value is not specified and A the job exists in the system image, built in via ebuild, then the B collector will determine this value dynamically.  If this value is@ not specified and the job doesn't exist in the system image the ? default value used will be the P0 Virtual si 
   ze parameter set in  ebuild.   
       Format:   ,         EPC> SET PC_SAMPLING/IMAGE_SIZE=1024   5 /CODE_START A This is an optional parameter which specifies the virtual address A where sampling will begin. This value would be set if the job is  B loaded dynamically or if samples are not to be taken of the entire@ job. If this value is not specified the Collector uses 200 (hex) as the starting address.  
       Format:   ,         EPC> SET PC_SAMPLING/CODE_START=400    5 /KWVA This is an optiona    l parameter which specifies that the KWV clock, @ instead of the TIMER INTERVAL, is used for sampling. The device : name is the name specified on the Device Description Menu.  
       Format:     	EPC> SET PC_SAMPLING/KWV=KWV11A  
 4 COVERAGED Specifies that the data which will be collected for this run will be COVERAGE  data.           Format:  $        EPC> SET COVERAGE  <job_name>  
 5 /IMAGE_SIZE ? This is an optional parameter which specifies the code size in  C bytes of the job to be sampled.      If this value is not specified and A the job exists in the system image, built in via ebuild, then the B collector will determine this value dynamically.  If this value is@ not specified and the job doesn't exist in the system image the ? default value used will be the P0 Virtual size parameter set in  ebuild.   
       Format:   )         EPC> SET COVERAGE/IMAGE_SIZE=1024    5 /CODE_START A This is an optional parameter which specifies the virtual address A where sampling will begin. This value wo    uld be set if the job is  B loaded dynamically or if samples are not to be taken of the entire@ job. If this value is not specified the Collector uses 200 (hex) as the starting address.  
       Format:   )         EPC> SET COVERAGE/CODE_START=400     4 PROCESS_SAMPLING  A Specifies that the data which will be collected for this run will C be PROCESS_SAMPLING data.  PROCESS_SAMPLING data consists of lapsed D time and context switch counts for each process within the selected  job.  
       Format:       ,         EPC> SET PROCESS_SAMPLING <job_name>   4 SYSTEM_SERVICE_SAMPLING E Specifies that the data which will be collected for this run will be  E SYSTEM_SERVICE_SAMPLING data.  SYSTEM_SERVICE_SAMPLING data consists  < of the number of times each kernel primitive is called.  SeeD documentation for the list of primitives SYSTEM_SERVICE_SAMPLING can keep track of.  
       Format:   3         EPC> SET SYSTEM_SERVICE_SAMPLING <job_name>    3 SHOW>     Displays information about the current collect    ion session.           Format:              EPC> Show Option   4 DATA_FILE 8 Displays the name of the current performance data file.   
       Format:            EPC> SHOW DATA_FILE    4 NODE< Displays the name of the node from where you are collecting  performance data.   
       Format:            EPC> SHOW NODE   4 RUN > Display the type of data you are currently collecting and any 0 qualifiers associated with that collection type.  
       Format:            EPC> SHOW RUN    3 GO Start     collection run.     
       Format:            EPC> GO    3 STOP9 Stop a collection run and write the data collected to the  specified performance datafile.   
       Format:            EPC> STOP    3 EXIT Exit the Collector Utility.         Format:          EPC> EXIT 2 /ANALYZER 7  The Analyzer Utility generates reports from datafiles  "  created by the Collector Utility.   
 3 TABULATE@ The TABULATE command generates tabular reports from a specified 	 datafile.   
       Format:   "             EPA> TAB[qualifiers] range     4 range A This entry specifies the section of the application for which the A user desires to see performance data displayed.  It is only valid B for PC-sampling data.  If '/SOURCE' is specified, the range should2 be the module for which source display is desired.  	 4 /SOURCE E This qualifier produces a listing of the source file with the         + performance data displayed for each line.     
       Format:  	 #         EPA> TAB/SOURCE module_name   	 4 /MODULE >     This qualifier produces a tabular report with routine entries  suppressed.   
       Format:   .         EPA> TAB/MODULE [list of module_names] 4 /ZERO   A This qualifier causes suppression of all entries for which there   are no data points.             Format:  -          EPA> TAB/ZERO [list of module_names] 
 4 /MAXIMUM  E This qualifier causes suppression of all entries whose percentage is  " greater than the specified value.   
       Format:   1         EPA> TAB/MAXIMUM=n [list of module_nam    es]   
 4 /MINIMUM  E This qualifier causes suppression of all entries whose percentage is    less than the specified value.    
       Format:  	 1         EPA> TAB/MINIMUM=m [list of module_names]    4 /FILE [=file_specification]   E This qualifier causes only a report file to be generated, no terminal  output.   
       Format:   # 	EPA> TAB/FILE[=file_specification]    4 /COVERAGE=KEYWORD   D This qualifier is used to specify how the table displays source codeF coverage data. The keywords are                                                                                                                                                                                                                                                    ^                        ̈́ $      ELN042.D                         
  )[SYSEXE.SEAS$WORK_0000005C]EPA_HELP.HLB;1                                                                                                                    wg 
                FULL and BRIEF.  The default is brief.H The BRIEF table simply indicates whether or not a particular source lineH was executed or not.  The FULL table displays the percentage and number " of PC counts for each source line.           Format:    	EPA> TAB/COVERAGE=[KEYWORD] 3 PLOT  C The PLOT command generates a histogram from a PC sampling datafile.   
       Format:   #         EPA> PLOT[qualifiers] range    4 range A This entry specifies the section of the application for which the A user desires     to see performance data displayed.  It is only valid B for PC-sampling data.  If '/SOURCE' is specified, the range should2 be the module for which source display is desired.	 4 /SOURCE > This qualifier produces a listing of the source file with the + performance data displayed for each line.     
       Format:  	 $         EPA> PLOT/SOURCE module_name  	 4 /MODULE > This qualifier produces a tabular report with routine entries  suppressed.   
       Format:   /         EPA> PLOT/MODULE [list of mo    dule_names]  4 /ZERO A This qualifier causes suppression of all entries for which there   are no data points.     
       Format:   & 	EPA> PLOT/ZERO [list of module_names]
 4 /MAXIMUMB This qualifier causes suppression of all entries whose percentage % is greater than the specified value.    
       Format:   2         EPA> PLOT/MAXIMUM=n [list of module_names]
 4 /MINIMUMB This qualifier causes suppression of all entries whose percentage # is less than the specified value.     
       Format:  	     2         EPA> PLOT/MINIMUM=m [list of module_names] 4 /FILE [=file_specification] E This qualifier causes only a report file to be generated, no terminal  output.   
       Format:   $ 	EPA> PLOT/FILE[=file_specification]   3 FILEC The FILE command causes the last report generated to be written to   a user specified file.     
       Format:  	          EPA> FILE file_spec    3 PRINT A The PRINT command causes the last report generated to be printed   on the system printer.    
       Format     :            EPA> PRINT w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           % * [SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1 +  ,    . >   /     4     >  =                    - 
    0   1    2   3      K  P   W   O =   5   6 &  7  ^  8          9          G    H  J                            %
   VAX-11 Librarian V04-00        Kߓ @*' !       7     <  x =  "      2            ,     ,           9  s                                                                                                                                                                                                                                                                                                                                                                                 |         l    ACCESSq    BITMAPv    BLOCKz    BUGCHECK}    	CHECKPROT    CLEANUP    CLOSE    CREATE    	DIRECTORY    DIRSUBS    DISKHAND    DISPLAY    ENTER    ERASE    EXTEND6    F11DEF    FCBSUBS3    FIDDEF    FILEHAND    FILEINIT    FILESERV-   FILEUTILB    FLSDEFY    FLSENTRY;   FLSMSG    FLUSH    GET    HEADERGET    HEADERMOUNT    OPEN   	PARSENAME
   PUT   READHOME   REMOVE5    RENAME   REWIND                 l    ACCESSq    ALLOCATE_BITMAP    ALLOCATE_MESSAGE    ALLOCATE_STRUCTURE    BUFFER_SETUPz    BUGCHECK-   	BUG_CHECK-   CHECKSUM-   	CHECKSUM2    CHECK_HEADER}    CHECK_PROTECTION
   CHECK_RECORD    CLEANUP    CLOSE_ACTIONv    
CLOSE_DISK    
CREATE_EXTFCB    
CREATE_FCB    CREATE_FILE    
CREATE_HEADER    CREATE_MAP_PTR*   
CREATE_WCBDEALLOCATE_MESSAGE    
DELETE_EXTFCB    DELETE_FFILE    DIRECTORY_ACCESS    DIRECTORY_DEACCESS_FILE              NEXT_FIXED_RECORD    NEXT_HEADER    OPEN_ACTIONv    	OPEN_DISK   
PARSE_NAME!   PERFORM_TRACE_DONE!   PERFORM_TRACE_INIT
   
PUT_ACTIONv    
READ_AHEADv    	READ_DISKv    	READ_FILE    READ_HEADER   	READ_HOME   REMOVE    
REMOVE_VCB-   	REM_QUEUE5    
RENAME_ACTION    RESTORE_CONTEXT    RESTORE_DIRl    RETURN_ATTRIBUTESq    
RETURN_BITMAP    RETURN_CHARACTERISTICS SAVE_DIR   SEARCH    SET_NEXT_RECORD    SHUFFLE_DIRTE_FILE                      
CREATE_WCB
   DIRECTORY_DEACCESS   DISK_HANDLER   FLS$K_BADBLOCK   FLS$K_ERRDURDMT   FLS$K_ILLEGALEXT   
GET_ACTION   NEXT_DIR_REC   RETURN_CHARACTERISTICS   SHUFFLE_DIR	   ZERO_WINDOWS                                                                                                                                                                                                                                                                                            	DISK_OPEN    DISK_PUT    DISPLAY_ACTION    ELN$FILE_INITIALIZE    ELN$FILE_SERVICE:   ELN$LOG_VOLCHANGE    EMPTY_DIRECTORY    ENTER-   ENTER_USER_CONTEXT    ERASE_ACTION    
ERASE_FILE    
EXTEND_ACTION    EXTEND_FILE    
EXTEND_HEADER    EXTEND_INDEX    FILE_HANDLER    FIND_ACTION    FIND_FCB;   FLS$K_ALLFHDNOTMAP;   FLS$K_BADBLOCK;   FLS$K_BADFILEVER;   FLS$K_BADPARAM;   FLS$K_BADSBMBLK;   FLS$K_ERRDURDMTXTON_DIR_REC                  GET_MAP_PTR!   GET_TRACE_BUFFER!   GET_TRACE_HEADER    INIT_FCB-   	INS_QUEUEv    IO_READ    LOCK    
MAKE_ENTRY    MAP_VBN    MARKDEL_FCB    MARK_DELETE-   
MATCH_NAME-   	MNT_TABLE    MOUNTz    
MOUNT_MESSAGE-   	MOVE_BITS    NEXT_DIR_REC                                                                                                                                                                                                                                   DIRECTORY_SCANB    DIRECTORY_TYPE    DIR_LIST    DIR_OPEN    
DISK_CLOSE    DISK_DIROPEN    DISK_GET    DISK_HANDLER                                                                                                                                                                                                                                                                                                                                                                               -   SS$_TOOMANYVER    SWITCH_BUFFERS-   TABLE    TRAVERSE_DIR%   TRUNCATE_ACTION%   
TRUNCATE_FILE    TRUNCATE_HEADER*   TURN_WINDOW    UNLOCK    
UNLOCK_RECORD
   
UPDATE_ACTION    UPDATE_HIGHWATERv    
WRITE_DISKv    
WRITE_FILE*   ZERO_WINDOWS                                                                                                                                                                                                                                      MAPPTR    MAPVBN    MISC    MOUNT    OPEN   	PARSENAME
   PUT   READHOME   REMOVE5    RENAME   REWIND   SEARCH!   TRACE%   TRUNCATE:   	VOLCHANGE*   WINDOW                                                                                                                                                                                                                                                                                                                 HEADER
   WINDOWTE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          _                        Ǯ $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        i "                          RETURN_FILESPEC   
REWIND_ACTION    SAVE_CONTEXT    SAVE_DIR   SEARCH-   SEND_BADSCAN!   
SEND_TRACE    SET_NEXT_RECORD    SHUFFLE_DIR                                                                                                                                                                                                                                                                                                                                                             
DEACCESS_FILE-   DEALLOCATE_BAD    DEALLOCATE_MESSAGE-   DEALLOCATE_STRUCTURE    
DELETE_EXTFCB    DELETE_FFILE    DIRECTORY_ACCESS    DIRECTORY_DEACCESS                                                                                                                                                                                                                                                                                                                                          ;   FLS$K_ILLPTRCNT;   FLS$K_MAPCNTZERO;   
FLS$K_MOUNTED;   
FLS$_FACILITY    FLUSH_ACTION    
FLUSH_BUFFERS-   
GET_ACCESS    
GET_ACTION                                                                                                                                                                                                                                                                                                                                                                ;   FLS$K_ERREXTIDX;   FLS$K_ERRRDIDX;   FLS$K_ERRWRTIDX;   FLS$K_FILBLKNOTMAP;   FLS$K_FILESTRUCT;   FLS$K_ILLEGALEXT                                                                                                                                                                                                                                                                                                                                                                                      ;   FLS$K_BADFILEID;   FLS$K_BADFILENAME;   FLS$K_BADFILEVER;   FLS$K_BADPARAM;   FLS$K_BADSBMBLK;   FLS$K_ERRDURDMT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     `                         $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          !                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               #                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               $                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               %                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               &                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               '                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               (                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               )                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               +                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               ,                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               -                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  a                        tqG $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        n "     .       /                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               2                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                4   1        jZNߓ V2.0-00                         6     FIDDEFV2.0-0010-OCT-1990 20:59                   VAXELN PASCAL V4.2_95 
  e
     i e    FID_K_INDEXFID_K_BITMAPFID_K_BADBLK	FID_K_MFDFID_K_CORIMGFID_K_VOLSETFID_K_CONTINFID_K_BACKUPFID_K_BADLOG	FLS_R_FID	 
  an-unnamed-tag 	FID_W_NUM     	FID_W_SEQ   	FID_B_RVN  	FID_B_NMX   	FID_R_FID   0	FID_W_RVN               P        $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                                            1        bߓ V4.2-03                        T6     RENAMEV4.2-0310-OCT-1990 21:05                   VAXELN PASCAL V4.2_95
  e
 `gM   _w  e    T4$DAPO t$DAPPARSEDEF$KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRY
RENAME_ACTION  T  KER$TRANSLATE_NAME  DAP$PARSE_FILESPEC  KER$ENTER_KERNEL_CONTEXT  CHECKSUM  CLEANUP  DEALLOCATE_MESSAGE  DEALLOCATE_STRUCTURE  DIRECTORY_DEACCESS  ENTER  
ERASE_FILE  FIND_FCB  LOCK  READ_HEA 7   1       `XrQߓ V3.2-00                         6     F11DEFV3.2-0010-OCT-1990 21:00                   VAXELN PASCAL V4.2_95 
  e
 DAA    e   T4$DAPFIDDEFFH2_K_LEVEL1FH2_K_LEVEL2FH2_K_CHECKSUMFH2_K_LENGTHFH2_K_FILEOWNERFH2_K_HIGHWATERFI2_K_LENGTH	FI2_K_FNMFI2_K_FNMEXTFI2_K_REVISIONFM2_K_PLACEMENT
FM2_K_FORMAT1
FM2_K_FORMAT2
FM2_K_FORMAT3
FM2_K_LENGTH0
FM2_K_LENGTH1
FM2_K_LENGTH2
FM2_K_LENGTH3FM2_K_MAX_LBN_FMT1FM2_K_MAX_CNT_FMT1FM2_K_MAX_CNT_ 8   FMT2FM2_K_MAX_CNT_FMT3FAT_K_UNDEFINEDFAT_K_FIXEDFAT_K_VARIABLE	FAT_K_VFCFAT_K_STREAMFAT_K_STREAMLFFAT_K_STREAMCRFAT_K_SEQUENTIAL  eFAT_K_RELATIVE
FAT_K_INDEXEDFAT_K_DIRECTHM2_K_LEVEL1HM2_K_LEVEL2HM2_K_CHECKSUM1HM2_K_CHECKSUM2	DIR_K_FIDDIR_K_LINKNAMEDIR_K_LENGTH
DIR_K_VERSION
DIR_K_NAME	FLS_R_SCB
FLS_R_SCB_STSSCB_V_MAPDIRTYSCB_V_MAPALLOCSCB_V_FILALLOCSCB_V_QUODIRTYSCB_V_HDRWRITEFLS_R_DIR_NAME	FLS_R_HM2FLS_R_INTFMT	FLS_R_FM2
FLS_R_FI2_EXT	FLS_R_ 9   FH2	FLS_R_FATFLS_R_REVINT
FLS_R_DIR_VERFLS_R_DIR_ENTRY	FLS_R_FI2 P<LxB   @   @   @   e : PSCB_W_STRUCLEV     
SCB_W_CLUSTER   
SCB_L_VOLSIZE
SCB_L_BLKSIZE
SCB_L_SECTORSSCB_L_TRACKSSCB_L_CYLINDERSCB_L_STATUS. $
SCB_L_STATUS2. $SCB_W_WRITECNT    SCB_T_VOLOCKNAME"SCB_Q_MOUNTTIME
.
SCB_W_BACKREV   6S :   CB_Q_GENERNUM
8SCB_B_$$FILL@SCB_W_CHECKSUM   . /0123 $P  
   an-unnamed-tag   e
HM2_L_HOMELBN  HM2_L_ALHOMELBNHM2_L_ALTIDXLBNHM2_W_STRUCLEV   
HM2_W_CLUSTER   p
HM2_W_HOMEVBN    HM2_W_ALHOMEVBN    HM2_W_ALTIDXVBN    HM2_W_IBMAPVBN    HM2_L_IBMAPLBNHM2_L_MAXFILESHM2_W_IBMAPSIZE    HM2_W_RESFILES   
HM2 ;   _W_DEVTYPE    	HM2_W_RVN   0HM2_W_SETCOUNT   @
HM2_W_VOLCHAR   PHM2_L_VOLOWNER,HM2_L_SEC_MASK0  e
HM2_W_PROTECT   e	DAP$W_PRO 4HM2_W_FILEPROTg
HM2_W_RECPROTgHM2_W_CHECKSUM1   
HM2_Q_CREDATE
<HM2_B_WINDOW  D
HM2_B_LRU_LIM  (HM2_W_EXTEND   0HM2_Q_RETAINMIN
HHM2_Q_RETAINMAX
P
HM2_Q_REVDATE
X
HM2_B_$$FILL1h`HM2_L_SERIALNUMH <   M2_T_STRUCNAME
HM2_T_VOLNAMEHM2_T_OWNERNAMEHM2_T_FORMAT
HM2_B_$$FILL2HM2_W_CHECKSUM2    UHM2_B_STRUCVER  e  HM2_B_STRUCLEV  hHM2_V_READCHECK*HM2_V_WRITCHECKQHM2_V_ERASERHM2_V_NOHIGHWATERSHM2_V_CLASS_PROTT$LOW_WORD     	HIGH_WORD    
  Q  FM2_W_WORD0     FM2_W_LOWLBN    FM2_V_EXACT  =    FM2_V_ONCYL	FM2_V_LBN	FM2_V_RVN
FM2_V_FORMAT B
FM2_L_LBN2 
FM2_V_HIGHLBN ?B FM2_V_COUNT2 ?B  FM2_W_LOWCOUNT e   
FM2_L_LBN3 FM2_B_COUNT1     FI2_R_HEADERx  FI2_T_USERLABELPx  
   Q PFH2_B_IDOFFSET    FH2_B_MPOFFSET  FH2_B_ACOFFSET  FH2_B_RSOFFSET  
FH2_W_SEG_NUM    FH2_W_STRUCLEV  >     0	FH2_R_FID	FLS_R_FID 
FH2_R_EXT_FID
FH2_W_RECATTR :FH2_V_NOBACKUPFH2_V_WRITEBACKFH2_V_READCHECKFH2_V_WRITCHECK e
FH2_V_CONTIGBFH2_V_LOCKEDFH2_V_CONTIGFH2_V_BADACLFH2_V_SPOOLFH2_V_DIRECTORYFH2_V_BADBLOCK
FH2_V_MARKDELFH2_V_NOCHARGEFH2_V_ERASE
FH2_W_RECPROTg8FH2_B_MAP_INUSE  FH2_B_ACC_MODE  FH2_L_FIL ?   EOWNER<FH2_W_FILEPROTg@FH2_R_BACKLINKBFH2_V_AIJNLHFH2_V_BIJNLAFH2_V_ATJNLBFH2_V_RUACCESSI
FH2_V_NORUJNLI	FH2_L_HWML     e eFH2_B_STRUCVER  FH2_B_STRUCLEV  FH2_L_FILECHAR4FH2_L_HIGHWATERLFH2_W_CHECKSUM     FH2_R_STRUCTURE     FH2_R_UNIQUE  FH2_R_REMAINDER  
   Q  FAT_B_RTYPE    
FAT_B_RATTR                                                                                                                                                                                                                                                   b                        bD; $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        6 "     ?        @   IB	DAP$B_RAT  FAT_W_RSIZE   FAT_L_HIBLK;FAT_L_EFBLK;FAT_W_FFBYTE   
FAT_B_BKTSIZE  p
FAT_B_VFCSIZE  xFAT_W_MAXREC      eFAT_W_DEFEXT    	FAT_W_GBC    FAT_B_$$FILL@    FAT_W_VERSIONS     `FAT_V_RTYPE B  
FAT_V_FILEORG BFAT_V_FORTRANCCFAT_V_IMPLIEDCC	
FAT_V_PRINTCC
FAT_V_NOSPANFAT_W_HIBLKH A      FAT_W_HIBLKL   0FAT_W_EFBLKH   @FAT_W_EFBLKL   P$        
DIR_W_VERSION     	DIR_R_FIDV 
 V Q  e0
DIR_W_SIZE   DIR_W_VERLIMIT   
DIR_V_TYPE B 
DIR_V_NEXTREC&
DIR_V_PREVREC'DIR_B_NAMECOUNT  ( VDIR_R_$$FILL  
DIR_T_NAMEP DIR_B_FLAGS  x 
 x Q FI2_T_FILENA     ME   xFI2_R_$$FILL  FI2_W_REVISION   
FI2_Q_CREDATE

FI2_Q_REVDATE

FI2_Q_EXPDATE
&
FI2_Q_BAKDATE
.FI2_T_FILENAMEXTB6      P        $CODE     $DATA         w w                                                                                                                                                                                                                                                                          C   1       XUߓ V4.2-01                         6     FLSDEFV4.2-0110-OCT-1990 21:00                   VAXELN PASCAL V4.2_95 
  e
 kH    e   T4$DAPO t$DAPPARSEDEFDAAF11DEFFIDDEFHEADTAILELEMENTABSOLUTERELATIVELOCKED	NOT_EMPTYEMPTYNO_MORE_ENTRIES	READ_MODE
WRITE_MODEREMOVE_MODEBOTHCTX_K_LENGTHDCX_K_LENGTHFCB_K_LENGTHFCB_K_DIR_LENGTHLCB_K_LENGTHPCB_K_LENGTHVCB_K_LENGTHFLS_K_DEFAULT_EXTEND_SIZEFLS_K_MAX_MESSAGESDAP$K_UNSUPPORT_FI D   LE_OPTIONSDAP$K_CANNOT_ACCESS_FILEDAP$K_DEVICE_FULLDAP$K_DIR_LOOKUP_FAILEDDAP$K_DIRECTORY_NOT_FOUNDDAP$K_ERROR_IN_DIRNAMEDAP$K_ERROR_IN_FILENAME eDAP$K_ERROR_IN_VERNUMDAP$K_FILE_ACTIVITYDAP$K_FILE_ALREADY_EXISTSDAP$K_INVALID_ALQDAP$K_INVALID_FILE_ORGANIZATIONDAP$K_INVALID_FSZDAP$K_PRIVILEGE_VIOLATIONDAP$K_RENAME_2DAP$K_UPI_NOT_SETDAP$K_FILE_ACCESS_TEDAP$K_FILE_HEADER_CHECKSUMDAP$K_FILE_HEADER_FULLDAP$K_INDEX_FILE_FULLDAP$K_INVALID_FILE_ATTRIBUTESDAP$K_INVALI E   D_KEY_VALUEDAP$K_INVALID_OPERATIONDAP$K_INVALID_REC_ENCOUNTEREDDAP$K_INVALID_RECORD_ACCESSDAP$K_INVALID_RECORD_SIZEDAP$K_INVALID_RFA eDAP$K_NO_CURRENT_RECORDDAP$K_NOT_AT_EOFDAP$K_RECORD_LOCKEDDAP$K_RECORD_NOT_LOCKEDDAP$K_DIRECTORY_FULL
DRP_K_READDRP_K_WRITEDRP_K_LENGTHFCB_K_UPD_DELTAFCB_K_DIRIDX	FIB_K_CYL	FIB_K_LBN	FIB_K_VBN	FIB_K_RFIPTX_K_LENGTH
VCB_K_VOLNAMEVCB_K_DEVNAMWCB_K_RTRVL_SIZE	WCB_K_MAPWCB_K_LENGTHWCB_K_MAX_WSIZEDIRECTORY_TYPE	FLS_R_MAP	FLS F   _R_FND	FLS_R_DYNACCESS_TYPE
BIT_ACCESSFLS_R_NAME_RECORDFLS_R_ARRAY	FLS_R_WCB
FLS_R_RTVL	FLS_R_PTX	FLS_R_DRP	FLS_R_VCB	FLS_R_PCB  e	FLS_R_FIB	FLS_R_ACC	FLS_R_LCB	FLS_R_FCB	FLS_R_MTX	FLS_R_DCX	FLS_R_CTX	FLS_E_DYN	DYN_K_RSV	DYN_K_FCB	DYN_K_PCB	DYN_K_VCB	DYN_K_WCB	DYN_K_PTX	DYN_K_DRP	DYN_K_NAM	DYN_K_LCB	DYN_K_DCX	DYN_K_CTXDYN_K_EXTPCBACCESS_BITSREAD_BIT	WRITE_BITEXECUTE_BIT
DELETE_BITACCESS_NAMEREAD_ACCESSWRITE_ACCESS
DELETE_ACCESS
CREATE_ACCESSRDATT_ G   ACCESSWRATT_ACCESSEXECUTE_ACCESS   +   P 4    5  1       7 q    -    Q      e U       e ,          >  :  ;  W  f  \    L  ^  a    "P 4  % 
  an-unnamed-tag MAP_L_COUNT  	MAP_L_LBNMAP_A_NXTPTR	FLS_R_FM2  @MAP_W_LOW_COUNT     MAP_W_HIGH_COUNT   
MAP_W_LOW_LBN    MA H   P_W_HIGH_LBN   0 
  { FND_V_WILD_VERSION  
FND_V_WILDFND_V_MAX_VERSIONFND_V_FIND_FID
FND_W_VERSION  eFND_W_COUNT FND_W_$$FILL   FND_A_STRING
P FND_W_FLAGS     `DYN_L_DYNFLN  DYN_A_DYNBLN
DYN_W_SIZE   
DYN_B_TYPE	 `
DYN_B_SPARE  OP  	s P
 n  PRIMARY_NAMEtDAP$ I   NAME_RECORD   SECONDARY_NAMEttNAME_STRING  DEFAULT_STRING  R , 
 , {  WCB_A_WCBFLS   eWCB_A_WCBBLS
WCB_W_SIZE   
WCB_B_TYPE	 `

WCB_V_READWCB_V_WRITEYWCB_V_NOTFCPZWCB_V_SHRWCB[WCB_V_OVERDRAWN\	WCB_A_FCB\
WCB_A_LINKSWCB_L_STVBNWCB_W_REFCNT   
WCB_W_ACONZ
WCB_W_NMAP    ,WCB_R_$$FILL  J     WCB_R_P1T WCB_R_P2T&WCB_W_COUNT     	WCB_L_LBN4
PTX_Q_$$FILL0
  
PTX_W_SIZE   
PTX_B_TYPE	 `
 e
PTX_B_$$FILL1  
PTX_R_CONTEXT(DRP_L_DRPFL  DRP_L_DRPBL
DRP_W_SIZE   
DRP_B_TYPE	 `
DRP_V_FCODE B
DRP_V_IOINPRG\DRP_L_EVENT
DRP_A_BUFFERANYTYPEDRP_L_START_LBNDRP_L_START_VBNDRP_L_STATUSDRP_W_COUNT    K       
   {  VCB_A_FCBFL\  VCB_A_FCBBL\
VCB_W_SIZE   
VCB_B_TYPE	 `
VCB_V_WRITE_IFVCB_V_WRITE_SMY   eVCB_V_HOMBLKBADZ  eVCB_V_IDXHDRBAD[
VCB_V_NOALLOC\VCB_V_EXTFID]VCB_V_GROUP^VCB_V_SYSTEM_VCB_W_TRANS   `	VCB_W_RVN   p
VCB_Q_PCBLIST
VCB_Q_FCB_MUTEX]VCB_L_PCBMSGEVT
 VCB_A_NEXT_VCBW$VCB_A_DRIVER_CTX(VCB_A_FILE_CTX_, L   VCB_L_OWNER0VCB_L_BASE_FHD_VBN4
VCB_L_HOMELBN8VCB_L_HOME2LBN<VCB_L_IXHDR2LBN@VCB_L_IBMAPLBNDVCB_L_SBMAPLBNHVCB_B_IBMAPSIZE  LVCB_B_SBMAPSIZE    ehVCB_B_IBMAPVBN  pVCB_B_SBMAPVBN  xVCB_A_IB_BUFFERRP
VCB_L_IBMAPIDTVCB_A_SBM_BUFFERRX
VCB_L_SBMAPID\VCB_Q_SM_MUTEX]`VCB_Q_IB_MUTEX]h
VCB_W_CLUSTER   pVCB_W_EXTEND   
VCB_L_FREEtVCB_L_MAXF M   ILESxVCB_B_WINDOW  |
VCB_B_LRU_LIM}VCB_W_FILEPROT	DAP$W_PRO ~VCB_B_SPARE   VCB_B_RESFILES  VCB_B_BLOCKFACT  VCB_V_WRITETHRU   eVCB_V_MRKDSMNTVCB_V_MNTINPRGVCB_V_UNIT_OPEN
VCB_V_$$FILL0 BVCB_L_DEV_CHAR	DAP$L_DEV   VCB_Q_DEVICE_DEP_CHAR	DAP$Q_DEV  VCB_L_DIRSEQ 
VCB_L_NAME_ID 
VCB_T_VOLNAME VCB_L_CACHE_HITS VCB_L_CACHE_MISSES N    VCB_B_FFFHDVBN   
VCB_B_$$FILL0   
VCB_W_VOLPROT VCB_W_CLOSEINPRG XVCB_T_DEVNAM  `VCB_B_STATUS    
VCB_R_DYNAMIC 0 e 
  { @PCB_L_PCBFL  PCB_L_PCBBL
PCB_W_SIZE   
PCB_B_TYPE	 `

PCB_B_$$FILL0  CURRENT_VCBWCIRCUITUSER_UIC 
CLEANUP_INPRG$	SUPERSEDE!DELETE_ENTRY"DELETE_PENDING#
DIR_ O   OPERATION$CREATE_FILE_OP%REENTER&ERASE_OPERATION'
CREATE_DIR(RENAME_OPERATION)
FILE_MODIFIED*
DIR_LOCKED+FILE_OPENED,CLOSE_OPERATION-  e
PCB_W_$$FILL0    e&PRIMARY_FCB\(CURRENT_WINDOWS,CURRENT_FIBY0FILE_HEADER	FLS_R_FH2 4	HEADER_ID8
HEADER_LBN<
PLACEMENT_LBN@PREVIOUS_CONTEXTUDFINAL_STATUSH
CLUSTER_BYTESLCLUSTER_SIZE   PMAX_REC_SIZE P      EOFBOFFILE_TRUNCATEDWRITE_OPERATIONSEQUENTIAL_ONLYFIRST_OPERATIONBLOCK_IO_OK
BLOCK_IO_ONLY
CREC_VALIDFIND_OPERATION	FIND_LAST  eSIMULATED_REWIND
PCB_W_$$FILL1   V
TMP_BUFFERX
TMP_MSG_ID\CREC_VBN`	CREC_BOFF   d	NREC_BOFF   fNREC_VBNh	CREC_SIZE   l
PCB_W_$$FILL2   n
LOCKED_RECORDpNAME_CONTROLQt                                                                                                                                                                                                                                                   c                        Y $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "     P        Q   
NAME_BLOCKxDEFAULT_NAME|DIR_FCB\ DIR_CONTEXT^ 
SAVED_CONTEXT^ NEW_FID 	SUPER_FID	FLS_R_FID  DIR_SEQUENCE    
SECONDARY_PCBX PRIMARY_FIBY  e
SECONDARY_FIBY  LCONTEXT_AREA($ 
  { 
FIB_W_ACONZ  	FIB_B_ORG  	FIB_B_RFM  (	FIB_B_RAT	DAP$B_RAT  0	FIB_B_SHR	DAP$B_SHR  8	FIB_L_FOP	DAP$L_FOP   R   @	FIB_R_FIDZ	FIB_R_DIDZ	FIB_L_WCCFIB_V_ALLVER FIB_V_ALLTYP FIB_V_ALLNAM 
FIB_V_WILDFIB_V_NEWVER FIB_V_SUPERSEDE 
FIB_V_FINDFID FIB_V_LOWVER   e
FIB_V_HIGHVER FIB_V_ALCONFIB_V_ALCONB FIB_V_FILCON FIB_V_ALDEF FIB_V_ALLOCATR FIB_V_EXTEND FIB_V_TRUNC FIB_V_NOHDREXT 
FIB_V_MARKBAD 
FIB_L_EXSZ FIB_L_EXVBN$FIB_B_ALOPTS S   	DAP$B_AOP  (
FIB_B_ALALIGN  H
FIB_R_LOC_FIDZ*FIB_L_LOC_ADDRESS0FIB_W_VERLIMIT   4  FIB_B_WSIZE  FIB_W_NAME_CONTROL   FIB_W_EXTEND_CONTROL       e
  {  e
ACC_V_NOWRITE  ACC_V_DLOCKACC_V_SPOOL
ACC_V_WRITECK
ACC_V_SEQONLYACC_V_WRITEACC_V_READCK	ACC_V_NOREAD

ACC_V_NOTRUNC 
ACC_W_ACON     LCB_A T   _LCBFL[  LCB_A_LCBBL[
LCB_W_SIZE   
LCB_B_TYPE	 `
LCB_V_EXCLUSIVELCB_V_READ_LCKYLCB_V_WRITE_LCKZLCB_L_RECORD_NUMBER  
   {  FCB_A_FCBFL\  FCB_A_FCBBL\
FCB_W_SIZE     e
FCB_B_TYPE	 `

FCB_B_$$FILL0  FCB_A_EXTEND_FCB\FCB_A_WCBFLSFCB_A_WCBBLSFCB_A_VOLUME_LINKWFCB_W_ACCESS_CNT   FCB_W_LOCK_CNT    FCB_W_WRITER_CNT U       FCB_W_DIRACC   FCB_W_DIR_ACC_CNT    	FCB_V_DIR0
FCB_V_MARKDEL1FCB_V_BADBLK2
FCB_V_EXCL3
FCB_B_$$FILL1  '	FCB_R_FIDZ(FCB_W_SEGNUM   .FCB_A_FILE_HEADER30FCB_L_HEADER_LBN4 eFCB_L_HEADER_ID8FCB_L_STVBN<FCB_L_STLBN@FCB_L_FILESIZEDFCB_L_FILEOWNERHFCB_W_FILEPROTLFCB_W_VERSIONS   pFCB_L_EFBLKPFCB_L_UPDATE_COUNTTFCB_W_D V   IRSEQ   XFCB_W_TRNC_LCK_CNT   FCB_L_BASE_VBN \
FCB_L_CBUFdFCB_A_FILE_BUFFER hFCB_L_MESSAGE_IDpFCB_L_RESERVEDtFCB_W_LONGEST_REC   xFCB_V_BUFFER_VALID   eFCB_V_MODIFIED  FCB_V_INTERNAL_TEF
FCB_B_$$FILL2  {
FCB_A_DRP_PTRV |FCB_L_CEOF_VBN FCB_W_CEOF_BOFF    FCB_W_REC_COU W   NT    FCB_L_UHIGH_VBN FCB_A_LCBFL[ FCB_A_LCBBL[ FCB_Q_MUTEX] FCB_L_REC_EVENT
  {FCB_B_FLAGS  z FCB_B_DIRIDX      MTX_W_COUNT   MTX_L_SEMAPHORE+ eDIR_VBN  
DIR_BUFFER
 DIR_SIZE   DIR_TYPE	 `
	DIR_SPARE  DIR_MESSAGE_ID	DIR_ENTRYFLS_R_DIR_ENTRY DIR_VERSION
FLS_R_DIR_VER DIR_E X   NDDIR_PRED
DIR_RECORD 
DIR_STATUS$
VERSION_LIMIT   (
VERSION_COUNT   PPREV_VERSION   `LAST_DIRECTORYZ.DISPLAY_ATT4COMPLETION_PENDING
LAST_ENTRYP5	PREV_NAMEP PREV_STRINGP   eCTX_L_VCB_MUTEX  
CTX_A_VCBLISTW
CTX_W_SIZE   
CTX_B_TYPE	 `
CTX_B_SPARE  
CTX_A_OPEN	CTX_A_GET	CTX_A_PUTCTX_A_CLOSE              P.DIR;1 5  
      DIRECTORY_TYPE      $CODE     $DATA        w w                                                                                                                                                                                                                                                                                                                                                                                                                                    Z   1       @8Xߓ V4.2-01                         8     FLSENTRYV4.2-0110-OCT-1990 21:00                   VAXELN PASCAL V4.2_95 
  e
      e   T4$DAPO t$DAPPARSEDEF$KERNELDAAF11DEFFIDDEFkHFLSDEF
FLS_R_WORDPAS$NEW2DISK_PUT	DISK_OPENDISK_GETDISK_DIROPEN
DISK_CLOSECLOSE_ACTIONDISPLAY_ACTION
EXTEND_ACTIONFLUSH_ACTIONTRUNCATE_ACTION
REWIND_ACTION
UPDATE_ACTIONFIND_ACTION
PUT_ACTION
GET_ACTIONERASE_ACTIONDIR_LISTDIR_OPEN
RENAME_ACT [   IONOPEN_ACTIONWRITE_BLOCK
STORE_REVERSEREAD_REVERSE
READ_BLOCKOPEN_DEVICEMINMAXMAP_AREA_STARTMAP_AREA_END
IDENT_AREAGET_CONTEXT
COMPLIMENT eCLOSE_DEVICE
SEND_TRACEGET_TRACE_BUFFERGET_TRACE_HEADERPERFORM_TRACE_DONEPERFORM_TRACE_INITELN$LOG_VOLCHANGEZERO_WINDOWS
WRITE_FILE
WRITE_DISKUPDATE_HIGHWATER
UNLOCK_RECORDUNLOCKTURN_WINDOWTRUNCATE_HEADER
TRUNCATE_FILETRAVERSE_DIRTRANSLATE_STATUSSWITCH_BUFFERSSHUFFLE_DIRSET_NEXT_RECORDSEND_BADSCANSEA \   RCHSAVE_DIRSAVE_CONTEXTRETURN_FILESPECRETURN_CHARACTERISTICS
RETURN_BITMAPRETURN_ATTRIBUTESRESTORE_DIRRESTORE_CONTEXT
REMOVE_VCB	REM_QUEUEREMOVE  e	READ_HOMEREAD_HEADER	READ_FILE	READ_DISK
READ_AHEAD
PARSE_NAME	OPEN_DISKNEXT_HEADERNEXT_FIXED_RECORDNEXT_DIR_REC	MOVE_BITS
MOUNT_MESSAGEMOUNT
MATCH_NAMEMARKDEL_FCBMARK_DELETEMAP_VBN
MAKE_ENTRYLOCKIO_READ	INS_QUEUEINIT_FCBGET_MAP_PTR
GET_ACCESS
FLUSH_BUFFERSFIND_FIRST_SETFIND_FIRST_CLEARFIND_FC ]   BFILE_HANDLEREXTEND_INDEX
EXTEND_HEADEREXTEND_FILE
ERASE_FILEENTER_USER_CONTEXTENTEREMPTY_DIRECTORYDISK_HANDLERDIRECTORY_SCANDIRECTORY_DEACCESS  eDIRECTORY_ACCESSDELETE_MUTEXDELETE_FFILE
DELETE_EXTFCBDEALLOCATE_STRUCTUREDEALLOCATE_MESSAGEDEALLOCATE_BAD
DEACCESS_FILE
CREATE_WCBCREATE_MAP_PTR
CREATE_HEADER
CREATE_FCB
CREATE_EXTFCBCREATE_FILE
CLOSE_DISKCLEANUP	CHECKSUM2CHECKSUMCHECK_RECORDCHECK_PROTECTIONCHECK_HEADERBUGCHECK	BUG_CHECKBUFFER_SET ^   UPALLOCATE_STRUCTUREALLOCATE_MESSAGEALLOCATE_BITMAPACCESS    
STRUCTURE_SIZE% ANYTYPEDAP$PUT_ACTION DAP$OPEN_ACTION   eDAP$GET_ACTION DAP$DIR_OPEN DAP$CLOSE_ACTION DAP$DISPLAY_ACTION DAP$EXTEND_ACTION DAP$FLUSH_ACTION DAP$TRUNCATE_ACTION DAP$REWIND_ACTION DAP$UPDATE_ACTION DAP$FIND_ACTION DAP$ERASE_ACTION DAP$DIR_LIST DAP$RENAME_ACTION 
VCB%0
LBN%0
COUNT%0
BUFFER%0 _   	FLS_R_VCB 
N	 
M0FLS_R_REVINT 
M	 
N0
%0
%0
%0
%0 
%0
DEV_DEP_CHAR%0	DAP$Q_DEV  e !
M%0
N%0"
M%0
N%0#
FHD0	FLS_R_FH2 $	FLS_R_FM2 
0%
0&	FLS_R_FI2 
CONTEXT0'	FLS_R_PCB 
	FILE_PRIV0
BIT_ACCESS  ( 
%0) 
ENTRY	 QUEUE_ENTRY 
RETURN_PTR	 + ,  . 
ACTION%  `   
OWNER% 
ERRCNT% 
OPRCNT% 
UNIT% 
DEVNAM 
VOLNAM 
VOLNUM% 
NUMSET% 	 
FCB% 	FLS_R_FCB  
PCB% 
BUF% 
% 1 
% 
   e% 
% 
% 2 
% 
NEW_HWM%  
% 

RECORD_NUMBER	  
MUTEX	 	FLS_R_MTX  
WCB% 
% 
DESIRED_VBN% 
	START_VBN% 	FLS_R_WCB 6 
% 
FIB% 
% 
	START_MAP	
LAST_COUNT% 	FLS_R_FIB  
% 
% 
% 
FHD_ID% 8 
%  a   
NAM% 
MODE% DAP$NAME_RECORD 9 
STATUS% : 
% 
FILL% ; 
% 
DCX% 
	DIRECTION% 	FLS_R_DCX < 
% 
NOSPAN%  
FID  e	FLS_R_FID  
% 
% 

SEARCH_STRING	 
OLD_STRING	 
%   ? 
% 	@	 
%  
% 
RESULTANT_FILESPEC	   
BLOCK_SIZE	 
ALLOCATION_QUANTITY	 
BUCKET_SIZE	 
FIXED_CONTROL_SIZE	 
MAXIMUM_RECORD_NUMBER	 
DEFAULT_EXTENSION_QUANTITY	 
LONGEST_RECORD                                                                                                                                                                                                                                                   d                        H+ $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        } "     a        b   _LENGTH	 

HIGHEST_BLOCK	 
END_OF_FILE_BLOCK	 	
FIRST_FREE_BYTE	 

STARTING_BLOCK_NUMBER	 

CREATION_DATE	 

REVISION_DATE	 

EXPIRATION_DATE	 
BACKUP_DATE	 
REVISION_NUMBER	  e
	 
PROTECTION	 
%                 



   	DAP$W_PRO  
% 
% 
%  
% 
ORGANIZATION	 

RECORD_FORMAT	 
RECORD_ATTRIBUTES	 
MAXIMUM_RECORD_SIZE	 
FILE_OPTIONS	     	DAP$B_RAT  	DAP$L_FOP   
% 
% 
 c   SAV_DCX	 	+	 
%  
%  
POSITION% 
HEADER% 
	 
QUEUE_TYPE% I 
% 
% 
ALL% 	J 
% 
VOLNAME 
HOME%   e
DEVICE_DEP_CHAR 
BLOCK_FACTOR	 
STATUS_2	 	FLS_R_HM2 K 
% 
FILE_ID	
	
	  L 
% 
BLOCK% M 
% 
% 
% 
% N 
%  
FILESPEC	 
FND%  	FLS_R_FND P 
% 
% Q 
% 
	
	 d   
EXT_FID	
EXT_SEG%   R 
% 
RNM% 
RECORD_BLOCK	 
RECORD_BYTE	 
%     
% 
% 	T 
BASE	 
POS%   e
SIZE% 
VALUE%  
	
ERROR_CODE%    
% 
PARTNER 
INTERACTIVE% W 
SRCLEN& 
SRCPTR% 
DSTLEN& 
DSTPTR% }
|
~X 
% 
% 
PRIMARY_FCB% 
DIR_FCB% Y 
% 
% 
	DO_DELETE% Z 
% 
% 
% 
BLOCKS% e   
UNMAPPED	 [ 
% 
% 
^% 
% 	_\ 
	  
% 
DRP% 	FLS_R_DRP  
>% 
?% 
% 
A% _ 
% 
%   e 
MAP	 	FLS_R_MAP 
USER_UIC% 
% 
+E -b  
% 
BUF_SELECT% 
	ZERO_FILL% c 
	 
	START_POS% 
	END_LIMIT% d 
	 
% 
% e 
% 
P	 f 
%  
% 
FILE_NUMBER%  
% 
% 
	
 f   OLD_HEADER	  i 
% 
% 
% 
MID% j 
% k 
ROUTINE% 
ARG_LIST%  
% 
% 
% 	m 
% 
% n 
  e%  
%   e
% 
^% 

	
START_BLOCK% 
START_RECORD	

START_VERSION	
PRED	
SEARCH_COUNT% 		_VFLS_R_DIR_ENTRY 
FLS_R_DIR_VER Vp 
%  
% 
% 
% 	 ACCESS_NAME r 
	  
% 
% 
 g   % t 
%  
PTR%  
	 
	  
% 
% 
% 
	
%  
%  
ACCESS_CONTROL 
t% 
% 
% 	FLS_R_ACC z 
% 
	 
% 
  e	 
	PLACEMENT% { 
% 
P	 | 
% 
% 
% 
% 
% } 
% 
% 
% 
% ~ 
% 
2% 
3% 
4% 
5%     7  
%  
%  
BUFLEN%  h   
%  
?%  
% 
%  
% 
% 
% 
% 
% 	  
% 
P  
w%  
w%  
% 
RECORD_OPTIONS% 	DAP$L_ROP   
DYN_SIZE%   e
DYN_TYPE% 	 	FLS_E_DYN  
MSG_SIZE% 
MSG_ID	  
% 

PLACEMENT_LBN% 
% 

BLOCKS_NEEDED% 
	START_LBN	 
BLOCKS_ALLOC	  
% 
2	 
3	 
4	 
5	 
6	 
ACCESS_MODE%     7 8 	 i    ))(ARG_CNT  CUR_VCB&(	ARG_BLOCK(AprFstBuCxKER$ENTER_KERNEL_CONTEXTADDRESS'HF''y)(('   e
FLS_R_BYTE& (JJ?/''(&&)
SECONDARY_PCB(7'&)N'&	&&(
WORD_ARRAY P     &&&H)P) j   FH2_B_IDOFFSET'%%(P P     &%&H)P)FH2_B_MPOFFSET)FH2_B_MAP_INUSE.'$$(P P     &$&H)  eP)   eX'##(M&N&MN8#M#N	""(M&N&MN8"N"M	!!(B  CDEP_CHAR&&(F( k   eFBChGHQ'HF''!  (B  CDISK_LBN	BLK_COUNT	IO_BUFFER&&&&(F(n  eFBCqrsGHN'HF'' M'N&MFLS_R_INTFMTLOW_WORDN}M|	HIGH_WORDN~N'     M&N}M|}N~M|~(B  Cqrs&&&&(F(FBCq r!s6  e$GH2'HF'''      P        $CODE     $DATA         w w                                                                                                                        m   1       1 _ߓ V4.2-03                         6     ACCESSV4.2-0310-OCT-1990 21:00                   VAXELN PASCAL V4.2_95 
  e
 Z=L    f  e    T4$DAPDAAF11DEFFIDDEFkHFLSDEFFLSENTRYRETURN_ATTRIBUTES ACCESS    KER$CREATE_EVENT  KER$CREATE_SEMAPHORE  CHECK_PROTECTION  
CREATE_EXTFCB  
CREATE_FCB  
CREATE_WCB  DEALLOCATE_MESSAGE  FIND_FCB  	INS_QUEUE  LOCK  NEXT_HEADER  READ_HEADER  UNLOCK      P  
      ACCESS  n   ^޼T޼nФ0RФR LOCKФ0Rݤ FIND_FCBP(Uդ(6Ф(Sգ0"Ø  LOCKФ(RТ04Т4<Т88UØ  LOCKUФ0Rߤ4(T READ_HEADERդ4!Џ 
 Xդ(Ф(R  UNLOCKԤ(1IФ4R5!Џ 2 Xդ(Ф(R  UNLOCKԤ(1ݤ4 ݤ ~ݤ CHECK_PROTECTIONPXXդ(Ф(R  UNLOCKԤ(1դ(1 Ф(SФ0VФW&$+<R
f!< R f<R <U!<.RЏ 0 XØ  UNLOCKԤ4Ԥ(1K$UU
<$RRR$ 
< RRR  f
<RRRf
<ZRRRZФ o   40 Ф88<RR<RR<R <RRRЏ X1  ݤ8ݤ<ݤ4ݤ 
CREATE_FCBP(Ф(SФ0VФU$$
fRR&   ffZռ<Ф40Ф88Ø  Ü   KER$CREATE_SEMAPHOREà   KER$CREATE_EVENTØ  LOCKeR Rݤ( 	INS_QUEUEPX<RRRЏ XX14߼߼߼T0$5Ф(UФ0SRݤ(ݤ4Rc 
CREATE_WCBP,ޥR Rݤ, 	INS_QUEUEHФ(UФ4Ф8|~(4T NEXT_HEADERPS	 HФHXSd߭߭
 DEALL p   OCATE_MESSAGESФ8ЭRݤ FIND_FCBPPUURT 
CREATE_EXTFCBPU|~eT NEXT_HEADERPS	 HФHXSU(3X
߭߭ DEALLOCATE_MESSAGEߤ4( T READ_HEADERФ(RФ40Ф(RФ88XФ(R  UNLOCKФR UNLOCKXP   
    <RETURN_ATTRIBUTES    P<^޼UХ4RTd d<Х(S<xxХ0RԼХ4R4ȏ   4ȏ   4ȏ   4ȏ @  5 4ȏ@   мRԼRR        $C     ODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         	 r   1       Xdߓ V4.2-01                         6     BITMAPV4.2-0110-OCT-1990 21:00                   VAXELN PASCAL V4.2_95 
  e
 b\)W    `  e    T4$DAP$KERNELkHFLSDEFFLSENTRY
RETURN_BITMAP ALLOCATE_BITMAP    KER$ENTER_KERNEL_CONTEXT  BUGCHECK  LOCK  	MOVE_BITS  	READ_DISK  UNLOCK  
WRITE_DISK   FLS$K_ILLEGALEXT   FLS$K_BADSBMBLK       P  
      ALLOCATE_BITMAP,^޼YЬ[޼W޼<pRRǮRZnORRѮRծԮ                                                                                                                                                                                                                                                   e                         $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "     r        s   xɈ Sɉ RRSɂ RRS[$[Ɍ 
 (Ԯ1[Ǯ[Ǐ   ` LOCKǮɌ X­X1 [ ߭߭Xݭ YIP1 ­XЭ(XЭUŮURƮRRŮRTǮTSUSRRZ6ǮRRST ([UTRR` UNLOCKԮ1 TXXTXZZVXV߭߭VݭYϺ ЭRRXRnЭRnnZF 	n8X&  ([` UNLOCKԮm[X1ծ	Ԯԭ1n nZ` UNLOCKԮ4߭߭ݮݮY%Ůn ¼t` UNLOCKЮP   PϞT^޼U޼YЬ t   `޼ЮX`WMRWRݏ FLS$K_BADSBMBLK BUGCHECKŐ1WVORVRGХXhWHTlUpTtxh| 	READ_DISKSl~S߭ KER$ENTER_KERNEL_CONTEXTХXVO`R `nX1n TTXXSTSS[Y`Y.[nSnSBXVSPnTPSP  STSfTSPTZN[nSnSBXVSPnTPSP  STSfTSPTZ SYSS[ݮBX 	MOVE_BITS[nZnZSSX1FZ 1>RnRV XTRTT   PTPPSQY!YQR   ;BXQ4 RS/RYQR   RSQBXRR    u   RSVRPxPPPXR   1 X1 Y9ХXSWHTUTS 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTХXWMPWPݏ FLS$K_BADSBMBLK BUGCHECKې1 ХXSWHTUTS 	READ_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTХXWPPOR1X1Y9ХXRWHTUTR 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTХX޼SXc޼R
S`cbRXRRggP  
    
RETURN_BITMAP    P޼V޼X޼WXWRRƌ <pSSXU     SURXRSWTTSWSݏ FLS$K_ILLEGALEXT BUGCHECK` LOCK|~TUVϜWt` UNLOCK    t  $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                  w   1    	   @iߓ V4.2-02                         5     BLOCKV4.2-0210-OCT-1990 21:00                    VAXELN PASCAL V4.2_95 
  e
 	ò      e    T4$DAP$KERNELkHFLSDEFFLSENTRY
WRITE_FILE 
WRITE_DISK 	READ_FILE 	READ_DISK 
READ_AHEAD 	OPEN_DISK IO_READ 
CLOSE_DISK    KER$WAIT_ANY  KER$CLEAR_EVENT  
KER$SIGNAL  KER$ENTER_KERNEL_CONTEXT  BUGCHECK  	INS_QUEUE  MAP_VBN  	READ_DISK  
WRITE_DISK   FLS$K_FILBLKNOTMAP       P 	 x    
      
CLOSE_DISK  ޼RТ,Pݢ(ްP`   
     IO_READ ^޼S޼RТQ<pnТPSPnQ 	READ_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭݢ  
KER$SIGNAL  
  k   	OPEN_DISK,  k   P^޼R޼nТ,Pݢ( ްP`  
     |
READ_AHEAD  |^޼TФ(SУdQ<PVA\VQRB|QzRPPzqVDkQU  BhV<PP߭PVݤ,T MAP_VBNPݥ  KER$CLEAR_EVENTФP~PPB| 	INS_QUEUEPФPݠ   
KER$SIGNAL  y    
  1  	READ_DISKn  1  P^޼R޼T޼޼nTݏ FLS$K_FILBLKNOTMAP BUGCHECKSТ,Qx	Pݢ(PݮTޱP`PSSP  
  }  	READ_FILE  }  P ^޼V޼nЦ(UХdTnR<PPPRPRRD\TzЦSD|R(ݢ|~  KER$WAIT_ANYҊD\
ä ТW\è <PP߭PD\ݦ,V MAP_VBNPSDhR<PTЦPPSTR 	READ_DISKR~R߭ KER$ENTER_KERNEL_CONTEXTЭWWP  
  >  
WRITE_DISK n  >  P^޼R޼T޼޼nTݏ FLS$K_FILBLKNOTMAP BUGCHEC     KSТ,Qx	Pݢ(PݮTޱP`PSSP  
    |
WRITE_FILE     P|^޼R޼UЬVТ(T%V<PV߭VE\ݢ,R MAP_VBNPSEhQТPPSVQ 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭP      $CODE     $DATA         w w                                                                                                                                                                                                                                      {   1        nߓ V2.0-00                         8     BUGCHECKV2.0-0010-OCT-1990 21:00                   VAXELN PASCAL V4.2_95 
  e
     o  e    T4$DAP.(
$DAPDECODEDEF,
DAP$ACCESSkHFLSDEFFLSENTRY
MOUNT_MESSAGE BUGCHECK  (      P-F-NOMSG, console:on device  l   PAS$HEX  DAP$OPEN  DAP$PUT  	DAP$CLOSE  	BUG_CHECK   
FLS$K_MOUNTED  TABLE  	MNT_TABLEl -I-MOUNTED, actual volume name is %FILE-F-BUGCHECK, fatal bugcheck%FILE-E-MOUNTERR,  |   error mounting volume   
     <BUGCHECK 6 <^޼ TABLEn ( R ݮRݮϜ   
     
MOUNT_MESSAGE    PÞ,^޼,^0 	MNT_TABLE4޼VƘ ?EƲ X2XY((r|(
<YWW0^(2|n(Xƴ YP P(n((6H(Ƙ 4(4HRf,R4 T  P΀^ЬWЬTЬP}ψ|~|~|~|~< ~|~߭|~   DAP$OPENP1& 
FLS$K_MOUNTED!TS|~ 2d~c|~ 	 DAP$PU     TPXXXRB
BXXXRB. 	 PAS$HEX}(
ϵ}W 
FLS$K_MOUNTED!ЬV("϶͎ (Ƙ .(.͎+xXS2CRWRVC (fTT2RS|~ Rd|~ 	 DAP$PUTPRSް(|~|~ 	DAP$CLOSEP RR 	BUG_CHECK      $CODE     $DATA        w w                                                                                                                             	 ~   1       Crߓ V4.2-00                         9     	CHECKPROTV4.2-0010-OCT-1990 21:00                    VAXELN PASCAL V4.2_95 
  e
 UH    O  e    T4$DAPFIDDEFkHFLSDEFFLSENTRYCHECK_PROTECTION     
GET_ACCESS      P  0.   
     CHECK_PROTECTION t^޼U޼WЬx޼T޼SW;RT<(PP	-PRS<PP	
PRR
Џ U V1!xQ	Q  V1WRRń 
Џ t V1 Ů vvݥ0Qu 
GET_ACCESSuPPPPP     B>QPPPPQ
Џ U V1 TL}ФHRS@}У<R}RWPP zxRVl}vvRxt 
GET_ACCESStPP
PPPW#PPPPPWP@ϋQPPPPQ	Џ U VVVP      $CODE     $DATA        w w                                                                                                                                                                                                                                                     1       `|wߓ V4.2-02                         7     CLEANUPV4.2-0210-OCT-1990 21:01                    VAXELN PASCAL V4.2_95 
  e
 Ԯ    d  e    T4$DAP$KERNELFIDDEFkHFLSDEFFLSENTRY
DEACCESS_FILE CLEANUP |  
KER$DELETE  KER$WAIT_ANY  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_STRUCTURE  BUGCHECK  DEALLOCATE_MESSAGE  DEALLOCATE_STRUCTURE  
DELETE_EXTFCB  DELETE_FFILE  DIRECTORY_DEACCESS  DIRECTORY_SCAN  LOCK  
MAKE_ENTRY      REMOVE  	REM_QUEUE  RESTORE_DIR  SEARCH  UNLOCK  
WRITE_DISK  ZERO_WINDOWS  CLOSE_ACTION   FLS$K_ILLEGALEXT      P  
      CLEANUPǞδ^ЬWWVЦ0R$զ(.%)SyRn;W;|~|~ CLOSE_ACTIONզ(Ц(R  LOCK$1 $	Ц0R
Y	<+~ ALLOCATE_STRUCTUREPƄ Ц0S<R
Ц4R(BЦ0S<Rݏ FLS$K_ILLEGALEXT BUGCHECKݦ0W SEARCHݦ4ݦ0W DELETE_FFILEPݦH BUGCHECKզ(Ц(RЦ40Ц88$    $
$$1$RRX$RRY$RRZF$Ƅ RբbƄ W RESTORE_DIRZ Ƅ W REMOVEPݦH BUGCHECKY1 H|Ƅ R Ƅ R Ƅ R<,RRXFƄ R5Rݏ|~|~ RƄ W	 DIRECTORY_SCANP HݦH BUGCHECKЦ0R(Ɛ Rݦ0RƄ W 
MAKE_ENTRY$P
P BUGCHECKƄ SУTƀ R@cSSЦRRST 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЦR XdYaZ^Ƅ R,Ƅ RТR(Ɛ Ƅ SУTƀ R@cSSЦR    RST 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTƄ &Ƅ Rբ
ߢߢ DEALLOCATE_MESSAGEƄ  DEALLOCATE_STRUCTUREƄ WU  DIRECTORY_DEACCESSզX
ߦ\ߦX DEALLOCATE_MESSAGE$
$%$W   
  -  <
DEACCESS_FILE -  P<޼SУ(Rգ(գ4
ߣ8ߣ4 DEALLOCATE_MESSAGE$1I  UNLOCKУP LOCK  LOCKPѣ(PPU$1 <PPU1 P1 բh1 Т|Pݠ|~  KER$WAIT_ANY Pݠ|~  KER$WAIT_AN                                                                                                                                                                                                                                                   f                        W/ $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        Db "                Yߢpߢh DEALLOCATE_MESSAGEТ|Pݠ  
KER$DELETE Pݠ  
KER$DELETEݢ| DEALLOCATE_STRUCTURE  DEALLOCATE_STRUCTURE||ԢlԢ\`Ԣdz$
ݣ( ZERO_WINDOWSգ,1 У,T&
<ZPPPZ 
<PPP 2< QQQ < P"<(PPУP ~<(PPУP ߣ,ݣ, 	REM_QUEUEݣ, DEALLOCATE_STRUCTUREԣ,$<PPP
<$PPP$УQ<PPP<Q<$PQPUQբ0ߢ8ߢ0 DEALLOCATE_MESSAGEԣ4<P_U\<$PV &D ߣ(ݣ( 	REM_QUEUEݣ(      
DELETE_EXTFCB   
KER$DELETE    
KER$DELETEݣ( DEALLOCATE_STRUCTUREԣ(  UNLOCK  UNLOCKԣ(УP UNLOCK$      $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                               	    1       @{ߓ V4.2-01                         5     CLOSEV4.2-0110-OCT-1990 21:01                    VAXELN PASCAL V4.2_95 
  e
 ='    h  e    T4$DAP$KERNELE,
$KERNELMSGDAAF11DEFkHFLSDEFFLSENTRYCLOSE_ACTION    KER$GET_TIME  KER$ENTER_KERNEL_CONTEXT  CHECK_PROTECTION  CHECKSUM  EMPTY_DIRECTORY  
FLUSH_BUFFERS  LOCK  
TRUNCATE_FILE  UNLOCK  
UNLOCK_RECORD  
WRITE_DISK      P  
      CLOSE_ACTION 0^޼n޼X}    ޼Z޼Y޼ЮP  QPQQUUSУ(TУ0VУPX PPPP T %WĘ  LOCKФ04Ф88գp
ߣpݣ( 
UNLOCK_RECORDzzU 
FLUSH_BUFFERSP1XУ0PzXXЏ 4 1<PP1 դT%Ф0Q&PP5n
% У0Q
X	Ф0P5N ݣ(ݣ ݣ CHECK_PROTECTIONP1У4P5ݣ4U EMPTY_DIRECTORYPЏ  1\$ 1@գ,У,P	Ф0P@4 %1  1 УP Џ t 1zĄ $Č R    Ą PPRPQRQQ$<Ĉ PѦ$Ą ֦$Ԧ Ф04Ф88ݤ0 CHECKSUMPݤ8ݤ0ݣ0U 
TRUNCATE_FILEPУ40У88У0PW1Ф0PUУ0PPP"P$PTxxWWФ0QaP>@aRQyPPѮQѮP
}W$%߭ KER$GET_TIMEѭ  |WZ	ZW%W
<PPPWY
<PP  Q ݣ(ݣ ݣ CHECK_PROTECTIONP1 ޼R<bPP  Ф0Pb@bLWYФ0PY<YHW%W`Ĉ Ą 䰭
ݤ0 CHECKSUMУ4QУ<RУP w P     RQ 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭЏ Ę  UNLOCK0%ЭP       $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                 1       Kߓ V4.2-00                         6     CREATEV4.2-0010-OCT-1990 21:01                   VAXELN PASCAL V4.2_95 
  e
 S-c    g  e    T4$DAP$KERNELE,
$KERNELMSGDAAF11DEFkHFLSDEFFLSENTRYCREATE_FILE        P   KER$CREATE_EVENT  KER$CREATE_SEMAPHORE  KER$GET_TIME  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_MESSAGE  
CREATE_FCB  
CREATE_HEADER  
CREATE_WCB  DEALLOCATE_MESSAGE  ENTER  EXTEND_FILE  INIT_FCB  	INS_Q    UEUE  MARK_DELETE  RESTORE_CONTEXT  SAVE_CONTEXT  UNLOCK  
WRITE_DISK  DIRECTORY_TYPE  ELN$INTEGER_TO_CHAR_VAR_R3 
     CREATE_FILEϞP^޼X޼X޼\ЬV޼T^P $ШR Џ t x1$Ш0RX 
CREATE_HEADERP||R	ШHx1(bd, n XTXTT|SȀ RТH<ШR~@STRRc\RR cV/\\BVV;ߨ8| DEALLOCATE_MESSAGEЏ X x1aVVߨ8| DEALLOCATE_MESSAGEЏ X x1@Ш    0RRRV
VVVVVT
Ш0R\|TШ0SRR4RR4RR5RR4RR4RR5|4Ȍ Ш0R
;ݨ0 Ȅ X ENTERPxx1Ш4SШ0R(BШxSȄ R	ШxRШxV<dQdPSkR  ELN$INTEGER_TO_CHAR_VAR_R3mRk(bШ4ScR>Bc`VY %0<DSRRSSVVV VV(VHVV V, Vc1 iaRRSRRWSWZZ[<ZVVP^nV(S4f(W8<[WW^(Zfn( DIRECTORY_TYPE[VVV VV(VnVV V, VcH    SCKRRTTVCPR<VWWP^(Tbn( DIRECTORY_TYPEVV VV(VnVV V, Vc(``R(B 6`Rx KER$GET_TIMEx  |ݨ(ݨ8ݨ<ݨ4ݨ 
CREATE_FCBP(Ш(TШ0U
eRR&   eeZШS<RRRĘ  Ĝ   KER$CREATE_SEMAPHOREĠ   KER$CREATE_EVENT %1 ߭< ~ ALLOCATE_MESSAGEPЭScШ0R $ݨ8ݨ4ݨ0X EXTEND_FILEPUШ(RШ40Ш88U{Ш4Rϳ@Ш(R Ш4RR
ݨ(ݨ4 INIT_FCBSTШ(RТ@SШRRS     T 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭU%߭߭ DEALLOCATE_MESSAGEUxx1 5Ш0RSݨ(ݨ4Sb 
CREATE_WCBP,Ш(RޢR Rݨ,   	INS_QUEUEШ(RШ40Ш88Џ x$0X SAVE_CONTEXTШ0R(Ȑ ݨ0X MARK_DELETEPxX RESTORE_CONTEXTxF$Ш(R  UNLOCKШ0RxP    u  $CODE     $DATA        w w                                                                                                                     1        ڱߓ V4.2-00                         9     	DIRECTORYV4.2-0010-OCT-1990 21:01                    VAXELN PASCAL V4.2_95 
  e
 >    Y  e    T4$DAPO t$DAPPARSEDEFkHFLSDEFFLSENTRYDIR_LIST DIR_OPEN        P;:DISK$ *.*;*   DAP$PARSE_FILESPEC  ACCESS  ALLOCATE_STRUCTURE  
DEACCESS_FILE  RETURN_CHARACTERISTICS  SEARCH  TRAVERSE_DIR  ELN$INTEGER_TO_CHAR_VAR_R3  PAS$NEW2 
  
   DIR_OPEN Ϟ^޼Rb(b޼Ь    ޼(^XШR 
 Џ ! 15 | DAP$PARSE_FILESPECPШxRШ| x DAP$PARSE_FILESPECP1ШxR RЏ  1 ݨx TRAVERSE_DIRP1Ȅ Tˏ   RSRSS 4$ШWR:ǘ P
RR[[Ь[VVZ<ZYY^(n(Vǘ WZVV V(VnV RRRVRg(RύcШxVЬSRRc cc(c$H<DRR (H  ݨ0 SEARCHP  Ш0RԢȄ RԢ.2 H	ШH    1 1 <~ ALLOCATE_STRUCTUREPȘ Ș RШȘ RPPȘ RШLLȘ R(Ș RШ  R V<~ PAS$NEW2PtЦtW, n t ggxЦxR<ЦxR @, n t tt|Ц|R<Ц|R@P  
    DIR_LIST    PϞ^Ьp^Zʄ R4ЪxRRlЏ [1l޼LWgVHЪxS<DRR (H gݪ0 SEARCHP[ HЪH[14[2VRЏ [l1ʄ R4ʄ Y<QPSR  ELN$INTEGER_TO_CHAR_VAR_R3(     HЩSRRRRV<VXX^(RnDV V(VnV RRRVRg(Rcʄ R 4{߼߼߼ ACCESSP[[YЪSRÄ ߼h߼d߼`\XTP߼D߼@߼<߼8߼4߼0߼,߼(߼$߼ ߼6  RETURN_CHARACTERISTICS 
DEACCESS_FILE[P    r  $CODE     $DATA    
    w w                                                                                                                                                                                                     1        סߓ V4.2-05                         7     DIRSUBSV4.2-0510-OCT-1990 21:01                    VAXELN PASCAL V4.2_95 
  e
 xa      e    T4$DAPO t$DAPPARSEDEF$KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRYTRAVERSE_DIR SHUFFLE_DIR NEXT_DIR_REC EMPTY_DIRECTORY DIRECTORY_SCAN DIRECTORY_DEACCESS DIRECTORY_ACCESS   KER$CREATE_EVENT  KER$CREATE_SEMAPHORE  
KER$DELETE  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_BITMAP  ALLOCA    TE_MESSAGE  ALLOCATE_STRUCTURE  CHECK_PROTECTION  CHECKSUM  CREATE_MAP_PTR  DEALLOCATE_MESSAGE  DEALLOCATE_STRUCTURE  FIND_FCB  GET_MAP_PTR  INIT_FCB  	INS_QUEUE  LOCK  
MATCH_NAME  	READ_DISK  READ_HEADER  	REM_QUEUE  RESTORE_CONTEXT  SAVE_CONTEXT  SEARCH  TRUNCATE_HEADER  UNLOCK  UPDATE_HIGHWATER4   
WRITE_DISK  ZERO_WINDOWS  DIRECTORY_TYPE     P ^QR޼T޼U޼n}PPP}1 dТPPT &вТPPT &ТS<PC<                                                                                                                                                                                                                                                   g                        6L $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "                "P= ߢݢ 	REM_QUEUEPÜ ߭ 
KER$DELETEà ߭ 
KER$DELETEݢ DEALLOCATE_STRUCTURE&}PPP}}0&n ߢU 	REM_QUEUEUdP Pݢ 	INS_QUEUE   
     DIRECTORY_ACCESS     P^޼V޼Y޼[ZЦR LOCKݦ FIND_FCBPWЦ<nЦ8ԭRWRRSS &RRRSS߭ V READ_HEADERP
Џ   X1WZݭVPWWƀ Ц8n<Ю8 Wݦ [~ݦ CHECK_PROTECTIONPXX1 Џ XЭSFT5)4$dRRd<R    <R<R<RЏ 1 X߭߭ DEALLOCATE_MESSAGEXy&<R[	Џ 0 X`<"SSS"<RPЦR}G<"RR> &Z~Wݦ]Q' ߭W 	REM_QUEUEPR ݦݭ 	INS_QUEUEPRЦR UNLOCKXP v  P ^ ޼T޼n~ ALLOCATE_STRUCTUREPRޢޢRS<ФФ<4<XPPPXØ  Ü   KER$CREATE_SEMAPHOREà   KER$CREATE_EVENTP@¤ PRݮ INIT_FCBRP   
    DIRECTORY_DEACCESS     P޼R 1 % P  UNLOCK    % SТP LOCK<"QQQ"<P[ &D<"P>    	REM_QUEUEÜ   
KER$DELETEà   
KER$DELETE  DEALLOCATE_STRUCTURE Q PA QТP UNLOCK   
    DIRECTORY_SCAN    PϞ^޼޼X޼Z޼0޼$ԮЮ0(޼Rb[[޼RbWW޼ RbԮШ ԭԭ ЮR SУPRѮ(RR(RR$$,UURR*oR%jjf &aî$,TTƮ$TЮR SDä RR   Dä UЮSÀ RPRѮ,R֮,Ǯ$(SЮTĀ RC¤ U֮(ЮS    À RP,Ѯ(0
[W|5ШЮ(RR,1_R(޼Yխpߨ< ~ ALLOCATE_MESSAGEPЮSÀ R(@TУRRTЭ 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSSЮRSHԮ1Э[Э[Э[2kRR142kT[TSSS   RSR RUUP   TUTЮRЏ 1 HԮ1@2RR 3ծUSЮTRRR-S R1OUR-R 571<nj Uj3RRUVЪT-U Vd 4-U Vd %WnSRݪ2~RS 
MATCH_NAMEP n1 1     WR[STTS TRRSWծTR-R 57 *TSЮTRRR-S R*<*R(W1 ѮU1 WPji\UNU` jj2T<*RRRTR	U?<gSTS<jRU-U)TS	UPW֮<*RRR*W1lUU1 W[SRRS RRRSW[Ю[W[RRRW2kRR1ծ^ЮSRR5P 5P5ЮR(57ЮR T &)(QyPP{$PRRR$RR
Ǯ$(R7BĤ Ԯխ
߭߭ DEALLOCATE_MESSAGEЭШ[ԭWԮѮ?,(1 1 W1     ծЮ[qԮ׮(խ
ߨ߭ DEALLOCATE_MESSAGEЭRЭRԭԭRU2eRR7U[2kRURRTRTRS RRRSS[RRRTU2eRR2kR[RRW2RR CW<*RRR*׮-խ(ѭĨ!߭߭ DEALLOCATE_MESSAGEխ
߭߭8  DEALLOCATE_MESSAGE(hЮ [WЮЮ$ЮP  
  O	  <EMPTY_DIRECTORY	 O	  P<4^޼U޼SQС̰έа̭խ	<P׭ДTѭ}P>@c䟭 GET_MAP_PTR߭< ~ ALLOCATE_MESSAGEPЭRХPPЭR 	READ_DISKQ    ~Q߭ KER$ENTER_KERNEL_CONTEXT2bPRPR߭߭ DEALLOCATE_MESSAGERTTP   
  
  NEXT_DIR_REC  
  P ^޼U޼Vԭ2RRR2RR}fSŀ RSPW1 ߭< ~ ALLOCATE_MESSAGEPŀ R@fTХRRTЭ 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSS߭߭ DEALLOCATE_MESSAGESHWmЭP2`SSS    RRRP   SRSЏ 1 HWRQЦSRRRT-Q RTTWխ
߭߭ DEALLOCATE_MESSAGEWP   PϞ    ^Q\ZYLSЪ(R<@TTЪRRTS 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ8 88H[1j<i1L\<  Ъ(RiP	    é4é@ߩߩ DEALLOCATE_MESSAGELD$ S$S6$\RR`2bR\RR\2`RRR$$S4SS)\`SLR`R4@LR`R@iRSKթF\T2dRR0`L`&LS`S4@LR`R@iT`H< ~ ALLOCATE_MESSAGEPP`ROL`       TbQPSTW<VVWWV(VacVW   R, n R``1 L\LTS SRRSS( dP@LX@   R, n Rhh PX@Pn@RR QhSRW<VVWWV(VacVWPX   R, n Rhh@RRL@RRRRP@S@RSR	i@PS(<TЪRRTS 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ8 88H[1 0 sЪ(R<P
\Qϒ HP DEALLOCATE_MESSAGELS(<T0TЪRRT    S 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ8 8
8H[( s 0[Ъ(R<P	\Q[[P   P ^QT ޼nRTPS<
PnPP
 T INIT_FCB PD PݠDT UPDATE_HIGHWATERТP Q PA QT CHECKSUMTQТ<SТPPSQ 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXT  
    SHUFFLE_DIR   PǞ^ЬЬ޼ZWXЧ0V(f(l SAVE_CONTEXTǀ ( 0Ч0R(Ǯ     |LT(  READ_HEADERP88, RESTORE_CONTEXTЧ0R(fЧ0R(l8HY1sZ1bЧ(UPRRD1 sЧ(RТDTTSSSRRTR,T   Џ  81 ,   < ,Ч0RЧ0R,(,ݧ0ݧ@ݧ ALLOCATE_BITMAPP88Џ 5 81Х@(0D< ~ ALLOCATE_MESSAGEPLLtЧ(RТPRR*R<H]Q P1 H	ЧH81T<TR|~R ݧ0ݧ TRUNCATE_HEADER:TTTSR>BcXSRRSSS, n SX XT(, CREA    TE_MAP_PTRݧ( ZERO_WINDOWS1HԨШSЧ(R@hTTЧRxR|TS 
WRITE_DISKSx~S߭ KER$ENTER_KERNEL_CONTEXTЭ881D< ~ ALLOCATE_MESSAGEPLhRЧ(VЦPURU1 R<LSЧ(R<@TTЧRRTS 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ881LSЧ(R<@TTЧRRTS 
WRITE_DISKS~S߭  KER$ENTER_KERNEL_CONTEXTЭ8L881 U<MLDL DEALLOCATE_MESSAGEZ]Q    Z1 ШSЧ(R@hTTЧRRTS 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ8Ш88;4ը@Ш2RRRR8Tߧ8T DEALLOCATE_MESSAGE RESTORE_CONTEXTЧ0R(fЧ0R(lLLLDL DEALLOCATE_MESSAGEPLHP DEALLOCATE_MESSAGE8Y8HYYP  
  (  TRAVERSE_DIR  (  PϞ^޼X޼Z^Ш0Rj	<+~ ALLOCATE_STRUCTUREPȄ     SSШ0RR$j
j	SRRR~ݨ0X'P[[1X8j1 j1 %1RRSRRVSV<YY^(S4n(V8VV V(Vn V RRRVR(R DIRECTORY_TYPEcHݨ0X SEARCHP[ HШH[1"[
Џ   [1Ш0R(Ш0RԢȄ Rߢߢ DEALLOCATE_MESSAGEXd1 1 YYRRj1 IKRRSIPRSVV V(Vb V RRRVR(R  DIRECTORY_TYPEcHY" ݨ0X SEARCHP[ݨ0X S     EARCHP[ HШH[A[	Џ   [5Ш0R(Ш0RԢȄ Rߢߢ DEALLOCATE_MESSAGEXτY(Ш0R[P       $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                               1       @ߓ V4.2-01                         8     DISKHANDV4.2-0110-OCT-1990 21:01                   VAXELN PASCAL V4.2_95 
  e
 W 
      e    T4$DAP$KERNELkHFLSDEFFLSENTRY
DISK_CLOSE DISK_PUT DISK_GET DISK_DIROPEN 	DISK_OPEN DISK_HANDLER     
KER$SIGNAL  
DAP$SERVER  KER$ENTER_KERNEL_CONTEXT  
CLOSE_DISK  DEALLOCATE_STRUCTURE  	INS_QUEUE  LOCK  	OPEN_DISK  	READ_DISK  UNLOCK  
WRITE_DISK       P  
      |DIS    K_HANDLER Z|^ЬVVUŜ 0 ԭ+ԭCԭԭ~ԭV ߭|~|~|~ ߭߭|~߭ ߭ 
DAP$SERVER%aХSXð RRRR LOCKХRR 
CLOSE_DISKR~R߭ KER$ENTER_KERNEL_CONTEXT<PPPʏ   Ä % UNLOCKХT$~RRV 	INS_QUEUEPݤ   
KER$SIGNALV DEALLOCATE_STRUCTURE  
    	DISK_OPENy   P^޼ЬxPPSУR,
Џ ! T1  LOCK 
 
Џ 0 T1  @      nУPPn                                                                                                                                                                                                                                                   h                          $      ELN042.D                       V  
  "[SYSEXE.SEAS$WORK_0000005C]FILL.\Q-:BmPOiE;1                                                                                 I    R                        Z 0     D       ܂7ZF 0X%	ir٘'X5b,^GRv
apۨ{`C'9m\W"7"iD[TLg2&ZԻY
(Xf]oVY1N2¨jCg@hV0_1Q\x\W< i	j cÑr#
[&BTɅ}pqL0UlaW4~݆V۴`/@qs0 gB ,ރm \p%^鞘&j#eDe'CH&Vrl.$j28ҚnPf~srE(1A])Hz,:]G8՞MUQ\¤GF[7oaPdfaXl[f]^Z!%3E#Sqm36,{SJ*BXAgVΣ,;Dͮ2xn_ .Aa5Xfr 2pƆiЖ#W \nMeK;/ğz #t{9#HAs&?8yd7-i§
@hmR1L
eO[}Smɬj}%KRZhjiٴ^:]zA'Go8/PEEtZ=e=ߕN6=Yk=xA_BGTX",DVɤ	E+#jSPMf.
g	<dE63Gn<M.F"XR&edEڟŬڀP*ڹ2M#SpE⊼9ʆ{{B$LqoÂc[zVEgjVtXG^=r?<
-_R\SXBz!6Iy~N2*A
uR|8ո.>^2(qnK*sgG9AmT}x@(f_ȍ~dS{Ϣ48&X:L2S	irJ 3vZxRy1MTe~N}},h?z+y26thN+~bY<^9aw]ߜKi_+Om2qp
R]T/
ģ?Ǚh8lAAoeKRHB|c`1!IWY&}	bmRw	#0| V2u?|B'vtH,۶.Z'u6Iv
f)!!;odXy,0?eZmtf&g )t1o5xd.bއզPN]@% y|·F6Xy^qm|N" ?P<ġ.܉	2*nhBp z!*b1ƜŎN[*x_uz2s\Ei@D\K5J,7O5ҿ	GO*K~n7-i~(1sd![SonT_,i6(G͞AwnJoF5~G--w>d葷#wqH%X8	~8Aqf )HK}9SH$U!\<ۆJ0t̬+ϡb+L-RMBT0c8U{~aVo `ͰZF1ڀpa	`)vBT
E(G~Pi8saK!´D0XqVSɓL̳C#s;!0p	"X0	fvhk҃
}~n5t_.k,VVsA;iJq:;(<䲰		Y<lgѦu3KN0!⡿~$H2vVwƢWA?봔 Nf7u+]`D;*W.1$εm{j1d<yZ7"jbi]Y{Ȇ/~3ggJuWXH`&p78)g8d!p2`Uɸ{EX*nN~
;~2D5c|GC+s	Nu 5-3n|d]/8f}jsĊ~}VV2f[eWn)dǉz`s4[W`|8a+7jYGf!SH4Vu-ؼݖf%ſfDM1NRT=JIP߶<_<Qlk!\g9L%\36x7g3&28HII?QZ<cyr2mL¸gǸ`LY2N>݁zE^t:eQ>8U6YJ
o %)d>cأ$]Gl#!u!Q P2u#' Jc5iR-gXP+Xe690 힑Mik%7M.Ĕ@ʂV3VUbBcgk/?acWD	*̟&Br6kNT;kK$C&![>>~_6®Y~OpwDbt:9.怅6qGF^<MtAHúUn
p4O&هHQ_s{^*2|U7T{
Y.lWsOxgD>`ҐtH
'FŨWvtH͕cTqPD}Pp#J|F1$-YhS1$ŝڕ:,^X[Qr6wPɪTCoq.a+1$5zǡ۵ԍ؍0OM 6ዲ	}|+EY4
Sj<E.JNP-Ps
b7gE2HǴJi7 ^gM.ӡ/qEѤ-\v`52ZL'KhXW{-ϸ_èW%
?Fn0<CH;=
(V#PTyʕSR0J

Z֚\
|ʷ(kc8
s-1;.u`NN|Z@?_P0N3B	q^j~;me-`7c:mHC&(jI81I9&m#dAUgD	nT(cMr3M$UYMȫYZx~HCz#e AAA0I5<
Eu[UHfj'~gXحl\0,j8<UG*XS17#CMUrn(hA6
z8a`jÎ˅U|UV:R1s΅gV{|ʠ-WK{,[pVψ69~^s?lˣd5F)n19Kn2RYz:X8)E5=`w2qݓ;%{Aik:A6Lknc(K<S^śݎ%]\ݛIk`ˍ<+ATks&%s[䍛+wL< B&uq ]QAo(S
891˷eXn֟;Dub[C;vLմ(ԇs317z
^u	M
<^jPѠfx[26W# N±y[,ixG]"LNqAҜ|>ͣ@cqH2d]w$#O&c*eO9Be|/^SB|d4Fxo+ǬʪL+)JR?bg-1^yȩlY :ēW
x"0JUDFe1ԆnP~_av_ݝ&p{rͭs;yϐWkYi}4ԅIb0Z|%?tЋ!rI%sy[Q('C*zKiH[Rq])S3
UbWح։<Vs7"XhtEmʙEJ|禲gk2zۤGw
w{MjHb?o&P#Tً$B
cB8՜s?_a4 Ba# EzLoQInZq]
cJHґ2$[PB౸L֦^>6(
+[pcNgFW0@FQ΋s&
v+q¼MϦ&ÚoӘCk'KְQ1]~GiiҤ&T*3cy~-yѧF]ڣ Hxr(Iܲ6Zv6Jgu<J:YKinuz/	|J
ȩ.x[=/a}$Z1SS&>,[S`!Q2U,=~{[<[G3Fs5*!A|p2%XmIC=;RwA!-#zIXp\ (ybZ_$MK#ȆJZVU`0_mNNP*AγT6 8CHw yt~s0/'!QI@QX|tXЙqG1^SXq[å%nS}ݰj`4ZR/b}4zD(!DwǛ
D'%Ug}v>!FRµ?!W*ж6ԥl[ȣ} Nvl/ "'n~K˾ר`g-OrW&XU};F_*Rf	j\l"K@uJ}7tz$"?x}yR
qjus
u!82`@q7im;gNg:kh2o;e푗m"sy=
+490xPOXmAsOWƒ{c;䶢ig\ͱ0/g#)~IpM4U㤖ۣdMEKeNnlǥ7( h{,7z+̓6'Jꇍfr"m?!>Tcwb3f]Z>j޽zNqKv%KvC*fBe捚%=Q@L"}֏r]H[B
	״:FHK}5SNFk)xn]mNnv{fa?Rvm:F(b!qsA\M<nx3RzTƍ_Md@΁ģxAAfuaN
EA<6ѥ<qO8GQDɂ=Dɡ'5:Os#plnha }#'!zq%R;ExreFfVͰW.WL^#8
4/{0
jԬK@iKE:,ou(sqxh:}MyBmws**(SUzd wOܵ
 zǮעB<cVɃN GQfyh,%#(m"|w1,gdG
EF2#Cp-- 摍soXd[yePE=	T؉?,9#yx55_-Nyѧ*Ŵt	!0VM.hOC:ސƆRH~Lc+c.؏>Z
'?%XY藅=5"C	;S!li&j%	uwZtej:,־`ݾ;hL[~/};F͙
mx`fUi~ldՆ1E2ЁRF186pWw){/;$g86
LqhHĭv0s%)v}mz\Q)"-YE  JXθ*^WBiiJ7f	݋ـTW21+A7+)V
ߥy gM<Y~t/ON4G>Q;or@r(b1ަS$ɐ]Ői@PwAN6/:5&o@8eiQ"d{iɴ?iV}0w<~΃V\Q'Դȵc%'s":+jCuW+_Al20TC[q6l	
ʐݗv%okDmR;ƪvFg7A۰TLL@~(x~wITamI7Z:0
Ce=`\fv_3š1?}g]Haq:.O9Ľ>TdZė}{œW8Yڒ7K˽G}.ш9(ә>oag/sTkA.ѶsвE_ÍGVU0sW?KWHhN}\rҶ椵RRK[(FY@ xEI LrtĆq=,niMOO&kLyut@]'h2*\v
>X@]~%,:=σA؏E.mܗCr?q<MxMMmnMe8(@NPJ[Y%|wD{ZPΓ~ هL2 uڰe隋f*QJ';(MC|׏F(O@{/tD)F%"1#"_ZG -(yď)<~slBv;8".ژ}QU9X7"˺K^o}2"w-8^}Q4;/T]l%3jj.&
X01dhfq!^G>gF:K0:i$Y01AtT&0h;a=kG ,/gv\4-%,~0ؔK]_Ns6:}cZ,|Q{W׷Jb'7&+'>Z8n[&yYPוl"lǠ~c2.r U^dvU]6d.hm^K30qz,}nIvdM٫-B@dt?rfjd,`zQ%ǡzOv286K)jŲNF<0t aA?ԥçp&P:sH<o#^?H(7b C,[MJU01C<B-4{L82N
͍jA;̌$pP626nPi$R8 Z2Fi҉`6 HzôdYEw\}ub)3kkv	h&}=*yM,K ahYOe bm<܋_~4xUAl;qpŊ
׈*
ze{!Ԣ֒;4tTMITٺr٢Ҿ읎2hHf5WW=;vMFm2TiHנe>o:'fLr.nYqѷa uD$'p
':<DaAԌՈp9]p)NT-)7Q5{<C-6v^>>,#,Tڝ%[ͦ,ɏ1̝2yq㘒CH*bLOn,7|rH"JdtX: G4wbUBZ-21tY˲6mO7m#EE+0TZ:-%5;
jPeڹR!uxn`L.{-$_#Nu¹	ВE>Ś1QӽPQ(yr e]|^~yJ)k#vWXt;Z`~hALԈ(s=1uL5OxrЪ=-p%D1+ :D)ߤgն3)ie	:dUv FÚ&`+ݘRۑc{t!z׵eע/켔
Ukf	Vg*|FAphpL~ GO Hc@q,+u;M2e1k'H^M/ 
40	U1?Ex<83H3Ƃ&Nu#Ti;'CPX 4o+HyŜ!d>.*'>~7Y\                                                                                                                                                                                                                                                   i                        td $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        u "                 	OPEN_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭTT1 <PPP%ȏ   } ( Q PPQ< PPQ QQ ˏPУ0P У0P 	Џ t TC PP   0ưR<RP	Џ J T!P
0Rм0ԼԼ$P  UNLOCKTP   
  K  <DISK_DIROPEN *  K  P<^޼Rb(bЏ ! P  
  l  DISK_GET  ^޼W޼VЬPPSW#W	Џ W Uu<RRVQǏ   RTQT< RVTR R}P`PRмQǏ   RnУPPTnQ 	READ_DISKQ~    Q߭ KER$ENTER_KERNEL_CONTEXTЭUUP  
    DISK_PUT     P$^޼W޼V޼޼ЬPPRТUТ0P 	Џ , Tuń 	Џ t TfW!W	Џ W TSVQ<RPxPPQPSVSǏ   nТPPSnЮ 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭTTP   
    
DISK_CLOSE     P^ЬPPSУRX° PPPP LOCKУPP 
CLOSE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭn<PPP%  UNLOCKnP     )  $CODE     $DATA              w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ߓ  THISSELL    DISKHAND  sߓ  THISSELL    DISPLAY ߓ  THISSELL    ENTER  .gߓ  THISSELL    ERASE 9ߓ  THISSELL    EXTEND  xߓ  THISSELL    FCBSUBS! `Fߓ  THISSELL    FILEHAND! ħߓ  THISSELL    FILEINIT! `rߓ  THISSELL    FILESERV ઇߓ  THISSELL    FLUSH `Glߓ  THISSELL    GET Hߓ  THISSELL    HEADER `3ߓ  THISSELL    MAPPTR `ߓ  THISSELL    MAPVBN %ߓ  TH	    1       섘ߓ V4.2-00                         7     DISPLAYV4.2-0010-OCT-1990 21:02                    VAXELN PASCAL V4.2_95 
  e
 6    A  e    T4$DAPkHFLSDEFFLSENTRYDISPLAY_ACTION  l   
FLUSH_BUFFERS  LOCK  RETURN_ATTRIBUTES  RETURN_CHARACTERISTICS  RETURN_FILESPEC  UNLOCK      P  
      <DISPLAY_ACTION <ЬhTTSУ(R  LOCKzz! T 
FLUSH_BUFFERSPUU  UNLOCK1 ߼߼߼T RETURN_ATTRIBUTESУP      T߼d߼`߼\XTPL߼D߼@߼<߼8߼4߼0߼,߼(߼$߼ ߼ RETURN_CHARACTERISTICS  UNLOCKЬHP`T RETURN_FILESPECЏ UUP        $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                             1       @ߓ V4.2-03                         5     ENTERV4.2-0310-OCT-1990 21:02                    VAXELN PASCAL V4.2_95 
  e
     q  e    T4$DAPO t$DAPPARSEDEF$KERNELDAAF11DEFkHFLSDEFFLSENTRY
MAKE_ENTRY ENTER        P .DIR(  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_MESSAGE  BUGCHECK  DIRECTORY_SCAN  NEXT_DIR_REC  
PARSE_NAME  	READ_DISK  REMOVE  RESTORE_DIR  SAVE_DIR  SHUFFLE_DIR  
WRITE_DISK   SS$_TOOMANYVER       FLS$K_BADPARAM   FLS$K_BADFILENAME  DIRECTORY_TYPE 
     ENTERϞ^޼[޼Y޼^ЫxS<Rݏ FLS$K_BADPARAM BUGCHECK1 %.S<DRR R(H1 fSRRSTRRVSVZ<ZXX^(S4nR(V8ZVV V(VnV RRRVR(R DIRECTORY_TYPEcKRSCKRRTUCPRTVV V(VbV RRRVR(R DIRECTORY_TYPEc 
PARSE_NAMEP	H1ݏ FLS$K_BADFILENAME     BUGCHECK1kSR
TccR $sSibЩ,ЩR(ː ЩRS($<RRVЩRVVTU9T2TURUUU0UUV(ЫR Y[Ϻ P1 <*RSRSRSHY[ NEXT_DIR_REC2RRRѩRPR HЫHWR(4ЩSˀ R@iTTЫRRTS 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭЫR P  
    
MAKE_ENTRY    PϞ^޼Y޼V޼Z޼Ԯ     2RRզ	ЮR(4UЦզwfUfզߦ< ~ ALLOCATE_MESSAGEPЦSɀ R@fTTЩRRTS 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ1AЦЦ2RRRRUЦզ1*[HæRR   R[RVY SHUFFLE_DIRP
 HЩH12RR;ɀ TPUUU &&fQyPP{UPRRRURRfRUR7BĤ [næRQ SRX<WWXXW(WacWX[RRЮS<4S	ɀ R<NSS <SЦRSS(ЦRЦS2    RRSЦR, SծЦRЮSC[[1j32S<RSR&<RR  Џ q HЏ q 1RRH<(RR  1[fWЦXj V SAVE_DIRPɈ fRݏR ZɄ Y	 DIRECTORY_SCANP1 <*SS<(RSR1 ,SЦRSƇ P Ƈ PƇ (Ƈ Ɖ ЦR(ɐ $RfWRSѦXSRRRSRR~Ʉ Y REMOVEP/ЩH1 HЩH1*(ݏ SS$_TOOMANYVER BUGCHECKԮ1[و VY RESTORE_DIR   R¦RR1ЦS2cRRRTѦ1      f1 RRѦR1 2dRR1 R-R 571 fЦSfTɀ R@TЩRRTS 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭ1 Ц2RRЦ2RRRЦ   R¦RR8VY SHUFFLE_DIRP( H#ЩHvVY SHUFFLE_DIRP HЩHZ2RRRæRQSRX<WWXXW(WacWX$2RRЦRЮS(Џ ЮP      $CODE     $DATA        w w                                                           1        dߓ V4.2-03                         5     ERASEV4.2-0310-OCT-1990 21:02                    VAXELN PASCAL V4.2_95 
  e
 a4      e    T4$DAPO t$DAPPARSEDEF$KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRYDELETE_FFILE MARKDEL_FCB MARK_DELETE 
ERASE_FILE ERASE_ACTION   DAP$PARSE_FILESPEC  KER$ENTER_KERNEL_CONTEXT  BUGCHECK  CHECK_PROTECTION  CHECKSUM  DEALLOCATE_MESSAGE  DEALLOCATE_STRUCTURE  
DELETE_EXTFCB  EMP    TY_DIRECTORY  FIND_FCB  LOCK  NEXT_HEADER  	READ_DISK  READ_HEADER  	REM_QUEUE  RETURN_FILESPEC  SEARCH  SEND_BADSCAN  TRAVERSE_DIR  TRUNCATE_HEADER  UNLOCK  
WRITE_DISK   FLS$K_BADFILEID       P  
      ERASE_ACTION ^޼Rb(bЬWWR  SRSSTФUŃ 
ń 
Џ  V1 $|~x DAP$PARSE_FILESPECPVVqń 	Џ t V]ݤxW TRAVERSE_DIRPVVIWGPVV=ФxSĄ R,ЬRbW RETURN_FILESPECդ4Ф4R    5RR
ߤ8ߤ4 DEALLOCATE_MESSAGEVP  
     |
ERASE_FILE <    P|^޼VHЦxS<DRR (Hݦ0V SEARCHPTT H.ƀ %ƀ R  UNLOCKÊ% H1 ЦHT1 զ(Ц(SЦ0R(*Ԧ,Ц0Rݦ FIND_FCBP(Ц(R  LOCK%RRR~ݦ0V5PTTƀ R  UNLOCK%զ(Ц(R  UNLOCKԦ(TP  
    <MARK_DELETE   P< ^޼R޼U޼nn1Q߭ R READ_HEADERP@$Џ T15<QТP PQ    PP
Џ U T1բ(6Т(P< PIPբ,PPQQТ,P PPPQQ'Џ 0 T1 ݭ ݢ ݢ CHECK_PROTECTIONPTT1 ЭP5PR EMPTY_DIRECTORYP
Џ  T1 @$ЭS5H ݢ(ݢ(ݢϧ PSURP^ТHT_S CHECKSUMТ<QТPPQS 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭTS4Т(PS0Т(PТ88TЏ TT U T 0 	T  խ
ߢ8߭  DEALLOCATE_MESSAGETP   
    MARKDEL_FCB    P^޼RЬЭSխd LOCKވ    & &&}PPP}<P UNLOCKT2 ߭ݭ 	REM_QUEUEݭ 
DELETE_EXTFCB UNLOCKݭ DEALLOCATE_STRUCTURETTP   
    DELETE_FFILE    PϞ^޼V޼޼nnR51:RnS<R<Rn CHECKSUMnR SEND_BADSCAN[1n1ЭTTR<W
SxSSSWЦ<SЦRRST 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSS	SH[19|~Tݮݦ TRUNCATE_HEADER<ZZ(ЦSWWLRWRݏ FLS$K_BADFILEID                                                                                                                                                                                                                                                   j                        ,\ $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "                  BUGCHECK1 X Yh LOCKٚNRRWFУPRDWUSUR 	READ_DISKT~T߭ KER$ENTER_KERNEL_CONTEXTՐWNNì Nì xXXXY YPУPRDWԼ SWR 
WRITE_DISKT~T߭ KER$ENTER_KERNEL_CONTEXTУP쟣h UNLOCKߦ8߭ DEALLOCATE_MESSAGEZ|~V NEXT_HEADERP	 H[խ1pn4Ԧ4[[P    	  $CODE     $DATA         w w                                                                                               1        p8ߓ V4.2-01                         6     EXTENDV4.2-0110-OCT-1990 21:02                   VAXELN PASCAL V4.2_95 
  e
 /	      e    T4$DAP$KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRYEXTEND_INDEX EXTEND_FILE 
EXTEND_ACTION   KER$ENTER_KERNEL_CONTEXT  ALLOCATE_BITMAP  BUGCHECK  CHECKSUM  CREATE_MAP_PTR  DEALLOCATE_MESSAGE  
EXTEND_HEADER  FIND_FCB  GET_MAP_PTR  INIT_FCB  LOCK  NEXT_HEADER  READ_HEADER      RESTORE_CONTEXT  
RETURN_BITMAP  SAVE_CONTEXT  TURN_WINDOW  UNLOCK  UPDATE_HIGHWATER  
WRITE_DISK   FLS$K_ERRWRTIDX   FLS$K_ERREXTIDX   FLS$K_BADPARAM      P  
      |
EXTEND_ACTION(|^ЬVVRТ(SТ0TØ  LOCKУ04У88У0PQ#<P<P
PP Ԥ$м ݣ8ݣ0ݢ0VqPUТ40Т88URݢ4 CHECKSUMТ4nТ<QТPPQn 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭUU
ԣTЏ UØ  UNLOCK    UP  
     EXTEND_FILE    PϞ^޼U޼T޼n޼Х(W Ф Sݏ FLS$K_BADPARAM BUGCHECKX1nVRFS4<VVSVRSRRYяP   Y)zY YDǌ PYzХR<rYФ YV[nR4	 nSЮS1 P>@cĚ:QQP>@cRЭĭQݏ FLS$K_BADPARAM BUGCHECKX1ѭRЭĭ GET_MAP_PTRVѭRHS|~gU NEXT_HEADERPS<߭߭ DEALLOCATE_MESSAGEХ8WЧWݥ FIND_FCBP
Џ 0 X1y[ HХHX1hS1A    $Ѥ$Vݏ FLS$K_BADPARAM BUGCHECKX1DԤ V$ZЭY1ХPѠtY$߭߭YTݥ@ݥ ALLOCATE_BITMAPPЏ 5 X1Џ 5 X1ЭRR YPPRRQPQQYԭ)P
Pե@ЭR:PWЭĭ GET_MAP_PTRPP7:QíPPPQQ:ЭЭЭRbP<bQQЭĭЭRЭSS߭ݭ߭R CREATE_MAP_PTRP1 |S߭ݭ߭< @~ CREATE_MAP_PTRPÏ @  R @  +S߭ݭ߭< ~ CREATE_MAP_PTRPÏ   R   ݭݭݥ 
RETURN_BITMAP­ 1 Џ      X1 R ߭gTU 
EXTEND_HEADERPXXRݭݥ 
RETURN_BITMAP1 WЧWЭQP>@aЭĭS߭Q߭R CREATE_MAP_PTRPЏ  XRݭݥ 
RETURN_BITMAP^R [ +ZZԥ@(PPP(Y1ե,$Rݧ<Rݭݥ, TURN_WINDOWP,Џ X[1 ݭ CHECKSUMWWݭ INIT_FCBХ<ХЭЭЭ̭Э 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSХ<SXSXߥ8߭ DEALLOCATE_MESSAGEߥ4(U READ_HEADERPXaPX\դ W    4RR$ VVV S Х4SRR4Х4SRR4ե(Vݥ4 UPDATE_HIGHWATERХ(RVDXЭP   
    |EXTEND_INDEX    P|<^޼S޼УVS SAVE_CONTEXTf(У(P  LOCKУ(PР,У0PУ0Pߣ4( S READ_HEADERݣ4ݣ, TURN_WINDOWP,У,Q<R RR<PPRU< RRRU<&PPRRUUUîxQQ<pPPtRRRQQPRPUPTT  <RTRRQУ0PQ ݣ8ݣ4ݣ0SPݏ FLS$K_ERREXTIDX BUGCHECKУ4PQУ(PP̰     ̡
Ρݣ4 CHECKSUMУ4TУ<RУPPRT 
WRITE_DISKU~U߭ KER$ENTER_KERNEL_CONTEXTЭnУ4TЦ@RУPPRT ~U߭ KER$ENTER_KERNEL_CONTEXTЭRnRݏ FLS$K_ERRWRTIDX BUGCHECKݣ(ݣ4 INIT_FCBߣ8ߣ4 DEALLOCATE_MESSAGEУ(P  UNLOCKS RESTORE_CONTEXT       $CODE     $DATA         w w                                                                                                                               	    1       uߓ V4.2-00                         7     FCBSUBSV4.2-0010-OCT-1990 21:02                    VAXELN PASCAL V4.2_95 
  e
 |f"    y  e    DAAF11DEFkHFLSDEFFLSENTRYINIT_FCB FIND_FCB 
DELETE_EXTFCB 
CREATE_EXTFCB 
CREATE_FCB  ]   ALLOCATE_STRUCTURE  DEALLOCATE_STRUCTURE  GET_MAP_PTR  	INS_QUEUE  	REM_QUEUE       P  
      
CREATE_FCB | ^޼޼޼޼nЬS~ ALLOCATE_STRUCTUREPSSRޢޢ    <	    ЮЮ4n8SݮRP  
  i   
CREATE_EXTFCB  i   P^޼S޼޼T޼n ݣ8ݣ<ݮݣnPR$$R޳P PR 	INS_QUEUEУQ<PPPnУ(PD<У(PDDУ(P<DQУ0P Q<RP  
     
DELETE_EXTFCBq     P^޼TФԤխ6 ߭ݭ 	REM_QUEUEЭRТQ<PPPТSR DEALLOCATE_STRUCTURES   
  E  <FIND_FCB F  E  P<޼UeTeRTR&޼STR(c*,
dTeRTRTTP  
    INIT_FCB  ^޼W޼V((     .Ч<H@LSNУPRզP	<RצP:RWS>Cg:RRS>CgR GET_MAP_PTRЭDԦ@4Э@ѭR GET_MAP_PTRDѭRѦPDЦDP    (  $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                         1       ߓ V4.2-00                         8     FILEHANDV4.2-0010-OCT-1990 21:02                   VAXELN PASCAL V4.2_95 
  e
 'N    ^  e    T4$DAPO t$DAPPARSEDEF$KERNELkHFLSDEFFLSENTRYFILE_HANDLER   KER$EXIT  
KER$SIGNAL  KER$SET_PROCESS_PRIORITY  KER$CURRENT_PROCESS  
DAP$SERVER  KER$GET_USER  CLEANUP  DEALLOCATE_STRUCTURE  	INS_QUEUE  OPEN_ACTION  
RENAME_ACTION  DIR_OPEN  DIR_LIST  ERASE_ACTION  
GET_ACTIO    N  
PUT_ACTION  FIND_ACTION  
UPDATE_ACTION  
REWIND_ACTION  TRUNCATE_ACTION  FLUSH_ACTION  
EXTEND_ACTION  DISPLAY_ACTION  CLOSE_ACTION  PAS$DISPOSE2  PAS$NEW2       P  
      FILE_HANDLER ΀^ЬXXW߭  KER$CURRENT_PROCESS Tǜ 0<~ PAS$NEW2PtЧtV, n t ffxЧxR<ЧxR @, n t tt|Ч|R<Ч|R@ߧ  ߭ KER$GET_USER OPEN_ACTIONԭ 
RENAME_ACTIONԭ DIR_OPENԭ DIR_LISTԭ ERASE_ACTION     
GET_ACTIONԭ 
PUT_ACTIONԭ FIND_ACTIONԭ 
UPDATE_ACTIONԭ 
REWIND_ACTIONԭ TRUNCATE_ACTIONԭ FLUSH_ACTIONԭ 
EXTEND_ACTIONԭ DISPLAY_ACTIONԭ CLOSE_ACTIONԭX ߭߭ ?߭߭߭߭߭߭߭߭߭߭߭߭߭ 
DAP$SERVER	ݭ  KER$SET_PROCESS_PRIORITYȘ %Ș  CLEANUPȘ Rݢt PAS$DISPOSE2Ș  DEALLOCATE_STRUCTUREX CLEANUPݨt PAS$DISPOSE2ЧS%~RRX 	INS_QUEUEPݣ   
KER$SIGNAL     	X DEALLOCATE_STRUCTURE  KER$EXIT       $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                            1       @>ߓ V2.0-00                         8     FILEINITV2.0-0010-OCT-1990 21:02                   VAXELN PASCAL V4.2_95 
  e
 p!    F  e    T4$DAPkHFLSDEFFLSENTRYELN$FILE_INITIALIZE    ALLOCATE_STRUCTURE      P   
       ELN$FILE_INITIALIZE5  
 ALLOCATE_STRUCTUREмммм     "   $CODE     $DATA         w w                                                                                                                 1        eߓ V4.2-05                         8     FILESERVV4.2-0510-OCT-1990 21:02                   VAXELN PASCAL V4.2_95 
  e
 Ry
      e    $;$DDA_UTILITYS*ǥ$$DSKDEFT4$DAP멸$ELNMSG$KERNELE,
$KERNELMSG$STACK_UTILITYkHFLSDEFFLSENTRYELN$FILE_SERVICE  Q      P$ACCESS$COMMANDDISK$DEFAULT_VOLUMEDISK$                                  KER$EXIT  KER$RECEIVE  KER$SET_PROCESS_PRIORITY  KER$CREATE_PROCESS  KER$ACCEPT_CIRCUI                                                                                                                                                                                                                                                   k                        5MA $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        L "                T  KER$WAIT_ANY  ELN$PROGRAM_ARGUMENT  ELN$PROGRAM_ARGUMENT_COUNT  KER$CREATE_EVENT  KER$CREATE_SEMAPHORE  KER$CREATE_PORT  KER$CREATE_NAME  
KER$SIGNAL  KER$CLEAR_EVENT  KER$DISCONNECT_CIRCUIT  KER$SEND  
KER$DELETE  KER$ENTER_KERNEL_CONTEXT  KER$GET_USER  ELN$ALLOCATE_STACK  ALLOCATE_STRUCTURE  CHECK_PROTECTION  DEALLOCATE_STRUCTURE   DISK_HANDLER  ENTER_USER_CONTEXT  FILE_HANDLER  IO_READ  LOCK  MOUNT  
MOUNT_MESSAGE  	REM_    QUEUE  
REMOVE_VCB  UNLOCK  ELN$LOG_VOLCHANGE  PAS$DISPOSE2  PAS$HANDLER  PAS$GOTO  PAS$NEW2  OTS$CVT_TI_L   0^޼޼޼޼޼nЮЮЮЮnޯQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭP    P|^޼R޼U޼T޼S޼nn + HТ,QǏ   TPx	PPݢ(PSUޱP`PV#Т,QǏ   TPx	PPݢ(PSUޱP`PVVP  
  	   ELN$FILE_SERVICE   ^޼޼޼nЬP`ЮЮnQ~Q ENTER_USER_CONTEXT I  P^Q\    WZ    Ya H32R,  R LOCK\Q1ЏrSZ1ЏSZ1 ̀ KER$GET_USER 1QS|~S CHECK_PROTECTIONP 19Ô Ô  
KER$DELETER 1 Vƴ TTS2Ʋ URR@   RUTSTSHЧHXXDD!!!(!ƴ #Ʋ !!!(!ƴ #2Ʋ RRXRRggg(gHƳ  2g OTS$CVT_TI_LЭL<RƘ !ݧLR ݦ0A~	 ELN$LOG_VOLCHANGEƄ  
    REMOVE_VCBЏrSZ  
KER$DELETEЏzSZSSZilǏ   SR RRRS  SiQƏ   S SSRTSS
SS   TRxRR SRRi  SxSS SSSi|~̀  KER$SEND̀  KER$DISCONNECT_CIRCUIT̀  
KER$DELETE   P Q\Rݢ   KER$CLEAR_EVENT~RR 	REM_QUEUEPPݠ    
KER$SIGNALR
R IO_READ   KER$DISCONNECT_CIRCUIT  
KER$DEL    ETER DEALLOCATE_STRUCTURERX° 	R°    P<^QV޼޼Y1 XR:UȘ P
RR(.ᰭRRRR(RȘ T2TSSޭp߭Ȕ  KER$CREATE_NAME l|  aRSޭ p߭  KER$CREATE_NAME 5|  	ЏSY 
MOUNT_MESSAGER UNLOCK 1 <~ ALLOCATE_STRUCTUREPRY~p MOUNTP 3P p߭߭ KER$CREATE    _NAME+%R  ߭ 
KER$DELETER  DEALLOCATE_STRUCTURE O  PϞl^޼p޼l޼[^tݏp KER$CREATE_PORT޼WgS2SLާP pL KER$CREATE_NAME͐ KER$CREATE_PORTgX2X|<XVVt^nV(gf})|LfP ͐L KER$CREATE_NAME͠ KER$CREATE_PORTgX2Xx<XVVt^nV (gf(xLfP ͠L KER$CREATE_NAME~ ALLOCATE_STRUCTUREPRRVg²     (g´ Rp(R[,R  ߦ  KER$CREATE_SEMAPHORE ߦ   KER$CREATE_EVENTЫRբ$	Т$Rբ$$Y  ELN$PROGRAM_ARGUMENT_COUNTPXX1 Z޼WZ ELN$PROGRAM_ARGUMENT ( TR:T P<TRPRRV2TVVVR-R  g@Y2TRVR VRRRS,SF  R, i  XZZYRZRR~]QR UNLOCKl  
KER$SIGNAL|W͠ݧ ͐p  KER$WAIT_ANY    
 ˵ǰ &Rݢ |~  KER$WAIT_ANY]Q ϻR° `  KER$CREATE_PORT<~ ALLOCATE_STRUCTUREPVRpP<PRx	RL(`|~ `p  KER$ACCEPT_CIRCUITR R KER$CREATE_PROCESS|R R KER$CREATE_PROCESS(`  KER$DISCONNECT_CIRCUIT`  
KER$DELETE DEALLOCATE_STRUCTURE1
   KER$SET_PROCESS_PRIORITY11ǰ &Rݢ |~  KER$WAIT_ANY]Q ϧ    R°  ̀  KER$CREATE_PORT|~ ̀͐  KER$ACCEPT_CIRCUIT̀|~  KER$WAIT_ANY|~̀  KER$RECEIVE]Q Ϝ12]Q ;1'~ PAS$NEW2PSc  KER$CREATE_PORT|~ c͠  KER$ACCEPT_CIRCUIT RS R KER$CREATE_PROCESSc  KER$DISCONNECT_CIRCUITc  
KER$DELETE1
  KER$SET_PROCESS_PRIORITY1 6  P ^޼U Ǐ   U TǏ   U TT
TT   RxRR SRRS  TxTT     STTSSPQRЬPРТPP|  P|  	P|  ЏS<R PAS$GOTOP   P,^| PAS$HANDLERm޼X޼nޯ]h|~  KER$WAIT_ANY|~h߭߭߭  KER$RECEIVEѭ   ݭ  
KER$DELETE1 ЭRТWԢRVϦ    | zYЦ$[Ц4ZˏR Z   WRѭR
ЏSYYGݦZW[ݮϕPݭsP WЏSЏSЏSЭRЭ|~h~ݭ߭V KER$SEND1ݭ  
KER$DELETE|h߭ KER$DISCONNECT_CIRCUITh  
K     ER$DELETEX PAS$DISPOSE2P A
  P ^޼n < ~ ELN$ALLOCATE_STACKn DISK_HANDLERQ~Q ENTER_USER_CONTEXT  KER$EXITP 
  P ^޼nn FILE_HANDLERQ~Q ENTER_USER_CONTEXT  KER$EXITP    
  $CODE P   $DATA    H    w w                                                                                                                                                                                                           	    1       @$ߓ V4.2-01                         5     FLUSHV4.2-0110-OCT-1990 21:03                    VAXELN PASCAL V4.2_95 
  e
     {  e    T4$DAP$KERNELDAAF11DEFkHFLSDEFFLSENTRYSWITCH_BUFFERS 
FLUSH_BUFFERS FLUSH_ACTION  ~   KER$WAIT_ANY  KER$ENTER_KERNEL_CONTEXT  CHECKSUM  EXTEND_FILE  LOCK  UNLOCK  
WRITE_DISK  
WRITE_FILE      P  
      <FLUSH_ACTION  <^ЬTTSУ(R  LOCKТ04Т88zzTk    PUUVzݣ4 CHECKSUMУ4nУ<QУPPQn 
WRITE_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭUU
Џ UԢT  UNLOCKUP   
     
FLUSH_BUFFERS    P0^޼W޼n޼Ч(VЧ0YԮЧ4RТܰޭభܭn$Ц`TЦ\RRTRSTSS\ZZnZ<PUJ\UUU1sUDxRR RRЧ4R4RզDRR%RRRæDU ԩ$ݧ8ݧ4ݧ0W EXTEND_FILEP[Ч40Ч88PT[1BƄ TTS<ƈ RSSJ\ySUtJ\TRRTЧ4RRЭ䰭
    ƈ DJ\Ƅ Sx	SS<ƈ RSRTTJhXRRR<ƈ R	hXTTLR, n Rh֦TѦTP   Hݧ4 CHECKSUMЧ4TЧ<SЧRRST 
WRITE_DISKS~S߭   KER$ENTER_KERNEL_CONTEXTЭ[ԦTЭP<ƈ RצPZRRzݮZW 
WRITE_FILEP[ Rz[*n%ZSSSzZR RW 
WRITE_FILEP[ Sz[P  
    <SWITCH_BUFFERS v    P<^޼T޼nФ(RUdSSzn~ݢdTϡPUâddТdSC|PTݠ|~  KER$WAIT_ANYC|PUP    :  $CODE     $DATA              w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 1        :iߓ V4.2-02                         3     GETV4.2-0210-OCT-1990 21:03                    VAXELN PASCAL V4.2_95 
  e
 YJ    v  e    T4$DAP$KERNELDAAF11DEFkHFLSDEFFLSENTRY
UNLOCK_RECORD FIND_ACTION 
GET_ACTION g  
KER$SIGNAL  KER$CLEAR_EVENT  KER$WAIT_ANY  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_STRUCTURE  BUFFER_SETUP  BUGCHECK  CHECK_RECORD  DEALLOCATE_STRUCTURE  
FLUSH_BUFFERS  	INS_QUEUE  LOCK  MAP_VBN  N    EXT_FIXED_RECORD  
READ_AHEAD  	READ_DISK  	READ_FILE  	REM_QUEUE  SET_NEXT_RECORD  SWITCH_BUFFERS  UNLOCK       P  
      |
GET_ACTION Z |^޼޼޼޼޼$nЮR  VRVVRU߼߼߼~ ݮݮ$ݮ,R	3  
  X   |FIND_ACTION|^޼޼޼nЬVU|~|~ݮݮݮ$V	Ϟ^޼X޼,޼0޼4޼8Ш(nШ0$TURRUURRUTU#ݮ4X BUFFER_SETUP4TЏ ' 1
U81 Ѯ, Ю$SRѮ,Ѯ,Ю$SRЏ W                                                                                                                                                                                                                                                    l                        / $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "                1
TѮ,TѮ,Ѯ,Ю$SRRЏ : 1
Ѯ, ޼Rb
<RR   &Џ \ 1[
ծ0ծ,Ѯ,Џ > 1@
Ѯ,Ю$SRЮ0hfT	ը`TШ(`nR  LOCKШ(dТ04Т88Т0RRbWW8sЮ$SRR'Ѯ,!ШhP<fXW~?fߨhݮ<X NEXT_FIXED_RECORDѮ,9ШhP<fXW޼S<T<RRRTT   c޼RbhfUU T1 UU1 U1 nRѨh 1 Ѩh f unRѨhD~ТdRnSRz&RzѨhB\nRТdS<PRnTC\RѨhRLnR΢dSSRnTRz&Rz    ѨhC`nR΢dS<PRnTC`RѨhRUTЏ ' 1}T $1QЮ$SRR1A419U"U1,U1&Ѯ,ծ,	Ѯ,1ըpߨpݨ(Tծ01 ݮ0ݨ( CHECK_RECORDP1 6eШ(hnR  UNLOCKШ(l  |~  KER$WAIT_ANYШ(p    KER$CLEAR_EVENTШ(t  LOCKШ(xݮ0ݨ( CHECK_RECORDPЏ ^ 1
nRТ04Т88Ш(TĐ SĐ RSRѣ0cSĐ RSR. ALLOCATE_STRUCTUREЮ0 RP 	INS_QUEUEPЮ0pЏ ^ 1 
UU
Шh`fd޼    RШ`bd8,U#Ю$SRѮ,Ѯ,
 	RRUUUU1 nRТdSSzoѨ`C\<PRnVC\RѨ`RlX SWITCH_BUFFERSP1	nRТdSSzѨ`C\<PRnVC\RѨ`R0ݨ`X 	READ_FILEP1P	ݨ`X 	READ_FILEP17	nRТdTD\`Sx	SS<dR SRnSDh 8TѮ,Ѯ,/nRТdSSTTRnVRz<PRC\RD`R	X 
READ_AHEADЏ Ѯ,=Ю$SRT.lnRѨ` < < `hfU1Q1>UZ_ԮЮ$SRR M   1Ш(T<RRlѨ`D0`    Sx	SS<dRRSSx	DRSRUTЏ ' %UѮ,PhXfW~X SET_NEXT_RECORD1U11Ш(U R2RRR1 W&Wń RѨ`R<ň RѨ`ń ň dUTЏ ' 1e֨`dХdSѨ`C\<PRC\RѨ`R-X SWITCH_BUFFERSP1.ݨ`X 	READ_FILEP1ХdSC\`Rx	RCh 2 VǏ   VT`TRRń  Rń ,<dSx	TTTVRRS<ň RSRUTЏ ' 1 UV$ V}P`P Ԯ1 Х0RS<RVR,<dRVRRR   WШ0RRRRVR
Џ ; IV    TTl TSTSS<dRSRǏ   R`Rh 	RRf TUT$11UwШ(VƄ Sx	SS<ƈ RSRUѮ,d`Sx	SS<dRRSSUм$RUTTRRSTSSTTl<dRTRǏ   R`Rh 	RRfT1\l1V
(17
(10(Ш(V T1
ЦdSƄ C\<PRC\RƄ R <ƈ R6ЦdS<PRC\RƄ R"ZЦdRB\Ƅ Sx	SS<ƈ RRSîSYîLYYW, ,  ,,, TTS2WURR,UTSTS["[RR[RRЦdRBh \ZFYX SWITCH_BUFFERSPBΦdS<PRC`R~X 	READ_FILE    P#ЦdRBh Ԯ1T1UЏ ' 1\Ш(YЩdRB\ZЮЮ Tl1w1pɄ Z<PRZRɄ R<Ɉ R+<PRZRɄ RZɄ Sx	SS<Ɉ RRSîSVîLV(R*VS(RRKR:KSdP<SRPRR[8[TT1[VR[RdRRRR
T[VR[R[T[<lR [RRl1 1 dRSR
SS_<PRRZTRZݨ,X MAP_VBNPWШX<PUШЭWUЭ 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭШX1 <lRVRRlШXTԮ<lRVRRl    1<lS<dRRSSǏ   SR`Rh 	SRRf(RL<lSSSl@dRR
8<lSS/TXTh_<lRRRl[tRR
SSl<l1 14nSdRRzΣdRRRz X 
FLUSH_BUFFERSP1Ю$Ѯ,< Ə   м TЮTШ`U~TxW 	READ_DISKVTݮUݨ,X MAP_VBNPRTSSШЭĭRЮTWV߭ KER$ENTER_KERNEL_CONTEXTЭܮSUx	RRTSS1OЏ 1DU1 Ѯ$ ݮ}P`P Ԯ1м [Ю$ЮZîLRЮѭR    RЭЭY QkSYW<VVWWV(VacVWYZ1 Y[X SWITCH_BUFFERSP1 nR΢dS<PRnTC`R~X 	READ_FILEP1 nSУdRBhTZLШLYZYdQkSYW<VVWWV(VacVWYZTѮ,Ѯ,/nRТdSSTTRnURz<PRC\RD`R	X 
READ_AHEADЏ ըp
 0 ߨpݨ(Ш(nR  UNLOCKЮLLP  
    
UNLOCK_RECORD    P^޼R ЭQ PQP
ѡa PѭPݏ a  BUGCHECK ߭ݭ 	REM_QUEUEݭ DEALLOCATE_STRU     CTUREԼ    
KER$SIGNAL     `  $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                             1       Eߓ V4.2-01                         6     HEADERV4.2-0110-OCT-1990 21:03                   VAXELN PASCAL V4.2_95 
  e
 \      e    $KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRYUPDATE_HIGHWATER TRUNCATE_HEADER READ_HEADER NEXT_HEADER 
EXTEND_HEADER 
CREATE_HEADER CHECK_HEADER  V  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_MESSAGE  BUGCHECK  CHECKSUM  
CREATE_EXTFCB  DEALLOCATE_MESSAGE  EXTEND_INDEX  GET_MAP_PTR  IN    IT_FCB  LOCK  MAP_VBN  	READ_DISK  
RETURN_BITMAP  TURN_WINDOW  UNLOCK  
WRITE_DISK   FLS$K_FILESTRUCT   FLS$K_ERRWRTIDX   FLS$K_ERRRDIDX   FLS$K_ALLFHDNOTMAP      P  
      CHECK_HEADER  ^޼V(<RR  R  
Џ FLS$K_FILESTRUCTW1 fRR*UUf!RRUR:TRSURRSTS	Џ  WN5<R
R	Џ  W4V CHECKSUMPWW	Џ  W
Џ  WWP   
     
CREATE_HEADER    PϞδ^޼VЦ[HЦTT    h LOCKЦWNĬ aĬ NФPNnDnЦn 	READ_DISKS~S KER$ENTER_KERNEL_CONTEXTWФP ФDNRLXXRX1 RZĬ RZRRФPDZYЦY $( 	READ_DISKS~S, KER$ENTER_KERNEL_CONTEXT,WФP0WЦ<h UNLOCKWH1UU   EPUU   XZaWW1 ФPXEhR  bSxUPSPRRhxZRPRRSSWWxfZNZĬ ФP@DZXЦHLHPXTX@\ 
WRITE_DISKS    L~S` KER$ENTER_KERNEL_CONTEXT`SФPdS
SHWWЦph UNLOCKWRѦHЏ  H1"Rƌ kTR4XXD1 RV EXTEND_INDEXЦYiRxXݢV MAP_VBNPWߦ8< ~ ALLOCATE_MESSAGEP̀Ц͈͈͌͐W͔̀͘͜ 
WRITE_DISKS͌~S͠ KER$ENTER_KERNEL_CONTEXT͠Sߦ8 DEALLOCATE_MESSAGESSH1k޼RbXݤV MAP_VBNPYݏ FLS$K_ALLFHDNOTMAP BUGCHECK1,XP 1>XPXĄ d     VPݏ FLS$K_ERRRDIDX BUGCHECK1WSУ͸ͺ͸Xʹʹ
ͶݤDWNW CHECKSUMЦ<SЦR͸RͼSW 
WRITE_DISKS͸~S KER$ENTER_KERNEL_CONTEXTTЦ<Ы@ЦW~S KER$ENTER_KERNEL_CONTEXTSЫ@ߦ8 DEALLOCATE_MESSAGETSݏ FLS$K_ERRWRTIDX BUGCHECK1ߦ8< ~ ALLOCATE_MESSAGEP1Hߦ8< ~ ALLOCATE_MESSAGEP Ц(,(0    Y48 < 	READ_DISKX,~X@ KER$ENTER_KERNEL_CONTEXT@RR1 TЦRPRTYX\T` 
WRITE_DISKSP~Sd KER$ENTER_KERNEL_CONTEXTdWЦRtRxY|Tt~X߭ KER$ENTER_KERNEL_CONTEXTЭSWSߦ8 DEALLOCATE_MESSAGEWWHSH1 T1޼R
bTPW<bR4ЦЭYT 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXT1[W1UY<WЬR޼S<RRRW(cW   CHECKSUMЦ<Ц    ЭԭЭЭW 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSЦ<SSHߦ8 DEALLOCATE_MESSAGEͼͼP  
    
EXTEND_HEADER   P,^޼W޼RR(Rݼ INIT_FCBէ,Ч(SЬRݢ<ݣDݼݧ, TURN_WINDOWP,мR(Ч<VЧ8nWTPЧHX1мS<RR  
Џ  X1 (ܣݼ CHECKSUMмSЧRRVS 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭXߧ8߭ DEALLOCATE_MESSAGEn8мV(ܦ<R(Bǌ <R    RRԦ:4fS
SSR>BfSRRR   R, n Rc޼S.ЧR LOCKcR RVW 
CREATE_EXTFCBЧR UNLOCKXP  
    <NEXT_HEADER    P<^޼T޼nԭ޼P`SnU޼PS<PPU<cPP>޼PРRR߭bcT(PQQQHЭP<PPU
Џ  H ЭP   
    <READ_HEADERP<$^޼SУTԭ<޼PР4R@޼P<`Q4QPď  PPQdP߭QݠS MAP_VBNPR
Џ  U1 R<R1 ߣ8< ~ ALLOCATE_MESSAGEPУPPRЭ                                                                                                                                                                                                                                                    m                        ! $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "                	READ_DISKQ~Q߭ KER$ENTER_KERNEL_CONTEXTЭn޼P`ݭCPRЬP(ݭ/PRR
n
ЭUЏ  UԼխ
ߣ8߭ DEALLOCATE_MESSAGEUP  
  
  |TRUNCATE_HEADER  
  P|^޼U޼R޼T޼VQ>Ad:PPQ>AdS޼P2`V* GET_MAP_PTRVQV~QU 
RETURN_BITMAP PVP ѭS$ GET_MAP_PTRݭݭU 
RETURN_BITMAP ѭS   
  
  UPDATE_HIGHWATER -  
  P^޼R޼Sbnn(բL	SSL     
  $CODE     $DATA              w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	    1       1ߓ V4.2-00                         6     MAPPTRV4.2-0010-OCT-1990 21:03                   VAXELN PASCAL V4.2_95 
  e
 ?    R  e    DAAF11DEFkHFLSDEFFLSENTRYGET_MAP_PTR CREATE_MAP_PTR 7   BUGCHECK   FLS$K_MAPCNTZERO   FLS$K_ILLPTRCNT 6      P СR:TTS\\STSST:SSP  
  -   CREATE_MAP_PTR ^޼WЬЬW
ݏ FLS$K_MAPCNTZERO BUGCHECKЭX֭YW   X޼Vf  @ K]Q PY1 X޼S      c޼T WRR dS<RR dRfd1 ֭W @  A]Q *PY1 X޼R b޼S WRR  cRмchW   @P֭]Q PYMX޼R b޼S W<RR  cRcRмcݏ FLS$K_ILLPTRCNT BUGCHECKYYP   
  {  <GET_MAP_PTR  {  P<^޼SnУUeT
cԣT'ecУR УRT ecУRТT" e㰮УRccУRТ      $CODE     $DATA         w w       	    1        ߓ V4.2-01                         6     MAPVBNV4.2-0110-OCT-1990 21:03                   VAXELN PASCAL V4.2_95 
  e
 %ng    <  e    DAAF11DEFkHFLSDEFFLSENTRYMAP_VBN 8   DEALLOCATE_MESSAGE  READ_HEADER  TURN_WINDOW      P  
      MAP_VBN^޼U޼X޼Z޼nШWZDZY1FRէRRTTЧRSѢ<ZSSTT'ЧWRէRRSSЧPRѠ<ZRRSS޼[èZS QQ<PaS]PRRSQ<aPPSRRSSnkT+SV<aP     PSPTQR<aRRPPTRVnVkTRRRYYrԭW(Х(PР04Х<SХ8T߭g U READ_HEADERPRХ8S<T8R	RHY*ݧ<ZݭX TURN_WINDOWխ
߭߭ DEALLOCATE_MESSAGEYP    s  $CODE     $DATA         w w                                                                                                                                                                                                                                                             1        ߓ V4.2-03                         4     MISCV4.2-0310-OCT-1990 21:03                   VAXELN PASCAL V4.2_95 
  e
 
!
    % e    T4$DAP$KERNELkHFLSDEFFLSENTRYUNLOCK SET_NEXT_RECORD SAVE_DIR SAVE_CONTEXT RETURN_FILESPEC RESTORE_DIR RESTORE_CONTEXT 
REMOVE_VCB NEXT_FIXED_RECORD LOCK DEALLOCATE_MESSAGE BUFFER_SETUP ALLOCATE_MESSAGE ALLOCATE_STRUCTURE        P:DISK$ K  
KER$SIGNAL  KER$WAIT_ANY  
KER$    DELETE  KER$CREATE_EVENT  KER$CREATE_MESSAGE  KER$ENTER_KERNEL_CONTEXT  BUGCHECK  
CLOSE_DISK  DEALLOCATE_STRUCTURE  
DELETE_EXTFCB  	READ_DISK  	REM_QUEUE  ZERO_WINDOWS  PAS$NEW2   FLS$K_ERRDURDMT  ELN$INTEGER_TO_CHAR_VAR_R3 
     ALLOCATE_STRUCTURE 4 ^޼W޼nW PAS$NEW2PV, n WfWn
VP  
  2   ALLOCATE_MESSAGE B  2   P^޼WW߭߼  KER$CREATE_MESSAGEЭV, n WfVP  
  Z   BUFFER_SETUP   Z   P^޼R޼nТ(S
n    TT
TTØ ϯ T1 գh{LLPߣpPPhLhlТ0PPPPߢ\ݢL`PX"(P|"PÀ У|Pߠ  KER$CREATE_EVENTÀ Pߠ  KER$CREATE_EVENT ThØ    
  (   DEALLOCATE_MESSAGE '  (  P ݼ  
KER$DELETEԼԼ   
  =   LOCK .  =  P ޼QXaݡ|~  KER$WAIT_ANY  
  W  |NEXT_FIXED_RECORDv  W  P|^޼U޼V޼*<RTTTǏ   TSVRSRļSSRTRR)VS<RRRxRRRRRSǏ   S 	S    ּ  
    
REMOVE_VCB ^޼VWƃ V 
CLOSE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTզdݦd  
KER$DELETEզlݦl  
KER$DELETEզ\ߦ\ߦXզTߦTߦPfս1 нU<RR1 1 fR ߭R 	REM_QUEUEPT<RRRЭS<RSU1 S 
DELETE_EXTFCBУS ZERO_WINDOWS ߭ݭ 	REM_QUEUEP
ݭ DEALLOCATE_STRUCTUREЭR   
KER$DELETE    
KER$DELETEբ0ߢ8ߢ06ЭRբh.բ|) #R DEALLOCATE_STRUCTU    RET1D, n  0WWW
ݏ #  FLS$K_ERRDURDMT BUGCHECK   
  :  RESTORE_CONTEXT8  :  P޼WЧDV(($V DEALLOCATE_STRUCTURE  
  V  RESTORE_DIR  V  P^޼W޼V޼XhRRǄ hfѨj޼TdfЦSǀ R@fUUЧRRUS 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTհ((**55P 5P5(577(+hf  
    RETURN_FILESPECt   P,^޼^ЭRТТxY %
<<RRR<5<R/RQޭPSR  ELN$INT    EGER_TO_CHAR_VAR_R3(<<[RR[i8ЬR[SbWSVV V(V@V RRRVRg(RcRЭS:bØ P
RRSSЬ܄SWWXXZ[[Z[<XVV^nV("fЭR(W <ZWW^nW(Xfg<XX^(Zgn([@WVV V(VnV RRRVRg(Rc  
  >  SAVE_CONTEXT :  >  P޼W4ϺPV(($, n ($VD 0, n 60  
  o  |SAVE_DIR % |^޼n	<+~σPV(+ fVP   
    SET_NEXT_RECORD $^޼S޼  -У`h<dT<RRRTR        T֣hf9Tf3`Rx	RR<dnnR<RRǏ   Rh 	Rf<fRRRRf<fѮ   ֣hf  
  '   UNLOCK %  ޼QXaݡ  
KER$SIGNAL     A  $CODE     $DATA        w w                                                                                                                                                                                                                                                                                               9    ISSELL    MISC  (:ߓ  THISSELL    MOUNT ߓ  THISSELL    OPEN" cߓ  THISSELL    	PARSENAME @Tߓ  THISSELL    PUT!  Sߓ  THISSELL    READHOME kߓ  THISSELL    REMOVE @oߓ  THISSELL    RENAME |ߓ  THISSELL    REWIND Zߓ  THISSELL    SEARCH tߓ  THISSELL    TRACE! `Bߓ  THISSELL    TRUNCATE  % ߓ  THISSELL    WINDOW! i%ߓ  THISSELL    FILEUTIL" `1(ߓ  THISSELL    	FILVE    1       7ߓ V4.2-01                         5     MOUNTV4.2-0110-OCT-1990 21:04                    VAXELN PASCAL V4.2_95 
  e
 q	    z  e    T4$DAP멸$ELNMSGE,
$KERNELMSG$KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRYMOUNT /      P                              DISK$  q  KER$CREATE_EVENT  KER$CREATE_SEMAPHORE  KER$CREATE_NAME  
KER$DELETE  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_MESSAGE  CHECK_HEADER  
CREATE_FCB  
CREATE_WCB      GET_MAP_PTR  	INS_QUEUE  
MOUNT_MESSAGE  	OPEN_DISK  	READ_DISK  	READ_HOME  
REMOVE_VCB  UNLOCK  ELN$LOG_VOLCHANGE   
FLS$K_MOUNTED  OTS$CVT_TI_L 
  &   MOUNT Ϟ^޼Y(L޼ЩXHpTЩ͐͔͐͘T͜ 	OPEN_DISKS͔~S͠ KER$ENTER_KERNEL_CONTEXT͠SSS 
MOUNT_MESSAGESH1.	ȃ ԨPԨdԨlhߨ\< ~ ALLOCATE_MESSAGEPXhh`pȘ ݩ 	READ_HOMEP((1Щ  Z[(PS1[ʘ C    ʔ   
KER$DELETEʔ ( 
MOUNT_MESSAGE(ʘ +ݏ 
FLS$K_MOUNTED 
MOUNT_MESSAGEhh  
MOUNT_MESSAGES:ϧP
SSRRR.(υͭ.RRRRͫ(Rͫ,2,WWDͭHLDʔ l KER$CREATE_NAME(ʘ lrl|  gWDͭH LDʔ l KER$CREATE_NAMEl=l|  	ЏSll 
MOUNT_MESSAGEݩ 
REMOVE_VCBޔSЏSH>((  
MOUNT_MESSAGE(0S(
S                                                                                                                                                                                                                                                   n                        X6k $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                         "                (HSS1TpȐ <SxSS< RSR4d8Ф<Ф@ФD< SSL<FRFrrФxDRD||ERR}Ф,06~4Ȯ <"RRȁ `Ȃ ȏ   Ȅ }pȈ ` ߨd  KER$CREATE_SEMAPHOREh ߨl  KER$CREATE_SEMAPHOREhhhz|~LRDR<WHЩ<SЩRRSW 	READ_DISKS~S KER$ENTER_KERNEL_CONTEXTRЩ<zW CHECK_HEADERRP1 Ш@<Щ<Щ W 	READ_DISKS ~S     KER$ENTER_KERNEL_CONTEXTSЩ< SS 
MOUNT_MESSAGESH1dЏ8SHzW CHECK_HEADERP ݏjS 
MOUNT_MESSAGEЏjSH1,ѩH
ݩH  
MOUNT_MESSAGEHԩ8 ݩ8ݩ<Wݩ 
CREATE_FCBPZʘ  ʜ   KER$CREATE_SEMAPHOREʠ   KER$CREATE_EVENTSУHJDHFУDFʄ Dʆ ʈ xZW~x 
CREATE_WCBުR RP 	INS_QUEUEWTLRR}R$$DUЩ,0,4U8<T@ 	READ_DISKS0~SD     KER$ENTER_KERNEL_CONTEXTDRRݏHS 
MOUNT_MESSAGEU< VFRV$x$SVRxRRSRdVxVRVR	RRdVVdR4RRʄ ѪPRRP<pRtR[[R[  [ Ə   [[    ݏS 
MOUNT_MESSAGEЏSH1`z|~LSDSSЩRTRXS\`Wd 	READ_DISKUT~Uh KER$ENTER_KERNEL_CONTEXThRzW CHECK_HEADERRPݏXS 
MOUNT_MESSAGE1LR>Bg͈̀ GET_MAP_PTR̈́TTH[MSЩx|xT    S|~U߭ KER$ENTER_KERNEL_CONTEXTЭWWݏ@S 
MOUNT_MESSAGE1 ȣݏ`S 
MOUNT_MESSAGEUV[1 [̈́ЩӬ́U 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭWW	Џ@SWETDe%DeSxTRSRRReV S V   TЩR<pSVStWW 
MOUNT_MESSAGEшȴ TTS2Ȳ URR@   RϩUTSTSH   H   V3VD   D   !   !   !   (!   ȴ #   '     !   !   !   (!   ȴ #   2Ȳ RRVRR            (    Fȳ    2    8   <@8 OTS$CVT_TI_L@L   <RȘ !   L   R ݨ0@~	 ELN$LOG_VOLCHANGEߨT< ~ ALLOCATE_MESSAGEPPШPШPШDЩЭԭЭЭЭ̭ 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSШPhR RZ 	INS_QUEUEPSȃ Щ UNLOCKЩH\\P     	  $CODE P   $DATA         &    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  1        $ߓ V4.2-05                         4     OPENV4.2-0510-OCT-1990 21:04                   VAXELN PASCAL V4.2_95 
  e
       e    T4$DAPO t$DAPPARSEDEF$KERNELDAAF11DEFkHFLSDEFFLSENTRYRETURN_CHARACTERISTICS OPEN_ACTION  f  DAP$PARSE_FILESPEC  KER$ENTER_KERNEL_CONTEXT  ACCESS  ALLOCATE_STRUCTURE  CHECKSUM  CLEANUP  CREATE_FILE  DEALLOCATE_MESSAGE  DEALLOCATE_STRUCTURE  DIRECTORY_DEACCESS  EXTEND_FILE  IN   IT_FCB  	INS_QUEUE  LOCK  	REM_QUEUE  RETURN_FILESPEC  SEARCH  TRAVERSE_DIR  UNLOCK  
WRITE_DISK  DIRECTORY_TYPE      P ^޼RТn% P  UNLOCK%ТP LOCK ߼ݼ 	REM_QUEUEݼ DEALLOCATE_STRUCTUREԼТP UNLOCK  
  a   OPEN_ACTION a   PϞΨ^޼ʹ޼Ͱ޼xͬ^ͨͬR  SRSSͼͼZЪ0[ЪxЪR 
 Џ  1Tͼ CLEANUP T޼,R|~bx DAP$PARSE_FILESPECP1   Ъ0RRм Tʏ   	%Џ 4 1ˏ   ʹRЏ , 1nˏʹRЪR Џ t 1C %"Џ 4 1- Џ , 1ʹˏʹR@TʹTͰˏo   ͰRЏ i 1ˏͰRkͰ=Ͱ7 k3)TЏ  1 RѼЏ i 1RTЏ Q 1iмRR
 %RЏ ] 1HRЏ X 11"ռ<ѼѼ<Џ  1
Ѽռ#
Ѽ    %ռ
   Ѽ   Џ J 1ЪS$RÄ ЪR| %S<DRR
< 71ռ4Џ  1
ͻ ͻͻ
ݪxͼ TRAVERSE_DIRP10C~ ALLOCATE_STRUCTUREPЪR LOCK޺R R 	INS_QUEUEЪR UNLOCK %.S<DRR  R(H1 MRSCKRRTUCPRTVV V(VbV RRRVR(R DIRECTORY_TYPEcdSRRSTRRVSVY<YXXͨ^(S4nR(V8YVV    V(VnV RRRVR(R DIRECTORY_TYPEcHݪ0ͼ SEARCHP H	ЪH1 6C>
9 %SR)<R#Џ - 1 
1YSR<Rʏ   (ݼݼݼݼͼ CREATE_FILEPЪ(Rբ4Ԫ(93ͻ~ ߼߼߼ͼ ACCESSP ʄ RSʄ &ʄ Rբ
ߢߢ DEALLOCATE_MESSAGEʄ  DEALLOCATE_STRUCTUREʄ 1Ь,Rbͼ RETURN_FILESPEC %Ъ4R4RRR"T$1   ͼTФ0YФ(VФ4RUФ4ScR>BcH %1 ռ41 RR RRм4 Ф4R4*<RRХDFզDݤ8ݤ4ݤ0ͼ EXTEND_FILEPФ40Ф881MФ4RUФ4ScR>Bcռ8RRR 8ռ<<ռDDռH
HHx\RXyWWѢXbW	S}b`RѢXbW	S}bdRѢXbW 	S}b&hRѢXbW	S}b.ռpФ4Rмp<мpH޼tS<cRR  Ф4Rc@cLݤ4 CHECKSUMФ4UФ<SФRRSU 
WRITE_DISKS~S߭ KE   R$ENTER_KERNEL_CONTEXTЭФ<ԦTݤ(ݤ4 INIT_FCB HФHBͼ߼t߼p߼lhd`\߼X߼T߼P߼L߼H߼D߼@߼<߼8߼4߼0H%Ъ(Ъ(R  UNLOCKHͼ DIRECTORY_DEACCESSͼRݢR*P#  
    |RETURN_CHARACTERISTICS    P|^޼LVЦ4RUЦ(TЦR RR   $	<RR$Q<RKХЭRRR RDХЭ$ЭĄ <(Ĉ <ФDФD Ą $<Ĉ (<x<<Ĉ RR   Ą Ĉ Ф@,ԼЦ4ScR>BcS}     0}4}&8}.<<@Ц4RТ<DЦ4R@H     	  $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                  	  1        Abߓ V4.2-00                         9     	PARSENAMEV4.2-0010-OCT-1990 21:04                    VAXELN PASCAL V4.2_95 
  e
 #hE    3  e    kHFLSDEFFLSENTRY
PARSE_NAME        P%*;(   OTS$CVT_TI_L 
     |
PARSE_NAME|^޼UV|eԥ޼RS:bP<bSPSSSbTS:TP<TSPSSS:TP<TSPSSee2SSХTCPŚPRPR-PPnR*eJ2PSPPPR2RC OTS$CVT_TI_LЭRR	R  	Џ q VR     n VP        $CODE     $DATA        w w                                                                                                                                                                                                                                                                                                                                                                                                                                                            1       `ߓ V4.2-01                         3     PUTV4.2-0110-OCT-1990 21:04                    VAXELN PASCAL V4.2_95 
  e
 L    j  e    T4$DAPDAAF11DEFkHFLSDEFFLSENTRYCHECK_RECORD 
UPDATE_ACTION 
PUT_ACTION       P
    KER$CLEAR_EVENT  KER$WAIT_ANY  BUFFER_SETUP  
FLUSH_BUFFERS  LOCK  NEXT_FIXED_RECORD  	READ_FILE  SWITCH_BUFFERS  UNLOCK  
UNLOCK_RECORD 
     |
PUT_ACTIONJ |^޼޼޼޼޼ЬV޼ nT                                                                                                                                                                                                                                                   o                        vǙ $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        >w "              ݮݮ~ݮݮݮ$Vw  
  J   
UPDATE_ACTION^޼޼޼nЬXXVT U	Џ  WU|~ ݮݮݮ X/PWWP@QSУTФ(R ݣ SWITCH_BUFFERSP V1  N΢dP<P\@`\\ ѣL3΢dP<P\@`\\ < \ѣ\΢d\<PUL`UU ТdQQP<P\@`\A\dzUݣ 	READ_FILEP V
Тd\LhVVP X  PQVЦUХ(R  LOCKХ0\\\EТ0\T<RSSxSSSSdx	 P< \\PSPS P< \S\P\֦ԈTU h f< S W 
   WS<P\WQyPP{\PSSS\SSWݦ 	READ_FILE dz  UNLOCK +  P QSУTФ(RѣMФh찤fܣ\<P\P ѣ؏   
P֣촣Ǐ   \\h 	\\fB~?ߣݣݣ NEXT_FIXED_RECORD&ѣ ѣ   0	Џ L Ѥp1 դp
ߤpݤ( 
UNLOCK_RECORD 0mhݣݤ(6	PZBݣݤ(#	P=  UNLOCK  |~  KER$WAIT_ANY    KER$CLEAR_EVENT  LOCKЏ ^ Т04Т88 `  P СRС\BSСRТ0RRR   S\\
NqBRS\\
5W)R$SRR
RR\0,СRԡТh찢f2SS<\S\Ǐ   \\h 	\\f СRТhѡf<\\ԡ܅Ǐ   \\h 	\\f СSУ(R<x\ѡ\̢xУh찣fRR<\R\ ѡ؏   
\֡촡Ǐ   \\h 	\\fϞ^ЬRЬЬЬ޼[ЬЬ ЭXШ(ZЭRTRRRVTUTԭ[Ш0R Џ W 1V1 [1 TUݭݭ BUFFER_SETUP]Q U   TЭR
RR.Ш0RRѭШ0RRѭЭRRRЏ W 1;TRTѭЏ : 1խխѭЏ > 1 0Џ , 1ʘ  LOCKЪ04Ъ88Ъ0RScRRУ谭ѭ1 V1 <R	ѭR1 Ш0RRR
<RRѭR1 Ш0RRRR
ѭ̏  uRRR  d
ѭ̏   VШ0RRRRѭR?Rѭ5V=<lRѭR
Ш0RRRѭ̏   Ш0RRRЏ f 1VUШ0RRRШ`hdf]Q .1+Ш`차dԭШ0RRR   R1 1 CЭR
RR3Ѩhʄ ʈ f#ʄ RѨhR<ʈ R T Џ L 1!TѭѭJШ0RR@Эԭ촭ԭѭ̏   Ǐ   RRh 	R֨hfbЭh̨fVԭШ0RRR +  ! ! 5 5 5 -]Q 1]Q ]Q ϼ]Q  Э̭޼RЭbЪdSSzѭC\<PRC\RѭR1 ݭ SWITCH_BUFFERSP1%ЪdSSzѭC\<PRC\RѭR1 ЪdTS<PRRSRSSD\ЪdRʄ B\<ʈ R\ѭʄ 
ЪdRʄ B\G<RJЭTЪdRTB\;ѭ̨L+ʄ SST*<PRTR   SRTSx	SS<ʈ RRSѭS	dzݭݭ 	READ_FILEP1XЪdTD\Sx	SS<RSRUUDhdRRzؽUV1 Ѩhʄ ^Ѩhʄ fʈ Nխѭ
Ш0RRR6ѭ+ѭ1 ѭʄ ѭʄ p<SS<ʈ RSR^խ$Ѩhʄ Ѩhʄ fʈ Ш0R b9ѭШhʄ fʈ R~?ʈ ʄ Rݭ NEXT_FIXED_RECORDЭYЭحULRRRЭRiQSRW<VVWWV(VacVW­حdRRzխ^]Q P1 YѭLШLЭЭRiQSRW<VVWWV(VacVW­ح     dRRzխحЪdRBhRRLխ֭\խ]Q :PpШL(2RѭR ]Q PFШL2TTTSC֭TSխ ݪdݭ 
FLUSH_BUFFERSPЏ ըp
ߨpݨ( 
UNLOCK_RECORDʘ  UNLOCKѭ 5 2ЭRТ(RЭ ЭRТ(R ЭRТ(RzЭRТ(RzЭRЭHЭP   
  8  |CHECK_RECORD ?  8  P|޼T޼VĐ SĐ RSRѣVcSĐ RUSRUUP     n  $CODE     $DATA        w w                                             	   1       `ߓ V4.2-00                         8     READHOMEV4.2-0010-OCT-1990 21:04                   VAXELN PASCAL V4.2_95 
  e
 nڠ    b  e    T4$DAP멸$ELNMSG$KERNELDAAF11DEFkHFLSDEFFLSENTRY	READ_HOME :   KER$ENTER_KERNEL_CONTEXT  	CHECKSUM2  	READ_DISK      P  
      	READ_HOMEǞ^޼ZЬR(b޼T}խ
ЏSV1SUUS<RRSǭSXRUUXRR"<RR	RRRXRRǼRXX

RXRXW޼Y     ZWT 	READ_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭVVAV  
ЏSV1DV ! 
ЏSV11V  V  1XW1 <RR  R  
ЏSU1 dW9դ4<R.<R(<R"<R<Rդդ< R<"RUxRUoT: 	CHECKSUM2PU]T<~ 	CHECKSUM2PUH<&R$R   <(RR   - 	 ] ЏSU)	ЏPSUUUVVPSd'Џ0SiVXWV1dVЏ0SVVP     #  $CODE     $DATA         w w             	   1        ߓ V4.2-00                         6     REMOVEV4.2-0010-OCT-1990 21:04                   VAXELN PASCAL V4.2_95 
  e
     H  e    $KERNELDAAF11DEFkHFLSDEFFLSENTRYREMOVE =   KER$ENTER_KERNEL_CONTEXT  SHUFFLE_DIR  
WRITE_DISK       P  
      REMOVE $^޼Z޼V޼Ц2RRRR2,ЦSRRƇ P Ƈ PƇ (Ƈ Ɖ  $@$Ц[RRS RRRSѮS>æTTYiQSTX<WWXXW(W     acWX2RRRY7æT®Tn QkSTX<WWXXW(WacWXԦЮYYW, n Yg2RR!ʀ RѢP~VZ SHUFFLE_DIRPRUYЦSʀ R@fTTЪRRTS 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSSSHUЪR UUP       $CODE     $DATA         w w                                                                                                                                                                                              DER  RETURN_FILESPEC  SEARCH  TRAVERSE_DIR  UNLOCK  
WRITE_DISK  ELN$INTEGER_TO_CHAR_VAR_R3      P  
      
RENAME_ACTIONϞ^޼͚R  SRSSWЧR 
 Џ  1%, n t R<͛@޼R|~b DAP$PARSE_FILESPECPP1JЧxЧxR޼R|~bx DAP$PARSE_FILESPECPP1ЧxYЧZi1 XXRRRЩ V,R ͠)ʘ ͠1 XXR,Rf zʲ T-Tʴ  z1 2Tʴ  ͬ KER$TRANSLATE_NAME   l|ͼ|RRR ( S2S ͼ KER$TRANSLATE_NAME
)ͼͬЏ  16Џ  1*   TRAVERSE_DIRPP1S<DRR͙ ͙͙R(͙H͛H ͚͙ݧ0 SEARCH H	ЧH1PP1xЧxSǄ RЬRb RETURN_FILESPECxЧ0R(Ǆ ZЧ0V 0 [ǀ Yݧx TRAVERSE_DIRPXX DIRECTORY_DEACCESSYǀ 1 ЧxRRЧ0S
ЧxS<DRR͙ ͙͙(͙H͛   H͚͙ݧ0 SEARCH HP-Ч0R$ DIRECTORY_DEACCESSYǀ  HЧHX_Џ - XVЧ0R(ݧ0Ǆ  ENTERPX$XЧxSǄ R ЬRb RETURN_FILESPEC CLEANUPYǀ Ǆ "Ǆ Rբ
ߢߢ DEALLOCATE_MESSAGEǄ  DEALLOCATE_STRUCTUREZǄ ǜ 0XX1Ǆ Rբ
ߢߢ DEALLOCATE_MESSAGEЧR LOCKݧ FIND_FCBP(Rէ(RRTTЧ(RSբ0SSTTЧ(RТ04Ч(RТ88ߧ4( READ_HEADERPXէ4
Џ     Xԧ(ЧR UNLOCKXX1aէ(Ч(R  LOCKЧ(Ч4R(BЧxY<QPSR  ELN$INTEGER_TO_CHAR_VAR_R3, ͛Ч4ScR>BcZ<DSRRSISVV V(VH͜V RRRVR͚(R͛c(͜j2͚RRRR,RͰ B 6ݧ4 CHECKSUMЧ4TЧ<SЧRRST 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭSЧ4Ч<է(Ч(Ч(R  UNLOCKԧ(ԧ4Ч4ߧ8ߧ4 DEALLOCATE_MESSAGESS$x 
ERASE_FILExP@$PP            $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	   1       yߓ V4.2-00                         6     REWINDV4.2-0010-OCT-1990 21:05                   VAXELN PASCAL V4.2_95 
  e
      @  e    T4$DAPkHFLSDEFFLSENTRY
REWIND_ACTION 9   
FLUSH_BUFFERS  LOCK  UNLOCK  
UNLOCK_RECORD       P  
      <
REWIND_ACTION <^޼nnP  RPRRTTRТ(STUØ  LOCKУ04У88UzzT 
FLUSH_BUFFERSPUUЏ Uբp
ߢpݢ( 
UNLOCK_RECORD͊UԢ`dhfTÄ 
<È P                                                                                                                                                                                                                                                   p                         $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        ® "                TTØ  UNLOCKUHUP        $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                            1       Qߓ V4.2-03                         6     SEARCHV4.2-0310-OCT-1990 21:05                   VAXELN PASCAL V4.2_95 
  e
 I*e    Q  e    T4$DAPDAAF11DEFFIDDEFkHFLSDEFFLSENTRYSEARCH        P*.*   DEALLOCATE_MESSAGE  DIRECTORY_ACCESS  DIRECTORY_SCAN  LOCK  
PARSE_NAME  REMOVE  UNLOCK 
     SEARCHϞ|^޼W޼X޼, P Ю[YЬRݮb 
PARSE_NAMEPZZZH1ckRRkѮѮR   kRRR~XW DIRECTORY_ACCESSPZZZH1%ǀ R  LOCK%ԮԮnǄ RԢǄ RԢ Ǆ V.02ЧS<ǖ RÐ Rզ
ߦߦ DEALLOCATE_MESSAGE(.ը1 SS
U޼RYb 
PARSE_NAMEϵb1 iS|~ UYǄ W	 DIRECTORY_SCANP HЧHZ17 kNii Ǆ RbSݏS YǄ W	 DIRECTORY_SCANP HЧHZ1Ǆ SУRn֣ 1 ЧS<ǖ RÐ R k* k ݏ|~ U YǄ W	 DIRECTORY_SCANPZ    ZǄ SУRn֣ | HЧHZ1sǄ TdRRU^դ Yդ
ߤߤ DEALLOCATE_MESSAGEݏ|~|~ YǄ W	 DIRECTORY_SCANPǄ SУRn֣  HЧHZ1Ǆ RТnФnǄ RТbǄ Rݏݮ ݮ$Ǆ W	 DIRECTORY_SCANP* HЧHZ1 ը	Џ 2 ZЏ  ZԨ1 Џ ZǄ RТR(k k)Ǆ R RR ׄ RR
ЧR ǖ ԨѮ4<RRT 㚨R
Џ U ZZH1 Ǆ W REMOVEPЧHZծǀ R  UNLOCK%ZP      $CODE     $DATA             w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    "  1       kߓ V4.2-00                         5     TRACEV4.2-0010-OCT-1990 21:05                    VAXELN PASCAL V4.2_95 
  e
 .      e    FLSENTRYE,
$KERNELMSG
SEND_TRACE GET_TRACE_BUFFER GET_TRACE_HEADER PERFORM_TRACE_DONE PERFORM_TRACE_INIT  7      Perror on ker$get_object_address =  ,TRACE_AREA    
KER$SIGNAL  ELN$TIME_STRING  KER$GET_TIME  KER$CURRENT_PROCESS  
KER$DELETE  KER$CREATE_AREA  KER$GET_OBJECT_ADDRESS  ELN$INTEGE #  R_TO_CHAR_VAR_R3 
  .   PERFORM_TRACE_INIT ^    R P
ޯڭ ߭bߢ߭ KER$CREATE_AREA-ѭ  ղ 	в  ݢ߭ 
KER$DELETEԭ \\P  
      PERFORM_TRACE_DONE 4     P     \ ݬ  
KER$DELETE  
     GET_TRACE_HEADER '     P    \ ЬRRRP   
     GET_TRACE_BUFFER     PϞh^    [^hԭԼ 1ЫR 1߭  KER$CURRENT_PROCESSݭ߭߭ KER$GET_OBJECT_ADDRES $  S譬1 ЭTФRQ>PPSR  ELN$INTEGER_TO_CHAR_VAR_R3YQ>(PSR  ELN$INTEGER_TO_CHAR_VAR_R3YZ<YVVh^nV(fϬ<ZXX^(Yfn(ZVV@ @V(VnV@ RRRVR(Roc2QޭPSR  ELN$INTEGER_TO_CHAR_VAR_R3("0RRR"R(RЫRR ԭխЫRXRRRRԭ1 ЫRXRRRRЫR  K    KER$GET_TIMEЭV ELN$TIME_STRING(rϼ(r
RRj jRR(RЭRRbv bvb(bЭ      RRP  
    
SEND_TRACE [    P    SУRQbPQXPPPPQݣ  
KER$SIGNAL       $CODE 
   $DATA    .    w w                                                                                                                                                                                                                                                                                                                                        &  1       ߓ V4.2-02                         8     TRUNCATEV4.2-0210-OCT-1990 21:05                   VAXELN PASCAL V4.2_95 
  e
 :    x  e    T4$DAP$KERNELDAAF11DEFFIDDEFkHFLSDEFFLSENTRY
TRUNCATE_FILE TRUNCATE_ACTION e  KER$ENTER_KERNEL_CONTEXT  ALLOCATE_MESSAGE  BUGCHECK  CHECKSUM  CREATE_MAP_PTR  DEALLOCATE_BAD  DEALLOCATE_MESSAGE  
DELETE_EXTFCB  DELETE_FFILE  FIND_FCB  GET_MAP_PTR  INIT_FCB  LOCK  N '  EXT_HEADER  READ_HEADER  TRUNCATE_HEADER  UNLOCK  UPDATE_HIGHWATER  
WRITE_DISK  
WRITE_FILE   FLS$K_BADPARAM       P  
      TRUNCATE_ACTION8^ЬZZVЦ0XЦ(WYhЏ , YTЏ  Y U TЏ  YRЏ : YY1 ǘ  LOCKЧ04Ч88TRRR
RRx UbЦ`UЧdTD\SUSP<PRSRURDSUx	UU<dRRUDhUnR   R, n R ЧdSC\Ǆ RRRSZ 
WRITE_FILEPYY&dǈ Ц`Ǆ UhfTЏ Yǘ  UNLOCKYP  
  $  
TRUNCATE_ (  FILE $  PϞ^޼X޼V޼޼ЮS<RR<
RR
RЏ U 1ЮЮШ(n$Wզ Џ FLS$K_BADPARAM1}$Џ H|ЭR1 ЭTS>Cd̚:RRS>CdZЭ[ѭZ+ GET_MAP_PTRЭRRW1 RWR$RЭ[ѭZ|~X NEXT_HEADERPSH߭߭ DEALLOCATE_MESSAGESШ8n	nRТn.ЭRݨ FIND_FCBPnЏ 0 1 HШH1S1AWЏ ' 1ШR<pRWRRWШR<pSSWRRSWW$WWЭ[[ZЭS<R	<R1	;ѭZ"WS )  ШR<pRSR ЭS<RRݏ FLS$K_BADPARAM BUGCHECKԮ1Ш(R$D(ЭSШ(RݢDS UPDATE_HIGHWATER➣R$аТҢ߭< ~ ALLOCATE_MESSAGEPЭY( ií[SSSRRSS:W.[̟ GET_MAP_PTRkR[ ߭Y߭W CREATE_MAP_PTRЭ[[ZR, n RkЭY<RR(ԩY CHECKSUMШ<SШRRSY 
WRITE_DISKS~S߭ KER$ENTER_KERNEL_CONTEXTЭШ<1 nn(nY INIT_FCBWݭVX DEALLOCATE_BADW     ݭVݨ $ TRUNCATE_HEADER㐮<RRH߭߭ DEALLOCATE_MESSAGEݮ X NEXT_HEADERPRn 
DELETE_EXTFCBRVX DELETE_FFILEPШHT
߭߭ DEALLOCATE_MESSAGE߭߭ DEALLOCATE_MESSAGEߨ4(X READ_HEADERPШ4RR$ЮP      $CODE     $DATA         w w                                                                                                                                                       	 +  1        ߓ V4.2-00                         6     WINDOWV4.2-0010-OCT-1990 21:05                   VAXELN PASCAL V4.2_95 
  e
 /    ^  e    DAAF11DEFkHFLSDEFFLSENTRYZERO_WINDOWS TURN_WINDOW 
CREATE_WCB A   ALLOCATE_STRUCTURE  DEALLOCATE_STRUCTURE  GET_MAP_PTR       P  
      <
CREATE_WCB  <^޼n޼S޼UnRХP|RR.R%%RRP PP ALLOCATE_STRUCTUREPTSTFPTS 5PTTQU PP ,  44 QP  
     TURN_WINDOW    PϞ^޼޼޼[޼ծLЮR<S SSS%%RSRRYЮT<ZФX nZ#VVRnT(BBZV
ЏX%YXTѮT$ZSSR<BRRTѮTSWZS[ѮЮ1WЮXЮRS>Cb:RRS>C1  GET_MAP_PTR1 WY/<"RXRR[1 RXWVVR(BBWVWWTSS  <RSRRDWRBRb  RR  <SRSS1n1OЮZ~ ALLOCATE_STRUCTURE     PZ nWXWVVRnS(BBWVZЮP     
  u  |ZERO_WINDOWS V  u  P|޼VЦTަUTU&ФRТSR DEALLOCATE_STRUCTURESRԤdTTU      $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              q                        >v $      ELN042.D                         
  %[SYSEXE.SEAS$WORK_0000005C]FILE.OLB;1                                                                                               >                        _7       -       .  1       b%ߓ V4.1-01                         8     FILEUTILV4.1-0110-OCT-1990 21:05                   VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.FILSRV.LIS]FILEUTIL/OBJ=ELN_BUILD:[ELN.FILSRV.OBJ]FILEUTIL ELN_BUILD:[ELN.FILSRV.SRC]FILEUTIL+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIBRARY+TOPD$:[KERNEL.OBJ]KERMAC/LIBRARY !  - File Service utility routines   BUGCHECK 
 +  DEALLOCATE_BAD 
 o   DEALLOCATE_STRUCTURE  FLS$K_ALLFHDNOTMAP  FLS$K_BADBLOCK  FLS$K_BADFILEID  FLS /  $K_BADFILENAME  FLS$K_BADFILEVER  FLS$K_BADPARAM  FLS$K_BADSBMBLK  FLS$K_ERRDURDMT  FLS$K_ERREXTIDX  FLS$K_ERRRDIDX  FLS$K_ERRWRTIDX  FLS$K_FILBLKNOTMAP  FLS$K_FILESTRUCT  FLS$K_ILLEGALEXT  FLS$K_ILLPTRCNT  FLS$K_MAPCNTZERO  
FLS$K_MOUNTED  KER$ALLOCATE_MEMORY  KER$EXIT  KER$SET_PROTECTION b  
    	MNT_TABLE  PAS$DISPOSE2 
 +  SEND_BADSCAN   	  SS$_TOOMANYVER 
     TABLE         	.  ABS  .    P        $ABS$    P  P  P  P 0    P       ERROR_TABLE   P       
ERROR_MESSAGE  P-F-ALLFHDNOTMAP, allocated file header not mapped P FLS$K_ALLFHDNOTMAP1   4&1P-F-BADBLOCK, bad block encountered; handling not implementedP FLS$K_BADBLOCK< 1 4&mP-F-BADFILEID, file number out of rangeP FLS$K_BADFILEID& m 4& P-F-BADFILENAME, bad filename for ENTERP FLS$K_BADFILENAME&   4& P-F-BADFILEVER, bad version number for ENTER P FLS$K_BADFILEVER+   4& P-F-BADPA 1  RAM, bad input para meter(P FLS$K_BADPARAM    4&P-F-BADSBMBLK, bad storage bitmap block specified in bitmap search0P FLS$K_BADSBMBLKA  4&EP-F-ERRDURDMT, error during dismount; outstanding file open8P FLS$K_ERRDURDMT: E 4&P-F-ERREXTIDX, error extending index file@P FLS$K_ERREXTIDX(  4&P-F-ERRRDIDX, error reading index file headerHP FLS$K_ERRRDIDX,  4&P-F-ERRWRTIDX, error writing index file headerPP  FLS$K_ERRWRTIDX 2  -  4& P-F-FILBLKNOTMAP, attempt to read/write from/to block not mapped in fileXP FLS$K_FILBLKNOTMAPG   4&GP-F-FILESTRUCT, unsupported file structure level or ODS2 feature`P FLS$K_FILESTRUCT? G 4&P-F-ILLEGALEXT, illegal extent specified in bitmap deallocationhP FLS$K_ILLEGALEXT>  4&P-F-ILLPTRCNT, illegal pointer count specified during retreival pointer creationpP FLS$K_ILLPTRCNTO   4&P-F-MAPCNTZERO, attempt to create map pointer 3   with zero block countxP FLS$K_MAPCNTZEROB  4&    UP P 
FLS$K_MOUNTED  U 4&UP-W-ALTHOMBLK, alternate home block used P0S' U 4&|P-W-ALTIDXFHD, alternate index file header used P8S. | 4&P-F-BADIDXFHD, no valid index file file header found PjS3  4&P-W-BITMAPERR, I/O error on storage bitmap; volume locked P@S8   4&S? G 4&P-W-IDXMAPERR, I/O error on index file bitmap; volume locked PHS;  4   4&PP-W-INCVOLLABEL, incorrect volume label, volume mounted anyway PPS= P 4&P-W-MAPHDRBAD, storage map header is bad; volume locked PXS6  4&P-F-MLTVOLLABEL, a volume with this name has already been mounted PS@  4&P-F-NOBLOCKSPEC, device driver indicated zero blocks on device PS=    4&@P-F-NOHOMEBLOCK, no valid home block found on volume PS3 @ 4&sP-W-VOLIMPDSM, volume was improperly dismounted; please reb 5  uild P`S> s 4&        ;  $CODE   P    
       	BUG_CHECK &	 P   
     CHECKSUM  &S ЬQPRRRRRRRRRRRRRRRRRRPʱRaPRaPP   
 P    	CHECKSUM2 &? }PxPPRRPRaPRaoP  l PAS$DISPOSE2yP   
 y    ENTER_USER_CONTEXT  & < R^Sʏ  S   S
  c   S~^P~SR`~ KER$ALLOCATE_MEMORYRSS~SR~ KER$SET_PROTECTIONЭ]^x~ ]~ KE 6  R$EXIT P  
     
GET_ACCESS  &R ЬQ< R
RR
 RRPxPQQPxPQQPPSS;P   
 ;    	INS_QUEUE &G PlլЬQ]\PPzP   
 z  
MATCH_NAME  &Q }R}TPVT$QQ*$RQQ%VW}VR}XTRPT}RV}TXP    
     	MOVE_BITS & P    
     	REM_QUEUE & PԼlլ&ЬQ)ЬQ _^
P     ԼPP+P   FLS$K_BADBLOCK~ BUGCHECK    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                     8    1        (ߓ V2.0-00                         9     	FILVECTORV2.0-0010-OCT-1990 21:06                    VAX MACRO V5.0-9  MACRO/NODEBUG/LIS=ELN_BUILD:[ELN.FILSRV.LIS]FILVECTOR/OBJ=ELN_BUILD:[ELN.FILSRV.OBJ]FILVECTOR ELN_BUILD:[ELN.FILSRV.SRC]FILVECTOR+TOPD$:[SEALIB.OBJ]SYSTEMLIB/LIBRARY+TOPD$:[KERNEL.OBJ]KERMAC/LIBRARY!  - File Service transfer vectors .   ELN$FILE_INITIALIZE  ELN$FILE_SERVICE         	.  ABS  .    P    
   
$$$VECTORS  PAELN$FILE_INITIALIZEELN$FI      LE_INITIALIZE&1 ELN$FILE_INITIALIZE3Q   AELN$FILE_SERVICEELN$FILE_SERVICE&1 ELN$FILE_SERVICE3    w w                                                                                                                                                                                                                                                                                                                                                                                                           CTOR"  *ߓ  THISSELL    	VOLCHANGE td,ߓ  THISSELL    FLSMSG" '  THISSELL    	FILVECTOR                                                                                                                                                                                                                                                                                                                                                                                                       
     1       *ߓ V01.0                           7     	VOLCHANGEV01.010-Oct-1990 21:0610-Oct-1990 21:06   VAX Bliss-32 V4.5-862     KER$POST_ERRORLOG    P   
      < ELN$LOG_VOLCHANGE_ < ^, n >n}nЬЬQaP(P .$0(2^>ݬ~ KER$POST_ERRORLOG    M   $CODE    w w                                                                                                                                                                                    <  1       ?X,ߓ  V2.0-00                         6     FLSMSGV2.0-0010-OCT-1990 21:0610-OCT-1990 21:06  VAX-11 Message V04-00        $ABS$    
FLS$K_MOUNTED   |FLS$K_MAPCNTZERO   tFLS$K_ILLPTRCNT   lFLS$K_ILLEGALEXT   dFLS$K_FILESTRUCT   \FLS$K_FILBLKNOTMAP   TFLS$K_ERRWRTIDX   LFLS$K_ERRRDIDX   DFLS$K_ERREXTIDX   <FLS$K_ERRDURDMT   4FLS$K_BADSBMBLK   ,FLS$K_BADPARAM   $FLS$K_BADFILEVER   FLS$K_BADFILE     NAME   FLS$K_BADFILEID   FLS$K_BADBLOCK   FLS$K_ALLFHDNOTMAP     
FLS$_FACILITY   w w                                                                                                                                                                                                                                                                                                                                                                                                                       - * [SYSEXE.SEAS$WORK_0000005C]FORTRAN_DEFS.FOR;1 +  ,    . ?    /     4 N   ?   > 8                   - 
    0   1    2   3      K  P   W   O ?    5 	  6 &  7 4^  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     r                        P $      ELN042.D                         
  -[SYSEXE.SEAS$WORK_0000005C]FORTRAN_DEFS.FOR;1                                                                                  N     ?                          "            M C****************************************************************************  C									    * + C   FORTRAN_DEFS.FOR      V4.1-00					    *  C									    * M C****************************************************************************  C*									    *I C*  Copyright (c) 1987, 1990  	                                    	    * < C*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * C* 									    * M C*  This software is furnished under a license and may be used and  copied  * M C*  only  in  accordance  with  the  terms  of  such  license and with the  * M C*  inclusion of the above copyright notice.  This software or  any  other  * M C*  copies  thereof may not be provided or otherwise made available to any  * M C*  other person.  No title to and ownership of  the  software  is  hereby  *  C*  transferred.							    * C* 									    * M C*  The information in this software is subject to change  without  notice  * M C*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  C*  Corporation.							    * C* 									    * M C*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B C*  software on equipment which is not supplied by DIGITAL.		    * C*									    *M C****************************************************************************  C  C  C Facility:  C ! C	VAXELN FORTRAN Run-time Library  C  C Abstract:  C A C	This file contains type and constant definitions for the VAXELN  C	FORTRAN run time facilities. C F C --------------------------------------------------------------------8 C These varying string needed by structures in this file C " 	structure /eln$varying_string_16/ 		integer*2 vs$count 		character*16 vs$data  	end structure " 	structure /eln$varying_string_32/ 		integer*2 vs$count 		character*32 vs$data  	end structure " 	structure /eln$varying_string_64/ 		integer*2 vs$count 		character*64 vs$data  	end structure # 	structure /eln$varying_string_255/  		integer*2 vs$count 		character*255 vs$data   	end structure F C --------------------------------------------------------------------  9 C These constants needed for ELN$LOAD_SECONDARY_PROCESSOR   +         parameter lsp$node_reset_fail = 0,  "      +            lsp$success = 1,*      +            lsp$open_file_fail = 2, *      +            lsp$memory_map_fail = 4,-      +            lsp$boot_command_fail = 6,  *      +            lsp$boot_block_fail = 8,*      +            lsp$load_image_fail = 10    F C --------------------------------------------------------------------  ) C This constant needed for the DLV driver     	parameter dlv$max_length = 1024  F C -------------------------------------------------------------------- C D C These are the constants needed the IEQ11-A/IEU11-A IEEE-488 driver     	structure /pp_config_word/  		byte addr  		byte value 	end structure   	structure /gpib_path_desc/  		byte talk_ad 		byte l_count 		byte listen_ad(14) 	end structure     	structure /sp_stat_word/  		byte addr  		byte stat  	end structure  !       parameter gp$mode_cids = 0,       +	 	gp$mode_cacs = 1,      +	        gp$mode_csbs = 2          PARAMETER PATH_LIMIT = 40   $ C Auxiliary Commands for IEEE driver         parameter AX_SRST = 0,      +		AX_DACR	=   1,      +		AX_RHDF	=   2,      +		AX_HDFA	=   3,      +		AX_HDFE =   4,      +		AX_NBF	=   5,       +		AX_FGET =   6,      +		AX_RTL  =   7,      +		AX_FEOI =   8,      +		AX_LON	=   9,       +		AX_TON	=   10,      +		AX_GTS	=   11,      +		AX_TCA	=   12,      +		AX_TCS	=   13,      +		AX_RPP	=   14,      +		AX_SIC	=   15,      +		AX_SRE	=   16,      +		AX_RQC	=   17,      +		AX_RLC	=   18,      +		AX_DAI  =   19,       +		AX_PTS	=   20,      +		AX_STDL =   21,       +		AX_SHSW =   22,       +		AX_VSTDL=   23,       +		AX_RSV2	=   24     C IEEE-488 Commands ! 	parameter gp$c_goto_local   = 1,        +		  gp$c_dev_clear    = 4,       +		  gp$c_pp_config    = 5,       +		  gp$c_grp_trig     = 8,!      +		  gp$c_take_control = 9,	 !      +		  gp$c_local_lock   = 17, !      +		  gp$c_clear_all    = 20, !      +		  gp$c_pp_unconf    = 21, !      +		  gp$c_sp_enable    = 24, !      +		  gp$c_sp_disable   = 25,       +		  gp$c_mla	  = 32,      +		  gp$c_mta	  = 64,!      +		  gp$c_unv_unlisten = 63, "      +  	  gp$c_unv_untalk   = 95,!      +		  gp$c_pp_enable    = 96, !      +		  gp$c_pp_disabl    = 112      	parameter gp$i_success = 0,!      +	   	  gp$i_no_message = 1,       +		  gp$w_redefine = 2,	       +	   	  gp$e_notsys = 3,	      +		  gp$e_bad_path = 4,	       +		  gp$e_no_event = 5,	       +		  gp$e_bad_talk = 6,	       +		  gp$e_bad_listen = 7,      +		  gp$e_bad_mode = 8,	       +		  gp$e_not_contrl = 9,       +		  gp$e_no_resource = 10,      +		  gp$e_bad_send = 11,	         +		  gp$e_bad_receive = 12,       +		  gp$e_err_int = 13,           +		  gp$e_ifc_int = 14,           +		  gp$e_srq_abort = 15,         +		  gp$e_nxm_error = 16,        +		  gp$e_no_srq = 17,	         +		  gp$e_srq_pending = 18,      +		  gp$e_invalid_bus = 19    	parameter gp$s_dcl = 0,      +		  gp$s_get = 1,       +		  gp$s_rlc = 2,       +		  gp$s_srq = 3,       +		  gp$s_ifc = 4,       +		  gp$s_rcc = 5,       +		  gp$s_ppu = 6,       +		  gp$s_ppc = 7,       +		  gp$s_adl = 8,       +		  gp$s_adt = 9,       +		  gp$s_dad = 10,      +		  gp$s_aet = 11,      +		  gp$s_ael = 12    	  parameter gp$bus_config = 0,       +		    gp$dev_config = 1,      +		    gp$unit_init = 2,       +		    gp$define_path = 3,       +		    gp$write_lb = 4,      +		    gp$write_eoi = 5,       +		    gp$read_lb = 6,       +		    gp$transfer = 7,      +		    gp$command = 8,       +		    gp$serial_poll = 9, "      +		    gp$parallel_poll = 10,#      +		    gp$load_ppoll_reg = 11, !      +		    gp$ppoll_config = 12,        +		    gp$aux_command = 13,       +		    gp$req_service = 14,      +		    gp$sense_mode = 15,        +		    gp$get_control = 16,!      +		    gp$goto_standby = 17, !      +		    gp$pass_control = 18, +      +	       	    gp$receive_control = 19,       +		    gp$set_event = 20,       +		    gp$clear_event = 21,      +		    gp$reply = 22,      +		    gp$event_reply = 23     F C --------------------------------------------------------------------! C Constants for the AXV11C device    	parameter  AXV$GAIN_ONE = 0,       +   	   AXV$GAIN_TWO = 1,      +	 	   AXV$GAIN_FOUR = 2,      +		   AXV$GAIN_EIGHT = 3   " 	parameter  AXV$DAC_CHANNEL_A = 0,       +		   AXV$DAC_CHANNEL_B = 1  F C --------------------------------------------------------------------   C Constants for the ADV11D      C completion codes for CODE type/ 	parameter  adv$success = 0,adv$no_request = 1, ,      +		   adv$timeout = 2,adv$aborted  = 3,      + 		   adv$unknown = 4    C values for adv$gain_array * 	parameter  adv$gain_1 = 0,adv$gain_2 = 1,(      +		   adv$gain_3 = 2,adv$gain_4 = 3  F C --------------------------------------------------------------------  % C constants for the AUTHORIZE utility   4 	parameter  auth$add_user = 0, auth$remove_user = 1,2      +		   auth$modify_user = 2,auth$show user = 3  < 	parameter  auth$username_field = 1,auth$nodename_field = 2,6      +		   auth$password_field = 4,auth$uic_field = 8,#      +		   auth$userdata_field = 16     F C --------------------------------------------------------------------/ C definitions needed for disk_utility functions  C / 	parameter  DSK$_BEGINNING = 0,DSK$_MIDDLE = 1,       +	 	   DSK$_END = 23 	parameter  DSK$_READCHECK = 0,DSK$_WRITECHECK = 1,       +		   DSK$_NOCHECK = 2      	structure /dsk$_badblock/ 		union  			map 				integer*4 start_lbn  				integer*2 lbn_count  				integer*2 fill0 
 			end map 			map 				byte sector  				byte track 				integer*2 cylinder 				integer*2 pbn_count  				logical*2 pbn_format
 			end map 		end union  	end structure  E C Supplies the number of bad blocks followed by a pointer to an array  C of dsk$_badblock.    	structure /dsk$_badlist/   		integer*4 badblocks 		integer*4 ptr_to_bad_blks  	end structure  F C --------------------------------------------------------------------/ C These parameters needed for the DRV11W driver   , 	PARAMETER  DRV11W$READ = 0,DRV11W$WRITE = 1   	PARAMETER  DRV11W$SUCCESS = 0,       +		   DRV11W$NEX = 1,      +		   DRV11W$ERROR = 2 F C -------------------------------------------------------------------- 	PARAMETER  KWV$RATE_STOP = 0,      +		   KWV$RATE_1MHZ = 1,       +		   KWV$RATE_100KHZ = 2,       +		   KWV$RATE_10KHZ = 3,      +		   KWV$RATE_1KHZ = 4,       +		   KWV$RATE_100HZ = 5,      +		   KWV$RATE_ST1 = 6,      +		   KWV$RATE_LINE = 7  F C                                                                                                                                                                                                                                                    s                        qx $      ELN042.D                         
  -[SYSEXE.SEAS$WORK_0000005C]FORTRAN_DEFS.FOR;1                                                                                  N     ?                         Yt "            --------------------------------------------------------------------     	structure /mutex/# 	    	integer*2 eln$semaphore_count  		integer*4 eln$flag 	end structure  F C -------------------------------------------------------------------- C + C These constants needed for the DRB driver  C * 	parameter  drb$longword = 0,drb$word = 1,6      +             drb$other_longword = 2,drb$byte = 3  - 	parameter  drb$reserved = 0,drb$success = 1, )      +		   drb$error = 2,drb$aborted = 3, !      +		   drb$control_change = 4   F C -------------------------------------------------------------------- C - C These constants needed for the DRQ3B driver  C * 	parameter  drq3b$false = 0,drq3b$true = 1  - 	parameter  drq3b$single = 0,drq3b$burst = 1,       +		   drq3b$block = 2  ' 	parameter  drq3b$rd = 0,drq3b$wrt = 1,       +		   drq3b$mem_to_mem = 2   9 	parameter  drq3b$transfer_done = 0,drq3b$no_request = 1, :      +		   drq3b$nem = 2, drq3b$eop = 3,drq3b$timeout = 4,=      +		   drq3b$wait_aborted = 5,drq3b$transfer_aborted = 6,       +		   drq3b$unknown = 7      < C     ------------------------------------------------------0 C  These needed for ELN$LOAD_SECONDARY_PROCESSOR C  	parameter sp$success = 0,!      +		  sp$node_reset_fail = 1,        +		  sp$open_file_fail = 2,!      +		  sp$memory_map_fail = 3, #      +		  sp$boot_command_fail = 4, !      +		  sp$boot_block_fail = 5,        +		  sp$load_image_fail = 6 		< C     ------------------------------------------------------ C Needed for queue routines  C  	structure /queue_entry/ 		integer*4 flink* 		integer*4 blink* 	end structure  9 	parameter QUEUE$HEAD = 0,QUEUE$TAIL =1,QUEUE$CURRENT = 2   < C     ------------------------------------------------------ C  C eln$dir_file C* 			*$       structure       /eln$dir_file/0 	        integer*4              eln$dapd_pointer/          	integer*4              eln$dir_status 4           	record/eln$varying_string_255/ eln$server4           	record/eln$varying_string_255/ eln$volume7           	record/eln$varying_string_255/ eln$directorys       end structuren 		< C     ------------------------------------------------------   	structure /port/h 	  	integer*4 eln$port(4)  	end structure  < C     ------------------------------------------------------   	structure /large_integer/ 	  	integer*4 eln$li1y 	  	integer*4 eln$li2	 	end structure  < C     ------------------------------------------------------ Cc0 C These parameters needed for the 'organization'% C field of the FILE$ATTRIBUTES recordT CE 	parameter FILE$SEQUENTIAL = 0,	'      +            FILE$RELATIVE   = 16, &      +            FILE$INDEXED    = 32   Ci2 C These parameters needed for the 'record_format '% C field of the FILE$ATTRIBUTES record* C	  2 	parameter FILE$UNDEFINED = 0,         ! Undefined<      +            FILE$FIXED     = 1,         ! Fixed length?      +            FILE$VARIABLE  = 2,         ! Variable lengthsC      +            FILE$VFC       = 3,         ! Variable with fixedA<      +            FILE$STREAM    = 4,         ! Stream ASCII9      +            FILE$STREAMLF  = 5,         ! Stream LFg9      +            FILE$STREAMCR  = 6          ! Stream CRy   CtB C These parameters needed for the 'record_attributes' field of the< C FILE$ATTRIBUTES record. They are bit position definitions. C	A 	parameter FILE$FORTRAN         = 0,   ! Fortran carriage controli>      +		  FILE$CARRIAGE_RETURN = 1,   ! CR/LF carriage controlC      +		  FILE$PRINT           = 2,   ! Print file carriage control	B      +		  FILE$NO_SPAN         = 3,   ! Records don't cross blocksA      +		  FILE$EMBEDDED        = 4,   ! Embedded carriage controle0      +		  FILE$RAT5            = 5,   ! Reserved0      +		  FILE$RAT6            = 6,   ! Reserved0      +		  FILE$RAT7            = 7    ! Reserved   C_= C These parameters needed for the 'file_options' field of the < C FILE$ATTRIBUTES record. They are bit position definitions. Ct  6 	parameter FILE$REWIND_OPEN      = 0,	! Rewind on open=      +	          FILE$REWIND_CLOSE     = 1,	! Rewind on close-0      +		  FILE$FOP2             = 2,	! Reserved	B      +            FILE$NO_POSITION      = 3,    ! Position magtapeF      +            FILE$NO_LOCK          = 4,    ! Do no lock if closed@      +            FILE$DIRECTORY        = 5,    ! Directory file0      +		  FILE$LOCKED	        = 6,	! File locked<      +            FILE$CONTIGUOUS       = 7,    ! Contiguous?      +		  FILE$SUPERCEDE        = 8,	! Supercede existing file	r>      +		  FILE$NOT_AT_EOF       = 9,	! Do not position to EOF	8      +		  FILE$TEMPORARY        = 10,	! Temporary file		B      +		  FILE$TEMPORARY_DELETE	= 11,	! Temporary, deletable file	)      +		  FILE$FOP12		= 12,	! Reserved			E9      +		  FILE$DISMOUNT_CLOSE	= 13,	! Dismount on close		 0      +		  FILE$WRITECHECK	= 14,	! Write check			.      +		  FILE$READCHECK	= 15,	! Read check			8      +		  FILE$CREATE_IF	= 16,	! Create if non-existent	9      +		  FILE$LOCK_OVERRIDE	= 17,	! Override file lock		 >      +		  FILE$SEQUENTIAL_ONLY	= 18,	! Sequential access only	@      +		  FILE$MAXIMIZE_VERSION	= 19,	! Maximize version number	8      +		  FILE$SPOOL		= 20,	! Spool to printer on close	0      +		  FILE$SUBMIT		= 21,	! Submit on close		0      +		  FILE$DELETE		= 22,	! Delete on close		?      +		  FILE$CONTIGUOUS_BEST_TRY = 23,! Contiguous best try		 0      +		  FILE$FOP24		= 24,	! Reserved for WAT		6      +		  FILE$DEFERRED_WRITE	= 25,	! Deferred write		:      +		  FILE$TRUNCATE		= 26,	! Truncate at EOF on close	7      +		  FILE$OUTPUT_PARSE	= 27,	! Output file parse		 )      +		  FILE$FOP28		= 28,	! Reserved			 )      +		  FILE$FOP29		= 29,	! Reserved				)      +		  FILE$FOP30		= 30,	! Reserved			s(      +		  FILE$FOP31		= 31	! Reserved			   C G C These parameters needed for the 'device_characteristics' field of the < C FILE$ATTRIBUTES record. They are bit position definitions. C   @ 	parameter FILE$RECORD_ORIENTED       = 0,     ! Record orientedG      +		  FILE$CARRIAGE_CONTROL	     = 1,     ! Carriage control device 3      +		  FILE$TERMINAL		     = 2,     ! Terminal		 D      +		  FILE$DIRECTORY_STRUCTURED  = 3,     ! Directory structuredA      +		  FILE$SINGLE_DIRECTORY	     = 4,     ! Single directory		A      +		  FILE$SEQUENTIAL_DEVICE     = 5,     ! Sequential device /      +		  FILE$DEV6		     = 6,     ! Reserved		e=      +		  FILE$FILES_ORIENTED	     = 7,     ! Files-oriented	t3      +		  FILE$SHAREABLE	     = 8,     ! Shareable		5      +		  FILE$SPOOLED	    	     = 9,     ! Spooled		 1      +		  FILE$MOUNTED		     = 10,    ! Mounted		iB      +		  FILE$DISMOUNT_MARKED	     = 11,    ! Marked for dismount3      +		  FILE$ALLOCATED	     = 12,    ! Allocated	 9      +		  FILE$INPUT_DEVICE	     = 13,    ! Input device	+;      +		  FILE$OUTPUT_DEVICE	     = 14,    ! Output device	aE      +		  FILE$SOFTWARE_WRITE_LOCKED = 15,    ! Software write-locked 3      +		  FILE$AVAILABLE	     = 16,    ! Available	tE      +		  FILE$ERROR_LOG_ENABLE	     = 17,    ! Error logging enabledu1      +		  FILE$MAILBOX		     = 18,    ! Mailbox		 3      +		  FILE$REALTIME		     = 19,    ! Realtime		=5      +		  FILE$RANDOM		     = 20,    ! Random access	sE      +		  FILE$READCHECK_ENABLED     = 21,    ! Read checking enabled F      +		  FILE$WRITECHECK_ENABLED    = 22,    ! Write checking enabled8      +		  FILE$FOREIGN		     = 23,    ! Mounted foreign	7      +		  FILE$NETWORK		     = 24,    ! Network device		7      +		  FILE$GENERIC		     = 25,    ! Generic device	,0      +		  FILE$DEV26		     = 26,    ! Reserved		0      +		  FILE$DEV27		     = 27,    ! Reserved		0      +		  FILE$DEV28		     = 28,    ! Reserved		0      +		  FILE$DEV29		     = 29,    ! Reserved		0      +		  FILE$DEV30		     = 30,    ! Reserved		/      +		  FILE$DEV31		     = 31    ! Reserved		-  # 	structure /FILE$ATTRIBUTES_RECORD/  		byte        organization 		byte        record_format  		byte        record_attributes+ 		byte        bucket_size ! 		integer*2   maximum_record_sizer 		integer*2   block_size  		integer*2   fixed_control_size' 		integer*2   default_extension_quality-# 		integer*2   longest_record_length  		integer*2   first_free_byte # 		integer*4   maximum_record_numberp 		integer*4   file_options$ 		integer*4   device_characteristics! 		integer*4   allocation_quantity	 		integer*4   highest_blocku 		integer*4   end_of_file_blockr# 		integer*4   starting_block_number  		integer*4   revision number4 		integer*4   creation_date(2)  		integer*4   revision_date(2)-!  		integer*4   expiration_date(2)   		integer*4   backup_date(2)r 		integer*4   ownera 		integer*2   protection4 		record /eln$varying_string_255/ resultant_fi                                                                                                                                                                                                                                                   t                        ¥a $      ELN042.D                         
  -[SYSEXE.SEAS$WORK_0000005C]FORTRAN_DEFS.FOR;1                                                                                  N     ?                         x "     #       lename 	end structure  			   ! . !  Define eln$copy_file options mask constants ! @ 	PARAMETER COPY$BLOCK_MODE_MASK = '00000001'X !  Block mode copyB 	PARAMETER COPY$RECORD_MODE_MASK = '00000002'X !  Record mode copyG 	PARAMETER COPY$AUTOMATIC_MODE_MASK = '00000004'X !  Do the Right ThingmG 	PARAMETER COPY$CONTIGUOUS_MASK = '00000008'X !  Contiguous output filerN 	PARAMETER COPY$NO_CONTIGUOUS_MASK = '00000010'X !  Non-contiguous output fileJ 	PARAMETER COPY$TRUNCATE_MASK = '00000020'X !  Truncate output file to EOFA 	PARAMETER COPY$RESERVED = '00000040'X	!  Reserved for future use     < C     ------------------------------------------------------   	structure /eln$time_record/ 		integer*2 year 		integer*2 month  		integer*2 day  		integer*2 hour 		integer*2 minute 		integer*2 second 		integer*2 hundredth_ 	end structure  < C     ------------------------------------------------------   	structure /dsc$descriptor/  		integer*2 dsc$w_length 		byte dsc$b_dtype 		byte dsc$b_class 		integer*4 dsc$a_pointern 	end structure  < C     ------------------------------------------------------     	parameter status$text = 1,       +		  status$ident = 2,       +		  status$severity = 4,      +		  status$facility =8,-      +    	  status$all = 15  < C     ------------------------------------------------------  : 	parameter NAME$LOCAL = 0,NAME$UNIVERSAL = 1,NAME$BOTH = 2/ 	parameter EVENT$CLEARED = 0,EVENT$SIGNALED = 1	  ; C This structure is the signal array for exception handling  	structure /chf$signal_array/- 		integer*4 chf$l_sig_args 		integer*4 chf$l_sig_name 		integer*4 chf$l_sig_arg1 	end structure  4 C  Define stack frame offsets for exception handling   	PARAMETER SF$M_C = '00000001'X- 	PARAMETER SF$M_V = '00000002'X- 	PARAMETER SF$M_Z = '00000004'Xe 	PARAMETER SF$M_N = '00000008'Xr" 	PARAMETER SF$M_TBIT = '00000010'X  	PARAMETER SF$M_IV = '00000020'X  	PARAMETER SF$M_FU = '00000040'X  	PARAMETER SF$M_DV = '00000080'X 	STRUCTURE /mch$frame_def/D 	    INTEGER*4 SF$A_HANDLER			!  Adr. of handler or 0 if no handler 
 	    UNION 	        MAP0 	        INTEGER*2 SF$W_SAVE_PSW			!  saved PSW  	        END MAP 	        MAP! 	            PARAMETER SF$S_C = 1 - 	            PARAMETER SF$V_C = 0			!  carry =! 	            PARAMETER SF$S_V = 1q0 	            PARAMETER SF$V_V = 1			!  overflow ! 	            PARAMETER SF$S_Z = 1 , 	            PARAMETER SF$V_Z = 2			!  zero ! 	            PARAMETER SF$S_N = 1q0 	            PARAMETER SF$V_N = 3			!  negative $ 	            PARAMETER SF$S_TBIT = 1< 	            PARAMETER SF$V_TBIT = 4			!  trace trap enable " 	            PARAMETER SF$S_IV = 1@ 	            PARAMETER SF$V_IV = 5			!  integer overflow enable " 	            PARAMETER SF$S_FU = 1B 	            PARAMETER SF$V_FU = 6			!  floating underflow enable " 	            PARAMETER SF$S_DV = 1" 	            PARAMETER SF$V_DV = 7: 	            BYTE %FILL (1)				!  decimal overflow enable  	        END MAP 	    END UNION
 	    UNION 	        MAPE 	        INTEGER*2 SF$W_SAVE_MASK		!  saved register mask plus flags u 	        END MAP 	        MAP* 	            PARAMETER SF$S_SAVE_MASK = 12A 	            PARAMETER SF$V_SAVE_MASK = 0		!  register save mask - !  MBZ -% 	            PARAMETER SF$S_CALLS = 1 6 	            PARAMETER SF$V_CALLS = 13		!  1 if CALLS ) 	            PARAMETER SF$S_STACKOFFS = 2l* 	            PARAMETER SF$V_STACKOFFS = 14, 	            BYTE %FILL (2)				!  SP offset  	        END MAP 	    END UNION* 	    INTEGER*4 SF$L_SAVE_AP			!  saved AP * 	    INTEGER*4 SF$L_SAVE_FP			!  saved FP * 	    INTEGER*4 SF$L_SAVE_PC			!  saved PC E 	    INTEGER*4 SF$L_SAVE_REGS		!  first register saved is saved here c 	END STRUCTURE	! mch$frame_def  4 C This is the mechanism array for exception handling 	structure /chf$mech_array/- 		integer*4 chf$l_mch_args 		integer*4 chf$l_mch_frame_ptr	 		integer*4 chf$l_mch_depthc 		integer*4 chf$l_mch_savr0- 		integer*4 chf$l_mch_savr1- 	end structure    F C -------------------------------------------------------------------- Cr* C These constants needed to set protection C    	parameter eln$prot_system = 1,6      +  	  eln$prot_owner = 16,D       +  	  eln$prot_group = 256,!      + 		  eln$prot_world = 4096,       +  	  eln$prot_read = 1,c      +  	  eln$prot_write = 2,       +  	  eln$prot_execute = 4,      +  	  eln$prot_delete = 8,1#      +            eln$prot_null = 0       F C -------------------------------------------------------------------- C . C These definitions needed for the DDA utility C   - 	parameter DDA$TTY_TERMINAL_CHAR_REVISION = 2I+ 	parameter DDA$TTY_MODEM_EVENT_REVISION = 1   )      	parameter dda$_modem_connected = 0,C,      +	          dda$_modem_disconnected = 1     C	{ Modem Control Types }_  ) 	parameter dda$_modem_control_driver = 0,e%      +		  dda$_modem_control_user = 1.  ! 	parameter dda$_parity_space = 0, &      +            dda$_parity_odd = 1,'      +            dda$_parity_even = 2, '      +            dda$_parity_mark = 3, (      +            dda$_parity_ignore = 4   C	{ Terminal Line Speed Types }=   	parameter dda$_rate_none = 0,      +		  dda$_rate_50 = 1, "      +	          dda$_rate_75 = 2,#      +	          dda$_rate_110 = 3,5%      +	          dda$_rate_134_5 = 4, #      +	          dda$_rate_150 = 5,I#      +	          dda$_rate_300 = 6, #      +	          dda$_rate_600 = 7,h$      +	          dda$_rate_1200 = 8,$      +	          dda$_rate_1800 = 9,%      +	          dda$_rate_2000 = 10,$%      +	          dda$_rate_2400 = 11, %      +	          dda$_rate_3600 = 12,=%      +	          dda$_rate_4800 = 13,F%      +	          dda$_rate_7200 = 14,+%      +	          dda$_rate_9600 = 15, &      +	          dda$_rate_19200 = 16,%      +	          dda$_rate_38400 = 17o     C	{ Terminal Interface Types }   	parameter dda$_type_cx =  0,t$      +	          dda$_type_dhv =  1,$      +	          dda$_type_dht =  2,#      +	          dda$_type_dz =  3,t$      +	          dda$_type_dmf =  4,$      +	          dda$_type_dmb =  5,$      +	          dda$_type_lat =  6,$      +	          dda$_type_rem =  7,%      +	          dda$_type_xwin =  8,e#      +            dda$_type_con = 9      C	{ DDA Device Classes }   	parameter dda$_class_tty = 0,#      +	          dda$_class_lat = 1_    9 C	{ TTY Get/Set Characteristics Information Definitions }   1         structure /dda$_terminal_characteristics/! 		integer*2 class  		integer*2 dev_type 		integer*4 revision 		logical*1 echo 		logical*1 passall= 		logical*1 escape 		logical*1 eight_bitE 		logical*1 scope1 		logical*1 host_synco 		logical*1 tty_sync 		logical*1 parity 		logical*1 parity_typee 		logical*1 char_sizeL 		logical*1 ddcmpp 		logical*1 lc_res1  		integer*2 line_speed 		logical*1 modem_support+ 		logical*1 modem_controll 		logical*1 ring 		logical*1 cd 		logical*1 cs 		logical*1 dsrs 		logical*1 dtr  		logical*1 rts	 		logical*1 passthru 	end structure  6 C	{ TTY Receive Modem Events Information Definitions }  ) 	structure /dda$_modem_event_information/	 		integer*4 revision       		byte modem_control                  byte modem_state 		logical*1 ring 		logical*1 cd   		logical*1 cs   		logical*1 dsr	 		logical*1 dtr  		logical*1 rts  	end structure       	parameter LAT$MAX_SERVICES = 8  	parameter LAT$MAX_LINKS = 4  $ 	parameter LAT$NODE_CHAR_VERSION = 1( 	parameter LAT$NODE_COUNTERS_VERSION = 1* 	parameter LAT$SERVER_COUNTERS_VERSION = 1* 	parameter LAT$DEVICE_COUNTERS_VERSION = 1$ 	parameter LAT$PORT_CHAR_VERSION = 1& 	parameter LAT$SERVER_CHAR_VERSION = 1  ! 	parameter lat$reserved_port = 0,T      +		  lat$application = 1,      +		  lat$dedicated = 2,      +		  lat$interactive = 3I     	parameter lat$node = 0,      +		  lat$device = 1,       +		  lat$server = 2  # 	parameter lat$set_auto_rating = 1, %      +		  lat$set_disable_groups = 2,s$      +		  lat$set_enable_groups = 4,      +		  lat$set_ident = 8,      +		  lat$set_link = 16,!      +		  lat$set_multicast = 32,+      +		  lat$set_node = 64,      +		  lat$set_port = 128,I&      +		  lat$set_queued_status = 256,       +		  lat$set_service = 512,&      +		  lat$set_static_rating = 1024     	structure /lat$groups/   		integer*4 lat$group_array(0:7) 	end structure   	, 	structure /lat$link_char/% 		record /eln$varying_string_16/ nameO& 		record /eln$varying_string_32/device 		integer*4 service_countt 		record /lat$groups/ groups 		logical*1 state  		byte lc_reserved(1) ; 		record /eln$varying_string_16/ services(lat$max_services)  	end structure     	structure /lat$service/ 		logical*1 static_ratingI 		byte service_rating - 		record /eln$varying_st                                                                                                                                                                                                                                                   u                         V_ $      ELN042.D                         
  -[SYSEXE.SEAS$WORK_0000005C]FORTRAN_DEFS.FOR;1                                                                                  N     ?                               4       ring_16/ service_name . 		record /eln$varying_string_64/ service_ident 	end structure    $ 	parameter lat$inval_start_msg = 0, *      +            lat$zero_node_index = 1,%      +		  lat$node_cir_idx_inval = 2,I-      +            lat$node_cir_seq_inval = 3, %      +		  lat$node_idx_not_valid = 4,e%      +		  lat$cir_forced_to_halt = 5,2%      +		  lat$inval_serv_slot_id = 6,E&      +		  lat$inval_node_slot_idx = 7,-      +            lat$inval_credit_field = 8, #      +		  lat$rept_create_slot = 9,e'      +		  lat$inval_seq_num_recvd = 10,,&      +		  lat$rept_discon_of_slot = 11     	structure /lat$node_counters/' 		record /large_integer/ receive_frames ' 		record /large_integer/ receive_errors	+ 		record /large_integer/ receive_duplicatesd( 		record /large_integer/ transmit_frames( 		record /large_integer/ transmit_errors! 		integer*4 last_transmit_failure ( 		record /large_integer/ retransmissions) 		record /large_integer/ circuit_timeoutst( 		record /large_integer/ protocol_errors 		integer*4 protocol_bit_mask ( 		record /large_integer/ resource_errors+ 		record /large_integer/ no_transmit_bufferc& 		record /large_integer/ unit_timeouts. 		record /large_integer/ solicitation_failures/ 		record /large_integer/ discarded_output_bytesg 	end structure    	structure /lat$server_counters/- 		record /eln$varying_string_255/ server_names' 		record /large_integer/ receive_framesa( 		record /large_integer/ transmit_frames( 		record /large_integer/ retransmissions* 		record /large_integer/ out_of_seq_frames) 		record /large_integer/ invalid_messages & 		record /large_integer/ invalid_slots 	end structure 		) 	parameter lat$rec_block_check_error = 0,k$      +		  lat$rec_framing_error = 1,$      +		  lat$rec_frame_too_long = 2      < C These constants are the bit positions for device_counters  C and not the bit masks.  , 	parameter lat$xmt_excessive_collisions = 0,*      +			lat$xmt_carrier_check_failed = 1,#      +			lat$xmt_short_circuit = 2,u"      +			lat$xmt_open_circuit = 3,$      +			lat$xmt_frame_too_long = 4,,      +			lat$xmt_remote_failure_to_defer = 5      e    	structure /lat$device_counters/* 		record /eln$varying_string_32/ line_name2 		record /large_integer/ seconds_since_last_zeroed- 		record /large_integer/ data_blocks_received	2 		record /large_integer/ multicast_blocks_received( 		record /large_integer/ receive_failure' 		record /large_integer/ bytes_received-1 		record /large_integer/ multicast_bytes_receivedr& 		record /large_integer/ data_overruns, 		record /large_integer/ local_buffer_errors) 		record /large_integer/ data_blocks_sent-. 		record /large_integer/ multicast_blocks_sent2 		record /large_integer/ blocks_sent_mlt_collision3 		record /large_integer/ blocks_sent_sngl_collision 3 		record /large_integer/ blocks_sent_initl_deferred # 		record /large_integer/ bytes_sent-- 		record /large_integer/ multicast_bytes_sent & 		record /large_integer/ send_failures8 		record /large_integer/ collisions_detect_check_failure7 		record /large_integer/ unrecognized_frame_destinationr0 		record /large_integer/ user_buffer_unavailable  		integer*4 receive_failures_map 		integer*4 send_failures_mapd 	end structure     	structure /lat$node_char /x% 		record /eln$varying_string_16/ name & 		record /eln$varying_string_64/ ident 		record /lat$groups/ groups 		byte seconds 		logical*1 state0 		byte version
 		byte eco 		integer*4 service_countR9 		record /lat$service/ lat$service_list(lat$max_services)P 		integer*4 link_count- 		record /lat$link_char/ links(lat$max_links)R 	end structure   	structure /lat$port_char/ 		byte port_type 		logical*1 queued_status ' 		record /eln$varying_string_32/ name		 * 		record /eln$varying_string_16/ link_name- 		record /eln$varying_string_255/ server_nameS 		byte res1(1)+ 		record /eln$varying_string_255/ port_name  		byte res2(1). 		record /eln$varying_string_255/ service_name 		byte res3(1)/ 		record /eln$varying_string_255/ actual_server  		byte res4(1)- 		record /eln$varying_string_255/ actual_port_ 		byte res5(1) 	end structure   	structure /lat$server_char/- 		record /eln$varying_string_255/ server_namep 		logical*1 active 		byte address(6)V% 		record /large_integer/ active_users5* 		record /eln$varying_string_16/ link_name 	end structure      F C -------------------------------------------------------------------- C / C These definitions needed for the SCSI utilityT CS  # 	parameter SCSI$K_MAX_UNITS    = 8,	*      +            SCSI$K_MSG_CONFIG   = 1,)      +	          SCSI$K_MSG_ATT      = 2,M)      +	          SCSI$K_MSG_CMD      = 1,a'      +	          SCSI$K_READ	      = 1,E(      +	          SCSI$K_WRITE	      = 0,)      +	          SCSI$K_DISCONNECT   = 1,T)      +	          SCSI$K_NODISCONNECT = 0,k'      +	          SCSI$K_SYNC	      = 1,_)      +	          SCSI$K_NOSYNC	      = 0,L)      +	          SCSI$K_NORETRY      = 1,T'      +	          SCSI$K_RETRY	      = 0M  ! 	structure /scsi$config_tbl_type/  		byte valid_data! 		byte device_type 		byte class_attachedI 		byte current_connectionE$                 byte removable_media 		byte product_id(0:15)  	end structure  ! 	structure /scsi$config_tbl_data/G@ 		record /scsi$config_tbl_type/ config_tbl(0:SCSI$K_MAX_UNITS-1) 	end structure   	structure /scsi$config_msg/ 		integer*4 error_code 		integer*4 msg_obje 		integer*4 msg_size+ 		record /scsi$config_tbl_data/ config_infoc 	end structure                                                                                                                                                                                                                      + * [SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1 +  ,    . j   /     4     j  k                    - 
    0   1    2   3      K  P   W   O k   5 i  6  iߓ  7 ?^  8          9          G    H  J        
              %
   VAX-11 Librarian V04-00         zߓ  N !               j  k          2   2   ?             w         >                                                                   #                                                                                                                                                                                                                                                                                                                            ASSIGN    CLOSEG    
COM$$R50WD_R6:    ELN$ADD_INTERLOCKED=    ELN$ADD_LARGE_INTEGERS_LIST3    ELN$CREATE_MUTEX3    ELN$DELETE_MUTEX7    ELN$DISABLE_INTERRUPT7    ELN$ENABLE_INTERRUPT?    
ELN$ESTABLISH3    ELN$INITIALIZE_AREA_LOCK8    ELN$INSERT_ENTRY3    
ELN$LOCK_AREA3    ELN$LOCK_MUTEX:    ELN$MFPR:    ELN$MTPR:    ELN$READ_BYTE_REGISTER:    ELN$READ_LONG_REGISTER:    ELN$READ_WORD_REGISTERN$WRITE_BYTE_REGISTER:    ELN$WRITE_WORD_REGISTER           X         G    
COM$$R50WD    
COM$ASSIGN    	COM$CLOSE    
COM$FDBSETA    
COM$IRAD50E    
COM$R50ASCC    	COM$RAD50I    
COM$USEREX?    
ELN$ESTABLISH:    
ELN$INLINE7    
ELN$INTERRUPT=    ELN$LARGE_INTEGER_MATH3    	ELN$MUTEX8    	ELN$QUEUE    
FOR$$ASSOC    FOR$$CBs    FOR$$CLOSE_FILE    FOR$$DISPATCH_T    
FOR$$ERROR    FOR$$EXIT_HANDL    
FOR$$FMTCP    FOR$$FMT_INTRP    FOR$$IO_BEG    FOR$$NML_TABLES    
FOR$BACKSPACEK    
FOR$BITOPS    	FOR$CLOSE   l         8    ELN$REMOVE_ENTRY8    ELN$START_QUEUE=    ELN$SUB_LARGE_INTEGERS_LIST=    ELN$TIME_FIELDS_LIST3    ELN$UNLOCK_AREA3    ELN$UNLOCK_MUTEX:    ELN$WRITE_BYTE_REGISTER:    ELN$WRITE_LONG_REGISTER:    ELN$WRITE_WORD_REGISTER    FDBSET    FOR$$AA_LUB_TAB    FOR$$AA_REC_PR0    FOR$$AA_REC_PR1    FOR$$AA_REC_PR9    FOR$$AA_UDF_PR0    FOR$$AA_UDF_PR9    
FOR$$ASSOC    FOR$$A_CUR_LUB    
FOR$$CB_FETCH    FOR$$CB_GET    FOR$$CB_POP   
FOR$DECODE_MOEX\#            ELN$READ_WORD_REGISTER   FOR$$AA_UDF_PR0   FOR$$CB_POP   FOR$$OPEN_DEFLT   
FOR$$REC_RSN1   
FOR$$REC_WIF1   
FOR$$REC_WSL0   FOR$$UDF_RL9   
FOR$BACKSPACE   
FOR$DECODE_MO
   FOR$IISHFTC   FOR$IO_LU_V
   
FOR$JIBSET   FOR$K_CLOERR   FOR$K_ERRDURWRI   FOR$K_INPRECTOO   FOR$K_OPEDEFREQ	   FOR$K_VFEVALERR   FOR$TIME   FOR$_ENDFILERR    FOR$_FMTIO_UNF   FOR$_IO_NONFOR   FOR$_REWRITERR   USEREX                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    v                        ~ $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                        d "                     K    FOR$IMVBITSc    FOR$INI_DES1_R2c    FOR$INI_DES2_R3c    FOR$INI_DESC_R6    FOR$INQUIREe    
FOR$IO_B_Re    
FOR$IO_B_Ve    FOR$IO_DC_Re    FOR$IO_DC_Ve    
FOR$IO_D_Re    
FOR$IO_D_V    
FOR$IO_ENDe    FOR$IO_FC_Re    FOR$IO_FC_Ve    
FOR$IO_F_Re    
FOR$IO_F_Ve    FOR$IO_GC_Re    FOR$IO_GC_Ve    
FOR$IO_G_Re    
FOR$IO_G_Ve    
FOR$IO_H_Re    
FOR$IO_H_Ve    FOR$IO_LU_Re    FOR$IO_LU_V   
FOR$IO_W_VK    
FOR$JIBCLRK    
FOR$JIBITSK    
FOR$JIBSETRT         [    FOR$K_FAC_NO[    FOR$K_FILNAMSPE[    FOR$K_FILNOTFOU[    FOR$K_FINERR[    FOR$K_FLOOVE[    FOR$K_FLOUND[    FOR$K_FLOZERDIV[    FOR$K_FORVARMIS[    FOR$K_INCFILORG[    FOR$K_INCKEYCHG[    FOR$K_INCOPECLO[    FOR$K_INCRECLEN[    FOR$K_INCRECTYP[    FOR$K_INFFORLOO[    FOR$K_INPCONERR[    FOR$K_INPRECTOO[    FOR$K_INPSTAREQ[    FOR$K_INSVIRMEM[    FOR$K_INTOVF[    FOR$K_INTZERDIV[    FOR$K_INVARGFORA    IRAD50E    R50ASCC    RAD50I    USEREX  [         [    FOR$K_INPSTAREQ[    FOR$K_INSVIRMEM[    FOR$K_INTOVF[    FOR$K_INTZERDIV[    FOR$K_INVARGFOR[    FOR$K_INVKEYSPE[    FOR$K_INVLOGUNI[    FOR$K_INVREFVAR[    FOR$K_KEYVALERR[    FOR$K_LISIO_SYN[    
FOR$K_MAX_ERR[    FOR$K_MIXFILACC[    FOR$K_NOTFORSPE[    FOR$K_NO_CURREC[    FOR$K_NO_SUCDEV[    FOR$K_OPEDEFREQ[    FOR$K_OPEFAI[    FOR$K_OUTCONERR[    FOR$K_OUTSTAOVE[    FOR$K_RECIO_OPEA    IRAD50E    R50ASCC    RAD50I    USEREX                 W"         [    FOR$K_OPEFAI[    FOR$K_OUTCONERR[    FOR$K_OUTSTAOVE[    FOR$K_RECIO_OPE[    FOR$K_RECNUMOUT[    FOR$K_REWERR[    FOR$K_REWRITERR[    FOR$K_SEGRECFOR[    FOR$K_SPERECLOC[    FOR$K_SYNERRFOR[    FOR$K_SYNERRNAM[    FOR$K_TOOMANREC[    FOR$K_TOOMANVAL[    FOR$K_UNIALROPE[    FOR$K_UNLERR[    FOR$K_VFEVALERR[    FOR$K_WRIREAFILo    FOR$LGEo    FOR$LGTo    FOR$LLEo    FOR$LLTq    FOR$RANDU_WA    IRAD50E    R50ASCC    RAD50I    USEREX                        FOR$DEF_FILE    FOR$DEF_FILE_WW    
FOR$ENCODE_MFY    
FOR$ENCODE_MO    FOR$ENDFILE_    FOR$EXIT_    
FOR$EXIT_W    FOR$FINDa    	FOR$IDATEK    
FOR$IIBCLRK    
FOR$IIBITSK    
FOR$IIBSETK    FOR$IISHFTC                                                                                                                                                                                                                                                                                        [    FOR$K_DECSTROVE[    FOR$K_DELERR[    FOR$K_DUPFILSPE[    FOR$K_ENDDURREA[    FOR$K_ENDFILERR[    FOR$K_ERRDURREA[    FOR$K_ERRDURWRI                                                                                                                                                                                                                                                                                                                                                                       K    FOR$JISHFTCK    FOR$JMVBITS[    FOR$K_ADJARRDIM[    FOR$K_ARRREFOUT[    FOR$K_ATTACCNON[    FOR$K_BACERR[    FOR$K_CLOERR                                                                                                                                                                                                                                                                                                                                                                        (         e    
FOR$IO_L_Re    
FOR$IO_L_Ve    FOR$IO_T_DSe    
FOR$IO_T_V_DSe    FOR$IO_WU_Re    FOR$IO_WU_Ve    
FOR$IO_W_Re    
FOR$IO_W_Ve    FOR$IO_X_DAe    FOR$IO_X_NLe    FOR$IO_X_SBe    FOR$IO_X_SEq    FOR$IRANm    	FOR$JDATEK    
FOR$JIBCLRK    
FOR$JIBITSK    
FOR$JIBSET                                                                                                                                                                                                            "         [    FOR$K_WRIREAFILo    FOR$LGEo    FOR$LGTo    FOR$LLEo    FOR$LLT    FOR$OPEN    	FOR$PAUSE    FOR$RABq    	FOR$RANDUq    FOR$RANDU_Wt    FOR$READ_DFv    FOR$READ_DOx    FOR$READ_DUz    FOR$READ_IF|    FOR$READ_IL~    FOR$READ_IO    FOR$READ_SF6    FOR$READ_SL    FOR$READ_SN    FOR$READ_SO    FOR$READ_SU    
FOR$REWIND    
FOR$SECNDS   FOR$STOP    FOR$TIME    FOR$WRITE_IFA    IRAD50E    R50ASCC    RAD50I    USEREX                    _    FOR$EXIT    FOR$FINDa    	FOR$IDATEc    FOR$INI_DES    FOR$INQUIREe    FOR$IO_ELEM    
FOR$IO_ENDm    	FOR$JDATEo    FOR$LEX!   
FOR$MSGDEF    FOR$OPEN    	FOR$PAUSE    FOR$RABq    
FOR$RANDOMt    FOR$READ_DFv    FOR$READ_DOx    FOR$READ_DUz    FOR$READ_IF|    FOR$READ_IL~    FOR$READ_IO    FOR$READ_SF6    FOR$READ_SL    FOR$READ_SN    FOR$READ_SO    FOR$READ_SU    
FOR$REWIND    
FOR$SECNDS   FOR$STOP    FOR$TIME$WRITE_SF                 
FOR$$ERROR   	FOR$CLOSE   
FOR$ENODEF   FOR$TIME   	MTH$CDABS  	MTH$DATAN+   	MTH$GMAX11   	MTH$HSIGNd  	MTH$IMIN0%   	OTS$MULCD.  	OTS$POWDD   SYS$EXIT                                                                                                                                                                                                                                                                                                                    "             
FOR$TIME_T_DS    FOR$WRITE_DF    FOR$WRITE_DO    FOR$WRITE_DU    FOR$WRITE_IF    FOR$WRITE_IL    FOR$WRITE_IOP    FOR$WRITE_SF    FOR$WRITE_SL    FOR$WRITE_SN    FOR$WRITE_SO    FOR$WRITE_SU!   FOR$_ADJARRDIM!   FOR$_ATTACCNON!   FOR$_ATTREANON!   FOR$_BACERR!   FOR$_CLOERR!   FOR$_DELERR!   FOR$_DIRIO_KEY!   FOR$_DUPFILSPE!   FOR$_ENDDURREA!   FOR$_ENDFILERRNOTFOU!   FOR$_FINERR!   FOR$_FLOUNDEXC!   FOR$_FMTIO_UNF                 
FOR$TIME_T_DS    FOR$WRITE_DF    FOR$WRITE_DO    FOR$WRITE_DU    FOR$WRITE_IF    FOR$WRITE_IL    FOR$WRITE_IOP    FOR$WRITE_SF    FOR$WRITE_SL    FOR$WRITE_SN    FOR$WRITE_SO    FOR$WRITE_SU
  LIB$CHAR   	LIB$ICHAR
   	LIB$INDEX?   
LIB$TPARSE  (MTH$$SIGNAL1  <MTH$ABSO   MTH$ACOS6   MTH$AINT>   MTH$ALOG%   MTH$AL_4_OV_PI2  MTH$AMOD6  	MTH$ANINTP  MTH$ASIN:   MTH$ATAN    
MTH$BITOPSR  FMTH$CABS   	MTH$CDABS             FOR$$CB_PUSH    FOR$$CB_RETs    FOR$$CLOSE_FILE   
FOR$$CVT_TYPE    FOR$$DECL_EXITH   FOR$$DO_NML_OUTPUT    FOR$$ERR_ENDHND    FOR$$ERR_OPECLO    FOR$$FMT_COMPIL    FOR$$FMT_INTRP0    FOR$$FMT_INTRP1    
FOR$$FP_MATCH   FOR$$FREE_VM   FOR$$GET_VM    FOR$$IOSTAT_HND    FOR$$IO_BEG    FOR$$IO_IN_PROG    FOR$$L_XIT_LOCK    
FOR$$NEXT_LUN    FOR$$OPECLO_ARG    FOR$$OPEN_DEFLT0    
FOR$$REC_WSF1    
FOR$BACKSPACE                            N    FOR$DATEQ    
FOR$DATE_T_DSS    
FOR$DECODE_MFU    
FOR$DECODE_MO    FOR$DEFINE_FILEW    
FOR$ENCODE_MFY    
FOR$ENCODE_MO    FOR$ENDFILE[    
FOR$ENODEF                                                                                                                                                                                                                                                                                                                                                      FOR$$AA_UDF_PR1    FOR$$AA_UDF_PR9    
FOR$$ASSOC    FOR$$A_CUR_LUB    FOR$$A_NMLKEYWD    FOR$$A_NMLSTATE    
FOR$$CB_FETCH    FOR$$CB_GET    FOR$$CB_POP                                                                                                                                                                                                                                                                                                                                       K    
FOR$BITESTK    
FOR$BJTEST    	FOR$CLOSE,  FOR$CNV_IN_L-  FOR$CNV_IN_O-  FOR$CNV_IN_Z%  
FOR$CNV_OUT_I%  
FOR$CNV_OUT_L%  
FOR$CNV_OUT_O%  
FOR$CNV_OUT_ZN    FOR$DATEQ    
FOR$DATE_T_DSS    
FOR$DECODE_MFU    
FOR$DECODE_MO                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 w                        ԏz $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                         "                         FOR$$EXIT_HANDL    
FOR$$FMTCP    FOR$$FMT_INTRP    FOR$$IO_BEG    FOR$$NML_TABLES    FOR$$OPEN_DEFLT    FOR$$OPEN_KEYWD    
FOR$$REC_PROC    FOR$$SIGNAL   FOR$$UDF_RF   FOR$$UDF_RL   FOR$$UDF_RN    FOR$$UDF_RU   FOR$$UDF_WF   FOR$$UDF_WL   FOR$$UDF_WN   FOR$$UDF_WU   FOR$$VM    
FOR$BACKSPACEK    
FOR$BITOPS    	FOR$CLOSE                                                                                                                        FOR$$OPEN_KEYWD    FOR$$OPEN_PROC    FOR$$REC_RD0    FOR$$REC_RD1    FOR$$REC_RD9    
FOR$$REC_RIF0    
FOR$$REC_RIF1    
FOR$$REC_RIF9    
FOR$$REC_RIL0    
FOR$$REC_RIL1    
FOR$$REC_RIL9    
FOR$$REC_RMF0    
FOR$$REC_RMF1    
FOR$$REC_RMF9    
FOR$$REC_RSF0    
FOR$$REC_RSF1    
FOR$$REC_RSF9    
FOR$$REC_RSL0    
FOR$$REC_RSL1    
FOR$$REC_RSL9    
FOR$$REC_RSN0    
FOR$$REC_RSN1    FOR$$REC_WD9    
FOR$$REC_WIF0    
FOR$$REC_WIF1 h             
FOR$$REC_WSL1    
FOR$$REC_WSL9    
FOR$$REC_WSN0    
FOR$$REC_WSN1    
FOR$$REC_WSU0    
FOR$$REC_WSU1    
FOR$$REC_WSU9    FOR$$SIGNAL    FOR$$SIGNAL_STO    FOR$$SIG_DATCOR    FOR$$SIG_FATINT    FOR$$SIG_NO_LUB   FOR$$UDF_RF0   FOR$$UDF_RF1   FOR$$UDF_RF9   FOR$$UDF_RL0   FOR$$UDF_RL1   FOR$$UDF_RL9   FOR$$UDF_RN0   FOR$$UDF_RN9    FOR$$UDF_RU0    FOR$$UDF_RU1    FOR$$UDF_RU9   FOR$$UDF_WF0    
FOR$BACKSPACE                    
FOR$$REC_WIF9    
FOR$$REC_WIL0    
FOR$$REC_WIL1    
FOR$$REC_WIL9    
FOR$$REC_WMF0    
FOR$$REC_WMF1    
FOR$$REC_WMF9    
FOR$$REC_WSF0    
FOR$$REC_WSF1    
FOR$$REC_WSF9    
FOR$$REC_WSL0                                                                                                                                                                                                                                                                                                      
FOR$$REC_RSU0    
FOR$$REC_RSU1    
FOR$$REC_RSU9    FOR$$REC_WD0    FOR$$REC_WD1    FOR$$REC_WD9    
FOR$$REC_WIF0    
FOR$$REC_WIF1                                                                                                                                                                                                                                                                                                                                                       D            FOR$$UDF_RN0   FOR$$UDF_RN9    FOR$$UDF_RU0    FOR$$UDF_RU1    FOR$$UDF_RU9   FOR$$UDF_WF0   FOR$$UDF_WF1   FOR$$UDF_WF9   FOR$$UDF_WL0   FOR$$UDF_WL1   FOR$$UDF_WL9   FOR$$UDF_WN0   FOR$$UDF_WN9   FOR$$UDF_WU0   FOR$$UDF_WU1   FOR$$UDF_WU9    
FOR$BACKSPACE                                                                                                                                                                                t"         !   FOR$_KEYIO_DIR!   FOR$_KEYVALERR!   FOR$_LISIO_SYN!   FOR$_MIXFILACC!   FOR$_MORONEREC!   FOR$_NOTFORSPE!   FOR$_NO_CURREC!   FOR$_NO_SUCDEV!   FOR$_OPEDEFREQ!   FOR$_OPEFAI!   FOR$_OPEREQDIS!   FOR$_OPEREQSEQ!   FOR$_OUTCONERR!   FOR$_OUTSTAOVE!   FOR$_RECIO_OPE!   FOR$_RECNUMOUT!   FOR$_REWERR!   FOR$_REWRITERR!   FOR$_SEQIO_DIR!   FOR$_SPERECLOC!   FOR$_SYNERRFOR!   FOR$_TOOMANREC!   FOR$_TOOMANVAL!   FOR$_UNFIO_FMT  w"         !   FOR$_FORVARMIS!   FOR$_INCFILORG!   FOR$_INCKEYCHG!   FOR$_INCOPECLO!   FOR$_INCRECLEN!   FOR$_INCRECTYP!   FOR$_INFFORLOO!   FOR$_INPCONERR!   FOR$_INPRECTOO!   FOR$_INPSTAREQ!   FOR$_INSVIRMEM!   FOR$_INVARGFOR!   FOR$_INVKEYSPE!   FOR$_INVLOGUNI!   FOR$_INVREFVAR!   FOR$_INVTEX!   FOR$_INVTEXREC!   FOR$_IO_NONFOR                                                                                                                             "         !   FOR$_UNIALROPE!   FOR$_UNLERR!   FOR$_VFEVALERR!   FOR$_WRIREAFILA    IRAD50?   LIB$$IDENT_KEY_TABLE?   LIB$$IDENT_STATE_TABLE?   LIB$$UIC_KEY_TABLE?   LIB$$UIC_STATE_TABLE
  LIB$CHAR   	LIB$ICHAR
   	LIB$INDEX?   
LIB$TPARSE>   MTH$$AB_ALOG>   MTH$$AB_ALOG_V:   MTH$$AB_ATAN:   MTH$$AB_ATAN_VT   
MTH$$AB_D_FHI>   
MTH$$AB_F_FHIo  &
MTH$$AB_G_FHI  F
MTH$$AB_H_FHId  
MTH$$DEXP2_R6J   MTH$$EXP2_R4<MTH$ABSH$ALOG>   
MTH$ALOG10   "         !   FOR$_ERRDURREA!   FOR$_ERRDURWRI!   
FOR$_FACILITY!   FOR$_FILNAMSPE!   FOR$_FILNOTFOU!   FOR$_FINERR!   FOR$_FLOUNDEXC!   FOR$_FMTIO_UNF                                                                                                                                                                                                                                                                                                                                                 "         !   FOR$_SEGRECFOR!   FOR$_SEQIO_DIR!   FOR$_SPERECLOC!   FOR$_SYNERRFOR!   FOR$_SYNERRNAM!   FOR$_TOOMANREC!   FOR$_TOOMANVAL!   FOR$_UNFIO_FMT                                                                                                                                                                                                                                                                                                                                            k#         	   FOR$K_VFEVALERR   FOR$TIME   FOR$_ENDFILERR    FOR$_FMTIO_UNF   FOR$_IO_NONFOR   FOR$_REWRITERR!   FOR$_UNFIO_FMT   MTH$$EXP2_R4G  MTH$ABS  
MTH$ALOG10(   MTH$AMOD'   
MTH$CGSQRTU  MTH$DABS&   MTH$DEXP_R7.   MTH$DSINCOSD*   MTH$GABS)   MTH$GCOS_R70   MTH$GLOG_R8/   MTH$GSIN_R7,   MTH$HCOS_R5_R52   MTH$IMOD$   	MTH$JNINT	  MTH$SINCOSD_R5  MTH$TANH-   OTS$DIVC;  
OTS$POWCDJ_R34  	OTS$POWGJ*  USEREX   5              FOR$K_OPEDEFREQ"   MTH$HCOS_R5V  USEREX                                                                                                                                                                                                                                                                                                                                                                                                                                                               tV        7  T	MTH$ININT    MTH$INOT1  <	MTH$JIABS    	MTH$JIAND   	MTH$JIDIM  n 
MTH$JIDINT  Z
MTH$JIDNNT    	MTH$JIEOR  n 	MTH$JIFIX  n 
MTH$JIGINT  ( 
MTH$JIGNNT  n 
MTH$JIHINT   
MTH$JIHNNT  n MTH$JINT    MTH$JIOR    
MTH$JISHFT/  < 
MTH$JISIGN*  	MTH$JMAX04  J 	MTH$JMAX1,  @	MTH$JMIN05  0 	MTH$JMIN1-   MTH$JMOD8   	MTH$JNINT  
MTH$RANDOM  n MTH$REAL9  F MTH$SIGNA  MTH$SINA  
MTH$SINCOSA  MTH$SINCOSDA  MTH$SINCOSD_R5TANHSEREX            7  T	MTH$ININT  Z
MTH$JIDNNT  ( 
MTH$JIGNNT   
MTH$JIHNNT/  < 
MTH$JISIGN*  	MTH$JMAX0,  @	MTH$JMIN08   	MTH$JNINT4  J MTH$MAX15  0 MTH$MIN1-   MTH$MOD  
MTH$RANDOM9  F MTH$SIGNA  
MTH$SINCOSg  2 MTH$SINHL  MTH$SQRTh  fMTH$TAN0   MTH$TANH0  8
OTS$$CVTDT3  
OTS$$CVTRT%  	OTS$CVTLT)   	OTS$CVTTF,  
OTS$CVTTLL-  
OTS$CVTTOL  ~OTS$DIVC!  	OTS$DIVCD"  	OTS$DIVCG:  OTS$MOVE#  	OTS$MULCD$POWCJ  	OTS$POWDD   	OTS$POWRR "           T	MTH$DACOS  T
MTH$DACOSD  T
MTH$DACOSD_R7  TMTH$DACOS_R7  TMTH$DACOS_R9  @	MTH$DASIN  @
MTH$DASIND  @
MTH$DASIND_R7  @MTH$DASIN_R7  @MTH$DASIN_R9M  	MTH$DATANM  
MTH$DATAN2M  
MTH$DATANDM  MTH$DATAND2M  
MTH$DATAND_R7M  MTH$DATAN_R7  n MTH$DBLE  n 
MTH$DCMPLX  
MTH$DCONJGW  MTH$DCOSW  	MTH$DCOSDW  MTH$DCOSD_R7   	MTH$DCOSHW  MTH$DCOS_R7   MTH$DDIMd  MTH$DEXPd  MTH$DEXP_R6d  MTH$DEXP_R7INCOSD      "         6  	MTH$ANINTP  MTH$ASINP  	MTH$ASINDP  MTH$ASIND_R4P  MTH$ASIN_R4P  MTH$ASIN_R5:   MTH$ATAN:   	MTH$ATAN2:   	MTH$ATAND:   
MTH$ATAND2:   MTH$ATAND_R4:   MTH$ATAN_R4R  FMTH$CABS[  MTH$CCOS   	MTH$CDABS   	MTH$CDCOS  D	MTH$CDEXP   	MTH$CDLOG   	MTH$CDSIN  
MTH$CDSQRTS  RMTH$CEXPT  z	MTH$CGABSX  	MTH$CGCOSW  	MTH$CGEXP  	MTH$CGLOGX  	MTH$CGSIN   
MTH$CGSQRTA  
MTH$COS_R4  	MTH$CSQRT1  <MTH$DABS                                                                                                                                                                                                                                                             x                        	 $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                         "     (        "         >   
MTH$ALOG10_R5>   	MTH$ALOG2>   MTH$ALOG_R5%   MTH$AL_4_OV_PI%   MTH$AL_4_OV_PI_V4  J 	MTH$AMAX15  0 	MTH$AMIN12  MTH$AMOD                                                                                                                                                                                                                                                                                                                                                                   "           	MTH$GACOS  
MTH$GACOSD  
MTH$GACOSD_R7  MTH$GACOS_R7  MTH$GACOS_R9  	MTH$GASIN  
MTH$GASIND  
MTH$GASIND_R7  MTH$GASIN_R7  MTH$GASIN_R9h  	MTH$GATANh  
MTH$GATAN2h  
MTH$GATANDh  MTH$GATAND2h  
MTH$GATAND_R7h  MTH$GATAN_R7  n 
MTH$GCMPLX  
MTH$GCONJGs   MTH$GCOSs   	MTH$GCOSDs   MTH$GCOSD_R7  n	MTH$GCOSHs   MTH$GCOS_R77o  &MTH$GLOGo  &
MTH$GLOG10o  &
MTH$GLOG10_R8o  &	MTH$GLOG2o  &MTH$GLOG_R8IN_R7 7"         W  MTH$DSINCOSD_R7W  MTH$DSINCOS_R7W  	MTH$DSINDW  MTH$DSIND_R7  t 	MTH$DSINHW  MTH$DSIN_R7g  	MTH$DSQRTg  MTH$DSQRT_R5   MTH$DTAN   	MTH$DTAND   MTH$DTAND_R7  	MTH$DTANH   MTH$DTAN_R7J   MTH$EXPJ   
MTH$EXP_R4  n 
MTH$FLOATI  n 
MTH$FLOATJ1  <MTH$GABS                                                                                                                                                                                                        
MTH$DCONJG   	MTH$DCOSHd  MTH$DEXP   MTH$DIM  MTH$DINTT   MTH$DLOG  V	MTH$DMAX1   	MTH$DMIN1   MTH$DMOD   	MTH$DNINT  ^ 	MTH$DPROD  	MTH$DSIGNW  MTH$DSINCOS  t 	MTH$DSINHg  	MTH$DSQRT   MTH$DTAN  	MTH$DTANHJ   MTH$EXP  	MTH$GACOS  	MTH$GASINh  	MTH$GATAN  
MTH$GCONJG  n	MTH$GCOSH  MTH$GEXP   MTH$GINTo  &MTH$GLOG   	MTH$GMAX1NH  
MTH$IIDNNT.   
MTH$IISIGN*  
 	MTH$IMAX0+  	MTH$IMIN0        "           (	MTH$GSQRT  (MTH$GSQRT_R5  dMTH$GTAN  d	MTH$GTAND  dMTH$GTAND_R7  
	MTH$GTANH  dMTH$GTAN_R71  <MTH$HABS  f	MTH$HACOS  f
MTH$HACOSD  f
MTH$HACOSD_R8  fMTH$HACOS_R8]  f 	MTH$HASIN]  f 
MTH$HASIND]  f 
MTH$HASIND_R8]  f MTH$HASIN_R8  B 	MTH$HATAN  B 
MTH$HATAN2  B 
MTH$HATAND  B MTH$HATAND2  B 
MTH$HATAND_R8  B MTH$HATAN_R8   MTH$HCOS   	MTH$HCOSD   MTH$HCOSD_R5_   	MTH$HCOSH   MTH$HCOS_R5SIND_R5   MTH$HSIN_R5OD    V        h  f
MTH$TAN_R4h  f
MTH$TAN_R53  OTS$$A_CVT_TAB0  8OTS$$CVT_D_T_R80  8OTS$$CVT_F_T_R83  OTS$$CVT_G_T_R83  OTS$$CVT_H_T_R83  OTS$$CVT_MUL3  OTS$$RET_A_CVT_TAB_R1%  OTS$CVT_L_TB%  OTS$CVT_L_TI%  OTS$CVT_L_TL%  OTS$CVT_L_TO%  OTS$CVT_L_TU%  OTS$CVT_L_TZ-  OTS$CVT_TB_L,  OTS$CVT_TL_L-  OTS$CVT_TO_L-  OTS$CVT_TZ_L)   OTS$CVT_T_F  ~OTS$DIVCOTS$MULCG_R3  	OTS$POWCC  : OTS$POWCDCD_R3  
OTS$POWCDJ_R3OTS$POWGJSEREX  Z"           n 
MTH$DFLOTI  n 
MTH$DFLOTJ   MTH$DIM  n 	MTH$DIMAG  MTH$DINT  MTH$DINT_R4T   MTH$DLOGT   
MTH$DLOG10T   
MTH$DLOG10_R8T   	MTH$DLOG2T   MTH$DLOG_R8  V	MTH$DMAX1   	MTH$DMIN1   MTH$DMOD   	MTH$DNINT  ^ 	MTH$DPROD  n 	MTH$DREAL  	MTH$DSIGNW  MTH$DSINW  MTH$DSINCOSW  MTH$DSINCOSD                                                                                                                                                          "            	MTH$GMAX1  	MTH$GMIN1  ZMTH$GMOD  	MTH$GNINT  	MTH$GPROD  n 	MTH$GREAL   	MTH$GSIGNs   MTH$GSINs   MTH$GSINCOSs   MTH$GSINCOSDs   MTH$GSINCOSD_R7s   MTH$GSINCOS_R7s   	MTH$GSINDs   MTH$GSIND_R7  	MTH$GSINHs   MTH$GSIN_R7                                                                                                                                                                                                                                  "           n 	MTH$GDBLE   MTH$GDIM  MTH$GEXP  MTH$GEXP_R6  MTH$GEXP_R7  n 
MTH$GFLOTI  n 
MTH$GFLOTJ  n 	MTH$GIMAG   MTH$GINT   MTH$GINT_R4o  &MTH$GLOGo  &
MTH$GLOG10o  &
MTH$GLOG10_R8o  &	MTH$GLOG2o  &MTH$GLOG_R8                                                                                                                                                                                                                                                         \           	MTH$GMIN1  ZMTH$GMOD  	MTH$GNINT  	MTH$GPROD   	MTH$GSIGNs   MTH$GSINCOS  	MTH$GSINH  (	MTH$GSQRT  dMTH$GTAN  
	MTH$GTANH  f	MTH$HACOS]  f 	MTH$HASIN  B 	MTH$HATAN_   	MTH$HCOSH  MTH$HEXP  PMTH$HINT  FMTH$HLOG  : 	MTH$HMAX1  	MTH$HMIN1  6 MTH$HMOD  t 	MTH$HNINT  	MTH$HSIGN   MTH$HSINCOS  R	MTH$HSQRT  	MTH$HTANH  
MTH$IIDNNT   
MTH$IIGNNT  p
MTH$IIHNNT.   
MTH$IISIGN*  
 	MTH$IMAX0+  	MTH$IMIN0  V          R	MTH$HSQRT  RMTH$HSQRT_R8c  PMTH$HTANc  P	MTH$HTANDc  PMTH$HTAND_R5c  PMTH$HTAND_R7  	MTH$HTANHc  PMTH$HTAN_R5c  PMTH$HTAN_R71  <	MTH$IIABS    	MTH$IIAND   	MTH$IIDIM  n 
MTH$IIDINT  
MTH$IIDNNT    	MTH$IIEOR  n 	MTH$IIFIX  n 
MTH$IIGINT   
MTH$IIGNNT  n 
MTH$IIHINT  p
MTH$IIHNNT  n MTH$IINT    MTH$IIOR    
MTH$IISHFT.   
MTH$IISIGN*  
 	MTH$IMAX04  J 	MTH$IMAX1+  	MTH$IMIN05  0 	MTH$IMIN1-   MTH$IMOD                    4   1       @
 V3.0-01                         9     	ELN$MUTEXV3.0-0110-OCT-1990 22:27                    VAXELN PASCAL V4.2_95 
  e
 냻     e   AREA_LOCK_VARIABLEMUTEXELN$UNLOCK_AREA
ELN$LOCK_AREAELN$INITIALIZE_AREA_LOCKELN$UNLOCK_MUTEXELN$LOCK_MUTEXELN$DELETE_MUTEXELN$CREATE_MUTEX  FLAG  COUNT  
BAREA	 
LOCK_VAR	   
	 

	   
	 

	 
STATUS	   
M	   
M	   
 5   
M	 
	   
M	 
	   I   
KER$SIGNAL  KER$WAIT_ANY  
KER$DELETE  KER$CREATE_SEMAPHORE       P  
       ELN$CREATE_MUTEX 0  ޼P `߼ KER$CREATE_SEMAPHORE  
     ELN$DELETE_MUTEX (     P޼Rb߼ 
KER$DELETE  
  1    ELN$LOCK_MUTEX .  1   P ޼QX
a|~  KER$WAIT_ANY  
  K    ELN$UNLOCK_MUTEX ,  K   P ޼QXa  
KER$SIGNAL%  
  e    ELN$INITIALIZE_AREA_LOCK *  e   P      |~߼ KER$WAIT_ANY  
  {    
ELN$LOCK_AREA+  {   P Xݼ|~  KER$WAIT_ANY   
      ELN$UNLOCK_AREA)     P Xݼ  
KER$SIGNAL        $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                 1       . 1-011                           9     FOR$READ_SL1-01110-OCT-1990 22:30                 N  VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADSL/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADSL ELN_BUILD:[ELN.FORRTL.SRC]FORREADSL+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIBL*  - entry point for FORTRAN READ SEQUENTIA   FOR$$IO_BEG  
FOR$$REC_RSL0  
FOR$$REC_RSL1  
FOR$$REC_RSL
     1         V3.0-01                         =     
ELN$INTERRUPTV3.0-0110-OCT-1990 22:27                    VAXELN PASCAL V4.2_95 
  e
 7L    E  e    ELN$ENABLE_INTERRUPTELN$DISABLE_INTERRUPT  
IPL	        P"  
       ELN$DISABLE_INTERRUPT	  ڼ !  
      ELN$ENABLE_INTERRUPT        
   $CODE     $DATA         w w                                                                                                                             	 9   1       @ V3.2-00                         9     	ELN$QUEUEV3.2-0010-OCT-1990 22:27                    VAXELN PASCAL V4.2_95 
  e
 Դ      e    ELN$START_QUEUEELN$REMOVE_ENTRYELN$INSERT_ENTRY 
HEADER	 QUEUE_ENTRY 
	 
ENTRY	 
EMPTY	 
POSITION% 	 QUEUE_POSITION 
	 
	 

FIRST_ELEMENT	 
	% 	 
       P  
      ELN$INSERT_ENTRY / ^޼nnR   
  -   ELN$REMOVE_EN                                                                                                                                                                                                                                                   y                         $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                        U "     9            TRY X ޼SSR Լ6SRԼԼ  
     ELN$START_QUEUE ޼Rbbb       $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                              ;   1    
   @ V3.1-01                         :     
ELN$INLINEV3.1-0110-OCT-1990 22:28                   VAXELN PASCAL V4.2_95 
  e
       e   INTEGER_LONGINTEGER_WORDINTEGER_BYTEELN$WRITE_LONG_REGISTERELN$WRITE_WORD_REGISTERELN$WRITE_BYTE_REGISTERELN$READ_LONG_REGISTERELN$READ_WORD_REGISTERELN$READ_BYTE_REGISTERELN$MTPRELN$MFPRELN$ADD_INTERLOCKED$  
DEST% 
REGISTER	 $$ 

% 
	    

% 
	  <    
	 $$ 
	    
	 	 
REGISTER_NUMBER% 
SOURCE%  
%  
DELTA% 

WORD_ARGUMENT	   e       P   
      ELN$ADD_INTERLOCKED ^޼nXnRRRRP   
      ELN$MFPR   ^޼ۮnnP  
  +    ELN$MTPR   ^޼޼nn #  
  >    ELN$READ_BYTE_REGISTER   ^nnP #  
  K    ELN$READ_WORD_REGISTER   ^n2nP #  
  X    ELN$READ_LONG_REGISTER   
     ^мP$  
  b    ELN$WRITE_BYTE_REGISTER  ^޼nn$  
  p    ELN$WRITE_WORD_REGISTER  ^޼nn$  
  ~    ELN$WRITE_LONG_REGISTER  ^޼nn       $CODE     $DATA         w w                                                                                                                                                                                                                                                                                           
 >   1       , V3.0-01                         F     ELN$LARGE_INTEGER_MATHV3.0-0110-OCT-1990 22:28                   VAXELN PASCAL V4.2_95 
  e
 ֔F      e    ELN$TIME_FIELDS_LISTELN$SUB_LARGE_INTEGERS_LISTELN$ADD_LARGE_INTEGERS_LIST 
TVALUE	 
RESULT	 
pTIME_RECORD 
MIN	 
SUB	 
DIFF	 


 
ADD1	 
ADD2	 
SUM	 


    ELN$TIME_FIELDS       P(  
      ELN$ADD_LARGE_INTEGERS_LIST T}R R ؤS}R (  
     ELN$SUB_LARGE_INT     EGERS_LIST# TSR Уbcd ٢ !  
  <   <ELN$TIME_FIELDS_LIST ) <^ ELN$TIME_FIELDS(     U   $CODE     $DATA         w w                                                                                                                                                                                                                                                                                                                                            @   1        w 0                               7     
ELN$ESTABLISH010-OCT-1990 22:28                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]ESTABLISH/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]ESTABLISH ELN_BUILD:[ELN.FORRTL.SRC]ESTABLISH(  - establish exception handling routine         	.  ABS  .       	. BLANK .   P        $ABS$   P P    
       
ELN$ESTABLISH      & ЬP    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  B   1        Y 1-004                           8     
COM$IRAD501-00410-OCT-1990 22:28                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]COMIRAD50/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]COMIRAD50 ELN_BUILD:[ELN.FORRTL.SRC]COMIRAD50*  ; FORTRAN COMPATIBILITY - ASCII to RAD50   
COM$$R50WD_R6          	.  ABS  .    P        $ABS$    P     5   _F4PCOMPAT$CODE        P|   
     | IRAD50  &C <UЬRb 
ТRЬTP 
COM$$R50WD_R6QU    w w                                                                                                                                                                                                                                                                                                                                                                                                              D   1       8 1-004                           7     	COM$RAD501-00410-OCT-1990 22:28                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]COMRAD50/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]COMRAD50 ELN_BUILD:[ELN.FORRTL.SRC]COMRAD50 *  ; FORTRAN COMPATIBILITY - ASCII to RAD50   
COM$$R50WD_R6          	.  ABS  .    P        $ABS$    P     7   _F4PCOMPAT$CODE   P     |   
     | RAD50 &S UЬRb 
ТR 
COM$$R50WD_R6Q 
COM$$R50WD_R6QnnP    w w                                                                                                                                                                                                                                                                                                                                                                                                 
 F   1         1-003                           8     
COM$R50ASC1-00310-OCT-1990 22:28                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]COMR50ASC/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]COMR50ASC ELN_BUILD:[ELN.FORRTL.SRC]COMR50ASC*  ; FORTRAN COMPATIBILITY - RADIX 50 TO AS         	.  ABS  .    P     {   _F4PCOMPAT$CODE 1  P ABCDEFGHIJKLMNOPQRSTUVWXYZ$.?0123456789<@        
 (   <@R50ASC  &S <SЬTЬUQS><PP  Џ  PS'{@  PRPBS{(PRPBS@    w w                                                                                                                                                                                                                                                                                                                                                                                                   
 H   1       T 1-004                           8     
COM$$R50WD1-00410-OCT-1990 22:28                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]COMR50WD/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]COMR50WD ELN_BUILD:[ELN.FORRTL.SRC]COMR50WD *  ; FORTRAN COMPATIBILITY - ASCII TO RADIX  
     
COM$$R50WD_R6         	.  ABS  .    P     g   _F4PCOMPAT$CODE m  PVQSUFSS :O     SZISA	@   S%S0
S90SS$SS.SSPxQQQSxQQSQVU    w w                                                                                                                                                                                                                                                                                                                                                                                                                               	 J   1       ! 1-004                           8     
COM$USEREX1-00410-OCT-1990 22:28                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]COMUSEREX/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]COMUSEREX ELN_BUILD:[ELN.FORRTL.SRC]COMUSEREX*  ; F4P COMPATIBILITY - USER EXIT PROCEDUR4   FOR$$GET_VM  FOR$$SIG_FATINT  
SYS$DCLEXH         	.  ABS  .    P     /   _F4PCOMPAT$CODE                                                                                                                                                                                                                                                    z                        WU $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                        a "     J              P    
       USEREX  &P  FOR$$GET_VMPQՁЬޡa` 
SYS$DCLEXHP  FOR$$SIG_FATINT   w w                                                                                                                                                                                                                                                                                                                                                                                            L   1    
   ` 1-002                           8     
FOR$BITOPS1-00210-OCT-1990 22:28                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORBITOPS/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORBITOPS ELN_BUILD:[ELN.FORRTL.SRC]FORBITOPS  ; MIL-STD 1753 bit operations          	.  ABS  .    P       	_FOR$CODE   P   
      FOR$IMVBITS & <P<Q<RPQPPRQ M       
      FOR$JMVBITS & мPPQQP    
 0     
FOR$IIBITS  & <PPP   
 >     
FOR$JIBITS  &
 P   
 I    FOR$IISHFTC & <P<Q2R  
 Y    FOR$JISHFTC &F мPмQмRQRRQRTQTTQTQTTRRQS SPQSRPTQRSPT RP   
      
FOR$BITEST  & <PPP    
      
FOR$BJTEST  & P   
      
FOR$IIBSET  & <P<QQP     
      
FOR$JIBSET  & мPP    
           
FOR$IIBCLR  & <P<QQP     
      
FOR$JIBCLR  & мPP    w w                                                                                                                                                                                                                                                                                                                                                                                                                                 
 O   1       @ 1-002                           6     FOR$DATE1-00210-OCT-1990 22:28                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORDATE/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORDATE ELN_BUILD:[ELN.FORRTL.SRC]FORDATE&  ; return system date in 9-byte array   
SYS$ASCTIM         	.  ABS  .    P    1   	_FOR$CODE   P<   
     < FOR$DATE  &: ^^RR~Џ      ~^P  `  
SYS$ASCTIM(b(ac   w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                         1        1-011                          _:     FOR$WRITE_SF1-01110-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITSF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITSF ELN_BUILD:[ELN.FORRTL.SRC]FORWRITSF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE SEQUENTI   FOR$$IO_BEG  
FOR$$REC_WSF0  
FOR$$REC_WSF1  
FOR$$REC_WSF
 R   1       @f 1-002                           ;     
FOR$DATE_T_DS1-00210-OCT-1990 22:28                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORDATEDS/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORDATEDS ELN_BUILD:[ELN.FORRTL.SRC]FORDATEDS!  ; return system date to FORTRAN    
SYS$ASCTIM         	.  ABS  .    P    4   	_FOR$CODE   P<   
     < 
FOR$DATE_T_DS &=      ^^RR~Џ ~^P  `  
SYS$ASCTIM	}P,	b Pa    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                      T   1       @J 1-011                           ;     
FOR$DECODE_MF1-01110-OCT-1990 22:28                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORDECOMF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORDECOMF ELN_BUILD:[ELN.FORRTL.SRC]FORDECOMF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN DECODE FORMATT   FOR$$IO_BEG  
FOR$$REC_RMF0  
FOR$$REC_RMF1  
FOR$$REC_R     MF9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     
FOR$DECODE_MF          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                    V   1       Wv 1-011                           ;     
FOR$DECODE_MO1-01110-OCT-1990 22:28                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORDECOMO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORDECOMO ELN_BUILD:[ELN.FORRTL.SRC]FORDECOMO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN DECODE OBJECT-   FOR$$FMT_COMPIL  FOR$$IO_BEG  
FOR$$REC_RMF0  
FOR$$REC     _RMF1  
FOR$$REC_RMF9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     
FOR$DECODE_MO          	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                              X   1        1-011                           ;     
FOR$ENCODE_MF1-01110-OCT-1990 22:28                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORENCOMF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORENCOMF ELN_BUILD:[ELN.FORRTL.SRC]FORENCOMF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN ENCODE FORMATT   FOR$$IO_BEG  
FOR$$REC_WMF0  
FOR$$REC_WMF1  
FOR$$REC_W     MF9  FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     
FOR$ENCODE_MF          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                    Z   1       @΢ 1-011                           ;     
FOR$ENCODE_MO1-01110-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORENCOMO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORENCOMO ELN_BUILD:[ELN.FORRTL.SRC]FORENCOMO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN ENCODE OBJECT-   FOR$$FMT_COMPIL  FOR$$IO_BEG  
FOR$$REC_WMF0  
FOR$$REC     _WMF1  
FOR$$REC_WMF9  FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     
FOR$ENCODE_MO          	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                {                         $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                        l "     [        \   1    >    I 1-003                           8     
FOR$ENODEF1-00310-OCT-1990 22:29                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORENODEF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORENODEF ELN_BUILD:[ELN.FORRTL.SRC]FORENODEF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB %  - FORTRAN error number definitions     ]   FOR$K_ADJARRDIM   M   FOR$K_ARRREFOUT   $   FOR$K_ATTACCNON ]         FOR$K_BACERR      FOR$K_CLOERR   L   FOR$K_DECSTROVE   7   FOR$K_DELERR      FOR$K_DUPFILSPE      FOR$K_ENDDURREA   !   FOR$K_ENDFILERR   '   FOR$K_ERRDURREA   &   FOR$K_ERRDURWRI      FOR$K_FAC_NO   +   FOR$K_FILNAMSPE      FOR$K_FILNOTFOU   9   FOR$K_FINERR   H   FOR$K_FLOOVE   J   FOR$K_FLOUND   I   FOR$K_FLOZERDIV   =   FOR$K_FORVARMIS   3   FOR$K_INCFILORG   2   FOR$K_INCKEYCHG   .   FOR$K_INCOPECLO   %   FOR$K_INCRECLE ^   N   ,   FOR$K_INCRECTYP   <   FOR$K_INFFORLOO   @   FOR$K_INPCONERR      FOR$K_INPRECTOO   C   FOR$K_INPSTAREQ   )   FOR$K_INSVIRMEM   F   FOR$K_INTOVF   G   FOR$K_INTZERDIV   0   FOR$K_INVARGFOR   1   FOR$K_INVKEYSPE       FOR$K_INVLOGUNI      FOR$K_INVREFVAR   -   FOR$K_KEYVALERR   ;   FOR$K_LISIO_SYN   ]   
FOR$K_MAX_ERR       FOR$K_MIXFILACC      FOR$K_NOTFORSPE   5   FOR$K_NO_CURREC   *   FOR$K_NO_SUCDEV      FOR$K_OPEDEFREQ           FOR$K_OPEFAI   ?   FOR$K_OUTCONERR   B   FOR$K_OUTSTAOVE   (   FOR$K_RECIO_OPE      FOR$K_RECNUMOUT      FOR$K_REWERR   6   FOR$K_REWRITERR   #   FOR$K_SEGRECFOR   4   FOR$K_SPERECLOC   >   FOR$K_SYNERRFOR      FOR$K_SYNERRNAM      FOR$K_TOOMANREC      FOR$K_TOOMANVAL   "   FOR$K_UNIALROPEI    8   FOR$K_UNLERR   D   FOR$K_VFEVALERR   /   FOR$K_WRIREAFIL          	.  ABS  .    P        	_FOR$CODE   P    w w                        `   1        7 1-005                           6     FOR$EXIT1-00510-OCT-1990 22:29                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FOREXIT/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FOREXIT ELN_BUILD:[ELN.FORRTL.SRC]FOREXIT  - FORTRAN CALL EXIT    SYS$EXIT         	.  ABS  .    P        	_FOR$CODE   P    
       
FOR$EXIT_W  & l<~	   
      F     OR$EXIT  & l
ݼ SYS$EXIT    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                       
 b   1       @O 1-002                           7     	FOR$IDATE1-00210-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORIDATE/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORIDATE ELN_BUILD:[ELN.FORRTL.SRC]FORIDATE #  ; Time and date as short integers    
SYS$NUMTIM         	.  ABS  .    P    .   	_FOR$CODE   P @  
      @	FOR$IDATE &7 ^^P      ` 
SYS$NUMTIM<PQ{d   PPPPn    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                    d   1        _ 1-021                           9     FOR$INI_DES1-02110-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORINIDES/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORINIDES ELN_BUILD:[ELN.FORRTL.SRC]FORINIDES*  ; FORTRAN array descriptor initialization  
     FOR$INI_DES1_R2 
 J   FOR$INI_DES2_R3 
    FOR$INI_DESC_R6  FOR$_ADJARRDIM  
LIB$SIGN	     AL         	.  ABS  .    P        $ABS$    P      	_FOR$CODE ( P P<`QàRR/RRQ}QRR
RQ FOR$_ADJARRDIM 
LIB$SIGNAL<`Qà RRà$(SS}RRSQSŠ(RS SĠ$RR}RQRR
QS}R<`QޠTVFdUSÅRRRRSVQSTV}uRtSuSdRuRV}RQRR
QS}R   w w                                                                                                                        f   1        \ 2-048B                          :     FOR$IO_ELEM2-048B10-OCT-1990 22:29                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORIOELEM/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORIOELEM ELN_BUILD:[ELN.FORRTL.SRC]FORIOELEM+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB $  ; FORTRAN I/O element transmission<   FOR$$AA_UDF_PR1  FOR$$A_CUR_LUB  FOR$$ERR_ENDHND         	.  A g   BS  .    P        $ABS$ 
   P  P  P    O  	_FOR$CODE   P   
      
FOR$IO_B_V  &
 ߬   
     
FOR$IO_B_R  & ݬ"   
     
FOR$IO_W_V  &
 ߬   
     
FOR$IO_W_R  & ݬ   
 $    
FOR$IO_L_V  &
 ߬   
 +    
FOR$IO_L_R  &Kݬ FOR$$A_CUR_LUB[	MЫPPQQ>e;ϮuY4&{Y4&   Y4&       Y4&ЮQ}}aQKEо?}9CϮ  4&  4&    h    4&        4&ЮQ}}a
Ѐ}P FOR$$A_CUR_LUB[eP FOR$$AA_UDF_PR1544@P$m FOR$$AA_UDF_PR1@    
     FOR$IO_WU_V &
 ߬   
     FOR$IO_WU_R & ݬ14    
     FOR$IO_LU_V &
 ߬   
    FOR$IO_LU_R & ݬ1!    
    
FOR$IO_F_V  &
 ߬   
    
FOR$IO_F_R  & ݬ
1    
 &   
FOR$IO_D_V  &
 ߬   
 -   
FOR$IO_D_R  & ݬ i   1    
 9   
FOR$IO_G_V  &
 ߬   
 @   
FOR$IO_G_R  & ݬ1    
 L   
FOR$IO_H_V  &
 ߬   
 S   
FOR$IO_H_R  & ݬ1   
 _  FOR$IO_FC_V & ެ\   
 g  FOR$IO_FC_R & Ь\
PQ'   
 u  FOR$IO_DC_V & ެ\   
 }  FOR$IO_DC_R & Ь\P  
   FOR$IO_GC_V & ެ\   
   FOR$IO_GC_R & Ь\PQ$m FOR$$A_CUR_LUB[eR FOR$$A
 j   A_UDF_PR1544BR	" \}P~n FOR$$AA_UDF_PR1B֮n FOR$$AA_UDF_PR1B\QQ}P~ FOR$$AA_UDF_PR1B 8 8 8   
   FOR$IO_X_SE &C  FOR$$A_CUR_LUB[ PP[3
313    
 
   FOR$IO_T_DS & }PQ<P~1 H   
    H
FOR$IO_T_V_DS & $m FOR$$A_CUR_LUB[}PQ<P~eP FOR$$AA_UDF_PR1544@P FOR$$AA_UDF_PR1@ЭPV<QQ^`   
 [  FOR$IO_X_DA &,$m  k   FOR$$A_CUR_LUB[eP FOR$$AA_UDF_PR1544@RЬPРT	ET\<`SI
K1G ~S~nnT\fdn FOR$$AA_UDF_PR1BSTTݠ~ FOR$$AA_UDF_PR1B
PQPPQ|~}P~T\$ԮTn FOR$$AA_UDF_PR1B֮n FOR$$AA_UDF_PR1BST   
    FOR$IO_X_SB &~ Ь\ FOR$$A_CUR_LUB[ЬQ*ݬ<lPQP~~$meQ FOR$$AA_UDF_PR1544AQ FOR$$AA_UDF_PR1A "  
 `  FOR$IO_X_NL &Ь\ЬTЬS$m  l   FOR$$A_CUR_LUB[eR FOR$$AA_UDF_PR1544BR^ݬ<l~~	 lTlĬn FOR$$AA_UDF_PR1Bx  P
1InxԮ}nЮ$Ь n FOR$$AA_UDF_PR1B FOR$$AA_UDF_PR1BTT SѮ1 e8Ϯ;$4&B$4&  I$4&      P$4&RRRKRDR=R6Ϯs\4&z\4&  \4&      \4&R FRRRRЫPPQQbP                                                                                                                                                                                                                                                   |                        g< $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                         "     l            eQ FOR$$AA_UDF_PR1544AQn FOR$$AA_UDF_PR1ATS@:о4}.ЮQ}}a"Ѐ}
ЮQ}}aTSP1}n FOR$$AA_UDF_PR1BTS   FOR$$A_CUR_LUBP  ^lhޮ~^}~ FOR$$ERR_ENDHND   w w                                                                                                                                                                                                                                                   
 n   1       ` 1-002                           7     	FOR$JDATE1-00210-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORJDATE/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORJDATE ELN_BUILD:[ELN.FORRTL.SRC]FORJDATE "  ; Time and Date as long integers   
SYS$NUMTIM         	.  ABS  .    P    .   	_FOR$CODE   P @  
      @	FOR$JDATE &7 ^^P `      
SYS$NUMTIM<PQ{d   PPPP22n    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                      p   1       Y 1-001                           5     FOR$LEX1-00110-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORLEX/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORLEX ELN_BUILD:[ELN.FORRTL.SRC]FORLEX    - Lexical comparison functions         	.  ABS  .    P    6   	_FOR$CODE   P   
      FOR$LLT &
 )+  
     FOR$LLE &
 	     !#  
     FOR$LGE &
   
     FOR$LGT & }P}R-Pa RcPP   w w                                                                                                                                                                                                                                                                                                                                                                                                            r   1       o 1-003                           8     
FOR$RANDOM1-00310-OCT-1990 22:29                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORRANDOM/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORRANDOM ELN_BUILD:[ELN.FORRTL.SRC]FORRANDOM*  ; random number generator and interfaces  
     FOR$RANDU_W         	.  ABS  .    P    N   	_FOR$CODE   P    
       	FOR$RANDU      & lPP   
      FOR$IRAN  &B PPPP#ŏ  PQQ NQPD 1  PQQQQ   PPPQ   w w                                                                                                                                                                                                                                                                                                                                                                                           	     1       `O 1-003                           =     FOR$$CLOSE_FILE1-00310-Oct-1990 22:3210-Oct-1990 22:32  VAX Bliss-32 V4.5-862D
   P*    	ELN$CLOSE 
       FOR$$CLOSE_FILEX   @JԫhF*|~~ݫH\ 	ELN$CLOSEPLԫPPPԫFP   R   	_FOR$CODE   w wTHISSELL    FOR$READ_SL$  l  THISSELL    FOR$READ_SN$  ę  THISSELL    FOR$READ_SO$ F  THISSELL    FOR$READ_SU# `A   THISSELL    
FOR$SECNDS   u   1         1-012                           9     FOR$READ_DF1-01210-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADDF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADDF ELN_BUILD:[ELN.FORRTL.SRC]FORREADDF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ DIRECT FO   FOR$$IO_BEG  FOR$$REC_RD0  FOR$$REC_RD1  FOR$$REC_RD9       FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     FOR$READ_DF         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                            w   1       L 1-012                           9     FOR$READ_DO1-01210-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADDO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADDO ELN_BUILD:[ELN.FORRTL.SRC]FORREADDO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ DIRECT OB   FOR$$FMT_COMPIL  FOR$$IO_BEG  FOR$$REC_RD0  FOR$$REC_RD     1  FOR$$REC_RD9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     FOR$READ_DO         	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                      y   1       E| 1-012                           9     FOR$READ_DU1-01210-OCT-1990 22:29                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADDU/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADDU ELN_BUILD:[ELN.FORRTL.SRC]FORREADDU+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ DIRECT UN   FOR$$IO_BEG  FOR$$REC_RD0  FOR$$REC_RD1  FOR$$REC_RD9       FOR$$UDF_RU0  FOR$$UDF_RU1  FOR$$UDF_RU9 
     FOR$READ_DU         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                            {   1       @/ 1-012                           9     FOR$READ_IF1-01210-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADIF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADIF ELN_BUILD:[ELN.FORRTL.SRC]FORREADIF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ INTERNAL    FOR$$IO_BEG  
FOR$$REC_RIF0  
FOR$$REC_RIF1  
FOR$$REC_RIF     9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     FOR$READ_IF          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                        }   1        1-001                           9     FOR$READ_IL1-00110-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADIL/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADIL ELN_BUILD:[ELN.FORRTL.SRC]FORREADIL+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB '  - FORTRAN READ internal list-directed    FOR$$IO_BEG  
FOR$$REC_RIL0  
FOR$$REC_RIL1  
FOR$$REC_RIL9                                                                                                                                                                                                                                                   }                         $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                        'm "     }              FOR$$UDF_RL0  FOR$$UDF_RL1  FOR$$UDF_RL9 
     FOR$READ_IL          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                             1       @h 1-012                           9     FOR$READ_IO1-01210-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADIO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADIO ELN_BUILD:[ELN.FORRTL.SRC]FORREADIO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ INTERNAL    FOR$$FMT_COMPIL  FOR$$IO_BEG  
FOR$$REC_RIF0  
FOR$$REC_R     IF1  
FOR$$REC_RIF9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     FOR$READ_IO          	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                     1         1-011                           9     FOR$READ_SF1-01110-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADSF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADSF ELN_BUILD:[ELN.FORRTL.SRC]FORREADSF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ SEQUENTIA   FOR$$IO_BEG  
FOR$$REC_RSF0  
FOR$$REC_RSF1  
FOR$$REC_RSF     9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     FOR$READ_SF          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                            9  FOR$$UDF_RL0  FOR$$UDF_RL1  FOR$$UDF_RL9 
     FOR$READ_SL          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&
P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                           1       Q 1-001                           9     FOR$READ_SN1-00110-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADSN/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADSN ELN_BUILD:[ELN.FORRTL.SRC]FORREADSN+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB $  - FORTRAN READ Sequential NAMELISTl   FOR$$IO_BEG  
FOR$$REC_RSN0  
FOR$$REC_RSN1  FOR$$UDF_RN0  F     OR$$UDF_RN9 
     FOR$READ_SN         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                                                                     1       " 1-011                           9     FOR$READ_SO1-01110-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADSO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADSO ELN_BUILD:[ELN.FORRTL.SRC]FORREADSO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ SEQUENTIA   FOR$$FMT_COMPIL  FOR$$IO_BEG  
FOR$$REC_RSF0  
FOR$$REC_R     SF1  
FOR$$REC_RSF9  FOR$$UDF_RF0  FOR$$UDF_RF1  FOR$$UDF_RF9 
     FOR$READ_SO          	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                     1        @ 1-012                           9     FOR$READ_SU1-01210-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORREADSU/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORREADSU ELN_BUILD:[ELN.FORRTL.SRC]FORREADSU+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN READ SEQUENTIA   FOR$$IO_BEG  
FOR$$REC_RSU0  
FOR$$REC_RSU1  
FOR$$REC_RSU     9  FOR$$UDF_RU0  FOR$$UDF_RU1  FOR$$UDF_RU9 
     FOR$READ_SU          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                       
    1         1-002                           8     
FOR$SECNDS1-00210-OCT-1990 22:30                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORSECNDS/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORSECNDS ELN_BUILD:[ELN.FORRTL.SRC]FORSECNDS  - GET DELTA TIME   
SYS$NUMTIM         	.  ABS  .    P    G   	_FOR$CODE   P @  
      @
FOR$SECNDS  &P ^^P ` 
SYS$NUMT     IM^<PP<PP<P<QQPNPPMnQFC  Q@QPBP@H P   w w                                                                                                                                                                                                                                                                                                                                                                                                                                                         
    1       	a 1-002                           6     FOR$TIME1-00210-OCT-1990 22:30                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORTIME/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORTIME ELN_BUILD:[ELN.FORRTL.SRC]FORTIME&  ; return system time in 8-byte array   
SYS$ASCTIM         	.  ABS  .    P        	_FOR$CODE   P    
       FOR$TIME  &) Ь~Џ ~     ^P `  
SYS$ASCTIM    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         1         2-001                          6     FOR$OPEN2-00110-Oct-1990 22:3610-Oct-1990 22:36  VAX Bliss-32 V4.5-862     FOR$$ERR_OPECLO   FOR$$OPEN_PROC   FOR$$SIGNAL_STO   FOR$$SIG_NO_LUB   FOR$$CB_PUSH   FOR$$CB_POP   FOR$$OPEN_KEYWD   FOR$$SIG_FATINT   FOR$$CLOSE_FILE    PW  
      FOR$OPENT ^|~|||| |(|0|8|@|H|P|X|`|hρ mltl~  PЮR FOR$$CB_PUSHԮll  P&ի	 FOR$$SIGNAL_STO                                                                                                                                                                                                                                                   ~                        [+fy $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                         "            
    1        1-002                           ;     
FOR$TIME_T_DS1-00210-OCT-1990 22:30                    VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORTIMEDS/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORTIMEDS ELN_BUILD:[ELN.FORRTL.SRC]FORTIMEDS!  ; return system time to FORTRAN    
SYS$ASCTIM         	.  ABS  .    P    *   	_FOR$CODE   P<   
     < 
FOR$TIME_T_DS &3      ЬS c  
SYS$ASCTIMcPcQ, ` Q`    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                   1       `  1-012                           :     FOR$WRITE_DF1-01210-OCT-1990 22:30                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITDF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITDF ELN_BUILD:[ELN.FORRTL.SRC]FORWRITDF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE DIRECT F   FOR$$IO_BEG  FOR$$REC_WD0  FOR$$REC_WD1  FOR$$REC_WD9       FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     FOR$WRITE_DF          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                             1          1-012                           :     FOR$WRITE_DO1-01210-OCT-1990 22:30                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITDO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITDO ELN_BUILD:[ELN.FORRTL.SRC]FORWRITDO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE DIRECT O   FOR$$IO_BEG  FOR$$REC_WD0  FOR$$REC_WD1  FOR$$REC_WD9       FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     FOR$WRITE_DO          	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                           1       @t~ 1-012                           :     FOR$WRITE_DU1-01210-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITDU/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITDU ELN_BUILD:[ELN.FORRTL.SRC]FORWRITDU+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE DIRECT U   FOR$$IO_BEG  FOR$$REC_WD0  FOR$$REC_WD1  FOR$$REC_WD9       FOR$$UDF_WU0  FOR$$UDF_WU1  FOR$$UDF_WU9 
     FOR$WRITE_DU          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                             1       b 1-013                           :     FOR$WRITE_IF1-01310-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITIF/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITIF ELN_BUILD:[ELN.FORRTL.SRC]FORWRITIF+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE INTERNAL   FOR$$IO_BEG  
FOR$$REC_WIF0  
FOR$$REC_WIF1  
FOR$$REC_WIF     9  FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     FOR$WRITE_IF         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                           1       @O 1-001                           :     FOR$WRITE_IL1-00110-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITIL/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITIL ELN_BUILD:[ELN.FORRTL.SRC]FORWRITIL+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB (  - FORTRAN WRITE internal list-directed   FOR$$IO_BEG  
FOR$$REC_WIL0  
FOR$$REC_WIL1  
FOR$$REC_WIL9       FOR$$UDF_WL0  FOR$$UDF_WL1  FOR$$UDF_WL9 
     FOR$WRITE_IL         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                             1       `p 1-013                           :     FOR$WRITE_IO1-01310-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITIO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITIO ELN_BUILD:[ELN.FORRTL.SRC]FORWRITIO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE INTERNAL   FOR$$FMT_COMPIL  FOR$$IO_BEG  
FOR$$REC_WIF0  
FOR$$REC_W     IF1  
FOR$$REC_WIF9  FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     FOR$WRITE_IO         	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                      9  FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     FOR$WRITE_SF         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                           1       `  1-011                           :     FOR$WRITE_SL1-01110-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITSL/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITSL ELN_BUILD:[ELN.FORRTL.SRC]FORWRITSL+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE SEQUENTI   FOR$$IO_BEG  
FOR$$REC_WSL0  
FOR$$REC_WSL1  
FOR$$REC_WSL     9  FOR$$UDF_WL0  FOR$$UDF_WL1  FOR$$UDF_WL9 
     FOR$WRITE_SL         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&	P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  0h $      ELN042.D                         
  +[SYSEXE.SEAS$WORK_0000005C]FRTLOBJECT.OLB;1                                                                                         j                         "                1        1-002                           :     FOR$WRITE_SN1-00210-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITSN/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITSN ELN_BUILD:[ELN.FORRTL.SRC]FORWRITSN+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB %  - FORTRAN WRITE Sequential NAMELIST m   FOR$$IO_BEG  
FOR$$REC_WSN0  
FOR$$REC_WSN1  FOR$$UDF_WN0       FOR$$UDF_WN9 
     FOR$WRITE_SN          	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                                                                 1        1-011                           :     FOR$WRITE_SO1-01110-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITSO/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITSO ELN_BUILD:[ELN.FORRTL.SRC]FORWRITSO+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE SEQUENTI   FOR$$FMT_COMPIL  FOR$$IO_BEG  
FOR$$REC_WSF0  
FOR$$REC_W     SF1  
FOR$$REC_WSF9  FOR$$UDF_WF0  FOR$$UDF_WF1  FOR$$UDF_WF9 
     FOR$WRITE_SO         	.  ABS  .    P    
   	_FOR$CODE +  PFOR$$IO_BEG&<P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                     1       # 1-011                           :     FOR$WRITE_SU1-01110-OCT-1990 22:31                   VAX MACRO V5.0-9  MACRO/NODEBUG/ENABLE=SUPPRESSION/DISABLE=(GLOBAL,TRACEBACK)/CROSS=(MACROS,SYMBOLS)/SHOW=(EXPANSIONS)/LIS=ELN_BUILD:[ELN.FORRTL.LIS]FORWRITSU/OBJ=ELN_BUILD:[ELN.FORRTL.OBJ]FORWRITSU ELN_BUILD:[ELN.FORRTL.SRC]FORWRITSU+ELN_BUILD:[ELN.FORRTL.OBJ]FORRTL/LIB *  - entry point for FORTRAN WRITE SEQUENTI   FOR$$IO_BEG  
FOR$$REC_WSU0  
FOR$$REC_WSU1  
FOR$$REC_WSU     9  FOR$$UDF_WU0  FOR$$UDF_WU1  FOR$$UDF_WU9 
     FOR$WRITE_SU         	.  ABS  .    P       	_FOR$CODE )  PFOR$$IO_BEG&P FOR$$IO_BEG3    w w                                                                                                                                                                                                                                                                                                                                       	   1       `2	 1-014                           9     FOR$$UDF_RU1-01410-Oct-1990 22:3910-Oct-1990 22:39  VAX Bliss-32 V4.5-862SQ    FOR$$AA_REC_PR0   FOR$$AA_REC_PR1   FOR$$AA_REC_PR9   FOR$$SIGNAL_STO   P  
      FOR$$UDF_RU0CC eeP@ FOR$$AA_REC_PR0P@ FOR$$AA_REC_PR0 ЫO  
  %   FOR$$UDF_RU1  FOR$$AA_REC_PR1Z FOR$$SIGNAL_STOY FOR$$AA_REC_PR0X1 ~uѬ  kЬ$ eP@hP@h" C~iЫ<P/ Ҭ&    1       # 1-007                           8     
COM$ASSIGN1-00710-Oct-1990 22:3110-Oct-1990 22:31  VAX Bliss-32 V4.5-862 k    FOR$$SIGNAL_STO   FOR$$GET_VM   FOR$$FREE_VM   FOR$$CB_PUSH   FOR$$CB_POP   FOR$$ERR_OPECLO    P   
      ASSIGN  ^~ mnP<R FOR$$CB_PUSHn
" FOR$$SIGNAL_STOl1 լЬRRWg EWRlլ<Q$: d b

: d bQRQQd   dQQЫV!P~ FOR$$GET_VMPV, n P fV谏Pf     ,ݦ,4~   FOR$$FREE_VM4Ԧ,VW   FOR$$CB_POP  ЬPРP^}~ FOR$$ERR_OPECLO< ЬS<cT+T   
0 FOR$$SIGNAL_STOЬRT FOR$$GET_VMP,T4(T,   B  	_FOR$CODE  Q     w w                                                                                                                                                                                                                                                                           	     1       ') 1-006                           7     	COM$CLOSE1-00610-Oct-1990 22:3110-Oct-1990 22:31   VAX Bliss-32 V4.5-862 
   P   H    	FOR$CLOSE   FOR$$ERR_OPECLO   FOR$$SIG_NO_LUB 
       CLOSEj   ) mlլ
}0~ FOR$$SIG_NO_LUB