                            â $      ELN042.B                                                                                                                                                                                                     ~@               ELN042.B  BACKUP/INTERCHANGE/VERIFY/BLOCK=9000/GROUP=25/REPLACE/PROT=(S:RWED,G:R,O:RWED,W:R) SEAS$KWD:*.*;* SEAS$LIB_NODE"SEAS$REMOTE password"::SEAS$LIB_DISK:[34516.79374.109147.0.ELN]ELN042.B;1/SAVE_SET  SYSTEM            `s      V5.4 	 _4BUY4:: 
   
  V5.4 
  $                               ) * [SYSEXE.SEAS$WORK_0000005C]$SCSI_BODY.C;1 +  ,    . `    /     4 P   `   _                   - 
    0   1    2   3      K  P   W   O `    5   6  @y.  7  -)G  8          9          G    H  J                        #module eln$scsi_utilityN /*****************************************************************************  *									     * /  *  Copyright (c) 1989, 1990					             * =  *  by DIGITAL Equipment Corporation, Maynard, Mass.			     *   *									     * N  *  This software is furnished under a license and may be used and  copied   *N  *  only  in  accordance  with  the  terms  of  such  license and with the   *N  *  inclusion of the above copyright notice.  This software or  any  other   *N  *  copies  thereof may not be provided or otherwise made available to any   *N  *  other person.  No title to and ownership of  the  software  is  hereby   *  *  transferred.							     *   *									     * N  *  The information in this software is subject to change  without  notice   *N  *  and  should  not  be  construed  as  a commitment by DIGITAL Equipment   *  *  Corporation.							     *   *									     * N  *  DIGITAL assumes no responsibility for the use or  reliability  of  its   *C  *  software on equipment which is not supplied by DIGITAL.		     *   *									     * O  *****************************************************************************/    /*  * FACILITY:  *    *	VAXELN Run Time System   *
  *  ABSTRACT:   *K  *       This module represents the SCSI application funtion interface that J  *       will allow an application program to communicate with a 3rd party:  *       SCSI device via the Generic Message Class driver.  *  
  * AUTHOR:  *$  *       Bruce R. Hansen 17-Nov-1989  *  * VERSION:   *H  *       V1.0-01   -    Bruce R. Hansen                 28-November-1989M  *                      Added a local copy of scsi$name to routine eln$scsi_- K  *                      get_control_ports. This name must be the same as in #  *                      SCSIGNRC.C. '  *       V1.0-00   -    Bruce R. Hansen &  *                      First release.  *  */    #include $scsi_utility #include $kernelmsg  #include $elnmsg #include descrip    O /******************************************************************************   *  *      Associative Constants:  *%  *  #define SCSI$K_MAX_UNITS        8 %  *  #define SCSI$K_READ             1 %  *  #define SCSI$K_WRITE            0 %  *  #define SCSI$K_DISCONNECT       1 %  *  #define SCSI$K_NODISCONNECT     0 %  *  #define SCSI$K_SYNC             1 %  *  #define SCSI$K_NOSYNC           0 %  *  #define SCSI$K_NORETRY          1 %  *  #define SCSI$K_RETRY            0   *O  * - - - - - - - - - - - - - - - - - - - - - - - -  - - - - - - - - - - - - - -   *#  *      Associated Data Structures:   *  *  struct scsi$varying_name {  *    unsigned short    count;!  *    char              data[30];   *  };  *!  *  struct scsi$config_tbl_type { '  *      unsigned char       valid_data; (  *      unsigned char       device_type;+  *      unsigned char       class_attached; /  *      unsigned char       current_connection; ,  *      unsigned char       removable_media;+  *      unsigned char       product_id[16];   *  };H  *      valid_data         - A device has been found at this SCSI Bus IdP  *      device_type        - Peripheral Device Type indicated by Inquiry CommandL  *      class_attached     - A class driver has been assigned to this deviceI  *      current_connection - A class driver has made a connection to this K  *                           device. Not available for use by another class $  *                           driver.L  *      removable_media    - Indicates if the SCSI device supports removable#  *                           media. I  *      product_id[16]     - Product Identification bytes 16 to 31 of the 2  *                           SCSI Inquiry command.  *  *!  *  struct scsi$config_tbl_data { A  *      struct scsi$config_tbl_type config_tbl[SCSI$K_MAX_UNITS];   *  };  *H  *      config_tbl         - A table representing configuration data forG  *                           each device found on the SCSI bus. Indexed 7  *                           by the SCSI id of the bus.   *O  ******************************************************************************   */   O /******************************************************************************   */  *      Associated Data Structures (continued):   *  *  struct scsi$config_msg {3  *      int                             error_code; 0  *      MESSAGE                         msg_obj;1  *      int                             msg_size; 4  *      struct scsi$config_tbl_data     config_info;  *  };  *J  *      error_code         - Error code returned from Message Class Driver-  *                              ELN$_SUCCESS  D  *                                      Normal successful completion0  *                              ELN$_UNSUPPORTEDH  *                                      The Generic Message Class DriverH  *                                      detected an unsupported  requestJ  *      msg_obg            - The MESSAGE value associated with the receipt6  *                           of configuration message.C  *      msg_size           - The total size of the message in bytes H  *      config_info        - A table representing configuration data for?  *                           each device found on the SCSI bus.   *P  *******************************************************************************  */   O /******************************************************************************   *2  *      Name:           ELN$SCSI_GET_CONTROL_PORTS  *H  *      Abstract:       This function will return PORT values to be usedL  *                      in communication with the Generic SCSI Message ClassL  *                      Driver. These PORTs, via datagram messages, are usedI  *                      to get SCSI configuration data and to attach this B  *                      application to one or more SCSI device(s).  *'  *      Inputs:         controller_name K  *                                  - Supplies a varying string of up to 30 K  *                                    characters indicating the name of the K  *                                    device. This name must match the name I  *                                    established with the System Builder 9  *                                    device description. G  *                      src_port    - Receives the value of the callers 3  *                                    message port. G  *                      dest_port   - Receives the value of the Generic 9  *                                    Message Class port.   *C  *      Outputs:        status -    KER$_SUCCESS                or  8  *                                  Status returned fromB  *                                    ker$create_port           or8  *                                    ker$translate_name  *  *      Synopsis: )  *                      #include $vaxelnc .  *                      #include $scsi_utility7  *                      int eln$scsi_get_control_ports( L  *                              struct scsi$varying_name   *controller_name,E  *                                      PORT               *src_port, G  *                                      PORT               *dest_port )   *O  ******************************************************************************   */   L int eln$scsi_get_control_ports(struct scsi$varying_name    *controller_name,E                                PORT                        *src_port, F                                PORT                        *dest_port) { !   int                     status; $   VARYING_STRING(64)      port_name;&   struct dsc$descriptor_s server_name;   int                     i;   char                    *ptr;      /*1    *  This name must be the same as in SCSIGNRC.C     */ 5   VARYING_STRING_CONSTANT(scsi$name,"_SCSI_GENERIC");      /*L    *  Build up a string descriptor from the name of the SCSI Generic Message    *  Class datagram port.    */    port_name.data[0] = '\$';    ptr = &port_name.data[1]; +   for(i=0; i < controller_name->count; i++) &     *ptr++ = controller_name->data[i];$   for(i=0; i < scsi$name.count; i++)     *ptr++ = scsi$name.data[i]; I   server_name.ds                                                                                                                                                                           + $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]$SCSI_BODY.C;1                                                                                      P    `                          "            c$w_length = controller_name->count + scsi$name.count +1; *   server_name.dsc$b_dtype = DSC$K_DTYPE_T;*   server_name.dsc$b_class = DSC$K_CLASS_S;-   server_name.dsc$a_pointer = port_name.data;      /*8    *  Create a Port value for this callers datagram port    */    ker$create_port(&status,                   src_port,                    NULL);     if (status == KER$_SUCCESS)      /*9      *  Now find the PORT value of the SCSI datagram port       */      ker$translate_name(&status, !                        dest_port, $                        &server_name,#                        NAME$LOCAL);      return(status);  }   O /******************************************************************************   *2  *      Name:           ELN$SCSI_FREE_CONTROL_PORT  *I  *      Abstract:       This function will remove the callers PORT object H  *                      from the system. This object was obtained in the;  *                      call to eln$scsi_get_control_ports.   *I  *      Inputs:         src_port    - Pointer to the callers message port D  *                                    to be removed from the system.  *2  *      Outputs:        status - KER$_SUCCESS   or5  *                               Status returned from .  *                                  ker$delete  *  *      Synopsis: )  *                      #include $vaxelnc .  *                      #include $scsi_utilityI  *                      int eln$scsi_free_control_port( PORT  *src_port )   *O  ******************************************************************************   */   . int eln$scsi_free_control_port(PORT *src_port) {    int   status;      /*:    *  Delete the Port value for this callers datagram port    */    ker$delete(&status,               src_port);      return(status);  }   O /******************************************************************************   *0  *      Name:           ELN$SCSI_GET_CONFIG_DATA  *  K  *      Abstract:       This function will request the Generic SCSI Message K  *                      class driver to return its SCSI configuration data.*  *N  *      Inputs:         src_port    - Pointer to callers message port returnedK  *                                    in call to eln$scsi_get_control_portssK  *                      dest_port   - Pointer to Generic SCSI Message Classn?  *                                    port returned in call to hA  *                                    eln$scsi_get_control_ports.tM  *                      config_msg_ptr - Pointer which will receive a pointeroJ  *                                       to the configuration data message0  *                                       packet.  *9  *      Outputs:        status - KER$_SUCCESS          or 5  *                               Status returned fromc9  *                                  ker$create_message orr9  *                                  ker$send           ort9  *                                  ker$wait_any       or /  *                                  ker$receive   *  *      Synopsis:o)  *                      #include $vaxelncL.  *                      #include $scsi_utility4  *                      int eln$scsi_get_config_dataH  *                                   ( PORT                   *src_port,I  *                                     PORT                   *dest_port,nO  *                                     struct scsi$config_msg **config_msg_ptr)a  *O  ******************************************************************************O  */*  @ int eln$scsi_get_config_data( PORT                   *src_port, @                               PORT                   *dest_port,F                               struct scsi$config_msg **config_msg_ptr) {s(   MESSAGE                       msg_obj;0   int                           msg_size,status;)   struct scsi$request_msg       *msg_ptr;-*   struct scsi$config_msg        *msg_ptr1;+   PORT                          reply_port;$     /*5    *  Get a message packet for the message to be sentd    */    ker$create_message( &status,                       &msg_obj,*                       &msg_ptr, 8                       sizeof(struct scsi$request_msg) );   /*E    *  If an error detected - return the error from ker$create_message     */    if (status != KER$_SUCCESS)C     return(status);n     /*B    *  Now fill in the operation code to request configuration data    */C'   msg_ptr->op_code = SCSI$K_MSG_CONFIG;I     /*3    *  Send the message to SCSI Generic Class Driver     */*   ker$send(&status,-            msg_obj,-+            sizeof(struct scsi$request_msg),             dest_port,t            src_port,            NULL);{     /*;    *  If an error detected - delete the message created and !    *  return status from ker$sendt    */    if (status != KER$_SUCCESS) {a     ker$delete(NULL,msg_obj);a     return(status);    }      /**    *  Now that we have sent the message - 5    *  Wait for the configuration data to be returned.c    */    ker$wait_any(&status,                 NULL,                NULL,                src_port);      /*<    *  If an error detected - return status from ker$wait_any    */-   if (status != KER$_SUCCESS)e     return(status);      /*+    *  Now that our port was been awakened -a1    *  Go get the configuration data from the PORT-    */s   ker$receive(&status,               &msg_obj,                &msg_ptr1,               &msg_size,               src_port,                NULL,i               &reply_port);      /*;    *  If an error detected - return status from ker$receive     */    if (status != KER$_SUCCESS)d     return(status);e     /*=    *  If the request was not recognized - return error statusn    */o+   if (msg_ptr1->error_code != ELN$_SUCCESS)t     return(KER$_BAD_VALUE);f     /*/    *  Now that we have the configuration data -*D    *  Return a pointer to the configuration data. In addition to theH    *  configuration data, the data structure will contain an error code,I    *  the MESSAGE ID of this message, and the actual size of the message.*H    *  It is the users responsibility of deleting the message when he is >    *  done with the data by calling eln$scsi_free_config_data.    */*   msg_ptr1->msg_obj  = msg_obj;i    msg_ptr1->msg_size = msg_size;    *config_msg_ptr    = msg_ptr1;     /*    *  Return KER$_SUCCESS     */r   return(status);  }S  O /******************************************************************************e  *1  *      Name:           ELN$SCSI_FREE_CONFIG_DATA;  *M  *      Abstract:       This function will remove the MESSAGE object from therO  *                      system and set the pointer to the configuration data to J  *                      NULL. The message pointer and object were obtainedB  *                      from the call to eln$scsi_get_config_data.  *I  *      Inputs:         config_msg_ptr - Pointer to the configuarion datapC  *                                       pointer retuned in call toaH  *                                       eln$scsi_get_config_data. This M  *                                       pointer which will receive a pointer 7  *                                       value of NULL.   *2  *      Outputs:        status - KER$_SUCCESS   or5  *                               Status returned from*.  *                                  ker$delete  *  *      Synopsis:*)  *                      #include $vaxelnc*.  *                      #include $scsi_utility5  *                      int eln$scsi_free_config_data O  *                                  ( struct scsi$config_msg **config_msg_ptr )n  *O  ******************************************************************************h  */O  H int eln$scsi_free_config_data( struct scsi$config_msg **config_msg_ptr ) {g$     int                      status;&     struct scsi$config_msg   *msg_ptr;       /*9      *  Get a pointer to the configuration data structure       */      msg_ptr = *config_msg_ptr;       /*C      *  Return the MESSAGE object back to the system pool and clearc4      *  references to it in the application program.      */ )     ker$delete(&status,msg_ptr->msg_obj);m       /*<      *  Clear the pointer to the configuration data record -      */*     *config_msg_ptr = NULL;        /**      *  Return the status from ker$_delete      */      return(status);o }h   lO /******************************************************************************   */  *      Name:           ELN$SCSI_CONNECT_DEVICE*  *L  *      Abstract:       This function will connect the specified SCSI deviceN  *                      to a SCSI Message Class process via a message ci                                                                                                                                                                                                                                                                           V $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]$SCSI_BODY.C;1                                                                                      P    `                         6 "     "       rcuit.L  *                      All SCSI commands, to and from the specified device,A  *                      will now be done via the message circuit.t  *                      N  *      Inputs:         src_port    - Pointer to callers message port returnedK  *                                    in call to eln$scsi_get_control_ports*K  *                      dest_port   - Pointer to Generic SCSI Message Class*?  *                                    port returned in call to tA  *                                    eln$scsi_get_control_ports.tI  *                      circuit_port - Receives the value of the circuits*3  *                                     message portpM  *                      process_prior- Process priority that the SCSI Message M  *                                     Class process will be set at. Supply a J  *                                     a priority in the range of 0 to 15,P  *                                     with 0 representing the highest priority.K  *                                     It is recommended that this prioritysH  *                                     value be set to 10. If the numberK  *                                     supplied is out of range, 10 will beo9  *                                     used as a default.mK  *                                     WARNING: Changing this value to any- G  *                                              thing other than 10 may>I  *                                              have an adverse effect on[H  *                                              the systems performance.P  *                      scsi_id      - SCSI ID of target device to be connected.K  *                                     Supply a value between 0 and 7 whichrI  *                                     represents the SCSI ID on the bus.('  *                                      I  *      Outputs:        status -   KER$_SUCCESS                        oro7  *                                 Status returned from K  *                                   ker$create_device                   or K  *                                   ker$send                            oruK  *                                   ker$wait_any                        or*K  *                                   ker$receive                         orOK  *                                   ker$create_port                     orjK  *                                   ker$connect_circuit                 ore5  *                                   ELN$_BADPARAM - pF  *                                      Bad parameter detected or SCSIK  *                                      ID of device out of range.       ors7  *                                   ELN$_DEVOFFLINE -  C  *                                      Device specified was not in C  *                                      the configuration data base K  *                                      or not available.                oru6  *                                   ELN$_DEVACTIVE - G  *                                      The specified device is already*G  *                                      active and connected to a class_K  *                                      driver. Not available for use.   oru8  *                                   ELN$_UNSUPPORTED - H  *                                      The Generic Message Class DriverH  *                                      detected an unsupported  request  *  *      Synopsis: )  *                      #include $vaxelncb.  *                      #include $scsi_utilityH  *                      int eln$scsi_connect_device ( PORT    *src_port,I  *                                                    PORT    *dest_port,oL  *                                                    PORT    *circuit_port,L  *                                                    int     process_prior,G  *                                                    int     scsi_id )t  *O  ******************************************************************************r  */   / int eln$scsi_connect_device( PORT   *src_port, i/                              PORT   *dest_port, 2                              PORT   *circuit_port,2                              int    process_prior,-                              int    scsi_id )S { +     PORT                        reply_port;S2     PORT                        dest_circuit_port;(     MESSAGE                     msg_obj;)     struct scsi$request_msg     *msg_ptr;o)     struct scsi$attach_response *rsp_ptr;$2     int                         msg_size,i,status;       /*7      *  Get a message packet for the message to be senti      */a      ker$create_message( &status,!                         &msg_obj, !                         &msg_ptr,a:                         sizeof(struct scsi$request_msg) );     if (status != KER$_SUCCESS)        return(status);P       /*G      *  Now fill in the operation code to request a connection, and thec1      *  device the connection is to be made with.*      */*&     msg_ptr->op_code = SCSI$K_MSG_ATT;!     msg_ptr->device_id = scsi_id;c       /*K      *  Check the requested process priority. If the priority is not valid,OL      *  default it to a process priority of 10. This corralates to a similar%      *  file system process priority.G      */ H     if ( (msg_ptr->process_prior < 0) || (msg_ptr->process_prior > 15) )"       msg_ptr->process_prior = 10;     else-       msg_ptr->process_prior = process_prior;T       /*9      *  Send the message to the SCSI Generic Class Drivera      */t     ker$send(&status,               msg_obj,s-              sizeof(struct scsi$request_msg),*              dest_port,m              src_port,              NULL);      if (status != KER$_SUCCESS)        return(status);r       /*,      *  Now that we have sent the message - &      *  Wait for the return message -       */      ker$wait_any(&status,                   NULL,                  NULL,                  src_port);S     if (status != KER$_SUCCESS)e       return(status);G       /*-      *  Now that our port was been awakened - 4      *  Go get the connection response from the PORT4      *  The response will confirm the attach requestD      *  and return the PORT value to be used in the message cirucit.      */a     ker$receive(&status,                 &msg_obj,                  &rsp_ptr,S                 &msg_size,                 src_port,)                 NULL,                  &reply_port);g     if (status != KER$_SUCCESS)a       return(status);d       /*,      *  Get the error code from the message.L      *  Get the PORT value of the other half of the circuit to be connected.9      *  This is retrieved from the message just received.(      */      i = rsp_ptr->error_code;.     dest_circuit_port = rsp_ptr->circuit_port;       /*+      *  Delete the attach response messgaget      */       ker$delete(&status,msg_obj);     if (status != KER$_SUCCESS)        return(status);        if ( i != ELN$_SUCCESS)        return( i );       /*9      *  Create a Port value for this callers circuit port       */-     ker$create_port(&status,!                     circuit_port,C                     NULL);     if (status != KER$_SUCCESS)s       return(status);n       /*      *  Now connect to circuit.oH      *  This will enable the callers program to communicate with devices7      *  on the SCSI bus via the Generic Interface Callsi      */h      ker$connect_circuit(&status,%                         circuit_port,a+                         &dest_circuit_port,*                         NULL,e                         FALSE,                         NULL,e                         NULL);     return(status);* }o wO /******************************************************************************=  *2  *      Name:           ELN$SCSI_DISCONNECT_DEVICE  *N  *      Abstract:       This function will disconnect the previously specifiedI  *                      device in the call to eln$scsi_connect_device and*J  *                      disconnect the message circuit between the callersP  *                      job and the SCSI Message Class process. The disconnectedJ  *                      device will now become available again for anotherK  *                      application to use. The circuit PORT object will ben0  *                      removed from the system.  *                      J  *      Inputs:         circuit_port - pointer to the callers circuit portJ  *                                     to be disconnected and removed from2  *                                     the system.'  *                                      =  *      Outputs:        status - KER                                                                                                                                                                                                                                                                           BJE $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]$SCSI_BODY.C;1                                                                                      P    `                         V: "     3       $_SUCCESS              or 5  *                               Status returned from =  *                                  ker$disconnect_circuit or .  *                                  ker$delete  *  *      Synopsis: )  *                      #include $vaxelnc .  *                      #include $scsi_utilityP  *                      int eln$scsi_disconnect_device ( PORT    *circuit_port )  *O  ******************************************************************************s  */    6 int eln$scsi_disconnect_device( PORT   *circuit_port ) {*     int         status;        /*3      *  Issue a disconnect to this circuits partner*      */g4     ker$disconnect_circuit( &status, circuit_port );       /*6      *  Return the PORT object back to the system pool      */c      if ( status == KER$_SUCCESS))       ker$delete( &status, circuit_port);        return(status);M }A oO /******************************************************************************t  *3  *      Name:           ELN$SCSI_MAP_MESSAGE_BUFFERs  *E  *      Abstract:       This function will create a message packet tooG  *                      be used in sending SCSI commands to the GenericeH  *                      Message Class driver. Pointers to a SCSI commandI  *                      buffer, a read/write buffer (if specified), along M  *                      with a MESSAGE object will be returned to the caller. K  *                      It will the callers reponsibilty to free the system M  *                      resources when done with this packet by making a call 9  *                      to eln$scsi_unmap_message_buffer.   *I  *      Inouts:         msg_obj -  Pointer which will receive the MESSAGE G  *                                 object of the newly created message.eJ  *                      cmd_ptr -  Pointer which will receive a pointer toE  *                                 the SCSI command buffer inside ther2  *                                 message packet.H  *                      cmd_size - Length in bytes of the requested SCSIM  *                                 command buffer. The maximum length command 0  *                                 is 256 bytes.J  *                      buf_ptr -  Pointer which will receive a pointer toK  *                                 the read/write buffer inside the messagea*  *                                 packet.H  *                                 NOTE: If a pointer is specified here,I  *                                       buf_size must also be specified..M  *                                       IF this value is NULL, then buf_size I  *                                       must also be zero. An error will*N  *                                       be returned if the above is not true.N  *                      buf_size - Length in bytes of the requested read/writeJ  *                                 buffer. The maximum data buffer size is/  *                                 65536 bytes.>K  *                                 NOTE: If this value is zero then buf_ptr I  *                                       must also be NULL. If this value*O  *                                       is non zero, then buf_ptr must contain*M  *                                       a pointer. An error will be returned =  *                                       if this is not true.eI  *                      pad_size - This field is used to accommodate SCSItG  *                                 device classes that require that the K  *                                 transfer length be specified in terms ofeM  *                                 a larger data unit than the count of bytes K  *                                 expressed in the buf_size field.  If the_M  *                                 total amount of data requested in the SCSIeK  *                                 command does not match that specified in_N  *                                 the buf_size field, this field must account6  *                                 for the difference.O  *                               - For example, suppose an application is using K  *                                 the generic message class driver to read J  *                                 the first 2 bytes of a disk block.  TheH  *                                 length field in the SCSI read commandO  *                                 contains 1 (indicating one logical block, or P  *                                 512 bytes), while the buf_size field containsE  *                                 a 2. The pad_size must contain the 9  *                                 difference, 510 bytes.   *:  *      Outputs:        status - KER$_SUCCESS           or5  *                               Status returned froms:  *                                  ker$create_message  or3  *                                  ELN$_BADPARAM -eF  *                                      Error detected with parametersJ  *                                      buf_ptr and/or buf_size (see notes/  *                                      above).c  *  *      Synopsis: )  *                      #include $vaxelncv.  *                      #include $scsi_utility8  *                      int eln$scsi_map_message_buffer I  *                                              ( MESSAGE       *msg_obj,*J  *                                                char          **cmd_ptr,I  *                                                int           cmd_size,*J  *                                                char          **buf_ptr,I  *                                                int           buf_size, J  *                                                int           pad_size )  *O  ******************************************************************************   */   9 int eln$scsi_map_message_buffer ( MESSAGE       *msg_obj,e:                                   char          **cmd_ptr,9                                   int           cmd_size,s:                                   char          **buf_ptr,9                                   int           buf_size,a:                                   int           pad_size ) { )   int                           pkt_size; '   int                           status;j)   struct scsi$request_packet    *pkt_ptr;      /*?    *  Calculate the size of the message needed for this command     */CH   pkt_size = (sizeof(struct scsi$request_packet) + cmd_size + buf_size);     /*'    *  Check the validity of the request     */tA   if (((!buf_ptr) && (!buf_size)) || ((buf_ptr) && (buf_size))) {=       /*5      *  Create a message buffer for this SCSI command       */c      ker$create_message( &status,                          msg_obj,!                         &pkt_ptr,i#                         pkt_size );r     if (status != KER$_SUCCESS)o       return(status);f  D     *cmd_ptr = (char *)pkt_ptr + sizeof(struct scsi$request_packet);$     pkt_ptr->cmd_ptr     = *cmd_ptr;$     pkt_ptr->cmd_length  = cmd_size;       /*5      *  Return pointer to buffer if one was specifiedr      */D     if (buf_ptr) {-       *buf_ptr = (char *)*cmd_ptr + cmd_size; %       pkt_ptr->buf_ptr     = buf_ptr;s&       pkt_ptr->data_length = buf_size;&       pkt_ptr->pad_length  = pad_size;     } else {"       pkt_ptr->buf_ptr     = NULL;"       pkt_ptr->data_length = NULL;"       pkt_ptr->pad_length  = NULL;     }t
   } else {     return(ELN$_BADPARAM);   }a   return(KER$_SUCCESS);  }  LO /******************************************************************************S  *5  *      Name:           ELN$SCSI_UNMAP_MESSAGE_BUFFERt  *C  *      Abstract:       This function will remove the MESSAGE valueoH  *                      from the system. This object was obtained in the<  *                      call to eln$scsi_map_message_buffer.  *?  *      Inputs:         msg_obj - Pointer to the MESSAGE object @  *                                to be removed from the system.  *2  *      Outputs:        status - KER$_SUCCESS   or5  *                               Status returned fromu.  *                                  ker$delete  *  *      Synopsis: )  *                      #include $vaxelnco.  *                      #include $scsi_utilityN  *                      int eln$scsi_unmap_message_buffer( MESSAGE  *msg_obj )  *O  ******************************************************************************c  */p  < int eln$scsi_unmap_message_buffer ( MESSAGE       *msg_obj ) {(   int   status;C      ker$delete(&status, *msg_obj);     return(status);E }   O /******************************************************************************p  *.  *      Name:           ELN$SCSI_ISSUE_COMMAND  *H  *                                                                                                                                                                                                                                                                               g $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]$SCSI_BODY.C;1                                                                                      P    `                         ˣ "     D         Abstract:       This function will deliver a SCSI command to theK  *                      target device via the Generic Message Class Driver.tG  *                      It will handle all movement of data to and fromcJ  *                      the associated message packets. It will return theH  *                      port drivers function status and the SCSI status=  *                      byte, if the command was successfull.   *                        *      Inputs: M  *                      scsi_sts        - Pointer which will receive the SCSI)N  *                                        status byte returned from the targetM  *                                        device, as defined in the ANSI SCSI 8  *                                        specification.I  *                      port_status     - Pointer which will receive the eM  *                                        status value returned from the SCSItA  *                                        Port Interface Routine.pI  *                      circuit_port    - Pointer to callers circuit portaM  *                                        returned in eln$scsi_connect_deviceiN  *                      scsi_id         - SCSI ID of target device. Same as inJ  *                                        call to eln$scsi_connect_device.K  *                      direction       - Specify SCSI$K_READ if the target L  *                                        is expected to enter DATA IN phaseC  *                                        to send data to the host.RL  *                                      - Specify SCSI$K_WRITE if the targetM  *                                        is expected to enter DATA OUT phase H  *                                        to receive data from the host.P  *                                      - This field must be specified. However,P  *                                        if buf_size equals zero in the call toJ  *                                        eln$scsi_map_message_buffer, theN  *                                        value is ignored by the port driver.P  *                      disconnect      - Specify SCSI$K_DISCONNECT to allow theP  *                                        target device to disconnect during theH  *                                        execution of the SCSI command.P  *                                      - Specify SCSI$K_NODISCONNECT to inhibitN  *                                        the target device from disconnectingJ  *                                        during execution of the command.O  *                                      - NOTE: Targets that hold on to the bus P  *                                              for long periods of time withoutK  *                                              disconnecting can adversely J  *                                              affect system performance.N  *                      synchronous     - Specify SCSI$K_SYNC if both the hostL  *                                        and the target support synchronousB  *                                        mode for data transfers.N  *                                      - Specify SCSI$K_NOSYNC if synchronousM  *                                        mode is not supported by either the 9  *                                        host or target. I  *                                      - NOTE: This port driver does not O  *                                              support synchronous mode trans- L  *                                              fers, thus, set the value toK  *                                              SCSI$K_NOSYNC. Asynchronous.N  *                                              mode will be used for all dataM  *                                              transfers by the port driver. K  *                      port_retry      - Specify SCSI$K_RETRY to allow the J  *                                        port driver to retry up to threeG  *                                        times, any command that fails K  *                                        with a timeout, bus parity, or an I  *                                        invalid phase transition error. K  *                                      - Specify SCSI$K_NORETRY to inhibit L  *                                        the port driver from doing retriesM  *                                        on commands for which it detects an 0  *                                        error.I  *                      phase_timeout   - Maximum number of seconds for a M  *                                        target to change the SCSI bus phase N  *                                        or complete a data transfer. A valueK  *                                        of 0 causes the SCSI port drivers L  *                                        default phase change timeout of 20I  *                                        seconds to be used. The maximum I  *                                        allowed value is 420 seconds. AsL  *                                        number out of range will cause theC  *                                        default value to be used.e,  *                      disconnect_timeout -P  *                                        Maximum number of seconds for a targetN  *                                        to reselect the initiator to proceedM  *                                        with a disconnected I/O transfer. A I  *                                        value of 0 causes the SCSI port L  *                                        drivers default disconnect timeoutO  *                                        of 20 seconds to be used. The maximum I  *                                        allowed value is 420 seconds. A L  *                                        number out of range will cause theC  *                                        default value to be used. P  *                      msg_obj         - Pointer to the MESSAGE object returnedK  *                                        in call to eln$scsi_map_message_- L  *                                        buffer. On return from the MessageO  *                                        Class driver, the MESSAGE object will L  *                                        be updated to reflect the returned9  *                                        message packet. O  *                      cmd_ptr         - Pointer to the pointer value returned K  *                                        in call to eln$scsi_map_message_-_L  *                                        buffer. On return from the GenericL  *                                        Message Class driver, the pointer N  *                                        will be updated to point at the SCSIP  *                                        command buffer in the returned packet.O  *                      buf_ptr         - Pointer to the pointer value returnedmK  *                                        in call to eln$scsi_map_message_-iL  *                                        buffer. On return from the GenericK  *                                        Message Class driver, the pointer J  *                                        will be updated to point at the K  *                                        read/write buffer in the returned*1  *                                        packet. M  *                                      - If NULL was specified in eln$scsi_-_O  *                                        map_message_buffer, then specify NULL B  *                                        for this parameter also.'  *                                      B  *      Outputs:        status      - KER$_SUCCESS              or<  *                                      Status returned fromB  *                                        ker$send              orB  *                                        ker$wait_any          orB  *                                        ker$receive           or9  *                                        ELN$_BADPARAM - M  *                                          The Message Class Driver detected B  *                                          a bad parameter value.  *P  *                      scsi_sts    - receives the value of the SCSI status byteI  *                                    returned from the target device, as!M  *                                    defined in the ANSI SCSI specification.zE  *                      port_status - Pointer which will receive the  I  *                                    status value returned from the SCSIu=  *                                    Port Interface Routine. 8  *                                        ELN$_SUCCESS -H  *                                                                                                                                                                                                                                                                                 >iV $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]$SCSI_BODY.C;1                                                                                      P    `                         oI      U                                           Normal successful completion8  *                                        ELN$_TMO     -I  *                                          Timeout error - failed duringdI  *                                          arbitration, selection or buseP  *                                          went free before command completion.8  *                                        ELN$_CRTLERR -M  *                                          Controller error or port hardwarer4  *                                          failure.  *  *      Synopsis:t)  *                      #include $vaxelnc .  *                      #include $scsi_utility3  *                      int eln$scsi_issue_command(o@  *                                      unsigned char *scsi_sts,C  *                                      int           *port_status, D  *                                      PORT          *circuit_port,>  *                                      int           scsi_id,@  *                                      int           direction,A  *                                      int           disconnect,fB  *                                      int           synchronous,A  *                                      int           port_retry,mD  *                                      int           phase_timeout,I  *                                      int           disconnect_timeout,*?  *                                      MESSAGE       *msg_obj,*@  *                                      char          **cmd_ptr,A  *                                      char          **buf_ptr )   *O  ******************************************************************************   */    4 int eln$scsi_issue_command( unsigned char *scsi_sts,7                             int           *port_status, 8                             PORT          *circuit_port,2                             int           scsi_id,4                             int           direction,5                             int           disconnect, 6                             int           synchronous,5                             int           port_retry,b8                             int           phase_timeout,=                             int           disconnect_timeout, 3                             MESSAGE       *msg_obj, 4                             char          **cmd_ptr,5                             char          **buf_ptr )  {t2     int                         status,msg_status;)     struct scsi$request_packet  *pkt_ptr;i(     MESSAGE                     pkt_obj;)     int                         msg_size;        /*F      *  Recreate the pointer to the base of the scsi$request_packet byI      *  taking the pointer to the scsi command packet and subtracting out*,      *  the size of the scsi$request_packet.      */iD     pkt_ptr = (char *)*cmd_ptr - sizeof(struct scsi$request_packet);       /*H      *  Now fill in the appropriate fields of the command packet message      */ &     pkt_ptr->op_code = SCSI$K_MSG_CMD;#     pkt_ptr->scsi_target = scsi_id;R     pkt_ptr->scsi_sts = 0xFF; &     pkt_ptr->version = SCSI$K_VERSION;     pkt_ptr->func_status = 0; 6     pkt_ptr->dir                = (direction) ? 1 : 0;7     pkt_ptr->dis                = (disconnect) ? 1 : 0; 8     pkt_ptr->syn                = (synchronous) ? 1 : 0;7     pkt_ptr->dpr                = (port_retry) ? 1 : 0; $     pkt_ptr->na                 = 0;0     pkt_ptr->phase_timeout      = phase_timeout;5     pkt_ptr->disconnect_timeout = disconnect_timeout;        /*N      *  Initialize return values of SCSI status byte and port function status.6      *  This is done in case the command doesn't work.      */e     *scsi_sts = 0xFF;      *port_status = 0;g       /*7      *  Now that the SCSI command packet has been setup 3      *  Send it to the Generic Message Class Driver       */ 9     ker$send(&status,*msg_obj,-1,circuit_port,NULL,NULL);      if (status != KER$_SUCCESS)        return(status);c       /*@      *  Wait for the port to execute the command and send back a      *  a response      */ 1     ker$wait_any(&status,NULL,NULL,circuit_port);t     if (status != KER$_SUCCESS)        return(status);        /**      *  Now that the port has responded - .      *  Receive the completed response packet.      */ K     ker$receive(&status,msg_obj,&pkt_ptr,&msg_size,circuit_port,NULL,NULL);f!     if (status != KER$_SUCCESS) {y0       ker$disconnect_circuit(NULL,circuit_port);       return(status);      }        /*6      *  Get a pointer to the returned SCSI command and3      *  The pointer of the possible read/write data*      */ D     *cmd_ptr = (char *)pkt_ptr + sizeof(struct scsi$request_packet);       /*5      *  Return pointer to buffer if one was specifiede      */      if (buf_ptr)8       *buf_ptr = (char *)*cmd_ptr + pkt_ptr->cmd_length;       /*H      *  Get the status returned in the packet. This status will indicateM      *  whether the command was issued or the packet had invalid information.       */      status = pkt_ptr->op_code;  !     if (status == KER$_SUCCESS) {        /*H        *  Return the SCSI BUS status and the port function status to the!        *  caller of this functione	        */a.       *scsi_sts    = pkt_ptr->scsi_sts & 0x3E;*       *port_status = pkt_ptr->func_status;     }        return(status);  }p                                                                                                                                                                                                                                                                      ( * [SYSEXE.SEAS$WORK_0000005C]AAV_DEC.PAS;1 +  , 	   .     /     4 I       8                   - 
    0   1    2   3      K  P   W   O     5   6  qE  7 ELG  8          9          G    H  J                        module aav_declarations;  . export	aav$data, da_control_status, da_buffer, 	da_registers, aav_data_area;   # export	aav_initialize,aav_write_xy;    type 	bit = 0..1; 	nibble = 0..%x0f;   	aav$data = 0..%x0fff;  ) 	da_control_status = [word] packed record . 		software_start		: [pos(0)] bit; {write only}* 		dma_enable		: [pos(1)] bit; {read/write}2 		multiple_conversion	: [pos(2)] bit; {read/write}3 		dma_extension_enable	: [pos(3)] bit; {read/write} 3 		realtime_clock_start	: [pos(4)] bit;	{read/write} ' 		dma_done		: [pos(5)] bit; {read only} 0 		interrupt_on_done	: [pos(6)] bit; {read/write}' 		da_ready		: [pos(7)] bit; {read only} 5 		digital_output_bits	: [pos(8)] nibble; {read/write} 5 		single_channel_select	: [pos(12)] bit; {read/write} 0 		y_channel_select	: [pos(13)] bit; {read/write}2 		interrupt_on_error	: [pos(14)] bit; {read/write}& 		error			: [pos(15)] bit; {read only} 	end;    	da_buffer = [word] aav$data;   * 	da_registers = [aligned(1)] packed record 		dacsr : da_control_status; 		dabuf : da_buffer; 	end;    	aav_data_area = record  		da_device : DEVICE;  		registers : ^da_registers; 	end;    procedure aav_initialize( " 	device_name : varying_string(30);) 	var ident   : ^aav_data_area); separate;   I procedure aav_write_xy(ident : ^aav_data_area; x,y : aav$data); separate;    end;                                                                                                                                                                                                                      + * [SYSEXE.SEAS$WORK_0000005C]AAV_DRIVER.PAS;1 +  ,    .     /     4 <                           - 
    0   1    2   3      K  P   W   O     5   6 #T  7 `CiG  8          9          G    H  J                     module aav_routines;   include aav_declarations;    procedure_body aav_initialize;   begin {aav_initialize} 	 ; 	new(ident);		{create a new data area for future reference}    	with ident^ do  	begin 		{Connect to AAV11-DA device}< 		create_device(device_name,da_device,registers:=registers); 		{Intialize AAV11-DA CSR}" 		write_register(registers^.dacsr, 			software_start		:=0,  			dma_enable		:=0,  			multiple_conversion	:=0,  			dma_extension_enable	:=0, 			realtime_clock_start	:=0, 			interrupt_on_done	:=0,  			digital_output_bits	:=0,  			single_channel_select	:=0,  			y_channel_select	:=0, 			interrupt_on_error	:=0);  	end;  end;  {aav_initialize}   procedure_body aav_write_xy;   begin {aav_write_xy} 	with ident^ do  	begin8 		write_register(registers^.dabuf,x); {write x to x-dac}8 		write_register(registers^.dabuf,y); {write y to y-dac}< 		write_register(registers^.dacsr,    {start d-a conversion} 			software_start:=1); 	end;  end;  {aav_write_xy}   end;  {module aav_routines                                                                                                                                                                                                            $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]AAV_DRIVER.PAS;1                                                                                    <                              f             }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             & * [SYSEXE.SEAS$WORK_0000005C]ADQ32.FOR;1 +  ,    .     /     4 T       B                  - 
    0   1    2   3      K  P   W   O     5   6 ߓ  7 @AG  8          9          G    H  J                            % !*** MODULE $adq32def IDENT V1-00 *** M ! *************************************************************************** M !                                                                           * M !   COPYRIGHT (c) 1989, 1990 BY                                             * M !   DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                  * M !   ALL RIGHTS RESERVED.                                                    * M !                                                                           * M !   THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED   * M !   ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE   * M !   INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER   * M !   COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY   * M !   OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY   * M !   TRANSFERRED.                                                            * M !                                                                           * M !   THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE   * M !   AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY DIGITAL EQUIPMENT   * M !   CORPORATION.                                                            * M !                                                                           * M !   DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS   * M !   SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                 * M !                                                                           * M !                                                                           * M ! ***************************************************************************  !  !  !  ADQ Clock rates   ! ( 	PARAMETER ADQ$_FREQ_5_MHZ = '0000000B'X* 	PARAMETER ADQ$_FREQ_500_KHZ = '0000000C'X) 	PARAMETER ADQ$_FREQ_50_KHZ = '0000000D'X ( 	PARAMETER ADQ$_FREQ_5_KHZ = '0000000E'X) 	PARAMETER ADQ$_FREQ_500_HZ = '0000000F'X ( 	PARAMETER ADQ$_FREQ_50_HZ = '00000003'X5 	PARAMETER ADQ$_FREQ_EXTERNAL_FREQUENCY = '00000004'X 3 	PARAMETER ADQ$_FREQ_EXTERNAL_TRIGGER = '00000008'X  !  !  !  clock mode  ! , 	PARAMETER ADQ$_K_CLOCK_MODE_1 = '00000001'X, 	PARAMETER ADQ$_K_CLOCK_MODE_2 = '00000002'X, 	PARAMETER ADQ$_K_CLOCK_MODE_3 = '00000003'X, 	PARAMETER ADQ$_K_CLOCK_MODE_4 = '00000004'X, 	PARAMETER ADQ$_K_CLOCK_MODE_5 = '00000005'X, 	PARAMETER ADQ$_K_CLOCK_MODE_6 = '00000006'X, 	PARAMETER ADQ$_K_CLOCK_MODE_7 = '00000007'X, 	PARAMETER ADQ$_K_CLOCK_MODE_8 = '00000008'X, 	PARAMETER ADQ$_K_CLOCK_MODE_9 = '00000009'X- 	PARAMETER ADQ$_K_CLOCK_MODE_10 = '0000000A'X - 	PARAMETER ADQ$_K_CLOCK_MODE_11 = '0000000B'X - 	PARAMETER ADQ$_K_CLOCK_MODE_12 = '0000000C'X - 	PARAMETER ADQ$_K_CLOCK_MODE_13 = '0000000D'X - 	PARAMETER ADQ$_K_CLOCK_MODE_14 = '0000000E'X - 	PARAMETER ADQ$_K_CLOCK_MODE_15 = '0000000F'X - 	PARAMETER ADQ$_K_CLOCK_MODE_16 = '00000010'X - 	PARAMETER ADQ$_K_CLOCK_MODE_17 = '00000011'X - 	PARAMETER ADQ$_K_CLOCK_MODE_18 = '00000012'X - 	PARAMETER ADQ$_K_CLOCK_MODE_19 = '00000013'X - 	PARAMETER ADQ$_K_CLOCK_MODE_20 = '00000014'X - 	PARAMETER ADQ$_K_CLOCK_MODE_21 = '00000015'X - 	PARAMETER ADQ$_K_CLOCK_MODE_22 = '00000016'X  !  ! 	 !  Gains   ! ( 	PARAMETER ADQ$_GAIN_UNITY = '00000000'X& 	PARAMETER ADQ$_GAIN_K_1 = '00000000'X& 	PARAMETER ADQ$_GAIN_K_2 = '00000001'X& 	PARAMETER ADQ$_GAIN_K_4 = '00000002'X& 	PARAMETER ADQ$_GAIN_K_8 = '00000003'X, 	PARAMETER ADQ$_GAIN_K_SCALING = '00000004'X !  !  !  Adq input modes ! 7 	PARAMETER ADQ$_INPUT_MODE_K_SINGLE_ENDED = '00000000'X 7 	PARAMETER ADQ$_INPUT_MODE_K_DIFFERENTIAL = '00000001'X  !  ! 9 !  Status values for use with eln$adq_transfer_done only.  ! % 	PARAMETER ADQ$ENTRY_TD = '00000001'X & 	PARAMETER ADQ$ENTRY_NXM = '00000002'X* 	PARAMETER ADQ$ENTRY_CLK_OVR = '00000004'X& 	PARAMETER ADQ$ENTRY_EOS = '00000008'X& 	PARAMETER ADQ$ENTRY_EOP = '00000010'X& 	PARAMETER ADQ$ENTRY_UNK = '00000020'X) 	PARAMETER ADQ$ENTRY_ACTIVE = '00000040'X ' 	PARAMETER ADQ$ENTRY_DBUF = '00000080'X + 	PARAMETER ADQ$ENTRY_NOTFOUND = '00000100'X ) 	PARAMETER ADQ$ENTRY_EQUEUE = '00000200'X * 	PARAMETER ADQ$ENTRY_ABORTED = '00000400'X, 	PARAMETER ADQ$ENTRY_FIFO_FULL = '00000800'X !  !  Parameter Entry List  ! ' 	PARAMETER adq$_m_channel = '0000001F'X $ 	PARAMETER adq$_m_gain = '00000600'X* 	PARAMETER adq$_m_input_mode = '00008000'X 	STRUCTURE /adq$_adc_entry/ ! 	    PARAMETER adq$_S_channel = 5 ! 	    PARAMETER adq$_V_channel = 0   	    PARAMETER adq$_S_tmp001 = 4  	    PARAMETER adq$_V_tmp001 = 5 	    PARAMETER adq$_S_gain = 2 	    PARAMETER adq$_V_gain = 9  	    PARAMETER adq$_S_tmp002 = 4! 	    PARAMETER adq$_V_tmp002 = 11 $ 	    PARAMETER adq$_S_input_mode = 1% 	    PARAMETER adq$_V_input_mode = 15  	    BYTE %FILL (2)  	END STRUCTURE	! adq$_adc_entry  !  ! * !   Pointer to a list of adq$_adc_entries. ! # 	! ** INTEGER*4 adq$_adc_entry_list  !  !    !   Pointer to an adq context  !   	! ** INTEGER*4 adq$_context_ptr !  !  !  	! ** INTEGER*2 adq$_divider !  ! % !   Adq dac data used in calibration.  !  	! ** BYTE      adq$_dac_data  ! E ! *******************************************************************  !  	EXTERNAL  eln$adq_initialize  !   Q !   status	    - A variable of type integer that receivies the completion status. . !   device_name - 30 Character Varying string.E !   context_id 	- Recieves a pointer to an VAXELN adq context record. C !   re_init	- A Boolean value.  Specify TRUE if the device is to be E !   adc_entry_list - An array of data of type adq$_adc_entry.  These  F !   adc_entry_list_size - The number of entries in the adc_entry_list J !   recycle_entry_list	- A Boolean value.  TRUE if the ADQ32 should recyleJ !   eop_enable	- A Boolean value.  TRUE to signal an end of transfer, if aE !   clock_mode	- An integer value that indicates an ADQ23 clock mode. K !   t1_frequency    - An integer value that indicates the base frequency of S !   t1_divider	    - An 16 bit positive integer value that indicates the number of  K !   t2_frequency    - An integer value that indicates the base frequency of S !   t2_divider	    - An 16 bit positive integer value that indicates the number of  P !   conversion_count - An integer value that indicates the number of conversionsK !   delay_frequency - An integer value that indicates the base frequency of T !   delay_divider   - An 16 bit positive integer value that indicates the number of  !  !  	EXTERNAL  eln$adq_queue_read  ! M !   status	- A variable of type integer that receivies the completion status. I !   context_id	- Supplies a pointer to the device context record returned Q !   dest_buffer	- A pointer to an area in memory that receives the convertd data  N !   wrd_count	- Supplies the count of words to be received in the DMA transferI !   user_id	- Supplies a user-defined identification code.  It allows you  !                  !  	EXTERNAL  eln$adq_start ! M !   status	- A variable of type integer that receivies the completion status. I !   context_id	- Supplies a pointer to the device context record returned  !  !   	EXTERNAL  eln$adq_transfer_done ! M !   status	- A variable of type integer that receivies the completion status. I !   context_id	- Supplies a pointer to the device context record returned F !   user_id	- Receives the a user-defined identification code that wasM !   dest_buffer	- Receives a pointer to the area in memory that received the  F !   bad_count	- Receives the count of words that failed to transfer.  P !   req_status	- A variable that receivies the completion status of the request.I !   time_val	- A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ` $      ELN042.B                         
  &[SYSEXE.SEAS$WORK_0000005C]ADQ32.FOR;1                                                                                         T                            B              LARGE INTEGER time value that indicates how long to wait  !  !                                                                                                                                                                                                                                                                                                                                                                                                                                                                             & * [SYSEXE.SEAS$WORK_0000005C]ADQ32.PAS;1 +  ,    .     /     4 U                         - 
    0   1    2   3      K  P   W   O     5   6  wߓ  7 G  8          9          G    H  J                            $ {** MODULE $adq32def IDENT V1-00 **}) MODULE $adq32_utility [IDENT('V4.1-00')];    N {*************************************************************************** }N {                                                                          * }N {  COPYRIGHT (c) 1989, 1990 BY                                             * }N {  DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASSACHUSETTS.                  * }N {  ALL RIGHTS RESERVED.                                                    * }N {                                                                          * }N {  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND COPIED   * }N {  ONLY IN  ACCORDANCE WITH  THE  TERMS  OF  SUCH  LICENSE  AND WITH THE   * }N {  INCLUSION OF THE ABOVE COPYRIGHT NOTICE. THIS SOFTWARE OR  ANY  OTHER   * }N {  COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY   * }N {  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE IS  HEREBY   * }N {  TRANSFERRED.                                                            * }N {                                                                          * }N {  THE INFORMATION IN THIS SOFTWARE IS  SUBJECT TO CHANGE WITHOUT NOTICE   * }N {  AND  SHOULD  NOT  BE  CONSTRUED AS  A COMMITMENT BY DIGITAL EQUIPMENT   * }N {  CORPORATION.                                                            * }N {                                                                          * }N {  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE  OR  RELIABILITY OF ITS   * }N {  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.                 * }N {                                                                          * }N {                                                                          * }N {*************************************************************************** }M {                                                                           } M {                                                                           } M { ADQ Clock rates                                                           } M {                                                                           }     CONST	ADQ$_FREQ_5_MHZ = 11;  	ADQ$_FREQ_500_KHZ = 12; 	ADQ$_FREQ_50_KHZ = 13;  	ADQ$_FREQ_5_KHZ = 14; 	ADQ$_FREQ_500_HZ = 15;  	ADQ$_FREQ_50_HZ = 3; " 	ADQ$_FREQ_EXTERNAL_FREQUENCY = 4;  	ADQ$_FREQ_EXTERNAL_TRIGGER = 8;   M {                                                                           } M {                                                                           } M { clock mode                                                                } M {                                                                           }     CONST	ADQ$_K_CLOCK_MODE_1 = 1; 	ADQ$_K_CLOCK_MODE_2 = 2;  	ADQ$_K_CLOCK_MODE_3 = 3;  	ADQ$_K_CLOCK_MODE_4 = 4;  	ADQ$_K_CLOCK_MODE_5 = 5;  	ADQ$_K_CLOCK_MODE_6 = 6;  	ADQ$_K_CLOCK_MODE_7 = 7;  	ADQ$_K_CLOCK_MODE_8 = 8;  	ADQ$_K_CLOCK_MODE_9 = 9;  	ADQ$_K_CLOCK_MODE_10 = 10;  	ADQ$_K_CLOCK_MODE_11 = 11;  	ADQ$_K_CLOCK_MODE_12 = 12             ;  	ADQ$_K_CLOCK_MODE_13 = 13;  	ADQ$_K_CLOCK_MODE_14 = 14;  	ADQ$_K_CLOCK_MODE_15 = 15;  	ADQ$_K_CLOCK_MODE_16 = 16;  	ADQ$_K_CLOCK_MODE_17 = 17;  	ADQ$_K_CLOCK_MODE_18 = 18;  	ADQ$_K_CLOCK_MODE_19 = 19;  	ADQ$_K_CLOCK_MODE_20 = 20;  	ADQ$_K_CLOCK_MODE_21 = 21;  	ADQ$_K_CLOCK_MODE_22 = 22;    M {                                                                           } M {                                                                           } M { Gains                                                                     } M {                                                                           }     CONST	ADQ$_GAIN_UNITY = 0; 	ADQ$_GAIN_K_1 = 0;  	ADQ$_GAIN_K_2 = 1;  	ADQ$_GAIN_K_4 = 2;  	ADQ$_GAIN_K_8 = 3;  	ADQ$_GAIN_K_SCALING = 4;    M {                                                                           } M {                                                                           } M { Adq input modes                                                           } M {                                                                           } , CONST	ADQ$_INPUT_MODE_K_SINGLE_ENDED = TRUE;( 	ADQ$_INPUT_MODE_K_DIFFERENTIAL = FALSE;   M {                                                                           } M {                                                                           } M { Status values for use with eln$adq_transfer_done only.                    } M {                                                                           }     CONST	ADQ$ENTRY_TD =      
        1;  	ADQ$ENTRY_NXM = 2;  	ADQ$ENTRY_CLK_OVR = 4;  	ADQ$ENTRY_EOS = 8;  	ADQ$ENTRY_EOP = 16; 	ADQ$ENTRY_UNK = 32; 	ADQ$ENTRY_ACTIVE = 64;  	ADQ$ENTRY_DBUF = 128; 	ADQ$ENTRY_NOTFOUND = 256; 	ADQ$ENTRY_EQUEUE = 512; 	ADQ$ENTRY_ABORTED = 1024; 	ADQ$ENTRY_FIFO_FULL = 2048;   M {                                                                           } M { Parameter Entry List                                                      } M {                                                                           }     CONST	adq$_m_channel = %x1F; 	adq$_m_gain = %x600;  	adq$_m_input_mode = %x8000;   # TYPE	adq$_adc_entry = PACKED RECORD % 	    adq$_v_channel : [BIT(5)] 0..31; $ 	    adq$_v_tmp001 : [BIT(4)] 0..15;! 	    adq$_v_gain : [BIT(2)] 0..3; $ 	    adq$_v_tmp002 : [BIT(4)] 0..15;! 	    adq$_v_input_mode : BOOLEAN;  	END;    M {                                                                           } M {                                                                           } M {  Pointer to a list of adq$_adc_entries.                                   } M {                                                                           }    , TYPE	adq$_adc_entry_list = ^adq$_adc_entry ;   M {                                                                           } M {                                                                           } M {  Pointer to an adq context                                                } M {                                                                       
                 }    ! TYPE	adq$_context_ptr = ^ANYTYPE;    M {                                                                           } M {                                                                           } M {                                                                           }    $ TYPE	adq$_divider = [WORD] 0..65535;   M {                                                                           } M {                                                                           } M {  Adq dac data used in calibration.                                        } M {                                                                           }    # TYPE	adq$_dac_data = [BYTE] 0..255;    M {                                                                           } M {*******************************************************************        } M {                                                                           }     PROCEDURE eln$adq_initialize(  	VAR status : INTEGER;- 	device_name : [READONLY] VARYING_STRING(30); # 	VAR context_id : adq$_context_ptr;  	re_init : [READONLY] BOOLEAN;1 	adc_entry_list : [READONLY] adq$_adc_entry_list; * 	adc_entry_list_size : [READONLY] INTEGER;) 	recycle_entry_list : [READONLY] BOOLEAN; ! 	EOP_enable : [READONLY] BOOLEAN; ! 	clock_mode : [READONLY] INTEGER; ( 	t1_frequency : [READONLY] INTEGER := 0;& 	t1_divider : [READONLY] adq$_divider;( 	t2_frequency : [READONLY] INTEGER := 0;& 	t2_divider : [READONLY] adq$_divider;, 	conversion_count : [READONLY] I                                                                                                                                                                                                                                                                                                                                                                                                                                  	                        b $      ELN042.B                         
  &[SYSEXE.SEAS$WORK_0000005C]ADQ32.PAS;1                                                                                         U                            Qe             NTEGER := 0;+ 	delay_frequency : [READONLY] INTEGER := 0; 4 	delay_divider : [READONLY] adq$_divider); SEPARATE;   M {                                                                           } R {  status	    - A variable of type integer that receivies the completion status. }M {  device_name - 30 Character Varying string.                               } L {  context_id 	- Recieves a pointer to an VAXELN adq context record.       }H {  re_init	- A Boolean value.  Specify TRUE if the device is to be     }M {  adc_entry_list - An array of data of type adq$_adc_entry.  These         }0M {  adc_entry_list_size - The number of entries in the adc_entry_list        }*K {  recycle_entry_list	- A Boolean value.  TRUE if the ADQ32 should recyle } K {  eop_enable	- A Boolean value.  TRUE to signal an end of transfer, if a } K {  clock_mode	- An integer value that indicates an ADQ23 clock mode.      } M {  t1_frequency    - An integer value that indicates the base frequency of  } T {  t1_divider	    - An 16 bit positive integer value that indicates the number of  }M {  t2_frequency    - An integer value that indicates the base frequency of  }OT {  t2_divider	    - An 16 bit positive integer value that indicates the number of  }Q {  conversion_count - An integer value that indicates the number of conversions }}M {  delay_frequency - An integer value that indicates the base frequency of  }}U {  delay_divider   - An 16 bit positive integer value that indicates the number of  }AM {                                                                           } M {                                                                           }E  F PROCEDURE eln$adq_queue_read(U 	VAR status : INTEGER;* 	context_id : [READONLY] adq$_context_ptr;# 	dest_buffer : [READONLY] ^ANYTYPE;P  	wrd_count : [READONLY] INTEGER;) 	user_id : [READONLY] INTEGER); SEPARATE;    M {                                                                           } N {  status	- A variable of type integer that receivies the completion status. }K {  context_id	- Supplies a pointer to the device context record returned  } R {  dest_buffer	- A pointer to an area in memory that receives the convertd data  }O {  wrd_count	- Supplies the count of words to be received in the DMA transfer } J {  user_id	- Supplies a user-defined identification code.  It allows you }M {                                                                           } M {                                                                           }     PROCEDURE eln$adq_start( 	VAR status : INTEGER;5 	context_id : [READONLY] adq$_context_ptr); SEPARATE;    M {                                                                           }HN {  status	- A variable of type integer that receivies the completion status. }K {  context_id	- Supplies a pointer to the device context record returned  }RM {                                                                           } M {                                                                           }      PROCEDURE eln$adq_transfer_done( 	VAR status : INTEGER;* 	context_id : [READONLY] adq$_context_ptr; 	VAR user_id : INTEGER;  	VAR dest_buffer : ^ANYTYPE; 	VAR bad_count : INTEGER;  	VAR req_status : INTEGER;6 	VAR time_value : [OPTIONAL] LARGE_INTEGER); SEPARATE;  AM {                                                                           } N {  status	- A variable of type integer that receivies the completion status. }K {  context_id	- Supplies a pointer to the device context record returned  }_H {  user_id	- Receives the a user-defined identification code that was  }N {  dest_buffer	- Receives a pointer to the area in memory that received the  }J {  bad_count	- Receives the count of words that failed to transfer.      }Q {  req_status	- A variable that receivies the completion status of the request. } J {  time_val	- A LARGE INTEGER time value that indicates how long to wait }M {                                                                           } M {                                                                           }  END;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            ) * [SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1 +  ,    .     /     4 Z                          - 
    0   1    2   3      K  P   W   O     5   6 `UET.  7 /G  8          9          G    H  J                      # #module ELN$ADQ32_UTILITY "V4.1-00"    /*  Title: ADQ32BODY  *  N  *  +------------------------------------------------------------------------+N  *  | Copyright (c) 1989, 1990                                               |N  *  | By Digital Equipment Corperation, Maynard, Mass.                       |N  *  | All Rights Reserverd.                                                  |N  *  | This software is furnished under a license and may be used and  copied |N  *  | only  in  accordance  with  the  terms  of  such  license and with the |N  *  | inclusion of the above copyright notice.  This software or  any  other |N  *  | copies  thereof may not be provided or otherwise made available to any |N  *  | other person.  No title to and ownership of  the  software  is  hereby |N  *  | transfered.                                                            |N  *  |                                                                        |N  *  | The information in this software is subject to change  without  notice |N  *  | and  should  not  be  construed  as  a commitment by Digital Equipment |N  *  | Corporation.                                                           |N  *  |                                                                        |N  *  | DIGITAL assumes no responsibility for the use or  reliability  of  its |N  *  | software on equipment which is not supplied by DIGITAL.                |N  *  +------------------------------------------------------------------------+  *  *  *  Abstract:   ADQ32BODY =  *              This module contains the routines to simplify .  *		to access a Digital Equipment Corp's ADQ32  *		A to D converter.   *  *  Author:     Ron Krueger   *  *  Date:       10-DEC-1989   *  *  Version:    V4.1-00   *  *  Modification History:   *  */    #pragma	 builtins    #include $vaxelnc  #include $elnmsg #include $kernelmsg  #include descrip #include $mutex  #include $physical_address   #include $relative_queue   #include $adq32_utility  #include $adq32_body   /*  * Exception Handler.   */   $ extern void eln$establish_handler();" extern void eln$default_handler();   /*  * Internal routines.   */    void    adq_isr(); void    adq_dma_isr();  ! static void adq_auto_calibrate(); ! static void adq_get_ave_sample();  static void adq_reinit();  static int  best_match();  static void calibrate_reg();   static void init_clk();  static void clk_set_1(); static void clk_set_2(); static void clk_set_3(); static void clk_set_4(); static void clk_set_5(); static void clk_set_6(); static void clk_set_7(); static void clk_set_8(); static void clk_set_9(); static void clk_set_10();  static void clk_set_11();  static void clk_set_12();  static void clk_set_13();  static void clk_set_14();  static void clk_set_15();  static void clk_set_16();  static void clk_set_17();  static void clk_set_18();  static void clk_set_19();  static void clk_set_20();  static void clk_set_21();  static void clk_set_22();    /*++  *)  * eln$adq_initialize - Initialize ADQ32.   *  * functional description:  *F  *	This routine determines if the ADQ32 hardware has been initialized I  *	already.  If it has not the necessary data structures are created and  G  *	the ADQ32 is calibrated.  If the hardware was previously initialized E  *	any pending reads are aborted.  In either case the new user values +  *	are stored and the ADQ32 hardware reset.   *
  * inputs:  *J  *	device_name	- Specifies name of device to be initialize. Must          @  *			  match a device name                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  
                        >ڏ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                              "             specified with the system builder.   A  *	reinit		- TRUE to reinitialized the ADQ32, FALSE if the is the    *			  the first initialization.G  *	adc_entry_list	- Pointer to an array of adq$_adc_entry, the entries  1  *			  describe which channels to sample and how. L  *	adc_entry_list_size - Number of entries in adc_entry_list (=< 512)       I  *	recycle_entry_list - TRUE to recyle the adc_entry_list.  If this value 7  *			     is FALSE then EOS (end of scan) interrupt is  +  *			     enabled, otherwise we would hang. B  *	eop_enable	-  TRUE if EOP is used to signal an end of transfer.8  *	clock_mode	- Specifies which clock mode to use.      >  *	t1_frequency    - Indicates the base frequency of t1 clock.@  *	t1_divider	- Indicates divider to be applied to t1_frequency.>  *	t2_frequency    - Indicates the base frequency of t2 clock.@  *	t2_divider	- Indicates divider to be applied to t2_frequency.H  *	conversion_count - Indicates number of samples to be taken per sweep.E  *	delay_frequency - Indicates the base frequency of the delay clock. G  *	delay_divider   - Indicates divider to be applied to the delay freq.   *  * implicit inputs:   *  *      none  *  * outputs:   *)  *      status		- Status of the operation >  *	context_id	- Recieves a pointer to an ADQ32 context record.  *  * implicit outputs:  *  *      none  *  *--  */   P void eln$adq_initialize(status, device_name, context_id, reinit, adc_entry_list,C 	adc_entry_list_size, recycle_entry_list,  eop_enable, clock_mode,  G 	t1_frequency, t1_divider, t2_frequency, t2_divider, conversion_count,    	delay_frequency, delay_divider) VAR_STR			*device_name;   adq_context_record	**context_id;1 BOOLEAN			reinit, recycle_entry_list, eop_enable; 8 unsigned short int	*adc_entry_list;   /*adq$_adc_entry*/4 int			adc_entry_list_size, clock_mode, t1_frequency,4 			t2_frequency, conversion_count, delay_frequency,  			*status; 9 unsigned short int	t1_divider, t2_divider, delay_divider;  {  int		    istatus, idesc; adq_region	    *qr;  adq_context_record  *ctx;  $DESCRIPTOR(adq_dev_name,"");        /*7      * If we can assume success until proven otherwise.       */        /*"      * Establish an error handler.      */   /     eln$establish_handler(eln$default_handler); +     if (status) *status = ELN$_SUCCESS;            /*4      * If this isn't a reinit, create the device and      * data structures.       */        if (!reinit) {   	/* 8 	 * Convert the name of the device from a varying string 	 * to a string descriptor.  	 */  1 	adq_dev_name.dsc$w_length  = device_name->count; 1 	adq_dev_name.dsc$a_pointer = &device_name->data;  	      	/*  	 * Allocate a context block.  	 */  C 	eln$allocate_clear_memory(NULL, sizeof(adq_context_record), &ctx);  	*context_id = ctx;    	/* 2 	 * Allocate an area of S0 for the ISR's to share. 	 */  N 	ker$allocate_system_region(NULL, &ctx->adq_region, sizeof(adq_region), NULL);  0 	eln$bzero(ctx->adq_region, sizeof(adq_region));   	/*  	 * create the device object 	 */   	ker$create_device(  	    NULL,		/* status */, 	    &adq_dev_name,	/* ptr to device name */ 	    1,			/* relative vector */ . 	    adq_isr,		/* interrupt service routine */@ 	    sizeof(adq_region_ptr), /* size of communications region */? 	    &ctx->isr_1_region,	/* address of communications region */ + 	    &ctx->adq_regs,	/* register pointer */ - 	    &ctx->bus_adapter,	/* adapter pointer */ # 	    NULL,		/* pointer to vector */ - 	    &ctx->priority,	/* interrupt priority */ A 	    &ctx->adq_device_a, /* pointer to receive device variable */ 6 	    sizeof(DEVICE),	/* number of devices to create */. 	    NULL);		/* power fail isr (not needed) */    & 	*ctx->isr_1_region = ctx->adq_region;   	/* 0 	 * create the device object for DMA interrupts. 	 */   	ker$create_device(  	    NULL,		/* status */, 	    &adq_dev_name,	/* ptr to device name */ 	    2,			/* relative vector */ 1 	    adq_dma_isr,	/* interrupt service routine */ @ 	    sizeof(adq_region_ptr), /* size of communications region */? 	    &ctx->isr_2_region,	/* address of communications region */ + 	    &ctx->adq_regs,	/* register pointer */ - 	    &ctx->bus_adapter,	/* adapter pointer */ # 	    NULL,		/* pointer to vector */ - 	    &ctx->priority,	/* interrupt priority */ A 	    &ctx->adq_device_b ,/* pointer to receive device variable */ 6 	    sizeof(DEVICE),	/* number of devices to create */. 	    NULL);		/* power fail isr (not needed) */  & 	*ctx->isr_2_region = ctx->adq_region;   	/*  	 * Create mutex.  	 * Create an abort event. 	 */    , 	ELN$CREATE_MUTEX(ctx->hardware_lock, NULL);  : 	ker$create_event(NULL, &ctx->abort_event, EVENT$CLEARED);   	/* ' 	 * Setup a pointer to the region data.  	 */   	qr = ctx->adq_region;   	/*  	 * Start the queues.  	 * Load the free queue. 	 */  ) 	ELN$START_QUEUE_RELATIVE(qr->req_queue); * 	ELN$START_QUEUE_RELATIVE(qr->done_queue);* 	ELN$START_QUEUE_RELATIVE(qr->free_queue);  + 	for (idesc=0; idesc < QUEUE_SIZE; idesc++) 2 	    _INSQTI(&qr->rdescs[idesc], &qr->free_queue);   	/* 3 	 * initialize the location of the clock functions.  	 */   	ctx->clk_func[0] = NULL;  	ctx->clk_func[1] = &clk_set_1;  	ctx->clk_func[2] = &clk_set_2;  	ctx->clk_func[3] = &clk_set_3;  	ctx->clk_func[4] = &clk_set_4;  	ctx->clk_func[5] = &clk_set_5;  	ctx->clk_func[6] = &clk_set_6;  	ctx->clk_func[7] = &clk_set_7;  	ctx->clk_func[8] = &clk_set_8;  	ctx->clk_func[9] = &clk_set_9; ! 	ctx->clk_func[10] = &clk_set_10; ! 	ctx->clk_func[11] = &clk_set_11; ! 	ctx->clk_func[12] = &clk_set_12; ! 	ctx->clk_func[13] = &clk_set_13; ! 	ctx->clk_func[14] = &clk_set_14; ! 	ctx->clk_func[15] = &clk_set_15; ! 	ctx->clk_func[16] = &clk_set_16; ! 	ctx->clk_func[17] = &clk_set_17; ! 	ctx->clk_func[18] = &clk_set_18; ! 	ctx->clk_func[19] = &clk_set_19; ! 	ctx->clk_func[20] = &clk_set_20; ! 	ctx->clk_func[21] = &clk_set_21; ! 	ctx->clk_func[22] = &clk_set_22;   	        /* 7         * Map the chain table so the ADQ can get at it.  	*/  	{  ? 	physical_addr	map;  /* Q-bus mapped address for chain table */    	    if (ctx->bus_adapter) {  ( 		    eln$unibus_map( ctx->adq_device_a, 				    &qr->chain_tbl,  				    (CHAIN_TBL_SZ * 2),  				    &map.full, 				    NULL);
 	    } else { 2 		map.full = eln$physical_address(&qr->chain_tbl); 	    }  ) 	    qr->chain_tbl_offset = map.bits.low;  	    qr->chain_tbl_seg.w	= 0; 0 	    qr->chain_tbl_seg.bits.seg = map.bits.high; 	}  	        /* B 	* The ADQ has a suggested calibration procedure using internally @ 	* generated reference voltages.  The calibration procedure will5 	* only be done the first time the device is init'ed._ 	*/T   	adq_auto_calibrate(ctx);Q       } else { 	/*-4 	 * if this is a reinit then adjust ctx accordingly. 	 */   	ctx = *context_id;i     }        /*,      * Do all things that reinit the device.      */        adq_reinit( status,a 		ctx, 		adc_entry_list,  		adc_entry_list_size, 		recycle_entry_list, 
 		eop_enable, 
 		clock_mode,  		t1_frequency, 
 		t1_divider,w 		t2_frequency, 
 		t2_divider,a 		conversion_count,  		delay_frequency, 		delay_divider);h }h t /*++  *'  * adq_reinit - Reset the ADQ32 device.s  *  * functional description:  *F  *	This routine marks all the entries in the request queue as aborted,H  *	stores the users new configuration data and (re)initialize the adq32.E  *	This an internal routine that is called by eln$adq_initialize and    *	adq_auto_calibrate.  *
  * inputs:  *?  *      context_id      - A pointer to an ADQ32 context record. A  *	reinit		- TRUE to reinitialized the ADQ32, FALSE if the is theu   *			  the first initialization.G  *	adc_entry_list	- Pointer to an array of adq$_adc_entry, the entries p1  *			  describe which channels to sample and how. L  *	adc_entry_list_size - Number of entries in adc_entry_list (=< 512)       :  *	recycle_entry_list - TRUE to recyle the adc_entry_list.B  *	eop_enable	-  TRUE if EOP is used to signal an end of transfer.8  *	clock_mode	- Specifies which clock mode to use.      >  *	t1_frequency    - Indicates the base frequency of t1 clock.@  *	t1_divider	- Indicates divider to be applied to t1_frequency.>  *	t2_frequency    - Indicates the base frequency of t2 clock.@  *	t2_divider	- Indicates divider to be applied to t2_frequency.H  *	conversion_count - Indicates number of samples to be taken per sweep.E  *	delay_frequency - Indicates the base frequency of the delay clock. G  *	delay_divider   - Indicates divider to be applied to the delay freq.n  *  * implicit inputs:   *  *      none  *  * outputs:l  *1  *      status          - Status of the operation_  *  * implicit outputs:  *                                                                                                                                                                                                                                                                            fT $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             "k              *      none  *  *--  */   I static void adq_reinit(status, ctx, adc_entry_list, adc_entry_list_size, eJ     recycle_entry_list, eop_enable, clock_mode, t1_frequency, t1_divider, A     t2_frequency, t2_divider, conversion_count, delay_frequency, e     delay_divider) adq_context_record	*ctx;) BOOLEAN			recycle_entry_list, eop_enable;i9 unsigned short int	*adc_entry_list;    /*adq$_adc_entry*/e4 int			adc_entry_list_size, clock_mode, t1_frequency,4 			t2_frequency, conversion_count, delay_frequency,  			*status;i9 unsigned short int	t1_divider, t2_divider, delay_divider;e {(% adq_region	    *qr = ctx->adq_region;i' adq_registers	    *reg = ctx->adq_regs;) read_desc	    *rd;
 int		    tmp;t       /*7      * Grab the ADQ and disable interrupts, flag abort._      * Signal the abort event.      */t  '     ELN$LOCK_MUTEX(ctx->hardware_lock);e0     write_register(ADQ_DMA_OFF, &reg->dma_conf);     qr->status.abort = TRUE;'     ker$signal(NULL, ctx->abort_event); ,     ker$clear_event(NULL, ctx->abort_event);       /*A      * Move all entries from the request queue to the done queue  =      * indicate all the data is bad and mark them as aborted.s      */n  	      do { & 	tmp = _REMQHI(&qr->req_queue, &rd);    	if (!(tmp & LOCKED_OR_EMPTY)) {# 	    rd->bad_count = rd->wrd_count;p' 	    rd->status    = ADQ$ENTRY_ABORTED; " 	    _INSQTI(rd, &qr->done_queue); 	}<      } while ( !(tmp & LOCKED_OR_EMPTY) || (tmp == LOCKED));       /*"      *  Save EOP processing state.      */         qr->status.eop = eop_ena             ble;       /*2      *  Init a template of the clock_configuration      *  register. >      *	    - this will clear the calibration bit if set by the%      *        get_ave_sample routine._O      *	    - fregs.clk_conf gets loaded into the ADQ in the clk_set_* routines.a      *%      *  Set the recycle ADC fifo bit.n=      *  Set the interrupt at end of ADC fifo bit accordingly.e5      *  Set the EOP enable bit like the user told us.E      */   3     qr->fregs.clk_conf.w = ADQ_CLK_OVRRUN_INTR_NBL;iC     qr->fregs.clk_conf.bits.parm_list_recycle = recycle_entry_list; 4     qr->fregs.clk_conf.bits.end_of_scan_intr_enable & 					    = recycle_entry_list ? 0 : 1;8     qr->fregs.clk_conf.bits.ext_eop_enable = eop_enable;       /*'      * Store away the users clock data..G      * The frequency information should be in low four bit of the word,iI      * it gets used in bit postions eight through 11, shift it there now.n      */a  #     qr->clk_data.mode = clock_mode;w4     qr->clk_data.t1f  = ((t1_frequency & 0xF) << 8);#     qr->clk_data.t1d  = t1_divider;d4     qr->clk_data.t2f  = ((t2_frequency & 0xF) << 8);#     qr->clk_data.t2d  = t2_divider;*)     qr->clk_data.t2c  = conversion_count;t7     qr->clk_data.delf = ((delay_frequency & 0xF) << 8);s&     qr->clk_data.deld = delay_divider;       /*,      * Do the cold ADQ initialize procedure.      */d  <     write_register(ADC_CTRL_MODULE_RESET, &reg->adq_ctrl.w);       /*!      * Clear the status register.n      */   7     write_register(ADQ_STAT_CLR_ALL, &reg->int_stat.w);r       /*      * Turn the clock off.      */y  ;     write_register(ADQ_CLK_CONF_DISABLE, &reg->clk_conf.w);x       /*3      * Reset DMA channels then Enable DMA transferso      */   @     DMA_WRITE(DMA_WINDOW_CH0_COMMAND,DMA_WIN_CH0_COMMAND_RESET);@     DMA_WRITE(DMA_WINDOW_CH1_COMMAND,DMA_WIN_CH1_COMMAND_RESET);  /     write_register(ADQ_DMA_ON, &reg->dma_conf);iF     DMA_WRITE(DMA_WINDOW_MASTER_MODE, DMA_WIN_MASTER_MODE_DMA_ENABLE);       /*B      * Prepare the chain table to store information for channel 1.N      * The VAXELN ADQ service routines do not take advantage of any Channel 1 $      * features, turn channel 1 off.8      * Note: DMA channel 0 gets loaded in eln$adq_start.      */e  ,     for (tmp = 0; tmp < CHAIN_TBL_SZ; tmp++)         qr->chain_tbl[tmp] = 0;I  8     qr->chain_tbl[CHT_CTRL_WRD] = CHT_CTRL_WRD_MOD_REGS;  /     qr->chain_tbl[1] = ADQ_DMA_CHANNEL_MODE_HI; >     qr->chain_tbl[2] = ( ADQ_DMA_CHANNEL_MODE_LO_CHAN_1_INIT | 			        ( eop_enable ? + 				  ADQ_DMA_CHANNEL_MODE_LO_EOP_ON : 0));-       /*@      * Load the ADQ's DMA chain registers with addresses the ADQM      * can use.  Then tell the ADQ to pull the chain into the ADQ DMA engine.(      */x  =     DMA_WRITE(DMA_WINDOW_CH1_CHAIN_SEG, qr->chain_tbl_seg.w); >     DMA_WRITE(DMA_WINDOW_CH1_CHAIN_OFF, qr->chain_tbl_offset);D     DMA_WRITE(DMA_WINDOW_CH1_COMMAND,   DMA_CH1_COMMAND_PULL_CHAIN);       /* _!      * Load the ADC fifo buffer         */a  B     for(tmp=0; tmp < adc_entry_list_size; tmp++,adc_entry_list++) 0 	write_register(*adc_entry_list, &reg->param.w);       /*1      *  Init status flags and Enable interrupts. r      */c       qr->status.abort = FALSE;i"     qr->status.adq_active = FALSE;&     qr->status.adq_double_buf = FALSE;  /     write_register(ADQ_DMA_ON, &reg->dma_conf);r)     ELN$UNLOCK_MUTEX(ctx->hardware_lock);s }a r /*++  *$  * init_clk - Initialize ADQ32 clock  *  * functional description:  *?  *	This routine performs the standard reset and initialization o+  *	procedures on the ADQ32 clock registers.I  *
  * inputs:2  *      reg		- A pointer to the ADQ32's registers.  *  * implicit inputs:*  *  *      none  *  * outputs:;  *
  *      none e  *  * implicit outputs:  *  *      none  *  *--  */_   static void init_clk(reg)u adq_registers	*reg;a {	     /*      * Reset the clock.	      */t  7     write_register(ADQ_CLK_CMD_RESET, &reg->clk_cmd.w);i       /*      * Select 16 bit bus mode.      */m      o<     write_register(ADQ_CLK_CMD_16_BIT_BUS, &reg->clk_cmd.w);       /*#      * Select Master mode register.t      */r  =     write_register(ADQ_CLK_CMD_MASTER_MODE, &reg->clk_cmd.w);	       /*3      * Enable auto-increment and set FOUT to 50 Hz.o      */   =     write_register(ADQ_CLK_DATA_50HZ_FOUT, &reg->clk_data.w);        /*(      * Select counter 5's mode register.      */       	=     write_register(ADQ_CLK_CMD_CNTR_5_MODE, &reg->clk_cmd.w);-       /*/      * Set counter 5's output to high impedancer      */   ?     write_register(ADQ_CLK      %       _DATA_HI_IMP_OUTP, &reg->clk_data.w);t      (     /*4      * Load all counters to clear any TC conditions.      */o  <     write_register(ADQ_CLK_CMD_LOAD_CNTRS, &reg->clk_cmd.w); }r h /*++  *2  * eln$adq_queue_read - Process a request for data  *  * functional description:  *K  *	This routine places a DMA read request for the ADQ32 on a request queue.;6  *	A maximum of 32 requests can be queued at any time.  *
  * inputs:?  *      context_id      - A pointer to an ADQ32 context record. /  *	dest_buffer	- A pointer to the users buffer.06  *	wrd_count	- The number of words to be transferred. C  *	user_id		- A user supplied Id value that will be associated withu  *			  the request.   *  * implicit inputs:s  *  *      none  *  * outputs:t  *1  *      status          - Status of the operation8  *  * implicit outputs:  *  *      none  *  *--  */lL void eln$adq_queue_read(status, context_id, dest_buffer, wrd_count, user_id)  adq_context_record  *context_id; char		    *dest_buffer;c% int		    wrd_count, user_id, *status;> {_) adq_region	*qr  = context_id->adq_region;] read_desc	*rd; physical_addr	dest_physical; int		qstat;>          /*"      * Establish an error handler.      */_  /     eln$establish_handler(eln$default_handler);_+     if (status) *status = ELN$_SUCCESS;    =       /*(      * Check the size of the word count.      */o  :     if ((wrd_count < -1) || (wrd_count > MAX_WORD_COUNT)) 1 	ker$raise_exception(NULL, ELN$_BADVALUE);			            /*      *	Get a read descri      (       ptor.mA      *  If there aren't any free request packets signal an error.L      */   ?     while ((qstat = _REMQHI(&qr->free_queue, &rd)) == LOCKED) ;e       if (qstat == WAS_EMPTY)t/ 	ker$raise_exception(NULL, ELN$_REQMAX);			    i       /**      * Fill in the requests relevent data.      */g       rd->wrd_count = wrd_count;      rd->dest_ptr  = dest_buffer;      rd->user_id	  = user_id;    $     rd->status	  = ADQ$ENTRY_EQUEUE;       /*@      * Get a memory address for the buffer that the ADQ can use.      */i  #     if (context_id->bus_adapter) { t* 	eln$unibus_map(	context_id->adq_device_a, 			dest_buffer,s 			(wrd_count * 2),  			&dest_physical.full,i	 			NULL);      } else {8 	dest_physical.full = eln$physical_address(dest_buffer);     }t       rd->buf_seg.w	 = 0;n3     rd->buf_seg.bits.seg = dest_physical.bits.high;i+     rd->buf_addr	 = dest_physical.bits.low;e       /*      * Enqueue the request.y      */d  (     qstat = _INSQTI(rd, &qr->req_queue); }c   /*++  *?  *  eln$adq_star                                                                                                                                                                                                                           (A $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             g      *       t  - Perform the ADQ32 clock dependent startup.e  *  * functional description:  *>  *	This routine tells the ADQ32 to start processing data.  TheA  *	DMA engine is loaded and the Clock and ADC are reset.  In manyi%  *	ways it is like a mini-initialize.o  *
  * inputs:?  *      context_id      - A pointer to an ADQ32 context record.i  *  * implicit inputs:x  *  *      none  *  * outputs:o1  *      status          - Status of the operationt  *  * implicit outputs:  *  *      none  *  *--  */t      +         & void eln$adq_start(status, context_id)! adq_context_record  	*context_id;p int   *status; {h) adq_region	*qr  = context_id->adq_region;t* adq_registers	*reg = context_id->adq_regs; read_desc	*rd; int tmp;       /*"      * Establish an error handler.      */.  /     eln$establish_handler(eln$default_handler); +     if (status) *status = ELN$_SUCCESS;    h       /*,      * Let no others mess with the hardware.      */b  .     ELN$LOCK_MUTEX(context_id->hardware_lock);       /*       * The ADQ is already active      */q  4     if (context_id->adq_region->status.adq_active) {- 	ELN$UNLOCK_MUTEX(context_id->hardware_lock);o+ 	ker$raise_exception(NULL, ELN$_ALLRDYRUN);e     }r       /*7      * There is nothing on the request queue to processt      */r       if (!qr->req_queue.flink) {l- 	ELN$UNLOCK_MUTEX(context_id->hardware_lock);t. 	ker$raise_exception(NULL, ELN$_NOREQ);			         }        /*&      * Turn off the clock and the DMA.      */t  ;     write_register(ADQ_CLK_CONF_DISABLE, &reg->clk_conf.w);e0     write_register(ADQ_DMA_OFF, &reg->dma_conf);       /*(      * Disable - Flush - Enable the ADC.      */r  ;     write_register(ADC_CTRL_DISABLE_ADC, &reg->adq_ctrl.w); :     write_register(ADC_CTRL_FLUSH_FIFO, &reg->adq_ctrl.w);7     write_register(ADC_CTRL_NBL_ADC, &reg->adq_ctrl.w);	       /*      * Set up the DMAi=      * Get a pointer to the first entry on the request queue.n       * ...and mark it as active.      */q       A     rd = (char *)&qr->req_queue.flink + (int)qr->req_q      .       ueue.flink;      "     rd->status = ADQ$ENTRY_ACTIVE;       /*!      * Reset the DMA Chain table.x      */i  ,     for (tmp = 0; tmp < CHAIN_TBL_SZ; tmp++)         qr->chain_tbl[tmp] = 0;t  3     qr->chain_tbl[CHT_CTRL_WRD] = CHT_CTRL_WRD_VAL;        /*K      * Load the buffer address and the word count of the first request intoa3      * the DMA chain table for the DMA channel 0 B._      */   0     qr->chain_tbl[CHT_CURR_SEG] = rd->buf_seg.w;/     qr->chain_tbl[CHT_CURR_OFF] = rd->buf_addr;a0     qr->chain_tbl[CHT_CURR_CNT] = rd->wrd_count;       /**      *  Set the command mode low register.5      *  Enable EOP if it is so desired.  This ensures A      *  that base to current reloading is disabled at the moment.t      */E  F     qr->chain_tbl[CHT_MOD_LO] = ADQ_DMA_CHANNEL_MODE_LO_CHAN_0_INIT | 9 		( qr->status.eop ? ADQ_DMA_CHANNEL_MODE_LO_EOP_ON : 0);}         /*7      * If there is another entry then double buffer it. C      * (if the pointer to the current request + the relative offsetp.      *  to the next entry != the queue header)      */c  ?     if (((char *)rd + (int)rd->link.flink) != &qr->req_queue) {r  ' 	rd = (char *)rd + (int)rd->link.flink;    	/*e) 	 * set the Channel 0 Base DMA registers.c 	 */  - 	qr->chain_tbl[CHT_BASE_SEG] = rd->buf_seg.w;n, 	qr->chain_tbl[CHT_BASE_OFF] = rd->buf_addr;- 	qr->chain_tbl[CHT_BASE_CNT] = rd->wrd_count;    	/*t 	 * Set double buffering flags.O 	 */   	rd->status  = ADQ$ENTRY_DBUF;" 	qr->status.adq_double_buf = TRUE;   	/*K) 	 *  Reint the command mode low register.b' 	 *  - Enable EOP if it is so desired. t( 	 *  - Enable base to current reloading. 	 */  J         qr->chain_tbl[CHT_MOD_LO] = ADQ_DMA_CHANNEL_MODE_LO_CHAN_0_INIT | / 		    ADQ_DMA_CHANNEL_MODE_LO_RELOAD_TRANS_ON |oA 	    	    ( qr->status.eop ? ADQ_DMA_CHANNEL_MODE_LO_EOP_ON : 0);o       }        /*(      * Set the channel mode hi register.      */n  8     qr->chain_tbl[CHT_MOD_HI] = ADQ_DMA_CHANNEL_MODE_HI;       /*      * Load the chain table.      */t  =     DMA_WRITE(DMA_WINDOW_CH0_CHAIN_SEG, qr->chain_tbl_seg.w);v>     DMA_WRITE(DMA_WINDOW_CH0_CHAIN_OFF, qr->chain_tbl_offset);D     DMA_WRITE(DMA_WINDOW_CH0_COMMAND,   DMA_CH0_COMMAND_PULL_CHAIN);       /*7      * Ensure that the DMA and ADC engines are talking.       */l  A     DMA_WRITE(DMA_WINDOW_CH0_COMMAND,   DMA_CH0_COMMAND_CON_DMA);lF     DMA_WRITE(DMA_WINDOW_CH0_COMMAND,   DMA_CH0_COMMAND_NBL_DMA_INTR);       /*      * Enable dma interrupts.t      */   /     write_register(ADQ_DMA_ON, &reg->dma_conf);_       /*      * Reset the clock.       */*  #     init_clk(context_id->adq_regs);r       /*!      * All clear to start the ADQc      */   !     qr->status.adq_active = TRUE;h       /*2      * Call the clock mode specific clock routine.      */A  C     (context_id->clk_func[(context_id->adq_region->clk_data.mode)])A4 	    (context_id->adq_regs, context_id->adq_region);    0     ELN$UNLOCK_MUTEX(context_id->hardware_lock); }O   /*++  *I  * eln$adq_transfer_done - Check if an entry has been return by the ADQ32n  *  * functional description:  *D  *	Remove an ADQ32 read request from the done queue and return it toE  *	the caller.  If a timeout value was specified, wait upto that longoB  *	for an request to turn up.  During the time of waiting an abortB  *	ADQ32 condition caused by a reinitialization will also wake up   *	the caller.  *
  * inputs:?  *      context_id      - A pointer to an ADQ32 context record.r6  *	time_out	- A pointer to the amount of time to wait.  *  * implicit inputs:   *  *      none  *  * outputs:O0  *	user_id		- Receives the user defined id code.?  *	dest_buffer	- Receives a pointer to the area in memory that l  *			  received the data.iI  *	bad_count	- Receives the count of words that failed to transfer.      G1  *      status          - Status of the operationC3  *      req_status      - The status of the requestM  *  * implicit outputs:  *  *      none  *  *--  */   E void eln$adq_transfer_done(status, context_id, user_id, dest_buffer, <' 			    bad_count, req_status, time_out)t  adq_context_record  *context_id; char	    **dest_buffer; 3 int	    *user_id, *bad_count, *status, *req_status;. LARGE_INTEGER	*time_out; {s) adq_region	*qr  = context_id->adq_region;  int		qstat;  read_desc	*rd; physical_addr	dest_physical;         /*"      * Establish an error handler.      */M  /     eln$establish_handler(eln$default_handler);i+     if (status) *status = ELN$_SUCCESS;    o       /*)      * Get a request from the done queue.a      */e  ?     while ((qstat = _REMQHI(&qr->done_queue, &rd)) == LOCKED) ;I       /*A      * If the queue was empty then wait for something to turn up.i4      *	    The four things that can wake us up are.       *	    1)    A timeout.p6      *	    2,3)  A signal device from one of the ISRs.      *	    4)	  An abort event.t      */a       if (qstat == WAS_EMPTY) {o& 	ker$wait_any(status, NULL, time_out,  			context_id->adq_device_a, ) 			context_id->adq_device_b, b 			context_id->abort_event);  ; 	while ((qstat = _REMQHI(&qr->done_queue, &rd)) == LOCKED);      }*       /*P      * If a request entry was aquired then return the values the user requested.      */>  %     if (!(qstat & LOCKED_OR_EMPTY)) {o 	/*e, 	 * An entry has been procured for the user.8 	 * If requested return the: user_id, bad_count, status. 	 */  ( 	if (user_id)	*user_id    = rd->user_id;, 	if (bad_count)	*bad_count  = rd->bad_count;+ 	if (req_status)	*req_status = rd->status;     	/* 1 	 * The address of the buffer is always returned.* 	 */ 	  	 *dest_buffer = rd->dest_ptr;   	/*, 	 * Unmap the data.  	 */       	dest_physical.full = 0;  0 	dest_physical.bits.high = rd->buf_seg.bits.seg;( 	dest_physical.bits.low  = rd->buf_addr;   	if (context_id->bus_adapter) 0 	    eln$unibus_unmap( context_id->adq_device_a, 			    rd->dest_ptr, 			    (rd->wrd_count * 2),l 			    dest_physical.full);h 				 	/*a' 	 * Return the entry to the free queue.e 	 */   	_INSQTI(rd, &qr->free_queue);       } else { 	/*xE 	 * Either a timout occured or an Abort event bumped us off an empty p. 	 * queue.  Tell the caller nothing was found. 	 */ 	 ( 	if (user_id)    *user_id   = 0;          	if (bad_count)  *bad_count = 0;3 	if (req_status)	*req_status = ADQ$ENTRY_NOTFOUND; p 	*dest_buffer  = 0;*     }o }    /*++  *G  * adq_auto_calibrate - set the ADQ32's internal calibration registers.i  *  * functional description:  *F  *	Calibrate the ADQ32 using the internal reference voltages differentF  *	methods are employed depending on whether the ADQ32 is jumpered for  *	uni                                                                                                                                                                                                                   
                        L $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             i "     ;        or bi polar operation.,  *
  * inputs:?  *      context_id      - A pointer to an ADQ32 context record.c  *  * implicit inputs:n  *  *      none  *  * outputs:t  *  *      none  *  * implicit outputs:  *  *      none  *--  */l  * static void adq_auto_calibrate(context_id)  adq_context_record  *context_id; {t. adq_registers	    *reg = context_id->adq_regs; intrpt_status_reg   is_reg;t; adq$_adc_entry	    adc_list = 0, *adc_list_ptr = &adc_list;E int		    status, buf_t;  short int	    calib_constant;        /*A      * fetch a copy of the interrupt status register and find out 9      * if the ADQ is running in bipolar or unipolar mode.       */   /     is_reg.w = read_register(&reg->int_stat.w);,           if (is_reg.bits.bi_unipolar)( 	calib_constant = 04;	    /* unipolar */     else* 	calib_constant = 0140004;   /* bipolar */       /*)      * Calibrate channel 1 at unity gain.       */t  B     calibrate_reg(context_id, calib_constant, 1, ADQ$_GAIN_UNITY, ! 		    ADQ$_GAIN_UNITY, GT, NULL);        /*"      *   Calibrate the Scaling DAC      */i      (      if (is_reg.bits.bi_unipolar), 	calib_constant = 0077774;   /*	unipolar  */     else+ 	calib_constant = 0037764;   /*	bipolar	 */f       /*&      * Use channel 2 with a gain of 1.      */>  B     calibrate_reg(context_id, calib_constant, 2, ADQ$_GAIN_UNITY, # 		  ADQ$_GAIN_K_SCALING, LT, NULL);i       /*      * Determine analog ground@      * Different methods are employed depending on the polarites      * of the situation.      */P  "     if (is_reg.bits.bi_unipolar) {% 	calib_constant = 04;	/*  unipolar */* 	/*T: 	 * OFFSET DAC Gain of 2 - Use channel 0 with a gain of 2.: 	 * OFFSET DAC Gain of 4 - Use channel 0 with a gain of 4.: 	 * OFFSET DAC Gain of 8 - Use channel 0 with a gain of 8. 	 */= 	calibrate_reg(context_id, calib_constant, 0, ADQ$_GAIN_K_2,   		      ADQ$_GAIN_K_2, GT, 2);= 	calibrate_reg(context_id, calib_constant, 0, ADQ$_GAIN_K_4, o 		      ADQ$_GAIN_K_4, GT, 4);= 	calibrate_reg(context_id, calib_constant, 0, ADQ$_GAIN_K_8, a 		      ADQ$_GAIN_K_8, GT, 8);     } else { 	/*x 	 * bipolar  	 */   	adc_list.adq$_v_channel = 0;_& 	adc_list.adq$_v_gain = ADQ$_GAIN_K_1;   	/*i, 	 * Reinit the ADQ  to do a burst mode read. 	 */ 	* 	adq_reinit( &status,d 		    context_id, - 		    &adc_list,	    /* addres of adc list */ ' 		    1,		    /* size of adc list	  */	 ( 		    TRUE,	    /* recycle entry list */# 		    FALSE,	    /* EOP Enable	  */$+ 		    ADQ$_K_CLOCK_MODE_1, /* Clock mode */ # 		    NULL,	    /* t1_frequency, */ ! 		    NULL,	    /* t1_divider, */_# 		    NULL,	    /* t2_frequency, */L! 		    NULL,	    /* t2_divider, */)' 		    NULL,	    /* conversion_count, */Y& 		    NULL,	    /* delay_frequency, */% 		    NULL);	    /* delay_divider, */s   	/*  	 * Get a sample of data.e 	 */  4 	adq_get_ave_sample(NULL, context_id, 2000, &buf_t);  -         calib_constant = (buf_t * 8)  / 2000;    	/* : 	 * OFFSET DAC Gain of 2 - Use channel 0 with a gain of 2.: 	 * OFFSET DAC Gain of 4 - Use channel 0 with a gain of 4.: 	 * OFFSET DAC Gain of 8 - Use channel 0 with a gain of 8. 	 */  = 	calibrate_reg(context_id, calib_constant, 0, ADQ$_GAIN_K_2, t  		     ADQ$_GAIN_K_2, GT, NULL);= 	calibrate_reg(context_id, calib_constant, 0, ADQ$_GAIN_K_4, t! 		      ADQ$_GAIN_K_4, GT, NULL);_= 	calibrate_reg(context_id, calib_constant, 0, ADQ$_GAIN_K_8,  ! 		      ADQ$_GAIN_K_8, GT, NULL);n     }t }r e /*++  *2  * Best Match - Which value is closer to the goal?  *  * functional description:  *K  *	Given a goal and two values determine which value is closer to the goal.   *
  * inputs:&  *      base	- The value to use a goal  *	v1	- The first contender_  *	v2	- The second contender  *  * implicit inputs:   *  *      none  *  * outputs:T  *  Return values.!  *	    1   - V1 is closer to basea"  *	    0   - V2 is closer to base.  *  * implicit outputs:  *  *      none  *  *--  */B  $ static int best_match (base, v1, v2) short int   base, v1, v2;  {r     v1 -= base;U     v2 -= base;_       if (v1 < 0)	v1 *= -1;_     if (v2 < 0)	v2 *= -1;        return ((v1 < v2) ? 1 : 0);o }l r /*++  *;  * adq_get_ave_sample - Gather a data sample from the ADQ32*  *  * functional description:  *>  *	Given a sample size, fetch the sample add it all up into a E  *	int value and return.  Samples of up to 524k could be accommodatedD  *	if the memory existed.   *
  * inputs:  *?  *      context_id      - A pointer to an ADQ32 context record.f  *  * implicit inputs:n  *  *      none  *  * outputs:   *1  *      status          - Status of the operation   *  * implicit outputs:  *  *      none  *  *--  */e  H static void adq_get_ave_sample( status, context_id, sample_size, sample)  adq_context_record  *context_id;' int		    sample_size, *sample, *status;s {w) adq_region  *qr = context_id->adq_region;a short int   *buf, *rbuf; int	    rstat; int	    istatus, i, total=0; LARGE_INTEGER	time_out; & $DESCRIPTOR(time_str,"0 00:01:00.00");       /*(      * Create a one second timout value.      */a  )     time_out = eln$time_value(&time_str);i       /*      * make us a buffer.      */r       sample_size += 10;B     eln$allocate_clear_memory(NULL, (int)(sample_size * 2), &buf);       /*-      * Tell the clock we desire to calibrate.       */   7     qr->fregs.clk_conf.bits.calibration_enable  = TRUE;        /*&      * Go forth and fetchith the data.      */   A     eln$adq_queue_read(NULL, context_id, buf, sample_size, NULL);        /*      * Start the beast..      */t     $     eln$adq_start(NULL, context_id);       /*D      * Here the intrepid software developer waits to see if anything      * will come back.      */    C  R     eln$adq_transfer_done(NULL, context_id, NULL, &rbuf, NULL, &rstat, &time_out);       if (rstat != ADQ$ENTRY_TD)4 	ker$raise_exception(NULL, ELN$_DEVNOTREADY);			           /*+      * Tally up the average of the buffer, M-      * don't use the first couple of samples.E      */        rbuf = buf;*     for (i = 0; i < 10; i++) 	rbuf++;  0     for (i = 10; i < sample_size; i++, rbuf++) { 	total += *rbuf;     }c       *sample = total;&     eln$deallocate_memory(NULL, &buf); }c   /*++  *  * calibrate_reg  *  * functional description:  *J  *	Given a channel and all the relavent information calibrate the channel.  *
  * inputs:  *?  *      context_id      - A pointer to an ADQ32 context record._6  *	goal		- A value that the register is tuned towards.B  *	adc_channel	- The channel that's to be use as a voltage source.:  *	adc_gain	- The gain at which that sample will be taken.8  *	calib_gain	- The calibration register to be adjusted.;  *	relation	- The type of check to be performed on the goall0  *	divisor		- Used with bipolar as a gain shift.  *  * implicit inputs:n  *  *      none  *  * outputs:A  *  *      none  *  * implicit outputs:  *  *      none  *--  */l  C static void calibrate_reg(context_id, goal, adc_channel, adc_gain, o# 			  calib_gain, relation, divisor)e  adq_context_record  *context_id; short int   goal;u= int	    adc_channel, adc_gain, calib_gain, relation, divisor;s {e; adq$_adc_entry	    adc_list = 0, *adc_list_ptr = &adc_list;o. adq_registers	    *reg = context_id->adq_regs; calibration_reg	    calib; int		    status; int		    sample_size = 1500; int		    total;t short int	    old_val, new_val;r# unsigned char	    old_dat, cur_bit;        /*!      *	Prepare an adc entry list.t      */*  *     adc_list.adq$_v_channel = adc_channel;$     adc_list.adq$_v_gain = adc_gain;       /*%      * Reinit the ADQ for burst mode.i      */           adq_reinit( NULL,i 		context_id, & 		&adc_list,  /* addres of adc list */" 		1,	    /* size of adc list	  */	$ 		TRUE,	    /* recycle entry list */ 		FALSE,	    /* EOP Enable	  */q' 		ADQ$_K_CLOCK_MODE_1, /* Burst mode */t 		NULL,	    /* t1_frequency, */t 		NULL,	    /* t1_divider, */* 		NULL,	    /* t2_frequency, */l 		NULL,	    /* t2_divider, */t# 		NULL,	    /* conversion_count, */ " 		NULL,	    /* delay_frequency, */! 		NULL);	    /* delay_divider, */l       /*%      * Init the calibration register.K=      * Set the high bit in the cur_bit, the bit being tested.o      */o          calib.w = 0;      calib.bits.reg = calib_gain;       cur_bit = 0x80;        do { 	/* ( 	 * Set cur_bit in the calibration data. 	 */   	calib.bits.data |= cur_bit;( 	write_register(calib.w, &reg->calib.w);   	/*  	 * Get a sample of data.  	 */  ; 	adq_get_ave_sample(NULL, context_id, sample_size, &total);_   	/*	) 	 * Create an OCTAL FLOATING POINT value.t 	 */  & 	new_val = (total *                                                                                                                                                                                                                                                                            `bQ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                              "     L       8)  / sample_size; 	  	/* F 	 * When calibrating UNIPOLAR register a divisor is sometimes employed# 	 * to counter the effects of gain.( 	 */  
 	if (divisor)T 	    new_val /= divisor;   	/*e: 	 * If the average value was greater then the desired goal3 	 * then turn the bit, that is being worked on off.d 	 */   	switch (relation) 	{
 	    case GT:  		if (new_val > goal)r! 		    calib.bits.data ^= cur_bit;; 		break;  
 	    case LT:  		if (new_val < goal) ! 		    calib.bits.data ^= cur_bit;r 		break;   	    case LEQ: 		if (new_val <= goal)! 		    calib.bits.data ^= cur_bit;  		break; 	}   	/*i 	 * Move it to the right a bit._ 	 */   	cur_bit >>= 1;	           } while (cur_bit);       /*8      * See if adding one will get us closer to our goal.      */s       old_val = new_val;     old_dat = calib.bits.data;     calib.bits.data++;+     write_register(calib.w, &reg->calib.w);        /*      * Get a sample of data.      */   >     adq_get_ave_sample(NULL, context_id, sample_size, &total);       /*,      * Create an OCTAL FLOATING POINT value.      */   )     new_val = (total * 8)  / sample_size;        /*N      * Set calib to value that best_match indicates comes closest to the goal.      */e  -     if ( best_match(goal, old_val, new_val)) a 	calib.bits.data = old_dat;e     /*5      * Write the final value to the calibaration DAC.*      */b  +     write_register(calib.w, &reg->calib.w);t }s f /*++  *  * clk_set_*  *  * functional description:  *.  *	Do the clock mode specific initializations.  *
  * inputs:  **  *	reg		- A pointer to the ADQ32 registers&  *	qr		- A pointer to the data region.  *  * implicit inputs:   *  *      none  *  * outputs:   *1  *      status          - Status of the operation   *  * implicit outputs:  *  *      none  *  *--  */e   /*  * Burst mode.  */_ void clk_set_1(reg, qr)e adq_registers	*reg;r adq_region	*qr;s {g unsigned short int wtmp;  -     write_register(0177500, &reg->clk_cmd.w);s<     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_PROG;+     write_register(wtmp, &reg->clk_conf.w);t5     write_register(ADC_CTRL_START, &reg->adq_ctrl.w);a }r   /*  * Burst, with edge gate.   */g void	clk_set_2(reg, qr)i adq_registers	*reg;  adq_region	*qr;. {u unsigned short int wtmp;  !     /* Set up clock register 3 */c-     write_register(0177403, &reg->clk_cmd.w); .     write_register(014041,  &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);_!     /* Set up clock register 5 */ -     write_register(0177405, &reg->clk_cmd.w);*.     write_register(014045,  &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);n     /*			      */n-     write_register(0177524, &reg->clk_cmd.w);;-     write_register(0177763, &reg->clk_cmd.w);l     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3;A+     write_register(wtmp, &reg->clk_conf.w);)-     write_register(0177464, &reg->clk_cmd.w);    }D   /*!  * Burst, with delayed edge gate.n  */p void	clk_set_3(reg, qr)i adq_registers	*reg;  adq_region	*qr;t {i unsigned short int wtmp;  3     /* Set up the delay time in clock register 3 */f-     write_register(0177403, &reg->clk_cmd.w);T&     wtmp = qr->clk_data.delf | 0xF0A1;.     write_register(wtmp,    &reg->clk_data.w);9     write_register(qr->clk_data.deld,  &reg->clk_data.w);b!     /* Set up clock register 5 */ -     write_register(0177405, &reg->clk_cmd.w);e-     write_register(04,	    &reg->clk_data.w);      /*			      */G-     write_register(0177524, &reg->clk_cmd.w);n     /*	Enable the ADC */Y     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3 | ADQ_CLK_CONF_GATE_TOG_NBL;a+     write_register(wtmp, &reg->clk_conf.w);_-     write_register(0177464, &reg->clk_cmd.w);  }e   /*(  * Burst, activated by external trigger.  */x void	clk_set_4(reg, qr)  adq_registers	*reg;i adq_region	*qr;	 {  unsigned short int wtmp;  !     /* Set up clock register 3 */s-     write_register(0177403, &reg->clk_cmd.w); .     write_register(0165401, &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w); !     /* Set up clock register 5 */ -     write_register(0177405, &reg->clk_cmd.w);i-     write_register(04,	    &reg->clk_data.w);*     /*			      */ -     write_register(0177524, &reg->clk_cmd.w);aW     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3 | ADQ_CLK_OVRRUN_INTR_NBL;t+     write_register(wtmp, &reg->clk_conf.w);a-     write_register(0177464, &reg->clk_cmd.w);D }G   /*  * Timed triggersw  */  void	clk_set_5(reg, qr)C adq_registers	*reg;n adq_region	*qr;o {. unsigned short int wtmp;  !     /* Set up clock register 4 */ -     write_register(0177404, &reg->clk_cmd.w);,%     wtmp = qr->clk_data.t1f | 0x1021;K.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);     /*			      */e-     write_register(0177510, &reg->clk_cmd.w);_     /*			      */G=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4; +     write_register(wtmp, &reg->clk_conf.w);n     /*			      */:-     write_register(0177450, &reg->clk_cmd.w);w }h   /*!  * Timed triggers, with Edge Gatep  */  void	clk_set_6(reg, qr)t adq_registers	*reg;  adq_region	*qr;e {  unsigned short int wtmp;  !     /* Set up clock register 3 */ -     write_register(0177403, &reg->clk_cmd.w); .     write_register(014040,  &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);:&     /* Set up T1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w); %     wtmp = qr->clk_data.t1f | 0x30A1; .     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);**     write_register(04,  &reg->clk_data.w);(     write_register(0,	&reg->clk_data.w);     /*			      */i-     write_register(0177534, &reg->clk_cmd.w);l-     write_register(0177503, &reg->clk_cmd.w); -     write_register(0177763, &reg->clk_cmd.w);      /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4;o+     write_register(wtmp, &reg->clk_conf.w);s-     write_register(0177474, &reg->clk_cmd.w);* }*   /*)  * Timed triggers, with Delayed Edge Gate_  */a void	clk_set_7(reg, qr)  adq_registers	*reg;  adq_region	*qr;d {c unsigned short int wtmp;  3     /* Set up the delay time in clock register 3 */x-     write_register(0177403, &reg->clk_cmd.w);n&     wtmp = qr->clk_data.delf | 0xF0A1;.     write_register(wtmp,    &reg->clk_data.w);9     write_register(qr->clk_data.deld,  &reg->clk_data.w);t&     /* Set up T1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w);m%     wtmp = qr->clk_data.t1f | 0x50A1;e.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);t*     write_register(04,  &reg->clk_data.w);     /*			      */e-     write_register(0177534, &reg->clk_cmd.w);,     /*	Enable the ADC */Y     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_GATE_TOG_NBL | ADQ_CLK_CONF_TRIG_BY_REG_4;o+     write_register(wtmp, &reg->clk_conf.w);d-     write_register(0177474, &reg->clk_cmd.w);  }*   /*"  * Timed triggers, with Level Gate  */r void	clk_set_8(reg, qr)_ adq_registers	*reg;, adq_region	*qr;t {  unsigned short int wtmp;  &     /* Set up T1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w);h%     wtmp = qr->clk_data.t1f | 0x70A1;t.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);
     /*  */-     write_register(0177510, &reg->clk_cmd.w);+     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4; +     write_register(wtmp, &reg->clk_conf.w); -     write_register(0177450, &reg->clk_cmd.w);e }l   /*0  * Timed triggers, activated by external trigger  */  void	clk_set_9(reg, qr)  adq_registers	*reg;  adq_region	*qr;  {g unsigned short int wtmp;        /* Set up clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);e.     write_register(0165441, &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);r&     /* Set up T1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w);g%     wtmp = qr->clk_data.t1f | 0x50A1;s.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);_-     write_register(04,	    &reg->clk_data.w);g	     /* */o-     write_register(0177534, &reg->clk_cmd.w);      /*	Enable the ADC */W     wtmp =                                                                                                                                                                                                                                                                           0 $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             P "     ]        qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4 | ADQ_CLK_OVRRUN_INTR_NBL; +     write_register(wtmp, &reg->clk_conf.w);r-     write_register(0177474, &reg->clk_cmd.w);_ }	   /*  * Burst Sweepsa  */  void	clk_set_10(reg, qr) adq_registers	*reg;  adq_region	*qr;_ {, unsigned short int wtmp;  &     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);_%     wtmp = qr->clk_data.t2f | 0x1021; .     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w); .     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */*-     write_register(0177524, &reg->clk_cmd.w); -     write_register(0177765, &reg->clk_cmd.w);_     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3; +     write_register(wtmp, &reg->clk_conf.w); -     write_register(0177464, &reg->clk_cmd.w);e }    /*  * Burst Sweeps, with Edge Gate   */  void	clk_set_11(reg, qr) adq_registers	*reg;  adq_region	*qr;{ {/ unsigned short int wtmp;        /* Set up clock register 2*/-     write_register(0177402, &reg->clk_cmd.w);&.     write_register(014040,  &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);d&     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);n%     wtmp = qr->clk_data.t2f | 0x30A1; .     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);a.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */b-     write_register(0177526, &reg->clk_cmd.w); -     write_register(0177502, &reg->clk_cmd.w);	-     write_register(0177762, &reg->clk_cmd.w);)-     write_register(0177765, &reg->clk_cmd.w);      /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3; +     write_register(wtmp, &reg->clk_conf.w);e-     write_register(0177466, &reg->clk_cmd.w);  }l   /*   * Burst Sweeps, with Level Gate  */t void	clk_set_12(reg, qr) adq_registers	*reg;c adq_region	*qr;i {) unsigned short int wtmp;  &     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);l%     wtmp = qr->clk_data.t2f | 0x90A1;O.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);b.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */ -     write_register(0177524, &reg->clk_cmd.w);:-     write_register(0177765, &reg->clk_cmd.w);i     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3;t+     write_register(wtmp, &reg->clk_conf.w); -     write_register(0177464, &reg->clk_cmd.w);  }t   /*.  * Burst Sweeps, activated by external trigger  */p void	clk_set_13(reg, qr) adq_registers	*reg;* adq_region	*qr;_ {o unsigned short int wtmp;        /* Set up clock register 1*/-     write_register(0177401, &reg->clk_cmd.w);i.     write_register(014000,  &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);       /* Set up clock register 2*/-     write_register(0177402, &reg->clk_cmd.w);&,     write_register(0,	    &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);_&     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w); %     wtmp = qr->clk_data.t2f | 0x3021;4.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);g.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */7-     write_register(0177527, &reg->clk_cmd.w);/-     write_register(0177761, &reg->clk_cmd.w);F-     write_register(0177762, &reg->clk_cmd.w);--     write_register(0177765, &reg->clk_cmd.w);g     /*	Enable the ADC */W     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3 | ADQ_CLK_OVRRUN_INTR_NBL; +     write_register(wtmp, &reg->clk_conf.w);m-     write_register(0177467, &reg->clk_cmd.w);i }r   /*6  * Burst Sweeps, Sweep controlled by external trigger.  */q void	clk_set_14(reg, qr) adq_registers	*reg;w adq_region	*qr;_ {a unsigned short int wtmp;        /* Set up clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);t.     write_register(0165441, &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);	      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w); .     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */B-     write_register(0177524, &reg->clk_cmd.w);d-     write_register(0177765, &reg->clk_cmd.w);_     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_3;t+     write_register(wtmp, &reg->clk_conf.w);r-     write_register(0177464, &reg->clk_cmd.w);r }_   /*  * Timed Sweepsc  */t void	clk_set_15(reg, qr) adq_registers	*reg;  adq_region	*qr;7 {5 unsigned short int wtmp;  &     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);4%     wtmp = qr->clk_data.t2f | 0x1021;e.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);      /* Set up clock register 4*/-     write_register(0177404, &reg->clk_cmd.w);i%     wtmp = qr->clk_data.t1f | 0x50A1; .     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);x.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */ -     write_register(0177534, &reg->clk_cmd.w);I-     write_register(0177765, &reg->clk_cmd.w);k     /*	Enable the ADC */?     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4  ;*+     write_register(wtmp, &reg->clk_conf.w);c-     write_register(0177474, &reg->clk_cmd.w);e }n /*  * Timed Sweeps, with edge gate   */  void	clk_set_16(reg, qr) adq_registers	*reg;t adq_region	*qr;> {_ unsigned short int wtmp;        /* Set up clock register 2*/-     write_register(0177402, &reg->clk_cmd.w); .     write_register(014040,  &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w);q&     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);e%     wtmp = qr->clk_data.t2f | 0x30A1;a.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);&     /* Set up t1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w); %     wtmp = qr->clk_data.t1f | 0x50A1;m.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);G.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */g-     write_register(0177536, &reg->clk_cmd.w);m-     write_register(0177502, &reg->clk_cmd.w);i-     write_register(0177762, &reg->clk_cmd.w);l-     write_register(0177763, &reg->clk_cmd.w);A     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4; +     write_register(wtmp, &reg->clk_conf.w);c-     write_register(0177476, &reg->clk_cmd.w);g }l   /*   * Timed Sweeps, with Level gate  */0 void	clk_set_17(reg, qr) adq_registers	*reg;a adq_region	*qr;e {t unsigned short int wtmp;  &     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);m%     wtmp = qr->clk_data.t2f | 0x90A1;l.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);&     /* Set up t1 in clock register 4*/-     write_register(0177404, &reg->clk_                                                                                                                                                                                                                                                                           'q $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             T      n       cmd.w);4%     wtmp = qr->clk_data.t1f | 0x50A1;c.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);d.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */t-     write_register(0177534, &reg->clk_cmd.w);;-     write_register(0177765, &reg->clk_cmd.w);>     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4;I+     write_register(wtmp, &reg->clk_conf.w);c-     write_register(0177474, &reg->clk_cmd.w);> }_   /*.  * Timed Sweeps, Activated by External Trigger  */l void	clk_set_18(reg, qr) adq_registers	*reg;e adq_region	*qr;d {e unsigned short int wtmp;        /* Set up clock register 1*/-     write_register(0177401, &reg->clk_cmd.w);g.     write_register(014000,  &reg->clk_data.w);*     write_register(02,  &reg->clk_data.w);      /* Set up clock register 2*/.      write_register(0177402, &reg->clk_cmd.w);,     write_register(0,	    &reg->clk_data.w);-     write_register(02,	    &reg->clk_data.w); &     /* Set up t2 in clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);t%     wtmp = qr->clk_data.t2f | 0x3021;t.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t2d,  &reg->clk_data.w);&     /* Set up t1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w);n%     wtmp = qr->clk_data.t1f | 0x50A1;C.     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);r.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */t-     write_register(0177537, &reg->clk_cmd.w);t-     write_register(0177761, &reg->clk_cmd.w);*-     write_register(0177762, &reg->clk_cmd.w);0-     write_register(0177765, &reg->clk_cmd.w);0     /*	Enable the ADC */W     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4 | ADQ_CLK_OVRRUN_INTR_NBL;2/     write_register(wtmp,	    &reg->clk_conf.w);a.     write_register(0177477,  &reg->clk_cmd.w); }>   /*6  * Timed Sweeps, Sweep controlled by external trigger.  */* void	clk_set_19(reg, qr) adq_registers	*reg;n adq_region	*qr;F {I unsigned short int wtmp;  &     /* Set up t1 in clock register 4*/-     write_register(0177404, &reg->clk_cmd.w);*%     wtmp = qr->clk_data.t1f | 0x50A1; .     write_register(wtmp,    &reg->clk_data.w);8     write_register(qr->clk_data.t1d,  &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);r.     write_register(02445,   &reg->clk_data.w);<     /* store two times the number of data items per sweep */      wtmp = qr->clk_data.t2c * 2;.     write_register(wtmp,    &reg->clk_data.w);	     /* */2-     write_register(0177530, &reg->clk_cmd.w);>-     write_register(0177765, &reg->clk_cmd.w);2     /*	Enable the ADC */Z     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_TRIG_BY_REG_4 | ADQ_CLK_CONF_XTRN_GATE_NBL;/     write_register(wtmp,	    &reg->clk_conf.w);t.     write_register(0177470,  &reg->clk_cmd.w); }    /*  * External Triggers    */r void	clk_set_20(reg, qr) adq_registers	*reg;* adq_region	*qr;e {t unsigned short int wtmp;        /* Set up clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);r,     write_register(0,	    &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);D-     write_register(04,	    &reg->clk_data.w);w	     /* */c-     write_register(0177524, &reg->clk_cmd.w);>     /*	Enable the ADC */W     wtmp = qr->fregs.clk_conf.w | ADQ_CLK_CONF_XTRN_GATE_NBL | ADQ_CLK_OVRRUN_INTR_NBL;_/     write_register(wtmp,	    &reg->clk_conf.w); .     write_register(0177464,  &reg->clk_cmd.w); }t   /*$  * External Triggers      v       , with edge gate  */k void	clk_set_21(reg, qr) adq_registers	*reg;  adq_region	*qr;w {  unsigned short int wtmp;        /* Set up clock register 3*/-     write_register(0177403, &reg->clk_cmd.w);r,     write_register(0,	    &reg->clk_data.w);      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);e-     write_register(04,	    &reg->clk_data.w); 	     /* */i-     write_register(0177524, &reg->clk_cmd.w);      /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w	| ADQ_CLK_CONF_XTRN_GATE_NBL )! 				| ADQ_CLK_CONF_XTRN_FREQ_NBL t" 				| ADQ_CLK_CONF_TRIG_BY_REG_4    				| ADQ_CLK_CONF_TRIG_BY_REG_3  				| ADQ_CLK_CONF_GATE_TOG_NBL;/     write_register(wtmp,	    &reg->clk_conf.w);t.     write_register(0177464,  &reg->clk_cmd.w); }g   /*,  * External Triggers, with delayed edge gate  */  void	clk_set_22(reg, qr) adq_registers	*reg;  adq_region	*qr;l {  unsigned short int wtmp;        /* Set up clock register 3*/-     write_register(0177403, &reg->clk_cmd.w); &     wtmp = qr->clk_data.delf | 0xF0A1;.     write_register(wtmp,    &reg->clk_data.w);9     write_register(qr->clk_data.deld,  &reg->clk_data.w);r      /* Set up clock register 5*/-     write_register(0177405, &reg->clk_cmd.w);*-     write_register(04,	    &reg->clk_data.w);i	     /* */3-     write_register(0177524, &reg->clk_cmd.w);2     /*	Enable the ADC */=     wtmp = qr->fregs.clk_conf.w	| ADQ_CLK_CONF_XTRN_FREQ_NBL d" 				| ADQ_CLK_CONF_TRIG_BY_REG_4    				| ADQ_CLK_CONF_TRIG_BY_REG_3  				| ADQ_CLK_CONF_GATE_TOG_NBL;/     write_register(wtmp,	    &reg->clk_conf.w);a.     write_register(0177464,  &reg->clk_cmd.w); }m e /*++  *,  * adq_isr - ADQ32 Interrupt service routine  *  * functional description:  *C  *	An interrupt is recieved from one of two vectors.  Determine thet*  *	nature of the interrupt and process it.  *
  * inputs:  *.  *	reg	    - A pointer to the ADQ32 registers.6  *	qr_ptr	    - A pointer to the ADQ32 context region.  *  * implicit inputs:   *  * outputs:I  *  * implicit outputs:  *--  */    void    adq_isr(reg, qr_ptr) adq_registers	*reg;r adq_region_ptr	*qr_ptr;g {l adq_region	    *qr = *qr_ptr;S read_desc	    *rd; intrpt_status_reg   stat;* int		    qstat, estat;       /*3      * Types of interrupts and actions to be taken:t      *D      *	NoneXistent Memory	- shouldn't happen - return packet (error)-      *	Clock Overrun		- return packet (error)r+      *	End of Scan		- return packet (error)&9      *  Interrupt on ADC Trig	- disabled shouldn't happenr5      *	ADC data available	- disabled shouldn't happeni/      *	ADC FIFO overrun	- return packet (error)o      *#      * Fetch interrupt information.       */=  -     stat.w = read_register(&reg->int_stat.w);        /*-      * Determine the cause of this interrupt.5      *-      * DMA type interrrupts will not be here.g      *E      * - Check for EOS (end of scan interrupt) first.  This is caused_O      *   by reaching the end of the ADC Parameter list without ADC recycle set._J      *   This error will disable the ADC which will cause a clock overrun        *	 error almost immediatly.      *J      * - Check for a clock overrun error.  Caused by a pethora of reasons.O      *   mainly having to to with three primary causes: 1) the ADC was shutdownkI      *   2) One ADQ clock told another ADQ clock to do something while itr0      *	 was still busy,  3) some external event.      *K      * - Check for ADC Buffer overrun error.  This is caused when the ADC's F      *   output buffer fills past capacity.  Shouldn't happen with the      *   DMA engine running.      *H      * - Check for NXM (non existent memory).  The DMA tried to put data;      *   in a place that does not exist (or a bus timeout).0      */r       if (stat.bits.end_of_scan) 	estat = ADQ$ENTRY_EOS; %     else if (stat.bits.clock_overrun)d 	estat = ADQ$ENTRY_CLK_OVR;t&     else if (stat.bits.fifo_full_intr) 	estat = ADQ$ENTRY_FIFO_FULL;      else if (stat.bits.nxm)  	estat = ADQ$ENTRY_NXM;l	     else   	estat = ADQ$ENTRY_UNK;        /*F      * If status is current active and not in the process of aborting.      */&  7     if (qr->status.adq_active && (!qr->status.abort)) {m   	/* 6 	 * Try and remove an entry from the request queue and6 	 * fill out its error status, bad count put it on the% 	 * done queue and signal the device.* 	 */  ; 	while ((qstat = _REMQHI(&qr->req_queue, &rd)) == LOCKED) ;.  " 	if (!(qstat & LOCKED_OR_EMPTY)) { 	    rd->status  = estat;e  9 	    DMA_READ(DMA_WINDOW_CH0_B_CURR_CNT, rd->bad_count);    " 	    _INSQTI(rd, &qr->do                                                                                                                                                                                                                                                           eˀ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             1 "            ne_queue);# 	    ker$signal_device(NULL, NULL);- 	}     }2       /*@      * An ADQ error occured the turn off DMA, ADC and the Clock.      */c      .D      DMA_WRITE(DMA_WINDOW_CH0_COMMAND,   DMA_CH0_COMMAND_DISCO_DMA);<      write_register(ADC_CTRL_DISABLE_ADC, &reg->adq_ctrl.w);<      write_register(ADQ_CLK_CONF_DISABLE, &reg->clk_conf.w);  A      DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_CLEAR_IP); A      DMA_WRITE(DMA_WINDOW_CH1_COMMAND, DMA_CH1_COMMAND_CLEAR_IP);_?      write_register(ADQ_INTR_STAT_CLEAR_ALL, &reg->int_stat.w);sF      DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_NBL_DMA_INTR);   #      qr->status.adq_active = FALSE;, }    > /*++  *0  * adq_dma_isr - ADQ32 Interrupt service routine  *  * functional description:  *-  *	A DMA interrupt is recieved. Determine the7*  *	nature of the interrupt and process it.  *
  * inputs:  *.  *	reg	    - A pointer to the ADQ32 registers.6  *	qr_ptr	    - A pointer to the ADQ32 context region.  *  * implicit inputs:-  *  * outputs:   *  * implicit outputs:  *--  */m    void    adq_dma_isr(reg, qr_ptr) adq_registers	*reg;  adq_region_ptr	*qr_ptr;  {_ adq_region	    *qr = *qr_ptr;r read_desc	    *rd,*rd2;t unsigned short int  wtmp;i dma_i_intr_save	    dma_save;_ dma_i_status	    dma_stat; intrpt_status_reg   stat;k int		    qstat, estat;       /*7      * Types of DMA interrupts and actions to be taken.-6      *	DMA transfer complete	- Return packet (success)2      *	DMA match condition	- ignore should happen./      *  DMA End Of Process	- depends on eop bit01      *	NoneXistent Memory	- return packet (error);      *#      * Fetch interrupt information.>      */w  -     stat.w = read_register(&reg->int_stat.w);e5     DMA_READ(DMA_WINDOW_CH0_DMA_STATUS, dma_stat.w); 03     DMA_READ(DMA_WINDOW_CH0_INTR_SAVE, dma_save.w);e       /*-      * Determine the cause of this interrupt.t      *I      *  - Check for an EOP (End of Process).  The EOP bit gets set in twoeL      *	  cases 1) an EOP signal is recieved. 2) an NXM (non-Existent memory)      *    error occured.        *B      *	- Check for TD (Transfer Done), all is happy keep on going.      */r       if (dma_save.bits.eop) { 	if (stat.bits.nxm)  	    estat = ADQ$ENTRY_NXM;* 	else  	    estat = ADQ$ENTRY_EOP;n+     } else if (dma_save.bits.transfer_done)d 	estat = ADQ$ENTRY_TD;	     else d 	estat = ADQ$ENTRY_UNK;w       /*D      * If the device is being reinit'ed or an intrrupt occurs while 9      * not active then dismiss the interrupt and go away.       */e  7     if (qr->status.abort || !(qr->status.adq_active)) {r  > 	DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_DISCO_DMA);= 	DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_CLEAR_IP);e; 	write_register(ADQ_INTR_STAT_CLEAR_ALL, &reg->int_stat.w);  	return;     };       /*7      * In any case this is the end of the current read. N      * Remove the entry from the request queue, fill out the vital statistics.      */>  >     while ((qstat = _REMQHI(&qr->req_queue, &rd)) == LOCKED) ;       /* 48      * If an entry was found mark its completion status.      */   %     if (!(qstat & LOCKED_OR_EMPTY)) {; 	rd->status  = estat;-     } else { 	/*gD 	 * No entry was found to process, clear the interrupt and continue. 	 */  > 	 DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_CLEAR_IP);> 	 DMA_WRITE(DMA_WINDOW_CH1_COMMAND, DMA_CH1_COMMAND_CLEAR_IP);< 	 write_register(ADQ_INTR_STAT_CLEAR_ALL, &reg->int_stat.w);C 	 DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_NBL_DMA_INTR); l	 	 return;      }t       /*      * Handle the interrupt.      */_       switch (estat) {   	case ADQ$ENTRY_TD:_ 	    /*0% 	     * Oh, good a transfer complete.l= 	     * Put the completed entry on the done queue and signal.I 	     */ 	    C" 	    _INSQTI(rd, &qr->done_queue);# 	    ker$signal_device(NULL, NULL);    	    /*i, 	     * Is there another entry on the queue? 	     */   	    if (qr->req_queue.flink) {r   		/*& 		 * Set up to process the next entry.! 		 * Has it been double buffered?  		 */d 		 t9 		rd = (char *)&qr->req_queue + (int)qr->req_queue.flink;r 		 e 		/*9 		 * If the next entry hasn't been loaded yet then do so.  		 */   ' 		if (rd->status == ADQ$ENTRY_EQUEUE) {a: 		    DMA_WRITE(DMA_WINDOW_CH0_B_CURR_SEG, rd->buf_seg.w);9 		    DMA_WRITE(DMA_WINDOW_CH0_B_CURR_OFF, rd->buf_addr);7: 		    DMA_WRITE(DMA_WINDOW_CH0_B_CURR_CNT, rd->wrd_count);$ 		    rd->status = ADQ$ENTRY_ACTIVE;+ 		} else if (rd->status == ADQ$ENTRY_DBUF) p$ 		    rd->status = ADQ$ENTRY_ACTIVE;   		/*< 		 * Set the pointer to the next entry, if it isn't pointing> 		 * back to the queue header then load the entry as a double  		 * buffer  		 */l  ) 		rd2 = (char *)rd + (int)rd->link.flink;    		if (rd2 != &qr->req_queue) { 		    /*: 		     * Load the Channel 0 Base to current DMA registers.	 		     */r  ; 		    DMA_WRITE(DMA_WINDOW_CH0_B_BASE_SEG, rd2->buf_seg.w); : 		    DMA_WRITE(DMA_WINDOW_CH0_B_BASE_OFF, rd2->buf_addr);; 		    DMA_WRITE(DMA_WINDOW_CH0_B_BASE_CNT, rd2->wrd_count);*  # 		    rd2->status = ADQ$ENTRY_DBUF;e 	t 		    /*+ 		     * Turn on base to current reloading. 	 		     */_  / 		    if (qr->status.adq_double_buf == FALSE) {t  0 			wtmp = ADQ_DMA_CHANNEL_MODE_LO_CHAN_0_INIT | 3 			       ADQ_DMA_CHANNEL_MODE_LO_RELOAD_TRANS_ON |r 			       ( qr->status.eop l0 			       ? ADQ_DMA_CHANNEL_MODE_LO_EOP_ON : 0);  , 			DMA_WRITE(DMA_WINDOW_CH0_MODE_LOW, wtmp); 			Q% 			qr->status.adq_double_buf == TRUE;t 		    } 
 		} else { 		    /*; 		     * There isn't a second entry so don't double buffer.** 		     * Clear the base to current reload.	 		     */2  . 		    if (qr->status.adq_double_buf == TRUE) {  0 			wtmp = ADQ_DMA_CHANNEL_MODE_LO_CHAN_0_INIT | ; 			  (qr->status.eop ? ADQ_DMA_CHANNEL_MODE_LO_EOP_ON : 0);r  , 			DMA_WRITE(DMA_WINDOW_CH0_MODE_LOW, wtmp);  % 			qr->status.adq_double_buf = FALSE;t   			/*r: 			 * Check the SIP bit, if is set then the last entry has> 			 * already completed and is waiting for processing, the DMA: 			 * engine must be disconnect from the ADC to prevent a  			 * spurrious transfer. 2 			 * The DMA engine gets reconnected by adq_start4 			 * Otherwise if SIP is clear everything is dandy. 			 */  4 			DMA_READ(DMA_WINDOW_CH0_DMA_STATUS, dma_stat.w); + 			if (dma_stat.bits.second_intr_pending) {_) 			    DMA_WRITE(DMA_WINDOW_CH0_COMMAND,   				DMA_CH0_COMMAND_DISCO_DMA);l 			}     		    }    o 		}k
 	    } else {) 		/* e1 		 * That was the last entry.  Shut the ADQ down.t 		 *$ 		 * Turn off the clock and the ADC. 		 */   9 		write_register(ADQ_CLK_CONF_DISABLE, &reg->clk_conf.w);k9 		write_register(ADC_CTRL_DISABLE_ADC, &reg->adq_ctrl.w);_    		qr->status.adq_active = FALSE; 	    }   	    /*c& 	     * Prepare for the next interrupt) 	     * Clear the intrrupt pending flags.l' 	     * Enable DMA interrupts and exit.e= 	     * Clear the DMA event of the interrupt status register.> 	     */  A 	    DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_CLEAR_IP);LA 	    DMA_WRITE(DMA_WINDOW_CH1_COMMAND, DMA_CH1_COMMAND_CLEAR_IP);DC 	    write_register(ADQ_INTR_STAT_CLEAR_DMA_INT, &reg->int_stat.w);_   	    /*m 	     * Enable DMA intrrupts.  	     */  F 	    DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_NBL_DMA_INTR);  	    break;e   	case ADQ$ENTRY_EOP: 	    /*i= 	     * WARNING!!! The EOP off Case falls through to and uses.1 	     * default!!!  Don't move this CASE block!!!o 	     * ? 	     * Are we processing EOP's or are they an error condition?.? 	     * If we are processing them then store the bad count, puti1 	     * the entry on the done queue and continue. D 	     * otherwise EOP is an error condition fall through to default. 	     *_ 	     */ 	     if (qr->status.eop) {    		/*0 		 * Write the number of samples not transfered.0 		 * Put the entry on the done queue and signal. 		 */   6 		DMA_READ(DMA_WINDOW_CH0_B_CURR_CNT, rd->bad_count);  	    M 		_INSQTI(rd, &qr->done_queue);   		ker$signal_device(NULL, NULL);   		/*/ 		 * Are we in the process of double buffering?n6 		 * EOP entries are NOT BASE to CURRENT reload by the4 		 * hardware since we needed to know the bad count.< 		 * Therefor the next entry will need to be manually loaded; 		 * into the current registers and if an next entry exists / 		 * it will be loaded into the base registers.. 		 */   " 		if (qr->status.adq_double_buf) {   		    /*0 		     * Set a pointer to the now current entry.	 		     */  	     = 		    rd = (char *)&qr->req_queue + (int)qr->req_queue.flink;c 		    /*? 		     * Clear the entry's double buf flag set the active flag.r 		     *; 		     * Load this entry's address and cou                                                                                                                                                                                                                                                                           #͹= $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]ADQ32_BODY.C;1                                                                                      Z                             '             nt into the base   		     * registers. 	 		     */l 		 i$ 		    rd->status	= ADQ$ENTRY_ACTIVE;  : 		    DMA_WRITE(DMA_WINDOW_CH0_B_CURR_SEG, rd->buf_seg.w);9 		    DMA_WRITE(DMA_WINDOW_CH0_B_CURR_OFF, rd->buf_addr);A: 		    DMA_WRITE(DMA_WINDOW_CH0_B_CURR_CNT, rd->wrd_count); 	o 		    /*8 		     * Next, if the next entry is not the queue header. 		     * set set up for a double buffer entry.	 		     */r  - 		    rd2 = (char *)rd + (int)rd->link.flink;t  " 		    if (rd2 != &qr->req_queue) { 			/*p. 			 * Set up this entry in the Base registers. 			 * Set flags. 			 */  8 			DMA_WRITE(DMA_WINDOW_CH0_B_BASE_SEG, rd2->buf_seg.w);7 			DMA_WRITE(DMA_WINDOW_CH0_B_BASE_OFF, rd2->buf_addr); 8 			DMA_WRITE(DMA_WINDOW_CH0_B_BASE_CNT, rd2->wrd_count);    			rd2->status = ADQ$ENTRY_DBUF; 		    } else { 			/*Q9 			 * otherwise there isn't another entry in the queue.  e6 			 * That makes the entry that is currently executing 			 * the last entry.N 			 *  			 * Cease double buffering.K9 			 * Clear the base to current reload bit in the channel  			 * mode low register. 			 */ 			 % 			qr->status.adq_double_buf = FALSE;a  0 			wtmp = ADQ_DMA_CHANNEL_MODE_LO_CHAN_0_INIT | ) 			       ADQ_DMA_CHANNEL_MODE_LO_EOP_ON;s  , 			DMA_WRITE(DMA_WINDOW_CH0_MODE_LOW, wtmp); 		 			/* 2 			 * No need to worry about a SIP condition since4 			 * base to current reload on EOP was not enabled. 			 */ 		     }
 		} else { 		    /*/ 		     * The double buffering flag is not set, N2 		     * The last entry is away on the done queue. 		     * put the adq to sleep. 		     */ 		     * Turn off The ADC, clear the leftovers.u	 		     */n  = 		    write_register(ADC_CTRL_DISABLE_ADC, &reg->adq_ctrl.w);A< 		    write_register(ADC_CTRL_FLUSH_FIFO, &reg->adq_ctrl.w);  $ 		    qr->status.adq_active = FALSE; 		}l   		/*# 		 * Prepare for the next interruptE& 		 * Clear the intrrupt pending flags.$ 		 * Enable DMA interrupts and exit.: 		 * Clear the DMA event of the interrupt status register. 		 */D  > 		DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_CLEAR_IP);> 		DMA_WRITE(DMA_WINDOW_CH1_COMMAND, DMA_CH1_COMMAND_CLEAR_IP);@ 		write_register(ADQ_INTR_STAT_CLEAR_DMA_INT, &reg->int_stat.w);   		/* 		 * Enable DMA intrrupts. 		 */r  C 		DMA_WRITE(DMA_WINDOW_CH0_COMMAND, DMA_CH0_COMMAND_NBL_DMA_INTR); r 		break; 	     }e 	    /* = 	     * Not doing EOP, Could be falling through to default!!!  	     */  	 	default:t 	    /* B 	     * An error of some type occured.  (NXM's will turn up here.)G 	     * Put an end to activites.  Write the number of words that failed:F 	     * to be transfered into the packed and put it on the done queue.7 	     * The user can clean up the others with a reinit.r 	     *dB 	     * Disconnect the DMA engine, turn off the Clock and the ADC.! 	     * Consider things inactive.a 	     */  9 	    DMA_READ(DMA_WINDOW_CH0_B_CURR_CNT, rd->bad_count); *D 	    DMA_WRITE(DMA_WINDOW_CH0_COMMAND,   DMA_CH0_COMMAND_DISCO_DMA);< 	    write_register(ADQ_CLK_CONF_DISABLE, &reg->clk_conf.w);< 	    write_register(ADC_CTRL_DISABLE_ADC, &reg->adq_ctrl.w);  " 	    _INSQTI(rd, &qr->done_queue);# 	    ker$signal_device(NULL, NULL);   # 	    qr->status.adq_active = FALSE;  	    break; 	     }    a }e                                                                                                                                                                                                                                                                                                                                                              . * [SYSEXE.SEAS$WORK_0000005C]ADQ32_UTILITY.EXE;1 +  , 
   .     /     4                            - 
    0   1    2   3      K  P   W   O     5   6 
  7 -G  8          9          G    H  J                  0 D X     0205      (          &                                       
ADQ32_UTILITY                          VAXELN V4.2-00 @Wۺ
 05-05                                                            
           !         LANGMSC_001"      !        
PASCALMSC_001"      !         
LIBCOMMON_001   1    1%   < 1=    1
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     ^  6$  3$  ЬPЏS`1fЬP`߭~ #  Э <n~߽ x <n~ݽ#   ЭP &"A   
P  ЭP` ЭP &"*   
P  ЭP`ЭP  ЭP    ЭP X  нSԣc|| RQ(RP@P]`aRЭPԠ*ЭP  .ЭP  2ЭP{  6ЭP  :ЭP/
  >ЭP{
  BЭP  FЭP  JЭP  NЭPO  RЭP  VЭPk  ZЭP  ^ЭP  bЭP  fЭP  jЭPw  nЭP  rЭP  vЭPw  zЭP  ~ЭP   ЭPՠ& ߭ݠ    P찭,.PP /ݭм<@~ݬ<ݬ8<4~ݬ0<,~ݬ(ݬ$ ~~ݬݬݭݬP| ^ЬScUУ"VX ݣ|~  Rb4ЬRݢ  ݢ @  ޭRQ^eb	QQQQTˏTSЭP
ЭP R]bST4 JJTTTRRKJЬTˏ RxRX$\ˏ(RxR^,bЬ0dˏ4RxRh8lRbRbR bR.b>fR bR,b>fRbRbR8b>fRbS>RbR	SPPPR PR$b>fR.bR b>fR,bR,b>fR bTެRTbPPЬQa`TQTb444RbЬSX ݣ    ^ЬQP`P`P`P`P`P`P_` ^мT    ЬRЏSbѬ
Ѭ   ݏ|S 8 ޭPQ^`	QQQQSS"PޭRQ^b	QQQQSSSݏ$S 8 ЭRЭRЬSSЭRЬЭR ЬPՠ& ߭~SݠY  PS  PЭRЭSRR 
ЭRdR]bP< ^ЬRbTТ"U    ЬPЏS`X ݢ|~  ЬRbP 4#X ݢ  ݏ,S 8 d'ЬQX ݡ  ݏ4S 8 P `P`P	`P`P`dPdPS@ R>P`P	R4RPRRR(cSQdPQP8QS "$44	RPRRR(&P&`>eP.`P"`>eP,`P.`>eP `P.`>eP `P.`>eP2`P`ЬSݣ"4cPPݣ"TP@*RbX ݣ   ^мT    ЬRЏSbޭPQ^`	QQQQSS!PޭRQ^b	QQQQSSS[ЬRݢݢݢݬ ݬ ޭPQ^`	QQQQSS ޭRQ^b	QQQQSSSvЬSЭRТcЬSЭR<
cЬSЭR<cЭRТԭЭQ
RR ЬPՠ&ݭ<RRR~ݡݠ  R]bЬRbЬRbЬR< b  ^ЬTФ"PP`PPSRPR |~2R~T!S	RP?R  2R~TS? 2RRT RT RTϻP|~|~|~  T߭߭<~T Ϟ xPƏ  P  2PRRT`  RTM  RT:  ^2P2QQPP2PQPP2PPPP2PPPPQQQPP< 0^  TЬScRU
ޤ䟭%  }ح
߭~   K ݬݭS S ߭ ߭ S ѭݏS 8 ЭP	P
RެSRcЭQ2aPPURQRcU ]   ^ެVfRТ"U |~|~|~  R ϮSެTQSPPQQP`߭<~f ϥxPƏ  PPRd	2RPdPPRЬPP ) A Mf?PR>QSPPQQ.PR&QSPPQQPRQSPPQQSPxPPPS1PRSQQWQQP`߭<~ݬ xPƏ  P2P~2S~2~σPWP`P ^ЬQP@`ЬP<JPPRPR`P`P ^ЬQP`P!`P`P`P%`P`PT`P`ЬP<JPPRPR`P4` ^ЬQP`ЬRɏ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            iE $      ELN042.B                       
  
  .[SYSEXE.SEAS$WORK_0000005C]ADQ32_UTILITY.EXE;1                                                                                                               6;      
       hPPSPS`Pl`P`P`PT`<JPPPSPS`P4`P ^ЬQP`P`P`P`P`PT`ЬP<JPP PRPR`P4`P ^ЬRP`ЬQɏ!  XPPSPS`P\`PH`<JPPSPS`P(`P ^ЬQP`P `P`P`ЬRɏ0  XPPSPS`P\`P`P`P `P\`PC`P`<JPPSPS`P<` ^ЬQP`ЬRɏ  hPPSPS`Pl`P`ɏP  XPPSPS`P\`P`P`P\`<JPPPSPS`P<` ^ЬRP`ЬQɏp  XPPSPS`P\`PH`<JPPSPS`P(`P ^ЬQP`P!`P`P`ЬRɏP  XPPSPS`P\`P`P`P\`<JPP PSPS`P<` ^ЬQP`ЬRɏ!  ^PPSPS`Pb`P`P%`ddPPSPS`PT`P`<JPPSPS`P4` ^ЬQP`P `P`P`ЬRɏ0  ^PPSPS`Pb`P`P%`ddPPSPS`PV`PB`P`P`<JPPSPS`P6`P ^ЬQP`ЬRɏ  ^PPSPS`Pb`P`P%`ddPPSPS`PT`P`<JPPSPS`P4` ^ЬQP`P `P`P`P `P`P`ЬRɏ!0  ^PPSPS`Pb`P`P%`ddPPSPS`PW`P`P`P`<JPP PSPS`P7`P ^ЬQP`P!`P`P`P%`ЬRddPPSPS`PT`P`<JPPSPS`P4`P ^ЬQP`ЬRɏ!  ^PPSPS`Pb`P`ɏP  XPPSPS`P\`P`P%`ddPPSPS`P\`P`<JPPSPS`P<`P ^ЬQP`P `P`P`ЬRɏ0  ^PPSPS`Pb`P`ɏP  XPPSPS`P\`P`P%`ddPPSPS`P^`PB`P`P`<JPPSPS`P>` ^ЬQP`ЬRɏ  ^PPSPS`Pb`P`ɏP  XPPSPS`P\`P`P%`ddPPSPS`P\`P`<JPPSPS`P<`P ^ЬQP`P `P`P`P `P`P`ЬRɏ!0  ^PPSPS`Pb`P`ɏP  XPPSPS`P\`P`P%`ddPPSPS`P_`P`P`P`<JPP PSPS`P?` ^ЬQP`ЬRɏP  XPPSPS`P\`P`P%`ddPPSPS`PX`P`<JPP PSPS`P8` ^ЬQP`P `P`P`PT`ЬP<JPȏ   P PRPR`P4`P ^ЬQP`P `P`P`PT`ЬP<JPȏ   Pȏ@   PPPPRPR`P4` ^ЬQP`ЬRɏ  hPPSPS`Pl`P`P`PT`<JPȏ@   PPPPSPS`P4`< ^мTЬRRbPPU)PUP< UUP U 4z4tޭPQ^d`	QQQQSS!PޭRQ^db	QQQQSSS2ЭRUЬPR2bЭS>`RbPP
R]b|~ ЬPR.b>`R bR	bR bR.b>`R$bR,b>`R%bRbR.b>`R2b4| ^мUЬQRbPPR.b>aScPPR*bcPPTPTPTP T4 4(ЬPR.b>`R bR.b>`R$bRbޭPQ^e`	QQQQSS!PޭRQ^eb	QQQQSSSЭRT4ЬPR.b>`R$bR,b>`R%bRbR.b>`R2bTPP. 1P?PR]b|~ e10eReRЭS<TT   7ЬPRb>`RbRb>`RbR2b>`Rb@PT   @ЭRbRSeRSRfЬPRb>`RbRb>`RbR6b>`Rb41 4SPSRSVRR b>`RVbvP4RRg4QQRQVЬSRR b>cRVb4R.b>cTdPP%R.b dЬRP `R	b4ЬPR.b>`R$bR,b>`R%bRbR.b>`R2bP41ЬTR2bЭS>dRbPP
R]b|~ 41 eReRЭR@Rb>dRЭPbRb>dRbR2b>dRb`PeRPR2Rb>dRbRb>dRbR6b>dRb04VRR b>dRVbR	bRb4ЬPR.b>`R$bR,b>`R%bRbR.b>`R2bPЬQR2bЭS>aRbPP
R.b>aR bR bR	bR]b|~ 4                                                                                                                                                                                                                                                                                                                                                                                                                                                            0 00:01:00.00                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  < ЬQ	QSQ	П PA^nPQߠ`h ЎQՎЎPQРP<2
 RxRR    RB8PРXPˏ  C`Px	PPQ 	P< ЬS 	RBSxSS~R~T~UeݬS~db   x	dP 	PPbR< ЬRЬS 	P@SxSSެUЬQ a1 	QTQePJП P ~Q~P}P~h ՎЎPРP<2
 QxQQ    QA8PРXPD`PTȏ   T ȏ   T``ЀQQ TTSbݬ  8  ݬx~ЬP 	QAPxP~                                                                                                    @  @       l   x                                               @   8   P   H                    &   
                 @                                                                       LANGMSC                                                        	PASCALMSC                                                      	LIBCOMMON                                                                                                                                                                      D     
ADQ32_UTILITYVAXELN V4.2-0010-OCT-1990 23:1110-OCT-1990 23:11  VAX-11 Linker V05-05        	.$$ABS$$. w         ELN$ADQ_INITIALIZE       ELN$ADQ_QUEUE_READ      < 
ELN$ADQ_START       ELN$ADQ_TRANSFER_DONE                                                                                                                                                                                                                                                                                               + * [SYSEXE.SEAS$WORK_0000005C]ADV11DBODY.PAS;1 +  , 
   . '    /     4 ]   '   %                    - 
    0   1    2   3      K  P   W   O &    5   6 o.  7 G  8          9          G    H  J                    . module eln$adv_dma_utility [ident('v3.0-00')];  M {****************************************************************************  {*									    *- {*  Copyright (c) 1984, 1990      						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  {  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { 8 {	ADV11D device interface module.  This module provides 8 {	an interface to the ADV11D A/D converter. DMA transfer* {	is provided as well as programmed input. { 	 { Author:  {  {	Amy Kessler  April 1987  {  { Modified:  {-} E include	$adv_dma_utility,$mutex,$unibu                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          V $      ELN042.B                       
  
  +[SYSEXE.SEAS$WORK_0000005C]ADV11DBODY.PAS;1                                                                                    ]     '                         0 "            s,$physical_address,$kernelmsg;  	   " procedure_body eln$adv_initialize;   {++   {	Initialize the ADV11-D device. { 	 { Inputs:  { 
 { device name  { clock_start_enable	 { re-init  { max_channel_num  { 
 { Outputs: { 0 { context_identifier - pointer to context region= { stat - completion code returned from call to create device.  {  {--}   var  	qbus_adapter :	^anytype;  	idesc : integer;  	temp_desc: ^queue_entry;  	empty: boolean; 	first_element: boolean; 	channel: integer;   begin  	 , 	stat := KER$_SUCCESS; { assume successfull} 	if not re_init then	 	   begin 9 		new(context_identifier); { allocate new context record}  		with context_identifier^ do  		    begin ) 			{create mutex for q-element free list}  			create_mutex (descs_lock); * 			{ create mutex for hardware registers } 			create_mutex ( hrdwre_lock); , 			create_device(device_name,adv_dma_device, 					vector_number :=1, $ 					service_routine := adv_dma_isr, 					region :=adv_dma_region,  					registers := adv_dma, 					priority := priority,' 					adapter_registers := qbus_adapter,  					status := stat);    			if stat=KER$_SUCCESS then  2 			    create_device(device_name,adv_error_device, 					vector_number := 2,% 					service_routine :=adv_error_isr,   					region := adv_error_region, 					registers := adv_dma, 					priority := priority,& 					adapter_registers :=qbus_adapter, 					status := stat);    			if stat= KER$_SUCCESS then  			    begin 				with adv_dma_region^ do  				   begin 					{ start queues }   					start_queue(request_queue); 					start_queue(done_queue);   + 					{are there  Q-bus adapter registers ?} & 					bus_adapter := qbus_adapter<>nil;   					{ initialize q-elements } 					  					for idesc:= 1 to siz do 					 begin ! 					 	descs[idesc].free := true; # 					 	descs[idesc].index := idesc; 
 					 end;! 				  end; { with adv_dma_region} # 			   end; { if stat=KER$_SUCCESS } $ 			end;  { with context_identifier } 		  end; { if not re_init }  						< 	if stat=KER$_SUCCESS then	{initialize board-wide parameter} 	   begin			{in memory			} 		with context_identifier^ do 
 		   begin 			with adv_dma_region^ do 			   begin = 				don_clock_enable:= clock_start_enable; {external trigger} J 				don_last_channel:= max_channel_num;    {single or differential inputs}H 				don_finished := true;	{ all channels on a progrd read are complete } 				if re_init then & 				   begin	{cancel further requests} 					abort_request:= true;1 					wait_any(time:=time_value('0 00:00:03.00'));  				' 				{remove entries from request queue} ! 				{put them on the done queue	}  				 					repeat ? 					   remove_entry(request_queue,temp_desc,empty,queue$head); ' 					   if not ( temp_desc = nil ) then  					      begin/ 						temp_desc::^buffer_desc^.aborted := true; < 						insert_entry(done_queue,temp_desc::^buffer_desc^.link," 								first_element,queue$tail); 					      end;  					until (temp_desc = nil );6 					abort_request:=false;	{re-enable future requests}   				   end; { if re_init }6 			re_init:=true;	{ device initialized at least once }  ( 				{ initialize the ADV11 D  hardware }    			write_register(adv_dma^.csr); 			 % 			write_register(adv_dma^.ext_dbr);   	 D 				{ initialize csr template in memory. Defaults can be overridden}9 				{ with Read parameters unless stated otherwise		    }   I 			don_csr_template:=read_register(adv_dma^.csr);  { read a copy of csr }  				with don_csr_template do 				  begin 6 					go := not don_clock_enable;  { software trigger } 					dma_enable := true;	 0 					dma_done := false;	{may start another DMA }0 					multi_conv := true;	{multiple conversions }4 					auto_incr := false;	{auto increment channel # }% 					clock_start := don_clock_enable; D 					interr_enable := true;	{ always use interrupts - not overriden}M 					error_interr := true;	{ always use interrupts on error - not overridden}  				   end;	{with csr_template}  					   ( 				{ initialize the error region flag }) 			adv_error_region^.error_flag := false;   			end;	{ with adv_dma_region^ }( 		   end;   { with context_identifier^ }  		end;	{ if stat= KER$_SUCCESS }  . 	end;	{ procedure eln$adv_initialize}			            " procedure_body	eln$adv_queue_read; {++  {  { functional description:  { 0 { 	This routine finds an available queue element+ { 	and fills in appropriate information and ' {	queues it to the read request queue.  0 {	If this is the first element on the queue, the {	read is started. { 	 { inputs:  { ; {	context_identifier ( will be c_i for debugging purposes )  {	transfer_type  {	start_chan {	auto_increment_enable  {	multi_conversion {	dest_buffer		  {	wrd_count 	 {	user_id  {	gain_array { 
 { outputs: { 1 {	queued 	1 means request was queued successfully ? {		0 means request not queued because no free element was found  {  {--} var 
 	index: word;  	physical: physical_addr;  	first_element: boolean; 	icount : integer; begin     with c_i^ do & 	{ if wrd_count is out of range    or}& 	{ abort had been requested        or}2 	{ for DMA if,multi-conversion is'nt chosen and  } 	{ the clock isn't enabled 			} $ 	{ then don't queue this request . }       begin < 	if ( wrd_count < 1) or (wrd_count > 32767 ) or				{abort ?}) 		(c_i^.adv_dma_region^.abort_request) or G 		( (transfer_type) and (not c_i^.adv_dma_region^.don_clock_enable) and   			(not multi_conversion) ) then 		queued := false  	else 0 	   begin						{lock free list ,find an element} 		lock_mutex( descs_lock);+ 		index := adv11d_allocate_descriptor(c_i);  		unlock_mutex( descs_lock ); A 		if index <> 0 then				{found a free queue element, fill it in } 
 		   begin 			with adv_dma_region^ do 			   begin / 				descs[index].auto := auto_increment_enable; + 				descs[index].multi := multi_conversion; , 				descs[index].xfer_type := transfer_type; 				if transfer_type then : 					descs[index].dest_ptr := dest_buffer {virtual addrss} 				else- 					descs[index].receive_ptr := dest_buffer; $ 				descs[index].user_id := user_id;( 				descs[index].wrd_count := wrd_count;+ 				descs[index].channel_num := start_chan;   				descs[index].index := index;  				if present (gain_array) then1 					descs[index].cgain := gain_array[start_chan]  				else& 					descs[index].cgain := adv$gain_1;. 				if transfer_type then	{ for DMA transfer } 				  begin  					if bus_adapter then# 				   		unibus_map(adv_dma_device,  				   		buffer:=dest_buffer^, 						buffer_size:=wrd_count*2, $ 						unibus_address:=physical.full)	 					else 5 						physical.full := physical_address(dest_buffer); 6 						descs[index].dest_physical.full:= physical.full; 				  end { if transfer_type }	 				 else 
 				    begin D 				  	descs[index].dest_physical.full:= 0; { for programmed input } 					for icount := 0 to 15 do / 						descs[index].receive_buffer[icount] := 0; $ 				   end; { if not transfer_type }  2 	   		{insert queue element in Read request queue}  " 	   			insert_entry(request_queue, 					descs[index].link,  					first_element,  					queue$tail);				   6 				if ((first_element) and (not abort_request)) then	: 								{ first element on the queue and no abort request}, 		   		  begin						{ start the first read }  6 				{ set up csr for ,override defaults if requested }   					with adv_dma_region^ do
 					   begin I 						don_csr_array[start_chan] := don_csr_template; {get default values} * 			   			with don_csr_array[start_chan] do 						   begin					{override} # 							dma_enable := transfer_type; * 							auto_incr := auto_increment_enable;& 							multi_conv := multi_conversion;! 							channel_sel := start_chan;  							if present (gain_array), 								then gain := gain_array[start_chan]; 						end; {with don_csr_array}  					end; {with adv_dma_region}    					lock_mutex(hrdwre_lock); 0 					if transfer_type then		{ for DMA transfer } 			   		  begin > 						write_register(adv_dma^.wcr,transfer_count:=-wrd_count);( 											 { complement of word count} P 						write_register(adv_dma^.car,bus_address:=physical.low); {physical address}G 						write_register(adv_dma^.ext_dbr,extended_address:=physical.high);  			   		   end; < 					write_register(adv_dma^.csr,don_csr_array[start_chan]);, 									{ for both DMA & programmed input } 					unlock_mutex(hrdwre_lock); ! 		   		  end; { if first element}  			end; {with adv_dma_region} ' 			if adv_error_region^.error_flag then  			   begin * 				adv_error_region^.error_flag := false; 				queued := false 	 			   end  			else  				queued:= true; 		end { if index <> 0} 	   else 		queued := false; 	end; {wrd_count in range}#    end; { with context_identifier }   end; {proced                                                                                                                                                                                                                                                                           ќ $      ELN042.B                       
  
  +[SYSEXE.SEAS$WORK_0000005C]ADV11DBODY.PAS;1                                                                                    ]     '                          "            ure adv_queue_read }     y  9 function	adv11d_allocate_descriptor(c_i:adv_dma$) : word;* {++* {*; { find a free queue element, fill it in, and link it to theh { read request queue.	 {	 { input: {y {	context_identifier {a	 { output:r {M9 {	adv11d_allocate_descriptor  0 means no descriptor foundi# {			     1 to siz , indicates whicha# {			      descriptor was allocated.n {--} varh
 	index: word;u   begins 	with c_i^.adv_dma_region^ doo	 	   begino
 		index := 0;t 		repeat 		   index := index+1r 		until 3 		   ((index> siz) or ( descs[index].free = true));  		if index > siz then* 		   index := 0N 		else! 		   descs[index].free := false;	 ) 		   adv11d_allocate_descriptor := index;*# 	   end; { with context_identifier}t end; {of function }i   j% procedure_body	eln$adv_transfer_done;  {+ { functional description:  {	9 { 	This routine removes an entry from the done_queue . If	: {	a non_empty descriptor is not found in the time limit, a7 {	timeout condition is returned to the user.  Status ist {	returned to the user.s {t { input: {	 {	context_identifierD {	time_out_sec: integer # of seconds to wait for a read to complete. {*	 { output:* { 	 {	user_id : {	dest_buffer: virtual address of area where data is found {	bad_countD {	done_statn {-}c varu 	empty :	boolean;o 	removed_desc :	^queue_entry;D+ 	timer : integer; { to count down seconds }e# 	one_second_timer : integer := 50 ;  	desc_index : integer;
 	i : integer;    begino 	if time_out_sec < 0 thenv 	   time_out_sec := 0; 	timer := time_out_sec;r
 	with c_i^ do 	 	   begino 		with adv_dma_region^ do+
 		   begin, 			done_stat := success; 	{ be an optimist }: 			remove_entry(done_queue,removed_desc,empty,queue$head); 			u: 			{ wait if there's no problem and a time was specified } 			 N 			while ( (timer>0 ) and ( removed_desc = nil ) and ( not abort_request) ) do 			   beginu
 				repeat? 				wait_any(adv_dma_device,time:=time_value('0 00:00:00.02'));y; 				remove_entry(done_queue,removed_desc,empty,queue$head);e- 				one_second_timer := one_second_timer - 1;sM 				until (removed_desc <> nil) or (one_second_timer = 0) or (abort_request);   6 				one_second_timer := 50; 	{ reset the 1 sec timer }0 				timer := timer-1;		{count down the seconds }6 				if ( (timer <= 0) and ( removed_desc = nil )) then) 					done_stat := timeout	{ return code }r 				else 				   begin 					if  ( abort_request) then 						done_stat := aborted; . 					if  ( adv_error_region^.error_flag ) then
 					   begini- 						adv_error_region^.error_flag := false;	  						done_stat := unknown;g 					   ends 				   end; { else timer } 			   end; { while timer > 0 } 				{ get results }t 			if  removed_desc <> nil thenv 			   beginc' 				with removed_desc::^buffer_desc^ doa 				   begin< 					desc_index := index;		{ index of allocated descriptor } 				   end;t' 				if descs[desc_index].xfer_type thenq 				   begin 					if bus_adapter then# 						unibus_unmap (adv_dma_device, + 							buffer:=descs[desc_index].dest_ptr^,b2 							buffer_size:=descs[desc_index].wrd_count*2,= 							unibus_address:=descs[desc_index].dest_physical.full);Q/ 					dest_buffer := descs[desc_index].dest_ptr;b) 				   end { if xfer_type, ie . if DMA }	m 				else< 				   begin		{ move programmed input to P0 space for user } 					for i := 0 to 15 do, 							descs[desc_index].receive_ptr^[i] := - 									descs[desc_index].receive_buffer[i];;2 					dest_buffer := descs[desc_index].receive_ptr;" 				   end; { else not xfer_type }   				{ get return info }R( 				user_id:= descs[desc_index].user_id;, 				bad_count:= descs[desc_index].bad_count;   				{ free queue element }# 				descs[desc_index].free := true;  			   end { if desc <> nil }   			elset 			   begine 				dest_buffer := nil;a 				bad_count := 0;n] 				if ( (done_stat <> timeout) and ( done_stat <> aborted) and (done_stat <> unknown) ) thend 					done_stat := no_request;_ 			   end; { else desc = nil }! 		   end; { with adv_dma_region }e$ 	   end; { with context_identifier }  end; { procedure transfer_done }   m 		    ; interrupt_service adv_dma_isr( adv_dma: ^adv_dma$registers; % 				adv_dma_region: ^adv_dma$region);y   vart 	done_desc : ^queue_entry; 	empty : boolean;f 	first_element : boolean;e 	xtype : boolean;n 	cnum : integer; 	autoflag :boolean;d 	multi_local : boolean;e 	gain_local : adv$gain;:$ 	don_dbr : adv_dma$ext_dbr_register;  	wcr_reg : adv_dma$wcr_register; 	w_count: word;e 	dma_addr: physical_addr;t 	empty_queue: integer:=0;  	request_status: boolean;e 	  begin_ 	with adv_dma_region^ do	 	   begini    J 		if don_finished then  { all channels of a programmed read are finished }
 		   begin# 			don_qptr := request_queue.flink;(G 			if don_qptr = address(request_queue) then    { request queue empty }t 			   beginr! 				empty_queue := empty_queue+1;u 				goto finishedi
 			   end;: 			remove_entry(request_queue,done_desc,empty,queue$head); 			don_queue_empty := emptyn 		   end 		else 			done_desc :=don_qptr;" 		with done_desc::^buffer_desc^ do
 		   begin 			xtype := xfer_type; 			autoflag := auto; 			cnum := channel_num;}* 			wcr_reg := read_register(adv_dma^.wcr);K 			bad_count := wcr_reg.transfer_count; { number of words not transferred }t, 			saved_csr := read_register(adv_dma^.csr);$ 			request_state := saved_csr.error;! 			request_status:=request_state;; 		   end; { with done_desc } 			if xtype then				{ for DMA }dS 				insert_entry(done_queue,done_desc::^buffer_desc^.link,first_element,queue$tail)r  # 			else					{ for programmed input}d 			   begindP 				don_dbr := read_register(adv_dma^.ext_dbr);  {read data and clear a/d done }$ 				with done_desc::^buffer_desc^ do 				   begin4 					receive_buffer[don_sample] := don_dbr.data_word 				   end; { with done_desc }  + 				{ finished ? or more channels to read }eU 				if (not autoflag) or ((autoflag) and (don_sample + cnum  =don_last_channel)) thenu 				   begin; 					insert_entry(done_queue,done_desc::^buffer_desc^.link,.! 							first_element,queue$tail);n 					don_sample := 0;r 					don_finished := true; 				   end { if not autoflag } 				elseD 				   if autoflag and ( don_sample + cnum<don_last_channel) then			, 					begin				{ start another progrmd read }: 						don_finished := false;	{ not finished all channels }# 						don_sample := don_sample + 1;n7 						write_register(adv_dma^.csr,don_csr_array[cnum]);p 						goto finished;	 					end;o  			   end; { else , if not DMA }  1 		{ is there another read for us to start ? }				 W 		if (( not don_queue_empty ) and ( not abort_request ) and ( not request_status)) then 
 		   begin- 			with request_queue.flink::^buffer_desc^ dou4 			   begin			{ get information about this request } 				xtype := xfer_type;o 				autoflag := auto;. 				cnum := channel_num; 				multi_local := multi;e 				gain_local := cgain;, 				don_csr_array[cnum] := don_csr_template;   				with don_csr_array[cnum] do  				   begin9 					dma_done := false;	{ in order to begin another DMA }  					dma_enable := xtype;v 					channel_sel := cnum;) 					auto_incr := auto;_ 					multi_conv := multi_local;	 					gain := gain_local; 				   end; { w ith csr_array }w# 				if xtype then			{ start a DMA }  				   begin> 					write_register(adv_dma^.wcr,transfer_count:= -wrd_count);A 					write_register(adv_dma^.car,bus_address:=dest_physical.low);	K 					write_register(adv_dma^.ext_dbr,extended_address:=dest_physical.high);d 				   end; { if xtype }Q 				write_register(adv_dma^.csr,don_csr_array[cnum]);	{ start DMA or prog input }c 			end; { with request_queue } 		end; { if not empty }l     	end; { with adv_dma_region }e signal_device;	 finished:p end;     a      = interrupt_service adv_error_isr( adv_dma: ^adv_dma$registers;l- 				adv_error_region: ^adv_dma$error_region);	   {++s6 {  Interrupt notification of errors is always enabled.7 { This routine is called when any of four errors occur. 6 { Three of them involve an external clock and can only: { occur if an external trigger s enabled.  The other is a 6 { memory timeout which occurs if a DMA is requested to' { a memory location that doesn't exist.h { The three other errors are:a {e: {	o   Overtrigger.. a new trigger occurred before the last {	    conversion completed.r= {	o   Programmed input overrun..a new trigger occurred beforen, {	    the previous converted value was read.: {	o   DMA data overrun.. a new trigger occurred before the9 {	    the DMA logic could transfer all the previous data.  {--}   beginx; 	adv_error_region^.error_flag := true;	{ set the flag for }	 						{ others to read } end; end. {end of module}                                                                                                                                                                                                                                                                                             & $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]ADV11DUTIL.PAS;1                                                                                    M                              ,              + * [SYSEXE.SEAS$WORK_0000005C]ADV11DUTIL.PAS;1 +  ,    .     /     4 M       <                   - 
    0   1    2   3      K  P   W   O     5   6 @4Jo.  7 H  8          9          G    H  J                     + module $adv_dma_utility [ident('v3.0-00')];  include $mutex; M {****************************************************************************  {*									    *- {*  Copyright (c) 1984, 1990      						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  {  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { 8 {	ADV11D device interface module.  This module provides 8 {	an interface to the ADV11D A/D converter. DMA transfer* {	is provided as well as programmed input. { 	 { Author:  {  {	Amy Kessler  April 1987  {  { Modified:  {-}        Const * 	siz=32;			{ # of queue elements allowed	}   Type  " bits$2 = 0..3;			{for CSR gain			}0 bits$4 = 0..15;			{for CSM channel select bits	}0 bits$6 = 0..63;			{for DMA extended addressing	}2 bits$10 = 0..1023;		{for DMA extended addressing	} 	 1 word_count = -32767..0;	{allowable wrd count for} 4 code = (success,no_request,timeout,aborted,unknown); 					{completion codes	} word = [word]0..65535;7 physical_addr = [long]packed record	{for addr mapping	} * 	case boolean of			{test bus_adapter flag} 	true: (full:integer); 	false: (low:word; 		high:bits$6) 	end;    adv$ = ^anytype;  adv$data= [word]-%o3777..%o7777;5 adv$data_array= packed array[0..15]of [word]adv$data;  ADV$DATA_PTR = ^ADV$DATA_ARRAY; 9 adv$gain = (adv$gain_1,adv$gain_2,adv$gain_3,adv$gain_4);  adv$gain_array =' 	packed array[0..15] of [byte]adv$gain;        		{Control/Status Register}   ) adv_dma$csr_register=[word] packed record + 	go :		[pos(0)] boolean;	{start conversion}   * 	dma_enable:	[pos(1)] boolean;	{DMA xfer	}0 	multi_conv:	[pos(2)] boolean;	{DMA multi-word	} 						{conversion enable} 1 	auto_incr:	[pos(3)] boolean;	{auto-increment of}  						{channel # enabled} 4 	clock_start:	[pos(4)] boolean;	{enable ext trigger}2 	dma_done:	[pos(5)] boolean;	{indicates xfer com-} 						{plete. The user must} 						{clear to continue }< 	interr_enable:	[pos(6)] boolean;	{always set for interrupt} 						{enable		}2 	ad_done:	[pos(7)] boolean;	{indicates conversion} 						{complete.Cleared when}  						{DBR is read	}3 	channel_sel:	[pos(8)]bits$4;		{start channel for }  						{conversion	} / 	gain:		[pos(12)]adv$gain;	{preamplifier gain,}  						{values,1,2,4,8	} : 	error_interr:	[pos(14)] boolean;	{always set to generate} 						{interrupts on error}  	error:		[pos(15)] boolean;	{} 	end;      		{ Current Address Register }  * 	adv_dma$car_register=[word] packed record 		bus_address: word; 		end;  3 		{ Extended Address Register - write only for DMA} 3 		{ Data Buffer Register- read only for programmed} 
 		{					A/D	}  		{ Test xfer_type				}   1 	adv_dma$ext_dbr_register = [word] packed record   		case boolean of ! 		true:(extended_address: bits$6;  			unused	:bits$10); 		false:(data_word: word)  		end;   		{ Word Count Register } , 	adv_dma$wcr_register = [word] packed record 		transfer_count:word_count; 		end;       		{ADV11 D Device Registers }    	adv_dma$registers = record  		csr	: adv_dma$csr_register; % 		ext_dbr	: adv_dma$ext_dbr_register;  		wcr	: adv_dma$wcr_register;  		car	: adv_dma$car_register;  		end;   		{ Buffer Descriptor }  		{ For use with Queue-Reads}    	buffer_desc = record ( 		link	: queue_entry;	{ queue element 	}, 		data	: ^anytype;	{pointer to xferred data} 		wrd_count:word_count;  					{requested # words	} ' 		xfer_type: boolean;	{flag for use of}  					{ext addr register} 		channel_num: integer;  					{[start]channel # 	}  		auto: boolean; 					{auto increment flag	}  		multi: boolean;   					{dma multi-word conversion} 		cgain: adv$gain; 					{gain for channel_num	}  ! 		saved_csr:adv_dma$csr_register;  					{ CSR on initialization } 		bad_count: word_count; 					{# words not transferred} 		dest_physical: physical_addr;  					{Q-bus mapped address	} 		dest_ptr: ^anytype;  					{pointer to destin buffer} 8 		receive_buffer : packed array[0..15]of [word]adv$data;  					{array for a full scan of }" 					{ all channels w/progr read } 		receive_ptr : adv$data_ptr;  		request_state: boolean;  					{ADV11-D status		} & 		user_id: integer;	{user defined id	}+ 		aborted	: boolean;	{cancel request flag	} ( 		free	: boolean;	{state of descriptor	}' 		index	: word;		{index of descriptor	}  		end;    # 			{ Device Communication Regions }    	adv_dma$region = record* 		done_queue: queue_entry; {read complete} 		request_queue:queue_entry; 					{read request} & 		descs : array[1..siz]of buffer_desc; 					{free list}  ! 		bus_adapter:boolean;	{flag for}  					{unibus map} 1 		abort_request:boolean;	{abort pending requests} $ 			{fields needed to invoke another} 			{read from the isr.} $ 		don_dbr: adv_dma$ext_dbr_register;# 			{converted data for progr Input} ) 		don_csr_template: adv_dma$csr_register;  			{ has default values } $ 		don_csr_array: packed array[0..15] 			of adv_dma$csr_register; % 			{ for channel specific parameters}  		don_clock_enable: boolean; 			{ external clock used}  		don_finished: boolean;& 			{ for completion of progrmd input } 		don_qptr: ^queue_entry; * 			{ used for auto-incr on progrmd input } 		don_first_channel: integer;  			{first channel to read} 		don_last_channel: integer; 			{max channel 	} 		don_word_count: integer;" 			{default to 1 for progr. input} 		don_sample: integer;' 			{sample being read. for prog. input}  		don_queue_empty: boolean; * 			{ remember if the queue was empty when}) 			{ doing a prog read w/auto increment }  		don_last_sample: integer;  			{last sample to read}		 		end;     	adv_dma$error_region = record 		error_flag: boolean; 		end;     		{ Device Context Record }     	adv_dma$context_record = record" 		adv_dma_region: ^adv_dma$region; 		adv_dma_device: device; * 		adv_error_region: ^adv_dma$error_region; 		adv_error_device: device;	 		adv_dma: ^adv_dma$registers; 		priority: integer;$ 		descs_lock: mutex;	{freelist lock} 		hrdwre_lock: mutex;  					{use w/Queue-Read}  		end;  " 	adv_dma$=^adv_dma$context_record; 				{device context pointer}       procedure 		eln$adv_initialize$ 			(device_name: varying_string(30);& 			clock_start_enable: boolean:=false; 			re_init: boolean:=false;  			max_channel_num:integer:=15; $ 			var	context_identifier: adv_dma$; 			var	stat:integer); 	 separate;       0 { context_identifier is c_i for debugging ease } procedure		eln$adv_queue_read  			(c_i: adv_dma$; 			transfer_type: boolean; 			start_chan: integer; ( 			auto_increment_enable:boolean:=false;# 			multi_conversion: boolean:=true;  			dest_buffer: ^anytype;  			wrd_count: word:=1; 			user_id: integer; 			var	gain_array: 			 [optional]adv$gain_array;  			var	queued: boolean);	 separate;     0 		{use c_i for context_identifier for debugging}  procedure		eln$adv_transfer_done   			(c_i:adv_dma$;  				var	user_id: integer;  				var	dest_buffer: ^anytype; 				var	bad_count: word_count; 				var	done_stat: code;( 				time_out_sec: integer:= %x7FFFFFFF);	 separate;    var  	re_init : boolean:=false;   end ;	{of module}                                                                                                                                                                                                                   ' * [SYSEXE.SEAS$WORK_0000005C]ANALOG.PAS;1 +  ,    .     /     4 c                          - 
    0   1    2   3      K  P   W   O     5   6  Uo.  7 A7H  8          9          G    H  J                                                                                                                                                                                                                                                    Vm $      ELN042.B                         
  '[SYSEXE.SEAS$WORK_0000005C]ANALOG.PAS;1                                                                                        c                              A              " module $analog [ident('V2.0-00')];  M {****************************************************************************  {*									    *- {*  Copyright (c) 1984, 1990      						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  {  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { A {	This module contains the exerciser for the axv and kwv drivers. F {	It is intended as a demonstration of some ways to use these drivers. { 	 { AUTHOR:  {  {	Jay Palmer, December 1984  { 
 { VERSION: { 	 {	V2.0-00  {  {--}  " include $axv_utility,$kwv_utility;   const start_chan = 7;        end_chan = 7; ]       clock_samp_count = 20;	{ # of samples to read per channel when clock starting is used } c       noclock_samp_count = 2000; { # of samples to read per channel when program starting is used }   R type clock_samp_array_type = axv$data_array(clock_samp_count,start_chan,end_chan);  - var clock_samp_array : clock_samp_array_type;    program test(input,output);   M   { This program runs three simple tests of an AXV11C or ADV11C device, using J     a KWV11C device both to initiate conversions and measure elapsed time.H     Some simple assumptions are made about the devices (this program may.     be modified if different conditions hold):  C 	A. The devices are known to the system builder as "AXV" and "KWV". > 	B. The AXV11C device is set up with an input voltage range of 	   -10V to +10V. C 	C. The AXV11C device is set upt to give offset binary output data. B 	D. The clock overflow tab on the KWV11C is connected to the clock 	   input on the AXV11C. }   var axv : axv$;      kwv : kwv$;      status : integer; 
     v : real; -     clock_abuff_ptr : ^clock_samp_array_type; P     noclock_abuff_ptr : ^axv$data_array(noclock_samp_count,start_chan,end_chan);#     kbuff_ptr : ^kwv$data_array(1);      total_values : integer;      tick_count : integer;      sum : integer;     chan : integer;      samp : integer;      begin   I   { For the first test, run the axv using interrupts, but do not initiate K     conversions with the clock.  Instead, use the clock to time the overall      rate of data collection. }  C   total_values := noclock_samp_count * (end_chan - start_chan + 1);      { Initialize both devices. }.   eln$axv_initialize('AXV', identifier := axv,! 		maximum_values := total_values,  		use_polling := false);  .   eln$kwv_initialize('KWV', identifier := kwv,  		mode := kwv$mode_three, 		maximum_values := 1, 		clock_rate := kwv$rate_1khz);      { Start the clock. }   eln$kwv_write(kwv);      { Gather the data. }=   eln$axv_read(axv, start_chan, end_chan, noclock_samp_count, & 	noclock_abuff_ptr, status := status);  /   { Stop the clock and read the elapsed time. }     eln$kwv_read(kwv,1,kbuff_ptr);     if status <> 1   then begin      writeln('failure of test1');     goto failure1;     end;  *   { Print the results of the first test. }I   writeln('Results of axv run with interrupts, using program starting:'); J   writeln('The sample rate was ', total_values/kbuff_ptr^[1]:5:2, ' kHz');'   for chan := start_chan to end_chan do 	     begin 
     sum := 0; *     for samp := 1 to noclock_samp_count do1       sum := sum + noclock_abuff_ptr^[samp,chan]; &     sum := sum div noclock_samp_count;(     v := (sum - %o4000) / %o4000 * 10.0;6     writeln('channel ', chan:1, ' voltage = ', v:5:2);     end;
   writeln;  	 failure1:   J   { Second, test the axv using polling with the kwv being used to initiateJ     sampling.  Keep increasing the clock frequency until a failure occurs.E     Take 10 samples on each channel and average the result values for      each channel as a check. }  A   total_values := clock_samp_count * (end_chan - start_chan + 1);      { Initialize the devices. } .   eln$axv_initialize('AXV', identifier := axv, 		clock_start_enable := true, ! 		maximum_values := total_values,  		use_polling := true, 		re_initialize := true);   .   eln$kwv_initialize('KWV', identifier := kwv, 		mode := kwv$mode_one,  		maximum_values := 1, 		clock_rate := kwv$rate_1mhz, 		re_initialize := true);   &   tick_count := 333;	{ start at 3kHz }  B   { Loop once to gather data at a successively higher frequency. }   while true do 	     begin   L     { Set up the clock so that the axv can use it to initiate conversions. }'     eln$kwv_write(kwv,true,tick_count);   *     { Gather the data at this frequency. }=     eln$axv_read(axv, start_chan, end_chan, clock_samp_count, ) 	clock_abuff_ptr, kwv, status := status);        if status <> 1     then goto finished2;  O     { Save the results of the last call and try another one at a faster rate. } )     clock_samp_array := clock_abuff_ptr^; !     tick_count := tick_count - 1;      end;  
 finished2:  +   { Print the results of the second test. } D   writeln('Results of axv run with polling, using clock starting:');R   writeln('Maximum sample rate attained was ', 1000.0/(tick_count+1):5:2, ' kHz');'   for chan := start_chan to end_chan do 	     begin 
     sum := 0; (     for samp := 1 to clock_samp_count do       begin /       sum := sum + clock_samp_array[samp,chan]; 
       end;     writeln;  $     sum := sum div clock_samp_count;(     v := (sum - %o4000) / %o4000 * 10.0;6     writeln('channel ', chan:1, ' voltage = ', v:5:2);     end;
   writeln;  L   { Third, test the axv using interrupts with the kwv being used to initiateJ     sampling.  Keep increasing the clock frequency until a failure occurs.E     Take 10 samples on each channel and average the result values for      each channel as a check. }  A   total_values := clock_samp_count * (end_chan - start_chan + 1);      { Initialize the devices. } .   eln$axv_initialize('AXV', identifier := axv, 		clock_start_enable := true, ! 		maximum_values := total_values,  		use_polling := false,  		re_initialize := true);   .   eln$kwv_initialize('KWV', identifier := kwv, 		mode := kwv$mode_one,  		maximum_values := 1, 		clock_rate := kwv$rate_1mhz, 		re_initialize := true);   8   tick_count := 667;	{ begin with a 1.5kHz sample rate }  1   { Loop once to gather data at each frequency. }    while true do 	     begin L     { Set the clock up so that the axv can use it to initiate conversions. }'     eln$kwv_write(kwv,true,tick_count);        { Read the data. }=     eln$axv_read(axv, start_chan, end_chan, clock_samp_count, ) 	clock_abuff_ptr, kwv, status := status);        if status <> 1     then goto finished3;  O     { Save the results of the last call and try another one at a faster rate. } )     clock_samp_array := clock_abuff_ptr^; !     tick_count := tick_count - 1;      end;  
 finished3:  *   { Print the results of the third test. }G   writeln('Results of axv run with interrupts, using clock starting:'); R   writeln('Maximum sample rate attained was ', 1000.0/(tick_count+1):5:2, ' kHz');'   for chan := start_chan to end_chan do 	     begin 
     sum := 0; (     for samp := 1 to clock_samp_count do/       sum := sum + clock_samp_array[samp,chan]; $     sum := sum div clock_samp_count;(     v := (sum - %o4000) / %o4000 * 10.0;6     writeln('channel ', chan:1, ' voltage = ', v:5:2);     end;
   writeln;     end;   end;                                                                    + * [SYSEXE.SEAS$WORK_0000005C]AXVKWVBODY.PAS;1 +  ,    . B    /     4 t   B   @ T                   - 
    0   1    2   3      K  P   W   O A    5   6 @B_  7 ?TH  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               = $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]AXVKWVBODY.PAS;1                                                                                    t     B                         B             . module eln$axv_kwv_utility [ident('V2.0-00')];  M {****************************************************************************  {*									    *- {*  Copyright (c) 1984, 1990      						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  {  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { ? {	This module contains the code (procedure bodies and interrupt A {	service routines) for the drivers for the adv11c/axv11c digital @ {	to analog and analog to digital converters and the kwv11c real
 {	time clock.  { 	 { AUTHOR:  {  {	Jay Palmer, December 1984  { 
              { VERSION: { 	 {	V2.0-00  {  { MODIFIED:  { " {       Bob Porras, July 14 1988 -/ {          Added status for KWV_WRITE - QAR 608  { % {       Ron Krueger, April 30, 1990 - B {          Fixed race condition in AXV_READ polled mode - QAR 1173 {  {--}     export;   , include $elnmsg, $axv_utility, $kwv_utility;  + { Types used privately by these routines. }    	{ axv device registers }   ' type	axv_csr_type = [word]packed record 6 		start 		: [pos(0)]boolean;	{ initiate a conversion }4 		gain_setting	: [pos(2)]axv$gain;	{ controls gain }O 		ext_start_enable : [pos(4)]boolean;	{ permits external starts of conversion } Q 		clock_start_enable : [pos(5)]boolean;	{ permits external starts of conversion } O 		done_int_enable : [pos(6)]boolean;	{ enables interrupt at end of conversion } ? 		a_d_done : [pos(7)]boolean;		{ set when conversion complete } B 		multiplexer_address : [pos(8)]0..15;	{ channel being addressed }R 		error_int_enable : [pos(14)]boolean;	{ enables interrupt at an error condition }< 		a_d_error : [pos(15)]boolean;		{ set when error detected } 		end;  > 	axv_dbr_type = [word]axv$data;			{ result of a/d conversion }  * 	axv_registers = [aligned(1)]packed record5 			  csr : axv_csr_type;		{ control/status register } 2 			  dbr : axv_dbr_type;		{ data buffer register }V 			  dac_a : axv_dbr_type;		{ dac channel A output register - not present for adv11c }V 			  dac_b : axv_dbr_type;		{ dac channel B output register - not present for adv11c }	 			  end;   B 	{ Since most processing of reads              is done in the interrupt serviceB 	  routine, most variables needed for processing a read must be inD 	  its interrupt region.  These variables are prefixed with dir_ for 	  "done_interrupt_region". } 9 	axv_done_interrupt_region(max_values : integer) = record P 				dir_delay : integer;				{ dummy variable cleared for delay in polling loop }P 				dir_dbr_read : axv_dbr_type;			{ temporary repository for data read in isr }M 				dir_finished : boolean;				{ true when the present read is the last one } ; 				dir_buffer_index : integer;			{ index to buffer array } 4 				dir_channel : integer;				{ channel being read }< 				dir_first_channel : integer;			{ first channel to read }; 				dir_last_channel : integer;			{ final channel to read } 2 				dir_sample : integer;				{ sample being read }8 				dir_last_sample : integer;			{ last sample to read }E 				dir_clock_start_enable : boolean;		{ clock signaling is enabled } G 				dir_ext_start_enable : boolean;			{ external signaling is enabled } 3 				dir_csr_template_array : packed array[0..15] of , 						axv_csr_type;			{ csrs to be written }L 				dir_kwv_present : boolean;			{ true if kwv_ident specified in kwv_read }_ 				dir_kwv_registers : ^kwv_registers;		{ addr of kwv's device registers, if above flag true } D 				dir_kwv_csr_template : kwv_csr_type;		{ for reading csr of kwv }H 				dir_buffer_size : integer;			{ maximum size of the buffer in words }< 		{MUST BE LAST}	dir_buffer : packed array[1..max_values] of1 					[word]axv$data;			{ results of conversions }  			   	end;   $ 	axv_error_interrupt_region = record 				 error_flag : boolean;	 				 end;    	{ data area for each device } 	axv_data_area = packed record@ 			  done_device : device;		{ device object for done interrupt }A 			  error_device : device;	{ device object for error interrupt } K 			  devnam : varying_string(30);	{ possibly needed for re-initialization } ? 			  polling : boolean;		{ use polling rather than interrupts } : 			  axv_priority : integer;	{ device interrupt priority }B 			  registers : ^axv_registers;	{ address of device's registers }Z 			  done_region_ptr : ^axv_done_interrupt_region(1);	{ address of done interrupt region }Z 			  error_region_ptr : ^axv_error_interrupt_region;	{ address of error interrupt region }	 			  end;    	{ kwv device registers } # 	kwv_csr_type = [word]packed record . 		go		: [pos(0)]boolean;	{ start the counter }1 		mode		: [pos(1)]kwv$mode;	{ mode of operation } / 		rate		: [pos(3)]kwv$clock_rate;{ clock rate } 7 		int_ovf		: [pos(6)]boolean;	{ interrupt on overflow } ; 		ovf_flag	: [pos(7)]boolean;	{ counter overflow occurred } 9 		maint_st1	: [pos(8)]boolean;	{ simulate firing of st1 } 9 		maint_st2	: [pos(9)]boolean;	{ simulate firing of st2 } ; 		maint_osc	: [pos(10)]boolean;	{ simulate one cy. of osc } : 		dio		: [pos(11)]boolean;	{ disable internal oscillator }I 		flag_overrun	: [pos(12)]boolean;	{ ovf occurs with ovf_flag still set } I 		st2_go_enable	: [pos(13)]boolean;	{ assertion of st2_flag sets go bit } R 		st2_int_enable	: [pos(14)]boolean;	{ assertion of st2_flag causes an interrupt }B 		st2_flag	: [pos(15)]boolean;	{ start interrupt request for st2 } 		end;  " 	kwv_bpr_type = [word]kwv$counter;  * 	kwv_registers = [aligned(1)]packed record5 			  csr : kwv_csr_type;		{ control/status register } 4 			  bpr : kwv_bpr_type;		{ buffer/preset register }	 			  end;   g 	{ Interrupt service communication region for the schmitt trigger #2 interrupt.  Variables present here 6 	  carry the prefix sir_ for "st2 interrupt region". }8 	kwv_st2_interrupt_region(max_values : integer) = record7 				sir_mode : kwv$mode;			{ device mode of operation } J 				sir_buffer_size : integer;		{ maximum size of result buffer in words }F 				sir_buffer_index : integer;		{ current position in result buffer }: 				sir_csr_template : kwv_csr_type;	{ csr to be written }M 				sir_csr_reset : kwv_csr_type;		{ for use in clearing the csr's st2 flag } I 				sir_error_flag : boolean;		{ indicates that a device error occurred } N 				sir_last_value : integer;		{ # of values to read in one call to kwv_read }W 		{MUST BE LAST}	sir_buffer : packed array[1..max_values] of	{ buffer for values read }  					[word]kwv$counter;  			   	end;   ( 	{ Data area for each physical device. } 	kwv_data_area = packed recordJ 			devnam : varying_string(30);	{ needed for re-initialization sometimes }5 			polling : boolean;		{ polling to be used on read } 8 			st2_device : device;		{ st2 interrupt device object }@ 			registers : ^kwv_registers;	{ address of device's registers }8 			kwv_priority : integer;	{ device interrupt priority }Y 			st2_region_ptr : ^kwv_st2_interrupt_region(1);	{ address of ISR communication region }  			end;   6 interrupt_service done_interrupt( reg: ^axv_registers;4 			             com: ^axv_done_interrupt_region(1));  G   { Called upon receipt of an interrupt indicating that a conversion is B     complete.  This routine reads the data from the just-completedD     conversion and then either initiates the next conversion or else=     (if no more conversions need be done) signals the device.   
   Parameters:   ' 	reg - address of the device registers;   < 	com - address of the done interrupt communication region. }     begin    with com^ do	     begin      { Read the new data. },     dir_dbr_read := read_register(reg^.dbr);  O     { Write the csr to initiate the next read, if there's to be another read. }      if not dir_finished G     then write_register(reg^.csr, dir_csr_template_array[dir_channel]);   &     { Copy the data into the buffer. }1     dir_buffer[dir_buffer_inde                                                                                                                                                                                                                                            $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]AXVKWVBODY.PAS;1                                                                                    t     B                           "            x] := dir_dbr_read;   t     { Signal the device if that was the last piece of data to gather.  At this time, it's also necessary to stop theP       clock if it was started by the call to axv_read that is being processed. }     if dir_finished      then begin       if dir_kwv_present+       then with dir_kwv_registers^ do begin 3         dir_kwv_csr_template := read_register(csr); )         dir_kwv_csr_template.go := false; 4         dir_kwv_csr_template.st2_go_enable := false;2         write_register(csr, dir_kwv_csr_template);         write_register(bpr, 0);          end;       dir_finished := false;       signal_device;       goto return;
       end;  D     { Now, while the device is busy getting the next piece of data, ;       update some variables in the done interrupt region. } -     dir_buffer_index := dir_buffer_index + 1;   %     if dir_channel = dir_last_channel      then%       if dir_sample = dir_last_sample 
       then 	dir_finished := true        else begin" 	dir_channel := dir_first_channel; 	dir_sample := dir_sample + 1; 	end     else%       dir_channel := dir_channel + 1;        end;   return:      end;  7 interrupt_service error_interrupt( reg: ^axv_registers; 3 			             com: ^axv_error_interrupt_region );   G   { Called on an error interrupt.  Such an interrupt means that either: B 	A. A clock or external start was initiated before the "transition@ 	   interval" completed.  This interval is necessary so that the: 	   analog voltage being read has adequate time to settle.? 	B. A conversion has completed, but the results of the previous*8 	   conversion were never read, and will be overwritten.  D     Both of these conditions can only occur if clock and/or external     starting is enabled.  
   Parameters:,  ' 	reg - address of the device registers;s  < 	com - address of the done interrupt communication region. }       beginn  D   { Just set the flag so axv_read can tell that an error occurred. }   com^.error_flag := true;   end; n" procedure_body eln$axv_initialize;  I   { This procedure is called to allocate and initialize the data area foraK     an ADV11C or AXV11C.  It also creates the necessary device objects.  IteL     must be called at least once for each physical device.  It may be calledJ     more than once for a given device if it's desired to change one of the     input parameters. }      beginnF   { Get a new identifier, unless this is a re-initialization, in which$     case the old one will be used. }   if not re_initialize   then$     new(identifier::^axv_data_area);  $   with identifier^::axv_data_area do	     begin	       if re_initialize     then       begin*:       if maximum_values > done_region_ptr^.dir_buffer_size
       thenD 	{ If a larger communication region need be created, then delete andI 	  re-create the done device.  Otherwise, use the existing done device. }  	begin 	delete(done_device);i         create_device(devnam,t 		  done_device, 		  vector_number := 1,	& 		  service_routine := done_interrupt, 		  region := done_region_ptrE1 				::^axv_done_interrupt_region(maximum_values),  		  registers := registers,  		  priority := axv_priority);         end;	       end        else       begin,  K       { Initialization for the first time - create a device object for both A 	the done and error interrupts, and save the device's name in thetD 	data area so it will be available for possible re-initialization. }        create_device(device_name, 		  done_device, 		  vector_number := 1,]& 		  service_routine := done_interrupt, 		  region := done_region_ptr{1 				::^axv_done_interrupt_region(maximum_values),e 		  registers := registers,  		  priority := axv_priority);          create_device(device_name, 		  error_device,c 		  vector_number := 2,e' 		  service_routine := error_interrupt,u  		  region := error_region_ptr);         devnam := device_name;
       end;  >     { initialize some variables in the done interrupt region }     with done_region_ptr^ do       begin(3       dir_clock_start_enable := clock_start_enable;n4       dir_ext_start_enable := external_start_enable;(       dir_buffer_size := maximum_values;
       end;  )     { initialize error interrupt region }e*     error_region_ptr^.error_flag := false;  #     { initialize the device's csr } #     write_register(registers^.csr);b  .     { Initialize variables in the data area. }     polling := use_polling;   '     { Return the status if requested. }d     if present(status)     then status := 1;      end;     end;     procedure_body eln$axv_read;  H { This routine is called by the user program to gather some data from anI   AXV11C or ADV11C device on the specified channels.  It may initiate theiD   conversions itself or allow a KWV11C real time clock to do this. }  0 var	channel			: integer;		{ channel beign read }? 	csr_read		: axv_csr_type;		{ variable into which csr is read }y? 	dbr_read		: axv_dbr_type;		{ variable into which dbr is read }yH 	kwv_csr_template	: kwv_csr_type;		{ used if a kwv device is specified }Z 	clk_ext_start_enable	: boolean;		{ true if either clock or external starting is enabled }G 	buffer_index		: integer;		{ index to result buffer - used in polling }_H 	total_reads		: integer;		{ used to detect termination of polling loop }        	n			: integer;     begina  $   with identifier^::axv_data_area do	     begine  J     { First, set up the csr templates - one for each channel to be read. }     with done_region_ptr^ do	     begingT       csr_read := read_register(registers^.csr);			{ start with existing csr value }M       clk_ext_start_enable := dir_clock_start_enable or dir_ext_start_enable;	4       for channel := start_channel to end_channel do
         beginv4         dir_csr_template_array[channel] := csr_read;/         with dir_csr_template_array[channel] dor 	  begind           start := not clk_ext_start_enable;			{ start only if clock/external starting not enabled }a 	  clock_start_enable := dir_clock_start_enable;		{ set up clock and external start enable bits }y, 	  ext_start_enable := dir_ext_start_enable;N 	  done_int_enable := not polling;			{ enable both interrupts if not polling }# 	  error_int_enable := not polling; 4 	  multiplexer_address := channel;			{ set channel }< 	  if present(gain_array)				{ set gain if it was supplied }3           then gain_setting := gain_array[channel];e 	  end;o         end;
       end;       if polling     then       beginn!       { Set up local variables. }        buffer_index := 0;K       total_reads := reads_per_channel * (end_channel - start_channel + 1);e  0       { Disable interrupts during the polling. }'       disable_interrupt(axv_priority); n         channel := start_channel;r  J       { Start the clock if the kwv_ident was supplied.  Simulate a schmitt 	trigger #2 event to do this. }o       if kwv_ident <> nil 7       then with kwv_ident^::kwv_data_area.registers^ do 
         beginc/         kwv_csr_template := read_register(csr);r+         kwv_csr_template.maint_st2 := true;r.         write_register(csr, kwv_csr_template);         end;  3       { Write the csr to initiate the first read. } ]       write_register(registers^.csr, done_region_ptr^.dir_csr_template_array[start_channel]);s  N       { Loop to read each piece of data.  Use a different loop, depending uponE 	whether or not the clock/external signals are being used to initiate	 	conversions. }a       if clk_ext_start_enabler.       then while buffer_index < total_reads do 	begin  0 	{ Update the buffer_index and channel number. }" 	buffer_index := buffer_index + 1; 	if channel = end_channele 	then( 	  channel := start_channelt 	elsec 	  channel := channel + 1;   	{ Polling loop. } 	repeatt- 	  csr_read := read_register(registers^.csr);r/ 	until csr_read.a_d_done or csr_read.a_d_error;l  3 	{ Write the CSR to initiate the next conversion. }tQ 	write_register(registers^.csr,done_region_ptr^.dir_csr_template_array[channel]);e  9 	{ Stuff the data from the conversion that just completedm 	  into the result buffer. }L 	done_region_ptr^.dir_buffer[buffer_index] := read_register(registers^.dbr);   	if csr_read.a_d_error 	then begini( 	  error_region_ptr^.error_flag := true; 	  enable_interrupt; 	  goto finished;_ 	  end;z   	end  :       { Clock is not being used to initiate conversions. }.       else while buffer_index < total_reads do 	begin  0 	{ Update the buffer_index and channel number. }" 	buffer_index := buffer_index + 1; 	if channel = end_channela 	thene 	  channel := start_channelr 	elseg 	  channel := channel + 1;   	{ Polling loop. } 	repeat	- 	  csr_read := read_register(registers^.csr);e/ 	u                                                                                                                                                                                                                                                                           n $      ELN042.B                       ,         	                           eqsqreY.EXE;1                                                                                                             3@"            Y8}(:cwVBxt^9
Q`6XKP6@8c~^$Y[v*BYN9,!1Z
-Eyƒ3yl^|'[^j{0@E2/ZD/պ]:jO~p?`ʔv'J̖M:xG0,j2>6@
u
>
xee_6{)5>.5mUa E b΄idpVCzp"5ZEYѕ9~}iNmļNNd/vA<Ƈ*+w҃bS-/֟oPw&֘oW	 '*jMWg}Sn'XJ[aG[=%^J*Suyni@LRr,u68. E.GL4Kf=ݣ-'HT) f\EwʇzXӾ%
bv6lȴs\% r~J%Rn_s_,?I"r-e7}	ڻEAQJXxU@(ӼThO-(!uWY-"/pCt̶"L#)S}R(\ԫ<"k:INKGYN0=K* [i-cJFjRz(1sBLTxC	a'!\-V !ԍZ],PgSY}nx5X6LHJhNlo0Geѝc#GmTDOE8i7)~!<9C\8}0ԲA]5dXMLTl?hQJBUqk@W>2Ra#NM[l?eM$H3HOMz4zho_/Q%x
o8;xě=1C^T8U2@&!Z+Xzyb-8}ra:Y;ukYfUn?˩}f<(@ srnB nx$ xJnÀ+K&K)/ FZ|ҩ'N#D%xibdl#JhHŧF8JAȤT3llzsP$x* =LMiac;~L^<63yPE1nZ2r^_N16lr=_MBk@`C@j;GPPHzOf\_8,KtYBr1x%{wf.5m+G]TC,&\5G(\
LjڟyŲV&(21(|Z02"cW>z|t>YￂK/ȡX^!?<&]'4ZfU?+J*.5m.
Ѥ| <@ϕ#7pnzѩnJFsa5rxg}A5VdSPxN٪+XF++%}
*e4I0*tIrx)=qbWbkgJڤcleM<O`1ȾTB}jJM.
Uڰe]Euvj2b u9wvl@h!N̤mT>L`>Ox@M5`[1(]צn/%">V xۍ5_#~9jiMgS{P>\gg5Ǫ5"Am7jL<rzӦi20Z\0Thn@~/[lyZ?.,N!fey>b5Hϖm#U1a!e*IY:f23F̱r}q"o_:CpƜ4]Բ)
I:6u|kW+x:o#>E/#*Ҥ'H6@аgc՝1@؈*@olf6zCE0l,bʆ,trqnc~9t~C5G[x+:Ԕz4 "s8J+I:2jqO +b'wM.-4_ztxDMw,2-fju+!^*NF*U3AIoP_t+̪<l|6vJɥYwO OYi;4]EA~Pwb)5S^pY,'^}JNGD}^w0%(b[SoX\)&ćZ\U\	E&{ucʰ"-
%J}(^CMhYGL$^^T=Jpw
*KAAd^G^խ8By0plyN>@}yA ;&N"s_ ^&* *r\_@EJ@iw~
]f^wC@B:n1@^W{s6߷6NZ#-+>W|fvaos"|m
<Ӑe#Nz*8ZEX'4O!5_WJ^2,3#K[`i2+
7;Eϗ.:]]*ITz@"	"+2'NyB.rn3tS#~
+&>y$%Frb&7Pąz8bCq^h(Ea_0da&.dn_&4Bf(JoOWdׁDI^i@3T/-׿wL@>L4{6?-pAL'Jb`mZY-8s%@:u@?2\.5:r
Z,l<= Oxh;&Li#r	P |:+XlW2"1zXg9 ̤T3+jw
iZy 5}@.p=M$`pC+5}b.\r^
H~
@k]A
Z-U(`K>p!8 ,.&Pr`q03 %,2beFt*~!W9@Nπ|c/I$(LW:CHqeWW|zma0]BpwDI%}UM}XB'n!`{_ CcYt23;Ai-Ƕv
e@Nj7>!B$9
E+Kd@ayTAWԔwM[hBMIA -/->~&k]gg`*7A[QBi^EMl?X*E-j+9grӨv&&8T)	ֽXmYZ]fq3sqU..M*v
`"N`_nye|>+ dqe	zvn(Yd]SWLCT%g~I4(B%Bi9`
i(?4`m i @1yOh$GLD-OmDX,EeHRGQA4E)|cdy0YQj\a-Q4qkiǭ--P_fme	<dN"V
cmq/^9nѤnj pd@JU^}7h;1//\
٣V0Nm#jX/&W+=MsJTm
G&t&",.;$-qdK|+M$~	6,O %8JeuPI4jo+l}{1l=ROJaL"]Z
)'#:#|G`N̘pm+0Ei3C+(? 	fQq̲wx\!c~,w'0-v^]fqi^DXZ26zm7>#G
:LCcL؞B,\nsJ[DW|%
uOXGfVcZ%s٠WA$%n2d}n{:o2y`6m?TmC:7mi#5q'cy^!;D5%._sꧾԥ3 ey%Bx^jnN+l+%um`g=T[o}8ONXK}@YPaGXMF-\X4z}![
@]>߱y(^R`+Nw!_yvIXCA*>jOG.qe72?m~3kA@1Y[-'_yG<HvSYYMqsB39%={3|r tvҁڙ߂쳲胐캖ǫěԢ֐Ӿ䆹ƚԴԳ㨕խ̨ܔJs,YOe(M-}o#^ee`Y=Susa\
f.hjKIe=-aZD	s|L}QDUWXiga\! U?LAj@B&66n`e&'l}@+'TvQ#SwyEHnVOA
D(L+daG)n4{=m+N]'T"Z^m]$M#
fJ'+
d`N`,6uQ;5mo?gSrmntX_pz9k  >`<A+zHQ/hjDHkE6IPbFqR=W~fmXk%]s%?f@NP~wU<.0t( s[c0xh9W,N RgwvSk'v^|0OJ3_.rt}
FU{?q]1%p	U	E2zp3@nt*8T3g-Z%
)5|&<f;&'5qR:T`>et9tKpJdus0qzCT4j$h!B<#Tw}p[CI[f'{}+&g)t$ry+1S3>Tl!tHc`a/T' -Vzq*
,50^q~@ETIfUU|DoU%BmeLD---EPxR9iSj(}/|#fZU4i#٫oxJ.zSF[,Fw)B%E,)=|'i܂Oޱe4<*y~=)xM#'	a5HYV9^))s
3ʝ_p
f.^c|S24N7xwP	gd@_>2u&Cqs}wRdZыdp8܊&!YD<hĊzroC|̂[[	<0vW9"OE_qlޣܪvʜխu	2"
ovC}Z`1l 
.Z)4C(~#WDa5A؄3!~9?@TbjI*\hlG]3f
b5/F΀AVϺ?4ݻZZlyO_iep;0֍4\
XbBZ?ŋ2EՐR  F_]eS+dˁ,w3k'-`ɳzݩX\05!Є?V7>~0.ZNGd	f",/bྉjBc+q,N7oH9##:~bKRT/Q~ׅ'~!AŭE-f ܫN'ۉ) JWgn=[Ow 196z@Abғ{;|+
g]~B0oj*/SSPXV%ra{>LW{BTkkz]}k܌TH+XtYN+цaWs]ZOk3U~M'I=ac;9_}fv@L:dc\XC|^k@sb#zi5qM}-؏p%^^GKT5AzSԤᮼm!	&Jy988>3`<UU<z%``DXB*j<kHW*MS.Dy7CFOyut@zg6Yq="2vfZ<>@Otc}Q>U	En )(
7۸+_:xAչ#%s.mֶwrBR( =vd*=Ai<-e
Vp"6#a4
5iWp3ߩtL!)!j%S4d?~uMPQQ]۪
V
d0lN g_$۲^<5J0dw];A
A6BsM4%wS)Ҷdn|M]/.45#.2>(
޴<4>
ZR"6 S+?=S$,k)r Qy:!2	*QLri8k4nDzN$l:TgOGRV߳hh)[Q:d>$6vڇO4I6ǌ_?N*טz;ftvTEE=\-O-@=[v}i]ȞнU/axWq&>=]>޻3TEs=?	~UP]דA!]_gNvg:<o4LQG*%pR-V!ٵhU>M;H^[)̨E1pAe7eJk3jg8of_5@;>05eq/hW쇛BW9;ΝGd-{6	s`|s?dV-)YUA<.mB6Ed5H2pFu)[5)XD}0ޛ@a~7^r;YJ(Wv}F-MTjT	LGo2z?b  42E1CtT>$Ie[$nnfYJ[:0.r C@,t_L
c&߄4Q
r
fNPF{t%kokj]oGdZ,Gb6*vd̐%_]ݘ}l @L}dM}qWbov	"-xyoZgMquV6,&M!I>B<b(:Jfh-G<UwiNpe/.X#ՈRIX~>CYIW"K$rQ/a@LTL*C7=;*ge~)fxd-{#e.׶$3'*g[ mr_kKc/sAOS7{Ei<eȘZEʍǯك){lȫ>ٱdK"{psF;5E?6XyJ~C,$6P{R-3u1mu3;NiA c!qԿC)dy
7SHEWw:u}l롔.fyF=!&tG!@;5L$rnKB@@/T{,Z~f׃X"IcX$(6Trx(vIVp`
aI(F.D@otUiAin 
8X7QZ"
f7vy*L&N׵,u̶8L([0E#UҟX&#d_@f<~k|t=g`	h"#st3{TC
sw7.P5WE!2-Vnq7eJ̀VBpq%<2`y==pZ 1?ld$F,	&P`3]B#זj /4r0rX'8͜Oؗ_9B#y[Ƞ3i8>r)q3W)e3V񊹋w
Z/֗ܜǊYRcǄ]N2ÃVwif4jٍEO؂b2J+`IkN`vy`L-
q&]20
vSp}Do69,['V&ä
 F!fEsB;>⁊"d襀L-6tonj&&к=<vz7skŻ]J^c
9a-52`:X~G[s~;x:PoFcX[UcRIKל  gT<@3lMֳI%bb\=Hl1ފY	HDǚfw+O8v:z"q}!MI!> ےQ;Ү]bl-ߏ]<hr
os wSq`OOCg>`\Je6{9u-&9)\)ERz5#@bC39*3O_҃oA!EG%^~d"n*ݡ3%K5"VZa׻Y]
0z1M&#S^t#KUܔ>|Ψx*gكSaV$IP$M%!X +~$=F^],dBx4gSh?sg+Zz
m9A0XT`w}Q
M*rv{:L)n*V`IcO	-KMN9]8K3AzEJx1=	?<%k]*Dl,H0"b)='ykJEdxa97:$_h|'G%9kY@7d i
|7}s_6O_XCu[~z4o
r!1z8yW/|3
rH:Cc,}GIowH1sJ_&t;lJK8Z5w4KU0jmtzV.6ULOP]tRRU
Wame.data[i]; I   server_name.ds                                                                                                                                                                           I $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]AXVKWVBODY.PAS;1                                                                                    t     B                          "     #       ntil csr_read.a_d_done or csr_read.a_d_error;r     I 	{ reading the dbr will clear the done bit in the csr for the next read }k+ 	dbr_read := read_register(registers^.dbr);r  3 	{ Write the CSR to initiate the next conversion. }dQ 	write_register(registers^.csr,done_region_ptr^.dir_csr_template_array[channel]);l  I 	{ Stuff data from the conversion that just completed into result buffer}s7 	done_region_ptr^.dir_buffer[buffer_index] := dbr_read;r   	if csr_read.a_d_error 	then begin	( 	  error_region_ptr^.error_flag := true; 	  enable_interrupt; g 	  goto finished;i 	  end;r   	end;	  D       { Get the last piece of data.  Necessary because the last trip= 	through the loop initiated the last conversion, but read thexJ         next-to-the-last piece of data.  It's necessary to poll the deviceE 	here also.  As soon as the read of data is complete, stop the clock a% 	if it was started by this routine. }n  '       buffer_index := buffer_index + 1;i         repeat2         csr_read := read_register(registers^.csr);       until csr_read.a_d_done;0       dbr_read := read_register(registers^.dbr);         if kwv_ident <> nilm=       then with kwv_ident^::kwv_data_area.registers^ do begin /         kwv_csr_template := read_register(csr);d         write_register(csr);%         kwv_csr_template.go := false;,0         kwv_csr_template.st2_go_enable := false;.         write_register(csr, kwv_csr_template);         write_register(bpr, 0);)         end;  2       { Set the error flag if there were errors. }9       error_region_ptr^.error_flag := csr_read.a_d_error;t  <       done_region_ptr^.dir_buffer[buffer_index] := dbr_read;         enable_interrupt; 	       endf  H     { No polling - use interrupts instead.  Set up for the first read. }     else       beginb  8       { Set up variables in the done interrupt region. }       with done_region_ptr^ do 	begin  ? 	{ Set up some variables for the ISR.  Note that dir_sample andf' 	  dir_channel reflect the next read. }g& 	dir_last_sample := reads_per_channel;$ 	dir_first_channel := start_channel;! 	dir_last_channel := end_channel;  	dir_buffer_index := 1;: 	if kwv_ident <> nil 	then begin  	  dir_kwv_present := true; < 	  dir_kwv_registers := kwv_ident^::kwv_data_area.registers; 	  end 	else dir_kwv_present := false;e  ( 	if dir_first_channel = dir_last_channel 	then beginu 	  if dir_last_sample = 1d 	  thenl 	    dir_finished := trueh
 	  else beginr 	    dir_finished := false; & 	    dir_channel := dir_first_channel; 	    dir_sample := 2;l	 	    end;s 	  end 	else beginl 	  dir_finished := false; ( 	  dir_channel := dir_first_channel + 1; 	  dir_sample := 1;  	  end;   H         { Write the device register to start the first conversion, startC 	  the kwv counting if this was called for, set up the csr templatee> 	  for the next read and wait on the device.  The wait will be, 	  satisfied when all data have been read. }&         write_register(registers^.csr,: 		done_region_ptr^.dir_csr_template_array[start_channel]);   	if kwv_ident <> nil2 	then with kwv_ident^::kwv_data_area.registers^ do 	  begin* 	  kwv_csr_template := read_register(csr);& 	  kwv_csr_template.maint_st2 := true;) 	  write_register(csr, kwv_csr_template);c 	  end;o           wait_any(done_device); 	end;   
       end;  	 finished:e  N     { Clear the device's csr, and read and clear the dbr so as not to leave it"       in an indeterminate state. }#     write_register(registers^.csr);a.     dbr_read := read_register(registers^.dbr);&     write_register(registers^.dbr, 0);  N     { All done - check for device errors.  If one occurred, then either returnJ       an error status or raise an exception, depending upon whether or not(       the return status was requested. }#     if error_region_ptr^.error_flag      then begin,       error_region_ptr^.error_flag := false;       if present(status)*       then status := eln$_axv_device_error2       else raise_exception(eln$_axv_device_error);	       end      else       if present(status)       then status := 1;   2     { Set the pointer to the data just gathered. }E     data_array_ptr::^anytype := address(done_region_ptr^.dir_buffer);h       end;     end; f procedure_body eln$axv_write;t  G   { This procedure is called to output the data given by "value" to the 5     dac channel given by the variable of that name. }      begin $   with identifier^::axv_data_area do	     begin(&     if dac_channel = axv$dac_channel_a0     then write_register(registers^.dac_a, value)1     else write_register(registers^.dac_b, value);n     end;     if present(status)   then status := 1;m   end; e5 interrupt_service st2_interrupt( reg: ^kwv_registers;_3 			             com: ^kwv_st2_interrupt_region(1));   D   { Called upon receipt of an interrupt indicating that an st2 eventH     has occurred.  This routine reads the data from the counter (buffer-H     preset register), tests for a data overrun, and clears the st2 flag.D     If this was the last value to be read, the device object is thenG     signalled and the go and st2_go_enable bits in the csr are cleared.e  
   Parameters:	  & 	reg : address of the device registers  > 	com : address of the interrupt service communication region }     beginr     with com^ do	     begin ,     { Write the csr to clear the st2_flag. },     write_register(reg^.csr, sir_csr_reset);       { Read the new data. }<     sir_buffer[sir_buffer_index] := read_register(reg^.bpr);        { Test for a data overrun. }0     sir_csr_template := read_register(reg^.csr);$     if sir_csr_template.flag_overrun     then begin       sir_error_flag := true;        signal_device;       goto return;
       end;  I     { More data to read?  If not, clear the go and st2_go_enable bits ando       signal the device. }(     if sir_buffer_index = sir_last_value     then begin#       sir_csr_template.go := false;n.       sir_csr_template.st2_go_enable := false;1       write_register(reg^.csr, sir_csr_template);r       signal_device;       goto return;
       end;  O     { Update the buffer index while the device is off reading the next datum. } -     sir_buffer_index := sir_buffer_index + 1;f     end;   return:D     end; n" procedure_body eln$kwv_initialize;  K   { This procedure is called to allocate and initialize the data area for a}M     KWV11C.  It also creates the necessary device objects.  It must be called;L     at least once for each physical device.  It may be called more than onceM     for a given device if it's desired to change one of the input parameters,d9     or to stop a device started by a call to kwv_write. }r     beginrF   { Get a new identifier, unless this is a re-initialization, in which$     case the old one will be used. }   if not re_initialize   then$     new(identifier::^kwv_data_area);  $   with identifier^::kwv_data_area do	     begini  G     { If a larger communication region need be created, then delete and K       re-create the st2 device.  Otherwise, use the existing done device. }      if re_initialize     then       begine9       if maximum_values > st2_region_ptr^.sir_buffer_sizel
       then 	begin 	delete(st2_device);         create_device(devnam,  		  st2_device,= 		  vector_number := 2,n% 		  service_routine := st2_interrupt,_ 		  region := st2_region_ptr0 				::^kwv_st2_interrupt_region(maximum_values), 		  registers := registers,t 		  priority := kwv_priority);         end;	       ende       elseK       { Initialization for the first time - create a device object for bothpC 	the st2 and error interrupts.  Also, save the device's name in thee@ 	data area so that it will be available for re-initialization. }       begin         create_device(device_name, 		  st2_device,g 		  vector_number := 2,s% 		  service_routine := st2_interrupt,r 		  region := st2_region_ptr0 				::^kwv_st2_interrupt_region(maximum_values), 		  registers := registers,  		  priority := kwv_priority);         devnam := device_name;
       end;  >     { Initialize some variables in the st2 interrupt region. }     with st2_region_ptr^ doa       beginh(       sir_buffer_size := maximum_values;       sir_mode := mode;h       sir_error_flag := false;
       end;  #     { initialize the device's csr }a"     write_register(registers^.csr, 		mode := mode,s 		rate := clock_rate,s) 		st2_int_enable := (not use_polling) and 7 			((mode = kwv$mode_two) or (mode = kwv$mode_three)));_  .     { Initialize variables in the data area. }     polling := use_polling;s  '     { Return the status if requested. }s     if present(status)     then status := 1;s     end;     end; n procedure_body eln$kwv_read;  P { This r                                                                                                                                                                                                                                                                           V@ $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]AXVKWVBODY.PAS;1                                                                                    t     B                         Ϥ      4       outine is called for a KWV11C device that has been initialized to run inJ   mode 2 or 3.  The normal case is that the device is not already countingH   (go bit not set).  In that case, it is the function of this routine to:   gather a time value for each external event being timed.  D   However, if the device is already counting, this call simulates anJ   external event and reads the clock, leaving it running.  Following this,G   another value may be read with another call to kwv_read, or the clocka1   may be stopped with a call to kwv_initialize. }e  N var	csr_read,csr_template	: kwv_csr_type;	{ for reading/writing device's csr }A 	csr_reset		: kwv_csr_type;	{ used to clear the st2 flag in csr }t4 	buffer_index		: integer;	{ index to result buffer }     begint  $   with identifier^::kwv_data_area do	     begina2     csr_template := read_register(registers^.csr);  ;     { Process the case that the clock is already running. }p     if csr_template.go     then begin$       { simulate an external event }%       csr_template.maint_st2 := true;o+       csr_template.st2_int_enable := false;p3       write_register(registers^.csr, csr_template);l  #       { poll until it's processed }r       repeat/ 	csr_template := read_register(registers^.csr);n"       until csr_template.st2_flag;  7       { copy the counter value into the result buffer }hE       st2_region_ptr^.sir_buffer[1] := read_register(registers^.bpr);c       goto success;;
       end;       if polling     then       begin_  !       { Set up local variables. }r2       csr_template.st2_go_enable := st2_go_enable;+       csr_template.go := not st2_go_enable;s  M       { Set up the csr reset template to be used in subsequent write_registert; 	operations, whose sole purpose is to clear the st2 flag. }e        csr_reset := csr_template;       csr_reset.go := true;l'       csr_reset.st2_go_enable := false;t  0       { Disable interrupts during the polling. }&       disable_interrupt(kwv_priority);  L       { Write the csr to start the counter or put the device in a state that( 	an st2 signal will start the counter. }3       write_register(registers^.csr, csr_template);e         { Loop for each value. }-       for buffer_index := 1 to value_count dot
         begint   	{ Polling loop. } 	repeat-- 	  csr_read := read_register(registers^.csr);  	until csr_read.st2_flag;n  % 	{ Write the CSR to clear st2_flag. }e* 	write_register(registers^.csr,csr_reset);  > 	{ Stuff the data from the previous time through the loop into3 	  the result buffer and update the buffer index. } , 	st2_region_ptr^.sir_buffer[buffer_index] :=! 	  read_register(registers^.bpr);   = 	{ See if this piece of data was ready before we were througha 	  processing the last one. }  	if csr_read.flag_overrunr 	then begind 	  enable_interrupt; 	  goto dev_error; 	  end;p   	end;=  B       { Clear both the go and st2_go_enable flags in the device. }       csr_template.go := false;e*       csr_template.st2_go_enable := false;2       write_register(registers^.csr,csr_template);         enable_interrupt;n	       end_  ,     { No polling - use interrupts instead. }     else       beginr  7       { Set up variables in the st2 interrupt region. }f       with st2_region_ptr^ dor 	begin  7         { Set up the csr template for the first read. }b3 	sir_csr_template := read_register(registers^.csr);g* 	sir_csr_template.go := not st2_go_enable;1 	sir_csr_template.st2_go_enable := st2_go_enable;h   	sir_buffer_index := 1;c 	sir_last_value := value_count;   A 	{ Set up the csr reset template to be used to clear the st2_flagh' 	  as each piece of data is gathered. } # 	sir_csr_reset := sir_csr_template;d 	sir_csr_reset.go := true;& 	sir_csr_reset.st2_go_enable := false;  M         { Write the device register and wait on the device.  The wait will be=, 	  satisfied when all data have been read. }9         write_register(registers^.csr, sir_csr_template);          wait_any(st2_device);e  ) 	{ Were there any errors while reading? }  	if sir_error_flag 	then goto dev_error 	else goto success;  	end;   
       end;   success:G     { Set the data array pointer to the data just gathered, and set thes       status, if requested. } D     data_array_ptr::^anytype := address(st2_region_ptr^.sir_buffer);     if present(status)     then status := 1;p     goto return;  
 dev_error:  H     { An error has occurred - signals were coming faster than they couldJ       be read.  Return error status if requested, or raise an exception if       it wasn't requested. }     if present(status)(     then status := eln$_kwv_data_overrun0     else raise_exception(eln$_kwv_data_overrun);     end;   return:r     end; v procedure_body eln$kwv_write;;  H   { This procedure is called for a KWV11C device in two different cases:  E     A. The device was initialized to operate in mode 0 or 1.  In thiseG        case, it causes the device to begin counting the given number ofeE        ticks or wait for an st2 signal to begin.  When that number is:E        counted, the clock overflow signal is generated.  Mode 1 means;D        that this action will be repeated.  Thus, this call generates7        a single pulse or a train of them after a delay.,  J     B. The device was initialized to operate in mode 2 or 3.  In this caseJ        the call causes the device to begin counting from zero, or wait forH        an st2 signal to do so.  It is then expected that sometime a callH        to kwv_read will be made, which reads the current elapsed time. }  "   var csr_template	: kwv_csr_type;     beginh$   with identifier^::kwv_data_area do	     begind  J     { Set up the csr template.  Start with the csr as it is and set eitherH       the go or st2_go_enable bit, depending upon whether the program or0       an external event is to start the clock. }2     csr_template := read_register(registers^.csr);0     csr_template.st2_go_enable := st2_go_enable;)     csr_template.go := not st2_go_enable; )     csr_template.st2_int_enable := false;h  K     { If the mod is 0 or 1, load the buffer/preset register with the numberd       of ticks to be counted. }p4     if (st2_region_ptr^.sir_mode = kwv$mode_zero) or0        (st2_region_ptr^.sir_Mode = kwv$mode_one)     then2       write_register(registers^.bpr, -tick_count);  T     write_register(registers^.csr, csr_template);	{ load csr to begin the counting }     end;       if present(status)     then       status := 1;   end;   end;                                                                                                                                                                                          ( * [SYSEXE.SEAS$WORK_0000005C]AXVUTIL.PAS;1 +  ,    .     /     4 M       z                   - 
    0   1    2   3      K  P   W   O     5   6 @3p.  7  rH  8          9          G    H  J                       ' module $axv_utility [ident('V2.0-00')];   M {****************************************************************************  {*									    *- {*  Copyright (c) 1984, 1990      						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  {  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { B {	This module contains declarations for the drivers for the adv11cB {	analog to digital converter and the axv11c combination analog to4 {	digital converter and digital to analog converter. { 	 { AUTHOR:  {  {	Jay Palmer, December 1984  { 
 { VERSION: { 	 {	V2.0-00  {                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            :, $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]AXVUTIL.PAS;1                                                                                       M                                           {--}     include $kwv_utility;     export axv$, axv$data, axv$gain,7        axv$data_array, axv$gain_array, axv$dac_channel, 7        eln$axv_initialize, eln$axv_read, eln$axv_write;    type$ 	{ input/output data and gain data }< 	axv$data		= -%o3777..%o7777;	{ for results of conversions }) 	axv$gain		= (axv$gain_one, axv$gain_two, & 				   axv$gain_four, axv$gain_eight);  / 	{ identifiers - one for each physical device }  	axv$ = ^anytype;   $ 	{ data packets passed to axv_read }  @ 	axv$data_array(values_per_chan,first_chan,last_chan: integer) =; 		packed array[1..values_per_chan,first_chan..last_chan] of  		[word]axv$data; / 	axv$gain_array(first_chan,last_chan:integer) = ( 		packed array[first_chan..last_chan] of 		[byte]axv$gain;   ) 	{ dac channel selections for axv_write } : 	axv$dac_channel = (axv$dac_channel_a, axv$dac_channel_b);    H procedure eln$axv_initialize(device_name : [readonly]varying_string(30); 			   VAR identifier : axv$;$ 			   maximum_values : integer := 1;, 			   clock_start_enable : boolean := false;/ 			   external_start_enable : boolean := false; ' 			   re_initialize : boolean := false; % 			   use_polling : boolean := false; 0 			   VAR status : [optional]integer); separate;  I   { This procedure is called to allocate and initialize the data area for K     an ADV11C or AXV11C.  It also creates the necessary device objects.  It L     must be called at least once for each physical device.  It may be calledJ     more than once for a given device if it's desired to change one of the     input parameters.        Parameters:   > 	device_name - 1 to 30 character string giving the name of theE 	device.  It must match the name established with the system builder.   E 	identifier - variable of type AXV$ that, if this call is successful, A 	receives a longword identifier to be used in subsequent calls to @ 	axv_initialize, axv_read and axv_write to identify this device.  F 	maximum_values - integer expression giving the maximum number of dataG 	values that may be read from this device in a single call to axv_read.   G 	clock_start_enable - optional boolean expression which if true enables C 	a conversion to be initiated by the KWV clock option.  The default  	value is false.  B 	external_start_enable - optional boolean expression which if trueA 	enables a conversion to be initiated by an external signal.  The  	default value is false.  E 	re_initialize - optional boolean expression that, if true, specifies D 	that the device has already been initialized.  If this is the case,C 	device_name is ignored, and the identifier is used to identify the B 	device.  No new data structures or objects are created unless the@ 	maximum_values parameter is greater than the previous value for< 	this device.  The default value of this parameter is false.  D 	use_polling - optional boolean expression that, if true, causes theE 	device to be driven using polling rather than interrupts.  If false, C 	interrupts will be used to gather data.  Polling is always done at ? 	device IPL (four for this device).  The default value for this E 	parameter is false.  The use of polling is only recommended if clock < 	or external starting us being used to initiate conversions.  ) 	status - optional integer to receive the > 	completion status of the routine.  The only possible value is0 	1, which indicates that the procedure completed 	successfully. }  ) procedure eln$axv_read(identifier : axv$;  		     start_channel : integer;  		     end_channel : integer; # 		     reads_per_channel : integer;  		     var data_array_ptr :  			^axv$data_array( 0 			reads_per_channel,start_channel,end_channel); 		     kwv_ident : kwv$ := nil;  		     var gain_array :  			[optional]axv$gain_array( 			start_channel,end_channel);1 		     var status : [optional]integer); separate;   H { This routine is called by the user program to gather some data from anI   AXV11C or ADV11C device on the specified channels.  It may initiate the I   conversions itself or allow a KWV11C real time clock or external signal 
   to do this.   
   Parameters:   G 	identifier - expression of type AXV$ giving the value of an identifier A 	(which was returned by axv_initialize) of the device to be read.   C 	start_channel - integer expression giving the first analog channel  	to be read.  C 	end_channel - integer expression giving the last analog channel to 	 	be read.   A 	reads_per_channel - integer expression giving the number of data @ 	to be gathered for each given by the preceeding two parameters.  C 	data_array_ptr - pointer variable which receives the address of an B 	array containing converted data from the device.  The first arrayB 	element corresponds to the first channel to be read.  The meaning> 	of the converted data is dependent on several hardware jumperH 	positions.  This is described in the LSI-11 Analog System User's Guide.D 	All or part of this array may be overwritten on subsequent calls to 	AXV_READ for this device.  B 	kwv_ident - optional value of type KWV$ that gives the identifierC 	of a KWV real time clock device.  It must be a value returned by a B 	call to KWV_INITIALIZE.  If present, it is assumed that the KWV's? 	clock overflow is connected to the AXV/ADV's clock start line. B 	Just prior to beginning to sample data, the clock is started, andB 	is stopped when all data have been gathered.  The KWV device mustC 	have been initialized to operate in mode 1 (if more than one value A 	is to be read) or mode 0 (if one value is to be read) and set up B 	with the desired tick count (which controls how often an overflowB 	is generated) by a call to KWV_WRITE.  This latter call must alsoB 	have specified st2_go_enable as true so that the call to AXV_READ< 	will do the actual starting of the clock.  If the kwv_ident@ 	parameter is absent, the call to AXV_READ does nothing to start 	a real time clock.   8 	gain_array - optional array variable which, if present,@ 	supplies the gain to be used in the conversion for each channel> 	to be read.  The first array element corresponds to the firstD 	channel to be read.  The allowed values for the gain setting are 1,@ 	2, 4 or 8, which are specified by the enumerated type axv$gain.B 	If this parameter is not present in the call, the gain value thatA 	was used for the last conversion from this AXV will be used.  If D 	no gains are ever used on a particular device, its initial hardware 	value of 1 will be used.   D 	status - optional integer variable to receive the completion statusA 	of the routine.  Possible values are 1, which indicates that the B 	procedure completed successfully and ELN$_AXV_DEVICE_ERROR, whichA 	indicates that either the sampling rate is too high and the data G 	is subject to error or else a conversion completed before the previous H 	conversion's data was read.  Both of these conditions can only occur ifC 	conversions are being initiated by the clock or external signal. }   * procedure eln$axv_write(identifier : axv$;" 			 dac_channel : axv$dac_channel; 			 value : axv$data; . 			 var status : [optional]integer); separate;  G   { This procedure is called to output the data given by "value" to the J     dac channel given by the variable of that name.  It may only be calledF     for an AXV11C device, since an ADV11C does not have any DAC output
     channels.      Parameters:   G 	identifier - expression of type AXV$ which identifies the device to be F 	written to.  It must be a value returned by a call to AXV_INITIALIZE.  < 	dac_channel - expression of type AXV$DAC_CHANNEL giving the! 	output channel to be written to.   C 	value - expression of type AXV$DATA which gives the actual da             ta to A 	be written out.  How this value determines the output voltage is B 	dependent on some hardware jumper settings.  This is described in' 	the LSI-11 Analog System User's Guide.   G 	status - optional integer variable to receive the completion status of D 	the routine.  The only possible value is 1, which indicates that it 	completed successfully. }   end; { module }                                                                                                                                                     $ * [SYSEXE.SEAS$WORK_0000005C]BDA.EXE;1 +  ,    .     /     4                            - 
    0   1    2   3      K  P   W   O 
    5   6 
  7 `;H  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       $      ELN042.B                         
  $[SYSEXE.SEAS$WORK_0000005C]BDA.EXE;1                                                                                                                         5              0 D X     0205      (                                                BDA                                    VAXELN V4.2-00 :
 05-05                                         	     	   
    "      !        
PASCALMSC_001"      !         
LIBCOMMON_001  |1
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           0000 00:00:01.00|^<~*  PV, n fVϡ ώԭԭԭpԭϭԭ;ԭԭϱԭԭԭԭ`
ԭRR߭߭߭߭߭߭߭߭߭߭߭߭VмRb@l^޼Vqc  qױ(sٰS2Sޭ٭GSπ	~ߦƼf߭ߦߦ<c@~S߭ 
P  ЦTЦR RխRR*4*4 *4EdS 	SS  SR  RƏ   RR4ݦR߭4   x	RSRdRR^  P   @  ݏ ߦ\   SxSRSBxS```dh V϶ 4+4 ^QR޼nТPPРS$4ԢWR  n)4)4֢Ѣ
3R
  ϫ R
  ^ЬЬ޼n}ԭЭRRWТV}ǰnǸ&4 $4 *4&4TЭRТS4R T<~cRC
  (4ݭݭjP]QݭP]Q &4ЭRТR)4P<޼UХT4 44 4 4SSRRUeSR 4P^޼RТTXhݢ\|~  `P QQСS4SP@ŏ  SP@SP^޼R޼TТS T&4 T$4xTQn`PApnXhݢ\  |^޼S޼UУRУP)4U&4 U$4 )4VSVЏ0  TøPPT
UPT@Џ   TEpPP T4PT@HУPP4P P44VP^޼R޼SC°߭  ЭP<^޼S޼T޼U޼nR|bԢУP *4DP ߭ݮeP  
U		  PЭb^޼R޼S޼޼ТP *4мnCPnݮP  ^޼SУRУR)4УR)4P^޼S޼УR$4nnP^޼S޼޼nУRn$4 Q\֬Ѭ\g
  ϧ \Y
   ^QR޼S<SP PPPP+SP PPPPSP PPPP	
SPP"ТPРPPP̭yR	  ^Ь޼WԭXσ߭	  }PЭRRVТRТЭЭRТRЭ}T}T|~ SЦRТ}Tnn|~ SS
]Q ЦRW4ԭЦR|~ ֭ѭ
ѭ

]Qώԭ߭ݦ  ЦRЭЦSУ 	fRR ЭЦSУ@ 	fRR Э@RR
RRS<T 	fRRR TЦRTЏ 
SyRG߭  ЦRխ
]QSRRSЦRSG߭  ЦRխ]QωS<RR SЦRSG߭  ЦRխ]QFЦR4S} RRRRSЦRSXXP@޼TUxUSФRCHS4URRREp@UVxVSФRCSŏ  VRRRR cVUŏa   USФRЏ  C UФR|44P޼Z޼V44PЬQ R  <R1	x4SSS1 ޼Yŏ  4RBƌ X+4f	
W/4Pŏ  [@R(hB[4[@Sŏ   4R<Bƈ C;4[@R R[@/4+4PYQ /4!Wŏ  WR(hBWPYQ ŏ  4RBƈ T RR4dx4SSS4R R4x4SSS1|޼S)4&4$4 4VT޼UT$4TPUQ VT (4$ *44R4T R<~cT/  ^޼R޼nТPn+4ТP/4ТP[@ТP_@мޯPR P߭   ޼SУR+4RB|~   
c   УQ_@Rŏ  RP@[4PB;4PУQ_@P P_@ c  УP/4УP/4УR/4 c  1R 1L| ЬVޟH UeUPѥVPR{ IB:
 Q~ݡݡ00Џ   0xPȏ   (Ў0Ўڎݏ|   8 ~0xPQQ_   ڎ ЬTޟH ScSѣTRB
 RԼR ЬTޟH ScSѣTT<D < ЬS 	RBSxSS~R~T~UeݬS~db   x	dP 	PPbR< ЬRЬS 	P@SxSSެUЬQ a1 	QTQePJП P ~Q~P}P~h ՎЎPРP<2
 QxQQ    QA8PРXPD`PTȏ   T ȏ   T``ЀQQ TTSbݬ  8  ݬx~ЬP 	QAPxP~   < ЬQ	QSQ	П PA^nPQߠ`h ЎQՎЎPQРP<2
 RxRR    RB8PРXPˏ  C`Px	PPQ 	P                                                                                                                                                                                                                                                                                                                                                                                                  @  @       \   h                                            H   h   p                 
                 @                                                                       	PASCALMSC                                                      	LIBCOMMON                                                                                                                                                                                                                                                      :     BDAVAXELN V4.2-0010-OCT-1990 23:1110-OCT-1990 23:11  VAX-11 Linker V05-05        	.$$ABS$$.          |BDAUQSSP_PORT$START                                                                                                                                                                                                                                                                                                                                                                                                ' * [SYSEXE.SEAS$WORK_0000005C]BDABOO.COM;1 +  ,    .     /     4 P       |                  - 
    0   1    2   3      K  P   W   O     5   6  .U  7 @9H  8          9          G    H  J                        
 SET VERIFY ! [CONSOLE]BDABOO.COM  ! I ! Command procedure to boot VAXELN from a BDA disk on a single processor  F ! 85nn or 8700 system. Can be invoked by DEFBOO.COM or can be invoked 1 ! directly by using the console command BOOT BDA.  ! G ! The following register deposits must be must be edited to correspond    ! to the hardware configuration: !  ! R1 - Bus address informationO ! R2 - [optional] Bits <31:24> specify controller letter (e.g., DUA, DUB, etc.)  ! R3 - Device unit number  ! 0 SET TERMINAL OPA0               ! Set up logging+ SET DEFAULT HEXADECIMAL, PHYSICAL, LONGWORD P IF NOT HALTED THEN HALT         ! Halt it and avoid unnecessary warning messages< WAIT                            ! Wait for processor to halt4 EXAMINE/SDF 0CA                 ! Retrieve halt code6 DEPOSIT AP @                    ! Move halt code to AP) EXAMINE PC                      ! Halt PC 5 DEPOSIT R10 @                   ! Move Halt PC to R10 * EXAMINE PSL                     ! Halt PSL6 DEPOSIT R11 @                   ! Move Halt PSL to R11* INITIALIZE                      ! Init CPUF SET CPU CURRENT_PRIMARY         ! Select the primary to be booted nextO UNJAM                           ! Clear VAXBI errors, NMI and VAXBI node state   				!  info E DEPOSIT/L/P 3E000000 020F00F0   ! Clear interlock timeout in mem CSR0 C EXAMINE/L/P 3E000010            ! Read mem CSR4 (clears interrupts) B EXAMINE/L/P 3E000014            ! Read mem CSR5 (clears NMI fault)B DEPOSIT/L/P 3E000008 F0000000   ! Clear RDS error bits in mem CSR0* INITIALIZE                      ! Init CPUA DEPOSIT R0 21                   ! Boot device type code - for BDA  ! < ! Modify this line for the VAXBI # and node # for your KDB50 ! B DEPOSIT R1 21                   ! BDA is on VAXBI 2, node number 1- DEPOSIT R2 0			! Unused for single controller  ! / ! Modify this line for the unit # of your drive  ! & DEPOSIT R3 0			! Unit # of drive (= 0)9 EXAMINE R3                      ! Display the unit number 7 DEPOSIT R4 0                    ! Clear unused r                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          gF $      ELN042.B                         
  '[SYSEXE.SEAS$WORK_0000005C]BDABOO.COM;1                                                                                        P                                          egister  ! G ! Change this line to DEPOSIT R5 84 to set the initial kernel debugger  C ! breakpoint. Change it to DEPOSIT R5 0 to enable full memory test.  ! K DEPOSIT R5 80             	! Bit  7 set says disable complete memory tests. 3 				!  R5 contains the software boot control flags  H                                 !  plus the root directory # in <31:28>.J                                 !  Defaults to SYS0 or unrooted directory.8 EXAMINE  R5                     ! Display the boot flagsA FIND/MEM                        ! Find 64kb of working memory and 5                                 !  set cold start bit = IF NOT $STATUS THEN @EXIT       ! Boot if find was successful H EXAMINE SP                      ! Show address of working memory + %X200F LOAD/MAINMEMORY/START=@ ELNLDR.EXE ! Load ELNLDR into good mem + %X2008 START @                         ! Start executing ELNLDR                                                                                                                                                  ( * [SYSEXE.SEAS$WORK_0000005C]BDABOO8.COM;1 +  ,     . 	    /     4 P   	    h                  - 
    0   1    2   3      K  P   W   O     5   6  -  7 H  8          9          G    H  J                       
 SET VERIFY ! [8800]BDABOO.COM ! ? ! Command procedure to boot VAXELN from a BDA disk on an 8800.  G ! Can be invoked by DEFBOO.COM or can be invoked directly by using the   ! console command BOOT BDA.  ! G ! The following register deposits must be must be edited to correspond    ! to the hardware configuration: !  ! R1 - Bus address informationO ! R2 - [optional] Bits <31:24> specify controller letter (e.g., DUA, DUB, etc.)  ! R3 - Device unit number  ! 0 SET TERMINAL OPA0               ! Set up logging+ SET DEFAULT HEXADECIMAL, PHYSICAL, LONGWORD  ! L ! Uncomment the following line if you want to force the right cpu (cpu 0) to ! be the primary.  ! C !SET NEXT_PRIMARY RIGHT		! Make sure that right cpu is next primary J SET CPU NEXT_PRIMARY            ! Select CPU that will be the next primaryP IF NOT HALTED THEN HALT         ! Halt it and avoid unnecessary warning messages< WAIT                            ! Wait for processor to haltL SET CPU NEXT_SECONDARY          ! Select CPU that will be the next secondaryP IF NOT HALTED THEN HALT         ! Halt it and avoid unnecessary warning messages< WAIT                            ! Wait for processor to halt2 SET CPU BOTH                    ! Select both cpus4 EXAMINE/SDF 0CA                 ! Retrieve halt code6 DEPOSIT AP @                    ! Move halt code to AP) EXAMINE PC                      ! Halt PC 5 DEPOSIT R10 @                   ! Move Halt PC to R10 * EXAMINE PSL                     ! Halt PSL6 DEPOSIT R11 @                   ! Move Halt PSL to R11* INITIALIZE                      ! Init CPUF SET CPU CURRENT_PRIMARY         ! Select the primary to be booted nextO UNJAM                           ! Clear VAXBI errors, NMI and VAXBI node state   				!  info E DEPOSIT/L/P 3E000000 020F00F0   ! Clear interlock timeout in mem CSR0 C EXAMINE/L/P 3E000010            ! Read mem CSR4 (clears interrupts) B EXAMINE/L/P 3E000014            ! Read mem CSR5 (clears NMI fault)B DEPOSIT/L/P 3E000008 F0000000   ! Clear RDS error bits in mem CSR0* INITIALIZE                      ! Init CPUA DEPOSIT R0 21                   ! boot device type code - for BDA  ! < ! Modify this line for the VAXBI # and node # for your KDB50 ! B DEPOSIT R1 21                   ! BDA is on VAXBI 2, node number 1- DEPOSIT R2 0			! Unused for single controller  ! / ! Modify this line for the unit # of your drive  ! & DEPOSIT R3 0			! Unit # of drive (= 0)9 EXAMINE R3                      ! Display the unit number 7 DEPOSIT R4 0                    ! Clear unused register  ! G ! Change this line to DEPOSIT R5 84 to set the initial kernel debugger  C ! breakpoint. Change it to DEPOSIT R5 0 to enable full memory test.  ! K DEPOSIT R5 80             	! Bit  7 set says disable complete memory tests. 3 				!  R5 contains the software boot control flags  H                                 !  plus the root directory # in <31:28>.I                                 ! Defaults to SYS0 or unrooted directory. 8 EXAMINE  R5                     ! Display the boot flagsA FIND/MEM                        ! Find 64kb of working memory and 5                                 !  set cold start bit = IF NOT $STATUS THEN @EXIT       ! Boot if find was successful H EXAMINE SP                      ! Show address of working memory + %X200F LOAD/MAINMEMORY/START=@ ELNLDR.EXE ! Load ELNLDR into good mem + %X2008 START @                         ! Start executing ELNLDR                                                                                                                                                                      ) * [SYSEXE.SEAS$WORK_0000005C]BDDRIVER.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6  m   7 `H  8          9          G    H  J                       0 D X     0205      (  h `                                              BDDRIVER                               VAXELN V4.2-00 `h  05-05                          
       ?         !         BDA_001"      !        
PASCALMSC_001"      !         
LIBCOMMON_001"      !         
MSCPCLASS_001      !         FILE_001      !        DAP_001   ^I  ԭ߭.  P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @   @       \   h                                                                     
                 @                                                                       BDA                                                            	PASCALMSC                                                      	LIBCOMMON                                                      	MSCPCLASS                                                      FILE                                                           DAP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ) * [SYSEXE.SEAS$WORK_0000005C]BDDRIVER.PAS;1 +  ,    .     /     4 M                           - 
    0   1    2   3      K  P   W   O     5   6  g:Q.  7 I  8          9          G    H  J                      # module bddriver [ident('V2.3-00')];   M {****************************************************************************  {*									    *- {*  Copyright (c) 1986, 1990     							    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software o                                                                                                                                                                                                                                                                                                                                                                                                                                           ; $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]BDDRIVER.PAS;1                                                                                      M                              #             n equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { Facility:  { 7 {	VAXELN Mass Storate Controller Protocol (MSCP) Driver  {  { Abstract:  { D { 	This module contains the calls to start the MSCP class driver on C {	a KDB50 controller.  This driver allows multiple accessing of the C {	controller and any attached drive units.  This driver is designed : {	to be used in conjunction with the VAXEL             N file service.  { 	 { Inputs:  { 7 {	Job parameter 1 is the device name of the controller. ; {	Job parameters 2 through n, where n is less than or equal = {	    to 9, are optional.  If present, they are a drive to be . {	    mounted and optionally the volume label. { 	 { Author:  {	Eric R Schott		June 16, 1986 {  {--}     include $mscpport; export ;   {  { Define the port routine  {}1 procedure bdauqssp_port$start of type port$start; 	 external;      {  { Define the MSCP class server {}0 procedure mscp_class$server of type class$start;	 external;      program driver;  begin +     bdauqssp_port$start(mscp_class$server);  end.   end;                                                                                                                                                                                                                                                                                                                                                                                          ) * [SYSEXE.SEAS$WORK_0000005C]BUDRIVER.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 ̏
  7 X(I  8          9          G    H  J                       0 D X     0205      (  
`                                              BUDRIVER                               VAXELN V4.2-00 &
 05-05                          
       ?         !         
BVPSSP_001"      !        
PASCALMSC_001"      !         
LIBCOMMON_001"      !         
MSCPCLASS_001      !         FILE_001      !        DAP_001   ^I  ԭ߭.  P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          @   @       \   h                                                                     
                 @                                                                       BVPSSP                                                         	PASCALMSC                                                      	LIBCOMMON                                                      	MSCPCLASS                                                      FILE                                                           DAP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          ) * [SYSEXE.SEAS$WORK_0000005C]BUDRIVER.PAS;1 +  ,    .     /     4 M                           - 
    0   1    2   3      K  P   W   O     5   6 ~Q.  7 CI  8          9          G    H  J          
            # module budriver [ident('V2.3-00')];   M {****************************************************************************  {*									    *- {*  Copyright (c) 1986, 1990     							    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { Facility:  { 7 {	VAXELN Mass Storate Controller Protocol (MSCP) Driver  {  { Abstract:  { D { 	This module contains the calls to start the MSCP class driver on A {	a BVP controller.  This driver allows multiple accessing of the C {	controller and any attached drive units.  This driver is designed : {	to be used in conjunction with the VAXELN file service.  { 	 { Inputs:  { 7 {	Job parameter 1 is the device name of the controller. ; {	Job parameters 2 through n, where n is less than or equal = {	    to 9, are optional.  If present, they are a drive to be . {	    mounted and optionally the volume label. { 	 { Author:  {	Eric R Schott		April 1, 1986 {  {--}     include $mscpport; export ;   {  { Define the port routine  {}/ procedure bvpssp_port$start of type port$start; 	 external;      {  { Define the MSCP class server {}0 procedure mscp_class$server of type class$start;	 external;      program driver;  begin )     bvpssp_port$start(mscp_class$server);  end.   end;                                                                                                                                                                                                                                                                                                                                                                                                ' * [SYSEXE.SEAS$WORK_0000005C]BVPSSP.EXE;1 +  ,    .     /     4                            - 
    0   1    2   3      K  P   W   O     5   6 `
  7 @TbI  8          9          G    H  J                         0 D X     0205      (                8                                BVPSSP                                 VAXELN V4.2-00  H
 05-05                       
                  
        
    "      !        
PASCALMSC_001"      !         
LIBCOMMON_001  15                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            Space for rent X3.0ELN 0000 00:00:04.000000 00:00:01.004^<<~  PW, n <gWVI  I(KS2Sޭi
Ss
~ߦߦf ߦߦ<!~S߭ 
P   ߦ   P߭t  }Pƍ0   ж<RRA  D 	.  	(	ᰭS2Sޭ᭫ ߭߭ߦ   ݏ }0   TxTSЦRTC  D9 X  T ߦ5 X  ЦR|p ЦRx  WƁ0ƾ0jRW R߭   ϟԭ_ԭtԭԭԭxp                                                                                                                                                                                                                                                                                                                                                                                                  !                         $      ELN042.B                         
  '[SYSEXE.SEAS$WORK_0000005C]BVPSSP.EXE;1                                                                                                                      t             | pt hl;`dX\PT϶@DRR@PX`hpx߭߭߭߭߭WмRb ^QR޼nТSy0ԢZR  n44֢Ѣ
8R  ;Rt   ^ЬЬ޼޼n}ԭЭV}ƅ0(ƙ0Ʃ0{0 y0ݭݭXP]QOƲ0ƪ0ƶ0nƺ0ݦ5 @  ЦR| ЦR(UЦRX(RRRRŏ  USЦRC0   PUTŏ  TSЦRC0  PTƮ0Ʃ0|~ݭZݦ5|~  Ʃ0WWW]Qπ {0ЭR4P^޼SУnò0Á0ò0Á0Á0TTRRSjTRÁ0P^޼RТPXx }0|~  ТP ߭p   PЭPРQŏ  QP@y@yQP^޼S޼T T{0 Ty0xTRУPB p ^  PУRXx 
}0  ^޼V޼XXݦ|~  ЦRТ*Э(ЦRТ,ЦRТ0ЦRЭRR *RR4H9 @  X{0 Xy0 4Ʃ0WW
XVϊ
Xݦ  WP^޼R޼SC90߭  ЭnC9 @  խpXݢ|~  ТPР*Э(ТPР,ТPР0ТPЭPP *PP4Xݢ  nP|^޼R޼UЬV޼TxUQТPA P|`|ТPA S 	VPP 	cXݢ|~  0PPPP00nXݢ  nЮ߭ h ЭQǏ   VPxPPXPdUxUQТPA"¶0^޼T޼nxnSФRC R|b|^޼RXݢ|~  ТPР*Э(ТPР,ТPР0ТPЭPP *PP4 4©0SSXݢ  SP^޼R޼y0nnP^޼R޼޼nny0^޼VXݦ|~  Xݦ  ݦ|~  Xݦ|~  ЦR !3RT4{0y0Ɓ0SRRy0
B9  SRĀ! 'Ц#RB9  1tЦRТ*Э(ЦRТ,ЦRТ0ЦRЭRRЦR ߭ Q  PЭWRWRRZZ1<RRƲ0ƪ0ѧƺ0Ʃ0
 P         l1SƩ0 "RRƲ0Ʃ0Чƶ01/Ʃ0ݦ5  1Ʃ0%Ʃ0Чƶ0ݦ5   Vk1 Ʃ0ݦ5  1  VJƩ0ݦ5  1 	 V,1 1 "X YX1 X{01 YWƾ0b	
S0Lŏ  <R(iB0<SЭR<C0<R R<0ƾ0RB9  0 ŏ  XR(iByH9   ЭSЦRc t
  PЦRX(RRRRZ11HPЬQ ޼SÀ!PЬQ  QR֢ТPР\ЬР\Т̬Т\Ь\Т̬|~ ѢϬR
  NR
  ^Ь޼WԭXz߭
  }PЭR ݢ|~  ЭVԭЦRТ
ƍ0|~ ֭ѭ
]Q ЏUЦRТ
ƍ0|~ ЦRТSUSURSURRT
RSURRTSUTԩЦRТЦRТ]Q ϛ]Q ωЭSУRТ*Эԣ(УRТ,УRТ0УRЭԢRR RR  r  r + + bhݦ  ƍ0|~ O   ЭRЭЭ舏ТRbЭb]Q ƍ0|~ ]Q  RR1cЭV, n  ЦS|c|||| ЦR (ЦR,048ЦR <@П DП HЏ   L|PRR \ 	fRRR\߭ݦ  <RR^`È Ê Ì Ð ä   ЦR| ЦR|ЦR, n   ЭRW#ЭR'ЭSG9 @   ОTT_  Ǐ   PRR SRЭЭТRbЭb]Q fЭRG90߭  խ]Q AЭSУRТ*Эԣ(УRТ,УRТ0УRЭԢRRR
]Q  RR]Q ЭRG9 @     ЭЭТRbЭb]Q ϞЭRG90߭  խ]Q yЭRG9 @  RSУRТ*Эԣ(УRТ,УRТ0УRЭԢRRR
]Q   RR]Q XЭR ݢ  ЭR'XP^޼W޼X޼YЧR ߭   PխЧRX(RRRRЭV, n fVRXYǮ0Ƕ0Ǻ0ǲ0Y 
   N  e   p   1 ЭVBǮ0Ǫ0Ǯ0RRǮ0 "(Ǚ0$( 41 ЭR " "1 ЭR1 ЭSǮ0Ǫ0Ǯ0RRǮ0oЭSǮ0Ǫ0Ǯ0RRǮ0QЧS< Rя  RЭR 
ЭRЭVŏ  XR(By Ǯ0Ǫ0Ǯ0RRǮ0쟷  P'   ЭЧRbЭb^޼R޼nn¾00|<м<ޯPR P߭   ޼R¾0P@9 @  ¾0P@9|~  ¾0P@9 @   
b   <Qŏ  QP@0PA0P<<P P< b  00 b  1J 1D                                                                                                                                                                                                                                                                                  | ЬVޟH UeUPѥVPR{ IB:
 Q~ݡݡ00Џ   0xPȏ   (Ў0Ўڎݏ|   8 ~0xPQQ_   ڎ ЬTޟH ScSѣTRB
 RԼR ЬTޟH ScSѣTT<D < ЬQ	QSQ	П PA^nPQߠ`h ЎQՎЎPQРP<2
 RxRR    RB8PРXPˏ  C`Px	PPQ 	P   P]\P  PԼ_^	PԼ                                                                                                                @  @       `   l                                                H   h   p                 
                 @                                                                       	PASCALMSC                                                      	LIBCOMMON                                                                                                                                                                                                                                                  =     BVPSSPVAXELN V4.2-0010-OCT-1990 23:1110-OCT-1990 23:11   VAX-11 Linker V05-05        	.$$ABS$$.         BVPSSP_PORT$START                                                                                                                                                                                                                                                                                                                                                                                              ( * [SYSEXE.SEAS$WORK_0000005C]CONSOLE.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 l  7  RI  8          9          G    H  J                        0 D X     0205      (  `     &      (                                  CONSOLE                                VAXELN V4.2-00 { 05-05                                     
       ?         !        DAP_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001"      !         
TERMCLASS_001      
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Console driver exception $ACCESS_CONSOLEϞX^|$"  m\(٭^X < ~"  ̠  0 b!  bڱ(dܰR-R  ̭(̭έKڭ(ڭܭΚ
 RR1 
 R0R\\9\
 R0RVV9VYYZZ[<YXXX^nX(̭hVW<ZVV^nV(YhfW<[XX^(Zfn\RRǰ[VVV(VnΣVRRRVR(RcS2Sޭέ ̠ ̜߭         SVV  V(V̾ V RRRVR̼ (ROc̼ S2S̾   ̸߭    v ߬r   ̴  ̰    ̶  


0
b)   bd d(d
-
  ϽO5RR 
6RR
3RR
4RR
RSRSS
9RR
{ RRR RRUUUWW !П RR쟭 ` V2VTTޭܭϯS~̌ ߬||~ ̄ <~SW߭ 
P  USSTޭܭϵR ̈ |~|~̀ *RS߭ 
P  
~
~
~܄   ~  PV f    l X   ߭ X  ~x  PU e                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     "                        ( $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.EXE;1                                                                                                                     2                   l @  τRݭUl R߭   l|~  l   ̀ R)V ߬x  Ԭ@ڬ  ( ߭   ݭ x e f̠ ̌  ̐   ̐ 
 " j  1

~߬x܄ (1 ~O  PS c   |~ c̠    RS R̔    1 ЬxT 1 |~߬x܄   ̄ SУR
&  
~߬xcϟ |~߬x܄   Z~  P̘  ܘ    |~ ܘ     sRݭ̘  R̔    ݭ϶ЬxR 1 1  ݢ"߭ 1^W޼n[޼X޼ZШR
& *ШS
&RR 
 
&УԣУԣ2ڧ|ШS
&RR 
 
&УԣУԣ [ 
 1jR @ݢ< @  8-jR @%8ݢ<   DݢcD	Ը 
Rʏ@   RR 
1 [ШSШSSRխ1 Yխ1 TYЭSC%VSUYT3T0Ub+xUQQ&PPQQ&PP
TE%VUT{V~hj  QPTTQTjS QTQQDڧ|bSUS0USbTST$SQA&A%xQSSPP&PPS&TQb UU׭1-@jRRSn7 2 `, @ 8Dݣ
ݣ;jR 3|~jh  ШR
& n~jhϔ|~jh    
[1|^CSUVX|~  PPVUX1  1P TT %T;  X1   1   , 1 T
  X1   1  X
  УxR P ߣxӄ    ЏSFEÄ PРQ
&Pʏ   PP
&ݢ"߭ Tr  X
  TQ  U1^޼S"RR )	cTT  (PЬQ @ڭ"(cDRR#c^WXvݧr|~  ZЬY޼[Y YR RRXЧxR 8ݢ<|~  ǀ VXR,RJ  Xf"RRǀ R(@ڭ"ǀ RRR# ǈ |~߭ ׀ Z׀ Y1rXvݧr  P  \\,!\\\\ \\!\\횡\\"\\^޼Rb(b]Q 
#2WWV]Q FRR#WV]Q m
#^޼SU!RRУQa1  cxRRRj eRR,УP
&RRR
&УP
&RRR
&*УP
&RRR
&УP
&RRR
&U1 ' " `УP
&Rȏ   RR
&UУR$1mV 1QP`RVB%``1N
&Rȏ   RR
&U13W 1 VTTa c,
&RRR
&УP
&RRR
&U1QP`RVB%``1
&Rȏ   RR
&U1Ta c,
&RRR
&УP
&RRR
&U1QP`RVB%``1u
&Rȏ   RR
&U1ZQP`RVB%``1D
&Rȏ   RR
&U1)VRRbcQP
&Rȏ@   RR
&x`RRR&ՠ`֠UУP`RVB%``
&Rȏ   RR
&UWVTT1  c0УP
&RRR
&УP
&RRR
&U1~W1xУP
&Rȏ@   RR
&x`RRR&ՠ`֠UУP`RVB%``1,
&Rȏ   RR
&U1T1  c0УP
&RRR
&УP
&RRR
&U1 W1 УP
&Rȏ@   RR
&x`RRR&ՠ`֠UУP`RVB%``1 
&Rȏ   RR
&UiWfT 5УPx`RRR&ՠ`֠
&Rȏ@   RR
&UУP`RVB%``
&Rȏ   RR
&UUPЬQ ^޼S@ڭ  (PЬQ @ڭ"(^(ϓ ޼Wg 	  	(	 	  	(	ϸVFRb 	t  	(	ϋV    "E   PQR)ТSc   S&     P|,^|  mSЬ޼V < ~  ޯ]~  PUe|~  |~߭߭߭߭@ ѭ1 ЭTT   ݭ   1 ЭRϢ" 1 > K x x x x x x x x x x V i V
R߭ O
߭BVTR
5TR*Uӄ ݣx߭ϵUݣx߭ЏS|~ܘ~ݭ߭` 1ݭ   ѭ||  1ѭ||  1 eУxn߭   ݭݮ  U  ߭     ݭo  P^W޼X<~߭߭߭p  ЭYY1 ЭV( hfݼ   ЭXǴ ǰ |~  ЭS 	Ƕ 
ׄ  RRRR	RRRR
RRRRRXǴ 
ǰ   ЭRЏSY|  Y|  	Y|  ЏSЭ<RЏSTмPРQQ	ЏST5UUPPQ#ЏSTPQЏSTЏSTTS1 X´ ° |~  мQ҄ ¶  	 P	
PP PU PX´ 
°   ЏSTмPTQRSc   S     PTRммм<ռ
Ѽ   < RмԼԼ <`$RѢ& 
RR 
S
RRSSS
RR
RRЏ PQRЬPРvR$  P8^|  mQVW޼Ьnޯ]Ѯ+n'ݮׄ ݧx  P[1 TѤ& 
RR 
S
RRSSS
RR
RRwԭ ߭߭ݤݧxׄ 	  P[[zѦYЭYY Y}P`PѦ ЦSSXмRHSXZмZR(RjY
Џ ' 씭Џ Џ ! |ЭP^QRIS޼޼nϣԭ ߭ݢݮݮݣx
  Џ P^QSR 
 PѠ[ԭ߭ r
  Џ P Θ^|&
  mЬ < ~!
  ] ]]8Ͱ]ʹm͠]ͤ|~|~|~͠|~ Ͱ|~|~	  Pn   	  P$^(T޼޼޼nZ߭   ݭ x ݮ߭ nݮ ߭߭ ݮ ߭߭ ݮ @  VWSSWV1 X|~  SR    Ѣ 5Ѣ +P UUSPeSZVX
  V1iЭ[1 [1 YX|~  QPQPY1 P UUY hPРQaQXPQP*QP РWåV ٥WSyRRWSVRǐXXRPeRСQPea
P	U  X
  Y1%X|~  SRSRnnSR} X
  Z1Zݾ߭ 1RX|~  мPԼX
  ^yR޼}S޼޼n߼QyPPTQ$SP    S  T }S ~  PSЮ} X|~  QPcQn  SX
  ^X޼W޼޼nЏS   RѮRЏSԧ SyRRѧ$Sѧ RЏSԧѭS1߭   ݭ x ШxSX*ݣ&|~  ШxRЏSFԧHէ1ШxVȄ R` էЧԦJЧЧJЧԦJԦ- (  (
E( (N f ߨx؄    f7SyRRѧ$Sѧ RЏSFEn  ݦ Tݶ߭ ݦ"|~  /*SyRRѧ$Sѧ Rզ 
 FЏSFЦШxRТFШxSX*ݣ&  ݭ x Э<^T޼R޼nЏSU   PnP
ЏSUԢߤx  US)ТQ#ФxSQ QݣP
ЏSUԢUߤx  QRЬPРТPP|  P|  	P|  ЏSR\  P ^|M  m޼n޼UЏSޯ] eݏS 8 мR- ,  ,1 J~  PX~  PV~  PT d X  ~  PW߭   Эg  RUTVݼXWݮ R߭   d|~   ffX}  eWo  d   T[  |мRЭQRЬPРТPP|  P|  	P|  ЏSUR  P^|  m޼n޼RЏSޯ] b߭   ݭݮ  b|мPЭ                                                                                                                                                                                                                                                                                                                                                        @   @                                                                  H   P   h   `   p               x   `   @   P   H   (       p                     $   
                 @                                                                       DAP                                                            	LIBCOMMON                                                      	PASCALMSC                                                      	TERMCLASS                                                    ( * [SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1 +  ,    .     /     4 n                           - 
    0   1    2   3      K  P   W   O     5   6 lQ.  7 ֝I  8          9          G    H  J                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          #                        !# $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                                           " module console [ident('V4.1-00')]; { M {****************************************************************************  {*									    *) {*  COPYRIGHT (C) 1984, 1990   					    * < {*  BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.			    * {* 									    * M {*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  * M {*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  * M {*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  * M {*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  * M {*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *  {*  TRANSFERRED.							    * {* 									    * M {*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  * M {*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *  {*  CORPORATION.							    * {* 									    * M {*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  * B {*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		    * {*									    *M {****************************************************************************  {++  { FACILITY:  {  {	VAXELN {  { ABSTRACT:  { 5 {	This module contains a VAX console terminal driver.  { 	 { AUTHOR:  { 6 {		Len Kawell, Darryl Havens, Kris Barker  24-May-1982 {  { / { NOTE 1:  Explanation of V3.2-00 debugging aid A {	Code has been added to the console driver to make it easier to  5 {	to debug, without having to change the source code. < {	What follows is a sample .DAT file for EBUILD which shows @ {	how one could debug the console driver using the new debugging	 {	scheme:  {	n { characteristic /remote_cli /noconsole /noserver /objects=1024 /ports=512 /loader=512 /p0_virtual_size=2048 -& { /p1_virtual_size=1024 /io_region=256d { program CONSOLE /initialize /debug /kernel_stack=8 /mode=kernel /job_priority=2 /argument=("FRED")3 { program ELN$:JOBCNTRL.EXE /argument=("", "SFRED") 9 { device XQA /register=%O774440 /vector=%O120 /priority=4 & { device FRED /vector=%XF8 /noautoload { J {       Note that you have to include the console driver as a PROGRAM withB {	/DEBUG in order to debug it.  Also, the program argument must beE {	something other than CONSOLE ("FRED" in the above example) and this @ {	other name must match the name of the device described in the E {	EBUILD device menu for the console.  The device must be /noautoload B {	so that the CONSOLE program specified will be picked up for the  {	device driver.E {	The program ELN$:JOBCNTRL.EXE is not necessary, but if included, it - {	allows ECL to start running on the console.  {  { MODIFIED:  { " {	V1.0-01	Kris Barker	25-July-1984@ {		Modified transmit logic to output characters from with ISR to. {		eliminate context switch on every character { ! {	V2.0-00 Gary Kimura	26-Nov-1984  {		Added calls to stack utility  { ! {	V2.0-01 Kris Barker	19-Dec-1984 = {		Added check of xmt_waiting flag to output ISR so device is % {		not signalled if no one is waiting  { ! {	V2.0-02 Kris Barker	19-Feb-1985 > {		Added code to delete the console device should an exception; {		occur.  Modified the exception handler output routine to 2 {		output by polling rather than interrupt driven. { 9 {	V2.1-01 Kris Barker/Eric R Schott 3-July-1985  (ers006) # {		Fixed software xon/xoff handling  { 0 {	V2.1-02 Eric R Schott	15-August-1985		(ers009)/ {		Added handling of VFC record format on input  { 0 {	V2.1-03 Eric R Schott	15-August-1985		(ers010)3 {		Fixed open_routine to set maximum_record_size to 1 {		max_read_buffer_size if maximum_record_size is % {		greater than max_read_buffer_size.  { 1 {	V2.1-04 Eric R Schott	6-September-1985	(ers029) 4 {		Removed rewind_routine and added truncate_routine2 {		(to be compatible with other terminal drivers). { 6 {	V2.2-00 - November 18, 1985 - Eric R Schott	(ers060)3 {		Added checks for dead await_control_key circuits  { 6 {	V2.2-01 - November 21, 1985 - Eric R Schott	(ers065)5 {		Modified transmit interrupt control to work across  {		most processors.  { @ {	V2.3-00 - June 3, 1986 - Eric R Schott, Scott H Davis (ers097) {		Updated to support ACP. { " {	V2.3-01 - March, 1987 - B. Ziker {		Replace sea$ with topd$ { & {	V3.0-00 - August , 1987 _ A. Kessler2 {		Console name string includes BI number and node {		for ASMP environment. { ) {	V3.1-00 - January 4, 1988 - S. Ducharme ) {		Modified for performance enhancements.  { * {	V3.1-01 - January 21, 1988 - S. Ducharme4 {		If the line is in PASSALL mode do not signal data {		overrun errors.* {	V3.1-02 - February 1, 1988 - S. Ducharme= {		Correct problem where the driver would enter a dead locked 9 {		state if the input buffer overflows while a read is in  {		progress. { % {	V3.2-00 - June 10, 1988 - J. McGray 1 {		Added DDA support for the following functions: ) {		  dda$_fnc_get_char, dda$_fnc_set_char  { 3 {		Added code to ease debugging - see NOTE 1 above.  { " {	V3.2-01 - July 5, 1988 - R. Pfau= {		Tie console driver to primary cpu. Needed for smp systems  A {		where interrupts come in on all cpus and we don't tie drivers   {		in create_device. { % {	V3.2-02 - July 12, 1988 - J. McGray  {		Set eightbit through DDA. { % {	V3.2-03 - July 12, 1988 - J. McGray ) {		Take eight_bit checking out of the ISR  { % {	V3.2-04 - July 13, 1988 - J. McGray $ {		Change Parity_type to enumerated. { % {	V3.2-05 - July 25, 1988 - J. McGray 7 {		Fixed bug in get_action that caused cntrl characters  {		to not work correctly.  { # {	V3.2-06 - July 29, 1988 - R. Pfau @ {		Don't use ** to convert primary cpu # to eligibility mask, so( {		we don't bring in the DMATH routines. { ' {	V3.3-00 January 18, 1989 - J. McGray	 3 {		- Added DDA support for the following functions: : {		  dda$_fnc_read (min/max reads, timeout, and reads with: {		  a terminating mask of characters) and dda$_fnc_write.2 {		- Change priority of main process to 6, from 7. { ' {	V4.0-00 January 25, 1989 - J. McGray	 3 {		- Added support for line PASSTHRU characteristic / {		  and the READ_PASSTHRU read characteristic. ? {	    ****************************** 
     
       *************************** ? {	    *** All user-written drivers MUST use the new definition  : {	    *** of terminal_flags for the call to TC$READ_CHARS.? {	    ********************************************************* 6 {		  Line PASSTHRU is now in the line parameter record# {		  that is passed in from EBUILD. / {		- Changed console_flags to console_line_char 4 {		  and renamed console_data to console_struc to be8 {		  more consistent with other VAXELN terminal drivers. { < {	       - Changed handling of isr events to fix the problem5 {		 where an event could potentially get lost, due to 6 {		 multiple event(s) occurring before the main driver {		 process could unblock.@ {	    **********************************************************; {	    ***	 ALL user_written drivers must use the method of  9 {	    ***  processing isr events.  Note that EVENT is now ? {	    ***  defined differently in the TERMINAL_READ_DATA record ; {	    ***  and that CNTRL_CHAR and CNTRL_CHAR_POS no longer 2 {	    ***  exist in the TERMINAL_READ_DATA record.@ {	    ********************************************************** { $ {	V4.0-01 March 2, 1989 - J. McGray	3 {		- Added out-of-band signalling functionality for * {		  the following user-callable routines:" {			ELN$TTY_SIGNAL_OOB_CHARACTERS " {			ELN$TTY_CANCEL_OOB_CHARACTERS ! {			ELN$TTY_RECEIVE_OOB_CHARACTER 1 {	 	- Renamed EVENT (in line_Ctx) to EVENT_FLAGS.  { " {	V4.0-02 May 2, 1989 - J. McGray	5 {		- Check for overflow error status in dda$tty_Read. 9 {		- Don't allow DDA read timeout value to be an absolute 
 {		  time. { # {	V4.1-00 July 6, 1989 - J. McGray	 7 {		- Take out the check for get_ctrl_key requests whose 8 {		  circuits to the application have been disconnected.> {		  It is no longer needed becuase the circuit process which : {		  is waiting for the control key to be typed now does a9 {		  WAIT_ANY on the circuit process object, rather than  @ {		  suspend itself, so that it will detect a disconnect itself.; {		  This eliminates the 20 second timer in the main driver  {		  process.	 {	******* NOTE ******** 5 {		All user-written drivers MUST take out the call to 7 {		TC$CLEANUP_CTRL_KEY, because it tries to do a RESUME 3 {		of the process that calls TC$AWAIT_CTRL_KEY, and 7 {		that code has been modified in TERMCLASS.PAS so that   {		it no longer suspends itself.2 {		User-written drivers should simply take out the1 {		timer from the main process wait_any call, and 6 {		therefore take out the call to TC$CLEANUP_CTRL_KEY.B {	    - Modify dda$tty_read and dda$tty_wr                                                                                                                                                                                                                                   $                         $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                              a "            ite to return number of ' {	      bytes transferred = 0 if error.  {--}    : include $dap, $termclass, $stack_utility, $mutex, $kernel; include $dda_utility;  include $kernelmsg;  include $elnmsg;* %include 'topd$:[kernel.src]kerneldef.pas'   const '     driver_class 		= dda$_class_tty;    $     device_type 		= dda$_type_con;    / { Console terminal processor register numbers }   3 	rxcs_number	= 32;			{ Receive control and status } , 	rxdb_number	= 33;			{ Receive data buffer }4 	txcs_number	= 34;			{ Transmit control and status }- 	txdb_number	= 35;			{ Transmit data buffer }   : 	max_read_buffer_size	= 512;		{ Maximum read buffer size }9 	input_buffer_size	= 32;		{ Input interrupt buffer size } 6 	xmt_buffer_length       = 32;		{ Size of xmt buffer }  
 	oddp = 0;
 	even = 1;  % 	ipl$_power = 31;			{ Powerfail IPL }    	carriage_return = 13; 	line_feed       = 10; 	control_s	= 19; 	control_q	= 17;  6 	handle_xon_xoff = true;		{ Handle XON/OFF in driver }  $ 	{ Default Console characteristics } 	default$hardcopy	= true;  	default$ANSI_escape	= true; 	default$echo		= true; 	default$passall		= false;! 	default$eightbit        = false;  	default$passthru	= false;   type       { timing queue records }     queue_record = record  	entryq      	: queue_entry;; 	line	   	: integer;	   {line number - always 0 in console} > 	time_at_timeout : large_integer;   {absolute time at timeout}= 	evnt		: timeout_event;   {type of timeout we are requesting} C 	ignore_timeout  : boolean;  {true if there is not longer a  need }[A     end; { record }		    { for this timer. ie ignore the timeout}*       line_timer_state = record ? 	io_tmo_started	       : ^queue_record; {latest io timer entry}* 	{ Could add other timeouts }I     end; { record }			       timeout_event = (* 		{S/ 		{	The following events are used to signal the 5 		{	main process (controlling process) for a timeout.H 		{} 		evnt$noevnt,			{no event}H 		evnt$io_tmo			{I/O timeout}A 		{C 		{ Could add other timeouts 		{} 		);   byte = 0..255; word = 0..65535; word1 = [word] 0..65535;  ) { Console terminal register definitions }  	 D 	rxcs_register = [long] packed record { Receive control and status }- 		ie: 	[pos(6)] boolean;	{ Interrupt enable }N# 		done: 	[pos(7)] boolean;	{ Done }  		end;  = 	rxdb_register = [long] packed record { Receive data buffer }A* 		ch: 	0..255;			{ 8-bit ASCII character } 		end;  E 	txcs_register = [long] packed record { Transmit control and status } - 		ie: 	[pos(6)] boolean;	{ Interrupt enable }O# 		rdy: 	[pos(7)] boolean;	{ Ready }L 		end;  : 	input_region_def = record		{ Input communication region } 	line_ctx : terminal_read_data;* 		end;  < 	output_region_def = record		{ Output communication region }3 		index       : integer;		{  current output index }r3 		chars_out   : integer;		{  # of chars to output } " 		xmt_buffer  : 			{  xmt buffer }  		    string(xmt_buffer_length);( 		xmt_waiting : boolean;		{  wait flag }1 		write_enable : boolean;		{  write enable flag }  		end; 		 	port_ptr = ^port;  # 	{ Console line parameters record }.$ 	ln_param_rec = [byte] packed record  	    echo          : boolean;			'             passall       : boolean;				'             hardcopy      : boolean;			 '             ANSI_escape   : boolean;			r 	    eightbit      : boolean; '             passthru      : boolean;			r 	end; { record }  5 	{ Line configuration record sent by system builder }= 	builder_params = packed recordL= 		dummy_word        : word;    {length of the varying string}r 		line              : integer;,                 parity_enable     : boolean;/                 sense             : oddp..even;s,                 modem             : boolean;,                 hardcopy          : boolean;,                 ANSI_escape       : boolean;,                 echo              : boolean;,                 passall           : boolean;,                 ddcmp_protocol    : boolean; 		cli		  : boolean;a 		passthru	  : boolean; 3                 character_length  : [pos(64)] byte;	)                 stop_bits         : byte;.(                 comm_speed        : word     		end; { record }    	dda_line_struc = recordQ 	    dda_terminal_char_lock : mutex; {lock for accessing console characteristics}t 	    host_sync	: boolean;t	 	    end;	  # 	{ Circuit process data structure }a 	ct_data_base = record5 	    port             : port;       {connecting port} :             read_buffer_size : integer;    {record length}             end; { record }s 	ct_ptr = ^ct_data_base;   	event_record = packed record	" 	    local_event: isr_event_flags;H 	    local_nbr_cntrl_chars: integer;   { Number control chars received }E 	    local_cntrl_char_idx: integer;    { Index into typhd buffer of }r5 	end; {record}			      {  first cntrl char received.}/ 	c   vart: 	timer_queue	 : queue_entry;   {header of the timer queue}H 	timer_complete_q : queue_entry;   {queue of completed timeout requests}> 	request_queue	 : queue_entry;   {header of the request queue}8 	sync_lock	 : mutex;	  {access lock for timing elements}3 	my_timer	 : large_integer; {for get_time routines}m@ 	new_timeout 	 : large_integer; {absolute time of next timeout} % 	line_timer_struc : line_timer_state;r    	dda_port: port;				{ DDA port }5 	dda_port_name: varying_string(32);	{ DDA port name }e/ 	dda_process_name: name;			{ DDA process name },/ 	dda_struc : dda_line_struc;		{ DDA variables }o' 	console_job_port: port;			{ Job port }	  	job_name: name;				{ Job name }( 	circuit_port: ^port;			{ Circuit port }& 	process_id: process;			{ Process ID }8 	signalled_object: integer;		{ Signalled object number }  , 	input_device: device;			{ Input device ID }. 	output_device: device;			{ Output device ID }@ 	input_region: ^input_region_def;	{ Input communication region }C 	output_region: ^output_region_def;	{ Output communication region } ; 	interrupt_priority: integer;		{ Interrupt priority level }   7 	{ Renamed console_data to be like the other terminal }  	{ drivers (eg. dz_struc) }eC 	console_struc  : terminal_data_pointer;	{ Console data structure }r  & 	put_lock: mutex;			{ Put_chars lock }  ) 	{ Console characteristics and defaults }o  ) 	argument_string	  : varying_string(100);uA 	console_line_char :  ln_param_rec;  { Console line data base.. } ' 					    {  filled in from EBUILD and }A 					    {  updated by DDA }  2 	rxcs: rxcs_register;			{ RXCS register variable }   	cr : string(1) := ''(13); 	bell : string(1) := ''(7);  var3' 	ker$gb_cpu_type: [external,byte] byte;n' 	ker$gb_sys_type: [external,byte] byte;p' 	ker$gb_bi_number: [external,byte]byte;n* 	ker$gb_node_number:  [external,byte]byte;: 		{ flag , if set  indicates this is an ASMP environment }* 		{ and this is a secondary processor.			}% 	ker$gb_ptooey: [external,byte]byte; i9         ker$gl_primary_cpunum:			{ cpu # of primary cpu }1 		[external] integer;a         ker$gb_smp_flags:e) 		[external] smp_flags_def;	{ smp flags }a  B 	sync_event  : event;   {event used to synchronize initialization}   k program console;   {++0 { B { Main driver procedure.  Performs program initialization and thenA { waits for requests for service in the form of circuit requests. A { When a circuit is accepted, a process is created to service thef? { circuit.  This allows each circuit complete independence fromtB { other circuits (except where shared resource synchronization is ? { required).  In other words, the device appears as a sharable,. { full-duplex device.  {  {--} varc 	my_proc: process; 	acp: boolean; 	vector_num: integer; > 	bi_num : byte;{ 0-15 hex ,represented as an ascii character }? 	bi_node : byte;{ 0-15 hex, represented as an ascii character }l. 	console_def : varying_string(12):= 'CONSOLE';B 	console_dev : varying_string(12);  {Added for debugging purposes}   	read_started: ^semaphore; 	status: integer;*M         circuit_db   : ct_ptr;	        {pointer to circuit data base struct.} >         elig : job_eligibility_mask;    {job eligibility mask}E 	temp_elig_mask : packed array [0..15] of boolean; {Temp storage for  # 					converting cpu # to elig mask}r 	request_timer   : event;  -  	timeout_occurred: ^semaphore;   	sub_process	: process;r   begint  ) eln$allocate_stack(4096); { eight pages }t  / { Create a well-known name for the job's port } ? { Include the BI number and adapter number in the name string }*; { if this is a secondary processor in an ASMP environment }u   job_port(console_job_port);*  H { Use either the name given as argument 1 or 'CONSOLE' if no argument 1}F { Assume debug mode if program argument is not 'CONSOLE', and DO NOT }H {  establish the exception handler, so user doesn't ha                                                                                                                                                                                                                                                   %                        7bT $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                              t "     #       ve to modify the }# {  source code in order to debug. }*  % console_dev := program_argument( 1 );    if console_dev = '' then M	     begin-      	console_dev := console_def;'     	establish(console_driver_handler);a     endu else     console_def := console_dev;R     if odd(ker$gb_ptooey) then	     begin	! 	bi_node:= ker$gb_node_number+48;	 	if bi_node>57 theni 		bi_node :=bi_node+7; 	bi_num:=ker$gb_bi_number + 48;M 	if bi_num > 57 then 		bi_num := bi_num + 7; F 	console_def := console_def + '_' + bi_num::char + '_' + bi_node::char     end; { if ptooey } 	05 create_name(job_name, console_def, console_job_port);o   create_port (dda_port);s) dda_port_name := console_def + '$ACCESS';e   create_name (dda_process_name, 	     dda_port_name, 	     dda_port);	h   { $ { Create the Put_chars write lock. }   create_mutex(put_lock);W   with dda_struc dot	     beginj& 	create_mutex(dda_terminal_char_lock); 	host_sync := false;     end;  ) { Initialize pointers to timing records }o( line_timer_struc.io_tmo_started  := nil;  1 { Set the default console line characteristics: }v with console_line_char dot	     beginL 	echo        := default$echo;s  	passall     := default$passall;! 	hardcopy    := default$hardcopy; $ 	ANSI_escape := default$ANSI_escape;! 	eightbit    := default$eightbit;e! 	passthru    := default$passthru;      end;  * { Get the EBUILD console characteristics }* argument_string := program_argument ( 2 );   if argument_string <> '' thenC+     with argument_string::builder_params do$ 	begin+ 	    console_line_char.echo        := echo;r. 	    console_line_char.passall     := passall;6             console_line_char.hardcopy    := hardcopy;9             console_line_char.ANSI_escape := ANSI_escape;e; 	    console_line_char.eightbit    := character_length = 3;s7             console_line_char.passthru    := passthru; o 	end;   I { Connect interrupt service routines to the input and output interrupts }c  eM if ((ker$gb_cpu_type = pr$_sid_typ630) or (ker$gb_cpu_type = pr$_sid_typ620))b,     and (ker$gb_sys_type = pr$_sidex_typ800) then 	acp := true else 	acp := false;   if acp then 	vector_num := 2 else 	vector_num := 1;i  B {Make driver run on primary if a symmetric multiprocessing kernel}  % if ker$gb_smp_flags.ker$v_smp_kernel      then 
         begine? 	    temp_elig_mask := zero;	{Use temporary variable to converte 					 from cpu # to bitmask}3 	    temp_elig_mask[ker$gl_primary_cpunum] := true;o- 	    elig.as_a_word := temp_elig_mask::word1; - 	    ker$set_job_eligibility(,elig);         h 	end;	   create_device(	console_dev,= 		input_device,e 		vector_number := vector_num, 		region := input_region, ! 		priority := interrupt_priority,	% 		service_routine := input_interrupt,r" 		powerfail_routine := powerfail);   if acp then 	vector_num := 1 else 	vector_num := 2;n   create_device(	console_dev,  		output_device, 		vector_number := vector_num, 		region := output_region,' 		service_routine := output_interrupt);u     { ! { Initialize the typeahead buffere {}  3 tc$initialize_typhd_buffers(input_region^.line_ctx,  			    handle_xon_xoff,o! 			    console_line_char.passall,s" 			    console_line_char.eightbit,# 			    console_line_char.passthru);e {y$ { Create the read started semaphore. {}     new(read_started);*     create_semaphore(read_started^, 0, 1);   {s" { Create the synchronization event {}/     create_event ( sync_event, event$cleared );	   { $ { Create the request-for-timer event {}2     create_event ( request_timer, event$cleared );   {; { Create the timeout semaphore {}!     new(timeout_occurred); 						s2     create_semaphore(timeout_occurred^, 0, 1); 			   { Start the timing queues: }      start_queue ( timer_queue );%     start_queue ( timer_complete_q );N"     start_queue ( request_queue );  4 { Sync_lock controls access of the timing records: }     create_mutex ( sync_lock );5   { Create the timing process }	     clear_event ( sync_event );a!     create_process ( sub_process,s 		     timer_process,) 		     sync_event, 		     timeout_occurred, 		     request_timer);       { Wait for completion }      wait_any ( sync_event );     delete (sync_event );n  - { Create the data structure for the console }c  3 tc$allocate_terminal_data ( console_struc, 0, true,n 			 read_started,o" 			 output_region^.write_enable );    & { Enable input and output interrupts }  
 rxcs := zero;u rxcs.ie := true; mtpr(rxcs_number, rxcs);   initialization_done;   {iO { Bump up the process priority of the dispatcher - note: this assumes a defaulttH { process priority of 8 for the line and circuit processes and that the I { process priority of the line and circuit processes will not be below 7.  {}   current_process(my_proc);o. set_process_priority(my_proc,read_priority-1);    ? { Continually wait for input interrupts and connect requests. }u repeat 	begin  > 	{ Don't wake up every 20 seconds for get_control_key cleanup} 	wait_any(input_device,  		 console_job_port,   		 read_started^,  		 dda_port, 	         timeout_occurred^,		 		 result := signalled_object);      	case signalled_object of   ) 	1:	{ Process received input characters }  		beginn( 		process_event(	input_region^.line_ctx, 				console_struc, 				console_line_char.passall) 		end;    : 	2:	{ Accept a circuit and create a process to service it}   		begin #                 new ( circuit_db ); 1                 create_port ( circuit_db^.port );   2                 accept_circuit (console_job_port, >                                 connect := circuit_db^.port );  ,                 create_process ( process_id,0                                 circuit_process,-                                 circuit_db );r   		end;   	3:	{u 		{ Read posted:4 		{ 	A read has been started.  Check to see if there& 		{	are any characters in the buffers. 		{} 		begin  		    with console_struc^ do 			if read_started 			then 	 				begint  				tc$process_input_characters( 					input_region^.line_ctx, 					console_struc);= 				if input_region^.line_ctx.usr_ptr^.event_flags <> [] thenk
 					begin, 					{ The buffers must have been swapped. }- 					{ The USR events have to be processed. }h+ 					process_event(	input_region^.line_ctx,t 							console_struc,y" 							console_line_char.passall);! 					tc$process_input_characters(/ 						input_region^.line_ctx,u 						console_struc); 	 					end;u 				read_started := falseu 				end; 		end;  > 	4:	{ Accept a circuit and create a DDA process to service it}   		begin  		new(circuit_port); 		create_port(circuit_port^);c   		accept_circuit(	dda_port,e 				connect := circuit_port^);   		create_process(	process_id,  				dda_circuit_process, o 				circuit_port,l 				request_timer ); 		end;  5 	5:	{ Timeout was signalled from the timer process: }e   		begint, 		    process_timeout_event (request_timer); 		end; {case = 5}o   	end; {Case}   	{: 	{	Now that we have processed the line that needed service? 	{	check to see if any I/O has completed for the console line. t> 	{	An I/O completion is deferred until now so that all buffers8 	{	that need swapping are processed as fast as possible. 	{}r   	with console_struc^ do;% 	if io_done AND read_in_progress then 
 	    begin1 		Cancel_timer (line_timer_struc.io_tmo_started);f+ 		signal( read_complete, status := status);i 		io_done := false;f 		read_in_progress := false;	 	    end;r   	end; {repeat}   until false; end.    : procedure process_event(var line_data: terminal_read_data;' 			var terminal: terminal_data_pointer;c 			passall: boolean);l   {++o {e# { process_event - Process ISR eventt {c { Routine Description: {k; {	This procedure will process events signalled by the input_ {	ISR for each line. {(	 { Inputs:n {e' {	line_data   - Line typeahead buffers.n( {	terminal    - Internal line data base.D {	passall	    - True if input characters should be processed without {		       intrepretation.e { 
 { Outputs:9 {	line_data   - Line typeahead buffers possibly modified.g( {	terminal    - Internal line data base. {y {--}   {t {	Local variable declarations. {}   vare 	stat		    : boolean;g 	status		    : integer;,, 	i		    : integer;	{ General purpose index } 	control_char	    : char;	 	first_one	    : boolean;r 	next_element	    : integer; 	found_one 	    : boolean; 	disposition	    : byte;' 	remove_from_data    : boolean := true;]$ 	local_event_record  : event_record;! 	temp_ptr	    : typhd_buffer_ptr; ? 	done 	    	    : boolean := false;  { true if working on ISR }i: 			     { EVENTS and have finished processing USR EVENTS } 			     { if there were any. }   beginz   { 1 {	Determine what n       4                                                                                                                                                                                                                                          &                        f9 $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                              X      4       eeds to be done based on eventso {	signalled by the isr.    {}   While not(done) do beginc  : { Process any events left in the USR EVENTS array first. }, if line_data.usr_ptr^.event_flags <> [] then	     begine1 	{ Copy USR event information to local storage: }u. 	with local_event_record,line_data.USR_ptr^ do
 	    begin 		local_event := event_flags;} 		event_flags := []; 	;+ 		local_nbr_cntrl_chars := nbr_cntrl_chars;_ 		nbr_cntrl_chars := 0;p 	e) 		local_cntrl_char_idx := cntrl_char_idx;t 		cntrl_char_idx := 0; 	    end; {with}     end  else	     beginr4 	{ Process any events left in the ISR EVENTS array }1 	{ Copy ISR event information to local storage: }_' 	disable_interrupt(interrupt_priority); . 	with local_event_record,line_data.ISR_ptr^ do
 	    begin 		local_event := event_flags;g 		event_flags := [];  + 		local_nbr_cntrl_chars := nbr_cntrl_chars;  		nbr_cntrl_chars := 0;o  ) 		local_cntrl_char_idx := cntrl_char_idx;p 		cntrl_char_idx := 0; 	    end; {with} 	enable_interrupt; 	done := true;     end;     with local_event_record do beginl  ( { See if there is an event to process: } if local_event <> [] thent begins  *     if evnt$input_xoff IN local_event then 	if terminal^.xon_xoff 	then  		with terminal^ doy 			begin 			clear_event(write_enable);o 			write_ena_flag^ := false; 			end;h    )     if evnt$input_xon IN local_event then  	if terminal^.xon_xoff 	thenm 		with terminal^ don 			begin 			write_ena_flag^ := true;t 			signal( write_enable);r 			if overflow_pending theni	 				begin # 				stat := put_chars(line,1,bell);  				overflow_pending := false; 				end; 			end;e    +     if evnt$cncl_typahd IN local_event then  		begine) 		    { Clear the user typeahead buffer }a" 		    line_data.usr_ptr^.put := 0;1 		    { Clear a possible evnt$control_char event} 7 		    local_event := local_event - [evnt$control_char];7 		end;    ,     if evnt$control_char IN local_event then	     begin      if done then! 	{ We are processing ISR events }d 	temp_ptr := line_data.ISR_ptr     else! 	{ We are processing USR events }t 	temp_ptr := line_data.USR_ptr;        with temp_ptr^ dop%     if local_nbr_cntrl_chars > 0 then_	     begin=   	first_one := true;	{init}  7 	{ Use local_cntrl_char_idx as the index of the first }  	{ control character found: }e# 	while local_nbr_cntrl_chars > 0 dot
 	    begin  	    	found_one := false; {init}  @  	        { Use local_cntrl_char_idx as the index of the first }& 	        {  control character found: } 	        if first_one then 		    beginr6 	    	    	control_char := data[local_cntrl_char_idx];B 		    	next_element := local_cntrl_char_idx; {NEXT_ELEMENT is the}= 			    { element following the cntrl character just removed.}: 		    	first_one := false; 		    	found_one := true;p	 		    endi
 	        else$@ 		    { Search the EVENTS array for the next control character }? 	    	    while ( (not found_one) AND (next_element < put) ) doa 			begin3 			    if ((events[next_element].error = false) ANDm@ 			   	(events[next_element].event_type = et$control_char)) then 		 	    	begin+ 				    { Found the next control character}s 		    		    found_one := true;/ 			    	    control_char := data[next_element];_ 			        end 			    else_% 				next_element := next_element + 1;i 			end;h   	    	if found_one then , 	    	    { Process the control character: } 		    begin > 		    	{ Bump any process waiting for the control character. }2 		    	disposition := tc$check_oob_char( terminal, 						    line_data, 						    control_char);  ) 			{ Default to disposition = remove_it }h 			remove_from_data := true;   			if disposition = keep_ito 			then2 				remove_from_data := falseM' 			else if not(disposition = remove_it)m 			thens" 				if terminal^.read_in_progress  				then 					remove_from_data := false) 				else if disposition = keep_if_no_readr 				then 					remove_from_data := false;t   			If remove_from_data then[' 			    { Remove the character from the}i( 			    {  the typeahead buffer and the } 			    {  events array:  	  		    {} 	 				begin	 				    { *** Device IPL *** }. 				    disable_interrupt(interrupt_priority);& 				    if next_element < (put-1) then+ 				    for i := next_element to (put-2) do 
 					begin" 				    	    data[i] := data[i+1];& 				    	    events[i] := events[i+1];	 					end;v 				    put := put - 1;e 				    enable_interrupt;u) 				    next_element := next_element - 1;,   				    { *** Normal IPL *** } 				end; {if remove_from_data }) 		    end; {if found_one}e 	p# 		next_element := next_eleme      =       nt + 1;y0 		{ Decrement the count of control characters: }5 		local_nbr_cntrl_chars := local_nbr_cntrl_chars - 1;   + 	    end; {while local_nbr_cntrl_chars > 0}n'     end; {if local_nbr_cntrl_chars > 0} "     end; {if evnt$control_char IN}    /     if evnt$buffer_overflow IN local_event then;       with terminal^ doh 	begin/ 		{	If the terminal is not in passall mode thent 		{	output the bell character. 		{}B 		if not(passall OR line_data.passthru OR line_data.read_passthru) 		then 			{( 			{	If xon and xoff support (TTSYNC) is' 			{	required check to see if output iss 			{	disabled. 			{}e 			if terminal^.xon_xoff 			theng	 				begin  					if not(write_ena_flag^)	 					thenr 						overflow_pending := true	 					elseu% 						stat := put_chars(line,1,bell);o 				endc 			{+ 			{	If NO xon and xoff (TTSYNC) support isn( 			{	required just output the bell char. 			{}  			elsen# 				stat := put_chars(line,1,bell);s   	end; {with}    ,     if evnt$io_completed IN local_event then  3 	{ If this line has a read in progress then processa2 	{ the data.  Otherwise, a race condition ocurred. 	{}e 	if terminal^.read_in_progress 	thent
 	    begin2 		tc$process_input_characters(line_data,terminal);. 		if line_data.usr_ptr^.event_flags <> [] then 		    begin^2 			{ USR events were cleared at the beginning of }( 			{ this routine, so if after calling }4 			{ tc$process_input_characters here it is NOT [] }/ 			{ then the buffers must have been swapped. }t- 			{ The read was not completed yet because } 5 			{ first the new USR events have to be processed. }a4 		        process_event(line_data,terminal,passall);3 			tc$process_input_characters(line_data,terminal);y
 		    end;	 	    end;r       {_=     {	The CONSOLE driver does not recognize any other events.u     {}  	 end; {if}s  ' { Clear out the local event variable: }e local_event := []; end; {with}e   end; { while not() } end; e  9 procedure process_timeout_event	(request_timer : event );    {++  {i { process_timeout_event  {  { Routine Description: { ; {	This procedure will process all timeout events signalled.a {t {  {--} varn     stat	: boolean;p     status	: integer;	     i		: integer;	@     ptr 	: ^queue_entry;  { pointer to timer_complete_q entries}:     entry_ptr	: ^queue_record; { pointer to queue records}#     done_process_timeout : boolean;      empty	: boolean;4     lkahd_flag	: boolean := true; { lookahead flag }   begin_  "     done_process_timeout := false;  2     {Process each element of the timer_complete_q}%     while not done_process_timeout do  	begin		    G     	    lock_mutex (sync_lock);  {make sure no one accesses the queue} $ 	    ptr := timer_complete_q.flink; ? 	    if ptr = address(timer_complete_q) then  {no more entries}h 		begini* 	            done_process_timeout := true;&     	    	    unlock_mutex (sync_lock) 		end / 	    else    {there is at least one more entry}	 	        begin  3 	    	{Remove the entry from the head of the queue}n% 	    	remove_entry (timer_complete_q, & 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);   		{ See if it is still valid }# 		if entry_ptr^.ignore_timeout thenc 		    beginc 			dispose (entry_ptr);n" 	    		unlock_mutex (sync_lock);  	 		    end_ 	        else  	 		    beginn3 			{ Determine what needs to be done based on the }	  			{  timeout event signalled: } 			CASE entry_ptr^.evnt of   			EVNT$NOEVNT:D 			    begin) 	    			{ There is no event to process. }; 				dispose (entry_ptr);- 	    	    	        unlock_mutex (sync_lock)  n 			    end;t 	r 			EVNT$IO_TMO:p 			    begin 				{I/O timeout has expired},0 				{ Delete the pointer to the timing record: }+ 				line_timer_struc.io_tmo_started := nil;m&     	    			unlock_mutex (sync_lock);  				with console_struc^ do 				if read_in_progress then
 				    begin{& 					{ See if any characters came in }" 					{ during the timeout period }! 					tc$process_input_characters(c 						input_region^.line_ctx,e 						console_struc, 						lkahd_flag);3 					if not io_done then io_status :                                                                                                                                                                                                                                   '                        J $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                                    E       = eln$_timeout;p 					io_done := false; 					read_in_progress := false;N 					read_w_term_mask := false;g3 					input_region^.line_ctx.isr_ptr^.event_flags :=fK 					    input_region^.line_ctx.isr_ptr^.event_flags - [evnt$io_completed];i1 					signal(read_complete,status := status);					  				    end;6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;t   			OTHERWISE 			    begin 		            	{( 		            	{ Process other timeouts. 		            	{}S&     	    			unlock_mutex (sync_lock);  	    			dispose (entry_ptr);   		            end; 		        END; {case}a* 		    end; {if entry_ptr^.ignore_timeout }  0 	    end; { if ptr = address(timer_complete_q) }.         end; {while not done_process_timeout }   end;  {procedure}p   s? interrupt_service output_interrupt(console_registers: ^anytype;t* 				   output_region: ^output_region_def); {++ @ { Output_interrupt - interrupt service routine to handle output. {i	 { Inputs:a {n
 {	IPL = 20  {	Mode = kernel, interrupt stack { 
 { Outputs: { @ {	The next character in the xmt buffer is output.  If the buffer: {	has been emptied, the output device object is signalled. {--} vard 	txcs : txcs_register;   beginn  2 { Make sure the device is ready to accept output }   repeat) 	txcs :: integer := mfpr ( txcs_number );  until txcs.rdy;r    I { Output more characters or signal device if done or write enable clear }    with output_region^ do0 	if (not write_enable) or (index>chars_out) then 		begine 		if xmt_waiting then  			signal_device;n 		txcs.ie := false;	 		mtpr(txcs_number, txcs); 		xmt_waiting := false;e 		index := index - 1;v 		endf 	elsee 		beginT8 		mtpr ( txdb_number, ord(substr(xmt_buffer,index,1)) ); 		index := index + 1;p 		end; end;   t  - function put_chars of type output_characters;d {++ 0 { Put_chars - put characters to console terminal {--} var 2 	txcs: txcs_register;			{ TXCS register variable }% 	ignore: integer;			{ Ignore status }=' 	xmt_index: integer;			{ buffer index }_, 	num_chars: integer;			{ character counter }/ 	tomove:	   integer;			{ characters to output }y    7 [inline] function minimum ( a, b : integer ) : integer;o {t5 { This function returns the minimum of its two inputsp {} begin  if a <= b then
 	minimum := aa else 	minimum := b; end;     beginn  G { Note: this routine ignores kernel service failures so as to be able }c9 {	to output characters even when the system has failed. }r  O lock_mutex(put_lock);	{ Only allow one process at a time to execute this code }p   xmt_index := 1;  num_chars := number_of_chars;r  + { Output buffers of characters until done }t   repeat  0 	{ Determine maximum chars to output this pass }  4 	tomove := minimum ( num_chars, xmt_buffer_length );) 	tc$check_write_enable ( console_struc );	 	with output_region^ do) 		begini< 		xmt_buffer := substr ( output_buffer, xmt_index, tomove ); 		chars_out  := tomove;e 		index      := 2; 		end;   	{ Make sure device is ready }   	repeata( 		txcs::integer := mfpr ( txcs_number ); 	until txcs.rdy;  1 	{ Output first character to start transmission }b  " 	disable_interrupt ( ipl$_power );$ 	output_region^.xmt_waiting := true; 	txcs.ie := true;l 	mtpr(txcs_number, txcs); B 	mtpr ( txdb_number, ord(substr(output_region^.xmt_buffer,1,1)) ); 	enable_interrupt;    	{ Wait for output to complete }  . 	wait_any ( output_device, status := ignore );  - 	{ Update counters and continue if not done }I  / 	xmt_index := xmt_index + output_region^.index;{/ 	num_chars := num_chars - output_region^.index;n   until ( num_chars = 0 );   put_chars := true;, unlock_mutex(put_lock);	{ Release the lock }   end;   m7 procedure put_exception_line(str: varying_string(256));e {++ E { put_exception_line - output a line of text to the terminal from thex {		       exception handler. {a	 { Inputs:  {  {	str - string to output.s {0
 { Outputs: {n$ {	String output to console terminal. {--} var  	i: integer; 	status : boolean; 	txcs: txcs_register;  	rxcs: rxcs_register;e 	rxdb: rxdb_register;    procedure transmitter_ready; begin  repeat$ 	rxcs::integer := mfpr(rxcs_number); 	if rxcs.done then 		beginc% 		rxdb::integer := mfpr(rxdb_number);	 		if rxdb.ch = control_s thent	 			repeatr' 				rxcs::integer := mfpr(rxcs_number);s' 				rxdb::integer := mfpr(rxdb_number);i* 			until rxcs.done and (rxdb.ch=control_q) 		end;$ 	txcs::integer := mfpr(txcs_number); until txcs.rdy;f end;   beginn   transmitter_ready;" mtpr(txdb_number,carriage_return);   for i:=1 to length(str) do 	begin 	transmitter_ready;]( 	mtpr(txdb_number,ord(substr(str,i,1))); 	end;g   transmitter_ready; mtpr(txdb_number,line_feed);   end;     _> interrupt_service input_interrupt(console_registers: ^anytype;' 				  input_region: ^input_region_def);e {++:H { Input_interrupt - interrupt service routine to handle character input. {s	 { Inputs:o {h) {	input_region - interrupt region pointer  {c
 {	IPL = 20  {	Mode = kernel, interrupt stack {d
 { Outputs: {c4 {	Input character is added to the input ring buffer. { @ {	If input buffer changed from empty to non-empty, device object {	is signalled.  {--}   consti
 	xon = 17; 	xoff = 19;    type%     ASCII_char = [byte] packed records 			low7 : 0..127;n 			high : 0..1 		        end; { record }r   varp 	rxdb: rxdb_register;	 	character: char;=Q 	bump_device: boolean := false;	{used to determine if device should be signalled}    l   { " {	Main routine for input_interrupt {}   beginh  # rxdb::integer := mfpr(rxdb_number);y   {a {	Handle the input character.v {}   with input_region^.line_ctx do   	if isr_ptr^.put > length* 	then	 		beginl 		{e/ 		{ The input buffer is full.  If the charactern6 		{ is XON or XOFF and we are NOT in passall mode then7 		{ inform the dispatcher that a XON or XOFF was found.	0 		{ Otherwise, bump the dispatcher with a buffer 		{ overflow condition.  		{} 		if ( (tt_sync) and 	 		     ( (rxdb.ch = xon) ore 		       (rxdb.ch = xoff) ) andl 		     (not passall) )   	 	thenm 			begin 				if rxdb.ch = xon then 
 				    begineE 					isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xon];:F 					isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xoff]; 				    endn 				else
 				    begin F 					isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xoff];E 					isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xon];i 				    end; 			        bump_device := true
 		        endt 		else 			begin' 			{ If the line is NOT in PASSALL model" 			{ then signal a buffer overflow% 			{ condition. In any event remembero'       R       			{ that an overrun condition occured.i 			{}c! 		        if ( (not passall) AND e 			     (not passthru) AND o 			     (not read_passthru) )	 			then(	 				beginlX 		                isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$buffer_overflow]; 				bump_device := true{ 				end; 			isr_ptr^.overflow := true;t 			end 		endi 	elset 		beginh 		character := chr(rxdb.ch); 		if passall 		then% 			tc$insert(input_region^.line_ctx,   				character, 				bump_device) 		else 			tc$dispatch_character(e 				input_region^.line_ctx,  				character, 				bump_device);d 		end;   if bump_device then 	signal_device;e   end;  8 interrupt_service powerfail(console_registers: ^anytype;- 			    interrupt_region: ^output_region_def);  {++ 0 { powerfail - powerfail recovery service routine {i	 { Inputs:  {{
 {	IPL = 31  {	Mode = kernel, interrupt stack {c
 { Outputs: {c {	Interrupts are re-enabled. {--} varu2 	rxcs: rxcs_register;			{ RXCS register variable }2 	txcs: txcs_register;			{ TXCS register variable } begin    { Re-enable interrupts }   rxcs.ie := true; mtpr(rxcs_number, rxcs);    6 { If someone is waiting on output, signal the device }   with interrupt_region^ do  	if xmt_waiting then 		begine 		signal_device; 		txcs.ie := false;  		mtpr(txcs_number, txcs); 		xmt_waiting := false;b 		end;   end;   => procedure write_exception(var signal_args: chf$r_signal_args); {++c< {  write_exception - writes exception for exception handlers {s
 {  Inputs: { ! {	Exception signal argument list.	 {--} varu 	arg: integer; 	ignore: boolean;s   begina   put_exception_line('');t0 put_exception_line('Console driver exception ');/ put_exception_line(hex(signal_args.arg_count));t* put_exception_line(hex(signal_args.name));  : for arg := 1 to 20 do {** signal_args.arg_count - 1 do **}6 	put_exception_line(hex(signal_args.additional[arg]));   end;   r: function console_driver_handler of type exception_handler; {++a- {  console_driver_handler - Exception handlerc {l
 {  Inputs: {l                                                                                                                                                                                                                                   (                        N $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                               
     V       ) {	Standard exception condition arguments.  {--} varl 	dummy : integer;k   begin   G { Turn off device interrupts, display the error, and exit the process }    mtpr(rxcs_number,0); mtpr(txcs_number,0); console_driver_handler := true;  write_exception(signal_args);u exit;    end;   o9 process_block dda_circuit_process (dda_circuit: port_ptr;s# 				   request_timer     : event );    {++R {vE { DDA Circuit process : This process is started to service a DDA I/O p! { request for the specified line.q {e
 { Inputs :7 {	dda_circuit - circuit to be used in DDA communicationv {d { Outputs :	none {g {--}   vart7     dda_packet	     : ^dda$_packet;	{ dda message data}c     dda_message_obj  : message;_!     message_size     : integer;  	(     disconnect_status, status : integer;=     sgnl_oob_outstanding_ptr : ^boolean; { TRUE if there is }e0 			{ an outstanding request for oob signalling } 			{ on this circuit process. };     i? function dda_circuit_process_handler of type exception_handler;n {++ 2 {  dda_circuit_process_handler - Exception handler {t
 {  Inputs: {r) {	Standard exception condition arguments.g {--} begin	  % dda_circuit_process_handler := false;m write_exception(signal_args);c delete(dda_circuit^);o dispose(dda_circuit);a exit;   { Exit the process }   end;   S% { Main code for DDA_circuit_process }d beginh0     eln$allocate_stack ( 4096 ); { eight pages }+     establish(dda_circuit_process_handler);o  "     new(sgnl_oob_outstanding_ptr);'     sgnl_oob_outstanding_ptr^ := false;m       while true do: 	begin2 	{ Wait for a message to come in over the circuit} 	wait_any(dda_circuit^);   	receive  (  dda_message_obj,t 		    dda_packet,  		    dda_circuit^,t 		    size := message_size,t 		    status := status );a   	If status = ker$_success then
 	    begin  @ 	 	{Request message must be at least the size of the dda header}) 		If message_size < dda$_header_size then	 		    begin{ 			delete (dda_message_obj);0 	    	        goto dda$_circuit_process_return  
 		    end;  * 		CASE DDA_PACKET^.HEADER.DDA$_FUNCTION OF 	  	    	    DDA$_FNC_GET_CHAR: 			begin 		    	    dda$tty_get_char( 				dda_message_obj,   		    		dda_packet,m 				console_line_char); 6 		    	    {original message is DELETED by the driver}5 		    	    { and a new one is created and returned. }r 	        	end; 	t 	    	    DDA$_FNC_SET_CHAR: 	    		begin 		    	    dda$tty_set_char( 		    		dda_packet,i 				console_line_char); 7 		    	    {original message is RETURNED by the driver}a- 		      [           	    { with just the status modified. }  	    		end;r   		    DDA$_FNC_READ: 	    		begin 			    dda$tty_read( 		    		dda_packet,l 				message_size,t 				request_timer);  	    		end;    		    DDA$_FNC_WRITE:e 	    		begin 			    dda$tty_write(c 		    		dda_packet,( 				message_size); 	    		end;r  ! 	    	    DDA$_FNC_SGNL_OOB_CHAR:n 	    		begin 		    	    dda$tty_sgnl_oob( 		    		dda_packet,  				console_struc, 				input_region^.line_ctx,  				sgnl_oob_outstanding_ptr); 	    		end;a   		    DDA$_FNC_CNCL_OOB_CHAR:  	    		begin 		    	    dda$tty_cncl_oob( 		    		dda_packet,i 				console_struc, 				sgnl_oob_outstanding_ptr); 	    		end;u   	    	    OTHERWISE) 	    		begin7 			    dda_packet^.header.dda$_status := ELN$_INVALFUNCo 	    		end;_           	END; {CASE}  =         	send(dda_message_obj, dda_circuit^, status:=status);tA 		if not odd(status) then	 {Couldn't send the message, delete it}g 	    	    beginx 			delete(dda_message_obj); 1 			{ Check if the circuit has been disconnected }r# 			if status = ker$_disconnect thenr( 			    goto dda$_circuit_process_return;
 		    end;  $ 	    end  {if status = ker$_success} 	elseuD 	    If status = ker$_disconnect then   { circuit was disconnected }+ 	        goto dda$_circuit_process_return; i       end; {while true}e     DDA$_CIRCUIT_PROCESS_RETURN:> { If there is an outstanding request to be signalled for OOB } {  characters then cancel it: }l! if sgnl_oob_outstanding_ptr^ then 	     beginc4 	{ Delete a signal request queued for this circuit }- 	dda$_dequeue_circuit_reqs ( console_struc );s& 	{sgnl_oob_outstanding_ptr^ := false;}     end;" dispose(sgnl_oob_outstanding_ptr);  $     disconnect_circuit(dda_circuit^,& 		       status := disconnect_status);     delete  ( dda_circuit^ );^     dispose ( dda_circuit );   end;   tP [inline] procedure DDA$_Dequeue_Circuit_Reqs (terminal : terminal_data_pointer);   {  {{K {  This procedure will dequeue an OOB signalling request for the specified e {  circuit, if one exists. OM {  NOTE: Currently there is only ONE queue for console (signal OOB characterseI {	 queue) and only ONE request per line per circuit.  Therefore, we only nH {	 need to search ONE queue for ONE request and cancel that request.  InE {	 the future, if a circuit gets disconnected and we have to clean upiE {	 the requests for the circuit by calling dda$_Dequeue_circuit_reqs,n9 {	 THIS CODE WILL HAVE TO GO THROUGH ALL EXISTING QUEUES g {	 AND CANCEL ALL REQUESTS.u {h	 { Inputs:t {    terminal - line structure {r
 { Outputs:	 {    none= {u {--} varm!     current_process_id : process;}      beginm(     current_process(current_process_id);!     tc$cancel_oob_chars(terminal,t 		current_process_id); end;    8 procedure dda$tty_get_char(var message_obj	   : message;( 			       request_ptr	   : ^dda$_packet;5 		               console_parameters  : ln_param_rec);a { 5 { dda$tty_get_char - Get the console characteristics.c {e {--}   type     char_response = record 	header: dda$_header;d, 	data_buffer: dda$_terminal_characteristics; 	end;r   varr     new_message	: message;     response	: ^char_response;     status	: integer;	   begind  A     { Driver creates a new message and deletes the original one }m<     create_message(new_message, response, status := status);       if odd(status) then_	     begin D 	{ Copy request header information, including unmodified user_data }2         response^.header := request_ptr^.header;    @ 	{ Return the size of the current revision of the data buffer. }  P         response^.header.dda$_buffer_size:= size(dda$_terminal_characteristics);  5 	delete(message_obj);  		{ Delete original message }	_: 	message_obj := new_message;	{ Return new message object }  1 	lock_mutex (dda_struc.dda_terminal_char_lock);  r  ) 	{ Fill in with console characteristics }. 	with response^.data_buffer do
 	    begin$ 	    	class         := driver_class;% 	    	dev_type      := device_type;   6 	    	revision      := dda$tty_terminal_char_revision;  . 	        host_sync     := dda_struc.host_sync;6 	    	tty_sync      := input_region^.line_ctx.tt_sync;? 		modem_control := dda$_modem_control_driver;  {not applicable}e  - 	    	echo 	      := console_parameters.echo;.2 	    	passall       := console_parameters.passall;:     	        passthru      := console_parameters.passthru;6 	    	escape        := console_parameters.ANSI_escape;2 		eight_bit     := console_parameters.eightbit;   6 	    	scope 	      := NOT console_parameters.hardcopy;   	    	parity        := false; 5 		parity_type   := dda$_parity_even; {not applicable}> 	    	char_size     := 8;      	    	ddcmp         := false; 3 		line_speed    := dda$_rate_none; {not applicable} ( 	    	modem_support := false; {no modem}  / 		{ No modem support, so just send back false }, 	    	ring 	      := false;u 	    	cd   	      := false;  	    	cs   	      := false;	 	    	dsr  	      := false;e 	    	dtr  	      := false;  	    	rts  	      := false; 
 	    end;	3 	unlock_mutex (dda_struc.dda_terminal_char_lock);     . 	response^.header.dda$_status := ELN$_SUCCESS;       end {if odd(status)} else	     beging! 	if (status = ker$_no_object) or n 	   (status = ker$_no_pool) or e 	   (status = ker$_no_memory). 	thenl 	    status := ELN$_NORESOURC;  + 	request_ptr^.header.dda$_status := status;i     end;   end; {procedure}   o@ procedure dda$tty_set_char( var request_ptr 	    : ^dda$_packet;6 		            var console_parameters  : ln_param_rec); {lC { dda$tty_set_char - Set the characteristics for the console, usingm, {		  the new values from the message packet. {  {--}   type     set_char_request = record	 	header: dda$_header;D, 	data_buffer: dda$_terminal_characteristics; 	end;i   var %     status	: integer := ELN$_SUCCESS;s     version	: integer;     temp_sync	: boolean;          beginu  C     { Make sure the received data buffer is at least big enough to}	=     { contain the revision number, otherwise it is invalid. }tI     if (request_ptr^.header.dda$_buffer_size < dda$_char_revision_offset)e     then 	statu                                                                                                                                                                                                                                   )                         $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                              i "     g       s := eln$_invalrec     else 	beginE 	    version := request_ptr::^set_char_request^.data_buffer.revision;n 	    {< 	    { Make sure the revision is valid, and if so, that the ? 	    { buffer size matches the size for that revision number: }  	    {}  	    CASE version of 		1:  beginiK 		    	if (request_ptr^.header.dda$_buffer_size <> dda$_char_1_buffer_size)  		    	then  			    status := eln$_invalrec;.
 		    end; 	r 		2:  beginiG 			if (request_ptr^.header.dda$_buffer_size <> dda$_char_2_buffer_size)e 		        then i 			    status := eln$_invalrec; 
 		    end;   		OTHERWISE_ 		    begin; 			status := eln$_invalrec; 
 		    end; 	    end; { CASE }
 	end; {if}  B     if status = ELN$_SUCCESS then	{buffer passed all the tests...} 	begin  5 	    lock_mutex (dda_struc.dda_terminal_char_lock);  f  8 	    with request_ptr::^set_char_request^.data_buffer do 		beging? 		    { Only the following variables are settable for console }o/ 		    { Ignore all other user supplied values }x5 	    	    input_region^.line_ctx.tt_sync := tty_sync;eB 	    	    dda_struc.host_sync            := false; {unimplemented}1 	    	    console_parameters.echo        := echo;e4 	    	    console_parameters.passall     := passall;4 	    	    input_region^.line_ctx.passall := passall;3 	    	    console_parameters.ANSI_escape := escape;n7 	    	    console_parameters.hardcopy    := NOT scope; u2 		    console_parameters.eightbit    := eight_bit;8 	    	    input_region^.line_ctx.eight_bit := eight_bit;4 		    { PASSTHRU is not in the revision 1 terminal }3 		    {  characteristics record.  If the received } 6 		    {  set_char request is for a version 1 record, }% 		    {  the don't change PASSTHRU: }0 		    if version >= 2 then 			begin3 		    	    console_parameters.passthru := passthru; 7 		    	    input_region^.line_ctx.passthru := passthru;d 			end;t 		end;	r  7 	    unlock_mutex (dda_struc.dda_terminal_char_lock);      	    status := ELN$_SUCCESS;     end;   return:a+ 	request_ptr^.header.dda$_status := status;q   end; {procedure}       i  9 process_block circuit_process ( circuit_struc : ct_ptr );	 {++ H { Circuit_process - Process to handle servicing a particular DAP circuit { K { Inputs : circuit_struc - a structure containing information particular ton {          this circuite {; {--} varo' 	console_circuit_flags: terminal_flags;t1 	read_buff: terminal_read_buffer;	{ Read buffer }nD 	saved_record_attributes: dap$b_rat;	{ Record attributes from open }D         saved_record_format: dap$b_rfm;		{ Record format from open }M         saved_fixed_control_size: dap$b_fsz;	{ Fixed control size from open }n7 	server_status: integer;			{ Server completion status }a    ; function circuit_process_handler of type exception_handler;t {++ . {  circuit_process_handler - Exception handler {}
 {  Inputs: { ) {	Standard exception condition arguments.i {--} beginl! circuit_process_handler := false;s write_exception(signal_args);r   delete ( circuit_struc^.port );b dispose ( circuit_struc );   exit;   { Exit the process }   end;    . function open_routine of type dap$open_action; {++ $ { open_routine - Open action routine { 	 { Inputs:  {d {	create			- create/open flagk" {	file_access 		- file access mode {	share 			- share access $ {	organization 		- file organization! {	record_format 		- record format{( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options	( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics* {	file_specification 	- file specification7 {	fixed_control_size	- fixed control size for VFC filesc' {	context 		- driver specific parameter_ { 	t
 { Outputs: {_$ {	organization 		- file organization! {	record_format 		- record format ( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options ( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics {E {	Return value = success.  {--} begin   1     saved_record_attributes := record_attributes;D)     saved_record_format := record_format;r3     saved_fixed_control_size := fixed_control_size;e  #     if (maximum_record_size = 0) orD- 	(maximum_record_size > max_read_buffer_size)i     then- 	maximum_record_size := max_read_buffer_size;d  ;     circuit_struc^.read_buffer_size := maximum_record_size;        organization := dap$k_seq;!     {record_format := dap$k_var;}n     file_options := [];	     device_char := gE 	[dap$v_devrec,dap$v_devccl,dap$v_devtrm,dap$v_devidv, dap$v_devodv];	  5     { Set up the circuit flags record for this OPEN }s  ?     {*********************************************************} ?     {*** All user-written drivers must use the new definition }      {*** of terminal_flags!!! } ?     {*********************************************************}u  !     with console_circuit_flags dos 	begin0 	    if circuit_struc^.read_buffer_size = 1 then 		begini0 		    { Special case for a read passthru state } 	   	    echo := false;n% 	            edit_mode_read := false;t 		end 	 	    else  		beginu+ 		    { Take value from default data base }i% 		    echo := console_line_char.echo;I  : 		    { The edit_mode_read flag TRUE indicates that data }3 		    { should be checked for editting functions: }  		    edit_mode_read := NOT (  			console_line_char.passall ORi  			console_line_char.passthru ); 		end;  - 	    hardcopy  := console_line_char.hardcopy;n;     	    escape_recognize := console_line_char.ANSI_escape;r 	end;q  "     open_routine := dap$k_success;   end; e, function get_routine of type dap$get_action; {++ , { get_routine - Get/read data action routine {g	 { Inputs:  {i* {	record_access	- record access to be used8 {	record_number	- record number - used as key in control! {	record_options	- record optionsn. {	buffer 		- pointer to receive buffer address" {	buffer_length	- length of buffer1 {	get_buffer	- routine to get a new larger buffer & {	context 	- driver specific parameter { 
 { Outputs: {o- {	buffer_length	- length of actual datum readO {	Return value = success {--} vara     i, read_length: integer;     read_status: boolean;i     count: integer;y     eof: boolean;c     tmp_buff: ^anytype;s  / function get_handler of type exception_handler;  {++i" {  get_handler - Exception handler {n
 {  Inputs: {q) {	Standard exception condition arguments.u {--} begins     get_handler := true;$     get_routine := signal_args.name;     goto return; end;   begin      establish(get_handler);i       {uF     { If the record access is keyed and the record number is non-zero,D     { then the record number represents a mask of control characters     { that are to be awaited.t     {}  ?     if (record_access = dap$k_key_acc) and (record_number <> 0)e     then 	begin;         read_buff[1] := tc$await_ctrl_key (  console_struc,c% 				    	     input_region^.line_ctx, / 				             record_number :: ctrl_key_set,s 					     circuit_struc^.port);r 	count := 1; 	eof := false; 	read_status := true;f 	end     else
         beginc 	{ Normal read }E 	{ Set up the flags record for this read with line data base values.}sD 	{ This makes certain that if the line values were changed through }E 	{ DDA SET_CHARACTERISTICS then the new READ will pick up these new }s= 	{ values, but READs that are already in progress will keep }e> 	{ whatever values of ECHO, HARDCOPY, and ESCAPE RECOGNITION }$ 	{ that they are currently using.  }  < 	{*********************************************************}< 	{*** All user-written drivers must use the new definition } 	{*** of terminal_flags!!! }< 	{*********************************************************}   	with console_circuit_flags do
 	    begin1 	    	if circuit_struc^.read_buffer_size = 1 thena 		    begin 4 		        { Special case for a read passthru state } 	   	    	echo := false;& 	            	edit_mode_read := false;	 		    end 
 	        else  	 	    begin, 		    	{ Take value from default data base }& 		    	echo := console_line_char.echo;  ; 		    	{ The edit_mode_read flag TRUE indicates that data }o4 		    	{ should be checked for editting functions: } 		    	edit_mode_read := NOT (  # 			    console_line_char.passall ORt$ 			    console_line_char.passthru );
 		    end;  1 	        hardcopy  := console_line_char.hardcopy;a?     	        escape_recognize := console_line_char.ANSI_escape;I	 	    end;	  " 	    read_status := tc$read_chars( 				input_region^.line_ctx,  				console_struc, 				read_buff,$ 				circuit_struc^.read_buffer_size,
 				count,                                                                                                                                                                                                                                                   *                        ߤ $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                               "     x        				console_circuit_flags, 				eof, 				put_chars);z 	end;  {if}  	        {m!     { If success, return the data 6     { For VFC files, place a control field on the data     {}       if read_status     then 	begin  # 	if saved_record_format = dap$k_vfcg 	then 4 	    read_length := count + saved_fixed_control_size 	else= 	    read_length := count;  ? 	{ Check the buffer for overflow. If so, allocate new buffer. }e   	if read_length > buffer_lengths 	thena' 	    buffer := get_buffer(read_length);a  @ 	{ Copy the input to the supplied buffer and return the length }  # 	if saved_record_format = dap$k_vfct 	then 
 	    begin. 	    for i := 1 to saved_fixed_control_size do- 		buffer^::terminal_read_buffer[i] := chr(0); E 	    tmp_buff::integer := buffer::integer + saved_fixed_control_size;r 	    end 	elser 	    tmp_buff := buffer;  7 	tmp_buff^::string(count) := substr(read_buff,1,count);a   	buffer_length := read_length;   	{ Set the return status }   	if eofs 	thene
 	    begin 	    get_routine := dap$k_eof; 	    eof := false  	    end 	else ! 	    get_routine := dap$k_successa 	end     else' 	get_routine := dap$k_device_not_ready;i   return:d     revert;  end; :, function put_routine of type dap$put_action; {++ - { put_routine - Put/write data action routine  { 	 { Inputs:h {e% {	record_access 	- record access typeg {	record_number	- record numbern! {	record_options	- record optionst/ {	buffer 		- buffer of characters to be writtend4 {	buffer_length	- number of characters to be written& {	context		- driver specific parameter { 	e
 { Outputs: {_ {	Return value = success.e {--} var      write_status : boolean;v   beginv  ;     write_status := tc$write_chars ( console_struc, buffer, - 				  buffer_length, saved_record_attributes,S 				  put_chars );   {**    if write_status then **}d 	put_routine := dap$k_successr {**    elsee+ 	put_routine := dap$k_device_not_ready; **}r end;  6 function truncate_routine of type dap$truncate_action; {++  {s- {  truncate_routine - truncate action routinen { H {	This routine is called by the dap$server routine when the user process  {	executes a truncate statement. { 
 {  Inputs: { 8 {	record_access		- type of access to be used in truncate { 	e {  Outputs:t {t {	return value = success {_ {--} vars     stat : boolean;r   beginf  " if ( (console_line_char.echo) AND -      (circuit_struc^.read_buffer_size <> 1) )t   then( 	stat := tc$write_newline(0, put_chars);  ! truncate_routine := dap$k_successi end;   {++  {	, {  Mainline code for circuit_process routine {  {--} begin_  0     eln$allocate_stack ( 4096 ); { eight pages }  '     establish(circuit_process_handler);:  H     server_status := dap$server (circuit_port    := circuit_struc^.port,& 			  	open_action     := open_routine,% 			  	get_action      := get_routine,a% 			  	put_action      := put_routine,e+ 			  	truncate_action := truncate_routine);l  #     delete ( circuit_struc^.port );      dispose ( circuit_struc ); end; t  + process_block timer_process ( evt  : event;r& 			     timeout_occurred : ^semaphore;  			     request_timer : event );   {++ ( { TIMER_PROCESS : general timer process M {   Accepts requests for starting timers, and signals main code upon timeout.b {--} {++  {  {n {--}   varr     status: integer;(     sigstat	 : integer;	{ local status }*     wait_stat	 : integer;	{ local status }9     timer_result : integer; 	{ result of a wait_any call} A     entry_ptr	: ^queue_record;{ general pointer to queue records}dK     timeptr 	: ^queue_entry;	{ pointer to queue entries in the timer_queue}cL     reqptr 	: ^queue_entry; { pointer to queue entries in the request_queue}E     relative_time : large_integer; {difference between 2 time values}cH     done_insert : boolean;	{ true if we have finished inserting all the}3 				{  request_queue entries into the timer_queue.}lI     done_checking_timer : boolean; { true if finished removing from the }_2 				{ timer_queue all the entries that have timed}/ 				{  out or that have ignore_timeout = true.}cE     tail_entry : boolean;	{ true if a record has to be added at the }F. 				{  tail position of the queue, rather than$ 				{  before the current position.}     first_element  : boolean;e     empty	   : boolean;i&     timer_active   : boolean := false;'     signal_main    : boolean := false; :     time_proc      : process;i   beginm  sJ     { Set the process priority of the timer to 7, above that of the line ]8     { processes and below that of the main dispatcher. }     current_process(time_proc);t2     set_process_priority(time_proc,read_priority);  #     signal ( evt,status:=sigstat );u       {Wait for startup: }     while true do 	     begin- 	if timer_active	then	   	    wait_any(request_timer, 	& 	             result := timer_result, " 	             time := new_timeout," 	             status := wait_stat) 	else    	    wait_any(request_timer, e& 	             result := timer_result, # 	             status := wait_stat);c    	 	clear_event(request_timer);  e, 	done_checking_timer := false;		{initialize}  s3 	REPEAT	{repeat until done_checking_timer := true }_; 	    timeptr := timer_queue.flink;  {point to first entry} 	  r, 	    { Is this the end of the timer_queue? }+ 	    If timeptr = address(timer_queue) theno= 	    	done_checking_timer := true  {no more entries to check}r  t	 	    elseu 	        begin(     	        lock_mutex ( sync_lock );  C 	    	with timeptr::^queue_record^ do  { point to the queue record}n 	    	    begin    p; 	                get_time(my_timer); 	{ get current time }	 ; 			{check if timer entry was cancelled or if timer expired} : 			if ((ignore_timeout) OR (time_at_timeout <= my_timer))  			then  			    begin			    i0 				{remove the current entry (the first entry)}% 			        remove_entry (timer_queue,e 					entry_ptr::^queue_entry,  					empty, queue$head);1 				{insert the entry into the timer_complete_q:}m) 			    	insert_entry ( timer_complete_q, _ 		    			entry_ptr^.entryq,a% 				    	first_element, queue$tail ); 2 				signal_main := true;	{signal timeout_occurred}
 			    end 			else	$ 			    {timeout has not expired yet}# 			    done_checking_timer := true;    5 	    	    end;  { with timeptr::^queue_record^ begin}*$ 		    unlock_mutex ( sync_lock );  	   8 	        end; { If timeptr = address(timer_queue) begin}    	UNTIL done_checking_timer;*  * {------ end common code ------}u        case timer_result of     0:		{timeout} 	     beginiG 	{ Nothing special to do for timeouts that wasn't already done above. }rG 	{  After this case statement, the timer will be resumed by setting   }a 	{  a new timeout value. }     end; {case 0}         1:		{request for timer}b	     begin 7 	done_insert := false;		{init - not done inserting yet}d  e 	REPEAT ! 	    lock_mutex ( sync_lock );  	hB 	    reqptr := request_queue.flink; {first entry in request_queue}   G 	    if reqptr = address(request_queue) then  {no more request entries}	 		begin   	            done_insert := true 		endy   4 	    else	{there is at least one more request entry}  e 	        begin  p; 	    	{Remove the entry from the head of the request_queue}e" 	    	remove_entry (request_queue,& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);  	 		if empty theno' 		   begin	{no more entries after this}  			done_insert := true;  		   end; {if}  r@ 		if not entry_ptr^.ignore_timeout then  {if record still valid} 		    begin	0 		    { Insert the request into the timer_queue}D 	        	timeptr := timer_queue.flink; {first entry in timer_queue}: 			timeptr := timeptr^.blink;     {get back to the header}  eF next_entry:		timeptr := timeptr^.flink;     {identify the next entry.}; 			tail_entry := false; {add at CURRENT position, not TAIL}    % 			{ Is this the end of timer_queue?}n+ 			if timeptr <> address(timer_queue) then t' 			    begin  	{not end of timer_queue}tA 				with timeptr::^queue_record^ do  { point to the queue record}  		    	    	    begin     6 			                relative_time := time_at_timeout - ! 						entry_ptr^.time_at_timeout;e( 				        if relative_time <= 0 then  9 					    goto next_entry;  {queue entry is more imminent}e 				    end; {with}e
 			    end+ 			else		{we are at the end of timer_queue}a; 			    {Have to insert the record at the TAIL of the timer}(: 			    { either because all the timer_queue elements are }: 			    { more imminent than this request, OR there are no}; 			    { elements left in the timer_queue (so that putting}k: 			    { the entry at the tail is that same as putting it} 			    { at the head. }s 			                                                                                                                                                                                                                                                      +                        ՜ $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                              Pm "             begin 			        tail_entry := true{ 			end;e  } 			{Insert the request}o  f 			if tail_entry thend# 			    insert_entry ( timer_queue, t 		    			entry_ptr^.entryq,e$ 				    	first_element, queue$tail ) 			elseS 			    begin1 				timeptr:= timeptr^.blink;  {get to previous }s# 						 {entry and insert after it.}e  		    		insert_entry ( timeptr^, 		    			entry_ptr^.entryq,I' 		    		    	first_element, queue$head)} 			end; {if tail_entry}*2 		    end { If not entry_ptr^.ignore_timeout then} 		else 		    beginsA 		        { This record never got into the timer_queue, because }*9 		  	{ the ignore bit was set while it was still in the } 6 		  	{ request_queue.  Since there are no longer any }6 			{ pointers to this record in the main code, we can}6 			{ dispose of the record now, rather than put it in} 			{ the timer_complete_q. }, 	    		dispose (entry_ptr);  {get rid of it} 		end;    { else }  	3 	    end;    { if reqptr = address(request_queue) }h  	    unlock_mutex (sync_lock);     A 	UNTIL done_insert  {Repeat until all request_queue records have}o. 			   {  been inserted into the timer_queue. }   end; {case = 1}N
     otherwisec 	begin	{No other events} 	end;      end; {End Case}p  t    {for both case 0 and case 1:}c     {      { Resume timing }o     { ?     { Set the new_timeout value to be the timeout of the first  5     {  element in the timer_queue, if there are any. uG     {  NOTE that the timeout of the first element of the queue may haveuE     {  already passed, during the execution of this routine.  So the  ?     {  wait_any for the timeout may get satisfied immediately. e     {}       lock_mutex (sync_lock) ; e?     timeptr := timer_queue.flink; 	{first entry in timer_queue}h  &     if timeptr = address(timer_queue)      then> 	timer_active := false		{no active entries in the timer queue}     else 	begin 	    timer_active := true;& 	    with timeptr::^queue_record^ do  ! 		new_timeout := time_at_timeout;          end; {if}e       unlock_mutex (sync_lock) ; l  t9     { Waited to signal main code until all entries that } !     { timed out were processed. }r     if signal_main then 
         begin  	    signal_main := false;  	    { Signal main driver code }/ 	    signal(timeout_occurred^, status:=sigstat)g 	end;u     end; {while true}  e end; {process}     e4 procedure Cancel_timer ( var ptr : ^queue_record ) ; {g& { Cancel a previously requested timer. {b+ { INPUT: ptr => pointer to a queue_record. tA { OUTPUT: => Ignore_bit field of the input record is set to true.a& {         => Ptr is replaced with nil. {}   beging     lock_mutex (sync_lock );	eK     if ptr <> nil then	   {do this check while we have control of the lock}t 	begin! 	    ptr^.ignore_timeout := true;d             ptr := nil 	end;t     unlock_mutex (sync_lock);	 end; {procedure}   e- procedure add_timer_request ( line : integer;o! 			     interval : large_integer;d! 			     t_event  : timeout_event;r! 			     var ptr  : ^queue_record;t  			     request_timer : event ); {++c {sE { add_timer_request: add a timer request to the request queue for the: {		     console line.s {e7 { INPUTS:  Line => console line,  it requested a timer. K { 	   Interval => length of time or absolute time to set the the timer for.lE {	   t_event  => type of timer (eg. evnt$mod2sec is a 2 second timer)_> {	   ptr	    => the address that will hold the pointer to the 6 {		       queue record after it is added to the queue.E {	   request_timer => the event to signal when the request is queued.u {t {--} var      entry_ptr	: ^queue_record;     save_ptr	: ^queue_record;a     tval	: large_integer;s     first_element : boolean;   begin  n0     {Cancel the previous timer, if there is one}     Cancel_timer (ptr);n  1     { Make sure time field is an absolute time. }s     if interval < 0 then 	begin! 	    { Interval is a delta time }e/ 	    get_time(my_timer);		{ get current time }	rM 	    my_timer := my_timer - interval;  { Determine ABSOLUTE TIME at timeout} u 	end     else! 	{ Interval is an absolute time }l 	my_timer := interval;        2     new (entry_ptr) ;	{create a new queue element}B     entry_ptr^.line  := line;  { Only one line for the console }		=     entry_ptr^.time_at_timeout := my_timer;  {absolute time}	t9     entry_ptr^.evnt := t_event;		{type of timer request}	e(     entry_ptr^.ignore_timeout := false;	  I     {queue the element in the request_queue and signal the timer process}        lock_mutex (sync_lock );  	 4     insert_entry ( request_queue, entry_ptr^.entryq," 		   first_element, queue$tail );	C     signal (request_timer);   {signal the timer to add the request}n  A     {Update the timer state for this line by saving the pointer }eB     { to the queue record in case you have to cancel the request }     {  later on: }     ptr := entry_ptr;       unlock_mutex (sync_lock);  	 	o end;  {process}  t    5 procedure dda$tty_read( request_ptr   : ^dda$_packet;g 			message_size  : integer;a 			request_timer : event );r {r$ { dda$tty_read - perform a DDA read  {  {--}   type@     bit_mask_set = packed set of 0..255; {set of oob characters}   var	6     lkahd_flag	  : boolean := true; { lookahead flag }8     status	  : integer := eln$_success; {assume success}     my_process	  : process;o   begin   @     { Make sure there is enough buffer space in the message to }$     {  return the data to be read. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	begin  	    status := eln$_invalbufsiz;/ 	    request_ptr^.header.dda$_buffer_size := 0;  	end;l  5     { Do not allow absolute times for timeout value }hO     if (dda$_sfb_timeout IN request_ptr^.header.dda$_subfunction.read_sfb) theno9         if request_ptr^.header.dda$_read_timeout > 0 theno
 	    begin9 	        status := eln$_invtimval;	{ Invalid time value }o3 	        request_ptr^.header.dda$_buffer_size := 0;e	 	    end;   !     if status = eln$_success theni 	begin  . 	    { Bump up process priority for the read }! 	    current_process(my_process); 5 	    set_process_priority(my_process, read_priority);i  9 	    { Obtain exclusive read access to the console line }t( 	    tc$set_read_lock ( console_struc );  5 	    { Pre-set the I/O completion status to success }w. 	    console_struc^.io_status := eln$_success;  / 	    { Clear out the extended status longword },6 	    request_ptr^.header.dda$_extended_status := zero;  3 	    { Make sure there is enough buffer space for }e9 	    { at least one character.  If not, return success. }e5 	    if request_ptr^.header.dda$_buffer_size > 0 then;  / 	    with console_struc^,request_ptr^.header dok
 	    begin 		io_done := false;r/ 		input_region^.line_ctx.read_passthru := true;   = 	    	if (dda$_sfb_minimum IN dda$_subfunction.read_sfb) then  		    begine! 			if dda$_min_read_size = 0 then_ 			    begin( 				cur_read_length := dda$_buffer_size; 				max_read_size := 0; + 				{ Preset io_done to true, so that the }h+ 				{ read will be complete after copying }u) 				{ whatever data is currently in the }  				{ typeahead buffers.}  				io_done := true;
 			    end 			elser 			    begin			    o* 				cur_read_length := dda$_min_read_size;& 				max_read_size := dda$_buffer_size; 			    end; 	 		    end  		else 		    beginu' 			cur_read_length := dda$_buffer_size;  			max_read_size := 0; e
 		    end;  ) 		{ Clear the number of characters read }d 		cur_read_count := 0;  7 		{ If there is a terminating mask, and it is 0, then }r@ 		{ just perform a normal read, as if there were no terminating} 		{ mask request. }	; 		if (dda$_sfb_term_mask IN dda$_subfunction.read_sfb) then 0 		    if dda$_term_mask::bit_mask_set <> [] then 			begin$ 		    	    read_w_term_mask := true;4 			    term_mask::dda$_break_mask := dda$_term_mask; 			end;t  , 		{ Pick up the address of the data buffer }= 		user_buffer::^anytype := address(request_ptr^.data_buffer);m  > 		{ See if there are any characters in the typeahead buffers } 		tc$process_input_characters( 			input_region^.line_ctx, 			console_struc,h 			lkahd_flag);   0 		if not(io_done)   { Read is not complete yet } 		then 		    beginb> 	    		if (dda$_sfb_timeout IN dda$_subfunction.read_sfb) then 		    	    begin! 				if dda$_read_timeout = 0 thenn
 				    begin	( 					{ Complete the read and return as }* 					{ many characters as were available }, 					{ in the typeahead buffers, reflected } 					{ in cur_read_count. }i# 				    	io_status := eln$_timeout;n 					io_done := true;i% 				        read_w_term_mask := falset 				    endn 				else
 				    begini" 					{ Enter a timeout entry and } 				                                                                                                                                                                                                                                                   ,                        b3J $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]CONSOLE.PAS;1                                                                                       n                              a             	{ and continue the read. }m1 					add_timer_request ( line, dda$_read_timeout,  					    evnt$io_tmo,u* 					    line_timer_struc.io_tmo_started,  					    request_timer); 				    end;& 		    	    end; {if (dda$_sfb_timeout}   			if not(io_done) then	 			    begin% 			        { Continue with the read }e 				read_started := true;e 				read_in_progress := true; ) 				{ Signal the main driver process to }h 				{  process the read: }* 				signal(start_read^, status := status); 				wait_any(read_complete); 			    end; 	 		    endc 		else 		    begin  		        { IO_DONE is TRUE }^; 	    		IF ((dda$_sfb_timeout IN dda$_subfunction.read_sfb) e# 			    AND (dda$_read_timeout = 0)    			    AND (cur_read_count = 0) = 			    AND (dda$_sfb_minimum IN dda$_subfunction.read_sfb) )   			THEN{9 			    { Give errors precedence over timeout completion }d6 			    { status.  If there was an error on the first }7 			    { character read, then the cur_read_count will }  			    { be zero. }t 			    if odd(io_status) 			    thenv6 			        {Change the status from success to timeout} 				io_status := eln$_timeout;
 		    end;   		{ 5 		{ Read is complete or timed-out. Return the number   		{  of characters read. 		{}% 		dda$_buffer_size := cur_read_count;e   	    end; {with}   	{ Return I/O status to user }= 	request_ptr^.header.dda$_status := console_struc^.io_status;e  . 	{ Release exclusive read access to the line }& 	tc$clear_read_lock ( console_struc );  4 	{ Reset the process priority back to the default. }3 	set_process_priority(my_process, normal_priority);{  $     end  {if status <> eln$_success} else    { Return status to user }-    request_ptr^.header.dda$_status := status;    end; { procedure }   l6 procedure dda$tty_write( request_ptr   : ^dda$_packet; 			 message_size  : integer);{ {r/ { dda$tty_write - perform a DDA write to a linet {p {--} var 8     status	  : integer := eln$_success; {assume success}#     output_buffer : ^string(32767);      write_status  : boolean;   begint  @     { Make sure there is enough buffer space in the message to }(     {  contain the data to be written. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	begin  	    status := eln$_invalbufsiz;/ 	    request_ptr^.header.dda$_buffer_size := 0;o 	end;   3     { Obtain exclusive write access for this line } (     tc$set_write_lock ( console_struc );  !     if status = eln$_success then  	begin  + 	    { See if there is anything to write. }u  	    { If not, return success. }5 	    if request_ptr^.header.dda$_buffer_size > 0 theno  / 	    with console_struc^,request_ptr^.header do  	    	begin10 		    { Pick up the address of the data buffer }C 		    output_buffer::^anytype := address(request_ptr^.data_buffer);   ( 		    write_status := put_chars ( line,  					dda$_buffer_size,1 					substr(output_buffer^,1,dda$_buffer_size) );     		    if not(write_status) then  		    	begin$ 			    status := eln$_devnotready;   			    dda$_buffer_size := 0;  r 		    	end;d
 	        end;t 	end;        { Send back status }.     request_ptr^.header.dda$_status := status;  4     { Release exclusive write access for this line }*     tc$clear_write_lock ( console_struc );   end; { procedure }    < procedure dda$tty_sgnl_oob( var request_ptr 	: ^dda$_packet;) 			    terminal		: terminal_data_pointer;u* 			    var line_data	: terminal_read_data;+ 			    sgnl_oob_outstanding_ptr: ^boolean);  {e3 { dda$tty_sgnl_oob - Signal out-of-band characters.  { * { INPUTS: request_ptr - dda request packet' {	  terminal    - terminal data pointert# {	  line_data   - console line datad {rF { OUTPUTS: sgnl_oob_outstanding_ptr^ -  set to true if the request for9 {	    oob signalling is successful.  Only one request forr6 {	    oob signallling can be outstanding at a time for {	    a dda circuit. {  {--}   varc-     status	        : integer := ELN$_SUCCESS;a%     ctrl_wait_ptr       : ^ctrl_wait;      this_process	: process;q4     this_process_ptr    : ^process;	  { Process ID }3     new_process_id      : process;	  { Process ID }l9     init_event		: ^event;	  { Event to signal after init}eB     process_Stat	: ^integer;	  { Status from create process call}   + function handler of type exception_handler;  begin  status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or i     (status = ker$_no_memory)l then     status := ELN$_NORESOURC;:   goto return; end;     begin      establish(handler);   0     { Only one request per circuit is allowed: }&     if sgnl_oob_outstanding_ptr^ then + 	raise_exception(eln$_request_outstanding);   G     if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] then 	     begini  3 	{ Create a record describing the waiting process }e 	new(ctrl_wait_ptr);  7 	{ Status and event to signal from create_process call}h 	new(process_stat);o 	new(init_event);h+ 	create_event (init_event^, event$cleared);t   	new(this_process_ptr);t 	current_process(this_process);t# 	this_process_ptr^ := this_process;   > 	{ Create the process to handle incoming oob char signalling }? 	create_process(new_process_id,	{returns id of created process} 5 		tc$signal_oob_chars,    {name of process to create} $ 		terminal,		{terminal data pointer}# 		line_data,		{terminal read data }s4 		this_process_ptr,	{process id of creating process}% 		ctrl_wait_ptr,		{ctrl_wait record.}r  		request_ptr,		{message packet}7 		process_stat, 		{status of initialization in process}E5 		init_event,		{event to signal after initialization}u 		sgnl_oob_outstanding_ptr);   	wait_any(init_event^);y   	if not odd(process_stat^) then}
 	    begin 	    	status := process_stat^; 	    	dispose(ctrl_wait_ptr);n 	    end         else' 	    sgnl_oob_outstanding_ptr^ := true;r   	dispose(this_process_ptr);o 	delete(init_event^);  	dispose(init_event);u  J     end; {if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] }   return:      revert;m+ 	request_ptr^.header.dda$_status := status;q   end; {procedure}   t? procedure dda$tty_cncl_oob( var request_ptr     : ^dda$_packet;e) 			    terminal		: terminal_data_pointer;n, 			    sgnl_oob_outstanding_ptr : ^boolean); {sL { dda$tty_cncl_oob - Cancel a request for out-of-band characters signalling. {q* { INPUTS: request_ptr - dda request packet/ {	  console_paramters - console line parameters;A { 	  sgnl_oob_outstanding_ptr^ -  true if there is an outstanding_6 {	    request for oob signalling for this dda circuit. {e {--}   var &     status  : integer := ELN$_SUCCESS;2     current_process_id : process;	  { Process ID }       + function handler of type exception_handler;  begine status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or       (status = ker$_no_memory)r then     status := ELN$_NORESOURC;g   goto return; end;     begin      establish(handler);e  4     { If there is a request outstanding, cancel it }&     if sgnl_oob_outstanding_ptr^ then 
         beginb) 	    current_process(current_process_id);r" 	    tc$cancel_oob_chars(terminal, 				current_process_id);( 	    sgnl_oob_outstanding_ptr^ := false;$ 	end; {if sgnl_oob_outstanding_ptr^}   return:)     revert; + 	request_ptr^.header.dda$_status := status;0   end; {procedure}   end;  {final end}n                                                                                                                                                                                                                                                                                          + * [SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6   7 I  8          9          G    H  J                     0 D X     0205      (  bq     &      0                                CONSOLE                                V4.0-02        5b 05-05                                     
       ?         !        DAP_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001"      !         
TERMCLASS_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    -                        oY, $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.EXE;1                                                                                                                   "                
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          Console driver exception 0 0:0:20$ACCESS_CONSOLEϞP^|"  m\(٭^P < ~"  ̠  0 Z!  Zڱ(\ܰR-R  ̭(̭έϠڭ(ڭܭΚ
 RR1 
 R0RTT9T
 R0RVV9VYYZZ[<YXXP^nX(̭hVW<ZVV^nV(YhfW<[XX^(ZfnTRR[VVV(VnΣVRRRVR(RcS2Sޭέ ̠ ̜߭         SVV  V(V̾ V RRRVR̼ (ROc̼ S2S̾   ̸߭    v ߬r   ̴  ̰    ̶  


0
Z!   Zd d(\
-
  ϽO5RR 
6RR
3RR
4RR
RSRSS
9RR
{ RRR RRUUUWW !П RR쟭 ` V2VTTޭܭSK
~̌ ߬||~ ̄ <~SW߭ 
P  USSTޭܭR ̈ |~|~̀ *RS߭ 
P  
~
~
~܄   ~  PX h    l X   ߭ X  ~p  PW g        l @  RݭWl R߭   l|~  l   ̀ R)X ߬x  Ԭ@ڬ  ( ߭   ݭ x I߭  }PU   Uĸ Vg h̠ ̌ ̐   ̐   8 M   :13܄ ݬxb     Uĸ V1

~߬x܄ (1 ~  PS c   |~ c̠    RS R̔    1 ЬxT 1 |~߬x܄   ̄ SУR
&  
~߬xcϟ |~߬x܄   Z~Q  P̘  ܘ    |~ ܘ     mRݭ̘  R̔    ݭ϶ЬxR 1 1 'ݢ"߭ 1h^fW޼n[޼X޼ZШR
& *ШS
&RR 
 
&УԣУԣ2ڧ|ШS
&RR 
 
&УԣУԣ [ 
 1jR @ݢ< @  8-jR @%8ݢ<   DݢfD	Ը 
Rʏ@   RR 
1 [ШSШSSRխ1 Yխ1 TYЭSC%VSUYT3T0Ub+xUQQ&PPQQ&PP
TE%VUT{V~hj  QPTTQTjS QTQQDڧ|bSUS0USbTST$SQA&A%xQSSPP&PPS&TQb UU׭1-@jRRSn7 2 `, @ 8Dݣ
ݣ;jR 3|~jh  ШR
& n~jhϔ|~jh|    
[1|^SUVX|~  PPVUX1  1P TT %T  X1   1   , 1 T  X1   1  X
  УxR P ߣxӄ v   ЏSFEÄ PРQ
&Pʏ   PP
&ݢ"߭ T  X
  T  U1^޼S"RR )	cTT# (޼RPRQ @ڭ"(cDRR#c^'WXvݧr|~  Z޼Y޼[Y YR RRXЧxR 8ݢ<|~  ǀ VXR,RJ  Xf"RRǀ R(@ڭ" ǈ |~߭ ׀ Z׀ YXvݧr  P  \\,!\\\\ \\!\\횡\\"\\^޼Rb(b]Q 
#2WWV]Q FRR#WV]Q m
#^޼SU!RRУQa1  cxRRRj eRR,УP
&RRR
&УP
&RRR
&*УP
&RRR
&УP
&RRR
&U1 ' " `УP
&Rȏ   RR
&UУR$1mV 1QP`RVB%``1N
&Rȏ   RR
&U13W 1 VTTa c,
&RRR
&УP
&RRR
&U1QP`RVB%``1
&Rȏ   RR
&U1Ta c,
&RRR
&УP
&RRR
&U1QP`RVB%``1u
&Rȏ   RR
&U1ZQP`RVB%``1D
&Rȏ   RR
&U1)VRRbcQP
&Rȏ@   RR
&x`RRR&ՠ`֠UУP`RVB%``
&Rȏ   RR
&UWVTT1  c0УP
&RRR
&УP
&RRR
&U1~W1xУP
&Rȏ@   RR
&x`RRR&ՠ`֠UУP`RVB%``1,
&Rȏ   RR
&U1T1  c0УP
&RRR
&УP
&RRR
&U1 W1 УP
&Rȏ@   RR
&x`RRR&ՠ`֠UУP`RVB%``1 
&Rȏ   RR
&UiWfT 5УPx`RRR&ՠ`֠
&Rȏ@   RR
&UУP`RVB%``
&Rȏ   RR
&UU޼RPRQ ^޼S@ڭ  (޼RPRQ @ڭ"(^(6 ޼Wg 	j  	(	 	D  	(	ϲVFRb 	  	(	υV    "E   PQS)УRb   R     P|,^|  mBS޼޼V < ~  ޯ]~w  PUe|~  |~߭߭߭߭@ ѭ1 ЭTT   ݭ   1 ЭRϢ" 1 > K x x x x x x x x x x V i V
R߭ O
߭BVTR"
5TR*Uӄ ݣx߭ϾUݣx߭ЏS|~ܘ~ݭ߭` 1ݭ   ѭ||  1ѭ||  1 eУxn߭   ݭݮV  U5  ߭     ݭ  P^W޼X<~߭߭߭p  ЭYY1 ЭV( hf޼Rb   ЭbXǴ ǰ |~  ЭS 	Ƕ 
ׄ  RRRR	RRRR
RRRRRXǴ 
ǰ   ЭRЏSY|  Y|  	Y|  ЏSЭ<`RЏSTмPРQQ	ЏST5UUPPQ#ЏSTPQЏSTЏSTTS1 X´ ° |~  мQ҄ ¶  	 P	
PP PU PX´ 
°   ЏSTмPTQSRb   R     P^T޼nRо мм<ռ
Ѽ   < SмԼԼ <`$RѢ& 
RR 
S
RRSSS
RR
RRЏ PQR޼PРzR  P8^|  mQVIW޼޼nޯ]Ѯ+n'ݮׄ ݧx  P[1 TѤ& 
RR 
S
RRSSS
RR
RRwԭ ߭߭ݤݧxׄ 	-  P[[~ѦYЭYY޼SY}P`PcѦ#ЦTTX޼ScRHTXZмZR(RjY
Џ ' 씭Џ Џ ! |ЭP^QRS޼޼nϟԭ ߭ݢݮݮݣx\
  Џ P^QSR 
 PѠWԭ߭ 
  Џ P Θ^|	  m޼ < ~	  ]]]8Ͱ]ʹm͠]ͤ|~|~|~͠|~ Ͱ|~|~0	  Pn   1	  P$^T޼޼޼nZ߭   ݭ x ݮ߭ nݮ ߭߭ ݮ ߭߭ ݮ @  VWSSWV1 X|~  SR    Ѣ 5Ѣ +P UUSPeSZVX
  V1iЭ[1 [1 YX|~  QPQPY1 P UUY hPРQaQXPQP*QP РWåV ٥WSyRRWSVRǐXXRPeRСQPea
P	U@  X
  Y1%X|~  SRSRnnSR} X
  Z1Zݾ߭ 1URX|~  ޼QaPaX
  ^
R޼}S޼޼n߼QyPPTQ$SP    S  T }S ~  PSЮ} X|~  QPcQn  SX
  ^HX޼W޼޼nЏS   RѮRЏS SyRRѧ$Sѧ RЏSԧѭS1߭   ݭ x ШxSX*ݣ&|~  ШxRЏSFԧHէ1ШxVȄ R` էЧԦJЧЧJЧԦJԦ- (  (
E( (N f ߨx؄    f7SyRRѧ$Sѧ RЏSFEn  ݦ Tݶ߭ ݦ"|~  /*SyRRѧ$Sѧ Rզ 
 FЏSFЦШxRТFШxSX*ݣ&  ݭ x Э<^PT޼R޼nЏSU   PnPЏSUߤx  US)ТQ#ФxSQ QݣP
ЏSUԢUߤxm  QR޼PРТPP|  P|  	P|  ЏSR  P ^|  m޼n޼VЏSޯ] fݏS 8 ޼TdR- ,  ,1 J~  PY~  PW~  PU e X  ~k  PX߭                                                                                                                                                                                                                                                    .                        >] $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.EXE;1                                                                                                                                 Эhr  SVUWdYXݮ S߭   e|~   ggY  fX  e   U  |мRЭQR޼PРТPP|  P|  	P|  ЏSUR  P^|  m޼n޼RЏSޯ] b߭   ݭݮs  b|мPЭ                                                                                                                                                                                                                                                @   @                                                                  H   P   h   `   p         
         x   `   @   P   H   (       0   p                     $   
                 @                                                                       DAP                                                            	LIBCOMMON                                                      	PASCALMSC                                                      	TERMCLASS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  CONSOLE    $CODE0       $DATA$   0  CONSOLE0  	 
   _   
  
PROCESS_EVENT
  	zk
     
  PROCESS_TIMEOUT_EVENT
  J	  h   }  OUTPUT_INTERRUPT}   	  Q      	PUT_CHARS  8	.	        PUT_EXCEPTION_LINE   TRANSMITTER_READY  		  G     		  P    '  INPUT_INTERRUPT'  A			3  R   y  	POWERFAILy  	,
  3      WRITE_EXCEPTION  	N
      W  CONSOLE_DRIVER_HANDLERW  	f
        DDA_CIRCUIT_PROCESS" v  DDA_CIRCUIT_PROCESS_HANDLERv  	
  3     j	
     V  DDA$TTY_GET_CHARV  R	O  B     DDA$TTY_SET_CHAR  K	       CIRCUIT_PROCESS   CIRCUIT_PROCESS_HANDLER  	  4      OPEN_ROUTINE  0	<        GET_ROUTINE   GET_HANDLER  	        ]	  t     PUT_ROUTINE  
	,
  A    T  TRUNCATE_ROUTINET  	L
  <     	\
      7  
TIMER_PROCESS7  	

0   l     CANCEL_TIMER  	p  E      ADD_TIMER_REQUEST  *	         DDA$TTY_READ   ~	     "  
DDA$TTY_WRITE"  ,	{  {    g#  DDA$TTY_SGNL_OOB  #  HANDLER #  	  G   g#  9	
     $  DDA$TTY_CNCL_OOB ~$  HANDLER~$  	  F   $  	+  T   H A  `^	     -DISK$USER2:[KESSLER.KERNEL.SRC]CONSOLE.PAS;10 L E  tH {   01DISK$USER2:[KESSLER.][KERNEL.SRC]KERNELDEF.PAS;18     
     
C    
,     
KER$VECTOR     KER$DATA                                                                                                                                                                                                                                                                              + * [SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1 +  , 	   .     /     4 n                          - 
    0   1    2   3      K  P   W   O     5   6 ô  7 @fI  8          9          G    H  J                    " module console [ident('V4.1-00')]; { M {****************************************************************************  {*									    *( {*  COPYRIGHT (C) 1984, 1989  					    *< {*  BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.			    * {* 									    * M {*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  * M {*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  * M {*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  * M {*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  * M {*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *  {*  TRANSFERRED.							    * {* 									    * M {*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  * M {*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *  {*  CORPORATION.							    * {* 									    * M {*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  * B {*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		    * {*									    *M {****************************************************************************  {++  { FACILITY:  {  {	VAXELN {  { ABSTRACT:  { 5 {	This module contains a VAX console terminal driver.  { 	 { AUTHOR:  { 6 {		Len Kawell, Darryl Havens, Kris Barker  24-May-1982 {  { / { NOTE 1:  Explanation of V3.2-00 debugging aid A {	Code has been added to the console driver to make it easier to  5 {	to debug, without having to change the source code. < {	What follows is a sample .DAT file for EBUILD which shows @ {	how one could debug the console driver using the new debugging	 {	scheme:  {	n { characteristic /remote_cli /noconsole /noserver /objects=1024 /ports=512 /loader=512 /p0_virtual_size=2048 -& { /p1_virtual_size=1024 /io_region=256d { program CONSOLE /initialize /debug /kernel_stack=8 /mode=kernel /job_priority=2 /argument=("FRED")3 { program ELN$:JOBCNTRL.EXE /argument=("", "SFRED") 9 { device XQA /register=%O774440 /vector=%O120 /priority=4 & { device FRED /vector=%XF8 /noautoload { J {       Note that you have to include the console driver as a PROGRAM withB {	/DEBUG in order to debug it.  Also, the program argument must beE {	something other than CONSOLE ("FRED" in the above example) and this @ {	other name must match the name of the device described in the E {	EBUILD device menu for the console.  The device must be /noautoload B {	so that the CONSOLE program specified will be picked up for the  {	device driver.E {	The program ELN$:JOBCNTRL.EXE is not necessary, but if included, it - {	allows ECL to start running on the console.  {  { MODIFIED:  { " {	V1.0-01	Kris Barker	25-July-1984@ {		Modified transmit logic to output characters from with ISR to. {		eliminate context switch on every character { ! {	V2.0-00 Gary Kimura	26-Nov-1984  {		Added calls to stack utility  { ! {	V2.0-01 Kris Barker	19-Dec-1984 = {		Added check of xmt_waiting flag to output ISR so device is % {		not signalled if no one is waiting  { ! {	V2.0-02 Kris Barker	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  /                        % $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                              "            19-Feb-1985 > {		Added code to delete the console device should an exception; {		occur.  Modified the exception handler output routine to 2 {		output by polling rather than interrupt driven. { 9 {	V2.1-01 Kris Barker/Eric R Schott 3-July-1985  (ers006) # {		Fixed software xon/xoff handling  { 0 {	V2.1-02 Eric R Schott	15-August-1985		(ers009)/ {		Added handling of VFC record format on input  { 0 {	V2.1-03 Eric R Schott	15-August-1985		(ers010)3 {		Fixed open_routine to set maximum_record_size to 1 {		max_read_buffer_size if maximum_record_size is % {		greater than max_read_buffer_size.  { 1 {	V2.1-04 Eric R Schott	6-September-1985	(ers029) 4 {		Removed rewind_routine and added truncate_routine2 {		(to be compatible with other terminal drivers). { 6 {	V2.2-00 - November 18, 1985 - Eric R Schott	(ers060)3 {		Added checks for dead await_control_key circuits  { 6 {	V2.2-01 - November 21, 1985 - Eric R Schott	(ers065)5 {		Modified transmit interrupt control to work across  {		most processors.  { @ {	V2.3-00 - June 3, 1986 - Eric R Schott, Scott H Davis (ers097) {		Updated to support ACP. { " {	V2.3-01 - March, 1987 - B. Ziker {		Replace sea$ with topd$ { & {	V3.0-00 - August , 1987 _ A. Kessler2 {		Console name string includes BI number and node {		for ASMP environment. { ) {	V3.1-00 - January 4, 1988 - S. Ducharme ) {		Modified for performance enhancements.  { * {	V3.1-01 - January 21, 1988 - S. Ducharme4 {		If the line is in PASSALL mode do not signal data {		overrun errors.* {	V3.1-02 - February 1, 1988 - S. Ducharme= {		Correct problem where the driver would enter a dead locked 9 {		state if the input buffer overflows while a read is in  {		progress. { % {	V3.2-00 - June 10, 1988 - J. McGray 1 {		Added DDA support for the following functions: ) {		  dda$_fnc_get_char, dda$_fnc_set_char  { 3 {		Added code to ease debugging - see NOTE 1 above.  { " {	V3.2-01 - July 5, 1988 - R. Pfau= {		Tie console driver to primary cpu. Needed for smp systems  A {		where interrupts come in on all cpus and we don't tie drivers   {		in create_device. { % {	V3.2-02 - July 12, 1988 - J. McGray  {		Set eightbit through DDA. { % {	V3.2-03 - July 12, 1988 - J. McGray ) {		Take eight_bit checking out of the ISR  { % {	V3.2-04 - July 13, 1988 - J. McGray $ {		Change Parity_type to enumerated. { % {	V3.2-05 - July 25, 1988 - J. McGray 7 {		Fixed bug in get_action that caused cntrl characters  {		to not work correctly.  { # {	V3.2-06 - July 29, 1988 - R. Pfau @ {		Don't use ** to convert primary cpu # to eligibility mask, so( {		we don't bring in the DMATH routines. { ' {	V3.3-00 January 18, 1989 - J. McGray	 3 {		- Added DDA support for the following functions: : {		  dda$_fnc_read (min/max reads, timeout, and reads with: {		  a terminating mask of characters) and dda$_fnc_write.2 {		- Change priority of main process to 6, from 7. { ' {	V4.0-00 January 25, 1989 - J. McGray	 3 {		- Added support for line PASSTHRU characteristic / {		  and the READ_PASSTHRU read characteristic. ? {	    ********************************************************* ? {	    *** All user-written drivers MUST use the new definition  : {	    *** of terminal_flags for the call to TC$READ_CHARS.? {	    ********************************************************* 6 {		  Line PASSTHRU is now in the line parameter record# {		  that is passed in from EBUILD. / {		- Changed console_flags to console_line_char 4 {		  and renamed console_data to console_struc to be8 {		  more consistent with other VAXELN terminal drivers. { < {	       - Changed handling of isr events to fix the problem5 {		 where an event could potentially get lost, due to 6 {		 multiple event(s) occurring before the main driver {		 process could unblock.@ {	    **********************************************************; {	    ***	 ALL user_written drivers must use the method of  9 {	    ***  processing isr events.  Note that EVENT is now ? {	    ***  defined differently in the TERMINAL_READ_DATA record ; {	    ***  and that CNTRL_CHAR and CNTRL_CHAR_POS no longer 2 {	    ***  exist in the TERMINAL_READ_DATA record.@ {	    ********************************************************** { $ {	V4.0-01 March 2, 1989 - J. McGray	3 {		- Added out-of-band signalling functionality for * {		  the following user-callable routines:" {			ELN$TTY_SIGNAL_OOB_CHARACTERS " {			ELN$TTY_CANCEL_OOB_CHARACTERS ! {			ELN$TTY_RECEIVE_OOB_CHARACTER 1 {	 	- Renamed EVENT (in line_Ctx) to EVENT_FLAGS.  { " {	V4.0-02 May 2, 1989 - J. McGray	5 {		- Check for overflow error status in dda$tty_Read. 9 {		- Don't allow DDA read timeout value to be an absolute 
 {		  time." {	V4.1-00 Dec 4, 1989 - A. Kessler3 {		Don't send a character in put_chars at the same  4 {		time that interrupts are enabled for TXCS. Output5 {		interrupt service sends all characters. Workaround  {		for Rigel processor.  {  {--}    : include $dap, $termclass, $stack_utility, $mutex, $kernel; include $dda_utility;  include $kernelmsg;  include $elnmsg;* %include 'topd$:[kernel.src]kerneldef.pas'   const '     driver_class 		= dda$_class_tty;    $     device_type 		= dda$_type_con;    / { Console terminal processor register numbers }   3 	rxcs_number	= 32;			{ Receive control and status } , 	rxdb_number	= 33;			{ Receive data buffer }4 	txcs_number	= 34;			{ Transmit control and status }- 	txdb_number	= 35;			{ Transmit data buffer }   : 	max_read_buffer_size	= 512;		{ Maximum read buffer size }9 	input_buffer_size	= 32;		{ Input interrupt buffer size } 6 	xmt_buffer_length       = 32;		{ Size of xmt buffer }  
 	oddp = 0;
 	even = 1;  % 	ipl$_power = 31;			{ Powerfail IPL }    	carriage_return = 13; 	line_feed       = 10; 	control_s	= 19; 	control_q	= 17;  6 	handle_xon_xoff = true;		{ Handle XON/OFF in driver }  $ 	{ Default Console characteristics } 	default$hardcopy	= true;  	default$ANSI_escape	= true; 	default$echo		= true; 	default$passall		= false;! 	default$eightbit        = false;  	default$passthru	= false;   type       { timing queue records }     queue_record = record  	entryq      	: queue_entry;; 	line	   	: integer;	   {line number - always 0 in console} > 	time_at_timeout : large_integer;   {absolute time at timeout}= 	evnt		: timeout_event;   {type of timeout we are requesting} C 	ignore_timeout  : boolean;  {true if there is not longer a  need } A     end; { record }		    { for this timer. ie ignore the timeout}        line_timer_state = record ? 	io_tmo_started	       : ^queue_record; {latest io timer entry}  	{ Could add other timeouts }      end; { record }			       timeout_event = (  		{ / 		{	The following events are used to signal the 5 		{	main process (controlling process) for a timeout.  		{} 		evnt$noevnt,			{no event}  		evnt$io_tmo			{I/O timeout}  		{  		{ Could add other timeouts 		{} 		);   byte = 0..255; word = 0..65535; word1 = [word] 0..65535;  ) { Console terminal register definitions }  	 D 	rxcs_register = [long] packed record { Receive control and status }- 		ie: 	[pos(6)] boolean;	{ Interrupt enable } # 		done: 	[pos(7)] boolean;	{ Done }  		end;  = 	rxdb_register = [long] packed record { Receive data buffer } * 		ch: 	0..255;			{ 8-bit ASCII character } 		end;  E 	txcs_register = [long] packed record { Transmit control and status } - 		ie: 	[pos(6)] boolean;	{ Interrupt enable } # 		rdy: 	[pos(7)] boolean;	{ Ready }  		end;  : 	input_region_def = record		{ Input communication region } 	line_ctx : terminal_read_data;  		end;  < 	output_region_def = record		{ Output communication region }3 		index       : integer;		{  current output index } 3 		chars_out   : integer;		{  # of chars to output } " 		xmt_buffer  : 			{  xmt buffer }  		    string(xmt_buffer_length);( 		xmt_waiting : boolean;		{  wait flag }1 		write_enable : boolean;		{  write enable flag }  		end; 		 	port_ptr = ^port;  # 	{ Console line parameters record } $ 	ln_param_rec = [byte] packed record  	    echo          : boolean;			'             passall       : boolean;			 '             hardcopy      : boolean;			 '             ANSI_escape   : boolean;			  	    eightbit      : boolean; '             passthru      : boolean;			  	end; { record }  5 	{ Line configuration record sent by system builder }  	builder_params = packed record = 		dummy_word        : word;    {length of the varying string}  		line              : integer;,                 parity_enable     : boolean;/                 sense             : oddp..even; ,                 modem             : boolean;,                 hardcopy          : boolean;,                 ANSI_escape       : boolean;,                 echo              : boolean;,                 pass                                                                                                                                                                                                                                                   0                        , $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             A' "            all           : boolean;,                 ddcmp_protocol    : boolean; 		cli		  : boolean;  		passthru	  : boolean; 3                 character_length  : [pos(64)] byte; )                 stop_bits         : byte; (                 comm_speed        : word     		end; { record }    	dda_line_struc = recordQ 	    dda_terminal_char_lock : mutex; {lock for accessing console characteristics}  	    host_sync	: boolean; 	 	    end;   # 	{ Circuit process data structure }  	ct_data_base = record5 	    port             : port;       {connecting port} :             read_buffer_size : integer;    {record length}             end; { record }  	ct_ptr = ^ct_data_base;   	event_record = packed record " 	    local_event: isr_event_flags;H 	    local_nbr_cntrl_chars: integer;   { Number control chars received }E 	    local_cntrl_char_idx: integer;    { Index into typhd buffer of } 5 	end; {record}			      {  first cntrl char received.}  	    var : 	timer_queue	 : queue_entry;   {header of the timer queue}H 	timer_complete_q : queue_entry;   {queue of completed timeout requests}> 	request_queue	 : queue_entry;   {header of the request queue}8 	sync_lock	 : mutex;	  {access lock for timing elements}3 	my_timer	 : large_integer; {for get_time routines} @ 	new_timeout 	 : large_integer; {absolute time of next timeout} % 	line_timer_struc : line_timer_state;     	dda_port: port;				{ DDA port }5 	dda_port_name: varying_string(32);	{ DDA port name } / 	dda_process_name: name;			{ DDA process name } / 	dda_struc : dda_line_struc;		{ DDA variables } ' 	console_job_port: port;			{ Job port }   	job_name: name;				{ Job name }( 	circuit_port: ^port;			{ Circuit port }& 	process_id: process;			{ Process ID }8 	signalled_object: integer;		{ Signalled object number }  , 	input_device: device;			{ Input device ID }. 	output_device: device;			{ Output device ID }@ 	input_region: ^input_region_def;	{ Input communication region }C 	output_region: ^output_region_def;	{ Output communication region } ; 	interrupt_priority: integer;		{ Interrupt priority level }   7 	{ Renamed console_data to be like the other terminal }  	{ drivers (eg. dz_struc) } C 	console_struc  : terminal_data_pointer;	{ Console data structure }   & 	put_lock: mutex;			{ Put_chars lock }  ) 	{ Console characteristics and defaults }   ) 	argument_string	  : varying_string(100); A 	console_line_char :  ln_param_rec;  { Console line data base.. } ' 					    {  filled in from EBUILD and }  					    {  updated by DDA }  2 	rxcs: rxcs_register;			{ RXCS register variable }   	cr : string(1) := ''(13); 	bell : string(1) := ''(7);  var ' 	ker$gb_cpu_type: [external,byte] byte; ' 	ker$gb_sys_type: [external,byte] byte; ' 	ker$gb_bi_number: [external,byte]byte; * 	ker$gb_node_number:  [external,byte]byte;: 		{ flag , if set  indicates this is an ASMP environment }* 		{ and this is a secondary processor.			}% 	ker$gb_ptooey: [external,byte]byte;  9         ker$gl_primary_cpunum:			{ cpu # of primary cpu }  		[external] integer;          ker$gb_smp_flags: ) 		[external] smp_flags_def;	{ smp flags }   B 	sync_event  : event;   {event used to synchronize initialization}     program console;   {++  { B { Main driver procedure.  Performs program initialization and thenA { waits for requests for service in the form of circuit requests. A { When a circuit is accepted, a process is created to service the ? { circuit.  This allows each circuit complete independence from B { other circuits (except where shared resource synchronization is ? { required).  In other words, the device appears as a sharable,  { full-duplex device.  {  {--} var  	my_proc: process;% 	time_interval, timer: large_integer;  	acp: boolean; 	vector_num: integer; > 	bi_num : byte;{ 0-15 hex ,represented as an ascii character }? 	bi_node : byte;{ 0-15 hex, represented as an ascii character } . 	console_def : varying_string(12):= 'CONSOLE';B 	console_dev : varying_string(12);  {Added for debugging purposes}   	read_started: ^semaphore; 	status: integer; M         circuit_db   : ct_ptr;	        {pointer to circuit data base struct.} >         elig : job_eligibility_mask;    {job eligibility mask}E 	temp_elig_mask : packed array [0..15] of boolean; {Temp storage for  # 					converting cpu # to elig mask}  	request_timer   : event;     	timeout_occurred: ^semaphore;   	sub_process	: process;    begin   ) eln$allocate_stack(4096); { eight pages }   / { Create a well-known name for the job's port } ? { Include the BI number and adapter number in the name string } ; { if this is a secondary processor in an ASMP environment }o   job_port(console_job_port);*  H { Use either the name given as argument 1 or 'CONSOLE' if no argument 1}F { Assume debug mode if program argument is not 'CONSOLE', and DO NOT }H {  establish the exception handler, so user doesn't have to modify the }# {  source code in order to debug. }C  % console_dev := program_argument( 1 );    if console_dev = '' then H	     beginF      	console_dev := console_def;'     	establish(console_driver_handler);C     endS else     console_def := console_dev;      if odd(ker$gb_ptooey) then	     beginD! 	bi_node:= ker$gb_node_number+48;E 	if bi_node>57 thenD 		bi_node :=bi_node+7; 	bi_num:=ker$gb_bi_number + 48;R 	if bi_num > 57 then 		bi_num := bi_num + 7;NF 	console_def := console_def + '_' + bi_num::char + '_' + bi_node::char     end; { if ptooey } 	S5 create_name(job_name, console_def, console_job_port);O   create_port (dda_port);	) dda_port_name := console_def + '$ACCESS';O   create_name (dda_process_name, 	     dda_port_name, 	     dda_port);	N   {C$ { Create the Put_chars write lock. }   create_mutex(put_lock);*   with dda_struc do*	     begin*& 	create_mutex(dda_terminal_char_lock); 	host_sync := false;     end;  ) { Initialize pointers to timing records }V( line_timer_struc.io_tmo_started  := nil;  1 { Set the default console line characteristics: }- with console_line_char do 	     beginn 	echo        := default$echo;o  	passall     := default$passall;! 	hardcopy    := default$hardcopy;d$ 	ANSI_escape := default$ANSI_escape;! 	eightbit    := default$eightbit;p! 	passthru    := default$passthru;      end;  * { Get the EBUILD console characteristics }* argument_string := program_argument ( 2 );   if argument_string <> '' then +     with argument_string::builder_params dou 	begin+ 	    console_line_char.echo        := echo;6. 	    console_line_char.passall     := passall;6             console_line_char.hardcopy    := hardcopy;9             console_line_char.ANSI_escape := ANSI_escape;i; 	    console_line_char.eightbit    := character_length = 3;e7             console_line_char.passthru    := passthru;   	end;   I { Connect interrupt service routines to the input and output interrupts }   oM if ((ker$gb_cpu_type = pr$_sid_typ630) or (ker$gb_cpu_type = pr$_sid_typ620))b,     and (ker$gb_sys_type = pr$_sidex_typ800) then 	acp := true else 	acp := false;   if acp then 	vector_num := 2 else 	vector_num := 1;   B {Make driver run on primary if a symmetric multiprocessing kernel}  % if ker$gb_smp_flags.ker$v_smp_kernel a    thenB
         begint? 	    temp_elig_mask := zero;	{Use temporary variable to convertn 					 from cpu # to bitmask}3 	    temp_elig_mask[ker$gl_primary_cpunum] := true;e- 	    elig.as_a_word := temp_elig_mask::word1; - 	    ker$set_job_eligibility(,elig);         a 	end;    create_device(	console_dev,v 		input_device,c 		vector_number := vector_num, 		region := input_region,8! 		priority := interrupt_priority,l% 		service_routine := input_interrupt,s" 		powerfail_routine := powerfail);   if acp then 	vector_num := 1 else 	vector_num := 2;    create_device(	console_dev,c 		output_device, 		vector_number := vector_num, 		region := output_region,' 		service_routine := output_interrupt);.     {	! { Initialize the typeahead buffer- {}  3 tc$initialize_typhd_buffers(input_region^.line_ctx,  			    handle_xon_xoff,t! 			    console_line_char.passall,d" 			    console_line_char.eightbit,# 			    console_line_char.passthru);A {s$ { Create the read started semaphore. {}     new(read_started);*     create_semaphore(read_started^, 0, 1);   {i" { Create the synchronization event {}/     create_event ( sync_event, event$cleared );9   { $ { Create the request-for-timer event {}2     create_event ( request_timer, event$cleared );   {n { Create the timeout semaphore {}!     new(timeout_occurred); 						)2     create_semaphore(timeout_occurred^, 0, 1); 			   { Start the timing queues: }      start_queue ( timer_queue );%     start_queue ( timer_complete_q ); "     start_queue ( request_queue );  4 { Sync_l                                                                                                                                                                                                                                                   1                        ٭ $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             ܾ "     )       ock controls access of the timing records: }     create_mutex ( sync_lock );r   { Create the timing process }8     clear_event ( sync_event );h!     create_process ( sub_process,8 		     timer_process,o 		     sync_event, 		     timeout_occurred, 		     request_timer);       { Wait for completion }      wait_any ( sync_event );     delete (sync_event );   - { Create the data structure for the console }   3 tc$allocate_terminal_data ( console_struc, 0, true,	 			 read_started,	" 			 output_region^.write_enable );    & { Enable input and output interrupts }  
 rxcs := zero;l rxcs.ie := true; mtpr(rxcs_number, rxcs);   initialization_done;   {oO { Bump up the process priority of the dispatcher - note: this assumes a defaultfH { process priority of 8 for the line and circuit processes and that the I { process priority of the line and circuit processes will not be below 7.9 {}   current_process(my_proc);e. set_process_priority(my_proc,read_priority-1);  ( time_interval := time_value('0 0:0:20');   get_time(timer); timer := timer - time_interval;0  ? { Continually wait for input interrupts and connect requests. }	 repeat 	begin   	wait_any(input_device,  		 console_job_port, t 		 read_started^,	 		 dda_port, 	         timeout_occurred^,	g 		 result := signalled_object,   		 time := timer);   	case signalled_object ofb  1 	0:	{ check on pending get control key requests }    		beginr$ 		tc$cleanup_ctrl_key(console_struc,  				    input_region^.line_ctx); 		get_time(timer);! 		timer := timer - time_interval;' 		end;  ) 	1:	{ Process received input characters }  		begin-( 		process_event(	input_region^.line_ctx, 				console_struc, 				console_line_char.passall) 		end;    : 	2:	{ Accept a circuit and create a process to service it}   		beginn#                 new ( circuit_db );n1                 create_port ( circuit_db^.port );9  2                 accept_circuit (console_job_port, >                                 connect := circuit_db^.port );  ,                 create_process ( process_id,0                                 circuit_process,-                                 circuit_db );    		end;   	3:	{o 		{ Read posted:4 		{ 	A read has been started.  Check to see if there& 		{	are any characters in the buffers. 		{} 		begine 		    with console_struc^ do 			if read_started 			then 	 				beging  				tc$process_input_characters( 					input_region^.line_ctx, 					console_struc);= 				if input_region^.line_ctx.usr_ptr^.event_flags <> [] then.
 					begin, 					{ The buffers must have been swapped. }- 					{ The USR events have to be processed. }g+ 					process_event(	input_region^.line_ctx,r 							console_struc,v" 							console_line_char.passall);! 					tc$process_input_characters(* 						input_region^.line_ctx,  						console_struc);r	 					end;u 				read_started := false* 				ends 		end;  > 	4:	{ Accept a circuit and create a DDA process to service it}   		beginN 		new(circuit_port); 		create_port(circuit_port^);a   		accept_circuit(	dda_port,	 				connect := circuit_port^);   		create_process(	process_id,  				dda_circuit_process, * 				circuit_port,* 				request_timer ); 		end;  5 	5:	{ Timeout was signalled from the timer process: }l   		begin	, 		    process_timeout_event (request_timer); 		end; {case = 5}C   	end; {Case}   	{: 	{	Now that we have processed the line that needed service? 	{	check to see if any I/O has completed for the console line. 0> 	{	An I/O completion is deferred until now so that all buffers8 	{	that need swapping are processed as fast as possible. 	{}b   	with console_struc^ do % 	if io_done AND read_in_progress thenD
 	    begin1 		Cancel_timer (line_timer_struc.io_tmo_started);i+ 		signal( read_complete, status := status);t 		io_done := false;a 		read_in_progress := false;	 	    end;p   	end; {repeat}   until false; end.   r: procedure process_event(var line_data: terminal_read_data;' 			var terminal: terminal_data_pointer;s 			passall: boolean);r   {++] {n# { process_event - Process ISR events {= { Routine Description: {e; {	This procedure will process events signalled by the inputr {	ISR for each line. {r	 { Inputs:= {;' {	line_data   - Line typeahead buffers._( {	terminal    - Internal line data base.D {	passall	    - True if input characters should be processed without {		       intrepretation.  { 
 { Outputs:9 {	line_data   - Line typeahead buffers possibly modified.e( {	terminal    - Internal line data base. {  {--}   {e {	Local variable declarations. {}   var} 	stat		    : boolean;  	status		    : integer;	, 	i		    : integer;	{ General purpose index } 	control_char	    : char;n 	first_one	    : boolean;1 	next_element	    : integer; 	found_one 	    : boolean; 	disposition	    : byte;' 	remove_from_data    : boolean := true;e$ 	local_event_record  : event_record;! 	temp_ptr	    : typhd_buffer_ptr;l? 	done 	    	    : boolean := false;  { true if working on ISR }	: 			     { EVENTS and have finished processing USR EVENTS } 			     { if there were any. }   beginn   { 1 {	Determine what needs to be done based on eventsc {	signalled by the isr.  : {}   While not(done) do begina  : { Process any events left in the USR EVENTS array first. }, if line_data.usr_ptr^.event_flags <> [] then	     begin 1 	{ Copy USR event information to local storage: }{. 	with local_event_record,line_data.USR_ptr^ do
 	    begin 		local_event := event_flags;	 		event_flags := []; 	l+ 		local_nbr_cntrl_chars := nbr_cntrl_chars;m 		nbr_cntrl_chars := 0;r 		) 		local_cntrl_char_idx := cntrl_char_idx;  		cntrl_char_idx := 0; 	    end; {with}     endp else	     beginn4 	{ Process any events left in the ISR EVENTS array }1 	{ Copy ISR event information to local storage: } ' 	disable_interrupt(interrupt_priority);y. 	with local_event_record,line_data.ISR_ptr^ do
 	    begin 		local_event := event_flags;i 		event_flags := [];  + 		local_nbr_cntrl_chars := nbr_cntrl_chars;o 		nbr_cntrl_chars := 0;o  ) 		local_cntrl_char_idx := cntrl_char_idx;  		cntrl_char_idx := 0; 	    end; {with} 	enable_interrupt; 	done := true;     end;     with local_event_record do begint  ( { See if there is an event to process: } if local_event <> [] thenr beginc  *     if evnt$input_xoff IN local_event then 	if terminal^.xon_xoff 	then	 		with terminal^ doe 			begin 			clear_event(write_enable);o 			write_ena_flag^ := false; 			end;n    )     if evnt$input_xon IN local_event then_ 	if terminal^.xon_xoff 	theno 		with terminal^ do  			begin 			write_ena_flag^ := true;t 			signal( write_enable);  			if overflow_pending theno	 				begin	# 				stat := put_chars(line,1,bell);  				overflow_pending := false; 				end; 			end;a    +     if evnt$cncl_typahd IN local_event then  		beginb) 		    { Clear the user typeahead buffer } " 		    line_data.usr_ptr^.put := 0;1 		    { Clear a possible evnt$control_char event} 7 		    local_event := local_event - [evnt$control_char];a 		end;    ,     if evnt$control_char IN local_event then	     beginc     if done then! 	{ We are processing ISR events }  	temp_ptr := line_data.ISR_ptr     else! 	{ We are processing USR events }r 	temp_ptr := line_data.USR_ptr;e       with temp_ptr^ doa%     if local_nbr_cntrl_chars > 0 thend	     beginh   	first_one := true;	{init}  7 	{ Use local_cntrl_char_idx as the index of the first }  	{ control character found: }e# 	while local_nbr_cntrl_chars > 0 do 
 	    begin  	    	found_one := false; {init}  @  	        { Use local_cntrl_char_idx as the index of the first }& 	        {  control character found: } 	        if first_one then 		    begina6 	    	    	control_char := data[local_cntrl_char_idx];B 		    	next_element := local_cntrl_char_idx; {NEXT_ELEMENT is the}= 			    { element following the cntrl character just removed.}  		    	first_one := false; 		    	found_one := true;e	 		    end 
 	        else;@ 		    { Search the EVENTS array for the next control character }? 	    	    while ( (not found_one) AND (next_element < put) ) doh 			begin3 			    if ((events[next_element].error = false) ANDu@ 			   	(events[next_element].event_type = et$control_char)) then 		 	    	begin+ 				    { Found the next control character}r 		    		    found_one := true;/ 			    	    control_char := data[next_element];e 			        end 			    else % 				next_element := next_element + 1;  			end;r   	    	if found_one thenN, 	    	    { Process the control character: } 		    begini> 		    	{ Bump any process waiting for the control character. }2 		    	disposition := tc$check_oob_char( terminal, 						    line_data, 						    control_char);  ) 			{ Default                                                                                                                                                                                                                                                   2                        Җ $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             xT "     :        to disposition = remove_it }u 			remove_from_data := true;   			if disposition = keep_itn 			thene 				remove_from_data := falsen' 			else if not(disposition = remove_it)g 			then}" 				if terminal^.read_in_progress  				then 					remove_from_data := false) 				else if disposition = keep_if_no_read  				then 					remove_from_data := false;d   			If remove_from_data then ' 			    { Remove the character from the} ( 			    {  the typeahead buffer and the } 			    {  events array:  	  		    {}l	 				begin	 				    { *** Device IPL *** }. 				    disable_interrupt(interrupt_priority);& 				    if next_element < (put-1) then+ 				    for i := next_element to (put-2) dor
 					begin" 				    	    data[i] := data[i+1];& 				    	    events[i] := events[i+1];	 					end;I 				    put := put - 1;_ 				    enable_interrupt;d) 				    next_element := next_element - 1;f   				    { *** Normal IPL *** } 				end; {if remove_from_data }f 		    end; {if found_one}g 	 # 		next_element := next_element + 1;I0 		{ Decrement the count of control characters: }5 		local_nbr_cntrl_chars := local_nbr_cntrl_chars - 1;z  + 	    end; {while local_nbr_cntrl_chars > 0}n'     end; {if local_nbr_cntrl_chars > 0}l"     end; {if evnt$control_char IN}    /     if evnt$buffer_overflow IN local_event thenn       with terminal^ don 	begin/ 		{	If the terminal is not in passall mode thenl 		{	output the bell character. 		{}B 		if not(passall OR line_data.passthru OR line_data.read_passthru) 		then 			{( 			{	If xon and xoff support (TTSYNC) is' 			{	required check to see if output is  			{	disabled. 			{}e 			if terminal^.xon_xoff 			theny	 				begint 					if not(write_ena_flag^)	 					thenx 						overflow_pending := true	 					elsee% 						stat := put_chars(line,1,bell);i 				endt 			{+ 			{	If NO xon and xoff (TTSYNC) support iso( 			{	required just output the bell char. 			{}y 			else # 				stat := put_chars(line,1,bell);c   	end; {with}    ,     if evnt$io_completed IN local_event then  3 	{ If this line has a read in progress then process 2 	{ the data.  Otherwise, a race condition ocurred. 	{}l 	if terminal^.read_in_progress 	then 
 	    begin2 		tc$process_input_characters(line_data,terminal);. 		if line_data.usr_ptr^.event_flags <> [] then 		    beginc2 			{ USR events were cleared at the beginning of }( 			{ this routine, so if after calling }4 			{ tc$process_input_characters here it is NOT [] }/ 			{ then the buffers must have been swapped. }s- 			{ The read was not completed yet because }s5 			{ first the new USR events have to be processed. }i4 		        process_event(line_data,terminal,passall);3 			tc$process_input_characters(line_data,terminal);u
 		    end;	 	    end;        {1=     {	The CONSOLE driver does not recognize any other events.-     {}  	 end; {if}s  ' { Clear out the local event variable: }i local_event := []; end; {with}o   end; { while not() } end; d  9 procedure process_timeout_event	(request_timer : event );a   {++t {r { process_timeout_event  {_ { Routine Description: {r; {	This procedure will process all timeout events signalled.; {  {b {--} vary     stat	: boolean;s     status	: integer;]     i		: integer;	@     ptr 	: ^queue_entry;  { pointer to timer_complete_q entries}:     entry_ptr	: ^queue_record; { pointer to queue records}#     done_process_timeout : boolean;a     empty	: boolean;4     lkahd_flag	: boolean := true; { lookahead flag }   begin   "     done_process_timeout := false;  2     {Process each element of the timer_complete_q}%     while not done_process_timeout doo 	begin		    G     	    lock_mutex (sync_lock);  {make sure no one accesses the queue} $ 	    ptr := timer_complete_q.flink; ? 	    if ptr = address(timer_complete_q) then  {no more entries}e 		beginn* 	            done_process_timeout := true;&     	    	    unlock_mutex (sync_lock) 		ends/ 	    else    {there is at least one more entry}d 	        begin  3 	    	{Remove the entry from the head of the queue}b% 	    	remove_entry (timer_complete_q,S& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);   		{ See if it is still valid }# 		if entry_ptr^.ignore_timeout then	 		    beginn 			dispose (entry_ptr);i" 	    		unlock_mutex (sync_lock);  	 		    end: 	        else  c 		    begin 3 			{ Determine what needs to be done based on the }r  			{  timeout event signalled: } 			CASE entry_ptr^.evnt of   			EVNT$NOEVNT:) 			    begin) 	    			{ There is no event to process. }d 				dispose (entry_ptr);- 	    	    	        unlock_mutex (sync_lock)    			    end;t 	N 			EVNT$IO_TMO:t 			    begin 				{I/O timeout has expired}t0 				{ Delete the pointer to the timing record: }+ 				line_timer_struc.io_tmo_started := nil;:&     	    			unlock_mutex (sync_lock);  				with console_struc^ do 				if read_in_progress then
 				    begine& 					{ See if any characters came in }" 					{ during the timeout period }! 					tc$process_input_characters($ 						input_region^.line_ctx,$ 						console_struc, 						lkahd_flag);3 					if not io_done then io_status := eln$_timeout;  					io_done := false; 					read_in_progress := false;  					read_w_term_mask := false;n3 					input_region^.line_ctx.isr_ptr^.event_flags :=gK 					    input_region^.line_ctx.isr_ptr^.event_flags - [evnt$io_completed];l1 					signal(read_complete,status := status);					  				    end;6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;l   			OTHERWISE 			    begin 		            	{( 		            	{ Process other timeouts. 		            	{}e&     	    			unlock_mutex (sync_lock);  	    			dispose (entry_ptr);   		            end; 		        END; {case} * 		    end; {if entry_ptr^.ignore_timeout }  0 	    end; { if ptr = address(timer_complete_q) }.         end; {while not done_process_timeout }   end;  {procedure}    k? interrupt_service output_interrupt(console_registers: ^anytype;p* 				   output_region: ^output_region_def); {++e@ { Output_interrupt - interrupt service routine to handle output. {l	 { Inputs:g {r
 {	IPL = 20  {	Mode = kernel, interrupt stack { 
 { Outputs: { @ {	The next character in the xmt buffer is output.  If the buffer: {	has been emptied, the output device object is signalled. {--} vary 	txcs : txcs_register;   begina  2 { Make sure the device is ready to accept output }   repeat) 	txcs :: integer := mfpr ( txcs_number );c until txcs.rdy;n    I { Output more characters or signal device if done or write enable clear }o   with output_region^ do0 	if (not write_enable) or (index>chars_out) then 		begint 		if xmt_waiting thenf 			signal_device;_ 		txcs.ie := false;o 		mtpr(txcs_number, txcs);   		xmt_waiting := false;d 		index := index - 1;  		endo 	else  		begin:8 		mtpr ( txdb_number, ord(substr(xmt_buffer,index,1)) ); 		index := index + 1;t 		end; end;   -  - function put_chars of type output_characters;. {++ 0 { Put_chars - put characters to console terminal {--} vara2 	txcs: txcs_register;			{ TXCS register variable }% 	ignore: integer;			{ Ignore status }e' 	xmt_index: integer;			{ buffer index }(, 	num_chars: integer;			{ character counter }/ 	tomove:	   integer;			{ characters to output }e    7 [inline] function minimum ( a, b : integer ) : integer;  { 5 { This function returns the minimum of its two inputse {} begint if a <= b then
 	minimum := a  else 	minimum := b; end;     begin   G { Note: this routine ignores kernel service failures so as to be able }19 {	to output characters even when the system has failed. }i  O lock_mutex(put_lock);	{ Only allow one process at a time to execute this code }u   xmt_index := 1;  num_chars := number_of_chars;e  + { Output buffers of characters until done }    repeat  0 	{ Determine maximum chars to output this pass }  4 	tomove := minimum ( num_chars, xmt_buffer_length );) 	tc$check_write_enable ( console_struc );c 	with output_region^ dom 		begin < 		xmt_buffer := substr ( output_buffer, xmt_index, tomove ); 		chars_out  := tomove;  		index      := 1; 		end;     	{ Make sure device is ready }   	repeat ( 		txcs::integer := mfpr ( txcs_number ); 	until txcs.rdy;   	^1 	{ Output first character to start transmission .e7 	{ Don't output first character here. Enable interruptsu 	{ for txcs. Rigel workaround. 	{} " 	disable_interrupt ( ipl$_power );$ 	output_region^.xmt_waiting := true; 	txcs.ie := true;c 	mtpr(txcs_number, txcs);i  D 	{mtpr ( txdb_number, ord(substr(output_region^.xmt_buffer,1,1)) );}   	enable_interrupt;    	{ Wait for output to complete }  . 	wait_any ( output_device, status := ignore );  - 	{ Update counters and continue if not done }0  / 	xmt_ind                                                                                                                                                                                                                                                   3                        hlG8 $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                              "     K       ex := xmt_index + output_region^.index;m/ 	num_chars := num_chars - output_region^.index;r   until ( num_chars = 0 );   put_chars := true;, unlock_mutex(put_lock);	{ Release the lock }   end;   t7 procedure put_exception_line(str: varying_string(256));	 {++lE { put_exception_line - output a line of text to the terminal from theo {		       exception handler. {c	 { Inputs:r {e {	str - string to output.e {p
 { Outputs: {l$ {	String output to console terminal. {--} var_ 	i: integer; 	status : boolean; 	txcs: txcs_register;  	rxcs: rxcs_register;d 	rxdb: rxdb_register;	   procedure transmitter_ready; beginl repeat$ 	rxcs::integer := mfpr(rxcs_number); 	if rxcs.done then 		begin2% 		rxdb::integer := mfpr(rxdb_number);s 		if rxdb.ch = control_s then 	 			repeat ' 				rxcs::integer := mfpr(rxcs_number);r' 				rxdb::integer := mfpr(rxdb_number); * 			until rxcs.done and (rxdb.ch=control_q) 		end;$ 	txcs::integer := mfpr(txcs_number); until txcs.rdy;; end;   begin    transmitter_ready;" mtpr(txdb_number,carriage_return);   for i:=1 to length(str) do 	begin 	transmitter_ready;i( 	mtpr(txdb_number,ord(substr(str,i,1))); 	end;:   transmitter_ready; mtpr(txdb_number,line_feed);   end; r    > interrupt_service input_interrupt(console_registers: ^anytype;' 				  input_region: ^input_region_def);	 {++iH { Input_interrupt - interrupt service routine to handle character input. {o	 { Inputs:  {	) {	input_region - interrupt region pointera {<
 {	IPL = 20  {	Mode = kernel, interrupt stack {a
 { Outputs: {.4 {	Input character is added to the input ring buffer. {p@ {	If input buffer changed from empty to non-empty, device object {	is signalled._ {--}   const 
 	xon = 17; 	xoff = 19;r   type%     ASCII_char = [byte] packed record	 			low7 : 0..127;	 			high : 0..1 		        end; { record }n   varn 	rxdb: rxdb_register;r 	character: char;DQ 	bump_device: boolean := false;	{used to determine if device should be signalled}o   a   {	" {	Main routine for input_interrupt {}   begint  # rxdb::integer := mfpr(rxdb_number);d   {	 {	Handle the input character.i {}   with input_region^.line_ctx do   	if isr_ptr^.put > lengthn 	thenr 		beginm 		{o/ 		{ The input buffer is full.  If the character 6 		{ is XON or XOFF and we are NOT in passall mode then7 		{ inform the dispatcher that a XON or XOFF was found.r0 		{ Otherwise, bump the dispatcher with a buffer 		{ overflow condition.A 		{} 		if ( (tt_sync) and u 		     ( (rxdb.ch = xon) or  		       (rxdb.ch = xoff) ) ande 		     (not passall) )   	 	thent 			begin 				if rxdb.ch = xon then 
 				    beginsE 					isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xon]; F 					isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xoff]; 				    ends 				else
 				    begin  					isr_ptr^.event_flags :=  ) isr_ptr^.event_flags + [evnt$input_xoff];eE 					isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xon];	 				    end; 			        bump_device := true
 		        endS 		else 			begin' 			{ If the line is NOT in PASSALL modew" 			{ then signal a buffer overflow% 			{ condition. In any event rememberu' 			{ that an overrun condition occured.b 			{}_! 		        if ( (not passall) AND a 			     (not passthru) AND i 			     (not read_passthru) )o 			thent	 				begin X 		                isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$buffer_overflow]; 				bump_device := truen 				end; 			isr_ptr^.overflow := true;	 			end 		endd 	elsei 		begin  		character := chr(rxdb.ch); 		if passall 		then% 			tc$insert(input_region^.line_ctx, o 				character, 				bump_device) 		else 			tc$dispatch_character(n 				input_region^.line_ctx,f 				character, 				bump_device);i 		end;   if bump_device then 	signal_device;    end; c8 interrupt_service powerfail(console_registers: ^anytype;- 			    interrupt_region: ^output_region_def);  {++u0 { powerfail - powerfail recovery service routine {i	 { Inputs:s { 
 {	IPL = 31  {	Mode = kernel, interrupt stack {e
 { Outputs: {e {	Interrupts are re-enabled. {--} vare2 	rxcs: rxcs_register;			{ RXCS register variable }2 	txcs: txcs_register;			{ TXCS register variable } beginT   { Re-enable interrupts }   rxcs.ie := true; mtpr(rxcs_number, rxcs);    6 { If someone is waiting on output, signal the device }   with interrupt_region^ doU 	if xmt_waiting then 		begin_ 		signal_device; 		txcs.ie := false;= 		mtpr(txcs_number, txcs); 		xmt_waiting := false;m 		end;   end;   => procedure write_exception(var signal_args: chf$r_signal_args); {++x< {  write_exception - writes exception for exception handlers {a
 {  Inputs: {i! {	Exception signal argument list.S {--} varo 	arg: integer; 	ignore: boolean;b   beginu   put_exception_line('');w0 put_exception_line('Console driver exception ');/ put_exception_line(hex(signal_args.arg_count));l* put_exception_line(hex(signal_args.name));  : for arg := 1 to 20 do {** signal_args.arg_count - 1 do **}6 	put_exception_line(hex(signal_args.additional[arg]));   end;   e: function console_driver_handler of type exception_handler; {++r- {  console_driver_handler - Exception handlert {r
 {  Inputs: {c) {	Standard exception condition arguments.$ {--} varI 	dummy : integer;    beginn  G { Turn off device interrupts, display the error, and exit the process }e   mtpr(rxcs_number,0); mtpr(txcs_number,0); console_driver_handler := true;l write_exception(signal_args);. exit;f   end;   i9 process_block dda_circuit_process (dda_circuit: port_ptr;	# 				   request_timer     : event );l   {++i {tE { DDA Circuit process : This process is started to service a DDA I/O n! { request for the specified line.  { 
 { Inputs :7 {	dda_circuit - circuit to be used in DDA communication  {  { Outputs :	none {  {--}   vare7     dda_packet	     : ^dda$_packet;	{ dda message data}o     dda_message_obj  : message;v!     message_size     : integer;  c(     disconnect_status, status : integer;=     sgnl_oob_outstanding_ptr : ^boolean; { TRUE if there is } 0 			{ an outstanding request for oob signalling } 			{ on this circuit process. }s     R? function dda_circuit_process_handler of type exception_handler;^ {++ 2 {  dda_circuit_process_handler - Exception handler {f
 {  Inputs: {e) {	Standard exception condition arguments.t {--} beginh  % dda_circuit_process_handler := false;e write_exception(signal_args);> delete(dda_circuit^);  dispose(dda_circuit);i exit;   { Exit the process }   end;   x% { Main code for DDA_circuit_process }{ begino0     eln$allocate_stack ( 4096 ); { eight pages }+     establish(dda_circuit_process_handler);[  "     new(sgnl_oob_outstanding_ptr);'     sgnl_oob_outstanding_ptr^ := false;E       while true doe 	begin2 	{ Wait for a message to come in over the circuit} 	wait_any(dda_circuit^);   	receive  (  dda_message_obj,  		    dda_packet,	 		    dda_circuit^,T 		    size := message_size,c 		    status := status );    	If status = ker$_success then
 	    begin  @ 	 	{Request message must be at least the size of the dda header}) 		If message_size < dda$_header_size thent 		    begin) 			delete (dda_message_obj);0 	    	        goto dda$_circuit_process_return  
 		    end;  * 		CASE DDA_PACKET^.HEADER.DDA$_FUNCTION OF 	l 	    	    DDA$_FNC_GET_CHAR: 			begin 		    	    dda$tty_get_char( 				dda_message_obj,   		    		dda_packet,N 				console_line_char); 6 		    	    {original message is DELETED by the driver}5 		    	    { and a new one is created and returned. }o 	        	end; 	o 	    	    DDA$_FNC_SET_CHAR: 	    		begin 		    	    dda$tty_set_char( 		    		dda_packet,o 				console_line_char);v7 		    	    {original message is RETURNED by the driver}t- 		    	    { with just the status modified. }f 	    		end;i   		    DDA$_FNC_READ: 	    		begin 			    dda$tty_read( 		    		dda_packet,m 				message_size,l 				request_timer);s 	    		end;i   		    DDA$_FNC_WRITE:	 	    		begin 			    dda$tty_write(  		    		dda_packet,  				message_size); 	    		end;r  ! 	    	    DDA$_FNC_SGNL_OOB_CHAR:f 	    		begin 		    	    dda$tty_sgnl_oob( 		    		dda_packet,  				console_struc, 				input_region^.line_ctx,  				sgnl_oob_outstanding_ptr); 	    		end;_   		    DDA$_FNC_CNCL_OOB_CHAR:o 	    		begin 		    	    dda$tty_cncl_oob( 		    		dda_packet,[ 				console_struc, 				sgnl_oob_outstanding_ptr); 	    		end;d   	    	    OTHERWISE- 	    		begin7 			    dda_packet^.header.dda$_status := ELN$_INVALFUNC- 	    		end;            	END; {CASE}  =         	send(dda_message_obj, dda_circuit^, status:=status); A 		if not odd(status) then	 {Couldn't s                                                                                                                                                                                                                                                   4                        ,w $      ELN042.B                         
  &[SYSEXE.SEAS$WORK_0000005C]AJB8DXLVOyzb;1                                                                                     >                            I 2     X       oZ1.Gx	riLѻ$ԅLjC7;}3u
ݹ6+G}7ʉQ|u΢}Xks^Zz!%_qF ?-(ys-"뒳f|r=(k0L]{oFsm
)\dMs(WC
4<I)IǠd/6 >*`5ܦaTG

FJ2Sann_YO{5ԦLPѺD[AT4UouӋp[yq~v`YMhW tV>&nT=_c&GXsB#1/omTE-{.~	AJ]˙N=س>VFxL"
!sloSJE^H-/sxfS0;4ŭWڽRr"A%/9cϯV?
m#_0.H	BOn 2]]RNN
m22ڋUwpjwbCMYluqrtMC2,oG՝"IM{r^8vXLޢ6'?m}Jk(gHzx
џVyao_D+sBjxv׹i(3agRzFzdRa?c)#wN޿؏/)5v.: ѧRi~LЄ!6~&9_f6'נ%4p柍ޭTF@$D3F5u|ot`FywHN9
?h4'*\M&/?Y1o2Ggu{&Ŀܘ!b&pj)eȜAW*c=3,ɻ!.N	/.uyNnEgb8
?ձRkZ:
)@;uTo~g,+K?A}g4mqcNc-^pPmHԓ󸽨ejo:єiMz}KFx'~yk*M
.#TZڇ) Yucpsdm98v-`*7tADL|:@<Y	-Ys^z\Bg[rΏOWFT*mBUF^.y0|'ڥn38n#I Pđ7[n[gBE/x+q&+.q*]")Rx)Kf}<u@U.}EKaؑd56%xdɕ6/<q5o⻓!9RNb6ertƇVW%t[rlK;<߹OI*%`USNYڋ Z %p\\]ĵNJr≇ǱdGع^1{>!Ag_BK_4x$T{k$1SϫߤzØ}tާޣ\x/UF(|`v}sdOΰh& {3ן[-pĘghafwc(+47MFI& Z
]1^&$<U.<UD)v+z)PF[h~ت.셸aݛSKl25ίT<hW7D1kOf9O^QC0 y'!MD9cHcR`P]C-wo
eG4NûWy+mpn]q*CŢzl9swwLԷW%<
7#n0jdu9|sڡH 4'A%5
ǆ<~F@(SD۷+;VRALƁ$7WD^%ꚑH>ъdfvt%8.7+x~AcO;M֥GvjNÎ'9ϬzG#.?]K<΁_{b{(Fù6q~7)\C
t>i#1l:}!&b̄L
A?f-zH2r,;G5ZT6
NFT[\^LO]/ueAy HPt
DRz0 S"Qi;'m_|\B>Mia89+Ҙ,l/眪2rX_z[dC8.	JkF2%OH88.kSAұ 8k9u{Bn꒥ŀ8%Ġ>t8ʋ
pz䠠vyM@Xv[&t2B+_U6"iZjoWy΅kjʭb'қD~d!6ĤLkm B7D{BtW]+l]A4󼠆| :R|I񼟝|0^LHЋ9N˂:|^bt 1f1O	,y/&ʱV;sg
caa{iZIxjT	Yeeα^8D贴T=p%b]rE4F㧏ji;ݮuFlE}	m;?SŰ10Ecc|	XZQ鼄6mQ-^;hX-
ŊY#.VmIa"Qx*Mk]L:?%;?IߞCg(n},%*7s2z1ݮD?Ns.	9/> Gf6DAՃ56ːj:<#uP@=/%R,1E7Yd6L֧&\7Z#_|BF:K&;Zɮ5
jڝJt#|,.0hwy^JA65#P7_Z4p':
 P`N=3b¿#r'c iAeܼfluj󣤵!(l9ޠ`J}Qʑ=Z!N

G~Z$Dv}-6t Lu;*j	-\ɎgY1nLOR_
L9Lcǀκs/cl*We54!q-4"tr:AkT[Q'AK3$فBy(/rq?iIײ+?ag9fQ<]߭6ӅO㏗tf^DeDpf$N5k'"q-V0JA5vPXzJ\ʄnNMe)mNjaиxl`ѻP&l)KCO{w.*Cp("ܐE]&n+Mէ6 ,+~rrտ>!~[Ghx7:iL
j"rkăT{:b5F'ubs1B ߿*VH	W/U6|nV)%{B1u+@\7jYsfd9RJB(G]XӬ̶]9= g	.X/K޻fE`Z{/ K
1aB
Hؙd\FQJK.fy9So^BRjgk1w,^!XNu,mV)x rG
F0K%IYSauM#ZG/_oqI"}<e5p͞łWA? ypywںxb,Sa[18ZT{㘢J>;*8ka@ M:BJ<9ƻOĔPT/IP^Dd|^7N>}+˟h-BܓQO>j;ڣ"\T̳H<"֓(kvJ {ЌV%A7
<ck;
?:II=Th
ڟ>)PXJ
.
g]Qtdx.&RǜXAP_NNK6J-=J"giL8CFHPS>2l\'7anNϴ[}z l&%F
YeSno1"|<_*tK۸M]67YXx	iv2ZKYD^ Exm7Xtȴve?ޫәWQxOr_u#dnZQN7鞆6q_*N1@9>!c@d_4i.Bh&T#.wdZjCaa֫lWBƄQ-;;];?:=?Aט15o*sk@$]IIJYTH
mR[7is>CE")e+H&)l`
ȥޤ3&
*n$xE/Y*p559Szf
ejaG߲'תzJ+2Q٪REʃXYh6KB⼮cEyȓ8lpu&ɚJ+=LO{9(|c|q+S;Q:'Ys*Akȥ`L?z*O)zme)t묗TenwcV7,V.,H%ov%L;N^]t4z|B%|T+f$oYGKZiI>8f'%dWV"݃3ɢ>:wx_L9Yc|.NaDR|~Fz^b1`&.˵_[IBiTU
8zGT*HK,dv?;:cv91WR8Gvlj wuStn@&!WvRgGN8Jt)ҭ?yđC<ޑh	l3=xfE<zl0bޅӧh(Y&(Zr4R'@!B`B-!ބz
= )K/v6-zݥT:Y6|/:#N_lꕅOk0AST)l;DiD}}^jFc
^g2:$,̰D\JqБ7m>f73erJn#{NcϟN|$v-vۗf~[PYR:sWlwUD]53_<@4QNVonbs+S/zfCQ@
ϊ5LU
E)V#0hb0T/I)NfbdXV81ha0V/Xkd|_{	 @e~Bӆ.p[_m l8Bc<1eu2d;3g[xcNnVc=ge6&@
&j&w>$om"ݞ]MFo\f+BA&W6HXYڦ
d!$ uQQUޤyx
kX
Js*c_`	~q;{E\ZkS)#3r'5}`OhJmA
*Qe!;T&Z:V!Q6@GPIP	EQP,'WOn*T#xc
5B2c4oV
{>
k9֑^EwOS x!`u0WxDXR(@0(b	I;BBWC!]/@56᫠dg2/g7ܚ!´^
&;;ّThP:DHj	L7D<N ▃Y; $?FJUhBP~eAͤ8ko
ڈ RNC#:9mt[KT4HȻXƨ^m#.RzDI_6ȴ7Y~(Nj{X ;{y"Zk}lK1Չ%E,MGJ@{O?kPڱܛc<~"zL癰1aoL-x\KU6SjAmosYy\,괎i<mVƌY8b^N1	:bҒT=*!8D}&];+"rTV$[גbGvܜc#_+NJ~If4KSM_;jefP0><[51|L`s(S;1=^7]-ZE yGWxpg.'Bt1'֐eg--sX?df=:.?v%\&s6;]"LTLMH!$nh &
ӳU0z,d+nYX~;aP'. \:S:\!!PJ=Z^nҳױ^k.`m9kHSȏ:dNIΤg6qE'kI
XAJu
gߠP`G\}=/tIv\('Y
^0gDwo<J-J>O(+53PV6F
ҝO"`/9N#Nh8#olosU7La[Xlk͙J4ZX;z`E^#Ct޿m/O
	i\MUM`d:[ƃ
Gd5B8!*,+`	_],"L@ݔw[+(ua}䒕OP^W^ħşF!Ft[zceu:ؙ7~W?PJCsomw<n Rqz D{A[~p;&Tcvh
QR-	9A$?sLBa"[Hf֎i.-ZfN3{dcovx7QB RKSUJ0:lOVK'Um073
U#ey7~ұ1y2:ʞ:S쫫k$ka
i[̏`[a5SΡdx"r&!j^L]|wQґC .x<úU(-ʓ-}yv{O
3{
L}[95Z7I?-&=Xg^Πcgk~
b&Xz48Ă@(c_X^vpob'a*Hiɥ柺Tt/N(U2?0YLuHl K{2R4_v߲9*衾mb<qF3yt<X.BNP#$6@$1+#,I65EYmhzL벦KyElOIhV;ⲥw6#iuV&3:yX#jHA|
.puPzFPw{iF#Yxyu-p2_-{98US>PKBjQ/q+LP;ɇitSYMa92PF-i2+ZĜ"OqڭΗY]_3RiG0K(n	J:S6ÎqCvh96=0Wmgr
7x`.ٻ{``[gR
mAj{NőDF&0 %A?e3d@u >oL^ϙd+c.znFtӚZb>eJad"SndYw]%
%LS]c8fاW~lW?쿾'zӜ'Ս^"s0.&0@t&Q[T9,)F=;{2ǻiH7!X7]dU5t܍Q,:;3:OwA^?'Ws6U{MV1֡fخu t꣐KE>RSaDprR$(j-wzg$Nwf{]p\

VL%?2|4`qީVhʃ6Y6+|P)t!Oʱl{lNSӇ{5=*V Gcy0GM]Am̑o	R3N4ՑN"[l)ǯH]d`yDD=';Rs#nI: \?SxHS]?p6n{N(=MNOR8s.&c!3i+xz:e(b57+zfW=\^
.IX|V0ږq3(#>Ew0Jh[ h %K$oIyMXQ                                                                                                                                                                                                                                   5                        f~ $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             X "     \       end the message, delete it}c 	    	    begin: 			delete(dda_message_obj); 1 			{ Check if the circuit has been disconnected }c# 			if status = ker$_disconnect thenf( 			    goto dda$_circuit_process_return;
 		    end;  $ 	    end  {if status = ker$_success} 	elselD 	    If status = ker$_disconnect then   { circuit was disconnected }+ 	        goto dda$_circuit_process_return; e       end; {while true}	     DDA$_CIRCUIT_PROCESS_RETURN:> { If there is an outstanding request to be signalled for OOB } {  characters then cancel it: }i! if sgnl_oob_outstanding_ptr^ then{	     begin 4 	{ Delete a signal request queued for this circuit }- 	dda$_dequeue_circuit_reqs ( console_struc );	& 	{sgnl_oob_outstanding_ptr^ := false;}     end;" dispose(sgnl_oob_outstanding_ptr);  $     disconnect_circuit(dda_circuit^,& 		       status := disconnect_status);     delete  ( dda_circuit^ );s     dispose ( dda_circuit );   end;    P [inline] procedure DDA$_Dequeue_Circuit_Reqs (terminal : terminal_data_pointer);   {  {dK {  This procedure will dequeue an OOB signalling request for the specified . {  circuit, if one exists. _M {  NOTE: Currently there is only ONE queue for console (signal OOB characters;I {	 queue) and only ONE request per line per circuit.  Therefore, we only eH {	 need to search ONE queue for ONE request and cancel that request.  InE {	 the future, if a circuit gets disconnected and we have to clean up E {	 the requests for the circuit by calling dda$_Dequeue_circuit_reqs, 9 {	 THIS CODE WILL HAVE TO GO THROUGH ALL EXISTING QUEUES o {	 AND CANCEL ALL REQUESTS._ {n	 { Inputs:, {    terminal - line structure {n
 { Outputs:	 {    nonea {r {--} var	!     current_process_id : process;       begin (     current_process(current_process_id);!     tc$cancel_oob_chars(terminal,  		current_process_id); end;   o8 procedure dda$tty_get_char(var message_obj	   : message;( 			       request_ptr	   : ^dda$_packet;5 		               console_parameters  : ln_param_rec);u {v5 { dda$tty_get_char - Get the console characteristics.w {  {--}   type     char_response = record 	header: dda$_header;t, 	data_buffer: dda$_terminal_characteristics; 	end;g   var      new_message	: message;     response	: ^char_response;     status	: integer;e   begin;  A     { Driver creates a new message and deletes the original one } <     create_message(new_message, response, status := status);       if odd(status) then 	     beginsD 	{ Copy request header information, including unmodified user_data }2         response^.header := request_ptr^.header;    @ 	{ Return the size of the current revision of the data buffer. }  P         response^.header.dda$_buffer_size:= size(dda$_terminal_characteristics);  5 	delete(message_obj);  		{ Delete original message }	n: 	message_obj := new_message;	{ Return new message object }  1 	lock_mutex (dda_struc.dda_terminal_char_lock);  o  ) 	{ Fill in with console characteristics }h 	with response^.data_buffer do
 	    begin$ 	    	class         := driver_class;% 	    	dev_type      := device_type;   6 	    	revision      := dda$tty_terminal_char_revision;  . 	        host_sync     := dda_struc.host_sync;6 	    	tty_sync      := input_region^.line_ctx.tt_sync;? 		modem_control := dda$_modem_control_driver;  {not applicable}D  - 	    	echo 	      := console_parameters.echo;	2 	    	passall       := console_parameters.passall;:     	        passthru      := console_parameters.passthru;6 	    	escape        := console_parameters.ANSI_escape;2 		eight_bit     := console_parameters.eightbit;   6 	    	scope 	      := NOT console_parameters.hardcopy;   	    	parity        := false; 5 		parity_type   := dda$_parity_even; {not applicable}i 	    	char_size     := 8;      	    	ddcmp         := false; 3 		line_speed    := dda$_rate_none; {not applicable}h( 	    	modem_support := false; {no modem}  / 		{ No modem support, so just send back false }} 	    	ring 	      := false;c 	    	cd   	      := false;i 	    	cs   	      := false;, 	    	dsr  	      := false;  	    	dtr  	      := false;  	    	rts  	      := false;:
 	    end;	3 	unlock_mutex (dda_struc.dda_terminal_char_lock);     . 	response^.header.dda$_status := ELN$_SUCCESS;       end {if odd(status)} else	     begint! 	if (status = ker$_no_object) or o 	   (status = ker$_no_pool) or l 	   (status = ker$_no_memory)	 	thenn 	    status := ELN$_NORESOURC;  + 	request_ptr^.header.dda$_status := status;O     end;   end; {procedure}    @ procedure dda$tty_set_char( var request_ptr 	    : ^dda$_packet;6 		            var console_parameters  : ln_param_rec); {eC { dda$tty_set_char - Set the characteristics for the console, using{, {		  the new values from the message packet. {p {--}   type     set_char_request = record; 	header: dda$_header;s, 	data_buffer: dda$_terminal_characteristics; 	end;v   varp%     status	: integer := ELN$_SUCCESS;e     version	: integer;     temp_sync	: boolean;          beginr  C     { Make sure the received data buffer is at least big enough to} =     { contain the revision number, otherwise it is invalid. } I     if (request_ptr^.header.dda$_buffer_size < dda$_char_revision_offset)e     then 	status := eln$_invalrec     else 	beginE 	    version := request_ptr::^set_char_request^.data_buffer.revision;  	    {< 	    { Make sure the revision is valid, and if so, that the ? 	    { buffer size matches the size for that revision number: }l 	    {}f 	    CASE version of 		1:  beginiK 		    	if (request_ptr^.header.dda$_buffer_size <> dda$_char_1_buffer_size)i 		    	then  			    status := eln$_invalrec; 
 		    end; 	l 		2:  begintG 			if (request_ptr^.header.dda$_buffer_size <> dda$_char_2_buffer_size)	 		        then e 			    status := eln$_invalrec;u
 		    end;   		OTHERWISE; 		    begini 			status := eln$_invalrec;-
 		    end; 	    end; { CASE }
 	end; {if}  B     if status = ELN$_SUCCESS then	{buffer passed all the tests...} 	begin  5 	    lock_mutex (dda_struc.dda_terminal_char_lock);  :  8 	    with request_ptr::^set_char_request^.data_buffer do 		begin ? 		    { Only the following variables are settable for console }e/ 		    { Ignore all other user supplied values }n5 	    	    input_region^.line_ctx.tt_sync := tty_sync;sB 	    	    dda_struc.host_sync            := false; {unimplemented}1 	    	    console_parameters.echo        := echo;;4 	    	    console_parameters.passall     := passall;4 	    	    input_region^.line_ctx.passall := passall;3 	    	    console_parameters.ANSI_escape := escape;x7 	    	    console_parameters.hardcopy    := NOT scope;  2 		    console_parameters.eightbit    := eight_bit;8 	    	    input_region^.line_ctx.eight_bit := eight_bit;4 		    { PASSTHRU is not in the revision 1 terminal }3 		    {  characteristics record.  If the received }f6 		    {  set_char request is for a version 1 record, }% 		    {  the don't change PASSTHRU: }	 		    if version >= 2 then 			begin3 		    	    console_parameters.passthru := passthru;e7 		    	    input_region^.line_ctx.passthru := passthru;  			end;  		end;	:  7 	    unlock_mutex (dda_struc.dda_terminal_char_lock);  {   	    status := ELN$_SUCCESS;     end;   return:D+ 	request_ptr^.header.dda$_status := status;r   end; {procedure}       r  9 process_block circuit_process ( circuit_struc : ct_ptr );e {++.H { Circuit_process - Process to handle servicing a particular DAP circuit {rK { Inputs : circuit_struc - a structure containing information particular toe {          this circuitp {t {--} var}' 	console_circuit_flags: terminal_flags;i1 	read_buff: terminal_read_buffer;	{ Read buffer }dD 	saved_record_attributes: dap$b_rat;	{ Record attributes from open }D         saved_record_format: dap$b_rfm;		{ Record format from open }M         saved_fixed_control_size: dap$b_fsz;	{ Fixed control size from open } 7 	server_status: integer;			{ Server completion status }     ; function circuit_process_handler of type exception_handler;f {++h. {  circuit_process_handler - Exception handler {e
 {  Inputs: {g) {	Standard exception condition arguments.o {--} begino! circuit_process_handler := false;e write_exception(signal_args);t   delete ( circuit_struc^.port );r dispose ( circuit_struc );   exit;   { Exit the process }   end;   t. function open_routine of type dap$open_action; {++ $ { open_routine - Open action routine {x	 { Inputs:s {	 {	create			- create/open flag	" {	file_access 		- file access mode {	share 			- share accessn$ {	organization 		- file organization! {	record_format 		- record format ( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options                                                                                                                                                                                                                                                   6                         $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             
 "     m        		- file optionsr( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics* {	file_specification 	- file specification7 {	fixed_control_size	- fixed control size for VFC files_' {	context 		- driver specific parameter: { 	t
 { Outputs: {u$ {	organization 		- file organization! {	record_format 		- record formatc( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file optionso( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics {p {	Return value = success.  {--} begin   1     saved_record_attributes := record_attributes;o)     saved_record_format := record_format; 3     saved_fixed_control_size := fixed_control_size;	  #     if (maximum_record_size = 0) orr- 	(maximum_record_size > max_read_buffer_size)r     then- 	maximum_record_size := max_read_buffer_size;i  ;     circuit_struc^.read_buffer_size := maximum_record_size;f       organization := dap$k_seq;!     {record_format := dap$k_var;})     file_options := [];p     device_char :=  E 	[dap$v_devrec,dap$v_devccl,dap$v_devtrm,dap$v_devidv, dap$v_devodv];	  5     { Set up the circuit flags record for this OPEN }c  ?     {*********************************************************}n?     {*** All user-written drivers must use the new definition },     {*** of terminal_flags!!! }r?     {*********************************************************}(  !     with console_circuit_flags doc 	begin0 	    if circuit_struc^.read_buffer_size = 1 then 		begin	0 		    { Special case for a read passthru state } 	   	    echo := false;r% 	            edit_mode_read := false;	 		endr	 	    elseg 		beginp+ 		    { Take value from default data base } % 		    echo := console_line_char.echo;r  : 		    { The edit_mode_read flag TRUE indicates that data }3 		    { should be checked for editting functions: }g 		    edit_mode_read := NOT (  			console_line_char.passall ORr  			console_line_char.passthru ); 		end;  - 	    hardcopy  := console_line_char.hardcopy;i;     	    escape_recognize := console_line_char.ANSI_escape;u 	end;t  "     open_routine := dap$k_success;   end;  , function get_routine of type dap$get_action; {++ , { get_routine - Get/read data action routine { 	 { Inputs:  { * {	record_access	- record access to be used8 {	record_number	- record number - used as key in control! {	record_options	- record optionsr. {	buffer 		- pointer to receive buffer address" {	buffer_length	- length of buffer1 {	get_buffer	- routine to get a new larger buffert& {	context 	- driver specific parameter {l
 { Outputs: {t- {	buffer_length	- length of actual datum read	 {	Return value = success {--} varn     i, read_length: integer;     read_status: boolean;      count: integer;e     eof: boolean;t     tmp_buff: ^anytype;t  / function get_handler of type exception_handler;f {++ " {  get_handler - Exception handler { 
 {  Inputs: { ) {	Standard exception condition arguments.k {--} begint     get_handler := true;$     get_routine := signal_args.name;     goto return; end;   begine     establish(get_handler);        {sF     { If the record access is keyed and the record number is non-zero,D     { then the record number represents a mask of control characters     { that are to be awaited.t     {}  ?     if (record_access = dap$k_key_acc) and (record_number <> 0)=     then 	begin;         read_buff[1] := tc$await_ctrl_key (  console_struc, % 				    	     input_region^.line_ctx,n/ 				             record_number :: ctrl_key_set,p 					     circuit_struc^.port);t 	count := 1; 	eof := false; 	read_status := true;a 	end     else
         beging 	{ Normal read }E 	{ Set up the flags record for this read with line data base values.}'D 	{ This makes certain that if the line values were changed through }E 	{ DDA SET_CHARACTERISTICS then the new READ will pick up these new } = 	{ values, but READs that are already in progress will keep }(> 	{ whatever values of ECHO, HARDCOPY, and ESCAPE RECOGNITION }$ 	{ that they are currently using.  }  < 	{*********************************************************}< 	{*** All user-written drivers must use the new definition } 	{*** of terminal_flags!!! }< 	{*********************************************************}   	with console_circuit_flags do
 	    begin1 	    	if circuit_struc^.read_buffer_size = 1 then  		    begin_4 		        { Special case for a read passthru state } 	   	    	echo := false;& 	            	edit_mode_read := false;	 		    end 
 	        else  	 	    begin, 		    	{ Take value from default data base }& 		    	echo := console_line_char.echo;  ; 		    	{ The edit_mode_read flag TRUE indicates that data } 4 		    	{ should be checked for editting functions: } 		    	edit_mode_read := NOT (  # 			    console_line_char.passall OR $ 			    console_line_char.passthru );
 		    end;  1 	        hardcopy  := console_line_char.hardcopy;n?     	        escape_recognize := console_line_char.ANSI_escape;i	 	    end;a  " 	    read_status := tc$read_chars( 				input_region^.line_ctx,o 				console_struc, 				read_buff,$ 				circuit_struc^.read_buffer_size,
 				count, 				console_circuit_flags, 				eof, 				put_chars);  	end;  {if}: 	e       {a!     { If success, return the data 6     { For VFC files, place a control field on the data     {}       if read_status     then 	begin  # 	if saved_record_format = dap$k_vfc  	thent4 	    read_length := count + saved_fixed_control_size 	elses 	    read_length := count;  ? 	{ Check the buffer for overflow. If so, allocate new buffer. }s   	if read_length > buffer_lengtht 	theng' 	    buffer := get_buffer(read_length);f  @ 	{ Copy the input to the supplied buffer and return the length }  # 	if saved_record_format = dap$k_vfcc 	then 
 	    begin. 	    for i := 1 to saved_fixed_control_size do- 		buffer^::terminal_read_buffer[i] := chr(0);	E 	    tmp_buff::integer := buffer::integer + saved_fixed_control_size;  	    end 	elses 	    tmp_buff := buffer;  7 	tmp_buff^::string(count) := substr(read_buff,1,count);e   	buffer_length := read_length;   	{ Set the return status }   	if eof_ 	then_
 	    begin 	    get_routine := dap$k_eof; 	    eof := falseF 	    end 	else ! 	    get_routine := dap$k_successn 	end     else' 	get_routine := dap$k_device_not_ready;	   return:a     revert;o end; e, function put_routine of type dap$put_action; {++ - { put_routine - Put/write data action routinea { 	 { Inputs:d {o% {	record_access 	- record access typeC {	record_number	- record number ! {	record_options	- record optionsa/ {	buffer 		- buffer of characters to be writteng4 {	buffer_length	- number of characters to be written& {	context		- driver specific parameter { 	d
 { Outputs: {$ {	Return value = success.	 {--} vary     write_status : boolean;    beging  ;     write_status := tc$write_chars ( console_struc, buffer,W- 				  buffer_length, saved_record_attributes,	 				  put_chars );   {**    if write_status then **}  	put_routine := dap$k_successR {**    elseg+ 	put_routine := dap$k_device_not_ready; **}_ end;  6 function truncate_routine of type dap$truncate_action; {++  {t- {  truncate_routine - truncate action routineC {_H {	This routine is called by the dap$server routine when the user process  {	executes a truncate statement. {o
 {  Inputs: {;8 {	record_access		- type of access to be used in truncate { 	a {  Outputs:e {d {	return value = success {  {--} var      stat : boolean;S   begin   " if ( (console_line_char.echo) AND -      (circuit_struc^.read_buffer_size <> 1) )	   then( 	stat := tc$write_newline(0, put_chars);  ! truncate_routine := dap$k_success  end; e {++  { , {  Mainline code for circuit_process routine {k {--} begint  0     eln$allocate_stack ( 4096 ); { eight pages }  '     establish(circuit_process_handler);c  H     server_status := dap$server (circuit_port    := circuit_struc^.port,& 			  	open_action     := open_routine,% 			  	get_action      := get_routine, % 			  	put_action      := put_routine,t+ 			  	truncate_action := truncate_routine);d  #     delete ( circuit_struc^.port );t     dispose ( circuit_struc ); end;    + process_block timer_process ( evt  : event;o& 			     timeout_occurred : ^semaphore;  			     request_timer : event );   {++t( { TIMER_PROCESS : general timer process M {   Accepts requests for starting timers, and signals main code upon timeout.a {--} {++o {c {t {--}   vare     status: integer;(     sigstat	 : integer;	{ local status }*     wait_stat	 : integer;	{ local status }9     timer_result : integer; 	{ result of a wait_                                                                                                                                                                                                                                                   7                        E $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             + "     ~       any call}iA     entry_ptr	: ^queue_record;{ general pointer to queue records}dK     timeptr 	: ^queue_entry;	{ pointer to queue entries in the timer_queue}fL     reqptr 	: ^queue_entry; { pointer to queue entries in the request_queue}E     relative_time : large_integer; {difference between 2 time values}eH     done_insert : boolean;	{ true if we have finished inserting all the}3 				{  request_queue entries into the timer_queue.} I     done_checking_timer : boolean; { true if finished removing from the }T2 				{ timer_queue all the entries that have timed}/ 				{  out or that have ignore_timeout = true.}eE     tail_entry : boolean;	{ true if a record has to be added at the }c. 				{  tail position of the queue, rather than$ 				{  before the current position.}     first_element  : boolean;r     empty	   : boolean; &     timer_active   : boolean := false;'     signal_main    : boolean := false; t     time_proc      : process;    beginn  eJ     { Set the process priority of the timer to 7, above that of the line ]8     { processes and below that of the main dispatcher. }     current_process(time_proc);_2     set_process_priority(time_proc,read_priority);  #     signal ( evt,status:=sigstat );p       {Wait for startup: }     while true do 	     begin  	if timer_active	then	   	    wait_any(request_timer, a& 	             result := timer_result, " 	             time := new_timeout," 	             status := wait_stat) 	else    	    wait_any(request_timer, d& 	             result := timer_result, # 	             status := wait_stat);     { 	clear_event(request_timer);  e, 	done_checking_timer := false;		{initialize}  .3 	REPEAT	{repeat until done_checking_timer := true }r; 	    timeptr := timer_queue.flink;  {point to first entry} e  n, 	    { Is this the end of the timer_queue? }+ 	    If timeptr = address(timer_queue) thent= 	    	done_checking_timer := true  {no more entries to check}c  h	 	    elsep 	        begin(     	        lock_mutex ( sync_lock );  C 	    	with timeptr::^queue_record^ do  { point to the queue record}  	    	    begin    a; 	                get_time(my_timer); 	{ get current time }	s; 			{check if timer entry was cancelled or if timer expired} : 			if ((ignore_timeout) OR (time_at_timeout <= my_timer))  			then  			    begin			    n0 				{remove the current entry (the first entry)}% 			        remove_entry (timer_queue,p 					entry_ptr::^queue_entry,  					empty, queue$head);1 				{insert the entry into the timer_complete_q:}_) 			    	insert_entry ( timer_complete_q,   		    			entry_ptr^.entryq,s% 				    	first_element, queue$tail );y2 				signal_main := true;	{signal timeout_occurred}
 			    end 			else	$ 			    {timeout has not expired yet}# 			    done_checking_timer := true;e   5 	    	    end;  { with timeptr::^queue_record^ begin}p$ 		    unlock_mutex ( sync_lock );  	  s8 	        end; { If timeptr = address(timer_queue) begin}  e 	UNTIL done_checking_timer;e    {------ end common code ------}   s     case timer_result of     0:		{timeout}l	     begin	G 	{ Nothing special to do for timeouts that wasn't already done above. }_G 	{  After this case statement, the timer will be resumed by setting   }n 	{  a new timeout value. }     end; {case 0}u        1:		{request for timer}a	     beginn7 	done_insert := false;		{init - not done inserting yet}   a 	REPEAT ! 	    lock_mutex ( sync_lock );  	rB 	    reqptr := request_queue.flink; {first entry in request_queue}   G 	    if reqptr = address(request_queue) then  {no more request entries}  		begina  	            done_insert := true 		end_  _4 	    else	{there is at least one more request entry}  	 	        begin  r; 	    	{Remove the entry from the head of the request_queue}t" 	    	remove_entry (request_queue,& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);  t 		if empty thenE' 		   begin	{no more entries after this}n 			done_insert := true;  		   end; {if}  s@ 		if not entry_ptr^.ignore_timeout then  {if record still valid} 		    begini0 		    { Insert the request into the timer_queue}D 	        	timeptr := timer_queue.flink; {first entry in timer_queue}: 			timeptr := timeptr^.blink;     {get back to the header}  nF next_entry:		timeptr := timeptr^.flink;     {identify the next entry.}; 			tail_entry := false; {add at CURRENT position, not TAIL}   b% 			{ Is this the end of timer_queue?}v+ 			if timeptr <> address(timer_queue) then  ' 			    begin  	{not end of timer_queue}.A 				with timeptr::^queue_record^ do  { point to the queue record}  		    	    	    begin    r6 			                relative_time := time_at_timeout - ! 						entry_ptr^.time_at_timeout;r( 				        if relative_time <= 0 then  9 					    goto next_entry;  {queue entry is more imminent}  				    end; {with}=
 			    end+ 			else		{we are at the end of timer_queue}i; 			    {Have to insert the record at the TAIL of the timer}e: 			    { either because all the timer_queue elements are }: 			    { more imminent than this request, OR there are no}; 			    { elements left in the timer_queue (so that putting}l: 			    { the entry at the tail is that same as putting it} 			    { at the head. }  			    begin 			        tail_entry := truey 			end;     			{Insert the request}     			if tail_entry thenn# 			    insert_entry ( timer_queue, h 		    			entry_ptr^.entryq, $ 				    	first_element, queue$tail ) 			else  			    begin1 				timeptr:= timeptr^.blink;  {get to previous }l# 						 {entry and insert after it.}   		    		insert_entry ( timeptr^, 		    			entry_ptr^.entryq, ' 		    		    	first_element, queue$head)i 			end; {if tail_entry}n2 		    end { If not entry_ptr^.ignore_timeout then} 		else 		    beginoA 		        { This record never got into the timer_queue, because }f9 		  	{ the ignore bit was set while it was still in the }	6 		  	{ request_queue.  Since there are no longer any }6 			{ pointers to this record in the main code, we can}6 			{ dispose of the record now, rather than put it in} 			{ the timer_complete_q. }, 	    		dispose (entry_ptr);  {get rid of it} 		end;    { else }   3 	    end;    { if reqptr = address(request_queue) }   	    unlock_mutex (sync_lock);    tA 	UNTIL done_insert  {Repeat until all request_queue records have}s. 			   {  been inserted into the timer_queue. }   end; {case = 1}o
     otherwisen 	begin	{No other events} 	end;      end; {End Case}c  a  r {for both case 0 and case 1:}a     {r     { Resume timing }i     { ?     { Set the new_timeout value to be the timeout of the first u5     {  element in the timer_queue, if there are any. rG     {  NOTE that the timeout of the first element of the queue may haveeE     {  already passed, during the execution of this routine.  So the e?     {  wait_any for the timeout may get satisfied immediately. r     {}       lock_mutex (sync_lock) ; n?     timeptr := timer_queue.flink; 	{first entry in timer_queue}i  &     if timeptr = address(timer_queue)      then> 	timer_active := false		{no active entries in the timer queue}     else 	begin 	    timer_active := true;& 	    with timeptr::^queue_record^ do  ! 		new_timeout := time_at_timeout;c         end; {if}        unlock_mutex (sync_lock) ; t  e9     { Waited to signal main code until all entries that }$!     { timed out were processed. }-     if signal_main then 
         begin  	    signal_main := false;  	    { Signal main driver code }/ 	    signal(timeout_occurred^, status:=sigstat)	 	end;      end; {while true}  r end; {process}      4 procedure Cancel_timer ( var ptr : ^queue_record ) ; {d& { Cancel a previously requested timer. {s+ { INPUT: ptr => pointer to a queue_record. cA { OUTPUT: => Ignore_bit field of the input record is set to true.r& {         => Ptr is replaced with nil. {}   begin	     lock_mutex (sync_lock );	rK     if ptr <> nil then	   {do this check while we have control of the lock}p 	begin! 	    ptr^.ignore_timeout := true;i             ptr := nil 	end;f     unlock_mutex (sync_lock);	 end; {procedure}   i- procedure add_timer_request ( line : integer;o! 			     interval : large_integer;c! 			     t_event  : timeout_event;e! 			     var ptr  : ^queue_record;e  			     request_timer : event ); {++= {cE { add_timer_request: add a timer request to the request queue for thes {		     console line.r { 7 { INPUTS:  Line => console line,  it requested a timer._K { 	   Interval => length of time or absolute time to set the the timer for. E {	   t_event  => type of timer (eg. evnt$mod2sec is a 2 second timer)f> {	   ptr	    => the address that will hold the pointer to the 6 {		       queue record after it is added                                                                                                                                                                                                                                                   8                        " $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                              "             to the queue.E {	   request_timer => the event to signal when the request is queued.  {[ {--} varc     entry_ptr	: ^queue_record;     save_ptr	: ^queue_record;      tval	: large_integer;r     first_element : boolean;   begin  *0     {Cancel the previous timer, if there is one}     Cancel_timer (ptr);   1     { Make sure time field is an absolute time. }e     if interval < 0 then 	begin! 	    { Interval is a delta time }*/ 	    get_time(my_timer);		{ get current time }	dM 	    my_timer := my_timer - interval;  { Determine ABSOLUTE TIME at timeout}   	end     else! 	{ Interval is an absolute time }e 	my_timer := interval;        2     new (entry_ptr) ;	{create a new queue element}B     entry_ptr^.line  := line;  { Only one line for the console }		=     entry_ptr^.time_at_timeout := my_timer;  {absolute time}	c9     entry_ptr^.evnt := t_event;		{type of timer request}	n(     entry_ptr^.ignore_timeout := false;	  I     {queue the element in the request_queue and signal the timer process}        lock_mutex (sync_lock );  	a4     insert_entry ( request_queue, entry_ptr^.entryq," 		   first_element, queue$tail );	C     signal (request_timer);   {signal the timer to add the request}y  A     {Update the timer state for this line by saving the pointer }eB     { to the queue record in case you have to cancel the request }     {  later on: }     ptr := entry_ptr;       unlock_mutex (sync_lock);  	 	  end;  {process}r -    5 procedure dda$tty_read( request_ptr   : ^dda$_packet;h 			message_size  : integer;u 			request_timer : event );e { $ { dda$tty_read - perform a DDA read  {l {--}   type@     bit_mask_set = packed set of 0..255; {set of oob characters}   vare6     lkahd_flag	  : boolean := true; { lookahead flag }8     status	  : integer := eln$_success; {assume success}     my_process	  : process;    beging  @     { Make sure there is enough buffer space in the message to }$     {  return the data to be read. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	status := eln$_invalbufsiz;  5     { Do not allow absolute times for timeout value } O     if (dda$_sfb_timeout IN request_ptr^.header.dda$_subfunction.read_sfb) then,9         if request_ptr^.header.dda$_read_timeout > 0 then 
 	    begin9 	        status := eln$_invtimval;	{ Invalid time value }c3 	        request_ptr^.header.dda$_buffer_size := 0;h	 	    end;   !     if status = eln$_success then_ 	begin  . 	    { Bump up process priority for the read }! 	    current_process(my_process);r5 	    set_process_priority(my_process, read_priority);c  9 	    { Obtain exclusive read access to the console line } ( 	    tc$set_read_lock ( console_struc );  5 	    { Pre-set the I/O completion status to success }e. 	    console_struc^.io_status := eln$_success;  / 	    { Clear out the extended status longword }T6 	    request_ptr^.header.dda$_extended_status := zero;  3 	    { Make sure there is enough buffer space for }e9 	    { at least one character.  If not, return success. }G5 	    if request_ptr^.header.dda$_buffer_size > 0 then*  / 	    with console_struc^,request_ptr^.header do*
 	    begin 		io_done := false;s/ 		input_region^.line_ctx.read_passthru := true;_  = 	    	if (dda$_sfb_minimum IN dda$_subfunction.read_sfb) then* 		    begint! 			if dda$_min_read_size = 0 theng 			    begin( 				cur_read_length := dda$_buffer_size; 				max_read_size := 0; + 				{ Preset io_done to true, so that the } + 				{ read will be complete after copying }_) 				{ whatever data is currently in the }  				{ typeahead buffers.}  				io_done := true;
 			    end 			else  			    begin			    e* 				cur_read_length := dda$_min_read_size;& 				max_read_size := dda$_buffer_size; 			    end;f	 		    end  		else 		    begine' 			cur_read_length := dda$_buffer_size;l 			max_read_size := 0;  
 		    end;  ) 		{ Clear the number of characters read }h 		cur_read_count := 0;  7 		{ If there is a terminating mask, and it is 0, then }l@ 		{ just perform a normal read, as if there were no terminating} 		{ mask request. }i; 		if (dda$_sfb_term_mask IN dda$_subfunction.read_sfb) theni0 		    if dda$_term_mask::bit_mask_set <> [] then 			begin$ 		    	    read_w_term_mask := true;4 			    term_mask::dda$_break_mask := dda$_term_mask; 			end;   , 		{ Pick up the address of the data buffer }= 		user_buffer::^anytype := address(request_ptr^.data_buffer);e  > 		{ See if there are any characters in the typeahead buffers } 		tc$process_input_characters( 			input_region^.line_ctx, 			console_struc,f 			lkahd_flag);   0 		if not(io_done)   { Read is not complete yet } 		then 		    beging> 	    		if (dda$_sfb_timeout IN dda$_subfunction.read_sfb) then 		    	    begin! 				if dda$_read_timeout = 0 then 
 				    beginr( 					{ Complete the read and return as }* 					{ many characters as were available }, 					{ in the typeahead buffers, reflected } 					{ in cur_read_count. }u# 				    	io_status := eln$_timeout;i 					io_done := true; % 				        read_w_term_mask := false: 				    end  				else
 				    beginn" 					{ Enter a timeout entry and } 					{ and continue the read. } 1 					add_timer_request ( line, dda$_read_timeout,  					    evnt$io_tmo, * 					    line_timer_struc.io_tmo_started,  					    request_timer); 				    end;& 		    	    end; {if (dda$_sfb_timeout}   			if not(io_done) then  			    begin% 			        { Continue with the read }  				read_started := true;  				read_in_progress := true;u) 				{ Signal the main driver process to }t 				{  process the read: }* 				signal(start_read^, status := status); 				wait_any(read_complete); 			    end; 	 		    end	 		else 		    beginr 		        { IO_DONE is TRUE }	; 	    		IF ((dda$_sfb_timeout IN dda$_subfunction.read_sfb) 	# 			    AND (dda$_read_timeout = 0)    			    AND (cur_read_count = 0) = 			    AND (dda$_sfb_minimum IN dda$_subfunction.read_sfb) ) f 			THEN	9 			    { Give errors precedence over timeout completion } 6 			    { status.  If there was an error on the first }7 			    { character read, then the cur_read_count will }e 			    { be zero. }; 			    if odd(io_status) 			    then 6 			        {Change the status from success to timeout} 				io_status := eln$_timeout;
 		    end;   		{d5 		{ Read is complete or timed-out. Return the number c 		{  of characters read. 		{}% 		dda$_buffer_size := cur_read_count;    	    end; {with}   	{ Return I/O status to user }= 	request_ptr^.header.dda$_status := console_struc^.io_status;n  . 	{ Release exclusive read access to the line }& 	tc$clear_read_lock ( console_struc );  4 	{ Reset the process priority back to the default. }3 	set_process_priority(my_process, normal_priority);+  $     end  {if status <> eln$_success} else    { Return status to user }-    request_ptr^.header.dda$_status := status;    end; { procedure }   c6 procedure dda$tty_write( request_ptr   : ^dda$_packet; 			 message_size  : integer);r { / { dda$tty_write - perform a DDA write to a line_ {i {--} varg8     status	  : integer := eln$_success; {assume success}#     output_buffer : ^string(32767);)     write_status  : boolean;   begin)  @     { Make sure there is enough buffer space in the message to }(     {  contain the data to be written. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	status := eln$_invalbufsiz;  3     { Obtain exclusive write access for this line }t(     tc$set_write_lock ( console_struc );  !     if status = eln$_success then: 	begin  + 	    { See if there is anything to write. }   	    { If not, return success. }5 	    if request_ptr^.header.dda$_buffer_size > 0 then	  / 	    with console_struc^,request_ptr^.header dod 	    	begin 0 		    { Pick up the address of the data buffer }C 		    output_buffer::^anytype := address(request_ptr^.data_buffer);s  ( 		    write_status := put_chars ( line,  					dda$_buffer_size,1 					substr(output_buffer^,1,dda$_buffer_size) );a    		    if not(write_status) then  		    	begin$ 			    status := eln$_devnotready;   			    dda$_buffer_size := 0;  _ 		    	end;a
 	        end;n 	end;        { Send back status }.     request_ptr^.header.dda$_status := status;  4     { Release exclusive write access for this line }*     tc$clear_write_lock ( console_struc );   end; { procedure }   i< procedure dda$tty_sgnl_oob( var request_ptr 	: ^dda$_packet;) 			    terminal		: terminal_data_pointer;r* 			    var line_data	: terminal_read_data;+ 			    sgnl_oob_outstanding_ptr: ^boolean);b {e3 { dda$tty_sgnl_oob - Signal out-of-band characters.i { * { INPUTS: request_ptr - dda request packet' {	  terminal    - termin                                                                                                                                                                                                                                                   9                        * $      ELN042.B                       	  
  +[SYSEXE.SEAS$WORK_0000005C]CONSOLE9RR.PAS;1                                                                                    n                             ;2             al data pointer # {	  line_data   - console line datad {aF { OUTPUTS: sgnl_oob_outstanding_ptr^ -  set to true if the request for9 {	    oob signalling is successful.  Only one request for)6 {	    oob signallling can be outstanding at a time for {	    a dda circuit. {t {--}   varw-     status	        : integer := ELN$_SUCCESS;:%     ctrl_wait_ptr       : ^ctrl_wait;      this_process	: process;t4     this_process_ptr    : ^process;	  { Process ID }3     new_process_id      : process;	  { Process ID } 9     init_event		: ^event;	  { Event to signal after init}tB     process_Stat	: ^integer;	  { Status from create process call}   + function handler of type exception_handler;  beginm status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or       (status = ker$_no_memory)  then     status := ELN$_NORESOURC;m   goto return; end;     begine     establish(handler);   0     { Only one request per circuit is allowed: }&     if sgnl_oob_outstanding_ptr^ then + 	raise_exception(eln$_request_outstanding);   G     if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] thent	     begine  3 	{ Create a record describing the waiting process }( 	new(ctrl_wait_ptr);  7 	{ Status and event to signal from create_process call}u 	new(process_stat);t 	new(init_event); + 	create_event (init_event^, event$cleared);:   	new(this_process_ptr);  	current_process(this_process);r# 	this_process_ptr^ := this_process;   > 	{ Create the process to handle incoming oob char signalling }? 	create_process(new_process_id,	{returns id of created process};5 		tc$signal_oob_chars,    {name of process to create} $ 		terminal,		{terminal data pointer}# 		line_data,		{terminal read data } 4 		this_process_ptr,	{process id of creating process}% 		ctrl_wait_ptr,		{ctrl_wait record.}s  		request_ptr,		{message packet}7 		process_stat, 		{status of initialization in process}e5 		init_event,		{event to signal after initialization}m 		sgnl_oob_outstanding_ptr);   	wait_any(init_event^);s   	if not odd(process_stat^) then'
 	    begin 	    	status := process_stat^; 	    	dispose(ctrl_wait_ptr);r 	    end         else' 	    sgnl_oob_outstanding_ptr^ := true;e   	dispose(this_process_ptr);t 	delete(init_event^);n 	dispose(init_event);i  J     end; {if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] }   return:t     revert;q+ 	request_ptr^.header.dda$_status := status;    end; {procedure}   s? procedure dda$tty_cncl_oob( var request_ptr     : ^dda$_packet; ) 			    terminal		: terminal_data_pointer; , 			    sgnl_oob_outstanding_ptr : ^boolean); { L { dda$tty_cncl_oob - Cancel a request for out-of-band characters signalling. {e* { INPUTS: request_ptr - dda request packet/ {	  console_paramters - console line parameterseA { 	  sgnl_oob_outstanding_ptr^ -  true if there is an outstandinge6 {	    request for oob signalling for this dda circuit. {s {--}   vart&     status  : integer := ELN$_SUCCESS;2     current_process_id : process;	  { Process ID }       + function handler of type exception_handler;q begini status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or :     (status = ker$_no_memory)  then     status := ELN$_NORESOURC;l   goto return; end;     begin      establish(handler);t  4     { If there is a request outstanding, cancel it }&     if sgnl_oob_outstanding_ptr^ then 
         begin.) 	    current_process(current_process_id);i" 	    tc$cancel_oob_chars(terminal, 				current_process_id);( 	    sgnl_oob_outstanding_ptr^ := false;$ 	end; {if sgnl_oob_outstanding_ptr^}   return:      revert;v+ 	request_ptr^.header.dda$_status := status;    end; {procedure}   end;  {final end}                                                                                                                                                                                                                                                                                                                                 ( * [SYSEXE.SEAS$WORK_0000005C]COPYSYS.COM;1 +  , 
   .     /     4 P                          - 
    0   1    2   3      K  P   W   O 
    5   6 @!*  7  dI  8          9          G    H  J                        $ ! K $ ! COPYSYS - command procedure to copy a system image to a Files-11 volume  $ !  $ ! Inputs:   $ !		P1 = system image file name $ !		P2 = output disk name $ !		P3 = initialize flag (y/n) # $ !		p4 = network change flag (y/n) " $ !		p5 = new node name (optional)% $ !		p6 = new node address (optional) @ $ !		processor type for booting 6000 class machines from tk50/70
 $ system = p1  $ processor =""  $ disk = p2  $ init_flag = p3 $ net_flag = p4  $ node_name = p5 $ node_address = p6 I $ if (system .nes. "") .and. (disk .nes. "") .and. (init_flag .eqs. "") -    then init_flag = "n"H $ if (system .nes. "") .and. (disk .nes. "") .and. (net_flag .eqs. "") -   then net_flag = "n"  $get_system:, $ if system .nes. "" then goto get_processor$ $ inquire system "System image file" $ goto get_system  $ ! = $ ! if processor is 6000 class machine and boot media is tape D $ ! we need to put a special version of VMB (ELNLDR.EXE) on the tape@ $ ! Note: We assume that if the first character of the processor8 $ ! type is a 6 that the target is a 6000 class machine. $ !  $get_processor: 9 $ inquire processor "Target processor type [MicroVAX II]" 6 $ if processor .eqs. "" then processor = "MicroVAX II" $!, $! Extract first character of processor type $!& $ processor = f$extract(0,1,processor)
 $get_disk:% $ if disk .nes. "" then goto set_disk  $ inquire disk "Output disk" $ goto get_disk 
 $set_disk: $ disk = disk - ":"  $ disk = disk + ":"  $ tape_device = 0  $ block_size = "" L $ if f$getdvi(disk,"DEVCLASS") .ne. 2 then goto get_init ! Tape = devclass 2 $ tape_device = 1  $ block_size = "/blocksize=512" * $ if net_flag .eqs. "" then net_flag = "n"
 $get_init:) $ if init_flag .nes. "" then goto get_net 4 $ inquire init_flag "Initialize the disk? (Y/N) [N]", $ if init_flag .eqs. "" then init_flag = "n"	 $get_net: - $ if net_flag .nes. "" then goto get_net_info A $ inquire net_flag "Change the node's name or address? (Y/N) [N]" * $ if net_flag .eqs. "" then net_flag = "n" $get_net_info:N $ if (.not. net_flag) .or. (node_name .nes. "") .or. (node_address .nes. "") - 	then goto check_image $ inquire node_name "Node name" % $ inquire node_address "Node address"  $ ! 9 $ ! Check that system image does not have an image header  $ ! 
 $check_image: ! $ system = f$parse(system,".SYS")  $ open system_file 'system'  $ read system_file header  $ close system_file < $ if f$locate("VAXELN", header) .eq. 512 then goto init_disk $ write sys$output -B    "System ", system, " not built with DISK boot method specified" $ write sys$output -G    "Rebuild the system with DISK boot method - system image not copied"  $ exit $ ! = $ ! Initialize the disk and create the necessary directories.  $ !  $init_disk: % $ disk_mounted = f$getdvi(disk,"mnt") E $ if (init_flag .eqs. "") .or. (.not. init_flag) then goto mount_disk  $ initialize 'disk' elan% $ if tape_device then goto mount_disk  $ mount/nomessage 'disk' elan  $ create/dir 'disk'[sys0]   $ create/dir 'disk'[sys0.sysexe] $ ! J $ ! If VMB and WRITEBOOT are available on the system disk, copy VMB to theL $ !target disk and set the target disk's bootblock to point to it.  This is G $ !needed for 11/750 TU58's and removable disks on 6000 class machines. L $ !If the host is running V4.7 version of VMS and the target is a 6000 classO $ !machine, then we need to use a VMS V5.x compatible version of VMB. There is  H $ !one in ELN$, under the name ELN$VMB.EXE. In that situation, edit this> $ !command file to search for the special version and copy it. $ ! - $ ! The next 3 lines should be changed to be:  $ ! A $ !if f$search("ELN$:ELN$VMB.EXE") .eqs. "" then goto copy_system I $ !if f$search("SYS$SYSTEM:WRITEBOOT.EXE") .eqs. "" then goto copy_system 3 $ !copy ELN$:eln$vmb.exe 'disk'[sys0.sysexe]vmb.exe  $ !  $ B $ if f$search("SYS$SYSTEM:VMB.EXE") .eqs. "" then goto copy_systemH $ if f$search("SYS$SYSTEM:WRITEBOOT.EXE") .eqs. "" then goto copy_system- $ copy sys$system:vmb.exe 'disk'[sys0.sysexe]   $ prev_priv = f$setprv("LOG_IO")* $ if f$priv("LOG_IO") then goto writ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  :                        zF) $      ELN042.B                       
  
  ([SYSEXE.SEAS$WORK_0000005C]COPYSYS.COM;1                                                                                       P                                   	       e_boot $ write sys$output -K    "LOG_IO privilege required to write boot block - boot block not written"  $ goto copy_system $write_boot:) $ define/user vmbfile 'disk'[sys0.sysexe]  $ run sys$system:writeboot vmbfile  1  200 ! $ prev_priv = f$setprv(prev_priv)  $ goto copy_system $  $mount_disk:A $ if tape_device .and. disk_mounted then dismount/nounload 'disk' / $ if tape_device .or. .not. disk_mounted then - . 	mount/nomessage'block_size'/overide=id 'disk' $ ! I $ ! if processor is a 6000 class machine we need to put a special version H $ ! of VMB.EXE (ELNLDR.EXE) on the tape before we copy the .sys file to  $ ! it.  $ ! , $ if .not. tape_device then goto copy_system. $ if processor .nes. "6" then goto copy_system1 $ copy/contig ELN$:ELNLDR.EXE 'disk'[SYS0.SYSEXE]  $ ! H $ ! Delete any existing image and copy the new one naming it SYSBOOT.EXE $ ! 
 $copy_system: - $ sysboot = disk + "[SYS0.SYSEXE]SYSBOOT.EXE" 6 $ if f$search(sysboot) .nes. "" then delete 'sysboot';  $ copy 'system' 'sysboot'/contig $ ! 4 $ ! Ask if the network information should be changed $ ! + $ if .not. net_flag then goto dismount_disk * $ copysys_utility := $eln$:copysys_utility $ node_area = ""& $ period = f$locate(".", node_address)< $ if period .ge. f$length(node_address) then goto change_net0 $ node_area = f$extract(0, period, node_address) $ period = period + 1 P $ node_address = f$extract( period, f$length(node_address)-period, node_address)2 $ if node_address .eqs. "" then node_address = "0" $change_net:? $ copysys_utility 'disk' 'node_name' 'node_address' 'node_area'  $  $dismount_disk: 5 $ if .not. disk_mounted then dismount/nounload 'disk'                                                                                                                                                                                                                                                                                                                                                                                                       0 * [SYSEXE.SEAS$WORK_0000005C]COPYSYS_UTILITY.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 Ʉb  7 J  8          9          G    H  J   
             0 D X     0205      (  b`                                             COPYSYS_UTILITY                        VAXELN V4.2-00 b 05-05                          
       ?         !        
LIBRTL_001      +      g  
PASRTL_001  BOOT DEVICE NOT UPDATED:                       ^(޼RTTS2bURR   RUTSTSSSP^޼RbV2VWW^^nW(Vg(gTTS2VURR   RUTSTSS2VSSPϞ^|l  P1	ЭXW2ZZWZRRR2RRGRƟ߭ PWWZRRTGS2TRcR߭PYY\\  \(\Gأ\ RRR\R(RϋcYWWZRRR2RRGRƟπ߭ψWPPWWZRRTGS2TRcRƟ߭ϝPYYα(GYWWZRRR2RRGRƟ߭#WPPWWZRRTGS2TRcRƟ߭7PYYR2RGȟ  Э[YWWZRRR2RRGRƟϙ߭ϱWPPWWZZTGS2TRcRƟp߭PYYR2RGȟw  Эȭ[   Ǐ   [ 
[[[ݭ   P$ p  Q  c  @  P[sys0.sysexe]sysboot.exe          
IMAGE_FILE                     QRЬPРϠR  PϞΜ^|  m޼RbͶ(b͸޼[޼Z޼Rb;(bЏ   d^ͨ-Ͷ͸  LZ[1b];W<WVVͨ^nV(;f(	f2W~    Ï     RƏ   RR  R( bͤͶ&Џ> Ͱ 	ͰRͤRYͶi	(Ͷ͸Z['Џ ͬ 	ͬRͤRXZRR 
[RR*h}  R( b]  F  7  P                                                                                                                                                                                                                         @   @                                                        x            (     x      H    h  x                 
                 @                                                                       LIBRTL                                                         PASRTL                                                                                                                                                                                                                       ( * [SYSEXE.SEAS$WORK_0000005C]COPY_NI.MAR;1 +  ,    .     /     4 M                           - 
    0   1    2   3      K  P   W   O     5   6  .R.  7 _3J  8          9          G    H  J                       0 	.TITLE	Copy to and from KA640 Lance chip NI RAM 	.IDENT /VAXELN X3.2-00/   ; M ;****************************************************************************  ;*									    *- ;*  Copyright (c) 1988, 1990      						    * < ;*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * ;* 									    * M ;*  This software is furnished under a license and may be used and  copied  * M ;*  only  in  accordance  with  the  terms  of  such  license and with the  * M ;*  inclusion of the above copyright notice.  This software or  any  other  * M ;*  copies  thereof may not be provided or otherwise made available to any  * M ;*  other person.  No title to and ownership of  the  software  is  hereby  *  ;*  transferred.							    * ;* 									    * M ;*  The information in this software is subject to change  without  notice  * M ;*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  ;*  Corporation.							    * ;* 									    * M ;*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B ;*  software on equipment which is not supplied by DIGITAL.		    * ;*									    *M ;****************************************************************************  ; 	 ; Author:  ;  ;	Brian Hasbrouck 10-MAY-1988  ;  ; Modified:  ;  ;  ; Abstract:  ; @ ;	This module contains copy routines for the ESDRIVER, the lanceA ;	chip datalink ETHERNET driver.  The routines will be called to  D ;	copy to or from the LANCE NI RAM and host memory.  These routines B ;	are coded in macro because the copy operations are frequent and @ ;	need to be quick.  The NI RAM area  is only used on the KA640. ;    ;  ;copy_to_ni_ram::  ;  ;	 0(AP)  - arguments # ;	 4(AP)	- ni buffer (by reference) % ;	 8(AP)	- host buffer (by reference) $ ;	12(AP)  - size in bytes (by value) ; ( .ENTRY	COPY_TO_NI_RAM,^m<dv,iv,r2,r3,r4>  ) 	MOVAL	@4(AP),R0		; NI RAM buffer pointer ' 	MOVAL	@8(AP),R1		; Host buffer pointer " 	MOVAL	@12(AP),R2		; size in bytes" 	INCL	R2			; round up byte to word6 	ASHL    #-1,R2,R3		; convert byte count to word count0 	ASHL	#-5,R3,R2		; DIVIDE by 32 for loop counter2 	EXTZV	#0,#5,R3,R4		; get remainder of size DIV 32. 	BEQL	11$			; skip the remainder stuff if none 	INCL	R2) 	SUBL3	R4,#32,R3		; tablesize - remainder  	MULL	#3,R3			; result * 3" 	JMP	L^11$(R3)			; jump into table$ 11$:	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop  	MOVZWL	(R1)+,(R0)+		; copy loop 	SOBGTR	R2, 11$  	RET     ;copy_from_ni_ram::  ;  ;	 0(AP)  - arguments # ;	 4(AP)	- ni buffer (by reference) % ;	 8(AP)	- host bu                                                                                                                                                                                   ;                        n,; $      ELN042.B                         
  ([SYSEXE.SEAS$WORK_0000005C]COPY_NI.MAR;1                                                                                       M                              i             ffer (by reference) $ ;	12(AP)  - size in bytes (by value) ; ' .ENTRY	COPY_FROM_NI_RAM,^m<dv,r2,r3,r4>   ) 	MOVAL	@4(AP),R0		; NI RAM buffer pointer ' 	MOVAL	@8(AP),R1		; Host buffer pointer " 	MOVAL	@12(AP),R2		; size in bytes" 	INCL	R2			; round up byte to word6 	ASHL    #-1,R2,R3		; convert byte count to word count0 	ASHL	#-5,R3,R2		; DIVIDE by 32 for loop counter2 	EXTZV	#0,#5,R3,R4		; get remainder of size DIV 32/ 	BEQL	111$			; skip the remainder stuff if none  	INCL	R2			;) 	SUBL3	R4,#32,R3		; tablesize - remainder  	MULL	#3,R3			; result * 3" 	JMP	L^111$(R3)		; jump into table$ 111$:	CVTLW	(R0)+,(R1)+		; copy loop 	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	CVTLW	(R0)+,(R1)+		; copy loop  	SOBGTR	R2, 111$ 	RET   .END                                                                                                                                                                                                                                                                                                                                                        ) * [SYSEXE.SEAS$WORK_0000005C]CSDRIVER.EXE;1 +  , 
   . 	    /     4     	                        - 
    0   1    2   3      K  P   W   O     5   6 8  7 TJ  8          9          G    H  J                       0 D X     0205      (  `                                              CSDRIVER                               VAXELN V4.2-00 `l 05-05                                  
       ?   "      !        
PASCALMSC_001"      !         
LIBCOMMON_001      !         FILE_001      !        DAP_001  <^\l< ~5
  %
  (
  (S2SެS~߬<߬,|~ ߬0<~S߭ 
P  S2Sެ!Sϸ~߬8|~|~߬4<~S߭ 
P   ϰԭԭyԭԭ߭߭߭߭N	  P$ ߬     ߬ X  RϤSݬR S߬(   ݬ|~  ݬ @  R ( ݬ(|~  P޼S֣УRB
#ѣ   @"PЬQ ޼S!RR RRR֣УRB
 RRRRR
 Rѣ    RRPЬQ ޼Sc PЬQ   ޼Sc PЬQ  qRТ4\@  Т0\@" |^2T޼V޼мVUVUФ0S|	 nURR  ЮRR#"RR	 #"RR	 #"RR^R޼nмТ4Scڢ,ԣ c1 ݮ !ݢ8|~  ݢ8|~   ^.S޼nмУ0Rbڣ,Ԣ b^ ݮТPP ֢ТP@
#@"ݣ<|~  ݣ8|~   ޼S	Џ RKS	Џ R=S	Џ  R+S	Џ t RS	Џ  RЏ  RRPFRТ4S ׼ԼRТ0S ׼ԼǞVЦ4Y޼ZмTЬRQDSZX<WWXXW(WacWXZQWV< Ц0XмSЬR( C$^~V޼n޼޼X$ݦ |~  ZЮ޼RǏ   R[ 	RR[ѮЦ0RYѮЦ0RYn_Z[1 1 ޼X޼WЦ4RYJ߭g< ~߭߭s֭ZZ[b\nWZ[RN޼X޼WЦ0R߭gX]QY;߭߭A֭ZZ[X$ݦ   ЭP^޼nЏa ޼R
bP<Џ P^޼R޼޼n< ~5  ޼QǏ   QPR  +RPPP  QRݾ (PPQЏ  QQP^޼R޼޼n< ~  ޼QǏ   QPR  +RPPP  QRݾϹPύPQЏ  QQP Џ P,^X޼Z޼h< ~N  ~<  PYZi0ZRWRްVVV(VVRRRVRg(RcݨݭY	  P                                                                                                                                                                                                                                                                                                                                                                                                                                             @   @       h   t                                            h   p                              
                 @                                                                       	PASCALMSC                                                      	LIBCOMMON                                                      FILE                                                           DAP                                                                                                                              ) * [SYSEXE.SEAS$WORK_0000005C]CSDRIVER.PAS;1 +  ,    . 6    /     4 R   6   5                     - 
    0   1    2   3      K  P   W   O 6    5   6  U*R.  7 qJ  8          9          G    H  J          
            # module csdriver [ident('V2.3-00')];   M {****************************************************************************  {*									    */ {*  Copyright (c) 1986, 1990        						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { + { 	This module contains the driver for the  ) {	RX50 device on the VAX Nautilus console  { 	 { AUTHOR:  {  {	Bob Porras 17-July-1986  { 
 { VERSION: { 	 {	V2.3-00  {  { MODIFICATIONS: {  {--}      % include $dap, $mutex, $stack_utility;    const        { Op codes }          read_data = 0;     write_data = 1;   0     { Console register numbers on the Nautilus }$     rxcs = %x20;				{receive status}"     rxdb = %x21;				{receive data}%     txcs = %x22;				{transmit status} #     txdb = %x23;				{transmit data}   L     { Success values - note: those not **'ed returned as controller errors }#     success              =  0;	{**} $     success_with_retries =  1;  {**}     fail_self_test       = -1;     partial_transfer_eot = -2;$     bad_unit             = -8;  {**}$     no_cartridge         = -9;  {**}$     write_locked         = -11; {**}$     data_check           = -17; {**}     block_not_found      = -32;      motor_stopped        = -33;      bad_opcode           = -48;      bad_block_number     = -55; 3     { Other errors and checksum errors flagged as } $     controller_error     = 100; {**}  
     { Misc. }      max_block_number = 799;      max_retries = 8;     ipl$_power = 31;       data_block = 512;      csa1_id = 1;     csa2_id = 4;
     csa1 = 1; 
                                                                                                                                                                                        <                         $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CSDRIVER.PAS;1                                                                                      R     6                          "            csa2 = 2;      txdb_read_sector = 0;      txdb_write_sector = 1;     txdb_drive_command  = 9;     txcs_int_disable = 0;      txcs_int_enable = 1;     rxcs_int_disable = 0;      rxcs_int_enable = 1;       type     bits$1 = 0..1;     bits$3 = 0..7;     bits$4 = 0..15;      bits$6 = 0..63;      bits$8 = 0..255;     word = 0..65535;     byte = 0..255;  5     rx50_status = bad_block_number..controller_error;   3 	    console_status_register = [long] packed record 0                          mbz1 : [pos(0)] bits$6;" 		         ie   : [pos(6)] bits$1;# 		         done : [pos(7)] boolean; " 		         mbz2 : [pos(8)] bits$8;# 		         mbz3 : [pos(16)] bits$8; $ 		         mbz4 : [pos(24)] bits$8; +                      end; { status record }   0 	    data_buffer_register = [long] packed record!                   case integer of :                      0 : ( message      : [pos(0)] bits$4;:                            message_type : [pos(4)] bits$4;, 		           id           : [pos(8)] bits$4;- 		           mbz1         : [pos(12)] bits$3; - 		           error        : [pos(15)] bits$1; - 		           mbz2         : [pos(16)] bits$8; . 		           mbz3         : [pos(24)] bits$8);  :                      1 : ( data  : [pos(0)] byte_data(1));
 		        4                      2 : ( long : [pos(0)] integer);+                      end; { buffer record }   ,              lbn_type = [long] packed record                   case integer of%                      0 : (low : byte; &                           high : byte;&                           mbz : word);2                      1 : (block_number : integer);%                       end; { record }        xmt_region = record  	    powerfail     : boolean; $             owned         : boolean;$             error         : boolean; 	    unit_id       : bits$4; 	    byte_count    : integer;   	    packet        : xmit_block;/             ipr_txcs : console_status_register; ,             ipr_txdb : data_buffer_register; 		 end; { record }       rec_region = record  	    powerfail     : boolean; $             owned         : boolean;$             error         : boolean; 	    unit_id       : bits$4; 	    byte_count    : integer;   	    packet        : xmit_block;/             ipr_rxcs : console_status_register; ,             ipr_rxdb : data_buffer_register; 		 end; { record }        tx_region_ptr = ^xmt_region;      rx_region_ptr = ^rec_region;       rx50_structure = record  	unit            : integer;  	end;   )     rx50_structure_ptr = ^rx50_structure;   '     x_buffer(n:integer) = byte_data(n); '     xmit_block = byte_data(data_block);          var      { Device stuff }     rx50_transmit : device;      rx50_receive  : device;        rx_region : rx_region_ptr;     tx_region : tx_region_ptr;       rx50_priority : integer;       { Misc. stuff } E     this_process     : process;            {token for unit processes} =     rx50_mutex       : mutex;              {controller mutex} )     controller_name  : varying_string(8); )     universal_name   : varying_string(8); :     init_event       : event;              {a dummy event}      file_service_ptr : ^anytype;       allocate_status  : integer;      PROGRAM  csdriver; {++  { 6 { This is the RX50 driver for the VAX Nautilus console {  {--}   VAR      unit  : byte;      cstat : boolean;   begin   M     eln$allocate_stack ( 4 * 512, status := allocate_status ); { four pages }   -     controller_name := program_argument( 1 ); -     universal_name  := program_argument( 2 );   $     create_device ( controller_name,"                     rx50_transmit, 		    vector_number     := 2, >             	    service_routine   := rx50_transmit_interrupt,<                     powerfail_routine := rx50_xmt_powerfail,0             	    region            := tx_region,6             	    priority          := rx50_priority );  $     create_device ( controller_name,             	    rx50_receive, 		    vector_number     := 1, =             	    service_routine   := rx50_receive_interrupt, <                     powerfail_routine := rx50_rec_powerfail,2             	    region            := rx_region );      C     { Now that the devices are created, initialize the controller }        initialize_controller;  5     { Initialize the job wide file service database } 8     file_service_ptr := eln$file_initialize ( rx50_open, 					      rx50_get, 					      rx50_put, 					      rx50_close );  )     { Create a mutex for the controller }       create_mutex ( rx50_mutex );       { Create a dummy event }/     create_event ( init_event, event$cleared );   H     { For each unit create the actual driver process for CSA1 and CSA2 }     for unit := 1 to 2 do  	begin%         create_process (this_process,                  	rx50_process,                 	unit, 			init_event ); 	wait_any ( init_event );  	clear_event ( init_event )  	end;        { Complete initialization }      initialization_done;        4     { Sit and wait on something that won't happen so"       subprocesses don't go away }     wait_any ( this_process );   end;      ? interrupt_service rx50_transmit_interrupt ( xregist : ^anytype; # 					    region  : tx_region_ptr );  {++ < { rx50_transmit_interrupt : device interrupt service routine { F {  This is the transmit interrupt service routine for the rx50 driver. { @ {  Inputs :     region    - pointer to the communications region {  {  Outputs :	none  {  {--}   begin        with region^ do          begin   &          byte_count := byte_count + 1;  8          ipr_txdb.data := substr(packet, byte_count, 1);'          mtpr(txdb, ipr_txdb::integer);             { xfers done? }  $          if byte_count >= data_block
          then               begin                ipr_txcs := zero;-              ipr_txcs.ie := txcs_int_disable; +              mtpr(txcs, ipr_txcs::integer);               owned := false;              signal_device;               end;   
       end; end;      = interrupt_service rx50_receive_interrupt ( xreg   : ^anytype; ! 					   region : rx_region_ptr );  {++ ; { rx50_receive_interrupt : device interrupt service routine  { E {  This is the receive interrupt service routine for the rx50 driver.  { < {  Inputs :	region    - pointer to the communications region {  {  Outputs :	none  {  {--}   begin        with region^ do        begin    	{ Read the input character } '         ipr_rxdb.long := mfpr ( rxdb );   1         if (ipr_rxdb.id = 1) or (ipr_rxdb.id = 4)          then           begin   7           { Bump up the byte_count and store the byte } '           byte_count := byte_count + 1; 9           substr(packet ,byte_count, 1) := ipr_rxdb.data;            end;   !         if ((ipr_rxdb.id = 8) and P                (((ipr_rxdb.message_type = 1) or (ipr_rxdb.message_type = 2)) andI                                                 (ipr_rxdb.message <> 0)))          then           error := true;  :         if (byte_count >= data_block) or (ipr_rxdb.id = 8)         then             begin              owned := false;              signal_device;           end;  
       end;                      end;      9 interrupt_service rx50_xmt_powerfail ( xreg   : ^anytype; $ 				       region : tx_region_ptr ); {++  { 8 { This is the transmit device powerfail recovery routine { 	 { Inputs:  { & {	Standard interrupt service arguments { 
 { Outputs: { : {	Controller initialized and any waiting process signalled {  {--}   begin        with region^ do    	begin     	  powerfail := true;              if owned             then             signal_device;  !           initialize_controller; 2   	end;    end;   *  9 interrupt_service rx50_rec_powerfail ( xreg   : ^anytype;*$ 				       region : rx_region_ptr ); {++  {67 { This is the receive device powerfail recovery routineo {i	 { Inputs:, {s& {	Standard interrupt service arguments {f
 { Outputs: {h: {	Controller initialized and any waiting process signalled {n {--}   begini       with region^ doh   	begin               powerfail := true;               if owned             then 	      signal_device;*  "             initialize_controller;   	end;i   end;   a    procedure initialize_controller; {++l {o7 { This procedure will perform controller initializationn {r {--} begin        with rx_region^ do  
         begin   *           disable_interrupt( ipl$_power );           ipr_rxcs := zero; )           ipr_rxcs.ie := rxcs_int_enable;G(           mtpr(rxcs, ipr_rxcs::integer);           enable_interrupt;*           end;       with tx_region^ do  
         beginl  *           disable_interrup                                                                                                                                                                                                                                                   =                        / $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CSDRIVER.PAS;1                                                                                      R     6                         Zf "            t( ipl$_power );           ipr_txcs := zero;L*           ipr_txcs.ie := txcs_int_disable;(           mtpr(txcs, ipr_txcs::integer);           enable_interrupt;            end; end;   N  R procedure send_command ( cmd : integer ; unit_number : bits$4; lbnum : lbn_type );   {++d {cK { This procedure sends a command to the RTI driver on the Nautilus console.  { 	 { Inputs:: {  {	cmd and unit_numberI {A
 { Outputs: {} {	Requested command issued {  {--} vari  io_request : bits$4;    begin}  8   if cmd = read_data then io_request := txdb_read_sector   else=     if cmd = write_data then io_request := txdb_write_sector;s     with tx_region^ do	     begine       ipr_txcs := zero;	       ipr_txdb := zero;              (       ipr_txdb.id := txdb_drive_command;%       ipr_txdb.message := io_request;n+       ipr_txdb.message_type := unit_number; $       mtpr(txdb, ipr_txdb::integer);         repeat*           ipr_txcs::integer := mfpr(txcs);         until ipr_txcs.done;  (       ipr_txdb.id := txdb_drive_command;,       ipr_txdb.data := lbnum.low::byte_data;$       mtpr(txdb, ipr_txdb::integer);         repeat*           ipr_txcs::integer := mfpr(txcs);         until ipr_txcs.done;  (       ipr_txdb.id := txdb_drive_command;-       ipr_txdb.data := lbnum.high::byte_data;s$       mtpr(txdb, ipr_txdb::integer);         repeat*           ipr_txcs::integer := mfpr(txcs);         until ipr_txcs.done;     end;   end;      D procedure receive_packet ( unit_number : bits$4; lbnum : lbn_type );   {++2 {20 { This procedure receives a packet from the RX50 { 	 { Inputs:x {d {	unit, block and the packet {d
 { Outputs: {  {	packet read from rx50  {x {--}   begin=   with rx_region^ do	     begin          powerfail := false;;  %       { Synchronize with the device } *       disable_interrupt ( rx50_priority );  ,       { Initialize the communications area }       byte_count := 0;  u       { Check for powerfail } '       disable_interrupt ( ipl$_power );r         if not powerfail
       then  
         begin;           enable_interrupt;b  6           send_command(read_data, unit_number, lbnum);             owned := true;      m1           wait_any(rx50_receive); { comm status })!           wait_any(rx50_receive);d         endc  
       else         enable_interrupt;n       end;   end;      A procedure send_packet ( unit_number : bits$4; lbnum : lbn_type );    {++] {t/ { This procedure transmits a packet to the RX50p {4	 { Inputs:  {  {	unit, block and the packet {b
 { Outputs: {  {	packet sent to rx50s {) {--}   begin             with tx_region^ do	     begin        powerfail := false;   %       { Synchronize with the device } *       disable_interrupt ( rx50_priority );  ,       { Initialize the communications area }       byte_count := 0;         { Check for powerfail }r  '       disable_interrupt ( ipl$_power );r             if not powerfail
       then  
         begin              enable_interrupt;   0           { Actual i/o done at interrupt level }  8           send_command(write_data, unit_number, lbnum );  !           ipr_txdb.id := unit_id;bL           byte_count := byte_count + 1;               { kick 1st byte xfer }7           ipr_txdb.data := substr(packet,byte_count,1); (           mtpr(txdb, ipr_txdb::integer);     K           ipr_txcs := zero;                           { enable interrupts }c)           ipr_txcs.ie := txcs_int_enable;x(           mtpr(txcs, ipr_txcs::integer);             owned := true;  %           wait_any ( rx50_transmit );i1           wait_any(rx50_receive);      { status }            end   	      else; 	    enable_interrupt;       end;   end;   _  ; function set_status ( success_code : byte ) : dap$l_status;  {++  {x5 { This function will examine the success code and sett- { the function value to the proper dap statuse {  {--}   begind       if success_code = successg     then!       set_status := dap$k_success      else,       if success_code = success_with_retries
       then0         set_status := dap$k_success_with_retries
       else&         if success_code = no_cartridge         then*           set_status := dap$k_no_cartridge         else(           if success_code = write_locked           then3             set_status := dap$k_device_write_locked_           else(             if success_code = data_check             then,               set_status := dap$k_data_check             else.               set_status := dap$k_device_error   end;      H procedure verify_read_request(var retries : integer; var done : boolean;M                               var error : boolean; var status : rx50_status);r {++p {:E { This procedure controls the retry code when retrying read requests.; {+ {--}   begini     if rx_region^.error    then  	     begin          retries := retries - 1;e         if retries <= 0 
       then  
         begins           error := true;           done := true;            status := data_check;=         end;       end      else  	     beginp       done := true;        status := success;     end;   end;             I procedure verify_write_request(var retries : integer; var done : boolean;rM                               var error : boolean; var status : rx50_status);r   {++_ {eF { This procedure controls the retry code when retrying write requests. {p {--}   begin      if tx_region^.error    then  	     begint         retries := retries - 1;5         if retries <= 0n
       then  
         begin            error := true;           done := true;            status := data_check;t         end;       end,     else  	     begino       done := true;g       status := success;     end;   end;   e  . function do_rx50_io ( command       : integer;  		      unit          : integer;  		      block         : integer;  		      buffer_length : integer;@ 		      var buffer    : x_buffer(buffer_length) ) : rx50_status;   var      unit_number   : bits$4;      lbnum	  : lbn_type;e     index         : integer;     blocks        : integer;     extra_bytes   : integer;     done          : boolean;     error         : boolean;     buffer_offset : integer;     retries       : integer;     nc            : integer;      status        : rx50_status;  3 procedure move_to_user ( length          : integer; ' 			 var user_buffer : x_buffer(length);n  			 var offset      : integer ); begin    with rx_region^ do	     beginl6      substr ( user_buffer, offset, length ) := packet;      offset := offset + length     endo end;  5 procedure move_from_user ( buffer_length   : integer;s0 			   var user_buffer : x_buffer(buffer_length);" 			   var offset      : integer );   begin   '     { Compute number of bytes to send }t     nc := data_block;i       { Form the data packet }     with tx_region^ do/ 	packet  := substr ( user_buffer, offset, nc );        offset := offset + nc  end;   o   beginu     { Lock the controller }u     lock_mutex ( rx50_mutex );       { Initialize flags }     error := false;      index := 1;t     retries := max_retries;t   	{ Initialize buffer offset }o 	buffer_offset := 1;   	lbnum.block_number := block; /         blocks := buffer_length div data_block;>4         extra_bytes := buffer_length mod data_block;           if (extra_bytes <> 0)          then           blocks := blocks + 1;            if unit = 1_         then           begino*             tx_region^.unit_id := csa1_id;             unit_number := 0
           end 
         else e           if unit = 2r           then             begin ,               tx_region^.unit_id := csa2_id;               unit_number := 1             end;      , 	        { What kind of a response was it? } 	        case command of   		{ Data - response to read }o 		read_data : begine  <                               { Copy data to user's buffer }  I                                while (index <= blocks) and (not error) don  '                                  begin b  1                                    done := false;   4                                    while not done do  *                                      begin  A                                        rx_region^.error := false; &                                       J                                        receive_packet(unit_number, lbnum);  gA                                        move_to_user ( data_block,i=                                                       buffer,;F                                                       buffer_offset );  P                                        verify_read_request(retries, done, error,C                                                                                                                                                                                                                                                                    >                        E7b $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CSDRIVER.PAS;1                                                                                      R     6                               (                                                  status);e)                                      end;   P                                    lbnum.block_number := lbnum.block_number + 1;6                                    index := index + 1;  %                                  end;                               end;   d   		{ Data - response to write } 		write_data : begin  >                                { Write data to user's buffer }  J                                 while (index <= blocks) and (not error) do  '                                   begin   2                                     done := false;  5                                     while not done do6+                                       beginv  B                                         tx_region^.error := false;&                                       O                                         move_from_user ( buffer_length, buffer,^- 				                         buffer_offset );;  >  		                        send_packet ( unit_number, lbnum );  R                                         verify_write_request(retries, done, error,E                                                              status);l*                                       end;  Q                                     lbnum.block_number := lbnum.block_number + 1;p7                                     index := index + 1;e  &                                   end; 			     end;   	        end; { case }    4     { Release the controller and return the status }      unlock_mutex ( rx50_mutex );       do_rx50_io := status;    end;      , function rx50_open of type disk$open_action; {++  {,$ {  Open_action - open action routine {t> {	This routine is called by the file server to open the device {d
 {  Inputs: {i2 {	device_char specifies the device characteristicsF {	device_dependent_char specifies the device dependent characteristicsE {	context is a pointer to the drive data base structure for this unit	 {u {  Outputs:  {u0 {	device_char returns the device characteristicsD {	device_dependent_char returns the device dependent characteristics" {	return value = completion status {s {--}   begin_  (     with context::rx50_structure_ptr^ do 	begin    %         device_char := [dap$v_devdir, %                         dap$v_devfod,d"             	        dap$v_devshr, 			dap$v_devavl, 			dap$v_devidv,             	    	dap$v_devodv,               	    	dap$v_devrnd];    0         { Set device dependent characteristics }%         with device_dependent_char DO              begin="             dap$b_sectors   := 10;!             dap$b_tracks    := 1; "             dap$w_cylinders := 80;/             { Return max LOGICAL block number }(/             dap$l_maxblock  := max_block_number_             end;  A         { Save the max record size and return successful status }t  #         rx50_open := dap$k_success;e           end    end;   e  * function rx50_get of type disk$get_action; {++  {n  {  rx50_get - get action routine {_F {	This routine is called by the file service to read a block or blocks {	from the device  {k
 {  Inputs: {0: {	starting_lbn specifies the starting logical block number5 {	buffer is the address of the buffer to receive data=+ {	buffer_length is the length of the buffero: {	context is a pointer to the drive database for this unit {      {  Outputs:r { ( {       return value = completion status {c {--}   var      success_code : byte;     block_length : word;   begini  L     eln$allocate_stack ( 2 * 512, status := allocate_status ); { two pages }  (     with context::rx50_structure_ptr^ do       begin   ' 	block_length := buffer_length div 512;,  0     	if ( starting_lbn <= max_block_number ) and< 	   ( ( starting_lbn+block_length-1 ) <= max_block_number )          then           beginc  @ 	    success_code := do_rx50_io ( read_data, unit, starting_lbn, 					 buffer_length,) 					 buffer^::x_buffer(buffer_length) );e8             rx50_get := set_status ( success_code );    
           end   
          elsenA            { Illegal block number (either start or end or both) }s*            rx50_get := dap$k_illegal_block          end;e   end;   o  * function rx50_put of type disk$put_action; {++  {c  {  rx50_put - put action routine {pG {	This routine is called by the file service to write a block or blocksu {	to the device  {h
 {  Inputs: {i: {	starting_lbn specifies the starting logical block number9 {	buffer is the address of the buffer containing the data + {	buffer_length is the length of the bufferi: {	context is a pointer to the drive database for this unit {      {  Outputs:b { ( {       return value = completion status {  {--}   varu     success_code : byte;     block_length : word;   begin   L     eln$allocate_stack ( 2 * 512, status := allocate_status ); { two pages }  (     with context::rx50_structure_ptr^ do       begin   ' 	block_length := buffer_length div 512;   0     	if ( starting_lbn <= max_block_number ) and< 	   ( ( starting_lbn+block_length-1 ) <= max_block_number )          then           beginn  A 	    success_code := do_rx50_io ( write_data, unit, starting_lbn,  					 buffer_length,) 					 buffer^::x_buffer(buffer_length) ); 8             rx50_put := set_status ( success_code );    
           end            else@           { Illegal block number (either start or end or both) })           rx50_put := dap$k_illegal_blocki          end;c   end;   u  . function rx50_close of type disk$close_action; {++  {l@ { This function is called by the file service to close this unit { 	 { Inputs:: {a5 {	context points to the drive data base for this units {d
 { Outputs: {e {	return value = success {_ {--}   begin_        rx50_close := dap$k_success;   end;   c  B process_block rx50_process ( unit : integer; init_event : event ); {++w {e4 { This is the unit level process for the rx50 driver {a	 { Inputs:  { . {	unit specifies the unit number of this drive( {	init_event is the syncronization event {_
 { Outputs: {_ {	none {r {--}   var )     drive_structure : rx50_structure_ptr;e)     port_name       : varying_string(31);     begin  M     eln$allocate_stack ( 4 * 512, status := allocate_status ); { four pages }e  2     { Allocate the drive structure for this unit }       new ( drive_structure );"     drive_structure^.unit := unit;    /     { Create a name for this particular drive }t  8     port_name := controller_name + CHR(unit + ORD('0'));    (     { Pass control to the file service }  2     eln$file_service ( port_name, drive_structure,( 		       init_event, file_service_ptr );      end; {Drive process}    end;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              ) * [SYSEXE.SEAS$WORK_0000005C]CXDRIVER.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6  h  7  tJ  8          9          G    H  J                       0 D X     0205      (  e`     8      P                                  CXDRIVER                               VAXELN V4.2-00 e 05-05                                     
       ?         !        DAP_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001!      !         DDCMP_V2_001"      !         
TERMCLASS_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ?                        wQ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.EXE;1                                                                                                                    º "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     td}$ACCESS       ARAI   	
  
Þ΀^V < ~/  /  (S2SuR @ ߭ݏ"[ R߭ 
P  S2SS~ |~|~e~S߭ 
P  SRխRR dSR S   SRRRWW/  0d 0d0(020C(0ƖƖWW.  0d 0d0(020ƀ Wŏ  WUxWRR\SRTRRc~Tc~\c~E.  WO  ( X  ~/.  PX h   SSR>BƄ R b   xSR>B~R b   S ߭ X  ~-  PY i   pppthhhl```d\ X   ( @  RЭTTY( R$   (|~  RϣS( @  TX(R S$   (|~  R(   @@ ( ߭   ݭ x ih@ ߭  ЭWW0Sŏ  STxSRRR~CƤDS S1 WvTDƤ\ cŏ  TS|~DƤCt,  UCRbR
& /xTRRR~DƤCeT`|~DƤC/,  T
WݭTDƤR # TSCƐݢ"߭ T1^GW޼޼n[޼X޼ZШR
& *ШS
&RR 
 
&УԣУԣ3ШS
&RR 
 
&УԣУԣ [ 
 1jR @ݢ< @  8.jR @&8ݢ<   Dǃ ݢD	Ը 
Rʏ@   RR 
1 [ШSШSSRխ1 Yխ1 TYЭSC%VSUYT3T0Ub+xUQQ&PPQQ&PP
TE%VUT|V~hju*  QPTTQTjS QTQQEbSUS0USbTST$SQA&A%xQSSPP&PPS&TQb UU׭1,BjRRSn9 4 `. @ 8Dǃ ݣzǃ ݣj>jR 6|~jh)  ШR
& n~jhݮχ|~jh\)    
[1^S޼WUhVX\X|~  hPPVUX\1X  1hP TT %T(  X\1X  1  0 h  1RTo(  X\1\X  1LP@ÈX\
X  ݤ  T(  1P@ÌX\
X  ݤϦФRRPW@ÈBcRT'  1 P@ÐX\
X  ФQAäR hŏ  QP Aä@'   ЏSFEŏ  QPAP`Q
&Pʏ   PP
&ݢ"߭ T('  X\
X  T'  U1^R޼Sc c ЏQyPnn|~ c
    PP|޼V޼TTVS޼UxSRVBdSO C@SPUQ C@S<@@PФ`RR PPf^S޼TxTRnB R bbb
b
	b`RDP|^V(ЭUxURSBcT RRd1RRdSSS CzCsRRdChRR	d3RRd4RRd5RR 6RRd9RRdRR7RRddRU   |^U޼Vм޼TSVnn SSdS SSS  S((S	00SSRRSRRR44SR88S
<<@@SSxVR>BxRVRBňRb|^޼[޼WVZ1޼n

1 YY   1Wŏ  YRBgTѴ1 
1j1b1Z dxRRRj eRR,ФP
&RRR
&ФP
&RRR
&*ФP
&RRR
&ФP
&RRR
&V1 ' " `ФP
&Rȏ   RR
&VФR$1
RZZZZZ1 U Rď  RBgSУQxaRR&xaPPZRRP&աa ֡УP`RUB%``
&Rȏ   RR
&Vѡ  $ a
&Rȏ   RR
&<VZ1 D Rď  RBgRТP`RB%``1
&Rȏ   RR
&V1U Rď  RBgSX 1UQQf c0УP
&RRR
&УP
&RRR
&V10УP`RUB%``1
&Rȏ   RR
&V1Qf c0УP
&RRR
&УP
&RRR
&V1УP`RUB%``1
&Rȏ   RR
&V1УP`RUB%``1|
&Rȏ   RR
&V1aURRbdУP
&Rȏ@   RR
&x`RRR&ՠ`֠VУP`RUB%``
&Rȏ   RR
&VXUQQ1  c0УP
&RRR
&УP
&RRR
&V1X1УP
&Rȏ@   RR
&x`RRR&ՠ`֠VУP`RUB%``1c
&Rȏ   RR
&V1HQ1  c0УP
&RRR
&УP
&RRR
&V1X1УP
&Rȏ@   RR
&x`RRR&ՠ`֠VУP`RUB%``1 
&Rȏ   RR
&V1 X1 Q 5УPx`RRR&ՠ`֠
&Rȏ@   RR
&VУP`RUB%``K
&Rȏ   RR
&V1ď  Y>I"  RR  P RRPnQ 1HVPЬQ |^޼V޼Tf#޼U SSPUQ C@f^S޼TRDPP|^R޼TTP>@ QX
a|~  P d1QQVV޼QD P ߭QPj  VЬP`nn  PPT`<@@STPP SSP
Q޼UUPPS PP SPSPD@ D |~  P dVD PݭUP  TP>@ QXa  SP DP2SЏQyP|~ P DP|~ SP<)URммм<ռ
Ѽ   < RмԼԼ <`$RѢ9xRT BRR xRRSRSdSRdRRSSSxSSRTRdRRSSdRRЏ PQRЬPРR  PϞ^|  mQV9X޼Ьnޯ]ЦTU DP1tѮ:n6ŏ  TSRݮCDȤ  P[1 PѠ2xTR BRR xTRRSRSeSReRRSSSxTSSRReRRSSeRRŏ  TRЦϺԭϖԭ߭߭߭ݠDȤB	  P[[zѦYЭYY Y}P`PѦ ЦSSWмRGSWZмZR(RjY
Џ ' 씭Џ Џ ! Џ ! |ЭP^QRS޼޼nТPԭ ߭ݢݮݮ@ä  PЏ PЏ ! P^QS0RУTQ DP2xTP @ PѠbԭ߭T  Џ PЏ ! P μ^Ь < ~3  P`ύ]`]]\]|~|~|~|~ |~|~  PnP     P Q\+\  PϞ@^|x  mY޼h޼X޼T޼d^Pޯ] < ~L   x       h``QyPP{
PRRR
R0RR_
`a_RRwWW  W(WW RRRWR(RwcWW  W(WȣW RRRWR(RNc1 [`QyPP{
PWWW
W0W<[ZZP^(nW_RRw[WW  W(WnW RRRWR(RwcWW  W(WȣW RRRWR(RϾcS2Soޭs xo߭   S2Spޭt p߭    T hhRBɤ  xRRBhqxhRRR<ŏ  hSR>C"  RxhSCDSRb  X  x ߭߭ ѭ1 xhRRR1 ~  PVhf ߭  t|~ x߭  CπRV R߭߭  1r      V  1N   Vr  16Vf  1*R|~R x   ŏ  hSR>C"  R-ptpR6  1~
  PVhf ߭  w|~ ߭  GRdV R߭߭  1      V  1^   V  1FVv  1:P$^T޼޼޼nZ߭   ݭ x ݮ߭ nݮH߭߭ ݮ ߭߭ ݮ @  VpWpSSWV1 X\X|~  SRP   ѢT5ѢP+pP UUShPeSZVX\
X  V1iЭ[1 [1 YX\X|~  `Q`PQPY1 `P UUY hpPРQaQXpPQP*QP РWåV ٥WSyRRWSVRǐXXRpPeRСQPea
P	U  X\
X  Y1%X\                                                                                                                                                                                                                                                   @                        On $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.EXE;1                                                                                                                                 X|~  pSpRSRnnSR}HX\
X  Z1Zݾ߭ 1RX\X|~  мPԼX\
X  ^UR޼}S޼޼n߼QyPPTQ$SPP   SP TT}SP~X  PSЮ}PX\X|~  Q`PcQn  SX\
X  ^R޼T޼W < ~  ~  PVf|~  |~߭߭߭߭@ ѭ1&ЭUU   ݭ   1ЭSϣ# ; n }          T   1 xdP@dS߭*1 xdP@d߭wxdPW@TSσ]WUTSYNUTS
AdQŏ  QPV@A¤Q߭wdPV@¤P߭ϼЏS|~~ݭ߭` 1ݭ   ѭ||  1ѭ||  1 f!dSC¤S߭   ݭSk  V:  ߭     T  P^W޼X޼Zм<~߭߭߭p  ЭYY1?ЭV( hfݼ   ЭxZR>B~SX
c|~  ЭS xZT>DǄRb
ŏ  ZRB>DǅRb RRRR	RRRR
RRRRRRRRRRRR RRRRRRRRϞRR
RR>D~SXc  ЭRЏSY|  Y|  	Y|  ЏSЭQRЬPРТPP|  P|  	P|  ЏSR&
  P^|
  mV޼W޼YЏSޯ]мPѠݏS 8 мRXXSSѢ<ݏS 8 +SѢ ݏS 8 ݏS 8 xWP>@~RX
b|~  мTQQQPP,xWP>@~RXb  ݏS 8 RRR
2RRRR B,xWP>@~RXb  ݏS 8 PP
PRRR Bυ,xWP>@~RXb  ݏS 8 ޼U 	eŏ  WSP	C
eePCPPeePP eRRR BPPe2PPP@PPe2PPP@PP	eXePCe!PCPCCxWS>CƅRb>CƄRbeYWDe~~YWϠ  >C~RXb  ЏS|мPЭ ^޼޼S޼T<@@RЮnn RRc dddd 	d^S޼޼U޼W޼VWVWTTVT<@@RЮnn RReÄTÄVÄÄ|^S޼R޼T޼nм޼VЏSUЏmQyP|dQP AP1  <Џ@QyP(#QyPPѢ QѢP	ЏSU}%QyPPѢ(QѢ$P	ЏSU
}$|USydP>@Ä QX
a|~  QyPPѭQѭP!dP}@cdPV@Ìdϸ(nd%dPV@ÈdϗЏSUU<^T޼U޼S<@@RUnn RRc UĀ ^R޼T޼ST J<@@QTPP QQc  T TP>@ QXa  ^7X޼W޼Y޼n޼ЏS   RnRЏSԧiSR CPЏSԧ SyRRѧ$Sѧ RЏSԧѭS1߭   ݭ x iRBȤSX*ݣ&|~  iRBȤRЏSFԧHէ1YiRBȤVŏ  iSRC` էЧԦJЧЧJЧԦJԦ- (  (
E( (N fiRŏ  RS BȤCj   k<SyRRѧ$Sѧ RЏSFEiRݮBȐ i4 Tݶ߭ ݦ"|~  /*SyRRѧ$Sѧ Rզ 
 FЏSFЦЦFRRSRS	RS
ЧRB HiRBȤRТFiRBȤSX*ݣ&  ݭ x Э|^T޼R޼V޼ЏSU   PѮP
ЏSUԢUS<fP@Ĥ  ТS'fQAĤnS SQϷP
ЏSUԢUfP@Ĥ  QRЬPРТPP|  P|  	P|  ЏSRM  P$^|>  m޼n޼UЏSޯ] eݏS 8 мR- ,  ,1 J~  PX~  PV~  PT d X  ~  PW߭   Эg  RUTVݼXWݮ R߭   d|~   ffXn  eW`  d   TL  |мRЭQRЬPРТPP|  P|  	P|  ЏSUR  P ^|  m޼n޼RЏSޯ] b߭   ݭݮ  b|мPЭ< ЬQ	QSQ	П PA^nPQߠ`h ЎQՎЎPQРP<2
 RxRR    RB8PРXPˏ  C`Px	PPQ 	P< ЬS 	RBSxSS~R~T~UeݬS~db   x	dP 	PPbR< ЬRЬS 	P@SxSSެUЬQ a1 	QTQePJП P ~Q~P}P~h ՎЎPРP<2
 QxQQ    QA8PРXPD`PTȏ   T ȏ   T``ЀQQ TTSbݬ  8  ݬx~ЬP 	QAPxP~                                                                                                                                                                         @   @                                                              H   P   h   `   p                               x   `   @   P   H   (       p                     6   
                 @                                                                       DAP                                                            	LIBCOMMON                                                      	PASCALMSC                                                      DDCMP_V2                                                       	TERMCLASS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ) * [SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1 +  ,    .     /     4 i                         - 
    0   1    2   3      K  P   W   O     5   6 @֑  7 qJ  8          9          G    H  J          
            # module cxdriver [ident('V4.2-00')];   M {****************************************************************************  {*									    *) {*  COPYRIGHT (C) 1984, 1990   					    * < {*  BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.			    * {* 									    * M {*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  * M {*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  * M {*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  * M {*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  * M {*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *  {*  TRANSFERRED.							    * {* 									    * M {*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  * M {*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *  {*  CORPORATION.							    * {* 									    * M {*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  * B {*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { 5 {	This module contains the driver for the CXA16 async  {	multiplexor device { 	 { AUTHOR:  {  {	Jo Ann Kasson 7-October-1986 { 
 { VERSION: { 	 {	V1.0-00  {  { MODIFIED BY: {  { + {	V3.0-01 - August 11, 1987 -	Jo Ann Kasson 1 {		Modified interface initialization and put_char  {		function.) {	V3.1-00 - January 6, 1988 - S. Ducharme 3 {		Modifications for input performance improvments.  {  {	V3.1-01 George Thissell Jr. ( {		Fixed char_length not working problem { * {	V3.1-02 - January 25, 1988 - S. Ducharme6 {		When the line is in PASSALL mode do not signal data {		overflow conditions.  { ) {	V3.1-03 February 11, 1988 - S. Ducharme = {		Correct problem where the driver would enter a dead locked 9 {		state if the input buffer overflows while a read is in  {		progress. { & {	V3.1-04 March 11, 1988 - G. Thissell {		Add JANUS support { " {	V3.2-00 June 1, 1988 - J. McGray1 {		Added DDA support for the following functions: ' {		dda$_fnc_get_char, dda$_fnc_set_char  { 2 {		fixed char_length bug where char_length was set. {		according to ebuild parameter for eightbit. { # {	V3.2-01 June 22, 1988 - J. McGray * {		Fixed DDA scope vs driver hardcopy bug. {		 A {		Removed echo and passall from the line circuit data structure, B {		and always use the line data base values of echo an                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  A                        L $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             Y             d passall to> {		make sure values are up-to-date (they may have been changed% {		through DDA SET_CHARACTERISTICS).   { # {	V3.2-02 June 24, 1988 - J. McGray 5 {		Fixed setting of passall and eight_bit in line_ctx 3 {		data base, from DDA set_characteristics routine.  { # {	V3.2-03 June 30, 1988 - J. McGray 9 {		Match up Ebuild speed values with valid driver speeds. 6 {		If invalid for this driver, keep the default speed. { " {	V3.2-04 July 1, 1988 - J. McGray? {		Took out eight_bit checking in ISR.  It is now in Termclass.  { " {	V3.2-05 July 7, 1988 - J. McGray- {		changed parity_type to an enumerated type.  { # {	V3.2-06 July 11, 1988 - J. McGray  {		Fixed dda_port_name bug.  { # {	V3.2-07 July 13, 1988 - J. McGray " {	      - Fixed parity_type error. { @ {	     -	eln$ddcmp_v2_term_device_number was changed from 8 to 0. {		in DDCMP_V2, so changed code to reflect it.? {		The purpose of this change was to allow drivers with greater = {		than 8 async lines (cxdriver) to be able to support DDCMP  ? {		on ALL those lines.  Previous to this version, line 8 could  < {		not be used for DDCMP, because input device object 8 was 7 {		being used to signal received characters on regular   {		(non-ddcmp) lines. I {      ********** ALL user-written drivers that implement DDCMP MUST make , {      ********** the following changes !!!!1 {		1) Define the new constant MAX_DEVICE_OBJECTS, 5 {		   and change the variable ASYNC_INPUT as follows: 
 { 		    CONST : {    		        max_device_objects = max_line_number + 1;  
 { 	  	    VAR B {    		    	async_input : array [0..max_device_objects] of device;	 {		   			 A {		2) In the input ISR, use device object X+1  (async_input[X+1]) B {		   to signal input for DDCMP on line X, and use device object 0? {		   (async_input[eln$ddcmp_v2_term_device_number]) to signal  ' {		   input for regular terminal lines.  {		   < {		3) In the call to eln$ddcmp_v2_initialize_line, associate: {		   input device object X+1 with line X by changing the K {                  parameter  async_input[line]  to  async_input[line + 1].  { # {	V3.2-08 July 17, 1988 - J. McGray : {		Handle DDA i/o and regular terminal i/o in ONE process.' {		Put an exception hander in SET_CHAR. 9 {		Take out disable/enable interrupts from around call to  {		  Initialize_line.  { # {	V3.2-09 July 25, 1988 - J. McGray / {		fixed cntrl key processing bug in get_action  { % {	V3.2-10 October 6, 1988 - J. McGray 6 {		In initialize_interface, lower IPL before executing {		EXIT instruction. { ) {	V4.0-00   November 28, 1988  J. McGray	 2 {		- Added DDA support for the following function: {		  dda$_fnc_assert_break { 1 {		- Modified the output ISR to keep reading from 7 {		  the transmit fifo until tx_action is clear.  While 3 {		  it is not necessary, it does improve interrupt 
 {		  latency.  {   {		January 18, 1989 - J. McGray	3 {		- Added DDA support for the following functions: : {		  dda$_fnc_read (min/max reads, timeout, and reads with: {		  a terminating mask of characters) and dda$_fnc_write. {   {		January 19, 1989 - J. McGray	3 {		- Added support for line PASSTHRU characteristic / {		  and the READ_PASSTHRU read characteristic. 6 {		  Line PASSTHRU is now in the line parameter record# {		  that is passed in from EBUILD. ? {	    ********************************************************* ? {	    *** All user-written drivers MUST use the new definition  : {	    *** of terminal_flags for the call to TC$READ_CHARS.? {	    *********************************************************  {			< {	       - Changed handling of isr      
        events to fix the problem5 {		 where an event could potentially get lost, due to 6 {		 multiple event(s) occurring before the main driver {		 process could unblock.@ {	    **********************************************************; {	    ***	 ALL user_written drivers must use the method of  9 {	    ***  processing isr events.  Note that EVENT is now ? {	    ***  defined differently in the TERMINAL_READ_DATA record ; {	    ***  and that CNTRL_CHAR and CNTRL_CHAR_POS no longer 2 {	    ***  exist in the TERMINAL_READ_DATA record.@ {	    ********************************************************** { $ {	V4.0-01 March 2, 1989 - J. McGray	3 {		- Added out-of-band signalling functionality for * {		  the following user-callable routines:" {			ELN$TTY_SIGNAL_OOB_CHARACTERS " {			ELN$TTY_CANCEL_OOB_CHARACTERS ! {			ELN$TTY_RECEIVE_OOB_CHARACTER 1 {	 	- Renamed EVENT (in line_Ctx) to EVENT_FLAGS.  { " {	V4.0-02 May 2, 1989 - J. McGray	7 {		  - Added support for error reporting for DDA reads. 8 {	    	    Report parity, framing, overrun, breaks, and 7 {		    overflow conditions.  Terminate the current read 7 {		    if an error occurs.  DAP reads are not affected.  { # {	V4.1-00 July 6, 1989 - J. McGray	 7 {		- Take out the check for get_ctrl_key requests whose 8 {		  circuits to the application have been disconnected.> {		  It is no longer needed becuase the circuit process which : {		  is waiting for the control key to be typed now does a9 {		  WAIT_ANY on the circuit process object, rather than  @ {		  suspend itself, so that it will detect a disconnect itself.; {		  This eliminates the 20 second timer in the main driver  {		  process.	 {	******* NOTE ******** 5 {		All user-written drivers MUST take out the call to 7 {		TC$CLEANUP_CTRL_KEY, because it tries to do a RESUME 3 {		of the process that calls TC$AWAIT_CTRL_KEY, and 7 {		that code has been modified in TERMCLASS.PAS so that   {		it no longer suspends itself.2 {		User-written drivers should simply take out the1 {		timer from the main process wait_any call, and 6 {		therefore take out the call to TC$CLEANUP_CTRL_KEY.B {	    - Modify dda$tty_read and dda$tty_write to return number of ' {	      bytes transferred = 0 if error.  { # {	V4.2-00 July 3, 1990 - J. McGray	 > {	    - Put in a timer after setting MASTER_RESET to make sure/ {	      that the board finishes initializing.    {--}      
 include $dap;  include $termclass;  include $physical_address; include $ddcmp_v2; include $stack_utility;  include $unibus; include $mutex;   1 include $elnmsg;	{ ELN error symbol definitions } : include $dda_utility;   { DDA data structure definitions }' include $kernelmsg;	{ KERNEL messages }    type?     { Record structure for queue entries for the terminal dda } +     { function dda$_fnc_sgnl_modem_events } $     dda_signal_event_record = record6 	entryq      	: queue_entry;   { Link list structure }9 	circuit_id	: port;		 { Circuit connection to a dda port} ' 					 {   (the circuit to ttax$access)} : 	response_port	: port; 	 { Port to send datagram of event}3 	user_data   	: integer;	 { User data - any value }      end; { record }   @     { Terminal DDA record for miscellaneous per-line variables }      dda_line_struc_misc = recordM         dda_signal_modem_q_lock  : mutex; { Lock for accessing modem queues } I         dda_terminal_char_lock   : mutex; { Lock for accessing terminal }  					  { characteristics} 1 	host_sync	   	 : boolean; { Input flow control } / 	modem_control	   	 : dda$_modem_control_types; + 	modem_state	   	 : dda$_modem_state_types;      end; { record }        nibble = 0..15;      bit_storage = [bit] 0..1; "     rate_tbl_entry = packed record 	value: [byte] nibble; 	valid: [byte] boolean;    	end;   $     parity_tbl_entry = packed record 	value: bits$1;  	valid: [byte] boolean;    	end;        { timing queue records }     queue_record = record  	entryq      	: queue_entry;% 	line	   	: integer;	   {line number} > 	time_at_timeout : large_integer;   {absolute time at timeout}= 	evnt		: timeout_event;   {type of timeout we are requesting}oC 	ignore_timeout  : boolean;  {true if there is not longer a  need }*A     end; { record }		    { for this timer. ie ignore the timeout}*       line_timer_state = record	C 	break_duration_started : ^queue_record; {latest break timer entry} C 	break_delay_started    : ^queue_record; {latest break timer entry}D? 	io_tmo_started	       : ^queue_record; {latest io timer entry}      end; { record }			       timeout_event = (N 		{O/ 		{	The following events are used to signal theR5 		{	main process (controlling process) for a timeout.E 		{} 		evnt$noevnt,			{no event}Y( 		evnt$break_duration,		{break duration}3 		evnt$break_delay,		{delay before break assertion}F 		evnt$io_tmo			{I/O timeout}	 		{  		{ Could add other timeouts 		{  		{} 		);  6     { General purpose record type.. one bit per line }$     bit_array = [word] packed record) 		flag : packed array [0..15] of boolean;  		end; { record }    ;     { Stores the duration of a pending break on each line }L     line_break_data = record 		du                                                                                                                                                                                                                                   B                        f $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             Y             ration : large_integer;P 		end; { record }         event_record = packed record 	local_event: isr_event_flags;  	local_nbr_cntrl_chars: integer; 	local_cntrl_char_idx: integer;A     end; {record}m   var .     { Headers of the dda signal event queues }E     dda_signal_modem_q  : array [0..max_line_number] of queue_entry; A  =     {dda_line_struc_misc record is defined in ddautil module}OG     dda_line_struc : array [0..max_line_number] of dda_line_struc_misc;f  M     {Need to be able to compare dda$_terminal_speed_types and EBUILD speeds }1     { to the driver speeds. }tO     { FALSE indicates this driver does not have the equivalent of the dda rate}F_     rate_array : [readonly] packed array [dda$_rate_none..dda$_rate_38400] of rate_tbl_entry :=  		(  (rate_none,FALSE),o 		   (rate_50,true), 		   (rate_75,true), 	 		   (rate_110,true), 	1 		   (rate_134_5,true), 	e 		   (rate_150,true),i 		   (rate_300,true),  		   (rate_600,true),  		   (rate_1200,true), i 		   (rate_1800,true), r 		   (rate             _2000,true),   		   (rate_2400,true), 	4 		   (rate_none,FALSE), {Not supported by cx driver} 		   (rate_4800,true), t 		   (rate_7200,true), o 		   (rate_9600,true), r 		   (rate_19200,true),  		   (rate_38400,true) );  e  b     dda_rate_array : [readonly] packed array [rate_50..rate_38400] of dda$_terminal_speed_types := 		(  dda$_rate_50, 		   dda$_rate_75, 	 		   dda$_rate_110, 	m 		   dda$_rate_134_5, 	m 		   dda$_rate_150,a 		   dda$_rate_300,  		   dda$_rate_600,  		   dda$_rate_1200, n 		   dda$_rate_1800, u 		   dda$_rate_2000, e 		   dda$_rate_2400, a4 		   {dda$_rate_3600,}  {not supported by cx driver} 		   dda$_rate_4800, . 		   dda$_rate_7200, i 		   dda$_rate_9600, _ 		   dda$_rate_19200,t 		   dda$_rate_38400 );a  O     {Need to be able to translate dda$_parity_type to driver supported SENSE. }sP     { FALSE indicates this driver does not have the equivalent of the dda type.}i     parity_array : [readonly] packed array [dda$_parity_space..dda$_parity_ignore] of parity_tbl_entry :=T3 		(  (oddp,FALSE),   {not supported by this driver}	 		   (oddp,true),      		   (even,true),    	  5 		   (oddp,FALSE),   {not supported by this driver} 	_4 		   (oddp,FALSE) ); {not supported by this driver}	  /     {Translate from driver SENSE to dda values}nR     dda_parity_array : [readonly] packed array [oddp..even] of dda$_parity_type :=< 		(  {dda$_parity_space,}     {not supported by this driver} 		   dda$_parity_odd,  		   dda$_parity_even );< 		   {dda$_parity_mark,}      {not sup             ported by this driver}< 		   {dda$_parity_ignore );}  {not supported by this driver}  =     timer_queue		: queue_entry;   {header of the timer queue}eK     timer_complete_q	: queue_entry;   {queue of completed timeout requests} @     request_queue	: queue_entry;   {header of the request queue}:     sync_lock		: mutex;	 {access lock for timing elements}8     my_timer	  	: large_integer; {for get_time routines}B     new_timeout 	: large_integer; {absolute time of next timeout} I     line_timer_struc    : array [0..max_line_number] of line_timer_state;r   var.     line_ctrl_dummy   : lctrl;   const $     { driver-specific dda constants}'     driver_class 		= dda$_class_tty;   s&     device_type 		= dda$_type_cx;	      :     input_buffer_size = 256;    {size of the input buffer}6     max_line_number   = 15;      {lines are 0 thru 15}/     max_device_objects = max_line_number + 1;  _  ;     max_read_buffer_size = 512;		{maximum read buffer size}l  &     ipl$_power = 31;			{powerfail ipl}  B     handle_xon_xoff = false;		{xon/xoff handled by the controller}       input_vector_number = 1;     output_vector_number = 2;e  ?     pr$_sid = %x3e;     {system identification register number} 1     microvax_1_id = 7;  {system ID of microVAX-I}   3     { The CXA/B16 device supported by the CXdriver ,@     { DOES NOT NEED to delay before asserting break in order to K     { allow any previously transmitted characters to complete transmission.o?     { This is because the CXdriver only does DMA transfers, andoE     { a DMA tr             ansfer on a CXA/B16 board will completely transmit the f/     { last characters before setting tx_action.dC     { Other VAXELN serial line drivers that support break will use tI     { break_delay as a TABLE of delays required to complete transmission nN     { on a per baud-rate basis; Cxdriver just uses the constant BREAK_DELAY. }     break_delay = 0;  :     { Break duration intervals in tenths of microseconds }0     short_break	= -37500;    {3.75 milliseconds})     long_break	= -35000000; {3.5 seconds}1         {a! { Possible device characteristicsS {}%     { Baud rate bit representations }S     rate_none  = %b'0000';     rate_50    = %b'0000';     rate_75    = %b'0001';     rate_110   = %b'0010';     rate_134_5 = %b'0011';     rate_150   = %b'0100';     rate_300   = %b'0101';     rate_600   = %b'0110';     rate_1200  = %b'0111';     rate_1800  = %b'1000';     rate_2000  = %b'1001';     rate_2400  = %b'1010';     rate_4800  = %b'1011';     rate_7200  = %b'1100';     rate_9600  = %b'1101';     rate_19200 = %b'1110';     rate_38400 = %b'1111';       {bits per character}     char_length_5 = %b'00';n     char_length_6 = %b'01';      char_length_7 = %b'10';      char_length_8 = %b'11';*       {number of stop bits}      stop0 = 0;     stop1 = 1;       {parity stuff}
     oddp = 0;*
     even = 1;s  )     {modem indicators - no modem support}      modem    = true;     no_modem = false;A  $     { Default line characteristics }     default$tty_sync		= TRUE; )     default$char_length		=      "        char_length_8;r     default$stop_bits		= stop0;*&     default$parity_enable    	= false;     default$sense		= even;#     default$baud_rate		= rate_9600;s     default$modem		= no_modem;     default$hardcopy		= false;      default$ANSI_escape		= true;     default$echo		= true;C     default$passall		= false;_(     default$eightbit            = false;(     default$ddcmp_protocol      = false;     default$passthru		= false;   -     type       { Some useful types }D     byte    = 0..255;R     xbyte   = -128..127;     word    = 0..65535;      small_integer = 0..7;i       bits$1  = 0..1;      bits$2  = 0..3;c     bits$3  = 0..7;o     bits$4  = 0..15;     bits$5  = 0..31;     bits$6  = 0..63;     bits$8  = [byte]byte;k     bits$14 = 0..16383;c     bits$16 = [word]word;h  (     buffer_ptr  = ^terminal_read_buffer;3     any_pointer = ^anytype;		{a pointer to anytype}a&     char_str    = varying_string (12);%     lw_string   = varying_string (4);p       {SID register description }s2     system_identification_register = packed record         hardware_rev : byte;         miccode_rev  : byte;         reserved     : byte;         id           : byte;     end;   v     {T! { Async device registers contentsU {}     { Control status register }R     csr = [word] packed record@             ind_reg_address : bits$4;	{indirect register number}) 	    skip	    : boolean;	{skip self test}n5             master_reset    : boolean;	{master reset}oA             rx_int_ena      : boolean;	{receive interrupt enable}e?             rx_data_avail   : boolean;	{receive data available}a8             tx_line	    : bits$4;	{transmit line number}3 	    tx_dma_err	    : boolean;	{transfer dma error}30 	    diag_fail	    : boolean;  {diagnostic fail}A             tx_int_ena	    : boolean;	{transmit interrupt enable} 8             tx_action	    : boolean;	{transmitter ready}     	  end; { record }  -     { Receive buffer and transmit character }k"     rxb_txc = [word] packed record 		case boolean ofd8 		    true  : ( rx_char	    : char;	{received character}?             		      rx_line	    : bits$4;	{receive line number}g;             		      parity_error  : boolean;	{parity error}e:             		      frame_error   : boolean;	{frame error}<             		      overrun_error : boolean;	{overrun error}D             		      data_valid    : boolean );{receive buffer valid}: 		    false : ( tx_char       : char;	{transmit character}- 			      tx_valid      : [pos(15)] boolean );;           end; { record }o       { Line parameter register }        lpr = [word] packed recordI 	    disab_xrpt	    : boolean;	{disable x_on/x_off reporting via Rx FIFO}a0 	    diag_code       : bits$2;	{diagnostic code}C             char_length     : bits$2;	{character length (5-8 bits)} 6             parity_enable   : boolean;	{parity enable};             even_odd_parity : bits$1;	{parity sense select} ;             stop_code       : bits$1;	{number of stop bits} 9             rx_baud_rate    : bits$4;	{receive baud rate}s:             tx_baud_                                                                                                                                                                                   C                        ) $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             `      (       rate    : bits$4;	{transmit baud rate}           end; { record }1       { Line status register }        lstat = [word] packed record4 	    dhu_ident		: [pos(8)] bits$1;	{dhu11 ident bit} 	    modem_support	: bits$1;		0    	    clear_to_send       : [pos(11)] boolean;# 	    carrier_detect      : boolean;d# 	    ring_indicator      : boolean;r# 	    data_set_ready      : boolean;b             end; { record }e       { Line control register }e        lctrl = [word] packed record 	    tx_dma_abort : boolean; 	    iauto        : boolean;0             rx_en        : boolean;		{rx enable},             break        : boolean;		{break} 	    oauto        : boolean;+ 	    force_xoff   : boolean;		{force X-OFF} / 	    maint        : bits$2;		{maintenance mode}k 	    link_type    : boolean;:             dtr          : boolean;		{data terminal ready}6             rts          : boolean;		{request to send}           end; { record }     *     { Transmit buffer address register 2 }  #     txb_high = [word] packed recordl 	    tbuff_high   : bits$6; % 	    tx_dma_start : [pos(7)] boolean;v& 	    tx_ena       : [pos(15)] boolean; 	  end; { record }  (     tbuffad2_byte = [byte] packed record 	    tbuff_high : bits$6;	% 	    tx_dma_start : [pos(7)] boolean; 	 	    end;        { Register layout }p  #     async_registers = packed record      			async_csr	: csr;l     			rx_tx		: rxb_txc;     			line_param	: lpr; 			line_status     : lstat;d 			line_control    : lctrl;  			txb_addr1	: [word] word;d 			txb_addr2	: txb_high;  			tx_dma_count    : [word] word     		      end; { record }e  6     { Some pointers to the aforementioned structures }$     register_ptr = ^async_registers; i       { Line parameters record }'     ln_param_rec = [long] packed record A          char_length   : char_length_5..char_length_8;	{bits 0-1}u0          stop_bits     : stop0..stop1;			{bit 2}+          parity_enable : boolean;			{bit 3}r/          sense         : oddp..even; 			{bit 4}_9          rx_baud_rate  : rate_50..rate_38400;		{bits 5-8}e:          tx_baud_rate  : rate_50..rate_38400;		{bits 9-12},          modem         : boolean;			{bit 13},          hardcopy      : boolean;			{bit 14},          ANSI_escape   : boolean;			{bit 15},          echo          : boolean;			{bit 16},          passall       : boolean;			{bit 17} 	 eightbit      : boolean;!          ddcmp_protocol: boolean;4$          passthru      : boolean;			          end; { record }  &     { Circuit process data structure }     ct_data_base = record,I             line             : integer;    {line number for this circuit}S<             port             : port;       {connecting port}:             read_buffer_size : integer;    {record length}             end; { record }4     ct_ptr = ^ct_data_base;e  8     { Line configuration record sent by system builder }"     builder_params = packed record= 		dummy_word        : word;    {length of the varying string}d 		line              : integer;,                 parity_enable     : boolean;/                 sense             .             : oddp..even;0,                 modem             : boolean;,                 hardcopy          : boolean;,                 ANSI_escape       : boolean;,                 echo              : boolean;,                 passall           : boolean;,                 ddcmp_protocol    : boolean; 		cli		  : boolean;o 		passthru	  : boolean; 3                 character_length  : [pos(64)] byte;o)                 stop_bits         : byte;n(                 comm_speed        : word     		end; { record }y  $     { Communications region layout }     input_region = record	= 	line_ctx : array [0..max_line_number] of terminal_read_data;FF         ddcmp_protocol : packed array [0..max_line_number] of boolean;M         ddcmp_region : array [0..max_line_number] of eln$ddcmp_v2_rec_region;          end; { record }d  .     output_region = [aligned(2)] packed record? 	line_char         : [aligned(2)] array [0..max_line_number] of} 								 ln_param_rec;; 	xmt_waiting       : array [0..max_line_number] of boolean;tH 	line_valid        : [aligned(2)] array [0..max_line_number] of boolean;+  	indirect_register : [aligned(2)] integer;t@         bus_adapter       : boolean; { flag for unibus mapping } 	end; { record }  #     rec_region_ptr = ^input_region;s$     xmt_region_ptr = ^output_region;   u   varu   { F { Device, device records, communications region, registers, etc., etc. {}  >     async_input		   : array [0..max_device_objects] of device;B     async_output           : array [0..max_line_number] of device;,     rec_region             : rec_region_ptr;,     xmt_region             : xmt_region_ptr;*     register_location      : register_ptr;%     async_ipl              : integer; 0     controller_name        : varying_string (8);       { Register contents }s"     async_csr : csr;			{async csr}       { Line data structures }C     cx_struc : array [0..max_line_number] of terminal_data_pointer;      jparam   : builder_params;$     jp       : varying_string (100);         { Some misc. stuff }N     line_number : integer;            {current line number for initialization}P     sync_event  : event;              {event used to synchronize initialization}E     sub_process : process;	      {process ID used for line processes} 8     lines       : array [0..max_line_number] of integer;2     put_lock: array [0..max_line_number] of mutex;       bell : string(1) := ''(7);)     control_z_character : char := ''(26);t  E     break_state : bit_array;  { Save the current line break states. }o@     break_data  : array [0..max_line_number] of line_break_data; c     program cxdriver;f {++  {aG { This is the main driver procedure.  It creates the device, resets thed< { async interface, and starts a process for each async line.B { These line processes will do the actual i/o.  This process waitsE { (via a signal) for each line process to complete its initializationaA { before starting the next process.  Once all processes have beencI { started and the exec has been informed that initialization is complete,-: { this procedure perform      4       s dispatching of input characters. {c {--} var      p_number    : integer;     line_number : integer;     i           : integer;     line        : integer;     qbus_adapter : ^anytype;     my_proc      : process;=     signaled_object : integer;     read_started: ^semaphore;1     status: integer;     request_timer   : event;  #     timeout_occurred: ^semaphore;        begin=  /     eln$allocate_stack ( 2048 ); { four pages }0   {%8 { Get the controller name specified by the job parameter {}.     controller_name := program_argument ( 1 );   {1 { Create the async devicec {}$     create_device ( controller_name, 		    async_input,/ 		    vector_number     := input_vector_number,_*     		    region            := rec_region,1     		    registers         := register_location,})     		    priority          := async_ipl,d5     		    service_routine   := async_input_interrupt,;8                     adapter_registers := qbus_adapter );  $     create_device ( controller_name, 		    async_output,t4     		    vector_number     := output_vector_number,& 		    region            := xmt_region,. 		    powerfail_routine := powerfail_recovery,8     		    service_routine   := async_output_interrupt );   {$. { Do global level initialization of the device {}  1     { Determine the existence of device mapping }f  3     xmt_region^.bus_adapter := qbus_adapter <> nil;e  L     for i := 0 to max_line_number do rec_region^.ddcmp_protocol[i] := false;  .     for line_number := 0 to max_line_number do$ 	set_default_par      7       ams ( line_number );   { * { Check for user-specified line parameters {}     p_number := 2;(     jp := program_argument ( p_number );     while length(jp)<>0 do 	begin  	jparam := jp :: builder_params;' 	store_line_characteristics ( jparam );. 	p_number := p_number + 1;% 	jp := program_argument ( p_number );_ 	end;f   { " { Initialize the break state bits. {}     break_state::bits$16 := 0;   {n" { Initialize the typeahead buffers {}$     for i := 0 to max_line_number do5 	tc$initialize_typhd_buffers(rec_region^.line_ctx[i],e 				    default$tty_sync,r) 				    xmt_region^.line_char[i].passall, * 				    xmt_region^.line_char[i].eightbit,+ 				    xmt_region^.line_char[i].passthru);   5     { Synchronize with device during initialization }s$     disable_interrupt ( async_ipl );;     initialize_interface ( register_location, xmt_region );m     enable_interrupt;o   {;" { Create the synchronization event {}/     create_event ( sync_event, event$cleared );x   {e$ { Create the read started semaphor                                                                                                                                                                                                   D                        HQ* $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                                    9       e. {}     new(read_started);*     create_semaphore(read_started^, 0, 1);   { " { Create the Put_chars write lock. {}  * for line_number := 0 to max_line_number do 	begin% 	create_mutex(put_lock[line_number]);oB 	create_mutex(dda_line_struc[line_number].dda_terminal_char_lock); 	end;n   { $ { Create the request-for-timer event {}2     create_event ( request_timer, event$cleared );   {  { Create the timeout semaphore {}!     new(timeout_occurred); 						 2     create_semaphore(timeout_occurred^, 0, 1); 			   {Start the timing queues: }}      start_queue ( timer_queue );%     start_queue ( timer_complete_q ); "     start_queue ( request_queue );  3 {Sync_lock controls access of the timing records: }      create_mutex ( sync_lock );   0 { Create the timing process, ONE for all lines }     clear_event ( sync_event ); !     create_process ( sub_process,  		     timer_process,  		     sync_event, 		     timeout_occurred, 		     request_timer);       { Wait for completion }r     wait_any ( sync_event );   {g: { Start a process to service DAP and DDA i/o requests for  { each async line. {}#     { For each line out there ... } .     for line_number := 0 to max_line_number do 	begin 	clear_event ( sync_event );  1         { Create a process to service this line }a"     	create_process ( sub_process,     			 line_process,t     			 line_number, 			 sync_event,  			 read_started,  		         request_timer);   	{ Wait for completion } 	wait_any ( sync_event )
 	end; { for }        delete(sync_event);     *     { Enable interrupts on the interface }F     write_register ( register_location^.async_csr, rx_int_ena := true, 						   tx_int_ena := true );   {t9 { Signal the exec that we're done with our initialization	 {} 	initialization_done;p   {)O { Bump up the process priority of the dispatcher - note: this assumes a defaulteH { process priority of 8 for the line and circuit processes and that the I { process priority of the line and circuit processes will not be below 7.t {}     current_process(my_proc); 2     set_process_priority(my_proc,read_priority-1);   {x { Perform input dispatching  {}     while true do}
         begin   8 	wait_any (async_input[eln$ddcmp_v2_term_device_number], 		  read_started^, 	          timeout_occurred^,	  		  result := signaled_object );   	case signaled_object of 	1:{ 		{t 		{ Device signalled:   		{	Handle events for each line. 		{} 		 		begin , 		for line_number := 0 to max_line_number do 			process_event(2 				line_number,& 				rec_region^.line_ctx[line_number], 				cx_struc[line_number],/ 				xmt_region^.line_char[line_number].passall)p 		end; 	2:a 		{  		{ Read posted:4 		{ 	A read has been started.  Check to see if there3 		{	is any characters in the buffers for this line.n 		{}   		begin , 		for line_number := 0 to max_line_number do! 			with cx_struc[line_number]^ dor 			if read_started 			then_ 			    begin  				tc$process_input_characters(' 					rec_region^.line_ctx[line_number],  					cx_struc[line_number]);I 					if rec_region^.line_ctx[line_number].usr_ptr^.event_flags <> [] thenn
 				    begin , 					{ The buffers must have been swapped. }- 					{ The USR events have to be processed. }; 					process_event(r 						line_number,( 						rec_region^.line_ctx[line_number], 						cx_struc[line_number],2 						xmt_region^.line_char[line_number].passall);! 					tc$process_input_characters( ( 						rec_region^.line_ctx[line_number], 						cx_struc[line_number]);. 				    end; 				read_started := false 
 			    end 		end;   	3:i 		{81 		{ Timeout was signalled from the timer process:{ 		{} 		begin , 		    process_timeout_event (request_timer); 		end; {case = 3}: 	end; {Case}   	{; 	{	Now that we have processed each line that needed service : 	{	check to see if any I/O has completed for any lines. An; 	{	I/O completion is deferred until now so that all buffersp8 	{	that need swapping are processed as fast as possible. 	{}   + 	for line_number := 0 to max_line_number doa  		with cx_struc[line_number]^ do! 		if io_done AND read_in_progress  		then 			beginF 		        Cancel_timer (line_timer_struc[line_number].io_tmo_started); 			signal( read_complete,  			        status := status);  			io_done := false; 			read_in_progress := false;  			end;^   	end; { while }    end. n- procedure process_event(line_number: integer; % 			var line_data: terminal_read_data;_' 			var terminal: terminal_data_pointer;y 			passall: boolean);    {++  { # { process_event - Process ISR eventl {  { Routine Description: { ; {	This procedure will process events signalled by the input  {	ISR for each line. { 	 { Inputs:a {oA {	line_number - Line number for which events are to be processed.;' {	line_data   - Line typeahead buffers.l( {	terminal    - Internal line data base.D {	passall	    - True if input characters should be processed without {		       intrepretation.e { 
 { Outputs:9 {	line_data   - Line typeahead buffers possibly modified. ( {	terminal    - Internal line data base. {o {--}   {  {	Local variable declarations. {}   var  	stat: boolean;g 	status: integer;n' 	i: integer;		{ General purpose index }0 	control_char	    : char;n 	first_one	    : boolean;m 	next_element	    : integer; 	found_one 	    : boolean; 	disposition	    : byte;' 	remove_from_data    : boolean := true;_$ 	local_event_record  : event_record;! 	temp_ptr	    : typhd_buffer_ptr;]? 	done 	    	    : boolean := false;  { true if working on ISR }i: 			     { EVENTS and have finished processing USR EVENTS } 			     { if there were any. }   begin    {_1 {	Determine what needs to be done based on eventse {	signalled by the isr.  r {} While not(done) do begint  : { Process any events left in the USR EVENTS array first. }, if line_data.usr_ptr^.event_flags <> [] then	     begini1 	{ Copy USR event information to local storage: } . 	with local_event_record,line_data.USR_ptr^ do
 	    begin 		local_event := event_flags;  		event_flags := []; 	 + 		local_nbr_cntrl_chars := nbr_cntrl_chars;_ 		nbr_cntrl_chars := 0;[ 	m) 		local_cntrl_char_idx := cntrl_char_idx;  		cntrl_char_idx := 0; 	    end; {with}     end  else	     begin_4 	{ Process any events left in the ISR EVENTS array }1 	{ Copy ISR event information to local storage: }n 	disable_interrupt(async_ipl);. 	with local_event_record,line_data.ISR_ptr^ do
 	    begin 		local_event := event_flags;t 		event_flags := [];  + 		local_nbr_cntrl_chars := nbr_cntrl_chars;i 		nbr_cntrl_chars := 0;i  ) 		local_cntrl_char_idx := cntrl_char_idx;1 		cntrl_char_idx := 0; 	    end; {with} 	enable_interrupt; 	done := true;     end;   with local_event_record do begine  ( { See if there is an event to process: } if local_event <> [] then  begin_  *     if evnt$input_xoff IN local_event then 	{/ 	{	If an XOFF event was received then handle ite/ 	{	ONLY if input flow control is handled by the_5 	{	driver.  This is because if the controller handles;4 	{	input flow control then the controller would have1 	{	stopped sending output to the device (also thea2 	{	write_enable event and flag does not exist; see, 	{	the procedure TC$ALLOCATE_TERMINAL_DATA). 	{}r 	if terminal^.xon_xoff 	thenn 		with terminal^ dot 			begin 			clear_event(write_enable);  			write_ena_flag^ := false; 			end;h    )     if evnt$input_xon IN local_event thene 	{/ 	{	If an XOFF event was received then handle itr/ 	{	ONLY if input flow control is handled by thea5 	{	driver.  This is because if the controller handlese4 	{	input flow control then the controller would have1 	{	stopped sending output to the device (also thee2 	{	write_enable event and flag does not exist; see, 	{	the procedure TC$ALLOCATE_TERMINAL_DATA). 	{}  	if terminal^.xon_xoff 	thenn 		with terminal^ do  			begin 			write_ena_flag^ := true;p 			signal( write_enable);e 			if overflow_pending thenn	 				begin # 				stat := put_chars(line,1,bell);s 				overflow_pending := false; 				end; 			end;e    +     if evnt$cncl_typahd IN local_event thenl 	begin( 	    { Clear the user typeahead buffer }! 	    line_data.usr_ptr^.put := 0; 1 	    { Clear a possible       I       evnt$control_char event }o6 	    local_event := local_event - [evnt$control_char]; 	end;     ,     if evnt$control_char IN local_event then
     begin        if done then! 	{ We are processing ISR events }i 	temp_ptr := line_data.ISR_ptr     else! 	{ We are processing USR events }n 	temp_ptr := line_data.USR_ptr;=       with temp_ptr^ doe  %     if local_nbr_cntrl_chars > 0 then;	     begin    	first_one := true;	{init}  # 	while local_nbr_cntrl_chars > 0 do 
 	    begin  	    	found_one := false; {i                                                                                                                                                                                                                                   E                        ?L $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             +U      J       nit}  @  	        { Use local_cntrl_char_idx as the index of the first }& 	        {  control character found: } 	        if first_one then 		    beginv6 	    	    	control_char := data[local_cntrl_char_idx];B 		    	next_element := local_cntrl_char_idx; {NEXT_ELEMENT is the}? 			    { element following the control character just removed.}q 		    	first_one := false; 		    	found_one := true;e	 		    endg
 	        elseo@ 		    { Search the EVENTS array for the next control character }? 	    	    while ( (not found_one) AND (next_element < put) ) doe 			begin3 			    if ((events[next_element].error = false) ANDa@ 			   	(events[next_element].event_type = et$control_char)) then 		 	    	begin+ 				    { Found the next control character}p 		    		    found_one := true;/ 			    	    control_char := data[next_element];d 			        end 			    elsee	 				begint) 				    next_element := next_element + 1;n 				end; 			end;t   	    	if found_one theno, 	    	    { Process the control character: } 		    be      L       ginsA 		        { Bump any process waiting for the control character. }_2 		    	disposition := tc$check_oob_char( terminal, 						    line_data, 						    control_char);  ) 			{ Default to disposition = remove_it }h% 			remove_from_data := true;   {init}i   			if disposition = keep_it  			thena 				remove_from_data := falsei' 			else if not(disposition = remove_it)o 			then " 				if terminal^.read_in_progress  				then 					remove_from_data := false) 				else if disposition = keep_if_no_reade 				then 					remove_from_data := false;r   			If remove_from_data then,' 			    { Remove the character from the}l( 			    {  the typeahead buffer and the } 			    {  events array:  	  		    {}_
 		    		beginrG 		    		    { Remove the control character from the typeahead buffer: }   " 		    		    { *** Device IPL *** }% 				    disable_interrupt(async_ipl);q' 			    		if next_element < (put-1) thena4 			    	    	    for i := next_element to (put-2) do 						begin # 					    	    data[i] := data[i+1]; ' 					    	    events[i] := events[i+1];}
 						end; 			    		put := put - 1;  			            enable_interrupt;" 		    		    { *** Normal IPL *** }) 				    next_element := next_element - 1;i  % 			        end; {if remove_from_data}o 		    end; {if found_one}n  # 		next_element := next_element + 1;a4 	    	{ Decrement the count of control characters: }9 	    	local_nbr_cntrl_chars := local_nbr_cntrl_chars - 1;t 		+ 	    end; {while local_nbr_cntrl_chars > 0} '     end; {if local_nbr_cntrl_chars > 0}n"     end; {if evnt$control_char IN}  /     if evnt$buffer_overflow IN local_event theny 	with terminal^ do 		beginl  / 		{	If the terminal is not in passall mode thena 		{	output the bell character. 		{} 	sB 		if not(passall OR line_data.passthru OR line_data.read_passthru) 		then 			{( 			{	If xon and xoff support (TTSYNC) is' 			{	required check to see if output is  			{	disabled. 			{}	 			if terminal^.xon_xoff 			then 	 				begini 				if not(write_ena_flag^)) 				then 					overflow_pending := true) 				else# 					stat := put_chars(line,1,bell)e 				endr 			{+ 			{	If NO xon and xoff (TTSYNC) support is_( 			{	required just output the bell char. 			{}t 			elsel# 				stat := put_chars(line,1,bell);i 	end; {with}    ,     if evnt$io_completed IN local_event then3 	{ If this line has a read in progress then process 2 	{ the data.  Otherwise, a race condition ocurred. 	{}u 	if terminal^.read_in_progress 	thenr
 	    begin2 		tc$process_input_characters(line_data,terminal);. 		if line_data.usr_ptr^.event_flags <> [] then 		    beginm2 			{ USR events were cleared at the beginning of }( 			{ this routine, so if after calling }4 			{ tc$process_input_characters here it is NOT [] }/ 			{ then the buffers must have been swapped. }o- 			{ The read was not completed yet because };5 			{ first the new USR events have to be processed. }g 			process_event(e 				line_number, 				line_data,
 				terminal, 
 				passall);04 			tc$process_input_characters(line_data, terminal);
 		    end;	 	    end;.       {l;     {  The CX16 driver does not recognize any other events.e     {}  	 end; {if}s  ' { Clear out the local event variable: }: local_event := []; end; {with}C   end; { while not() } end; c  9 procedure process_timeout_event	(request_timer : event );	   {++e {m { process_timeout_event  {o { Routine Description: {b; {	This procedure will process all timeout events signalled p {	for all lines. {r {  {--} varg     stat	: boolean;m     status	: integer;i     line_number : integer;     i		: integer;	@     ptr 	: ^queue_entry;  { pointer to timer_complete_q entries}:     entry_ptr	: ^queue_record; { pointer to queue records}#     done_process_timeout : boolean;s     empty	: boolean;4     lkahd_flag	: boolean := true; { lookahead flag }   beginc  "     done_process_timeout := false;  2     {Process each element of the timer_complete_q}%     while not done_process_timeout dol 	begin		    G     	    lock_mutex (sync_lock);  {make sure no one accesses the queue} $ 	    ptr := timer_complete_q.flink; ? 	    if ptr = address(timer_complete_q) then  {no more entries}	 		begins* 	            done_process_timeout := true;&     	    	    unlock_mutex (sync_lock) 		endv/ 	    else    {there is at least one more entry}e 	        begin  3 	    	{Remove the entry from the head of the queue} % 	    	remove_entry (timer_complete_q,r& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);   		{ See if it is still valid }# 		if entry_ptr^.ignore_timeout then  		    begino5 	    		dispose (entry_ptr);  {get rid of queue entry}a&     		    	unlock_mutex (sync_lock);  	 		    enda 	        else  ( 		    begine3 			{ Determine what needs to be done based on the }s  			{  timeout event signalled: } 			CASE entry_ptr^.evnt of   			EVNT$NOEVNT:c 			    begin) 	    			{ There is no event to process. }a 				dispose (entry_ptr);- 	    	    	        unlock_mutex (sync_lock)  s 			    end;) 	  			EVNT$BREAK_DURATION:n 			    begin2 				{ Break duration timer has expired, so clear }% 				{ the break state on the line.  } 0 				{ Delete the pointer to the timing record: }D 				line_timer_struc[entry_ptr^.line].break_duration_started := nil;&     	    			unlock_mutex (sync_lock); ) 				dda$_clear_break ( entry_ptr^.line,		. 						   register_location ); 6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;  	  			EVNT$BREAK_DELAY: 			    begin, 				{ Break delay timer is expired, so set }$ 				{ the break state on the line. }0 				{ Delete the pointer to the timing record: }A 				line_timer_struc[entry_ptr^.line].break_delay_started := nil;p&     	    			unlock_mutex (sync_lock); ' 				dda$_set_break ( entry_ptr^.line,		n 						 register_location );	0 			        add_timer_request ( entry_ptr^.line, * 					break_data[entry_ptr^.line].duration, 			    		evnt$break_duration,m? 					line_timer_struc[entry_ptr^.line].break_duration_started, e 				        request_timer);i6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;    			EVNT$IO_TMO:. 			    begin 				{I/O timeout has expired} 0 				{ Delete the pointer to the timing record: }< 				line_timer_struc[entry_ptr^.line].io_tmo_started := nil;&     	    			unlock_mutex (sync_lock); & 				with cx_struc[entry_ptr^.line]^ do 				if read_in_progress then
 				    begino& 					{ See if any characters came in }" 					{ during the timeout period }! 					tc$process_input_characters( , 						rec_region^.line_ctx[entry_ptr^.line],  						cx_struc[entry_ptr^.line], 						lkahd_flag);3 					if not io_done then io_status := eln$_timeout;_ 					io_done := false; 					read_in_progress := false;i 					read_w_term_mask := false; B 					rec_region^.line_ctx[entry_ptr^.line].isr_ptr^.event_flags :=W 						rec_region^.line_ctx[entry_ptr^.line].isr_ptr^.event_flags - [evnt$io_completed]; 1 					signal(read_complete,status := status);					l 				    end;6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;i   			OTHERWISE 			    begin 		            	{( 		            	{ Process other timeouts. 		            	{} &     	    			unlock_mutex (sync_lock);  	    			dispose (entry_ptr);   		            end; 		        END; {case}l* 		    end; {if entry_ptr^.ignore_timeout }  0 	    end; { if ptr = address(timer_complete_q) }.         end; {while not done_process_timeout }   end;  {procedure}l    : procedure initialize_interface ( registers : register_ptr;" 				 region    : xmt_region_ptr );   {++  {lH { This procedure will perform interface initialization either at startup { or after a powerfail.  {s	 {                                                                                                                                                                                                                                    F                        v $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                              "     [       Inputs:t {p0 {	registers points to the cxa16 device registers< {	region points to the transmit device communications region {r
 { Outputs: {a {	async interface initializeda {; {	5 { Note: This procedure should be called at device IPL  {  {--}   var      dummy : rxb_txc;     i : integer;   beginp  !     { Reset the async interface }{  6     async_csr := read_register( registers^.async_csr);&     if not async_csr.master_reset thenG          write_register ( registers^.async_csr, master_reset := true );a       enable_interrupt;o?     { Wait for 1/2 second to allow initialization to complete } "     wait_any ( time := -5000000 );$     disable_interrupt ( async_ipl );  *     { Wait until the reset has completed }  
     repeat9     	async_csr := read_register ( registers^.async_csr );b%     until not async_csr.master_reset;     1     { check if diagnostics failed. If not ignore}l&     { 8 characters in input buffer.		}        if async_csr.diag_fail then  	begin 	    enable_interrupt;	 	    exiti 	end;t       for i := 1 to 8 do 	begin) 	dummy := read_register(registers^.rx_tx); 	end;  end;      > interrupt_service powerfail_recovery ( xreg    : register_ptr;& 				       xregion : xmt_region_ptr ); {++m {tG { This is the powerfail recovery routine for the DZV-11 async interfacem {t	 { Inputs:a {U) {	std. interrupt_service procedure inputsf {c
 { Outputs: {a@ {	device reinitialized and circuit processes waiting to transmit
 {	signaled {c {--}   var      i       : integer;   beginl  #     { First, reinit the interface }r        initialize_interface ( xreg, 		           xregion );h  G     { Now reinit each line and check for xmtting circuit processes thatr       were waiting }  $     for i := 0 to max_line_number do 	begin   	{ Initialize this line }i4 	initialize_line ( i, xregion^.line_char[i], xreg );  - 	{ Anyone waiting to transmit on this line? }	    	if xregion^.xmt_waiting[i] then* 	    signal_device ( device_number := i );" 	xregion^.xmt_waiting[i] := false;  
 	end; { for }l  +     { Set the CSR up for the current line }d  %     write_register ( xreg^.async_csr,m 			rx_int_ena := true, 			tx_int_ena := true,: 			ind_reg_address := xregion^.indirect_register::bits$4);   end; o    0 procedure set_default_params ( line : integer ); {++t {;J { This procedure will set the line characteristics for LINE to the default { values {i {--}   begint  '     with xmt_region^.line_char[line] do	 	begin& 	char_length   := default$char_length;$ 	stop_bits     := default$stop_bits;( 	parity_enable := default$parity_enable;  	sense         := default$sense;$ 	rx_baud_rate  := default$baud_rate;$ 	tx_baud_rate  := default$baud_rate;  	modem         := default$modem;# 	hardcopy      := default$hardcopy; & 	ANSI_escape   := default$ANSI_escape; 	echo          := default$echo;	" 	passall       := default$passall;# 	eightbit      := default$eightbit;v0         ddcmp_protocol:= default$ddcmp_protocol;# 	passthru      := default$passthru;= 	end;   )     xmt_region^.line_valid[line] := true;	   end; 	    A procedure store_line_characteristics ( jparam : builder_params );R {++  { J { This procedure is used to store user-specified line characteristics into5 { the parameter record of the data base for this line  {e {--}   beginl  /      with xmt_region^.line_char[jparam.line] do	        begin  G     	{ Set the characteristics for this line - note: for now, you can'teG 	  set the character length and # of stop bits via the system builder } 0           parity_enable := jparam.parity_enable;(           sense         := jparam.sense; 	  {5 	  { Match up ebuild speed values with driver values _3 	  {    If not a valid speed then keep the default.  	  {}eI 	  If rate_array[jparam.comm_speed::dda$_terminal_speed_types].valid then  	      beginQ 		rx_baud_rate := rate_array[jparam.comm_speed::dda$_terminal_speed_types].value;nV 	      	tx_baud_rate := rate_array[jparam.comm_speed::dda$_terminal_speed_types].value 	      end;l+           hardcopy      := jparam.hardcopy;l.           ANSI_escape   := jparam.ANSI_escape;'           echo          := jparam.echo; *           passall       := jparam.passall;,           passthru      := jparam.passthru;   -           if jparam.character_length = 3 then} 	       begin;                 eightbit := true; 	       endp           else 	       begin;!                eightbit := false;	 	       end;  1           ddcmp_protocol:= jparam.ddcmp_protocol;i            if ddcmp_protocol then             begint$                ANSI_escape := false;$                echo        := false;#                passall     := true;	#                eightbit    := true;T?                rec_region^.ddcmp_protocol[jparam.line] := true;{             end;
        end   end; 1    8 procedure initialize_line ( line              : integer;( 			    line_parameters   : ln_param_rec;* 			    register_location : register_ptr ); {, {rK { This procedure will write the line parameters for this line to the propergM { line parameters register and enable the line for transmitting and receiving. {n	 { Inputs:[ {h" {	line number specifies which line< {	line_parameters contains the characteristics for this line8 {	register_location points to the dmf32 device registers { 
 { Outputs: {  {	line initialized {e1 { Note: This routine assumes device IPL or higher  {a {--} var{     lparam : lpr;e     temp_oauto : boolean;    begino       with line_parameters do  	begin           { Set line parameters })3     	write_register ( register_location^.async_csr,l 				ind_reg_address := line );7         write_register ( register_location^.line_param,  			        disab_xrpt	:= true,# 				char_length     := char_length,e, 			        parity_enable   := parity_enable,$ 			        even_odd_parity := sense,( 			        stop_code       := stop_bits,+ 			        rx_baud_rate    := rx_baud_rate, - 			        tx_baud_rate    := tx_baud_rate );u     J { Set oauto according to (not(passall) and tty_sync), but set iauto just } { according to not(passall). }   	if not(default$tty_sync)m 	thenn5 		temp_oauto := ( not(passall) AND default$tty_sync )  	else  		temp_oauto := not(passall);   *         { Enable this line for receiving }9         write_register ( register_location^.line_control,	          			rx_en        := true,& 			        oauto        := temp_oauto,  				iauto        := not passall, 				link_type    := modem );     	end { with };        with dda_line_struc[line] do 	begin. 	    host_sync     := false; { Unimplemented }4     	    modem_control := dda$_modem_control_driver;2     	    modem_state   := dda$_modem_disconnected; 	end;o  "     with line_timer_struc[line] do 	begin# 	    break_duration_started := nil;t$ 	    break_delay_started    := nil; # 	    io_tmo_started         := nil;s 	end;s   end; e    J interrupt_service async_input_interrupt ( device_registers : register_ptr;+ 					  inp              : rec_region_ptr );	 {++  {tD { Async_input_interrupt : async line input interrupt service routine { < { This is the input interrupt service routine for the CXA16.@ { It reads characters from the input silo and puts them into theJ { input buffer which is located in the input device record region.  If theM { input buffer state changes from empty to non-empty, the device is signaled.  {n8 {  Inputs :	inp - pointer to input communications region* {		device_registers - pointer to registers {o {  Outputs :	nones {e {--}   const 
 	xon    = 17;u         xoff = 19;   var 4 	rx_data          : rxb_txc;        {receive buffer} 	character: char;		{character}Q 	bump_device: boolean := FALSE;	{used to determine if device should be signalled}i: 	error: integer := -1;		{error type - es$break_detected, }+ 					{ es$framing_error, es$parity_error, }       					{ or es$overrun_error }   beginc   {b { Read the input register  {}:      rx_data := read_register ( device_registers^.rx_tx );   {dC { As long as there is input in the silo, put it in the input buffern {}       while rx_data.data_valid do        begin   	  { Ignore diagnostics }.% 	  if not ( (rx_data.frame_error) ANDi  		   (rx_data.overrun_error) AND" 		   (rx_data.parity_error) ) then=           if not inp^.ddcmp_protocol [ rx_data.rx_line ] thent             begin.( 		with inp^.line_ctx[rx_data.rx_line] do 		if isr_ptr^.put > length theny 		    begin  		    {k* 		    { The input buffer is full.  If the 0 		    { character is XON or XOFF and we are NOT 3 		    { in passall mode then inform the dispatcher u6 		    { that a XON or XOFF was found. Otherwise, bump . 		    { the dispatcher with a buffer overflow  		    { co                                                                                                                                                                                                                                                   G                        3ˉ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             & "     l       ndition./ 		    { Ignore all errors when buffer is full }r 		    {}. 	            if not ( (rx_data.frame_error) OR" 			     (rx_data.overrun_error) OR! 			     (rx_data.parity_error) ) 	
 		    then 		    if ( (tt_sync) and 	' 			 ( (ord(rx_data.rx_char) = xon) or  o+ 			   (ord(rx_data.rx_char) = xoff) ) and  	 			   (not passall) )e 	 	    thent 			begin) 			    if ord(rx_data.rx_char) = xon thenc	 				beginrH 				    isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xon];I 				    isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xoff];a 				endr 			    elsei	 				begin_I 				    isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xoff];.H 				    isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xon]; 				end; 			    bump_device := true
 		        endl
 		    else 			begin+ 			    { If the line is NOT in PASSALL modep& 			    { then signal a buffer overflow) 			    { condition. In any event remember + 			    { that an overrun condition occured.o	 			    {} % 		            if ( (not passall) AND ( 			         (not passthru) AND 			    	 (not read_passthru) ) 			    thenN
 			    	begin U 			            isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$buffer_overflow];) 			  	    bump_device := truee 			    	end;! 			    isr_ptr^.overflow := true;r 			end;n& 		    end { if isr_ptr^.put > length } 		else 			begin 			    {1 			    { If the data has an error (parity, frame,e, 			    {  overrun, or break) then handle it 	 			    {}t$ 		            if rx_data.frame_error 			    theno	 				begin # 				    if rx_data.rx_char = chr(0)t 				    then# 				    	error := es$break_detected 
 				    else  $ 				    	error := es$framing_error;	 				end  			    else	$ 	       			if rx_data.overrun_error  				then# 				    { NOTE:  CX places a NULL }e' 				    {  character in the fifo when }n 				    {  an overrun occurs }! 				    error := es$overrun_error; 	       			else   				    if rx_data.parity_error  				    then 					error := es$parity_error; 	t 			    if error <> -1  			    theno	 				begint. 				    { Record the error and terminate the } 				    {  current read: }# 			            tc$read_error(error, % 					inp^.line_ctx[rx_data.rx_line], r 				        rx_data.rx_char, 					bump_device); 				    error := -1; 				enda 			    else ! 			    	{ The character is good }t
 			if passallh 			thena. 				tc$insert(inp^.line_ctx[rx_data.rx_line],  					rx_data.rx_char,} 					bump_device)r 			elsel 				tc$dispatch_character(% 					inp^.line_ctx[rx_data.rx_line], o 					rx_data.rx_char,n 					bump_device);+ 		        end; { if isr_ptr^.put > length }  		endr           else             begine,                if eln$ddcmp_v2_receive_isr (O                              address ( inp^.ddcmp_region [ rx_data.rx_line ] ), /                              rx_data.rx_char ) r 		then 		    { Signal line+1 now. }L                     signal_device ( device_number := (rx_data.rx_line + 1));             end; { if }   M         { Now read input register again to see if more characters are there } ?           rx_data := read_register ( device_registers^.rx_tx );           end; { while }d       if bump_device     then 	signal_device( 4 		device_number := eln$ddcmp_v2_term_device_number);   end;      K interrupt_service async_output_interrupt ( device_registers : register_ptr; , 					   xregion          : xmt_region_ptr ); {++  { F { Async_output_interrupt : async line output interrupt service routine {x= { This is the output interrupt service routine for the CXA16. B { It reads the CSR to determine which line interrupted and signals { the appropriate device.t {,@ {  Inputs :    xregion - pointer to output communications region1 {	       device_registers  - pointer to registerse {l {  Outputs :   nonee {  {--} var;:     async_csr        : csr;      {control status register}N     this_line        : integer;  {line number on which interrupt was received}   begin	   {g { Read the CSR {}?     async_csr := read_register ( device_registers^.async_csr );r      while async_csr.tx_action do 	begin$ 	    this_line := async_csr.tx_line;   	    {9 	    {Signal the interrupt and clear the xmt waiting flagm 	    {} 2 	    signal_device ( device_number := this_line );. 	    xregion^.xmt_waiting[this_line] := false;  B 	    { Read the CSR again to see if any other lines interrupted: }@ 	    async_csr := read_register ( device_registers^.async_csr ); 	end;c end; o        I function line_valid of type check_line_valid;	{ (line_number : integer )}]   begin	  6     line_valid := xmt_region^.line_valid[line_number];   end; l    - function put_chars of type output_characters;t" 	 { ( line_number       : integer;" 	     number_of_chars   : integer;@ 	     var output_buffer : string(number_of_chars) ) : boolean; } {++e {n3 { This function outputs characters to an async lineS {t	 { Inputs:r {i {	line number specifies line) {	number_of_chars specifies buffer length . {	output_buffer points to buffer of characters { 
 { Outputs: {l% {	characters output on specified linee= {	function returns false if line goes invalid, true otherwisev {e {--} type(     physical_addr = [long] packed record 	case boolean of  	    true  : ( full : integer ); 	    false : ( low  : word;_ 		      high : bits$6 )  	end; { record }   vara     output_character : char;     tx_csr           : csr;e     full             : boolean;:     count            : integer;d     done             : boolean; %     physical         : physical_addr;j     correct	     : integer;N     temp	     : ^string(3);c   begin   L     { Allow only one copy of this routine to execute per line at one time. }L     { This allows both the driver and the line processes to be performing  }L     { write operations at the same time.                                   }  &     lock_mutex(put_lock[line_number]);       { Always use DMA }  )         { Get the address of the buffer }l'         if xmt_region^.bus_adapter thend 	     begin 4 	     { hack because q-bus map wants odd addresses }% 	     temp := address(output_buffer);  	     if odd( temp::integer ) 
 	     then 		correct := 1
 	     else 		correct := 0;               { map the buffer }oF              unibus_map ( dev            := async_output[line_number],:                           buffer         := output_buffer,<                           buffer_size    := number_of_chars,<                           unibus_address := physical.full );/ 	     physical.full := physical.full + correct;i	 	     endr         else7              { Get the physical address of the buffer }nJ              physical.full := physical_address ( address(output_buffer) );   	{ Synchronize with device }  ! 	disable_interrupt ( async_ipl );m3      	xmt_region^.indirect_register := line_number;i  = 	{ Write the register number and then the transmit register }a  3     	write_register ( register_location^.async_csr,e 				rx_int_ena := true,h 				tx_int_ena := true,g% 				ind_reg_address := line_number ); ? 	write_register ( register_location^.txb_addr1, physical.low );_E 	write_register ( register_location^.tx_dma_count, number_of_chars );r> 	write_register ( register_location^.txb_addr2::tbuffad2_byte,# 				 tbuff_high   := physical.high,  				 tx_dma_start := true);   . 	{ Raise to powerfail IPL to set waiting bit }  " 	disable_interrupt ( IPL$_power );. 	xmt_region^.xmt_waiting[line_number] := true; 	enable_interrupt;/         wait_any ( async_output[line_number] );l  -         { Unmap the buffer if it was mapped }n"         if xmt_region^.bus_adapter 	then_ 	     beginn/ 	     physical.full := physical.full - correct;sH              unibus_unmap ( dev            := async_output[line_number],<                             buffer         := output_buffer,>                             buffer_size    := number_of_chars,>                             unibus_address := physical.full );
 	     end;  C     { Allow any other copy of this routine be eligible to execute }   (     unlock_mutex(put_lock[line_number]);  J     { Check for line valid to return status.  True is returned only if theD       line is up.  If not, wait to see if it comes back (checking inF       midstream).  Caller of this routine can then check line_valid to5       determine which dap status to return to user. }        put_chars := true;3     if not xmt_region^.line_valid[line_number] theni 	begin 	put_chars := false;$ 	wait_any ( time := modem_timeout );0 	if not xmt_region^.line_valid[line_number] then( 	    wait_any ( time := modem_timeout ); 	end;i   end;      9 process_block circuit_process ( circuit_struc :                                                                                                                                                                                                                                                    H                        "K $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             # "     }       ct_ptr );    {++e {pI { Circuit process : This process is started to service an i/o request fort { the specified line.  {tI { Inputs : circuit_struc - a structure containing information peculiar ton { this circuit {t { Outputs :	none {i {--}   vara3     read_buff               : terminal_read_buffer;e(     saved_record_attributes : dap$b_rat;@     saved_record_format: dap$b_rfm;		{ Record format from open }I     saved_fixed_control_size: dap$b_fsz;	{ Fixed control size from open }_&     this_line               : integer;&     context                 : integer;&     status                  : integer;-     circuit_flags           : terminal_flags;a y  - function open_action of type dap$open_action;e {++  {b$ {  Open_action - open action routine {_I {	This routine is called by the dap$server routine when the user process e {	executes an open statement.n {e
 {  Inputs: {  {	create			- create/open flagi" {	file_access 		- file access mode {	share 			- share accessr$ {	organization 		- file organization! {	record_format 		- record format.( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file optionse( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics* {	file_specification 	- file specification) {	fixed_control_size	- fixed control sizep0 {	context 		- driver specific parameter (unused) { 	a {  Outputs:w {f$ {	organization 		- file organization! {	record_format 		- record format	( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options ( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics {n {	return value = success {r {--}   begino  (     { Save specified record attributes }1     saved_record_attributes := record_attributes;g)     saved_record_format := record_format;e3     saved_fixed_control_size := fixed_control_size;t  0     { Set max record size and read buffer size }#     if (maximum_record_size = 0) or-- 	(maximum_record_size > max_read_buffer_size)	     then- 	maximum_record_size := max_read_buffer_size;f  ;     circuit_struc^.read_buffer_size := maximum_record_size;_  )     { Set some other various parameters };     organization := dap$k_seq;!     {record_format := dap$k_var;}      file_options := [];OL     device_char := [ dap$v_devrec, dap$v_devccl, dap$v_devtrm, dap$v_devidv, 		     dap$v_devodv ];       { Set up the flags record }n  ?     {*********************************************************} ?     {*** All user-written drivers must use the new definition }      {*** of terminal_flags!!! } ?     {*********************************************************}o       with circuit_flags dov 	begin0 	    if circuit_struc^.read_buffer_size = 1 then 		begine0 		    { Special case for a read passthru state } 		    echo := false; 		    edit_mode_read := false; 		endr	 	    elsee 		begin{+ 		    { Take value from default data base }{4 		    echo := xmt_region^.line_char[this_line].echo;  5 		    { The edit mode flag TRUE indicates that data } 3 		    { should be checked for editting functions: }  		    edit_mode_read := NOT ( . 			xmt_region^.line_char[this_line].passall OR. 			xmt_region^.line_char[this_line].passthru); 		end;  < 	    hardcopy  := xmt_region^.line_char[this_line].hardcopy;J     	    escape_recognize := xmt_region^.line_char[this_line].ANSI_escape; 	end;        { Success !!}r      open_action := dap$k_success   end; r  + function get_action of type dap$get_action;t {++  {	" {  Get_action - get action routine {tI {	This routine is called by the dap$server routine when the user process r- {	executes a get (read/readln/etc) statement.	 { 
 {  Inputs: {x4 {	record_access		- type of access to be used in get 1 {	record_number		- number of record to read (lbn) 4 {	record_options		- record options to be used in get. {	buffer			- address of buffer to receive data3 {	buffer_length		- length of buffer to receive datae0 {	get_buffer		- routine to get new larger buffer0 {	context 		- driver specific parameter (unused) { 	i {  Outputs:t {l. {	buffer_length		- length of actual datum read {	return value = success {d {--} vari     i, read_length: integer;     read_status: boolean;m     count: integer;_     eof: boolean;      tmp_buff: ^anytype;a  / function get_handler of type exception_handler;} {++ " {  get_handler - Exception handler {n
 {  Inputs: {t) {	Standard exception condition arguments.  {--} begino     get_handler := true;#     get_action := signal_args.name;      goto return; end;   begini     establish(get_handler);x  #     { If the line is up, continue }f  (     if xmt_region^.line_valid[this_line]     then 	begin 	{C 	{ If the record access is keyed and the record number is non-zero,_A 	{ then the record number represents a mask of control characterso 	{ that are to be awaited. 	{}+  G         if ( record_access = dap$k_key_acc ) and ( record_number <> 0 )i 	then              begint             count := 1;eD             read_buff[1] := tc$await_ctrl_key ( cx_struc[this_line],. 				    	     rec_region^.line_ctx[this_line],( 					     record_number :: ctrl_key_set, 					     circuit_struc^.port);d             eof := false;t 	    read_status := true;s             end-         else
 	    begin             { Normal read }tI 	    { Set up the flags record for this read with line data base values.}uH 	    { This makes certain that if the line values were changed through }I 	    { DDA SET_CHARACTERISTICS then the new READ will pick up these new } A 	    { values, but READs that are already in progress will keep }iB 	    { whatever values of ECHO, HARDCOPY, and ESCAPE RECOGNITION }( 	    { that they are currently using.  }  @ 	    {*********************************************************}@ 	    {*** All user-written drivers must use the new definition }  	    {*** of terminal_flags!!! }@ 	    {*********************************************************}   	    with circuit_flags do 		beginr1 		    if circuit_struc^.read_buffer_size = 1 thene 			begin1 			    { Special case for a read passthru state }c 			    echo := false;r 			    edit_mode_read := false;  			end
 		    else 			begin, 			    { Take value from default data base }5 			    echo := xmt_region^.line_char[this_line].echo;f 	t6 			    { The edit mode flag TRUE indicates that data }4 			    { should be checked for editting functions: } 			    edit_mode_read := NOT ( t/ 				xmt_region^.line_char[this_line].passall ORp/ 				xmt_region^.line_char[this_line].passthru);  			end;n  = 		    hardcopy  := xmt_region^.line_char[this_line].hardcopy;yG 		    escape_recognize := xmt_region^.line_char[this_line].ANSI_escape;  		end;  O                 read_status := tc$read_chars ( rec_region^.line_ctx[this_line],o 					cx_struc[this_line],a 					read_buff, , 				        circuit_struc^.read_buffer_size, 					count,: 					circuit_flags, 	 					eof,d 					put_chars,  					line_valid );	 	    end;    	{ 	{ If success, return the data3 	{ For VFC files, place a control field on the datai 	{}    	if read_statuse 	thenf
 	    begin  ' 	    if saved_record_format = dap$k_vfc 	 	    then 1 		read_length := count + saved_fixed_control_sizem	 	    else  		read_length := count;   C 	    { Check the buffer for overflow. If so, allocate new buffer. }c  # 	    if read_length > buffer_lengthA	 	    then $ 		buffer := get_buffer(read_length);  D 	    { Copy the input to the supplied buffer and return the length }  ' 	    if saved_record_format = dap$k_vfc 	 	    thenr 		begint+ 		for i := 1 to saved_fixed_control_size do 1 		    buffer^::terminal_read_buffer[i] := chr(0);0B 		tmp_buff::integer := buffer::integer + saved_fixed_control_size; 		end 	 	    else_ 		tmp_buff := buffer;   ; 	    tmp_buff^::string(count) := substr(read_buff,1,count);   " 	    buffer_length := read_length;   	    { Set the return status }   	    if eofs	 	    then  		beginf 		get_action := dap$k_eof; 		eof := false 		ende	 	    else  		get_action := dap$k_success  	    end   	else * 	    get_action := dap$k_device_not_ready; 	end       else& 	get_action := dap$k_device_not_ready; 	{ return:i     revert;e end; s  + function put_action of type dap$put_action;n {++  {t" {  Put_action - put action routine {tI {	This routine is called by the dap$server routine when the user process  / {	executes a put (write/writeln/etc) statement.: {r
 {  Inputs: {t3 {	record_access		- type of access to be used in put 2 {	record_number		- number of record to write (lbn)4 {	record_options		- record                                                                                                                                                                                                                                                   I                        fR $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             ? "             options to be used in put. {	buffer			- address of buffer containing data4 {	buffer_length		- length of data in buffer to write0 {	context 		- driver specific parameter (unused) { 	t {  Outputs:R {e {	return value = success {i {--} var      start           : integer;     i               : integer;     number_of_chars : integer;     first_char      : char;y     write_status    : boolean;   beginn  A     write_status := tc$write_chars ( cx_struc[this_line], buffer,r- 				  buffer_length, saved_record_attributes,p 				  put_chars );       if write_status then 	put_action := dap$k_success     else& 	put_action := dap$k_device_not_ready;   end;      5 function truncate_action of type dap$truncate_action;z {++  {u, {  Truncate_action - truncate action routine {sH {	This routine is called by the dap$server routine when the user process  {	executes a truncate statement. { 
 {  Inputs: {m8 {	record_access		- type of access to be used in truncate { 	e {  Outputs:  {e {	return value = success {  {--} varp     stat : boolean;e   beginm  -     if xmt_region^.line_valid[this_line] thenf   	begin9         if ( (xmt_region^.line_char[this_line].echo) AND  . 	     (circuit_struc^.read_buffer_size <> 1) ) 	then              begino>             stat := tc$write_newline ( this_line, put_chars );5             {cx_struc[this_line].lf_needed := false;}n3             {cx_struc[this_line].lf_output := true}:             end;(         truncate_action := dap$k_success 	end     else+ 	truncate_action := dap$k_device_not_ready;c   end;       {++o {s { Circuit process code {/ {--}   begin   0     eln$allocate_stack ( 4096 ); { eight pages }   {s- { Save the line number in an accessible place  {}%     this_line := circuit_struc^.line;}   {a { Let DAP do it  {}A     status := dap$server (circuit_port    := circuit_struc^.port,a$ 			  open_action     := open_action,# 			  get_action      := get_action, # 			  put_action      := put_action,s) 			  truncate_action := truncate_action);h   {n! { Get rid of what we're not usingt {}#     delete ( circuit_struc^.port );s     dispose ( circuit_struc );   END; l  , process_block line_process ( line : integer; 			     evt  : event;p" 			     read_started : ^semaphore;  			     request_timer : event ); {++r {i, { Line_process : async process for each line {s7 { This procedure is started as a process for each line.t@ { Once the line has been properly initialized, it then waits forM { DAP and DDA connect requests and starts a circuit process for each request.e {d {--} var :     my_port          : port;            {line unique port}C     port_name        : varying_string (32); {the name of this line}p.     process_name     : name;	        {name ID}M     circuit_db       : ct_ptr;	        {pointer to circuit data base struct.}iJ     sub_process      : process;	        {process ID for circuit processes}>     dda_port         : port;            {line unique DDA port}C     dda_port_name    : varying_string (32); {the DDA name of this }f 					    { line - TTAx$ACCESS}2     dda_process_name : name;	        {DDA name ID}N     dda_sub_process  : process;	        {process ID for DDA circuit processes}     status	     : integer;      signalled_object : integer;      num 	     : integer;     char1	     : char;  + function handler of type exception_handler;} begina     handler := true; =     goto LINE_RETURN;  end;   beginf       establish(handler);   .     eln$allocate_stack ( 1024 ); { two pages }  F     { Create two ports and two universally known names for this line }  8     create_port ( my_port );	{create a dap message port}9     create_port ( dda_port );	{create a dda message port}e       num := line;)     char1 := chr (num MOD 10 + ord('0'));e     num := num DIV 10;     if num = 0   	then 
 	    begin* 	   	port_name := controller_name + char1;, 	   	dda_port_name := port_name + '$ACCESS'; 	    end 	elsev
 	    begin! 		port_name := controller_name + d& 			chr(num MOD 10 + ord('0')) + char1;) 		dda_port_name := port_name + '$ACCESS';*	 	    end;*       { Create dap process name }      create_name ( process_name,                    port_name,                   my_port );       { Create dda process name }*&     create_name ( dda_process_name,   &                   dda_port_name,                         dda_port );z  D     { Allocate the line data structure - xon/xoff support required }B     { Pass handle_xon_xoff to the xon_xoff field of the terminal }A     { data record.  This value will NOT be modified.  It merely } @     { indicates whether the DRIVER is responsible for handling }5     { received XON/XOFF (true is driver handles it) }b  /     tc$allocate_terminal_data ( cx_struc[line],d%                                 line,h0                                 handle_xon_xoff, 			        read_started );  <     { Initialize the line and signal the job when complete }     initialize_line ( line, 2                       xmt_region^.line_char[line],*                       register_location );  6     if xmt_region^.line_char[line].ddcmp_protocol then 	{D 	{ NOTE: The device object associated with DDCMP line X is ( X+1 ).  	{}uK 	eln$ddcmp_v2_initialize_line ( address ( rec_region^.ddcmp_region[line] ),a'                                   line, ,                                   async_ipl,8                                   async_input[line + 1],,                                   my_port );     signal ( evt );t       {rO     { Create port to be used for the DAP and DDA circuits and wait for connect cK     { requests.  Upon receipt of request, start up a process to service it.r     {}       while true doe 	begin. 	    { Wait for a DAP or DDA connect request } 	    wait_any( my_port,  		      dda_port, $ 		      result := signalled_object,  		      status := status );e   	    if signalled_object = 1 		then$ 		    { It's a DAP connect request } 		    beginn9 			if not xmt_region^.line_char[line].ddcmp_protocol thenc 			    begin 				{ It's not a DDCMP line }  e  7 			        { Create a new port and the data structure }e- 			        { to pass to the circuit process }  			        new ( circuit_db );$ 			        circuit_db^.line := line;* 			        create_port ( circuit_db^.port, 			        status := status );   		    	        if odd(status)h 			    	then
 				    begint, 			                accept_circuit ( my_port,H                                   	         connect := circuit_db^.port, 						 status  := status );r 			    	        if odd(status) 			    	        then 				            begin	5 		    		                { Start the circuit process }f2 			    	    	        create_process ( sub_process,7                                     			circuit_process,e6                                     	    		circuit_db, 							status := status );	 					      					        if not odd(status)  					        thene 					            begin3 				    		    disconnect_circuit(circuit_db^.port);r# 						    delete(circuit_db^.port);. 						    dispose(circuit_db); 				 	            end; 				            end 	 					elseS 				   	    begint" 					    delete(circuit_db^.port); 					    dispose(circuit_db);s 				        end; 				    endi 		    		else 				    dispose(circuit_db);  
 			    end 			elseC 			    begin# 			        { It is a DDCMP line }  }: 			        accept_circuit ( my_port, full_error := true );N 				    eln$ddcmp_v2_start_running ( address (rec_region^.ddcmp_region[line]), 		        	    put_chars ); 5 			    end; { if not xmt_region^.line_char[line]... }*	 		    end    		else  { if signalled_object }r 				 		    begins( 		        { It's a DDA connect request }  6 		        { Create a new port and the data structure }, 		        { to pass to the circuit process } 		        new ( circuit_db );b# 		        circuit_db^.line := line;t) 		        create_port ( circuit_db^.port,n 		        status := status );	   	    	        if odd(status) 		    	then  			    begin, 		                accept_circuit ( dda_port,) 	         			connect := circuit_db^.port,_ 					status  := status );] 		    	        if odd(status)i 		    	        thens 			            begin		4 	    		                { Start the circuit process }5 		    	    	        create_process ( dda_sub_process,[ 						dda_circuit_process, 				    		circuit_db,  			     			request_timer,s 						status := status );s	 					    	 				        if not odd(status) 				        then 				            begina2 			    		    disconnect_circuit(circuit_db^.port);" 					    delete(circuit_db^.port); 					    dispose(circuit_db);  			 	            end;h 			            end 				else 		                                                                                                                                                                                                                                                   J                        3t $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                                          	   	    begin! 				    delete(circuit_db^.port);u 				    dispose(circuit_db); 			        end;f
 			    end 	    		elset 			    dispose(circuit_db);+  # 		    end;  { if signalled_object }        end; {while true}    LINE_RETURN: end; { process } w+ process_block timer_process ( evt  : event;e& 			     timeout_occurred : ^semaphore;  			     request_timer : event );   {++ 5 { TIMER_PROCESS : general timer process for all lineshM {   Accepts requests for starting timers, and signals main code upon               timeout.	 {--} {++t {a {_ {--}   var_     status: integer;(     sigstat	 : integer;	{ local status }*     wait_stat	 : integer;	{ local status }9     timer_result : integer; 	{ result of a wait_any call}fA     entry_ptr	: ^queue_record;{ general pointer to queue records} K     timeptr 	: ^queue_entry;	{ pointer to queue entries in the timer_queue} L     reqptr 	: ^queue_entry; { pointer to queue entries in the request_queue}E     relative_time : large_integer; {difference between 2 time values} H     done_insert : boolean;	{ true if we have finished inserting all the}3 				{  request_queue entries into the timer_queue.}eI     done_checking_timer : boolean; { true if finished removing from the }t2 				{ timer_queue all the entries that have timed}/ 				{  out or that have ignore_timeout = true.}oE     tail_entry : boolean;	{ true if a record has to be added at the }:. 				{  tail position of the queue, rather than$ 				{  before the current position.}     first_element  : boolean;o     empty	   : boolean;o&     timer_active   : boolean := false;'     signal_main    : boolean := false; n     time_proc      : process;    begin   oJ     { Set the process priority of the timer to 7, above that of the line ]8     { processes and below that of the main dispatcher. }     current_process(time_proc);n2     set_process_priority(time_proc,read_priority);  #     signal ( evt,status:=sigstat );        {Wait for startup: }     while true doi	     beginc 	if timer_active	then	   	    wait_any(request_timer, r& 	             result := timer_result, " 	             time := new_timeout," 	             status := wait_stat) 	else    	    wait_any(request_timer, ;& 	             result := timer_result, # 	             status := wait_stat);     c 	clear_event(request_timer);  i, 	done_checking_timer := false;		{initialize}  r3 	REPEAT	{repeat until done_checking_timer := true } ; 	    timeptr := timer_queue.flink;  {point to first entry} c   , 	    { Is this the end of the timer_queue? }+ 	    If timeptr = address(timer_queue) then = 	    	done_checking_timer := true  {no more entries to check}h  l	 	    else  	        begin(     	        lock_mutex ( sync_lock );  C 	    	with timeptr::^queue_record^ do  { point to the queue record}  	    	    begin     ; 	                get_time(my_timer); 	{ get current time }	 ; 			{check if timer entry was cancelled or if timer expired} : 			if ((ignore_timeout) OR (time_at_timeout <= my_timer))  			then  			    begin			    d0 				{remove the current entry (the first entry)}% 			        remove_entry (timer_queue,  					entry_ptr::^queue_entry,  					empty, queue$head);1 				{insert the entry into the timer_complete_q:} ) 			    	insert_entry ( timer_complete_q,   		    			entry_ptr^.entryq,c% 				    	first_element, queue$tail );o2 				signal_main := true;	{signal timeout_occurred}
 			    end 			else	$ 			    {timeout has not expired yet}# 			    done_checking_timer := true;n   5 	    	    end;  { with timeptr::^queue_record^ begin}i$ 		    unlock_mutex ( sync_lock );  	   8 	        end; { If timeptr = address(timer_queue) begin}  t 	UNTIL done_checking_timer;t    {------ end common code ------}i  p     case timer_result of     0:		{timeout}t	     begin G 	{ Nothing special to do for timeouts that wasn't already done above. } G 	{  After this case statement, the timer will be resumed by setting   }e 	{  a new timeout value. }     end; {case 0}         1:		{request for timer} 	     beginf7 	done_insert := false;		{init - not done inserting yet}r  s 	REPEAT ! 	    lock_mutex ( sync_lock );  	pB 	    reqptr := request_queue.flink; {first entry in request_queue}   G 	    if reqptr = address(request_queue) then  {no more request entries}n 		begin   	            done_insert := true 		endt   4 	    else	{there is at least one more request entry}  r 	        begin  s; 	    	{Remove the entry from the head of the request_queue} " 	    	remove_entry (request_queue,& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);    		if empty thenn' 		   begin	{no more entries after this}n 			done_insert := true;  		   end; {if}  s@ 		if not entry_ptr^.ignore_timeout then  {if record still valid} 		    begin 0 		    { Insert the request into the timer_queue}D 	        	timeptr := timer_queue.flink; {first entry in timer_queue}: 			timeptr := timeptr^.blink;     {get back to the header}  LF next_entry:		timeptr := timeptr^.flink;     {identify the next entry.}; 			tail_entry := false; {add at CURRENT position, not TAIL}a  t% 			{ Is this the end of timer_queue?}e+ 			if timeptr <> address(timer_queue) then d' 			    begin  	{not end of timer_queue}oA 				with timeptr::^queue_record^ do  { point to the queue record}= 		    	    	    begin    )6 			                relative_time := time_at_timeout - ! 						entry_ptr^.time_at_timeout;l( 				        if relative_time <= 0 then  9 					    goto next_entry;  {queue entry is more imminent}n 				    end; {with}e
 			    end+ 			else		{we are at the end of timer_queue}n; 			    {Have to insert the record at the TAIL of the timer}p: 			    { either because all the timer_queue elements are }: 			    { more imminent than this request, OR there are no}; 			    { elements left in the timer_queue (so that putting}e: 			    { the entry at the tail is that same as putting it} 			    { at the head. }  			    begin 			        tail_entry := trueu 			end;u  d 			{Insert the request}_  f 			if tail_entry theno# 			    insert_entry ( timer_queue,   		    			entry_ptr^.entryq,e$ 				    	first_element, queue$tail ) 			elseR 			    begin1 				timeptr:= timeptr^.blink;  {get to previous } # 						 {entry and insert after it.}l  		    		insert_entry ( timeptr^, 		    			entry_ptr^.entryq, ' 		    		    	first_element, queue$head)  			end; {if tail_entry}	2 		    end { If not entry_ptr^.ignore_timeout then} 		else 		    beginwA 		        { This record never got into the timer_queue, because } 9 		  	{ the ignore bit was set while it was still in the }r6 		  	{ request_queue.  Since there are no longer any }6 			{ pointers to this record in the main code, we can}6 			{ dispose of the record now, rather than put it in} 			{ the timer_complete_q. }, 	    		dispose (entry_ptr);  {get rid of it} 		end;    { else }  e3 	    end;    { if reqptr = address(request_queue) }   	    unlock_mutex (sync_lock);    nA 	UNTIL done_insert  {Repeat until all request_queue records have}i. 			   {  been inserted into the timer_queue. }   end; {case = 1}a
     otherwise  	begin	{No other events} 	end;u     end; {End Case}f  q  t {for both case 0 and case 1:}      {      { Resume timing }d     {g?     { Set the new_timeout value to be the timeout of the first (5     {  element in the timer_queue, if there are any. lG     {  NOTE that the timeout of the first element of the queue may have1E     {  already passed, during the execution of this routine.  So the  ?     {  wait_any for the timeout may get satisfied immediately. 	     {}       lock_mutex (sync_lock) ;  ?     timeptr := timer_queue.flink; 	{first entry in timer_queue}   &     if timeptr = address(timer_queue)      then> 	timer_active := false		{no active entries in the timer queue}     else 	begin 	    timer_active := true;& 	    with timeptr::^queue_record^ do  ! 		new_timeout := time_at_timeout;i         end; {if}        unlock_mutex (sync_lock) ;     9     { Waited to signal main code until all entries that }r!     { timed out were processed. }	     if signal_main thenu
         begin  	    signal_main := false;  	    { Signal main driver code }/ 	    signal(timeout_occurred^, status:=sigstat)c 	end;r     end; {while true}    end; {process}    4 procedure Cancel_timer ( var ptr : ^queue_record ) ; { & { Cancel a previously requested timer. { + { INPUT: ptr => pointer to a queue_record.  A { OUTPUT: => Ignore_bit field of the input record is set to true.	& {         => Ptr is replaced with nil. {}   begin      lock_mutex (sync_lock );		K     if ptr <> nil then	   {do this check while we have control of the lock}	 	begin! 	    ptr^.ignore_timeout                                                                                                                                                                                                                                   K                        0` $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             L "             := true;(             ptr := nil 	end;s     unlock_mutex (sync_lock);	 end; {procedure} 	  - procedure add_timer_request ( line : integer; ! 			     interval : large_integer; ! 			     t_event  : timeout_event; ! 			     var ptr  : ^queue_record;l  			     request_timer : event );   {++s {tL { add_timer_request: add a timer request to the request queue for this line. { 2 { INPUTS:  Line => line for which to start a timerK { 	   Interval => length of time or absolute time to set the the timer for. E {	   t_event  => type of timer (eg. evnt$mod2sec is a 2 second timer)n> {	   ptr	    => the address that will hold the pointer to the 6 {		       queue record after it is added to the queue.E {	   request_timer => the event to signal when the request is queued.  {t {--} vart     entry_ptr	: ^queue_record;     save_ptr	: ^queue_record;g     tval	: large_integer;t     first_element : boolean;   begin  t0     {Cancel the previous timer, if there is one}     Cancel_timer (ptr);t  1     { Make sure time field is an absolute time. }      if interval < 0 then 	begin! 	    { Interval is a delta time } / 	    get_time(my_timer);		{ get current time }	_M 	    my_timer := my_timer - interval;  { Determine ABSOLUTE TIME at timeout} t 	end     else! 	{ Interval is an absolute time }d 	my_timer := interval;        2     new (entry_ptr) ;	{create a new queue element}     entry_ptr^.line  := line;		t=     entry_ptr^.time_at_timeout := my_timer;  {absolute time}	 9     entry_ptr^.evnt := t_event;		{type of timer request}	n(     entry_ptr^.ignore_timeout := false;	  I     {queue the element in the request_queue and signal the timer process}d       lock_mutex (sync_lock );  	 4     insert_entry ( request_queue, entry_ptr^.entryq," 		   first_element, queue$tail );	C     signal (request_timer);   {signal the timer to add the request}d  A     {Update the timer state for this line by saving the pointer }CB     { to the queue record in case you have to cancel the request }     {  later on: }     ptr := entry_ptr;n      unlock_mutex (sync_lock);  	 	  end;  {process}s n  ? process_block dda_circuit_process ( dda_circuit_struc : ct_ptr;i$ 				    request_timer     : event );   {++i {gE { DDA Circuit process : This process is started to service a DDA I/O e! { request for the specified line.  {eB { Inputs : dda_circuit_struc - a structure containing information  { particular to this circuit {o { Outputs :	none {s {--}   vars7     dda_packet	     : ^dda$_packet;	{ dda message data}bI     dda_message_obj  : message;	        { The MESSAGE value identifying }e$ 					{ the next message in the port}I     message_size     : integer;  	{ receives the size (in bytes) of the }t 					{ received message data. } (     disconnect_status, status : integer;=     sgnl_oob_outstanding_ptr : ^boolean; { TRUE if there is } 0 			{ an outstanding request for oob signalling } 			{ on this circuit process. }    begino0     eln$allocate_stack ( 4096 ); { eight pages }  "     new(sgnl_oob_outstanding_ptr);'     sgnl_oob_outstanding_ptr^ := false;e       While true do:	     begin 2 	{ Wait for a message to come in over the circuit}# 	wait_any(dda_circuit_struc^.port);    	receive  (  dda_message_obj,  		    dda_packet,h 		    dda_circuit_struc^.port, 		    size := message_size,d 		    status := status );r   	If status = ker$_success then
 	    begin  @ 	 	{Request message must be at least the size of the dda header}) 		If message_size < dda$_header_size theni 		    begin  			delete (dda_message_obj);0 	    	        goto dda$_circuit_process_return  
 		    end;  * 		CASE DDA_PACKET^.HEADER.DDA$_FUNCTION OF 	  	    	    DDA$_FNC_GET_CHAR: 			begin 		    	    dda$tty_get_char( 				dda_message_obj,   		    		dda_packet,  				dda_circuit_struc^.line,4 				xmt_region^.line_char[dda_circuit_struc^.line]);6 		    	    {original message is DELETED by the driver}5 		    	    { and a new one is created and returned. }e 	        	end; 	i 	    	    DDA$_FNC_SET_CHAR: 	    		begin 		    	    dda$tty_set_char( 		    		dda_packet,s 				dda_circuit_struc^.line,3 				xmt_region^.line_char[dda_circuit_struc^.line],h 				register_location); 7 		    	    {original message is RETURNED by the driver}i- 		    	    { with just the status modified. }u 	    		end;     	    	    DDA$_FNC_ASSERT_BREAK: 	    		begin 			    dda$tty_assert_break( 		    		dda_packet,r     				dda_circuit_struc, 				register_location,3 				xmt_region^.line_char[dda_circuit_struc^.line],	 				request_timer);	7 		    	    {original message is RETURNED by the driver} - 		    	    { with just the status modified. }t 	    		end;e   		    DDA$_FNC_READ: 	    		begin 			    dda$tty_read( 		    		dda_packet,_     				dda_circuit_struc, 				message_size,  				request_timer);. 	    		end;	   		    DDA$_FNC_WRITE:$ 	    		begin 			    dda$tty_write(i 		    		dda_packet,}     				dda_circuit_struc, 				message_size); 	    		end;   ! 	    	    DDA$_FNC_SGNL_OOB_CHAR:  	    		begin 		    	    dda$tty_sgnl_oob( 		    		dda_packet,  				dda_circuit_struc^.line,& 				cx_struc[dda_circuit_struc^.line],2 				rec_region^.line_ctx[dda_circuit_struc^.line], 				sgnl_oob_outstanding_ptr); 	    		end;p   		    DDA$_FNC_CNCL_OOB_CHAR:: 	    		begin 		    	    dda$tty_cncl_oob( 		    		dda_packet,h 				dda_circuit_struc^.line,& 				cx_struc[dda_circuit_struc^.line], 				sgnl_oob_outstanding_ptr); 	    		end;e   	    	    OTHERWISE  	    		begin7 			    dda_packet^.header.dda$_status := ELN$_INVALFUNCe 	    		end;	           	END; {CASE}  H         	send(dda_message_obj, dda_circuit_struc^.port, status:=status);A 		if not odd(status) then	 {Couldn't send the message, delete it}p 	    	    begine 			delete(dda_message_obj); 1 			{ Check if the circuit has been disconnected } # 			if status = ker$_disconnect then ( 			    goto dda$_circuit_process_return;
 		    end;  $ 	    end  {if status = ker$_success} 	elseeD 	    If status = ker$_disconnect then   { circuit was disconnected }+ 	        goto dda$_circuit_process_return; u       end; {while true}y     DDA$_CIRCUIT_PROCESS_RETURN:> { If there is an outstanding request to be signalled for OOB } {  characters then cancel it: }t! if sgnl_oob_outstanding_ptr^ then 	     begin 4 	{ Delete a signal request queued for this circuit }A 	dda$_dequeue_circuit_reqs ( cx_struc[dda_circuit_struc^.line] );m     end;" dispose(sgnl_oob_outstanding_ptr);  /     disconnect_circuit(dda_circuit_struc^.port, & 		       status := disconnect_status);(     delete  ( dda_circuit_struc^.port );"     dispose ( dda_circuit_struc );   end;     ?P [inline] procedure DDA$_Dequeue_Circuit_Reqs (terminal : terminal_data_pointer); {e {oK {  This procedure will dequeue an OOB signalling request for the specified   {  circuit, if one exists.  N {  NOTE: currently there is only ONE queue for CXdriver (signal OOB charactersH {	queue) and only ONE request per line per circuit.  Therefore, we only G {	need to search one queue for one request and cancel that request.  In{D {	the future, if a circuit gets disconnected and we have to clean upD {	the requests for the circuit by calling dda$_Dequeue_circuit_reqs,8 {	THIS CODE WILL HAVE TO GO THROUGH ALL EXISTING QUEUES  {	AND CANCEL ALL REQUESTS. {e	 { Inputs:i {    terminal - line structure {e
 { Outputs:	 {    none  {  {--} vart!     current_process_id : process;h      begin	(     current_process(current_process_id);!     tc$cancel_oob_chars(terminal,e 		current_process_id); end;   	5 procedure dda$tty_get_char(var message_obj	: message;.% 			       request_ptr	: ^dda$_packet;$ 	 		       this_line	: integer;	2 		               line_parameters  : ln_param_rec); {	D { dda$tty_get_char - Get the characteristics for the specified line. {	 {--}   type     char_response = record 	header: dda$_header;	, 	data_buffer: dda$_terminal_characteristics; 	end;.   vart     new_message	: message;     response	: ^char_response;     status	: integer;r   begine  A     { Driver creates a new message and deletes the original one } <     create_message(new_message, response, status := status);       if odd(status) thenh	     begin,D 	{ Copy request header information, including unmodified user_data }2         response^.header := request_ptr^.header;    @ 	{ Return the size of the current revision of the data buffer. }  P         response^.header.dda$_buffer_size:= size(dda$_terminal_characteristics);  5 	delete(message_obj);  		{ Delete original message }	 : 	message_obj := new_message;	{ Return new message object }  A 	lock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  e  * 	{                                                                                                                                                                                                                                                   L                        , $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             Q@ "             Fill in with terminal characteristics } 	with response^.data_buffer do
 	    begin$ 	    	class         := driver_class;# 	    	dev_type      := device_type;i6 	    	revision      := dda$tty_terminal_char_revision;  > 	        host_sync     := dda_line_struc[this_line].host_sync;? 	    	tty_sync      := rec_region^.line_ctx[this_line].tt_sync; ; 		modem_control := dda_line_struc[this_line].modem_control;	  * 	    	echo 	      := line_parameters.echo;/ 	    	passall       := line_parameters.passall;t7     	        passthru      := line_parameters.passthru; 3 	    	escape        := line_parameters.ansi_escape; , 		eight_bit     := line_parameters.eightbit;3 	    	scope 	      := not line_parameters.hardcopy;o5 	    	parity        := line_parameters.parity_enable;f; 		parity_type   := dda_parity_array[line_parameters.sense];i9 	    	char_size     := (line_parameters.char_length + 5);e6 	    	ddcmp         := line_parameters.ddcmp_protocol;@ 		line_speed    := dda_rate_array[line_parameters.rx_baud_rate];- 	    	modem_support := line_parameters.modem;c  / 		{ No modem support, so just send back false }  	    	ring 	      := false;( 	    	cd   	      := false;  	    	cs   	      := false;u 	    	dsr  	      := false;r 	    	dtr  	      := false;. 	    	rts  	      := false;i
 	    end;	C 	unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);     . 	response^.header.dda$_status := ELN$_SUCCESS;       end {if odd(status)} else	     begin ! 	if (status = ker$_no_object) or   	   (status = ker$_no_pool) or ( 	   (status = ker$_no_memory)s 	thenn 	    status := ELN$_NORESOURC;  + 	request_ptr^.header.dda$_status := status;      end;   end; {procedure}   :> procedure dda$tty_set_char( var request_ptr 	  : ^dda$_packet;% 	 		        this_line   	  : integer;s3 		            var line_parameters   : ln_param_rec;a0 	  		        register_location : register_ptr ); {.J { dda$tty_set_char - Set the characteristics for the specified line, using, {		  the new values from the message packet. {m {--}   type     set_char_request = record  	header: dda$_header;o, 	data_buffer: dda$_terminal_characteristics; 	end;d   vari%     status	: integer := ELN$_SUCCESS;t     version	: integer;     temp_sync	: boolean;       + function handler of type exception_handler;t begin  status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or o     (status = ker$_no_memory)  then     status := ELN$_NORESOURC;    goto return; end;   begin        establish(handler);n  C     { Make sure the received data buffer is at least big enough to}s=     { contain the revision number, otherwise it is invalid. }}I     if (request_ptr^.header.dda$_buffer_size < dda$_char_revision_offset)e     then  	raise_exception(ELN$_INVALREC);  D     version := request_ptr::^set_char_request^.data_buffer.revision;     { ;     { Make sure the revision is valid, and if so, that the r>     { buffer size matches the size for that revision number: }     {}     CASE version ofe
 	1:  beginJ 	    	if (request_ptr^.header.dda$_buffer_size <> dda$_char_1_buffer_size) 	    	then s% 		    raise_exception(eln$_invalrec); 	 	    end;m  
 	2:  beginF 		if (request_ptr^.header.dda$_buffer_size <> dda$_char_2_buffer_size) 	        then % 		    raise_exception(eln$_invalrec); 	 	    end;h  
 	OTHERWISE
 	    begin! 		raise_exception(eln$_invalrec);o	 	    end;      end; { CASE }e  D     lock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);    7     with request_ptr::^set_char_request^.data_buffer dot 	begin  : 	    { Check some user-supplied values to make sure they }( 	    { are compatible with this driver.}= 	    { Do these checks BEFORE actually setting new values.  }i: 	    { Thus if there is an error, the user must resubmit }> 	    { the SET request with all his original request values. } 		 -> 	    char_size  := char_size - 5;  {Map to char_length values}( 	    if ( (char_size < char_length_5) OR  		 (char_size > char_length_8) )	 	    thene 		beginaH 		    unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  ) 		    raise_exception(ELN$_INVALCHARSIZ);  		end;  4 	    { This check may be different for each driver }( 	    If ( (line_speed < dda$_rate_50) OR$ 		 (line_speed > dda$_rate_38400) OR( 		 (NOT rate_array[line_speed].valid) ) 	 	    thenU 		begineH 		    unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  ' 		    raise_exception(ELN$_INVALSPEED);a 		end;  . 	    If ( (parity_type < dda$_parity_space) OR( 		 (parity_type > dda$_parity_ignore) OR+ 		 (NOT parity_array[parity_type].valid) ) i	 	    then  		beginsH 		    unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  ( 		    raise_exception(ELN$_INVALPARITY); 		end;  9 	    { No problems... So we can set the characteristics }d    	    {** class    - readonly **}  	    {** dev_type - readonly **}  	    {** revision - readonly **}  > 	    {------------ Line Parameters Register -----------------}% 	    {** ddcmp         - readonly **}t% 	    {** modem_support - readonly **}o# 	    line_parameters.echo := echo;  ( 	    line_parameters.passall := passall;8 	    rec_region^.line_ctx[this_line].passall := passall;, 	    line_parameters.ansi_escape := escape; , 	    line_parameters.eightbit := eight_bit; < 	    rec_region^.line_ctx[this_line].eight_bit := eight_bit;+ 	    line_parameters.hardcopy := not scope;t- 	    line_parameters.parity_enable := parity;e. 	    line_parameters.char_length := char_size;> 	    line_parameters.sense := parity_array[parity_type].value;B 	    line_parameters.rx_baud_rate := rate_array[line_speed].value;B 	    line_parameters.tx_baud_rate := rate_array[line_speed].value;3 	    { PASSTHRU is not in the revision 1 terminal }i2 	    {  characteristics record.  If the received }5 	    {  set_char request is for a version 1 record, }b$ 	    {  the don't change PASSTHRU: } 	    if version >= 2 then	 		begini/ 	    	    line_parameters.passthru := passthru;.? 	    	    rec_region^.line_ctx[this_line].passthru := passthru;  		end; 		+ 	    if line_parameters.ddcmp_protocol then  		begint+ 		    line_parameters.ANSI_escape := false; + 		    line_parameters.echo        := false;d* 		    line_parameters.passall     := true;* 		    line_parameters.eightbit    := true;6 		    rec_region^.line_ctx[this_line].passall := true;8 		    rec_region^.line_ctx[this_line].eight_bit := true; 		end;  9 	    rec_region^.line_ctx[this_line].tt_sync := tty_sync;   J 	    dda_line_struc[this_line].modem_control := dda$_modem_control_driver;B 	    dda_line_struc[this_line].host_sync := false; {unimplemented}  @ 	    { NO MODEM support so ignore the user-supplied values for } 	    { DTR and RTS. }t  - 	    { Modify the registers with new values }C% 	    disable_interrupt ( async_ipl );d    	    { Line parameter register }- 	    DDA$_Modify_Line_Parameters ( this_line,d 				         register_location,l 				         line_parameters );d 	    { Lctrl register } . 	    DDA$_Reset_tty_sync_register ( this_line, 					register_location,  					tty_sync, 					line_parameters.passall); 	    enable_interrupt;   	end;	  C 	unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  n   	status := ELN$_SUCCESS;   return:e     revert;t+ 	request_ptr^.header.dda$_status := status;i   end; {procedure}      B procedure DDA$_Modify_Line_Parameters ( line 	          : integer;- 				        register_location : register_ptr;=3 				        var line_parameters   : ln_param_rec );e   {e { O { This procedure will write the new line parameters for this line to the proper  { line parameters register.C {U	 { Inputs:R {R" {	line number specifies which line> {	line_parameters contains the user-specified characteristics  {	  for this linea5 {	register_location points to the CX device registerst {e
 { Outputs: {r# {	line parameter register modified.c {t1 { Note: This routine assumes device IPL or higher( {l {--} varn     lparam : lpr;i   beginc     with line_parameters dot 	begin               { Set line number}3     	write_register ( register_location^.async_csr,s 				rx_int_ena := true,  				tx_int_ena := true,p 				ind_reg_address := line );  #             { Set line parameters } C             lparam := read_register(register_location^.line_param);t+ 	    lparam.char_length     := char_length; - 	    lparam.parity_enable   := parity_enable;C% 	    lparam.even_odd_parity := sense;), 	    lparam.rx_baud_rate    := rx_baud_rate;, 	    lparam.tx_baud_rate    := tx_baud_rate;  D             write_register ( register_location^.line_param, lparam);  ? 	    {ECHO, PASSALL, EIGHTBIT, ESCAPE,                                                                                                                                                                                                                                                   M                        ^ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                              "             and SCOPE are not in a }e= 	    { register; they are just stored in the communications }LE 	    { region, which I already updated before calling this routine. }e   	end; {with} end;    = procedure DDA$_Reset_TTY_Sync_register ( line      : integer; - 			        register_location  : register_ptr; ( 			        new_tty_sync       : boolean; 				passall		   : boolean ); {++  {u@ { This procedure will modify oauto in the line control register.2 { The oauto must not be TRUE when passall is TRUE,? { So if user has set tt_sync to true, it can only be set in the_ { register if passall is false. C { tt_sync reflects what the user wants, but not necessarily what is  { in the oauto register. {s	 { Inputs:o { " {	line number specifies which line5 {	register_location points to the CX device registerse7 {	new_tty_sync specifies the new value to set oauto to. B {       passsall specified the current passall value for the line. {d
 { Outputs: {i {	oauto modified.a {m1 { Note: This routine assumes device IPL or higher  {  {--} varu     temp_oauto : boolean;p   begin        if not(new_tty_sync)     then0 	temp_oauto := ( not(passall) AND new_tty_sync )     else 	temp_oauto := not(passall);       { Set the line number }a2     write_register ( register_location^.async_csr, 				rx_int_ena := true,l 				tx_int_ena := true,l 				ind_reg_address := line );       { Modify oauto }F     line_ctrl_dummy := read_register(register_location^.line_control);(     line_ctrl_dummy.oauto := temp_oauto;)     line_ctrl_dummy.iauto := not passall;aF     write_register ( register_location^.line_control,line_ctrl_dummy); end;   i  procedure dda$tty_assert_break(   			request_ptr   : ^dda$_packet; 			circuit_struc : ct_ptr;+ 		        register_location : register_ptr;e1 	                line_parameters  : ln_param_rec;= 			request_timer  : event ); {tB { dda$tty_assert_break - force a serial line to the spacing state. {  {--} varo+     status	      : integer := eln$_success;l4     duration 	      : large_integer := short_break; &     delay	      : large_integer := 0;       begine  ;     { Don't allow break assertion if the line is not valid.n     {}7     if xmt_region^.line_valid[circuit_struc^.line] then. 	begin    	    with request_ptr^.header do
    	    beginn  2     	    	{ Determine the duration of the break: }M 	    	if not (dda$_sfb_short_break IN dda$_subfunction.assert_break_sfb) then  		    begin G 		    	if dda$_sfb_long_break IN dda$_subfunction.assert_break_sfb theni$ 	        	    duration := long_break 		    	else=S 	        	    if (dda$_sfb_user_duration IN dda$_subfunction.assert_break_sfb) theni< 			        { Do not allow absolute times for timeout value }* 			        if dda$_break_duration > 0 then7 				    status := eln$_invtimval	{ Invalid time value }f 			        else	6 		                    duration := dda$_break_duration;
 		    end;  / 	    	{ Determine the delay before the break: };B 		if dda$_sfb_user_delay IN dda$_subfunction.assert_break_sfb then 		    begin B 	                { Do not allow absolute times for timeout value }- 	                if dda$_break_delay > 0 thene> 		             status := eln$_invtimval	{ Invalid time value } 	                elsed( 		            delay := dda$_break_delay;	 		    end  		else# 	    	    { Use the default delay }  	    	    delay := break_delay;p   	    end; {with}  ) 	    if (status = eln$_success) then	      	        begin  < 		    { Obtain exclusive write access until break is done. }0 		    lock_mutex(put_lock[circuit_struc^.line]);   		    if delay <> 0 then 			begin> 			    { Save the break duration for when the delay times out}@ 		    	    break_data[circuit_struc^.line].duration := duration; 	 = 	  	            { Add an entry into the timer queue for the }h  		    	    { delay specified.  }7 			    add_timer_request ( circuit_struc^.line, delay, ; 				      evnt$break_delay,cE 				      line_timer_struc[circuit_struc^.line].break_delay_started,   				      request_timer);N
 		        endo
 		    else 		        begin A 		            { There is no delay to time, so start the duration rC 		            { timer now and set the break state in the register.}r. 			    dda$_set_break ( circuit_struc^.line,		" 			    		     register_location );: 			    add_timer_request ( circuit_struc^.line, duration,  				      evnt$break_duration,H 				      line_timer_struc[circuit_struc^.line].break_duration_started,  				      request_timer);t 		        end;  ! 		end; {if status = eln$_success}e 		 	end {if line_valid}     else3 	status := eln$_devnotready;    { Line is invalid }.  4     { Return the status in the same message packet }.     request_ptr^.header.dda$_status := status;   end;     b* procedure dda$_set_break ( line	: integer;/ 		           register_location : register_ptr);  { < { dda$_set_break - force a serial line to the spacing state. { > { NOTE: put_lock mutex is assumed to be locked before entering {       this routine.m {--} vari     line_ctrl_dummy   : lctrl; begino  $     disable_interrupt ( async_ipl );         { Set the line number }n/ 	write_register ( register_location^.async_csr,e 			 rx_int_ena := true,c 			 tx_int_ena := true,r 			 ind_reg_address := line );   	{ Set break bit }C 	line_ctrl_dummy := read_register(register_location^.line_control);t 	line_ctrl_dummy.break := true;lC 	write_register ( register_location^.line_control,line_ctrl_dummy);-     enable_interrupt;h  )     { Save the break state of this line }5#     break_state.flag[line] := true;)   end;    - procedure dda$_clear_break ( line  : integer;i1 		             register_location : register_ptr);e {o> { dda$_clear_break - clear the spacing state of a serial line. {t> { NOTE: put_lock mutex is assumed to be locked before entering {       this routine.e {--} var      line_ctrl_dummy   : lctrl;   begin I     { Make sure the break state is actually set, otherwise the put_lock }m     { will get out of sync: }_"     if break_state.flag[line] then 	begin% 	    disable_interrupt ( async_ipl );  		{ Set the line number }p0 		write_register ( register_location^.async_csr, 				 rx_int_ena := true, 			     	 tx_int_ena := true,d$ 			     	 ind_reg_address := line );   		{ Clear break bit }_D 		line_ctrl_dummy := read_register(register_location^.line_control);! 		line_ctrl_dummy.break := false; D 		write_register ( register_location^.line_control,line_ctrl_dummy); 	    enable_interrupt;  * 	    { Save the break state of this line }% 	    break_state.flag[line] := false;   ' 	    { Release exclusive write access }o" 	    unlock_mutex(put_lock[line]);  
 	end; {if} end;  5 procedure dda$tty_read( request_ptr   : ^dda$_packet;^ 			dda_circuit_struc : ct_ptr; 			message_size : integer; 			request_timer  : event ); {l/ { dda$tty_read - perform a DDA read on the liner {o {--} type@     bit_mask_set = packed set of 0..255; {set of oob characters}   vars6     lkahd_flag	  : boolean := true; { lookahead flag }8     status	  : integer := eln$_success; {assume success}     my_process	  : process;r   begin_  @     { Make sure there is enough buffer space in the message to }$     {  return the data to be read. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	begin  	    status := eln$_invalbufsiz;/ 	    request_ptr^.header.dda$_buffer_size := 0;  	end;   #     { Only read from a valid line }P?     if not xmt_region^.line_valid[dda_circuit_struc^.line] thenp 	begin  	    status := eln$_devnotready;/ 	    request_ptr^.header.dda$_buffer_size := 0;s 	end;   5     { Do not allow absolute times for timeout value } O     if (dda$_sfb_timeout IN request_ptr^.header.dda$_subfunction.read_sfb) theno9         if request_ptr^.header.dda$_read_timeout > 0 thenu
 	    begin9 	        status := eln$_invtimval;	{ Invalid time value }c3 	        request_ptr^.header.dda$_buffer_size := 0;e	 	    end;i  !     if status = eln$_success then  	begin  . 	    { Bump up process priority for the read }! 	    current_process(my_process);m5 	    set_process_priority(my_process, read_priority);t  1 	    { Obtain exclusive read access to the line } < 	    tc$set_read_lock ( cx_struc[dda_circuit_struc^.line] );  5 	    { Pre-set the I/O completion status to success } B 	    cx_struc[dda_circuit_struc^.line]^.io_status := eln$_success;  / 	    { Clear out the extended status longword }a6 	    request_ptr^.header.dda$_extended_status := zero;  3 	    { Make sure there is enough buffer space for }e9 	    { at least one character.  If not, return success. }r5 	    if request_ptr^.header.dda$_buffer_size > 0 thens  C 	    with cx                                                                                                                                                                                                                                                   N                        vG $      ELN042.B                         
  +[SYSEXE.SEAS$WORK_0000005C]CDNSC[_9\\1PAS;1                                                                                    H    h                          :            |JhB3Y_6bNXrHxgTFEUT)V}XS}W[.b0ݱASh¯`Zz3V0+e󗽳kOs&SNQu?avKM?3-Y?D|P<iXުr6Gk&'-NbqM9?g'/.FYk)MRdcXXTgl;pd)T>7g kI4ePW!1	PwYϞdRWO l7
e #5V0C(*T3fJ?W?}S̘8>k pCA {䢛R i:jWe
Fu%U
v~'_vgEjv
W{U¼oM#AMq@r"ebLЩ2p\a8Oz'u!ouBzL+@)T-;k0nv,xmU,cVl[+bNQb޶Zwԅ&-7mw3Dlѧ
W
$2 5:Y![4"
wJ

2'4aa?7A$#\4>N$1F7 Go̔'Sibκȏ;K݅<Y`誼 a/ 0f}[w4x_蛜cq&zV"hsKG&xkrUq
S9^7%ԇV߅߿qca̶%o ڐZm{-YADW!I Ǖ *ѲVA^~:~9p31ju>$`M_fCfÁ	WF?hSav[AxAXx \Uט6}YOM|4+ɲ:y1o'mR{@]k7W/dkBENeP37AXVwaz+Q	J4{3AԾxGgA	[uW:DZ;eP^(@9 z( 'Os0]c`ǜ qJ2YFMr7gKO)`sUdfW;d}OKr* ^{-dǐf+:/uCs[[>.yIW:Z˾Ԣ+tX}heSBC;Do!VG5m< !{br!S0mE	YۆU(7[L1~h|T:Ȯ̒}Nш}?f6֞"&zv:?v3xȡnUIxŉ_[(?Dx,x
[ЫWCHI4ӹvV~>J	V 
!, /r6Et4c0#e^Y	Iɿ~ j.e\@,,b<_~òЄHvy`1Qܢy9$ƹjZGuyld!
~3-o6%uUeyAg.SUYyρC*c_ؤ_uqwoŷ?63[O3,B?dCWҞs[wAE=lݾ9dZG8K[.A$8uq9g-a:r-<+LWX])`B#P<"^${fIQYLj"9-&&%difL[G?${axء`/"$Q}Ҿ$烏{%-ja~w~27g9 ǧ"ɑǞ6!bUY	_B
6m^]8x8јxݚ]nz%v=4 |so
↼x4_D#BRt 14[v$ ã9uÜGr!1OWW/Cg,_/k9^_rZ.OW}u_F+ 1YX@)&iUeJ	:9'j#5":Fq2dhjI)0Ow5}Q>Jm}I||uZgܯXtIl?z̥;w;`I IrFx"__g5SӯՎaߣ%QR$9I%3\Js.)zϋ@[w,6X^zMh_uppUq`7=\m.P xjw
/@кkHNz{O7i\UN
)٭AiW_e#r,LA93r9ΑlFݭEn<^=U(;hJFwĜAڭͰ`.9n\g9W{<kqAPEjxᦿf2q/?4䷕&K'RF`wگڛg\PKDcztgJG;iCL3}$9qSr_|%F*4)Yu}(Ssp@y= ?9(7&WH`suJ՚+.k*o?=lS?\T11G1	0=G8D:1=*ίa_=9&ͷU~T zvRoa~ZV;DL"*hfؿ >6CAfJ3wMsS]Bhf#
ɭhIdL{a B_+nsa7lj 2WM0Ҳ#"")[+}^=o$$͉C:1:`R2VѷWpd/YN7VXuF`qmE48a^"x)^eQ
4_K/L"X=- ߭_{-z~i[-G+y͛Y2[E)*Ԯ)4c{\F'Qk9 X<
<Fce
*BN!MtMeSf\[x>dNnat#O кD^-mwo9~w
#~0MWxFNeR&39{AĻWlIK$2m/Xkdm>-r..nE1uD6W~[uַ	}Y?=߿ulKw䌭QK1ֻS{hЎ}Ъh2$~nBurJ&z$w_w1 gпH੡@Bw{Չ`[PHpܴ@rt	B'dS_\XЙ'
id[;Ԩq)?oɝp6(#u
 O^Ez׼k*__DDtϩ3۵5/HR/(v1({# W氡bɟ$i#Ų#^5
?z)S벴ިOmH{'XN㹈S#wU1ǘyX_QpqBȆNvt
vWO!<d>
_3:N}f'j*h1z>֮Pܸ?|rsoQ;xL_]}$Y?,QY	:mK鏄X=Y$oGյ}ƭӜO8I0'%@OȀڠ\1b׵
yIHic(ߤ{I3+vXVSnώip4(08Z+Di	3͗J
meO`K:۰%%z"!tKzfngqI_xɥZ񉒝fxgW42jB|	cT M
im+H鶠q߼=,N8;4'om<pϛa?s@{R=O2F8<$d/9ۄ" y=o#kp4x9ӥrH"S$2F?E
ȍMϏL_MrN<GQA`34u<X($g/gsit۰^nx|/<z>Y\YGwb\Zh_ȳ|@d{3u9Pĺq,8Ҟ9rI(VS)W.̬C	h*HK!:X`w:2Ǐ^?1[i9/BGlc=q+"{/
~A(4xϢNqdbC~9/lZc&K%+xO)aH"(lLGh`^/m	B~|L۵w
xkAڎ+-*(cg週zٰ2Rhՙ>GS8W5@9 ԤQi6m]k3 QyN5{^uOdmlxTp3)F	^Rm|s\Y#އ0]OҌk2
3(-o#AIF'ޡ[nLB/:g*<^gsU@gs}-r$j2<cm-`ё)-N">\F V>빐CI$4ٶnoh|zn5)g~,k+Yk1~])>q9ia(,6=1ЍFEW^>'J!5)>XtHoi~uQ&͙+
KC6sܢ[`$^=#
>mdB>.>՚IO%Y(3=pSWj5n[j]1q_xvuwbнCGA< ra9(K;g-	aah"%n0eNtN7o(3
Bz1hr_"tdy.'P9xR>4/Q7Ҍ@qW :,
d6?j@sJmTK</ymvA &_!6{b!cŐ^Y .IGpm_[];}1e,M`C95hE-;'#K#7zH~l
bBkA5<Fd.)DC-g;k}y9[PEo\o{3np<a72&&![-hpUB27ptxWG
lUHi-l	_~Y{ZT; wK@g Bjgyhu|{ukl T6PdBSG]GnZq!Fsd KK~edZ\'.i7gUJ|>vX_9HjK/xL4jc_RڽCD~ '(-9]2[0@DB'%l|%i9̣"1'UpC6f-dt3
$q(\b\_*LWѴgVt9D;hWPDZ2ҏC}Ѷ[uqe%"yTd(({Nʰ Q4p"A&m# CǓna֑/1,ؔCVHw4*zVqS>0M	8=qIP2ahTMoy,DE[h%)!E8PWI%D@?BBJ
佁PMFb&c_kr;mD)ntJ8)мyz@&Zz,5"DOZſSf!4{ϧ,lCDQ[t,xW{\q};m=K
B^ncKm;.kuLZ*
Pvph&)BJ#;+5V5hÎ$->JP:^R谑fj[ 9j'mwXKD^h+ϑ2q
ۑ=_(LƄ*O'_~\F~YZ+^{C
U͞#$R%˺$"S'$1zPi)H/-vU..sa
+YleKlxD
`rا}Y@efdFѮ	z)m5!-JBI_9Ăd1;shʓp&\4oձ6NϷu$i)aD++Ʀb18"ÊהT!zA#"G=5AwB v`pVh
NىbipX-ԇ$߲̐֝aD+iGP	c[OJd^
 c}&!0?	nl <t6SAhK7DCiJ:]%B`@-0FZ9H+Z+p1?wvjBgj󹽰ş܁ѱ؊ϧǮԠ)!C C#|T~a}/ǰs$Z߮y\=-eA<,^D\2MUgi;]O^}o%\r:%ytXTq>w6lѕ'SB;A1]CTNG\;0Tڏ2l
?K 0Z0txfpھ-V*nYj!'>TQp;a	twB9X[R[UKW^kQja3.wl88ӖJ#.dI:յ: "@۝N  ǧx$
b&)؆%?ټۜ=Qy-פ+܏-ߌKRK'j;F+<'G:0ȗ
rJS.j]h$k<?O)c'%ՠ<#E; a`vyJVƕl,ؑP)ZrB]m'Kj]	
]yy\IJQD"mj$u266)Is>[GAٓj$5REU	}ceLhXK;-b#KwFt>Sq\j!#p+hhwJXmo8PE0ś6u~4l}z(/a\+{si2|"'H#< |Q=W'ˢ	$@lh%s3TBCiI,(]'ĞN~L_rt.RoWb"C7`[ĽwTlPؖ)dܺZȬ[ɣo9_2*5Ά`'̘؉~ORPsEߤLɦV-~O7+kU]ŬL-y;NOZK#C-e	xs-@ҷ-T.lPq|[?Z$Rd,>Qa`<[Eܻ%JۣLVĨǼiH8Ը.GhVf '4!G)!1x iO*=1
̻"; ܾsu
L'-XNZf"o"Bv>0aUE97eꀳHdIzp\{ķ΋ 䆐EMVn
WT.%DM]V|;s {`)zy/$O.uO %m_Ś'D t"|:f^44ltaR@#VlhbMõY-_c
ˀOB#e]>>^\ܑZA.(Ci)}|C(=~O1($rxpFBHMí 7"xb܊oL
=TZSǹf.k^᧦8þKzChYٜ$D)7Cc>ID!sl@BIkG| /V
<"i}X,qC%K,PޔX,hW 
q4)lY.)KKoվwiv>% IO_/*p;诹f7/ G_.Aoe| 1{̂/ !
8]xe4=$UQMJ_K,5\5fqF+J{UL|:)1	]5drV~O@Yj\-t[*g뽜mSeUC"DUȁIXt0U
or~LQvMЃ9Y\o!r.s_W=^g#
8LxR zh3iL"?IZw/tz<ܵ	o(7/kwKiic#h*|SL6NBX)wu!*T9aElH{` IEHSA?]VHYHsaUhT{kiPP4	<o=5u&
                                                                                                                                                                                   O                        5 $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                              
            _struc[dda_circuit_struc^.line]^,request_ptr^.header do_
 	    begin 		io_done := false;rF 		rec_region^.line_ctx[dda_circuit_struc^.line].read_passthru := true;  = 	    	if (dda$_sfb_minimum IN dda$_subfunction.read_sfb) then  		    beginD! 			if dda$_min_read_size = 0 then  			    begin( 				cur_read_length := dda$_buffer_size; 				max_read_size := 0;a+ 				{ Preset io_done to true, so that the } + 				{ read will be complete after copying }p) 				{ whatever data is currently in the }i 				{ typeahead buffers.}  				io_done := true;
 			    end 			elseh 			    begin			    m* 				cur_read_length := dda$_min_read_size;& 				max_read_size := dda$_buffer_size; 			    end;s	 		    endd 		else 		    begin ' 			cur_read_length := dda$_buffer_size;  			max_read_size := 0; h
 		    end;  ) 		{ Clear the number of characters read }  		cur_read_count := 0;  7 		{ If there is a terminating mask, and it is 0, then } @ 		{ just perform a normal read, as if there were no terminating} 		{ mask request. }:; 		if (dda$_sfb_term_mask IN dda$_subfunction.read_sfb) thenn0 		    if dda$_term_mask::bit_mask_set <> [] then 			begin$ 		    	    read_w_term_mask := true;4 			    term_mask::dda$_break_mask := dda$_term_mask; 			end;   , 		{ Pick up the address of the data buffer }= 		user_buffer::^anytype := address(request_ptr^.data_buffer);e  > 		{ See if there are any characters in the typeahead buffers } 		tc$process_input_characters(1 			rec_region^.line_ctx[dda_circuit_struc^.line],C% 			cx_struc[dda_circuit_struc^.line],E 			lkahd_flag);   0 		if not(io_done)   { Read is not complete yet } 		then 		    beging> 	    		if (dda$_sfb_timeout IN dda$_subfunction.read_sfb) then 		    	    begin! 				if dda$_read_timeout = 0 thenn
 				    beginn( 					{ Complete the read and return as }* 					{ many characters as were available }, 					{ in the typeahead buffers, reflected } 					{ in cur_read_count. }e# 				    	io_status := eln$_timeout;n 					io_done := true;a% 				        read_w_term_mask := falseU 				    ends 				else
 				    begine" 					{ Enter a timeout entry and } 					{ and continue the read. }sD 					add_timer_request ( dda_circuit_struc^.line, dda$_read_timeout, 					    evnt$io_tmo, C 					    line_timer_struc[dda_circuit_struc^.line].io_tmo_started, o 					    request_timer); 				    end;& 		    	    end; {if (dda$_sfb_timeout}   			if not(io_done) thens 			    begin% 			        { Continue with the read }. 				read_started := true;t 				read_in_progress := true;r) 				{ Signal the main driv             er process to }- 				{  process the read: }* 				signal(start_read^, status := status); 				wait_any(read_complete); 			    end; 	 		    end_ 		else 		    beginm 		        { IO_DONE is TRUE } ; 	    		IF ((dda$_sfb_timeout IN dda$_subfunction.read_sfb) i# 			    AND (dda$_read_timeout = 0) e  			    AND (cur_read_count = 0) = 			    AND (dda$_sfb_minimum IN dda$_subfunction.read_sfb) ) r 			THEN=9 			    { Give errors precedence over timeout completion }c6 			    { status.  If there was an error on the first }7 			    { character read, then the cur_read_count will }n 			    { be zero. }t 			    IF odd(io_status) c 			    THEN_6 			        {Change the status from success to timeout} 				io_status := eln$_timeout;
 		    end;   		{ 5 		{ Read is complete or timed-out. Return the number p4 		{  of characters read.  Count does NOT include the2 		{  terminating error character, if there is one. 		{}% 		dda$_buffer_size := cur_read_count;t; 		{ If there is an error, return the associated character }= 		{  to the user: }e( 		if ( (io_status = eln$_frame_error) OR+ 		     (io_status = eln$_break_detected) ORt' 		     (io_status = eln$_parity) ) thent 		    begin_4 			{ Copy the error character (string is 1-based): }E 			dda$_extended_status::dda$_extended_read_status.error_character :=a- 				substr(user_buffer^,dda$_buffer_size+1,1)o
 		    end;   	    end; {with}   	{ Return I/O status to user }Q 	request_ptr^.header.dda$_status := cx_struc[dda_circuit_struc^.line]^.io_status;   . 	{ Release exclusive read access to the line }: 	tc$clear_read_lock ( cx_struc[dda_circuit_struc^.line] );  4 	{ Reset the process priority back to the default. }3 	set_process_priority(my_process, normal_priority);r  $     end  {if status <> eln$_success} else    { Return status to user }-    request_ptr^.header.dda$_status := status;:     end; { procedure }    6 procedure dda$tty_write( request_ptr   : ^dda$_packet; 			dda_circuit_struc : ct_ptr; 			message_size   : integer);  {n/ { dda$tty_write - perform a DDA write to a lineb {u {--} varr8     status	  : integer := eln$_success; {assume success}#     output_buffer : ^string(32767);_     write_status  : boolean;   begin   @     { Make sure there is enough buffer space in the message to }(     {  contain the data to be written. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	begin  	    status := eln$_invalbufsiz;/ 	    request_ptr^.header.dda$_buffer_size := 0;. 	end;   !     if status = eln$_success thenl 	begin  4 	    { Obtain exclusive write access for this line }= 	    tc$set_write_lock ( cx_struc[dda_circuit_struc^.line] );d  + 	    { See if there is anything to write. }   	    { If not, return success. }5 	    if request_ptr^.header.dda$_buffer_size > 0 thene  C 	    with cx_struc[dda_circuit_struc^.line]^,request_ptr^.header do	 	    	beginb0 		    { Pick up the address of the data buffer }C 		    output_buffer::^anytype := address(request_ptr^.data_buffer);   ; 		    write_status := put_chars ( dda_circuit_struc^.line, s 					dda$_buffer_size,1 					substr(output_buffer^,1,dda$_buffer_size) );e    		    if not(write_status) then  		    	begin$ 			    status := eln$_devnotready;   			    dda$_buffer_size := 0;    		    	end;m
 	        end;r 	end;r       { Send back status }.     request_ptr^.header.dda$_status := status;  4     { Release exclusive write access for this line }>     tc$clear_write_lock ( cx_struc[dda_circuit_struc^.line] );   end; { procedure }   l< procedure dda$tty_sgnl_oob( var request_ptr 	: ^dda$_packet; 	 		    this_line 		: integer;) 			    terminal		: terminal_data_pointer;e* 			    var line_data	: terminal_read_data;+ 			    sgnl_oob_outstanding_ptr: ^boolean);	 {n3 { dda$tty_sgnl_oob - Signal out-of-band characters.) { * { INPUTS: request_ptr - dda request packet" {	  this_line - serial line number {oF { OUTPUTS: sgnl_oob_outstanding_ptr^ -  set to true if the request for9 {	    oob signalling is successful.  Only one request for 5 {	    oob signalling can be outstanding at a time fore {	    a dda circuit. {e {--}   varl-     status	        : integer := ELN$_SUCCESS; %     ctrl_wait_ptr       : ^ctrl_wait;d     this_process	: process;e4     this_process_ptr    : ^process;	  { Process ID }3     new_process_id      : process;	  { Process ID }r9     init_event		: ^event;	  { Event to signal after init}eB     process_Stat	: ^integer;	  { Status from create process call}     + function handler of type exception_handler;r begin  status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or d     (status = ker$_no_memory)i then     status := ELN$_NORESOURC;E   goto return; end;     begin      establish(handler);   0     { Only one request per circuit is allowed: }&     if sgnl_oob_outstanding_ptr^ then + 	raise_exception(eln$_request_outstanding);e  G     if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] then 	     beginn  3 	{ Create a record describing the waiting process }i 	new(ctrl_wait_ptr);  7 	{ Status and event to signal from create_process call}= 	new(process_stat);i 	new(init_event);	+ 	create_event (init_event^, event$cleared);a   	new(this_process_ptr);_ 	current_process(this_process);o# 	this_process_ptr^ := this_process;u  > 	{ Create the process to handle incoming oob char signalling }? 	create_process(new_process_id,	{returns id of created process}h5 		tc$signal_oob_chars,    {name of process to create}e$ 		terminal,		{terminal data pointer}# 		line_data,		{terminal read data }(4 		this_process_ptr,	{process id of creating process}% 		ctrl_wait_ptr,		{ctrl_wait record.}t  		request_ptr,		{message packet}7 		process_stat, 		{status of initialization in process};5 		init_event,		{event to signal after initialization}  		sgnl_oob_outstanding_ptr);   	wait_any(init_event^);{   	if not odd(process_stat^) then 
 	    begin 	    	status := process_stat^; 	    	dispose(ctrl_wait_ptr);: 	    end         else' 	    sgnl_oob_outstanding_ptr^ := true;    	dispose(this_process_ptr);  	del                                                                                                                                                                                                                                   P                        f: $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]CXDRIVER.PAS;1                                                                                      i                             	s             ete(init_event^);i 	dispose(init_event);   J     end; {if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] }   return:s     revert;a+ 	request_ptr^.header.dda$_status := status;e   end; {procedure}   q; procedure dda$tty_cncl_oob( var request_ptr	: ^dda$_packet;y 			    this_line		: integer;) 			    terminal		: terminal_data_pointer;_+ 			    sgnl_oob_outstanding_ptr: ^boolean);n {eL { dda$tty_cncl_oob - Cancel a request for out-of-band characters signalling. {n* { INPUTS: request_ptr - dda request packet# {	  this_line  - serial line number_A { 	  sgnl_oob_outstanding_ptr^ -  true if there is an outstandingr6 {	    request for oob signalling for this dda circuit. {s {--}   var_&     status  : integer := ELN$_SUCCESS;2     current_process_id : process;	  { Process ID }       + function handler of type exception_handler;n begin  status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or e     (status = ker$_no_memory)  then     status := ELN$_NORESOURC;    goto return; end;     begind     establish(handler);;  4     { If there is a request outstanding, cancel it }&     if sgnl_oob_outstanding_ptr^ then 
         begin=) 	    current_process(current_process_id);n" 	    tc$cancel_oob_chars(terminal, 				current_process_id);( 	    sgnl_oob_outstanding_ptr^ := false;$ 	end; {if sgnl_oob_outstanding_ptr^}   return:n     revert; + 	request_ptr^.header.dda$_status := status;t   end; {procedure} end; {final end}                            ) * [SYSEXE.SEAS$WORK_0000005C]DATATOBJ.CLD;1 +  ,    .     /     4 ;                           - 
    0   1    2   3      K  P   W   O     5 @  6  ཀྵf  7 @J  8          9          G    H  J                       define verb datatobj 	image eln$:datatobj: 	parameter p1,prompt="Source",value(required,type=$infile); 	parameter p2,prompt="Object",value(required,type=$outfile)                                                                                                                                                                                                                                                                                                                                                                         ) * [SYSEXE.SEAS$WORK_0000005C]DATATOBJ.EXE;1 +  ,    . 	    /     4     	                        - 
    0   1    2   3      K  P   W   O     5   6 
  7 @)J  8          9          G    H  J                       0 D X     0205      (  
`       h(                                  DATATOBJ                               VAXELN V4.2-00 
 05-05                                     
       ?         +      g  
PASRTL_001      !        
LIBRTL_001                                                                                                                                                           D      OBJECT_FILE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    B      
INPUT_FILE                                                                                                                                                                                                                                                                                     VAXELN UtilityOBJECT_BASE.]p2p1$CODEV1.0^XC   ޯ   ޯ  SR:SP<SRPRRVVV2STTRVRRRS:URFP<RSPSSRVTRVRRRR00(F(R2R~ #     R2R~h  h  DHSSR2RVVIVR,S RJVFCVFCRύbVW0 @H(GCW(GCWhSWRRc cc(cDhf  DE, FhRb(Dh=  DEV(VFhS2VRRRc cc(cDh   DEF
GHLSSR2RVVNVR,S ROhSVVc cc(cDh  DEFJPKhRb}Dhw  1 1  R( b N  < VWVVV   V\\S\\S\VDSE\R(RGFhS\RRc cc(cDh  \WV1nDEGHIJKLM(kNhRb(Dh  DEhRbDhq  h`   U  P < `^, n 䐏P[  O  ݬ9  ^| !  VX^, n 䐏Q    ݬf^PRݬ  l$լݬfRP|   VD^, n ȐSȞ  ؞  ܕlլݬfЬ̑lլ
lլ, n 䞭l
լЬl
լЬlլݬf^< `^, n 䐏T      l
լЬ^< `^, n 䐏U      ݬ   ^          @   @   P                                                          `                `  H  P      %       
   
                 @                                                                       PASRTL                                                         LIBRTL                                       
                                                                                                                                                                                    ) * [SYSEXE.SEAS$WORK_0000005C]DCDRIVER.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 ȯ  7  'K  8          9          G    H  J                       0 D X     0205      (  =`                                             DCDRIVER                               VAXELN V4.2-00  X= 05-05                               	   
  	     ?   !      !         TERMINAL_001"      !         
LIBCOMMON_001      !        DAP_001"      !        
PASCALMSC_001      !         	DDCMP_001          S   /0 0:0:20^\ < ~T  ?  ppp(prpS2SnެrrϫR ߬0߬ |~߬$߬,<m~Rn 
P  Լ,Ь,RԢЬ,Rk(SЬ,RCSRRMRVV
  d d(?(~~YVVl
  d d(SЬ,R mЬ,R m+S&Ь,R CS mSЬ,R mS ߭ X  SЭRϗTR @  RS T߭   R|~  Sݭ @   ( ߭   ݭ x nrn|  }PV   V Wڬ Ь,Rbw Ь,R mݭ|~   mRB0x  x(RBl  R   V Wڬ Ь,RbЬ,SccRBRbvcRRc  wSvRRPŏp  SRRUЬ(TRϝhlhRd~Ud~PClQ  1^T޼n.nSФ(RCbR bbbbb	b`Ф(RC,|^V(ЭP.PUЦ(REbT RRd1RRd<SSRRdSRR	d3RRd4RRd5RR 6RRdRR2RR
d
dЦ(RE,7RRddЦ,R@Þ^V޼Y޼ < ~<
      0YRXRðpWW  W(WrW RRRWRh(RcS2Sޭح ߭߭   .YSЦ(RC-YIf	  ڦ C(Rbݦ$Y ŏp  YRRR(/ŏ  YSЦ,R>CRI0ݦ YRx	  ݭ  ŏp  YSSRR(j~-	  PTYdSS(RR.YSЦ(R CRR    |~    RT R߭   R|~R    ŏ  YSЦ,R>CRϱԭ߭R  1F|0^޼(޼U޼Vf                                                                                                                                                                                                                                                                                                                                                                                                                  Q                        ^?` $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DCDRIVER.EXE;1                                                                                                                                 RRx(SCCT fTfTRTfTTCTfRR   TR$$TTC' C^޼T޼RS.SP@kP`TS8S^QU޼WxWVХRF1 ХRТXFWRR ХS G>УTTRRRRcWTc mPXQ TTDRbХPRR)ŏ  WR>BRR<  PWPXQ ХRF1h^QT޼XxXWФRGY|Yy.XVФRТZФRFkS -
УUU-xXPФR@@+ףYXPZQ PE
RRPxXRPB֣ФRGY|^\ЬЬЭR.VV]Q.
V]Q_ЭR^T޼.SФ(RC,P^nV޼YnЬ[xYX.YW޼Z[ [R RRIfR Ҵ ¸ |~  Ц(RSnT,SD  GЦ(RGRЮbЦ(RGRbڦ Ц$RHH IP|~  Ц(RGRbnb[1jP<URммм<ռ
Ѽ   < RмԼԼ <`$R ŏp  SSRХ(TRdRRSSdRRѼЏ P(^QVX޼nЬUЦT.TSШ(R C,1 n)U%RUDh"  PS5RЦBԭ ߭߭ݢDh  PSSuѦYЭYY Y}P`PѦ ЦTTSмRCTSWмWR(RgY	Џ ' RЏ RЏ ! RЏ ! RRP^QR޼޼nТPvԭ ߭ݢݮݮ@&  PЏ PЏ ! P^QSR.QТ(P A,(P ԭ߭ݣ  Џ PЏ ! P μ^Ь < ~  P`ω]]%]f]|~|~|~|~ |~|~]  PnP   N  P                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      @   @                                                      0       8      (                        h   `   p                                    
                 @                                                                       TERMINAL                                                       	LIBCOMMON                                                      DAP                                                            	PASCALMSC                                                      DDCMP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ) * [SYSEXE.SEAS$WORK_0000005C]DCDRIVER.PAS;1 +  ,    . B    /     4 O   B   B                    - 
    0   1    2   3      K  P   W   O C    5   6 d+R.  7  %/K  8          9          G    H  J                      # module dcdriver [ident('V2.3-00')];   M {****************************************************************************  {*									    */ {*  Copyright (c) 1986, 1990        						    * < {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { ? {	This module contains the driver for the ACP octart (DC349-AA) % {	ansynchronous communication device.  { 	 { AUTHOR:  {  {	Eric R Schott	19-May-1986  {  { MODIFIED BY: {  {--}  8 include $dap, $terminal, $mutex, $ddcmp, $stack_utility;     const   : 	{ Number of parameters in the line characteristic table } 	table_length = 12;   6 	input_buffer_size = 256;	{ size of the input buffer }/ 	max_line_number   = 7;		{ lines are 0 thru 7 } < 	xmt_buffer_length = 32;		{ length of the transmit buffers }9 	max_read_buffer_size = 512;	{ maximum read buffer size } $ 	ipl$_power = 31;		{ powerfail ipl }     	{" 	{ Possible device characteristics     	{}   " 	{ Baud rate bit representations }   	rate_50    = %b'0000';  	rate_75    = %b'0001';  	rate_110   = %b'0010';  	rate_134_5 = %b'0011';  	rate_150   = %b'0100';  	rate_300   = %b'0101';  	rate_600   = %b'0110';  	rate_1200  = %b'0111';  	rate_1800  = %b'1000';  	rate_2000  = %b'1001';  	rate_2400  = %b'1010';  	rate_3600  = %b'1011';  	rate_4800  = %b'1100';  	rate_7200  = %b'1101';  	rate_9600  = %b'1110';  	rate_19200 = %b'1111';    	{ bits per character }    	char_length_5 = %b'00'; 	char_length_6 = %b'01'; 	char_length_7 = %b'10'; 	char_length_8 = %b'11';   	{ number of stop bits }   	stop0 = 0;  	stop1 = 1;  	stop15 = 2; 	stop2 = 3;    	{ parity stuff }   
 	oddp = 0;
 	even = 1;   	{ operating mode }    	mode_normal = 0;  	mode_auto_echo = 1; 	mode_local_loop = 2;  	mode_remote_loop = 3;    ! 	{ Default line characteristics }   % 	default$char_length	= char_length_8;  	default$stop_bits	= stop1;  	default$parity_enable	= false;  	default$sense		= even;  	default$baud_rate	= rate_9600;  	default$modem		= false; 	default$hardcopy	= false; 	default$ANSI_escape	= true; 	default$echo		= true; 	default$passall		= false; 	default$eightbit	= false;  	default$ddcmp_protocol	= false;   type   	{ Some useful types }   	bits$1  = 0..1; 	bits$2  = 0..3; 	bits$3  = 0..7; 	bits$4  = 0..15;  	bits$5  = 0..31;  	bits$6  = 0..63;  	bits$7  = 0..127;# 	bits$8  = 0..255;   byte = bits$8;  	bits$9  = 0..511; 	bits$10 = 0..1023;  	bits$11 = 0..2047;  	bits$12 = 0..4095;  	bits$13 = 0..8191;  	bits$14 = 0..16383; 	bits$15 = 0..32767;$ 	bits$16 = 0..65535; word = bits$16;  % 	buffer_ptr  = ^terminal_read_buffer; 0 	any_pointer = ^anytype;		{a pointer to anytype}" 	char_str    = varying_string(12);! 	lw_string   = varying_string(4);        	{ 	{ DC349-AA registers  	{}   ) 	rcv_trn_buff_type = [byte] packed record  		case boolean of    		true: (receive_data: char);    		false: (transmit_data: char);  		end;  ' 	status_reg_type = [byte] packed record ( 		txrdy: boolean;		{ transmitter ready }% 		rxrdy: boolean;		{ receiver ready } ( 		txemt: boolean;		{ transmitter empty }! 		per: boolean;		{ parity error } " 		orr: boolean;		{ overrun error }  		fer: boolean;		{ frame error }( 		dcd: boolean;		{ data carrier detect }# 		dsr: boolean;		{ data set ready }  		end;   	{@ 	{ Mode registers 1 and 2 are accessed in a round robin fashion.B 	{ That is, after mode register 1 is accessed, an internal pointer= 	{ is updated and mode register 2 can then be accessed.  This > 	{ internal pointer can be reset to mode register 1 by reading& 	{ the command register for this line. 	{}   % 	mode_reg_type = [byte] packed record  		case boolean of    		true: ( { mode register 1 } 0 			mcie: boolean;		{ modem control intr enable } 			rsvd: boolean;		{ reserved } , 			char_length: bits$2;	{ character length }, 			parity_enable: boolean;	{ parity enable }) 			parity_sense: bits$1;	{ parity sense } . 			stop_code: bits$2; 	{ number of stop bits } 			);    		false: ( { mode register 2 }0 			receive_speed: bits$4;	{ receiver baud rate }4 			transmit_speed: bits$4; { transmitter baud rate } 			);  		end;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    R                        Hl $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DCDRIVER.PAS;1                                                                                      O     B                         _ "            ( 	command_reg_type = [byte] packed record% 		txen: boolean;		{ transmit enable } / 		txie: boolean;		{ transmit interrupt enable } % 		rxen: boolean;		{ receiver enable } % 		txbrk: boolean;		{ transmit break } 9 		rerr: boolean;		{ reset error (must write 0 to clear) } / 		rxie: boolean;		{ receiver interrupt enable } , 		operating_mode: bits$2;	{ operating mode } 		end;   	{< 	{ The interrupt summary and data set summary appear in each> 	{ register set, but are actually single registers that can be$ 	{ accessed from multiple locations. 	{}   . 	interrupt_summary_type = [byte] packed record9 		transmit_interrupt: boolean;	{ 1 = tran, 0 = receiver } 5 		line_number: bits$3;		{ line number for interrupt } ! 		reserved: bits$3;		{ reserved } ' 		irq: boolean;			{ interrupt request }  		end;  - 	data_set_summary_type = [byte] packed record  		data_change0: boolean; 		data_change1: boolean; 		data_change2: boolean; 		data_change3: boolean; 		data_change4: boolean; 		data_change5: boolean; 		data_change6: boolean; 		data_change7: boolean; 		end;   	{" 	{ Definition of a single line set 	{}   # 	per_line_registers = packed record " 		rcv_trn_buff: rcv_trn_buff_type; 			fill1: byte_data(3);  		status_reg: status_reg_type; 			fill2: byte_data(3);  		mode_reg: mode_reg_type; 			fill3: byte_data(3);   		command_reg: command_reg_type; 			fill4: byte_data(3); , 		interrupt_summary: interrupt_summary_type; 			fill5: byte_data(3); * 		data_set_summary: data_set_summary_type; 			fill6: byte_data(3);  			reserved1: byte_data(4);  			reserved2: byte_data(4);  		end;     	{' 	{ Definition of the DC349-AA registers  	{}   7 	dc349_registers = packed array [0..max_line_number] of  			    per_line_registers;  ! 	register_ptr = ^dc349_registers;      	{ Line parameters record }    	ln_param_rec = packed record 7 		char_length: char_length_5..char_length_8;	{bits 0-1} $ 		stop_bits: stop0..stop1;			{bit 2}$ 		parity_enable: boolean;				{bit 3} 		sense: oddp..even;				{bit 4} 0 		rx_baud_rate: rate_50..rate_19200;		{bits 5-8}1 		tx_baud_rate: rate_50..rate_19200;		{bits 9-12}  		modem: boolean;					{bit 13}  		hardcopy: boolean;				{bit 14}# 		ANSI_escape: boolean;				{bit 15}  		echo: boolean;					{bit 16}  		passall: boolean;				{bit 17}  		eightbit: boolean; 		ddcmp_protocol: boolean; 		end;  # 	{ Circuit process data structure }    	ct_data_base = record1 		line: integer;			{line number for this circuit} ! 		port: port;			{connecting port} , 		read_buffer_size: integer;	{record length}- 		local_pass: boolean;		{local passall state} * 		local_echo: boolean;		{local echo state}             end; { record }    	ct_ptr = ^ct_data_base;  5 	{ Line configuration record sent by system builder }    	builder_params = packed record 5 		dummy_word: word;    {length of the varying string}  		line: integer;'                 parity_enable: boolean; "                 sense: oddp..even;                 modem: boolean; "                 hardcopy: boolean;%                 ANSI_escape: boolean;                  echo: boolean;!                 passall: boolean; (                 ddcmp_protocol: boolean;1                 character_length: [pos(64)] byte;                   stop_bits: byte;                  comm_speed: word
     		end;  ! 	{ Communications region layout }   # 	buffer_type = [word] packed record 
 		data: char;  		line: bits$3;  		end;    	output_region_contents = record 		line_char: ln_param_rec;) 		index: integer;		{current buffer index} , 		chars_out: integer;	{characters to output}( 		xmt_buffer: string(xmt_buffer_length); 		xmt_waiting: boolean;  		line_valid: boolean; 		write_enable: boolean; 		end;  3 	output_region_type = array [0..max_line_number] of  					output_region_contents;& 	xmt_region_ptr = ^output_region_type;   	region_type = record ! 		get: integer;	    { get index } ! 		put: integer;	    { put index } : 		buffer: array [0..input_buffer_size - 1] of buffer_type;8 		ddcmp_protocol: array [0..max_line_number] of boolean;. 		ddcmp_region: array [0..max_line_number] of  						eln$ddcmp_rec_region; $ 		output_region: output_region_type; 		dispatcher_device: integer;  		end;   	region_ptr = ^region_type;      var $ 	controller_name: varying_string(8);" 	devices: array [0..15] of device; 	region: region_ptr; 	xmt_region: xmt_region_ptr;! 	register_location: register_ptr;  	async_ipl: integer;   	{ Line data structures } ? 	dc_struc: array [0..max_line_number] of terminal_data_pointer;          program dcdriver;    {++ 
 { dcdriver {  {--} var  	i: integer; 	rx: buffer_type;  	character: char;  	line: integer;  	signaled_object: integer; 	jparam: builder_params; 	jp: varying_string(100);    	{ Some misc. stuff } > 	sync_event: event;	{event used to synchronize initialization}; 	sub_process: process;	{process ID used for line processes} % 	timer, time_interval: large_integer;    begin   ( eln$allocate_stack(2048); { four pages }  ' controller_name := program_argument(1);    {  { Create the async device  {} create_device( 	controller_name, 	 	devices,  	vector_number := 1, 	region := region,  	registers := register_location, 	priority := async_ipl,*% 	service_routine := async_interrupt);   ; { Initialize the get and put pointers to the input buffer }u   region^.get := 0;a region^.put := 0;*- xmt_region := address(region^.output_region);i    for i := 0 to max_line_number do$ 	region^.ddcmp_protocol[i] := false;    for i := 0 to max_line_number do 	set_default_params(i);*   {l* { Check for user-specified line parameters {} i := 2;n jp := program_argument(i); while length(jp) <> 0 do 	begin  	jparam := jp :: builder_params;$ 	store_line_characteristics(jparam); 	i := i + 1; 	jp := program_argument(i);  	end;r     i := 0;   region^.dispatcher_device := -1;D while (region^.dispatcher_device = -1) and (i <= max_line_number) do 	begin! 	if not region^.ddcmp_protocol[i]c 	thenn! 		region^.dispatcher_device := i;p 	i := i + 1; 	end;  {	" { Create the synchronization event {}( create_event(sync_event, event$cleared);   {i= { Start a process to service i/o requests for each async lineT {}    for i := 0 to max_line_number do 	begin 	clear_event(sync_event);*  1         { Create a process to service this line }Y     	create_process( 		sub_process, 		line_process,  		i, 		sync_event );t   	wait_any(sync_event)a 	end;4   clear_event(sync_event); initialization_done;   {UO { Bump up the process priority of the dispatcher - note: this assumes a default : { process priority of 8 for the line and circuit processes {} current_process(sub_process);e$ set_process_priority(sub_process,7);  ( time_interval := time_value('0 0:0:20'); get_time(timer); timer := timer - time_interval;	   {n { Perform input dispatchinge {}
 while true doe
         beginn  %         disable_interrupt(async_ipl);1  $         { Wait for some characters }  *         while region^.get = region^.put do 		begine 		enable_interrupt; # 		if region^.dispatcher_device = -1t 		then 			wait_any(sync_event)' 		else/ 			wait_any(devices[region^.dispatcher_device],r- 				time:= timer, result := signaled_object);    		if signaled_object = 0 		then 			begin# 			for i := 0 to max_line_number dot" 				cleanup_ctrl_key(dc_struc[i]); 			get_time(timer);0! 			timer := timer - time_interval1 			end;t  2 		{**************** DEVICE IPL ******************}   		disable_interrupt(async_ipl);b 		end;  E 	{ Get the character out of the input buffer and update get pointer }=  *         rx := region^.buffer[region^.get];?         region^.get := (region^.get + 1) mod input_buffer_size;1           enable_interrupt;=  3 	{****************** LOWER IPL *******************}   &         { Handle the input character }           line := rx.line;         character := rx.data;e  * 	{ Give the character to the proper line }   	dispatch_character( 		dc_struc[line],h 		character,& 		xmt_region^[line].line_char.passall,' 		xmt_region^[line].line_char.eightbit, 
 		put_chars);a   	end;_ end.   f, procedure set_default_params(line: integer);   {++f { set_default_params { J { This procedure will set the line characteristics for LINE to the default { values {d {--}   begin   # with xmt_region^[line].line_char do} 	begin& 	char_length   := default$char_length;$ 	stop_bits     := default$stop_bits;( 	parity_enable := default$parity_enable;  	sense         := default$sense;$ 	rx_baud_rate  := default$baud_rate;$ 	tx_baud_rate  := default$baud_rate;  	modem         := default$modem;# 	hardcopy      := default$hardcopy;t& 	ANSI_escape   := default$ANSI_escape; 	echo          := default$echo;^                                                                                                                                                                                                                                                   S                        518 $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DCDRIVER.PAS;1                                                                                      O     B                          "            " 	passall       := default$passall;# 	eightbit      := default$eightbit; ) 	ddcmp_protocol:= default$ddcmp_protocol;i 	end;v  % xmt_region^[line].line_valid := true;A   end;    = procedure store_line_characteristics(jparam: builder_params);e   {++  { store_line_characteristics { J { This procedure is used to store user-specified line characteristics into5 { the parameter record of the data base for this line	 {d {--} begin{  * with xmt_region^[jparam.line].line_char do 	begin   	{C 	{ Set the characteristics for this line - NOTE: for now, you can'trE 	{ set the character length and # of stop bits via the system buildere 	{}}' 	parity_enable := jparam.parity_enable;	 	sense := jparam.sense;t# 	rx_baud_rate := jparam.comm_speed;o# 	tx_baud_rate := jparam.comm_speed;r 	hardcopy := jparam.hardcopy;n# 	ANSI_escape := jparam.ANSI_escape;g 	echo := jparam.echo;e 	passall := jparam.passall;n 	if jparam.character_length = 3  	thena 		eightbit := true 	elsee 		eightbit := false;  C 	{ Set the modem flag and if line is a modem, clear the valid bit }e   	modem := jparam.modem;		 	if modeme 	thenm/ 		xmt_region^[jparam.line].line_valid := false;r) 	ddcmp_protocol := jparam.ddcmp_protocol;c 	if ddcmp_protocol 	thenb 		begina 		ANSI_escape := false;p 		echo := false; 		passall := true; 		eightbit := true;2. 		region^.ddcmp_protocol[jparam.line] := true; 		end; 	end end;   r process_block line_process(v 			line: integer;t 			evt: event ); {++{+ { Line_process: async process for each line  {m {d7 { This procedure is started as a process for each line.n@ { Once the line has been properly initialized, it then waits forA { connect requests and starts a circiut process for each request.i {r {--} vare$ 	my_port: port;			{line unique port}7 	port_name: varying_string(32);	{the name of this line}e& 	process_name: name;	        {name ID}C 	circuit_db: ct_ptr;	        {pointer to circuit data base struct.}uA 	sub_process: process;	        {process ID for circuit processes}s begina  ' eln$allocate_stack(1024); { two pages }n  < { Create a port and a universally known name for this line }   create_port(my_port);;4 port_name := controller_name + chr(line + ord('0')); create_name( 	process_name, 	port_name, 
 	my_port);    @ { Allocate the line data structure - xon/xoff support required }  2 allocate_terminal_data(dc_struc[line], line, true,# 			xmt_region^[line].write_enable);;    8 { Initialize the line and signal the job when complete }   disable_interrupt(async_ipl);  initialize_line(line,6 		xmt_region^[line].line_char, 		register_location ); enable_interrupt;n  - if xmt_region^[line].line_char.ddcmp_protocold then? 	eln$ddcmp_initialize_line(address(region^.ddcmp_region[line]), '                                   line, ,                                   async_ipl,0                                   devices[line],+                                   my_port);_ signal(evt);   {sE { Create port to be used for the DAP circuit and wait for connect re-mD { quest.  Upon receipt of request, start up a process to service it. {}
 while true dot 	begin   	{. 	{ Create a new port and the data structure to 	{ pass to the circuit process 	{}   2 	if not xmt_region^[line].line_char.ddcmp_protocol 	then  		begin_ 		new(circuit_db); 		circuit_db^.line := line;s@ 		circuit_db^.local_pass := xmt_region^[line].line_char.passall;= 		circuit_db^.local_echo := xmt_region^[line].line_char.echo;;  		create_port(circuit_db^.port);    		{ Wait for a connect request }   		accept_circuit(u 				my_port," 				connect := circuit_db^.port );   		{ Start the circuit process }    		create_process(e 				sub_process, 				circuit_process, 				circuit_db );e 		endb 	else	 		begin5. 		accept_circuit(my_port, full_error := true); 		eln$ddcmp_start_running(( 				address(region^.ddcmp_region[line]), 				put_chars);r 		end;   	end;  end;   procedure initialize_line( 			line: integer;	! 			line_parameters: ln_param_rec;	$ 			register_location: register_ptr); {++f { initialize_line{ {oK { This procedure will write the line parameters for this line to the properlM { line parameters register and enable the line for transmitting and receivings { 	 { Inputs:o {g" {	line number specifies which line< {	line_parameters contains the characteristics for this line2 {	register_location points to the device registers { 
 { Outputs: {a {	line initialized { 1 { Note: This routine assumes device IPL or higher  {e {--} var  	local_sense: 0..1;d! 	local_command: command_reg_type;I begin:   with line_parameters do  	begin   	if sense = oddp 	thens 		local_sense := 0 	else  		local_sense := 1;o   	{ zero the command register }   	local_command := zero;  	write_register(( 			register_location^[line].command_reg, 			local_command);     	{9 	{ Read the command register to guarrantee that we accessd0 	{ mode register 1.  Then write mode register 2. 	{}o  F 	local_command := read_register(register_location^[line].command_reg);   	write_register(% 			register_location^[line].mode_reg,t 			mcie := false,m% 		        char_length := char_length,	) 		        parity_enable := parity_enable,a& 		        parity_sense := local_sense," 		        stop_code := stop_bits); 	write_register(    % 			register_location^[line].mode_reg,t! 			receive_speed := rx_baud_rate,_# 			transmit_speed := rx_baud_rate);    	local_command := zero;r 	with local_command do 		beginr 		txen := true;f 		txie := true;u 		rxen := true;m 		rxie := true;   		operating_mode := mode_normal; 		end;         write_register(e( 			register_location^[line].command_reg, 			local_command);
 	end { with }p end;   t% interrupt_service powerfail_recovery(o" 			device_registers: register_ptr; 			inp: region_ptr );n   {++g) { This is the powerfail recovery routine.r {o	 { Inputs:t { ) {	std. interrupt_service procedure inputsa {n
 { Outputs: { @ {	device reinitialized and circuit processes waiting to transmit
 {	signaled {n {--} varf 	i: integer;   begin    { 1 { Now reinit each line and check for transmitting-% { circuit processes that were waitinge {}    for i := 0 to max_line_number doG 	initialize_line(i, inp^.output_region[i].line_char, device_registers);n   end;   {" interrupt_service async_interrupt(& 			    device_registers: register_ptr; 			    inp: region_ptr );c {++{ {cC { Async_input_interrupt: async line input interrupt service routiner { 5 { This is the input/output interrupt service routine. 9 { It determines the source of the interrupt, and servicese7 { the appropriate line.  It loops until all activity isd { serviced.c {_, {  Inputs :	registers - pointer to registers {		region - pointer to region  {a {  Outputs :	nonee {u {--} varn' 	interrupt_sum: interrupt_summary_type;d 	line: integer;t      . procedure handle_rec_interrupt(line: integer);   {++  { handle_rec_interrupt {n? { It reads characters and puts them into the input buffer whichd> { is located in the device record region.  If the input buffer@ { state changes from empty to non-empty, the device is signaled. {--} var} 	rx_data: buffer_type; 	local_status: status_reg_type;<# 	local_rcv_buff: rcv_trn_buff_type;d beginm  B local_status := read_register(device_registers^[line].status_reg);   while local_status.rxrdy do= 	begin! 	local_rcv_buff := read_register(l( 		device_registers^[line].rcv_trn_buff);- 	rx_data.data := local_rcv_buff.receive_data;. 	rx_data.line := line;  ! 	if not inp^.ddcmp_protocol[line]p 	then  		begine  > 		{ If the input buffer is not full, put the character in it }  7 		if ((inp^.put + 1) mod input_buffer_size) <> inp^.gete 		then 			begin 			{' 			{ If input buffer goes from empty ton! 			{ non-empty, signal dispatcher_ 			{}* 			if inp^.put = inp^.gete 			thenv 				signal_device(J                                    device_number:=inp^.dispatcher_device);  $ 			inp^.buffer[inp^.put] := rx_data;3 			inp^.put := (inp^.put + 1) mod input_buffer_size  			end;h 		ends 	elsei 		if eln$ddcmp_receive_isr(t$ 			address(inp^.ddcmp_region[line]), 				rx_data.data)i 		then( 			signal_device(device_number := line);  L         { Now read the status register to see if more characters are there }  C 	local_status := read_register(device_registers^[line].status_reg);    	end;   end;i      . procedure handle_xmt_interrupt(line: integer);   {++a { handle_xmt_interrupt {  {--} var  	local_status: status_reg_type; ! 	local_command: command_reg_type;  	done: boolean;n begint  B local_status := read_register(device_registers^[line].status_reg); done := false;  * while local_status.txrdy and (not done) do 	begin  !                                                                                                                                                                                                                                                    T                        \ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DCDRIVER.PAS;1                                                                                      O     B                         R "     -       	with inp^.output_region[line] doo  . 		if (not write_enable) or (index > chars_out) 		then 			begin" 			local_command := read_register(* 					device_registers^[line].command_reg);   			local_command.txie := false;a6 			write_register(device_registers^[line].command_reg, 					local_command); 			xmt_waiting := false; 			index := index - 1; 			done := true;+ 			signal_device(device_number := (line+8))  			end 		else 			begin7 			write_register(device_registers^[line].rcv_trn_buff,d1 				transmit_data := substr(xmt_buffer,index,1));  			index := index + 1; 			end;* 		C 	local_status := read_register(device_registers^[line].status_reg);  	end;  end;   begin   G interrupt_sum := read_register(device_registers^[0].interrupt_summary);s   while interrupt_sum.irq do 	begin# 	line := interrupt_sum.line_number;e  $ 	if interrupt_sum.transmit_interrupt 	theni 		handle_xmt_interrupt(line) 	elsen 		handle_rec_interrupt(line);_  H 	interrupt_sum := read_register(device_registers^[0].interrupt_summary); 	end;  end;   aH function line_valid of type check_line_valid;	{ (line_number: integer )}   {++g { check_line_valid {} {--} begina2 line_valid := xmt_region^[line_number].line_valid; end;   t- function put_chars of type output_characters;l 	 { ( line_number: integer;$ 	     number_of_chars: integer;$> 	     var output_buffer: string(number_of_chars) ): boolean; } {++e { put_chars  {r3 { This function outputs characters to an async linee {l	 { Inputs:p {  {	line number specifies line) {	number_of_chars specifies buffer lengthg. {	output_buffer points to buffer of characters { 
 { Outputs: {r% {	characters output on specified linei= {	function returns false if line goes invalid, true otherwiser {i {--} varb 	output_character: char; 	full: boolean;a 	count: integer; 	done: boolean;  	xmt_index: integer; 	tomove: integer;e! 	local_command: command_reg_type;d 	num_chars: integer;    $ [inline]function minimum(a: integer; 			 b: integer): integer;a beginb	 if a <= b  then
 	minimum := as else 	minimum := b; end;     begin    xmt_index := 1;c num_chars := number_of_chars;i   repeat  @ 	{ Move characters from the user buffer to the transmit buffer }  1 	tomove := minimum(num_chars, xmt_buffer_length);s+ 	check_write_enable(dc_struc[line_number]); ? 	xmt_region^[line_number].xmt_buffer := substr(  output_buffer,e 							xmt_index,  							tomove );. 	xmt_region^[line_number].chars_out := tomove;) 	xmt_region^[line_number].index     := 1;	  = 	{ Set the line enable bit in the transmit control register }m   	disable_interrupt(async_ipl);  	local_command := read_register(1 				register_location^[line_number].command_reg);e 	local_command.txie := true;< 	write_register(register_location^[line_number].command_reg, 			    local_command); 	enable_interrupt;  2 	{ Wait for the isr to empty the transmit buffer }  " 	wait_any(devices[line_number+8]);   	{ Update counters }  9 	xmt_index := xmt_index + xmt_region^[line_number].index; 9 	num_chars := num_chars - xmt_region^[line_number].index;    until num_chars = 0;  : { No modem support for this driver so always return true } put_chars := true;   end;   f5 process_block circuit_process(circuit_struc: ct_ptr);    {++qH { Circuit process: This process is started to service an i/o request for { the specified line.e {mH { Inputs: circuit_struc - a structure containing information peculiar to { this circuit {e { Outputs :	none {e {--} var ! 	read_buff: terminal_read_buffer;c$ 	saved_record_attributes: dap$b_rat;= 	saved_record_format: dap$b_rfm;		{ Record format from open } F 	saved_fixed_control_size: dap$b_fsz;	{ Fixed control size from open } 	this_line: integer; 	context: integer; 	status: integer;n 	circuit_flags: terminal_flags;  m- function open_action of type dap$open_action;e   {++ $ {  Open_action - open action routine {aI {	This routine is called by the dap$server routine when the user process   {	executes an open statement.n {t
 {  Inputs: {p {	create			- create/open flagn" {	file_access 		- file access mode {	share 			- share access,$ {	organization 		- file organization! {	record_format 		- record format_( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options ( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics* {	file_specification 	- file specification) {	fixed_control_size	- fixed control size 0 {	context 		- driver specific parameter (unused) { 	m {  Outputs:p {r$ {	organization 		- file organization! {	record_format 		- record format ( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options[( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics {c {	return value = success {i {--} begine  $ { Save specified record attributes }- saved_record_attributes := record_attributes;e% saved_record_format := record_format;r/ saved_fixed_control_size := fixed_control_size;y  C { Set max record size (if default specified) and read buffer size }cL if (maximum_record_size = 0) or (maximum_record_size > max_read_buffer_size) then- 	maximum_record_size := max_read_buffer_size;t  7 circuit_struc^.read_buffer_size := maximum_record_size;   % { Set some other various parameters }  organization := dap$k_seq; {record_format := dap$k_var;}t file_options := [];:: device_char := [ dap$v_devrec, dap$v_devccl, dap$v_devtrm,  		 dap$v_devidv, dap$v_devodv ]; 	t { Set up the flags record }e with circuit_flags doe 	begin& 	passall := circuit_struc^.local_pass;# 	echo := circuit_struc^.local_echo;i7 	hardcopy := xmt_region^[this_line].line_char.hardcopy;	B 	escape_recognize := xmt_region^[this_line].line_char.ANSI_escape; 	end;s  ) { If max record size is 1, special case }s   if maximum_record_size = 1 then 	begin 	circuit_flags.passall := true;   	circuit_flags.echo    := false; 	end;    open_action := dap$k_success   end;   l+ function get_action of type dap$get_action;l {++ " {  Get_action - get action routine {pI {	This routine is called by the dap$server routine when the user process o- {	executes a get (read/readln/etc) statement.w {e
 {  Inputs: {r4 {	record_access		- type of access to be used in get 1 {	record_number		- number of record to read (lbn)t4 {	record_options		- record options to be used in get. {	buffer			- address of buffer to receive data3 {	buffer_length		- length of buffer to receive datai0 {	get_buffer		- routine to get new larger buffer0 {	context 		- driver specific parameter (unused) { 	e {  Outputs:  { . {	buffer_length		- length of actual datum read {	return value = success {  {--} varc 	i, read_length: integer;r 	read_status: boolean; 	count: integer; 	eof: boolean; 	tmp_buff: ^anytype;   begin    { If the line is up, continue }   $ if xmt_region^[this_line].line_valid then 	begin   	{C 	{ If the record access is keyed and the record number is non-zero,rA 	{ then the record number represents a mask of control characterst 	{ that are to be awaited. 	{}.  < 	if (record_access = dap$k_key_acc) and (record_number <> 0) 	then_ 		begino
 		count := 1;y! 		read_buff[1] := await_ctrl_key(t 					dc_struc[this_line], # 					record_number :: ctrl_key_set,e 					circuit_struc^.port );  		eof := false;u 		read_status := true; 		endn 	elsep 		{ Normal read }r 		read_status := read_chars( 					dc_struc[this_line],	 					read_buff,}% 					circuit_struc^.read_buffer_size,  					count,c 					circuit_flags,t	 					eof,- 					put_chars);   	{ 	{ If success, return the data3 	{ For VFC files, place a control field on the datat 	{}e   	if read_statusd 	thene 		beginn  $ 		if saved_record_format = dap$k_vfc 		then2 			read_length := count + saved_fixed_control_size 		else 			read_length := count;  @ 		{ Check the buffer for overflow. If so, allocate new buffer. }    		if read_length > buffer_length 		then% 			buffer := get_buffer(read_length);e  A 		{ Copy the input to the supplied buffer and return the length }n  $ 		if saved_record_format = dap$k_vfc 		then 			begin, 			for i := 1 to saved_fixed_control_size do/ 				buffer^::terminal_read_buffer[i] := chr(0);aC 			tmp_buff::integer := buffer::integer + saved_fixed_control_size;  			end 		else 			tmp_buff := buffer;  8 		tmp_buff^::string(count) := substr(read_buff,1,count);   		buffer_length := read_length;b   		{ Set the return status }h   		if eof 		then 			begin 			get_action := dap$k_eof;e 			eof := falseo 			end 		else 			get_action := dap$k_success 		end    	elsep'                                                                                                                                                                                                                                                    U                        ٙvl $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DCDRIVER.PAS;1                                                                                      O     B                         S 
     >       		get_action := dap$k_device_not_ready;c 	end   else& 	get_action := dap$k_device_not_ready; 	: end;   s+ function put_action of type dap$put_action;h   {++ " {  Put_action - put action routine {bI {	This routine is called by the dap$server routine when the user process d/ {	executes a put (write/writeln/etc) statement.n {=
 {  Inputs: {o3 {	record_access		- type of access to be used in put 2 {	record_number		- number of record to write (lbn)4 {	record_options		- record options to be used in put. {	buffer			- address of buffer containing data4 {	buffer_length		- length of data in buffer to write0 {	context 		- driver specific parameter (unused) { 	e {  Outputs:l {v {	return value = success {  {--} vard 	write_status: boolean;c begini   write_status := write_chars( 			dc_struc[this_line], 
 			buffer, 			buffer_length,f 			saved_record_attributes,e 			put_chars );c   if write_status	 then 	put_action := dap$k_success else& 	put_action := dap$k_device_not_ready; end;   r5 function truncate_action of type dap$truncate_action;    {++ , {  Truncate_action - truncate action routine {aH {	This routine is called by the dap$server routine when the user process  {	executes a truncate statement. {i
 {  Inputs: {a8 {	record_access		- type of access to be used in truncate { 	_ {  Outputs:l {l {	return value = success {  {--} vare 	stat: boolean;o   begins  $ if xmt_region^[this_line].line_valid then 	begin 	if circuit_struc^.local_echo_ 	thent 		begin(. 		stat := write_newline(this_line, put_chars);+ 		{dc_struc[this_line].lf_needed := false;}e) 		{dc_struc[this_line].lf_output := true}c 		end;(         truncate_action := dap$k_success 	end else+ 	truncate_action := dap$k_device_not_ready;	 end;   s {++e {e { Circuit process code {e {--}   beginc  ) eln$allocate_stack(4096); { eight pages }:   {e- { Save the line number in an accessible placec {}! this_line := circuit_struc^.line;    {g { Let DAP do its {} status := dap$server(.) 		circuit_port    := circuit_struc^.port,(! 		open_action     := open_action,   		get_action      := get_action,  		put_action      := put_action,& 		truncate_action := truncate_action);   { ! { Get rid of what we're not usingi {} delete(circuit_struc^.port); dispose(circuit_struc);e end;     end;                                                                                                                                                                                                                                                            ) * [SYSEXE.SEAS$WORK_0000005C]DDDRIVER.EXE;1 +  ,    . 	    /     4     	                        - 
    0   1    2   3      K  P   W   O     5   6 `i
  7 MK  8          9          G    H  J                       0 D X     0205      (  
`                                              DDDRIVER                               VAXELN V4.2-00 `
 05-05                                  
       ?   "      !        
PASCALMSC_001"      !         
LIBCOMMON_001      !         FILE_001      !        DAP_001  <^\l< ~5
  %
  (
  (S2SެS~߬<߬,|~ ߬0~S߭ 
P  S2SެS~߬8|~|~߬4<"~S߭ 
P   ԭԭφԭԭ߭߭߭߭O	  P$ ߬     ߬ X  R϶SݬR S߬(   ݬ|~  ݬ @  R ( ݬ(|~  P^޼SѣԭڭPЬQ ֣ԭУRB	ڭ^޼Sŏ   RB
TRRԭڭ cqddPRR@dRRRdRRxRRRxRd-УR R#RB
PЬQ ԭڭ޼S ncԣ PЬQ ޼Sԣ#RB
 cPЬQ ER  Т4\|#P@
Т0\Ԭ^ԭڭԭR\\ڭRԭڭ\RRڭ\RRRRԭڭ|^޼VfSUxURSRxUUU!T<DfRR<S<RRSSUT޼STTDRRRR<S<RRSSЭP^=W޼Z޼Y0ڧ,Ч0RԢЧ0RYЧ0RjQ
SYX<VVXXV(VacVXԭ@Ч0R bڭ ݧ<|~    0^V 0XRڦ,ԭ@ 0ڭ4 ݦ8|~   0XXЦ4WЬSŏ   R( BcXP ^LR޼޼޼޼n
Т4P n
DPϥ<|^( ||~}S C~RPRRRRP޼T޼STSTRSRRP޼S	Џ RKS	Џ R=S	Џ  R+S	Џ t RS	Џ  RЏ  RRP@޼VVUмTЬSЬR(UDVQVüRRR~LP޼WЦXgXUTмSЬR,TC UHRgݦPbϞ^޼޼޼X|~  Z[Z11޼X޼YXݮݮݮtWϔPVV1 RR" v              O j.PRXtiREW@XxtiX]Qx~ωPZWWZ	WV1JZ@RR( / / / / / ( / ( ( / / / / / / / ( ( ndnW A[ZdnZ1Xi]  nP^޼nЏa ޼Rb<Џ P^޼R޼޼n< ~-  ޼QǏ   QPR  /RPPP  !QQRݾPPQЏ  QQP^޼R޼޼nv< ~  ޼QǏ   QPR  /RPPP  !QQRݾxPϔPQЏ  QQP Џ P,^X޼Z޼h< ~>  ~,  PYZi0ZRRRްVVV(VVRRRVR(RcݨݭY   P                                                                                                                                                              @   @       h   t                                            h   p                              
                 @                                                                       	PASCALMSC                                                      	LIBCOMMON                                                      FILE                                                           DAP                                                                                                                              ) * [SYSEXE.SEAS$WORK_0000005C]DDDRIVER.PAS;1 +  ,    . 9    /     4 N   9   9 >                    - 
    0   1    2   3      K  P   W   O :    5   6  Y9R.  7 `jK  8          9          G    H  J                      # module dddriver [ident('V2.0-00')];   M {****************************************************************************  {*									    *0 {*  Copyright (c) 1984, 1990         						    *< {*  by DIGITAL Equipment Corporation, Maynard, Mass.			    * {* 									    * M {*  This software is furnished under a license and may be used and  copied  * M {*  only  in  accordance  with  the  terms  of  such  license and with the  * M {*  inclusion of the above copyright notice.  This software or  any  other  * M {*  copies  thereof may not be provided or otherwise made available to any  * M {*  other person.  No title to and ownership of  the  software  is  hereby  *  {*  transferred.							    * {* 									    * M {*  The information in this software is subject to change  without  notice  * M {*  and  should  not  be  construed  as  a commitment by DIGITAL Equipment  *  {*  Corporation.							    * {* 									    * M {*  DIGITAL assumes no responsibility for the use or  reliability  of  its  * B {*  software on equipment which is not supplied by DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { 2 { 	This module contains the driver for the console
 {	TU58 device  { 	 { AUTHOR:  {  {	Kris Barker 15-December-1982 { 
 { VERSION: { 	 {	V1.0-00  { 
 { VERSION: { 	 {	V2.0-00  {  { MODIFICATIONS: {  {	V2.0-01	Gary Kimura 7-Dec-84 {		added stack utility {--}      % in             clude $dap, $mutex, $stack_utility;    const        { TU58 op codes }      nop        = 0;      initialize = 1;      read_data  = 2;      write_data = 3;      position   = 5;      diagnose   = 7;      g_status   = 8;      s_status   = 9;      end_op     = %x40;  (     { TU58 register numbers on the 730 }$     csrs = %x1C;				{receive status}"     csrd = %x1D;				{receive data}%     csts = %x1E;				{transmit status} #     cstd = %x1F;				{transmit data}        { Packet flag values }     data                                                                                                                                                                       V                        <џ $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DDDRIVER.PAS;1                                                                                      N     9                          "             = 1;      control  = 2;      init     = 4;      continue = 16;     xon      = 17;     xoff     = 19;@     checksum_flag = 99;		{dummy value to denote checksum errors}  L     { Success values - note: those not **'ed returned as controller errors }#     success              =  0;	{**} $     success_with_retries =  1;  {**}     fail_self_test       = -1;     partial_transfer_eot = -2;$     bad_unit             = -8;  {**}$     no_cartridge         = -9;  {**}$     write_locked         = -11; {**}$     data_check           = -17; {**}     block_not_found      = -32;      motor_stopped        = -33;      bad_opcode           = -48;      bad_block_number     = -55; 3     { Other errors and checksum errors flagged as } $     controller_error     = 100; {**}  
     { Misc. }      break_bit = 1;     null      = 0;     command_length = 10;     mrsp_switch = 8;     max_block_number = 511;      full_packet_bytes = 128;     full_packet_size = 132;      max_retries = 8;     ipl$_power = 31;       type     word = 0..65535;     byte = 0..255;$     x_buffer(n:integer) = string(n);7     tu58_status = bad_block_number .. controller_error;   #     long_word_byte  = packed record                  case integer of (                     0: (long : integer);4                     1: (word  : word; word2 : word);3                     2: (byte1 : byte; byte2 : byte)                end;{record}       { Generic packet format } +     tu58_packet (n:integer) = packed record $                     flag     : byte;$                     length   : byte;)                     pbuff    : string(n); #                     checksum : word                    end;{record}       { end packet format }      end_packet = packed record             flag       : byte;             length     : byte;             opcode     : byte;             success    : byte;             unit       : byte;             unused     : byte;             sequence   : word;             byte_count : word;             summary    : word;             checksum   : word               end;{record}        { Command packet format } "     command_packet = packed record"                 flag       : byte;"                 length     : byte;"                 opcode     : byte;"                 modifier   : byte;"                 unit       : byte;"                 switches   : byte;"                 sequence   : word;"                 byte_count : word;"                 block      : word;!                 checksum   : word                   end;{record}        { Full data packet }1     full_packet = tu58_packet(full_packet_bytes);        rec_region = record $             owned         : boolean; 	    mrsp          : boolean;  	    get_buff      : integer;  	    put_buff      : integer; 0 	    rec_struc     : array [0..1] of buff_struc; 		 end; { record }       xmt_region = record  	    powerfail     : boolean;  	    owned         : boolean;  	    pointer       : integer;  	    packet_length : integer; . 	    c_packet      : string(full_packet_size); 		 end; { record }       buff_struc = record $             pointer       : integer;$             packet_length : integer;5             c_packet      : string(full_packet_size);             	 end; { record }        rx_region_ptr = ^rec_region;      tx_region_ptr = ^xmt_region;  3     transmit_status_register = [long] packed record )                     break      : boolean; 2                     int_ena    : [pos(6)] boolean;2                     ready      : [pos(7)] boolean;                    end;{record}   2     receive_status_register = [long] packed record2                     int_ena    : [pos(6)] boolean;2                     done       : [pos(7)] boolean;                   end;{record}       tu58_structure = record  	unit            : integer;  	end;   )     tu58_structure_ptr = ^tu58_structure;          var      { Device stuff }     tu58_transmit : device;      tu58_receive  : device;        rx_region : rx_region_ptr;     tx_region : tx_region_ptr;       tu58_priority : integer;       { Misc. stuff } E     this_process     : process;            {token for unit processes} =     tu58_mutex       : mutex;              {controller mutex} )     controller_name  : varying_string(8); )     universal_name   : varying_string(8); :     init_event       : event;              {a dummy event}      file_service_ptr : ^anytype;       allocate_status  : integer;      PROGRAM  dddriver; {++  {  { This is the TU58 driver  {  {--}   VAR      unit  : byte;      cstat : boolean;   begin   M     eln$allocate_stack ( 4 * 512, status := allocate_status ); { four pages }   -     controller_name := program_argument( 1 ); -     universal_name  := program_argument( 2 );   $     create_device ( controller_name,"                     tu58_transmit, 		    vector_number   := 2, <             	    service_routine := tu58_transmit_interrupt,. 		    powerfail_routine := tu58_xmt_powerfail,.             	    region          := tx_region,4             	    priority        := tu58_priority );  $     create_device ( controller_name,             	    tu58_receive, 		    vector_number   := 1, ;             	    service_routine := tu58_receive_interrupt, . 		    powerfail_routine := tu58_rec_powerfail,0             	    region          := rx_region );  C     { Now that the devices are created, initialize the controller }        initialize_controller;  5     { Initialize the job wide file service database } 8     file_service_ptr := eln$file_initialize ( tu58_open, 					      tu58_get, 					      tu58_put, 					      tu58_close );  )     { Create a mutex for the controller }       create_mutex ( tu58_mutex );       { Create a dummy event }/     create_event ( init_event, event$cleared );   6     { For each unit create the actual driver process }     for unit := 0 to 1 do  	begin%         create_process (this_process,                  	tu58_process,                 	unit, 			init_event ); 	wait_any ( init_event );  	clear_event ( init_event )  	end;        { Complete initialization }      initialization_done;  4     { Sit and wait on something that won't happen so"       subprocesses don't go away }     wait_any ( this_process );   end;      ? interrupt_service tu58_transmit_interrupt ( xregist : ^anytype; # 					    region  : tx_region_ptr );  {++ < { tu58_transmit_interrupt : device interrupt service routine { F {  This is the transmit interrupt service routine for the tu58 driver. { @ {  Inputs :     region    - pointer to the communications region {  {  Outputs :	none  {  {--} var      xmt : long_word_byte;  begin        with region^ do            { Are we done? }'         if pointer = packet_length then              begin   J             { All done so turn off the transmitter and signal the device }             xmt.long := 0;$             mtpr ( csts, xmt.long );             owned := false;              signal_device              end   	     	else              begin   <             { Bump up the pointer and output the next byte }#             pointer := pointer + 1;              xmt.long := 0;:             xmt.byte1::char := substr(c_packet,pointer,1);$             mtpr ( cstd, xmt.long );             end    end;      = interrupt_service tu58_receive_interrupt ( xreg   : ^anytype; ! 					   region : rx_region_ptr );  {++ ; { tu58_receive_interrupt : device interrupt service routine  { E {  This is the receive interrupt service routine for the tu58 driver.  { < {  Inputs :	region    - pointer to the communications region {  {  Outputs :	none  {  {--} var      rec, xmt : long_word_byte;   begin   0     with region^, region^.rec_struc[put_buff] do 	begin   	{ Read the input character } "         rec.long := mfpr ( csrd );   	{ if MRSP, send ack byte }  	xmt.long := 0;  	xmt.byte1 := continue;  	mtpr ( cstd, xmt.long );    	{ Input expected? } 	if owned then
 	    begin  6             { Bump up the pointer and store the byte }#             pointer := pointer + 1; :             substr(c_packet,pointer,1) := rec.byte1::char;  I             { if this is the first byte, determine the type of response }]             if pointer = 1 then*!                 case rec.byte1 of*A                     { Allow (initially) for a full sized packet } F                     data, control : packet_length := size(full_packet)6                     otherwise       packet_length := 1                 end;{case}  9             { The second byte gives us the actual count }r             if pointer = 2 thene>                 packet_length := size(tu58_packet(rec.byte1));     +             if                                                                                                                                                                                                                                                   W                        oK $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DDDRIVER.PAS;1                                                                                      N     9                         ~              pointer = packet_length thene                 beginm     6                 { Swap buffers and signal the device } 		get_buff := put_buff;e% 		put_buff := ( put_buff + 1 ) mod 2;	# 		rec_struc[put_buff].pointer := 0;n                 signal_deviceu                 endo 	    end   	else 
 	    begin 	    { disable interrupts }m             rec.long := 0;$             mtpr ( csrs, rec.long ); 	    end           end {with} end; r    9 interrupt_service tu58_xmt_powerfail ( xreg   : ^anytype;t$ 				       region : tx_region_ptr ); {++D {T8 { This is the transmit device powerfail recovery routine {*	 { Inputs:* {*& {	Standard interrupt service arguments { 
 { Outputs: { : {	Controller initialized and any waiting process signalled {c {--}   beginv       reset_controller;8       with region^ do  	begin   	powerfail := true;- 	pointer := 0; 	if owned then 	    signal_device;  	end;2   end;      9 interrupt_service tu58_rec_powerfail ( xreg   : ^anytype;s$ 				       region : rx_region_ptr ); {++m {x7 { This is the receive device powerfail recovery routine  {o	 { Inputs:0 { & {	Standard interrupt service arguments { 
 { Outputs: {= {	Any waiting process signalledi {o {--}   begin        with region^ do_ 	begin   	put_buff := 0;  	get_buff := 1; " 	rec_struc[put_buff].pointer := 0; 	if owned then 	    signal_device;} 	end;s   end; 	      procedure initialize_controller; {++s { 7 { This procedure will perform controller initializationa {t {--} begin}  %     disable_interrupt ( ipl$_power );      reset_controller;      enable_interrupt;        with rx_region^ do 	begin 	mrsp := true; 	put_buff := 0;u 	get_buff := 0;s" 	rec_struc[put_buff].pointer := 0; 	end;t       tx_region^.pointer := 0;   end; s     procedure reset_controller;; {++  { N { This is the TU58 controller initialization module.  It will send out a BREAKH { signal for one character time followed by 2 INIT characters.  The TU58M { responds to the second INIT with a CONTINUE character and is then ready for  { normal operations. {c {--} var *     xmt_status : transmit_status_register;      xmt_data   : long_word_byte;)     rec_status : receive_status_register;       rec_data   : long_word_byte;     i          : integer;r   begin        xmt_status :: integer := 0;      xmt_status.break := true; )     mtpr ( csts, xmt_status :: integer );c       xmt_data.long := 0;r  $     { Send two nulls while we wait }     for i := 1 to 2 do
         begine         repeat2             xmt_status :: integer := mfpr ( csts )         until xmt_status.ready;r#         mtpr( cstd, xmt_data.long )a	     	end;l  7     { Clear the status register to turn off the break }a     xmt_status :: integer := 0;e)     mtpr ( csts, xmt_status :: integer );:  '     { Now send the two required INITs }      xmt_data.byte1 := init;      for i := 1 to 2 do
         beginy         repeat3             xmt_status :: integer := mfpr ( csts );          until xmt_status.ready;d*         mtpr ( cstd, xmt_data :: integer )	     	end;         { Read the receiver status }
     repeat.         rec_status :: integer := mfpr ( csrs )     until rec_status.done;  #     rec_data.long := mfpr ( csrd );f  $     { Turn off receiver interrupts }     rec_status :: integer := 0; )     mtpr ( csrs, rec_status :: integer );      end; b    ( function get_checksum ( psize : integer;?                         var pack : tu58_packet(psize) ) : word;  {++u {e6 { This procedure will compute the checksum of a packet {m {--} type     ck = [long] packed recordr 		case boolean ofd) 		    true  : ( int   : [long] integer ); $ 		    false : ( word1 : [word] word; 			      word2 : [word] word );; 		end; { record }e  /     tu58_word_packet(n:integer) = packed record; 					flag   : byte;i 					length : byte; ) 					buff   : packed array [1..n] of word  				  end; { record }    var      csum        : ck;;     i           : integer;     ch          : char;      word_length : integer;   beginh  3     { Initialize checksum to first word in packet } ,     csum.int := pack.flag + 256*pack.length;  C     { Compute the number of words in the message part of the pack }e%     word_length := pack.length div 2;   5     {with x as pack::tu58_word_packet(word_length) dof 	begin}i 	for i := 1 to word_length doa
 	    beginH 	    csum.int := csum.int + pack::tu58_word_packet(word_length).buff[i];+ 	    csum.word1 := csum.word1 + csum.word2;o 	    csum.word2 := 0	 	    end;g 	if odd(pack.length) theni
 	    begin, 	    ch := substr(pack.pbuff,pack.length             ,1);$ 	    csum.int := csum.int + ord(ch);* 	    csum.word1 := csum.word1 + csum.word2 	    end; { if } 	{end;} { with }       get_checksum := csum.int end; f    - procedure send_packet ( psize      : integer; # 			var packet : byte_data(psize) );    {++o {t/ { This procedure transmits a packet to the TU58= {o	 { Inputs:r {r {	packet size and the packet { 
 { Outputs: {  {	packet sent to tu58n {  {--}   varo-     xmt           : transmit_status_register;)   begin;  
     repeat   	tx_region^.powerfail := false;_    	{ Synchronize with the device }% 	disable_interrupt ( tu58_priority );o  ' 	{ Initialize the communications area }  	tx_region^.pointer := 0; # 	tx_region^.packet_length := psize;83 	tx_region^.c_packet :: byte_data(psize) := packet;e  * 	{ Enable interrupts for the transmitter } 	xmt :: integer := 0;  	xmt.int_ena := true;    	{ Check for powerfail }  " 	disable_interrupt ( ipl$_power );! 	if not tx_region^.powerfail theno
 	    begin! 	    mtpr ( csts, xmt::integer );e 	    tx_region^.owned := true; 	    enable_interrupt;  + 	    { Actual i/o done at interrupt level }     	    wait_any ( tu58_transmit ); 	    end 	elset 	    enable_interrupt;  #     until not tx_region^.powerfail;_   end; r    > function receive_packet( var packet : full_packet ) : boolean; {++n { 0 { This procedure receives a packet from the tu58 {u	 { Inputs:r {  {	none {A
 { Outputs: {+7 {	received packed or indication that powerfail occurred  {t {--}   var "     rec : receive_status_register;   begina        if tx_region^.powerfail then 	receive_packet := true      else 	begin% 	disable_interrupt ( tu58_priority );  	rec :: integer := 0;r 	rec.int_ena := true; " 	disable_interrupt ( ipl$_power );! 	if not tx_region^.powerfail then 
 	    begin! 	    mtpr ( csrs, rec::integer );s 	    rx_region^.owned := true; 	    enable_interrupt; 	    wait_any ( tu58_receive );,	 	    end;  	  	if tx_region^.powerfail then, 	    receive_packet := true  	else 
 	    begin 	    receive_packet := false;t 	    with rx_region^ do ' 		packet :: string(full_packet_size) := " 				 rec_struc[get_buff].c_packet;	 	    end;8   	end;i   end;      7 procedure send_command_packet ( operation, unit : byte; ) 			        block, buffer_length : word );  {++h {t9 { This procedure will formulate and ship a command packet  {t {--} varr     c_packet : command_packet;   begini       { Load the command packet }r#     c_packet.flag       := control;8*     c_packet.length     := command_length;%     c_packet.opcode     := operation;      c_packet.modifier   := 0;l      c_packet.unit       := unit;       if rx_region^.mrsp thene! 	c_packet.switches := mrsp_switchn     else 	c_packet.switches := 0;       c_packet.sequence   := 0;p*     c_packet.byte_count := buffer_length; !     c_packet.block      := block;e  %     { Compute and load the checksum } 7     c_packet.checksum := get_checksum ( command_length,e2 				      c_packet::tu58_packet(command_length) );       { Ship the packet } I     send_packet ( size(c_packet), c_packet :: byte_data(size(c_packet)) )p   end;      = function verify_checksum ( cpacket : full_packet ) : boolean;n {++  { D { This function will verify that the checksum in a packet is correct {  {--} var:     cksum : word;    beginu  9     cksum := get_checksum ( full_packet_bytes, cpacket ); 5     with x as cpacket::tu58_packet(cpacket.length) doh 	if cksum = x.checksum then  	    verify_checksum := true 	elseu 	    verify_checksum := falses end;      ( function minimum ( a, b : byte ) : byte; begin      if a <= b then         minimum := a     else         minimum := b end; h    ; function set_status ( success_code : byte ) : dap$l_status;t {++a {i5 { This function will examine the success code and set;- { the function value to the proper dap status  {  {--} begine"     if success_code = success then#         set_status := dap$k_success 4     else if success_code = success_with_retries then0         set_status := dap$k_success_with_retries,     else if succ                                                                                                                                                                                                                                   X                        K)+v $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DDDRIVER.PAS;1                                                                                      N     9                         O "     '       ess_code = no_cartridge then(         set_status := dap$k_no_cartridge,     else if success_code = write_locked then/         set_status := dap$k_device_write_lockedc*     else if success_code = data_check then&         set_status := dap$k_data_check     else(         set_status := dap$k_device_error end;   n    . function do_tu58_io ( opcode        : integer;  		      unit          : integer;  		      block         : integer;  		      buffer_length : integer;@ 		      var buffer    : x_buffer(buffer_length) ) : tu58_status;   var      done,error    : boolean;3     rsp_packet    : tu58_packet(full_packet_bytes);r     buffer_offset : integer;3     data_packet   : tu58_packet(full_packet_bytes);l     retries       : integer;     nc            : integer;      status        : tu58_status;     powerfailed   : boolean;  3 procedure move_to_user ( length          : integer; * 			 var rpacket     : tu58_packet(length);' 			 var user_buffer : x_buffer(length);:  			 var offset      : integer ); beginr<     substr ( user_buffer, offset, length ) := rpacket.pbuff;     offset := offset + length  end;  5 procedure move_from_user ( buffer_length   : integer; 0 			   var user_buffer : x_buffer(buffer_length);  			   var offset      : integer;& 			   var dpacket     : full_packet );   begina  '     { Compute number of bytes to send }}2     nc := minimum ( 128, buffer_length-offset+1 );       { Form the data packet })     with x as dpacket::tu58_packet(nc) do  	begin 	x.flag     := data; 	x.length   := nc;2 	x.pbuff    := substr ( user_buffer, offset, nc );+ 	x.checksum := get_checksum ( nc, dpacket )a 	end;a     offset := offset + nc: end;   begin	     { Lock the controller }m     lock_mutex ( tu58_mutex );       { Initialize flags }     done := false;     retries := max_retries;        while not done do  	begin   	{ Send the command packet }< 	send_command_packet ( opcode, unit, block, buffer_length );   	{ Initialize buffer offset }  	buffer_offset := 1;   	error := false;  / 	{ Loop until done or an error is encountered }t 	repeatD  A 	    { Get a response - if a powerfail occurred, skip out of this / 	      loop and retransmit the command packet }n  2 	    powerfailed := receive_packet ( rsp_packet );   	    if not powerfailed then  , 	        { What kind of a response was is? }  	        case rsp_packet.flag of   		{ Data - response to read } = 		data	: { Validate checksum and copy data to user's buffer }n+ 			  if verify_checksum ( rsp_packet ) then * 			      move_to_user ( rsp_packet.length,2 				   rsp_packet::tu58_packet(rsp_packet.length), 				   buffer, buffer_offset )	 			  else	 			      error := true;e  " 		{ Continue - response to write } 		continue: beginn1 			  { Copy data from user's buffer and ship it } , 			  move_from_user ( buffer_length, buffer,% 					   buffer_offset, data_packet ); % 			  send_packet ( size(data_packet),s0 				data_packet::byte_data(size(data_packet)) );	 			  end;     		{ end - operation completion }? 		control : if verify_checksum ( rsp_packet::full_packet ) then  			      done :=  true	 			  elser 			      error := true;   " 		{ No other responses are valid } 		otherwise error := true0   	        end { case }c  $ 	until done or error or powerfailed;  1 	{ First check for done via end packet received }d
 	if done theno* 	    with x as rsp_packet :: end_packet do 		case x.success ofd- 		    success, success_with_retries,bad_unit,e. 		    no_cartridge, write_locked, data_check : 				status := x.successh* 		    otherwise status := controller_error 		end; { case }   ' 	{ Now check for error exit from loop }  	if error then
 	    begin  7 	    { Reset the controller and decrement retry count }s 	    reset_controller; 	    retries := retries - 1;  F 	    { if no more retries, we're done with status = controller error } 	    if retries <= 0 thene 		begine 		done := true;t 		status := controller_error 		endm	 	    end;    	end; { while }d  4     { Release the controller and return the status }      unlock_mutex ( tu58_mutex );     do_tu58_io := status   end;      , function tu58_open of type disk$open_action; {++  {d$ {  Open_action - open action routine {l> {	This routine is called by the file server to open the device { 
 {  Inputs: { 2 {	device_char specifies the device characteristicsF {	device_dependent_char specifies the device dependent characteristicsE {	context is a pointer to the drive data base structure for this units {  {  Outputs:p { 0 {	device_char returns the device characteristicsD {	device_dependent_char returns the device dependent characteristics" {	return value = completion status {_ {--} begine  (     with context::tu58_structure_ptr^ do 	begin    %         device_char := [dap$v_devdir, %                         dap$v_devfod,e"             	        dap$v_devshr, 			dap$v_devavl, 			dap$v_devidv,             	    	dap$v_devodv,e              	    	dap$v_devrnd];    0         { Set device dependent characteristics }%         with device_dependent_char DOp             begin #             dap$b_sectors   := 128;o!             dap$b_tracks    := 4;o!             dap$w_cylinders := 1;i/             { Return max LOGICAL block number } /             dap$l_maxblock  := max_block_number              end;  A         { Save the max record size and return successful status }t  #         tu58_open := dap$k_success;[           end    end; {    * function tu58_get of type disk$get_action; {++  {   {  tu58_get - get action routine { F {	This routine is called by the file service to read a block or blocks {	from the device  { 
 {  Inputs: { : {	starting_lbn specifies the starting logical block number5 {	buffer is the address of the buffer to receive datat+ {	buffer_length is the length of the bufferc: {	context is a pointer to the drive database for this unit {      {  Outputs:  {b( {       return value = completion status {w {--} varw     success_code : byte;     block_length : word;   beginr  L     eln$allocate_stack ( 2 * 512, status := allocate_status ); { two pages }  (     with context::tu58_structure_ptr^ do 	begin  ' 	block_length := buffer_length div 512;o  0     	if ( starting_lbn <= max_block_number ) and@ 	   ( ( starting_lbn+block_length-1 ) <= max_block_number ) then             begin   @ 	    success_code := do_tu58_io ( read_data, unit, starting_lbn, 					 buffer_length,) 					 buffer^::x_buffer(buffer_length) );u4             tu58_get := set_status ( success_code );             endn           elseB             { Illegal block number (either start or end or both) }+             tu58_get := dap$k_illegal_blockf   	end;    end; i    * function tu58_put of type disk$put_action; {++  {)  {  tu58_put - put action routine {sG {	This routine is called by the file service to write a block or blocks8 {	to the devicea {t
 {  Inputs: {s: {	starting_lbn specifies the starting logical block number9 {	buffer is the address of the buffer containing the datae+ {	buffer_length is the length of the bufferl: {	context is a pointer to the drive database for this unit {      {  Outputs:: {t( {       return value = completion status {  {--} vare     success_code : byte;     block_length : word;   begin   L     eln$allocate_stack ( 2 * 512, status := allocate_status ); { two pages }  (     with context::tu58_structure_ptr^ do 	begin  ' 	block_length := buffer_length div 512;e  0     	if ( starting_lbn <= max_block_number ) and@ 	   ( ( starting_lbn+block_length-1 ) <= max_block_number ) then             beginc  A 	    success_code := do_tu58_io ( write_data, unit, starting_lbn,  					 buffer_length,) 					 buffer^::x_buffer(buffer_length) );i4             tu58_put := set_status ( success_code );             end(           elseB             { Illegal block number (either start or end or both) }+             tu58_put := dap$k_illegal_blocka   	end;    end;    . function tu58_close of type disk$close_action; {++e {=@ { This function is called by the file service to close this unit { 	 { Inputs:  { 5 {	context points to the drive data base for this unit  {e
 { Outputs: {n {	return value = success {e {--}   beginx        tu58_close := dap$k_success;   end; z      B process_block tu58_process ( unit : integer; init_event : event ); {++  {r4 { This is the unit level process for the tu58 driver {		 { Inputs:o { . {	unit specifies the unit number of this drive( {	init_event is the syncronization event { 
 { Outputs: {r {	none {k {--}   varp)     drive_structure : tu58_structure_ptr;p)     port_name       : varying_string(31);l   begin_  M     eln$allocate_stack ( 4 * 512, status :                                                                                                                                                                                                                                                   Y                        / $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DDDRIVER.PAS;1                                                                                      N     9                         Ҟ      8       = allocate_status ); { four pages }   2     { Allocate the drive structure for this unit }       new ( drive_structure );"     drive_structure^.unit := unit;    /     { Create a name for this particular drive -aM       Note: the outside world sees units numbered 1 and 2, which are actuallyt'             0 and 1 to the controller }n  <     port_name := controller_name + CHR(unit + ORD('0') + 1);    (     { Pass control to the file service }  2     eln$file_service ( port_name, drive_structure,( 		       init_event, file_service_ptr );     end; {Drive process}   end;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ' * [SYSEXE.SEAS$WORK_0000005C]DEFBOO.COM;1 +  ,    .     /     4 P                         - 
    0   1    2   3      K  P   W   O     5   6 Z(  7  9K  8          9          G    H  J                        
 SET VERIFY ! DEFBOO.COM
 ! Rev Num 3.0  ! E ! This command procedure will be executed automatically during system J ! initialization or following a power failure or an error halt if you haveM ! enabled the AUTO_BOOT keyswitch.  It will also be executed when the command & ! BOOT with no device name is entered. ! O ! This file boots from the DEBNA over the Ethernet (device type XEA). To modify P ! the file for a different device, replace ETA with DDDnnn in the BOOT command,  ! where:2 !       DDD = device name: BCI, BDA, UDA, XEA, ETAH !       nnn = boot device unit number (ignored if you deposit the unit #) !				       in R3 in the xxxBOO.com file)  ! I IF NOT HALTED THEN HALT ! Halt cpu and avoid unnecessary warning messages 4 WAIT                    ! wait for processor to haltI BOOT ETA               	! Boot from DEBNA (device type ETA), unit set in   		      	!   ETABOO.COM                                                                                                                                             ( * [SYSEXE.SEAS$WORK_0000005C]DEFBOO8.COM;1 +  ,    .     /     4 P                          - 
    0   1    2   3      K  P   W   O     5   6 `^p(  7 `K  8          9          G    H  J                       
 SET VERIFY ! DEFBOO.COM
 ! Rev Num 3.0  ! E ! This command procedure will be executed automatically during system J ! initialization or following a power failure or an error halt if you haveM ! enabled the AUTO_BOOT keyswitch.  It will also be executed when the command ( ! BOOT, with no device name, is entered. ! , ! This command file is tailored for an 8800. ! O ! This file boots from the DEBNA over the Ethernet (device type XEA). To modify P ! the file for a different device, replace ETA with DDDnnn in the BOOT command,  ! where:2 !       DDD = device name: BCI, BDA, UDA, XEA, ETAH !       nnn = boot device unit number (ignored if you deposit the unit #) !				       in R3 in the xxxBOO.com file)  ! 0 SET CPU NEXT_SECONDARY		!Halt the next secondary IF NOT HALTED THEN HALT  WAIT, SET CPU NEXT_PRIMARY		!Halt the next primary IF NOT HALTED THEN HALT  WAIT0 SET CPU CURRENT_PRIMARY		!Select current primaryI BOOT ETA               	! Boot from DEBNA (device type ETA), unit set in   		      	!   ETABOO.COM                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         * * [SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.EXE;1 +  ,    .     /     4                             - 
    0   1    2   3      K  P   W   O     5   6 Gh  7  BK  8          9          G    H  J                      0 D X     0205      (  `     6                                        	DHTDRIVER                              VAXELN V4.2-00 @z 05-05                                     
       ?         !        DAP_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001!      !         DDCMP_V2_001"      !         
TERMCLASS_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             $ACCESS  ¶ ,E  *@+`y<}X,       ARAI   	
  
Þ΀^"V < ~{/  k/  ###(#%ݏ    < ~Ƅ 0  ƄRƄRƄRƄ< ~  #S2S%|R 	`0|~ <<~R߭ߦD
P  #S2S%)R @|~|~8,R߭ߦD
P  ݏ   8< ~4 x 4<48S<RCDSRRϐRWW'.  ƌ d ƌ dƌ (ƌ Ǝ ƌ F(ƌ   ϕWW-  Rƌ d ƌ dƌ (ƌ bƎ ƌ @Wŏ  W\<UxWR1RP8S2RT4RRc~Tc~Pc~L-  W084q  ߦP X  ~B-  PX h   SSR>BXR b   xSR>BR b   S ߭ X  ~,  PY i          ݦP @  ,RЭTTYݦP RߦL   ݦP|~  RϺSݦP @  TXݦPR SߦL   ݦP|~  RݦP   " 44R"@@4 ( ߭   ݭ x ih` ߭  ЭWW4Sŏ  SU<TxSR1RR8~C ES S1 WUE \ lŏ  US<R|~E Cn+  <TCRbR
& 4xUR1RR8~E CUd<R|~E C$+  U
WݭTD R # TSCƐݢ"߭ T1^8W޼޼n[޼X޼ZШR
& *ШS
&RR 
 
&УԣУԣ30ШS
&RR 
 
&УԣУԣ [ 
 1jR @ݢ< @  8-jR @%8 DJݢϲDݢ<  	Ը 
Rʏ@   RR 
1 [ШSШSSRխ1 Yխ1 TYЭSC%VSUYT3T0Ub+xUQQ&PPQQ&PP
TE%VUT|V~hjk)  QPTTQTjS QTQQE0bSUS0USbTST$SQA&A%xQSSPP&PPS&TQb UU׭1,@jRRSn7 2 `, @ 8DJݣT
JݣE>jR 6|~jh}(  ШR
& n~jhݮϊ|~jhT(    
[1^T޼XVWX|~  PPWVX1  1P UU %U'  X1  1  0 h  1VUc'  X1`  1PP@ĈX
  4ݥ\U'  1P@ČX
  4ݥХRRPX@ĈBdR(U&  1 P@ĐX
  ХSC R lŏ  SQ<P C A&   ЏS                                                                                                                                                                                                                                                                                                                                                                                                                  Z                        `s $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.EXE;1                                                                                                                   !j "     	       FEŏ  Q<PAP`Q
&Pʏ   PP
&ݢ"߭ U&  X
  U%  V1^R޼Sc   cc  
     PP<>T޼UxUS8RCR bbb
b
	b`8RE$|^V(ЭUxUS8RCT RRd1RRdSSS C`CYRRdCNRR	d3RRd4RRd5RR 6RRd9RRdRR2RR
d
d68RE$xUR>B&Rb<R EDď  U>ED~$  7RRddЭS<RCD<^S޼Uм޼TRUPP RRdR PPRPPPPRPPRPPRPPR	PPRRPPRPQQPPRQPPR
PPPPRRxUP>@P<Q EDŏ  UP>@D~#  UP@ÈP`|^޼UWZe[1޼n

1 X HD1[ŏ  XRBTѴ1 
1k1c1[ dxRRRj eRR,ФP
&RRR
&ФP
&RRR
&*ФP
&RRR
&ФP
&RRR
&W1 ' " `ФP
&Rȏ   RR
&WФR$1
RZZZZZ1 V Rď  RBSУQxaRR&xaPPZRRP&աa ֡УP`RVB%``
&Rȏ   RR
&Wѡ  $ a
&Rȏ   RR
&<WZ1 E Rď  RBRТP`RB%``1
&Rȏ   RR
&W1V Rď  RBSY 1VQQf c0УP
&RRR
&УP
&RRR
&W1.УP`RVB%``1
&Rȏ   RR
&W1Qf c0УP
&RRR
&УP
&RRR
&W1УP`RVB%``1
&Rȏ   RR
&W1УP`RVB%``1z
&Rȏ   RR
&W1_VRRbdУP
&Rȏ@   RR
&x`RRR&ՠ`֠WУP`RVB%``
&Rȏ   RR
&WYVQQ1  c0УP
&RRR
&УP
&RRR
&W1Y1УP
&Rȏ@   RR
&x`RRR&ՠ`֠WУP`RVB%``1a
&Rȏ   RR
&W1FQ1  c0УP
&RRR
&УP
&RRR
&W1
Y1УP
&Rȏ@   RR
&x`RRR&ՠ`֠WУP`RVB%``1 
&Rȏ   RR
&W1 Y1 Q 5УPx`RRR&ՠ`֠
&Rȏ@   RR
&WУP`RVB%``I
&Rȏ   RR
&W/ď  X>HDRR  P RRPnQ 1GWPЬQ <^޼nSо US$޼Te PTQ SS^S޼T8RD$P^U޼XXR>BXSX
c|~  SXPZ޼Y޼WZH@|~  0<@@RXPP RR44QPPSYVPPVPRVRRTTSCTTR4PCgQaSTRRSYR ZR1rH@|~  XR>BXSXc  T8R H$/TЏSyRnn|~ 8R H$n|~ TP^xS޼n0<@@RnPP RR44PPP PRPRRP<4URммм<ռ
Ѽ   < RмԼԼ <`$RѢ9xR8T BRR xR1RS4RSdSRdRRSSSxS.SR8TRdRR/SSdRRЏ PQRЬPРR  PϞ^|  mQVDX޼Ьޯ]ЦU8Y E$1}Ѯ?ծ:ŏ  UT<SRݮDE   Pn1 TѤ2xUR BRR xUR1RS4RSiSRiRRSSSxUS.SRRiRR/SSiRRŏ  US<RЦϡԭ}ԭ߭߭߭ݤE C	  PnnzѦZЭZZ Z}P`PѦ ЦSSWмRGSW[м[R(RkZ
Џ ' 씭Џ Џ ! Џ ! |ЭP^QRS޼޼nТPϳԭ ߭ݢݮݮ@   PЏ PЏ ! P^QS1RУT8Q D$2xTP @ PѠJԭ߭T  Џ PЏ ! P μ^Ь < ~4  P`σ]V]]\]|~|~|~|~ |~|~  PnP     P Q\L\  PϞL^|y  mX޼Z޼d޼`޼hޯ] < ~T   x       0ZRRw#WW  W(W%W RRRWR(Rwc[[WW  W(WȣW RRRWR(Rπc2[oޭs xo߭   S2Spޭt p߭    ` ZJ   xZS8R4CZxZR3RR83ŏ  ZS<R>CDRxJd0ZR<  d  x ߭߭ ѭ1 xZR3RR81 ~  PVZf ߭  t|~ x߭  CYRV R߭߭  1v      Vd  1R   VL  1:V@  1.R|~R x   ŏ  ZS<R>CDRptpR  1~  PVZf ߭  w|~ ߭  GRhV R߭߭  1      Vz  1h   Vb  1PVV  1DP$^T޼޼޼nZ߭   ݭ x ݮ߭ nݮ߭߭ ݮ ߭߭ ݮ @  VWSSWV1 X|~  SR   Ѣ5Ѣ+P UUSPeSZVX
  V1iЭ[1 [1 YX|~   Q PQPY1  P UUY hPРQaQXPQP*QP РWåV ٥WSyRRWSVRǐXXRPeRСQPea
P	Ub  X
  Y1%X|~  SRSRnnSR}X
  Z1Zݾ߭ 1{RX|~  мPԼX
  ^5R޼}S޼޼n߼QyPPTQ$SP   S T}S~8  PSЮ}X|~  Q PcQn  SX
  ^pS޼U޼W < ~  ~  PVf|~  |~߭߭߭߭@ ѭ16ЭRR   ݭ   1'ЭTϤ# ? z           \   1 xeQ8PAeT߭61 xeQ8P4Ae߭xeQ8PWA4UTϗaWRUTrRRUT
EeRŏ  RQ<PVAB R߭ϐePV@ P߭ЏS|~~ݭ߭` 1ݭ   ѭ||  1ѭ||  1 f!eRB R߭   ݭR?  V
  ߭     U  P^yW޼X޼Zм<~߭߭߭p  ЭYY1HЭV( hfݼ   ЭxZR>BSX
c|~  ЭS xZU>E$Rb
ŏ  ZT<RD>E%Rb RRRR	RRRR
RRRRRRRRRR	RR RRRRRRRRRR
RR>ESXc  ЭRЏSY|  Y|  	Y|  ЏSЭQRЬPРТPP|  P|  	P|  ЏSR  P^|  mV޼W޼YЏSޯ]мPѠݏS 8 мRXXSSѢ<ݏS 8 +SѢ ݏS 8 ݏS 8 xWP>@RX
b|~  мTQQQPP,xWP>@RXb  ݏS 8 RRR
2RRRR B&,xWP>@RXb  ݏS 8 PP
PRRR B,xWP>@RXb  ݏS 8 ޼U 	eŏ  WS<P	C
ee<PCPPeePP eRRR B3PPe2PPP@4PPe2PPP@!PP	eXe<PCe!<PC<PC<PCxWS>C$RbeYWAe~~YWϬ >CRXb  ЏS|мPЭ< ^S޼޼T޼U0<@@RЮnn RRd eeee 	e ^ES޼޼U޼W޼VWVWTTVT0<@@RЮnn RReHTHVHH |^S޼R޼T޼nм޼VЏSUЏmQyP|dQ8P A$1  <Џ@QyP(#QyPPѢ QѢP	ЏSU}%QyPPѢ(QѢ$P	ЏSU}$
P}@@حUSxdP>@XQX
a|~  QyPPѭQѭP!dP}@cdPV@ÌdϏ(nd%dPV@ÈdnЏSUU<^T޼U޼S0<@@RUnn RRc U@^TR޼T޼ST@H0<@@QTPP QQc  T@TP>@XQXa  ^X޼W޼Y޼n޼ЏS   RnRЏSԧiS8R C$ЏSԧ SyRRѧ$Sѧ RЏSԧѭS1߭   ݭ x iRB SX*ݣ&|~  iRB RЏSFԧHէ1]iRB Vŏ  iS<RCd էЧԦJЧЧJЧԦJԦ- (  (
E( (N fiSŏ  ST<R C D%   k<SyRRѧ$Sѧ RЏSFEiRݮBȐ i Tݶ߭ ݦ"|~  /*SyRRѧ$Sѧ Rզ 
 FЏSFЦЦFRRSRS	RS
ЧRB HiRB RТFiRB SX*ݣ&  ݭ x Э|^yT޼R޼V޼ЏSU   PѮP
ЏSUԢfP@   US-ТS'fQA nS SQUP
ЏSUԢUf                                                                                                                                                                                                                                                   [                        a $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.EXE;1                                                                                                                                P@   QRЬPРТPP|  P|  	P|  ЏSR  P$^|  m޼n޼UЏSޯ] eݏS 8 мR- ,  ,1 J~  PX~  PV~  PT d X  ~|  PW߭   Эg  RUTVݼXWݮ R߭   d|~   ffX%  eW  d   T  |мRЭQRЬPРТPP|  P|  	P|  ЏSUR  P ^|  m޼n޼RЏSޯ] b߭   ݭݮ  b|мPЭ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @   @                                                              H   P   h   `   p                                  x   `   @   P   H   (       p                     4   
                 @                                                                       DAP                                                            	LIBCOMMON                                                      	PASCALMSC                                                      DDCMP_V2                                                       	TERMCLASS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * * [SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1 +  ,    .     /     4 i                           - 
    0   1    2   3      K  P   W   O     5   6  ?R.  7 K  8          9          G    H  J                     $ module dhtdriver [ident('V4.1-00')];  M {****************************************************************************  {*									    *) {*  COPYRIGHT (C) 1984, 1990   					    * < {*  BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.			    * {* 									    * M {*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  * M {*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  * M {*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  * M {*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  * M {*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *  {*  TRANSFERRED.							    * {* 									    * M {*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  * M {*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *  {*  CORPORATION.							    * {* 									    * M {*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  * B {*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { 6 {	This module contains the driver for the DHT-32 async {	multiplexor device { 	 { AUTHOR:  {  {	Julie McGray 22-July-1988  { 
 { VERSION: { 	 {	V3.2-00  {  { MODIFIED BY: {   {	V3.2-01	  J. McGray	6-Oct-1988? {		Do an EXIT upon diagnostics failure in initialize_interface.  { ) {	V3.3-00	  J. McGray	November 28, 1988 	 2 {		- Added DDA support for the following function: {		  dda$_fnc_assert_break { ' {	V3.3-01 January 18, 1989 - J. McGray	 3 {		- Added DDA support for the following functions: : {		  dda$_fnc_read (min/max reads, timeout, and reads with: {		  a terminating mask of characters) and dda$_fnc_write. { ' {	V3.3-02 January 19, 1989 - J. McGray	 3 {		- Added support for line PASSTHRU characteristic / {		  and the READ_PASSTHRU read characteristic. 6 {		  Line PASSTHRU is now in the line parameter record# {		  that is passed in from EBUILD. ? {	    ********************************************************* ? {	    *** All user-written drivers MUST use the new definition  : {	    *** of terminal_flags for the call to TC$READ_CHARS.? {	    *********************************************************  {			< {	       - Changed handling of isr events to fix the problem5 {		 where an event could potentially get lost, due to 6 {		 multiple event(s) occurring before the main driver {		 process could unblock.@ {	    **********************************************************; {	    ***	 ALL user_written drivers must use the method of  9 {	    ***  processing isr events.  Note that EVENT is now ? {	    ***  defined differently in the TERMINAL_READ_DATA record ; {	    ***  and that CNTRL_CHAR and CNTRL_CHAR_POS no longer 2 {	    ***  exist in the TERMINAL_READ_DATA record.@ {	    ********************************************************** { $ {	V4.0-00 March 2, 1989 - J. McGray	3 {		- Added out-of-band signalling functionality for * {		  the following user-callable routines:" {			ELN$TTY_SIGNAL_OOB_CHARACTERS " {			ELN$TTY_CANCEL_OOB_CHARACTERS ! {			ELN$TTY_RECEIVE_OOB_CHARACTER 1 {	 	- Renamed EVENT (in line_Ctx) to EVENT_FLAGS.  { " {	V4.0-01 May 2, 1989 - J. McGray	7 {		  - Added support for error reporting for DDA reads. 8 {	    	    Report parity, framing, overrun, breaks, and 7 {		    overflow conditions.  Terminate the current read 7 {		    if an error occurs.  DAP reads are not affected.  { # {	V4.1-00 July 6, 1989 - J. McGray	 7 {		- Take out the check for get_ctrl_key requests whose 8 {		  circuits to the application have been disconnected.> {		  It is no longer needed becuase the circuit process which : {		  is waiting for the control key to be typed now does a9 {		  WAIT_ANY on the circuit process object, rather than  @ {		  suspend itself, so that it will detect a disconnect itself.; {		  This eliminates the 20 second timer in the main driver  {		  process.	 {	******* NOTE ******** 5 {		All user-written drivers MUST take out the call to 7 {		TC$CLEANUP_CTRL_KEY, because it tries to do a RESUME 3 {		of the process that calls TC$AWAIT_CTRL_KEY, and 7 {		that code has been modified in TERMCLASS.PAS so that   {		it no longer suspends itself.2 {		User-written drivers should simply take out the1 {		timer from the main process wait_any call, and 6 {		therefore take out the call to TC$CLEANUP_CTRL_KEY.B {	    - Modify dda$tty_read and dda$tty_write to return number of ' {	      bytes transferred = 0 if error.  {--}  
 include $dap;  include $termclass;  include $physical_address; include $ddcmp_v2; include $stack_utility;  include $unibus; include $mutex;  include $kernel;1 include $elnmsg;	{ ELN error symbol definitions } : include $dda_utility;   { DDA data structure definitions }' include $kernelmsg;	{ KERNEL messages }    type@     { Terminal DDA record for miscellaneous per-line variables }      dda_line_struc_misc = recordM         dda_signal_modem_q_lock  : mutex; { Lock for accessing modem queues } I         dda_terminal_char_lock   : mutex; { Lock for accessing terminal }  					  { characteristics} 1 	host_sync	   : boolean;	  { Input flow control } - 	modem_control	   : dda$_modem_control_types; ) 	modem_state	   : dda$_modem_state_types;      end; { record }        nibble = 0..15;      bit_storage = [bit] 0..1; "     rate_tbl_entry = packed record 	value: [byte] nibble; 	valid: [byte] boolean;  	end;   $     parity_tbl_entry = packed record 	value: bits$1;  	valid: [byte] boolean;    	end;        { timing queue records }     queue_record = record  	entryq      	: queue_entry;% 	line	   	: integer;	   {line number} > 	time_at_timeout : large_integer;   {absolute time at timeout}= 	evnt		: timeout_event;   {type of timeout we are requesting} C 	ignore_timeout  : boolean;  {true if there is not longer a  need } A     end; { record }		    { for this timer. ie ignore the timeout}        line_timer_state = record C 	break_duration_started : ^queue_record; {la                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  \                        N $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "     
       test break timer entry} C 	break_delay_started    : ^queue_record; {latest break timer entry} ? 	io_tmo_started	       : ^queue_record; {latest io timer entry}      end; { record }			       timeout_event = (  		{ / 		{	The following events are used to signal the 5 		{	main process (controlling process) for a timeout.  		{} 		evnt$noevnt,			{no event} ( 		evnt$break_duration,		{break duration}3 		evnt$break_delay,		{delay before break assertion}  		evnt$io_tmo			{I/O timeout}  		{  		{ Could add other timeouts 		{  		{} 		);  6     { General purpose record type.. one bit per line }$     bit_array = [byte] packed record( 		flag : packed array [0..7] of boolean; 		end; { record }    ;     { Stores the duration of a pending break on each line }      line_break_data = record 		duration : large_integer;  		end; { record }         event_record = packed record 	local_event: isr_event_flags;  	local_nbr_cntrl_chars: integer; 	local_cntrl_char_idx: integer;      end; {record}    var =     {dda_line_struc_misc record is defined in DDAUTIL module} G     dda_line_struc : array [0..max_line_number] of dda_line_struc_misc;   L     {Need to be able to compare dda$_terminal_speed_types and EBUILD speeds}     { to the driver speeds. } O     { FALSE indicates this driver does not have the equivalent of the dda rate} _     rate_array : [readonly] packed array [dda$_rate_none..dda$_rate_38400] of rate_tbl_entry :=  		(  (rate_none,FALSE),  		   (rate_50,true), 		   (rate_75,true), 	 		   (rate_110,true), 	  		   (rate_134_5,true), 	  		   (rate_150,true),  		   (rate_300,true),  		   (rate_600,true),  		   (rate_1200,true),   		   (rate_1800,true),   		   (rate_2000,true),   		   (rate_2400,true),  M 		   (RATE_NONE,FALSE), {corresponds to DDA rate 3600, not supported by DHT }  		   (rate_4800,true),   		   (rate_7200,true),   		   (rate_9600,true),   		   (rate_19200,true),  		   (rate_38400,true) );   b     dda_rate_array : [readonly] packed array [rate_50..rate_38400] of dda$_terminal_speed_types := 		(  dda$_rate_50, 		   dda$_rate_75, 	 		   dda$_rate_110, 	  		   dda$_rate_134_5, 	  		   dda$_rate_150,  		   dda$_rate_300,  		   dda$_rate_600,  		   dda$_rate_1200,   		   dda$_rate_1800,   		   dda$_rate_2000,   		   dda$_rate_2400,  8 		   {dda$_rate_3600,}  {Driver does not have this rate} 		   dda$_rate_4800,   		   dda$_rate_7200,   		   dda$_rate_9600,   		   dda$_rate_19200,  		   dda$_rate_38400 );   O     {Need to be able to translate dda$_parity_type to driver supported SENSE. } P     { FALSE indicates this driver does not have the equivalent of the dda type.}i     parity_array : [readonly] packed array [dda$_parity_space..dda$_parity_ignore] of parity_tbl_entry := 3 		(  (oddp,FALSE),   {not supported by this driver}  		   (oddp,true),      		   (even,true),    	  5 		   (oddp,FALSE),   {not supported by this driver} 	 4 		   (oddp,FALSE) ); {not supported by this driver}	  /     {Translate from driver SENSE to dda values} R     dda_parity_array : [readonly] packed array [oddp..even] of dda$_parity_type :=< 		(  {dda$_parity_space,}     {not supported by this driver} 		   dda$_parity_odd,  		   dda$_parity_even );< 		   {dda$_parity_mark,}      {not supported by this driver}< 		   {dda$_parity_ignore );}  {not supported by this driver}  A { BREAK_DELAY is a table of fixed time intervals which represent  H { the amount of time needed to delay before setting a line to the break D { state, in order to allow any previously transmitted characters to F { complete transmission.  The time intervals are device and baud rate : { dependent, and must be set for each particular driver.   { - { Use the following formula to compute delay: < {	Delay = (number of characters in the device's transmission< {	   holding buffer)  *  ( transmission speed per character,$ {	   assuming 12 bits per character) { : {	Where transmission speed per character is calculated by:7 {	(number of bits per character including start, stop,   {	   and parity bits) / 2 {	   (line transmission speed in bits per second)  {v/ { The DHT-32 device supported by the DHTdriver *< { has a 2 character output buffer, so the formula becomes:   {	delay = 2 * (12/baud_rate) 9 { F { The interval values in the BREAK_DELAY table are in negative tenths > { of microseconds; ie for 9600 the delay is .00250 seconds =  ; {       2500 microseconds = 25000 tenths of a microsecond. C {}S     break_delay : [readonly] packed array [rate_50..rate_38400] of large_integer :=E 		( -4800000, {50} 		  -3200000, {75} 		  -2181819, {110}I 		  -1784390, {134.5}P 		  -1600000, {150}M 		  -0800000, {300}  		  -0400000, {600}  		  -0200000, {1200} 		  -0133334, {1800} 		  -0120000, {2000} 		  -0100000, {2400}( 		  -0050000, {4800  no 3600 for DHT-32} 		  -0033334, {7200} 		  -0025000, {9600} 		  -0012500, {19200}    		  -0062500 {38400} );E  =     timer_queue		: queue_entry;   {header of the timer queue}	K     timer_complete_q	: queue_entry;   {queue of completed timeout requests}S@     request_queue	: queue_entry;   {header of the request queue}:     sync_lock		: mutex;	 {access lock for timing elements}8     my_timer	  	: large_integer; {for get_time routines}B     new_timeout 	: large_integer; {absolute time of next timeout} I     line_timer_struc    : array [0..max_line_number] of line_timer_state;c   constp$     { driver-specific dda constants}'     driver_class 		= dda$_class_tty;    '     device_type 		= dda$_type_dht;	    	  5     max_line_number   = 7;      	{lines are 0 thru 7}sI     max_device_objects = max_line_number + 1;  {device object 0 is used }2$ 					{ for regular terminal lines. };     max_read_buffer_size = 512;		{maximum read buffer size}3  &     ipl$_power = 30;			{powerfail ipl}  ?     handle_xon_xoff = false;	{TRUE if DRIVER handles xon/xoff }d. 				{FALSE if DRIVER does NOT handle xon/xoff}) 				{DHT controller handles TTY_SYNC by }n, 				{ setting or clearing iauto and oauto. }2 				{ TTY_SYNC is NOT implemented in this driver }
 				{ code. }      input_vector_number = 1;     output_vector_number = 2;H@     tx_fifo_max = 64;		{ Maximum number of characters that the }( 				{ transmit fifo can hold per line. }  0     short_break	= -37500;    {3.75 milliseconds})     long_break	= -35000000; {3.5 seconds}i     { ! { Possible device characteristicsl {}%     { Baud rate bit representations }*     rate_none  = %b'0000';     rate_50    = %b'0000';     rate_75    = %b'0001';     rate_110   = %b'0010';     rate_134_5 = %b'0011';     rate_150   = %b'0100';     rate_300   = %b'0101';     rate_600   = %b'0110';     rate_1200  = %b'0111';     rate_1800  = %b'1000';     rate_2000  = %b'1001';     rate_2400  = %b'1010';     rate_4800  = %b'1011';     rate_7200  = %b'1100';     rate_9600  = %b'1101';     rate_19200 = %b'1110';     rate_38400 = %b'1111';       {bits per character}     char_length_5 = %b'00';R     char_length_6 = %b'01';      char_length_7 = %b'10';M     char_length_8 = %b'11';        {number of stop bits}*     stop0 = 0;     stop1 = 1;       {parity stuff}
     oddp = 0;	
     even = 1;t       {modem indicators}     modem    = true;     no_modem = false;e  $     { Default line characteristics }'     default$tty_sync            = true; )     default$char_length		= char_length_8;      default$stop_bits		= stop0;E&     default$parity_enable    	= false;     default$sense		= even;#     default$baud_rate		= rate_9600;s     default$modem		= no_modem;     default$hardcopy		= false;      default$ANSI_escape		= true;     default$echo		= true;      default$passall		= false; (     default$eightbit            = false;(     default$ddcmp_protocol      = false;     default$passthru		= false;   	     type       { Some useful types }n     byte    = [BYTE]0..255;      word    = [WORD]0..65535;i       packed_word = packed recordo 	wd : [word] word; 	end;e       bits$1  = 0..1;_     bits$2  = 0..3;o     bits$3  = 0..7;h     bits$4  = 0..15;     bits$6  = 0..63;  (     buffer_ptr  = ^terminal_read_buffer;   t  0   { Interrupt Controller Register Descriptions })   int_register_def = [byte] packed recordr'     dc		: boolean; 	{ disk controller } '     sc		: boolean; 	{ tape controller }t'     vs		: boolean; 	{ video secondary }l*     vf		: boolean; 	{ video end of frame }4     ns		: boolean; 	{ network controller secondary }2     np		: boolean; 	{ network primary controller }4     st		: boolean; 	{ serial line transmitter done }9     sr		: boolean; 	{ serial line receiver or silo full }E   end; { record }   %   interrupt_registers = packed record '     hltcod		: integer;	    { 200                                                                                                                                                                                                                                                   ]                        Q, $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "            80000 }f%     mser		: integer;	    { 20080004 } %     mear		: integer;	    { 20080008 }p+     mask 		: int_register_def; { 2008000C } &     vdc_org		: byte;		    { 2008000D },     vdc_sel		: vdc_sel_def;	    { 2008000E }-     int_clr		: int_register_def; { 2008000F }d   end; { record }   2 { Video interrupt select register definition }    '      vdc_sel_def = [byte] packed recordD= 	rec_int_ena	: [pos(0)] boolean;	{ receiver interrupt enable}s# 					{ enables interrupt at 244hex}l     end; { vdc_sel_def }   {f! { Async device registers contents  {}     { Control status register }      csr = [word] packed recordI             ind_reg_address : bits$4;	{indirect register number - L.SEL } , 					{ used to select the line number that }( 					{ is represented by the following }- 					{ registers:  Line Parameter Register, }.$ 					{	Transmit FIFO data register,}$ 					{	Transmit FIFO size register,} 					{	Line Status Register, }$ 					{   and Line Control Register }>             diag_skip	    : boolean;	{diagnostic skip - D.SKP}/             master_reset    : boolean;  {reset} H             rx_int_ena      : boolean;	{receive interrupt enable - R.IE}G             rx_data_avail   : boolean;	{receive data available - R.DON}aA             tx_line	    : bits$4;	{transmit line number - T.LINE}s0 	    notused	    : boolean;	{not used on DHT32} 7 	    diag_fail	    : boolean;  {diagnostic fail D.FAIL}rF             tx_int_ena	    : boolean;	{transmit interrupt enable T.IE}=             tx_ready	    : boolean;	{transmitter ready T.RDY}t     	  end; { record }  0     { Receive buffer or Receive Timer Register }"     rxb_rtr = [word] packed record 	case boolean of1 	    true  : ( case0: rxb_rtr_0);  {receive char}v2 	    false : ( case1: rxb_rtr_1);  {receive timer}     end;       { Receive buffer }(     rxb_rtr_0 = [word] packed record    A 	    rx_char 	    : [pos(0)] char;  {character received - R.DATA}}3 	    rx_line	    : bits$4;   {line number - R.LINE} 7 	    parity_error    : boolean;  {parity error - P.ERR}e6 	    frame_error     : boolean;  {frame error - F.ERR}8 	    overrun_error   : boolean;  {overrun error - O.ERR}? 	    data_valid      : boolean;  {receive buffer valid - D.VAL}c 	  end;				            { Receiver Timer Register }e(     rxb_rtr_1 = [word] packed record    > 	    r_time	    : [pos(0)] byte;  {receive timer value R.TIME}5 	    unused	    : byte;	{not used when setting timer}l 	  end;				    c       { Line parameter register }c     lpr = [word] packed recordC 	    xreport	    : [pos(0)] boolean;  {XON/XOFF reporting - D.XRPT} G 	    diag_code       : bits$2;   {state of internal diagnostics of dht}uK             char_length     : bits$2;	{character length - C.LEN (5-8 bits)}I>             parity_enable   : boolean;	{parity enable - P.ENA}C             even_odd_parity : bits$1;	{parity sense select - E.PAR}eD             stop_code       : bits$1;	{number of stop bits - S.CODE}C             rx_baud_rate    : bits$4;	{receive baud rate - R.SPEED}	D             tx_baud_rate    : bits$4;	{transmit baud rate - T.SPEED}           end; { record }     %     { Transmit FIFO Size - read only}u6     { Available size ranges from 0 to 64 characters. }+     tx_fifo_size = [word] packed record    rC 	    fifo_size	    : [pos(0)] byte; {transmit FIFO space available}p? 	    unused	    : byte;	     {undefined when reading FIFO size}, 	  end;				    0  ,     { Transmit Buffer or Transmit FIFO size}$     tdat_tsiz = [word] packed record         case integer of			% 	    1 : ( tx_size  : tx_fifo_size );p$ 	    2 : ( tx_word  : [word] word );" 	    3 : ( tx_byte1 : [byte] char;$ 	          tx_byte2 : [byte] char );
 	end;  {case}        { Line Control Register }a      lctrl = [word] packed record> 	    tx_abort     : [pos(0)] boolean;	{transmit abort - T.ABT}B 	    iauto        : boolean;	{receiver auto flow control - R.AUTO}A             rx_en        : boolean;	{receive line enable - R.ENA} 4             break        : boolean;	{transmit break}E 	    oauto        : boolean;	{transmitter auto flow control - T.AUTO}S5 	    fxoff	 : boolean;	{force transmit XOFF - F.XOFF}v6 	    maint        : bits$2;	{maintenance mode - MAINT}C 	    link_type    : boolean;	{Link type - L.TYPE - Always clear it}iJ             dtr          : boolean;	{data terminal ready - DTR - not used}O             rts          :[pos(12)] boolean;	{request to send - RTS - not used} ' 					{bits 13, 14, and 15 are not used}{           end; { record }r         { Transmit Enable }vA     {*** Never change anything but the most significant bit, or }a!     {*** controller could hang! }p#     tx_ena   = [word] packed recordnD 	    trans_enable : [pos(15)] boolean;  {transmitter enable - T.ENA} 	  end;	             { Register layout }t  #     async_registers = packed recordp#     			async_csr	: csr;		{offset 0}h#     			rx_rt		: rxb_rtr;	{offset 2}e$     			line_param	: lpr;		{offset 4}( 			trans_fifo	: tdat_tsiz;    {offset 6}' 			line_control    : lctrl;	{offset 8}	t1 			dht_unused	: [word] word; {unused}	{offset 10}h" 			tx_enable	: tx_ena;	{offset 12}6 			dht_unused2     : [word] word  {unused}	{offset 14}     		      end; { record }c  6     { Some pointers to the aforementioned structures }$     register_ptr = ^async_registers; a       { Line parameters record }'     ln_param_rec = [long] packed recordoA          char_length   : char_length_5..char_length_8;	{bits 0-1}	0          stop_bits     : stop0..stop1;			{bit 2}+          parity_enable : boolean;			{bit 3}d/          sense         : oddp..even; 			{bit 4} 9          rx_baud_rate  : rate_50..rate_38400;		{bits 5-8}H:          tx_baud_rate  : rate_50..rate_38400;		{bits 9-12},          modem         : boolean;			{bit 13},          hardcopy      : boolean;			{bit 14},          ANSI_escape   : boolean;			{bit 15},          echo          : boolean;			{bit 16},          passall       : boolean;			{bit 17} 	 eightbit      : boolean;!          ddcmp_protocol: boolean;e$          passthru      : boolean;			          end; { record }  &     { Circuit process data structure }     ct_data_base = recordII             line             : integer;    {line number for this circuit}0<             port             : port;       {connecting port}:             read_buffer_size : integer;    {record length}             end; { record }0     ct_ptr = ^ct_data_base;   8     { Line configuration record sent by system builder }"     builder_params = packed record= 		dummy_word        : word;    {length of the varying string}y 		line              : integer;,                 parity_enable     : boolean;/                 sense             : oddp..even;m,                 modem             : boolean;,                 hardcopy          : boolean;,                 ANSI_escape       : boolean;,                 echo              : boolean;,                 passall           : boolean;,                 ddcmp_protocol    : boolean; 		cli		  : boolean;r 		passthru	  : boolean; M                 character_length  : [pos(64)] byte;  {eightbit specification};)                 stop_bits         : byte;e(                 comm_speed        : word     		end; { record }	  $     { Communications region layout }     input_region = record{=         csr_ptr : register_ptr;  {*** need for microvax 2000} = 	line_ctx : array [0..max_line_number] of terminal_read_data;n@         ddcmp_protocol : array [0..max_line_number] of boolean; O         ddcmp_region   : array [0..max_line_number] of eln$ddcmp_v2_rec_region; 8 	line_msc       : array [0..max_line_number] of rxb_rtr;         end; { record }r       output_region = record 	csr_ptr		: register_ptr;_= 	line_char      	: [aligned(2)] array [0..max_line_number] ofn 								 ln_param_rec;F 	line_valid     	: [aligned(2)] array [0..max_line_number] of boolean;
       end;  #     rec_region_ptr = ^input_region;e$     xmt_region_ptr = ^output_region;   t   vare   {nF { Device, device records, communications region, registers, etc., etc. {}R     int_mask_register   : ^interrupt_registers;   { virtual addr of int mask reg }  ;     async_input		: array [0..max_device_objects] of device;=?     async_output        : array [0..max_line_number] of device;;)     rec_region          : rec_region_ptr; )     xmt_region          : xmt_region_ptr; '     register_location   : register_ptr;="     async_ipl           : integer;-     controller_name     : varying_string (8);      receive_timer 	: byte;       { Register contents }_"     async_csr : csr;			{async csr}       { Line data structures }D     dht_struc : array [0..max_line_number] of terminal_data_pointer;     jparam   : builder_params;$     jp                                                                                                                                                                                                                                                     ^                        >P_ $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                              > "     /            : varying_string (100);       start_read : ^semaphore;2     put_lock: array [0..max_line_number] of mutex;       { Some misc. stuff }N     line_number : integer;            {current line number for initialization}P     sync_event  : event;              {event used to synchronize initialization}E     sub_process : process;	      {process ID used for line processes}o)     control_z_character : char := ''(26);e     bell : string(1) := ''(7);     line_ctrl_dummy   : lctrl;     stat : integer;   E     break_state : bit_array;  { Save the current line break states. } @     break_data  : array [0..max_line_number] of line_break_data; o     program dhtdriver; {++  { G { This is the main driver procedure.  It creates the device, resets thed< { async interface, and starts a process for each async line.B { These line processes will do the actual i/o.  This process waitsE { (via a signal) for each line process to complete its initialization A { before starting the next process.  Once all processes have beenfI { started and the exec has been informed that initialization is complete,	: { this procedure performs dispatching of input characters. {e {--} var      p_number     : integer;n     line_number  : integer;a     i            : integer;n     line         : integer;      my_proc      : process;      signaled_object : integer;     read_started : ^semaphore;     status: integer;7     rx_data : rxb_rtr;	{receive data and receive timer}r      int_mask : int_register_def;      read_int_reg  : vdc_sel_def;     request_timer   : event;  #     timeout_occurred: ^semaphore;        begin   /     eln$allocate_stack ( 2048 ); { four pages }    {_8 { Get the controller name specified by the job parameter {}.     controller_name := program_argument ( 1 );   {}H { Set the interrupt mask bits in the systems interrupt mask register to I { allow the DHT transmitters and receivers to interrupt the system         {}F     allocate_memory( int_mask_register, 512, physical := %x20080000 );-       read_int_reg::byte := 0;	{clear it out}e'       read_int_reg.rec_int_ena := true;t@       write_register( int_mask_register^.vdc_sel, read_int_reg);       int_mask := zero;              int_mask.VS := true;       int_mask.VF := true;=       write_register( int_mask_register^.int_clr, int_mask );	;       int_mask := read_register( int_mask_register^.mask );I       int_mask.VF := true;       int_mask.VS := true;9       write_register( int_mask_register^.mask, int_mask); *     free_memory( 512, int_mask_register );   {{ { Create the async device  {}$     create_device ( controller_name, 		    async_input,/ 		    vector_number     := input_vector_number,e*     		    region            := rec_region,)     		    priority          := async_ipl,  		    status	      := stat,	6     		    service_routine   := async_input_interrupt);  $     create_device ( controller_name, 		    async_output,i4     		    vector_number     := output_vector_number,& 		    region            := xmt_region, 		    status	      := stat,b8     		    service_routine   := async_output_interrupt );    0     { Get a pointer to the DHT32 CSR registers }@     ker$allocate_system_region( region_ptr := register_location, 				size       := 512, 				physical   := %x38000000 );s  M     { copy system pointer to CSR registers into input communications region }_-     rec_region^.csr_ptr := register_location;   N     { copy system pointer to CSR registers into output communications region }-     xmt_region^.csr_ptr := register_location;o     {{' { Set the default line characteristics.  {}  $     for i := 0 to max_line_number do( 	rec_region^.ddcmp_protocol[i] := false;  .     for line_number := 0 to max_line_number do$ 	set_default_params ( line_number );   { * { Check for user-specified line parameters {}     p_number := 2;(     jp := program_argument ( p_number );     while length(jp)<>0 do 	begin  	jparam := jp :: builder_params;' 	store_line_characteristics ( jparam );  	p_number := p_number + 1;% 	jp := program_argument ( p_number );x 	end;    {[" { Initialize the break state bits. {}     break_state::byte := 0;    {t" { Initialize the typeahead buffers {}$     for i := 0 to max_line_number do5 	tc$initialize_typhd_buffers(rec_region^.line_ctx[i],  				    default$tty_sync,a) 				    xmt_region^.line_char[i].passall,n* 				    xmt_region^.line_char[i].eightbit,+ 				    xmt_region^.line_char[i].passthru);1   {m/ { Synchronize with device during initializationaD { Note that now the interrupts are enabled after processing the lineC { characteristics.  Older versions of the driver enabled interruptsr1 { before the line charactersitics were processed.  {}$     disable_interrupt ( async_ipl );;     initialize_interface ( register_location, xmt_region );      enable_interrupt;)   {e" { Create the synchronization event {}/     create_event ( sync_event, event$cleared );F   {i$ { Create the read started semaphore. {}     new(read_started);*     create_semaphore(read_started^, 0, 1);   { M { Create the Put_chars write lock, and the dda terminal characteristics lock.d {}* for line_number := 0 to max_line_number do	     begin % 	create_mutex(put_lock[line_number]); F 	create_mutex ( dda_line_struc[line_number].dda_terminal_char_lock  );     end;   { $ { Create the request-for-timer event {}2     create_event ( request_timer, event$cleared );   {l { Create the timeout semaphore {}!     new(timeout_occurred); 						 2     create_semaphore(timeout_occurred^, 0, 1); 			   {Start the timing queues: }       start_queue ( timer_queue );%     start_queue ( timer_complete_q ); "     start_queue ( request_queue );  3 {Sync_lock controls access of the timing records: }A     create_mutex ( sync_lock );;  0 { Create the timing process, ONE for all lines }     clear_event ( sync_event );e!     create_process ( sub_process,  		     timer_process,p 		     sync_event, 		     timeout_occurred, 		     request_timer);       { Wait for completion }      wait_any ( sync_event );   {nI { Start a process to service DAP and DDA i/o requests for each async line, {}#     { For each line out there ... }p.     for line_number := 0 to max_line_number do 	begin 	clear_event ( sync_event );  1         { Create a process to service this line }t  "     	create_process ( sub_process,     			 line_process,a     			 line_number, 			 sync_event,_ 			 read_started,s 		         request_timer);   	{ Wait for completion } 	wait_any ( sync_event )
 	end; { for }o   	delete (sync_event );    N     { Set Receive Timer to immediate interrupt (on receipt of 1st character) }     receive_timer := 1;   C     { Select line 0 before setting the receive timer delay in the } (     { Receive Timer Register (rxb_rtr) }I     write_register ( register_location^.async_csr, ind_reg_address := 0);t  :     rx_data := read_register ( register_location^.rx_rt );,     rx_data.case1.r_time := receive_timer;  8     write_register ( register_location^.rx_rt, rx_data);  .     { Now Enable interrupts on the interface }F     write_register ( register_location^.async_csr, rx_int_ena := true, 						   tx_int_ena := true );   {89 { Signal the exec that we're done with our initialization1 {} 	initialization_done;:   {eO { Bump up the process priority of the dispatcher - note: this assumes a defaulteH { process priority of 8 for the line and circuit processes and that the I { process priority of the line and circuit processes will not be below 7.  {}     current_process(my_proc); 2     set_process_priority(my_proc,read_priority-1);   {} { Perform input dispatchinga {}     while true dot
         beginI  9 	wait_any ( async_input[eln$ddcmp_v2_term_device_number],  			read_started^,  		        timeout_occurred^,	; 			result := signaled_object );    	case signaled_object of 	1:  		{o 		{ Device signalled:   		{	Handle events for each line. 		{} 		 		begin , 		for line_number := 0 to max_line_number do 			process_event(_ 					line_number,o' 					rec_region^.line_ctx[line_number],h 					dht_struc[line_number],0 					xmt_region^.line_char[line_number].passall) 		end; 	2:  		{a 		{ Read posted:4 		{ 	A read has been started.  Check to see if there3 		{	is any characters in the buffers for this line.  		{}   		begin;, 		for line_number := 0 to max_line_number do" 			with dht_struc[line_number]^ do 			if read_started 			thena 			    begin  				tc$process_input_characters(' 					rec_region^.line_ctx[line_number],e 					dht_struc[line_number]); H 				if rec_region^.line_ctx[line_number].usr_ptr^.event_flags <> [] then
 				    begin , 					{ The buffers must have been swapped. }- 					{ The U                                                                                                                                                                                                                                                   _                        " $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                              q "     @       SR events have to be processed. }r 					process_event(c 						line_number,( 						rec_region^.line_ctx[line_number], 						dht_struc[line_number],d2 						xmt_region^.line_char[line_number].passall);! 					tc$process_input_characters( ( 						rec_region^.line_ctx[line_number], 						dht_struc[line_number]); 				    end; 				read_started := false 
 			    end 		end;   	3:  		{n1 		{ Timeout was signalled from the timer process:; 		{} 		begin{, 		    process_timeout_event (request_timer); 		end; {case = 3}r   	end; {Case}   	{; 	{	Now that we have processed each line that needed servicea: 	{	check to see if any I/O has completed for any lines. An; 	{	I/O completion is deferred until now so that all buffers_8 	{	that need swapping are processed as fast as possible. 	{}   + 	for line_number := 0 to max_line_number dog! 		with dht_struc[line_number]^ do ! 		if io_done AND read_in_progressg 		then 			beginF 		        Cancel_timer (line_timer_struc[line_number].io_tmo_started); 			signal( read_complete,_ 			        status := status);i 			io_done := false; 			read_in_progress := false;_ 			end;r 	end; { while }n   end.  . procedure process_event(line_number : integer;% 			var line_data: terminal_read_data;n' 			var terminal: terminal_data_pointer;_ 			passall: boolean);v   {++  {b# { process_event - Process ISR event  {s { Routine Description: {}; {	This procedure will process events signalled by the inputa {	ISR for each line. {l	 { Inputs:e { A {	line_number - Line number for which events are to be processed.;' {	line_data   - Line typeahead buffers._' {			(rec_region^.line_ctx[line_number]);( {	terminal    - Internal line data base.D {	passall	    - True if input characters should be processed without {		       intrepretation.  { 
 { Outputs:9 {	line_data   - Line typeahead buffers possibly modified.s( {	terminal    - Internal line data base. {o {--}   {o {	Local variable declarations. {}   var: 	stat: boolean;7 	status: integer;u' 	i: integer;		{ General purpose index }  	control_char	    : char;  	first_one	    : boolean;a 	next_element	    : integer; 	found_one 	    : boolean; 	disposition	    : byte;' 	remove_from_data    : boolean := true;i$ 	local_event_record  : event_record;! 	temp_ptr	    : typhd_buffer_ptr; ? 	done 	    	    : boolean := false;  { true if working on ISR }e: 			     { EVENTS and have finished processing USR EVENTS } 			     { if there were any. }   beginp   {i1 {	Determine what needs to be done based on eventse {	signalled by the isr.  e {} While not(done) do beginh  : { Process any events left in the USR EVENTS array first. }, if line_data.usr_ptr^.event_flags <> [] then	     begin}1 	{ Copy USR event information to local storage: }e. 	with local_event_record,line_data.USR_ptr^ do
 	    begin 		local_event := event_flags;  		event_flags := []; 	d+ 		local_nbr_cntrl_chars := nbr_cntrl_chars;h 		nbr_cntrl_chars := 0;; 	 ) 		local_cntrl_char_idx := cntrl_char_idx;i 		cntrl_char_idx := 0; 	    end; {with}     ende else	     begin_4 	{ Process any events left in the ISR EVENTS array }1 	{ Copy ISR event information to local storage: }o 	disable_interrupt(async_ipl);. 	with local_event_record,line_data.ISR_ptr^ do
 	    begin 		local_event := event_flags;m 		event_flags := [];  + 		local_nbr_cntrl_chars := nbr_cntrl_chars;t 		nbr_cntrl_chars := 0;   ) 		local_cntrl_char_idx := cntrl_char_idx;d 		cntrl_char_idx := 0; 	    end; {with} 	enable_interrupt; 	done := true;     end;   with local_event_record do begin   ( { See if there is an event to process: } if local_event <> [] thena begine  *     if evnt$input_xoff IN local_event then 	{/ 	{	If an XOFF event was received then handle it / 	{	ONLY if input flow control is handled by the=5 	{	driver.  This is because if the controller handlesr4 	{	input flow control then the controller would have1 	{	stopped sending output to the device (also the 2 	{	write_enable event and flag does not exist; see, 	{	the procedure TC$ALLOCATE_TERMINAL_DATA). 	{}( 	if terminal^.xon_xoff 	then{ 		with terminal^ dod 			begin 			clear_event(write_enable);r 			write_ena_flag^ := false; 			end;r  )     if evnt$input_xon IN local_event then  	{. 	{	If an XON event was received then handle it/ 	{	ONLY if input flow control is handled by the 5 	{	driver.  This is because if the controller handlesr4 	{	input flow control then the controller would have2 	{	resumed  sending output to the device (also the2 	{	write_enable event and flag does not exist; see, 	{	the procedure TC$ALLOCATE_TERMINAL_DATA). 	{}c 	if terminal^.xon_xoff 	thene 		with terminal^ doe 			begin 			write_ena_flag^ := true;} 			if overflow_pending theni	 				beginp# 				stat := put_chars(line,1,bell);  				overflow_pending := false; 				end; 			signal( write_enable);n 			end;R    +     if evnt$cncl_typahd IN local_event then  	begin( 	    { Clear the user typeahead buffer }! 	    line_data.usr_ptr^.put := 0;s1 	    { Clear a possible evnt$control_char event }e6 	    local_event := local_event - [evnt$control_char]; 	end;     ,     if evnt$control_char IN local_event then	     begine  o     if done then! 	{ We are processing ISR events }  	temp_ptr := line_data.ISR_ptr     else! 	{ We are processing USR events }  	temp_ptr := line_data.USR_ptr;l       with temp_ptr^ do_%     if local_nbr_cntrl_chars > 0 thent	     begin    	first_one := true;	{init}  # 	while local_nbr_cntrl_chars > 0 dom
 	    begin  	    	found_one := false; {init}  @  	        { Use local_cntrl_char_idx as the index of the first }& 	        {  control character found: } 	        if first_one then 		    begin 6 	    	    	control_char := data[local_cntrl_char_idx];B 		    	next_element := local_cntrl_char_idx; {NEXT_ELEMENT is the}? 			    { element following the control character just removed.}. 		    	first_one := false; 		    	found_one := true;]	 		    end 
 	        elsei@ 		    { Search the EVENTS array for the next control character }? 	    	    while ( (not found_one) AND (next_element < put) ) dot 			begin3 			    if ((events[next_element].error = false) ANDh@ 			   	(events[next_element].event_type = et$control_char)) then 		 	    	begin+ 				    { Found the next control character}  		    		    found_one := true;/ 			    	    control_char := data[next_element];  			        end 			    elsea	 				begin ) 				    next_element := next_element + 1;e 				end; 			end;r   	    	if found_one thenh, 	    	    { Process the control character: } 		    begin_A 		        { Bump any process waiting for the control character. }d2 		    	disposition := tc$check_oob_char( terminal, 						    line_data, 						    control_char);  ) 			{ Default to disposition = remove_it }u% 			remove_from_data := true;   {init}e   			if disposition = keep_it  			thenr 				remove_from_data := falset' 			else if not(disposition = remove_it)v 			thene" 				if terminal^.read_in_progress  				then 					remove_from_data := false) 				else if disposition = keep_if_no_read^ 				then 					remove_from_data := false;    			If remove_from_data then ' 			    { Remove the character from the} ( 			    {  the typeahead buffer and the } 			    {  events array:  	  		    {}r
 		    		begin G 		    		    { Remove the control character from the typeahead buffer: }l  " 		    		    { *** Device IPL *** }% 				    disable_interrupt(async_ipl); ' 			    		if next_element < (put-1) then,4 			    	    	    for i := next_element to (put-2) do 						beginr# 					    	    data[i] := data[i+1];v' 					    	    events[i] := events[i+1];e
 						end; 			    		put := put - 1;  			            enable_interrupt;" 		    		    { *** Normal IPL *** }) 				    next_element := next_element - 1;r  % 			        end; {if remove_from_data}e 		    end; {if found_one}l  # 		next_element := next_element + 1;c  4 	    	{ Decrement the count of control characters: }9 	    	local_nbr_cntrl_chars := local_nbr_cntrl_chars - 1;; 		+ 	    end; {while local_nbr_cntrl_chars > 0}e'     end; {if local_nbr_cntrl_chars > 0}n#     end; {if evnt$control_char IN }i    /     if evnt$buffer_overflow IN local_event then  	with terminal^ do
 	    begin/ 		{	If the terminal is not in passall mode thenl 		{	output the bell character. 		{} 	rB 		if not(passall OR line_data.passthru OR line_data.read_passthru) 		then 			{( 			{	If xon and xoff support (TTSYNC) is' 			{	required check to see if output isa 			{	disabled. 			{}i 			if terminal^.xon_xoff 			thene	 				begin. 				if not(write_ena_flag^)  				then 					overflow_pending := true  				else$ 					stat := put_chars(line,1,bell); 				end  			{+ 			{	If NO xon                                                                                                                                                                                                                                                   `                        ؆E $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "     Q        and xoff (TTSYNC) support isi( 			{	required just output the bell char. 			{}t 			else # 				stat := put_chars(line,1,bell);u  	 	    end;     ,     if evnt$io_completed IN local_event then3 	{ If this line has a read in progress then processr2 	{ the data.  Otherwise, a race condition ocurred. 	{}i 	if terminal^.read_in_progress 	thenl
 	    begin2 		tc$process_input_characters(line_data,terminal);. 		if line_data.usr_ptr^.event_flags <> [] then 		    beginh2 			{ USR events were cleared at the beginning of }( 			{ this routine, so if after calling }4 			{ tc$process_input_characters here it is NOT [] }/ 			{ then the buffers must have been swapped. }c- 			{ The read was not completed yet because }s5 			{ first the new USR events have to be processed. }  			process_event(e 				line_number, 				line_data,
 				terminal,e
 				passall);_4 			tc$process_input_characters(line_data, terminal);
 		    end;	 	    end;r       {x=     {  The DHT-32 driver does not recognize any other events.      {}
 end; {End if}A' { Clear out the local event variable: }t local_event := []; end; {with}e   end; { while not() } end;    9 procedure process_timeout_event	(request_timer : event );t   {++t {[ { process_timeout_event  {s { Routine Description: {g; {	This procedure will process all timeout events signalled t {	for all lines. {	 {t {--} var_     stat	: boolean;c     status	: integer;n     line_number : integer;     i		: integer;	@     ptr 	: ^queue_entry;  { pointer to timer_complete_q entries}:     entry_ptr	: ^queue_record; { pointer to queue records}#     done_process_timeout : boolean;i     empty	: boolean;4     lkahd_flag	: boolean := true; { lookahead flag }   begine  "     done_process_timeout := false;  2     {Process each element of the timer_complete_q}%     while not done_process_timeout do	 	begin		    G     	    lock_mutex (sync_lock);  {make sure no one accesses the queue}a$ 	    ptr := timer_complete_q.flink; ? 	    if ptr = address(timer_complete_q) then  {no more entries}n 		begin=* 	            done_process_timeout := true;&     	    	    unlock_mutex (sync_lock) 		end{/ 	    else    {there is at least one more entry}n 	        begin  3 	    	{Remove the entry from the head of the queue}{% 	    	remove_entry (timer_complete_q,s& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);   		{ See if it is still valid }# 		if entry_ptr^.ignore_timeout thenh 		    begin 5 	    		dispose (entry_ptr);  {get rid of queue entry}o&     		    	unlock_mutex (sync_lock);  	 		    end  	        else  u 		    begino3 			{ Determine what needs to be done based on the }r  			{  timeout event signalled: } 			CASE entry_ptr^.evnt of   			EVNT$NOEVNT:	 			    begin) 	    			{ There is no event to process. }r 				dispose (entry_ptr);- 	    	    	        unlock_mutex (sync_lock)    			    end;  	n 			EVNT$BREAK_DURATION:t 			    begin2 				{ Break duration timer has expired, so clear }% 				{ the break state on the line.  }s0 				{ Delete the pointer to the timing record: }D 				line_timer_struc[entry_ptr^.line].break_duration_started := nil;&     	    			unlock_mutex (sync_lock); ) 				dda$_clear_break ( entry_ptr^.line,			 						   register_location );r6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;  	p 			EVNT$BREAK_DELAY: 			    begin, 				{ Break delay timer is expired, so set }$ 				{ the break state on the line. }0 				{ Delete the pointer to the timing record: }A 				line_timer_struc[entry_ptr^.line].break_delay_started := nil; &     	    			unlock_mutex (sync_lock); ' 				dda$_set_break ( entry_ptr^.line,		  						 register_location ); 0 			        add_timer_request ( entry_ptr^.line, * 					break_data[entry_ptr^.line].duration, 			    		evnt$break_duration,t? 					line_timer_struc[entry_ptr^.line].break_duration_started, { 				        request_timer);	6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;f   			EVNT$IO_TMO:  			    begin 				{I/O timeout has expired}d0 				{ Delete the pointer to the timing record: }< 				line_timer_struc[entry_ptr^.line].io_tmo_started := nil;&     	    			unlock_mutex (sync_lock); ' 				with dht_struc[entry_ptr^.line]^ do  				if read_in_progress then
 				    beginl& 					{ See if any characters came in }" 					{ during the timeout period }! 					tc$process_input_characters(n, 						rec_region^.line_ctx[entry_ptr^.line],! 						dht_struc[entry_ptr^.line],r 						lkahd_flag);3 					if not io_done then io_status := eln$_timeout;x 					io_done := false; 					read_in_progress := false;P 					read_w_term_mask := false; B 					rec_region^.line_ctx[entry_ptr^.line].isr_ptr^.event_flags :=W 						rec_region^.line_ctx[entry_ptr^.line].isr_ptr^.event_flags - [evnt$io_completed];n1 					signal(read_complete,status := status);					[ 				    end;6 	    			dispose (entry_ptr);  {get rid of queue entry} 			    end;o   			OTHERWISE 			    begin 		            	{( 		            	{ Process other timeouts. 		            	{}=&     	    			unlock_mutex (sync_lock);  	    			dispose (entry_ptr);   		            end; 		        END; {case}<* 		    end; {if entry_ptr^.ignore_timeout }  0 	    end; { if ptr = address(timer_complete_q) }.         end; {while not done_process_timeout }   end;  {procedure}h   {: procedure initialize_interface ( registers : register_ptr;" 				 region    : xmt_region_ptr );   {++a { H { This procedure will perform interface initialization either at startup { or after a powerfail.s { 	 { Inputs:e {e1 {	registers points to the DHT-32 device registerso< {	region points to the transmit device communications region {i
 { Outputs: {	 {	async interface initializede {r { 5 { Note: This procedure should be called at device IPLn {N {--} varr 	dummy	:	rxb_rtr;  	i	:	integer;    	 begino  !     { Reset the async interface } 0 	async_csr:=read_register(registers^.async_csr);# 	if not async_csr.master_reset theno& 		write_register(registers^.async_csr, 				master_reset:=true);*     { Wait until the reset has completed }  
     repeat9     	async_csr := read_register ( registers^.async_csr );_%     until not async_csr.master_reset;b  4     {	Check if diagnostics failed.  If not ignore 	}'     {	8 characters in input buffer.			}r 	i     if async_csr.diag_fail theng 	begin 	    enable_interrupt;	 	    exitl 	end;	       for i:= 1 to 8 don 	begin, 	    dummy:= read_register(registers^.rx_rt) 	end;    end;     r0 procedure set_default_params ( line : integer ); {++p {iJ { This procedure will set the line characteristics for LINE to the default { values {e {--}   beginf  '     with xmt_region^.line_char[line] do  	begin& 	char_length   := default$char_length;$ 	stop_bits     := default$stop_bits;( 	parity_enable := default$parity_enable;  	sense         := default$sense;$ 	rx_baud_rate  := default$baud_rate;$ 	tx_baud_rate  := default$baud_rate;  	modem         := default$modem;# 	hardcopy      := default$hardcopy;l& 	ANSI_escape   := default$ANSI_escape; 	echo          := default$echo; " 	passall       := default$passall;# 	eightbit      := default$eightbit;o0         ddcmp_protocol:= default$ddcmp_protocol;# 	passthru      := default$passthru;  	end;[  )     xmt_region^.line_valid[line] := true;=   end; l    A procedure store_line_characteristics ( jparam : builder_params );l {++a {rJ { This procedure is used to store user-specified line characteristics into5 { the parameter record of the data base for this linea {o {--}   beginr  /      with xmt_region^.line_char[jparam.line] doN        begin  G     	{ Set the characteristics for this line - note: for now, you can'tNG 	  set the character length and # of stop bits via the system builder }	0           parity_enable := jparam.parity_enable;(           sense         := jparam.sense; 	  {5 	  { Match up ebuild speed values with driver values d3 	  {    If not a valid speed then keep the default.e 	  {}eI 	  If rate_array[jparam.comm_speed::dda$_terminal_speed_types].valid thens 	      beginQ 		rx_baud_rate := rate_array[jparam.comm_speed::dda$_terminal_speed_types].value;aV 	      	tx_baud_rate := rate_array[jparam.comm_speed::dda$_terminal_speed_types].value 	      end;o+           hardcopy      := jparam.hardcopy;o.           ANSI_escape   := jparam.ANSI_escape;'           echo          := jparam.echo;r*           passall       := jparam.passall;,           passthru      := jparam.passthru;   -           if jparam.character_length = 3 thenm                eightbit := truei           else!                eightbit := false;m  C 	{ Set the modem flag and if line is a modem, clear the valid bit }v(                                                                                                                                                                                                                                                        a                        R`& $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                              X "     b             modem         := jparam.modem;           if modem then} 	     beginv<                xmt_region^.line_valid[jparam.line] := false;K 	       dda_line_struc[jparam.line].modem_state := dda$_modem_disconnected;eC                     if rec_region^.ddcmp_protocol[jparam.line] thene 			begin# 			    eln$ddcmp_v2_halt_protocol (r7 				address ( rec_region^.ddcmp_region[jparam.line]) );	 			end;i  
 	     end;  1           ddcmp_protocol:= jparam.ddcmp_protocol;n            if ddcmp_protocol then             beginn$                ANSI_escape := false;$                echo        := false;#                passall     := true;e#                eightbit    := true;d?                rec_region^.ddcmp_protocol[jparam.line] := true;n             end;
        end   end;      8 procedure initialize_line ( line              : integer;( 			    line_parameters   : ln_param_rec;* 			    register_location : register_ptr ); {  {;K { This procedure will write the line parameters for this line to the propertM { line parameters register and enable the line for transmitting and receivinge {e	 { Inputs:p {t" {	line number specifies which line< {	line_parameters contains the characteristics for this line8 {	register_location points to the DHT32 device registers {r
 { Outputs: {o {	line initialized {{1 { Note: This routine assumes device IPL or highere {  {--} var      temp_oauto : boolean;    beginn       with line_parameters do  	begin           { Set line parameters }eH 	write_register ( register_location^.async_csr, ind_reg_address:=line );  F 	{ Clear xreport so that xon/xoff's are reported in the fifo even if }( 	{ ttsync is true (to be like the DHV) }7         write_register ( register_location^.line_param,a 				xreport		:= false,* 			        char_length     := char_length,, 			        parity_enable   := parity_enable,$ 			        even_odd_parity := sense,( 			        stop_code       := stop_bits,+ 			        rx_baud_rate    := rx_baud_rate, - 			        tx_baud_rate    := tx_baud_rate );d       @ 	{ Set oauto according to (not(passall) and tty_sync), but set }* 	{ iauto just according to not(passall). }   	if not(default$tty_sync)h 	thenn5 		temp_oauto := ( not(passall) AND default$tty_sync )s 	else	 		temp_oauto := not(passall);e  *         { Enable this line for receiving }9         write_register ( register_location^.line_control,_          			rx_en        := true,! 				dtr	     := false, {drop dtr} ! 				rts	     := false, {drop rts}37 			        oauto        := temp_oauto,  {initial value}n0 				iauto        := not passall, {initial value} 	    			fxoff	     := false, 				link_type    := modem );   	end; {with}        with dda_line_struc[line] do 	begin1     	    host_sync 	  := false; { Unimplemented } 4     	    modem_control := dda$_modem_control_driver;2     	    modem_state   := dda$_modem_disconnected; 	end;   ,     if rec_region^.ddcmp_protocol[line] then 	begin! 	    eln$ddcmp_v2_halt_protocol (;/ 			address ( rec_region^.ddcmp_region[line]) );  	end;   "     with line_timer_struc[line] do 	begin# 	    break_duration_started := nil;o$ 	    break_delay_started    := nil; # 	    io_tmo_started         := nil;_ 	end;b   end; r  J interrupt_service async_input_interrupt ( dummy_in_ptr     : register_ptr;+ 					  inp              : rec_region_ptr );} {++  {lD { Async_input_interrupt : async line input interrupt service routine {o< { This is the input interrupt service routine for the DHT-32@ { It reads characters from the input silo and puts them into theJ { input buffer which is located in the input device record region.  If theM { input buffer state changes from empty to non-empty, the device is signaled.  { 8 {  Inputs :	inp - pointer to input communications region1 {		dummy_in_ptr - dummy ptr of type register_ptr.e {  Outputs :	none  {  {--}   const:
     xon = 17;      xoff = 19;   varuG     device_registers : register_ptr; { system pointer to device reg's }t&     rx_data: rxb_rtr;	{receive buffer}      character: char;	{character}T     bump_device: boolean := FALSE;	{used to determine if device should be signalled}=     error: integer := -1;		{error type - es$break_detected, }i+ 					{ es$framing_error, es$parity_error, }e      					{ or es$overrun_error }   begin   7 { Get pointer to CSR registers from input comm region }y! device_registers := inp^.csr_ptr;u   {s { Read the input register  {}5 rx_data := read_register ( device_registers^.rx_rt );a   {tC { As long as there is input in the silo, put it in the input buffer  {}! while rx_data.case0.data_valid dor	     begin	   	{ Ignore diagnostics }r) 	if not ( (rx_data.case0.frame_error) AND $ 		 (rx_data.case0.overrun_error) AND& 		 (rx_data.case0.parity_error) ) then  : 	if not inp^.ddcmp_protocol [ rx_data.case0.rx_line ] then
 	    begin 		{u 		{	Handle the input character.N 		{}. 		with inp^.line_ctx[rx_data.case0.rx_line] do# 		    if isr_ptr^.put > length then  			begin 			    {+ 			    { The input buffer is full.  If the r1 			    { character is XON or XOFF and we are NOT e4 			    { in passall mode then inform the dispatcher 7 			    { that a XON or XOFF was found. Otherwise, bump r/ 			    { the dispatcher with a buffer overflow t 			    { condition. / 			    { Ignore all errors when buffer is full. 	 			    {}a. 			    if not ( (rx_data.case0.frame_error) OR0 		       		     (rx_data.case0.overrun_error) OR/ 		       		     (rx_data.case0.parity_error) ) d 			    thenr 			    if ( (tt_sync) and - 				( (ord(rx_data.case0.rx_char) = xon) or  p1 				  (ord(rx_data.case0.rx_char) = xoff) ) and  r 				  (not passall) )r 			    then.	 				begino- 					if ord(rx_data.case0.rx_char) = xon thenc 					    beginF 						isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xon];G 						isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xoff];u 					    end	 					elses 					    beginG 						isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$input_xoff];_F 						isr_ptr^.event_flags := isr_ptr^.event_flags - [evnt$input_xon];
 					    end;  					bump_device := true 				endn 			    elsef	 				begin	- 				    	{ If the line is NOT in PASSALL model+ 				        { then signal a buffer overflow . 				        { condition. In any event remember0 				        { that an overrun condition occured. 				        {} 					if ( (not passall) AND  					     (not passthru) AND 					     (not read_passthru) ) 	 					then  					    beginS 					        isr_ptr^.event_flags := isr_ptr^.event_flags + [evnt$buffer_overflow];	  					        bump_device := true
 					    end;l& 				        isr_ptr^.overflow := true; 				end;
 			    end 			elseN 			    begin 				{;. 				{ If the data has an error (parity, frame,) 				{  overrun, or break) then handle it   				{}' 			        if rx_data.case0.frame_error  				then
 				    begind& 					if rx_data.case0.rx_char = chr(0)	 					then;# 					    error := es$break_detected 
 					else $ 					    error := es$framing_error;	 				    endi	 				else	t. 		       		    if rx_data.case0.overrun_error  				    then! 					{ NOTE:  DHT places a NULL }e$ 					{  character in the fifo when } 					{  an overrun occurs }i 					error := es$overrun_error 		       		    else # 					if rx_data.case0.parity_error l	 					then " 					    error := es$parity_error; 		 				if error <> -1 g 				then
 				    begin 2 				        { Record the error and terminate the } 				        {  current read: }  				        tc$read_error(error,, 						inp^.line_ctx[rx_data.case0.rx_line],  						rx_data.case0.rx_char, 						bump_device);c) 					error := -1;	{undefined error value}  				    end  				else! 				    { The character is good }n 				    if passall then C 		        	        tc$insert(inp^.line_ctx[rx_data.case0.rx_line], s 					    rx_data.case0.rx_char,f 					    bump_device)e 				    else" 				        tc$dispatch_character(/ 					    inp^.line_ctx[rx_data.case0.rx_line], y 					    rx_data.case0.rx_char,) 					    bump_device);' 			    end;  {if isr_ptr^.put > length}n	 	    end +% 	else   {if not inp^.ddcmp_protocol }i
 	    begin& 	        if eln$ddcmp_v2_receive_isr (; 			address ( inp^.ddcmp_region [ rx_data.case0.rx_line ] ),d 			rx_data.case0.rx_char )
 	        thenl 		    { Signal line+1 now. }D 		    signal_device ( device_number := (rx_data.case0.rx_line + 1));	 	    end;l  I     { Now read input register again to see if more characters are there }d9     rx_data := read_register ( device_registers^.rx_rt );    end; { while }   if bump_device thena     signal_device(3 	device_number := eln$ddcmp_v2_term_device_number);a   end; ;    K interrupt_service async_output_i                                                                                                                                                                                                                                                   b                        "% $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                              h "     s       nterrupt ( dummy_out_ptr    : register_ptr;o, 					   xregion          : xmt_region_ptr ); {++[ { F { Async_output_interrupt : async line output interrupt service routine {_= { This is the output interrupt service routine for the DHT-32 B { It reads the CSR to determine which line interrupted and signals { the appropriate device.d { @ {  Inputs :    xregion - pointer to output communications region8 {	       dummy_out_ptr - dummy ptr of type register_ptr. {t {  Outputs :   nonef {t {--} varnG     device_registers : register_ptr; { system pointer to device reg's }v:     async_csr        : csr;      {control status register}N     this_line        : integer;  {line number on which interrupt was received}!     done	     : boolean := false;s   begin   7 { Get pointer to CSR registers from input comm region }I% device_registers := xregion^.csr_ptr;r   {_ { Read the CSR! { Loop until tx_ready is false.  a {}   while not done doo	     begind< 	async_csr := read_register ( device_registers^.async_csr ); 	if async_csr.tx_ready then$
 	    beginO         	this_line := async_csr.tx_line;  { The line that sent the interrupt -} ( 				 	  	 { This line's FIFO is empty. } 		{  		{ Signal the interrupt a 		{}/ 		signal_device ( device_number := this_line );  	    end 	else  	    done := true;     end;   end; j  I function line_valid of type check_line_valid;	{ (line_number : integer )}  begin   6     line_valid := xmt_region^.line_valid[line_number];   end;   s- function put_chars of type output_characters;e" 	 { ( line_number       : integer;" 	     number_of_chars   : integer;@ 	     var output_buffer : string(number_of_chars) ) : boolean; } {++i {s3 { This function outputs characters to an async linet {e	 { Inputs:  {  {	line number specifies line) {	number_of_chars specifies buffer lengthe. {	output_buffer points to buffer of characters {i
 { Outputs: {n% {	characters output on specified linen= {	function returns false if line goes invalid, true otherwise  {--}   varp     output_character : char;E     tx_fifo          : tdat_tsiz; { Transmit FIFO size register and } ! 				  {    Transmit Data Buffer }:<     full             : boolean;   { true = tx fifo is full }C     count            : integer;   { number of chars output so far } H     done             : boolean;   { true = done transmitting all chars }     max_output,loop  : integer;s  6 [inline] function minimum ( a,b : integer ) : integer; begin      if a <= b then
 	minimum := ah     else
 	minimum := bs end;   begino    L     { Allow only one copy of this routine to execute per line at one time. }L     { This allows both the driver and the line processes to be performing  }L     { write operations at the same time.                                   }  &     lock_mutex(put_lock[line_number]);  6     count := 0;		{ haven't transmitted any chars yet }     done  := false;   (     { See if the tx fifo has some room }.     { full = true indicates fifo has no room }'     full := check_fifo ( line_number );e  2     { Loop until all characters have been output }
     repeat  <         { If the fifo is full, wait for it to become empty }         if full then3             wait_any ( async_output[line_number] );r  K         { Now pump characters into the fifo until it's full or we're done }g  $         { Raise IPL to synchronize }(         disable_interrupt ( async_ipl );  O         { Write our line number into the CSR as the indirect register address }a6         write_register ( register_location^.async_csr, 				rx_int_ena := true,  				tx_int_ena := true,g% 				ind_reg_address := line_number );t  < 	{ Get the fifo count and compute max characters to output }` 	tx_fifo.tx_size.fifo_size := read_register ( register_location^.trans_fifo.tx_size.fifo_size );  5 	max_output := minimum ( (tx_fifo.tx_size.fifo_size),i 				(number_of_chars-count) );  D 	{ Since the DHT can output 2 chars at a time, if the count is odd }F 	{ then output the odd character, and thereafter output 2 at a time. } 	if odd(max_output) then
 	    begin 	        count := count + 1;B 	        write_register ( register_location^.trans_fifo.tx_byte1, $ 				substr(output_buffer,count,1) );    	    end;  &         { Loop outputting characters }.         for loop := 1 to (max_output div 2) do             beginr3                 { Output two characters at a time }eA 	        write_register ( register_location^.trans_fifo.tx_word, p5 			substr(output_buffer,count+1,2)::packed_word.wd );o 	        count := count + 2;	 	    end;g           { More to output? }i+         done := (count >= number_of_chars);e           { Restore IPL }o         enable_interrupt;   ;         { If we aren't done, the fifo must have been full };         full := true;c       until done;r  -     { Wait for the transmitting to complete }p  +     wait_any ( async_output[line_number] );   E     { Let any other current copy of this routine be eligible to run }   (     unlock_mutex(put_lock[line_number]);  J     { Check for line valid to return status.  True is returned only if theD       line is up.  If not, wait to see if it comes back (checking inF       midstream).  Caller of this routine can then check line_valid to5       determine which dap status to return to user. }t       put_chars := true;3     if not xmt_region^.line_valid[line_number] thenO 	begin 	put_chars := false;$ 	wait_any ( time := modem_timeout );0 	if not xmt_region^.line_valid[line_number] then( 	    wait_any ( time := modem_timeout ); 	end;r   end;       e8 function check_fifo ( line_number : integer ) : boolean; {++: {AH { This function will check the tx fifo for the specified line and return2 { true if the fifo is full, or false if it is not. {$ {--} varo9     tx_fifo : tdat_tsiz;  { Transmit fifo size register }    begin        { Synchronize with device } $     disable_interrupt ( async_ipl );  G     { Write line number into the CSR as the indirect register address }e2     write_register ( register_location^.async_csr, 			     rx_int_ena := true,l 			     tx_int_ena := true, ) 			     ind_reg_address := line_number );        { Check the fifo }c     tx_fifo.tx_size.fifo_size := read_register ( register_location^.trans_fifo.tx_size.fifo_size );d       { Restore IPL }      enable_interrupt;d       { Was it full? }P     check_fifo := (tx_fifo.tx_size.fifo_size = 0); { 0 indicates no free space }   end; i  9 process_block circuit_process ( circuit_struc : ct_ptr );g   {++  {	I { Circuit process : This process is started to service an i/o request fora { the specified line.n {eI { Inputs : circuit_struc - a structure containing information peculiar tot { this circuit {a { Outputs :	none {u {--}   var{3     read_buff               : terminal_read_buffer;n(     saved_record_attributes : dap$b_rat;@     saved_record_format: dap$b_rfm;		{ Record format from open }I     saved_fixed_control_size: dap$b_fsz;	{ Fixed control size from open } &     this_line               : integer;&     context                 : integer;&     status                  : integer;-     circuit_flags           : terminal_flags;  n  - function open_action of type dap$open_action;e {++  {	$ {  Open_action - open action routine {cI {	This routine is called by the dap$server routine when the user process t {	executes an open statement.e {f
 {  Inputs: {^ {	create			- create/open flag]" {	file_access 		- file access mode {	share 			- share accesse$ {	organization 		- file organization! {	record_format 		- record formate( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options	( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics* {	file_specification 	- file specification) {	fixed_control_size	- fixed control sizeo0 {	context 		- driver specific parameter (unused) { 	  {  Outputs:n {p$ {	organization 		- file organization! {	record_format 		- record formatn( {	record_attributes 	- record attributes, {	maximum_record_size 	- maximum record size {	file_options 		- file options ( {	device_char	 	- device characteristics: {	device_dependent_char	- device dependent characteristics {	 {	return value = success {e {--}   beginr  (     { Save specified record attributes }1     saved_record_attributes := record_attributes;o)     saved_record_format := record_format;t3     saved_fixed_control_size := fixed_control_size;:  0     { Set max record size and read buffer size }#     if (maximum_record_size = 0) or	- 	(maximum_record_size > max_read_buffer_size)_     then- 	maximum_record_size := max_read_buffer_size;   ;     circuit_struc^                                                                                                                                                                                                                                                   c                        T $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                              a "            .read_buffer_size := maximum_record_size;   )     { Set some other various parameters }	     organization := dap$k_seq;!     {record_format := dap$k_var;}      file_options := [];oL     device_char := [ dap$v_devrec, dap$v_devccl, dap$v_devtrm, dap$v_devidv, 		     dap$v_devodv ];       { Set up the flags record }}  ?     {*********************************************************}e?     {*** All user-written drivers must use the new definition }      {*** of terminal_flags!!! }r?     {*********************************************************}        with circuit_flags do  	begin0 	    if circuit_struc^.read_buffer_size = 1 then 		begins0 		    { Special case for a read passthru state } 		    echo := false; 		    edit_mode_read := false; 		end		 	    else. 		beginr+ 		    { Take value from default data base }s4 		    echo := xmt_region^.line_char[this_line].echo;  5 		    { The edit mode flag TRUE indicates that data }^3 		    { should be checked for editting functions: }_ 		    edit_mode_read := NOT ( . 			xmt_region^.line_char[this_line].passall OR/ 			xmt_region^.line_char[this_line].passthru );  		end;  < 	    hardcopy  := xmt_region^.line_char[this_line].hardcopy;J     	    escape_recognize := xmt_region^.line_char[this_line].ANSI_escape; 	end;o       { Success !!}r      open_action := dap$k_success   end; e  + function get_action of type dap$get_action;_ {++  {e" {  Get_action - get action routine {:I {	This routine is called by the dap$server routine when the user process n- {	executes a get (read/readln/etc) statement.r {r
 {  Inputs: {g4 {	record_access		- type of access to be used in get 1 {	record_number		- number of record to read (lbn)e4 {	record_options		- record options to be used in get. {	buffer			- address of buffer to receive data3 {	buffer_length		- length of buffer to receive datar0 {	get_buffer		- routine to get new larger buffer0 {	context 		- driver specific parameter (unused) { 	t {  Outputs:p {o. {	buffer_length		- length of actual datum read {	return value = success {g {--} varg     i, read_length: integer;     read_status: boolean;_     count: integer;      eof: boolean;g     tmp_buff: ^anytype;   / function get_handler of type exception_handler;r {++e" {  get_handler - Exception handler { 
 {  Inputs: {e) {	Standard exception condition arguments.r {--} begini     get_handler := true;#     get_action := signal_args.name;p     goto return; end;   begin      establish(get_handler);i  #     { If the line is up, continue }e  (     if xmt_region^.line_valid[this_line]     then   	begin 	{C 	{ If the record access is keyed and the record number is non-zero,tA 	{ then the record number represents a mask of control charactersn 	{ that are to be awaited. 	{}l  G         if ( record_access = dap$k_key_acc ) and ( record_number <> 0 )u 	then              begin              count := 1;pE             read_buff[1] := tc$await_ctrl_key ( dht_struc[this_line],l. 				    	     rec_region^.line_ctx[this_line],( 					     record_number :: ctrl_key_set, 					     circuit_struc^.port);              eof := false;b 	    read_status := true;              endf         else
 	    begin             { Normal read } I 	    { Set up the flags record for this read with line data base values.}	H 	    { This makes certain that if the line values were changed through }I 	    { DDA SET_CHARACTERISTICS then the new READ will pick up these new }eA 	    { values, but READs that are already in progress will keep } B 	    { whatever values of ECHO, HARDCOPY, and ESCAPE RECOGNITION }( 	    { that they are currently using.  }  @ 	    {*********************************************************}@ 	    {*** All user-written drivers must use the new definition }  	    {*** of terminal_flags!!! }@ 	    {*********************************************************}   	    with circuit_flags do 		begin 1 		    if circuit_struc^.read_buffer_size = 1 theno 			begin1 			    { Special case for a read passthru state }  			    echo := false;  			    edit_mode_read := false;e 			end
 		    else 			begin, 			    { Take value from default data base }5 			    echo := xmt_region^.line_char[this_line].echo;i 	p6 			    { The edit mode flag TRUE indicates that data }4 			    { should be checked for editting functions: } 			    edit_mode_read := NOT ( e/ 				xmt_region^.line_char[this_line].passall ORy0 				xmt_region^.line_char[this_line].passthru ); 			end;i  = 		    hardcopy  := xmt_region^.line_char[this_line].hardcopy;}G 		    escape_recognize := xmt_region^.line_char[this_line].ANSI_escape;t 		end;  O                 read_status := tc$read_chars ( rec_region^.line_ctx[this_line],e 					dht_struc[this_line], 					read_buff,t, 				        circuit_struc^.read_buffer_size, 					count,c 					circuit_flags,f	 					eof,s 					put_chars,n 					line_valid );	 	    end;s   	{ 	{ If success, return the data3 	{ For VFC files, place a control field on the datan 	{}e   	if read_statust 	thene
 	    begin  ' 	    if saved_record_format = dap$k_vfcn	 	    then,1 		read_length := count + saved_fixed_control_sizeg	 	    elsee 		read_length := count;)  C 	    { Check the buffer for overflow. If so, allocate new buffer. }_  # 	    if read_length > buffer_length 	 	    thenl$ 		buffer := get_buffer(read_length);  D 	    { Copy the input to the supplied buffer and return the length }  ' 	    if saved_record_format = dap$k_vfcn	 	    thenh 		begint+ 		for i := 1 to saved_fixed_control_size doe1 		    buffer^::terminal_read_buffer[i] := chr(0);}B 		tmp_buff::integer := buffer::integer + saved_fixed_control_size; 		end 	 	    elseg 		tmp_buff := buffer;o  ; 	    tmp_buff^::string(count) := substr(read_buff,1,count);   " 	    buffer_length := read_length;   	    { Set the return status }   	    if eofu	 	    then  		begin  		get_action := dap$k_eof; 		eof := false 		endr	 	    else  		get_action := dap$k_successe 	    end   	elsea* 	    get_action := dap$k_device_not_ready; 	end       else& 	get_action := dap$k_device_not_ready; 	  return:g     revert;  end; u  + function put_action of type dap$put_action;h {++  { " {  Put_action - put action routine {eI {	This routine is called by the dap$server routine when the user process ;/ {	executes a put (write/writeln/etc) statement.  { 
 {  Inputs: {a3 {	record_access		- type of access to be used in putu2 {	record_number		- number of record to write (lbn)4 {	record_options		- record options to be used in put. {	buffer			- address of buffer containing data4 {	buffer_length		- length of data in buffer to write0 {	context 		- driver specific parameter (unused) { 	m {  Outputs:k {  {	return value = success {  {--} vart     start           : integer;     i               : integer;     number_of_chars : integer;     first_char      : char;t     write_status    : boolean;   beginO  B     write_status := tc$write_chars ( dht_struc[this_line], buffer,, 			  buffer_length, saved_record_attributes, 			  put_chars );        if write_status then 	put_action := dap$k_success     else& 	put_action := dap$k_device_not_ready;   end;  5 function truncate_action of type dap$truncate_action;d {++  { , {  Truncate_action - truncate action routine {tH {	This routine is called by the dap$server routine when the user process  {	executes a truncate statement. {n
 {  Inputs: { 8 {	record_access		- type of access to be used in truncate { 	m {  Outputs:C {a {	return value = success {s {--} varr     stat : boolean;e   beginn  -     if xmt_region^.line_valid[this_line] then    	begin9         if ( (xmt_region^.line_char[this_line].echo) AND  . 	     (circuit_struc^.read_buffer_size <> 1) ) 	then=             beging>             stat := tc$write_newline ( this_line, put_chars );6             {dht_struc[this_line].lf_needed := false;}4             {dht_struc[this_line].lf_output := true}             end;(         truncate_action := dap$k_success 	end     else+ 	truncate_action := dap$k_device_not_ready;c   end;   {++s {o { Circuit process code {a {--}   begino  0     eln$allocate_stack ( 4096 ); { eight pages }   {-- { Save the line number in an accessible placet {}%     this_line := circuit_struc^.line;    {  { Let DAP do itb {}A     status := dap$server (circuit_port    := circuit_struc^.port, $ 			  open_action     := open_action,# 			  get_action      := get_action,n# 			  put_action      := put_action,$) 			  truncate_action := truncate_action);    {s! { Get rid of what we're not using  {}#     delete ( circuit_struc^.port );t     dispose ( circuit_struc );   END; i  , process_block line_process ( line : integer;                                                                                                                                                                                                                                                    d                        <
 $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "            			     evt  : event;e" 			     read_started : ^semaphore;  			     request_timer : event ); {++h {r, { Line_process : async process for each line {h7 { This procedure is started as a process for each line.I@ { Once the line has been properly initialized, it then waits forM { DAP and DDA connect requests and starts a circiut process for each request.  {e {--} var :     my_port          : port;            {line unique port}C     port_name        : varying_string (32); {the name of this line}l.     process_name     : name;	        {name ID}M     circuit_db       : ct_ptr;	        {pointer to circuit data base struct.}iJ     sub_process      : process;	        {process ID for circuit processes}:     dda_port         : port;            {line unique port}Q     dda_port_name    : varying_string (32); {the name of this line - TTAx$ACCESS}n.     dda_process_name : name;	        {name ID}N     dda_sub_process  : process;	        {process ID for DDA circuit processes}     status	     : integer;     signalled_object : integer;	  + function handler of type exception_handler;n begin=     handler := true;     goto LINE_RETURN;e end;   begint       establish(handler);d  .     eln$allocate_stack ( 1024 ); { two pages }  F     { Create two ports and two universally known names for this line }  8     create_port ( my_port );	{Create a DAP message port}9     create_port ( dda_port );	{Create a DDA message port}z  <     port_name := controller_name + chr ( line + ord('0') ) ;,     dda_port_name  := port_name + '$ACCESS';       create_name ( process_name,e                   port_name,                   my_port );  &     create_name ( dda_process_name,   &                   dda_port_name,                         dda_port );v  (     { Allocate the line data structure }  B     { Pass handle_xon_xoff to the xon_xoff field of the terminal }A     { data record.  This value will NOT be modified.  It merely }*@     { indicates whether the DRIVER is responsible for handling }     { received XON/XOFF } 0     tc$allocate_terminal_data ( dht_struc[line],%                                 line,s0                                 handle_xon_xoff, 			        read_started );  <     { Initialize the line and signal the job when complete }     initialize_line ( line,a2                       xmt_region^.line_char[line],*                       register_location );  6     if xmt_region^.line_char[line].ddcmp_protocol then 	{D 	{ NOTE: The device object associated with DDCMP line X is ( X+1 ).  	{}fK 	eln$ddcmp_v2_initialize_line ( address ( rec_region^.ddcmp_region[line] ),i'                                   line,t,                                   async_ipl,8                                   async_input[line + 1],,                                   my_port );     signal ( evt );        { F     { Create port to be used for the DAP circuit and wait for connect K     { request.  Upon receipt of request, start up a process to service it. n     {}       while true doi 	begin. 	    { Wait for a DAP or DDA connect request } 	    wait_any( my_port,  		      dda_port,e$ 		      result := signalled_object,  		      status := status );s   	    if signalled_object = 1 		then$ 		    { It's a DAP connect request } 		    begino9 			if not xmt_region^.line_char[line].ddcmp_protocol then  			    begin 				{ It's not a DDCMP line }  e  7 			        { Create a new port and the data structure }e- 			        { to pass to the circuit process }e 			        new ( circuit_db );$ 			        circuit_db^.line := line;* 			        create_port ( circuit_db^.port, 			        status := status );   		    	        if odd(status)n 			    	then
 				    begin , 			                accept_circuit ( my_port,H                                   	         connect := circuit_db^.port, 						 status  := status );: 			    	        if odd(status) 			    	        then 				            begin	5 		    		                { Start the circuit process }o2 			    	    	        create_process ( sub_process,7                                     			circuit_process,t6                                     	    		circuit_db, 							status := status );	 					    e 					        if not odd(status)t 					        thene 					            begin3 				    		    disconnect_circuit(circuit_db^.port); # 						    delete(circuit_db^.port);k 						    dispose(circuit_db); 				 	            end; 				            end 	 					elsep 				   	    beginb" 					    delete(circuit_db^.port); 					    dispose(circuit_db);  				        end; 				    end, 		    		else 				    dispose(circuit_db);  
 			    end 			else^ 			    begin# 			        { It is a DDCMP line }  t: 			        accept_circuit ( my_port, full_error := true );J 				eln$ddcmp_v2_start_running ( address (rec_region^.ddcmp_region[line]),1                                      put_chars );i. 			    end; { if not xmt_region^.line_char...}	 		    endA   		else  { if signalled_object }E 				 		    begins( 		        { It's a DDA connect request }  6 		        { Create a new port and the data structure }, 		        { to pass to the circuit process } 		        new ( circuit_db );u# 		        circuit_db^.line := line;*) 		        create_port ( circuit_db^.port,  		        status := status );m   	    	        if odd(status) 		    	thenr 			    begin, 		                accept_circuit ( dda_port,) 	         			connect := circuit_db^.port,_ 					status  := status );f 		    	        if odd(status)e 		    	        then  			            begin	o4 	    		                { Start the circuit process }5 		    	    	        create_process ( dda_sub_process,b 						dda_circuit_process, 				    		circuit_db,  			     			request_timer,l 						status := status ); 	 					    { 				        if not odd(status) 				        then 				            begind2 			    		    disconnect_circuit(circuit_db^.port);" 					    delete(circuit_db^.port); 					    dispose(circuit_db);_ 			 	            end;l 			            end 				else 			   	    begin! 				    delete(circuit_db^.port);a 				    dispose(circuit_db); 			        end;.
 			    end 	    		else_ 			    dispose(circuit_db);   # 		    end;  { if signalled_object }c       end; {while true}n   LINE_RETURN: end; { process } 	  + process_block timer_process ( evt  : event;u& 			     timeout_occurred : ^semaphore;  			     request_timer : event );   {++	5 { TIMER_PROCESS : general timer process for all lines M {   Accepts requests for starting timers, and signals main code upon timeout.d {--} {++t {e {  {--}   var      status: integer;(     sigstat	 : integer;	{ local status }*     wait_stat	 : integer;	{ local status }9     timer_result : integer; 	{ result of a wait_any call} A     entry_ptr	: ^queue_record;{ general pointer to queue records} K     timeptr 	: ^queue_entry;	{ pointer to queue entries in the timer_queue}CL     reqptr 	: ^queue_entry; { pointer to queue entries in the request_queue}E     relative_time : large_integer; {difference between 2 time values}_H     done_insert : boolean;	{ true if we have finished inserting all the}3 				{  request_queue entries into the timer_queue.}dI     done_checking_timer : boolean; { true if finished removing from the }^2 				{ timer_queue all the entries that have timed}/ 				{  out or that have ignore_timeout = true.}eE     tail_entry : boolean;	{ true if a record has to be added at the } . 				{  tail position of the queue, rather than$ 				{  before the current position.}     first_element  : boolean;=     empty	   : boolean; &     timer_active   : boolean := false;'     signal_main    : boolean := false; t     time_proc      : process;t   beginp  aJ     { Set the process priority of the timer to 7, above that of the line ]8     { processes and below that of the main dispatcher. }     current_process(time_proc);r2     set_process_priority(time_proc,read_priority);  #     signal ( evt,status:=sigstat );        {Wait for startup: }     while true doi	     begin	 	if timer_active	then	   	    wait_any(request_timer, f& 	             result := timer_result, " 	             time := new_timeout," 	             status := wait_stat) 	elsee   	    wait_any(request_timer,  & 	             result := timer_result, # 	             status := wait_stat);     e 	clear_event(request_timer);  e, 	done_checking_timer := false;		{initialize}  r3 	REPEAT	{repeat until done_checking_timer := true }i; 	    timeptr := timer_queue.flink;  {point to first entry} e  b, 	    { Is this the end of the timer_queue? }+ 	    If timeptr = address(timer_queue) thena= 	    	done_checking_timer := true  {no more entries to check}=  p	 	    elseo 	        begin(     	                                                                                                                                                                                                                                                    e                        2A  $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                              *d "                   lock_mutex ( sync_lock );  C 	    	with timeptr::^queue_record^ do  { point to the queue record}u 	    	    begin    i; 	                get_time(my_timer); 	{ get current time }	 ; 			{check if timer entry was cancelled or if timer expired}d: 			if ((ignore_timeout) OR (time_at_timeout <= my_timer))  			then  			    begin			    s0 				{remove the current entry (the first entry)}% 			        remove_entry (timer_queue,h 					entry_ptr::^queue_entry,  					empty, queue$head);1 				{insert the entry into the timer_complete_q:}e) 			    	insert_entry ( timer_complete_q,   		    			entry_ptr^.entryq,c% 				    	first_element, queue$tail );;2 				signal_main := true;	{signal timeout_occurred}
 			    end 			else	$ 			    {timeout has not expired yet}# 			    done_checking_timer := true;t   5 	    	    end;  { with timeptr::^queue_record^ begin}a$ 		    unlock_mutex ( sync_lock );  	   8 	        end; { If timeptr = address(timer_queue) begin}  o 	UNTIL done_checking_timer;p  s {------ end common code ------}i  n     case timer_result of     0:		{timeout}u	     beginiG 	{ Nothing special to do for timeouts that wasn't already done above. } G 	{  After this case statement, the timer will be resumed by setting   }t 	{  a new timeout value. }     end; {case 0}   :     1:		{request for timer}_	     beginr7 	done_insert := false;		{init - not done inserting yet}   } 	REPEAT ! 	    lock_mutex ( sync_lock );  	iB 	    reqptr := request_queue.flink; {first entry in request_queue}  nG 	    if reqptr = address(request_queue) then  {no more request entries}  		begine  	            done_insert := true 		endp  e4 	    else	{there is at least one more request entry}    	        begin  s; 	    	{Remove the entry from the head of the request_queue}e" 	    	remove_entry (request_queue,& 	    		      entry_ptr::^queue_entry,   	    		      empty, queue$head);  a 		if empty then ' 		   begin	{no more entries after this}r 			done_insert := true;  		   end; {if}  )@ 		if not entry_ptr^.ignore_timeout then  {if record still valid} 		    begin 0 		    { Insert the request into the timer_queue}D 	        	timeptr := timer_queue.flink; {first entry in timer_queue}: 			timeptr := timeptr^.blink;     {get back to the header}   F next_entry:		timeptr := timeptr^.flink;     {identify the next entry.}; 			tail_entry := false; {add at CURRENT position, not TAIL}:  m% 			{ Is this the end of timer_queue?}s+ 			if timeptr <> address(timer_queue) then c' 			    begin  	{not end of timer_queue};A 				with timeptr::^queue_record^ do  { point to the queue record}p 		    	    	    begin     6 			                relative_time := time_at_timeout - ! 						entry_ptr^.time_at_timeout; ( 				        if relative_time <= 0 then  9 					    goto next_entry;  {queue entry is more imminent}f 				    end; {with} 
 			    end+ 			else		{we are at the end of timer_queue} ; 			    {Have to insert the record at the TAIL of the timer} : 			    { either because all the timer_queue elements are }: 			    { more imminent than this request, OR there are no}; 			    { elements left in the timer_queue (so that putting} : 			    { the entry at the tail is that same as putting it} 			    { at the head. }t 			    begin 			        tail_entry := true  			end;l  a 			{Insert the request}e    			if tail_entry then_# 			    insert_entry ( timer_queue, m 		    			entry_ptr^.entryq,h$ 				    	first_element, queue$tail ) 			else  			    begin1 				timeptr:= timeptr^.blink;  {get to previous } # 						 {entry and insert after it.}c  		    		insert_entry ( timeptr^, 		    			entry_ptr^.entryq, ' 		    		    	first_element, queue$head)  			end; {if tail_entry} 2 		    end { If not entry_ptr^.ignore_timeout then} 		else 		    begineA 		        { This record never got into the timer_queue, because }m9 		  	{ the ignore bit was set while it was still in the }l6 		  	{ request_queue.  Since there are no longer any }6 			{ pointers to this record in the main code, we can}6 			{ dispose of the record now, rather than put it in} 			{ the timer_complete_q. }, 	    		dispose (entry_ptr);  {get rid of it} 		end;    { else }  t3 	    end;    { if reqptr = address(request_queue) }   	    unlock_mutex (sync_lock);    uA 	UNTIL done_insert  {Repeat until all request_queue records have}n. 			   {  been inserted into the timer_queue. }   end; {case = 1}r
     otherwiseo 	begin	{No other events} 	end;r     end; {End Case}a  u    {for both case 0 and case 1:}}     {      { Resume timing }      {W?     { Set the new_timeout value to be the timeout of the first  5     {  element in the timer_queue, if there are any.  G     {  NOTE that the timeout of the first element of the queue may have	E     {  already passed, during the execution of this routine.  So the .?     {  wait_any for the timeout may get satisfied immediately. t     {}       lock_mutex (sync_lock) ;  ?     timeptr := timer_queue.flink; 	{first entry in timer_queue}   &     if timeptr = address(timer_queue)      then> 	timer_active := false		{no active entries in the timer queue}     else 	begin 	    timer_active := true;& 	    with timeptr::^queue_record^ do  ! 		new_timeout := time_at_timeout;          end; {if}i       unlock_mutex (sync_lock) ;     9     { Waited to signal main code until all entries that }s!     { timed out were processed. }      if signal_main then	
         begin	 	    signal_main := false;  	    { Signal main driver code }/ 	    signal(timeout_occurred^, status:=sigstat)s 	end;_     end; {while true}    end; {process}    4 procedure Cancel_timer ( var ptr : ^queue_record ) ; { & { Cancel a previously requested timer. {;+ { INPUT: ptr => pointer to a queue_record. tA { OUTPUT: => Ignore_bit field of the input record is set to true.e& {         => Ptr is replaced with nil. {}   beginu     lock_mutex (sync_lock );	sK     if ptr <> nil then	   {do this check while we have control of the lock}	 	begin! 	    ptr^.ignore_timeout := true;.             ptr := nil 	end;t     unlock_mutex (sync_lock);	 end; {procedure}    - procedure add_timer_request ( line : integer;s! 			     interval : large_integer;s! 			     t_event  : timeout_event;p! 			     var ptr  : ^queue_record;t  			     request_timer : event );   {++a {eL { add_timer_request: add a timer request to the request queue for this line. {a2 { INPUTS:  Line => line for which to start a timerK { 	   Interval => length of time or absolute time to set the the timer for. E {	   t_event  => type of timer (eg. evnt$mod2sec is a 2 second timer) > {	   ptr	    => the address that will hold the pointer to the 6 {		       queue record after it is added to the queue.E {	   request_timer => the event to signal when the request is queued.  {t {--} vars     entry_ptr	: ^queue_record;     save_ptr	: ^queue_record;n     tval	: large_integer;c     first_element : boolean;   begin  :0     {Cancel the previous timer, if there is one}     Cancel_timer (ptr);t  1     { Make sure time field is an absolute time. }      if interval < 0 then 	begin! 	    { Interval is a delta time } / 	    get_time(my_timer);		{ get current time }	iM 	    my_timer := my_timer - interval;  { Determine ABSOLUTE TIME at timeout} s 	end     else! 	{ Interval is an absolute time }s 	my_timer := interval;        2     new (entry_ptr) ;	{create a new queue element}     entry_ptr^.line  := line;		(=     entry_ptr^.time_at_timeout := my_timer;  {absolute time}	 9     entry_ptr^.evnt := t_event;		{type of timer request}	 (     entry_ptr^.ignore_timeout := false;	  I     {queue the element in the request_queue and signal the timer process}s       lock_mutex (sync_lock );  	 4     insert_entry ( request_queue, entry_ptr^.entryq," 		   first_element, queue$tail );	C     signal (request_timer);   {signal the timer to add the request}d  A     {Update the timer state for this line by saving the pointer }CB     { to the queue record in case you have to cancel the request }     {  later on: }     ptr := entry_ptr;n      unlock_mutex (sync_lock);  	 	  end;  {process}s n  ? process_block dda_circuit_process ( dda_circuit_struc : ct_ptr;i$ 				    request_timer     : event ); {++: {tE { DDA Circuit process : This process is started to service a DDA I/O e! { request for the specified line.  {iB { Inputs : dda_circuit_struc - a structure containing information  { particular to this circuit {  { Outputs :	none {i {--}   varu7     dda_packet	     : ^dda$_packet;	{ dda message data}eI     dda_message_obj  : message;	        { The MESSAGE value identifying }s$ 					{ the next message in the port}I     message_size     : integer;  	{ re                                                                                                                                                                                                                                                   f                        d87 $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "            ceives the size (in bytes) of the }{ 					{ received message data. }h(     disconnect_status, status : integer;=     sgnl_oob_outstanding_ptr : ^boolean; { TRUE if there is }e0 			{ an outstanding request for oob signalling } 			{ on this circuit process. }i   beginn0     eln$allocate_stack ( 4096 ); { eight pages }  "     new(sgnl_oob_outstanding_ptr);'     sgnl_oob_outstanding_ptr^ := false;i       While true don	     begin 2 	{ Wait for a message to come in over the circuit}# 	wait_any(dda_circuit_struc^.port);    	receive  (  dda_message_obj,h 		    dda_packet,  		    dda_circuit_struc^.port, 		    size := message_size,n 		    status := status );_   	If status = ker$_success then
 	    begin  @ 	 	{Request message must be at least the size of the dda header}) 		If message_size < dda$_header_size thend 		    begin	 			delete (dda_message_obj);0 	    	        goto dda$_circuit_process_return  
 		    end;  * 		CASE DDA_PACKET^.HEADER.DDA$_FUNCTION OF 	  	    	    DDA$_FNC_GET_CHAR: 			begin 		    	    dda$tty_get_char( 				dda_message_obj,   		    		dda_packet,  				dda_circuit_struc^.line,4 				xmt_region^.line_char[dda_circuit_struc^.line]);  6 		    	    {original message is DELETED by the driver}5 		    	    { and a new one is created and returned. }e 	        	end; 	i 	    	    DDA$_FNC_SET_CHAR: 	    		begin 		    	    dda$tty_set_char( 		    		dda_packet,s 				dda_circuit_struc^.line,3 				xmt_region^.line_char[dda_circuit_struc^.line],= 				register_location); 7 		    	    {original message is RETURNED by the driver}i- 		    	    { with just the status modified. }u 	    		end;     	    	    DDA$_FNC_ASSERT_BREAK: 	    		begin 			    dda$tty_assert_break( 		    		dda_packet,r     				dda_circuit_struc, 				register_location,3 				xmt_region^.line_char[dda_circuit_struc^.line],	 				request_timer);	7 		    	    {original message is RETURNED by the driver} - 		    	    { with just the status modified. }t 	    		end;e   		    DDA$_FNC_READ: 	    		begin 			    dda$tty_read( 		    		dda_packet,_     				dda_circuit_struc, 				message_size,  				request_timer);. 	    		end;	   		    DDA$_FNC_WRITE:$ 	    		begin 			    dda$tty_write(i 		    		dda_packet,}     				dda_circuit_struc, 				message_size); 	    		end;   ! 	    	    DDA$_FNC_SGNL_OOB_CHAR:  	    		begin 		    	    dda$tty_sgnl_oob( 		    		dda_packet,  				dda_circuit_struc^.line,' 				dht_struc[dda_circuit_struc^.line],s2 				rec_region^.line_ctx[dda_circuit_struc^.line], 				sgnl_oob_outstanding_ptr); 	    		end;    		    DDA$_FNC_CNCL_OOB_CHAR:	 	    		begin 		    	    dda$tty_cncl_oob( 		    		dda_packet,t 				dda_circuit_struc^.line,' 				dht_struc[dda_circuit_struc^.line],r 				sgnl_oob_outstanding_ptr); 	    		end;i   	    	    OTHERWISE; 	    		begin7 			    dda_packet^.header.dda$_status := ELN$_INVALFUNC: 	    		end;i           	END; {CASE}  H         	send(dda_message_obj, dda_circuit_struc^.port, status:=status);A 		if not odd(status) then	 {Couldn't send the message, delete it}= 	    	    beginq 			delete(dda_message_obj); 1 			{ Check if the circuit has been disconnected }e# 			if status = ker$_disconnect thenl( 			    goto dda$_circuit_process_return;
 		    end;  $ 	    end  {if status = ker$_success} 	elseqD 	    If status = ker$_disconnect then   { circuit was disconnected }+ 	        goto dda$_circuit_process_return; $       end; {while true}e     DDA$_CIRCUIT_PROCESS_RETURN:> { If there is an outstanding request to be signalled for OOB } {  characters then cancel it: } ! if sgnl_oob_outstanding_ptr^ theni	     begin / 	{ Delete the signal request for this circuit } B 	dda$_dequeue_circuit_reqs ( dht_struc[dda_circuit_struc^.line] );     end;" dispose(sgnl_oob_outstanding_ptr);  /     disconnect_circuit(dda_circuit_struc^.port, & 		       status := disconnect_status);  (     delete  ( dda_circuit_struc^.port );"     dispose ( dda_circuit_struc );   end;   ?P [inline] procedure DDA$_Dequeue_Circuit_Reqs (terminal : terminal_data_pointer); {e {;K {  This procedure will dequeue an OOB signalling request for the specified   {  circuit, if one exists.  N {  NOTE: currently there is only ONE queue for CXdriver (signal OOB charactersH {	queue) and only ONE request per line per circuit.  Therefore, we only G {	need to search one queue for one request and cancel that request.  In{D {	the future, if a circuit gets disconnected and we have to clean upD {	the requests for the circuit by calling dda$_Dequeue_circuit_reqs,8 {	THIS CODE WILL HAVE TO GO THROUGH ALL EXISTING QUEUES  {	AND CANCEL ALL REQUESTS. {e	 { Inputs:i {    terminal - line structure { 
 { Outputs:	 {    none  {  {--} vart!     current_process_id : process;h      begin	(     current_process(current_process_id);!     tc$cancel_oob_chars(terminal,e 		current_process_id); end;   	5 procedure dda$tty_get_char(var message_obj	: message;.% 			       request_ptr	: ^dda$_packet;$ 	 		       this_line	: integer;	2 		               line_parameters  : ln_param_rec); {	D { dda$tty_get_char - Get the characteristics for the specified line. {	 {--}   type     char_response = record 	header: dda$_header;	, 	data_buffer: dda$_terminal_characteristics; 	end;.   vart     new_message	: message;     response	: ^char_response;     status	: integer;r   begine  A     { Driver creates a new message and deletes the original one } <     create_message(new_message, response, status := status);       if odd(status) thenh	     begin,D 	{ Copy request header information, including unmodified user_data }2         response^.header := request_ptr^.header;    @ 	{ Return the size of the current revision of the data buffer. }  P         response^.header.dda$_buffer_size:= size(dda$_terminal_characteristics);  5 	delete(message_obj);  		{ Delete original message }	 : 	message_obj := new_message;	{ Return new message object }  A 	lock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  e  * 	{ Fill in with terminal characteristics } 	with response^.data_buffer do
 	    begin$ 	    	class         := driver_class;# 	    	dev_type      := device_type;i6 	    	revision      := dda$tty_terminal_char_revision;  > 	        host_sync     := dda_line_struc[this_line].host_sync;; 		tty_sync      := rec_region^.line_ctx[this_line].tt_sync;.? 	    	modem_control := dda_line_struc[this_line].modem_control;t  * 	    	echo 	      := line_parameters.echo;/ 	    	passall       := line_parameters.passall;t7     	        passthru      := line_parameters.passthru; 3 	    	escape        := line_parameters.ansi_escape; , 		eight_bit     := line_parameters.eightbit;3 	    	scope 	      := not line_parameters.hardcopy;o5 	    	parity        := line_parameters.parity_enable;f; 		parity_type   := dda_parity_array[line_parameters.sense];i9 	    	char_size     := (line_parameters.char_length + 5);e6 	    	ddcmp         := line_parameters.ddcmp_protocol;@ 		line_speed    := dda_rate_array[line_parameters.rx_baud_rate];- 	    	modem_support := line_parameters.modem;s9 		{ No modem, so send back false for all modem signals: }r 	    	ring 	      := false;r 	    	cd   	      := false;a 	    	cs   	      := false;i 	    	dsr  	      := false;n 	    	dtr  	      := false;U 	    	rts  	      := false;t
 	    end;	C 	unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  e  . 	response^.header.dda$_status := ELN$_SUCCESS;       end {if odd(status)} else	     beginn! 	if (status = ker$_no_object) or r 	   (status = ker$_no_pool) or   	   (status = ker$_no_memory)n 	thent 	    status := ELN$_NORESOURC;  + 	request_ptr^.header.dda$_status := status;i     end;   end; {procedure}   i> procedure dda$tty_set_char( var request_ptr 	  : ^dda$_packet;% 	 		        this_line   	  : integer; 3 		            var line_parameters   : ln_param_rec;m0 	  		        register_location : register_ptr ); { J { dda$tty_set_char - Set the characteristics for the specified line, using, {		  the new values from the message packet. {  {--} type     set_char_request = recordm 	header: dda$_header;m, 	data_buffer: dda$_terminal_characteristics; 	end;p   vart%     status	: integer := ELN$_SUCCESS;      version	: integer;     temp_sync	: boolean;       + function handler of type exception_handler;} begin  status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or ;     (status = ker$_no_memory)r then     status := ELN$_NORESOURC;a   goto return; end;     begins       establish(handler);t  C     { Make sure the received data buffer is at least big enough to}a=     { contain the revision num                                                                                                                                                                                                                                                   g                        h9 $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "            ber, otherwise it is invalid. } I     if (request_ptr^.header.dda$_buffer_size < dda$_char_revision_offset)      then  	raise_exception(eln$_invalrec);  D     version := request_ptr::^set_char_request^.data_buffer.revision;     {u;     { Make sure the revision is valid, and if so, that the t>     { buffer size matches the size for that revision number: }     {}     CASE version ofe
 	1:  beginJ 	    	if (request_ptr^.header.dda$_buffer_size <> dda$_char_1_buffer_size) 	    	then  % 		    raise_exception(eln$_invalrec);o	 	    end;y  
 	2:  beginF 		if (request_ptr^.header.dda$_buffer_size <> dda$_char_2_buffer_size) 	        then % 		    raise_exception(eln$_invalrec);a	 	    end;   
 	OTHERWISE
 	    begin! 		raise_exception(eln$_invalrec);l	 	    end;n     end; { CASE }   D     lock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);    7     with request_ptr::^set_char_request^.data_buffer doc  	begin	  : 	    { Check some user-supplied values to make sure they }( 	    { are compatible with this driver.}= 	    { Do these checks BEFORE actually setting new values.  } : 	    { Thus if there is an error, the user must resubmit }> 	    { the SET request with all his original request values. }  4 	    { This check may be different for each driver }= 	    char_size := char_size - 5;  {Map to char_length values} ( 	    if ( (char_size < char_length_5) OR  		 (char_size > char_length_8) )	 	    thenE 		beginuH 		    unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  ) 		    raise_exception(eln$_invalcharsiz);e 		end;  4 	    { This check may be different for each driver }( 	    If ( (line_speed < dda$_rate_50) OR% 		 (line_speed > dda$_rate_38400) OR e) 		 ( NOT rate_array[line_speed].valid ) ) 	 	    then} 		begin H 		    unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  ' 		    raise_exception(eln$_invalspeed);g 		end;  . 	    If ( (parity_type < dda$_parity_space) OR( 		 (parity_type > dda$_parity_ignore) OR- 		 ( NOT parity_array[parity_type].valid ) ) d	 	    thent 		begin)H 		    unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);  ( 		    raise_exception(eln$_invalparity); 		end;  9 	    { No problems... So we can set the characteristics }   	    {** class    - readonly **}  	    {** dev_type - readonly **}  	    {** revision - readonly **}  > 	    {------------ Line Parameters Register -----------------}% 	    {** ddcmp         - readonly **}u% 	    {** modem_support - readonly **}H# 	    line_parameters.echo := echo;  ( 	    line_parameters.passall := passall;8 	    rec_region^.line_ctx[this_line].passall := passall;, 	    line_parameters.ansi_escape := escape; , 	    line_parameters.eightbit := eight_bit; < 	    rec_region^.line_ctx[this_line].eight_bit := eight_bit;+ 	    line_parameters.hardcopy := not scope; - 	    line_parameters.parity_enable := parity;C. 	    line_parameters.char_length := char_size;> 	    line_parameters.sense := parity_array[parity_type].value;B 	    line_parameters.rx_baud_rate := rate_array[line_speed].value;B 	    line_parameters.tx_baud_rate := rate_array[line_speed].value;3 	    { PASSTHRU is not in the revision 1 terminal } 2 	    {  characteristics record.  If the received }5 	    {  set_char request is for a version 1 record, }	$ 	    {  the don't change PASSTHRU: } 	    if version >= 2 thene 		begin_/ 	    	    line_parameters.passthru := passthru; ? 	    	    rec_region^.line_ctx[this_line].passthru := passthru;{ 		end; 		 		+ 	    if line_parameters.ddcmp_protocol then$ 		begin:+ 		    line_parameters.ANSI_escape := false;	+ 		    line_parameters.echo        := false;	* 		    line_parameters.passall     := true;* 		    line_parameters.eightbit    := true;: 	    	    rec_region^.line_ctx[this_line].passall := true;< 	    	    rec_region^.line_ctx[this_line].eight_bit := true; 		end;  8 	    rec_region^.line_ctx[this_line].tt_sync :=tty_sync;B 	    dda_line_struc[this_line].host_sync := false; {unimplemented}  - 	    { Modify the registers with new values }e    	    { Line parameter register }- 	    DDA$_Modify_Line_Parameters ( this_line,  				        register_location, 				        line_parameters );   	    { Lctrl register }t. 	    DDA$_Reset_TTY_Sync_register ( this_line, 				register_location,
 				tty_sync,o 				line_parameters.passall ); 	end;	  F     unlock_mutex (dda_line_struc[this_line].dda_terminal_char_lock);         status := ELN$_SUCCESS;    return:      revert; + 	request_ptr^.header.dda$_status := status;.   end; {procedure}     fB procedure DDA$_Modify_Line_Parameters ( line 	          : integer;- 				        register_location : register_ptr;{3 				        var line_parameters   : ln_param_rec );    {s {kO { This procedure will write the new line parameters for this line to the proper  { line parameters register.s { 	 { Inputs:  { " {	line number specifies which line> {	line_parameters contains the user-specified characteristics  {	  for this line{8 {	register_location points to the DHT32 device registers { 
 { Outputs: {r# {	line parameter register modified.c {a { Note: > {    the dda_terminal_char_lock are both locked at this point. {--} varh     lparam : lpr;r   beginc     with line_parameters do_ 	begin  % 	    disable_interrupt ( async_ipl );              { Set line number}3 	    write_register ( register_location^.async_csr,. 			     rx_int_ena := true,s 			     tx_int_ena := true,e" 			     ind_reg_address := line );  < 	    lparam := read_register(register_location^.line_param);+ 	    lparam.char_length     := char_length;a- 	    lparam.parity_enable   := parity_enable;l% 	    lparam.even_odd_parity := sense;t, 	    lparam.rx_baud_rate    := rx_baud_rate;, 	    lparam.tx_baud_rate    := tx_baud_rate;; 	    write_register (register_location^.line_param,lparam);s 	    enable_interrupt;  ? 	    {ECHO, PASSALL, EIGHTBIT, ESCAPE, and SCOPE are not in a }d= 	    { register; they are just stored in the communications }cE 	    { region, which I already updated before calling this routine. }l   	end; {with} end;   q= procedure DDA$_Reset_TTY_Sync_register ( line      : integer;	- 			        register_location  : register_ptr;t( 			        new_tty_sync       : boolean; 				passall		   : boolean ); {++r {_@ { This procedure will modify oauto in the line control register.2 { The oauto must not be TRUE when passall is TRUE,? { So if user has set tt_sync to true, it can only be set in them { register if passall is false. C { tt_sync reflects what the user wants, but not necessarily what is  { in the oauto register. { 	 { Inputs:c { " {	line number specifies which line8 {	register_location points to the DHT32 device registers7 {	new_tty_sync specifies the new value to set oauto to.uB {       passsall specified the current passall value for the line. { 
 { Outputs: {e {	oauto modified.o {; {  {--} vari     temp_oauto : boolean;    begine       if not(new_tty_sync)     then0 	temp_oauto := ( not(passall) AND new_tty_sync )     else 	temp_oauto := not(passall);  $     disable_interrupt ( async_ipl );     { Set the line number }n/ 	write_register ( register_location^.async_csr,r 			 rx_int_ena := true,  			 tx_int_ena := true,  			 ind_reg_address := line );       { Modify oauto }I     line_ctrl_dummy 	  := read_register(register_location^.line_control);d(     line_ctrl_dummy.oauto := temp_oauto;)     line_ctrl_dummy.iauto := not passall;RF     write_register ( register_location^.line_control,line_ctrl_dummy);     enable_interrupt;e end; l  procedure dda$tty_assert_break(   			request_ptr   : ^dda$_packet; 			circuit_struc : ct_ptr;+ 		        register_location : register_ptr;=1 	                line_parameters  : ln_param_rec;i 			request_timer  : event ); {sB { dda$tty_assert_break - force a serial line to the spacing state. {r {--} varl+     status	      : integer := eln$_success;t4     duration 	      : large_integer := short_break; &     delay	      : large_integer := 0;       beginl  ;     { Don't allow break assertion if the line is not valid.      {}7     if xmt_region^.line_valid[circuit_struc^.line] thene 	begin    	    with request_ptr^.header do
    	    begint  2     	    	{ Determine the duration of the break: }M 	    	if not (dda$_sfb_short_break IN dda$_subfunction.assert_break_sfb) then= 		    beginrG 		    	if dda$_sfb_long_break IN dda$_subfunction.assert_break_sfb thenr$ 	        	    duration := long_break 		    	elseeS 	        	    if (dda$_sfb_user_duration IN dda$_subfunction.assert_break_sfb) then < 			        { Do not allow absolute times for timeout value }* 			        if dda$_break_duration > 0 then7 				    status := eln$                                                                                                                                                                                                                                                   h                        v. $      ELN042.B                         
  )[SYSEXE.SEAS$WORK_0000005C]DCDRIVER.EXE;1                                                                                                                    -             ɾbEFY{h:|4ĄO[7&iPPQTpVڼ6tȺl`_6\uٿ誰bfOF<lQ?',٧H熀$=F='W0/#`|}L%1W)czcO*qBuu[@Wm6&7]fyw0rܷp6C h{! cT㡨Ƌp~TVّWg=9"HM{h@38ӥO>է-N,.:o X@gIUYܱc?.먐*IZ9s`b 3wK`YUE'RTR#%+L+nfR x.6eb]~57ʁ姠e}Bo3%H$W
&w|U2s8	ae+Q|%dQ1WV8!3qRn@lq=#-0Vߘ7;j" :!M2C"oD#ĸCzvBkoש&]6k,an-bqS3UL^}ԺCBRaiN֗ߐQv#sqx9V.̓JS!k?\P.:dh5I! nO>u2.ab6 mTHkqpD^~+;Z+%	fTN+jW[0?GvQ#y{Dm!=5V$8|.a
IJIh<B݆\q²Ԅ.٘JT[}BFסӎ9/m-93ݞ3ث4T9Ƣ']>ӫB-ةSKb̽)%m~t\1w`8{CǭװEiF-8pj
n=A,G\d`wFl (c"ol-Rs+ה~Fv]S?Ä-eNqbnk)[kWލo.£!~4[jН
K{E聲 s!<?OމӘ9~F1$̻~bWH"3h[L\x8gK/tf.
Ք]PUL.:_FQd]r{L
P]aT1D/zVrzAWC},Ap$!5!
Σr[D9J04&o>0EZ
uk}L\n-wǌeB2Gī^3G?u󌨙58-Ahs8ޚTkeM]74~J0)>iNͥ<3N/A#y˝fO	b/\ 0>po'6
bB*BD؋
]cmAJ x[낽eI֭7-8ׯd}o$A$ $vGgP!&T&﫛,MyD]l*3Ğ[IazV|
*TS^L9KrU@S^@qG]^~[Mb/_dLGQ~IB+m)ofX4`n@*g?`
$>EF7Vߐ4~Hw30U jx~;¶~*qJYvWoCal>ZJ03UNDȁAAAW]L8HQUlr. Z2.Zt8D[5a-QMOa6oh\cuf"aVZ!L[.jx2!T}}QY96\#YC:l0+"
mآ"(5}-u{t%sj^y:>Vx,k@})U'+w1HHA\~ 9Vzk(phjpVfUfwR`ijqm:G&40"8JoeA֗!F.}=87K8_s!(|??^5/<p$USb<cC"	QXV#I;0ltI%^9Щ<.i.-&o=Vtp2a "Q"!Ao>|MuJs]4iFlm~pN& 19}I&wuC`/'4+7N[!t8G[cO{nkM܃#:T7N7%0021Y]֡+b>D #5ZVߙy9QCumKe~qK$Y|ty].?eY{,sw=l+ѫ7
:($T OΈ7Đy
fLo*׀ҷ r`Zw6zQ=`f	sY:i6qx(.@\<\JcGY5`>8{lQ>\*vZ{JW:\7/i`UaN߾mOMָG19i5/T07VA
a;Q4PyFdG lx=~ӧqne	{m
.fRmq=w!1B#p4fE,ib)H?W
dWo/}붦%wRHj.ut)ůq[X
&>\%LopZDqB[%E>!tFpnAM<1](GWEG.S|Z-LNwXw_V$0XwfƸUReB:rR3|=:N*ӈ	GMػA)˟F[7o)lvC3iqH*_;7Fg/ܓ{0vodW,#Z[.C
"ְZ_o֠]L52dXa˹Wٕ'ЯeG	`]O-Ò}{PF[1{PYls㉊apMk^kz.)p]lvManEs.NoHG|*%DrژN8쨍{֕ ,Tx߹~}uQ>V	tV9+B.C\h':/ijTb׺'fs%S\n#?ߩH/%.Eoo&q_ *huei+^B`M!N4	])^l.C(S	\>#;ޭLuUE0D
˔"
Cc*iy7'e
uP
	%YmTQfC`fjmQQQF>54U53A@+S~Hc~?1*#t_{/>`<@DI;(id2,n*|I=,GxHA@VfGR>'a'm
AK5<x,o$WDIAy#81+-Z/Y!H@@)?`)e
, \ƇR^C[qjrO!S3p;!zҎsv/{/V+O>vE~U/&Xy.:q-m\d"iq;";Up*LJ ,DL&}?M
@X/µ1)q8Y JUT>7bT/B4V㚈Fl _Aephr]gndT,u`]!3{Q+Dy"w"N{ONr|I1KDvnEznj<E:1ϑ֮*Qx^@~,saIHo;pthU{`7+S2;=;M^ь~C5 NIW2À2s(~qAkg;Ԉt%&=461>
}TJ7[i_~9۲FEzʭڌ1Q
\cxuGrZyQKѣ m6ޮ|Ҧm \)\g{?Zq7ϲ7Z7B'YXϾD+0Q`n쐆L/t+TRق
&}8#[qI;8w+o(,xQJRmSxlM?sLaE(x,lTkq0/RfV}ĨbNFcrc<5p:Kuee9v7MC>.[
!2Їo:ȋgZwX}i!E	-*0vեۿU,q<28O1izwc(6aɪvF0rE4:Ios<Rg@uCBB4-u˞`Y]Y^v1wͣgWUuyev2`*ٽ'oc+Ѯ3PG<_3r2lAj 5vPS VAOi͈ѸA%~,C;wsR>,,ꍉ,/рѡ.0Ϗ/xctֺGCm|W:@>vla@]!jS@]خhX%sdQnqf
?nqbeF7Un:9Д`0ɳPd!1,{Ӭ{ӎWMg	!MUco|Uf
!nAeSem]$tN?~65Cj=^SbOd:?_Rqk&+Q|js?<>ͽҬ]l#pڲzi&
IV̇_~kȖYw<82vj[3<^L2"sR@$kA9mmYpQ`x?rn~*dtK|l؁`S^$oeɼG$ RIhCX(rt7}G%%0xU>TZjBiO[mxv$(iTL%-r9Hw4_
}c%
m7EGE&"`z'"eӳs9?t(϶V(5Δ?祄Ӻ{H>^2}D`gǸ&sy} yvcR,t-:p~=c_ᱏnzm(#9˕?=RͶIX%\ӵ RF$ӿCP;$5?p	]ܲi:YM۳oU_֮,KrD^Ď`gjd`q~cdq=(=^!#n;#PXq;]R}cEM)
7E\Nٕ6NZz\XzC\vdFe%LRj='3Rp-˽\aA8"N
^ Lrn%,Le?;|7}Yby
Ț:7Zrb 7
3,Pv${^TfTKa4e8Y,)*0NMnޱ]*+݁G%3XV-<kɪSӓUM7nÄHY㣫Pz=Rs ZUh z.Ƀ3r)AP$Ϝ^M,kWga ;y\@!uj@]ӒNИgwfb#.#O+Q]/PZoY׌-mX,hjlivK
DР06a{^0-ugOǮ{:𛹷+ːl>љT?ҍv-쯵-ZF~.fBN,MתTxOjXnQ=0PsXl'n25*q&[KmMLݽP+ZY?naA!Be&3d3ؒW-QYGu%80*
EC?&+y/z֣A1OAA8P-#oFrJXN֕׈~;AϥxpNx-YK gg	L2 Fׁ	 a_
\#3wl$>C!;XH#6aϱ~\dJɃv"+T[<#r_uuٕb/'Xo5V1ȍܫ9>nÙ2wd4$JqXL|셆:kH^XR
Bb8n9ȯca:Fywݲ2kf3>*Q 0*sEٜAZ[s Ͽ.@9!CBs0}ߝ6]
A>(oaɐ`/H(_4 &F?U*j'^őV+G]nskV6ؓLntBn; Ī!`D7M`&WeHc2_"'.@>?&6٭Xdw5d8YVnhʛǉBD]PT-R=B3\nZ AcEj?
&;Y;Q~T8p\G(!َNM/_#^zYQC?GX]4>Yq5_Dcm[tt@!P4ԧP5,QMqI\zNuL
[vA-$aUI\,(yeIP7&>5xU30izZhSxTy>|qi˧w)j}TC]ju,Ab̧[6W&beANOqp
S%ygO_uDy(vT^[9{(KTN)︫G"8~C.rd+JPG{sxԴ;4nG.%=,If3kJHu-	"?*P@#\0
lo?*J2=@}nG.̌{F=RBv"~Qv 0N2|2yV`/+*y9=x)M[[)y(%o[$-DD?P=fNji(nM<C>ֲ.}ħ ۅ'@.ۡUxf-b\JVXz+$cAfT7`lnYXP^aEK`>G;Ӫ(!c?(斟@v6}O;Aj"LpWw*/722@
zɸ VtĿj/xƹ#2=53mF8|q
}rRڒ
FJ|cXB||5dמ;?s`uRd_j'L@<fvfYX58|:&JMea21(=}ཾIo2
u-u	gx${D
J,CYK=gt6mim	;sg&-c]so!K*EA_İRP=fTW%m<(æhxހwXU{7ほE/w~\.q$p.*Mt/ÒZG㛲bT64/N?d;%h0{L}^ҩ{%/[	S
I~LrX\s^3e)|+U
dٚMH!rb\atq5kt,fI_f}j\π7	\8JռHks>?*{._3PV\&vnIS`621Fˀɳ-O
פOôc)xHQoW)7Su1V0
p/eȝ@+kb}"~Q(2mmRk-+<{D%P yt/Uey%FĻǂ>z}DedG٣0>r1mTrĒD.\S{EkRmfkVKc&SF &b3FMyT޹
d5+=^b{!?1~]<j
6h%-M;ʑ^3*͊&
eLEW'f:\DY!
\ZdHD$$H:
ԝS<	)$E8KiOz
,
m(Ux_Nw, W|[g9@ɋ8@arg[^ߝO_p3^A.Q,00pvr,&#]#;KjKhYΘJUaS+|H3dApewja:;ם*pÎ
kUN65fƴq$:mmZrtfe'3 ǭc`ha%N<Sٓ'OG)G+P	CcTv8C)	.([zgpC;;06O3fGچzKo/!x
|7ess_vku(;tS @4				{transmit data}        { Packet flag values }     data                                                                                                                                                                       i                         $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                               "            _invtimval	{ Invalid time value }e 			        else 6 		                    duration := dda$_break_duration;
 		    end;  / 	    	{ Determine the delay before the break: }uB 		if dda$_sfb_user_delay IN dda$_subfunction.assert_break_sfb then 		    beginhB 	                { Do not allow absolute times for timeout value }- 	                if dda$_break_delay > 0 thenr> 		             status := eln$_invtimval	{ Invalid time value } 	                else ( 		            delay := dda$_break_delay;	 		    ends 		else# 	    	    { Use the default delay } = 	    	    delay := break_delay[line_parameters.rx_baud_rate];e   	    end; {with}  ) 	    if (status = eln$_success) then	    e 	        begin  < 		    { Obtain exclusive write access until break is done. }0 		    lock_mutex(put_lock[circuit_struc^.line]);   		    if delay <> 0 then 			begin> 			    { Save the break duration for when the delay times out}@ 		    	    break_data[circuit_struc^.line].duration := duration;  = 	  	            { Add an entry into the timer queue for the }:  		    	    { delay specified.  }7 			    add_timer_request ( circuit_struc^.line, delay, r 				      evnt$break_delay, E 				      line_timer_struc[circuit_struc^.line].break_delay_started, = 				      request_timer);s
 		        end_
 		    else 		        begin$A 		            { There is no delay to time, so start the duration  C 		            { timer now and set the break state in the register.}e. 			    dda$_set_break ( circuit_struc^.line,		" 			    		     register_location );: 			    add_timer_request ( circuit_struc^.line, duration,  				      evnt$break_duration,H 				      line_timer_struc[circuit_struc^.line].break_duration_started,  				      request_timer);s 		        end;  ! 		end; {if status = eln$_success}    	end i     else3 	status := eln$_devnotready;    { Line is invalid }i  4     { Return the status in the same message packet }.     request_ptr^.header.dda$_status := status;   end;     e* procedure dda$_set_break ( line	: integer;/ 		           register_location : register_ptr);y { < { dda$_set_break - force a serial line to the spacing state. {a> { NOTE: put_lock mutex is assumed to be locked before entering {       this routine.  {--} var      line_ctrl_dummy   : lctrl;   begine$     disable_interrupt ( async_ipl );         { Set the line number }t/ 	write_register ( register_location^.async_csr,r 			 rx_int_ena := true,u 			 tx_int_ena := true,e 			 ind_reg_address := line );   	{ Set break bit }C 	line_ctrl_dummy := read_register(register_location^.line_control);s 	line_ctrl_dummy.break := true;nC 	write_register ( register_location^.line_control,line_ctrl_dummy);m     enable_interrupt;q  )     { Save the break state of this line } #     break_state.flag[line] := true;f   end;   r- procedure dda$_clear_break ( line  : integer;h1 		             register_location : register_ptr);g {5> { dda$_clear_break - clear the spacing state of a serial line. { > { NOTE: put_lock mutex is assumed to be locked before entering {       this routine.o {--} varl     line_ctrl_dummy   : lctrl;   beginaI     { Make sure the break state is actually set, otherwise the put_lock }      { will get out of sync: }0"     if break_state.flag[line] then 	begin% 	    disable_interrupt ( async_ipl );o 		{ Set the line number }i0 		write_register ( register_location^.async_csr, 				 rx_int_ena := true, 			     	 tx_int_ena := true,y$ 			     	 ind_reg_address := line );   		{ Clear break bit }eD 		line_ctrl_dummy := read_register(register_location^.line_control);! 		line_ctrl_dummy.break := false;sD 		write_register ( register_location^.line_control,line_ctrl_dummy); 	    enable_interrupt;  * 	    { Save the break state of this line }% 	    break_state.flag[line] := false;d  ' 	    { Release exclusive write access } " 	    unlock_mutex(put_lock[line]);  
 	end; {if} end;  5 procedure dda$tty_read( request_ptr   : ^dda$_packet;  			dda_circuit_struc : ct_ptr; 			message_size : integer; 			request_timer  : event ); {e/ { dda$tty_read - perform a DDA read on the line  {  {--} type@     bit_mask_set = packed set of 0..255; {set of oob characters}   vare6     lkahd_flag	  : boolean := true; { lookahead flag }8     status	  : integer := eln$_success; {assume success}     my_process	  : process;h   begin=  @     { Make sure there is enough buffer space in the message to }$     {  return the data to be read. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	begin  	    status := eln$_invalbufsiz;/ 	    request_ptr^.header.dda$_buffer_size := 0;[ 	end;e  #     { Only read from a valid line }h?     if not xmt_region^.line_valid[dda_circuit_struc^.line] then  	begin  	    status := eln$_devnotready;/ 	    request_ptr^.header.dda$_buffer_size := 0;e 	end;R  5     { Do not allow absolute times for timeout value }eO     if (dda$_sfb_timeout IN request_ptr^.header.dda$_subfunction.read_sfb) thens9         if request_ptr^.header.dda$_read_timeout > 0 then.
 	    begin9 	        status := eln$_invtimval;	{ Invalid time value }l3 	        request_ptr^.header.dda$_buffer_size := 0;		 	    end;r  !     if status = eln$_success theni 	begin  . 	    { Bump up process priority for the read }! 	    current_process(my_process);;5 	    set_process_priority(my_process, read_priority);=  1 	    { Obtain exclusive read access to the line }]= 	    tc$set_read_lock ( dht_struc[dda_circuit_struc^.line] );:  5 	    { Pre-set the I/O completion status to success }iC 	    dht_struc[dda_circuit_struc^.line]^.io_status := eln$_success;y  / 	    { Clear out the extended status longword }r6 	    request_ptr^.header.dda$_extended_status := zero;  3 	    { Make sure there is enough buffer space for }s9 	    { at least one character.  If not, return success. }r5 	    if request_ptr^.header.dda$_buffer_size > 0 thene  D 	    with dht_struc[dda_circuit_struc^.line]^,request_ptr^.header do
 	    begin 		io_done := false;rF 		rec_region^.line_ctx[dda_circuit_struc^.line].read_passthru := true;  = 	    	if (dda$_sfb_minimum IN dda$_subfunction.read_sfb) then; 		    begin ! 			if dda$_min_read_size = 0 then  			    begin( 				cur_read_length := dda$_buffer_size; 				max_read_size := 0;w+ 				{ Preset io_done to true, so that the }n+ 				{ read will be complete after copying }s) 				{ whatever data is currently in the }e 				{ typeahead buffers.}  				io_done := true;
 			    end 			elset 			    begin			    n* 				cur_read_length := dda$_min_read_size;& 				max_read_size := dda$_buffer_size; 			    end;r	 		    endo 		else 		    begin ' 			cur_read_length := dda$_buffer_size;h 			max_read_size := 0; -
 		    end;  ) 		{ Clear the number of characters read }a 		cur_read_count := 0;  7 		{ If there is a terminating mask, and it is 0, then }e@ 		{ just perform a normal read, as if there were no terminating} 		{ mask request. }r; 		if (dda$_sfb_term_mask IN dda$_subfunction.read_sfb) then=0 		    if dda$_term_mask::bit_mask_set <> [] then 			begin$ 		    	    read_w_term_mask := true;4 			    term_mask::dda$_break_mask := dda$_term_mask; 			end;b  , 		{ Pick up the address of the data buffer }= 		user_buffer::^anytype := address(request_ptr^.data_buffer);_  > 		{ See if there are any characters in the typeahead buffers } 		tc$process_input_characters(1 			rec_region^.line_ctx[dda_circuit_struc^.line],P& 			dht_struc[dda_circuit_struc^.line], 			lkahd_flag);u  0 		if not(io_done)   { Read is not complete yet } 		then 		    begind> 	    		if (dda$_sfb_timeout IN dda$_subfunction.read_sfb) then 		    	    begin! 				if dda$_read_timeout = 0 thent
 				    begin ( 					{ Complete the read and return as }* 					{ many characters as were available }, 					{ in the typeahead buffers, reflected } 					{ in cur_read_count. }h# 				    	io_status := eln$_timeout;  					io_done := true;a% 				        read_w_term_mask := false_ 				    end  				else
 				    beginm" 					{ Enter a timeout entry and } 					{ and continue the read. }wD 					add_timer_request ( dda_circuit_struc^.line, dda$_read_timeout, 					    evnt$io_tmo,eC 					    line_timer_struc[dda_circuit_struc^.line].io_tmo_started, e 					    request_timer); 				    end;& 		    	    end; {if (dda$_sfb_timeout}   			if not(io_done) thent 			    begin% 			        { Continue with the read }a 				read_started := true;} 				read_in_progress := true;n) 				{ Signal the main driver process to }  				{  process the read: }* 				signal(start_read^, status := status); 				wait_any(read_complete); 			    end;e	 		    endn 		else 		    beginh 		        { IO_DONE is TRUE }e; 	    		IF ((dda$_s                                                                                                                                                                                                                                                   j                        fz $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHTDRIVER.PAS;1                                                                                     i                                           fb_timeout IN dda$_subfunction.read_sfb)  # 			    AND (dda$_read_timeout = 0) _  			    AND (cur_read_count = 0) = 			    AND (dda$_sfb_minimum IN dda$_subfunction.read_sfb) ) t 			THEN_9 			    { Give errors precedence over timeout completion }i6 			    { status.  If there was an error on the first }7 			    { character read, then the cur_read_count will }  			    { be zero. }n 			    IF ODD(io_status) s 			    THEN 6 			        {Change the status from success to timeout} 				io_status := eln$_timeout;
 		    end;   		{ 5 		{ Read is complete or timed-out. Return the number r 		{  of characters read. 		{}% 		dda$_buffer_size := cur_read_count;i; 		{ If there is an error, return the associated character }i 		{  to the user: }s( 		if ( (io_status = eln$_frame_error) OR+ 		     (io_status = eln$_break_detected) ORe' 		     (io_status = eln$_parity) ) theno 		    begint4 			{ Copy the error character (string is 1-based): }E 			dda$_extended_status::dda$_extended_read_status.error_character :=_- 				substr(user_buffer^,dda$_buffer_size+1,1)e
 		    end;   	    end; {with}   	{ Return I/O status to user }R 	request_ptr^.header.dda$_status := dht_struc[dda_circuit_struc^.line]^.io_status;  . 	{ Release exclusive read access to the line }; 	tc$clear_read_lock ( dht_struc[dda_circuit_struc^.line] );   4 	{ Reset the process priority back to the default. }3 	set_process_priority(my_process, normal_priority);b  $     end  {if status <> eln$_success} else    { Return status to user }-    request_ptr^.header.dda$_status := status;m     end; { procedure }    6 procedure dda$tty_write( request_ptr   : ^dda$_packet; 			dda_circuit_struc : ct_ptr; 			message_size   : integer);  {f/ { dda$tty_write - perform a DDA write to a liner {_ {--} var	8     status	  : integer := eln$_success; {assume success}#     output_buffer : ^string(32767);      write_status  : boolean;   begin   @     { Make sure there is enough buffer space in the message to }(     {  contain the data to be written. }P     if message_size < (request_ptr^.header.dda$_buffer_size + dda$_header_size)      then 	begin  	    status := eln$_invalbufsiz;/ 	    request_ptr^.header.dda$_buffer_size := 0;e 	end;n  3     { Obtain exclusive write access for this line }e=     tc$set_write_lock ( dht_struc[dda_circuit_struc^.line] );i  !     if status = eln$_success then  	begin  + 	    { See if there is anything to write. }w  	    { If not, return success. }5 	    if request_ptr^.header.dda$_buffer_size > 0 then;  D 	    with dht_struc[dda_circuit_struc^.line]^,request_ptr^.header do 	        begin0 		    { Pick up the address of the data buffer }C 		    output_buffer::^anytype := address(request_ptr^.data_buffer);m  ; 		    write_status := put_chars ( dda_circuit_struc^.line,   		 		dda$_buffer_size,1 			 	substr(output_buffer^,1,dda$_buffer_size) );     		    if not(write_status) then  		    	begin$ 			    status := eln$_devnotready;   			    dda$_buffer_size := 0;  . 		    	end;a
 	        end;i 	end;t       { Send back status }.     request_ptr^.header.dda$_status := status;  4     { Release exclusive write access for this line }?     tc$clear_write_lock ( dht_struc[dda_circuit_struc^.line] );u   end; { procedure }    < procedure dda$tty_sgnl_oob( var request_ptr 	: ^dda$_packet; 	 		    this_line 		: integer;) 			    terminal		: terminal_data_pointer;a* 			    var line_data	: terminal_read_data;+ 			    sgnl_oob_outstanding_ptr: ^boolean);d {s3 { dda$tty_sgnl_oob - Signal out-of-band characters.b {k* { INPUTS: request_ptr - dda request packet" {	  this_line - serial line number {tF { OUTPUTS: sgnl_oob_outstanding_ptr^ -  set to true if the request for9 {	    oob signalling is successful.  Only one request fors5 {	    oob signalling can be outstanding at a time for  {	    a dda circuit. {e {--}   var_-     status	        : integer := ELN$_SUCCESS;e%     ctrl_wait_ptr       : ^ctrl_wait;r     this_process	: process; 4     this_process_ptr    : ^process;	  { Process ID }3     new_process_id      : process;	  { Process ID }g9     init_event		: ^event;	  { Event to signal after init}bB     process_Stat	: ^integer;	  { Status from create process call}     + function handler of type exception_handler;  begine status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or i     (status = ker$_no_memory)e then     status := ELN$_NORESOURC;d   goto return; end;     beging     establish(handler);   0     { Only one request per circuit is allowed: }&     if sgnl_oob_outstanding_ptr^ then + 	raise_exception(eln$_request_outstanding);   G     if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] thenl	     begin   3 	{ Create a record describing the waiting process }e 	new(ctrl_wait_ptr);  7 	{ Status and event to signal from create_process call}i 	new(process_stat);r 	new(init_event);s+ 	create_event (init_event^, event$cleared);    	new(this_process_ptr);  	current_process(this_process); # 	this_process_ptr^ := this_process;u  > 	{ Create the process to handle incoming oob char signalling }? 	create_process(new_process_id,	{returns id of created process}i5 		tc$signal_oob_chars,    {name of process to create} $ 		terminal,		{terminal data pointer}# 		line_data,		{terminal read data }f4 		this_process_ptr,	{process id of creating process}% 		ctrl_wait_ptr,		{ctrl_wait record.}d  		request_ptr,		{message packet}7 		process_stat, 		{status of initialization in process}r5 		init_event,		{event to signal after initialization}m 		sgnl_oob_outstanding_ptr);   	wait_any(init_event^);n   	if not odd(process_stat^) then_
 	    begin 	    	status := process_stat^; 	    	dispose(ctrl_wait_ptr);_ 	    end         else' 	    sgnl_oob_outstanding_ptr^ := true;g   	dispose(this_process_ptr);c 	delete(init_event^);: 	dispose(init_event);   J     end; {if request_ptr^.header.dda$_oob_characters::oob_char_set <> [] }   return:t     revert; + 	request_ptr^.header.dda$_status := status;a   end; {procedure}   e< procedure dda$tty_cncl_oob( var request_ptr 	: ^dda$_packet; 			    this_line		: integer;) 			    terminal		: terminal_data_pointer;a+ 			    sgnl_oob_outstanding_ptr: ^boolean);^ {nL { dda$tty_cncl_oob - Cancel a request for out-of-band characters signalling. { * { INPUTS: request_ptr - dda request packet# {	  this_line  - serial line numbersA { 	  sgnl_oob_outstanding_ptr^ -  true if there is an outstandings6 {	    request for oob signalling for this dda circuit. {r {--}   vare&     status  : integer := ELN$_SUCCESS;2     current_process_id : process;	  { Process ID }       + function handler of type exception_handler;r begin= status    := signal_args.name; handler := true;    if (status = ker$_no_object) or      (status = ker$_no_pool) or c     (status = ker$_no_memory)  then     status := ELN$_NORESOURC;e   goto return; end;     beginx     establish(handler);e  4     { If there is a request outstanding, cancel it }&     if sgnl_oob_outstanding_ptr^ then 
         begint) 	    current_process(current_process_id);u" 	    tc$cancel_oob_chars(terminal, 				current_process_id);( 	    sgnl_oob_outstanding_ptr^ := false;$ 	end; {if sgnl_oob_outstanding_ptr^}   return:      revert; + 	request_ptr^.header.dda$_status := status;    end; {procedure} end; {final end}                                                                                                                                                                                                                                                                                                                                * * [SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.EXE;1 +  ,    . *    /     4     *   *                     - 
    0   1    2   3      K  P   W   O *    5   6 >  7  KL  8          9          G    H  J                      0 D X     0205      (  `     N      	                                  	DHVDRIVER                              VAXELN V4.2-00 @ 05-05                      #            '   
  (     ?         !        DAP_001"      !         
LIBCOMMON_001"      !        
PASCALMSC_001!      !         DDCMP_V2_001"      !         
TERMCLASS_001                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    k                        
" $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.EXE;1                                                                                          *                         F "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          0 0:0:00.50 0:0:020 0:0:29.50 0:0:04.78              $ACCESS0 0:0:00.22       ARAI   	
  
   # ¶( a@ l@<m¶aÞ΀^V < ~LE  8E  >>>(>@>S2S@R 	xH ߭LT<~R߭ 
P  >S2S@9St~X|~|~P5S߭ 
P  PSRխRR 4STRCDSRRzRWWbD  ƨ d ƨ dƨ (ƨ ƪ ƨ C(ƨ ςWWD  ƨ d ƨ dƨ (ƨ ƪ ƨ @Wŏ  WUxWRR\PSRTRRc~Tc~\c~ETC  WHPL	  ߦl X  ~C  PX h   UUT>DtR b   xUS>CƔR b   >CƚR b   >DDR b   U ߭ X  ~B  PY i   ƌƌƌƐƄƄƄƈ|||ƀSxSRBRbbbSx t   ݦl @  RЭTTYݦl Rߦh   ݦl|~  RϝSݦl @  TXݦlR Sߦh   ݦl|~  Rݦl   @@L ( ߭   ݭ x ihx ߭  ЭWW3Sŏ  STxSRRݭRP~CDTS S1 WyTD\ fŏ  TS|~DCTA  TUCRbR
& 2xTRRݭRP~DCeT`|~DCTGA  T
WݭρTDR # 	TSC4ݢ"߭ T1 ^WV޼Y޼޼n޼Z޼[ЪR
& >ЬRТS
&RR 
 
&УԣУԣУԣУԣDHЪS
&RR 
 
&УԣУԣУԣУԣ  
 1~мR @ݢ< @  8.мR @%8 DCݢ9Dݢ<  1
ЬRТTЪTTSխ1dXխ1YTXЭRB%RUXT4T1Uc,xUQQ&PPQQ&PPTE%UT1 HcRUR0URcTRT$RQA&A%xQRRPP&PPR&TQc xYP>@ơRbMYR>BDPX
`|~   ݮjYbYR>BDPXm`  `YR>BDPX
`|~  ~~~~Yq YA.YR>BDPX`  ׭1	Ժ 
Rʏ@   RR 
1 ЪSЪSSRխ1 Xխ1 TXЭSC%WSUXT3T0Ub+xUQQ&PPQQ&PP
TE%WUT|W~jk=  QPTTQTkS QTQQEHbSUS0USbTST$SQA&A%xQSSPP&PPS&TQb UU׭1,AkRRS7 2 `, @ 8DCݣP
CݣA@kR 8|~kj<  ЪR
& n~kjY|~kj<    
1^
U޼XWńYXxt|~  ńPPYWXx1tt  1dńR ԭЭV %V;  Xx1-t  1 	 < < < < < <   Q1V;  Xx1t  1Xx
t  ЭRR>BDPX
`|~  ЭRŏ  S߭XCTݢЭRR>BDPX1h`  1Z	RB,Xx
t  ЭRLݢϛ2R:  1	RB0Xx
t  ЭTLݤ2ФS	SRXB,CeST:  1 	RB4Xx
t  ЭTФP@S hŏ  PR @BTj:   ЏSFEŏ  QTPARbR
&Pʏ   PP
&ݣ"߭ ݭ9   Xx
t  ݭ9  W1W^IR޼Sc<< c ЏQyPnn|~ Hc<<
<    PP|޼V޼TTVS޼UxSRVBdSϕ C SPUQ C S<@@PФ0RR PPf^S޼TxTRPnB R bbb
b
	b`PRD(|^<V(ЭUxURPSBcT RRd1RRdSSS C`CYRRdCNRR	d3RRd4RRd5RR 6RRd9RRdRR2RR
d
d6PRE(xUR>BƢRbTR EDď  U>ED~7  7RRddЭSTRCD<^#S޼Tм޼URTPP RReR PPRPPPPRPPRPPRPPR	PPRRPPRPQQPPRQPPR
PPPPRRTP@üP	xTP>@ÔPTQ DDŏ  TP>@D~6  
vTP@üQPPa
PPPPPPPP
PPPPPP$TP@P`||ԠTPD  	TP@,@0@4^޼[޼UWZ1X޼n1 
1 1 1( Qď  QAScPAR`b1PRxbPPP&բb֢AeRТP`RB%``
&Rȏ   RR
&cP
&RRR
&W1 X H嘭  1 HD1Wŏ  XRBeTѴ1 
1h1`1X dxRRRj eRR,ФP
&RRR
&ФP
&RRR
&*ФP
&RRR
&ФP
&RRR
&W1 ' " `ФP
&Rȏ   RR
&WФR$1
RZZZZZ1 V Rď  RBeSУQxaRR&xaPPZRRP&աa ֡УP`RVB%``
&Rȏ   RR
&Wѡ  $ a
&Rȏ   RR
&<WZ1 D Rď  RBeRТP`RB%``1
&Rȏ   RR
&W1V Rď  RBeSY 1VQQf c0УP
&RRR
&УP
&RRR
&W1.УP`RVB%``1
&Rȏ   RR
&W1Qf c0УP
&RRR
&УP
&RRR
&W1УP`RVB%``1
&Rȏ   RR
&W1УP`RVB%``1z
&Rȏ   RR
&W1_VRRbdУP
&Rȏ@   RR
&x`RRR&ՠ`֠WУP`RVB%``
&Rȏ   RR
&WYVQQ1  c0УP
&RRR
&УP
&RRR
&W1Y1УP
&Rȏ@   RR
&x`RRR&ՠ`֠WУP`RVB%``1a
&Rȏ   RR
&W1FQ1  c0УP
&RRR
&УP
&RRR
&W1
Y1УP
&Rȏ@   RR
&x`RRR&ՠ`֠WУP`RVB%``1 
&Rȏ   RR
&W1 Y1 Q 5УPx`RRR&ՠ`֠
&Rȏ@   RR
&WУP`RVB%``I
&Rȏ   RR
&W/ď  X>HDRR/  P RRPnQ 1WPЬQ ^޼W޼TU޼Vg SSPVQ C UU$^S޼T޼WXxTR
RPURe1|޼Q(TRTPaW@üD☭  D(~cPPPPPPPPnTPTRn~~~~WBüD  D(~T
TςVVdH<@@RTPP RRLLR PPD(xTP>@âRbTP@üP	
1_V12TPD  TR
	TRB0
B,T@" T@TP>@tRXb  PPD(xTP>@âRbTR DDŏ  TP>@D~-  HTP DDЬPРQaPD@%aX<@@UTPP UULLR ߭,-  }P	TPW@ TyTPD  TP@üP	%V PPD(xTP>@âRbTP@XDP |~D,  ^:S޼TPRD(P^R޼UUP>@tSX
c|~  ޼VVlV1HS޼THPPU0<@@QUPP QQL< QCPPQLPQPPE  EX|~  VS1 PP 4/޼TdSSWWEXS ߭VdS7)  WЬP`SS(  PHPPU0<@@TUPP TTLLP
LS޼VVPPT PP TLPTPPE  EX|~  PP 4WEXSݭVS)  UP>@tSXc  VPP E(/VЏTySnn|~ PP E(n|~ VP<@URммм<ռ
Ѽ   < RмԼԼ <`$                                                                                                                                                                                                                                                   l                        w $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.EXE;1                                                                                          *                          "            RѢ9xRPT BRR xRRSRSdSRdRRSSSxSSRPTRdRRSSdRRЏ PQRЬPРR)  PϞ^|)  mQVPX޼Ьnޯ]ЦTPU D(1tѮ:n6ŏ  TSRݮCTD)  P[1 PѠ2xTR BRR xTRRSRSeSReRRSSSxTSSRReRRSSeRRŏ  TRЦLԭ(ԭ߭߭߭ݠDBT	(  P[[zѦYЭYY Y}P`PѦ ЦSSWмRGSWZмZR(RjY
Џ ' 씭Џ Џ ! Џ ! |ЭP^QRS޼޼nТP]ԭ ߭ݢݮݮ@ (  PЏ PЏ ! P^QSGRУTPQ D(2xTP @ PѠԭ߭T'  Џ PЏ ! P μ^Ь < ~N'  P`ύ]`]]\]|~|~|~|~ |~|~&  PnP   &  P Q\K\&  PϞL^|&  m0X޼Z޼d޼`޼hޯ] < ~n&   x       0ZRYRw>WW  W(W@W RRRWRi(Rwc[[WW  W(WȣW RRRWR(RϺc2[oޭs xo߭   S2Spޭt p߭    ` ZJ%  xZRLBPZxZRRRP3ŏ  ZSTR>CDRߟxJ|HZRW%  d  x ߭߭ ѭ1 xZRRRP1 ~$  PVZf ߭  t|~ x߭  CZRV R߭߭  1v      V{$  1R   Vc$  1:VW$  1.R|~R x   ŏ  ZSTR>CDRϝptpR/$  1~$  PVZf ߭  w|~ ߭  G
RhV R߭߭  1      V#  1h   Vy#  1PVm#  1DP$^T޼޼޼nZ߭   ݭ x ݮ߭ nݮ4߭߭ ݮ ߭߭ ݮ @  VČWČSSWV1 Xxt|~  SR<   Ѣ@5Ѣ<+ČP UUSĄPeSZVXx
t  V1iЭ[1 [1 YXxt|~  |Q|PQPY1 |P UUY hČPРQaQXČPQP*QP РWåV ٥WSyRRWSVRǐXXRČPeRСQPea
P	Uy!  Xx
t  Y1%Xxt|~  ČSČRSRnnSR}4Xx
t  Z1Zݾ߭ 1RXxt|~  мPԼXx
t  ^LR޼nXxt|~  $nP@QaPaաСPԡաСPԡաСPԡաСPԡXx
t  |^T޼VXxt|~  мU 9 f  1	RBXx
t  1	RBXx
t  ЬR1	RBXx
t  1r	RB Xx
t  ޼S мR	RB(121,ح߭  }PмP	RVBݠX1 	RB$Xx
t  мPxRBĜR~~~b~ݠϲ ޼S 1   1 
!ح߭k  }PмP	RVBݠϲ H	RB(Xx
t  ЬRXx
t  ݼ  ^{S޼޼޼޼޼nRBüRbn^%R޼}S޼޼n߼pQyPPTQ$SP<   S< T@}S<~'  PSЮ}<Xxt|~  Q|PcQn  SXx
t   ^޼n޼SRnSRSRRP0^;V޼Z޼޼޼޼ ޼$޼(YX޼W~~Pn~~P[~~vP~~ePST1 T a 1 n	ZRB	YXX1[!	ZRBYЬRXX1Y1nYXX1y[@Bխ߭  }P	ZRݮBZYXX1.Y1%Y1T  2  
1S	YXX1Y1n1  	1 Ϥԭ߭  }P	ZRݮB(ZB
jԭ߭  }PݮB$ZYxZRBƜRbXYX1?Y16	ZRB$"xZRBƜRb|XX11 n	ZRBBYXX1 [,	ZRB!BXYXYX1 Ѯ,	ZRB!BϳXYXYXkYc	ZRB YXXPYHn*	ZRBB`B(YXXYYYY~~~~Z,,^U޼W޼n < ~  ~  PZj|~  |~߭߭߭߭@ ѭ1ZЭSS   ݭ   1KЭTϤ# ;       U o       1 xgRBPgT߭1 xgRLBPg߭B1 xgR
RRP~WT
1 xgR
RRP~WTG	wxgRnBPLWT]nSWTNSWT]AgSŏ  SRZBTCS߭gRZBR߭XЏS|~~ݭ߭` 1ݭ   ѭ||  1wѭ||  1jgSCxSR
RRPRRTS[<ߔYx[R>BŔSX
c|~  [[RBVTDx[RBXVX5VT)fRRR  YfVVXYx[R>BŔSXc   j߭   ݭݮ  Zt  ߭     WR  P^W޼Y޼Xм<~߭߭߭p  ЭZZ1ЭV( ifݼ   ЭxXR>BǚSX
c|~  XR>BDSX
c|~  ЭS xXT>DǠRb
ŏ  XRBT>DǡRb RRRR	RRRR
RRRRRRRRRRRR RRRRRRRRRR
RRXRBBBBBBXR>BDSXc  xXR>BǚSXc  ЭRЏSZ|  Z|  	Z|  ЏSЭQRЬPРТPP|  P|  	P|  ЏSlR  P^|  mU޼V޼XЏSޯ]мPѠݏS 8 мRWWSSѢ<ݏS 8 +SѢ ݏS 8 ݏS 8 xVP>@ŚRX
b|~  VP>@DRX
b|~  мSQQQPPIxVP>@ŚRXb  VP>@DRXb  ݏS 8 RRR
2RRRR BϡIxVP>@ŚRXb  VP>@DRXb  ݏS 8 PP
PRRR B+IxVP>@ŚRXb  VP>@DRXb  ݏS 8 ޼T 	dŏ  VQTP	A
ddTPAPPddPP dRRR BtPPd2PPP@uPPd2PPP@bPP	dWdTPAd!TPATPAATxVP>@ŠRbdXVv
d~~~~d~~XVVP>@DRXb  xVP>@ŚRXb  ЏS|мPЭ< ^"S޼޼T޼UH<@@RЮnn RRd eeee 	e ^V޼WЏSXxWR>BƔSX
c|~  WWRBTxWRBYTY1 < ~߭߭߭p  1 ЭPTUWQAƼR	Х(ЏSԠxWQ>AơSc >AƢSc!"#$%	&
'|~~ݭ߭` <ݭ   ѭ\|  &ФSdRRR  STXdTTYX1!xWR>BƔSXc  ^TY޼Z޼W޼nXxgR>BɔSX
c|~  ggRBUnDxgRBVUV5UT)eRRRG  XeUUVXxgR>BɔSXc  ЏS^Y޼Z޼W޼nXЏS[n1 xgR>BɔSX
c|~  ggRBUxgRBVUVUT)XeUUVXxgR>BɔSXc  Xq,~k
  PXXV((Ъ(xgR>BɔSX
c|~  xgRSBRhSxgR>BɔSXc  ЏS[ЏS[[^S޼T޼Y޼X޼W޼[޼Z޼U޼ nVn1 UUxTR>BáPU`AU`W~X~U~YTϧ >BâP`TQ DDŏ  TP>@D~  hVcxTR>BáPU`(U`TPD  TϊPPD(>BâP`TP@üP[	Z
W~X~Z~[~YTϵVVW~X~YT5^S޼T޼U޼W޼VTPD  T
	TRB0ϹB,ϯT@" T@TP>@tRXb  WVWQQVQPPD(H<@@RTPP RReAAQAVPPABBAA TP@üQPPa
PPPPPPPP
PPPPPP
^QS޼޼U޼W޼VWVWTTVTH<@@RЮnn RReATAVAA ^S޼޼U޼޼޼W޼VWVWTTVTH<@@RЮnn RReATAVA	AAA |^gS޼R޼T޼nм޼VЏSUЏmQyP|dQPP A(1  <Џ@QyP(#QyPPѢ QѢP	ЏSU}%QyPPѢ(QѢ$P	ЏSU}$
P}@7íUSxdP>@tQX
a|~  QyPPѭQѭP!dP}@c	dPV@0d*(nd%	dPV@,d	ЏSUU<^ T޼U޼SH<@@RUnn RRc                                                                                                                                                                                                                                                   m                        Q $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.EXE;1                                                                                          *                         
I      $        U@^߻R޼T޼ST@HH<@@QTPP QQc  T@TP>@tQXa  ^}X޼W޼Y޼n޼ЏS   RnRЏSԧiSPR C(ЏSԧ SyRRѧ$Sѧ RЏSԧѭS1߭   ݭ x iRBSX*ݣ&|~  iRBRЏSFԧHէ1YiRBVŏ  iSTRC` էЧԦJЧЧJЧԦJԦ- (  (
E( (N fiRŏ  RS BCT   k<SyRRѧ$Sѧ RЏSFE	iRݮB4	 iϪ Tݶ߭ ݦ"|~  /*SyRRѧ$Sѧ Rզ 
 FЏSFЦЦFRRSRS	RS
ЧRB HiRBRТFiRBSX*ݣ&  ݭ x Э|^T޼R޼V޼ЏSU   PѮP
ЏSUԢfP@o  US-ТS'fQAnS SQxP
ЏSUԢUfP@"  QRЬPРТPP|  P|  	P|  ЏSR  P$^|  m޼n޼UЏSޯ] eݏS 8 мR- ,  ,1 J~?  PX~2  PV~%  PT d X  ~  PW߭   Эg*  RUTVݼXWݮ R߭   d|~   ffX  eW  d   T  |мRЭQRЬPРТPP|  P|  	P|  ЏSUR8  P ^|)  m޼n޼RЏSޯ] b߭   ݭݮ*  b|мPЭ< ЬQ	QSQ	П PA^nPQߠ`h ЎQՎЎPQРP<2
 RxRR    RB8PРXPˏ  C`Px	PPQ 	P< ЬS 	RBSxSS~R~T~UeݬS~db   x	dP 	PPbR< ЬRЬS 	P@SxSSެUЬQ a1 	QTQePJП P ~Q~P}P~h ՎЎPРP<2
 QxQQ    QA8PРXPD`PTȏ   T ȏ   T``ЀQQ TTSbݬ  8  ݬx~ЬP 	QAPxP~                                                                                                                                                                                                                                               @   @                                                              H   P   h   `   p                                     x   `   @   P   H   (       p                     L   
                 @                                                                       DAP                                                            	LIBCOMMON                                                      	PASCALMSC                                                      DDCMP_V2                                                       	TERMCLASS                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            * * [SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1 +  ,    . z   /     4 m   z  y                   - 
    0   1    2   3      K  P   W   O z   5   6  p  7 'L  8          9          G    H  J                       $ module dhvdriver [ident('V4.2-00')];  M {****************************************************************************  {*									    *) {*  COPYRIGHT (C) 1984, 1990   					    * < {*  BY DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.			    * {* 									    * M {*  THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED AND  COPIED  * M {*  ONLY  IN  ACCORDANCE  WITH  THE  TERMS  OF  SUCH  LICENSE AND WITH THE  * M {*  INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR  ANY  OTHER  * M {*  COPIES  THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE AVAILABLE TO ANY  * M {*  OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF  THE  SOFTWARE  IS  HEREBY  *  {*  TRANSFERRED.							    * {* 									    * M {*  THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE  WITHOUT  NOTICE  * M {*  AND  SHOULD  NOT  BE  CONSTRUED  AS  A COMMITMENT BY DIGITAL EQUIPMENT  *  {*  CORPORATION.							    * {* 									    * M {*  DIGITAL ASSUMES NO RESPONSIBILITY FOR THE USE OR  RELIABILITY  OF  ITS  * B {*  SOFTWARE ON EQUIPMENT WHICH IS NOT SUPPLIED BY DIGITAL.		    * {*									    *M {****************************************************************************  {  {++  { FACILITY:  {  {	VAXELN Run-time System {  { ABSTRACT:  { 6 {	This module contains the driver for the DHV-11 async {	multiplexor device { 	 { AUTHOR:  {  {	Kris Barker 16-September-1983  { 
 { VERSION: { 	 {	V1.0-00  {  { MODIFIED BY: { ! {	V2.0-00	Gary Kimura	31-Oct-1984  {		added ddcmp support { ! {	V2.0-01	Gary Kimura	27-Nov-1984 / {		added unibus mapping for MicroVax-II support  { ! {	V2.0-02 Kris Barker	25-Mar-1985 > {		added dispose call in circuit process to dispose circuit db# {		structure when circuit is closed  { + {	V2.1-01 Eric Schott	29-July-1985	(ers008) = {		fixed unibus mapping for MicroVax-II with fortran carriage 
 {		control { - {	V2.1-02 Eric Schott	16-August-1985	(ers018) / {		Added handling of VFC record format on input  { - {	V2.1-03 Eric Schott	16-August-1985	(ers019) 2 {		Fixed open_action to set maximum_record_size to1 {		max_read_buffer_size if maximum_record_size is % {		greater than max_read_buffer_size.  { - {	V2.1-04 Eric Schott	19-August-1985	(ers022) % {		Raised max_read_buffer size to 512  { 6 {	V2.2-00 - November 18, 1985 - Eric R Schott	(ers063)3 {		Added checks for dead await_control_key circuits  { ! {	V3.0-00  Amy Kessler	4-May-1987 4 {		Modified definitions of Lctrl and Lstat to agree * {		with documentation. Modified Interface ( {		initialization and put_char function. { % {	V3.1-00	Stephen Ducharme 3-Nov-1987 9 {		Modified for increased input performance when the line   {		is set to PASSALL and NOECHO. {  {	V3.1-01 George Thissell Jr. ; {		Fixed char_length not working bug. Now can set character ) {		length from the ebuild menu correctly.  { & {	V3.1-02 Stephen Ducharme 21-Jan-19889 {		If the line is in PASSALL mode then do not signal data  {		overrun errors. {		 % {	V3.1-03 Stephen Ducharme 9-Feb-1988 = {		Correct problem where the driver would enter a dead locked 9 {		state if the input buffer overflows while a read is in  {		progress. {		  {	V3.2-00 J. McGray	4 {		- Modified modem handling routines to conform to = {		  DEC std #52.  Implemented general purpose timer process. ; {	 	- Changed the process_modem_change code to NOT read the 5 {		  lstat register to see what the modem state is.   7 {		  Instead, the input isr saves the state info in the  {		  comm region. 5 {		- Added a check in input isr to see if the data in 6 {		  the fifo is a diagnostic, or if there is an error' {		  (frame error, overrun, or parity).  {  {	V3.2-01 J. McGray	3 {		- Added DDA support for the following functions: ! {		  dda$_fnc_get_characteristics ! {		  dda$_fnc_set_characteristics  {		  dda$_fnc_sgnl_modem_events  {		  dda$_fnc_cncl_modem_events  {		 # {	V3.2-02 June 22, 1988 - J. McGray * {		Fixed DDA scope vs driver hardcopy bug. {		 A {		Removed echo and passall from the line circuit data structure, B {		and always use the line data base values of echo and passall to> {		make sure values are up-to-date (they may have been changed% {		through DDA SET_CHARACTERISTICS).   { # {	V3.2-03 June 24, 1988 - J. McGray 5 {		Fixed setting of passall and eight_bit in line_ctx 3 {		data base, from DDA set_characteristics routine.  {		 # {	V3.2-04 June 30, 1988 - J. McGray 9 {		Match up Ebuild speed values with valid driver speeds. 6 {		If invalid for this driver, keep the default speed. { " {	V3.2-05 July 1, 1988 - J. McGray8 {		Took eight_bit checking out of the ISR.  It is now in
 {		Termclass.  { " {	V3.2-06 July 7, 1988 - J. McGray- {		Changed parity_type to an enumerated type.  { # {	V3.2-07 July 13, 1988 - J. McGray # {	     -  fixed parity_type error.	  { @ {	     -	eln$ddcmp_v2_term_device_number was changed from 8 to 0. {		in DDCMP_V2, so changed code to reflect it.? {		The purpose of this change was to allow drivers with greater > {		than 8 async lines to be able to support DDCMP on ALL those= {		lines.  Previous to this version, line 8 could not be used > {		for DDCMP, because device object                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   n                        ĝ}G $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1                                                                                     m    z                        i "            8 was being used to signal4 {		received characters on regular (non-ddcmp) lines.I {      ********** ALL user-written drivers that implement DDCMP MUST make , {      ********** the following changes !!!!1 {		1) Define the new constant MAX_DEVICE_OBJECTS, 5 {		   and change the variable ASYNC_INPUT as follows: 
 { 		    CONST : {    		        max_device_objects = max_line_number + 1;  
 { 	  	    VAR B {    		    	async_input : array [0..max_device_objects] of device;	 {		   			 A {		2) In the input ISR, use device object X+1  (async_input[X+1]) 9 {		   to signal DDCMP for line X, and use device object 0 B {		   (async_input[0]) to signal input for regular terminal lines. {		   < {		3) In the call to eln$ddcmp_v2_initialize_line, associate< {		   device object X+1 for line X by changing the parameter> {                  async_input[line] to async_input[line + 1]. { # {	V3.2-08 July 17, 1988 - J. McGray : {		Handle DDA i/o and regular terminal i/o in ONE process.9 {		Take out disable/enable interrupts from around call to  {		  initialize_line.  { # {	V3.2-09 July 25, 1988 - J. McGray 2 {		Fixed bug in cntrl key processing in get_action' {		Change dda$_type_dh to dda$_type_dhv  { # {	V3.2-10 July 31, 1988 - J. McGray 9 {		Modify output ISR to keep reading the interrupts until  {		tx_ready is clear.  { ( {	V3.2-11 September 28, 1988 - J. McGray1 {		Fix placement of disable/enable_interrupts in  8 {		process_modem_change.  Do not allow lock/unlock_mutex {		at elevated IPL.  { % {	V3.2-12 October 6, 1988 - J. McGray > {	      - Fix input_isr so that DDCMP lines will process modem {		state changes. 8 {	      - Always initialize ignore_input[line] to false.> {	      - In initialize_interface, lower IPL before EXIT call. { ( {	V3.3-00 November 28, 1988 - J. McGray	2 {		- Added DDA support for the following function: {		  dda$_fnc_assert_break { ' {	V3.3-01 January 18, 1989 - J. McGray	 3 {		- Added DDA support for the following functions: : {		  dda$_fnc_read (min/max reads, timeout, and reads with: {		  a terminating mask of characters) and dda$_fnc_write. { ' {	V3.3-02 January 19, 1989 - J. McGray	 3 {		- Added support for line PASSTHRU characteristic / {		  and the READ_PASSTHRU read characteristic. 6 {		  Line PASSTHRU is now in the line parameter record# {		  that is passed in from EBUILD. ? {	    ********************************************************* ? {	    *** All user-written drivers MUST use the new definition  : {	    *** of terminal_flags for the call to TC$READ_CHARS.? {	    *********************************************************  {			< {	       - Changed handling of isr events to fix the problem5 {		 where an event could potentially get lost, due to 6 {		 multiple event(s) occurring before the main driver {		 process could unblock.@ {	    **********************************************************; {	    ***	 ALL user_written drivers must use the method of  9 {	    ***  processing isr events.  Note that EVENT is now ? {	    ***  defined differently in the TERMINAL_READ_DATA record ; {	    ***  and that CNTRL_CHAR and CNTRL_CHAR_POS no longer 2 {	    ***  exist in the TERMINAL_READ_DATA record.@ {	    ********************************************************** { $ {	V4.0-00 March 2, 1989 - J. McGray	3 {		- Added out-of-band signalling functionality for * {		  the following user-callable routines:" {			ELN$TTY_SIGNAL_OOB_CHARACTERS " {			ELN$TTY_CANCEL_OOB_CHARACTERS ! {			ELN$TTY_RECEIVE_OOB_CHARACTER 1 {	 	- Renamed EVENT (in line_Ctx) to EVENT_FLAGS.  { " {	V4.0-01 May 2, 1989 - J. McGray	7 {		  - Added support for error reporting for DDA reads. 8 {	    	    Report parity, framing, overrun, breaks, and 7 {		    overflow conditions.  Terminate the current read 7 {		    if an error occurs.  DAP reads are not affected. : {		  - Do not stuff a cntrl-z character into the typeahead4 {		    buffer when a modem line goes down IF it is a= {		    DDCMP line.  DDCMP does not use the typeahead buffers.  { # {	V4.1-00 July 6, 1989 - J. McGray	 7 {		- Take out the check for get_ctrl_key requests whose 8 {		  circuits to the application have been disconnected.> {		  It is no longer needed becuase the circuit process which : {		  is waiting for the control key to be typed now does a9 {		  WAIT_ANY on the circuit process object, rather than  @ {		  suspend itself, so that it will detect a disconnect itself.; {		  This eliminates the 20 second timer in the main driver  {		  process.	 {	******* NOTE ******** 5 {		All user-written drivers MUST take out the call to 7 {		TC$CLEANUP_CTRL_KEY, because it tries to do a RESUME 3 {		of the process that calls TC$AWAIT_CTRL_KEY, and 7 {		that code has been modified in TERMCLASS.PAS so that   {		it no longer suspends itself.2 {		User-written drivers should simply take out the1 {		timer from the main process wait_any call, and 6 {		therefore take out the call to TC$CLEANUP_CTRL_KEY.B {	    - Modify dda$tty_read and dda$tty_write to return number of ' {	      bytes transferred = 0 if error.  { # {	V4.2-00 May 22, 1990 - J. McGray	 > {	    - Put in a timer after setting MASTER_RESET to make sure/ {	      that the board finishes initializing.  * {--} *    
 include $dap;* include $termclass;* include $physical_address; include $ddcmp_v2; include $stack_utility;D include $unibus; include $mutex;R  1 include $elnmsg;	{ ELN error symbol definitions }R: include $dda_utility;   { DDA data structure definitions }' include $kernelmsg;	{ KERNEL messages }T   type?     { Record structure for queue entries for the terminal dda }R+     { function dda$_fnc_sgnl_modem_events } $     dda_signal_event_record = record6 	entryq      	: queue_entry;   { Link list structure }9 	circuit_id	: port;		 { Circuit connection to a dda port}E' 					 {   (the circuit to ttax$access)}	: 	response_port	: port; 	 { Port to send datagram of event}3 	user_data   	: integer;	 { User data - any value }N     end; { record }   @     { Terminal DDA record for miscellaneous per-line variables }      dda_line_struc_misc = recordM         dda_signal_modem_q_lock  : mutex; { Lock for accessing modem queues }EI         dda_terminal_char_lock   : mutex; { Lock for accessing terminal }* 					  { characteristics}*1 	host_sync	   : boolean;	  { Input flow control } - 	modem_control	   : dda$_modem_control_types;t) 	modem_state	   : dda$_modem_state_types;t     end; { record }h       nibble = 0..15;p     bit_storage = [bit] 0..1; "     rate_tbl_entry = packed record 	value: [byte] nibble; 	valid: [byte] boolean;: 	end;	  $     parity_tbl_entry = packed record 	value: bits$1;  	valid: [byte] boolean;  7 	end;8   vara.     { Headers of the dda signal event queues }E     dda_signal_modem_q  : array [0..max_line_number] of queue_entry; p  =     {dda_line_struc_misc record is defined in ddautil module} G     dda_line_struc : array [0..max_line_number] of dda_line_struc_misc;n  A { BREAK_DELAY is a table of fixed time intervals which represent rH { the amount of time needed to delay before setting a line to the break D { state, in order to allow any previously transmitted characters to F { complete transmission.  The time intervals are device and baud rate : { dependent, and must be set for each particular driver.   { - { Use the following formula to compute delay:0< {	Delay = (number of characters in the device's transmission< {	   holding buffer)  *  ( transmission speed per character,$ {	   assuming 12 bits per character) {	: {	Where transmission speed per character is calculated by:7 {	(number of bits per character including start, stop, e {	   and parity bits) /z2 {	   (line transmission speed in bits per second)  {hJ { The DHV type devices supported by the DHVdriver (DHQ-11, DHV-11, CXY08) = { have a 3 character output buffer, so the formula becomes:  l {	delay = 3 * (12/baud_rate) t {rF { The interval values in the BREAK_DELAY table are in negative tenths > { of microseconds; ie for 9600 the delay is .00375 seconds =  ; {       3750 microseconds = 37500 tenths of a microsecond. r {}S     break_delay : [readonly] packed array [rate_50..rate_38400] of large_integer :=l 		( -7200000, {50} 		  -4800000, {75} 		  -3272730, {110}s 		  -2676580, {134.5}	 		  -2400000, {150}3 		  -1200000, {300}- 		   -600000, {600}i 		   -300000, {1200} 		   -200000, {1800} 		   -180000, {2000} 		   -150000, {2400}( 		    -75000, {4800  (no 3600 for DHV) } 		    -50000, {7200} 		    -37500, {9600} 		    -18750, {19200}  		     -9375  {38400});   L     {Need to be able to compare dda$_terminal_speed_types and EBUILD speeds}     { to the driver speeds. }aO     { FALSE indicates this driver does not have the equivalent o                                                                                                                                                                                                                                                   o                        F $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1                                                                                     m    z                        % "            f the dda rate},_     rate_array : [readonly] packed array [dda$_rate_none..dda$_rate_38400] of rate_tbl_entry :=o 		(  (rate_none,FALSE),h 		   (rate_50,true), 		   (rate_75,true), 	 		   (rate_110,true), 	m 		   (rate_134_5,true), 	_ 		   (rate_150,true),  		   (rate_300,true),  		   (rate_600,true),  		   (rate_1200,true), c 		   (rate_1800,true), d 		   (rate_2000,true), e 		   (rate_2400,true), uM 		   (RATE_NONE,FALSE), {corresponds to DDA rate 3600, not supported by DHV }k 		   (rate_4800,true), a 		   (rate_7200,true), a 		   (rate_9600,true), C 		   (rate_19200,true),  		   (rate_38400,true) );M  b     dda_rate_array : [readonly] packed array [rate_50..rate_38400] of dda$_terminal_speed_types := 		(  dda$_rate_50, 		   dda$_rate_75, 	 		   dda$_rate_110, 	t 		   dda$_rate_134_5, 	  		   dda$_rate_150,e 		   dda$_rate_300,  		   dda$_rate_600,  		   dda$_rate_1200, 	 		   dda$_rate_1800, J 		   dda$_rate_2000, _ 		   dda$_rate_2400,  8 		   {dda$_rate_3600,}  {Driver does not have this rate} 		   dda$_rate_4800, a 		   dda$_rate_7200, e 		   dda$_rate_9600, 	 		   dda$_rate_19200,  		   dda$_rate_38400 );e  O     {Need to be able to translate dda$_parity_type to driver supported SENSE. }oP     { FALSE indicates this driver does not have the equivalent of the dda type.}i     parity_array : [readonly] packed array [dda$_parity_space..dda$_parity_ignore] of parity_tbl_entry :=	3 		(  (oddp,FALSE),   {not supported by this driver}e 		   (oddp,true),    e 		   (even,true),    	  5 		   (oddp,FALSE),   {not supported by this driver} 	 4 		   (oddp,FALSE) ); {not supported by this driver}	  /     {Translate from driver SENSE to dda values}*R     dda_parity_array : [readonly] packed array [oddp..even] of dda$_parity_type :=< 		(  {dda$_parity_space,}     {not supported by this driver} 		   dda$_parity_odd,  		   dda$_parity_even );< 		   {dda$_parity_mark,}      {not supported by this driver}< 		   {dda$_parity_ignore );}  {not supported by this driver}   consti$     { driver-specific dda constants}'     driver_class 		= dda$_class_tty;    '     device_type 		= dda$_type_dhv;	    a   type     { timing queue records }     queue_record = record  	entryq      	: queue_entry;% 	line	   	: integer;	   {line number} > 	time_at_timeout : large_integer;   {absolute time at timeout}= 	evnt		: timeout_event;   {type of timeout we are requesting}3C 	ignore_timeout  : boolean;  {true if there is not longer a  need }nA     end; { record }		    { for this timer. ie ignore the timeout}a       line_timer_state = recordiF 	sec_2_started	 : ^queue_record; {pointer to latest 2 sec timer entry}= 	sec_5_started    : ^queue_record; {latest 5 sec timer entry}_> 	sec_30_started   : ^queue_record; {latest 30 sec timer entry}> 	msec_220_started : ^queue_record; {latest 220 ms timer entry}> 	msec_500_started : ^queue_record; {latest 500 ms timer entry}@ 	sec_2_UK_started : ^queue_record; {latest 2 sec UK timer entry}C 	break_duration_started : ^queue_record; {latest break timer entry}oC 	break_delay_started    : ^queue_record; {latest break timer entry} ? 	io_tmo_started	       : ^queue_record; {latest io timer entry}z     end; { record }			       modem_state = record7 	prev_dsr          : boolean;	{previous data set ready} 7 	prev_ri           : boolean;	{previous ring indicator}r< 	prev_dcd          : boolean;	{previous data carrier detect}6 	prev_cts          : boolean;	{previous clear to send}6 	current_dsr       : boolean;	{current data set ready}6 	current_ri        : boolean;	{current ring indicator}B         current_dcd       : boolean;	{current data carrier detect}5 	current_cts       : boolean;	{current clear to send}HF 	dec52_state       : dec52_modem_state;  {current state of modem line}) 					{ with respect to DEC standard #52.}e7 	dtr_on		  : boolean;	{TRUE if the driver has set dtr }*& 					{ and rts ON (modem line only) ,}1 				        { indicating that it is waiting for }M 					{ the modem to set dsr. }6 	rts_on		  : boolean;	{TRUE if the driver has set rts} 	end; { record }  L     saved_modem_state = record   {modem state accumulated while waiting for}1 				 { 500ms timer to go off. need to ignore all}e0 				 { data and modem status changes until the }2 				 { timer goes off in order to avoid transient}( 				 { garbage from some older modems. }) 	save_dsr    : boolean;	 {data set ready}*) 	save_ri     : boolean;	 {ring indicator}t5         save_dcd    : boolean;	 {data carrier detect} ( 	save_cts    : boolean;	 {clear to send}         end; { record }M       timeout_event = (	 		{*/ 		{	The following events are used to signal thee5 		{	main process (controlling process) for a timeout.  		{} 		evnt$noevnt,			{no event}*' 		evnt$mod2sec,			{2 sec modem timeout}0' 		evnt$mod5sec,			{5 sec modem timeout}o) 		evnt$mod30sec,			{30 sec modem timeout}	( 		evnt$mod220ms,			{220ms modem timeout}( 		evnt$mod500ms,			{500ms modem timeout}, 		evnt$mod2secUK,			{2 sec UK modem timeout}( 		evnt$break_duration,		{break duration}3 		evnt$break_delay,		{delay before break assertion}8 		evnt$io_tmo			{I/O timeout}p 		{f 		{ Could add other timeouts 		{  		{} 		);       dec52_modem_state = (n 		{a4 		{	The following are the possible states of a modem+ 		{	line, with regards to dec standard #52:  		{}= 		state3a,  {idle state. dtr and rts are not set; we are not o! 			  { waiting for a connection.}a4 		state3,	  {dtr and rts are set, waiting for dsr}		5 		state5a,  {first 500ms of state 5, ignore all data}0; 		state5,	  {dsr is up, waiting for cd and cts to come up.}_. 		state6a,  {cd glitch, 2 sec timer is on.}			* 		state6,	  {normal data exchange state}		? 		state7,	  {disconnected, waiting for 220ms before dsr drops.}a> 		state7a,  {disconnected, waiting for dsr to drop, or 5 sec.}; 		state7b   {disconnected, waiting for UK timer to expire.}s7 			  {UK timer.. make sure there is at least 2 seconds}i1 			  { elapsed from DSR ON -> DTR OFF -> DTR ON }  		);       modem_change_action = (* 		{ 2 		{	The following are the possible actions to take6 		{	following a modem state change or a modem timeout: 		{}! 		ignore_change,		{ do nothing. }I5 		set_line_valid,		{ we have a connection, flag it. }M& 		drop_line,		{ disconnect the line. }0 		answer_call		{ got a ring.. answer the call. } 		);   vare=     timer_queue		: queue_entry;   {header of the timer queue}oK     timer_complete_q	: queue_entry;   {queue of completed timeout requests} @     request_queue	: queue_entry;   {header of the request queue}:     sync_lock		: mutex;	 {access lock for timing elements}  *     { Access lock for modem state table: };     modem_state_lock	: array [0..max_line_number] of mutex;   8     my_timer	  	: large_integer; {for get_time routines}B     new_timeout 	: large_integer; {absolute time of next timeout} I     line_timer_struc    : array [0..max_line_number] of line_timer_state;i=     state_array 	: array [0..max_line_number] of modem_state;tJ     modem_change_accum  : array [0..max_line_number] of saved_modem_state;   constq5     max_line_number   = 7;      	{lines are 0 thru 7}aI     max_device_objects = max_line_number + 1;  {device object 0 is used } $ 					{ for regular terminal lines. };     max_read_buffer_size = 512;		{maximum read buffer size}o&     ipl$_power = 30;			{powerfail ipl}  ?     handle_xon_xoff = false;	{TRUE if DRIVER handles xon/xoff } . 				{FALSE if DRIVER does NOT handle xon/xoff}) 				{DHV controller handles TTY_SYNC by }l, 				{ setting or clearing iauto and oauto. }2 				{ TTY_SYNC is NOT implemented in this driver }
 				{ code. }l     input_vector_number = 1;     output_vector_number = 2;d  ?     pr$_sid = %x3e;     {system identification register number}	1     microvax_1_id = 7;  {system ID of microVAX-I}   0     short_break	= -37500;    {3.75 milliseconds})     long_break	= -35000000; {3.5 seconds}$ d     {e! { Possible device characteristics  {}%     { Baud rate bit representations }      rate_none  = %b'0000';     rate_50    = %b'0000';     rate_75    = %b'0001';     rate_110   = %b'0010';     rate_134_5 = %b'0011';     rate_150   = %b'0100';     rate_300   = %b'0101';     rate_600   = %b'0110';     rate_1200  = %b'0111';     rate_1800  = %b'1000';     rate_2000  = %b'1001';     rate_2400  = %b'1010';     rate_4800  = %b'1011';     rate_7200  = %b'1100';     rate_9600  = %b'1101';     rate_19200 = %b'1110';     rate_38400 = %b'1111';       {bits per character}     char_length_5 = %b'00';      char_length_6 = %b'01';o     char_length_7 = %b'10';t     char_length_8 = %b'11';e       {number of stop bits}n     stop0 = 0;     stop1 = 1;       {parity stuff}                                                                                                                                                                                                                                                   p                        l7 $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1                                                                                     m    z                         "     -       
     oddp = 0;a
     even = 1;a       {modem indicators}     modem    = true;     no_modem = false;   $     { Default line characteristics }'     default$tty_sync            = TRUE; )     default$char_length		= char_length_8;b     default$stop_bits		= stop0;e&     default$parity_enable    	= false;     default$sense		= even;#     default$baud_rate		= rate_9600;l     default$modem		= no_modem;     default$hardcopy		= false;      default$ANSI_escape		= true;     default$echo		= true;n     default$passall		= false;H(     default$eightbit            = false;(     default$ddcmp_protocol      = false;     default$passthru		= false;   c     type       { Some useful types }t     byte    = 0..255;l     xbyte   = -128..127;     word    = 0..65535;      small_integer = 0..7;        bits$1  = 0..1;5     bits$2  = 0..3;      bits$3  = 0..7;7     bits$4  = 0..15;     bits$5  = 0..31;     bits$6  = 0..63;     bits$8  = [byte]byte;3     bits$14 = 0..16383;l  (     buffer_ptr  = ^terminal_read_buffer;3     any_pointer = ^anytype;		{a pointer to anytype}0&     char_str    = varying_string (12);%     lw_string   = varying_string (4);	       {SID register description }22     system_identification_register = packed record         hardware_rev : byte;         miccode_rev  : byte;         reserved     : byte;         id           : byte;     end;   t     {r! { Async device registers contentsI {}     { Control status register }s     csr = [word] packed record@             ind_reg_address : bits$4;	{indirect register number}>             master_reset    : [pos(5)] boolean;	{master reset}A             rx_int_ena      : boolean;	{receive interrupt enable}e?             rx_data_avail   : boolean;	{receive data available}18             tx_line	    : bits$4;	{transmit line number}3 	    tx_dma_err	    : boolean;	{transfer dma error}c0 	    diag_fail	    : boolean;  {diagnostic fail}A             tx_int_ena	    : boolean;	{transmit interrupt enable}t7             tx_ready	    : boolean;	{transmitter ready},     	  end; { record }  E { Changed the format of rxb_txc because needed to define fields for }e@ { the case where a modem status change was placed in the fifo. }  -     { Receive buffer and transmit character } "     rxb_txc = [word] packed record 	case boolean of? 	    true  : ( case0: rxb_txc_buf_0 );  {receive/transmit char}	D 	    false : ( case1: rxb_txc_buf_1 );  {modem change or diagnostic}     end;  +     {Received char or Transmit char} {V3.2}e,     rxb_txc_buf_0 = [word] packed record    = 	rx_tx_char 	  : [pos(0)] char;  {character sent or received}02 	rx_line	          : bits$4;         {line number}7 	parity_error      : [pos(12)] boolean;  {parity error}n1 	frame_error       : boolean;  	    {frame error}o3 	overrun_error     : boolean;  	    {overrun error} > 	data_valid        : boolean;  	    {receive buffer valid or }.     end;				    {  transmit character valid. }  .     {Modem status change or diagnostic} {V3.2},     rxb_txc_buf_1 = [word] packed record    7 	data_set_change : [pos(0)] boolean;  {data set change}o5 	clear_to_send   : [pos(3)] boolean;  {clear to send}o7 	carrier_detect  : [pos(4)] boolean;  {carrier detect} r6 	ring_indicator  : [pos(5)] boolean;  {ring indicator}6 	data_set_ready  : [pos(7)] boolean;  {data set ready}5 	rx_line         : bits$4;	     {receive line number}}4 	parity_error    : [pos(12)] boolean; {parity error}3 	frame_error     : [pos(13)] boolean; {frame error}i5 	overrun_error   : [pos(14)] boolean; {overrun error}h@ 	data_valid      : [pos(15)] boolean; {receive buffer valid or }/     end;				     {  transmit character valid. }p  O     modem_data = [byte] packed record   { template for modem state information}=  					{ in the typeahead buffer }7 	data_set_change : [pos(0)] boolean;  {data set change}m5 	clear_to_send   : [pos(3)] boolean;  {clear to send}n7 	carrier_detect  : [pos(4)] boolean;  {carrier detect} 36 	ring_indicator  : [pos(5)] boolean;  {ring indicator}6 	data_set_ready  : [pos(7)] boolean;  {data set ready}     end; {record}m       { Line parameter register }c       lpr = [word] packed record' 	    diag_code       : [pos(1)] bits$2;}C             char_length     : bits$2;	{character length (5-8 bits)}c6             parity_enable   : boolean;	{parity enable};             even_odd_parity : bits$1;	{parity sense select}n;             stop_code       : bits$1;	{number of stop bits} 9             rx_baud_rate    : bits$4;	{receive baud rate} :             tx_baud_rate    : bits$4;	{transmit baud rate}           end; { record }e       { Line status register }        lstat = [word] packed record0    	    clear_to_send       : [pos(11)] boolean;# 	    carrier_detect      : boolean; # 	    ring_indicator      : boolean; , 	    data_set_ready      :[pos(15)] boolean;             end; { record }n       { Line control register }e        lctrl = [word] packed record 	    tx_dma_abort : boolean; 	    iauto        : boolean;0             rx_en        : boolean;		{rx enable},             break        : boolean;		{break} 	    oauto        : boolean;$ 	    maint        : [pos(6)] bits$2; 	    link_type    : boolean;:             dtr          : boolean;		{data terminal ready}>             rts          :[pos(12)] boolean;	{request to send}           end; { record }     *     { Transmit buffer address register 2 }  #     txb_high = [word] packed record{ 	    tbuff_high   : bits$6; % 	    tx_dma_start : [pos(7)] boolean; & 	    tx_ena       : [pos(15)] boolean; 	  end; { record }  $ 	tbuffad2_byte=	[byte] packed record 		tbuff_high: bits$6;   		tx_dma_start: [pos(7)] boolean 		end;       { Register layout }n  #     async_registers = packed recorde     			async_csr	: csr;{     			rx_tx		: rxb_txc;     			line_param	: lpr; 			line_status     : lstat;i 			line_control    : lctrl;f 			txb_addr1	: [word] word;v 			txb_addr2	: txb_high;  			tx_dma_count    : [word] word     		      end; { record }   6     { Some pointers to the aforementioned structures }$     register_ptr = ^async_registers;         { Line parameters record }'     ln_param_rec = [long] packed recordaA          char_length   : char_length_5..char_length_8;	{bits 0-1}a0          stop_bits     : stop0..stop1;			{bit 2}+          parity_enable : boolean;			{bit 3}t/          sense         : oddp..even; 			{bit 4}e9          rx_baud_rate  : rate_50..rate_38400;		{bits 5-8}e:          tx_baud_rate  : rate_50..rate_38400;		{bits 9-12},          modem         : boolean;			{bit 13},          hardcopy      : boolean;			{bit 14},          ANSI_escape   : boolean;			{bit 15},          echo          : boolean;			{bit 16},          passall       : boolean;			{bit 17} 	 eightbit      : boolean;!          ddcmp_protocol: boolean;s$          passthru      : boolean;			          end; { record }  &     { Circuit process data structure }     ct_data_base = record I             line             : integer;    {line number for this circuit}n<             port             : port;       {connecting port}:             read_buffer_size : integer;    {record length}             end; { record }t     ct_ptr = ^ct_data_base;	  8     { Line configuration record sent by system builder }"     builder_params = packed record= 		dummy_word        : word;    {length of the varying string}  		line              : integer;,                 parity_enable     : boolean;/                 sense             : oddp..even;s,                 modem             : boolean;,                 hardcopy          : boolean;,                 ANSI_escape       : boolean;,                 echo              : boolean;,                 passall           : boolean;,                 ddcmp_protocol    : boolean; 		cli		  : boolean;  		passthru	  : boolean; M                 character_length  : [pos(64)] byte;  {eightbit specification} )                 stop_bits         : byte;a(                 comm_speed        : word     		end; { record }q  $     { Communications region layout }     input_region = recordr= 	line_ctx : array [0..max_line_number] of terminal_read_data;c@         ddcmp_protocol : array [0..max_line_number] of boolean; O         ddcmp_region   : array [0..max_line_number] of eln$ddcmp_v2_rec_region;y9 	ignore_input   : array [0..max_line_number] of boolean; _         end; { record }     .     output_region = [aligned(2)] packed record? 	line_char         : [aligned(2)] array [0..max_line_number] oft 								 ln_param_rec;; 	xmt_waiting       : array [0..max_line_number] of boolean;aH 	line_valid        : [aligned(2)] array [0..max_line_number] of boolean;+  	indirect_register : [aligned(2)] integer;_@         bus_adapter                                                                                                                                                                                                                                                    q                        ʖ^o $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1                                                                                     m    z                        e "     >             : boolean; { flag for unibus mapping } 	end; { record }  #     rec_region_ptr = ^input_region;e$     xmt_region_ptr = ^output_region;  6     { General purpose record type.. one bit per line }$     bit_array = [byte] packed record( 		flag : packed array [0..7] of boolean; 		end; { record }f   ;     { Stores the duration of a pending break on each line }c     line_break_data = record 		duration : large_integer;e 		end; { record }         event_record = packed record 	local_event: isr_event_flags;! 	local_nbr_modem_events: integer;   	local_modem_event_idx: integer;  	local_nbr_cntrl_chars: integer; 	local_cntrl_char_idx: integer;h     end; {record}    .   vari   {dF { Device, device records, communications region, registers, etc., etc. {};     async_input		: array [0..max_device_objects] of device; ?     async_output        : array [0..max_line_number] of device;e)     rec_region          : rec_region_ptr;0)     xmt_region          : xmt_region_ptr;0'     register_location   : register_ptr;;"     async_ipl           : integer;-     controller_name     : varying_string (8);;       { Register contents } "     async_csr : csr;			{async csr}       { Line data structures }D     dhv_struc : array [0..max_line_number] of terminal_data_pointer;     jparam   : builder_params;$     jp       : varying_string (100);       start_read : ^semaphore;2     put_lock: array [0..max_line_number] of mutex;       { Some misc. stuff }N     line_number : integer;            {current line number for initialization}P     sync_event  : event;              {event used to synchronize initialization}E     sub_process : process;	      {process ID used for line processes}l8     lines       : array [0..max_line_number] of integer;)     control_z_character : char := ''(26);s     bell : string(1) := ''(7);     line_ctrl_dummy   : lctrl;E     break_state : bit_array;  { Save the current line break states. }n@     break_data  : array [0..max_line_number] of line_break_data; t     program dhvdriver; {++e { G { This is the main driver procedure.  It creates the device, resets the < { async interface, and starts a process for each async line.B { These line processes will do the actual i/o.  This process waitsE { (via a signal) for each line process to complete its initializationmA { before starting the next process.  Once all processes have been I { started and the exec has been informed that initialization is complete,6: { this procedure performs dispatching of input characters. {l {--} varf     p_number    : integer;     line_number : integer;     i           : integer;     character   : char;y     line        : integer;     ds_change   : boolean;     qbus_adapter : ^anytype;     my_proc      : process;t     signaled_object : integer;       read_started: ^semaphore;      status: integer;     request_timer   : event;  #     timeout_occurred: ^semaphore;  ;   begin   /     eln$allocate_stack ( 2048 ); { four pages }    {o8 { Get the controller name specified by the job parameter {}.     controller_name := program_argument ( 1 );   {e { Create the async devicet {}$     create_device ( controller_name, 		    async_input,/ 		    vector_number     := input_vector_number, *     		    region            := rec_region,1     		    registers         := register_location,	)     		    priority          := async_ipl, 5     		    service_routine   := async_input_interrupt,b8                     adapter_registers := qbus_adapter );  $     create_device ( controller_name, 		    async_output, 4     		    vector_number     := output_vector_number,& 		    region            := xmt_region,. 		    powerfail_routine := powerfail_recovery,8     		    service_routine   := async_output_interrupt );   { . { Do global level initialization of the device {}  1     { Determine the existence of device mapping }   3     xmt_region^.bus_adapter := qbus_adapter <> nil;    {f' { Set the default line characteristics.c {}  $     for i := 0 to max_line_number do( 	rec_region^.ddcmp_protocol[i] := false;  .     for line_number := 0 to max_line_number do$ 	set_default_params ( line_number );   {e* { Check for user-specified line parameters {}     p_number := 2;(     jp := program_argument ( p_number );     while length(jp)<>0 do 	begin  	jparam := jp :: builder_params;' 	store_line_characteristics ( jparam );r 	p_number := p_number + 1;% 	jp := program_argument ( p_number );  	end;;   { " { Initialize the break state bits. {}     break_state::bits$8 := 0;t   {V" { Initialize the typeahead buffers {}$     for i := 0 to max_line_number do5 	tc$initialize_typhd_buffers(rec_region^.line_ctx[i],( 				    default$tty_sync,d) 				    xmt_region^.line_char[i].passall,c* 				    xmt_region^.line_char[i].eightbit,+ 				    xmt_region^.line_char[i].passthru);  {[/ { Synchronize with device during initialization D { Note that now the interrupts are enabled after processing the lineC { characteristics.  Older versions of the driver enabled interruptse1 { before the line charactersitics were processed.e {}$     disable_interrupt ( async_ipl );;     initialize_interface ( register_location, xmt_region );n     enable_interrupt;p   { " { Create the synchronization event {}/     create_event ( sync_event, event$cleared );    {y$ { Create the read started semaphore. {}     new(read_started);*     create_semaphore(read_started^, 0, 1);   {c" { Create the Put_chars write lock. {}  * for line_number := 0 to max_line_number do	     begin(% 	create_mutex(put_lock[line_number]);eF 	create_mutex ( dda_line_struc[line_number].dda_signal_modem_q_lock );F 	create_mutex ( dda_line_struc[line_number].dda_terminal_char_lock  );7         create_mutex ( modem_state_lock[line_number] );t     end;   { $ { Create the request-for-timer event {}2     create_event ( request_timer, event$cleared );   {  { Create the timeout semaphore {}!     new(timeout_occurred); 						 2     create_semaphore(timeout_occurred^, 0, 1); 			   {Start the timing queues: }i      start_queue ( timer_queue );%     start_queue ( timer_complete_q );}"     start_queue ( request_queue );  % {Start the dda signal event queues: }w* for line_number := 0 to max_line_number do4     start_queue ( dda_signal_modem_q[line_number] );  3 {Sync_lock controls access of the timing records: }t     create_mutex ( sync_lock );a  0 { Create the timing process, ONE for all lines }     clear_event ( sync_event );r!     create_process ( sub_process,  		     timer_process,  		     sync_event, 		     timeout_occurred, 		     request_timer);       { Wait for completion }n     wait_any ( sync_event );   {lI { Start a process to service DAP and DDA i/o requests for each async line  {}  #     { For each line out there ... }r.     for line_number := 0 to max_line_number do 	begin 	clear_event ( sync_event );  1         { Create a process to service this line }   "     	create_process ( sub_process,     			 line_process,u     			 line_number, 			 sync_event,  			 read_started,  		         request_timer);   	{ Wait for completion } 	wait_any ( sync_event )
 	end; { for }o   	delete (sync_event );  *     { Enable interrupts on the interface }F     write_register ( register_location^.async_csr, rx_int_ena := true, 						   tx_int_ena := true );   {x9 { Signal the exec that we're done with our initializationt {} 	initialization_done;t   { O { Bump up the process priority of the dispatcher - note: this assumes a defaultdH { process priority of 8 for the line and circuit processes and that the I { process priority of the line and circuit processes will not be below 7.e {}     current_process(my_proc);r2     set_process_priority(my_proc,read_priority-1);     {e { Perform input dispatching0 {}     while true dos
         begint  9 	wait_any ( async_input[eln$ddcmp_v2_term_device_number],  			read_started^,  		        timeout_occurred^,	  			result := signaled_object );a   	case signaled_object of 	1:t 		{d 		{ Device signalled:3  		{	Handle events for each line. 		{} 		 		begin	, 		for line_number := 0 to max_line_number do 			process_event(  					line_number,o' 					rec_region^.line_ctx[line_number],: 					dhv_struc[line_number],0 					xmt_region^.line_char[line_number].passall, 					request_timer)    		end; 	2:o 		{o 		{ Read posted:4 		{ 	A read has been started.  Check to see if there3 		{	is any characters in the buffers for this line._ 		{}   		begin , 		for line_number := 0 to max_line_number do" 			with dhv_struc[line_number]^ do 			if read_started 			then  			    begin  				tc$process_input_characters(' 					rec_region^.line_ctx[line_number],  					dhv_struc[line_number])                                                                                                                                                                                                                                                   r                        + $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1                                                                                     m    z                        1 "     O       ;pH 				if rec_region^.line_ctx[line_number].usr_ptr^.event_flags <> [] then
 				    beginl, 					{ The buffers must have been swapped. }- 					{ The USR events have to be processed. }	 					process_event(n 						line_number,( 						rec_region^.line_ctx[line_number], 						dhv_struc[line_number],p1 						xmt_region^.line_char[line_number].passall,a 						request_timer);d! 					tc$process_input_characters( ( 						rec_region^.line_ctx[line_number], 						dhv_struc[line_number]); 				    end; 				read_started := false 
 			    end 		end;   	3:  		{_1 		{ Timeout was signalled from the timer process:s 		{} 		beginn, 		    process_timeout_event (request_timer); 		end; {case = 3}t 	end; {Case}   	{; 	{	Now that we have processed each line that needed servicem: 	{	check to see if any I/O has completed for any lines. An; 	{	I/O completion is deferred until now so that all bufferst8 	{	that need swapping are processed as fast as possible. 	{}   + 	for line_number := 0 to max_line_number dob! 		with dhv_struc[line_number]^ doa! 		if io_done AND read_in_progressc 		then 			beginF 		        Cancel_timer (line_timer_struc[line_number].io_tmo_started); 			signal( read_complete,p 			        status := status);  			io_done := false; 			read_in_progress := false;a 			end;m 	end; { while }	   end. e. procedure process_event(line_number : integer;% 			var line_data: terminal_read_data;[' 			var terminal: terminal_data_pointer;  			passall: boolean; 			request_timer : event);       {++  {u# { process_event - Process ISR event  {b { Routine Description: {d; {	This procedure will process events signalled by the inputr {	ISR for each line. { 	 { Inputs:u {sA {	line_number - Line number for which events are to be processed.e' {	line_data   - Line typeahead buffers.l' {			(rec_region^.line_ctx[line_number])s( {	terminal    - Internal line data base.D {	passall	    - True if input characters should be processed without {		       intrepretation.n {e
 { Outputs:9 {	line_data   - Line typeahead buffers possibly modified.e( {	terminal    - Internal line data base. {e {--}   {l {	Local variable declarations. {}   vara 	stat: boolean;  	status: integer; ' 	i: integer;		{ General purpose index }r?         modem_status_buf    : modem_data; {modem data template}n 	control_char	    : char;_ 	first_one	    : boolean;s 	next_element	    : integer; 	found_one 	    : boolean; 	disposition	    : byte;' 	remove_from_data    : boolean := true; $ 	local_event_record  : event_record;! 	temp_ptr	    : typhd_buffer_ptr;_? 	done 	    	    : boolean := false;  { true if working on ISR }g: 			     { EVENTS and have finished processing USR EVENTS } 			     { if there were any. }   begins   { 1 {	Determine what needs to be done based on eventsl {	signalled by the isr.    {} While not(done) do begin   : { Process any events left in the USR EVENTS array first. }, if line_data.usr_ptr^.event_flags <> [] then	     begino1 	{ Copy USR event information to local storage: } . 	with local_event_record,line_data.USR_ptr^ do
 	    begin 		local_event := event_flags;u 		event_flags := []; 	l- 		local_nbr_modem_events := nbr_modem_events;c 		nbr_modem_events := 0;  + 		local_modem_event_idx := modem_event_idx;m 		modem_event_idx := 0;t  + 		local_nbr_cntrl_chars := nbr_cntrl_chars;s 		nbr_cntrl_chars := 0;i 	c) 		local_cntrl_char_idx := cntrl_char_idx;_ 		cntrl_char_idx := 0; 	    end; {with}     end  else	     beginr4 	{ Process any events left in the ISR EVENTS array }1 	{ Copy ISR event information to local storage: }i 	disable_interrupt(async_ipl);. 	with local_event_record,line_data.ISR_ptr^ do
 	    begin 		local_event := event_flags;i 		event_flags := [];  - 		local_nbr_modem_events := nbr_modem_events;a 		nbr_modem_events := 0;  + 		local_modem_event_idx := modem_event_idx;n 		modem_event_idx := 0;   + 		local_nbr_cntrl_chars := nbr_cntrl_chars;c 		nbr_cntrl_chars := 0;n  ) 		local_cntrl_char_idx := cntrl_char_idx;p 		cntrl_char_idx := 0; 	    end; {with} 	enable_interrupt; 	done := true;     end;   with local_event_record do begin   ( { See if there is an event to process: } if local_event <> [] then  begina  *     if evnt$input_xoff IN local_event then 	{/ 	{	If an XOFF event was received then handle it / 	{	ONLY if input flow control is handled by thet5 	{	driver.  This is because if the controller handlese4 	{	input flow control then the controller would have1 	{	stopped sending output to the device (also theh2 	{	write_enable event and flag does not exist; see, 	{	the procedure TC$ALLOCATE_TERMINAL_DATA). 	{}  	if terminal^.xon_xoff thent 	    with terminal^ do 		beginl  		    clear_event(write_enable); 		    write_ena_flag^ := false;o 		end;    )     if evnt$input_xon IN local_event then  	{. 	{	If an XON event was received then handle it/ 	{	ONLY if input flow control is handled by the	5 	{	driver.  This is because if the controller handles 4 	{	input flow control then the controller would have2 	{	resumed  sending output to the device (also the2 	{	write_enable event and flag does not exist; see, 	{	the procedure TC$ALLOCATE_TERMINAL_DATA). 	{}	 	if terminal^.xon_xoff 	thena 	    with terminal^ do 		begino 		    write_ena_flag^ := true; 		    if overflow_pending then 			begin& 			    stat := put_chars(line,1,bell);! 			    overflow_pending := false;  			end;_ 		    signal( write_enable); 		end;    ,     if evnt$modem_change IN local_event then
     begin        if done then! 	{ We are processing ISR events }p 	temp_ptr := line_data.ISR_ptr     else! 	{ We are processing USR events }t 	temp_ptr := line_data.USR_ptr;        with temp_ptr^ doe&     if local_nbr_modem_events > 0 then	     begin    	first_one := true;	{init}  $ 	while local_nbr_modem_events > 0 do
 	    begin  	    	found_one := false; {init}  D  	    	{ Use local_modem_event_idx as the index of the first modem }$ 	    	{  state change information: } 	    	if first_one thene 		    begin.G 	    	    	modem_status_buf := data[local_modem_event_idx]::modem_data;fC 		    	next_element := local_modem_event_idx; {NEXT_ELEMENT is the}b? 			    { element following the modem change info just removed.}	 		    	first_one := false; 		    	found_one := true;i	 		    enda
 	    	else: 		    { Search the EVENTS array for the next modem event } 		    begind< 		    	while ( (not found_one) AND (next_element < put) ) do 			    begin4 			    	if ((events[next_element].error = false) ANDC 			   	    (events[next_element].event_type = et$modem_event)) thent 		 	    	    begin/ 				    	{ Found the modem change information }n 		    		    	found_one := true;aH 	    	    	    	    	modem_status_buf := data[next_element]::modem_data; 			       	    end 			    	else
 				    begine* 				    	next_element := next_element + 1; 				    end; 			    end;e
 		    end;   	    	if found_one thenr 		    begin I 		    	{ Remove the modem status information from the typeahead buffer: }0 		    	{ *** Device IPL *** }i$ 		    	disable_interrupt(async_ipl);) 		    	    if next_element < (put-1) thenu/ 		    	    	for i := next_element to (put-2) do 	 				beginr! 			    	    data[i] := data[i+1];o% 			    	    events[i] := events[i+1];a 				end; 		    	    put := put - 1; 		    	enable_interrupt; 		    	{ *** Normal IPL *** }e  $ 		    	{ Process the modem change: }O 		    	If dda_line_struc[line_number].modem_control = dda$_modem_control_driver  		    	theno 		            begin 4 		    	    	{ Driver will process the modem change }0 				lock_mutex (modem_state_lock[line_number]); / 		    	    	process_modem_change (line_number,   						  line_data, 				 	          request_timer, 						  modem_status_buf);2 				unlock_mutex (modem_state_lock[line_number]);   G 		    	    	{ Process_modem_change will call dda$_report_modem_change }m 		            enda 	    	    	elset 		    	    beginL 		            	{ User will process the modem change - just give the status } 	e? 		    	    	{ Update the modem_state_table with the new modem }o# 		    	    	{  state information: } 0 				lock_mutex (modem_state_lock[line_number]); / 		      	    	update_modem_state ( line_number,d- 				         modem_status_buf.data_set_ready, - 				         modem_status_buf.ring_indicator,e- 				         modem_status_buf.carrier_detect,e. 				         modem_status_buf.clear_to_send );  3 		    	    	dda$_report_modem_change (line_number); 2 				unlock_mutex (modem_state_lock[line_number]);  		            end;   		    end; {if found_one}   1 	        { Decrement the count of modem events: }w> 	        local_nbr_modem_events := local_nbr_modem_events - 1; 		                                                                                                                                                                                                                                                    s                         $ $      ELN042.B                         
  *[SYSEXE.SEAS$WORK_0000005C]DHVDRIVER.PAS;1                                                                                     m    z                         "     `       	    end; {while}u)     end; {if local_nbr_modem_events > 0 }("     end; {if evnt$modem_change IN}  +     if evnt$cncl_typahd IN local_event then  	begin( 	    { Clear the user typeahead buffer }! 	    line_data.usr_ptr^.put := 0;_1 	    { Clear a possible evnt$control_char event } 6 	    local_event := local_event - [evnt$control_char]; 	end;o    ,     if evnt$control_char IN local_event then	     begins  r     if done then! 	{ We are processing ISR events }b 	temp_ptr := line_data.ISR_ptr     else! 	{ We are processing USR events }c 	temp_ptr := line_data.USR_ptr;f       with temp_ptr^ do}%     if local_nbr_cntrl_chars > 0 then 	     begin    	first_one := true;	{init}  # 	while local_nbr_cntrl_chars > 0 do	
 	    begin  	    	found_one := false; {init}  @  	        { Use local_cntrl_char_idx as the index of the first }& 	        {  control character found: } 	        if first_one then 		    beginm6 	    	    	control_char := data[local_cntrl_char_idx];B 		    	next_element := local_cntrl_char_idx; {NEXT_ELEMENT is the}? 			    { element following the control character just removed.}l 		    	first_one := false; 		    	found_one := true;d	 		    end	
 	        elsee@ 		    { Search the EVENTS array for the next control character }? 	    	    while ( (not found_one) AND (next_element < put) ) dot 			begin3 			    if ((events[next_element].error = false) AND @ 			   	(events[next_element].event_type = et$control_char)) then 		 	    	begin+ 				    { Found the next control character}c 		    		    found_one := true;/ 			    	    control_char := data[next_element];> 			        end 			    else		 				begine) 				    next_element := next_element + 1;R 				end; 			end;p   	    	if found_one thene, 	    	    { Process the control character: } 		    begin_A 		        { Bump any process waiting for the control character. }a2 		    	disposition := tc$check_oob_char( terminal, 						    line_data, 						    control_char);  ) 			{ Default to disposition = remove_it }i% 			remove_from_data := true;   {init}a   			if disposition = keep_itn 			then  				remove_from_data := falsee' 			else if not(disposition = remove_it)n 			thenr" 				if terminal^.read_in_progress  				then 					remove_from_data := false) 				else if disposition = keep_if_no_readt 				then 					remove_from_data := false;O   			If remove_from_data thenn' 			    { Remove the character from the} ( 			    {  the typeahead buffer and the } 			    {  events array:  	  		    {}{
 		    		begin_G 		    		    { Remove the control character from the typeahead buffer: }	  " 		    		    { *** Device IPL *** }% 				    disable_interrupt(async_ipl);i' 			    		if next_element < (put-1) thend4 			    	    	    for i := next_element to (put-2) do 						begini# 					    	    data[i] := data[i+1]; ' 					    	    events[i] := events[i+1]; 
 						end; 			    		put := put - 1;  			            enable_interrupt;" 		    		    { *** Normal IPL *** }. 			    	    next_element := next_element -  1;  % 			        end; {if remove_from_data}+ 		    end; {if found_one}r  + 	        next_element := next_element +  1;d4 	    	{ Decrement the count of control characters: }9 	    	local_nbr_cntrl_chars := local_nbr_cntrl_chars - 1;n 		+ 	    end; {while local_nbr_cntrl_chars > 0}o'     end; {if local_nbr_cntrl_chars > 0}b#     end; {if evnt$control_char IN }i  /     if evnt$buffer_overflow IN local_event thens 	with terminal^ do
 	    begin  / 		{	If the terminal is not in passall mode then  		{	output the bell character. 		{}  B 		if not(passall OR line_data.passthru OR line_data.read_passthru) 		then 		    {a+ 		    {	If xon and xoff support (TTSYNC) isc* 		    {	required check to see if output is 		    {	disabled.i 		    {}    		    if terminal^.xon_xoff then 			begin 			    if not(write_ena_flag^) 			    thene 				overflow_pending := true 			    else # 				stat := put_chars(line,1,bell);n 			end 			    {/ 			    {	If NO xon and xoff (TTSYNC) support isv, 			    {	required just output the bell char.	 			    {}:
 		    else" 			stat := put_chars(line,1,bell);   	    end; {with}    ,     if evnt$io_completed IN local_event then3 	{ If this line has a read in progress then processN2 	{ the data.  Otherwise, a race condition ocurred. 	{}e 	if terminal^.read_in_progress 	thene
 	    begin2 		tc$process_input_characters(line_data,terminal);. 		if line_data.usr_ptr^.event_flags <> [] then 		    begin.2 			{ USR events were cleared at the beginning of }( 			{ this routine, so if after calling }4 			{ tc$process_input_characters here it is NOT [] }/ 			{ then the buffers must have been swapped. }f- 			{ The read was not completed yet because }o5 			{ first the new USR events have to be processed. }  			process_event(_ 				line_number, 				line_data,
 				terminal,  				passall, 				request_timer);=4 			tc$process_input_characters(line_data, terminal);
 		    end;	 	    end;n       {i9     {	Ignore any other event.  The DHV-11 driver does notl!     {	recognize any other events.t     {}  	 end; {if}N' { Clear out the local event variable: }  local_event := []; end; {with}t   end; { while not() } end; v    9 procedure process_timeout_event	(request_timer : event );e   {++a {i { process_timeout_event  {o { Routine Description: {_; {	This procedure will process all timeout events signalled n {	for all lines. {i {n {--} varv     stat	: boolean;o     status	: integer;n     line_number : integer;     i		: integer;	@     ptr 	: ^queue_entry;  { pointer 