/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.openide.ErrorManager;
import org.openide.execution.ExecInfo;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.Executor;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassLoader;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.io.FoldingIOException;
import org.openide.windows.InputOutput;

public class ThreadExecutor
extends Executor {
    static final long serialVersionUID = -7160546092135474445L;
    static /* synthetic */ Class class$org$openide$execution$ThreadExecutor;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorTask execute(ExecInfo info) throws IOException {
        ExecutorTask ret;
        TERunnable run = new TERunnable(info);
        InputOutput inout = this.needsIO() ? null : InputOutput.NULL;
        TERunnable tERunnable = run;
        synchronized (tERunnable) {
            ret = ExecutionEngine.getDefault().execute(info.getClassName(), run, inout);
            run.setInputOutput(ret.getInputOutput());
            try {
                run.wait();
                Throwable t = run.getException();
                if (t != null && !(t instanceof ThreadDeath)) {
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof Error) {
                        throw (Error)t;
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    throw new FoldingIOException(t);
                }
            }
            catch (InterruptedException e) {
                throw new FoldingIOException((Throwable)e);
            }
        }
        return ret;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$execution$ThreadExecutor == null ? (class$org$openide$execution$ThreadExecutor = ThreadExecutor.class$("org.openide.execution.ThreadExecutor")) : class$org$openide$execution$ThreadExecutor);
    }

    protected void checkClass(Class clazz) throws IOException {
        Method method;
        try {
            method = clazz.getDeclaredMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ThreadExecutor.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        }
        catch (NoSuchMethodException e) {
            IOException ioe = new IOException(e.toString());
            ErrorManager.getDefault().annotate((Throwable)ioe, 256, null, NbBundle.getMessage((Class)(class$org$openide$execution$ThreadExecutor == null ? (class$org$openide$execution$ThreadExecutor = ThreadExecutor.class$("org.openide.execution.ThreadExecutor")) : class$org$openide$execution$ThreadExecutor), (String)"EXC_NoSuchMethodException"), (Throwable)e, null);
            throw ioe;
        }
        if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getReturnType() != Void.TYPE) {
            IOException ioe = new IOException("wrong signature");
            ErrorManager.getDefault().annotate((Throwable)ioe, NbBundle.getMessage((Class)(class$org$openide$execution$ThreadExecutor == null ? (class$org$openide$execution$ThreadExecutor = ThreadExecutor.class$("org.openide.execution.ThreadExecutor")) : class$org$openide$execution$ThreadExecutor), (String)"EXC_not_public_static_void"));
            throw ioe;
        }
    }

    protected void executeClass(Class clazz, String[] params) {
        try {
            Method method = clazz.getDeclaredMethod("main", params.getClass());
            method.setAccessible(true);
            method.invoke(null, new Object[]{params});
        }
        catch (InvocationTargetException ex) {
            if (!(ex.getTargetException() instanceof ThreadDeath)) {
                ex.getTargetException().printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ClassLoader createClassLoader(InputOutput io) {
        return new NbClassLoader(io);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TERunnable
    implements Runnable {
        private Throwable exception;
        private ExecInfo info;
        private InputOutput io;

        TERunnable(ExecInfo info) {
            this.info = info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String className = this.info.getClassName();
            String[] params = this.info.getArguments();
            Class<?> clazz = null;
            TERunnable tERunnable = this;
            synchronized (tERunnable) {
                try {
                    ClassLoader loader = ThreadExecutor.this.createClassLoader(this.io);
                    clazz = loader.loadClass(className);
                    if (clazz == null) {
                        throw new IOException();
                    }
                    if (clazz.getClassLoader() != loader) {
                        ErrorManager.getDefault().log(16, "The class " + clazz.getName() + " was loaded by an unexpected classloader: " + clazz.getClassLoader() + ". Usually this means you are trying to run a class from Filesystems via internal execution that is also in an enabled module JAR. The version in the JAR is being used.");
                    }
                    ThreadExecutor.this.checkClass(clazz);
                }
                catch (Exception e) {
                    this.exception = e;
                    return;
                }
                catch (LinkageError e) {
                    this.exception = e;
                    return;
                }
                finally {
                    this.notifyAll();
                }
            }
            ThreadExecutor.this.executeClass(clazz, params);
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setInputOutput(InputOutput io) {
            this.io = io;
        }
    }
}

